/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.x509store;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Primitive;
import org.jruby.ext.openssl.x509store.Purpose;
import org.jruby.ext.openssl.x509store.Trust;

public class VerifyParameter {
    public String name;
    public Date checkTime;
    public long inheritFlags;
    public long flags;
    public int purpose;
    public int trust;
    public int depth;
    List<ASN1Primitive> policies;
    private static final VerifyParameter[] defaultTable = new VerifyParameter[]{new VerifyParameter("default", 0L, 0L, 32768L, 0, 0, 100, null), new VerifyParameter("pkcs7", 0L, 0L, 0L, 4, 4, -1, null), new VerifyParameter("ssl_client", 0L, 0L, 0L, 1, 2, -1, null), new VerifyParameter("ssl_server", 0L, 0L, 0L, 2, 3, -1, null)};
    private static final List<VerifyParameter> parameterTable = new ArrayList<VerifyParameter>();

    public VerifyParameter() {
        this.zero();
    }

    public VerifyParameter(String n, long t, long i_f, long f, int p, int trs, int d, List<ASN1Primitive> pol) {
        this.name = n;
        this.checkTime = new Date(t);
        this.inheritFlags = i_f;
        this.flags = f;
        this.purpose = p;
        this.trust = trs;
        this.depth = d;
        this.policies = pol;
    }

    private void zero() {
        this.name = null;
        this.purpose = 0;
        this.trust = 0;
        this.inheritFlags = 1L;
        this.flags = 0L;
        this.depth = -1;
        this.policies = null;
    }

    public void free() {
        this.zero();
    }

    public void inherit(VerifyParameter src) {
        boolean to_o;
        if (src == null) {
            return;
        }
        long inh_flags = src.inheritFlags | this.inheritFlags;
        if ((inh_flags & 0x10L) != 0L) {
            this.inheritFlags = 0L;
        }
        if ((inh_flags & 8L) != 0L) {
            return;
        }
        boolean to_d = (inh_flags & 1L) != 0L;
        boolean bl = to_o = (inh_flags & 2L) != 0L;
        if (to_o || src.purpose != 0 && (to_d || this.purpose == 0)) {
            this.purpose = src.purpose;
        }
        if (to_o || src.trust != 0 && (to_d || this.trust == 0)) {
            this.trust = src.trust;
        }
        if (to_o || src.depth != -1 && (to_d || this.depth == -1)) {
            this.depth = src.depth;
        }
        if (to_o || (this.flags & 2L) == 0L) {
            this.checkTime = src.checkTime;
            this.flags &= 0xFFFFFFFFFFFFFFFDL;
        }
        if ((inh_flags & 4L) != 0L) {
            this.flags = 0L;
        }
        this.flags |= src.flags;
        if (to_o || src.policies != null && (to_d || this.policies == null)) {
            this.setPolicies(src.policies);
        }
    }

    void set(VerifyParameter from) {
        this.inheritFlags |= 1L;
        this.inherit(from);
    }

    public int setName(String name2) {
        this.name = name2;
        return 1;
    }

    public int setFlags(long flags) {
        this.flags |= flags;
        if ((flags & 0x780L) == 1920L) {
            this.flags |= 0x80L;
        }
        return 1;
    }

    public int clearFlags(long flags) {
        this.flags &= flags ^ 0xFFFFFFFFFFFFFFFFL;
        return 1;
    }

    public long getFlags() {
        return this.flags;
    }

    public int setPurpose(int purpose) {
        int[] arg = new int[]{this.purpose};
        int v = Purpose.set(arg, purpose);
        this.purpose = arg[0];
        return v;
    }

    public int setTrust(int trust) {
        int[] arg = new int[]{this.trust};
        int v = Trust.set(arg, trust);
        this.trust = arg[0];
        return v;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setTime(Date t) {
        this.checkTime = t;
        this.flags |= 2L;
    }

    public int addPolicy(ASN1Primitive policy) {
        if (this.policies == null) {
            this.policies = new ArrayList<ASN1Primitive>();
        }
        this.policies.add(policy);
        return 1;
    }

    public int setPolicies(List<ASN1Primitive> policies) {
        if (policies == null) {
            this.policies = null;
            return 1;
        }
        this.policies = new ArrayList<ASN1Primitive>();
        this.policies.addAll(policies);
        this.flags |= 0x80L;
        return 1;
    }

    public int getDepth() {
        return this.depth;
    }

    public int addTable() {
        Iterator<VerifyParameter> iter = parameterTable.iterator();
        while (iter.hasNext()) {
            VerifyParameter v = iter.next();
            if (!this.name.equals(v.name)) continue;
            iter.remove();
        }
        parameterTable.add(this);
        return 1;
    }

    public String toString() {
        return "VerifyParameter{name='" + this.name + '\'' + ", checkTime=" + this.checkTime + ", inheritFlags=" + this.inheritFlags + ", flags=" + this.flags + ", purpose=" + this.purpose + ", trust=" + this.trust + ", depth=" + this.depth + ", policies=" + this.policies + '}';
    }

    public static VerifyParameter lookup(String name2) {
        for (VerifyParameter v : parameterTable) {
            if (!name2.equals(v.name)) continue;
            return v;
        }
        for (VerifyParameter v : defaultTable) {
            if (!name2.equals(v.name)) continue;
            return v;
        }
        return null;
    }

    public static void tableCleanup() {
        parameterTable.clear();
    }
}

