/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util.rewriters;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectLiteral;
import org.jetbrains.kotlin.js.backend.ast.JsReturn;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.coroutine.CoroutinePassesKt;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\u00132\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u0015H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/js/inline/util/rewriters/ReturnReplacingVisitor;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "resultRef", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "breakLabel", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "isSuspend", "", "<init>", "(Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;Z)V", "visit", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsObjectLiteral;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "endVisit", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsReturn;", "getReturnReplacement", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "returnExpression", "processCoroutineResult", "expression", "js.translator"})
@SourceDebugExtension(value={"SMAP\nReturnReplacingVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReturnReplacingVisitor.kt\norg/jetbrains/kotlin/js/inline/util/rewriters/ReturnReplacingVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
public final class ReturnReplacingVisitor
extends JsVisitorWithContextImpl {
    @Nullable
    private final JsNameRef resultRef;
    @Nullable
    private final JsNameRef breakLabel;
    @NotNull
    private final JsFunction function;
    private final boolean isSuspend;

    public ReturnReplacingVisitor(@Nullable JsNameRef resultRef, @Nullable JsNameRef breakLabel, @NotNull JsFunction function2, boolean isSuspend) {
        Intrinsics.checkNotNullParameter(function2, "function");
        this.resultRef = resultRef;
        this.breakLabel = breakLabel;
        this.function = function2;
        this.isSuspend = isSuspend;
    }

    public boolean visit(@NotNull JsObjectLiteral x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        return false;
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void endVisit(@NotNull JsReturn x, @NotNull JsContext<JsNode> ctx) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        if (MetadataProperties.getReturnTarget(x) != null && !Intrinsics.areEqual(MetadataProperties.getFunctionDescriptor(this.function), MetadataProperties.getReturnTarget(x))) {
            return;
        }
        ctx.removeMe();
        JsExpression returnReplacement = this.getReturnReplacement(x.getExpression());
        if (returnReplacement != null) {
            if (returnReplacement.getSource() == null) {
                returnReplacement.setSource(x.getSource());
            }
            ctx.addNext((JsNode)new JsExpressionStatement(returnReplacement));
        }
        if (this.breakLabel != null) {
            void $this$endVisit_u24lambda_u240;
            JsBreak jsBreak;
            JsBreak jsBreak2 = jsBreak = new JsBreak(this.breakLabel);
            JsContext<JsNode> jsContext = ctx;
            boolean bl = false;
            $this$endVisit_u24lambda_u240.setSource(x.getSource());
            jsContext.addNext((JsNode)jsBreak);
        }
    }

    private final JsExpression getReturnReplacement(JsExpression returnExpression) {
        JsExpression jsExpression;
        if (returnExpression != null) {
            JsBinaryOperation assignment;
            JsBinaryOperation jsBinaryOperation;
            JsNameRef jsNameRef = this.resultRef;
            if (jsNameRef != null) {
                JsBinaryOperation jsBinaryOperation2;
                JsNameRef lhs = jsNameRef;
                boolean bl = false;
                JsExpression jsExpression2 = this.processCoroutineResult(returnExpression);
                Intrinsics.checkNotNull(jsExpression2);
                JsExpression rhs = jsExpression2;
                JsBinaryOperation $this$getReturnReplacement_u24lambda_u242_u24lambda_u241 = jsBinaryOperation2 = JsAstUtils.assignment(lhs, rhs);
                boolean bl2 = false;
                Intrinsics.checkNotNull($this$getReturnReplacement_u24lambda_u242_u24lambda_u241);
                MetadataProperties.setSynthetic($this$getReturnReplacement_u24lambda_u242_u24lambda_u241, true);
                jsBinaryOperation = jsBinaryOperation2;
            } else {
                jsBinaryOperation = null;
            }
            JsBinaryOperation jsBinaryOperation3 = assignment = jsBinaryOperation;
            jsExpression = jsBinaryOperation3 != null ? (JsExpression)jsBinaryOperation3 : this.processCoroutineResult(returnExpression);
        } else {
            jsExpression = this.processCoroutineResult(null);
        }
        return jsExpression;
    }

    private final JsExpression processCoroutineResult(JsExpression expression2) {
        JsNameRef jsNameRef;
        if (!this.isSuspend || CoroutinePassesKt.isStateMachineResult(expression2)) {
            return expression2;
        }
        JsNameRef $this$processCoroutineResult_u24lambda_u243 = jsNameRef = new JsNameRef("$$coroutineResult$$", JsAstUtils.stateMachineReceiver());
        boolean bl = false;
        MetadataProperties.setCoroutineResult($this$processCoroutineResult_u24lambda_u243, true);
        JsNameRef lhs = jsNameRef;
        JsExpression jsExpression = lhs;
        JsExpression jsExpression2 = expression2;
        if (jsExpression2 == null) {
            JsExpression jsExpression3 = Namer.getUndefinedExpression();
            jsExpression2 = jsExpression3;
            Intrinsics.checkNotNullExpressionValue(jsExpression3, "getUndefinedExpression(...)");
        }
        return JsAstUtils.assignment(jsExpression, jsExpression2);
    }
}

