# The PEP 484 type hints stub file for the krita module.
#
# Generated by SIP 6.8.6


import typing

import PyQt5.sip

from PyQt5 import QtCore
from PyQt5 import QtGui
from PyQt5 import QtXml
from PyQt5 import QtWidgets

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = typing.Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = typing.Union[typing.Callable[..., Any], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = typing.Union[typing.Sequence[int], typing.Sequence[float],
        PyQt5.sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = typing.Union[typing.Sequence[int],
        typing.Sequence[float], PyQt5.sip.Buffer, int, None]


class Shape(QtCore.QObject):

    def parentShape(self) -> typing.Optional['Shape']: ...
    def isSelected(self) -> bool: ...
    def deselect(self) -> None: ...
    def select(self) -> None: ...
    def toSvg(self, prependStyles: bool = ..., stripTextMode: bool = ...) -> str: ...
    def updateAbsolute(self, box: QtCore.QRectF) -> None: ...
    def update(self) -> None: ...
    def remove(self) -> bool: ...
    def absoluteTransformation(self) -> QtGui.QTransform: ...
    def setTransformation(self, matrix: QtGui.QTransform) -> None: ...
    def transformation(self) -> QtGui.QTransform: ...
    def setPosition(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def position(self) -> QtCore.QPointF: ...
    def boundingBox(self) -> QtCore.QRectF: ...
    def setGeometryProtected(self, protect: bool) -> None: ...
    def geometryProtected(self) -> bool: ...
    def setSelectable(self, selectable: bool) -> None: ...
    def selectable(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def visible(self) -> bool: ...
    def setZIndex(self, zindex: int) -> None: ...
    def zIndex(self) -> int: ...
    def setName(self, name: typing.Optional[str]) -> None: ...
    def name(self) -> str: ...
    def type(self) -> str: ...


class GroupShape(Shape):

    def children(self) -> typing.List[Shape]: ...


class Canvas(QtCore.QObject):

    def view(self) -> typing.Optional['View']: ...
    def levelOfDetailMode(self) -> bool: ...
    def setLevelOfDetailMode(self, enable: bool) -> None: ...
    def wrapAroundMode(self) -> bool: ...
    def setWrapAroundMode(self, enable: bool) -> None: ...
    def setMirror(self, value: bool) -> None: ...
    def mirror(self) -> bool: ...
    def setRotation(self, angle: float) -> None: ...
    def rotation(self) -> float: ...
    def resetRotation(self) -> None: ...
    def resetZoom(self) -> None: ...
    def setZoomLevel(self, value: float) -> None: ...
    def zoomLevel(self) -> float: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Channel(QtCore.QObject):

    def setPixelData(self, value: typing.Union[QtCore.QByteArray, bytes, bytearray], rect: QtCore.QRect) -> None: ...
    def pixelData(self, rect: QtCore.QRect) -> QtCore.QByteArray: ...
    def bounds(self) -> QtCore.QRect: ...
    def channelSize(self) -> int: ...
    def position(self) -> int: ...
    def name(self) -> str: ...
    def setVisible(self, value: bool) -> None: ...
    def visible(self) -> bool: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class DockWidgetFactoryBase(PyQt5.sip.wrapper):

    class DockPosition(int):
        DockTornOff = ... # type: DockWidgetFactoryBase.DockPosition
        DockTop = ... # type: DockWidgetFactoryBase.DockPosition
        DockBottom = ... # type: DockWidgetFactoryBase.DockPosition
        DockRight = ... # type: DockWidgetFactoryBase.DockPosition
        DockLeft = ... # type: DockWidgetFactoryBase.DockPosition
        DockMinimized = ... # type: DockWidgetFactoryBase.DockPosition

    @typing.overload
    def __init__(self, _id: typing.Optional[str], _dockPosition: 'DockWidgetFactoryBase.DockPosition') -> None: ...
    @typing.overload
    def __init__(self, a0: 'DockWidgetFactoryBase') -> None: ...

    def id(self) -> str: ...
    def createDockWidget(self) -> typing.Optional[QtWidgets.QDockWidget]: ...


class DockWidget(QtWidgets.QDockWidget):

    def __init__(self) -> None: ...

    def canvasChanged(self, canvas: typing.Optional[Canvas]) -> None: ...
    def canvas(self) -> typing.Optional[Canvas]: ...


class Document(QtCore.QObject):

    def removeAnnotation(self, type: typing.Optional[str]) -> None: ...
    def setAnnotation(self, type: typing.Optional[str], description: typing.Optional[str], annotation: typing.Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def annotation(self, type: typing.Optional[str]) -> QtCore.QByteArray: ...
    def annotationDescription(self, type: typing.Optional[str]) -> str: ...
    def annotationTypes(self) -> typing.List[str]: ...
    def setCurrentTime(self, time: int) -> None: ...
    def currentTime(self) -> int: ...
    def playBackEndTime(self) -> int: ...
    def playBackStartTime(self) -> int: ...
    def setPlayBackRange(self, start: int, stop: int) -> None: ...
    def animationLength(self) -> int: ...
    def fullClipRangeEndTime(self) -> int: ...
    def setFullClipRangeEndTime(self, endTime: int) -> None: ...
    def fullClipRangeStartTime(self) -> int: ...
    def setFullClipRangeStartTime(self, startTime: int) -> None: ...
    def setFramesPerSecond(self, fps: int) -> None: ...
    def framesPerSecond(self) -> int: ...
    def importAnimation(self, files: typing.Iterable[typing.Optional[str]], firstFrame: int, step: int) -> bool: ...
    def bounds(self) -> QtCore.QRect: ...
    def setModified(self, modified: bool) -> None: ...
    def modified(self) -> bool: ...
    def setGuidesLocked(self, locked: bool) -> None: ...
    def setGuidesVisible(self, visible: bool) -> None: ...
    def setVerticalGuides(self, lines: typing.Iterable[float]) -> None: ...
    def setHorizontalGuides(self, lines: typing.Iterable[float]) -> None: ...
    def refreshProjection(self) -> None: ...
    def tryBarrierLock(self) -> bool: ...
    def waitForDone(self) -> None: ...
    def unlock(self) -> None: ...
    def lock(self) -> None: ...
    def thumbnail(self, w: int, h: int) -> QtGui.QImage: ...
    def projection(self, x: int = ..., y: int = ..., w: int = ..., h: int = ...) -> QtGui.QImage: ...
    def createColorizeMask(self, name: typing.Optional[str]) -> typing.Optional['ColorizeMask']: ...
    def createTransformMask(self, name: typing.Optional[str]) -> typing.Optional['TransformMask']: ...
    def createTransparencyMask(self, name: typing.Optional[str]) -> typing.Optional['TransparencyMask']: ...
    def createSelectionMask(self, name: typing.Optional[str]) -> typing.Optional['SelectionMask']: ...
    @typing.overload
    def createFilterMask(self, name: typing.Optional[str], filter: 'Filter', selection: 'Selection') -> typing.Optional['FilterMask']: ...
    @typing.overload
    def createFilterMask(self, name: typing.Optional[str], filter: 'Filter', selection_source: typing.Optional['Node']) -> typing.Optional['FilterMask']: ...
    def createFileLayer(self, name: typing.Optional[str], fileName: typing.Optional[str], scalingMethod: typing.Optional[str], scalingFilter: typing.Optional[str] = ...) -> typing.Optional['FileLayer']: ...
    def createVectorLayer(self, name: typing.Optional[str]) -> typing.Optional['VectorLayer']: ...
    def createFillLayer(self, name: typing.Optional[str], filterName: typing.Optional[str], configuration: 'InfoObject', selection: 'Selection') -> typing.Optional['FillLayer']: ...
    def createFilterLayer(self, name: typing.Optional[str], filter: 'Filter', selection: 'Selection') -> typing.Optional['FilterLayer']: ...
    def createCloneLayer(self, name: typing.Optional[str], source: typing.Optional['Node']) -> typing.Optional['CloneLayer']: ...
    def createGroupLayer(self, name: typing.Optional[str]) -> typing.Optional['GroupLayer']: ...
    def createNode(self, name: typing.Optional[str], nodeType: typing.Optional[str]) -> typing.Optional['Node']: ...
    def saveAs(self, filename: typing.Optional[str]) -> bool: ...
    def save(self) -> bool: ...
    def shearImage(self, angleX: float, angleY: float) -> None: ...
    def rotateImage(self, radians: float) -> None: ...
    def scaleImage(self, w: int, h: int, xres: int, yres: int, strategy: typing.Optional[str]) -> None: ...
    def resizeImage(self, x: int, y: int, w: int, h: int) -> None: ...
    def flatten(self) -> None: ...
    def exportImage(self, filename: typing.Optional[str], exportConfiguration: 'InfoObject') -> bool: ...
    def crop(self, x: int, y: int, w: int, h: int) -> None: ...
    def close(self) -> bool: ...
    def pixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def setYRes(self, yRes: float) -> None: ...
    def yRes(self) -> float: ...
    def setXRes(self, xRes: float) -> None: ...
    def xRes(self) -> float: ...
    def setYOffset(self, y: int) -> None: ...
    def yOffset(self) -> int: ...
    def setXOffset(self, x: int) -> None: ...
    def xOffset(self) -> int: ...
    def setWidth(self, value: int) -> None: ...
    def width(self) -> int: ...
    def setSelection(self, value: typing.Optional['Selection']) -> None: ...
    def selection(self) -> typing.Optional['Selection']: ...
    def rootNode(self) -> typing.Optional['Node']: ...
    def setResolution(self, value: int) -> None: ...
    def resolution(self) -> int: ...
    def setName(self, value: typing.Optional[str]) -> None: ...
    def name(self) -> str: ...
    def setHeight(self, value: int) -> None: ...
    def height(self) -> int: ...
    def setFileName(self, value: typing.Optional[str]) -> None: ...
    def fileName(self) -> str: ...
    def setDocumentInfo(self, document: typing.Optional[str]) -> None: ...
    def documentInfo(self) -> str: ...
    def setBackgroundColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> bool: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setColorSpace(self, value: typing.Optional[str], colorDepth: typing.Optional[str], colorProfile: typing.Optional[str]) -> bool: ...
    def setColorProfile(self, colorProfile: typing.Optional[str]) -> bool: ...
    def colorProfile(self) -> str: ...
    def colorModel(self) -> str: ...
    def colorDepth(self) -> str: ...
    def setBatchmode(self, value: bool) -> None: ...
    def batchmode(self) -> bool: ...
    def nodeByUniqueID(self, id: QtCore.QUuid) -> typing.Optional['Node']: ...
    def nodeByName(self, node: typing.Optional[str]) -> typing.Optional['Node']: ...
    def topLevelNodes(self) -> typing.List['Node']: ...
    def setActiveNode(self, value: typing.Optional['Node']) -> None: ...
    def activeNode(self) -> typing.Optional['Node']: ...
    def clone(self) -> typing.Optional['Document']: ...
    def guidesLocked(self) -> bool: ...
    def guidesVisible(self) -> bool: ...
    def verticalGuides(self) -> typing.List[float]: ...
    def horizontalGuides(self) -> typing.List[float]: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Filter(QtCore.QObject):

    def __init__(self) -> None: ...

    def startFilter(self, node: typing.Optional['Node'], x: int, y: int, w: int, h: int) -> bool: ...
    def apply(self, node: typing.Optional['Node'], x: int, y: int, w: int, h: int) -> None: ...
    def setConfiguration(self, value: typing.Optional['InfoObject']) -> None: ...
    def configuration(self) -> typing.Optional['InfoObject']: ...
    def setName(self, a0: typing.Optional[str]) -> None: ...
    def name(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class InfoObject(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def property(self, key: typing.Optional[str]) -> typing.Any: ...
    def setProperty(self, key: typing.Optional[str], value: typing.Any) -> None: ...
    def setProperties(self, value: typing.Dict[typing.Optional[str], typing.Any]) -> None: ...
    def properties(self) -> typing.Dict[str, typing.Any]: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Extension(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def createActions(self, window: typing.Optional['Window']) -> None: ...
    def setup(self) -> None: ...


class View(QtCore.QObject):

    def flakeToImageTransform(self) -> QtGui.QTransform: ...
    def flakeToCanvasTransform(self) -> QtGui.QTransform: ...
    def flakeToDocumentTransform(self) -> QtGui.QTransform: ...
    def selectedNodes(self) -> typing.List['Node']: ...
    def showFloatingMessage(self, message: typing.Optional[str], icon: QtGui.QIcon, timeout: int, priority: int) -> None: ...
    def setPaintingFlow(self, flow: float) -> None: ...
    def paintingFlow(self) -> float: ...
    def setBrushRotation(self, brushRotation: float) -> None: ...
    def brushRotation(self) -> float: ...
    def setBrushSize(self, brushSize: float) -> None: ...
    def brushSize(self) -> float: ...
    def setPaintingOpacity(self, opacity: float) -> None: ...
    def paintingOpacity(self) -> float: ...
    def setHDRGamma(self, gamma: float) -> None: ...
    def HDRGamma(self) -> float: ...
    def setHDRExposure(self, exposure: float) -> None: ...
    def HDRExposure(self) -> float: ...
    def setCurrentBlendingMode(self, blendingMode: typing.Optional[str]) -> None: ...
    def currentBlendingMode(self) -> str: ...
    def setCurrentGradient(self, resource: typing.Optional['Resource']) -> None: ...
    def currentGradient(self) -> typing.Optional['Resource']: ...
    def setCurrentPattern(self, resource: typing.Optional['Resource']) -> None: ...
    def currentPattern(self) -> typing.Optional['Resource']: ...
    def setCurrentBrushPreset(self, resource: typing.Optional['Resource']) -> None: ...
    def currentBrushPreset(self) -> typing.Optional['Resource']: ...
    def setBackGroundColor(self, color: typing.Optional['ManagedColor']) -> None: ...
    def backgroundColor(self) -> typing.Optional['ManagedColor']: ...
    def setForeGroundColor(self, color: typing.Optional['ManagedColor']) -> None: ...
    def foregroundColor(self) -> typing.Optional['ManagedColor']: ...
    def activateResource(self, resource: typing.Optional['Resource']) -> None: ...
    def canvas(self) -> typing.Optional[Canvas]: ...
    def setVisible(self) -> None: ...
    def visible(self) -> bool: ...
    def setDocument(self, document: typing.Optional[Document]) -> None: ...
    def document(self) -> typing.Optional[Document]: ...
    def window(self) -> typing.Optional['Window']: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Window(QtCore.QObject):

    activeViewChanged: typing.ClassVar[QtCore.pyqtSignal]
    themeChanged: typing.ClassVar[QtCore.pyqtSignal]
    windowClosed: typing.ClassVar[QtCore.pyqtSignal]
    def createAction(self, id: typing.Optional[str], text: typing.Optional[str] = ..., menuLocation: typing.Optional[str] = ...) -> typing.Optional[QtWidgets.QAction]: ...
    def close(self) -> None: ...
    def activate(self) -> None: ...
    def activeView(self) -> typing.Optional[View]: ...
    def showView(self, view: typing.Optional[View]) -> None: ...
    def addView(self, document: typing.Optional[Document]) -> typing.Optional[View]: ...
    def views(self) -> typing.List[View]: ...
    def dockers(self) -> typing.List[QtWidgets.QDockWidget]: ...
    def qwindow(self) -> typing.Optional[QtWidgets.QMainWindow]: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Krita(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    @staticmethod
    def getAppDataLocation() -> str: ...
    @staticmethod
    def krita_i18nc(context: typing.Optional[str], text: typing.Optional[str]) -> str: ...
    @staticmethod
    def krita_i18n(text: typing.Optional[str]) -> str: ...
    @staticmethod
    def fromVariant(v: typing.Any) -> typing.Optional[QtCore.QObject]: ...
    @staticmethod
    def instance() -> typing.Optional['Krita']: ...
    def readSetting(self, group: typing.Optional[str], name: typing.Optional[str], defaultValue: typing.Optional[str]) -> str: ...
    def writeSetting(self, group: typing.Optional[str], name: typing.Optional[str], value: typing.Optional[str]) -> None: ...
    def addDockWidgetFactory(self, _factory: typing.Optional[DockWidgetFactoryBase]) -> None: ...
    def addExtension(self, _extension: typing.Optional[Extension]) -> None: ...
    def icon(self, iconName: typing.Optional[str]) -> QtGui.QIcon: ...
    def openWindow(self) -> typing.Optional[Window]: ...
    def openDocument(self, filename: typing.Optional[str]) -> typing.Optional[Document]: ...
    def extensions(self) -> typing.List[Extension]: ...
    def createDocument(self, width: int, height: int, name: typing.Optional[str], colorModel: typing.Optional[str], colorDepth: typing.Optional[str], profile: typing.Optional[str], resolution: float) -> typing.Optional[Document]: ...
    def recentDocuments(self) -> typing.List[str]: ...
    def resources(self, type: typing.Optional[str]) -> typing.Any: ...
    def windows(self) -> typing.List[Window]: ...
    def activeWindow(self) -> typing.Optional[Window]: ...
    def views(self) -> typing.List[View]: ...
    def version(self) -> str: ...
    def notifier(self) -> typing.Optional['Notifier']: ...
    def addProfile(self, profilePath: typing.Optional[str]) -> bool: ...
    def profiles(self, colorModel: typing.Optional[str], ColorDepth: typing.Optional[str]) -> typing.List[str]: ...
    def filterStrategies(self) -> typing.List[str]: ...
    def colorDepths(self, colorModel: typing.Optional[str]) -> typing.List[str]: ...
    def colorModels(self) -> typing.List[str]: ...
    def filter(self, name: typing.Optional[str]) -> typing.Optional[Filter]: ...
    def filters(self) -> typing.List[str]: ...
    def dockers(self) -> typing.List[QtWidgets.QDockWidget]: ...
    def documents(self) -> typing.List[Document]: ...
    def action(self, name: typing.Optional[str]) -> typing.Optional[QtWidgets.QAction]: ...
    def actions(self) -> typing.List[QtWidgets.QAction]: ...
    def setBatchmode(self, value: bool) -> None: ...
    def batchmode(self) -> bool: ...
    def setActiveDocument(self, value: typing.Optional[Document]) -> None: ...
    def activeDocument(self) -> typing.Optional[Document]: ...


class Node(QtCore.QObject):

    def uniqueId(self) -> QtCore.QUuid: ...
    def index(self) -> int: ...
    def setLayerStyleFromAsl(self, asl: typing.Optional[str]) -> None: ...
    def layerStyleToAsl(self) -> str: ...
    def thumbnail(self, w: int, h: int) -> QtGui.QImage: ...
    def shearNode(self, angleX: float, angleY: float) -> None: ...
    def cropNode(self, x: int, y: int, w: int, h: int) -> None: ...
    def rotateNode(self, radians: float) -> None: ...
    def scaleNode(self, origin: typing.Union[QtCore.QPointF, QtCore.QPoint], width: int, height: int, strategy: typing.Optional[str]) -> None: ...
    def mergeDown(self) -> typing.Optional['Node']: ...
    def save(self, filename: typing.Optional[str], xRes: float, yRes: float, exportConfiguration: InfoObject, exportRect: QtCore.QRect = ...) -> None: ...
    def duplicate(self) -> typing.Optional['Node']: ...
    def remove(self) -> bool: ...
    def position(self) -> QtCore.QPoint: ...
    def move(self, x: int, y: int) -> None: ...
    def bounds(self) -> QtCore.QRect: ...
    def setPixelData(self, value: typing.Union[QtCore.QByteArray, bytes, bytearray], x: int, y: int, w: int, h: int) -> None: ...
    def projectionPixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def pixelDataAtTime(self, x: int, y: int, w: int, h: int, time: int) -> QtCore.QByteArray: ...
    def pixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def setVisible(self, value: bool) -> None: ...
    def hasKeyframeAtTime(self, frameNumber: int) -> bool: ...
    def visible(self) -> bool: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> str: ...
    def parentNode(self) -> typing.Optional['Node']: ...
    def setOpacity(self, value: int) -> None: ...
    def opacity(self) -> int: ...
    def setName(self, value: typing.Optional[str]) -> None: ...
    def name(self) -> str: ...
    def hasExtents(self) -> bool: ...
    def setLocked(self, value: bool) -> None: ...
    def locked(self) -> bool: ...
    def setInheritAlpha(self, value: bool) -> None: ...
    def inheritAlpha(self) -> bool: ...
    def setColorSpace(self, colorModel: typing.Optional[str], colorDepth: typing.Optional[str], colorProfile: typing.Optional[str]) -> bool: ...
    def setColorProfile(self, colorProfile: typing.Optional[str]) -> bool: ...
    def colorProfile(self) -> str: ...
    def colorModel(self) -> str: ...
    def setColorLabel(self, value: int) -> None: ...
    def colorLabel(self) -> int: ...
    def collapsed(self) -> bool: ...
    def setCollapsed(self, collapsed: bool) -> None: ...
    def enableAnimation(self) -> None: ...
    def animated(self) -> bool: ...
    def colorDepth(self) -> str: ...
    def setChildNodes(self, nodes: typing.Iterable['Node']) -> None: ...
    def removeChildNode(self, child: typing.Optional['Node']) -> bool: ...
    def addChildNode(self, child: typing.Optional['Node'], above: typing.Optional['Node']) -> bool: ...
    def findChildNodes(self, name: typing.Optional[str] = ..., recursive: bool = ..., partialMatch: bool = ..., type: typing.Optional[str] = ..., colorLabelIndex: int = ...) -> typing.List['Node']: ...
    def childNodes(self) -> typing.List['Node']: ...
    def channels(self) -> typing.List[Channel]: ...
    def setBlendingMode(self, value: typing.Optional[str]) -> None: ...
    def blendingMode(self) -> str: ...
    def setAlphaLocked(self, value: bool) -> None: ...
    def alphaLocked(self) -> bool: ...
    def clone(self) -> typing.Optional['Node']: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class GroupLayer(Node):

    def passThroughMode(self) -> bool: ...
    def setPassThroughMode(self, passthrough: bool) -> None: ...
    def type(self) -> str: ...


class CloneLayer(Node):

    def setSourceNode(self, node: typing.Optional[Node]) -> None: ...
    def sourceNode(self) -> typing.Optional[Node]: ...
    def type(self) -> str: ...


class FilterLayer(Node):

    def filter(self) -> typing.Optional[Filter]: ...
    def setFilter(self, filter: Filter) -> None: ...
    def type(self) -> str: ...


class FileLayer(Node):

    def path(self) -> str: ...
    def scalingFilter(self) -> str: ...
    def scalingMethod(self) -> str: ...
    def resetCache(self) -> None: ...
    def setProperties(self, FileName: typing.Optional[str], ScalingMethod: typing.Optional[str], scalingFilter: typing.Optional[str]) -> None: ...
    def type(self) -> str: ...


class FillLayer(Node):

    def filterConfig(self) -> typing.Optional[InfoObject]: ...
    def generatorName(self) -> str: ...
    def setGenerator(self, filterName: typing.Optional[str], filterConfig: typing.Optional[InfoObject]) -> bool: ...
    def type(self) -> str: ...


class VectorLayer(Node):

    def createGroupShape(self, name: typing.Optional[str], shapes: typing.Iterable[Shape]) -> typing.Optional[Shape]: ...
    def shapesInRect(self, rect: QtCore.QRectF, omitHiddenShapes: bool = ..., containedMode: bool = ...) -> typing.List[Shape]: ...
    def shapeAtPosition(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> typing.Optional[Shape]: ...
    def addShapesFromSvg(self, svg: typing.Optional[str]) -> typing.List[Shape]: ...
    def toSvg(self) -> str: ...
    def shapes(self) -> typing.List[Shape]: ...
    def type(self) -> str: ...


class FilterMask(Node):

    def filter(self) -> typing.Optional[Filter]: ...
    def setFilter(self, filter: Filter) -> None: ...
    def type(self) -> str: ...


class SelectionMask(Node):

    def setSelection(self, selection: typing.Optional['Selection']) -> None: ...
    def selection(self) -> typing.Optional['Selection']: ...
    def type(self) -> str: ...


class TransparencyMask(Node):

    def setSelection(self, selection: typing.Optional['Selection']) -> None: ...
    def selection(self) -> typing.Optional['Selection']: ...
    def type(self) -> str: ...


class TransformMask(Node):

    def fromXML(self, xml: typing.Optional[str]) -> bool: ...
    def toXML(self) -> str: ...
    def finalAffineTransform(self) -> QtGui.QTransform: ...
    def type(self) -> str: ...


class ColorizeMask(Node):

    def setEditKeyStrokes(self, enabled: bool) -> None: ...
    def editKeyStrokes(self) -> bool: ...
    def setShowOutput(self, enabled: bool) -> None: ...
    def showOutput(self) -> bool: ...
    def resetCache(self) -> None: ...
    def updateMask(self, force: bool = ...) -> None: ...
    def limitToDeviceBounds(self) -> bool: ...
    def setLimitToDeviceBounds(self, value: bool) -> None: ...
    def cleanUpAmount(self) -> float: ...
    def setCleanUpAmount(self, value: float) -> None: ...
    def edgeDetectionSize(self) -> float: ...
    def setEdgeDetectionSize(self, value: float) -> None: ...
    def useEdgeDetection(self) -> bool: ...
    def setUseEdgeDetection(self, value: bool) -> None: ...
    def setKeyStrokePixelData(self, value: typing.Union[QtCore.QByteArray, bytes, bytearray], color: typing.Optional['ManagedColor'], x: int, y: int, w: int, h: int) -> bool: ...
    def keyStrokePixelData(self, color: typing.Optional['ManagedColor'], x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def transparencyIndex(self) -> int: ...
    def removeKeyStroke(self, color: typing.Optional['ManagedColor']) -> None: ...
    def initializeKeyStrokeColors(self, colors: typing.Iterable['ManagedColor'], transparentIndex: int = ...) -> None: ...
    def keyStrokesColors(self) -> typing.List['ManagedColor']: ...
    def type(self) -> str: ...


class Notifier(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    configurationChanged: typing.ClassVar[QtCore.pyqtSignal]
    windowCreated: typing.ClassVar[QtCore.pyqtSignal]
    windowIsBeingCreated: typing.ClassVar[QtCore.pyqtSignal]
    viewClosed: typing.ClassVar[QtCore.pyqtSignal]
    viewCreated: typing.ClassVar[QtCore.pyqtSignal]
    imageClosed: typing.ClassVar[QtCore.pyqtSignal]
    imageSaved: typing.ClassVar[QtCore.pyqtSignal]
    imageCreated: typing.ClassVar[QtCore.pyqtSignal]
    applicationClosing: typing.ClassVar[QtCore.pyqtSignal]
    def setActive(self, value: bool) -> None: ...
    def active(self) -> bool: ...


class Resource(QtCore.QObject):

    def setImage(self, image: QtGui.QImage) -> None: ...
    def image(self) -> QtGui.QImage: ...
    def filename(self) -> str: ...
    def setName(self, value: typing.Optional[str]) -> None: ...
    def name(self) -> str: ...
    def type(self) -> str: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Selection(QtCore.QObject):

    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def setPixelData(self, value: typing.Union[QtCore.QByteArray, bytes, bytearray], x: int, y: int, w: int, h: int) -> None: ...
    def pixelData(self, x: int, y: int, w: int, h: int) -> QtCore.QByteArray: ...
    def symmetricdifference(self, selection: typing.Optional['Selection']) -> None: ...
    def intersect(self, selection: typing.Optional['Selection']) -> None: ...
    def subtract(self, selection: typing.Optional['Selection']) -> None: ...
    def add(self, selection: typing.Optional['Selection']) -> None: ...
    def replace(self, selection: typing.Optional['Selection']) -> None: ...
    def selectAll(self, node: typing.Optional[Node], value: int) -> None: ...
    def select(self, x: int, y: int, w: int, h: int, value: int) -> None: ...
    def resize(self, w: int, h: int) -> None: ...
    def invert(self) -> None: ...
    def smooth(self) -> None: ...
    def shrink(self, xRadius: int, yRadius: int, edgeLock: bool) -> None: ...
    def grow(self, xradius: int, yradius: int) -> None: ...
    def feather(self, radius: int) -> None: ...
    def border(self, xRadius: int, yRadius: int) -> None: ...
    def dilate(self) -> None: ...
    def erode(self) -> None: ...
    def paste(self, destination: typing.Optional[Node], x: int, y: int) -> None: ...
    def cut(self, node: typing.Optional[Node]) -> None: ...
    def copy(self, node: typing.Optional[Node]) -> None: ...
    def contract(self, value: int) -> None: ...
    def clear(self) -> None: ...
    def move(self, x: int, y: int) -> None: ...
    def y(self) -> int: ...
    def x(self) -> int: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def duplicate(self) -> typing.Optional['Selection']: ...
    def __ne__(self, other: object): ...
    def __eq__(self, other: object): ...


class Preset(QtCore.QObject):

    def __init__(self, resource: typing.Optional[Resource]) -> None: ...

    def fromXML(self, xml: typing.Optional[str]) -> None: ...
    def toXML(self) -> str: ...


class PresetChooser(QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    presetClicked: typing.ClassVar[QtCore.pyqtSignal]
    presetSelected: typing.ClassVar[QtCore.pyqtSignal]
    def currentPreset(self) -> typing.Optional[Resource]: ...
    def setCurrentPreset(self, resource: typing.Optional[Resource]) -> None: ...


class Scratchpad(QtWidgets.QWidget):

    def __init__(self, view: typing.Optional[View], defaultColor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    def copyScratchpadImageData(self) -> QtGui.QImage: ...
    def loadScratchpadImage(self, image: QtGui.QImage) -> None: ...
    def setFillColor(self, color: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor]) -> None: ...
    def setMode(self, modeName: typing.Optional[str]) -> None: ...
    def linkCanvasZoom(self, value: bool) -> None: ...
    def setModeManually(self, value: bool) -> None: ...
    def clear(self) -> None: ...


class Palette(QtCore.QObject):

    def __init__(self, resource: typing.Optional[Resource]) -> None: ...

    def save(self) -> bool: ...
    def moveGroup(self, groupName: typing.Optional[str], groupNameInsertBefore: typing.Optional[str]) -> None: ...
    def changeGroupName(self, oldGroupName: typing.Optional[str], newGroupName: typing.Optional[str]) -> None: ...
    def removeEntry(self, index: int, groupName: typing.Optional[str]) -> None: ...
    def addEntry(self, entry: 'Swatch', groupName: typing.Optional[str]) -> None: ...
    def colorSetEntryFromGroup(self, index: int, groupName: typing.Optional[str]) -> typing.Optional['Swatch']: ...
    def colorSetEntryByIndex(self, index: int) -> typing.Optional['Swatch']: ...
    def colorsCountTotal(self) -> int: ...
    def removeGroup(self, name: typing.Optional[str], keepColors: bool) -> None: ...
    def addGroup(self, name: typing.Optional[str]) -> None: ...
    def groupNames(self) -> typing.List[str]: ...
    def setComment(self, comment: typing.Optional[str]) -> None: ...
    def comment(self) -> str: ...
    def setColumnCount(self, columns: int) -> None: ...
    def columnCount(self) -> int: ...
    def numberOfEntries(self) -> int: ...


class PaletteView(QtWidgets.QWidget):

    def __init__(self, parent: typing.Optional[QtWidgets.QWidget] = ...) -> None: ...

    entrySelectedBackGround: typing.ClassVar[QtCore.pyqtSignal]
    entrySelectedForeGround: typing.ClassVar[QtCore.pyqtSignal]
    def trySelectClosestColor(self, color: typing.Optional['ManagedColor']) -> None: ...
    def removeSelectedEntryWithDialog(self) -> bool: ...
    def addGroupWithDialog(self) -> bool: ...
    def addEntryWithDialog(self, color: typing.Optional['ManagedColor']) -> bool: ...
    def setPalette(self, palette: typing.Optional[Palette]) -> None: ...


class ManagedColor(QtCore.QObject):

    def __init__(self, colorModel: typing.Optional[str], colorDepth: typing.Optional[str], colorProfile: typing.Optional[str], parent: typing.Optional[QtCore.QObject] = ...) -> None: ...

    def __ne__(self, other: object): ...
    def toQString(self) -> str: ...
    def fromXML(self, xml: typing.Optional[str]) -> None: ...
    def toXML(self) -> str: ...
    def setComponents(self, values: typing.Iterable[float]) -> None: ...
    def componentsOrdered(self) -> typing.List[float]: ...
    def components(self) -> typing.List[float]: ...
    def setColorSpace(self, colorModel: typing.Optional[str], colorDepth: typing.Optional[str], colorProfile: typing.Optional[str]) -> bool: ...
    def setColorProfile(self, colorProfile: typing.Optional[str]) -> bool: ...
    def colorProfile(self) -> str: ...
    def colorModel(self) -> str: ...
    def colorDepth(self) -> str: ...
    @staticmethod
    def fromQColor(qcolor: typing.Union[QtGui.QColor, QtCore.Qt.GlobalColor], canvas: typing.Optional[Canvas] = ...) -> typing.Optional['ManagedColor']: ...
    def colorForCanvas(self, canvas: typing.Optional[Canvas]) -> QtGui.QColor: ...
    def __eq__(self, other: object): ...


class Swatch(PyQt5.sip.wrapper):

    def __init__(self) -> None: ...

    def isValid(self) -> bool: ...
    def setSpotColor(self, spotColor: bool) -> None: ...
    def spotColor(self) -> bool: ...
    def setColor(self, color: typing.Optional[ManagedColor]) -> None: ...
    def color(self) -> typing.Optional[ManagedColor]: ...
    def setId(self, id: typing.Optional[str]) -> None: ...
    def id(self) -> str: ...
    def setName(self, name: typing.Optional[str]) -> None: ...
    def name(self) -> str: ...


class KisCubicCurve(PyQt5.sip.wrapper):

    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, a0: 'KisCubicCurve') -> None: ...

    def fromString(self, a0: typing.Optional[str]) -> None: ...
    def toString(self) -> str: ...
    def name(self) -> str: ...
    def setName(self, name: typing.Optional[str]) -> None: ...
    def isConstant(self, x: float) -> bool: ...
    def isIdentity(self) -> bool: ...
    def removePoint(self, idx: int) -> None: ...
    def addPoint(self, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> int: ...
    def setPoint(self, idx: int, point: typing.Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setPoints(self, points: typing.Iterable[typing.Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
    def points(self) -> typing.List[QtCore.QPointF]: ...
    def value(self, x: float) -> float: ...


from typing import Type


class DockWidgetFactory(DockWidgetFactoryBase):

    def __init__(self, _id: str, _dockPosition: DockWidgetFactoryBase.DockPosition, _klass: Type[DockWidget]): ...


def qDebug(text: str): ...

