"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRACE_TABLE_TYPE_KEY = exports.TRACE_TABLE_TITLES = exports.TRACE_TABLE_OPTIONS = exports.TRACE_CUSTOM_SPAN_INDEX_SETTING = exports.TRACE_CUSTOM_SERVICE_INDEX_SETTING = exports.TRACE_ANALYTICS_PLOTS_DATE_FORMAT = exports.TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = exports.TRACE_ANALYTICS_DSL_ROUTE = exports.TRACE_ANALYTICS_DOCUMENTATION_LINK = exports.TRACE_ANALYTICS_DATE_FORMAT = exports.TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.TRACES_MAX_NUM = exports.SERVICE_MAP_MAX_NODES = exports.SERVICE_MAP_MAX_EDGES = exports.JAEGER_SERVICE_INDEX_NAME = exports.JAEGER_INDEX_NAME = exports.DATA_PREPPER_SERVICE_INDEX_NAME = exports.DATA_PREPPER_INDEX_NAME = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const JAEGER_INDEX_NAME = exports.JAEGER_INDEX_NAME = '*jaeger-span-*';
const JAEGER_SERVICE_INDEX_NAME = exports.JAEGER_SERVICE_INDEX_NAME = '*jaeger-service*';
const DATA_PREPPER_INDEX_NAME = exports.DATA_PREPPER_INDEX_NAME = 'otel-v1-apm-span-*';
const DATA_PREPPER_SERVICE_INDEX_NAME = exports.DATA_PREPPER_SERVICE_INDEX_NAME = 'otel-v1-apm-service-map*';
const TRACE_ANALYTICS_DATE_FORMAT = exports.TRACE_ANALYTICS_DATE_FORMAT = 'MM/DD/YYYY HH:mm:ss.SSS';
const TRACE_ANALYTICS_PLOTS_DATE_FORMAT = exports.TRACE_ANALYTICS_PLOTS_DATE_FORMAT = 'MMM D, YYYY HH:mm:ss.SSS';
const SERVICE_MAP_MAX_NODES = exports.SERVICE_MAP_MAX_NODES = 500;
// size limit when requesting edge related queries, not necessarily the number of edges
const SERVICE_MAP_MAX_EDGES = exports.SERVICE_MAP_MAX_EDGES = 1000;
const TRACES_MAX_NUM = exports.TRACES_MAX_NUM = 3000;
const TRACE_ANALYTICS_DOCUMENTATION_LINK = exports.TRACE_ANALYTICS_DOCUMENTATION_LINK = 'https://opensearch.org/docs/latest/observability-plugin/trace/index/';
const TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = exports.TRACE_ANALYTICS_JAEGER_INDICES_ROUTE = '/api/observability/trace_analytics/jaeger_indices';
const TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = exports.TRACE_ANALYTICS_DATA_PREPPER_INDICES_ROUTE = '/api/observability/trace_analytics/data_prepper_indices';
const TRACE_ANALYTICS_DSL_ROUTE = exports.TRACE_ANALYTICS_DSL_ROUTE = '/api/observability/trace_analytics/query';
const TRACE_CUSTOM_SPAN_INDEX_SETTING = exports.TRACE_CUSTOM_SPAN_INDEX_SETTING = 'observability:traceAnalyticsSpanIndices';
const TRACE_CUSTOM_SERVICE_INDEX_SETTING = exports.TRACE_CUSTOM_SERVICE_INDEX_SETTING = 'observability:traceAnalyticsServiceIndices';
let TRACE_TABLE_TITLES = exports.TRACE_TABLE_TITLES = /*#__PURE__*/function (TRACE_TABLE_TITLES) {
  TRACE_TABLE_TITLES["all_spans"] = "All Spans";
  TRACE_TABLE_TITLES["root_spans"] = "Root Spans";
  TRACE_TABLE_TITLES["entry_spans"] = "Service Entry Spans";
  TRACE_TABLE_TITLES["traces"] = "Traces";
  return TRACE_TABLE_TITLES;
}({});
const getDescription = key => {
  const descriptions = {
    all_spans: 'Spans representing all activities in all traces across the system',
    root_spans: 'Spans marking the root or starting point of each trace',
    entry_spans: 'Spans that indicate the entry point of service-side processing',
    traces: 'Spans grouped by traceId to show a complete trace lifecycle'
  };
  return descriptions[key];
};
const TRACE_TABLE_OPTIONS = exports.TRACE_TABLE_OPTIONS = Object.entries(TRACE_TABLE_TITLES).map(([key, label]) => ({
  label,
  key,
  'aria-describedby': getDescription(key)
}));
const TRACE_TABLE_TYPE_KEY = exports.TRACE_TABLE_TYPE_KEY = 'TraceAnalyticsTraceTableType';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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