"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CaseInsensitiveCharStream = void 0;
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class CaseInsensitiveCharStream {
  get index() {
    return this.stream.index;
  }
  get size() {
    return this.stream.size;
  }
  get sourceName() {
    return 'pplquery';
  }
  constructor(stream) {
    _defineProperty(this, "stream", void 0);
    this.stream = stream;
  }
  LA(offset) {
    const c = this.stream.LA(offset);
    if (c <= 0) {
      return c;
    }

    // case insensitivity support for PPL
    return String.fromCodePoint(c).toUpperCase().codePointAt(0);
  }
  consume() {
    this.stream.consume();
  }
  mark() {
    return this.stream.mark();
  }
  release(marker) {
    this.stream.release(marker);
  }
  seek(index) {
    this.stream.seek(index);
  }
  getText(interval) {
    return this.stream.getText(interval);
  }
  toString() {
    return this.stream.toString();
  }
}
exports.CaseInsensitiveCharStream = CaseInsensitiveCharStream;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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