/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chronology;

import net.sourceforge.plantuml.chronology.TimeScaleChronology;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.TimeHeaderParameters;
import net.sourceforge.plantuml.project.core.PrintScale;
import net.sourceforge.plantuml.project.draw.TimeHeader;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;

public class TimeHeaderChronology
extends TimeHeader {
    private final PrintScale printScale;

    @Override
    public double getFullHeaderHeight(StringBounder stringBounder) {
        return this.getTimeHeaderHeight(stringBounder) + this.getHeaderNameDayHeight();
    }

    @Override
    public double getTimeHeaderHeight(StringBounder stringBounder) {
        double h2 = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble();
        return h2 + 6.0;
    }

    @Override
    public double getTimeFooterHeight(StringBounder stringBounder) {
        double h2 = this.thParam.getStyle(SName.timeline, SName.day).value(PName.FontSize).asDouble();
        return h2 + 6.0;
    }

    private double getHeaderNameDayHeight() {
        return 0.0;
    }

    public TimeHeaderChronology(StringBounder stringBounder, TimeHeaderParameters thParam, PrintScale printScale, TimeScaleChronology timeScale) {
        super(thParam, timeScale);
        this.printScale = printScale;
    }

    private void drawSmallVlinesDay(UGraphic ug, TimeScale timeScale, double totalHeightWithoutFooter) {
        ug = ug.apply(this.getLineColor());
        ug = ug.apply(UTranslate.dy(6.0));
        ULine vbar = ULine.vline(totalHeightWithoutFooter + 2.0);
        Day i = this.getMin();
        while (i.compareTo(this.getMax().increment()) < 0) {
            double x1 = timeScale.getStartingPosition(i);
            ug.apply(UTranslate.dx(x1)).draw(vbar);
            i = i.increment(this.printScale);
        }
    }

    private void drawSimpleDayCounter(UGraphic ug, TimeScale timeScale) {
        Day i = this.getMin();
        while (i.compareTo(this.getMax().increment()) < 0) {
            UFont font = this.thParam.getStyle(SName.timeline, SName.day).getUFont();
            FontConfiguration fontConfiguration = this.getFontConfiguration(font, false, this.openFontColor());
            TextBlock num = Display.getWithNewlines(i.toStringShort(this.thParam.getLocale())).create(fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            double x1 = timeScale.getStartingPosition(i);
            double x2 = this.printScale == PrintScale.WEEKLY ? timeScale.getEndingPosition(i.addDays(6)) : timeScale.getEndingPosition(i);
            double width = num.calculateDimension(ug.getStringBounder()).getWidth();
            double delta = x2 - x1 - width;
            if (i.compareTo(this.getMax().increment()) < 0) {
                num.drawU(ug.apply(UTranslate.dx(x1 + delta / 2.0)));
            }
            i = i.increment(this.printScale);
        }
    }

    @Override
    public void drawTimeHeader(UGraphic ug, double totalHeightWithoutFooter) {
        double xmin = this.getTimeScale().getStartingPosition(this.getMin());
        double xmax = this.getTimeScale().getEndingPosition(this.getMax());
        this.drawSmallVlinesDay(ug, this.getTimeScale(), totalHeightWithoutFooter);
        this.drawSimpleDayCounter(ug, this.getTimeScale());
    }

    @Override
    public void drawTimeFooter(UGraphic ug) {
        double xmin = this.getTimeScale().getStartingPosition(this.getMin());
        double xmax = this.getTimeScale().getEndingPosition(this.getMax());
        ug = ug.apply(UTranslate.dy(3.0));
        this.drawSimpleDayCounter(ug, this.getTimeScale());
    }

    protected final void drawTextsBackground(UGraphic ug, double totalHeightWithoutFooter) {
        double height = totalHeightWithoutFooter - this.getFullHeaderHeight(ug.getStringBounder());
        Pending pending = null;
        Day wink = this.getMin();
        while (wink.compareTo(this.getMax()) <= 0) {
            double x1 = this.getTimeScale().getStartingPosition(wink);
            double x2 = this.getTimeScale().getEndingPosition(wink);
            HColor back = this.thParam.getColor(wink);
            if (back == null) {
                if (pending != null) {
                    pending.draw(ug, height);
                }
                pending = null;
            } else {
                if (pending != null && !pending.color.equals(back)) {
                    pending.draw(ug, height);
                    pending = null;
                }
                if (pending == null) {
                    pending = new Pending(back, x1, x2);
                } else {
                    pending.x2 = x2;
                }
            }
            wink = wink.increment();
        }
    }

    class Pending {
        final double x1;
        double x2;
        final HColor color;

        Pending(HColor color, double x1, double x2) {
            this.x1 = x1;
            this.x2 = x2;
            this.color = color;
        }

        public void draw(UGraphic ug, double height) {
            TimeHeaderChronology.this.drawRectangle(ug.apply(this.color.bg()), height, this.x1, this.x2);
        }
    }
}

