/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.svg;

import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorGradient;
import net.sourceforge.plantuml.klimt.drawing.svg.LengthAdjust;
import net.sourceforge.plantuml.klimt.drawing.svg.SvgOption;
import net.sourceforge.plantuml.klimt.geom.USegment;
import net.sourceforge.plantuml.klimt.geom.USegmentType;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UImageSvg;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.security.SImageIO;
import net.sourceforge.plantuml.security.SecurityProfile;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.utils.Base64Coder;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.xml.XmlFactories;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgGraphics {
    private static final String XLINK_TITLE1 = "title";
    private static final String XLINK_TITLE2 = "xlink:title";
    private static final String XLINK_HREF1 = "href";
    private static final String XLINK_HREF2 = "xlink:href";
    private final Document document;
    private final Element root;
    private final Element defs;
    private final Element gRoot;
    private String fill = "black";
    private String stroke = "black";
    private String strokeWidth;
    private String strokeDasharray = null;
    private final String backcolorString;
    private int maxX = 10;
    private int maxY = 10;
    private final String filterUid;
    private final String shadowId;
    private final String gradientId;
    private final SvgOption option;
    private Element pendingBackground;
    private boolean robotoAdded = false;
    private Map<List<Object>, String> gradients = new HashMap<List<Object>, String>();
    private final List<Element> pendingAction = new ArrayList<Element>();
    private final Map<String, String> filterBackColor = new HashMap<String, String>();
    private StringBuilder currentPath = null;
    private final Map<String, String> images = new HashMap<String, String>();
    private boolean withShadow = false;
    private boolean hidden;
    public static final String META_HEADER = "<!--SRC=[";

    protected final void ensureVisible(double x, double y) {
        if (x > (double)this.maxX) {
            this.maxX = (int)(x + 1.0);
        }
        if (y > (double)this.maxY) {
            this.maxY = (int)(y + 1.0);
        }
    }

    public SvgGraphics(long seed, SvgOption option) {
        try {
            HColor backcolor;
            this.document = this.getDocument();
            this.option = option;
            XDimension2D minDim = option.getMinDim();
            this.ensureVisible(minDim.getWidth(), minDim.getHeight());
            this.root = this.getRootNode();
            this.defs = this.simpleElement("defs");
            this.gRoot = this.simpleElement("g");
            this.strokeWidth = this.format(1.0);
            this.filterUid = "b" + SvgGraphics.getSeed(seed);
            this.shadowId = "f" + SvgGraphics.getSeed(seed);
            this.gradientId = "g" + SvgGraphics.getSeed(seed);
            if (option.getHover() != null) {
                this.defs.appendChild(this.getPathHover(option.getHover()));
            }
            if (option.isInteractive()) {
                Element script;
                Element styles = this.getStylesForInteractiveMode();
                if (styles != null) {
                    this.defs.appendChild(styles);
                }
                if ((script = this.getScriptForInteractiveMode()) != null) {
                    this.defs.appendChild(script);
                }
            }
            if ((backcolor = option.getBackcolor()) instanceof HColorGradient) {
                this.backcolorString = null;
                HColorGradient gr = (HColorGradient)backcolor;
                String id = this.createSvgGradient(gr.getColor1().toRGB(option.getColorMapper()), gr.getColor2().toRGB(option.getColorMapper()), gr.getPolicy());
                this.paintBackcolor("url(#" + id + ")");
            } else if (backcolor == null) {
                this.backcolorString = null;
            } else {
                this.backcolorString = backcolor.toSvg(option.getColorMapper());
                String color = backcolor.toSvg(option.getColorMapper());
                if (!(color.equals("#00000000") || color.equals("#000000") || color.equals("#FFFFFF"))) {
                    this.paintBackcolor(color);
                }
            }
        }
        catch (ParserConfigurationException e) {
            Logme.error(e);
            throw new IllegalStateException(e);
        }
    }

    private void addRoboto() {
        if (this.robotoAdded) {
            return;
        }
        Element style = this.document.createElement("style");
        style.setAttribute("type", "text/css");
        style.setTextContent("@import url('https://fonts.googleapis.com/css?family=Roboto:400,100,100italic,300,300italic,400italic,500,500italic,700,700italic,900,900italic');");
        this.defs.appendChild(style);
        this.robotoAdded = true;
    }

    private void paintBackcolor(String back) {
        this.setFillColor(back);
        this.setStrokeColor(null);
        this.pendingBackground = this.createRectangleInternal(0.0, 0.0, 0.0, 0.0);
        this.getG().appendChild(this.pendingBackground);
    }

    private Element getStylesForInteractiveMode() {
        Element style = this.simpleElement("style");
        String text = SvgGraphics.getData("default.css");
        if (text == null) {
            return null;
        }
        CDATASection cdata = this.document.createCDATASection(text);
        style.setAttribute("type", "text/css");
        style.appendChild(cdata);
        return style;
    }

    private Element getScriptForInteractiveMode() {
        Element script = this.document.createElement("script");
        String text = SvgGraphics.getData("default.js");
        if (text == null) {
            return null;
        }
        script.setTextContent(text);
        return script;
    }

    private static String getData(String name) {
        try {
            InputStream is = SvgGraphics.class.getResourceAsStream("/svg/" + name);
            if (is != null) {
                return FileUtils.readText(is);
            }
            Log.error("Cannot retrieve " + name);
        }
        catch (IOException e) {
            Logme.error(e);
        }
        return null;
    }

    private Element getPathHover(String hover) {
        Element style = this.simpleElement("style");
        CDATASection cdata = this.document.createCDATASection("path:hover { stroke: " + hover + " !important;}");
        style.setAttribute("type", "text/css");
        style.appendChild(cdata);
        return style;
    }

    private static String getSeed(long seed) {
        return Long.toString(Math.abs(seed), 36);
    }

    private Element simpleElement(String type) {
        Element theElement = this.document.createElement(type);
        this.root.appendChild(theElement);
        return theElement;
    }

    private Document getDocument() throws ParserConfigurationException {
        DocumentBuilder builder = XmlFactories.newDocumentBuilder();
        Document document = builder.newDocument();
        document.setXmlStandalone(true);
        return document;
    }

    private Element getRootNode() {
        Element svg = this.document.createElement("svg");
        this.document.appendChild(svg);
        svg.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        svg.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
        svg.setAttribute("version", "1.1");
        if (this.option.getTitle() != null) {
            Element title = this.document.createElement(XLINK_TITLE1);
            title.setTextContent(this.option.getTitle());
            svg.appendChild(title);
        }
        return svg;
    }

    public void svgEllipse(double x, double y, double xRadius, double yRadius, double deltaShadow) {
        this.manageShadow(deltaShadow);
        if (!this.hidden) {
            Element elt = this.document.createElement("ellipse");
            elt.setAttribute("cx", this.format(x));
            elt.setAttribute("cy", this.format(y));
            elt.setAttribute("rx", this.format(xRadius));
            elt.setAttribute("ry", this.format(yRadius));
            this.fillMe(elt);
            elt.setAttribute("style", this.getStyle());
            this.addFilterShadowId(elt, deltaShadow);
            this.getG().appendChild(elt);
        }
        this.ensureVisible(x + xRadius + deltaShadow * 2.0, y + yRadius + deltaShadow * 2.0);
    }

    public void svgArcEllipse(double rx, double ry, double x1, double y1, double x2, double y2) {
        if (!this.hidden) {
            String path = "M" + this.format(x1) + "," + this.format(y1) + " A" + this.format(rx) + "," + this.format(ry) + " 0 0 0 " + this.format(x2) + " " + this.format(y2);
            Element elt = this.document.createElement("path");
            elt.setAttribute("d", path);
            this.fillMe(elt);
            elt.setAttribute("style", this.getStyle());
            this.getG().appendChild(elt);
        }
        this.ensureVisible(x1, y1);
        this.ensureVisible(x2, y2);
    }

    public String createSvgGradient(String color1, String color2, char policy) {
        List<Object> key = Arrays.asList(color1, color2, Character.valueOf(policy));
        String id = this.gradients.get(key);
        if (id == null) {
            Element elt = this.document.createElement("linearGradient");
            if (policy == '|') {
                elt.setAttribute("x1", "0%");
                elt.setAttribute("y1", "50%");
                elt.setAttribute("x2", "100%");
                elt.setAttribute("y2", "50%");
            } else if (policy == '\\') {
                elt.setAttribute("x1", "0%");
                elt.setAttribute("y1", "100%");
                elt.setAttribute("x2", "100%");
                elt.setAttribute("y2", "0%");
            } else if (policy == '-') {
                elt.setAttribute("x1", "50%");
                elt.setAttribute("y1", "0%");
                elt.setAttribute("x2", "50%");
                elt.setAttribute("y2", "100%");
            } else {
                elt.setAttribute("x1", "0%");
                elt.setAttribute("y1", "0%");
                elt.setAttribute("x2", "100%");
                elt.setAttribute("y2", "100%");
            }
            id = this.gradientId + this.gradients.size();
            this.gradients.put(key, id);
            elt.setAttribute("id", id);
            Element stop1 = this.document.createElement("stop");
            stop1.setAttribute("stop-color", color1);
            stop1.setAttribute("offset", "0%");
            Element stop2 = this.document.createElement("stop");
            stop2.setAttribute("stop-color", color2);
            stop2.setAttribute("offset", "100%");
            elt.appendChild(stop1);
            elt.appendChild(stop2);
            this.defs.appendChild(elt);
        }
        return id;
    }

    public final void setFillColor(String fill) {
        this.fill = this.fixColor(fill);
    }

    public final void setStrokeColor(String stroke) {
        this.stroke = this.fixColor(stroke);
    }

    private String fixColor(String color) {
        return color == null || "#00000000".equals(color) ? "none" : color;
    }

    public final void setStrokeWidth(double strokeWidth, String strokeDasharray) {
        this.strokeWidth = this.format(strokeWidth);
        this.strokeDasharray = strokeDasharray;
    }

    public final Element getG() {
        if (this.pendingAction.size() == 0) {
            return this.gRoot;
        }
        return this.pendingAction.get(0);
    }

    public void svgRectangle(double x, double y, double width, double height, double rx, double ry, double deltaShadow, String id, String codeLine) {
        if (height <= 0.0 || width <= 0.0) {
            return;
        }
        this.manageShadow(deltaShadow);
        if (!this.hidden) {
            Element elt = this.createRectangleInternal(x, y, width, height);
            this.addFilterShadowId(elt, deltaShadow);
            if (rx > 0.0 && ry > 0.0) {
                elt.setAttribute("rx", this.format(rx));
                elt.setAttribute("ry", this.format(ry));
            }
            if (id != null) {
                elt.setAttribute("id", id);
            }
            if (codeLine != null) {
                elt.setAttribute("codeLine", codeLine);
            }
            this.getG().appendChild(elt);
        }
        this.ensureVisible(x + width + 2.0 * deltaShadow, y + height + 2.0 * deltaShadow);
    }

    private Element createRectangleInternal(double x, double y, double width, double height) {
        Element elt = this.document.createElement("rect");
        elt.setAttribute("x", this.format(x));
        elt.setAttribute("y", this.format(y));
        elt.setAttribute("width", this.format(width));
        elt.setAttribute("height", this.format(height));
        this.fillMe(elt);
        elt.setAttribute("style", this.getStyleSpecial());
        return elt;
    }

    public void svgLine(double x1, double y1, double x2, double y2, double deltaShadow) {
        this.manageShadow(deltaShadow);
        if (!this.hidden) {
            Element elt = this.document.createElement("line");
            elt.setAttribute("x1", this.format(x1));
            elt.setAttribute("y1", this.format(y1));
            elt.setAttribute("x2", this.format(x2));
            elt.setAttribute("y2", this.format(y2));
            elt.setAttribute("style", this.getStyle());
            this.addFilterShadowId(elt, deltaShadow);
            this.getG().appendChild(elt);
        }
        this.ensureVisible(x1 + 2.0 * deltaShadow, y1 + 2.0 * deltaShadow);
        this.ensureVisible(x2 + 2.0 * deltaShadow, y2 + 2.0 * deltaShadow);
    }

    private String getStyle() {
        StringBuilder style = new StringBuilder();
        style.append("stroke:" + this.stroke + ";");
        style.append("stroke-width:" + this.strokeWidth + ";");
        if (this.fill.equals("#00000000")) {
            style.append("fill:none;");
        }
        if (this.strokeDasharray != null) {
            style.append("stroke-dasharray:" + this.strokeDasharray + ";");
        }
        return style.toString();
    }

    private String getStyleSpecial() {
        StringBuilder style = new StringBuilder();
        style.append("stroke:" + this.stroke + ";");
        style.append("stroke-width:" + this.strokeWidth + ";");
        if (this.fill.equals("#00000000")) {
            style.append("fill:none;");
        }
        if (this.strokeDasharray != null) {
            style.append("stroke-dasharray:" + this.strokeDasharray + ";");
        }
        return style.toString();
    }

    public void svgPolygon(double deltaShadow, double ... points) {
        assert (points.length % 2 == 0);
        this.manageShadow(deltaShadow);
        if (!this.hidden) {
            Element elt = this.document.createElement("polygon");
            StringBuilder sb = new StringBuilder();
            for (double coord : points) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(this.format(coord));
            }
            elt.setAttribute("points", sb.toString());
            this.fillMe(elt);
            elt.setAttribute("style", this.getStyleSpecial());
            this.addFilterShadowId(elt, deltaShadow);
            this.getG().appendChild(elt);
        }
        for (int i = 0; i < points.length; i += 2) {
            this.ensureVisible(points[i] + 2.0 * deltaShadow, points[i + 1] + 2.0 * deltaShadow);
        }
    }

    public void text(String text, double x, double y, String fontFamily, int fontSize, String fontWeight, String fontStyle, String textDecoration, double textLength, Map<String, String> attributes, String textBackColor) {
        if (!this.hidden) {
            Element elt = this.document.createElement("text");
            elt.setAttribute("x", this.format(x));
            elt.setAttribute("y", this.format(y));
            this.fillMe(elt);
            elt.setAttribute("font-size", this.format(fontSize));
            if (this.option.getLengthAdjust() == LengthAdjust.SPACING) {
                elt.setAttribute("lengthAdjust", "spacing");
                elt.setAttribute("textLength", this.format(textLength));
            } else if (this.option.getLengthAdjust() == LengthAdjust.SPACING_AND_GLYPHS) {
                elt.setAttribute("lengthAdjust", "spacingAndGlyphs");
                elt.setAttribute("textLength", this.format(textLength));
            }
            if (fontWeight != null) {
                elt.setAttribute("font-weight", fontWeight);
            }
            if (fontStyle != null) {
                elt.setAttribute("font-style", fontStyle);
            }
            if (textDecoration != null) {
                elt.setAttribute("text-decoration", textDecoration);
            }
            if (fontFamily != null) {
                if ("roboto".equalsIgnoreCase(fontFamily)) {
                    this.addRoboto();
                }
                if ("monospaced".equalsIgnoreCase(fontFamily)) {
                    fontFamily = "monospace";
                }
                elt.setAttribute("font-family", fontFamily);
                if (fontFamily.equalsIgnoreCase("monospace") || fontFamily.equalsIgnoreCase("courier")) {
                    text = text.replace(' ', '\u00a0');
                }
            }
            if (textBackColor != null) {
                String backFilterId = this.getFilterBackColor(textBackColor);
                elt.setAttribute("filter", "url(#" + backFilterId + ")");
            }
            for (Map.Entry<String, String> ent : attributes.entrySet()) {
                elt.setAttribute(ent.getKey(), ent.getValue());
            }
            elt.setTextContent(text);
            this.getG().appendChild(elt);
        }
        this.ensureVisible(x, y);
        this.ensureVisible(x + textLength, y);
    }

    private String getIdFilterBackColor(String color) {
        String result = this.filterBackColor.get(color);
        if (result == null) {
            result = this.filterUid + this.filterBackColor.size();
            this.filterBackColor.put(color, result);
        }
        return result;
    }

    private String getFilterBackColor(String color) {
        String id = this.filterBackColor.get(color);
        if (id != null) {
            return id;
        }
        id = this.getIdFilterBackColor(color);
        Element filter = this.document.createElement("filter");
        filter.setAttribute("id", id);
        filter.setAttribute("x", "0");
        filter.setAttribute("y", "0");
        filter.setAttribute("width", "1");
        filter.setAttribute("height", "1");
        this.addFilter(filter, "feFlood", "flood-color", color, "result", "flood");
        this.addFilter(filter, "feComposite", "in", "SourceGraphic", "in2", "flood", "operator", "over");
        this.defs.appendChild(filter);
        return id;
    }

    private Transformer getTransformer() throws TransformerException {
        Transformer transformer = XmlFactories.newTransformer();
        Log.info("Transformer=" + transformer.getClass());
        transformer.setOutputProperty("standalone", "no");
        transformer.setOutputProperty("encoding", "us-ascii");
        return transformer;
    }

    public void createXml(OutputStream os) throws TransformerException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.createXmlInternal(baos);
        String s2 = new String(baos.toByteArray());
        for (Map.Entry<String, String> ent : this.images.entrySet()) {
            String k = "<" + ent.getKey() + "/>";
            s2 = s2.replace(k, ent.getValue());
        }
        s2 = this.removeXmlHeader(s2);
        os.write(s2.getBytes());
    }

    private String removeXmlHeader(String s2) {
        s2 = s2.replaceFirst("^<\\?xml [^<>]+?\\>", "");
        return s2;
    }

    private void createXmlInternal(OutputStream os) throws TransformerException {
        DOMSource source = new DOMSource(this.document);
        int maxXscaled = (int)((double)this.maxX * this.option.getScale());
        int maxYscaled = (int)((double)this.maxY * this.option.getScale());
        String style = "width:" + maxXscaled + "px;height:" + maxYscaled + "px;";
        if (this.backcolorString != null && !"#00000000".equals(this.backcolorString)) {
            style = style + "background:" + this.backcolorString + ";";
        }
        if (this.option.getSvgDimensionStyle()) {
            this.root.setAttribute("style", style);
            this.root.setAttribute("width", this.format(this.maxX) + "px");
            this.root.setAttribute("height", this.format(this.maxY) + "px");
        }
        this.root.setAttribute("viewBox", "0 0 " + maxXscaled + " " + maxYscaled);
        this.root.setAttribute("zoomAndPan", "magnify");
        this.root.setAttribute("preserveAspectRatio", this.option.getPreserveAspectRatio());
        this.root.setAttribute("contentStyleType", "text/css");
        if (this.pendingBackground != null) {
            this.pendingBackground.setAttribute("width", this.format(this.maxX));
            this.pendingBackground.setAttribute("height", this.format(this.maxY));
        }
        StreamResult scrResult = new StreamResult(os);
        this.getTransformer().transform(source, scrResult);
    }

    public void svgPath(double x, double y, UPath path, double deltaShadow) {
        this.manageShadow(deltaShadow);
        this.ensureVisible(x, y);
        StringBuilder sb = new StringBuilder();
        for (USegment seg : path) {
            USegmentType type = seg.getSegmentType();
            double[] coord = seg.getCoord();
            if (type == USegmentType.SEG_MOVETO) {
                sb.append("M" + this.format(coord[0] + x) + "," + this.format(coord[1] + y) + " ");
                this.ensureVisible(coord[0] + x + 2.0 * deltaShadow, coord[1] + y + 2.0 * deltaShadow);
                continue;
            }
            if (type == USegmentType.SEG_LINETO) {
                sb.append("L" + this.format(coord[0] + x) + "," + this.format(coord[1] + y) + " ");
                this.ensureVisible(coord[0] + x + 2.0 * deltaShadow, coord[1] + y + 2.0 * deltaShadow);
                continue;
            }
            if (type == USegmentType.SEG_QUADTO) {
                sb.append("Q" + this.format(coord[0] + x) + "," + this.format(coord[1] + y) + " " + this.format(coord[2] + x) + "," + this.format(coord[3] + y) + " ");
                this.ensureVisible(coord[0] + x + 2.0 * deltaShadow, coord[1] + y + 2.0 * deltaShadow);
                this.ensureVisible(coord[2] + x + 2.0 * deltaShadow, coord[3] + y + 2.0 * deltaShadow);
                continue;
            }
            if (type == USegmentType.SEG_CUBICTO) {
                sb.append("C" + this.format(coord[0] + x) + "," + this.format(coord[1] + y) + " " + this.format(coord[2] + x) + "," + this.format(coord[3] + y) + " " + this.format(coord[4] + x) + "," + this.format(coord[5] + y) + " ");
                this.ensureVisible(coord[0] + x + 2.0 * deltaShadow, coord[1] + y + 2.0 * deltaShadow);
                this.ensureVisible(coord[2] + x + 2.0 * deltaShadow, coord[3] + y + 2.0 * deltaShadow);
                this.ensureVisible(coord[4] + x + 2.0 * deltaShadow, coord[5] + y + 2.0 * deltaShadow);
                continue;
            }
            if (type == USegmentType.SEG_ARCTO) {
                sb.append("A" + this.format(coord[0]) + "," + this.format(coord[1]) + " " + this.format(coord[2]) + " " + this.formatBoolean(coord[3]) + " " + this.formatBoolean(coord[4]) + " " + this.format(coord[5] + x) + "," + this.format(coord[6] + y) + " ");
                this.ensureVisible(coord[5] + coord[0] + x + 2.0 * deltaShadow, coord[6] + coord[1] + y + 2.0 * deltaShadow);
                continue;
            }
            if (type == USegmentType.SEG_CLOSE) continue;
            Log.println("unknown3 " + seg);
        }
        if (!this.hidden) {
            String codeLine;
            Element elt = this.document.createElement("path");
            elt.setAttribute("d", sb.toString());
            elt.setAttribute("style", this.getStyle());
            this.fillMe(elt);
            String id = path.getComment();
            if (id != null) {
                elt.setAttribute("id", id);
            }
            if ((codeLine = path.getCodeLine()) != null) {
                elt.setAttribute("codeLine", codeLine);
            }
            this.addFilterShadowId(elt, deltaShadow);
            this.getG().appendChild(elt);
        }
    }

    private void fillMe(Element elt) {
        if (this.fill.equals("#00000000")) {
            return;
        }
        if (this.fill.matches("#[0-9A-Fa-f]{8}")) {
            elt.setAttribute("fill", this.fill.substring(0, 7));
            double opacity = (double)Integer.parseInt(this.fill.substring(7), 16) / 255.0;
            elt.setAttribute("fill-opacity", String.format(Locale.US, "%1.5f", opacity));
        } else {
            elt.setAttribute("fill", this.fill);
        }
    }

    private void addFilterShadowId(Element elt, double deltaShadow) {
        if (deltaShadow > 0.0) {
            elt.setAttribute("filter", "url(#" + this.shadowId + ")");
        }
    }

    public void newpath() {
        this.currentPath = new StringBuilder();
    }

    public void moveto(double x, double y) {
        this.currentPath.append("M" + this.format(x) + "," + this.format(y) + " ");
        this.ensureVisible(x, y);
    }

    public void lineto(double x, double y) {
        this.currentPath.append("L" + this.format(x) + "," + this.format(y) + " ");
        this.ensureVisible(x, y);
    }

    public void closepath() {
        this.currentPath.append("Z ");
    }

    public void curveto(double x1, double y1, double x2, double y2, double x3, double y3) {
        this.currentPath.append("C" + this.format(x1) + "," + this.format(y1) + " " + this.format(x2) + "," + this.format(y2) + " " + this.format(x3) + "," + this.format(y3) + " ");
        this.ensureVisible(x1, y1);
        this.ensureVisible(x2, y2);
        this.ensureVisible(x3, y3);
    }

    public void quadto(double x1, double y1, double x2, double y2) {
        this.currentPath.append("Q" + this.format(x1) + "," + this.format(y1) + " " + this.format(x2) + "," + this.format(y2) + " ");
        this.ensureVisible(x1, y1);
        this.ensureVisible(x2, y2);
    }

    private String format(double xx) {
        double x = xx * this.option.getScale();
        if (x == 0.0) {
            return "0";
        }
        String s2 = String.format(Locale.US, "%1.4f", x);
        if ((s2 = s2.replaceAll("(\\.\\d*?)0+$", "$1")).endsWith(".")) {
            s2 = s2.substring(0, s2.length() - 1);
        }
        return s2;
    }

    private String formatBoolean(double x) {
        return x == 0.0 ? "0" : "1";
    }

    public void fill(int windingRule) {
        if (!this.hidden) {
            Element elt = this.document.createElement("path");
            elt.setAttribute("d", this.currentPath.toString());
            this.fillMe(elt);
            this.getG().appendChild(elt);
        }
        this.currentPath = null;
    }

    public void drawPathIterator(double x, double y, PathIterator path) {
        this.newpath();
        double[] coord = new double[6];
        while (!path.isDone()) {
            int code = path.currentSegment(coord);
            if (code == 0) {
                this.moveto(coord[0] + x, coord[1] + y);
            } else if (code == 1) {
                this.lineto(coord[0] + x, coord[1] + y);
            } else if (code == 4) {
                this.closepath();
            } else if (code == 3) {
                this.curveto(coord[0] + x, coord[1] + y, coord[2] + x, coord[3] + y, coord[4] + x, coord[5] + y);
            } else if (code == 2) {
                this.quadto(coord[0] + x, coord[1] + y, coord[2] + x, coord[3] + y);
            } else {
                throw new UnsupportedOperationException("code=" + code);
            }
            path.next();
        }
        this.fill(path.getWindingRule());
    }

    public void svgImage(BufferedImage image, double x, double y) throws IOException {
        if (!this.hidden) {
            Element elt = this.document.createElement("image");
            elt.setAttribute("width", this.format(image.getWidth()));
            elt.setAttribute("height", this.format(image.getHeight()));
            elt.setAttribute("x", this.format(x));
            elt.setAttribute("y", this.format(y));
            String s2 = this.toBase64(image);
            elt.setAttribute(XLINK_HREF2, "data:image/png;base64," + s2);
            this.getG().appendChild(elt);
        }
        this.ensureVisible(x, y);
        this.ensureVisible(x + (double)image.getWidth(), y + (double)image.getHeight());
    }

    private void svgImageUnsecure(UImageSvg image, double x, double y) {
        if (!this.hidden) {
            String svg = this.manageScale(image);
            String pos = "<svg x=\"" + this.format(x) + "\" y=\"" + this.format(y) + "\">";
            svg = pos + svg.substring(5);
            String key = "imagesvginlined" + image.getMD5Hex() + this.images.size();
            Element elt = this.document.createElement(key);
            this.getG().appendChild(elt);
            this.images.put(key, svg);
        }
        this.ensureVisible(x, y);
        this.ensureVisible(x + (double)image.getData("width"), y + (double)image.getData("height"));
    }

    public void svgImage(UImageSvg image, double x, double y) {
        if (SecurityUtils.getSecurityProfile() == SecurityProfile.UNSECURE) {
            this.svgImageUnsecure(image, x, y);
            return;
        }
        if (!this.hidden) {
            Element elt = this.document.createElement("image");
            elt.setAttribute("width", this.format(image.getWidth()));
            elt.setAttribute("height", this.format(image.getHeight()));
            elt.setAttribute("x", this.format(x));
            elt.setAttribute("y", this.format(y));
            String svg = this.manageScale(image);
            String svgHeader = image.containsXlink() ? "<svg height=\"" + (int)(image.getHeight() * this.option.getScale()) + "\" width=\"" + (int)(image.getWidth() * this.option.getScale()) + "\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns=\"http://www.w3.org/2000/svg\" >" : "<svg height=\"" + (int)(image.getHeight() * this.option.getScale()) + "\" width=\"" + (int)(image.getWidth() * this.option.getScale()) + "\" xmlns=\"http://www.w3.org/2000/svg\" >";
            svg = svgHeader + svg.substring(5);
            String s2 = this.toBase64(svg);
            elt.setAttribute(XLINK_HREF2, "data:image/svg+xml;base64," + s2);
            this.getG().appendChild(elt);
        }
        this.ensureVisible(x, y);
        this.ensureVisible(x + (double)image.getData("width"), y + (double)image.getData("height"));
    }

    private String manageScale(UImageSvg svgImage) {
        double svgScale = svgImage.getScale();
        String svg = svgImage.getSvg(false);
        if (svgScale * this.option.getScale() == 1.0) {
            return svg;
        }
        String svg2 = svg.replace('\n', ' ').replace('\r', ' ');
        if (!svg2.contains("<g ") && !svg2.contains("<g>")) {
            svg = svg.replaceFirst("\\<svg\\>", "<svg><g>");
            svg = svg.replaceFirst("\\</svg\\>", "</g></svg>");
        }
        String factor = this.format(svgScale);
        String s1 = "\\<g\\b";
        String s2 = "<g transform=\"scale(" + factor + "," + factor + ")\" ";
        svg = svg.replaceFirst("\\<g\\b", s2);
        return svg;
    }

    private String toBase64(BufferedImage image) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SImageIO.write((RenderedImage)image, "png", baos);
        byte[] data = baos.toByteArray();
        return new String(Base64Coder.encode(data));
    }

    private String toBase64(String s2) {
        byte[] data = s2.getBytes(Charset.forName("UTF8"));
        return new String(Base64Coder.encode(data));
    }

    private void manageShadow(double deltaShadow) {
        if (deltaShadow != 0.0) {
            if (!this.withShadow) {
                Element filter = this.document.createElement("filter");
                filter.setAttribute("id", this.shadowId);
                filter.setAttribute("x", "-1");
                filter.setAttribute("y", "-1");
                filter.setAttribute("width", "300%");
                filter.setAttribute("height", "300%");
                this.addFilter(filter, "feGaussianBlur", "result", "blurOut", "stdDeviation", this.format(2.0));
                this.addFilter(filter, "feColorMatrix", "type", "matrix", "in", "blurOut", "result", "blurOut2", "values", "0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 .4 0");
                this.addFilter(filter, "feOffset", "result", "blurOut3", "in", "blurOut2", "dx", this.format(4.0), "dy", this.format(4.0));
                this.addFilter(filter, "feBlend", "in", "SourceGraphic", "in2", "blurOut3", "mode", "normal");
                this.defs.appendChild(filter);
            }
            this.withShadow = true;
        }
    }

    private void addFilter(Element filter, String name, String ... data) {
        assert (data.length % 2 == 0);
        Element elt = this.document.createElement(name);
        for (int i = 0; i < data.length; i += 2) {
            elt.setAttribute(data[i], data[i + 1]);
        }
        filter.appendChild(elt);
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public static String getMetadataHex(String comment) {
        try {
            String encoded = TranscoderUtil.getDefaultTranscoderProtected().encode(comment);
            return encoded;
        }
        catch (IOException e) {
            return "ERROR42";
        }
    }

    public void addCommentMetadata(String metadata) {
        String signature = SvgGraphics.getMetadataHex(metadata).replace("--", "- -");
        String comment = "SRC=[" + signature + "]";
        Comment commentElement = this.document.createComment(comment);
        this.getG().appendChild(commentElement);
    }

    public void addComment(String comment) {
        Comment commentElement = this.document.createComment(comment);
        this.getG().appendChild(commentElement);
    }

    public void addScriptTag(String url) {
        Element script = this.document.createElement("script");
        script.setAttribute("type", "text/javascript");
        script.setAttribute(XLINK_HREF2, url);
        this.root.appendChild(script);
    }

    public void addScript(String scriptTextPath) {
        Element script = this.document.createElement("script");
        String scriptText = SvgGraphics.getData(scriptTextPath);
        CDATASection cDATAScript = this.document.createCDATASection(scriptText);
        script.appendChild(cDATAScript);
        this.root.appendChild(script);
    }

    public void addStyle(String cssStylePath) {
        Element style = this.simpleElement("style");
        String text = SvgGraphics.getData(cssStylePath);
        CDATASection cdata = this.document.createCDATASection(text);
        style.setAttribute("type", "text/css");
        style.appendChild(cdata);
        this.root.appendChild(style);
    }

    public void openLink(String url, String title, String target) {
        Objects.requireNonNull(url);
        if (SecurityUtils.ignoreThisLink(url)) {
            return;
        }
        if (this.pendingAction.size() > 0) {
            this.closeLink();
        }
        this.pendingAction.add(0, this.document.createElement("a"));
        this.pendingAction.get(0).setAttribute("target", target);
        this.pendingAction.get(0).setAttribute(XLINK_HREF1, url);
        this.pendingAction.get(0).setAttribute(XLINK_HREF2, url);
        this.pendingAction.get(0).setAttribute("xlink:type", "simple");
        this.pendingAction.get(0).setAttribute("xlink:actuate", "onRequest");
        this.pendingAction.get(0).setAttribute("xlink:show", "new");
        if (title == null) {
            this.pendingAction.get(0).setAttribute(XLINK_TITLE1, url);
            this.pendingAction.get(0).setAttribute(XLINK_TITLE2, url);
        } else {
            title = this.formatTitle(title);
            this.pendingAction.get(0).setAttribute(XLINK_TITLE1, title);
            this.pendingAction.get(0).setAttribute(XLINK_TITLE2, title);
        }
    }

    private String formatTitle(String title) {
        Pattern p = Pattern.compile("\\<U\\+([0-9A-Fa-f]+)\\>");
        Matcher m4 = p.matcher(title);
        StringBuffer sb = new StringBuffer();
        while (m4.find()) {
            String num = m4.group(1);
            char c = (char)Integer.parseInt(num, 16);
            m4.appendReplacement(sb, "" + c);
        }
        m4.appendTail(sb);
        title = sb.toString().replaceAll("\\\\n", "\n");
        return title;
    }

    public void closeLink() {
        if (this.pendingAction.size() > 0) {
            Element element = this.pendingAction.get(0);
            this.pendingAction.remove(0);
            if (element.getFirstChild() != null) {
                this.getG().appendChild(element);
            }
        }
    }

    public void startGroup(Map<UGroupType, String> typeIdents) {
        if (typeIdents.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.pendingAction.add(0, this.document.createElement("g"));
        for (Map.Entry<UGroupType, String> typeIdent : typeIdents.entrySet()) {
            if (typeIdent.getKey() == UGroupType.ID) {
                this.pendingAction.get(0).setAttribute("id", typeIdent.getValue());
            }
            if (!this.option.isInteractive() || typeIdent.getKey() != UGroupType.CLASS) continue;
            this.pendingAction.get(0).setAttribute("class", typeIdent.getValue());
        }
    }

    public void closeGroup() {
        this.closeLink();
    }
}

