/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.MinMax;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.nwdiag.core.NServer;
import net.sourceforge.plantuml.nwdiag.core.NStackable;
import net.sourceforge.plantuml.nwdiag.next.NBox;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;

public class NwGroup
implements NStackable {
    private final Set<String> names = new HashSet<String>();
    private final String name;
    private HColor color;
    private String description;
    private NBox nbox;

    public NBox getNboxInternal() {
        if (this.nbox == null) {
            this.nbox = new NBox();
        }
        return this.nbox;
    }

    public final NBox getNbox(Map<String, ? extends NServer> servers) {
        if (this.nbox == null) {
            this.nbox = new NBox();
            for (Map.Entry<String, ? extends NServer> ent : servers.entrySet()) {
                if (!this.names.contains(ent.getKey())) continue;
                this.nbox.add(ent.getValue().getBar());
            }
        }
        return this.nbox;
    }

    public void addName(String name) {
        this.names.add(name);
    }

    public String toString() {
        return "NwGroup:" + this.name + " " + this.names + " " + this.nbox;
    }

    public NwGroup(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final HColor getColor() {
        return this.color;
    }

    @Override
    public final void setColor(HColor color) {
        this.color = color;
    }

    @Override
    public final void setDescription(String value) {
        this.description = value;
    }

    protected final String getDescription() {
        return this.description;
    }

    public final Set<String> names() {
        return Collections.unmodifiableSet(this.names);
    }

    public boolean contains(NServer server) {
        return this.names.contains(server.getName());
    }

    public double getTopHeaderHeight(StringBounder stringBounder, ISkinParam skinParam) {
        TextBlock block = this.buildHeaderName(skinParam);
        if (block == null) {
            return 0.0;
        }
        XDimension2D blockDim = block.calculateDimension(stringBounder);
        return blockDim.getHeight();
    }

    private StyleSignatureBasic getStyleDefinition() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.nwdiagDiagram, SName.group);
    }

    public void drawGroup(UGraphic ug, MinMax size, ISkinParam skinParam) {
        HColor backgroundColor;
        StyleBuilder styleBuilder = skinParam.getCurrentStyleBuilder();
        Style style = this.getStyleDefinition().getMergedStyle(styleBuilder);
        TextBlock block = this.buildHeaderName(skinParam);
        if (block != null) {
            XDimension2D blockDim = block.calculateDimension(ug.getStringBounder());
            double dy = size.getMinY() - blockDim.getHeight();
            size = size.addPoint(size.getMinX(), dy);
        }
        if ((backgroundColor = this.getColor()) == null) {
            backgroundColor = style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
        }
        HColor lineColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        size.draw(ug, lineColor, backgroundColor);
        if (block != null) {
            block.drawU(ug.apply(new UTranslate(size.getMinX() + 5.0, size.getMinY())));
        }
    }

    private TextBlock buildHeaderName(ISkinParam skinParam) {
        if (this.getDescription() == null) {
            return null;
        }
        StyleBuilder styleBuilder = skinParam.getCurrentStyleBuilder();
        Style style = this.getStyleDefinition().getMergedStyle(styleBuilder);
        return Display.getWithNewlines(this.getDescription()).create(style.getFontConfiguration(skinParam.getIHtmlColorSet()), HorizontalAlignment.LEFT, skinParam);
    }
}

