/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BackSlash {
    public static final String BS_BS_N = "\\n";
    public static final String NEWLINE = "\n";
    public static final char CHAR_NEWLINE = '\n';

    public static final String lineSeparator() {
        return System.lineSeparator();
    }

    public static char hiddenNewLine() {
        return '\ue00a';
    }

    public static String convertHiddenNewLine(String s2) {
        s2 = s2.replaceAll("(?<!\\\\)\\\\n", "" + BackSlash.hiddenNewLine());
        s2 = s2.replaceAll("\\\\\\\\n", "\\\\n");
        return s2;
    }

    public static List<String> splitHiddenNewLine(String s2) {
        return Arrays.asList(s2.split("" + BackSlash.hiddenNewLine()));
    }

    public static String manageNewLine(String string) {
        return string.replace(BackSlash.hiddenNewLine(), '\n');
    }

    public static List<String> getWithNewlines(CharSequence s2) {
        if (s2 == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '\\' && i < s2.length() - 1) {
                char c2 = s2.charAt(i + 1);
                ++i;
                if (c2 == 'n') {
                    result.add(current.toString());
                    current.setLength(0);
                    continue;
                }
                if (c2 == 't') {
                    current.append('\t');
                    continue;
                }
                if (c2 != '\\') continue;
                current.append(c2);
                continue;
            }
            current.append(c);
        }
        result.add(current.toString());
        return Collections.unmodifiableList(result);
    }

    public static String translateBackSlashes(CharSequence s2) {
        if (s2 == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c == '\\' && i < s2.length() - 1 && BackSlash.isEnglishLetterOfBackSlash(s2.charAt(i + 1))) {
                result.append('\\');
                result.append(BackSlash.translateChar(s2.charAt(i + 1)));
                ++i;
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private static boolean isEnglishLetterOfBackSlash(char c) {
        return c == 'n';
    }

    public static String untranslateBackSlashes(CharSequence s2) {
        if (s2 == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c > '\ue000' && c < '\ue07f') {
                c = (char)(c - 57344);
            }
            result.append(c);
        }
        return result.toString();
    }

    private static char translateChar(char c) {
        if (c > '\u0080') {
            throw new IllegalArgumentException();
        }
        return (char)(57344 + c);
    }
}

