// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from R7FA2E1A9.svd, see https://github.com/cmsis-svd/cmsis-svd-data/tree/master/data/Renesas

//go:build renesas && r7fa2e1a9

// Arm Cortex-M23 based Microcontroller RA2E1 device
//
//	This software is supplied by Renesas Electronics Corporation and is only intended for
//	use with Renesas products. No other uses are authorized. This software is owned by
//	Renesas Electronics Corporation and is protected under all applicable laws, including
//	copyright laws.
//
//	THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
//	THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT LIMITED TO
//	WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
//	ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED. TO THE MAXIMUM EXTENT PERMITTED NOT
//	PROHIBITED BY LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED
//	COMPANIES SHALL BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL
//	DAMAGES FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
//	BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//
//	Renesas reserves the right, without notice, to make changes to this software and to
//	discontinue the availability of this software. By using this software, you agree to
//	the additional terms and conditions found by accessing the following link:
//	http://www.renesas.com/disclaimer
//	\n
package renesas

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "R7FA2E1A9"
	CPU          = "CM23"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// ICU for CPU
	IRQ_IEL0 = 0

	// ICU for CPU
	IRQ_IEL1 = 1

	// ICU for CPU
	IRQ_IEL2 = 2

	// ICU for CPU
	IRQ_IEL3 = 3

	// ICU for CPU
	IRQ_IEL4 = 4

	// ICU for CPU
	IRQ_IEL5 = 5

	// ICU for CPU
	IRQ_IEL6 = 6

	// ICU for CPU
	IRQ_IEL7 = 7

	// ICU for CPU
	IRQ_IEL8 = 8

	// ICU for CPU
	IRQ_IEL9 = 9

	// ICU for CPU
	IRQ_IEL10 = 10

	// ICU for CPU
	IRQ_IEL11 = 11

	// ICU for CPU
	IRQ_IEL12 = 12

	// ICU for CPU
	IRQ_IEL13 = 13

	// ICU for CPU
	IRQ_IEL14 = 14

	// ICU for CPU
	IRQ_IEL15 = 15

	// ICU for CPU
	IRQ_IEL16 = 16

	// ICU for CPU
	IRQ_IEL17 = 17

	// ICU for CPU
	IRQ_IEL18 = 18

	// ICU for CPU
	IRQ_IEL19 = 19

	// ICU for CPU
	IRQ_IEL20 = 20

	// ICU for CPU
	IRQ_IEL21 = 21

	// ICU for CPU
	IRQ_IEL22 = 22

	// ICU for CPU
	IRQ_IEL23 = 23

	// ICU for CPU
	IRQ_IEL24 = 24

	// ICU for CPU
	IRQ_IEL25 = 25

	// ICU for CPU
	IRQ_IEL26 = 26

	// ICU for CPU
	IRQ_IEL27 = 27

	// ICU for CPU
	IRQ_IEL28 = 28

	// ICU for CPU
	IRQ_IEL29 = 29

	// ICU for CPU
	IRQ_IEL30 = 30

	// ICU for CPU
	IRQ_IEL31 = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export IEL0_IRQHandler
func interruptIEL0() {
	callHandlers(IRQ_IEL0)
}

//export IEL1_IRQHandler
func interruptIEL1() {
	callHandlers(IRQ_IEL1)
}

//export IEL2_IRQHandler
func interruptIEL2() {
	callHandlers(IRQ_IEL2)
}

//export IEL3_IRQHandler
func interruptIEL3() {
	callHandlers(IRQ_IEL3)
}

//export IEL4_IRQHandler
func interruptIEL4() {
	callHandlers(IRQ_IEL4)
}

//export IEL5_IRQHandler
func interruptIEL5() {
	callHandlers(IRQ_IEL5)
}

//export IEL6_IRQHandler
func interruptIEL6() {
	callHandlers(IRQ_IEL6)
}

//export IEL7_IRQHandler
func interruptIEL7() {
	callHandlers(IRQ_IEL7)
}

//export IEL8_IRQHandler
func interruptIEL8() {
	callHandlers(IRQ_IEL8)
}

//export IEL9_IRQHandler
func interruptIEL9() {
	callHandlers(IRQ_IEL9)
}

//export IEL10_IRQHandler
func interruptIEL10() {
	callHandlers(IRQ_IEL10)
}

//export IEL11_IRQHandler
func interruptIEL11() {
	callHandlers(IRQ_IEL11)
}

//export IEL12_IRQHandler
func interruptIEL12() {
	callHandlers(IRQ_IEL12)
}

//export IEL13_IRQHandler
func interruptIEL13() {
	callHandlers(IRQ_IEL13)
}

//export IEL14_IRQHandler
func interruptIEL14() {
	callHandlers(IRQ_IEL14)
}

//export IEL15_IRQHandler
func interruptIEL15() {
	callHandlers(IRQ_IEL15)
}

//export IEL16_IRQHandler
func interruptIEL16() {
	callHandlers(IRQ_IEL16)
}

//export IEL17_IRQHandler
func interruptIEL17() {
	callHandlers(IRQ_IEL17)
}

//export IEL18_IRQHandler
func interruptIEL18() {
	callHandlers(IRQ_IEL18)
}

//export IEL19_IRQHandler
func interruptIEL19() {
	callHandlers(IRQ_IEL19)
}

//export IEL20_IRQHandler
func interruptIEL20() {
	callHandlers(IRQ_IEL20)
}

//export IEL21_IRQHandler
func interruptIEL21() {
	callHandlers(IRQ_IEL21)
}

//export IEL22_IRQHandler
func interruptIEL22() {
	callHandlers(IRQ_IEL22)
}

//export IEL23_IRQHandler
func interruptIEL23() {
	callHandlers(IRQ_IEL23)
}

//export IEL24_IRQHandler
func interruptIEL24() {
	callHandlers(IRQ_IEL24)
}

//export IEL25_IRQHandler
func interruptIEL25() {
	callHandlers(IRQ_IEL25)
}

//export IEL26_IRQHandler
func interruptIEL26() {
	callHandlers(IRQ_IEL26)
}

//export IEL27_IRQHandler
func interruptIEL27() {
	callHandlers(IRQ_IEL27)
}

//export IEL28_IRQHandler
func interruptIEL28() {
	callHandlers(IRQ_IEL28)
}

//export IEL29_IRQHandler
func interruptIEL29() {
	callHandlers(IRQ_IEL29)
}

//export IEL30_IRQHandler
func interruptIEL30() {
	callHandlers(IRQ_IEL30)
}

//export IEL31_IRQHandler
func interruptIEL31() {
	callHandlers(IRQ_IEL31)
}

// Peripherals.
var (
	// Renesas Memory Protection Unit
	RMPU = (*RMPU_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// SRAM Control
	SRAM = (*SRAM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// BUS Control
	BUS = (*BUS_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Data Transfer Controller
	DTC = (*DTC_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// ICU for CPU
	ICU = (*ICU_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Debug Function
	DBG = (*DBG_Type)(unsafe.Pointer(uintptr(0x4001b000)))

	// System Control
	SYSC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x4001e000)))

	// Port 0 Control Registers
	PORT0 = (*PORT0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// Port 1 Control Registers
	PORT1 = (*PORT1_Type)(unsafe.Pointer(uintptr(0x40040020)))

	// Port 2 Control Registers
	PORT2 = (*PORT1_Type)(unsafe.Pointer(uintptr(0x40040040)))

	// Port 3 Control Registers
	PORT3 = (*PORT0_Type)(unsafe.Pointer(uintptr(0x40040060)))

	// Port 4 Control Registers
	PORT4 = (*PORT0_Type)(unsafe.Pointer(uintptr(0x40040080)))

	// Port 5 Control Registers
	PORT5 = (*PORT0_Type)(unsafe.Pointer(uintptr(0x400400a0)))

	// Port 9 Control Registers
	PORT9 = (*PORT0_Type)(unsafe.Pointer(uintptr(0x40040120)))

	// Pmn Pin Function Control Register
	PFS = (*PFS_Type)(unsafe.Pointer(uintptr(0x40040800)))

	// Event Link Controller
	ELC = (*ELC_Type)(unsafe.Pointer(uintptr(0x40041000)))

	// Port Output Enable Module for GPT
	POEG = (*POEG_Type)(unsafe.Pointer(uintptr(0x40042000)))

	// Realtime Clock
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40044000)))

	// Watchdog Timer
	WDT = (*WDT_Type)(unsafe.Pointer(uintptr(0x40044200)))

	// Independent Watchdog Timer
	IWDT = (*IWDT_Type)(unsafe.Pointer(uintptr(0x40044400)))

	// Clock Frequency Accuracy Measurement Circuit
	CAC = (*CAC_Type)(unsafe.Pointer(uintptr(0x40044600)))

	// Module Stop Control B, C, D
	MSTP = (*MSTP_Type)(unsafe.Pointer(uintptr(0x40047000)))

	// Inter-Integrated Circuit 0
	IIC0 = (*IIC0_Type)(unsafe.Pointer(uintptr(0x40053000)))

	// Inter-Integrated Circuit 0 Wake-up Unit
	IIC0WU = (*IIC0WU_Type)(unsafe.Pointer(uintptr(0x40053014)))

	// Data Operation Circuit
	DOC = (*DOC_Type)(unsafe.Pointer(uintptr(0x40054100)))

	// 12-bit A/D Converter
	ADC120 = (*ADC120_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// Serial Communication Interface 0
	SCI0 = (*SCI0_Type)(unsafe.Pointer(uintptr(0x40070000)))

	// Serial Communication Interface 0
	SCI1 = (*SCI1_Type)(unsafe.Pointer(uintptr(0x40070020)))

	// Serial Communication Interface 0
	SCI2 = (*SCI1_Type)(unsafe.Pointer(uintptr(0x40070040)))

	// Serial Communication Interface 0
	SCI9 = (*SCI1_Type)(unsafe.Pointer(uintptr(0x40070120)))

	// Serial Peripheral Interface
	SPI0 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x40072000)))

	// Cyclic Redundancy Check Calculator
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40074000)))

	// General PWM 32-bit Timer 0
	GPT320 = (*GPT320_Type)(unsafe.Pointer(uintptr(0x40078000)))

	// General PWM 16-bit Timer 4
	GPT164 = (*GPT164_Type)(unsafe.Pointer(uintptr(0x40078400)))

	// General PWM 16-bit Timer 5
	GPT165 = (*GPT164_Type)(unsafe.Pointer(uintptr(0x40078500)))

	// General PWM 16-bit Timer 6
	GPT166 = (*GPT164_Type)(unsafe.Pointer(uintptr(0x40078600)))

	// General PWM 16-bit Timer 7
	GPT167 = (*GPT164_Type)(unsafe.Pointer(uintptr(0x40078700)))

	// General PWM 16-bit Timer 8
	GPT168 = (*GPT164_Type)(unsafe.Pointer(uintptr(0x40078800)))

	// General PWM 16-bit Timer 9
	GPT169 = (*GPT164_Type)(unsafe.Pointer(uintptr(0x40078900)))

	// Output Phase Switching Controller
	GPT_OPS = (*GPT_OPS_Type)(unsafe.Pointer(uintptr(0x40078ff0)))

	// Key Interrupt Function
	KINT = (*KINT_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// Capacitive Touch Sensing Unit
	CTSU = (*CTSU_Type)(unsafe.Pointer(uintptr(0x40082000)))

	// Low Power Asynchronous General Purpose Timer 0
	AGT0 = (*AGT0_Type)(unsafe.Pointer(uintptr(0x40084000)))

	// Low Power Asynchronous General Purpose Timer 1
	AGT1 = (*AGT0_Type)(unsafe.Pointer(uintptr(0x40084100)))

	// Low-Power Analog Comparator
	ACMPLP = (*ACMPLP_Type)(unsafe.Pointer(uintptr(0x40085e00)))

	// Flash I/O Registers
	FLCN = (*FLCN_Type)(unsafe.Pointer(uintptr(0x407ec000)))
)

// Renesas Memory Protection Unit
type RMPU_Type struct {
	MMPUCTLA  volatile.Register16 // 0x0
	_         [256]byte
	MMPUPTA   volatile.Register16 // 0x102
	_         [252]byte
	MMPUACA0  volatile.Register16 // 0x200
	_         [2]byte
	MMPUSA0   volatile.Register32 // 0x204
	MMPUEA0   volatile.Register32 // 0x208
	_         [4]byte
	MMPUACA1  volatile.Register16 // 0x210
	_         [2]byte
	MMPUSA1   volatile.Register32 // 0x214
	MMPUEA1   volatile.Register32 // 0x218
	_         [4]byte
	MMPUACA2  volatile.Register16 // 0x220
	_         [2]byte
	MMPUSA2   volatile.Register32 // 0x224
	MMPUEA2   volatile.Register32 // 0x228
	_         [4]byte
	MMPUACA3  volatile.Register16 // 0x230
	_         [2]byte
	MMPUSA3   volatile.Register32 // 0x234
	MMPUEA3   volatile.Register32 // 0x238
	_         [2500]byte
	SMPUCTL   volatile.Register16 // 0xC00
	_         [14]byte
	SMPUMBIU  volatile.Register16 // 0xC10
	_         [2]byte
	SMPUFBIU  volatile.Register16 // 0xC14
	_         [2]byte
	SMPUSRAM0 volatile.Register16 // 0xC18
	_         [6]byte
	SMPUP0BIU volatile.Register16 // 0xC20
	_         [2]byte
	SMPUP2BIU volatile.Register16 // 0xC24
	_         [2]byte
	SMPUP6BIU volatile.Register16 // 0xC28
	_         [214]byte
	MSPMPUOAD volatile.Register16 // 0xD00
	_         [2]byte
	MSPMPUCTL volatile.Register16 // 0xD04
	MSPMPUPT  volatile.Register16 // 0xD06
	MSPMPUSA  volatile.Register32 // 0xD08
	MSPMPUEA  volatile.Register32 // 0xD0C
	PSPMPUOAD volatile.Register16 // 0xD10
	_         [2]byte
	PSPMPUCTL volatile.Register16 // 0xD14
	PSPMPUPT  volatile.Register16 // 0xD16
	PSPMPUSA  volatile.Register32 // 0xD18
	PSPMPUEA  volatile.Register32 // 0xD1C
}

// RMPU.MMPUCTLA: Bus Master MPU Control Register
func (o *RMPU_Type) SetMMPUCTLA_ENABLE(value uint16) {
	volatile.StoreUint16(&o.MMPUCTLA.Reg, volatile.LoadUint16(&o.MMPUCTLA.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMMPUCTLA_ENABLE() uint16 {
	return volatile.LoadUint16(&o.MMPUCTLA.Reg) & 0x1
}
func (o *RMPU_Type) SetMMPUCTLA_OAD(value uint16) {
	volatile.StoreUint16(&o.MMPUCTLA.Reg, volatile.LoadUint16(&o.MMPUCTLA.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetMMPUCTLA_OAD() uint16 {
	return (volatile.LoadUint16(&o.MMPUCTLA.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetMMPUCTLA_KEY(value uint16) {
	volatile.StoreUint16(&o.MMPUCTLA.Reg, volatile.LoadUint16(&o.MMPUCTLA.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetMMPUCTLA_KEY() uint16 {
	return (volatile.LoadUint16(&o.MMPUCTLA.Reg) & 0xff00) >> 8
}

// RMPU.MMPUPTA: Group A Protection of Register
func (o *RMPU_Type) SetMMPUPTA_PROTECT(value uint16) {
	volatile.StoreUint16(&o.MMPUPTA.Reg, volatile.LoadUint16(&o.MMPUPTA.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMMPUPTA_PROTECT() uint16 {
	return volatile.LoadUint16(&o.MMPUPTA.Reg) & 0x1
}
func (o *RMPU_Type) SetMMPUPTA_KEY(value uint16) {
	volatile.StoreUint16(&o.MMPUPTA.Reg, volatile.LoadUint16(&o.MMPUPTA.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetMMPUPTA_KEY() uint16 {
	return (volatile.LoadUint16(&o.MMPUPTA.Reg) & 0xff00) >> 8
}

// RMPU.MMPUACA0: Group A Region %s access control register
func (o *RMPU_Type) SetMMPUACA0_ENABLE(value uint16) {
	volatile.StoreUint16(&o.MMPUACA0.Reg, volatile.LoadUint16(&o.MMPUACA0.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMMPUACA0_ENABLE() uint16 {
	return volatile.LoadUint16(&o.MMPUACA0.Reg) & 0x1
}
func (o *RMPU_Type) SetMMPUACA0_RP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA0.Reg, volatile.LoadUint16(&o.MMPUACA0.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetMMPUACA0_RP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA0.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetMMPUACA0_WP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA0.Reg, volatile.LoadUint16(&o.MMPUACA0.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetMMPUACA0_WP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA0.Reg) & 0x4) >> 2
}

// RMPU.MMPUSA0: Group A Region %s Start Address Register
func (o *RMPU_Type) SetMMPUSA0(value uint32) {
	volatile.StoreUint32(&o.MMPUSA0.Reg, value)
}
func (o *RMPU_Type) GetMMPUSA0() uint32 {
	return volatile.LoadUint32(&o.MMPUSA0.Reg)
}

// RMPU.MMPUEA0: Group A Region %s End Address Register
func (o *RMPU_Type) SetMMPUEA0(value uint32) {
	volatile.StoreUint32(&o.MMPUEA0.Reg, value)
}
func (o *RMPU_Type) GetMMPUEA0() uint32 {
	return volatile.LoadUint32(&o.MMPUEA0.Reg)
}

// RMPU.MMPUACA1: Group A Region %s access control register
func (o *RMPU_Type) SetMMPUACA1_ENABLE(value uint16) {
	volatile.StoreUint16(&o.MMPUACA1.Reg, volatile.LoadUint16(&o.MMPUACA1.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMMPUACA1_ENABLE() uint16 {
	return volatile.LoadUint16(&o.MMPUACA1.Reg) & 0x1
}
func (o *RMPU_Type) SetMMPUACA1_RP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA1.Reg, volatile.LoadUint16(&o.MMPUACA1.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetMMPUACA1_RP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA1.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetMMPUACA1_WP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA1.Reg, volatile.LoadUint16(&o.MMPUACA1.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetMMPUACA1_WP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA1.Reg) & 0x4) >> 2
}

// RMPU.MMPUSA1: Group A Region %s Start Address Register
func (o *RMPU_Type) SetMMPUSA1(value uint32) {
	volatile.StoreUint32(&o.MMPUSA1.Reg, value)
}
func (o *RMPU_Type) GetMMPUSA1() uint32 {
	return volatile.LoadUint32(&o.MMPUSA1.Reg)
}

// RMPU.MMPUEA1: Group A Region %s End Address Register
func (o *RMPU_Type) SetMMPUEA1(value uint32) {
	volatile.StoreUint32(&o.MMPUEA1.Reg, value)
}
func (o *RMPU_Type) GetMMPUEA1() uint32 {
	return volatile.LoadUint32(&o.MMPUEA1.Reg)
}

// RMPU.MMPUACA2: Group A Region %s access control register
func (o *RMPU_Type) SetMMPUACA2_ENABLE(value uint16) {
	volatile.StoreUint16(&o.MMPUACA2.Reg, volatile.LoadUint16(&o.MMPUACA2.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMMPUACA2_ENABLE() uint16 {
	return volatile.LoadUint16(&o.MMPUACA2.Reg) & 0x1
}
func (o *RMPU_Type) SetMMPUACA2_RP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA2.Reg, volatile.LoadUint16(&o.MMPUACA2.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetMMPUACA2_RP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA2.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetMMPUACA2_WP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA2.Reg, volatile.LoadUint16(&o.MMPUACA2.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetMMPUACA2_WP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA2.Reg) & 0x4) >> 2
}

// RMPU.MMPUSA2: Group A Region %s Start Address Register
func (o *RMPU_Type) SetMMPUSA2(value uint32) {
	volatile.StoreUint32(&o.MMPUSA2.Reg, value)
}
func (o *RMPU_Type) GetMMPUSA2() uint32 {
	return volatile.LoadUint32(&o.MMPUSA2.Reg)
}

// RMPU.MMPUEA2: Group A Region %s End Address Register
func (o *RMPU_Type) SetMMPUEA2(value uint32) {
	volatile.StoreUint32(&o.MMPUEA2.Reg, value)
}
func (o *RMPU_Type) GetMMPUEA2() uint32 {
	return volatile.LoadUint32(&o.MMPUEA2.Reg)
}

// RMPU.MMPUACA3: Group A Region %s access control register
func (o *RMPU_Type) SetMMPUACA3_ENABLE(value uint16) {
	volatile.StoreUint16(&o.MMPUACA3.Reg, volatile.LoadUint16(&o.MMPUACA3.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMMPUACA3_ENABLE() uint16 {
	return volatile.LoadUint16(&o.MMPUACA3.Reg) & 0x1
}
func (o *RMPU_Type) SetMMPUACA3_RP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA3.Reg, volatile.LoadUint16(&o.MMPUACA3.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetMMPUACA3_RP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA3.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetMMPUACA3_WP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA3.Reg, volatile.LoadUint16(&o.MMPUACA3.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetMMPUACA3_WP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA3.Reg) & 0x4) >> 2
}

// RMPU.MMPUSA3: Group A Region %s Start Address Register
func (o *RMPU_Type) SetMMPUSA3(value uint32) {
	volatile.StoreUint32(&o.MMPUSA3.Reg, value)
}
func (o *RMPU_Type) GetMMPUSA3() uint32 {
	return volatile.LoadUint32(&o.MMPUSA3.Reg)
}

// RMPU.MMPUEA3: Group A Region %s End Address Register
func (o *RMPU_Type) SetMMPUEA3(value uint32) {
	volatile.StoreUint32(&o.MMPUEA3.Reg, value)
}
func (o *RMPU_Type) GetMMPUEA3() uint32 {
	return volatile.LoadUint32(&o.MMPUEA3.Reg)
}

// RMPU.SMPUCTL: Slave MPU Control Register
func (o *RMPU_Type) SetSMPUCTL_OAD(value uint16) {
	volatile.StoreUint16(&o.SMPUCTL.Reg, volatile.LoadUint16(&o.SMPUCTL.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetSMPUCTL_OAD() uint16 {
	return volatile.LoadUint16(&o.SMPUCTL.Reg) & 0x1
}
func (o *RMPU_Type) SetSMPUCTL_PROTECT(value uint16) {
	volatile.StoreUint16(&o.SMPUCTL.Reg, volatile.LoadUint16(&o.SMPUCTL.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetSMPUCTL_PROTECT() uint16 {
	return (volatile.LoadUint16(&o.SMPUCTL.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetSMPUCTL_KEY(value uint16) {
	volatile.StoreUint16(&o.SMPUCTL.Reg, volatile.LoadUint16(&o.SMPUCTL.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetSMPUCTL_KEY() uint16 {
	return (volatile.LoadUint16(&o.SMPUCTL.Reg) & 0xff00) >> 8
}

// RMPU.SMPUMBIU: Access Control Register for Memory Bus 1
func (o *RMPU_Type) SetSMPUMBIU_RPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUMBIU.Reg, volatile.LoadUint16(&o.SMPUMBIU.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetSMPUMBIU_RPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUMBIU.Reg) & 0x4) >> 2
}
func (o *RMPU_Type) SetSMPUMBIU_WPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUMBIU.Reg, volatile.LoadUint16(&o.SMPUMBIU.Reg)&^(0x8)|value<<3)
}
func (o *RMPU_Type) GetSMPUMBIU_WPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUMBIU.Reg) & 0x8) >> 3
}

// RMPU.SMPUFBIU: Access Control Register for Internal Peripheral Bus 9
func (o *RMPU_Type) SetSMPUFBIU_RPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUFBIU.Reg, volatile.LoadUint16(&o.SMPUFBIU.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetSMPUFBIU_RPCPU() uint16 {
	return volatile.LoadUint16(&o.SMPUFBIU.Reg) & 0x1
}
func (o *RMPU_Type) SetSMPUFBIU_WPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUFBIU.Reg, volatile.LoadUint16(&o.SMPUFBIU.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetSMPUFBIU_WPCPU() uint16 {
	return (volatile.LoadUint16(&o.SMPUFBIU.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetSMPUFBIU_RPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUFBIU.Reg, volatile.LoadUint16(&o.SMPUFBIU.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetSMPUFBIU_RPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUFBIU.Reg) & 0x4) >> 2
}
func (o *RMPU_Type) SetSMPUFBIU_WPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUFBIU.Reg, volatile.LoadUint16(&o.SMPUFBIU.Reg)&^(0x8)|value<<3)
}
func (o *RMPU_Type) GetSMPUFBIU_WPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUFBIU.Reg) & 0x8) >> 3
}

// RMPU.SMPUSRAM0: Access Control Register for Memory Bus 4
func (o *RMPU_Type) SetSMPUSRAM0_RPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUSRAM0.Reg, volatile.LoadUint16(&o.SMPUSRAM0.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetSMPUSRAM0_RPCPU() uint16 {
	return volatile.LoadUint16(&o.SMPUSRAM0.Reg) & 0x1
}
func (o *RMPU_Type) SetSMPUSRAM0_WPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUSRAM0.Reg, volatile.LoadUint16(&o.SMPUSRAM0.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetSMPUSRAM0_WPCPU() uint16 {
	return (volatile.LoadUint16(&o.SMPUSRAM0.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetSMPUSRAM0_RPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUSRAM0.Reg, volatile.LoadUint16(&o.SMPUSRAM0.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetSMPUSRAM0_RPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUSRAM0.Reg) & 0x4) >> 2
}
func (o *RMPU_Type) SetSMPUSRAM0_WPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUSRAM0.Reg, volatile.LoadUint16(&o.SMPUSRAM0.Reg)&^(0x8)|value<<3)
}
func (o *RMPU_Type) GetSMPUSRAM0_WPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUSRAM0.Reg) & 0x8) >> 3
}

// RMPU.SMPUP0BIU: Access Control Register for Internal Peripheral Bus 1
func (o *RMPU_Type) SetSMPUP0BIU_RPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUP0BIU.Reg, volatile.LoadUint16(&o.SMPUP0BIU.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetSMPUP0BIU_RPCPU() uint16 {
	return volatile.LoadUint16(&o.SMPUP0BIU.Reg) & 0x1
}
func (o *RMPU_Type) SetSMPUP0BIU_WPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUP0BIU.Reg, volatile.LoadUint16(&o.SMPUP0BIU.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetSMPUP0BIU_WPCPU() uint16 {
	return (volatile.LoadUint16(&o.SMPUP0BIU.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetSMPUP0BIU_RPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUP0BIU.Reg, volatile.LoadUint16(&o.SMPUP0BIU.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetSMPUP0BIU_RPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUP0BIU.Reg) & 0x4) >> 2
}
func (o *RMPU_Type) SetSMPUP0BIU_WPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUP0BIU.Reg, volatile.LoadUint16(&o.SMPUP0BIU.Reg)&^(0x8)|value<<3)
}
func (o *RMPU_Type) GetSMPUP0BIU_WPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUP0BIU.Reg) & 0x8) >> 3
}

// RMPU.SMPUP2BIU: Access Control Register for Internal Peripheral Bus 3
func (o *RMPU_Type) SetSMPUP2BIU_RPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUP2BIU.Reg, volatile.LoadUint16(&o.SMPUP2BIU.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetSMPUP2BIU_RPCPU() uint16 {
	return volatile.LoadUint16(&o.SMPUP2BIU.Reg) & 0x1
}
func (o *RMPU_Type) SetSMPUP2BIU_WPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUP2BIU.Reg, volatile.LoadUint16(&o.SMPUP2BIU.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetSMPUP2BIU_WPCPU() uint16 {
	return (volatile.LoadUint16(&o.SMPUP2BIU.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetSMPUP2BIU_RPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUP2BIU.Reg, volatile.LoadUint16(&o.SMPUP2BIU.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetSMPUP2BIU_RPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUP2BIU.Reg) & 0x4) >> 2
}
func (o *RMPU_Type) SetSMPUP2BIU_WPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUP2BIU.Reg, volatile.LoadUint16(&o.SMPUP2BIU.Reg)&^(0x8)|value<<3)
}
func (o *RMPU_Type) GetSMPUP2BIU_WPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUP2BIU.Reg) & 0x8) >> 3
}

// RMPU.SMPUP6BIU: Access Control Register for Internal Peripheral Bus 7
func (o *RMPU_Type) SetSMPUP6BIU_RPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUP6BIU.Reg, volatile.LoadUint16(&o.SMPUP6BIU.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetSMPUP6BIU_RPCPU() uint16 {
	return volatile.LoadUint16(&o.SMPUP6BIU.Reg) & 0x1
}
func (o *RMPU_Type) SetSMPUP6BIU_WPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUP6BIU.Reg, volatile.LoadUint16(&o.SMPUP6BIU.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetSMPUP6BIU_WPCPU() uint16 {
	return (volatile.LoadUint16(&o.SMPUP6BIU.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetSMPUP6BIU_RPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUP6BIU.Reg, volatile.LoadUint16(&o.SMPUP6BIU.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetSMPUP6BIU_RPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUP6BIU.Reg) & 0x4) >> 2
}
func (o *RMPU_Type) SetSMPUP6BIU_WPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUP6BIU.Reg, volatile.LoadUint16(&o.SMPUP6BIU.Reg)&^(0x8)|value<<3)
}
func (o *RMPU_Type) GetSMPUP6BIU_WPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUP6BIU.Reg) & 0x8) >> 3
}

// RMPU.MSPMPUOAD: Stack Pointer Monitor Operation After Detection Register
func (o *RMPU_Type) SetMSPMPUOAD_OAD(value uint16) {
	volatile.StoreUint16(&o.MSPMPUOAD.Reg, volatile.LoadUint16(&o.MSPMPUOAD.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMSPMPUOAD_OAD() uint16 {
	return volatile.LoadUint16(&o.MSPMPUOAD.Reg) & 0x1
}
func (o *RMPU_Type) SetMSPMPUOAD_KEY(value uint16) {
	volatile.StoreUint16(&o.MSPMPUOAD.Reg, volatile.LoadUint16(&o.MSPMPUOAD.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetMSPMPUOAD_KEY() uint16 {
	return (volatile.LoadUint16(&o.MSPMPUOAD.Reg) & 0xff00) >> 8
}

// RMPU.MSPMPUCTL: Stack Pointer Monitor Access Control Register
func (o *RMPU_Type) SetMSPMPUCTL_ENABLE(value uint16) {
	volatile.StoreUint16(&o.MSPMPUCTL.Reg, volatile.LoadUint16(&o.MSPMPUCTL.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMSPMPUCTL_ENABLE() uint16 {
	return volatile.LoadUint16(&o.MSPMPUCTL.Reg) & 0x1
}
func (o *RMPU_Type) SetMSPMPUCTL_ERROR(value uint16) {
	volatile.StoreUint16(&o.MSPMPUCTL.Reg, volatile.LoadUint16(&o.MSPMPUCTL.Reg)&^(0x100)|value<<8)
}
func (o *RMPU_Type) GetMSPMPUCTL_ERROR() uint16 {
	return (volatile.LoadUint16(&o.MSPMPUCTL.Reg) & 0x100) >> 8
}

// RMPU.MSPMPUPT: Stack Pointer Monitor Protection Register
func (o *RMPU_Type) SetMSPMPUPT_PROTECT(value uint16) {
	volatile.StoreUint16(&o.MSPMPUPT.Reg, volatile.LoadUint16(&o.MSPMPUPT.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMSPMPUPT_PROTECT() uint16 {
	return volatile.LoadUint16(&o.MSPMPUPT.Reg) & 0x1
}
func (o *RMPU_Type) SetMSPMPUPT_KEY(value uint16) {
	volatile.StoreUint16(&o.MSPMPUPT.Reg, volatile.LoadUint16(&o.MSPMPUPT.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetMSPMPUPT_KEY() uint16 {
	return (volatile.LoadUint16(&o.MSPMPUPT.Reg) & 0xff00) >> 8
}

// RMPU.MSPMPUSA: Main Stack Pointer (MSP) Monitor Start Address Register
func (o *RMPU_Type) SetMSPMPUSA(value uint32) {
	volatile.StoreUint32(&o.MSPMPUSA.Reg, value)
}
func (o *RMPU_Type) GetMSPMPUSA() uint32 {
	return volatile.LoadUint32(&o.MSPMPUSA.Reg)
}

// RMPU.MSPMPUEA: Main Stack Pointer (MSP) Monitor End Address Register
func (o *RMPU_Type) SetMSPMPUEA(value uint32) {
	volatile.StoreUint32(&o.MSPMPUEA.Reg, value)
}
func (o *RMPU_Type) GetMSPMPUEA() uint32 {
	return volatile.LoadUint32(&o.MSPMPUEA.Reg)
}

// RMPU.PSPMPUOAD: Stack Pointer Monitor Operation After Detection Register
func (o *RMPU_Type) SetPSPMPUOAD_OAD(value uint16) {
	volatile.StoreUint16(&o.PSPMPUOAD.Reg, volatile.LoadUint16(&o.PSPMPUOAD.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetPSPMPUOAD_OAD() uint16 {
	return volatile.LoadUint16(&o.PSPMPUOAD.Reg) & 0x1
}
func (o *RMPU_Type) SetPSPMPUOAD_KEY(value uint16) {
	volatile.StoreUint16(&o.PSPMPUOAD.Reg, volatile.LoadUint16(&o.PSPMPUOAD.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetPSPMPUOAD_KEY() uint16 {
	return (volatile.LoadUint16(&o.PSPMPUOAD.Reg) & 0xff00) >> 8
}

// RMPU.PSPMPUCTL: Stack Pointer Monitor Access Control Register
func (o *RMPU_Type) SetPSPMPUCTL_ENABLE(value uint16) {
	volatile.StoreUint16(&o.PSPMPUCTL.Reg, volatile.LoadUint16(&o.PSPMPUCTL.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetPSPMPUCTL_ENABLE() uint16 {
	return volatile.LoadUint16(&o.PSPMPUCTL.Reg) & 0x1
}
func (o *RMPU_Type) SetPSPMPUCTL_ERROR(value uint16) {
	volatile.StoreUint16(&o.PSPMPUCTL.Reg, volatile.LoadUint16(&o.PSPMPUCTL.Reg)&^(0x100)|value<<8)
}
func (o *RMPU_Type) GetPSPMPUCTL_ERROR() uint16 {
	return (volatile.LoadUint16(&o.PSPMPUCTL.Reg) & 0x100) >> 8
}

// RMPU.PSPMPUPT: Stack Pointer Monitor Protection Register
func (o *RMPU_Type) SetPSPMPUPT_PROTECT(value uint16) {
	volatile.StoreUint16(&o.PSPMPUPT.Reg, volatile.LoadUint16(&o.PSPMPUPT.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetPSPMPUPT_PROTECT() uint16 {
	return volatile.LoadUint16(&o.PSPMPUPT.Reg) & 0x1
}
func (o *RMPU_Type) SetPSPMPUPT_KEY(value uint16) {
	volatile.StoreUint16(&o.PSPMPUPT.Reg, volatile.LoadUint16(&o.PSPMPUPT.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetPSPMPUPT_KEY() uint16 {
	return (volatile.LoadUint16(&o.PSPMPUPT.Reg) & 0xff00) >> 8
}

// RMPU.PSPMPUSA: Process Stack Pointer (PSP) Monitor Start Address Register
func (o *RMPU_Type) SetPSPMPUSA(value uint32) {
	volatile.StoreUint32(&o.PSPMPUSA.Reg, value)
}
func (o *RMPU_Type) GetPSPMPUSA() uint32 {
	return volatile.LoadUint32(&o.PSPMPUSA.Reg)
}

// RMPU.PSPMPUEA: Process Stack Pointer (PSP) Monitor End Address Register
func (o *RMPU_Type) SetPSPMPUEA(value uint32) {
	volatile.StoreUint32(&o.PSPMPUEA.Reg, value)
}
func (o *RMPU_Type) GetPSPMPUEA() uint32 {
	return volatile.LoadUint32(&o.PSPMPUEA.Reg)
}

// SRAM Control
type SRAM_Type struct {
	PARIOAD  volatile.Register8 // 0x0
	_        [3]byte
	SRAMPRCR volatile.Register8 // 0x4
}

// SRAM.PARIOAD: SRAM Parity Error Operation After Detection Register
func (o *SRAM_Type) SetPARIOAD_OAD(value uint8) {
	volatile.StoreUint8(&o.PARIOAD.Reg, volatile.LoadUint8(&o.PARIOAD.Reg)&^(0x1)|value)
}
func (o *SRAM_Type) GetPARIOAD_OAD() uint8 {
	return volatile.LoadUint8(&o.PARIOAD.Reg) & 0x1
}

// SRAM.SRAMPRCR: SRAM Protection Register
func (o *SRAM_Type) SetSRAMPRCR(value uint8) {
	volatile.StoreUint8(&o.SRAMPRCR.Reg, volatile.LoadUint8(&o.SRAMPRCR.Reg)&^(0x1)|value)
}
func (o *SRAM_Type) GetSRAMPRCR() uint8 {
	return volatile.LoadUint8(&o.SRAMPRCR.Reg) & 0x1
}
func (o *SRAM_Type) SetSRAMPRCR_KW(value uint8) {
	volatile.StoreUint8(&o.SRAMPRCR.Reg, volatile.LoadUint8(&o.SRAMPRCR.Reg)&^(0xfe)|value<<1)
}
func (o *SRAM_Type) GetSRAMPRCR_KW() uint8 {
	return (volatile.LoadUint8(&o.SRAMPRCR.Reg) & 0xfe) >> 1
}

// BUS Control
type BUS_Type struct {
	_           [4104]byte
	BUSMCNTSYS  volatile.Register16 // 0x1008
	_           [2]byte
	BUSMCNTDMA  volatile.Register16 // 0x100C
	_           [2066]byte
	BUS3ERRADD  volatile.Register32 // 0x1820
	BUS3ERRSTAT volatile.Register8  // 0x1824
	_           [11]byte
	BUS4ERRADD  volatile.Register32 // 0x1830
	BUS4ERRSTAT volatile.Register8  // 0x1834
}

// BUS.BUSMCNTSYS: Master Bus Control Register SYS
func (o *BUS_Type) SetBUSMCNTSYS_IERES(value uint16) {
	volatile.StoreUint16(&o.BUSMCNTSYS.Reg, volatile.LoadUint16(&o.BUSMCNTSYS.Reg)&^(0x8000)|value<<15)
}
func (o *BUS_Type) GetBUSMCNTSYS_IERES() uint16 {
	return (volatile.LoadUint16(&o.BUSMCNTSYS.Reg) & 0x8000) >> 15
}

// BUS.BUSMCNTDMA: Master Bus Control Register DMA
func (o *BUS_Type) SetBUSMCNTDMA_IERES(value uint16) {
	volatile.StoreUint16(&o.BUSMCNTDMA.Reg, volatile.LoadUint16(&o.BUSMCNTDMA.Reg)&^(0x8000)|value<<15)
}
func (o *BUS_Type) GetBUSMCNTDMA_IERES() uint16 {
	return (volatile.LoadUint16(&o.BUSMCNTDMA.Reg) & 0x8000) >> 15
}

// BUS.BUS3ERRADD: Bus Error Address Register 3
func (o *BUS_Type) SetBUS3ERRADD(value uint32) {
	volatile.StoreUint32(&o.BUS3ERRADD.Reg, value)
}
func (o *BUS_Type) GetBUS3ERRADD() uint32 {
	return volatile.LoadUint32(&o.BUS3ERRADD.Reg)
}

// BUS.BUS3ERRSTAT: BUS Error Status Register 3
func (o *BUS_Type) SetBUS3ERRSTAT_ACCSTAT(value uint8) {
	volatile.StoreUint8(&o.BUS3ERRSTAT.Reg, volatile.LoadUint8(&o.BUS3ERRSTAT.Reg)&^(0x1)|value)
}
func (o *BUS_Type) GetBUS3ERRSTAT_ACCSTAT() uint8 {
	return volatile.LoadUint8(&o.BUS3ERRSTAT.Reg) & 0x1
}
func (o *BUS_Type) SetBUS3ERRSTAT_ERRSTAT(value uint8) {
	volatile.StoreUint8(&o.BUS3ERRSTAT.Reg, volatile.LoadUint8(&o.BUS3ERRSTAT.Reg)&^(0x80)|value<<7)
}
func (o *BUS_Type) GetBUS3ERRSTAT_ERRSTAT() uint8 {
	return (volatile.LoadUint8(&o.BUS3ERRSTAT.Reg) & 0x80) >> 7
}

// BUS.BUS4ERRADD: Bus Error Address Register 4
func (o *BUS_Type) SetBUS4ERRADD(value uint32) {
	volatile.StoreUint32(&o.BUS4ERRADD.Reg, value)
}
func (o *BUS_Type) GetBUS4ERRADD() uint32 {
	return volatile.LoadUint32(&o.BUS4ERRADD.Reg)
}

// BUS.BUS4ERRSTAT: BUS Error Status Register 4
func (o *BUS_Type) SetBUS4ERRSTAT_ACCSTAT(value uint8) {
	volatile.StoreUint8(&o.BUS4ERRSTAT.Reg, volatile.LoadUint8(&o.BUS4ERRSTAT.Reg)&^(0x1)|value)
}
func (o *BUS_Type) GetBUS4ERRSTAT_ACCSTAT() uint8 {
	return volatile.LoadUint8(&o.BUS4ERRSTAT.Reg) & 0x1
}
func (o *BUS_Type) SetBUS4ERRSTAT_ERRSTAT(value uint8) {
	volatile.StoreUint8(&o.BUS4ERRSTAT.Reg, volatile.LoadUint8(&o.BUS4ERRSTAT.Reg)&^(0x80)|value<<7)
}
func (o *BUS_Type) GetBUS4ERRSTAT_ERRSTAT() uint8 {
	return (volatile.LoadUint8(&o.BUS4ERRSTAT.Reg) & 0x80) >> 7
}

// Data Transfer Controller
type DTC_Type struct {
	DTCCR  volatile.Register8 // 0x0
	_      [3]byte
	DTCVBR volatile.Register32 // 0x4
	_      [4]byte
	DTCST  volatile.Register8 // 0xC
	_      byte
	DTCSTS volatile.Register16 // 0xE
}

// DTC.DTCCR: DTC Control Register
func (o *DTC_Type) SetDTCCR_RRS(value uint8) {
	volatile.StoreUint8(&o.DTCCR.Reg, volatile.LoadUint8(&o.DTCCR.Reg)&^(0x10)|value<<4)
}
func (o *DTC_Type) GetDTCCR_RRS() uint8 {
	return (volatile.LoadUint8(&o.DTCCR.Reg) & 0x10) >> 4
}

// DTC.DTCST: DTC Module Start Register
func (o *DTC_Type) SetDTCST(value uint8) {
	volatile.StoreUint8(&o.DTCST.Reg, volatile.LoadUint8(&o.DTCST.Reg)&^(0x1)|value)
}
func (o *DTC_Type) GetDTCST() uint8 {
	return volatile.LoadUint8(&o.DTCST.Reg) & 0x1
}

// DTC.DTCSTS: DTC Status Register
func (o *DTC_Type) SetDTCSTS_VECN(value uint16) {
	volatile.StoreUint16(&o.DTCSTS.Reg, volatile.LoadUint16(&o.DTCSTS.Reg)&^(0xff)|value)
}
func (o *DTC_Type) GetDTCSTS_VECN() uint16 {
	return volatile.LoadUint16(&o.DTCSTS.Reg) & 0xff
}
func (o *DTC_Type) SetDTCSTS_ACT(value uint16) {
	volatile.StoreUint16(&o.DTCSTS.Reg, volatile.LoadUint16(&o.DTCSTS.Reg)&^(0x8000)|value<<15)
}
func (o *DTC_Type) GetDTCSTS_ACT() uint16 {
	return (volatile.LoadUint16(&o.DTCSTS.Reg) & 0x8000) >> 15
}

// ICU for CPU
type ICU_Type struct {
	IRQCR0  volatile.Register8 // 0x0
	IRQCR1  volatile.Register8 // 0x1
	IRQCR2  volatile.Register8 // 0x2
	IRQCR3  volatile.Register8 // 0x3
	IRQCR4  volatile.Register8 // 0x4
	IRQCR5  volatile.Register8 // 0x5
	IRQCR6  volatile.Register8 // 0x6
	IRQCR7  volatile.Register8 // 0x7
	_       [248]byte
	NMICR   volatile.Register8 // 0x100
	_       [31]byte
	NMIER   volatile.Register16 // 0x120
	_       [14]byte
	NMICLR  volatile.Register16 // 0x130
	_       [14]byte
	NMISR   volatile.Register16 // 0x140
	_       [94]byte
	WUPEN   volatile.Register32 // 0x1A0
	_       [28]byte
	IELEN   volatile.Register8 // 0x1C0
	_       [63]byte
	SELSR0  volatile.Register16 // 0x200
	_       [254]byte
	IELSR0  volatile.Register32 // 0x300
	IELSR1  volatile.Register32 // 0x304
	IELSR2  volatile.Register32 // 0x308
	IELSR3  volatile.Register32 // 0x30C
	IELSR4  volatile.Register32 // 0x310
	IELSR5  volatile.Register32 // 0x314
	IELSR6  volatile.Register32 // 0x318
	IELSR7  volatile.Register32 // 0x31C
	IELSR8  volatile.Register32 // 0x320
	IELSR9  volatile.Register32 // 0x324
	IELSR10 volatile.Register32 // 0x328
	IELSR11 volatile.Register32 // 0x32C
	IELSR12 volatile.Register32 // 0x330
	IELSR13 volatile.Register32 // 0x334
	IELSR14 volatile.Register32 // 0x338
	IELSR15 volatile.Register32 // 0x33C
	IELSR16 volatile.Register32 // 0x340
	IELSR17 volatile.Register32 // 0x344
	IELSR18 volatile.Register32 // 0x348
	IELSR19 volatile.Register32 // 0x34C
	IELSR20 volatile.Register32 // 0x350
	IELSR21 volatile.Register32 // 0x354
	IELSR22 volatile.Register32 // 0x358
	IELSR23 volatile.Register32 // 0x35C
	IELSR24 volatile.Register32 // 0x360
	IELSR25 volatile.Register32 // 0x364
	IELSR26 volatile.Register32 // 0x368
	IELSR27 volatile.Register32 // 0x36C
	IELSR28 volatile.Register32 // 0x370
	IELSR29 volatile.Register32 // 0x374
	IELSR30 volatile.Register32 // 0x378
	IELSR31 volatile.Register32 // 0x37C
}

// ICU.IRQCR0: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR0_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR0.Reg, volatile.LoadUint8(&o.IRQCR0.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR0_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR0.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR0_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR0.Reg, volatile.LoadUint8(&o.IRQCR0.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR0_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR0.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR0_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR0.Reg, volatile.LoadUint8(&o.IRQCR0.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR0_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR0.Reg) & 0x80) >> 7
}

// ICU.IRQCR1: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR1_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR1.Reg, volatile.LoadUint8(&o.IRQCR1.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR1_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR1.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR1_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR1.Reg, volatile.LoadUint8(&o.IRQCR1.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR1_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR1.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR1_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR1.Reg, volatile.LoadUint8(&o.IRQCR1.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR1_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR1.Reg) & 0x80) >> 7
}

// ICU.IRQCR2: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR2_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR2.Reg, volatile.LoadUint8(&o.IRQCR2.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR2_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR2.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR2_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR2.Reg, volatile.LoadUint8(&o.IRQCR2.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR2_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR2.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR2_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR2.Reg, volatile.LoadUint8(&o.IRQCR2.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR2_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR2.Reg) & 0x80) >> 7
}

// ICU.IRQCR3: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR3_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR3.Reg, volatile.LoadUint8(&o.IRQCR3.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR3_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR3.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR3_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR3.Reg, volatile.LoadUint8(&o.IRQCR3.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR3_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR3.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR3_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR3.Reg, volatile.LoadUint8(&o.IRQCR3.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR3_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR3.Reg) & 0x80) >> 7
}

// ICU.IRQCR4: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR4_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR4.Reg, volatile.LoadUint8(&o.IRQCR4.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR4_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR4.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR4_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR4.Reg, volatile.LoadUint8(&o.IRQCR4.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR4_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR4.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR4_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR4.Reg, volatile.LoadUint8(&o.IRQCR4.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR4_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR4.Reg) & 0x80) >> 7
}

// ICU.IRQCR5: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR5_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR5.Reg, volatile.LoadUint8(&o.IRQCR5.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR5_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR5.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR5_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR5.Reg, volatile.LoadUint8(&o.IRQCR5.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR5_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR5.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR5_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR5.Reg, volatile.LoadUint8(&o.IRQCR5.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR5_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR5.Reg) & 0x80) >> 7
}

// ICU.IRQCR6: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR6_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR6.Reg, volatile.LoadUint8(&o.IRQCR6.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR6_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR6.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR6_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR6.Reg, volatile.LoadUint8(&o.IRQCR6.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR6_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR6.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR6_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR6.Reg, volatile.LoadUint8(&o.IRQCR6.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR6_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR6.Reg) & 0x80) >> 7
}

// ICU.IRQCR7: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR7_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR7.Reg, volatile.LoadUint8(&o.IRQCR7.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR7_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR7.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR7_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR7.Reg, volatile.LoadUint8(&o.IRQCR7.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR7_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR7.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR7_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR7.Reg, volatile.LoadUint8(&o.IRQCR7.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR7_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR7.Reg) & 0x80) >> 7
}

// ICU.NMICR: NMI Pin Interrupt Control Register
func (o *ICU_Type) SetNMICR_NMIMD(value uint8) {
	volatile.StoreUint8(&o.NMICR.Reg, volatile.LoadUint8(&o.NMICR.Reg)&^(0x1)|value)
}
func (o *ICU_Type) GetNMICR_NMIMD() uint8 {
	return volatile.LoadUint8(&o.NMICR.Reg) & 0x1
}
func (o *ICU_Type) SetNMICR_NFCLKSEL(value uint8) {
	volatile.StoreUint8(&o.NMICR.Reg, volatile.LoadUint8(&o.NMICR.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetNMICR_NFCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.NMICR.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetNMICR_NFLTEN(value uint8) {
	volatile.StoreUint8(&o.NMICR.Reg, volatile.LoadUint8(&o.NMICR.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetNMICR_NFLTEN() uint8 {
	return (volatile.LoadUint8(&o.NMICR.Reg) & 0x80) >> 7
}

// ICU.NMIER: Non-Maskable Interrupt Enable Register
func (o *ICU_Type) SetNMIER_IWDTEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x1)|value)
}
func (o *ICU_Type) GetNMIER_IWDTEN() uint16 {
	return volatile.LoadUint16(&o.NMIER.Reg) & 0x1
}
func (o *ICU_Type) SetNMIER_WDTEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x2)|value<<1)
}
func (o *ICU_Type) GetNMIER_WDTEN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x2) >> 1
}
func (o *ICU_Type) SetNMIER_LVD1EN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x4)|value<<2)
}
func (o *ICU_Type) GetNMIER_LVD1EN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x4) >> 2
}
func (o *ICU_Type) SetNMIER_LVD2EN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x8)|value<<3)
}
func (o *ICU_Type) GetNMIER_LVD2EN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x8) >> 3
}
func (o *ICU_Type) SetNMIER_OSTEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x40)|value<<6)
}
func (o *ICU_Type) GetNMIER_OSTEN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x40) >> 6
}
func (o *ICU_Type) SetNMIER_NMIEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetNMIER_NMIEN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x80) >> 7
}
func (o *ICU_Type) SetNMIER_RPEEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x100)|value<<8)
}
func (o *ICU_Type) GetNMIER_RPEEN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x100) >> 8
}
func (o *ICU_Type) SetNMIER_BUSSEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x400)|value<<10)
}
func (o *ICU_Type) GetNMIER_BUSSEN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x400) >> 10
}
func (o *ICU_Type) SetNMIER_BUSMEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x800)|value<<11)
}
func (o *ICU_Type) GetNMIER_BUSMEN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x800) >> 11
}
func (o *ICU_Type) SetNMIER_SPEEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x1000)|value<<12)
}
func (o *ICU_Type) GetNMIER_SPEEN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x1000) >> 12
}

// ICU.NMICLR: Non-Maskable Interrupt Status Clear Register
func (o *ICU_Type) SetNMICLR_IWDTCLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x1)|value)
}
func (o *ICU_Type) GetNMICLR_IWDTCLR() uint16 {
	return volatile.LoadUint16(&o.NMICLR.Reg) & 0x1
}
func (o *ICU_Type) SetNMICLR_WDTCLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x2)|value<<1)
}
func (o *ICU_Type) GetNMICLR_WDTCLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x2) >> 1
}
func (o *ICU_Type) SetNMICLR_LVD1CLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x4)|value<<2)
}
func (o *ICU_Type) GetNMICLR_LVD1CLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x4) >> 2
}
func (o *ICU_Type) SetNMICLR_LVD2CLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x8)|value<<3)
}
func (o *ICU_Type) GetNMICLR_LVD2CLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x8) >> 3
}
func (o *ICU_Type) SetNMICLR_OSTCLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x40)|value<<6)
}
func (o *ICU_Type) GetNMICLR_OSTCLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x40) >> 6
}
func (o *ICU_Type) SetNMICLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetNMICLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x80) >> 7
}
func (o *ICU_Type) SetNMICLR_RPECLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x100)|value<<8)
}
func (o *ICU_Type) GetNMICLR_RPECLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x100) >> 8
}
func (o *ICU_Type) SetNMICLR_BUSSCLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x400)|value<<10)
}
func (o *ICU_Type) GetNMICLR_BUSSCLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x400) >> 10
}
func (o *ICU_Type) SetNMICLR_BUSMCLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x800)|value<<11)
}
func (o *ICU_Type) GetNMICLR_BUSMCLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x800) >> 11
}
func (o *ICU_Type) SetNMICLR_SPECLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x1000)|value<<12)
}
func (o *ICU_Type) GetNMICLR_SPECLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x1000) >> 12
}

// ICU.NMISR: Non-Maskable Interrupt Status Register
func (o *ICU_Type) SetNMISR_IWDTST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x1)|value)
}
func (o *ICU_Type) GetNMISR_IWDTST() uint16 {
	return volatile.LoadUint16(&o.NMISR.Reg) & 0x1
}
func (o *ICU_Type) SetNMISR_WDTST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x2)|value<<1)
}
func (o *ICU_Type) GetNMISR_WDTST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x2) >> 1
}
func (o *ICU_Type) SetNMISR_LVD1ST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x4)|value<<2)
}
func (o *ICU_Type) GetNMISR_LVD1ST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x4) >> 2
}
func (o *ICU_Type) SetNMISR_LVD2ST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x8)|value<<3)
}
func (o *ICU_Type) GetNMISR_LVD2ST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x8) >> 3
}
func (o *ICU_Type) SetNMISR_OSTST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x40)|value<<6)
}
func (o *ICU_Type) GetNMISR_OSTST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x40) >> 6
}
func (o *ICU_Type) SetNMISR_NMIST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetNMISR_NMIST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x80) >> 7
}
func (o *ICU_Type) SetNMISR_RPEST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x100)|value<<8)
}
func (o *ICU_Type) GetNMISR_RPEST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x100) >> 8
}
func (o *ICU_Type) SetNMISR_BUSSST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x400)|value<<10)
}
func (o *ICU_Type) GetNMISR_BUSSST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x400) >> 10
}
func (o *ICU_Type) SetNMISR_BUSMST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x800)|value<<11)
}
func (o *ICU_Type) GetNMISR_BUSMST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x800) >> 11
}
func (o *ICU_Type) SetNMISR_SPEST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x1000)|value<<12)
}
func (o *ICU_Type) GetNMISR_SPEST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x1000) >> 12
}

// ICU.WUPEN: Wake Up Interrupt Enable Register
func (o *ICU_Type) SetWUPEN_IRQWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0xff)|value)
}
func (o *ICU_Type) GetWUPEN_IRQWUPEN() uint32 {
	return volatile.LoadUint32(&o.WUPEN.Reg) & 0xff
}
func (o *ICU_Type) SetWUPEN_IWDTWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x10000)|value<<16)
}
func (o *ICU_Type) GetWUPEN_IWDTWUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x10000) >> 16
}
func (o *ICU_Type) SetWUPEN_KEYWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x20000)|value<<17)
}
func (o *ICU_Type) GetWUPEN_KEYWUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x20000) >> 17
}
func (o *ICU_Type) SetWUPEN_LVD1WUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x40000)|value<<18)
}
func (o *ICU_Type) GetWUPEN_LVD1WUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x40000) >> 18
}
func (o *ICU_Type) SetWUPEN_LVD2WUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x80000)|value<<19)
}
func (o *ICU_Type) GetWUPEN_LVD2WUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x80000) >> 19
}
func (o *ICU_Type) SetWUPEN_ACMPLP0WUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x800000)|value<<23)
}
func (o *ICU_Type) GetWUPEN_ACMPLP0WUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x800000) >> 23
}
func (o *ICU_Type) SetWUPEN_RTCALMWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x1000000)|value<<24)
}
func (o *ICU_Type) GetWUPEN_RTCALMWUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x1000000) >> 24
}
func (o *ICU_Type) SetWUPEN_RTCPRDWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x2000000)|value<<25)
}
func (o *ICU_Type) GetWUPEN_RTCPRDWUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x2000000) >> 25
}
func (o *ICU_Type) SetWUPEN_AGT1UDWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x10000000)|value<<28)
}
func (o *ICU_Type) GetWUPEN_AGT1UDWUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x10000000) >> 28
}
func (o *ICU_Type) SetWUPEN_AGT1CAWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x20000000)|value<<29)
}
func (o *ICU_Type) GetWUPEN_AGT1CAWUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x20000000) >> 29
}
func (o *ICU_Type) SetWUPEN_AGT1CBWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x40000000)|value<<30)
}
func (o *ICU_Type) GetWUPEN_AGT1CBWUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x40000000) >> 30
}
func (o *ICU_Type) SetWUPEN_IIC0WUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x80000000)|value<<31)
}
func (o *ICU_Type) GetWUPEN_IIC0WUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x80000000) >> 31
}

// ICU.IELEN: ICU event Enable Register
func (o *ICU_Type) SetIELEN_RTCINTEN(value uint8) {
	volatile.StoreUint8(&o.IELEN.Reg, volatile.LoadUint8(&o.IELEN.Reg)&^(0x1)|value)
}
func (o *ICU_Type) GetIELEN_RTCINTEN() uint8 {
	return volatile.LoadUint8(&o.IELEN.Reg) & 0x1
}
func (o *ICU_Type) SetIELEN(value uint8) {
	volatile.StoreUint8(&o.IELEN.Reg, volatile.LoadUint8(&o.IELEN.Reg)&^(0x2)|value<<1)
}
func (o *ICU_Type) GetIELEN() uint8 {
	return (volatile.LoadUint8(&o.IELEN.Reg) & 0x2) >> 1
}

// Debug Function
type DBG_Type struct {
	DBGSTR    volatile.Register32 // 0x0
	_         [12]byte
	DBGSTOPCR volatile.Register32 // 0x10
}

// DBG.DBGSTR: Debug Status Register
func (o *DBG_Type) SetDBGSTR_CDBGPWRUPREQ(value uint32) {
	volatile.StoreUint32(&o.DBGSTR.Reg, volatile.LoadUint32(&o.DBGSTR.Reg)&^(0x10000000)|value<<28)
}
func (o *DBG_Type) GetDBGSTR_CDBGPWRUPREQ() uint32 {
	return (volatile.LoadUint32(&o.DBGSTR.Reg) & 0x10000000) >> 28
}
func (o *DBG_Type) SetDBGSTR_CDBGPWRUPACK(value uint32) {
	volatile.StoreUint32(&o.DBGSTR.Reg, volatile.LoadUint32(&o.DBGSTR.Reg)&^(0x20000000)|value<<29)
}
func (o *DBG_Type) GetDBGSTR_CDBGPWRUPACK() uint32 {
	return (volatile.LoadUint32(&o.DBGSTR.Reg) & 0x20000000) >> 29
}

// DBG.DBGSTOPCR: Debug Stop Control Register
func (o *DBG_Type) SetDBGSTOPCR_DBGSTOP_IWDT(value uint32) {
	volatile.StoreUint32(&o.DBGSTOPCR.Reg, volatile.LoadUint32(&o.DBGSTOPCR.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetDBGSTOPCR_DBGSTOP_IWDT() uint32 {
	return volatile.LoadUint32(&o.DBGSTOPCR.Reg) & 0x1
}
func (o *DBG_Type) SetDBGSTOPCR_DBGSTOP_WDT(value uint32) {
	volatile.StoreUint32(&o.DBGSTOPCR.Reg, volatile.LoadUint32(&o.DBGSTOPCR.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetDBGSTOPCR_DBGSTOP_WDT() uint32 {
	return (volatile.LoadUint32(&o.DBGSTOPCR.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetDBGSTOPCR_DBGSTOP_LVD0(value uint32) {
	volatile.StoreUint32(&o.DBGSTOPCR.Reg, volatile.LoadUint32(&o.DBGSTOPCR.Reg)&^(0x10000)|value<<16)
}
func (o *DBG_Type) GetDBGSTOPCR_DBGSTOP_LVD0() uint32 {
	return (volatile.LoadUint32(&o.DBGSTOPCR.Reg) & 0x10000) >> 16
}
func (o *DBG_Type) SetDBGSTOPCR_DBGSTOP_LVD1(value uint32) {
	volatile.StoreUint32(&o.DBGSTOPCR.Reg, volatile.LoadUint32(&o.DBGSTOPCR.Reg)&^(0x20000)|value<<17)
}
func (o *DBG_Type) GetDBGSTOPCR_DBGSTOP_LVD1() uint32 {
	return (volatile.LoadUint32(&o.DBGSTOPCR.Reg) & 0x20000) >> 17
}
func (o *DBG_Type) SetDBGSTOPCR_DBGSTOP_LVD2(value uint32) {
	volatile.StoreUint32(&o.DBGSTOPCR.Reg, volatile.LoadUint32(&o.DBGSTOPCR.Reg)&^(0x40000)|value<<18)
}
func (o *DBG_Type) GetDBGSTOPCR_DBGSTOP_LVD2() uint32 {
	return (volatile.LoadUint32(&o.DBGSTOPCR.Reg) & 0x40000) >> 18
}
func (o *DBG_Type) SetDBGSTOPCR_DBGSTOP_RPER(value uint32) {
	volatile.StoreUint32(&o.DBGSTOPCR.Reg, volatile.LoadUint32(&o.DBGSTOPCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DBG_Type) GetDBGSTOPCR_DBGSTOP_RPER() uint32 {
	return (volatile.LoadUint32(&o.DBGSTOPCR.Reg) & 0x1000000) >> 24
}

// System Control
type SYSC_Type struct {
	_         [12]byte
	SBYCR     volatile.Register16 // 0xC
	_         [14]byte
	MSTPCRA   volatile.Register32 // 0x1C
	SCKDIVCR  volatile.Register32 // 0x20
	_         [2]byte
	SCKSCR    volatile.Register8 // 0x26
	_         [10]byte
	MEMWAIT   volatile.Register8 // 0x31
	MOSCCR    volatile.Register8 // 0x32
	_         [3]byte
	HOCOCR    volatile.Register8 // 0x36
	_         byte
	MOCOCR    volatile.Register8 // 0x38
	_         [3]byte
	OSCSF     volatile.Register8 // 0x3C
	_         byte
	CKOCR     volatile.Register8 // 0x3E
	_         byte
	OSTDCR    volatile.Register8 // 0x40
	OSTDSR    volatile.Register8 // 0x41
	_         [10]byte
	LPOPT     volatile.Register8 // 0x4C
	_         [20]byte
	MOCOUTCR  volatile.Register8 // 0x61
	HOCOUTCR  volatile.Register8 // 0x62
	_         [47]byte
	SNZCR     volatile.Register8 // 0x92
	_         byte
	SNZEDCR0  volatile.Register8 // 0x94
	_         [3]byte
	SNZREQCR0 volatile.Register32 // 0x98
	_         [3]byte
	PSMCR     volatile.Register8 // 0x9F
	OPCCR     volatile.Register8 // 0xA0
	_         byte
	MOSCWTCR  volatile.Register8 // 0xA2
	_         [2]byte
	HOCOWTCR  volatile.Register8 // 0xA5
	_         [4]byte
	SOPCCR    volatile.Register8 // 0xAA
	_         [21]byte
	RSTSR1    volatile.Register16 // 0xC0
	_         [30]byte
	LVD1CR1   volatile.Register8 // 0xE0
	LVD1SR    volatile.Register8 // 0xE1
	LVD2CR1   volatile.Register8 // 0xE2
	LVD2SR    volatile.Register8 // 0xE3
	_         [794]byte
	PRCR      volatile.Register16 // 0x3FE
	_         [14]byte
	SYOCDCR   volatile.Register8 // 0x40E
	_         byte
	RSTSR0    volatile.Register8 // 0x410
	RSTSR2    volatile.Register8 // 0x411
	_         byte
	MOMCR     volatile.Register8 // 0x413
	_         [3]byte
	LVCMPCR   volatile.Register8 // 0x417
	LVDLVLR   volatile.Register8 // 0x418
	_         byte
	LVD1CR0   volatile.Register8 // 0x41A
	LVD2CR0   volatile.Register8 // 0x41B
	_         [100]byte
	SOSCCR    volatile.Register8 // 0x480
	SOMCR     volatile.Register8 // 0x481
	SOMRG     volatile.Register8 // 0x482
	_         [13]byte
	LOCOCR    volatile.Register8 // 0x490
	_         byte
	LOCOUTCR  volatile.Register8 // 0x492
}

// SYSC.SBYCR: Standby Control Register
func (o *SYSC_Type) SetSBYCR_SSBY(value uint16) {
	volatile.StoreUint16(&o.SBYCR.Reg, volatile.LoadUint16(&o.SBYCR.Reg)&^(0x8000)|value<<15)
}
func (o *SYSC_Type) GetSBYCR_SSBY() uint16 {
	return (volatile.LoadUint16(&o.SBYCR.Reg) & 0x8000) >> 15
}

// SYSC.MSTPCRA: Module Stop Control Register A
func (o *SYSC_Type) SetMSTPCRA_MSTPA22(value uint32) {
	volatile.StoreUint32(&o.MSTPCRA.Reg, volatile.LoadUint32(&o.MSTPCRA.Reg)&^(0x400000)|value<<22)
}
func (o *SYSC_Type) GetMSTPCRA_MSTPA22() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRA.Reg) & 0x400000) >> 22
}

// SYSC.SCKDIVCR: System Clock Division Control Register
func (o *SYSC_Type) SetSCKDIVCR_PCKD(value uint32) {
	volatile.StoreUint32(&o.SCKDIVCR.Reg, volatile.LoadUint32(&o.SCKDIVCR.Reg)&^(0x7)|value)
}
func (o *SYSC_Type) GetSCKDIVCR_PCKD() uint32 {
	return volatile.LoadUint32(&o.SCKDIVCR.Reg) & 0x7
}
func (o *SYSC_Type) SetSCKDIVCR_PCKB(value uint32) {
	volatile.StoreUint32(&o.SCKDIVCR.Reg, volatile.LoadUint32(&o.SCKDIVCR.Reg)&^(0x700)|value<<8)
}
func (o *SYSC_Type) GetSCKDIVCR_PCKB() uint32 {
	return (volatile.LoadUint32(&o.SCKDIVCR.Reg) & 0x700) >> 8
}
func (o *SYSC_Type) SetSCKDIVCR_ICK(value uint32) {
	volatile.StoreUint32(&o.SCKDIVCR.Reg, volatile.LoadUint32(&o.SCKDIVCR.Reg)&^(0x7000000)|value<<24)
}
func (o *SYSC_Type) GetSCKDIVCR_ICK() uint32 {
	return (volatile.LoadUint32(&o.SCKDIVCR.Reg) & 0x7000000) >> 24
}

// SYSC.SCKSCR: System Clock Source Control Register
func (o *SYSC_Type) SetSCKSCR_CKSEL(value uint8) {
	volatile.StoreUint8(&o.SCKSCR.Reg, volatile.LoadUint8(&o.SCKSCR.Reg)&^(0x7)|value)
}
func (o *SYSC_Type) GetSCKSCR_CKSEL() uint8 {
	return volatile.LoadUint8(&o.SCKSCR.Reg) & 0x7
}

// SYSC.MEMWAIT: Memory Wait Cycle Control Register for Code Flash
func (o *SYSC_Type) SetMEMWAIT(value uint8) {
	volatile.StoreUint8(&o.MEMWAIT.Reg, volatile.LoadUint8(&o.MEMWAIT.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetMEMWAIT() uint8 {
	return volatile.LoadUint8(&o.MEMWAIT.Reg) & 0x1
}

// SYSC.MOSCCR: Main Clock Oscillator Control Register
func (o *SYSC_Type) SetMOSCCR_MOSTP(value uint8) {
	volatile.StoreUint8(&o.MOSCCR.Reg, volatile.LoadUint8(&o.MOSCCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetMOSCCR_MOSTP() uint8 {
	return volatile.LoadUint8(&o.MOSCCR.Reg) & 0x1
}

// SYSC.HOCOCR: High-Speed On-Chip Oscillator Control Register
func (o *SYSC_Type) SetHOCOCR_HCSTP(value uint8) {
	volatile.StoreUint8(&o.HOCOCR.Reg, volatile.LoadUint8(&o.HOCOCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetHOCOCR_HCSTP() uint8 {
	return volatile.LoadUint8(&o.HOCOCR.Reg) & 0x1
}

// SYSC.MOCOCR: Middle-Speed On-Chip Oscillator Control Register
func (o *SYSC_Type) SetMOCOCR_MCSTP(value uint8) {
	volatile.StoreUint8(&o.MOCOCR.Reg, volatile.LoadUint8(&o.MOCOCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetMOCOCR_MCSTP() uint8 {
	return volatile.LoadUint8(&o.MOCOCR.Reg) & 0x1
}

// SYSC.OSCSF: Oscillation Stabilization Flag Register
func (o *SYSC_Type) SetOSCSF_HOCOSF(value uint8) {
	volatile.StoreUint8(&o.OSCSF.Reg, volatile.LoadUint8(&o.OSCSF.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetOSCSF_HOCOSF() uint8 {
	return volatile.LoadUint8(&o.OSCSF.Reg) & 0x1
}
func (o *SYSC_Type) SetOSCSF_MOSCSF(value uint8) {
	volatile.StoreUint8(&o.OSCSF.Reg, volatile.LoadUint8(&o.OSCSF.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetOSCSF_MOSCSF() uint8 {
	return (volatile.LoadUint8(&o.OSCSF.Reg) & 0x8) >> 3
}

// SYSC.CKOCR: Clock Out Control Register
func (o *SYSC_Type) SetCKOCR_CKOSEL(value uint8) {
	volatile.StoreUint8(&o.CKOCR.Reg, volatile.LoadUint8(&o.CKOCR.Reg)&^(0x7)|value)
}
func (o *SYSC_Type) GetCKOCR_CKOSEL() uint8 {
	return volatile.LoadUint8(&o.CKOCR.Reg) & 0x7
}
func (o *SYSC_Type) SetCKOCR_CKODIV(value uint8) {
	volatile.StoreUint8(&o.CKOCR.Reg, volatile.LoadUint8(&o.CKOCR.Reg)&^(0x70)|value<<4)
}
func (o *SYSC_Type) GetCKOCR_CKODIV() uint8 {
	return (volatile.LoadUint8(&o.CKOCR.Reg) & 0x70) >> 4
}
func (o *SYSC_Type) SetCKOCR_CKOEN(value uint8) {
	volatile.StoreUint8(&o.CKOCR.Reg, volatile.LoadUint8(&o.CKOCR.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetCKOCR_CKOEN() uint8 {
	return (volatile.LoadUint8(&o.CKOCR.Reg) & 0x80) >> 7
}

// SYSC.OSTDCR: Oscillation Stop Detection Control Register
func (o *SYSC_Type) SetOSTDCR_OSTDIE(value uint8) {
	volatile.StoreUint8(&o.OSTDCR.Reg, volatile.LoadUint8(&o.OSTDCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetOSTDCR_OSTDIE() uint8 {
	return volatile.LoadUint8(&o.OSTDCR.Reg) & 0x1
}
func (o *SYSC_Type) SetOSTDCR_OSTDE(value uint8) {
	volatile.StoreUint8(&o.OSTDCR.Reg, volatile.LoadUint8(&o.OSTDCR.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetOSTDCR_OSTDE() uint8 {
	return (volatile.LoadUint8(&o.OSTDCR.Reg) & 0x80) >> 7
}

// SYSC.OSTDSR: Oscillation Stop Detection Status Register
func (o *SYSC_Type) SetOSTDSR_OSTDF(value uint8) {
	volatile.StoreUint8(&o.OSTDSR.Reg, volatile.LoadUint8(&o.OSTDSR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetOSTDSR_OSTDF() uint8 {
	return volatile.LoadUint8(&o.OSTDSR.Reg) & 0x1
}

// SYSC.LPOPT: Lower Power Operation Control Register
func (o *SYSC_Type) SetLPOPT_MPUDIS(value uint8) {
	volatile.StoreUint8(&o.LPOPT.Reg, volatile.LoadUint8(&o.LPOPT.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetLPOPT_MPUDIS() uint8 {
	return volatile.LoadUint8(&o.LPOPT.Reg) & 0x1
}
func (o *SYSC_Type) SetLPOPT_DCLKDIS(value uint8) {
	volatile.StoreUint8(&o.LPOPT.Reg, volatile.LoadUint8(&o.LPOPT.Reg)&^(0x6)|value<<1)
}
func (o *SYSC_Type) GetLPOPT_DCLKDIS() uint8 {
	return (volatile.LoadUint8(&o.LPOPT.Reg) & 0x6) >> 1
}
func (o *SYSC_Type) SetLPOPT_BPFCLKDIS(value uint8) {
	volatile.StoreUint8(&o.LPOPT.Reg, volatile.LoadUint8(&o.LPOPT.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetLPOPT_BPFCLKDIS() uint8 {
	return (volatile.LoadUint8(&o.LPOPT.Reg) & 0x8) >> 3
}
func (o *SYSC_Type) SetLPOPT_LPOPTEN(value uint8) {
	volatile.StoreUint8(&o.LPOPT.Reg, volatile.LoadUint8(&o.LPOPT.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetLPOPT_LPOPTEN() uint8 {
	return (volatile.LoadUint8(&o.LPOPT.Reg) & 0x80) >> 7
}

// SYSC.MOCOUTCR: MOCO User Trimming Control Register
func (o *SYSC_Type) SetMOCOUTCR(value uint8) {
	volatile.StoreUint8(&o.MOCOUTCR.Reg, value)
}
func (o *SYSC_Type) GetMOCOUTCR() uint8 {
	return volatile.LoadUint8(&o.MOCOUTCR.Reg)
}

// SYSC.HOCOUTCR: HOCO User Trimming Control Register
func (o *SYSC_Type) SetHOCOUTCR(value uint8) {
	volatile.StoreUint8(&o.HOCOUTCR.Reg, value)
}
func (o *SYSC_Type) GetHOCOUTCR() uint8 {
	return volatile.LoadUint8(&o.HOCOUTCR.Reg)
}

// SYSC.SNZCR: Snooze Control Register
func (o *SYSC_Type) SetSNZCR_RXDREQEN(value uint8) {
	volatile.StoreUint8(&o.SNZCR.Reg, volatile.LoadUint8(&o.SNZCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetSNZCR_RXDREQEN() uint8 {
	return volatile.LoadUint8(&o.SNZCR.Reg) & 0x1
}
func (o *SYSC_Type) SetSNZCR_SNZDTCEN(value uint8) {
	volatile.StoreUint8(&o.SNZCR.Reg, volatile.LoadUint8(&o.SNZCR.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetSNZCR_SNZDTCEN() uint8 {
	return (volatile.LoadUint8(&o.SNZCR.Reg) & 0x2) >> 1
}
func (o *SYSC_Type) SetSNZCR_SNZE(value uint8) {
	volatile.StoreUint8(&o.SNZCR.Reg, volatile.LoadUint8(&o.SNZCR.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetSNZCR_SNZE() uint8 {
	return (volatile.LoadUint8(&o.SNZCR.Reg) & 0x80) >> 7
}

// SYSC.SNZEDCR0: Snooze End Control Register 0
func (o *SYSC_Type) SetSNZEDCR0_AGTUNFED(value uint8) {
	volatile.StoreUint8(&o.SNZEDCR0.Reg, volatile.LoadUint8(&o.SNZEDCR0.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetSNZEDCR0_AGTUNFED() uint8 {
	return volatile.LoadUint8(&o.SNZEDCR0.Reg) & 0x1
}
func (o *SYSC_Type) SetSNZEDCR0_DTCZRED(value uint8) {
	volatile.StoreUint8(&o.SNZEDCR0.Reg, volatile.LoadUint8(&o.SNZEDCR0.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetSNZEDCR0_DTCZRED() uint8 {
	return (volatile.LoadUint8(&o.SNZEDCR0.Reg) & 0x2) >> 1
}
func (o *SYSC_Type) SetSNZEDCR0_DTCNZRED(value uint8) {
	volatile.StoreUint8(&o.SNZEDCR0.Reg, volatile.LoadUint8(&o.SNZEDCR0.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetSNZEDCR0_DTCNZRED() uint8 {
	return (volatile.LoadUint8(&o.SNZEDCR0.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetSNZEDCR0_AD0MATED(value uint8) {
	volatile.StoreUint8(&o.SNZEDCR0.Reg, volatile.LoadUint8(&o.SNZEDCR0.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetSNZEDCR0_AD0MATED() uint8 {
	return (volatile.LoadUint8(&o.SNZEDCR0.Reg) & 0x8) >> 3
}
func (o *SYSC_Type) SetSNZEDCR0_AD0UMTED(value uint8) {
	volatile.StoreUint8(&o.SNZEDCR0.Reg, volatile.LoadUint8(&o.SNZEDCR0.Reg)&^(0x10)|value<<4)
}
func (o *SYSC_Type) GetSNZEDCR0_AD0UMTED() uint8 {
	return (volatile.LoadUint8(&o.SNZEDCR0.Reg) & 0x10) >> 4
}
func (o *SYSC_Type) SetSNZEDCR0_SCI0UMTED(value uint8) {
	volatile.StoreUint8(&o.SNZEDCR0.Reg, volatile.LoadUint8(&o.SNZEDCR0.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetSNZEDCR0_SCI0UMTED() uint8 {
	return (volatile.LoadUint8(&o.SNZEDCR0.Reg) & 0x80) >> 7
}

// SYSC.SNZREQCR0: Snooze Request Control Register 0
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN0(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN0() uint32 {
	return volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x1
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN1(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN1() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x2) >> 1
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN2(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN2() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN3(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN3() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x8) >> 3
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN4(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x10)|value<<4)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN4() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x10) >> 4
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN5(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x20)|value<<5)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN5() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x20) >> 5
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN6(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x40)|value<<6)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN6() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x40) >> 6
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN7(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN7() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x80) >> 7
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN17(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x20000)|value<<17)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN17() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x20000) >> 17
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN23(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x800000)|value<<23)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN23() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x800000) >> 23
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN24(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x1000000)|value<<24)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN24() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x1000000) >> 24
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN25(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x2000000)|value<<25)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN25() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x2000000) >> 25
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN28(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN28() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x10000000) >> 28
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN29(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN29() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x20000000) >> 29
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN30(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN30() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x40000000) >> 30
}

// SYSC.PSMCR: Power Save Memory Control Register
func (o *SYSC_Type) SetPSMCR_PSMC(value uint8) {
	volatile.StoreUint8(&o.PSMCR.Reg, volatile.LoadUint8(&o.PSMCR.Reg)&^(0x3)|value)
}
func (o *SYSC_Type) GetPSMCR_PSMC() uint8 {
	return volatile.LoadUint8(&o.PSMCR.Reg) & 0x3
}

// SYSC.OPCCR: Operating Power Control Register
func (o *SYSC_Type) SetOPCCR_OPCM(value uint8) {
	volatile.StoreUint8(&o.OPCCR.Reg, volatile.LoadUint8(&o.OPCCR.Reg)&^(0x3)|value)
}
func (o *SYSC_Type) GetOPCCR_OPCM() uint8 {
	return volatile.LoadUint8(&o.OPCCR.Reg) & 0x3
}
func (o *SYSC_Type) SetOPCCR_OPCMTSF(value uint8) {
	volatile.StoreUint8(&o.OPCCR.Reg, volatile.LoadUint8(&o.OPCCR.Reg)&^(0x10)|value<<4)
}
func (o *SYSC_Type) GetOPCCR_OPCMTSF() uint8 {
	return (volatile.LoadUint8(&o.OPCCR.Reg) & 0x10) >> 4
}

// SYSC.MOSCWTCR: Main Clock Oscillator Wait Control Register
func (o *SYSC_Type) SetMOSCWTCR_MSTS(value uint8) {
	volatile.StoreUint8(&o.MOSCWTCR.Reg, volatile.LoadUint8(&o.MOSCWTCR.Reg)&^(0xf)|value)
}
func (o *SYSC_Type) GetMOSCWTCR_MSTS() uint8 {
	return volatile.LoadUint8(&o.MOSCWTCR.Reg) & 0xf
}

// SYSC.HOCOWTCR: High-Speed On-Chip Oscillator Wait Control Register
func (o *SYSC_Type) SetHOCOWTCR_HSTS(value uint8) {
	volatile.StoreUint8(&o.HOCOWTCR.Reg, volatile.LoadUint8(&o.HOCOWTCR.Reg)&^(0x7)|value)
}
func (o *SYSC_Type) GetHOCOWTCR_HSTS() uint8 {
	return volatile.LoadUint8(&o.HOCOWTCR.Reg) & 0x7
}

// SYSC.SOPCCR: Sub Operating Power Control Register
func (o *SYSC_Type) SetSOPCCR_SOPCM(value uint8) {
	volatile.StoreUint8(&o.SOPCCR.Reg, volatile.LoadUint8(&o.SOPCCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetSOPCCR_SOPCM() uint8 {
	return volatile.LoadUint8(&o.SOPCCR.Reg) & 0x1
}
func (o *SYSC_Type) SetSOPCCR_SOPCMTSF(value uint8) {
	volatile.StoreUint8(&o.SOPCCR.Reg, volatile.LoadUint8(&o.SOPCCR.Reg)&^(0x10)|value<<4)
}
func (o *SYSC_Type) GetSOPCCR_SOPCMTSF() uint8 {
	return (volatile.LoadUint8(&o.SOPCCR.Reg) & 0x10) >> 4
}

// SYSC.RSTSR1: Reset Status Register 1
func (o *SYSC_Type) SetRSTSR1_IWDTRF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetRSTSR1_IWDTRF() uint16 {
	return volatile.LoadUint16(&o.RSTSR1.Reg) & 0x1
}
func (o *SYSC_Type) SetRSTSR1_WDTRF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetRSTSR1_WDTRF() uint16 {
	return (volatile.LoadUint16(&o.RSTSR1.Reg) & 0x2) >> 1
}
func (o *SYSC_Type) SetRSTSR1_SWRF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetRSTSR1_SWRF() uint16 {
	return (volatile.LoadUint16(&o.RSTSR1.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetRSTSR1_RPERF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x100)|value<<8)
}
func (o *SYSC_Type) GetRSTSR1_RPERF() uint16 {
	return (volatile.LoadUint16(&o.RSTSR1.Reg) & 0x100) >> 8
}
func (o *SYSC_Type) SetRSTSR1_BUSSRF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x400)|value<<10)
}
func (o *SYSC_Type) GetRSTSR1_BUSSRF() uint16 {
	return (volatile.LoadUint16(&o.RSTSR1.Reg) & 0x400) >> 10
}
func (o *SYSC_Type) SetRSTSR1_BUSMRF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x800)|value<<11)
}
func (o *SYSC_Type) GetRSTSR1_BUSMRF() uint16 {
	return (volatile.LoadUint16(&o.RSTSR1.Reg) & 0x800) >> 11
}
func (o *SYSC_Type) SetRSTSR1_SPERF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *SYSC_Type) GetRSTSR1_SPERF() uint16 {
	return (volatile.LoadUint16(&o.RSTSR1.Reg) & 0x1000) >> 12
}

// SYSC.LVD1CR1: Voltage Monitor 1 Circuit Control Register
func (o *SYSC_Type) SetLVD1CR1_IDTSEL(value uint8) {
	volatile.StoreUint8(&o.LVD1CR1.Reg, volatile.LoadUint8(&o.LVD1CR1.Reg)&^(0x3)|value)
}
func (o *SYSC_Type) GetLVD1CR1_IDTSEL() uint8 {
	return volatile.LoadUint8(&o.LVD1CR1.Reg) & 0x3
}
func (o *SYSC_Type) SetLVD1CR1_IRQSEL(value uint8) {
	volatile.StoreUint8(&o.LVD1CR1.Reg, volatile.LoadUint8(&o.LVD1CR1.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetLVD1CR1_IRQSEL() uint8 {
	return (volatile.LoadUint8(&o.LVD1CR1.Reg) & 0x4) >> 2
}

// SYSC.LVD1SR: Voltage Monitor 1 Circuit Status Register
func (o *SYSC_Type) SetLVD1SR_DET(value uint8) {
	volatile.StoreUint8(&o.LVD1SR.Reg, volatile.LoadUint8(&o.LVD1SR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetLVD1SR_DET() uint8 {
	return volatile.LoadUint8(&o.LVD1SR.Reg) & 0x1
}
func (o *SYSC_Type) SetLVD1SR_MON(value uint8) {
	volatile.StoreUint8(&o.LVD1SR.Reg, volatile.LoadUint8(&o.LVD1SR.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetLVD1SR_MON() uint8 {
	return (volatile.LoadUint8(&o.LVD1SR.Reg) & 0x2) >> 1
}

// SYSC.LVD2CR1: Voltage Monitor 2 Circuit Control Register 1
func (o *SYSC_Type) SetLVD2CR1_IDTSEL(value uint8) {
	volatile.StoreUint8(&o.LVD2CR1.Reg, volatile.LoadUint8(&o.LVD2CR1.Reg)&^(0x3)|value)
}
func (o *SYSC_Type) GetLVD2CR1_IDTSEL() uint8 {
	return volatile.LoadUint8(&o.LVD2CR1.Reg) & 0x3
}
func (o *SYSC_Type) SetLVD2CR1_IRQSEL(value uint8) {
	volatile.StoreUint8(&o.LVD2CR1.Reg, volatile.LoadUint8(&o.LVD2CR1.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetLVD2CR1_IRQSEL() uint8 {
	return (volatile.LoadUint8(&o.LVD2CR1.Reg) & 0x4) >> 2
}

// SYSC.LVD2SR: Voltage Monitor 2 Circuit Status Register
func (o *SYSC_Type) SetLVD2SR_DET(value uint8) {
	volatile.StoreUint8(&o.LVD2SR.Reg, volatile.LoadUint8(&o.LVD2SR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetLVD2SR_DET() uint8 {
	return volatile.LoadUint8(&o.LVD2SR.Reg) & 0x1
}
func (o *SYSC_Type) SetLVD2SR_MON(value uint8) {
	volatile.StoreUint8(&o.LVD2SR.Reg, volatile.LoadUint8(&o.LVD2SR.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetLVD2SR_MON() uint8 {
	return (volatile.LoadUint8(&o.LVD2SR.Reg) & 0x2) >> 1
}

// SYSC.PRCR: Protect Register
func (o *SYSC_Type) SetPRCR_PRC0(value uint16) {
	volatile.StoreUint16(&o.PRCR.Reg, volatile.LoadUint16(&o.PRCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetPRCR_PRC0() uint16 {
	return volatile.LoadUint16(&o.PRCR.Reg) & 0x1
}
func (o *SYSC_Type) SetPRCR_PRC1(value uint16) {
	volatile.StoreUint16(&o.PRCR.Reg, volatile.LoadUint16(&o.PRCR.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetPRCR_PRC1() uint16 {
	return (volatile.LoadUint16(&o.PRCR.Reg) & 0x2) >> 1
}
func (o *SYSC_Type) SetPRCR_PRC3(value uint16) {
	volatile.StoreUint16(&o.PRCR.Reg, volatile.LoadUint16(&o.PRCR.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetPRCR_PRC3() uint16 {
	return (volatile.LoadUint16(&o.PRCR.Reg) & 0x8) >> 3
}
func (o *SYSC_Type) SetPRCR_PRKEY(value uint16) {
	volatile.StoreUint16(&o.PRCR.Reg, volatile.LoadUint16(&o.PRCR.Reg)&^(0xff00)|value<<8)
}
func (o *SYSC_Type) GetPRCR_PRKEY() uint16 {
	return (volatile.LoadUint16(&o.PRCR.Reg) & 0xff00) >> 8
}

// SYSC.SYOCDCR: System Control OCD Control Register
func (o *SYSC_Type) SetSYOCDCR_DBGEN(value uint8) {
	volatile.StoreUint8(&o.SYOCDCR.Reg, volatile.LoadUint8(&o.SYOCDCR.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetSYOCDCR_DBGEN() uint8 {
	return (volatile.LoadUint8(&o.SYOCDCR.Reg) & 0x80) >> 7
}

// SYSC.RSTSR0: Reset Status Register 0
func (o *SYSC_Type) SetRSTSR0_PORF(value uint8) {
	volatile.StoreUint8(&o.RSTSR0.Reg, volatile.LoadUint8(&o.RSTSR0.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetRSTSR0_PORF() uint8 {
	return volatile.LoadUint8(&o.RSTSR0.Reg) & 0x1
}
func (o *SYSC_Type) SetRSTSR0_LVD0RF(value uint8) {
	volatile.StoreUint8(&o.RSTSR0.Reg, volatile.LoadUint8(&o.RSTSR0.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetRSTSR0_LVD0RF() uint8 {
	return (volatile.LoadUint8(&o.RSTSR0.Reg) & 0x2) >> 1
}
func (o *SYSC_Type) SetRSTSR0_LVD1RF(value uint8) {
	volatile.StoreUint8(&o.RSTSR0.Reg, volatile.LoadUint8(&o.RSTSR0.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetRSTSR0_LVD1RF() uint8 {
	return (volatile.LoadUint8(&o.RSTSR0.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetRSTSR0_LVD2RF(value uint8) {
	volatile.StoreUint8(&o.RSTSR0.Reg, volatile.LoadUint8(&o.RSTSR0.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetRSTSR0_LVD2RF() uint8 {
	return (volatile.LoadUint8(&o.RSTSR0.Reg) & 0x8) >> 3
}

// SYSC.RSTSR2: Reset Status Register 2
func (o *SYSC_Type) SetRSTSR2_CWSF(value uint8) {
	volatile.StoreUint8(&o.RSTSR2.Reg, volatile.LoadUint8(&o.RSTSR2.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetRSTSR2_CWSF() uint8 {
	return volatile.LoadUint8(&o.RSTSR2.Reg) & 0x1
}

// SYSC.MOMCR: Main Clock Oscillator Mode Oscillation Control Register
func (o *SYSC_Type) SetMOMCR_MODRV1(value uint8) {
	volatile.StoreUint8(&o.MOMCR.Reg, volatile.LoadUint8(&o.MOMCR.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetMOMCR_MODRV1() uint8 {
	return (volatile.LoadUint8(&o.MOMCR.Reg) & 0x8) >> 3
}
func (o *SYSC_Type) SetMOMCR_MOSEL(value uint8) {
	volatile.StoreUint8(&o.MOMCR.Reg, volatile.LoadUint8(&o.MOMCR.Reg)&^(0x40)|value<<6)
}
func (o *SYSC_Type) GetMOMCR_MOSEL() uint8 {
	return (volatile.LoadUint8(&o.MOMCR.Reg) & 0x40) >> 6
}

// SYSC.LVCMPCR: Voltage Monitor Circuit Control Register
func (o *SYSC_Type) SetLVCMPCR_LVD1E(value uint8) {
	volatile.StoreUint8(&o.LVCMPCR.Reg, volatile.LoadUint8(&o.LVCMPCR.Reg)&^(0x20)|value<<5)
}
func (o *SYSC_Type) GetLVCMPCR_LVD1E() uint8 {
	return (volatile.LoadUint8(&o.LVCMPCR.Reg) & 0x20) >> 5
}
func (o *SYSC_Type) SetLVCMPCR_LVD2E(value uint8) {
	volatile.StoreUint8(&o.LVCMPCR.Reg, volatile.LoadUint8(&o.LVCMPCR.Reg)&^(0x40)|value<<6)
}
func (o *SYSC_Type) GetLVCMPCR_LVD2E() uint8 {
	return (volatile.LoadUint8(&o.LVCMPCR.Reg) & 0x40) >> 6
}

// SYSC.LVDLVLR: Voltage Detection Level Select Register
func (o *SYSC_Type) SetLVDLVLR_LVD1LVL(value uint8) {
	volatile.StoreUint8(&o.LVDLVLR.Reg, volatile.LoadUint8(&o.LVDLVLR.Reg)&^(0x1f)|value)
}
func (o *SYSC_Type) GetLVDLVLR_LVD1LVL() uint8 {
	return volatile.LoadUint8(&o.LVDLVLR.Reg) & 0x1f
}
func (o *SYSC_Type) SetLVDLVLR_LVD2LVL(value uint8) {
	volatile.StoreUint8(&o.LVDLVLR.Reg, volatile.LoadUint8(&o.LVDLVLR.Reg)&^(0xe0)|value<<5)
}
func (o *SYSC_Type) GetLVDLVLR_LVD2LVL() uint8 {
	return (volatile.LoadUint8(&o.LVDLVLR.Reg) & 0xe0) >> 5
}

// SYSC.LVD1CR0: Voltage Monitor 1 Circuit Control Register 0
func (o *SYSC_Type) SetLVD1CR0_RIE(value uint8) {
	volatile.StoreUint8(&o.LVD1CR0.Reg, volatile.LoadUint8(&o.LVD1CR0.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetLVD1CR0_RIE() uint8 {
	return volatile.LoadUint8(&o.LVD1CR0.Reg) & 0x1
}
func (o *SYSC_Type) SetLVD1CR0_CMPE(value uint8) {
	volatile.StoreUint8(&o.LVD1CR0.Reg, volatile.LoadUint8(&o.LVD1CR0.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetLVD1CR0_CMPE() uint8 {
	return (volatile.LoadUint8(&o.LVD1CR0.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetLVD1CR0_RI(value uint8) {
	volatile.StoreUint8(&o.LVD1CR0.Reg, volatile.LoadUint8(&o.LVD1CR0.Reg)&^(0x40)|value<<6)
}
func (o *SYSC_Type) GetLVD1CR0_RI() uint8 {
	return (volatile.LoadUint8(&o.LVD1CR0.Reg) & 0x40) >> 6
}
func (o *SYSC_Type) SetLVD1CR0_RN(value uint8) {
	volatile.StoreUint8(&o.LVD1CR0.Reg, volatile.LoadUint8(&o.LVD1CR0.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetLVD1CR0_RN() uint8 {
	return (volatile.LoadUint8(&o.LVD1CR0.Reg) & 0x80) >> 7
}

// SYSC.LVD2CR0: Voltage Monitor 2 Circuit Control Register 0
func (o *SYSC_Type) SetLVD2CR0_RIE(value uint8) {
	volatile.StoreUint8(&o.LVD2CR0.Reg, volatile.LoadUint8(&o.LVD2CR0.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetLVD2CR0_RIE() uint8 {
	return volatile.LoadUint8(&o.LVD2CR0.Reg) & 0x1
}
func (o *SYSC_Type) SetLVD2CR0_CMPE(value uint8) {
	volatile.StoreUint8(&o.LVD2CR0.Reg, volatile.LoadUint8(&o.LVD2CR0.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetLVD2CR0_CMPE() uint8 {
	return (volatile.LoadUint8(&o.LVD2CR0.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetLVD2CR0_RI(value uint8) {
	volatile.StoreUint8(&o.LVD2CR0.Reg, volatile.LoadUint8(&o.LVD2CR0.Reg)&^(0x40)|value<<6)
}
func (o *SYSC_Type) GetLVD2CR0_RI() uint8 {
	return (volatile.LoadUint8(&o.LVD2CR0.Reg) & 0x40) >> 6
}
func (o *SYSC_Type) SetLVD2CR0_RN(value uint8) {
	volatile.StoreUint8(&o.LVD2CR0.Reg, volatile.LoadUint8(&o.LVD2CR0.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetLVD2CR0_RN() uint8 {
	return (volatile.LoadUint8(&o.LVD2CR0.Reg) & 0x80) >> 7
}

// SYSC.SOSCCR: Sub-Clock Oscillator Control Register
func (o *SYSC_Type) SetSOSCCR_SOSTP(value uint8) {
	volatile.StoreUint8(&o.SOSCCR.Reg, volatile.LoadUint8(&o.SOSCCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetSOSCCR_SOSTP() uint8 {
	return volatile.LoadUint8(&o.SOSCCR.Reg) & 0x1
}

// SYSC.SOMCR: Sub-Clock Oscillator Mode Control Register
func (o *SYSC_Type) SetSOMCR_SODRV(value uint8) {
	volatile.StoreUint8(&o.SOMCR.Reg, volatile.LoadUint8(&o.SOMCR.Reg)&^(0x3)|value)
}
func (o *SYSC_Type) GetSOMCR_SODRV() uint8 {
	return volatile.LoadUint8(&o.SOMCR.Reg) & 0x3
}

// SYSC.SOMRG: Sub-Clock Oscillator Margin Check Register
func (o *SYSC_Type) SetSOMRG_SOSCMRG(value uint8) {
	volatile.StoreUint8(&o.SOMRG.Reg, volatile.LoadUint8(&o.SOMRG.Reg)&^(0x3)|value)
}
func (o *SYSC_Type) GetSOMRG_SOSCMRG() uint8 {
	return volatile.LoadUint8(&o.SOMRG.Reg) & 0x3
}

// SYSC.LOCOCR: Low-Speed On-Chip Oscillator Control Register
func (o *SYSC_Type) SetLOCOCR_LCSTP(value uint8) {
	volatile.StoreUint8(&o.LOCOCR.Reg, volatile.LoadUint8(&o.LOCOCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetLOCOCR_LCSTP() uint8 {
	return volatile.LoadUint8(&o.LOCOCR.Reg) & 0x1
}

// SYSC.LOCOUTCR: LOCO User Trimming Control Register
func (o *SYSC_Type) SetLOCOUTCR(value uint8) {
	volatile.StoreUint8(&o.LOCOUTCR.Reg, value)
}
func (o *SYSC_Type) GetLOCOUTCR() uint8 {
	return volatile.LoadUint8(&o.LOCOUTCR.Reg)
}

// Port 0 Control Registers
type PORT0_Type struct {
	PCNTR1 volatile.Register32 // 0x0
	PCNTR2 volatile.Register32 // 0x4
	PCNTR3 volatile.Register32 // 0x8
}

// PORT0.PCNTR1: Port Control Register 1
func (o *PORT0_Type) SetPCNTR1_PDR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x1)|value)
}
func (o *PORT0_Type) GetPCNTR1_PDR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR1.Reg) & 0x1
}
func (o *PORT0_Type) SetPCNTR1_PDR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x2)|value<<1)
}
func (o *PORT0_Type) GetPCNTR1_PDR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x2) >> 1
}
func (o *PORT0_Type) SetPCNTR1_PDR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x4)|value<<2)
}
func (o *PORT0_Type) GetPCNTR1_PDR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x4) >> 2
}
func (o *PORT0_Type) SetPCNTR1_PDR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x8)|value<<3)
}
func (o *PORT0_Type) GetPCNTR1_PDR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x8) >> 3
}
func (o *PORT0_Type) SetPCNTR1_PDR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x10)|value<<4)
}
func (o *PORT0_Type) GetPCNTR1_PDR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x10) >> 4
}
func (o *PORT0_Type) SetPCNTR1_PDR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x20)|value<<5)
}
func (o *PORT0_Type) GetPCNTR1_PDR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x20) >> 5
}
func (o *PORT0_Type) SetPCNTR1_PDR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x40)|value<<6)
}
func (o *PORT0_Type) GetPCNTR1_PDR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x40) >> 6
}
func (o *PORT0_Type) SetPCNTR1_PDR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x80)|value<<7)
}
func (o *PORT0_Type) GetPCNTR1_PDR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x80) >> 7
}
func (o *PORT0_Type) SetPCNTR1_PDR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x100)|value<<8)
}
func (o *PORT0_Type) GetPCNTR1_PDR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x100) >> 8
}
func (o *PORT0_Type) SetPCNTR1_PDR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x200)|value<<9)
}
func (o *PORT0_Type) GetPCNTR1_PDR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x200) >> 9
}
func (o *PORT0_Type) SetPCNTR1_PDR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x400)|value<<10)
}
func (o *PORT0_Type) GetPCNTR1_PDR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x400) >> 10
}
func (o *PORT0_Type) SetPCNTR1_PDR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x800)|value<<11)
}
func (o *PORT0_Type) GetPCNTR1_PDR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x800) >> 11
}
func (o *PORT0_Type) SetPCNTR1_PDR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x1000)|value<<12)
}
func (o *PORT0_Type) GetPCNTR1_PDR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x1000) >> 12
}
func (o *PORT0_Type) SetPCNTR1_PDR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x2000)|value<<13)
}
func (o *PORT0_Type) GetPCNTR1_PDR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x2000) >> 13
}
func (o *PORT0_Type) SetPCNTR1_PDR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x4000)|value<<14)
}
func (o *PORT0_Type) GetPCNTR1_PDR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x4000) >> 14
}
func (o *PORT0_Type) SetPCNTR1_PDR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x8000)|value<<15)
}
func (o *PORT0_Type) GetPCNTR1_PDR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x8000) >> 15
}
func (o *PORT0_Type) SetPCNTR1_PODR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x10000)|value<<16)
}
func (o *PORT0_Type) GetPCNTR1_PODR00() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x10000) >> 16
}
func (o *PORT0_Type) SetPCNTR1_PODR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x20000)|value<<17)
}
func (o *PORT0_Type) GetPCNTR1_PODR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x20000) >> 17
}
func (o *PORT0_Type) SetPCNTR1_PODR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x40000)|value<<18)
}
func (o *PORT0_Type) GetPCNTR1_PODR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x40000) >> 18
}
func (o *PORT0_Type) SetPCNTR1_PODR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x80000)|value<<19)
}
func (o *PORT0_Type) GetPCNTR1_PODR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x80000) >> 19
}
func (o *PORT0_Type) SetPCNTR1_PODR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x100000)|value<<20)
}
func (o *PORT0_Type) GetPCNTR1_PODR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x100000) >> 20
}
func (o *PORT0_Type) SetPCNTR1_PODR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x200000)|value<<21)
}
func (o *PORT0_Type) GetPCNTR1_PODR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x200000) >> 21
}
func (o *PORT0_Type) SetPCNTR1_PODR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x400000)|value<<22)
}
func (o *PORT0_Type) GetPCNTR1_PODR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x400000) >> 22
}
func (o *PORT0_Type) SetPCNTR1_PODR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x800000)|value<<23)
}
func (o *PORT0_Type) GetPCNTR1_PODR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x800000) >> 23
}
func (o *PORT0_Type) SetPCNTR1_PODR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT0_Type) GetPCNTR1_PODR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x1000000) >> 24
}
func (o *PORT0_Type) SetPCNTR1_PODR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PORT0_Type) GetPCNTR1_PODR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x2000000) >> 25
}
func (o *PORT0_Type) SetPCNTR1_PODR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PORT0_Type) GetPCNTR1_PODR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x4000000) >> 26
}
func (o *PORT0_Type) SetPCNTR1_PODR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PORT0_Type) GetPCNTR1_PODR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x8000000) >> 27
}
func (o *PORT0_Type) SetPCNTR1_PODR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT0_Type) GetPCNTR1_PODR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x10000000) >> 28
}
func (o *PORT0_Type) SetPCNTR1_PODR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x20000000)|value<<29)
}
func (o *PORT0_Type) GetPCNTR1_PODR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x20000000) >> 29
}
func (o *PORT0_Type) SetPCNTR1_PODR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT0_Type) GetPCNTR1_PODR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x40000000) >> 30
}
func (o *PORT0_Type) SetPCNTR1_PODR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT0_Type) GetPCNTR1_PODR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x80000000) >> 31
}

// PORT0.PCNTR2: Port Control Register 2
func (o *PORT0_Type) SetPCNTR2_PIDR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x1)|value)
}
func (o *PORT0_Type) GetPCNTR2_PIDR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR2.Reg) & 0x1
}
func (o *PORT0_Type) SetPCNTR2_PIDR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x2)|value<<1)
}
func (o *PORT0_Type) GetPCNTR2_PIDR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x2) >> 1
}
func (o *PORT0_Type) SetPCNTR2_PIDR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x4)|value<<2)
}
func (o *PORT0_Type) GetPCNTR2_PIDR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x4) >> 2
}
func (o *PORT0_Type) SetPCNTR2_PIDR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x8)|value<<3)
}
func (o *PORT0_Type) GetPCNTR2_PIDR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x8) >> 3
}
func (o *PORT0_Type) SetPCNTR2_PIDR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x10)|value<<4)
}
func (o *PORT0_Type) GetPCNTR2_PIDR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x10) >> 4
}
func (o *PORT0_Type) SetPCNTR2_PIDR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x20)|value<<5)
}
func (o *PORT0_Type) GetPCNTR2_PIDR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x20) >> 5
}
func (o *PORT0_Type) SetPCNTR2_PIDR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x40)|value<<6)
}
func (o *PORT0_Type) GetPCNTR2_PIDR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x40) >> 6
}
func (o *PORT0_Type) SetPCNTR2_PIDR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x80)|value<<7)
}
func (o *PORT0_Type) GetPCNTR2_PIDR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x80) >> 7
}
func (o *PORT0_Type) SetPCNTR2_PIDR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x100)|value<<8)
}
func (o *PORT0_Type) GetPCNTR2_PIDR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x100) >> 8
}
func (o *PORT0_Type) SetPCNTR2_PIDR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x200)|value<<9)
}
func (o *PORT0_Type) GetPCNTR2_PIDR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x200) >> 9
}
func (o *PORT0_Type) SetPCNTR2_PIDR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x400)|value<<10)
}
func (o *PORT0_Type) GetPCNTR2_PIDR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x400) >> 10
}
func (o *PORT0_Type) SetPCNTR2_PIDR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x800)|value<<11)
}
func (o *PORT0_Type) GetPCNTR2_PIDR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x800) >> 11
}
func (o *PORT0_Type) SetPCNTR2_PIDR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x1000)|value<<12)
}
func (o *PORT0_Type) GetPCNTR2_PIDR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x1000) >> 12
}
func (o *PORT0_Type) SetPCNTR2_PIDR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x2000)|value<<13)
}
func (o *PORT0_Type) GetPCNTR2_PIDR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x2000) >> 13
}
func (o *PORT0_Type) SetPCNTR2_PIDR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x4000)|value<<14)
}
func (o *PORT0_Type) GetPCNTR2_PIDR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x4000) >> 14
}
func (o *PORT0_Type) SetPCNTR2_PIDR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x8000)|value<<15)
}
func (o *PORT0_Type) GetPCNTR2_PIDR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x8000) >> 15
}

// PORT0.PCNTR3: Port Control Register 3
func (o *PORT0_Type) SetPCNTR3_POSR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x1)|value)
}
func (o *PORT0_Type) GetPCNTR3_POSR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR3.Reg) & 0x1
}
func (o *PORT0_Type) SetPCNTR3_POSR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x2)|value<<1)
}
func (o *PORT0_Type) GetPCNTR3_POSR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x2) >> 1
}
func (o *PORT0_Type) SetPCNTR3_POSR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x4)|value<<2)
}
func (o *PORT0_Type) GetPCNTR3_POSR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x4) >> 2
}
func (o *PORT0_Type) SetPCNTR3_POSR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x8)|value<<3)
}
func (o *PORT0_Type) GetPCNTR3_POSR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x8) >> 3
}
func (o *PORT0_Type) SetPCNTR3_POSR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x10)|value<<4)
}
func (o *PORT0_Type) GetPCNTR3_POSR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x10) >> 4
}
func (o *PORT0_Type) SetPCNTR3_POSR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x20)|value<<5)
}
func (o *PORT0_Type) GetPCNTR3_POSR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x20) >> 5
}
func (o *PORT0_Type) SetPCNTR3_POSR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x40)|value<<6)
}
func (o *PORT0_Type) GetPCNTR3_POSR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x40) >> 6
}
func (o *PORT0_Type) SetPCNTR3_POSR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x80)|value<<7)
}
func (o *PORT0_Type) GetPCNTR3_POSR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x80) >> 7
}
func (o *PORT0_Type) SetPCNTR3_POSR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x100)|value<<8)
}
func (o *PORT0_Type) GetPCNTR3_POSR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x100) >> 8
}
func (o *PORT0_Type) SetPCNTR3_POSR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x200)|value<<9)
}
func (o *PORT0_Type) GetPCNTR3_POSR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x200) >> 9
}
func (o *PORT0_Type) SetPCNTR3_POSR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x400)|value<<10)
}
func (o *PORT0_Type) GetPCNTR3_POSR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x400) >> 10
}
func (o *PORT0_Type) SetPCNTR3_POSR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x800)|value<<11)
}
func (o *PORT0_Type) GetPCNTR3_POSR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x800) >> 11
}
func (o *PORT0_Type) SetPCNTR3_POSR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x1000)|value<<12)
}
func (o *PORT0_Type) GetPCNTR3_POSR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x1000) >> 12
}
func (o *PORT0_Type) SetPCNTR3_POSR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x2000)|value<<13)
}
func (o *PORT0_Type) GetPCNTR3_POSR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x2000) >> 13
}
func (o *PORT0_Type) SetPCNTR3_POSR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x4000)|value<<14)
}
func (o *PORT0_Type) GetPCNTR3_POSR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x4000) >> 14
}
func (o *PORT0_Type) SetPCNTR3_POSR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x8000)|value<<15)
}
func (o *PORT0_Type) GetPCNTR3_POSR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x8000) >> 15
}
func (o *PORT0_Type) SetPCNTR3_PORR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x10000)|value<<16)
}
func (o *PORT0_Type) GetPCNTR3_PORR00() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x10000) >> 16
}
func (o *PORT0_Type) SetPCNTR3_PORR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x20000)|value<<17)
}
func (o *PORT0_Type) GetPCNTR3_PORR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x20000) >> 17
}
func (o *PORT0_Type) SetPCNTR3_PORR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x40000)|value<<18)
}
func (o *PORT0_Type) GetPCNTR3_PORR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x40000) >> 18
}
func (o *PORT0_Type) SetPCNTR3_PORR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x80000)|value<<19)
}
func (o *PORT0_Type) GetPCNTR3_PORR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x80000) >> 19
}
func (o *PORT0_Type) SetPCNTR3_PORR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x100000)|value<<20)
}
func (o *PORT0_Type) GetPCNTR3_PORR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x100000) >> 20
}
func (o *PORT0_Type) SetPCNTR3_PORR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x200000)|value<<21)
}
func (o *PORT0_Type) GetPCNTR3_PORR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x200000) >> 21
}
func (o *PORT0_Type) SetPCNTR3_PORR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x400000)|value<<22)
}
func (o *PORT0_Type) GetPCNTR3_PORR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x400000) >> 22
}
func (o *PORT0_Type) SetPCNTR3_PORR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x800000)|value<<23)
}
func (o *PORT0_Type) GetPCNTR3_PORR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x800000) >> 23
}
func (o *PORT0_Type) SetPCNTR3_PORR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT0_Type) GetPCNTR3_PORR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x1000000) >> 24
}
func (o *PORT0_Type) SetPCNTR3_PORR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x2000000)|value<<25)
}
func (o *PORT0_Type) GetPCNTR3_PORR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x2000000) >> 25
}
func (o *PORT0_Type) SetPCNTR3_PORR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x4000000)|value<<26)
}
func (o *PORT0_Type) GetPCNTR3_PORR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x4000000) >> 26
}
func (o *PORT0_Type) SetPCNTR3_PORR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x8000000)|value<<27)
}
func (o *PORT0_Type) GetPCNTR3_PORR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x8000000) >> 27
}
func (o *PORT0_Type) SetPCNTR3_PORR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT0_Type) GetPCNTR3_PORR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x10000000) >> 28
}
func (o *PORT0_Type) SetPCNTR3_PORR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x20000000)|value<<29)
}
func (o *PORT0_Type) GetPCNTR3_PORR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x20000000) >> 29
}
func (o *PORT0_Type) SetPCNTR3_PORR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT0_Type) GetPCNTR3_PORR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x40000000) >> 30
}
func (o *PORT0_Type) SetPCNTR3_PORR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT0_Type) GetPCNTR3_PORR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x80000000) >> 31
}

// Port 1 Control Registers
type PORT1_Type struct {
	PCNTR1 volatile.Register32 // 0x0
	PCNTR2 volatile.Register32 // 0x4
	PCNTR3 volatile.Register32 // 0x8
	PCNTR4 volatile.Register32 // 0xC
}

// PORT1.PCNTR1: Port Control Register 1
func (o *PORT1_Type) SetPCNTR1_PDR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x1)|value)
}
func (o *PORT1_Type) GetPCNTR1_PDR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR1.Reg) & 0x1
}
func (o *PORT1_Type) SetPCNTR1_PDR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x2)|value<<1)
}
func (o *PORT1_Type) GetPCNTR1_PDR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x2) >> 1
}
func (o *PORT1_Type) SetPCNTR1_PDR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x4)|value<<2)
}
func (o *PORT1_Type) GetPCNTR1_PDR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x4) >> 2
}
func (o *PORT1_Type) SetPCNTR1_PDR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x8)|value<<3)
}
func (o *PORT1_Type) GetPCNTR1_PDR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x8) >> 3
}
func (o *PORT1_Type) SetPCNTR1_PDR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x10)|value<<4)
}
func (o *PORT1_Type) GetPCNTR1_PDR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x10) >> 4
}
func (o *PORT1_Type) SetPCNTR1_PDR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x20)|value<<5)
}
func (o *PORT1_Type) GetPCNTR1_PDR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x20) >> 5
}
func (o *PORT1_Type) SetPCNTR1_PDR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x40)|value<<6)
}
func (o *PORT1_Type) GetPCNTR1_PDR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x40) >> 6
}
func (o *PORT1_Type) SetPCNTR1_PDR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x80)|value<<7)
}
func (o *PORT1_Type) GetPCNTR1_PDR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x80) >> 7
}
func (o *PORT1_Type) SetPCNTR1_PDR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x100)|value<<8)
}
func (o *PORT1_Type) GetPCNTR1_PDR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x100) >> 8
}
func (o *PORT1_Type) SetPCNTR1_PDR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x200)|value<<9)
}
func (o *PORT1_Type) GetPCNTR1_PDR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x200) >> 9
}
func (o *PORT1_Type) SetPCNTR1_PDR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x400)|value<<10)
}
func (o *PORT1_Type) GetPCNTR1_PDR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x400) >> 10
}
func (o *PORT1_Type) SetPCNTR1_PDR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x800)|value<<11)
}
func (o *PORT1_Type) GetPCNTR1_PDR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x800) >> 11
}
func (o *PORT1_Type) SetPCNTR1_PDR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x1000)|value<<12)
}
func (o *PORT1_Type) GetPCNTR1_PDR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x1000) >> 12
}
func (o *PORT1_Type) SetPCNTR1_PDR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x2000)|value<<13)
}
func (o *PORT1_Type) GetPCNTR1_PDR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x2000) >> 13
}
func (o *PORT1_Type) SetPCNTR1_PDR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x4000)|value<<14)
}
func (o *PORT1_Type) GetPCNTR1_PDR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x4000) >> 14
}
func (o *PORT1_Type) SetPCNTR1_PDR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x8000)|value<<15)
}
func (o *PORT1_Type) GetPCNTR1_PDR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x8000) >> 15
}
func (o *PORT1_Type) SetPCNTR1_PODR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x10000)|value<<16)
}
func (o *PORT1_Type) GetPCNTR1_PODR00() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x10000) >> 16
}
func (o *PORT1_Type) SetPCNTR1_PODR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x20000)|value<<17)
}
func (o *PORT1_Type) GetPCNTR1_PODR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x20000) >> 17
}
func (o *PORT1_Type) SetPCNTR1_PODR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x40000)|value<<18)
}
func (o *PORT1_Type) GetPCNTR1_PODR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x40000) >> 18
}
func (o *PORT1_Type) SetPCNTR1_PODR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x80000)|value<<19)
}
func (o *PORT1_Type) GetPCNTR1_PODR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x80000) >> 19
}
func (o *PORT1_Type) SetPCNTR1_PODR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x100000)|value<<20)
}
func (o *PORT1_Type) GetPCNTR1_PODR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x100000) >> 20
}
func (o *PORT1_Type) SetPCNTR1_PODR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x200000)|value<<21)
}
func (o *PORT1_Type) GetPCNTR1_PODR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x200000) >> 21
}
func (o *PORT1_Type) SetPCNTR1_PODR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x400000)|value<<22)
}
func (o *PORT1_Type) GetPCNTR1_PODR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x400000) >> 22
}
func (o *PORT1_Type) SetPCNTR1_PODR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x800000)|value<<23)
}
func (o *PORT1_Type) GetPCNTR1_PODR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x800000) >> 23
}
func (o *PORT1_Type) SetPCNTR1_PODR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT1_Type) GetPCNTR1_PODR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x1000000) >> 24
}
func (o *PORT1_Type) SetPCNTR1_PODR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PORT1_Type) GetPCNTR1_PODR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x2000000) >> 25
}
func (o *PORT1_Type) SetPCNTR1_PODR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PORT1_Type) GetPCNTR1_PODR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x4000000) >> 26
}
func (o *PORT1_Type) SetPCNTR1_PODR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PORT1_Type) GetPCNTR1_PODR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x8000000) >> 27
}
func (o *PORT1_Type) SetPCNTR1_PODR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT1_Type) GetPCNTR1_PODR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x10000000) >> 28
}
func (o *PORT1_Type) SetPCNTR1_PODR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x20000000)|value<<29)
}
func (o *PORT1_Type) GetPCNTR1_PODR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x20000000) >> 29
}
func (o *PORT1_Type) SetPCNTR1_PODR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT1_Type) GetPCNTR1_PODR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x40000000) >> 30
}
func (o *PORT1_Type) SetPCNTR1_PODR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT1_Type) GetPCNTR1_PODR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x80000000) >> 31
}

// PORT1.PCNTR2: Port Control Register 2
func (o *PORT1_Type) SetPCNTR2_PIDR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x1)|value)
}
func (o *PORT1_Type) GetPCNTR2_PIDR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR2.Reg) & 0x1
}
func (o *PORT1_Type) SetPCNTR2_PIDR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x2)|value<<1)
}
func (o *PORT1_Type) GetPCNTR2_PIDR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x2) >> 1
}
func (o *PORT1_Type) SetPCNTR2_PIDR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x4)|value<<2)
}
func (o *PORT1_Type) GetPCNTR2_PIDR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x4) >> 2
}
func (o *PORT1_Type) SetPCNTR2_PIDR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x8)|value<<3)
}
func (o *PORT1_Type) GetPCNTR2_PIDR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x8) >> 3
}
func (o *PORT1_Type) SetPCNTR2_PIDR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x10)|value<<4)
}
func (o *PORT1_Type) GetPCNTR2_PIDR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x10) >> 4
}
func (o *PORT1_Type) SetPCNTR2_PIDR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x20)|value<<5)
}
func (o *PORT1_Type) GetPCNTR2_PIDR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x20) >> 5
}
func (o *PORT1_Type) SetPCNTR2_PIDR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x40)|value<<6)
}
func (o *PORT1_Type) GetPCNTR2_PIDR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x40) >> 6
}
func (o *PORT1_Type) SetPCNTR2_PIDR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x80)|value<<7)
}
func (o *PORT1_Type) GetPCNTR2_PIDR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x80) >> 7
}
func (o *PORT1_Type) SetPCNTR2_PIDR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x100)|value<<8)
}
func (o *PORT1_Type) GetPCNTR2_PIDR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x100) >> 8
}
func (o *PORT1_Type) SetPCNTR2_PIDR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x200)|value<<9)
}
func (o *PORT1_Type) GetPCNTR2_PIDR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x200) >> 9
}
func (o *PORT1_Type) SetPCNTR2_PIDR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x400)|value<<10)
}
func (o *PORT1_Type) GetPCNTR2_PIDR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x400) >> 10
}
func (o *PORT1_Type) SetPCNTR2_PIDR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x800)|value<<11)
}
func (o *PORT1_Type) GetPCNTR2_PIDR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x800) >> 11
}
func (o *PORT1_Type) SetPCNTR2_PIDR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x1000)|value<<12)
}
func (o *PORT1_Type) GetPCNTR2_PIDR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x1000) >> 12
}
func (o *PORT1_Type) SetPCNTR2_PIDR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x2000)|value<<13)
}
func (o *PORT1_Type) GetPCNTR2_PIDR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x2000) >> 13
}
func (o *PORT1_Type) SetPCNTR2_PIDR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x4000)|value<<14)
}
func (o *PORT1_Type) GetPCNTR2_PIDR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x4000) >> 14
}
func (o *PORT1_Type) SetPCNTR2_PIDR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x8000)|value<<15)
}
func (o *PORT1_Type) GetPCNTR2_PIDR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x8000) >> 15
}
func (o *PORT1_Type) SetPCNTR2_EIDR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x10000)|value<<16)
}
func (o *PORT1_Type) GetPCNTR2_EIDR00() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x10000) >> 16
}
func (o *PORT1_Type) SetPCNTR2_EIDR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x20000)|value<<17)
}
func (o *PORT1_Type) GetPCNTR2_EIDR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x20000) >> 17
}
func (o *PORT1_Type) SetPCNTR2_EIDR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x40000)|value<<18)
}
func (o *PORT1_Type) GetPCNTR2_EIDR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x40000) >> 18
}
func (o *PORT1_Type) SetPCNTR2_EIDR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x80000)|value<<19)
}
func (o *PORT1_Type) GetPCNTR2_EIDR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x80000) >> 19
}
func (o *PORT1_Type) SetPCNTR2_EIDR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x100000)|value<<20)
}
func (o *PORT1_Type) GetPCNTR2_EIDR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x100000) >> 20
}
func (o *PORT1_Type) SetPCNTR2_EIDR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x200000)|value<<21)
}
func (o *PORT1_Type) GetPCNTR2_EIDR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x200000) >> 21
}
func (o *PORT1_Type) SetPCNTR2_EIDR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x400000)|value<<22)
}
func (o *PORT1_Type) GetPCNTR2_EIDR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x400000) >> 22
}
func (o *PORT1_Type) SetPCNTR2_EIDR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x800000)|value<<23)
}
func (o *PORT1_Type) GetPCNTR2_EIDR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x800000) >> 23
}
func (o *PORT1_Type) SetPCNTR2_EIDR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT1_Type) GetPCNTR2_EIDR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x1000000) >> 24
}
func (o *PORT1_Type) SetPCNTR2_EIDR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x2000000)|value<<25)
}
func (o *PORT1_Type) GetPCNTR2_EIDR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x2000000) >> 25
}
func (o *PORT1_Type) SetPCNTR2_EIDR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x4000000)|value<<26)
}
func (o *PORT1_Type) GetPCNTR2_EIDR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x4000000) >> 26
}
func (o *PORT1_Type) SetPCNTR2_EIDR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x8000000)|value<<27)
}
func (o *PORT1_Type) GetPCNTR2_EIDR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x8000000) >> 27
}
func (o *PORT1_Type) SetPCNTR2_EIDR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT1_Type) GetPCNTR2_EIDR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x10000000) >> 28
}
func (o *PORT1_Type) SetPCNTR2_EIDR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x20000000)|value<<29)
}
func (o *PORT1_Type) GetPCNTR2_EIDR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x20000000) >> 29
}
func (o *PORT1_Type) SetPCNTR2_EIDR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT1_Type) GetPCNTR2_EIDR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x40000000) >> 30
}
func (o *PORT1_Type) SetPCNTR2_EIDR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT1_Type) GetPCNTR2_EIDR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x80000000) >> 31
}

// PORT1.PCNTR3: Port Control Register 3
func (o *PORT1_Type) SetPCNTR3_POSR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x1)|value)
}
func (o *PORT1_Type) GetPCNTR3_POSR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR3.Reg) & 0x1
}
func (o *PORT1_Type) SetPCNTR3_POSR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x2)|value<<1)
}
func (o *PORT1_Type) GetPCNTR3_POSR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x2) >> 1
}
func (o *PORT1_Type) SetPCNTR3_POSR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x4)|value<<2)
}
func (o *PORT1_Type) GetPCNTR3_POSR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x4) >> 2
}
func (o *PORT1_Type) SetPCNTR3_POSR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x8)|value<<3)
}
func (o *PORT1_Type) GetPCNTR3_POSR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x8) >> 3
}
func (o *PORT1_Type) SetPCNTR3_POSR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x10)|value<<4)
}
func (o *PORT1_Type) GetPCNTR3_POSR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x10) >> 4
}
func (o *PORT1_Type) SetPCNTR3_POSR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x20)|value<<5)
}
func (o *PORT1_Type) GetPCNTR3_POSR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x20) >> 5
}
func (o *PORT1_Type) SetPCNTR3_POSR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x40)|value<<6)
}
func (o *PORT1_Type) GetPCNTR3_POSR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x40) >> 6
}
func (o *PORT1_Type) SetPCNTR3_POSR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x80)|value<<7)
}
func (o *PORT1_Type) GetPCNTR3_POSR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x80) >> 7
}
func (o *PORT1_Type) SetPCNTR3_POSR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x100)|value<<8)
}
func (o *PORT1_Type) GetPCNTR3_POSR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x100) >> 8
}
func (o *PORT1_Type) SetPCNTR3_POSR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x200)|value<<9)
}
func (o *PORT1_Type) GetPCNTR3_POSR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x200) >> 9
}
func (o *PORT1_Type) SetPCNTR3_POSR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x400)|value<<10)
}
func (o *PORT1_Type) GetPCNTR3_POSR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x400) >> 10
}
func (o *PORT1_Type) SetPCNTR3_POSR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x800)|value<<11)
}
func (o *PORT1_Type) GetPCNTR3_POSR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x800) >> 11
}
func (o *PORT1_Type) SetPCNTR3_POSR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x1000)|value<<12)
}
func (o *PORT1_Type) GetPCNTR3_POSR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x1000) >> 12
}
func (o *PORT1_Type) SetPCNTR3_POSR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x2000)|value<<13)
}
func (o *PORT1_Type) GetPCNTR3_POSR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x2000) >> 13
}
func (o *PORT1_Type) SetPCNTR3_POSR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x4000)|value<<14)
}
func (o *PORT1_Type) GetPCNTR3_POSR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x4000) >> 14
}
func (o *PORT1_Type) SetPCNTR3_POSR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x8000)|value<<15)
}
func (o *PORT1_Type) GetPCNTR3_POSR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x8000) >> 15
}
func (o *PORT1_Type) SetPCNTR3_PORR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x10000)|value<<16)
}
func (o *PORT1_Type) GetPCNTR3_PORR00() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x10000) >> 16
}
func (o *PORT1_Type) SetPCNTR3_PORR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x20000)|value<<17)
}
func (o *PORT1_Type) GetPCNTR3_PORR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x20000) >> 17
}
func (o *PORT1_Type) SetPCNTR3_PORR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x40000)|value<<18)
}
func (o *PORT1_Type) GetPCNTR3_PORR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x40000) >> 18
}
func (o *PORT1_Type) SetPCNTR3_PORR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x80000)|value<<19)
}
func (o *PORT1_Type) GetPCNTR3_PORR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x80000) >> 19
}
func (o *PORT1_Type) SetPCNTR3_PORR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x100000)|value<<20)
}
func (o *PORT1_Type) GetPCNTR3_PORR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x100000) >> 20
}
func (o *PORT1_Type) SetPCNTR3_PORR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x200000)|value<<21)
}
func (o *PORT1_Type) GetPCNTR3_PORR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x200000) >> 21
}
func (o *PORT1_Type) SetPCNTR3_PORR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x400000)|value<<22)
}
func (o *PORT1_Type) GetPCNTR3_PORR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x400000) >> 22
}
func (o *PORT1_Type) SetPCNTR3_PORR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x800000)|value<<23)
}
func (o *PORT1_Type) GetPCNTR3_PORR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x800000) >> 23
}
func (o *PORT1_Type) SetPCNTR3_PORR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT1_Type) GetPCNTR3_PORR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x1000000) >> 24
}
func (o *PORT1_Type) SetPCNTR3_PORR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x2000000)|value<<25)
}
func (o *PORT1_Type) GetPCNTR3_PORR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x2000000) >> 25
}
func (o *PORT1_Type) SetPCNTR3_PORR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x4000000)|value<<26)
}
func (o *PORT1_Type) GetPCNTR3_PORR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x4000000) >> 26
}
func (o *PORT1_Type) SetPCNTR3_PORR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x8000000)|value<<27)
}
func (o *PORT1_Type) GetPCNTR3_PORR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x8000000) >> 27
}
func (o *PORT1_Type) SetPCNTR3_PORR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT1_Type) GetPCNTR3_PORR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x10000000) >> 28
}
func (o *PORT1_Type) SetPCNTR3_PORR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x20000000)|value<<29)
}
func (o *PORT1_Type) GetPCNTR3_PORR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x20000000) >> 29
}
func (o *PORT1_Type) SetPCNTR3_PORR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT1_Type) GetPCNTR3_PORR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x40000000) >> 30
}
func (o *PORT1_Type) SetPCNTR3_PORR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT1_Type) GetPCNTR3_PORR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x80000000) >> 31
}

// PORT1.PCNTR4: Port Control Register 4
func (o *PORT1_Type) SetPCNTR4_EOSR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x1)|value)
}
func (o *PORT1_Type) GetPCNTR4_EOSR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR4.Reg) & 0x1
}
func (o *PORT1_Type) SetPCNTR4_EOSR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x2)|value<<1)
}
func (o *PORT1_Type) GetPCNTR4_EOSR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x2) >> 1
}
func (o *PORT1_Type) SetPCNTR4_EOSR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x4)|value<<2)
}
func (o *PORT1_Type) GetPCNTR4_EOSR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x4) >> 2
}
func (o *PORT1_Type) SetPCNTR4_EOSR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x8)|value<<3)
}
func (o *PORT1_Type) GetPCNTR4_EOSR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x8) >> 3
}
func (o *PORT1_Type) SetPCNTR4_EOSR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x10)|value<<4)
}
func (o *PORT1_Type) GetPCNTR4_EOSR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x10) >> 4
}
func (o *PORT1_Type) SetPCNTR4_EOSR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x20)|value<<5)
}
func (o *PORT1_Type) GetPCNTR4_EOSR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x20) >> 5
}
func (o *PORT1_Type) SetPCNTR4_EOSR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x40)|value<<6)
}
func (o *PORT1_Type) GetPCNTR4_EOSR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x40) >> 6
}
func (o *PORT1_Type) SetPCNTR4_EOSR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x80)|value<<7)
}
func (o *PORT1_Type) GetPCNTR4_EOSR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x80) >> 7
}
func (o *PORT1_Type) SetPCNTR4_EOSR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x100)|value<<8)
}
func (o *PORT1_Type) GetPCNTR4_EOSR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x100) >> 8
}
func (o *PORT1_Type) SetPCNTR4_EOSR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x200)|value<<9)
}
func (o *PORT1_Type) GetPCNTR4_EOSR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x200) >> 9
}
func (o *PORT1_Type) SetPCNTR4_EOSR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x400)|value<<10)
}
func (o *PORT1_Type) GetPCNTR4_EOSR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x400) >> 10
}
func (o *PORT1_Type) SetPCNTR4_EOSR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x800)|value<<11)
}
func (o *PORT1_Type) GetPCNTR4_EOSR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x800) >> 11
}
func (o *PORT1_Type) SetPCNTR4_EOSR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x1000)|value<<12)
}
func (o *PORT1_Type) GetPCNTR4_EOSR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x1000) >> 12
}
func (o *PORT1_Type) SetPCNTR4_EOSR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x2000)|value<<13)
}
func (o *PORT1_Type) GetPCNTR4_EOSR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x2000) >> 13
}
func (o *PORT1_Type) SetPCNTR4_EOSR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x4000)|value<<14)
}
func (o *PORT1_Type) GetPCNTR4_EOSR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x4000) >> 14
}
func (o *PORT1_Type) SetPCNTR4_EOSR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x8000)|value<<15)
}
func (o *PORT1_Type) GetPCNTR4_EOSR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x8000) >> 15
}
func (o *PORT1_Type) SetPCNTR4_EORR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x10000)|value<<16)
}
func (o *PORT1_Type) GetPCNTR4_EORR00() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x10000) >> 16
}
func (o *PORT1_Type) SetPCNTR4_EORR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x20000)|value<<17)
}
func (o *PORT1_Type) GetPCNTR4_EORR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x20000) >> 17
}
func (o *PORT1_Type) SetPCNTR4_EORR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x40000)|value<<18)
}
func (o *PORT1_Type) GetPCNTR4_EORR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x40000) >> 18
}
func (o *PORT1_Type) SetPCNTR4_EORR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x80000)|value<<19)
}
func (o *PORT1_Type) GetPCNTR4_EORR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x80000) >> 19
}
func (o *PORT1_Type) SetPCNTR4_EORR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x100000)|value<<20)
}
func (o *PORT1_Type) GetPCNTR4_EORR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x100000) >> 20
}
func (o *PORT1_Type) SetPCNTR4_EORR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x200000)|value<<21)
}
func (o *PORT1_Type) GetPCNTR4_EORR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x200000) >> 21
}
func (o *PORT1_Type) SetPCNTR4_EORR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x400000)|value<<22)
}
func (o *PORT1_Type) GetPCNTR4_EORR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x400000) >> 22
}
func (o *PORT1_Type) SetPCNTR4_EORR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x800000)|value<<23)
}
func (o *PORT1_Type) GetPCNTR4_EORR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x800000) >> 23
}
func (o *PORT1_Type) SetPCNTR4_EORR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT1_Type) GetPCNTR4_EORR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x1000000) >> 24
}
func (o *PORT1_Type) SetPCNTR4_EORR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x2000000)|value<<25)
}
func (o *PORT1_Type) GetPCNTR4_EORR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x2000000) >> 25
}
func (o *PORT1_Type) SetPCNTR4_EORR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x4000000)|value<<26)
}
func (o *PORT1_Type) GetPCNTR4_EORR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x4000000) >> 26
}
func (o *PORT1_Type) SetPCNTR4_EORR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x8000000)|value<<27)
}
func (o *PORT1_Type) GetPCNTR4_EORR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x8000000) >> 27
}
func (o *PORT1_Type) SetPCNTR4_EORR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT1_Type) GetPCNTR4_EORR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x10000000) >> 28
}
func (o *PORT1_Type) SetPCNTR4_EORR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x20000000)|value<<29)
}
func (o *PORT1_Type) GetPCNTR4_EORR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x20000000) >> 29
}
func (o *PORT1_Type) SetPCNTR4_EORR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT1_Type) GetPCNTR4_EORR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x40000000) >> 30
}
func (o *PORT1_Type) SetPCNTR4_EORR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT1_Type) GetPCNTR4_EORR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x80000000) >> 31
}

// Pmn Pin Function Control Register
type PFS_Type struct {
	P000PFS volatile.Register32 // 0x0
	P001PFS volatile.Register32 // 0x4
	P002PFS volatile.Register32 // 0x8
	P003PFS volatile.Register32 // 0xC
	P004PFS volatile.Register32 // 0x10
	P005PFS volatile.Register32 // 0x14
	P006PFS volatile.Register32 // 0x18
	P007PFS volatile.Register32 // 0x1C
	P008PFS volatile.Register32 // 0x20
	_       [4]byte
	P010PFS volatile.Register32 // 0x28
	P011PFS volatile.Register32 // 0x2C
	P012PFS volatile.Register32 // 0x30
	P013PFS volatile.Register32 // 0x34
	P014PFS volatile.Register32 // 0x38
	P015PFS volatile.Register32 // 0x3C
	P100PFS volatile.Register32 // 0x40
	P101PFS volatile.Register32 // 0x44
	P102PFS volatile.Register32 // 0x48
	P103PFS volatile.Register32 // 0x4C
	P104PFS volatile.Register32 // 0x50
	P105PFS volatile.Register32 // 0x54
	P106PFS volatile.Register32 // 0x58
	P107PFS volatile.Register32 // 0x5C
	P108PFS volatile.Register32 // 0x60
	P109PFS volatile.Register32 // 0x64
	P110PFS volatile.Register32 // 0x68
	P111PFS volatile.Register32 // 0x6C
	P112PFS volatile.Register32 // 0x70
	P113PFS volatile.Register32 // 0x74
	P114PFS volatile.Register32 // 0x78
	P115PFS volatile.Register32 // 0x7C
	P200PFS volatile.Register32 // 0x80
	P201PFS volatile.Register32 // 0x84
	P202PFS volatile.Register32 // 0x88
	P203PFS volatile.Register32 // 0x8C
	P204PFS volatile.Register32 // 0x90
	P205PFS volatile.Register32 // 0x94
	P206PFS volatile.Register32 // 0x98
	P207PFS volatile.Register32 // 0x9C
	P208PFS volatile.Register32 // 0xA0
	_       [12]byte
	P212PFS volatile.Register32 // 0xB0
	P213PFS volatile.Register32 // 0xB4
	P214PFS volatile.Register32 // 0xB8
	P215PFS volatile.Register32 // 0xBC
	P300PFS volatile.Register32 // 0xC0
	P301PFS volatile.Register32 // 0xC4
	P302PFS volatile.Register32 // 0xC8
	P303PFS volatile.Register32 // 0xCC
	P304PFS volatile.Register32 // 0xD0
	P305PFS volatile.Register32 // 0xD4
	P306PFS volatile.Register32 // 0xD8
	P307PFS volatile.Register32 // 0xDC
	_       [32]byte
	P400PFS volatile.Register32 // 0x100
	P401PFS volatile.Register32 // 0x104
	P402PFS volatile.Register32 // 0x108
	P403PFS volatile.Register32 // 0x10C
	P404PFS volatile.Register32 // 0x110
	P405PFS volatile.Register32 // 0x114
	P406PFS volatile.Register32 // 0x118
	P407PFS volatile.Register32 // 0x11C
	P408PFS volatile.Register32 // 0x120
	P409PFS volatile.Register32 // 0x124
	P410PFS volatile.Register32 // 0x128
	P411PFS volatile.Register32 // 0x12C
	_       [16]byte
	P500PFS volatile.Register32 // 0x140
	P501PFS volatile.Register32 // 0x144
	P502PFS volatile.Register32 // 0x148
	P503PFS volatile.Register32 // 0x14C
	P504PFS volatile.Register32 // 0x150
	P505PFS volatile.Register32 // 0x154
	_       [284]byte
	P913PFS volatile.Register32 // 0x274
	P914PFS volatile.Register32 // 0x278
	P915PFS volatile.Register32 // 0x27C
	_       [643]byte
	PWPR    volatile.Register8 // 0x503
	_       [11]byte
	PRWCNTR volatile.Register8 // 0x50F
}

// PFS.P000PFS: Port 00%s Pin Function Select Register
func (o *PFS_Type) SetP000PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P000PFS.Reg, volatile.LoadUint32(&o.P000PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP000PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P000PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP000PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P000PFS.Reg, volatile.LoadUint32(&o.P000PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP000PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P000PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP000PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P000PFS.Reg, volatile.LoadUint32(&o.P000PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP000PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P000PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP000PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P000PFS.Reg, volatile.LoadUint32(&o.P000PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP000PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P000PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP000PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P000PFS.Reg, volatile.LoadUint32(&o.P000PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP000PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P000PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP000PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P000PFS.Reg, volatile.LoadUint32(&o.P000PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP000PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P000PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP000PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P000PFS.Reg, volatile.LoadUint32(&o.P000PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP000PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P000PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP000PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P000PFS.Reg, volatile.LoadUint32(&o.P000PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP000PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P000PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP000PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P000PFS.Reg, volatile.LoadUint32(&o.P000PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP000PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P000PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P001PFS: Port 00%s Pin Function Select Register
func (o *PFS_Type) SetP001PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P001PFS.Reg, volatile.LoadUint32(&o.P001PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP001PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P001PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP001PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P001PFS.Reg, volatile.LoadUint32(&o.P001PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP001PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P001PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP001PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P001PFS.Reg, volatile.LoadUint32(&o.P001PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP001PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P001PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP001PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P001PFS.Reg, volatile.LoadUint32(&o.P001PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP001PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P001PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP001PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P001PFS.Reg, volatile.LoadUint32(&o.P001PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP001PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P001PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP001PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P001PFS.Reg, volatile.LoadUint32(&o.P001PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP001PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P001PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP001PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P001PFS.Reg, volatile.LoadUint32(&o.P001PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP001PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P001PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP001PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P001PFS.Reg, volatile.LoadUint32(&o.P001PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP001PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P001PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP001PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P001PFS.Reg, volatile.LoadUint32(&o.P001PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP001PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P001PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P002PFS: Port 00%s Pin Function Select Register
func (o *PFS_Type) SetP002PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P002PFS.Reg, volatile.LoadUint32(&o.P002PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP002PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P002PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP002PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P002PFS.Reg, volatile.LoadUint32(&o.P002PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP002PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P002PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP002PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P002PFS.Reg, volatile.LoadUint32(&o.P002PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP002PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P002PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP002PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P002PFS.Reg, volatile.LoadUint32(&o.P002PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP002PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P002PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP002PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P002PFS.Reg, volatile.LoadUint32(&o.P002PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP002PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P002PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP002PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P002PFS.Reg, volatile.LoadUint32(&o.P002PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP002PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P002PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP002PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P002PFS.Reg, volatile.LoadUint32(&o.P002PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP002PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P002PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP002PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P002PFS.Reg, volatile.LoadUint32(&o.P002PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP002PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P002PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP002PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P002PFS.Reg, volatile.LoadUint32(&o.P002PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP002PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P002PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P003PFS: Port 00%s Pin Function Select Register
func (o *PFS_Type) SetP003PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P003PFS.Reg, volatile.LoadUint32(&o.P003PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP003PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P003PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP003PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P003PFS.Reg, volatile.LoadUint32(&o.P003PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP003PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P003PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP003PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P003PFS.Reg, volatile.LoadUint32(&o.P003PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP003PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P003PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP003PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P003PFS.Reg, volatile.LoadUint32(&o.P003PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP003PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P003PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP003PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P003PFS.Reg, volatile.LoadUint32(&o.P003PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP003PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P003PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP003PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P003PFS.Reg, volatile.LoadUint32(&o.P003PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP003PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P003PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP003PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P003PFS.Reg, volatile.LoadUint32(&o.P003PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP003PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P003PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP003PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P003PFS.Reg, volatile.LoadUint32(&o.P003PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP003PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P003PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP003PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P003PFS.Reg, volatile.LoadUint32(&o.P003PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP003PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P003PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P004PFS: Port 00%s Pin Function Select Register
func (o *PFS_Type) SetP004PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P004PFS.Reg, volatile.LoadUint32(&o.P004PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP004PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P004PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP004PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P004PFS.Reg, volatile.LoadUint32(&o.P004PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP004PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P004PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP004PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P004PFS.Reg, volatile.LoadUint32(&o.P004PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP004PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P004PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP004PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P004PFS.Reg, volatile.LoadUint32(&o.P004PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP004PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P004PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP004PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P004PFS.Reg, volatile.LoadUint32(&o.P004PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP004PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P004PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP004PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P004PFS.Reg, volatile.LoadUint32(&o.P004PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP004PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P004PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP004PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P004PFS.Reg, volatile.LoadUint32(&o.P004PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP004PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P004PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP004PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P004PFS.Reg, volatile.LoadUint32(&o.P004PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP004PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P004PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP004PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P004PFS.Reg, volatile.LoadUint32(&o.P004PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP004PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P004PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P005PFS: Port 00%s Pin Function Select Register
func (o *PFS_Type) SetP005PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P005PFS.Reg, volatile.LoadUint32(&o.P005PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP005PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P005PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP005PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P005PFS.Reg, volatile.LoadUint32(&o.P005PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP005PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P005PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP005PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P005PFS.Reg, volatile.LoadUint32(&o.P005PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP005PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P005PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP005PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P005PFS.Reg, volatile.LoadUint32(&o.P005PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP005PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P005PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP005PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P005PFS.Reg, volatile.LoadUint32(&o.P005PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP005PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P005PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP005PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P005PFS.Reg, volatile.LoadUint32(&o.P005PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP005PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P005PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP005PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P005PFS.Reg, volatile.LoadUint32(&o.P005PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP005PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P005PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP005PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P005PFS.Reg, volatile.LoadUint32(&o.P005PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP005PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P005PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP005PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P005PFS.Reg, volatile.LoadUint32(&o.P005PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP005PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P005PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P006PFS: Port 00%s Pin Function Select Register
func (o *PFS_Type) SetP006PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P006PFS.Reg, volatile.LoadUint32(&o.P006PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP006PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P006PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP006PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P006PFS.Reg, volatile.LoadUint32(&o.P006PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP006PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P006PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP006PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P006PFS.Reg, volatile.LoadUint32(&o.P006PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP006PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P006PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP006PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P006PFS.Reg, volatile.LoadUint32(&o.P006PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP006PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P006PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP006PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P006PFS.Reg, volatile.LoadUint32(&o.P006PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP006PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P006PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP006PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P006PFS.Reg, volatile.LoadUint32(&o.P006PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP006PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P006PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP006PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P006PFS.Reg, volatile.LoadUint32(&o.P006PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP006PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P006PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP006PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P006PFS.Reg, volatile.LoadUint32(&o.P006PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP006PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P006PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP006PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P006PFS.Reg, volatile.LoadUint32(&o.P006PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP006PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P006PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P007PFS: Port 00%s Pin Function Select Register
func (o *PFS_Type) SetP007PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P007PFS.Reg, volatile.LoadUint32(&o.P007PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP007PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P007PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP007PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P007PFS.Reg, volatile.LoadUint32(&o.P007PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP007PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P007PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP007PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P007PFS.Reg, volatile.LoadUint32(&o.P007PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP007PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P007PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP007PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P007PFS.Reg, volatile.LoadUint32(&o.P007PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP007PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P007PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP007PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P007PFS.Reg, volatile.LoadUint32(&o.P007PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP007PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P007PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP007PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P007PFS.Reg, volatile.LoadUint32(&o.P007PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP007PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P007PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP007PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P007PFS.Reg, volatile.LoadUint32(&o.P007PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP007PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P007PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP007PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P007PFS.Reg, volatile.LoadUint32(&o.P007PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP007PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P007PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP007PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P007PFS.Reg, volatile.LoadUint32(&o.P007PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP007PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P007PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P008PFS: Port 00%s Pin Function Select Register
func (o *PFS_Type) SetP008PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P008PFS.Reg, volatile.LoadUint32(&o.P008PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP008PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P008PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP008PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P008PFS.Reg, volatile.LoadUint32(&o.P008PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP008PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P008PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP008PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P008PFS.Reg, volatile.LoadUint32(&o.P008PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP008PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P008PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP008PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P008PFS.Reg, volatile.LoadUint32(&o.P008PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP008PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P008PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP008PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P008PFS.Reg, volatile.LoadUint32(&o.P008PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP008PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P008PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP008PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P008PFS.Reg, volatile.LoadUint32(&o.P008PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP008PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P008PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP008PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P008PFS.Reg, volatile.LoadUint32(&o.P008PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP008PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P008PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP008PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P008PFS.Reg, volatile.LoadUint32(&o.P008PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP008PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P008PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP008PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P008PFS.Reg, volatile.LoadUint32(&o.P008PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP008PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P008PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P010PFS: Port 0%s Pin Function Select Register
func (o *PFS_Type) SetP010PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP010PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P010PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP010PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP010PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP010PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP010PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP010PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP010PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP010PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP010PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP010PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP010PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP010PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP010PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP010PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP010PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP010PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP010PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P011PFS: Port 0%s Pin Function Select Register
func (o *PFS_Type) SetP011PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP011PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P011PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP011PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP011PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP011PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP011PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP011PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP011PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP011PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP011PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP011PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP011PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP011PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP011PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP011PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP011PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP011PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP011PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P012PFS: Port 0%s Pin Function Select Register
func (o *PFS_Type) SetP012PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P012PFS.Reg, volatile.LoadUint32(&o.P012PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP012PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P012PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP012PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P012PFS.Reg, volatile.LoadUint32(&o.P012PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP012PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P012PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP012PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P012PFS.Reg, volatile.LoadUint32(&o.P012PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP012PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P012PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP012PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P012PFS.Reg, volatile.LoadUint32(&o.P012PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP012PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P012PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP012PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P012PFS.Reg, volatile.LoadUint32(&o.P012PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP012PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P012PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP012PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P012PFS.Reg, volatile.LoadUint32(&o.P012PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP012PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P012PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP012PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P012PFS.Reg, volatile.LoadUint32(&o.P012PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP012PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P012PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP012PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P012PFS.Reg, volatile.LoadUint32(&o.P012PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP012PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P012PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP012PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P012PFS.Reg, volatile.LoadUint32(&o.P012PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP012PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P012PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P013PFS: Port 0%s Pin Function Select Register
func (o *PFS_Type) SetP013PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P013PFS.Reg, volatile.LoadUint32(&o.P013PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP013PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P013PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP013PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P013PFS.Reg, volatile.LoadUint32(&o.P013PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP013PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P013PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP013PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P013PFS.Reg, volatile.LoadUint32(&o.P013PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP013PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P013PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP013PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P013PFS.Reg, volatile.LoadUint32(&o.P013PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP013PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P013PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP013PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P013PFS.Reg, volatile.LoadUint32(&o.P013PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP013PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P013PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP013PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P013PFS.Reg, volatile.LoadUint32(&o.P013PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP013PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P013PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP013PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P013PFS.Reg, volatile.LoadUint32(&o.P013PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP013PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P013PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP013PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P013PFS.Reg, volatile.LoadUint32(&o.P013PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP013PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P013PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP013PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P013PFS.Reg, volatile.LoadUint32(&o.P013PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP013PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P013PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P014PFS: Port 0%s Pin Function Select Register
func (o *PFS_Type) SetP014PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP014PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P014PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP014PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP014PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP014PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP014PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP014PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP014PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP014PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP014PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP014PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP014PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP014PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP014PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP014PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP014PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP014PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP014PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P015PFS: Port 0%s Pin Function Select Register
func (o *PFS_Type) SetP015PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP015PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P015PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP015PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP015PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP015PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP015PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP015PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP015PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP015PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP015PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP015PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP015PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP015PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP015PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP015PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP015PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP015PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP015PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P100PFS: Port 10%s Pin Function Select Register
func (o *PFS_Type) SetP100PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP100PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P100PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP100PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP100PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP100PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP100PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP100PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP100PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP100PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP100PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP100PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP100PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP100PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP100PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP100PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP100PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP100PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP100PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP100PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP100PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P101PFS: Port 10%s Pin Function Select Register
func (o *PFS_Type) SetP101PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP101PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P101PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP101PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP101PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP101PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP101PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP101PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP101PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP101PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP101PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP101PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP101PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP101PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP101PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP101PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP101PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP101PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP101PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP101PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP101PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P102PFS: Port 10%s Pin Function Select Register
func (o *PFS_Type) SetP102PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP102PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P102PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP102PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP102PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP102PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP102PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP102PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP102PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP102PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP102PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP102PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP102PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP102PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP102PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP102PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP102PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP102PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP102PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP102PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP102PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P103PFS: Port 10%s Pin Function Select Register
func (o *PFS_Type) SetP103PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP103PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P103PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP103PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP103PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP103PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP103PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP103PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP103PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP103PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP103PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP103PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP103PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP103PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP103PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP103PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP103PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP103PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP103PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP103PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP103PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P104PFS: Port 10%s Pin Function Select Register
func (o *PFS_Type) SetP104PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P104PFS.Reg, volatile.LoadUint32(&o.P104PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP104PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P104PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP104PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P104PFS.Reg, volatile.LoadUint32(&o.P104PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP104PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P104PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP104PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P104PFS.Reg, volatile.LoadUint32(&o.P104PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP104PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P104PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP104PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P104PFS.Reg, volatile.LoadUint32(&o.P104PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP104PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P104PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP104PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P104PFS.Reg, volatile.LoadUint32(&o.P104PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP104PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P104PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP104PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P104PFS.Reg, volatile.LoadUint32(&o.P104PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP104PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P104PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP104PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P104PFS.Reg, volatile.LoadUint32(&o.P104PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP104PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P104PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP104PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P104PFS.Reg, volatile.LoadUint32(&o.P104PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP104PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P104PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP104PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P104PFS.Reg, volatile.LoadUint32(&o.P104PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP104PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P104PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP104PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P104PFS.Reg, volatile.LoadUint32(&o.P104PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP104PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P104PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P105PFS: Port 10%s Pin Function Select Register
func (o *PFS_Type) SetP105PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P105PFS.Reg, volatile.LoadUint32(&o.P105PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP105PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P105PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP105PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P105PFS.Reg, volatile.LoadUint32(&o.P105PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP105PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P105PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP105PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P105PFS.Reg, volatile.LoadUint32(&o.P105PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP105PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P105PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP105PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P105PFS.Reg, volatile.LoadUint32(&o.P105PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP105PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P105PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP105PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P105PFS.Reg, volatile.LoadUint32(&o.P105PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP105PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P105PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP105PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P105PFS.Reg, volatile.LoadUint32(&o.P105PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP105PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P105PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP105PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P105PFS.Reg, volatile.LoadUint32(&o.P105PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP105PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P105PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP105PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P105PFS.Reg, volatile.LoadUint32(&o.P105PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP105PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P105PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP105PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P105PFS.Reg, volatile.LoadUint32(&o.P105PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP105PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P105PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP105PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P105PFS.Reg, volatile.LoadUint32(&o.P105PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP105PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P105PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P106PFS: Port 10%s Pin Function Select Register
func (o *PFS_Type) SetP106PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P106PFS.Reg, volatile.LoadUint32(&o.P106PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP106PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P106PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP106PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P106PFS.Reg, volatile.LoadUint32(&o.P106PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP106PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P106PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP106PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P106PFS.Reg, volatile.LoadUint32(&o.P106PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP106PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P106PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP106PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P106PFS.Reg, volatile.LoadUint32(&o.P106PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP106PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P106PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP106PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P106PFS.Reg, volatile.LoadUint32(&o.P106PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP106PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P106PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP106PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P106PFS.Reg, volatile.LoadUint32(&o.P106PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP106PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P106PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP106PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P106PFS.Reg, volatile.LoadUint32(&o.P106PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP106PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P106PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP106PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P106PFS.Reg, volatile.LoadUint32(&o.P106PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP106PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P106PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP106PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P106PFS.Reg, volatile.LoadUint32(&o.P106PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP106PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P106PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP106PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P106PFS.Reg, volatile.LoadUint32(&o.P106PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP106PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P106PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P107PFS: Port 10%s Pin Function Select Register
func (o *PFS_Type) SetP107PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P107PFS.Reg, volatile.LoadUint32(&o.P107PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP107PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P107PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP107PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P107PFS.Reg, volatile.LoadUint32(&o.P107PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP107PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P107PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP107PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P107PFS.Reg, volatile.LoadUint32(&o.P107PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP107PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P107PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP107PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P107PFS.Reg, volatile.LoadUint32(&o.P107PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP107PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P107PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP107PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P107PFS.Reg, volatile.LoadUint32(&o.P107PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP107PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P107PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP107PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P107PFS.Reg, volatile.LoadUint32(&o.P107PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP107PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P107PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP107PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P107PFS.Reg, volatile.LoadUint32(&o.P107PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP107PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P107PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP107PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P107PFS.Reg, volatile.LoadUint32(&o.P107PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP107PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P107PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP107PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P107PFS.Reg, volatile.LoadUint32(&o.P107PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP107PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P107PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP107PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P107PFS.Reg, volatile.LoadUint32(&o.P107PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP107PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P107PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P108PFS: Port 108 Pin Function Select Register
func (o *PFS_Type) SetP108PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP108PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P108PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP108PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP108PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP108PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP108PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP108PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP108PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP108PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP108PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP108PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP108PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP108PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP108PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP108PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP108PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP108PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP108PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP108PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP108PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P109PFS: Port 109 Pin Function Select Register
func (o *PFS_Type) SetP109PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP109PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P109PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP109PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP109PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP109PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP109PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP109PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP109PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP109PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP109PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP109PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP109PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP109PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP109PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP109PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP109PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP109PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP109PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP109PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP109PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P110PFS: Port 1%s Pin Function Select Register
func (o *PFS_Type) SetP110PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP110PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P110PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP110PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP110PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP110PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP110PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP110PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP110PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP110PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP110PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP110PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP110PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP110PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP110PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP110PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP110PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP110PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP110PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP110PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP110PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P111PFS: Port 1%s Pin Function Select Register
func (o *PFS_Type) SetP111PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP111PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P111PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP111PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP111PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP111PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP111PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP111PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP111PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP111PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP111PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP111PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP111PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP111PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP111PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP111PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP111PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP111PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP111PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP111PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP111PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P112PFS: Port 1%s Pin Function Select Register
func (o *PFS_Type) SetP112PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP112PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P112PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP112PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP112PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP112PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP112PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP112PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP112PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP112PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP112PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP112PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP112PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP112PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP112PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP112PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP112PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP112PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP112PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP112PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP112PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P113PFS: Port 1%s Pin Function Select Register
func (o *PFS_Type) SetP113PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P113PFS.Reg, volatile.LoadUint32(&o.P113PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP113PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P113PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP113PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P113PFS.Reg, volatile.LoadUint32(&o.P113PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP113PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P113PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP113PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P113PFS.Reg, volatile.LoadUint32(&o.P113PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP113PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P113PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP113PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P113PFS.Reg, volatile.LoadUint32(&o.P113PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP113PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P113PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP113PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P113PFS.Reg, volatile.LoadUint32(&o.P113PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP113PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P113PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP113PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P113PFS.Reg, volatile.LoadUint32(&o.P113PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP113PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P113PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP113PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P113PFS.Reg, volatile.LoadUint32(&o.P113PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP113PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P113PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP113PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P113PFS.Reg, volatile.LoadUint32(&o.P113PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP113PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P113PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP113PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P113PFS.Reg, volatile.LoadUint32(&o.P113PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP113PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P113PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP113PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P113PFS.Reg, volatile.LoadUint32(&o.P113PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP113PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P113PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P114PFS: Port 1%s Pin Function Select Register
func (o *PFS_Type) SetP114PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P114PFS.Reg, volatile.LoadUint32(&o.P114PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP114PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P114PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP114PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P114PFS.Reg, volatile.LoadUint32(&o.P114PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP114PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P114PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP114PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P114PFS.Reg, volatile.LoadUint32(&o.P114PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP114PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P114PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP114PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P114PFS.Reg, volatile.LoadUint32(&o.P114PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP114PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P114PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP114PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P114PFS.Reg, volatile.LoadUint32(&o.P114PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP114PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P114PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP114PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P114PFS.Reg, volatile.LoadUint32(&o.P114PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP114PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P114PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP114PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P114PFS.Reg, volatile.LoadUint32(&o.P114PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP114PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P114PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP114PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P114PFS.Reg, volatile.LoadUint32(&o.P114PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP114PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P114PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP114PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P114PFS.Reg, volatile.LoadUint32(&o.P114PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP114PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P114PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP114PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P114PFS.Reg, volatile.LoadUint32(&o.P114PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP114PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P114PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P115PFS: Port 1%s Pin Function Select Register
func (o *PFS_Type) SetP115PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P115PFS.Reg, volatile.LoadUint32(&o.P115PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP115PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P115PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP115PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P115PFS.Reg, volatile.LoadUint32(&o.P115PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP115PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P115PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP115PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P115PFS.Reg, volatile.LoadUint32(&o.P115PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP115PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P115PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP115PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P115PFS.Reg, volatile.LoadUint32(&o.P115PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP115PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P115PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP115PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P115PFS.Reg, volatile.LoadUint32(&o.P115PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP115PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P115PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP115PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P115PFS.Reg, volatile.LoadUint32(&o.P115PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP115PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P115PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP115PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P115PFS.Reg, volatile.LoadUint32(&o.P115PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP115PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P115PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP115PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P115PFS.Reg, volatile.LoadUint32(&o.P115PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP115PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P115PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP115PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P115PFS.Reg, volatile.LoadUint32(&o.P115PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP115PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P115PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP115PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P115PFS.Reg, volatile.LoadUint32(&o.P115PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP115PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P115PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P200PFS: Port 200 Pin Function Select Register
func (o *PFS_Type) SetP200PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP200PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P200PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP200PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP200PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP200PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP200PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP200PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP200PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP200PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP200PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP200PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP200PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP200PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP200PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP200PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP200PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP200PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP200PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP200PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP200PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P201PFS: Port 201 Pin Function Select Register
func (o *PFS_Type) SetP201PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP201PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P201PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP201PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP201PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP201PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP201PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP201PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP201PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP201PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP201PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP201PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP201PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP201PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP201PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP201PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP201PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP201PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP201PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP201PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP201PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P202PFS: Port 20%s Pin Function Select Register
func (o *PFS_Type) SetP202PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P202PFS.Reg, volatile.LoadUint32(&o.P202PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP202PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P202PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP202PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P202PFS.Reg, volatile.LoadUint32(&o.P202PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP202PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P202PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP202PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P202PFS.Reg, volatile.LoadUint32(&o.P202PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP202PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P202PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP202PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P202PFS.Reg, volatile.LoadUint32(&o.P202PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP202PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P202PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP202PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P202PFS.Reg, volatile.LoadUint32(&o.P202PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP202PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P202PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP202PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P202PFS.Reg, volatile.LoadUint32(&o.P202PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP202PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P202PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP202PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P202PFS.Reg, volatile.LoadUint32(&o.P202PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP202PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P202PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP202PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P202PFS.Reg, volatile.LoadUint32(&o.P202PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP202PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P202PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP202PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P202PFS.Reg, volatile.LoadUint32(&o.P202PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP202PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P202PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP202PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P202PFS.Reg, volatile.LoadUint32(&o.P202PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP202PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P202PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P203PFS: Port 20%s Pin Function Select Register
func (o *PFS_Type) SetP203PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P203PFS.Reg, volatile.LoadUint32(&o.P203PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP203PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P203PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP203PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P203PFS.Reg, volatile.LoadUint32(&o.P203PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP203PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P203PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP203PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P203PFS.Reg, volatile.LoadUint32(&o.P203PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP203PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P203PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP203PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P203PFS.Reg, volatile.LoadUint32(&o.P203PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP203PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P203PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP203PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P203PFS.Reg, volatile.LoadUint32(&o.P203PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP203PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P203PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP203PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P203PFS.Reg, volatile.LoadUint32(&o.P203PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP203PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P203PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP203PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P203PFS.Reg, volatile.LoadUint32(&o.P203PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP203PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P203PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP203PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P203PFS.Reg, volatile.LoadUint32(&o.P203PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP203PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P203PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP203PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P203PFS.Reg, volatile.LoadUint32(&o.P203PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP203PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P203PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP203PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P203PFS.Reg, volatile.LoadUint32(&o.P203PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP203PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P203PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P204PFS: Port 20%s Pin Function Select Register
func (o *PFS_Type) SetP204PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P204PFS.Reg, volatile.LoadUint32(&o.P204PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP204PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P204PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP204PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P204PFS.Reg, volatile.LoadUint32(&o.P204PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP204PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P204PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP204PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P204PFS.Reg, volatile.LoadUint32(&o.P204PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP204PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P204PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP204PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P204PFS.Reg, volatile.LoadUint32(&o.P204PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP204PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P204PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP204PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P204PFS.Reg, volatile.LoadUint32(&o.P204PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP204PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P204PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP204PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P204PFS.Reg, volatile.LoadUint32(&o.P204PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP204PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P204PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP204PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P204PFS.Reg, volatile.LoadUint32(&o.P204PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP204PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P204PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP204PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P204PFS.Reg, volatile.LoadUint32(&o.P204PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP204PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P204PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP204PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P204PFS.Reg, volatile.LoadUint32(&o.P204PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP204PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P204PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP204PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P204PFS.Reg, volatile.LoadUint32(&o.P204PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP204PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P204PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P205PFS: Port 20%s Pin Function Select Register
func (o *PFS_Type) SetP205PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP205PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P205PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP205PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP205PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP205PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP205PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP205PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP205PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP205PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP205PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP205PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP205PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP205PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP205PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP205PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP205PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP205PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP205PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP205PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP205PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P206PFS: Port 20%s Pin Function Select Register
func (o *PFS_Type) SetP206PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P206PFS.Reg, volatile.LoadUint32(&o.P206PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP206PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P206PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP206PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P206PFS.Reg, volatile.LoadUint32(&o.P206PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP206PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P206PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP206PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P206PFS.Reg, volatile.LoadUint32(&o.P206PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP206PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P206PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP206PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P206PFS.Reg, volatile.LoadUint32(&o.P206PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP206PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P206PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP206PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P206PFS.Reg, volatile.LoadUint32(&o.P206PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP206PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P206PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP206PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P206PFS.Reg, volatile.LoadUint32(&o.P206PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP206PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P206PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP206PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P206PFS.Reg, volatile.LoadUint32(&o.P206PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP206PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P206PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP206PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P206PFS.Reg, volatile.LoadUint32(&o.P206PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP206PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P206PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP206PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P206PFS.Reg, volatile.LoadUint32(&o.P206PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP206PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P206PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP206PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P206PFS.Reg, volatile.LoadUint32(&o.P206PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP206PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P206PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P207PFS: Port 20%s Pin Function Select Register
func (o *PFS_Type) SetP207PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P207PFS.Reg, volatile.LoadUint32(&o.P207PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP207PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P207PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP207PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P207PFS.Reg, volatile.LoadUint32(&o.P207PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP207PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P207PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP207PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P207PFS.Reg, volatile.LoadUint32(&o.P207PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP207PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P207PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP207PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P207PFS.Reg, volatile.LoadUint32(&o.P207PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP207PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P207PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP207PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P207PFS.Reg, volatile.LoadUint32(&o.P207PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP207PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P207PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP207PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P207PFS.Reg, volatile.LoadUint32(&o.P207PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP207PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P207PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP207PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P207PFS.Reg, volatile.LoadUint32(&o.P207PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP207PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P207PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP207PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P207PFS.Reg, volatile.LoadUint32(&o.P207PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP207PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P207PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP207PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P207PFS.Reg, volatile.LoadUint32(&o.P207PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP207PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P207PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP207PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P207PFS.Reg, volatile.LoadUint32(&o.P207PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP207PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P207PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P208PFS: Port 20%s Pin Function Select Register
func (o *PFS_Type) SetP208PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P208PFS.Reg, volatile.LoadUint32(&o.P208PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP208PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P208PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP208PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P208PFS.Reg, volatile.LoadUint32(&o.P208PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP208PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P208PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP208PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P208PFS.Reg, volatile.LoadUint32(&o.P208PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP208PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P208PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP208PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P208PFS.Reg, volatile.LoadUint32(&o.P208PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP208PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P208PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP208PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P208PFS.Reg, volatile.LoadUint32(&o.P208PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP208PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P208PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP208PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P208PFS.Reg, volatile.LoadUint32(&o.P208PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP208PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P208PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP208PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P208PFS.Reg, volatile.LoadUint32(&o.P208PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP208PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P208PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP208PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P208PFS.Reg, volatile.LoadUint32(&o.P208PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP208PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P208PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP208PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P208PFS.Reg, volatile.LoadUint32(&o.P208PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP208PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P208PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP208PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P208PFS.Reg, volatile.LoadUint32(&o.P208PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP208PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P208PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P212PFS: Port 2%s Pin Function Select Register
func (o *PFS_Type) SetP212PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P212PFS.Reg, volatile.LoadUint32(&o.P212PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP212PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P212PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP212PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P212PFS.Reg, volatile.LoadUint32(&o.P212PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP212PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P212PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP212PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P212PFS.Reg, volatile.LoadUint32(&o.P212PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP212PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P212PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP212PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P212PFS.Reg, volatile.LoadUint32(&o.P212PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP212PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P212PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP212PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P212PFS.Reg, volatile.LoadUint32(&o.P212PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP212PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P212PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP212PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P212PFS.Reg, volatile.LoadUint32(&o.P212PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP212PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P212PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP212PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P212PFS.Reg, volatile.LoadUint32(&o.P212PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP212PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P212PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP212PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P212PFS.Reg, volatile.LoadUint32(&o.P212PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP212PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P212PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP212PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P212PFS.Reg, volatile.LoadUint32(&o.P212PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP212PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P212PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP212PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P212PFS.Reg, volatile.LoadUint32(&o.P212PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP212PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P212PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P213PFS: Port 2%s Pin Function Select Register
func (o *PFS_Type) SetP213PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P213PFS.Reg, volatile.LoadUint32(&o.P213PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP213PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P213PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP213PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P213PFS.Reg, volatile.LoadUint32(&o.P213PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP213PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P213PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP213PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P213PFS.Reg, volatile.LoadUint32(&o.P213PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP213PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P213PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP213PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P213PFS.Reg, volatile.LoadUint32(&o.P213PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP213PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P213PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP213PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P213PFS.Reg, volatile.LoadUint32(&o.P213PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP213PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P213PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP213PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P213PFS.Reg, volatile.LoadUint32(&o.P213PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP213PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P213PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP213PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P213PFS.Reg, volatile.LoadUint32(&o.P213PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP213PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P213PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP213PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P213PFS.Reg, volatile.LoadUint32(&o.P213PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP213PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P213PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP213PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P213PFS.Reg, volatile.LoadUint32(&o.P213PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP213PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P213PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP213PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P213PFS.Reg, volatile.LoadUint32(&o.P213PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP213PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P213PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P214PFS: Port 2%s Pin Function Select Register
func (o *PFS_Type) SetP214PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P214PFS.Reg, volatile.LoadUint32(&o.P214PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP214PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P214PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP214PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P214PFS.Reg, volatile.LoadUint32(&o.P214PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP214PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P214PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP214PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P214PFS.Reg, volatile.LoadUint32(&o.P214PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP214PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P214PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP214PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P214PFS.Reg, volatile.LoadUint32(&o.P214PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP214PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P214PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP214PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P214PFS.Reg, volatile.LoadUint32(&o.P214PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP214PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P214PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP214PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P214PFS.Reg, volatile.LoadUint32(&o.P214PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP214PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P214PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP214PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P214PFS.Reg, volatile.LoadUint32(&o.P214PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP214PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P214PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP214PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P214PFS.Reg, volatile.LoadUint32(&o.P214PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP214PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P214PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP214PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P214PFS.Reg, volatile.LoadUint32(&o.P214PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP214PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P214PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP214PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P214PFS.Reg, volatile.LoadUint32(&o.P214PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP214PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P214PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P215PFS: Port 2%s Pin Function Select Register
func (o *PFS_Type) SetP215PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P215PFS.Reg, volatile.LoadUint32(&o.P215PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP215PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P215PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP215PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P215PFS.Reg, volatile.LoadUint32(&o.P215PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP215PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P215PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP215PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P215PFS.Reg, volatile.LoadUint32(&o.P215PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP215PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P215PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP215PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P215PFS.Reg, volatile.LoadUint32(&o.P215PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP215PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P215PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP215PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P215PFS.Reg, volatile.LoadUint32(&o.P215PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP215PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P215PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP215PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P215PFS.Reg, volatile.LoadUint32(&o.P215PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP215PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P215PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP215PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P215PFS.Reg, volatile.LoadUint32(&o.P215PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP215PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P215PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP215PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P215PFS.Reg, volatile.LoadUint32(&o.P215PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP215PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P215PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP215PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P215PFS.Reg, volatile.LoadUint32(&o.P215PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP215PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P215PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP215PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P215PFS.Reg, volatile.LoadUint32(&o.P215PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP215PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P215PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P300PFS: Port 300 Pin Function Select Register
func (o *PFS_Type) SetP300PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP300PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P300PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP300PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP300PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP300PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP300PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP300PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP300PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP300PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP300PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP300PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP300PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP300PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP300PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP300PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP300PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP300PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP300PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P301PFS: Port 30%s Pin Function Select Register
func (o *PFS_Type) SetP301PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P301PFS.Reg, volatile.LoadUint32(&o.P301PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP301PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P301PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP301PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P301PFS.Reg, volatile.LoadUint32(&o.P301PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP301PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P301PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP301PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P301PFS.Reg, volatile.LoadUint32(&o.P301PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP301PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P301PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP301PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P301PFS.Reg, volatile.LoadUint32(&o.P301PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP301PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P301PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP301PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P301PFS.Reg, volatile.LoadUint32(&o.P301PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP301PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P301PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP301PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P301PFS.Reg, volatile.LoadUint32(&o.P301PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP301PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P301PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP301PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P301PFS.Reg, volatile.LoadUint32(&o.P301PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP301PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P301PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP301PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P301PFS.Reg, volatile.LoadUint32(&o.P301PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP301PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P301PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP301PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P301PFS.Reg, volatile.LoadUint32(&o.P301PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP301PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P301PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P302PFS: Port 30%s Pin Function Select Register
func (o *PFS_Type) SetP302PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P302PFS.Reg, volatile.LoadUint32(&o.P302PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP302PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P302PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP302PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P302PFS.Reg, volatile.LoadUint32(&o.P302PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP302PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P302PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP302PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P302PFS.Reg, volatile.LoadUint32(&o.P302PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP302PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P302PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP302PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P302PFS.Reg, volatile.LoadUint32(&o.P302PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP302PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P302PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP302PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P302PFS.Reg, volatile.LoadUint32(&o.P302PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP302PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P302PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP302PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P302PFS.Reg, volatile.LoadUint32(&o.P302PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP302PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P302PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP302PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P302PFS.Reg, volatile.LoadUint32(&o.P302PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP302PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P302PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP302PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P302PFS.Reg, volatile.LoadUint32(&o.P302PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP302PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P302PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP302PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P302PFS.Reg, volatile.LoadUint32(&o.P302PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP302PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P302PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P303PFS: Port 30%s Pin Function Select Register
func (o *PFS_Type) SetP303PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P303PFS.Reg, volatile.LoadUint32(&o.P303PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP303PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P303PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP303PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P303PFS.Reg, volatile.LoadUint32(&o.P303PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP303PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P303PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP303PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P303PFS.Reg, volatile.LoadUint32(&o.P303PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP303PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P303PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP303PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P303PFS.Reg, volatile.LoadUint32(&o.P303PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP303PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P303PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP303PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P303PFS.Reg, volatile.LoadUint32(&o.P303PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP303PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P303PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP303PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P303PFS.Reg, volatile.LoadUint32(&o.P303PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP303PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P303PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP303PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P303PFS.Reg, volatile.LoadUint32(&o.P303PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP303PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P303PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP303PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P303PFS.Reg, volatile.LoadUint32(&o.P303PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP303PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P303PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP303PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P303PFS.Reg, volatile.LoadUint32(&o.P303PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP303PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P303PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P304PFS: Port 30%s Pin Function Select Register
func (o *PFS_Type) SetP304PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P304PFS.Reg, volatile.LoadUint32(&o.P304PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP304PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P304PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP304PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P304PFS.Reg, volatile.LoadUint32(&o.P304PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP304PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P304PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP304PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P304PFS.Reg, volatile.LoadUint32(&o.P304PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP304PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P304PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP304PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P304PFS.Reg, volatile.LoadUint32(&o.P304PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP304PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P304PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP304PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P304PFS.Reg, volatile.LoadUint32(&o.P304PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP304PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P304PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP304PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P304PFS.Reg, volatile.LoadUint32(&o.P304PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP304PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P304PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP304PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P304PFS.Reg, volatile.LoadUint32(&o.P304PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP304PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P304PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP304PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P304PFS.Reg, volatile.LoadUint32(&o.P304PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP304PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P304PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP304PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P304PFS.Reg, volatile.LoadUint32(&o.P304PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP304PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P304PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P305PFS: Port 30%s Pin Function Select Register
func (o *PFS_Type) SetP305PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P305PFS.Reg, volatile.LoadUint32(&o.P305PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP305PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P305PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP305PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P305PFS.Reg, volatile.LoadUint32(&o.P305PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP305PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P305PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP305PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P305PFS.Reg, volatile.LoadUint32(&o.P305PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP305PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P305PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP305PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P305PFS.Reg, volatile.LoadUint32(&o.P305PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP305PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P305PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP305PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P305PFS.Reg, volatile.LoadUint32(&o.P305PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP305PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P305PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP305PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P305PFS.Reg, volatile.LoadUint32(&o.P305PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP305PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P305PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP305PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P305PFS.Reg, volatile.LoadUint32(&o.P305PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP305PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P305PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP305PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P305PFS.Reg, volatile.LoadUint32(&o.P305PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP305PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P305PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP305PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P305PFS.Reg, volatile.LoadUint32(&o.P305PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP305PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P305PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P306PFS: Port 30%s Pin Function Select Register
func (o *PFS_Type) SetP306PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P306PFS.Reg, volatile.LoadUint32(&o.P306PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP306PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P306PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP306PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P306PFS.Reg, volatile.LoadUint32(&o.P306PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP306PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P306PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP306PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P306PFS.Reg, volatile.LoadUint32(&o.P306PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP306PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P306PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP306PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P306PFS.Reg, volatile.LoadUint32(&o.P306PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP306PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P306PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP306PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P306PFS.Reg, volatile.LoadUint32(&o.P306PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP306PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P306PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP306PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P306PFS.Reg, volatile.LoadUint32(&o.P306PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP306PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P306PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP306PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P306PFS.Reg, volatile.LoadUint32(&o.P306PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP306PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P306PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP306PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P306PFS.Reg, volatile.LoadUint32(&o.P306PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP306PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P306PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP306PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P306PFS.Reg, volatile.LoadUint32(&o.P306PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP306PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P306PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P307PFS: Port 30%s Pin Function Select Register
func (o *PFS_Type) SetP307PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P307PFS.Reg, volatile.LoadUint32(&o.P307PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP307PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P307PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP307PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P307PFS.Reg, volatile.LoadUint32(&o.P307PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP307PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P307PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP307PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P307PFS.Reg, volatile.LoadUint32(&o.P307PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP307PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P307PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP307PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P307PFS.Reg, volatile.LoadUint32(&o.P307PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP307PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P307PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP307PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P307PFS.Reg, volatile.LoadUint32(&o.P307PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP307PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P307PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP307PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P307PFS.Reg, volatile.LoadUint32(&o.P307PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP307PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P307PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP307PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P307PFS.Reg, volatile.LoadUint32(&o.P307PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP307PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P307PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP307PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P307PFS.Reg, volatile.LoadUint32(&o.P307PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP307PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P307PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP307PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P307PFS.Reg, volatile.LoadUint32(&o.P307PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP307PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P307PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P400PFS: Port 40%s Pin Function Select Register
func (o *PFS_Type) SetP400PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP400PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P400PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP400PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP400PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP400PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP400PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP400PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP400PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP400PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP400PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP400PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP400PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP400PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP400PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP400PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP400PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP400PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP400PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P401PFS: Port 40%s Pin Function Select Register
func (o *PFS_Type) SetP401PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP401PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P401PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP401PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP401PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP401PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP401PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP401PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP401PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP401PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP401PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP401PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP401PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP401PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP401PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP401PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP401PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP401PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP401PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P402PFS: Port 40%s Pin Function Select Register
func (o *PFS_Type) SetP402PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P402PFS.Reg, volatile.LoadUint32(&o.P402PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP402PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P402PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP402PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P402PFS.Reg, volatile.LoadUint32(&o.P402PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP402PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P402PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP402PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P402PFS.Reg, volatile.LoadUint32(&o.P402PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP402PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P402PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP402PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P402PFS.Reg, volatile.LoadUint32(&o.P402PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP402PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P402PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP402PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P402PFS.Reg, volatile.LoadUint32(&o.P402PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP402PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P402PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP402PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P402PFS.Reg, volatile.LoadUint32(&o.P402PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP402PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P402PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP402PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P402PFS.Reg, volatile.LoadUint32(&o.P402PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP402PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P402PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP402PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P402PFS.Reg, volatile.LoadUint32(&o.P402PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP402PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P402PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP402PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P402PFS.Reg, volatile.LoadUint32(&o.P402PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP402PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P402PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P403PFS: Port 40%s Pin Function Select Register
func (o *PFS_Type) SetP403PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P403PFS.Reg, volatile.LoadUint32(&o.P403PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP403PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P403PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP403PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P403PFS.Reg, volatile.LoadUint32(&o.P403PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP403PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P403PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP403PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P403PFS.Reg, volatile.LoadUint32(&o.P403PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP403PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P403PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP403PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P403PFS.Reg, volatile.LoadUint32(&o.P403PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP403PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P403PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP403PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P403PFS.Reg, volatile.LoadUint32(&o.P403PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP403PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P403PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP403PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P403PFS.Reg, volatile.LoadUint32(&o.P403PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP403PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P403PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP403PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P403PFS.Reg, volatile.LoadUint32(&o.P403PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP403PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P403PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP403PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P403PFS.Reg, volatile.LoadUint32(&o.P403PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP403PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P403PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP403PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P403PFS.Reg, volatile.LoadUint32(&o.P403PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP403PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P403PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P404PFS: Port 40%s Pin Function Select Register
func (o *PFS_Type) SetP404PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P404PFS.Reg, volatile.LoadUint32(&o.P404PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP404PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P404PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP404PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P404PFS.Reg, volatile.LoadUint32(&o.P404PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP404PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P404PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP404PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P404PFS.Reg, volatile.LoadUint32(&o.P404PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP404PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P404PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP404PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P404PFS.Reg, volatile.LoadUint32(&o.P404PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP404PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P404PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP404PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P404PFS.Reg, volatile.LoadUint32(&o.P404PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP404PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P404PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP404PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P404PFS.Reg, volatile.LoadUint32(&o.P404PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP404PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P404PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP404PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P404PFS.Reg, volatile.LoadUint32(&o.P404PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP404PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P404PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP404PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P404PFS.Reg, volatile.LoadUint32(&o.P404PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP404PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P404PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP404PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P404PFS.Reg, volatile.LoadUint32(&o.P404PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP404PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P404PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P405PFS: Port 40%s Pin Function Select Register
func (o *PFS_Type) SetP405PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P405PFS.Reg, volatile.LoadUint32(&o.P405PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP405PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P405PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP405PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P405PFS.Reg, volatile.LoadUint32(&o.P405PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP405PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P405PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP405PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P405PFS.Reg, volatile.LoadUint32(&o.P405PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP405PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P405PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP405PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P405PFS.Reg, volatile.LoadUint32(&o.P405PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP405PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P405PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP405PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P405PFS.Reg, volatile.LoadUint32(&o.P405PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP405PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P405PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP405PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P405PFS.Reg, volatile.LoadUint32(&o.P405PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP405PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P405PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP405PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P405PFS.Reg, volatile.LoadUint32(&o.P405PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP405PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P405PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP405PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P405PFS.Reg, volatile.LoadUint32(&o.P405PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP405PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P405PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP405PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P405PFS.Reg, volatile.LoadUint32(&o.P405PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP405PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P405PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P406PFS: Port 40%s Pin Function Select Register
func (o *PFS_Type) SetP406PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P406PFS.Reg, volatile.LoadUint32(&o.P406PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP406PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P406PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP406PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P406PFS.Reg, volatile.LoadUint32(&o.P406PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP406PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P406PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP406PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P406PFS.Reg, volatile.LoadUint32(&o.P406PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP406PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P406PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP406PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P406PFS.Reg, volatile.LoadUint32(&o.P406PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP406PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P406PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP406PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P406PFS.Reg, volatile.LoadUint32(&o.P406PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP406PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P406PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP406PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P406PFS.Reg, volatile.LoadUint32(&o.P406PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP406PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P406PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP406PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P406PFS.Reg, volatile.LoadUint32(&o.P406PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP406PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P406PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP406PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P406PFS.Reg, volatile.LoadUint32(&o.P406PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP406PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P406PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP406PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P406PFS.Reg, volatile.LoadUint32(&o.P406PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP406PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P406PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P407PFS: Port 40%s Pin Function Select Register
func (o *PFS_Type) SetP407PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P407PFS.Reg, volatile.LoadUint32(&o.P407PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP407PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P407PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP407PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P407PFS.Reg, volatile.LoadUint32(&o.P407PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP407PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P407PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP407PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P407PFS.Reg, volatile.LoadUint32(&o.P407PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP407PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P407PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP407PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P407PFS.Reg, volatile.LoadUint32(&o.P407PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP407PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P407PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP407PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P407PFS.Reg, volatile.LoadUint32(&o.P407PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP407PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P407PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP407PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P407PFS.Reg, volatile.LoadUint32(&o.P407PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP407PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P407PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP407PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P407PFS.Reg, volatile.LoadUint32(&o.P407PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP407PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P407PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP407PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P407PFS.Reg, volatile.LoadUint32(&o.P407PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP407PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P407PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP407PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P407PFS.Reg, volatile.LoadUint32(&o.P407PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP407PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P407PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P408PFS: Port 40%s Pin Function Select Register
func (o *PFS_Type) SetP408PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P408PFS.Reg, volatile.LoadUint32(&o.P408PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP408PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P408PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP408PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P408PFS.Reg, volatile.LoadUint32(&o.P408PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP408PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P408PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP408PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P408PFS.Reg, volatile.LoadUint32(&o.P408PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP408PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P408PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP408PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P408PFS.Reg, volatile.LoadUint32(&o.P408PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP408PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P408PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP408PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P408PFS.Reg, volatile.LoadUint32(&o.P408PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP408PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P408PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP408PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P408PFS.Reg, volatile.LoadUint32(&o.P408PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP408PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P408PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP408PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P408PFS.Reg, volatile.LoadUint32(&o.P408PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP408PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P408PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP408PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P408PFS.Reg, volatile.LoadUint32(&o.P408PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP408PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P408PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP408PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P408PFS.Reg, volatile.LoadUint32(&o.P408PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP408PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P408PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P409PFS: Port 40%s Pin Function Select Register
func (o *PFS_Type) SetP409PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P409PFS.Reg, volatile.LoadUint32(&o.P409PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP409PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P409PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP409PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P409PFS.Reg, volatile.LoadUint32(&o.P409PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP409PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P409PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP409PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P409PFS.Reg, volatile.LoadUint32(&o.P409PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP409PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P409PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP409PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P409PFS.Reg, volatile.LoadUint32(&o.P409PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP409PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P409PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP409PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P409PFS.Reg, volatile.LoadUint32(&o.P409PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP409PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P409PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP409PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P409PFS.Reg, volatile.LoadUint32(&o.P409PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP409PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P409PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP409PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P409PFS.Reg, volatile.LoadUint32(&o.P409PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP409PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P409PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP409PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P409PFS.Reg, volatile.LoadUint32(&o.P409PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP409PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P409PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP409PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P409PFS.Reg, volatile.LoadUint32(&o.P409PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP409PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P409PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P410PFS: Port 4%s Pin Function Select Register
func (o *PFS_Type) SetP410PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P410PFS.Reg, volatile.LoadUint32(&o.P410PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP410PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P410PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP410PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P410PFS.Reg, volatile.LoadUint32(&o.P410PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP410PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P410PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP410PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P410PFS.Reg, volatile.LoadUint32(&o.P410PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP410PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P410PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP410PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P410PFS.Reg, volatile.LoadUint32(&o.P410PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP410PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P410PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP410PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P410PFS.Reg, volatile.LoadUint32(&o.P410PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP410PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P410PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP410PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P410PFS.Reg, volatile.LoadUint32(&o.P410PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP410PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P410PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP410PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P410PFS.Reg, volatile.LoadUint32(&o.P410PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP410PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P410PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP410PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P410PFS.Reg, volatile.LoadUint32(&o.P410PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP410PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P410PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP410PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P410PFS.Reg, volatile.LoadUint32(&o.P410PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP410PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P410PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P411PFS: Port 4%s Pin Function Select Register
func (o *PFS_Type) SetP411PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P411PFS.Reg, volatile.LoadUint32(&o.P411PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP411PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P411PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP411PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P411PFS.Reg, volatile.LoadUint32(&o.P411PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP411PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P411PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP411PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P411PFS.Reg, volatile.LoadUint32(&o.P411PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP411PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P411PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP411PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P411PFS.Reg, volatile.LoadUint32(&o.P411PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP411PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P411PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP411PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P411PFS.Reg, volatile.LoadUint32(&o.P411PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP411PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P411PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP411PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P411PFS.Reg, volatile.LoadUint32(&o.P411PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP411PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P411PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP411PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P411PFS.Reg, volatile.LoadUint32(&o.P411PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP411PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P411PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP411PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P411PFS.Reg, volatile.LoadUint32(&o.P411PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP411PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P411PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP411PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P411PFS.Reg, volatile.LoadUint32(&o.P411PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP411PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P411PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P500PFS: Port 50%s Pin Function Select Register
func (o *PFS_Type) SetP500PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P500PFS.Reg, volatile.LoadUint32(&o.P500PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP500PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P500PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP500PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P500PFS.Reg, volatile.LoadUint32(&o.P500PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP500PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P500PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP500PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P500PFS.Reg, volatile.LoadUint32(&o.P500PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP500PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P500PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP500PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P500PFS.Reg, volatile.LoadUint32(&o.P500PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP500PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P500PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP500PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P500PFS.Reg, volatile.LoadUint32(&o.P500PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP500PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P500PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP500PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P500PFS.Reg, volatile.LoadUint32(&o.P500PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP500PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P500PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP500PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P500PFS.Reg, volatile.LoadUint32(&o.P500PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP500PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P500PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP500PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P500PFS.Reg, volatile.LoadUint32(&o.P500PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP500PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P500PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP500PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P500PFS.Reg, volatile.LoadUint32(&o.P500PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP500PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P500PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P501PFS: Port 50%s Pin Function Select Register
func (o *PFS_Type) SetP501PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P501PFS.Reg, volatile.LoadUint32(&o.P501PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP501PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P501PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP501PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P501PFS.Reg, volatile.LoadUint32(&o.P501PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP501PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P501PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP501PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P501PFS.Reg, volatile.LoadUint32(&o.P501PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP501PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P501PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP501PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P501PFS.Reg, volatile.LoadUint32(&o.P501PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP501PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P501PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP501PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P501PFS.Reg, volatile.LoadUint32(&o.P501PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP501PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P501PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP501PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P501PFS.Reg, volatile.LoadUint32(&o.P501PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP501PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P501PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP501PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P501PFS.Reg, volatile.LoadUint32(&o.P501PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP501PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P501PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP501PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P501PFS.Reg, volatile.LoadUint32(&o.P501PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP501PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P501PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP501PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P501PFS.Reg, volatile.LoadUint32(&o.P501PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP501PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P501PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P502PFS: Port 50%s Pin Function Select Register
func (o *PFS_Type) SetP502PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P502PFS.Reg, volatile.LoadUint32(&o.P502PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP502PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P502PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP502PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P502PFS.Reg, volatile.LoadUint32(&o.P502PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP502PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P502PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP502PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P502PFS.Reg, volatile.LoadUint32(&o.P502PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP502PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P502PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP502PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P502PFS.Reg, volatile.LoadUint32(&o.P502PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP502PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P502PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP502PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P502PFS.Reg, volatile.LoadUint32(&o.P502PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP502PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P502PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP502PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P502PFS.Reg, volatile.LoadUint32(&o.P502PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP502PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P502PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP502PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P502PFS.Reg, volatile.LoadUint32(&o.P502PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP502PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P502PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP502PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P502PFS.Reg, volatile.LoadUint32(&o.P502PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP502PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P502PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP502PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P502PFS.Reg, volatile.LoadUint32(&o.P502PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP502PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P502PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P503PFS: Port 50%s Pin Function Select Register
func (o *PFS_Type) SetP503PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P503PFS.Reg, volatile.LoadUint32(&o.P503PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP503PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P503PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP503PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P503PFS.Reg, volatile.LoadUint32(&o.P503PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP503PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P503PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP503PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P503PFS.Reg, volatile.LoadUint32(&o.P503PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP503PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P503PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP503PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P503PFS.Reg, volatile.LoadUint32(&o.P503PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP503PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P503PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP503PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P503PFS.Reg, volatile.LoadUint32(&o.P503PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP503PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P503PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP503PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P503PFS.Reg, volatile.LoadUint32(&o.P503PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP503PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P503PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP503PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P503PFS.Reg, volatile.LoadUint32(&o.P503PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP503PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P503PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP503PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P503PFS.Reg, volatile.LoadUint32(&o.P503PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP503PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P503PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP503PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P503PFS.Reg, volatile.LoadUint32(&o.P503PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP503PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P503PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P504PFS: Port 50%s Pin Function Select Register
func (o *PFS_Type) SetP504PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P504PFS.Reg, volatile.LoadUint32(&o.P504PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP504PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P504PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP504PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P504PFS.Reg, volatile.LoadUint32(&o.P504PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP504PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P504PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP504PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P504PFS.Reg, volatile.LoadUint32(&o.P504PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP504PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P504PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP504PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P504PFS.Reg, volatile.LoadUint32(&o.P504PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP504PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P504PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP504PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P504PFS.Reg, volatile.LoadUint32(&o.P504PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP504PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P504PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP504PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P504PFS.Reg, volatile.LoadUint32(&o.P504PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP504PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P504PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP504PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P504PFS.Reg, volatile.LoadUint32(&o.P504PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP504PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P504PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP504PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P504PFS.Reg, volatile.LoadUint32(&o.P504PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP504PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P504PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP504PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P504PFS.Reg, volatile.LoadUint32(&o.P504PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP504PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P504PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P505PFS: Port 50%s Pin Function Select Register
func (o *PFS_Type) SetP505PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P505PFS.Reg, volatile.LoadUint32(&o.P505PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP505PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P505PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP505PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P505PFS.Reg, volatile.LoadUint32(&o.P505PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP505PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P505PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP505PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P505PFS.Reg, volatile.LoadUint32(&o.P505PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP505PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P505PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP505PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P505PFS.Reg, volatile.LoadUint32(&o.P505PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP505PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P505PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP505PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P505PFS.Reg, volatile.LoadUint32(&o.P505PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP505PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P505PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP505PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P505PFS.Reg, volatile.LoadUint32(&o.P505PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP505PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P505PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP505PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P505PFS.Reg, volatile.LoadUint32(&o.P505PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP505PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P505PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP505PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P505PFS.Reg, volatile.LoadUint32(&o.P505PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP505PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P505PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP505PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P505PFS.Reg, volatile.LoadUint32(&o.P505PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP505PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P505PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P913PFS: Port 9%s Pin Function Select Register
func (o *PFS_Type) SetP913PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P913PFS.Reg, volatile.LoadUint32(&o.P913PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP913PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P913PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP913PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P913PFS.Reg, volatile.LoadUint32(&o.P913PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP913PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P913PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP913PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P913PFS.Reg, volatile.LoadUint32(&o.P913PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP913PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P913PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP913PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P913PFS.Reg, volatile.LoadUint32(&o.P913PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP913PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P913PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP913PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P913PFS.Reg, volatile.LoadUint32(&o.P913PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP913PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P913PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP913PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P913PFS.Reg, volatile.LoadUint32(&o.P913PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP913PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P913PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP913PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P913PFS.Reg, volatile.LoadUint32(&o.P913PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP913PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P913PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP913PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P913PFS.Reg, volatile.LoadUint32(&o.P913PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP913PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P913PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP913PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P913PFS.Reg, volatile.LoadUint32(&o.P913PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP913PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P913PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P914PFS: Port 9%s Pin Function Select Register
func (o *PFS_Type) SetP914PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP914PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P914PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP914PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP914PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP914PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP914PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP914PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP914PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP914PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP914PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP914PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP914PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP914PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP914PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP914PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP914PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP914PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP914PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P915PFS: Port 9%s Pin Function Select Register
func (o *PFS_Type) SetP915PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P915PFS.Reg, volatile.LoadUint32(&o.P915PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP915PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P915PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP915PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P915PFS.Reg, volatile.LoadUint32(&o.P915PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP915PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P915PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP915PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P915PFS.Reg, volatile.LoadUint32(&o.P915PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP915PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P915PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP915PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P915PFS.Reg, volatile.LoadUint32(&o.P915PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP915PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P915PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP915PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P915PFS.Reg, volatile.LoadUint32(&o.P915PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP915PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P915PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP915PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P915PFS.Reg, volatile.LoadUint32(&o.P915PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP915PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P915PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP915PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P915PFS.Reg, volatile.LoadUint32(&o.P915PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP915PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P915PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP915PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P915PFS.Reg, volatile.LoadUint32(&o.P915PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP915PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P915PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP915PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P915PFS.Reg, volatile.LoadUint32(&o.P915PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP915PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P915PFS.Reg) & 0x1f000000) >> 24
}

// PFS.PWPR: Write-Protect Register
func (o *PFS_Type) SetPWPR_PFSWE(value uint8) {
	volatile.StoreUint8(&o.PWPR.Reg, volatile.LoadUint8(&o.PWPR.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetPWPR_PFSWE() uint8 {
	return (volatile.LoadUint8(&o.PWPR.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetPWPR_B0WI(value uint8) {
	volatile.StoreUint8(&o.PWPR.Reg, volatile.LoadUint8(&o.PWPR.Reg)&^(0x80)|value<<7)
}
func (o *PFS_Type) GetPWPR_B0WI() uint8 {
	return (volatile.LoadUint8(&o.PWPR.Reg) & 0x80) >> 7
}

// PFS.PRWCNTR: Port Read Wait Control Register
func (o *PFS_Type) SetPRWCNTR_WAIT(value uint8) {
	volatile.StoreUint8(&o.PRWCNTR.Reg, volatile.LoadUint8(&o.PRWCNTR.Reg)&^(0x3)|value)
}
func (o *PFS_Type) GetPRWCNTR_WAIT() uint8 {
	return volatile.LoadUint8(&o.PRWCNTR.Reg) & 0x3
}

// Event Link Controller
type ELC_Type struct {
	ELCR    volatile.Register8 // 0x0
	_       byte
	ELSEGR0 volatile.Register8 // 0x2
	_       byte
	ELSEGR1 volatile.Register8 // 0x4
	_       [11]byte
	ELSR0   volatile.Register16 // 0x10
	_       [2]byte
	ELSR1   volatile.Register16 // 0x14
	_       [2]byte
	ELSR2   volatile.Register16 // 0x18
	_       [2]byte
	ELSR3   volatile.Register16 // 0x1C
	_       [18]byte
	ELSR8   volatile.Register16 // 0x30
	_       [2]byte
	ELSR9   volatile.Register16 // 0x34
	_       [10]byte
	ELSR12  volatile.Register16 // 0x40
	_       [6]byte
	ELSR14  volatile.Register16 // 0x48
	_       [2]byte
	ELSR15  volatile.Register16 // 0x4C
	_       [10]byte
	ELSR18  volatile.Register16 // 0x58
}

// ELC.ELCR: Event Link Controller Register
func (o *ELC_Type) SetELCR_ELCON(value uint8) {
	volatile.StoreUint8(&o.ELCR.Reg, volatile.LoadUint8(&o.ELCR.Reg)&^(0x80)|value<<7)
}
func (o *ELC_Type) GetELCR_ELCON() uint8 {
	return (volatile.LoadUint8(&o.ELCR.Reg) & 0x80) >> 7
}

// ELC.ELSEGR0: Event Link Software Event Generation Register %s
func (o *ELC_Type) SetELSEGR0_SEG(value uint8) {
	volatile.StoreUint8(&o.ELSEGR0.Reg, volatile.LoadUint8(&o.ELSEGR0.Reg)&^(0x1)|value)
}
func (o *ELC_Type) GetELSEGR0_SEG() uint8 {
	return volatile.LoadUint8(&o.ELSEGR0.Reg) & 0x1
}
func (o *ELC_Type) SetELSEGR0_WE(value uint8) {
	volatile.StoreUint8(&o.ELSEGR0.Reg, volatile.LoadUint8(&o.ELSEGR0.Reg)&^(0x40)|value<<6)
}
func (o *ELC_Type) GetELSEGR0_WE() uint8 {
	return (volatile.LoadUint8(&o.ELSEGR0.Reg) & 0x40) >> 6
}
func (o *ELC_Type) SetELSEGR0_WI(value uint8) {
	volatile.StoreUint8(&o.ELSEGR0.Reg, volatile.LoadUint8(&o.ELSEGR0.Reg)&^(0x80)|value<<7)
}
func (o *ELC_Type) GetELSEGR0_WI() uint8 {
	return (volatile.LoadUint8(&o.ELSEGR0.Reg) & 0x80) >> 7
}

// ELC.ELSEGR1: Event Link Software Event Generation Register %s
func (o *ELC_Type) SetELSEGR1_SEG(value uint8) {
	volatile.StoreUint8(&o.ELSEGR1.Reg, volatile.LoadUint8(&o.ELSEGR1.Reg)&^(0x1)|value)
}
func (o *ELC_Type) GetELSEGR1_SEG() uint8 {
	return volatile.LoadUint8(&o.ELSEGR1.Reg) & 0x1
}
func (o *ELC_Type) SetELSEGR1_WE(value uint8) {
	volatile.StoreUint8(&o.ELSEGR1.Reg, volatile.LoadUint8(&o.ELSEGR1.Reg)&^(0x40)|value<<6)
}
func (o *ELC_Type) GetELSEGR1_WE() uint8 {
	return (volatile.LoadUint8(&o.ELSEGR1.Reg) & 0x40) >> 6
}
func (o *ELC_Type) SetELSEGR1_WI(value uint8) {
	volatile.StoreUint8(&o.ELSEGR1.Reg, volatile.LoadUint8(&o.ELSEGR1.Reg)&^(0x80)|value<<7)
}
func (o *ELC_Type) GetELSEGR1_WI() uint8 {
	return (volatile.LoadUint8(&o.ELSEGR1.Reg) & 0x80) >> 7
}

// ELC.ELSR0: Event Link Setting Register %s
func (o *ELC_Type) SetELSR0_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR0.Reg, volatile.LoadUint16(&o.ELSR0.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR0_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR0.Reg) & 0xff
}

// ELC.ELSR1: Event Link Setting Register %s
func (o *ELC_Type) SetELSR1_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR1.Reg, volatile.LoadUint16(&o.ELSR1.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR1_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR1.Reg) & 0xff
}

// ELC.ELSR2: Event Link Setting Register %s
func (o *ELC_Type) SetELSR2_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR2.Reg, volatile.LoadUint16(&o.ELSR2.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR2_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR2.Reg) & 0xff
}

// ELC.ELSR3: Event Link Setting Register %s
func (o *ELC_Type) SetELSR3_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR3.Reg, volatile.LoadUint16(&o.ELSR3.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR3_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR3.Reg) & 0xff
}

// ELC.ELSR8: Event Link Setting Register %s
func (o *ELC_Type) SetELSR8_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR8.Reg, volatile.LoadUint16(&o.ELSR8.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR8_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR8.Reg) & 0xff
}

// ELC.ELSR9: Event Link Setting Register %s
func (o *ELC_Type) SetELSR9_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR9.Reg, volatile.LoadUint16(&o.ELSR9.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR9_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR9.Reg) & 0xff
}

// ELC.ELSR12: Event Link Setting Register 12
func (o *ELC_Type) SetELSR12_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR12.Reg, volatile.LoadUint16(&o.ELSR12.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR12_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR12.Reg) & 0xff
}

// ELC.ELSR14: Event Link Setting Register %s
func (o *ELC_Type) SetELSR14_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR14.Reg, volatile.LoadUint16(&o.ELSR14.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR14_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR14.Reg) & 0xff
}

// ELC.ELSR15: Event Link Setting Register %s
func (o *ELC_Type) SetELSR15_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR15.Reg, volatile.LoadUint16(&o.ELSR15.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR15_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR15.Reg) & 0xff
}

// ELC.ELSR18: Event Link Setting Register 18
func (o *ELC_Type) SetELSR18_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR18.Reg, volatile.LoadUint16(&o.ELSR18.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR18_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR18.Reg) & 0xff
}

// Port Output Enable Module for GPT
type POEG_Type struct {
	POEGGA volatile.Register32 // 0x0
	_      [252]byte
	POEGGB volatile.Register32 // 0x100
}

// POEG.POEGGA: POEG Group A Setting Register
func (o *POEG_Type) SetPOEGGA_PIDF(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x1)|value)
}
func (o *POEG_Type) GetPOEGGA_PIDF() uint32 {
	return volatile.LoadUint32(&o.POEGGA.Reg) & 0x1
}
func (o *POEG_Type) SetPOEGGA_IOCF(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x2)|value<<1)
}
func (o *POEG_Type) GetPOEGGA_IOCF() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x2) >> 1
}
func (o *POEG_Type) SetPOEGGA_OSTPF(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x4)|value<<2)
}
func (o *POEG_Type) GetPOEGGA_OSTPF() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x4) >> 2
}
func (o *POEG_Type) SetPOEGGA_SSF(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x8)|value<<3)
}
func (o *POEG_Type) GetPOEGGA_SSF() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x8) >> 3
}
func (o *POEG_Type) SetPOEGGA_PIDE(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x10)|value<<4)
}
func (o *POEG_Type) GetPOEGGA_PIDE() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x10) >> 4
}
func (o *POEG_Type) SetPOEGGA_IOCE(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x20)|value<<5)
}
func (o *POEG_Type) GetPOEGGA_IOCE() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x20) >> 5
}
func (o *POEG_Type) SetPOEGGA_OSTPE(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x40)|value<<6)
}
func (o *POEG_Type) GetPOEGGA_OSTPE() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x40) >> 6
}
func (o *POEG_Type) SetPOEGGA_ST(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x10000)|value<<16)
}
func (o *POEG_Type) GetPOEGGA_ST() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x10000) >> 16
}
func (o *POEG_Type) SetPOEGGA_INV(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x10000000)|value<<28)
}
func (o *POEG_Type) GetPOEGGA_INV() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x10000000) >> 28
}
func (o *POEG_Type) SetPOEGGA_NFEN(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x20000000)|value<<29)
}
func (o *POEG_Type) GetPOEGGA_NFEN() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x20000000) >> 29
}
func (o *POEG_Type) SetPOEGGA_NFCS(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0xc0000000)|value<<30)
}
func (o *POEG_Type) GetPOEGGA_NFCS() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0xc0000000) >> 30
}

// POEG.POEGGB: POEG Group B Setting Register
func (o *POEG_Type) SetPOEGGB_PIDF(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x1)|value)
}
func (o *POEG_Type) GetPOEGGB_PIDF() uint32 {
	return volatile.LoadUint32(&o.POEGGB.Reg) & 0x1
}
func (o *POEG_Type) SetPOEGGB_IOCF(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x2)|value<<1)
}
func (o *POEG_Type) GetPOEGGB_IOCF() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x2) >> 1
}
func (o *POEG_Type) SetPOEGGB_OSTPF(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x4)|value<<2)
}
func (o *POEG_Type) GetPOEGGB_OSTPF() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x4) >> 2
}
func (o *POEG_Type) SetPOEGGB_SSF(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x8)|value<<3)
}
func (o *POEG_Type) GetPOEGGB_SSF() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x8) >> 3
}
func (o *POEG_Type) SetPOEGGB_PIDE(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x10)|value<<4)
}
func (o *POEG_Type) GetPOEGGB_PIDE() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x10) >> 4
}
func (o *POEG_Type) SetPOEGGB_IOCE(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x20)|value<<5)
}
func (o *POEG_Type) GetPOEGGB_IOCE() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x20) >> 5
}
func (o *POEG_Type) SetPOEGGB_OSTPE(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x40)|value<<6)
}
func (o *POEG_Type) GetPOEGGB_OSTPE() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x40) >> 6
}
func (o *POEG_Type) SetPOEGGB_ST(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x10000)|value<<16)
}
func (o *POEG_Type) GetPOEGGB_ST() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x10000) >> 16
}
func (o *POEG_Type) SetPOEGGB_INV(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x10000000)|value<<28)
}
func (o *POEG_Type) GetPOEGGB_INV() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x10000000) >> 28
}
func (o *POEG_Type) SetPOEGGB_NFEN(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x20000000)|value<<29)
}
func (o *POEG_Type) GetPOEGGB_NFEN() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x20000000) >> 29
}
func (o *POEG_Type) SetPOEGGB_NFCS(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0xc0000000)|value<<30)
}
func (o *POEG_Type) GetPOEGGB_NFCS() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0xc0000000) >> 30
}

// Realtime Clock
type RTC_Type struct {
	R64CNT   volatile.Register8 // 0x0
	_        byte
	BCNT0    volatile.Register8 // 0x2
	_        byte
	BCNT1    volatile.Register8 // 0x4
	_        byte
	BCNT2    volatile.Register8 // 0x6
	_        byte
	BCNT3    volatile.Register8 // 0x8
	_        byte
	RDAYCNT  volatile.Register8 // 0xA
	_        byte
	RMONCNT  volatile.Register8 // 0xC
	_        byte
	RYRCNT   volatile.Register16 // 0xE
	BCNT0AR  volatile.Register8  // 0x10
	_        byte
	BCNT1AR  volatile.Register8 // 0x12
	_        byte
	BCNT2AR  volatile.Register8 // 0x14
	_        byte
	BCNT3AR  volatile.Register8 // 0x16
	_        byte
	BCNT0AER volatile.Register8 // 0x18
	_        byte
	BCNT1AER volatile.Register8 // 0x1A
	_        byte
	BCNT2AER volatile.Register16 // 0x1C
	BCNT3AER volatile.Register8  // 0x1E
	_        [3]byte
	RCR1     volatile.Register8 // 0x22
	_        byte
	RCR2     volatile.Register8 // 0x24
	_        [3]byte
	RCR4     volatile.Register8 // 0x28
	_        byte
	RFRH     volatile.Register16 // 0x2A
	RFRL     volatile.Register16 // 0x2C
	RADJ     volatile.Register8  // 0x2E
}

// RTC.R64CNT: 64-Hz Counter
func (o *RTC_Type) SetR64CNT_F64HZ(value uint8) {
	volatile.StoreUint8(&o.R64CNT.Reg, volatile.LoadUint8(&o.R64CNT.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetR64CNT_F64HZ() uint8 {
	return volatile.LoadUint8(&o.R64CNT.Reg) & 0x1
}
func (o *RTC_Type) SetR64CNT_F32HZ(value uint8) {
	volatile.StoreUint8(&o.R64CNT.Reg, volatile.LoadUint8(&o.R64CNT.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetR64CNT_F32HZ() uint8 {
	return (volatile.LoadUint8(&o.R64CNT.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetR64CNT_F16HZ(value uint8) {
	volatile.StoreUint8(&o.R64CNT.Reg, volatile.LoadUint8(&o.R64CNT.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetR64CNT_F16HZ() uint8 {
	return (volatile.LoadUint8(&o.R64CNT.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetR64CNT_F8HZ(value uint8) {
	volatile.StoreUint8(&o.R64CNT.Reg, volatile.LoadUint8(&o.R64CNT.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetR64CNT_F8HZ() uint8 {
	return (volatile.LoadUint8(&o.R64CNT.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetR64CNT_F4HZ(value uint8) {
	volatile.StoreUint8(&o.R64CNT.Reg, volatile.LoadUint8(&o.R64CNT.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetR64CNT_F4HZ() uint8 {
	return (volatile.LoadUint8(&o.R64CNT.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetR64CNT_F2HZ(value uint8) {
	volatile.StoreUint8(&o.R64CNT.Reg, volatile.LoadUint8(&o.R64CNT.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetR64CNT_F2HZ() uint8 {
	return (volatile.LoadUint8(&o.R64CNT.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetR64CNT_F1HZ(value uint8) {
	volatile.StoreUint8(&o.R64CNT.Reg, volatile.LoadUint8(&o.R64CNT.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetR64CNT_F1HZ() uint8 {
	return (volatile.LoadUint8(&o.R64CNT.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetR64CNT_R64OVF(value uint8) {
	volatile.StoreUint8(&o.R64CNT.Reg, volatile.LoadUint8(&o.R64CNT.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetR64CNT_R64OVF() uint8 {
	return (volatile.LoadUint8(&o.R64CNT.Reg) & 0x80) >> 7
}

// RTC.BCNT0: Binary Counter %s
func (o *RTC_Type) SetBCNT0(value uint8) {
	volatile.StoreUint8(&o.BCNT0.Reg, value)
}
func (o *RTC_Type) GetBCNT0() uint8 {
	return volatile.LoadUint8(&o.BCNT0.Reg)
}

// RTC.BCNT1: Binary Counter %s
func (o *RTC_Type) SetBCNT1(value uint8) {
	volatile.StoreUint8(&o.BCNT1.Reg, value)
}
func (o *RTC_Type) GetBCNT1() uint8 {
	return volatile.LoadUint8(&o.BCNT1.Reg)
}

// RTC.BCNT2: Binary Counter %s
func (o *RTC_Type) SetBCNT2(value uint8) {
	volatile.StoreUint8(&o.BCNT2.Reg, value)
}
func (o *RTC_Type) GetBCNT2() uint8 {
	return volatile.LoadUint8(&o.BCNT2.Reg)
}

// RTC.BCNT3: Binary Counter %s
func (o *RTC_Type) SetBCNT3(value uint8) {
	volatile.StoreUint8(&o.BCNT3.Reg, value)
}
func (o *RTC_Type) GetBCNT3() uint8 {
	return volatile.LoadUint8(&o.BCNT3.Reg)
}

// RTC.RDAYCNT: Day Counter
func (o *RTC_Type) SetRDAYCNT_DATE1(value uint8) {
	volatile.StoreUint8(&o.RDAYCNT.Reg, volatile.LoadUint8(&o.RDAYCNT.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetRDAYCNT_DATE1() uint8 {
	return volatile.LoadUint8(&o.RDAYCNT.Reg) & 0xf
}
func (o *RTC_Type) SetRDAYCNT_DATE10(value uint8) {
	volatile.StoreUint8(&o.RDAYCNT.Reg, volatile.LoadUint8(&o.RDAYCNT.Reg)&^(0x30)|value<<4)
}
func (o *RTC_Type) GetRDAYCNT_DATE10() uint8 {
	return (volatile.LoadUint8(&o.RDAYCNT.Reg) & 0x30) >> 4
}

// RTC.RMONCNT: Month Counter
func (o *RTC_Type) SetRMONCNT_MON1(value uint8) {
	volatile.StoreUint8(&o.RMONCNT.Reg, volatile.LoadUint8(&o.RMONCNT.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetRMONCNT_MON1() uint8 {
	return volatile.LoadUint8(&o.RMONCNT.Reg) & 0xf
}
func (o *RTC_Type) SetRMONCNT_MON10(value uint8) {
	volatile.StoreUint8(&o.RMONCNT.Reg, volatile.LoadUint8(&o.RMONCNT.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetRMONCNT_MON10() uint8 {
	return (volatile.LoadUint8(&o.RMONCNT.Reg) & 0x10) >> 4
}

// RTC.RYRCNT: Year Counter
func (o *RTC_Type) SetRYRCNT_YR1(value uint16) {
	volatile.StoreUint16(&o.RYRCNT.Reg, volatile.LoadUint16(&o.RYRCNT.Reg)&^(0xf)|value)
}
func (o *RTC_Type) GetRYRCNT_YR1() uint16 {
	return volatile.LoadUint16(&o.RYRCNT.Reg) & 0xf
}
func (o *RTC_Type) SetRYRCNT_YR10(value uint16) {
	volatile.StoreUint16(&o.RYRCNT.Reg, volatile.LoadUint16(&o.RYRCNT.Reg)&^(0xf0)|value<<4)
}
func (o *RTC_Type) GetRYRCNT_YR10() uint16 {
	return (volatile.LoadUint16(&o.RYRCNT.Reg) & 0xf0) >> 4
}

// RTC.BCNT0AR: Binary Counter %s Alarm Register
func (o *RTC_Type) SetBCNT0AR(value uint8) {
	volatile.StoreUint8(&o.BCNT0AR.Reg, value)
}
func (o *RTC_Type) GetBCNT0AR() uint8 {
	return volatile.LoadUint8(&o.BCNT0AR.Reg)
}

// RTC.BCNT1AR: Binary Counter %s Alarm Register
func (o *RTC_Type) SetBCNT1AR(value uint8) {
	volatile.StoreUint8(&o.BCNT1AR.Reg, value)
}
func (o *RTC_Type) GetBCNT1AR() uint8 {
	return volatile.LoadUint8(&o.BCNT1AR.Reg)
}

// RTC.BCNT2AR: Binary Counter %s Alarm Register
func (o *RTC_Type) SetBCNT2AR(value uint8) {
	volatile.StoreUint8(&o.BCNT2AR.Reg, value)
}
func (o *RTC_Type) GetBCNT2AR() uint8 {
	return volatile.LoadUint8(&o.BCNT2AR.Reg)
}

// RTC.BCNT3AR: Binary Counter %s Alarm Register
func (o *RTC_Type) SetBCNT3AR(value uint8) {
	volatile.StoreUint8(&o.BCNT3AR.Reg, value)
}
func (o *RTC_Type) GetBCNT3AR() uint8 {
	return volatile.LoadUint8(&o.BCNT3AR.Reg)
}

// RTC.BCNT0AER: Binary Counter %s Alarm Enable Register
func (o *RTC_Type) SetBCNT0AER(value uint8) {
	volatile.StoreUint8(&o.BCNT0AER.Reg, value)
}
func (o *RTC_Type) GetBCNT0AER() uint8 {
	return volatile.LoadUint8(&o.BCNT0AER.Reg)
}

// RTC.BCNT1AER: Binary Counter %s Alarm Enable Register
func (o *RTC_Type) SetBCNT1AER(value uint8) {
	volatile.StoreUint8(&o.BCNT1AER.Reg, value)
}
func (o *RTC_Type) GetBCNT1AER() uint8 {
	return volatile.LoadUint8(&o.BCNT1AER.Reg)
}

// RTC.BCNT2AER: Binary Counter 2 Alarm Enable Register
func (o *RTC_Type) SetBCNT2AER_ENB(value uint16) {
	volatile.StoreUint16(&o.BCNT2AER.Reg, volatile.LoadUint16(&o.BCNT2AER.Reg)&^(0xff)|value)
}
func (o *RTC_Type) GetBCNT2AER_ENB() uint16 {
	return volatile.LoadUint16(&o.BCNT2AER.Reg) & 0xff
}

// RTC.BCNT3AER: Binary Counter 3 Alarm Enable Register
func (o *RTC_Type) SetBCNT3AER(value uint8) {
	volatile.StoreUint8(&o.BCNT3AER.Reg, value)
}
func (o *RTC_Type) GetBCNT3AER() uint8 {
	return volatile.LoadUint8(&o.BCNT3AER.Reg)
}

// RTC.RCR1: RTC Control Register 1
func (o *RTC_Type) SetRCR1_AIE(value uint8) {
	volatile.StoreUint8(&o.RCR1.Reg, volatile.LoadUint8(&o.RCR1.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetRCR1_AIE() uint8 {
	return volatile.LoadUint8(&o.RCR1.Reg) & 0x1
}
func (o *RTC_Type) SetRCR1_CIE(value uint8) {
	volatile.StoreUint8(&o.RCR1.Reg, volatile.LoadUint8(&o.RCR1.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetRCR1_CIE() uint8 {
	return (volatile.LoadUint8(&o.RCR1.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetRCR1_PIE(value uint8) {
	volatile.StoreUint8(&o.RCR1.Reg, volatile.LoadUint8(&o.RCR1.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetRCR1_PIE() uint8 {
	return (volatile.LoadUint8(&o.RCR1.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetRCR1_RTCOS(value uint8) {
	volatile.StoreUint8(&o.RCR1.Reg, volatile.LoadUint8(&o.RCR1.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetRCR1_RTCOS() uint8 {
	return (volatile.LoadUint8(&o.RCR1.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetRCR1_PES(value uint8) {
	volatile.StoreUint8(&o.RCR1.Reg, volatile.LoadUint8(&o.RCR1.Reg)&^(0xf0)|value<<4)
}
func (o *RTC_Type) GetRCR1_PES() uint8 {
	return (volatile.LoadUint8(&o.RCR1.Reg) & 0xf0) >> 4
}

// RTC.RCR2: RTC Control Register 2 (in Calendar Count Mode)
func (o *RTC_Type) SetRCR2_START(value uint8) {
	volatile.StoreUint8(&o.RCR2.Reg, volatile.LoadUint8(&o.RCR2.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetRCR2_START() uint8 {
	return volatile.LoadUint8(&o.RCR2.Reg) & 0x1
}
func (o *RTC_Type) SetRCR2_RESET(value uint8) {
	volatile.StoreUint8(&o.RCR2.Reg, volatile.LoadUint8(&o.RCR2.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetRCR2_RESET() uint8 {
	return (volatile.LoadUint8(&o.RCR2.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetRCR2_ADJ30(value uint8) {
	volatile.StoreUint8(&o.RCR2.Reg, volatile.LoadUint8(&o.RCR2.Reg)&^(0x4)|value<<2)
}
func (o *RTC_Type) GetRCR2_ADJ30() uint8 {
	return (volatile.LoadUint8(&o.RCR2.Reg) & 0x4) >> 2
}
func (o *RTC_Type) SetRCR2_RTCOE(value uint8) {
	volatile.StoreUint8(&o.RCR2.Reg, volatile.LoadUint8(&o.RCR2.Reg)&^(0x8)|value<<3)
}
func (o *RTC_Type) GetRCR2_RTCOE() uint8 {
	return (volatile.LoadUint8(&o.RCR2.Reg) & 0x8) >> 3
}
func (o *RTC_Type) SetRCR2_AADJE(value uint8) {
	volatile.StoreUint8(&o.RCR2.Reg, volatile.LoadUint8(&o.RCR2.Reg)&^(0x10)|value<<4)
}
func (o *RTC_Type) GetRCR2_AADJE() uint8 {
	return (volatile.LoadUint8(&o.RCR2.Reg) & 0x10) >> 4
}
func (o *RTC_Type) SetRCR2_AADJP(value uint8) {
	volatile.StoreUint8(&o.RCR2.Reg, volatile.LoadUint8(&o.RCR2.Reg)&^(0x20)|value<<5)
}
func (o *RTC_Type) GetRCR2_AADJP() uint8 {
	return (volatile.LoadUint8(&o.RCR2.Reg) & 0x20) >> 5
}
func (o *RTC_Type) SetRCR2_HR24(value uint8) {
	volatile.StoreUint8(&o.RCR2.Reg, volatile.LoadUint8(&o.RCR2.Reg)&^(0x40)|value<<6)
}
func (o *RTC_Type) GetRCR2_HR24() uint8 {
	return (volatile.LoadUint8(&o.RCR2.Reg) & 0x40) >> 6
}
func (o *RTC_Type) SetRCR2_CNTMD(value uint8) {
	volatile.StoreUint8(&o.RCR2.Reg, volatile.LoadUint8(&o.RCR2.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetRCR2_CNTMD() uint8 {
	return (volatile.LoadUint8(&o.RCR2.Reg) & 0x80) >> 7
}

// RTC.RCR4: RTC Control Register 4
func (o *RTC_Type) SetRCR4_RCKSEL(value uint8) {
	volatile.StoreUint8(&o.RCR4.Reg, volatile.LoadUint8(&o.RCR4.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetRCR4_RCKSEL() uint8 {
	return volatile.LoadUint8(&o.RCR4.Reg) & 0x1
}
func (o *RTC_Type) SetRCR4_ROPSEL(value uint8) {
	volatile.StoreUint8(&o.RCR4.Reg, volatile.LoadUint8(&o.RCR4.Reg)&^(0x80)|value<<7)
}
func (o *RTC_Type) GetRCR4_ROPSEL() uint8 {
	return (volatile.LoadUint8(&o.RCR4.Reg) & 0x80) >> 7
}

// RTC.RFRH: Frequency Register H
func (o *RTC_Type) SetRFRH_RFC16(value uint16) {
	volatile.StoreUint16(&o.RFRH.Reg, volatile.LoadUint16(&o.RFRH.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetRFRH_RFC16() uint16 {
	return volatile.LoadUint16(&o.RFRH.Reg) & 0x1
}

// RTC.RFRL: Frequency Register L
func (o *RTC_Type) SetRFRL(value uint16) {
	volatile.StoreUint16(&o.RFRL.Reg, value)
}
func (o *RTC_Type) GetRFRL() uint16 {
	return volatile.LoadUint16(&o.RFRL.Reg)
}

// RTC.RADJ: Time Error Adjustment Register
func (o *RTC_Type) SetRADJ_ADJ(value uint8) {
	volatile.StoreUint8(&o.RADJ.Reg, volatile.LoadUint8(&o.RADJ.Reg)&^(0x3f)|value)
}
func (o *RTC_Type) GetRADJ_ADJ() uint8 {
	return volatile.LoadUint8(&o.RADJ.Reg) & 0x3f
}
func (o *RTC_Type) SetRADJ_PMADJ(value uint8) {
	volatile.StoreUint8(&o.RADJ.Reg, volatile.LoadUint8(&o.RADJ.Reg)&^(0xc0)|value<<6)
}
func (o *RTC_Type) GetRADJ_PMADJ() uint8 {
	return (volatile.LoadUint8(&o.RADJ.Reg) & 0xc0) >> 6
}

// Watchdog Timer
type WDT_Type struct {
	WDTRR    volatile.Register8 // 0x0
	_        byte
	WDTCR    volatile.Register16 // 0x2
	WDTSR    volatile.Register16 // 0x4
	WDTRCR   volatile.Register8  // 0x6
	_        byte
	WDTCSTPR volatile.Register8 // 0x8
}

// WDT.WDTCR: WDT Control Register
func (o *WDT_Type) SetWDTCR_TOPS(value uint16) {
	volatile.StoreUint16(&o.WDTCR.Reg, volatile.LoadUint16(&o.WDTCR.Reg)&^(0x3)|value)
}
func (o *WDT_Type) GetWDTCR_TOPS() uint16 {
	return volatile.LoadUint16(&o.WDTCR.Reg) & 0x3
}
func (o *WDT_Type) SetWDTCR_CKS(value uint16) {
	volatile.StoreUint16(&o.WDTCR.Reg, volatile.LoadUint16(&o.WDTCR.Reg)&^(0xf0)|value<<4)
}
func (o *WDT_Type) GetWDTCR_CKS() uint16 {
	return (volatile.LoadUint16(&o.WDTCR.Reg) & 0xf0) >> 4
}
func (o *WDT_Type) SetWDTCR_RPES(value uint16) {
	volatile.StoreUint16(&o.WDTCR.Reg, volatile.LoadUint16(&o.WDTCR.Reg)&^(0x300)|value<<8)
}
func (o *WDT_Type) GetWDTCR_RPES() uint16 {
	return (volatile.LoadUint16(&o.WDTCR.Reg) & 0x300) >> 8
}
func (o *WDT_Type) SetWDTCR_RPSS(value uint16) {
	volatile.StoreUint16(&o.WDTCR.Reg, volatile.LoadUint16(&o.WDTCR.Reg)&^(0x3000)|value<<12)
}
func (o *WDT_Type) GetWDTCR_RPSS() uint16 {
	return (volatile.LoadUint16(&o.WDTCR.Reg) & 0x3000) >> 12
}

// WDT.WDTSR: WDT Status Register
func (o *WDT_Type) SetWDTSR_CNTVAL(value uint16) {
	volatile.StoreUint16(&o.WDTSR.Reg, volatile.LoadUint16(&o.WDTSR.Reg)&^(0x3fff)|value)
}
func (o *WDT_Type) GetWDTSR_CNTVAL() uint16 {
	return volatile.LoadUint16(&o.WDTSR.Reg) & 0x3fff
}
func (o *WDT_Type) SetWDTSR_UNDFF(value uint16) {
	volatile.StoreUint16(&o.WDTSR.Reg, volatile.LoadUint16(&o.WDTSR.Reg)&^(0x4000)|value<<14)
}
func (o *WDT_Type) GetWDTSR_UNDFF() uint16 {
	return (volatile.LoadUint16(&o.WDTSR.Reg) & 0x4000) >> 14
}
func (o *WDT_Type) SetWDTSR_REFEF(value uint16) {
	volatile.StoreUint16(&o.WDTSR.Reg, volatile.LoadUint16(&o.WDTSR.Reg)&^(0x8000)|value<<15)
}
func (o *WDT_Type) GetWDTSR_REFEF() uint16 {
	return (volatile.LoadUint16(&o.WDTSR.Reg) & 0x8000) >> 15
}

// WDT.WDTRCR: WDT Reset Control Register
func (o *WDT_Type) SetWDTRCR_RSTIRQS(value uint8) {
	volatile.StoreUint8(&o.WDTRCR.Reg, volatile.LoadUint8(&o.WDTRCR.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetWDTRCR_RSTIRQS() uint8 {
	return (volatile.LoadUint8(&o.WDTRCR.Reg) & 0x80) >> 7
}

// WDT.WDTCSTPR: WDT Count Stop Control Register
func (o *WDT_Type) SetWDTCSTPR_SLCSTP(value uint8) {
	volatile.StoreUint8(&o.WDTCSTPR.Reg, volatile.LoadUint8(&o.WDTCSTPR.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetWDTCSTPR_SLCSTP() uint8 {
	return (volatile.LoadUint8(&o.WDTCSTPR.Reg) & 0x80) >> 7
}

// Independent Watchdog Timer
type IWDT_Type struct {
	IWDTRR volatile.Register8 // 0x0
	_      [3]byte
	IWDTSR volatile.Register16 // 0x4
}

// IWDT.IWDTSR: IWDT Status Register
func (o *IWDT_Type) SetIWDTSR_CNTVAL(value uint16) {
	volatile.StoreUint16(&o.IWDTSR.Reg, volatile.LoadUint16(&o.IWDTSR.Reg)&^(0x3fff)|value)
}
func (o *IWDT_Type) GetIWDTSR_CNTVAL() uint16 {
	return volatile.LoadUint16(&o.IWDTSR.Reg) & 0x3fff
}
func (o *IWDT_Type) SetIWDTSR_UNDFF(value uint16) {
	volatile.StoreUint16(&o.IWDTSR.Reg, volatile.LoadUint16(&o.IWDTSR.Reg)&^(0x4000)|value<<14)
}
func (o *IWDT_Type) GetIWDTSR_UNDFF() uint16 {
	return (volatile.LoadUint16(&o.IWDTSR.Reg) & 0x4000) >> 14
}
func (o *IWDT_Type) SetIWDTSR_REFEF(value uint16) {
	volatile.StoreUint16(&o.IWDTSR.Reg, volatile.LoadUint16(&o.IWDTSR.Reg)&^(0x8000)|value<<15)
}
func (o *IWDT_Type) GetIWDTSR_REFEF() uint16 {
	return (volatile.LoadUint16(&o.IWDTSR.Reg) & 0x8000) >> 15
}

// Clock Frequency Accuracy Measurement Circuit
type CAC_Type struct {
	CACR0   volatile.Register8 // 0x0
	CACR1   volatile.Register8 // 0x1
	CACR2   volatile.Register8 // 0x2
	CAICR   volatile.Register8 // 0x3
	CASTR   volatile.Register8 // 0x4
	_       byte
	CAULVR  volatile.Register16 // 0x6
	CALLVR  volatile.Register16 // 0x8
	CACNTBR volatile.Register16 // 0xA
}

// CAC.CACR0: CAC Control Register 0
func (o *CAC_Type) SetCACR0_CFME(value uint8) {
	volatile.StoreUint8(&o.CACR0.Reg, volatile.LoadUint8(&o.CACR0.Reg)&^(0x1)|value)
}
func (o *CAC_Type) GetCACR0_CFME() uint8 {
	return volatile.LoadUint8(&o.CACR0.Reg) & 0x1
}

// CAC.CACR1: CAC Control Register 1
func (o *CAC_Type) SetCACR1_CACREFE(value uint8) {
	volatile.StoreUint8(&o.CACR1.Reg, volatile.LoadUint8(&o.CACR1.Reg)&^(0x1)|value)
}
func (o *CAC_Type) GetCACR1_CACREFE() uint8 {
	return volatile.LoadUint8(&o.CACR1.Reg) & 0x1
}
func (o *CAC_Type) SetCACR1_FMCS(value uint8) {
	volatile.StoreUint8(&o.CACR1.Reg, volatile.LoadUint8(&o.CACR1.Reg)&^(0xe)|value<<1)
}
func (o *CAC_Type) GetCACR1_FMCS() uint8 {
	return (volatile.LoadUint8(&o.CACR1.Reg) & 0xe) >> 1
}
func (o *CAC_Type) SetCACR1_TCSS(value uint8) {
	volatile.StoreUint8(&o.CACR1.Reg, volatile.LoadUint8(&o.CACR1.Reg)&^(0x30)|value<<4)
}
func (o *CAC_Type) GetCACR1_TCSS() uint8 {
	return (volatile.LoadUint8(&o.CACR1.Reg) & 0x30) >> 4
}
func (o *CAC_Type) SetCACR1_EDGES(value uint8) {
	volatile.StoreUint8(&o.CACR1.Reg, volatile.LoadUint8(&o.CACR1.Reg)&^(0xc0)|value<<6)
}
func (o *CAC_Type) GetCACR1_EDGES() uint8 {
	return (volatile.LoadUint8(&o.CACR1.Reg) & 0xc0) >> 6
}

// CAC.CACR2: CAC Control Register 2
func (o *CAC_Type) SetCACR2_RPS(value uint8) {
	volatile.StoreUint8(&o.CACR2.Reg, volatile.LoadUint8(&o.CACR2.Reg)&^(0x1)|value)
}
func (o *CAC_Type) GetCACR2_RPS() uint8 {
	return volatile.LoadUint8(&o.CACR2.Reg) & 0x1
}
func (o *CAC_Type) SetCACR2_RSCS(value uint8) {
	volatile.StoreUint8(&o.CACR2.Reg, volatile.LoadUint8(&o.CACR2.Reg)&^(0xe)|value<<1)
}
func (o *CAC_Type) GetCACR2_RSCS() uint8 {
	return (volatile.LoadUint8(&o.CACR2.Reg) & 0xe) >> 1
}
func (o *CAC_Type) SetCACR2_RCDS(value uint8) {
	volatile.StoreUint8(&o.CACR2.Reg, volatile.LoadUint8(&o.CACR2.Reg)&^(0x30)|value<<4)
}
func (o *CAC_Type) GetCACR2_RCDS() uint8 {
	return (volatile.LoadUint8(&o.CACR2.Reg) & 0x30) >> 4
}
func (o *CAC_Type) SetCACR2_DFS(value uint8) {
	volatile.StoreUint8(&o.CACR2.Reg, volatile.LoadUint8(&o.CACR2.Reg)&^(0xc0)|value<<6)
}
func (o *CAC_Type) GetCACR2_DFS() uint8 {
	return (volatile.LoadUint8(&o.CACR2.Reg) & 0xc0) >> 6
}

// CAC.CAICR: CAC Interrupt Control Register
func (o *CAC_Type) SetCAICR_FERRIE(value uint8) {
	volatile.StoreUint8(&o.CAICR.Reg, volatile.LoadUint8(&o.CAICR.Reg)&^(0x1)|value)
}
func (o *CAC_Type) GetCAICR_FERRIE() uint8 {
	return volatile.LoadUint8(&o.CAICR.Reg) & 0x1
}
func (o *CAC_Type) SetCAICR_MENDIE(value uint8) {
	volatile.StoreUint8(&o.CAICR.Reg, volatile.LoadUint8(&o.CAICR.Reg)&^(0x2)|value<<1)
}
func (o *CAC_Type) GetCAICR_MENDIE() uint8 {
	return (volatile.LoadUint8(&o.CAICR.Reg) & 0x2) >> 1
}
func (o *CAC_Type) SetCAICR_OVFIE(value uint8) {
	volatile.StoreUint8(&o.CAICR.Reg, volatile.LoadUint8(&o.CAICR.Reg)&^(0x4)|value<<2)
}
func (o *CAC_Type) GetCAICR_OVFIE() uint8 {
	return (volatile.LoadUint8(&o.CAICR.Reg) & 0x4) >> 2
}
func (o *CAC_Type) SetCAICR_FERRFCL(value uint8) {
	volatile.StoreUint8(&o.CAICR.Reg, volatile.LoadUint8(&o.CAICR.Reg)&^(0x10)|value<<4)
}
func (o *CAC_Type) GetCAICR_FERRFCL() uint8 {
	return (volatile.LoadUint8(&o.CAICR.Reg) & 0x10) >> 4
}
func (o *CAC_Type) SetCAICR_MENDFCL(value uint8) {
	volatile.StoreUint8(&o.CAICR.Reg, volatile.LoadUint8(&o.CAICR.Reg)&^(0x20)|value<<5)
}
func (o *CAC_Type) GetCAICR_MENDFCL() uint8 {
	return (volatile.LoadUint8(&o.CAICR.Reg) & 0x20) >> 5
}
func (o *CAC_Type) SetCAICR_OVFFCL(value uint8) {
	volatile.StoreUint8(&o.CAICR.Reg, volatile.LoadUint8(&o.CAICR.Reg)&^(0x40)|value<<6)
}
func (o *CAC_Type) GetCAICR_OVFFCL() uint8 {
	return (volatile.LoadUint8(&o.CAICR.Reg) & 0x40) >> 6
}

// CAC.CASTR: CAC Status Register
func (o *CAC_Type) SetCASTR_FERRF(value uint8) {
	volatile.StoreUint8(&o.CASTR.Reg, volatile.LoadUint8(&o.CASTR.Reg)&^(0x1)|value)
}
func (o *CAC_Type) GetCASTR_FERRF() uint8 {
	return volatile.LoadUint8(&o.CASTR.Reg) & 0x1
}
func (o *CAC_Type) SetCASTR_MENDF(value uint8) {
	volatile.StoreUint8(&o.CASTR.Reg, volatile.LoadUint8(&o.CASTR.Reg)&^(0x2)|value<<1)
}
func (o *CAC_Type) GetCASTR_MENDF() uint8 {
	return (volatile.LoadUint8(&o.CASTR.Reg) & 0x2) >> 1
}
func (o *CAC_Type) SetCASTR_OVFF(value uint8) {
	volatile.StoreUint8(&o.CASTR.Reg, volatile.LoadUint8(&o.CASTR.Reg)&^(0x4)|value<<2)
}
func (o *CAC_Type) GetCASTR_OVFF() uint8 {
	return (volatile.LoadUint8(&o.CASTR.Reg) & 0x4) >> 2
}

// Module Stop Control B, C, D
type MSTP_Type struct {
	MSTPCRB  volatile.Register32 // 0x0
	MSTPCRC  volatile.Register32 // 0x4
	MSTPCRD  volatile.Register32 // 0x8
	LSMRWDIS volatile.Register16 // 0xC
}

// MSTP.MSTPCRB: Module Stop Control Register B
func (o *MSTP_Type) SetMSTPCRB_MSTPB9(value uint32) {
	volatile.StoreUint32(&o.MSTPCRB.Reg, volatile.LoadUint32(&o.MSTPCRB.Reg)&^(0x200)|value<<9)
}
func (o *MSTP_Type) GetMSTPCRB_MSTPB9() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRB.Reg) & 0x200) >> 9
}
func (o *MSTP_Type) SetMSTPCRB_MSTPB19(value uint32) {
	volatile.StoreUint32(&o.MSTPCRB.Reg, volatile.LoadUint32(&o.MSTPCRB.Reg)&^(0x80000)|value<<19)
}
func (o *MSTP_Type) GetMSTPCRB_MSTPB19() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRB.Reg) & 0x80000) >> 19
}
func (o *MSTP_Type) SetMSTPCRB_MSTPB22(value uint32) {
	volatile.StoreUint32(&o.MSTPCRB.Reg, volatile.LoadUint32(&o.MSTPCRB.Reg)&^(0x400000)|value<<22)
}
func (o *MSTP_Type) GetMSTPCRB_MSTPB22() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRB.Reg) & 0x400000) >> 22
}
func (o *MSTP_Type) SetMSTPCRB_MSTPB29(value uint32) {
	volatile.StoreUint32(&o.MSTPCRB.Reg, volatile.LoadUint32(&o.MSTPCRB.Reg)&^(0x20000000)|value<<29)
}
func (o *MSTP_Type) GetMSTPCRB_MSTPB29() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRB.Reg) & 0x20000000) >> 29
}
func (o *MSTP_Type) SetMSTPCRB_MSTPB30(value uint32) {
	volatile.StoreUint32(&o.MSTPCRB.Reg, volatile.LoadUint32(&o.MSTPCRB.Reg)&^(0x40000000)|value<<30)
}
func (o *MSTP_Type) GetMSTPCRB_MSTPB30() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRB.Reg) & 0x40000000) >> 30
}
func (o *MSTP_Type) SetMSTPCRB_MSTPB31(value uint32) {
	volatile.StoreUint32(&o.MSTPCRB.Reg, volatile.LoadUint32(&o.MSTPCRB.Reg)&^(0x80000000)|value<<31)
}
func (o *MSTP_Type) GetMSTPCRB_MSTPB31() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRB.Reg) & 0x80000000) >> 31
}

// MSTP.MSTPCRC: Module Stop Control Register C
func (o *MSTP_Type) SetMSTPCRC_MSTPC0(value uint32) {
	volatile.StoreUint32(&o.MSTPCRC.Reg, volatile.LoadUint32(&o.MSTPCRC.Reg)&^(0x1)|value)
}
func (o *MSTP_Type) GetMSTPCRC_MSTPC0() uint32 {
	return volatile.LoadUint32(&o.MSTPCRC.Reg) & 0x1
}
func (o *MSTP_Type) SetMSTPCRC_MSTPC1(value uint32) {
	volatile.StoreUint32(&o.MSTPCRC.Reg, volatile.LoadUint32(&o.MSTPCRC.Reg)&^(0x2)|value<<1)
}
func (o *MSTP_Type) GetMSTPCRC_MSTPC1() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRC.Reg) & 0x2) >> 1
}
func (o *MSTP_Type) SetMSTPCRC_MSTPC3(value uint32) {
	volatile.StoreUint32(&o.MSTPCRC.Reg, volatile.LoadUint32(&o.MSTPCRC.Reg)&^(0x8)|value<<3)
}
func (o *MSTP_Type) GetMSTPCRC_MSTPC3() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRC.Reg) & 0x8) >> 3
}
func (o *MSTP_Type) SetMSTPCRC_MSTPC13(value uint32) {
	volatile.StoreUint32(&o.MSTPCRC.Reg, volatile.LoadUint32(&o.MSTPCRC.Reg)&^(0x2000)|value<<13)
}
func (o *MSTP_Type) GetMSTPCRC_MSTPC13() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRC.Reg) & 0x2000) >> 13
}
func (o *MSTP_Type) SetMSTPCRC_MSTPC14(value uint32) {
	volatile.StoreUint32(&o.MSTPCRC.Reg, volatile.LoadUint32(&o.MSTPCRC.Reg)&^(0x4000)|value<<14)
}
func (o *MSTP_Type) GetMSTPCRC_MSTPC14() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRC.Reg) & 0x4000) >> 14
}
func (o *MSTP_Type) SetMSTPCRC_MSTPC28(value uint32) {
	volatile.StoreUint32(&o.MSTPCRC.Reg, volatile.LoadUint32(&o.MSTPCRC.Reg)&^(0x10000000)|value<<28)
}
func (o *MSTP_Type) GetMSTPCRC_MSTPC28() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRC.Reg) & 0x10000000) >> 28
}
func (o *MSTP_Type) SetMSTPCRC_MSTPC31(value uint32) {
	volatile.StoreUint32(&o.MSTPCRC.Reg, volatile.LoadUint32(&o.MSTPCRC.Reg)&^(0x80000000)|value<<31)
}
func (o *MSTP_Type) GetMSTPCRC_MSTPC31() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRC.Reg) & 0x80000000) >> 31
}

// MSTP.MSTPCRD: Module Stop Control Register D
func (o *MSTP_Type) SetMSTPCRD_MSTPD2(value uint32) {
	volatile.StoreUint32(&o.MSTPCRD.Reg, volatile.LoadUint32(&o.MSTPCRD.Reg)&^(0x4)|value<<2)
}
func (o *MSTP_Type) GetMSTPCRD_MSTPD2() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRD.Reg) & 0x4) >> 2
}
func (o *MSTP_Type) SetMSTPCRD_MSTPD3(value uint32) {
	volatile.StoreUint32(&o.MSTPCRD.Reg, volatile.LoadUint32(&o.MSTPCRD.Reg)&^(0x8)|value<<3)
}
func (o *MSTP_Type) GetMSTPCRD_MSTPD3() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRD.Reg) & 0x8) >> 3
}
func (o *MSTP_Type) SetMSTPCRD_MSTPD5(value uint32) {
	volatile.StoreUint32(&o.MSTPCRD.Reg, volatile.LoadUint32(&o.MSTPCRD.Reg)&^(0x20)|value<<5)
}
func (o *MSTP_Type) GetMSTPCRD_MSTPD5() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRD.Reg) & 0x20) >> 5
}
func (o *MSTP_Type) SetMSTPCRD_MSTPD6(value uint32) {
	volatile.StoreUint32(&o.MSTPCRD.Reg, volatile.LoadUint32(&o.MSTPCRD.Reg)&^(0x40)|value<<6)
}
func (o *MSTP_Type) GetMSTPCRD_MSTPD6() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRD.Reg) & 0x40) >> 6
}
func (o *MSTP_Type) SetMSTPCRD_MSTPD14(value uint32) {
	volatile.StoreUint32(&o.MSTPCRD.Reg, volatile.LoadUint32(&o.MSTPCRD.Reg)&^(0x4000)|value<<14)
}
func (o *MSTP_Type) GetMSTPCRD_MSTPD14() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRD.Reg) & 0x4000) >> 14
}
func (o *MSTP_Type) SetMSTPCRD_MSTPD16(value uint32) {
	volatile.StoreUint32(&o.MSTPCRD.Reg, volatile.LoadUint32(&o.MSTPCRD.Reg)&^(0x10000)|value<<16)
}
func (o *MSTP_Type) GetMSTPCRD_MSTPD16() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRD.Reg) & 0x10000) >> 16
}
func (o *MSTP_Type) SetMSTPCRD_MSTPD29(value uint32) {
	volatile.StoreUint32(&o.MSTPCRD.Reg, volatile.LoadUint32(&o.MSTPCRD.Reg)&^(0x20000000)|value<<29)
}
func (o *MSTP_Type) GetMSTPCRD_MSTPD29() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRD.Reg) & 0x20000000) >> 29
}

// MSTP.LSMRWDIS: Low Speed Module R/W Disable Control Register
func (o *MSTP_Type) SetLSMRWDIS_RTCRWDIS(value uint16) {
	volatile.StoreUint16(&o.LSMRWDIS.Reg, volatile.LoadUint16(&o.LSMRWDIS.Reg)&^(0x1)|value)
}
func (o *MSTP_Type) GetLSMRWDIS_RTCRWDIS() uint16 {
	return volatile.LoadUint16(&o.LSMRWDIS.Reg) & 0x1
}
func (o *MSTP_Type) SetLSMRWDIS_WDTDIS(value uint16) {
	volatile.StoreUint16(&o.LSMRWDIS.Reg, volatile.LoadUint16(&o.LSMRWDIS.Reg)&^(0x2)|value<<1)
}
func (o *MSTP_Type) GetLSMRWDIS_WDTDIS() uint16 {
	return (volatile.LoadUint16(&o.LSMRWDIS.Reg) & 0x2) >> 1
}
func (o *MSTP_Type) SetLSMRWDIS_IWDTIDS(value uint16) {
	volatile.StoreUint16(&o.LSMRWDIS.Reg, volatile.LoadUint16(&o.LSMRWDIS.Reg)&^(0x4)|value<<2)
}
func (o *MSTP_Type) GetLSMRWDIS_IWDTIDS() uint16 {
	return (volatile.LoadUint16(&o.LSMRWDIS.Reg) & 0x4) >> 2
}
func (o *MSTP_Type) SetLSMRWDIS_WREN(value uint16) {
	volatile.StoreUint16(&o.LSMRWDIS.Reg, volatile.LoadUint16(&o.LSMRWDIS.Reg)&^(0x80)|value<<7)
}
func (o *MSTP_Type) GetLSMRWDIS_WREN() uint16 {
	return (volatile.LoadUint16(&o.LSMRWDIS.Reg) & 0x80) >> 7
}
func (o *MSTP_Type) SetLSMRWDIS_PRKEY(value uint16) {
	volatile.StoreUint16(&o.LSMRWDIS.Reg, volatile.LoadUint16(&o.LSMRWDIS.Reg)&^(0xff00)|value<<8)
}
func (o *MSTP_Type) GetLSMRWDIS_PRKEY() uint16 {
	return (volatile.LoadUint16(&o.LSMRWDIS.Reg) & 0xff00) >> 8
}

// Inter-Integrated Circuit 0
type IIC0_Type struct {
	ICCR1 volatile.Register8 // 0x0
	ICCR2 volatile.Register8 // 0x1
	ICMR1 volatile.Register8 // 0x2
	ICMR2 volatile.Register8 // 0x3
	ICMR3 volatile.Register8 // 0x4
	ICFER volatile.Register8 // 0x5
	ICSER volatile.Register8 // 0x6
	ICIER volatile.Register8 // 0x7
	ICSR1 volatile.Register8 // 0x8
	ICSR2 volatile.Register8 // 0x9
	SARL0 volatile.Register8 // 0xA
	SARU0 volatile.Register8 // 0xB
	SARL1 volatile.Register8 // 0xC
	SARU1 volatile.Register8 // 0xD
	SARL2 volatile.Register8 // 0xE
	SARU2 volatile.Register8 // 0xF
	ICBRL volatile.Register8 // 0x10
	ICBRH volatile.Register8 // 0x11
	ICDRT volatile.Register8 // 0x12
	ICDRR volatile.Register8 // 0x13
}

// IIC0.ICCR1: I2C Bus Control Register 1
func (o *IIC0_Type) SetICCR1_SDAI(value uint8) {
	volatile.StoreUint8(&o.ICCR1.Reg, volatile.LoadUint8(&o.ICCR1.Reg)&^(0x1)|value)
}
func (o *IIC0_Type) GetICCR1_SDAI() uint8 {
	return volatile.LoadUint8(&o.ICCR1.Reg) & 0x1
}
func (o *IIC0_Type) SetICCR1_SCLI(value uint8) {
	volatile.StoreUint8(&o.ICCR1.Reg, volatile.LoadUint8(&o.ICCR1.Reg)&^(0x2)|value<<1)
}
func (o *IIC0_Type) GetICCR1_SCLI() uint8 {
	return (volatile.LoadUint8(&o.ICCR1.Reg) & 0x2) >> 1
}
func (o *IIC0_Type) SetICCR1_SDAO(value uint8) {
	volatile.StoreUint8(&o.ICCR1.Reg, volatile.LoadUint8(&o.ICCR1.Reg)&^(0x4)|value<<2)
}
func (o *IIC0_Type) GetICCR1_SDAO() uint8 {
	return (volatile.LoadUint8(&o.ICCR1.Reg) & 0x4) >> 2
}
func (o *IIC0_Type) SetICCR1_SCLO(value uint8) {
	volatile.StoreUint8(&o.ICCR1.Reg, volatile.LoadUint8(&o.ICCR1.Reg)&^(0x8)|value<<3)
}
func (o *IIC0_Type) GetICCR1_SCLO() uint8 {
	return (volatile.LoadUint8(&o.ICCR1.Reg) & 0x8) >> 3
}
func (o *IIC0_Type) SetICCR1_SOWP(value uint8) {
	volatile.StoreUint8(&o.ICCR1.Reg, volatile.LoadUint8(&o.ICCR1.Reg)&^(0x10)|value<<4)
}
func (o *IIC0_Type) GetICCR1_SOWP() uint8 {
	return (volatile.LoadUint8(&o.ICCR1.Reg) & 0x10) >> 4
}
func (o *IIC0_Type) SetICCR1_CLO(value uint8) {
	volatile.StoreUint8(&o.ICCR1.Reg, volatile.LoadUint8(&o.ICCR1.Reg)&^(0x20)|value<<5)
}
func (o *IIC0_Type) GetICCR1_CLO() uint8 {
	return (volatile.LoadUint8(&o.ICCR1.Reg) & 0x20) >> 5
}
func (o *IIC0_Type) SetICCR1_IICRST(value uint8) {
	volatile.StoreUint8(&o.ICCR1.Reg, volatile.LoadUint8(&o.ICCR1.Reg)&^(0x40)|value<<6)
}
func (o *IIC0_Type) GetICCR1_IICRST() uint8 {
	return (volatile.LoadUint8(&o.ICCR1.Reg) & 0x40) >> 6
}
func (o *IIC0_Type) SetICCR1_ICE(value uint8) {
	volatile.StoreUint8(&o.ICCR1.Reg, volatile.LoadUint8(&o.ICCR1.Reg)&^(0x80)|value<<7)
}
func (o *IIC0_Type) GetICCR1_ICE() uint8 {
	return (volatile.LoadUint8(&o.ICCR1.Reg) & 0x80) >> 7
}

// IIC0.ICCR2: I2C Bus Control Register 2
func (o *IIC0_Type) SetICCR2_ST(value uint8) {
	volatile.StoreUint8(&o.ICCR2.Reg, volatile.LoadUint8(&o.ICCR2.Reg)&^(0x2)|value<<1)
}
func (o *IIC0_Type) GetICCR2_ST() uint8 {
	return (volatile.LoadUint8(&o.ICCR2.Reg) & 0x2) >> 1
}
func (o *IIC0_Type) SetICCR2_RS(value uint8) {
	volatile.StoreUint8(&o.ICCR2.Reg, volatile.LoadUint8(&o.ICCR2.Reg)&^(0x4)|value<<2)
}
func (o *IIC0_Type) GetICCR2_RS() uint8 {
	return (volatile.LoadUint8(&o.ICCR2.Reg) & 0x4) >> 2
}
func (o *IIC0_Type) SetICCR2_SP(value uint8) {
	volatile.StoreUint8(&o.ICCR2.Reg, volatile.LoadUint8(&o.ICCR2.Reg)&^(0x8)|value<<3)
}
func (o *IIC0_Type) GetICCR2_SP() uint8 {
	return (volatile.LoadUint8(&o.ICCR2.Reg) & 0x8) >> 3
}
func (o *IIC0_Type) SetICCR2_TRS(value uint8) {
	volatile.StoreUint8(&o.ICCR2.Reg, volatile.LoadUint8(&o.ICCR2.Reg)&^(0x20)|value<<5)
}
func (o *IIC0_Type) GetICCR2_TRS() uint8 {
	return (volatile.LoadUint8(&o.ICCR2.Reg) & 0x20) >> 5
}
func (o *IIC0_Type) SetICCR2_MST(value uint8) {
	volatile.StoreUint8(&o.ICCR2.Reg, volatile.LoadUint8(&o.ICCR2.Reg)&^(0x40)|value<<6)
}
func (o *IIC0_Type) GetICCR2_MST() uint8 {
	return (volatile.LoadUint8(&o.ICCR2.Reg) & 0x40) >> 6
}
func (o *IIC0_Type) SetICCR2_BBSY(value uint8) {
	volatile.StoreUint8(&o.ICCR2.Reg, volatile.LoadUint8(&o.ICCR2.Reg)&^(0x80)|value<<7)
}
func (o *IIC0_Type) GetICCR2_BBSY() uint8 {
	return (volatile.LoadUint8(&o.ICCR2.Reg) & 0x80) >> 7
}

// IIC0.ICMR1: I2C Bus Mode Register 1
func (o *IIC0_Type) SetICMR1_BC(value uint8) {
	volatile.StoreUint8(&o.ICMR1.Reg, volatile.LoadUint8(&o.ICMR1.Reg)&^(0x7)|value)
}
func (o *IIC0_Type) GetICMR1_BC() uint8 {
	return volatile.LoadUint8(&o.ICMR1.Reg) & 0x7
}
func (o *IIC0_Type) SetICMR1_BCWP(value uint8) {
	volatile.StoreUint8(&o.ICMR1.Reg, volatile.LoadUint8(&o.ICMR1.Reg)&^(0x8)|value<<3)
}
func (o *IIC0_Type) GetICMR1_BCWP() uint8 {
	return (volatile.LoadUint8(&o.ICMR1.Reg) & 0x8) >> 3
}
func (o *IIC0_Type) SetICMR1_CKS(value uint8) {
	volatile.StoreUint8(&o.ICMR1.Reg, volatile.LoadUint8(&o.ICMR1.Reg)&^(0x70)|value<<4)
}
func (o *IIC0_Type) GetICMR1_CKS() uint8 {
	return (volatile.LoadUint8(&o.ICMR1.Reg) & 0x70) >> 4
}
func (o *IIC0_Type) SetICMR1_MTWP(value uint8) {
	volatile.StoreUint8(&o.ICMR1.Reg, volatile.LoadUint8(&o.ICMR1.Reg)&^(0x80)|value<<7)
}
func (o *IIC0_Type) GetICMR1_MTWP() uint8 {
	return (volatile.LoadUint8(&o.ICMR1.Reg) & 0x80) >> 7
}

// IIC0.ICMR2: I2C Bus Mode Register 2
func (o *IIC0_Type) SetICMR2_TMOS(value uint8) {
	volatile.StoreUint8(&o.ICMR2.Reg, volatile.LoadUint8(&o.ICMR2.Reg)&^(0x1)|value)
}
func (o *IIC0_Type) GetICMR2_TMOS() uint8 {
	return volatile.LoadUint8(&o.ICMR2.Reg) & 0x1
}
func (o *IIC0_Type) SetICMR2_TMOL(value uint8) {
	volatile.StoreUint8(&o.ICMR2.Reg, volatile.LoadUint8(&o.ICMR2.Reg)&^(0x2)|value<<1)
}
func (o *IIC0_Type) GetICMR2_TMOL() uint8 {
	return (volatile.LoadUint8(&o.ICMR2.Reg) & 0x2) >> 1
}
func (o *IIC0_Type) SetICMR2_TMOH(value uint8) {
	volatile.StoreUint8(&o.ICMR2.Reg, volatile.LoadUint8(&o.ICMR2.Reg)&^(0x4)|value<<2)
}
func (o *IIC0_Type) GetICMR2_TMOH() uint8 {
	return (volatile.LoadUint8(&o.ICMR2.Reg) & 0x4) >> 2
}
func (o *IIC0_Type) SetICMR2_SDDL(value uint8) {
	volatile.StoreUint8(&o.ICMR2.Reg, volatile.LoadUint8(&o.ICMR2.Reg)&^(0x70)|value<<4)
}
func (o *IIC0_Type) GetICMR2_SDDL() uint8 {
	return (volatile.LoadUint8(&o.ICMR2.Reg) & 0x70) >> 4
}
func (o *IIC0_Type) SetICMR2_DLCS(value uint8) {
	volatile.StoreUint8(&o.ICMR2.Reg, volatile.LoadUint8(&o.ICMR2.Reg)&^(0x80)|value<<7)
}
func (o *IIC0_Type) GetICMR2_DLCS() uint8 {
	return (volatile.LoadUint8(&o.ICMR2.Reg) & 0x80) >> 7
}

// IIC0.ICMR3: I2C Bus Mode Register 3
func (o *IIC0_Type) SetICMR3_NF(value uint8) {
	volatile.StoreUint8(&o.ICMR3.Reg, volatile.LoadUint8(&o.ICMR3.Reg)&^(0x3)|value)
}
func (o *IIC0_Type) GetICMR3_NF() uint8 {
	return volatile.LoadUint8(&o.ICMR3.Reg) & 0x3
}
func (o *IIC0_Type) SetICMR3_ACKBR(value uint8) {
	volatile.StoreUint8(&o.ICMR3.Reg, volatile.LoadUint8(&o.ICMR3.Reg)&^(0x4)|value<<2)
}
func (o *IIC0_Type) GetICMR3_ACKBR() uint8 {
	return (volatile.LoadUint8(&o.ICMR3.Reg) & 0x4) >> 2
}
func (o *IIC0_Type) SetICMR3_ACKBT(value uint8) {
	volatile.StoreUint8(&o.ICMR3.Reg, volatile.LoadUint8(&o.ICMR3.Reg)&^(0x8)|value<<3)
}
func (o *IIC0_Type) GetICMR3_ACKBT() uint8 {
	return (volatile.LoadUint8(&o.ICMR3.Reg) & 0x8) >> 3
}
func (o *IIC0_Type) SetICMR3_ACKWP(value uint8) {
	volatile.StoreUint8(&o.ICMR3.Reg, volatile.LoadUint8(&o.ICMR3.Reg)&^(0x10)|value<<4)
}
func (o *IIC0_Type) GetICMR3_ACKWP() uint8 {
	return (volatile.LoadUint8(&o.ICMR3.Reg) & 0x10) >> 4
}
func (o *IIC0_Type) SetICMR3_RDRFS(value uint8) {
	volatile.StoreUint8(&o.ICMR3.Reg, volatile.LoadUint8(&o.ICMR3.Reg)&^(0x20)|value<<5)
}
func (o *IIC0_Type) GetICMR3_RDRFS() uint8 {
	return (volatile.LoadUint8(&o.ICMR3.Reg) & 0x20) >> 5
}
func (o *IIC0_Type) SetICMR3_WAIT(value uint8) {
	volatile.StoreUint8(&o.ICMR3.Reg, volatile.LoadUint8(&o.ICMR3.Reg)&^(0x40)|value<<6)
}
func (o *IIC0_Type) GetICMR3_WAIT() uint8 {
	return (volatile.LoadUint8(&o.ICMR3.Reg) & 0x40) >> 6
}
func (o *IIC0_Type) SetICMR3_SMBS(value uint8) {
	volatile.StoreUint8(&o.ICMR3.Reg, volatile.LoadUint8(&o.ICMR3.Reg)&^(0x80)|value<<7)
}
func (o *IIC0_Type) GetICMR3_SMBS() uint8 {
	return (volatile.LoadUint8(&o.ICMR3.Reg) & 0x80) >> 7
}

// IIC0.ICFER: I2C Bus Function Enable Register
func (o *IIC0_Type) SetICFER_TMOE(value uint8) {
	volatile.StoreUint8(&o.ICFER.Reg, volatile.LoadUint8(&o.ICFER.Reg)&^(0x1)|value)
}
func (o *IIC0_Type) GetICFER_TMOE() uint8 {
	return volatile.LoadUint8(&o.ICFER.Reg) & 0x1
}
func (o *IIC0_Type) SetICFER_MALE(value uint8) {
	volatile.StoreUint8(&o.ICFER.Reg, volatile.LoadUint8(&o.ICFER.Reg)&^(0x2)|value<<1)
}
func (o *IIC0_Type) GetICFER_MALE() uint8 {
	return (volatile.LoadUint8(&o.ICFER.Reg) & 0x2) >> 1
}
func (o *IIC0_Type) SetICFER_NALE(value uint8) {
	volatile.StoreUint8(&o.ICFER.Reg, volatile.LoadUint8(&o.ICFER.Reg)&^(0x4)|value<<2)
}
func (o *IIC0_Type) GetICFER_NALE() uint8 {
	return (volatile.LoadUint8(&o.ICFER.Reg) & 0x4) >> 2
}
func (o *IIC0_Type) SetICFER_SALE(value uint8) {
	volatile.StoreUint8(&o.ICFER.Reg, volatile.LoadUint8(&o.ICFER.Reg)&^(0x8)|value<<3)
}
func (o *IIC0_Type) GetICFER_SALE() uint8 {
	return (volatile.LoadUint8(&o.ICFER.Reg) & 0x8) >> 3
}
func (o *IIC0_Type) SetICFER_NACKE(value uint8) {
	volatile.StoreUint8(&o.ICFER.Reg, volatile.LoadUint8(&o.ICFER.Reg)&^(0x10)|value<<4)
}
func (o *IIC0_Type) GetICFER_NACKE() uint8 {
	return (volatile.LoadUint8(&o.ICFER.Reg) & 0x10) >> 4
}
func (o *IIC0_Type) SetICFER_NFE(value uint8) {
	volatile.StoreUint8(&o.ICFER.Reg, volatile.LoadUint8(&o.ICFER.Reg)&^(0x20)|value<<5)
}
func (o *IIC0_Type) GetICFER_NFE() uint8 {
	return (volatile.LoadUint8(&o.ICFER.Reg) & 0x20) >> 5
}
func (o *IIC0_Type) SetICFER_SCLE(value uint8) {
	volatile.StoreUint8(&o.ICFER.Reg, volatile.LoadUint8(&o.ICFER.Reg)&^(0x40)|value<<6)
}
func (o *IIC0_Type) GetICFER_SCLE() uint8 {
	return (volatile.LoadUint8(&o.ICFER.Reg) & 0x40) >> 6
}

// IIC0.ICSER: I2C Bus Status Enable Register
func (o *IIC0_Type) SetICSER_SAR0E(value uint8) {
	volatile.StoreUint8(&o.ICSER.Reg, volatile.LoadUint8(&o.ICSER.Reg)&^(0x1)|value)
}
func (o *IIC0_Type) GetICSER_SAR0E() uint8 {
	return volatile.LoadUint8(&o.ICSER.Reg) & 0x1
}
func (o *IIC0_Type) SetICSER_SAR1E(value uint8) {
	volatile.StoreUint8(&o.ICSER.Reg, volatile.LoadUint8(&o.ICSER.Reg)&^(0x2)|value<<1)
}
func (o *IIC0_Type) GetICSER_SAR1E() uint8 {
	return (volatile.LoadUint8(&o.ICSER.Reg) & 0x2) >> 1
}
func (o *IIC0_Type) SetICSER_SAR2E(value uint8) {
	volatile.StoreUint8(&o.ICSER.Reg, volatile.LoadUint8(&o.ICSER.Reg)&^(0x4)|value<<2)
}
func (o *IIC0_Type) GetICSER_SAR2E() uint8 {
	return (volatile.LoadUint8(&o.ICSER.Reg) & 0x4) >> 2
}
func (o *IIC0_Type) SetICSER_GCAE(value uint8) {
	volatile.StoreUint8(&o.ICSER.Reg, volatile.LoadUint8(&o.ICSER.Reg)&^(0x8)|value<<3)
}
func (o *IIC0_Type) GetICSER_GCAE() uint8 {
	return (volatile.LoadUint8(&o.ICSER.Reg) & 0x8) >> 3
}
func (o *IIC0_Type) SetICSER_DIDE(value uint8) {
	volatile.StoreUint8(&o.ICSER.Reg, volatile.LoadUint8(&o.ICSER.Reg)&^(0x20)|value<<5)
}
func (o *IIC0_Type) GetICSER_DIDE() uint8 {
	return (volatile.LoadUint8(&o.ICSER.Reg) & 0x20) >> 5
}
func (o *IIC0_Type) SetICSER_HOAE(value uint8) {
	volatile.StoreUint8(&o.ICSER.Reg, volatile.LoadUint8(&o.ICSER.Reg)&^(0x80)|value<<7)
}
func (o *IIC0_Type) GetICSER_HOAE() uint8 {
	return (volatile.LoadUint8(&o.ICSER.Reg) & 0x80) >> 7
}

// IIC0.ICIER: I2C Bus Interrupt Enable Register
func (o *IIC0_Type) SetICIER_TMOIE(value uint8) {
	volatile.StoreUint8(&o.ICIER.Reg, volatile.LoadUint8(&o.ICIER.Reg)&^(0x1)|value)
}
func (o *IIC0_Type) GetICIER_TMOIE() uint8 {
	return volatile.LoadUint8(&o.ICIER.Reg) & 0x1
}
func (o *IIC0_Type) SetICIER_ALIE(value uint8) {
	volatile.StoreUint8(&o.ICIER.Reg, volatile.LoadUint8(&o.ICIER.Reg)&^(0x2)|value<<1)
}
func (o *IIC0_Type) GetICIER_ALIE() uint8 {
	return (volatile.LoadUint8(&o.ICIER.Reg) & 0x2) >> 1
}
func (o *IIC0_Type) SetICIER_STIE(value uint8) {
	volatile.StoreUint8(&o.ICIER.Reg, volatile.LoadUint8(&o.ICIER.Reg)&^(0x4)|value<<2)
}
func (o *IIC0_Type) GetICIER_STIE() uint8 {
	return (volatile.LoadUint8(&o.ICIER.Reg) & 0x4) >> 2
}
func (o *IIC0_Type) SetICIER_SPIE(value uint8) {
	volatile.StoreUint8(&o.ICIER.Reg, volatile.LoadUint8(&o.ICIER.Reg)&^(0x8)|value<<3)
}
func (o *IIC0_Type) GetICIER_SPIE() uint8 {
	return (volatile.LoadUint8(&o.ICIER.Reg) & 0x8) >> 3
}
func (o *IIC0_Type) SetICIER_NAKIE(value uint8) {
	volatile.StoreUint8(&o.ICIER.Reg, volatile.LoadUint8(&o.ICIER.Reg)&^(0x10)|value<<4)
}
func (o *IIC0_Type) GetICIER_NAKIE() uint8 {
	return (volatile.LoadUint8(&o.ICIER.Reg) & 0x10) >> 4
}
func (o *IIC0_Type) SetICIER_RIE(value uint8) {
	volatile.StoreUint8(&o.ICIER.Reg, volatile.LoadUint8(&o.ICIER.Reg)&^(0x20)|value<<5)
}
func (o *IIC0_Type) GetICIER_RIE() uint8 {
	return (volatile.LoadUint8(&o.ICIER.Reg) & 0x20) >> 5
}
func (o *IIC0_Type) SetICIER_TEIE(value uint8) {
	volatile.StoreUint8(&o.ICIER.Reg, volatile.LoadUint8(&o.ICIER.Reg)&^(0x40)|value<<6)
}
func (o *IIC0_Type) GetICIER_TEIE() uint8 {
	return (volatile.LoadUint8(&o.ICIER.Reg) & 0x40) >> 6
}
func (o *IIC0_Type) SetICIER_TIE(value uint8) {
	volatile.StoreUint8(&o.ICIER.Reg, volatile.LoadUint8(&o.ICIER.Reg)&^(0x80)|value<<7)
}
func (o *IIC0_Type) GetICIER_TIE() uint8 {
	return (volatile.LoadUint8(&o.ICIER.Reg) & 0x80) >> 7
}

// IIC0.ICSR1: I2C Bus Status Register 1
func (o *IIC0_Type) SetICSR1_AAS0(value uint8) {
	volatile.StoreUint8(&o.ICSR1.Reg, volatile.LoadUint8(&o.ICSR1.Reg)&^(0x1)|value)
}
func (o *IIC0_Type) GetICSR1_AAS0() uint8 {
	return volatile.LoadUint8(&o.ICSR1.Reg) & 0x1
}
func (o *IIC0_Type) SetICSR1_AAS1(value uint8) {
	volatile.StoreUint8(&o.ICSR1.Reg, volatile.LoadUint8(&o.ICSR1.Reg)&^(0x2)|value<<1)
}
func (o *IIC0_Type) GetICSR1_AAS1() uint8 {
	return (volatile.LoadUint8(&o.ICSR1.Reg) & 0x2) >> 1
}
func (o *IIC0_Type) SetICSR1_AAS2(value uint8) {
	volatile.StoreUint8(&o.ICSR1.Reg, volatile.LoadUint8(&o.ICSR1.Reg)&^(0x4)|value<<2)
}
func (o *IIC0_Type) GetICSR1_AAS2() uint8 {
	return (volatile.LoadUint8(&o.ICSR1.Reg) & 0x4) >> 2
}
func (o *IIC0_Type) SetICSR1_GCA(value uint8) {
	volatile.StoreUint8(&o.ICSR1.Reg, volatile.LoadUint8(&o.ICSR1.Reg)&^(0x8)|value<<3)
}
func (o *IIC0_Type) GetICSR1_GCA() uint8 {
	return (volatile.LoadUint8(&o.ICSR1.Reg) & 0x8) >> 3
}
func (o *IIC0_Type) SetICSR1_DID(value uint8) {
	volatile.StoreUint8(&o.ICSR1.Reg, volatile.LoadUint8(&o.ICSR1.Reg)&^(0x20)|value<<5)
}
func (o *IIC0_Type) GetICSR1_DID() uint8 {
	return (volatile.LoadUint8(&o.ICSR1.Reg) & 0x20) >> 5
}
func (o *IIC0_Type) SetICSR1_HOA(value uint8) {
	volatile.StoreUint8(&o.ICSR1.Reg, volatile.LoadUint8(&o.ICSR1.Reg)&^(0x80)|value<<7)
}
func (o *IIC0_Type) GetICSR1_HOA() uint8 {
	return (volatile.LoadUint8(&o.ICSR1.Reg) & 0x80) >> 7
}

// IIC0.ICSR2: I2C Bus Status Register 2
func (o *IIC0_Type) SetICSR2_TMOF(value uint8) {
	volatile.StoreUint8(&o.ICSR2.Reg, volatile.LoadUint8(&o.ICSR2.Reg)&^(0x1)|value)
}
func (o *IIC0_Type) GetICSR2_TMOF() uint8 {
	return volatile.LoadUint8(&o.ICSR2.Reg) & 0x1
}
func (o *IIC0_Type) SetICSR2_AL(value uint8) {
	volatile.StoreUint8(&o.ICSR2.Reg, volatile.LoadUint8(&o.ICSR2.Reg)&^(0x2)|value<<1)
}
func (o *IIC0_Type) GetICSR2_AL() uint8 {
	return (volatile.LoadUint8(&o.ICSR2.Reg) & 0x2) >> 1
}
func (o *IIC0_Type) SetICSR2_START(value uint8) {
	volatile.StoreUint8(&o.ICSR2.Reg, volatile.LoadUint8(&o.ICSR2.Reg)&^(0x4)|value<<2)
}
func (o *IIC0_Type) GetICSR2_START() uint8 {
	return (volatile.LoadUint8(&o.ICSR2.Reg) & 0x4) >> 2
}
func (o *IIC0_Type) SetICSR2_STOP(value uint8) {
	volatile.StoreUint8(&o.ICSR2.Reg, volatile.LoadUint8(&o.ICSR2.Reg)&^(0x8)|value<<3)
}
func (o *IIC0_Type) GetICSR2_STOP() uint8 {
	return (volatile.LoadUint8(&o.ICSR2.Reg) & 0x8) >> 3
}
func (o *IIC0_Type) SetICSR2_NACKF(value uint8) {
	volatile.StoreUint8(&o.ICSR2.Reg, volatile.LoadUint8(&o.ICSR2.Reg)&^(0x10)|value<<4)
}
func (o *IIC0_Type) GetICSR2_NACKF() uint8 {
	return (volatile.LoadUint8(&o.ICSR2.Reg) & 0x10) >> 4
}
func (o *IIC0_Type) SetICSR2_RDRF(value uint8) {
	volatile.StoreUint8(&o.ICSR2.Reg, volatile.LoadUint8(&o.ICSR2.Reg)&^(0x20)|value<<5)
}
func (o *IIC0_Type) GetICSR2_RDRF() uint8 {
	return (volatile.LoadUint8(&o.ICSR2.Reg) & 0x20) >> 5
}
func (o *IIC0_Type) SetICSR2_TEND(value uint8) {
	volatile.StoreUint8(&o.ICSR2.Reg, volatile.LoadUint8(&o.ICSR2.Reg)&^(0x40)|value<<6)
}
func (o *IIC0_Type) GetICSR2_TEND() uint8 {
	return (volatile.LoadUint8(&o.ICSR2.Reg) & 0x40) >> 6
}
func (o *IIC0_Type) SetICSR2_TDRE(value uint8) {
	volatile.StoreUint8(&o.ICSR2.Reg, volatile.LoadUint8(&o.ICSR2.Reg)&^(0x80)|value<<7)
}
func (o *IIC0_Type) GetICSR2_TDRE() uint8 {
	return (volatile.LoadUint8(&o.ICSR2.Reg) & 0x80) >> 7
}

// IIC0.SARL0: Slave Address Register Ly
func (o *IIC0_Type) SetSARL0_SVA0(value uint8) {
	volatile.StoreUint8(&o.SARL0.Reg, volatile.LoadUint8(&o.SARL0.Reg)&^(0x1)|value)
}
func (o *IIC0_Type) GetSARL0_SVA0() uint8 {
	return volatile.LoadUint8(&o.SARL0.Reg) & 0x1
}
func (o *IIC0_Type) SetSARL0_SVA(value uint8) {
	volatile.StoreUint8(&o.SARL0.Reg, volatile.LoadUint8(&o.SARL0.Reg)&^(0xfe)|value<<1)
}
func (o *IIC0_Type) GetSARL0_SVA() uint8 {
	return (volatile.LoadUint8(&o.SARL0.Reg) & 0xfe) >> 1
}

// IIC0.SARU0: Slave Address Register Uy
func (o *IIC0_Type) SetSARU0_FS(value uint8) {
	volatile.StoreUint8(&o.SARU0.Reg, volatile.LoadUint8(&o.SARU0.Reg)&^(0x1)|value)
}
func (o *IIC0_Type) GetSARU0_FS() uint8 {
	return volatile.LoadUint8(&o.SARU0.Reg) & 0x1
}
func (o *IIC0_Type) SetSARU0_SVA(value uint8) {
	volatile.StoreUint8(&o.SARU0.Reg, volatile.LoadUint8(&o.SARU0.Reg)&^(0x6)|value<<1)
}
func (o *IIC0_Type) GetSARU0_SVA() uint8 {
	return (volatile.LoadUint8(&o.SARU0.Reg) & 0x6) >> 1
}

// IIC0.SARL1: Slave Address Register Ly
func (o *IIC0_Type) SetSARL1_SVA0(value uint8) {
	volatile.StoreUint8(&o.SARL1.Reg, volatile.LoadUint8(&o.SARL1.Reg)&^(0x1)|value)
}
func (o *IIC0_Type) GetSARL1_SVA0() uint8 {
	return volatile.LoadUint8(&o.SARL1.Reg) & 0x1
}
func (o *IIC0_Type) SetSARL1_SVA(value uint8) {
	volatile.StoreUint8(&o.SARL1.Reg, volatile.LoadUint8(&o.SARL1.Reg)&^(0xfe)|value<<1)
}
func (o *IIC0_Type) GetSARL1_SVA() uint8 {
	return (volatile.LoadUint8(&o.SARL1.Reg) & 0xfe) >> 1
}

// IIC0.SARU1: Slave Address Register Uy
func (o *IIC0_Type) SetSARU1_FS(value uint8) {
	volatile.StoreUint8(&o.SARU1.Reg, volatile.LoadUint8(&o.SARU1.Reg)&^(0x1)|value)
}
func (o *IIC0_Type) GetSARU1_FS() uint8 {
	return volatile.LoadUint8(&o.SARU1.Reg) & 0x1
}
func (o *IIC0_Type) SetSARU1_SVA(value uint8) {
	volatile.StoreUint8(&o.SARU1.Reg, volatile.LoadUint8(&o.SARU1.Reg)&^(0x6)|value<<1)
}
func (o *IIC0_Type) GetSARU1_SVA() uint8 {
	return (volatile.LoadUint8(&o.SARU1.Reg) & 0x6) >> 1
}

// IIC0.SARL2: Slave Address Register Ly
func (o *IIC0_Type) SetSARL2_SVA0(value uint8) {
	volatile.StoreUint8(&o.SARL2.Reg, volatile.LoadUint8(&o.SARL2.Reg)&^(0x1)|value)
}
func (o *IIC0_Type) GetSARL2_SVA0() uint8 {
	return volatile.LoadUint8(&o.SARL2.Reg) & 0x1
}
func (o *IIC0_Type) SetSARL2_SVA(value uint8) {
	volatile.StoreUint8(&o.SARL2.Reg, volatile.LoadUint8(&o.SARL2.Reg)&^(0xfe)|value<<1)
}
func (o *IIC0_Type) GetSARL2_SVA() uint8 {
	return (volatile.LoadUint8(&o.SARL2.Reg) & 0xfe) >> 1
}

// IIC0.SARU2: Slave Address Register Uy
func (o *IIC0_Type) SetSARU2_FS(value uint8) {
	volatile.StoreUint8(&o.SARU2.Reg, volatile.LoadUint8(&o.SARU2.Reg)&^(0x1)|value)
}
func (o *IIC0_Type) GetSARU2_FS() uint8 {
	return volatile.LoadUint8(&o.SARU2.Reg) & 0x1
}
func (o *IIC0_Type) SetSARU2_SVA(value uint8) {
	volatile.StoreUint8(&o.SARU2.Reg, volatile.LoadUint8(&o.SARU2.Reg)&^(0x6)|value<<1)
}
func (o *IIC0_Type) GetSARU2_SVA() uint8 {
	return (volatile.LoadUint8(&o.SARU2.Reg) & 0x6) >> 1
}

// IIC0.ICBRL: I2C Bus Bit Rate Low-Level Register
func (o *IIC0_Type) SetICBRL_BRL(value uint8) {
	volatile.StoreUint8(&o.ICBRL.Reg, volatile.LoadUint8(&o.ICBRL.Reg)&^(0x1f)|value)
}
func (o *IIC0_Type) GetICBRL_BRL() uint8 {
	return volatile.LoadUint8(&o.ICBRL.Reg) & 0x1f
}

// IIC0.ICBRH: I2C Bus Bit Rate High-Level Register
func (o *IIC0_Type) SetICBRH_BRH(value uint8) {
	volatile.StoreUint8(&o.ICBRH.Reg, volatile.LoadUint8(&o.ICBRH.Reg)&^(0x1f)|value)
}
func (o *IIC0_Type) GetICBRH_BRH() uint8 {
	return volatile.LoadUint8(&o.ICBRH.Reg) & 0x1f
}

// Inter-Integrated Circuit 0 Wake-up Unit
type IIC0WU_Type struct {
	_      [2]byte
	ICWUR  volatile.Register8 // 0x2
	ICWUR2 volatile.Register8 // 0x3
}

// IIC0WU.ICWUR: I2C Bus Wakeup Unit Register
func (o *IIC0WU_Type) SetICWUR_WUAFA(value uint8) {
	volatile.StoreUint8(&o.ICWUR.Reg, volatile.LoadUint8(&o.ICWUR.Reg)&^(0x1)|value)
}
func (o *IIC0WU_Type) GetICWUR_WUAFA() uint8 {
	return volatile.LoadUint8(&o.ICWUR.Reg) & 0x1
}
func (o *IIC0WU_Type) SetICWUR_WUACK(value uint8) {
	volatile.StoreUint8(&o.ICWUR.Reg, volatile.LoadUint8(&o.ICWUR.Reg)&^(0x10)|value<<4)
}
func (o *IIC0WU_Type) GetICWUR_WUACK() uint8 {
	return (volatile.LoadUint8(&o.ICWUR.Reg) & 0x10) >> 4
}
func (o *IIC0WU_Type) SetICWUR_WUF(value uint8) {
	volatile.StoreUint8(&o.ICWUR.Reg, volatile.LoadUint8(&o.ICWUR.Reg)&^(0x20)|value<<5)
}
func (o *IIC0WU_Type) GetICWUR_WUF() uint8 {
	return (volatile.LoadUint8(&o.ICWUR.Reg) & 0x20) >> 5
}
func (o *IIC0WU_Type) SetICWUR_WUIE(value uint8) {
	volatile.StoreUint8(&o.ICWUR.Reg, volatile.LoadUint8(&o.ICWUR.Reg)&^(0x40)|value<<6)
}
func (o *IIC0WU_Type) GetICWUR_WUIE() uint8 {
	return (volatile.LoadUint8(&o.ICWUR.Reg) & 0x40) >> 6
}
func (o *IIC0WU_Type) SetICWUR_WUE(value uint8) {
	volatile.StoreUint8(&o.ICWUR.Reg, volatile.LoadUint8(&o.ICWUR.Reg)&^(0x80)|value<<7)
}
func (o *IIC0WU_Type) GetICWUR_WUE() uint8 {
	return (volatile.LoadUint8(&o.ICWUR.Reg) & 0x80) >> 7
}

// IIC0WU.ICWUR2: I2C Bus Wakeup Unit Register 2
func (o *IIC0WU_Type) SetICWUR2_WUSEN(value uint8) {
	volatile.StoreUint8(&o.ICWUR2.Reg, volatile.LoadUint8(&o.ICWUR2.Reg)&^(0x1)|value)
}
func (o *IIC0WU_Type) GetICWUR2_WUSEN() uint8 {
	return volatile.LoadUint8(&o.ICWUR2.Reg) & 0x1
}
func (o *IIC0WU_Type) SetICWUR2_WUASYF(value uint8) {
	volatile.StoreUint8(&o.ICWUR2.Reg, volatile.LoadUint8(&o.ICWUR2.Reg)&^(0x2)|value<<1)
}
func (o *IIC0WU_Type) GetICWUR2_WUASYF() uint8 {
	return (volatile.LoadUint8(&o.ICWUR2.Reg) & 0x2) >> 1
}
func (o *IIC0WU_Type) SetICWUR2_WUSYF(value uint8) {
	volatile.StoreUint8(&o.ICWUR2.Reg, volatile.LoadUint8(&o.ICWUR2.Reg)&^(0x4)|value<<2)
}
func (o *IIC0WU_Type) GetICWUR2_WUSYF() uint8 {
	return (volatile.LoadUint8(&o.ICWUR2.Reg) & 0x4) >> 2
}

// Data Operation Circuit
type DOC_Type struct {
	DOCR  volatile.Register8 // 0x0
	_     byte
	DODIR volatile.Register16 // 0x2
	DODSR volatile.Register16 // 0x4
}

// DOC.DOCR: DOC Control Register
func (o *DOC_Type) SetDOCR_OMS(value uint8) {
	volatile.StoreUint8(&o.DOCR.Reg, volatile.LoadUint8(&o.DOCR.Reg)&^(0x3)|value)
}
func (o *DOC_Type) GetDOCR_OMS() uint8 {
	return volatile.LoadUint8(&o.DOCR.Reg) & 0x3
}
func (o *DOC_Type) SetDOCR_DCSEL(value uint8) {
	volatile.StoreUint8(&o.DOCR.Reg, volatile.LoadUint8(&o.DOCR.Reg)&^(0x4)|value<<2)
}
func (o *DOC_Type) GetDOCR_DCSEL() uint8 {
	return (volatile.LoadUint8(&o.DOCR.Reg) & 0x4) >> 2
}
func (o *DOC_Type) SetDOCR_DOPCF(value uint8) {
	volatile.StoreUint8(&o.DOCR.Reg, volatile.LoadUint8(&o.DOCR.Reg)&^(0x20)|value<<5)
}
func (o *DOC_Type) GetDOCR_DOPCF() uint8 {
	return (volatile.LoadUint8(&o.DOCR.Reg) & 0x20) >> 5
}
func (o *DOC_Type) SetDOCR_DOPCFCL(value uint8) {
	volatile.StoreUint8(&o.DOCR.Reg, volatile.LoadUint8(&o.DOCR.Reg)&^(0x40)|value<<6)
}
func (o *DOC_Type) GetDOCR_DOPCFCL() uint8 {
	return (volatile.LoadUint8(&o.DOCR.Reg) & 0x40) >> 6
}

// 12-bit A/D Converter
type ADC120_Type struct {
	ADCSR      volatile.Register16 // 0x0
	_          [2]byte
	ADANSA0    volatile.Register16 // 0x4
	ADANSA1    volatile.Register16 // 0x6
	ADADS0     volatile.Register16 // 0x8
	ADADS1     volatile.Register16 // 0xA
	ADADC      volatile.Register8  // 0xC
	_          byte
	ADCER      volatile.Register16 // 0xE
	ADSTRGR    volatile.Register16 // 0x10
	ADEXICR    volatile.Register16 // 0x12
	ADANSB0    volatile.Register16 // 0x14
	ADANSB1    volatile.Register16 // 0x16
	ADDBLDR    volatile.Register16 // 0x18
	ADTSDR     volatile.Register16 // 0x1A
	ADOCDR     volatile.Register16 // 0x1C
	ADRD       volatile.Register16 // 0x1E
	ADDR0      volatile.Register16 // 0x20
	ADDR1      volatile.Register16 // 0x22
	ADDR2      volatile.Register16 // 0x24
	ADDR3      volatile.Register16 // 0x26
	ADDR4      volatile.Register16 // 0x28
	ADDR5      volatile.Register16 // 0x2A
	ADDR6      volatile.Register16 // 0x2C
	ADDR7      volatile.Register16 // 0x2E
	ADDR8      volatile.Register16 // 0x30
	ADDR9      volatile.Register16 // 0x32
	ADDR10     volatile.Register16 // 0x34
	_          [10]byte
	ADCTDR     volatile.Register16 // 0x40
	ADDR17     volatile.Register16 // 0x42
	ADDR18     volatile.Register16 // 0x44
	ADDR19     volatile.Register16 // 0x46
	ADDR20     volatile.Register16 // 0x48
	ADDR21     volatile.Register16 // 0x4A
	ADDR22     volatile.Register16 // 0x4C
	_          [44]byte
	ADDISCR    volatile.Register8 // 0x7A
	_          [3]byte
	ADACSR     volatile.Register8 // 0x7E
	_          byte
	ADGSPCR    volatile.Register16 // 0x80
	_          [2]byte
	ADDBLDRA   volatile.Register16 // 0x84
	ADDBLDRB   volatile.Register16 // 0x86
	_          [2]byte
	ADHVREFCNT volatile.Register8 // 0x8A
	_          byte
	ADWINMON   volatile.Register8 // 0x8C
	_          [3]byte
	ADCMPCR    volatile.Register16 // 0x90
	ADCMPANSER volatile.Register8  // 0x92
	ADCMPLER   volatile.Register8  // 0x93
	ADCMPANSR0 volatile.Register16 // 0x94
	ADCMPANSR1 volatile.Register16 // 0x96
	ADCMPLR0   volatile.Register16 // 0x98
	ADCMPLR1   volatile.Register16 // 0x9A
	ADCMPDR0   volatile.Register16 // 0x9C
	ADCMPDR1   volatile.Register16 // 0x9E
	ADCMPSR0   volatile.Register16 // 0xA0
	ADCMPSR1   volatile.Register16 // 0xA2
	ADCMPSER   volatile.Register8  // 0xA4
	_          byte
	ADCMPBNSR  volatile.Register8 // 0xA6
	_          byte
	ADWINLLB   volatile.Register16 // 0xA8
	ADWINULB   volatile.Register16 // 0xAA
	ADCMPBSR   volatile.Register8  // 0xAC
	_          [48]byte
	ADSSTRL    volatile.Register8 // 0xDD
	ADSSTRT    volatile.Register8 // 0xDE
	ADSSTRO    volatile.Register8 // 0xDF
	ADSSTR0    volatile.Register8 // 0xE0
	ADSSTR1    volatile.Register8 // 0xE1
	ADSSTR2    volatile.Register8 // 0xE2
	ADSSTR3    volatile.Register8 // 0xE3
	ADSSTR4    volatile.Register8 // 0xE4
	ADSSTR5    volatile.Register8 // 0xE5
	ADSSTR6    volatile.Register8 // 0xE6
	ADSSTR7    volatile.Register8 // 0xE7
	ADSSTR8    volatile.Register8 // 0xE8
	ADSSTR9    volatile.Register8 // 0xE9
	ADSSTR10   volatile.Register8 // 0xEA
}

// ADC120.ADCSR: A/D Control Register
func (o *ADC120_Type) SetADCSR_DBLANS(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x1f)|value)
}
func (o *ADC120_Type) GetADCSR_DBLANS() uint16 {
	return volatile.LoadUint16(&o.ADCSR.Reg) & 0x1f
}
func (o *ADC120_Type) SetADCSR_GBADIE(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCSR_GBADIE() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADCSR_DBLE(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADCSR_DBLE() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADCSR_EXTRG(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADCSR_EXTRG() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADCSR_TRGE(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADCSR_TRGE() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADCSR_ADHSC(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADCSR_ADHSC() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADCSR_ADCS(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x6000)|value<<13)
}
func (o *ADC120_Type) GetADCSR_ADCS() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x6000) >> 13
}
func (o *ADC120_Type) SetADCSR_ADST(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADCSR_ADST() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x8000) >> 15
}

// ADC120.ADANSA0: A/D Channel Select Register A0
func (o *ADC120_Type) SetADANSA0_ANSA00(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADANSA0_ANSA00() uint16 {
	return volatile.LoadUint16(&o.ADANSA0.Reg) & 0x1
}
func (o *ADC120_Type) SetADANSA0_ANSA01(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADANSA0_ANSA01() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADANSA0_ANSA02(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADANSA0_ANSA02() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADANSA0_ANSA03(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADANSA0_ANSA03() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADANSA0_ANSA04(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADANSA0_ANSA04() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADANSA0_ANSA05(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADANSA0_ANSA05() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADANSA0_ANSA06(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADANSA0_ANSA06() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADANSA0_ANSA07(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADANSA0_ANSA07() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADANSA0_ANSA08(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADANSA0_ANSA08() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADANSA0_ANSA09(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADANSA0_ANSA09() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADANSA0_ANSA10(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADANSA0_ANSA10() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x400) >> 10
}

// ADC120.ADANSA1: A/D Channel Select Register A1
func (o *ADC120_Type) SetADANSA1_ANSA16(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADANSA1_ANSA16() uint16 {
	return volatile.LoadUint16(&o.ADANSA1.Reg) & 0x1
}
func (o *ADC120_Type) SetADANSA1_ANSA17(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADANSA1_ANSA17() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADANSA1_ANSA18(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADANSA1_ANSA18() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADANSA1_ANSA19(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADANSA1_ANSA19() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADANSA1_ANSA20(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADANSA1_ANSA20() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADANSA1_ANSA21(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADANSA1_ANSA21() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADANSA1_ANSA22(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADANSA1_ANSA22() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x40) >> 6
}

// ADC120.ADADS0: A/D-Converted Value Addition/Average Channel Select Register 0
func (o *ADC120_Type) SetADADS0_ADS00(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADADS0_ADS00() uint16 {
	return volatile.LoadUint16(&o.ADADS0.Reg) & 0x1
}
func (o *ADC120_Type) SetADADS0_ADS01(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADADS0_ADS01() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADADS0_ADS02(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADADS0_ADS02() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADADS0_ADS03(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADADS0_ADS03() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADADS0_ADS04(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADADS0_ADS04() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADADS0_ADS05(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADADS0_ADS05() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADADS0_ADS06(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADADS0_ADS06() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADADS0_ADS07(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADADS0_ADS07() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADADS0_ADS08(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADADS0_ADS08() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADADS0_ADS09(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADADS0_ADS09() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADADS0_ADS10(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADADS0_ADS10() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x400) >> 10
}

// ADC120.ADADS1: A/D-Converted Value Addition/Average Channel Select Register 1
func (o *ADC120_Type) SetADADS1_ADS16(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADADS1_ADS16() uint16 {
	return volatile.LoadUint16(&o.ADADS1.Reg) & 0x1
}
func (o *ADC120_Type) SetADADS1_ADS17(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADADS1_ADS17() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADADS1_ADS18(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADADS1_ADS18() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADADS1_ADS19(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADADS1_ADS19() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADADS1_ADS20(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADADS1_ADS20() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADADS1_ADS21(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADADS1_ADS21() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADADS1_ADS22(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADADS1_ADS22() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x40) >> 6
}

// ADC120.ADADC: A/D-Converted Value Addition/Average Count Select Register
func (o *ADC120_Type) SetADADC_ADC(value uint8) {
	volatile.StoreUint8(&o.ADADC.Reg, volatile.LoadUint8(&o.ADADC.Reg)&^(0x7)|value)
}
func (o *ADC120_Type) GetADADC_ADC() uint8 {
	return volatile.LoadUint8(&o.ADADC.Reg) & 0x7
}
func (o *ADC120_Type) SetADADC_AVEE(value uint8) {
	volatile.StoreUint8(&o.ADADC.Reg, volatile.LoadUint8(&o.ADADC.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADADC_AVEE() uint8 {
	return (volatile.LoadUint8(&o.ADADC.Reg) & 0x80) >> 7
}

// ADC120.ADCER: A/D Control Extended Register
func (o *ADC120_Type) SetADCER_ACE(value uint16) {
	volatile.StoreUint16(&o.ADCER.Reg, volatile.LoadUint16(&o.ADCER.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCER_ACE() uint16 {
	return (volatile.LoadUint16(&o.ADCER.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCER_DIAGVAL(value uint16) {
	volatile.StoreUint16(&o.ADCER.Reg, volatile.LoadUint16(&o.ADCER.Reg)&^(0x300)|value<<8)
}
func (o *ADC120_Type) GetADCER_DIAGVAL() uint16 {
	return (volatile.LoadUint16(&o.ADCER.Reg) & 0x300) >> 8
}
func (o *ADC120_Type) SetADCER_DIAGLD(value uint16) {
	volatile.StoreUint16(&o.ADCER.Reg, volatile.LoadUint16(&o.ADCER.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADCER_DIAGLD() uint16 {
	return (volatile.LoadUint16(&o.ADCER.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADCER_DIAGM(value uint16) {
	volatile.StoreUint16(&o.ADCER.Reg, volatile.LoadUint16(&o.ADCER.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADCER_DIAGM() uint16 {
	return (volatile.LoadUint16(&o.ADCER.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADCER_ADRFMT(value uint16) {
	volatile.StoreUint16(&o.ADCER.Reg, volatile.LoadUint16(&o.ADCER.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADCER_ADRFMT() uint16 {
	return (volatile.LoadUint16(&o.ADCER.Reg) & 0x8000) >> 15
}

// ADC120.ADSTRGR: A/D Conversion Start Trigger Select Register
func (o *ADC120_Type) SetADSTRGR_TRSB(value uint16) {
	volatile.StoreUint16(&o.ADSTRGR.Reg, volatile.LoadUint16(&o.ADSTRGR.Reg)&^(0x3f)|value)
}
func (o *ADC120_Type) GetADSTRGR_TRSB() uint16 {
	return volatile.LoadUint16(&o.ADSTRGR.Reg) & 0x3f
}
func (o *ADC120_Type) SetADSTRGR_TRSA(value uint16) {
	volatile.StoreUint16(&o.ADSTRGR.Reg, volatile.LoadUint16(&o.ADSTRGR.Reg)&^(0x3f00)|value<<8)
}
func (o *ADC120_Type) GetADSTRGR_TRSA() uint16 {
	return (volatile.LoadUint16(&o.ADSTRGR.Reg) & 0x3f00) >> 8
}

// ADC120.ADEXICR: A/D Conversion Extended Input Control Registers
func (o *ADC120_Type) SetADEXICR_TSSAD(value uint16) {
	volatile.StoreUint16(&o.ADEXICR.Reg, volatile.LoadUint16(&o.ADEXICR.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADEXICR_TSSAD() uint16 {
	return volatile.LoadUint16(&o.ADEXICR.Reg) & 0x1
}
func (o *ADC120_Type) SetADEXICR_OCSAD(value uint16) {
	volatile.StoreUint16(&o.ADEXICR.Reg, volatile.LoadUint16(&o.ADEXICR.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADEXICR_OCSAD() uint16 {
	return (volatile.LoadUint16(&o.ADEXICR.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADEXICR_TSSA(value uint16) {
	volatile.StoreUint16(&o.ADEXICR.Reg, volatile.LoadUint16(&o.ADEXICR.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADEXICR_TSSA() uint16 {
	return (volatile.LoadUint16(&o.ADEXICR.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADEXICR_OCSA(value uint16) {
	volatile.StoreUint16(&o.ADEXICR.Reg, volatile.LoadUint16(&o.ADEXICR.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADEXICR_OCSA() uint16 {
	return (volatile.LoadUint16(&o.ADEXICR.Reg) & 0x200) >> 9
}

// ADC120.ADANSB0: A/D Channel Select Register B0
func (o *ADC120_Type) SetADANSB0_ANSB00(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADANSB0_ANSB00() uint16 {
	return volatile.LoadUint16(&o.ADANSB0.Reg) & 0x1
}
func (o *ADC120_Type) SetADANSB0_ANSB01(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADANSB0_ANSB01() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADANSB0_ANSB02(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADANSB0_ANSB02() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADANSB0_ANSB03(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADANSB0_ANSB03() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADANSB0_ANSB04(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADANSB0_ANSB04() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADANSB0_ANSB05(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADANSB0_ANSB05() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADANSB0_ANSB06(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADANSB0_ANSB06() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADANSB0_ANSB07(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADANSB0_ANSB07() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADANSB0_ANSB08(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADANSB0_ANSB08() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADANSB0_ANSB09(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADANSB0_ANSB09() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADANSB0_ANSB10(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADANSB0_ANSB10() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x400) >> 10
}

// ADC120.ADANSB1: A/D Channel Select Register B1
func (o *ADC120_Type) SetADANSB1_ANSB16(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADANSB1_ANSB16() uint16 {
	return volatile.LoadUint16(&o.ADANSB1.Reg) & 0x1
}
func (o *ADC120_Type) SetADANSB1_ANSB17(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADANSB1_ANSB17() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADANSB1_ANSB18(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADANSB1_ANSB18() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADANSB1_ANSB19(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADANSB1_ANSB19() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADANSB1_ANSB20(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADANSB1_ANSB20() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADANSB1_ANSB21(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADANSB1_ANSB21() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADANSB1_ANSB22(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADANSB1_ANSB22() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x40) >> 6
}

// ADC120.ADDBLDR: A/D Data Duplexing Register
func (o *ADC120_Type) SetADDBLDR(value uint16) {
	volatile.StoreUint16(&o.ADDBLDR.Reg, value)
}
func (o *ADC120_Type) GetADDBLDR() uint16 {
	return volatile.LoadUint16(&o.ADDBLDR.Reg)
}

// ADC120.ADTSDR: A/D Temperature Sensor Data Register
func (o *ADC120_Type) SetADTSDR(value uint16) {
	volatile.StoreUint16(&o.ADTSDR.Reg, value)
}
func (o *ADC120_Type) GetADTSDR() uint16 {
	return volatile.LoadUint16(&o.ADTSDR.Reg)
}

// ADC120.ADOCDR: A/D Internal Reference Voltage Data Register
func (o *ADC120_Type) SetADOCDR(value uint16) {
	volatile.StoreUint16(&o.ADOCDR.Reg, value)
}
func (o *ADC120_Type) GetADOCDR() uint16 {
	return volatile.LoadUint16(&o.ADOCDR.Reg)
}

// ADC120.ADRD: A/D Self-Diagnosis Data Register
func (o *ADC120_Type) SetADRD_AD(value uint16) {
	volatile.StoreUint16(&o.ADRD.Reg, volatile.LoadUint16(&o.ADRD.Reg)&^(0xfff)|value)
}
func (o *ADC120_Type) GetADRD_AD() uint16 {
	return volatile.LoadUint16(&o.ADRD.Reg) & 0xfff
}
func (o *ADC120_Type) SetADRD_DIAGST(value uint16) {
	volatile.StoreUint16(&o.ADRD.Reg, volatile.LoadUint16(&o.ADRD.Reg)&^(0xc000)|value<<14)
}
func (o *ADC120_Type) GetADRD_DIAGST() uint16 {
	return (volatile.LoadUint16(&o.ADRD.Reg) & 0xc000) >> 14
}

// ADC120.ADDR0: A/D Data Registers %s
func (o *ADC120_Type) SetADDR0(value uint16) {
	volatile.StoreUint16(&o.ADDR0.Reg, value)
}
func (o *ADC120_Type) GetADDR0() uint16 {
	return volatile.LoadUint16(&o.ADDR0.Reg)
}

// ADC120.ADDR1: A/D Data Registers %s
func (o *ADC120_Type) SetADDR1(value uint16) {
	volatile.StoreUint16(&o.ADDR1.Reg, value)
}
func (o *ADC120_Type) GetADDR1() uint16 {
	return volatile.LoadUint16(&o.ADDR1.Reg)
}

// ADC120.ADDR2: A/D Data Registers %s
func (o *ADC120_Type) SetADDR2(value uint16) {
	volatile.StoreUint16(&o.ADDR2.Reg, value)
}
func (o *ADC120_Type) GetADDR2() uint16 {
	return volatile.LoadUint16(&o.ADDR2.Reg)
}

// ADC120.ADDR3: A/D Data Registers %s
func (o *ADC120_Type) SetADDR3(value uint16) {
	volatile.StoreUint16(&o.ADDR3.Reg, value)
}
func (o *ADC120_Type) GetADDR3() uint16 {
	return volatile.LoadUint16(&o.ADDR3.Reg)
}

// ADC120.ADDR4: A/D Data Registers %s
func (o *ADC120_Type) SetADDR4(value uint16) {
	volatile.StoreUint16(&o.ADDR4.Reg, value)
}
func (o *ADC120_Type) GetADDR4() uint16 {
	return volatile.LoadUint16(&o.ADDR4.Reg)
}

// ADC120.ADDR5: A/D Data Registers %s
func (o *ADC120_Type) SetADDR5(value uint16) {
	volatile.StoreUint16(&o.ADDR5.Reg, value)
}
func (o *ADC120_Type) GetADDR5() uint16 {
	return volatile.LoadUint16(&o.ADDR5.Reg)
}

// ADC120.ADDR6: A/D Data Registers %s
func (o *ADC120_Type) SetADDR6(value uint16) {
	volatile.StoreUint16(&o.ADDR6.Reg, value)
}
func (o *ADC120_Type) GetADDR6() uint16 {
	return volatile.LoadUint16(&o.ADDR6.Reg)
}

// ADC120.ADDR7: A/D Data Registers %s
func (o *ADC120_Type) SetADDR7(value uint16) {
	volatile.StoreUint16(&o.ADDR7.Reg, value)
}
func (o *ADC120_Type) GetADDR7() uint16 {
	return volatile.LoadUint16(&o.ADDR7.Reg)
}

// ADC120.ADDR8: A/D Data Registers %s
func (o *ADC120_Type) SetADDR8(value uint16) {
	volatile.StoreUint16(&o.ADDR8.Reg, value)
}
func (o *ADC120_Type) GetADDR8() uint16 {
	return volatile.LoadUint16(&o.ADDR8.Reg)
}

// ADC120.ADDR9: A/D Data Registers %s
func (o *ADC120_Type) SetADDR9(value uint16) {
	volatile.StoreUint16(&o.ADDR9.Reg, value)
}
func (o *ADC120_Type) GetADDR9() uint16 {
	return volatile.LoadUint16(&o.ADDR9.Reg)
}

// ADC120.ADDR10: A/D Data Registers %s
func (o *ADC120_Type) SetADDR10(value uint16) {
	volatile.StoreUint16(&o.ADDR10.Reg, value)
}
func (o *ADC120_Type) GetADDR10() uint16 {
	return volatile.LoadUint16(&o.ADDR10.Reg)
}

// ADC120.ADCTDR: A/D CTSU TSCAP Voltage Data Register
func (o *ADC120_Type) SetADCTDR(value uint16) {
	volatile.StoreUint16(&o.ADCTDR.Reg, value)
}
func (o *ADC120_Type) GetADCTDR() uint16 {
	return volatile.LoadUint16(&o.ADCTDR.Reg)
}

// ADC120.ADDR17: A/D Data Registers %s
func (o *ADC120_Type) SetADDR17(value uint16) {
	volatile.StoreUint16(&o.ADDR17.Reg, value)
}
func (o *ADC120_Type) GetADDR17() uint16 {
	return volatile.LoadUint16(&o.ADDR17.Reg)
}

// ADC120.ADDR18: A/D Data Registers %s
func (o *ADC120_Type) SetADDR18(value uint16) {
	volatile.StoreUint16(&o.ADDR18.Reg, value)
}
func (o *ADC120_Type) GetADDR18() uint16 {
	return volatile.LoadUint16(&o.ADDR18.Reg)
}

// ADC120.ADDR19: A/D Data Registers %s
func (o *ADC120_Type) SetADDR19(value uint16) {
	volatile.StoreUint16(&o.ADDR19.Reg, value)
}
func (o *ADC120_Type) GetADDR19() uint16 {
	return volatile.LoadUint16(&o.ADDR19.Reg)
}

// ADC120.ADDR20: A/D Data Registers %s
func (o *ADC120_Type) SetADDR20(value uint16) {
	volatile.StoreUint16(&o.ADDR20.Reg, value)
}
func (o *ADC120_Type) GetADDR20() uint16 {
	return volatile.LoadUint16(&o.ADDR20.Reg)
}

// ADC120.ADDR21: A/D Data Registers %s
func (o *ADC120_Type) SetADDR21(value uint16) {
	volatile.StoreUint16(&o.ADDR21.Reg, value)
}
func (o *ADC120_Type) GetADDR21() uint16 {
	return volatile.LoadUint16(&o.ADDR21.Reg)
}

// ADC120.ADDR22: A/D Data Registers %s
func (o *ADC120_Type) SetADDR22(value uint16) {
	volatile.StoreUint16(&o.ADDR22.Reg, value)
}
func (o *ADC120_Type) GetADDR22() uint16 {
	return volatile.LoadUint16(&o.ADDR22.Reg)
}

// ADC120.ADDISCR: A/D Disconnection Detection Control Register
func (o *ADC120_Type) SetADDISCR_ADNDIS(value uint8) {
	volatile.StoreUint8(&o.ADDISCR.Reg, volatile.LoadUint8(&o.ADDISCR.Reg)&^(0xf)|value)
}
func (o *ADC120_Type) GetADDISCR_ADNDIS() uint8 {
	return volatile.LoadUint8(&o.ADDISCR.Reg) & 0xf
}
func (o *ADC120_Type) SetADDISCR_PCHG(value uint8) {
	volatile.StoreUint8(&o.ADDISCR.Reg, volatile.LoadUint8(&o.ADDISCR.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADDISCR_PCHG() uint8 {
	return (volatile.LoadUint8(&o.ADDISCR.Reg) & 0x10) >> 4
}

// ADC120.ADACSR: A/D Conversion Operation Mode Select Register
func (o *ADC120_Type) SetADACSR_ADSAC(value uint8) {
	volatile.StoreUint8(&o.ADACSR.Reg, volatile.LoadUint8(&o.ADACSR.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADACSR_ADSAC() uint8 {
	return (volatile.LoadUint8(&o.ADACSR.Reg) & 0x2) >> 1
}

// ADC120.ADGSPCR: A/D Group Scan Priority Control Register
func (o *ADC120_Type) SetADGSPCR_PGS(value uint16) {
	volatile.StoreUint16(&o.ADGSPCR.Reg, volatile.LoadUint16(&o.ADGSPCR.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADGSPCR_PGS() uint16 {
	return volatile.LoadUint16(&o.ADGSPCR.Reg) & 0x1
}
func (o *ADC120_Type) SetADGSPCR_GBRSCN(value uint16) {
	volatile.StoreUint16(&o.ADGSPCR.Reg, volatile.LoadUint16(&o.ADGSPCR.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADGSPCR_GBRSCN() uint16 {
	return (volatile.LoadUint16(&o.ADGSPCR.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADGSPCR_GBRP(value uint16) {
	volatile.StoreUint16(&o.ADGSPCR.Reg, volatile.LoadUint16(&o.ADGSPCR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADGSPCR_GBRP() uint16 {
	return (volatile.LoadUint16(&o.ADGSPCR.Reg) & 0x8000) >> 15
}

// ADC120.ADDBLDRA: A/D Data Duplexing Register A
func (o *ADC120_Type) SetADDBLDRA(value uint16) {
	volatile.StoreUint16(&o.ADDBLDRA.Reg, value)
}
func (o *ADC120_Type) GetADDBLDRA() uint16 {
	return volatile.LoadUint16(&o.ADDBLDRA.Reg)
}

// ADC120.ADDBLDRB: A/D Data Duplexing Register B
func (o *ADC120_Type) SetADDBLDRB(value uint16) {
	volatile.StoreUint16(&o.ADDBLDRB.Reg, value)
}
func (o *ADC120_Type) GetADDBLDRB() uint16 {
	return volatile.LoadUint16(&o.ADDBLDRB.Reg)
}

// ADC120.ADHVREFCNT: A/D High-Potential/Low-Potential Reference Voltage Control Register
func (o *ADC120_Type) SetADHVREFCNT_HVSEL(value uint8) {
	volatile.StoreUint8(&o.ADHVREFCNT.Reg, volatile.LoadUint8(&o.ADHVREFCNT.Reg)&^(0x3)|value)
}
func (o *ADC120_Type) GetADHVREFCNT_HVSEL() uint8 {
	return volatile.LoadUint8(&o.ADHVREFCNT.Reg) & 0x3
}
func (o *ADC120_Type) SetADHVREFCNT_LVSEL(value uint8) {
	volatile.StoreUint8(&o.ADHVREFCNT.Reg, volatile.LoadUint8(&o.ADHVREFCNT.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADHVREFCNT_LVSEL() uint8 {
	return (volatile.LoadUint8(&o.ADHVREFCNT.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADHVREFCNT_ADSLP(value uint8) {
	volatile.StoreUint8(&o.ADHVREFCNT.Reg, volatile.LoadUint8(&o.ADHVREFCNT.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADHVREFCNT_ADSLP() uint8 {
	return (volatile.LoadUint8(&o.ADHVREFCNT.Reg) & 0x80) >> 7
}

// ADC120.ADWINMON: A/D Compare Function Window A/B Status Monitor Register
func (o *ADC120_Type) SetADWINMON_MONCOMB(value uint8) {
	volatile.StoreUint8(&o.ADWINMON.Reg, volatile.LoadUint8(&o.ADWINMON.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADWINMON_MONCOMB() uint8 {
	return volatile.LoadUint8(&o.ADWINMON.Reg) & 0x1
}
func (o *ADC120_Type) SetADWINMON_MONCMPA(value uint8) {
	volatile.StoreUint8(&o.ADWINMON.Reg, volatile.LoadUint8(&o.ADWINMON.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADWINMON_MONCMPA() uint8 {
	return (volatile.LoadUint8(&o.ADWINMON.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADWINMON_MONCMPB(value uint8) {
	volatile.StoreUint8(&o.ADWINMON.Reg, volatile.LoadUint8(&o.ADWINMON.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADWINMON_MONCMPB() uint8 {
	return (volatile.LoadUint8(&o.ADWINMON.Reg) & 0x20) >> 5
}

// ADC120.ADCMPCR: A/D Compare Function Control Register
func (o *ADC120_Type) SetADCMPCR_CMPAB(value uint16) {
	volatile.StoreUint16(&o.ADCMPCR.Reg, volatile.LoadUint16(&o.ADCMPCR.Reg)&^(0x3)|value)
}
func (o *ADC120_Type) GetADCMPCR_CMPAB() uint16 {
	return volatile.LoadUint16(&o.ADCMPCR.Reg) & 0x3
}
func (o *ADC120_Type) SetADCMPCR_CMPBE(value uint16) {
	volatile.StoreUint16(&o.ADCMPCR.Reg, volatile.LoadUint16(&o.ADCMPCR.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADCMPCR_CMPBE() uint16 {
	return (volatile.LoadUint16(&o.ADCMPCR.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADCMPCR_CMPAE(value uint16) {
	volatile.StoreUint16(&o.ADCMPCR.Reg, volatile.LoadUint16(&o.ADCMPCR.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADCMPCR_CMPAE() uint16 {
	return (volatile.LoadUint16(&o.ADCMPCR.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADCMPCR_CMPBIE(value uint16) {
	volatile.StoreUint16(&o.ADCMPCR.Reg, volatile.LoadUint16(&o.ADCMPCR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADCMPCR_CMPBIE() uint16 {
	return (volatile.LoadUint16(&o.ADCMPCR.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADCMPCR_WCMPE(value uint16) {
	volatile.StoreUint16(&o.ADCMPCR.Reg, volatile.LoadUint16(&o.ADCMPCR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADCMPCR_WCMPE() uint16 {
	return (volatile.LoadUint16(&o.ADCMPCR.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADCMPCR_CMPAIE(value uint16) {
	volatile.StoreUint16(&o.ADCMPCR.Reg, volatile.LoadUint16(&o.ADCMPCR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADCMPCR_CMPAIE() uint16 {
	return (volatile.LoadUint16(&o.ADCMPCR.Reg) & 0x8000) >> 15
}

// ADC120.ADCMPANSER: A/D Compare Function Window A Extended Input Select Register
func (o *ADC120_Type) SetADCMPANSER_CMPTSA(value uint8) {
	volatile.StoreUint8(&o.ADCMPANSER.Reg, volatile.LoadUint8(&o.ADCMPANSER.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPANSER_CMPTSA() uint8 {
	return volatile.LoadUint8(&o.ADCMPANSER.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPANSER_CMPOCA(value uint8) {
	volatile.StoreUint8(&o.ADCMPANSER.Reg, volatile.LoadUint8(&o.ADCMPANSER.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPANSER_CMPOCA() uint8 {
	return (volatile.LoadUint8(&o.ADCMPANSER.Reg) & 0x2) >> 1
}

// ADC120.ADCMPLER: A/D Compare Function Window A Extended Input Comparison Condition Setting Register
func (o *ADC120_Type) SetADCMPLER_CMPLTSA(value uint8) {
	volatile.StoreUint8(&o.ADCMPLER.Reg, volatile.LoadUint8(&o.ADCMPLER.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPLER_CMPLTSA() uint8 {
	return volatile.LoadUint8(&o.ADCMPLER.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPLER_CMPLOCA(value uint8) {
	volatile.StoreUint8(&o.ADCMPLER.Reg, volatile.LoadUint8(&o.ADCMPLER.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPLER_CMPLOCA() uint8 {
	return (volatile.LoadUint8(&o.ADCMPLER.Reg) & 0x2) >> 1
}

// ADC120.ADCMPANSR0: A/D Compare Function Window A Channel Select Register 0
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA00(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA00() uint16 {
	return volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA01(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA01() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA02(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA02() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA03(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA03() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA04(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA04() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA05(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA05() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA06(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA06() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA07(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA07() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA08(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA08() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA09(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA09() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA10(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA10() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x400) >> 10
}

// ADC120.ADCMPANSR1: A/D Compare Function Window A Channel Select Register 1
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA16(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA16() uint16 {
	return volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA17(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA17() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA18(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA18() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA19(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA19() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA20(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA20() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA21(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA21() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA22(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA22() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x40) >> 6
}

// ADC120.ADCMPLR0: A/D Compare Function Window A Comparison Condition Setting Register 0
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA00(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA00() uint16 {
	return volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA01(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA01() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA02(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA02() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA03(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA03() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA04(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA04() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA05(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA05() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA06(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA06() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA07(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA07() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA08(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA08() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA09(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA09() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA10(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA10() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x400) >> 10
}

// ADC120.ADCMPLR1: A/D Compare Function Window A Comparison Condition Setting Register 1
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA16(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA16() uint16 {
	return volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA17(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA17() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA18(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA18() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA19(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA19() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA20(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA20() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA21(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA21() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA22(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA22() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x40) >> 6
}

// ADC120.ADCMPSR0: A/D Compare Function Window A Channel Status Register 0
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA00(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA00() uint16 {
	return volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA01(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA01() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA02(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA02() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA03(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA03() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA04(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA04() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA05(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA05() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA06(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA06() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA07(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA07() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA08(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA08() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA09(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA09() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA10(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA10() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x400) >> 10
}

// ADC120.ADCMPSR1: A/D Compare Function Window A Channel Status Register1
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA16(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA16() uint16 {
	return volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA17(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA17() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA18(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA18() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA19(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA19() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA20(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA20() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA21(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA21() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA22(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA22() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x40) >> 6
}

// ADC120.ADCMPSER: A/D Compare Function Window A Extended Input Channel Status Register
func (o *ADC120_Type) SetADCMPSER_CMPSTTSA(value uint8) {
	volatile.StoreUint8(&o.ADCMPSER.Reg, volatile.LoadUint8(&o.ADCMPSER.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPSER_CMPSTTSA() uint8 {
	return volatile.LoadUint8(&o.ADCMPSER.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPSER_CMPSTOCA(value uint8) {
	volatile.StoreUint8(&o.ADCMPSER.Reg, volatile.LoadUint8(&o.ADCMPSER.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPSER_CMPSTOCA() uint8 {
	return (volatile.LoadUint8(&o.ADCMPSER.Reg) & 0x2) >> 1
}

// ADC120.ADCMPBNSR: A/D Compare Function Window B Channel Select Register
func (o *ADC120_Type) SetADCMPBNSR_CMPCHB(value uint8) {
	volatile.StoreUint8(&o.ADCMPBNSR.Reg, volatile.LoadUint8(&o.ADCMPBNSR.Reg)&^(0x3f)|value)
}
func (o *ADC120_Type) GetADCMPBNSR_CMPCHB() uint8 {
	return volatile.LoadUint8(&o.ADCMPBNSR.Reg) & 0x3f
}
func (o *ADC120_Type) SetADCMPBNSR_CMPLB(value uint8) {
	volatile.StoreUint8(&o.ADCMPBNSR.Reg, volatile.LoadUint8(&o.ADCMPBNSR.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADCMPBNSR_CMPLB() uint8 {
	return (volatile.LoadUint8(&o.ADCMPBNSR.Reg) & 0x80) >> 7
}

// ADC120.ADCMPBSR: A/D Compare Function Window B Status Register
func (o *ADC120_Type) SetADCMPBSR_CMPSTB(value uint8) {
	volatile.StoreUint8(&o.ADCMPBSR.Reg, volatile.LoadUint8(&o.ADCMPBSR.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPBSR_CMPSTB() uint8 {
	return volatile.LoadUint8(&o.ADCMPBSR.Reg) & 0x1
}

// ADC120.ADSSTRL: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTRL(value uint8) {
	volatile.StoreUint8(&o.ADSSTRL.Reg, value)
}
func (o *ADC120_Type) GetADSSTRL() uint8 {
	return volatile.LoadUint8(&o.ADSSTRL.Reg)
}

// ADC120.ADSSTRT: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTRT(value uint8) {
	volatile.StoreUint8(&o.ADSSTRT.Reg, value)
}
func (o *ADC120_Type) GetADSSTRT() uint8 {
	return volatile.LoadUint8(&o.ADSSTRT.Reg)
}

// ADC120.ADSSTRO: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTRO(value uint8) {
	volatile.StoreUint8(&o.ADSSTRO.Reg, value)
}
func (o *ADC120_Type) GetADSSTRO() uint8 {
	return volatile.LoadUint8(&o.ADSSTRO.Reg)
}

// ADC120.ADSSTR0: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR0(value uint8) {
	volatile.StoreUint8(&o.ADSSTR0.Reg, value)
}
func (o *ADC120_Type) GetADSSTR0() uint8 {
	return volatile.LoadUint8(&o.ADSSTR0.Reg)
}

// ADC120.ADSSTR1: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR1(value uint8) {
	volatile.StoreUint8(&o.ADSSTR1.Reg, value)
}
func (o *ADC120_Type) GetADSSTR1() uint8 {
	return volatile.LoadUint8(&o.ADSSTR1.Reg)
}

// ADC120.ADSSTR2: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR2(value uint8) {
	volatile.StoreUint8(&o.ADSSTR2.Reg, value)
}
func (o *ADC120_Type) GetADSSTR2() uint8 {
	return volatile.LoadUint8(&o.ADSSTR2.Reg)
}

// ADC120.ADSSTR3: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR3(value uint8) {
	volatile.StoreUint8(&o.ADSSTR3.Reg, value)
}
func (o *ADC120_Type) GetADSSTR3() uint8 {
	return volatile.LoadUint8(&o.ADSSTR3.Reg)
}

// ADC120.ADSSTR4: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR4(value uint8) {
	volatile.StoreUint8(&o.ADSSTR4.Reg, value)
}
func (o *ADC120_Type) GetADSSTR4() uint8 {
	return volatile.LoadUint8(&o.ADSSTR4.Reg)
}

// ADC120.ADSSTR5: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR5(value uint8) {
	volatile.StoreUint8(&o.ADSSTR5.Reg, value)
}
func (o *ADC120_Type) GetADSSTR5() uint8 {
	return volatile.LoadUint8(&o.ADSSTR5.Reg)
}

// ADC120.ADSSTR6: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR6(value uint8) {
	volatile.StoreUint8(&o.ADSSTR6.Reg, value)
}
func (o *ADC120_Type) GetADSSTR6() uint8 {
	return volatile.LoadUint8(&o.ADSSTR6.Reg)
}

// ADC120.ADSSTR7: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR7(value uint8) {
	volatile.StoreUint8(&o.ADSSTR7.Reg, value)
}
func (o *ADC120_Type) GetADSSTR7() uint8 {
	return volatile.LoadUint8(&o.ADSSTR7.Reg)
}

// ADC120.ADSSTR8: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR8(value uint8) {
	volatile.StoreUint8(&o.ADSSTR8.Reg, value)
}
func (o *ADC120_Type) GetADSSTR8() uint8 {
	return volatile.LoadUint8(&o.ADSSTR8.Reg)
}

// ADC120.ADSSTR9: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR9(value uint8) {
	volatile.StoreUint8(&o.ADSSTR9.Reg, value)
}
func (o *ADC120_Type) GetADSSTR9() uint8 {
	return volatile.LoadUint8(&o.ADSSTR9.Reg)
}

// ADC120.ADSSTR10: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR10(value uint8) {
	volatile.StoreUint8(&o.ADSSTR10.Reg, value)
}
func (o *ADC120_Type) GetADSSTR10() uint8 {
	return volatile.LoadUint8(&o.ADSSTR10.Reg)
}

// Serial Communication Interface 0
type SCI0_Type struct {
	SMR    volatile.Register8  // 0x0
	BRR    volatile.Register8  // 0x1
	SCR    volatile.Register8  // 0x2
	TDR    volatile.Register8  // 0x3
	SSR    volatile.Register8  // 0x4
	RDR    volatile.Register8  // 0x5
	SCMR   volatile.Register8  // 0x6
	SEMR   volatile.Register8  // 0x7
	SNFR   volatile.Register8  // 0x8
	SIMR1  volatile.Register8  // 0x9
	SIMR2  volatile.Register8  // 0xA
	SIMR3  volatile.Register8  // 0xB
	SISR   volatile.Register8  // 0xC
	SPMR   volatile.Register8  // 0xD
	FTDRHL volatile.Register16 // 0xE
	FRDRHL volatile.Register16 // 0x10
	MDDR   volatile.Register8  // 0x12
	DCCR   volatile.Register8  // 0x13
	FCR    volatile.Register16 // 0x14
	FDR    volatile.Register16 // 0x16
	LSR    volatile.Register16 // 0x18
	CDR    volatile.Register16 // 0x1A
	SPTR   volatile.Register8  // 0x1C
}

// SCI0.SMR: Serial Mode Register for Non-Smart Card Interface Mode (SCMR.SMIF = 0)
func (o *SCI0_Type) SetSMR_CKS(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x3)|value)
}
func (o *SCI0_Type) GetSMR_CKS() uint8 {
	return volatile.LoadUint8(&o.SMR.Reg) & 0x3
}
func (o *SCI0_Type) SetSMR_MP(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x4)|value<<2)
}
func (o *SCI0_Type) GetSMR_MP() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x4) >> 2
}
func (o *SCI0_Type) SetSMR_STOP(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x8)|value<<3)
}
func (o *SCI0_Type) GetSMR_STOP() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x8) >> 3
}
func (o *SCI0_Type) SetSMR_PM(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x10)|value<<4)
}
func (o *SCI0_Type) GetSMR_PM() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x10) >> 4
}
func (o *SCI0_Type) SetSMR_PE(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x20)|value<<5)
}
func (o *SCI0_Type) GetSMR_PE() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x20) >> 5
}
func (o *SCI0_Type) SetSMR_CHR(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x40)|value<<6)
}
func (o *SCI0_Type) GetSMR_CHR() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x40) >> 6
}
func (o *SCI0_Type) SetSMR_CM(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x80)|value<<7)
}
func (o *SCI0_Type) GetSMR_CM() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x80) >> 7
}

// SCI0.SCR: Serial Control Register for Non-Smart Card Interface Mode (SCMR.SMIF = 0)
func (o *SCI0_Type) SetSCR_CKE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x3)|value)
}
func (o *SCI0_Type) GetSCR_CKE() uint8 {
	return volatile.LoadUint8(&o.SCR.Reg) & 0x3
}
func (o *SCI0_Type) SetSCR_TEIE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *SCI0_Type) GetSCR_TEIE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x4) >> 2
}
func (o *SCI0_Type) SetSCR_MPIE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *SCI0_Type) GetSCR_MPIE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x8) >> 3
}
func (o *SCI0_Type) SetSCR_RE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *SCI0_Type) GetSCR_RE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x10) >> 4
}
func (o *SCI0_Type) SetSCR_TE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x20)|value<<5)
}
func (o *SCI0_Type) GetSCR_TE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x20) >> 5
}
func (o *SCI0_Type) SetSCR_RIE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x40)|value<<6)
}
func (o *SCI0_Type) GetSCR_RIE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x40) >> 6
}
func (o *SCI0_Type) SetSCR_TIE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x80)|value<<7)
}
func (o *SCI0_Type) GetSCR_TIE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x80) >> 7
}

// SCI0.SSR: Serial Status Register for Non-Smart Card Interface and Non-FIFO Mode (SCMR.SMIF = 0, FCR.FM = 0)
func (o *SCI0_Type) SetSSR_MPBT(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x1)|value)
}
func (o *SCI0_Type) GetSSR_MPBT() uint8 {
	return volatile.LoadUint8(&o.SSR.Reg) & 0x1
}
func (o *SCI0_Type) SetSSR_MPB(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x2)|value<<1)
}
func (o *SCI0_Type) GetSSR_MPB() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x2) >> 1
}
func (o *SCI0_Type) SetSSR_TEND(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x4)|value<<2)
}
func (o *SCI0_Type) GetSSR_TEND() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x4) >> 2
}
func (o *SCI0_Type) SetSSR_PER(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x8)|value<<3)
}
func (o *SCI0_Type) GetSSR_PER() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x8) >> 3
}
func (o *SCI0_Type) SetSSR_FER(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x10)|value<<4)
}
func (o *SCI0_Type) GetSSR_FER() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x10) >> 4
}
func (o *SCI0_Type) SetSSR_ORER(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x20)|value<<5)
}
func (o *SCI0_Type) GetSSR_ORER() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x20) >> 5
}
func (o *SCI0_Type) SetSSR_RDRF(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x40)|value<<6)
}
func (o *SCI0_Type) GetSSR_RDRF() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x40) >> 6
}
func (o *SCI0_Type) SetSSR_TDRE(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x80)|value<<7)
}
func (o *SCI0_Type) GetSSR_TDRE() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x80) >> 7
}

// SCI0.SCMR: Smart Card Mode Register
func (o *SCI0_Type) SetSCMR_SMIF(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x1)|value)
}
func (o *SCI0_Type) GetSCMR_SMIF() uint8 {
	return volatile.LoadUint8(&o.SCMR.Reg) & 0x1
}
func (o *SCI0_Type) SetSCMR_SINV(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x4)|value<<2)
}
func (o *SCI0_Type) GetSCMR_SINV() uint8 {
	return (volatile.LoadUint8(&o.SCMR.Reg) & 0x4) >> 2
}
func (o *SCI0_Type) SetSCMR_SDIR(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x8)|value<<3)
}
func (o *SCI0_Type) GetSCMR_SDIR() uint8 {
	return (volatile.LoadUint8(&o.SCMR.Reg) & 0x8) >> 3
}
func (o *SCI0_Type) SetSCMR_CHR1(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x10)|value<<4)
}
func (o *SCI0_Type) GetSCMR_CHR1() uint8 {
	return (volatile.LoadUint8(&o.SCMR.Reg) & 0x10) >> 4
}
func (o *SCI0_Type) SetSCMR_BCP2(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x80)|value<<7)
}
func (o *SCI0_Type) GetSCMR_BCP2() uint8 {
	return (volatile.LoadUint8(&o.SCMR.Reg) & 0x80) >> 7
}

// SCI0.SEMR: Serial Extended Mode Register
func (o *SCI0_Type) SetSEMR_BRME(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x4)|value<<2)
}
func (o *SCI0_Type) GetSEMR_BRME() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x4) >> 2
}
func (o *SCI0_Type) SetSEMR_ABCSE(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x8)|value<<3)
}
func (o *SCI0_Type) GetSEMR_ABCSE() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x8) >> 3
}
func (o *SCI0_Type) SetSEMR_ABCS(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x10)|value<<4)
}
func (o *SCI0_Type) GetSEMR_ABCS() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x10) >> 4
}
func (o *SCI0_Type) SetSEMR_NFEN(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x20)|value<<5)
}
func (o *SCI0_Type) GetSEMR_NFEN() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x20) >> 5
}
func (o *SCI0_Type) SetSEMR_BGDM(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x40)|value<<6)
}
func (o *SCI0_Type) GetSEMR_BGDM() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x40) >> 6
}
func (o *SCI0_Type) SetSEMR_RXDESEL(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x80)|value<<7)
}
func (o *SCI0_Type) GetSEMR_RXDESEL() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x80) >> 7
}

// SCI0.SNFR: Noise Filter Setting Register
func (o *SCI0_Type) SetSNFR_NFCS(value uint8) {
	volatile.StoreUint8(&o.SNFR.Reg, volatile.LoadUint8(&o.SNFR.Reg)&^(0x7)|value)
}
func (o *SCI0_Type) GetSNFR_NFCS() uint8 {
	return volatile.LoadUint8(&o.SNFR.Reg) & 0x7
}

// SCI0.SIMR1: IIC Mode Register 1
func (o *SCI0_Type) SetSIMR1_IICM(value uint8) {
	volatile.StoreUint8(&o.SIMR1.Reg, volatile.LoadUint8(&o.SIMR1.Reg)&^(0x1)|value)
}
func (o *SCI0_Type) GetSIMR1_IICM() uint8 {
	return volatile.LoadUint8(&o.SIMR1.Reg) & 0x1
}
func (o *SCI0_Type) SetSIMR1_IICDL(value uint8) {
	volatile.StoreUint8(&o.SIMR1.Reg, volatile.LoadUint8(&o.SIMR1.Reg)&^(0xf8)|value<<3)
}
func (o *SCI0_Type) GetSIMR1_IICDL() uint8 {
	return (volatile.LoadUint8(&o.SIMR1.Reg) & 0xf8) >> 3
}

// SCI0.SIMR2: IIC Mode Register 2
func (o *SCI0_Type) SetSIMR2_IICINTM(value uint8) {
	volatile.StoreUint8(&o.SIMR2.Reg, volatile.LoadUint8(&o.SIMR2.Reg)&^(0x1)|value)
}
func (o *SCI0_Type) GetSIMR2_IICINTM() uint8 {
	return volatile.LoadUint8(&o.SIMR2.Reg) & 0x1
}
func (o *SCI0_Type) SetSIMR2_IICCSC(value uint8) {
	volatile.StoreUint8(&o.SIMR2.Reg, volatile.LoadUint8(&o.SIMR2.Reg)&^(0x2)|value<<1)
}
func (o *SCI0_Type) GetSIMR2_IICCSC() uint8 {
	return (volatile.LoadUint8(&o.SIMR2.Reg) & 0x2) >> 1
}
func (o *SCI0_Type) SetSIMR2_IICACKT(value uint8) {
	volatile.StoreUint8(&o.SIMR2.Reg, volatile.LoadUint8(&o.SIMR2.Reg)&^(0x20)|value<<5)
}
func (o *SCI0_Type) GetSIMR2_IICACKT() uint8 {
	return (volatile.LoadUint8(&o.SIMR2.Reg) & 0x20) >> 5
}

// SCI0.SIMR3: IIC Mode Register 3
func (o *SCI0_Type) SetSIMR3_IICSTAREQ(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x1)|value)
}
func (o *SCI0_Type) GetSIMR3_IICSTAREQ() uint8 {
	return volatile.LoadUint8(&o.SIMR3.Reg) & 0x1
}
func (o *SCI0_Type) SetSIMR3_IICRSTAREQ(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x2)|value<<1)
}
func (o *SCI0_Type) GetSIMR3_IICRSTAREQ() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0x2) >> 1
}
func (o *SCI0_Type) SetSIMR3_IICSTPREQ(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x4)|value<<2)
}
func (o *SCI0_Type) GetSIMR3_IICSTPREQ() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0x4) >> 2
}
func (o *SCI0_Type) SetSIMR3_IICSTIF(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x8)|value<<3)
}
func (o *SCI0_Type) GetSIMR3_IICSTIF() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0x8) >> 3
}
func (o *SCI0_Type) SetSIMR3_IICSDAS(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x30)|value<<4)
}
func (o *SCI0_Type) GetSIMR3_IICSDAS() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0x30) >> 4
}
func (o *SCI0_Type) SetSIMR3_IICSCLS(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0xc0)|value<<6)
}
func (o *SCI0_Type) GetSIMR3_IICSCLS() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0xc0) >> 6
}

// SCI0.SISR: IIC Status Register
func (o *SCI0_Type) SetSISR_IICACKR(value uint8) {
	volatile.StoreUint8(&o.SISR.Reg, volatile.LoadUint8(&o.SISR.Reg)&^(0x1)|value)
}
func (o *SCI0_Type) GetSISR_IICACKR() uint8 {
	return volatile.LoadUint8(&o.SISR.Reg) & 0x1
}

// SCI0.SPMR: SPI Mode Register
func (o *SCI0_Type) SetSPMR_SSE(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x1)|value)
}
func (o *SCI0_Type) GetSPMR_SSE() uint8 {
	return volatile.LoadUint8(&o.SPMR.Reg) & 0x1
}
func (o *SCI0_Type) SetSPMR_CTSE(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x2)|value<<1)
}
func (o *SCI0_Type) GetSPMR_CTSE() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x2) >> 1
}
func (o *SCI0_Type) SetSPMR_MSS(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x4)|value<<2)
}
func (o *SCI0_Type) GetSPMR_MSS() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x4) >> 2
}
func (o *SCI0_Type) SetSPMR_MFF(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x10)|value<<4)
}
func (o *SCI0_Type) GetSPMR_MFF() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x10) >> 4
}
func (o *SCI0_Type) SetSPMR_CKPOL(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x40)|value<<6)
}
func (o *SCI0_Type) GetSPMR_CKPOL() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x40) >> 6
}
func (o *SCI0_Type) SetSPMR_CKPH(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x80)|value<<7)
}
func (o *SCI0_Type) GetSPMR_CKPH() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x80) >> 7
}

// SCI0.FTDRHL: Transmit FIFO Data Register
func (o *SCI0_Type) SetFTDRHL_TDAT(value uint16) {
	volatile.StoreUint16(&o.FTDRHL.Reg, volatile.LoadUint16(&o.FTDRHL.Reg)&^(0x1ff)|value)
}
func (o *SCI0_Type) GetFTDRHL_TDAT() uint16 {
	return volatile.LoadUint16(&o.FTDRHL.Reg) & 0x1ff
}
func (o *SCI0_Type) SetFTDRHL_MPBT(value uint16) {
	volatile.StoreUint16(&o.FTDRHL.Reg, volatile.LoadUint16(&o.FTDRHL.Reg)&^(0x200)|value<<9)
}
func (o *SCI0_Type) GetFTDRHL_MPBT() uint16 {
	return (volatile.LoadUint16(&o.FTDRHL.Reg) & 0x200) >> 9
}

// SCI0.FRDRHL: Receive FIFO Data Register
func (o *SCI0_Type) SetFRDRHL_RDAT(value uint16) {
	volatile.StoreUint16(&o.FRDRHL.Reg, volatile.LoadUint16(&o.FRDRHL.Reg)&^(0x1ff)|value)
}
func (o *SCI0_Type) GetFRDRHL_RDAT() uint16 {
	return volatile.LoadUint16(&o.FRDRHL.Reg) & 0x1ff
}
func (o *SCI0_Type) SetFRDRHL_MPB(value uint16) {
	volatile.StoreUint16(&o.FRDRHL.Reg, volatile.LoadUint16(&o.FRDRHL.Reg)&^(0x200)|value<<9)
}
func (o *SCI0_Type) GetFRDRHL_MPB() uint16 {
	return (volatile.LoadUint16(&o.FRDRHL.Reg) & 0x200) >> 9
}
func (o *SCI0_Type) SetFRDRHL_DR(value uint16) {
	volatile.StoreUint16(&o.FRDRHL.Reg, volatile.LoadUint16(&o.FRDRHL.Reg)&^(0x400)|value<<10)
}
func (o *SCI0_Type) GetFRDRHL_DR() uint16 {
	return (volatile.LoadUint16(&o.FRDRHL.Reg) & 0x400) >> 10
}
func (o *SCI0_Type) SetFRDRHL_PER(value uint16) {
	volatile.StoreUint16(&o.FRDRHL.Reg, volatile.LoadUint16(&o.FRDRHL.Reg)&^(0x800)|value<<11)
}
func (o *SCI0_Type) GetFRDRHL_PER() uint16 {
	return (volatile.LoadUint16(&o.FRDRHL.Reg) & 0x800) >> 11
}
func (o *SCI0_Type) SetFRDRHL_FER(value uint16) {
	volatile.StoreUint16(&o.FRDRHL.Reg, volatile.LoadUint16(&o.FRDRHL.Reg)&^(0x1000)|value<<12)
}
func (o *SCI0_Type) GetFRDRHL_FER() uint16 {
	return (volatile.LoadUint16(&o.FRDRHL.Reg) & 0x1000) >> 12
}
func (o *SCI0_Type) SetFRDRHL_ORER(value uint16) {
	volatile.StoreUint16(&o.FRDRHL.Reg, volatile.LoadUint16(&o.FRDRHL.Reg)&^(0x2000)|value<<13)
}
func (o *SCI0_Type) GetFRDRHL_ORER() uint16 {
	return (volatile.LoadUint16(&o.FRDRHL.Reg) & 0x2000) >> 13
}
func (o *SCI0_Type) SetFRDRHL_RDF(value uint16) {
	volatile.StoreUint16(&o.FRDRHL.Reg, volatile.LoadUint16(&o.FRDRHL.Reg)&^(0x4000)|value<<14)
}
func (o *SCI0_Type) GetFRDRHL_RDF() uint16 {
	return (volatile.LoadUint16(&o.FRDRHL.Reg) & 0x4000) >> 14
}

// SCI0.DCCR: Data Compare Match Control Register
func (o *SCI0_Type) SetDCCR_DCMF(value uint8) {
	volatile.StoreUint8(&o.DCCR.Reg, volatile.LoadUint8(&o.DCCR.Reg)&^(0x1)|value)
}
func (o *SCI0_Type) GetDCCR_DCMF() uint8 {
	return volatile.LoadUint8(&o.DCCR.Reg) & 0x1
}
func (o *SCI0_Type) SetDCCR_DPER(value uint8) {
	volatile.StoreUint8(&o.DCCR.Reg, volatile.LoadUint8(&o.DCCR.Reg)&^(0x8)|value<<3)
}
func (o *SCI0_Type) GetDCCR_DPER() uint8 {
	return (volatile.LoadUint8(&o.DCCR.Reg) & 0x8) >> 3
}
func (o *SCI0_Type) SetDCCR_DFER(value uint8) {
	volatile.StoreUint8(&o.DCCR.Reg, volatile.LoadUint8(&o.DCCR.Reg)&^(0x10)|value<<4)
}
func (o *SCI0_Type) GetDCCR_DFER() uint8 {
	return (volatile.LoadUint8(&o.DCCR.Reg) & 0x10) >> 4
}
func (o *SCI0_Type) SetDCCR_IDSEL(value uint8) {
	volatile.StoreUint8(&o.DCCR.Reg, volatile.LoadUint8(&o.DCCR.Reg)&^(0x40)|value<<6)
}
func (o *SCI0_Type) GetDCCR_IDSEL() uint8 {
	return (volatile.LoadUint8(&o.DCCR.Reg) & 0x40) >> 6
}
func (o *SCI0_Type) SetDCCR_DCME(value uint8) {
	volatile.StoreUint8(&o.DCCR.Reg, volatile.LoadUint8(&o.DCCR.Reg)&^(0x80)|value<<7)
}
func (o *SCI0_Type) GetDCCR_DCME() uint8 {
	return (volatile.LoadUint8(&o.DCCR.Reg) & 0x80) >> 7
}

// SCI0.FCR: FIFO Control Register
func (o *SCI0_Type) SetFCR_FM(value uint16) {
	volatile.StoreUint16(&o.FCR.Reg, volatile.LoadUint16(&o.FCR.Reg)&^(0x1)|value)
}
func (o *SCI0_Type) GetFCR_FM() uint16 {
	return volatile.LoadUint16(&o.FCR.Reg) & 0x1
}
func (o *SCI0_Type) SetFCR_RFRST(value uint16) {
	volatile.StoreUint16(&o.FCR.Reg, volatile.LoadUint16(&o.FCR.Reg)&^(0x2)|value<<1)
}
func (o *SCI0_Type) GetFCR_RFRST() uint16 {
	return (volatile.LoadUint16(&o.FCR.Reg) & 0x2) >> 1
}
func (o *SCI0_Type) SetFCR_TFRST(value uint16) {
	volatile.StoreUint16(&o.FCR.Reg, volatile.LoadUint16(&o.FCR.Reg)&^(0x4)|value<<2)
}
func (o *SCI0_Type) GetFCR_TFRST() uint16 {
	return (volatile.LoadUint16(&o.FCR.Reg) & 0x4) >> 2
}
func (o *SCI0_Type) SetFCR_DRES(value uint16) {
	volatile.StoreUint16(&o.FCR.Reg, volatile.LoadUint16(&o.FCR.Reg)&^(0x8)|value<<3)
}
func (o *SCI0_Type) GetFCR_DRES() uint16 {
	return (volatile.LoadUint16(&o.FCR.Reg) & 0x8) >> 3
}
func (o *SCI0_Type) SetFCR_TTRG(value uint16) {
	volatile.StoreUint16(&o.FCR.Reg, volatile.LoadUint16(&o.FCR.Reg)&^(0xf0)|value<<4)
}
func (o *SCI0_Type) GetFCR_TTRG() uint16 {
	return (volatile.LoadUint16(&o.FCR.Reg) & 0xf0) >> 4
}
func (o *SCI0_Type) SetFCR_RTRG(value uint16) {
	volatile.StoreUint16(&o.FCR.Reg, volatile.LoadUint16(&o.FCR.Reg)&^(0xf00)|value<<8)
}
func (o *SCI0_Type) GetFCR_RTRG() uint16 {
	return (volatile.LoadUint16(&o.FCR.Reg) & 0xf00) >> 8
}
func (o *SCI0_Type) SetFCR_RSTRG(value uint16) {
	volatile.StoreUint16(&o.FCR.Reg, volatile.LoadUint16(&o.FCR.Reg)&^(0xf000)|value<<12)
}
func (o *SCI0_Type) GetFCR_RSTRG() uint16 {
	return (volatile.LoadUint16(&o.FCR.Reg) & 0xf000) >> 12
}

// SCI0.FDR: FIFO Data Count Register
func (o *SCI0_Type) SetFDR_R(value uint16) {
	volatile.StoreUint16(&o.FDR.Reg, volatile.LoadUint16(&o.FDR.Reg)&^(0x1f)|value)
}
func (o *SCI0_Type) GetFDR_R() uint16 {
	return volatile.LoadUint16(&o.FDR.Reg) & 0x1f
}
func (o *SCI0_Type) SetFDR_T(value uint16) {
	volatile.StoreUint16(&o.FDR.Reg, volatile.LoadUint16(&o.FDR.Reg)&^(0x1f00)|value<<8)
}
func (o *SCI0_Type) GetFDR_T() uint16 {
	return (volatile.LoadUint16(&o.FDR.Reg) & 0x1f00) >> 8
}

// SCI0.LSR: Line Status Register
func (o *SCI0_Type) SetLSR_ORER(value uint16) {
	volatile.StoreUint16(&o.LSR.Reg, volatile.LoadUint16(&o.LSR.Reg)&^(0x1)|value)
}
func (o *SCI0_Type) GetLSR_ORER() uint16 {
	return volatile.LoadUint16(&o.LSR.Reg) & 0x1
}
func (o *SCI0_Type) SetLSR_FNUM(value uint16) {
	volatile.StoreUint16(&o.LSR.Reg, volatile.LoadUint16(&o.LSR.Reg)&^(0x7c)|value<<2)
}
func (o *SCI0_Type) GetLSR_FNUM() uint16 {
	return (volatile.LoadUint16(&o.LSR.Reg) & 0x7c) >> 2
}
func (o *SCI0_Type) SetLSR_PNUM(value uint16) {
	volatile.StoreUint16(&o.LSR.Reg, volatile.LoadUint16(&o.LSR.Reg)&^(0x1f00)|value<<8)
}
func (o *SCI0_Type) GetLSR_PNUM() uint16 {
	return (volatile.LoadUint16(&o.LSR.Reg) & 0x1f00) >> 8
}

// SCI0.CDR: Compare Match Data Register
func (o *SCI0_Type) SetCDR_CMPD(value uint16) {
	volatile.StoreUint16(&o.CDR.Reg, volatile.LoadUint16(&o.CDR.Reg)&^(0x1ff)|value)
}
func (o *SCI0_Type) GetCDR_CMPD() uint16 {
	return volatile.LoadUint16(&o.CDR.Reg) & 0x1ff
}

// SCI0.SPTR: Serial Port Register
func (o *SCI0_Type) SetSPTR_RXDMON(value uint8) {
	volatile.StoreUint8(&o.SPTR.Reg, volatile.LoadUint8(&o.SPTR.Reg)&^(0x1)|value)
}
func (o *SCI0_Type) GetSPTR_RXDMON() uint8 {
	return volatile.LoadUint8(&o.SPTR.Reg) & 0x1
}
func (o *SCI0_Type) SetSPTR_SPB2DT(value uint8) {
	volatile.StoreUint8(&o.SPTR.Reg, volatile.LoadUint8(&o.SPTR.Reg)&^(0x2)|value<<1)
}
func (o *SCI0_Type) GetSPTR_SPB2DT() uint8 {
	return (volatile.LoadUint8(&o.SPTR.Reg) & 0x2) >> 1
}
func (o *SCI0_Type) SetSPTR_SPB2IO(value uint8) {
	volatile.StoreUint8(&o.SPTR.Reg, volatile.LoadUint8(&o.SPTR.Reg)&^(0x4)|value<<2)
}
func (o *SCI0_Type) GetSPTR_SPB2IO() uint8 {
	return (volatile.LoadUint8(&o.SPTR.Reg) & 0x4) >> 2
}

// Serial Communication Interface 0
type SCI1_Type struct {
	SMR   volatile.Register8  // 0x0
	BRR   volatile.Register8  // 0x1
	SCR   volatile.Register8  // 0x2
	TDR   volatile.Register8  // 0x3
	SSR   volatile.Register8  // 0x4
	RDR   volatile.Register8  // 0x5
	SCMR  volatile.Register8  // 0x6
	SEMR  volatile.Register8  // 0x7
	SNFR  volatile.Register8  // 0x8
	SIMR1 volatile.Register8  // 0x9
	SIMR2 volatile.Register8  // 0xA
	SIMR3 volatile.Register8  // 0xB
	SISR  volatile.Register8  // 0xC
	SPMR  volatile.Register8  // 0xD
	TDRHL volatile.Register16 // 0xE
	RDRHL volatile.Register16 // 0x10
	MDDR  volatile.Register8  // 0x12
}

// SCI1.SMR: Serial Mode Register for Non-Smart Card Interface Mode (SCMR.SMIF = 0)
func (o *SCI1_Type) SetSMR_CKS(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x3)|value)
}
func (o *SCI1_Type) GetSMR_CKS() uint8 {
	return volatile.LoadUint8(&o.SMR.Reg) & 0x3
}
func (o *SCI1_Type) SetSMR_MP(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x4)|value<<2)
}
func (o *SCI1_Type) GetSMR_MP() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x4) >> 2
}
func (o *SCI1_Type) SetSMR_STOP(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x8)|value<<3)
}
func (o *SCI1_Type) GetSMR_STOP() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x8) >> 3
}
func (o *SCI1_Type) SetSMR_PM(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x10)|value<<4)
}
func (o *SCI1_Type) GetSMR_PM() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x10) >> 4
}
func (o *SCI1_Type) SetSMR_PE(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x20)|value<<5)
}
func (o *SCI1_Type) GetSMR_PE() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x20) >> 5
}
func (o *SCI1_Type) SetSMR_CHR(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x40)|value<<6)
}
func (o *SCI1_Type) GetSMR_CHR() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x40) >> 6
}
func (o *SCI1_Type) SetSMR_CM(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x80)|value<<7)
}
func (o *SCI1_Type) GetSMR_CM() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x80) >> 7
}

// SCI1.SCR: Serial Control Register for Non-Smart Card Interface Mode (SCMR.SMIF = 0)
func (o *SCI1_Type) SetSCR_CKE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x3)|value)
}
func (o *SCI1_Type) GetSCR_CKE() uint8 {
	return volatile.LoadUint8(&o.SCR.Reg) & 0x3
}
func (o *SCI1_Type) SetSCR_TEIE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *SCI1_Type) GetSCR_TEIE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x4) >> 2
}
func (o *SCI1_Type) SetSCR_MPIE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *SCI1_Type) GetSCR_MPIE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x8) >> 3
}
func (o *SCI1_Type) SetSCR_RE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *SCI1_Type) GetSCR_RE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x10) >> 4
}
func (o *SCI1_Type) SetSCR_TE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x20)|value<<5)
}
func (o *SCI1_Type) GetSCR_TE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x20) >> 5
}
func (o *SCI1_Type) SetSCR_RIE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x40)|value<<6)
}
func (o *SCI1_Type) GetSCR_RIE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x40) >> 6
}
func (o *SCI1_Type) SetSCR_TIE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x80)|value<<7)
}
func (o *SCI1_Type) GetSCR_TIE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x80) >> 7
}

// SCI1.SSR: Serial Status Register for Non-Smart Card Interface and Non-FIFO Mode (SCMR.SMIF = 0, FCR.FM = 0)
func (o *SCI1_Type) SetSSR_MPBT(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x1)|value)
}
func (o *SCI1_Type) GetSSR_MPBT() uint8 {
	return volatile.LoadUint8(&o.SSR.Reg) & 0x1
}
func (o *SCI1_Type) SetSSR_MPB(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x2)|value<<1)
}
func (o *SCI1_Type) GetSSR_MPB() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x2) >> 1
}
func (o *SCI1_Type) SetSSR_TEND(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x4)|value<<2)
}
func (o *SCI1_Type) GetSSR_TEND() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x4) >> 2
}
func (o *SCI1_Type) SetSSR_PER(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x8)|value<<3)
}
func (o *SCI1_Type) GetSSR_PER() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x8) >> 3
}
func (o *SCI1_Type) SetSSR_FER(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x10)|value<<4)
}
func (o *SCI1_Type) GetSSR_FER() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x10) >> 4
}
func (o *SCI1_Type) SetSSR_ORER(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x20)|value<<5)
}
func (o *SCI1_Type) GetSSR_ORER() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x20) >> 5
}
func (o *SCI1_Type) SetSSR_RDRF(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x40)|value<<6)
}
func (o *SCI1_Type) GetSSR_RDRF() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x40) >> 6
}
func (o *SCI1_Type) SetSSR_TDRE(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x80)|value<<7)
}
func (o *SCI1_Type) GetSSR_TDRE() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x80) >> 7
}

// SCI1.SCMR: Smart Card Mode Register
func (o *SCI1_Type) SetSCMR_SMIF(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x1)|value)
}
func (o *SCI1_Type) GetSCMR_SMIF() uint8 {
	return volatile.LoadUint8(&o.SCMR.Reg) & 0x1
}
func (o *SCI1_Type) SetSCMR_SINV(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x4)|value<<2)
}
func (o *SCI1_Type) GetSCMR_SINV() uint8 {
	return (volatile.LoadUint8(&o.SCMR.Reg) & 0x4) >> 2
}
func (o *SCI1_Type) SetSCMR_SDIR(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x8)|value<<3)
}
func (o *SCI1_Type) GetSCMR_SDIR() uint8 {
	return (volatile.LoadUint8(&o.SCMR.Reg) & 0x8) >> 3
}
func (o *SCI1_Type) SetSCMR_CHR1(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x10)|value<<4)
}
func (o *SCI1_Type) GetSCMR_CHR1() uint8 {
	return (volatile.LoadUint8(&o.SCMR.Reg) & 0x10) >> 4
}
func (o *SCI1_Type) SetSCMR_BCP2(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x80)|value<<7)
}
func (o *SCI1_Type) GetSCMR_BCP2() uint8 {
	return (volatile.LoadUint8(&o.SCMR.Reg) & 0x80) >> 7
}

// SCI1.SEMR: Serial Extended Mode Register
func (o *SCI1_Type) SetSEMR_BRME(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x4)|value<<2)
}
func (o *SCI1_Type) GetSEMR_BRME() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x4) >> 2
}
func (o *SCI1_Type) SetSEMR_ABCSE(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x8)|value<<3)
}
func (o *SCI1_Type) GetSEMR_ABCSE() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x8) >> 3
}
func (o *SCI1_Type) SetSEMR_ABCS(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x10)|value<<4)
}
func (o *SCI1_Type) GetSEMR_ABCS() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x10) >> 4
}
func (o *SCI1_Type) SetSEMR_NFEN(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x20)|value<<5)
}
func (o *SCI1_Type) GetSEMR_NFEN() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x20) >> 5
}
func (o *SCI1_Type) SetSEMR_BGDM(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x40)|value<<6)
}
func (o *SCI1_Type) GetSEMR_BGDM() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x40) >> 6
}
func (o *SCI1_Type) SetSEMR_RXDESEL(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x80)|value<<7)
}
func (o *SCI1_Type) GetSEMR_RXDESEL() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x80) >> 7
}

// SCI1.SNFR: Noise Filter Setting Register
func (o *SCI1_Type) SetSNFR_NFCS(value uint8) {
	volatile.StoreUint8(&o.SNFR.Reg, volatile.LoadUint8(&o.SNFR.Reg)&^(0x7)|value)
}
func (o *SCI1_Type) GetSNFR_NFCS() uint8 {
	return volatile.LoadUint8(&o.SNFR.Reg) & 0x7
}

// SCI1.SIMR1: IIC Mode Register 1
func (o *SCI1_Type) SetSIMR1_IICM(value uint8) {
	volatile.StoreUint8(&o.SIMR1.Reg, volatile.LoadUint8(&o.SIMR1.Reg)&^(0x1)|value)
}
func (o *SCI1_Type) GetSIMR1_IICM() uint8 {
	return volatile.LoadUint8(&o.SIMR1.Reg) & 0x1
}
func (o *SCI1_Type) SetSIMR1_IICDL(value uint8) {
	volatile.StoreUint8(&o.SIMR1.Reg, volatile.LoadUint8(&o.SIMR1.Reg)&^(0xf8)|value<<3)
}
func (o *SCI1_Type) GetSIMR1_IICDL() uint8 {
	return (volatile.LoadUint8(&o.SIMR1.Reg) & 0xf8) >> 3
}

// SCI1.SIMR2: IIC Mode Register 2
func (o *SCI1_Type) SetSIMR2_IICINTM(value uint8) {
	volatile.StoreUint8(&o.SIMR2.Reg, volatile.LoadUint8(&o.SIMR2.Reg)&^(0x1)|value)
}
func (o *SCI1_Type) GetSIMR2_IICINTM() uint8 {
	return volatile.LoadUint8(&o.SIMR2.Reg) & 0x1
}
func (o *SCI1_Type) SetSIMR2_IICCSC(value uint8) {
	volatile.StoreUint8(&o.SIMR2.Reg, volatile.LoadUint8(&o.SIMR2.Reg)&^(0x2)|value<<1)
}
func (o *SCI1_Type) GetSIMR2_IICCSC() uint8 {
	return (volatile.LoadUint8(&o.SIMR2.Reg) & 0x2) >> 1
}
func (o *SCI1_Type) SetSIMR2_IICACKT(value uint8) {
	volatile.StoreUint8(&o.SIMR2.Reg, volatile.LoadUint8(&o.SIMR2.Reg)&^(0x20)|value<<5)
}
func (o *SCI1_Type) GetSIMR2_IICACKT() uint8 {
	return (volatile.LoadUint8(&o.SIMR2.Reg) & 0x20) >> 5
}

// SCI1.SIMR3: IIC Mode Register 3
func (o *SCI1_Type) SetSIMR3_IICSTAREQ(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x1)|value)
}
func (o *SCI1_Type) GetSIMR3_IICSTAREQ() uint8 {
	return volatile.LoadUint8(&o.SIMR3.Reg) & 0x1
}
func (o *SCI1_Type) SetSIMR3_IICRSTAREQ(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x2)|value<<1)
}
func (o *SCI1_Type) GetSIMR3_IICRSTAREQ() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0x2) >> 1
}
func (o *SCI1_Type) SetSIMR3_IICSTPREQ(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x4)|value<<2)
}
func (o *SCI1_Type) GetSIMR3_IICSTPREQ() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0x4) >> 2
}
func (o *SCI1_Type) SetSIMR3_IICSTIF(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x8)|value<<3)
}
func (o *SCI1_Type) GetSIMR3_IICSTIF() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0x8) >> 3
}
func (o *SCI1_Type) SetSIMR3_IICSDAS(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x30)|value<<4)
}
func (o *SCI1_Type) GetSIMR3_IICSDAS() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0x30) >> 4
}
func (o *SCI1_Type) SetSIMR3_IICSCLS(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0xc0)|value<<6)
}
func (o *SCI1_Type) GetSIMR3_IICSCLS() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0xc0) >> 6
}

// SCI1.SISR: IIC Status Register
func (o *SCI1_Type) SetSISR_IICACKR(value uint8) {
	volatile.StoreUint8(&o.SISR.Reg, volatile.LoadUint8(&o.SISR.Reg)&^(0x1)|value)
}
func (o *SCI1_Type) GetSISR_IICACKR() uint8 {
	return volatile.LoadUint8(&o.SISR.Reg) & 0x1
}

// SCI1.SPMR: SPI Mode Register
func (o *SCI1_Type) SetSPMR_SSE(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x1)|value)
}
func (o *SCI1_Type) GetSPMR_SSE() uint8 {
	return volatile.LoadUint8(&o.SPMR.Reg) & 0x1
}
func (o *SCI1_Type) SetSPMR_CTSE(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x2)|value<<1)
}
func (o *SCI1_Type) GetSPMR_CTSE() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x2) >> 1
}
func (o *SCI1_Type) SetSPMR_MSS(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x4)|value<<2)
}
func (o *SCI1_Type) GetSPMR_MSS() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x4) >> 2
}
func (o *SCI1_Type) SetSPMR_MFF(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x10)|value<<4)
}
func (o *SCI1_Type) GetSPMR_MFF() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x10) >> 4
}
func (o *SCI1_Type) SetSPMR_CKPOL(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x40)|value<<6)
}
func (o *SCI1_Type) GetSPMR_CKPOL() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x40) >> 6
}
func (o *SCI1_Type) SetSPMR_CKPH(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x80)|value<<7)
}
func (o *SCI1_Type) GetSPMR_CKPH() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x80) >> 7
}

// SCI1.TDRHL: Transmit Data Register
func (o *SCI1_Type) SetTDRHL_TDAT(value uint16) {
	volatile.StoreUint16(&o.TDRHL.Reg, volatile.LoadUint16(&o.TDRHL.Reg)&^(0x1ff)|value)
}
func (o *SCI1_Type) GetTDRHL_TDAT() uint16 {
	return volatile.LoadUint16(&o.TDRHL.Reg) & 0x1ff
}

// SCI1.RDRHL: Receive Data Register
func (o *SCI1_Type) SetRDRHL_RDAT(value uint16) {
	volatile.StoreUint16(&o.RDRHL.Reg, volatile.LoadUint16(&o.RDRHL.Reg)&^(0x1ff)|value)
}
func (o *SCI1_Type) GetRDRHL_RDAT() uint16 {
	return volatile.LoadUint16(&o.RDRHL.Reg) & 0x1ff
}

// Serial Peripheral Interface
type SPI0_Type struct {
	SPCR   volatile.Register8  // 0x0
	SSLP   volatile.Register8  // 0x1
	SPPCR  volatile.Register8  // 0x2
	SPSR   volatile.Register8  // 0x3
	SPDR   volatile.Register32 // 0x4
	_      [2]byte
	SPBR   volatile.Register8  // 0xA
	SPDCR  volatile.Register8  // 0xB
	SPCKD  volatile.Register8  // 0xC
	SSLND  volatile.Register8  // 0xD
	SPND   volatile.Register8  // 0xE
	SPCR2  volatile.Register8  // 0xF
	SPCMD0 volatile.Register16 // 0x10
}

// SPI0.SPCR: SPI Control Register
func (o *SPI0_Type) SetSPCR_SPMS(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSPCR_SPMS() uint8 {
	return volatile.LoadUint8(&o.SPCR.Reg) & 0x1
}
func (o *SPI0_Type) SetSPCR_TXMD(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSPCR_TXMD() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSPCR_MODFEN(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetSPCR_MODFEN() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetSPCR_MSTR(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetSPCR_MSTR() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetSPCR_SPEIE(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetSPCR_SPEIE() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetSPCR_SPTIE(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetSPCR_SPTIE() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x20) >> 5
}
func (o *SPI0_Type) SetSPCR_SPE(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x40)|value<<6)
}
func (o *SPI0_Type) GetSPCR_SPE() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x40) >> 6
}
func (o *SPI0_Type) SetSPCR_SPRIE(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x80)|value<<7)
}
func (o *SPI0_Type) GetSPCR_SPRIE() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x80) >> 7
}

// SPI0.SSLP: SPI Slave Select Polarity Register
func (o *SPI0_Type) SetSSLP_SSL0P(value uint8) {
	volatile.StoreUint8(&o.SSLP.Reg, volatile.LoadUint8(&o.SSLP.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSSLP_SSL0P() uint8 {
	return volatile.LoadUint8(&o.SSLP.Reg) & 0x1
}
func (o *SPI0_Type) SetSSLP_SSL1P(value uint8) {
	volatile.StoreUint8(&o.SSLP.Reg, volatile.LoadUint8(&o.SSLP.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSSLP_SSL1P() uint8 {
	return (volatile.LoadUint8(&o.SSLP.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSSLP_SSL2P(value uint8) {
	volatile.StoreUint8(&o.SSLP.Reg, volatile.LoadUint8(&o.SSLP.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetSSLP_SSL2P() uint8 {
	return (volatile.LoadUint8(&o.SSLP.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetSSLP_SSL3P(value uint8) {
	volatile.StoreUint8(&o.SSLP.Reg, volatile.LoadUint8(&o.SSLP.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetSSLP_SSL3P() uint8 {
	return (volatile.LoadUint8(&o.SSLP.Reg) & 0x8) >> 3
}

// SPI0.SPPCR: SPI Pin Control Register
func (o *SPI0_Type) SetSPPCR_SPLP(value uint8) {
	volatile.StoreUint8(&o.SPPCR.Reg, volatile.LoadUint8(&o.SPPCR.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSPPCR_SPLP() uint8 {
	return volatile.LoadUint8(&o.SPPCR.Reg) & 0x1
}
func (o *SPI0_Type) SetSPPCR_SPLP2(value uint8) {
	volatile.StoreUint8(&o.SPPCR.Reg, volatile.LoadUint8(&o.SPPCR.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSPPCR_SPLP2() uint8 {
	return (volatile.LoadUint8(&o.SPPCR.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSPPCR_MOIFV(value uint8) {
	volatile.StoreUint8(&o.SPPCR.Reg, volatile.LoadUint8(&o.SPPCR.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetSPPCR_MOIFV() uint8 {
	return (volatile.LoadUint8(&o.SPPCR.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetSPPCR_MOIFE(value uint8) {
	volatile.StoreUint8(&o.SPPCR.Reg, volatile.LoadUint8(&o.SPPCR.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetSPPCR_MOIFE() uint8 {
	return (volatile.LoadUint8(&o.SPPCR.Reg) & 0x20) >> 5
}

// SPI0.SPSR: SPI Status Register
func (o *SPI0_Type) SetSPSR_OVRF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSPSR_OVRF() uint8 {
	return volatile.LoadUint8(&o.SPSR.Reg) & 0x1
}
func (o *SPI0_Type) SetSPSR_IDLNF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSPSR_IDLNF() uint8 {
	return (volatile.LoadUint8(&o.SPSR.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSPSR_MODF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetSPSR_MODF() uint8 {
	return (volatile.LoadUint8(&o.SPSR.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetSPSR_PERF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetSPSR_PERF() uint8 {
	return (volatile.LoadUint8(&o.SPSR.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetSPSR_UDRF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetSPSR_UDRF() uint8 {
	return (volatile.LoadUint8(&o.SPSR.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetSPSR_SPTEF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetSPSR_SPTEF() uint8 {
	return (volatile.LoadUint8(&o.SPSR.Reg) & 0x20) >> 5
}
func (o *SPI0_Type) SetSPSR_SPRF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x80)|value<<7)
}
func (o *SPI0_Type) GetSPSR_SPRF() uint8 {
	return (volatile.LoadUint8(&o.SPSR.Reg) & 0x80) >> 7
}

// SPI0.SPDCR: SPI Data Control Register
func (o *SPI0_Type) SetSPDCR_SPRDTD(value uint8) {
	volatile.StoreUint8(&o.SPDCR.Reg, volatile.LoadUint8(&o.SPDCR.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetSPDCR_SPRDTD() uint8 {
	return (volatile.LoadUint8(&o.SPDCR.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetSPDCR_SPLW(value uint8) {
	volatile.StoreUint8(&o.SPDCR.Reg, volatile.LoadUint8(&o.SPDCR.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetSPDCR_SPLW() uint8 {
	return (volatile.LoadUint8(&o.SPDCR.Reg) & 0x20) >> 5
}
func (o *SPI0_Type) SetSPDCR_SPBYT(value uint8) {
	volatile.StoreUint8(&o.SPDCR.Reg, volatile.LoadUint8(&o.SPDCR.Reg)&^(0x40)|value<<6)
}
func (o *SPI0_Type) GetSPDCR_SPBYT() uint8 {
	return (volatile.LoadUint8(&o.SPDCR.Reg) & 0x40) >> 6
}

// SPI0.SPCKD: SPI Clock Delay Register
func (o *SPI0_Type) SetSPCKD_SCKDL(value uint8) {
	volatile.StoreUint8(&o.SPCKD.Reg, volatile.LoadUint8(&o.SPCKD.Reg)&^(0x7)|value)
}
func (o *SPI0_Type) GetSPCKD_SCKDL() uint8 {
	return volatile.LoadUint8(&o.SPCKD.Reg) & 0x7
}

// SPI0.SSLND: SPI Slave Select Negation Delay Register
func (o *SPI0_Type) SetSSLND_SLNDL(value uint8) {
	volatile.StoreUint8(&o.SSLND.Reg, volatile.LoadUint8(&o.SSLND.Reg)&^(0x7)|value)
}
func (o *SPI0_Type) GetSSLND_SLNDL() uint8 {
	return volatile.LoadUint8(&o.SSLND.Reg) & 0x7
}

// SPI0.SPND: SPI Next-Access Delay Register
func (o *SPI0_Type) SetSPND_SPNDL(value uint8) {
	volatile.StoreUint8(&o.SPND.Reg, volatile.LoadUint8(&o.SPND.Reg)&^(0x7)|value)
}
func (o *SPI0_Type) GetSPND_SPNDL() uint8 {
	return volatile.LoadUint8(&o.SPND.Reg) & 0x7
}

// SPI0.SPCR2: SPI Control Register 2
func (o *SPI0_Type) SetSPCR2_SPPE(value uint8) {
	volatile.StoreUint8(&o.SPCR2.Reg, volatile.LoadUint8(&o.SPCR2.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSPCR2_SPPE() uint8 {
	return volatile.LoadUint8(&o.SPCR2.Reg) & 0x1
}
func (o *SPI0_Type) SetSPCR2_SPOE(value uint8) {
	volatile.StoreUint8(&o.SPCR2.Reg, volatile.LoadUint8(&o.SPCR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSPCR2_SPOE() uint8 {
	return (volatile.LoadUint8(&o.SPCR2.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSPCR2_SPIIE(value uint8) {
	volatile.StoreUint8(&o.SPCR2.Reg, volatile.LoadUint8(&o.SPCR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetSPCR2_SPIIE() uint8 {
	return (volatile.LoadUint8(&o.SPCR2.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetSPCR2_PTE(value uint8) {
	volatile.StoreUint8(&o.SPCR2.Reg, volatile.LoadUint8(&o.SPCR2.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetSPCR2_PTE() uint8 {
	return (volatile.LoadUint8(&o.SPCR2.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetSPCR2_SCKASE(value uint8) {
	volatile.StoreUint8(&o.SPCR2.Reg, volatile.LoadUint8(&o.SPCR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetSPCR2_SCKASE() uint8 {
	return (volatile.LoadUint8(&o.SPCR2.Reg) & 0x10) >> 4
}

// SPI0.SPCMD0: SPI Command Register 0
func (o *SPI0_Type) SetSPCMD0_CPHA(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSPCMD0_CPHA() uint16 {
	return volatile.LoadUint16(&o.SPCMD0.Reg) & 0x1
}
func (o *SPI0_Type) SetSPCMD0_CPOL(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSPCMD0_CPOL() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSPCMD0_BRDV(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0xc)|value<<2)
}
func (o *SPI0_Type) GetSPCMD0_BRDV() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0xc) >> 2
}
func (o *SPI0_Type) SetSPCMD0_SSLA(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0x70)|value<<4)
}
func (o *SPI0_Type) GetSPCMD0_SSLA() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0x70) >> 4
}
func (o *SPI0_Type) SetSPCMD0_SPB(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0xf00)|value<<8)
}
func (o *SPI0_Type) GetSPCMD0_SPB() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0xf00) >> 8
}
func (o *SPI0_Type) SetSPCMD0_LSBF(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0x1000)|value<<12)
}
func (o *SPI0_Type) GetSPCMD0_LSBF() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0x1000) >> 12
}
func (o *SPI0_Type) SetSPCMD0_SPNDEN(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0x2000)|value<<13)
}
func (o *SPI0_Type) GetSPCMD0_SPNDEN() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0x2000) >> 13
}
func (o *SPI0_Type) SetSPCMD0_SLNDEN(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0x4000)|value<<14)
}
func (o *SPI0_Type) GetSPCMD0_SLNDEN() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0x4000) >> 14
}
func (o *SPI0_Type) SetSPCMD0_SCKDEN(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0x8000)|value<<15)
}
func (o *SPI0_Type) GetSPCMD0_SCKDEN() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0x8000) >> 15
}

// Cyclic Redundancy Check Calculator
type CRC_Type struct {
	CRCCR0 volatile.Register8 // 0x0
	CRCCR1 volatile.Register8 // 0x1
	_      [2]byte
	CRCDIR volatile.Register32 // 0x4
	CRCDOR volatile.Register32 // 0x8
	CRCSAR volatile.Register16 // 0xC
}

// CRC.CRCCR0: CRC Control Register 0
func (o *CRC_Type) SetCRCCR0_GPS(value uint8) {
	volatile.StoreUint8(&o.CRCCR0.Reg, volatile.LoadUint8(&o.CRCCR0.Reg)&^(0x7)|value)
}
func (o *CRC_Type) GetCRCCR0_GPS() uint8 {
	return volatile.LoadUint8(&o.CRCCR0.Reg) & 0x7
}
func (o *CRC_Type) SetCRCCR0_LMS(value uint8) {
	volatile.StoreUint8(&o.CRCCR0.Reg, volatile.LoadUint8(&o.CRCCR0.Reg)&^(0x40)|value<<6)
}
func (o *CRC_Type) GetCRCCR0_LMS() uint8 {
	return (volatile.LoadUint8(&o.CRCCR0.Reg) & 0x40) >> 6
}
func (o *CRC_Type) SetCRCCR0_DORCLR(value uint8) {
	volatile.StoreUint8(&o.CRCCR0.Reg, volatile.LoadUint8(&o.CRCCR0.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCRCCR0_DORCLR() uint8 {
	return (volatile.LoadUint8(&o.CRCCR0.Reg) & 0x80) >> 7
}

// CRC.CRCCR1: CRC Control Register 1
func (o *CRC_Type) SetCRCCR1_CRCSWR(value uint8) {
	volatile.StoreUint8(&o.CRCCR1.Reg, volatile.LoadUint8(&o.CRCCR1.Reg)&^(0x40)|value<<6)
}
func (o *CRC_Type) GetCRCCR1_CRCSWR() uint8 {
	return (volatile.LoadUint8(&o.CRCCR1.Reg) & 0x40) >> 6
}
func (o *CRC_Type) SetCRCCR1_CRCSEN(value uint8) {
	volatile.StoreUint8(&o.CRCCR1.Reg, volatile.LoadUint8(&o.CRCCR1.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCRCCR1_CRCSEN() uint8 {
	return (volatile.LoadUint8(&o.CRCCR1.Reg) & 0x80) >> 7
}

// CRC.CRCSAR: Snoop Address Register
func (o *CRC_Type) SetCRCSAR_CRCSA(value uint16) {
	volatile.StoreUint16(&o.CRCSAR.Reg, volatile.LoadUint16(&o.CRCSAR.Reg)&^(0x3fff)|value)
}
func (o *CRC_Type) GetCRCSAR_CRCSA() uint16 {
	return volatile.LoadUint16(&o.CRCSAR.Reg) & 0x3fff
}

// General PWM 32-bit Timer 0
type GPT320_Type struct {
	GTWP     volatile.Register32 // 0x0
	GTSTR    volatile.Register32 // 0x4
	GTSTP    volatile.Register32 // 0x8
	GTCLR    volatile.Register32 // 0xC
	GTSSR    volatile.Register32 // 0x10
	GTPSR    volatile.Register32 // 0x14
	GTCSR    volatile.Register32 // 0x18
	GTUPSR   volatile.Register32 // 0x1C
	GTDNSR   volatile.Register32 // 0x20
	GTICASR  volatile.Register32 // 0x24
	GTICBSR  volatile.Register32 // 0x28
	GTCR     volatile.Register32 // 0x2C
	GTUDDTYC volatile.Register32 // 0x30
	GTIOR    volatile.Register32 // 0x34
	GTINTAD  volatile.Register32 // 0x38
	GTST     volatile.Register32 // 0x3C
	GTBER    volatile.Register32 // 0x40
	_        [4]byte
	GTCNT    volatile.Register32 // 0x48
	GTCCRA   volatile.Register32 // 0x4C
	GTCCRB   volatile.Register32 // 0x50
	GTCCRC   volatile.Register32 // 0x54
	GTCCRE   volatile.Register32 // 0x58
	GTCCRD   volatile.Register32 // 0x5C
	GTCCRF   volatile.Register32 // 0x60
	GTPR     volatile.Register32 // 0x64
	GTPBR    volatile.Register32 // 0x68
	_        [28]byte
	GTDTCR   volatile.Register32 // 0x88
	GTDVU    volatile.Register32 // 0x8C
}

// GPT320.GTWP: General PWM Timer Write-Protection Register
func (o *GPT320_Type) SetGTWP_WP(value uint32) {
	volatile.StoreUint32(&o.GTWP.Reg, volatile.LoadUint32(&o.GTWP.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTWP_WP() uint32 {
	return volatile.LoadUint32(&o.GTWP.Reg) & 0x1
}
func (o *GPT320_Type) SetGTWP_PRKEY(value uint32) {
	volatile.StoreUint32(&o.GTWP.Reg, volatile.LoadUint32(&o.GTWP.Reg)&^(0xff00)|value<<8)
}
func (o *GPT320_Type) GetGTWP_PRKEY() uint32 {
	return (volatile.LoadUint32(&o.GTWP.Reg) & 0xff00) >> 8
}

// GPT320.GTSTR: General PWM Timer Software Start Register
func (o *GPT320_Type) SetGTSTR_CSTRT0(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTSTR_CSTRT0() uint32 {
	return volatile.LoadUint32(&o.GTSTR.Reg) & 0x1
}
func (o *GPT320_Type) SetGTSTR_CSTRT1(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x2)|value<<1)
}
func (o *GPT320_Type) GetGTSTR_CSTRT1() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x2) >> 1
}
func (o *GPT320_Type) SetGTSTR_CSTRT2(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x4)|value<<2)
}
func (o *GPT320_Type) GetGTSTR_CSTRT2() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x4) >> 2
}
func (o *GPT320_Type) SetGTSTR_CSTRT3(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x8)|value<<3)
}
func (o *GPT320_Type) GetGTSTR_CSTRT3() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x8) >> 3
}
func (o *GPT320_Type) SetGTSTR_CSTRT4(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x10)|value<<4)
}
func (o *GPT320_Type) GetGTSTR_CSTRT4() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x10) >> 4
}
func (o *GPT320_Type) SetGTSTR_CSTRT5(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x20)|value<<5)
}
func (o *GPT320_Type) GetGTSTR_CSTRT5() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x20) >> 5
}
func (o *GPT320_Type) SetGTSTR_CSTRT6(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x40)|value<<6)
}
func (o *GPT320_Type) GetGTSTR_CSTRT6() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x40) >> 6
}
func (o *GPT320_Type) SetGTSTR_CSTRT7(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x80)|value<<7)
}
func (o *GPT320_Type) GetGTSTR_CSTRT7() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x80) >> 7
}
func (o *GPT320_Type) SetGTSTR_CSTRT8(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x100)|value<<8)
}
func (o *GPT320_Type) GetGTSTR_CSTRT8() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x100) >> 8
}
func (o *GPT320_Type) SetGTSTR_CSTRT9(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x200)|value<<9)
}
func (o *GPT320_Type) GetGTSTR_CSTRT9() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x200) >> 9
}

// GPT320.GTSTP: General PWM Timer Software Stop Register
func (o *GPT320_Type) SetGTSTP_CSTOP0(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTSTP_CSTOP0() uint32 {
	return volatile.LoadUint32(&o.GTSTP.Reg) & 0x1
}
func (o *GPT320_Type) SetGTSTP_CSTOP1(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x2)|value<<1)
}
func (o *GPT320_Type) GetGTSTP_CSTOP1() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x2) >> 1
}
func (o *GPT320_Type) SetGTSTP_CSTOP2(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x4)|value<<2)
}
func (o *GPT320_Type) GetGTSTP_CSTOP2() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x4) >> 2
}
func (o *GPT320_Type) SetGTSTP_CSTOP3(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x8)|value<<3)
}
func (o *GPT320_Type) GetGTSTP_CSTOP3() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x8) >> 3
}
func (o *GPT320_Type) SetGTSTP_CSTOP4(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x10)|value<<4)
}
func (o *GPT320_Type) GetGTSTP_CSTOP4() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x10) >> 4
}
func (o *GPT320_Type) SetGTSTP_CSTOP5(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x20)|value<<5)
}
func (o *GPT320_Type) GetGTSTP_CSTOP5() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x20) >> 5
}
func (o *GPT320_Type) SetGTSTP_CSTOP6(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x40)|value<<6)
}
func (o *GPT320_Type) GetGTSTP_CSTOP6() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x40) >> 6
}
func (o *GPT320_Type) SetGTSTP_CSTOP7(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x80)|value<<7)
}
func (o *GPT320_Type) GetGTSTP_CSTOP7() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x80) >> 7
}
func (o *GPT320_Type) SetGTSTP_CSTOP8(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x100)|value<<8)
}
func (o *GPT320_Type) GetGTSTP_CSTOP8() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x100) >> 8
}
func (o *GPT320_Type) SetGTSTP_CSTOP9(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x200)|value<<9)
}
func (o *GPT320_Type) GetGTSTP_CSTOP9() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x200) >> 9
}

// GPT320.GTCLR: General PWM Timer Software Clear Register
func (o *GPT320_Type) SetGTCLR_CCLR0(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTCLR_CCLR0() uint32 {
	return volatile.LoadUint32(&o.GTCLR.Reg) & 0x1
}
func (o *GPT320_Type) SetGTCLR_CCLR1(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPT320_Type) GetGTCLR_CCLR1() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x2) >> 1
}
func (o *GPT320_Type) SetGTCLR_CCLR2(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPT320_Type) GetGTCLR_CCLR2() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x4) >> 2
}
func (o *GPT320_Type) SetGTCLR_CCLR3(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPT320_Type) GetGTCLR_CCLR3() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x8) >> 3
}
func (o *GPT320_Type) SetGTCLR_CCLR4(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPT320_Type) GetGTCLR_CCLR4() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x10) >> 4
}
func (o *GPT320_Type) SetGTCLR_CCLR5(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPT320_Type) GetGTCLR_CCLR5() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x20) >> 5
}
func (o *GPT320_Type) SetGTCLR_CCLR6(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPT320_Type) GetGTCLR_CCLR6() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x40) >> 6
}
func (o *GPT320_Type) SetGTCLR_CCLR7(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPT320_Type) GetGTCLR_CCLR7() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x80) >> 7
}
func (o *GPT320_Type) SetGTCLR_CCLR8(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x100)|value<<8)
}
func (o *GPT320_Type) GetGTCLR_CCLR8() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x100) >> 8
}
func (o *GPT320_Type) SetGTCLR_CCLR9(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x200)|value<<9)
}
func (o *GPT320_Type) GetGTCLR_CCLR9() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x200) >> 9
}

// GPT320.GTSSR: General PWM Timer Start Source Select Register
func (o *GPT320_Type) SetGTSSR_SSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTSSR_SSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTSSR.Reg) & 0x1
}
func (o *GPT320_Type) SetGTSSR_SSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT320_Type) GetGTSSR_SSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x2) >> 1
}
func (o *GPT320_Type) SetGTSSR_SSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT320_Type) GetGTSSR_SSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x4) >> 2
}
func (o *GPT320_Type) SetGTSSR_SSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT320_Type) GetGTSSR_SSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x8) >> 3
}
func (o *GPT320_Type) SetGTSSR_SSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT320_Type) GetGTSSR_SSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x100) >> 8
}
func (o *GPT320_Type) SetGTSSR_SSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT320_Type) GetGTSSR_SSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x200) >> 9
}
func (o *GPT320_Type) SetGTSSR_SSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT320_Type) GetGTSSR_SSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x400) >> 10
}
func (o *GPT320_Type) SetGTSSR_SSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT320_Type) GetGTSSR_SSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x800) >> 11
}
func (o *GPT320_Type) SetGTSSR_SSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT320_Type) GetGTSSR_SSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x1000) >> 12
}
func (o *GPT320_Type) SetGTSSR_SSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT320_Type) GetGTSSR_SSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x2000) >> 13
}
func (o *GPT320_Type) SetGTSSR_SSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT320_Type) GetGTSSR_SSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x4000) >> 14
}
func (o *GPT320_Type) SetGTSSR_SSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT320_Type) GetGTSSR_SSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x8000) >> 15
}
func (o *GPT320_Type) SetGTSSR_SSELCA(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT320_Type) GetGTSSR_SSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x10000) >> 16
}
func (o *GPT320_Type) SetGTSSR_SSELCB(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT320_Type) GetGTSSR_SSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x20000) >> 17
}
func (o *GPT320_Type) SetGTSSR_SSELCC(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT320_Type) GetGTSSR_SSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x40000) >> 18
}
func (o *GPT320_Type) SetGTSSR_SSELCD(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT320_Type) GetGTSSR_SSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x80000) >> 19
}
func (o *GPT320_Type) SetGTSSR_CSTRT(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPT320_Type) GetGTSSR_CSTRT() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x80000000) >> 31
}

// GPT320.GTPSR: General PWM Timer Stop Source Select Register
func (o *GPT320_Type) SetGTPSR_PSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTPSR_PSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTPSR.Reg) & 0x1
}
func (o *GPT320_Type) SetGTPSR_PSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT320_Type) GetGTPSR_PSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x2) >> 1
}
func (o *GPT320_Type) SetGTPSR_PSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT320_Type) GetGTPSR_PSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x4) >> 2
}
func (o *GPT320_Type) SetGTPSR_PSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT320_Type) GetGTPSR_PSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x8) >> 3
}
func (o *GPT320_Type) SetGTPSR_PSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT320_Type) GetGTPSR_PSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x100) >> 8
}
func (o *GPT320_Type) SetGTPSR_PSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT320_Type) GetGTPSR_PSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x200) >> 9
}
func (o *GPT320_Type) SetGTPSR_PSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT320_Type) GetGTPSR_PSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x400) >> 10
}
func (o *GPT320_Type) SetGTPSR_PSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT320_Type) GetGTPSR_PSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x800) >> 11
}
func (o *GPT320_Type) SetGTPSR_PSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT320_Type) GetGTPSR_PSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x1000) >> 12
}
func (o *GPT320_Type) SetGTPSR_PSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT320_Type) GetGTPSR_PSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x2000) >> 13
}
func (o *GPT320_Type) SetGTPSR_PSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT320_Type) GetGTPSR_PSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x4000) >> 14
}
func (o *GPT320_Type) SetGTPSR_PSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT320_Type) GetGTPSR_PSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x8000) >> 15
}
func (o *GPT320_Type) SetGTPSR_PSELCA(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT320_Type) GetGTPSR_PSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x10000) >> 16
}
func (o *GPT320_Type) SetGTPSR_PSELCB(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT320_Type) GetGTPSR_PSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x20000) >> 17
}
func (o *GPT320_Type) SetGTPSR_PSELCC(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT320_Type) GetGTPSR_PSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x40000) >> 18
}
func (o *GPT320_Type) SetGTPSR_PSELCD(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT320_Type) GetGTPSR_PSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x80000) >> 19
}
func (o *GPT320_Type) SetGTPSR_CSTOP(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPT320_Type) GetGTPSR_CSTOP() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x80000000) >> 31
}

// GPT320.GTCSR: General PWM Timer Clear Source Select Register
func (o *GPT320_Type) SetGTCSR_CSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTCSR_CSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTCSR.Reg) & 0x1
}
func (o *GPT320_Type) SetGTCSR_CSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT320_Type) GetGTCSR_CSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x2) >> 1
}
func (o *GPT320_Type) SetGTCSR_CSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT320_Type) GetGTCSR_CSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x4) >> 2
}
func (o *GPT320_Type) SetGTCSR_CSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT320_Type) GetGTCSR_CSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x8) >> 3
}
func (o *GPT320_Type) SetGTCSR_CSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT320_Type) GetGTCSR_CSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x100) >> 8
}
func (o *GPT320_Type) SetGTCSR_CSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT320_Type) GetGTCSR_CSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x200) >> 9
}
func (o *GPT320_Type) SetGTCSR_CSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT320_Type) GetGTCSR_CSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x400) >> 10
}
func (o *GPT320_Type) SetGTCSR_CSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT320_Type) GetGTCSR_CSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x800) >> 11
}
func (o *GPT320_Type) SetGTCSR_CSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT320_Type) GetGTCSR_CSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x1000) >> 12
}
func (o *GPT320_Type) SetGTCSR_CSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT320_Type) GetGTCSR_CSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x2000) >> 13
}
func (o *GPT320_Type) SetGTCSR_CSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT320_Type) GetGTCSR_CSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x4000) >> 14
}
func (o *GPT320_Type) SetGTCSR_CSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT320_Type) GetGTCSR_CSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x8000) >> 15
}
func (o *GPT320_Type) SetGTCSR_CSELCA(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT320_Type) GetGTCSR_CSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x10000) >> 16
}
func (o *GPT320_Type) SetGTCSR_CSELCB(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT320_Type) GetGTCSR_CSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x20000) >> 17
}
func (o *GPT320_Type) SetGTCSR_CSELCC(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT320_Type) GetGTCSR_CSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x40000) >> 18
}
func (o *GPT320_Type) SetGTCSR_CSELCD(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT320_Type) GetGTCSR_CSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x80000) >> 19
}
func (o *GPT320_Type) SetGTCSR_CCLR(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPT320_Type) GetGTCSR_CCLR() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x80000000) >> 31
}

// GPT320.GTUPSR: General PWM Timer Up Count Source Select Register
func (o *GPT320_Type) SetGTUPSR_USGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTUPSR_USGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTUPSR.Reg) & 0x1
}
func (o *GPT320_Type) SetGTUPSR_USGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT320_Type) GetGTUPSR_USGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x2) >> 1
}
func (o *GPT320_Type) SetGTUPSR_USGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT320_Type) GetGTUPSR_USGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x4) >> 2
}
func (o *GPT320_Type) SetGTUPSR_USGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT320_Type) GetGTUPSR_USGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x8) >> 3
}
func (o *GPT320_Type) SetGTUPSR_USCARBL(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT320_Type) GetGTUPSR_USCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x100) >> 8
}
func (o *GPT320_Type) SetGTUPSR_USCARBH(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT320_Type) GetGTUPSR_USCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x200) >> 9
}
func (o *GPT320_Type) SetGTUPSR_USCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT320_Type) GetGTUPSR_USCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x400) >> 10
}
func (o *GPT320_Type) SetGTUPSR_USCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT320_Type) GetGTUPSR_USCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x800) >> 11
}
func (o *GPT320_Type) SetGTUPSR_USCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT320_Type) GetGTUPSR_USCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x1000) >> 12
}
func (o *GPT320_Type) SetGTUPSR_USCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT320_Type) GetGTUPSR_USCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x2000) >> 13
}
func (o *GPT320_Type) SetGTUPSR_USCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT320_Type) GetGTUPSR_USCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x4000) >> 14
}
func (o *GPT320_Type) SetGTUPSR_USCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT320_Type) GetGTUPSR_USCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x8000) >> 15
}
func (o *GPT320_Type) SetGTUPSR_USELCA(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT320_Type) GetGTUPSR_USELCA() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x10000) >> 16
}
func (o *GPT320_Type) SetGTUPSR_USELCB(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT320_Type) GetGTUPSR_USELCB() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x20000) >> 17
}
func (o *GPT320_Type) SetGTUPSR_USELCC(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT320_Type) GetGTUPSR_USELCC() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x40000) >> 18
}
func (o *GPT320_Type) SetGTUPSR_USELCD(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT320_Type) GetGTUPSR_USELCD() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x80000) >> 19
}

// GPT320.GTDNSR: General PWM Timer Down Count Source Select Register
func (o *GPT320_Type) SetGTDNSR_DSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTDNSR_DSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTDNSR.Reg) & 0x1
}
func (o *GPT320_Type) SetGTDNSR_DSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT320_Type) GetGTDNSR_DSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x2) >> 1
}
func (o *GPT320_Type) SetGTDNSR_DSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT320_Type) GetGTDNSR_DSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x4) >> 2
}
func (o *GPT320_Type) SetGTDNSR_DSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT320_Type) GetGTDNSR_DSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x8) >> 3
}
func (o *GPT320_Type) SetGTDNSR_DSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT320_Type) GetGTDNSR_DSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x100) >> 8
}
func (o *GPT320_Type) SetGTDNSR_DSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT320_Type) GetGTDNSR_DSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x200) >> 9
}
func (o *GPT320_Type) SetGTDNSR_DSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT320_Type) GetGTDNSR_DSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x400) >> 10
}
func (o *GPT320_Type) SetGTDNSR_DSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT320_Type) GetGTDNSR_DSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x800) >> 11
}
func (o *GPT320_Type) SetGTDNSR_DSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT320_Type) GetGTDNSR_DSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x1000) >> 12
}
func (o *GPT320_Type) SetGTDNSR_DSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT320_Type) GetGTDNSR_DSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x2000) >> 13
}
func (o *GPT320_Type) SetGTDNSR_DSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT320_Type) GetGTDNSR_DSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x4000) >> 14
}
func (o *GPT320_Type) SetGTDNSR_DSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT320_Type) GetGTDNSR_DSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x8000) >> 15
}
func (o *GPT320_Type) SetGTDNSR_DSELCA(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT320_Type) GetGTDNSR_DSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x10000) >> 16
}
func (o *GPT320_Type) SetGTDNSR_DSELCB(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT320_Type) GetGTDNSR_DSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x20000) >> 17
}
func (o *GPT320_Type) SetGTDNSR_DSELCC(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT320_Type) GetGTDNSR_DSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x40000) >> 18
}
func (o *GPT320_Type) SetGTDNSR_DSELCD(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT320_Type) GetGTDNSR_DSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x80000) >> 19
}

// GPT320.GTICASR: General PWM Timer Input Capture Source Select Register A
func (o *GPT320_Type) SetGTICASR_ASGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTICASR_ASGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTICASR.Reg) & 0x1
}
func (o *GPT320_Type) SetGTICASR_ASGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x2)|value<<1)
}
func (o *GPT320_Type) GetGTICASR_ASGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x2) >> 1
}
func (o *GPT320_Type) SetGTICASR_ASGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x4)|value<<2)
}
func (o *GPT320_Type) GetGTICASR_ASGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x4) >> 2
}
func (o *GPT320_Type) SetGTICASR_ASGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x8)|value<<3)
}
func (o *GPT320_Type) GetGTICASR_ASGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x8) >> 3
}
func (o *GPT320_Type) SetGTICASR_ASCARBL(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x100)|value<<8)
}
func (o *GPT320_Type) GetGTICASR_ASCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x100) >> 8
}
func (o *GPT320_Type) SetGTICASR_ASCARBH(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x200)|value<<9)
}
func (o *GPT320_Type) GetGTICASR_ASCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x200) >> 9
}
func (o *GPT320_Type) SetGTICASR_ASCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x400)|value<<10)
}
func (o *GPT320_Type) GetGTICASR_ASCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x400) >> 10
}
func (o *GPT320_Type) SetGTICASR_ASCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x800)|value<<11)
}
func (o *GPT320_Type) GetGTICASR_ASCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x800) >> 11
}
func (o *GPT320_Type) SetGTICASR_ASCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT320_Type) GetGTICASR_ASCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x1000) >> 12
}
func (o *GPT320_Type) SetGTICASR_ASCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT320_Type) GetGTICASR_ASCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x2000) >> 13
}
func (o *GPT320_Type) SetGTICASR_ASCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT320_Type) GetGTICASR_ASCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x4000) >> 14
}
func (o *GPT320_Type) SetGTICASR_ASCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT320_Type) GetGTICASR_ASCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x8000) >> 15
}
func (o *GPT320_Type) SetGTICASR_ASELCA(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT320_Type) GetGTICASR_ASELCA() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x10000) >> 16
}
func (o *GPT320_Type) SetGTICASR_ASELCB(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT320_Type) GetGTICASR_ASELCB() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x20000) >> 17
}
func (o *GPT320_Type) SetGTICASR_ASELCC(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT320_Type) GetGTICASR_ASELCC() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x40000) >> 18
}
func (o *GPT320_Type) SetGTICASR_ASELCD(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT320_Type) GetGTICASR_ASELCD() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x80000) >> 19
}

// GPT320.GTICBSR: General PWM Timer Input Capture Source Select Register B
func (o *GPT320_Type) SetGTICBSR_BSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTICBSR_BSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTICBSR.Reg) & 0x1
}
func (o *GPT320_Type) SetGTICBSR_BSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT320_Type) GetGTICBSR_BSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x2) >> 1
}
func (o *GPT320_Type) SetGTICBSR_BSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT320_Type) GetGTICBSR_BSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x4) >> 2
}
func (o *GPT320_Type) SetGTICBSR_BSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT320_Type) GetGTICBSR_BSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x8) >> 3
}
func (o *GPT320_Type) SetGTICBSR_BSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT320_Type) GetGTICBSR_BSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x100) >> 8
}
func (o *GPT320_Type) SetGTICBSR_BSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT320_Type) GetGTICBSR_BSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x200) >> 9
}
func (o *GPT320_Type) SetGTICBSR_BSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT320_Type) GetGTICBSR_BSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x400) >> 10
}
func (o *GPT320_Type) SetGTICBSR_BSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT320_Type) GetGTICBSR_BSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x800) >> 11
}
func (o *GPT320_Type) SetGTICBSR_BSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT320_Type) GetGTICBSR_BSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x1000) >> 12
}
func (o *GPT320_Type) SetGTICBSR_BSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT320_Type) GetGTICBSR_BSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x2000) >> 13
}
func (o *GPT320_Type) SetGTICBSR_BSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT320_Type) GetGTICBSR_BSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x4000) >> 14
}
func (o *GPT320_Type) SetGTICBSR_BSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT320_Type) GetGTICBSR_BSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x8000) >> 15
}
func (o *GPT320_Type) SetGTICBSR_BSELCA(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT320_Type) GetGTICBSR_BSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x10000) >> 16
}
func (o *GPT320_Type) SetGTICBSR_BSELCB(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT320_Type) GetGTICBSR_BSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x20000) >> 17
}
func (o *GPT320_Type) SetGTICBSR_BSELCC(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT320_Type) GetGTICBSR_BSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x40000) >> 18
}
func (o *GPT320_Type) SetGTICBSR_BSELCD(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT320_Type) GetGTICBSR_BSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x80000) >> 19
}

// GPT320.GTCR: General PWM Timer Control Register
func (o *GPT320_Type) SetGTCR_CST(value uint32) {
	volatile.StoreUint32(&o.GTCR.Reg, volatile.LoadUint32(&o.GTCR.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTCR_CST() uint32 {
	return volatile.LoadUint32(&o.GTCR.Reg) & 0x1
}
func (o *GPT320_Type) SetGTCR_MD(value uint32) {
	volatile.StoreUint32(&o.GTCR.Reg, volatile.LoadUint32(&o.GTCR.Reg)&^(0x70000)|value<<16)
}
func (o *GPT320_Type) GetGTCR_MD() uint32 {
	return (volatile.LoadUint32(&o.GTCR.Reg) & 0x70000) >> 16
}
func (o *GPT320_Type) SetGTCR_TPCS(value uint32) {
	volatile.StoreUint32(&o.GTCR.Reg, volatile.LoadUint32(&o.GTCR.Reg)&^(0x7000000)|value<<24)
}
func (o *GPT320_Type) GetGTCR_TPCS() uint32 {
	return (volatile.LoadUint32(&o.GTCR.Reg) & 0x7000000) >> 24
}

// GPT320.GTUDDTYC: General PWM Timer Count Direction and Duty Setting Register
func (o *GPT320_Type) SetGTUDDTYC_UD(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTUDDTYC_UD() uint32 {
	return volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x1
}
func (o *GPT320_Type) SetGTUDDTYC_UDF(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x2)|value<<1)
}
func (o *GPT320_Type) GetGTUDDTYC_UDF() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x2) >> 1
}
func (o *GPT320_Type) SetGTUDDTYC_OADTY(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x30000)|value<<16)
}
func (o *GPT320_Type) GetGTUDDTYC_OADTY() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x30000) >> 16
}
func (o *GPT320_Type) SetGTUDDTYC_OADTYF(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x40000)|value<<18)
}
func (o *GPT320_Type) GetGTUDDTYC_OADTYF() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x40000) >> 18
}
func (o *GPT320_Type) SetGTUDDTYC_OADTYR(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x80000)|value<<19)
}
func (o *GPT320_Type) GetGTUDDTYC_OADTYR() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x80000) >> 19
}
func (o *GPT320_Type) SetGTUDDTYC_OBDTY(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x3000000)|value<<24)
}
func (o *GPT320_Type) GetGTUDDTYC_OBDTY() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x3000000) >> 24
}
func (o *GPT320_Type) SetGTUDDTYC_OBDTYF(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x4000000)|value<<26)
}
func (o *GPT320_Type) GetGTUDDTYC_OBDTYF() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x4000000) >> 26
}
func (o *GPT320_Type) SetGTUDDTYC_OBDTYR(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x8000000)|value<<27)
}
func (o *GPT320_Type) GetGTUDDTYC_OBDTYR() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x8000000) >> 27
}

// GPT320.GTIOR: General PWM Timer I/O Control Register
func (o *GPT320_Type) SetGTIOR_GTIOA(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x1f)|value)
}
func (o *GPT320_Type) GetGTIOR_GTIOA() uint32 {
	return volatile.LoadUint32(&o.GTIOR.Reg) & 0x1f
}
func (o *GPT320_Type) SetGTIOR_OADFLT(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x40)|value<<6)
}
func (o *GPT320_Type) GetGTIOR_OADFLT() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x40) >> 6
}
func (o *GPT320_Type) SetGTIOR_OAHLD(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x80)|value<<7)
}
func (o *GPT320_Type) GetGTIOR_OAHLD() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x80) >> 7
}
func (o *GPT320_Type) SetGTIOR_OAE(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x100)|value<<8)
}
func (o *GPT320_Type) GetGTIOR_OAE() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x100) >> 8
}
func (o *GPT320_Type) SetGTIOR_OADF(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x600)|value<<9)
}
func (o *GPT320_Type) GetGTIOR_OADF() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x600) >> 9
}
func (o *GPT320_Type) SetGTIOR_NFAEN(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT320_Type) GetGTIOR_NFAEN() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x2000) >> 13
}
func (o *GPT320_Type) SetGTIOR_NFCSA(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0xc000)|value<<14)
}
func (o *GPT320_Type) GetGTIOR_NFCSA() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0xc000) >> 14
}
func (o *GPT320_Type) SetGTIOR_GTIOB(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x1f0000)|value<<16)
}
func (o *GPT320_Type) GetGTIOR_GTIOB() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x1f0000) >> 16
}
func (o *GPT320_Type) SetGTIOR_OBDFLT(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x400000)|value<<22)
}
func (o *GPT320_Type) GetGTIOR_OBDFLT() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x400000) >> 22
}
func (o *GPT320_Type) SetGTIOR_OBHLD(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x800000)|value<<23)
}
func (o *GPT320_Type) GetGTIOR_OBHLD() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x800000) >> 23
}
func (o *GPT320_Type) SetGTIOR_OBE(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPT320_Type) GetGTIOR_OBE() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x1000000) >> 24
}
func (o *GPT320_Type) SetGTIOR_OBDF(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x6000000)|value<<25)
}
func (o *GPT320_Type) GetGTIOR_OBDF() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x6000000) >> 25
}
func (o *GPT320_Type) SetGTIOR_NFBEN(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPT320_Type) GetGTIOR_NFBEN() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x20000000) >> 29
}
func (o *GPT320_Type) SetGTIOR_NFCSB(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPT320_Type) GetGTIOR_NFCSB() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0xc0000000) >> 30
}

// GPT320.GTINTAD: General PWM Timer Interrupt Output Setting Register
func (o *GPT320_Type) SetGTINTAD_GRP(value uint32) {
	volatile.StoreUint32(&o.GTINTAD.Reg, volatile.LoadUint32(&o.GTINTAD.Reg)&^(0x3000000)|value<<24)
}
func (o *GPT320_Type) GetGTINTAD_GRP() uint32 {
	return (volatile.LoadUint32(&o.GTINTAD.Reg) & 0x3000000) >> 24
}
func (o *GPT320_Type) SetGTINTAD_GRPABH(value uint32) {
	volatile.StoreUint32(&o.GTINTAD.Reg, volatile.LoadUint32(&o.GTINTAD.Reg)&^(0x20000000)|value<<29)
}
func (o *GPT320_Type) GetGTINTAD_GRPABH() uint32 {
	return (volatile.LoadUint32(&o.GTINTAD.Reg) & 0x20000000) >> 29
}
func (o *GPT320_Type) SetGTINTAD_GRPABL(value uint32) {
	volatile.StoreUint32(&o.GTINTAD.Reg, volatile.LoadUint32(&o.GTINTAD.Reg)&^(0x40000000)|value<<30)
}
func (o *GPT320_Type) GetGTINTAD_GRPABL() uint32 {
	return (volatile.LoadUint32(&o.GTINTAD.Reg) & 0x40000000) >> 30
}

// GPT320.GTST: General PWM Timer Status Register
func (o *GPT320_Type) SetGTST_TCFA(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTST_TCFA() uint32 {
	return volatile.LoadUint32(&o.GTST.Reg) & 0x1
}
func (o *GPT320_Type) SetGTST_TCFB(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x2)|value<<1)
}
func (o *GPT320_Type) GetGTST_TCFB() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x2) >> 1
}
func (o *GPT320_Type) SetGTST_TCFC(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x4)|value<<2)
}
func (o *GPT320_Type) GetGTST_TCFC() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x4) >> 2
}
func (o *GPT320_Type) SetGTST_TCFD(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x8)|value<<3)
}
func (o *GPT320_Type) GetGTST_TCFD() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x8) >> 3
}
func (o *GPT320_Type) SetGTST_TCFE(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x10)|value<<4)
}
func (o *GPT320_Type) GetGTST_TCFE() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x10) >> 4
}
func (o *GPT320_Type) SetGTST_TCFF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x20)|value<<5)
}
func (o *GPT320_Type) GetGTST_TCFF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x20) >> 5
}
func (o *GPT320_Type) SetGTST_TCFPO(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x40)|value<<6)
}
func (o *GPT320_Type) GetGTST_TCFPO() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x40) >> 6
}
func (o *GPT320_Type) SetGTST_TCFPU(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x80)|value<<7)
}
func (o *GPT320_Type) GetGTST_TCFPU() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x80) >> 7
}
func (o *GPT320_Type) SetGTST_TUCF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x8000)|value<<15)
}
func (o *GPT320_Type) GetGTST_TUCF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x8000) >> 15
}
func (o *GPT320_Type) SetGTST_ODF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x1000000)|value<<24)
}
func (o *GPT320_Type) GetGTST_ODF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x1000000) >> 24
}
func (o *GPT320_Type) SetGTST_OABHF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x20000000)|value<<29)
}
func (o *GPT320_Type) GetGTST_OABHF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x20000000) >> 29
}
func (o *GPT320_Type) SetGTST_OABLF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x40000000)|value<<30)
}
func (o *GPT320_Type) GetGTST_OABLF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x40000000) >> 30
}

// GPT320.GTBER: General PWM Timer Buffer Enable Register
func (o *GPT320_Type) SetGTBER_BD0(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTBER_BD0() uint32 {
	return volatile.LoadUint32(&o.GTBER.Reg) & 0x1
}
func (o *GPT320_Type) SetGTBER_BD1(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x2)|value<<1)
}
func (o *GPT320_Type) GetGTBER_BD1() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0x2) >> 1
}
func (o *GPT320_Type) SetGTBER_CCRA(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x30000)|value<<16)
}
func (o *GPT320_Type) GetGTBER_CCRA() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0x30000) >> 16
}
func (o *GPT320_Type) SetGTBER_CCRB(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPT320_Type) GetGTBER_CCRB() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0xc0000) >> 18
}
func (o *GPT320_Type) SetGTBER_PR(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x300000)|value<<20)
}
func (o *GPT320_Type) GetGTBER_PR() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0x300000) >> 20
}
func (o *GPT320_Type) SetGTBER_CCRSWT(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x400000)|value<<22)
}
func (o *GPT320_Type) GetGTBER_CCRSWT() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0x400000) >> 22
}

// GPT320.GTDTCR: General PWM Timer Dead Time Control Register
func (o *GPT320_Type) SetGTDTCR_TDE(value uint32) {
	volatile.StoreUint32(&o.GTDTCR.Reg, volatile.LoadUint32(&o.GTDTCR.Reg)&^(0x1)|value)
}
func (o *GPT320_Type) GetGTDTCR_TDE() uint32 {
	return volatile.LoadUint32(&o.GTDTCR.Reg) & 0x1
}

// General PWM 16-bit Timer 4
type GPT164_Type struct {
	GTWP     volatile.Register32 // 0x0
	GTSTR    volatile.Register32 // 0x4
	GTSTP    volatile.Register32 // 0x8
	GTCLR    volatile.Register32 // 0xC
	GTSSR    volatile.Register32 // 0x10
	GTPSR    volatile.Register32 // 0x14
	GTCSR    volatile.Register32 // 0x18
	GTUPSR   volatile.Register32 // 0x1C
	GTDNSR   volatile.Register32 // 0x20
	GTICASR  volatile.Register32 // 0x24
	GTICBSR  volatile.Register32 // 0x28
	GTCR     volatile.Register32 // 0x2C
	GTUDDTYC volatile.Register32 // 0x30
	GTIOR    volatile.Register32 // 0x34
	GTINTAD  volatile.Register32 // 0x38
	GTST     volatile.Register32 // 0x3C
	GTBER    volatile.Register32 // 0x40
	_        [4]byte
	GTCNT    volatile.Register32 // 0x48
	GTCCRA   volatile.Register32 // 0x4C
	GTCCRB   volatile.Register32 // 0x50
	GTCCRC   volatile.Register32 // 0x54
	GTCCRE   volatile.Register32 // 0x58
	GTCCRD   volatile.Register32 // 0x5C
	GTCCRF   volatile.Register32 // 0x60
	GTPR     volatile.Register32 // 0x64
	GTPBR    volatile.Register32 // 0x68
	_        [28]byte
	GTDTCR   volatile.Register32 // 0x88
	GTDVU    volatile.Register32 // 0x8C
}

// GPT164.GTWP: General PWM Timer Write-Protection Register
func (o *GPT164_Type) SetGTWP_WP(value uint32) {
	volatile.StoreUint32(&o.GTWP.Reg, volatile.LoadUint32(&o.GTWP.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTWP_WP() uint32 {
	return volatile.LoadUint32(&o.GTWP.Reg) & 0x1
}
func (o *GPT164_Type) SetGTWP_PRKEY(value uint32) {
	volatile.StoreUint32(&o.GTWP.Reg, volatile.LoadUint32(&o.GTWP.Reg)&^(0xff00)|value<<8)
}
func (o *GPT164_Type) GetGTWP_PRKEY() uint32 {
	return (volatile.LoadUint32(&o.GTWP.Reg) & 0xff00) >> 8
}

// GPT164.GTSTR: General PWM Timer Software Start Register
func (o *GPT164_Type) SetGTSTR_CSTRT0(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTSTR_CSTRT0() uint32 {
	return volatile.LoadUint32(&o.GTSTR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTSTR_CSTRT1(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTSTR_CSTRT1() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTSTR_CSTRT2(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTSTR_CSTRT2() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTSTR_CSTRT3(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTSTR_CSTRT3() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTSTR_CSTRT4(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x10)|value<<4)
}
func (o *GPT164_Type) GetGTSTR_CSTRT4() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x10) >> 4
}
func (o *GPT164_Type) SetGTSTR_CSTRT5(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x20)|value<<5)
}
func (o *GPT164_Type) GetGTSTR_CSTRT5() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x20) >> 5
}
func (o *GPT164_Type) SetGTSTR_CSTRT6(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x40)|value<<6)
}
func (o *GPT164_Type) GetGTSTR_CSTRT6() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x40) >> 6
}
func (o *GPT164_Type) SetGTSTR_CSTRT7(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x80)|value<<7)
}
func (o *GPT164_Type) GetGTSTR_CSTRT7() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x80) >> 7
}
func (o *GPT164_Type) SetGTSTR_CSTRT8(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTSTR_CSTRT8() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTSTR_CSTRT9(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTSTR_CSTRT9() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x200) >> 9
}

// GPT164.GTSTP: General PWM Timer Software Stop Register
func (o *GPT164_Type) SetGTSTP_CSTOP0(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTSTP_CSTOP0() uint32 {
	return volatile.LoadUint32(&o.GTSTP.Reg) & 0x1
}
func (o *GPT164_Type) SetGTSTP_CSTOP1(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTSTP_CSTOP1() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTSTP_CSTOP2(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTSTP_CSTOP2() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTSTP_CSTOP3(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTSTP_CSTOP3() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTSTP_CSTOP4(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x10)|value<<4)
}
func (o *GPT164_Type) GetGTSTP_CSTOP4() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x10) >> 4
}
func (o *GPT164_Type) SetGTSTP_CSTOP5(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x20)|value<<5)
}
func (o *GPT164_Type) GetGTSTP_CSTOP5() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x20) >> 5
}
func (o *GPT164_Type) SetGTSTP_CSTOP6(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x40)|value<<6)
}
func (o *GPT164_Type) GetGTSTP_CSTOP6() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x40) >> 6
}
func (o *GPT164_Type) SetGTSTP_CSTOP7(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x80)|value<<7)
}
func (o *GPT164_Type) GetGTSTP_CSTOP7() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x80) >> 7
}
func (o *GPT164_Type) SetGTSTP_CSTOP8(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTSTP_CSTOP8() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTSTP_CSTOP9(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTSTP_CSTOP9() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x200) >> 9
}

// GPT164.GTCLR: General PWM Timer Software Clear Register
func (o *GPT164_Type) SetGTCLR_CCLR0(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTCLR_CCLR0() uint32 {
	return volatile.LoadUint32(&o.GTCLR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTCLR_CCLR1(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTCLR_CCLR1() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTCLR_CCLR2(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTCLR_CCLR2() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTCLR_CCLR3(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTCLR_CCLR3() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTCLR_CCLR4(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPT164_Type) GetGTCLR_CCLR4() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x10) >> 4
}
func (o *GPT164_Type) SetGTCLR_CCLR5(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPT164_Type) GetGTCLR_CCLR5() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x20) >> 5
}
func (o *GPT164_Type) SetGTCLR_CCLR6(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPT164_Type) GetGTCLR_CCLR6() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x40) >> 6
}
func (o *GPT164_Type) SetGTCLR_CCLR7(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPT164_Type) GetGTCLR_CCLR7() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x80) >> 7
}
func (o *GPT164_Type) SetGTCLR_CCLR8(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTCLR_CCLR8() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTCLR_CCLR9(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTCLR_CCLR9() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x200) >> 9
}

// GPT164.GTSSR: General PWM Timer Start Source Select Register
func (o *GPT164_Type) SetGTSSR_SSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTSSR_SSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTSSR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTSSR_SSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTSSR_SSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTSSR_SSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTSSR_SSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTSSR_SSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTSSR_SSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTSSR_SSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTSSR_SSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTSSR_SSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTSSR_SSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTSSR_SSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTSSR_SSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTSSR_SSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTSSR_SSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTSSR_SSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTSSR_SSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTSSR_SSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTSSR_SSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTSSR_SSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTSSR_SSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTSSR_SSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTSSR_SSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTSSR_SSELCA(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTSSR_SSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTSSR_SSELCB(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTSSR_SSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTSSR_SSELCC(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTSSR_SSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTSSR_SSELCD(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTSSR_SSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x80000) >> 19
}
func (o *GPT164_Type) SetGTSSR_CSTRT(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPT164_Type) GetGTSSR_CSTRT() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x80000000) >> 31
}

// GPT164.GTPSR: General PWM Timer Stop Source Select Register
func (o *GPT164_Type) SetGTPSR_PSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTPSR_PSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTPSR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTPSR_PSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTPSR_PSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTPSR_PSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTPSR_PSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTPSR_PSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTPSR_PSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTPSR_PSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTPSR_PSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTPSR_PSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTPSR_PSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTPSR_PSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTPSR_PSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTPSR_PSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTPSR_PSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTPSR_PSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTPSR_PSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTPSR_PSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTPSR_PSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTPSR_PSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTPSR_PSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTPSR_PSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTPSR_PSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTPSR_PSELCA(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTPSR_PSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTPSR_PSELCB(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTPSR_PSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTPSR_PSELCC(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTPSR_PSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTPSR_PSELCD(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTPSR_PSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x80000) >> 19
}
func (o *GPT164_Type) SetGTPSR_CSTOP(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPT164_Type) GetGTPSR_CSTOP() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x80000000) >> 31
}

// GPT164.GTCSR: General PWM Timer Clear Source Select Register
func (o *GPT164_Type) SetGTCSR_CSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTCSR_CSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTCSR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTCSR_CSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTCSR_CSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTCSR_CSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTCSR_CSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTCSR_CSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTCSR_CSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTCSR_CSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTCSR_CSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTCSR_CSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTCSR_CSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTCSR_CSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTCSR_CSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTCSR_CSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTCSR_CSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTCSR_CSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTCSR_CSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTCSR_CSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTCSR_CSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTCSR_CSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTCSR_CSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTCSR_CSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTCSR_CSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTCSR_CSELCA(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTCSR_CSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTCSR_CSELCB(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTCSR_CSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTCSR_CSELCC(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTCSR_CSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTCSR_CSELCD(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTCSR_CSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x80000) >> 19
}
func (o *GPT164_Type) SetGTCSR_CCLR(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPT164_Type) GetGTCSR_CCLR() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x80000000) >> 31
}

// GPT164.GTUPSR: General PWM Timer Up Count Source Select Register
func (o *GPT164_Type) SetGTUPSR_USGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTUPSR_USGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTUPSR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTUPSR_USGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTUPSR_USGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTUPSR_USGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTUPSR_USGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTUPSR_USGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTUPSR_USGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTUPSR_USCARBL(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTUPSR_USCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTUPSR_USCARBH(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTUPSR_USCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTUPSR_USCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTUPSR_USCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTUPSR_USCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTUPSR_USCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTUPSR_USCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTUPSR_USCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTUPSR_USCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTUPSR_USCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTUPSR_USCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTUPSR_USCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTUPSR_USCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTUPSR_USCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTUPSR_USELCA(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTUPSR_USELCA() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTUPSR_USELCB(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTUPSR_USELCB() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTUPSR_USELCC(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTUPSR_USELCC() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTUPSR_USELCD(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTUPSR_USELCD() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x80000) >> 19
}

// GPT164.GTDNSR: General PWM Timer Down Count Source Select Register
func (o *GPT164_Type) SetGTDNSR_DSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTDNSR_DSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTDNSR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTDNSR_DSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTDNSR_DSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTDNSR_DSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTDNSR_DSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTDNSR_DSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTDNSR_DSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTDNSR_DSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTDNSR_DSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTDNSR_DSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTDNSR_DSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTDNSR_DSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTDNSR_DSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTDNSR_DSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTDNSR_DSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTDNSR_DSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTDNSR_DSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTDNSR_DSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTDNSR_DSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTDNSR_DSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTDNSR_DSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTDNSR_DSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTDNSR_DSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTDNSR_DSELCA(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTDNSR_DSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTDNSR_DSELCB(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTDNSR_DSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTDNSR_DSELCC(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTDNSR_DSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTDNSR_DSELCD(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTDNSR_DSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x80000) >> 19
}

// GPT164.GTICASR: General PWM Timer Input Capture Source Select Register A
func (o *GPT164_Type) SetGTICASR_ASGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTICASR_ASGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTICASR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTICASR_ASGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTICASR_ASGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTICASR_ASGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTICASR_ASGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTICASR_ASGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTICASR_ASGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTICASR_ASCARBL(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTICASR_ASCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTICASR_ASCARBH(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTICASR_ASCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTICASR_ASCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTICASR_ASCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTICASR_ASCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTICASR_ASCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTICASR_ASCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTICASR_ASCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTICASR_ASCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTICASR_ASCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTICASR_ASCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTICASR_ASCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTICASR_ASCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTICASR_ASCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTICASR_ASELCA(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTICASR_ASELCA() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTICASR_ASELCB(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTICASR_ASELCB() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTICASR_ASELCC(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTICASR_ASELCC() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTICASR_ASELCD(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTICASR_ASELCD() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x80000) >> 19
}

// GPT164.GTICBSR: General PWM Timer Input Capture Source Select Register B
func (o *GPT164_Type) SetGTICBSR_BSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTICBSR_BSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTICBSR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTICBSR_BSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTICBSR_BSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTICBSR_BSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTICBSR_BSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTICBSR_BSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTICBSR_BSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTICBSR_BSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTICBSR_BSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTICBSR_BSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTICBSR_BSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTICBSR_BSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTICBSR_BSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTICBSR_BSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTICBSR_BSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTICBSR_BSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTICBSR_BSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTICBSR_BSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTICBSR_BSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTICBSR_BSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTICBSR_BSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTICBSR_BSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTICBSR_BSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTICBSR_BSELCA(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTICBSR_BSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTICBSR_BSELCB(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTICBSR_BSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTICBSR_BSELCC(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTICBSR_BSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTICBSR_BSELCD(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTICBSR_BSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x80000) >> 19
}

// GPT164.GTCR: General PWM Timer Control Register
func (o *GPT164_Type) SetGTCR_CST(value uint32) {
	volatile.StoreUint32(&o.GTCR.Reg, volatile.LoadUint32(&o.GTCR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTCR_CST() uint32 {
	return volatile.LoadUint32(&o.GTCR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTCR_MD(value uint32) {
	volatile.StoreUint32(&o.GTCR.Reg, volatile.LoadUint32(&o.GTCR.Reg)&^(0x70000)|value<<16)
}
func (o *GPT164_Type) GetGTCR_MD() uint32 {
	return (volatile.LoadUint32(&o.GTCR.Reg) & 0x70000) >> 16
}
func (o *GPT164_Type) SetGTCR_TPCS(value uint32) {
	volatile.StoreUint32(&o.GTCR.Reg, volatile.LoadUint32(&o.GTCR.Reg)&^(0x7000000)|value<<24)
}
func (o *GPT164_Type) GetGTCR_TPCS() uint32 {
	return (volatile.LoadUint32(&o.GTCR.Reg) & 0x7000000) >> 24
}

// GPT164.GTUDDTYC: General PWM Timer Count Direction and Duty Setting Register
func (o *GPT164_Type) SetGTUDDTYC_UD(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTUDDTYC_UD() uint32 {
	return volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x1
}
func (o *GPT164_Type) SetGTUDDTYC_UDF(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTUDDTYC_UDF() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTUDDTYC_OADTY(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x30000)|value<<16)
}
func (o *GPT164_Type) GetGTUDDTYC_OADTY() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x30000) >> 16
}
func (o *GPT164_Type) SetGTUDDTYC_OADTYF(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTUDDTYC_OADTYF() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTUDDTYC_OADTYR(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTUDDTYC_OADTYR() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x80000) >> 19
}
func (o *GPT164_Type) SetGTUDDTYC_OBDTY(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x3000000)|value<<24)
}
func (o *GPT164_Type) GetGTUDDTYC_OBDTY() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x3000000) >> 24
}
func (o *GPT164_Type) SetGTUDDTYC_OBDTYF(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x4000000)|value<<26)
}
func (o *GPT164_Type) GetGTUDDTYC_OBDTYF() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x4000000) >> 26
}
func (o *GPT164_Type) SetGTUDDTYC_OBDTYR(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x8000000)|value<<27)
}
func (o *GPT164_Type) GetGTUDDTYC_OBDTYR() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x8000000) >> 27
}

// GPT164.GTIOR: General PWM Timer I/O Control Register
func (o *GPT164_Type) SetGTIOR_GTIOA(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x1f)|value)
}
func (o *GPT164_Type) GetGTIOR_GTIOA() uint32 {
	return volatile.LoadUint32(&o.GTIOR.Reg) & 0x1f
}
func (o *GPT164_Type) SetGTIOR_OADFLT(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x40)|value<<6)
}
func (o *GPT164_Type) GetGTIOR_OADFLT() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x40) >> 6
}
func (o *GPT164_Type) SetGTIOR_OAHLD(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x80)|value<<7)
}
func (o *GPT164_Type) GetGTIOR_OAHLD() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x80) >> 7
}
func (o *GPT164_Type) SetGTIOR_OAE(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTIOR_OAE() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTIOR_OADF(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x600)|value<<9)
}
func (o *GPT164_Type) GetGTIOR_OADF() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x600) >> 9
}
func (o *GPT164_Type) SetGTIOR_NFAEN(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTIOR_NFAEN() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTIOR_NFCSA(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0xc000)|value<<14)
}
func (o *GPT164_Type) GetGTIOR_NFCSA() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0xc000) >> 14
}
func (o *GPT164_Type) SetGTIOR_GTIOB(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x1f0000)|value<<16)
}
func (o *GPT164_Type) GetGTIOR_GTIOB() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x1f0000) >> 16
}
func (o *GPT164_Type) SetGTIOR_OBDFLT(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x400000)|value<<22)
}
func (o *GPT164_Type) GetGTIOR_OBDFLT() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x400000) >> 22
}
func (o *GPT164_Type) SetGTIOR_OBHLD(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x800000)|value<<23)
}
func (o *GPT164_Type) GetGTIOR_OBHLD() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x800000) >> 23
}
func (o *GPT164_Type) SetGTIOR_OBE(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPT164_Type) GetGTIOR_OBE() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x1000000) >> 24
}
func (o *GPT164_Type) SetGTIOR_OBDF(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x6000000)|value<<25)
}
func (o *GPT164_Type) GetGTIOR_OBDF() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x6000000) >> 25
}
func (o *GPT164_Type) SetGTIOR_NFBEN(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPT164_Type) GetGTIOR_NFBEN() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x20000000) >> 29
}
func (o *GPT164_Type) SetGTIOR_NFCSB(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPT164_Type) GetGTIOR_NFCSB() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0xc0000000) >> 30
}

// GPT164.GTINTAD: General PWM Timer Interrupt Output Setting Register
func (o *GPT164_Type) SetGTINTAD_GRP(value uint32) {
	volatile.StoreUint32(&o.GTINTAD.Reg, volatile.LoadUint32(&o.GTINTAD.Reg)&^(0x3000000)|value<<24)
}
func (o *GPT164_Type) GetGTINTAD_GRP() uint32 {
	return (volatile.LoadUint32(&o.GTINTAD.Reg) & 0x3000000) >> 24
}
func (o *GPT164_Type) SetGTINTAD_GRPABH(value uint32) {
	volatile.StoreUint32(&o.GTINTAD.Reg, volatile.LoadUint32(&o.GTINTAD.Reg)&^(0x20000000)|value<<29)
}
func (o *GPT164_Type) GetGTINTAD_GRPABH() uint32 {
	return (volatile.LoadUint32(&o.GTINTAD.Reg) & 0x20000000) >> 29
}
func (o *GPT164_Type) SetGTINTAD_GRPABL(value uint32) {
	volatile.StoreUint32(&o.GTINTAD.Reg, volatile.LoadUint32(&o.GTINTAD.Reg)&^(0x40000000)|value<<30)
}
func (o *GPT164_Type) GetGTINTAD_GRPABL() uint32 {
	return (volatile.LoadUint32(&o.GTINTAD.Reg) & 0x40000000) >> 30
}

// GPT164.GTST: General PWM Timer Status Register
func (o *GPT164_Type) SetGTST_TCFA(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTST_TCFA() uint32 {
	return volatile.LoadUint32(&o.GTST.Reg) & 0x1
}
func (o *GPT164_Type) SetGTST_TCFB(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTST_TCFB() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTST_TCFC(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTST_TCFC() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTST_TCFD(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTST_TCFD() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTST_TCFE(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x10)|value<<4)
}
func (o *GPT164_Type) GetGTST_TCFE() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x10) >> 4
}
func (o *GPT164_Type) SetGTST_TCFF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x20)|value<<5)
}
func (o *GPT164_Type) GetGTST_TCFF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x20) >> 5
}
func (o *GPT164_Type) SetGTST_TCFPO(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x40)|value<<6)
}
func (o *GPT164_Type) GetGTST_TCFPO() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x40) >> 6
}
func (o *GPT164_Type) SetGTST_TCFPU(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x80)|value<<7)
}
func (o *GPT164_Type) GetGTST_TCFPU() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x80) >> 7
}
func (o *GPT164_Type) SetGTST_TUCF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTST_TUCF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTST_ODF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x1000000)|value<<24)
}
func (o *GPT164_Type) GetGTST_ODF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x1000000) >> 24
}
func (o *GPT164_Type) SetGTST_OABHF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x20000000)|value<<29)
}
func (o *GPT164_Type) GetGTST_OABHF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x20000000) >> 29
}
func (o *GPT164_Type) SetGTST_OABLF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x40000000)|value<<30)
}
func (o *GPT164_Type) GetGTST_OABLF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x40000000) >> 30
}

// GPT164.GTBER: General PWM Timer Buffer Enable Register
func (o *GPT164_Type) SetGTBER_BD0(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTBER_BD0() uint32 {
	return volatile.LoadUint32(&o.GTBER.Reg) & 0x1
}
func (o *GPT164_Type) SetGTBER_BD1(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTBER_BD1() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTBER_CCRA(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x30000)|value<<16)
}
func (o *GPT164_Type) GetGTBER_CCRA() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0x30000) >> 16
}
func (o *GPT164_Type) SetGTBER_CCRB(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPT164_Type) GetGTBER_CCRB() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0xc0000) >> 18
}
func (o *GPT164_Type) SetGTBER_PR(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x300000)|value<<20)
}
func (o *GPT164_Type) GetGTBER_PR() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0x300000) >> 20
}
func (o *GPT164_Type) SetGTBER_CCRSWT(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x400000)|value<<22)
}
func (o *GPT164_Type) GetGTBER_CCRSWT() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0x400000) >> 22
}

// GPT164.GTDTCR: General PWM Timer Dead Time Control Register
func (o *GPT164_Type) SetGTDTCR_TDE(value uint32) {
	volatile.StoreUint32(&o.GTDTCR.Reg, volatile.LoadUint32(&o.GTDTCR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTDTCR_TDE() uint32 {
	return volatile.LoadUint32(&o.GTDTCR.Reg) & 0x1
}

// Output Phase Switching Controller
type GPT_OPS_Type struct {
	OPSCR volatile.Register32 // 0x0
}

// GPT_OPS.OPSCR: Output Phase Switching Control Register
func (o *GPT_OPS_Type) SetOPSCR_UF(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x1)|value)
}
func (o *GPT_OPS_Type) GetOPSCR_UF() uint32 {
	return volatile.LoadUint32(&o.OPSCR.Reg) & 0x1
}
func (o *GPT_OPS_Type) SetOPSCR_VF(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x2)|value<<1)
}
func (o *GPT_OPS_Type) GetOPSCR_VF() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x2) >> 1
}
func (o *GPT_OPS_Type) SetOPSCR_WF(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x4)|value<<2)
}
func (o *GPT_OPS_Type) GetOPSCR_WF() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x4) >> 2
}
func (o *GPT_OPS_Type) SetOPSCR_U(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x10)|value<<4)
}
func (o *GPT_OPS_Type) GetOPSCR_U() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x10) >> 4
}
func (o *GPT_OPS_Type) SetOPSCR_V(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x20)|value<<5)
}
func (o *GPT_OPS_Type) GetOPSCR_V() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x20) >> 5
}
func (o *GPT_OPS_Type) SetOPSCR_W(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x40)|value<<6)
}
func (o *GPT_OPS_Type) GetOPSCR_W() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x40) >> 6
}
func (o *GPT_OPS_Type) SetOPSCR_EN(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x100)|value<<8)
}
func (o *GPT_OPS_Type) GetOPSCR_EN() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x100) >> 8
}
func (o *GPT_OPS_Type) SetOPSCR_FB(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT_OPS_Type) GetOPSCR_FB() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x10000) >> 16
}
func (o *GPT_OPS_Type) SetOPSCR_P(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT_OPS_Type) GetOPSCR_P() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x20000) >> 17
}
func (o *GPT_OPS_Type) SetOPSCR_N(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT_OPS_Type) GetOPSCR_N() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x40000) >> 18
}
func (o *GPT_OPS_Type) SetOPSCR_INV(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT_OPS_Type) GetOPSCR_INV() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x80000) >> 19
}
func (o *GPT_OPS_Type) SetOPSCR_RV(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x100000)|value<<20)
}
func (o *GPT_OPS_Type) GetOPSCR_RV() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x100000) >> 20
}
func (o *GPT_OPS_Type) SetOPSCR_ALIGN(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x200000)|value<<21)
}
func (o *GPT_OPS_Type) GetOPSCR_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x200000) >> 21
}
func (o *GPT_OPS_Type) SetOPSCR_GRP(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPT_OPS_Type) GetOPSCR_GRP() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x3000000) >> 24
}
func (o *GPT_OPS_Type) SetOPSCR_GODF(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPT_OPS_Type) GetOPSCR_GODF() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x4000000) >> 26
}
func (o *GPT_OPS_Type) SetOPSCR_NFEN(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPT_OPS_Type) GetOPSCR_NFEN() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x20000000) >> 29
}
func (o *GPT_OPS_Type) SetOPSCR_NFCS(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPT_OPS_Type) GetOPSCR_NFCS() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0xc0000000) >> 30
}

// Key Interrupt Function
type KINT_Type struct {
	KRCTL volatile.Register8 // 0x0
	_     [3]byte
	KRF   volatile.Register8 // 0x4
	_     [3]byte
	KRM   volatile.Register8 // 0x8
}

// KINT.KRCTL: Key Return Control Register
func (o *KINT_Type) SetKRCTL_KREG(value uint8) {
	volatile.StoreUint8(&o.KRCTL.Reg, volatile.LoadUint8(&o.KRCTL.Reg)&^(0x1)|value)
}
func (o *KINT_Type) GetKRCTL_KREG() uint8 {
	return volatile.LoadUint8(&o.KRCTL.Reg) & 0x1
}
func (o *KINT_Type) SetKRCTL_KRMD(value uint8) {
	volatile.StoreUint8(&o.KRCTL.Reg, volatile.LoadUint8(&o.KRCTL.Reg)&^(0x80)|value<<7)
}
func (o *KINT_Type) GetKRCTL_KRMD() uint8 {
	return (volatile.LoadUint8(&o.KRCTL.Reg) & 0x80) >> 7
}

// KINT.KRF: Key Return Flag Register
func (o *KINT_Type) SetKRF_KIF0(value uint8) {
	volatile.StoreUint8(&o.KRF.Reg, volatile.LoadUint8(&o.KRF.Reg)&^(0x1)|value)
}
func (o *KINT_Type) GetKRF_KIF0() uint8 {
	return volatile.LoadUint8(&o.KRF.Reg) & 0x1
}
func (o *KINT_Type) SetKRF_KIF1(value uint8) {
	volatile.StoreUint8(&o.KRF.Reg, volatile.LoadUint8(&o.KRF.Reg)&^(0x2)|value<<1)
}
func (o *KINT_Type) GetKRF_KIF1() uint8 {
	return (volatile.LoadUint8(&o.KRF.Reg) & 0x2) >> 1
}
func (o *KINT_Type) SetKRF_KIF2(value uint8) {
	volatile.StoreUint8(&o.KRF.Reg, volatile.LoadUint8(&o.KRF.Reg)&^(0x4)|value<<2)
}
func (o *KINT_Type) GetKRF_KIF2() uint8 {
	return (volatile.LoadUint8(&o.KRF.Reg) & 0x4) >> 2
}
func (o *KINT_Type) SetKRF_KIF3(value uint8) {
	volatile.StoreUint8(&o.KRF.Reg, volatile.LoadUint8(&o.KRF.Reg)&^(0x8)|value<<3)
}
func (o *KINT_Type) GetKRF_KIF3() uint8 {
	return (volatile.LoadUint8(&o.KRF.Reg) & 0x8) >> 3
}
func (o *KINT_Type) SetKRF_KIF4(value uint8) {
	volatile.StoreUint8(&o.KRF.Reg, volatile.LoadUint8(&o.KRF.Reg)&^(0x10)|value<<4)
}
func (o *KINT_Type) GetKRF_KIF4() uint8 {
	return (volatile.LoadUint8(&o.KRF.Reg) & 0x10) >> 4
}
func (o *KINT_Type) SetKRF_KIF5(value uint8) {
	volatile.StoreUint8(&o.KRF.Reg, volatile.LoadUint8(&o.KRF.Reg)&^(0x20)|value<<5)
}
func (o *KINT_Type) GetKRF_KIF5() uint8 {
	return (volatile.LoadUint8(&o.KRF.Reg) & 0x20) >> 5
}
func (o *KINT_Type) SetKRF_KIF6(value uint8) {
	volatile.StoreUint8(&o.KRF.Reg, volatile.LoadUint8(&o.KRF.Reg)&^(0x40)|value<<6)
}
func (o *KINT_Type) GetKRF_KIF6() uint8 {
	return (volatile.LoadUint8(&o.KRF.Reg) & 0x40) >> 6
}
func (o *KINT_Type) SetKRF_KIF7(value uint8) {
	volatile.StoreUint8(&o.KRF.Reg, volatile.LoadUint8(&o.KRF.Reg)&^(0x80)|value<<7)
}
func (o *KINT_Type) GetKRF_KIF7() uint8 {
	return (volatile.LoadUint8(&o.KRF.Reg) & 0x80) >> 7
}

// KINT.KRM: Key Return Mode Register
func (o *KINT_Type) SetKRM_KIMC0(value uint8) {
	volatile.StoreUint8(&o.KRM.Reg, volatile.LoadUint8(&o.KRM.Reg)&^(0x1)|value)
}
func (o *KINT_Type) GetKRM_KIMC0() uint8 {
	return volatile.LoadUint8(&o.KRM.Reg) & 0x1
}
func (o *KINT_Type) SetKRM_KIMC1(value uint8) {
	volatile.StoreUint8(&o.KRM.Reg, volatile.LoadUint8(&o.KRM.Reg)&^(0x2)|value<<1)
}
func (o *KINT_Type) GetKRM_KIMC1() uint8 {
	return (volatile.LoadUint8(&o.KRM.Reg) & 0x2) >> 1
}
func (o *KINT_Type) SetKRM_KIMC2(value uint8) {
	volatile.StoreUint8(&o.KRM.Reg, volatile.LoadUint8(&o.KRM.Reg)&^(0x4)|value<<2)
}
func (o *KINT_Type) GetKRM_KIMC2() uint8 {
	return (volatile.LoadUint8(&o.KRM.Reg) & 0x4) >> 2
}
func (o *KINT_Type) SetKRM_KIMC3(value uint8) {
	volatile.StoreUint8(&o.KRM.Reg, volatile.LoadUint8(&o.KRM.Reg)&^(0x8)|value<<3)
}
func (o *KINT_Type) GetKRM_KIMC3() uint8 {
	return (volatile.LoadUint8(&o.KRM.Reg) & 0x8) >> 3
}
func (o *KINT_Type) SetKRM_KIMC4(value uint8) {
	volatile.StoreUint8(&o.KRM.Reg, volatile.LoadUint8(&o.KRM.Reg)&^(0x10)|value<<4)
}
func (o *KINT_Type) GetKRM_KIMC4() uint8 {
	return (volatile.LoadUint8(&o.KRM.Reg) & 0x10) >> 4
}
func (o *KINT_Type) SetKRM_KIMC5(value uint8) {
	volatile.StoreUint8(&o.KRM.Reg, volatile.LoadUint8(&o.KRM.Reg)&^(0x20)|value<<5)
}
func (o *KINT_Type) GetKRM_KIMC5() uint8 {
	return (volatile.LoadUint8(&o.KRM.Reg) & 0x20) >> 5
}
func (o *KINT_Type) SetKRM_KIMC6(value uint8) {
	volatile.StoreUint8(&o.KRM.Reg, volatile.LoadUint8(&o.KRM.Reg)&^(0x40)|value<<6)
}
func (o *KINT_Type) GetKRM_KIMC6() uint8 {
	return (volatile.LoadUint8(&o.KRM.Reg) & 0x40) >> 6
}
func (o *KINT_Type) SetKRM_KIMC7(value uint8) {
	volatile.StoreUint8(&o.KRM.Reg, volatile.LoadUint8(&o.KRM.Reg)&^(0x80)|value<<7)
}
func (o *KINT_Type) GetKRM_KIMC7() uint8 {
	return (volatile.LoadUint8(&o.KRM.Reg) & 0x80) >> 7
}

// Capacitive Touch Sensing Unit
type CTSU_Type struct {
	CTSUCRA    volatile.Register32 // 0x0
	CTSUCRB    volatile.Register32 // 0x4
	CTSUMCH    volatile.Register32 // 0x8
	CTSUCHACA  volatile.Register32 // 0xC
	CTSUCHACB  volatile.Register32 // 0x10
	CTSUCHTRCA volatile.Register32 // 0x14
	CTSUCHTRCB volatile.Register32 // 0x18
	CTSUSR     volatile.Register32 // 0x1C
	CTSUSO     volatile.Register32 // 0x20
	CTSUSCNT   volatile.Register32 // 0x24
	CTSUCALIB  volatile.Register32 // 0x28
	CTSUSUCLKA volatile.Register32 // 0x2C
	CTSUSUCLKB volatile.Register32 // 0x30
	CTSUCFCCNT volatile.Register32 // 0x34
}

// CTSU.CTSUCRA: CTSU Control Register A
func (o *CTSU_Type) SetCTSUCRA_STRT(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x1)|value)
}
func (o *CTSU_Type) GetCTSUCRA_STRT() uint32 {
	return volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x1
}
func (o *CTSU_Type) SetCTSUCRA_CAP(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x2)|value<<1)
}
func (o *CTSU_Type) GetCTSUCRA_CAP() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x2) >> 1
}
func (o *CTSU_Type) SetCTSUCRA_SNZ(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x4)|value<<2)
}
func (o *CTSU_Type) GetCTSUCRA_SNZ() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x4) >> 2
}
func (o *CTSU_Type) SetCTSUCRA_CFCON(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x8)|value<<3)
}
func (o *CTSU_Type) GetCTSUCRA_CFCON() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x8) >> 3
}
func (o *CTSU_Type) SetCTSUCRA_INIT(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x10)|value<<4)
}
func (o *CTSU_Type) GetCTSUCRA_INIT() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x10) >> 4
}
func (o *CTSU_Type) SetCTSUCRA_PUMPON(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x20)|value<<5)
}
func (o *CTSU_Type) GetCTSUCRA_PUMPON() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x20) >> 5
}
func (o *CTSU_Type) SetCTSUCRA_TXVSEL(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0xc0)|value<<6)
}
func (o *CTSU_Type) GetCTSUCRA_TXVSEL() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0xc0) >> 6
}
func (o *CTSU_Type) SetCTSUCRA_PON(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x100)|value<<8)
}
func (o *CTSU_Type) GetCTSUCRA_PON() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x100) >> 8
}
func (o *CTSU_Type) SetCTSUCRA_CSW(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x200)|value<<9)
}
func (o *CTSU_Type) GetCTSUCRA_CSW() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x200) >> 9
}
func (o *CTSU_Type) SetCTSUCRA_ATUNE0(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x400)|value<<10)
}
func (o *CTSU_Type) GetCTSUCRA_ATUNE0() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x400) >> 10
}
func (o *CTSU_Type) SetCTSUCRA_ATUNE1(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x800)|value<<11)
}
func (o *CTSU_Type) GetCTSUCRA_ATUNE1() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x800) >> 11
}
func (o *CTSU_Type) SetCTSUCRA_CLK(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x3000)|value<<12)
}
func (o *CTSU_Type) GetCTSUCRA_CLK() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x3000) >> 12
}
func (o *CTSU_Type) SetCTSUCRA_MD0(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x4000)|value<<14)
}
func (o *CTSU_Type) GetCTSUCRA_MD0() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x4000) >> 14
}
func (o *CTSU_Type) SetCTSUCRA_MD1(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x8000)|value<<15)
}
func (o *CTSU_Type) GetCTSUCRA_MD1() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x8000) >> 15
}
func (o *CTSU_Type) SetCTSUCRA_MD2(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x10000)|value<<16)
}
func (o *CTSU_Type) GetCTSUCRA_MD2() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x10000) >> 16
}
func (o *CTSU_Type) SetCTSUCRA_ATUNE2(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x20000)|value<<17)
}
func (o *CTSU_Type) GetCTSUCRA_ATUNE2() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x20000) >> 17
}
func (o *CTSU_Type) SetCTSUCRA_LOAD(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0xc0000)|value<<18)
}
func (o *CTSU_Type) GetCTSUCRA_LOAD() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0xc0000) >> 18
}
func (o *CTSU_Type) SetCTSUCRA_POSEL(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x300000)|value<<20)
}
func (o *CTSU_Type) GetCTSUCRA_POSEL() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x300000) >> 20
}
func (o *CTSU_Type) SetCTSUCRA_SDPSEL(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x400000)|value<<22)
}
func (o *CTSU_Type) GetCTSUCRA_SDPSEL() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x400000) >> 22
}
func (o *CTSU_Type) SetCTSUCRA_PCSEL(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x800000)|value<<23)
}
func (o *CTSU_Type) GetCTSUCRA_PCSEL() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x800000) >> 23
}
func (o *CTSU_Type) SetCTSUCRA_STCLK(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x3f000000)|value<<24)
}
func (o *CTSU_Type) GetCTSUCRA_STCLK() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x3f000000) >> 24
}
func (o *CTSU_Type) SetCTSUCRA_DCMODE(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x40000000)|value<<30)
}
func (o *CTSU_Type) GetCTSUCRA_DCMODE() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x40000000) >> 30
}
func (o *CTSU_Type) SetCTSUCRA_DCBACK(value uint32) {
	volatile.StoreUint32(&o.CTSUCRA.Reg, volatile.LoadUint32(&o.CTSUCRA.Reg)&^(0x80000000)|value<<31)
}
func (o *CTSU_Type) GetCTSUCRA_DCBACK() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRA.Reg) & 0x80000000) >> 31
}

// CTSU.CTSUCRB: CTSU Control Register B
func (o *CTSU_Type) SetCTSUCRB_PRRATIO(value uint32) {
	volatile.StoreUint32(&o.CTSUCRB.Reg, volatile.LoadUint32(&o.CTSUCRB.Reg)&^(0xf)|value)
}
func (o *CTSU_Type) GetCTSUCRB_PRRATIO() uint32 {
	return volatile.LoadUint32(&o.CTSUCRB.Reg) & 0xf
}
func (o *CTSU_Type) SetCTSUCRB_PRMODE(value uint32) {
	volatile.StoreUint32(&o.CTSUCRB.Reg, volatile.LoadUint32(&o.CTSUCRB.Reg)&^(0x30)|value<<4)
}
func (o *CTSU_Type) GetCTSUCRB_PRMODE() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRB.Reg) & 0x30) >> 4
}
func (o *CTSU_Type) SetCTSUCRB_SOFF(value uint32) {
	volatile.StoreUint32(&o.CTSUCRB.Reg, volatile.LoadUint32(&o.CTSUCRB.Reg)&^(0x40)|value<<6)
}
func (o *CTSU_Type) GetCTSUCRB_SOFF() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRB.Reg) & 0x40) >> 6
}
func (o *CTSU_Type) SetCTSUCRB_PROFF(value uint32) {
	volatile.StoreUint32(&o.CTSUCRB.Reg, volatile.LoadUint32(&o.CTSUCRB.Reg)&^(0x80)|value<<7)
}
func (o *CTSU_Type) GetCTSUCRB_PROFF() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRB.Reg) & 0x80) >> 7
}
func (o *CTSU_Type) SetCTSUCRB_SST(value uint32) {
	volatile.StoreUint32(&o.CTSUCRB.Reg, volatile.LoadUint32(&o.CTSUCRB.Reg)&^(0xff00)|value<<8)
}
func (o *CTSU_Type) GetCTSUCRB_SST() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRB.Reg) & 0xff00) >> 8
}
func (o *CTSU_Type) SetCTSUCRB_SSMOD(value uint32) {
	volatile.StoreUint32(&o.CTSUCRB.Reg, volatile.LoadUint32(&o.CTSUCRB.Reg)&^(0x7000000)|value<<24)
}
func (o *CTSU_Type) GetCTSUCRB_SSMOD() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRB.Reg) & 0x7000000) >> 24
}
func (o *CTSU_Type) SetCTSUCRB_SSCNT(value uint32) {
	volatile.StoreUint32(&o.CTSUCRB.Reg, volatile.LoadUint32(&o.CTSUCRB.Reg)&^(0x30000000)|value<<28)
}
func (o *CTSU_Type) GetCTSUCRB_SSCNT() uint32 {
	return (volatile.LoadUint32(&o.CTSUCRB.Reg) & 0x30000000) >> 28
}

// CTSU.CTSUMCH: CTSU Measurement Channel Register
func (o *CTSU_Type) SetCTSUMCH_MCH0(value uint32) {
	volatile.StoreUint32(&o.CTSUMCH.Reg, volatile.LoadUint32(&o.CTSUMCH.Reg)&^(0x3f)|value)
}
func (o *CTSU_Type) GetCTSUMCH_MCH0() uint32 {
	return volatile.LoadUint32(&o.CTSUMCH.Reg) & 0x3f
}
func (o *CTSU_Type) SetCTSUMCH_MCH1(value uint32) {
	volatile.StoreUint32(&o.CTSUMCH.Reg, volatile.LoadUint32(&o.CTSUMCH.Reg)&^(0x3f00)|value<<8)
}
func (o *CTSU_Type) GetCTSUMCH_MCH1() uint32 {
	return (volatile.LoadUint32(&o.CTSUMCH.Reg) & 0x3f00) >> 8
}
func (o *CTSU_Type) SetCTSUMCH_MCA0(value uint32) {
	volatile.StoreUint32(&o.CTSUMCH.Reg, volatile.LoadUint32(&o.CTSUMCH.Reg)&^(0x10000)|value<<16)
}
func (o *CTSU_Type) GetCTSUMCH_MCA0() uint32 {
	return (volatile.LoadUint32(&o.CTSUMCH.Reg) & 0x10000) >> 16
}
func (o *CTSU_Type) SetCTSUMCH_MCA1(value uint32) {
	volatile.StoreUint32(&o.CTSUMCH.Reg, volatile.LoadUint32(&o.CTSUMCH.Reg)&^(0x20000)|value<<17)
}
func (o *CTSU_Type) GetCTSUMCH_MCA1() uint32 {
	return (volatile.LoadUint32(&o.CTSUMCH.Reg) & 0x20000) >> 17
}
func (o *CTSU_Type) SetCTSUMCH_MCA2(value uint32) {
	volatile.StoreUint32(&o.CTSUMCH.Reg, volatile.LoadUint32(&o.CTSUMCH.Reg)&^(0x40000)|value<<18)
}
func (o *CTSU_Type) GetCTSUMCH_MCA2() uint32 {
	return (volatile.LoadUint32(&o.CTSUMCH.Reg) & 0x40000) >> 18
}
func (o *CTSU_Type) SetCTSUMCH_MCA3(value uint32) {
	volatile.StoreUint32(&o.CTSUMCH.Reg, volatile.LoadUint32(&o.CTSUMCH.Reg)&^(0x80000)|value<<19)
}
func (o *CTSU_Type) GetCTSUMCH_MCA3() uint32 {
	return (volatile.LoadUint32(&o.CTSUMCH.Reg) & 0x80000) >> 19
}

// CTSU.CTSUCHACA: CTSU Channel Enable Control Register A
func (o *CTSU_Type) SetCTSUCHACA_CHAC00(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x1)|value)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC00() uint32 {
	return volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x1
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC02(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x4)|value<<2)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC02() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x4) >> 2
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC04(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x10)|value<<4)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC04() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x10) >> 4
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC05(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x20)|value<<5)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC05() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x20) >> 5
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC06(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x40)|value<<6)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC06() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x40) >> 6
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC07(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x80)|value<<7)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC07() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x80) >> 7
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC08(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x100)|value<<8)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC08() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x100) >> 8
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC09(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x200)|value<<9)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC09() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x200) >> 9
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC10(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x400)|value<<10)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC10() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x400) >> 10
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC11(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x800)|value<<11)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC11() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x800) >> 11
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC12(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x1000)|value<<12)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC12() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x1000) >> 12
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC13(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x2000)|value<<13)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC13() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x2000) >> 13
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC14(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x4000)|value<<14)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC14() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x4000) >> 14
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC15(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x8000)|value<<15)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC15() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x8000) >> 15
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC16(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x10000)|value<<16)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC16() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x10000) >> 16
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC17(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x20000)|value<<17)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC17() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x20000) >> 17
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC18(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x40000)|value<<18)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC18() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x40000) >> 18
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC21(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x200000)|value<<21)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC21() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x200000) >> 21
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC22(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x400000)|value<<22)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC22() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x400000) >> 22
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC23(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x800000)|value<<23)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC23() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x800000) >> 23
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC24(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x1000000)|value<<24)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC24() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x1000000) >> 24
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC25(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x2000000)|value<<25)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC25() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x2000000) >> 25
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC26(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x4000000)|value<<26)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC26() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x4000000) >> 26
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC27(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x8000000)|value<<27)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC27() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x8000000) >> 27
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC28(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x10000000)|value<<28)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC28() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x10000000) >> 28
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC30(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x40000000)|value<<30)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC30() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x40000000) >> 30
}
func (o *CTSU_Type) SetCTSUCHACA_CHAC31(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACA.Reg, volatile.LoadUint32(&o.CTSUCHACA.Reg)&^(0x80000000)|value<<31)
}
func (o *CTSU_Type) GetCTSUCHACA_CHAC31() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACA.Reg) & 0x80000000) >> 31
}

// CTSU.CTSUCHACB: CTSU Channel Enable Control Register B
func (o *CTSU_Type) SetCTSUCHACB_CHAC32(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACB.Reg, volatile.LoadUint32(&o.CTSUCHACB.Reg)&^(0x1)|value)
}
func (o *CTSU_Type) GetCTSUCHACB_CHAC32() uint32 {
	return volatile.LoadUint32(&o.CTSUCHACB.Reg) & 0x1
}
func (o *CTSU_Type) SetCTSUCHACB_CHAC33(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACB.Reg, volatile.LoadUint32(&o.CTSUCHACB.Reg)&^(0x2)|value<<1)
}
func (o *CTSU_Type) GetCTSUCHACB_CHAC33() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACB.Reg) & 0x2) >> 1
}
func (o *CTSU_Type) SetCTSUCHACB_CHAC34(value uint32) {
	volatile.StoreUint32(&o.CTSUCHACB.Reg, volatile.LoadUint32(&o.CTSUCHACB.Reg)&^(0x4)|value<<2)
}
func (o *CTSU_Type) GetCTSUCHACB_CHAC34() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHACB.Reg) & 0x4) >> 2
}

// CTSU.CTSUCHTRCA: CTSU Channel Transmit/Receive Control Register A
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC00(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x1)|value)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC00() uint32 {
	return volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x1
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC02(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x4)|value<<2)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC02() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x4) >> 2
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC04(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x10)|value<<4)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC04() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x10) >> 4
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC05(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x20)|value<<5)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC05() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x20) >> 5
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC06(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x40)|value<<6)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC06() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x40) >> 6
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC07(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x80)|value<<7)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC07() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x80) >> 7
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC08(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x100)|value<<8)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC08() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x100) >> 8
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC09(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x200)|value<<9)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC09() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x200) >> 9
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC10(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x400)|value<<10)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC10() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x400) >> 10
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC11(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x800)|value<<11)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC11() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x800) >> 11
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC12(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x1000)|value<<12)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC12() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x1000) >> 12
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC13(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x2000)|value<<13)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC13() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x2000) >> 13
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC14(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x4000)|value<<14)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC14() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x4000) >> 14
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC15(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x8000)|value<<15)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC15() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x8000) >> 15
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC16(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x10000)|value<<16)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC16() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x10000) >> 16
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC17(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x20000)|value<<17)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC17() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x20000) >> 17
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC18(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x40000)|value<<18)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC18() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x40000) >> 18
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC21(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x200000)|value<<21)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC21() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x200000) >> 21
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC22(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x400000)|value<<22)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC22() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x400000) >> 22
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC23(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x800000)|value<<23)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC23() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x800000) >> 23
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC24(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x1000000)|value<<24)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC24() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x1000000) >> 24
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC25(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x2000000)|value<<25)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC25() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x2000000) >> 25
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC26(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x4000000)|value<<26)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC26() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x4000000) >> 26
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC27(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x8000000)|value<<27)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC27() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x8000000) >> 27
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC28(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x10000000)|value<<28)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC28() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x10000000) >> 28
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC30(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x40000000)|value<<30)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC30() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x40000000) >> 30
}
func (o *CTSU_Type) SetCTSUCHTRCA_CHTRC31(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCA.Reg, volatile.LoadUint32(&o.CTSUCHTRCA.Reg)&^(0x80000000)|value<<31)
}
func (o *CTSU_Type) GetCTSUCHTRCA_CHTRC31() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCA.Reg) & 0x80000000) >> 31
}

// CTSU.CTSUCHTRCB: CTSU Channel Transmit/Receive Control Register B
func (o *CTSU_Type) SetCTSUCHTRCB_CHTRC32(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCB.Reg, volatile.LoadUint32(&o.CTSUCHTRCB.Reg)&^(0x1)|value)
}
func (o *CTSU_Type) GetCTSUCHTRCB_CHTRC32() uint32 {
	return volatile.LoadUint32(&o.CTSUCHTRCB.Reg) & 0x1
}
func (o *CTSU_Type) SetCTSUCHTRCB_CHTRC33(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCB.Reg, volatile.LoadUint32(&o.CTSUCHTRCB.Reg)&^(0x2)|value<<1)
}
func (o *CTSU_Type) GetCTSUCHTRCB_CHTRC33() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCB.Reg) & 0x2) >> 1
}
func (o *CTSU_Type) SetCTSUCHTRCB_CHTRC34(value uint32) {
	volatile.StoreUint32(&o.CTSUCHTRCB.Reg, volatile.LoadUint32(&o.CTSUCHTRCB.Reg)&^(0x4)|value<<2)
}
func (o *CTSU_Type) GetCTSUCHTRCB_CHTRC34() uint32 {
	return (volatile.LoadUint32(&o.CTSUCHTRCB.Reg) & 0x4) >> 2
}

// CTSU.CTSUSR: CTSU Status Register
func (o *CTSU_Type) SetCTSUSR_MFC(value uint32) {
	volatile.StoreUint32(&o.CTSUSR.Reg, volatile.LoadUint32(&o.CTSUSR.Reg)&^(0x3)|value)
}
func (o *CTSU_Type) GetCTSUSR_MFC() uint32 {
	return volatile.LoadUint32(&o.CTSUSR.Reg) & 0x3
}
func (o *CTSU_Type) SetCTSUSR_ICOMPRST(value uint32) {
	volatile.StoreUint32(&o.CTSUSR.Reg, volatile.LoadUint32(&o.CTSUSR.Reg)&^(0x20)|value<<5)
}
func (o *CTSU_Type) GetCTSUSR_ICOMPRST() uint32 {
	return (volatile.LoadUint32(&o.CTSUSR.Reg) & 0x20) >> 5
}
func (o *CTSU_Type) SetCTSUSR_ICOMP1(value uint32) {
	volatile.StoreUint32(&o.CTSUSR.Reg, volatile.LoadUint32(&o.CTSUSR.Reg)&^(0x40)|value<<6)
}
func (o *CTSU_Type) GetCTSUSR_ICOMP1() uint32 {
	return (volatile.LoadUint32(&o.CTSUSR.Reg) & 0x40) >> 6
}
func (o *CTSU_Type) SetCTSUSR_ICOMP0(value uint32) {
	volatile.StoreUint32(&o.CTSUSR.Reg, volatile.LoadUint32(&o.CTSUSR.Reg)&^(0x80)|value<<7)
}
func (o *CTSU_Type) GetCTSUSR_ICOMP0() uint32 {
	return (volatile.LoadUint32(&o.CTSUSR.Reg) & 0x80) >> 7
}
func (o *CTSU_Type) SetCTSUSR_STC(value uint32) {
	volatile.StoreUint32(&o.CTSUSR.Reg, volatile.LoadUint32(&o.CTSUSR.Reg)&^(0x700)|value<<8)
}
func (o *CTSU_Type) GetCTSUSR_STC() uint32 {
	return (volatile.LoadUint32(&o.CTSUSR.Reg) & 0x700) >> 8
}
func (o *CTSU_Type) SetCTSUSR_DTSR(value uint32) {
	volatile.StoreUint32(&o.CTSUSR.Reg, volatile.LoadUint32(&o.CTSUSR.Reg)&^(0x1000)|value<<12)
}
func (o *CTSU_Type) GetCTSUSR_DTSR() uint32 {
	return (volatile.LoadUint32(&o.CTSUSR.Reg) & 0x1000) >> 12
}
func (o *CTSU_Type) SetCTSUSR_SENSOVF(value uint32) {
	volatile.StoreUint32(&o.CTSUSR.Reg, volatile.LoadUint32(&o.CTSUSR.Reg)&^(0x2000)|value<<13)
}
func (o *CTSU_Type) GetCTSUSR_SENSOVF() uint32 {
	return (volatile.LoadUint32(&o.CTSUSR.Reg) & 0x2000) >> 13
}
func (o *CTSU_Type) SetCTSUSR_SUOVF(value uint32) {
	volatile.StoreUint32(&o.CTSUSR.Reg, volatile.LoadUint32(&o.CTSUSR.Reg)&^(0x4000)|value<<14)
}
func (o *CTSU_Type) GetCTSUSR_SUOVF() uint32 {
	return (volatile.LoadUint32(&o.CTSUSR.Reg) & 0x4000) >> 14
}
func (o *CTSU_Type) SetCTSUSR_PS(value uint32) {
	volatile.StoreUint32(&o.CTSUSR.Reg, volatile.LoadUint32(&o.CTSUSR.Reg)&^(0x8000)|value<<15)
}
func (o *CTSU_Type) GetCTSUSR_PS() uint32 {
	return (volatile.LoadUint32(&o.CTSUSR.Reg) & 0x8000) >> 15
}
func (o *CTSU_Type) SetCTSUSR_CFCRDCH(value uint32) {
	volatile.StoreUint32(&o.CTSUSR.Reg, volatile.LoadUint32(&o.CTSUSR.Reg)&^(0x3f0000)|value<<16)
}
func (o *CTSU_Type) GetCTSUSR_CFCRDCH() uint32 {
	return (volatile.LoadUint32(&o.CTSUSR.Reg) & 0x3f0000) >> 16
}

// CTSU.CTSUSO: CTSU Sensor Offset Register
func (o *CTSU_Type) SetCTSUSO_SO(value uint32) {
	volatile.StoreUint32(&o.CTSUSO.Reg, volatile.LoadUint32(&o.CTSUSO.Reg)&^(0x3ff)|value)
}
func (o *CTSU_Type) GetCTSUSO_SO() uint32 {
	return volatile.LoadUint32(&o.CTSUSO.Reg) & 0x3ff
}
func (o *CTSU_Type) SetCTSUSO_SNUM(value uint32) {
	volatile.StoreUint32(&o.CTSUSO.Reg, volatile.LoadUint32(&o.CTSUSO.Reg)&^(0x3fc00)|value<<10)
}
func (o *CTSU_Type) GetCTSUSO_SNUM() uint32 {
	return (volatile.LoadUint32(&o.CTSUSO.Reg) & 0x3fc00) >> 10
}
func (o *CTSU_Type) SetCTSUSO_SSDIV(value uint32) {
	volatile.StoreUint32(&o.CTSUSO.Reg, volatile.LoadUint32(&o.CTSUSO.Reg)&^(0xf00000)|value<<20)
}
func (o *CTSU_Type) GetCTSUSO_SSDIV() uint32 {
	return (volatile.LoadUint32(&o.CTSUSO.Reg) & 0xf00000) >> 20
}
func (o *CTSU_Type) SetCTSUSO_SDPA(value uint32) {
	volatile.StoreUint32(&o.CTSUSO.Reg, volatile.LoadUint32(&o.CTSUSO.Reg)&^(0xff000000)|value<<24)
}
func (o *CTSU_Type) GetCTSUSO_SDPA() uint32 {
	return (volatile.LoadUint32(&o.CTSUSO.Reg) & 0xff000000) >> 24
}

// CTSU.CTSUSCNT: CTSU Sensor Counter Register
func (o *CTSU_Type) SetCTSUSCNT_SENSCNT(value uint32) {
	volatile.StoreUint32(&o.CTSUSCNT.Reg, volatile.LoadUint32(&o.CTSUSCNT.Reg)&^(0xffff)|value)
}
func (o *CTSU_Type) GetCTSUSCNT_SENSCNT() uint32 {
	return volatile.LoadUint32(&o.CTSUSCNT.Reg) & 0xffff
}
func (o *CTSU_Type) SetCTSUSCNT_SUCKCNT(value uint32) {
	volatile.StoreUint32(&o.CTSUSCNT.Reg, volatile.LoadUint32(&o.CTSUSCNT.Reg)&^(0xffff0000)|value<<16)
}
func (o *CTSU_Type) GetCTSUSCNT_SUCKCNT() uint32 {
	return (volatile.LoadUint32(&o.CTSUSCNT.Reg) & 0xffff0000) >> 16
}

// CTSU.CTSUCALIB: CTSU Calibration Register
func (o *CTSU_Type) SetCTSUCALIB_TSOD(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x4)|value<<2)
}
func (o *CTSU_Type) GetCTSUCALIB_TSOD() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x4) >> 2
}
func (o *CTSU_Type) SetCTSUCALIB_DRV(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x8)|value<<3)
}
func (o *CTSU_Type) GetCTSUCALIB_DRV() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x8) >> 3
}
func (o *CTSU_Type) SetCTSUCALIB_CLKSEL(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x30)|value<<4)
}
func (o *CTSU_Type) GetCTSUCALIB_CLKSEL() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x30) >> 4
}
func (o *CTSU_Type) SetCTSUCALIB_SUCLKEN(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x40)|value<<6)
}
func (o *CTSU_Type) GetCTSUCALIB_SUCLKEN() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x40) >> 6
}
func (o *CTSU_Type) SetCTSUCALIB_TSOC(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x80)|value<<7)
}
func (o *CTSU_Type) GetCTSUCALIB_TSOC() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x80) >> 7
}
func (o *CTSU_Type) SetCTSUCALIB_CNTRDSEL(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x100)|value<<8)
}
func (o *CTSU_Type) GetCTSUCALIB_CNTRDSEL() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x100) >> 8
}
func (o *CTSU_Type) SetCTSUCALIB_IOC(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x200)|value<<9)
}
func (o *CTSU_Type) GetCTSUCALIB_IOC() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x200) >> 9
}
func (o *CTSU_Type) SetCTSUCALIB_CFCRDMD(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x400)|value<<10)
}
func (o *CTSU_Type) GetCTSUCALIB_CFCRDMD() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x400) >> 10
}
func (o *CTSU_Type) SetCTSUCALIB_DCOFF(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x800)|value<<11)
}
func (o *CTSU_Type) GetCTSUCALIB_DCOFF() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x800) >> 11
}
func (o *CTSU_Type) SetCTSUCALIB_CFCSEL(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x3f0000)|value<<16)
}
func (o *CTSU_Type) GetCTSUCALIB_CFCSEL() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x3f0000) >> 16
}
func (o *CTSU_Type) SetCTSUCALIB_CFCMODE(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x400000)|value<<22)
}
func (o *CTSU_Type) GetCTSUCALIB_CFCMODE() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x400000) >> 22
}
func (o *CTSU_Type) SetCTSUCALIB_DACMSEL(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x1000000)|value<<24)
}
func (o *CTSU_Type) GetCTSUCALIB_DACMSEL() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x1000000) >> 24
}
func (o *CTSU_Type) SetCTSUCALIB_DACCARRY(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x2000000)|value<<25)
}
func (o *CTSU_Type) GetCTSUCALIB_DACCARRY() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x2000000) >> 25
}
func (o *CTSU_Type) SetCTSUCALIB_SUMSEL(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x4000000)|value<<26)
}
func (o *CTSU_Type) GetCTSUCALIB_SUMSEL() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x4000000) >> 26
}
func (o *CTSU_Type) SetCTSUCALIB_SUCARRY(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x8000000)|value<<27)
}
func (o *CTSU_Type) GetCTSUCALIB_SUCARRY() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x8000000) >> 27
}
func (o *CTSU_Type) SetCTSUCALIB_DACCLK(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x10000000)|value<<28)
}
func (o *CTSU_Type) GetCTSUCALIB_DACCLK() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x10000000) >> 28
}
func (o *CTSU_Type) SetCTSUCALIB_CCOCLK(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x20000000)|value<<29)
}
func (o *CTSU_Type) GetCTSUCALIB_CCOCLK() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x20000000) >> 29
}
func (o *CTSU_Type) SetCTSUCALIB_CCOCALIB(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x40000000)|value<<30)
}
func (o *CTSU_Type) GetCTSUCALIB_CCOCALIB() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x40000000) >> 30
}
func (o *CTSU_Type) SetCTSUCALIB_TXREV(value uint32) {
	volatile.StoreUint32(&o.CTSUCALIB.Reg, volatile.LoadUint32(&o.CTSUCALIB.Reg)&^(0x80000000)|value<<31)
}
func (o *CTSU_Type) GetCTSUCALIB_TXREV() uint32 {
	return (volatile.LoadUint32(&o.CTSUCALIB.Reg) & 0x80000000) >> 31
}

// CTSU.CTSUSUCLKB: CTSU Sensor Unit Clock Control Register B
func (o *CTSU_Type) SetCTSUSUCLKB_SUADJ2(value uint32) {
	volatile.StoreUint32(&o.CTSUSUCLKB.Reg, volatile.LoadUint32(&o.CTSUSUCLKB.Reg)&^(0xff)|value)
}
func (o *CTSU_Type) GetCTSUSUCLKB_SUADJ2() uint32 {
	return volatile.LoadUint32(&o.CTSUSUCLKB.Reg) & 0xff
}
func (o *CTSU_Type) SetCTSUSUCLKB_SUMULTI2(value uint32) {
	volatile.StoreUint32(&o.CTSUSUCLKB.Reg, volatile.LoadUint32(&o.CTSUSUCLKB.Reg)&^(0xff00)|value<<8)
}
func (o *CTSU_Type) GetCTSUSUCLKB_SUMULTI2() uint32 {
	return (volatile.LoadUint32(&o.CTSUSUCLKB.Reg) & 0xff00) >> 8
}
func (o *CTSU_Type) SetCTSUSUCLKB_SUADJ3(value uint32) {
	volatile.StoreUint32(&o.CTSUSUCLKB.Reg, volatile.LoadUint32(&o.CTSUSUCLKB.Reg)&^(0xff0000)|value<<16)
}
func (o *CTSU_Type) GetCTSUSUCLKB_SUADJ3() uint32 {
	return (volatile.LoadUint32(&o.CTSUSUCLKB.Reg) & 0xff0000) >> 16
}
func (o *CTSU_Type) SetCTSUSUCLKB_SUMULTI3(value uint32) {
	volatile.StoreUint32(&o.CTSUSUCLKB.Reg, volatile.LoadUint32(&o.CTSUSUCLKB.Reg)&^(0xff000000)|value<<24)
}
func (o *CTSU_Type) GetCTSUSUCLKB_SUMULTI3() uint32 {
	return (volatile.LoadUint32(&o.CTSUSUCLKB.Reg) & 0xff000000) >> 24
}

// CTSU.CTSUCFCCNT: CTSU CFC Counter Register
func (o *CTSU_Type) SetCTSUCFCCNT_CFCCNT(value uint32) {
	volatile.StoreUint32(&o.CTSUCFCCNT.Reg, volatile.LoadUint32(&o.CTSUCFCCNT.Reg)&^(0xffff)|value)
}
func (o *CTSU_Type) GetCTSUCFCCNT_CFCCNT() uint32 {
	return volatile.LoadUint32(&o.CTSUCFCCNT.Reg) & 0xffff
}

// Low Power Asynchronous General Purpose Timer 0
type AGT0_Type struct {
	AGT      volatile.Register16 // 0x0
	AGTCMA   volatile.Register16 // 0x2
	AGTCMB   volatile.Register16 // 0x4
	_        [2]byte
	AGTCR    volatile.Register8 // 0x8
	AGTMR1   volatile.Register8 // 0x9
	AGTMR2   volatile.Register8 // 0xA
	_        byte
	AGTIOC   volatile.Register8 // 0xC
	AGTISR   volatile.Register8 // 0xD
	AGTCMSR  volatile.Register8 // 0xE
	AGTIOSEL volatile.Register8 // 0xF
}

// AGT0.AGTCR: AGT Control Register
func (o *AGT0_Type) SetAGTCR_TSTART(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x1)|value)
}
func (o *AGT0_Type) GetAGTCR_TSTART() uint8 {
	return volatile.LoadUint8(&o.AGTCR.Reg) & 0x1
}
func (o *AGT0_Type) SetAGTCR_TCSTF(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x2)|value<<1)
}
func (o *AGT0_Type) GetAGTCR_TCSTF() uint8 {
	return (volatile.LoadUint8(&o.AGTCR.Reg) & 0x2) >> 1
}
func (o *AGT0_Type) SetAGTCR_TSTOP(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x4)|value<<2)
}
func (o *AGT0_Type) GetAGTCR_TSTOP() uint8 {
	return (volatile.LoadUint8(&o.AGTCR.Reg) & 0x4) >> 2
}
func (o *AGT0_Type) SetAGTCR_TEDGF(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x10)|value<<4)
}
func (o *AGT0_Type) GetAGTCR_TEDGF() uint8 {
	return (volatile.LoadUint8(&o.AGTCR.Reg) & 0x10) >> 4
}
func (o *AGT0_Type) SetAGTCR_TUNDF(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x20)|value<<5)
}
func (o *AGT0_Type) GetAGTCR_TUNDF() uint8 {
	return (volatile.LoadUint8(&o.AGTCR.Reg) & 0x20) >> 5
}
func (o *AGT0_Type) SetAGTCR_TCMAF(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x40)|value<<6)
}
func (o *AGT0_Type) GetAGTCR_TCMAF() uint8 {
	return (volatile.LoadUint8(&o.AGTCR.Reg) & 0x40) >> 6
}
func (o *AGT0_Type) SetAGTCR_TCMBF(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x80)|value<<7)
}
func (o *AGT0_Type) GetAGTCR_TCMBF() uint8 {
	return (volatile.LoadUint8(&o.AGTCR.Reg) & 0x80) >> 7
}

// AGT0.AGTMR1: AGT Mode Register 1
func (o *AGT0_Type) SetAGTMR1_TMOD(value uint8) {
	volatile.StoreUint8(&o.AGTMR1.Reg, volatile.LoadUint8(&o.AGTMR1.Reg)&^(0x7)|value)
}
func (o *AGT0_Type) GetAGTMR1_TMOD() uint8 {
	return volatile.LoadUint8(&o.AGTMR1.Reg) & 0x7
}
func (o *AGT0_Type) SetAGTMR1_TEDGPL(value uint8) {
	volatile.StoreUint8(&o.AGTMR1.Reg, volatile.LoadUint8(&o.AGTMR1.Reg)&^(0x8)|value<<3)
}
func (o *AGT0_Type) GetAGTMR1_TEDGPL() uint8 {
	return (volatile.LoadUint8(&o.AGTMR1.Reg) & 0x8) >> 3
}
func (o *AGT0_Type) SetAGTMR1_TCK(value uint8) {
	volatile.StoreUint8(&o.AGTMR1.Reg, volatile.LoadUint8(&o.AGTMR1.Reg)&^(0x70)|value<<4)
}
func (o *AGT0_Type) GetAGTMR1_TCK() uint8 {
	return (volatile.LoadUint8(&o.AGTMR1.Reg) & 0x70) >> 4
}

// AGT0.AGTMR2: AGT Mode Register 2
func (o *AGT0_Type) SetAGTMR2_CKS(value uint8) {
	volatile.StoreUint8(&o.AGTMR2.Reg, volatile.LoadUint8(&o.AGTMR2.Reg)&^(0x7)|value)
}
func (o *AGT0_Type) GetAGTMR2_CKS() uint8 {
	return volatile.LoadUint8(&o.AGTMR2.Reg) & 0x7
}
func (o *AGT0_Type) SetAGTMR2_LPM(value uint8) {
	volatile.StoreUint8(&o.AGTMR2.Reg, volatile.LoadUint8(&o.AGTMR2.Reg)&^(0x80)|value<<7)
}
func (o *AGT0_Type) GetAGTMR2_LPM() uint8 {
	return (volatile.LoadUint8(&o.AGTMR2.Reg) & 0x80) >> 7
}

// AGT0.AGTIOC: AGT I/O Control Register
func (o *AGT0_Type) SetAGTIOC_TEDGSEL(value uint8) {
	volatile.StoreUint8(&o.AGTIOC.Reg, volatile.LoadUint8(&o.AGTIOC.Reg)&^(0x1)|value)
}
func (o *AGT0_Type) GetAGTIOC_TEDGSEL() uint8 {
	return volatile.LoadUint8(&o.AGTIOC.Reg) & 0x1
}
func (o *AGT0_Type) SetAGTIOC_TOE(value uint8) {
	volatile.StoreUint8(&o.AGTIOC.Reg, volatile.LoadUint8(&o.AGTIOC.Reg)&^(0x4)|value<<2)
}
func (o *AGT0_Type) GetAGTIOC_TOE() uint8 {
	return (volatile.LoadUint8(&o.AGTIOC.Reg) & 0x4) >> 2
}
func (o *AGT0_Type) SetAGTIOC_TIPF(value uint8) {
	volatile.StoreUint8(&o.AGTIOC.Reg, volatile.LoadUint8(&o.AGTIOC.Reg)&^(0x30)|value<<4)
}
func (o *AGT0_Type) GetAGTIOC_TIPF() uint8 {
	return (volatile.LoadUint8(&o.AGTIOC.Reg) & 0x30) >> 4
}
func (o *AGT0_Type) SetAGTIOC_TIOGT(value uint8) {
	volatile.StoreUint8(&o.AGTIOC.Reg, volatile.LoadUint8(&o.AGTIOC.Reg)&^(0xc0)|value<<6)
}
func (o *AGT0_Type) GetAGTIOC_TIOGT() uint8 {
	return (volatile.LoadUint8(&o.AGTIOC.Reg) & 0xc0) >> 6
}

// AGT0.AGTISR: AGT Event Pin Select Register
func (o *AGT0_Type) SetAGTISR_EEPS(value uint8) {
	volatile.StoreUint8(&o.AGTISR.Reg, volatile.LoadUint8(&o.AGTISR.Reg)&^(0x4)|value<<2)
}
func (o *AGT0_Type) GetAGTISR_EEPS() uint8 {
	return (volatile.LoadUint8(&o.AGTISR.Reg) & 0x4) >> 2
}

// AGT0.AGTCMSR: AGT Compare Match Function Select Register
func (o *AGT0_Type) SetAGTCMSR_TCMEA(value uint8) {
	volatile.StoreUint8(&o.AGTCMSR.Reg, volatile.LoadUint8(&o.AGTCMSR.Reg)&^(0x1)|value)
}
func (o *AGT0_Type) GetAGTCMSR_TCMEA() uint8 {
	return volatile.LoadUint8(&o.AGTCMSR.Reg) & 0x1
}
func (o *AGT0_Type) SetAGTCMSR_TOEA(value uint8) {
	volatile.StoreUint8(&o.AGTCMSR.Reg, volatile.LoadUint8(&o.AGTCMSR.Reg)&^(0x2)|value<<1)
}
func (o *AGT0_Type) GetAGTCMSR_TOEA() uint8 {
	return (volatile.LoadUint8(&o.AGTCMSR.Reg) & 0x2) >> 1
}
func (o *AGT0_Type) SetAGTCMSR_TOPOLA(value uint8) {
	volatile.StoreUint8(&o.AGTCMSR.Reg, volatile.LoadUint8(&o.AGTCMSR.Reg)&^(0x4)|value<<2)
}
func (o *AGT0_Type) GetAGTCMSR_TOPOLA() uint8 {
	return (volatile.LoadUint8(&o.AGTCMSR.Reg) & 0x4) >> 2
}
func (o *AGT0_Type) SetAGTCMSR_TCMEB(value uint8) {
	volatile.StoreUint8(&o.AGTCMSR.Reg, volatile.LoadUint8(&o.AGTCMSR.Reg)&^(0x10)|value<<4)
}
func (o *AGT0_Type) GetAGTCMSR_TCMEB() uint8 {
	return (volatile.LoadUint8(&o.AGTCMSR.Reg) & 0x10) >> 4
}
func (o *AGT0_Type) SetAGTCMSR_TOEB(value uint8) {
	volatile.StoreUint8(&o.AGTCMSR.Reg, volatile.LoadUint8(&o.AGTCMSR.Reg)&^(0x20)|value<<5)
}
func (o *AGT0_Type) GetAGTCMSR_TOEB() uint8 {
	return (volatile.LoadUint8(&o.AGTCMSR.Reg) & 0x20) >> 5
}
func (o *AGT0_Type) SetAGTCMSR_TOPOLB(value uint8) {
	volatile.StoreUint8(&o.AGTCMSR.Reg, volatile.LoadUint8(&o.AGTCMSR.Reg)&^(0x40)|value<<6)
}
func (o *AGT0_Type) GetAGTCMSR_TOPOLB() uint8 {
	return (volatile.LoadUint8(&o.AGTCMSR.Reg) & 0x40) >> 6
}

// AGT0.AGTIOSEL: AGT Pin Select Register
func (o *AGT0_Type) SetAGTIOSEL_SEL(value uint8) {
	volatile.StoreUint8(&o.AGTIOSEL.Reg, volatile.LoadUint8(&o.AGTIOSEL.Reg)&^(0x3)|value)
}
func (o *AGT0_Type) GetAGTIOSEL_SEL() uint8 {
	return volatile.LoadUint8(&o.AGTIOSEL.Reg) & 0x3
}
func (o *AGT0_Type) SetAGTIOSEL_TIES(value uint8) {
	volatile.StoreUint8(&o.AGTIOSEL.Reg, volatile.LoadUint8(&o.AGTIOSEL.Reg)&^(0x10)|value<<4)
}
func (o *AGT0_Type) GetAGTIOSEL_TIES() uint8 {
	return (volatile.LoadUint8(&o.AGTIOSEL.Reg) & 0x10) >> 4
}

// Low-Power Analog Comparator
type ACMPLP_Type struct {
	COMPMDR volatile.Register8 // 0x0
	COMPFIR volatile.Register8 // 0x1
	COMPOCR volatile.Register8 // 0x2
}

// ACMPLP.COMPMDR: ACMPLP Mode Setting Register
func (o *ACMPLP_Type) SetCOMPMDR_C0ENB(value uint8) {
	volatile.StoreUint8(&o.COMPMDR.Reg, volatile.LoadUint8(&o.COMPMDR.Reg)&^(0x1)|value)
}
func (o *ACMPLP_Type) GetCOMPMDR_C0ENB() uint8 {
	return volatile.LoadUint8(&o.COMPMDR.Reg) & 0x1
}
func (o *ACMPLP_Type) SetCOMPMDR_C0WDE(value uint8) {
	volatile.StoreUint8(&o.COMPMDR.Reg, volatile.LoadUint8(&o.COMPMDR.Reg)&^(0x2)|value<<1)
}
func (o *ACMPLP_Type) GetCOMPMDR_C0WDE() uint8 {
	return (volatile.LoadUint8(&o.COMPMDR.Reg) & 0x2) >> 1
}
func (o *ACMPLP_Type) SetCOMPMDR_C0VRF(value uint8) {
	volatile.StoreUint8(&o.COMPMDR.Reg, volatile.LoadUint8(&o.COMPMDR.Reg)&^(0x4)|value<<2)
}
func (o *ACMPLP_Type) GetCOMPMDR_C0VRF() uint8 {
	return (volatile.LoadUint8(&o.COMPMDR.Reg) & 0x4) >> 2
}
func (o *ACMPLP_Type) SetCOMPMDR_C0MON(value uint8) {
	volatile.StoreUint8(&o.COMPMDR.Reg, volatile.LoadUint8(&o.COMPMDR.Reg)&^(0x8)|value<<3)
}
func (o *ACMPLP_Type) GetCOMPMDR_C0MON() uint8 {
	return (volatile.LoadUint8(&o.COMPMDR.Reg) & 0x8) >> 3
}
func (o *ACMPLP_Type) SetCOMPMDR_C1ENB(value uint8) {
	volatile.StoreUint8(&o.COMPMDR.Reg, volatile.LoadUint8(&o.COMPMDR.Reg)&^(0x10)|value<<4)
}
func (o *ACMPLP_Type) GetCOMPMDR_C1ENB() uint8 {
	return (volatile.LoadUint8(&o.COMPMDR.Reg) & 0x10) >> 4
}
func (o *ACMPLP_Type) SetCOMPMDR_C1WDE(value uint8) {
	volatile.StoreUint8(&o.COMPMDR.Reg, volatile.LoadUint8(&o.COMPMDR.Reg)&^(0x20)|value<<5)
}
func (o *ACMPLP_Type) GetCOMPMDR_C1WDE() uint8 {
	return (volatile.LoadUint8(&o.COMPMDR.Reg) & 0x20) >> 5
}
func (o *ACMPLP_Type) SetCOMPMDR_C1VRF(value uint8) {
	volatile.StoreUint8(&o.COMPMDR.Reg, volatile.LoadUint8(&o.COMPMDR.Reg)&^(0x40)|value<<6)
}
func (o *ACMPLP_Type) GetCOMPMDR_C1VRF() uint8 {
	return (volatile.LoadUint8(&o.COMPMDR.Reg) & 0x40) >> 6
}
func (o *ACMPLP_Type) SetCOMPMDR_C1MON(value uint8) {
	volatile.StoreUint8(&o.COMPMDR.Reg, volatile.LoadUint8(&o.COMPMDR.Reg)&^(0x80)|value<<7)
}
func (o *ACMPLP_Type) GetCOMPMDR_C1MON() uint8 {
	return (volatile.LoadUint8(&o.COMPMDR.Reg) & 0x80) >> 7
}

// ACMPLP.COMPFIR: ACMPLP Filter Control Register
func (o *ACMPLP_Type) SetCOMPFIR_C0FCK(value uint8) {
	volatile.StoreUint8(&o.COMPFIR.Reg, volatile.LoadUint8(&o.COMPFIR.Reg)&^(0x3)|value)
}
func (o *ACMPLP_Type) GetCOMPFIR_C0FCK() uint8 {
	return volatile.LoadUint8(&o.COMPFIR.Reg) & 0x3
}
func (o *ACMPLP_Type) SetCOMPFIR_C0EPO(value uint8) {
	volatile.StoreUint8(&o.COMPFIR.Reg, volatile.LoadUint8(&o.COMPFIR.Reg)&^(0x4)|value<<2)
}
func (o *ACMPLP_Type) GetCOMPFIR_C0EPO() uint8 {
	return (volatile.LoadUint8(&o.COMPFIR.Reg) & 0x4) >> 2
}
func (o *ACMPLP_Type) SetCOMPFIR_C0EDG(value uint8) {
	volatile.StoreUint8(&o.COMPFIR.Reg, volatile.LoadUint8(&o.COMPFIR.Reg)&^(0x8)|value<<3)
}
func (o *ACMPLP_Type) GetCOMPFIR_C0EDG() uint8 {
	return (volatile.LoadUint8(&o.COMPFIR.Reg) & 0x8) >> 3
}
func (o *ACMPLP_Type) SetCOMPFIR_C1FCK(value uint8) {
	volatile.StoreUint8(&o.COMPFIR.Reg, volatile.LoadUint8(&o.COMPFIR.Reg)&^(0x30)|value<<4)
}
func (o *ACMPLP_Type) GetCOMPFIR_C1FCK() uint8 {
	return (volatile.LoadUint8(&o.COMPFIR.Reg) & 0x30) >> 4
}
func (o *ACMPLP_Type) SetCOMPFIR_C1EPO(value uint8) {
	volatile.StoreUint8(&o.COMPFIR.Reg, volatile.LoadUint8(&o.COMPFIR.Reg)&^(0x40)|value<<6)
}
func (o *ACMPLP_Type) GetCOMPFIR_C1EPO() uint8 {
	return (volatile.LoadUint8(&o.COMPFIR.Reg) & 0x40) >> 6
}
func (o *ACMPLP_Type) SetCOMPFIR_C1EDG(value uint8) {
	volatile.StoreUint8(&o.COMPFIR.Reg, volatile.LoadUint8(&o.COMPFIR.Reg)&^(0x80)|value<<7)
}
func (o *ACMPLP_Type) GetCOMPFIR_C1EDG() uint8 {
	return (volatile.LoadUint8(&o.COMPFIR.Reg) & 0x80) >> 7
}

// ACMPLP.COMPOCR: ACMPLP Output Control Register
func (o *ACMPLP_Type) SetCOMPOCR_C0OE(value uint8) {
	volatile.StoreUint8(&o.COMPOCR.Reg, volatile.LoadUint8(&o.COMPOCR.Reg)&^(0x2)|value<<1)
}
func (o *ACMPLP_Type) GetCOMPOCR_C0OE() uint8 {
	return (volatile.LoadUint8(&o.COMPOCR.Reg) & 0x2) >> 1
}
func (o *ACMPLP_Type) SetCOMPOCR_C0OP(value uint8) {
	volatile.StoreUint8(&o.COMPOCR.Reg, volatile.LoadUint8(&o.COMPOCR.Reg)&^(0x4)|value<<2)
}
func (o *ACMPLP_Type) GetCOMPOCR_C0OP() uint8 {
	return (volatile.LoadUint8(&o.COMPOCR.Reg) & 0x4) >> 2
}
func (o *ACMPLP_Type) SetCOMPOCR_C1OE(value uint8) {
	volatile.StoreUint8(&o.COMPOCR.Reg, volatile.LoadUint8(&o.COMPOCR.Reg)&^(0x20)|value<<5)
}
func (o *ACMPLP_Type) GetCOMPOCR_C1OE() uint8 {
	return (volatile.LoadUint8(&o.COMPOCR.Reg) & 0x20) >> 5
}
func (o *ACMPLP_Type) SetCOMPOCR_C1OP(value uint8) {
	volatile.StoreUint8(&o.COMPOCR.Reg, volatile.LoadUint8(&o.COMPOCR.Reg)&^(0x40)|value<<6)
}
func (o *ACMPLP_Type) GetCOMPOCR_C1OP() uint8 {
	return (volatile.LoadUint8(&o.COMPOCR.Reg) & 0x40) >> 6
}
func (o *ACMPLP_Type) SetCOMPOCR_SPDMD(value uint8) {
	volatile.StoreUint8(&o.COMPOCR.Reg, volatile.LoadUint8(&o.COMPOCR.Reg)&^(0x80)|value<<7)
}
func (o *ACMPLP_Type) GetCOMPOCR_SPDMD() uint8 {
	return (volatile.LoadUint8(&o.COMPOCR.Reg) & 0x80) >> 7
}

// Flash I/O Registers
type FLCN_Type struct {
	_         [144]byte
	DFLCTL    volatile.Register8 // 0x90
	_         [111]byte
	FPMCR     volatile.Register8 // 0x100
	_         [3]byte
	FASR      volatile.Register8 // 0x104
	_         [3]byte
	FSARL     volatile.Register16 // 0x108
	_         [6]byte
	FSARH     volatile.Register16 // 0x110
	_         [2]byte
	FCR       volatile.Register8 // 0x114
	_         [3]byte
	FEARL     volatile.Register16 // 0x118
	_         [6]byte
	FEARH     volatile.Register16 // 0x120
	_         [2]byte
	FRESETR   volatile.Register8 // 0x124
	_         [7]byte
	FSTATR1   volatile.Register8 // 0x12C
	_         [3]byte
	FWBL0     volatile.Register16 // 0x130
	_         [6]byte
	FWBH0     volatile.Register16 // 0x138
	_         [70]byte
	FPR       volatile.Register8 // 0x180
	_         [3]byte
	FPSR      volatile.Register8 // 0x184
	_         [3]byte
	FRBL0     volatile.Register16 // 0x188
	_         [6]byte
	FRBH0     volatile.Register16 // 0x190
	_         [46]byte
	FSCMR     volatile.Register16 // 0x1C0
	_         [6]byte
	FAWSMR    volatile.Register16 // 0x1C8
	_         [6]byte
	FAWEMR    volatile.Register16 // 0x1D0
	_         [6]byte
	FISR      volatile.Register8 // 0x1D8
	_         [3]byte
	FEXCR     volatile.Register8 // 0x1DC
	_         [3]byte
	FEAML     volatile.Register16 // 0x1E0
	_         [6]byte
	FEAMH     volatile.Register16 // 0x1E8
	_         [6]byte
	FSTATR2   volatile.Register16 // 0x1F0
	_         [54]byte
	TSCDR     volatile.Register32 // 0x228
	_         [376]byte
	CTSUTRIMA volatile.Register32 // 0x3A4
	CTSUTRIMB volatile.Register32 // 0x3A8
	_         [15364]byte
	FENTRYR   volatile.Register16 // 0x3FB0
	_         [18]byte
	FLDWAITR  volatile.Register8 // 0x3FC4
	_         [3]byte
	PFBER     volatile.Register8 // 0x3FC8
}

// FLCN.DFLCTL: Data Flash Control Register
func (o *FLCN_Type) SetDFLCTL_DFLEN(value uint8) {
	volatile.StoreUint8(&o.DFLCTL.Reg, volatile.LoadUint8(&o.DFLCTL.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetDFLCTL_DFLEN() uint8 {
	return volatile.LoadUint8(&o.DFLCTL.Reg) & 0x1
}

// FLCN.FPMCR: Flash P/E Mode Control Register
func (o *FLCN_Type) SetFPMCR_FMS0(value uint8) {
	volatile.StoreUint8(&o.FPMCR.Reg, volatile.LoadUint8(&o.FPMCR.Reg)&^(0x2)|value<<1)
}
func (o *FLCN_Type) GetFPMCR_FMS0() uint8 {
	return (volatile.LoadUint8(&o.FPMCR.Reg) & 0x2) >> 1
}
func (o *FLCN_Type) SetFPMCR_RPDIS(value uint8) {
	volatile.StoreUint8(&o.FPMCR.Reg, volatile.LoadUint8(&o.FPMCR.Reg)&^(0x8)|value<<3)
}
func (o *FLCN_Type) GetFPMCR_RPDIS() uint8 {
	return (volatile.LoadUint8(&o.FPMCR.Reg) & 0x8) >> 3
}
func (o *FLCN_Type) SetFPMCR_FMS1(value uint8) {
	volatile.StoreUint8(&o.FPMCR.Reg, volatile.LoadUint8(&o.FPMCR.Reg)&^(0x10)|value<<4)
}
func (o *FLCN_Type) GetFPMCR_FMS1() uint8 {
	return (volatile.LoadUint8(&o.FPMCR.Reg) & 0x10) >> 4
}

// FLCN.FASR: Flash Area Select Register
func (o *FLCN_Type) SetFASR_EXS(value uint8) {
	volatile.StoreUint8(&o.FASR.Reg, volatile.LoadUint8(&o.FASR.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetFASR_EXS() uint8 {
	return volatile.LoadUint8(&o.FASR.Reg) & 0x1
}

// FLCN.FSARL: Flash Processing Start Address Register L
func (o *FLCN_Type) SetFSARL(value uint16) {
	volatile.StoreUint16(&o.FSARL.Reg, value)
}
func (o *FLCN_Type) GetFSARL() uint16 {
	return volatile.LoadUint16(&o.FSARL.Reg)
}

// FLCN.FSARH: Flash Processing Start Address Register H
func (o *FLCN_Type) SetFSARH(value uint16) {
	volatile.StoreUint16(&o.FSARH.Reg, value)
}
func (o *FLCN_Type) GetFSARH() uint16 {
	return volatile.LoadUint16(&o.FSARH.Reg)
}

// FLCN.FCR: Flash Control Register
func (o *FLCN_Type) SetFCR_CMD(value uint8) {
	volatile.StoreUint8(&o.FCR.Reg, volatile.LoadUint8(&o.FCR.Reg)&^(0xf)|value)
}
func (o *FLCN_Type) GetFCR_CMD() uint8 {
	return volatile.LoadUint8(&o.FCR.Reg) & 0xf
}
func (o *FLCN_Type) SetFCR_DRC(value uint8) {
	volatile.StoreUint8(&o.FCR.Reg, volatile.LoadUint8(&o.FCR.Reg)&^(0x10)|value<<4)
}
func (o *FLCN_Type) GetFCR_DRC() uint8 {
	return (volatile.LoadUint8(&o.FCR.Reg) & 0x10) >> 4
}
func (o *FLCN_Type) SetFCR_STOP(value uint8) {
	volatile.StoreUint8(&o.FCR.Reg, volatile.LoadUint8(&o.FCR.Reg)&^(0x40)|value<<6)
}
func (o *FLCN_Type) GetFCR_STOP() uint8 {
	return (volatile.LoadUint8(&o.FCR.Reg) & 0x40) >> 6
}
func (o *FLCN_Type) SetFCR_OPST(value uint8) {
	volatile.StoreUint8(&o.FCR.Reg, volatile.LoadUint8(&o.FCR.Reg)&^(0x80)|value<<7)
}
func (o *FLCN_Type) GetFCR_OPST() uint8 {
	return (volatile.LoadUint8(&o.FCR.Reg) & 0x80) >> 7
}

// FLCN.FEARL: Flash Processing End Address Register L
func (o *FLCN_Type) SetFEARL(value uint16) {
	volatile.StoreUint16(&o.FEARL.Reg, value)
}
func (o *FLCN_Type) GetFEARL() uint16 {
	return volatile.LoadUint16(&o.FEARL.Reg)
}

// FLCN.FEARH: Flash Processing End Address Register H
func (o *FLCN_Type) SetFEARH(value uint16) {
	volatile.StoreUint16(&o.FEARH.Reg, value)
}
func (o *FLCN_Type) GetFEARH() uint16 {
	return volatile.LoadUint16(&o.FEARH.Reg)
}

// FLCN.FRESETR: Flash Reset Register
func (o *FLCN_Type) SetFRESETR_FRESET(value uint8) {
	volatile.StoreUint8(&o.FRESETR.Reg, volatile.LoadUint8(&o.FRESETR.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetFRESETR_FRESET() uint8 {
	return volatile.LoadUint8(&o.FRESETR.Reg) & 0x1
}

// FLCN.FSTATR1: Flash Status Register 1
func (o *FLCN_Type) SetFSTATR1_DRRDY(value uint8) {
	volatile.StoreUint8(&o.FSTATR1.Reg, volatile.LoadUint8(&o.FSTATR1.Reg)&^(0x2)|value<<1)
}
func (o *FLCN_Type) GetFSTATR1_DRRDY() uint8 {
	return (volatile.LoadUint8(&o.FSTATR1.Reg) & 0x2) >> 1
}
func (o *FLCN_Type) SetFSTATR1_FRDY(value uint8) {
	volatile.StoreUint8(&o.FSTATR1.Reg, volatile.LoadUint8(&o.FSTATR1.Reg)&^(0x40)|value<<6)
}
func (o *FLCN_Type) GetFSTATR1_FRDY() uint8 {
	return (volatile.LoadUint8(&o.FSTATR1.Reg) & 0x40) >> 6
}
func (o *FLCN_Type) SetFSTATR1_EXRDY(value uint8) {
	volatile.StoreUint8(&o.FSTATR1.Reg, volatile.LoadUint8(&o.FSTATR1.Reg)&^(0x80)|value<<7)
}
func (o *FLCN_Type) GetFSTATR1_EXRDY() uint8 {
	return (volatile.LoadUint8(&o.FSTATR1.Reg) & 0x80) >> 7
}

// FLCN.FWBL0: Flash Write Buffer Register L0
func (o *FLCN_Type) SetFWBL0(value uint16) {
	volatile.StoreUint16(&o.FWBL0.Reg, value)
}
func (o *FLCN_Type) GetFWBL0() uint16 {
	return volatile.LoadUint16(&o.FWBL0.Reg)
}

// FLCN.FWBH0: Flash Write Buffer Register H0
func (o *FLCN_Type) SetFWBH0(value uint16) {
	volatile.StoreUint16(&o.FWBH0.Reg, value)
}
func (o *FLCN_Type) GetFWBH0() uint16 {
	return volatile.LoadUint16(&o.FWBH0.Reg)
}

// FLCN.FPR: Protection Unlock Register
func (o *FLCN_Type) SetFPR(value uint8) {
	volatile.StoreUint8(&o.FPR.Reg, value)
}
func (o *FLCN_Type) GetFPR() uint8 {
	return volatile.LoadUint8(&o.FPR.Reg)
}

// FLCN.FPSR: Protection Unlock Status Register
func (o *FLCN_Type) SetFPSR_PERR(value uint8) {
	volatile.StoreUint8(&o.FPSR.Reg, volatile.LoadUint8(&o.FPSR.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetFPSR_PERR() uint8 {
	return volatile.LoadUint8(&o.FPSR.Reg) & 0x1
}

// FLCN.FRBL0: Flash Read Buffer Register L0
func (o *FLCN_Type) SetFRBL0(value uint16) {
	volatile.StoreUint16(&o.FRBL0.Reg, value)
}
func (o *FLCN_Type) GetFRBL0() uint16 {
	return volatile.LoadUint16(&o.FRBL0.Reg)
}

// FLCN.FRBH0: Flash Read Buffer Register H0
func (o *FLCN_Type) SetFRBH0(value uint16) {
	volatile.StoreUint16(&o.FRBH0.Reg, value)
}
func (o *FLCN_Type) GetFRBH0() uint16 {
	return volatile.LoadUint16(&o.FRBH0.Reg)
}

// FLCN.FSCMR: Flash Start-Up Setting Monitor Register
func (o *FLCN_Type) SetFSCMR_SASMF(value uint16) {
	volatile.StoreUint16(&o.FSCMR.Reg, volatile.LoadUint16(&o.FSCMR.Reg)&^(0x100)|value<<8)
}
func (o *FLCN_Type) GetFSCMR_SASMF() uint16 {
	return (volatile.LoadUint16(&o.FSCMR.Reg) & 0x100) >> 8
}
func (o *FLCN_Type) SetFSCMR_FSPR(value uint16) {
	volatile.StoreUint16(&o.FSCMR.Reg, volatile.LoadUint16(&o.FSCMR.Reg)&^(0x4000)|value<<14)
}
func (o *FLCN_Type) GetFSCMR_FSPR() uint16 {
	return (volatile.LoadUint16(&o.FSCMR.Reg) & 0x4000) >> 14
}

// FLCN.FAWSMR: Flash Access Window Start Address Monitor Register
func (o *FLCN_Type) SetFAWSMR_FAWS(value uint16) {
	volatile.StoreUint16(&o.FAWSMR.Reg, volatile.LoadUint16(&o.FAWSMR.Reg)&^(0x7ff)|value)
}
func (o *FLCN_Type) GetFAWSMR_FAWS() uint16 {
	return volatile.LoadUint16(&o.FAWSMR.Reg) & 0x7ff
}
func (o *FLCN_Type) SetFAWSMR_FSPR(value uint16) {
	volatile.StoreUint16(&o.FAWSMR.Reg, volatile.LoadUint16(&o.FAWSMR.Reg)&^(0x8000)|value<<15)
}
func (o *FLCN_Type) GetFAWSMR_FSPR() uint16 {
	return (volatile.LoadUint16(&o.FAWSMR.Reg) & 0x8000) >> 15
}

// FLCN.FAWEMR: Flash Access Window End Address Monitor Register
func (o *FLCN_Type) SetFAWEMR_FAWE(value uint16) {
	volatile.StoreUint16(&o.FAWEMR.Reg, volatile.LoadUint16(&o.FAWEMR.Reg)&^(0x7ff)|value)
}
func (o *FLCN_Type) GetFAWEMR_FAWE() uint16 {
	return volatile.LoadUint16(&o.FAWEMR.Reg) & 0x7ff
}
func (o *FLCN_Type) SetFAWEMR_SASMF(value uint16) {
	volatile.StoreUint16(&o.FAWEMR.Reg, volatile.LoadUint16(&o.FAWEMR.Reg)&^(0x8000)|value<<15)
}
func (o *FLCN_Type) GetFAWEMR_SASMF() uint16 {
	return (volatile.LoadUint16(&o.FAWEMR.Reg) & 0x8000) >> 15
}

// FLCN.FISR: Flash Initial Setting Register
func (o *FLCN_Type) SetFISR_PCKA(value uint8) {
	volatile.StoreUint8(&o.FISR.Reg, volatile.LoadUint8(&o.FISR.Reg)&^(0x3f)|value)
}
func (o *FLCN_Type) GetFISR_PCKA() uint8 {
	return volatile.LoadUint8(&o.FISR.Reg) & 0x3f
}
func (o *FLCN_Type) SetFISR_SAS(value uint8) {
	volatile.StoreUint8(&o.FISR.Reg, volatile.LoadUint8(&o.FISR.Reg)&^(0xc0)|value<<6)
}
func (o *FLCN_Type) GetFISR_SAS() uint8 {
	return (volatile.LoadUint8(&o.FISR.Reg) & 0xc0) >> 6
}

// FLCN.FEXCR: Flash Extra Area Control Register
func (o *FLCN_Type) SetFEXCR_CMD(value uint8) {
	volatile.StoreUint8(&o.FEXCR.Reg, volatile.LoadUint8(&o.FEXCR.Reg)&^(0x7)|value)
}
func (o *FLCN_Type) GetFEXCR_CMD() uint8 {
	return volatile.LoadUint8(&o.FEXCR.Reg) & 0x7
}
func (o *FLCN_Type) SetFEXCR_OPST(value uint8) {
	volatile.StoreUint8(&o.FEXCR.Reg, volatile.LoadUint8(&o.FEXCR.Reg)&^(0x80)|value<<7)
}
func (o *FLCN_Type) GetFEXCR_OPST() uint8 {
	return (volatile.LoadUint8(&o.FEXCR.Reg) & 0x80) >> 7
}

// FLCN.FEAML: Flash Error Address Monitor Register L
func (o *FLCN_Type) SetFEAML(value uint16) {
	volatile.StoreUint16(&o.FEAML.Reg, value)
}
func (o *FLCN_Type) GetFEAML() uint16 {
	return volatile.LoadUint16(&o.FEAML.Reg)
}

// FLCN.FEAMH: Flash Error Address Monitor Register H
func (o *FLCN_Type) SetFEAMH(value uint16) {
	volatile.StoreUint16(&o.FEAMH.Reg, value)
}
func (o *FLCN_Type) GetFEAMH() uint16 {
	return volatile.LoadUint16(&o.FEAMH.Reg)
}

// FLCN.FSTATR2: Flash Status Register 2
func (o *FLCN_Type) SetFSTATR2_ERERR(value uint16) {
	volatile.StoreUint16(&o.FSTATR2.Reg, volatile.LoadUint16(&o.FSTATR2.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetFSTATR2_ERERR() uint16 {
	return volatile.LoadUint16(&o.FSTATR2.Reg) & 0x1
}
func (o *FLCN_Type) SetFSTATR2_PRGERR(value uint16) {
	volatile.StoreUint16(&o.FSTATR2.Reg, volatile.LoadUint16(&o.FSTATR2.Reg)&^(0x2)|value<<1)
}
func (o *FLCN_Type) GetFSTATR2_PRGERR() uint16 {
	return (volatile.LoadUint16(&o.FSTATR2.Reg) & 0x2) >> 1
}
func (o *FLCN_Type) SetFSTATR2_PRGERR01(value uint16) {
	volatile.StoreUint16(&o.FSTATR2.Reg, volatile.LoadUint16(&o.FSTATR2.Reg)&^(0x4)|value<<2)
}
func (o *FLCN_Type) GetFSTATR2_PRGERR01() uint16 {
	return (volatile.LoadUint16(&o.FSTATR2.Reg) & 0x4) >> 2
}
func (o *FLCN_Type) SetFSTATR2_BCERR(value uint16) {
	volatile.StoreUint16(&o.FSTATR2.Reg, volatile.LoadUint16(&o.FSTATR2.Reg)&^(0x8)|value<<3)
}
func (o *FLCN_Type) GetFSTATR2_BCERR() uint16 {
	return (volatile.LoadUint16(&o.FSTATR2.Reg) & 0x8) >> 3
}
func (o *FLCN_Type) SetFSTATR2_ILGLERR(value uint16) {
	volatile.StoreUint16(&o.FSTATR2.Reg, volatile.LoadUint16(&o.FSTATR2.Reg)&^(0x10)|value<<4)
}
func (o *FLCN_Type) GetFSTATR2_ILGLERR() uint16 {
	return (volatile.LoadUint16(&o.FSTATR2.Reg) & 0x10) >> 4
}
func (o *FLCN_Type) SetFSTATR2_EILGLERR(value uint16) {
	volatile.StoreUint16(&o.FSTATR2.Reg, volatile.LoadUint16(&o.FSTATR2.Reg)&^(0x20)|value<<5)
}
func (o *FLCN_Type) GetFSTATR2_EILGLERR() uint16 {
	return (volatile.LoadUint16(&o.FSTATR2.Reg) & 0x20) >> 5
}

// FLCN.TSCDR: Temperature Sensor Calibration Data Register
func (o *FLCN_Type) SetTSCDR(value uint32) {
	volatile.StoreUint32(&o.TSCDR.Reg, volatile.LoadUint32(&o.TSCDR.Reg)&^(0xffff)|value)
}
func (o *FLCN_Type) GetTSCDR() uint32 {
	return volatile.LoadUint32(&o.TSCDR.Reg) & 0xffff
}

// FLCN.CTSUTRIMA: CTSU Trimming Register A
func (o *FLCN_Type) SetCTSUTRIMA_RTRIM(value uint32) {
	volatile.StoreUint32(&o.CTSUTRIMA.Reg, volatile.LoadUint32(&o.CTSUTRIMA.Reg)&^(0xff)|value)
}
func (o *FLCN_Type) GetCTSUTRIMA_RTRIM() uint32 {
	return volatile.LoadUint32(&o.CTSUTRIMA.Reg) & 0xff
}
func (o *FLCN_Type) SetCTSUTRIMA_DACTRIM(value uint32) {
	volatile.StoreUint32(&o.CTSUTRIMA.Reg, volatile.LoadUint32(&o.CTSUTRIMA.Reg)&^(0xff00)|value<<8)
}
func (o *FLCN_Type) GetCTSUTRIMA_DACTRIM() uint32 {
	return (volatile.LoadUint32(&o.CTSUTRIMA.Reg) & 0xff00) >> 8
}
func (o *FLCN_Type) SetCTSUTRIMA_SUADJD(value uint32) {
	volatile.StoreUint32(&o.CTSUTRIMA.Reg, volatile.LoadUint32(&o.CTSUTRIMA.Reg)&^(0xff0000)|value<<16)
}
func (o *FLCN_Type) GetCTSUTRIMA_SUADJD() uint32 {
	return (volatile.LoadUint32(&o.CTSUTRIMA.Reg) & 0xff0000) >> 16
}
func (o *FLCN_Type) SetCTSUTRIMA_SUADJTRIM(value uint32) {
	volatile.StoreUint32(&o.CTSUTRIMA.Reg, volatile.LoadUint32(&o.CTSUTRIMA.Reg)&^(0xff000000)|value<<24)
}
func (o *FLCN_Type) GetCTSUTRIMA_SUADJTRIM() uint32 {
	return (volatile.LoadUint32(&o.CTSUTRIMA.Reg) & 0xff000000) >> 24
}

// FLCN.CTSUTRIMB: CTSU Trimming Register B
func (o *FLCN_Type) SetCTSUTRIMB_TRESULT0(value uint32) {
	volatile.StoreUint32(&o.CTSUTRIMB.Reg, volatile.LoadUint32(&o.CTSUTRIMB.Reg)&^(0xff)|value)
}
func (o *FLCN_Type) GetCTSUTRIMB_TRESULT0() uint32 {
	return volatile.LoadUint32(&o.CTSUTRIMB.Reg) & 0xff
}
func (o *FLCN_Type) SetCTSUTRIMB_TRESULT1(value uint32) {
	volatile.StoreUint32(&o.CTSUTRIMB.Reg, volatile.LoadUint32(&o.CTSUTRIMB.Reg)&^(0xff00)|value<<8)
}
func (o *FLCN_Type) GetCTSUTRIMB_TRESULT1() uint32 {
	return (volatile.LoadUint32(&o.CTSUTRIMB.Reg) & 0xff00) >> 8
}
func (o *FLCN_Type) SetCTSUTRIMB_TRESULT2(value uint32) {
	volatile.StoreUint32(&o.CTSUTRIMB.Reg, volatile.LoadUint32(&o.CTSUTRIMB.Reg)&^(0xff0000)|value<<16)
}
func (o *FLCN_Type) GetCTSUTRIMB_TRESULT2() uint32 {
	return (volatile.LoadUint32(&o.CTSUTRIMB.Reg) & 0xff0000) >> 16
}
func (o *FLCN_Type) SetCTSUTRIMB_TRESULT3(value uint32) {
	volatile.StoreUint32(&o.CTSUTRIMB.Reg, volatile.LoadUint32(&o.CTSUTRIMB.Reg)&^(0xff000000)|value<<24)
}
func (o *FLCN_Type) GetCTSUTRIMB_TRESULT3() uint32 {
	return (volatile.LoadUint32(&o.CTSUTRIMB.Reg) & 0xff000000) >> 24
}

// FLCN.FENTRYR: Flash P/E Mode Entry Register
func (o *FLCN_Type) SetFENTRYR_FENTRY0(value uint16) {
	volatile.StoreUint16(&o.FENTRYR.Reg, volatile.LoadUint16(&o.FENTRYR.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetFENTRYR_FENTRY0() uint16 {
	return volatile.LoadUint16(&o.FENTRYR.Reg) & 0x1
}
func (o *FLCN_Type) SetFENTRYR_FENTRYD(value uint16) {
	volatile.StoreUint16(&o.FENTRYR.Reg, volatile.LoadUint16(&o.FENTRYR.Reg)&^(0x80)|value<<7)
}
func (o *FLCN_Type) GetFENTRYR_FENTRYD() uint16 {
	return (volatile.LoadUint16(&o.FENTRYR.Reg) & 0x80) >> 7
}
func (o *FLCN_Type) SetFENTRYR_FEKEY(value uint16) {
	volatile.StoreUint16(&o.FENTRYR.Reg, volatile.LoadUint16(&o.FENTRYR.Reg)&^(0xff00)|value<<8)
}
func (o *FLCN_Type) GetFENTRYR_FEKEY() uint16 {
	return (volatile.LoadUint16(&o.FENTRYR.Reg) & 0xff00) >> 8
}

// FLCN.FLDWAITR: Memory Wait Cycle Control Register for Data Flash
func (o *FLCN_Type) SetFLDWAITR_FLDWAIT1(value uint8) {
	volatile.StoreUint8(&o.FLDWAITR.Reg, volatile.LoadUint8(&o.FLDWAITR.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetFLDWAITR_FLDWAIT1() uint8 {
	return volatile.LoadUint8(&o.FLDWAITR.Reg) & 0x1
}

// FLCN.PFBER: Prefetch Buffer Enable Register
func (o *FLCN_Type) SetPFBER_PFBE(value uint8) {
	volatile.StoreUint8(&o.PFBER.Reg, volatile.LoadUint8(&o.PFBER.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetPFBER_PFBE() uint8 {
	return volatile.LoadUint8(&o.PFBER.Reg) & 0x1
}

// Constants for RMPU: Renesas Memory Protection Unit
const (
	// MMPUCTLA: Bus Master MPU Control Register
	// Position of ENABLE field.
	RMPU_MMPUCTLA_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	RMPU_MMPUCTLA_ENABLE_Msk = 0x1
	// Bit ENABLE.
	RMPU_MMPUCTLA_ENABLE = 0x1
	// Master group A disabled
	RMPU_MMPUCTLA_ENABLE_0 = 0x0
	// Master group A enabled
	RMPU_MMPUCTLA_ENABLE_1 = 0x1
	// Position of OAD field.
	RMPU_MMPUCTLA_OAD_Pos = 0x1
	// Bit mask of OAD field.
	RMPU_MMPUCTLA_OAD_Msk = 0x2
	// Bit OAD.
	RMPU_MMPUCTLA_OAD = 0x2
	// Non-maskable interrupt
	RMPU_MMPUCTLA_OAD_0 = 0x0
	// Reset
	RMPU_MMPUCTLA_OAD_1 = 0x1
	// Position of KEY field.
	RMPU_MMPUCTLA_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_MMPUCTLA_KEY_Msk = 0xff00

	// MMPUPTA: Group A Protection of Register
	// Position of PROTECT field.
	RMPU_MMPUPTA_PROTECT_Pos = 0x0
	// Bit mask of PROTECT field.
	RMPU_MMPUPTA_PROTECT_Msk = 0x1
	// Bit PROTECT.
	RMPU_MMPUPTA_PROTECT = 0x1
	// All bus master MPU group A register writes are permitted.
	RMPU_MMPUPTA_PROTECT_0 = 0x0
	// All bus master MPU group A register writes are protected. Reads are permitted.
	RMPU_MMPUPTA_PROTECT_1 = 0x1
	// Position of KEY field.
	RMPU_MMPUPTA_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_MMPUPTA_KEY_Msk = 0xff00

	// MMPUACA0: Group A Region %s access control register
	// Position of ENABLE field.
	RMPU_MMPUACA_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	RMPU_MMPUACA_ENABLE_Msk = 0x1
	// Bit ENABLE.
	RMPU_MMPUACA_ENABLE = 0x1
	// Group A region n disabled
	RMPU_MMPUACA_ENABLE_0 = 0x0
	// Group A region n enabled
	RMPU_MMPUACA_ENABLE_1 = 0x1
	// Position of RP field.
	RMPU_MMPUACA_RP_Pos = 0x1
	// Bit mask of RP field.
	RMPU_MMPUACA_RP_Msk = 0x2
	// Bit RP.
	RMPU_MMPUACA_RP = 0x2
	// Read permission
	RMPU_MMPUACA_RP_0 = 0x0
	// Read protection
	RMPU_MMPUACA_RP_1 = 0x1
	// Position of WP field.
	RMPU_MMPUACA_WP_Pos = 0x2
	// Bit mask of WP field.
	RMPU_MMPUACA_WP_Msk = 0x4
	// Bit WP.
	RMPU_MMPUACA_WP = 0x4
	// Write permission
	RMPU_MMPUACA_WP_0 = 0x0
	// Write protection
	RMPU_MMPUACA_WP_1 = 0x1

	// MMPUSA0: Group A Region %s Start Address Register
	// Position of MMPUSA field.
	RMPU_MMPUSA_MMPUSA_Pos = 0x0
	// Bit mask of MMPUSA field.
	RMPU_MMPUSA_MMPUSA_Msk = 0xffffffff

	// MMPUEA0: Group A Region %s End Address Register
	// Position of MMPUEA field.
	RMPU_MMPUEA_MMPUEA_Pos = 0x0
	// Bit mask of MMPUEA field.
	RMPU_MMPUEA_MMPUEA_Msk = 0xffffffff

	// SMPUCTL: Slave MPU Control Register
	// Position of OAD field.
	RMPU_SMPUCTL_OAD_Pos = 0x0
	// Bit mask of OAD field.
	RMPU_SMPUCTL_OAD_Msk = 0x1
	// Bit OAD.
	RMPU_SMPUCTL_OAD = 0x1
	// Non-maskable interrupt
	RMPU_SMPUCTL_OAD_0 = 0x0
	// Reset
	RMPU_SMPUCTL_OAD_1 = 0x1
	// Position of PROTECT field.
	RMPU_SMPUCTL_PROTECT_Pos = 0x1
	// Bit mask of PROTECT field.
	RMPU_SMPUCTL_PROTECT_Msk = 0x2
	// Bit PROTECT.
	RMPU_SMPUCTL_PROTECT = 0x2
	// All bus slave register writes are permitted
	RMPU_SMPUCTL_PROTECT_0 = 0x0
	// All bus slave register writes are protected. Reads are permitted
	RMPU_SMPUCTL_PROTECT_1 = 0x1
	// Position of KEY field.
	RMPU_SMPUCTL_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_SMPUCTL_KEY_Msk = 0xff00

	// SMPUMBIU: Access Control Register for Memory Bus 1
	// Position of RPGRPA field.
	RMPU_SMPUMBIU_RPGRPA_Pos = 0x2
	// Bit mask of RPGRPA field.
	RMPU_SMPUMBIU_RPGRPA_Msk = 0x4
	// Bit RPGRPA.
	RMPU_SMPUMBIU_RPGRPA = 0x4
	// Memory protection read for master MPU group A disabled
	RMPU_SMPUMBIU_RPGRPA_0 = 0x0
	// Memory protection read for master MPU group A enabled
	RMPU_SMPUMBIU_RPGRPA_1 = 0x1
	// Position of WPGRPA field.
	RMPU_SMPUMBIU_WPGRPA_Pos = 0x3
	// Bit mask of WPGRPA field.
	RMPU_SMPUMBIU_WPGRPA_Msk = 0x8
	// Bit WPGRPA.
	RMPU_SMPUMBIU_WPGRPA = 0x8
	// Memory protection write for master MPU group A disabled
	RMPU_SMPUMBIU_WPGRPA_0 = 0x0
	// Memory protection write for master MPU group A enabled
	RMPU_SMPUMBIU_WPGRPA_1 = 0x1

	// SMPUFBIU: Access Control Register for Internal Peripheral Bus 9
	// Position of RPCPU field.
	RMPU_SMPUFBIU_RPCPU_Pos = 0x0
	// Bit mask of RPCPU field.
	RMPU_SMPUFBIU_RPCPU_Msk = 0x1
	// Bit RPCPU.
	RMPU_SMPUFBIU_RPCPU = 0x1
	// Memory protection for CPU read disabled
	RMPU_SMPUFBIU_RPCPU_0 = 0x0
	// Memory protection for CPU read enabled
	RMPU_SMPUFBIU_RPCPU_1 = 0x1
	// Position of WPCPU field.
	RMPU_SMPUFBIU_WPCPU_Pos = 0x1
	// Bit mask of WPCPU field.
	RMPU_SMPUFBIU_WPCPU_Msk = 0x2
	// Bit WPCPU.
	RMPU_SMPUFBIU_WPCPU = 0x2
	// Memory protection for CPU write disabled
	RMPU_SMPUFBIU_WPCPU_0 = 0x0
	// Memory protection for CPU write enabled
	RMPU_SMPUFBIU_WPCPU_1 = 0x1
	// Position of RPGRPA field.
	RMPU_SMPUFBIU_RPGRPA_Pos = 0x2
	// Bit mask of RPGRPA field.
	RMPU_SMPUFBIU_RPGRPA_Msk = 0x4
	// Bit RPGRPA.
	RMPU_SMPUFBIU_RPGRPA = 0x4
	// Memory protection for master MPU group A read disabled
	RMPU_SMPUFBIU_RPGRPA_0 = 0x0
	// Memory protection for master MPU group A read enabled
	RMPU_SMPUFBIU_RPGRPA_1 = 0x1
	// Position of WPGRPA field.
	RMPU_SMPUFBIU_WPGRPA_Pos = 0x3
	// Bit mask of WPGRPA field.
	RMPU_SMPUFBIU_WPGRPA_Msk = 0x8
	// Bit WPGRPA.
	RMPU_SMPUFBIU_WPGRPA = 0x8
	// Memory protection for master MPU group A write disabled
	RMPU_SMPUFBIU_WPGRPA_0 = 0x0
	// Memory protection for master MPU group A write enabled
	RMPU_SMPUFBIU_WPGRPA_1 = 0x1

	// SMPUSRAM0: Access Control Register for Memory Bus 4
	// Position of RPCPU field.
	RMPU_SMPUSRAM0_RPCPU_Pos = 0x0
	// Bit mask of RPCPU field.
	RMPU_SMPUSRAM0_RPCPU_Msk = 0x1
	// Bit RPCPU.
	RMPU_SMPUSRAM0_RPCPU = 0x1
	// Memory protection for CPU read disabled
	RMPU_SMPUSRAM0_RPCPU_0 = 0x0
	// Memory protection for CPU read enabled
	RMPU_SMPUSRAM0_RPCPU_1 = 0x1
	// Position of WPCPU field.
	RMPU_SMPUSRAM0_WPCPU_Pos = 0x1
	// Bit mask of WPCPU field.
	RMPU_SMPUSRAM0_WPCPU_Msk = 0x2
	// Bit WPCPU.
	RMPU_SMPUSRAM0_WPCPU = 0x2
	// Memory protection for CPU write disabled
	RMPU_SMPUSRAM0_WPCPU_0 = 0x0
	// Memory protection for CPU write enabled
	RMPU_SMPUSRAM0_WPCPU_1 = 0x1
	// Position of RPGRPA field.
	RMPU_SMPUSRAM0_RPGRPA_Pos = 0x2
	// Bit mask of RPGRPA field.
	RMPU_SMPUSRAM0_RPGRPA_Msk = 0x4
	// Bit RPGRPA.
	RMPU_SMPUSRAM0_RPGRPA = 0x4
	// Memory protection for master MPU group A read disabled
	RMPU_SMPUSRAM0_RPGRPA_0 = 0x0
	// Memory protection for master MPU group A read enabled
	RMPU_SMPUSRAM0_RPGRPA_1 = 0x1
	// Position of WPGRPA field.
	RMPU_SMPUSRAM0_WPGRPA_Pos = 0x3
	// Bit mask of WPGRPA field.
	RMPU_SMPUSRAM0_WPGRPA_Msk = 0x8
	// Bit WPGRPA.
	RMPU_SMPUSRAM0_WPGRPA = 0x8
	// Memory protection for master MPU group A write disabled
	RMPU_SMPUSRAM0_WPGRPA_0 = 0x0
	// Memory protection for master MPU group A write enabled
	RMPU_SMPUSRAM0_WPGRPA_1 = 0x1

	// SMPUP0BIU: Access Control Register for Internal Peripheral Bus 1
	// Position of RPCPU field.
	RMPU_SMPUP0BIU_RPCPU_Pos = 0x0
	// Bit mask of RPCPU field.
	RMPU_SMPUP0BIU_RPCPU_Msk = 0x1
	// Bit RPCPU.
	RMPU_SMPUP0BIU_RPCPU = 0x1
	// Memory protection for CPU read disabled
	RMPU_SMPUP0BIU_RPCPU_0 = 0x0
	// Memory protection for CPU read enabled
	RMPU_SMPUP0BIU_RPCPU_1 = 0x1
	// Position of WPCPU field.
	RMPU_SMPUP0BIU_WPCPU_Pos = 0x1
	// Bit mask of WPCPU field.
	RMPU_SMPUP0BIU_WPCPU_Msk = 0x2
	// Bit WPCPU.
	RMPU_SMPUP0BIU_WPCPU = 0x2
	// Memory protection for CPU write disabled
	RMPU_SMPUP0BIU_WPCPU_0 = 0x0
	// Memory protection for CPU write enabled
	RMPU_SMPUP0BIU_WPCPU_1 = 0x1
	// Position of RPGRPA field.
	RMPU_SMPUP0BIU_RPGRPA_Pos = 0x2
	// Bit mask of RPGRPA field.
	RMPU_SMPUP0BIU_RPGRPA_Msk = 0x4
	// Bit RPGRPA.
	RMPU_SMPUP0BIU_RPGRPA = 0x4
	// Memory protection for master MPU group A read disabled
	RMPU_SMPUP0BIU_RPGRPA_0 = 0x0
	// Memory protection for master MPU group A read enabled
	RMPU_SMPUP0BIU_RPGRPA_1 = 0x1
	// Position of WPGRPA field.
	RMPU_SMPUP0BIU_WPGRPA_Pos = 0x3
	// Bit mask of WPGRPA field.
	RMPU_SMPUP0BIU_WPGRPA_Msk = 0x8
	// Bit WPGRPA.
	RMPU_SMPUP0BIU_WPGRPA = 0x8
	// Memory protection for master MPU group A write disabled
	RMPU_SMPUP0BIU_WPGRPA_0 = 0x0
	// Memory protection for master MPU group A write enabled
	RMPU_SMPUP0BIU_WPGRPA_1 = 0x1

	// SMPUP2BIU: Access Control Register for Internal Peripheral Bus 3
	// Position of RPCPU field.
	RMPU_SMPUP2BIU_RPCPU_Pos = 0x0
	// Bit mask of RPCPU field.
	RMPU_SMPUP2BIU_RPCPU_Msk = 0x1
	// Bit RPCPU.
	RMPU_SMPUP2BIU_RPCPU = 0x1
	// Memory protection for CPU read disabled
	RMPU_SMPUP2BIU_RPCPU_0 = 0x0
	// Memory protection for CPU read enabled
	RMPU_SMPUP2BIU_RPCPU_1 = 0x1
	// Position of WPCPU field.
	RMPU_SMPUP2BIU_WPCPU_Pos = 0x1
	// Bit mask of WPCPU field.
	RMPU_SMPUP2BIU_WPCPU_Msk = 0x2
	// Bit WPCPU.
	RMPU_SMPUP2BIU_WPCPU = 0x2
	// Memory protection for CPU write disabled
	RMPU_SMPUP2BIU_WPCPU_0 = 0x0
	// Memory protection for CPU write enabled
	RMPU_SMPUP2BIU_WPCPU_1 = 0x1
	// Position of RPGRPA field.
	RMPU_SMPUP2BIU_RPGRPA_Pos = 0x2
	// Bit mask of RPGRPA field.
	RMPU_SMPUP2BIU_RPGRPA_Msk = 0x4
	// Bit RPGRPA.
	RMPU_SMPUP2BIU_RPGRPA = 0x4
	// Memory protection for master MPU group A read disabled
	RMPU_SMPUP2BIU_RPGRPA_0 = 0x0
	// Memory protection for master MPU group A read enabled
	RMPU_SMPUP2BIU_RPGRPA_1 = 0x1
	// Position of WPGRPA field.
	RMPU_SMPUP2BIU_WPGRPA_Pos = 0x3
	// Bit mask of WPGRPA field.
	RMPU_SMPUP2BIU_WPGRPA_Msk = 0x8
	// Bit WPGRPA.
	RMPU_SMPUP2BIU_WPGRPA = 0x8
	// Memory protection for master MPU group A write disabled
	RMPU_SMPUP2BIU_WPGRPA_0 = 0x0
	// Memory protection for master MPU group A write enabled
	RMPU_SMPUP2BIU_WPGRPA_1 = 0x1

	// SMPUP6BIU: Access Control Register for Internal Peripheral Bus 7
	// Position of RPCPU field.
	RMPU_SMPUP6BIU_RPCPU_Pos = 0x0
	// Bit mask of RPCPU field.
	RMPU_SMPUP6BIU_RPCPU_Msk = 0x1
	// Bit RPCPU.
	RMPU_SMPUP6BIU_RPCPU = 0x1
	// CPU read of memory protection disabled
	RMPU_SMPUP6BIU_RPCPU_0 = 0x0
	// CPU read of memory protection enabled
	RMPU_SMPUP6BIU_RPCPU_1 = 0x1
	// Position of WPCPU field.
	RMPU_SMPUP6BIU_WPCPU_Pos = 0x1
	// Bit mask of WPCPU field.
	RMPU_SMPUP6BIU_WPCPU_Msk = 0x2
	// Bit WPCPU.
	RMPU_SMPUP6BIU_WPCPU = 0x2
	// CPU write of memory protection disabled
	RMPU_SMPUP6BIU_WPCPU_0 = 0x0
	// CPU write of memory protection enabled
	RMPU_SMPUP6BIU_WPCPU_1 = 0x1
	// Position of RPGRPA field.
	RMPU_SMPUP6BIU_RPGRPA_Pos = 0x2
	// Bit mask of RPGRPA field.
	RMPU_SMPUP6BIU_RPGRPA_Msk = 0x4
	// Bit RPGRPA.
	RMPU_SMPUP6BIU_RPGRPA = 0x4
	// Master MPU group A read of memory protection disabled
	RMPU_SMPUP6BIU_RPGRPA_0 = 0x0
	// Master MPU group A read of memory protection enabled
	RMPU_SMPUP6BIU_RPGRPA_1 = 0x1
	// Position of WPGRPA field.
	RMPU_SMPUP6BIU_WPGRPA_Pos = 0x3
	// Bit mask of WPGRPA field.
	RMPU_SMPUP6BIU_WPGRPA_Msk = 0x8
	// Bit WPGRPA.
	RMPU_SMPUP6BIU_WPGRPA = 0x8
	// Master MPU group A write of memory protection disabled
	RMPU_SMPUP6BIU_WPGRPA_0 = 0x0
	// Master MPU group A write of memory protection enabled
	RMPU_SMPUP6BIU_WPGRPA_1 = 0x1

	// MSPMPUOAD: Stack Pointer Monitor Operation After Detection Register
	// Position of OAD field.
	RMPU_MSPMPUOAD_OAD_Pos = 0x0
	// Bit mask of OAD field.
	RMPU_MSPMPUOAD_OAD_Msk = 0x1
	// Bit OAD.
	RMPU_MSPMPUOAD_OAD = 0x1
	// Non-maskable interrupt
	RMPU_MSPMPUOAD_OAD_0 = 0x0
	// Reset
	RMPU_MSPMPUOAD_OAD_1 = 0x1
	// Position of KEY field.
	RMPU_MSPMPUOAD_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_MSPMPUOAD_KEY_Msk = 0xff00

	// MSPMPUCTL: Stack Pointer Monitor Access Control Register
	// Position of ENABLE field.
	RMPU_MSPMPUCTL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	RMPU_MSPMPUCTL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	RMPU_MSPMPUCTL_ENABLE = 0x1
	// Stack pointer monitor is disabled
	RMPU_MSPMPUCTL_ENABLE_0 = 0x0
	// Stack pointer monitor is enabled
	RMPU_MSPMPUCTL_ENABLE_1 = 0x1
	// Position of ERROR field.
	RMPU_MSPMPUCTL_ERROR_Pos = 0x8
	// Bit mask of ERROR field.
	RMPU_MSPMPUCTL_ERROR_Msk = 0x100
	// Bit ERROR.
	RMPU_MSPMPUCTL_ERROR = 0x100
	// Stack pointer has not overflowed or underflowed
	RMPU_MSPMPUCTL_ERROR_0 = 0x0
	// Stack pointer has overflowed or underflowed
	RMPU_MSPMPUCTL_ERROR_1 = 0x1

	// MSPMPUPT: Stack Pointer Monitor Protection Register
	// Position of PROTECT field.
	RMPU_MSPMPUPT_PROTECT_Pos = 0x0
	// Bit mask of PROTECT field.
	RMPU_MSPMPUPT_PROTECT_Msk = 0x1
	// Bit PROTECT.
	RMPU_MSPMPUPT_PROTECT = 0x1
	// Stack pointer monitor register writes are permitted.
	RMPU_MSPMPUPT_PROTECT_0 = 0x0
	// Stack pointer monitor register writes are protected. Reads are permitted
	RMPU_MSPMPUPT_PROTECT_1 = 0x1
	// Position of KEY field.
	RMPU_MSPMPUPT_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_MSPMPUPT_KEY_Msk = 0xff00

	// MSPMPUSA: Main Stack Pointer (MSP) Monitor Start Address Register
	// Position of MSPMPUSA field.
	RMPU_MSPMPUSA_MSPMPUSA_Pos = 0x0
	// Bit mask of MSPMPUSA field.
	RMPU_MSPMPUSA_MSPMPUSA_Msk = 0xffffffff

	// MSPMPUEA: Main Stack Pointer (MSP) Monitor End Address Register
	// Position of MSPMPUEA field.
	RMPU_MSPMPUEA_MSPMPUEA_Pos = 0x0
	// Bit mask of MSPMPUEA field.
	RMPU_MSPMPUEA_MSPMPUEA_Msk = 0xffffffff

	// PSPMPUOAD: Stack Pointer Monitor Operation After Detection Register
	// Position of OAD field.
	RMPU_PSPMPUOAD_OAD_Pos = 0x0
	// Bit mask of OAD field.
	RMPU_PSPMPUOAD_OAD_Msk = 0x1
	// Bit OAD.
	RMPU_PSPMPUOAD_OAD = 0x1
	// Non-maskable interrupt
	RMPU_PSPMPUOAD_OAD_0 = 0x0
	// Reset
	RMPU_PSPMPUOAD_OAD_1 = 0x1
	// Position of KEY field.
	RMPU_PSPMPUOAD_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_PSPMPUOAD_KEY_Msk = 0xff00

	// PSPMPUCTL: Stack Pointer Monitor Access Control Register
	// Position of ENABLE field.
	RMPU_PSPMPUCTL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	RMPU_PSPMPUCTL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	RMPU_PSPMPUCTL_ENABLE = 0x1
	// Stack pointer monitor is disabled
	RMPU_PSPMPUCTL_ENABLE_0 = 0x0
	// Stack pointer monitor is enabled
	RMPU_PSPMPUCTL_ENABLE_1 = 0x1
	// Position of ERROR field.
	RMPU_PSPMPUCTL_ERROR_Pos = 0x8
	// Bit mask of ERROR field.
	RMPU_PSPMPUCTL_ERROR_Msk = 0x100
	// Bit ERROR.
	RMPU_PSPMPUCTL_ERROR = 0x100
	// Stack pointer has not overflowed or underflowed
	RMPU_PSPMPUCTL_ERROR_0 = 0x0
	// Stack pointer has overflowed or underflowed
	RMPU_PSPMPUCTL_ERROR_1 = 0x1

	// PSPMPUPT: Stack Pointer Monitor Protection Register
	// Position of PROTECT field.
	RMPU_PSPMPUPT_PROTECT_Pos = 0x0
	// Bit mask of PROTECT field.
	RMPU_PSPMPUPT_PROTECT_Msk = 0x1
	// Bit PROTECT.
	RMPU_PSPMPUPT_PROTECT = 0x1
	// Stack pointer monitor register writes are permitted.
	RMPU_PSPMPUPT_PROTECT_0 = 0x0
	// Stack pointer monitor register writes are protected. Reads are permitted
	RMPU_PSPMPUPT_PROTECT_1 = 0x1
	// Position of KEY field.
	RMPU_PSPMPUPT_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_PSPMPUPT_KEY_Msk = 0xff00

	// PSPMPUSA: Process Stack Pointer (PSP) Monitor Start Address Register
	// Position of PSPMPUSA field.
	RMPU_PSPMPUSA_PSPMPUSA_Pos = 0x0
	// Bit mask of PSPMPUSA field.
	RMPU_PSPMPUSA_PSPMPUSA_Msk = 0xffffffff

	// PSPMPUEA: Process Stack Pointer (PSP) Monitor End Address Register
	// Position of PSPMPUEA field.
	RMPU_PSPMPUEA_PSPMPUEA_Pos = 0x0
	// Bit mask of PSPMPUEA field.
	RMPU_PSPMPUEA_PSPMPUEA_Msk = 0xffffffff
)

// Constants for SRAM: SRAM Control
const (
	// PARIOAD: SRAM Parity Error Operation After Detection Register
	// Position of OAD field.
	SRAM_PARIOAD_OAD_Pos = 0x0
	// Bit mask of OAD field.
	SRAM_PARIOAD_OAD_Msk = 0x1
	// Bit OAD.
	SRAM_PARIOAD_OAD = 0x1
	// Non-maskable interrupt
	SRAM_PARIOAD_OAD_0 = 0x0
	// Reset
	SRAM_PARIOAD_OAD_1 = 0x1

	// SRAMPRCR: SRAM Protection Register
	// Position of SRAMPRCR field.
	SRAM_SRAMPRCR_SRAMPRCR_Pos = 0x0
	// Bit mask of SRAMPRCR field.
	SRAM_SRAMPRCR_SRAMPRCR_Msk = 0x1
	// Bit SRAMPRCR.
	SRAM_SRAMPRCR_SRAMPRCR = 0x1
	// Disable writes to protected registers
	SRAM_SRAMPRCR_SRAMPRCR_0 = 0x0
	// Enable writes to protected registers
	SRAM_SRAMPRCR_SRAMPRCR_1 = 0x1
	// Position of KW field.
	SRAM_SRAMPRCR_KW_Pos = 0x1
	// Bit mask of KW field.
	SRAM_SRAMPRCR_KW_Msk = 0xfe
)

// Constants for BUS: BUS Control
const (
	// BUSMCNTSYS: Master Bus Control Register SYS
	// Position of IERES field.
	BUS_BUSMCNTSYS_IERES_Pos = 0xf
	// Bit mask of IERES field.
	BUS_BUSMCNTSYS_IERES_Msk = 0x8000
	// Bit IERES.
	BUS_BUSMCNTSYS_IERES = 0x8000
	// A bus error is reported.
	BUS_BUSMCNTSYS_IERES_0 = 0x0
	// A bus error is not reported.
	BUS_BUSMCNTSYS_IERES_1 = 0x1

	// BUSMCNTDMA: Master Bus Control Register DMA
	// Position of IERES field.
	BUS_BUSMCNTDMA_IERES_Pos = 0xf
	// Bit mask of IERES field.
	BUS_BUSMCNTDMA_IERES_Msk = 0x8000
	// Bit IERES.
	BUS_BUSMCNTDMA_IERES = 0x8000
	// A bus error is reported.
	BUS_BUSMCNTDMA_IERES_0 = 0x0
	// A bus error is not reported.
	BUS_BUSMCNTDMA_IERES_1 = 0x1

	// BUS3ERRADD: Bus Error Address Register 3
	// Position of BERAD field.
	BUS_BUS3ERRADD_BERAD_Pos = 0x0
	// Bit mask of BERAD field.
	BUS_BUS3ERRADD_BERAD_Msk = 0xffffffff

	// BUS3ERRSTAT: BUS Error Status Register 3
	// Position of ACCSTAT field.
	BUS_BUS3ERRSTAT_ACCSTAT_Pos = 0x0
	// Bit mask of ACCSTAT field.
	BUS_BUS3ERRSTAT_ACCSTAT_Msk = 0x1
	// Bit ACCSTAT.
	BUS_BUS3ERRSTAT_ACCSTAT = 0x1
	// Read access
	BUS_BUS3ERRSTAT_ACCSTAT_0 = 0x0
	// Write access
	BUS_BUS3ERRSTAT_ACCSTAT_1 = 0x1
	// Position of ERRSTAT field.
	BUS_BUS3ERRSTAT_ERRSTAT_Pos = 0x7
	// Bit mask of ERRSTAT field.
	BUS_BUS3ERRSTAT_ERRSTAT_Msk = 0x80
	// Bit ERRSTAT.
	BUS_BUS3ERRSTAT_ERRSTAT = 0x80
	// No bus error occurred.
	BUS_BUS3ERRSTAT_ERRSTAT_0 = 0x0
	// Bus error occurred.
	BUS_BUS3ERRSTAT_ERRSTAT_1 = 0x1

	// BUS4ERRADD: Bus Error Address Register 4
	// Position of BERAD field.
	BUS_BUS4ERRADD_BERAD_Pos = 0x0
	// Bit mask of BERAD field.
	BUS_BUS4ERRADD_BERAD_Msk = 0xffffffff

	// BUS4ERRSTAT: BUS Error Status Register 4
	// Position of ACCSTAT field.
	BUS_BUS4ERRSTAT_ACCSTAT_Pos = 0x0
	// Bit mask of ACCSTAT field.
	BUS_BUS4ERRSTAT_ACCSTAT_Msk = 0x1
	// Bit ACCSTAT.
	BUS_BUS4ERRSTAT_ACCSTAT = 0x1
	// Read access
	BUS_BUS4ERRSTAT_ACCSTAT_0 = 0x0
	// Write access
	BUS_BUS4ERRSTAT_ACCSTAT_1 = 0x1
	// Position of ERRSTAT field.
	BUS_BUS4ERRSTAT_ERRSTAT_Pos = 0x7
	// Bit mask of ERRSTAT field.
	BUS_BUS4ERRSTAT_ERRSTAT_Msk = 0x80
	// Bit ERRSTAT.
	BUS_BUS4ERRSTAT_ERRSTAT = 0x80
	// No bus error occurred.
	BUS_BUS4ERRSTAT_ERRSTAT_0 = 0x0
	// Bus error occurred.
	BUS_BUS4ERRSTAT_ERRSTAT_1 = 0x1
)

// Constants for DTC: Data Transfer Controller
const (
	// DTCCR: DTC Control Register
	// Position of RRS field.
	DTC_DTCCR_RRS_Pos = 0x4
	// Bit mask of RRS field.
	DTC_DTCCR_RRS_Msk = 0x10
	// Bit RRS.
	DTC_DTCCR_RRS = 0x10
	// Transfer information read is not skipped
	DTC_DTCCR_RRS_0 = 0x0
	// Transfer information read is skipped when vector numbers match
	DTC_DTCCR_RRS_1 = 0x1

	// DTCST: DTC Module Start Register
	// Position of DTCST field.
	DTC_DTCST_DTCST_Pos = 0x0
	// Bit mask of DTCST field.
	DTC_DTCST_DTCST_Msk = 0x1
	// Bit DTCST.
	DTC_DTCST_DTCST = 0x1
	// DTC module stopped.
	DTC_DTCST_DTCST_0 = 0x0
	// DTC module started.
	DTC_DTCST_DTCST_1 = 0x1

	// DTCSTS: DTC Status Register
	// Position of VECN field.
	DTC_DTCSTS_VECN_Pos = 0x0
	// Bit mask of VECN field.
	DTC_DTCSTS_VECN_Msk = 0xff
	// Position of ACT field.
	DTC_DTCSTS_ACT_Pos = 0xf
	// Bit mask of ACT field.
	DTC_DTCSTS_ACT_Msk = 0x8000
	// Bit ACT.
	DTC_DTCSTS_ACT = 0x8000
	// DTC transfer operation is not in progress.
	DTC_DTCSTS_ACT_0 = 0x0
	// DTC transfer operation is in progress.
	DTC_DTCSTS_ACT_1 = 0x1
)

// Constants for ICU: ICU for CPU
const (
	// IRQCR0: IRQ Control Register %s
	// Position of IRQMD field.
	ICU_IRQCR_IRQMD_Pos = 0x0
	// Bit mask of IRQMD field.
	ICU_IRQCR_IRQMD_Msk = 0x3
	// Falling edge
	ICU_IRQCR_IRQMD_00 = 0x0
	// Rising edge
	ICU_IRQCR_IRQMD_01 = 0x1
	// Rising and falling edges
	ICU_IRQCR_IRQMD_10 = 0x2
	// Low level
	ICU_IRQCR_IRQMD_11 = 0x3
	// Position of FCLKSEL field.
	ICU_IRQCR_FCLKSEL_Pos = 0x4
	// Bit mask of FCLKSEL field.
	ICU_IRQCR_FCLKSEL_Msk = 0x30
	// PCLKB
	ICU_IRQCR_FCLKSEL_00 = 0x0
	// PCLKB/8
	ICU_IRQCR_FCLKSEL_01 = 0x1
	// PCLKB/32
	ICU_IRQCR_FCLKSEL_10 = 0x2
	// PCLKB/64
	ICU_IRQCR_FCLKSEL_11 = 0x3
	// Position of FLTEN field.
	ICU_IRQCR_FLTEN_Pos = 0x7
	// Bit mask of FLTEN field.
	ICU_IRQCR_FLTEN_Msk = 0x80
	// Bit FLTEN.
	ICU_IRQCR_FLTEN = 0x80
	// Digital filter is disabled
	ICU_IRQCR_FLTEN_0 = 0x0
	// Digital filter is enabled.
	ICU_IRQCR_FLTEN_1 = 0x1

	// NMICR: NMI Pin Interrupt Control Register
	// Position of NMIMD field.
	ICU_NMICR_NMIMD_Pos = 0x0
	// Bit mask of NMIMD field.
	ICU_NMICR_NMIMD_Msk = 0x1
	// Bit NMIMD.
	ICU_NMICR_NMIMD = 0x1
	// Falling edge
	ICU_NMICR_NMIMD_0 = 0x0
	// Rising edge
	ICU_NMICR_NMIMD_1 = 0x1
	// Position of NFCLKSEL field.
	ICU_NMICR_NFCLKSEL_Pos = 0x4
	// Bit mask of NFCLKSEL field.
	ICU_NMICR_NFCLKSEL_Msk = 0x30
	// PCLKB
	ICU_NMICR_NFCLKSEL_00 = 0x0
	// PCLKB/8
	ICU_NMICR_NFCLKSEL_01 = 0x1
	// PCLKB/32
	ICU_NMICR_NFCLKSEL_10 = 0x2
	// PCLKB/64
	ICU_NMICR_NFCLKSEL_11 = 0x3
	// Position of NFLTEN field.
	ICU_NMICR_NFLTEN_Pos = 0x7
	// Bit mask of NFLTEN field.
	ICU_NMICR_NFLTEN_Msk = 0x80
	// Bit NFLTEN.
	ICU_NMICR_NFLTEN = 0x80
	// Disabled.
	ICU_NMICR_NFLTEN_0 = 0x0
	// Enabled.
	ICU_NMICR_NFLTEN_1 = 0x1

	// NMIER: Non-Maskable Interrupt Enable Register
	// Position of IWDTEN field.
	ICU_NMIER_IWDTEN_Pos = 0x0
	// Bit mask of IWDTEN field.
	ICU_NMIER_IWDTEN_Msk = 0x1
	// Bit IWDTEN.
	ICU_NMIER_IWDTEN = 0x1
	// Disabled
	ICU_NMIER_IWDTEN_0 = 0x0
	// Enabled.
	ICU_NMIER_IWDTEN_1 = 0x1
	// Position of WDTEN field.
	ICU_NMIER_WDTEN_Pos = 0x1
	// Bit mask of WDTEN field.
	ICU_NMIER_WDTEN_Msk = 0x2
	// Bit WDTEN.
	ICU_NMIER_WDTEN = 0x2
	// Disabled
	ICU_NMIER_WDTEN_0 = 0x0
	// Enabled
	ICU_NMIER_WDTEN_1 = 0x1
	// Position of LVD1EN field.
	ICU_NMIER_LVD1EN_Pos = 0x2
	// Bit mask of LVD1EN field.
	ICU_NMIER_LVD1EN_Msk = 0x4
	// Bit LVD1EN.
	ICU_NMIER_LVD1EN = 0x4
	// Disabled
	ICU_NMIER_LVD1EN_0 = 0x0
	// Enabled
	ICU_NMIER_LVD1EN_1 = 0x1
	// Position of LVD2EN field.
	ICU_NMIER_LVD2EN_Pos = 0x3
	// Bit mask of LVD2EN field.
	ICU_NMIER_LVD2EN_Msk = 0x8
	// Bit LVD2EN.
	ICU_NMIER_LVD2EN = 0x8
	// Disabled
	ICU_NMIER_LVD2EN_0 = 0x0
	// Enabled
	ICU_NMIER_LVD2EN_1 = 0x1
	// Position of OSTEN field.
	ICU_NMIER_OSTEN_Pos = 0x6
	// Bit mask of OSTEN field.
	ICU_NMIER_OSTEN_Msk = 0x40
	// Bit OSTEN.
	ICU_NMIER_OSTEN = 0x40
	// Disabled
	ICU_NMIER_OSTEN_0 = 0x0
	// Enabled
	ICU_NMIER_OSTEN_1 = 0x1
	// Position of NMIEN field.
	ICU_NMIER_NMIEN_Pos = 0x7
	// Bit mask of NMIEN field.
	ICU_NMIER_NMIEN_Msk = 0x80
	// Bit NMIEN.
	ICU_NMIER_NMIEN = 0x80
	// Disabled
	ICU_NMIER_NMIEN_0 = 0x0
	// Enabled
	ICU_NMIER_NMIEN_1 = 0x1
	// Position of RPEEN field.
	ICU_NMIER_RPEEN_Pos = 0x8
	// Bit mask of RPEEN field.
	ICU_NMIER_RPEEN_Msk = 0x100
	// Bit RPEEN.
	ICU_NMIER_RPEEN = 0x100
	// Disabled
	ICU_NMIER_RPEEN_0 = 0x0
	// Enabled
	ICU_NMIER_RPEEN_1 = 0x1
	// Position of BUSSEN field.
	ICU_NMIER_BUSSEN_Pos = 0xa
	// Bit mask of BUSSEN field.
	ICU_NMIER_BUSSEN_Msk = 0x400
	// Bit BUSSEN.
	ICU_NMIER_BUSSEN = 0x400
	// Disabled
	ICU_NMIER_BUSSEN_0 = 0x0
	// Enabled
	ICU_NMIER_BUSSEN_1 = 0x1
	// Position of BUSMEN field.
	ICU_NMIER_BUSMEN_Pos = 0xb
	// Bit mask of BUSMEN field.
	ICU_NMIER_BUSMEN_Msk = 0x800
	// Bit BUSMEN.
	ICU_NMIER_BUSMEN = 0x800
	// Disabled
	ICU_NMIER_BUSMEN_0 = 0x0
	// Enabled
	ICU_NMIER_BUSMEN_1 = 0x1
	// Position of SPEEN field.
	ICU_NMIER_SPEEN_Pos = 0xc
	// Bit mask of SPEEN field.
	ICU_NMIER_SPEEN_Msk = 0x1000
	// Bit SPEEN.
	ICU_NMIER_SPEEN = 0x1000
	// Disabled
	ICU_NMIER_SPEEN_0 = 0x0
	// Enabled
	ICU_NMIER_SPEEN_1 = 0x1

	// NMICLR: Non-Maskable Interrupt Status Clear Register
	// Position of IWDTCLR field.
	ICU_NMICLR_IWDTCLR_Pos = 0x0
	// Bit mask of IWDTCLR field.
	ICU_NMICLR_IWDTCLR_Msk = 0x1
	// Bit IWDTCLR.
	ICU_NMICLR_IWDTCLR = 0x1
	// No effect
	ICU_NMICLR_IWDTCLR_0 = 0x0
	// Clear the NMISR.IWDTST flag
	ICU_NMICLR_IWDTCLR_1 = 0x1
	// Position of WDTCLR field.
	ICU_NMICLR_WDTCLR_Pos = 0x1
	// Bit mask of WDTCLR field.
	ICU_NMICLR_WDTCLR_Msk = 0x2
	// Bit WDTCLR.
	ICU_NMICLR_WDTCLR = 0x2
	// No effect
	ICU_NMICLR_WDTCLR_0 = 0x0
	// Clear the NMISR.WDTST flag
	ICU_NMICLR_WDTCLR_1 = 0x1
	// Position of LVD1CLR field.
	ICU_NMICLR_LVD1CLR_Pos = 0x2
	// Bit mask of LVD1CLR field.
	ICU_NMICLR_LVD1CLR_Msk = 0x4
	// Bit LVD1CLR.
	ICU_NMICLR_LVD1CLR = 0x4
	// No effect
	ICU_NMICLR_LVD1CLR_0 = 0x0
	// Clear the NMISR.LVD1ST flag
	ICU_NMICLR_LVD1CLR_1 = 0x1
	// Position of LVD2CLR field.
	ICU_NMICLR_LVD2CLR_Pos = 0x3
	// Bit mask of LVD2CLR field.
	ICU_NMICLR_LVD2CLR_Msk = 0x8
	// Bit LVD2CLR.
	ICU_NMICLR_LVD2CLR = 0x8
	// No effect
	ICU_NMICLR_LVD2CLR_0 = 0x0
	// Clear the NMISR.LVD2ST flag.
	ICU_NMICLR_LVD2CLR_1 = 0x1
	// Position of OSTCLR field.
	ICU_NMICLR_OSTCLR_Pos = 0x6
	// Bit mask of OSTCLR field.
	ICU_NMICLR_OSTCLR_Msk = 0x40
	// Bit OSTCLR.
	ICU_NMICLR_OSTCLR = 0x40
	// No effect
	ICU_NMICLR_OSTCLR_0 = 0x0
	// Clear the NMISR.OSTST flag
	ICU_NMICLR_OSTCLR_1 = 0x1
	// Position of NMICLR field.
	ICU_NMICLR_NMICLR_Pos = 0x7
	// Bit mask of NMICLR field.
	ICU_NMICLR_NMICLR_Msk = 0x80
	// Bit NMICLR.
	ICU_NMICLR_NMICLR = 0x80
	// No effect
	ICU_NMICLR_NMICLR_0 = 0x0
	// Clear the NMISR.NMIST flag
	ICU_NMICLR_NMICLR_1 = 0x1
	// Position of RPECLR field.
	ICU_NMICLR_RPECLR_Pos = 0x8
	// Bit mask of RPECLR field.
	ICU_NMICLR_RPECLR_Msk = 0x100
	// Bit RPECLR.
	ICU_NMICLR_RPECLR = 0x100
	// No effect
	ICU_NMICLR_RPECLR_0 = 0x0
	// Clear the NMISR.RPEST flag
	ICU_NMICLR_RPECLR_1 = 0x1
	// Position of BUSSCLR field.
	ICU_NMICLR_BUSSCLR_Pos = 0xa
	// Bit mask of BUSSCLR field.
	ICU_NMICLR_BUSSCLR_Msk = 0x400
	// Bit BUSSCLR.
	ICU_NMICLR_BUSSCLR = 0x400
	// No effect
	ICU_NMICLR_BUSSCLR_0 = 0x0
	// Clear the NMISR.BUSSST flag
	ICU_NMICLR_BUSSCLR_1 = 0x1
	// Position of BUSMCLR field.
	ICU_NMICLR_BUSMCLR_Pos = 0xb
	// Bit mask of BUSMCLR field.
	ICU_NMICLR_BUSMCLR_Msk = 0x800
	// Bit BUSMCLR.
	ICU_NMICLR_BUSMCLR = 0x800
	// No effect
	ICU_NMICLR_BUSMCLR_0 = 0x0
	// Clear the NMISR.BUSMST flag
	ICU_NMICLR_BUSMCLR_1 = 0x1
	// Position of SPECLR field.
	ICU_NMICLR_SPECLR_Pos = 0xc
	// Bit mask of SPECLR field.
	ICU_NMICLR_SPECLR_Msk = 0x1000
	// Bit SPECLR.
	ICU_NMICLR_SPECLR = 0x1000
	// No effect
	ICU_NMICLR_SPECLR_0 = 0x0
	// Clear the NMISR.SPEST flag
	ICU_NMICLR_SPECLR_1 = 0x1

	// NMISR: Non-Maskable Interrupt Status Register
	// Position of IWDTST field.
	ICU_NMISR_IWDTST_Pos = 0x0
	// Bit mask of IWDTST field.
	ICU_NMISR_IWDTST_Msk = 0x1
	// Bit IWDTST.
	ICU_NMISR_IWDTST = 0x1
	// Interrupt not requested
	ICU_NMISR_IWDTST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_IWDTST_1 = 0x1
	// Position of WDTST field.
	ICU_NMISR_WDTST_Pos = 0x1
	// Bit mask of WDTST field.
	ICU_NMISR_WDTST_Msk = 0x2
	// Bit WDTST.
	ICU_NMISR_WDTST = 0x2
	// Interrupt not requested
	ICU_NMISR_WDTST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_WDTST_1 = 0x1
	// Position of LVD1ST field.
	ICU_NMISR_LVD1ST_Pos = 0x2
	// Bit mask of LVD1ST field.
	ICU_NMISR_LVD1ST_Msk = 0x4
	// Bit LVD1ST.
	ICU_NMISR_LVD1ST = 0x4
	// Interrupt not requested
	ICU_NMISR_LVD1ST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_LVD1ST_1 = 0x1
	// Position of LVD2ST field.
	ICU_NMISR_LVD2ST_Pos = 0x3
	// Bit mask of LVD2ST field.
	ICU_NMISR_LVD2ST_Msk = 0x8
	// Bit LVD2ST.
	ICU_NMISR_LVD2ST = 0x8
	// Interrupt not requested
	ICU_NMISR_LVD2ST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_LVD2ST_1 = 0x1
	// Position of OSTST field.
	ICU_NMISR_OSTST_Pos = 0x6
	// Bit mask of OSTST field.
	ICU_NMISR_OSTST_Msk = 0x40
	// Bit OSTST.
	ICU_NMISR_OSTST = 0x40
	// Interrupt not requested for main clock oscillation stop
	ICU_NMISR_OSTST_0 = 0x0
	// Interrupt requested for main clock oscillation stop
	ICU_NMISR_OSTST_1 = 0x1
	// Position of NMIST field.
	ICU_NMISR_NMIST_Pos = 0x7
	// Bit mask of NMIST field.
	ICU_NMISR_NMIST_Msk = 0x80
	// Bit NMIST.
	ICU_NMISR_NMIST = 0x80
	// Interrupt not requested
	ICU_NMISR_NMIST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_NMIST_1 = 0x1
	// Position of RPEST field.
	ICU_NMISR_RPEST_Pos = 0x8
	// Bit mask of RPEST field.
	ICU_NMISR_RPEST_Msk = 0x100
	// Bit RPEST.
	ICU_NMISR_RPEST = 0x100
	// Interrupt not requested
	ICU_NMISR_RPEST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_RPEST_1 = 0x1
	// Position of BUSSST field.
	ICU_NMISR_BUSSST_Pos = 0xa
	// Bit mask of BUSSST field.
	ICU_NMISR_BUSSST_Msk = 0x400
	// Bit BUSSST.
	ICU_NMISR_BUSSST = 0x400
	// Interrupt not requested
	ICU_NMISR_BUSSST_0 = 0x0
	// Interrupt requested.
	ICU_NMISR_BUSSST_1 = 0x1
	// Position of BUSMST field.
	ICU_NMISR_BUSMST_Pos = 0xb
	// Bit mask of BUSMST field.
	ICU_NMISR_BUSMST_Msk = 0x800
	// Bit BUSMST.
	ICU_NMISR_BUSMST = 0x800
	// Interrupt not requested
	ICU_NMISR_BUSMST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_BUSMST_1 = 0x1
	// Position of SPEST field.
	ICU_NMISR_SPEST_Pos = 0xc
	// Bit mask of SPEST field.
	ICU_NMISR_SPEST_Msk = 0x1000
	// Bit SPEST.
	ICU_NMISR_SPEST = 0x1000
	// Interrupt not requested
	ICU_NMISR_SPEST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_SPEST_1 = 0x1

	// WUPEN: Wake Up Interrupt Enable Register
	// Position of IRQWUPEN field.
	ICU_WUPEN_IRQWUPEN_Pos = 0x0
	// Bit mask of IRQWUPEN field.
	ICU_WUPEN_IRQWUPEN_Msk = 0xff
	// Software Standby/Snooze Mode returns by IRQn interrupt disabled
	ICU_WUPEN_IRQWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by IRQn interrupt enabled
	ICU_WUPEN_IRQWUPEN_1 = 0x1
	// Position of IWDTWUPEN field.
	ICU_WUPEN_IWDTWUPEN_Pos = 0x10
	// Bit mask of IWDTWUPEN field.
	ICU_WUPEN_IWDTWUPEN_Msk = 0x10000
	// Bit IWDTWUPEN.
	ICU_WUPEN_IWDTWUPEN = 0x10000
	// Software Standby/Snooze Mode returns by IWDT interrupt disabled
	ICU_WUPEN_IWDTWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by IWDT interrupt enabled
	ICU_WUPEN_IWDTWUPEN_1 = 0x1
	// Position of KEYWUPEN field.
	ICU_WUPEN_KEYWUPEN_Pos = 0x11
	// Bit mask of KEYWUPEN field.
	ICU_WUPEN_KEYWUPEN_Msk = 0x20000
	// Bit KEYWUPEN.
	ICU_WUPEN_KEYWUPEN = 0x20000
	// Software Standby/Snooze Mode returns by KEY interrupt disabled
	ICU_WUPEN_KEYWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by KEY interrupt enabled
	ICU_WUPEN_KEYWUPEN_1 = 0x1
	// Position of LVD1WUPEN field.
	ICU_WUPEN_LVD1WUPEN_Pos = 0x12
	// Bit mask of LVD1WUPEN field.
	ICU_WUPEN_LVD1WUPEN_Msk = 0x40000
	// Bit LVD1WUPEN.
	ICU_WUPEN_LVD1WUPEN = 0x40000
	// Software Standby/Snooze Mode returns by LVD1 interrupt disabled
	ICU_WUPEN_LVD1WUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by LVD1 interrupt enabled
	ICU_WUPEN_LVD1WUPEN_1 = 0x1
	// Position of LVD2WUPEN field.
	ICU_WUPEN_LVD2WUPEN_Pos = 0x13
	// Bit mask of LVD2WUPEN field.
	ICU_WUPEN_LVD2WUPEN_Msk = 0x80000
	// Bit LVD2WUPEN.
	ICU_WUPEN_LVD2WUPEN = 0x80000
	// Software Standby/Snooze Mode returns by LVD2 interrupt disabled
	ICU_WUPEN_LVD2WUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by LVD2 interrupt enabled
	ICU_WUPEN_LVD2WUPEN_1 = 0x1
	// Position of ACMPLP0WUPEN field.
	ICU_WUPEN_ACMPLP0WUPEN_Pos = 0x17
	// Bit mask of ACMPLP0WUPEN field.
	ICU_WUPEN_ACMPLP0WUPEN_Msk = 0x800000
	// Bit ACMPLP0WUPEN.
	ICU_WUPEN_ACMPLP0WUPEN = 0x800000
	// Software Standby/Snooze Mode returns by ACMPLP0 interrupt disabled
	ICU_WUPEN_ACMPLP0WUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by ACMPLP0 interrupt enabled
	ICU_WUPEN_ACMPLP0WUPEN_1 = 0x1
	// Position of RTCALMWUPEN field.
	ICU_WUPEN_RTCALMWUPEN_Pos = 0x18
	// Bit mask of RTCALMWUPEN field.
	ICU_WUPEN_RTCALMWUPEN_Msk = 0x1000000
	// Bit RTCALMWUPEN.
	ICU_WUPEN_RTCALMWUPEN = 0x1000000
	// Software Standby/Snooze Mode returns by RTC alarm interrupt disabled
	ICU_WUPEN_RTCALMWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by RTC alarm interrupt enabled.
	ICU_WUPEN_RTCALMWUPEN_1 = 0x1
	// Position of RTCPRDWUPEN field.
	ICU_WUPEN_RTCPRDWUPEN_Pos = 0x19
	// Bit mask of RTCPRDWUPEN field.
	ICU_WUPEN_RTCPRDWUPEN_Msk = 0x2000000
	// Bit RTCPRDWUPEN.
	ICU_WUPEN_RTCPRDWUPEN = 0x2000000
	// Software Standby/Snooze Mode returns by RTC period interrupt disabled
	ICU_WUPEN_RTCPRDWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by RTC period interrupt enabled
	ICU_WUPEN_RTCPRDWUPEN_1 = 0x1
	// Position of AGT1UDWUPEN field.
	ICU_WUPEN_AGT1UDWUPEN_Pos = 0x1c
	// Bit mask of AGT1UDWUPEN field.
	ICU_WUPEN_AGT1UDWUPEN_Msk = 0x10000000
	// Bit AGT1UDWUPEN.
	ICU_WUPEN_AGT1UDWUPEN = 0x10000000
	// Software Standby/Snooze Mode returns by AGT1 underflow interrupt disabled
	ICU_WUPEN_AGT1UDWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by AGT1 underflow
	ICU_WUPEN_AGT1UDWUPEN_1 = 0x1
	// Position of AGT1CAWUPEN field.
	ICU_WUPEN_AGT1CAWUPEN_Pos = 0x1d
	// Bit mask of AGT1CAWUPEN field.
	ICU_WUPEN_AGT1CAWUPEN_Msk = 0x20000000
	// Bit AGT1CAWUPEN.
	ICU_WUPEN_AGT1CAWUPEN = 0x20000000
	// Software Standby/Snooze Mode returns by AGT1 compare match A interrupt disabled.
	ICU_WUPEN_AGT1CAWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by AGT1 compare match A interrupt enabled.
	ICU_WUPEN_AGT1CAWUPEN_1 = 0x1
	// Position of AGT1CBWUPEN field.
	ICU_WUPEN_AGT1CBWUPEN_Pos = 0x1e
	// Bit mask of AGT1CBWUPEN field.
	ICU_WUPEN_AGT1CBWUPEN_Msk = 0x40000000
	// Bit AGT1CBWUPEN.
	ICU_WUPEN_AGT1CBWUPEN = 0x40000000
	// Software Standby/Snooze Mode returns by AGT1 compare match B interrupt disabled.
	ICU_WUPEN_AGT1CBWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by AGT1 compare match B interrupt enabled.
	ICU_WUPEN_AGT1CBWUPEN_1 = 0x1
	// Position of IIC0WUPEN field.
	ICU_WUPEN_IIC0WUPEN_Pos = 0x1f
	// Bit mask of IIC0WUPEN field.
	ICU_WUPEN_IIC0WUPEN_Msk = 0x80000000
	// Bit IIC0WUPEN.
	ICU_WUPEN_IIC0WUPEN = 0x80000000
	// Software Standby/Snooze Mode returns by IIC0 address match interrupt disabled
	ICU_WUPEN_IIC0WUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by IIC0 address match interrupt enabled
	ICU_WUPEN_IIC0WUPEN_1 = 0x1

	// IELEN: ICU event Enable Register
	// Position of RTCINTEN field.
	ICU_IELEN_RTCINTEN_Pos = 0x0
	// Bit mask of RTCINTEN field.
	ICU_IELEN_RTCINTEN_Msk = 0x1
	// Bit RTCINTEN.
	ICU_IELEN_RTCINTEN = 0x1
	// Disabled
	ICU_IELEN_RTCINTEN_0 = 0x0
	// Enabled
	ICU_IELEN_RTCINTEN_1 = 0x1
	// Position of IELEN field.
	ICU_IELEN_IELEN_Pos = 0x1
	// Bit mask of IELEN field.
	ICU_IELEN_IELEN_Msk = 0x2
	// Bit IELEN.
	ICU_IELEN_IELEN = 0x2
	// Disabled
	ICU_IELEN_IELEN_0 = 0x0
	// Enabled
	ICU_IELEN_IELEN_1 = 0x1
)

// Constants for DBG: Debug Function
const (
	// DBGSTR: Debug Status Register
	// Position of CDBGPWRUPREQ field.
	DBG_DBGSTR_CDBGPWRUPREQ_Pos = 0x1c
	// Bit mask of CDBGPWRUPREQ field.
	DBG_DBGSTR_CDBGPWRUPREQ_Msk = 0x10000000
	// Bit CDBGPWRUPREQ.
	DBG_DBGSTR_CDBGPWRUPREQ = 0x10000000
	// OCD is not requesting debug power up
	DBG_DBGSTR_CDBGPWRUPREQ_0 = 0x0
	// OCD is requesting debug power up
	DBG_DBGSTR_CDBGPWRUPREQ_1 = 0x1
	// Position of CDBGPWRUPACK field.
	DBG_DBGSTR_CDBGPWRUPACK_Pos = 0x1d
	// Bit mask of CDBGPWRUPACK field.
	DBG_DBGSTR_CDBGPWRUPACK_Msk = 0x20000000
	// Bit CDBGPWRUPACK.
	DBG_DBGSTR_CDBGPWRUPACK = 0x20000000
	// Debug power-up request is not acknowledged
	DBG_DBGSTR_CDBGPWRUPACK_0 = 0x0
	// Debug power-up request is acknowledged
	DBG_DBGSTR_CDBGPWRUPACK_1 = 0x1

	// DBGSTOPCR: Debug Stop Control Register
	// Position of DBGSTOP_IWDT field.
	DBG_DBGSTOPCR_DBGSTOP_IWDT_Pos = 0x0
	// Bit mask of DBGSTOP_IWDT field.
	DBG_DBGSTOPCR_DBGSTOP_IWDT_Msk = 0x1
	// Bit DBGSTOP_IWDT.
	DBG_DBGSTOPCR_DBGSTOP_IWDT = 0x1
	// Enable IWDT reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_IWDT_0 = 0x0
	// Mask IWDT reset/interrupt and stop IWDT counter
	DBG_DBGSTOPCR_DBGSTOP_IWDT_1 = 0x1
	// Position of DBGSTOP_WDT field.
	DBG_DBGSTOPCR_DBGSTOP_WDT_Pos = 0x1
	// Bit mask of DBGSTOP_WDT field.
	DBG_DBGSTOPCR_DBGSTOP_WDT_Msk = 0x2
	// Bit DBGSTOP_WDT.
	DBG_DBGSTOPCR_DBGSTOP_WDT = 0x2
	// Enable WDT reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_WDT_0 = 0x0
	// Mask WDT reset/interrupt and stop WDT counter
	DBG_DBGSTOPCR_DBGSTOP_WDT_1 = 0x1
	// Position of DBGSTOP_LVD0 field.
	DBG_DBGSTOPCR_DBGSTOP_LVD0_Pos = 0x10
	// Bit mask of DBGSTOP_LVD0 field.
	DBG_DBGSTOPCR_DBGSTOP_LVD0_Msk = 0x10000
	// Bit DBGSTOP_LVD0.
	DBG_DBGSTOPCR_DBGSTOP_LVD0 = 0x10000
	// Enable LVD0 reset
	DBG_DBGSTOPCR_DBGSTOP_LVD0_0 = 0x0
	// Mask LVD0 reset
	DBG_DBGSTOPCR_DBGSTOP_LVD0_1 = 0x1
	// Position of DBGSTOP_LVD1 field.
	DBG_DBGSTOPCR_DBGSTOP_LVD1_Pos = 0x11
	// Bit mask of DBGSTOP_LVD1 field.
	DBG_DBGSTOPCR_DBGSTOP_LVD1_Msk = 0x20000
	// Bit DBGSTOP_LVD1.
	DBG_DBGSTOPCR_DBGSTOP_LVD1 = 0x20000
	// Enable LVD1 reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_LVD1_0 = 0x0
	// Mask LVD1 reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_LVD1_1 = 0x1
	// Position of DBGSTOP_LVD2 field.
	DBG_DBGSTOPCR_DBGSTOP_LVD2_Pos = 0x12
	// Bit mask of DBGSTOP_LVD2 field.
	DBG_DBGSTOPCR_DBGSTOP_LVD2_Msk = 0x40000
	// Bit DBGSTOP_LVD2.
	DBG_DBGSTOPCR_DBGSTOP_LVD2 = 0x40000
	// Enable LVD2 reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_LVD2_0 = 0x0
	// Mask LVD2 reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_LVD2_1 = 0x1
	// Position of DBGSTOP_RPER field.
	DBG_DBGSTOPCR_DBGSTOP_RPER_Pos = 0x18
	// Bit mask of DBGSTOP_RPER field.
	DBG_DBGSTOPCR_DBGSTOP_RPER_Msk = 0x1000000
	// Bit DBGSTOP_RPER.
	DBG_DBGSTOPCR_DBGSTOP_RPER = 0x1000000
	// Enable SRAM parity error reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_RPER_0 = 0x0
	// Mask SRAM parity error reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_RPER_1 = 0x1
)

// Constants for SYSC: System Control
const (
	// SBYCR: Standby Control Register
	// Position of SSBY field.
	SYSC_SBYCR_SSBY_Pos = 0xf
	// Bit mask of SSBY field.
	SYSC_SBYCR_SSBY_Msk = 0x8000
	// Bit SSBY.
	SYSC_SBYCR_SSBY = 0x8000
	// Sleep mode
	SYSC_SBYCR_SSBY_0 = 0x0
	// Software Standby mode.
	SYSC_SBYCR_SSBY_1 = 0x1

	// MSTPCRA: Module Stop Control Register A
	// Position of MSTPA22 field.
	SYSC_MSTPCRA_MSTPA22_Pos = 0x16
	// Bit mask of MSTPA22 field.
	SYSC_MSTPCRA_MSTPA22_Msk = 0x400000
	// Bit MSTPA22.
	SYSC_MSTPCRA_MSTPA22 = 0x400000
	// Cancel the module-stop state
	SYSC_MSTPCRA_MSTPA22_0 = 0x0
	// Enter the module-stop state
	SYSC_MSTPCRA_MSTPA22_1 = 0x1

	// SCKDIVCR: System Clock Division Control Register
	// Position of PCKD field.
	SYSC_SCKDIVCR_PCKD_Pos = 0x0
	// Bit mask of PCKD field.
	SYSC_SCKDIVCR_PCKD_Msk = 0x7
	// x 1/1
	SYSC_SCKDIVCR_PCKD_000 = 0x0
	// x 1/2
	SYSC_SCKDIVCR_PCKD_001 = 0x1
	// x 1/4
	SYSC_SCKDIVCR_PCKD_010 = 0x2
	// x 1/8
	SYSC_SCKDIVCR_PCKD_011 = 0x3
	// x 1/16
	SYSC_SCKDIVCR_PCKD_100 = 0x4
	// x 1/32
	SYSC_SCKDIVCR_PCKD_101 = 0x5
	// x 1/64
	SYSC_SCKDIVCR_PCKD_110 = 0x6
	// Position of PCKB field.
	SYSC_SCKDIVCR_PCKB_Pos = 0x8
	// Bit mask of PCKB field.
	SYSC_SCKDIVCR_PCKB_Msk = 0x700
	// x 1/1
	SYSC_SCKDIVCR_PCKB_000 = 0x0
	// x 1/2
	SYSC_SCKDIVCR_PCKB_001 = 0x1
	// x 1/4
	SYSC_SCKDIVCR_PCKB_010 = 0x2
	// x 1/8
	SYSC_SCKDIVCR_PCKB_011 = 0x3
	// x 1/16
	SYSC_SCKDIVCR_PCKB_100 = 0x4
	// x 1/32
	SYSC_SCKDIVCR_PCKB_101 = 0x5
	// x 1/64
	SYSC_SCKDIVCR_PCKB_110 = 0x6
	// Position of ICK field.
	SYSC_SCKDIVCR_ICK_Pos = 0x18
	// Bit mask of ICK field.
	SYSC_SCKDIVCR_ICK_Msk = 0x7000000
	// x 1/1
	SYSC_SCKDIVCR_ICK_000 = 0x0
	// x 1/2
	SYSC_SCKDIVCR_ICK_001 = 0x1
	// x 1/4
	SYSC_SCKDIVCR_ICK_010 = 0x2
	// x 1/8
	SYSC_SCKDIVCR_ICK_011 = 0x3
	// x 1/16
	SYSC_SCKDIVCR_ICK_100 = 0x4
	// x 1/32
	SYSC_SCKDIVCR_ICK_101 = 0x5
	// x 1/64
	SYSC_SCKDIVCR_ICK_110 = 0x6

	// SCKSCR: System Clock Source Control Register
	// Position of CKSEL field.
	SYSC_SCKSCR_CKSEL_Pos = 0x0
	// Bit mask of CKSEL field.
	SYSC_SCKSCR_CKSEL_Msk = 0x7
	// HOCO
	SYSC_SCKSCR_CKSEL_000 = 0x0
	// MOCO
	SYSC_SCKSCR_CKSEL_001 = 0x1
	// LOCO
	SYSC_SCKSCR_CKSEL_010 = 0x2
	// Main clock oscillator (MOSC)
	SYSC_SCKSCR_CKSEL_011 = 0x3
	// Sub-clock oscillator (SOSC)
	SYSC_SCKSCR_CKSEL_100 = 0x4
	// Setting prohibited
	SYSC_SCKSCR_CKSEL_101 = 0x5
	// Setting prohibited
	SYSC_SCKSCR_CKSEL_110 = 0x6
	// Setting prohibited
	SYSC_SCKSCR_CKSEL_111 = 0x7

	// MEMWAIT: Memory Wait Cycle Control Register for Code Flash
	// Position of MEMWAIT field.
	SYSC_MEMWAIT_MEMWAIT_Pos = 0x0
	// Bit mask of MEMWAIT field.
	SYSC_MEMWAIT_MEMWAIT_Msk = 0x1
	// Bit MEMWAIT.
	SYSC_MEMWAIT_MEMWAIT = 0x1
	// No wait
	SYSC_MEMWAIT_MEMWAIT_0 = 0x0
	// Wait
	SYSC_MEMWAIT_MEMWAIT_1 = 0x1

	// MOSCCR: Main Clock Oscillator Control Register
	// Position of MOSTP field.
	SYSC_MOSCCR_MOSTP_Pos = 0x0
	// Bit mask of MOSTP field.
	SYSC_MOSCCR_MOSTP_Msk = 0x1
	// Bit MOSTP.
	SYSC_MOSCCR_MOSTP = 0x1
	// Operate the main clock oscillator
	SYSC_MOSCCR_MOSTP_0 = 0x0
	// Stop the main clock oscillator
	SYSC_MOSCCR_MOSTP_1 = 0x1

	// HOCOCR: High-Speed On-Chip Oscillator Control Register
	// Position of HCSTP field.
	SYSC_HOCOCR_HCSTP_Pos = 0x0
	// Bit mask of HCSTP field.
	SYSC_HOCOCR_HCSTP_Msk = 0x1
	// Bit HCSTP.
	SYSC_HOCOCR_HCSTP = 0x1
	// Operate the HOCO clock
	SYSC_HOCOCR_HCSTP_0 = 0x0
	// Stop the HOCO clock
	SYSC_HOCOCR_HCSTP_1 = 0x1

	// MOCOCR: Middle-Speed On-Chip Oscillator Control Register
	// Position of MCSTP field.
	SYSC_MOCOCR_MCSTP_Pos = 0x0
	// Bit mask of MCSTP field.
	SYSC_MOCOCR_MCSTP_Msk = 0x1
	// Bit MCSTP.
	SYSC_MOCOCR_MCSTP = 0x1
	// MOCO clock is operating
	SYSC_MOCOCR_MCSTP_0 = 0x0
	// MOCO clock is stopped
	SYSC_MOCOCR_MCSTP_1 = 0x1

	// OSCSF: Oscillation Stabilization Flag Register
	// Position of HOCOSF field.
	SYSC_OSCSF_HOCOSF_Pos = 0x0
	// Bit mask of HOCOSF field.
	SYSC_OSCSF_HOCOSF_Msk = 0x1
	// Bit HOCOSF.
	SYSC_OSCSF_HOCOSF = 0x1
	// The HOCO clock is stopped or is not yet stable
	SYSC_OSCSF_HOCOSF_0 = 0x0
	// The HOCO clock is stable, so is available for use as the system clock
	SYSC_OSCSF_HOCOSF_1 = 0x1
	// Position of MOSCSF field.
	SYSC_OSCSF_MOSCSF_Pos = 0x3
	// Bit mask of MOSCSF field.
	SYSC_OSCSF_MOSCSF_Msk = 0x8
	// Bit MOSCSF.
	SYSC_OSCSF_MOSCSF = 0x8
	// The main clock oscillator is stopped (MOSTP = 1) or is not yet stable
	SYSC_OSCSF_MOSCSF_0 = 0x0
	// The main clock oscillator is stable, so is available for use as the system clock
	SYSC_OSCSF_MOSCSF_1 = 0x1

	// CKOCR: Clock Out Control Register
	// Position of CKOSEL field.
	SYSC_CKOCR_CKOSEL_Pos = 0x0
	// Bit mask of CKOSEL field.
	SYSC_CKOCR_CKOSEL_Msk = 0x7
	// HOCO (value after reset)
	SYSC_CKOCR_CKOSEL_000 = 0x0
	// MOCO
	SYSC_CKOCR_CKOSEL_001 = 0x1
	// LOCO
	SYSC_CKOCR_CKOSEL_010 = 0x2
	// MOSC
	SYSC_CKOCR_CKOSEL_011 = 0x3
	// SOSC
	SYSC_CKOCR_CKOSEL_100 = 0x4
	// Setting prohibited
	SYSC_CKOCR_CKOSEL_101 = 0x5
	// Position of CKODIV field.
	SYSC_CKOCR_CKODIV_Pos = 0x4
	// Bit mask of CKODIV field.
	SYSC_CKOCR_CKODIV_Msk = 0x70
	// x 1/1
	SYSC_CKOCR_CKODIV_000 = 0x0
	// x 1/2
	SYSC_CKOCR_CKODIV_001 = 0x1
	// x 1/4
	SYSC_CKOCR_CKODIV_010 = 0x2
	// x 1/8
	SYSC_CKOCR_CKODIV_011 = 0x3
	// x 1/16
	SYSC_CKOCR_CKODIV_100 = 0x4
	// x 1/32
	SYSC_CKOCR_CKODIV_101 = 0x5
	// x 1/64
	SYSC_CKOCR_CKODIV_110 = 0x6
	// x 1/128
	SYSC_CKOCR_CKODIV_111 = 0x7
	// Position of CKOEN field.
	SYSC_CKOCR_CKOEN_Pos = 0x7
	// Bit mask of CKOEN field.
	SYSC_CKOCR_CKOEN_Msk = 0x80
	// Bit CKOEN.
	SYSC_CKOCR_CKOEN = 0x80
	// Disable clock out
	SYSC_CKOCR_CKOEN_0 = 0x0
	// Enable clock out
	SYSC_CKOCR_CKOEN_1 = 0x1

	// OSTDCR: Oscillation Stop Detection Control Register
	// Position of OSTDIE field.
	SYSC_OSTDCR_OSTDIE_Pos = 0x0
	// Bit mask of OSTDIE field.
	SYSC_OSTDCR_OSTDIE_Msk = 0x1
	// Bit OSTDIE.
	SYSC_OSTDCR_OSTDIE = 0x1
	// Disable oscillation stop detection interrupt (do not notify the POEG)
	SYSC_OSTDCR_OSTDIE_0 = 0x0
	// Enable oscillation stop detection interrupt (notify the POEG)
	SYSC_OSTDCR_OSTDIE_1 = 0x1
	// Position of OSTDE field.
	SYSC_OSTDCR_OSTDE_Pos = 0x7
	// Bit mask of OSTDE field.
	SYSC_OSTDCR_OSTDE_Msk = 0x80
	// Bit OSTDE.
	SYSC_OSTDCR_OSTDE = 0x80
	// Disable oscillation stop detection function
	SYSC_OSTDCR_OSTDE_0 = 0x0
	// Enable oscillation stop detection function
	SYSC_OSTDCR_OSTDE_1 = 0x1

	// OSTDSR: Oscillation Stop Detection Status Register
	// Position of OSTDF field.
	SYSC_OSTDSR_OSTDF_Pos = 0x0
	// Bit mask of OSTDF field.
	SYSC_OSTDSR_OSTDF_Msk = 0x1
	// Bit OSTDF.
	SYSC_OSTDSR_OSTDF = 0x1
	// Main clock oscillation stop not detected
	SYSC_OSTDSR_OSTDF_0 = 0x0
	// Main clock oscillation stop detected
	SYSC_OSTDSR_OSTDF_1 = 0x1

	// LPOPT: Lower Power Operation Control Register
	// Position of MPUDIS field.
	SYSC_LPOPT_MPUDIS_Pos = 0x0
	// Bit mask of MPUDIS field.
	SYSC_LPOPT_MPUDIS_Msk = 0x1
	// Bit MPUDIS.
	SYSC_LPOPT_MPUDIS = 0x1
	// MPU operates as normal
	SYSC_LPOPT_MPUDIS_0 = 0x0
	// MPU operate clock stops (MPU function disable).
	SYSC_LPOPT_MPUDIS_1 = 0x1
	// Position of DCLKDIS field.
	SYSC_LPOPT_DCLKDIS_Pos = 0x1
	// Bit mask of DCLKDIS field.
	SYSC_LPOPT_DCLKDIS_Msk = 0x6
	// Debug clock does not stop
	SYSC_LPOPT_DCLKDIS_00 = 0x0
	// Position of BPFCLKDIS field.
	SYSC_LPOPT_BPFCLKDIS_Pos = 0x3
	// Bit mask of BPFCLKDIS field.
	SYSC_LPOPT_BPFCLKDIS_Msk = 0x8
	// Bit BPFCLKDIS.
	SYSC_LPOPT_BPFCLKDIS = 0x8
	// Flash register R/W clock operates as normal
	SYSC_LPOPT_BPFCLKDIS_0 = 0x0
	// Flash register R/W clock stops.
	SYSC_LPOPT_BPFCLKDIS_1 = 0x1
	// Position of LPOPTEN field.
	SYSC_LPOPT_LPOPTEN_Pos = 0x7
	// Bit mask of LPOPTEN field.
	SYSC_LPOPT_LPOPTEN_Msk = 0x80
	// Bit LPOPTEN.
	SYSC_LPOPT_LPOPTEN = 0x80
	// All lower power counter measure disable
	SYSC_LPOPT_LPOPTEN_0 = 0x0
	// All lower power counter measure enable
	SYSC_LPOPT_LPOPTEN_1 = 0x1

	// MOCOUTCR: MOCO User Trimming Control Register
	// Position of MOCOUTRM field.
	SYSC_MOCOUTCR_MOCOUTRM_Pos = 0x0
	// Bit mask of MOCOUTRM field.
	SYSC_MOCOUTCR_MOCOUTRM_Msk = 0xff

	// HOCOUTCR: HOCO User Trimming Control Register
	// Position of HOCOUTRM field.
	SYSC_HOCOUTCR_HOCOUTRM_Pos = 0x0
	// Bit mask of HOCOUTRM field.
	SYSC_HOCOUTCR_HOCOUTRM_Msk = 0xff

	// SNZCR: Snooze Control Register
	// Position of RXDREQEN field.
	SYSC_SNZCR_RXDREQEN_Pos = 0x0
	// Bit mask of RXDREQEN field.
	SYSC_SNZCR_RXDREQEN_Msk = 0x1
	// Bit RXDREQEN.
	SYSC_SNZCR_RXDREQEN = 0x1
	// Ignore RXD0 falling edge in Software Standby mode
	SYSC_SNZCR_RXDREQEN_0 = 0x0
	// Detect RXD0 falling edge in Software Standby mode
	SYSC_SNZCR_RXDREQEN_1 = 0x1
	// Position of SNZDTCEN field.
	SYSC_SNZCR_SNZDTCEN_Pos = 0x1
	// Bit mask of SNZDTCEN field.
	SYSC_SNZCR_SNZDTCEN_Msk = 0x2
	// Bit SNZDTCEN.
	SYSC_SNZCR_SNZDTCEN = 0x2
	// Disable DTC operation
	SYSC_SNZCR_SNZDTCEN_0 = 0x0
	// Enable DTC operation
	SYSC_SNZCR_SNZDTCEN_1 = 0x1
	// Position of SNZE field.
	SYSC_SNZCR_SNZE_Pos = 0x7
	// Bit mask of SNZE field.
	SYSC_SNZCR_SNZE_Msk = 0x80
	// Bit SNZE.
	SYSC_SNZCR_SNZE = 0x80
	// Disable Snooze mode
	SYSC_SNZCR_SNZE_0 = 0x0
	// Enable Snooze mode
	SYSC_SNZCR_SNZE_1 = 0x1

	// SNZEDCR0: Snooze End Control Register 0
	// Position of AGTUNFED field.
	SYSC_SNZEDCR0_AGTUNFED_Pos = 0x0
	// Bit mask of AGTUNFED field.
	SYSC_SNZEDCR0_AGTUNFED_Msk = 0x1
	// Bit AGTUNFED.
	SYSC_SNZEDCR0_AGTUNFED = 0x1
	// Disable the snooze end request
	SYSC_SNZEDCR0_AGTUNFED_0 = 0x0
	// Enable the snooze end request
	SYSC_SNZEDCR0_AGTUNFED_1 = 0x1
	// Position of DTCZRED field.
	SYSC_SNZEDCR0_DTCZRED_Pos = 0x1
	// Bit mask of DTCZRED field.
	SYSC_SNZEDCR0_DTCZRED_Msk = 0x2
	// Bit DTCZRED.
	SYSC_SNZEDCR0_DTCZRED = 0x2
	// Disable the snooze end request
	SYSC_SNZEDCR0_DTCZRED_0 = 0x0
	// Enable the snooze end request
	SYSC_SNZEDCR0_DTCZRED_1 = 0x1
	// Position of DTCNZRED field.
	SYSC_SNZEDCR0_DTCNZRED_Pos = 0x2
	// Bit mask of DTCNZRED field.
	SYSC_SNZEDCR0_DTCNZRED_Msk = 0x4
	// Bit DTCNZRED.
	SYSC_SNZEDCR0_DTCNZRED = 0x4
	// Disable the snooze end request
	SYSC_SNZEDCR0_DTCNZRED_0 = 0x0
	// Enable the snooze end request
	SYSC_SNZEDCR0_DTCNZRED_1 = 0x1
	// Position of AD0MATED field.
	SYSC_SNZEDCR0_AD0MATED_Pos = 0x3
	// Bit mask of AD0MATED field.
	SYSC_SNZEDCR0_AD0MATED_Msk = 0x8
	// Bit AD0MATED.
	SYSC_SNZEDCR0_AD0MATED = 0x8
	// Disable the snooze end request
	SYSC_SNZEDCR0_AD0MATED_0 = 0x0
	// Enable the snooze end request
	SYSC_SNZEDCR0_AD0MATED_1 = 0x1
	// Position of AD0UMTED field.
	SYSC_SNZEDCR0_AD0UMTED_Pos = 0x4
	// Bit mask of AD0UMTED field.
	SYSC_SNZEDCR0_AD0UMTED_Msk = 0x10
	// Bit AD0UMTED.
	SYSC_SNZEDCR0_AD0UMTED = 0x10
	// Disable the snooze end request
	SYSC_SNZEDCR0_AD0UMTED_0 = 0x0
	// Enable the snooze end request
	SYSC_SNZEDCR0_AD0UMTED_1 = 0x1
	// Position of SCI0UMTED field.
	SYSC_SNZEDCR0_SCI0UMTED_Pos = 0x7
	// Bit mask of SCI0UMTED field.
	SYSC_SNZEDCR0_SCI0UMTED_Msk = 0x80
	// Bit SCI0UMTED.
	SYSC_SNZEDCR0_SCI0UMTED = 0x80
	// Disable the snooze end request
	SYSC_SNZEDCR0_SCI0UMTED_0 = 0x0
	// Enable the snooze end request
	SYSC_SNZEDCR0_SCI0UMTED_1 = 0x1

	// SNZREQCR0: Snooze Request Control Register 0
	// Position of SNZREQEN0 field.
	SYSC_SNZREQCR0_SNZREQEN0_Pos = 0x0
	// Bit mask of SNZREQEN0 field.
	SYSC_SNZREQCR0_SNZREQEN0_Msk = 0x1
	// Bit SNZREQEN0.
	SYSC_SNZREQCR0_SNZREQEN0 = 0x1
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN0_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN0_1 = 0x1
	// Position of SNZREQEN1 field.
	SYSC_SNZREQCR0_SNZREQEN1_Pos = 0x1
	// Bit mask of SNZREQEN1 field.
	SYSC_SNZREQCR0_SNZREQEN1_Msk = 0x2
	// Bit SNZREQEN1.
	SYSC_SNZREQCR0_SNZREQEN1 = 0x2
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN1_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN1_1 = 0x1
	// Position of SNZREQEN2 field.
	SYSC_SNZREQCR0_SNZREQEN2_Pos = 0x2
	// Bit mask of SNZREQEN2 field.
	SYSC_SNZREQCR0_SNZREQEN2_Msk = 0x4
	// Bit SNZREQEN2.
	SYSC_SNZREQCR0_SNZREQEN2 = 0x4
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN2_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN2_1 = 0x1
	// Position of SNZREQEN3 field.
	SYSC_SNZREQCR0_SNZREQEN3_Pos = 0x3
	// Bit mask of SNZREQEN3 field.
	SYSC_SNZREQCR0_SNZREQEN3_Msk = 0x8
	// Bit SNZREQEN3.
	SYSC_SNZREQCR0_SNZREQEN3 = 0x8
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN3_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN3_1 = 0x1
	// Position of SNZREQEN4 field.
	SYSC_SNZREQCR0_SNZREQEN4_Pos = 0x4
	// Bit mask of SNZREQEN4 field.
	SYSC_SNZREQCR0_SNZREQEN4_Msk = 0x10
	// Bit SNZREQEN4.
	SYSC_SNZREQCR0_SNZREQEN4 = 0x10
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN4_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN4_1 = 0x1
	// Position of SNZREQEN5 field.
	SYSC_SNZREQCR0_SNZREQEN5_Pos = 0x5
	// Bit mask of SNZREQEN5 field.
	SYSC_SNZREQCR0_SNZREQEN5_Msk = 0x20
	// Bit SNZREQEN5.
	SYSC_SNZREQCR0_SNZREQEN5 = 0x20
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN5_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN5_1 = 0x1
	// Position of SNZREQEN6 field.
	SYSC_SNZREQCR0_SNZREQEN6_Pos = 0x6
	// Bit mask of SNZREQEN6 field.
	SYSC_SNZREQCR0_SNZREQEN6_Msk = 0x40
	// Bit SNZREQEN6.
	SYSC_SNZREQCR0_SNZREQEN6 = 0x40
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN6_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN6_1 = 0x1
	// Position of SNZREQEN7 field.
	SYSC_SNZREQCR0_SNZREQEN7_Pos = 0x7
	// Bit mask of SNZREQEN7 field.
	SYSC_SNZREQCR0_SNZREQEN7_Msk = 0x80
	// Bit SNZREQEN7.
	SYSC_SNZREQCR0_SNZREQEN7 = 0x80
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN7_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN7_1 = 0x1
	// Position of SNZREQEN17 field.
	SYSC_SNZREQCR0_SNZREQEN17_Pos = 0x11
	// Bit mask of SNZREQEN17 field.
	SYSC_SNZREQCR0_SNZREQEN17_Msk = 0x20000
	// Bit SNZREQEN17.
	SYSC_SNZREQCR0_SNZREQEN17 = 0x20000
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN17_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN17_1 = 0x1
	// Position of SNZREQEN23 field.
	SYSC_SNZREQCR0_SNZREQEN23_Pos = 0x17
	// Bit mask of SNZREQEN23 field.
	SYSC_SNZREQCR0_SNZREQEN23_Msk = 0x800000
	// Bit SNZREQEN23.
	SYSC_SNZREQCR0_SNZREQEN23 = 0x800000
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN23_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN23_1 = 0x1
	// Position of SNZREQEN24 field.
	SYSC_SNZREQCR0_SNZREQEN24_Pos = 0x18
	// Bit mask of SNZREQEN24 field.
	SYSC_SNZREQCR0_SNZREQEN24_Msk = 0x1000000
	// Bit SNZREQEN24.
	SYSC_SNZREQCR0_SNZREQEN24 = 0x1000000
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN24_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN24_1 = 0x1
	// Position of SNZREQEN25 field.
	SYSC_SNZREQCR0_SNZREQEN25_Pos = 0x19
	// Bit mask of SNZREQEN25 field.
	SYSC_SNZREQCR0_SNZREQEN25_Msk = 0x2000000
	// Bit SNZREQEN25.
	SYSC_SNZREQCR0_SNZREQEN25 = 0x2000000
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN25_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN25_1 = 0x1
	// Position of SNZREQEN28 field.
	SYSC_SNZREQCR0_SNZREQEN28_Pos = 0x1c
	// Bit mask of SNZREQEN28 field.
	SYSC_SNZREQCR0_SNZREQEN28_Msk = 0x10000000
	// Bit SNZREQEN28.
	SYSC_SNZREQCR0_SNZREQEN28 = 0x10000000
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN28_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN28_1 = 0x1
	// Position of SNZREQEN29 field.
	SYSC_SNZREQCR0_SNZREQEN29_Pos = 0x1d
	// Bit mask of SNZREQEN29 field.
	SYSC_SNZREQCR0_SNZREQEN29_Msk = 0x20000000
	// Bit SNZREQEN29.
	SYSC_SNZREQCR0_SNZREQEN29 = 0x20000000
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN29_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN29_1 = 0x1
	// Position of SNZREQEN30 field.
	SYSC_SNZREQCR0_SNZREQEN30_Pos = 0x1e
	// Bit mask of SNZREQEN30 field.
	SYSC_SNZREQCR0_SNZREQEN30_Msk = 0x40000000
	// Bit SNZREQEN30.
	SYSC_SNZREQCR0_SNZREQEN30 = 0x40000000
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN30_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN30_1 = 0x1

	// PSMCR: Power Save Memory Control Register
	// Position of PSMC field.
	SYSC_PSMCR_PSMC_Pos = 0x0
	// Bit mask of PSMC field.
	SYSC_PSMCR_PSMC_Msk = 0x3
	// All SRAMs are on in Software Standby mode
	SYSC_PSMCR_PSMC_00 = 0x0
	// 8 KB SRAM (0x2000_4000 to 0x2000_5FFF) is on in Software Standby mode
	SYSC_PSMCR_PSMC_01 = 0x1
	// Setting prohibited
	SYSC_PSMCR_PSMC_10 = 0x2
	// Setting prohibited
	SYSC_PSMCR_PSMC_11 = 0x3

	// OPCCR: Operating Power Control Register
	// Position of OPCM field.
	SYSC_OPCCR_OPCM_Pos = 0x0
	// Bit mask of OPCM field.
	SYSC_OPCCR_OPCM_Msk = 0x3
	// High-speed mode
	SYSC_OPCCR_OPCM_00 = 0x0
	// Middle-speed mode
	SYSC_OPCCR_OPCM_01 = 0x1
	// Setting prohibited
	SYSC_OPCCR_OPCM_10 = 0x2
	// Low-speed mode
	SYSC_OPCCR_OPCM_11 = 0x3
	// Position of OPCMTSF field.
	SYSC_OPCCR_OPCMTSF_Pos = 0x4
	// Bit mask of OPCMTSF field.
	SYSC_OPCCR_OPCMTSF_Msk = 0x10
	// Bit OPCMTSF.
	SYSC_OPCCR_OPCMTSF = 0x10
	// Transition completed
	SYSC_OPCCR_OPCMTSF_0 = 0x0
	// During transition
	SYSC_OPCCR_OPCMTSF_1 = 0x1

	// MOSCWTCR: Main Clock Oscillator Wait Control Register
	// Position of MSTS field.
	SYSC_MOSCWTCR_MSTS_Pos = 0x0
	// Bit mask of MSTS field.
	SYSC_MOSCWTCR_MSTS_Msk = 0xf
	// Wait time = 2 cycles (0.25 us)
	SYSC_MOSCWTCR_MSTS_0x0 = 0x0
	// Wait time = 1024 cycles (128 us)
	SYSC_MOSCWTCR_MSTS_0x1 = 0x1
	// Wait time = 2048 cycles (256 us)
	SYSC_MOSCWTCR_MSTS_0x2 = 0x2
	// Wait time = 4096 cycles (512 us)
	SYSC_MOSCWTCR_MSTS_0x3 = 0x3
	// Wait time = 8192 cycles (1024 us)
	SYSC_MOSCWTCR_MSTS_0x4 = 0x4
	// Wait time = 16384 cycles (2048 us)
	SYSC_MOSCWTCR_MSTS_0x5 = 0x5
	// Wait time = 32768 cycles (4096 us)
	SYSC_MOSCWTCR_MSTS_0x6 = 0x6
	// Wait time = 65536 cycles (8192 us)
	SYSC_MOSCWTCR_MSTS_0x7 = 0x7
	// Wait time = 131072 cycles (16384 us)
	SYSC_MOSCWTCR_MSTS_0x8 = 0x8
	// Wait time = 262144 cycles (32768 us)
	SYSC_MOSCWTCR_MSTS_0x9 = 0x9

	// HOCOWTCR: High-Speed On-Chip Oscillator Wait Control Register
	// Position of HSTS field.
	SYSC_HOCOWTCR_HSTS_Pos = 0x0
	// Bit mask of HSTS field.
	SYSC_HOCOWTCR_HSTS_Msk = 0x7
	// Value after reset.
	SYSC_HOCOWTCR_HSTS_101 = 0x5
	// Before starting high-speed on-chip oscillator by setting HOCOCR.HCSTP bit, the HSTS[2:0] bits must be set to 011b beforehand. Wait time = 46 cycles (5.75 µs) Wait time is calculated at MOCO = 8 MHz (typically 0.125 µs).
	SYSC_HOCOWTCR_HSTS_011 = 0x3

	// SOPCCR: Sub Operating Power Control Register
	// Position of SOPCM field.
	SYSC_SOPCCR_SOPCM_Pos = 0x0
	// Bit mask of SOPCM field.
	SYSC_SOPCCR_SOPCM_Msk = 0x1
	// Bit SOPCM.
	SYSC_SOPCCR_SOPCM = 0x1
	// Other than Subosc-speed mode
	SYSC_SOPCCR_SOPCM_0 = 0x0
	// Subosc-speed mode
	SYSC_SOPCCR_SOPCM_1 = 0x1
	// Position of SOPCMTSF field.
	SYSC_SOPCCR_SOPCMTSF_Pos = 0x4
	// Bit mask of SOPCMTSF field.
	SYSC_SOPCCR_SOPCMTSF_Msk = 0x10
	// Bit SOPCMTSF.
	SYSC_SOPCCR_SOPCMTSF = 0x10
	// Transition completed
	SYSC_SOPCCR_SOPCMTSF_0 = 0x0
	// During transition
	SYSC_SOPCCR_SOPCMTSF_1 = 0x1

	// RSTSR1: Reset Status Register 1
	// Position of IWDTRF field.
	SYSC_RSTSR1_IWDTRF_Pos = 0x0
	// Bit mask of IWDTRF field.
	SYSC_RSTSR1_IWDTRF_Msk = 0x1
	// Bit IWDTRF.
	SYSC_RSTSR1_IWDTRF = 0x1
	// Independent watchdog timer reset not detected
	SYSC_RSTSR1_IWDTRF_0 = 0x0
	// Independent watchdog timer reset detected
	SYSC_RSTSR1_IWDTRF_1 = 0x1
	// Position of WDTRF field.
	SYSC_RSTSR1_WDTRF_Pos = 0x1
	// Bit mask of WDTRF field.
	SYSC_RSTSR1_WDTRF_Msk = 0x2
	// Bit WDTRF.
	SYSC_RSTSR1_WDTRF = 0x2
	// Watchdog timer reset not detected
	SYSC_RSTSR1_WDTRF_0 = 0x0
	// Watchdog timer reset detected
	SYSC_RSTSR1_WDTRF_1 = 0x1
	// Position of SWRF field.
	SYSC_RSTSR1_SWRF_Pos = 0x2
	// Bit mask of SWRF field.
	SYSC_RSTSR1_SWRF_Msk = 0x4
	// Bit SWRF.
	SYSC_RSTSR1_SWRF = 0x4
	// Software reset not detected
	SYSC_RSTSR1_SWRF_0 = 0x0
	// Software reset detected
	SYSC_RSTSR1_SWRF_1 = 0x1
	// Position of RPERF field.
	SYSC_RSTSR1_RPERF_Pos = 0x8
	// Bit mask of RPERF field.
	SYSC_RSTSR1_RPERF_Msk = 0x100
	// Bit RPERF.
	SYSC_RSTSR1_RPERF = 0x100
	// SRAM parity error reset not detected
	SYSC_RSTSR1_RPERF_0 = 0x0
	// SRAM parity error reset detected
	SYSC_RSTSR1_RPERF_1 = 0x1
	// Position of BUSSRF field.
	SYSC_RSTSR1_BUSSRF_Pos = 0xa
	// Bit mask of BUSSRF field.
	SYSC_RSTSR1_BUSSRF_Msk = 0x400
	// Bit BUSSRF.
	SYSC_RSTSR1_BUSSRF = 0x400
	// Bus slave MPU error reset not detected
	SYSC_RSTSR1_BUSSRF_0 = 0x0
	// Bus slave MPU error reset detected
	SYSC_RSTSR1_BUSSRF_1 = 0x1
	// Position of BUSMRF field.
	SYSC_RSTSR1_BUSMRF_Pos = 0xb
	// Bit mask of BUSMRF field.
	SYSC_RSTSR1_BUSMRF_Msk = 0x800
	// Bit BUSMRF.
	SYSC_RSTSR1_BUSMRF = 0x800
	// Bus master MPU error reset not detected
	SYSC_RSTSR1_BUSMRF_0 = 0x0
	// Bus master MPU error reset detected
	SYSC_RSTSR1_BUSMRF_1 = 0x1
	// Position of SPERF field.
	SYSC_RSTSR1_SPERF_Pos = 0xc
	// Bit mask of SPERF field.
	SYSC_RSTSR1_SPERF_Msk = 0x1000
	// Bit SPERF.
	SYSC_RSTSR1_SPERF = 0x1000
	// CPU stack pointer error reset not detected
	SYSC_RSTSR1_SPERF_0 = 0x0
	// CPU stack pointer error reset detected
	SYSC_RSTSR1_SPERF_1 = 0x1

	// LVD1CR1: Voltage Monitor 1 Circuit Control Register
	// Position of IDTSEL field.
	SYSC_LVD1CR1_IDTSEL_Pos = 0x0
	// Bit mask of IDTSEL field.
	SYSC_LVD1CR1_IDTSEL_Msk = 0x3
	// When VCC >= Vdet1 (rise) is detected
	SYSC_LVD1CR1_IDTSEL_00 = 0x0
	// When VCC < Vdet1 (fall) is detected
	SYSC_LVD1CR1_IDTSEL_01 = 0x1
	// When fall and rise are detected
	SYSC_LVD1CR1_IDTSEL_10 = 0x2
	// Settings prohibited
	SYSC_LVD1CR1_IDTSEL_11 = 0x3
	// Position of IRQSEL field.
	SYSC_LVD1CR1_IRQSEL_Pos = 0x2
	// Bit mask of IRQSEL field.
	SYSC_LVD1CR1_IRQSEL_Msk = 0x4
	// Bit IRQSEL.
	SYSC_LVD1CR1_IRQSEL = 0x4
	// Non-maskable interrupt
	SYSC_LVD1CR1_IRQSEL_0 = 0x0
	// Maskable interrupt
	SYSC_LVD1CR1_IRQSEL_1 = 0x1

	// LVD1SR: Voltage Monitor 1 Circuit Status Register
	// Position of DET field.
	SYSC_LVD1SR_DET_Pos = 0x0
	// Bit mask of DET field.
	SYSC_LVD1SR_DET_Msk = 0x1
	// Bit DET.
	SYSC_LVD1SR_DET = 0x1
	// Not detected
	SYSC_LVD1SR_DET_0 = 0x0
	// Vdet1 crossing is detected
	SYSC_LVD1SR_DET_1 = 0x1
	// Position of MON field.
	SYSC_LVD1SR_MON_Pos = 0x1
	// Bit mask of MON field.
	SYSC_LVD1SR_MON_Msk = 0x2
	// Bit MON.
	SYSC_LVD1SR_MON = 0x2
	// VCC < Vdet1
	SYSC_LVD1SR_MON_0 = 0x0
	// VCC >= Vdet1 or MON is disabled
	SYSC_LVD1SR_MON_1 = 0x1

	// LVD2CR1: Voltage Monitor 2 Circuit Control Register 1
	// Position of IDTSEL field.
	SYSC_LVD2CR1_IDTSEL_Pos = 0x0
	// Bit mask of IDTSEL field.
	SYSC_LVD2CR1_IDTSEL_Msk = 0x3
	// When VCC>= Vdet2 (rise) is detected
	SYSC_LVD2CR1_IDTSEL_00 = 0x0
	// When VCC < Vdet2 (fall) is detected
	SYSC_LVD2CR1_IDTSEL_01 = 0x1
	// When fall and rise are detected
	SYSC_LVD2CR1_IDTSEL_10 = 0x2
	// Settings prohibited
	SYSC_LVD2CR1_IDTSEL_11 = 0x3
	// Position of IRQSEL field.
	SYSC_LVD2CR1_IRQSEL_Pos = 0x2
	// Bit mask of IRQSEL field.
	SYSC_LVD2CR1_IRQSEL_Msk = 0x4
	// Bit IRQSEL.
	SYSC_LVD2CR1_IRQSEL = 0x4
	// Non-maskable interrupt
	SYSC_LVD2CR1_IRQSEL_0 = 0x0
	// Maskable interrupt
	SYSC_LVD2CR1_IRQSEL_1 = 0x1

	// LVD2SR: Voltage Monitor 2 Circuit Status Register
	// Position of DET field.
	SYSC_LVD2SR_DET_Pos = 0x0
	// Bit mask of DET field.
	SYSC_LVD2SR_DET_Msk = 0x1
	// Bit DET.
	SYSC_LVD2SR_DET = 0x1
	// Not detected
	SYSC_LVD2SR_DET_0 = 0x0
	// Vdet2 crossing is detected
	SYSC_LVD2SR_DET_1 = 0x1
	// Position of MON field.
	SYSC_LVD2SR_MON_Pos = 0x1
	// Bit mask of MON field.
	SYSC_LVD2SR_MON_Msk = 0x2
	// Bit MON.
	SYSC_LVD2SR_MON = 0x2
	// VCC < Vdet2
	SYSC_LVD2SR_MON_0 = 0x0
	// VCC>= Vdet2 or MON is disabled
	SYSC_LVD2SR_MON_1 = 0x1

	// PRCR: Protect Register
	// Position of PRC0 field.
	SYSC_PRCR_PRC0_Pos = 0x0
	// Bit mask of PRC0 field.
	SYSC_PRCR_PRC0_Msk = 0x1
	// Bit PRC0.
	SYSC_PRCR_PRC0 = 0x1
	// Disable writes
	SYSC_PRCR_PRC0_0 = 0x0
	// Enable writes
	SYSC_PRCR_PRC0_1 = 0x1
	// Position of PRC1 field.
	SYSC_PRCR_PRC1_Pos = 0x1
	// Bit mask of PRC1 field.
	SYSC_PRCR_PRC1_Msk = 0x2
	// Bit PRC1.
	SYSC_PRCR_PRC1 = 0x2
	// Disable writes
	SYSC_PRCR_PRC1_0 = 0x0
	// Enable writes
	SYSC_PRCR_PRC1_1 = 0x1
	// Position of PRC3 field.
	SYSC_PRCR_PRC3_Pos = 0x3
	// Bit mask of PRC3 field.
	SYSC_PRCR_PRC3_Msk = 0x8
	// Bit PRC3.
	SYSC_PRCR_PRC3 = 0x8
	// Disable writes
	SYSC_PRCR_PRC3_0 = 0x0
	// Enable writes
	SYSC_PRCR_PRC3_1 = 0x1
	// Position of PRKEY field.
	SYSC_PRCR_PRKEY_Pos = 0x8
	// Bit mask of PRKEY field.
	SYSC_PRCR_PRKEY_Msk = 0xff00

	// SYOCDCR: System Control OCD Control Register
	// Position of DBGEN field.
	SYSC_SYOCDCR_DBGEN_Pos = 0x7
	// Bit mask of DBGEN field.
	SYSC_SYOCDCR_DBGEN_Msk = 0x80
	// Bit DBGEN.
	SYSC_SYOCDCR_DBGEN = 0x80
	// On-chip debugger is disabled
	SYSC_SYOCDCR_DBGEN_0 = 0x0
	// On-chip debugger is enabled
	SYSC_SYOCDCR_DBGEN_1 = 0x1

	// RSTSR0: Reset Status Register 0
	// Position of PORF field.
	SYSC_RSTSR0_PORF_Pos = 0x0
	// Bit mask of PORF field.
	SYSC_RSTSR0_PORF_Msk = 0x1
	// Bit PORF.
	SYSC_RSTSR0_PORF = 0x1
	// Power-on reset not detected
	SYSC_RSTSR0_PORF_0 = 0x0
	// Power-on reset detected
	SYSC_RSTSR0_PORF_1 = 0x1
	// Position of LVD0RF field.
	SYSC_RSTSR0_LVD0RF_Pos = 0x1
	// Bit mask of LVD0RF field.
	SYSC_RSTSR0_LVD0RF_Msk = 0x2
	// Bit LVD0RF.
	SYSC_RSTSR0_LVD0RF = 0x2
	// Voltage monitor 0 reset not detected
	SYSC_RSTSR0_LVD0RF_0 = 0x0
	// Voltage monitor 0 reset detected
	SYSC_RSTSR0_LVD0RF_1 = 0x1
	// Position of LVD1RF field.
	SYSC_RSTSR0_LVD1RF_Pos = 0x2
	// Bit mask of LVD1RF field.
	SYSC_RSTSR0_LVD1RF_Msk = 0x4
	// Bit LVD1RF.
	SYSC_RSTSR0_LVD1RF = 0x4
	// Voltage monitor 1 reset not detected
	SYSC_RSTSR0_LVD1RF_0 = 0x0
	// Voltage monitor 1 reset detected
	SYSC_RSTSR0_LVD1RF_1 = 0x1
	// Position of LVD2RF field.
	SYSC_RSTSR0_LVD2RF_Pos = 0x3
	// Bit mask of LVD2RF field.
	SYSC_RSTSR0_LVD2RF_Msk = 0x8
	// Bit LVD2RF.
	SYSC_RSTSR0_LVD2RF = 0x8
	// Voltage monitor 2 reset not detected
	SYSC_RSTSR0_LVD2RF_0 = 0x0
	// Voltage monitor 2 reset detected
	SYSC_RSTSR0_LVD2RF_1 = 0x1

	// RSTSR2: Reset Status Register 2
	// Position of CWSF field.
	SYSC_RSTSR2_CWSF_Pos = 0x0
	// Bit mask of CWSF field.
	SYSC_RSTSR2_CWSF_Msk = 0x1
	// Bit CWSF.
	SYSC_RSTSR2_CWSF = 0x1
	// Cold start
	SYSC_RSTSR2_CWSF_0 = 0x0
	// Warm start
	SYSC_RSTSR2_CWSF_1 = 0x1

	// MOMCR: Main Clock Oscillator Mode Oscillation Control Register
	// Position of MODRV1 field.
	SYSC_MOMCR_MODRV1_Pos = 0x3
	// Bit mask of MODRV1 field.
	SYSC_MOMCR_MODRV1_Msk = 0x8
	// Bit MODRV1.
	SYSC_MOMCR_MODRV1 = 0x8
	// 10 MHz to 20 MHz
	SYSC_MOMCR_MODRV1_0 = 0x0
	// 1 MHz to 10 MHz
	SYSC_MOMCR_MODRV1_1 = 0x1
	// Position of MOSEL field.
	SYSC_MOMCR_MOSEL_Pos = 0x6
	// Bit mask of MOSEL field.
	SYSC_MOMCR_MOSEL_Msk = 0x40
	// Bit MOSEL.
	SYSC_MOMCR_MOSEL = 0x40
	// Resonator
	SYSC_MOMCR_MOSEL_0 = 0x0
	// External clock input
	SYSC_MOMCR_MOSEL_1 = 0x1

	// LVCMPCR: Voltage Monitor Circuit Control Register
	// Position of LVD1E field.
	SYSC_LVCMPCR_LVD1E_Pos = 0x5
	// Bit mask of LVD1E field.
	SYSC_LVCMPCR_LVD1E_Msk = 0x20
	// Bit LVD1E.
	SYSC_LVCMPCR_LVD1E = 0x20
	// Voltage detection 1 circuit disabled
	SYSC_LVCMPCR_LVD1E_0 = 0x0
	// Voltage detection 1 circuit enabled
	SYSC_LVCMPCR_LVD1E_1 = 0x1
	// Position of LVD2E field.
	SYSC_LVCMPCR_LVD2E_Pos = 0x6
	// Bit mask of LVD2E field.
	SYSC_LVCMPCR_LVD2E_Msk = 0x40
	// Bit LVD2E.
	SYSC_LVCMPCR_LVD2E = 0x40
	// Voltage detection 2 circuit disabled
	SYSC_LVCMPCR_LVD2E_0 = 0x0
	// Voltage detection 2 circuit enabled
	SYSC_LVCMPCR_LVD2E_1 = 0x1

	// LVDLVLR: Voltage Detection Level Select Register
	// Position of LVD1LVL field.
	SYSC_LVDLVLR_LVD1LVL_Pos = 0x0
	// Bit mask of LVD1LVL field.
	SYSC_LVDLVLR_LVD1LVL_Msk = 0x1f
	// Vdet1_0
	SYSC_LVDLVLR_LVD1LVL_0x00 = 0x0
	// Vdet1_1
	SYSC_LVDLVLR_LVD1LVL_0x01 = 0x1
	// Vdet1_2
	SYSC_LVDLVLR_LVD1LVL_0x02 = 0x2
	// Vdet1_3
	SYSC_LVDLVLR_LVD1LVL_0x03 = 0x3
	// Vdet1_4
	SYSC_LVDLVLR_LVD1LVL_0x04 = 0x4
	// Vdet1_5
	SYSC_LVDLVLR_LVD1LVL_0x05 = 0x5
	// Vdet1_6
	SYSC_LVDLVLR_LVD1LVL_0x06 = 0x6
	// Vdet1_7
	SYSC_LVDLVLR_LVD1LVL_0x07 = 0x7
	// Vdet1_8
	SYSC_LVDLVLR_LVD1LVL_0x08 = 0x8
	// Vdet1_9
	SYSC_LVDLVLR_LVD1LVL_0x09 = 0x9
	// Vdet1_A
	SYSC_LVDLVLR_LVD1LVL_0x0A = 0xa
	// Vdet1_B
	SYSC_LVDLVLR_LVD1LVL_0x0B = 0xb
	// Vdet1_C
	SYSC_LVDLVLR_LVD1LVL_0x0C = 0xc
	// Vdet1_D
	SYSC_LVDLVLR_LVD1LVL_0x0D = 0xd
	// Vdet1_E
	SYSC_LVDLVLR_LVD1LVL_0x0E = 0xe
	// Vdet1_F
	SYSC_LVDLVLR_LVD1LVL_0x0F = 0xf
	// Position of LVD2LVL field.
	SYSC_LVDLVLR_LVD2LVL_Pos = 0x5
	// Bit mask of LVD2LVL field.
	SYSC_LVDLVLR_LVD2LVL_Msk = 0xe0
	// Vdet2_0
	SYSC_LVDLVLR_LVD2LVL_000 = 0x0
	// Vdet2_1
	SYSC_LVDLVLR_LVD2LVL_001 = 0x1
	// Vdet2_2
	SYSC_LVDLVLR_LVD2LVL_010 = 0x2
	// Vdet2_3
	SYSC_LVDLVLR_LVD2LVL_011 = 0x3

	// LVD1CR0: Voltage Monitor 1 Circuit Control Register 0
	// Position of RIE field.
	SYSC_LVD1CR0_RIE_Pos = 0x0
	// Bit mask of RIE field.
	SYSC_LVD1CR0_RIE_Msk = 0x1
	// Bit RIE.
	SYSC_LVD1CR0_RIE = 0x1
	// Disable
	SYSC_LVD1CR0_RIE_0 = 0x0
	// Enable
	SYSC_LVD1CR0_RIE_1 = 0x1
	// Position of CMPE field.
	SYSC_LVD1CR0_CMPE_Pos = 0x2
	// Bit mask of CMPE field.
	SYSC_LVD1CR0_CMPE_Msk = 0x4
	// Bit CMPE.
	SYSC_LVD1CR0_CMPE = 0x4
	// Disable voltage monitor 1 circuit comparison result output
	SYSC_LVD1CR0_CMPE_0 = 0x0
	// Enable voltage monitor 1 circuit comparison result output
	SYSC_LVD1CR0_CMPE_1 = 0x1
	// Position of RI field.
	SYSC_LVD1CR0_RI_Pos = 0x6
	// Bit mask of RI field.
	SYSC_LVD1CR0_RI_Msk = 0x40
	// Bit RI.
	SYSC_LVD1CR0_RI = 0x40
	// Generate voltage monitor 1 interrupt on Vdet1 crossing
	SYSC_LVD1CR0_RI_0 = 0x0
	// Enable voltage monitor 1 reset when the voltage falls to and below Vdet1
	SYSC_LVD1CR0_RI_1 = 0x1
	// Position of RN field.
	SYSC_LVD1CR0_RN_Pos = 0x7
	// Bit mask of RN field.
	SYSC_LVD1CR0_RN_Msk = 0x80
	// Bit RN.
	SYSC_LVD1CR0_RN = 0x80
	// Negate after a stabilization time (tLVD1) when VCC > Vdet1 is detected
	SYSC_LVD1CR0_RN_0 = 0x0
	// Negate after a stabilization time (tLVD1) on assertion of the LVD1 reset
	SYSC_LVD1CR0_RN_1 = 0x1

	// LVD2CR0: Voltage Monitor 2 Circuit Control Register 0
	// Position of RIE field.
	SYSC_LVD2CR0_RIE_Pos = 0x0
	// Bit mask of RIE field.
	SYSC_LVD2CR0_RIE_Msk = 0x1
	// Bit RIE.
	SYSC_LVD2CR0_RIE = 0x1
	// Disable
	SYSC_LVD2CR0_RIE_0 = 0x0
	// Enable
	SYSC_LVD2CR0_RIE_1 = 0x1
	// Position of CMPE field.
	SYSC_LVD2CR0_CMPE_Pos = 0x2
	// Bit mask of CMPE field.
	SYSC_LVD2CR0_CMPE_Msk = 0x4
	// Bit CMPE.
	SYSC_LVD2CR0_CMPE = 0x4
	// Disable voltage monitor 2 circuit comparison result output
	SYSC_LVD2CR0_CMPE_0 = 0x0
	// Enable voltage monitor 2 circuit comparison result output
	SYSC_LVD2CR0_CMPE_1 = 0x1
	// Position of RI field.
	SYSC_LVD2CR0_RI_Pos = 0x6
	// Bit mask of RI field.
	SYSC_LVD2CR0_RI_Msk = 0x40
	// Bit RI.
	SYSC_LVD2CR0_RI = 0x40
	// Generate voltage monitor 2 interrupt on Vdet2 crossing
	SYSC_LVD2CR0_RI_0 = 0x0
	// Enable voltage monitor 2 reset when the voltage falls to and below Vdet2
	SYSC_LVD2CR0_RI_1 = 0x1
	// Position of RN field.
	SYSC_LVD2CR0_RN_Pos = 0x7
	// Bit mask of RN field.
	SYSC_LVD2CR0_RN_Msk = 0x80
	// Bit RN.
	SYSC_LVD2CR0_RN = 0x80
	// Negate after a stabilization time (tLVD2) when VCC > Vdet2 is detected
	SYSC_LVD2CR0_RN_0 = 0x0
	// Negate after a stabilization time (tLVD2) on assertion of the LVD2 reset
	SYSC_LVD2CR0_RN_1 = 0x1

	// SOSCCR: Sub-Clock Oscillator Control Register
	// Position of SOSTP field.
	SYSC_SOSCCR_SOSTP_Pos = 0x0
	// Bit mask of SOSTP field.
	SYSC_SOSCCR_SOSTP_Msk = 0x1
	// Bit SOSTP.
	SYSC_SOSCCR_SOSTP = 0x1
	// Operate the sub-clock oscillator
	SYSC_SOSCCR_SOSTP_0 = 0x0
	// Stop the sub-clock oscillator
	SYSC_SOSCCR_SOSTP_1 = 0x1

	// SOMCR: Sub-Clock Oscillator Mode Control Register
	// Position of SODRV field.
	SYSC_SOMCR_SODRV_Pos = 0x0
	// Bit mask of SODRV field.
	SYSC_SOMCR_SODRV_Msk = 0x3
	// Normal Mode
	SYSC_SOMCR_SODRV_00 = 0x0
	// Low Power Mode 1
	SYSC_SOMCR_SODRV_01 = 0x1
	// Low Power Mode 2
	SYSC_SOMCR_SODRV_10 = 0x2
	// Low Power Mode 3
	SYSC_SOMCR_SODRV_11 = 0x3

	// SOMRG: Sub-Clock Oscillator Margin Check Register
	// Position of SOSCMRG field.
	SYSC_SOMRG_SOSCMRG_Pos = 0x0
	// Bit mask of SOSCMRG field.
	SYSC_SOMRG_SOSCMRG_Msk = 0x3
	// Normal Current
	SYSC_SOMRG_SOSCMRG_00 = 0x0
	// Lower Margin check
	SYSC_SOMRG_SOSCMRG_01 = 0x1
	// Upper Margin check
	SYSC_SOMRG_SOSCMRG_10 = 0x2
	// Setting prohibited
	SYSC_SOMRG_SOSCMRG_11 = 0x3

	// LOCOCR: Low-Speed On-Chip Oscillator Control Register
	// Position of LCSTP field.
	SYSC_LOCOCR_LCSTP_Pos = 0x0
	// Bit mask of LCSTP field.
	SYSC_LOCOCR_LCSTP_Msk = 0x1
	// Bit LCSTP.
	SYSC_LOCOCR_LCSTP = 0x1
	// Operate the LOCO clock
	SYSC_LOCOCR_LCSTP_0 = 0x0
	// Stop the LOCO clock
	SYSC_LOCOCR_LCSTP_1 = 0x1

	// LOCOUTCR: LOCO User Trimming Control Register
	// Position of LOCOUTRM field.
	SYSC_LOCOUTCR_LOCOUTRM_Pos = 0x0
	// Bit mask of LOCOUTRM field.
	SYSC_LOCOUTCR_LOCOUTRM_Msk = 0xff
)

// Constants for PORT0: Port 0 Control Registers
const (
	// PCNTR1: Port Control Register 1
	// Position of PDR00 field.
	PORT0_PCNTR1_PDR00_Pos = 0x0
	// Bit mask of PDR00 field.
	PORT0_PCNTR1_PDR00_Msk = 0x1
	// Bit PDR00.
	PORT0_PCNTR1_PDR00 = 0x1
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR00_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR00_1 = 0x1
	// Position of PDR01 field.
	PORT0_PCNTR1_PDR01_Pos = 0x1
	// Bit mask of PDR01 field.
	PORT0_PCNTR1_PDR01_Msk = 0x2
	// Bit PDR01.
	PORT0_PCNTR1_PDR01 = 0x2
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR01_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR01_1 = 0x1
	// Position of PDR02 field.
	PORT0_PCNTR1_PDR02_Pos = 0x2
	// Bit mask of PDR02 field.
	PORT0_PCNTR1_PDR02_Msk = 0x4
	// Bit PDR02.
	PORT0_PCNTR1_PDR02 = 0x4
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR02_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR02_1 = 0x1
	// Position of PDR03 field.
	PORT0_PCNTR1_PDR03_Pos = 0x3
	// Bit mask of PDR03 field.
	PORT0_PCNTR1_PDR03_Msk = 0x8
	// Bit PDR03.
	PORT0_PCNTR1_PDR03 = 0x8
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR03_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR03_1 = 0x1
	// Position of PDR04 field.
	PORT0_PCNTR1_PDR04_Pos = 0x4
	// Bit mask of PDR04 field.
	PORT0_PCNTR1_PDR04_Msk = 0x10
	// Bit PDR04.
	PORT0_PCNTR1_PDR04 = 0x10
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR04_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR04_1 = 0x1
	// Position of PDR05 field.
	PORT0_PCNTR1_PDR05_Pos = 0x5
	// Bit mask of PDR05 field.
	PORT0_PCNTR1_PDR05_Msk = 0x20
	// Bit PDR05.
	PORT0_PCNTR1_PDR05 = 0x20
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR05_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR05_1 = 0x1
	// Position of PDR06 field.
	PORT0_PCNTR1_PDR06_Pos = 0x6
	// Bit mask of PDR06 field.
	PORT0_PCNTR1_PDR06_Msk = 0x40
	// Bit PDR06.
	PORT0_PCNTR1_PDR06 = 0x40
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR06_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR06_1 = 0x1
	// Position of PDR07 field.
	PORT0_PCNTR1_PDR07_Pos = 0x7
	// Bit mask of PDR07 field.
	PORT0_PCNTR1_PDR07_Msk = 0x80
	// Bit PDR07.
	PORT0_PCNTR1_PDR07 = 0x80
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR07_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR07_1 = 0x1
	// Position of PDR08 field.
	PORT0_PCNTR1_PDR08_Pos = 0x8
	// Bit mask of PDR08 field.
	PORT0_PCNTR1_PDR08_Msk = 0x100
	// Bit PDR08.
	PORT0_PCNTR1_PDR08 = 0x100
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR08_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR08_1 = 0x1
	// Position of PDR09 field.
	PORT0_PCNTR1_PDR09_Pos = 0x9
	// Bit mask of PDR09 field.
	PORT0_PCNTR1_PDR09_Msk = 0x200
	// Bit PDR09.
	PORT0_PCNTR1_PDR09 = 0x200
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR09_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR09_1 = 0x1
	// Position of PDR10 field.
	PORT0_PCNTR1_PDR10_Pos = 0xa
	// Bit mask of PDR10 field.
	PORT0_PCNTR1_PDR10_Msk = 0x400
	// Bit PDR10.
	PORT0_PCNTR1_PDR10 = 0x400
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR10_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR10_1 = 0x1
	// Position of PDR11 field.
	PORT0_PCNTR1_PDR11_Pos = 0xb
	// Bit mask of PDR11 field.
	PORT0_PCNTR1_PDR11_Msk = 0x800
	// Bit PDR11.
	PORT0_PCNTR1_PDR11 = 0x800
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR11_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR11_1 = 0x1
	// Position of PDR12 field.
	PORT0_PCNTR1_PDR12_Pos = 0xc
	// Bit mask of PDR12 field.
	PORT0_PCNTR1_PDR12_Msk = 0x1000
	// Bit PDR12.
	PORT0_PCNTR1_PDR12 = 0x1000
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR12_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR12_1 = 0x1
	// Position of PDR13 field.
	PORT0_PCNTR1_PDR13_Pos = 0xd
	// Bit mask of PDR13 field.
	PORT0_PCNTR1_PDR13_Msk = 0x2000
	// Bit PDR13.
	PORT0_PCNTR1_PDR13 = 0x2000
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR13_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR13_1 = 0x1
	// Position of PDR14 field.
	PORT0_PCNTR1_PDR14_Pos = 0xe
	// Bit mask of PDR14 field.
	PORT0_PCNTR1_PDR14_Msk = 0x4000
	// Bit PDR14.
	PORT0_PCNTR1_PDR14 = 0x4000
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR14_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR14_1 = 0x1
	// Position of PDR15 field.
	PORT0_PCNTR1_PDR15_Pos = 0xf
	// Bit mask of PDR15 field.
	PORT0_PCNTR1_PDR15_Msk = 0x8000
	// Bit PDR15.
	PORT0_PCNTR1_PDR15 = 0x8000
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR15_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR15_1 = 0x1
	// Position of PODR00 field.
	PORT0_PCNTR1_PODR00_Pos = 0x10
	// Bit mask of PODR00 field.
	PORT0_PCNTR1_PODR00_Msk = 0x10000
	// Bit PODR00.
	PORT0_PCNTR1_PODR00 = 0x10000
	// Low output
	PORT0_PCNTR1_PODR00_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR00_1 = 0x1
	// Position of PODR01 field.
	PORT0_PCNTR1_PODR01_Pos = 0x11
	// Bit mask of PODR01 field.
	PORT0_PCNTR1_PODR01_Msk = 0x20000
	// Bit PODR01.
	PORT0_PCNTR1_PODR01 = 0x20000
	// Low output
	PORT0_PCNTR1_PODR01_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR01_1 = 0x1
	// Position of PODR02 field.
	PORT0_PCNTR1_PODR02_Pos = 0x12
	// Bit mask of PODR02 field.
	PORT0_PCNTR1_PODR02_Msk = 0x40000
	// Bit PODR02.
	PORT0_PCNTR1_PODR02 = 0x40000
	// Low output
	PORT0_PCNTR1_PODR02_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR02_1 = 0x1
	// Position of PODR03 field.
	PORT0_PCNTR1_PODR03_Pos = 0x13
	// Bit mask of PODR03 field.
	PORT0_PCNTR1_PODR03_Msk = 0x80000
	// Bit PODR03.
	PORT0_PCNTR1_PODR03 = 0x80000
	// Low output
	PORT0_PCNTR1_PODR03_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR03_1 = 0x1
	// Position of PODR04 field.
	PORT0_PCNTR1_PODR04_Pos = 0x14
	// Bit mask of PODR04 field.
	PORT0_PCNTR1_PODR04_Msk = 0x100000
	// Bit PODR04.
	PORT0_PCNTR1_PODR04 = 0x100000
	// Low output
	PORT0_PCNTR1_PODR04_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR04_1 = 0x1
	// Position of PODR05 field.
	PORT0_PCNTR1_PODR05_Pos = 0x15
	// Bit mask of PODR05 field.
	PORT0_PCNTR1_PODR05_Msk = 0x200000
	// Bit PODR05.
	PORT0_PCNTR1_PODR05 = 0x200000
	// Low output
	PORT0_PCNTR1_PODR05_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR05_1 = 0x1
	// Position of PODR06 field.
	PORT0_PCNTR1_PODR06_Pos = 0x16
	// Bit mask of PODR06 field.
	PORT0_PCNTR1_PODR06_Msk = 0x400000
	// Bit PODR06.
	PORT0_PCNTR1_PODR06 = 0x400000
	// Low output
	PORT0_PCNTR1_PODR06_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR06_1 = 0x1
	// Position of PODR07 field.
	PORT0_PCNTR1_PODR07_Pos = 0x17
	// Bit mask of PODR07 field.
	PORT0_PCNTR1_PODR07_Msk = 0x800000
	// Bit PODR07.
	PORT0_PCNTR1_PODR07 = 0x800000
	// Low output
	PORT0_PCNTR1_PODR07_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR07_1 = 0x1
	// Position of PODR08 field.
	PORT0_PCNTR1_PODR08_Pos = 0x18
	// Bit mask of PODR08 field.
	PORT0_PCNTR1_PODR08_Msk = 0x1000000
	// Bit PODR08.
	PORT0_PCNTR1_PODR08 = 0x1000000
	// Low output
	PORT0_PCNTR1_PODR08_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR08_1 = 0x1
	// Position of PODR09 field.
	PORT0_PCNTR1_PODR09_Pos = 0x19
	// Bit mask of PODR09 field.
	PORT0_PCNTR1_PODR09_Msk = 0x2000000
	// Bit PODR09.
	PORT0_PCNTR1_PODR09 = 0x2000000
	// Low output
	PORT0_PCNTR1_PODR09_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR09_1 = 0x1
	// Position of PODR10 field.
	PORT0_PCNTR1_PODR10_Pos = 0x1a
	// Bit mask of PODR10 field.
	PORT0_PCNTR1_PODR10_Msk = 0x4000000
	// Bit PODR10.
	PORT0_PCNTR1_PODR10 = 0x4000000
	// Low output
	PORT0_PCNTR1_PODR10_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR10_1 = 0x1
	// Position of PODR11 field.
	PORT0_PCNTR1_PODR11_Pos = 0x1b
	// Bit mask of PODR11 field.
	PORT0_PCNTR1_PODR11_Msk = 0x8000000
	// Bit PODR11.
	PORT0_PCNTR1_PODR11 = 0x8000000
	// Low output
	PORT0_PCNTR1_PODR11_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR11_1 = 0x1
	// Position of PODR12 field.
	PORT0_PCNTR1_PODR12_Pos = 0x1c
	// Bit mask of PODR12 field.
	PORT0_PCNTR1_PODR12_Msk = 0x10000000
	// Bit PODR12.
	PORT0_PCNTR1_PODR12 = 0x10000000
	// Low output
	PORT0_PCNTR1_PODR12_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR12_1 = 0x1
	// Position of PODR13 field.
	PORT0_PCNTR1_PODR13_Pos = 0x1d
	// Bit mask of PODR13 field.
	PORT0_PCNTR1_PODR13_Msk = 0x20000000
	// Bit PODR13.
	PORT0_PCNTR1_PODR13 = 0x20000000
	// Low output
	PORT0_PCNTR1_PODR13_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR13_1 = 0x1
	// Position of PODR14 field.
	PORT0_PCNTR1_PODR14_Pos = 0x1e
	// Bit mask of PODR14 field.
	PORT0_PCNTR1_PODR14_Msk = 0x40000000
	// Bit PODR14.
	PORT0_PCNTR1_PODR14 = 0x40000000
	// Low output
	PORT0_PCNTR1_PODR14_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR14_1 = 0x1
	// Position of PODR15 field.
	PORT0_PCNTR1_PODR15_Pos = 0x1f
	// Bit mask of PODR15 field.
	PORT0_PCNTR1_PODR15_Msk = 0x80000000
	// Bit PODR15.
	PORT0_PCNTR1_PODR15 = 0x80000000
	// Low output
	PORT0_PCNTR1_PODR15_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR15_1 = 0x1

	// PODR: Port Control Register 1
	// Position of PODR00 field.
	PORT0_PODR_PODR00_Pos = 0x0
	// Bit mask of PODR00 field.
	PORT0_PODR_PODR00_Msk = 0x1
	// Bit PODR00.
	PORT0_PODR_PODR00 = 0x1
	// Low output
	PORT0_PODR_PODR00_0 = 0x0
	// High output
	PORT0_PODR_PODR00_1 = 0x1
	// Position of PODR01 field.
	PORT0_PODR_PODR01_Pos = 0x1
	// Bit mask of PODR01 field.
	PORT0_PODR_PODR01_Msk = 0x2
	// Bit PODR01.
	PORT0_PODR_PODR01 = 0x2
	// Low output
	PORT0_PODR_PODR01_0 = 0x0
	// High output
	PORT0_PODR_PODR01_1 = 0x1
	// Position of PODR02 field.
	PORT0_PODR_PODR02_Pos = 0x2
	// Bit mask of PODR02 field.
	PORT0_PODR_PODR02_Msk = 0x4
	// Bit PODR02.
	PORT0_PODR_PODR02 = 0x4
	// Low output
	PORT0_PODR_PODR02_0 = 0x0
	// High output
	PORT0_PODR_PODR02_1 = 0x1
	// Position of PODR03 field.
	PORT0_PODR_PODR03_Pos = 0x3
	// Bit mask of PODR03 field.
	PORT0_PODR_PODR03_Msk = 0x8
	// Bit PODR03.
	PORT0_PODR_PODR03 = 0x8
	// Low output
	PORT0_PODR_PODR03_0 = 0x0
	// High output
	PORT0_PODR_PODR03_1 = 0x1
	// Position of PODR04 field.
	PORT0_PODR_PODR04_Pos = 0x4
	// Bit mask of PODR04 field.
	PORT0_PODR_PODR04_Msk = 0x10
	// Bit PODR04.
	PORT0_PODR_PODR04 = 0x10
	// Low output
	PORT0_PODR_PODR04_0 = 0x0
	// High output
	PORT0_PODR_PODR04_1 = 0x1
	// Position of PODR05 field.
	PORT0_PODR_PODR05_Pos = 0x5
	// Bit mask of PODR05 field.
	PORT0_PODR_PODR05_Msk = 0x20
	// Bit PODR05.
	PORT0_PODR_PODR05 = 0x20
	// Low output
	PORT0_PODR_PODR05_0 = 0x0
	// High output
	PORT0_PODR_PODR05_1 = 0x1
	// Position of PODR06 field.
	PORT0_PODR_PODR06_Pos = 0x6
	// Bit mask of PODR06 field.
	PORT0_PODR_PODR06_Msk = 0x40
	// Bit PODR06.
	PORT0_PODR_PODR06 = 0x40
	// Low output
	PORT0_PODR_PODR06_0 = 0x0
	// High output
	PORT0_PODR_PODR06_1 = 0x1
	// Position of PODR07 field.
	PORT0_PODR_PODR07_Pos = 0x7
	// Bit mask of PODR07 field.
	PORT0_PODR_PODR07_Msk = 0x80
	// Bit PODR07.
	PORT0_PODR_PODR07 = 0x80
	// Low output
	PORT0_PODR_PODR07_0 = 0x0
	// High output
	PORT0_PODR_PODR07_1 = 0x1
	// Position of PODR08 field.
	PORT0_PODR_PODR08_Pos = 0x8
	// Bit mask of PODR08 field.
	PORT0_PODR_PODR08_Msk = 0x100
	// Bit PODR08.
	PORT0_PODR_PODR08 = 0x100
	// Low output
	PORT0_PODR_PODR08_0 = 0x0
	// High output
	PORT0_PODR_PODR08_1 = 0x1
	// Position of PODR09 field.
	PORT0_PODR_PODR09_Pos = 0x9
	// Bit mask of PODR09 field.
	PORT0_PODR_PODR09_Msk = 0x200
	// Bit PODR09.
	PORT0_PODR_PODR09 = 0x200
	// Low output
	PORT0_PODR_PODR09_0 = 0x0
	// High output
	PORT0_PODR_PODR09_1 = 0x1
	// Position of PODR10 field.
	PORT0_PODR_PODR10_Pos = 0xa
	// Bit mask of PODR10 field.
	PORT0_PODR_PODR10_Msk = 0x400
	// Bit PODR10.
	PORT0_PODR_PODR10 = 0x400
	// Low output
	PORT0_PODR_PODR10_0 = 0x0
	// High output
	PORT0_PODR_PODR10_1 = 0x1
	// Position of PODR11 field.
	PORT0_PODR_PODR11_Pos = 0xb
	// Bit mask of PODR11 field.
	PORT0_PODR_PODR11_Msk = 0x800
	// Bit PODR11.
	PORT0_PODR_PODR11 = 0x800
	// Low output
	PORT0_PODR_PODR11_0 = 0x0
	// High output
	PORT0_PODR_PODR11_1 = 0x1
	// Position of PODR12 field.
	PORT0_PODR_PODR12_Pos = 0xc
	// Bit mask of PODR12 field.
	PORT0_PODR_PODR12_Msk = 0x1000
	// Bit PODR12.
	PORT0_PODR_PODR12 = 0x1000
	// Low output
	PORT0_PODR_PODR12_0 = 0x0
	// High output
	PORT0_PODR_PODR12_1 = 0x1
	// Position of PODR13 field.
	PORT0_PODR_PODR13_Pos = 0xd
	// Bit mask of PODR13 field.
	PORT0_PODR_PODR13_Msk = 0x2000
	// Bit PODR13.
	PORT0_PODR_PODR13 = 0x2000
	// Low output
	PORT0_PODR_PODR13_0 = 0x0
	// High output
	PORT0_PODR_PODR13_1 = 0x1
	// Position of PODR14 field.
	PORT0_PODR_PODR14_Pos = 0xe
	// Bit mask of PODR14 field.
	PORT0_PODR_PODR14_Msk = 0x4000
	// Bit PODR14.
	PORT0_PODR_PODR14 = 0x4000
	// Low output
	PORT0_PODR_PODR14_0 = 0x0
	// High output
	PORT0_PODR_PODR14_1 = 0x1
	// Position of PODR15 field.
	PORT0_PODR_PODR15_Pos = 0xf
	// Bit mask of PODR15 field.
	PORT0_PODR_PODR15_Msk = 0x8000
	// Bit PODR15.
	PORT0_PODR_PODR15 = 0x8000
	// Low output
	PORT0_PODR_PODR15_0 = 0x0
	// High output
	PORT0_PODR_PODR15_1 = 0x1

	// PDR: Port Control Register 1
	// Position of PDR00 field.
	PORT0_PDR_PDR00_Pos = 0x0
	// Bit mask of PDR00 field.
	PORT0_PDR_PDR00_Msk = 0x1
	// Bit PDR00.
	PORT0_PDR_PDR00 = 0x1
	// Input (functions as an input pin)
	PORT0_PDR_PDR00_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR00_1 = 0x1
	// Position of PDR01 field.
	PORT0_PDR_PDR01_Pos = 0x1
	// Bit mask of PDR01 field.
	PORT0_PDR_PDR01_Msk = 0x2
	// Bit PDR01.
	PORT0_PDR_PDR01 = 0x2
	// Input (functions as an input pin)
	PORT0_PDR_PDR01_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR01_1 = 0x1
	// Position of PDR02 field.
	PORT0_PDR_PDR02_Pos = 0x2
	// Bit mask of PDR02 field.
	PORT0_PDR_PDR02_Msk = 0x4
	// Bit PDR02.
	PORT0_PDR_PDR02 = 0x4
	// Input (functions as an input pin)
	PORT0_PDR_PDR02_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR02_1 = 0x1
	// Position of PDR03 field.
	PORT0_PDR_PDR03_Pos = 0x3
	// Bit mask of PDR03 field.
	PORT0_PDR_PDR03_Msk = 0x8
	// Bit PDR03.
	PORT0_PDR_PDR03 = 0x8
	// Input (functions as an input pin)
	PORT0_PDR_PDR03_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR03_1 = 0x1
	// Position of PDR04 field.
	PORT0_PDR_PDR04_Pos = 0x4
	// Bit mask of PDR04 field.
	PORT0_PDR_PDR04_Msk = 0x10
	// Bit PDR04.
	PORT0_PDR_PDR04 = 0x10
	// Input (functions as an input pin)
	PORT0_PDR_PDR04_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR04_1 = 0x1
	// Position of PDR05 field.
	PORT0_PDR_PDR05_Pos = 0x5
	// Bit mask of PDR05 field.
	PORT0_PDR_PDR05_Msk = 0x20
	// Bit PDR05.
	PORT0_PDR_PDR05 = 0x20
	// Input (functions as an input pin)
	PORT0_PDR_PDR05_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR05_1 = 0x1
	// Position of PDR06 field.
	PORT0_PDR_PDR06_Pos = 0x6
	// Bit mask of PDR06 field.
	PORT0_PDR_PDR06_Msk = 0x40
	// Bit PDR06.
	PORT0_PDR_PDR06 = 0x40
	// Input (functions as an input pin)
	PORT0_PDR_PDR06_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR06_1 = 0x1
	// Position of PDR07 field.
	PORT0_PDR_PDR07_Pos = 0x7
	// Bit mask of PDR07 field.
	PORT0_PDR_PDR07_Msk = 0x80
	// Bit PDR07.
	PORT0_PDR_PDR07 = 0x80
	// Input (functions as an input pin)
	PORT0_PDR_PDR07_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR07_1 = 0x1
	// Position of PDR08 field.
	PORT0_PDR_PDR08_Pos = 0x8
	// Bit mask of PDR08 field.
	PORT0_PDR_PDR08_Msk = 0x100
	// Bit PDR08.
	PORT0_PDR_PDR08 = 0x100
	// Input (functions as an input pin)
	PORT0_PDR_PDR08_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR08_1 = 0x1
	// Position of PDR09 field.
	PORT0_PDR_PDR09_Pos = 0x9
	// Bit mask of PDR09 field.
	PORT0_PDR_PDR09_Msk = 0x200
	// Bit PDR09.
	PORT0_PDR_PDR09 = 0x200
	// Input (functions as an input pin)
	PORT0_PDR_PDR09_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR09_1 = 0x1
	// Position of PDR10 field.
	PORT0_PDR_PDR10_Pos = 0xa
	// Bit mask of PDR10 field.
	PORT0_PDR_PDR10_Msk = 0x400
	// Bit PDR10.
	PORT0_PDR_PDR10 = 0x400
	// Input (functions as an input pin)
	PORT0_PDR_PDR10_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR10_1 = 0x1
	// Position of PDR11 field.
	PORT0_PDR_PDR11_Pos = 0xb
	// Bit mask of PDR11 field.
	PORT0_PDR_PDR11_Msk = 0x800
	// Bit PDR11.
	PORT0_PDR_PDR11 = 0x800
	// Input (functions as an input pin)
	PORT0_PDR_PDR11_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR11_1 = 0x1
	// Position of PDR12 field.
	PORT0_PDR_PDR12_Pos = 0xc
	// Bit mask of PDR12 field.
	PORT0_PDR_PDR12_Msk = 0x1000
	// Bit PDR12.
	PORT0_PDR_PDR12 = 0x1000
	// Input (functions as an input pin)
	PORT0_PDR_PDR12_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR12_1 = 0x1
	// Position of PDR13 field.
	PORT0_PDR_PDR13_Pos = 0xd
	// Bit mask of PDR13 field.
	PORT0_PDR_PDR13_Msk = 0x2000
	// Bit PDR13.
	PORT0_PDR_PDR13 = 0x2000
	// Input (functions as an input pin)
	PORT0_PDR_PDR13_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR13_1 = 0x1
	// Position of PDR14 field.
	PORT0_PDR_PDR14_Pos = 0xe
	// Bit mask of PDR14 field.
	PORT0_PDR_PDR14_Msk = 0x4000
	// Bit PDR14.
	PORT0_PDR_PDR14 = 0x4000
	// Input (functions as an input pin)
	PORT0_PDR_PDR14_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR14_1 = 0x1
	// Position of PDR15 field.
	PORT0_PDR_PDR15_Pos = 0xf
	// Bit mask of PDR15 field.
	PORT0_PDR_PDR15_Msk = 0x8000
	// Bit PDR15.
	PORT0_PDR_PDR15 = 0x8000
	// Input (functions as an input pin)
	PORT0_PDR_PDR15_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR15_1 = 0x1

	// PCNTR2: Port Control Register 2
	// Position of PIDR00 field.
	PORT0_PCNTR2_PIDR00_Pos = 0x0
	// Bit mask of PIDR00 field.
	PORT0_PCNTR2_PIDR00_Msk = 0x1
	// Bit PIDR00.
	PORT0_PCNTR2_PIDR00 = 0x1
	// Low level
	PORT0_PCNTR2_PIDR00_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR00_1 = 0x1
	// Position of PIDR01 field.
	PORT0_PCNTR2_PIDR01_Pos = 0x1
	// Bit mask of PIDR01 field.
	PORT0_PCNTR2_PIDR01_Msk = 0x2
	// Bit PIDR01.
	PORT0_PCNTR2_PIDR01 = 0x2
	// Low level
	PORT0_PCNTR2_PIDR01_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR01_1 = 0x1
	// Position of PIDR02 field.
	PORT0_PCNTR2_PIDR02_Pos = 0x2
	// Bit mask of PIDR02 field.
	PORT0_PCNTR2_PIDR02_Msk = 0x4
	// Bit PIDR02.
	PORT0_PCNTR2_PIDR02 = 0x4
	// Low level
	PORT0_PCNTR2_PIDR02_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR02_1 = 0x1
	// Position of PIDR03 field.
	PORT0_PCNTR2_PIDR03_Pos = 0x3
	// Bit mask of PIDR03 field.
	PORT0_PCNTR2_PIDR03_Msk = 0x8
	// Bit PIDR03.
	PORT0_PCNTR2_PIDR03 = 0x8
	// Low level
	PORT0_PCNTR2_PIDR03_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR03_1 = 0x1
	// Position of PIDR04 field.
	PORT0_PCNTR2_PIDR04_Pos = 0x4
	// Bit mask of PIDR04 field.
	PORT0_PCNTR2_PIDR04_Msk = 0x10
	// Bit PIDR04.
	PORT0_PCNTR2_PIDR04 = 0x10
	// Low level
	PORT0_PCNTR2_PIDR04_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR04_1 = 0x1
	// Position of PIDR05 field.
	PORT0_PCNTR2_PIDR05_Pos = 0x5
	// Bit mask of PIDR05 field.
	PORT0_PCNTR2_PIDR05_Msk = 0x20
	// Bit PIDR05.
	PORT0_PCNTR2_PIDR05 = 0x20
	// Low level
	PORT0_PCNTR2_PIDR05_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR05_1 = 0x1
	// Position of PIDR06 field.
	PORT0_PCNTR2_PIDR06_Pos = 0x6
	// Bit mask of PIDR06 field.
	PORT0_PCNTR2_PIDR06_Msk = 0x40
	// Bit PIDR06.
	PORT0_PCNTR2_PIDR06 = 0x40
	// Low level
	PORT0_PCNTR2_PIDR06_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR06_1 = 0x1
	// Position of PIDR07 field.
	PORT0_PCNTR2_PIDR07_Pos = 0x7
	// Bit mask of PIDR07 field.
	PORT0_PCNTR2_PIDR07_Msk = 0x80
	// Bit PIDR07.
	PORT0_PCNTR2_PIDR07 = 0x80
	// Low level
	PORT0_PCNTR2_PIDR07_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR07_1 = 0x1
	// Position of PIDR08 field.
	PORT0_PCNTR2_PIDR08_Pos = 0x8
	// Bit mask of PIDR08 field.
	PORT0_PCNTR2_PIDR08_Msk = 0x100
	// Bit PIDR08.
	PORT0_PCNTR2_PIDR08 = 0x100
	// Low level
	PORT0_PCNTR2_PIDR08_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR08_1 = 0x1
	// Position of PIDR09 field.
	PORT0_PCNTR2_PIDR09_Pos = 0x9
	// Bit mask of PIDR09 field.
	PORT0_PCNTR2_PIDR09_Msk = 0x200
	// Bit PIDR09.
	PORT0_PCNTR2_PIDR09 = 0x200
	// Low level
	PORT0_PCNTR2_PIDR09_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR09_1 = 0x1
	// Position of PIDR10 field.
	PORT0_PCNTR2_PIDR10_Pos = 0xa
	// Bit mask of PIDR10 field.
	PORT0_PCNTR2_PIDR10_Msk = 0x400
	// Bit PIDR10.
	PORT0_PCNTR2_PIDR10 = 0x400
	// Low level
	PORT0_PCNTR2_PIDR10_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR10_1 = 0x1
	// Position of PIDR11 field.
	PORT0_PCNTR2_PIDR11_Pos = 0xb
	// Bit mask of PIDR11 field.
	PORT0_PCNTR2_PIDR11_Msk = 0x800
	// Bit PIDR11.
	PORT0_PCNTR2_PIDR11 = 0x800
	// Low level
	PORT0_PCNTR2_PIDR11_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR11_1 = 0x1
	// Position of PIDR12 field.
	PORT0_PCNTR2_PIDR12_Pos = 0xc
	// Bit mask of PIDR12 field.
	PORT0_PCNTR2_PIDR12_Msk = 0x1000
	// Bit PIDR12.
	PORT0_PCNTR2_PIDR12 = 0x1000
	// Low level
	PORT0_PCNTR2_PIDR12_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR12_1 = 0x1
	// Position of PIDR13 field.
	PORT0_PCNTR2_PIDR13_Pos = 0xd
	// Bit mask of PIDR13 field.
	PORT0_PCNTR2_PIDR13_Msk = 0x2000
	// Bit PIDR13.
	PORT0_PCNTR2_PIDR13 = 0x2000
	// Low level
	PORT0_PCNTR2_PIDR13_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR13_1 = 0x1
	// Position of PIDR14 field.
	PORT0_PCNTR2_PIDR14_Pos = 0xe
	// Bit mask of PIDR14 field.
	PORT0_PCNTR2_PIDR14_Msk = 0x4000
	// Bit PIDR14.
	PORT0_PCNTR2_PIDR14 = 0x4000
	// Low level
	PORT0_PCNTR2_PIDR14_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR14_1 = 0x1
	// Position of PIDR15 field.
	PORT0_PCNTR2_PIDR15_Pos = 0xf
	// Bit mask of PIDR15 field.
	PORT0_PCNTR2_PIDR15_Msk = 0x8000
	// Bit PIDR15.
	PORT0_PCNTR2_PIDR15 = 0x8000
	// Low level
	PORT0_PCNTR2_PIDR15_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR15_1 = 0x1

	// PIDR: Port Control Register 2
	// Position of PIDR00 field.
	PORT0_PIDR_PIDR00_Pos = 0x0
	// Bit mask of PIDR00 field.
	PORT0_PIDR_PIDR00_Msk = 0x1
	// Bit PIDR00.
	PORT0_PIDR_PIDR00 = 0x1
	// Low level
	PORT0_PIDR_PIDR00_0 = 0x0
	// High level
	PORT0_PIDR_PIDR00_1 = 0x1
	// Position of PIDR01 field.
	PORT0_PIDR_PIDR01_Pos = 0x1
	// Bit mask of PIDR01 field.
	PORT0_PIDR_PIDR01_Msk = 0x2
	// Bit PIDR01.
	PORT0_PIDR_PIDR01 = 0x2
	// Low level
	PORT0_PIDR_PIDR01_0 = 0x0
	// High level
	PORT0_PIDR_PIDR01_1 = 0x1
	// Position of PIDR02 field.
	PORT0_PIDR_PIDR02_Pos = 0x2
	// Bit mask of PIDR02 field.
	PORT0_PIDR_PIDR02_Msk = 0x4
	// Bit PIDR02.
	PORT0_PIDR_PIDR02 = 0x4
	// Low level
	PORT0_PIDR_PIDR02_0 = 0x0
	// High level
	PORT0_PIDR_PIDR02_1 = 0x1
	// Position of PIDR03 field.
	PORT0_PIDR_PIDR03_Pos = 0x3
	// Bit mask of PIDR03 field.
	PORT0_PIDR_PIDR03_Msk = 0x8
	// Bit PIDR03.
	PORT0_PIDR_PIDR03 = 0x8
	// Low level
	PORT0_PIDR_PIDR03_0 = 0x0
	// High level
	PORT0_PIDR_PIDR03_1 = 0x1
	// Position of PIDR04 field.
	PORT0_PIDR_PIDR04_Pos = 0x4
	// Bit mask of PIDR04 field.
	PORT0_PIDR_PIDR04_Msk = 0x10
	// Bit PIDR04.
	PORT0_PIDR_PIDR04 = 0x10
	// Low level
	PORT0_PIDR_PIDR04_0 = 0x0
	// High level
	PORT0_PIDR_PIDR04_1 = 0x1
	// Position of PIDR05 field.
	PORT0_PIDR_PIDR05_Pos = 0x5
	// Bit mask of PIDR05 field.
	PORT0_PIDR_PIDR05_Msk = 0x20
	// Bit PIDR05.
	PORT0_PIDR_PIDR05 = 0x20
	// Low level
	PORT0_PIDR_PIDR05_0 = 0x0
	// High level
	PORT0_PIDR_PIDR05_1 = 0x1
	// Position of PIDR06 field.
	PORT0_PIDR_PIDR06_Pos = 0x6
	// Bit mask of PIDR06 field.
	PORT0_PIDR_PIDR06_Msk = 0x40
	// Bit PIDR06.
	PORT0_PIDR_PIDR06 = 0x40
	// Low level
	PORT0_PIDR_PIDR06_0 = 0x0
	// High level
	PORT0_PIDR_PIDR06_1 = 0x1
	// Position of PIDR07 field.
	PORT0_PIDR_PIDR07_Pos = 0x7
	// Bit mask of PIDR07 field.
	PORT0_PIDR_PIDR07_Msk = 0x80
	// Bit PIDR07.
	PORT0_PIDR_PIDR07 = 0x80
	// Low level
	PORT0_PIDR_PIDR07_0 = 0x0
	// High level
	PORT0_PIDR_PIDR07_1 = 0x1
	// Position of PIDR08 field.
	PORT0_PIDR_PIDR08_Pos = 0x8
	// Bit mask of PIDR08 field.
	PORT0_PIDR_PIDR08_Msk = 0x100
	// Bit PIDR08.
	PORT0_PIDR_PIDR08 = 0x100
	// Low level
	PORT0_PIDR_PIDR08_0 = 0x0
	// High level
	PORT0_PIDR_PIDR08_1 = 0x1
	// Position of PIDR09 field.
	PORT0_PIDR_PIDR09_Pos = 0x9
	// Bit mask of PIDR09 field.
	PORT0_PIDR_PIDR09_Msk = 0x200
	// Bit PIDR09.
	PORT0_PIDR_PIDR09 = 0x200
	// Low level
	PORT0_PIDR_PIDR09_0 = 0x0
	// High level
	PORT0_PIDR_PIDR09_1 = 0x1
	// Position of PIDR10 field.
	PORT0_PIDR_PIDR10_Pos = 0xa
	// Bit mask of PIDR10 field.
	PORT0_PIDR_PIDR10_Msk = 0x400
	// Bit PIDR10.
	PORT0_PIDR_PIDR10 = 0x400
	// Low level
	PORT0_PIDR_PIDR10_0 = 0x0
	// High level
	PORT0_PIDR_PIDR10_1 = 0x1
	// Position of PIDR11 field.
	PORT0_PIDR_PIDR11_Pos = 0xb
	// Bit mask of PIDR11 field.
	PORT0_PIDR_PIDR11_Msk = 0x800
	// Bit PIDR11.
	PORT0_PIDR_PIDR11 = 0x800
	// Low level
	PORT0_PIDR_PIDR11_0 = 0x0
	// High level
	PORT0_PIDR_PIDR11_1 = 0x1
	// Position of PIDR12 field.
	PORT0_PIDR_PIDR12_Pos = 0xc
	// Bit mask of PIDR12 field.
	PORT0_PIDR_PIDR12_Msk = 0x1000
	// Bit PIDR12.
	PORT0_PIDR_PIDR12 = 0x1000
	// Low level
	PORT0_PIDR_PIDR12_0 = 0x0
	// High level
	PORT0_PIDR_PIDR12_1 = 0x1
	// Position of PIDR13 field.
	PORT0_PIDR_PIDR13_Pos = 0xd
	// Bit mask of PIDR13 field.
	PORT0_PIDR_PIDR13_Msk = 0x2000
	// Bit PIDR13.
	PORT0_PIDR_PIDR13 = 0x2000
	// Low level
	PORT0_PIDR_PIDR13_0 = 0x0
	// High level
	PORT0_PIDR_PIDR13_1 = 0x1
	// Position of PIDR14 field.
	PORT0_PIDR_PIDR14_Pos = 0xe
	// Bit mask of PIDR14 field.
	PORT0_PIDR_PIDR14_Msk = 0x4000
	// Bit PIDR14.
	PORT0_PIDR_PIDR14 = 0x4000
	// Low level
	PORT0_PIDR_PIDR14_0 = 0x0
	// High level
	PORT0_PIDR_PIDR14_1 = 0x1
	// Position of PIDR15 field.
	PORT0_PIDR_PIDR15_Pos = 0xf
	// Bit mask of PIDR15 field.
	PORT0_PIDR_PIDR15_Msk = 0x8000
	// Bit PIDR15.
	PORT0_PIDR_PIDR15 = 0x8000
	// Low level
	PORT0_PIDR_PIDR15_0 = 0x0
	// High level
	PORT0_PIDR_PIDR15_1 = 0x1

	// PCNTR3: Port Control Register 3
	// Position of POSR00 field.
	PORT0_PCNTR3_POSR00_Pos = 0x0
	// Bit mask of POSR00 field.
	PORT0_PCNTR3_POSR00_Msk = 0x1
	// Bit POSR00.
	PORT0_PCNTR3_POSR00 = 0x1
	// No effect on output
	PORT0_PCNTR3_POSR00_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR00_1 = 0x1
	// Position of POSR01 field.
	PORT0_PCNTR3_POSR01_Pos = 0x1
	// Bit mask of POSR01 field.
	PORT0_PCNTR3_POSR01_Msk = 0x2
	// Bit POSR01.
	PORT0_PCNTR3_POSR01 = 0x2
	// No effect on output
	PORT0_PCNTR3_POSR01_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR01_1 = 0x1
	// Position of POSR02 field.
	PORT0_PCNTR3_POSR02_Pos = 0x2
	// Bit mask of POSR02 field.
	PORT0_PCNTR3_POSR02_Msk = 0x4
	// Bit POSR02.
	PORT0_PCNTR3_POSR02 = 0x4
	// No effect on output
	PORT0_PCNTR3_POSR02_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR02_1 = 0x1
	// Position of POSR03 field.
	PORT0_PCNTR3_POSR03_Pos = 0x3
	// Bit mask of POSR03 field.
	PORT0_PCNTR3_POSR03_Msk = 0x8
	// Bit POSR03.
	PORT0_PCNTR3_POSR03 = 0x8
	// No effect on output
	PORT0_PCNTR3_POSR03_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR03_1 = 0x1
	// Position of POSR04 field.
	PORT0_PCNTR3_POSR04_Pos = 0x4
	// Bit mask of POSR04 field.
	PORT0_PCNTR3_POSR04_Msk = 0x10
	// Bit POSR04.
	PORT0_PCNTR3_POSR04 = 0x10
	// No effect on output
	PORT0_PCNTR3_POSR04_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR04_1 = 0x1
	// Position of POSR05 field.
	PORT0_PCNTR3_POSR05_Pos = 0x5
	// Bit mask of POSR05 field.
	PORT0_PCNTR3_POSR05_Msk = 0x20
	// Bit POSR05.
	PORT0_PCNTR3_POSR05 = 0x20
	// No effect on output
	PORT0_PCNTR3_POSR05_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR05_1 = 0x1
	// Position of POSR06 field.
	PORT0_PCNTR3_POSR06_Pos = 0x6
	// Bit mask of POSR06 field.
	PORT0_PCNTR3_POSR06_Msk = 0x40
	// Bit POSR06.
	PORT0_PCNTR3_POSR06 = 0x40
	// No effect on output
	PORT0_PCNTR3_POSR06_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR06_1 = 0x1
	// Position of POSR07 field.
	PORT0_PCNTR3_POSR07_Pos = 0x7
	// Bit mask of POSR07 field.
	PORT0_PCNTR3_POSR07_Msk = 0x80
	// Bit POSR07.
	PORT0_PCNTR3_POSR07 = 0x80
	// No effect on output
	PORT0_PCNTR3_POSR07_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR07_1 = 0x1
	// Position of POSR08 field.
	PORT0_PCNTR3_POSR08_Pos = 0x8
	// Bit mask of POSR08 field.
	PORT0_PCNTR3_POSR08_Msk = 0x100
	// Bit POSR08.
	PORT0_PCNTR3_POSR08 = 0x100
	// No effect on output
	PORT0_PCNTR3_POSR08_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR08_1 = 0x1
	// Position of POSR09 field.
	PORT0_PCNTR3_POSR09_Pos = 0x9
	// Bit mask of POSR09 field.
	PORT0_PCNTR3_POSR09_Msk = 0x200
	// Bit POSR09.
	PORT0_PCNTR3_POSR09 = 0x200
	// No effect on output
	PORT0_PCNTR3_POSR09_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR09_1 = 0x1
	// Position of POSR10 field.
	PORT0_PCNTR3_POSR10_Pos = 0xa
	// Bit mask of POSR10 field.
	PORT0_PCNTR3_POSR10_Msk = 0x400
	// Bit POSR10.
	PORT0_PCNTR3_POSR10 = 0x400
	// No effect on output
	PORT0_PCNTR3_POSR10_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR10_1 = 0x1
	// Position of POSR11 field.
	PORT0_PCNTR3_POSR11_Pos = 0xb
	// Bit mask of POSR11 field.
	PORT0_PCNTR3_POSR11_Msk = 0x800
	// Bit POSR11.
	PORT0_PCNTR3_POSR11 = 0x800
	// No effect on output
	PORT0_PCNTR3_POSR11_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR11_1 = 0x1
	// Position of POSR12 field.
	PORT0_PCNTR3_POSR12_Pos = 0xc
	// Bit mask of POSR12 field.
	PORT0_PCNTR3_POSR12_Msk = 0x1000
	// Bit POSR12.
	PORT0_PCNTR3_POSR12 = 0x1000
	// No effect on output
	PORT0_PCNTR3_POSR12_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR12_1 = 0x1
	// Position of POSR13 field.
	PORT0_PCNTR3_POSR13_Pos = 0xd
	// Bit mask of POSR13 field.
	PORT0_PCNTR3_POSR13_Msk = 0x2000
	// Bit POSR13.
	PORT0_PCNTR3_POSR13 = 0x2000
	// No effect on output
	PORT0_PCNTR3_POSR13_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR13_1 = 0x1
	// Position of POSR14 field.
	PORT0_PCNTR3_POSR14_Pos = 0xe
	// Bit mask of POSR14 field.
	PORT0_PCNTR3_POSR14_Msk = 0x4000
	// Bit POSR14.
	PORT0_PCNTR3_POSR14 = 0x4000
	// No effect on output
	PORT0_PCNTR3_POSR14_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR14_1 = 0x1
	// Position of POSR15 field.
	PORT0_PCNTR3_POSR15_Pos = 0xf
	// Bit mask of POSR15 field.
	PORT0_PCNTR3_POSR15_Msk = 0x8000
	// Bit POSR15.
	PORT0_PCNTR3_POSR15 = 0x8000
	// No effect on output
	PORT0_PCNTR3_POSR15_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR15_1 = 0x1
	// Position of PORR00 field.
	PORT0_PCNTR3_PORR00_Pos = 0x10
	// Bit mask of PORR00 field.
	PORT0_PCNTR3_PORR00_Msk = 0x10000
	// Bit PORR00.
	PORT0_PCNTR3_PORR00 = 0x10000
	// No effect on output
	PORT0_PCNTR3_PORR00_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR00_1 = 0x1
	// Position of PORR01 field.
	PORT0_PCNTR3_PORR01_Pos = 0x11
	// Bit mask of PORR01 field.
	PORT0_PCNTR3_PORR01_Msk = 0x20000
	// Bit PORR01.
	PORT0_PCNTR3_PORR01 = 0x20000
	// No effect on output
	PORT0_PCNTR3_PORR01_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR01_1 = 0x1
	// Position of PORR02 field.
	PORT0_PCNTR3_PORR02_Pos = 0x12
	// Bit mask of PORR02 field.
	PORT0_PCNTR3_PORR02_Msk = 0x40000
	// Bit PORR02.
	PORT0_PCNTR3_PORR02 = 0x40000
	// No effect on output
	PORT0_PCNTR3_PORR02_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR02_1 = 0x1
	// Position of PORR03 field.
	PORT0_PCNTR3_PORR03_Pos = 0x13
	// Bit mask of PORR03 field.
	PORT0_PCNTR3_PORR03_Msk = 0x80000
	// Bit PORR03.
	PORT0_PCNTR3_PORR03 = 0x80000
	// No effect on output
	PORT0_PCNTR3_PORR03_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR03_1 = 0x1
	// Position of PORR04 field.
	PORT0_PCNTR3_PORR04_Pos = 0x14
	// Bit mask of PORR04 field.
	PORT0_PCNTR3_PORR04_Msk = 0x100000
	// Bit PORR04.
	PORT0_PCNTR3_PORR04 = 0x100000
	// No effect on output
	PORT0_PCNTR3_PORR04_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR04_1 = 0x1
	// Position of PORR05 field.
	PORT0_PCNTR3_PORR05_Pos = 0x15
	// Bit mask of PORR05 field.
	PORT0_PCNTR3_PORR05_Msk = 0x200000
	// Bit PORR05.
	PORT0_PCNTR3_PORR05 = 0x200000
	// No effect on output
	PORT0_PCNTR3_PORR05_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR05_1 = 0x1
	// Position of PORR06 field.
	PORT0_PCNTR3_PORR06_Pos = 0x16
	// Bit mask of PORR06 field.
	PORT0_PCNTR3_PORR06_Msk = 0x400000
	// Bit PORR06.
	PORT0_PCNTR3_PORR06 = 0x400000
	// No effect on output
	PORT0_PCNTR3_PORR06_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR06_1 = 0x1
	// Position of PORR07 field.
	PORT0_PCNTR3_PORR07_Pos = 0x17
	// Bit mask of PORR07 field.
	PORT0_PCNTR3_PORR07_Msk = 0x800000
	// Bit PORR07.
	PORT0_PCNTR3_PORR07 = 0x800000
	// No effect on output
	PORT0_PCNTR3_PORR07_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR07_1 = 0x1
	// Position of PORR08 field.
	PORT0_PCNTR3_PORR08_Pos = 0x18
	// Bit mask of PORR08 field.
	PORT0_PCNTR3_PORR08_Msk = 0x1000000
	// Bit PORR08.
	PORT0_PCNTR3_PORR08 = 0x1000000
	// No effect on output
	PORT0_PCNTR3_PORR08_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR08_1 = 0x1
	// Position of PORR09 field.
	PORT0_PCNTR3_PORR09_Pos = 0x19
	// Bit mask of PORR09 field.
	PORT0_PCNTR3_PORR09_Msk = 0x2000000
	// Bit PORR09.
	PORT0_PCNTR3_PORR09 = 0x2000000
	// No effect on output
	PORT0_PCNTR3_PORR09_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR09_1 = 0x1
	// Position of PORR10 field.
	PORT0_PCNTR3_PORR10_Pos = 0x1a
	// Bit mask of PORR10 field.
	PORT0_PCNTR3_PORR10_Msk = 0x4000000
	// Bit PORR10.
	PORT0_PCNTR3_PORR10 = 0x4000000
	// No effect on output
	PORT0_PCNTR3_PORR10_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR10_1 = 0x1
	// Position of PORR11 field.
	PORT0_PCNTR3_PORR11_Pos = 0x1b
	// Bit mask of PORR11 field.
	PORT0_PCNTR3_PORR11_Msk = 0x8000000
	// Bit PORR11.
	PORT0_PCNTR3_PORR11 = 0x8000000
	// No effect on output
	PORT0_PCNTR3_PORR11_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR11_1 = 0x1
	// Position of PORR12 field.
	PORT0_PCNTR3_PORR12_Pos = 0x1c
	// Bit mask of PORR12 field.
	PORT0_PCNTR3_PORR12_Msk = 0x10000000
	// Bit PORR12.
	PORT0_PCNTR3_PORR12 = 0x10000000
	// No effect on output
	PORT0_PCNTR3_PORR12_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR12_1 = 0x1
	// Position of PORR13 field.
	PORT0_PCNTR3_PORR13_Pos = 0x1d
	// Bit mask of PORR13 field.
	PORT0_PCNTR3_PORR13_Msk = 0x20000000
	// Bit PORR13.
	PORT0_PCNTR3_PORR13 = 0x20000000
	// No effect on output
	PORT0_PCNTR3_PORR13_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR13_1 = 0x1
	// Position of PORR14 field.
	PORT0_PCNTR3_PORR14_Pos = 0x1e
	// Bit mask of PORR14 field.
	PORT0_PCNTR3_PORR14_Msk = 0x40000000
	// Bit PORR14.
	PORT0_PCNTR3_PORR14 = 0x40000000
	// No effect on output
	PORT0_PCNTR3_PORR14_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR14_1 = 0x1
	// Position of PORR15 field.
	PORT0_PCNTR3_PORR15_Pos = 0x1f
	// Bit mask of PORR15 field.
	PORT0_PCNTR3_PORR15_Msk = 0x80000000
	// Bit PORR15.
	PORT0_PCNTR3_PORR15 = 0x80000000
	// No effect on output
	PORT0_PCNTR3_PORR15_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR15_1 = 0x1

	// PORR: Port Control Register 3
	// Position of PORR00 field.
	PORT0_PORR_PORR00_Pos = 0x0
	// Bit mask of PORR00 field.
	PORT0_PORR_PORR00_Msk = 0x1
	// Bit PORR00.
	PORT0_PORR_PORR00 = 0x1
	// No effect on output
	PORT0_PORR_PORR00_0 = 0x0
	// Low output
	PORT0_PORR_PORR00_1 = 0x1
	// Position of PORR01 field.
	PORT0_PORR_PORR01_Pos = 0x1
	// Bit mask of PORR01 field.
	PORT0_PORR_PORR01_Msk = 0x2
	// Bit PORR01.
	PORT0_PORR_PORR01 = 0x2
	// No effect on output
	PORT0_PORR_PORR01_0 = 0x0
	// Low output
	PORT0_PORR_PORR01_1 = 0x1
	// Position of PORR02 field.
	PORT0_PORR_PORR02_Pos = 0x2
	// Bit mask of PORR02 field.
	PORT0_PORR_PORR02_Msk = 0x4
	// Bit PORR02.
	PORT0_PORR_PORR02 = 0x4
	// No effect on output
	PORT0_PORR_PORR02_0 = 0x0
	// Low output
	PORT0_PORR_PORR02_1 = 0x1
	// Position of PORR03 field.
	PORT0_PORR_PORR03_Pos = 0x3
	// Bit mask of PORR03 field.
	PORT0_PORR_PORR03_Msk = 0x8
	// Bit PORR03.
	PORT0_PORR_PORR03 = 0x8
	// No effect on output
	PORT0_PORR_PORR03_0 = 0x0
	// Low output
	PORT0_PORR_PORR03_1 = 0x1
	// Position of PORR04 field.
	PORT0_PORR_PORR04_Pos = 0x4
	// Bit mask of PORR04 field.
	PORT0_PORR_PORR04_Msk = 0x10
	// Bit PORR04.
	PORT0_PORR_PORR04 = 0x10
	// No effect on output
	PORT0_PORR_PORR04_0 = 0x0
	// Low output
	PORT0_PORR_PORR04_1 = 0x1
	// Position of PORR05 field.
	PORT0_PORR_PORR05_Pos = 0x5
	// Bit mask of PORR05 field.
	PORT0_PORR_PORR05_Msk = 0x20
	// Bit PORR05.
	PORT0_PORR_PORR05 = 0x20
	// No effect on output
	PORT0_PORR_PORR05_0 = 0x0
	// Low output
	PORT0_PORR_PORR05_1 = 0x1
	// Position of PORR06 field.
	PORT0_PORR_PORR06_Pos = 0x6
	// Bit mask of PORR06 field.
	PORT0_PORR_PORR06_Msk = 0x40
	// Bit PORR06.
	PORT0_PORR_PORR06 = 0x40
	// No effect on output
	PORT0_PORR_PORR06_0 = 0x0
	// Low output
	PORT0_PORR_PORR06_1 = 0x1
	// Position of PORR07 field.
	PORT0_PORR_PORR07_Pos = 0x7
	// Bit mask of PORR07 field.
	PORT0_PORR_PORR07_Msk = 0x80
	// Bit PORR07.
	PORT0_PORR_PORR07 = 0x80
	// No effect on output
	PORT0_PORR_PORR07_0 = 0x0
	// Low output
	PORT0_PORR_PORR07_1 = 0x1
	// Position of PORR08 field.
	PORT0_PORR_PORR08_Pos = 0x8
	// Bit mask of PORR08 field.
	PORT0_PORR_PORR08_Msk = 0x100
	// Bit PORR08.
	PORT0_PORR_PORR08 = 0x100
	// No effect on output
	PORT0_PORR_PORR08_0 = 0x0
	// Low output
	PORT0_PORR_PORR08_1 = 0x1
	// Position of PORR09 field.
	PORT0_PORR_PORR09_Pos = 0x9
	// Bit mask of PORR09 field.
	PORT0_PORR_PORR09_Msk = 0x200
	// Bit PORR09.
	PORT0_PORR_PORR09 = 0x200
	// No effect on output
	PORT0_PORR_PORR09_0 = 0x0
	// Low output
	PORT0_PORR_PORR09_1 = 0x1
	// Position of PORR10 field.
	PORT0_PORR_PORR10_Pos = 0xa
	// Bit mask of PORR10 field.
	PORT0_PORR_PORR10_Msk = 0x400
	// Bit PORR10.
	PORT0_PORR_PORR10 = 0x400
	// No effect on output
	PORT0_PORR_PORR10_0 = 0x0
	// Low output
	PORT0_PORR_PORR10_1 = 0x1
	// Position of PORR11 field.
	PORT0_PORR_PORR11_Pos = 0xb
	// Bit mask of PORR11 field.
	PORT0_PORR_PORR11_Msk = 0x800
	// Bit PORR11.
	PORT0_PORR_PORR11 = 0x800
	// No effect on output
	PORT0_PORR_PORR11_0 = 0x0
	// Low output
	PORT0_PORR_PORR11_1 = 0x1
	// Position of PORR12 field.
	PORT0_PORR_PORR12_Pos = 0xc
	// Bit mask of PORR12 field.
	PORT0_PORR_PORR12_Msk = 0x1000
	// Bit PORR12.
	PORT0_PORR_PORR12 = 0x1000
	// No effect on output
	PORT0_PORR_PORR12_0 = 0x0
	// Low output
	PORT0_PORR_PORR12_1 = 0x1
	// Position of PORR13 field.
	PORT0_PORR_PORR13_Pos = 0xd
	// Bit mask of PORR13 field.
	PORT0_PORR_PORR13_Msk = 0x2000
	// Bit PORR13.
	PORT0_PORR_PORR13 = 0x2000
	// No effect on output
	PORT0_PORR_PORR13_0 = 0x0
	// Low output
	PORT0_PORR_PORR13_1 = 0x1
	// Position of PORR14 field.
	PORT0_PORR_PORR14_Pos = 0xe
	// Bit mask of PORR14 field.
	PORT0_PORR_PORR14_Msk = 0x4000
	// Bit PORR14.
	PORT0_PORR_PORR14 = 0x4000
	// No effect on output
	PORT0_PORR_PORR14_0 = 0x0
	// Low output
	PORT0_PORR_PORR14_1 = 0x1
	// Position of PORR15 field.
	PORT0_PORR_PORR15_Pos = 0xf
	// Bit mask of PORR15 field.
	PORT0_PORR_PORR15_Msk = 0x8000
	// Bit PORR15.
	PORT0_PORR_PORR15 = 0x8000
	// No effect on output
	PORT0_PORR_PORR15_0 = 0x0
	// Low output
	PORT0_PORR_PORR15_1 = 0x1

	// POSR: Port Control Register 3
	// Position of POSR00 field.
	PORT0_POSR_POSR00_Pos = 0x0
	// Bit mask of POSR00 field.
	PORT0_POSR_POSR00_Msk = 0x1
	// Bit POSR00.
	PORT0_POSR_POSR00 = 0x1
	// No effect on output
	PORT0_POSR_POSR00_0 = 0x0
	// High output
	PORT0_POSR_POSR00_1 = 0x1
	// Position of POSR01 field.
	PORT0_POSR_POSR01_Pos = 0x1
	// Bit mask of POSR01 field.
	PORT0_POSR_POSR01_Msk = 0x2
	// Bit POSR01.
	PORT0_POSR_POSR01 = 0x2
	// No effect on output
	PORT0_POSR_POSR01_0 = 0x0
	// High output
	PORT0_POSR_POSR01_1 = 0x1
	// Position of POSR02 field.
	PORT0_POSR_POSR02_Pos = 0x2
	// Bit mask of POSR02 field.
	PORT0_POSR_POSR02_Msk = 0x4
	// Bit POSR02.
	PORT0_POSR_POSR02 = 0x4
	// No effect on output
	PORT0_POSR_POSR02_0 = 0x0
	// High output
	PORT0_POSR_POSR02_1 = 0x1
	// Position of POSR03 field.
	PORT0_POSR_POSR03_Pos = 0x3
	// Bit mask of POSR03 field.
	PORT0_POSR_POSR03_Msk = 0x8
	// Bit POSR03.
	PORT0_POSR_POSR03 = 0x8
	// No effect on output
	PORT0_POSR_POSR03_0 = 0x0
	// High output
	PORT0_POSR_POSR03_1 = 0x1
	// Position of POSR04 field.
	PORT0_POSR_POSR04_Pos = 0x4
	// Bit mask of POSR04 field.
	PORT0_POSR_POSR04_Msk = 0x10
	// Bit POSR04.
	PORT0_POSR_POSR04 = 0x10
	// No effect on output
	PORT0_POSR_POSR04_0 = 0x0
	// High output
	PORT0_POSR_POSR04_1 = 0x1
	// Position of POSR05 field.
	PORT0_POSR_POSR05_Pos = 0x5
	// Bit mask of POSR05 field.
	PORT0_POSR_POSR05_Msk = 0x20
	// Bit POSR05.
	PORT0_POSR_POSR05 = 0x20
	// No effect on output
	PORT0_POSR_POSR05_0 = 0x0
	// High output
	PORT0_POSR_POSR05_1 = 0x1
	// Position of POSR06 field.
	PORT0_POSR_POSR06_Pos = 0x6
	// Bit mask of POSR06 field.
	PORT0_POSR_POSR06_Msk = 0x40
	// Bit POSR06.
	PORT0_POSR_POSR06 = 0x40
	// No effect on output
	PORT0_POSR_POSR06_0 = 0x0
	// High output
	PORT0_POSR_POSR06_1 = 0x1
	// Position of POSR07 field.
	PORT0_POSR_POSR07_Pos = 0x7
	// Bit mask of POSR07 field.
	PORT0_POSR_POSR07_Msk = 0x80
	// Bit POSR07.
	PORT0_POSR_POSR07 = 0x80
	// No effect on output
	PORT0_POSR_POSR07_0 = 0x0
	// High output
	PORT0_POSR_POSR07_1 = 0x1
	// Position of POSR08 field.
	PORT0_POSR_POSR08_Pos = 0x8
	// Bit mask of POSR08 field.
	PORT0_POSR_POSR08_Msk = 0x100
	// Bit POSR08.
	PORT0_POSR_POSR08 = 0x100
	// No effect on output
	PORT0_POSR_POSR08_0 = 0x0
	// High output
	PORT0_POSR_POSR08_1 = 0x1
	// Position of POSR09 field.
	PORT0_POSR_POSR09_Pos = 0x9
	// Bit mask of POSR09 field.
	PORT0_POSR_POSR09_Msk = 0x200
	// Bit POSR09.
	PORT0_POSR_POSR09 = 0x200
	// No effect on output
	PORT0_POSR_POSR09_0 = 0x0
	// High output
	PORT0_POSR_POSR09_1 = 0x1
	// Position of POSR10 field.
	PORT0_POSR_POSR10_Pos = 0xa
	// Bit mask of POSR10 field.
	PORT0_POSR_POSR10_Msk = 0x400
	// Bit POSR10.
	PORT0_POSR_POSR10 = 0x400
	// No effect on output
	PORT0_POSR_POSR10_0 = 0x0
	// High output
	PORT0_POSR_POSR10_1 = 0x1
	// Position of POSR11 field.
	PORT0_POSR_POSR11_Pos = 0xb
	// Bit mask of POSR11 field.
	PORT0_POSR_POSR11_Msk = 0x800
	// Bit POSR11.
	PORT0_POSR_POSR11 = 0x800
	// No effect on output
	PORT0_POSR_POSR11_0 = 0x0
	// High output
	PORT0_POSR_POSR11_1 = 0x1
	// Position of POSR12 field.
	PORT0_POSR_POSR12_Pos = 0xc
	// Bit mask of POSR12 field.
	PORT0_POSR_POSR12_Msk = 0x1000
	// Bit POSR12.
	PORT0_POSR_POSR12 = 0x1000
	// No effect on output
	PORT0_POSR_POSR12_0 = 0x0
	// High output
	PORT0_POSR_POSR12_1 = 0x1
	// Position of POSR13 field.
	PORT0_POSR_POSR13_Pos = 0xd
	// Bit mask of POSR13 field.
	PORT0_POSR_POSR13_Msk = 0x2000
	// Bit POSR13.
	PORT0_POSR_POSR13 = 0x2000
	// No effect on output
	PORT0_POSR_POSR13_0 = 0x0
	// High output
	PORT0_POSR_POSR13_1 = 0x1
	// Position of POSR14 field.
	PORT0_POSR_POSR14_Pos = 0xe
	// Bit mask of POSR14 field.
	PORT0_POSR_POSR14_Msk = 0x4000
	// Bit POSR14.
	PORT0_POSR_POSR14 = 0x4000
	// No effect on output
	PORT0_POSR_POSR14_0 = 0x0
	// High output
	PORT0_POSR_POSR14_1 = 0x1
	// Position of POSR15 field.
	PORT0_POSR_POSR15_Pos = 0xf
	// Bit mask of POSR15 field.
	PORT0_POSR_POSR15_Msk = 0x8000
	// Bit POSR15.
	PORT0_POSR_POSR15 = 0x8000
	// No effect on output
	PORT0_POSR_POSR15_0 = 0x0
	// High output
	PORT0_POSR_POSR15_1 = 0x1
)

// Constants for PORT1: Port 1 Control Registers
const (
	// PCNTR1: Port Control Register 1
	// Position of PDR00 field.
	PORT1_PCNTR1_PDR00_Pos = 0x0
	// Bit mask of PDR00 field.
	PORT1_PCNTR1_PDR00_Msk = 0x1
	// Bit PDR00.
	PORT1_PCNTR1_PDR00 = 0x1
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR00_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR00_1 = 0x1
	// Position of PDR01 field.
	PORT1_PCNTR1_PDR01_Pos = 0x1
	// Bit mask of PDR01 field.
	PORT1_PCNTR1_PDR01_Msk = 0x2
	// Bit PDR01.
	PORT1_PCNTR1_PDR01 = 0x2
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR01_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR01_1 = 0x1
	// Position of PDR02 field.
	PORT1_PCNTR1_PDR02_Pos = 0x2
	// Bit mask of PDR02 field.
	PORT1_PCNTR1_PDR02_Msk = 0x4
	// Bit PDR02.
	PORT1_PCNTR1_PDR02 = 0x4
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR02_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR02_1 = 0x1
	// Position of PDR03 field.
	PORT1_PCNTR1_PDR03_Pos = 0x3
	// Bit mask of PDR03 field.
	PORT1_PCNTR1_PDR03_Msk = 0x8
	// Bit PDR03.
	PORT1_PCNTR1_PDR03 = 0x8
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR03_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR03_1 = 0x1
	// Position of PDR04 field.
	PORT1_PCNTR1_PDR04_Pos = 0x4
	// Bit mask of PDR04 field.
	PORT1_PCNTR1_PDR04_Msk = 0x10
	// Bit PDR04.
	PORT1_PCNTR1_PDR04 = 0x10
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR04_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR04_1 = 0x1
	// Position of PDR05 field.
	PORT1_PCNTR1_PDR05_Pos = 0x5
	// Bit mask of PDR05 field.
	PORT1_PCNTR1_PDR05_Msk = 0x20
	// Bit PDR05.
	PORT1_PCNTR1_PDR05 = 0x20
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR05_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR05_1 = 0x1
	// Position of PDR06 field.
	PORT1_PCNTR1_PDR06_Pos = 0x6
	// Bit mask of PDR06 field.
	PORT1_PCNTR1_PDR06_Msk = 0x40
	// Bit PDR06.
	PORT1_PCNTR1_PDR06 = 0x40
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR06_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR06_1 = 0x1
	// Position of PDR07 field.
	PORT1_PCNTR1_PDR07_Pos = 0x7
	// Bit mask of PDR07 field.
	PORT1_PCNTR1_PDR07_Msk = 0x80
	// Bit PDR07.
	PORT1_PCNTR1_PDR07 = 0x80
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR07_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR07_1 = 0x1
	// Position of PDR08 field.
	PORT1_PCNTR1_PDR08_Pos = 0x8
	// Bit mask of PDR08 field.
	PORT1_PCNTR1_PDR08_Msk = 0x100
	// Bit PDR08.
	PORT1_PCNTR1_PDR08 = 0x100
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR08_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR08_1 = 0x1
	// Position of PDR09 field.
	PORT1_PCNTR1_PDR09_Pos = 0x9
	// Bit mask of PDR09 field.
	PORT1_PCNTR1_PDR09_Msk = 0x200
	// Bit PDR09.
	PORT1_PCNTR1_PDR09 = 0x200
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR09_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR09_1 = 0x1
	// Position of PDR10 field.
	PORT1_PCNTR1_PDR10_Pos = 0xa
	// Bit mask of PDR10 field.
	PORT1_PCNTR1_PDR10_Msk = 0x400
	// Bit PDR10.
	PORT1_PCNTR1_PDR10 = 0x400
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR10_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR10_1 = 0x1
	// Position of PDR11 field.
	PORT1_PCNTR1_PDR11_Pos = 0xb
	// Bit mask of PDR11 field.
	PORT1_PCNTR1_PDR11_Msk = 0x800
	// Bit PDR11.
	PORT1_PCNTR1_PDR11 = 0x800
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR11_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR11_1 = 0x1
	// Position of PDR12 field.
	PORT1_PCNTR1_PDR12_Pos = 0xc
	// Bit mask of PDR12 field.
	PORT1_PCNTR1_PDR12_Msk = 0x1000
	// Bit PDR12.
	PORT1_PCNTR1_PDR12 = 0x1000
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR12_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR12_1 = 0x1
	// Position of PDR13 field.
	PORT1_PCNTR1_PDR13_Pos = 0xd
	// Bit mask of PDR13 field.
	PORT1_PCNTR1_PDR13_Msk = 0x2000
	// Bit PDR13.
	PORT1_PCNTR1_PDR13 = 0x2000
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR13_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR13_1 = 0x1
	// Position of PDR14 field.
	PORT1_PCNTR1_PDR14_Pos = 0xe
	// Bit mask of PDR14 field.
	PORT1_PCNTR1_PDR14_Msk = 0x4000
	// Bit PDR14.
	PORT1_PCNTR1_PDR14 = 0x4000
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR14_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR14_1 = 0x1
	// Position of PDR15 field.
	PORT1_PCNTR1_PDR15_Pos = 0xf
	// Bit mask of PDR15 field.
	PORT1_PCNTR1_PDR15_Msk = 0x8000
	// Bit PDR15.
	PORT1_PCNTR1_PDR15 = 0x8000
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR15_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR15_1 = 0x1
	// Position of PODR00 field.
	PORT1_PCNTR1_PODR00_Pos = 0x10
	// Bit mask of PODR00 field.
	PORT1_PCNTR1_PODR00_Msk = 0x10000
	// Bit PODR00.
	PORT1_PCNTR1_PODR00 = 0x10000
	// Low output
	PORT1_PCNTR1_PODR00_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR00_1 = 0x1
	// Position of PODR01 field.
	PORT1_PCNTR1_PODR01_Pos = 0x11
	// Bit mask of PODR01 field.
	PORT1_PCNTR1_PODR01_Msk = 0x20000
	// Bit PODR01.
	PORT1_PCNTR1_PODR01 = 0x20000
	// Low output
	PORT1_PCNTR1_PODR01_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR01_1 = 0x1
	// Position of PODR02 field.
	PORT1_PCNTR1_PODR02_Pos = 0x12
	// Bit mask of PODR02 field.
	PORT1_PCNTR1_PODR02_Msk = 0x40000
	// Bit PODR02.
	PORT1_PCNTR1_PODR02 = 0x40000
	// Low output
	PORT1_PCNTR1_PODR02_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR02_1 = 0x1
	// Position of PODR03 field.
	PORT1_PCNTR1_PODR03_Pos = 0x13
	// Bit mask of PODR03 field.
	PORT1_PCNTR1_PODR03_Msk = 0x80000
	// Bit PODR03.
	PORT1_PCNTR1_PODR03 = 0x80000
	// Low output
	PORT1_PCNTR1_PODR03_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR03_1 = 0x1
	// Position of PODR04 field.
	PORT1_PCNTR1_PODR04_Pos = 0x14
	// Bit mask of PODR04 field.
	PORT1_PCNTR1_PODR04_Msk = 0x100000
	// Bit PODR04.
	PORT1_PCNTR1_PODR04 = 0x100000
	// Low output
	PORT1_PCNTR1_PODR04_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR04_1 = 0x1
	// Position of PODR05 field.
	PORT1_PCNTR1_PODR05_Pos = 0x15
	// Bit mask of PODR05 field.
	PORT1_PCNTR1_PODR05_Msk = 0x200000
	// Bit PODR05.
	PORT1_PCNTR1_PODR05 = 0x200000
	// Low output
	PORT1_PCNTR1_PODR05_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR05_1 = 0x1
	// Position of PODR06 field.
	PORT1_PCNTR1_PODR06_Pos = 0x16
	// Bit mask of PODR06 field.
	PORT1_PCNTR1_PODR06_Msk = 0x400000
	// Bit PODR06.
	PORT1_PCNTR1_PODR06 = 0x400000
	// Low output
	PORT1_PCNTR1_PODR06_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR06_1 = 0x1
	// Position of PODR07 field.
	PORT1_PCNTR1_PODR07_Pos = 0x17
	// Bit mask of PODR07 field.
	PORT1_PCNTR1_PODR07_Msk = 0x800000
	// Bit PODR07.
	PORT1_PCNTR1_PODR07 = 0x800000
	// Low output
	PORT1_PCNTR1_PODR07_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR07_1 = 0x1
	// Position of PODR08 field.
	PORT1_PCNTR1_PODR08_Pos = 0x18
	// Bit mask of PODR08 field.
	PORT1_PCNTR1_PODR08_Msk = 0x1000000
	// Bit PODR08.
	PORT1_PCNTR1_PODR08 = 0x1000000
	// Low output
	PORT1_PCNTR1_PODR08_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR08_1 = 0x1
	// Position of PODR09 field.
	PORT1_PCNTR1_PODR09_Pos = 0x19
	// Bit mask of PODR09 field.
	PORT1_PCNTR1_PODR09_Msk = 0x2000000
	// Bit PODR09.
	PORT1_PCNTR1_PODR09 = 0x2000000
	// Low output
	PORT1_PCNTR1_PODR09_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR09_1 = 0x1
	// Position of PODR10 field.
	PORT1_PCNTR1_PODR10_Pos = 0x1a
	// Bit mask of PODR10 field.
	PORT1_PCNTR1_PODR10_Msk = 0x4000000
	// Bit PODR10.
	PORT1_PCNTR1_PODR10 = 0x4000000
	// Low output
	PORT1_PCNTR1_PODR10_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR10_1 = 0x1
	// Position of PODR11 field.
	PORT1_PCNTR1_PODR11_Pos = 0x1b
	// Bit mask of PODR11 field.
	PORT1_PCNTR1_PODR11_Msk = 0x8000000
	// Bit PODR11.
	PORT1_PCNTR1_PODR11 = 0x8000000
	// Low output
	PORT1_PCNTR1_PODR11_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR11_1 = 0x1
	// Position of PODR12 field.
	PORT1_PCNTR1_PODR12_Pos = 0x1c
	// Bit mask of PODR12 field.
	PORT1_PCNTR1_PODR12_Msk = 0x10000000
	// Bit PODR12.
	PORT1_PCNTR1_PODR12 = 0x10000000
	// Low output
	PORT1_PCNTR1_PODR12_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR12_1 = 0x1
	// Position of PODR13 field.
	PORT1_PCNTR1_PODR13_Pos = 0x1d
	// Bit mask of PODR13 field.
	PORT1_PCNTR1_PODR13_Msk = 0x20000000
	// Bit PODR13.
	PORT1_PCNTR1_PODR13 = 0x20000000
	// Low output
	PORT1_PCNTR1_PODR13_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR13_1 = 0x1
	// Position of PODR14 field.
	PORT1_PCNTR1_PODR14_Pos = 0x1e
	// Bit mask of PODR14 field.
	PORT1_PCNTR1_PODR14_Msk = 0x40000000
	// Bit PODR14.
	PORT1_PCNTR1_PODR14 = 0x40000000
	// Low output
	PORT1_PCNTR1_PODR14_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR14_1 = 0x1
	// Position of PODR15 field.
	PORT1_PCNTR1_PODR15_Pos = 0x1f
	// Bit mask of PODR15 field.
	PORT1_PCNTR1_PODR15_Msk = 0x80000000
	// Bit PODR15.
	PORT1_PCNTR1_PODR15 = 0x80000000
	// Low output
	PORT1_PCNTR1_PODR15_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR15_1 = 0x1

	// PODR: Port Control Register 1
	// Position of PODR00 field.
	PORT1_PODR_PODR00_Pos = 0x0
	// Bit mask of PODR00 field.
	PORT1_PODR_PODR00_Msk = 0x1
	// Bit PODR00.
	PORT1_PODR_PODR00 = 0x1
	// Low output
	PORT1_PODR_PODR00_0 = 0x0
	// High output
	PORT1_PODR_PODR00_1 = 0x1
	// Position of PODR01 field.
	PORT1_PODR_PODR01_Pos = 0x1
	// Bit mask of PODR01 field.
	PORT1_PODR_PODR01_Msk = 0x2
	// Bit PODR01.
	PORT1_PODR_PODR01 = 0x2
	// Low output
	PORT1_PODR_PODR01_0 = 0x0
	// High output
	PORT1_PODR_PODR01_1 = 0x1
	// Position of PODR02 field.
	PORT1_PODR_PODR02_Pos = 0x2
	// Bit mask of PODR02 field.
	PORT1_PODR_PODR02_Msk = 0x4
	// Bit PODR02.
	PORT1_PODR_PODR02 = 0x4
	// Low output
	PORT1_PODR_PODR02_0 = 0x0
	// High output
	PORT1_PODR_PODR02_1 = 0x1
	// Position of PODR03 field.
	PORT1_PODR_PODR03_Pos = 0x3
	// Bit mask of PODR03 field.
	PORT1_PODR_PODR03_Msk = 0x8
	// Bit PODR03.
	PORT1_PODR_PODR03 = 0x8
	// Low output
	PORT1_PODR_PODR03_0 = 0x0
	// High output
	PORT1_PODR_PODR03_1 = 0x1
	// Position of PODR04 field.
	PORT1_PODR_PODR04_Pos = 0x4
	// Bit mask of PODR04 field.
	PORT1_PODR_PODR04_Msk = 0x10
	// Bit PODR04.
	PORT1_PODR_PODR04 = 0x10
	// Low output
	PORT1_PODR_PODR04_0 = 0x0
	// High output
	PORT1_PODR_PODR04_1 = 0x1
	// Position of PODR05 field.
	PORT1_PODR_PODR05_Pos = 0x5
	// Bit mask of PODR05 field.
	PORT1_PODR_PODR05_Msk = 0x20
	// Bit PODR05.
	PORT1_PODR_PODR05 = 0x20
	// Low output
	PORT1_PODR_PODR05_0 = 0x0
	// High output
	PORT1_PODR_PODR05_1 = 0x1
	// Position of PODR06 field.
	PORT1_PODR_PODR06_Pos = 0x6
	// Bit mask of PODR06 field.
	PORT1_PODR_PODR06_Msk = 0x40
	// Bit PODR06.
	PORT1_PODR_PODR06 = 0x40
	// Low output
	PORT1_PODR_PODR06_0 = 0x0
	// High output
	PORT1_PODR_PODR06_1 = 0x1
	// Position of PODR07 field.
	PORT1_PODR_PODR07_Pos = 0x7
	// Bit mask of PODR07 field.
	PORT1_PODR_PODR07_Msk = 0x80
	// Bit PODR07.
	PORT1_PODR_PODR07 = 0x80
	// Low output
	PORT1_PODR_PODR07_0 = 0x0
	// High output
	PORT1_PODR_PODR07_1 = 0x1
	// Position of PODR08 field.
	PORT1_PODR_PODR08_Pos = 0x8
	// Bit mask of PODR08 field.
	PORT1_PODR_PODR08_Msk = 0x100
	// Bit PODR08.
	PORT1_PODR_PODR08 = 0x100
	// Low output
	PORT1_PODR_PODR08_0 = 0x0
	// High output
	PORT1_PODR_PODR08_1 = 0x1
	// Position of PODR09 field.
	PORT1_PODR_PODR09_Pos = 0x9
	// Bit mask of PODR09 field.
	PORT1_PODR_PODR09_Msk = 0x200
	// Bit PODR09.
	PORT1_PODR_PODR09 = 0x200
	// Low output
	PORT1_PODR_PODR09_0 = 0x0
	// High output
	PORT1_PODR_PODR09_1 = 0x1
	// Position of PODR10 field.
	PORT1_PODR_PODR10_Pos = 0xa
	// Bit mask of PODR10 field.
	PORT1_PODR_PODR10_Msk = 0x400
	// Bit PODR10.
	PORT1_PODR_PODR10 = 0x400
	// Low output
	PORT1_PODR_PODR10_0 = 0x0
	// High output
	PORT1_PODR_PODR10_1 = 0x1
	// Position of PODR11 field.
	PORT1_PODR_PODR11_Pos = 0xb
	// Bit mask of PODR11 field.
	PORT1_PODR_PODR11_Msk = 0x800
	// Bit PODR11.
	PORT1_PODR_PODR11 = 0x800
	// Low output
	PORT1_PODR_PODR11_0 = 0x0
	// High output
	PORT1_PODR_PODR11_1 = 0x1
	// Position of PODR12 field.
	PORT1_PODR_PODR12_Pos = 0xc
	// Bit mask of PODR12 field.
	PORT1_PODR_PODR12_Msk = 0x1000
	// Bit PODR12.
	PORT1_PODR_PODR12 = 0x1000
	// Low output
	PORT1_PODR_PODR12_0 = 0x0
	// High output
	PORT1_PODR_PODR12_1 = 0x1
	// Position of PODR13 field.
	PORT1_PODR_PODR13_Pos = 0xd
	// Bit mask of PODR13 field.
	PORT1_PODR_PODR13_Msk = 0x2000
	// Bit PODR13.
	PORT1_PODR_PODR13 = 0x2000
	// Low output
	PORT1_PODR_PODR13_0 = 0x0
	// High output
	PORT1_PODR_PODR13_1 = 0x1
	// Position of PODR14 field.
	PORT1_PODR_PODR14_Pos = 0xe
	// Bit mask of PODR14 field.
	PORT1_PODR_PODR14_Msk = 0x4000
	// Bit PODR14.
	PORT1_PODR_PODR14 = 0x4000
	// Low output
	PORT1_PODR_PODR14_0 = 0x0
	// High output
	PORT1_PODR_PODR14_1 = 0x1
	// Position of PODR15 field.
	PORT1_PODR_PODR15_Pos = 0xf
	// Bit mask of PODR15 field.
	PORT1_PODR_PODR15_Msk = 0x8000
	// Bit PODR15.
	PORT1_PODR_PODR15 = 0x8000
	// Low output
	PORT1_PODR_PODR15_0 = 0x0
	// High output
	PORT1_PODR_PODR15_1 = 0x1

	// PDR: Port Control Register 1
	// Position of PDR00 field.
	PORT1_PDR_PDR00_Pos = 0x0
	// Bit mask of PDR00 field.
	PORT1_PDR_PDR00_Msk = 0x1
	// Bit PDR00.
	PORT1_PDR_PDR00 = 0x1
	// Input (functions as an input pin)
	PORT1_PDR_PDR00_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR00_1 = 0x1
	// Position of PDR01 field.
	PORT1_PDR_PDR01_Pos = 0x1
	// Bit mask of PDR01 field.
	PORT1_PDR_PDR01_Msk = 0x2
	// Bit PDR01.
	PORT1_PDR_PDR01 = 0x2
	// Input (functions as an input pin)
	PORT1_PDR_PDR01_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR01_1 = 0x1
	// Position of PDR02 field.
	PORT1_PDR_PDR02_Pos = 0x2
	// Bit mask of PDR02 field.
	PORT1_PDR_PDR02_Msk = 0x4
	// Bit PDR02.
	PORT1_PDR_PDR02 = 0x4
	// Input (functions as an input pin)
	PORT1_PDR_PDR02_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR02_1 = 0x1
	// Position of PDR03 field.
	PORT1_PDR_PDR03_Pos = 0x3
	// Bit mask of PDR03 field.
	PORT1_PDR_PDR03_Msk = 0x8
	// Bit PDR03.
	PORT1_PDR_PDR03 = 0x8
	// Input (functions as an input pin)
	PORT1_PDR_PDR03_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR03_1 = 0x1
	// Position of PDR04 field.
	PORT1_PDR_PDR04_Pos = 0x4
	// Bit mask of PDR04 field.
	PORT1_PDR_PDR04_Msk = 0x10
	// Bit PDR04.
	PORT1_PDR_PDR04 = 0x10
	// Input (functions as an input pin)
	PORT1_PDR_PDR04_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR04_1 = 0x1
	// Position of PDR05 field.
	PORT1_PDR_PDR05_Pos = 0x5
	// Bit mask of PDR05 field.
	PORT1_PDR_PDR05_Msk = 0x20
	// Bit PDR05.
	PORT1_PDR_PDR05 = 0x20
	// Input (functions as an input pin)
	PORT1_PDR_PDR05_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR05_1 = 0x1
	// Position of PDR06 field.
	PORT1_PDR_PDR06_Pos = 0x6
	// Bit mask of PDR06 field.
	PORT1_PDR_PDR06_Msk = 0x40
	// Bit PDR06.
	PORT1_PDR_PDR06 = 0x40
	// Input (functions as an input pin)
	PORT1_PDR_PDR06_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR06_1 = 0x1
	// Position of PDR07 field.
	PORT1_PDR_PDR07_Pos = 0x7
	// Bit mask of PDR07 field.
	PORT1_PDR_PDR07_Msk = 0x80
	// Bit PDR07.
	PORT1_PDR_PDR07 = 0x80
	// Input (functions as an input pin)
	PORT1_PDR_PDR07_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR07_1 = 0x1
	// Position of PDR08 field.
	PORT1_PDR_PDR08_Pos = 0x8
	// Bit mask of PDR08 field.
	PORT1_PDR_PDR08_Msk = 0x100
	// Bit PDR08.
	PORT1_PDR_PDR08 = 0x100
	// Input (functions as an input pin)
	PORT1_PDR_PDR08_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR08_1 = 0x1
	// Position of PDR09 field.
	PORT1_PDR_PDR09_Pos = 0x9
	// Bit mask of PDR09 field.
	PORT1_PDR_PDR09_Msk = 0x200
	// Bit PDR09.
	PORT1_PDR_PDR09 = 0x200
	// Input (functions as an input pin)
	PORT1_PDR_PDR09_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR09_1 = 0x1
	// Position of PDR10 field.
	PORT1_PDR_PDR10_Pos = 0xa
	// Bit mask of PDR10 field.
	PORT1_PDR_PDR10_Msk = 0x400
	// Bit PDR10.
	PORT1_PDR_PDR10 = 0x400
	// Input (functions as an input pin)
	PORT1_PDR_PDR10_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR10_1 = 0x1
	// Position of PDR11 field.
	PORT1_PDR_PDR11_Pos = 0xb
	// Bit mask of PDR11 field.
	PORT1_PDR_PDR11_Msk = 0x800
	// Bit PDR11.
	PORT1_PDR_PDR11 = 0x800
	// Input (functions as an input pin)
	PORT1_PDR_PDR11_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR11_1 = 0x1
	// Position of PDR12 field.
	PORT1_PDR_PDR12_Pos = 0xc
	// Bit mask of PDR12 field.
	PORT1_PDR_PDR12_Msk = 0x1000
	// Bit PDR12.
	PORT1_PDR_PDR12 = 0x1000
	// Input (functions as an input pin)
	PORT1_PDR_PDR12_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR12_1 = 0x1
	// Position of PDR13 field.
	PORT1_PDR_PDR13_Pos = 0xd
	// Bit mask of PDR13 field.
	PORT1_PDR_PDR13_Msk = 0x2000
	// Bit PDR13.
	PORT1_PDR_PDR13 = 0x2000
	// Input (functions as an input pin)
	PORT1_PDR_PDR13_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR13_1 = 0x1
	// Position of PDR14 field.
	PORT1_PDR_PDR14_Pos = 0xe
	// Bit mask of PDR14 field.
	PORT1_PDR_PDR14_Msk = 0x4000
	// Bit PDR14.
	PORT1_PDR_PDR14 = 0x4000
	// Input (functions as an input pin)
	PORT1_PDR_PDR14_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR14_1 = 0x1
	// Position of PDR15 field.
	PORT1_PDR_PDR15_Pos = 0xf
	// Bit mask of PDR15 field.
	PORT1_PDR_PDR15_Msk = 0x8000
	// Bit PDR15.
	PORT1_PDR_PDR15 = 0x8000
	// Input (functions as an input pin)
	PORT1_PDR_PDR15_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR15_1 = 0x1

	// PCNTR2: Port Control Register 2
	// Position of PIDR00 field.
	PORT1_PCNTR2_PIDR00_Pos = 0x0
	// Bit mask of PIDR00 field.
	PORT1_PCNTR2_PIDR00_Msk = 0x1
	// Bit PIDR00.
	PORT1_PCNTR2_PIDR00 = 0x1
	// Low level
	PORT1_PCNTR2_PIDR00_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR00_1 = 0x1
	// Position of PIDR01 field.
	PORT1_PCNTR2_PIDR01_Pos = 0x1
	// Bit mask of PIDR01 field.
	PORT1_PCNTR2_PIDR01_Msk = 0x2
	// Bit PIDR01.
	PORT1_PCNTR2_PIDR01 = 0x2
	// Low level
	PORT1_PCNTR2_PIDR01_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR01_1 = 0x1
	// Position of PIDR02 field.
	PORT1_PCNTR2_PIDR02_Pos = 0x2
	// Bit mask of PIDR02 field.
	PORT1_PCNTR2_PIDR02_Msk = 0x4
	// Bit PIDR02.
	PORT1_PCNTR2_PIDR02 = 0x4
	// Low level
	PORT1_PCNTR2_PIDR02_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR02_1 = 0x1
	// Position of PIDR03 field.
	PORT1_PCNTR2_PIDR03_Pos = 0x3
	// Bit mask of PIDR03 field.
	PORT1_PCNTR2_PIDR03_Msk = 0x8
	// Bit PIDR03.
	PORT1_PCNTR2_PIDR03 = 0x8
	// Low level
	PORT1_PCNTR2_PIDR03_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR03_1 = 0x1
	// Position of PIDR04 field.
	PORT1_PCNTR2_PIDR04_Pos = 0x4
	// Bit mask of PIDR04 field.
	PORT1_PCNTR2_PIDR04_Msk = 0x10
	// Bit PIDR04.
	PORT1_PCNTR2_PIDR04 = 0x10
	// Low level
	PORT1_PCNTR2_PIDR04_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR04_1 = 0x1
	// Position of PIDR05 field.
	PORT1_PCNTR2_PIDR05_Pos = 0x5
	// Bit mask of PIDR05 field.
	PORT1_PCNTR2_PIDR05_Msk = 0x20
	// Bit PIDR05.
	PORT1_PCNTR2_PIDR05 = 0x20
	// Low level
	PORT1_PCNTR2_PIDR05_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR05_1 = 0x1
	// Position of PIDR06 field.
	PORT1_PCNTR2_PIDR06_Pos = 0x6
	// Bit mask of PIDR06 field.
	PORT1_PCNTR2_PIDR06_Msk = 0x40
	// Bit PIDR06.
	PORT1_PCNTR2_PIDR06 = 0x40
	// Low level
	PORT1_PCNTR2_PIDR06_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR06_1 = 0x1
	// Position of PIDR07 field.
	PORT1_PCNTR2_PIDR07_Pos = 0x7
	// Bit mask of PIDR07 field.
	PORT1_PCNTR2_PIDR07_Msk = 0x80
	// Bit PIDR07.
	PORT1_PCNTR2_PIDR07 = 0x80
	// Low level
	PORT1_PCNTR2_PIDR07_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR07_1 = 0x1
	// Position of PIDR08 field.
	PORT1_PCNTR2_PIDR08_Pos = 0x8
	// Bit mask of PIDR08 field.
	PORT1_PCNTR2_PIDR08_Msk = 0x100
	// Bit PIDR08.
	PORT1_PCNTR2_PIDR08 = 0x100
	// Low level
	PORT1_PCNTR2_PIDR08_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR08_1 = 0x1
	// Position of PIDR09 field.
	PORT1_PCNTR2_PIDR09_Pos = 0x9
	// Bit mask of PIDR09 field.
	PORT1_PCNTR2_PIDR09_Msk = 0x200
	// Bit PIDR09.
	PORT1_PCNTR2_PIDR09 = 0x200
	// Low level
	PORT1_PCNTR2_PIDR09_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR09_1 = 0x1
	// Position of PIDR10 field.
	PORT1_PCNTR2_PIDR10_Pos = 0xa
	// Bit mask of PIDR10 field.
	PORT1_PCNTR2_PIDR10_Msk = 0x400
	// Bit PIDR10.
	PORT1_PCNTR2_PIDR10 = 0x400
	// Low level
	PORT1_PCNTR2_PIDR10_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR10_1 = 0x1
	// Position of PIDR11 field.
	PORT1_PCNTR2_PIDR11_Pos = 0xb
	// Bit mask of PIDR11 field.
	PORT1_PCNTR2_PIDR11_Msk = 0x800
	// Bit PIDR11.
	PORT1_PCNTR2_PIDR11 = 0x800
	// Low level
	PORT1_PCNTR2_PIDR11_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR11_1 = 0x1
	// Position of PIDR12 field.
	PORT1_PCNTR2_PIDR12_Pos = 0xc
	// Bit mask of PIDR12 field.
	PORT1_PCNTR2_PIDR12_Msk = 0x1000
	// Bit PIDR12.
	PORT1_PCNTR2_PIDR12 = 0x1000
	// Low level
	PORT1_PCNTR2_PIDR12_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR12_1 = 0x1
	// Position of PIDR13 field.
	PORT1_PCNTR2_PIDR13_Pos = 0xd
	// Bit mask of PIDR13 field.
	PORT1_PCNTR2_PIDR13_Msk = 0x2000
	// Bit PIDR13.
	PORT1_PCNTR2_PIDR13 = 0x2000
	// Low level
	PORT1_PCNTR2_PIDR13_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR13_1 = 0x1
	// Position of PIDR14 field.
	PORT1_PCNTR2_PIDR14_Pos = 0xe
	// Bit mask of PIDR14 field.
	PORT1_PCNTR2_PIDR14_Msk = 0x4000
	// Bit PIDR14.
	PORT1_PCNTR2_PIDR14 = 0x4000
	// Low level
	PORT1_PCNTR2_PIDR14_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR14_1 = 0x1
	// Position of PIDR15 field.
	PORT1_PCNTR2_PIDR15_Pos = 0xf
	// Bit mask of PIDR15 field.
	PORT1_PCNTR2_PIDR15_Msk = 0x8000
	// Bit PIDR15.
	PORT1_PCNTR2_PIDR15 = 0x8000
	// Low level
	PORT1_PCNTR2_PIDR15_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR15_1 = 0x1
	// Position of EIDR00 field.
	PORT1_PCNTR2_EIDR00_Pos = 0x10
	// Bit mask of EIDR00 field.
	PORT1_PCNTR2_EIDR00_Msk = 0x10000
	// Bit EIDR00.
	PORT1_PCNTR2_EIDR00 = 0x10000
	// Low input
	PORT1_PCNTR2_EIDR00_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR00_1 = 0x1
	// Position of EIDR01 field.
	PORT1_PCNTR2_EIDR01_Pos = 0x11
	// Bit mask of EIDR01 field.
	PORT1_PCNTR2_EIDR01_Msk = 0x20000
	// Bit EIDR01.
	PORT1_PCNTR2_EIDR01 = 0x20000
	// Low input
	PORT1_PCNTR2_EIDR01_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR01_1 = 0x1
	// Position of EIDR02 field.
	PORT1_PCNTR2_EIDR02_Pos = 0x12
	// Bit mask of EIDR02 field.
	PORT1_PCNTR2_EIDR02_Msk = 0x40000
	// Bit EIDR02.
	PORT1_PCNTR2_EIDR02 = 0x40000
	// Low input
	PORT1_PCNTR2_EIDR02_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR02_1 = 0x1
	// Position of EIDR03 field.
	PORT1_PCNTR2_EIDR03_Pos = 0x13
	// Bit mask of EIDR03 field.
	PORT1_PCNTR2_EIDR03_Msk = 0x80000
	// Bit EIDR03.
	PORT1_PCNTR2_EIDR03 = 0x80000
	// Low input
	PORT1_PCNTR2_EIDR03_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR03_1 = 0x1
	// Position of EIDR04 field.
	PORT1_PCNTR2_EIDR04_Pos = 0x14
	// Bit mask of EIDR04 field.
	PORT1_PCNTR2_EIDR04_Msk = 0x100000
	// Bit EIDR04.
	PORT1_PCNTR2_EIDR04 = 0x100000
	// Low input
	PORT1_PCNTR2_EIDR04_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR04_1 = 0x1
	// Position of EIDR05 field.
	PORT1_PCNTR2_EIDR05_Pos = 0x15
	// Bit mask of EIDR05 field.
	PORT1_PCNTR2_EIDR05_Msk = 0x200000
	// Bit EIDR05.
	PORT1_PCNTR2_EIDR05 = 0x200000
	// Low input
	PORT1_PCNTR2_EIDR05_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR05_1 = 0x1
	// Position of EIDR06 field.
	PORT1_PCNTR2_EIDR06_Pos = 0x16
	// Bit mask of EIDR06 field.
	PORT1_PCNTR2_EIDR06_Msk = 0x400000
	// Bit EIDR06.
	PORT1_PCNTR2_EIDR06 = 0x400000
	// Low input
	PORT1_PCNTR2_EIDR06_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR06_1 = 0x1
	// Position of EIDR07 field.
	PORT1_PCNTR2_EIDR07_Pos = 0x17
	// Bit mask of EIDR07 field.
	PORT1_PCNTR2_EIDR07_Msk = 0x800000
	// Bit EIDR07.
	PORT1_PCNTR2_EIDR07 = 0x800000
	// Low input
	PORT1_PCNTR2_EIDR07_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR07_1 = 0x1
	// Position of EIDR08 field.
	PORT1_PCNTR2_EIDR08_Pos = 0x18
	// Bit mask of EIDR08 field.
	PORT1_PCNTR2_EIDR08_Msk = 0x1000000
	// Bit EIDR08.
	PORT1_PCNTR2_EIDR08 = 0x1000000
	// Low input
	PORT1_PCNTR2_EIDR08_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR08_1 = 0x1
	// Position of EIDR09 field.
	PORT1_PCNTR2_EIDR09_Pos = 0x19
	// Bit mask of EIDR09 field.
	PORT1_PCNTR2_EIDR09_Msk = 0x2000000
	// Bit EIDR09.
	PORT1_PCNTR2_EIDR09 = 0x2000000
	// Low input
	PORT1_PCNTR2_EIDR09_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR09_1 = 0x1
	// Position of EIDR10 field.
	PORT1_PCNTR2_EIDR10_Pos = 0x1a
	// Bit mask of EIDR10 field.
	PORT1_PCNTR2_EIDR10_Msk = 0x4000000
	// Bit EIDR10.
	PORT1_PCNTR2_EIDR10 = 0x4000000
	// Low input
	PORT1_PCNTR2_EIDR10_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR10_1 = 0x1
	// Position of EIDR11 field.
	PORT1_PCNTR2_EIDR11_Pos = 0x1b
	// Bit mask of EIDR11 field.
	PORT1_PCNTR2_EIDR11_Msk = 0x8000000
	// Bit EIDR11.
	PORT1_PCNTR2_EIDR11 = 0x8000000
	// Low input
	PORT1_PCNTR2_EIDR11_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR11_1 = 0x1
	// Position of EIDR12 field.
	PORT1_PCNTR2_EIDR12_Pos = 0x1c
	// Bit mask of EIDR12 field.
	PORT1_PCNTR2_EIDR12_Msk = 0x10000000
	// Bit EIDR12.
	PORT1_PCNTR2_EIDR12 = 0x10000000
	// Low input
	PORT1_PCNTR2_EIDR12_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR12_1 = 0x1
	// Position of EIDR13 field.
	PORT1_PCNTR2_EIDR13_Pos = 0x1d
	// Bit mask of EIDR13 field.
	PORT1_PCNTR2_EIDR13_Msk = 0x20000000
	// Bit EIDR13.
	PORT1_PCNTR2_EIDR13 = 0x20000000
	// Low input
	PORT1_PCNTR2_EIDR13_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR13_1 = 0x1
	// Position of EIDR14 field.
	PORT1_PCNTR2_EIDR14_Pos = 0x1e
	// Bit mask of EIDR14 field.
	PORT1_PCNTR2_EIDR14_Msk = 0x40000000
	// Bit EIDR14.
	PORT1_PCNTR2_EIDR14 = 0x40000000
	// Low input
	PORT1_PCNTR2_EIDR14_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR14_1 = 0x1
	// Position of EIDR15 field.
	PORT1_PCNTR2_EIDR15_Pos = 0x1f
	// Bit mask of EIDR15 field.
	PORT1_PCNTR2_EIDR15_Msk = 0x80000000
	// Bit EIDR15.
	PORT1_PCNTR2_EIDR15 = 0x80000000
	// Low input
	PORT1_PCNTR2_EIDR15_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR15_1 = 0x1

	// EIDR: Port Control Register 2
	// Position of EIDR00 field.
	PORT1_EIDR_EIDR00_Pos = 0x0
	// Bit mask of EIDR00 field.
	PORT1_EIDR_EIDR00_Msk = 0x1
	// Bit EIDR00.
	PORT1_EIDR_EIDR00 = 0x1
	// Low input
	PORT1_EIDR_EIDR00_0 = 0x0
	// High input
	PORT1_EIDR_EIDR00_1 = 0x1
	// Position of EIDR01 field.
	PORT1_EIDR_EIDR01_Pos = 0x1
	// Bit mask of EIDR01 field.
	PORT1_EIDR_EIDR01_Msk = 0x2
	// Bit EIDR01.
	PORT1_EIDR_EIDR01 = 0x2
	// Low input
	PORT1_EIDR_EIDR01_0 = 0x0
	// High input
	PORT1_EIDR_EIDR01_1 = 0x1
	// Position of EIDR02 field.
	PORT1_EIDR_EIDR02_Pos = 0x2
	// Bit mask of EIDR02 field.
	PORT1_EIDR_EIDR02_Msk = 0x4
	// Bit EIDR02.
	PORT1_EIDR_EIDR02 = 0x4
	// Low input
	PORT1_EIDR_EIDR02_0 = 0x0
	// High input
	PORT1_EIDR_EIDR02_1 = 0x1
	// Position of EIDR03 field.
	PORT1_EIDR_EIDR03_Pos = 0x3
	// Bit mask of EIDR03 field.
	PORT1_EIDR_EIDR03_Msk = 0x8
	// Bit EIDR03.
	PORT1_EIDR_EIDR03 = 0x8
	// Low input
	PORT1_EIDR_EIDR03_0 = 0x0
	// High input
	PORT1_EIDR_EIDR03_1 = 0x1
	// Position of EIDR04 field.
	PORT1_EIDR_EIDR04_Pos = 0x4
	// Bit mask of EIDR04 field.
	PORT1_EIDR_EIDR04_Msk = 0x10
	// Bit EIDR04.
	PORT1_EIDR_EIDR04 = 0x10
	// Low input
	PORT1_EIDR_EIDR04_0 = 0x0
	// High input
	PORT1_EIDR_EIDR04_1 = 0x1
	// Position of EIDR05 field.
	PORT1_EIDR_EIDR05_Pos = 0x5
	// Bit mask of EIDR05 field.
	PORT1_EIDR_EIDR05_Msk = 0x20
	// Bit EIDR05.
	PORT1_EIDR_EIDR05 = 0x20
	// Low input
	PORT1_EIDR_EIDR05_0 = 0x0
	// High input
	PORT1_EIDR_EIDR05_1 = 0x1
	// Position of EIDR06 field.
	PORT1_EIDR_EIDR06_Pos = 0x6
	// Bit mask of EIDR06 field.
	PORT1_EIDR_EIDR06_Msk = 0x40
	// Bit EIDR06.
	PORT1_EIDR_EIDR06 = 0x40
	// Low input
	PORT1_EIDR_EIDR06_0 = 0x0
	// High input
	PORT1_EIDR_EIDR06_1 = 0x1
	// Position of EIDR07 field.
	PORT1_EIDR_EIDR07_Pos = 0x7
	// Bit mask of EIDR07 field.
	PORT1_EIDR_EIDR07_Msk = 0x80
	// Bit EIDR07.
	PORT1_EIDR_EIDR07 = 0x80
	// Low input
	PORT1_EIDR_EIDR07_0 = 0x0
	// High input
	PORT1_EIDR_EIDR07_1 = 0x1
	// Position of EIDR08 field.
	PORT1_EIDR_EIDR08_Pos = 0x8
	// Bit mask of EIDR08 field.
	PORT1_EIDR_EIDR08_Msk = 0x100
	// Bit EIDR08.
	PORT1_EIDR_EIDR08 = 0x100
	// Low input
	PORT1_EIDR_EIDR08_0 = 0x0
	// High input
	PORT1_EIDR_EIDR08_1 = 0x1
	// Position of EIDR09 field.
	PORT1_EIDR_EIDR09_Pos = 0x9
	// Bit mask of EIDR09 field.
	PORT1_EIDR_EIDR09_Msk = 0x200
	// Bit EIDR09.
	PORT1_EIDR_EIDR09 = 0x200
	// Low input
	PORT1_EIDR_EIDR09_0 = 0x0
	// High input
	PORT1_EIDR_EIDR09_1 = 0x1
	// Position of EIDR10 field.
	PORT1_EIDR_EIDR10_Pos = 0xa
	// Bit mask of EIDR10 field.
	PORT1_EIDR_EIDR10_Msk = 0x400
	// Bit EIDR10.
	PORT1_EIDR_EIDR10 = 0x400
	// Low input
	PORT1_EIDR_EIDR10_0 = 0x0
	// High input
	PORT1_EIDR_EIDR10_1 = 0x1
	// Position of EIDR11 field.
	PORT1_EIDR_EIDR11_Pos = 0xb
	// Bit mask of EIDR11 field.
	PORT1_EIDR_EIDR11_Msk = 0x800
	// Bit EIDR11.
	PORT1_EIDR_EIDR11 = 0x800
	// Low input
	PORT1_EIDR_EIDR11_0 = 0x0
	// High input
	PORT1_EIDR_EIDR11_1 = 0x1
	// Position of EIDR12 field.
	PORT1_EIDR_EIDR12_Pos = 0xc
	// Bit mask of EIDR12 field.
	PORT1_EIDR_EIDR12_Msk = 0x1000
	// Bit EIDR12.
	PORT1_EIDR_EIDR12 = 0x1000
	// Low input
	PORT1_EIDR_EIDR12_0 = 0x0
	// High input
	PORT1_EIDR_EIDR12_1 = 0x1
	// Position of EIDR13 field.
	PORT1_EIDR_EIDR13_Pos = 0xd
	// Bit mask of EIDR13 field.
	PORT1_EIDR_EIDR13_Msk = 0x2000
	// Bit EIDR13.
	PORT1_EIDR_EIDR13 = 0x2000
	// Low input
	PORT1_EIDR_EIDR13_0 = 0x0
	// High input
	PORT1_EIDR_EIDR13_1 = 0x1
	// Position of EIDR14 field.
	PORT1_EIDR_EIDR14_Pos = 0xe
	// Bit mask of EIDR14 field.
	PORT1_EIDR_EIDR14_Msk = 0x4000
	// Bit EIDR14.
	PORT1_EIDR_EIDR14 = 0x4000
	// Low input
	PORT1_EIDR_EIDR14_0 = 0x0
	// High input
	PORT1_EIDR_EIDR14_1 = 0x1
	// Position of EIDR15 field.
	PORT1_EIDR_EIDR15_Pos = 0xf
	// Bit mask of EIDR15 field.
	PORT1_EIDR_EIDR15_Msk = 0x8000
	// Bit EIDR15.
	PORT1_EIDR_EIDR15 = 0x8000
	// Low input
	PORT1_EIDR_EIDR15_0 = 0x0
	// High input
	PORT1_EIDR_EIDR15_1 = 0x1

	// PIDR: Port Control Register 2
	// Position of PIDR00 field.
	PORT1_PIDR_PIDR00_Pos = 0x0
	// Bit mask of PIDR00 field.
	PORT1_PIDR_PIDR00_Msk = 0x1
	// Bit PIDR00.
	PORT1_PIDR_PIDR00 = 0x1
	// Low level
	PORT1_PIDR_PIDR00_0 = 0x0
	// High level
	PORT1_PIDR_PIDR00_1 = 0x1
	// Position of PIDR01 field.
	PORT1_PIDR_PIDR01_Pos = 0x1
	// Bit mask of PIDR01 field.
	PORT1_PIDR_PIDR01_Msk = 0x2
	// Bit PIDR01.
	PORT1_PIDR_PIDR01 = 0x2
	// Low level
	PORT1_PIDR_PIDR01_0 = 0x0
	// High level
	PORT1_PIDR_PIDR01_1 = 0x1
	// Position of PIDR02 field.
	PORT1_PIDR_PIDR02_Pos = 0x2
	// Bit mask of PIDR02 field.
	PORT1_PIDR_PIDR02_Msk = 0x4
	// Bit PIDR02.
	PORT1_PIDR_PIDR02 = 0x4
	// Low level
	PORT1_PIDR_PIDR02_0 = 0x0
	// High level
	PORT1_PIDR_PIDR02_1 = 0x1
	// Position of PIDR03 field.
	PORT1_PIDR_PIDR03_Pos = 0x3
	// Bit mask of PIDR03 field.
	PORT1_PIDR_PIDR03_Msk = 0x8
	// Bit PIDR03.
	PORT1_PIDR_PIDR03 = 0x8
	// Low level
	PORT1_PIDR_PIDR03_0 = 0x0
	// High level
	PORT1_PIDR_PIDR03_1 = 0x1
	// Position of PIDR04 field.
	PORT1_PIDR_PIDR04_Pos = 0x4
	// Bit mask of PIDR04 field.
	PORT1_PIDR_PIDR04_Msk = 0x10
	// Bit PIDR04.
	PORT1_PIDR_PIDR04 = 0x10
	// Low level
	PORT1_PIDR_PIDR04_0 = 0x0
	// High level
	PORT1_PIDR_PIDR04_1 = 0x1
	// Position of PIDR05 field.
	PORT1_PIDR_PIDR05_Pos = 0x5
	// Bit mask of PIDR05 field.
	PORT1_PIDR_PIDR05_Msk = 0x20
	// Bit PIDR05.
	PORT1_PIDR_PIDR05 = 0x20
	// Low level
	PORT1_PIDR_PIDR05_0 = 0x0
	// High level
	PORT1_PIDR_PIDR05_1 = 0x1
	// Position of PIDR06 field.
	PORT1_PIDR_PIDR06_Pos = 0x6
	// Bit mask of PIDR06 field.
	PORT1_PIDR_PIDR06_Msk = 0x40
	// Bit PIDR06.
	PORT1_PIDR_PIDR06 = 0x40
	// Low level
	PORT1_PIDR_PIDR06_0 = 0x0
	// High level
	PORT1_PIDR_PIDR06_1 = 0x1
	// Position of PIDR07 field.
	PORT1_PIDR_PIDR07_Pos = 0x7
	// Bit mask of PIDR07 field.
	PORT1_PIDR_PIDR07_Msk = 0x80
	// Bit PIDR07.
	PORT1_PIDR_PIDR07 = 0x80
	// Low level
	PORT1_PIDR_PIDR07_0 = 0x0
	// High level
	PORT1_PIDR_PIDR07_1 = 0x1
	// Position of PIDR08 field.
	PORT1_PIDR_PIDR08_Pos = 0x8
	// Bit mask of PIDR08 field.
	PORT1_PIDR_PIDR08_Msk = 0x100
	// Bit PIDR08.
	PORT1_PIDR_PIDR08 = 0x100
	// Low level
	PORT1_PIDR_PIDR08_0 = 0x0
	// High level
	PORT1_PIDR_PIDR08_1 = 0x1
	// Position of PIDR09 field.
	PORT1_PIDR_PIDR09_Pos = 0x9
	// Bit mask of PIDR09 field.
	PORT1_PIDR_PIDR09_Msk = 0x200
	// Bit PIDR09.
	PORT1_PIDR_PIDR09 = 0x200
	// Low level
	PORT1_PIDR_PIDR09_0 = 0x0
	// High level
	PORT1_PIDR_PIDR09_1 = 0x1
	// Position of PIDR10 field.
	PORT1_PIDR_PIDR10_Pos = 0xa
	// Bit mask of PIDR10 field.
	PORT1_PIDR_PIDR10_Msk = 0x400
	// Bit PIDR10.
	PORT1_PIDR_PIDR10 = 0x400
	// Low level
	PORT1_PIDR_PIDR10_0 = 0x0
	// High level
	PORT1_PIDR_PIDR10_1 = 0x1
	// Position of PIDR11 field.
	PORT1_PIDR_PIDR11_Pos = 0xb
	// Bit mask of PIDR11 field.
	PORT1_PIDR_PIDR11_Msk = 0x800
	// Bit PIDR11.
	PORT1_PIDR_PIDR11 = 0x800
	// Low level
	PORT1_PIDR_PIDR11_0 = 0x0
	// High level
	PORT1_PIDR_PIDR11_1 = 0x1
	// Position of PIDR12 field.
	PORT1_PIDR_PIDR12_Pos = 0xc
	// Bit mask of PIDR12 field.
	PORT1_PIDR_PIDR12_Msk = 0x1000
	// Bit PIDR12.
	PORT1_PIDR_PIDR12 = 0x1000
	// Low level
	PORT1_PIDR_PIDR12_0 = 0x0
	// High level
	PORT1_PIDR_PIDR12_1 = 0x1
	// Position of PIDR13 field.
	PORT1_PIDR_PIDR13_Pos = 0xd
	// Bit mask of PIDR13 field.
	PORT1_PIDR_PIDR13_Msk = 0x2000
	// Bit PIDR13.
	PORT1_PIDR_PIDR13 = 0x2000
	// Low level
	PORT1_PIDR_PIDR13_0 = 0x0
	// High level
	PORT1_PIDR_PIDR13_1 = 0x1
	// Position of PIDR14 field.
	PORT1_PIDR_PIDR14_Pos = 0xe
	// Bit mask of PIDR14 field.
	PORT1_PIDR_PIDR14_Msk = 0x4000
	// Bit PIDR14.
	PORT1_PIDR_PIDR14 = 0x4000
	// Low level
	PORT1_PIDR_PIDR14_0 = 0x0
	// High level
	PORT1_PIDR_PIDR14_1 = 0x1
	// Position of PIDR15 field.
	PORT1_PIDR_PIDR15_Pos = 0xf
	// Bit mask of PIDR15 field.
	PORT1_PIDR_PIDR15_Msk = 0x8000
	// Bit PIDR15.
	PORT1_PIDR_PIDR15 = 0x8000
	// Low level
	PORT1_PIDR_PIDR15_0 = 0x0
	// High level
	PORT1_PIDR_PIDR15_1 = 0x1

	// PCNTR3: Port Control Register 3
	// Position of POSR00 field.
	PORT1_PCNTR3_POSR00_Pos = 0x0
	// Bit mask of POSR00 field.
	PORT1_PCNTR3_POSR00_Msk = 0x1
	// Bit POSR00.
	PORT1_PCNTR3_POSR00 = 0x1
	// No effect on output
	PORT1_PCNTR3_POSR00_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR00_1 = 0x1
	// Position of POSR01 field.
	PORT1_PCNTR3_POSR01_Pos = 0x1
	// Bit mask of POSR01 field.
	PORT1_PCNTR3_POSR01_Msk = 0x2
	// Bit POSR01.
	PORT1_PCNTR3_POSR01 = 0x2
	// No effect on output
	PORT1_PCNTR3_POSR01_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR01_1 = 0x1
	// Position of POSR02 field.
	PORT1_PCNTR3_POSR02_Pos = 0x2
	// Bit mask of POSR02 field.
	PORT1_PCNTR3_POSR02_Msk = 0x4
	// Bit POSR02.
	PORT1_PCNTR3_POSR02 = 0x4
	// No effect on output
	PORT1_PCNTR3_POSR02_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR02_1 = 0x1
	// Position of POSR03 field.
	PORT1_PCNTR3_POSR03_Pos = 0x3
	// Bit mask of POSR03 field.
	PORT1_PCNTR3_POSR03_Msk = 0x8
	// Bit POSR03.
	PORT1_PCNTR3_POSR03 = 0x8
	// No effect on output
	PORT1_PCNTR3_POSR03_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR03_1 = 0x1
	// Position of POSR04 field.
	PORT1_PCNTR3_POSR04_Pos = 0x4
	// Bit mask of POSR04 field.
	PORT1_PCNTR3_POSR04_Msk = 0x10
	// Bit POSR04.
	PORT1_PCNTR3_POSR04 = 0x10
	// No effect on output
	PORT1_PCNTR3_POSR04_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR04_1 = 0x1
	// Position of POSR05 field.
	PORT1_PCNTR3_POSR05_Pos = 0x5
	// Bit mask of POSR05 field.
	PORT1_PCNTR3_POSR05_Msk = 0x20
	// Bit POSR05.
	PORT1_PCNTR3_POSR05 = 0x20
	// No effect on output
	PORT1_PCNTR3_POSR05_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR05_1 = 0x1
	// Position of POSR06 field.
	PORT1_PCNTR3_POSR06_Pos = 0x6
	// Bit mask of POSR06 field.
	PORT1_PCNTR3_POSR06_Msk = 0x40
	// Bit POSR06.
	PORT1_PCNTR3_POSR06 = 0x40
	// No effect on output
	PORT1_PCNTR3_POSR06_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR06_1 = 0x1
	// Position of POSR07 field.
	PORT1_PCNTR3_POSR07_Pos = 0x7
	// Bit mask of POSR07 field.
	PORT1_PCNTR3_POSR07_Msk = 0x80
	// Bit POSR07.
	PORT1_PCNTR3_POSR07 = 0x80
	// No effect on output
	PORT1_PCNTR3_POSR07_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR07_1 = 0x1
	// Position of POSR08 field.
	PORT1_PCNTR3_POSR08_Pos = 0x8
	// Bit mask of POSR08 field.
	PORT1_PCNTR3_POSR08_Msk = 0x100
	// Bit POSR08.
	PORT1_PCNTR3_POSR08 = 0x100
	// No effect on output
	PORT1_PCNTR3_POSR08_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR08_1 = 0x1
	// Position of POSR09 field.
	PORT1_PCNTR3_POSR09_Pos = 0x9
	// Bit mask of POSR09 field.
	PORT1_PCNTR3_POSR09_Msk = 0x200
	// Bit POSR09.
	PORT1_PCNTR3_POSR09 = 0x200
	// No effect on output
	PORT1_PCNTR3_POSR09_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR09_1 = 0x1
	// Position of POSR10 field.
	PORT1_PCNTR3_POSR10_Pos = 0xa
	// Bit mask of POSR10 field.
	PORT1_PCNTR3_POSR10_Msk = 0x400
	// Bit POSR10.
	PORT1_PCNTR3_POSR10 = 0x400
	// No effect on output
	PORT1_PCNTR3_POSR10_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR10_1 = 0x1
	// Position of POSR11 field.
	PORT1_PCNTR3_POSR11_Pos = 0xb
	// Bit mask of POSR11 field.
	PORT1_PCNTR3_POSR11_Msk = 0x800
	// Bit POSR11.
	PORT1_PCNTR3_POSR11 = 0x800
	// No effect on output
	PORT1_PCNTR3_POSR11_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR11_1 = 0x1
	// Position of POSR12 field.
	PORT1_PCNTR3_POSR12_Pos = 0xc
	// Bit mask of POSR12 field.
	PORT1_PCNTR3_POSR12_Msk = 0x1000
	// Bit POSR12.
	PORT1_PCNTR3_POSR12 = 0x1000
	// No effect on output
	PORT1_PCNTR3_POSR12_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR12_1 = 0x1
	// Position of POSR13 field.
	PORT1_PCNTR3_POSR13_Pos = 0xd
	// Bit mask of POSR13 field.
	PORT1_PCNTR3_POSR13_Msk = 0x2000
	// Bit POSR13.
	PORT1_PCNTR3_POSR13 = 0x2000
	// No effect on output
	PORT1_PCNTR3_POSR13_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR13_1 = 0x1
	// Position of POSR14 field.
	PORT1_PCNTR3_POSR14_Pos = 0xe
	// Bit mask of POSR14 field.
	PORT1_PCNTR3_POSR14_Msk = 0x4000
	// Bit POSR14.
	PORT1_PCNTR3_POSR14 = 0x4000
	// No effect on output
	PORT1_PCNTR3_POSR14_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR14_1 = 0x1
	// Position of POSR15 field.
	PORT1_PCNTR3_POSR15_Pos = 0xf
	// Bit mask of POSR15 field.
	PORT1_PCNTR3_POSR15_Msk = 0x8000
	// Bit POSR15.
	PORT1_PCNTR3_POSR15 = 0x8000
	// No effect on output
	PORT1_PCNTR3_POSR15_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR15_1 = 0x1
	// Position of PORR00 field.
	PORT1_PCNTR3_PORR00_Pos = 0x10
	// Bit mask of PORR00 field.
	PORT1_PCNTR3_PORR00_Msk = 0x10000
	// Bit PORR00.
	PORT1_PCNTR3_PORR00 = 0x10000
	// No effect on output
	PORT1_PCNTR3_PORR00_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR00_1 = 0x1
	// Position of PORR01 field.
	PORT1_PCNTR3_PORR01_Pos = 0x11
	// Bit mask of PORR01 field.
	PORT1_PCNTR3_PORR01_Msk = 0x20000
	// Bit PORR01.
	PORT1_PCNTR3_PORR01 = 0x20000
	// No effect on output
	PORT1_PCNTR3_PORR01_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR01_1 = 0x1
	// Position of PORR02 field.
	PORT1_PCNTR3_PORR02_Pos = 0x12
	// Bit mask of PORR02 field.
	PORT1_PCNTR3_PORR02_Msk = 0x40000
	// Bit PORR02.
	PORT1_PCNTR3_PORR02 = 0x40000
	// No effect on output
	PORT1_PCNTR3_PORR02_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR02_1 = 0x1
	// Position of PORR03 field.
	PORT1_PCNTR3_PORR03_Pos = 0x13
	// Bit mask of PORR03 field.
	PORT1_PCNTR3_PORR03_Msk = 0x80000
	// Bit PORR03.
	PORT1_PCNTR3_PORR03 = 0x80000
	// No effect on output
	PORT1_PCNTR3_PORR03_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR03_1 = 0x1
	// Position of PORR04 field.
	PORT1_PCNTR3_PORR04_Pos = 0x14
	// Bit mask of PORR04 field.
	PORT1_PCNTR3_PORR04_Msk = 0x100000
	// Bit PORR04.
	PORT1_PCNTR3_PORR04 = 0x100000
	// No effect on output
	PORT1_PCNTR3_PORR04_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR04_1 = 0x1
	// Position of PORR05 field.
	PORT1_PCNTR3_PORR05_Pos = 0x15
	// Bit mask of PORR05 field.
	PORT1_PCNTR3_PORR05_Msk = 0x200000
	// Bit PORR05.
	PORT1_PCNTR3_PORR05 = 0x200000
	// No effect on output
	PORT1_PCNTR3_PORR05_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR05_1 = 0x1
	// Position of PORR06 field.
	PORT1_PCNTR3_PORR06_Pos = 0x16
	// Bit mask of PORR06 field.
	PORT1_PCNTR3_PORR06_Msk = 0x400000
	// Bit PORR06.
	PORT1_PCNTR3_PORR06 = 0x400000
	// No effect on output
	PORT1_PCNTR3_PORR06_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR06_1 = 0x1
	// Position of PORR07 field.
	PORT1_PCNTR3_PORR07_Pos = 0x17
	// Bit mask of PORR07 field.
	PORT1_PCNTR3_PORR07_Msk = 0x800000
	// Bit PORR07.
	PORT1_PCNTR3_PORR07 = 0x800000
	// No effect on output
	PORT1_PCNTR3_PORR07_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR07_1 = 0x1
	// Position of PORR08 field.
	PORT1_PCNTR3_PORR08_Pos = 0x18
	// Bit mask of PORR08 field.
	PORT1_PCNTR3_PORR08_Msk = 0x1000000
	// Bit PORR08.
	PORT1_PCNTR3_PORR08 = 0x1000000
	// No effect on output
	PORT1_PCNTR3_PORR08_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR08_1 = 0x1
	// Position of PORR09 field.
	PORT1_PCNTR3_PORR09_Pos = 0x19
	// Bit mask of PORR09 field.
	PORT1_PCNTR3_PORR09_Msk = 0x2000000
	// Bit PORR09.
	PORT1_PCNTR3_PORR09 = 0x2000000
	// No effect on output
	PORT1_PCNTR3_PORR09_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR09_1 = 0x1
	// Position of PORR10 field.
	PORT1_PCNTR3_PORR10_Pos = 0x1a
	// Bit mask of PORR10 field.
	PORT1_PCNTR3_PORR10_Msk = 0x4000000
	// Bit PORR10.
	PORT1_PCNTR3_PORR10 = 0x4000000
	// No effect on output
	PORT1_PCNTR3_PORR10_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR10_1 = 0x1
	// Position of PORR11 field.
	PORT1_PCNTR3_PORR11_Pos = 0x1b
	// Bit mask of PORR11 field.
	PORT1_PCNTR3_PORR11_Msk = 0x8000000
	// Bit PORR11.
	PORT1_PCNTR3_PORR11 = 0x8000000
	// No effect on output
	PORT1_PCNTR3_PORR11_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR11_1 = 0x1
	// Position of PORR12 field.
	PORT1_PCNTR3_PORR12_Pos = 0x1c
	// Bit mask of PORR12 field.
	PORT1_PCNTR3_PORR12_Msk = 0x10000000
	// Bit PORR12.
	PORT1_PCNTR3_PORR12 = 0x10000000
	// No effect on output
	PORT1_PCNTR3_PORR12_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR12_1 = 0x1
	// Position of PORR13 field.
	PORT1_PCNTR3_PORR13_Pos = 0x1d
	// Bit mask of PORR13 field.
	PORT1_PCNTR3_PORR13_Msk = 0x20000000
	// Bit PORR13.
	PORT1_PCNTR3_PORR13 = 0x20000000
	// No effect on output
	PORT1_PCNTR3_PORR13_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR13_1 = 0x1
	// Position of PORR14 field.
	PORT1_PCNTR3_PORR14_Pos = 0x1e
	// Bit mask of PORR14 field.
	PORT1_PCNTR3_PORR14_Msk = 0x40000000
	// Bit PORR14.
	PORT1_PCNTR3_PORR14 = 0x40000000
	// No effect on output
	PORT1_PCNTR3_PORR14_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR14_1 = 0x1
	// Position of PORR15 field.
	PORT1_PCNTR3_PORR15_Pos = 0x1f
	// Bit mask of PORR15 field.
	PORT1_PCNTR3_PORR15_Msk = 0x80000000
	// Bit PORR15.
	PORT1_PCNTR3_PORR15 = 0x80000000
	// No effect on output
	PORT1_PCNTR3_PORR15_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR15_1 = 0x1

	// PORR: Port Control Register 3
	// Position of PORR00 field.
	PORT1_PORR_PORR00_Pos = 0x0
	// Bit mask of PORR00 field.
	PORT1_PORR_PORR00_Msk = 0x1
	// Bit PORR00.
	PORT1_PORR_PORR00 = 0x1
	// No effect on output
	PORT1_PORR_PORR00_0 = 0x0
	// Low output
	PORT1_PORR_PORR00_1 = 0x1
	// Position of PORR01 field.
	PORT1_PORR_PORR01_Pos = 0x1
	// Bit mask of PORR01 field.
	PORT1_PORR_PORR01_Msk = 0x2
	// Bit PORR01.
	PORT1_PORR_PORR01 = 0x2
	// No effect on output
	PORT1_PORR_PORR01_0 = 0x0
	// Low output
	PORT1_PORR_PORR01_1 = 0x1
	// Position of PORR02 field.
	PORT1_PORR_PORR02_Pos = 0x2
	// Bit mask of PORR02 field.
	PORT1_PORR_PORR02_Msk = 0x4
	// Bit PORR02.
	PORT1_PORR_PORR02 = 0x4
	// No effect on output
	PORT1_PORR_PORR02_0 = 0x0
	// Low output
	PORT1_PORR_PORR02_1 = 0x1
	// Position of PORR03 field.
	PORT1_PORR_PORR03_Pos = 0x3
	// Bit mask of PORR03 field.
	PORT1_PORR_PORR03_Msk = 0x8
	// Bit PORR03.
	PORT1_PORR_PORR03 = 0x8
	// No effect on output
	PORT1_PORR_PORR03_0 = 0x0
	// Low output
	PORT1_PORR_PORR03_1 = 0x1
	// Position of PORR04 field.
	PORT1_PORR_PORR04_Pos = 0x4
	// Bit mask of PORR04 field.
	PORT1_PORR_PORR04_Msk = 0x10
	// Bit PORR04.
	PORT1_PORR_PORR04 = 0x10
	// No effect on output
	PORT1_PORR_PORR04_0 = 0x0
	// Low output
	PORT1_PORR_PORR04_1 = 0x1
	// Position of PORR05 field.
	PORT1_PORR_PORR05_Pos = 0x5
	// Bit mask of PORR05 field.
	PORT1_PORR_PORR05_Msk = 0x20
	// Bit PORR05.
	PORT1_PORR_PORR05 = 0x20
	// No effect on output
	PORT1_PORR_PORR05_0 = 0x0
	// Low output
	PORT1_PORR_PORR05_1 = 0x1
	// Position of PORR06 field.
	PORT1_PORR_PORR06_Pos = 0x6
	// Bit mask of PORR06 field.
	PORT1_PORR_PORR06_Msk = 0x40
	// Bit PORR06.
	PORT1_PORR_PORR06 = 0x40
	// No effect on output
	PORT1_PORR_PORR06_0 = 0x0
	// Low output
	PORT1_PORR_PORR06_1 = 0x1
	// Position of PORR07 field.
	PORT1_PORR_PORR07_Pos = 0x7
	// Bit mask of PORR07 field.
	PORT1_PORR_PORR07_Msk = 0x80
	// Bit PORR07.
	PORT1_PORR_PORR07 = 0x80
	// No effect on output
	PORT1_PORR_PORR07_0 = 0x0
	// Low output
	PORT1_PORR_PORR07_1 = 0x1
	// Position of PORR08 field.
	PORT1_PORR_PORR08_Pos = 0x8
	// Bit mask of PORR08 field.
	PORT1_PORR_PORR08_Msk = 0x100
	// Bit PORR08.
	PORT1_PORR_PORR08 = 0x100
	// No effect on output
	PORT1_PORR_PORR08_0 = 0x0
	// Low output
	PORT1_PORR_PORR08_1 = 0x1
	// Position of PORR09 field.
	PORT1_PORR_PORR09_Pos = 0x9
	// Bit mask of PORR09 field.
	PORT1_PORR_PORR09_Msk = 0x200
	// Bit PORR09.
	PORT1_PORR_PORR09 = 0x200
	// No effect on output
	PORT1_PORR_PORR09_0 = 0x0
	// Low output
	PORT1_PORR_PORR09_1 = 0x1
	// Position of PORR10 field.
	PORT1_PORR_PORR10_Pos = 0xa
	// Bit mask of PORR10 field.
	PORT1_PORR_PORR10_Msk = 0x400
	// Bit PORR10.
	PORT1_PORR_PORR10 = 0x400
	// No effect on output
	PORT1_PORR_PORR10_0 = 0x0
	// Low output
	PORT1_PORR_PORR10_1 = 0x1
	// Position of PORR11 field.
	PORT1_PORR_PORR11_Pos = 0xb
	// Bit mask of PORR11 field.
	PORT1_PORR_PORR11_Msk = 0x800
	// Bit PORR11.
	PORT1_PORR_PORR11 = 0x800
	// No effect on output
	PORT1_PORR_PORR11_0 = 0x0
	// Low output
	PORT1_PORR_PORR11_1 = 0x1
	// Position of PORR12 field.
	PORT1_PORR_PORR12_Pos = 0xc
	// Bit mask of PORR12 field.
	PORT1_PORR_PORR12_Msk = 0x1000
	// Bit PORR12.
	PORT1_PORR_PORR12 = 0x1000
	// No effect on output
	PORT1_PORR_PORR12_0 = 0x0
	// Low output
	PORT1_PORR_PORR12_1 = 0x1
	// Position of PORR13 field.
	PORT1_PORR_PORR13_Pos = 0xd
	// Bit mask of PORR13 field.
	PORT1_PORR_PORR13_Msk = 0x2000
	// Bit PORR13.
	PORT1_PORR_PORR13 = 0x2000
	// No effect on output
	PORT1_PORR_PORR13_0 = 0x0
	// Low output
	PORT1_PORR_PORR13_1 = 0x1
	// Position of PORR14 field.
	PORT1_PORR_PORR14_Pos = 0xe
	// Bit mask of PORR14 field.
	PORT1_PORR_PORR14_Msk = 0x4000
	// Bit PORR14.
	PORT1_PORR_PORR14 = 0x4000
	// No effect on output
	PORT1_PORR_PORR14_0 = 0x0
	// Low output
	PORT1_PORR_PORR14_1 = 0x1
	// Position of PORR15 field.
	PORT1_PORR_PORR15_Pos = 0xf
	// Bit mask of PORR15 field.
	PORT1_PORR_PORR15_Msk = 0x8000
	// Bit PORR15.
	PORT1_PORR_PORR15 = 0x8000
	// No effect on output
	PORT1_PORR_PORR15_0 = 0x0
	// Low output
	PORT1_PORR_PORR15_1 = 0x1

	// POSR: Port Control Register 3
	// Position of POSR00 field.
	PORT1_POSR_POSR00_Pos = 0x0
	// Bit mask of POSR00 field.
	PORT1_POSR_POSR00_Msk = 0x1
	// Bit POSR00.
	PORT1_POSR_POSR00 = 0x1
	// No effect on output
	PORT1_POSR_POSR00_0 = 0x0
	// High output
	PORT1_POSR_POSR00_1 = 0x1
	// Position of POSR01 field.
	PORT1_POSR_POSR01_Pos = 0x1
	// Bit mask of POSR01 field.
	PORT1_POSR_POSR01_Msk = 0x2
	// Bit POSR01.
	PORT1_POSR_POSR01 = 0x2
	// No effect on output
	PORT1_POSR_POSR01_0 = 0x0
	// High output
	PORT1_POSR_POSR01_1 = 0x1
	// Position of POSR02 field.
	PORT1_POSR_POSR02_Pos = 0x2
	// Bit mask of POSR02 field.
	PORT1_POSR_POSR02_Msk = 0x4
	// Bit POSR02.
	PORT1_POSR_POSR02 = 0x4
	// No effect on output
	PORT1_POSR_POSR02_0 = 0x0
	// High output
	PORT1_POSR_POSR02_1 = 0x1
	// Position of POSR03 field.
	PORT1_POSR_POSR03_Pos = 0x3
	// Bit mask of POSR03 field.
	PORT1_POSR_POSR03_Msk = 0x8
	// Bit POSR03.
	PORT1_POSR_POSR03 = 0x8
	// No effect on output
	PORT1_POSR_POSR03_0 = 0x0
	// High output
	PORT1_POSR_POSR03_1 = 0x1
	// Position of POSR04 field.
	PORT1_POSR_POSR04_Pos = 0x4
	// Bit mask of POSR04 field.
	PORT1_POSR_POSR04_Msk = 0x10
	// Bit POSR04.
	PORT1_POSR_POSR04 = 0x10
	// No effect on output
	PORT1_POSR_POSR04_0 = 0x0
	// High output
	PORT1_POSR_POSR04_1 = 0x1
	// Position of POSR05 field.
	PORT1_POSR_POSR05_Pos = 0x5
	// Bit mask of POSR05 field.
	PORT1_POSR_POSR05_Msk = 0x20
	// Bit POSR05.
	PORT1_POSR_POSR05 = 0x20
	// No effect on output
	PORT1_POSR_POSR05_0 = 0x0
	// High output
	PORT1_POSR_POSR05_1 = 0x1
	// Position of POSR06 field.
	PORT1_POSR_POSR06_Pos = 0x6
	// Bit mask of POSR06 field.
	PORT1_POSR_POSR06_Msk = 0x40
	// Bit POSR06.
	PORT1_POSR_POSR06 = 0x40
	// No effect on output
	PORT1_POSR_POSR06_0 = 0x0
	// High output
	PORT1_POSR_POSR06_1 = 0x1
	// Position of POSR07 field.
	PORT1_POSR_POSR07_Pos = 0x7
	// Bit mask of POSR07 field.
	PORT1_POSR_POSR07_Msk = 0x80
	// Bit POSR07.
	PORT1_POSR_POSR07 = 0x80
	// No effect on output
	PORT1_POSR_POSR07_0 = 0x0
	// High output
	PORT1_POSR_POSR07_1 = 0x1
	// Position of POSR08 field.
	PORT1_POSR_POSR08_Pos = 0x8
	// Bit mask of POSR08 field.
	PORT1_POSR_POSR08_Msk = 0x100
	// Bit POSR08.
	PORT1_POSR_POSR08 = 0x100
	// No effect on output
	PORT1_POSR_POSR08_0 = 0x0
	// High output
	PORT1_POSR_POSR08_1 = 0x1
	// Position of POSR09 field.
	PORT1_POSR_POSR09_Pos = 0x9
	// Bit mask of POSR09 field.
	PORT1_POSR_POSR09_Msk = 0x200
	// Bit POSR09.
	PORT1_POSR_POSR09 = 0x200
	// No effect on output
	PORT1_POSR_POSR09_0 = 0x0
	// High output
	PORT1_POSR_POSR09_1 = 0x1
	// Position of POSR10 field.
	PORT1_POSR_POSR10_Pos = 0xa
	// Bit mask of POSR10 field.
	PORT1_POSR_POSR10_Msk = 0x400
	// Bit POSR10.
	PORT1_POSR_POSR10 = 0x400
	// No effect on output
	PORT1_POSR_POSR10_0 = 0x0
	// High output
	PORT1_POSR_POSR10_1 = 0x1
	// Position of POSR11 field.
	PORT1_POSR_POSR11_Pos = 0xb
	// Bit mask of POSR11 field.
	PORT1_POSR_POSR11_Msk = 0x800
	// Bit POSR11.
	PORT1_POSR_POSR11 = 0x800
	// No effect on output
	PORT1_POSR_POSR11_0 = 0x0
	// High output
	PORT1_POSR_POSR11_1 = 0x1
	// Position of POSR12 field.
	PORT1_POSR_POSR12_Pos = 0xc
	// Bit mask of POSR12 field.
	PORT1_POSR_POSR12_Msk = 0x1000
	// Bit POSR12.
	PORT1_POSR_POSR12 = 0x1000
	// No effect on output
	PORT1_POSR_POSR12_0 = 0x0
	// High output
	PORT1_POSR_POSR12_1 = 0x1
	// Position of POSR13 field.
	PORT1_POSR_POSR13_Pos = 0xd
	// Bit mask of POSR13 field.
	PORT1_POSR_POSR13_Msk = 0x2000
	// Bit POSR13.
	PORT1_POSR_POSR13 = 0x2000
	// No effect on output
	PORT1_POSR_POSR13_0 = 0x0
	// High output
	PORT1_POSR_POSR13_1 = 0x1
	// Position of POSR14 field.
	PORT1_POSR_POSR14_Pos = 0xe
	// Bit mask of POSR14 field.
	PORT1_POSR_POSR14_Msk = 0x4000
	// Bit POSR14.
	PORT1_POSR_POSR14 = 0x4000
	// No effect on output
	PORT1_POSR_POSR14_0 = 0x0
	// High output
	PORT1_POSR_POSR14_1 = 0x1
	// Position of POSR15 field.
	PORT1_POSR_POSR15_Pos = 0xf
	// Bit mask of POSR15 field.
	PORT1_POSR_POSR15_Msk = 0x8000
	// Bit POSR15.
	PORT1_POSR_POSR15 = 0x8000
	// No effect on output
	PORT1_POSR_POSR15_0 = 0x0
	// High output
	PORT1_POSR_POSR15_1 = 0x1

	// PCNTR4: Port Control Register 4
	// Position of EOSR00 field.
	PORT1_PCNTR4_EOSR00_Pos = 0x0
	// Bit mask of EOSR00 field.
	PORT1_PCNTR4_EOSR00_Msk = 0x1
	// Bit EOSR00.
	PORT1_PCNTR4_EOSR00 = 0x1
	// No effect on output
	PORT1_PCNTR4_EOSR00_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR00_1 = 0x1
	// Position of EOSR01 field.
	PORT1_PCNTR4_EOSR01_Pos = 0x1
	// Bit mask of EOSR01 field.
	PORT1_PCNTR4_EOSR01_Msk = 0x2
	// Bit EOSR01.
	PORT1_PCNTR4_EOSR01 = 0x2
	// No effect on output
	PORT1_PCNTR4_EOSR01_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR01_1 = 0x1
	// Position of EOSR02 field.
	PORT1_PCNTR4_EOSR02_Pos = 0x2
	// Bit mask of EOSR02 field.
	PORT1_PCNTR4_EOSR02_Msk = 0x4
	// Bit EOSR02.
	PORT1_PCNTR4_EOSR02 = 0x4
	// No effect on output
	PORT1_PCNTR4_EOSR02_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR02_1 = 0x1
	// Position of EOSR03 field.
	PORT1_PCNTR4_EOSR03_Pos = 0x3
	// Bit mask of EOSR03 field.
	PORT1_PCNTR4_EOSR03_Msk = 0x8
	// Bit EOSR03.
	PORT1_PCNTR4_EOSR03 = 0x8
	// No effect on output
	PORT1_PCNTR4_EOSR03_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR03_1 = 0x1
	// Position of EOSR04 field.
	PORT1_PCNTR4_EOSR04_Pos = 0x4
	// Bit mask of EOSR04 field.
	PORT1_PCNTR4_EOSR04_Msk = 0x10
	// Bit EOSR04.
	PORT1_PCNTR4_EOSR04 = 0x10
	// No effect on output
	PORT1_PCNTR4_EOSR04_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR04_1 = 0x1
	// Position of EOSR05 field.
	PORT1_PCNTR4_EOSR05_Pos = 0x5
	// Bit mask of EOSR05 field.
	PORT1_PCNTR4_EOSR05_Msk = 0x20
	// Bit EOSR05.
	PORT1_PCNTR4_EOSR05 = 0x20
	// No effect on output
	PORT1_PCNTR4_EOSR05_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR05_1 = 0x1
	// Position of EOSR06 field.
	PORT1_PCNTR4_EOSR06_Pos = 0x6
	// Bit mask of EOSR06 field.
	PORT1_PCNTR4_EOSR06_Msk = 0x40
	// Bit EOSR06.
	PORT1_PCNTR4_EOSR06 = 0x40
	// No effect on output
	PORT1_PCNTR4_EOSR06_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR06_1 = 0x1
	// Position of EOSR07 field.
	PORT1_PCNTR4_EOSR07_Pos = 0x7
	// Bit mask of EOSR07 field.
	PORT1_PCNTR4_EOSR07_Msk = 0x80
	// Bit EOSR07.
	PORT1_PCNTR4_EOSR07 = 0x80
	// No effect on output
	PORT1_PCNTR4_EOSR07_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR07_1 = 0x1
	// Position of EOSR08 field.
	PORT1_PCNTR4_EOSR08_Pos = 0x8
	// Bit mask of EOSR08 field.
	PORT1_PCNTR4_EOSR08_Msk = 0x100
	// Bit EOSR08.
	PORT1_PCNTR4_EOSR08 = 0x100
	// No effect on output
	PORT1_PCNTR4_EOSR08_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR08_1 = 0x1
	// Position of EOSR09 field.
	PORT1_PCNTR4_EOSR09_Pos = 0x9
	// Bit mask of EOSR09 field.
	PORT1_PCNTR4_EOSR09_Msk = 0x200
	// Bit EOSR09.
	PORT1_PCNTR4_EOSR09 = 0x200
	// No effect on output
	PORT1_PCNTR4_EOSR09_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR09_1 = 0x1
	// Position of EOSR10 field.
	PORT1_PCNTR4_EOSR10_Pos = 0xa
	// Bit mask of EOSR10 field.
	PORT1_PCNTR4_EOSR10_Msk = 0x400
	// Bit EOSR10.
	PORT1_PCNTR4_EOSR10 = 0x400
	// No effect on output
	PORT1_PCNTR4_EOSR10_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR10_1 = 0x1
	// Position of EOSR11 field.
	PORT1_PCNTR4_EOSR11_Pos = 0xb
	// Bit mask of EOSR11 field.
	PORT1_PCNTR4_EOSR11_Msk = 0x800
	// Bit EOSR11.
	PORT1_PCNTR4_EOSR11 = 0x800
	// No effect on output
	PORT1_PCNTR4_EOSR11_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR11_1 = 0x1
	// Position of EOSR12 field.
	PORT1_PCNTR4_EOSR12_Pos = 0xc
	// Bit mask of EOSR12 field.
	PORT1_PCNTR4_EOSR12_Msk = 0x1000
	// Bit EOSR12.
	PORT1_PCNTR4_EOSR12 = 0x1000
	// No effect on output
	PORT1_PCNTR4_EOSR12_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR12_1 = 0x1
	// Position of EOSR13 field.
	PORT1_PCNTR4_EOSR13_Pos = 0xd
	// Bit mask of EOSR13 field.
	PORT1_PCNTR4_EOSR13_Msk = 0x2000
	// Bit EOSR13.
	PORT1_PCNTR4_EOSR13 = 0x2000
	// No effect on output
	PORT1_PCNTR4_EOSR13_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR13_1 = 0x1
	// Position of EOSR14 field.
	PORT1_PCNTR4_EOSR14_Pos = 0xe
	// Bit mask of EOSR14 field.
	PORT1_PCNTR4_EOSR14_Msk = 0x4000
	// Bit EOSR14.
	PORT1_PCNTR4_EOSR14 = 0x4000
	// No effect on output
	PORT1_PCNTR4_EOSR14_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR14_1 = 0x1
	// Position of EOSR15 field.
	PORT1_PCNTR4_EOSR15_Pos = 0xf
	// Bit mask of EOSR15 field.
	PORT1_PCNTR4_EOSR15_Msk = 0x8000
	// Bit EOSR15.
	PORT1_PCNTR4_EOSR15 = 0x8000
	// No effect on output
	PORT1_PCNTR4_EOSR15_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR15_1 = 0x1
	// Position of EORR00 field.
	PORT1_PCNTR4_EORR00_Pos = 0x10
	// Bit mask of EORR00 field.
	PORT1_PCNTR4_EORR00_Msk = 0x10000
	// Bit EORR00.
	PORT1_PCNTR4_EORR00 = 0x10000
	// No effect on output
	PORT1_PCNTR4_EORR00_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR00_1 = 0x1
	// Position of EORR01 field.
	PORT1_PCNTR4_EORR01_Pos = 0x11
	// Bit mask of EORR01 field.
	PORT1_PCNTR4_EORR01_Msk = 0x20000
	// Bit EORR01.
	PORT1_PCNTR4_EORR01 = 0x20000
	// No effect on output
	PORT1_PCNTR4_EORR01_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR01_1 = 0x1
	// Position of EORR02 field.
	PORT1_PCNTR4_EORR02_Pos = 0x12
	// Bit mask of EORR02 field.
	PORT1_PCNTR4_EORR02_Msk = 0x40000
	// Bit EORR02.
	PORT1_PCNTR4_EORR02 = 0x40000
	// No effect on output
	PORT1_PCNTR4_EORR02_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR02_1 = 0x1
	// Position of EORR03 field.
	PORT1_PCNTR4_EORR03_Pos = 0x13
	// Bit mask of EORR03 field.
	PORT1_PCNTR4_EORR03_Msk = 0x80000
	// Bit EORR03.
	PORT1_PCNTR4_EORR03 = 0x80000
	// No effect on output
	PORT1_PCNTR4_EORR03_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR03_1 = 0x1
	// Position of EORR04 field.
	PORT1_PCNTR4_EORR04_Pos = 0x14
	// Bit mask of EORR04 field.
	PORT1_PCNTR4_EORR04_Msk = 0x100000
	// Bit EORR04.
	PORT1_PCNTR4_EORR04 = 0x100000
	// No effect on output
	PORT1_PCNTR4_EORR04_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR04_1 = 0x1
	// Position of EORR05 field.
	PORT1_PCNTR4_EORR05_Pos = 0x15
	// Bit mask of EORR05 field.
	PORT1_PCNTR4_EORR05_Msk = 0x200000
	// Bit EORR05.
	PORT1_PCNTR4_EORR05 = 0x200000
	// No effect on output
	PORT1_PCNTR4_EORR05_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR05_1 = 0x1
	// Position of EORR06 field.
	PORT1_PCNTR4_EORR06_Pos = 0x16
	// Bit mask of EORR06 field.
	PORT1_PCNTR4_EORR06_Msk = 0x400000
	// Bit EORR06.
	PORT1_PCNTR4_EORR06 = 0x400000
	// No effect on output
	PORT1_PCNTR4_EORR06_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR06_1 = 0x1
	// Position of EORR07 field.
	PORT1_PCNTR4_EORR07_Pos = 0x17
	// Bit mask of EORR07 field.
	PORT1_PCNTR4_EORR07_Msk = 0x800000
	// Bit EORR07.
	PORT1_PCNTR4_EORR07 = 0x800000
	// No effect on output
	PORT1_PCNTR4_EORR07_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR07_1 = 0x1
	// Position of EORR08 field.
	PORT1_PCNTR4_EORR08_Pos = 0x18
	// Bit mask of EORR08 field.
	PORT1_PCNTR4_EORR08_Msk = 0x1000000
	// Bit EORR08.
	PORT1_PCNTR4_EORR08 = 0x1000000
	// No effect on output
	PORT1_PCNTR4_EORR08_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR08_1 = 0x1
	// Position of EORR09 field.
	PORT1_PCNTR4_EORR09_Pos = 0x19
	// Bit mask of EORR09 field.
	PORT1_PCNTR4_EORR09_Msk = 0x2000000
	// Bit EORR09.
	PORT1_PCNTR4_EORR09 = 0x2000000
	// No effect on output
	PORT1_PCNTR4_EORR09_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR09_1 = 0x1
	// Position of EORR10 field.
	PORT1_PCNTR4_EORR10_Pos = 0x1a
	// Bit mask of EORR10 field.
	PORT1_PCNTR4_EORR10_Msk = 0x4000000
	// Bit EORR10.
	PORT1_PCNTR4_EORR10 = 0x4000000
	// No effect on output
	PORT1_PCNTR4_EORR10_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR10_1 = 0x1
	// Position of EORR11 field.
	PORT1_PCNTR4_EORR11_Pos = 0x1b
	// Bit mask of EORR11 field.
	PORT1_PCNTR4_EORR11_Msk = 0x8000000
	// Bit EORR11.
	PORT1_PCNTR4_EORR11 = 0x8000000
	// No effect on output
	PORT1_PCNTR4_EORR11_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR11_1 = 0x1
	// Position of EORR12 field.
	PORT1_PCNTR4_EORR12_Pos = 0x1c
	// Bit mask of EORR12 field.
	PORT1_PCNTR4_EORR12_Msk = 0x10000000
	// Bit EORR12.
	PORT1_PCNTR4_EORR12 = 0x10000000
	// No effect on output
	PORT1_PCNTR4_EORR12_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR12_1 = 0x1
	// Position of EORR13 field.
	PORT1_PCNTR4_EORR13_Pos = 0x1d
	// Bit mask of EORR13 field.
	PORT1_PCNTR4_EORR13_Msk = 0x20000000
	// Bit EORR13.
	PORT1_PCNTR4_EORR13 = 0x20000000
	// No effect on output
	PORT1_PCNTR4_EORR13_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR13_1 = 0x1
	// Position of EORR14 field.
	PORT1_PCNTR4_EORR14_Pos = 0x1e
	// Bit mask of EORR14 field.
	PORT1_PCNTR4_EORR14_Msk = 0x40000000
	// Bit EORR14.
	PORT1_PCNTR4_EORR14 = 0x40000000
	// No effect on output
	PORT1_PCNTR4_EORR14_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR14_1 = 0x1
	// Position of EORR15 field.
	PORT1_PCNTR4_EORR15_Pos = 0x1f
	// Bit mask of EORR15 field.
	PORT1_PCNTR4_EORR15_Msk = 0x80000000
	// Bit EORR15.
	PORT1_PCNTR4_EORR15 = 0x80000000
	// No effect on output
	PORT1_PCNTR4_EORR15_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR15_1 = 0x1

	// EORR: Port Control Register 4
	// Position of EORR00 field.
	PORT1_EORR_EORR00_Pos = 0x0
	// Bit mask of EORR00 field.
	PORT1_EORR_EORR00_Msk = 0x1
	// Bit EORR00.
	PORT1_EORR_EORR00 = 0x1
	// No effect on output
	PORT1_EORR_EORR00_0 = 0x0
	// Low output
	PORT1_EORR_EORR00_1 = 0x1
	// Position of EORR01 field.
	PORT1_EORR_EORR01_Pos = 0x1
	// Bit mask of EORR01 field.
	PORT1_EORR_EORR01_Msk = 0x2
	// Bit EORR01.
	PORT1_EORR_EORR01 = 0x2
	// No effect on output
	PORT1_EORR_EORR01_0 = 0x0
	// Low output
	PORT1_EORR_EORR01_1 = 0x1
	// Position of EORR02 field.
	PORT1_EORR_EORR02_Pos = 0x2
	// Bit mask of EORR02 field.
	PORT1_EORR_EORR02_Msk = 0x4
	// Bit EORR02.
	PORT1_EORR_EORR02 = 0x4
	// No effect on output
	PORT1_EORR_EORR02_0 = 0x0
	// Low output
	PORT1_EORR_EORR02_1 = 0x1
	// Position of EORR03 field.
	PORT1_EORR_EORR03_Pos = 0x3
	// Bit mask of EORR03 field.
	PORT1_EORR_EORR03_Msk = 0x8
	// Bit EORR03.
	PORT1_EORR_EORR03 = 0x8
	// No effect on output
	PORT1_EORR_EORR03_0 = 0x0
	// Low output
	PORT1_EORR_EORR03_1 = 0x1
	// Position of EORR04 field.
	PORT1_EORR_EORR04_Pos = 0x4
	// Bit mask of EORR04 field.
	PORT1_EORR_EORR04_Msk = 0x10
	// Bit EORR04.
	PORT1_EORR_EORR04 = 0x10
	// No effect on output
	PORT1_EORR_EORR04_0 = 0x0
	// Low output
	PORT1_EORR_EORR04_1 = 0x1
	// Position of EORR05 field.
	PORT1_EORR_EORR05_Pos = 0x5
	// Bit mask of EORR05 field.
	PORT1_EORR_EORR05_Msk = 0x20
	// Bit EORR05.
	PORT1_EORR_EORR05 = 0x20
	// No effect on output
	PORT1_EORR_EORR05_0 = 0x0
	// Low output
	PORT1_EORR_EORR05_1 = 0x1
	// Position of EORR06 field.
	PORT1_EORR_EORR06_Pos = 0x6
	// Bit mask of EORR06 field.
	PORT1_EORR_EORR06_Msk = 0x40
	// Bit EORR06.
	PORT1_EORR_EORR06 = 0x40
	// No effect on output
	PORT1_EORR_EORR06_0 = 0x0
	// Low output
	PORT1_EORR_EORR06_1 = 0x1
	// Position of EORR07 field.
	PORT1_EORR_EORR07_Pos = 0x7
	// Bit mask of EORR07 field.
	PORT1_EORR_EORR07_Msk = 0x80
	// Bit EORR07.
	PORT1_EORR_EORR07 = 0x80
	// No effect on output
	PORT1_EORR_EORR07_0 = 0x0
	// Low output
	PORT1_EORR_EORR07_1 = 0x1
	// Position of EORR08 field.
	PORT1_EORR_EORR08_Pos = 0x8
	// Bit mask of EORR08 field.
	PORT1_EORR_EORR08_Msk = 0x100
	// Bit EORR08.
	PORT1_EORR_EORR08 = 0x100
	// No effect on output
	PORT1_EORR_EORR08_0 = 0x0
	// Low output
	PORT1_EORR_EORR08_1 = 0x1
	// Position of EORR09 field.
	PORT1_EORR_EORR09_Pos = 0x9
	// Bit mask of EORR09 field.
	PORT1_EORR_EORR09_Msk = 0x200
	// Bit EORR09.
	PORT1_EORR_EORR09 = 0x200
	// No effect on output
	PORT1_EORR_EORR09_0 = 0x0
	// Low output
	PORT1_EORR_EORR09_1 = 0x1
	// Position of EORR10 field.
	PORT1_EORR_EORR10_Pos = 0xa
	// Bit mask of EORR10 field.
	PORT1_EORR_EORR10_Msk = 0x400
	// Bit EORR10.
	PORT1_EORR_EORR10 = 0x400
	// No effect on output
	PORT1_EORR_EORR10_0 = 0x0
	// Low output
	PORT1_EORR_EORR10_1 = 0x1
	// Position of EORR11 field.
	PORT1_EORR_EORR11_Pos = 0xb
	// Bit mask of EORR11 field.
	PORT1_EORR_EORR11_Msk = 0x800
	// Bit EORR11.
	PORT1_EORR_EORR11 = 0x800
	// No effect on output
	PORT1_EORR_EORR11_0 = 0x0
	// Low output
	PORT1_EORR_EORR11_1 = 0x1
	// Position of EORR12 field.
	PORT1_EORR_EORR12_Pos = 0xc
	// Bit mask of EORR12 field.
	PORT1_EORR_EORR12_Msk = 0x1000
	// Bit EORR12.
	PORT1_EORR_EORR12 = 0x1000
	// No effect on output
	PORT1_EORR_EORR12_0 = 0x0
	// Low output
	PORT1_EORR_EORR12_1 = 0x1
	// Position of EORR13 field.
	PORT1_EORR_EORR13_Pos = 0xd
	// Bit mask of EORR13 field.
	PORT1_EORR_EORR13_Msk = 0x2000
	// Bit EORR13.
	PORT1_EORR_EORR13 = 0x2000
	// No effect on output
	PORT1_EORR_EORR13_0 = 0x0
	// Low output
	PORT1_EORR_EORR13_1 = 0x1
	// Position of EORR14 field.
	PORT1_EORR_EORR14_Pos = 0xe
	// Bit mask of EORR14 field.
	PORT1_EORR_EORR14_Msk = 0x4000
	// Bit EORR14.
	PORT1_EORR_EORR14 = 0x4000
	// No effect on output
	PORT1_EORR_EORR14_0 = 0x0
	// Low output
	PORT1_EORR_EORR14_1 = 0x1
	// Position of EORR15 field.
	PORT1_EORR_EORR15_Pos = 0xf
	// Bit mask of EORR15 field.
	PORT1_EORR_EORR15_Msk = 0x8000
	// Bit EORR15.
	PORT1_EORR_EORR15 = 0x8000
	// No effect on output
	PORT1_EORR_EORR15_0 = 0x0
	// Low output
	PORT1_EORR_EORR15_1 = 0x1

	// EOSR: Port Control Register 4
	// Position of EOSR00 field.
	PORT1_EOSR_EOSR00_Pos = 0x0
	// Bit mask of EOSR00 field.
	PORT1_EOSR_EOSR00_Msk = 0x1
	// Bit EOSR00.
	PORT1_EOSR_EOSR00 = 0x1
	// No effect on output
	PORT1_EOSR_EOSR00_0 = 0x0
	// High output
	PORT1_EOSR_EOSR00_1 = 0x1
	// Position of EOSR01 field.
	PORT1_EOSR_EOSR01_Pos = 0x1
	// Bit mask of EOSR01 field.
	PORT1_EOSR_EOSR01_Msk = 0x2
	// Bit EOSR01.
	PORT1_EOSR_EOSR01 = 0x2
	// No effect on output
	PORT1_EOSR_EOSR01_0 = 0x0
	// High output
	PORT1_EOSR_EOSR01_1 = 0x1
	// Position of EOSR02 field.
	PORT1_EOSR_EOSR02_Pos = 0x2
	// Bit mask of EOSR02 field.
	PORT1_EOSR_EOSR02_Msk = 0x4
	// Bit EOSR02.
	PORT1_EOSR_EOSR02 = 0x4
	// No effect on output
	PORT1_EOSR_EOSR02_0 = 0x0
	// High output
	PORT1_EOSR_EOSR02_1 = 0x1
	// Position of EOSR03 field.
	PORT1_EOSR_EOSR03_Pos = 0x3
	// Bit mask of EOSR03 field.
	PORT1_EOSR_EOSR03_Msk = 0x8
	// Bit EOSR03.
	PORT1_EOSR_EOSR03 = 0x8
	// No effect on output
	PORT1_EOSR_EOSR03_0 = 0x0
	// High output
	PORT1_EOSR_EOSR03_1 = 0x1
	// Position of EOSR04 field.
	PORT1_EOSR_EOSR04_Pos = 0x4
	// Bit mask of EOSR04 field.
	PORT1_EOSR_EOSR04_Msk = 0x10
	// Bit EOSR04.
	PORT1_EOSR_EOSR04 = 0x10
	// No effect on output
	PORT1_EOSR_EOSR04_0 = 0x0
	// High output
	PORT1_EOSR_EOSR04_1 = 0x1
	// Position of EOSR05 field.
	PORT1_EOSR_EOSR05_Pos = 0x5
	// Bit mask of EOSR05 field.
	PORT1_EOSR_EOSR05_Msk = 0x20
	// Bit EOSR05.
	PORT1_EOSR_EOSR05 = 0x20
	// No effect on output
	PORT1_EOSR_EOSR05_0 = 0x0
	// High output
	PORT1_EOSR_EOSR05_1 = 0x1
	// Position of EOSR06 field.
	PORT1_EOSR_EOSR06_Pos = 0x6
	// Bit mask of EOSR06 field.
	PORT1_EOSR_EOSR06_Msk = 0x40
	// Bit EOSR06.
	PORT1_EOSR_EOSR06 = 0x40
	// No effect on output
	PORT1_EOSR_EOSR06_0 = 0x0
	// High output
	PORT1_EOSR_EOSR06_1 = 0x1
	// Position of EOSR07 field.
	PORT1_EOSR_EOSR07_Pos = 0x7
	// Bit mask of EOSR07 field.
	PORT1_EOSR_EOSR07_Msk = 0x80
	// Bit EOSR07.
	PORT1_EOSR_EOSR07 = 0x80
	// No effect on output
	PORT1_EOSR_EOSR07_0 = 0x0
	// High output
	PORT1_EOSR_EOSR07_1 = 0x1
	// Position of EOSR08 field.
	PORT1_EOSR_EOSR08_Pos = 0x8
	// Bit mask of EOSR08 field.
	PORT1_EOSR_EOSR08_Msk = 0x100
	// Bit EOSR08.
	PORT1_EOSR_EOSR08 = 0x100
	// No effect on output
	PORT1_EOSR_EOSR08_0 = 0x0
	// High output
	PORT1_EOSR_EOSR08_1 = 0x1
	// Position of EOSR09 field.
	PORT1_EOSR_EOSR09_Pos = 0x9
	// Bit mask of EOSR09 field.
	PORT1_EOSR_EOSR09_Msk = 0x200
	// Bit EOSR09.
	PORT1_EOSR_EOSR09 = 0x200
	// No effect on output
	PORT1_EOSR_EOSR09_0 = 0x0
	// High output
	PORT1_EOSR_EOSR09_1 = 0x1
	// Position of EOSR10 field.
	PORT1_EOSR_EOSR10_Pos = 0xa
	// Bit mask of EOSR10 field.
	PORT1_EOSR_EOSR10_Msk = 0x400
	// Bit EOSR10.
	PORT1_EOSR_EOSR10 = 0x400
	// No effect on output
	PORT1_EOSR_EOSR10_0 = 0x0
	// High output
	PORT1_EOSR_EOSR10_1 = 0x1
	// Position of EOSR11 field.
	PORT1_EOSR_EOSR11_Pos = 0xb
	// Bit mask of EOSR11 field.
	PORT1_EOSR_EOSR11_Msk = 0x800
	// Bit EOSR11.
	PORT1_EOSR_EOSR11 = 0x800
	// No effect on output
	PORT1_EOSR_EOSR11_0 = 0x0
	// High output
	PORT1_EOSR_EOSR11_1 = 0x1
	// Position of EOSR12 field.
	PORT1_EOSR_EOSR12_Pos = 0xc
	// Bit mask of EOSR12 field.
	PORT1_EOSR_EOSR12_Msk = 0x1000
	// Bit EOSR12.
	PORT1_EOSR_EOSR12 = 0x1000
	// No effect on output
	PORT1_EOSR_EOSR12_0 = 0x0
	// High output
	PORT1_EOSR_EOSR12_1 = 0x1
	// Position of EOSR13 field.
	PORT1_EOSR_EOSR13_Pos = 0xd
	// Bit mask of EOSR13 field.
	PORT1_EOSR_EOSR13_Msk = 0x2000
	// Bit EOSR13.
	PORT1_EOSR_EOSR13 = 0x2000
	// No effect on output
	PORT1_EOSR_EOSR13_0 = 0x0
	// High output
	PORT1_EOSR_EOSR13_1 = 0x1
	// Position of EOSR14 field.
	PORT1_EOSR_EOSR14_Pos = 0xe
	// Bit mask of EOSR14 field.
	PORT1_EOSR_EOSR14_Msk = 0x4000
	// Bit EOSR14.
	PORT1_EOSR_EOSR14 = 0x4000
	// No effect on output
	PORT1_EOSR_EOSR14_0 = 0x0
	// High output
	PORT1_EOSR_EOSR14_1 = 0x1
	// Position of EOSR15 field.
	PORT1_EOSR_EOSR15_Pos = 0xf
	// Bit mask of EOSR15 field.
	PORT1_EOSR_EOSR15_Msk = 0x8000
	// Bit EOSR15.
	PORT1_EOSR_EOSR15 = 0x8000
	// No effect on output
	PORT1_EOSR_EOSR15_0 = 0x0
	// High output
	PORT1_EOSR_EOSR15_1 = 0x1
)

// Constants for PFS: Pmn Pin Function Control Register
const (
	// P000PFS: Port 00%s Pin Function Select Register
	// Position of PODR field.
	PFS_P00PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P00PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P00PFS_PODR = 0x1
	// Output low
	PFS_P00PFS_PODR_0 = 0x0
	// Output high
	PFS_P00PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P00PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P00PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P00PFS_PIDR = 0x2
	// Low level
	PFS_P00PFS_PIDR_0 = 0x0
	// High level
	PFS_P00PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P00PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P00PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P00PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P00PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P00PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P00PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P00PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P00PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P00PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P00PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P00PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P00PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P00PFS_NCODR = 0x40
	// Output CMOS
	PFS_P00PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P00PFS_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P00PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P00PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P00PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P00PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P00PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P00PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P00PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P00PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P00PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P00PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P00PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P00PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P00PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P00PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P00PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P00PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P00PFS_PSEL_Msk = 0x1f000000

	// P000PFS_HA: Port 00%s Pin Function Select Register
	// Position of PODR field.
	PFS_P00PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P00PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P00PFS_HA_PODR = 0x1
	// Output low
	PFS_P00PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P00PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P00PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P00PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P00PFS_HA_PIDR = 0x2
	// Low level
	PFS_P00PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P00PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P00PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P00PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P00PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P00PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P00PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P00PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P00PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P00PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P00PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P00PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P00PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P00PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P00PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P00PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P00PFS_HA_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P00PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P00PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P00PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P00PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P00PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P00PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P00PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P00PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P00PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P00PFS_HA_ASEL_1 = 0x1

	// P000PFS_BY: Port 00%s Pin Function Select Register
	// Position of PODR field.
	PFS_P00PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P00PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P00PFS_BY_PODR = 0x1
	// Output low
	PFS_P00PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P00PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P00PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P00PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P00PFS_BY_PIDR = 0x2
	// Low level
	PFS_P00PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P00PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P00PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P00PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P00PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P00PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P00PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P00PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P00PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P00PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P00PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P00PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P00PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P00PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P00PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P00PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P00PFS_BY_NCODR_1 = 0x1

	// P010PFS: Port 0%s Pin Function Select Register
	// Position of PODR field.
	PFS_P0PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P0PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P0PFS_PODR = 0x1
	// Output low
	PFS_P0PFS_PODR_0 = 0x0
	// Output high
	PFS_P0PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P0PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P0PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P0PFS_PIDR = 0x2
	// Low level
	PFS_P0PFS_PIDR_0 = 0x0
	// High level
	PFS_P0PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P0PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P0PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P0PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P0PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P0PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P0PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P0PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P0PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P0PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P0PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P0PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P0PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P0PFS_NCODR = 0x40
	// Output CMOS
	PFS_P0PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P0PFS_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P0PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P0PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P0PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P0PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P0PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P0PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P0PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P0PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P0PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P0PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P0PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P0PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P0PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P0PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P0PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P0PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P0PFS_PSEL_Msk = 0x1f000000

	// P010PFS_HA: Port 0%s Pin Function Select Register
	// Position of PODR field.
	PFS_P0PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P0PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P0PFS_HA_PODR = 0x1
	// Output low
	PFS_P0PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P0PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P0PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P0PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P0PFS_HA_PIDR = 0x2
	// Low level
	PFS_P0PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P0PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P0PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P0PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P0PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P0PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P0PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P0PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P0PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P0PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P0PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P0PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P0PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P0PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P0PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P0PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P0PFS_HA_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P0PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P0PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P0PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P0PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P0PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P0PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P0PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P0PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P0PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P0PFS_HA_ASEL_1 = 0x1

	// P010PFS_BY: Port 0%s Pin Function Select Register
	// Position of PODR field.
	PFS_P0PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P0PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P0PFS_BY_PODR = 0x1
	// Output low
	PFS_P0PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P0PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P0PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P0PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P0PFS_BY_PIDR = 0x2
	// Low level
	PFS_P0PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P0PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P0PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P0PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P0PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P0PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P0PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P0PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P0PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P0PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P0PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P0PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P0PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P0PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P0PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P0PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P0PFS_BY_NCODR_1 = 0x1

	// P100PFS: Port 10%s Pin Function Select Register
	// Position of PODR field.
	PFS_P10PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P10PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P10PFS_PODR = 0x1
	// Output low
	PFS_P10PFS_PODR_0 = 0x0
	// Output high
	PFS_P10PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P10PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P10PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P10PFS_PIDR = 0x2
	// Low level
	PFS_P10PFS_PIDR_0 = 0x0
	// High level
	PFS_P10PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P10PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P10PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P10PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P10PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P10PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P10PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P10PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P10PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P10PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P10PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P10PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P10PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P10PFS_NCODR = 0x40
	// Output CMOS
	PFS_P10PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P10PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P10PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P10PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P10PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P10PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P10PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P10PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P10PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P10PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P10PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P10PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P10PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P10PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P10PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P10PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P10PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P10PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P10PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P10PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P10PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P10PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P10PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P10PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P10PFS_PSEL_Msk = 0x1f000000

	// P100PFS_HA: Port 10%s Pin Function Select Register
	// Position of PODR field.
	PFS_P10PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P10PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P10PFS_HA_PODR = 0x1
	// Output low
	PFS_P10PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P10PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P10PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P10PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P10PFS_HA_PIDR = 0x2
	// Low level
	PFS_P10PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P10PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P10PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P10PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P10PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P10PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P10PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P10PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P10PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P10PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P10PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P10PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P10PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P10PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P10PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P10PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P10PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P10PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P10PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P10PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P10PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P10PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P10PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P10PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P10PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P10PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P10PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P10PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P10PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P10PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P10PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P10PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P10PFS_HA_ASEL_1 = 0x1

	// P100PFS_BY: Port 10%s Pin Function Select Register
	// Position of PODR field.
	PFS_P10PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P10PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P10PFS_BY_PODR = 0x1
	// Output low
	PFS_P10PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P10PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P10PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P10PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P10PFS_BY_PIDR = 0x2
	// Low level
	PFS_P10PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P10PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P10PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P10PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P10PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P10PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P10PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P10PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P10PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P10PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P10PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P10PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P10PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P10PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P10PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P10PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P10PFS_BY_NCODR_1 = 0x1

	// P108PFS: Port 108 Pin Function Select Register
	// Position of PODR field.
	PFS_P108PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P108PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P108PFS_PODR = 0x1
	// Output low
	PFS_P108PFS_PODR_0 = 0x0
	// Output high
	PFS_P108PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P108PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P108PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P108PFS_PIDR = 0x2
	// Low level
	PFS_P108PFS_PIDR_0 = 0x0
	// High level
	PFS_P108PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P108PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P108PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P108PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P108PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P108PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P108PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P108PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P108PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P108PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P108PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P108PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P108PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P108PFS_NCODR = 0x40
	// Output CMOS
	PFS_P108PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P108PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P108PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P108PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P108PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P108PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P108PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P108PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P108PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P108PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P108PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P108PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P108PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P108PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P108PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P108PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P108PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P108PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P108PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P108PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P108PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P108PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P108PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P108PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P108PFS_PSEL_Msk = 0x1f000000

	// P108PFS_HA: Port 108 Pin Function Select Register
	// Position of PODR field.
	PFS_P108PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P108PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P108PFS_HA_PODR = 0x1
	// Output low
	PFS_P108PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P108PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P108PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P108PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P108PFS_HA_PIDR = 0x2
	// Low level
	PFS_P108PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P108PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P108PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P108PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P108PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P108PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P108PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P108PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P108PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P108PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P108PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P108PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P108PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P108PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P108PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P108PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P108PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P108PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P108PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P108PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P108PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P108PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P108PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P108PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P108PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P108PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P108PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P108PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P108PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P108PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P108PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P108PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P108PFS_HA_ASEL_1 = 0x1

	// P108PFS_BY: Port 108 Pin Function Select Register
	// Position of PODR field.
	PFS_P108PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P108PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P108PFS_BY_PODR = 0x1
	// Output low
	PFS_P108PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P108PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P108PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P108PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P108PFS_BY_PIDR = 0x2
	// Low level
	PFS_P108PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P108PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P108PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P108PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P108PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P108PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P108PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P108PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P108PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P108PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P108PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P108PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P108PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P108PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P108PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P108PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P108PFS_BY_NCODR_1 = 0x1

	// P109PFS: Port 109 Pin Function Select Register
	// Position of PODR field.
	PFS_P109PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P109PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P109PFS_PODR = 0x1
	// Output low
	PFS_P109PFS_PODR_0 = 0x0
	// Output high
	PFS_P109PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P109PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P109PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P109PFS_PIDR = 0x2
	// Low level
	PFS_P109PFS_PIDR_0 = 0x0
	// High level
	PFS_P109PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P109PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P109PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P109PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P109PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P109PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P109PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P109PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P109PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P109PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P109PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P109PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P109PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P109PFS_NCODR = 0x40
	// Output CMOS
	PFS_P109PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P109PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P109PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P109PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P109PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P109PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P109PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P109PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P109PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P109PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P109PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P109PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P109PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P109PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P109PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P109PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P109PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P109PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P109PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P109PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P109PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P109PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P109PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P109PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P109PFS_PSEL_Msk = 0x1f000000

	// P109PFS_HA: Port 109 Pin Function Select Register
	// Position of PODR field.
	PFS_P109PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P109PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P109PFS_HA_PODR = 0x1
	// Output low
	PFS_P109PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P109PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P109PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P109PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P109PFS_HA_PIDR = 0x2
	// Low level
	PFS_P109PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P109PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P109PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P109PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P109PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P109PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P109PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P109PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P109PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P109PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P109PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P109PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P109PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P109PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P109PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P109PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P109PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P109PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P109PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P109PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P109PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P109PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P109PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P109PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P109PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P109PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P109PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P109PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P109PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P109PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P109PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P109PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P109PFS_HA_ASEL_1 = 0x1

	// P109PFS_BY: Port 109 Pin Function Select Register
	// Position of PODR field.
	PFS_P109PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P109PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P109PFS_BY_PODR = 0x1
	// Output low
	PFS_P109PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P109PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P109PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P109PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P109PFS_BY_PIDR = 0x2
	// Low level
	PFS_P109PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P109PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P109PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P109PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P109PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P109PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P109PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P109PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P109PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P109PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P109PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P109PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P109PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P109PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P109PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P109PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P109PFS_BY_NCODR_1 = 0x1

	// P110PFS: Port 1%s Pin Function Select Register
	// Position of PODR field.
	PFS_P1PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P1PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P1PFS_PODR = 0x1
	// Output low
	PFS_P1PFS_PODR_0 = 0x0
	// Output high
	PFS_P1PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P1PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P1PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P1PFS_PIDR = 0x2
	// Low level
	PFS_P1PFS_PIDR_0 = 0x0
	// High level
	PFS_P1PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P1PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P1PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P1PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P1PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P1PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P1PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P1PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P1PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P1PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P1PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P1PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P1PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P1PFS_NCODR = 0x40
	// Output CMOS
	PFS_P1PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P1PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P1PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P1PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P1PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P1PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P1PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P1PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P1PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P1PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P1PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P1PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P1PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P1PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P1PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P1PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P1PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P1PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P1PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P1PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P1PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P1PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P1PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P1PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P1PFS_PSEL_Msk = 0x1f000000

	// P110PFS_HA: Port 1%s Pin Function Select Register
	// Position of PODR field.
	PFS_P1PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P1PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P1PFS_HA_PODR = 0x1
	// Output low
	PFS_P1PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P1PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P1PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P1PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P1PFS_HA_PIDR = 0x2
	// Low level
	PFS_P1PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P1PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P1PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P1PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P1PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P1PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P1PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P1PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P1PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P1PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P1PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P1PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P1PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P1PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P1PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P1PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P1PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P1PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P1PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P1PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P1PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P1PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P1PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P1PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P1PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P1PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P1PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P1PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P1PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P1PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P1PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P1PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P1PFS_HA_ASEL_1 = 0x1

	// P110PFS_BY: Port 1%s Pin Function Select Register
	// Position of PODR field.
	PFS_P1PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P1PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P1PFS_BY_PODR = 0x1
	// Output low
	PFS_P1PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P1PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P1PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P1PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P1PFS_BY_PIDR = 0x2
	// Low level
	PFS_P1PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P1PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P1PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P1PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P1PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P1PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P1PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P1PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P1PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P1PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P1PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P1PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P1PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P1PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P1PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P1PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P1PFS_BY_NCODR_1 = 0x1

	// P200PFS: Port 200 Pin Function Select Register
	// Position of PODR field.
	PFS_P200PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P200PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P200PFS_PODR = 0x1
	// Output low
	PFS_P200PFS_PODR_0 = 0x0
	// Output high
	PFS_P200PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P200PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P200PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P200PFS_PIDR = 0x2
	// Low level
	PFS_P200PFS_PIDR_0 = 0x0
	// High level
	PFS_P200PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P200PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P200PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P200PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P200PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P200PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P200PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P200PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P200PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P200PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P200PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P200PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P200PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P200PFS_NCODR = 0x40
	// Output CMOS
	PFS_P200PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P200PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P200PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P200PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P200PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P200PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P200PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P200PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P200PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P200PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P200PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P200PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P200PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P200PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P200PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P200PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P200PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P200PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P200PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P200PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P200PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P200PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P200PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P200PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P200PFS_PSEL_Msk = 0x1f000000

	// P200PFS_HA: Port 200 Pin Function Select Register
	// Position of PODR field.
	PFS_P200PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P200PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P200PFS_HA_PODR = 0x1
	// Output low
	PFS_P200PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P200PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P200PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P200PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P200PFS_HA_PIDR = 0x2
	// Low level
	PFS_P200PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P200PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P200PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P200PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P200PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P200PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P200PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P200PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P200PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P200PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P200PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P200PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P200PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P200PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P200PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P200PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P200PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P200PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P200PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P200PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P200PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P200PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P200PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P200PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P200PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P200PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P200PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P200PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P200PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P200PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P200PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P200PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P200PFS_HA_ASEL_1 = 0x1

	// P200PFS_BY: Port 200 Pin Function Select Register
	// Position of PODR field.
	PFS_P200PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P200PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P200PFS_BY_PODR = 0x1
	// Output low
	PFS_P200PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P200PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P200PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P200PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P200PFS_BY_PIDR = 0x2
	// Low level
	PFS_P200PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P200PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P200PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P200PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P200PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P200PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P200PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P200PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P200PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P200PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P200PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P200PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P200PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P200PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P200PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P200PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P200PFS_BY_NCODR_1 = 0x1

	// P201PFS: Port 201 Pin Function Select Register
	// Position of PODR field.
	PFS_P201PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P201PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P201PFS_PODR = 0x1
	// Output low
	PFS_P201PFS_PODR_0 = 0x0
	// Output high
	PFS_P201PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P201PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P201PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P201PFS_PIDR = 0x2
	// Low level
	PFS_P201PFS_PIDR_0 = 0x0
	// High level
	PFS_P201PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P201PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P201PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P201PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P201PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P201PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P201PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P201PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P201PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P201PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P201PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P201PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P201PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P201PFS_NCODR = 0x40
	// Output CMOS
	PFS_P201PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P201PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P201PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P201PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P201PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P201PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P201PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P201PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P201PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P201PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P201PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P201PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P201PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P201PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P201PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P201PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P201PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P201PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P201PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P201PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P201PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P201PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P201PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P201PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P201PFS_PSEL_Msk = 0x1f000000

	// P201PFS_HA: Port 201 Pin Function Select Register
	// Position of PODR field.
	PFS_P201PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P201PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P201PFS_HA_PODR = 0x1
	// Output low
	PFS_P201PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P201PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P201PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P201PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P201PFS_HA_PIDR = 0x2
	// Low level
	PFS_P201PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P201PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P201PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P201PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P201PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P201PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P201PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P201PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P201PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P201PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P201PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P201PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P201PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P201PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P201PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P201PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P201PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P201PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P201PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P201PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P201PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P201PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P201PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P201PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P201PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P201PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P201PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P201PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P201PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P201PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P201PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P201PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P201PFS_HA_ASEL_1 = 0x1

	// P201PFS_BY: Port 201 Pin Function Select Register
	// Position of PODR field.
	PFS_P201PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P201PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P201PFS_BY_PODR = 0x1
	// Output low
	PFS_P201PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P201PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P201PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P201PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P201PFS_BY_PIDR = 0x2
	// Low level
	PFS_P201PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P201PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P201PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P201PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P201PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P201PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P201PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P201PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P201PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P201PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P201PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P201PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P201PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P201PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P201PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P201PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P201PFS_BY_NCODR_1 = 0x1

	// P202PFS: Port 20%s Pin Function Select Register
	// Position of PODR field.
	PFS_P20PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P20PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P20PFS_PODR = 0x1
	// Output low
	PFS_P20PFS_PODR_0 = 0x0
	// Output high
	PFS_P20PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P20PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P20PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P20PFS_PIDR = 0x2
	// Low level
	PFS_P20PFS_PIDR_0 = 0x0
	// High level
	PFS_P20PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P20PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P20PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P20PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P20PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P20PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P20PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P20PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P20PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P20PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P20PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P20PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P20PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P20PFS_NCODR = 0x40
	// Output CMOS
	PFS_P20PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P20PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P20PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P20PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P20PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P20PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P20PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P20PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P20PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P20PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P20PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P20PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P20PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P20PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P20PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P20PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P20PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P20PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P20PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P20PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P20PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P20PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P20PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P20PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P20PFS_PSEL_Msk = 0x1f000000

	// P202PFS_HA: Port 20%s Pin Function Select Register
	// Position of PODR field.
	PFS_P20PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P20PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P20PFS_HA_PODR = 0x1
	// Output low
	PFS_P20PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P20PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P20PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P20PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P20PFS_HA_PIDR = 0x2
	// Low level
	PFS_P20PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P20PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P20PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P20PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P20PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P20PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P20PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P20PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P20PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P20PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P20PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P20PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P20PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P20PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P20PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P20PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P20PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P20PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P20PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P20PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P20PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P20PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P20PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P20PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P20PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P20PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P20PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P20PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P20PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P20PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P20PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P20PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P20PFS_HA_ASEL_1 = 0x1

	// P202PFS_BY: Port 20%s Pin Function Select Register
	// Position of PODR field.
	PFS_P20PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P20PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P20PFS_BY_PODR = 0x1
	// Output low
	PFS_P20PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P20PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P20PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P20PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P20PFS_BY_PIDR = 0x2
	// Low level
	PFS_P20PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P20PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P20PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P20PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P20PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P20PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P20PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P20PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P20PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P20PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P20PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P20PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P20PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P20PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P20PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P20PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P20PFS_BY_NCODR_1 = 0x1

	// P212PFS: Port 2%s Pin Function Select Register
	// Position of PODR field.
	PFS_P2PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P2PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P2PFS_PODR = 0x1
	// Output low
	PFS_P2PFS_PODR_0 = 0x0
	// Output high
	PFS_P2PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P2PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P2PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P2PFS_PIDR = 0x2
	// Low level
	PFS_P2PFS_PIDR_0 = 0x0
	// High level
	PFS_P2PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P2PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P2PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P2PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P2PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P2PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P2PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P2PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P2PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P2PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P2PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P2PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P2PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P2PFS_NCODR = 0x40
	// Output CMOS
	PFS_P2PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P2PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P2PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P2PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P2PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P2PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P2PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P2PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P2PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P2PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P2PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P2PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P2PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P2PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P2PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P2PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P2PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P2PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P2PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P2PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P2PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P2PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P2PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P2PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P2PFS_PSEL_Msk = 0x1f000000

	// P212PFS_HA: Port 2%s Pin Function Select Register
	// Position of PODR field.
	PFS_P2PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P2PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P2PFS_HA_PODR = 0x1
	// Output low
	PFS_P2PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P2PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P2PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P2PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P2PFS_HA_PIDR = 0x2
	// Low level
	PFS_P2PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P2PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P2PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P2PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P2PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P2PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P2PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P2PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P2PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P2PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P2PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P2PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P2PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P2PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P2PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P2PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P2PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P2PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P2PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P2PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P2PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P2PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P2PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P2PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P2PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P2PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P2PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P2PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P2PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P2PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P2PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P2PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P2PFS_HA_ASEL_1 = 0x1

	// P212PFS_BY: Port 2%s Pin Function Select Register
	// Position of PODR field.
	PFS_P2PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P2PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P2PFS_BY_PODR = 0x1
	// Output low
	PFS_P2PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P2PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P2PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P2PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P2PFS_BY_PIDR = 0x2
	// Low level
	PFS_P2PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P2PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P2PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P2PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P2PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P2PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P2PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P2PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P2PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P2PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P2PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P2PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P2PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P2PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P2PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P2PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P2PFS_BY_NCODR_1 = 0x1

	// P300PFS: Port 300 Pin Function Select Register
	// Position of PODR field.
	PFS_P300PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P300PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P300PFS_PODR = 0x1
	// Output low
	PFS_P300PFS_PODR_0 = 0x0
	// Output high
	PFS_P300PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P300PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P300PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P300PFS_PIDR = 0x2
	// Low level
	PFS_P300PFS_PIDR_0 = 0x0
	// High level
	PFS_P300PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P300PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P300PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P300PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P300PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P300PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P300PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P300PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P300PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P300PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P300PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P300PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P300PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P300PFS_NCODR = 0x40
	// Output CMOS
	PFS_P300PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P300PFS_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P300PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P300PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P300PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P300PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P300PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P300PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P300PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P300PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P300PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P300PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P300PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P300PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P300PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P300PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P300PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P300PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P300PFS_PSEL_Msk = 0x1f000000

	// P300PFS_HA: Port 300 Pin Function Select Register
	// Position of PODR field.
	PFS_P300PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P300PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P300PFS_HA_PODR = 0x1
	// Output low
	PFS_P300PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P300PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P300PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P300PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P300PFS_HA_PIDR = 0x2
	// Low level
	PFS_P300PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P300PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P300PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P300PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P300PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P300PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P300PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P300PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P300PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P300PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P300PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P300PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P300PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P300PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P300PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P300PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P300PFS_HA_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P300PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P300PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P300PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P300PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P300PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P300PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P300PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P300PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P300PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P300PFS_HA_ASEL_1 = 0x1

	// P300PFS_BY: Port 300 Pin Function Select Register
	// Position of PODR field.
	PFS_P300PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P300PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P300PFS_BY_PODR = 0x1
	// Output low
	PFS_P300PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P300PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P300PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P300PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P300PFS_BY_PIDR = 0x2
	// Low level
	PFS_P300PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P300PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P300PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P300PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P300PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P300PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P300PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P300PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P300PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P300PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P300PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P300PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P300PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P300PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P300PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P300PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P300PFS_BY_NCODR_1 = 0x1

	// P301PFS: Port 30%s Pin Function Select Register
	// Position of PODR field.
	PFS_P30PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P30PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P30PFS_PODR = 0x1
	// Output low
	PFS_P30PFS_PODR_0 = 0x0
	// Output high
	PFS_P30PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P30PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P30PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P30PFS_PIDR = 0x2
	// Low level
	PFS_P30PFS_PIDR_0 = 0x0
	// High level
	PFS_P30PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P30PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P30PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P30PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P30PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P30PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P30PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P30PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P30PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P30PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P30PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P30PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P30PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P30PFS_NCODR = 0x40
	// Output CMOS
	PFS_P30PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P30PFS_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P30PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P30PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P30PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P30PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P30PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P30PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P30PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P30PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P30PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P30PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P30PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P30PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P30PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P30PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P30PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P30PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P30PFS_PSEL_Msk = 0x1f000000

	// P301PFS_HA: Port 30%s Pin Function Select Register
	// Position of PODR field.
	PFS_P30PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P30PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P30PFS_HA_PODR = 0x1
	// Output low
	PFS_P30PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P30PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P30PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P30PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P30PFS_HA_PIDR = 0x2
	// Low level
	PFS_P30PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P30PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P30PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P30PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P30PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P30PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P30PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P30PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P30PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P30PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P30PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P30PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P30PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P30PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P30PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P30PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P30PFS_HA_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P30PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P30PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P30PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P30PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P30PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P30PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P30PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P30PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P30PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P30PFS_HA_ASEL_1 = 0x1

	// P301PFS_BY: Port 30%s Pin Function Select Register
	// Position of PODR field.
	PFS_P30PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P30PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P30PFS_BY_PODR = 0x1
	// Output low
	PFS_P30PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P30PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P30PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P30PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P30PFS_BY_PIDR = 0x2
	// Low level
	PFS_P30PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P30PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P30PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P30PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P30PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P30PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P30PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P30PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P30PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P30PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P30PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P30PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P30PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P30PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P30PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P30PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P30PFS_BY_NCODR_1 = 0x1

	// P400PFS: Port 40%s Pin Function Select Register
	// Position of PODR field.
	PFS_P40PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P40PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P40PFS_PODR = 0x1
	// Output low
	PFS_P40PFS_PODR_0 = 0x0
	// Output high
	PFS_P40PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P40PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P40PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P40PFS_PIDR = 0x2
	// Low level
	PFS_P40PFS_PIDR_0 = 0x0
	// High level
	PFS_P40PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P40PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P40PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P40PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P40PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P40PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P40PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P40PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P40PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P40PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P40PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P40PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P40PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P40PFS_NCODR = 0x40
	// Output CMOS
	PFS_P40PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P40PFS_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P40PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P40PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P40PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P40PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P40PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P40PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P40PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P40PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P40PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P40PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P40PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P40PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P40PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P40PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P40PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P40PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P40PFS_PSEL_Msk = 0x1f000000

	// P400PFS_HA: Port 40%s Pin Function Select Register
	// Position of PODR field.
	PFS_P40PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P40PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P40PFS_HA_PODR = 0x1
	// Output low
	PFS_P40PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P40PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P40PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P40PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P40PFS_HA_PIDR = 0x2
	// Low level
	PFS_P40PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P40PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P40PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P40PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P40PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P40PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P40PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P40PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P40PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P40PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P40PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P40PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P40PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P40PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P40PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P40PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P40PFS_HA_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P40PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P40PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P40PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P40PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P40PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P40PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P40PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P40PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P40PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P40PFS_HA_ASEL_1 = 0x1

	// P400PFS_BY: Port 40%s Pin Function Select Register
	// Position of PODR field.
	PFS_P40PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P40PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P40PFS_BY_PODR = 0x1
	// Output low
	PFS_P40PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P40PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P40PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P40PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P40PFS_BY_PIDR = 0x2
	// Low level
	PFS_P40PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P40PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P40PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P40PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P40PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P40PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P40PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P40PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P40PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P40PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P40PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P40PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P40PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P40PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P40PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P40PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P40PFS_BY_NCODR_1 = 0x1

	// P410PFS: Port 4%s Pin Function Select Register
	// Position of PODR field.
	PFS_P4PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P4PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P4PFS_PODR = 0x1
	// Output low
	PFS_P4PFS_PODR_0 = 0x0
	// Output high
	PFS_P4PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P4PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P4PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P4PFS_PIDR = 0x2
	// Low level
	PFS_P4PFS_PIDR_0 = 0x0
	// High level
	PFS_P4PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P4PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P4PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P4PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P4PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P4PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P4PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P4PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P4PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P4PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P4PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P4PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P4PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P4PFS_NCODR = 0x40
	// Output CMOS
	PFS_P4PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P4PFS_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P4PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P4PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P4PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P4PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P4PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P4PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P4PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P4PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P4PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P4PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P4PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P4PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P4PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P4PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P4PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P4PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P4PFS_PSEL_Msk = 0x1f000000

	// P410PFS_HA: Port 4%s Pin Function Select Register
	// Position of PODR field.
	PFS_P4PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P4PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P4PFS_HA_PODR = 0x1
	// Output low
	PFS_P4PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P4PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P4PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P4PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P4PFS_HA_PIDR = 0x2
	// Low level
	PFS_P4PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P4PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P4PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P4PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P4PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P4PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P4PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P4PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P4PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P4PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P4PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P4PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P4PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P4PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P4PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P4PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P4PFS_HA_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P4PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P4PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P4PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P4PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P4PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P4PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P4PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P4PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P4PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P4PFS_HA_ASEL_1 = 0x1

	// P410PFS_BY: Port 4%s Pin Function Select Register
	// Position of PODR field.
	PFS_P4PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P4PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P4PFS_BY_PODR = 0x1
	// Output low
	PFS_P4PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P4PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P4PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P4PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P4PFS_BY_PIDR = 0x2
	// Low level
	PFS_P4PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P4PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P4PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P4PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P4PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P4PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P4PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P4PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P4PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P4PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P4PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P4PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P4PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P4PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P4PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P4PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P4PFS_BY_NCODR_1 = 0x1

	// P500PFS: Port 50%s Pin Function Select Register
	// Position of PODR field.
	PFS_P50PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P50PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P50PFS_PODR = 0x1
	// Output low
	PFS_P50PFS_PODR_0 = 0x0
	// Output high
	PFS_P50PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P50PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P50PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P50PFS_PIDR = 0x2
	// Low level
	PFS_P50PFS_PIDR_0 = 0x0
	// High level
	PFS_P50PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P50PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P50PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P50PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P50PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P50PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P50PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P50PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P50PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P50PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P50PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P50PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P50PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P50PFS_NCODR = 0x40
	// Output CMOS
	PFS_P50PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P50PFS_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P50PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P50PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P50PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P50PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P50PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P50PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P50PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P50PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P50PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P50PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P50PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P50PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P50PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P50PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P50PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P50PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P50PFS_PSEL_Msk = 0x1f000000

	// P500PFS_HA: Port 50%s Pin Function Select Register
	// Position of PODR field.
	PFS_P50PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P50PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P50PFS_HA_PODR = 0x1
	// Output low
	PFS_P50PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P50PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P50PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P50PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P50PFS_HA_PIDR = 0x2
	// Low level
	PFS_P50PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P50PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P50PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P50PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P50PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P50PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P50PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P50PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P50PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P50PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P50PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P50PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P50PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P50PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P50PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P50PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P50PFS_HA_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P50PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P50PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P50PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P50PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P50PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P50PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P50PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P50PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P50PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P50PFS_HA_ASEL_1 = 0x1

	// P500PFS_BY: Port 50%s Pin Function Select Register
	// Position of PODR field.
	PFS_P50PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P50PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P50PFS_BY_PODR = 0x1
	// Output low
	PFS_P50PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P50PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P50PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P50PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P50PFS_BY_PIDR = 0x2
	// Low level
	PFS_P50PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P50PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P50PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P50PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P50PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P50PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P50PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P50PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P50PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P50PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P50PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P50PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P50PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P50PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P50PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P50PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P50PFS_BY_NCODR_1 = 0x1

	// P913PFS: Port 9%s Pin Function Select Register
	// Position of PODR field.
	PFS_P9PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P9PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P9PFS_PODR = 0x1
	// Output low
	PFS_P9PFS_PODR_0 = 0x0
	// Output high
	PFS_P9PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P9PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P9PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P9PFS_PIDR = 0x2
	// Low level
	PFS_P9PFS_PIDR_0 = 0x0
	// High level
	PFS_P9PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P9PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P9PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P9PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P9PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P9PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P9PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P9PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P9PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P9PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P9PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P9PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P9PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P9PFS_NCODR = 0x40
	// Output CMOS
	PFS_P9PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P9PFS_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P9PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P9PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P9PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P9PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P9PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P9PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P9PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P9PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P9PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P9PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P9PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P9PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P9PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P9PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P9PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P9PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P9PFS_PSEL_Msk = 0x1f000000

	// P913PFS_HA: Port 9%s Pin Function Select Register
	// Position of PODR field.
	PFS_P9PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P9PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P9PFS_HA_PODR = 0x1
	// Output low
	PFS_P9PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P9PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P9PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P9PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P9PFS_HA_PIDR = 0x2
	// Low level
	PFS_P9PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P9PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P9PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P9PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P9PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P9PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P9PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P9PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P9PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P9PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P9PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P9PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P9PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P9PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P9PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P9PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P9PFS_HA_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P9PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P9PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P9PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P9PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P9PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P9PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P9PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P9PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P9PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P9PFS_HA_ASEL_1 = 0x1

	// P913PFS_BY: Port 9%s Pin Function Select Register
	// Position of PODR field.
	PFS_P9PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P9PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P9PFS_BY_PODR = 0x1
	// Output low
	PFS_P9PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P9PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P9PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P9PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P9PFS_BY_PIDR = 0x2
	// Low level
	PFS_P9PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P9PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P9PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P9PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P9PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P9PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P9PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P9PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P9PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P9PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P9PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P9PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P9PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P9PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P9PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P9PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P9PFS_BY_NCODR_1 = 0x1

	// PWPR: Write-Protect Register
	// Position of PFSWE field.
	PFS_PWPR_PFSWE_Pos = 0x6
	// Bit mask of PFSWE field.
	PFS_PWPR_PFSWE_Msk = 0x40
	// Bit PFSWE.
	PFS_PWPR_PFSWE = 0x40
	// Writing to the PmnPFS register is disabled
	PFS_PWPR_PFSWE_0 = 0x0
	// Writing to the PmnPFS register is enabled
	PFS_PWPR_PFSWE_1 = 0x1
	// Position of B0WI field.
	PFS_PWPR_B0WI_Pos = 0x7
	// Bit mask of B0WI field.
	PFS_PWPR_B0WI_Msk = 0x80
	// Bit B0WI.
	PFS_PWPR_B0WI = 0x80
	// Writing to the PFSWE bit is enabled
	PFS_PWPR_B0WI_0 = 0x0
	// Writing to the PFSWE bit is disabled
	PFS_PWPR_B0WI_1 = 0x1

	// PRWCNTR: Port Read Wait Control Register
	// Position of WAIT field.
	PFS_PRWCNTR_WAIT_Pos = 0x0
	// Bit mask of WAIT field.
	PFS_PRWCNTR_WAIT_Msk = 0x3
	// Setting prohibited
	PFS_PRWCNTR_WAIT_00 = 0x0
	// Insert a 1-cycle wait
	PFS_PRWCNTR_WAIT_01 = 0x1
	// Insert a 2-cycle wait
	PFS_PRWCNTR_WAIT_10 = 0x2
	// Insert a 3-cycle wait
	PFS_PRWCNTR_WAIT_11 = 0x3
)

// Constants for ELC: Event Link Controller
const (
	// ELCR: Event Link Controller Register
	// Position of ELCON field.
	ELC_ELCR_ELCON_Pos = 0x7
	// Bit mask of ELCON field.
	ELC_ELCR_ELCON_Msk = 0x80
	// Bit ELCON.
	ELC_ELCR_ELCON = 0x80
	// ELC function is disabled.
	ELC_ELCR_ELCON_0 = 0x0
	// ELC function is enabled.
	ELC_ELCR_ELCON_1 = 0x1

	// ELSEGR0: Event Link Software Event Generation Register %s
	// Position of SEG field.
	ELC_ELSEGR_SEG_Pos = 0x0
	// Bit mask of SEG field.
	ELC_ELSEGR_SEG_Msk = 0x1
	// Bit SEG.
	ELC_ELSEGR_SEG = 0x1
	// Normal operation
	ELC_ELSEGR_SEG_0 = 0x0
	// Software event is generated.
	ELC_ELSEGR_SEG_1 = 0x1
	// Position of WE field.
	ELC_ELSEGR_WE_Pos = 0x6
	// Bit mask of WE field.
	ELC_ELSEGR_WE_Msk = 0x40
	// Bit WE.
	ELC_ELSEGR_WE = 0x40
	// Write to SEG bit disabled.
	ELC_ELSEGR_WE_0 = 0x0
	// Write to SEG bit enabled.
	ELC_ELSEGR_WE_1 = 0x1
	// Position of WI field.
	ELC_ELSEGR_WI_Pos = 0x7
	// Bit mask of WI field.
	ELC_ELSEGR_WI_Msk = 0x80
	// Bit WI.
	ELC_ELSEGR_WI = 0x80
	// Write to ELSEGR register enabled.
	ELC_ELSEGR_WI_0 = 0x0
	// Write to ELSEGR register disabled.
	ELC_ELSEGR_WI_1 = 0x1

	// ELSR0: Event Link Setting Register %s
	// Position of ELS field.
	ELC_ELSR_ELS_Pos = 0x0
	// Bit mask of ELS field.
	ELC_ELSR_ELS_Msk = 0xff

	// ELSR8: Event Link Setting Register %s
	// Position of ELS field.
	ELC_ELSR_ELS_Pos = 0x0
	// Bit mask of ELS field.
	ELC_ELSR_ELS_Msk = 0xff

	// ELSR12: Event Link Setting Register 12
	// Position of ELS field.
	ELC_ELSR12_ELS_Pos = 0x0
	// Bit mask of ELS field.
	ELC_ELSR12_ELS_Msk = 0xff

	// ELSR14: Event Link Setting Register %s
	// Position of ELS field.
	ELC_ELSR_ELS_Pos = 0x0
	// Bit mask of ELS field.
	ELC_ELSR_ELS_Msk = 0xff

	// ELSR18: Event Link Setting Register 18
	// Position of ELS field.
	ELC_ELSR18_ELS_Pos = 0x0
	// Bit mask of ELS field.
	ELC_ELSR18_ELS_Msk = 0xff
)

// Constants for POEG: Port Output Enable Module for GPT
const (
	// POEGGA: POEG Group A Setting Register
	// Position of PIDF field.
	POEG_POEGGA_PIDF_Pos = 0x0
	// Bit mask of PIDF field.
	POEG_POEGGA_PIDF_Msk = 0x1
	// Bit PIDF.
	POEG_POEGGA_PIDF = 0x1
	// No output-disable request from the GTETRGn pin occurred
	POEG_POEGGA_PIDF_0 = 0x0
	// Output-disable request from the GTETRGn pin occurred.
	POEG_POEGGA_PIDF_1 = 0x1
	// Position of IOCF field.
	POEG_POEGGA_IOCF_Pos = 0x1
	// Bit mask of IOCF field.
	POEG_POEGGA_IOCF_Msk = 0x2
	// Bit IOCF.
	POEG_POEGGA_IOCF = 0x2
	// No output-disable request from GPT occurred.
	POEG_POEGGA_IOCF_0 = 0x0
	// Output-disable request from GPT occurred.
	POEG_POEGGA_IOCF_1 = 0x1
	// Position of OSTPF field.
	POEG_POEGGA_OSTPF_Pos = 0x2
	// Bit mask of OSTPF field.
	POEG_POEGGA_OSTPF_Msk = 0x4
	// Bit OSTPF.
	POEG_POEGGA_OSTPF = 0x4
	// No output-disable request from oscillation stop detection occurred
	POEG_POEGGA_OSTPF_0 = 0x0
	// Output-disable request from oscillation stop detection occurred
	POEG_POEGGA_OSTPF_1 = 0x1
	// Position of SSF field.
	POEG_POEGGA_SSF_Pos = 0x3
	// Bit mask of SSF field.
	POEG_POEGGA_SSF_Msk = 0x8
	// Bit SSF.
	POEG_POEGGA_SSF = 0x8
	// No output-disable request from software occurred
	POEG_POEGGA_SSF_0 = 0x0
	// Output-disable request from software occurred
	POEG_POEGGA_SSF_1 = 0x1
	// Position of PIDE field.
	POEG_POEGGA_PIDE_Pos = 0x4
	// Bit mask of PIDE field.
	POEG_POEGGA_PIDE_Msk = 0x10
	// Bit PIDE.
	POEG_POEGGA_PIDE = 0x10
	// Disable output-disable requests from the GTETRGn pins
	POEG_POEGGA_PIDE_0 = 0x0
	// Enable output-disable requests from the GTETRGn pins
	POEG_POEGGA_PIDE_1 = 0x1
	// Position of IOCE field.
	POEG_POEGGA_IOCE_Pos = 0x5
	// Bit mask of IOCE field.
	POEG_POEGGA_IOCE_Msk = 0x20
	// Bit IOCE.
	POEG_POEGGA_IOCE = 0x20
	// Disable output-disable requests from GPT
	POEG_POEGGA_IOCE_0 = 0x0
	// Enable output-disable requests from GPT
	POEG_POEGGA_IOCE_1 = 0x1
	// Position of OSTPE field.
	POEG_POEGGA_OSTPE_Pos = 0x6
	// Bit mask of OSTPE field.
	POEG_POEGGA_OSTPE_Msk = 0x40
	// Bit OSTPE.
	POEG_POEGGA_OSTPE = 0x40
	// Disable output-disable requests from oscillation stop detection
	POEG_POEGGA_OSTPE_0 = 0x0
	// Enable output-disable requests from oscillation stop detection
	POEG_POEGGA_OSTPE_1 = 0x1
	// Position of ST field.
	POEG_POEGGA_ST_Pos = 0x10
	// Bit mask of ST field.
	POEG_POEGGA_ST_Msk = 0x10000
	// Bit ST.
	POEG_POEGGA_ST = 0x10000
	// GTETRGn input after filtering was 0
	POEG_POEGGA_ST_0 = 0x0
	// GTETRGn input after filtering was 1
	POEG_POEGGA_ST_1 = 0x1
	// Position of INV field.
	POEG_POEGGA_INV_Pos = 0x1c
	// Bit mask of INV field.
	POEG_POEGGA_INV_Msk = 0x10000000
	// Bit INV.
	POEG_POEGGA_INV = 0x10000000
	// Input GTETRGn as-is
	POEG_POEGGA_INV_0 = 0x0
	// Input GTETRGn in reverse
	POEG_POEGGA_INV_1 = 0x1
	// Position of NFEN field.
	POEG_POEGGA_NFEN_Pos = 0x1d
	// Bit mask of NFEN field.
	POEG_POEGGA_NFEN_Msk = 0x20000000
	// Bit NFEN.
	POEG_POEGGA_NFEN = 0x20000000
	// Disable noise filtering
	POEG_POEGGA_NFEN_0 = 0x0
	// Enable noise filtering
	POEG_POEGGA_NFEN_1 = 0x1
	// Position of NFCS field.
	POEG_POEGGA_NFCS_Pos = 0x1e
	// Bit mask of NFCS field.
	POEG_POEGGA_NFCS_Msk = 0xc0000000
	// Sample GTETRGn pin input level three times every PCLKB
	POEG_POEGGA_NFCS_00 = 0x0
	// Sample GTETRGn pin input level three times every PCLKB/8
	POEG_POEGGA_NFCS_01 = 0x1
	// Sample GTETRGn pin input level three times every PCLKB/32
	POEG_POEGGA_NFCS_10 = 0x2
	// Sample GTETRGn pin input level three times every PCLKB/128
	POEG_POEGGA_NFCS_11 = 0x3

	// POEGGB: POEG Group B Setting Register
	// Position of PIDF field.
	POEG_POEGGB_PIDF_Pos = 0x0
	// Bit mask of PIDF field.
	POEG_POEGGB_PIDF_Msk = 0x1
	// Bit PIDF.
	POEG_POEGGB_PIDF = 0x1
	// No output-disable request from the GTETRGn pin occurred
	POEG_POEGGB_PIDF_0 = 0x0
	// Output-disable request from the GTETRGn pin occurred.
	POEG_POEGGB_PIDF_1 = 0x1
	// Position of IOCF field.
	POEG_POEGGB_IOCF_Pos = 0x1
	// Bit mask of IOCF field.
	POEG_POEGGB_IOCF_Msk = 0x2
	// Bit IOCF.
	POEG_POEGGB_IOCF = 0x2
	// No output-disable request from GPT occurred.
	POEG_POEGGB_IOCF_0 = 0x0
	// Output-disable request from GPT occurred.
	POEG_POEGGB_IOCF_1 = 0x1
	// Position of OSTPF field.
	POEG_POEGGB_OSTPF_Pos = 0x2
	// Bit mask of OSTPF field.
	POEG_POEGGB_OSTPF_Msk = 0x4
	// Bit OSTPF.
	POEG_POEGGB_OSTPF = 0x4
	// No output-disable request from oscillation stop detection occurred
	POEG_POEGGB_OSTPF_0 = 0x0
	// Output-disable request from oscillation stop detection occurred
	POEG_POEGGB_OSTPF_1 = 0x1
	// Position of SSF field.
	POEG_POEGGB_SSF_Pos = 0x3
	// Bit mask of SSF field.
	POEG_POEGGB_SSF_Msk = 0x8
	// Bit SSF.
	POEG_POEGGB_SSF = 0x8
	// No output-disable request from software occurred
	POEG_POEGGB_SSF_0 = 0x0
	// Output-disable request from software occurred
	POEG_POEGGB_SSF_1 = 0x1
	// Position of PIDE field.
	POEG_POEGGB_PIDE_Pos = 0x4
	// Bit mask of PIDE field.
	POEG_POEGGB_PIDE_Msk = 0x10
	// Bit PIDE.
	POEG_POEGGB_PIDE = 0x10
	// Disable output-disable requests from the GTETRGn pins
	POEG_POEGGB_PIDE_0 = 0x0
	// Enable output-disable requests from the GTETRGn pins
	POEG_POEGGB_PIDE_1 = 0x1
	// Position of IOCE field.
	POEG_POEGGB_IOCE_Pos = 0x5
	// Bit mask of IOCE field.
	POEG_POEGGB_IOCE_Msk = 0x20
	// Bit IOCE.
	POEG_POEGGB_IOCE = 0x20
	// Disable output-disable requests from GPT
	POEG_POEGGB_IOCE_0 = 0x0
	// Enable output-disable requests from GPT
	POEG_POEGGB_IOCE_1 = 0x1
	// Position of OSTPE field.
	POEG_POEGGB_OSTPE_Pos = 0x6
	// Bit mask of OSTPE field.
	POEG_POEGGB_OSTPE_Msk = 0x40
	// Bit OSTPE.
	POEG_POEGGB_OSTPE = 0x40
	// Disable output-disable requests from oscillation stop detection
	POEG_POEGGB_OSTPE_0 = 0x0
	// Enable output-disable requests from oscillation stop detection
	POEG_POEGGB_OSTPE_1 = 0x1
	// Position of ST field.
	POEG_POEGGB_ST_Pos = 0x10
	// Bit mask of ST field.
	POEG_POEGGB_ST_Msk = 0x10000
	// Bit ST.
	POEG_POEGGB_ST = 0x10000
	// GTETRGn input after filtering was 0
	POEG_POEGGB_ST_0 = 0x0
	// GTETRGn input after filtering was 1
	POEG_POEGGB_ST_1 = 0x1
	// Position of INV field.
	POEG_POEGGB_INV_Pos = 0x1c
	// Bit mask of INV field.
	POEG_POEGGB_INV_Msk = 0x10000000
	// Bit INV.
	POEG_POEGGB_INV = 0x10000000
	// Input GTETRGn as-is
	POEG_POEGGB_INV_0 = 0x0
	// Input GTETRGn in reverse
	POEG_POEGGB_INV_1 = 0x1
	// Position of NFEN field.
	POEG_POEGGB_NFEN_Pos = 0x1d
	// Bit mask of NFEN field.
	POEG_POEGGB_NFEN_Msk = 0x20000000
	// Bit NFEN.
	POEG_POEGGB_NFEN = 0x20000000
	// Disable noise filtering
	POEG_POEGGB_NFEN_0 = 0x0
	// Enable noise filtering
	POEG_POEGGB_NFEN_1 = 0x1
	// Position of NFCS field.
	POEG_POEGGB_NFCS_Pos = 0x1e
	// Bit mask of NFCS field.
	POEG_POEGGB_NFCS_Msk = 0xc0000000
	// Sample GTETRGn pin input level three times every PCLKB
	POEG_POEGGB_NFCS_00 = 0x0
	// Sample GTETRGn pin input level three times every PCLKB/8
	POEG_POEGGB_NFCS_01 = 0x1
	// Sample GTETRGn pin input level three times every PCLKB/32
	POEG_POEGGB_NFCS_10 = 0x2
	// Sample GTETRGn pin input level three times every PCLKB/128
	POEG_POEGGB_NFCS_11 = 0x3
)

// Constants for RTC: Realtime Clock
const (
	// R64CNT: 64-Hz Counter
	// Position of F64HZ field.
	RTC_R64CNT_F64HZ_Pos = 0x0
	// Bit mask of F64HZ field.
	RTC_R64CNT_F64HZ_Msk = 0x1
	// Bit F64HZ.
	RTC_R64CNT_F64HZ = 0x1
	// Position of F32HZ field.
	RTC_R64CNT_F32HZ_Pos = 0x1
	// Bit mask of F32HZ field.
	RTC_R64CNT_F32HZ_Msk = 0x2
	// Bit F32HZ.
	RTC_R64CNT_F32HZ = 0x2
	// Position of F16HZ field.
	RTC_R64CNT_F16HZ_Pos = 0x2
	// Bit mask of F16HZ field.
	RTC_R64CNT_F16HZ_Msk = 0x4
	// Bit F16HZ.
	RTC_R64CNT_F16HZ = 0x4
	// Position of F8HZ field.
	RTC_R64CNT_F8HZ_Pos = 0x3
	// Bit mask of F8HZ field.
	RTC_R64CNT_F8HZ_Msk = 0x8
	// Bit F8HZ.
	RTC_R64CNT_F8HZ = 0x8
	// Position of F4HZ field.
	RTC_R64CNT_F4HZ_Pos = 0x4
	// Bit mask of F4HZ field.
	RTC_R64CNT_F4HZ_Msk = 0x10
	// Bit F4HZ.
	RTC_R64CNT_F4HZ = 0x10
	// Position of F2HZ field.
	RTC_R64CNT_F2HZ_Pos = 0x5
	// Bit mask of F2HZ field.
	RTC_R64CNT_F2HZ_Msk = 0x20
	// Bit F2HZ.
	RTC_R64CNT_F2HZ = 0x20
	// Position of F1HZ field.
	RTC_R64CNT_F1HZ_Pos = 0x6
	// Bit mask of F1HZ field.
	RTC_R64CNT_F1HZ_Msk = 0x40
	// Bit F1HZ.
	RTC_R64CNT_F1HZ = 0x40
	// Position of R64OVF field.
	RTC_R64CNT_R64OVF_Pos = 0x7
	// Bit mask of R64OVF field.
	RTC_R64CNT_R64OVF_Msk = 0x80
	// Bit R64OVF.
	RTC_R64CNT_R64OVF = 0x80

	// BCNT0: Binary Counter %s
	// Position of BCNT field.
	RTC_BCNT_BCNT_Pos = 0x0
	// Bit mask of BCNT field.
	RTC_BCNT_BCNT_Msk = 0xff

	// RSECCNT: Second Counter (in Calendar Count Mode)
	// Position of SEC1 field.
	RTC_RSECCNT_SEC1_Pos = 0x0
	// Bit mask of SEC1 field.
	RTC_RSECCNT_SEC1_Msk = 0xf
	// Position of SEC10 field.
	RTC_RSECCNT_SEC10_Pos = 0x4
	// Bit mask of SEC10 field.
	RTC_RSECCNT_SEC10_Msk = 0x70

	// RMINCNT: Minute Counter (in Calendar Count Mode)
	// Position of MIN1 field.
	RTC_RMINCNT_MIN1_Pos = 0x0
	// Bit mask of MIN1 field.
	RTC_RMINCNT_MIN1_Msk = 0xf
	// Position of MIN10 field.
	RTC_RMINCNT_MIN10_Pos = 0x4
	// Bit mask of MIN10 field.
	RTC_RMINCNT_MIN10_Msk = 0x70

	// RHRCNT: Hour Counter (in Calendar Count Mode)
	// Position of HR1 field.
	RTC_RHRCNT_HR1_Pos = 0x0
	// Bit mask of HR1 field.
	RTC_RHRCNT_HR1_Msk = 0xf
	// Position of HR10 field.
	RTC_RHRCNT_HR10_Pos = 0x4
	// Bit mask of HR10 field.
	RTC_RHRCNT_HR10_Msk = 0x30
	// Position of PM field.
	RTC_RHRCNT_PM_Pos = 0x6
	// Bit mask of PM field.
	RTC_RHRCNT_PM_Msk = 0x40
	// Bit PM.
	RTC_RHRCNT_PM = 0x40
	// AM
	RTC_RHRCNT_PM_0 = 0x0
	// PM
	RTC_RHRCNT_PM_1 = 0x1

	// RWKCNT: Day-of-Week Counter (in Calendar Count Mode)
	// Position of DAYW field.
	RTC_RWKCNT_DAYW_Pos = 0x0
	// Bit mask of DAYW field.
	RTC_RWKCNT_DAYW_Msk = 0x7
	// Sunday
	RTC_RWKCNT_DAYW_000 = 0x0
	// Monday
	RTC_RWKCNT_DAYW_001 = 0x1
	// Tuesday
	RTC_RWKCNT_DAYW_010 = 0x2
	// Wednesday
	RTC_RWKCNT_DAYW_011 = 0x3
	// Thursday
	RTC_RWKCNT_DAYW_100 = 0x4
	// Friday
	RTC_RWKCNT_DAYW_101 = 0x5
	// Saturday
	RTC_RWKCNT_DAYW_110 = 0x6
	// Setting prohibited
	RTC_RWKCNT_DAYW_111 = 0x7

	// RDAYCNT: Day Counter
	// Position of DATE1 field.
	RTC_RDAYCNT_DATE1_Pos = 0x0
	// Bit mask of DATE1 field.
	RTC_RDAYCNT_DATE1_Msk = 0xf
	// Position of DATE10 field.
	RTC_RDAYCNT_DATE10_Pos = 0x4
	// Bit mask of DATE10 field.
	RTC_RDAYCNT_DATE10_Msk = 0x30

	// RMONCNT: Month Counter
	// Position of MON1 field.
	RTC_RMONCNT_MON1_Pos = 0x0
	// Bit mask of MON1 field.
	RTC_RMONCNT_MON1_Msk = 0xf
	// Position of MON10 field.
	RTC_RMONCNT_MON10_Pos = 0x4
	// Bit mask of MON10 field.
	RTC_RMONCNT_MON10_Msk = 0x10
	// Bit MON10.
	RTC_RMONCNT_MON10 = 0x10

	// RYRCNT: Year Counter
	// Position of YR1 field.
	RTC_RYRCNT_YR1_Pos = 0x0
	// Bit mask of YR1 field.
	RTC_RYRCNT_YR1_Msk = 0xf
	// Position of YR10 field.
	RTC_RYRCNT_YR10_Pos = 0x4
	// Bit mask of YR10 field.
	RTC_RYRCNT_YR10_Msk = 0xf0

	// BCNT0AR: Binary Counter %s Alarm Register
	// Position of BCNTAR field.
	RTC_BCNTAR_BCNTAR_Pos = 0x0
	// Bit mask of BCNTAR field.
	RTC_BCNTAR_BCNTAR_Msk = 0xff

	// RSECAR: Second Alarm Register (in Calendar Count Mode)
	// Position of SEC1 field.
	RTC_RSECAR_SEC1_Pos = 0x0
	// Bit mask of SEC1 field.
	RTC_RSECAR_SEC1_Msk = 0xf
	// Position of SEC10 field.
	RTC_RSECAR_SEC10_Pos = 0x4
	// Bit mask of SEC10 field.
	RTC_RSECAR_SEC10_Msk = 0x70
	// Position of ENB field.
	RTC_RSECAR_ENB_Pos = 0x7
	// Bit mask of ENB field.
	RTC_RSECAR_ENB_Msk = 0x80
	// Bit ENB.
	RTC_RSECAR_ENB = 0x80
	// Do not compare register value with RSECCNT counter value
	RTC_RSECAR_ENB_0 = 0x0
	// Compare register value with RSECCNT counter value
	RTC_RSECAR_ENB_1 = 0x1

	// RMINAR: Minute Alarm Register (in Calendar Count Mode)
	// Position of MIN1 field.
	RTC_RMINAR_MIN1_Pos = 0x0
	// Bit mask of MIN1 field.
	RTC_RMINAR_MIN1_Msk = 0xf
	// Position of MIN10 field.
	RTC_RMINAR_MIN10_Pos = 0x4
	// Bit mask of MIN10 field.
	RTC_RMINAR_MIN10_Msk = 0x70
	// Position of ENB field.
	RTC_RMINAR_ENB_Pos = 0x7
	// Bit mask of ENB field.
	RTC_RMINAR_ENB_Msk = 0x80
	// Bit ENB.
	RTC_RMINAR_ENB = 0x80
	// Do not compare register value with RMINCNT counter value
	RTC_RMINAR_ENB_0 = 0x0
	// Compare register value with RMINCNT counter value
	RTC_RMINAR_ENB_1 = 0x1

	// RHRAR: Hour Alarm Register (in Calendar Count Mode)
	// Position of HR1 field.
	RTC_RHRAR_HR1_Pos = 0x0
	// Bit mask of HR1 field.
	RTC_RHRAR_HR1_Msk = 0xf
	// Position of HR10 field.
	RTC_RHRAR_HR10_Pos = 0x4
	// Bit mask of HR10 field.
	RTC_RHRAR_HR10_Msk = 0x30
	// Position of PM field.
	RTC_RHRAR_PM_Pos = 0x6
	// Bit mask of PM field.
	RTC_RHRAR_PM_Msk = 0x40
	// Bit PM.
	RTC_RHRAR_PM = 0x40
	// AM
	RTC_RHRAR_PM_0 = 0x0
	// PM
	RTC_RHRAR_PM_1 = 0x1
	// Position of ENB field.
	RTC_RHRAR_ENB_Pos = 0x7
	// Bit mask of ENB field.
	RTC_RHRAR_ENB_Msk = 0x80
	// Bit ENB.
	RTC_RHRAR_ENB = 0x80
	// Do not compare register value with RHRCNT counter value
	RTC_RHRAR_ENB_0 = 0x0
	// Compare register value with RHRCNT counter value
	RTC_RHRAR_ENB_1 = 0x1

	// RWKAR: Day-of-Week Alarm Register (in Calendar Count Mode)
	// Position of DAYW field.
	RTC_RWKAR_DAYW_Pos = 0x0
	// Bit mask of DAYW field.
	RTC_RWKAR_DAYW_Msk = 0x7
	// Sunday
	RTC_RWKAR_DAYW_000 = 0x0
	// Monday
	RTC_RWKAR_DAYW_001 = 0x1
	// Tuesday
	RTC_RWKAR_DAYW_010 = 0x2
	// Wednesday
	RTC_RWKAR_DAYW_011 = 0x3
	// Thursday
	RTC_RWKAR_DAYW_100 = 0x4
	// Friday
	RTC_RWKAR_DAYW_101 = 0x5
	// Saturday
	RTC_RWKAR_DAYW_110 = 0x6
	// Setting prohibited
	RTC_RWKAR_DAYW_111 = 0x7
	// Position of ENB field.
	RTC_RWKAR_ENB_Pos = 0x7
	// Bit mask of ENB field.
	RTC_RWKAR_ENB_Msk = 0x80
	// Bit ENB.
	RTC_RWKAR_ENB = 0x80
	// Do not compare register value with RWKCNT counter value
	RTC_RWKAR_ENB_0 = 0x0
	// Compare register value with RWKCNT counter value
	RTC_RWKAR_ENB_1 = 0x1

	// BCNT0AER: Binary Counter %s Alarm Enable Register
	// Position of ENB field.
	RTC_BCNTAER_ENB_Pos = 0x0
	// Bit mask of ENB field.
	RTC_BCNTAER_ENB_Msk = 0xff

	// RDAYAR: Date Alarm Register (in Calendar Count Mode)
	// Position of DATE1 field.
	RTC_RDAYAR_DATE1_Pos = 0x0
	// Bit mask of DATE1 field.
	RTC_RDAYAR_DATE1_Msk = 0xf
	// Position of DATE10 field.
	RTC_RDAYAR_DATE10_Pos = 0x4
	// Bit mask of DATE10 field.
	RTC_RDAYAR_DATE10_Msk = 0x30
	// Position of ENB field.
	RTC_RDAYAR_ENB_Pos = 0x7
	// Bit mask of ENB field.
	RTC_RDAYAR_ENB_Msk = 0x80
	// Bit ENB.
	RTC_RDAYAR_ENB = 0x80
	// Do not compare register value with RDAYCNT counter value
	RTC_RDAYAR_ENB_0 = 0x0
	// Compare register value with RDAYCNT counter value
	RTC_RDAYAR_ENB_1 = 0x1

	// RMONAR: Month Alarm Register (in Calendar Count Mode)
	// Position of MON1 field.
	RTC_RMONAR_MON1_Pos = 0x0
	// Bit mask of MON1 field.
	RTC_RMONAR_MON1_Msk = 0xf
	// Position of MON10 field.
	RTC_RMONAR_MON10_Pos = 0x4
	// Bit mask of MON10 field.
	RTC_RMONAR_MON10_Msk = 0x10
	// Bit MON10.
	RTC_RMONAR_MON10 = 0x10
	// Position of ENB field.
	RTC_RMONAR_ENB_Pos = 0x7
	// Bit mask of ENB field.
	RTC_RMONAR_ENB_Msk = 0x80
	// Bit ENB.
	RTC_RMONAR_ENB = 0x80
	// Do not compare register value with RMONCNT counter value
	RTC_RMONAR_ENB_0 = 0x0
	// Compare register value with RMONCNT counter value
	RTC_RMONAR_ENB_1 = 0x1

	// BCNT2AER: Binary Counter 2 Alarm Enable Register
	// Position of ENB field.
	RTC_BCNT2AER_ENB_Pos = 0x0
	// Bit mask of ENB field.
	RTC_BCNT2AER_ENB_Msk = 0xff

	// RYRAR: Year Alarm Register (in Calendar Count Mode)
	// Position of YR1 field.
	RTC_RYRAR_YR1_Pos = 0x0
	// Bit mask of YR1 field.
	RTC_RYRAR_YR1_Msk = 0xf
	// Position of YR10 field.
	RTC_RYRAR_YR10_Pos = 0x4
	// Bit mask of YR10 field.
	RTC_RYRAR_YR10_Msk = 0xf0

	// BCNT3AER: Binary Counter 3 Alarm Enable Register
	// Position of ENB field.
	RTC_BCNT3AER_ENB_Pos = 0x0
	// Bit mask of ENB field.
	RTC_BCNT3AER_ENB_Msk = 0xff

	// RYRAREN: Year Alarm Enable Register (in Calendar Count Mode)
	// Position of ENB field.
	RTC_RYRAREN_ENB_Pos = 0x7
	// Bit mask of ENB field.
	RTC_RYRAREN_ENB_Msk = 0x80
	// Bit ENB.
	RTC_RYRAREN_ENB = 0x80
	// Do not compare register value with the RYRCNT counter value
	RTC_RYRAREN_ENB_0 = 0x0
	// Compare register value with the RYRCNT counter value
	RTC_RYRAREN_ENB_1 = 0x1

	// RCR1: RTC Control Register 1
	// Position of AIE field.
	RTC_RCR1_AIE_Pos = 0x0
	// Bit mask of AIE field.
	RTC_RCR1_AIE_Msk = 0x1
	// Bit AIE.
	RTC_RCR1_AIE = 0x1
	// Disable alarm interrupt requests
	RTC_RCR1_AIE_0 = 0x0
	// Enable alarm interrupt requests
	RTC_RCR1_AIE_1 = 0x1
	// Position of CIE field.
	RTC_RCR1_CIE_Pos = 0x1
	// Bit mask of CIE field.
	RTC_RCR1_CIE_Msk = 0x2
	// Bit CIE.
	RTC_RCR1_CIE = 0x2
	// Disable carry interrupt requests
	RTC_RCR1_CIE_0 = 0x0
	// Enable carry interrupt requests
	RTC_RCR1_CIE_1 = 0x1
	// Position of PIE field.
	RTC_RCR1_PIE_Pos = 0x2
	// Bit mask of PIE field.
	RTC_RCR1_PIE_Msk = 0x4
	// Bit PIE.
	RTC_RCR1_PIE = 0x4
	// Disable periodic interrupt requests
	RTC_RCR1_PIE_0 = 0x0
	// Enable periodic interrupt requests
	RTC_RCR1_PIE_1 = 0x1
	// Position of RTCOS field.
	RTC_RCR1_RTCOS_Pos = 0x3
	// Bit mask of RTCOS field.
	RTC_RCR1_RTCOS_Msk = 0x8
	// Bit RTCOS.
	RTC_RCR1_RTCOS = 0x8
	// Outputs 1 Hz on RTCOUT
	RTC_RCR1_RTCOS_0 = 0x0
	// Outputs 64 Hz RTCOUT
	RTC_RCR1_RTCOS_1 = 0x1
	// Position of PES field.
	RTC_RCR1_PES_Pos = 0x4
	// Bit mask of PES field.
	RTC_RCR1_PES_Msk = 0xf0
	// Generate periodic interrupt every 1/256 second
	RTC_RCR1_PES_0x6 = 0x6
	// Generate periodic interrupt every 1/128 second
	RTC_RCR1_PES_0x7 = 0x7
	// Generate periodic interrupt every 1/64 second
	RTC_RCR1_PES_0x8 = 0x8
	// Generate periodic interrupt every 1/32 second
	RTC_RCR1_PES_0x9 = 0x9
	// Generate periodic interrupt every 1/16 second
	RTC_RCR1_PES_0xA = 0xa
	// Generate periodic interrupt every 1/8 second
	RTC_RCR1_PES_0xB = 0xb
	// Generate periodic interrupt every 1/4 second
	RTC_RCR1_PES_0xC = 0xc
	// Generate periodic interrupt every 1/2 second
	RTC_RCR1_PES_0xD = 0xd
	// Generate periodic interrupt every 1 second
	RTC_RCR1_PES_0xE = 0xe
	// Generate periodic interrupt every 2 seconds
	RTC_RCR1_PES_0xF = 0xf

	// RCR2: RTC Control Register 2 (in Calendar Count Mode)
	// Position of START field.
	RTC_RCR2_START_Pos = 0x0
	// Bit mask of START field.
	RTC_RCR2_START_Msk = 0x1
	// Bit START.
	RTC_RCR2_START = 0x1
	// Stop prescaler and time counter
	RTC_RCR2_START_0 = 0x0
	// Operate prescaler and time counter normally
	RTC_RCR2_START_1 = 0x1
	// Position of RESET field.
	RTC_RCR2_RESET_Pos = 0x1
	// Bit mask of RESET field.
	RTC_RCR2_RESET_Msk = 0x2
	// Bit RESET.
	RTC_RCR2_RESET = 0x2
	// In writing: Invalid (writing 0 has no effect). In reading: Normal time operation in progress, or an RTC software reset has completed.
	RTC_RCR2_RESET_0 = 0x0
	// In writing: Initialize the prescaler and target registers for RTC software reset. In reading: RTC software reset in progress.
	RTC_RCR2_RESET_1 = 0x1
	// Position of ADJ30 field.
	RTC_RCR2_ADJ30_Pos = 0x2
	// Bit mask of ADJ30 field.
	RTC_RCR2_ADJ30_Msk = 0x4
	// Bit ADJ30.
	RTC_RCR2_ADJ30 = 0x4
	// In writing: Invalid (writing 0 has no effect). In reading: Normal time operation in progress, or 30-second adjustment has completed.
	RTC_RCR2_ADJ30_0 = 0x0
	// In writing: Execute 30-second adjustment. In reading: 30-second adjustment in progress.
	RTC_RCR2_ADJ30_1 = 0x1
	// Position of RTCOE field.
	RTC_RCR2_RTCOE_Pos = 0x3
	// Bit mask of RTCOE field.
	RTC_RCR2_RTCOE_Msk = 0x8
	// Bit RTCOE.
	RTC_RCR2_RTCOE = 0x8
	// Disable RTCOUT output
	RTC_RCR2_RTCOE_0 = 0x0
	// Enable RTCOUT output
	RTC_RCR2_RTCOE_1 = 0x1
	// Position of AADJE field.
	RTC_RCR2_AADJE_Pos = 0x4
	// Bit mask of AADJE field.
	RTC_RCR2_AADJE_Msk = 0x10
	// Bit AADJE.
	RTC_RCR2_AADJE = 0x10
	// Disable automatic adjustment
	RTC_RCR2_AADJE_0 = 0x0
	// Enable automatic adjustment
	RTC_RCR2_AADJE_1 = 0x1
	// Position of AADJP field.
	RTC_RCR2_AADJP_Pos = 0x5
	// Bit mask of AADJP field.
	RTC_RCR2_AADJP_Msk = 0x20
	// Bit AADJP.
	RTC_RCR2_AADJP = 0x20
	// In normal operation mode, adjust RADJ.ADJ[5:0] setting from the count value of the prescaler every minute. In low-consumption clock mode, adjust RADJ.ADJ[5:0] setting from the count value of the 64-Hz counter every day.
	RTC_RCR2_AADJP_0 = 0x0
	// In normal operation mode, adjust RADJ.ADJ[5:0] setting from the count value of the prescaler every 10 seconds. In low-consumption clock mode, adjust RADJ.ADJ[5:0] setting from the count value of the 64-Hz counter every hour.
	RTC_RCR2_AADJP_1 = 0x1
	// Position of HR24 field.
	RTC_RCR2_HR24_Pos = 0x6
	// Bit mask of HR24 field.
	RTC_RCR2_HR24_Msk = 0x40
	// Bit HR24.
	RTC_RCR2_HR24 = 0x40
	// Operate RTC in 12-hour mode
	RTC_RCR2_HR24_0 = 0x0
	// Operate RTC in 24-hour mode
	RTC_RCR2_HR24_1 = 0x1
	// Position of CNTMD field.
	RTC_RCR2_CNTMD_Pos = 0x7
	// Bit mask of CNTMD field.
	RTC_RCR2_CNTMD_Msk = 0x80
	// Bit CNTMD.
	RTC_RCR2_CNTMD = 0x80
	// Calendar count mode
	RTC_RCR2_CNTMD_0 = 0x0
	// Binary count mode
	RTC_RCR2_CNTMD_1 = 0x1

	// RCR2_BCNT: RTC Control Register 2 (in Binary Count Mode)
	// Position of START field.
	RTC_RCR2_BCNT_START_Pos = 0x0
	// Bit mask of START field.
	RTC_RCR2_BCNT_START_Msk = 0x1
	// Bit START.
	RTC_RCR2_BCNT_START = 0x1
	// Stop the 32-bit binary counter, 64-Hz counter, and prescaler
	RTC_RCR2_BCNT_START_0 = 0x0
	// Operate the 32-bit binary counter, 64-Hz counter, and prescaler normally
	RTC_RCR2_BCNT_START_1 = 0x1
	// Position of RESET field.
	RTC_RCR2_BCNT_RESET_Pos = 0x1
	// Bit mask of RESET field.
	RTC_RCR2_BCNT_RESET_Msk = 0x2
	// Bit RESET.
	RTC_RCR2_BCNT_RESET = 0x2
	// In writing: Invalid (writing 0 has no effect). In reading: Normal time operation in progress, or an RTC software reset has completed.
	RTC_RCR2_BCNT_RESET_0 = 0x0
	// In writing: Initialize the prescaler and target registers for RTC software reset. In reading: RTC software reset in progress.
	RTC_RCR2_BCNT_RESET_1 = 0x1
	// Position of RTCOE field.
	RTC_RCR2_BCNT_RTCOE_Pos = 0x3
	// Bit mask of RTCOE field.
	RTC_RCR2_BCNT_RTCOE_Msk = 0x8
	// Bit RTCOE.
	RTC_RCR2_BCNT_RTCOE = 0x8
	// Disable RTCOUT output
	RTC_RCR2_BCNT_RTCOE_0 = 0x0
	// Enable RTCOUT output
	RTC_RCR2_BCNT_RTCOE_1 = 0x1
	// Position of AADJE field.
	RTC_RCR2_BCNT_AADJE_Pos = 0x4
	// Bit mask of AADJE field.
	RTC_RCR2_BCNT_AADJE_Msk = 0x10
	// Bit AADJE.
	RTC_RCR2_BCNT_AADJE = 0x10
	// Disable automatic adjustment
	RTC_RCR2_BCNT_AADJE_0 = 0x0
	// Enable automatic adjustment
	RTC_RCR2_BCNT_AADJE_1 = 0x1
	// Position of AADJP field.
	RTC_RCR2_BCNT_AADJP_Pos = 0x5
	// Bit mask of AADJP field.
	RTC_RCR2_BCNT_AADJP_Msk = 0x20
	// Bit AADJP.
	RTC_RCR2_BCNT_AADJP = 0x20
	// In normal operation mode, add or subtract the RADJ.ADJ[5:0] bits from the prescaler count value every 32 seconds. In low-consumption clock mode, add or subtract the RADJ.ADJ[5:0] bits from the 64-Hz counter count value every 8192 seconds.
	RTC_RCR2_BCNT_AADJP_0 = 0x0
	// In normal operation mode, add or subtract the RADJ.ADJ[5:0] bits from the prescaler count value every 8 seconds. In low-consumption clock mode, add or subtract the RADJ.ADJ[5:0] bits from the 64-Hz counter count value every 2048 seconds.
	RTC_RCR2_BCNT_AADJP_1 = 0x1
	// Position of CNTMD field.
	RTC_RCR2_BCNT_CNTMD_Pos = 0x7
	// Bit mask of CNTMD field.
	RTC_RCR2_BCNT_CNTMD_Msk = 0x80
	// Bit CNTMD.
	RTC_RCR2_BCNT_CNTMD = 0x80
	// Calendar count mode
	RTC_RCR2_BCNT_CNTMD_0 = 0x0
	// Binary count mode
	RTC_RCR2_BCNT_CNTMD_1 = 0x1

	// RCR4: RTC Control Register 4
	// Position of RCKSEL field.
	RTC_RCR4_RCKSEL_Pos = 0x0
	// Bit mask of RCKSEL field.
	RTC_RCR4_RCKSEL_Msk = 0x1
	// Bit RCKSEL.
	RTC_RCR4_RCKSEL = 0x1
	// Sub-clock oscillator is selected
	RTC_RCR4_RCKSEL_0 = 0x0
	// LOCO is selected
	RTC_RCR4_RCKSEL_1 = 0x1
	// Position of ROPSEL field.
	RTC_RCR4_ROPSEL_Pos = 0x7
	// Bit mask of ROPSEL field.
	RTC_RCR4_ROPSEL_Msk = 0x80
	// Bit ROPSEL.
	RTC_RCR4_ROPSEL = 0x80
	// Normal operation mode is selected.
	RTC_RCR4_ROPSEL_0 = 0x0
	// Low-consumption clock mode is selected.
	RTC_RCR4_ROPSEL_1 = 0x1

	// RFRH: Frequency Register H
	// Position of RFC16 field.
	RTC_RFRH_RFC16_Pos = 0x0
	// Bit mask of RFC16 field.
	RTC_RFRH_RFC16_Msk = 0x1
	// Bit RFC16.
	RTC_RFRH_RFC16 = 0x1

	// RFRL: Frequency Register L
	// Position of RFC field.
	RTC_RFRL_RFC_Pos = 0x0
	// Bit mask of RFC field.
	RTC_RFRL_RFC_Msk = 0xffff

	// RADJ: Time Error Adjustment Register
	// Position of ADJ field.
	RTC_RADJ_ADJ_Pos = 0x0
	// Bit mask of ADJ field.
	RTC_RADJ_ADJ_Msk = 0x3f
	// Position of PMADJ field.
	RTC_RADJ_PMADJ_Pos = 0x6
	// Bit mask of PMADJ field.
	RTC_RADJ_PMADJ_Msk = 0xc0
	// Do not perform adjustment.
	RTC_RADJ_PMADJ_00 = 0x0
	// In normal operation mode, adjustment is performed by the addition to the prescaler. In low-consumption clock mode, adjustment is performed by the addition to the 64-Hz counter.
	RTC_RADJ_PMADJ_01 = 0x1
	// In normal operation mode, adjustment is performed by the subtraction from the prescaler. In low-consumption clock mode, adjustment is performed by the subtraction from the 64-Hz counter.
	RTC_RADJ_PMADJ_10 = 0x2
	// Setting prohibited.
	RTC_RADJ_PMADJ_11 = 0x3
)

// Constants for WDT: Watchdog Timer
const (
	// WDTCR: WDT Control Register
	// Position of TOPS field.
	WDT_WDTCR_TOPS_Pos = 0x0
	// Bit mask of TOPS field.
	WDT_WDTCR_TOPS_Msk = 0x3
	// 1024 cycles (0x03FF)
	WDT_WDTCR_TOPS_00 = 0x0
	// 4096 cycles (0x0FFF)
	WDT_WDTCR_TOPS_01 = 0x1
	// 8192 cycles (0x1FFF)
	WDT_WDTCR_TOPS_10 = 0x2
	// 16384 cycles (0x3FFF)
	WDT_WDTCR_TOPS_11 = 0x3
	// Position of CKS field.
	WDT_WDTCR_CKS_Pos = 0x4
	// Bit mask of CKS field.
	WDT_WDTCR_CKS_Msk = 0xf0
	// PCLKB/4
	WDT_WDTCR_CKS_0x1 = 0x1
	// PCLKB/64
	WDT_WDTCR_CKS_0x4 = 0x4
	// PCLKB/128
	WDT_WDTCR_CKS_0xF = 0xf
	// PCLKB/512
	WDT_WDTCR_CKS_0x6 = 0x6
	// PCLKB/2048
	WDT_WDTCR_CKS_0x7 = 0x7
	// PCLKB/8192
	WDT_WDTCR_CKS_0x8 = 0x8
	// Position of RPES field.
	WDT_WDTCR_RPES_Pos = 0x8
	// Bit mask of RPES field.
	WDT_WDTCR_RPES_Msk = 0x300
	// 75%
	WDT_WDTCR_RPES_00 = 0x0
	// 50%
	WDT_WDTCR_RPES_01 = 0x1
	// 25%
	WDT_WDTCR_RPES_10 = 0x2
	// 0% (do not specify window end position).
	WDT_WDTCR_RPES_11 = 0x3
	// Position of RPSS field.
	WDT_WDTCR_RPSS_Pos = 0xc
	// Bit mask of RPSS field.
	WDT_WDTCR_RPSS_Msk = 0x3000
	// 25%
	WDT_WDTCR_RPSS_00 = 0x0
	// 50%
	WDT_WDTCR_RPSS_01 = 0x1
	// 75%
	WDT_WDTCR_RPSS_10 = 0x2
	// 100% (do not specify window start position).
	WDT_WDTCR_RPSS_11 = 0x3

	// WDTSR: WDT Status Register
	// Position of CNTVAL field.
	WDT_WDTSR_CNTVAL_Pos = 0x0
	// Bit mask of CNTVAL field.
	WDT_WDTSR_CNTVAL_Msk = 0x3fff
	// Position of UNDFF field.
	WDT_WDTSR_UNDFF_Pos = 0xe
	// Bit mask of UNDFF field.
	WDT_WDTSR_UNDFF_Msk = 0x4000
	// Bit UNDFF.
	WDT_WDTSR_UNDFF = 0x4000
	// No underflow occurred
	WDT_WDTSR_UNDFF_0 = 0x0
	// Underflow occurred
	WDT_WDTSR_UNDFF_1 = 0x1
	// Position of REFEF field.
	WDT_WDTSR_REFEF_Pos = 0xf
	// Bit mask of REFEF field.
	WDT_WDTSR_REFEF_Msk = 0x8000
	// Bit REFEF.
	WDT_WDTSR_REFEF = 0x8000
	// No refresh error occurred
	WDT_WDTSR_REFEF_0 = 0x0
	// Refresh error occurred
	WDT_WDTSR_REFEF_1 = 0x1

	// WDTRCR: WDT Reset Control Register
	// Position of RSTIRQS field.
	WDT_WDTRCR_RSTIRQS_Pos = 0x7
	// Bit mask of RSTIRQS field.
	WDT_WDTRCR_RSTIRQS_Msk = 0x80
	// Bit RSTIRQS.
	WDT_WDTRCR_RSTIRQS = 0x80
	// Interrupt
	WDT_WDTRCR_RSTIRQS_0 = 0x0
	// Reset
	WDT_WDTRCR_RSTIRQS_1 = 0x1

	// WDTCSTPR: WDT Count Stop Control Register
	// Position of SLCSTP field.
	WDT_WDTCSTPR_SLCSTP_Pos = 0x7
	// Bit mask of SLCSTP field.
	WDT_WDTCSTPR_SLCSTP_Msk = 0x80
	// Bit SLCSTP.
	WDT_WDTCSTPR_SLCSTP = 0x80
	// Disable count stop
	WDT_WDTCSTPR_SLCSTP_0 = 0x0
	// Stop count on transition to Sleep mode
	WDT_WDTCSTPR_SLCSTP_1 = 0x1
)

// Constants for IWDT: Independent Watchdog Timer
const (
	// IWDTSR: IWDT Status Register
	// Position of CNTVAL field.
	IWDT_IWDTSR_CNTVAL_Pos = 0x0
	// Bit mask of CNTVAL field.
	IWDT_IWDTSR_CNTVAL_Msk = 0x3fff
	// Position of UNDFF field.
	IWDT_IWDTSR_UNDFF_Pos = 0xe
	// Bit mask of UNDFF field.
	IWDT_IWDTSR_UNDFF_Msk = 0x4000
	// Bit UNDFF.
	IWDT_IWDTSR_UNDFF = 0x4000
	// No underflow occurred
	IWDT_IWDTSR_UNDFF_0 = 0x0
	// Underflow occurred
	IWDT_IWDTSR_UNDFF_1 = 0x1
	// Position of REFEF field.
	IWDT_IWDTSR_REFEF_Pos = 0xf
	// Bit mask of REFEF field.
	IWDT_IWDTSR_REFEF_Msk = 0x8000
	// Bit REFEF.
	IWDT_IWDTSR_REFEF = 0x8000
	// No refresh error occurred
	IWDT_IWDTSR_REFEF_0 = 0x0
	// Refresh error occurred
	IWDT_IWDTSR_REFEF_1 = 0x1
)

// Constants for CAC: Clock Frequency Accuracy Measurement Circuit
const (
	// CACR0: CAC Control Register 0
	// Position of CFME field.
	CAC_CACR0_CFME_Pos = 0x0
	// Bit mask of CFME field.
	CAC_CACR0_CFME_Msk = 0x1
	// Bit CFME.
	CAC_CACR0_CFME = 0x1
	// Disable
	CAC_CACR0_CFME_0 = 0x0
	// Enable
	CAC_CACR0_CFME_1 = 0x1

	// CACR1: CAC Control Register 1
	// Position of CACREFE field.
	CAC_CACR1_CACREFE_Pos = 0x0
	// Bit mask of CACREFE field.
	CAC_CACR1_CACREFE_Msk = 0x1
	// Bit CACREFE.
	CAC_CACR1_CACREFE = 0x1
	// Disable
	CAC_CACR1_CACREFE_0 = 0x0
	// Enable
	CAC_CACR1_CACREFE_1 = 0x1
	// Position of FMCS field.
	CAC_CACR1_FMCS_Pos = 0x1
	// Bit mask of FMCS field.
	CAC_CACR1_FMCS_Msk = 0xe
	// Main clock oscillator
	CAC_CACR1_FMCS_000 = 0x0
	// Sub-clock oscillator
	CAC_CACR1_FMCS_001 = 0x1
	// HOCO clock
	CAC_CACR1_FMCS_010 = 0x2
	// MOCO
	CAC_CACR1_FMCS_011 = 0x3
	// LOCO clock
	CAC_CACR1_FMCS_100 = 0x4
	// Peripheral module clock B (PCLKB)
	CAC_CACR1_FMCS_101 = 0x5
	// IWDT-dedicated clock
	CAC_CACR1_FMCS_110 = 0x6
	// Setting prohibited
	CAC_CACR1_FMCS_111 = 0x7
	// Position of TCSS field.
	CAC_CACR1_TCSS_Pos = 0x4
	// Bit mask of TCSS field.
	CAC_CACR1_TCSS_Msk = 0x30
	// No division
	CAC_CACR1_TCSS_00 = 0x0
	// x 1/4 clock
	CAC_CACR1_TCSS_01 = 0x1
	// x 1/8 clock
	CAC_CACR1_TCSS_10 = 0x2
	// x 1/32 clock
	CAC_CACR1_TCSS_11 = 0x3
	// Position of EDGES field.
	CAC_CACR1_EDGES_Pos = 0x6
	// Bit mask of EDGES field.
	CAC_CACR1_EDGES_Msk = 0xc0
	// Rising edge
	CAC_CACR1_EDGES_00 = 0x0
	// Falling edge
	CAC_CACR1_EDGES_01 = 0x1
	// Both rising and falling edges
	CAC_CACR1_EDGES_10 = 0x2
	// Setting prohibited
	CAC_CACR1_EDGES_11 = 0x3

	// CACR2: CAC Control Register 2
	// Position of RPS field.
	CAC_CACR2_RPS_Pos = 0x0
	// Bit mask of RPS field.
	CAC_CACR2_RPS_Msk = 0x1
	// Bit RPS.
	CAC_CACR2_RPS = 0x1
	// CACREF pin input
	CAC_CACR2_RPS_0 = 0x0
	// Internal clock (internally generated signal)
	CAC_CACR2_RPS_1 = 0x1
	// Position of RSCS field.
	CAC_CACR2_RSCS_Pos = 0x1
	// Bit mask of RSCS field.
	CAC_CACR2_RSCS_Msk = 0xe
	// Main clock oscillator
	CAC_CACR2_RSCS_000 = 0x0
	// Sub-clock oscillator
	CAC_CACR2_RSCS_001 = 0x1
	// HOCO clock
	CAC_CACR2_RSCS_010 = 0x2
	// MOCO
	CAC_CACR2_RSCS_011 = 0x3
	// LOCO clock
	CAC_CACR2_RSCS_100 = 0x4
	// Peripheral module clock B (PCLKB)
	CAC_CACR2_RSCS_101 = 0x5
	// IWDT-dedicated clock
	CAC_CACR2_RSCS_110 = 0x6
	// Setting prohibited
	CAC_CACR2_RSCS_111 = 0x7
	// Position of RCDS field.
	CAC_CACR2_RCDS_Pos = 0x4
	// Bit mask of RCDS field.
	CAC_CACR2_RCDS_Msk = 0x30
	// x 1/32 clock
	CAC_CACR2_RCDS_00 = 0x0
	// x 1/128 clock
	CAC_CACR2_RCDS_01 = 0x1
	// x 1/1024 clock
	CAC_CACR2_RCDS_10 = 0x2
	// x 1/8192 clock
	CAC_CACR2_RCDS_11 = 0x3
	// Position of DFS field.
	CAC_CACR2_DFS_Pos = 0x6
	// Bit mask of DFS field.
	CAC_CACR2_DFS_Msk = 0xc0
	// Disable digital filtering
	CAC_CACR2_DFS_00 = 0x0
	// Use sampling clock for the digital filter as the frequency measuring clock
	CAC_CACR2_DFS_01 = 0x1
	// Use sampling clock for the digital filter as the frequency measuring clock divided by 4
	CAC_CACR2_DFS_10 = 0x2
	// Use sampling clock for the digital filter as the frequency measuring clock divided by 16.
	CAC_CACR2_DFS_11 = 0x3

	// CAICR: CAC Interrupt Control Register
	// Position of FERRIE field.
	CAC_CAICR_FERRIE_Pos = 0x0
	// Bit mask of FERRIE field.
	CAC_CAICR_FERRIE_Msk = 0x1
	// Bit FERRIE.
	CAC_CAICR_FERRIE = 0x1
	// Disable
	CAC_CAICR_FERRIE_0 = 0x0
	// Enable
	CAC_CAICR_FERRIE_1 = 0x1
	// Position of MENDIE field.
	CAC_CAICR_MENDIE_Pos = 0x1
	// Bit mask of MENDIE field.
	CAC_CAICR_MENDIE_Msk = 0x2
	// Bit MENDIE.
	CAC_CAICR_MENDIE = 0x2
	// Disable
	CAC_CAICR_MENDIE_0 = 0x0
	// Enable
	CAC_CAICR_MENDIE_1 = 0x1
	// Position of OVFIE field.
	CAC_CAICR_OVFIE_Pos = 0x2
	// Bit mask of OVFIE field.
	CAC_CAICR_OVFIE_Msk = 0x4
	// Bit OVFIE.
	CAC_CAICR_OVFIE = 0x4
	// Disable
	CAC_CAICR_OVFIE_0 = 0x0
	// Enable
	CAC_CAICR_OVFIE_1 = 0x1
	// Position of FERRFCL field.
	CAC_CAICR_FERRFCL_Pos = 0x4
	// Bit mask of FERRFCL field.
	CAC_CAICR_FERRFCL_Msk = 0x10
	// Bit FERRFCL.
	CAC_CAICR_FERRFCL = 0x10
	// No effect
	CAC_CAICR_FERRFCL_0 = 0x0
	// The CASTR.FERRF flag is cleared
	CAC_CAICR_FERRFCL_1 = 0x1
	// Position of MENDFCL field.
	CAC_CAICR_MENDFCL_Pos = 0x5
	// Bit mask of MENDFCL field.
	CAC_CAICR_MENDFCL_Msk = 0x20
	// Bit MENDFCL.
	CAC_CAICR_MENDFCL = 0x20
	// No effect
	CAC_CAICR_MENDFCL_0 = 0x0
	// The CASTR.MENDF flag is cleared
	CAC_CAICR_MENDFCL_1 = 0x1
	// Position of OVFFCL field.
	CAC_CAICR_OVFFCL_Pos = 0x6
	// Bit mask of OVFFCL field.
	CAC_CAICR_OVFFCL_Msk = 0x40
	// Bit OVFFCL.
	CAC_CAICR_OVFFCL = 0x40
	// No effect
	CAC_CAICR_OVFFCL_0 = 0x0
	// The CASTR.OVFF flag is cleared.
	CAC_CAICR_OVFFCL_1 = 0x1

	// CASTR: CAC Status Register
	// Position of FERRF field.
	CAC_CASTR_FERRF_Pos = 0x0
	// Bit mask of FERRF field.
	CAC_CASTR_FERRF_Msk = 0x1
	// Bit FERRF.
	CAC_CASTR_FERRF = 0x1
	// Clock frequency is within the allowable range
	CAC_CASTR_FERRF_0 = 0x0
	// Clock frequency has deviated beyond the allowable range (frequency error).
	CAC_CASTR_FERRF_1 = 0x1
	// Position of MENDF field.
	CAC_CASTR_MENDF_Pos = 0x1
	// Bit mask of MENDF field.
	CAC_CASTR_MENDF_Msk = 0x2
	// Bit MENDF.
	CAC_CASTR_MENDF = 0x2
	// Measurement is in progress
	CAC_CASTR_MENDF_0 = 0x0
	// Measurement ended
	CAC_CASTR_MENDF_1 = 0x1
	// Position of OVFF field.
	CAC_CASTR_OVFF_Pos = 0x2
	// Bit mask of OVFF field.
	CAC_CASTR_OVFF_Msk = 0x4
	// Bit OVFF.
	CAC_CASTR_OVFF = 0x4
	// Counter has not overflowed
	CAC_CASTR_OVFF_0 = 0x0
	// Counter overflowed
	CAC_CASTR_OVFF_1 = 0x1
)

// Constants for MSTP: Module Stop Control B, C, D
const (
	// MSTPCRB: Module Stop Control Register B
	// Position of MSTPB9 field.
	MSTP_MSTPCRB_MSTPB9_Pos = 0x9
	// Bit mask of MSTPB9 field.
	MSTP_MSTPCRB_MSTPB9_Msk = 0x200
	// Bit MSTPB9.
	MSTP_MSTPCRB_MSTPB9 = 0x200
	// Cancel the module-stop state
	MSTP_MSTPCRB_MSTPB9_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRB_MSTPB9_1 = 0x1
	// Position of MSTPB19 field.
	MSTP_MSTPCRB_MSTPB19_Pos = 0x13
	// Bit mask of MSTPB19 field.
	MSTP_MSTPCRB_MSTPB19_Msk = 0x80000
	// Bit MSTPB19.
	MSTP_MSTPCRB_MSTPB19 = 0x80000
	// Cancel the module-stop state
	MSTP_MSTPCRB_MSTPB19_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRB_MSTPB19_1 = 0x1
	// Position of MSTPB22 field.
	MSTP_MSTPCRB_MSTPB22_Pos = 0x16
	// Bit mask of MSTPB22 field.
	MSTP_MSTPCRB_MSTPB22_Msk = 0x400000
	// Bit MSTPB22.
	MSTP_MSTPCRB_MSTPB22 = 0x400000
	// Cancel the module-stop state
	MSTP_MSTPCRB_MSTPB22_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRB_MSTPB22_1 = 0x1
	// Position of MSTPB29 field.
	MSTP_MSTPCRB_MSTPB29_Pos = 0x1d
	// Bit mask of MSTPB29 field.
	MSTP_MSTPCRB_MSTPB29_Msk = 0x20000000
	// Bit MSTPB29.
	MSTP_MSTPCRB_MSTPB29 = 0x20000000
	// Cancel the module-stop state
	MSTP_MSTPCRB_MSTPB29_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRB_MSTPB29_1 = 0x1
	// Position of MSTPB30 field.
	MSTP_MSTPCRB_MSTPB30_Pos = 0x1e
	// Bit mask of MSTPB30 field.
	MSTP_MSTPCRB_MSTPB30_Msk = 0x40000000
	// Bit MSTPB30.
	MSTP_MSTPCRB_MSTPB30 = 0x40000000
	// Cancel the module-stop state
	MSTP_MSTPCRB_MSTPB30_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRB_MSTPB30_1 = 0x1
	// Position of MSTPB31 field.
	MSTP_MSTPCRB_MSTPB31_Pos = 0x1f
	// Bit mask of MSTPB31 field.
	MSTP_MSTPCRB_MSTPB31_Msk = 0x80000000
	// Bit MSTPB31.
	MSTP_MSTPCRB_MSTPB31 = 0x80000000
	// Cancel the module-stop state
	MSTP_MSTPCRB_MSTPB31_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRB_MSTPB31_1 = 0x1

	// MSTPCRC: Module Stop Control Register C
	// Position of MSTPC0 field.
	MSTP_MSTPCRC_MSTPC0_Pos = 0x0
	// Bit mask of MSTPC0 field.
	MSTP_MSTPCRC_MSTPC0_Msk = 0x1
	// Bit MSTPC0.
	MSTP_MSTPCRC_MSTPC0 = 0x1
	// Cancel the module-stop state
	MSTP_MSTPCRC_MSTPC0_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRC_MSTPC0_1 = 0x1
	// Position of MSTPC1 field.
	MSTP_MSTPCRC_MSTPC1_Pos = 0x1
	// Bit mask of MSTPC1 field.
	MSTP_MSTPCRC_MSTPC1_Msk = 0x2
	// Bit MSTPC1.
	MSTP_MSTPCRC_MSTPC1 = 0x2
	// Cancel the module-stop state
	MSTP_MSTPCRC_MSTPC1_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRC_MSTPC1_1 = 0x1
	// Position of MSTPC3 field.
	MSTP_MSTPCRC_MSTPC3_Pos = 0x3
	// Bit mask of MSTPC3 field.
	MSTP_MSTPCRC_MSTPC3_Msk = 0x8
	// Bit MSTPC3.
	MSTP_MSTPCRC_MSTPC3 = 0x8
	// Cancel the module-stop state
	MSTP_MSTPCRC_MSTPC3_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRC_MSTPC3_1 = 0x1
	// Position of MSTPC13 field.
	MSTP_MSTPCRC_MSTPC13_Pos = 0xd
	// Bit mask of MSTPC13 field.
	MSTP_MSTPCRC_MSTPC13_Msk = 0x2000
	// Bit MSTPC13.
	MSTP_MSTPCRC_MSTPC13 = 0x2000
	// Cancel the module-stop state
	MSTP_MSTPCRC_MSTPC13_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRC_MSTPC13_1 = 0x1
	// Position of MSTPC14 field.
	MSTP_MSTPCRC_MSTPC14_Pos = 0xe
	// Bit mask of MSTPC14 field.
	MSTP_MSTPCRC_MSTPC14_Msk = 0x4000
	// Bit MSTPC14.
	MSTP_MSTPCRC_MSTPC14 = 0x4000
	// Cancel the module-stop state
	MSTP_MSTPCRC_MSTPC14_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRC_MSTPC14_1 = 0x1
	// Position of MSTPC28 field.
	MSTP_MSTPCRC_MSTPC28_Pos = 0x1c
	// Bit mask of MSTPC28 field.
	MSTP_MSTPCRC_MSTPC28_Msk = 0x10000000
	// Bit MSTPC28.
	MSTP_MSTPCRC_MSTPC28 = 0x10000000
	// Cancel the module-stop state
	MSTP_MSTPCRC_MSTPC28_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRC_MSTPC28_1 = 0x1
	// Position of MSTPC31 field.
	MSTP_MSTPCRC_MSTPC31_Pos = 0x1f
	// Bit mask of MSTPC31 field.
	MSTP_MSTPCRC_MSTPC31_Msk = 0x80000000
	// Bit MSTPC31.
	MSTP_MSTPCRC_MSTPC31 = 0x80000000
	// Cancel the module-stop state
	MSTP_MSTPCRC_MSTPC31_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRC_MSTPC31_1 = 0x1

	// MSTPCRD: Module Stop Control Register D
	// Position of MSTPD2 field.
	MSTP_MSTPCRD_MSTPD2_Pos = 0x2
	// Bit mask of MSTPD2 field.
	MSTP_MSTPCRD_MSTPD2_Msk = 0x4
	// Bit MSTPD2.
	MSTP_MSTPCRD_MSTPD2 = 0x4
	// Cancel the module-stop state
	MSTP_MSTPCRD_MSTPD2_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRD_MSTPD2_1 = 0x1
	// Position of MSTPD3 field.
	MSTP_MSTPCRD_MSTPD3_Pos = 0x3
	// Bit mask of MSTPD3 field.
	MSTP_MSTPCRD_MSTPD3_Msk = 0x8
	// Bit MSTPD3.
	MSTP_MSTPCRD_MSTPD3 = 0x8
	// Cancel the module-stop state
	MSTP_MSTPCRD_MSTPD3_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRD_MSTPD3_1 = 0x1
	// Position of MSTPD5 field.
	MSTP_MSTPCRD_MSTPD5_Pos = 0x5
	// Bit mask of MSTPD5 field.
	MSTP_MSTPCRD_MSTPD5_Msk = 0x20
	// Bit MSTPD5.
	MSTP_MSTPCRD_MSTPD5 = 0x20
	// Cancel the module-stop state
	MSTP_MSTPCRD_MSTPD5_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRD_MSTPD5_1 = 0x1
	// Position of MSTPD6 field.
	MSTP_MSTPCRD_MSTPD6_Pos = 0x6
	// Bit mask of MSTPD6 field.
	MSTP_MSTPCRD_MSTPD6_Msk = 0x40
	// Bit MSTPD6.
	MSTP_MSTPCRD_MSTPD6 = 0x40
	// Cancel the module-stop state
	MSTP_MSTPCRD_MSTPD6_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRD_MSTPD6_1 = 0x1
	// Position of MSTPD14 field.
	MSTP_MSTPCRD_MSTPD14_Pos = 0xe
	// Bit mask of MSTPD14 field.
	MSTP_MSTPCRD_MSTPD14_Msk = 0x4000
	// Bit MSTPD14.
	MSTP_MSTPCRD_MSTPD14 = 0x4000
	// Cancel the module-stop state
	MSTP_MSTPCRD_MSTPD14_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRD_MSTPD14_1 = 0x1
	// Position of MSTPD16 field.
	MSTP_MSTPCRD_MSTPD16_Pos = 0x10
	// Bit mask of MSTPD16 field.
	MSTP_MSTPCRD_MSTPD16_Msk = 0x10000
	// Bit MSTPD16.
	MSTP_MSTPCRD_MSTPD16 = 0x10000
	// Cancel the module-stop state
	MSTP_MSTPCRD_MSTPD16_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRD_MSTPD16_1 = 0x1
	// Position of MSTPD29 field.
	MSTP_MSTPCRD_MSTPD29_Pos = 0x1d
	// Bit mask of MSTPD29 field.
	MSTP_MSTPCRD_MSTPD29_Msk = 0x20000000
	// Bit MSTPD29.
	MSTP_MSTPCRD_MSTPD29 = 0x20000000
	// Cancel the module-stop state
	MSTP_MSTPCRD_MSTPD29_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRD_MSTPD29_1 = 0x1

	// LSMRWDIS: Low Speed Module R/W Disable Control Register
	// Position of RTCRWDIS field.
	MSTP_LSMRWDIS_RTCRWDIS_Pos = 0x0
	// Bit mask of RTCRWDIS field.
	MSTP_LSMRWDIS_RTCRWDIS_Msk = 0x1
	// Bit RTCRWDIS.
	MSTP_LSMRWDIS_RTCRWDIS = 0x1
	// RTC register R/W clock always on
	MSTP_LSMRWDIS_RTCRWDIS_0 = 0x0
	// RTC register R/W clock stops
	MSTP_LSMRWDIS_RTCRWDIS_1 = 0x1
	// Position of WDTDIS field.
	MSTP_LSMRWDIS_WDTDIS_Pos = 0x1
	// Bit mask of WDTDIS field.
	MSTP_LSMRWDIS_WDTDIS_Msk = 0x2
	// Bit WDTDIS.
	MSTP_LSMRWDIS_WDTDIS = 0x2
	// WDT operates as normal
	MSTP_LSMRWDIS_WDTDIS_0 = 0x0
	// Stop the WDT clock and register R/W clock
	MSTP_LSMRWDIS_WDTDIS_1 = 0x1
	// Position of IWDTIDS field.
	MSTP_LSMRWDIS_IWDTIDS_Pos = 0x2
	// Bit mask of IWDTIDS field.
	MSTP_LSMRWDIS_IWDTIDS_Msk = 0x4
	// Bit IWDTIDS.
	MSTP_LSMRWDIS_IWDTIDS = 0x4
	// IWDT operates as normal
	MSTP_LSMRWDIS_IWDTIDS_0 = 0x0
	// Stop the IWDT register R/W clock
	MSTP_LSMRWDIS_IWDTIDS_1 = 0x1
	// Position of WREN field.
	MSTP_LSMRWDIS_WREN_Pos = 0x7
	// Bit mask of WREN field.
	MSTP_LSMRWDIS_WREN_Msk = 0x80
	// Bit WREN.
	MSTP_LSMRWDIS_WREN = 0x80
	// Write protect for bits [2:0]
	MSTP_LSMRWDIS_WREN_0 = 0x0
	// Write enable for bits [2:0]
	MSTP_LSMRWDIS_WREN_1 = 0x1
	// Position of PRKEY field.
	MSTP_LSMRWDIS_PRKEY_Pos = 0x8
	// Bit mask of PRKEY field.
	MSTP_LSMRWDIS_PRKEY_Msk = 0xff00
)

// Constants for IIC0: Inter-Integrated Circuit 0
const (
	// ICCR1: I2C Bus Control Register 1
	// Position of SDAI field.
	IIC0_ICCR1_SDAI_Pos = 0x0
	// Bit mask of SDAI field.
	IIC0_ICCR1_SDAI_Msk = 0x1
	// Bit SDAI.
	IIC0_ICCR1_SDAI = 0x1
	// SDA0 line is low
	IIC0_ICCR1_SDAI_0 = 0x0
	// SDA0 line is high
	IIC0_ICCR1_SDAI_1 = 0x1
	// Position of SCLI field.
	IIC0_ICCR1_SCLI_Pos = 0x1
	// Bit mask of SCLI field.
	IIC0_ICCR1_SCLI_Msk = 0x2
	// Bit SCLI.
	IIC0_ICCR1_SCLI = 0x2
	// SCL0 line is low
	IIC0_ICCR1_SCLI_0 = 0x0
	// SCL0 line is high
	IIC0_ICCR1_SCLI_1 = 0x1
	// Position of SDAO field.
	IIC0_ICCR1_SDAO_Pos = 0x2
	// Bit mask of SDAO field.
	IIC0_ICCR1_SDAO_Msk = 0x4
	// Bit SDAO.
	IIC0_ICCR1_SDAO = 0x4
	// Read: IIC drives SDA0 pin low Write: IIC drives SDA0 pin low
	IIC0_ICCR1_SDAO_0 = 0x0
	// Read: IIC releases SDA0 pin Write: IIC releases SDA0 pin
	IIC0_ICCR1_SDAO_1 = 0x1
	// Position of SCLO field.
	IIC0_ICCR1_SCLO_Pos = 0x3
	// Bit mask of SCLO field.
	IIC0_ICCR1_SCLO_Msk = 0x8
	// Bit SCLO.
	IIC0_ICCR1_SCLO = 0x8
	// Read: IIC drives SCL0 pin low Write: IIC drives SCL0 pin low
	IIC0_ICCR1_SCLO_0 = 0x0
	// Read: IIC releases SCL0 pin Write: IIC releases SCL0 pin
	IIC0_ICCR1_SCLO_1 = 0x1
	// Position of SOWP field.
	IIC0_ICCR1_SOWP_Pos = 0x4
	// Bit mask of SOWP field.
	IIC0_ICCR1_SOWP_Msk = 0x10
	// Bit SOWP.
	IIC0_ICCR1_SOWP = 0x10
	// Write enable SCLO and SDAO bits
	IIC0_ICCR1_SOWP_0 = 0x0
	// Write protect SCLO and SDAO bits
	IIC0_ICCR1_SOWP_1 = 0x1
	// Position of CLO field.
	IIC0_ICCR1_CLO_Pos = 0x5
	// Bit mask of CLO field.
	IIC0_ICCR1_CLO_Msk = 0x20
	// Bit CLO.
	IIC0_ICCR1_CLO = 0x20
	// Do not output extra SCL clock cycle (default)
	IIC0_ICCR1_CLO_0 = 0x0
	// Output extra SCL clock cycle
	IIC0_ICCR1_CLO_1 = 0x1
	// Position of IICRST field.
	IIC0_ICCR1_IICRST_Pos = 0x6
	// Bit mask of IICRST field.
	IIC0_ICCR1_IICRST_Msk = 0x40
	// Bit IICRST.
	IIC0_ICCR1_IICRST = 0x40
	// Release IIC reset or internal reset
	IIC0_ICCR1_IICRST_0 = 0x0
	// Initiate IIC reset or internal reset
	IIC0_ICCR1_IICRST_1 = 0x1
	// Position of ICE field.
	IIC0_ICCR1_ICE_Pos = 0x7
	// Bit mask of ICE field.
	IIC0_ICCR1_ICE_Msk = 0x80
	// Bit ICE.
	IIC0_ICCR1_ICE = 0x80
	// Disable (SCL0 and SDA0 pins in inactive state)
	IIC0_ICCR1_ICE_0 = 0x0
	// Enable (SCL0 and SDA0 pins in active state)
	IIC0_ICCR1_ICE_1 = 0x1

	// ICCR2: I2C Bus Control Register 2
	// Position of ST field.
	IIC0_ICCR2_ST_Pos = 0x1
	// Bit mask of ST field.
	IIC0_ICCR2_ST_Msk = 0x2
	// Bit ST.
	IIC0_ICCR2_ST = 0x2
	// Do not issue a start condition request
	IIC0_ICCR2_ST_0 = 0x0
	// Issue a start condition request
	IIC0_ICCR2_ST_1 = 0x1
	// Position of RS field.
	IIC0_ICCR2_RS_Pos = 0x2
	// Bit mask of RS field.
	IIC0_ICCR2_RS_Msk = 0x4
	// Bit RS.
	IIC0_ICCR2_RS = 0x4
	// Do not issue a restart condition request
	IIC0_ICCR2_RS_0 = 0x0
	// Issue a restart condition request
	IIC0_ICCR2_RS_1 = 0x1
	// Position of SP field.
	IIC0_ICCR2_SP_Pos = 0x3
	// Bit mask of SP field.
	IIC0_ICCR2_SP_Msk = 0x8
	// Bit SP.
	IIC0_ICCR2_SP = 0x8
	// Do not issue a stop condition request
	IIC0_ICCR2_SP_0 = 0x0
	// Issue a stop condition request
	IIC0_ICCR2_SP_1 = 0x1
	// Position of TRS field.
	IIC0_ICCR2_TRS_Pos = 0x5
	// Bit mask of TRS field.
	IIC0_ICCR2_TRS_Msk = 0x20
	// Bit TRS.
	IIC0_ICCR2_TRS = 0x20
	// Receive mode
	IIC0_ICCR2_TRS_0 = 0x0
	// Transmit mode
	IIC0_ICCR2_TRS_1 = 0x1
	// Position of MST field.
	IIC0_ICCR2_MST_Pos = 0x6
	// Bit mask of MST field.
	IIC0_ICCR2_MST_Msk = 0x40
	// Bit MST.
	IIC0_ICCR2_MST = 0x40
	// Slave mode
	IIC0_ICCR2_MST_0 = 0x0
	// Master mode
	IIC0_ICCR2_MST_1 = 0x1
	// Position of BBSY field.
	IIC0_ICCR2_BBSY_Pos = 0x7
	// Bit mask of BBSY field.
	IIC0_ICCR2_BBSY_Msk = 0x80
	// Bit BBSY.
	IIC0_ICCR2_BBSY = 0x80
	// I2C bus released (bus free state)
	IIC0_ICCR2_BBSY_0 = 0x0
	// I2C bus occupied (bus busy state)
	IIC0_ICCR2_BBSY_1 = 0x1

	// ICMR1: I2C Bus Mode Register 1
	// Position of BC field.
	IIC0_ICMR1_BC_Pos = 0x0
	// Bit mask of BC field.
	IIC0_ICMR1_BC_Msk = 0x7
	// 9 bits
	IIC0_ICMR1_BC_000 = 0x0
	// 2 bits
	IIC0_ICMR1_BC_001 = 0x1
	// 3 bits
	IIC0_ICMR1_BC_010 = 0x2
	// 4 bits
	IIC0_ICMR1_BC_011 = 0x3
	// 5 bits
	IIC0_ICMR1_BC_100 = 0x4
	// 6 bits
	IIC0_ICMR1_BC_101 = 0x5
	// 7 bits
	IIC0_ICMR1_BC_110 = 0x6
	// 8 bits
	IIC0_ICMR1_BC_111 = 0x7
	// Position of BCWP field.
	IIC0_ICMR1_BCWP_Pos = 0x3
	// Bit mask of BCWP field.
	IIC0_ICMR1_BCWP_Msk = 0x8
	// Bit BCWP.
	IIC0_ICMR1_BCWP = 0x8
	// Write enable BC[2:0] bits
	IIC0_ICMR1_BCWP_0 = 0x0
	// Write protect BC[2:0] bits
	IIC0_ICMR1_BCWP_1 = 0x1
	// Position of CKS field.
	IIC0_ICMR1_CKS_Pos = 0x4
	// Bit mask of CKS field.
	IIC0_ICMR1_CKS_Msk = 0x70
	// Position of MTWP field.
	IIC0_ICMR1_MTWP_Pos = 0x7
	// Bit mask of MTWP field.
	IIC0_ICMR1_MTWP_Msk = 0x80
	// Bit MTWP.
	IIC0_ICMR1_MTWP = 0x80
	// Write protect MST and TRS bits in ICCR2
	IIC0_ICMR1_MTWP_0 = 0x0
	// Write enable MST and TRS bits in ICCR2
	IIC0_ICMR1_MTWP_1 = 0x1

	// ICMR2: I2C Bus Mode Register 2
	// Position of TMOS field.
	IIC0_ICMR2_TMOS_Pos = 0x0
	// Bit mask of TMOS field.
	IIC0_ICMR2_TMOS_Msk = 0x1
	// Bit TMOS.
	IIC0_ICMR2_TMOS = 0x1
	// Select long mode
	IIC0_ICMR2_TMOS_0 = 0x0
	// Select short mode
	IIC0_ICMR2_TMOS_1 = 0x1
	// Position of TMOL field.
	IIC0_ICMR2_TMOL_Pos = 0x1
	// Bit mask of TMOL field.
	IIC0_ICMR2_TMOL_Msk = 0x2
	// Bit TMOL.
	IIC0_ICMR2_TMOL = 0x2
	// Disable count while SCL0 line is low
	IIC0_ICMR2_TMOL_0 = 0x0
	// Enable count while SCL0 line is low
	IIC0_ICMR2_TMOL_1 = 0x1
	// Position of TMOH field.
	IIC0_ICMR2_TMOH_Pos = 0x2
	// Bit mask of TMOH field.
	IIC0_ICMR2_TMOH_Msk = 0x4
	// Bit TMOH.
	IIC0_ICMR2_TMOH = 0x4
	// Disable count while SCL0 line is high
	IIC0_ICMR2_TMOH_0 = 0x0
	// Enable count while SCL0 line is high
	IIC0_ICMR2_TMOH_1 = 0x1
	// Position of SDDL field.
	IIC0_ICMR2_SDDL_Pos = 0x4
	// Bit mask of SDDL field.
	IIC0_ICMR2_SDDL_Msk = 0x70
	// No output delay
	IIC0_ICMR2_SDDL_000 = 0x0
	// 1 IIC-phi cycle (When ICMR2.DLCS = 0 (IIC-phi)) 1 or 2 IIC-phi cycles (When ICMR2.DLCS = 1 (IIC-phi/2))
	IIC0_ICMR2_SDDL_001 = 0x1
	// 2 IIC-phi cycles (When ICMR2.DLCS = 0 (IIC-phi)) 3 or 4 IIC-phi cycles (When ICMR2.DLCS = 1 (IIC-phi/2))
	IIC0_ICMR2_SDDL_010 = 0x2
	// 3 IIC-phi cycles (When ICMR2.DLCS = 0 (IIC-phi)) 5 or 6 IIC-phi cycles (When ICMR2.DLCS = 1 (IIC-phi/2))
	IIC0_ICMR2_SDDL_011 = 0x3
	// 4 IIC-phi cycles (When ICMR2.DLCS = 0 (IIC-phi)) 7 or 8 IIC-phi cycles (When ICMR2.DLCS = 1 (IIC-phi/2))
	IIC0_ICMR2_SDDL_100 = 0x4
	// 5 IIC-phi cycles (When ICMR2.DLCS = 0 (IIC-phi)) 9 or 10 IIC-phi cycles (When ICMR2.DLCS = 1 (IIC-phi/2))
	IIC0_ICMR2_SDDL_101 = 0x5
	// 6 IIC-phi cycles (When ICMR2.DLCS = 0 (IIC-phi)) 11 or 12 IIC-phi cycles (When ICMR2.DLCS = 1 (IIC-phi/2))
	IIC0_ICMR2_SDDL_110 = 0x6
	// 7 IIC-phi cycles (When ICMR2.DLCS = 0 (IIC-phi)) 13 or 14 IIC-phi cycles (When ICMR2.DLCS = 1 (IIC-phi/2))
	IIC0_ICMR2_SDDL_111 = 0x7
	// Position of DLCS field.
	IIC0_ICMR2_DLCS_Pos = 0x7
	// Bit mask of DLCS field.
	IIC0_ICMR2_DLCS_Msk = 0x80
	// Bit DLCS.
	IIC0_ICMR2_DLCS = 0x80
	// Select internal reference clock (IIC-phi) as the clock source for SDA output delay counter
	IIC0_ICMR2_DLCS_0 = 0x0
	// Select internal reference clock divided by 2 (IIC-phi/2) as the clock source for SDA output delay counter
	IIC0_ICMR2_DLCS_1 = 0x1

	// ICMR3: I2C Bus Mode Register 3
	// Position of NF field.
	IIC0_ICMR3_NF_Pos = 0x0
	// Bit mask of NF field.
	IIC0_ICMR3_NF_Msk = 0x3
	// Filter out noise of up to 1 IIC-phi cycle (single-stage filter)
	IIC0_ICMR3_NF_00 = 0x0
	// Filter out noise of up to 2 IIC-phi cycles (2-stage filter)
	IIC0_ICMR3_NF_01 = 0x1
	// Filter out noise of up to 3 IIC-phi cycles (3-stage filter)
	IIC0_ICMR3_NF_10 = 0x2
	// Filter out noise of up to 4 IIC-phi cycles (4-stage filter)
	IIC0_ICMR3_NF_11 = 0x3
	// Position of ACKBR field.
	IIC0_ICMR3_ACKBR_Pos = 0x2
	// Bit mask of ACKBR field.
	IIC0_ICMR3_ACKBR_Msk = 0x4
	// Bit ACKBR.
	IIC0_ICMR3_ACKBR = 0x4
	// 0 received as the acknowledge bit (ACK reception)
	IIC0_ICMR3_ACKBR_0 = 0x0
	// 1 received as the acknowledge bit (NACK reception)
	IIC0_ICMR3_ACKBR_1 = 0x1
	// Position of ACKBT field.
	IIC0_ICMR3_ACKBT_Pos = 0x3
	// Bit mask of ACKBT field.
	IIC0_ICMR3_ACKBT_Msk = 0x8
	// Bit ACKBT.
	IIC0_ICMR3_ACKBT = 0x8
	// Send 0 as the acknowledge bit (ACK transmission)
	IIC0_ICMR3_ACKBT_0 = 0x0
	// Send 1 as the acknowledge bit (NACK transmission)
	IIC0_ICMR3_ACKBT_1 = 0x1
	// Position of ACKWP field.
	IIC0_ICMR3_ACKWP_Pos = 0x4
	// Bit mask of ACKWP field.
	IIC0_ICMR3_ACKWP_Msk = 0x10
	// Bit ACKWP.
	IIC0_ICMR3_ACKWP = 0x10
	// Write protect ACKBT bit
	IIC0_ICMR3_ACKWP_0 = 0x0
	// Write enable ACKBT bit
	IIC0_ICMR3_ACKWP_1 = 0x1
	// Position of RDRFS field.
	IIC0_ICMR3_RDRFS_Pos = 0x5
	// Bit mask of RDRFS field.
	IIC0_ICMR3_RDRFS_Msk = 0x20
	// Bit RDRFS.
	IIC0_ICMR3_RDRFS = 0x20
	// Set the RDRF flag on the rising edge of the 9th SCL clock cycle. The SCLn line is not held low on the falling edge of the 8th clock cycle.
	IIC0_ICMR3_RDRFS_0 = 0x0
	// Set the RDRF flag on the rising edge of the 8th SCL clock cycle. The SCLn line is held low on the falling edge of the 8th clock cycle.
	IIC0_ICMR3_RDRFS_1 = 0x1
	// Position of WAIT field.
	IIC0_ICMR3_WAIT_Pos = 0x6
	// Bit mask of WAIT field.
	IIC0_ICMR3_WAIT_Msk = 0x40
	// Bit WAIT.
	IIC0_ICMR3_WAIT = 0x40
	// No wait (The SCLn line is not held low during the period between the 9th clock cycle and the 1st clock cycle.)
	IIC0_ICMR3_WAIT_0 = 0x0
	// Wait (The SCLn line is held low during the period between the 9th clock cycle and the 1st clock cycle.)
	IIC0_ICMR3_WAIT_1 = 0x1
	// Position of SMBS field.
	IIC0_ICMR3_SMBS_Pos = 0x7
	// Bit mask of SMBS field.
	IIC0_ICMR3_SMBS_Msk = 0x80
	// Bit SMBS.
	IIC0_ICMR3_SMBS = 0x80
	// Select I2C Bus
	IIC0_ICMR3_SMBS_0 = 0x0
	// Select SMBus
	IIC0_ICMR3_SMBS_1 = 0x1

	// ICFER: I2C Bus Function Enable Register
	// Position of TMOE field.
	IIC0_ICFER_TMOE_Pos = 0x0
	// Bit mask of TMOE field.
	IIC0_ICFER_TMOE_Msk = 0x1
	// Bit TMOE.
	IIC0_ICFER_TMOE = 0x1
	// Disable
	IIC0_ICFER_TMOE_0 = 0x0
	// Enable
	IIC0_ICFER_TMOE_1 = 0x1
	// Position of MALE field.
	IIC0_ICFER_MALE_Pos = 0x1
	// Bit mask of MALE field.
	IIC0_ICFER_MALE_Msk = 0x2
	// Bit MALE.
	IIC0_ICFER_MALE = 0x2
	// Disable the arbitration-lost detection function and disable automatic clearing of the MST and TRS bits in ICCR2 when arbitration is lost
	IIC0_ICFER_MALE_0 = 0x0
	// Enable the arbitration-lost detection function and enable automatic clearing of the MST and TRS bits in ICCR2 when arbitration is lost
	IIC0_ICFER_MALE_1 = 0x1
	// Position of NALE field.
	IIC0_ICFER_NALE_Pos = 0x2
	// Bit mask of NALE field.
	IIC0_ICFER_NALE_Msk = 0x4
	// Bit NALE.
	IIC0_ICFER_NALE = 0x4
	// Disable
	IIC0_ICFER_NALE_0 = 0x0
	// Enable
	IIC0_ICFER_NALE_1 = 0x1
	// Position of SALE field.
	IIC0_ICFER_SALE_Pos = 0x3
	// Bit mask of SALE field.
	IIC0_ICFER_SALE_Msk = 0x8
	// Bit SALE.
	IIC0_ICFER_SALE = 0x8
	// Disable
	IIC0_ICFER_SALE_0 = 0x0
	// Enable
	IIC0_ICFER_SALE_1 = 0x1
	// Position of NACKE field.
	IIC0_ICFER_NACKE_Pos = 0x4
	// Bit mask of NACKE field.
	IIC0_ICFER_NACKE_Msk = 0x10
	// Bit NACKE.
	IIC0_ICFER_NACKE = 0x10
	// Do not suspend transfer operation during NACK reception (disable transfer suspension)
	IIC0_ICFER_NACKE_0 = 0x0
	// Suspend transfer operation during NACK reception (enable transfer suspension)
	IIC0_ICFER_NACKE_1 = 0x1
	// Position of NFE field.
	IIC0_ICFER_NFE_Pos = 0x5
	// Bit mask of NFE field.
	IIC0_ICFER_NFE_Msk = 0x20
	// Bit NFE.
	IIC0_ICFER_NFE = 0x20
	// Do not use the digital noise filter circuit
	IIC0_ICFER_NFE_0 = 0x0
	// Use the digital noise filter circuit
	IIC0_ICFER_NFE_1 = 0x1
	// Position of SCLE field.
	IIC0_ICFER_SCLE_Pos = 0x6
	// Bit mask of SCLE field.
	IIC0_ICFER_SCLE_Msk = 0x40
	// Bit SCLE.
	IIC0_ICFER_SCLE = 0x40
	// Do not use the SCL synchronous circuit
	IIC0_ICFER_SCLE_0 = 0x0
	// Use the SCL synchronous circuit
	IIC0_ICFER_SCLE_1 = 0x1

	// ICSER: I2C Bus Status Enable Register
	// Position of SAR0E field.
	IIC0_ICSER_SAR0E_Pos = 0x0
	// Bit mask of SAR0E field.
	IIC0_ICSER_SAR0E_Msk = 0x1
	// Bit SAR0E.
	IIC0_ICSER_SAR0E = 0x1
	// Disable slave address in SARL0 and SARU0
	IIC0_ICSER_SAR0E_0 = 0x0
	// Enable slave address in SARL0 and SARU0
	IIC0_ICSER_SAR0E_1 = 0x1
	// Position of SAR1E field.
	IIC0_ICSER_SAR1E_Pos = 0x1
	// Bit mask of SAR1E field.
	IIC0_ICSER_SAR1E_Msk = 0x2
	// Bit SAR1E.
	IIC0_ICSER_SAR1E = 0x2
	// Disable slave address in SARL1 and SARU1
	IIC0_ICSER_SAR1E_0 = 0x0
	// Enable slave address in SARL1 and SARU1
	IIC0_ICSER_SAR1E_1 = 0x1
	// Position of SAR2E field.
	IIC0_ICSER_SAR2E_Pos = 0x2
	// Bit mask of SAR2E field.
	IIC0_ICSER_SAR2E_Msk = 0x4
	// Bit SAR2E.
	IIC0_ICSER_SAR2E = 0x4
	// Disable slave address in SARL2 and SARU2
	IIC0_ICSER_SAR2E_0 = 0x0
	// Enable slave address in SARL2 and SARU2
	IIC0_ICSER_SAR2E_1 = 0x1
	// Position of GCAE field.
	IIC0_ICSER_GCAE_Pos = 0x3
	// Bit mask of GCAE field.
	IIC0_ICSER_GCAE_Msk = 0x8
	// Bit GCAE.
	IIC0_ICSER_GCAE = 0x8
	// Disable general call address detection
	IIC0_ICSER_GCAE_0 = 0x0
	// Enable general call address detection
	IIC0_ICSER_GCAE_1 = 0x1
	// Position of DIDE field.
	IIC0_ICSER_DIDE_Pos = 0x5
	// Bit mask of DIDE field.
	IIC0_ICSER_DIDE_Msk = 0x20
	// Bit DIDE.
	IIC0_ICSER_DIDE = 0x20
	// Disable device-ID address detection
	IIC0_ICSER_DIDE_0 = 0x0
	// Enable device-ID address detection
	IIC0_ICSER_DIDE_1 = 0x1
	// Position of HOAE field.
	IIC0_ICSER_HOAE_Pos = 0x7
	// Bit mask of HOAE field.
	IIC0_ICSER_HOAE_Msk = 0x80
	// Bit HOAE.
	IIC0_ICSER_HOAE = 0x80
	// Disable host address detection
	IIC0_ICSER_HOAE_0 = 0x0
	// Enable host address detection
	IIC0_ICSER_HOAE_1 = 0x1

	// ICIER: I2C Bus Interrupt Enable Register
	// Position of TMOIE field.
	IIC0_ICIER_TMOIE_Pos = 0x0
	// Bit mask of TMOIE field.
	IIC0_ICIER_TMOIE_Msk = 0x1
	// Bit TMOIE.
	IIC0_ICIER_TMOIE = 0x1
	// Disable timeout interrupt (TMOI) request
	IIC0_ICIER_TMOIE_0 = 0x0
	// Enable timeout interrupt (TMOI) request
	IIC0_ICIER_TMOIE_1 = 0x1
	// Position of ALIE field.
	IIC0_ICIER_ALIE_Pos = 0x1
	// Bit mask of ALIE field.
	IIC0_ICIER_ALIE_Msk = 0x2
	// Bit ALIE.
	IIC0_ICIER_ALIE = 0x2
	// Disable arbitration-lost interrupt (ALI) request
	IIC0_ICIER_ALIE_0 = 0x0
	// Enable arbitration-lost interrupt (ALI) request
	IIC0_ICIER_ALIE_1 = 0x1
	// Position of STIE field.
	IIC0_ICIER_STIE_Pos = 0x2
	// Bit mask of STIE field.
	IIC0_ICIER_STIE_Msk = 0x4
	// Bit STIE.
	IIC0_ICIER_STIE = 0x4
	// Disable start condition detection interrupt (STI) request
	IIC0_ICIER_STIE_0 = 0x0
	// Enable start condition detection interrupt (STI) request
	IIC0_ICIER_STIE_1 = 0x1
	// Position of SPIE field.
	IIC0_ICIER_SPIE_Pos = 0x3
	// Bit mask of SPIE field.
	IIC0_ICIER_SPIE_Msk = 0x8
	// Bit SPIE.
	IIC0_ICIER_SPIE = 0x8
	// Disable stop condition detection interrupt (SPI) request
	IIC0_ICIER_SPIE_0 = 0x0
	// Enable stop condition detection interrupt (SPI) request
	IIC0_ICIER_SPIE_1 = 0x1
	// Position of NAKIE field.
	IIC0_ICIER_NAKIE_Pos = 0x4
	// Bit mask of NAKIE field.
	IIC0_ICIER_NAKIE_Msk = 0x10
	// Bit NAKIE.
	IIC0_ICIER_NAKIE = 0x10
	// Disable NACK reception interrupt (NAKI) request
	IIC0_ICIER_NAKIE_0 = 0x0
	// Enable NACK reception interrupt (NAKI) request
	IIC0_ICIER_NAKIE_1 = 0x1
	// Position of RIE field.
	IIC0_ICIER_RIE_Pos = 0x5
	// Bit mask of RIE field.
	IIC0_ICIER_RIE_Msk = 0x20
	// Bit RIE.
	IIC0_ICIER_RIE = 0x20
	// Disable receive data full interrupt (IIC0_RXI) request
	IIC0_ICIER_RIE_0 = 0x0
	// Enable receive data full interrupt (IIC0_RXI) request
	IIC0_ICIER_RIE_1 = 0x1
	// Position of TEIE field.
	IIC0_ICIER_TEIE_Pos = 0x6
	// Bit mask of TEIE field.
	IIC0_ICIER_TEIE_Msk = 0x40
	// Bit TEIE.
	IIC0_ICIER_TEIE = 0x40
	// Disable transmit end interrupt (IIC0_TEI) request
	IIC0_ICIER_TEIE_0 = 0x0
	// Enable transmit end interrupt (IIC0_TEI) request
	IIC0_ICIER_TEIE_1 = 0x1
	// Position of TIE field.
	IIC0_ICIER_TIE_Pos = 0x7
	// Bit mask of TIE field.
	IIC0_ICIER_TIE_Msk = 0x80
	// Bit TIE.
	IIC0_ICIER_TIE = 0x80
	// Disable transmit data empty interrupt (IIC0_TXI) request
	IIC0_ICIER_TIE_0 = 0x0
	// Enable transmit data empty interrupt (IIC0_TXI) request
	IIC0_ICIER_TIE_1 = 0x1

	// ICSR1: I2C Bus Status Register 1
	// Position of AAS0 field.
	IIC0_ICSR1_AAS0_Pos = 0x0
	// Bit mask of AAS0 field.
	IIC0_ICSR1_AAS0_Msk = 0x1
	// Bit AAS0.
	IIC0_ICSR1_AAS0 = 0x1
	// Slave address 0 not detected
	IIC0_ICSR1_AAS0_0 = 0x0
	// Slave address 0 detected
	IIC0_ICSR1_AAS0_1 = 0x1
	// Position of AAS1 field.
	IIC0_ICSR1_AAS1_Pos = 0x1
	// Bit mask of AAS1 field.
	IIC0_ICSR1_AAS1_Msk = 0x2
	// Bit AAS1.
	IIC0_ICSR1_AAS1 = 0x2
	// Slave address 1 not detected
	IIC0_ICSR1_AAS1_0 = 0x0
	// Slave address 1 detected
	IIC0_ICSR1_AAS1_1 = 0x1
	// Position of AAS2 field.
	IIC0_ICSR1_AAS2_Pos = 0x2
	// Bit mask of AAS2 field.
	IIC0_ICSR1_AAS2_Msk = 0x4
	// Bit AAS2.
	IIC0_ICSR1_AAS2 = 0x4
	// Slave address 2 not detected
	IIC0_ICSR1_AAS2_0 = 0x0
	// Slave address 2 detected
	IIC0_ICSR1_AAS2_1 = 0x1
	// Position of GCA field.
	IIC0_ICSR1_GCA_Pos = 0x3
	// Bit mask of GCA field.
	IIC0_ICSR1_GCA_Msk = 0x8
	// Bit GCA.
	IIC0_ICSR1_GCA = 0x8
	// General call address not detected
	IIC0_ICSR1_GCA_0 = 0x0
	// General call address detected
	IIC0_ICSR1_GCA_1 = 0x1
	// Position of DID field.
	IIC0_ICSR1_DID_Pos = 0x5
	// Bit mask of DID field.
	IIC0_ICSR1_DID_Msk = 0x20
	// Bit DID.
	IIC0_ICSR1_DID = 0x20
	// Device-ID command not detected
	IIC0_ICSR1_DID_0 = 0x0
	// Device-ID command detected
	IIC0_ICSR1_DID_1 = 0x1
	// Position of HOA field.
	IIC0_ICSR1_HOA_Pos = 0x7
	// Bit mask of HOA field.
	IIC0_ICSR1_HOA_Msk = 0x80
	// Bit HOA.
	IIC0_ICSR1_HOA = 0x80
	// Host address not detected
	IIC0_ICSR1_HOA_0 = 0x0
	// Host address detected
	IIC0_ICSR1_HOA_1 = 0x1

	// ICSR2: I2C Bus Status Register 2
	// Position of TMOF field.
	IIC0_ICSR2_TMOF_Pos = 0x0
	// Bit mask of TMOF field.
	IIC0_ICSR2_TMOF_Msk = 0x1
	// Bit TMOF.
	IIC0_ICSR2_TMOF = 0x1
	// Timeout not detected
	IIC0_ICSR2_TMOF_0 = 0x0
	// Timeout detected
	IIC0_ICSR2_TMOF_1 = 0x1
	// Position of AL field.
	IIC0_ICSR2_AL_Pos = 0x1
	// Bit mask of AL field.
	IIC0_ICSR2_AL_Msk = 0x2
	// Bit AL.
	IIC0_ICSR2_AL = 0x2
	// Arbitration not lost
	IIC0_ICSR2_AL_0 = 0x0
	// Arbitration lost
	IIC0_ICSR2_AL_1 = 0x1
	// Position of START field.
	IIC0_ICSR2_START_Pos = 0x2
	// Bit mask of START field.
	IIC0_ICSR2_START_Msk = 0x4
	// Bit START.
	IIC0_ICSR2_START = 0x4
	// Start condition not detected
	IIC0_ICSR2_START_0 = 0x0
	// Start condition detected
	IIC0_ICSR2_START_1 = 0x1
	// Position of STOP field.
	IIC0_ICSR2_STOP_Pos = 0x3
	// Bit mask of STOP field.
	IIC0_ICSR2_STOP_Msk = 0x8
	// Bit STOP.
	IIC0_ICSR2_STOP = 0x8
	// Stop condition not detected
	IIC0_ICSR2_STOP_0 = 0x0
	// Stop condition detected
	IIC0_ICSR2_STOP_1 = 0x1
	// Position of NACKF field.
	IIC0_ICSR2_NACKF_Pos = 0x4
	// Bit mask of NACKF field.
	IIC0_ICSR2_NACKF_Msk = 0x10
	// Bit NACKF.
	IIC0_ICSR2_NACKF = 0x10
	// NACK not detected
	IIC0_ICSR2_NACKF_0 = 0x0
	// NACK detected
	IIC0_ICSR2_NACKF_1 = 0x1
	// Position of RDRF field.
	IIC0_ICSR2_RDRF_Pos = 0x5
	// Bit mask of RDRF field.
	IIC0_ICSR2_RDRF_Msk = 0x20
	// Bit RDRF.
	IIC0_ICSR2_RDRF = 0x20
	// ICDRR contains no receive data
	IIC0_ICSR2_RDRF_0 = 0x0
	// ICDRR contains receive data
	IIC0_ICSR2_RDRF_1 = 0x1
	// Position of TEND field.
	IIC0_ICSR2_TEND_Pos = 0x6
	// Bit mask of TEND field.
	IIC0_ICSR2_TEND_Msk = 0x40
	// 