
//==--------- builtins_scalar_gen.hpp - SYCL generated built-in functions ---------==//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//
//
// NOTE: This file was generated and should not be changed!

#pragma once

#include <sycl/builtins_utils_scalar.hpp>

// TODO Decide whether to mark functions with this attribute.
#define __NOEXC /*noexcept*/

namespace sycl {
inline namespace _V1 {

inline float acos(float a0) __NOEXC {
  return __sycl_std::__invoke_acos<float>(a0);
}

inline double acos(double a0) __NOEXC {
  return __sycl_std::__invoke_acos<double>(a0);
}

inline half acos(half a0) __NOEXC {
  return __sycl_std::__invoke_acos<half>(a0);
}

inline float acosh(float a0) __NOEXC {
  return __sycl_std::__invoke_acosh<float>(a0);
}

inline double acosh(double a0) __NOEXC {
  return __sycl_std::__invoke_acosh<double>(a0);
}

inline half acosh(half a0) __NOEXC {
  return __sycl_std::__invoke_acosh<half>(a0);
}

inline float acospi(float a0) __NOEXC {
  return __sycl_std::__invoke_acospi<float>(a0);
}

inline double acospi(double a0) __NOEXC {
  return __sycl_std::__invoke_acospi<double>(a0);
}

inline half acospi(half a0) __NOEXC {
  return __sycl_std::__invoke_acospi<half>(a0);
}

inline float asin(float a0) __NOEXC {
  return __sycl_std::__invoke_asin<float>(a0);
}

inline double asin(double a0) __NOEXC {
  return __sycl_std::__invoke_asin<double>(a0);
}

inline half asin(half a0) __NOEXC {
  return __sycl_std::__invoke_asin<half>(a0);
}

inline float asinh(float a0) __NOEXC {
  return __sycl_std::__invoke_asinh<float>(a0);
}

inline double asinh(double a0) __NOEXC {
  return __sycl_std::__invoke_asinh<double>(a0);
}

inline half asinh(half a0) __NOEXC {
  return __sycl_std::__invoke_asinh<half>(a0);
}

inline float asinpi(float a0) __NOEXC {
  return __sycl_std::__invoke_asinpi<float>(a0);
}

inline double asinpi(double a0) __NOEXC {
  return __sycl_std::__invoke_asinpi<double>(a0);
}

inline half asinpi(half a0) __NOEXC {
  return __sycl_std::__invoke_asinpi<half>(a0);
}

inline float atan(float a0) __NOEXC {
  return __sycl_std::__invoke_atan<float>(a0);
}

inline double atan(double a0) __NOEXC {
  return __sycl_std::__invoke_atan<double>(a0);
}

inline half atan(half a0) __NOEXC {
  return __sycl_std::__invoke_atan<half>(a0);
}

inline float atan2(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_atan2<float>(a0, a1);
}

inline double atan2(double a0, double a1) __NOEXC {
  return __sycl_std::__invoke_atan2<double>(a0, a1);
}

inline half atan2(half a0, half a1) __NOEXC {
  return __sycl_std::__invoke_atan2<half>(a0, a1);
}

inline float atanh(float a0) __NOEXC {
  return __sycl_std::__invoke_atanh<float>(a0);
}

inline double atanh(double a0) __NOEXC {
  return __sycl_std::__invoke_atanh<double>(a0);
}

inline half atanh(half a0) __NOEXC {
  return __sycl_std::__invoke_atanh<half>(a0);
}

inline float atanpi(float a0) __NOEXC {
  return __sycl_std::__invoke_atanpi<float>(a0);
}

inline double atanpi(double a0) __NOEXC {
  return __sycl_std::__invoke_atanpi<double>(a0);
}

inline half atanpi(half a0) __NOEXC {
  return __sycl_std::__invoke_atanpi<half>(a0);
}

inline float atan2pi(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_atan2pi<float>(a0, a1);
}

inline double atan2pi(double a0, double a1) __NOEXC {
  return __sycl_std::__invoke_atan2pi<double>(a0, a1);
}

inline half atan2pi(half a0, half a1) __NOEXC {
  return __sycl_std::__invoke_atan2pi<half>(a0, a1);
}

inline float cbrt(float a0) __NOEXC {
  return __sycl_std::__invoke_cbrt<float>(a0);
}

inline double cbrt(double a0) __NOEXC {
  return __sycl_std::__invoke_cbrt<double>(a0);
}

inline half cbrt(half a0) __NOEXC {
  return __sycl_std::__invoke_cbrt<half>(a0);
}

inline float ceil(float a0) __NOEXC {
  return __sycl_std::__invoke_ceil<float>(a0);
}

inline double ceil(double a0) __NOEXC {
  return __sycl_std::__invoke_ceil<double>(a0);
}

inline half ceil(half a0) __NOEXC {
  return __sycl_std::__invoke_ceil<half>(a0);
}

inline float copysign(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_copysign<float>(a0, a1);
}

inline double copysign(double a0, double a1) __NOEXC {
  return __sycl_std::__invoke_copysign<double>(a0, a1);
}

inline half copysign(half a0, half a1) __NOEXC {
  return __sycl_std::__invoke_copysign<half>(a0, a1);
}

inline float cos(float a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    return __sycl_std::__invoke_native_cos<float>(a0);}
  return __sycl_std::__invoke_cos<float>(a0);
}

inline double cos(double a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    return __sycl_std::__invoke_native_cos<double>(a0);}
  return __sycl_std::__invoke_cos<double>(a0);
}

inline half cos(half a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    return __sycl_std::__invoke_native_cos<half>(a0);}
  return __sycl_std::__invoke_cos<half>(a0);
}

inline float cosh(float a0) __NOEXC {
  return __sycl_std::__invoke_cosh<float>(a0);
}

inline double cosh(double a0) __NOEXC {
  return __sycl_std::__invoke_cosh<double>(a0);
}

inline half cosh(half a0) __NOEXC {
  return __sycl_std::__invoke_cosh<half>(a0);
}

inline float cospi(float a0) __NOEXC {
  return __sycl_std::__invoke_cospi<float>(a0);
}

inline double cospi(double a0) __NOEXC {
  return __sycl_std::__invoke_cospi<double>(a0);
}

inline half cospi(half a0) __NOEXC {
  return __sycl_std::__invoke_cospi<half>(a0);
}

inline float erfc(float a0) __NOEXC {
  return __sycl_std::__invoke_erfc<float>(a0);
}

inline double erfc(double a0) __NOEXC {
  return __sycl_std::__invoke_erfc<double>(a0);
}

inline half erfc(half a0) __NOEXC {
  return __sycl_std::__invoke_erfc<half>(a0);
}

inline float erf(float a0) __NOEXC {
  return __sycl_std::__invoke_erf<float>(a0);
}

inline double erf(double a0) __NOEXC {
  return __sycl_std::__invoke_erf<double>(a0);
}

inline half erf(half a0) __NOEXC {
  return __sycl_std::__invoke_erf<half>(a0);
}

inline float exp(float a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    return __sycl_std::__invoke_native_exp<float>(a0);}
  return __sycl_std::__invoke_exp<float>(a0);
}

inline double exp(double a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    return __sycl_std::__invoke_native_exp<double>(a0);}
  return __sycl_std::__invoke_exp<double>(a0);
}

inline half exp(half a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    return __sycl_std::__invoke_native_exp<half>(a0);}
  return __sycl_std::__invoke_exp<half>(a0);
}

inline float exp2(float a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    return __sycl_std::__invoke_native_exp2<float>(a0);}
  return __sycl_std::__invoke_exp2<float>(a0);
}

inline double exp2(double a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    return __sycl_std::__invoke_native_exp2<double>(a0);}
  return __sycl_std::__invoke_exp2<double>(a0);
}

inline half exp2(half a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    return __sycl_std::__invoke_native_exp2<half>(a0);}
  return __sycl_std::__invoke_exp2<half>(a0);
}

inline float exp10(float a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    return __sycl_std::__invoke_native_exp10<float>(a0);}
  return __sycl_std::__invoke_exp10<float>(a0);
}

inline double exp10(double a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    return __sycl_std::__invoke_native_exp10<double>(a0);}
  return __sycl_std::__invoke_exp10<double>(a0);
}

inline half exp10(half a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    return __sycl_std::__invoke_native_exp10<half>(a0);}
  return __sycl_std::__invoke_exp10<half>(a0);
}

inline float expm1(float a0) __NOEXC {
  return __sycl_std::__invoke_expm1<float>(a0);
}

inline double expm1(double a0) __NOEXC {
  return __sycl_std::__invoke_expm1<double>(a0);
}

inline half expm1(half a0) __NOEXC {
  return __sycl_std::__invoke_expm1<half>(a0);
}

inline float fabs(float a0) __NOEXC {
  return __sycl_std::__invoke_fabs<float>(a0);
}

inline double fabs(double a0) __NOEXC {
  return __sycl_std::__invoke_fabs<double>(a0);
}

inline half fabs(half a0) __NOEXC {
  return __sycl_std::__invoke_fabs<half>(a0);
}

inline float fdim(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_fdim<float>(a0, a1);
}

inline double fdim(double a0, double a1) __NOEXC {
  return __sycl_std::__invoke_fdim<double>(a0, a1);
}

inline half fdim(half a0, half a1) __NOEXC {
  return __sycl_std::__invoke_fdim<half>(a0, a1);
}

inline float floor(float a0) __NOEXC {
  return __sycl_std::__invoke_floor<float>(a0);
}

inline double floor(double a0) __NOEXC {
  return __sycl_std::__invoke_floor<double>(a0);
}

inline half floor(half a0) __NOEXC {
  return __sycl_std::__invoke_floor<half>(a0);
}

inline float fma(float a0, float a1, float a2) __NOEXC {
  return __sycl_std::__invoke_fma<float>(a0, a1, a2);
}

inline double fma(double a0, double a1, double a2) __NOEXC {
  return __sycl_std::__invoke_fma<double>(a0, a1, a2);
}

inline half fma(half a0, half a1, half a2) __NOEXC {
  return __sycl_std::__invoke_fma<half>(a0, a1, a2);
}

inline float fmax(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_fmax<float>(a0, a1);
}

inline double fmax(double a0, double a1) __NOEXC {
  return __sycl_std::__invoke_fmax<double>(a0, a1);
}

inline half fmax(half a0, half a1) __NOEXC {
  return __sycl_std::__invoke_fmax<half>(a0, a1);
}

inline float fmin(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_fmin<float>(a0, a1);
}

inline double fmin(double a0, double a1) __NOEXC {
  return __sycl_std::__invoke_fmin<double>(a0, a1);
}

inline half fmin(half a0, half a1) __NOEXC {
  return __sycl_std::__invoke_fmin<half>(a0, a1);
}

inline float fmod(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_fmod<float>(a0, a1);
}

inline double fmod(double a0, double a1) __NOEXC {
  return __sycl_std::__invoke_fmod<double>(a0, a1);
}

inline half fmod(half a0, half a1) __NOEXC {
  return __sycl_std::__invoke_fmod<half>(a0, a1);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<float>>), float> fract(float a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fract<float>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline float fract(float a0, float* a1) __NOEXC {
  return __sycl_std::__invoke_fract<float>(a0, a1);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<double>>), double> fract(double a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fract<double>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline double fract(double a0, double* a1) __NOEXC {
  return __sycl_std::__invoke_fract<double>(a0, a1);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<half>>), half> fract(half a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fract<half>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline half fract(half a0, half* a1) __NOEXC {
  return __sycl_std::__invoke_fract<half>(a0, a1);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<int>>), float> frexp(float a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_frexp<float>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline float frexp(float a0, int* a1) __NOEXC {
  return __sycl_std::__invoke_frexp<float>(a0, a1);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<int>>), double> frexp(double a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_frexp<double>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline double frexp(double a0, int* a1) __NOEXC {
  return __sycl_std::__invoke_frexp<double>(a0, a1);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<int>>), half> frexp(half a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_frexp<half>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline half frexp(half a0, int* a1) __NOEXC {
  return __sycl_std::__invoke_frexp<half>(a0, a1);
}

inline float hypot(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_hypot<float>(a0, a1);
}

inline double hypot(double a0, double a1) __NOEXC {
  return __sycl_std::__invoke_hypot<double>(a0, a1);
}

inline half hypot(half a0, half a1) __NOEXC {
  return __sycl_std::__invoke_hypot<half>(a0, a1);
}

inline int ilogb(float a0) __NOEXC {
  return __sycl_std::__invoke_ilogb<int>(a0);
}

inline int ilogb(double a0) __NOEXC {
  return __sycl_std::__invoke_ilogb<int>(a0);
}

inline int ilogb(half a0) __NOEXC {
  return __sycl_std::__invoke_ilogb<int>(a0);
}

inline float ldexp(float a0, int a1) __NOEXC {
  return __sycl_std::__invoke_ldexp<float>(a0, a1);
}

inline double ldexp(double a0, int a1) __NOEXC {
  return __sycl_std::__invoke_ldexp<double>(a0, a1);
}

inline half ldexp(half a0, int a1) __NOEXC {
  return __sycl_std::__invoke_ldexp<half>(a0, a1);
}

inline float lgamma(float a0) __NOEXC {
  return __sycl_std::__invoke_lgamma<float>(a0);
}

inline double lgamma(double a0) __NOEXC {
  return __sycl_std::__invoke_lgamma<double>(a0);
}

inline half lgamma(half a0) __NOEXC {
  return __sycl_std::__invoke_lgamma<half>(a0);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<int>>), float> lgamma_r(float a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_lgamma_r<float>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline float lgamma_r(float a0, int* a1) __NOEXC {
  return __sycl_std::__invoke_lgamma_r<float>(a0, a1);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<int>>), double> lgamma_r(double a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_lgamma_r<double>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline double lgamma_r(double a0, int* a1) __NOEXC {
  return __sycl_std::__invoke_lgamma_r<double>(a0, a1);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<int>>), half> lgamma_r(half a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_lgamma_r<half>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline half lgamma_r(half a0, int* a1) __NOEXC {
  return __sycl_std::__invoke_lgamma_r<half>(a0, a1);
}

inline float log(float a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    return __sycl_std::__invoke_native_log<float>(a0);}
  return __sycl_std::__invoke_log<float>(a0);
}

inline double log(double a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    return __sycl_std::__invoke_native_log<double>(a0);}
  return __sycl_std::__invoke_log<double>(a0);
}

inline half log(half a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    return __sycl_std::__invoke_native_log<half>(a0);}
  return __sycl_std::__invoke_log<half>(a0);
}

inline float log2(float a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    return __sycl_std::__invoke_native_log2<float>(a0);}
  return __sycl_std::__invoke_log2<float>(a0);
}

inline double log2(double a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    return __sycl_std::__invoke_native_log2<double>(a0);}
  return __sycl_std::__invoke_log2<double>(a0);
}

inline half log2(half a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    return __sycl_std::__invoke_native_log2<half>(a0);}
  return __sycl_std::__invoke_log2<half>(a0);
}

inline float log10(float a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    return __sycl_std::__invoke_native_log10<float>(a0);}
  return __sycl_std::__invoke_log10<float>(a0);
}

inline double log10(double a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    return __sycl_std::__invoke_native_log10<double>(a0);}
  return __sycl_std::__invoke_log10<double>(a0);
}

inline half log10(half a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    return __sycl_std::__invoke_native_log10<half>(a0);}
  return __sycl_std::__invoke_log10<half>(a0);
}

inline float log1p(float a0) __NOEXC {
  return __sycl_std::__invoke_log1p<float>(a0);
}

inline double log1p(double a0) __NOEXC {
  return __sycl_std::__invoke_log1p<double>(a0);
}

inline half log1p(half a0) __NOEXC {
  return __sycl_std::__invoke_log1p<half>(a0);
}

inline float logb(float a0) __NOEXC {
  return __sycl_std::__invoke_logb<float>(a0);
}

inline double logb(double a0) __NOEXC {
  return __sycl_std::__invoke_logb<double>(a0);
}

inline half logb(half a0) __NOEXC {
  return __sycl_std::__invoke_logb<half>(a0);
}

inline float mad(float a0, float a1, float a2) __NOEXC {
  return __sycl_std::__invoke_mad<float>(a0, a1, a2);
}

inline double mad(double a0, double a1, double a2) __NOEXC {
  return __sycl_std::__invoke_mad<double>(a0, a1, a2);
}

inline half mad(half a0, half a1, half a2) __NOEXC {
  return __sycl_std::__invoke_mad<half>(a0, a1, a2);
}

inline float maxmag(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_maxmag<float>(a0, a1);
}

inline double maxmag(double a0, double a1) __NOEXC {
  return __sycl_std::__invoke_maxmag<double>(a0, a1);
}

inline half maxmag(half a0, half a1) __NOEXC {
  return __sycl_std::__invoke_maxmag<half>(a0, a1);
}

inline float minmag(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_minmag<float>(a0, a1);
}

inline double minmag(double a0, double a1) __NOEXC {
  return __sycl_std::__invoke_minmag<double>(a0, a1);
}

inline half minmag(half a0, half a1) __NOEXC {
  return __sycl_std::__invoke_minmag<half>(a0, a1);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<float>>), float> modf(float a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_modf<float>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline float modf(float a0, float* a1) __NOEXC {
  return __sycl_std::__invoke_modf<float>(a0, a1);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<double>>), double> modf(double a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_modf<double>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline double modf(double a0, double* a1) __NOEXC {
  return __sycl_std::__invoke_modf<double>(a0, a1);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<half>>), half> modf(half a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_modf<half>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline half modf(half a0, half* a1) __NOEXC {
  return __sycl_std::__invoke_modf<half>(a0, a1);
}

inline detail::nan_return_unswizzled_t<unsigned int> nan(unsigned int a0) __NOEXC {
  using unswizzled_arg_t = detail::simplify_if_swizzle_t<unsigned int>;
  return __sycl_std::__invoke_nan<detail::nan_return_unswizzled_t<unsigned int>>(
    detail::convert_data_type<unswizzled_arg_t, detail::nan_argument_base_t<unswizzled_arg_t>>()(a0));
}

inline detail::nan_return_unswizzled_t<unsigned long> nan(unsigned long a0) __NOEXC {
  using unswizzled_arg_t = detail::simplify_if_swizzle_t<unsigned long>;
  return __sycl_std::__invoke_nan<detail::nan_return_unswizzled_t<unsigned long>>(
    detail::convert_data_type<unswizzled_arg_t, detail::nan_argument_base_t<unswizzled_arg_t>>()(a0));
}

inline detail::nan_return_unswizzled_t<unsigned long long> nan(unsigned long long a0) __NOEXC {
  using unswizzled_arg_t = detail::simplify_if_swizzle_t<unsigned long long>;
  return __sycl_std::__invoke_nan<detail::nan_return_unswizzled_t<unsigned long long>>(
    detail::convert_data_type<unswizzled_arg_t, detail::nan_argument_base_t<unswizzled_arg_t>>()(a0));
}

inline detail::nan_return_unswizzled_t<unsigned short> nan(unsigned short a0) __NOEXC {
  using unswizzled_arg_t = detail::simplify_if_swizzle_t<unsigned short>;
  return __sycl_std::__invoke_nan<detail::nan_return_unswizzled_t<unsigned short>>(
    detail::convert_data_type<unswizzled_arg_t, detail::nan_argument_base_t<unswizzled_arg_t>>()(a0));
}

inline float nextafter(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_nextafter<float>(a0, a1);
}

inline double nextafter(double a0, double a1) __NOEXC {
  return __sycl_std::__invoke_nextafter<double>(a0, a1);
}

inline half nextafter(half a0, half a1) __NOEXC {
  return __sycl_std::__invoke_nextafter<half>(a0, a1);
}

inline float pow(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_pow<float>(a0, a1);
}

inline double pow(double a0, double a1) __NOEXC {
  return __sycl_std::__invoke_pow<double>(a0, a1);
}

inline half pow(half a0, half a1) __NOEXC {
  return __sycl_std::__invoke_pow<half>(a0, a1);
}

inline float pown(float a0, int a1) __NOEXC {
  return __sycl_std::__invoke_pown<float>(a0, a1);
}

inline double pown(double a0, int a1) __NOEXC {
  return __sycl_std::__invoke_pown<double>(a0, a1);
}

inline half pown(half a0, int a1) __NOEXC {
  return __sycl_std::__invoke_pown<half>(a0, a1);
}

inline float powr(float a0, float a1) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    return __sycl_std::__invoke_native_powr<float>(a0, a1);}
  return __sycl_std::__invoke_powr<float>(a0, a1);
}

inline double powr(double a0, double a1) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    return __sycl_std::__invoke_native_powr<double>(a0, a1);}
  return __sycl_std::__invoke_powr<double>(a0, a1);
}

inline half powr(half a0, half a1) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    return __sycl_std::__invoke_native_powr<half>(a0, a1);}
  return __sycl_std::__invoke_powr<half>(a0, a1);
}

inline float remainder(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_remainder<float>(a0, a1);
}

inline double remainder(double a0, double a1) __NOEXC {
  return __sycl_std::__invoke_remainder<double>(a0, a1);
}

inline half remainder(half a0, half a1) __NOEXC {
  return __sycl_std::__invoke_remainder<half>(a0, a1);
}

template <typename T2>
std::enable_if_t<(detail::is_multi_ptr_v<T2> && detail::has_writeable_addr_space_v<T2> && detail::is_valid_elem_type_v<T2, detail::simplify_if_swizzle_t<int>>), float> remquo(float a0, float a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_remquo<float>(a0, a1, a2);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline float remquo(float a0, float a1, int* a2) __NOEXC {
  return __sycl_std::__invoke_remquo<float>(a0, a1, a2);
}

template <typename T2>
std::enable_if_t<(detail::is_multi_ptr_v<T2> && detail::has_writeable_addr_space_v<T2> && detail::is_valid_elem_type_v<T2, detail::simplify_if_swizzle_t<int>>), double> remquo(double a0, double a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_remquo<double>(a0, a1, a2);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline double remquo(double a0, double a1, int* a2) __NOEXC {
  return __sycl_std::__invoke_remquo<double>(a0, a1, a2);
}

template <typename T2>
std::enable_if_t<(detail::is_multi_ptr_v<T2> && detail::has_writeable_addr_space_v<T2> && detail::is_valid_elem_type_v<T2, detail::simplify_if_swizzle_t<int>>), half> remquo(half a0, half a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_remquo<half>(a0, a1, a2);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline half remquo(half a0, half a1, int* a2) __NOEXC {
  return __sycl_std::__invoke_remquo<half>(a0, a1, a2);
}

inline float rint(float a0) __NOEXC {
  return __sycl_std::__invoke_rint<float>(a0);
}

inline double rint(double a0) __NOEXC {
  return __sycl_std::__invoke_rint<double>(a0);
}

inline half rint(half a0) __NOEXC {
  return __sycl_std::__invoke_rint<half>(a0);
}

inline float rootn(float a0, int a1) __NOEXC {
  return __sycl_std::__invoke_rootn<float>(a0, a1);
}

inline double rootn(double a0, int a1) __NOEXC {
  return __sycl_std::__invoke_rootn<double>(a0, a1);
}

inline half rootn(half a0, int a1) __NOEXC {
  return __sycl_std::__invoke_rootn<half>(a0, a1);
}

inline float round(float a0) __NOEXC {
  return __sycl_std::__invoke_round<float>(a0);
}

inline double round(double a0) __NOEXC {
  return __sycl_std::__invoke_round<double>(a0);
}

inline half round(half a0) __NOEXC {
  return __sycl_std::__invoke_round<half>(a0);
}

inline float rsqrt(float a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    return __sycl_std::__invoke_native_rsqrt<float>(a0);}
  return __sycl_std::__invoke_rsqrt<float>(a0);
}

inline double rsqrt(double a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    return __sycl_std::__invoke_native_rsqrt<double>(a0);}
  return __sycl_std::__invoke_rsqrt<double>(a0);
}

inline half rsqrt(half a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    return __sycl_std::__invoke_native_rsqrt<half>(a0);}
  return __sycl_std::__invoke_rsqrt<half>(a0);
}

inline float sin(float a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    return __sycl_std::__invoke_native_sin<float>(a0);}
  return __sycl_std::__invoke_sin<float>(a0);
}

inline double sin(double a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    return __sycl_std::__invoke_native_sin<double>(a0);}
  return __sycl_std::__invoke_sin<double>(a0);
}

inline half sin(half a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    return __sycl_std::__invoke_native_sin<half>(a0);}
  return __sycl_std::__invoke_sin<half>(a0);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<float>>), float> sincos(float a0, T1 a1) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    *a1 = __sycl_std::__invoke_native_cos<float>(a0);
    return __sycl_std::__invoke_native_sin<float>(a0);}
  return __sycl_std::__invoke_sincos<float>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline float sincos(float a0, float* a1) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    *a1 = __sycl_std::__invoke_native_cos<float>(a0);
    return __sycl_std::__invoke_native_sin<float>(a0);}
  return __sycl_std::__invoke_sincos<float>(a0, a1);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<double>>), double> sincos(double a0, T1 a1) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    *a1 = __sycl_std::__invoke_native_cos<double>(a0);
    return __sycl_std::__invoke_native_sin<double>(a0);}
  return __sycl_std::__invoke_sincos<double>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline double sincos(double a0, double* a1) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    *a1 = __sycl_std::__invoke_native_cos<double>(a0);
    return __sycl_std::__invoke_native_sin<double>(a0);}
  return __sycl_std::__invoke_sincos<double>(a0, a1);
}

template <typename T1>
std::enable_if_t<(detail::is_multi_ptr_v<T1> && detail::has_writeable_addr_space_v<T1> && detail::is_valid_elem_type_v<T1, detail::simplify_if_swizzle_t<half>>), half> sincos(half a0, T1 a1) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    *a1 = __sycl_std::__invoke_native_cos<half>(a0);
    return __sycl_std::__invoke_native_sin<half>(a0);}
  return __sycl_std::__invoke_sincos<half>(a0, a1);
}

__SYCL_DEPRECATED("SYCL builtin functions with raw pointer arguments have been deprecated. Please use multi_ptr.")
inline half sincos(half a0, half* a1) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    *a1 = __sycl_std::__invoke_native_cos<half>(a0);
    return __sycl_std::__invoke_native_sin<half>(a0);}
  return __sycl_std::__invoke_sincos<half>(a0, a1);
}

inline float sinh(float a0) __NOEXC {
  return __sycl_std::__invoke_sinh<float>(a0);
}

inline double sinh(double a0) __NOEXC {
  return __sycl_std::__invoke_sinh<double>(a0);
}

inline half sinh(half a0) __NOEXC {
  return __sycl_std::__invoke_sinh<half>(a0);
}

inline float sinpi(float a0) __NOEXC {
  return __sycl_std::__invoke_sinpi<float>(a0);
}

inline double sinpi(double a0) __NOEXC {
  return __sycl_std::__invoke_sinpi<double>(a0);
}

inline half sinpi(half a0) __NOEXC {
  return __sycl_std::__invoke_sinpi<half>(a0);
}

inline float sqrt(float a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    return __sycl_std::__invoke_native_sqrt<float>(a0);}
  return __sycl_std::__invoke_sqrt<float>(a0);
}

inline double sqrt(double a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    return __sycl_std::__invoke_native_sqrt<double>(a0);}
  return __sycl_std::__invoke_sqrt<double>(a0);
}

inline half sqrt(half a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    return __sycl_std::__invoke_native_sqrt<half>(a0);}
  return __sycl_std::__invoke_sqrt<half>(a0);
}

inline float tan(float a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<float>) {    return __sycl_std::__invoke_native_tan<float>(a0);}
  return __sycl_std::__invoke_tan<float>(a0);
}

inline double tan(double a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<double>) {    return __sycl_std::__invoke_native_tan<double>(a0);}
  return __sycl_std::__invoke_tan<double>(a0);
}

inline half tan(half a0) __NOEXC {
  if constexpr (detail::use_fast_math_v<half>) {    return __sycl_std::__invoke_native_tan<half>(a0);}
  return __sycl_std::__invoke_tan<half>(a0);
}

inline float tanh(float a0) __NOEXC {
  return __sycl_std::__invoke_tanh<float>(a0);
}

inline double tanh(double a0) __NOEXC {
  return __sycl_std::__invoke_tanh<double>(a0);
}

inline half tanh(half a0) __NOEXC {
  return __sycl_std::__invoke_tanh<half>(a0);
}

inline float tanpi(float a0) __NOEXC {
  return __sycl_std::__invoke_tanpi<float>(a0);
}

inline double tanpi(double a0) __NOEXC {
  return __sycl_std::__invoke_tanpi<double>(a0);
}

inline half tanpi(half a0) __NOEXC {
  return __sycl_std::__invoke_tanpi<half>(a0);
}

inline float tgamma(float a0) __NOEXC {
  return __sycl_std::__invoke_tgamma<float>(a0);
}

inline double tgamma(double a0) __NOEXC {
  return __sycl_std::__invoke_tgamma<double>(a0);
}

inline half tgamma(half a0) __NOEXC {
  return __sycl_std::__invoke_tgamma<half>(a0);
}

inline float trunc(float a0) __NOEXC {
  return __sycl_std::__invoke_trunc<float>(a0);
}

inline double trunc(double a0) __NOEXC {
  return __sycl_std::__invoke_trunc<double>(a0);
}

inline half trunc(half a0) __NOEXC {
  return __sycl_std::__invoke_trunc<half>(a0);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> abs_diff(T0 a0, T1 a1) __NOEXC {
return static_cast<T0>(__sycl_std::__invoke_s_abs_diff<detail::make_unsigned_t<T0>>(a0 ,a1));
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> abs_diff(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_abs_diff<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> add_sat(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_add_sat<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> add_sat(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_add_sat<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> hadd(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_hadd<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> hadd(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_hadd<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> rhadd(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_rhadd<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> rhadd(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_rhadd<T0>(a0, a1);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>), T0> clz(T0 a0) __NOEXC {
  return __sycl_std::__invoke_clz<T0>(a0);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>), T0> ctz(T0 a0) __NOEXC {
  return __sycl_std::__invoke_ctz<T0>(a0);
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>) && detail::check_all_same_op_type_v<T0, T1, T2>, T0> mad_hi(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_s_mad_hi<T0>(a0, a1, a2);
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::check_type_in_v<T0, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>) && detail::check_all_same_op_type_v<T0, T1, T2>, T0> mad_hi(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_u_mad_hi<T0>(a0, a1, a2);
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>) && detail::check_all_same_op_type_v<T0, T1, T2>, T0> mad_sat(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_s_mad_sat<T0>(a0, a1, a2);
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::check_type_in_v<T0, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>) && detail::check_all_same_op_type_v<T0, T1, T2>, T0> mad_sat(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_u_mad_sat<T0>(a0, a1, a2);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> mul_hi(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_mul_hi<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> mul_hi(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_mul_hi<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> rotate(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_rotate<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> sub_sat(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_sub_sat<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> sub_sat(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_sub_sat<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, int8_t>) && (detail::check_type_in_v<T1, uint8_t>), detail::upsampled_int_t<T0>> upsample(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_upsample<detail::upsampled_int_t<T0>>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, char>) && (detail::check_type_in_v<T1, uint8_t>), detail::upsampled_int_t<T0>> upsample(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_upsample<detail::upsampled_int_t<T0>>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, uint8_t>) && detail::check_all_same_op_type_v<T0, T1>, detail::upsampled_int_t<T0>> upsample(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_upsample<detail::upsampled_int_t<T0>>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, int16_t>) && (detail::check_type_in_v<T1, uint16_t>), detail::upsampled_int_t<T0>> upsample(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_upsample<detail::upsampled_int_t<T0>>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, uint16_t>) && detail::check_all_same_op_type_v<T0, T1>, detail::upsampled_int_t<T0>> upsample(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_upsample<detail::upsampled_int_t<T0>>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, int32_t>) && (detail::check_type_in_v<T1, uint32_t>), detail::upsampled_int_t<T0>> upsample(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_upsample<detail::upsampled_int_t<T0>>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, uint32_t>) && detail::check_all_same_op_type_v<T0, T1>, detail::upsampled_int_t<T0>> upsample(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_upsample<detail::upsampled_int_t<T0>>(a0, a1);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>), T0> popcount(T0 a0) __NOEXC {
  return __sycl_std::__invoke_popcount<T0>(a0);
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::check_type_in_v<T0, int32_t>) && detail::check_all_same_op_type_v<T0, T1, T2>, T0> mad24(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_s_mad24<T0>(a0, a1, a2);
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::check_type_in_v<T0, uint32_t>) && detail::check_all_same_op_type_v<T0, T1, T2>, T0> mad24(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_u_mad24<T0>(a0, a1, a2);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, int32_t>) && detail::check_all_same_op_type_v<T0, T1>, T0> mul24(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_mul24<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, uint32_t>) && detail::check_all_same_op_type_v<T0, T1>, T0> mul24(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_mul24<T0>(a0, a1);
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::check_type_in_v<T0, float, double, half>) && detail::check_all_same_op_type_v<T0, T1, T2>, T0> clamp(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_fclamp<T0>(a0, a1, a2);
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>) && detail::check_all_same_op_type_v<T0, T1, T2>, T0> clamp(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_s_clamp<T0>(a0, a1, a2);
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::check_type_in_v<T0, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>) && detail::check_all_same_op_type_v<T0, T1, T2>, T0> clamp(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_u_clamp<T0>(a0, a1, a2);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, float, double, half>), T0> degrees(T0 a0) __NOEXC {
  return __sycl_std::__invoke_degrees<T0>(a0);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, float, double, half>) && detail::check_all_same_op_type_v<T0, T1>, T0> (max)(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fmax_common<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> (max)(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_max<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> (max)(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_max<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, float, double, half>) && detail::check_all_same_op_type_v<T0, T1>, T0> (min)(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fmin_common<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> (min)(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_s_min<T0>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>) && detail::check_all_same_op_type_v<T0, T1>, T0> (min)(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_u_min<T0>(a0, a1);
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::check_type_in_v<T0, float, double, half>) && detail::check_all_same_op_type_v<T0, T1, T2>, T0> mix(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_mix<T0>(a0, a1, a2);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, float, double, half>), T0> radians(T0 a0) __NOEXC {
  return __sycl_std::__invoke_radians<T0>(a0);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, float, double, half>) && detail::check_all_same_op_type_v<T0, T1>, T0> step(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_step<T0>(a0, a1);
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::check_type_in_v<T0, float, double, half>) && detail::check_all_same_op_type_v<T0, T1, T2>, T0> smoothstep(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_smoothstep<T0>(a0, a1, a2);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, float, double, half>), T0> sign(T0 a0) __NOEXC {
  return __sycl_std::__invoke_sign<T0>(a0);
}

template <typename T0>
__SYCL_DEPRECATED("abs for floating point types is non-standard and has been deprecated. Please use fabs instead.")
std::enable_if_t<(detail::check_type_in_v<T0, float, double, half>), T0> abs(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fabs<T0>(a0);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>), T0> abs(T0 a0) __NOEXC {
return static_cast<T0>(__sycl_std::__invoke_s_abs<detail::make_unsigned_t<T0>>(a0));
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long>), T0> abs(T0 a0) __NOEXC {
  return __sycl_std::__invoke_u_abs<T0>(a0);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, float, double, half>) && detail::check_all_same_op_type_v<T0, T1>, T0> dot(T0 a0, T1 a1) __NOEXC {
  return a0 * a1;
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, float>) && detail::check_all_same_op_type_v<T0, T1>, float> distance(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_distance<float>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, double>) && detail::check_all_same_op_type_v<T0, T1>, double> distance(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_distance<double>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, half>) && detail::check_all_same_op_type_v<T0, T1>, half> distance(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_distance<half>(a0, a1);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, float>), float> length(T0 a0) __NOEXC {
  return __sycl_std::__invoke_length<float>(a0);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, double>), double> length(T0 a0) __NOEXC {
  return __sycl_std::__invoke_length<double>(a0);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, half>), half> length(T0 a0) __NOEXC {
  return __sycl_std::__invoke_length<half>(a0);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, float>), T0> normalize(T0 a0) __NOEXC {
  return __sycl_std::__invoke_normalize<T0>(a0);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, double>), T0> normalize(T0 a0) __NOEXC {
  return __sycl_std::__invoke_normalize<T0>(a0);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, half>), T0> normalize(T0 a0) __NOEXC {
  return __sycl_std::__invoke_normalize<T0>(a0);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, float>) && detail::check_all_same_op_type_v<T0, T1>, float> fast_distance(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fast_distance<float>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, double>) && detail::check_all_same_op_type_v<T0, T1>, double> fast_distance(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fast_distance<double>(a0, a1);
}

template <typename T0, typename T1>
std::enable_if_t<(detail::check_type_in_v<T0, half>) && detail::check_all_same_op_type_v<T0, T1>, half> fast_distance(T0 a0, T1 a1) __NOEXC {
  return __sycl_std::__invoke_fast_distance<half>(a0, a1);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, float>), float> fast_length(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fast_length<float>(a0);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, double>), double> fast_length(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fast_length<double>(a0);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, half>), half> fast_length(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fast_length<half>(a0);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, float>), T0> fast_normalize(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fast_normalize<T0>(a0);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, double>), T0> fast_normalize(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fast_normalize<T0>(a0);
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, half>), T0> fast_normalize(T0 a0) __NOEXC {
  return __sycl_std::__invoke_fast_normalize<T0>(a0);
}

inline bool isequal(float a0, float a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isequal(double a0, double a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isequal(half a0, half a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isnotequal(float a0, float a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FUnordNotEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isnotequal(double a0, double a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FUnordNotEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isnotequal(half a0, half a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FUnordNotEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isgreater(float a0, float a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdGreaterThan<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isgreater(double a0, double a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdGreaterThan<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isgreater(half a0, half a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdGreaterThan<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isgreaterequal(float a0, float a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdGreaterThanEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isgreaterequal(double a0, double a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdGreaterThanEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isgreaterequal(half a0, half a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdGreaterThanEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isless(float a0, float a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdLessThan<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isless(double a0, double a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdLessThan<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isless(half a0, half a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdLessThan<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool islessequal(float a0, float a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdLessThanEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool islessequal(double a0, double a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdLessThanEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool islessequal(half a0, half a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdLessThanEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool islessgreater(float a0, float a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdNotEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool islessgreater(double a0, double a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdNotEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool islessgreater(half a0, half a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_FOrdNotEqual<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isfinite(float a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_IsFinite<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool isfinite(double a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_IsFinite<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool isfinite(half a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_IsFinite<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool isinf(float a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_IsInf<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool isinf(double a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_IsInf<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool isinf(half a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_IsInf<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool isnan(float a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_IsNan<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool isnan(double a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_IsNan<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool isnan(half a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_IsNan<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool isnormal(float a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_IsNormal<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool isnormal(double a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_IsNormal<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool isnormal(half a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_IsNormal<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool isordered(float a0, float a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_Ordered<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isordered(double a0, double a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_Ordered<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isordered(half a0, half a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_Ordered<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isunordered(float a0, float a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_Unordered<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isunordered(double a0, double a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_Unordered<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool isunordered(half a0, half a1) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_Unordered<detail::internal_rel_ret_t<bool>>(a0, a1));
}

inline bool signbit(float a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_SignBitSet<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool signbit(double a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_SignBitSet<detail::internal_rel_ret_t<bool>>(a0));
}

inline bool signbit(half a0) __NOEXC {
  return detail::RelConverter<bool>::apply(__sycl_std::__invoke_SignBitSet<detail::internal_rel_ret_t<bool>>(a0));
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>), bool> any(T0 a0) __NOEXC {
  return bool(int(detail::msbIsSet(a0)));
}

template <typename T0>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long>), bool> all(T0 a0) __NOEXC {
  return bool(int(detail::msbIsSet(a0)));
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long, float, double, half>) && detail::check_all_same_op_type_v<T0, T1, T2>, T0> bitselect(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_bitselect<T0>(a0, a1, a2);
}

template <typename T0, typename T1, typename T2>
std::enable_if_t<(detail::check_type_in_v<T0, char, signed char, short, int, long, long long, unsigned char, unsigned short, unsigned int, unsigned long, unsigned long long, float, double, half>) && detail::check_all_same_op_type_v<T0, T1> && (detail::check_type_in_v<T2, bool>), T0> select(T0 a0, T1 a1, T2 a2) __NOEXC {
  return __sycl_std::__invoke_select<T0>(
      a0, a1, static_cast<detail::get_select_opencl_builtin_c_arg_type<T0>>(a2));
}

namespace native {
inline float cos(float a0) __NOEXC {
  return __sycl_std::__invoke_native_cos<float>(a0);
}

inline float divide(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_native_divide<float>(a0, a1);
}

inline float exp(float a0) __NOEXC {
  return __sycl_std::__invoke_native_exp<float>(a0);
}

inline float exp2(float a0) __NOEXC {
  return __sycl_std::__invoke_native_exp2<float>(a0);
}

inline float exp10(float a0) __NOEXC {
  return __sycl_std::__invoke_native_exp10<float>(a0);
}

inline float log(float a0) __NOEXC {
  return __sycl_std::__invoke_native_log<float>(a0);
}

inline float log2(float a0) __NOEXC {
  return __sycl_std::__invoke_native_log2<float>(a0);
}

inline float log10(float a0) __NOEXC {
  return __sycl_std::__invoke_native_log10<float>(a0);
}

inline float powr(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_native_powr<float>(a0, a1);
}

inline float recip(float a0) __NOEXC {
  return __sycl_std::__invoke_native_recip<float>(a0);
}

inline float rsqrt(float a0) __NOEXC {
  return __sycl_std::__invoke_native_rsqrt<float>(a0);
}

inline float sin(float a0) __NOEXC {
  return __sycl_std::__invoke_native_sin<float>(a0);
}

inline float sqrt(float a0) __NOEXC {
  return __sycl_std::__invoke_native_sqrt<float>(a0);
}

inline float tan(float a0) __NOEXC {
  return __sycl_std::__invoke_native_tan<float>(a0);
}
} // namespace native

namespace half_precision {
inline float cos(float a0) __NOEXC {
  return __sycl_std::__invoke_half_cos<float>(a0);
}

inline float divide(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_half_divide<float>(a0, a1);
}

inline float exp(float a0) __NOEXC {
  return __sycl_std::__invoke_half_exp<float>(a0);
}

inline float exp2(float a0) __NOEXC {
  return __sycl_std::__invoke_half_exp2<float>(a0);
}

inline float exp10(float a0) __NOEXC {
  return __sycl_std::__invoke_half_exp10<float>(a0);
}

inline float log(float a0) __NOEXC {
  return __sycl_std::__invoke_half_log<float>(a0);
}

inline float log2(float a0) __NOEXC {
  return __sycl_std::__invoke_half_log2<float>(a0);
}

inline float log10(float a0) __NOEXC {
  return __sycl_std::__invoke_half_log10<float>(a0);
}

inline float powr(float a0, float a1) __NOEXC {
  return __sycl_std::__invoke_half_powr<float>(a0, a1);
}

inline float recip(float a0) __NOEXC {
  return __sycl_std::__invoke_half_recip<float>(a0);
}

inline float rsqrt(float a0) __NOEXC {
  return __sycl_std::__invoke_half_rsqrt<float>(a0);
}

inline float sin(float a0) __NOEXC {
  return __sycl_std::__invoke_half_sin<float>(a0);
}

inline float sqrt(float a0) __NOEXC {
  return __sycl_std::__invoke_half_sqrt<float>(a0);
}

inline float tan(float a0) __NOEXC {
  return __sycl_std::__invoke_half_tan<float>(a0);
}
} // namespace half_precision

} // namespace _V1
} // namespace sycl

#undef __NOEXC
