/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy.tabbed;

import com.google.common.base.Preconditions;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class MakeSiblingsDisjointChangeGenerator<E extends OWLEntity> {
    private final OWLObjectHierarchyProvider<E> hierarchyProvider;
    private final Function<Set<E>, Set<E>> siblingsExtractor;
    private final Function<Set<E>, OWLAxiom> disjointSiblingsAxiomFactory;
    private final OWLOntology targetOntology;

    public MakeSiblingsDisjointChangeGenerator(@Nonnull OWLObjectHierarchyProvider<E> existingHierarchyProvider, @Nonnull Function<Set<E>, Set<E>> disjointSiblingsExtractor, @Nonnull Function<Set<E>, OWLAxiom> disjointSiblingsAxiomFactory, @Nonnull OWLOntology targetOntology) {
        this.hierarchyProvider = (OWLObjectHierarchyProvider)Preconditions.checkNotNull(existingHierarchyProvider);
        this.siblingsExtractor = (Function)Preconditions.checkNotNull(disjointSiblingsExtractor);
        this.disjointSiblingsAxiomFactory = (Function)Preconditions.checkNotNull(disjointSiblingsAxiomFactory);
        this.targetOntology = (OWLOntology)Preconditions.checkNotNull((Object)targetOntology);
    }

    @Nonnull
    public List<OWLOntologyChange> generateChanges(@Nonnull SetMultimap<E, E> parent2ChildMap) {
        Preconditions.checkNotNull(parent2ChildMap);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (OWLEntity parent : parent2ChildMap.keySet()) {
            Set children = parent2ChildMap.get((Object)parent);
            Set<OWLEntity> existingChildren = this.hierarchyProvider.getChildren(parent);
            Sets.SetView unionOfChildren = Sets.union((Set)children, existingChildren);
            Set<E> siblingsToMakeDisjoint = this.siblingsExtractor.apply((Set<E>)unionOfChildren);
            this.generateChanges(siblingsToMakeDisjoint, changes);
        }
        return changes;
    }

    private void generateChanges(@Nonnull Set<E> siblingsToMakeDisjoint, @Nonnull List<OWLOntologyChange> changes) {
        if (siblingsToMakeDisjoint.size() < 2) {
            return;
        }
        OWLAxiom disjointSiblingsAxiom = this.disjointSiblingsAxiomFactory.apply(siblingsToMakeDisjoint);
        changes.add((OWLOntologyChange)new AddAxiom(this.targetOntology, disjointSiblingsAxiom));
    }
}

