from typing_extensions import Self

from .enums import CredentialType

class Username:
    def __init__(self, username: str) -> None: ...
    @property
    def credential_type(self) -> CredentialType: ...
    @property
    def credential_tuple(self) -> tuple[str]: ...
    def __call__(self, _url: str, _username: str | None, _allowed: CredentialType) -> Self: ...

class UserPass:
    def __init__(self, username: str, password: str) -> None: ...
    @property
    def credential_type(self) -> CredentialType: ...
    @property
    def credential_tuple(self) -> tuple[str, str]: ...
    def __call__(self, _url: str, _username: str | None, _allowed: CredentialType) -> Self: ...

class Keypair:
    def __init__(self, username: str, pubkey: str, privkey: str, passphrase: str) -> None: ...
    @property
    def credential_type(self) -> CredentialType: ...
    @property
    def credential_tuple(self) -> tuple[str, str, str, str]: ...
    def __call__(self, _url: str, _username: str | None, _allowed: CredentialType) -> Self: ...

class KeypairFromAgent(Keypair):
    def __init__(self, username: str) -> None: ...

class KeypairFromMemory(Keypair):
    @property
    def credential_type(self) -> CredentialType: ...
