/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl;

import java.nio.ByteBuffer;

public abstract class GLBufferStorage {
    private final int name;
    private long size;
    private int mutableUsage;
    private int immutableFlags;
    private ByteBuffer mappedBuffer;
    private static final String msgClazzName = "GLBufferStorage";

    protected GLBufferStorage(int n, long l, int n2, int n3) {
        this.name = n;
        this.size = l;
        this.mutableUsage = n2;
        this.immutableFlags = n3;
        this.mappedBuffer = null;
    }

    protected void reset(long l, int n, int n2) {
        this.size = l;
        this.mutableUsage = n;
        this.immutableFlags = n2;
        this.mappedBuffer = null;
    }

    protected void setMappedBuffer(ByteBuffer byteBuffer) {
        this.mappedBuffer = byteBuffer;
    }

    public final int getName() {
        return this.name;
    }

    public final long getSize() {
        return this.size;
    }

    public final boolean isMutableStorage() {
        return 0 != this.mutableUsage;
    }

    public final int getMutableUsage() {
        return this.mutableUsage;
    }

    public final int getImmutableFlags() {
        return this.immutableFlags;
    }

    public final ByteBuffer getMappedBuffer() {
        return this.mappedBuffer;
    }

    public final String toString() {
        return this.toString(false);
    }

    public final String toString(boolean bl) {
        String string = this.isMutableStorage() ? String.format("%s[name %s, size %d, mutable usage 0x%X", msgClazzName, this.name, this.size, this.mutableUsage) : String.format("%s[name %s, size %d, immutable flags 0x%X", msgClazzName, this.name, this.size, this.immutableFlags);
        if (bl) {
            return string + "]";
        }
        return string + ", mapped " + this.mappedBuffer + "]";
    }
}

