/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.utils;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.core.network.utils.IpAddressUtils;

class IpAddressUtilsFilter {
    private static final boolean JDK_PREFER_IPV6_ADDRESS = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.getBoolean("java.net.preferIPv6Addresses");
        }
    });

    private IpAddressUtilsFilter() {
    }

    protected static InetAddress pickInetAddress(Iterable<InetAddress> iterable, IpAddressUtils.IpTypePreference ipTypePreference) {
        IpAddressUtils.IpTypePreference ipTypePreference2 = IpAddressUtilsFilter.getIpTypePreferenceResolved(ipTypePreference);
        for (InetAddress inetAddress : iterable) {
            if (ipTypePreference2 == IpAddressUtils.IpTypePreference.ANY_IPV4_PREF || ipTypePreference2 == IpAddressUtils.IpTypePreference.ANY_IPV6_PREF) {
                return inetAddress;
            }
            if (inetAddress instanceof Inet4Address && ipTypePreference2 == IpAddressUtils.IpTypePreference.IPV4_ONLY) {
                return inetAddress;
            }
            if (!(inetAddress instanceof Inet6Address) || ipTypePreference2 != IpAddressUtils.IpTypePreference.IPV6_ONLY) continue;
            return inetAddress;
        }
        return null;
    }

    @NonNull
    protected static List<InetAddress> filterInetAddresses(Iterable<InetAddress> iterable, IpAddressUtils.IpTypePreference ipTypePreference) {
        IpAddressUtils.IpTypePreference ipTypePreference2 = IpAddressUtilsFilter.getIpTypePreferenceResolved(ipTypePreference);
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>();
        if (iterable != null) {
            for (InetAddress inetAddress : iterable) {
                if (ipTypePreference2 == IpAddressUtils.IpTypePreference.ANY_IPV4_PREF || ipTypePreference2 == IpAddressUtils.IpTypePreference.ANY_IPV6_PREF) {
                    arrayList.add(inetAddress);
                    continue;
                }
                if (inetAddress instanceof Inet4Address && ipTypePreference2 == IpAddressUtils.IpTypePreference.IPV4_ONLY) {
                    arrayList.add(inetAddress);
                }
                if (!(inetAddress instanceof Inet6Address) || ipTypePreference2 != IpAddressUtils.IpTypePreference.IPV6_ONLY) continue;
                arrayList.add(inetAddress);
            }
        }
        if (ipTypePreference2 == IpAddressUtils.IpTypePreference.ANY_IPV4_PREF) {
            IpAddressUtils.sortIpAddressesShallow(arrayList, true);
        }
        if (ipTypePreference2 == IpAddressUtils.IpTypePreference.ANY_IPV6_PREF) {
            IpAddressUtils.sortIpAddressesShallow(arrayList, false);
        }
        return arrayList;
    }

    private static IpAddressUtils.IpTypePreference getIpTypePreferenceResolved(IpAddressUtils.IpTypePreference ipTypePreference) {
        if (ipTypePreference == IpAddressUtils.IpTypePreference.ANY_JDK_PREF) {
            if (JDK_PREFER_IPV6_ADDRESS) {
                return IpAddressUtils.IpTypePreference.ANY_IPV6_PREF;
            }
            return IpAddressUtils.IpTypePreference.ANY_IPV4_PREF;
        }
        return ipTypePreference;
    }
}

