# 1 "otherlibs/ocamlc_loc/src/lexer.mll"
 
  (* raise when the format is unrecognized *)
  exception Unknown_format

  type lines =
    | Single of int
    | Range of int * int

  type code =
    { code : int
    ; name : string
    }

  type source =
    | Code of code
    | Alert of string

  type severity =
    | Error of source option
    | Warning of code
    | Alert of { name : string ; source : string }

  type loc =
    { chars : (int * int) option
    ; lines : lines
    ; path : string
    }

  type line = { indent : int ; contents : string }

  type token =
    | Loc of { indent : int ; loc : loc ; message : string }
    | Line of line
    | Eof

  let parse_range s =
    match String.split_on_char '-' s with
    | [x; y] -> (int_of_string x, int_of_string y)
    | _ -> assert false

# 43 "otherlibs/ocamlc_loc/src/lexer.ml"
let __ocaml_lex_tables = {
  Lexing.lex_base =
   "\000\000\254\255\010\000\059\000\000\000\001\000\001\000\255\255\
    \085\000\252\255\005\000\095\000\144\000\000\000\001\000\006\000\
    \255\255\000\000\001\000\002\000\002\000\254\255\253\255\011\000\
    \005\000\010\000\000\000\005\000\006\000\010\000\008\000\145\000\
    \004\000\064\000\146\000\013\000\003\000\009\000\018\000\003\000\
    \015\000\020\000\000\000\022\000\000\000\156\000\222\000\008\000\
    \070\000\063\000\000\000\011\000\151\000\004\000\061\000\049\000\
    \050\000\003\000\030\000\034\000\018\000\158\000\005\000\054\000\
    \060\000\067\000\063\000\071\000\253\000\023\001\049\001\075\001\
    \078\000\087\000\205\000\089\000\020\000\207\000\007\000\080\000\
    \070\000\071\000\004\000\077\001\160\001\219\000\009\000\220\000\
    \254\255\255\255\028\000\028\001\103\001\254\255\084\000\210\000\
    \083\000\101\000\007\000\006\000\056\000\000\000\048\000\212\000\
    \110\000\107\000\121\000\202\000\049\000\088\001\111\001\139\001\
    \191\001\120\000\129\000\113\000\139\000\141\000\125\000\142\000\
    \131\000\131\000\018\002\243\001\003\002\028\002\192\001\255\255\
    \083\000\255\255\029\001\039\002\056\002\066\002\080\002\131\002\
    \133\002\143\000\151\000\135\000\153\000\154\000\139\000\166\000\
    \154\000\166\000\134\002\100\002\119\002\145\002\149\002\255\255\
    \033\001\255\255\049\001";
  Lexing.lex_backtrk =
   "\002\000\255\255\255\255\255\255\255\255\255\255\000\000\255\255\
    \004\000\255\255\002\000\255\255\255\255\255\255\255\255\000\000\
    \255\255\000\000\255\255\255\255\001\000\255\255\255\255\002\000\
    \005\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\000\000\000\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\002\000\002\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\004\000\004\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\001\000\001\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\003\000\003\000\000\000\
    \255\255\255\255\000\000\000\000\002\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\000\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\000\000\255\255\
    \000\000\255\255\000\000\255\255\255\255\255\255\255\255\000\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\000\000\255\255\
    \000\000\255\255\000\000";
  Lexing.lex_default =
   "\255\255\000\000\255\255\255\255\255\255\255\255\006\000\000\000\
    \255\255\000\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \000\000\255\255\255\255\255\255\020\000\000\000\000\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\036\000\036\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\049\000\
    \255\255\049\000\255\255\255\255\053\000\053\000\255\255\255\255\
    \255\255\255\255\059\000\059\000\255\255\062\000\062\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\075\000\255\255\075\000\255\255\078\000\078\000\255\255\
    \255\255\255\255\255\255\255\255\255\255\086\000\086\000\090\000\
    \000\000\000\000\090\000\090\000\255\255\000\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\100\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\130\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\128\000\000\000\
    \128\000\000\000\130\000\255\255\255\255\255\255\255\255\154\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\152\000\000\000\
    \152\000\000\000\154\000";
  Lexing.lex_trans =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\003\000\016\000\007\000\021\000\003\000\023\000\022\000\
    \016\000\000\000\023\000\017\000\023\000\022\000\035\000\000\000\
    \023\000\000\000\035\000\000\000\000\000\000\000\000\000\000\000\
    \003\000\006\000\020\000\058\000\083\000\023\000\089\000\099\000\
    \100\000\051\000\004\000\023\000\102\000\035\000\014\000\015\000\
    \002\000\002\000\002\000\002\000\002\000\002\000\002\000\002\000\
    \002\000\002\000\002\000\002\000\002\000\002\000\002\000\002\000\
    \002\000\002\000\002\000\002\000\003\000\052\000\025\000\255\255\
    \003\000\033\000\027\000\060\000\061\000\033\000\077\000\048\000\
    \103\000\131\000\000\000\048\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\101\000\003\000\026\000\127\000\012\000\000\000\
    \033\000\063\000\012\000\010\000\040\000\255\255\048\000\045\000\
    \032\000\043\000\038\000\002\000\002\000\002\000\002\000\002\000\
    \002\000\002\000\002\000\002\000\002\000\012\000\079\000\028\000\
    \029\000\030\000\031\000\039\000\005\000\019\000\054\000\018\000\
    \039\000\041\000\042\000\013\000\044\000\011\000\011\000\011\000\
    \011\000\011\000\011\000\011\000\011\000\011\000\011\000\011\000\
    \011\000\011\000\011\000\011\000\011\000\011\000\011\000\011\000\
    \011\000\012\000\033\000\033\000\050\000\012\000\033\000\033\000\
    \052\000\047\000\055\000\056\000\052\000\045\000\057\000\061\000\
    \064\000\045\000\065\000\061\000\066\000\067\000\068\000\038\000\
    \012\000\034\000\033\000\010\000\255\255\080\000\076\000\052\000\
    \081\000\032\000\037\000\082\000\045\000\096\000\061\000\097\000\
    \011\000\011\000\011\000\011\000\011\000\011\000\011\000\011\000\
    \011\000\011\000\098\000\035\000\046\000\046\000\046\000\046\000\
    \046\000\046\000\046\000\046\000\046\000\046\000\074\000\105\000\
    \077\000\106\000\074\000\095\000\077\000\103\000\107\000\095\000\
    \114\000\103\000\115\000\116\000\085\000\091\000\089\000\048\000\
    \085\000\091\000\109\000\048\000\117\000\074\000\010\000\077\000\
    \118\000\119\000\095\000\120\000\103\000\121\000\122\000\138\000\
    \139\000\140\000\141\000\085\000\091\000\142\000\048\000\143\000\
    \001\000\255\255\255\255\255\255\255\255\255\255\070\000\255\255\
    \255\255\255\255\070\000\144\000\145\000\255\255\046\000\046\000\
    \046\000\046\000\046\000\046\000\046\000\046\000\046\000\046\000\
    \094\000\146\000\000\000\000\000\255\255\071\000\255\255\000\000\
    \074\000\000\000\255\255\000\000\074\000\091\000\089\000\129\000\
    \073\000\091\000\000\000\151\000\000\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\074\000\
    \255\255\047\000\070\000\153\000\091\000\108\000\070\000\255\255\
    \104\000\000\000\000\000\000\000\000\000\000\000\000\000\069\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\070\000\000\000\255\255\070\000\009\000\083\000\255\255\
    \070\000\255\255\083\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\070\000\000\000\083\000\000\000\000\000\
    \095\000\000\000\073\000\072\000\095\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\069\000\069\000\000\000\000\000\095\000\
    \110\000\110\000\110\000\110\000\110\000\110\000\110\000\110\000\
    \110\000\110\000\000\000\000\000\111\000\129\000\000\000\255\255\
    \111\000\000\000\000\000\112\000\000\000\000\000\255\255\110\000\
    \110\000\110\000\110\000\110\000\110\000\110\000\110\000\110\000\
    \110\000\111\000\000\000\111\000\000\000\094\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \112\000\126\000\127\000\000\000\112\000\126\000\000\000\255\255\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\085\000\255\255\088\000\000\000\000\000\112\000\
    \126\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\000\000\000\000\000\000\000\000\084\000\
    \000\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\122\000\255\255\255\255\000\000\122\000\
    \124\000\255\255\113\000\123\000\123\000\123\000\123\000\123\000\
    \123\000\123\000\123\000\123\000\123\000\000\000\000\000\000\000\
    \000\000\255\255\122\000\125\000\125\000\125\000\125\000\125\000\
    \125\000\125\000\125\000\125\000\125\000\000\000\000\000\000\000\
    \000\000\000\000\123\000\123\000\123\000\123\000\123\000\123\000\
    \123\000\123\000\123\000\123\000\125\000\125\000\125\000\125\000\
    \125\000\125\000\125\000\125\000\125\000\125\000\126\000\132\000\
    \132\000\132\000\132\000\132\000\132\000\132\000\132\000\132\000\
    \132\000\000\000\000\000\000\000\000\000\133\000\000\000\093\000\
    \132\000\132\000\132\000\132\000\132\000\132\000\132\000\132\000\
    \132\000\132\000\134\000\134\000\134\000\134\000\134\000\134\000\
    \134\000\134\000\134\000\134\000\136\000\000\000\000\000\000\000\
    \134\000\134\000\134\000\134\000\134\000\134\000\134\000\134\000\
    \134\000\134\000\135\000\255\255\135\000\153\000\136\000\146\000\
    \135\000\148\000\136\000\146\000\147\000\147\000\147\000\147\000\
    \147\000\147\000\147\000\147\000\147\000\147\000\150\000\151\000\
    \000\000\000\000\150\000\135\000\000\000\136\000\146\000\149\000\
    \149\000\149\000\149\000\149\000\149\000\149\000\149\000\149\000\
    \149\000\000\000\000\000\000\000\000\000\150\000\147\000\147\000\
    \147\000\147\000\147\000\147\000\147\000\147\000\147\000\147\000\
    \255\255\149\000\149\000\149\000\149\000\149\000\149\000\149\000\
    \149\000\149\000\149\000\150\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \137\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\255\255\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\255\255";
  Lexing.lex_check =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\000\000\017\000\006\000\020\000\000\000\010\000\010\000\
    \015\000\255\255\010\000\015\000\023\000\023\000\035\000\255\255\
    \023\000\255\255\035\000\255\255\255\255\255\255\255\255\255\255\
    \000\000\005\000\019\000\057\000\082\000\010\000\090\000\098\000\
    \099\000\050\000\002\000\023\000\101\000\035\000\013\000\014\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\002\000\002\000\002\000\002\000\002\000\002\000\
    \002\000\002\000\002\000\002\000\003\000\051\000\024\000\058\000\
    \003\000\033\000\024\000\059\000\060\000\033\000\076\000\048\000\
    \102\000\108\000\255\255\048\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\100\000\003\000\024\000\128\000\008\000\255\255\
    \033\000\026\000\008\000\010\000\039\000\047\000\048\000\044\000\
    \033\000\042\000\037\000\003\000\003\000\003\000\003\000\003\000\
    \003\000\003\000\003\000\003\000\003\000\008\000\025\000\027\000\
    \028\000\029\000\030\000\032\000\004\000\018\000\038\000\011\000\
    \037\000\040\000\041\000\008\000\043\000\008\000\008\000\008\000\
    \008\000\008\000\008\000\008\000\008\000\008\000\008\000\011\000\
    \011\000\011\000\011\000\011\000\011\000\011\000\011\000\011\000\
    \011\000\012\000\031\000\034\000\049\000\012\000\031\000\034\000\
    \052\000\048\000\054\000\055\000\052\000\045\000\056\000\061\000\
    \063\000\045\000\064\000\061\000\065\000\066\000\067\000\072\000\
    \012\000\031\000\034\000\008\000\073\000\079\000\075\000\052\000\
    \080\000\031\000\034\000\081\000\045\000\094\000\061\000\096\000\
    \012\000\012\000\012\000\012\000\012\000\012\000\012\000\012\000\
    \012\000\012\000\097\000\031\000\045\000\045\000\045\000\045\000\
    \045\000\045\000\045\000\045\000\045\000\045\000\074\000\104\000\
    \077\000\105\000\074\000\095\000\077\000\103\000\106\000\095\000\
    \113\000\103\000\114\000\115\000\085\000\087\000\087\000\046\000\
    \085\000\087\000\107\000\046\000\116\000\074\000\012\000\077\000\
    \117\000\118\000\095\000\119\000\103\000\120\000\121\000\137\000\
    \138\000\139\000\140\000\085\000\087\000\141\000\046\000\142\000\
    \000\000\006\000\020\000\036\000\053\000\062\000\068\000\078\000\
    \047\000\086\000\068\000\143\000\144\000\035\000\046\000\046\000\
    \046\000\046\000\046\000\046\000\046\000\046\000\046\000\046\000\
    \095\000\145\000\255\255\255\255\090\000\068\000\058\000\255\255\
    \069\000\255\255\059\000\255\255\069\000\091\000\091\000\130\000\
    \074\000\091\000\255\255\152\000\255\255\068\000\068\000\068\000\
    \068\000\068\000\068\000\068\000\068\000\068\000\068\000\069\000\
    \100\000\046\000\070\000\154\000\091\000\107\000\070\000\049\000\
    \103\000\255\255\255\255\255\255\255\255\255\255\255\255\069\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\069\000\
    \069\000\070\000\255\255\128\000\071\000\008\000\083\000\073\000\
    \071\000\075\000\083\000\255\255\255\255\255\255\255\255\255\255\
    \255\255\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \070\000\070\000\070\000\071\000\255\255\083\000\255\255\255\255\
    \092\000\255\255\069\000\071\000\092\000\255\255\255\255\255\255\
    \255\255\255\255\255\255\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\071\000\071\000\255\255\255\255\092\000\
    \109\000\109\000\109\000\109\000\109\000\109\000\109\000\109\000\
    \109\000\109\000\255\255\255\255\111\000\111\000\255\255\052\000\
    \111\000\255\255\255\255\110\000\255\255\255\255\061\000\110\000\
    \110\000\110\000\110\000\110\000\110\000\110\000\110\000\110\000\
    \110\000\110\000\255\255\111\000\255\255\092\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \112\000\126\000\126\000\255\255\112\000\126\000\255\255\077\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\085\000\087\000\255\255\255\255\112\000\
    \126\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\255\255\255\255\255\255\255\255\084\000\
    \255\255\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\122\000\091\000\130\000\255\255\122\000\
    \123\000\152\000\112\000\123\000\123\000\123\000\123\000\123\000\
    \123\000\123\000\123\000\123\000\123\000\255\255\255\255\255\255\
    \255\255\154\000\122\000\124\000\124\000\124\000\124\000\124\000\
    \124\000\124\000\124\000\124\000\124\000\255\255\255\255\255\255\
    \255\255\255\255\122\000\122\000\122\000\122\000\122\000\122\000\
    \122\000\122\000\122\000\122\000\125\000\125\000\125\000\125\000\
    \125\000\125\000\125\000\125\000\125\000\125\000\125\000\131\000\
    \131\000\131\000\131\000\131\000\131\000\131\000\131\000\131\000\
    \131\000\255\255\255\255\255\255\255\255\132\000\255\255\092\000\
    \132\000\132\000\132\000\132\000\132\000\132\000\132\000\132\000\
    \132\000\132\000\133\000\133\000\133\000\133\000\133\000\133\000\
    \133\000\133\000\133\000\133\000\134\000\255\255\255\255\255\255\
    \134\000\134\000\134\000\134\000\134\000\134\000\134\000\134\000\
    \134\000\134\000\134\000\111\000\135\000\135\000\136\000\146\000\
    \135\000\147\000\136\000\146\000\147\000\147\000\147\000\147\000\
    \147\000\147\000\147\000\147\000\147\000\147\000\150\000\150\000\
    \255\255\255\255\150\000\135\000\255\255\136\000\146\000\148\000\
    \148\000\148\000\148\000\148\000\148\000\148\000\148\000\148\000\
    \148\000\255\255\255\255\255\255\255\255\150\000\146\000\146\000\
    \146\000\146\000\146\000\146\000\146\000\146\000\146\000\146\000\
    \126\000\149\000\149\000\149\000\149\000\149\000\149\000\149\000\
    \149\000\149\000\149\000\149\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \136\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\135\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\150\000";
  Lexing.lex_base_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\010\000\000\000\
    \000\000\001\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\002\000\003\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\001\000\067\000\077\000\126\000\137\000\
    \000\000\004\000\001\000\005\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\001\000\127\000\214\000\002\000\000\000\128\000\
    \000\000\075\000\017\000\134\000\003\000\000\000\000\000\005\000\
    \000\000\000\000\000\000\002\000\049\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\006\000\007\000\147\000\157\000\139\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\027\000\008\000\000\000\033\001\043\001\152\000\116\000\
    \018\000\096\000\019\000\000\000\000\000\054\001\064\001\114\001\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\030\000\010\000\000\000\105\001\115\001\116\001\155\000\
    \020\000\138\000\021\000";
  Lexing.lex_backtrk_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\016\000\016\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\028\000\028\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\050\000\050\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\068\000\068\000\075\000\
    \000\000\000\000\075\000\075\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\096\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\116\000\000\000\
    \116\000\000\000\096\000\000\000\000\000\000\000\000\000\138\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\155\000\000\000\
    \155\000\000\000\138\000";
  Lexing.lex_default_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\013\000\
    \000\000\013\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\025\000\025\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\047\000\000\000\047\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\080\000\
    \000\000\000\000\080\000\080\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\041\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\059\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\059\000\000\000\
    \059\000\000\000\059\000\000\000\000\000\000\000\000\000\059\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\059\000\000\000\
    \059\000\000\000\059\000";
  Lexing.lex_trans_code =
   "\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\004\000\000\000\065\000\038\000\004\000\038\000\065\000\
    \038\000\065\000\038\000\065\000\000\000\065\000\000\000\065\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \004\000\059\000\065\000\038\000\041\000\038\000\044\000\088\000\
    \065\000\000\000\065\000\000\000\000\000\000\000\000\000\000\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
    \007\000\007\000\007\000\007\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\038\000\000\000\000\000\000\000\
    \038\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\010\000\044\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\038\000\000\000\010\000\000\000\004\000\
    \033\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\001\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\038\000\
    \059\000\083\000\000\000\038\000\059\000\083\000\065\000\083\000\
    \000\000\065\000\038\000\083\000\091\000\000\000\038\000\000\000\
    \091\000\000\000\000\000\000\000\000\000\000\000\038\000\059\000\
    \083\000\091\000\000\000\000\000\000\000\091\000\083\000\000\000\
    \044\000\038\000\000\000\091\000\000\000\000\000\041\000\041\000\
    \041\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \091\000\041\000\041\000\041\000\041\000\041\000\041\000\041\000\
    \041\000\041\000\041\000\047\000\047\000\047\000\047\000\047\000\
    \047\000\047\000\047\000\047\000\047\000\047\000\047\000\047\000\
    \047\000\047\000\047\000\047\000\047\000\047\000\047\000\091\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
    \062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
    \062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
    \062\000\062\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\062\000\062\000\
    \062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
    \065\000\000\000\000\000\000\000\000\000\000\000\000\000\062\000\
    \062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
    \062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
    \062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
    \062\000\000\000\000\000\000\000\000\000\062\000\000\000\062\000\
    \062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
    \062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
    \062\000\062\000\062\000\062\000\062\000\062\000\062\000\062\000\
    \062\000\113\000\113\000\113\000\113\000\113\000\113\000\113\000\
    \113\000\113\000\113\000\113\000\113\000\113\000\113\000\113\000\
    \113\000\113\000\113\000\113\000\113\000\091\000\135\000\135\000\
    \135\000\135\000\135\000\135\000\135\000\135\000\135\000\135\000\
    \135\000\135\000\135\000\135\000\135\000\135\000\135\000\135\000\
    \135\000\135\000\091\000\091\000\000\000\091\000\000\000\091\000\
    \000\000\091\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\091\000\000\000\091\000\000\000\000\000\000\000\
    \000\000\113\000\113\000\113\000\113\000\113\000\113\000\113\000\
    \113\000\113\000\113\000\113\000\113\000\113\000\113\000\113\000\
    \113\000\113\000\113\000\113\000\113\000\091\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
    \000\000\000\000\000\000\000\000\000\000";
  Lexing.lex_check_code =
   "\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\045\000\255\255\085\000\092\000\045\000\095\000\085\000\
    \092\000\122\000\095\000\146\000\255\255\122\000\255\255\146\000\
    \255\255\255\255\255\255\090\000\128\000\130\000\152\000\154\000\
    \045\000\082\000\085\000\092\000\099\000\095\000\107\000\108\000\
    \122\000\255\255\146\000\058\000\059\000\255\255\255\255\255\255\
    \045\000\045\000\045\000\045\000\045\000\045\000\045\000\045\000\
    \045\000\045\000\046\000\046\000\046\000\046\000\046\000\046\000\
    \046\000\046\000\046\000\046\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\068\000\255\255\255\255\255\255\
    \068\000\255\255\255\255\100\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\048\000\074\000\047\000\049\000\255\255\
    \255\255\073\000\075\000\068\000\255\255\046\000\255\255\044\000\
    \067\000\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\030\000\068\000\068\000\068\000\068\000\068\000\
    \068\000\068\000\068\000\068\000\068\000\069\000\069\000\069\000\
    \069\000\069\000\069\000\069\000\069\000\069\000\069\000\070\000\
    \083\000\087\000\087\000\070\000\083\000\087\000\121\000\091\000\
    \091\000\145\000\071\000\091\000\111\000\111\000\071\000\255\255\
    \111\000\255\255\255\255\255\255\255\255\255\255\070\000\083\000\
    \087\000\126\000\126\000\255\255\255\255\126\000\091\000\255\255\
    \069\000\071\000\255\255\111\000\255\255\255\255\070\000\070\000\
    \070\000\070\000\070\000\070\000\070\000\070\000\070\000\070\000\
    \126\000\071\000\071\000\071\000\071\000\071\000\071\000\071\000\
    \071\000\071\000\071\000\109\000\109\000\109\000\109\000\109\000\
    \109\000\109\000\109\000\109\000\109\000\110\000\110\000\110\000\
    \110\000\110\000\110\000\110\000\110\000\110\000\110\000\110\000\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\083\000\083\000\083\000\083\000\083\000\083\000\
    \083\000\083\000\255\255\255\255\255\255\255\255\255\255\255\255\
    \047\000\049\000\058\000\059\000\073\000\075\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\090\000\128\000\130\000\152\000\154\000\255\255\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\100\000\255\255\255\255\255\255\084\000\255\255\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\084\000\084\000\084\000\084\000\084\000\084\000\084\000\
    \084\000\124\000\124\000\124\000\124\000\124\000\124\000\124\000\
    \124\000\124\000\124\000\125\000\125\000\125\000\125\000\125\000\
    \125\000\125\000\125\000\125\000\125\000\125\000\133\000\133\000\
    \133\000\133\000\133\000\133\000\133\000\133\000\133\000\133\000\
    \134\000\134\000\134\000\134\000\134\000\134\000\134\000\134\000\
    \134\000\134\000\134\000\135\000\135\000\150\000\150\000\135\000\
    \087\000\150\000\255\255\255\255\255\255\255\255\091\000\255\255\
    \255\255\255\255\255\255\111\000\255\255\255\255\255\255\255\255\
    \255\255\255\255\135\000\255\255\150\000\255\255\255\255\255\255\
    \126\000\148\000\148\000\148\000\148\000\148\000\148\000\148\000\
    \148\000\148\000\148\000\149\000\149\000\149\000\149\000\149\000\
    \149\000\149\000\149\000\149\000\149\000\149\000\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
    \255\255\255\255\135\000\255\255\150\000";
  Lexing.lex_code =
   "\255\004\255\255\005\255\255\006\255\255\007\255\255\008\255\255\
    \002\007\003\008\000\005\001\006\255\009\255\255\000\004\001\009\
    \255\010\255\004\255\255\010\255\255\011\255\255\012\255\255\013\
    \255\255\002\012\003\013\000\010\001\011\255\014\255\255\015\255\
    \255\016\255\255\002\016\000\014\001\015\255\000\003\001\002\255\
    \002\255\255\003\255\002\255\255\018\255\255\015\255\014\255\255\
    \009\255\005\255\001\011\002\015\003\014\007\012\006\013\000\010\
    \255\017\255\255\009\255\001\011\002\015\003\014\007\012\006\013\
    \000\010\005\016\004\017\255\019\255\255\007\255\005\255\001\011\
    \002\015\003\014\009\018\008\019\000\010\255\007\255\001\011\002\
    \015\003\014\009\018\008\019\000\010\005\016\004\017\255";
}

let rec skip_excerpt_head lexbuf =
   __ocaml_lex_skip_excerpt_head_rec lexbuf 0
and __ocaml_lex_skip_excerpt_head_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 58 "otherlibs/ocamlc_loc/src/lexer.mll"
    ( `Continue )
# 584 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 1 ->
# 59 "otherlibs/ocamlc_loc/src/lexer.mll"
        ( `Stop )
# 589 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 2 ->
# 60 "otherlibs/ocamlc_loc/src/lexer.mll"
       ( `Stop )
# 594 "otherlibs/ocamlc_loc/src/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_skip_excerpt_head_rec lexbuf __ocaml_lex_state

and skip_excerpt_tail lexbuf =
   __ocaml_lex_skip_excerpt_tail_rec lexbuf 8
and __ocaml_lex_skip_excerpt_tail_rec lexbuf __ocaml_lex_state =
  match Lexing.engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
# 63 "otherlibs/ocamlc_loc/src/lexer.mll"
                      ( `Continue )
# 606 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 1 ->
# 65 "otherlibs/ocamlc_loc/src/lexer.mll"
    ( `Continue )
# 611 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 2 ->
# 67 "otherlibs/ocamlc_loc/src/lexer.mll"
    ( `Continue )
# 616 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 3 ->
# 68 "otherlibs/ocamlc_loc/src/lexer.mll"
        ( `Stop )
# 621 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 4 ->
# 69 "otherlibs/ocamlc_loc/src/lexer.mll"
       ( `Stop )
# 626 "otherlibs/ocamlc_loc/src/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_skip_excerpt_tail_rec lexbuf __ocaml_lex_state

and severity lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 17 (-1); __ocaml_lex_severity_rec lexbuf 24
and __ocaml_lex_severity_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 73 "otherlibs/ocamlc_loc/src/lexer.mll"
                  rest
# 639 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_start_pos + 6) lexbuf.Lexing.lex_curr_pos in
# 74 "otherlibs/ocamlc_loc/src/lexer.mll"
    ( Some (Error None, rest) )
# 643 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 1 ->
let
# 75 "otherlibs/ocamlc_loc/src/lexer.mll"
                               code
# 649 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1)
and
# 75 "otherlibs/ocamlc_loc/src/lexer.mll"
                                                            name
# 654 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(2) lexbuf.Lexing.lex_mem.(3)
and
# 76 "otherlibs/ocamlc_loc/src/lexer.mll"
                  rest
# 659 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_mem.(3) + 2) lexbuf.Lexing.lex_curr_pos in
# 77 "otherlibs/ocamlc_loc/src/lexer.mll"
    ( Some (Warning { code = int_of_string code ; name }, rest)
    )
# 664 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 2 ->
let
# 80 "otherlibs/ocamlc_loc/src/lexer.mll"
                                code
# 670 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1)
and
# 80 "otherlibs/ocamlc_loc/src/lexer.mll"
                                                             name
# 675 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(2) lexbuf.Lexing.lex_mem.(3)
and
# 81 "otherlibs/ocamlc_loc/src/lexer.mll"
                  rest
# 680 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_mem.(3) + 3) lexbuf.Lexing.lex_curr_pos in
# 82 "otherlibs/ocamlc_loc/src/lexer.mll"
    ( Some (Error (Some (Code { code = int_of_string code ; name })), rest)
    )
# 685 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 3 ->
let
# 84 "otherlibs/ocamlc_loc/src/lexer.mll"
                                  name
# 691 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1)
and
# 84 "otherlibs/ocamlc_loc/src/lexer.mll"
                                                          source
# 696 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(2) lexbuf.Lexing.lex_curr_pos in
# 85 "otherlibs/ocamlc_loc/src/lexer.mll"
    (  Some (Alert { name ; source }, "")
    )
# 701 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 4 ->
let
# 87 "otherlibs/ocamlc_loc/src/lexer.mll"
                              kind
# 707 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0)
and
# 87 "otherlibs/ocamlc_loc/src/lexer.mll"
                                                            alert
# 712 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_mem.(0) + 8) lexbuf.Lexing.lex_mem.(1)
and
# 88 "otherlibs/ocamlc_loc/src/lexer.mll"
                  rest
# 717 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_mem.(1) + 2) lexbuf.Lexing.lex_curr_pos in
# 89 "otherlibs/ocamlc_loc/src/lexer.mll"
    ( let res =
        match kind with
        | "Error" -> Error (Some (Alert alert))
        | "Warning" -> Alert { name = alert ; source = "" }
        | _ -> assert false
      in
      Some (res, rest)
    )
# 728 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 5 ->
# 97 "otherlibs/ocamlc_loc/src/lexer.mll"
       ( None )
# 733 "otherlibs/ocamlc_loc/src/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_severity_rec lexbuf __ocaml_lex_state

and line lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 4 (-1);(* L=2 [3] <- p ; [2] <- p ;  *)
  lexbuf.Lexing.lex_mem.(3) <- lexbuf.Lexing.lex_curr_pos ;
  lexbuf.Lexing.lex_mem.(2) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_line_rec lexbuf 87
and __ocaml_lex_line_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 100 "otherlibs/ocamlc_loc/src/lexer.mll"
              prefix
# 749 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0)
and
# 100 "otherlibs/ocamlc_loc/src/lexer.mll"
                                    contents
# 754 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(0) lexbuf.Lexing.lex_mem.(1) in
# 101 "otherlibs/ocamlc_loc/src/lexer.mll"
    ( Line { indent = String.length prefix ; contents }
    )
# 759 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 1 ->
# 103 "otherlibs/ocamlc_loc/src/lexer.mll"
        ( Eof )
# 764 "otherlibs/ocamlc_loc/src/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_line_rec lexbuf __ocaml_lex_state

and token lexbuf =
  lexbuf.Lexing.lex_mem <- Array.make 20 (-1);(* L=1 [10] <- p ;  *)
  lexbuf.Lexing.lex_mem.(10) <- lexbuf.Lexing.lex_curr_pos ;
 __ocaml_lex_token_rec lexbuf 92
and __ocaml_lex_token_rec lexbuf __ocaml_lex_state =
  match Lexing.new_engine __ocaml_lex_tables __ocaml_lex_state lexbuf with
      | 0 ->
let
# 106 "otherlibs/ocamlc_loc/src/lexer.mll"
              indent
# 779 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_start_pos lexbuf.Lexing.lex_mem.(0)
and
# 106 "otherlibs/ocamlc_loc/src/lexer.mll"
                                             path
# 784 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf (lexbuf.Lexing.lex_mem.(0) + 6) lexbuf.Lexing.lex_mem.(1)
and
# 107 "otherlibs/ocamlc_loc/src/lexer.mll"
                         line
# 789 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme_opt lexbuf lexbuf.Lexing.lex_mem.(7) lexbuf.Lexing.lex_mem.(6)
and
# 107 "otherlibs/ocamlc_loc/src/lexer.mll"
                                                    lines
# 794 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme_opt lexbuf lexbuf.Lexing.lex_mem.(9) lexbuf.Lexing.lex_mem.(8)
and
# 108 "otherlibs/ocamlc_loc/src/lexer.mll"
                                            chars
# 799 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme_opt lexbuf lexbuf.Lexing.lex_mem.(5) lexbuf.Lexing.lex_mem.(4)
and
# 109 "otherlibs/ocamlc_loc/src/lexer.mll"
                            message
# 804 "otherlibs/ocamlc_loc/src/lexer.ml"
= Lexing.sub_lexeme lexbuf lexbuf.Lexing.lex_mem.(2) lexbuf.Lexing.lex_mem.(3) in
# 110 "otherlibs/ocamlc_loc/src/lexer.mll"
    ( let lines =
        match line, lines with
        | Some line, None -> Single (int_of_string line)
        | None, Some range ->
          let start, finish = (parse_range range) in
          Range (start, finish)
        | None, None
        | Some _, Some _ -> assert false
      in
      let chars =
        match chars with
        | None -> None
        | Some chars ->
          let start, finish = parse_range chars in
          Some (start, finish)
      in
      let indent = String.length indent in
      let loc = { lines ; path ; chars } in
      Loc { loc ; indent ; message }
    )
# 827 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 1 ->
# 130 "otherlibs/ocamlc_loc/src/lexer.mll"
        ( Eof )
# 832 "otherlibs/ocamlc_loc/src/lexer.ml"

  | 2 ->
# 131 "otherlibs/ocamlc_loc/src/lexer.mll"
       ( line lexbuf )
# 837 "otherlibs/ocamlc_loc/src/lexer.ml"

  | __ocaml_lex_state -> lexbuf.Lexing.refill_buff lexbuf;
      __ocaml_lex_token_rec lexbuf __ocaml_lex_state

;;

