# frozen_string_literal: true

require_relative '../../lib/sass/elf'

module Sass
  module CLI
    INTERPRETER = '/lib/ld-linux-armhf.so.3'

    COMMAND = [
      *(ELF::INTERPRETER unless ELF::INTERPRETER.nil? ||
                                ELF::INTERPRETER == INTERPRETER ||
                                !ELF::INTERPRETER.end_with?(INTERPRETER)),
      File.absolute_path('/usr/bin/sass', __dir__).freeze
    ].freeze
  end

  private_constant :CLI
end
