/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.appui.about;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.net.URI;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.graalvm.visualvm.core.ui.DesktopUtils;
import org.graalvm.visualvm.lib.ui.components.ImagePanel;
import org.graalvm.visualvm.modules.appui.about.AboutDialog;
import org.graalvm.visualvm.uisupport.HTMLTextArea;
import org.graalvm.visualvm.uisupport.SeparatorLine;

public class AboutDialogPanel
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(AboutDialogPanel.class.getName());
    private HTMLTextArea licenseArea;

    AboutDialogPanel() {
        this.initComponents();
        final Runnable repainter = new Runnable(){

            @Override
            public void run() {
                AboutDialogPanel.this.repaint();
            }
        };
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && AboutDialogPanel.this.isShowing()) {
                    SwingUtilities.invokeLater(repainter);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(repainter);
                        }
                    });
                }
            }
        });
    }

    void updateAppearance() {
        String message = AboutDialog.getInstance().getMessage();
        String htmlMessage = AboutDialog.getInstance().getHTMLMessage();
        this.licenseArea.setVisible(message != null);
        if (message != null) {
            if (htmlMessage != null && DesktopUtils.isBrowseAvailable()) {
                this.licenseArea.setText(htmlMessage);
            } else {
                this.licenseArea.setText(message);
            }
        }
    }

    private void initComponents() {
        ImagePanel splashImageContainer = new ImagePanel(AboutDialog.getInstance().getAboutImage());
        SeparatorLine separator = new SeparatorLine();
        this.licenseArea = new HTMLTextArea(){

            protected void showURL(URL url) {
                if (DesktopUtils.isBrowseAvailable()) {
                    try {
                        DesktopUtils.browse((URI)url.toURI());
                    }
                    catch (Exception e) {
                        LOGGER.throwing(AboutDialogPanel.class.getName(), "initComponents", e);
                    }
                }
            }
        };
        this.licenseArea.setOpaque(true);
        this.licenseArea.setForeground(Color.BLACK);
        this.licenseArea.setBorder(BorderFactory.createEmptyBorder(10, 22, 10, 22));
        this.licenseArea.setCaret((Caret)new NullCaret());
        this.licenseArea.setShowPopup(false);
        this.licenseArea.setFocusable(false);
        splashImageContainer.setLayout(new BorderLayout());
        if (UIManager.getLookAndFeel().getID().equals("Nimbus")) {
            this.licenseArea.setBackground(new Color(0, 0, 0, 0));
            JPanel transparentPanel = new JPanel(new BorderLayout()){

                @Override
                public void paint(Graphics g) {
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    this.paintChildren(g);
                }
            };
            transparentPanel.setOpaque(true);
            transparentPanel.setBackground(new Color(255, 255, 255, 100));
            transparentPanel.add((Component)this.licenseArea, "Center");
            splashImageContainer.add((Component)transparentPanel, "South");
        } else {
            this.licenseArea.setBackground(new Color(255, 255, 255, 100));
            splashImageContainer.add((Component)this.licenseArea, "South");
        }
        this.setLayout(new BorderLayout());
        this.add((Component)splashImageContainer, "Center");
        this.add((Component)separator, "South");
    }

    private static final class NullCaret
    implements Caret {
        private NullCaret() {
        }

        @Override
        public void install(JTextComponent c) {
        }

        @Override
        public void deinstall(JTextComponent c) {
        }

        @Override
        public void paint(Graphics g) {
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }

        @Override
        public boolean isVisible() {
            return false;
        }

        @Override
        public void setVisible(boolean v) {
        }

        @Override
        public boolean isSelectionVisible() {
            return false;
        }

        @Override
        public void setSelectionVisible(boolean v) {
        }

        @Override
        public void setMagicCaretPosition(Point p) {
        }

        @Override
        public Point getMagicCaretPosition() {
            return new Point(0, 0);
        }

        @Override
        public void setBlinkRate(int rate) {
        }

        @Override
        public int getBlinkRate() {
            return 0;
        }

        @Override
        public int getDot() {
            return 0;
        }

        @Override
        public int getMark() {
            return 0;
        }

        @Override
        public void setDot(int dot) {
        }

        @Override
        public void moveDot(int dot) {
        }
    }
}

