/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.ml.common.annotation.InputDataSet;
import org.opensearch.ml.common.dataset.MLInputDataType;
import org.opensearch.ml.common.dataset.MLInputDataset;

@InputDataSet(value=MLInputDataType.TEXT_SIMILARITY)
public class TextSimilarityInputDataSet
extends MLInputDataset {
    private final List<String> textDocs;
    private final String queryText;

    public TextSimilarityInputDataSet(String queryText, List<String> textDocs) {
        super(MLInputDataType.TEXT_SIMILARITY);
        Objects.requireNonNull(textDocs);
        Objects.requireNonNull(queryText);
        if (textDocs.isEmpty()) {
            throw new IllegalArgumentException("No text documents were provided");
        }
        this.textDocs = textDocs;
        this.queryText = queryText;
    }

    public TextSimilarityInputDataSet(StreamInput in) throws IOException {
        super(MLInputDataType.TEXT_SIMILARITY);
        this.queryText = in.readString();
        int size = in.readInt();
        this.textDocs = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            String context = in.readString();
            this.textDocs.add(context);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.queryText);
        out.writeInt(this.textDocs.size());
        for (String doc : this.textDocs) {
            out.writeString(doc);
        }
    }

    @Generated
    public static TextSimilarityInputDataSetBuilder builder() {
        return new TextSimilarityInputDataSetBuilder();
    }

    @Generated
    public TextSimilarityInputDataSetBuilder toBuilder() {
        return new TextSimilarityInputDataSetBuilder().queryText(this.queryText).textDocs(this.textDocs);
    }

    @Generated
    public List<String> getTextDocs() {
        return this.textDocs;
    }

    @Generated
    public String getQueryText() {
        return this.queryText;
    }

    @Generated
    public static class TextSimilarityInputDataSetBuilder {
        @Generated
        private String queryText;
        @Generated
        private List<String> textDocs;

        @Generated
        TextSimilarityInputDataSetBuilder() {
        }

        @Generated
        public TextSimilarityInputDataSetBuilder queryText(String queryText) {
            this.queryText = queryText;
            return this;
        }

        @Generated
        public TextSimilarityInputDataSetBuilder textDocs(List<String> textDocs) {
            this.textDocs = textDocs;
            return this;
        }

        @Generated
        public TextSimilarityInputDataSet build() {
            return new TextSimilarityInputDataSet(this.queryText, this.textDocs);
        }

        @Generated
        public String toString() {
            return "TextSimilarityInputDataSet.TextSimilarityInputDataSetBuilder(queryText=" + this.queryText + ", textDocs=" + String.valueOf(this.textDocs) + ")";
        }
    }
}

