// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from nrf52833.svd, see https://github.com/NordicSemiconductor/nrfx/tree/master/mdk

//go:build nrf && nrf52833

// nRF52833 reference description for radio MCU with ARM 32-bit Cortex-M4 Microcontroller
//
//	Copyright (c) 2010 - 2020, Nordic Semiconductor ASA All rights reserved.
//
//	Redistribution and use in source and binary forms, with or without
//	modification, are permitted provided that the following conditions are met:
//
//	1. Redistributions of source code must retain the above copyright notice, this
//	list of conditions and the following disclaimer.
//
//	2. Redistributions in binary form must reproduce the above copyright
//	notice, this list of conditions and the following disclaimer in the
//	documentation and/or other materials provided with the distribution.
//
//	3. Neither the name of Nordic Semiconductor ASA nor the names of its
//	contributors may be used to endorse or promote products derived from this
//	software without specific prior written permission.
//
//	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
//	AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//	IMPLIED WARRANTIES OF MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE
//	ARE DISCLAIMED. IN NO EVENT SHALL NORDIC SEMICONDUCTOR ASA OR CONTRIBUTORS BE
//	LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
//	CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
//	SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
//	INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
//	CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
//	ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
//	POSSIBILITY OF SUCH DAMAGE.
package nrf

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "nrf52833"
	CPU          = "CM4"
	FPUPresent   = true
	NVICPrioBits = 3
)

// Interrupt numbers.
const (
	// Clock control // Power control
	IRQ_POWER_CLOCK = 0

	// Clock control
	IRQ_CLOCK = 0

	// Power control
	IRQ_POWER = 0

	// 2.4 GHz radio
	IRQ_RADIO = 1

	// Universal Asynchronous Receiver/Transmitter // UART with EasyDMA 0
	IRQ_UARTE0_UART0 = 2

	// Universal Asynchronous Receiver/Transmitter
	IRQ_UART0 = 2

	// UART with EasyDMA 0
	IRQ_UARTE0 = 2

	// Serial Peripheral Interface 0 // Serial Peripheral Interface Master with EasyDMA 0 // SPI Slave 0 // I2C compatible Two-Wire Interface 0 // I2C compatible Two-Wire Master Interface with EasyDMA 0 // I2C compatible Two-Wire Slave Interface with EasyDMA 0
	IRQ_SPIM0_SPIS0_TWIM0_TWIS0_SPI0_TWI0 = 3

	// Serial Peripheral Interface 0
	IRQ_SPI0 = 3

	// Serial Peripheral Interface Master with EasyDMA 0
	IRQ_SPIM0 = 3

	// SPI Slave 0
	IRQ_SPIS0 = 3

	// I2C compatible Two-Wire Interface 0
	IRQ_TWI0 = 3

	// I2C compatible Two-Wire Master Interface with EasyDMA 0
	IRQ_TWIM0 = 3

	// I2C compatible Two-Wire Slave Interface with EasyDMA 0
	IRQ_TWIS0 = 3

	// Serial Peripheral Interface 1 // Serial Peripheral Interface Master with EasyDMA 1 // SPI Slave 1 // I2C compatible Two-Wire Interface 1 // I2C compatible Two-Wire Master Interface with EasyDMA 1 // I2C compatible Two-Wire Slave Interface with EasyDMA 1
	IRQ_SPIM1_SPIS1_TWIM1_TWIS1_SPI1_TWI1 = 4

	// Serial Peripheral Interface 1
	IRQ_SPI1 = 4

	// Serial Peripheral Interface Master with EasyDMA 1
	IRQ_SPIM1 = 4

	// SPI Slave 1
	IRQ_SPIS1 = 4

	// I2C compatible Two-Wire Interface 1
	IRQ_TWI1 = 4

	// I2C compatible Two-Wire Master Interface with EasyDMA 1
	IRQ_TWIM1 = 4

	// I2C compatible Two-Wire Slave Interface with EasyDMA 1
	IRQ_TWIS1 = 4

	// NFC-A compatible radio
	IRQ_NFCT = 5

	// GPIO Tasks and Events
	IRQ_GPIOTE = 6

	// Successive approximation register (SAR) analog-to-digital converter
	IRQ_SAADC = 7

	// Timer/Counter 0
	IRQ_TIMER0 = 8

	// Timer/Counter 1
	IRQ_TIMER1 = 9

	// Timer/Counter 2
	IRQ_TIMER2 = 10

	// Real time counter 0
	IRQ_RTC0 = 11

	// Temperature Sensor
	IRQ_TEMP = 12

	// Random Number Generator
	IRQ_RNG = 13

	// AES ECB Mode Encryption
	IRQ_ECB = 14

	// Accelerated Address Resolver // AES CCM Mode Encryption
	IRQ_CCM_AAR = 15

	// Accelerated Address Resolver
	IRQ_AAR = 15

	// AES CCM Mode Encryption
	IRQ_CCM = 15

	// Watchdog Timer
	IRQ_WDT = 16

	// Real time counter 1
	IRQ_RTC1 = 17

	// Quadrature Decoder
	IRQ_QDEC = 18

	// Comparator // Low-power comparator
	IRQ_COMP_LPCOMP = 19

	// Comparator
	IRQ_COMP = 19

	// Low-power comparator
	IRQ_LPCOMP = 19

	// Event generator unit 0 // Software interrupt 0
	IRQ_SWI0_EGU0 = 20

	// Event generator unit 0
	IRQ_EGU0 = 20

	// Software interrupt 0
	IRQ_SWI0 = 20

	// Event generator unit 1 // Software interrupt 1
	IRQ_SWI1_EGU1 = 21

	// Event generator unit 1
	IRQ_EGU1 = 21

	// Software interrupt 1
	IRQ_SWI1 = 21

	// Event generator unit 2 // Software interrupt 2
	IRQ_SWI2_EGU2 = 22

	// Event generator unit 2
	IRQ_EGU2 = 22

	// Software interrupt 2
	IRQ_SWI2 = 22

	// Event generator unit 3 // Software interrupt 3
	IRQ_SWI3_EGU3 = 23

	// Event generator unit 3
	IRQ_EGU3 = 23

	// Software interrupt 3
	IRQ_SWI3 = 23

	// Event generator unit 4 // Software interrupt 4
	IRQ_SWI4_EGU4 = 24

	// Event generator unit 4
	IRQ_EGU4 = 24

	// Software interrupt 4
	IRQ_SWI4 = 24

	// Event generator unit 5 // Software interrupt 5
	IRQ_SWI5_EGU5 = 25

	// Event generator unit 5
	IRQ_EGU5 = 25

	// Software interrupt 5
	IRQ_SWI5 = 25

	// Timer/Counter 3
	IRQ_TIMER3 = 26

	// Timer/Counter 4
	IRQ_TIMER4 = 27

	// Pulse width modulation unit 0
	IRQ_PWM0 = 28

	// Pulse Density Modulation (Digital Microphone) Interface
	IRQ_PDM = 29

	// Memory Watch Unit
	IRQ_MWU = 32

	// Pulse width modulation unit 1
	IRQ_PWM1 = 33

	// Pulse width modulation unit 2
	IRQ_PWM2 = 34

	// Serial Peripheral Interface 2 // Serial Peripheral Interface Master with EasyDMA 2 // SPI Slave 2
	IRQ_SPIM2_SPIS2_SPI2 = 35

	// Serial Peripheral Interface 2
	IRQ_SPI2 = 35

	// Serial Peripheral Interface Master with EasyDMA 2
	IRQ_SPIM2 = 35

	// SPI Slave 2
	IRQ_SPIS2 = 35

	// Real time counter 2
	IRQ_RTC2 = 36

	// Inter-IC Sound
	IRQ_I2S = 37

	// FPU
	IRQ_FPU = 38

	// Universal serial bus device
	IRQ_USBD = 39

	// UART with EasyDMA 1
	IRQ_UARTE1 = 40

	// Pulse width modulation unit 3
	IRQ_PWM3 = 45

	// Serial Peripheral Interface Master with EasyDMA 3
	IRQ_SPIM3 = 47

	// Highest interrupt number on this device.
	IRQ_max = 47
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export POWER_CLOCK_IRQHandler
func interruptPOWER_CLOCK() {
	callHandlers(IRQ_POWER_CLOCK)
}

//export RADIO_IRQHandler
func interruptRADIO() {
	callHandlers(IRQ_RADIO)
}

//export UARTE0_UART0_IRQHandler
func interruptUARTE0_UART0() {
	callHandlers(IRQ_UARTE0_UART0)
}

//export SPIM0_SPIS0_TWIM0_TWIS0_SPI0_TWI0_IRQHandler
func interruptSPIM0_SPIS0_TWIM0_TWIS0_SPI0_TWI0() {
	callHandlers(IRQ_SPIM0_SPIS0_TWIM0_TWIS0_SPI0_TWI0)
}

//export SPIM1_SPIS1_TWIM1_TWIS1_SPI1_TWI1_IRQHandler
func interruptSPIM1_SPIS1_TWIM1_TWIS1_SPI1_TWI1() {
	callHandlers(IRQ_SPIM1_SPIS1_TWIM1_TWIS1_SPI1_TWI1)
}

//export NFCT_IRQHandler
func interruptNFCT() {
	callHandlers(IRQ_NFCT)
}

//export GPIOTE_IRQHandler
func interruptGPIOTE() {
	callHandlers(IRQ_GPIOTE)
}

//export SAADC_IRQHandler
func interruptSAADC() {
	callHandlers(IRQ_SAADC)
}

//export TIMER0_IRQHandler
func interruptTIMER0() {
	callHandlers(IRQ_TIMER0)
}

//export TIMER1_IRQHandler
func interruptTIMER1() {
	callHandlers(IRQ_TIMER1)
}

//export TIMER2_IRQHandler
func interruptTIMER2() {
	callHandlers(IRQ_TIMER2)
}

//export RTC0_IRQHandler
func interruptRTC0() {
	callHandlers(IRQ_RTC0)
}

//export TEMP_IRQHandler
func interruptTEMP() {
	callHandlers(IRQ_TEMP)
}

//export RNG_IRQHandler
func interruptRNG() {
	callHandlers(IRQ_RNG)
}

//export ECB_IRQHandler
func interruptECB() {
	callHandlers(IRQ_ECB)
}

//export CCM_AAR_IRQHandler
func interruptCCM_AAR() {
	callHandlers(IRQ_CCM_AAR)
}

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export RTC1_IRQHandler
func interruptRTC1() {
	callHandlers(IRQ_RTC1)
}

//export QDEC_IRQHandler
func interruptQDEC() {
	callHandlers(IRQ_QDEC)
}

//export COMP_LPCOMP_IRQHandler
func interruptCOMP_LPCOMP() {
	callHandlers(IRQ_COMP_LPCOMP)
}

//export SWI0_EGU0_IRQHandler
func interruptSWI0_EGU0() {
	callHandlers(IRQ_SWI0_EGU0)
}

//export SWI1_EGU1_IRQHandler
func interruptSWI1_EGU1() {
	callHandlers(IRQ_SWI1_EGU1)
}

//export SWI2_EGU2_IRQHandler
func interruptSWI2_EGU2() {
	callHandlers(IRQ_SWI2_EGU2)
}

//export SWI3_EGU3_IRQHandler
func interruptSWI3_EGU3() {
	callHandlers(IRQ_SWI3_EGU3)
}

//export SWI4_EGU4_IRQHandler
func interruptSWI4_EGU4() {
	callHandlers(IRQ_SWI4_EGU4)
}

//export SWI5_EGU5_IRQHandler
func interruptSWI5_EGU5() {
	callHandlers(IRQ_SWI5_EGU5)
}

//export TIMER3_IRQHandler
func interruptTIMER3() {
	callHandlers(IRQ_TIMER3)
}

//export TIMER4_IRQHandler
func interruptTIMER4() {
	callHandlers(IRQ_TIMER4)
}

//export PWM0_IRQHandler
func interruptPWM0() {
	callHandlers(IRQ_PWM0)
}

//export PDM_IRQHandler
func interruptPDM() {
	callHandlers(IRQ_PDM)
}

//export MWU_IRQHandler
func interruptMWU() {
	callHandlers(IRQ_MWU)
}

//export PWM1_IRQHandler
func interruptPWM1() {
	callHandlers(IRQ_PWM1)
}

//export PWM2_IRQHandler
func interruptPWM2() {
	callHandlers(IRQ_PWM2)
}

//export SPIM2_SPIS2_SPI2_IRQHandler
func interruptSPIM2_SPIS2_SPI2() {
	callHandlers(IRQ_SPIM2_SPIS2_SPI2)
}

//export RTC2_IRQHandler
func interruptRTC2() {
	callHandlers(IRQ_RTC2)
}

//export I2S_IRQHandler
func interruptI2S() {
	callHandlers(IRQ_I2S)
}

//export FPU_IRQHandler
func interruptFPU() {
	callHandlers(IRQ_FPU)
}

//export USBD_IRQHandler
func interruptUSBD() {
	callHandlers(IRQ_USBD)
}

//export UARTE1_IRQHandler
func interruptUARTE1() {
	callHandlers(IRQ_UARTE1)
}

//export PWM3_IRQHandler
func interruptPWM3() {
	callHandlers(IRQ_PWM3)
}

//export SPIM3_IRQHandler
func interruptSPIM3() {
	callHandlers(IRQ_SPIM3)
}

// Peripherals.
var (
	// Factory information configuration registers
	FICR = (*FICR_Type)(unsafe.Pointer(uintptr(0x10000000)))

	// User information configuration registers
	UICR = (*UICR_Type)(unsafe.Pointer(uintptr(0x10001000)))

	// Clock control
	CLOCK = (*CLOCK_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Power control
	POWER = (*POWER_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// GPIO Port 1
	P0 = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000000)))

	// 2.4 GHz radio
	RADIO = (*RADIO_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// Universal Asynchronous Receiver/Transmitter
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// UART with EasyDMA 0
	UARTE0 = (*UARTE_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// Serial Peripheral Interface 0
	SPI0 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Serial Peripheral Interface Master with EasyDMA 0
	SPIM0 = (*SPIM_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// SPI Slave 0
	SPIS0 = (*SPIS_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// I2C compatible Two-Wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 0
	TWIM0 = (*TWIM_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 0
	TWIS0 = (*TWIS_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// NFC-A compatible radio
	NFCT = (*NFCT_Type)(unsafe.Pointer(uintptr(0x40005000)))

	// GPIO Tasks and Events
	GPIOTE = (*GPIOTE_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Successive approximation register (SAR) analog-to-digital converter
	SAADC = (*SAADC_Type)(unsafe.Pointer(uintptr(0x40007000)))

	// Timer/Counter 0
	TIMER0 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Real time counter 0
	RTC0 = (*RTC_Type)(unsafe.Pointer(uintptr(0x4000b000)))

	// Temperature Sensor
	TEMP = (*TEMP_Type)(unsafe.Pointer(uintptr(0x4000c000)))

	// Random Number Generator
	RNG = (*RNG_Type)(unsafe.Pointer(uintptr(0x4000d000)))

	// AES ECB Mode Encryption
	ECB = (*ECB_Type)(unsafe.Pointer(uintptr(0x4000e000)))

	// Accelerated Address Resolver
	AAR = (*AAR_Type)(unsafe.Pointer(uintptr(0x4000f000)))

	// AES CCM Mode Encryption
	CCM = (*CCM_Type)(unsafe.Pointer(uintptr(0x4000f000)))

	// Watchdog Timer
	WDT = (*WDT_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Quadrature Decoder
	QDEC = (*QDEC_Type)(unsafe.Pointer(uintptr(0x40012000)))

	// Comparator
	COMP = (*COMP_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Low-power comparator
	LPCOMP = (*LPCOMP_Type)(unsafe.Pointer(uintptr(0x40013000)))

	// Event generator unit 0
	EGU0 = (*EGU_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Software interrupt 0
	SWI0 = (*SWI_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Pulse width modulation unit 0
	PWM0 = (*PWM_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Pulse Density Modulation (Digital Microphone) Interface
	PDM = (*PDM_Type)(unsafe.Pointer(uintptr(0x4001d000)))

	// Access control lists
	ACL = (*ACL_Type)(unsafe.Pointer(uintptr(0x4001e000)))

	// Non Volatile Memory Controller
	NVMC = (*NVMC_Type)(unsafe.Pointer(uintptr(0x4001e000)))

	// Programmable Peripheral Interconnect
	PPI = (*PPI_Type)(unsafe.Pointer(uintptr(0x4001f000)))

	// Memory Watch Unit
	MWU = (*MWU_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Inter-IC Sound
	I2S = (*I2S_Type)(unsafe.Pointer(uintptr(0x40025000)))

	// FPU
	FPU = (*FPU_Type)(unsafe.Pointer(uintptr(0x40026000)))

	// Universal serial bus device
	USBD = (*USBD_Type)(unsafe.Pointer(uintptr(0x40027000)))

	// GPIO Port 2
	P1 = (*GPIO_Type)(unsafe.Pointer(uintptr(0x50000300)))

	// Serial Peripheral Interface 1
	SPI1 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Serial Peripheral Interface Master with EasyDMA 1
	SPIM1 = (*SPIM_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// SPI Slave 1
	SPIS1 = (*SPIS_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// I2C compatible Two-Wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// I2C compatible Two-Wire Master Interface with EasyDMA 1
	TWIM1 = (*TWIM_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// I2C compatible Two-Wire Slave Interface with EasyDMA 1
	TWIS1 = (*TWIS_Type)(unsafe.Pointer(uintptr(0x40004000)))

	// Timer/Counter 1
	TIMER1 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x40009000)))

	// Timer/Counter 2
	TIMER2 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x4000a000)))

	// Real time counter 1
	RTC1 = (*RTC_Type)(unsafe.Pointer(uintptr(0x40011000)))

	// Event generator unit 1
	EGU1 = (*EGU_Type)(unsafe.Pointer(uintptr(0x40015000)))

	// Software interrupt 1
	SWI1 = (*SWI_Type)(unsafe.Pointer(uintptr(0x40015000)))

	// Event generator unit 2
	EGU2 = (*EGU_Type)(unsafe.Pointer(uintptr(0x40016000)))

	// Software interrupt 2
	SWI2 = (*SWI_Type)(unsafe.Pointer(uintptr(0x40016000)))

	// Event generator unit 3
	EGU3 = (*EGU_Type)(unsafe.Pointer(uintptr(0x40017000)))

	// Software interrupt 3
	SWI3 = (*SWI_Type)(unsafe.Pointer(uintptr(0x40017000)))

	// Event generator unit 4
	EGU4 = (*EGU_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// Software interrupt 4
	SWI4 = (*SWI_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// Event generator unit 5
	EGU5 = (*EGU_Type)(unsafe.Pointer(uintptr(0x40019000)))

	// Software interrupt 5
	SWI5 = (*SWI_Type)(unsafe.Pointer(uintptr(0x40019000)))

	// Timer/Counter 3
	TIMER3 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x4001a000)))

	// Timer/Counter 4
	TIMER4 = (*TIMER_Type)(unsafe.Pointer(uintptr(0x4001b000)))

	// Pulse width modulation unit 1
	PWM1 = (*PWM_Type)(unsafe.Pointer(uintptr(0x40021000)))

	// Pulse width modulation unit 2
	PWM2 = (*PWM_Type)(unsafe.Pointer(uintptr(0x40022000)))

	// Serial Peripheral Interface 2
	SPI2 = (*SPI_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Serial Peripheral Interface Master with EasyDMA 2
	SPIM2 = (*SPIM_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// SPI Slave 2
	SPIS2 = (*SPIS_Type)(unsafe.Pointer(uintptr(0x40023000)))

	// Real time counter 2
	RTC2 = (*RTC_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// UART with EasyDMA 1
	UARTE1 = (*UARTE_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Pulse width modulation unit 3
	PWM3 = (*PWM_Type)(unsafe.Pointer(uintptr(0x4002d000)))

	// Serial Peripheral Interface Master with EasyDMA 3
	SPIM3 = (*SPIM_Type)(unsafe.Pointer(uintptr(0x4002f000)))
)

// Factory information configuration registers
type FICR_Type struct {
	_              [16]byte
	CODEPAGESIZE   volatile.Register32 // 0x10
	CODESIZE       volatile.Register32 // 0x14
	_              [72]byte
	DEVICEID       [2]volatile.Register32 // 0x60
	_              [24]byte
	ER             [4]volatile.Register32 // 0x80
	IR             [4]volatile.Register32 // 0x90
	DEVICEADDRTYPE volatile.Register32    // 0xA0
	DEVICEADDR     [2]volatile.Register32 // 0xA4
	_              [84]byte
	INFO           FICR_INFO_Type // 0x100
	_              [572]byte
	PRODTEST       [3]volatile.Register32 // 0x350
	_              [168]byte
	TEMP           FICR_TEMP_Type // 0x404
	_              [8]byte
	NFC            FICR_NFC_Type // 0x450
}

// FICR.CODEPAGESIZE: Code memory page size
func (o *FICR_Type) SetCODEPAGESIZE(value uint32) {
	volatile.StoreUint32(&o.CODEPAGESIZE.Reg, value)
}
func (o *FICR_Type) GetCODEPAGESIZE() uint32 {
	return volatile.LoadUint32(&o.CODEPAGESIZE.Reg)
}

// FICR.CODESIZE: Code memory size
func (o *FICR_Type) SetCODESIZE(value uint32) {
	volatile.StoreUint32(&o.CODESIZE.Reg, value)
}
func (o *FICR_Type) GetCODESIZE() uint32 {
	return volatile.LoadUint32(&o.CODESIZE.Reg)
}

// FICR.DEVICEID: Description collection: Device identifier
func (o *FICR_Type) SetDEVICEID(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVICEID[idx].Reg, value)
}
func (o *FICR_Type) GetDEVICEID(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVICEID[idx].Reg)
}

// FICR.ER: Description collection: Encryption root, word n
func (o *FICR_Type) SetER(idx int, value uint32) {
	volatile.StoreUint32(&o.ER[idx].Reg, value)
}
func (o *FICR_Type) GetER(idx int) uint32 {
	return volatile.LoadUint32(&o.ER[idx].Reg)
}

// FICR.IR: Description collection: Identity Root, word n
func (o *FICR_Type) SetIR(idx int, value uint32) {
	volatile.StoreUint32(&o.IR[idx].Reg, value)
}
func (o *FICR_Type) GetIR(idx int) uint32 {
	return volatile.LoadUint32(&o.IR[idx].Reg)
}

// FICR.DEVICEADDRTYPE: Device address type
func (o *FICR_Type) SetDEVICEADDRTYPE(value uint32) {
	volatile.StoreUint32(&o.DEVICEADDRTYPE.Reg, volatile.LoadUint32(&o.DEVICEADDRTYPE.Reg)&^(0x1)|value)
}
func (o *FICR_Type) GetDEVICEADDRTYPE() uint32 {
	return volatile.LoadUint32(&o.DEVICEADDRTYPE.Reg) & 0x1
}

// FICR.DEVICEADDR: Description collection: Device address n
func (o *FICR_Type) SetDEVICEADDR(idx int, value uint32) {
	volatile.StoreUint32(&o.DEVICEADDR[idx].Reg, value)
}
func (o *FICR_Type) GetDEVICEADDR(idx int) uint32 {
	return volatile.LoadUint32(&o.DEVICEADDR[idx].Reg)
}

// FICR.PRODTEST: Description collection: Production test signature n
func (o *FICR_Type) SetPRODTEST(idx int, value uint32) {
	volatile.StoreUint32(&o.PRODTEST[idx].Reg, value)
}
func (o *FICR_Type) GetPRODTEST(idx int) uint32 {
	return volatile.LoadUint32(&o.PRODTEST[idx].Reg)
}

// Device info
type FICR_INFO_Type struct {
	PART    volatile.Register32 // 0x100
	VARIANT volatile.Register32 // 0x104
	PACKAGE volatile.Register32 // 0x108
	RAM     volatile.Register32 // 0x10C
	FLASH   volatile.Register32 // 0x110
}

// FICR_INFO.PART: Part code
func (o *FICR_INFO_Type) SetPART(value uint32) {
	volatile.StoreUint32(&o.PART.Reg, value)
}
func (o *FICR_INFO_Type) GetPART() uint32 {
	return volatile.LoadUint32(&o.PART.Reg)
}

// FICR_INFO.VARIANT: Build code (hardware version and production configuration)
func (o *FICR_INFO_Type) SetVARIANT(value uint32) {
	volatile.StoreUint32(&o.VARIANT.Reg, value)
}
func (o *FICR_INFO_Type) GetVARIANT() uint32 {
	return volatile.LoadUint32(&o.VARIANT.Reg)
}

// FICR_INFO.PACKAGE: Package option
func (o *FICR_INFO_Type) SetPACKAGE(value uint32) {
	volatile.StoreUint32(&o.PACKAGE.Reg, value)
}
func (o *FICR_INFO_Type) GetPACKAGE() uint32 {
	return volatile.LoadUint32(&o.PACKAGE.Reg)
}

// FICR_INFO.RAM: RAM variant
func (o *FICR_INFO_Type) SetRAM(value uint32) {
	volatile.StoreUint32(&o.RAM.Reg, value)
}
func (o *FICR_INFO_Type) GetRAM() uint32 {
	return volatile.LoadUint32(&o.RAM.Reg)
}

// FICR_INFO.FLASH: Flash variant
func (o *FICR_INFO_Type) SetFLASH(value uint32) {
	volatile.StoreUint32(&o.FLASH.Reg, value)
}
func (o *FICR_INFO_Type) GetFLASH() uint32 {
	return volatile.LoadUint32(&o.FLASH.Reg)
}

// Registers storing factory TEMP module linearization coefficients
type FICR_TEMP_Type struct {
	A0 volatile.Register32 // 0x404
	A1 volatile.Register32 // 0x408
	A2 volatile.Register32 // 0x40C
	A3 volatile.Register32 // 0x410
	A4 volatile.Register32 // 0x414
	A5 volatile.Register32 // 0x418
	B0 volatile.Register32 // 0x41C
	B1 volatile.Register32 // 0x420
	B2 volatile.Register32 // 0x424
	B3 volatile.Register32 // 0x428
	B4 volatile.Register32 // 0x42C
	B5 volatile.Register32 // 0x430
	T0 volatile.Register32 // 0x434
	T1 volatile.Register32 // 0x438
	T2 volatile.Register32 // 0x43C
	T3 volatile.Register32 // 0x440
	T4 volatile.Register32 // 0x444
}

// FICR_TEMP.A0: Slope definition A0
func (o *FICR_TEMP_Type) SetA0_A(value uint32) {
	volatile.StoreUint32(&o.A0.Reg, volatile.LoadUint32(&o.A0.Reg)&^(0xfff)|value)
}
func (o *FICR_TEMP_Type) GetA0_A() uint32 {
	return volatile.LoadUint32(&o.A0.Reg) & 0xfff
}

// FICR_TEMP.A1: Slope definition A1
func (o *FICR_TEMP_Type) SetA1_A(value uint32) {
	volatile.StoreUint32(&o.A1.Reg, volatile.LoadUint32(&o.A1.Reg)&^(0xfff)|value)
}
func (o *FICR_TEMP_Type) GetA1_A() uint32 {
	return volatile.LoadUint32(&o.A1.Reg) & 0xfff
}

// FICR_TEMP.A2: Slope definition A2
func (o *FICR_TEMP_Type) SetA2_A(value uint32) {
	volatile.StoreUint32(&o.A2.Reg, volatile.LoadUint32(&o.A2.Reg)&^(0xfff)|value)
}
func (o *FICR_TEMP_Type) GetA2_A() uint32 {
	return volatile.LoadUint32(&o.A2.Reg) & 0xfff
}

// FICR_TEMP.A3: Slope definition A3
func (o *FICR_TEMP_Type) SetA3_A(value uint32) {
	volatile.StoreUint32(&o.A3.Reg, volatile.LoadUint32(&o.A3.Reg)&^(0xfff)|value)
}
func (o *FICR_TEMP_Type) GetA3_A() uint32 {
	return volatile.LoadUint32(&o.A3.Reg) & 0xfff
}

// FICR_TEMP.A4: Slope definition A4
func (o *FICR_TEMP_Type) SetA4_A(value uint32) {
	volatile.StoreUint32(&o.A4.Reg, volatile.LoadUint32(&o.A4.Reg)&^(0xfff)|value)
}
func (o *FICR_TEMP_Type) GetA4_A() uint32 {
	return volatile.LoadUint32(&o.A4.Reg) & 0xfff
}

// FICR_TEMP.A5: Slope definition A5
func (o *FICR_TEMP_Type) SetA5_A(value uint32) {
	volatile.StoreUint32(&o.A5.Reg, volatile.LoadUint32(&o.A5.Reg)&^(0xfff)|value)
}
func (o *FICR_TEMP_Type) GetA5_A() uint32 {
	return volatile.LoadUint32(&o.A5.Reg) & 0xfff
}

// FICR_TEMP.B0: Y-intercept B0
func (o *FICR_TEMP_Type) SetB0_B(value uint32) {
	volatile.StoreUint32(&o.B0.Reg, volatile.LoadUint32(&o.B0.Reg)&^(0x3fff)|value)
}
func (o *FICR_TEMP_Type) GetB0_B() uint32 {
	return volatile.LoadUint32(&o.B0.Reg) & 0x3fff
}

// FICR_TEMP.B1: Y-intercept B1
func (o *FICR_TEMP_Type) SetB1_B(value uint32) {
	volatile.StoreUint32(&o.B1.Reg, volatile.LoadUint32(&o.B1.Reg)&^(0x3fff)|value)
}
func (o *FICR_TEMP_Type) GetB1_B() uint32 {
	return volatile.LoadUint32(&o.B1.Reg) & 0x3fff
}

// FICR_TEMP.B2: Y-intercept B2
func (o *FICR_TEMP_Type) SetB2_B(value uint32) {
	volatile.StoreUint32(&o.B2.Reg, volatile.LoadUint32(&o.B2.Reg)&^(0x3fff)|value)
}
func (o *FICR_TEMP_Type) GetB2_B() uint32 {
	return volatile.LoadUint32(&o.B2.Reg) & 0x3fff
}

// FICR_TEMP.B3: Y-intercept B3
func (o *FICR_TEMP_Type) SetB3_B(value uint32) {
	volatile.StoreUint32(&o.B3.Reg, volatile.LoadUint32(&o.B3.Reg)&^(0x3fff)|value)
}
func (o *FICR_TEMP_Type) GetB3_B() uint32 {
	return volatile.LoadUint32(&o.B3.Reg) & 0x3fff
}

// FICR_TEMP.B4: Y-intercept B4
func (o *FICR_TEMP_Type) SetB4_B(value uint32) {
	volatile.StoreUint32(&o.B4.Reg, volatile.LoadUint32(&o.B4.Reg)&^(0x3fff)|value)
}
func (o *FICR_TEMP_Type) GetB4_B() uint32 {
	return volatile.LoadUint32(&o.B4.Reg) & 0x3fff
}

// FICR_TEMP.B5: Y-intercept B5
func (o *FICR_TEMP_Type) SetB5_B(value uint32) {
	volatile.StoreUint32(&o.B5.Reg, volatile.LoadUint32(&o.B5.Reg)&^(0x3fff)|value)
}
func (o *FICR_TEMP_Type) GetB5_B() uint32 {
	return volatile.LoadUint32(&o.B5.Reg) & 0x3fff
}

// FICR_TEMP.T0: Segment end T0
func (o *FICR_TEMP_Type) SetT0_T(value uint32) {
	volatile.StoreUint32(&o.T0.Reg, volatile.LoadUint32(&o.T0.Reg)&^(0xff)|value)
}
func (o *FICR_TEMP_Type) GetT0_T() uint32 {
	return volatile.LoadUint32(&o.T0.Reg) & 0xff
}

// FICR_TEMP.T1: Segment end T1
func (o *FICR_TEMP_Type) SetT1_T(value uint32) {
	volatile.StoreUint32(&o.T1.Reg, volatile.LoadUint32(&o.T1.Reg)&^(0xff)|value)
}
func (o *FICR_TEMP_Type) GetT1_T() uint32 {
	return volatile.LoadUint32(&o.T1.Reg) & 0xff
}

// FICR_TEMP.T2: Segment end T2
func (o *FICR_TEMP_Type) SetT2_T(value uint32) {
	volatile.StoreUint32(&o.T2.Reg, volatile.LoadUint32(&o.T2.Reg)&^(0xff)|value)
}
func (o *FICR_TEMP_Type) GetT2_T() uint32 {
	return volatile.LoadUint32(&o.T2.Reg) & 0xff
}

// FICR_TEMP.T3: Segment end T3
func (o *FICR_TEMP_Type) SetT3_T(value uint32) {
	volatile.StoreUint32(&o.T3.Reg, volatile.LoadUint32(&o.T3.Reg)&^(0xff)|value)
}
func (o *FICR_TEMP_Type) GetT3_T() uint32 {
	return volatile.LoadUint32(&o.T3.Reg) & 0xff
}

// FICR_TEMP.T4: Segment end T4
func (o *FICR_TEMP_Type) SetT4_T(value uint32) {
	volatile.StoreUint32(&o.T4.Reg, volatile.LoadUint32(&o.T4.Reg)&^(0xff)|value)
}
func (o *FICR_TEMP_Type) GetT4_T() uint32 {
	return volatile.LoadUint32(&o.T4.Reg) & 0xff
}

// Unspecified
type FICR_NFC_Type struct {
	TAGHEADER0 volatile.Register32 // 0x450
	TAGHEADER1 volatile.Register32 // 0x454
	TAGHEADER2 volatile.Register32 // 0x458
	TAGHEADER3 volatile.Register32 // 0x45C
}

// FICR_NFC.TAGHEADER0: Default header for NFC tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST, and NFCID1_LAST.
func (o *FICR_NFC_Type) SetTAGHEADER0_MFGID(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER0.Reg, volatile.LoadUint32(&o.TAGHEADER0.Reg)&^(0xff)|value)
}
func (o *FICR_NFC_Type) GetTAGHEADER0_MFGID() uint32 {
	return volatile.LoadUint32(&o.TAGHEADER0.Reg) & 0xff
}
func (o *FICR_NFC_Type) SetTAGHEADER0_UD1(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER0.Reg, volatile.LoadUint32(&o.TAGHEADER0.Reg)&^(0xff00)|value<<8)
}
func (o *FICR_NFC_Type) GetTAGHEADER0_UD1() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER0.Reg) & 0xff00) >> 8
}
func (o *FICR_NFC_Type) SetTAGHEADER0_UD2(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER0.Reg, volatile.LoadUint32(&o.TAGHEADER0.Reg)&^(0xff0000)|value<<16)
}
func (o *FICR_NFC_Type) GetTAGHEADER0_UD2() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER0.Reg) & 0xff0000) >> 16
}
func (o *FICR_NFC_Type) SetTAGHEADER0_UD3(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER0.Reg, volatile.LoadUint32(&o.TAGHEADER0.Reg)&^(0xff000000)|value<<24)
}
func (o *FICR_NFC_Type) GetTAGHEADER0_UD3() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER0.Reg) & 0xff000000) >> 24
}

// FICR_NFC.TAGHEADER1: Default header for NFC tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST, and NFCID1_LAST.
func (o *FICR_NFC_Type) SetTAGHEADER1_UD4(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER1.Reg, volatile.LoadUint32(&o.TAGHEADER1.Reg)&^(0xff)|value)
}
func (o *FICR_NFC_Type) GetTAGHEADER1_UD4() uint32 {
	return volatile.LoadUint32(&o.TAGHEADER1.Reg) & 0xff
}
func (o *FICR_NFC_Type) SetTAGHEADER1_UD5(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER1.Reg, volatile.LoadUint32(&o.TAGHEADER1.Reg)&^(0xff00)|value<<8)
}
func (o *FICR_NFC_Type) GetTAGHEADER1_UD5() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER1.Reg) & 0xff00) >> 8
}
func (o *FICR_NFC_Type) SetTAGHEADER1_UD6(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER1.Reg, volatile.LoadUint32(&o.TAGHEADER1.Reg)&^(0xff0000)|value<<16)
}
func (o *FICR_NFC_Type) GetTAGHEADER1_UD6() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER1.Reg) & 0xff0000) >> 16
}
func (o *FICR_NFC_Type) SetTAGHEADER1_UD7(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER1.Reg, volatile.LoadUint32(&o.TAGHEADER1.Reg)&^(0xff000000)|value<<24)
}
func (o *FICR_NFC_Type) GetTAGHEADER1_UD7() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER1.Reg) & 0xff000000) >> 24
}

// FICR_NFC.TAGHEADER2: Default header for NFC tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST, and NFCID1_LAST.
func (o *FICR_NFC_Type) SetTAGHEADER2_UD8(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER2.Reg, volatile.LoadUint32(&o.TAGHEADER2.Reg)&^(0xff)|value)
}
func (o *FICR_NFC_Type) GetTAGHEADER2_UD8() uint32 {
	return volatile.LoadUint32(&o.TAGHEADER2.Reg) & 0xff
}
func (o *FICR_NFC_Type) SetTAGHEADER2_UD9(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER2.Reg, volatile.LoadUint32(&o.TAGHEADER2.Reg)&^(0xff00)|value<<8)
}
func (o *FICR_NFC_Type) GetTAGHEADER2_UD9() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER2.Reg) & 0xff00) >> 8
}
func (o *FICR_NFC_Type) SetTAGHEADER2_UD10(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER2.Reg, volatile.LoadUint32(&o.TAGHEADER2.Reg)&^(0xff0000)|value<<16)
}
func (o *FICR_NFC_Type) GetTAGHEADER2_UD10() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER2.Reg) & 0xff0000) >> 16
}
func (o *FICR_NFC_Type) SetTAGHEADER2_UD11(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER2.Reg, volatile.LoadUint32(&o.TAGHEADER2.Reg)&^(0xff000000)|value<<24)
}
func (o *FICR_NFC_Type) GetTAGHEADER2_UD11() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER2.Reg) & 0xff000000) >> 24
}

// FICR_NFC.TAGHEADER3: Default header for NFC tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST, and NFCID1_LAST.
func (o *FICR_NFC_Type) SetTAGHEADER3_UD12(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER3.Reg, volatile.LoadUint32(&o.TAGHEADER3.Reg)&^(0xff)|value)
}
func (o *FICR_NFC_Type) GetTAGHEADER3_UD12() uint32 {
	return volatile.LoadUint32(&o.TAGHEADER3.Reg) & 0xff
}
func (o *FICR_NFC_Type) SetTAGHEADER3_UD13(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER3.Reg, volatile.LoadUint32(&o.TAGHEADER3.Reg)&^(0xff00)|value<<8)
}
func (o *FICR_NFC_Type) GetTAGHEADER3_UD13() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER3.Reg) & 0xff00) >> 8
}
func (o *FICR_NFC_Type) SetTAGHEADER3_UD14(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER3.Reg, volatile.LoadUint32(&o.TAGHEADER3.Reg)&^(0xff0000)|value<<16)
}
func (o *FICR_NFC_Type) GetTAGHEADER3_UD14() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER3.Reg) & 0xff0000) >> 16
}
func (o *FICR_NFC_Type) SetTAGHEADER3_UD15(value uint32) {
	volatile.StoreUint32(&o.TAGHEADER3.Reg, volatile.LoadUint32(&o.TAGHEADER3.Reg)&^(0xff000000)|value<<24)
}
func (o *FICR_NFC_Type) GetTAGHEADER3_UD15() uint32 {
	return (volatile.LoadUint32(&o.TAGHEADER3.Reg) & 0xff000000) >> 24
}

// User information configuration registers
type UICR_Type struct {
	_         [20]byte
	NRFFW     [13]volatile.Register32 // 0x14
	_         [8]byte
	NRFHW     [12]volatile.Register32 // 0x50
	CUSTOMER  [32]volatile.Register32 // 0x80
	_         [256]byte
	PSELRESET [2]volatile.Register32 // 0x200
	APPROTECT volatile.Register32    // 0x208
	NFCPINS   volatile.Register32    // 0x20C
	DEBUGCTRL volatile.Register32    // 0x210
	_         [240]byte
	REGOUT0   volatile.Register32 // 0x304
}

// UICR.NRFFW: Description collection: Reserved for Nordic firmware design
func (o *UICR_Type) SetNRFFW(idx int, value uint32) {
	volatile.StoreUint32(&o.NRFFW[idx].Reg, value)
}
func (o *UICR_Type) GetNRFFW(idx int) uint32 {
	return volatile.LoadUint32(&o.NRFFW[idx].Reg)
}

// UICR.NRFHW: Description collection: Reserved for Nordic hardware design
func (o *UICR_Type) SetNRFHW(idx int, value uint32) {
	volatile.StoreUint32(&o.NRFHW[idx].Reg, value)
}
func (o *UICR_Type) GetNRFHW(idx int) uint32 {
	return volatile.LoadUint32(&o.NRFHW[idx].Reg)
}

// UICR.CUSTOMER: Description collection: Reserved for customer
func (o *UICR_Type) SetCUSTOMER(idx int, value uint32) {
	volatile.StoreUint32(&o.CUSTOMER[idx].Reg, value)
}
func (o *UICR_Type) GetCUSTOMER(idx int) uint32 {
	return volatile.LoadUint32(&o.CUSTOMER[idx].Reg)
}

// UICR.PSELRESET: Description collection: Mapping of the nRESET function (see POWER chapter for details)
func (o *UICR_Type) SetPSELRESET_PIN(idx int, value uint32) {
	volatile.StoreUint32(&o.PSELRESET[idx].Reg, volatile.LoadUint32(&o.PSELRESET[idx].Reg)&^(0x1f)|value)
}
func (o *UICR_Type) GetPSELRESET_PIN(idx int) uint32 {
	return volatile.LoadUint32(&o.PSELRESET[idx].Reg) & 0x1f
}
func (o *UICR_Type) SetPSELRESET_PORT(idx int, value uint32) {
	volatile.StoreUint32(&o.PSELRESET[idx].Reg, volatile.LoadUint32(&o.PSELRESET[idx].Reg)&^(0x20)|value<<5)
}
func (o *UICR_Type) GetPSELRESET_PORT(idx int) uint32 {
	return (volatile.LoadUint32(&o.PSELRESET[idx].Reg) & 0x20) >> 5
}
func (o *UICR_Type) SetPSELRESET_CONNECT(idx int, value uint32) {
	volatile.StoreUint32(&o.PSELRESET[idx].Reg, volatile.LoadUint32(&o.PSELRESET[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *UICR_Type) GetPSELRESET_CONNECT(idx int) uint32 {
	return (volatile.LoadUint32(&o.PSELRESET[idx].Reg) & 0x80000000) >> 31
}

// UICR.APPROTECT: Access port protection
func (o *UICR_Type) SetAPPROTECT_PALL(value uint32) {
	volatile.StoreUint32(&o.APPROTECT.Reg, volatile.LoadUint32(&o.APPROTECT.Reg)&^(0xff)|value)
}
func (o *UICR_Type) GetAPPROTECT_PALL() uint32 {
	return volatile.LoadUint32(&o.APPROTECT.Reg) & 0xff
}

// UICR.NFCPINS: Setting of pins dedicated to NFC functionality: NFC antenna or GPIO
func (o *UICR_Type) SetNFCPINS_PROTECT(value uint32) {
	volatile.StoreUint32(&o.NFCPINS.Reg, volatile.LoadUint32(&o.NFCPINS.Reg)&^(0x1)|value)
}
func (o *UICR_Type) GetNFCPINS_PROTECT() uint32 {
	return volatile.LoadUint32(&o.NFCPINS.Reg) & 0x1
}

// UICR.DEBUGCTRL: Processor debug control
func (o *UICR_Type) SetDEBUGCTRL_CPUNIDEN(value uint32) {
	volatile.StoreUint32(&o.DEBUGCTRL.Reg, volatile.LoadUint32(&o.DEBUGCTRL.Reg)&^(0xff)|value)
}
func (o *UICR_Type) GetDEBUGCTRL_CPUNIDEN() uint32 {
	return volatile.LoadUint32(&o.DEBUGCTRL.Reg) & 0xff
}
func (o *UICR_Type) SetDEBUGCTRL_CPUFPBEN(value uint32) {
	volatile.StoreUint32(&o.DEBUGCTRL.Reg, volatile.LoadUint32(&o.DEBUGCTRL.Reg)&^(0xff00)|value<<8)
}
func (o *UICR_Type) GetDEBUGCTRL_CPUFPBEN() uint32 {
	return (volatile.LoadUint32(&o.DEBUGCTRL.Reg) & 0xff00) >> 8
}

// UICR.REGOUT0: Output voltage from REG0 regulator stage. The maximum output voltage from this stage is given as VDDH - VREG0DROP.
func (o *UICR_Type) SetREGOUT0_VOUT(value uint32) {
	volatile.StoreUint32(&o.REGOUT0.Reg, volatile.LoadUint32(&o.REGOUT0.Reg)&^(0x7)|value)
}
func (o *UICR_Type) GetREGOUT0_VOUT() uint32 {
	return volatile.LoadUint32(&o.REGOUT0.Reg) & 0x7
}

// Clock control
type CLOCK_Type struct {
	TASKS_HFCLKSTART    volatile.Register32 // 0x0
	TASKS_HFCLKSTOP     volatile.Register32 // 0x4
	TASKS_LFCLKSTART    volatile.Register32 // 0x8
	TASKS_LFCLKSTOP     volatile.Register32 // 0xC
	TASKS_CAL           volatile.Register32 // 0x10
	TASKS_CTSTART       volatile.Register32 // 0x14
	TASKS_CTSTOP        volatile.Register32 // 0x18
	_                   [228]byte
	EVENTS_HFCLKSTARTED volatile.Register32 // 0x100
	EVENTS_LFCLKSTARTED volatile.Register32 // 0x104
	_                   [4]byte
	EVENTS_DONE         volatile.Register32 // 0x10C
	EVENTS_CTTO         volatile.Register32 // 0x110
	_                   [20]byte
	EVENTS_CTSTARTED    volatile.Register32 // 0x128
	EVENTS_CTSTOPPED    volatile.Register32 // 0x12C
	_                   [468]byte
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [252]byte
	HFCLKRUN            volatile.Register32 // 0x408
	HFCLKSTAT           volatile.Register32 // 0x40C
	_                   [4]byte
	LFCLKRUN            volatile.Register32 // 0x414
	LFCLKSTAT           volatile.Register32 // 0x418
	LFCLKSRCCOPY        volatile.Register32 // 0x41C
	_                   [248]byte
	LFCLKSRC            volatile.Register32 // 0x518
	_                   [12]byte
	HFXODEBOUNCE        volatile.Register32 // 0x528
	LFXODEBOUNCE        volatile.Register32 // 0x52C
	_                   [8]byte
	CTIV                volatile.Register32 // 0x538
	_                   [32]byte
	TRACECONFIG         volatile.Register32 // 0x55C
}

// CLOCK.TASKS_HFCLKSTART: Start HFXO crystal oscillator
func (o *CLOCK_Type) SetTASKS_HFCLKSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_HFCLKSTART.Reg, volatile.LoadUint32(&o.TASKS_HFCLKSTART.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_HFCLKSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_HFCLKSTART.Reg) & 0x1
}

// CLOCK.TASKS_HFCLKSTOP: Stop HFXO crystal oscillator
func (o *CLOCK_Type) SetTASKS_HFCLKSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_HFCLKSTOP.Reg, volatile.LoadUint32(&o.TASKS_HFCLKSTOP.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_HFCLKSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_HFCLKSTOP.Reg) & 0x1
}

// CLOCK.TASKS_LFCLKSTART: Start LFCLK
func (o *CLOCK_Type) SetTASKS_LFCLKSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_LFCLKSTART.Reg, volatile.LoadUint32(&o.TASKS_LFCLKSTART.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_LFCLKSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_LFCLKSTART.Reg) & 0x1
}

// CLOCK.TASKS_LFCLKSTOP: Stop LFCLK
func (o *CLOCK_Type) SetTASKS_LFCLKSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_LFCLKSTOP.Reg, volatile.LoadUint32(&o.TASKS_LFCLKSTOP.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_LFCLKSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_LFCLKSTOP.Reg) & 0x1
}

// CLOCK.TASKS_CAL: Start calibration of LFRC
func (o *CLOCK_Type) SetTASKS_CAL(value uint32) {
	volatile.StoreUint32(&o.TASKS_CAL.Reg, volatile.LoadUint32(&o.TASKS_CAL.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_CAL() uint32 {
	return volatile.LoadUint32(&o.TASKS_CAL.Reg) & 0x1
}

// CLOCK.TASKS_CTSTART: Start calibration timer
func (o *CLOCK_Type) SetTASKS_CTSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_CTSTART.Reg, volatile.LoadUint32(&o.TASKS_CTSTART.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_CTSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_CTSTART.Reg) & 0x1
}

// CLOCK.TASKS_CTSTOP: Stop calibration timer
func (o *CLOCK_Type) SetTASKS_CTSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_CTSTOP.Reg, volatile.LoadUint32(&o.TASKS_CTSTOP.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetTASKS_CTSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_CTSTOP.Reg) & 0x1
}

// CLOCK.EVENTS_HFCLKSTARTED: HFXO crystal oscillator started
func (o *CLOCK_Type) SetEVENTS_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_HFCLKSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_HFCLKSTARTED.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_HFCLKSTARTED.Reg) & 0x1
}

// CLOCK.EVENTS_LFCLKSTARTED: LFCLK started
func (o *CLOCK_Type) SetEVENTS_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LFCLKSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_LFCLKSTARTED.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_LFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LFCLKSTARTED.Reg) & 0x1
}

// CLOCK.EVENTS_DONE: Calibration of LFRC completed
func (o *CLOCK_Type) SetEVENTS_DONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DONE.Reg, volatile.LoadUint32(&o.EVENTS_DONE.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_DONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DONE.Reg) & 0x1
}

// CLOCK.EVENTS_CTTO: Calibration timer timeout
func (o *CLOCK_Type) SetEVENTS_CTTO(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CTTO.Reg, volatile.LoadUint32(&o.EVENTS_CTTO.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_CTTO() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CTTO.Reg) & 0x1
}

// CLOCK.EVENTS_CTSTARTED: Calibration timer has been started and is ready to process new tasks
func (o *CLOCK_Type) SetEVENTS_CTSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CTSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_CTSTARTED.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_CTSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CTSTARTED.Reg) & 0x1
}

// CLOCK.EVENTS_CTSTOPPED: Calibration timer has been stopped and is ready to process new tasks
func (o *CLOCK_Type) SetEVENTS_CTSTOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CTSTOPPED.Reg, volatile.LoadUint32(&o.EVENTS_CTSTOPPED.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetEVENTS_CTSTOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CTSTOPPED.Reg) & 0x1
}

// CLOCK.INTENSET: Enable interrupt
func (o *CLOCK_Type) SetINTENSET_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTENSET_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTENSET_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTENSET_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *CLOCK_Type) SetINTENSET_DONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *CLOCK_Type) GetINTENSET_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *CLOCK_Type) SetINTENSET_CTTO(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *CLOCK_Type) GetINTENSET_CTTO() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *CLOCK_Type) SetINTENSET_CTSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *CLOCK_Type) GetINTENSET_CTSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *CLOCK_Type) SetINTENSET_CTSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *CLOCK_Type) GetINTENSET_CTSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}

// CLOCK.INTENCLR: Disable interrupt
func (o *CLOCK_Type) SetINTENCLR_HFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetINTENCLR_HFCLKSTARTED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *CLOCK_Type) SetINTENCLR_LFCLKSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *CLOCK_Type) GetINTENCLR_LFCLKSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *CLOCK_Type) SetINTENCLR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *CLOCK_Type) GetINTENCLR_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *CLOCK_Type) SetINTENCLR_CTTO(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *CLOCK_Type) GetINTENCLR_CTTO() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *CLOCK_Type) SetINTENCLR_CTSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *CLOCK_Type) GetINTENCLR_CTSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *CLOCK_Type) SetINTENCLR_CTSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *CLOCK_Type) GetINTENCLR_CTSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}

// CLOCK.HFCLKRUN: Status indicating that HFCLKSTART task has been triggered
func (o *CLOCK_Type) SetHFCLKRUN_STATUS(value uint32) {
	volatile.StoreUint32(&o.HFCLKRUN.Reg, volatile.LoadUint32(&o.HFCLKRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKRUN_STATUS() uint32 {
	return volatile.LoadUint32(&o.HFCLKRUN.Reg) & 0x1
}

// CLOCK.HFCLKSTAT: HFCLK status
func (o *CLOCK_Type) SetHFCLKSTAT_SRC(value uint32) {
	volatile.StoreUint32(&o.HFCLKSTAT.Reg, volatile.LoadUint32(&o.HFCLKSTAT.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetHFCLKSTAT_SRC() uint32 {
	return volatile.LoadUint32(&o.HFCLKSTAT.Reg) & 0x1
}
func (o *CLOCK_Type) SetHFCLKSTAT_STATE(value uint32) {
	volatile.StoreUint32(&o.HFCLKSTAT.Reg, volatile.LoadUint32(&o.HFCLKSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCK_Type) GetHFCLKSTAT_STATE() uint32 {
	return (volatile.LoadUint32(&o.HFCLKSTAT.Reg) & 0x10000) >> 16
}

// CLOCK.LFCLKRUN: Status indicating that LFCLKSTART task has been triggered
func (o *CLOCK_Type) SetLFCLKRUN_STATUS(value uint32) {
	volatile.StoreUint32(&o.LFCLKRUN.Reg, volatile.LoadUint32(&o.LFCLKRUN.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetLFCLKRUN_STATUS() uint32 {
	return volatile.LoadUint32(&o.LFCLKRUN.Reg) & 0x1
}

// CLOCK.LFCLKSTAT: LFCLK status
func (o *CLOCK_Type) SetLFCLKSTAT_SRC(value uint32) {
	volatile.StoreUint32(&o.LFCLKSTAT.Reg, volatile.LoadUint32(&o.LFCLKSTAT.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetLFCLKSTAT_SRC() uint32 {
	return volatile.LoadUint32(&o.LFCLKSTAT.Reg) & 0x3
}
func (o *CLOCK_Type) SetLFCLKSTAT_STATE(value uint32) {
	volatile.StoreUint32(&o.LFCLKSTAT.Reg, volatile.LoadUint32(&o.LFCLKSTAT.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCK_Type) GetLFCLKSTAT_STATE() uint32 {
	return (volatile.LoadUint32(&o.LFCLKSTAT.Reg) & 0x10000) >> 16
}

// CLOCK.LFCLKSRCCOPY: Copy of LFCLKSRC register, set when LFCLKSTART task was triggered
func (o *CLOCK_Type) SetLFCLKSRCCOPY_SRC(value uint32) {
	volatile.StoreUint32(&o.LFCLKSRCCOPY.Reg, volatile.LoadUint32(&o.LFCLKSRCCOPY.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetLFCLKSRCCOPY_SRC() uint32 {
	return volatile.LoadUint32(&o.LFCLKSRCCOPY.Reg) & 0x3
}

// CLOCK.LFCLKSRC: Clock source for the LFCLK
func (o *CLOCK_Type) SetLFCLKSRC_SRC(value uint32) {
	volatile.StoreUint32(&o.LFCLKSRC.Reg, volatile.LoadUint32(&o.LFCLKSRC.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetLFCLKSRC_SRC() uint32 {
	return volatile.LoadUint32(&o.LFCLKSRC.Reg) & 0x3
}
func (o *CLOCK_Type) SetLFCLKSRC_BYPASS(value uint32) {
	volatile.StoreUint32(&o.LFCLKSRC.Reg, volatile.LoadUint32(&o.LFCLKSRC.Reg)&^(0x10000)|value<<16)
}
func (o *CLOCK_Type) GetLFCLKSRC_BYPASS() uint32 {
	return (volatile.LoadUint32(&o.LFCLKSRC.Reg) & 0x10000) >> 16
}
func (o *CLOCK_Type) SetLFCLKSRC_EXTERNAL(value uint32) {
	volatile.StoreUint32(&o.LFCLKSRC.Reg, volatile.LoadUint32(&o.LFCLKSRC.Reg)&^(0x20000)|value<<17)
}
func (o *CLOCK_Type) GetLFCLKSRC_EXTERNAL() uint32 {
	return (volatile.LoadUint32(&o.LFCLKSRC.Reg) & 0x20000) >> 17
}

// CLOCK.HFXODEBOUNCE: HFXO debounce time. The HFXO is started by triggering the TASKS_HFCLKSTART task.
func (o *CLOCK_Type) SetHFXODEBOUNCE(value uint32) {
	volatile.StoreUint32(&o.HFXODEBOUNCE.Reg, volatile.LoadUint32(&o.HFXODEBOUNCE.Reg)&^(0xff)|value)
}
func (o *CLOCK_Type) GetHFXODEBOUNCE() uint32 {
	return volatile.LoadUint32(&o.HFXODEBOUNCE.Reg) & 0xff
}

// CLOCK.LFXODEBOUNCE: LFXO debounce time. The LFXO is started by triggering the TASKS_LFCLKSTART task when the LFCLKSRC register is configured for Xtal.
func (o *CLOCK_Type) SetLFXODEBOUNCE(value uint32) {
	volatile.StoreUint32(&o.LFXODEBOUNCE.Reg, volatile.LoadUint32(&o.LFXODEBOUNCE.Reg)&^(0x1)|value)
}
func (o *CLOCK_Type) GetLFXODEBOUNCE() uint32 {
	return volatile.LoadUint32(&o.LFXODEBOUNCE.Reg) & 0x1
}

// CLOCK.CTIV: Calibration timer interval
func (o *CLOCK_Type) SetCTIV(value uint32) {
	volatile.StoreUint32(&o.CTIV.Reg, volatile.LoadUint32(&o.CTIV.Reg)&^(0x7f)|value)
}
func (o *CLOCK_Type) GetCTIV() uint32 {
	return volatile.LoadUint32(&o.CTIV.Reg) & 0x7f
}

// CLOCK.TRACECONFIG: Clocking options for the trace port debug interface
func (o *CLOCK_Type) SetTRACECONFIG_TRACEPORTSPEED(value uint32) {
	volatile.StoreUint32(&o.TRACECONFIG.Reg, volatile.LoadUint32(&o.TRACECONFIG.Reg)&^(0x3)|value)
}
func (o *CLOCK_Type) GetTRACECONFIG_TRACEPORTSPEED() uint32 {
	return volatile.LoadUint32(&o.TRACECONFIG.Reg) & 0x3
}
func (o *CLOCK_Type) SetTRACECONFIG_TRACEMUX(value uint32) {
	volatile.StoreUint32(&o.TRACECONFIG.Reg, volatile.LoadUint32(&o.TRACECONFIG.Reg)&^(0x30000)|value<<16)
}
func (o *CLOCK_Type) GetTRACECONFIG_TRACEMUX() uint32 {
	return (volatile.LoadUint32(&o.TRACECONFIG.Reg) & 0x30000) >> 16
}

// Power control
type POWER_Type struct {
	_                  [120]byte
	TASKS_CONSTLAT     volatile.Register32 // 0x78
	TASKS_LOWPWR       volatile.Register32 // 0x7C
	_                  [136]byte
	EVENTS_POFWARN     volatile.Register32 // 0x108
	_                  [8]byte
	EVENTS_SLEEPENTER  volatile.Register32 // 0x114
	EVENTS_SLEEPEXIT   volatile.Register32 // 0x118
	EVENTS_USBDETECTED volatile.Register32 // 0x11C
	EVENTS_USBREMOVED  volatile.Register32 // 0x120
	EVENTS_USBPWRRDY   volatile.Register32 // 0x124
	_                  [476]byte
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [244]byte
	RESETREAS          volatile.Register32 // 0x400
	_                  [36]byte
	RAMSTATUS          volatile.Register32 // 0x428
	_                  [12]byte
	USBREGSTATUS       volatile.Register32 // 0x438
	_                  [196]byte
	SYSTEMOFF          volatile.Register32 // 0x500
	_                  [12]byte
	POFCON             volatile.Register32 // 0x510
	_                  [8]byte
	GPREGRET           volatile.Register32 // 0x51C
	GPREGRET2          volatile.Register32 // 0x520
	_                  [84]byte
	DCDCEN             volatile.Register32 // 0x578
	_                  [196]byte
	MAINREGSTATUS      volatile.Register32 // 0x640
	_                  [700]byte
	RAM                [9]POWER_RAM_Type // 0x900
}

// POWER.TASKS_CONSTLAT: Enable Constant Latency mode
func (o *POWER_Type) SetTASKS_CONSTLAT(value uint32) {
	volatile.StoreUint32(&o.TASKS_CONSTLAT.Reg, volatile.LoadUint32(&o.TASKS_CONSTLAT.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetTASKS_CONSTLAT() uint32 {
	return volatile.LoadUint32(&o.TASKS_CONSTLAT.Reg) & 0x1
}

// POWER.TASKS_LOWPWR: Enable Low-power mode (variable latency)
func (o *POWER_Type) SetTASKS_LOWPWR(value uint32) {
	volatile.StoreUint32(&o.TASKS_LOWPWR.Reg, volatile.LoadUint32(&o.TASKS_LOWPWR.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetTASKS_LOWPWR() uint32 {
	return volatile.LoadUint32(&o.TASKS_LOWPWR.Reg) & 0x1
}

// POWER.EVENTS_POFWARN: Power failure warning
func (o *POWER_Type) SetEVENTS_POFWARN(value uint32) {
	volatile.StoreUint32(&o.EVENTS_POFWARN.Reg, volatile.LoadUint32(&o.EVENTS_POFWARN.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_POFWARN() uint32 {
	return volatile.LoadUint32(&o.EVENTS_POFWARN.Reg) & 0x1
}

// POWER.EVENTS_SLEEPENTER: CPU entered WFI/WFE sleep
func (o *POWER_Type) SetEVENTS_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SLEEPENTER.Reg, volatile.LoadUint32(&o.EVENTS_SLEEPENTER.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_SLEEPENTER() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SLEEPENTER.Reg) & 0x1
}

// POWER.EVENTS_SLEEPEXIT: CPU exited WFI/WFE sleep
func (o *POWER_Type) SetEVENTS_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SLEEPEXIT.Reg, volatile.LoadUint32(&o.EVENTS_SLEEPEXIT.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_SLEEPEXIT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SLEEPEXIT.Reg) & 0x1
}

// POWER.EVENTS_USBDETECTED: Voltage supply detected on VBUS
func (o *POWER_Type) SetEVENTS_USBDETECTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_USBDETECTED.Reg, volatile.LoadUint32(&o.EVENTS_USBDETECTED.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_USBDETECTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_USBDETECTED.Reg) & 0x1
}

// POWER.EVENTS_USBREMOVED: Voltage supply removed from VBUS
func (o *POWER_Type) SetEVENTS_USBREMOVED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_USBREMOVED.Reg, volatile.LoadUint32(&o.EVENTS_USBREMOVED.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_USBREMOVED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_USBREMOVED.Reg) & 0x1
}

// POWER.EVENTS_USBPWRRDY: USB 3.3 V supply ready
func (o *POWER_Type) SetEVENTS_USBPWRRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_USBPWRRDY.Reg, volatile.LoadUint32(&o.EVENTS_USBPWRRDY.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetEVENTS_USBPWRRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_USBPWRRDY.Reg) & 0x1
}

// POWER.INTENSET: Enable interrupt
func (o *POWER_Type) SetINTENSET_POFWARN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetINTENSET_POFWARN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetINTENSET_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *POWER_Type) GetINTENSET_SLEEPENTER() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *POWER_Type) SetINTENSET_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *POWER_Type) GetINTENSET_SLEEPEXIT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *POWER_Type) SetINTENSET_USBDETECTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *POWER_Type) GetINTENSET_USBDETECTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *POWER_Type) SetINTENSET_USBREMOVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *POWER_Type) GetINTENSET_USBREMOVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *POWER_Type) SetINTENSET_USBPWRRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *POWER_Type) GetINTENSET_USBPWRRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}

// POWER.INTENCLR: Disable interrupt
func (o *POWER_Type) SetINTENCLR_POFWARN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetINTENCLR_POFWARN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetINTENCLR_SLEEPENTER(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *POWER_Type) GetINTENCLR_SLEEPENTER() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *POWER_Type) SetINTENCLR_SLEEPEXIT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *POWER_Type) GetINTENCLR_SLEEPEXIT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *POWER_Type) SetINTENCLR_USBDETECTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *POWER_Type) GetINTENCLR_USBDETECTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *POWER_Type) SetINTENCLR_USBREMOVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *POWER_Type) GetINTENCLR_USBREMOVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *POWER_Type) SetINTENCLR_USBPWRRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *POWER_Type) GetINTENCLR_USBPWRRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}

// POWER.RESETREAS: Reset reason
func (o *POWER_Type) SetRESETREAS_RESETPIN(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetRESETREAS_RESETPIN() uint32 {
	return volatile.LoadUint32(&o.RESETREAS.Reg) & 0x1
}
func (o *POWER_Type) SetRESETREAS_DOG(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x2)|value<<1)
}
func (o *POWER_Type) GetRESETREAS_DOG() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x2) >> 1
}
func (o *POWER_Type) SetRESETREAS_SREQ(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetRESETREAS_SREQ() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetRESETREAS_LOCKUP(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x8)|value<<3)
}
func (o *POWER_Type) GetRESETREAS_LOCKUP() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x8) >> 3
}
func (o *POWER_Type) SetRESETREAS_OFF(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x10000)|value<<16)
}
func (o *POWER_Type) GetRESETREAS_OFF() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x10000) >> 16
}
func (o *POWER_Type) SetRESETREAS_LPCOMP(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x20000)|value<<17)
}
func (o *POWER_Type) GetRESETREAS_LPCOMP() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x20000) >> 17
}
func (o *POWER_Type) SetRESETREAS_DIF(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x40000)|value<<18)
}
func (o *POWER_Type) GetRESETREAS_DIF() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x40000) >> 18
}
func (o *POWER_Type) SetRESETREAS_NFC(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x80000)|value<<19)
}
func (o *POWER_Type) GetRESETREAS_NFC() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x80000) >> 19
}
func (o *POWER_Type) SetRESETREAS_VBUS(value uint32) {
	volatile.StoreUint32(&o.RESETREAS.Reg, volatile.LoadUint32(&o.RESETREAS.Reg)&^(0x100000)|value<<20)
}
func (o *POWER_Type) GetRESETREAS_VBUS() uint32 {
	return (volatile.LoadUint32(&o.RESETREAS.Reg) & 0x100000) >> 20
}

// POWER.RAMSTATUS: Deprecated register - RAM status register
func (o *POWER_Type) SetRAMSTATUS_RAMBLOCK0(value uint32) {
	volatile.StoreUint32(&o.RAMSTATUS.Reg, volatile.LoadUint32(&o.RAMSTATUS.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetRAMSTATUS_RAMBLOCK0() uint32 {
	return volatile.LoadUint32(&o.RAMSTATUS.Reg) & 0x1
}
func (o *POWER_Type) SetRAMSTATUS_RAMBLOCK1(value uint32) {
	volatile.StoreUint32(&o.RAMSTATUS.Reg, volatile.LoadUint32(&o.RAMSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *POWER_Type) GetRAMSTATUS_RAMBLOCK1() uint32 {
	return (volatile.LoadUint32(&o.RAMSTATUS.Reg) & 0x2) >> 1
}
func (o *POWER_Type) SetRAMSTATUS_RAMBLOCK2(value uint32) {
	volatile.StoreUint32(&o.RAMSTATUS.Reg, volatile.LoadUint32(&o.RAMSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *POWER_Type) GetRAMSTATUS_RAMBLOCK2() uint32 {
	return (volatile.LoadUint32(&o.RAMSTATUS.Reg) & 0x4) >> 2
}
func (o *POWER_Type) SetRAMSTATUS_RAMBLOCK3(value uint32) {
	volatile.StoreUint32(&o.RAMSTATUS.Reg, volatile.LoadUint32(&o.RAMSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *POWER_Type) GetRAMSTATUS_RAMBLOCK3() uint32 {
	return (volatile.LoadUint32(&o.RAMSTATUS.Reg) & 0x8) >> 3
}

// POWER.USBREGSTATUS: USB supply status
func (o *POWER_Type) SetUSBREGSTATUS_VBUSDETECT(value uint32) {
	volatile.StoreUint32(&o.USBREGSTATUS.Reg, volatile.LoadUint32(&o.USBREGSTATUS.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetUSBREGSTATUS_VBUSDETECT() uint32 {
	return volatile.LoadUint32(&o.USBREGSTATUS.Reg) & 0x1
}
func (o *POWER_Type) SetUSBREGSTATUS_OUTPUTRDY(value uint32) {
	volatile.StoreUint32(&o.USBREGSTATUS.Reg, volatile.LoadUint32(&o.USBREGSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *POWER_Type) GetUSBREGSTATUS_OUTPUTRDY() uint32 {
	return (volatile.LoadUint32(&o.USBREGSTATUS.Reg) & 0x2) >> 1
}

// POWER.SYSTEMOFF: System OFF register
func (o *POWER_Type) SetSYSTEMOFF(value uint32) {
	volatile.StoreUint32(&o.SYSTEMOFF.Reg, volatile.LoadUint32(&o.SYSTEMOFF.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetSYSTEMOFF() uint32 {
	return volatile.LoadUint32(&o.SYSTEMOFF.Reg) & 0x1
}

// POWER.POFCON: Power-fail comparator configuration
func (o *POWER_Type) SetPOFCON_POF(value uint32) {
	volatile.StoreUint32(&o.POFCON.Reg, volatile.LoadUint32(&o.POFCON.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetPOFCON_POF() uint32 {
	return volatile.LoadUint32(&o.POFCON.Reg) & 0x1
}
func (o *POWER_Type) SetPOFCON_THRESHOLD(value uint32) {
	volatile.StoreUint32(&o.POFCON.Reg, volatile.LoadUint32(&o.POFCON.Reg)&^(0x1e)|value<<1)
}
func (o *POWER_Type) GetPOFCON_THRESHOLD() uint32 {
	return (volatile.LoadUint32(&o.POFCON.Reg) & 0x1e) >> 1
}
func (o *POWER_Type) SetPOFCON_THRESHOLDVDDH(value uint32) {
	volatile.StoreUint32(&o.POFCON.Reg, volatile.LoadUint32(&o.POFCON.Reg)&^(0xf00)|value<<8)
}
func (o *POWER_Type) GetPOFCON_THRESHOLDVDDH() uint32 {
	return (volatile.LoadUint32(&o.POFCON.Reg) & 0xf00) >> 8
}

// POWER.GPREGRET: General purpose retention register
func (o *POWER_Type) SetGPREGRET(value uint32) {
	volatile.StoreUint32(&o.GPREGRET.Reg, volatile.LoadUint32(&o.GPREGRET.Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetGPREGRET() uint32 {
	return volatile.LoadUint32(&o.GPREGRET.Reg) & 0xff
}

// POWER.GPREGRET2: General purpose retention register
func (o *POWER_Type) SetGPREGRET2_GPREGRET(value uint32) {
	volatile.StoreUint32(&o.GPREGRET2.Reg, volatile.LoadUint32(&o.GPREGRET2.Reg)&^(0xff)|value)
}
func (o *POWER_Type) GetGPREGRET2_GPREGRET() uint32 {
	return volatile.LoadUint32(&o.GPREGRET2.Reg) & 0xff
}

// POWER.DCDCEN: Enable DC/DC converter for REG1 stage
func (o *POWER_Type) SetDCDCEN(value uint32) {
	volatile.StoreUint32(&o.DCDCEN.Reg, volatile.LoadUint32(&o.DCDCEN.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetDCDCEN() uint32 {
	return volatile.LoadUint32(&o.DCDCEN.Reg) & 0x1
}

// POWER.MAINREGSTATUS: Main supply status
func (o *POWER_Type) SetMAINREGSTATUS(value uint32) {
	volatile.StoreUint32(&o.MAINREGSTATUS.Reg, volatile.LoadUint32(&o.MAINREGSTATUS.Reg)&^(0x1)|value)
}
func (o *POWER_Type) GetMAINREGSTATUS() uint32 {
	return volatile.LoadUint32(&o.MAINREGSTATUS.Reg) & 0x1
}

// Unspecified
type POWER_RAM_Type struct {
	POWER    volatile.Register32 // 0x900
	POWERSET volatile.Register32 // 0x904
	POWERCLR volatile.Register32 // 0x908
	_        [4]byte
}

// POWER_RAM.POWER: Description cluster: RAMn power control register
func (o *POWER_RAM_Type) SetPOWER_S0POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x1)|value)
}
func (o *POWER_RAM_Type) GetPOWER_S0POWER() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x1
}
func (o *POWER_RAM_Type) SetPOWER_S1POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x2)|value<<1)
}
func (o *POWER_RAM_Type) GetPOWER_S1POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x2) >> 1
}
func (o *POWER_RAM_Type) SetPOWER_S2POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x4)|value<<2)
}
func (o *POWER_RAM_Type) GetPOWER_S2POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x4) >> 2
}
func (o *POWER_RAM_Type) SetPOWER_S3POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x8)|value<<3)
}
func (o *POWER_RAM_Type) GetPOWER_S3POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x8) >> 3
}
func (o *POWER_RAM_Type) SetPOWER_S4POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x10)|value<<4)
}
func (o *POWER_RAM_Type) GetPOWER_S4POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x10) >> 4
}
func (o *POWER_RAM_Type) SetPOWER_S5POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x20)|value<<5)
}
func (o *POWER_RAM_Type) GetPOWER_S5POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x20) >> 5
}
func (o *POWER_RAM_Type) SetPOWER_S6POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x40)|value<<6)
}
func (o *POWER_RAM_Type) GetPOWER_S6POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x40) >> 6
}
func (o *POWER_RAM_Type) SetPOWER_S7POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x80)|value<<7)
}
func (o *POWER_RAM_Type) GetPOWER_S7POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x80) >> 7
}
func (o *POWER_RAM_Type) SetPOWER_S8POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x100)|value<<8)
}
func (o *POWER_RAM_Type) GetPOWER_S8POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x100) >> 8
}
func (o *POWER_RAM_Type) SetPOWER_S9POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x200)|value<<9)
}
func (o *POWER_RAM_Type) GetPOWER_S9POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x200) >> 9
}
func (o *POWER_RAM_Type) SetPOWER_S10POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x400)|value<<10)
}
func (o *POWER_RAM_Type) GetPOWER_S10POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x400) >> 10
}
func (o *POWER_RAM_Type) SetPOWER_S11POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x800)|value<<11)
}
func (o *POWER_RAM_Type) GetPOWER_S11POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x800) >> 11
}
func (o *POWER_RAM_Type) SetPOWER_S12POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x1000)|value<<12)
}
func (o *POWER_RAM_Type) GetPOWER_S12POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x1000) >> 12
}
func (o *POWER_RAM_Type) SetPOWER_S13POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x2000)|value<<13)
}
func (o *POWER_RAM_Type) GetPOWER_S13POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x2000) >> 13
}
func (o *POWER_RAM_Type) SetPOWER_S14POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x4000)|value<<14)
}
func (o *POWER_RAM_Type) GetPOWER_S14POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x4000) >> 14
}
func (o *POWER_RAM_Type) SetPOWER_S15POWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x8000)|value<<15)
}
func (o *POWER_RAM_Type) GetPOWER_S15POWER() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x8000) >> 15
}
func (o *POWER_RAM_Type) SetPOWER_S0RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x10000)|value<<16)
}
func (o *POWER_RAM_Type) GetPOWER_S0RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x10000) >> 16
}
func (o *POWER_RAM_Type) SetPOWER_S1RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x20000)|value<<17)
}
func (o *POWER_RAM_Type) GetPOWER_S1RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x20000) >> 17
}
func (o *POWER_RAM_Type) SetPOWER_S2RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x40000)|value<<18)
}
func (o *POWER_RAM_Type) GetPOWER_S2RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x40000) >> 18
}
func (o *POWER_RAM_Type) SetPOWER_S3RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x80000)|value<<19)
}
func (o *POWER_RAM_Type) GetPOWER_S3RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x80000) >> 19
}
func (o *POWER_RAM_Type) SetPOWER_S4RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x100000)|value<<20)
}
func (o *POWER_RAM_Type) GetPOWER_S4RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x100000) >> 20
}
func (o *POWER_RAM_Type) SetPOWER_S5RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x200000)|value<<21)
}
func (o *POWER_RAM_Type) GetPOWER_S5RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x200000) >> 21
}
func (o *POWER_RAM_Type) SetPOWER_S6RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x400000)|value<<22)
}
func (o *POWER_RAM_Type) GetPOWER_S6RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x400000) >> 22
}
func (o *POWER_RAM_Type) SetPOWER_S7RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x800000)|value<<23)
}
func (o *POWER_RAM_Type) GetPOWER_S7RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x800000) >> 23
}
func (o *POWER_RAM_Type) SetPOWER_S8RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x1000000)|value<<24)
}
func (o *POWER_RAM_Type) GetPOWER_S8RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x1000000) >> 24
}
func (o *POWER_RAM_Type) SetPOWER_S9RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x2000000)|value<<25)
}
func (o *POWER_RAM_Type) GetPOWER_S9RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x2000000) >> 25
}
func (o *POWER_RAM_Type) SetPOWER_S10RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x4000000)|value<<26)
}
func (o *POWER_RAM_Type) GetPOWER_S10RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x4000000) >> 26
}
func (o *POWER_RAM_Type) SetPOWER_S11RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x8000000)|value<<27)
}
func (o *POWER_RAM_Type) GetPOWER_S11RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x8000000) >> 27
}
func (o *POWER_RAM_Type) SetPOWER_S12RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x10000000)|value<<28)
}
func (o *POWER_RAM_Type) GetPOWER_S12RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x10000000) >> 28
}
func (o *POWER_RAM_Type) SetPOWER_S13RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x20000000)|value<<29)
}
func (o *POWER_RAM_Type) GetPOWER_S13RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x20000000) >> 29
}
func (o *POWER_RAM_Type) SetPOWER_S14RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x40000000)|value<<30)
}
func (o *POWER_RAM_Type) GetPOWER_S14RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x40000000) >> 30
}
func (o *POWER_RAM_Type) SetPOWER_S15RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_RAM_Type) GetPOWER_S15RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWER.Reg) & 0x80000000) >> 31
}

// POWER_RAM.POWERSET: Description cluster: RAMn power control set register
func (o *POWER_RAM_Type) SetPOWERSET_S0POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x1)|value)
}
func (o *POWER_RAM_Type) GetPOWERSET_S0POWER() uint32 {
	return volatile.LoadUint32(&o.POWERSET.Reg) & 0x1
}
func (o *POWER_RAM_Type) SetPOWERSET_S1POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x2)|value<<1)
}
func (o *POWER_RAM_Type) GetPOWERSET_S1POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x2) >> 1
}
func (o *POWER_RAM_Type) SetPOWERSET_S2POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x4)|value<<2)
}
func (o *POWER_RAM_Type) GetPOWERSET_S2POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x4) >> 2
}
func (o *POWER_RAM_Type) SetPOWERSET_S3POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x8)|value<<3)
}
func (o *POWER_RAM_Type) GetPOWERSET_S3POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x8) >> 3
}
func (o *POWER_RAM_Type) SetPOWERSET_S4POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x10)|value<<4)
}
func (o *POWER_RAM_Type) GetPOWERSET_S4POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x10) >> 4
}
func (o *POWER_RAM_Type) SetPOWERSET_S5POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x20)|value<<5)
}
func (o *POWER_RAM_Type) GetPOWERSET_S5POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x20) >> 5
}
func (o *POWER_RAM_Type) SetPOWERSET_S6POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x40)|value<<6)
}
func (o *POWER_RAM_Type) GetPOWERSET_S6POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x40) >> 6
}
func (o *POWER_RAM_Type) SetPOWERSET_S7POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x80)|value<<7)
}
func (o *POWER_RAM_Type) GetPOWERSET_S7POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x80) >> 7
}
func (o *POWER_RAM_Type) SetPOWERSET_S8POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x100)|value<<8)
}
func (o *POWER_RAM_Type) GetPOWERSET_S8POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x100) >> 8
}
func (o *POWER_RAM_Type) SetPOWERSET_S9POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x200)|value<<9)
}
func (o *POWER_RAM_Type) GetPOWERSET_S9POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x200) >> 9
}
func (o *POWER_RAM_Type) SetPOWERSET_S10POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x400)|value<<10)
}
func (o *POWER_RAM_Type) GetPOWERSET_S10POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x400) >> 10
}
func (o *POWER_RAM_Type) SetPOWERSET_S11POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x800)|value<<11)
}
func (o *POWER_RAM_Type) GetPOWERSET_S11POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x800) >> 11
}
func (o *POWER_RAM_Type) SetPOWERSET_S12POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x1000)|value<<12)
}
func (o *POWER_RAM_Type) GetPOWERSET_S12POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x1000) >> 12
}
func (o *POWER_RAM_Type) SetPOWERSET_S13POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x2000)|value<<13)
}
func (o *POWER_RAM_Type) GetPOWERSET_S13POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x2000) >> 13
}
func (o *POWER_RAM_Type) SetPOWERSET_S14POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x4000)|value<<14)
}
func (o *POWER_RAM_Type) GetPOWERSET_S14POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x4000) >> 14
}
func (o *POWER_RAM_Type) SetPOWERSET_S15POWER(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x8000)|value<<15)
}
func (o *POWER_RAM_Type) GetPOWERSET_S15POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x8000) >> 15
}
func (o *POWER_RAM_Type) SetPOWERSET_S0RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x10000)|value<<16)
}
func (o *POWER_RAM_Type) GetPOWERSET_S0RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x10000) >> 16
}
func (o *POWER_RAM_Type) SetPOWERSET_S1RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x20000)|value<<17)
}
func (o *POWER_RAM_Type) GetPOWERSET_S1RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x20000) >> 17
}
func (o *POWER_RAM_Type) SetPOWERSET_S2RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x40000)|value<<18)
}
func (o *POWER_RAM_Type) GetPOWERSET_S2RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x40000) >> 18
}
func (o *POWER_RAM_Type) SetPOWERSET_S3RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x80000)|value<<19)
}
func (o *POWER_RAM_Type) GetPOWERSET_S3RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x80000) >> 19
}
func (o *POWER_RAM_Type) SetPOWERSET_S4RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x100000)|value<<20)
}
func (o *POWER_RAM_Type) GetPOWERSET_S4RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x100000) >> 20
}
func (o *POWER_RAM_Type) SetPOWERSET_S5RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x200000)|value<<21)
}
func (o *POWER_RAM_Type) GetPOWERSET_S5RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x200000) >> 21
}
func (o *POWER_RAM_Type) SetPOWERSET_S6RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x400000)|value<<22)
}
func (o *POWER_RAM_Type) GetPOWERSET_S6RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x400000) >> 22
}
func (o *POWER_RAM_Type) SetPOWERSET_S7RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x800000)|value<<23)
}
func (o *POWER_RAM_Type) GetPOWERSET_S7RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x800000) >> 23
}
func (o *POWER_RAM_Type) SetPOWERSET_S8RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x1000000)|value<<24)
}
func (o *POWER_RAM_Type) GetPOWERSET_S8RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x1000000) >> 24
}
func (o *POWER_RAM_Type) SetPOWERSET_S9RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x2000000)|value<<25)
}
func (o *POWER_RAM_Type) GetPOWERSET_S9RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x2000000) >> 25
}
func (o *POWER_RAM_Type) SetPOWERSET_S10RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x4000000)|value<<26)
}
func (o *POWER_RAM_Type) GetPOWERSET_S10RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x4000000) >> 26
}
func (o *POWER_RAM_Type) SetPOWERSET_S11RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x8000000)|value<<27)
}
func (o *POWER_RAM_Type) GetPOWERSET_S11RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x8000000) >> 27
}
func (o *POWER_RAM_Type) SetPOWERSET_S12RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x10000000)|value<<28)
}
func (o *POWER_RAM_Type) GetPOWERSET_S12RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x10000000) >> 28
}
func (o *POWER_RAM_Type) SetPOWERSET_S13RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x20000000)|value<<29)
}
func (o *POWER_RAM_Type) GetPOWERSET_S13RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x20000000) >> 29
}
func (o *POWER_RAM_Type) SetPOWERSET_S14RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x40000000)|value<<30)
}
func (o *POWER_RAM_Type) GetPOWERSET_S14RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x40000000) >> 30
}
func (o *POWER_RAM_Type) SetPOWERSET_S15RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERSET.Reg, volatile.LoadUint32(&o.POWERSET.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_RAM_Type) GetPOWERSET_S15RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERSET.Reg) & 0x80000000) >> 31
}

// POWER_RAM.POWERCLR: Description cluster: RAMn power control clear register
func (o *POWER_RAM_Type) SetPOWERCLR_S0POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x1)|value)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S0POWER() uint32 {
	return volatile.LoadUint32(&o.POWERCLR.Reg) & 0x1
}
func (o *POWER_RAM_Type) SetPOWERCLR_S1POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x2)|value<<1)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S1POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x2) >> 1
}
func (o *POWER_RAM_Type) SetPOWERCLR_S2POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x4)|value<<2)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S2POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x4) >> 2
}
func (o *POWER_RAM_Type) SetPOWERCLR_S3POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x8)|value<<3)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S3POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x8) >> 3
}
func (o *POWER_RAM_Type) SetPOWERCLR_S4POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x10)|value<<4)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S4POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x10) >> 4
}
func (o *POWER_RAM_Type) SetPOWERCLR_S5POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x20)|value<<5)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S5POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x20) >> 5
}
func (o *POWER_RAM_Type) SetPOWERCLR_S6POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x40)|value<<6)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S6POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x40) >> 6
}
func (o *POWER_RAM_Type) SetPOWERCLR_S7POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x80)|value<<7)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S7POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x80) >> 7
}
func (o *POWER_RAM_Type) SetPOWERCLR_S8POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x100)|value<<8)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S8POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x100) >> 8
}
func (o *POWER_RAM_Type) SetPOWERCLR_S9POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x200)|value<<9)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S9POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x200) >> 9
}
func (o *POWER_RAM_Type) SetPOWERCLR_S10POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x400)|value<<10)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S10POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x400) >> 10
}
func (o *POWER_RAM_Type) SetPOWERCLR_S11POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x800)|value<<11)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S11POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x800) >> 11
}
func (o *POWER_RAM_Type) SetPOWERCLR_S12POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x1000)|value<<12)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S12POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x1000) >> 12
}
func (o *POWER_RAM_Type) SetPOWERCLR_S13POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x2000)|value<<13)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S13POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x2000) >> 13
}
func (o *POWER_RAM_Type) SetPOWERCLR_S14POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x4000)|value<<14)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S14POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x4000) >> 14
}
func (o *POWER_RAM_Type) SetPOWERCLR_S15POWER(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x8000)|value<<15)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S15POWER() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x8000) >> 15
}
func (o *POWER_RAM_Type) SetPOWERCLR_S0RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x10000)|value<<16)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S0RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x10000) >> 16
}
func (o *POWER_RAM_Type) SetPOWERCLR_S1RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x20000)|value<<17)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S1RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x20000) >> 17
}
func (o *POWER_RAM_Type) SetPOWERCLR_S2RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x40000)|value<<18)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S2RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x40000) >> 18
}
func (o *POWER_RAM_Type) SetPOWERCLR_S3RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x80000)|value<<19)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S3RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x80000) >> 19
}
func (o *POWER_RAM_Type) SetPOWERCLR_S4RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x100000)|value<<20)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S4RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x100000) >> 20
}
func (o *POWER_RAM_Type) SetPOWERCLR_S5RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x200000)|value<<21)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S5RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x200000) >> 21
}
func (o *POWER_RAM_Type) SetPOWERCLR_S6RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x400000)|value<<22)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S6RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x400000) >> 22
}
func (o *POWER_RAM_Type) SetPOWERCLR_S7RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x800000)|value<<23)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S7RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x800000) >> 23
}
func (o *POWER_RAM_Type) SetPOWERCLR_S8RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S8RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x1000000) >> 24
}
func (o *POWER_RAM_Type) SetPOWERCLR_S9RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S9RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x2000000) >> 25
}
func (o *POWER_RAM_Type) SetPOWERCLR_S10RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S10RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x4000000) >> 26
}
func (o *POWER_RAM_Type) SetPOWERCLR_S11RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S11RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x8000000) >> 27
}
func (o *POWER_RAM_Type) SetPOWERCLR_S12RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S12RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x10000000) >> 28
}
func (o *POWER_RAM_Type) SetPOWERCLR_S13RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S13RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x20000000) >> 29
}
func (o *POWER_RAM_Type) SetPOWERCLR_S14RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S14RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x40000000) >> 30
}
func (o *POWER_RAM_Type) SetPOWERCLR_S15RETENTION(value uint32) {
	volatile.StoreUint32(&o.POWERCLR.Reg, volatile.LoadUint32(&o.POWERCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *POWER_RAM_Type) GetPOWERCLR_S15RETENTION() uint32 {
	return (volatile.LoadUint32(&o.POWERCLR.Reg) & 0x80000000) >> 31
}

// GPIO Port 1
type GPIO_Type struct {
	_          [1284]byte
	OUT        volatile.Register32 // 0x504
	OUTSET     volatile.Register32 // 0x508
	OUTCLR     volatile.Register32 // 0x50C
	IN         volatile.Register32 // 0x510
	DIR        volatile.Register32 // 0x514
	DIRSET     volatile.Register32 // 0x518
	DIRCLR     volatile.Register32 // 0x51C
	LATCH      volatile.Register32 // 0x520
	DETECTMODE volatile.Register32 // 0x524
	_          [472]byte
	PIN_CNF    [32]volatile.Register32 // 0x700
}

// GPIO.OUT: Write GPIO port
func (o *GPIO_Type) SetOUT_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUT_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUT.Reg) & 0x1
}
func (o *GPIO_Type) SetOUT_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUT_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUT_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUT_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUT_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUT_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUT_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUT_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUT_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUT_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUT_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUT_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUT_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUT_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUT_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUT_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUT_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUT_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUT_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUT_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUT_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUT_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUT_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUT_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUT_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUT_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUT_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUT_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUT_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUT_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUT_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUT_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUT_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUT_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUT_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUT_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUT_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUT_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUT_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUT_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUT_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUT_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUT_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUT_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUT_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUT_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUT_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUT_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUT_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUT_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUT_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUT_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUT_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUT_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUT_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUT_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUT_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUT_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUT_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUT_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUT_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUT.Reg, volatile.LoadUint32(&o.OUT.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUT_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUT.Reg) & 0x80000000) >> 31
}

// GPIO.OUTSET: Set individual bits in GPIO port
func (o *GPIO_Type) SetOUTSET_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUTSET_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUTSET.Reg) & 0x1
}
func (o *GPIO_Type) SetOUTSET_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUTSET_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUTSET_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUTSET_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUTSET_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUTSET_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUTSET_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUTSET_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUTSET_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUTSET_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUTSET_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUTSET_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUTSET_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUTSET_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUTSET_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUTSET_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUTSET_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUTSET_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUTSET_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUTSET_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUTSET_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUTSET_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUTSET_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUTSET_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUTSET_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUTSET_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUTSET_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUTSET_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUTSET_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUTSET_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUTSET_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUTSET_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUTSET_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUTSET_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUTSET_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUTSET_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUTSET_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUTSET_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUTSET_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUTSET_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUTSET_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUTSET_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUTSET_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUTSET_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUTSET_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUTSET_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUTSET_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUTSET_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUTSET_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUTSET_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUTSET_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUTSET_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUTSET_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUTSET_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUTSET_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUTSET_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUTSET_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUTSET_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUTSET_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUTSET_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUTSET_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUTSET.Reg, volatile.LoadUint32(&o.OUTSET.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUTSET_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUTSET.Reg) & 0x80000000) >> 31
}

// GPIO.OUTCLR: Clear individual bits in GPIO port
func (o *GPIO_Type) SetOUTCLR_PIN0(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetOUTCLR_PIN0() uint32 {
	return volatile.LoadUint32(&o.OUTCLR.Reg) & 0x1
}
func (o *GPIO_Type) SetOUTCLR_PIN1(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetOUTCLR_PIN1() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetOUTCLR_PIN2(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetOUTCLR_PIN2() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetOUTCLR_PIN3(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetOUTCLR_PIN3() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetOUTCLR_PIN4(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetOUTCLR_PIN4() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetOUTCLR_PIN5(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetOUTCLR_PIN5() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetOUTCLR_PIN6(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetOUTCLR_PIN6() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetOUTCLR_PIN7(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetOUTCLR_PIN7() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetOUTCLR_PIN8(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetOUTCLR_PIN8() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetOUTCLR_PIN9(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetOUTCLR_PIN9() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetOUTCLR_PIN10(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetOUTCLR_PIN10() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetOUTCLR_PIN11(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetOUTCLR_PIN11() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetOUTCLR_PIN12(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetOUTCLR_PIN12() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetOUTCLR_PIN13(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetOUTCLR_PIN13() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetOUTCLR_PIN14(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetOUTCLR_PIN14() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetOUTCLR_PIN15(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetOUTCLR_PIN15() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetOUTCLR_PIN16(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetOUTCLR_PIN16() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetOUTCLR_PIN17(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetOUTCLR_PIN17() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetOUTCLR_PIN18(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetOUTCLR_PIN18() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetOUTCLR_PIN19(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetOUTCLR_PIN19() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetOUTCLR_PIN20(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetOUTCLR_PIN20() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetOUTCLR_PIN21(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetOUTCLR_PIN21() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetOUTCLR_PIN22(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetOUTCLR_PIN22() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetOUTCLR_PIN23(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetOUTCLR_PIN23() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetOUTCLR_PIN24(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetOUTCLR_PIN24() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetOUTCLR_PIN25(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetOUTCLR_PIN25() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetOUTCLR_PIN26(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetOUTCLR_PIN26() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetOUTCLR_PIN27(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetOUTCLR_PIN27() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetOUTCLR_PIN28(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetOUTCLR_PIN28() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetOUTCLR_PIN29(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetOUTCLR_PIN29() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetOUTCLR_PIN30(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetOUTCLR_PIN30() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetOUTCLR_PIN31(value uint32) {
	volatile.StoreUint32(&o.OUTCLR.Reg, volatile.LoadUint32(&o.OUTCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetOUTCLR_PIN31() uint32 {
	return (volatile.LoadUint32(&o.OUTCLR.Reg) & 0x80000000) >> 31
}

// GPIO.IN: Read GPIO port
func (o *GPIO_Type) SetIN_PIN0(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetIN_PIN0() uint32 {
	return volatile.LoadUint32(&o.IN.Reg) & 0x1
}
func (o *GPIO_Type) SetIN_PIN1(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetIN_PIN1() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetIN_PIN2(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetIN_PIN2() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetIN_PIN3(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetIN_PIN3() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetIN_PIN4(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetIN_PIN4() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetIN_PIN5(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetIN_PIN5() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetIN_PIN6(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetIN_PIN6() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetIN_PIN7(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetIN_PIN7() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetIN_PIN8(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetIN_PIN8() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetIN_PIN9(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetIN_PIN9() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetIN_PIN10(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetIN_PIN10() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetIN_PIN11(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetIN_PIN11() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetIN_PIN12(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetIN_PIN12() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetIN_PIN13(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetIN_PIN13() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetIN_PIN14(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetIN_PIN14() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetIN_PIN15(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetIN_PIN15() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetIN_PIN16(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetIN_PIN16() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetIN_PIN17(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetIN_PIN17() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetIN_PIN18(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetIN_PIN18() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetIN_PIN19(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetIN_PIN19() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetIN_PIN20(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetIN_PIN20() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetIN_PIN21(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetIN_PIN21() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetIN_PIN22(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetIN_PIN22() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetIN_PIN23(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetIN_PIN23() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetIN_PIN24(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetIN_PIN24() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetIN_PIN25(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetIN_PIN25() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetIN_PIN26(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetIN_PIN26() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetIN_PIN27(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetIN_PIN27() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetIN_PIN28(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetIN_PIN28() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetIN_PIN29(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetIN_PIN29() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetIN_PIN30(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetIN_PIN30() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetIN_PIN31(value uint32) {
	volatile.StoreUint32(&o.IN.Reg, volatile.LoadUint32(&o.IN.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetIN_PIN31() uint32 {
	return (volatile.LoadUint32(&o.IN.Reg) & 0x80000000) >> 31
}

// GPIO.DIR: Direction of GPIO pins
func (o *GPIO_Type) SetDIR_PIN0(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIR_PIN0() uint32 {
	return volatile.LoadUint32(&o.DIR.Reg) & 0x1
}
func (o *GPIO_Type) SetDIR_PIN1(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIR_PIN1() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIR_PIN2(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIR_PIN2() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIR_PIN3(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIR_PIN3() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIR_PIN4(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIR_PIN4() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIR_PIN5(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIR_PIN5() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIR_PIN6(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIR_PIN6() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIR_PIN7(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIR_PIN7() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIR_PIN8(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIR_PIN8() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIR_PIN9(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIR_PIN9() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIR_PIN10(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIR_PIN10() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIR_PIN11(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIR_PIN11() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIR_PIN12(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIR_PIN12() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIR_PIN13(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIR_PIN13() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIR_PIN14(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIR_PIN14() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIR_PIN15(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIR_PIN15() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIR_PIN16(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIR_PIN16() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIR_PIN17(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIR_PIN17() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIR_PIN18(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIR_PIN18() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIR_PIN19(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIR_PIN19() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIR_PIN20(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIR_PIN20() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIR_PIN21(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIR_PIN21() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIR_PIN22(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIR_PIN22() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIR_PIN23(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIR_PIN23() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIR_PIN24(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIR_PIN24() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIR_PIN25(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIR_PIN25() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIR_PIN26(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIR_PIN26() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIR_PIN27(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIR_PIN27() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIR_PIN28(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIR_PIN28() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIR_PIN29(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIR_PIN29() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIR_PIN30(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIR_PIN30() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIR_PIN31(value uint32) {
	volatile.StoreUint32(&o.DIR.Reg, volatile.LoadUint32(&o.DIR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIR_PIN31() uint32 {
	return (volatile.LoadUint32(&o.DIR.Reg) & 0x80000000) >> 31
}

// GPIO.DIRSET: DIR set register
func (o *GPIO_Type) SetDIRSET_PIN0(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIRSET_PIN0() uint32 {
	return volatile.LoadUint32(&o.DIRSET.Reg) & 0x1
}
func (o *GPIO_Type) SetDIRSET_PIN1(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIRSET_PIN1() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIRSET_PIN2(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIRSET_PIN2() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIRSET_PIN3(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIRSET_PIN3() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIRSET_PIN4(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIRSET_PIN4() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIRSET_PIN5(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIRSET_PIN5() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIRSET_PIN6(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIRSET_PIN6() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIRSET_PIN7(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIRSET_PIN7() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIRSET_PIN8(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIRSET_PIN8() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIRSET_PIN9(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIRSET_PIN9() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIRSET_PIN10(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIRSET_PIN10() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIRSET_PIN11(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIRSET_PIN11() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIRSET_PIN12(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIRSET_PIN12() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIRSET_PIN13(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIRSET_PIN13() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIRSET_PIN14(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIRSET_PIN14() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIRSET_PIN15(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIRSET_PIN15() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIRSET_PIN16(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIRSET_PIN16() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIRSET_PIN17(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIRSET_PIN17() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIRSET_PIN18(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIRSET_PIN18() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIRSET_PIN19(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIRSET_PIN19() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIRSET_PIN20(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIRSET_PIN20() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIRSET_PIN21(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIRSET_PIN21() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIRSET_PIN22(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIRSET_PIN22() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIRSET_PIN23(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIRSET_PIN23() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIRSET_PIN24(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIRSET_PIN24() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIRSET_PIN25(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIRSET_PIN25() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIRSET_PIN26(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIRSET_PIN26() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIRSET_PIN27(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIRSET_PIN27() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIRSET_PIN28(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIRSET_PIN28() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIRSET_PIN29(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIRSET_PIN29() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIRSET_PIN30(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIRSET_PIN30() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIRSET_PIN31(value uint32) {
	volatile.StoreUint32(&o.DIRSET.Reg, volatile.LoadUint32(&o.DIRSET.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIRSET_PIN31() uint32 {
	return (volatile.LoadUint32(&o.DIRSET.Reg) & 0x80000000) >> 31
}

// GPIO.DIRCLR: DIR clear register
func (o *GPIO_Type) SetDIRCLR_PIN0(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDIRCLR_PIN0() uint32 {
	return volatile.LoadUint32(&o.DIRCLR.Reg) & 0x1
}
func (o *GPIO_Type) SetDIRCLR_PIN1(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetDIRCLR_PIN1() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetDIRCLR_PIN2(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetDIRCLR_PIN2() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetDIRCLR_PIN3(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetDIRCLR_PIN3() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetDIRCLR_PIN4(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetDIRCLR_PIN4() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetDIRCLR_PIN5(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetDIRCLR_PIN5() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetDIRCLR_PIN6(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetDIRCLR_PIN6() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetDIRCLR_PIN7(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetDIRCLR_PIN7() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetDIRCLR_PIN8(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetDIRCLR_PIN8() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetDIRCLR_PIN9(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetDIRCLR_PIN9() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetDIRCLR_PIN10(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetDIRCLR_PIN10() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetDIRCLR_PIN11(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetDIRCLR_PIN11() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetDIRCLR_PIN12(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetDIRCLR_PIN12() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetDIRCLR_PIN13(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetDIRCLR_PIN13() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetDIRCLR_PIN14(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetDIRCLR_PIN14() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetDIRCLR_PIN15(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetDIRCLR_PIN15() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetDIRCLR_PIN16(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetDIRCLR_PIN16() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetDIRCLR_PIN17(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetDIRCLR_PIN17() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetDIRCLR_PIN18(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetDIRCLR_PIN18() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetDIRCLR_PIN19(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetDIRCLR_PIN19() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetDIRCLR_PIN20(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetDIRCLR_PIN20() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetDIRCLR_PIN21(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetDIRCLR_PIN21() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetDIRCLR_PIN22(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetDIRCLR_PIN22() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetDIRCLR_PIN23(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetDIRCLR_PIN23() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetDIRCLR_PIN24(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetDIRCLR_PIN24() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetDIRCLR_PIN25(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetDIRCLR_PIN25() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetDIRCLR_PIN26(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetDIRCLR_PIN26() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetDIRCLR_PIN27(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetDIRCLR_PIN27() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetDIRCLR_PIN28(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetDIRCLR_PIN28() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetDIRCLR_PIN29(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetDIRCLR_PIN29() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetDIRCLR_PIN30(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetDIRCLR_PIN30() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetDIRCLR_PIN31(value uint32) {
	volatile.StoreUint32(&o.DIRCLR.Reg, volatile.LoadUint32(&o.DIRCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetDIRCLR_PIN31() uint32 {
	return (volatile.LoadUint32(&o.DIRCLR.Reg) & 0x80000000) >> 31
}

// GPIO.LATCH: Latch register indicating what GPIO pins that have met the criteria set in the PIN_CNF[n].SENSE registers
func (o *GPIO_Type) SetLATCH_PIN0(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetLATCH_PIN0() uint32 {
	return volatile.LoadUint32(&o.LATCH.Reg) & 0x1
}
func (o *GPIO_Type) SetLATCH_PIN1(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetLATCH_PIN1() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetLATCH_PIN2(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x4)|value<<2)
}
func (o *GPIO_Type) GetLATCH_PIN2() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x4) >> 2
}
func (o *GPIO_Type) SetLATCH_PIN3(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x8)|value<<3)
}
func (o *GPIO_Type) GetLATCH_PIN3() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x8) >> 3
}
func (o *GPIO_Type) SetLATCH_PIN4(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x10)|value<<4)
}
func (o *GPIO_Type) GetLATCH_PIN4() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x10) >> 4
}
func (o *GPIO_Type) SetLATCH_PIN5(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x20)|value<<5)
}
func (o *GPIO_Type) GetLATCH_PIN5() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x20) >> 5
}
func (o *GPIO_Type) SetLATCH_PIN6(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x40)|value<<6)
}
func (o *GPIO_Type) GetLATCH_PIN6() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x40) >> 6
}
func (o *GPIO_Type) SetLATCH_PIN7(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x80)|value<<7)
}
func (o *GPIO_Type) GetLATCH_PIN7() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x80) >> 7
}
func (o *GPIO_Type) SetLATCH_PIN8(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x100)|value<<8)
}
func (o *GPIO_Type) GetLATCH_PIN8() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x100) >> 8
}
func (o *GPIO_Type) SetLATCH_PIN9(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x200)|value<<9)
}
func (o *GPIO_Type) GetLATCH_PIN9() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x200) >> 9
}
func (o *GPIO_Type) SetLATCH_PIN10(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x400)|value<<10)
}
func (o *GPIO_Type) GetLATCH_PIN10() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x400) >> 10
}
func (o *GPIO_Type) SetLATCH_PIN11(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x800)|value<<11)
}
func (o *GPIO_Type) GetLATCH_PIN11() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x800) >> 11
}
func (o *GPIO_Type) SetLATCH_PIN12(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x1000)|value<<12)
}
func (o *GPIO_Type) GetLATCH_PIN12() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x1000) >> 12
}
func (o *GPIO_Type) SetLATCH_PIN13(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x2000)|value<<13)
}
func (o *GPIO_Type) GetLATCH_PIN13() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x2000) >> 13
}
func (o *GPIO_Type) SetLATCH_PIN14(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x4000)|value<<14)
}
func (o *GPIO_Type) GetLATCH_PIN14() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x4000) >> 14
}
func (o *GPIO_Type) SetLATCH_PIN15(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x8000)|value<<15)
}
func (o *GPIO_Type) GetLATCH_PIN15() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x8000) >> 15
}
func (o *GPIO_Type) SetLATCH_PIN16(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x10000)|value<<16)
}
func (o *GPIO_Type) GetLATCH_PIN16() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x10000) >> 16
}
func (o *GPIO_Type) SetLATCH_PIN17(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x20000)|value<<17)
}
func (o *GPIO_Type) GetLATCH_PIN17() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x20000) >> 17
}
func (o *GPIO_Type) SetLATCH_PIN18(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x40000)|value<<18)
}
func (o *GPIO_Type) GetLATCH_PIN18() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x40000) >> 18
}
func (o *GPIO_Type) SetLATCH_PIN19(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x80000)|value<<19)
}
func (o *GPIO_Type) GetLATCH_PIN19() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x80000) >> 19
}
func (o *GPIO_Type) SetLATCH_PIN20(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x100000)|value<<20)
}
func (o *GPIO_Type) GetLATCH_PIN20() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x100000) >> 20
}
func (o *GPIO_Type) SetLATCH_PIN21(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x200000)|value<<21)
}
func (o *GPIO_Type) GetLATCH_PIN21() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x200000) >> 21
}
func (o *GPIO_Type) SetLATCH_PIN22(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x400000)|value<<22)
}
func (o *GPIO_Type) GetLATCH_PIN22() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x400000) >> 22
}
func (o *GPIO_Type) SetLATCH_PIN23(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x800000)|value<<23)
}
func (o *GPIO_Type) GetLATCH_PIN23() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x800000) >> 23
}
func (o *GPIO_Type) SetLATCH_PIN24(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x1000000)|value<<24)
}
func (o *GPIO_Type) GetLATCH_PIN24() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x1000000) >> 24
}
func (o *GPIO_Type) SetLATCH_PIN25(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x2000000)|value<<25)
}
func (o *GPIO_Type) GetLATCH_PIN25() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x2000000) >> 25
}
func (o *GPIO_Type) SetLATCH_PIN26(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x4000000)|value<<26)
}
func (o *GPIO_Type) GetLATCH_PIN26() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x4000000) >> 26
}
func (o *GPIO_Type) SetLATCH_PIN27(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x8000000)|value<<27)
}
func (o *GPIO_Type) GetLATCH_PIN27() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x8000000) >> 27
}
func (o *GPIO_Type) SetLATCH_PIN28(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x10000000)|value<<28)
}
func (o *GPIO_Type) GetLATCH_PIN28() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x10000000) >> 28
}
func (o *GPIO_Type) SetLATCH_PIN29(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x20000000)|value<<29)
}
func (o *GPIO_Type) GetLATCH_PIN29() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x20000000) >> 29
}
func (o *GPIO_Type) SetLATCH_PIN30(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x40000000)|value<<30)
}
func (o *GPIO_Type) GetLATCH_PIN30() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x40000000) >> 30
}
func (o *GPIO_Type) SetLATCH_PIN31(value uint32) {
	volatile.StoreUint32(&o.LATCH.Reg, volatile.LoadUint32(&o.LATCH.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIO_Type) GetLATCH_PIN31() uint32 {
	return (volatile.LoadUint32(&o.LATCH.Reg) & 0x80000000) >> 31
}

// GPIO.DETECTMODE: Select between default DETECT signal behaviour and LDETECT mode
func (o *GPIO_Type) SetDETECTMODE(value uint32) {
	volatile.StoreUint32(&o.DETECTMODE.Reg, volatile.LoadUint32(&o.DETECTMODE.Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetDETECTMODE() uint32 {
	return volatile.LoadUint32(&o.DETECTMODE.Reg) & 0x1
}

// GPIO.PIN_CNF: Description collection: Configuration of GPIO pins
func (o *GPIO_Type) SetPIN_CNF_DIR(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x1)|value)
}
func (o *GPIO_Type) GetPIN_CNF_DIR(idx int) uint32 {
	return volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x1
}
func (o *GPIO_Type) SetPIN_CNF_INPUT(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x2)|value<<1)
}
func (o *GPIO_Type) GetPIN_CNF_INPUT(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x2) >> 1
}
func (o *GPIO_Type) SetPIN_CNF_PULL(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0xc)|value<<2)
}
func (o *GPIO_Type) GetPIN_CNF_PULL(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0xc) >> 2
}
func (o *GPIO_Type) SetPIN_CNF_DRIVE(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x700)|value<<8)
}
func (o *GPIO_Type) GetPIN_CNF_DRIVE(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x700) >> 8
}
func (o *GPIO_Type) SetPIN_CNF_SENSE(idx int, value uint32) {
	volatile.StoreUint32(&o.PIN_CNF[idx].Reg, volatile.LoadUint32(&o.PIN_CNF[idx].Reg)&^(0x30000)|value<<16)
}
func (o *GPIO_Type) GetPIN_CNF_SENSE(idx int) uint32 {
	return (volatile.LoadUint32(&o.PIN_CNF[idx].Reg) & 0x30000) >> 16
}

// 2.4 GHz radio
type RADIO_Type struct {
	TASKS_TXEN        volatile.Register32 // 0x0
	TASKS_RXEN        volatile.Register32 // 0x4
	TASKS_START       volatile.Register32 // 0x8
	TASKS_STOP        volatile.Register32 // 0xC
	TASKS_DISABLE     volatile.Register32 // 0x10
	TASKS_RSSISTART   volatile.Register32 // 0x14
	TASKS_RSSISTOP    volatile.Register32 // 0x18
	TASKS_BCSTART     volatile.Register32 // 0x1C
	TASKS_BCSTOP      volatile.Register32 // 0x20
	TASKS_EDSTART     volatile.Register32 // 0x24
	TASKS_EDSTOP      volatile.Register32 // 0x28
	TASKS_CCASTART    volatile.Register32 // 0x2C
	TASKS_CCASTOP     volatile.Register32 // 0x30
	_                 [204]byte
	EVENTS_READY      volatile.Register32 // 0x100
	EVENTS_ADDRESS    volatile.Register32 // 0x104
	EVENTS_PAYLOAD    volatile.Register32 // 0x108
	EVENTS_END        volatile.Register32 // 0x10C
	EVENTS_DISABLED   volatile.Register32 // 0x110
	EVENTS_DEVMATCH   volatile.Register32 // 0x114
	EVENTS_DEVMISS    volatile.Register32 // 0x118
	EVENTS_RSSIEND    volatile.Register32 // 0x11C
	_                 [8]byte
	EVENTS_BCMATCH    volatile.Register32 // 0x128
	_                 [4]byte
	EVENTS_CRCOK      volatile.Register32 // 0x130
	EVENTS_CRCERROR   volatile.Register32 // 0x134
	EVENTS_FRAMESTART volatile.Register32 // 0x138
	EVENTS_EDEND      volatile.Register32 // 0x13C
	EVENTS_EDSTOPPED  volatile.Register32 // 0x140
	EVENTS_CCAIDLE    volatile.Register32 // 0x144
	EVENTS_CCABUSY    volatile.Register32 // 0x148
	EVENTS_CCASTOPPED volatile.Register32 // 0x14C
	EVENTS_RATEBOOST  volatile.Register32 // 0x150
	EVENTS_TXREADY    volatile.Register32 // 0x154
	EVENTS_RXREADY    volatile.Register32 // 0x158
	EVENTS_MHRMATCH   volatile.Register32 // 0x15C
	_                 [8]byte
	EVENTS_SYNC       volatile.Register32 // 0x168
	EVENTS_PHYEND     volatile.Register32 // 0x16C
	EVENTS_CTEPRESENT volatile.Register32 // 0x170
	_                 [140]byte
	SHORTS            volatile.Register32 // 0x200
	_                 [256]byte
	INTENSET          volatile.Register32 // 0x304
	INTENCLR          volatile.Register32 // 0x308
	_                 [244]byte
	CRCSTATUS         volatile.Register32 // 0x400
	_                 [4]byte
	RXMATCH           volatile.Register32 // 0x408
	RXCRC             volatile.Register32 // 0x40C
	DAI               volatile.Register32 // 0x410
	PDUSTAT           volatile.Register32 // 0x414
	_                 [52]byte
	CTESTATUS         volatile.Register32 // 0x44C
	_                 [8]byte
	DFESTATUS         volatile.Register32 // 0x458
	_                 [168]byte
	PACKETPTR         volatile.Register32 // 0x504
	FREQUENCY         volatile.Register32 // 0x508
	TXPOWER           volatile.Register32 // 0x50C
	MODE              volatile.Register32 // 0x510
	PCNF0             volatile.Register32 // 0x514
	PCNF1             volatile.Register32 // 0x518
	BASE0             volatile.Register32 // 0x51C
	BASE1             volatile.Register32 // 0x520
	PREFIX0           volatile.Register32 // 0x524
	PREFIX1           volatile.Register32 // 0x528
	TXADDRESS         volatile.Register32 // 0x52C
	RXADDRESSES       volatile.Register32 // 0x530
	CRCCNF            volatile.Register32 // 0x534
	CRCPOLY           volatile.Register32 // 0x538
	CRCINIT           volatile.Register32 // 0x53C
	_                 [4]byte
	TIFS              volatile.Register32 // 0x544
	RSSISAMPLE        volatile.Register32 // 0x548
	_                 [4]byte
	STATE             volatile.Register32 // 0x550
	DATAWHITEIV       volatile.Register32 // 0x554
	_                 [8]byte
	BCC               volatile.Register32 // 0x560
	_                 [156]byte
	DAB               [8]volatile.Register32 // 0x600
	DAP               [8]volatile.Register32 // 0x620
	DACNF             volatile.Register32    // 0x640
	MHRMATCHCONF      volatile.Register32    // 0x644
	MHRMATCHMAS       volatile.Register32    // 0x648
	_                 [4]byte
	MODECNF0          volatile.Register32 // 0x650
	_                 [12]byte
	SFD               volatile.Register32 // 0x660
	EDCNT             volatile.Register32 // 0x664
	EDSAMPLE          volatile.Register32 // 0x668
	CCACTRL           volatile.Register32 // 0x66C
	_                 [656]byte
	DFEMODE           volatile.Register32 // 0x900
	CTEINLINECONF     volatile.Register32 // 0x904
	_                 [8]byte
	DFECTRL1          volatile.Register32 // 0x910
	DFECTRL2          volatile.Register32 // 0x914
	_                 [16]byte
	SWITCHPATTERN     volatile.Register32  // 0x928
	CLEARPATTERN      volatile.Register32  // 0x92C
	PSEL              RADIO_PSEL_Type      // 0x930
	DFEPACKET         RADIO_DFEPACKET_Type // 0x950
	_                 [1696]byte
	POWER             volatile.Register32 // 0xFFC
}

// RADIO.TASKS_TXEN: Enable RADIO in TX mode
func (o *RADIO_Type) SetTASKS_TXEN(value uint32) {
	volatile.StoreUint32(&o.TASKS_TXEN.Reg, volatile.LoadUint32(&o.TASKS_TXEN.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_TXEN() uint32 {
	return volatile.LoadUint32(&o.TASKS_TXEN.Reg) & 0x1
}

// RADIO.TASKS_RXEN: Enable RADIO in RX mode
func (o *RADIO_Type) SetTASKS_RXEN(value uint32) {
	volatile.StoreUint32(&o.TASKS_RXEN.Reg, volatile.LoadUint32(&o.TASKS_RXEN.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_RXEN() uint32 {
	return volatile.LoadUint32(&o.TASKS_RXEN.Reg) & 0x1
}

// RADIO.TASKS_START: Start RADIO
func (o *RADIO_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// RADIO.TASKS_STOP: Stop RADIO
func (o *RADIO_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// RADIO.TASKS_DISABLE: Disable RADIO
func (o *RADIO_Type) SetTASKS_DISABLE(value uint32) {
	volatile.StoreUint32(&o.TASKS_DISABLE.Reg, volatile.LoadUint32(&o.TASKS_DISABLE.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_DISABLE() uint32 {
	return volatile.LoadUint32(&o.TASKS_DISABLE.Reg) & 0x1
}

// RADIO.TASKS_RSSISTART: Start the RSSI and take one single sample of the receive signal strength
func (o *RADIO_Type) SetTASKS_RSSISTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_RSSISTART.Reg, volatile.LoadUint32(&o.TASKS_RSSISTART.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_RSSISTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_RSSISTART.Reg) & 0x1
}

// RADIO.TASKS_RSSISTOP: Stop the RSSI measurement
func (o *RADIO_Type) SetTASKS_RSSISTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_RSSISTOP.Reg, volatile.LoadUint32(&o.TASKS_RSSISTOP.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_RSSISTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_RSSISTOP.Reg) & 0x1
}

// RADIO.TASKS_BCSTART: Start the bit counter
func (o *RADIO_Type) SetTASKS_BCSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_BCSTART.Reg, volatile.LoadUint32(&o.TASKS_BCSTART.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_BCSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_BCSTART.Reg) & 0x1
}

// RADIO.TASKS_BCSTOP: Stop the bit counter
func (o *RADIO_Type) SetTASKS_BCSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_BCSTOP.Reg, volatile.LoadUint32(&o.TASKS_BCSTOP.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_BCSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_BCSTOP.Reg) & 0x1
}

// RADIO.TASKS_EDSTART: Start the energy detect measurement used in IEEE 802.15.4 mode
func (o *RADIO_Type) SetTASKS_EDSTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_EDSTART.Reg, volatile.LoadUint32(&o.TASKS_EDSTART.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_EDSTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_EDSTART.Reg) & 0x1
}

// RADIO.TASKS_EDSTOP: Stop the energy detect measurement
func (o *RADIO_Type) SetTASKS_EDSTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_EDSTOP.Reg, volatile.LoadUint32(&o.TASKS_EDSTOP.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_EDSTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_EDSTOP.Reg) & 0x1
}

// RADIO.TASKS_CCASTART: Start the clear channel assessment used in IEEE 802.15.4 mode
func (o *RADIO_Type) SetTASKS_CCASTART(value uint32) {
	volatile.StoreUint32(&o.TASKS_CCASTART.Reg, volatile.LoadUint32(&o.TASKS_CCASTART.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_CCASTART() uint32 {
	return volatile.LoadUint32(&o.TASKS_CCASTART.Reg) & 0x1
}

// RADIO.TASKS_CCASTOP: Stop the clear channel assessment
func (o *RADIO_Type) SetTASKS_CCASTOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_CCASTOP.Reg, volatile.LoadUint32(&o.TASKS_CCASTOP.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetTASKS_CCASTOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_CCASTOP.Reg) & 0x1
}

// RADIO.EVENTS_READY: RADIO has ramped up and is ready to be started
func (o *RADIO_Type) SetEVENTS_READY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READY.Reg, volatile.LoadUint32(&o.EVENTS_READY.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_READY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READY.Reg) & 0x1
}

// RADIO.EVENTS_ADDRESS: Address sent or received
func (o *RADIO_Type) SetEVENTS_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ADDRESS.Reg, volatile.LoadUint32(&o.EVENTS_ADDRESS.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_ADDRESS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ADDRESS.Reg) & 0x1
}

// RADIO.EVENTS_PAYLOAD: Packet payload sent or received
func (o *RADIO_Type) SetEVENTS_PAYLOAD(value uint32) {
	volatile.StoreUint32(&o.EVENTS_PAYLOAD.Reg, volatile.LoadUint32(&o.EVENTS_PAYLOAD.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_PAYLOAD() uint32 {
	return volatile.LoadUint32(&o.EVENTS_PAYLOAD.Reg) & 0x1
}

// RADIO.EVENTS_END: Packet sent or received
func (o *RADIO_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// RADIO.EVENTS_DISABLED: RADIO has been disabled
func (o *RADIO_Type) SetEVENTS_DISABLED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DISABLED.Reg, volatile.LoadUint32(&o.EVENTS_DISABLED.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_DISABLED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DISABLED.Reg) & 0x1
}

// RADIO.EVENTS_DEVMATCH: A device address match occurred on the last received packet
func (o *RADIO_Type) SetEVENTS_DEVMATCH(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DEVMATCH.Reg, volatile.LoadUint32(&o.EVENTS_DEVMATCH.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_DEVMATCH() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DEVMATCH.Reg) & 0x1
}

// RADIO.EVENTS_DEVMISS: No device address match occurred on the last received packet
func (o *RADIO_Type) SetEVENTS_DEVMISS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DEVMISS.Reg, volatile.LoadUint32(&o.EVENTS_DEVMISS.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_DEVMISS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DEVMISS.Reg) & 0x1
}

// RADIO.EVENTS_RSSIEND: Sampling of receive signal strength complete
func (o *RADIO_Type) SetEVENTS_RSSIEND(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RSSIEND.Reg, volatile.LoadUint32(&o.EVENTS_RSSIEND.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_RSSIEND() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RSSIEND.Reg) & 0x1
}

// RADIO.EVENTS_BCMATCH: Bit counter reached bit count value
func (o *RADIO_Type) SetEVENTS_BCMATCH(value uint32) {
	volatile.StoreUint32(&o.EVENTS_BCMATCH.Reg, volatile.LoadUint32(&o.EVENTS_BCMATCH.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_BCMATCH() uint32 {
	return volatile.LoadUint32(&o.EVENTS_BCMATCH.Reg) & 0x1
}

// RADIO.EVENTS_CRCOK: Packet received with CRC ok
func (o *RADIO_Type) SetEVENTS_CRCOK(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CRCOK.Reg, volatile.LoadUint32(&o.EVENTS_CRCOK.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_CRCOK() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CRCOK.Reg) & 0x1
}

// RADIO.EVENTS_CRCERROR: Packet received with CRC error
func (o *RADIO_Type) SetEVENTS_CRCERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CRCERROR.Reg, volatile.LoadUint32(&o.EVENTS_CRCERROR.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_CRCERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CRCERROR.Reg) & 0x1
}

// RADIO.EVENTS_FRAMESTART: IEEE 802.15.4 length field received
func (o *RADIO_Type) SetEVENTS_FRAMESTART(value uint32) {
	volatile.StoreUint32(&o.EVENTS_FRAMESTART.Reg, volatile.LoadUint32(&o.EVENTS_FRAMESTART.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_FRAMESTART() uint32 {
	return volatile.LoadUint32(&o.EVENTS_FRAMESTART.Reg) & 0x1
}

// RADIO.EVENTS_EDEND: Sampling of energy detection complete. A new ED sample is ready for readout from the RADIO.EDSAMPLE register
func (o *RADIO_Type) SetEVENTS_EDEND(value uint32) {
	volatile.StoreUint32(&o.EVENTS_EDEND.Reg, volatile.LoadUint32(&o.EVENTS_EDEND.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_EDEND() uint32 {
	return volatile.LoadUint32(&o.EVENTS_EDEND.Reg) & 0x1
}

// RADIO.EVENTS_EDSTOPPED: The sampling of energy detection has stopped
func (o *RADIO_Type) SetEVENTS_EDSTOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_EDSTOPPED.Reg, volatile.LoadUint32(&o.EVENTS_EDSTOPPED.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_EDSTOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_EDSTOPPED.Reg) & 0x1
}

// RADIO.EVENTS_CCAIDLE: Wireless medium in idle - clear to send
func (o *RADIO_Type) SetEVENTS_CCAIDLE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CCAIDLE.Reg, volatile.LoadUint32(&o.EVENTS_CCAIDLE.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_CCAIDLE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CCAIDLE.Reg) & 0x1
}

// RADIO.EVENTS_CCABUSY: Wireless medium busy - do not send
func (o *RADIO_Type) SetEVENTS_CCABUSY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CCABUSY.Reg, volatile.LoadUint32(&o.EVENTS_CCABUSY.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_CCABUSY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CCABUSY.Reg) & 0x1
}

// RADIO.EVENTS_CCASTOPPED: The CCA has stopped
func (o *RADIO_Type) SetEVENTS_CCASTOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CCASTOPPED.Reg, volatile.LoadUint32(&o.EVENTS_CCASTOPPED.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_CCASTOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CCASTOPPED.Reg) & 0x1
}

// RADIO.EVENTS_RATEBOOST: Ble_LR CI field received, receive mode is changed from Ble_LR125Kbit to Ble_LR500Kbit.
func (o *RADIO_Type) SetEVENTS_RATEBOOST(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RATEBOOST.Reg, volatile.LoadUint32(&o.EVENTS_RATEBOOST.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_RATEBOOST() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RATEBOOST.Reg) & 0x1
}

// RADIO.EVENTS_TXREADY: RADIO has ramped up and is ready to be started TX path
func (o *RADIO_Type) SetEVENTS_TXREADY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXREADY.Reg, volatile.LoadUint32(&o.EVENTS_TXREADY.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_TXREADY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXREADY.Reg) & 0x1
}

// RADIO.EVENTS_RXREADY: RADIO has ramped up and is ready to be started RX path
func (o *RADIO_Type) SetEVENTS_RXREADY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXREADY.Reg, volatile.LoadUint32(&o.EVENTS_RXREADY.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_RXREADY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXREADY.Reg) & 0x1
}

// RADIO.EVENTS_MHRMATCH: MAC header match found
func (o *RADIO_Type) SetEVENTS_MHRMATCH(value uint32) {
	volatile.StoreUint32(&o.EVENTS_MHRMATCH.Reg, volatile.LoadUint32(&o.EVENTS_MHRMATCH.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_MHRMATCH() uint32 {
	return volatile.LoadUint32(&o.EVENTS_MHRMATCH.Reg) & 0x1
}

// RADIO.EVENTS_SYNC: Preamble indicator
func (o *RADIO_Type) SetEVENTS_SYNC(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SYNC.Reg, volatile.LoadUint32(&o.EVENTS_SYNC.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_SYNC() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SYNC.Reg) & 0x1
}

// RADIO.EVENTS_PHYEND: Generated when last bit is sent on air, or received from air
func (o *RADIO_Type) SetEVENTS_PHYEND(value uint32) {
	volatile.StoreUint32(&o.EVENTS_PHYEND.Reg, volatile.LoadUint32(&o.EVENTS_PHYEND.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_PHYEND() uint32 {
	return volatile.LoadUint32(&o.EVENTS_PHYEND.Reg) & 0x1
}

// RADIO.EVENTS_CTEPRESENT: CTE is present (early warning right after receiving CTEInfo byte)
func (o *RADIO_Type) SetEVENTS_CTEPRESENT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CTEPRESENT.Reg, volatile.LoadUint32(&o.EVENTS_CTEPRESENT.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetEVENTS_CTEPRESENT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CTEPRESENT.Reg) & 0x1
}

// RADIO.SHORTS: Shortcuts between local events and tasks
func (o *RADIO_Type) SetSHORTS_READY_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetSHORTS_READY_START() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *RADIO_Type) SetSHORTS_END_DISABLE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *RADIO_Type) GetSHORTS_END_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *RADIO_Type) SetSHORTS_DISABLED_TXEN(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *RADIO_Type) GetSHORTS_DISABLED_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *RADIO_Type) SetSHORTS_DISABLED_RXEN(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *RADIO_Type) GetSHORTS_DISABLED_RXEN() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *RADIO_Type) SetSHORTS_ADDRESS_RSSISTART(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetSHORTS_ADDRESS_RSSISTART() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}
func (o *RADIO_Type) SetSHORTS_END_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *RADIO_Type) GetSHORTS_END_START() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}
func (o *RADIO_Type) SetSHORTS_ADDRESS_BCSTART(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x40)|value<<6)
}
func (o *RADIO_Type) GetSHORTS_ADDRESS_BCSTART() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x40) >> 6
}
func (o *RADIO_Type) SetSHORTS_DISABLED_RSSISTOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x100)|value<<8)
}
func (o *RADIO_Type) GetSHORTS_DISABLED_RSSISTOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x100) >> 8
}
func (o *RADIO_Type) SetSHORTS_RXREADY_CCASTART(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x800)|value<<11)
}
func (o *RADIO_Type) GetSHORTS_RXREADY_CCASTART() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x800) >> 11
}
func (o *RADIO_Type) SetSHORTS_CCAIDLE_TXEN(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1000)|value<<12)
}
func (o *RADIO_Type) GetSHORTS_CCAIDLE_TXEN() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x1000) >> 12
}
func (o *RADIO_Type) SetSHORTS_CCABUSY_DISABLE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2000)|value<<13)
}
func (o *RADIO_Type) GetSHORTS_CCABUSY_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2000) >> 13
}
func (o *RADIO_Type) SetSHORTS_FRAMESTART_BCSTART(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4000)|value<<14)
}
func (o *RADIO_Type) GetSHORTS_FRAMESTART_BCSTART() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4000) >> 14
}
func (o *RADIO_Type) SetSHORTS_READY_EDSTART(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8000)|value<<15)
}
func (o *RADIO_Type) GetSHORTS_READY_EDSTART() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8000) >> 15
}
func (o *RADIO_Type) SetSHORTS_EDEND_DISABLE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10000)|value<<16)
}
func (o *RADIO_Type) GetSHORTS_EDEND_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10000) >> 16
}
func (o *RADIO_Type) SetSHORTS_CCAIDLE_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20000)|value<<17)
}
func (o *RADIO_Type) GetSHORTS_CCAIDLE_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20000) >> 17
}
func (o *RADIO_Type) SetSHORTS_TXREADY_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x40000)|value<<18)
}
func (o *RADIO_Type) GetSHORTS_TXREADY_START() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x40000) >> 18
}
func (o *RADIO_Type) SetSHORTS_RXREADY_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x80000)|value<<19)
}
func (o *RADIO_Type) GetSHORTS_RXREADY_START() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x80000) >> 19
}
func (o *RADIO_Type) SetSHORTS_PHYEND_DISABLE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x100000)|value<<20)
}
func (o *RADIO_Type) GetSHORTS_PHYEND_DISABLE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x100000) >> 20
}
func (o *RADIO_Type) SetSHORTS_PHYEND_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x200000)|value<<21)
}
func (o *RADIO_Type) GetSHORTS_PHYEND_START() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x200000) >> 21
}

// RADIO.INTENSET: Enable interrupt
func (o *RADIO_Type) SetINTENSET_READY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetINTENSET_READY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *RADIO_Type) SetINTENSET_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RADIO_Type) GetINTENSET_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *RADIO_Type) SetINTENSET_PAYLOAD(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *RADIO_Type) GetINTENSET_PAYLOAD() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *RADIO_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *RADIO_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *RADIO_Type) SetINTENSET_DISABLED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetINTENSET_DISABLED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *RADIO_Type) SetINTENSET_DEVMATCH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *RADIO_Type) GetINTENSET_DEVMATCH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *RADIO_Type) SetINTENSET_DEVMISS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *RADIO_Type) GetINTENSET_DEVMISS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *RADIO_Type) SetINTENSET_RSSIEND(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *RADIO_Type) GetINTENSET_RSSIEND() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *RADIO_Type) SetINTENSET_BCMATCH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *RADIO_Type) GetINTENSET_BCMATCH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *RADIO_Type) SetINTENSET_CRCOK(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *RADIO_Type) GetINTENSET_CRCOK() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *RADIO_Type) SetINTENSET_CRCERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *RADIO_Type) GetINTENSET_CRCERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *RADIO_Type) SetINTENSET_FRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *RADIO_Type) GetINTENSET_FRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *RADIO_Type) SetINTENSET_EDEND(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *RADIO_Type) GetINTENSET_EDEND() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *RADIO_Type) SetINTENSET_EDSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *RADIO_Type) GetINTENSET_EDSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *RADIO_Type) SetINTENSET_CCAIDLE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *RADIO_Type) GetINTENSET_CCAIDLE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *RADIO_Type) SetINTENSET_CCABUSY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *RADIO_Type) GetINTENSET_CCABUSY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *RADIO_Type) SetINTENSET_CCASTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *RADIO_Type) GetINTENSET_CCASTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *RADIO_Type) SetINTENSET_RATEBOOST(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *RADIO_Type) GetINTENSET_RATEBOOST() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *RADIO_Type) SetINTENSET_TXREADY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200000)|value<<21)
}
func (o *RADIO_Type) GetINTENSET_TXREADY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200000) >> 21
}
func (o *RADIO_Type) SetINTENSET_RXREADY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400000)|value<<22)
}
func (o *RADIO_Type) GetINTENSET_RXREADY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400000) >> 22
}
func (o *RADIO_Type) SetINTENSET_MHRMATCH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800000)|value<<23)
}
func (o *RADIO_Type) GetINTENSET_MHRMATCH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800000) >> 23
}
func (o *RADIO_Type) SetINTENSET_SYNC(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000000)|value<<26)
}
func (o *RADIO_Type) GetINTENSET_SYNC() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000000) >> 26
}
func (o *RADIO_Type) SetINTENSET_PHYEND(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000000)|value<<27)
}
func (o *RADIO_Type) GetINTENSET_PHYEND() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000000) >> 27
}
func (o *RADIO_Type) SetINTENSET_CTEPRESENT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000000)|value<<28)
}
func (o *RADIO_Type) GetINTENSET_CTEPRESENT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000000) >> 28
}

// RADIO.INTENCLR: Disable interrupt
func (o *RADIO_Type) SetINTENCLR_READY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetINTENCLR_READY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *RADIO_Type) SetINTENCLR_ADDRESS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RADIO_Type) GetINTENCLR_ADDRESS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *RADIO_Type) SetINTENCLR_PAYLOAD(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *RADIO_Type) GetINTENCLR_PAYLOAD() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *RADIO_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *RADIO_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *RADIO_Type) SetINTENCLR_DISABLED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetINTENCLR_DISABLED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *RADIO_Type) SetINTENCLR_DEVMATCH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *RADIO_Type) GetINTENCLR_DEVMATCH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *RADIO_Type) SetINTENCLR_DEVMISS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *RADIO_Type) GetINTENCLR_DEVMISS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *RADIO_Type) SetINTENCLR_RSSIEND(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *RADIO_Type) GetINTENCLR_RSSIEND() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *RADIO_Type) SetINTENCLR_BCMATCH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *RADIO_Type) GetINTENCLR_BCMATCH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *RADIO_Type) SetINTENCLR_CRCOK(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *RADIO_Type) GetINTENCLR_CRCOK() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *RADIO_Type) SetINTENCLR_CRCERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *RADIO_Type) GetINTENCLR_CRCERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *RADIO_Type) SetINTENCLR_FRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *RADIO_Type) GetINTENCLR_FRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *RADIO_Type) SetINTENCLR_EDEND(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *RADIO_Type) GetINTENCLR_EDEND() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *RADIO_Type) SetINTENCLR_EDSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *RADIO_Type) GetINTENCLR_EDSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *RADIO_Type) SetINTENCLR_CCAIDLE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *RADIO_Type) GetINTENCLR_CCAIDLE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *RADIO_Type) SetINTENCLR_CCABUSY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *RADIO_Type) GetINTENCLR_CCABUSY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *RADIO_Type) SetINTENCLR_CCASTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *RADIO_Type) GetINTENCLR_CCASTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *RADIO_Type) SetINTENCLR_RATEBOOST(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *RADIO_Type) GetINTENCLR_RATEBOOST() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *RADIO_Type) SetINTENCLR_TXREADY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *RADIO_Type) GetINTENCLR_TXREADY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200000) >> 21
}
func (o *RADIO_Type) SetINTENCLR_RXREADY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400000)|value<<22)
}
func (o *RADIO_Type) GetINTENCLR_RXREADY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400000) >> 22
}
func (o *RADIO_Type) SetINTENCLR_MHRMATCH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800000)|value<<23)
}
func (o *RADIO_Type) GetINTENCLR_MHRMATCH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800000) >> 23
}
func (o *RADIO_Type) SetINTENCLR_SYNC(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *RADIO_Type) GetINTENCLR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000000) >> 26
}
func (o *RADIO_Type) SetINTENCLR_PHYEND(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *RADIO_Type) GetINTENCLR_PHYEND() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000000) >> 27
}
func (o *RADIO_Type) SetINTENCLR_CTEPRESENT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *RADIO_Type) GetINTENCLR_CTEPRESENT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000000) >> 28
}

// RADIO.CRCSTATUS: CRC status
func (o *RADIO_Type) SetCRCSTATUS(value uint32) {
	volatile.StoreUint32(&o.CRCSTATUS.Reg, volatile.LoadUint32(&o.CRCSTATUS.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetCRCSTATUS() uint32 {
	return volatile.LoadUint32(&o.CRCSTATUS.Reg) & 0x1
}

// RADIO.RXMATCH: Received address
func (o *RADIO_Type) SetRXMATCH(value uint32) {
	volatile.StoreUint32(&o.RXMATCH.Reg, volatile.LoadUint32(&o.RXMATCH.Reg)&^(0x7)|value)
}
func (o *RADIO_Type) GetRXMATCH() uint32 {
	return volatile.LoadUint32(&o.RXMATCH.Reg) & 0x7
}

// RADIO.RXCRC: CRC field of previously received packet
func (o *RADIO_Type) SetRXCRC(value uint32) {
	volatile.StoreUint32(&o.RXCRC.Reg, volatile.LoadUint32(&o.RXCRC.Reg)&^(0xffffff)|value)
}
func (o *RADIO_Type) GetRXCRC() uint32 {
	return volatile.LoadUint32(&o.RXCRC.Reg) & 0xffffff
}

// RADIO.DAI: Device address match index
func (o *RADIO_Type) SetDAI(value uint32) {
	volatile.StoreUint32(&o.DAI.Reg, volatile.LoadUint32(&o.DAI.Reg)&^(0x7)|value)
}
func (o *RADIO_Type) GetDAI() uint32 {
	return volatile.LoadUint32(&o.DAI.Reg) & 0x7
}

// RADIO.PDUSTAT: Payload status
func (o *RADIO_Type) SetPDUSTAT(value uint32) {
	volatile.StoreUint32(&o.PDUSTAT.Reg, volatile.LoadUint32(&o.PDUSTAT.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetPDUSTAT() uint32 {
	return volatile.LoadUint32(&o.PDUSTAT.Reg) & 0x1
}
func (o *RADIO_Type) SetPDUSTAT_CISTAT(value uint32) {
	volatile.StoreUint32(&o.PDUSTAT.Reg, volatile.LoadUint32(&o.PDUSTAT.Reg)&^(0x6)|value<<1)
}
func (o *RADIO_Type) GetPDUSTAT_CISTAT() uint32 {
	return (volatile.LoadUint32(&o.PDUSTAT.Reg) & 0x6) >> 1
}

// RADIO.CTESTATUS: CTEInfo parsed from received packet
func (o *RADIO_Type) SetCTESTATUS_CTETIME(value uint32) {
	volatile.StoreUint32(&o.CTESTATUS.Reg, volatile.LoadUint32(&o.CTESTATUS.Reg)&^(0x1f)|value)
}
func (o *RADIO_Type) GetCTESTATUS_CTETIME() uint32 {
	return volatile.LoadUint32(&o.CTESTATUS.Reg) & 0x1f
}
func (o *RADIO_Type) SetCTESTATUS_RFU(value uint32) {
	volatile.StoreUint32(&o.CTESTATUS.Reg, volatile.LoadUint32(&o.CTESTATUS.Reg)&^(0x20)|value<<5)
}
func (o *RADIO_Type) GetCTESTATUS_RFU() uint32 {
	return (volatile.LoadUint32(&o.CTESTATUS.Reg) & 0x20) >> 5
}
func (o *RADIO_Type) SetCTESTATUS_CTETYPE(value uint32) {
	volatile.StoreUint32(&o.CTESTATUS.Reg, volatile.LoadUint32(&o.CTESTATUS.Reg)&^(0xc0)|value<<6)
}
func (o *RADIO_Type) GetCTESTATUS_CTETYPE() uint32 {
	return (volatile.LoadUint32(&o.CTESTATUS.Reg) & 0xc0) >> 6
}

// RADIO.DFESTATUS: DFE status information
func (o *RADIO_Type) SetDFESTATUS_SWITCHINGSTATE(value uint32) {
	volatile.StoreUint32(&o.DFESTATUS.Reg, volatile.LoadUint32(&o.DFESTATUS.Reg)&^(0x7)|value)
}
func (o *RADIO_Type) GetDFESTATUS_SWITCHINGSTATE() uint32 {
	return volatile.LoadUint32(&o.DFESTATUS.Reg) & 0x7
}
func (o *RADIO_Type) SetDFESTATUS_SAMPLINGSTATE(value uint32) {
	volatile.StoreUint32(&o.DFESTATUS.Reg, volatile.LoadUint32(&o.DFESTATUS.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetDFESTATUS_SAMPLINGSTATE() uint32 {
	return (volatile.LoadUint32(&o.DFESTATUS.Reg) & 0x10) >> 4
}

// RADIO.PACKETPTR: Packet pointer
func (o *RADIO_Type) SetPACKETPTR(value uint32) {
	volatile.StoreUint32(&o.PACKETPTR.Reg, value)
}
func (o *RADIO_Type) GetPACKETPTR() uint32 {
	return volatile.LoadUint32(&o.PACKETPTR.Reg)
}

// RADIO.FREQUENCY: Frequency
func (o *RADIO_Type) SetFREQUENCY(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, volatile.LoadUint32(&o.FREQUENCY.Reg)&^(0x7f)|value)
}
func (o *RADIO_Type) GetFREQUENCY() uint32 {
	return volatile.LoadUint32(&o.FREQUENCY.Reg) & 0x7f
}
func (o *RADIO_Type) SetFREQUENCY_MAP(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, volatile.LoadUint32(&o.FREQUENCY.Reg)&^(0x100)|value<<8)
}
func (o *RADIO_Type) GetFREQUENCY_MAP() uint32 {
	return (volatile.LoadUint32(&o.FREQUENCY.Reg) & 0x100) >> 8
}

// RADIO.TXPOWER: Output power
func (o *RADIO_Type) SetTXPOWER(value uint32) {
	volatile.StoreUint32(&o.TXPOWER.Reg, volatile.LoadUint32(&o.TXPOWER.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetTXPOWER() uint32 {
	return volatile.LoadUint32(&o.TXPOWER.Reg) & 0xff
}

// RADIO.MODE: Data rate and modulation
func (o *RADIO_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0xf)|value)
}
func (o *RADIO_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0xf
}

// RADIO.PCNF0: Packet configuration register 0
func (o *RADIO_Type) SetPCNF0_LFLEN(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0xf)|value)
}
func (o *RADIO_Type) GetPCNF0_LFLEN() uint32 {
	return volatile.LoadUint32(&o.PCNF0.Reg) & 0xf
}
func (o *RADIO_Type) SetPCNF0_S0LEN(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0x100)|value<<8)
}
func (o *RADIO_Type) GetPCNF0_S0LEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0x100) >> 8
}
func (o *RADIO_Type) SetPCNF0_S1LEN(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0xf0000)|value<<16)
}
func (o *RADIO_Type) GetPCNF0_S1LEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0xf0000) >> 16
}
func (o *RADIO_Type) SetPCNF0_S1INCL(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0x100000)|value<<20)
}
func (o *RADIO_Type) GetPCNF0_S1INCL() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0x100000) >> 20
}
func (o *RADIO_Type) SetPCNF0_CILEN(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0xc00000)|value<<22)
}
func (o *RADIO_Type) GetPCNF0_CILEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0xc00000) >> 22
}
func (o *RADIO_Type) SetPCNF0_PLEN(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0x3000000)|value<<24)
}
func (o *RADIO_Type) GetPCNF0_PLEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0x3000000) >> 24
}
func (o *RADIO_Type) SetPCNF0_CRCINC(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0x4000000)|value<<26)
}
func (o *RADIO_Type) GetPCNF0_CRCINC() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0x4000000) >> 26
}
func (o *RADIO_Type) SetPCNF0_TERMLEN(value uint32) {
	volatile.StoreUint32(&o.PCNF0.Reg, volatile.LoadUint32(&o.PCNF0.Reg)&^(0x60000000)|value<<29)
}
func (o *RADIO_Type) GetPCNF0_TERMLEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF0.Reg) & 0x60000000) >> 29
}

// RADIO.PCNF1: Packet configuration register 1
func (o *RADIO_Type) SetPCNF1_MAXLEN(value uint32) {
	volatile.StoreUint32(&o.PCNF1.Reg, volatile.LoadUint32(&o.PCNF1.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPCNF1_MAXLEN() uint32 {
	return volatile.LoadUint32(&o.PCNF1.Reg) & 0xff
}
func (o *RADIO_Type) SetPCNF1_STATLEN(value uint32) {
	volatile.StoreUint32(&o.PCNF1.Reg, volatile.LoadUint32(&o.PCNF1.Reg)&^(0xff00)|value<<8)
}
func (o *RADIO_Type) GetPCNF1_STATLEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF1.Reg) & 0xff00) >> 8
}
func (o *RADIO_Type) SetPCNF1_BALEN(value uint32) {
	volatile.StoreUint32(&o.PCNF1.Reg, volatile.LoadUint32(&o.PCNF1.Reg)&^(0x70000)|value<<16)
}
func (o *RADIO_Type) GetPCNF1_BALEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF1.Reg) & 0x70000) >> 16
}
func (o *RADIO_Type) SetPCNF1_ENDIAN(value uint32) {
	volatile.StoreUint32(&o.PCNF1.Reg, volatile.LoadUint32(&o.PCNF1.Reg)&^(0x1000000)|value<<24)
}
func (o *RADIO_Type) GetPCNF1_ENDIAN() uint32 {
	return (volatile.LoadUint32(&o.PCNF1.Reg) & 0x1000000) >> 24
}
func (o *RADIO_Type) SetPCNF1_WHITEEN(value uint32) {
	volatile.StoreUint32(&o.PCNF1.Reg, volatile.LoadUint32(&o.PCNF1.Reg)&^(0x2000000)|value<<25)
}
func (o *RADIO_Type) GetPCNF1_WHITEEN() uint32 {
	return (volatile.LoadUint32(&o.PCNF1.Reg) & 0x2000000) >> 25
}

// RADIO.BASE0: Base address 0
func (o *RADIO_Type) SetBASE0(value uint32) {
	volatile.StoreUint32(&o.BASE0.Reg, value)
}
func (o *RADIO_Type) GetBASE0() uint32 {
	return volatile.LoadUint32(&o.BASE0.Reg)
}

// RADIO.BASE1: Base address 1
func (o *RADIO_Type) SetBASE1(value uint32) {
	volatile.StoreUint32(&o.BASE1.Reg, value)
}
func (o *RADIO_Type) GetBASE1() uint32 {
	return volatile.LoadUint32(&o.BASE1.Reg)
}

// RADIO.PREFIX0: Prefixes bytes for logical addresses 0-3
func (o *RADIO_Type) SetPREFIX0_AP0(value uint32) {
	volatile.StoreUint32(&o.PREFIX0.Reg, volatile.LoadUint32(&o.PREFIX0.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPREFIX0_AP0() uint32 {
	return volatile.LoadUint32(&o.PREFIX0.Reg) & 0xff
}
func (o *RADIO_Type) SetPREFIX0_AP1(value uint32) {
	volatile.StoreUint32(&o.PREFIX0.Reg, volatile.LoadUint32(&o.PREFIX0.Reg)&^(0xff00)|value<<8)
}
func (o *RADIO_Type) GetPREFIX0_AP1() uint32 {
	return (volatile.LoadUint32(&o.PREFIX0.Reg) & 0xff00) >> 8
}
func (o *RADIO_Type) SetPREFIX0_AP2(value uint32) {
	volatile.StoreUint32(&o.PREFIX0.Reg, volatile.LoadUint32(&o.PREFIX0.Reg)&^(0xff0000)|value<<16)
}
func (o *RADIO_Type) GetPREFIX0_AP2() uint32 {
	return (volatile.LoadUint32(&o.PREFIX0.Reg) & 0xff0000) >> 16
}
func (o *RADIO_Type) SetPREFIX0_AP3(value uint32) {
	volatile.StoreUint32(&o.PREFIX0.Reg, volatile.LoadUint32(&o.PREFIX0.Reg)&^(0xff000000)|value<<24)
}
func (o *RADIO_Type) GetPREFIX0_AP3() uint32 {
	return (volatile.LoadUint32(&o.PREFIX0.Reg) & 0xff000000) >> 24
}

// RADIO.PREFIX1: Prefixes bytes for logical addresses 4-7
func (o *RADIO_Type) SetPREFIX1_AP4(value uint32) {
	volatile.StoreUint32(&o.PREFIX1.Reg, volatile.LoadUint32(&o.PREFIX1.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetPREFIX1_AP4() uint32 {
	return volatile.LoadUint32(&o.PREFIX1.Reg) & 0xff
}
func (o *RADIO_Type) SetPREFIX1_AP5(value uint32) {
	volatile.StoreUint32(&o.PREFIX1.Reg, volatile.LoadUint32(&o.PREFIX1.Reg)&^(0xff00)|value<<8)
}
func (o *RADIO_Type) GetPREFIX1_AP5() uint32 {
	return (volatile.LoadUint32(&o.PREFIX1.Reg) & 0xff00) >> 8
}
func (o *RADIO_Type) SetPREFIX1_AP6(value uint32) {
	volatile.StoreUint32(&o.PREFIX1.Reg, volatile.LoadUint32(&o.PREFIX1.Reg)&^(0xff0000)|value<<16)
}
func (o *RADIO_Type) GetPREFIX1_AP6() uint32 {
	return (volatile.LoadUint32(&o.PREFIX1.Reg) & 0xff0000) >> 16
}
func (o *RADIO_Type) SetPREFIX1_AP7(value uint32) {
	volatile.StoreUint32(&o.PREFIX1.Reg, volatile.LoadUint32(&o.PREFIX1.Reg)&^(0xff000000)|value<<24)
}
func (o *RADIO_Type) GetPREFIX1_AP7() uint32 {
	return (volatile.LoadUint32(&o.PREFIX1.Reg) & 0xff000000) >> 24
}

// RADIO.TXADDRESS: Transmit address select
func (o *RADIO_Type) SetTXADDRESS(value uint32) {
	volatile.StoreUint32(&o.TXADDRESS.Reg, volatile.LoadUint32(&o.TXADDRESS.Reg)&^(0x7)|value)
}
func (o *RADIO_Type) GetTXADDRESS() uint32 {
	return volatile.LoadUint32(&o.TXADDRESS.Reg) & 0x7
}

// RADIO.RXADDRESSES: Receive address select
func (o *RADIO_Type) SetRXADDRESSES_ADDR0(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR0() uint32 {
	return volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x1
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR1(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x2)|value<<1)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR1() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x2) >> 1
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR2(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x4)|value<<2)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR2() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x4) >> 2
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR3(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x8)|value<<3)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR3() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x8) >> 3
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR4(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR4() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x10) >> 4
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR5(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x20)|value<<5)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR5() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x20) >> 5
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR6(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x40)|value<<6)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR6() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x40) >> 6
}
func (o *RADIO_Type) SetRXADDRESSES_ADDR7(value uint32) {
	volatile.StoreUint32(&o.RXADDRESSES.Reg, volatile.LoadUint32(&o.RXADDRESSES.Reg)&^(0x80)|value<<7)
}
func (o *RADIO_Type) GetRXADDRESSES_ADDR7() uint32 {
	return (volatile.LoadUint32(&o.RXADDRESSES.Reg) & 0x80) >> 7
}

// RADIO.CRCCNF: CRC configuration
func (o *RADIO_Type) SetCRCCNF_LEN(value uint32) {
	volatile.StoreUint32(&o.CRCCNF.Reg, volatile.LoadUint32(&o.CRCCNF.Reg)&^(0x3)|value)
}
func (o *RADIO_Type) GetCRCCNF_LEN() uint32 {
	return volatile.LoadUint32(&o.CRCCNF.Reg) & 0x3
}
func (o *RADIO_Type) SetCRCCNF_SKIPADDR(value uint32) {
	volatile.StoreUint32(&o.CRCCNF.Reg, volatile.LoadUint32(&o.CRCCNF.Reg)&^(0x300)|value<<8)
}
func (o *RADIO_Type) GetCRCCNF_SKIPADDR() uint32 {
	return (volatile.LoadUint32(&o.CRCCNF.Reg) & 0x300) >> 8
}

// RADIO.CRCPOLY: CRC polynomial
func (o *RADIO_Type) SetCRCPOLY(value uint32) {
	volatile.StoreUint32(&o.CRCPOLY.Reg, volatile.LoadUint32(&o.CRCPOLY.Reg)&^(0xffffff)|value)
}
func (o *RADIO_Type) GetCRCPOLY() uint32 {
	return volatile.LoadUint32(&o.CRCPOLY.Reg) & 0xffffff
}

// RADIO.CRCINIT: CRC initial value
func (o *RADIO_Type) SetCRCINIT(value uint32) {
	volatile.StoreUint32(&o.CRCINIT.Reg, volatile.LoadUint32(&o.CRCINIT.Reg)&^(0xffffff)|value)
}
func (o *RADIO_Type) GetCRCINIT() uint32 {
	return volatile.LoadUint32(&o.CRCINIT.Reg) & 0xffffff
}

// RADIO.TIFS: Interframe spacing in us
func (o *RADIO_Type) SetTIFS(value uint32) {
	volatile.StoreUint32(&o.TIFS.Reg, volatile.LoadUint32(&o.TIFS.Reg)&^(0x3ff)|value)
}
func (o *RADIO_Type) GetTIFS() uint32 {
	return volatile.LoadUint32(&o.TIFS.Reg) & 0x3ff
}

// RADIO.RSSISAMPLE: RSSI sample
func (o *RADIO_Type) SetRSSISAMPLE(value uint32) {
	volatile.StoreUint32(&o.RSSISAMPLE.Reg, volatile.LoadUint32(&o.RSSISAMPLE.Reg)&^(0x7f)|value)
}
func (o *RADIO_Type) GetRSSISAMPLE() uint32 {
	return volatile.LoadUint32(&o.RSSISAMPLE.Reg) & 0x7f
}

// RADIO.STATE: Current radio state
func (o *RADIO_Type) SetSTATE(value uint32) {
	volatile.StoreUint32(&o.STATE.Reg, volatile.LoadUint32(&o.STATE.Reg)&^(0xf)|value)
}
func (o *RADIO_Type) GetSTATE() uint32 {
	return volatile.LoadUint32(&o.STATE.Reg) & 0xf
}

// RADIO.DATAWHITEIV: Data whitening initial value
func (o *RADIO_Type) SetDATAWHITEIV(value uint32) {
	volatile.StoreUint32(&o.DATAWHITEIV.Reg, volatile.LoadUint32(&o.DATAWHITEIV.Reg)&^(0x7f)|value)
}
func (o *RADIO_Type) GetDATAWHITEIV() uint32 {
	return volatile.LoadUint32(&o.DATAWHITEIV.Reg) & 0x7f
}

// RADIO.BCC: Bit counter compare
func (o *RADIO_Type) SetBCC(value uint32) {
	volatile.StoreUint32(&o.BCC.Reg, value)
}
func (o *RADIO_Type) GetBCC() uint32 {
	return volatile.LoadUint32(&o.BCC.Reg)
}

// RADIO.DAB: Description collection: Device address base segment n
func (o *RADIO_Type) SetDAB(idx int, value uint32) {
	volatile.StoreUint32(&o.DAB[idx].Reg, value)
}
func (o *RADIO_Type) GetDAB(idx int) uint32 {
	return volatile.LoadUint32(&o.DAB[idx].Reg)
}

// RADIO.DAP: Description collection: Device address prefix n
func (o *RADIO_Type) SetDAP(idx int, value uint32) {
	volatile.StoreUint32(&o.DAP[idx].Reg, volatile.LoadUint32(&o.DAP[idx].Reg)&^(0xffff)|value)
}
func (o *RADIO_Type) GetDAP(idx int) uint32 {
	return volatile.LoadUint32(&o.DAP[idx].Reg) & 0xffff
}

// RADIO.DACNF: Device address match configuration
func (o *RADIO_Type) SetDACNF_ENA0(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetDACNF_ENA0() uint32 {
	return volatile.LoadUint32(&o.DACNF.Reg) & 0x1
}
func (o *RADIO_Type) SetDACNF_ENA1(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x2)|value<<1)
}
func (o *RADIO_Type) GetDACNF_ENA1() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x2) >> 1
}
func (o *RADIO_Type) SetDACNF_ENA2(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x4)|value<<2)
}
func (o *RADIO_Type) GetDACNF_ENA2() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x4) >> 2
}
func (o *RADIO_Type) SetDACNF_ENA3(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x8)|value<<3)
}
func (o *RADIO_Type) GetDACNF_ENA3() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x8) >> 3
}
func (o *RADIO_Type) SetDACNF_ENA4(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetDACNF_ENA4() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x10) >> 4
}
func (o *RADIO_Type) SetDACNF_ENA5(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x20)|value<<5)
}
func (o *RADIO_Type) GetDACNF_ENA5() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x20) >> 5
}
func (o *RADIO_Type) SetDACNF_ENA6(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x40)|value<<6)
}
func (o *RADIO_Type) GetDACNF_ENA6() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x40) >> 6
}
func (o *RADIO_Type) SetDACNF_ENA7(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x80)|value<<7)
}
func (o *RADIO_Type) GetDACNF_ENA7() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x80) >> 7
}
func (o *RADIO_Type) SetDACNF_TXADD0(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x100)|value<<8)
}
func (o *RADIO_Type) GetDACNF_TXADD0() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x100) >> 8
}
func (o *RADIO_Type) SetDACNF_TXADD1(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x200)|value<<9)
}
func (o *RADIO_Type) GetDACNF_TXADD1() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x200) >> 9
}
func (o *RADIO_Type) SetDACNF_TXADD2(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x400)|value<<10)
}
func (o *RADIO_Type) GetDACNF_TXADD2() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x400) >> 10
}
func (o *RADIO_Type) SetDACNF_TXADD3(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x800)|value<<11)
}
func (o *RADIO_Type) GetDACNF_TXADD3() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x800) >> 11
}
func (o *RADIO_Type) SetDACNF_TXADD4(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x1000)|value<<12)
}
func (o *RADIO_Type) GetDACNF_TXADD4() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x1000) >> 12
}
func (o *RADIO_Type) SetDACNF_TXADD5(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x2000)|value<<13)
}
func (o *RADIO_Type) GetDACNF_TXADD5() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x2000) >> 13
}
func (o *RADIO_Type) SetDACNF_TXADD6(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x4000)|value<<14)
}
func (o *RADIO_Type) GetDACNF_TXADD6() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x4000) >> 14
}
func (o *RADIO_Type) SetDACNF_TXADD7(value uint32) {
	volatile.StoreUint32(&o.DACNF.Reg, volatile.LoadUint32(&o.DACNF.Reg)&^(0x8000)|value<<15)
}
func (o *RADIO_Type) GetDACNF_TXADD7() uint32 {
	return (volatile.LoadUint32(&o.DACNF.Reg) & 0x8000) >> 15
}

// RADIO.MHRMATCHCONF: Search pattern configuration
func (o *RADIO_Type) SetMHRMATCHCONF(value uint32) {
	volatile.StoreUint32(&o.MHRMATCHCONF.Reg, value)
}
func (o *RADIO_Type) GetMHRMATCHCONF() uint32 {
	return volatile.LoadUint32(&o.MHRMATCHCONF.Reg)
}

// RADIO.MHRMATCHMAS: Pattern mask
func (o *RADIO_Type) SetMHRMATCHMAS(value uint32) {
	volatile.StoreUint32(&o.MHRMATCHMAS.Reg, value)
}
func (o *RADIO_Type) GetMHRMATCHMAS() uint32 {
	return volatile.LoadUint32(&o.MHRMATCHMAS.Reg)
}

// RADIO.MODECNF0: Radio mode configuration register 0
func (o *RADIO_Type) SetMODECNF0_RU(value uint32) {
	volatile.StoreUint32(&o.MODECNF0.Reg, volatile.LoadUint32(&o.MODECNF0.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetMODECNF0_RU() uint32 {
	return volatile.LoadUint32(&o.MODECNF0.Reg) & 0x1
}
func (o *RADIO_Type) SetMODECNF0_DTX(value uint32) {
	volatile.StoreUint32(&o.MODECNF0.Reg, volatile.LoadUint32(&o.MODECNF0.Reg)&^(0x300)|value<<8)
}
func (o *RADIO_Type) GetMODECNF0_DTX() uint32 {
	return (volatile.LoadUint32(&o.MODECNF0.Reg) & 0x300) >> 8
}

// RADIO.SFD: IEEE 802.15.4 start of frame delimiter
func (o *RADIO_Type) SetSFD(value uint32) {
	volatile.StoreUint32(&o.SFD.Reg, volatile.LoadUint32(&o.SFD.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSFD() uint32 {
	return volatile.LoadUint32(&o.SFD.Reg) & 0xff
}

// RADIO.EDCNT: IEEE 802.15.4 energy detect loop count
func (o *RADIO_Type) SetEDCNT(value uint32) {
	volatile.StoreUint32(&o.EDCNT.Reg, volatile.LoadUint32(&o.EDCNT.Reg)&^(0x1fffff)|value)
}
func (o *RADIO_Type) GetEDCNT() uint32 {
	return volatile.LoadUint32(&o.EDCNT.Reg) & 0x1fffff
}

// RADIO.EDSAMPLE: IEEE 802.15.4 energy detect level
func (o *RADIO_Type) SetEDSAMPLE_EDLVL(value uint32) {
	volatile.StoreUint32(&o.EDSAMPLE.Reg, volatile.LoadUint32(&o.EDSAMPLE.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetEDSAMPLE_EDLVL() uint32 {
	return volatile.LoadUint32(&o.EDSAMPLE.Reg) & 0xff
}

// RADIO.CCACTRL: IEEE 802.15.4 clear channel assessment control
func (o *RADIO_Type) SetCCACTRL_CCAMODE(value uint32) {
	volatile.StoreUint32(&o.CCACTRL.Reg, volatile.LoadUint32(&o.CCACTRL.Reg)&^(0x7)|value)
}
func (o *RADIO_Type) GetCCACTRL_CCAMODE() uint32 {
	return volatile.LoadUint32(&o.CCACTRL.Reg) & 0x7
}
func (o *RADIO_Type) SetCCACTRL_CCAEDTHRES(value uint32) {
	volatile.StoreUint32(&o.CCACTRL.Reg, volatile.LoadUint32(&o.CCACTRL.Reg)&^(0xff00)|value<<8)
}
func (o *RADIO_Type) GetCCACTRL_CCAEDTHRES() uint32 {
	return (volatile.LoadUint32(&o.CCACTRL.Reg) & 0xff00) >> 8
}
func (o *RADIO_Type) SetCCACTRL_CCACORRTHRES(value uint32) {
	volatile.StoreUint32(&o.CCACTRL.Reg, volatile.LoadUint32(&o.CCACTRL.Reg)&^(0xff0000)|value<<16)
}
func (o *RADIO_Type) GetCCACTRL_CCACORRTHRES() uint32 {
	return (volatile.LoadUint32(&o.CCACTRL.Reg) & 0xff0000) >> 16
}
func (o *RADIO_Type) SetCCACTRL_CCACORRCNT(value uint32) {
	volatile.StoreUint32(&o.CCACTRL.Reg, volatile.LoadUint32(&o.CCACTRL.Reg)&^(0xff000000)|value<<24)
}
func (o *RADIO_Type) GetCCACTRL_CCACORRCNT() uint32 {
	return (volatile.LoadUint32(&o.CCACTRL.Reg) & 0xff000000) >> 24
}

// RADIO.DFEMODE: Whether to use Angle-of-Arrival (AOA) or Angle-of-Departure (AOD)
func (o *RADIO_Type) SetDFEMODE_DFEOPMODE(value uint32) {
	volatile.StoreUint32(&o.DFEMODE.Reg, volatile.LoadUint32(&o.DFEMODE.Reg)&^(0x3)|value)
}
func (o *RADIO_Type) GetDFEMODE_DFEOPMODE() uint32 {
	return volatile.LoadUint32(&o.DFEMODE.Reg) & 0x3
}

// RADIO.CTEINLINECONF: Configuration for CTE inline mode
func (o *RADIO_Type) SetCTEINLINECONF_CTEINLINECTRLEN(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetCTEINLINECONF_CTEINLINECTRLEN() uint32 {
	return volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0x1
}
func (o *RADIO_Type) SetCTEINLINECONF_CTEINFOINS1(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0x8)|value<<3)
}
func (o *RADIO_Type) GetCTEINLINECONF_CTEINFOINS1() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0x8) >> 3
}
func (o *RADIO_Type) SetCTEINLINECONF_CTEERRORHANDLING(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0x10)|value<<4)
}
func (o *RADIO_Type) GetCTEINLINECONF_CTEERRORHANDLING() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0x10) >> 4
}
func (o *RADIO_Type) SetCTEINLINECONF_CTETIMEVALIDRANGE(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0xc0)|value<<6)
}
func (o *RADIO_Type) GetCTEINLINECONF_CTETIMEVALIDRANGE() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0xc0) >> 6
}
func (o *RADIO_Type) SetCTEINLINECONF_CTEINLINERXMODE1US(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0x1c00)|value<<10)
}
func (o *RADIO_Type) GetCTEINLINECONF_CTEINLINERXMODE1US() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0x1c00) >> 10
}
func (o *RADIO_Type) SetCTEINLINECONF_CTEINLINERXMODE2US(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0xe000)|value<<13)
}
func (o *RADIO_Type) GetCTEINLINECONF_CTEINLINERXMODE2US() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0xe000) >> 13
}
func (o *RADIO_Type) SetCTEINLINECONF_S0CONF(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0xff0000)|value<<16)
}
func (o *RADIO_Type) GetCTEINLINECONF_S0CONF() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0xff0000) >> 16
}
func (o *RADIO_Type) SetCTEINLINECONF_S0MASK(value uint32) {
	volatile.StoreUint32(&o.CTEINLINECONF.Reg, volatile.LoadUint32(&o.CTEINLINECONF.Reg)&^(0xff000000)|value<<24)
}
func (o *RADIO_Type) GetCTEINLINECONF_S0MASK() uint32 {
	return (volatile.LoadUint32(&o.CTEINLINECONF.Reg) & 0xff000000) >> 24
}

// RADIO.DFECTRL1: Various configuration for Direction finding
func (o *RADIO_Type) SetDFECTRL1_NUMBEROF8US(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0x3f)|value)
}
func (o *RADIO_Type) GetDFECTRL1_NUMBEROF8US() uint32 {
	return volatile.LoadUint32(&o.DFECTRL1.Reg) & 0x3f
}
func (o *RADIO_Type) SetDFECTRL1_DFEINEXTENSION(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0x80)|value<<7)
}
func (o *RADIO_Type) GetDFECTRL1_DFEINEXTENSION() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0x80) >> 7
}
func (o *RADIO_Type) SetDFECTRL1_TSWITCHSPACING(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0x700)|value<<8)
}
func (o *RADIO_Type) GetDFECTRL1_TSWITCHSPACING() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0x700) >> 8
}
func (o *RADIO_Type) SetDFECTRL1_TSAMPLESPACINGREF(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0x7000)|value<<12)
}
func (o *RADIO_Type) GetDFECTRL1_TSAMPLESPACINGREF() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0x7000) >> 12
}
func (o *RADIO_Type) SetDFECTRL1_SAMPLETYPE(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0x8000)|value<<15)
}
func (o *RADIO_Type) GetDFECTRL1_SAMPLETYPE() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0x8000) >> 15
}
func (o *RADIO_Type) SetDFECTRL1_TSAMPLESPACING(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0x70000)|value<<16)
}
func (o *RADIO_Type) GetDFECTRL1_TSAMPLESPACING() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0x70000) >> 16
}
func (o *RADIO_Type) SetDFECTRL1_REPEATPATTERN(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0xf00000)|value<<20)
}
func (o *RADIO_Type) GetDFECTRL1_REPEATPATTERN() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0xf00000) >> 20
}
func (o *RADIO_Type) SetDFECTRL1_AGCBACKOFFGAIN(value uint32) {
	volatile.StoreUint32(&o.DFECTRL1.Reg, volatile.LoadUint32(&o.DFECTRL1.Reg)&^(0xf000000)|value<<24)
}
func (o *RADIO_Type) GetDFECTRL1_AGCBACKOFFGAIN() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL1.Reg) & 0xf000000) >> 24
}

// RADIO.DFECTRL2: Start offset for Direction finding
func (o *RADIO_Type) SetDFECTRL2_TSWITCHOFFSET(value uint32) {
	volatile.StoreUint32(&o.DFECTRL2.Reg, volatile.LoadUint32(&o.DFECTRL2.Reg)&^(0x1fff)|value)
}
func (o *RADIO_Type) GetDFECTRL2_TSWITCHOFFSET() uint32 {
	return volatile.LoadUint32(&o.DFECTRL2.Reg) & 0x1fff
}
func (o *RADIO_Type) SetDFECTRL2_TSAMPLEOFFSET(value uint32) {
	volatile.StoreUint32(&o.DFECTRL2.Reg, volatile.LoadUint32(&o.DFECTRL2.Reg)&^(0xfff0000)|value<<16)
}
func (o *RADIO_Type) GetDFECTRL2_TSAMPLEOFFSET() uint32 {
	return (volatile.LoadUint32(&o.DFECTRL2.Reg) & 0xfff0000) >> 16
}

// RADIO.SWITCHPATTERN: GPIO patterns to be used for each antenna
func (o *RADIO_Type) SetSWITCHPATTERN(value uint32) {
	volatile.StoreUint32(&o.SWITCHPATTERN.Reg, volatile.LoadUint32(&o.SWITCHPATTERN.Reg)&^(0xff)|value)
}
func (o *RADIO_Type) GetSWITCHPATTERN() uint32 {
	return volatile.LoadUint32(&o.SWITCHPATTERN.Reg) & 0xff
}

// RADIO.CLEARPATTERN: Clear the GPIO pattern array for antenna control
func (o *RADIO_Type) SetCLEARPATTERN(value uint32) {
	volatile.StoreUint32(&o.CLEARPATTERN.Reg, volatile.LoadUint32(&o.CLEARPATTERN.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetCLEARPATTERN() uint32 {
	return volatile.LoadUint32(&o.CLEARPATTERN.Reg) & 0x1
}

// RADIO.POWER: Peripheral power control
func (o *RADIO_Type) SetPOWER(value uint32) {
	volatile.StoreUint32(&o.POWER.Reg, volatile.LoadUint32(&o.POWER.Reg)&^(0x1)|value)
}
func (o *RADIO_Type) GetPOWER() uint32 {
	return volatile.LoadUint32(&o.POWER.Reg) & 0x1
}

// Unspecified
type RADIO_PSEL_Type struct {
	DFEGPIO [8]volatile.Register32 // 0x930
}

// DFE packet EasyDMA channel
type RADIO_DFEPACKET_Type struct {
	PTR    volatile.Register32 // 0x950
	MAXCNT volatile.Register32 // 0x954
	AMOUNT volatile.Register32 // 0x958
}

// RADIO_DFEPACKET.PTR: Data pointer
func (o *RADIO_DFEPACKET_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *RADIO_DFEPACKET_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// RADIO_DFEPACKET.MAXCNT: Maximum number of buffer words to transfer
func (o *RADIO_DFEPACKET_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x3fff)|value)
}
func (o *RADIO_DFEPACKET_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x3fff
}

// RADIO_DFEPACKET.AMOUNT: Number of samples transferred in the last transaction
func (o *RADIO_DFEPACKET_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *RADIO_DFEPACKET_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// Universal Asynchronous Receiver/Transmitter
type UART_Type struct {
	TASKS_STARTRX volatile.Register32 // 0x0
	TASKS_STOPRX  volatile.Register32 // 0x4
	TASKS_STARTTX volatile.Register32 // 0x8
	TASKS_STOPTX  volatile.Register32 // 0xC
	_             [12]byte
	TASKS_SUSPEND volatile.Register32 // 0x1C
	_             [224]byte
	EVENTS_CTS    volatile.Register32 // 0x100
	EVENTS_NCTS   volatile.Register32 // 0x104
	EVENTS_RXDRDY volatile.Register32 // 0x108
	_             [16]byte
	EVENTS_TXDRDY volatile.Register32 // 0x11C
	_             [4]byte
	EVENTS_ERROR  volatile.Register32 // 0x124
	_             [28]byte
	EVENTS_RXTO   volatile.Register32 // 0x144
	_             [184]byte
	SHORTS        volatile.Register32 // 0x200
	_             [256]byte
	INTENSET      volatile.Register32 // 0x304
	INTENCLR      volatile.Register32 // 0x308
	_             [372]byte
	ERRORSRC      volatile.Register32 // 0x480
	_             [124]byte
	ENABLE        volatile.Register32 // 0x500
	_             [4]byte
	PSEL          UART_PSEL_Type      // 0x508
	RXD           volatile.Register32 // 0x518
	TXD           volatile.Register32 // 0x51C
	_             [4]byte
	BAUDRATE      volatile.Register32 // 0x524
	_             [68]byte
	CONFIG        volatile.Register32 // 0x56C
}

// UART.TASKS_STARTRX: Start UART receiver
func (o *UART_Type) SetTASKS_STARTRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTRX.Reg, volatile.LoadUint32(&o.TASKS_STARTRX.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetTASKS_STARTRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTRX.Reg) & 0x1
}

// UART.TASKS_STOPRX: Stop UART receiver
func (o *UART_Type) SetTASKS_STOPRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOPRX.Reg, volatile.LoadUint32(&o.TASKS_STOPRX.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetTASKS_STOPRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOPRX.Reg) & 0x1
}

// UART.TASKS_STARTTX: Start UART transmitter
func (o *UART_Type) SetTASKS_STARTTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTTX.Reg, volatile.LoadUint32(&o.TASKS_STARTTX.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetTASKS_STARTTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTTX.Reg) & 0x1
}

// UART.TASKS_STOPTX: Stop UART transmitter
func (o *UART_Type) SetTASKS_STOPTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOPTX.Reg, volatile.LoadUint32(&o.TASKS_STOPTX.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetTASKS_STOPTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOPTX.Reg) & 0x1
}

// UART.TASKS_SUSPEND: Suspend UART
func (o *UART_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// UART.EVENTS_CTS: CTS is activated (set low). Clear To Send.
func (o *UART_Type) SetEVENTS_CTS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CTS.Reg, volatile.LoadUint32(&o.EVENTS_CTS.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetEVENTS_CTS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CTS.Reg) & 0x1
}

// UART.EVENTS_NCTS: CTS is deactivated (set high). Not Clear To Send.
func (o *UART_Type) SetEVENTS_NCTS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_NCTS.Reg, volatile.LoadUint32(&o.EVENTS_NCTS.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetEVENTS_NCTS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_NCTS.Reg) & 0x1
}

// UART.EVENTS_RXDRDY: Data received in RXD
func (o *UART_Type) SetEVENTS_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXDRDY.Reg, volatile.LoadUint32(&o.EVENTS_RXDRDY.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetEVENTS_RXDRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXDRDY.Reg) & 0x1
}

// UART.EVENTS_TXDRDY: Data sent from TXD
func (o *UART_Type) SetEVENTS_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXDRDY.Reg, volatile.LoadUint32(&o.EVENTS_TXDRDY.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetEVENTS_TXDRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXDRDY.Reg) & 0x1
}

// UART.EVENTS_ERROR: Error detected
func (o *UART_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// UART.EVENTS_RXTO: Receiver timeout
func (o *UART_Type) SetEVENTS_RXTO(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXTO.Reg, volatile.LoadUint32(&o.EVENTS_RXTO.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetEVENTS_RXTO() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXTO.Reg) & 0x1
}

// UART.SHORTS: Shortcuts between local events and tasks
func (o *UART_Type) SetSHORTS_CTS_STARTRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetSHORTS_CTS_STARTRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetSHORTS_NCTS_STOPRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetSHORTS_NCTS_STOPRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}

// UART.INTENSET: Enable interrupt
func (o *UART_Type) SetINTENSET_CTS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetINTENSET_CTS() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *UART_Type) SetINTENSET_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetINTENSET_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetINTENSET_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetINTENSET_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetINTENSET_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetINTENSET_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetINTENSET_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *UART_Type) GetINTENSET_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}

// UART.INTENCLR: Disable interrupt
func (o *UART_Type) SetINTENCLR_CTS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetINTENCLR_CTS() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *UART_Type) SetINTENCLR_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetINTENCLR_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetINTENCLR_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetINTENCLR_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetINTENCLR_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetINTENCLR_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetINTENCLR_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *UART_Type) GetINTENCLR_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}

// UART.ERRORSRC: Error source
func (o *UART_Type) SetERRORSRC_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetERRORSRC_OVERRUN() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *UART_Type) SetERRORSRC_PARITY(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetERRORSRC_PARITY() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetERRORSRC_FRAMING(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetERRORSRC_FRAMING() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetERRORSRC_BREAK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetERRORSRC_BREAK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x8) >> 3
}

// UART.ENABLE: Enable UART
func (o *UART_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *UART_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// UART.RXD: RXD register
func (o *UART_Type) SetRXD(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetRXD() uint32 {
	return volatile.LoadUint32(&o.RXD.Reg) & 0xff
}

// UART.TXD: TXD register
func (o *UART_Type) SetTXD(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetTXD() uint32 {
	return volatile.LoadUint32(&o.TXD.Reg) & 0xff
}

// UART.BAUDRATE: Baud rate. Accuracy depends on the HFCLK source selected.
func (o *UART_Type) SetBAUDRATE(value uint32) {
	volatile.StoreUint32(&o.BAUDRATE.Reg, value)
}
func (o *UART_Type) GetBAUDRATE() uint32 {
	return volatile.LoadUint32(&o.BAUDRATE.Reg)
}

// UART.CONFIG: Configuration of parity and hardware flow control
func (o *UART_Type) SetCONFIG_HWFC(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetCONFIG_HWFC() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *UART_Type) SetCONFIG_PARITY(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xe)|value<<1)
}
func (o *UART_Type) GetCONFIG_PARITY() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xe) >> 1
}
func (o *UART_Type) SetCONFIG_STOP(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetCONFIG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetCONFIG_PARITYTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetCONFIG_PARITYTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100) >> 8
}

// Unspecified
type UART_PSEL_Type struct {
	RTS volatile.Register32 // 0x508
	TXD volatile.Register32 // 0x50C
	CTS volatile.Register32 // 0x510
	RXD volatile.Register32 // 0x514
}

// UART_PSEL.RTS: Pin select for RTS
func (o *UART_PSEL_Type) SetRTS_PIN(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x1f)|value)
}
func (o *UART_PSEL_Type) GetRTS_PIN() uint32 {
	return volatile.LoadUint32(&o.RTS.Reg) & 0x1f
}
func (o *UART_PSEL_Type) SetRTS_PORT(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x20)|value<<5)
}
func (o *UART_PSEL_Type) GetRTS_PORT() uint32 {
	return (volatile.LoadUint32(&o.RTS.Reg) & 0x20) >> 5
}
func (o *UART_PSEL_Type) SetRTS_CONNECT(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UART_PSEL_Type) GetRTS_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.RTS.Reg) & 0x80000000) >> 31
}

// UART_PSEL.TXD: Pin select for TXD
func (o *UART_PSEL_Type) SetTXD_PIN(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x1f)|value)
}
func (o *UART_PSEL_Type) GetTXD_PIN() uint32 {
	return volatile.LoadUint32(&o.TXD.Reg) & 0x1f
}
func (o *UART_PSEL_Type) SetTXD_PORT(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x20)|value<<5)
}
func (o *UART_PSEL_Type) GetTXD_PORT() uint32 {
	return (volatile.LoadUint32(&o.TXD.Reg) & 0x20) >> 5
}
func (o *UART_PSEL_Type) SetTXD_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x80000000)|value<<31)
}
func (o *UART_PSEL_Type) GetTXD_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TXD.Reg) & 0x80000000) >> 31
}

// UART_PSEL.CTS: Pin select for CTS
func (o *UART_PSEL_Type) SetCTS_PIN(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x1f)|value)
}
func (o *UART_PSEL_Type) GetCTS_PIN() uint32 {
	return volatile.LoadUint32(&o.CTS.Reg) & 0x1f
}
func (o *UART_PSEL_Type) SetCTS_PORT(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x20)|value<<5)
}
func (o *UART_PSEL_Type) GetCTS_PORT() uint32 {
	return (volatile.LoadUint32(&o.CTS.Reg) & 0x20) >> 5
}
func (o *UART_PSEL_Type) SetCTS_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UART_PSEL_Type) GetCTS_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CTS.Reg) & 0x80000000) >> 31
}

// UART_PSEL.RXD: Pin select for RXD
func (o *UART_PSEL_Type) SetRXD_PIN(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x1f)|value)
}
func (o *UART_PSEL_Type) GetRXD_PIN() uint32 {
	return volatile.LoadUint32(&o.RXD.Reg) & 0x1f
}
func (o *UART_PSEL_Type) SetRXD_PORT(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x20)|value<<5)
}
func (o *UART_PSEL_Type) GetRXD_PORT() uint32 {
	return (volatile.LoadUint32(&o.RXD.Reg) & 0x20) >> 5
}
func (o *UART_PSEL_Type) SetRXD_CONNECT(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x80000000)|value<<31)
}
func (o *UART_PSEL_Type) GetRXD_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.RXD.Reg) & 0x80000000) >> 31
}

// UART with EasyDMA 0
type UARTE_Type struct {
	TASKS_STARTRX    volatile.Register32 // 0x0
	TASKS_STOPRX     volatile.Register32 // 0x4
	TASKS_STARTTX    volatile.Register32 // 0x8
	TASKS_STOPTX     volatile.Register32 // 0xC
	_                [28]byte
	TASKS_FLUSHRX    volatile.Register32 // 0x2C
	_                [208]byte
	EVENTS_CTS       volatile.Register32 // 0x100
	EVENTS_NCTS      volatile.Register32 // 0x104
	EVENTS_RXDRDY    volatile.Register32 // 0x108
	_                [4]byte
	EVENTS_ENDRX     volatile.Register32 // 0x110
	_                [8]byte
	EVENTS_TXDRDY    volatile.Register32 // 0x11C
	EVENTS_ENDTX     volatile.Register32 // 0x120
	EVENTS_ERROR     volatile.Register32 // 0x124
	_                [28]byte
	EVENTS_RXTO      volatile.Register32 // 0x144
	_                [4]byte
	EVENTS_RXSTARTED volatile.Register32 // 0x14C
	EVENTS_TXSTARTED volatile.Register32 // 0x150
	_                [4]byte
	EVENTS_TXSTOPPED volatile.Register32 // 0x158
	_                [164]byte
	SHORTS           volatile.Register32 // 0x200
	_                [252]byte
	INTEN            volatile.Register32 // 0x300
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [372]byte
	ERRORSRC         volatile.Register32 // 0x480
	_                [124]byte
	ENABLE           volatile.Register32 // 0x500
	_                [4]byte
	PSEL             UARTE_PSEL_Type // 0x508
	_                [12]byte
	BAUDRATE         volatile.Register32 // 0x524
	_                [12]byte
	RXD              UARTE_RXD_Type // 0x534
	_                [4]byte
	TXD              UARTE_TXD_Type // 0x544
	_                [28]byte
	CONFIG           volatile.Register32 // 0x56C
}

// UARTE.TASKS_STARTRX: Start UART receiver
func (o *UARTE_Type) SetTASKS_STARTRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTRX.Reg, volatile.LoadUint32(&o.TASKS_STARTRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STARTRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTRX.Reg) & 0x1
}

// UARTE.TASKS_STOPRX: Stop UART receiver
func (o *UARTE_Type) SetTASKS_STOPRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOPRX.Reg, volatile.LoadUint32(&o.TASKS_STOPRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STOPRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOPRX.Reg) & 0x1
}

// UARTE.TASKS_STARTTX: Start UART transmitter
func (o *UARTE_Type) SetTASKS_STARTTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTTX.Reg, volatile.LoadUint32(&o.TASKS_STARTTX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STARTTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTTX.Reg) & 0x1
}

// UARTE.TASKS_STOPTX: Stop UART transmitter
func (o *UARTE_Type) SetTASKS_STOPTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOPTX.Reg, volatile.LoadUint32(&o.TASKS_STOPTX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_STOPTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOPTX.Reg) & 0x1
}

// UARTE.TASKS_FLUSHRX: Flush RX FIFO into RX buffer
func (o *UARTE_Type) SetTASKS_FLUSHRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_FLUSHRX.Reg, volatile.LoadUint32(&o.TASKS_FLUSHRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetTASKS_FLUSHRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_FLUSHRX.Reg) & 0x1
}

// UARTE.EVENTS_CTS: CTS is activated (set low). Clear To Send.
func (o *UARTE_Type) SetEVENTS_CTS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CTS.Reg, volatile.LoadUint32(&o.EVENTS_CTS.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_CTS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CTS.Reg) & 0x1
}

// UARTE.EVENTS_NCTS: CTS is deactivated (set high). Not Clear To Send.
func (o *UARTE_Type) SetEVENTS_NCTS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_NCTS.Reg, volatile.LoadUint32(&o.EVENTS_NCTS.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_NCTS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_NCTS.Reg) & 0x1
}

// UARTE.EVENTS_RXDRDY: Data received in RXD (but potentially not yet transferred to Data RAM)
func (o *UARTE_Type) SetEVENTS_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXDRDY.Reg, volatile.LoadUint32(&o.EVENTS_RXDRDY.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_RXDRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXDRDY.Reg) & 0x1
}

// UARTE.EVENTS_ENDRX: Receive buffer is filled up
func (o *UARTE_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// UARTE.EVENTS_TXDRDY: Data sent from TXD
func (o *UARTE_Type) SetEVENTS_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXDRDY.Reg, volatile.LoadUint32(&o.EVENTS_TXDRDY.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_TXDRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXDRDY.Reg) & 0x1
}

// UARTE.EVENTS_ENDTX: Last TX byte transmitted
func (o *UARTE_Type) SetEVENTS_ENDTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDTX.Reg, volatile.LoadUint32(&o.EVENTS_ENDTX.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_ENDTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDTX.Reg) & 0x1
}

// UARTE.EVENTS_ERROR: Error detected
func (o *UARTE_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// UARTE.EVENTS_RXTO: Receiver timeout
func (o *UARTE_Type) SetEVENTS_RXTO(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXTO.Reg, volatile.LoadUint32(&o.EVENTS_RXTO.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_RXTO() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXTO.Reg) & 0x1
}

// UARTE.EVENTS_RXSTARTED: UART receiver has started
func (o *UARTE_Type) SetEVENTS_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_RXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg) & 0x1
}

// UARTE.EVENTS_TXSTARTED: UART transmitter has started
func (o *UARTE_Type) SetEVENTS_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_TXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg) & 0x1
}

// UARTE.EVENTS_TXSTOPPED: Transmitter stopped
func (o *UARTE_Type) SetEVENTS_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTOPPED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTOPPED.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetEVENTS_TXSTOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTOPPED.Reg) & 0x1
}

// UARTE.SHORTS: Shortcuts between local events and tasks
func (o *UARTE_Type) SetSHORTS_ENDRX_STARTRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_Type) GetSHORTS_ENDRX_STARTRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}
func (o *UARTE_Type) SetSHORTS_ENDRX_STOPRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x40)|value<<6)
}
func (o *UARTE_Type) GetSHORTS_ENDRX_STOPRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x40) >> 6
}

// UARTE.INTEN: Enable or disable interrupt
func (o *UARTE_Type) SetINTEN_CTS(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetINTEN_CTS() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *UARTE_Type) SetINTEN_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetINTEN_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetINTEN_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetINTEN_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetINTEN_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetINTEN_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetINTEN_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *UARTE_Type) GetINTEN_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *UARTE_Type) SetINTEN_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetINTEN_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *UARTE_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *UARTE_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *UARTE_Type) SetINTEN_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20000)|value<<17)
}
func (o *UARTE_Type) GetINTEN_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20000) >> 17
}
func (o *UARTE_Type) SetINTEN_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *UARTE_Type) GetINTEN_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *UARTE_Type) SetINTEN_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *UARTE_Type) GetINTEN_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *UARTE_Type) SetINTEN_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400000)|value<<22)
}
func (o *UARTE_Type) GetINTEN_TXSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400000) >> 22
}

// UARTE.INTENSET: Enable interrupt
func (o *UARTE_Type) SetINTENSET_CTS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetINTENSET_CTS() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *UARTE_Type) SetINTENSET_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetINTENSET_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetINTENSET_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetINTENSET_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetINTENSET_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *UARTE_Type) GetINTENSET_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *UARTE_Type) SetINTENSET_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetINTENSET_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *UARTE_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *UARTE_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *UARTE_Type) SetINTENSET_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *UARTE_Type) GetINTENSET_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *UARTE_Type) SetINTENSET_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *UARTE_Type) GetINTENSET_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *UARTE_Type) SetINTENSET_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *UARTE_Type) GetINTENSET_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *UARTE_Type) SetINTENSET_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400000)|value<<22)
}
func (o *UARTE_Type) GetINTENSET_TXSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400000) >> 22
}

// UARTE.INTENCLR: Disable interrupt
func (o *UARTE_Type) SetINTENCLR_CTS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetINTENCLR_CTS() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *UARTE_Type) SetINTENCLR_NCTS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetINTENCLR_NCTS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetINTENCLR_RXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetINTENCLR_RXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetINTENCLR_TXDRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *UARTE_Type) GetINTENCLR_TXDRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *UARTE_Type) SetINTENCLR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetINTENCLR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *UARTE_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *UARTE_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *UARTE_Type) SetINTENCLR_RXTO(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *UARTE_Type) GetINTENCLR_RXTO() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *UARTE_Type) SetINTENCLR_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *UARTE_Type) GetINTENCLR_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *UARTE_Type) SetINTENCLR_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *UARTE_Type) GetINTENCLR_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *UARTE_Type) SetINTENCLR_TXSTOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400000)|value<<22)
}
func (o *UARTE_Type) GetINTENCLR_TXSTOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400000) >> 22
}

// UARTE.ERRORSRC: Error source Note : this register is read / write one to clear.
func (o *UARTE_Type) SetERRORSRC_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetERRORSRC_OVERRUN() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *UARTE_Type) SetERRORSRC_PARITY(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x2)|value<<1)
}
func (o *UARTE_Type) GetERRORSRC_PARITY() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x2) >> 1
}
func (o *UARTE_Type) SetERRORSRC_FRAMING(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *UARTE_Type) GetERRORSRC_FRAMING() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}
func (o *UARTE_Type) SetERRORSRC_BREAK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x8)|value<<3)
}
func (o *UARTE_Type) GetERRORSRC_BREAK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x8) >> 3
}

// UARTE.ENABLE: Enable UART
func (o *UARTE_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *UARTE_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// UARTE.BAUDRATE: Baud rate. Accuracy depends on the HFCLK source selected.
func (o *UARTE_Type) SetBAUDRATE(value uint32) {
	volatile.StoreUint32(&o.BAUDRATE.Reg, value)
}
func (o *UARTE_Type) GetBAUDRATE() uint32 {
	return volatile.LoadUint32(&o.BAUDRATE.Reg)
}

// UARTE.CONFIG: Configuration of parity and hardware flow control
func (o *UARTE_Type) SetCONFIG_HWFC(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *UARTE_Type) GetCONFIG_HWFC() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *UARTE_Type) SetCONFIG_PARITY(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0xe)|value<<1)
}
func (o *UARTE_Type) GetCONFIG_PARITY() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0xe) >> 1
}
func (o *UARTE_Type) SetCONFIG_STOP(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x10)|value<<4)
}
func (o *UARTE_Type) GetCONFIG_STOP() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x10) >> 4
}
func (o *UARTE_Type) SetCONFIG_PARITYTYPE(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100)|value<<8)
}
func (o *UARTE_Type) GetCONFIG_PARITYTYPE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100) >> 8
}

// Unspecified
type UARTE_PSEL_Type struct {
	RTS volatile.Register32 // 0x508
	TXD volatile.Register32 // 0x50C
	CTS volatile.Register32 // 0x510
	RXD volatile.Register32 // 0x514
}

// UARTE_PSEL.RTS: Pin select for RTS signal
func (o *UARTE_PSEL_Type) SetRTS_PIN(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetRTS_PIN() uint32 {
	return volatile.LoadUint32(&o.RTS.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetRTS_PORT(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_PSEL_Type) GetRTS_PORT() uint32 {
	return (volatile.LoadUint32(&o.RTS.Reg) & 0x20) >> 5
}
func (o *UARTE_PSEL_Type) SetRTS_CONNECT(value uint32) {
	volatile.StoreUint32(&o.RTS.Reg, volatile.LoadUint32(&o.RTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetRTS_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.RTS.Reg) & 0x80000000) >> 31
}

// UARTE_PSEL.TXD: Pin select for TXD signal
func (o *UARTE_PSEL_Type) SetTXD_PIN(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetTXD_PIN() uint32 {
	return volatile.LoadUint32(&o.TXD.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetTXD_PORT(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_PSEL_Type) GetTXD_PORT() uint32 {
	return (volatile.LoadUint32(&o.TXD.Reg) & 0x20) >> 5
}
func (o *UARTE_PSEL_Type) SetTXD_CONNECT(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetTXD_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.TXD.Reg) & 0x80000000) >> 31
}

// UARTE_PSEL.CTS: Pin select for CTS signal
func (o *UARTE_PSEL_Type) SetCTS_PIN(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetCTS_PIN() uint32 {
	return volatile.LoadUint32(&o.CTS.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetCTS_PORT(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_PSEL_Type) GetCTS_PORT() uint32 {
	return (volatile.LoadUint32(&o.CTS.Reg) & 0x20) >> 5
}
func (o *UARTE_PSEL_Type) SetCTS_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CTS.Reg, volatile.LoadUint32(&o.CTS.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetCTS_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CTS.Reg) & 0x80000000) >> 31
}

// UARTE_PSEL.RXD: Pin select for RXD signal
func (o *UARTE_PSEL_Type) SetRXD_PIN(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x1f)|value)
}
func (o *UARTE_PSEL_Type) GetRXD_PIN() uint32 {
	return volatile.LoadUint32(&o.RXD.Reg) & 0x1f
}
func (o *UARTE_PSEL_Type) SetRXD_PORT(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x20)|value<<5)
}
func (o *UARTE_PSEL_Type) GetRXD_PORT() uint32 {
	return (volatile.LoadUint32(&o.RXD.Reg) & 0x20) >> 5
}
func (o *UARTE_PSEL_Type) SetRXD_CONNECT(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0x80000000)|value<<31)
}
func (o *UARTE_PSEL_Type) GetRXD_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.RXD.Reg) & 0x80000000) >> 31
}

// RXD EasyDMA channel
type UARTE_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
}

// UARTE_RXD.PTR: Data pointer
func (o *UARTE_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *UARTE_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// UARTE_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *UARTE_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *UARTE_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// UARTE_RXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *UARTE_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *UARTE_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TXD EasyDMA channel
type UARTE_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
}

// UARTE_TXD.PTR: Data pointer
func (o *UARTE_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *UARTE_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// UARTE_TXD.MAXCNT: Maximum number of bytes in transmit buffer
func (o *UARTE_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *UARTE_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// UARTE_TXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *UARTE_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *UARTE_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// Serial Peripheral Interface 0
type SPI_Type struct {
	_            [264]byte
	EVENTS_READY volatile.Register32 // 0x108
	_            [504]byte
	INTENSET     volatile.Register32 // 0x304
	INTENCLR     volatile.Register32 // 0x308
	_            [500]byte
	ENABLE       volatile.Register32 // 0x500
	_            [4]byte
	PSEL         SPI_PSEL_Type // 0x508
	_            [4]byte
	RXD          volatile.Register32 // 0x518
	TXD          volatile.Register32 // 0x51C
	_            [4]byte
	FREQUENCY    volatile.Register32 // 0x524
	_            [44]byte
	CONFIG       volatile.Register32 // 0x554
}

// SPI.EVENTS_READY: TXD byte sent and RXD byte received
func (o *SPI_Type) SetEVENTS_READY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READY.Reg, volatile.LoadUint32(&o.EVENTS_READY.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetEVENTS_READY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READY.Reg) & 0x1
}

// SPI.INTENSET: Enable interrupt
func (o *SPI_Type) SetINTENSET_READY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetINTENSET_READY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// SPI.INTENCLR: Disable interrupt
func (o *SPI_Type) SetINTENCLR_READY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetINTENCLR_READY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// SPI.ENABLE: Enable SPI
func (o *SPI_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *SPI_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// SPI.RXD: RXD register
func (o *SPI_Type) SetRXD(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetRXD() uint32 {
	return volatile.LoadUint32(&o.RXD.Reg) & 0xff
}

// SPI.TXD: TXD register
func (o *SPI_Type) SetTXD(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0xff)|value)
}
func (o *SPI_Type) GetTXD() uint32 {
	return volatile.LoadUint32(&o.TXD.Reg) & 0xff
}

// SPI.FREQUENCY: SPI frequency. Accuracy depends on the HFCLK source selected.
func (o *SPI_Type) SetFREQUENCY(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, value)
}
func (o *SPI_Type) GetFREQUENCY() uint32 {
	return volatile.LoadUint32(&o.FREQUENCY.Reg)
}

// SPI.CONFIG: Configuration register
func (o *SPI_Type) SetCONFIG_ORDER(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCONFIG_ORDER() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SPI_Type) SetCONFIG_CPHA(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCONFIG_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCONFIG_CPOL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCONFIG_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x4) >> 2
}

// Unspecified
type SPI_PSEL_Type struct {
	SCK  volatile.Register32 // 0x508
	MOSI volatile.Register32 // 0x50C
	MISO volatile.Register32 // 0x510
}

// SPI_PSEL.SCK: Pin select for SCK
func (o *SPI_PSEL_Type) SetSCK_PIN(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x1f)|value)
}
func (o *SPI_PSEL_Type) GetSCK_PIN() uint32 {
	return volatile.LoadUint32(&o.SCK.Reg) & 0x1f
}
func (o *SPI_PSEL_Type) SetSCK_PORT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x20)|value<<5)
}
func (o *SPI_PSEL_Type) GetSCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x20) >> 5
}
func (o *SPI_PSEL_Type) SetSCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_PSEL_Type) GetSCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x80000000) >> 31
}

// SPI_PSEL.MOSI: Pin select for MOSI signal
func (o *SPI_PSEL_Type) SetMOSI_PIN(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x1f)|value)
}
func (o *SPI_PSEL_Type) GetMOSI_PIN() uint32 {
	return volatile.LoadUint32(&o.MOSI.Reg) & 0x1f
}
func (o *SPI_PSEL_Type) SetMOSI_PORT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x20)|value<<5)
}
func (o *SPI_PSEL_Type) GetMOSI_PORT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x20) >> 5
}
func (o *SPI_PSEL_Type) SetMOSI_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_PSEL_Type) GetMOSI_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x80000000) >> 31
}

// SPI_PSEL.MISO: Pin select for MISO signal
func (o *SPI_PSEL_Type) SetMISO_PIN(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x1f)|value)
}
func (o *SPI_PSEL_Type) GetMISO_PIN() uint32 {
	return volatile.LoadUint32(&o.MISO.Reg) & 0x1f
}
func (o *SPI_PSEL_Type) SetMISO_PORT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x20)|value<<5)
}
func (o *SPI_PSEL_Type) GetMISO_PORT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x20) >> 5
}
func (o *SPI_PSEL_Type) SetMISO_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x80000000)|value<<31)
}
func (o *SPI_PSEL_Type) GetMISO_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x80000000) >> 31
}

// Serial Peripheral Interface Master with EasyDMA 0
type SPIM_Type struct {
	_              [16]byte
	TASKS_START    volatile.Register32 // 0x10
	TASKS_STOP     volatile.Register32 // 0x14
	_              [4]byte
	TASKS_SUSPEND  volatile.Register32 // 0x1C
	TASKS_RESUME   volatile.Register32 // 0x20
	_              [224]byte
	EVENTS_STOPPED volatile.Register32 // 0x104
	_              [8]byte
	EVENTS_ENDRX   volatile.Register32 // 0x110
	_              [4]byte
	EVENTS_END     volatile.Register32 // 0x118
	_              [4]byte
	EVENTS_ENDTX   volatile.Register32 // 0x120
	_              [40]byte
	EVENTS_STARTED volatile.Register32 // 0x14C
	_              [176]byte
	SHORTS         volatile.Register32 // 0x200
	_              [256]byte
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [244]byte
	STALLSTAT      volatile.Register32 // 0x400
	_              [252]byte
	ENABLE         volatile.Register32 // 0x500
	_              [4]byte
	PSEL           SPIM_PSEL_Type // 0x508
	_              [12]byte
	FREQUENCY      volatile.Register32 // 0x524
	_              [12]byte
	RXD            SPIM_RXD_Type       // 0x534
	TXD            SPIM_TXD_Type       // 0x544
	CONFIG         volatile.Register32 // 0x554
	_              [8]byte
	IFTIMING       SPIM_IFTIMING_Type  // 0x560
	CSNPOL         volatile.Register32 // 0x568
	PSELDCX        volatile.Register32 // 0x56C
	DCXCNT         volatile.Register32 // 0x570
	_              [76]byte
	ORC            volatile.Register32 // 0x5C0
}

// SPIM.TASKS_START: Start SPI transaction
func (o *SPIM_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// SPIM.TASKS_STOP: Stop SPI transaction
func (o *SPIM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// SPIM.TASKS_SUSPEND: Suspend SPI transaction
func (o *SPIM_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// SPIM.TASKS_RESUME: Resume SPI transaction
func (o *SPIM_Type) SetTASKS_RESUME(value uint32) {
	volatile.StoreUint32(&o.TASKS_RESUME.Reg, volatile.LoadUint32(&o.TASKS_RESUME.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetTASKS_RESUME() uint32 {
	return volatile.LoadUint32(&o.TASKS_RESUME.Reg) & 0x1
}

// SPIM.EVENTS_STOPPED: SPI transaction has stopped
func (o *SPIM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// SPIM.EVENTS_ENDRX: End of RXD buffer reached
func (o *SPIM_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// SPIM.EVENTS_END: End of RXD buffer and TXD buffer reached
func (o *SPIM_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// SPIM.EVENTS_ENDTX: End of TXD buffer reached
func (o *SPIM_Type) SetEVENTS_ENDTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDTX.Reg, volatile.LoadUint32(&o.EVENTS_ENDTX.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_ENDTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDTX.Reg) & 0x1
}

// SPIM.EVENTS_STARTED: Transaction started
func (o *SPIM_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// SPIM.SHORTS: Shortcuts between local events and tasks
func (o *SPIM_Type) SetSHORTS_END_START(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20000)|value<<17)
}
func (o *SPIM_Type) GetSHORTS_END_START() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20000) >> 17
}

// SPIM.INTENSET: Enable interrupt
func (o *SPIM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SPIM_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SPIM_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SPIM_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *SPIM_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *SPIM_Type) SetINTENSET_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *SPIM_Type) GetINTENSET_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *SPIM_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *SPIM_Type) GetINTENSET_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}

// SPIM.INTENCLR: Disable interrupt
func (o *SPIM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SPIM_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SPIM_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SPIM_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *SPIM_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *SPIM_Type) SetINTENCLR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *SPIM_Type) GetINTENCLR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *SPIM_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *SPIM_Type) GetINTENCLR_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}

// SPIM.STALLSTAT: Stall status for EasyDMA RAM accesses. The fields in this register is set to STALL by hardware whenever a stall occurres and can be cleared (set to NOSTALL) by the CPU.
func (o *SPIM_Type) SetSTALLSTAT_TX(value uint32) {
	volatile.StoreUint32(&o.STALLSTAT.Reg, volatile.LoadUint32(&o.STALLSTAT.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetSTALLSTAT_TX() uint32 {
	return volatile.LoadUint32(&o.STALLSTAT.Reg) & 0x1
}
func (o *SPIM_Type) SetSTALLSTAT_RX(value uint32) {
	volatile.StoreUint32(&o.STALLSTAT.Reg, volatile.LoadUint32(&o.STALLSTAT.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetSTALLSTAT_RX() uint32 {
	return (volatile.LoadUint32(&o.STALLSTAT.Reg) & 0x2) >> 1
}

// SPIM.ENABLE: Enable SPIM
func (o *SPIM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// SPIM.FREQUENCY: SPI frequency. Accuracy depends on the HFCLK source selected.
func (o *SPIM_Type) SetFREQUENCY(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, value)
}
func (o *SPIM_Type) GetFREQUENCY() uint32 {
	return volatile.LoadUint32(&o.FREQUENCY.Reg)
}

// SPIM.CONFIG: Configuration register
func (o *SPIM_Type) SetCONFIG_ORDER(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetCONFIG_ORDER() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SPIM_Type) SetCONFIG_CPHA(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *SPIM_Type) GetCONFIG_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}
func (o *SPIM_Type) SetCONFIG_CPOL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x4)|value<<2)
}
func (o *SPIM_Type) GetCONFIG_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x4) >> 2
}

// SPIM.CSNPOL: Polarity of CSN output
func (o *SPIM_Type) SetCSNPOL(value uint32) {
	volatile.StoreUint32(&o.CSNPOL.Reg, volatile.LoadUint32(&o.CSNPOL.Reg)&^(0x1)|value)
}
func (o *SPIM_Type) GetCSNPOL() uint32 {
	return volatile.LoadUint32(&o.CSNPOL.Reg) & 0x1
}

// SPIM.PSELDCX: Pin select for DCX signal
func (o *SPIM_Type) SetPSELDCX_PIN(value uint32) {
	volatile.StoreUint32(&o.PSELDCX.Reg, volatile.LoadUint32(&o.PSELDCX.Reg)&^(0x1f)|value)
}
func (o *SPIM_Type) GetPSELDCX_PIN() uint32 {
	return volatile.LoadUint32(&o.PSELDCX.Reg) & 0x1f
}
func (o *SPIM_Type) SetPSELDCX_PORT(value uint32) {
	volatile.StoreUint32(&o.PSELDCX.Reg, volatile.LoadUint32(&o.PSELDCX.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_Type) GetPSELDCX_PORT() uint32 {
	return (volatile.LoadUint32(&o.PSELDCX.Reg) & 0x20) >> 5
}
func (o *SPIM_Type) SetPSELDCX_CONNECT(value uint32) {
	volatile.StoreUint32(&o.PSELDCX.Reg, volatile.LoadUint32(&o.PSELDCX.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_Type) GetPSELDCX_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.PSELDCX.Reg) & 0x80000000) >> 31
}

// SPIM.DCXCNT: DCX configuration
func (o *SPIM_Type) SetDCXCNT(value uint32) {
	volatile.StoreUint32(&o.DCXCNT.Reg, volatile.LoadUint32(&o.DCXCNT.Reg)&^(0xf)|value)
}
func (o *SPIM_Type) GetDCXCNT() uint32 {
	return volatile.LoadUint32(&o.DCXCNT.Reg) & 0xf
}

// SPIM.ORC: Byte transmitted after TXD.MAXCNT bytes have been transmitted in the case when RXD.MAXCNT is greater than TXD.MAXCNT
func (o *SPIM_Type) SetORC(value uint32) {
	volatile.StoreUint32(&o.ORC.Reg, volatile.LoadUint32(&o.ORC.Reg)&^(0xff)|value)
}
func (o *SPIM_Type) GetORC() uint32 {
	return volatile.LoadUint32(&o.ORC.Reg) & 0xff
}

// Unspecified
type SPIM_PSEL_Type struct {
	SCK  volatile.Register32 // 0x508
	MOSI volatile.Register32 // 0x50C
	MISO volatile.Register32 // 0x510
	CSN  volatile.Register32 // 0x514
}

// SPIM_PSEL.SCK: Pin select for SCK
func (o *SPIM_PSEL_Type) SetSCK_PIN(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetSCK_PIN() uint32 {
	return volatile.LoadUint32(&o.SCK.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetSCK_PORT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_PSEL_Type) GetSCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x20) >> 5
}
func (o *SPIM_PSEL_Type) SetSCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetSCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x80000000) >> 31
}

// SPIM_PSEL.MOSI: Pin select for MOSI signal
func (o *SPIM_PSEL_Type) SetMOSI_PIN(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetMOSI_PIN() uint32 {
	return volatile.LoadUint32(&o.MOSI.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetMOSI_PORT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_PSEL_Type) GetMOSI_PORT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x20) >> 5
}
func (o *SPIM_PSEL_Type) SetMOSI_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetMOSI_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x80000000) >> 31
}

// SPIM_PSEL.MISO: Pin select for MISO signal
func (o *SPIM_PSEL_Type) SetMISO_PIN(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetMISO_PIN() uint32 {
	return volatile.LoadUint32(&o.MISO.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetMISO_PORT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_PSEL_Type) GetMISO_PORT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x20) >> 5
}
func (o *SPIM_PSEL_Type) SetMISO_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetMISO_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x80000000) >> 31
}

// SPIM_PSEL.CSN: Pin select for CSN
func (o *SPIM_PSEL_Type) SetCSN_PIN(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x1f)|value)
}
func (o *SPIM_PSEL_Type) GetCSN_PIN() uint32 {
	return volatile.LoadUint32(&o.CSN.Reg) & 0x1f
}
func (o *SPIM_PSEL_Type) SetCSN_PORT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x20)|value<<5)
}
func (o *SPIM_PSEL_Type) GetCSN_PORT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x20) >> 5
}
func (o *SPIM_PSEL_Type) SetCSN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIM_PSEL_Type) GetCSN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x80000000) >> 31
}

// RXD EasyDMA channel
type SPIM_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// SPIM_RXD.PTR: Data pointer
func (o *SPIM_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIM_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIM_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *SPIM_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *SPIM_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// SPIM_RXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *SPIM_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *SPIM_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// SPIM_RXD.LIST: EasyDMA list type
func (o *SPIM_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIM_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// TXD EasyDMA channel
type SPIM_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// SPIM_TXD.PTR: Data pointer
func (o *SPIM_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIM_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIM_TXD.MAXCNT: Number of bytes in transmit buffer
func (o *SPIM_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *SPIM_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// SPIM_TXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *SPIM_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *SPIM_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// SPIM_TXD.LIST: EasyDMA list type
func (o *SPIM_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIM_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// Unspecified
type SPIM_IFTIMING_Type struct {
	RXDELAY volatile.Register32 // 0x560
	CSNDUR  volatile.Register32 // 0x564
}

// SPIM_IFTIMING.RXDELAY: Sample delay for input serial data on MISO
func (o *SPIM_IFTIMING_Type) SetRXDELAY(value uint32) {
	volatile.StoreUint32(&o.RXDELAY.Reg, volatile.LoadUint32(&o.RXDELAY.Reg)&^(0x7)|value)
}
func (o *SPIM_IFTIMING_Type) GetRXDELAY() uint32 {
	return volatile.LoadUint32(&o.RXDELAY.Reg) & 0x7
}

// SPIM_IFTIMING.CSNDUR: Minimum duration between edge of CSN and edge of SCK and minimum duration CSN must stay high between transactions
func (o *SPIM_IFTIMING_Type) SetCSNDUR(value uint32) {
	volatile.StoreUint32(&o.CSNDUR.Reg, volatile.LoadUint32(&o.CSNDUR.Reg)&^(0xff)|value)
}
func (o *SPIM_IFTIMING_Type) GetCSNDUR() uint32 {
	return volatile.LoadUint32(&o.CSNDUR.Reg) & 0xff
}

// SPI Slave 0
type SPIS_Type struct {
	_               [36]byte
	TASKS_ACQUIRE   volatile.Register32 // 0x24
	TASKS_RELEASE   volatile.Register32 // 0x28
	_               [216]byte
	EVENTS_END      volatile.Register32 // 0x104
	_               [8]byte
	EVENTS_ENDRX    volatile.Register32 // 0x110
	_               [20]byte
	EVENTS_ACQUIRED volatile.Register32 // 0x128
	_               [212]byte
	SHORTS          volatile.Register32 // 0x200
	_               [256]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [244]byte
	SEMSTAT         volatile.Register32 // 0x400
	_               [60]byte
	STATUS          volatile.Register32 // 0x440
	_               [188]byte
	ENABLE          volatile.Register32 // 0x500
	_               [4]byte
	PSEL            SPIS_PSEL_Type // 0x508
	_               [28]byte
	RXD             SPIS_RXD_Type       // 0x534
	TXD             SPIS_TXD_Type       // 0x544
	CONFIG          volatile.Register32 // 0x554
	_               [4]byte
	DEF             volatile.Register32 // 0x55C
	_               [96]byte
	ORC             volatile.Register32 // 0x5C0
}

// SPIS.TASKS_ACQUIRE: Acquire SPI semaphore
func (o *SPIS_Type) SetTASKS_ACQUIRE(value uint32) {
	volatile.StoreUint32(&o.TASKS_ACQUIRE.Reg, volatile.LoadUint32(&o.TASKS_ACQUIRE.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetTASKS_ACQUIRE() uint32 {
	return volatile.LoadUint32(&o.TASKS_ACQUIRE.Reg) & 0x1
}

// SPIS.TASKS_RELEASE: Release SPI semaphore, enabling the SPI slave to acquire it
func (o *SPIS_Type) SetTASKS_RELEASE(value uint32) {
	volatile.StoreUint32(&o.TASKS_RELEASE.Reg, volatile.LoadUint32(&o.TASKS_RELEASE.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetTASKS_RELEASE() uint32 {
	return volatile.LoadUint32(&o.TASKS_RELEASE.Reg) & 0x1
}

// SPIS.EVENTS_END: Granted transaction completed
func (o *SPIS_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// SPIS.EVENTS_ENDRX: End of RXD buffer reached
func (o *SPIS_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// SPIS.EVENTS_ACQUIRED: Semaphore acquired
func (o *SPIS_Type) SetEVENTS_ACQUIRED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ACQUIRED.Reg, volatile.LoadUint32(&o.EVENTS_ACQUIRED.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetEVENTS_ACQUIRED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ACQUIRED.Reg) & 0x1
}

// SPIS.SHORTS: Shortcuts between local events and tasks
func (o *SPIS_Type) SetSHORTS_END_ACQUIRE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *SPIS_Type) GetSHORTS_END_ACQUIRE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}

// SPIS.INTENSET: Enable interrupt
func (o *SPIS_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SPIS_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SPIS_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SPIS_Type) SetINTENSET_ACQUIRED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *SPIS_Type) GetINTENSET_ACQUIRED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}

// SPIS.INTENCLR: Disable interrupt
func (o *SPIS_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SPIS_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SPIS_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SPIS_Type) SetINTENCLR_ACQUIRED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *SPIS_Type) GetINTENCLR_ACQUIRED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}

// SPIS.SEMSTAT: Semaphore status register
func (o *SPIS_Type) SetSEMSTAT(value uint32) {
	volatile.StoreUint32(&o.SEMSTAT.Reg, volatile.LoadUint32(&o.SEMSTAT.Reg)&^(0x3)|value)
}
func (o *SPIS_Type) GetSEMSTAT() uint32 {
	return volatile.LoadUint32(&o.SEMSTAT.Reg) & 0x3
}

// SPIS.STATUS: Status from last transaction
func (o *SPIS_Type) SetSTATUS_OVERREAD(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetSTATUS_OVERREAD() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *SPIS_Type) SetSTATUS_OVERFLOW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetSTATUS_OVERFLOW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}

// SPIS.ENABLE: Enable SPI slave
func (o *SPIS_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *SPIS_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// SPIS.CONFIG: Configuration register
func (o *SPIS_Type) SetCONFIG_ORDER(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *SPIS_Type) GetCONFIG_ORDER() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *SPIS_Type) SetCONFIG_CPHA(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *SPIS_Type) GetCONFIG_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}
func (o *SPIS_Type) SetCONFIG_CPOL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x4)|value<<2)
}
func (o *SPIS_Type) GetCONFIG_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x4) >> 2
}

// SPIS.DEF: Default character. Character clocked out in case of an ignored transaction.
func (o *SPIS_Type) SetDEF(value uint32) {
	volatile.StoreUint32(&o.DEF.Reg, volatile.LoadUint32(&o.DEF.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetDEF() uint32 {
	return volatile.LoadUint32(&o.DEF.Reg) & 0xff
}

// SPIS.ORC: Over-read character
func (o *SPIS_Type) SetORC(value uint32) {
	volatile.StoreUint32(&o.ORC.Reg, volatile.LoadUint32(&o.ORC.Reg)&^(0xff)|value)
}
func (o *SPIS_Type) GetORC() uint32 {
	return volatile.LoadUint32(&o.ORC.Reg) & 0xff
}

// Unspecified
type SPIS_PSEL_Type struct {
	SCK  volatile.Register32 // 0x508
	MISO volatile.Register32 // 0x50C
	MOSI volatile.Register32 // 0x510
	CSN  volatile.Register32 // 0x514
}

// SPIS_PSEL.SCK: Pin select for SCK
func (o *SPIS_PSEL_Type) SetSCK_PIN(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetSCK_PIN() uint32 {
	return volatile.LoadUint32(&o.SCK.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetSCK_PORT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x20)|value<<5)
}
func (o *SPIS_PSEL_Type) GetSCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x20) >> 5
}
func (o *SPIS_PSEL_Type) SetSCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetSCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x80000000) >> 31
}

// SPIS_PSEL.MISO: Pin select for MISO signal
func (o *SPIS_PSEL_Type) SetMISO_PIN(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetMISO_PIN() uint32 {
	return volatile.LoadUint32(&o.MISO.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetMISO_PORT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x20)|value<<5)
}
func (o *SPIS_PSEL_Type) GetMISO_PORT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x20) >> 5
}
func (o *SPIS_PSEL_Type) SetMISO_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MISO.Reg, volatile.LoadUint32(&o.MISO.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetMISO_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MISO.Reg) & 0x80000000) >> 31
}

// SPIS_PSEL.MOSI: Pin select for MOSI signal
func (o *SPIS_PSEL_Type) SetMOSI_PIN(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetMOSI_PIN() uint32 {
	return volatile.LoadUint32(&o.MOSI.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetMOSI_PORT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x20)|value<<5)
}
func (o *SPIS_PSEL_Type) GetMOSI_PORT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x20) >> 5
}
func (o *SPIS_PSEL_Type) SetMOSI_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MOSI.Reg, volatile.LoadUint32(&o.MOSI.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetMOSI_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MOSI.Reg) & 0x80000000) >> 31
}

// SPIS_PSEL.CSN: Pin select for CSN signal
func (o *SPIS_PSEL_Type) SetCSN_PIN(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x1f)|value)
}
func (o *SPIS_PSEL_Type) GetCSN_PIN() uint32 {
	return volatile.LoadUint32(&o.CSN.Reg) & 0x1f
}
func (o *SPIS_PSEL_Type) SetCSN_PORT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x20)|value<<5)
}
func (o *SPIS_PSEL_Type) GetCSN_PORT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x20) >> 5
}
func (o *SPIS_PSEL_Type) SetCSN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CSN.Reg, volatile.LoadUint32(&o.CSN.Reg)&^(0x80000000)|value<<31)
}
func (o *SPIS_PSEL_Type) GetCSN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CSN.Reg) & 0x80000000) >> 31
}

// Unspecified
type SPIS_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// SPIS_RXD.PTR: RXD data pointer
func (o *SPIS_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIS_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIS_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *SPIS_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *SPIS_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// SPIS_RXD.AMOUNT: Number of bytes received in last granted transaction
func (o *SPIS_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *SPIS_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// SPIS_RXD.LIST: EasyDMA list type
func (o *SPIS_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIS_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// Unspecified
type SPIS_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// SPIS_TXD.PTR: TXD data pointer
func (o *SPIS_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SPIS_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SPIS_TXD.MAXCNT: Maximum number of bytes in transmit buffer
func (o *SPIS_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *SPIS_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// SPIS_TXD.AMOUNT: Number of bytes transmitted in last granted transaction
func (o *SPIS_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *SPIS_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// SPIS_TXD.LIST: EasyDMA list type
func (o *SPIS_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *SPIS_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// I2C compatible Two-Wire Interface 0
type TWI_Type struct {
	TASKS_STARTRX    volatile.Register32 // 0x0
	_                [4]byte
	TASKS_STARTTX    volatile.Register32 // 0x8
	_                [8]byte
	TASKS_STOP       volatile.Register32 // 0x14
	_                [4]byte
	TASKS_SUSPEND    volatile.Register32 // 0x1C
	TASKS_RESUME     volatile.Register32 // 0x20
	_                [224]byte
	EVENTS_STOPPED   volatile.Register32 // 0x104
	EVENTS_RXDREADY  volatile.Register32 // 0x108
	_                [16]byte
	EVENTS_TXDSENT   volatile.Register32 // 0x11C
	_                [4]byte
	EVENTS_ERROR     volatile.Register32 // 0x124
	_                [16]byte
	EVENTS_BB        volatile.Register32 // 0x138
	_                [12]byte
	EVENTS_SUSPENDED volatile.Register32 // 0x148
	_                [180]byte
	SHORTS           volatile.Register32 // 0x200
	_                [256]byte
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [440]byte
	ERRORSRC         volatile.Register32 // 0x4C4
	_                [56]byte
	ENABLE           volatile.Register32 // 0x500
	_                [4]byte
	PSEL             TWI_PSEL_Type // 0x508
	_                [8]byte
	RXD              volatile.Register32 // 0x518
	TXD              volatile.Register32 // 0x51C
	_                [4]byte
	FREQUENCY        volatile.Register32 // 0x524
	_                [96]byte
	ADDRESS          volatile.Register32 // 0x588
}

// TWI.TASKS_STARTRX: Start TWI receive sequence
func (o *TWI_Type) SetTASKS_STARTRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTRX.Reg, volatile.LoadUint32(&o.TASKS_STARTRX.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetTASKS_STARTRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTRX.Reg) & 0x1
}

// TWI.TASKS_STARTTX: Start TWI transmit sequence
func (o *TWI_Type) SetTASKS_STARTTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTTX.Reg, volatile.LoadUint32(&o.TASKS_STARTTX.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetTASKS_STARTTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTTX.Reg) & 0x1
}

// TWI.TASKS_STOP: Stop TWI transaction
func (o *TWI_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TWI.TASKS_SUSPEND: Suspend TWI transaction
func (o *TWI_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// TWI.TASKS_RESUME: Resume TWI transaction
func (o *TWI_Type) SetTASKS_RESUME(value uint32) {
	volatile.StoreUint32(&o.TASKS_RESUME.Reg, volatile.LoadUint32(&o.TASKS_RESUME.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetTASKS_RESUME() uint32 {
	return volatile.LoadUint32(&o.TASKS_RESUME.Reg) & 0x1
}

// TWI.EVENTS_STOPPED: TWI stopped
func (o *TWI_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// TWI.EVENTS_RXDREADY: TWI RXD byte received
func (o *TWI_Type) SetEVENTS_RXDREADY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXDREADY.Reg, volatile.LoadUint32(&o.EVENTS_RXDREADY.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetEVENTS_RXDREADY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXDREADY.Reg) & 0x1
}

// TWI.EVENTS_TXDSENT: TWI TXD byte sent
func (o *TWI_Type) SetEVENTS_TXDSENT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXDSENT.Reg, volatile.LoadUint32(&o.EVENTS_TXDSENT.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetEVENTS_TXDSENT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXDSENT.Reg) & 0x1
}

// TWI.EVENTS_ERROR: TWI error
func (o *TWI_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// TWI.EVENTS_BB: TWI byte boundary, generated before each byte that is sent or received
func (o *TWI_Type) SetEVENTS_BB(value uint32) {
	volatile.StoreUint32(&o.EVENTS_BB.Reg, volatile.LoadUint32(&o.EVENTS_BB.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetEVENTS_BB() uint32 {
	return volatile.LoadUint32(&o.EVENTS_BB.Reg) & 0x1
}

// TWI.EVENTS_SUSPENDED: TWI entered the suspended state
func (o *TWI_Type) SetEVENTS_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SUSPENDED.Reg, volatile.LoadUint32(&o.EVENTS_SUSPENDED.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetEVENTS_SUSPENDED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SUSPENDED.Reg) & 0x1
}

// TWI.SHORTS: Shortcuts between local events and tasks
func (o *TWI_Type) SetSHORTS_BB_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetSHORTS_BB_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *TWI_Type) SetSHORTS_BB_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetSHORTS_BB_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}

// TWI.INTENSET: Enable interrupt
func (o *TWI_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetINTENSET_RXDREADY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetINTENSET_RXDREADY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetINTENSET_TXDSENT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *TWI_Type) GetINTENSET_TXDSENT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *TWI_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetINTENSET_BB(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetINTENSET_BB() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetINTENSET_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *TWI_Type) GetINTENSET_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}

// TWI.INTENCLR: Disable interrupt
func (o *TWI_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetINTENCLR_RXDREADY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetINTENCLR_RXDREADY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetINTENCLR_TXDSENT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *TWI_Type) GetINTENCLR_TXDSENT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *TWI_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetINTENCLR_BB(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetINTENCLR_BB() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetINTENCLR_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *TWI_Type) GetINTENCLR_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}

// TWI.ERRORSRC: Error source
func (o *TWI_Type) SetERRORSRC_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetERRORSRC_OVERRUN() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *TWI_Type) SetERRORSRC_ANACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetERRORSRC_ANACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetERRORSRC_DNACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetERRORSRC_DNACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}

// TWI.ENABLE: Enable TWI
func (o *TWI_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *TWI_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// TWI.RXD: RXD register
func (o *TWI_Type) SetRXD(value uint32) {
	volatile.StoreUint32(&o.RXD.Reg, volatile.LoadUint32(&o.RXD.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetRXD() uint32 {
	return volatile.LoadUint32(&o.RXD.Reg) & 0xff
}

// TWI.TXD: TXD register
func (o *TWI_Type) SetTXD(value uint32) {
	volatile.StoreUint32(&o.TXD.Reg, volatile.LoadUint32(&o.TXD.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetTXD() uint32 {
	return volatile.LoadUint32(&o.TXD.Reg) & 0xff
}

// TWI.FREQUENCY: TWI frequency. Accuracy depends on the HFCLK source selected.
func (o *TWI_Type) SetFREQUENCY(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, value)
}
func (o *TWI_Type) GetFREQUENCY() uint32 {
	return volatile.LoadUint32(&o.FREQUENCY.Reg)
}

// TWI.ADDRESS: Address used in the TWI transfer
func (o *TWI_Type) SetADDRESS(value uint32) {
	volatile.StoreUint32(&o.ADDRESS.Reg, volatile.LoadUint32(&o.ADDRESS.Reg)&^(0x7f)|value)
}
func (o *TWI_Type) GetADDRESS() uint32 {
	return volatile.LoadUint32(&o.ADDRESS.Reg) & 0x7f
}

// Unspecified
type TWI_PSEL_Type struct {
	SCL volatile.Register32 // 0x508
	SDA volatile.Register32 // 0x50C
}

// TWI_PSEL.SCL: Pin select for SCL
func (o *TWI_PSEL_Type) SetSCL_PIN(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x1f)|value)
}
func (o *TWI_PSEL_Type) GetSCL_PIN() uint32 {
	return volatile.LoadUint32(&o.SCL.Reg) & 0x1f
}
func (o *TWI_PSEL_Type) SetSCL_PORT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x20)|value<<5)
}
func (o *TWI_PSEL_Type) GetSCL_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x20) >> 5
}
func (o *TWI_PSEL_Type) SetSCL_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x80000000)|value<<31)
}
func (o *TWI_PSEL_Type) GetSCL_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x80000000) >> 31
}

// TWI_PSEL.SDA: Pin select for SDA
func (o *TWI_PSEL_Type) SetSDA_PIN(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x1f)|value)
}
func (o *TWI_PSEL_Type) GetSDA_PIN() uint32 {
	return volatile.LoadUint32(&o.SDA.Reg) & 0x1f
}
func (o *TWI_PSEL_Type) SetSDA_PORT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x20)|value<<5)
}
func (o *TWI_PSEL_Type) GetSDA_PORT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x20) >> 5
}
func (o *TWI_PSEL_Type) SetSDA_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x80000000)|value<<31)
}
func (o *TWI_PSEL_Type) GetSDA_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x80000000) >> 31
}

// I2C compatible Two-Wire Master Interface with EasyDMA 0
type TWIM_Type struct {
	TASKS_STARTRX    volatile.Register32 // 0x0
	_                [4]byte
	TASKS_STARTTX    volatile.Register32 // 0x8
	_                [8]byte
	TASKS_STOP       volatile.Register32 // 0x14
	_                [4]byte
	TASKS_SUSPEND    volatile.Register32 // 0x1C
	TASKS_RESUME     volatile.Register32 // 0x20
	_                [224]byte
	EVENTS_STOPPED   volatile.Register32 // 0x104
	_                [28]byte
	EVENTS_ERROR     volatile.Register32 // 0x124
	_                [32]byte
	EVENTS_SUSPENDED volatile.Register32 // 0x148
	EVENTS_RXSTARTED volatile.Register32 // 0x14C
	EVENTS_TXSTARTED volatile.Register32 // 0x150
	_                [8]byte
	EVENTS_LASTRX    volatile.Register32 // 0x15C
	EVENTS_LASTTX    volatile.Register32 // 0x160
	_                [156]byte
	SHORTS           volatile.Register32 // 0x200
	_                [252]byte
	INTEN            volatile.Register32 // 0x300
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [440]byte
	ERRORSRC         volatile.Register32 // 0x4C4
	_                [56]byte
	ENABLE           volatile.Register32 // 0x500
	_                [4]byte
	PSEL             TWIM_PSEL_Type // 0x508
	_                [20]byte
	FREQUENCY        volatile.Register32 // 0x524
	_                [12]byte
	RXD              TWIM_RXD_Type // 0x534
	TXD              TWIM_TXD_Type // 0x544
	_                [52]byte
	ADDRESS          volatile.Register32 // 0x588
}

// TWIM.TASKS_STARTRX: Start TWI receive sequence
func (o *TWIM_Type) SetTASKS_STARTRX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTRX.Reg, volatile.LoadUint32(&o.TASKS_STARTRX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_STARTRX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTRX.Reg) & 0x1
}

// TWIM.TASKS_STARTTX: Start TWI transmit sequence
func (o *TWIM_Type) SetTASKS_STARTTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTTX.Reg, volatile.LoadUint32(&o.TASKS_STARTTX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_STARTTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTTX.Reg) & 0x1
}

// TWIM.TASKS_STOP: Stop TWI transaction. Must be issued while the TWI master is not suspended.
func (o *TWIM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TWIM.TASKS_SUSPEND: Suspend TWI transaction
func (o *TWIM_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// TWIM.TASKS_RESUME: Resume TWI transaction
func (o *TWIM_Type) SetTASKS_RESUME(value uint32) {
	volatile.StoreUint32(&o.TASKS_RESUME.Reg, volatile.LoadUint32(&o.TASKS_RESUME.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetTASKS_RESUME() uint32 {
	return volatile.LoadUint32(&o.TASKS_RESUME.Reg) & 0x1
}

// TWIM.EVENTS_STOPPED: TWI stopped
func (o *TWIM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// TWIM.EVENTS_ERROR: TWI error
func (o *TWIM_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// TWIM.EVENTS_SUSPENDED: Last byte has been sent out after the SUSPEND task has been issued, TWI traffic is now suspended.
func (o *TWIM_Type) SetEVENTS_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SUSPENDED.Reg, volatile.LoadUint32(&o.EVENTS_SUSPENDED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_SUSPENDED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SUSPENDED.Reg) & 0x1
}

// TWIM.EVENTS_RXSTARTED: Receive sequence started
func (o *TWIM_Type) SetEVENTS_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_RXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg) & 0x1
}

// TWIM.EVENTS_TXSTARTED: Transmit sequence started
func (o *TWIM_Type) SetEVENTS_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_TXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg) & 0x1
}

// TWIM.EVENTS_LASTRX: Byte boundary, starting to receive the last byte
func (o *TWIM_Type) SetEVENTS_LASTRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LASTRX.Reg, volatile.LoadUint32(&o.EVENTS_LASTRX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_LASTRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LASTRX.Reg) & 0x1
}

// TWIM.EVENTS_LASTTX: Byte boundary, starting to transmit the last byte
func (o *TWIM_Type) SetEVENTS_LASTTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LASTTX.Reg, volatile.LoadUint32(&o.EVENTS_LASTTX.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetEVENTS_LASTTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LASTTX.Reg) & 0x1
}

// TWIM.SHORTS: Shortcuts between local events and tasks
func (o *TWIM_Type) SetSHORTS_LASTTX_STARTRX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x80)|value<<7)
}
func (o *TWIM_Type) GetSHORTS_LASTTX_STARTRX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x80) >> 7
}
func (o *TWIM_Type) SetSHORTS_LASTTX_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x100)|value<<8)
}
func (o *TWIM_Type) GetSHORTS_LASTTX_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x100) >> 8
}
func (o *TWIM_Type) SetSHORTS_LASTTX_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetSHORTS_LASTTX_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetSHORTS_LASTRX_STARTTX(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x400)|value<<10)
}
func (o *TWIM_Type) GetSHORTS_LASTRX_STARTTX() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x400) >> 10
}
func (o *TWIM_Type) SetSHORTS_LASTRX_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x800)|value<<11)
}
func (o *TWIM_Type) GetSHORTS_LASTRX_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x800) >> 11
}
func (o *TWIM_Type) SetSHORTS_LASTRX_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1000)|value<<12)
}
func (o *TWIM_Type) GetSHORTS_LASTRX_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x1000) >> 12
}

// TWIM.INTEN: Enable or disable interrupt
func (o *TWIM_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetINTEN_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000)|value<<18)
}
func (o *TWIM_Type) GetINTEN_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000) >> 18
}
func (o *TWIM_Type) SetINTEN_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *TWIM_Type) GetINTEN_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *TWIM_Type) SetINTEN_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *TWIM_Type) GetINTEN_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *TWIM_Type) SetINTEN_LASTRX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800000)|value<<23)
}
func (o *TWIM_Type) GetINTEN_LASTRX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800000) >> 23
}
func (o *TWIM_Type) SetINTEN_LASTTX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIM_Type) GetINTEN_LASTTX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000000) >> 24
}

// TWIM.INTENSET: Enable interrupt
func (o *TWIM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetINTENSET_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *TWIM_Type) GetINTENSET_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *TWIM_Type) SetINTENSET_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TWIM_Type) GetINTENSET_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *TWIM_Type) SetINTENSET_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *TWIM_Type) GetINTENSET_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *TWIM_Type) SetINTENSET_LASTRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800000)|value<<23)
}
func (o *TWIM_Type) GetINTENSET_LASTRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800000) >> 23
}
func (o *TWIM_Type) SetINTENSET_LASTTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIM_Type) GetINTENSET_LASTTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000000) >> 24
}

// TWIM.INTENCLR: Disable interrupt
func (o *TWIM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *TWIM_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *TWIM_Type) SetINTENCLR_SUSPENDED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *TWIM_Type) GetINTENCLR_SUSPENDED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *TWIM_Type) SetINTENCLR_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TWIM_Type) GetINTENCLR_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *TWIM_Type) SetINTENCLR_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *TWIM_Type) GetINTENCLR_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *TWIM_Type) SetINTENCLR_LASTRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800000)|value<<23)
}
func (o *TWIM_Type) GetINTENCLR_LASTRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800000) >> 23
}
func (o *TWIM_Type) SetINTENCLR_LASTTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *TWIM_Type) GetINTENCLR_LASTTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000000) >> 24
}

// TWIM.ERRORSRC: Error source
func (o *TWIM_Type) SetERRORSRC_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *TWIM_Type) GetERRORSRC_OVERRUN() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *TWIM_Type) SetERRORSRC_ANACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x2)|value<<1)
}
func (o *TWIM_Type) GetERRORSRC_ANACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x2) >> 1
}
func (o *TWIM_Type) SetERRORSRC_DNACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *TWIM_Type) GetERRORSRC_DNACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}

// TWIM.ENABLE: Enable TWIM
func (o *TWIM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *TWIM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// TWIM.FREQUENCY: TWI frequency. Accuracy depends on the HFCLK source selected.
func (o *TWIM_Type) SetFREQUENCY(value uint32) {
	volatile.StoreUint32(&o.FREQUENCY.Reg, value)
}
func (o *TWIM_Type) GetFREQUENCY() uint32 {
	return volatile.LoadUint32(&o.FREQUENCY.Reg)
}

// TWIM.ADDRESS: Address used in the TWI transfer
func (o *TWIM_Type) SetADDRESS(value uint32) {
	volatile.StoreUint32(&o.ADDRESS.Reg, volatile.LoadUint32(&o.ADDRESS.Reg)&^(0x7f)|value)
}
func (o *TWIM_Type) GetADDRESS() uint32 {
	return volatile.LoadUint32(&o.ADDRESS.Reg) & 0x7f
}

// Unspecified
type TWIM_PSEL_Type struct {
	SCL volatile.Register32 // 0x508
	SDA volatile.Register32 // 0x50C
}

// TWIM_PSEL.SCL: Pin select for SCL signal
func (o *TWIM_PSEL_Type) SetSCL_PIN(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x1f)|value)
}
func (o *TWIM_PSEL_Type) GetSCL_PIN() uint32 {
	return volatile.LoadUint32(&o.SCL.Reg) & 0x1f
}
func (o *TWIM_PSEL_Type) SetSCL_PORT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x20)|value<<5)
}
func (o *TWIM_PSEL_Type) GetSCL_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x20) >> 5
}
func (o *TWIM_PSEL_Type) SetSCL_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_PSEL_Type) GetSCL_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x80000000) >> 31
}

// TWIM_PSEL.SDA: Pin select for SDA signal
func (o *TWIM_PSEL_Type) SetSDA_PIN(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x1f)|value)
}
func (o *TWIM_PSEL_Type) GetSDA_PIN() uint32 {
	return volatile.LoadUint32(&o.SDA.Reg) & 0x1f
}
func (o *TWIM_PSEL_Type) SetSDA_PORT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x20)|value<<5)
}
func (o *TWIM_PSEL_Type) GetSDA_PORT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x20) >> 5
}
func (o *TWIM_PSEL_Type) SetSDA_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIM_PSEL_Type) GetSDA_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x80000000) >> 31
}

// RXD EasyDMA channel
type TWIM_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// TWIM_RXD.PTR: Data pointer
func (o *TWIM_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIM_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIM_RXD.MAXCNT: Maximum number of bytes in receive buffer
func (o *TWIM_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *TWIM_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// TWIM_RXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *TWIM_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *TWIM_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TWIM_RXD.LIST: EasyDMA list type
func (o *TWIM_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x7)|value)
}
func (o *TWIM_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x7
}

// TXD EasyDMA channel
type TWIM_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// TWIM_TXD.PTR: Data pointer
func (o *TWIM_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIM_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIM_TXD.MAXCNT: Maximum number of bytes in transmit buffer
func (o *TWIM_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *TWIM_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// TWIM_TXD.AMOUNT: Number of bytes transferred in the last transaction
func (o *TWIM_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *TWIM_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TWIM_TXD.LIST: EasyDMA list type
func (o *TWIM_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x7)|value)
}
func (o *TWIM_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x7
}

// I2C compatible Two-Wire Slave Interface with EasyDMA 0
type TWIS_Type struct {
	_                [20]byte
	TASKS_STOP       volatile.Register32 // 0x14
	_                [4]byte
	TASKS_SUSPEND    volatile.Register32 // 0x1C
	TASKS_RESUME     volatile.Register32 // 0x20
	_                [12]byte
	TASKS_PREPARERX  volatile.Register32 // 0x30
	TASKS_PREPARETX  volatile.Register32 // 0x34
	_                [204]byte
	EVENTS_STOPPED   volatile.Register32 // 0x104
	_                [28]byte
	EVENTS_ERROR     volatile.Register32 // 0x124
	_                [36]byte
	EVENTS_RXSTARTED volatile.Register32 // 0x14C
	EVENTS_TXSTARTED volatile.Register32 // 0x150
	_                [16]byte
	EVENTS_WRITE     volatile.Register32 // 0x164
	EVENTS_READ      volatile.Register32 // 0x168
	_                [148]byte
	SHORTS           volatile.Register32 // 0x200
	_                [252]byte
	INTEN            volatile.Register32 // 0x300
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [452]byte
	ERRORSRC         volatile.Register32 // 0x4D0
	MATCH            volatile.Register32 // 0x4D4
	_                [40]byte
	ENABLE           volatile.Register32 // 0x500
	_                [4]byte
	PSEL             TWIS_PSEL_Type // 0x508
	_                [36]byte
	RXD              TWIS_RXD_Type // 0x534
	TXD              TWIS_TXD_Type // 0x544
	_                [52]byte
	ADDRESS          [2]volatile.Register32 // 0x588
	_                [4]byte
	CONFIG           volatile.Register32 // 0x594
	_                [40]byte
	ORC              volatile.Register32 // 0x5C0
}

// TWIS.TASKS_STOP: Stop TWI transaction
func (o *TWIS_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TWIS.TASKS_SUSPEND: Suspend TWI transaction
func (o *TWIS_Type) SetTASKS_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.TASKS_SUSPEND.Reg, volatile.LoadUint32(&o.TASKS_SUSPEND.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_SUSPEND() uint32 {
	return volatile.LoadUint32(&o.TASKS_SUSPEND.Reg) & 0x1
}

// TWIS.TASKS_RESUME: Resume TWI transaction
func (o *TWIS_Type) SetTASKS_RESUME(value uint32) {
	volatile.StoreUint32(&o.TASKS_RESUME.Reg, volatile.LoadUint32(&o.TASKS_RESUME.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_RESUME() uint32 {
	return volatile.LoadUint32(&o.TASKS_RESUME.Reg) & 0x1
}

// TWIS.TASKS_PREPARERX: Prepare the TWI slave to respond to a write command
func (o *TWIS_Type) SetTASKS_PREPARERX(value uint32) {
	volatile.StoreUint32(&o.TASKS_PREPARERX.Reg, volatile.LoadUint32(&o.TASKS_PREPARERX.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_PREPARERX() uint32 {
	return volatile.LoadUint32(&o.TASKS_PREPARERX.Reg) & 0x1
}

// TWIS.TASKS_PREPARETX: Prepare the TWI slave to respond to a read command
func (o *TWIS_Type) SetTASKS_PREPARETX(value uint32) {
	volatile.StoreUint32(&o.TASKS_PREPARETX.Reg, volatile.LoadUint32(&o.TASKS_PREPARETX.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetTASKS_PREPARETX() uint32 {
	return volatile.LoadUint32(&o.TASKS_PREPARETX.Reg) & 0x1
}

// TWIS.EVENTS_STOPPED: TWI stopped
func (o *TWIS_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// TWIS.EVENTS_ERROR: TWI error
func (o *TWIS_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// TWIS.EVENTS_RXSTARTED: Receive sequence started
func (o *TWIS_Type) SetEVENTS_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_RXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXSTARTED.Reg) & 0x1
}

// TWIS.EVENTS_TXSTARTED: Transmit sequence started
func (o *TWIS_Type) SetEVENTS_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_TXSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXSTARTED.Reg) & 0x1
}

// TWIS.EVENTS_WRITE: Write command received
func (o *TWIS_Type) SetEVENTS_WRITE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_WRITE.Reg, volatile.LoadUint32(&o.EVENTS_WRITE.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_WRITE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_WRITE.Reg) & 0x1
}

// TWIS.EVENTS_READ: Read command received
func (o *TWIS_Type) SetEVENTS_READ(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READ.Reg, volatile.LoadUint32(&o.EVENTS_READ.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetEVENTS_READ() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READ.Reg) & 0x1
}

// TWIS.SHORTS: Shortcuts between local events and tasks
func (o *TWIS_Type) SetSHORTS_WRITE_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2000)|value<<13)
}
func (o *TWIS_Type) GetSHORTS_WRITE_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2000) >> 13
}
func (o *TWIS_Type) SetSHORTS_READ_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4000)|value<<14)
}
func (o *TWIS_Type) GetSHORTS_READ_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4000) >> 14
}

// TWIS.INTEN: Enable or disable interrupt
func (o *TWIS_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *TWIS_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *TWIS_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *TWIS_Type) SetINTEN_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *TWIS_Type) GetINTEN_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *TWIS_Type) SetINTEN_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *TWIS_Type) GetINTEN_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *TWIS_Type) SetINTEN_WRITE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000000)|value<<25)
}
func (o *TWIS_Type) GetINTEN_WRITE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000000) >> 25
}
func (o *TWIS_Type) SetINTEN_READ(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000000)|value<<26)
}
func (o *TWIS_Type) GetINTEN_READ() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000000) >> 26
}

// TWIS.INTENSET: Enable interrupt
func (o *TWIS_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TWIS_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *TWIS_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *TWIS_Type) SetINTENSET_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TWIS_Type) GetINTENSET_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *TWIS_Type) SetINTENSET_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *TWIS_Type) GetINTENSET_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *TWIS_Type) SetINTENSET_WRITE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000000)|value<<25)
}
func (o *TWIS_Type) GetINTENSET_WRITE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000000) >> 25
}
func (o *TWIS_Type) SetINTENSET_READ(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000000)|value<<26)
}
func (o *TWIS_Type) GetINTENSET_READ() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000000) >> 26
}

// TWIS.INTENCLR: Disable interrupt
func (o *TWIS_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TWIS_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *TWIS_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *TWIS_Type) SetINTENCLR_RXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TWIS_Type) GetINTENCLR_RXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *TWIS_Type) SetINTENCLR_TXSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *TWIS_Type) GetINTENCLR_TXSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *TWIS_Type) SetINTENCLR_WRITE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *TWIS_Type) GetINTENCLR_WRITE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000000) >> 25
}
func (o *TWIS_Type) SetINTENCLR_READ(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *TWIS_Type) GetINTENCLR_READ() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000000) >> 26
}

// TWIS.ERRORSRC: Error source
func (o *TWIS_Type) SetERRORSRC_OVERFLOW(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetERRORSRC_OVERFLOW() uint32 {
	return volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x1
}
func (o *TWIS_Type) SetERRORSRC_DNACK(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x4)|value<<2)
}
func (o *TWIS_Type) GetERRORSRC_DNACK() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x4) >> 2
}
func (o *TWIS_Type) SetERRORSRC_OVERREAD(value uint32) {
	volatile.StoreUint32(&o.ERRORSRC.Reg, volatile.LoadUint32(&o.ERRORSRC.Reg)&^(0x8)|value<<3)
}
func (o *TWIS_Type) GetERRORSRC_OVERREAD() uint32 {
	return (volatile.LoadUint32(&o.ERRORSRC.Reg) & 0x8) >> 3
}

// TWIS.MATCH: Status register indicating which address had a match
func (o *TWIS_Type) SetMATCH(value uint32) {
	volatile.StoreUint32(&o.MATCH.Reg, volatile.LoadUint32(&o.MATCH.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetMATCH() uint32 {
	return volatile.LoadUint32(&o.MATCH.Reg) & 0x1
}

// TWIS.ENABLE: Enable TWIS
func (o *TWIS_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0xf)|value)
}
func (o *TWIS_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0xf
}

// TWIS.ADDRESS: Description collection: TWI slave address n
func (o *TWIS_Type) SetADDRESS(idx int, value uint32) {
	volatile.StoreUint32(&o.ADDRESS[idx].Reg, volatile.LoadUint32(&o.ADDRESS[idx].Reg)&^(0x7f)|value)
}
func (o *TWIS_Type) GetADDRESS(idx int) uint32 {
	return volatile.LoadUint32(&o.ADDRESS[idx].Reg) & 0x7f
}

// TWIS.CONFIG: Configuration register for the address match mechanism
func (o *TWIS_Type) SetCONFIG_ADDRESS0(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *TWIS_Type) GetCONFIG_ADDRESS0() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *TWIS_Type) SetCONFIG_ADDRESS1(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x2)|value<<1)
}
func (o *TWIS_Type) GetCONFIG_ADDRESS1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x2) >> 1
}

// TWIS.ORC: Over-read character. Character sent out in case of an over-read of the transmit buffer.
func (o *TWIS_Type) SetORC(value uint32) {
	volatile.StoreUint32(&o.ORC.Reg, volatile.LoadUint32(&o.ORC.Reg)&^(0xff)|value)
}
func (o *TWIS_Type) GetORC() uint32 {
	return volatile.LoadUint32(&o.ORC.Reg) & 0xff
}

// Unspecified
type TWIS_PSEL_Type struct {
	SCL volatile.Register32 // 0x508
	SDA volatile.Register32 // 0x50C
}

// TWIS_PSEL.SCL: Pin select for SCL signal
func (o *TWIS_PSEL_Type) SetSCL_PIN(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x1f)|value)
}
func (o *TWIS_PSEL_Type) GetSCL_PIN() uint32 {
	return volatile.LoadUint32(&o.SCL.Reg) & 0x1f
}
func (o *TWIS_PSEL_Type) SetSCL_PORT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x20)|value<<5)
}
func (o *TWIS_PSEL_Type) GetSCL_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x20) >> 5
}
func (o *TWIS_PSEL_Type) SetSCL_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCL.Reg, volatile.LoadUint32(&o.SCL.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_PSEL_Type) GetSCL_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCL.Reg) & 0x80000000) >> 31
}

// TWIS_PSEL.SDA: Pin select for SDA signal
func (o *TWIS_PSEL_Type) SetSDA_PIN(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x1f)|value)
}
func (o *TWIS_PSEL_Type) GetSDA_PIN() uint32 {
	return volatile.LoadUint32(&o.SDA.Reg) & 0x1f
}
func (o *TWIS_PSEL_Type) SetSDA_PORT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x20)|value<<5)
}
func (o *TWIS_PSEL_Type) GetSDA_PORT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x20) >> 5
}
func (o *TWIS_PSEL_Type) SetSDA_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDA.Reg, volatile.LoadUint32(&o.SDA.Reg)&^(0x80000000)|value<<31)
}
func (o *TWIS_PSEL_Type) GetSDA_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDA.Reg) & 0x80000000) >> 31
}

// RXD EasyDMA channel
type TWIS_RXD_Type struct {
	PTR    volatile.Register32 // 0x534
	MAXCNT volatile.Register32 // 0x538
	AMOUNT volatile.Register32 // 0x53C
	LIST   volatile.Register32 // 0x540
}

// TWIS_RXD.PTR: RXD Data pointer
func (o *TWIS_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIS_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIS_RXD.MAXCNT: Maximum number of bytes in RXD buffer
func (o *TWIS_RXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *TWIS_RXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// TWIS_RXD.AMOUNT: Number of bytes transferred in the last RXD transaction
func (o *TWIS_RXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *TWIS_RXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TWIS_RXD.LIST: EasyDMA list type
func (o *TWIS_RXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *TWIS_RXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// TXD EasyDMA channel
type TWIS_TXD_Type struct {
	PTR    volatile.Register32 // 0x544
	MAXCNT volatile.Register32 // 0x548
	AMOUNT volatile.Register32 // 0x54C
	LIST   volatile.Register32 // 0x550
}

// TWIS_TXD.PTR: TXD Data pointer
func (o *TWIS_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *TWIS_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// TWIS_TXD.MAXCNT: Maximum number of bytes in TXD buffer
func (o *TWIS_TXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0xffff)|value)
}
func (o *TWIS_TXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0xffff
}

// TWIS_TXD.AMOUNT: Number of bytes transferred in the last TXD transaction
func (o *TWIS_TXD_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xffff)|value)
}
func (o *TWIS_TXD_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0xffff
}

// TWIS_TXD.LIST: EasyDMA list type
func (o *TWIS_TXD_Type) SetLIST(value uint32) {
	volatile.StoreUint32(&o.LIST.Reg, volatile.LoadUint32(&o.LIST.Reg)&^(0x3)|value)
}
func (o *TWIS_TXD_Type) GetLIST() uint32 {
	return volatile.LoadUint32(&o.LIST.Reg) & 0x3
}

// NFC-A compatible radio
type NFCT_Type struct {
	TASKS_ACTIVATE           volatile.Register32 // 0x0
	TASKS_DISABLE            volatile.Register32 // 0x4
	TASKS_SENSE              volatile.Register32 // 0x8
	TASKS_STARTTX            volatile.Register32 // 0xC
	_                        [12]byte
	TASKS_ENABLERXDATA       volatile.Register32 // 0x1C
	_                        [4]byte
	TASKS_GOIDLE             volatile.Register32 // 0x24
	TASKS_GOSLEEP            volatile.Register32 // 0x28
	_                        [212]byte
	EVENTS_READY             volatile.Register32 // 0x100
	EVENTS_FIELDDETECTED     volatile.Register32 // 0x104
	EVENTS_FIELDLOST         volatile.Register32 // 0x108
	EVENTS_TXFRAMESTART      volatile.Register32 // 0x10C
	EVENTS_TXFRAMEEND        volatile.Register32 // 0x110
	EVENTS_RXFRAMESTART      volatile.Register32 // 0x114
	EVENTS_RXFRAMEEND        volatile.Register32 // 0x118
	EVENTS_ERROR             volatile.Register32 // 0x11C
	_                        [8]byte
	EVENTS_RXERROR           volatile.Register32 // 0x128
	EVENTS_ENDRX             volatile.Register32 // 0x12C
	EVENTS_ENDTX             volatile.Register32 // 0x130
	_                        [4]byte
	EVENTS_AUTOCOLRESSTARTED volatile.Register32 // 0x138
	_                        [12]byte
	EVENTS_COLLISION         volatile.Register32 // 0x148
	EVENTS_SELECTED          volatile.Register32 // 0x14C
	EVENTS_STARTED           volatile.Register32 // 0x150
	_                        [172]byte
	SHORTS                   volatile.Register32 // 0x200
	_                        [252]byte
	INTEN                    volatile.Register32 // 0x300
	INTENSET                 volatile.Register32 // 0x304
	INTENCLR                 volatile.Register32 // 0x308
	_                        [248]byte
	ERRORSTATUS              volatile.Register32 // 0x404
	_                        [4]byte
	FRAMESTATUS              NFCT_FRAMESTATUS_Type // 0x40C
	NFCTAGSTATE              volatile.Register32   // 0x410
	_                        [12]byte
	SLEEPSTATE               volatile.Register32 // 0x420
	_                        [24]byte
	FIELDPRESENT             volatile.Register32 // 0x43C
	_                        [196]byte
	FRAMEDELAYMIN            volatile.Register32 // 0x504
	FRAMEDELAYMAX            volatile.Register32 // 0x508
	FRAMEDELAYMODE           volatile.Register32 // 0x50C
	PACKETPTR                volatile.Register32 // 0x510
	MAXLEN                   volatile.Register32 // 0x514
	TXD                      NFCT_TXD_Type       // 0x518
	RXD                      NFCT_RXD_Type       // 0x520
	_                        [4]byte
	MODULATIONCTRL           volatile.Register32 // 0x52C
	_                        [8]byte
	MODULATIONPSEL           volatile.Register32 // 0x538
	_                        [84]byte
	NFCID1_LAST              volatile.Register32 // 0x590
	NFCID1_2ND_LAST          volatile.Register32 // 0x594
	NFCID1_3RD_LAST          volatile.Register32 // 0x598
	AUTOCOLRESCONFIG         volatile.Register32 // 0x59C
	SENSRES                  volatile.Register32 // 0x5A0
	SELRES                   volatile.Register32 // 0x5A4
}

// NFCT.TASKS_ACTIVATE: Activate NFCT peripheral for incoming and outgoing frames, change state to activated
func (o *NFCT_Type) SetTASKS_ACTIVATE(value uint32) {
	volatile.StoreUint32(&o.TASKS_ACTIVATE.Reg, volatile.LoadUint32(&o.TASKS_ACTIVATE.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_ACTIVATE() uint32 {
	return volatile.LoadUint32(&o.TASKS_ACTIVATE.Reg) & 0x1
}

// NFCT.TASKS_DISABLE: Disable NFCT peripheral
func (o *NFCT_Type) SetTASKS_DISABLE(value uint32) {
	volatile.StoreUint32(&o.TASKS_DISABLE.Reg, volatile.LoadUint32(&o.TASKS_DISABLE.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_DISABLE() uint32 {
	return volatile.LoadUint32(&o.TASKS_DISABLE.Reg) & 0x1
}

// NFCT.TASKS_SENSE: Enable NFC sense field mode, change state to sense mode
func (o *NFCT_Type) SetTASKS_SENSE(value uint32) {
	volatile.StoreUint32(&o.TASKS_SENSE.Reg, volatile.LoadUint32(&o.TASKS_SENSE.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_SENSE() uint32 {
	return volatile.LoadUint32(&o.TASKS_SENSE.Reg) & 0x1
}

// NFCT.TASKS_STARTTX: Start transmission of an outgoing frame, change state to transmit
func (o *NFCT_Type) SetTASKS_STARTTX(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTTX.Reg, volatile.LoadUint32(&o.TASKS_STARTTX.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_STARTTX() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTTX.Reg) & 0x1
}

// NFCT.TASKS_ENABLERXDATA: Initializes the EasyDMA for receive.
func (o *NFCT_Type) SetTASKS_ENABLERXDATA(value uint32) {
	volatile.StoreUint32(&o.TASKS_ENABLERXDATA.Reg, volatile.LoadUint32(&o.TASKS_ENABLERXDATA.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_ENABLERXDATA() uint32 {
	return volatile.LoadUint32(&o.TASKS_ENABLERXDATA.Reg) & 0x1
}

// NFCT.TASKS_GOIDLE: Force state machine to IDLE state
func (o *NFCT_Type) SetTASKS_GOIDLE(value uint32) {
	volatile.StoreUint32(&o.TASKS_GOIDLE.Reg, volatile.LoadUint32(&o.TASKS_GOIDLE.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_GOIDLE() uint32 {
	return volatile.LoadUint32(&o.TASKS_GOIDLE.Reg) & 0x1
}

// NFCT.TASKS_GOSLEEP: Force state machine to SLEEP_A state
func (o *NFCT_Type) SetTASKS_GOSLEEP(value uint32) {
	volatile.StoreUint32(&o.TASKS_GOSLEEP.Reg, volatile.LoadUint32(&o.TASKS_GOSLEEP.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetTASKS_GOSLEEP() uint32 {
	return volatile.LoadUint32(&o.TASKS_GOSLEEP.Reg) & 0x1
}

// NFCT.EVENTS_READY: The NFCT peripheral is ready to receive and send frames
func (o *NFCT_Type) SetEVENTS_READY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READY.Reg, volatile.LoadUint32(&o.EVENTS_READY.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_READY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READY.Reg) & 0x1
}

// NFCT.EVENTS_FIELDDETECTED: Remote NFC field detected
func (o *NFCT_Type) SetEVENTS_FIELDDETECTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_FIELDDETECTED.Reg, volatile.LoadUint32(&o.EVENTS_FIELDDETECTED.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_FIELDDETECTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_FIELDDETECTED.Reg) & 0x1
}

// NFCT.EVENTS_FIELDLOST: Remote NFC field lost
func (o *NFCT_Type) SetEVENTS_FIELDLOST(value uint32) {
	volatile.StoreUint32(&o.EVENTS_FIELDLOST.Reg, volatile.LoadUint32(&o.EVENTS_FIELDLOST.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_FIELDLOST() uint32 {
	return volatile.LoadUint32(&o.EVENTS_FIELDLOST.Reg) & 0x1
}

// NFCT.EVENTS_TXFRAMESTART: Marks the start of the first symbol of a transmitted frame
func (o *NFCT_Type) SetEVENTS_TXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXFRAMESTART.Reg, volatile.LoadUint32(&o.EVENTS_TXFRAMESTART.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_TXFRAMESTART() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXFRAMESTART.Reg) & 0x1
}

// NFCT.EVENTS_TXFRAMEEND: Marks the end of the last transmitted on-air symbol of a frame
func (o *NFCT_Type) SetEVENTS_TXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXFRAMEEND.Reg, volatile.LoadUint32(&o.EVENTS_TXFRAMEEND.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_TXFRAMEEND() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXFRAMEEND.Reg) & 0x1
}

// NFCT.EVENTS_RXFRAMESTART: Marks the end of the first symbol of a received frame
func (o *NFCT_Type) SetEVENTS_RXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXFRAMESTART.Reg, volatile.LoadUint32(&o.EVENTS_RXFRAMESTART.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_RXFRAMESTART() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXFRAMESTART.Reg) & 0x1
}

// NFCT.EVENTS_RXFRAMEEND: Received data has been checked (CRC, parity) and transferred to RAM, and EasyDMA has ended accessing the RX buffer
func (o *NFCT_Type) SetEVENTS_RXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXFRAMEEND.Reg, volatile.LoadUint32(&o.EVENTS_RXFRAMEEND.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_RXFRAMEEND() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXFRAMEEND.Reg) & 0x1
}

// NFCT.EVENTS_ERROR: NFC error reported. The ERRORSTATUS register contains details on the source of the error.
func (o *NFCT_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// NFCT.EVENTS_RXERROR: NFC RX frame error reported. The FRAMESTATUS.RX register contains details on the source of the error.
func (o *NFCT_Type) SetEVENTS_RXERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXERROR.Reg, volatile.LoadUint32(&o.EVENTS_RXERROR.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_RXERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXERROR.Reg) & 0x1
}

// NFCT.EVENTS_ENDRX: RX buffer (as defined by PACKETPTR and MAXLEN) in Data RAM full.
func (o *NFCT_Type) SetEVENTS_ENDRX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDRX.Reg, volatile.LoadUint32(&o.EVENTS_ENDRX.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_ENDRX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDRX.Reg) & 0x1
}

// NFCT.EVENTS_ENDTX: Transmission of data in RAM has ended, and EasyDMA has ended accessing the TX buffer
func (o *NFCT_Type) SetEVENTS_ENDTX(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDTX.Reg, volatile.LoadUint32(&o.EVENTS_ENDTX.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_ENDTX() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDTX.Reg) & 0x1
}

// NFCT.EVENTS_AUTOCOLRESSTARTED: Auto collision resolution process has started
func (o *NFCT_Type) SetEVENTS_AUTOCOLRESSTARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_AUTOCOLRESSTARTED.Reg, volatile.LoadUint32(&o.EVENTS_AUTOCOLRESSTARTED.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_AUTOCOLRESSTARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_AUTOCOLRESSTARTED.Reg) & 0x1
}

// NFCT.EVENTS_COLLISION: NFC auto collision resolution error reported.
func (o *NFCT_Type) SetEVENTS_COLLISION(value uint32) {
	volatile.StoreUint32(&o.EVENTS_COLLISION.Reg, volatile.LoadUint32(&o.EVENTS_COLLISION.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_COLLISION() uint32 {
	return volatile.LoadUint32(&o.EVENTS_COLLISION.Reg) & 0x1
}

// NFCT.EVENTS_SELECTED: NFC auto collision resolution successfully completed
func (o *NFCT_Type) SetEVENTS_SELECTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SELECTED.Reg, volatile.LoadUint32(&o.EVENTS_SELECTED.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_SELECTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SELECTED.Reg) & 0x1
}

// NFCT.EVENTS_STARTED: EasyDMA is ready to receive or send frames.
func (o *NFCT_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// NFCT.SHORTS: Shortcuts between local events and tasks
func (o *NFCT_Type) SetSHORTS_FIELDDETECTED_ACTIVATE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetSHORTS_FIELDDETECTED_ACTIVATE() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *NFCT_Type) SetSHORTS_FIELDLOST_SENSE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *NFCT_Type) GetSHORTS_FIELDLOST_SENSE() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *NFCT_Type) SetSHORTS_TXFRAMEEND_ENABLERXDATA(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *NFCT_Type) GetSHORTS_TXFRAMEEND_ENABLERXDATA() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}

// NFCT.INTEN: Enable or disable interrupt
func (o *NFCT_Type) SetINTEN_READY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetINTEN_READY() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *NFCT_Type) SetINTEN_FIELDDETECTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *NFCT_Type) GetINTEN_FIELDDETECTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *NFCT_Type) SetINTEN_FIELDLOST(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_Type) GetINTEN_FIELDLOST() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *NFCT_Type) SetINTEN_TXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *NFCT_Type) GetINTEN_TXFRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *NFCT_Type) SetINTEN_TXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *NFCT_Type) GetINTEN_TXFRAMEEND() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *NFCT_Type) SetINTEN_RXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *NFCT_Type) GetINTEN_RXFRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *NFCT_Type) SetINTEN_RXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *NFCT_Type) GetINTEN_RXFRAMEEND() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *NFCT_Type) SetINTEN_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *NFCT_Type) GetINTEN_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *NFCT_Type) SetINTEN_RXERROR(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *NFCT_Type) GetINTEN_RXERROR() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *NFCT_Type) SetINTEN_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800)|value<<11)
}
func (o *NFCT_Type) GetINTEN_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800) >> 11
}
func (o *NFCT_Type) SetINTEN_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000)|value<<12)
}
func (o *NFCT_Type) GetINTEN_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000) >> 12
}
func (o *NFCT_Type) SetINTEN_AUTOCOLRESSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000)|value<<14)
}
func (o *NFCT_Type) GetINTEN_AUTOCOLRESSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000) >> 14
}
func (o *NFCT_Type) SetINTEN_COLLISION(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000)|value<<18)
}
func (o *NFCT_Type) GetINTEN_COLLISION() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000) >> 18
}
func (o *NFCT_Type) SetINTEN_SELECTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *NFCT_Type) GetINTEN_SELECTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *NFCT_Type) SetINTEN_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *NFCT_Type) GetINTEN_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}

// NFCT.INTENSET: Enable interrupt
func (o *NFCT_Type) SetINTENSET_READY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetINTENSET_READY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *NFCT_Type) SetINTENSET_FIELDDETECTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *NFCT_Type) GetINTENSET_FIELDDETECTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *NFCT_Type) SetINTENSET_FIELDLOST(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_Type) GetINTENSET_FIELDLOST() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *NFCT_Type) SetINTENSET_TXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *NFCT_Type) GetINTENSET_TXFRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *NFCT_Type) SetINTENSET_TXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *NFCT_Type) GetINTENSET_TXFRAMEEND() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *NFCT_Type) SetINTENSET_RXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *NFCT_Type) GetINTENSET_RXFRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *NFCT_Type) SetINTENSET_RXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *NFCT_Type) GetINTENSET_RXFRAMEEND() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *NFCT_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *NFCT_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *NFCT_Type) SetINTENSET_RXERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *NFCT_Type) GetINTENSET_RXERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *NFCT_Type) SetINTENSET_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *NFCT_Type) GetINTENSET_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *NFCT_Type) SetINTENSET_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *NFCT_Type) GetINTENSET_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *NFCT_Type) SetINTENSET_AUTOCOLRESSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *NFCT_Type) GetINTENSET_AUTOCOLRESSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *NFCT_Type) SetINTENSET_COLLISION(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *NFCT_Type) GetINTENSET_COLLISION() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *NFCT_Type) SetINTENSET_SELECTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *NFCT_Type) GetINTENSET_SELECTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *NFCT_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *NFCT_Type) GetINTENSET_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}

// NFCT.INTENCLR: Disable interrupt
func (o *NFCT_Type) SetINTENCLR_READY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetINTENCLR_READY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *NFCT_Type) SetINTENCLR_FIELDDETECTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *NFCT_Type) GetINTENCLR_FIELDDETECTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *NFCT_Type) SetINTENCLR_FIELDLOST(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_Type) GetINTENCLR_FIELDLOST() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *NFCT_Type) SetINTENCLR_TXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *NFCT_Type) GetINTENCLR_TXFRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *NFCT_Type) SetINTENCLR_TXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *NFCT_Type) GetINTENCLR_TXFRAMEEND() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *NFCT_Type) SetINTENCLR_RXFRAMESTART(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *NFCT_Type) GetINTENCLR_RXFRAMESTART() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *NFCT_Type) SetINTENCLR_RXFRAMEEND(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *NFCT_Type) GetINTENCLR_RXFRAMEEND() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *NFCT_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *NFCT_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *NFCT_Type) SetINTENCLR_RXERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *NFCT_Type) GetINTENCLR_RXERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *NFCT_Type) SetINTENCLR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *NFCT_Type) GetINTENCLR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *NFCT_Type) SetINTENCLR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *NFCT_Type) GetINTENCLR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *NFCT_Type) SetINTENCLR_AUTOCOLRESSTARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *NFCT_Type) GetINTENCLR_AUTOCOLRESSTARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *NFCT_Type) SetINTENCLR_COLLISION(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *NFCT_Type) GetINTENCLR_COLLISION() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *NFCT_Type) SetINTENCLR_SELECTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *NFCT_Type) GetINTENCLR_SELECTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *NFCT_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *NFCT_Type) GetINTENCLR_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}

// NFCT.ERRORSTATUS: NFC Error Status register
func (o *NFCT_Type) SetERRORSTATUS_FRAMEDELAYTIMEOUT(value uint32) {
	volatile.StoreUint32(&o.ERRORSTATUS.Reg, volatile.LoadUint32(&o.ERRORSTATUS.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetERRORSTATUS_FRAMEDELAYTIMEOUT() uint32 {
	return volatile.LoadUint32(&o.ERRORSTATUS.Reg) & 0x1
}

// NFCT.NFCTAGSTATE: NfcTag state register
func (o *NFCT_Type) SetNFCTAGSTATE(value uint32) {
	volatile.StoreUint32(&o.NFCTAGSTATE.Reg, volatile.LoadUint32(&o.NFCTAGSTATE.Reg)&^(0x7)|value)
}
func (o *NFCT_Type) GetNFCTAGSTATE() uint32 {
	return volatile.LoadUint32(&o.NFCTAGSTATE.Reg) & 0x7
}

// NFCT.SLEEPSTATE: Sleep state during automatic collision resolution
func (o *NFCT_Type) SetSLEEPSTATE(value uint32) {
	volatile.StoreUint32(&o.SLEEPSTATE.Reg, volatile.LoadUint32(&o.SLEEPSTATE.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetSLEEPSTATE() uint32 {
	return volatile.LoadUint32(&o.SLEEPSTATE.Reg) & 0x1
}

// NFCT.FIELDPRESENT: Indicates the presence or not of a valid field
func (o *NFCT_Type) SetFIELDPRESENT(value uint32) {
	volatile.StoreUint32(&o.FIELDPRESENT.Reg, volatile.LoadUint32(&o.FIELDPRESENT.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetFIELDPRESENT() uint32 {
	return volatile.LoadUint32(&o.FIELDPRESENT.Reg) & 0x1
}
func (o *NFCT_Type) SetFIELDPRESENT_LOCKDETECT(value uint32) {
	volatile.StoreUint32(&o.FIELDPRESENT.Reg, volatile.LoadUint32(&o.FIELDPRESENT.Reg)&^(0x2)|value<<1)
}
func (o *NFCT_Type) GetFIELDPRESENT_LOCKDETECT() uint32 {
	return (volatile.LoadUint32(&o.FIELDPRESENT.Reg) & 0x2) >> 1
}

// NFCT.FRAMEDELAYMIN: Minimum frame delay
func (o *NFCT_Type) SetFRAMEDELAYMIN(value uint32) {
	volatile.StoreUint32(&o.FRAMEDELAYMIN.Reg, volatile.LoadUint32(&o.FRAMEDELAYMIN.Reg)&^(0xffff)|value)
}
func (o *NFCT_Type) GetFRAMEDELAYMIN() uint32 {
	return volatile.LoadUint32(&o.FRAMEDELAYMIN.Reg) & 0xffff
}

// NFCT.FRAMEDELAYMAX: Maximum frame delay
func (o *NFCT_Type) SetFRAMEDELAYMAX(value uint32) {
	volatile.StoreUint32(&o.FRAMEDELAYMAX.Reg, volatile.LoadUint32(&o.FRAMEDELAYMAX.Reg)&^(0xfffff)|value)
}
func (o *NFCT_Type) GetFRAMEDELAYMAX() uint32 {
	return volatile.LoadUint32(&o.FRAMEDELAYMAX.Reg) & 0xfffff
}

// NFCT.FRAMEDELAYMODE: Configuration register for the Frame Delay Timer
func (o *NFCT_Type) SetFRAMEDELAYMODE(value uint32) {
	volatile.StoreUint32(&o.FRAMEDELAYMODE.Reg, volatile.LoadUint32(&o.FRAMEDELAYMODE.Reg)&^(0x3)|value)
}
func (o *NFCT_Type) GetFRAMEDELAYMODE() uint32 {
	return volatile.LoadUint32(&o.FRAMEDELAYMODE.Reg) & 0x3
}

// NFCT.PACKETPTR: Packet pointer for TXD and RXD data storage in Data RAM
func (o *NFCT_Type) SetPACKETPTR(value uint32) {
	volatile.StoreUint32(&o.PACKETPTR.Reg, value)
}
func (o *NFCT_Type) GetPACKETPTR() uint32 {
	return volatile.LoadUint32(&o.PACKETPTR.Reg)
}

// NFCT.MAXLEN: Size of the RAM buffer allocated to TXD and RXD data storage each
func (o *NFCT_Type) SetMAXLEN(value uint32) {
	volatile.StoreUint32(&o.MAXLEN.Reg, volatile.LoadUint32(&o.MAXLEN.Reg)&^(0x1ff)|value)
}
func (o *NFCT_Type) GetMAXLEN() uint32 {
	return volatile.LoadUint32(&o.MAXLEN.Reg) & 0x1ff
}

// NFCT.MODULATIONCTRL: Enables the modulation output to a GPIO pin which can be connected to a second external antenna.
func (o *NFCT_Type) SetMODULATIONCTRL(value uint32) {
	volatile.StoreUint32(&o.MODULATIONCTRL.Reg, volatile.LoadUint32(&o.MODULATIONCTRL.Reg)&^(0x3)|value)
}
func (o *NFCT_Type) GetMODULATIONCTRL() uint32 {
	return volatile.LoadUint32(&o.MODULATIONCTRL.Reg) & 0x3
}

// NFCT.MODULATIONPSEL: Pin select for Modulation control.
func (o *NFCT_Type) SetMODULATIONPSEL_PIN(value uint32) {
	volatile.StoreUint32(&o.MODULATIONPSEL.Reg, volatile.LoadUint32(&o.MODULATIONPSEL.Reg)&^(0x1f)|value)
}
func (o *NFCT_Type) GetMODULATIONPSEL_PIN() uint32 {
	return volatile.LoadUint32(&o.MODULATIONPSEL.Reg) & 0x1f
}
func (o *NFCT_Type) SetMODULATIONPSEL_PORT(value uint32) {
	volatile.StoreUint32(&o.MODULATIONPSEL.Reg, volatile.LoadUint32(&o.MODULATIONPSEL.Reg)&^(0x20)|value<<5)
}
func (o *NFCT_Type) GetMODULATIONPSEL_PORT() uint32 {
	return (volatile.LoadUint32(&o.MODULATIONPSEL.Reg) & 0x20) >> 5
}
func (o *NFCT_Type) SetMODULATIONPSEL_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MODULATIONPSEL.Reg, volatile.LoadUint32(&o.MODULATIONPSEL.Reg)&^(0x80000000)|value<<31)
}
func (o *NFCT_Type) GetMODULATIONPSEL_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MODULATIONPSEL.Reg) & 0x80000000) >> 31
}

// NFCT.NFCID1_LAST: Last NFCID1 part (4, 7 or 10 bytes ID)
func (o *NFCT_Type) SetNFCID1_LAST_NFCID1_Z(value uint32) {
	volatile.StoreUint32(&o.NFCID1_LAST.Reg, volatile.LoadUint32(&o.NFCID1_LAST.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetNFCID1_LAST_NFCID1_Z() uint32 {
	return volatile.LoadUint32(&o.NFCID1_LAST.Reg) & 0xff
}
func (o *NFCT_Type) SetNFCID1_LAST_NFCID1_Y(value uint32) {
	volatile.StoreUint32(&o.NFCID1_LAST.Reg, volatile.LoadUint32(&o.NFCID1_LAST.Reg)&^(0xff00)|value<<8)
}
func (o *NFCT_Type) GetNFCID1_LAST_NFCID1_Y() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_LAST.Reg) & 0xff00) >> 8
}
func (o *NFCT_Type) SetNFCID1_LAST_NFCID1_X(value uint32) {
	volatile.StoreUint32(&o.NFCID1_LAST.Reg, volatile.LoadUint32(&o.NFCID1_LAST.Reg)&^(0xff0000)|value<<16)
}
func (o *NFCT_Type) GetNFCID1_LAST_NFCID1_X() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_LAST.Reg) & 0xff0000) >> 16
}
func (o *NFCT_Type) SetNFCID1_LAST_NFCID1_W(value uint32) {
	volatile.StoreUint32(&o.NFCID1_LAST.Reg, volatile.LoadUint32(&o.NFCID1_LAST.Reg)&^(0xff000000)|value<<24)
}
func (o *NFCT_Type) GetNFCID1_LAST_NFCID1_W() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_LAST.Reg) & 0xff000000) >> 24
}

// NFCT.NFCID1_2ND_LAST: Second last NFCID1 part (7 or 10 bytes ID)
func (o *NFCT_Type) SetNFCID1_2ND_LAST_NFCID1_V(value uint32) {
	volatile.StoreUint32(&o.NFCID1_2ND_LAST.Reg, volatile.LoadUint32(&o.NFCID1_2ND_LAST.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetNFCID1_2ND_LAST_NFCID1_V() uint32 {
	return volatile.LoadUint32(&o.NFCID1_2ND_LAST.Reg) & 0xff
}
func (o *NFCT_Type) SetNFCID1_2ND_LAST_NFCID1_U(value uint32) {
	volatile.StoreUint32(&o.NFCID1_2ND_LAST.Reg, volatile.LoadUint32(&o.NFCID1_2ND_LAST.Reg)&^(0xff00)|value<<8)
}
func (o *NFCT_Type) GetNFCID1_2ND_LAST_NFCID1_U() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_2ND_LAST.Reg) & 0xff00) >> 8
}
func (o *NFCT_Type) SetNFCID1_2ND_LAST_NFCID1_T(value uint32) {
	volatile.StoreUint32(&o.NFCID1_2ND_LAST.Reg, volatile.LoadUint32(&o.NFCID1_2ND_LAST.Reg)&^(0xff0000)|value<<16)
}
func (o *NFCT_Type) GetNFCID1_2ND_LAST_NFCID1_T() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_2ND_LAST.Reg) & 0xff0000) >> 16
}

// NFCT.NFCID1_3RD_LAST: Third last NFCID1 part (10 bytes ID)
func (o *NFCT_Type) SetNFCID1_3RD_LAST_NFCID1_S(value uint32) {
	volatile.StoreUint32(&o.NFCID1_3RD_LAST.Reg, volatile.LoadUint32(&o.NFCID1_3RD_LAST.Reg)&^(0xff)|value)
}
func (o *NFCT_Type) GetNFCID1_3RD_LAST_NFCID1_S() uint32 {
	return volatile.LoadUint32(&o.NFCID1_3RD_LAST.Reg) & 0xff
}
func (o *NFCT_Type) SetNFCID1_3RD_LAST_NFCID1_R(value uint32) {
	volatile.StoreUint32(&o.NFCID1_3RD_LAST.Reg, volatile.LoadUint32(&o.NFCID1_3RD_LAST.Reg)&^(0xff00)|value<<8)
}
func (o *NFCT_Type) GetNFCID1_3RD_LAST_NFCID1_R() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_3RD_LAST.Reg) & 0xff00) >> 8
}
func (o *NFCT_Type) SetNFCID1_3RD_LAST_NFCID1_Q(value uint32) {
	volatile.StoreUint32(&o.NFCID1_3RD_LAST.Reg, volatile.LoadUint32(&o.NFCID1_3RD_LAST.Reg)&^(0xff0000)|value<<16)
}
func (o *NFCT_Type) GetNFCID1_3RD_LAST_NFCID1_Q() uint32 {
	return (volatile.LoadUint32(&o.NFCID1_3RD_LAST.Reg) & 0xff0000) >> 16
}

// NFCT.AUTOCOLRESCONFIG: Controls the auto collision resolution function. This setting must be done before the NFCT peripheral is activated.
func (o *NFCT_Type) SetAUTOCOLRESCONFIG_MODE(value uint32) {
	volatile.StoreUint32(&o.AUTOCOLRESCONFIG.Reg, volatile.LoadUint32(&o.AUTOCOLRESCONFIG.Reg)&^(0x1)|value)
}
func (o *NFCT_Type) GetAUTOCOLRESCONFIG_MODE() uint32 {
	return volatile.LoadUint32(&o.AUTOCOLRESCONFIG.Reg) & 0x1
}

// NFCT.SENSRES: NFC-A SENS_RES auto-response settings
func (o *NFCT_Type) SetSENSRES_BITFRAMESDD(value uint32) {
	volatile.StoreUint32(&o.SENSRES.Reg, volatile.LoadUint32(&o.SENSRES.Reg)&^(0x1f)|value)
}
func (o *NFCT_Type) GetSENSRES_BITFRAMESDD() uint32 {
	return volatile.LoadUint32(&o.SENSRES.Reg) & 0x1f
}
func (o *NFCT_Type) SetSENSRES_RFU5(value uint32) {
	volatile.StoreUint32(&o.SENSRES.Reg, volatile.LoadUint32(&o.SENSRES.Reg)&^(0x20)|value<<5)
}
func (o *NFCT_Type) GetSENSRES_RFU5() uint32 {
	return (volatile.LoadUint32(&o.SENSRES.Reg) & 0x20) >> 5
}
func (o *NFCT_Type) SetSENSRES_NFCIDSIZE(value uint32) {
	volatile.StoreUint32(&o.SENSRES.Reg, volatile.LoadUint32(&o.SENSRES.Reg)&^(0xc0)|value<<6)
}
func (o *NFCT_Type) GetSENSRES_NFCIDSIZE() uint32 {
	return (volatile.LoadUint32(&o.SENSRES.Reg) & 0xc0) >> 6
}
func (o *NFCT_Type) SetSENSRES_PLATFCONFIG(value uint32) {
	volatile.StoreUint32(&o.SENSRES.Reg, volatile.LoadUint32(&o.SENSRES.Reg)&^(0xf00)|value<<8)
}
func (o *NFCT_Type) GetSENSRES_PLATFCONFIG() uint32 {
	return (volatile.LoadUint32(&o.SENSRES.Reg) & 0xf00) >> 8
}
func (o *NFCT_Type) SetSENSRES_RFU74(value uint32) {
	volatile.StoreUint32(&o.SENSRES.Reg, volatile.LoadUint32(&o.SENSRES.Reg)&^(0xf000)|value<<12)
}
func (o *NFCT_Type) GetSENSRES_RFU74() uint32 {
	return (volatile.LoadUint32(&o.SENSRES.Reg) & 0xf000) >> 12
}

// NFCT.SELRES: NFC-A SEL_RES auto-response settings
func (o *NFCT_Type) SetSELRES_RFU10(value uint32) {
	volatile.StoreUint32(&o.SELRES.Reg, volatile.LoadUint32(&o.SELRES.Reg)&^(0x3)|value)
}
func (o *NFCT_Type) GetSELRES_RFU10() uint32 {
	return volatile.LoadUint32(&o.SELRES.Reg) & 0x3
}
func (o *NFCT_Type) SetSELRES_CASCADE(value uint32) {
	volatile.StoreUint32(&o.SELRES.Reg, volatile.LoadUint32(&o.SELRES.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_Type) GetSELRES_CASCADE() uint32 {
	return (volatile.LoadUint32(&o.SELRES.Reg) & 0x4) >> 2
}
func (o *NFCT_Type) SetSELRES_RFU43(value uint32) {
	volatile.StoreUint32(&o.SELRES.Reg, volatile.LoadUint32(&o.SELRES.Reg)&^(0x18)|value<<3)
}
func (o *NFCT_Type) GetSELRES_RFU43() uint32 {
	return (volatile.LoadUint32(&o.SELRES.Reg) & 0x18) >> 3
}
func (o *NFCT_Type) SetSELRES_PROTOCOL(value uint32) {
	volatile.StoreUint32(&o.SELRES.Reg, volatile.LoadUint32(&o.SELRES.Reg)&^(0x60)|value<<5)
}
func (o *NFCT_Type) GetSELRES_PROTOCOL() uint32 {
	return (volatile.LoadUint32(&o.SELRES.Reg) & 0x60) >> 5
}
func (o *NFCT_Type) SetSELRES_RFU7(value uint32) {
	volatile.StoreUint32(&o.SELRES.Reg, volatile.LoadUint32(&o.SELRES.Reg)&^(0x80)|value<<7)
}
func (o *NFCT_Type) GetSELRES_RFU7() uint32 {
	return (volatile.LoadUint32(&o.SELRES.Reg) & 0x80) >> 7
}

// Unspecified
type NFCT_FRAMESTATUS_Type struct {
	RX volatile.Register32 // 0x40C
}

// NFCT_FRAMESTATUS.RX: Result of last incoming frame
func (o *NFCT_FRAMESTATUS_Type) SetRX_CRCERROR(value uint32) {
	volatile.StoreUint32(&o.RX.Reg, volatile.LoadUint32(&o.RX.Reg)&^(0x1)|value)
}
func (o *NFCT_FRAMESTATUS_Type) GetRX_CRCERROR() uint32 {
	return volatile.LoadUint32(&o.RX.Reg) & 0x1
}
func (o *NFCT_FRAMESTATUS_Type) SetRX_PARITYSTATUS(value uint32) {
	volatile.StoreUint32(&o.RX.Reg, volatile.LoadUint32(&o.RX.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_FRAMESTATUS_Type) GetRX_PARITYSTATUS() uint32 {
	return (volatile.LoadUint32(&o.RX.Reg) & 0x4) >> 2
}
func (o *NFCT_FRAMESTATUS_Type) SetRX_OVERRUN(value uint32) {
	volatile.StoreUint32(&o.RX.Reg, volatile.LoadUint32(&o.RX.Reg)&^(0x8)|value<<3)
}
func (o *NFCT_FRAMESTATUS_Type) GetRX_OVERRUN() uint32 {
	return (volatile.LoadUint32(&o.RX.Reg) & 0x8) >> 3
}

// Unspecified
type NFCT_TXD_Type struct {
	FRAMECONFIG volatile.Register32 // 0x518
	AMOUNT      volatile.Register32 // 0x51C
}

// NFCT_TXD.FRAMECONFIG: Configuration of outgoing frames
func (o *NFCT_TXD_Type) SetFRAMECONFIG_PARITY(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x1)|value)
}
func (o *NFCT_TXD_Type) GetFRAMECONFIG_PARITY() uint32 {
	return volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x1
}
func (o *NFCT_TXD_Type) SetFRAMECONFIG_DISCARDMODE(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x2)|value<<1)
}
func (o *NFCT_TXD_Type) GetFRAMECONFIG_DISCARDMODE() uint32 {
	return (volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x2) >> 1
}
func (o *NFCT_TXD_Type) SetFRAMECONFIG_SOF(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_TXD_Type) GetFRAMECONFIG_SOF() uint32 {
	return (volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x4) >> 2
}
func (o *NFCT_TXD_Type) SetFRAMECONFIG_CRCMODETX(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x10)|value<<4)
}
func (o *NFCT_TXD_Type) GetFRAMECONFIG_CRCMODETX() uint32 {
	return (volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x10) >> 4
}

// NFCT_TXD.AMOUNT: Size of outgoing frame
func (o *NFCT_TXD_Type) SetAMOUNT_TXDATABITS(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x7)|value)
}
func (o *NFCT_TXD_Type) GetAMOUNT_TXDATABITS() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x7
}
func (o *NFCT_TXD_Type) SetAMOUNT_TXDATABYTES(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xff8)|value<<3)
}
func (o *NFCT_TXD_Type) GetAMOUNT_TXDATABYTES() uint32 {
	return (volatile.LoadUint32(&o.AMOUNT.Reg) & 0xff8) >> 3
}

// Unspecified
type NFCT_RXD_Type struct {
	FRAMECONFIG volatile.Register32 // 0x520
	AMOUNT      volatile.Register32 // 0x524
}

// NFCT_RXD.FRAMECONFIG: Configuration of incoming frames
func (o *NFCT_RXD_Type) SetFRAMECONFIG_PARITY(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x1)|value)
}
func (o *NFCT_RXD_Type) GetFRAMECONFIG_PARITY() uint32 {
	return volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x1
}
func (o *NFCT_RXD_Type) SetFRAMECONFIG_SOF(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x4)|value<<2)
}
func (o *NFCT_RXD_Type) GetFRAMECONFIG_SOF() uint32 {
	return (volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x4) >> 2
}
func (o *NFCT_RXD_Type) SetFRAMECONFIG_CRCMODERX(value uint32) {
	volatile.StoreUint32(&o.FRAMECONFIG.Reg, volatile.LoadUint32(&o.FRAMECONFIG.Reg)&^(0x10)|value<<4)
}
func (o *NFCT_RXD_Type) GetFRAMECONFIG_CRCMODERX() uint32 {
	return (volatile.LoadUint32(&o.FRAMECONFIG.Reg) & 0x10) >> 4
}

// NFCT_RXD.AMOUNT: Size of last incoming frame
func (o *NFCT_RXD_Type) SetAMOUNT_RXDATABITS(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x7)|value)
}
func (o *NFCT_RXD_Type) GetAMOUNT_RXDATABITS() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x7
}
func (o *NFCT_RXD_Type) SetAMOUNT_RXDATABYTES(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0xff8)|value<<3)
}
func (o *NFCT_RXD_Type) GetAMOUNT_RXDATABYTES() uint32 {
	return (volatile.LoadUint32(&o.AMOUNT.Reg) & 0xff8) >> 3
}

// GPIO Tasks and Events
type GPIOTE_Type struct {
	TASKS_OUT   [8]volatile.Register32 // 0x0
	_           [16]byte
	TASKS_SET   [8]volatile.Register32 // 0x30
	_           [16]byte
	TASKS_CLR   [8]volatile.Register32 // 0x60
	_           [128]byte
	EVENTS_IN   [8]volatile.Register32 // 0x100
	_           [92]byte
	EVENTS_PORT volatile.Register32 // 0x17C
	_           [388]byte
	INTENSET    volatile.Register32 // 0x304
	INTENCLR    volatile.Register32 // 0x308
	_           [516]byte
	CONFIG      [8]volatile.Register32 // 0x510
}

// GPIOTE.TASKS_OUT: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is configured in CONFIG[n].POLARITY.
func (o *GPIOTE_Type) SetTASKS_OUT(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_OUT[idx].Reg, volatile.LoadUint32(&o.TASKS_OUT[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetTASKS_OUT(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_OUT[idx].Reg) & 0x1
}

// GPIOTE.TASKS_SET: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it high.
func (o *GPIOTE_Type) SetTASKS_SET(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_SET[idx].Reg, volatile.LoadUint32(&o.TASKS_SET[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetTASKS_SET(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_SET[idx].Reg) & 0x1
}

// GPIOTE.TASKS_CLR: Description collection: Task for writing to pin specified in CONFIG[n].PSEL. Action on pin is to set it low.
func (o *GPIOTE_Type) SetTASKS_CLR(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_CLR[idx].Reg, volatile.LoadUint32(&o.TASKS_CLR[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetTASKS_CLR(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_CLR[idx].Reg) & 0x1
}

// GPIOTE.EVENTS_IN: Description collection: Event generated from pin specified in CONFIG[n].PSEL
func (o *GPIOTE_Type) SetEVENTS_IN(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_IN[idx].Reg, volatile.LoadUint32(&o.EVENTS_IN[idx].Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetEVENTS_IN(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_IN[idx].Reg) & 0x1
}

// GPIOTE.EVENTS_PORT: Event generated from multiple input GPIO pins with SENSE mechanism enabled
func (o *GPIOTE_Type) SetEVENTS_PORT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_PORT.Reg, volatile.LoadUint32(&o.EVENTS_PORT.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetEVENTS_PORT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_PORT.Reg) & 0x1
}

// GPIOTE.INTENSET: Enable interrupt
func (o *GPIOTE_Type) SetINTENSET_IN0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetINTENSET_IN0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *GPIOTE_Type) SetINTENSET_IN1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *GPIOTE_Type) GetINTENSET_IN1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *GPIOTE_Type) SetINTENSET_IN2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *GPIOTE_Type) GetINTENSET_IN2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *GPIOTE_Type) SetINTENSET_IN3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *GPIOTE_Type) GetINTENSET_IN3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *GPIOTE_Type) SetINTENSET_IN4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *GPIOTE_Type) GetINTENSET_IN4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *GPIOTE_Type) SetINTENSET_IN5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *GPIOTE_Type) GetINTENSET_IN5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *GPIOTE_Type) SetINTENSET_IN6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *GPIOTE_Type) GetINTENSET_IN6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *GPIOTE_Type) SetINTENSET_IN7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *GPIOTE_Type) GetINTENSET_IN7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *GPIOTE_Type) SetINTENSET_PORT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetINTENSET_PORT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000000) >> 31
}

// GPIOTE.INTENCLR: Disable interrupt
func (o *GPIOTE_Type) SetINTENCLR_IN0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *GPIOTE_Type) GetINTENCLR_IN0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *GPIOTE_Type) SetINTENCLR_IN1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPIOTE_Type) GetINTENCLR_IN1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *GPIOTE_Type) SetINTENCLR_IN2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPIOTE_Type) GetINTENCLR_IN2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *GPIOTE_Type) SetINTENCLR_IN3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPIOTE_Type) GetINTENCLR_IN3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *GPIOTE_Type) SetINTENCLR_IN4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPIOTE_Type) GetINTENCLR_IN4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *GPIOTE_Type) SetINTENCLR_IN5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPIOTE_Type) GetINTENCLR_IN5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *GPIOTE_Type) SetINTENCLR_IN6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPIOTE_Type) GetINTENCLR_IN6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *GPIOTE_Type) SetINTENCLR_IN7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPIOTE_Type) GetINTENCLR_IN7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *GPIOTE_Type) SetINTENCLR_PORT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPIOTE_Type) GetINTENCLR_PORT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000000) >> 31
}

// GPIOTE.CONFIG: Description collection: Configuration for OUT[n], SET[n], and CLR[n] tasks and IN[n] event
func (o *GPIOTE_Type) SetCONFIG_MODE(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x3)|value)
}
func (o *GPIOTE_Type) GetCONFIG_MODE(idx int) uint32 {
	return volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x3
}
func (o *GPIOTE_Type) SetCONFIG_PSEL(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x1f00)|value<<8)
}
func (o *GPIOTE_Type) GetCONFIG_PSEL(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x1f00) >> 8
}
func (o *GPIOTE_Type) SetCONFIG_PORT(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x2000)|value<<13)
}
func (o *GPIOTE_Type) GetCONFIG_PORT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x2000) >> 13
}
func (o *GPIOTE_Type) SetCONFIG_POLARITY(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *GPIOTE_Type) GetCONFIG_POLARITY(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x30000) >> 16
}
func (o *GPIOTE_Type) SetCONFIG_OUTINIT(idx int, value uint32) {
	volatile.StoreUint32(&o.CONFIG[idx].Reg, volatile.LoadUint32(&o.CONFIG[idx].Reg)&^(0x100000)|value<<20)
}
func (o *GPIOTE_Type) GetCONFIG_OUTINIT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CONFIG[idx].Reg) & 0x100000) >> 20
}

// Successive approximation register (SAR) analog-to-digital converter
type SAADC_Type struct {
	TASKS_START           volatile.Register32 // 0x0
	TASKS_SAMPLE          volatile.Register32 // 0x4
	TASKS_STOP            volatile.Register32 // 0x8
	TASKS_CALIBRATEOFFSET volatile.Register32 // 0xC
	_                     [240]byte
	EVENTS_STARTED        volatile.Register32     // 0x100
	EVENTS_END            volatile.Register32     // 0x104
	EVENTS_DONE           volatile.Register32     // 0x108
	EVENTS_RESULTDONE     volatile.Register32     // 0x10C
	EVENTS_CALIBRATEDONE  volatile.Register32     // 0x110
	EVENTS_STOPPED        volatile.Register32     // 0x114
	EVENTS_CH             [8]SAADC_EVENTS_CH_Type // 0x118
	_                     [424]byte
	INTEN                 volatile.Register32 // 0x300
	INTENSET              volatile.Register32 // 0x304
	INTENCLR              volatile.Register32 // 0x308
	_                     [244]byte
	STATUS                volatile.Register32 // 0x400
	_                     [252]byte
	ENABLE                volatile.Register32 // 0x500
	_                     [12]byte
	CH                    [8]SAADC_CH_Type // 0x510
	_                     [96]byte
	RESOLUTION            volatile.Register32 // 0x5F0
	OVERSAMPLE            volatile.Register32 // 0x5F4
	SAMPLERATE            volatile.Register32 // 0x5F8
	_                     [48]byte
	RESULT                SAADC_RESULT_Type // 0x62C
}

// SAADC.TASKS_START: Starts the SAADC and prepares the result buffer in RAM
func (o *SAADC_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// SAADC.TASKS_SAMPLE: Takes one SAADC sample
func (o *SAADC_Type) SetTASKS_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.TASKS_SAMPLE.Reg, volatile.LoadUint32(&o.TASKS_SAMPLE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetTASKS_SAMPLE() uint32 {
	return volatile.LoadUint32(&o.TASKS_SAMPLE.Reg) & 0x1
}

// SAADC.TASKS_STOP: Stops the SAADC and terminates all on-going conversions
func (o *SAADC_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// SAADC.TASKS_CALIBRATEOFFSET: Starts offset auto-calibration
func (o *SAADC_Type) SetTASKS_CALIBRATEOFFSET(value uint32) {
	volatile.StoreUint32(&o.TASKS_CALIBRATEOFFSET.Reg, volatile.LoadUint32(&o.TASKS_CALIBRATEOFFSET.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetTASKS_CALIBRATEOFFSET() uint32 {
	return volatile.LoadUint32(&o.TASKS_CALIBRATEOFFSET.Reg) & 0x1
}

// SAADC.EVENTS_STARTED: The SAADC has started
func (o *SAADC_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// SAADC.EVENTS_END: The SAADC has filled up the result buffer
func (o *SAADC_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// SAADC.EVENTS_DONE: A conversion task has been completed. Depending on the configuration, multiple conversions might be needed for a result to be transferred to RAM.
func (o *SAADC_Type) SetEVENTS_DONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DONE.Reg, volatile.LoadUint32(&o.EVENTS_DONE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_DONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DONE.Reg) & 0x1
}

// SAADC.EVENTS_RESULTDONE: Result ready for transfer to RAM
func (o *SAADC_Type) SetEVENTS_RESULTDONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RESULTDONE.Reg, volatile.LoadUint32(&o.EVENTS_RESULTDONE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_RESULTDONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RESULTDONE.Reg) & 0x1
}

// SAADC.EVENTS_CALIBRATEDONE: Calibration is complete
func (o *SAADC_Type) SetEVENTS_CALIBRATEDONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CALIBRATEDONE.Reg, volatile.LoadUint32(&o.EVENTS_CALIBRATEDONE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_CALIBRATEDONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CALIBRATEDONE.Reg) & 0x1
}

// SAADC.EVENTS_STOPPED: The SAADC has stopped
func (o *SAADC_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// SAADC.INTEN: Enable or disable interrupt
func (o *SAADC_Type) SetINTEN_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetINTEN_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *SAADC_Type) SetINTEN_END(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *SAADC_Type) GetINTEN_END() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *SAADC_Type) SetINTEN_DONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *SAADC_Type) GetINTEN_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *SAADC_Type) SetINTEN_RESULTDONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *SAADC_Type) GetINTEN_RESULTDONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *SAADC_Type) SetINTEN_CALIBRATEDONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *SAADC_Type) GetINTEN_CALIBRATEDONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *SAADC_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *SAADC_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *SAADC_Type) SetINTEN_CH0LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *SAADC_Type) GetINTEN_CH0LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *SAADC_Type) SetINTEN_CH0LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *SAADC_Type) GetINTEN_CH0LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *SAADC_Type) SetINTEN_CH1LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *SAADC_Type) GetINTEN_CH1LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *SAADC_Type) SetINTEN_CH1LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *SAADC_Type) GetINTEN_CH1LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *SAADC_Type) SetINTEN_CH2LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *SAADC_Type) GetINTEN_CH2LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *SAADC_Type) SetINTEN_CH2LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800)|value<<11)
}
func (o *SAADC_Type) GetINTEN_CH2LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800) >> 11
}
func (o *SAADC_Type) SetINTEN_CH3LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_Type) GetINTEN_CH3LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000) >> 12
}
func (o *SAADC_Type) SetINTEN_CH3LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000)|value<<13)
}
func (o *SAADC_Type) GetINTEN_CH3LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000) >> 13
}
func (o *SAADC_Type) SetINTEN_CH4LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000)|value<<14)
}
func (o *SAADC_Type) GetINTEN_CH4LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000) >> 14
}
func (o *SAADC_Type) SetINTEN_CH4LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000)|value<<15)
}
func (o *SAADC_Type) GetINTEN_CH4LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000) >> 15
}
func (o *SAADC_Type) SetINTEN_CH5LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10000)|value<<16)
}
func (o *SAADC_Type) GetINTEN_CH5LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10000) >> 16
}
func (o *SAADC_Type) SetINTEN_CH5LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20000)|value<<17)
}
func (o *SAADC_Type) GetINTEN_CH5LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20000) >> 17
}
func (o *SAADC_Type) SetINTEN_CH6LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000)|value<<18)
}
func (o *SAADC_Type) GetINTEN_CH6LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000) >> 18
}
func (o *SAADC_Type) SetINTEN_CH6LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *SAADC_Type) GetINTEN_CH6LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *SAADC_Type) SetINTEN_CH7LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *SAADC_Type) GetINTEN_CH7LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *SAADC_Type) SetINTEN_CH7LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200000)|value<<21)
}
func (o *SAADC_Type) GetINTEN_CH7LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200000) >> 21
}

// SAADC.INTENSET: Enable interrupt
func (o *SAADC_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetINTENSET_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *SAADC_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SAADC_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SAADC_Type) SetINTENSET_DONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SAADC_Type) GetINTENSET_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SAADC_Type) SetINTENSET_RESULTDONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SAADC_Type) GetINTENSET_RESULTDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SAADC_Type) SetINTENSET_CALIBRATEDONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SAADC_Type) GetINTENSET_CALIBRATEDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SAADC_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *SAADC_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *SAADC_Type) SetINTENSET_CH0LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *SAADC_Type) GetINTENSET_CH0LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *SAADC_Type) SetINTENSET_CH0LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SAADC_Type) GetINTENSET_CH0LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *SAADC_Type) SetINTENSET_CH1LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *SAADC_Type) GetINTENSET_CH1LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *SAADC_Type) SetINTENSET_CH1LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *SAADC_Type) GetINTENSET_CH1LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *SAADC_Type) SetINTENSET_CH2LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *SAADC_Type) GetINTENSET_CH2LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *SAADC_Type) SetINTENSET_CH2LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *SAADC_Type) GetINTENSET_CH2LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *SAADC_Type) SetINTENSET_CH3LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_Type) GetINTENSET_CH3LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *SAADC_Type) SetINTENSET_CH3LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *SAADC_Type) GetINTENSET_CH3LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *SAADC_Type) SetINTENSET_CH4LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *SAADC_Type) GetINTENSET_CH4LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *SAADC_Type) SetINTENSET_CH4LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *SAADC_Type) GetINTENSET_CH4LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *SAADC_Type) SetINTENSET_CH5LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *SAADC_Type) GetINTENSET_CH5LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *SAADC_Type) SetINTENSET_CH5LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *SAADC_Type) GetINTENSET_CH5LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *SAADC_Type) SetINTENSET_CH6LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *SAADC_Type) GetINTENSET_CH6LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *SAADC_Type) SetINTENSET_CH6LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *SAADC_Type) GetINTENSET_CH6LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *SAADC_Type) SetINTENSET_CH7LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *SAADC_Type) GetINTENSET_CH7LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *SAADC_Type) SetINTENSET_CH7LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200000)|value<<21)
}
func (o *SAADC_Type) GetINTENSET_CH7LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200000) >> 21
}

// SAADC.INTENCLR: Disable interrupt
func (o *SAADC_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetINTENCLR_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *SAADC_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SAADC_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SAADC_Type) SetINTENCLR_DONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SAADC_Type) GetINTENCLR_DONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SAADC_Type) SetINTENCLR_RESULTDONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SAADC_Type) GetINTENCLR_RESULTDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SAADC_Type) SetINTENCLR_CALIBRATEDONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SAADC_Type) GetINTENCLR_CALIBRATEDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SAADC_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *SAADC_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *SAADC_Type) SetINTENCLR_CH0LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *SAADC_Type) GetINTENCLR_CH0LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *SAADC_Type) SetINTENCLR_CH0LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SAADC_Type) GetINTENCLR_CH0LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *SAADC_Type) SetINTENCLR_CH1LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *SAADC_Type) GetINTENCLR_CH1LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *SAADC_Type) SetINTENCLR_CH1LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *SAADC_Type) GetINTENCLR_CH1LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *SAADC_Type) SetINTENCLR_CH2LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *SAADC_Type) GetINTENCLR_CH2LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *SAADC_Type) SetINTENCLR_CH2LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *SAADC_Type) GetINTENCLR_CH2LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *SAADC_Type) SetINTENCLR_CH3LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_Type) GetINTENCLR_CH3LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *SAADC_Type) SetINTENCLR_CH3LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *SAADC_Type) GetINTENCLR_CH3LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *SAADC_Type) SetINTENCLR_CH4LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *SAADC_Type) GetINTENCLR_CH4LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *SAADC_Type) SetINTENCLR_CH4LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *SAADC_Type) GetINTENCLR_CH4LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *SAADC_Type) SetINTENCLR_CH5LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *SAADC_Type) GetINTENCLR_CH5LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *SAADC_Type) SetINTENCLR_CH5LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *SAADC_Type) GetINTENCLR_CH5LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *SAADC_Type) SetINTENCLR_CH6LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *SAADC_Type) GetINTENCLR_CH6LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *SAADC_Type) SetINTENCLR_CH6LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *SAADC_Type) GetINTENCLR_CH6LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *SAADC_Type) SetINTENCLR_CH7LIMITH(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *SAADC_Type) GetINTENCLR_CH7LIMITH() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *SAADC_Type) SetINTENCLR_CH7LIMITL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *SAADC_Type) GetINTENCLR_CH7LIMITL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200000) >> 21
}

// SAADC.STATUS: Status
func (o *SAADC_Type) SetSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetSTATUS() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}

// SAADC.ENABLE: Enable or disable SAADC
func (o *SAADC_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *SAADC_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// SAADC.RESOLUTION: Resolution configuration
func (o *SAADC_Type) SetRESOLUTION_VAL(value uint32) {
	volatile.StoreUint32(&o.RESOLUTION.Reg, volatile.LoadUint32(&o.RESOLUTION.Reg)&^(0x7)|value)
}
func (o *SAADC_Type) GetRESOLUTION_VAL() uint32 {
	return volatile.LoadUint32(&o.RESOLUTION.Reg) & 0x7
}

// SAADC.OVERSAMPLE: Oversampling configuration. The RESOLUTION is applied before averaging, thus for high OVERSAMPLE a higher RESOLUTION should be used.
func (o *SAADC_Type) SetOVERSAMPLE(value uint32) {
	volatile.StoreUint32(&o.OVERSAMPLE.Reg, volatile.LoadUint32(&o.OVERSAMPLE.Reg)&^(0xf)|value)
}
func (o *SAADC_Type) GetOVERSAMPLE() uint32 {
	return volatile.LoadUint32(&o.OVERSAMPLE.Reg) & 0xf
}

// SAADC.SAMPLERATE: Controls normal or continuous sample rate
func (o *SAADC_Type) SetSAMPLERATE_CC(value uint32) {
	volatile.StoreUint32(&o.SAMPLERATE.Reg, volatile.LoadUint32(&o.SAMPLERATE.Reg)&^(0x7ff)|value)
}
func (o *SAADC_Type) GetSAMPLERATE_CC() uint32 {
	return volatile.LoadUint32(&o.SAMPLERATE.Reg) & 0x7ff
}
func (o *SAADC_Type) SetSAMPLERATE_MODE(value uint32) {
	volatile.StoreUint32(&o.SAMPLERATE.Reg, volatile.LoadUint32(&o.SAMPLERATE.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_Type) GetSAMPLERATE_MODE() uint32 {
	return (volatile.LoadUint32(&o.SAMPLERATE.Reg) & 0x1000) >> 12
}

// Peripheral events.
type SAADC_EVENTS_CH_Type struct {
	LIMITH volatile.Register32 // 0x118
	LIMITL volatile.Register32 // 0x11C
}

// SAADC_EVENTS_CH.LIMITH: Description cluster: Last result is equal or above CH[n].LIMIT.HIGH
func (o *SAADC_EVENTS_CH_Type) SetLIMITH(value uint32) {
	volatile.StoreUint32(&o.LIMITH.Reg, volatile.LoadUint32(&o.LIMITH.Reg)&^(0x1)|value)
}
func (o *SAADC_EVENTS_CH_Type) GetLIMITH() uint32 {
	return volatile.LoadUint32(&o.LIMITH.Reg) & 0x1
}

// SAADC_EVENTS_CH.LIMITL: Description cluster: Last result is equal or below CH[n].LIMIT.LOW
func (o *SAADC_EVENTS_CH_Type) SetLIMITL(value uint32) {
	volatile.StoreUint32(&o.LIMITL.Reg, volatile.LoadUint32(&o.LIMITL.Reg)&^(0x1)|value)
}
func (o *SAADC_EVENTS_CH_Type) GetLIMITL() uint32 {
	return volatile.LoadUint32(&o.LIMITL.Reg) & 0x1
}

// Unspecified
type SAADC_CH_Type struct {
	PSELP  volatile.Register32 // 0x510
	PSELN  volatile.Register32 // 0x514
	CONFIG volatile.Register32 // 0x518
	LIMIT  volatile.Register32 // 0x51C
}

// SAADC_CH.PSELP: Description cluster: Input positive pin selection for CH[n]
func (o *SAADC_CH_Type) SetPSELP(value uint32) {
	volatile.StoreUint32(&o.PSELP.Reg, volatile.LoadUint32(&o.PSELP.Reg)&^(0x1f)|value)
}
func (o *SAADC_CH_Type) GetPSELP() uint32 {
	return volatile.LoadUint32(&o.PSELP.Reg) & 0x1f
}

// SAADC_CH.PSELN: Description cluster: Input negative pin selection for CH[n]
func (o *SAADC_CH_Type) SetPSELN(value uint32) {
	volatile.StoreUint32(&o.PSELN.Reg, volatile.LoadUint32(&o.PSELN.Reg)&^(0x1f)|value)
}
func (o *SAADC_CH_Type) GetPSELN() uint32 {
	return volatile.LoadUint32(&o.PSELN.Reg) & 0x1f
}

// SAADC_CH.CONFIG: Description cluster: Input configuration for CH[n]
func (o *SAADC_CH_Type) SetCONFIG_RESP(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x3)|value)
}
func (o *SAADC_CH_Type) GetCONFIG_RESP() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x3
}
func (o *SAADC_CH_Type) SetCONFIG_RESN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x30)|value<<4)
}
func (o *SAADC_CH_Type) GetCONFIG_RESN() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x30) >> 4
}
func (o *SAADC_CH_Type) SetCONFIG_GAIN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x700)|value<<8)
}
func (o *SAADC_CH_Type) GetCONFIG_GAIN() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x700) >> 8
}
func (o *SAADC_CH_Type) SetCONFIG_REFSEL(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1000)|value<<12)
}
func (o *SAADC_CH_Type) GetCONFIG_REFSEL() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x1000) >> 12
}
func (o *SAADC_CH_Type) SetCONFIG_TACQ(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x70000)|value<<16)
}
func (o *SAADC_CH_Type) GetCONFIG_TACQ() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x70000) >> 16
}
func (o *SAADC_CH_Type) SetCONFIG_MODE(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x100000)|value<<20)
}
func (o *SAADC_CH_Type) GetCONFIG_MODE() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x100000) >> 20
}
func (o *SAADC_CH_Type) SetCONFIG_BURST(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1000000)|value<<24)
}
func (o *SAADC_CH_Type) GetCONFIG_BURST() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x1000000) >> 24
}

// SAADC_CH.LIMIT: Description cluster: High/low limits for event monitoring of a channel
func (o *SAADC_CH_Type) SetLIMIT_LOW(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffff)|value)
}
func (o *SAADC_CH_Type) GetLIMIT_LOW() uint32 {
	return volatile.LoadUint32(&o.LIMIT.Reg) & 0xffff
}
func (o *SAADC_CH_Type) SetLIMIT_HIGH(value uint32) {
	volatile.StoreUint32(&o.LIMIT.Reg, volatile.LoadUint32(&o.LIMIT.Reg)&^(0xffff0000)|value<<16)
}
func (o *SAADC_CH_Type) GetLIMIT_HIGH() uint32 {
	return (volatile.LoadUint32(&o.LIMIT.Reg) & 0xffff0000) >> 16
}

// RESULT EasyDMA channel
type SAADC_RESULT_Type struct {
	PTR    volatile.Register32 // 0x62C
	MAXCNT volatile.Register32 // 0x630
	AMOUNT volatile.Register32 // 0x634
}

// SAADC_RESULT.PTR: Data pointer
func (o *SAADC_RESULT_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *SAADC_RESULT_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// SAADC_RESULT.MAXCNT: Maximum number of 16-bit samples to be written to output RAM buffer
func (o *SAADC_RESULT_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x7fff)|value)
}
func (o *SAADC_RESULT_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x7fff
}

// SAADC_RESULT.AMOUNT: Number of 16-bit samples written to output RAM buffer since the previous START task
func (o *SAADC_RESULT_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x7fff)|value)
}
func (o *SAADC_RESULT_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x7fff
}

// Timer/Counter 0
type TIMER_Type struct {
	TASKS_START    volatile.Register32 // 0x0
	TASKS_STOP     volatile.Register32 // 0x4
	TASKS_COUNT    volatile.Register32 // 0x8
	TASKS_CLEAR    volatile.Register32 // 0xC
	TASKS_SHUTDOWN volatile.Register32 // 0x10
	_              [44]byte
	TASKS_CAPTURE  [6]volatile.Register32 // 0x40
	_              [232]byte
	EVENTS_COMPARE [6]volatile.Register32 // 0x140
	_              [168]byte
	SHORTS         volatile.Register32 // 0x200
	_              [256]byte
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [504]byte
	MODE           volatile.Register32 // 0x504
	BITMODE        volatile.Register32 // 0x508
	_              [4]byte
	PRESCALER      volatile.Register32 // 0x510
	_              [44]byte
	CC             [6]volatile.Register32 // 0x540
}

// TIMER.TASKS_START: Start Timer
func (o *TIMER_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// TIMER.TASKS_STOP: Stop Timer
func (o *TIMER_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TIMER.TASKS_COUNT: Increment Timer (Counter mode only)
func (o *TIMER_Type) SetTASKS_COUNT(value uint32) {
	volatile.StoreUint32(&o.TASKS_COUNT.Reg, volatile.LoadUint32(&o.TASKS_COUNT.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_COUNT() uint32 {
	return volatile.LoadUint32(&o.TASKS_COUNT.Reg) & 0x1
}

// TIMER.TASKS_CLEAR: Clear time
func (o *TIMER_Type) SetTASKS_CLEAR(value uint32) {
	volatile.StoreUint32(&o.TASKS_CLEAR.Reg, volatile.LoadUint32(&o.TASKS_CLEAR.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_CLEAR() uint32 {
	return volatile.LoadUint32(&o.TASKS_CLEAR.Reg) & 0x1
}

// TIMER.TASKS_SHUTDOWN: Deprecated register - Shut down timer
func (o *TIMER_Type) SetTASKS_SHUTDOWN(value uint32) {
	volatile.StoreUint32(&o.TASKS_SHUTDOWN.Reg, volatile.LoadUint32(&o.TASKS_SHUTDOWN.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_SHUTDOWN() uint32 {
	return volatile.LoadUint32(&o.TASKS_SHUTDOWN.Reg) & 0x1
}

// TIMER.TASKS_CAPTURE: Description collection: Capture Timer value to CC[n] register
func (o *TIMER_Type) SetTASKS_CAPTURE(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_CAPTURE[idx].Reg, volatile.LoadUint32(&o.TASKS_CAPTURE[idx].Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetTASKS_CAPTURE(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_CAPTURE[idx].Reg) & 0x1
}

// TIMER.EVENTS_COMPARE: Description collection: Compare event on CC[n] match
func (o *TIMER_Type) SetEVENTS_COMPARE(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_COMPARE[idx].Reg, volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetEVENTS_COMPARE(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg) & 0x1
}

// TIMER.SHORTS: Shortcuts between local events and tasks
func (o *TIMER_Type) SetSHORTS_COMPARE0_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *TIMER_Type) GetSHORTS_COMPARE0_CLEAR() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *TIMER_Type) SetSHORTS_COMPARE1_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *TIMER_Type) GetSHORTS_COMPARE1_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *TIMER_Type) SetSHORTS_COMPARE2_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *TIMER_Type) GetSHORTS_COMPARE2_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *TIMER_Type) SetSHORTS_COMPARE3_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *TIMER_Type) GetSHORTS_COMPARE3_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *TIMER_Type) SetSHORTS_COMPARE4_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *TIMER_Type) GetSHORTS_COMPARE4_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}
func (o *TIMER_Type) SetSHORTS_COMPARE5_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *TIMER_Type) GetSHORTS_COMPARE5_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}
func (o *TIMER_Type) SetSHORTS_COMPARE0_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x100)|value<<8)
}
func (o *TIMER_Type) GetSHORTS_COMPARE0_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x100) >> 8
}
func (o *TIMER_Type) SetSHORTS_COMPARE1_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x200)|value<<9)
}
func (o *TIMER_Type) GetSHORTS_COMPARE1_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x200) >> 9
}
func (o *TIMER_Type) SetSHORTS_COMPARE2_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x400)|value<<10)
}
func (o *TIMER_Type) GetSHORTS_COMPARE2_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x400) >> 10
}
func (o *TIMER_Type) SetSHORTS_COMPARE3_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x800)|value<<11)
}
func (o *TIMER_Type) GetSHORTS_COMPARE3_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x800) >> 11
}
func (o *TIMER_Type) SetSHORTS_COMPARE4_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1000)|value<<12)
}
func (o *TIMER_Type) GetSHORTS_COMPARE4_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x1000) >> 12
}
func (o *TIMER_Type) SetSHORTS_COMPARE5_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2000)|value<<13)
}
func (o *TIMER_Type) GetSHORTS_COMPARE5_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2000) >> 13
}

// TIMER.INTENSET: Enable interrupt
func (o *TIMER_Type) SetINTENSET_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *TIMER_Type) GetINTENSET_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *TIMER_Type) SetINTENSET_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *TIMER_Type) GetINTENSET_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *TIMER_Type) SetINTENSET_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *TIMER_Type) GetINTENSET_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *TIMER_Type) SetINTENSET_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TIMER_Type) GetINTENSET_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *TIMER_Type) SetINTENSET_COMPARE4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *TIMER_Type) GetINTENSET_COMPARE4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *TIMER_Type) SetINTENSET_COMPARE5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200000)|value<<21)
}
func (o *TIMER_Type) GetINTENSET_COMPARE5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200000) >> 21
}

// TIMER.INTENCLR: Disable interrupt
func (o *TIMER_Type) SetINTENCLR_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *TIMER_Type) SetINTENCLR_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *TIMER_Type) SetINTENCLR_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *TIMER_Type) SetINTENCLR_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *TIMER_Type) SetINTENCLR_COMPARE4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *TIMER_Type) SetINTENCLR_COMPARE5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *TIMER_Type) GetINTENCLR_COMPARE5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200000) >> 21
}

// TIMER.MODE: Timer mode selection
func (o *TIMER_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x3)|value)
}
func (o *TIMER_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x3
}

// TIMER.BITMODE: Configure the number of bits used by the TIMER
func (o *TIMER_Type) SetBITMODE(value uint32) {
	volatile.StoreUint32(&o.BITMODE.Reg, volatile.LoadUint32(&o.BITMODE.Reg)&^(0x3)|value)
}
func (o *TIMER_Type) GetBITMODE() uint32 {
	return volatile.LoadUint32(&o.BITMODE.Reg) & 0x3
}

// TIMER.PRESCALER: Timer prescaler register
func (o *TIMER_Type) SetPRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESCALER.Reg, volatile.LoadUint32(&o.PRESCALER.Reg)&^(0xf)|value)
}
func (o *TIMER_Type) GetPRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESCALER.Reg) & 0xf
}

// TIMER.CC: Description collection: Capture/Compare register n
func (o *TIMER_Type) SetCC(idx int, value uint32) {
	volatile.StoreUint32(&o.CC[idx].Reg, value)
}
func (o *TIMER_Type) GetCC(idx int) uint32 {
	return volatile.LoadUint32(&o.CC[idx].Reg)
}

// Real time counter 0
type RTC_Type struct {
	TASKS_START      volatile.Register32 // 0x0
	TASKS_STOP       volatile.Register32 // 0x4
	TASKS_CLEAR      volatile.Register32 // 0x8
	TASKS_TRIGOVRFLW volatile.Register32 // 0xC
	_                [240]byte
	EVENTS_TICK      volatile.Register32 // 0x100
	EVENTS_OVRFLW    volatile.Register32 // 0x104
	_                [56]byte
	EVENTS_COMPARE   [4]volatile.Register32 // 0x140
	_                [436]byte
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [52]byte
	EVTEN            volatile.Register32 // 0x340
	EVTENSET         volatile.Register32 // 0x344
	EVTENCLR         volatile.Register32 // 0x348
	_                [440]byte
	COUNTER          volatile.Register32 // 0x504
	PRESCALER        volatile.Register32 // 0x508
	_                [52]byte
	CC               [4]volatile.Register32 // 0x540
}

// RTC.TASKS_START: Start RTC COUNTER
func (o *RTC_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// RTC.TASKS_STOP: Stop RTC COUNTER
func (o *RTC_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// RTC.TASKS_CLEAR: Clear RTC COUNTER
func (o *RTC_Type) SetTASKS_CLEAR(value uint32) {
	volatile.StoreUint32(&o.TASKS_CLEAR.Reg, volatile.LoadUint32(&o.TASKS_CLEAR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_CLEAR() uint32 {
	return volatile.LoadUint32(&o.TASKS_CLEAR.Reg) & 0x1
}

// RTC.TASKS_TRIGOVRFLW: Set COUNTER to 0xFFFFF0
func (o *RTC_Type) SetTASKS_TRIGOVRFLW(value uint32) {
	volatile.StoreUint32(&o.TASKS_TRIGOVRFLW.Reg, volatile.LoadUint32(&o.TASKS_TRIGOVRFLW.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetTASKS_TRIGOVRFLW() uint32 {
	return volatile.LoadUint32(&o.TASKS_TRIGOVRFLW.Reg) & 0x1
}

// RTC.EVENTS_TICK: Event on COUNTER increment
func (o *RTC_Type) SetEVENTS_TICK(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TICK.Reg, volatile.LoadUint32(&o.EVENTS_TICK.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVENTS_TICK() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TICK.Reg) & 0x1
}

// RTC.EVENTS_OVRFLW: Event on COUNTER overflow
func (o *RTC_Type) SetEVENTS_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVENTS_OVRFLW.Reg, volatile.LoadUint32(&o.EVENTS_OVRFLW.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVENTS_OVRFLW() uint32 {
	return volatile.LoadUint32(&o.EVENTS_OVRFLW.Reg) & 0x1
}

// RTC.EVENTS_COMPARE: Description collection: Compare event on CC[n] match
func (o *RTC_Type) SetEVENTS_COMPARE(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_COMPARE[idx].Reg, volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVENTS_COMPARE(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_COMPARE[idx].Reg) & 0x1
}

// RTC.INTENSET: Enable interrupt
func (o *RTC_Type) SetINTENSET_TICK(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetINTENSET_TICK() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *RTC_Type) SetINTENSET_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetINTENSET_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetINTENSET_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetINTENSET_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetINTENSET_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetINTENSET_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetINTENSET_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetINTENSET_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetINTENSET_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetINTENSET_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}

// RTC.INTENCLR: Disable interrupt
func (o *RTC_Type) SetINTENCLR_TICK(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetINTENCLR_TICK() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *RTC_Type) SetINTENCLR_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetINTENCLR_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetINTENCLR_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetINTENCLR_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetINTENCLR_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetINTENCLR_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetINTENCLR_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetINTENCLR_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetINTENCLR_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetINTENCLR_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}

// RTC.EVTEN: Enable or disable event routing
func (o *RTC_Type) SetEVTEN_TICK(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVTEN_TICK() uint32 {
	return volatile.LoadUint32(&o.EVTEN.Reg) & 0x1
}
func (o *RTC_Type) SetEVTEN_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetEVTEN_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetEVTEN_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetEVTEN_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetEVTEN_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetEVTEN_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetEVTEN_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetEVTEN_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetEVTEN_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.EVTEN.Reg, volatile.LoadUint32(&o.EVTEN.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetEVTEN_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.EVTEN.Reg) & 0x80000) >> 19
}

// RTC.EVTENSET: Enable event routing
func (o *RTC_Type) SetEVTENSET_TICK(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVTENSET_TICK() uint32 {
	return volatile.LoadUint32(&o.EVTENSET.Reg) & 0x1
}
func (o *RTC_Type) SetEVTENSET_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetEVTENSET_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetEVTENSET_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetEVTENSET_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetEVTENSET_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetEVTENSET_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetEVTENSET_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetEVTENSET_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetEVTENSET_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.EVTENSET.Reg, volatile.LoadUint32(&o.EVTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetEVTENSET_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.EVTENSET.Reg) & 0x80000) >> 19
}

// RTC.EVTENCLR: Disable event routing
func (o *RTC_Type) SetEVTENCLR_TICK(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_Type) GetEVTENCLR_TICK() uint32 {
	return volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x1
}
func (o *RTC_Type) SetEVTENCLR_OVRFLW(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_Type) GetEVTENCLR_OVRFLW() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_Type) SetEVTENCLR_COMPARE0(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE0() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x10000) >> 16
}
func (o *RTC_Type) SetEVTENCLR_COMPARE1(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE1() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x20000) >> 17
}
func (o *RTC_Type) SetEVTENCLR_COMPARE2(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE2() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x40000) >> 18
}
func (o *RTC_Type) SetEVTENCLR_COMPARE3(value uint32) {
	volatile.StoreUint32(&o.EVTENCLR.Reg, volatile.LoadUint32(&o.EVTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_Type) GetEVTENCLR_COMPARE3() uint32 {
	return (volatile.LoadUint32(&o.EVTENCLR.Reg) & 0x80000) >> 19
}

// RTC.COUNTER: Current COUNTER value
func (o *RTC_Type) SetCOUNTER(value uint32) {
	volatile.StoreUint32(&o.COUNTER.Reg, volatile.LoadUint32(&o.COUNTER.Reg)&^(0xffffff)|value)
}
func (o *RTC_Type) GetCOUNTER() uint32 {
	return volatile.LoadUint32(&o.COUNTER.Reg) & 0xffffff
}

// RTC.PRESCALER: 12 bit prescaler for COUNTER frequency (32768/(PRESCALER+1)).Must be written when RTC is stopped
func (o *RTC_Type) SetPRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESCALER.Reg, volatile.LoadUint32(&o.PRESCALER.Reg)&^(0xfff)|value)
}
func (o *RTC_Type) GetPRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESCALER.Reg) & 0xfff
}

// RTC.CC: Description collection: Compare register n
func (o *RTC_Type) SetCC_COMPARE(idx int, value uint32) {
	volatile.StoreUint32(&o.CC[idx].Reg, volatile.LoadUint32(&o.CC[idx].Reg)&^(0xffffff)|value)
}
func (o *RTC_Type) GetCC_COMPARE(idx int) uint32 {
	return volatile.LoadUint32(&o.CC[idx].Reg) & 0xffffff
}

// Temperature Sensor
type TEMP_Type struct {
	TASKS_START    volatile.Register32 // 0x0
	TASKS_STOP     volatile.Register32 // 0x4
	_              [248]byte
	EVENTS_DATARDY volatile.Register32 // 0x100
	_              [512]byte
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [508]byte
	TEMP           volatile.Register32 // 0x508
	_              [20]byte
	A0             volatile.Register32 // 0x520
	A1             volatile.Register32 // 0x524
	A2             volatile.Register32 // 0x528
	A3             volatile.Register32 // 0x52C
	A4             volatile.Register32 // 0x530
	A5             volatile.Register32 // 0x534
	_              [8]byte
	B0             volatile.Register32 // 0x540
	B1             volatile.Register32 // 0x544
	B2             volatile.Register32 // 0x548
	B3             volatile.Register32 // 0x54C
	B4             volatile.Register32 // 0x550
	B5             volatile.Register32 // 0x554
	_              [8]byte
	T0             volatile.Register32 // 0x560
	T1             volatile.Register32 // 0x564
	T2             volatile.Register32 // 0x568
	T3             volatile.Register32 // 0x56C
	T4             volatile.Register32 // 0x570
}

// TEMP.TASKS_START: Start temperature measurement
func (o *TEMP_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *TEMP_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// TEMP.TASKS_STOP: Stop temperature measurement
func (o *TEMP_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *TEMP_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// TEMP.EVENTS_DATARDY: Temperature measurement complete, data ready
func (o *TEMP_Type) SetEVENTS_DATARDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DATARDY.Reg, volatile.LoadUint32(&o.EVENTS_DATARDY.Reg)&^(0x1)|value)
}
func (o *TEMP_Type) GetEVENTS_DATARDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DATARDY.Reg) & 0x1
}

// TEMP.INTENSET: Enable interrupt
func (o *TEMP_Type) SetINTENSET_DATARDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TEMP_Type) GetINTENSET_DATARDY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}

// TEMP.INTENCLR: Disable interrupt
func (o *TEMP_Type) SetINTENCLR_DATARDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TEMP_Type) GetINTENCLR_DATARDY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}

// TEMP.TEMP: Temperature in degC (0.25deg steps)
func (o *TEMP_Type) SetTEMP(value uint32) {
	volatile.StoreUint32(&o.TEMP.Reg, value)
}
func (o *TEMP_Type) GetTEMP() uint32 {
	return volatile.LoadUint32(&o.TEMP.Reg)
}

// TEMP.A0: Slope of 1st piece wise linear function
func (o *TEMP_Type) SetA0(value uint32) {
	volatile.StoreUint32(&o.A0.Reg, volatile.LoadUint32(&o.A0.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetA0() uint32 {
	return volatile.LoadUint32(&o.A0.Reg) & 0xfff
}

// TEMP.A1: Slope of 2nd piece wise linear function
func (o *TEMP_Type) SetA1(value uint32) {
	volatile.StoreUint32(&o.A1.Reg, volatile.LoadUint32(&o.A1.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetA1() uint32 {
	return volatile.LoadUint32(&o.A1.Reg) & 0xfff
}

// TEMP.A2: Slope of 3rd piece wise linear function
func (o *TEMP_Type) SetA2(value uint32) {
	volatile.StoreUint32(&o.A2.Reg, volatile.LoadUint32(&o.A2.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetA2() uint32 {
	return volatile.LoadUint32(&o.A2.Reg) & 0xfff
}

// TEMP.A3: Slope of 4th piece wise linear function
func (o *TEMP_Type) SetA3(value uint32) {
	volatile.StoreUint32(&o.A3.Reg, volatile.LoadUint32(&o.A3.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetA3() uint32 {
	return volatile.LoadUint32(&o.A3.Reg) & 0xfff
}

// TEMP.A4: Slope of 5th piece wise linear function
func (o *TEMP_Type) SetA4(value uint32) {
	volatile.StoreUint32(&o.A4.Reg, volatile.LoadUint32(&o.A4.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetA4() uint32 {
	return volatile.LoadUint32(&o.A4.Reg) & 0xfff
}

// TEMP.A5: Slope of 6th piece wise linear function
func (o *TEMP_Type) SetA5(value uint32) {
	volatile.StoreUint32(&o.A5.Reg, volatile.LoadUint32(&o.A5.Reg)&^(0xfff)|value)
}
func (o *TEMP_Type) GetA5() uint32 {
	return volatile.LoadUint32(&o.A5.Reg) & 0xfff
}

// TEMP.B0: y-intercept of 1st piece wise linear function
func (o *TEMP_Type) SetB0(value uint32) {
	volatile.StoreUint32(&o.B0.Reg, volatile.LoadUint32(&o.B0.Reg)&^(0x3fff)|value)
}
func (o *TEMP_Type) GetB0() uint32 {
	return volatile.LoadUint32(&o.B0.Reg) & 0x3fff
}

// TEMP.B1: y-intercept of 2nd piece wise linear function
func (o *TEMP_Type) SetB1(value uint32) {
	volatile.StoreUint32(&o.B1.Reg, volatile.LoadUint32(&o.B1.Reg)&^(0x3fff)|value)
}
func (o *TEMP_Type) GetB1() uint32 {
	return volatile.LoadUint32(&o.B1.Reg) & 0x3fff
}

// TEMP.B2: y-intercept of 3rd piece wise linear function
func (o *TEMP_Type) SetB2(value uint32) {
	volatile.StoreUint32(&o.B2.Reg, volatile.LoadUint32(&o.B2.Reg)&^(0x3fff)|value)
}
func (o *TEMP_Type) GetB2() uint32 {
	return volatile.LoadUint32(&o.B2.Reg) & 0x3fff
}

// TEMP.B3: y-intercept of 4th piece wise linear function
func (o *TEMP_Type) SetB3(value uint32) {
	volatile.StoreUint32(&o.B3.Reg, volatile.LoadUint32(&o.B3.Reg)&^(0x3fff)|value)
}
func (o *TEMP_Type) GetB3() uint32 {
	return volatile.LoadUint32(&o.B3.Reg) & 0x3fff
}

// TEMP.B4: y-intercept of 5th piece wise linear function
func (o *TEMP_Type) SetB4(value uint32) {
	volatile.StoreUint32(&o.B4.Reg, volatile.LoadUint32(&o.B4.Reg)&^(0x3fff)|value)
}
func (o *TEMP_Type) GetB4() uint32 {
	return volatile.LoadUint32(&o.B4.Reg) & 0x3fff
}

// TEMP.B5: y-intercept of 6th piece wise linear function
func (o *TEMP_Type) SetB5(value uint32) {
	volatile.StoreUint32(&o.B5.Reg, volatile.LoadUint32(&o.B5.Reg)&^(0x3fff)|value)
}
func (o *TEMP_Type) GetB5() uint32 {
	return volatile.LoadUint32(&o.B5.Reg) & 0x3fff
}

// TEMP.T0: End point of 1st piece wise linear function
func (o *TEMP_Type) SetT0(value uint32) {
	volatile.StoreUint32(&o.T0.Reg, volatile.LoadUint32(&o.T0.Reg)&^(0xff)|value)
}
func (o *TEMP_Type) GetT0() uint32 {
	return volatile.LoadUint32(&o.T0.Reg) & 0xff
}

// TEMP.T1: End point of 2nd piece wise linear function
func (o *TEMP_Type) SetT1(value uint32) {
	volatile.StoreUint32(&o.T1.Reg, volatile.LoadUint32(&o.T1.Reg)&^(0xff)|value)
}
func (o *TEMP_Type) GetT1() uint32 {
	return volatile.LoadUint32(&o.T1.Reg) & 0xff
}

// TEMP.T2: End point of 3rd piece wise linear function
func (o *TEMP_Type) SetT2(value uint32) {
	volatile.StoreUint32(&o.T2.Reg, volatile.LoadUint32(&o.T2.Reg)&^(0xff)|value)
}
func (o *TEMP_Type) GetT2() uint32 {
	return volatile.LoadUint32(&o.T2.Reg) & 0xff
}

// TEMP.T3: End point of 4th piece wise linear function
func (o *TEMP_Type) SetT3(value uint32) {
	volatile.StoreUint32(&o.T3.Reg, volatile.LoadUint32(&o.T3.Reg)&^(0xff)|value)
}
func (o *TEMP_Type) GetT3() uint32 {
	return volatile.LoadUint32(&o.T3.Reg) & 0xff
}

// TEMP.T4: End point of 5th piece wise linear function
func (o *TEMP_Type) SetT4(value uint32) {
	volatile.StoreUint32(&o.T4.Reg, volatile.LoadUint32(&o.T4.Reg)&^(0xff)|value)
}
func (o *TEMP_Type) GetT4() uint32 {
	return volatile.LoadUint32(&o.T4.Reg) & 0xff
}

// Random Number Generator
type RNG_Type struct {
	TASKS_START   volatile.Register32 // 0x0
	TASKS_STOP    volatile.Register32 // 0x4
	_             [248]byte
	EVENTS_VALRDY volatile.Register32 // 0x100
	_             [252]byte
	SHORTS        volatile.Register32 // 0x200
	_             [256]byte
	INTENSET      volatile.Register32 // 0x304
	INTENCLR      volatile.Register32 // 0x308
	_             [504]byte
	CONFIG        volatile.Register32 // 0x504
	VALUE         volatile.Register32 // 0x508
}

// RNG.TASKS_START: Task starting the random number generator
func (o *RNG_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// RNG.TASKS_STOP: Task stopping the random number generator
func (o *RNG_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// RNG.EVENTS_VALRDY: Event being generated for every new random number written to the VALUE register
func (o *RNG_Type) SetEVENTS_VALRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_VALRDY.Reg, volatile.LoadUint32(&o.EVENTS_VALRDY.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetEVENTS_VALRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_VALRDY.Reg) & 0x1
}

// RNG.SHORTS: Shortcuts between local events and tasks
func (o *RNG_Type) SetSHORTS_VALRDY_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetSHORTS_VALRDY_STOP() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}

// RNG.INTENSET: Enable interrupt
func (o *RNG_Type) SetINTENSET_VALRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetINTENSET_VALRDY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}

// RNG.INTENCLR: Disable interrupt
func (o *RNG_Type) SetINTENCLR_VALRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetINTENCLR_VALRDY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}

// RNG.CONFIG: Configuration register
func (o *RNG_Type) SetCONFIG_DERCEN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *RNG_Type) GetCONFIG_DERCEN() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}

// RNG.VALUE: Output random number
func (o *RNG_Type) SetVALUE(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0xff)|value)
}
func (o *RNG_Type) GetVALUE() uint32 {
	return volatile.LoadUint32(&o.VALUE.Reg) & 0xff
}

// AES ECB Mode Encryption
type ECB_Type struct {
	TASKS_STARTECB  volatile.Register32 // 0x0
	TASKS_STOPECB   volatile.Register32 // 0x4
	_               [248]byte
	EVENTS_ENDECB   volatile.Register32 // 0x100
	EVENTS_ERRORECB volatile.Register32 // 0x104
	_               [508]byte
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [504]byte
	ECBDATAPTR      volatile.Register32 // 0x504
}

// ECB.TASKS_STARTECB: Start ECB block encrypt
func (o *ECB_Type) SetTASKS_STARTECB(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTECB.Reg, volatile.LoadUint32(&o.TASKS_STARTECB.Reg)&^(0x1)|value)
}
func (o *ECB_Type) GetTASKS_STARTECB() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTECB.Reg) & 0x1
}

// ECB.TASKS_STOPECB: Abort a possible executing ECB operation
func (o *ECB_Type) SetTASKS_STOPECB(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOPECB.Reg, volatile.LoadUint32(&o.TASKS_STOPECB.Reg)&^(0x1)|value)
}
func (o *ECB_Type) GetTASKS_STOPECB() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOPECB.Reg) & 0x1
}

// ECB.EVENTS_ENDECB: ECB block encrypt complete
func (o *ECB_Type) SetEVENTS_ENDECB(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDECB.Reg, volatile.LoadUint32(&o.EVENTS_ENDECB.Reg)&^(0x1)|value)
}
func (o *ECB_Type) GetEVENTS_ENDECB() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDECB.Reg) & 0x1
}

// ECB.EVENTS_ERRORECB: ECB block encrypt aborted because of a STOPECB task or due to an error
func (o *ECB_Type) SetEVENTS_ERRORECB(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERRORECB.Reg, volatile.LoadUint32(&o.EVENTS_ERRORECB.Reg)&^(0x1)|value)
}
func (o *ECB_Type) GetEVENTS_ERRORECB() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERRORECB.Reg) & 0x1
}

// ECB.INTENSET: Enable interrupt
func (o *ECB_Type) SetINTENSET_ENDECB(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *ECB_Type) GetINTENSET_ENDECB() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *ECB_Type) SetINTENSET_ERRORECB(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *ECB_Type) GetINTENSET_ERRORECB() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}

// ECB.INTENCLR: Disable interrupt
func (o *ECB_Type) SetINTENCLR_ENDECB(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *ECB_Type) GetINTENCLR_ENDECB() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *ECB_Type) SetINTENCLR_ERRORECB(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *ECB_Type) GetINTENCLR_ERRORECB() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}

// ECB.ECBDATAPTR: ECB block encrypt memory pointers
func (o *ECB_Type) SetECBDATAPTR(value uint32) {
	volatile.StoreUint32(&o.ECBDATAPTR.Reg, value)
}
func (o *ECB_Type) GetECBDATAPTR() uint32 {
	return volatile.LoadUint32(&o.ECBDATAPTR.Reg)
}

// Accelerated Address Resolver
type AAR_Type struct {
	TASKS_START        volatile.Register32 // 0x0
	_                  [4]byte
	TASKS_STOP         volatile.Register32 // 0x8
	_                  [244]byte
	EVENTS_END         volatile.Register32 // 0x100
	EVENTS_RESOLVED    volatile.Register32 // 0x104
	EVENTS_NOTRESOLVED volatile.Register32 // 0x108
	_                  [504]byte
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [244]byte
	STATUS             volatile.Register32 // 0x400
	_                  [252]byte
	ENABLE             volatile.Register32 // 0x500
	NIRK               volatile.Register32 // 0x504
	IRKPTR             volatile.Register32 // 0x508
	_                  [4]byte
	ADDRPTR            volatile.Register32 // 0x510
	SCRATCHPTR         volatile.Register32 // 0x514
}

// AAR.TASKS_START: Start resolving addresses based on IRKs specified in the IRK data structure
func (o *AAR_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// AAR.TASKS_STOP: Stop resolving addresses
func (o *AAR_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// AAR.EVENTS_END: Address resolution procedure complete
func (o *AAR_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// AAR.EVENTS_RESOLVED: Address resolved
func (o *AAR_Type) SetEVENTS_RESOLVED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RESOLVED.Reg, volatile.LoadUint32(&o.EVENTS_RESOLVED.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetEVENTS_RESOLVED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RESOLVED.Reg) & 0x1
}

// AAR.EVENTS_NOTRESOLVED: Address not resolved
func (o *AAR_Type) SetEVENTS_NOTRESOLVED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_NOTRESOLVED.Reg, volatile.LoadUint32(&o.EVENTS_NOTRESOLVED.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetEVENTS_NOTRESOLVED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_NOTRESOLVED.Reg) & 0x1
}

// AAR.INTENSET: Enable interrupt
func (o *AAR_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetINTENSET_END() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *AAR_Type) SetINTENSET_RESOLVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *AAR_Type) GetINTENSET_RESOLVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *AAR_Type) SetINTENSET_NOTRESOLVED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *AAR_Type) GetINTENSET_NOTRESOLVED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// AAR.INTENCLR: Disable interrupt
func (o *AAR_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *AAR_Type) GetINTENCLR_END() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *AAR_Type) SetINTENCLR_RESOLVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *AAR_Type) GetINTENCLR_RESOLVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *AAR_Type) SetINTENCLR_NOTRESOLVED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *AAR_Type) GetINTENCLR_NOTRESOLVED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// AAR.STATUS: Resolution status
func (o *AAR_Type) SetSTATUS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0xf)|value)
}
func (o *AAR_Type) GetSTATUS() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0xf
}

// AAR.ENABLE: Enable AAR
func (o *AAR_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x3)|value)
}
func (o *AAR_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x3
}

// AAR.NIRK: Number of IRKs
func (o *AAR_Type) SetNIRK(value uint32) {
	volatile.StoreUint32(&o.NIRK.Reg, volatile.LoadUint32(&o.NIRK.Reg)&^(0x1f)|value)
}
func (o *AAR_Type) GetNIRK() uint32 {
	return volatile.LoadUint32(&o.NIRK.Reg) & 0x1f
}

// AAR.IRKPTR: Pointer to IRK data structure
func (o *AAR_Type) SetIRKPTR(value uint32) {
	volatile.StoreUint32(&o.IRKPTR.Reg, value)
}
func (o *AAR_Type) GetIRKPTR() uint32 {
	return volatile.LoadUint32(&o.IRKPTR.Reg)
}

// AAR.ADDRPTR: Pointer to the resolvable address
func (o *AAR_Type) SetADDRPTR(value uint32) {
	volatile.StoreUint32(&o.ADDRPTR.Reg, value)
}
func (o *AAR_Type) GetADDRPTR() uint32 {
	return volatile.LoadUint32(&o.ADDRPTR.Reg)
}

// AAR.SCRATCHPTR: Pointer to data area used for temporary storage
func (o *AAR_Type) SetSCRATCHPTR(value uint32) {
	volatile.StoreUint32(&o.SCRATCHPTR.Reg, value)
}
func (o *AAR_Type) GetSCRATCHPTR() uint32 {
	return volatile.LoadUint32(&o.SCRATCHPTR.Reg)
}

// AES CCM Mode Encryption
type CCM_Type struct {
	TASKS_KSGEN        volatile.Register32 // 0x0
	TASKS_CRYPT        volatile.Register32 // 0x4
	TASKS_STOP         volatile.Register32 // 0x8
	TASKS_RATEOVERRIDE volatile.Register32 // 0xC
	_                  [240]byte
	EVENTS_ENDKSGEN    volatile.Register32 // 0x100
	EVENTS_ENDCRYPT    volatile.Register32 // 0x104
	EVENTS_ERROR       volatile.Register32 // 0x108
	_                  [244]byte
	SHORTS             volatile.Register32 // 0x200
	_                  [256]byte
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [244]byte
	MICSTATUS          volatile.Register32 // 0x400
	_                  [252]byte
	ENABLE             volatile.Register32 // 0x500
	MODE               volatile.Register32 // 0x504
	CNFPTR             volatile.Register32 // 0x508
	INPTR              volatile.Register32 // 0x50C
	OUTPTR             volatile.Register32 // 0x510
	SCRATCHPTR         volatile.Register32 // 0x514
	MAXPACKETSIZE      volatile.Register32 // 0x518
	RATEOVERRIDE       volatile.Register32 // 0x51C
}

// CCM.TASKS_KSGEN: Start generation of key-stream. This operation will stop by itself when completed.
func (o *CCM_Type) SetTASKS_KSGEN(value uint32) {
	volatile.StoreUint32(&o.TASKS_KSGEN.Reg, volatile.LoadUint32(&o.TASKS_KSGEN.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetTASKS_KSGEN() uint32 {
	return volatile.LoadUint32(&o.TASKS_KSGEN.Reg) & 0x1
}

// CCM.TASKS_CRYPT: Start encryption/decryption. This operation will stop by itself when completed.
func (o *CCM_Type) SetTASKS_CRYPT(value uint32) {
	volatile.StoreUint32(&o.TASKS_CRYPT.Reg, volatile.LoadUint32(&o.TASKS_CRYPT.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetTASKS_CRYPT() uint32 {
	return volatile.LoadUint32(&o.TASKS_CRYPT.Reg) & 0x1
}

// CCM.TASKS_STOP: Stop encryption/decryption
func (o *CCM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// CCM.TASKS_RATEOVERRIDE: Override DATARATE setting in MODE register with the contents of the RATEOVERRIDE register for any ongoing encryption/decryption
func (o *CCM_Type) SetTASKS_RATEOVERRIDE(value uint32) {
	volatile.StoreUint32(&o.TASKS_RATEOVERRIDE.Reg, volatile.LoadUint32(&o.TASKS_RATEOVERRIDE.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetTASKS_RATEOVERRIDE() uint32 {
	return volatile.LoadUint32(&o.TASKS_RATEOVERRIDE.Reg) & 0x1
}

// CCM.EVENTS_ENDKSGEN: Key-stream generation complete
func (o *CCM_Type) SetEVENTS_ENDKSGEN(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDKSGEN.Reg, volatile.LoadUint32(&o.EVENTS_ENDKSGEN.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetEVENTS_ENDKSGEN() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDKSGEN.Reg) & 0x1
}

// CCM.EVENTS_ENDCRYPT: Encrypt/decrypt complete
func (o *CCM_Type) SetEVENTS_ENDCRYPT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDCRYPT.Reg, volatile.LoadUint32(&o.EVENTS_ENDCRYPT.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetEVENTS_ENDCRYPT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDCRYPT.Reg) & 0x1
}

// CCM.EVENTS_ERROR: Deprecated register - CCM error event
func (o *CCM_Type) SetEVENTS_ERROR(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ERROR.Reg, volatile.LoadUint32(&o.EVENTS_ERROR.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetEVENTS_ERROR() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ERROR.Reg) & 0x1
}

// CCM.SHORTS: Shortcuts between local events and tasks
func (o *CCM_Type) SetSHORTS_ENDKSGEN_CRYPT(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetSHORTS_ENDKSGEN_CRYPT() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}

// CCM.INTENSET: Enable interrupt
func (o *CCM_Type) SetINTENSET_ENDKSGEN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetINTENSET_ENDKSGEN() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *CCM_Type) SetINTENSET_ENDCRYPT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *CCM_Type) GetINTENSET_ENDCRYPT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *CCM_Type) SetINTENSET_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *CCM_Type) GetINTENSET_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// CCM.INTENCLR: Disable interrupt
func (o *CCM_Type) SetINTENCLR_ENDKSGEN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetINTENCLR_ENDKSGEN() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *CCM_Type) SetINTENCLR_ENDCRYPT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *CCM_Type) GetINTENCLR_ENDCRYPT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *CCM_Type) SetINTENCLR_ERROR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *CCM_Type) GetINTENCLR_ERROR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// CCM.MICSTATUS: MIC check result
func (o *CCM_Type) SetMICSTATUS(value uint32) {
	volatile.StoreUint32(&o.MICSTATUS.Reg, volatile.LoadUint32(&o.MICSTATUS.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetMICSTATUS() uint32 {
	return volatile.LoadUint32(&o.MICSTATUS.Reg) & 0x1
}

// CCM.ENABLE: Enable
func (o *CCM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x3)|value)
}
func (o *CCM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x3
}

// CCM.MODE: Operation mode
func (o *CCM_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *CCM_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}
func (o *CCM_Type) SetMODE_DATARATE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x30000)|value<<16)
}
func (o *CCM_Type) GetMODE_DATARATE() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x30000) >> 16
}
func (o *CCM_Type) SetMODE_LENGTH(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1000000)|value<<24)
}
func (o *CCM_Type) GetMODE_LENGTH() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x1000000) >> 24
}

// CCM.CNFPTR: Pointer to data structure holding AES key and NONCE vector
func (o *CCM_Type) SetCNFPTR(value uint32) {
	volatile.StoreUint32(&o.CNFPTR.Reg, value)
}
func (o *CCM_Type) GetCNFPTR() uint32 {
	return volatile.LoadUint32(&o.CNFPTR.Reg)
}

// CCM.INPTR: Input pointer
func (o *CCM_Type) SetINPTR(value uint32) {
	volatile.StoreUint32(&o.INPTR.Reg, value)
}
func (o *CCM_Type) GetINPTR() uint32 {
	return volatile.LoadUint32(&o.INPTR.Reg)
}

// CCM.OUTPTR: Output pointer
func (o *CCM_Type) SetOUTPTR(value uint32) {
	volatile.StoreUint32(&o.OUTPTR.Reg, value)
}
func (o *CCM_Type) GetOUTPTR() uint32 {
	return volatile.LoadUint32(&o.OUTPTR.Reg)
}

// CCM.SCRATCHPTR: Pointer to data area used for temporary storage
func (o *CCM_Type) SetSCRATCHPTR(value uint32) {
	volatile.StoreUint32(&o.SCRATCHPTR.Reg, value)
}
func (o *CCM_Type) GetSCRATCHPTR() uint32 {
	return volatile.LoadUint32(&o.SCRATCHPTR.Reg)
}

// CCM.MAXPACKETSIZE: Length of key-stream generated when MODE.LENGTH = Extended.
func (o *CCM_Type) SetMAXPACKETSIZE(value uint32) {
	volatile.StoreUint32(&o.MAXPACKETSIZE.Reg, volatile.LoadUint32(&o.MAXPACKETSIZE.Reg)&^(0xff)|value)
}
func (o *CCM_Type) GetMAXPACKETSIZE() uint32 {
	return volatile.LoadUint32(&o.MAXPACKETSIZE.Reg) & 0xff
}

// CCM.RATEOVERRIDE: Data rate override setting.
func (o *CCM_Type) SetRATEOVERRIDE(value uint32) {
	volatile.StoreUint32(&o.RATEOVERRIDE.Reg, volatile.LoadUint32(&o.RATEOVERRIDE.Reg)&^(0x3)|value)
}
func (o *CCM_Type) GetRATEOVERRIDE() uint32 {
	return volatile.LoadUint32(&o.RATEOVERRIDE.Reg) & 0x3
}

// Watchdog Timer
type WDT_Type struct {
	TASKS_START    volatile.Register32 // 0x0
	_              [252]byte
	EVENTS_TIMEOUT volatile.Register32 // 0x100
	_              [512]byte
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [244]byte
	RUNSTATUS      volatile.Register32 // 0x400
	REQSTATUS      volatile.Register32 // 0x404
	_              [252]byte
	CRV            volatile.Register32 // 0x504
	RREN           volatile.Register32 // 0x508
	CONFIG         volatile.Register32 // 0x50C
	_              [240]byte
	RR             [8]volatile.Register32 // 0x600
}

// WDT.TASKS_START: Start the watchdog
func (o *WDT_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// WDT.EVENTS_TIMEOUT: Watchdog timeout
func (o *WDT_Type) SetEVENTS_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TIMEOUT.Reg, volatile.LoadUint32(&o.EVENTS_TIMEOUT.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetEVENTS_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TIMEOUT.Reg) & 0x1
}

// WDT.INTENSET: Enable interrupt
func (o *WDT_Type) SetINTENSET_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENSET_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}

// WDT.INTENCLR: Disable interrupt
func (o *WDT_Type) SetINTENCLR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENCLR_TIMEOUT() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}

// WDT.RUNSTATUS: Run status
func (o *WDT_Type) SetRUNSTATUS(value uint32) {
	volatile.StoreUint32(&o.RUNSTATUS.Reg, volatile.LoadUint32(&o.RUNSTATUS.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetRUNSTATUS() uint32 {
	return volatile.LoadUint32(&o.RUNSTATUS.Reg) & 0x1
}

// WDT.REQSTATUS: Request status
func (o *WDT_Type) SetREQSTATUS_RR0(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetREQSTATUS_RR0() uint32 {
	return volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x1
}
func (o *WDT_Type) SetREQSTATUS_RR1(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetREQSTATUS_RR1() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetREQSTATUS_RR2(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetREQSTATUS_RR2() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetREQSTATUS_RR3(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetREQSTATUS_RR3() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetREQSTATUS_RR4(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *WDT_Type) GetREQSTATUS_RR4() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x10) >> 4
}
func (o *WDT_Type) SetREQSTATUS_RR5(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *WDT_Type) GetREQSTATUS_RR5() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x20) >> 5
}
func (o *WDT_Type) SetREQSTATUS_RR6(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *WDT_Type) GetREQSTATUS_RR6() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x40) >> 6
}
func (o *WDT_Type) SetREQSTATUS_RR7(value uint32) {
	volatile.StoreUint32(&o.REQSTATUS.Reg, volatile.LoadUint32(&o.REQSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetREQSTATUS_RR7() uint32 {
	return (volatile.LoadUint32(&o.REQSTATUS.Reg) & 0x80) >> 7
}

// WDT.CRV: Counter reload value
func (o *WDT_Type) SetCRV(value uint32) {
	volatile.StoreUint32(&o.CRV.Reg, value)
}
func (o *WDT_Type) GetCRV() uint32 {
	return volatile.LoadUint32(&o.CRV.Reg)
}

// WDT.RREN: Enable register for reload request registers
func (o *WDT_Type) SetRREN_RR0(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetRREN_RR0() uint32 {
	return volatile.LoadUint32(&o.RREN.Reg) & 0x1
}
func (o *WDT_Type) SetRREN_RR1(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetRREN_RR1() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetRREN_RR2(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetRREN_RR2() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetRREN_RR3(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetRREN_RR3() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetRREN_RR4(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x10)|value<<4)
}
func (o *WDT_Type) GetRREN_RR4() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x10) >> 4
}
func (o *WDT_Type) SetRREN_RR5(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x20)|value<<5)
}
func (o *WDT_Type) GetRREN_RR5() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x20) >> 5
}
func (o *WDT_Type) SetRREN_RR6(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x40)|value<<6)
}
func (o *WDT_Type) GetRREN_RR6() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x40) >> 6
}
func (o *WDT_Type) SetRREN_RR7(value uint32) {
	volatile.StoreUint32(&o.RREN.Reg, volatile.LoadUint32(&o.RREN.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetRREN_RR7() uint32 {
	return (volatile.LoadUint32(&o.RREN.Reg) & 0x80) >> 7
}

// WDT.CONFIG: Configuration register
func (o *WDT_Type) SetCONFIG_SLEEP(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetCONFIG_SLEEP() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x1
}
func (o *WDT_Type) SetCONFIG_HALT(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetCONFIG_HALT() uint32 {
	return (volatile.LoadUint32(&o.CONFIG.Reg) & 0x8) >> 3
}

// WDT.RR: Description collection: Reload request n
func (o *WDT_Type) SetRR(idx int, value uint32) {
	volatile.StoreUint32(&o.RR[idx].Reg, value)
}
func (o *WDT_Type) GetRR(idx int) uint32 {
	return volatile.LoadUint32(&o.RR[idx].Reg)
}

// Quadrature Decoder
type QDEC_Type struct {
	TASKS_START      volatile.Register32 // 0x0
	TASKS_STOP       volatile.Register32 // 0x4
	TASKS_READCLRACC volatile.Register32 // 0x8
	TASKS_RDCLRACC   volatile.Register32 // 0xC
	TASKS_RDCLRDBL   volatile.Register32 // 0x10
	_                [236]byte
	EVENTS_SAMPLERDY volatile.Register32 // 0x100
	EVENTS_REPORTRDY volatile.Register32 // 0x104
	EVENTS_ACCOF     volatile.Register32 // 0x108
	EVENTS_DBLRDY    volatile.Register32 // 0x10C
	EVENTS_STOPPED   volatile.Register32 // 0x110
	_                [236]byte
	SHORTS           volatile.Register32 // 0x200
	_                [256]byte
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
	_                [500]byte
	ENABLE           volatile.Register32 // 0x500
	LEDPOL           volatile.Register32 // 0x504
	SAMPLEPER        volatile.Register32 // 0x508
	SAMPLE           volatile.Register32 // 0x50C
	REPORTPER        volatile.Register32 // 0x510
	ACC              volatile.Register32 // 0x514
	ACCREAD          volatile.Register32 // 0x518
	PSEL             QDEC_PSEL_Type      // 0x51C
	DBFEN            volatile.Register32 // 0x528
	_                [20]byte
	LEDPRE           volatile.Register32 // 0x540
	ACCDBL           volatile.Register32 // 0x544
	ACCDBLREAD       volatile.Register32 // 0x548
}

// QDEC.TASKS_START: Task starting the quadrature decoder
func (o *QDEC_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// QDEC.TASKS_STOP: Task stopping the quadrature decoder
func (o *QDEC_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// QDEC.TASKS_READCLRACC: Read and clear ACC and ACCDBL
func (o *QDEC_Type) SetTASKS_READCLRACC(value uint32) {
	volatile.StoreUint32(&o.TASKS_READCLRACC.Reg, volatile.LoadUint32(&o.TASKS_READCLRACC.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetTASKS_READCLRACC() uint32 {
	return volatile.LoadUint32(&o.TASKS_READCLRACC.Reg) & 0x1
}

// QDEC.TASKS_RDCLRACC: Read and clear ACC
func (o *QDEC_Type) SetTASKS_RDCLRACC(value uint32) {
	volatile.StoreUint32(&o.TASKS_RDCLRACC.Reg, volatile.LoadUint32(&o.TASKS_RDCLRACC.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetTASKS_RDCLRACC() uint32 {
	return volatile.LoadUint32(&o.TASKS_RDCLRACC.Reg) & 0x1
}

// QDEC.TASKS_RDCLRDBL: Read and clear ACCDBL
func (o *QDEC_Type) SetTASKS_RDCLRDBL(value uint32) {
	volatile.StoreUint32(&o.TASKS_RDCLRDBL.Reg, volatile.LoadUint32(&o.TASKS_RDCLRDBL.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetTASKS_RDCLRDBL() uint32 {
	return volatile.LoadUint32(&o.TASKS_RDCLRDBL.Reg) & 0x1
}

// QDEC.EVENTS_SAMPLERDY: Event being generated for every new sample value written to the SAMPLE register
func (o *QDEC_Type) SetEVENTS_SAMPLERDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SAMPLERDY.Reg, volatile.LoadUint32(&o.EVENTS_SAMPLERDY.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetEVENTS_SAMPLERDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SAMPLERDY.Reg) & 0x1
}

// QDEC.EVENTS_REPORTRDY: Non-null report ready
func (o *QDEC_Type) SetEVENTS_REPORTRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_REPORTRDY.Reg, volatile.LoadUint32(&o.EVENTS_REPORTRDY.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetEVENTS_REPORTRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_REPORTRDY.Reg) & 0x1
}

// QDEC.EVENTS_ACCOF: ACC or ACCDBL register overflow
func (o *QDEC_Type) SetEVENTS_ACCOF(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ACCOF.Reg, volatile.LoadUint32(&o.EVENTS_ACCOF.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetEVENTS_ACCOF() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ACCOF.Reg) & 0x1
}

// QDEC.EVENTS_DBLRDY: Double displacement(s) detected
func (o *QDEC_Type) SetEVENTS_DBLRDY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DBLRDY.Reg, volatile.LoadUint32(&o.EVENTS_DBLRDY.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetEVENTS_DBLRDY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DBLRDY.Reg) & 0x1
}

// QDEC.EVENTS_STOPPED: QDEC has been stopped
func (o *QDEC_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// QDEC.SHORTS: Shortcuts between local events and tasks
func (o *QDEC_Type) SetSHORTS_REPORTRDY_READCLRACC(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetSHORTS_REPORTRDY_READCLRACC() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *QDEC_Type) SetSHORTS_SAMPLERDY_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *QDEC_Type) GetSHORTS_SAMPLERDY_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *QDEC_Type) SetSHORTS_REPORTRDY_RDCLRACC(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *QDEC_Type) GetSHORTS_REPORTRDY_RDCLRACC() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *QDEC_Type) SetSHORTS_REPORTRDY_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *QDEC_Type) GetSHORTS_REPORTRDY_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *QDEC_Type) SetSHORTS_DBLRDY_RDCLRDBL(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *QDEC_Type) GetSHORTS_DBLRDY_RDCLRDBL() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}
func (o *QDEC_Type) SetSHORTS_DBLRDY_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x20)|value<<5)
}
func (o *QDEC_Type) GetSHORTS_DBLRDY_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x20) >> 5
}
func (o *QDEC_Type) SetSHORTS_SAMPLERDY_READCLRACC(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x40)|value<<6)
}
func (o *QDEC_Type) GetSHORTS_SAMPLERDY_READCLRACC() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x40) >> 6
}

// QDEC.INTENSET: Enable interrupt
func (o *QDEC_Type) SetINTENSET_SAMPLERDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetINTENSET_SAMPLERDY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *QDEC_Type) SetINTENSET_REPORTRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *QDEC_Type) GetINTENSET_REPORTRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *QDEC_Type) SetINTENSET_ACCOF(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *QDEC_Type) GetINTENSET_ACCOF() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *QDEC_Type) SetINTENSET_DBLRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *QDEC_Type) GetINTENSET_DBLRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *QDEC_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *QDEC_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}

// QDEC.INTENCLR: Disable interrupt
func (o *QDEC_Type) SetINTENCLR_SAMPLERDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetINTENCLR_SAMPLERDY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *QDEC_Type) SetINTENCLR_REPORTRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *QDEC_Type) GetINTENCLR_REPORTRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *QDEC_Type) SetINTENCLR_ACCOF(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *QDEC_Type) GetINTENCLR_ACCOF() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *QDEC_Type) SetINTENCLR_DBLRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *QDEC_Type) GetINTENCLR_DBLRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *QDEC_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *QDEC_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}

// QDEC.ENABLE: Enable the quadrature decoder
func (o *QDEC_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// QDEC.LEDPOL: LED output pin polarity
func (o *QDEC_Type) SetLEDPOL(value uint32) {
	volatile.StoreUint32(&o.LEDPOL.Reg, volatile.LoadUint32(&o.LEDPOL.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetLEDPOL() uint32 {
	return volatile.LoadUint32(&o.LEDPOL.Reg) & 0x1
}

// QDEC.SAMPLEPER: Sample period
func (o *QDEC_Type) SetSAMPLEPER(value uint32) {
	volatile.StoreUint32(&o.SAMPLEPER.Reg, volatile.LoadUint32(&o.SAMPLEPER.Reg)&^(0xf)|value)
}
func (o *QDEC_Type) GetSAMPLEPER() uint32 {
	return volatile.LoadUint32(&o.SAMPLEPER.Reg) & 0xf
}

// QDEC.SAMPLE: Motion sample value
func (o *QDEC_Type) SetSAMPLE(value uint32) {
	volatile.StoreUint32(&o.SAMPLE.Reg, value)
}
func (o *QDEC_Type) GetSAMPLE() uint32 {
	return volatile.LoadUint32(&o.SAMPLE.Reg)
}

// QDEC.REPORTPER: Number of samples to be taken before REPORTRDY and DBLRDY events can be generated
func (o *QDEC_Type) SetREPORTPER(value uint32) {
	volatile.StoreUint32(&o.REPORTPER.Reg, volatile.LoadUint32(&o.REPORTPER.Reg)&^(0xf)|value)
}
func (o *QDEC_Type) GetREPORTPER() uint32 {
	return volatile.LoadUint32(&o.REPORTPER.Reg) & 0xf
}

// QDEC.ACC: Register accumulating the valid transitions
func (o *QDEC_Type) SetACC(value uint32) {
	volatile.StoreUint32(&o.ACC.Reg, value)
}
func (o *QDEC_Type) GetACC() uint32 {
	return volatile.LoadUint32(&o.ACC.Reg)
}

// QDEC.ACCREAD: Snapshot of the ACC register, updated by the READCLRACC or RDCLRACC task
func (o *QDEC_Type) SetACCREAD(value uint32) {
	volatile.StoreUint32(&o.ACCREAD.Reg, value)
}
func (o *QDEC_Type) GetACCREAD() uint32 {
	return volatile.LoadUint32(&o.ACCREAD.Reg)
}

// QDEC.DBFEN: Enable input debounce filters
func (o *QDEC_Type) SetDBFEN(value uint32) {
	volatile.StoreUint32(&o.DBFEN.Reg, volatile.LoadUint32(&o.DBFEN.Reg)&^(0x1)|value)
}
func (o *QDEC_Type) GetDBFEN() uint32 {
	return volatile.LoadUint32(&o.DBFEN.Reg) & 0x1
}

// QDEC.LEDPRE: Time period the LED is switched ON prior to sampling
func (o *QDEC_Type) SetLEDPRE(value uint32) {
	volatile.StoreUint32(&o.LEDPRE.Reg, volatile.LoadUint32(&o.LEDPRE.Reg)&^(0x1ff)|value)
}
func (o *QDEC_Type) GetLEDPRE() uint32 {
	return volatile.LoadUint32(&o.LEDPRE.Reg) & 0x1ff
}

// QDEC.ACCDBL: Register accumulating the number of detected double transitions
func (o *QDEC_Type) SetACCDBL(value uint32) {
	volatile.StoreUint32(&o.ACCDBL.Reg, volatile.LoadUint32(&o.ACCDBL.Reg)&^(0xf)|value)
}
func (o *QDEC_Type) GetACCDBL() uint32 {
	return volatile.LoadUint32(&o.ACCDBL.Reg) & 0xf
}

// QDEC.ACCDBLREAD: Snapshot of the ACCDBL, updated by the READCLRACC or RDCLRDBL task
func (o *QDEC_Type) SetACCDBLREAD(value uint32) {
	volatile.StoreUint32(&o.ACCDBLREAD.Reg, volatile.LoadUint32(&o.ACCDBLREAD.Reg)&^(0xf)|value)
}
func (o *QDEC_Type) GetACCDBLREAD() uint32 {
	return volatile.LoadUint32(&o.ACCDBLREAD.Reg) & 0xf
}

// Unspecified
type QDEC_PSEL_Type struct {
	LED volatile.Register32 // 0x51C
	A   volatile.Register32 // 0x520
	B   volatile.Register32 // 0x524
}

// QDEC_PSEL.LED: Pin select for LED signal
func (o *QDEC_PSEL_Type) SetLED_PIN(value uint32) {
	volatile.StoreUint32(&o.LED.Reg, volatile.LoadUint32(&o.LED.Reg)&^(0x1f)|value)
}
func (o *QDEC_PSEL_Type) GetLED_PIN() uint32 {
	return volatile.LoadUint32(&o.LED.Reg) & 0x1f
}
func (o *QDEC_PSEL_Type) SetLED_PORT(value uint32) {
	volatile.StoreUint32(&o.LED.Reg, volatile.LoadUint32(&o.LED.Reg)&^(0x20)|value<<5)
}
func (o *QDEC_PSEL_Type) GetLED_PORT() uint32 {
	return (volatile.LoadUint32(&o.LED.Reg) & 0x20) >> 5
}
func (o *QDEC_PSEL_Type) SetLED_CONNECT(value uint32) {
	volatile.StoreUint32(&o.LED.Reg, volatile.LoadUint32(&o.LED.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_PSEL_Type) GetLED_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.LED.Reg) & 0x80000000) >> 31
}

// QDEC_PSEL.A: Pin select for A signal
func (o *QDEC_PSEL_Type) SetA_PIN(value uint32) {
	volatile.StoreUint32(&o.A.Reg, volatile.LoadUint32(&o.A.Reg)&^(0x1f)|value)
}
func (o *QDEC_PSEL_Type) GetA_PIN() uint32 {
	return volatile.LoadUint32(&o.A.Reg) & 0x1f
}
func (o *QDEC_PSEL_Type) SetA_PORT(value uint32) {
	volatile.StoreUint32(&o.A.Reg, volatile.LoadUint32(&o.A.Reg)&^(0x20)|value<<5)
}
func (o *QDEC_PSEL_Type) GetA_PORT() uint32 {
	return (volatile.LoadUint32(&o.A.Reg) & 0x20) >> 5
}
func (o *QDEC_PSEL_Type) SetA_CONNECT(value uint32) {
	volatile.StoreUint32(&o.A.Reg, volatile.LoadUint32(&o.A.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_PSEL_Type) GetA_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.A.Reg) & 0x80000000) >> 31
}

// QDEC_PSEL.B: Pin select for B signal
func (o *QDEC_PSEL_Type) SetB_PIN(value uint32) {
	volatile.StoreUint32(&o.B.Reg, volatile.LoadUint32(&o.B.Reg)&^(0x1f)|value)
}
func (o *QDEC_PSEL_Type) GetB_PIN() uint32 {
	return volatile.LoadUint32(&o.B.Reg) & 0x1f
}
func (o *QDEC_PSEL_Type) SetB_PORT(value uint32) {
	volatile.StoreUint32(&o.B.Reg, volatile.LoadUint32(&o.B.Reg)&^(0x20)|value<<5)
}
func (o *QDEC_PSEL_Type) GetB_PORT() uint32 {
	return (volatile.LoadUint32(&o.B.Reg) & 0x20) >> 5
}
func (o *QDEC_PSEL_Type) SetB_CONNECT(value uint32) {
	volatile.StoreUint32(&o.B.Reg, volatile.LoadUint32(&o.B.Reg)&^(0x80000000)|value<<31)
}
func (o *QDEC_PSEL_Type) GetB_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.B.Reg) & 0x80000000) >> 31
}

// Comparator
type COMP_Type struct {
	TASKS_START  volatile.Register32 // 0x0
	TASKS_STOP   volatile.Register32 // 0x4
	TASKS_SAMPLE volatile.Register32 // 0x8
	_            [244]byte
	EVENTS_READY volatile.Register32 // 0x100
	EVENTS_DOWN  volatile.Register32 // 0x104
	EVENTS_UP    volatile.Register32 // 0x108
	EVENTS_CROSS volatile.Register32 // 0x10C
	_            [240]byte
	SHORTS       volatile.Register32 // 0x200
	_            [252]byte
	INTEN        volatile.Register32 // 0x300
	INTENSET     volatile.Register32 // 0x304
	INTENCLR     volatile.Register32 // 0x308
	_            [244]byte
	RESULT       volatile.Register32 // 0x400
	_            [252]byte
	ENABLE       volatile.Register32 // 0x500
	PSEL         volatile.Register32 // 0x504
	REFSEL       volatile.Register32 // 0x508
	EXTREFSEL    volatile.Register32 // 0x50C
	_            [32]byte
	TH           volatile.Register32 // 0x530
	MODE         volatile.Register32 // 0x534
	HYST         volatile.Register32 // 0x538
}

// COMP.TASKS_START: Start comparator
func (o *COMP_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// COMP.TASKS_STOP: Stop comparator
func (o *COMP_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// COMP.TASKS_SAMPLE: Sample comparator value
func (o *COMP_Type) SetTASKS_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.TASKS_SAMPLE.Reg, volatile.LoadUint32(&o.TASKS_SAMPLE.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetTASKS_SAMPLE() uint32 {
	return volatile.LoadUint32(&o.TASKS_SAMPLE.Reg) & 0x1
}

// COMP.EVENTS_READY: COMP is ready and output is valid
func (o *COMP_Type) SetEVENTS_READY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READY.Reg, volatile.LoadUint32(&o.EVENTS_READY.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetEVENTS_READY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READY.Reg) & 0x1
}

// COMP.EVENTS_DOWN: Downward crossing
func (o *COMP_Type) SetEVENTS_DOWN(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DOWN.Reg, volatile.LoadUint32(&o.EVENTS_DOWN.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetEVENTS_DOWN() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DOWN.Reg) & 0x1
}

// COMP.EVENTS_UP: Upward crossing
func (o *COMP_Type) SetEVENTS_UP(value uint32) {
	volatile.StoreUint32(&o.EVENTS_UP.Reg, volatile.LoadUint32(&o.EVENTS_UP.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetEVENTS_UP() uint32 {
	return volatile.LoadUint32(&o.EVENTS_UP.Reg) & 0x1
}

// COMP.EVENTS_CROSS: Downward or upward crossing
func (o *COMP_Type) SetEVENTS_CROSS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CROSS.Reg, volatile.LoadUint32(&o.EVENTS_CROSS.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetEVENTS_CROSS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CROSS.Reg) & 0x1
}

// COMP.SHORTS: Shortcuts between local events and tasks
func (o *COMP_Type) SetSHORTS_READY_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetSHORTS_READY_SAMPLE() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *COMP_Type) SetSHORTS_READY_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetSHORTS_READY_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *COMP_Type) SetSHORTS_DOWN_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *COMP_Type) GetSHORTS_DOWN_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *COMP_Type) SetSHORTS_UP_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *COMP_Type) GetSHORTS_UP_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *COMP_Type) SetSHORTS_CROSS_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *COMP_Type) GetSHORTS_CROSS_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}

// COMP.INTEN: Enable or disable interrupt
func (o *COMP_Type) SetINTEN_READY(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetINTEN_READY() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *COMP_Type) SetINTEN_DOWN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetINTEN_DOWN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *COMP_Type) SetINTEN_UP(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *COMP_Type) GetINTEN_UP() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *COMP_Type) SetINTEN_CROSS(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *COMP_Type) GetINTEN_CROSS() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}

// COMP.INTENSET: Enable interrupt
func (o *COMP_Type) SetINTENSET_READY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetINTENSET_READY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *COMP_Type) SetINTENSET_DOWN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetINTENSET_DOWN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *COMP_Type) SetINTENSET_UP(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *COMP_Type) GetINTENSET_UP() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *COMP_Type) SetINTENSET_CROSS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *COMP_Type) GetINTENSET_CROSS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}

// COMP.INTENCLR: Disable interrupt
func (o *COMP_Type) SetINTENCLR_READY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetINTENCLR_READY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *COMP_Type) SetINTENCLR_DOWN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *COMP_Type) GetINTENCLR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *COMP_Type) SetINTENCLR_UP(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *COMP_Type) GetINTENCLR_UP() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *COMP_Type) SetINTENCLR_CROSS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *COMP_Type) GetINTENCLR_CROSS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}

// COMP.RESULT: Compare result
func (o *COMP_Type) SetRESULT(value uint32) {
	volatile.StoreUint32(&o.RESULT.Reg, volatile.LoadUint32(&o.RESULT.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetRESULT() uint32 {
	return volatile.LoadUint32(&o.RESULT.Reg) & 0x1
}

// COMP.ENABLE: COMP enable
func (o *COMP_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x3)|value)
}
func (o *COMP_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x3
}

// COMP.PSEL: Pin select
func (o *COMP_Type) SetPSEL(value uint32) {
	volatile.StoreUint32(&o.PSEL.Reg, volatile.LoadUint32(&o.PSEL.Reg)&^(0x7)|value)
}
func (o *COMP_Type) GetPSEL() uint32 {
	return volatile.LoadUint32(&o.PSEL.Reg) & 0x7
}

// COMP.REFSEL: Reference source select for single-ended mode
func (o *COMP_Type) SetREFSEL(value uint32) {
	volatile.StoreUint32(&o.REFSEL.Reg, volatile.LoadUint32(&o.REFSEL.Reg)&^(0x7)|value)
}
func (o *COMP_Type) GetREFSEL() uint32 {
	return volatile.LoadUint32(&o.REFSEL.Reg) & 0x7
}

// COMP.EXTREFSEL: External reference select
func (o *COMP_Type) SetEXTREFSEL(value uint32) {
	volatile.StoreUint32(&o.EXTREFSEL.Reg, volatile.LoadUint32(&o.EXTREFSEL.Reg)&^(0x7)|value)
}
func (o *COMP_Type) GetEXTREFSEL() uint32 {
	return volatile.LoadUint32(&o.EXTREFSEL.Reg) & 0x7
}

// COMP.TH: Threshold configuration for hysteresis unit
func (o *COMP_Type) SetTH_THDOWN(value uint32) {
	volatile.StoreUint32(&o.TH.Reg, volatile.LoadUint32(&o.TH.Reg)&^(0x3f)|value)
}
func (o *COMP_Type) GetTH_THDOWN() uint32 {
	return volatile.LoadUint32(&o.TH.Reg) & 0x3f
}
func (o *COMP_Type) SetTH_THUP(value uint32) {
	volatile.StoreUint32(&o.TH.Reg, volatile.LoadUint32(&o.TH.Reg)&^(0x3f00)|value<<8)
}
func (o *COMP_Type) GetTH_THUP() uint32 {
	return (volatile.LoadUint32(&o.TH.Reg) & 0x3f00) >> 8
}

// COMP.MODE: Mode configuration
func (o *COMP_Type) SetMODE_SP(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x3)|value)
}
func (o *COMP_Type) GetMODE_SP() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x3
}
func (o *COMP_Type) SetMODE_MAIN(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x100)|value<<8)
}
func (o *COMP_Type) GetMODE_MAIN() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x100) >> 8
}

// COMP.HYST: Comparator hysteresis enable
func (o *COMP_Type) SetHYST(value uint32) {
	volatile.StoreUint32(&o.HYST.Reg, volatile.LoadUint32(&o.HYST.Reg)&^(0x1)|value)
}
func (o *COMP_Type) GetHYST() uint32 {
	return volatile.LoadUint32(&o.HYST.Reg) & 0x1
}

// Low-power comparator
type LPCOMP_Type struct {
	TASKS_START  volatile.Register32 // 0x0
	TASKS_STOP   volatile.Register32 // 0x4
	TASKS_SAMPLE volatile.Register32 // 0x8
	_            [244]byte
	EVENTS_READY volatile.Register32 // 0x100
	EVENTS_DOWN  volatile.Register32 // 0x104
	EVENTS_UP    volatile.Register32 // 0x108
	EVENTS_CROSS volatile.Register32 // 0x10C
	_            [240]byte
	SHORTS       volatile.Register32 // 0x200
	_            [256]byte
	INTENSET     volatile.Register32 // 0x304
	INTENCLR     volatile.Register32 // 0x308
	_            [244]byte
	RESULT       volatile.Register32 // 0x400
	_            [252]byte
	ENABLE       volatile.Register32 // 0x500
	PSEL         volatile.Register32 // 0x504
	REFSEL       volatile.Register32 // 0x508
	EXTREFSEL    volatile.Register32 // 0x50C
	_            [16]byte
	ANADETECT    volatile.Register32 // 0x520
	_            [20]byte
	HYST         volatile.Register32 // 0x538
}

// LPCOMP.TASKS_START: Start comparator
func (o *LPCOMP_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// LPCOMP.TASKS_STOP: Stop comparator
func (o *LPCOMP_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// LPCOMP.TASKS_SAMPLE: Sample comparator value
func (o *LPCOMP_Type) SetTASKS_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.TASKS_SAMPLE.Reg, volatile.LoadUint32(&o.TASKS_SAMPLE.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetTASKS_SAMPLE() uint32 {
	return volatile.LoadUint32(&o.TASKS_SAMPLE.Reg) & 0x1
}

// LPCOMP.EVENTS_READY: LPCOMP is ready and output is valid
func (o *LPCOMP_Type) SetEVENTS_READY(value uint32) {
	volatile.StoreUint32(&o.EVENTS_READY.Reg, volatile.LoadUint32(&o.EVENTS_READY.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetEVENTS_READY() uint32 {
	return volatile.LoadUint32(&o.EVENTS_READY.Reg) & 0x1
}

// LPCOMP.EVENTS_DOWN: Downward crossing
func (o *LPCOMP_Type) SetEVENTS_DOWN(value uint32) {
	volatile.StoreUint32(&o.EVENTS_DOWN.Reg, volatile.LoadUint32(&o.EVENTS_DOWN.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetEVENTS_DOWN() uint32 {
	return volatile.LoadUint32(&o.EVENTS_DOWN.Reg) & 0x1
}

// LPCOMP.EVENTS_UP: Upward crossing
func (o *LPCOMP_Type) SetEVENTS_UP(value uint32) {
	volatile.StoreUint32(&o.EVENTS_UP.Reg, volatile.LoadUint32(&o.EVENTS_UP.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetEVENTS_UP() uint32 {
	return volatile.LoadUint32(&o.EVENTS_UP.Reg) & 0x1
}

// LPCOMP.EVENTS_CROSS: Downward or upward crossing
func (o *LPCOMP_Type) SetEVENTS_CROSS(value uint32) {
	volatile.StoreUint32(&o.EVENTS_CROSS.Reg, volatile.LoadUint32(&o.EVENTS_CROSS.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetEVENTS_CROSS() uint32 {
	return volatile.LoadUint32(&o.EVENTS_CROSS.Reg) & 0x1
}

// LPCOMP.SHORTS: Shortcuts between local events and tasks
func (o *LPCOMP_Type) SetSHORTS_READY_SAMPLE(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetSHORTS_READY_SAMPLE() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *LPCOMP_Type) SetSHORTS_READY_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *LPCOMP_Type) GetSHORTS_READY_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *LPCOMP_Type) SetSHORTS_DOWN_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *LPCOMP_Type) GetSHORTS_DOWN_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *LPCOMP_Type) SetSHORTS_UP_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *LPCOMP_Type) GetSHORTS_UP_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *LPCOMP_Type) SetSHORTS_CROSS_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *LPCOMP_Type) GetSHORTS_CROSS_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}

// LPCOMP.INTENSET: Enable interrupt
func (o *LPCOMP_Type) SetINTENSET_READY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetINTENSET_READY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *LPCOMP_Type) SetINTENSET_DOWN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *LPCOMP_Type) GetINTENSET_DOWN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *LPCOMP_Type) SetINTENSET_UP(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *LPCOMP_Type) GetINTENSET_UP() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *LPCOMP_Type) SetINTENSET_CROSS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *LPCOMP_Type) GetINTENSET_CROSS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}

// LPCOMP.INTENCLR: Disable interrupt
func (o *LPCOMP_Type) SetINTENCLR_READY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetINTENCLR_READY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *LPCOMP_Type) SetINTENCLR_DOWN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *LPCOMP_Type) GetINTENCLR_DOWN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *LPCOMP_Type) SetINTENCLR_UP(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *LPCOMP_Type) GetINTENCLR_UP() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *LPCOMP_Type) SetINTENCLR_CROSS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *LPCOMP_Type) GetINTENCLR_CROSS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}

// LPCOMP.RESULT: Compare result
func (o *LPCOMP_Type) SetRESULT(value uint32) {
	volatile.StoreUint32(&o.RESULT.Reg, volatile.LoadUint32(&o.RESULT.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetRESULT() uint32 {
	return volatile.LoadUint32(&o.RESULT.Reg) & 0x1
}

// LPCOMP.ENABLE: Enable LPCOMP
func (o *LPCOMP_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x3)|value)
}
func (o *LPCOMP_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x3
}

// LPCOMP.PSEL: Input pin select
func (o *LPCOMP_Type) SetPSEL(value uint32) {
	volatile.StoreUint32(&o.PSEL.Reg, volatile.LoadUint32(&o.PSEL.Reg)&^(0x7)|value)
}
func (o *LPCOMP_Type) GetPSEL() uint32 {
	return volatile.LoadUint32(&o.PSEL.Reg) & 0x7
}

// LPCOMP.REFSEL: Reference select
func (o *LPCOMP_Type) SetREFSEL(value uint32) {
	volatile.StoreUint32(&o.REFSEL.Reg, volatile.LoadUint32(&o.REFSEL.Reg)&^(0xf)|value)
}
func (o *LPCOMP_Type) GetREFSEL() uint32 {
	return volatile.LoadUint32(&o.REFSEL.Reg) & 0xf
}

// LPCOMP.EXTREFSEL: External reference select
func (o *LPCOMP_Type) SetEXTREFSEL(value uint32) {
	volatile.StoreUint32(&o.EXTREFSEL.Reg, volatile.LoadUint32(&o.EXTREFSEL.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetEXTREFSEL() uint32 {
	return volatile.LoadUint32(&o.EXTREFSEL.Reg) & 0x1
}

// LPCOMP.ANADETECT: Analog detect configuration
func (o *LPCOMP_Type) SetANADETECT(value uint32) {
	volatile.StoreUint32(&o.ANADETECT.Reg, volatile.LoadUint32(&o.ANADETECT.Reg)&^(0x3)|value)
}
func (o *LPCOMP_Type) GetANADETECT() uint32 {
	return volatile.LoadUint32(&o.ANADETECT.Reg) & 0x3
}

// LPCOMP.HYST: Comparator hysteresis enable
func (o *LPCOMP_Type) SetHYST(value uint32) {
	volatile.StoreUint32(&o.HYST.Reg, volatile.LoadUint32(&o.HYST.Reg)&^(0x1)|value)
}
func (o *LPCOMP_Type) GetHYST() uint32 {
	return volatile.LoadUint32(&o.HYST.Reg) & 0x1
}

// Event generator unit 0
type EGU_Type struct {
	TASKS_TRIGGER    [16]volatile.Register32 // 0x0
	_                [192]byte
	EVENTS_TRIGGERED [16]volatile.Register32 // 0x100
	_                [448]byte
	INTEN            volatile.Register32 // 0x300
	INTENSET         volatile.Register32 // 0x304
	INTENCLR         volatile.Register32 // 0x308
}

// EGU.TASKS_TRIGGER: Description collection: Trigger n for triggering the corresponding TRIGGERED[n] event
func (o *EGU_Type) SetTASKS_TRIGGER(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_TRIGGER[idx].Reg, volatile.LoadUint32(&o.TASKS_TRIGGER[idx].Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetTASKS_TRIGGER(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_TRIGGER[idx].Reg) & 0x1
}

// EGU.EVENTS_TRIGGERED: Description collection: Event number n generated by triggering the corresponding TRIGGER[n] task
func (o *EGU_Type) SetEVENTS_TRIGGERED(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_TRIGGERED[idx].Reg, volatile.LoadUint32(&o.EVENTS_TRIGGERED[idx].Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetEVENTS_TRIGGERED(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_TRIGGERED[idx].Reg) & 0x1
}

// EGU.INTEN: Enable or disable interrupt
func (o *EGU_Type) SetINTEN_TRIGGERED0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetINTEN_TRIGGERED0() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *EGU_Type) SetINTEN_TRIGGERED1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *EGU_Type) GetINTEN_TRIGGERED1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *EGU_Type) SetINTEN_TRIGGERED2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *EGU_Type) GetINTEN_TRIGGERED2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *EGU_Type) SetINTEN_TRIGGERED3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *EGU_Type) GetINTEN_TRIGGERED3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *EGU_Type) SetINTEN_TRIGGERED4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *EGU_Type) GetINTEN_TRIGGERED4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *EGU_Type) SetINTEN_TRIGGERED5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *EGU_Type) GetINTEN_TRIGGERED5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *EGU_Type) SetINTEN_TRIGGERED6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *EGU_Type) GetINTEN_TRIGGERED6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *EGU_Type) SetINTEN_TRIGGERED7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *EGU_Type) GetINTEN_TRIGGERED7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *EGU_Type) SetINTEN_TRIGGERED8(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *EGU_Type) GetINTEN_TRIGGERED8() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *EGU_Type) SetINTEN_TRIGGERED9(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *EGU_Type) GetINTEN_TRIGGERED9() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *EGU_Type) SetINTEN_TRIGGERED10(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *EGU_Type) GetINTEN_TRIGGERED10() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *EGU_Type) SetINTEN_TRIGGERED11(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800)|value<<11)
}
func (o *EGU_Type) GetINTEN_TRIGGERED11() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800) >> 11
}
func (o *EGU_Type) SetINTEN_TRIGGERED12(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000)|value<<12)
}
func (o *EGU_Type) GetINTEN_TRIGGERED12() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000) >> 12
}
func (o *EGU_Type) SetINTEN_TRIGGERED13(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000)|value<<13)
}
func (o *EGU_Type) GetINTEN_TRIGGERED13() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000) >> 13
}
func (o *EGU_Type) SetINTEN_TRIGGERED14(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000)|value<<14)
}
func (o *EGU_Type) GetINTEN_TRIGGERED14() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000) >> 14
}
func (o *EGU_Type) SetINTEN_TRIGGERED15(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000)|value<<15)
}
func (o *EGU_Type) GetINTEN_TRIGGERED15() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000) >> 15
}

// EGU.INTENSET: Enable interrupt
func (o *EGU_Type) SetINTENSET_TRIGGERED0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *EGU_Type) SetINTENSET_TRIGGERED1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *EGU_Type) SetINTENSET_TRIGGERED2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *EGU_Type) SetINTENSET_TRIGGERED3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *EGU_Type) SetINTENSET_TRIGGERED4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *EGU_Type) SetINTENSET_TRIGGERED5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *EGU_Type) SetINTENSET_TRIGGERED6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *EGU_Type) SetINTENSET_TRIGGERED7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *EGU_Type) SetINTENSET_TRIGGERED8(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED8() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *EGU_Type) SetINTENSET_TRIGGERED9(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED9() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *EGU_Type) SetINTENSET_TRIGGERED10(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED10() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *EGU_Type) SetINTENSET_TRIGGERED11(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED11() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *EGU_Type) SetINTENSET_TRIGGERED12(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED12() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *EGU_Type) SetINTENSET_TRIGGERED13(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED13() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *EGU_Type) SetINTENSET_TRIGGERED14(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED14() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *EGU_Type) SetINTENSET_TRIGGERED15(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *EGU_Type) GetINTENSET_TRIGGERED15() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}

// EGU.INTENCLR: Disable interrupt
func (o *EGU_Type) SetINTENCLR_TRIGGERED0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED8(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED8() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED9(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED9() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED10(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED10() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED11(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED11() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED12(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED12() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED13(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED13() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED14(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED14() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *EGU_Type) SetINTENCLR_TRIGGERED15(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *EGU_Type) GetINTENCLR_TRIGGERED15() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}

// Software interrupt 0
type SWI_Type struct {
	UNUSED volatile.Register32 // 0x0
}

// Pulse width modulation unit 0
type PWM_Type struct {
	_                   [4]byte
	TASKS_STOP          volatile.Register32    // 0x4
	TASKS_SEQSTART      [2]volatile.Register32 // 0x8
	TASKS_NEXTSTEP      volatile.Register32    // 0x10
	_                   [240]byte
	EVENTS_STOPPED      volatile.Register32    // 0x104
	EVENTS_SEQSTARTED   [2]volatile.Register32 // 0x108
	EVENTS_SEQEND       [2]volatile.Register32 // 0x110
	EVENTS_PWMPERIODEND volatile.Register32    // 0x118
	EVENTS_LOOPSDONE    volatile.Register32    // 0x11C
	_                   [224]byte
	SHORTS              volatile.Register32 // 0x200
	_                   [252]byte
	INTEN               volatile.Register32 // 0x300
	INTENSET            volatile.Register32 // 0x304
	INTENCLR            volatile.Register32 // 0x308
	_                   [500]byte
	ENABLE              volatile.Register32 // 0x500
	MODE                volatile.Register32 // 0x504
	COUNTERTOP          volatile.Register32 // 0x508
	PRESCALER           volatile.Register32 // 0x50C
	DECODER             volatile.Register32 // 0x510
	LOOP                volatile.Register32 // 0x514
	_                   [8]byte
	SEQ                 [2]PWM_SEQ_Type // 0x520
	PSEL                PWM_PSEL_Type   // 0x560
}

// PWM.TASKS_STOP: Stops PWM pulse generation on all channels at the end of current PWM period, and stops sequence playback
func (o *PWM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// PWM.TASKS_SEQSTART: Description collection: Loads the first PWM value on all enabled channels from sequence n, and starts playing that sequence at the rate defined in SEQ[n]REFRESH and/or DECODER.MODE. Causes PWM generation to start if not running.
func (o *PWM_Type) SetTASKS_SEQSTART(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_SEQSTART[idx].Reg, volatile.LoadUint32(&o.TASKS_SEQSTART[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetTASKS_SEQSTART(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_SEQSTART[idx].Reg) & 0x1
}

// PWM.TASKS_NEXTSTEP: Steps by one value in the current sequence on all enabled channels if DECODER.MODE=NextStep. Does not cause PWM generation to start if not running.
func (o *PWM_Type) SetTASKS_NEXTSTEP(value uint32) {
	volatile.StoreUint32(&o.TASKS_NEXTSTEP.Reg, volatile.LoadUint32(&o.TASKS_NEXTSTEP.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetTASKS_NEXTSTEP() uint32 {
	return volatile.LoadUint32(&o.TASKS_NEXTSTEP.Reg) & 0x1
}

// PWM.EVENTS_STOPPED: Response to STOP task, emitted when PWM pulses are no longer generated
func (o *PWM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// PWM.EVENTS_SEQSTARTED: Description collection: First PWM period started on sequence n
func (o *PWM_Type) SetEVENTS_SEQSTARTED(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_SEQSTARTED[idx].Reg, volatile.LoadUint32(&o.EVENTS_SEQSTARTED[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_SEQSTARTED(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_SEQSTARTED[idx].Reg) & 0x1
}

// PWM.EVENTS_SEQEND: Description collection: Emitted at end of every sequence n, when last value from RAM has been applied to wave counter
func (o *PWM_Type) SetEVENTS_SEQEND(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_SEQEND[idx].Reg, volatile.LoadUint32(&o.EVENTS_SEQEND[idx].Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_SEQEND(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_SEQEND[idx].Reg) & 0x1
}

// PWM.EVENTS_PWMPERIODEND: Emitted at the end of each PWM period
func (o *PWM_Type) SetEVENTS_PWMPERIODEND(value uint32) {
	volatile.StoreUint32(&o.EVENTS_PWMPERIODEND.Reg, volatile.LoadUint32(&o.EVENTS_PWMPERIODEND.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_PWMPERIODEND() uint32 {
	return volatile.LoadUint32(&o.EVENTS_PWMPERIODEND.Reg) & 0x1
}

// PWM.EVENTS_LOOPSDONE: Concatenated sequences have been played the amount of times defined in LOOP.CNT
func (o *PWM_Type) SetEVENTS_LOOPSDONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_LOOPSDONE.Reg, volatile.LoadUint32(&o.EVENTS_LOOPSDONE.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetEVENTS_LOOPSDONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_LOOPSDONE.Reg) & 0x1
}

// PWM.SHORTS: Shortcuts between local events and tasks
func (o *PWM_Type) SetSHORTS_SEQEND0_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSHORTS_SEQEND0_STOP() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *PWM_Type) SetSHORTS_SEQEND1_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSHORTS_SEQEND1_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSHORTS_LOOPSDONE_SEQSTART0(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSHORTS_LOOPSDONE_SEQSTART0() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSHORTS_LOOPSDONE_SEQSTART1(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSHORTS_LOOPSDONE_SEQSTART1() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetSHORTS_LOOPSDONE_STOP(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetSHORTS_LOOPSDONE_STOP() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}

// PWM.INTEN: Enable or disable interrupt
func (o *PWM_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetINTEN_SEQSTARTED0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetINTEN_SEQSTARTED0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetINTEN_SEQSTARTED1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetINTEN_SEQSTARTED1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetINTEN_SEQEND0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetINTEN_SEQEND0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetINTEN_SEQEND1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetINTEN_SEQEND1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetINTEN_PWMPERIODEND(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetINTEN_PWMPERIODEND() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetINTEN_LOOPSDONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetINTEN_LOOPSDONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}

// PWM.INTENSET: Enable interrupt
func (o *PWM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetINTENSET_SEQSTARTED0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetINTENSET_SEQSTARTED0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetINTENSET_SEQSTARTED1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetINTENSET_SEQSTARTED1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetINTENSET_SEQEND0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetINTENSET_SEQEND0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetINTENSET_SEQEND1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetINTENSET_SEQEND1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetINTENSET_PWMPERIODEND(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetINTENSET_PWMPERIODEND() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetINTENSET_LOOPSDONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetINTENSET_LOOPSDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}

// PWM.INTENCLR: Disable interrupt
func (o *PWM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetINTENCLR_SEQSTARTED0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetINTENCLR_SEQSTARTED0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetINTENCLR_SEQSTARTED1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetINTENCLR_SEQSTARTED1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *PWM_Type) SetINTENCLR_SEQEND0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *PWM_Type) GetINTENCLR_SEQEND0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *PWM_Type) SetINTENCLR_SEQEND1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *PWM_Type) GetINTENCLR_SEQEND1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *PWM_Type) SetINTENCLR_PWMPERIODEND(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *PWM_Type) GetINTENCLR_PWMPERIODEND() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *PWM_Type) SetINTENCLR_LOOPSDONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *PWM_Type) GetINTENCLR_LOOPSDONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}

// PWM.ENABLE: PWM module enable register
func (o *PWM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// PWM.MODE: Selects operating mode of the wave counter
func (o *PWM_Type) SetMODE_UPDOWN(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetMODE_UPDOWN() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}

// PWM.COUNTERTOP: Value up to which the pulse generator counter counts
func (o *PWM_Type) SetCOUNTERTOP(value uint32) {
	volatile.StoreUint32(&o.COUNTERTOP.Reg, volatile.LoadUint32(&o.COUNTERTOP.Reg)&^(0x7fff)|value)
}
func (o *PWM_Type) GetCOUNTERTOP() uint32 {
	return volatile.LoadUint32(&o.COUNTERTOP.Reg) & 0x7fff
}

// PWM.PRESCALER: Configuration for PWM_CLK
func (o *PWM_Type) SetPRESCALER(value uint32) {
	volatile.StoreUint32(&o.PRESCALER.Reg, volatile.LoadUint32(&o.PRESCALER.Reg)&^(0x7)|value)
}
func (o *PWM_Type) GetPRESCALER() uint32 {
	return volatile.LoadUint32(&o.PRESCALER.Reg) & 0x7
}

// PWM.DECODER: Configuration of the decoder
func (o *PWM_Type) SetDECODER_LOAD(value uint32) {
	volatile.StoreUint32(&o.DECODER.Reg, volatile.LoadUint32(&o.DECODER.Reg)&^(0x3)|value)
}
func (o *PWM_Type) GetDECODER_LOAD() uint32 {
	return volatile.LoadUint32(&o.DECODER.Reg) & 0x3
}
func (o *PWM_Type) SetDECODER_MODE(value uint32) {
	volatile.StoreUint32(&o.DECODER.Reg, volatile.LoadUint32(&o.DECODER.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetDECODER_MODE() uint32 {
	return (volatile.LoadUint32(&o.DECODER.Reg) & 0x100) >> 8
}

// PWM.LOOP: Number of playbacks of a loop
func (o *PWM_Type) SetLOOP_CNT(value uint32) {
	volatile.StoreUint32(&o.LOOP.Reg, volatile.LoadUint32(&o.LOOP.Reg)&^(0xffff)|value)
}
func (o *PWM_Type) GetLOOP_CNT() uint32 {
	return volatile.LoadUint32(&o.LOOP.Reg) & 0xffff
}

// Unspecified
type PWM_SEQ_Type struct {
	PTR      volatile.Register32 // 0x520
	CNT      volatile.Register32 // 0x524
	REFRESH  volatile.Register32 // 0x528
	ENDDELAY volatile.Register32 // 0x52C
	_        [16]byte
}

// PWM_SEQ.PTR: Description cluster: Beginning address in RAM of this sequence
func (o *PWM_SEQ_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *PWM_SEQ_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// PWM_SEQ.CNT: Description cluster: Number of values (duty cycles) in this sequence
func (o *PWM_SEQ_Type) SetCNT(value uint32) {
	volatile.StoreUint32(&o.CNT.Reg, volatile.LoadUint32(&o.CNT.Reg)&^(0x7fff)|value)
}
func (o *PWM_SEQ_Type) GetCNT() uint32 {
	return volatile.LoadUint32(&o.CNT.Reg) & 0x7fff
}

// PWM_SEQ.REFRESH: Description cluster: Number of additional PWM periods between samples loaded into compare register
func (o *PWM_SEQ_Type) SetREFRESH_CNT(value uint32) {
	volatile.StoreUint32(&o.REFRESH.Reg, volatile.LoadUint32(&o.REFRESH.Reg)&^(0xffffff)|value)
}
func (o *PWM_SEQ_Type) GetREFRESH_CNT() uint32 {
	return volatile.LoadUint32(&o.REFRESH.Reg) & 0xffffff
}

// PWM_SEQ.ENDDELAY: Description cluster: Time added after the sequence
func (o *PWM_SEQ_Type) SetENDDELAY_CNT(value uint32) {
	volatile.StoreUint32(&o.ENDDELAY.Reg, volatile.LoadUint32(&o.ENDDELAY.Reg)&^(0xffffff)|value)
}
func (o *PWM_SEQ_Type) GetENDDELAY_CNT() uint32 {
	return volatile.LoadUint32(&o.ENDDELAY.Reg) & 0xffffff
}

// Unspecified
type PWM_PSEL_Type struct {
	OUT [4]volatile.Register32 // 0x560
}

// Pulse Density Modulation (Digital Microphone) Interface
type PDM_Type struct {
	TASKS_START    volatile.Register32 // 0x0
	TASKS_STOP     volatile.Register32 // 0x4
	_              [248]byte
	EVENTS_STARTED volatile.Register32 // 0x100
	EVENTS_STOPPED volatile.Register32 // 0x104
	EVENTS_END     volatile.Register32 // 0x108
	_              [500]byte
	INTEN          volatile.Register32 // 0x300
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [500]byte
	ENABLE         volatile.Register32 // 0x500
	PDMCLKCTRL     volatile.Register32 // 0x504
	MODE           volatile.Register32 // 0x508
	_              [12]byte
	GAINL          volatile.Register32 // 0x518
	GAINR          volatile.Register32 // 0x51C
	RATIO          volatile.Register32 // 0x520
	_              [28]byte
	PSEL           PDM_PSEL_Type // 0x540
	_              [24]byte
	SAMPLE         PDM_SAMPLE_Type // 0x560
}

// PDM.TASKS_START: Starts continuous PDM transfer
func (o *PDM_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// PDM.TASKS_STOP: Stops PDM transfer
func (o *PDM_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// PDM.EVENTS_STARTED: PDM transfer has started
func (o *PDM_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// PDM.EVENTS_STOPPED: PDM transfer has finished
func (o *PDM_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// PDM.EVENTS_END: The PDM has written the last sample specified by SAMPLE.MAXCNT (or the last sample after a STOP task has been received) to Data RAM
func (o *PDM_Type) SetEVENTS_END(value uint32) {
	volatile.StoreUint32(&o.EVENTS_END.Reg, volatile.LoadUint32(&o.EVENTS_END.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetEVENTS_END() uint32 {
	return volatile.LoadUint32(&o.EVENTS_END.Reg) & 0x1
}

// PDM.INTEN: Enable or disable interrupt
func (o *PDM_Type) SetINTEN_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetINTEN_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *PDM_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *PDM_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *PDM_Type) SetINTEN_END(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *PDM_Type) GetINTEN_END() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}

// PDM.INTENSET: Enable interrupt
func (o *PDM_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetINTENSET_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *PDM_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *PDM_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *PDM_Type) SetINTENSET_END(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *PDM_Type) GetINTENSET_END() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// PDM.INTENCLR: Disable interrupt
func (o *PDM_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetINTENCLR_STARTED() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *PDM_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *PDM_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *PDM_Type) SetINTENCLR_END(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *PDM_Type) GetINTENCLR_END() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// PDM.ENABLE: PDM module enable register
func (o *PDM_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// PDM.PDMCLKCTRL: PDM clock generator control
func (o *PDM_Type) SetPDMCLKCTRL(value uint32) {
	volatile.StoreUint32(&o.PDMCLKCTRL.Reg, value)
}
func (o *PDM_Type) GetPDMCLKCTRL() uint32 {
	return volatile.LoadUint32(&o.PDMCLKCTRL.Reg)
}

// PDM.MODE: Defines the routing of the connected PDM microphones' signals
func (o *PDM_Type) SetMODE_OPERATION(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetMODE_OPERATION() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}
func (o *PDM_Type) SetMODE_EDGE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x2)|value<<1)
}
func (o *PDM_Type) GetMODE_EDGE() uint32 {
	return (volatile.LoadUint32(&o.MODE.Reg) & 0x2) >> 1
}

// PDM.GAINL: Left output gain adjustment
func (o *PDM_Type) SetGAINL(value uint32) {
	volatile.StoreUint32(&o.GAINL.Reg, volatile.LoadUint32(&o.GAINL.Reg)&^(0x7f)|value)
}
func (o *PDM_Type) GetGAINL() uint32 {
	return volatile.LoadUint32(&o.GAINL.Reg) & 0x7f
}

// PDM.GAINR: Right output gain adjustment
func (o *PDM_Type) SetGAINR(value uint32) {
	volatile.StoreUint32(&o.GAINR.Reg, volatile.LoadUint32(&o.GAINR.Reg)&^(0x7f)|value)
}
func (o *PDM_Type) GetGAINR() uint32 {
	return volatile.LoadUint32(&o.GAINR.Reg) & 0x7f
}

// PDM.RATIO: Selects the ratio between PDM_CLK and output sample rate. Change PDMCLKCTRL accordingly.
func (o *PDM_Type) SetRATIO(value uint32) {
	volatile.StoreUint32(&o.RATIO.Reg, volatile.LoadUint32(&o.RATIO.Reg)&^(0x1)|value)
}
func (o *PDM_Type) GetRATIO() uint32 {
	return volatile.LoadUint32(&o.RATIO.Reg) & 0x1
}

// Unspecified
type PDM_PSEL_Type struct {
	CLK volatile.Register32 // 0x540
	DIN volatile.Register32 // 0x544
}

// PDM_PSEL.CLK: Pin number configuration for PDM CLK signal
func (o *PDM_PSEL_Type) SetCLK_PIN(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x1f)|value)
}
func (o *PDM_PSEL_Type) GetCLK_PIN() uint32 {
	return volatile.LoadUint32(&o.CLK.Reg) & 0x1f
}
func (o *PDM_PSEL_Type) SetCLK_PORT(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x20)|value<<5)
}
func (o *PDM_PSEL_Type) GetCLK_PORT() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x20) >> 5
}
func (o *PDM_PSEL_Type) SetCLK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.CLK.Reg, volatile.LoadUint32(&o.CLK.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_PSEL_Type) GetCLK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.CLK.Reg) & 0x80000000) >> 31
}

// PDM_PSEL.DIN: Pin number configuration for PDM DIN signal
func (o *PDM_PSEL_Type) SetDIN_PIN(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, volatile.LoadUint32(&o.DIN.Reg)&^(0x1f)|value)
}
func (o *PDM_PSEL_Type) GetDIN_PIN() uint32 {
	return volatile.LoadUint32(&o.DIN.Reg) & 0x1f
}
func (o *PDM_PSEL_Type) SetDIN_PORT(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, volatile.LoadUint32(&o.DIN.Reg)&^(0x20)|value<<5)
}
func (o *PDM_PSEL_Type) GetDIN_PORT() uint32 {
	return (volatile.LoadUint32(&o.DIN.Reg) & 0x20) >> 5
}
func (o *PDM_PSEL_Type) SetDIN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.DIN.Reg, volatile.LoadUint32(&o.DIN.Reg)&^(0x80000000)|value<<31)
}
func (o *PDM_PSEL_Type) GetDIN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.DIN.Reg) & 0x80000000) >> 31
}

// Unspecified
type PDM_SAMPLE_Type struct {
	PTR    volatile.Register32 // 0x560
	MAXCNT volatile.Register32 // 0x564
}

// PDM_SAMPLE.PTR: RAM address pointer to write samples to with EasyDMA
func (o *PDM_SAMPLE_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *PDM_SAMPLE_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// PDM_SAMPLE.MAXCNT: Number of samples to allocate memory for in EasyDMA mode
func (o *PDM_SAMPLE_Type) SetMAXCNT_BUFFSIZE(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x7fff)|value)
}
func (o *PDM_SAMPLE_Type) GetMAXCNT_BUFFSIZE() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x7fff
}

// Access control lists
type ACL_Type struct {
	_   [2048]byte
	ACL [8]ACL_ACL_Type // 0x800
}

// Unspecified
type ACL_ACL_Type struct {
	ADDR volatile.Register32 // 0x800
	SIZE volatile.Register32 // 0x804
	PERM volatile.Register32 // 0x808
	_    [4]byte
}

// ACL_ACL.ADDR: Description cluster: Configure the word-aligned start address of region n to protect
func (o *ACL_ACL_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, value)
}
func (o *ACL_ACL_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg)
}

// ACL_ACL.SIZE: Description cluster: Size of region to protect counting from address ACL[n].ADDR. Write '0' as no effect.
func (o *ACL_ACL_Type) SetSIZE(value uint32) {
	volatile.StoreUint32(&o.SIZE.Reg, value)
}
func (o *ACL_ACL_Type) GetSIZE() uint32 {
	return volatile.LoadUint32(&o.SIZE.Reg)
}

// ACL_ACL.PERM: Description cluster: Access permissions for region n as defined by start address ACL[n].ADDR and size ACL[n].SIZE
func (o *ACL_ACL_Type) SetPERM_WRITE(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x2)|value<<1)
}
func (o *ACL_ACL_Type) GetPERM_WRITE() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x2) >> 1
}
func (o *ACL_ACL_Type) SetPERM_READ(value uint32) {
	volatile.StoreUint32(&o.PERM.Reg, volatile.LoadUint32(&o.PERM.Reg)&^(0x4)|value<<2)
}
func (o *ACL_ACL_Type) GetPERM_READ() uint32 {
	return (volatile.LoadUint32(&o.PERM.Reg) & 0x4) >> 2
}

// Non Volatile Memory Controller
type NVMC_Type struct {
	_                   [1024]byte
	READY               volatile.Register32 // 0x400
	_                   [4]byte
	READYNEXT           volatile.Register32 // 0x408
	_                   [248]byte
	CONFIG              volatile.Register32 // 0x504
	ERASEPAGE           volatile.Register32 // 0x508
	ERASEALL            volatile.Register32 // 0x50C
	ERASEPCR0           volatile.Register32 // 0x510
	ERASEUICR           volatile.Register32 // 0x514
	ERASEPAGEPARTIAL    volatile.Register32 // 0x518
	ERASEPAGEPARTIALCFG volatile.Register32 // 0x51C
	_                   [32]byte
	ICACHECNF           volatile.Register32 // 0x540
	_                   [4]byte
	IHIT                volatile.Register32 // 0x548
	IMISS               volatile.Register32 // 0x54C
}

// NVMC.READY: Ready flag
func (o *NVMC_Type) SetREADY(value uint32) {
	volatile.StoreUint32(&o.READY.Reg, volatile.LoadUint32(&o.READY.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetREADY() uint32 {
	return volatile.LoadUint32(&o.READY.Reg) & 0x1
}

// NVMC.READYNEXT: Ready flag
func (o *NVMC_Type) SetREADYNEXT(value uint32) {
	volatile.StoreUint32(&o.READYNEXT.Reg, volatile.LoadUint32(&o.READYNEXT.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetREADYNEXT() uint32 {
	return volatile.LoadUint32(&o.READYNEXT.Reg) & 0x1
}

// NVMC.CONFIG: Configuration register
func (o *NVMC_Type) SetCONFIG_WEN(value uint32) {
	volatile.StoreUint32(&o.CONFIG.Reg, volatile.LoadUint32(&o.CONFIG.Reg)&^(0x3)|value)
}
func (o *NVMC_Type) GetCONFIG_WEN() uint32 {
	return volatile.LoadUint32(&o.CONFIG.Reg) & 0x3
}

// NVMC.ERASEPAGE: Register for erasing a page in code area
func (o *NVMC_Type) SetERASEPAGE(value uint32) {
	volatile.StoreUint32(&o.ERASEPAGE.Reg, value)
}
func (o *NVMC_Type) GetERASEPAGE() uint32 {
	return volatile.LoadUint32(&o.ERASEPAGE.Reg)
}

// NVMC.ERASEALL: Register for erasing all non-volatile user memory
func (o *NVMC_Type) SetERASEALL(value uint32) {
	volatile.StoreUint32(&o.ERASEALL.Reg, volatile.LoadUint32(&o.ERASEALL.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetERASEALL() uint32 {
	return volatile.LoadUint32(&o.ERASEALL.Reg) & 0x1
}

// NVMC.ERASEPCR0: Deprecated register - Register for erasing a page in code area, equivalent to ERASEPAGE
func (o *NVMC_Type) SetERASEPCR0(value uint32) {
	volatile.StoreUint32(&o.ERASEPCR0.Reg, value)
}
func (o *NVMC_Type) GetERASEPCR0() uint32 {
	return volatile.LoadUint32(&o.ERASEPCR0.Reg)
}

// NVMC.ERASEUICR: Register for erasing user information configuration registers
func (o *NVMC_Type) SetERASEUICR(value uint32) {
	volatile.StoreUint32(&o.ERASEUICR.Reg, volatile.LoadUint32(&o.ERASEUICR.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetERASEUICR() uint32 {
	return volatile.LoadUint32(&o.ERASEUICR.Reg) & 0x1
}

// NVMC.ERASEPAGEPARTIAL: Register for partial erase of a page in code area
func (o *NVMC_Type) SetERASEPAGEPARTIAL(value uint32) {
	volatile.StoreUint32(&o.ERASEPAGEPARTIAL.Reg, value)
}
func (o *NVMC_Type) GetERASEPAGEPARTIAL() uint32 {
	return volatile.LoadUint32(&o.ERASEPAGEPARTIAL.Reg)
}

// NVMC.ERASEPAGEPARTIALCFG: Register for partial erase configuration
func (o *NVMC_Type) SetERASEPAGEPARTIALCFG_DURATION(value uint32) {
	volatile.StoreUint32(&o.ERASEPAGEPARTIALCFG.Reg, volatile.LoadUint32(&o.ERASEPAGEPARTIALCFG.Reg)&^(0x7f)|value)
}
func (o *NVMC_Type) GetERASEPAGEPARTIALCFG_DURATION() uint32 {
	return volatile.LoadUint32(&o.ERASEPAGEPARTIALCFG.Reg) & 0x7f
}

// NVMC.ICACHECNF: I-code cache configuration register
func (o *NVMC_Type) SetICACHECNF_CACHEEN(value uint32) {
	volatile.StoreUint32(&o.ICACHECNF.Reg, volatile.LoadUint32(&o.ICACHECNF.Reg)&^(0x1)|value)
}
func (o *NVMC_Type) GetICACHECNF_CACHEEN() uint32 {
	return volatile.LoadUint32(&o.ICACHECNF.Reg) & 0x1
}
func (o *NVMC_Type) SetICACHECNF_CACHEPROFEN(value uint32) {
	volatile.StoreUint32(&o.ICACHECNF.Reg, volatile.LoadUint32(&o.ICACHECNF.Reg)&^(0x100)|value<<8)
}
func (o *NVMC_Type) GetICACHECNF_CACHEPROFEN() uint32 {
	return (volatile.LoadUint32(&o.ICACHECNF.Reg) & 0x100) >> 8
}

// NVMC.IHIT: I-code cache hit counter
func (o *NVMC_Type) SetIHIT(value uint32) {
	volatile.StoreUint32(&o.IHIT.Reg, value)
}
func (o *NVMC_Type) GetIHIT() uint32 {
	return volatile.LoadUint32(&o.IHIT.Reg)
}

// NVMC.IMISS: I-code cache miss counter
func (o *NVMC_Type) SetIMISS(value uint32) {
	volatile.StoreUint32(&o.IMISS.Reg, value)
}
func (o *NVMC_Type) GetIMISS() uint32 {
	return volatile.LoadUint32(&o.IMISS.Reg)
}

// Programmable Peripheral Interconnect
type PPI_Type struct {
	TASKS_CHG [6]PPI_TASKS_CHG_Type // 0x0
	_         [1232]byte
	CHEN      volatile.Register32 // 0x500
	CHENSET   volatile.Register32 // 0x504
	CHENCLR   volatile.Register32 // 0x508
	_         [4]byte
	CH        [20]PPI_CH_Type // 0x510
	_         [592]byte
	CHG       [6]volatile.Register32 // 0x800
	_         [248]byte
	FORK      [32]PPI_FORK_Type // 0x910
}

// PPI.CHEN: Channel enable register
func (o *PPI_Type) SetCHEN_CH0(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x1)|value)
}
func (o *PPI_Type) GetCHEN_CH0() uint32 {
	return volatile.LoadUint32(&o.CHEN.Reg) & 0x1
}
func (o *PPI_Type) SetCHEN_CH1(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x2)|value<<1)
}
func (o *PPI_Type) GetCHEN_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x2) >> 1
}
func (o *PPI_Type) SetCHEN_CH2(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x4)|value<<2)
}
func (o *PPI_Type) GetCHEN_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x4) >> 2
}
func (o *PPI_Type) SetCHEN_CH3(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x8)|value<<3)
}
func (o *PPI_Type) GetCHEN_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x8) >> 3
}
func (o *PPI_Type) SetCHEN_CH4(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x10)|value<<4)
}
func (o *PPI_Type) GetCHEN_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x10) >> 4
}
func (o *PPI_Type) SetCHEN_CH5(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x20)|value<<5)
}
func (o *PPI_Type) GetCHEN_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x20) >> 5
}
func (o *PPI_Type) SetCHEN_CH6(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x40)|value<<6)
}
func (o *PPI_Type) GetCHEN_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x40) >> 6
}
func (o *PPI_Type) SetCHEN_CH7(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x80)|value<<7)
}
func (o *PPI_Type) GetCHEN_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x80) >> 7
}
func (o *PPI_Type) SetCHEN_CH8(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x100)|value<<8)
}
func (o *PPI_Type) GetCHEN_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x100) >> 8
}
func (o *PPI_Type) SetCHEN_CH9(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x200)|value<<9)
}
func (o *PPI_Type) GetCHEN_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x200) >> 9
}
func (o *PPI_Type) SetCHEN_CH10(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x400)|value<<10)
}
func (o *PPI_Type) GetCHEN_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x400) >> 10
}
func (o *PPI_Type) SetCHEN_CH11(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x800)|value<<11)
}
func (o *PPI_Type) GetCHEN_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x800) >> 11
}
func (o *PPI_Type) SetCHEN_CH12(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x1000)|value<<12)
}
func (o *PPI_Type) GetCHEN_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x1000) >> 12
}
func (o *PPI_Type) SetCHEN_CH13(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x2000)|value<<13)
}
func (o *PPI_Type) GetCHEN_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x2000) >> 13
}
func (o *PPI_Type) SetCHEN_CH14(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x4000)|value<<14)
}
func (o *PPI_Type) GetCHEN_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x4000) >> 14
}
func (o *PPI_Type) SetCHEN_CH15(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x8000)|value<<15)
}
func (o *PPI_Type) GetCHEN_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x8000) >> 15
}
func (o *PPI_Type) SetCHEN_CH16(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x10000)|value<<16)
}
func (o *PPI_Type) GetCHEN_CH16() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x10000) >> 16
}
func (o *PPI_Type) SetCHEN_CH17(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x20000)|value<<17)
}
func (o *PPI_Type) GetCHEN_CH17() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x20000) >> 17
}
func (o *PPI_Type) SetCHEN_CH18(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x40000)|value<<18)
}
func (o *PPI_Type) GetCHEN_CH18() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x40000) >> 18
}
func (o *PPI_Type) SetCHEN_CH19(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x80000)|value<<19)
}
func (o *PPI_Type) GetCHEN_CH19() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x80000) >> 19
}
func (o *PPI_Type) SetCHEN_CH20(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x100000)|value<<20)
}
func (o *PPI_Type) GetCHEN_CH20() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x100000) >> 20
}
func (o *PPI_Type) SetCHEN_CH21(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x200000)|value<<21)
}
func (o *PPI_Type) GetCHEN_CH21() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x200000) >> 21
}
func (o *PPI_Type) SetCHEN_CH22(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x400000)|value<<22)
}
func (o *PPI_Type) GetCHEN_CH22() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x400000) >> 22
}
func (o *PPI_Type) SetCHEN_CH23(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x800000)|value<<23)
}
func (o *PPI_Type) GetCHEN_CH23() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x800000) >> 23
}
func (o *PPI_Type) SetCHEN_CH24(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x1000000)|value<<24)
}
func (o *PPI_Type) GetCHEN_CH24() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x1000000) >> 24
}
func (o *PPI_Type) SetCHEN_CH25(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x2000000)|value<<25)
}
func (o *PPI_Type) GetCHEN_CH25() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x2000000) >> 25
}
func (o *PPI_Type) SetCHEN_CH26(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x4000000)|value<<26)
}
func (o *PPI_Type) GetCHEN_CH26() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x4000000) >> 26
}
func (o *PPI_Type) SetCHEN_CH27(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x8000000)|value<<27)
}
func (o *PPI_Type) GetCHEN_CH27() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x8000000) >> 27
}
func (o *PPI_Type) SetCHEN_CH28(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x10000000)|value<<28)
}
func (o *PPI_Type) GetCHEN_CH28() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x10000000) >> 28
}
func (o *PPI_Type) SetCHEN_CH29(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x20000000)|value<<29)
}
func (o *PPI_Type) GetCHEN_CH29() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x20000000) >> 29
}
func (o *PPI_Type) SetCHEN_CH30(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x40000000)|value<<30)
}
func (o *PPI_Type) GetCHEN_CH30() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x40000000) >> 30
}
func (o *PPI_Type) SetCHEN_CH31(value uint32) {
	volatile.StoreUint32(&o.CHEN.Reg, volatile.LoadUint32(&o.CHEN.Reg)&^(0x80000000)|value<<31)
}
func (o *PPI_Type) GetCHEN_CH31() uint32 {
	return (volatile.LoadUint32(&o.CHEN.Reg) & 0x80000000) >> 31
}

// PPI.CHENSET: Channel enable set register
func (o *PPI_Type) SetCHENSET_CH0(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x1)|value)
}
func (o *PPI_Type) GetCHENSET_CH0() uint32 {
	return volatile.LoadUint32(&o.CHENSET.Reg) & 0x1
}
func (o *PPI_Type) SetCHENSET_CH1(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x2)|value<<1)
}
func (o *PPI_Type) GetCHENSET_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x2) >> 1
}
func (o *PPI_Type) SetCHENSET_CH2(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x4)|value<<2)
}
func (o *PPI_Type) GetCHENSET_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x4) >> 2
}
func (o *PPI_Type) SetCHENSET_CH3(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x8)|value<<3)
}
func (o *PPI_Type) GetCHENSET_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x8) >> 3
}
func (o *PPI_Type) SetCHENSET_CH4(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x10)|value<<4)
}
func (o *PPI_Type) GetCHENSET_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x10) >> 4
}
func (o *PPI_Type) SetCHENSET_CH5(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x20)|value<<5)
}
func (o *PPI_Type) GetCHENSET_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x20) >> 5
}
func (o *PPI_Type) SetCHENSET_CH6(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x40)|value<<6)
}
func (o *PPI_Type) GetCHENSET_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x40) >> 6
}
func (o *PPI_Type) SetCHENSET_CH7(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x80)|value<<7)
}
func (o *PPI_Type) GetCHENSET_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x80) >> 7
}
func (o *PPI_Type) SetCHENSET_CH8(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x100)|value<<8)
}
func (o *PPI_Type) GetCHENSET_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x100) >> 8
}
func (o *PPI_Type) SetCHENSET_CH9(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x200)|value<<9)
}
func (o *PPI_Type) GetCHENSET_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x200) >> 9
}
func (o *PPI_Type) SetCHENSET_CH10(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x400)|value<<10)
}
func (o *PPI_Type) GetCHENSET_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x400) >> 10
}
func (o *PPI_Type) SetCHENSET_CH11(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x800)|value<<11)
}
func (o *PPI_Type) GetCHENSET_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x800) >> 11
}
func (o *PPI_Type) SetCHENSET_CH12(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x1000)|value<<12)
}
func (o *PPI_Type) GetCHENSET_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x1000) >> 12
}
func (o *PPI_Type) SetCHENSET_CH13(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x2000)|value<<13)
}
func (o *PPI_Type) GetCHENSET_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x2000) >> 13
}
func (o *PPI_Type) SetCHENSET_CH14(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x4000)|value<<14)
}
func (o *PPI_Type) GetCHENSET_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x4000) >> 14
}
func (o *PPI_Type) SetCHENSET_CH15(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x8000)|value<<15)
}
func (o *PPI_Type) GetCHENSET_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x8000) >> 15
}
func (o *PPI_Type) SetCHENSET_CH16(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x10000)|value<<16)
}
func (o *PPI_Type) GetCHENSET_CH16() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x10000) >> 16
}
func (o *PPI_Type) SetCHENSET_CH17(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x20000)|value<<17)
}
func (o *PPI_Type) GetCHENSET_CH17() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x20000) >> 17
}
func (o *PPI_Type) SetCHENSET_CH18(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x40000)|value<<18)
}
func (o *PPI_Type) GetCHENSET_CH18() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x40000) >> 18
}
func (o *PPI_Type) SetCHENSET_CH19(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x80000)|value<<19)
}
func (o *PPI_Type) GetCHENSET_CH19() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x80000) >> 19
}
func (o *PPI_Type) SetCHENSET_CH20(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x100000)|value<<20)
}
func (o *PPI_Type) GetCHENSET_CH20() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x100000) >> 20
}
func (o *PPI_Type) SetCHENSET_CH21(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x200000)|value<<21)
}
func (o *PPI_Type) GetCHENSET_CH21() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x200000) >> 21
}
func (o *PPI_Type) SetCHENSET_CH22(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x400000)|value<<22)
}
func (o *PPI_Type) GetCHENSET_CH22() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x400000) >> 22
}
func (o *PPI_Type) SetCHENSET_CH23(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x800000)|value<<23)
}
func (o *PPI_Type) GetCHENSET_CH23() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x800000) >> 23
}
func (o *PPI_Type) SetCHENSET_CH24(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *PPI_Type) GetCHENSET_CH24() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x1000000) >> 24
}
func (o *PPI_Type) SetCHENSET_CH25(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x2000000)|value<<25)
}
func (o *PPI_Type) GetCHENSET_CH25() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x2000000) >> 25
}
func (o *PPI_Type) SetCHENSET_CH26(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x4000000)|value<<26)
}
func (o *PPI_Type) GetCHENSET_CH26() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x4000000) >> 26
}
func (o *PPI_Type) SetCHENSET_CH27(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x8000000)|value<<27)
}
func (o *PPI_Type) GetCHENSET_CH27() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x8000000) >> 27
}
func (o *PPI_Type) SetCHENSET_CH28(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x10000000)|value<<28)
}
func (o *PPI_Type) GetCHENSET_CH28() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x10000000) >> 28
}
func (o *PPI_Type) SetCHENSET_CH29(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x20000000)|value<<29)
}
func (o *PPI_Type) GetCHENSET_CH29() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x20000000) >> 29
}
func (o *PPI_Type) SetCHENSET_CH30(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x40000000)|value<<30)
}
func (o *PPI_Type) GetCHENSET_CH30() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x40000000) >> 30
}
func (o *PPI_Type) SetCHENSET_CH31(value uint32) {
	volatile.StoreUint32(&o.CHENSET.Reg, volatile.LoadUint32(&o.CHENSET.Reg)&^(0x80000000)|value<<31)
}
func (o *PPI_Type) GetCHENSET_CH31() uint32 {
	return (volatile.LoadUint32(&o.CHENSET.Reg) & 0x80000000) >> 31
}

// PPI.CHENCLR: Channel enable clear register
func (o *PPI_Type) SetCHENCLR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x1)|value)
}
func (o *PPI_Type) GetCHENCLR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHENCLR.Reg) & 0x1
}
func (o *PPI_Type) SetCHENCLR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x2)|value<<1)
}
func (o *PPI_Type) GetCHENCLR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x2) >> 1
}
func (o *PPI_Type) SetCHENCLR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x4)|value<<2)
}
func (o *PPI_Type) GetCHENCLR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x4) >> 2
}
func (o *PPI_Type) SetCHENCLR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x8)|value<<3)
}
func (o *PPI_Type) GetCHENCLR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x8) >> 3
}
func (o *PPI_Type) SetCHENCLR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x10)|value<<4)
}
func (o *PPI_Type) GetCHENCLR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x10) >> 4
}
func (o *PPI_Type) SetCHENCLR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x20)|value<<5)
}
func (o *PPI_Type) GetCHENCLR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x20) >> 5
}
func (o *PPI_Type) SetCHENCLR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x40)|value<<6)
}
func (o *PPI_Type) GetCHENCLR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x40) >> 6
}
func (o *PPI_Type) SetCHENCLR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x80)|value<<7)
}
func (o *PPI_Type) GetCHENCLR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x80) >> 7
}
func (o *PPI_Type) SetCHENCLR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x100)|value<<8)
}
func (o *PPI_Type) GetCHENCLR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x100) >> 8
}
func (o *PPI_Type) SetCHENCLR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x200)|value<<9)
}
func (o *PPI_Type) GetCHENCLR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x200) >> 9
}
func (o *PPI_Type) SetCHENCLR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x400)|value<<10)
}
func (o *PPI_Type) GetCHENCLR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x400) >> 10
}
func (o *PPI_Type) SetCHENCLR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x800)|value<<11)
}
func (o *PPI_Type) GetCHENCLR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x800) >> 11
}
func (o *PPI_Type) SetCHENCLR_CH12(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *PPI_Type) GetCHENCLR_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x1000) >> 12
}
func (o *PPI_Type) SetCHENCLR_CH13(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *PPI_Type) GetCHENCLR_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x2000) >> 13
}
func (o *PPI_Type) SetCHENCLR_CH14(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *PPI_Type) GetCHENCLR_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x4000) >> 14
}
func (o *PPI_Type) SetCHENCLR_CH15(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *PPI_Type) GetCHENCLR_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x8000) >> 15
}
func (o *PPI_Type) SetCHENCLR_CH16(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *PPI_Type) GetCHENCLR_CH16() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x10000) >> 16
}
func (o *PPI_Type) SetCHENCLR_CH17(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *PPI_Type) GetCHENCLR_CH17() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x20000) >> 17
}
func (o *PPI_Type) SetCHENCLR_CH18(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *PPI_Type) GetCHENCLR_CH18() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x40000) >> 18
}
func (o *PPI_Type) SetCHENCLR_CH19(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *PPI_Type) GetCHENCLR_CH19() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x80000) >> 19
}
func (o *PPI_Type) SetCHENCLR_CH20(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *PPI_Type) GetCHENCLR_CH20() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x100000) >> 20
}
func (o *PPI_Type) SetCHENCLR_CH21(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *PPI_Type) GetCHENCLR_CH21() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x200000) >> 21
}
func (o *PPI_Type) SetCHENCLR_CH22(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x400000)|value<<22)
}
func (o *PPI_Type) GetCHENCLR_CH22() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x400000) >> 22
}
func (o *PPI_Type) SetCHENCLR_CH23(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x800000)|value<<23)
}
func (o *PPI_Type) GetCHENCLR_CH23() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x800000) >> 23
}
func (o *PPI_Type) SetCHENCLR_CH24(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *PPI_Type) GetCHENCLR_CH24() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x1000000) >> 24
}
func (o *PPI_Type) SetCHENCLR_CH25(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *PPI_Type) GetCHENCLR_CH25() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x2000000) >> 25
}
func (o *PPI_Type) SetCHENCLR_CH26(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *PPI_Type) GetCHENCLR_CH26() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x4000000) >> 26
}
func (o *PPI_Type) SetCHENCLR_CH27(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *PPI_Type) GetCHENCLR_CH27() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x8000000) >> 27
}
func (o *PPI_Type) SetCHENCLR_CH28(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x10000000)|value<<28)
}
func (o *PPI_Type) GetCHENCLR_CH28() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x10000000) >> 28
}
func (o *PPI_Type) SetCHENCLR_CH29(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x20000000)|value<<29)
}
func (o *PPI_Type) GetCHENCLR_CH29() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x20000000) >> 29
}
func (o *PPI_Type) SetCHENCLR_CH30(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x40000000)|value<<30)
}
func (o *PPI_Type) GetCHENCLR_CH30() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x40000000) >> 30
}
func (o *PPI_Type) SetCHENCLR_CH31(value uint32) {
	volatile.StoreUint32(&o.CHENCLR.Reg, volatile.LoadUint32(&o.CHENCLR.Reg)&^(0x80000000)|value<<31)
}
func (o *PPI_Type) GetCHENCLR_CH31() uint32 {
	return (volatile.LoadUint32(&o.CHENCLR.Reg) & 0x80000000) >> 31
}

// PPI.CHG: Description collection: Channel group n
func (o *PPI_Type) SetCHG_CH0(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x1)|value)
}
func (o *PPI_Type) GetCHG_CH0(idx int) uint32 {
	return volatile.LoadUint32(&o.CHG[idx].Reg) & 0x1
}
func (o *PPI_Type) SetCHG_CH1(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x2)|value<<1)
}
func (o *PPI_Type) GetCHG_CH1(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x2) >> 1
}
func (o *PPI_Type) SetCHG_CH2(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x4)|value<<2)
}
func (o *PPI_Type) GetCHG_CH2(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x4) >> 2
}
func (o *PPI_Type) SetCHG_CH3(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x8)|value<<3)
}
func (o *PPI_Type) GetCHG_CH3(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x8) >> 3
}
func (o *PPI_Type) SetCHG_CH4(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x10)|value<<4)
}
func (o *PPI_Type) GetCHG_CH4(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x10) >> 4
}
func (o *PPI_Type) SetCHG_CH5(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x20)|value<<5)
}
func (o *PPI_Type) GetCHG_CH5(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x20) >> 5
}
func (o *PPI_Type) SetCHG_CH6(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x40)|value<<6)
}
func (o *PPI_Type) GetCHG_CH6(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x40) >> 6
}
func (o *PPI_Type) SetCHG_CH7(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x80)|value<<7)
}
func (o *PPI_Type) GetCHG_CH7(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x80) >> 7
}
func (o *PPI_Type) SetCHG_CH8(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x100)|value<<8)
}
func (o *PPI_Type) GetCHG_CH8(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x100) >> 8
}
func (o *PPI_Type) SetCHG_CH9(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x200)|value<<9)
}
func (o *PPI_Type) GetCHG_CH9(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x200) >> 9
}
func (o *PPI_Type) SetCHG_CH10(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x400)|value<<10)
}
func (o *PPI_Type) GetCHG_CH10(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x400) >> 10
}
func (o *PPI_Type) SetCHG_CH11(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x800)|value<<11)
}
func (o *PPI_Type) GetCHG_CH11(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x800) >> 11
}
func (o *PPI_Type) SetCHG_CH12(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x1000)|value<<12)
}
func (o *PPI_Type) GetCHG_CH12(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x1000) >> 12
}
func (o *PPI_Type) SetCHG_CH13(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x2000)|value<<13)
}
func (o *PPI_Type) GetCHG_CH13(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x2000) >> 13
}
func (o *PPI_Type) SetCHG_CH14(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x4000)|value<<14)
}
func (o *PPI_Type) GetCHG_CH14(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x4000) >> 14
}
func (o *PPI_Type) SetCHG_CH15(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x8000)|value<<15)
}
func (o *PPI_Type) GetCHG_CH15(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x8000) >> 15
}
func (o *PPI_Type) SetCHG_CH16(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x10000)|value<<16)
}
func (o *PPI_Type) GetCHG_CH16(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x10000) >> 16
}
func (o *PPI_Type) SetCHG_CH17(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x20000)|value<<17)
}
func (o *PPI_Type) GetCHG_CH17(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x20000) >> 17
}
func (o *PPI_Type) SetCHG_CH18(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x40000)|value<<18)
}
func (o *PPI_Type) GetCHG_CH18(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x40000) >> 18
}
func (o *PPI_Type) SetCHG_CH19(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x80000)|value<<19)
}
func (o *PPI_Type) GetCHG_CH19(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x80000) >> 19
}
func (o *PPI_Type) SetCHG_CH20(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x100000)|value<<20)
}
func (o *PPI_Type) GetCHG_CH20(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x100000) >> 20
}
func (o *PPI_Type) SetCHG_CH21(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x200000)|value<<21)
}
func (o *PPI_Type) GetCHG_CH21(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x200000) >> 21
}
func (o *PPI_Type) SetCHG_CH22(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x400000)|value<<22)
}
func (o *PPI_Type) GetCHG_CH22(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x400000) >> 22
}
func (o *PPI_Type) SetCHG_CH23(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x800000)|value<<23)
}
func (o *PPI_Type) GetCHG_CH23(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x800000) >> 23
}
func (o *PPI_Type) SetCHG_CH24(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *PPI_Type) GetCHG_CH24(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x1000000) >> 24
}
func (o *PPI_Type) SetCHG_CH25(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *PPI_Type) GetCHG_CH25(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x2000000) >> 25
}
func (o *PPI_Type) SetCHG_CH26(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *PPI_Type) GetCHG_CH26(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x4000000) >> 26
}
func (o *PPI_Type) SetCHG_CH27(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *PPI_Type) GetCHG_CH27(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x8000000) >> 27
}
func (o *PPI_Type) SetCHG_CH28(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *PPI_Type) GetCHG_CH28(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x10000000) >> 28
}
func (o *PPI_Type) SetCHG_CH29(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *PPI_Type) GetCHG_CH29(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x20000000) >> 29
}
func (o *PPI_Type) SetCHG_CH30(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *PPI_Type) GetCHG_CH30(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x40000000) >> 30
}
func (o *PPI_Type) SetCHG_CH31(idx int, value uint32) {
	volatile.StoreUint32(&o.CHG[idx].Reg, volatile.LoadUint32(&o.CHG[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *PPI_Type) GetCHG_CH31(idx int) uint32 {
	return (volatile.LoadUint32(&o.CHG[idx].Reg) & 0x80000000) >> 31
}

// Channel group tasks
type PPI_TASKS_CHG_Type struct {
	EN  volatile.Register32 // 0x0
	DIS volatile.Register32 // 0x4
}

// PPI_TASKS_CHG.EN: Description cluster: Enable channel group n
func (o *PPI_TASKS_CHG_Type) SetEN(value uint32) {
	volatile.StoreUint32(&o.EN.Reg, volatile.LoadUint32(&o.EN.Reg)&^(0x1)|value)
}
func (o *PPI_TASKS_CHG_Type) GetEN() uint32 {
	return volatile.LoadUint32(&o.EN.Reg) & 0x1
}

// PPI_TASKS_CHG.DIS: Description cluster: Disable channel group n
func (o *PPI_TASKS_CHG_Type) SetDIS(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *PPI_TASKS_CHG_Type) GetDIS() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}

// PPI Channel
type PPI_CH_Type struct {
	EEP volatile.Register32 // 0x510
	TEP volatile.Register32 // 0x514
}

// PPI_CH.EEP: Description cluster: Channel n event end-point
func (o *PPI_CH_Type) SetEEP(value uint32) {
	volatile.StoreUint32(&o.EEP.Reg, value)
}
func (o *PPI_CH_Type) GetEEP() uint32 {
	return volatile.LoadUint32(&o.EEP.Reg)
}

// PPI_CH.TEP: Description cluster: Channel n task end-point
func (o *PPI_CH_Type) SetTEP(value uint32) {
	volatile.StoreUint32(&o.TEP.Reg, value)
}
func (o *PPI_CH_Type) GetTEP() uint32 {
	return volatile.LoadUint32(&o.TEP.Reg)
}

// Fork
type PPI_FORK_Type struct {
	TEP volatile.Register32 // 0x910
}

// PPI_FORK.TEP: Description cluster: Channel n task end-point
func (o *PPI_FORK_Type) SetTEP(value uint32) {
	volatile.StoreUint32(&o.TEP.Reg, value)
}
func (o *PPI_FORK_Type) GetTEP() uint32 {
	return volatile.LoadUint32(&o.TEP.Reg)
}

// Memory Watch Unit
type MWU_Type struct {
	_              [256]byte
	EVENTS_REGION  [4]MWU_EVENTS_REGION_Type // 0x100
	_              [64]byte
	EVENTS_PREGION [2]MWU_EVENTS_PREGION_Type // 0x160
	_              [400]byte
	INTEN          volatile.Register32 // 0x300
	INTENSET       volatile.Register32 // 0x304
	INTENCLR       volatile.Register32 // 0x308
	_              [20]byte
	NMIEN          volatile.Register32 // 0x320
	NMIENSET       volatile.Register32 // 0x324
	NMIENCLR       volatile.Register32 // 0x328
	_              [212]byte
	PERREGION      [2]MWU_PERREGION_Type // 0x400
	_              [256]byte
	REGIONEN       volatile.Register32 // 0x510
	REGIONENSET    volatile.Register32 // 0x514
	REGIONENCLR    volatile.Register32 // 0x518
	_              [228]byte
	REGION         [4]MWU_REGION_Type // 0x600
	_              [128]byte
	PREGION        [2]MWU_PREGION_Type // 0x6C0
}

// MWU.INTEN: Enable or disable interrupt
func (o *MWU_Type) SetINTEN_REGION0WA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *MWU_Type) GetINTEN_REGION0WA() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *MWU_Type) SetINTEN_REGION0RA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *MWU_Type) GetINTEN_REGION0RA() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *MWU_Type) SetINTEN_REGION1WA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *MWU_Type) GetINTEN_REGION1WA() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *MWU_Type) SetINTEN_REGION1RA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *MWU_Type) GetINTEN_REGION1RA() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *MWU_Type) SetINTEN_REGION2WA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *MWU_Type) GetINTEN_REGION2WA() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *MWU_Type) SetINTEN_REGION2RA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *MWU_Type) GetINTEN_REGION2RA() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *MWU_Type) SetINTEN_REGION3WA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *MWU_Type) GetINTEN_REGION3WA() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *MWU_Type) SetINTEN_REGION3RA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *MWU_Type) GetINTEN_REGION3RA() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *MWU_Type) SetINTEN_PREGION0WA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000000)|value<<24)
}
func (o *MWU_Type) GetINTEN_PREGION0WA() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000000) >> 24
}
func (o *MWU_Type) SetINTEN_PREGION0RA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000000)|value<<25)
}
func (o *MWU_Type) GetINTEN_PREGION0RA() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000000) >> 25
}
func (o *MWU_Type) SetINTEN_PREGION1WA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000000)|value<<26)
}
func (o *MWU_Type) GetINTEN_PREGION1WA() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000000) >> 26
}
func (o *MWU_Type) SetINTEN_PREGION1RA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000000)|value<<27)
}
func (o *MWU_Type) GetINTEN_PREGION1RA() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000000) >> 27
}

// MWU.INTENSET: Enable interrupt
func (o *MWU_Type) SetINTENSET_REGION0WA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *MWU_Type) GetINTENSET_REGION0WA() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *MWU_Type) SetINTENSET_REGION0RA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *MWU_Type) GetINTENSET_REGION0RA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *MWU_Type) SetINTENSET_REGION1WA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *MWU_Type) GetINTENSET_REGION1WA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *MWU_Type) SetINTENSET_REGION1RA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *MWU_Type) GetINTENSET_REGION1RA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *MWU_Type) SetINTENSET_REGION2WA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *MWU_Type) GetINTENSET_REGION2WA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *MWU_Type) SetINTENSET_REGION2RA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *MWU_Type) GetINTENSET_REGION2RA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *MWU_Type) SetINTENSET_REGION3WA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *MWU_Type) GetINTENSET_REGION3WA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *MWU_Type) SetINTENSET_REGION3RA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *MWU_Type) GetINTENSET_REGION3RA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *MWU_Type) SetINTENSET_PREGION0WA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *MWU_Type) GetINTENSET_PREGION0WA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000000) >> 24
}
func (o *MWU_Type) SetINTENSET_PREGION0RA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000000)|value<<25)
}
func (o *MWU_Type) GetINTENSET_PREGION0RA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000000) >> 25
}
func (o *MWU_Type) SetINTENSET_PREGION1WA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000000)|value<<26)
}
func (o *MWU_Type) GetINTENSET_PREGION1WA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000000) >> 26
}
func (o *MWU_Type) SetINTENSET_PREGION1RA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000000)|value<<27)
}
func (o *MWU_Type) GetINTENSET_PREGION1RA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000000) >> 27
}

// MWU.INTENCLR: Disable interrupt
func (o *MWU_Type) SetINTENCLR_REGION0WA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *MWU_Type) GetINTENCLR_REGION0WA() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *MWU_Type) SetINTENCLR_REGION0RA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *MWU_Type) GetINTENCLR_REGION0RA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *MWU_Type) SetINTENCLR_REGION1WA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *MWU_Type) GetINTENCLR_REGION1WA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *MWU_Type) SetINTENCLR_REGION1RA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *MWU_Type) GetINTENCLR_REGION1RA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *MWU_Type) SetINTENCLR_REGION2WA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *MWU_Type) GetINTENCLR_REGION2WA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *MWU_Type) SetINTENCLR_REGION2RA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *MWU_Type) GetINTENCLR_REGION2RA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *MWU_Type) SetINTENCLR_REGION3WA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *MWU_Type) GetINTENCLR_REGION3WA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *MWU_Type) SetINTENCLR_REGION3RA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *MWU_Type) GetINTENCLR_REGION3RA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *MWU_Type) SetINTENCLR_PREGION0WA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *MWU_Type) GetINTENCLR_PREGION0WA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000000) >> 24
}
func (o *MWU_Type) SetINTENCLR_PREGION0RA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *MWU_Type) GetINTENCLR_PREGION0RA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000000) >> 25
}
func (o *MWU_Type) SetINTENCLR_PREGION1WA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *MWU_Type) GetINTENCLR_PREGION1WA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000000) >> 26
}
func (o *MWU_Type) SetINTENCLR_PREGION1RA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *MWU_Type) GetINTENCLR_PREGION1RA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000000) >> 27
}

// MWU.NMIEN: Enable or disable interrupt
func (o *MWU_Type) SetNMIEN_REGION0WA(value uint32) {
	volatile.StoreUint32(&o.NMIEN.Reg, volatile.LoadUint32(&o.NMIEN.Reg)&^(0x1)|value)
}
func (o *MWU_Type) GetNMIEN_REGION0WA() uint32 {
	return volatile.LoadUint32(&o.NMIEN.Reg) & 0x1
}
func (o *MWU_Type) SetNMIEN_REGION0RA(value uint32) {
	volatile.StoreUint32(&o.NMIEN.Reg, volatile.LoadUint32(&o.NMIEN.Reg)&^(0x2)|value<<1)
}
func (o *MWU_Type) GetNMIEN_REGION0RA() uint32 {
	return (volatile.LoadUint32(&o.NMIEN.Reg) & 0x2) >> 1
}
func (o *MWU_Type) SetNMIEN_REGION1WA(value uint32) {
	volatile.StoreUint32(&o.NMIEN.Reg, volatile.LoadUint32(&o.NMIEN.Reg)&^(0x4)|value<<2)
}
func (o *MWU_Type) GetNMIEN_REGION1WA() uint32 {
	return (volatile.LoadUint32(&o.NMIEN.Reg) & 0x4) >> 2
}
func (o *MWU_Type) SetNMIEN_REGION1RA(value uint32) {
	volatile.StoreUint32(&o.NMIEN.Reg, volatile.LoadUint32(&o.NMIEN.Reg)&^(0x8)|value<<3)
}
func (o *MWU_Type) GetNMIEN_REGION1RA() uint32 {
	return (volatile.LoadUint32(&o.NMIEN.Reg) & 0x8) >> 3
}
func (o *MWU_Type) SetNMIEN_REGION2WA(value uint32) {
	volatile.StoreUint32(&o.NMIEN.Reg, volatile.LoadUint32(&o.NMIEN.Reg)&^(0x10)|value<<4)
}
func (o *MWU_Type) GetNMIEN_REGION2WA() uint32 {
	return (volatile.LoadUint32(&o.NMIEN.Reg) & 0x10) >> 4
}
func (o *MWU_Type) SetNMIEN_REGION2RA(value uint32) {
	volatile.StoreUint32(&o.NMIEN.Reg, volatile.LoadUint32(&o.NMIEN.Reg)&^(0x20)|value<<5)
}
func (o *MWU_Type) GetNMIEN_REGION2RA() uint32 {
	return (volatile.LoadUint32(&o.NMIEN.Reg) & 0x20) >> 5
}
func (o *MWU_Type) SetNMIEN_REGION3WA(value uint32) {
	volatile.StoreUint32(&o.NMIEN.Reg, volatile.LoadUint32(&o.NMIEN.Reg)&^(0x40)|value<<6)
}
func (o *MWU_Type) GetNMIEN_REGION3WA() uint32 {
	return (volatile.LoadUint32(&o.NMIEN.Reg) & 0x40) >> 6
}
func (o *MWU_Type) SetNMIEN_REGION3RA(value uint32) {
	volatile.StoreUint32(&o.NMIEN.Reg, volatile.LoadUint32(&o.NMIEN.Reg)&^(0x80)|value<<7)
}
func (o *MWU_Type) GetNMIEN_REGION3RA() uint32 {
	return (volatile.LoadUint32(&o.NMIEN.Reg) & 0x80) >> 7
}
func (o *MWU_Type) SetNMIEN_PREGION0WA(value uint32) {
	volatile.StoreUint32(&o.NMIEN.Reg, volatile.LoadUint32(&o.NMIEN.Reg)&^(0x1000000)|value<<24)
}
func (o *MWU_Type) GetNMIEN_PREGION0WA() uint32 {
	return (volatile.LoadUint32(&o.NMIEN.Reg) & 0x1000000) >> 24
}
func (o *MWU_Type) SetNMIEN_PREGION0RA(value uint32) {
	volatile.StoreUint32(&o.NMIEN.Reg, volatile.LoadUint32(&o.NMIEN.Reg)&^(0x2000000)|value<<25)
}
func (o *MWU_Type) GetNMIEN_PREGION0RA() uint32 {
	return (volatile.LoadUint32(&o.NMIEN.Reg) & 0x2000000) >> 25
}
func (o *MWU_Type) SetNMIEN_PREGION1WA(value uint32) {
	volatile.StoreUint32(&o.NMIEN.Reg, volatile.LoadUint32(&o.NMIEN.Reg)&^(0x4000000)|value<<26)
}
func (o *MWU_Type) GetNMIEN_PREGION1WA() uint32 {
	return (volatile.LoadUint32(&o.NMIEN.Reg) & 0x4000000) >> 26
}
func (o *MWU_Type) SetNMIEN_PREGION1RA(value uint32) {
	volatile.StoreUint32(&o.NMIEN.Reg, volatile.LoadUint32(&o.NMIEN.Reg)&^(0x8000000)|value<<27)
}
func (o *MWU_Type) GetNMIEN_PREGION1RA() uint32 {
	return (volatile.LoadUint32(&o.NMIEN.Reg) & 0x8000000) >> 27
}

// MWU.NMIENSET: Enable interrupt
func (o *MWU_Type) SetNMIENSET_REGION0WA(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x1)|value)
}
func (o *MWU_Type) GetNMIENSET_REGION0WA() uint32 {
	return volatile.LoadUint32(&o.NMIENSET.Reg) & 0x1
}
func (o *MWU_Type) SetNMIENSET_REGION0RA(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x2)|value<<1)
}
func (o *MWU_Type) GetNMIENSET_REGION0RA() uint32 {
	return (volatile.LoadUint32(&o.NMIENSET.Reg) & 0x2) >> 1
}
func (o *MWU_Type) SetNMIENSET_REGION1WA(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x4)|value<<2)
}
func (o *MWU_Type) GetNMIENSET_REGION1WA() uint32 {
	return (volatile.LoadUint32(&o.NMIENSET.Reg) & 0x4) >> 2
}
func (o *MWU_Type) SetNMIENSET_REGION1RA(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x8)|value<<3)
}
func (o *MWU_Type) GetNMIENSET_REGION1RA() uint32 {
	return (volatile.LoadUint32(&o.NMIENSET.Reg) & 0x8) >> 3
}
func (o *MWU_Type) SetNMIENSET_REGION2WA(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x10)|value<<4)
}
func (o *MWU_Type) GetNMIENSET_REGION2WA() uint32 {
	return (volatile.LoadUint32(&o.NMIENSET.Reg) & 0x10) >> 4
}
func (o *MWU_Type) SetNMIENSET_REGION2RA(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x20)|value<<5)
}
func (o *MWU_Type) GetNMIENSET_REGION2RA() uint32 {
	return (volatile.LoadUint32(&o.NMIENSET.Reg) & 0x20) >> 5
}
func (o *MWU_Type) SetNMIENSET_REGION3WA(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x40)|value<<6)
}
func (o *MWU_Type) GetNMIENSET_REGION3WA() uint32 {
	return (volatile.LoadUint32(&o.NMIENSET.Reg) & 0x40) >> 6
}
func (o *MWU_Type) SetNMIENSET_REGION3RA(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x80)|value<<7)
}
func (o *MWU_Type) GetNMIENSET_REGION3RA() uint32 {
	return (volatile.LoadUint32(&o.NMIENSET.Reg) & 0x80) >> 7
}
func (o *MWU_Type) SetNMIENSET_PREGION0WA(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *MWU_Type) GetNMIENSET_PREGION0WA() uint32 {
	return (volatile.LoadUint32(&o.NMIENSET.Reg) & 0x1000000) >> 24
}
func (o *MWU_Type) SetNMIENSET_PREGION0RA(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x2000000)|value<<25)
}
func (o *MWU_Type) GetNMIENSET_PREGION0RA() uint32 {
	return (volatile.LoadUint32(&o.NMIENSET.Reg) & 0x2000000) >> 25
}
func (o *MWU_Type) SetNMIENSET_PREGION1WA(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x4000000)|value<<26)
}
func (o *MWU_Type) GetNMIENSET_PREGION1WA() uint32 {
	return (volatile.LoadUint32(&o.NMIENSET.Reg) & 0x4000000) >> 26
}
func (o *MWU_Type) SetNMIENSET_PREGION1RA(value uint32) {
	volatile.StoreUint32(&o.NMIENSET.Reg, volatile.LoadUint32(&o.NMIENSET.Reg)&^(0x8000000)|value<<27)
}
func (o *MWU_Type) GetNMIENSET_PREGION1RA() uint32 {
	return (volatile.LoadUint32(&o.NMIENSET.Reg) & 0x8000000) >> 27
}

// MWU.NMIENCLR: Disable interrupt
func (o *MWU_Type) SetNMIENCLR_REGION0WA(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x1)|value)
}
func (o *MWU_Type) GetNMIENCLR_REGION0WA() uint32 {
	return volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x1
}
func (o *MWU_Type) SetNMIENCLR_REGION0RA(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x2)|value<<1)
}
func (o *MWU_Type) GetNMIENCLR_REGION0RA() uint32 {
	return (volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x2) >> 1
}
func (o *MWU_Type) SetNMIENCLR_REGION1WA(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x4)|value<<2)
}
func (o *MWU_Type) GetNMIENCLR_REGION1WA() uint32 {
	return (volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x4) >> 2
}
func (o *MWU_Type) SetNMIENCLR_REGION1RA(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x8)|value<<3)
}
func (o *MWU_Type) GetNMIENCLR_REGION1RA() uint32 {
	return (volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x8) >> 3
}
func (o *MWU_Type) SetNMIENCLR_REGION2WA(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x10)|value<<4)
}
func (o *MWU_Type) GetNMIENCLR_REGION2WA() uint32 {
	return (volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x10) >> 4
}
func (o *MWU_Type) SetNMIENCLR_REGION2RA(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x20)|value<<5)
}
func (o *MWU_Type) GetNMIENCLR_REGION2RA() uint32 {
	return (volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x20) >> 5
}
func (o *MWU_Type) SetNMIENCLR_REGION3WA(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x40)|value<<6)
}
func (o *MWU_Type) GetNMIENCLR_REGION3WA() uint32 {
	return (volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x40) >> 6
}
func (o *MWU_Type) SetNMIENCLR_REGION3RA(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x80)|value<<7)
}
func (o *MWU_Type) GetNMIENCLR_REGION3RA() uint32 {
	return (volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x80) >> 7
}
func (o *MWU_Type) SetNMIENCLR_PREGION0WA(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *MWU_Type) GetNMIENCLR_PREGION0WA() uint32 {
	return (volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x1000000) >> 24
}
func (o *MWU_Type) SetNMIENCLR_PREGION0RA(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *MWU_Type) GetNMIENCLR_PREGION0RA() uint32 {
	return (volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x2000000) >> 25
}
func (o *MWU_Type) SetNMIENCLR_PREGION1WA(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *MWU_Type) GetNMIENCLR_PREGION1WA() uint32 {
	return (volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x4000000) >> 26
}
func (o *MWU_Type) SetNMIENCLR_PREGION1RA(value uint32) {
	volatile.StoreUint32(&o.NMIENCLR.Reg, volatile.LoadUint32(&o.NMIENCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *MWU_Type) GetNMIENCLR_PREGION1RA() uint32 {
	return (volatile.LoadUint32(&o.NMIENCLR.Reg) & 0x8000000) >> 27
}

// MWU.REGIONEN: Enable/disable regions watch
func (o *MWU_Type) SetREGIONEN_RGN0WA(value uint32) {
	volatile.StoreUint32(&o.REGIONEN.Reg, volatile.LoadUint32(&o.REGIONEN.Reg)&^(0x1)|value)
}
func (o *MWU_Type) GetREGIONEN_RGN0WA() uint32 {
	return volatile.LoadUint32(&o.REGIONEN.Reg) & 0x1
}
func (o *MWU_Type) SetREGIONEN_RGN0RA(value uint32) {
	volatile.StoreUint32(&o.REGIONEN.Reg, volatile.LoadUint32(&o.REGIONEN.Reg)&^(0x2)|value<<1)
}
func (o *MWU_Type) GetREGIONEN_RGN0RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONEN.Reg) & 0x2) >> 1
}
func (o *MWU_Type) SetREGIONEN_RGN1WA(value uint32) {
	volatile.StoreUint32(&o.REGIONEN.Reg, volatile.LoadUint32(&o.REGIONEN.Reg)&^(0x4)|value<<2)
}
func (o *MWU_Type) GetREGIONEN_RGN1WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONEN.Reg) & 0x4) >> 2
}
func (o *MWU_Type) SetREGIONEN_RGN1RA(value uint32) {
	volatile.StoreUint32(&o.REGIONEN.Reg, volatile.LoadUint32(&o.REGIONEN.Reg)&^(0x8)|value<<3)
}
func (o *MWU_Type) GetREGIONEN_RGN1RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONEN.Reg) & 0x8) >> 3
}
func (o *MWU_Type) SetREGIONEN_RGN2WA(value uint32) {
	volatile.StoreUint32(&o.REGIONEN.Reg, volatile.LoadUint32(&o.REGIONEN.Reg)&^(0x10)|value<<4)
}
func (o *MWU_Type) GetREGIONEN_RGN2WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONEN.Reg) & 0x10) >> 4
}
func (o *MWU_Type) SetREGIONEN_RGN2RA(value uint32) {
	volatile.StoreUint32(&o.REGIONEN.Reg, volatile.LoadUint32(&o.REGIONEN.Reg)&^(0x20)|value<<5)
}
func (o *MWU_Type) GetREGIONEN_RGN2RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONEN.Reg) & 0x20) >> 5
}
func (o *MWU_Type) SetREGIONEN_RGN3WA(value uint32) {
	volatile.StoreUint32(&o.REGIONEN.Reg, volatile.LoadUint32(&o.REGIONEN.Reg)&^(0x40)|value<<6)
}
func (o *MWU_Type) GetREGIONEN_RGN3WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONEN.Reg) & 0x40) >> 6
}
func (o *MWU_Type) SetREGIONEN_RGN3RA(value uint32) {
	volatile.StoreUint32(&o.REGIONEN.Reg, volatile.LoadUint32(&o.REGIONEN.Reg)&^(0x80)|value<<7)
}
func (o *MWU_Type) GetREGIONEN_RGN3RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONEN.Reg) & 0x80) >> 7
}
func (o *MWU_Type) SetREGIONEN_PRGN0WA(value uint32) {
	volatile.StoreUint32(&o.REGIONEN.Reg, volatile.LoadUint32(&o.REGIONEN.Reg)&^(0x1000000)|value<<24)
}
func (o *MWU_Type) GetREGIONEN_PRGN0WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONEN.Reg) & 0x1000000) >> 24
}
func (o *MWU_Type) SetREGIONEN_PRGN0RA(value uint32) {
	volatile.StoreUint32(&o.REGIONEN.Reg, volatile.LoadUint32(&o.REGIONEN.Reg)&^(0x2000000)|value<<25)
}
func (o *MWU_Type) GetREGIONEN_PRGN0RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONEN.Reg) & 0x2000000) >> 25
}
func (o *MWU_Type) SetREGIONEN_PRGN1WA(value uint32) {
	volatile.StoreUint32(&o.REGIONEN.Reg, volatile.LoadUint32(&o.REGIONEN.Reg)&^(0x4000000)|value<<26)
}
func (o *MWU_Type) GetREGIONEN_PRGN1WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONEN.Reg) & 0x4000000) >> 26
}
func (o *MWU_Type) SetREGIONEN_PRGN1RA(value uint32) {
	volatile.StoreUint32(&o.REGIONEN.Reg, volatile.LoadUint32(&o.REGIONEN.Reg)&^(0x8000000)|value<<27)
}
func (o *MWU_Type) GetREGIONEN_PRGN1RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONEN.Reg) & 0x8000000) >> 27
}

// MWU.REGIONENSET: Enable regions watch
func (o *MWU_Type) SetREGIONENSET_RGN0WA(value uint32) {
	volatile.StoreUint32(&o.REGIONENSET.Reg, volatile.LoadUint32(&o.REGIONENSET.Reg)&^(0x1)|value)
}
func (o *MWU_Type) GetREGIONENSET_RGN0WA() uint32 {
	return volatile.LoadUint32(&o.REGIONENSET.Reg) & 0x1
}
func (o *MWU_Type) SetREGIONENSET_RGN0RA(value uint32) {
	volatile.StoreUint32(&o.REGIONENSET.Reg, volatile.LoadUint32(&o.REGIONENSET.Reg)&^(0x2)|value<<1)
}
func (o *MWU_Type) GetREGIONENSET_RGN0RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENSET.Reg) & 0x2) >> 1
}
func (o *MWU_Type) SetREGIONENSET_RGN1WA(value uint32) {
	volatile.StoreUint32(&o.REGIONENSET.Reg, volatile.LoadUint32(&o.REGIONENSET.Reg)&^(0x4)|value<<2)
}
func (o *MWU_Type) GetREGIONENSET_RGN1WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENSET.Reg) & 0x4) >> 2
}
func (o *MWU_Type) SetREGIONENSET_RGN1RA(value uint32) {
	volatile.StoreUint32(&o.REGIONENSET.Reg, volatile.LoadUint32(&o.REGIONENSET.Reg)&^(0x8)|value<<3)
}
func (o *MWU_Type) GetREGIONENSET_RGN1RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENSET.Reg) & 0x8) >> 3
}
func (o *MWU_Type) SetREGIONENSET_RGN2WA(value uint32) {
	volatile.StoreUint32(&o.REGIONENSET.Reg, volatile.LoadUint32(&o.REGIONENSET.Reg)&^(0x10)|value<<4)
}
func (o *MWU_Type) GetREGIONENSET_RGN2WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENSET.Reg) & 0x10) >> 4
}
func (o *MWU_Type) SetREGIONENSET_RGN2RA(value uint32) {
	volatile.StoreUint32(&o.REGIONENSET.Reg, volatile.LoadUint32(&o.REGIONENSET.Reg)&^(0x20)|value<<5)
}
func (o *MWU_Type) GetREGIONENSET_RGN2RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENSET.Reg) & 0x20) >> 5
}
func (o *MWU_Type) SetREGIONENSET_RGN3WA(value uint32) {
	volatile.StoreUint32(&o.REGIONENSET.Reg, volatile.LoadUint32(&o.REGIONENSET.Reg)&^(0x40)|value<<6)
}
func (o *MWU_Type) GetREGIONENSET_RGN3WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENSET.Reg) & 0x40) >> 6
}
func (o *MWU_Type) SetREGIONENSET_RGN3RA(value uint32) {
	volatile.StoreUint32(&o.REGIONENSET.Reg, volatile.LoadUint32(&o.REGIONENSET.Reg)&^(0x80)|value<<7)
}
func (o *MWU_Type) GetREGIONENSET_RGN3RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENSET.Reg) & 0x80) >> 7
}
func (o *MWU_Type) SetREGIONENSET_PRGN0WA(value uint32) {
	volatile.StoreUint32(&o.REGIONENSET.Reg, volatile.LoadUint32(&o.REGIONENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *MWU_Type) GetREGIONENSET_PRGN0WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENSET.Reg) & 0x1000000) >> 24
}
func (o *MWU_Type) SetREGIONENSET_PRGN0RA(value uint32) {
	volatile.StoreUint32(&o.REGIONENSET.Reg, volatile.LoadUint32(&o.REGIONENSET.Reg)&^(0x2000000)|value<<25)
}
func (o *MWU_Type) GetREGIONENSET_PRGN0RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENSET.Reg) & 0x2000000) >> 25
}
func (o *MWU_Type) SetREGIONENSET_PRGN1WA(value uint32) {
	volatile.StoreUint32(&o.REGIONENSET.Reg, volatile.LoadUint32(&o.REGIONENSET.Reg)&^(0x4000000)|value<<26)
}
func (o *MWU_Type) GetREGIONENSET_PRGN1WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENSET.Reg) & 0x4000000) >> 26
}
func (o *MWU_Type) SetREGIONENSET_PRGN1RA(value uint32) {
	volatile.StoreUint32(&o.REGIONENSET.Reg, volatile.LoadUint32(&o.REGIONENSET.Reg)&^(0x8000000)|value<<27)
}
func (o *MWU_Type) GetREGIONENSET_PRGN1RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENSET.Reg) & 0x8000000) >> 27
}

// MWU.REGIONENCLR: Disable regions watch
func (o *MWU_Type) SetREGIONENCLR_RGN0WA(value uint32) {
	volatile.StoreUint32(&o.REGIONENCLR.Reg, volatile.LoadUint32(&o.REGIONENCLR.Reg)&^(0x1)|value)
}
func (o *MWU_Type) GetREGIONENCLR_RGN0WA() uint32 {
	return volatile.LoadUint32(&o.REGIONENCLR.Reg) & 0x1
}
func (o *MWU_Type) SetREGIONENCLR_RGN0RA(value uint32) {
	volatile.StoreUint32(&o.REGIONENCLR.Reg, volatile.LoadUint32(&o.REGIONENCLR.Reg)&^(0x2)|value<<1)
}
func (o *MWU_Type) GetREGIONENCLR_RGN0RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENCLR.Reg) & 0x2) >> 1
}
func (o *MWU_Type) SetREGIONENCLR_RGN1WA(value uint32) {
	volatile.StoreUint32(&o.REGIONENCLR.Reg, volatile.LoadUint32(&o.REGIONENCLR.Reg)&^(0x4)|value<<2)
}
func (o *MWU_Type) GetREGIONENCLR_RGN1WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENCLR.Reg) & 0x4) >> 2
}
func (o *MWU_Type) SetREGIONENCLR_RGN1RA(value uint32) {
	volatile.StoreUint32(&o.REGIONENCLR.Reg, volatile.LoadUint32(&o.REGIONENCLR.Reg)&^(0x8)|value<<3)
}
func (o *MWU_Type) GetREGIONENCLR_RGN1RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENCLR.Reg) & 0x8) >> 3
}
func (o *MWU_Type) SetREGIONENCLR_RGN2WA(value uint32) {
	volatile.StoreUint32(&o.REGIONENCLR.Reg, volatile.LoadUint32(&o.REGIONENCLR.Reg)&^(0x10)|value<<4)
}
func (o *MWU_Type) GetREGIONENCLR_RGN2WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENCLR.Reg) & 0x10) >> 4
}
func (o *MWU_Type) SetREGIONENCLR_RGN2RA(value uint32) {
	volatile.StoreUint32(&o.REGIONENCLR.Reg, volatile.LoadUint32(&o.REGIONENCLR.Reg)&^(0x20)|value<<5)
}
func (o *MWU_Type) GetREGIONENCLR_RGN2RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENCLR.Reg) & 0x20) >> 5
}
func (o *MWU_Type) SetREGIONENCLR_RGN3WA(value uint32) {
	volatile.StoreUint32(&o.REGIONENCLR.Reg, volatile.LoadUint32(&o.REGIONENCLR.Reg)&^(0x40)|value<<6)
}
func (o *MWU_Type) GetREGIONENCLR_RGN3WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENCLR.Reg) & 0x40) >> 6
}
func (o *MWU_Type) SetREGIONENCLR_RGN3RA(value uint32) {
	volatile.StoreUint32(&o.REGIONENCLR.Reg, volatile.LoadUint32(&o.REGIONENCLR.Reg)&^(0x80)|value<<7)
}
func (o *MWU_Type) GetREGIONENCLR_RGN3RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENCLR.Reg) & 0x80) >> 7
}
func (o *MWU_Type) SetREGIONENCLR_PRGN0WA(value uint32) {
	volatile.StoreUint32(&o.REGIONENCLR.Reg, volatile.LoadUint32(&o.REGIONENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *MWU_Type) GetREGIONENCLR_PRGN0WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENCLR.Reg) & 0x1000000) >> 24
}
func (o *MWU_Type) SetREGIONENCLR_PRGN0RA(value uint32) {
	volatile.StoreUint32(&o.REGIONENCLR.Reg, volatile.LoadUint32(&o.REGIONENCLR.Reg)&^(0x2000000)|value<<25)
}
func (o *MWU_Type) GetREGIONENCLR_PRGN0RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENCLR.Reg) & 0x2000000) >> 25
}
func (o *MWU_Type) SetREGIONENCLR_PRGN1WA(value uint32) {
	volatile.StoreUint32(&o.REGIONENCLR.Reg, volatile.LoadUint32(&o.REGIONENCLR.Reg)&^(0x4000000)|value<<26)
}
func (o *MWU_Type) GetREGIONENCLR_PRGN1WA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENCLR.Reg) & 0x4000000) >> 26
}
func (o *MWU_Type) SetREGIONENCLR_PRGN1RA(value uint32) {
	volatile.StoreUint32(&o.REGIONENCLR.Reg, volatile.LoadUint32(&o.REGIONENCLR.Reg)&^(0x8000000)|value<<27)
}
func (o *MWU_Type) GetREGIONENCLR_PRGN1RA() uint32 {
	return (volatile.LoadUint32(&o.REGIONENCLR.Reg) & 0x8000000) >> 27
}

// Peripheral events.
type MWU_EVENTS_REGION_Type struct {
	WA volatile.Register32 // 0x100
	RA volatile.Register32 // 0x104
}

// MWU_EVENTS_REGION.WA: Description cluster: Write access to region n detected
func (o *MWU_EVENTS_REGION_Type) SetWA(value uint32) {
	volatile.StoreUint32(&o.WA.Reg, volatile.LoadUint32(&o.WA.Reg)&^(0x1)|value)
}
func (o *MWU_EVENTS_REGION_Type) GetWA() uint32 {
	return volatile.LoadUint32(&o.WA.Reg) & 0x1
}

// MWU_EVENTS_REGION.RA: Description cluster: Read access to region n detected
func (o *MWU_EVENTS_REGION_Type) SetRA(value uint32) {
	volatile.StoreUint32(&o.RA.Reg, volatile.LoadUint32(&o.RA.Reg)&^(0x1)|value)
}
func (o *MWU_EVENTS_REGION_Type) GetRA() uint32 {
	return volatile.LoadUint32(&o.RA.Reg) & 0x1
}

// Peripheral events.
type MWU_EVENTS_PREGION_Type struct {
	WA volatile.Register32 // 0x160
	RA volatile.Register32 // 0x164
}

// MWU_EVENTS_PREGION.WA: Description cluster: Write access to peripheral region n detected
func (o *MWU_EVENTS_PREGION_Type) SetWA(value uint32) {
	volatile.StoreUint32(&o.WA.Reg, volatile.LoadUint32(&o.WA.Reg)&^(0x1)|value)
}
func (o *MWU_EVENTS_PREGION_Type) GetWA() uint32 {
	return volatile.LoadUint32(&o.WA.Reg) & 0x1
}

// MWU_EVENTS_PREGION.RA: Description cluster: Read access to peripheral region n detected
func (o *MWU_EVENTS_PREGION_Type) SetRA(value uint32) {
	volatile.StoreUint32(&o.RA.Reg, volatile.LoadUint32(&o.RA.Reg)&^(0x1)|value)
}
func (o *MWU_EVENTS_PREGION_Type) GetRA() uint32 {
	return volatile.LoadUint32(&o.RA.Reg) & 0x1
}

// Unspecified
type MWU_PERREGION_Type struct {
	SUBSTATWA volatile.Register32 // 0x400
	SUBSTATRA volatile.Register32 // 0x404
}

// MWU_PERREGION.SUBSTATWA: Description cluster: Source of event/interrupt in region n, write access detected while corresponding subregion was enabled for watching
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR0(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x1)|value)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR0() uint32 {
	return volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x1
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR1(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x2)|value<<1)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR1() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x2) >> 1
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR2(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x4)|value<<2)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR2() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x4) >> 2
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR3(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x8)|value<<3)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR3() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x8) >> 3
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR4(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x10)|value<<4)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR4() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x10) >> 4
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR5(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x20)|value<<5)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR5() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x20) >> 5
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR6(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x40)|value<<6)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR6() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x40) >> 6
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR7(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x80)|value<<7)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR7() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x80) >> 7
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR8(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x100)|value<<8)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR8() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x100) >> 8
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR9(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x200)|value<<9)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR9() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x200) >> 9
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR10(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x400)|value<<10)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR10() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x400) >> 10
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR11(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x800)|value<<11)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR11() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x800) >> 11
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR12(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x1000)|value<<12)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR12() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x1000) >> 12
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR13(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x2000)|value<<13)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR13() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x2000) >> 13
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR14(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x4000)|value<<14)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR14() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x4000) >> 14
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR15(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x8000)|value<<15)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR15() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x8000) >> 15
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR16(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x10000)|value<<16)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR16() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x10000) >> 16
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR17(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x20000)|value<<17)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR17() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x20000) >> 17
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR18(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x40000)|value<<18)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR18() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x40000) >> 18
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR19(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x80000)|value<<19)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR19() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x80000) >> 19
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR20(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x100000)|value<<20)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR20() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x100000) >> 20
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR21(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x200000)|value<<21)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR21() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x200000) >> 21
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR22(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x400000)|value<<22)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR22() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x400000) >> 22
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR23(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x800000)|value<<23)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR23() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x800000) >> 23
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR24(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x1000000)|value<<24)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR24() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x1000000) >> 24
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR25(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x2000000)|value<<25)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR25() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x2000000) >> 25
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR26(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x4000000)|value<<26)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR26() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x4000000) >> 26
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR27(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x8000000)|value<<27)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR27() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x8000000) >> 27
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR28(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x10000000)|value<<28)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR28() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x10000000) >> 28
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR29(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x20000000)|value<<29)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR29() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x20000000) >> 29
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR30(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x40000000)|value<<30)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR30() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x40000000) >> 30
}
func (o *MWU_PERREGION_Type) SetSUBSTATWA_SR31(value uint32) {
	volatile.StoreUint32(&o.SUBSTATWA.Reg, volatile.LoadUint32(&o.SUBSTATWA.Reg)&^(0x80000000)|value<<31)
}
func (o *MWU_PERREGION_Type) GetSUBSTATWA_SR31() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATWA.Reg) & 0x80000000) >> 31
}

// MWU_PERREGION.SUBSTATRA: Description cluster: Source of event/interrupt in region n, read access detected while corresponding subregion was enabled for watching
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR0(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x1)|value)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR0() uint32 {
	return volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x1
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR1(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x2)|value<<1)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR1() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x2) >> 1
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR2(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x4)|value<<2)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR2() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x4) >> 2
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR3(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x8)|value<<3)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR3() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x8) >> 3
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR4(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x10)|value<<4)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR4() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x10) >> 4
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR5(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x20)|value<<5)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR5() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x20) >> 5
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR6(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x40)|value<<6)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR6() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x40) >> 6
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR7(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x80)|value<<7)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR7() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x80) >> 7
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR8(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x100)|value<<8)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR8() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x100) >> 8
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR9(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x200)|value<<9)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR9() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x200) >> 9
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR10(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x400)|value<<10)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR10() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x400) >> 10
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR11(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x800)|value<<11)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR11() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x800) >> 11
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR12(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x1000)|value<<12)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR12() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x1000) >> 12
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR13(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x2000)|value<<13)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR13() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x2000) >> 13
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR14(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x4000)|value<<14)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR14() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x4000) >> 14
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR15(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x8000)|value<<15)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR15() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x8000) >> 15
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR16(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x10000)|value<<16)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR16() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x10000) >> 16
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR17(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x20000)|value<<17)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR17() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x20000) >> 17
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR18(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x40000)|value<<18)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR18() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x40000) >> 18
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR19(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x80000)|value<<19)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR19() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x80000) >> 19
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR20(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x100000)|value<<20)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR20() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x100000) >> 20
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR21(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x200000)|value<<21)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR21() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x200000) >> 21
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR22(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x400000)|value<<22)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR22() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x400000) >> 22
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR23(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x800000)|value<<23)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR23() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x800000) >> 23
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR24(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x1000000)|value<<24)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR24() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x1000000) >> 24
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR25(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x2000000)|value<<25)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR25() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x2000000) >> 25
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR26(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x4000000)|value<<26)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR26() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x4000000) >> 26
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR27(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x8000000)|value<<27)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR27() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x8000000) >> 27
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR28(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x10000000)|value<<28)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR28() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x10000000) >> 28
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR29(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x20000000)|value<<29)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR29() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x20000000) >> 29
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR30(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x40000000)|value<<30)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR30() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x40000000) >> 30
}
func (o *MWU_PERREGION_Type) SetSUBSTATRA_SR31(value uint32) {
	volatile.StoreUint32(&o.SUBSTATRA.Reg, volatile.LoadUint32(&o.SUBSTATRA.Reg)&^(0x80000000)|value<<31)
}
func (o *MWU_PERREGION_Type) GetSUBSTATRA_SR31() uint32 {
	return (volatile.LoadUint32(&o.SUBSTATRA.Reg) & 0x80000000) >> 31
}

// Unspecified
type MWU_REGION_Type struct {
	START volatile.Register32 // 0x600
	END   volatile.Register32 // 0x604
	_     [8]byte
}

// MWU_REGION.START: Description cluster: Start address for region n
func (o *MWU_REGION_Type) SetSTART(value uint32) {
	volatile.StoreUint32(&o.START.Reg, value)
}
func (o *MWU_REGION_Type) GetSTART() uint32 {
	return volatile.LoadUint32(&o.START.Reg)
}

// MWU_REGION.END: Description cluster: End address of region n
func (o *MWU_REGION_Type) SetEND(value uint32) {
	volatile.StoreUint32(&o.END.Reg, value)
}
func (o *MWU_REGION_Type) GetEND() uint32 {
	return volatile.LoadUint32(&o.END.Reg)
}

// Unspecified
type MWU_PREGION_Type struct {
	START volatile.Register32 // 0x6C0
	END   volatile.Register32 // 0x6C4
	SUBS  volatile.Register32 // 0x6C8
	_     [4]byte
}

// MWU_PREGION.START: Description cluster: Reserved for future use
func (o *MWU_PREGION_Type) SetSTART(value uint32) {
	volatile.StoreUint32(&o.START.Reg, value)
}
func (o *MWU_PREGION_Type) GetSTART() uint32 {
	return volatile.LoadUint32(&o.START.Reg)
}

// MWU_PREGION.END: Description cluster: Reserved for future use
func (o *MWU_PREGION_Type) SetEND(value uint32) {
	volatile.StoreUint32(&o.END.Reg, value)
}
func (o *MWU_PREGION_Type) GetEND() uint32 {
	return volatile.LoadUint32(&o.END.Reg)
}

// MWU_PREGION.SUBS: Description cluster: Subregions of region n
func (o *MWU_PREGION_Type) SetSUBS_SR0(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x1)|value)
}
func (o *MWU_PREGION_Type) GetSUBS_SR0() uint32 {
	return volatile.LoadUint32(&o.SUBS.Reg) & 0x1
}
func (o *MWU_PREGION_Type) SetSUBS_SR1(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x2)|value<<1)
}
func (o *MWU_PREGION_Type) GetSUBS_SR1() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x2) >> 1
}
func (o *MWU_PREGION_Type) SetSUBS_SR2(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x4)|value<<2)
}
func (o *MWU_PREGION_Type) GetSUBS_SR2() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x4) >> 2
}
func (o *MWU_PREGION_Type) SetSUBS_SR3(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x8)|value<<3)
}
func (o *MWU_PREGION_Type) GetSUBS_SR3() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x8) >> 3
}
func (o *MWU_PREGION_Type) SetSUBS_SR4(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x10)|value<<4)
}
func (o *MWU_PREGION_Type) GetSUBS_SR4() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x10) >> 4
}
func (o *MWU_PREGION_Type) SetSUBS_SR5(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x20)|value<<5)
}
func (o *MWU_PREGION_Type) GetSUBS_SR5() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x20) >> 5
}
func (o *MWU_PREGION_Type) SetSUBS_SR6(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x40)|value<<6)
}
func (o *MWU_PREGION_Type) GetSUBS_SR6() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x40) >> 6
}
func (o *MWU_PREGION_Type) SetSUBS_SR7(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x80)|value<<7)
}
func (o *MWU_PREGION_Type) GetSUBS_SR7() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x80) >> 7
}
func (o *MWU_PREGION_Type) SetSUBS_SR8(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x100)|value<<8)
}
func (o *MWU_PREGION_Type) GetSUBS_SR8() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x100) >> 8
}
func (o *MWU_PREGION_Type) SetSUBS_SR9(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x200)|value<<9)
}
func (o *MWU_PREGION_Type) GetSUBS_SR9() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x200) >> 9
}
func (o *MWU_PREGION_Type) SetSUBS_SR10(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x400)|value<<10)
}
func (o *MWU_PREGION_Type) GetSUBS_SR10() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x400) >> 10
}
func (o *MWU_PREGION_Type) SetSUBS_SR11(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x800)|value<<11)
}
func (o *MWU_PREGION_Type) GetSUBS_SR11() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x800) >> 11
}
func (o *MWU_PREGION_Type) SetSUBS_SR12(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x1000)|value<<12)
}
func (o *MWU_PREGION_Type) GetSUBS_SR12() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x1000) >> 12
}
func (o *MWU_PREGION_Type) SetSUBS_SR13(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x2000)|value<<13)
}
func (o *MWU_PREGION_Type) GetSUBS_SR13() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x2000) >> 13
}
func (o *MWU_PREGION_Type) SetSUBS_SR14(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x4000)|value<<14)
}
func (o *MWU_PREGION_Type) GetSUBS_SR14() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x4000) >> 14
}
func (o *MWU_PREGION_Type) SetSUBS_SR15(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x8000)|value<<15)
}
func (o *MWU_PREGION_Type) GetSUBS_SR15() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x8000) >> 15
}
func (o *MWU_PREGION_Type) SetSUBS_SR16(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x10000)|value<<16)
}
func (o *MWU_PREGION_Type) GetSUBS_SR16() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x10000) >> 16
}
func (o *MWU_PREGION_Type) SetSUBS_SR17(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x20000)|value<<17)
}
func (o *MWU_PREGION_Type) GetSUBS_SR17() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x20000) >> 17
}
func (o *MWU_PREGION_Type) SetSUBS_SR18(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x40000)|value<<18)
}
func (o *MWU_PREGION_Type) GetSUBS_SR18() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x40000) >> 18
}
func (o *MWU_PREGION_Type) SetSUBS_SR19(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x80000)|value<<19)
}
func (o *MWU_PREGION_Type) GetSUBS_SR19() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x80000) >> 19
}
func (o *MWU_PREGION_Type) SetSUBS_SR20(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x100000)|value<<20)
}
func (o *MWU_PREGION_Type) GetSUBS_SR20() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x100000) >> 20
}
func (o *MWU_PREGION_Type) SetSUBS_SR21(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x200000)|value<<21)
}
func (o *MWU_PREGION_Type) GetSUBS_SR21() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x200000) >> 21
}
func (o *MWU_PREGION_Type) SetSUBS_SR22(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x400000)|value<<22)
}
func (o *MWU_PREGION_Type) GetSUBS_SR22() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x400000) >> 22
}
func (o *MWU_PREGION_Type) SetSUBS_SR23(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x800000)|value<<23)
}
func (o *MWU_PREGION_Type) GetSUBS_SR23() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x800000) >> 23
}
func (o *MWU_PREGION_Type) SetSUBS_SR24(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x1000000)|value<<24)
}
func (o *MWU_PREGION_Type) GetSUBS_SR24() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x1000000) >> 24
}
func (o *MWU_PREGION_Type) SetSUBS_SR25(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x2000000)|value<<25)
}
func (o *MWU_PREGION_Type) GetSUBS_SR25() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x2000000) >> 25
}
func (o *MWU_PREGION_Type) SetSUBS_SR26(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x4000000)|value<<26)
}
func (o *MWU_PREGION_Type) GetSUBS_SR26() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x4000000) >> 26
}
func (o *MWU_PREGION_Type) SetSUBS_SR27(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x8000000)|value<<27)
}
func (o *MWU_PREGION_Type) GetSUBS_SR27() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x8000000) >> 27
}
func (o *MWU_PREGION_Type) SetSUBS_SR28(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x10000000)|value<<28)
}
func (o *MWU_PREGION_Type) GetSUBS_SR28() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x10000000) >> 28
}
func (o *MWU_PREGION_Type) SetSUBS_SR29(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x20000000)|value<<29)
}
func (o *MWU_PREGION_Type) GetSUBS_SR29() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x20000000) >> 29
}
func (o *MWU_PREGION_Type) SetSUBS_SR30(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x40000000)|value<<30)
}
func (o *MWU_PREGION_Type) GetSUBS_SR30() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x40000000) >> 30
}
func (o *MWU_PREGION_Type) SetSUBS_SR31(value uint32) {
	volatile.StoreUint32(&o.SUBS.Reg, volatile.LoadUint32(&o.SUBS.Reg)&^(0x80000000)|value<<31)
}
func (o *MWU_PREGION_Type) GetSUBS_SR31() uint32 {
	return (volatile.LoadUint32(&o.SUBS.Reg) & 0x80000000) >> 31
}

// Inter-IC Sound
type I2S_Type struct {
	TASKS_START     volatile.Register32 // 0x0
	TASKS_STOP      volatile.Register32 // 0x4
	_               [252]byte
	EVENTS_RXPTRUPD volatile.Register32 // 0x104
	EVENTS_STOPPED  volatile.Register32 // 0x108
	_               [8]byte
	EVENTS_TXPTRUPD volatile.Register32 // 0x114
	_               [488]byte
	INTEN           volatile.Register32 // 0x300
	INTENSET        volatile.Register32 // 0x304
	INTENCLR        volatile.Register32 // 0x308
	_               [500]byte
	ENABLE          volatile.Register32 // 0x500
	CONFIG          I2S_CONFIG_Type     // 0x504
	_               [12]byte
	RXD             I2S_RXD_Type // 0x538
	_               [4]byte
	TXD             I2S_TXD_Type // 0x540
	_               [12]byte
	RXTXD           I2S_RXTXD_Type // 0x550
	_               [12]byte
	PSEL            I2S_PSEL_Type // 0x560
}

// I2S.TASKS_START: Starts continuous I2S transfer. Also starts MCK generator when this is enabled.
func (o *I2S_Type) SetTASKS_START(value uint32) {
	volatile.StoreUint32(&o.TASKS_START.Reg, volatile.LoadUint32(&o.TASKS_START.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetTASKS_START() uint32 {
	return volatile.LoadUint32(&o.TASKS_START.Reg) & 0x1
}

// I2S.TASKS_STOP: Stops I2S transfer. Also stops MCK generator. Triggering this task will cause the STOPPED event to be generated.
func (o *I2S_Type) SetTASKS_STOP(value uint32) {
	volatile.StoreUint32(&o.TASKS_STOP.Reg, volatile.LoadUint32(&o.TASKS_STOP.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetTASKS_STOP() uint32 {
	return volatile.LoadUint32(&o.TASKS_STOP.Reg) & 0x1
}

// I2S.EVENTS_RXPTRUPD: The RXD.PTR register has been copied to internal double-buffers. When the I2S module is started and RX is enabled, this event will be generated for every RXTXD.MAXCNT words that are received on the SDIN pin.
func (o *I2S_Type) SetEVENTS_RXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.EVENTS_RXPTRUPD.Reg, volatile.LoadUint32(&o.EVENTS_RXPTRUPD.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetEVENTS_RXPTRUPD() uint32 {
	return volatile.LoadUint32(&o.EVENTS_RXPTRUPD.Reg) & 0x1
}

// I2S.EVENTS_STOPPED: I2S transfer stopped.
func (o *I2S_Type) SetEVENTS_STOPPED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STOPPED.Reg, volatile.LoadUint32(&o.EVENTS_STOPPED.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetEVENTS_STOPPED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STOPPED.Reg) & 0x1
}

// I2S.EVENTS_TXPTRUPD: The TDX.PTR register has been copied to internal double-buffers. When the I2S module is started and TX is enabled, this event will be generated for every RXTXD.MAXCNT words that are sent on the SDOUT pin.
func (o *I2S_Type) SetEVENTS_TXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.EVENTS_TXPTRUPD.Reg, volatile.LoadUint32(&o.EVENTS_TXPTRUPD.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetEVENTS_TXPTRUPD() uint32 {
	return volatile.LoadUint32(&o.EVENTS_TXPTRUPD.Reg) & 0x1
}

// I2S.INTEN: Enable or disable interrupt
func (o *I2S_Type) SetINTEN_RXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINTEN_RXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINTEN_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINTEN_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINTEN_TXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINTEN_TXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}

// I2S.INTENSET: Enable interrupt
func (o *I2S_Type) SetINTENSET_RXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINTENSET_RXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINTENSET_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINTENSET_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINTENSET_TXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINTENSET_TXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}

// I2S.INTENCLR: Disable interrupt
func (o *I2S_Type) SetINTENCLR_RXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *I2S_Type) GetINTENCLR_RXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *I2S_Type) SetINTENCLR_STOPPED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *I2S_Type) GetINTENCLR_STOPPED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *I2S_Type) SetINTENCLR_TXPTRUPD(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *I2S_Type) GetINTENCLR_TXPTRUPD() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}

// I2S.ENABLE: Enable I2S module.
func (o *I2S_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *I2S_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// Unspecified
type I2S_CONFIG_Type struct {
	MODE     volatile.Register32 // 0x504
	RXEN     volatile.Register32 // 0x508
	TXEN     volatile.Register32 // 0x50C
	MCKEN    volatile.Register32 // 0x510
	MCKFREQ  volatile.Register32 // 0x514
	RATIO    volatile.Register32 // 0x518
	SWIDTH   volatile.Register32 // 0x51C
	ALIGN    volatile.Register32 // 0x520
	FORMAT   volatile.Register32 // 0x524
	CHANNELS volatile.Register32 // 0x528
}

// I2S_CONFIG.MODE: I2S mode.
func (o *I2S_CONFIG_Type) SetMODE(value uint32) {
	volatile.StoreUint32(&o.MODE.Reg, volatile.LoadUint32(&o.MODE.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetMODE() uint32 {
	return volatile.LoadUint32(&o.MODE.Reg) & 0x1
}

// I2S_CONFIG.RXEN: Reception (RX) enable.
func (o *I2S_CONFIG_Type) SetRXEN(value uint32) {
	volatile.StoreUint32(&o.RXEN.Reg, volatile.LoadUint32(&o.RXEN.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetRXEN() uint32 {
	return volatile.LoadUint32(&o.RXEN.Reg) & 0x1
}

// I2S_CONFIG.TXEN: Transmission (TX) enable.
func (o *I2S_CONFIG_Type) SetTXEN(value uint32) {
	volatile.StoreUint32(&o.TXEN.Reg, volatile.LoadUint32(&o.TXEN.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetTXEN() uint32 {
	return volatile.LoadUint32(&o.TXEN.Reg) & 0x1
}

// I2S_CONFIG.MCKEN: Master clock generator enable.
func (o *I2S_CONFIG_Type) SetMCKEN(value uint32) {
	volatile.StoreUint32(&o.MCKEN.Reg, volatile.LoadUint32(&o.MCKEN.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetMCKEN() uint32 {
	return volatile.LoadUint32(&o.MCKEN.Reg) & 0x1
}

// I2S_CONFIG.MCKFREQ: Master clock generator frequency.
func (o *I2S_CONFIG_Type) SetMCKFREQ(value uint32) {
	volatile.StoreUint32(&o.MCKFREQ.Reg, value)
}
func (o *I2S_CONFIG_Type) GetMCKFREQ() uint32 {
	return volatile.LoadUint32(&o.MCKFREQ.Reg)
}

// I2S_CONFIG.RATIO: MCK / LRCK ratio.
func (o *I2S_CONFIG_Type) SetRATIO(value uint32) {
	volatile.StoreUint32(&o.RATIO.Reg, volatile.LoadUint32(&o.RATIO.Reg)&^(0xf)|value)
}
func (o *I2S_CONFIG_Type) GetRATIO() uint32 {
	return volatile.LoadUint32(&o.RATIO.Reg) & 0xf
}

// I2S_CONFIG.SWIDTH: Sample width.
func (o *I2S_CONFIG_Type) SetSWIDTH(value uint32) {
	volatile.StoreUint32(&o.SWIDTH.Reg, volatile.LoadUint32(&o.SWIDTH.Reg)&^(0x3)|value)
}
func (o *I2S_CONFIG_Type) GetSWIDTH() uint32 {
	return volatile.LoadUint32(&o.SWIDTH.Reg) & 0x3
}

// I2S_CONFIG.ALIGN: Alignment of sample within a frame.
func (o *I2S_CONFIG_Type) SetALIGN(value uint32) {
	volatile.StoreUint32(&o.ALIGN.Reg, volatile.LoadUint32(&o.ALIGN.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetALIGN() uint32 {
	return volatile.LoadUint32(&o.ALIGN.Reg) & 0x1
}

// I2S_CONFIG.FORMAT: Frame format.
func (o *I2S_CONFIG_Type) SetFORMAT(value uint32) {
	volatile.StoreUint32(&o.FORMAT.Reg, volatile.LoadUint32(&o.FORMAT.Reg)&^(0x1)|value)
}
func (o *I2S_CONFIG_Type) GetFORMAT() uint32 {
	return volatile.LoadUint32(&o.FORMAT.Reg) & 0x1
}

// I2S_CONFIG.CHANNELS: Enable channels.
func (o *I2S_CONFIG_Type) SetCHANNELS(value uint32) {
	volatile.StoreUint32(&o.CHANNELS.Reg, volatile.LoadUint32(&o.CHANNELS.Reg)&^(0x3)|value)
}
func (o *I2S_CONFIG_Type) GetCHANNELS() uint32 {
	return volatile.LoadUint32(&o.CHANNELS.Reg) & 0x3
}

// Unspecified
type I2S_RXD_Type struct {
	PTR volatile.Register32 // 0x538
}

// I2S_RXD.PTR: Receive buffer RAM start address.
func (o *I2S_RXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *I2S_RXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// Unspecified
type I2S_TXD_Type struct {
	PTR volatile.Register32 // 0x540
}

// I2S_TXD.PTR: Transmit buffer RAM start address.
func (o *I2S_TXD_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *I2S_TXD_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// Unspecified
type I2S_RXTXD_Type struct {
	MAXCNT volatile.Register32 // 0x550
}

// I2S_RXTXD.MAXCNT: Size of RXD and TXD buffers.
func (o *I2S_RXTXD_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x3fff)|value)
}
func (o *I2S_RXTXD_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x3fff
}

// Unspecified
type I2S_PSEL_Type struct {
	MCK   volatile.Register32 // 0x560
	SCK   volatile.Register32 // 0x564
	LRCK  volatile.Register32 // 0x568
	SDIN  volatile.Register32 // 0x56C
	SDOUT volatile.Register32 // 0x570
}

// I2S_PSEL.MCK: Pin select for MCK signal.
func (o *I2S_PSEL_Type) SetMCK_PIN(value uint32) {
	volatile.StoreUint32(&o.MCK.Reg, volatile.LoadUint32(&o.MCK.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetMCK_PIN() uint32 {
	return volatile.LoadUint32(&o.MCK.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetMCK_PORT(value uint32) {
	volatile.StoreUint32(&o.MCK.Reg, volatile.LoadUint32(&o.MCK.Reg)&^(0x20)|value<<5)
}
func (o *I2S_PSEL_Type) GetMCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.MCK.Reg) & 0x20) >> 5
}
func (o *I2S_PSEL_Type) SetMCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.MCK.Reg, volatile.LoadUint32(&o.MCK.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetMCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.MCK.Reg) & 0x80000000) >> 31
}

// I2S_PSEL.SCK: Pin select for SCK signal.
func (o *I2S_PSEL_Type) SetSCK_PIN(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetSCK_PIN() uint32 {
	return volatile.LoadUint32(&o.SCK.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetSCK_PORT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x20)|value<<5)
}
func (o *I2S_PSEL_Type) GetSCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x20) >> 5
}
func (o *I2S_PSEL_Type) SetSCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SCK.Reg, volatile.LoadUint32(&o.SCK.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetSCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SCK.Reg) & 0x80000000) >> 31
}

// I2S_PSEL.LRCK: Pin select for LRCK signal.
func (o *I2S_PSEL_Type) SetLRCK_PIN(value uint32) {
	volatile.StoreUint32(&o.LRCK.Reg, volatile.LoadUint32(&o.LRCK.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetLRCK_PIN() uint32 {
	return volatile.LoadUint32(&o.LRCK.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetLRCK_PORT(value uint32) {
	volatile.StoreUint32(&o.LRCK.Reg, volatile.LoadUint32(&o.LRCK.Reg)&^(0x20)|value<<5)
}
func (o *I2S_PSEL_Type) GetLRCK_PORT() uint32 {
	return (volatile.LoadUint32(&o.LRCK.Reg) & 0x20) >> 5
}
func (o *I2S_PSEL_Type) SetLRCK_CONNECT(value uint32) {
	volatile.StoreUint32(&o.LRCK.Reg, volatile.LoadUint32(&o.LRCK.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetLRCK_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.LRCK.Reg) & 0x80000000) >> 31
}

// I2S_PSEL.SDIN: Pin select for SDIN signal.
func (o *I2S_PSEL_Type) SetSDIN_PIN(value uint32) {
	volatile.StoreUint32(&o.SDIN.Reg, volatile.LoadUint32(&o.SDIN.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetSDIN_PIN() uint32 {
	return volatile.LoadUint32(&o.SDIN.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetSDIN_PORT(value uint32) {
	volatile.StoreUint32(&o.SDIN.Reg, volatile.LoadUint32(&o.SDIN.Reg)&^(0x20)|value<<5)
}
func (o *I2S_PSEL_Type) GetSDIN_PORT() uint32 {
	return (volatile.LoadUint32(&o.SDIN.Reg) & 0x20) >> 5
}
func (o *I2S_PSEL_Type) SetSDIN_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDIN.Reg, volatile.LoadUint32(&o.SDIN.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetSDIN_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDIN.Reg) & 0x80000000) >> 31
}

// I2S_PSEL.SDOUT: Pin select for SDOUT signal.
func (o *I2S_PSEL_Type) SetSDOUT_PIN(value uint32) {
	volatile.StoreUint32(&o.SDOUT.Reg, volatile.LoadUint32(&o.SDOUT.Reg)&^(0x1f)|value)
}
func (o *I2S_PSEL_Type) GetSDOUT_PIN() uint32 {
	return volatile.LoadUint32(&o.SDOUT.Reg) & 0x1f
}
func (o *I2S_PSEL_Type) SetSDOUT_PORT(value uint32) {
	volatile.StoreUint32(&o.SDOUT.Reg, volatile.LoadUint32(&o.SDOUT.Reg)&^(0x20)|value<<5)
}
func (o *I2S_PSEL_Type) GetSDOUT_PORT() uint32 {
	return (volatile.LoadUint32(&o.SDOUT.Reg) & 0x20) >> 5
}
func (o *I2S_PSEL_Type) SetSDOUT_CONNECT(value uint32) {
	volatile.StoreUint32(&o.SDOUT.Reg, volatile.LoadUint32(&o.SDOUT.Reg)&^(0x80000000)|value<<31)
}
func (o *I2S_PSEL_Type) GetSDOUT_CONNECT() uint32 {
	return (volatile.LoadUint32(&o.SDOUT.Reg) & 0x80000000) >> 31
}

// FPU
type FPU_Type struct {
	UNUSED volatile.Register32 // 0x0
}

// Universal serial bus device
type USBD_Type struct {
	_                  [4]byte
	TASKS_STARTEPIN    [8]volatile.Register32 // 0x4
	TASKS_STARTISOIN   volatile.Register32    // 0x24
	TASKS_STARTEPOUT   [8]volatile.Register32 // 0x28
	TASKS_STARTISOOUT  volatile.Register32    // 0x48
	TASKS_EP0RCVOUT    volatile.Register32    // 0x4C
	TASKS_EP0STATUS    volatile.Register32    // 0x50
	TASKS_EP0STALL     volatile.Register32    // 0x54
	TASKS_DPDMDRIVE    volatile.Register32    // 0x58
	TASKS_DPDMNODRIVE  volatile.Register32    // 0x5C
	_                  [160]byte
	EVENTS_USBRESET    volatile.Register32    // 0x100
	EVENTS_STARTED     volatile.Register32    // 0x104
	EVENTS_ENDEPIN     [8]volatile.Register32 // 0x108
	EVENTS_EP0DATADONE volatile.Register32    // 0x128
	EVENTS_ENDISOIN    volatile.Register32    // 0x12C
	EVENTS_ENDEPOUT    [8]volatile.Register32 // 0x130
	EVENTS_ENDISOOUT   volatile.Register32    // 0x150
	EVENTS_SOF         volatile.Register32    // 0x154
	EVENTS_USBEVENT    volatile.Register32    // 0x158
	EVENTS_EP0SETUP    volatile.Register32    // 0x15C
	EVENTS_EPDATA      volatile.Register32    // 0x160
	_                  [156]byte
	SHORTS             volatile.Register32 // 0x200
	_                  [252]byte
	INTEN              volatile.Register32 // 0x300
	INTENSET           volatile.Register32 // 0x304
	INTENCLR           volatile.Register32 // 0x308
	_                  [244]byte
	EVENTCAUSE         volatile.Register32 // 0x400
	_                  [28]byte
	HALTED             USBD_HALTED_Type // 0x420
	_                  [4]byte
	EPSTATUS           volatile.Register32 // 0x468
	EPDATASTATUS       volatile.Register32 // 0x46C
	USBADDR            volatile.Register32 // 0x470
	_                  [12]byte
	BMREQUESTTYPE      volatile.Register32 // 0x480
	BREQUEST           volatile.Register32 // 0x484
	WVALUEL            volatile.Register32 // 0x488
	WVALUEH            volatile.Register32 // 0x48C
	WINDEXL            volatile.Register32 // 0x490
	WINDEXH            volatile.Register32 // 0x494
	WLENGTHL           volatile.Register32 // 0x498
	WLENGTHH           volatile.Register32 // 0x49C
	SIZE               USBD_SIZE_Type      // 0x4A0
	_                  [60]byte
	ENABLE             volatile.Register32 // 0x500
	USBPULLUP          volatile.Register32 // 0x504
	DPDMVALUE          volatile.Register32 // 0x508
	DTOGGLE            volatile.Register32 // 0x50C
	EPINEN             volatile.Register32 // 0x510
	EPOUTEN            volatile.Register32 // 0x514
	EPSTALL            volatile.Register32 // 0x518
	ISOSPLIT           volatile.Register32 // 0x51C
	FRAMECNTR          volatile.Register32 // 0x520
	_                  [8]byte
	LOWPOWER           volatile.Register32 // 0x52C
	ISOINCONFIG        volatile.Register32 // 0x530
	_                  [204]byte
	EPIN               [8]USBD_EPIN_Type // 0x600
	ISOIN              USBD_ISOIN_Type   // 0x6A0
	_                  [84]byte
	EPOUT              [8]USBD_EPOUT_Type // 0x700
	ISOOUT             USBD_ISOOUT_Type   // 0x7A0
}

// USBD.TASKS_STARTEPIN: Description collection: Captures the EPIN[n].PTR and EPIN[n].MAXCNT registers values, and enables endpoint IN n to respond to traffic from host
func (o *USBD_Type) SetTASKS_STARTEPIN(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTEPIN[idx].Reg, volatile.LoadUint32(&o.TASKS_STARTEPIN[idx].Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_STARTEPIN(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTEPIN[idx].Reg) & 0x1
}

// USBD.TASKS_STARTISOIN: Captures the ISOIN.PTR and ISOIN.MAXCNT registers values, and enables sending data on ISO endpoint
func (o *USBD_Type) SetTASKS_STARTISOIN(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTISOIN.Reg, volatile.LoadUint32(&o.TASKS_STARTISOIN.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_STARTISOIN() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTISOIN.Reg) & 0x1
}

// USBD.TASKS_STARTEPOUT: Description collection: Captures the EPOUT[n].PTR and EPOUT[n].MAXCNT registers values, and enables endpoint n to respond to traffic from host
func (o *USBD_Type) SetTASKS_STARTEPOUT(idx int, value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTEPOUT[idx].Reg, volatile.LoadUint32(&o.TASKS_STARTEPOUT[idx].Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_STARTEPOUT(idx int) uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTEPOUT[idx].Reg) & 0x1
}

// USBD.TASKS_STARTISOOUT: Captures the ISOOUT.PTR and ISOOUT.MAXCNT registers values, and enables receiving of data on ISO endpoint
func (o *USBD_Type) SetTASKS_STARTISOOUT(value uint32) {
	volatile.StoreUint32(&o.TASKS_STARTISOOUT.Reg, volatile.LoadUint32(&o.TASKS_STARTISOOUT.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_STARTISOOUT() uint32 {
	return volatile.LoadUint32(&o.TASKS_STARTISOOUT.Reg) & 0x1
}

// USBD.TASKS_EP0RCVOUT: Allows OUT data stage on control endpoint 0
func (o *USBD_Type) SetTASKS_EP0RCVOUT(value uint32) {
	volatile.StoreUint32(&o.TASKS_EP0RCVOUT.Reg, volatile.LoadUint32(&o.TASKS_EP0RCVOUT.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_EP0RCVOUT() uint32 {
	return volatile.LoadUint32(&o.TASKS_EP0RCVOUT.Reg) & 0x1
}

// USBD.TASKS_EP0STATUS: Allows status stage on control endpoint 0
func (o *USBD_Type) SetTASKS_EP0STATUS(value uint32) {
	volatile.StoreUint32(&o.TASKS_EP0STATUS.Reg, volatile.LoadUint32(&o.TASKS_EP0STATUS.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_EP0STATUS() uint32 {
	return volatile.LoadUint32(&o.TASKS_EP0STATUS.Reg) & 0x1
}

// USBD.TASKS_EP0STALL: Stalls data and status stage on control endpoint 0
func (o *USBD_Type) SetTASKS_EP0STALL(value uint32) {
	volatile.StoreUint32(&o.TASKS_EP0STALL.Reg, volatile.LoadUint32(&o.TASKS_EP0STALL.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_EP0STALL() uint32 {
	return volatile.LoadUint32(&o.TASKS_EP0STALL.Reg) & 0x1
}

// USBD.TASKS_DPDMDRIVE: Forces D+ and D- lines into the state defined in the DPDMVALUE register
func (o *USBD_Type) SetTASKS_DPDMDRIVE(value uint32) {
	volatile.StoreUint32(&o.TASKS_DPDMDRIVE.Reg, volatile.LoadUint32(&o.TASKS_DPDMDRIVE.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_DPDMDRIVE() uint32 {
	return volatile.LoadUint32(&o.TASKS_DPDMDRIVE.Reg) & 0x1
}

// USBD.TASKS_DPDMNODRIVE: Stops forcing D+ and D- lines into any state (USB engine takes control)
func (o *USBD_Type) SetTASKS_DPDMNODRIVE(value uint32) {
	volatile.StoreUint32(&o.TASKS_DPDMNODRIVE.Reg, volatile.LoadUint32(&o.TASKS_DPDMNODRIVE.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetTASKS_DPDMNODRIVE() uint32 {
	return volatile.LoadUint32(&o.TASKS_DPDMNODRIVE.Reg) & 0x1
}

// USBD.EVENTS_USBRESET: Signals that a USB reset condition has been detected on USB lines
func (o *USBD_Type) SetEVENTS_USBRESET(value uint32) {
	volatile.StoreUint32(&o.EVENTS_USBRESET.Reg, volatile.LoadUint32(&o.EVENTS_USBRESET.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_USBRESET() uint32 {
	return volatile.LoadUint32(&o.EVENTS_USBRESET.Reg) & 0x1
}

// USBD.EVENTS_STARTED: Confirms that the EPIN[n].PTR and EPIN[n].MAXCNT, or EPOUT[n].PTR and EPOUT[n].MAXCNT registers have been captured on all endpoints reported in the EPSTATUS register
func (o *USBD_Type) SetEVENTS_STARTED(value uint32) {
	volatile.StoreUint32(&o.EVENTS_STARTED.Reg, volatile.LoadUint32(&o.EVENTS_STARTED.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_STARTED() uint32 {
	return volatile.LoadUint32(&o.EVENTS_STARTED.Reg) & 0x1
}

// USBD.EVENTS_ENDEPIN: Description collection: The whole EPIN[n] buffer has been consumed. The buffer can be accessed safely by software.
func (o *USBD_Type) SetEVENTS_ENDEPIN(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDEPIN[idx].Reg, volatile.LoadUint32(&o.EVENTS_ENDEPIN[idx].Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_ENDEPIN(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDEPIN[idx].Reg) & 0x1
}

// USBD.EVENTS_EP0DATADONE: An acknowledged data transfer has taken place on the control endpoint
func (o *USBD_Type) SetEVENTS_EP0DATADONE(value uint32) {
	volatile.StoreUint32(&o.EVENTS_EP0DATADONE.Reg, volatile.LoadUint32(&o.EVENTS_EP0DATADONE.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_EP0DATADONE() uint32 {
	return volatile.LoadUint32(&o.EVENTS_EP0DATADONE.Reg) & 0x1
}

// USBD.EVENTS_ENDISOIN: The whole ISOIN buffer has been consumed. The buffer can be accessed safely by software.
func (o *USBD_Type) SetEVENTS_ENDISOIN(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDISOIN.Reg, volatile.LoadUint32(&o.EVENTS_ENDISOIN.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_ENDISOIN() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDISOIN.Reg) & 0x1
}

// USBD.EVENTS_ENDEPOUT: Description collection: The whole EPOUT[n] buffer has been consumed. The buffer can be accessed safely by software.
func (o *USBD_Type) SetEVENTS_ENDEPOUT(idx int, value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDEPOUT[idx].Reg, volatile.LoadUint32(&o.EVENTS_ENDEPOUT[idx].Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_ENDEPOUT(idx int) uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDEPOUT[idx].Reg) & 0x1
}

// USBD.EVENTS_ENDISOOUT: The whole ISOOUT buffer has been consumed. The buffer can be accessed safely by software.
func (o *USBD_Type) SetEVENTS_ENDISOOUT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_ENDISOOUT.Reg, volatile.LoadUint32(&o.EVENTS_ENDISOOUT.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_ENDISOOUT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_ENDISOOUT.Reg) & 0x1
}

// USBD.EVENTS_SOF: Signals that a SOF (start of frame) condition has been detected on USB lines
func (o *USBD_Type) SetEVENTS_SOF(value uint32) {
	volatile.StoreUint32(&o.EVENTS_SOF.Reg, volatile.LoadUint32(&o.EVENTS_SOF.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_SOF() uint32 {
	return volatile.LoadUint32(&o.EVENTS_SOF.Reg) & 0x1
}

// USBD.EVENTS_USBEVENT: An event or an error not covered by specific events has occurred. Check EVENTCAUSE register to find the cause.
func (o *USBD_Type) SetEVENTS_USBEVENT(value uint32) {
	volatile.StoreUint32(&o.EVENTS_USBEVENT.Reg, volatile.LoadUint32(&o.EVENTS_USBEVENT.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_USBEVENT() uint32 {
	return volatile.LoadUint32(&o.EVENTS_USBEVENT.Reg) & 0x1
}

// USBD.EVENTS_EP0SETUP: A valid SETUP token has been received (and acknowledged) on the control endpoint
func (o *USBD_Type) SetEVENTS_EP0SETUP(value uint32) {
	volatile.StoreUint32(&o.EVENTS_EP0SETUP.Reg, volatile.LoadUint32(&o.EVENTS_EP0SETUP.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_EP0SETUP() uint32 {
	return volatile.LoadUint32(&o.EVENTS_EP0SETUP.Reg) & 0x1
}

// USBD.EVENTS_EPDATA: A data transfer has occurred on a data endpoint, indicated by the EPDATASTATUS register
func (o *USBD_Type) SetEVENTS_EPDATA(value uint32) {
	volatile.StoreUint32(&o.EVENTS_EPDATA.Reg, volatile.LoadUint32(&o.EVENTS_EPDATA.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTS_EPDATA() uint32 {
	return volatile.LoadUint32(&o.EVENTS_EPDATA.Reg) & 0x1
}

// USBD.SHORTS: Shortcuts between local events and tasks
func (o *USBD_Type) SetSHORTS_EP0DATADONE_STARTEPIN0(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetSHORTS_EP0DATADONE_STARTEPIN0() uint32 {
	return volatile.LoadUint32(&o.SHORTS.Reg) & 0x1
}
func (o *USBD_Type) SetSHORTS_EP0DATADONE_STARTEPOUT0(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetSHORTS_EP0DATADONE_STARTEPOUT0() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetSHORTS_EP0DATADONE_EP0STATUS(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetSHORTS_EP0DATADONE_EP0STATUS() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetSHORTS_ENDEPOUT0_EP0STATUS(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetSHORTS_ENDEPOUT0_EP0STATUS() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetSHORTS_ENDEPOUT0_EP0RCVOUT(value uint32) {
	volatile.StoreUint32(&o.SHORTS.Reg, volatile.LoadUint32(&o.SHORTS.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetSHORTS_ENDEPOUT0_EP0RCVOUT() uint32 {
	return (volatile.LoadUint32(&o.SHORTS.Reg) & 0x10) >> 4
}

// USBD.INTEN: Enable or disable interrupt
func (o *USBD_Type) SetINTEN_USBRESET(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetINTEN_USBRESET() uint32 {
	return volatile.LoadUint32(&o.INTEN.Reg) & 0x1
}
func (o *USBD_Type) SetINTEN_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetINTEN_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetINTEN_ENDEPIN0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetINTEN_ENDEPIN0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetINTEN_ENDEPIN1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetINTEN_ENDEPIN1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetINTEN_ENDEPIN2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetINTEN_ENDEPIN2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetINTEN_ENDEPIN3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetINTEN_ENDEPIN3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetINTEN_ENDEPIN4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetINTEN_ENDEPIN4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetINTEN_ENDEPIN5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetINTEN_ENDEPIN5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetINTEN_ENDEPIN6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetINTEN_ENDEPIN6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100) >> 8
}
func (o *USBD_Type) SetINTEN_ENDEPIN7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200)|value<<9)
}
func (o *USBD_Type) GetINTEN_ENDEPIN7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200) >> 9
}
func (o *USBD_Type) SetINTEN_EP0DATADONE(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400)|value<<10)
}
func (o *USBD_Type) GetINTEN_EP0DATADONE() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400) >> 10
}
func (o *USBD_Type) SetINTEN_ENDISOIN(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800)|value<<11)
}
func (o *USBD_Type) GetINTEN_ENDISOIN() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800) >> 11
}
func (o *USBD_Type) SetINTEN_ENDEPOUT0(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000)|value<<12)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT0() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000) >> 12
}
func (o *USBD_Type) SetINTEN_ENDEPOUT1(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x2000)|value<<13)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT1() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x2000) >> 13
}
func (o *USBD_Type) SetINTEN_ENDEPOUT2(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x4000)|value<<14)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT2() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x4000) >> 14
}
func (o *USBD_Type) SetINTEN_ENDEPOUT3(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x8000)|value<<15)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT3() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x8000) >> 15
}
func (o *USBD_Type) SetINTEN_ENDEPOUT4(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x10000)|value<<16)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT4() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x10000) >> 16
}
func (o *USBD_Type) SetINTEN_ENDEPOUT5(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x20000)|value<<17)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT5() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x20000) >> 17
}
func (o *USBD_Type) SetINTEN_ENDEPOUT6(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x40000)|value<<18)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT6() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x40000) >> 18
}
func (o *USBD_Type) SetINTEN_ENDEPOUT7(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x80000)|value<<19)
}
func (o *USBD_Type) GetINTEN_ENDEPOUT7() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x80000) >> 19
}
func (o *USBD_Type) SetINTEN_ENDISOOUT(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x100000)|value<<20)
}
func (o *USBD_Type) GetINTEN_ENDISOOUT() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x100000) >> 20
}
func (o *USBD_Type) SetINTEN_SOF(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x200000)|value<<21)
}
func (o *USBD_Type) GetINTEN_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x200000) >> 21
}
func (o *USBD_Type) SetINTEN_USBEVENT(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x400000)|value<<22)
}
func (o *USBD_Type) GetINTEN_USBEVENT() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x400000) >> 22
}
func (o *USBD_Type) SetINTEN_EP0SETUP(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x800000)|value<<23)
}
func (o *USBD_Type) GetINTEN_EP0SETUP() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x800000) >> 23
}
func (o *USBD_Type) SetINTEN_EPDATA(value uint32) {
	volatile.StoreUint32(&o.INTEN.Reg, volatile.LoadUint32(&o.INTEN.Reg)&^(0x1000000)|value<<24)
}
func (o *USBD_Type) GetINTEN_EPDATA() uint32 {
	return (volatile.LoadUint32(&o.INTEN.Reg) & 0x1000000) >> 24
}

// USBD.INTENSET: Enable interrupt
func (o *USBD_Type) SetINTENSET_USBRESET(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetINTENSET_USBRESET() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *USBD_Type) SetINTENSET_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetINTENSET_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetINTENSET_ENDEPIN0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetINTENSET_ENDEPIN1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetINTENSET_ENDEPIN2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetINTENSET_ENDEPIN3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetINTENSET_ENDEPIN4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetINTENSET_ENDEPIN5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetINTENSET_ENDEPIN6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *USBD_Type) SetINTENSET_ENDEPIN7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *USBD_Type) GetINTENSET_ENDEPIN7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *USBD_Type) SetINTENSET_EP0DATADONE(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *USBD_Type) GetINTENSET_EP0DATADONE() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *USBD_Type) SetINTENSET_ENDISOIN(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *USBD_Type) GetINTENSET_ENDISOIN() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *USBD_Type) SetINTENSET_ENDEPOUT7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *USBD_Type) GetINTENSET_ENDEPOUT7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *USBD_Type) SetINTENSET_ENDISOOUT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *USBD_Type) GetINTENSET_ENDISOOUT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *USBD_Type) SetINTENSET_SOF(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200000)|value<<21)
}
func (o *USBD_Type) GetINTENSET_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200000) >> 21
}
func (o *USBD_Type) SetINTENSET_USBEVENT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400000)|value<<22)
}
func (o *USBD_Type) GetINTENSET_USBEVENT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400000) >> 22
}
func (o *USBD_Type) SetINTENSET_EP0SETUP(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800000)|value<<23)
}
func (o *USBD_Type) GetINTENSET_EP0SETUP() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800000) >> 23
}
func (o *USBD_Type) SetINTENSET_EPDATA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000000)|value<<24)
}
func (o *USBD_Type) GetINTENSET_EPDATA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000000) >> 24
}

// USBD.INTENCLR: Disable interrupt
func (o *USBD_Type) SetINTENCLR_USBRESET(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetINTENCLR_USBRESET() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *USBD_Type) SetINTENCLR_STARTED(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetINTENCLR_STARTED() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *USBD_Type) SetINTENCLR_ENDEPIN7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *USBD_Type) GetINTENCLR_ENDEPIN7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *USBD_Type) SetINTENCLR_EP0DATADONE(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *USBD_Type) GetINTENCLR_EP0DATADONE() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *USBD_Type) SetINTENCLR_ENDISOIN(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *USBD_Type) GetINTENCLR_ENDISOIN() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *USBD_Type) SetINTENCLR_ENDEPOUT7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *USBD_Type) GetINTENCLR_ENDEPOUT7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *USBD_Type) SetINTENCLR_ENDISOOUT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *USBD_Type) GetINTENCLR_ENDISOOUT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *USBD_Type) SetINTENCLR_SOF(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *USBD_Type) GetINTENCLR_SOF() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200000) >> 21
}
func (o *USBD_Type) SetINTENCLR_USBEVENT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400000)|value<<22)
}
func (o *USBD_Type) GetINTENCLR_USBEVENT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400000) >> 22
}
func (o *USBD_Type) SetINTENCLR_EP0SETUP(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800000)|value<<23)
}
func (o *USBD_Type) GetINTENCLR_EP0SETUP() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800000) >> 23
}
func (o *USBD_Type) SetINTENCLR_EPDATA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000000)|value<<24)
}
func (o *USBD_Type) GetINTENCLR_EPDATA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000000) >> 24
}

// USBD.EVENTCAUSE: Details on what caused the USBEVENT event
func (o *USBD_Type) SetEVENTCAUSE_ISOOUTCRC(value uint32) {
	volatile.StoreUint32(&o.EVENTCAUSE.Reg, volatile.LoadUint32(&o.EVENTCAUSE.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEVENTCAUSE_ISOOUTCRC() uint32 {
	return volatile.LoadUint32(&o.EVENTCAUSE.Reg) & 0x1
}
func (o *USBD_Type) SetEVENTCAUSE_SUSPEND(value uint32) {
	volatile.StoreUint32(&o.EVENTCAUSE.Reg, volatile.LoadUint32(&o.EVENTCAUSE.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetEVENTCAUSE_SUSPEND() uint32 {
	return (volatile.LoadUint32(&o.EVENTCAUSE.Reg) & 0x100) >> 8
}
func (o *USBD_Type) SetEVENTCAUSE_RESUME(value uint32) {
	volatile.StoreUint32(&o.EVENTCAUSE.Reg, volatile.LoadUint32(&o.EVENTCAUSE.Reg)&^(0x200)|value<<9)
}
func (o *USBD_Type) GetEVENTCAUSE_RESUME() uint32 {
	return (volatile.LoadUint32(&o.EVENTCAUSE.Reg) & 0x200) >> 9
}
func (o *USBD_Type) SetEVENTCAUSE_USBWUALLOWED(value uint32) {
	volatile.StoreUint32(&o.EVENTCAUSE.Reg, volatile.LoadUint32(&o.EVENTCAUSE.Reg)&^(0x400)|value<<10)
}
func (o *USBD_Type) GetEVENTCAUSE_USBWUALLOWED() uint32 {
	return (volatile.LoadUint32(&o.EVENTCAUSE.Reg) & 0x400) >> 10
}
func (o *USBD_Type) SetEVENTCAUSE_READY(value uint32) {
	volatile.StoreUint32(&o.EVENTCAUSE.Reg, volatile.LoadUint32(&o.EVENTCAUSE.Reg)&^(0x800)|value<<11)
}
func (o *USBD_Type) GetEVENTCAUSE_READY() uint32 {
	return (volatile.LoadUint32(&o.EVENTCAUSE.Reg) & 0x800) >> 11
}

// USBD.EPSTATUS: Provides information on which endpoint's EasyDMA registers have been captured
func (o *USBD_Type) SetEPSTATUS_EPIN0(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEPSTATUS_EPIN0() uint32 {
	return volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x1
}
func (o *USBD_Type) SetEPSTATUS_EPIN1(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetEPSTATUS_EPIN1() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetEPSTATUS_EPIN2(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetEPSTATUS_EPIN2() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetEPSTATUS_EPIN3(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetEPSTATUS_EPIN3() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetEPSTATUS_EPIN4(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetEPSTATUS_EPIN4() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetEPSTATUS_EPIN5(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetEPSTATUS_EPIN5() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetEPSTATUS_EPIN6(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetEPSTATUS_EPIN6() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetEPSTATUS_EPIN7(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetEPSTATUS_EPIN7() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetEPSTATUS_EPIN8(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetEPSTATUS_EPIN8() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x100) >> 8
}
func (o *USBD_Type) SetEPSTATUS_EPOUT0(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x10000)|value<<16)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT0() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x10000) >> 16
}
func (o *USBD_Type) SetEPSTATUS_EPOUT1(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x20000)|value<<17)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT1() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x20000) >> 17
}
func (o *USBD_Type) SetEPSTATUS_EPOUT2(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x40000)|value<<18)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT2() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x40000) >> 18
}
func (o *USBD_Type) SetEPSTATUS_EPOUT3(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x80000)|value<<19)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT3() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x80000) >> 19
}
func (o *USBD_Type) SetEPSTATUS_EPOUT4(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x100000)|value<<20)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT4() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x100000) >> 20
}
func (o *USBD_Type) SetEPSTATUS_EPOUT5(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x200000)|value<<21)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT5() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x200000) >> 21
}
func (o *USBD_Type) SetEPSTATUS_EPOUT6(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x400000)|value<<22)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT6() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x400000) >> 22
}
func (o *USBD_Type) SetEPSTATUS_EPOUT7(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x800000)|value<<23)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT7() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x800000) >> 23
}
func (o *USBD_Type) SetEPSTATUS_EPOUT8(value uint32) {
	volatile.StoreUint32(&o.EPSTATUS.Reg, volatile.LoadUint32(&o.EPSTATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *USBD_Type) GetEPSTATUS_EPOUT8() uint32 {
	return (volatile.LoadUint32(&o.EPSTATUS.Reg) & 0x1000000) >> 24
}

// USBD.EPDATASTATUS: Provides information on which endpoint(s) an acknowledged data transfer has occurred (EPDATA event)
func (o *USBD_Type) SetEPDATASTATUS_EPIN1(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN1() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetEPDATASTATUS_EPIN2(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN2() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetEPDATASTATUS_EPIN3(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN3() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetEPDATASTATUS_EPIN4(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN4() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetEPDATASTATUS_EPIN5(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN5() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetEPDATASTATUS_EPIN6(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN6() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetEPDATASTATUS_EPIN7(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetEPDATASTATUS_EPIN7() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT1(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x20000)|value<<17)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT1() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x20000) >> 17
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT2(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x40000)|value<<18)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT2() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x40000) >> 18
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT3(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x80000)|value<<19)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT3() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x80000) >> 19
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT4(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x100000)|value<<20)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT4() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x100000) >> 20
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT5(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x200000)|value<<21)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT5() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x200000) >> 21
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT6(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x400000)|value<<22)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT6() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x400000) >> 22
}
func (o *USBD_Type) SetEPDATASTATUS_EPOUT7(value uint32) {
	volatile.StoreUint32(&o.EPDATASTATUS.Reg, volatile.LoadUint32(&o.EPDATASTATUS.Reg)&^(0x800000)|value<<23)
}
func (o *USBD_Type) GetEPDATASTATUS_EPOUT7() uint32 {
	return (volatile.LoadUint32(&o.EPDATASTATUS.Reg) & 0x800000) >> 23
}

// USBD.USBADDR: Device USB address
func (o *USBD_Type) SetUSBADDR_ADDR(value uint32) {
	volatile.StoreUint32(&o.USBADDR.Reg, volatile.LoadUint32(&o.USBADDR.Reg)&^(0x7f)|value)
}
func (o *USBD_Type) GetUSBADDR_ADDR() uint32 {
	return volatile.LoadUint32(&o.USBADDR.Reg) & 0x7f
}

// USBD.BMREQUESTTYPE: SETUP data, byte 0, bmRequestType
func (o *USBD_Type) SetBMREQUESTTYPE_RECIPIENT(value uint32) {
	volatile.StoreUint32(&o.BMREQUESTTYPE.Reg, volatile.LoadUint32(&o.BMREQUESTTYPE.Reg)&^(0x1f)|value)
}
func (o *USBD_Type) GetBMREQUESTTYPE_RECIPIENT() uint32 {
	return volatile.LoadUint32(&o.BMREQUESTTYPE.Reg) & 0x1f
}
func (o *USBD_Type) SetBMREQUESTTYPE_TYPE(value uint32) {
	volatile.StoreUint32(&o.BMREQUESTTYPE.Reg, volatile.LoadUint32(&o.BMREQUESTTYPE.Reg)&^(0x60)|value<<5)
}
func (o *USBD_Type) GetBMREQUESTTYPE_TYPE() uint32 {
	return (volatile.LoadUint32(&o.BMREQUESTTYPE.Reg) & 0x60) >> 5
}
func (o *USBD_Type) SetBMREQUESTTYPE_DIRECTION(value uint32) {
	volatile.StoreUint32(&o.BMREQUESTTYPE.Reg, volatile.LoadUint32(&o.BMREQUESTTYPE.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetBMREQUESTTYPE_DIRECTION() uint32 {
	return (volatile.LoadUint32(&o.BMREQUESTTYPE.Reg) & 0x80) >> 7
}

// USBD.BREQUEST: SETUP data, byte 1, bRequest
func (o *USBD_Type) SetBREQUEST(value uint32) {
	volatile.StoreUint32(&o.BREQUEST.Reg, volatile.LoadUint32(&o.BREQUEST.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetBREQUEST() uint32 {
	return volatile.LoadUint32(&o.BREQUEST.Reg) & 0xff
}

// USBD.WVALUEL: SETUP data, byte 2, LSB of wValue
func (o *USBD_Type) SetWVALUEL(value uint32) {
	volatile.StoreUint32(&o.WVALUEL.Reg, volatile.LoadUint32(&o.WVALUEL.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetWVALUEL() uint32 {
	return volatile.LoadUint32(&o.WVALUEL.Reg) & 0xff
}

// USBD.WVALUEH: SETUP data, byte 3, MSB of wValue
func (o *USBD_Type) SetWVALUEH(value uint32) {
	volatile.StoreUint32(&o.WVALUEH.Reg, volatile.LoadUint32(&o.WVALUEH.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetWVALUEH() uint32 {
	return volatile.LoadUint32(&o.WVALUEH.Reg) & 0xff
}

// USBD.WINDEXL: SETUP data, byte 4, LSB of wIndex
func (o *USBD_Type) SetWINDEXL(value uint32) {
	volatile.StoreUint32(&o.WINDEXL.Reg, volatile.LoadUint32(&o.WINDEXL.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetWINDEXL() uint32 {
	return volatile.LoadUint32(&o.WINDEXL.Reg) & 0xff
}

// USBD.WINDEXH: SETUP data, byte 5, MSB of wIndex
func (o *USBD_Type) SetWINDEXH(value uint32) {
	volatile.StoreUint32(&o.WINDEXH.Reg, volatile.LoadUint32(&o.WINDEXH.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetWINDEXH() uint32 {
	return volatile.LoadUint32(&o.WINDEXH.Reg) & 0xff
}

// USBD.WLENGTHL: SETUP data, byte 6, LSB of wLength
func (o *USBD_Type) SetWLENGTHL(value uint32) {
	volatile.StoreUint32(&o.WLENGTHL.Reg, volatile.LoadUint32(&o.WLENGTHL.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetWLENGTHL() uint32 {
	return volatile.LoadUint32(&o.WLENGTHL.Reg) & 0xff
}

// USBD.WLENGTHH: SETUP data, byte 7, MSB of wLength
func (o *USBD_Type) SetWLENGTHH(value uint32) {
	volatile.StoreUint32(&o.WLENGTHH.Reg, volatile.LoadUint32(&o.WLENGTHH.Reg)&^(0xff)|value)
}
func (o *USBD_Type) GetWLENGTHH() uint32 {
	return volatile.LoadUint32(&o.WLENGTHH.Reg) & 0xff
}

// USBD.ENABLE: Enable USB
func (o *USBD_Type) SetENABLE(value uint32) {
	volatile.StoreUint32(&o.ENABLE.Reg, volatile.LoadUint32(&o.ENABLE.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetENABLE() uint32 {
	return volatile.LoadUint32(&o.ENABLE.Reg) & 0x1
}

// USBD.USBPULLUP: Control of the USB pull-up
func (o *USBD_Type) SetUSBPULLUP_CONNECT(value uint32) {
	volatile.StoreUint32(&o.USBPULLUP.Reg, volatile.LoadUint32(&o.USBPULLUP.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetUSBPULLUP_CONNECT() uint32 {
	return volatile.LoadUint32(&o.USBPULLUP.Reg) & 0x1
}

// USBD.DPDMVALUE: State D+ and D- lines will be forced into by the DPDMDRIVE task. The DPDMNODRIVE task reverts the control of the lines to MAC IP (no forcing).
func (o *USBD_Type) SetDPDMVALUE_STATE(value uint32) {
	volatile.StoreUint32(&o.DPDMVALUE.Reg, volatile.LoadUint32(&o.DPDMVALUE.Reg)&^(0x1f)|value)
}
func (o *USBD_Type) GetDPDMVALUE_STATE() uint32 {
	return volatile.LoadUint32(&o.DPDMVALUE.Reg) & 0x1f
}

// USBD.DTOGGLE: Data toggle control and status
func (o *USBD_Type) SetDTOGGLE_EP(value uint32) {
	volatile.StoreUint32(&o.DTOGGLE.Reg, volatile.LoadUint32(&o.DTOGGLE.Reg)&^(0x7)|value)
}
func (o *USBD_Type) GetDTOGGLE_EP() uint32 {
	return volatile.LoadUint32(&o.DTOGGLE.Reg) & 0x7
}
func (o *USBD_Type) SetDTOGGLE_IO(value uint32) {
	volatile.StoreUint32(&o.DTOGGLE.Reg, volatile.LoadUint32(&o.DTOGGLE.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetDTOGGLE_IO() uint32 {
	return (volatile.LoadUint32(&o.DTOGGLE.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetDTOGGLE_VALUE(value uint32) {
	volatile.StoreUint32(&o.DTOGGLE.Reg, volatile.LoadUint32(&o.DTOGGLE.Reg)&^(0x300)|value<<8)
}
func (o *USBD_Type) GetDTOGGLE_VALUE() uint32 {
	return (volatile.LoadUint32(&o.DTOGGLE.Reg) & 0x300) >> 8
}

// USBD.EPINEN: Endpoint IN enable
func (o *USBD_Type) SetEPINEN_IN0(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEPINEN_IN0() uint32 {
	return volatile.LoadUint32(&o.EPINEN.Reg) & 0x1
}
func (o *USBD_Type) SetEPINEN_IN1(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetEPINEN_IN1() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetEPINEN_IN2(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetEPINEN_IN2() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetEPINEN_IN3(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetEPINEN_IN3() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetEPINEN_IN4(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetEPINEN_IN4() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetEPINEN_IN5(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetEPINEN_IN5() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetEPINEN_IN6(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetEPINEN_IN6() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetEPINEN_IN7(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetEPINEN_IN7() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetEPINEN_ISOIN(value uint32) {
	volatile.StoreUint32(&o.EPINEN.Reg, volatile.LoadUint32(&o.EPINEN.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetEPINEN_ISOIN() uint32 {
	return (volatile.LoadUint32(&o.EPINEN.Reg) & 0x100) >> 8
}

// USBD.EPOUTEN: Endpoint OUT enable
func (o *USBD_Type) SetEPOUTEN_OUT0(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetEPOUTEN_OUT0() uint32 {
	return volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x1
}
func (o *USBD_Type) SetEPOUTEN_OUT1(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x2)|value<<1)
}
func (o *USBD_Type) GetEPOUTEN_OUT1() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x2) >> 1
}
func (o *USBD_Type) SetEPOUTEN_OUT2(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x4)|value<<2)
}
func (o *USBD_Type) GetEPOUTEN_OUT2() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x4) >> 2
}
func (o *USBD_Type) SetEPOUTEN_OUT3(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x8)|value<<3)
}
func (o *USBD_Type) GetEPOUTEN_OUT3() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x8) >> 3
}
func (o *USBD_Type) SetEPOUTEN_OUT4(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x10)|value<<4)
}
func (o *USBD_Type) GetEPOUTEN_OUT4() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x10) >> 4
}
func (o *USBD_Type) SetEPOUTEN_OUT5(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x20)|value<<5)
}
func (o *USBD_Type) GetEPOUTEN_OUT5() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x20) >> 5
}
func (o *USBD_Type) SetEPOUTEN_OUT6(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x40)|value<<6)
}
func (o *USBD_Type) GetEPOUTEN_OUT6() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x40) >> 6
}
func (o *USBD_Type) SetEPOUTEN_OUT7(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetEPOUTEN_OUT7() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetEPOUTEN_ISOOUT(value uint32) {
	volatile.StoreUint32(&o.EPOUTEN.Reg, volatile.LoadUint32(&o.EPOUTEN.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetEPOUTEN_ISOOUT() uint32 {
	return (volatile.LoadUint32(&o.EPOUTEN.Reg) & 0x100) >> 8
}

// USBD.EPSTALL: STALL endpoints
func (o *USBD_Type) SetEPSTALL_EP(value uint32) {
	volatile.StoreUint32(&o.EPSTALL.Reg, volatile.LoadUint32(&o.EPSTALL.Reg)&^(0x7)|value)
}
func (o *USBD_Type) GetEPSTALL_EP() uint32 {
	return volatile.LoadUint32(&o.EPSTALL.Reg) & 0x7
}
func (o *USBD_Type) SetEPSTALL_IO(value uint32) {
	volatile.StoreUint32(&o.EPSTALL.Reg, volatile.LoadUint32(&o.EPSTALL.Reg)&^(0x80)|value<<7)
}
func (o *USBD_Type) GetEPSTALL_IO() uint32 {
	return (volatile.LoadUint32(&o.EPSTALL.Reg) & 0x80) >> 7
}
func (o *USBD_Type) SetEPSTALL_STALL(value uint32) {
	volatile.StoreUint32(&o.EPSTALL.Reg, volatile.LoadUint32(&o.EPSTALL.Reg)&^(0x100)|value<<8)
}
func (o *USBD_Type) GetEPSTALL_STALL() uint32 {
	return (volatile.LoadUint32(&o.EPSTALL.Reg) & 0x100) >> 8
}

// USBD.ISOSPLIT: Controls the split of ISO buffers
func (o *USBD_Type) SetISOSPLIT_SPLIT(value uint32) {
	volatile.StoreUint32(&o.ISOSPLIT.Reg, volatile.LoadUint32(&o.ISOSPLIT.Reg)&^(0xffff)|value)
}
func (o *USBD_Type) GetISOSPLIT_SPLIT() uint32 {
	return volatile.LoadUint32(&o.ISOSPLIT.Reg) & 0xffff
}

// USBD.FRAMECNTR: Returns the current value of the start of frame counter
func (o *USBD_Type) SetFRAMECNTR(value uint32) {
	volatile.StoreUint32(&o.FRAMECNTR.Reg, volatile.LoadUint32(&o.FRAMECNTR.Reg)&^(0x7ff)|value)
}
func (o *USBD_Type) GetFRAMECNTR() uint32 {
	return volatile.LoadUint32(&o.FRAMECNTR.Reg) & 0x7ff
}

// USBD.LOWPOWER: Controls USBD peripheral low power mode during USB suspend
func (o *USBD_Type) SetLOWPOWER(value uint32) {
	volatile.StoreUint32(&o.LOWPOWER.Reg, volatile.LoadUint32(&o.LOWPOWER.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetLOWPOWER() uint32 {
	return volatile.LoadUint32(&o.LOWPOWER.Reg) & 0x1
}

// USBD.ISOINCONFIG: Controls the response of the ISO IN endpoint to an IN token when no data is ready to be sent
func (o *USBD_Type) SetISOINCONFIG_RESPONSE(value uint32) {
	volatile.StoreUint32(&o.ISOINCONFIG.Reg, volatile.LoadUint32(&o.ISOINCONFIG.Reg)&^(0x1)|value)
}
func (o *USBD_Type) GetISOINCONFIG_RESPONSE() uint32 {
	return volatile.LoadUint32(&o.ISOINCONFIG.Reg) & 0x1
}

// Unspecified
type USBD_HALTED_Type struct {
	EPIN  [8]volatile.Register32 // 0x420
	_     [4]byte
	EPOUT [8]volatile.Register32 // 0x444
}

// Unspecified
type USBD_SIZE_Type struct {
	EPOUT  [8]volatile.Register32 // 0x4A0
	ISOOUT volatile.Register32    // 0x4C0
}

// USBD_SIZE.ISOOUT: Number of bytes received last on this ISO OUT data endpoint
func (o *USBD_SIZE_Type) SetISOOUT_SIZE(value uint32) {
	volatile.StoreUint32(&o.ISOOUT.Reg, volatile.LoadUint32(&o.ISOOUT.Reg)&^(0x3ff)|value)
}
func (o *USBD_SIZE_Type) GetISOOUT_SIZE() uint32 {
	return volatile.LoadUint32(&o.ISOOUT.Reg) & 0x3ff
}
func (o *USBD_SIZE_Type) SetISOOUT_ZERO(value uint32) {
	volatile.StoreUint32(&o.ISOOUT.Reg, volatile.LoadUint32(&o.ISOOUT.Reg)&^(0x10000)|value<<16)
}
func (o *USBD_SIZE_Type) GetISOOUT_ZERO() uint32 {
	return (volatile.LoadUint32(&o.ISOOUT.Reg) & 0x10000) >> 16
}

// Unspecified
type USBD_EPIN_Type struct {
	PTR    volatile.Register32 // 0x600
	MAXCNT volatile.Register32 // 0x604
	AMOUNT volatile.Register32 // 0x608
	_      [8]byte
}

// USBD_EPIN.PTR: Description cluster: Data pointer
func (o *USBD_EPIN_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *USBD_EPIN_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// USBD_EPIN.MAXCNT: Description cluster: Maximum number of bytes to transfer
func (o *USBD_EPIN_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x7f)|value)
}
func (o *USBD_EPIN_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x7f
}

// USBD_EPIN.AMOUNT: Description cluster: Number of bytes transferred in the last transaction
func (o *USBD_EPIN_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x7f)|value)
}
func (o *USBD_EPIN_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x7f
}

// Unspecified
type USBD_ISOIN_Type struct {
	PTR    volatile.Register32 // 0x6A0
	MAXCNT volatile.Register32 // 0x6A4
	AMOUNT volatile.Register32 // 0x6A8
}

// USBD_ISOIN.PTR: Data pointer
func (o *USBD_ISOIN_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *USBD_ISOIN_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// USBD_ISOIN.MAXCNT: Maximum number of bytes to transfer
func (o *USBD_ISOIN_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x3ff)|value)
}
func (o *USBD_ISOIN_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x3ff
}

// USBD_ISOIN.AMOUNT: Number of bytes transferred in the last transaction
func (o *USBD_ISOIN_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x3ff)|value)
}
func (o *USBD_ISOIN_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x3ff
}

// Unspecified
type USBD_EPOUT_Type struct {
	PTR    volatile.Register32 // 0x700
	MAXCNT volatile.Register32 // 0x704
	AMOUNT volatile.Register32 // 0x708
	_      [8]byte
}

// USBD_EPOUT.PTR: Description cluster: Data pointer
func (o *USBD_EPOUT_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *USBD_EPOUT_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// USBD_EPOUT.MAXCNT: Description cluster: Maximum number of bytes to transfer
func (o *USBD_EPOUT_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x7f)|value)
}
func (o *USBD_EPOUT_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x7f
}

// USBD_EPOUT.AMOUNT: Description cluster: Number of bytes transferred in the last transaction
func (o *USBD_EPOUT_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x7f)|value)
}
func (o *USBD_EPOUT_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x7f
}

// Unspecified
type USBD_ISOOUT_Type struct {
	PTR    volatile.Register32 // 0x7A0
	MAXCNT volatile.Register32 // 0x7A4
	AMOUNT volatile.Register32 // 0x7A8
}

// USBD_ISOOUT.PTR: Data pointer
func (o *USBD_ISOOUT_Type) SetPTR(value uint32) {
	volatile.StoreUint32(&o.PTR.Reg, value)
}
func (o *USBD_ISOOUT_Type) GetPTR() uint32 {
	return volatile.LoadUint32(&o.PTR.Reg)
}

// USBD_ISOOUT.MAXCNT: Maximum number of bytes to transfer
func (o *USBD_ISOOUT_Type) SetMAXCNT(value uint32) {
	volatile.StoreUint32(&o.MAXCNT.Reg, volatile.LoadUint32(&o.MAXCNT.Reg)&^(0x3ff)|value)
}
func (o *USBD_ISOOUT_Type) GetMAXCNT() uint32 {
	return volatile.LoadUint32(&o.MAXCNT.Reg) & 0x3ff
}

// USBD_ISOOUT.AMOUNT: Number of bytes transferred in the last transaction
func (o *USBD_ISOOUT_Type) SetAMOUNT(value uint32) {
	volatile.StoreUint32(&o.AMOUNT.Reg, volatile.LoadUint32(&o.AMOUNT.Reg)&^(0x3ff)|value)
}
func (o *USBD_ISOOUT_Type) GetAMOUNT() uint32 {
	return volatile.LoadUint32(&o.AMOUNT.Reg) & 0x3ff
}

// Constants for FICR: Factory information configuration registers
const (
	// CODEPAGESIZE: Code memory page size
	// Position of CODEPAGESIZE field.
	FICR_CODEPAGESIZE_CODEPAGESIZE_Pos = 0x0
	// Bit mask of CODEPAGESIZE field.
	FICR_CODEPAGESIZE_CODEPAGESIZE_Msk = 0xffffffff

	// CODESIZE: Code memory size
	// Position of CODESIZE field.
	FICR_CODESIZE_CODESIZE_Pos = 0x0
	// Bit mask of CODESIZE field.
	FICR_CODESIZE_CODESIZE_Msk = 0xffffffff

	// DEVICEID: Description collection: Device identifier
	// Position of DEVICEID field.
	FICR_DEVICEID_DEVICEID_Pos = 0x0
	// Bit mask of DEVICEID field.
	FICR_DEVICEID_DEVICEID_Msk = 0xffffffff

	// ER: Description collection: Encryption root, word n
	// Position of ER field.
	FICR_ER_ER_Pos = 0x0
	// Bit mask of ER field.
	FICR_ER_ER_Msk = 0xffffffff

	// IR: Description collection: Identity Root, word n
	// Position of IR field.
	FICR_IR_IR_Pos = 0x0
	// Bit mask of IR field.
	FICR_IR_IR_Msk = 0xffffffff

	// DEVICEADDRTYPE: Device address type
	// Position of DEVICEADDRTYPE field.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Pos = 0x0
	// Bit mask of DEVICEADDRTYPE field.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Msk = 0x1
	// Bit DEVICEADDRTYPE.
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE = 0x1
	// Public address
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Public = 0x0
	// Random address
	FICR_DEVICEADDRTYPE_DEVICEADDRTYPE_Random = 0x1

	// DEVICEADDR: Description collection: Device address n
	// Position of DEVICEADDR field.
	FICR_DEVICEADDR_DEVICEADDR_Pos = 0x0
	// Bit mask of DEVICEADDR field.
	FICR_DEVICEADDR_DEVICEADDR_Msk = 0xffffffff

	// INFO.PART: Part code
	// Position of PART field.
	FICR_INFO_PART_PART_Pos = 0x0
	// Bit mask of PART field.
	FICR_INFO_PART_PART_Msk = 0xffffffff
	// nRF52833
	FICR_INFO_PART_PART_N52833 = 0x52833
	// nRF52840
	FICR_INFO_PART_PART_N52840 = 0x52840
	// Unspecified
	FICR_INFO_PART_PART_Unspecified = 0xffffffff

	// INFO.VARIANT: Build code (hardware version and production configuration)
	// Position of VARIANT field.
	FICR_INFO_VARIANT_VARIANT_Pos = 0x0
	// Bit mask of VARIANT field.
	FICR_INFO_VARIANT_VARIANT_Msk = 0xffffffff
	// AAAA
	FICR_INFO_VARIANT_VARIANT_AAAA = 0x41414141
	// AAAB
	FICR_INFO_VARIANT_VARIANT_AAAB = 0x41414142
	// Unspecified
	FICR_INFO_VARIANT_VARIANT_Unspecified = 0xffffffff

	// INFO.PACKAGE: Package option
	// Position of PACKAGE field.
	FICR_INFO_PACKAGE_PACKAGE_Pos = 0x0
	// Bit mask of PACKAGE field.
	FICR_INFO_PACKAGE_PACKAGE_Msk = 0xffffffff
	// QDxx - 40-pin QFN
	FICR_INFO_PACKAGE_PACKAGE_QD = 0x2007
	// QIxx - 73-pin aQFN
	FICR_INFO_PACKAGE_PACKAGE_QI = 0x2004
	// CJxx - WLCSP
	FICR_INFO_PACKAGE_PACKAGE_CJ = 0x2008
	// Unspecified
	FICR_INFO_PACKAGE_PACKAGE_Unspecified = 0xffffffff

	// INFO.RAM: RAM variant
	// Position of RAM field.
	FICR_INFO_RAM_RAM_Pos = 0x0
	// Bit mask of RAM field.
	FICR_INFO_RAM_RAM_Msk = 0xffffffff
	// 16 kByte RAM
	FICR_INFO_RAM_RAM_K16 = 0x10
	// 32 kByte RAM
	FICR_INFO_RAM_RAM_K32 = 0x20
	// 64 kByte RAM
	FICR_INFO_RAM_RAM_K64 = 0x40
	// 128 kByte RAM
	FICR_INFO_RAM_RAM_K128 = 0x80
	// 256 kByte RAM
	FICR_INFO_RAM_RAM_K256 = 0x100
	// Unspecified
	FICR_INFO_RAM_RAM_Unspecified = 0xffffffff

	// INFO.FLASH: Flash variant
	// Position of FLASH field.
	FICR_INFO_FLASH_FLASH_Pos = 0x0
	// Bit mask of FLASH field.
	FICR_INFO_FLASH_FLASH_Msk = 0xffffffff
	// 128 kByte FLASH
	FICR_INFO_FLASH_FLASH_K128 = 0x80
	// 256 kByte FLASH
	FICR_INFO_FLASH_FLASH_K256 = 0x100
	// 512 kByte FLASH
	FICR_INFO_FLASH_FLASH_K512 = 0x200
	// 1 MByte FLASH
	FICR_INFO_FLASH_FLASH_K1024 = 0x400
	// 2 MByte FLASH
	FICR_INFO_FLASH_FLASH_K2048 = 0x800
	// Unspecified
	FICR_INFO_FLASH_FLASH_Unspecified = 0xffffffff

	// PRODTEST: Description collection: Production test signature n
	// Position of PRODTEST field.
	FICR_PRODTEST_PRODTEST_Pos = 0x0
	// Bit mask of PRODTEST field.
	FICR_PRODTEST_PRODTEST_Msk = 0xffffffff
	// Production tests done
	FICR_PRODTEST_PRODTEST_Done = 0xbb42319f
	// Production tests not done
	FICR_PRODTEST_PRODTEST_NotDone = 0xffffffff

	// TEMP.A0: Slope definition A0
	// Position of A field.
	FICR_TEMP_A0_A_Pos = 0x0
	// Bit mask of A field.
	FICR_TEMP_A0_A_Msk = 0xfff

	// TEMP.A1: Slope definition A1
	// Position of A field.
	FICR_TEMP_A1_A_Pos = 0x0
	// Bit mask of A field.
	FICR_TEMP_A1_A_Msk = 0xfff

	// TEMP.A2: Slope definition A2
	// Position of A field.
	FICR_TEMP_A2_A_Pos = 0x0
	// Bit mask of A field.
	FICR_TEMP_A2_A_Msk = 0xfff

	// TEMP.A3: Slope definition A3
	// Position of A field.
	FICR_TEMP_A3_A_Pos = 0x0
	// Bit mask of A field.
	FICR_TEMP_A3_A_Msk = 0xfff

	// TEMP.A4: Slope definition A4
	// Position of A field.
	FICR_TEMP_A4_A_Pos = 0x0
	// Bit mask of A field.
	FICR_TEMP_A4_A_Msk = 0xfff

	// TEMP.A5: Slope definition A5
	// Position of A field.
	FICR_TEMP_A5_A_Pos = 0x0
	// Bit mask of A field.
	FICR_TEMP_A5_A_Msk = 0xfff

	// TEMP.B0: Y-intercept B0
	// Position of B field.
	FICR_TEMP_B0_B_Pos = 0x0
	// Bit mask of B field.
	FICR_TEMP_B0_B_Msk = 0x3fff

	// TEMP.B1: Y-intercept B1
	// Position of B field.
	FICR_TEMP_B1_B_Pos = 0x0
	// Bit mask of B field.
	FICR_TEMP_B1_B_Msk = 0x3fff

	// TEMP.B2: Y-intercept B2
	// Position of B field.
	FICR_TEMP_B2_B_Pos = 0x0
	// Bit mask of B field.
	FICR_TEMP_B2_B_Msk = 0x3fff

	// TEMP.B3: Y-intercept B3
	// Position of B field.
	FICR_TEMP_B3_B_Pos = 0x0
	// Bit mask of B field.
	FICR_TEMP_B3_B_Msk = 0x3fff

	// TEMP.B4: Y-intercept B4
	// Position of B field.
	FICR_TEMP_B4_B_Pos = 0x0
	// Bit mask of B field.
	FICR_TEMP_B4_B_Msk = 0x3fff

	// TEMP.B5: Y-intercept B5
	// Position of B field.
	FICR_TEMP_B5_B_Pos = 0x0
	// Bit mask of B field.
	FICR_TEMP_B5_B_Msk = 0x3fff

	// TEMP.T0: Segment end T0
	// Position of T field.
	FICR_TEMP_T0_T_Pos = 0x0
	// Bit mask of T field.
	FICR_TEMP_T0_T_Msk = 0xff

	// TEMP.T1: Segment end T1
	// Position of T field.
	FICR_TEMP_T1_T_Pos = 0x0
	// Bit mask of T field.
	FICR_TEMP_T1_T_Msk = 0xff

	// TEMP.T2: Segment end T2
	// Position of T field.
	FICR_TEMP_T2_T_Pos = 0x0
	// Bit mask of T field.
	FICR_TEMP_T2_T_Msk = 0xff

	// TEMP.T3: Segment end T3
	// Position of T field.
	FICR_TEMP_T3_T_Pos = 0x0
	// Bit mask of T field.
	FICR_TEMP_T3_T_Msk = 0xff

	// TEMP.T4: Segment end T4
	// Position of T field.
	FICR_TEMP_T4_T_Pos = 0x0
	// Bit mask of T field.
	FICR_TEMP_T4_T_Msk = 0xff

	// NFC.TAGHEADER0: Default header for NFC tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST, and NFCID1_LAST.
	// Position of MFGID field.
	FICR_NFC_TAGHEADER0_MFGID_Pos = 0x0
	// Bit mask of MFGID field.
	FICR_NFC_TAGHEADER0_MFGID_Msk = 0xff
	// Position of UD1 field.
	FICR_NFC_TAGHEADER0_UD1_Pos = 0x8
	// Bit mask of UD1 field.
	FICR_NFC_TAGHEADER0_UD1_Msk = 0xff00
	// Position of UD2 field.
	FICR_NFC_TAGHEADER0_UD2_Pos = 0x10
	// Bit mask of UD2 field.
	FICR_NFC_TAGHEADER0_UD2_Msk = 0xff0000
	// Position of UD3 field.
	FICR_NFC_TAGHEADER0_UD3_Pos = 0x18
	// Bit mask of UD3 field.
	FICR_NFC_TAGHEADER0_UD3_Msk = 0xff000000

	// NFC.TAGHEADER1: Default header for NFC tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST, and NFCID1_LAST.
	// Position of UD4 field.
	FICR_NFC_TAGHEADER1_UD4_Pos = 0x0
	// Bit mask of UD4 field.
	FICR_NFC_TAGHEADER1_UD4_Msk = 0xff
	// Position of UD5 field.
	FICR_NFC_TAGHEADER1_UD5_Pos = 0x8
	// Bit mask of UD5 field.
	FICR_NFC_TAGHEADER1_UD5_Msk = 0xff00
	// Position of UD6 field.
	FICR_NFC_TAGHEADER1_UD6_Pos = 0x10
	// Bit mask of UD6 field.
	FICR_NFC_TAGHEADER1_UD6_Msk = 0xff0000
	// Position of UD7 field.
	FICR_NFC_TAGHEADER1_UD7_Pos = 0x18
	// Bit mask of UD7 field.
	FICR_NFC_TAGHEADER1_UD7_Msk = 0xff000000

	// NFC.TAGHEADER2: Default header for NFC tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST, and NFCID1_LAST.
	// Position of UD8 field.
	FICR_NFC_TAGHEADER2_UD8_Pos = 0x0
	// Bit mask of UD8 field.
	FICR_NFC_TAGHEADER2_UD8_Msk = 0xff
	// Position of UD9 field.
	FICR_NFC_TAGHEADER2_UD9_Pos = 0x8
	// Bit mask of UD9 field.
	FICR_NFC_TAGHEADER2_UD9_Msk = 0xff00
	// Position of UD10 field.
	FICR_NFC_TAGHEADER2_UD10_Pos = 0x10
	// Bit mask of UD10 field.
	FICR_NFC_TAGHEADER2_UD10_Msk = 0xff0000
	// Position of UD11 field.
	FICR_NFC_TAGHEADER2_UD11_Pos = 0x18
	// Bit mask of UD11 field.
	FICR_NFC_TAGHEADER2_UD11_Msk = 0xff000000

	// NFC.TAGHEADER3: Default header for NFC tag. Software can read these values to populate NFCID1_3RD_LAST, NFCID1_2ND_LAST, and NFCID1_LAST.
	// Position of UD12 field.
	FICR_NFC_TAGHEADER3_UD12_Pos = 0x0
	// Bit mask of UD12 field.
	FICR_NFC_TAGHEADER3_UD12_Msk = 0xff
	// Position of UD13 field.
	FICR_NFC_TAGHEADER3_UD13_Pos = 0x8
	// Bit mask of UD13 field.
	FICR_NFC_TAGHEADER3_UD13_Msk = 0xff00
	// Position of UD14 field.
	FICR_NFC_TAGHEADER3_UD14_Pos = 0x10
	// Bit mask of UD14 field.
	FICR_NFC_TAGHEADER3_UD14_Msk = 0xff0000
	// Position of UD15 field.
	FICR_NFC_TAGHEADER3_UD15_Pos = 0x18
	// Bit mask of UD15 field.
	FICR_NFC_TAGHEADER3_UD15_Msk = 0xff000000
)

// Constants for UICR: User information configuration registers
const (
	// NRFFW: Description collection: Reserved for Nordic firmware design
	// Position of NRFFW field.
	UICR_NRFFW_NRFFW_Pos = 0x0
	// Bit mask of NRFFW field.
	UICR_NRFFW_NRFFW_Msk = 0xffffffff

	// NRFHW: Description collection: Reserved for Nordic hardware design
	// Position of NRFHW field.
	UICR_NRFHW_NRFHW_Pos = 0x0
	// Bit mask of NRFHW field.
	UICR_NRFHW_NRFHW_Msk = 0xffffffff

	// CUSTOMER: Description collection: Reserved for customer
	// Position of CUSTOMER field.
	UICR_CUSTOMER_CUSTOMER_Pos = 0x0
	// Bit mask of CUSTOMER field.
	UICR_CUSTOMER_CUSTOMER_Msk = 0xffffffff

	// PSELRESET: Description collection: Mapping of the nRESET function (see POWER chapter for details)
	// Position of PIN field.
	UICR_PSELRESET_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UICR_PSELRESET_PIN_Msk = 0x1f
	// Position of PORT field.
	UICR_PSELRESET_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UICR_PSELRESET_PORT_Msk = 0x20
	// Bit PORT.
	UICR_PSELRESET_PORT = 0x20
	// Position of CONNECT field.
	UICR_PSELRESET_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UICR_PSELRESET_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UICR_PSELRESET_CONNECT = 0x80000000
	// Disconnect
	UICR_PSELRESET_CONNECT_Disconnected = 0x1
	// Connect
	UICR_PSELRESET_CONNECT_Connected = 0x0

	// APPROTECT: Access port protection
	// Position of PALL field.
	UICR_APPROTECT_PALL_Pos = 0x0
	// Bit mask of PALL field.
	UICR_APPROTECT_PALL_Msk = 0xff
	// Disable
	UICR_APPROTECT_PALL_Disabled = 0xff
	// Enable
	UICR_APPROTECT_PALL_Enabled = 0x0

	// NFCPINS: Setting of pins dedicated to NFC functionality: NFC antenna or GPIO
	// Position of PROTECT field.
	UICR_NFCPINS_PROTECT_Pos = 0x0
	// Bit mask of PROTECT field.
	UICR_NFCPINS_PROTECT_Msk = 0x1
	// Bit PROTECT.
	UICR_NFCPINS_PROTECT = 0x1
	// Operation as GPIO pins. Same protection as normal GPIO pins
	UICR_NFCPINS_PROTECT_Disabled = 0x0
	// Operation as NFC antenna pins. Configures the protection for NFC operation
	UICR_NFCPINS_PROTECT_NFC = 0x1

	// DEBUGCTRL: Processor debug control
	// Position of CPUNIDEN field.
	UICR_DEBUGCTRL_CPUNIDEN_Pos = 0x0
	// Bit mask of CPUNIDEN field.
	UICR_DEBUGCTRL_CPUNIDEN_Msk = 0xff
	// Enable CPU ITM and ETM functionality (default behavior)
	UICR_DEBUGCTRL_CPUNIDEN_Enabled = 0xff
	// Disable CPU ITM and ETM functionality
	UICR_DEBUGCTRL_CPUNIDEN_Disabled = 0x0
	// Position of CPUFPBEN field.
	UICR_DEBUGCTRL_CPUFPBEN_Pos = 0x8
	// Bit mask of CPUFPBEN field.
	UICR_DEBUGCTRL_CPUFPBEN_Msk = 0xff00
	// Enable CPU FPB unit (default behavior)
	UICR_DEBUGCTRL_CPUFPBEN_Enabled = 0xff
	// Disable CPU FPB unit. Writes into the FPB registers will be ignored.
	UICR_DEBUGCTRL_CPUFPBEN_Disabled = 0x0

	// REGOUT0: Output voltage from REG0 regulator stage. The maximum output voltage from this stage is given as VDDH - VREG0DROP.
	// Position of VOUT field.
	UICR_REGOUT0_VOUT_Pos = 0x0
	// Bit mask of VOUT field.
	UICR_REGOUT0_VOUT_Msk = 0x7
	// 1.8 V
	UICR_REGOUT0_VOUT_1V8 = 0x0
	// 2.1 V
	UICR_REGOUT0_VOUT_2V1 = 0x1
	// 2.4 V
	UICR_REGOUT0_VOUT_2V4 = 0x2
	// 2.7 V
	UICR_REGOUT0_VOUT_2V7 = 0x3
	// 3.0 V
	UICR_REGOUT0_VOUT_3V0 = 0x4
	// 3.3 V
	UICR_REGOUT0_VOUT_3V3 = 0x5
	// Default voltage: 1.8 V
	UICR_REGOUT0_VOUT_DEFAULT = 0x7
)

// Constants for CLOCK: Clock control
const (
	// TASKS_HFCLKSTART: Start HFXO crystal oscillator
	// Position of TASKS_HFCLKSTART field.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Pos = 0x0
	// Bit mask of TASKS_HFCLKSTART field.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Msk = 0x1
	// Bit TASKS_HFCLKSTART.
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKSTART_TASKS_HFCLKSTART_Trigger = 0x1

	// TASKS_HFCLKSTOP: Stop HFXO crystal oscillator
	// Position of TASKS_HFCLKSTOP field.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Pos = 0x0
	// Bit mask of TASKS_HFCLKSTOP field.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Msk = 0x1
	// Bit TASKS_HFCLKSTOP.
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_HFCLKSTOP_TASKS_HFCLKSTOP_Trigger = 0x1

	// TASKS_LFCLKSTART: Start LFCLK
	// Position of TASKS_LFCLKSTART field.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Pos = 0x0
	// Bit mask of TASKS_LFCLKSTART field.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Msk = 0x1
	// Bit TASKS_LFCLKSTART.
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART = 0x1
	// Trigger task
	CLOCK_TASKS_LFCLKSTART_TASKS_LFCLKSTART_Trigger = 0x1

	// TASKS_LFCLKSTOP: Stop LFCLK
	// Position of TASKS_LFCLKSTOP field.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Pos = 0x0
	// Bit mask of TASKS_LFCLKSTOP field.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Msk = 0x1
	// Bit TASKS_LFCLKSTOP.
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_LFCLKSTOP_TASKS_LFCLKSTOP_Trigger = 0x1

	// TASKS_CAL: Start calibration of LFRC
	// Position of TASKS_CAL field.
	CLOCK_TASKS_CAL_TASKS_CAL_Pos = 0x0
	// Bit mask of TASKS_CAL field.
	CLOCK_TASKS_CAL_TASKS_CAL_Msk = 0x1
	// Bit TASKS_CAL.
	CLOCK_TASKS_CAL_TASKS_CAL = 0x1
	// Trigger task
	CLOCK_TASKS_CAL_TASKS_CAL_Trigger = 0x1

	// TASKS_CTSTART: Start calibration timer
	// Position of TASKS_CTSTART field.
	CLOCK_TASKS_CTSTART_TASKS_CTSTART_Pos = 0x0
	// Bit mask of TASKS_CTSTART field.
	CLOCK_TASKS_CTSTART_TASKS_CTSTART_Msk = 0x1
	// Bit TASKS_CTSTART.
	CLOCK_TASKS_CTSTART_TASKS_CTSTART = 0x1
	// Trigger task
	CLOCK_TASKS_CTSTART_TASKS_CTSTART_Trigger = 0x1

	// TASKS_CTSTOP: Stop calibration timer
	// Position of TASKS_CTSTOP field.
	CLOCK_TASKS_CTSTOP_TASKS_CTSTOP_Pos = 0x0
	// Bit mask of TASKS_CTSTOP field.
	CLOCK_TASKS_CTSTOP_TASKS_CTSTOP_Msk = 0x1
	// Bit TASKS_CTSTOP.
	CLOCK_TASKS_CTSTOP_TASKS_CTSTOP = 0x1
	// Trigger task
	CLOCK_TASKS_CTSTOP_TASKS_CTSTOP_Trigger = 0x1

	// EVENTS_HFCLKSTARTED: HFXO crystal oscillator started
	// Position of EVENTS_HFCLKSTARTED field.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Pos = 0x0
	// Bit mask of EVENTS_HFCLKSTARTED field.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Msk = 0x1
	// Bit EVENTS_HFCLKSTARTED.
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_HFCLKSTARTED_EVENTS_HFCLKSTARTED_Generated = 0x1

	// EVENTS_LFCLKSTARTED: LFCLK started
	// Position of EVENTS_LFCLKSTARTED field.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Pos = 0x0
	// Bit mask of EVENTS_LFCLKSTARTED field.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Msk = 0x1
	// Bit EVENTS_LFCLKSTARTED.
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_LFCLKSTARTED_EVENTS_LFCLKSTARTED_Generated = 0x1

	// EVENTS_DONE: Calibration of LFRC completed
	// Position of EVENTS_DONE field.
	CLOCK_EVENTS_DONE_EVENTS_DONE_Pos = 0x0
	// Bit mask of EVENTS_DONE field.
	CLOCK_EVENTS_DONE_EVENTS_DONE_Msk = 0x1
	// Bit EVENTS_DONE.
	CLOCK_EVENTS_DONE_EVENTS_DONE = 0x1
	// Event not generated
	CLOCK_EVENTS_DONE_EVENTS_DONE_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_DONE_EVENTS_DONE_Generated = 0x1

	// EVENTS_CTTO: Calibration timer timeout
	// Position of EVENTS_CTTO field.
	CLOCK_EVENTS_CTTO_EVENTS_CTTO_Pos = 0x0
	// Bit mask of EVENTS_CTTO field.
	CLOCK_EVENTS_CTTO_EVENTS_CTTO_Msk = 0x1
	// Bit EVENTS_CTTO.
	CLOCK_EVENTS_CTTO_EVENTS_CTTO = 0x1
	// Event not generated
	CLOCK_EVENTS_CTTO_EVENTS_CTTO_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_CTTO_EVENTS_CTTO_Generated = 0x1

	// EVENTS_CTSTARTED: Calibration timer has been started and is ready to process new tasks
	// Position of EVENTS_CTSTARTED field.
	CLOCK_EVENTS_CTSTARTED_EVENTS_CTSTARTED_Pos = 0x0
	// Bit mask of EVENTS_CTSTARTED field.
	CLOCK_EVENTS_CTSTARTED_EVENTS_CTSTARTED_Msk = 0x1
	// Bit EVENTS_CTSTARTED.
	CLOCK_EVENTS_CTSTARTED_EVENTS_CTSTARTED = 0x1
	// Event not generated
	CLOCK_EVENTS_CTSTARTED_EVENTS_CTSTARTED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_CTSTARTED_EVENTS_CTSTARTED_Generated = 0x1

	// EVENTS_CTSTOPPED: Calibration timer has been stopped and is ready to process new tasks
	// Position of EVENTS_CTSTOPPED field.
	CLOCK_EVENTS_CTSTOPPED_EVENTS_CTSTOPPED_Pos = 0x0
	// Bit mask of EVENTS_CTSTOPPED field.
	CLOCK_EVENTS_CTSTOPPED_EVENTS_CTSTOPPED_Msk = 0x1
	// Bit EVENTS_CTSTOPPED.
	CLOCK_EVENTS_CTSTOPPED_EVENTS_CTSTOPPED = 0x1
	// Event not generated
	CLOCK_EVENTS_CTSTOPPED_EVENTS_CTSTOPPED_NotGenerated = 0x0
	// Event generated
	CLOCK_EVENTS_CTSTOPPED_EVENTS_CTSTOPPED_Generated = 0x1

	// INTENSET: Enable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENSET_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENSET_HFCLKSTARTED = 0x1
	// Read: Disabled
	CLOCK_INTENSET_HFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_HFCLKSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_HFCLKSTARTED_Set = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENSET_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENSET_LFCLKSTARTED = 0x2
	// Read: Disabled
	CLOCK_INTENSET_LFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_LFCLKSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_LFCLKSTARTED_Set = 0x1
	// Position of DONE field.
	CLOCK_INTENSET_DONE_Pos = 0x3
	// Bit mask of DONE field.
	CLOCK_INTENSET_DONE_Msk = 0x8
	// Bit DONE.
	CLOCK_INTENSET_DONE = 0x8
	// Read: Disabled
	CLOCK_INTENSET_DONE_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_DONE_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_DONE_Set = 0x1
	// Position of CTTO field.
	CLOCK_INTENSET_CTTO_Pos = 0x4
	// Bit mask of CTTO field.
	CLOCK_INTENSET_CTTO_Msk = 0x10
	// Bit CTTO.
	CLOCK_INTENSET_CTTO = 0x10
	// Read: Disabled
	CLOCK_INTENSET_CTTO_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_CTTO_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_CTTO_Set = 0x1
	// Position of CTSTARTED field.
	CLOCK_INTENSET_CTSTARTED_Pos = 0xa
	// Bit mask of CTSTARTED field.
	CLOCK_INTENSET_CTSTARTED_Msk = 0x400
	// Bit CTSTARTED.
	CLOCK_INTENSET_CTSTARTED = 0x400
	// Read: Disabled
	CLOCK_INTENSET_CTSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_CTSTARTED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_CTSTARTED_Set = 0x1
	// Position of CTSTOPPED field.
	CLOCK_INTENSET_CTSTOPPED_Pos = 0xb
	// Bit mask of CTSTOPPED field.
	CLOCK_INTENSET_CTSTOPPED_Msk = 0x800
	// Bit CTSTOPPED.
	CLOCK_INTENSET_CTSTOPPED = 0x800
	// Read: Disabled
	CLOCK_INTENSET_CTSTOPPED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENSET_CTSTOPPED_Enabled = 0x1
	// Enable
	CLOCK_INTENSET_CTSTOPPED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Pos = 0x0
	// Bit mask of HFCLKSTARTED field.
	CLOCK_INTENCLR_HFCLKSTARTED_Msk = 0x1
	// Bit HFCLKSTARTED.
	CLOCK_INTENCLR_HFCLKSTARTED = 0x1
	// Read: Disabled
	CLOCK_INTENCLR_HFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_HFCLKSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_HFCLKSTARTED_Clear = 0x1
	// Position of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Pos = 0x1
	// Bit mask of LFCLKSTARTED field.
	CLOCK_INTENCLR_LFCLKSTARTED_Msk = 0x2
	// Bit LFCLKSTARTED.
	CLOCK_INTENCLR_LFCLKSTARTED = 0x2
	// Read: Disabled
	CLOCK_INTENCLR_LFCLKSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_LFCLKSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_LFCLKSTARTED_Clear = 0x1
	// Position of DONE field.
	CLOCK_INTENCLR_DONE_Pos = 0x3
	// Bit mask of DONE field.
	CLOCK_INTENCLR_DONE_Msk = 0x8
	// Bit DONE.
	CLOCK_INTENCLR_DONE = 0x8
	// Read: Disabled
	CLOCK_INTENCLR_DONE_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_DONE_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_DONE_Clear = 0x1
	// Position of CTTO field.
	CLOCK_INTENCLR_CTTO_Pos = 0x4
	// Bit mask of CTTO field.
	CLOCK_INTENCLR_CTTO_Msk = 0x10
	// Bit CTTO.
	CLOCK_INTENCLR_CTTO = 0x10
	// Read: Disabled
	CLOCK_INTENCLR_CTTO_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_CTTO_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_CTTO_Clear = 0x1
	// Position of CTSTARTED field.
	CLOCK_INTENCLR_CTSTARTED_Pos = 0xa
	// Bit mask of CTSTARTED field.
	CLOCK_INTENCLR_CTSTARTED_Msk = 0x400
	// Bit CTSTARTED.
	CLOCK_INTENCLR_CTSTARTED = 0x400
	// Read: Disabled
	CLOCK_INTENCLR_CTSTARTED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_CTSTARTED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_CTSTARTED_Clear = 0x1
	// Position of CTSTOPPED field.
	CLOCK_INTENCLR_CTSTOPPED_Pos = 0xb
	// Bit mask of CTSTOPPED field.
	CLOCK_INTENCLR_CTSTOPPED_Msk = 0x800
	// Bit CTSTOPPED.
	CLOCK_INTENCLR_CTSTOPPED = 0x800
	// Read: Disabled
	CLOCK_INTENCLR_CTSTOPPED_Disabled = 0x0
	// Read: Enabled
	CLOCK_INTENCLR_CTSTOPPED_Enabled = 0x1
	// Disable
	CLOCK_INTENCLR_CTSTOPPED_Clear = 0x1

	// HFCLKRUN: Status indicating that HFCLKSTART task has been triggered
	// Position of STATUS field.
	CLOCK_HFCLKRUN_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	CLOCK_HFCLKRUN_STATUS_Msk = 0x1
	// Bit STATUS.
	CLOCK_HFCLKRUN_STATUS = 0x1
	// Task not triggered
	CLOCK_HFCLKRUN_STATUS_NotTriggered = 0x0
	// Task triggered
	CLOCK_HFCLKRUN_STATUS_Triggered = 0x1

	// HFCLKSTAT: HFCLK status
	// Position of SRC field.
	CLOCK_HFCLKSTAT_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_HFCLKSTAT_SRC_Msk = 0x1
	// Bit SRC.
	CLOCK_HFCLKSTAT_SRC = 0x1
	// 64 MHz internal oscillator (HFINT)
	CLOCK_HFCLKSTAT_SRC_RC = 0x0
	// 64 MHz crystal oscillator (HFXO)
	CLOCK_HFCLKSTAT_SRC_Xtal = 0x1
	// Position of STATE field.
	CLOCK_HFCLKSTAT_STATE_Pos = 0x10
	// Bit mask of STATE field.
	CLOCK_HFCLKSTAT_STATE_Msk = 0x10000
	// Bit STATE.
	CLOCK_HFCLKSTAT_STATE = 0x10000
	// HFCLK not running
	CLOCK_HFCLKSTAT_STATE_NotRunning = 0x0
	// HFCLK running
	CLOCK_HFCLKSTAT_STATE_Running = 0x1

	// LFCLKRUN: Status indicating that LFCLKSTART task has been triggered
	// Position of STATUS field.
	CLOCK_LFCLKRUN_STATUS_Pos = 0x0
	// Bit mask of STATUS field.
	CLOCK_LFCLKRUN_STATUS_Msk = 0x1
	// Bit STATUS.
	CLOCK_LFCLKRUN_STATUS = 0x1
	// Task not triggered
	CLOCK_LFCLKRUN_STATUS_NotTriggered = 0x0
	// Task triggered
	CLOCK_LFCLKRUN_STATUS_Triggered = 0x1

	// LFCLKSTAT: LFCLK status
	// Position of SRC field.
	CLOCK_LFCLKSTAT_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSTAT_SRC_Msk = 0x3
	// 32.768 kHz RC oscillator (LFRC)
	CLOCK_LFCLKSTAT_SRC_RC = 0x0
	// 32.768 kHz crystal oscillator (LFXO)
	CLOCK_LFCLKSTAT_SRC_Xtal = 0x1
	// 32.768 kHz synthesized from HFCLK (LFSYNT)
	CLOCK_LFCLKSTAT_SRC_Synth = 0x2
	// Position of STATE field.
	CLOCK_LFCLKSTAT_STATE_Pos = 0x10
	// Bit mask of STATE field.
	CLOCK_LFCLKSTAT_STATE_Msk = 0x10000
	// Bit STATE.
	CLOCK_LFCLKSTAT_STATE = 0x10000
	// LFCLK not running
	CLOCK_LFCLKSTAT_STATE_NotRunning = 0x0
	// LFCLK running
	CLOCK_LFCLKSTAT_STATE_Running = 0x1

	// LFCLKSRCCOPY: Copy of LFCLKSRC register, set when LFCLKSTART task was triggered
	// Position of SRC field.
	CLOCK_LFCLKSRCCOPY_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSRCCOPY_SRC_Msk = 0x3
	// 32.768 kHz RC oscillator (LFRC)
	CLOCK_LFCLKSRCCOPY_SRC_RC = 0x0
	// 32.768 kHz crystal oscillator (LFXO)
	CLOCK_LFCLKSRCCOPY_SRC_Xtal = 0x1
	// 32.768 kHz synthesized from HFCLK (LFSYNT)
	CLOCK_LFCLKSRCCOPY_SRC_Synth = 0x2

	// LFCLKSRC: Clock source for the LFCLK
	// Position of SRC field.
	CLOCK_LFCLKSRC_SRC_Pos = 0x0
	// Bit mask of SRC field.
	CLOCK_LFCLKSRC_SRC_Msk = 0x3
	// 32.768 kHz RC oscillator (LFRC)
	CLOCK_LFCLKSRC_SRC_RC = 0x0
	// 32.768 kHz crystal oscillator (LFXO)
	CLOCK_LFCLKSRC_SRC_Xtal = 0x1
	// 32.768 kHz synthesized from HFCLK (LFSYNT)
	CLOCK_LFCLKSRC_SRC_Synth = 0x2
	// Position of BYPASS field.
	CLOCK_LFCLKSRC_BYPASS_Pos = 0x10
	// Bit mask of BYPASS field.
	CLOCK_LFCLKSRC_BYPASS_Msk = 0x10000
	// Bit BYPASS.
	CLOCK_LFCLKSRC_BYPASS = 0x10000
	// Disable (use with Xtal or low-swing external source)
	CLOCK_LFCLKSRC_BYPASS_Disabled = 0x0
	// Enable (use with rail-to-rail external source)
	CLOCK_LFCLKSRC_BYPASS_Enabled = 0x1
	// Position of EXTERNAL field.
	CLOCK_LFCLKSRC_EXTERNAL_Pos = 0x11
	// Bit mask of EXTERNAL field.
	CLOCK_LFCLKSRC_EXTERNAL_Msk = 0x20000
	// Bit EXTERNAL.
	CLOCK_LFCLKSRC_EXTERNAL = 0x20000
	// Disable external source (use with Xtal)
	CLOCK_LFCLKSRC_EXTERNAL_Disabled = 0x0
	// Enable use of external source instead of Xtal (SRC needs to be set to Xtal)
	CLOCK_LFCLKSRC_EXTERNAL_Enabled = 0x1

	// HFXODEBOUNCE: HFXO debounce time. The HFXO is started by triggering the TASKS_HFCLKSTART task.
	// Position of HFXODEBOUNCE field.
	CLOCK_HFXODEBOUNCE_HFXODEBOUNCE_Pos = 0x0
	// Bit mask of HFXODEBOUNCE field.
	CLOCK_HFXODEBOUNCE_HFXODEBOUNCE_Msk = 0xff
	// 256 us debounce time. Recommended for 1.6 mm x 2.0 mm crystals and larger.
	CLOCK_HFXODEBOUNCE_HFXODEBOUNCE_Db256us = 0x10
	// 1024 us debounce time. Recommended for 1.6 mm x 1.2 mm crystals and smaller.
	CLOCK_HFXODEBOUNCE_HFXODEBOUNCE_Db1024us = 0x40

	// LFXODEBOUNCE: LFXO debounce time. The LFXO is started by triggering the TASKS_LFCLKSTART task when the LFCLKSRC register is configured for Xtal.
	// Position of LFXODEBOUNCE field.
	CLOCK_LFXODEBOUNCE_LFXODEBOUNCE_Pos = 0x0
	// Bit mask of LFXODEBOUNCE field.
	CLOCK_LFXODEBOUNCE_LFXODEBOUNCE_Msk = 0x1
	// Bit LFXODEBOUNCE.
	CLOCK_LFXODEBOUNCE_LFXODEBOUNCE = 0x1
	// 8192 32.768 kHz periods, or 0.25 s. Recommended for normal Operating Temperature conditions.
	CLOCK_LFXODEBOUNCE_LFXODEBOUNCE_Normal = 0x0
	// 16384 32.768 kHz periods, or 0.5 s. Recommended for Extended Operating Temperature conditions.
	CLOCK_LFXODEBOUNCE_LFXODEBOUNCE_Extended = 0x1

	// CTIV: Calibration timer interval
	// Position of CTIV field.
	CLOCK_CTIV_CTIV_Pos = 0x0
	// Bit mask of CTIV field.
	CLOCK_CTIV_CTIV_Msk = 0x7f

	// TRACECONFIG: Clocking options for the trace port debug interface
	// Position of TRACEPORTSPEED field.
	CLOCK_TRACECONFIG_TRACEPORTSPEED_Pos = 0x0
	// Bit mask of TRACEPORTSPEED field.
	CLOCK_TRACECONFIG_TRACEPORTSPEED_Msk = 0x3
	// 32 MHz trace port clock (TRACECLK = 16 MHz)
	CLOCK_TRACECONFIG_TRACEPORTSPEED_32MHz = 0x0
	// 16 MHz trace port clock (TRACECLK = 8 MHz)
	CLOCK_TRACECONFIG_TRACEPORTSPEED_16MHz = 0x1
	// 8 MHz trace port clock (TRACECLK = 4 MHz)
	CLOCK_TRACECONFIG_TRACEPORTSPEED_8MHz = 0x2
	// 4 MHz trace port clock (TRACECLK = 2 MHz)
	CLOCK_TRACECONFIG_TRACEPORTSPEED_4MHz = 0x3
	// Position of TRACEMUX field.
	CLOCK_TRACECONFIG_TRACEMUX_Pos = 0x10
	// Bit mask of TRACEMUX field.
	CLOCK_TRACECONFIG_TRACEMUX_Msk = 0x30000
	// No trace signals routed to pins. All pins can be used as regular GPIOs.
	CLOCK_TRACECONFIG_TRACEMUX_GPIO = 0x0
	// SWO trace signal routed to pin. Remaining pins can be used as regular GPIOs.
	CLOCK_TRACECONFIG_TRACEMUX_Serial = 0x1
	// All trace signals (TRACECLK and TRACEDATA[n]) routed to pins.
	CLOCK_TRACECONFIG_TRACEMUX_Parallel = 0x2
)

// Constants for POWER: Power control
const (
	// TASKS_CONSTLAT: Enable Constant Latency mode
	// Position of TASKS_CONSTLAT field.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Pos = 0x0
	// Bit mask of TASKS_CONSTLAT field.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Msk = 0x1
	// Bit TASKS_CONSTLAT.
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT = 0x1
	// Trigger task
	POWER_TASKS_CONSTLAT_TASKS_CONSTLAT_Trigger = 0x1

	// TASKS_LOWPWR: Enable Low-power mode (variable latency)
	// Position of TASKS_LOWPWR field.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Pos = 0x0
	// Bit mask of TASKS_LOWPWR field.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Msk = 0x1
	// Bit TASKS_LOWPWR.
	POWER_TASKS_LOWPWR_TASKS_LOWPWR = 0x1
	// Trigger task
	POWER_TASKS_LOWPWR_TASKS_LOWPWR_Trigger = 0x1

	// EVENTS_POFWARN: Power failure warning
	// Position of EVENTS_POFWARN field.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Pos = 0x0
	// Bit mask of EVENTS_POFWARN field.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Msk = 0x1
	// Bit EVENTS_POFWARN.
	POWER_EVENTS_POFWARN_EVENTS_POFWARN = 0x1
	// Event not generated
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_POFWARN_EVENTS_POFWARN_Generated = 0x1

	// EVENTS_SLEEPENTER: CPU entered WFI/WFE sleep
	// Position of EVENTS_SLEEPENTER field.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Pos = 0x0
	// Bit mask of EVENTS_SLEEPENTER field.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Msk = 0x1
	// Bit EVENTS_SLEEPENTER.
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER = 0x1
	// Event not generated
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_SLEEPENTER_EVENTS_SLEEPENTER_Generated = 0x1

	// EVENTS_SLEEPEXIT: CPU exited WFI/WFE sleep
	// Position of EVENTS_SLEEPEXIT field.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Pos = 0x0
	// Bit mask of EVENTS_SLEEPEXIT field.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Msk = 0x1
	// Bit EVENTS_SLEEPEXIT.
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT = 0x1
	// Event not generated
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_SLEEPEXIT_EVENTS_SLEEPEXIT_Generated = 0x1

	// EVENTS_USBDETECTED: Voltage supply detected on VBUS
	// Position of EVENTS_USBDETECTED field.
	POWER_EVENTS_USBDETECTED_EVENTS_USBDETECTED_Pos = 0x0
	// Bit mask of EVENTS_USBDETECTED field.
	POWER_EVENTS_USBDETECTED_EVENTS_USBDETECTED_Msk = 0x1
	// Bit EVENTS_USBDETECTED.
	POWER_EVENTS_USBDETECTED_EVENTS_USBDETECTED = 0x1
	// Event not generated
	POWER_EVENTS_USBDETECTED_EVENTS_USBDETECTED_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_USBDETECTED_EVENTS_USBDETECTED_Generated = 0x1

	// EVENTS_USBREMOVED: Voltage supply removed from VBUS
	// Position of EVENTS_USBREMOVED field.
	POWER_EVENTS_USBREMOVED_EVENTS_USBREMOVED_Pos = 0x0
	// Bit mask of EVENTS_USBREMOVED field.
	POWER_EVENTS_USBREMOVED_EVENTS_USBREMOVED_Msk = 0x1
	// Bit EVENTS_USBREMOVED.
	POWER_EVENTS_USBREMOVED_EVENTS_USBREMOVED = 0x1
	// Event not generated
	POWER_EVENTS_USBREMOVED_EVENTS_USBREMOVED_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_USBREMOVED_EVENTS_USBREMOVED_Generated = 0x1

	// EVENTS_USBPWRRDY: USB 3.3 V supply ready
	// Position of EVENTS_USBPWRRDY field.
	POWER_EVENTS_USBPWRRDY_EVENTS_USBPWRRDY_Pos = 0x0
	// Bit mask of EVENTS_USBPWRRDY field.
	POWER_EVENTS_USBPWRRDY_EVENTS_USBPWRRDY_Msk = 0x1
	// Bit EVENTS_USBPWRRDY.
	POWER_EVENTS_USBPWRRDY_EVENTS_USBPWRRDY = 0x1
	// Event not generated
	POWER_EVENTS_USBPWRRDY_EVENTS_USBPWRRDY_NotGenerated = 0x0
	// Event generated
	POWER_EVENTS_USBPWRRDY_EVENTS_USBPWRRDY_Generated = 0x1

	// INTENSET: Enable interrupt
	// Position of POFWARN field.
	POWER_INTENSET_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTENSET_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTENSET_POFWARN = 0x4
	// Read: Disabled
	POWER_INTENSET_POFWARN_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_POFWARN_Enabled = 0x1
	// Enable
	POWER_INTENSET_POFWARN_Set = 0x1
	// Position of SLEEPENTER field.
	POWER_INTENSET_SLEEPENTER_Pos = 0x5
	// Bit mask of SLEEPENTER field.
	POWER_INTENSET_SLEEPENTER_Msk = 0x20
	// Bit SLEEPENTER.
	POWER_INTENSET_SLEEPENTER = 0x20
	// Read: Disabled
	POWER_INTENSET_SLEEPENTER_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_SLEEPENTER_Enabled = 0x1
	// Enable
	POWER_INTENSET_SLEEPENTER_Set = 0x1
	// Position of SLEEPEXIT field.
	POWER_INTENSET_SLEEPEXIT_Pos = 0x6
	// Bit mask of SLEEPEXIT field.
	POWER_INTENSET_SLEEPEXIT_Msk = 0x40
	// Bit SLEEPEXIT.
	POWER_INTENSET_SLEEPEXIT = 0x40
	// Read: Disabled
	POWER_INTENSET_SLEEPEXIT_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_SLEEPEXIT_Enabled = 0x1
	// Enable
	POWER_INTENSET_SLEEPEXIT_Set = 0x1
	// Position of USBDETECTED field.
	POWER_INTENSET_USBDETECTED_Pos = 0x7
	// Bit mask of USBDETECTED field.
	POWER_INTENSET_USBDETECTED_Msk = 0x80
	// Bit USBDETECTED.
	POWER_INTENSET_USBDETECTED = 0x80
	// Read: Disabled
	POWER_INTENSET_USBDETECTED_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_USBDETECTED_Enabled = 0x1
	// Enable
	POWER_INTENSET_USBDETECTED_Set = 0x1
	// Position of USBREMOVED field.
	POWER_INTENSET_USBREMOVED_Pos = 0x8
	// Bit mask of USBREMOVED field.
	POWER_INTENSET_USBREMOVED_Msk = 0x100
	// Bit USBREMOVED.
	POWER_INTENSET_USBREMOVED = 0x100
	// Read: Disabled
	POWER_INTENSET_USBREMOVED_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_USBREMOVED_Enabled = 0x1
	// Enable
	POWER_INTENSET_USBREMOVED_Set = 0x1
	// Position of USBPWRRDY field.
	POWER_INTENSET_USBPWRRDY_Pos = 0x9
	// Bit mask of USBPWRRDY field.
	POWER_INTENSET_USBPWRRDY_Msk = 0x200
	// Bit USBPWRRDY.
	POWER_INTENSET_USBPWRRDY = 0x200
	// Read: Disabled
	POWER_INTENSET_USBPWRRDY_Disabled = 0x0
	// Read: Enabled
	POWER_INTENSET_USBPWRRDY_Enabled = 0x1
	// Enable
	POWER_INTENSET_USBPWRRDY_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of POFWARN field.
	POWER_INTENCLR_POFWARN_Pos = 0x2
	// Bit mask of POFWARN field.
	POWER_INTENCLR_POFWARN_Msk = 0x4
	// Bit POFWARN.
	POWER_INTENCLR_POFWARN = 0x4
	// Read: Disabled
	POWER_INTENCLR_POFWARN_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_POFWARN_Enabled = 0x1
	// Disable
	POWER_INTENCLR_POFWARN_Clear = 0x1
	// Position of SLEEPENTER field.
	POWER_INTENCLR_SLEEPENTER_Pos = 0x5
	// Bit mask of SLEEPENTER field.
	POWER_INTENCLR_SLEEPENTER_Msk = 0x20
	// Bit SLEEPENTER.
	POWER_INTENCLR_SLEEPENTER = 0x20
	// Read: Disabled
	POWER_INTENCLR_SLEEPENTER_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_SLEEPENTER_Enabled = 0x1
	// Disable
	POWER_INTENCLR_SLEEPENTER_Clear = 0x1
	// Position of SLEEPEXIT field.
	POWER_INTENCLR_SLEEPEXIT_Pos = 0x6
	// Bit mask of SLEEPEXIT field.
	POWER_INTENCLR_SLEEPEXIT_Msk = 0x40
	// Bit SLEEPEXIT.
	POWER_INTENCLR_SLEEPEXIT = 0x40
	// Read: Disabled
	POWER_INTENCLR_SLEEPEXIT_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_SLEEPEXIT_Enabled = 0x1
	// Disable
	POWER_INTENCLR_SLEEPEXIT_Clear = 0x1
	// Position of USBDETECTED field.
	POWER_INTENCLR_USBDETECTED_Pos = 0x7
	// Bit mask of USBDETECTED field.
	POWER_INTENCLR_USBDETECTED_Msk = 0x80
	// Bit USBDETECTED.
	POWER_INTENCLR_USBDETECTED = 0x80
	// Read: Disabled
	POWER_INTENCLR_USBDETECTED_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_USBDETECTED_Enabled = 0x1
	// Disable
	POWER_INTENCLR_USBDETECTED_Clear = 0x1
	// Position of USBREMOVED field.
	POWER_INTENCLR_USBREMOVED_Pos = 0x8
	// Bit mask of USBREMOVED field.
	POWER_INTENCLR_USBREMOVED_Msk = 0x100
	// Bit USBREMOVED.
	POWER_INTENCLR_USBREMOVED = 0x100
	// Read: Disabled
	POWER_INTENCLR_USBREMOVED_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_USBREMOVED_Enabled = 0x1
	// Disable
	POWER_INTENCLR_USBREMOVED_Clear = 0x1
	// Position of USBPWRRDY field.
	POWER_INTENCLR_USBPWRRDY_Pos = 0x9
	// Bit mask of USBPWRRDY field.
	POWER_INTENCLR_USBPWRRDY_Msk = 0x200
	// Bit USBPWRRDY.
	POWER_INTENCLR_USBPWRRDY = 0x200
	// Read: Disabled
	POWER_INTENCLR_USBPWRRDY_Disabled = 0x0
	// Read: Enabled
	POWER_INTENCLR_USBPWRRDY_Enabled = 0x1
	// Disable
	POWER_INTENCLR_USBPWRRDY_Clear = 0x1

	// RESETREAS: Reset reason
	// Position of RESETPIN field.
	POWER_RESETREAS_RESETPIN_Pos = 0x0
	// Bit mask of RESETPIN field.
	POWER_RESETREAS_RESETPIN_Msk = 0x1
	// Bit RESETPIN.
	POWER_RESETREAS_RESETPIN = 0x1
	// Not detected
	POWER_RESETREAS_RESETPIN_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_RESETPIN_Detected = 0x1
	// Position of DOG field.
	POWER_RESETREAS_DOG_Pos = 0x1
	// Bit mask of DOG field.
	POWER_RESETREAS_DOG_Msk = 0x2
	// Bit DOG.
	POWER_RESETREAS_DOG = 0x2
	// Not detected
	POWER_RESETREAS_DOG_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_DOG_Detected = 0x1
	// Position of SREQ field.
	POWER_RESETREAS_SREQ_Pos = 0x2
	// Bit mask of SREQ field.
	POWER_RESETREAS_SREQ_Msk = 0x4
	// Bit SREQ.
	POWER_RESETREAS_SREQ = 0x4
	// Not detected
	POWER_RESETREAS_SREQ_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_SREQ_Detected = 0x1
	// Position of LOCKUP field.
	POWER_RESETREAS_LOCKUP_Pos = 0x3
	// Bit mask of LOCKUP field.
	POWER_RESETREAS_LOCKUP_Msk = 0x8
	// Bit LOCKUP.
	POWER_RESETREAS_LOCKUP = 0x8
	// Not detected
	POWER_RESETREAS_LOCKUP_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_LOCKUP_Detected = 0x1
	// Position of OFF field.
	POWER_RESETREAS_OFF_Pos = 0x10
	// Bit mask of OFF field.
	POWER_RESETREAS_OFF_Msk = 0x10000
	// Bit OFF.
	POWER_RESETREAS_OFF = 0x10000
	// Not detected
	POWER_RESETREAS_OFF_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_OFF_Detected = 0x1
	// Position of LPCOMP field.
	POWER_RESETREAS_LPCOMP_Pos = 0x11
	// Bit mask of LPCOMP field.
	POWER_RESETREAS_LPCOMP_Msk = 0x20000
	// Bit LPCOMP.
	POWER_RESETREAS_LPCOMP = 0x20000
	// Not detected
	POWER_RESETREAS_LPCOMP_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_LPCOMP_Detected = 0x1
	// Position of DIF field.
	POWER_RESETREAS_DIF_Pos = 0x12
	// Bit mask of DIF field.
	POWER_RESETREAS_DIF_Msk = 0x40000
	// Bit DIF.
	POWER_RESETREAS_DIF = 0x40000
	// Not detected
	POWER_RESETREAS_DIF_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_DIF_Detected = 0x1
	// Position of NFC field.
	POWER_RESETREAS_NFC_Pos = 0x13
	// Bit mask of NFC field.
	POWER_RESETREAS_NFC_Msk = 0x80000
	// Bit NFC.
	POWER_RESETREAS_NFC = 0x80000
	// Not detected
	POWER_RESETREAS_NFC_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_NFC_Detected = 0x1
	// Position of VBUS field.
	POWER_RESETREAS_VBUS_Pos = 0x14
	// Bit mask of VBUS field.
	POWER_RESETREAS_VBUS_Msk = 0x100000
	// Bit VBUS.
	POWER_RESETREAS_VBUS = 0x100000
	// Not detected
	POWER_RESETREAS_VBUS_NotDetected = 0x0
	// Detected
	POWER_RESETREAS_VBUS_Detected = 0x1

	// RAMSTATUS: Deprecated register - RAM status register
	// Position of RAMBLOCK0 field.
	POWER_RAMSTATUS_RAMBLOCK0_Pos = 0x0
	// Bit mask of RAMBLOCK0 field.
	POWER_RAMSTATUS_RAMBLOCK0_Msk = 0x1
	// Bit RAMBLOCK0.
	POWER_RAMSTATUS_RAMBLOCK0 = 0x1
	// Off
	POWER_RAMSTATUS_RAMBLOCK0_Off = 0x0
	// On
	POWER_RAMSTATUS_RAMBLOCK0_On = 0x1
	// Position of RAMBLOCK1 field.
	POWER_RAMSTATUS_RAMBLOCK1_Pos = 0x1
	// Bit mask of RAMBLOCK1 field.
	POWER_RAMSTATUS_RAMBLOCK1_Msk = 0x2
	// Bit RAMBLOCK1.
	POWER_RAMSTATUS_RAMBLOCK1 = 0x2
	// Off
	POWER_RAMSTATUS_RAMBLOCK1_Off = 0x0
	// On
	POWER_RAMSTATUS_RAMBLOCK1_On = 0x1
	// Position of RAMBLOCK2 field.
	POWER_RAMSTATUS_RAMBLOCK2_Pos = 0x2
	// Bit mask of RAMBLOCK2 field.
	POWER_RAMSTATUS_RAMBLOCK2_Msk = 0x4
	// Bit RAMBLOCK2.
	POWER_RAMSTATUS_RAMBLOCK2 = 0x4
	// Off
	POWER_RAMSTATUS_RAMBLOCK2_Off = 0x0
	// On
	POWER_RAMSTATUS_RAMBLOCK2_On = 0x1
	// Position of RAMBLOCK3 field.
	POWER_RAMSTATUS_RAMBLOCK3_Pos = 0x3
	// Bit mask of RAMBLOCK3 field.
	POWER_RAMSTATUS_RAMBLOCK3_Msk = 0x8
	// Bit RAMBLOCK3.
	POWER_RAMSTATUS_RAMBLOCK3 = 0x8
	// Off
	POWER_RAMSTATUS_RAMBLOCK3_Off = 0x0
	// On
	POWER_RAMSTATUS_RAMBLOCK3_On = 0x1

	// USBREGSTATUS: USB supply status
	// Position of VBUSDETECT field.
	POWER_USBREGSTATUS_VBUSDETECT_Pos = 0x0
	// Bit mask of VBUSDETECT field.
	POWER_USBREGSTATUS_VBUSDETECT_Msk = 0x1
	// Bit VBUSDETECT.
	POWER_USBREGSTATUS_VBUSDETECT = 0x1
	// VBUS voltage below valid threshold
	POWER_USBREGSTATUS_VBUSDETECT_NoVbus = 0x0
	// VBUS voltage above valid threshold
	POWER_USBREGSTATUS_VBUSDETECT_VbusPresent = 0x1
	// Position of OUTPUTRDY field.
	POWER_USBREGSTATUS_OUTPUTRDY_Pos = 0x1
	// Bit mask of OUTPUTRDY field.
	POWER_USBREGSTATUS_OUTPUTRDY_Msk = 0x2
	// Bit OUTPUTRDY.
	POWER_USBREGSTATUS_OUTPUTRDY = 0x2
	// USBREG output settling time not elapsed
	POWER_USBREGSTATUS_OUTPUTRDY_NotReady = 0x0
	// USBREG output settling time elapsed (same information as USBPWRRDY event)
	POWER_USBREGSTATUS_OUTPUTRDY_Ready = 0x1

	// SYSTEMOFF: System OFF register
	// Position of SYSTEMOFF field.
	POWER_SYSTEMOFF_SYSTEMOFF_Pos = 0x0
	// Bit mask of SYSTEMOFF field.
	POWER_SYSTEMOFF_SYSTEMOFF_Msk = 0x1
	// Bit SYSTEMOFF.
	POWER_SYSTEMOFF_SYSTEMOFF = 0x1
	// Enable System OFF mode
	POWER_SYSTEMOFF_SYSTEMOFF_Enter = 0x1

	// POFCON: Power-fail comparator configuration
	// Position of POF field.
	POWER_POFCON_POF_Pos = 0x0
	// Bit mask of POF field.
	POWER_POFCON_POF_Msk = 0x1
	// Bit POF.
	POWER_POFCON_POF = 0x1
	// Disable
	POWER_POFCON_POF_Disabled = 0x0
	// Enable
	POWER_POFCON_POF_Enabled = 0x1
	// Position of THRESHOLD field.
	POWER_POFCON_THRESHOLD_Pos = 0x1
	// Bit mask of THRESHOLD field.
	POWER_POFCON_THRESHOLD_Msk = 0x1e
	// Set threshold to 1.7 V
	POWER_POFCON_THRESHOLD_V17 = 0x4
	// Set threshold to 1.8 V
	POWER_POFCON_THRESHOLD_V18 = 0x5
	// Set threshold to 1.9 V
	POWER_POFCON_THRESHOLD_V19 = 0x6
	// Set threshold to 2.0 V
	POWER_POFCON_THRESHOLD_V20 = 0x7
	// Set threshold to 2.1 V
	POWER_POFCON_THRESHOLD_V21 = 0x8
	// Set threshold to 2.2 V
	POWER_POFCON_THRESHOLD_V22 = 0x9
	// Set threshold to 2.3 V
	POWER_POFCON_THRESHOLD_V23 = 0xa
	// Set threshold to 2.4 V
	POWER_POFCON_THRESHOLD_V24 = 0xb
	// Set threshold to 2.5 V
	POWER_POFCON_THRESHOLD_V25 = 0xc
	// Set threshold to 2.6 V
	POWER_POFCON_THRESHOLD_V26 = 0xd
	// Set threshold to 2.7 V
	POWER_POFCON_THRESHOLD_V27 = 0xe
	// Set threshold to 2.8 V
	POWER_POFCON_THRESHOLD_V28 = 0xf
	// Position of THRESHOLDVDDH field.
	POWER_POFCON_THRESHOLDVDDH_Pos = 0x8
	// Bit mask of THRESHOLDVDDH field.
	POWER_POFCON_THRESHOLDVDDH_Msk = 0xf00
	// Set threshold to 2.7 V
	POWER_POFCON_THRESHOLDVDDH_V27 = 0x0
	// Set threshold to 2.8 V
	POWER_POFCON_THRESHOLDVDDH_V28 = 0x1
	// Set threshold to 2.9 V
	POWER_POFCON_THRESHOLDVDDH_V29 = 0x2
	// Set threshold to 3.0 V
	POWER_POFCON_THRESHOLDVDDH_V30 = 0x3
	// Set threshold to 3.1 V
	POWER_POFCON_THRESHOLDVDDH_V31 = 0x4
	// Set threshold to 3.2 V
	POWER_POFCON_THRESHOLDVDDH_V32 = 0x5
	// Set threshold to 3.3 V
	POWER_POFCON_THRESHOLDVDDH_V33 = 0x6
	// Set threshold to 3.4 V
	POWER_POFCON_THRESHOLDVDDH_V34 = 0x7
	// Set threshold to 3.5 V
	POWER_POFCON_THRESHOLDVDDH_V35 = 0x8
	// Set threshold to 3.6 V
	POWER_POFCON_THRESHOLDVDDH_V36 = 0x9
	// Set threshold to 3.7 V
	POWER_POFCON_THRESHOLDVDDH_V37 = 0xa
	// Set threshold to 3.8 V
	POWER_POFCON_THRESHOLDVDDH_V38 = 0xb
	// Set threshold to 3.9 V
	POWER_POFCON_THRESHOLDVDDH_V39 = 0xc
	// Set threshold to 4.0 V
	POWER_POFCON_THRESHOLDVDDH_V40 = 0xd
	// Set threshold to 4.1 V
	POWER_POFCON_THRESHOLDVDDH_V41 = 0xe
	// Set threshold to 4.2 V
	POWER_POFCON_THRESHOLDVDDH_V42 = 0xf

	// GPREGRET: General purpose retention register
	// Position of GPREGRET field.
	POWER_GPREGRET_GPREGRET_Pos = 0x0
	// Bit mask of GPREGRET field.
	POWER_GPREGRET_GPREGRET_Msk = 0xff

	// GPREGRET2: General purpose retention register
	// Position of GPREGRET field.
	POWER_GPREGRET2_GPREGRET_Pos = 0x0
	// Bit mask of GPREGRET field.
	POWER_GPREGRET2_GPREGRET_Msk = 0xff

	// DCDCEN: Enable DC/DC converter for REG1 stage
	// Position of DCDCEN field.
	POWER_DCDCEN_DCDCEN_Pos = 0x0
	// Bit mask of DCDCEN field.
	POWER_DCDCEN_DCDCEN_Msk = 0x1
	// Bit DCDCEN.
	POWER_DCDCEN_DCDCEN = 0x1
	// Disable
	POWER_DCDCEN_DCDCEN_Disabled = 0x0
	// Enable
	POWER_DCDCEN_DCDCEN_Enabled = 0x1

	// MAINREGSTATUS: Main supply status
	// Position of MAINREGSTATUS field.
	POWER_MAINREGSTATUS_MAINREGSTATUS_Pos = 0x0
	// Bit mask of MAINREGSTATUS field.
	POWER_MAINREGSTATUS_MAINREGSTATUS_Msk = 0x1
	// Bit MAINREGSTATUS.
	POWER_MAINREGSTATUS_MAINREGSTATUS = 0x1
	// Normal voltage mode. Voltage supplied on VDD.
	POWER_MAINREGSTATUS_MAINREGSTATUS_Normal = 0x0
	// High voltage mode. Voltage supplied on VDDH.
	POWER_MAINREGSTATUS_MAINREGSTATUS_High = 0x1

	// RAM.POWER: Description cluster: RAMn power control register
	// Position of S0POWER field.
	POWER_RAM_POWER_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	POWER_RAM_POWER_S0POWER_Msk = 0x1
	// Bit S0POWER.
	POWER_RAM_POWER_S0POWER = 0x1
	// Off
	POWER_RAM_POWER_S0POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S0POWER_On = 0x1
	// Position of S1POWER field.
	POWER_RAM_POWER_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	POWER_RAM_POWER_S1POWER_Msk = 0x2
	// Bit S1POWER.
	POWER_RAM_POWER_S1POWER = 0x2
	// Off
	POWER_RAM_POWER_S1POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S1POWER_On = 0x1
	// Position of S2POWER field.
	POWER_RAM_POWER_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	POWER_RAM_POWER_S2POWER_Msk = 0x4
	// Bit S2POWER.
	POWER_RAM_POWER_S2POWER = 0x4
	// Off
	POWER_RAM_POWER_S2POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S2POWER_On = 0x1
	// Position of S3POWER field.
	POWER_RAM_POWER_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	POWER_RAM_POWER_S3POWER_Msk = 0x8
	// Bit S3POWER.
	POWER_RAM_POWER_S3POWER = 0x8
	// Off
	POWER_RAM_POWER_S3POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S3POWER_On = 0x1
	// Position of S4POWER field.
	POWER_RAM_POWER_S4POWER_Pos = 0x4
	// Bit mask of S4POWER field.
	POWER_RAM_POWER_S4POWER_Msk = 0x10
	// Bit S4POWER.
	POWER_RAM_POWER_S4POWER = 0x10
	// Off
	POWER_RAM_POWER_S4POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S4POWER_On = 0x1
	// Position of S5POWER field.
	POWER_RAM_POWER_S5POWER_Pos = 0x5
	// Bit mask of S5POWER field.
	POWER_RAM_POWER_S5POWER_Msk = 0x20
	// Bit S5POWER.
	POWER_RAM_POWER_S5POWER = 0x20
	// Off
	POWER_RAM_POWER_S5POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S5POWER_On = 0x1
	// Position of S6POWER field.
	POWER_RAM_POWER_S6POWER_Pos = 0x6
	// Bit mask of S6POWER field.
	POWER_RAM_POWER_S6POWER_Msk = 0x40
	// Bit S6POWER.
	POWER_RAM_POWER_S6POWER = 0x40
	// Off
	POWER_RAM_POWER_S6POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S6POWER_On = 0x1
	// Position of S7POWER field.
	POWER_RAM_POWER_S7POWER_Pos = 0x7
	// Bit mask of S7POWER field.
	POWER_RAM_POWER_S7POWER_Msk = 0x80
	// Bit S7POWER.
	POWER_RAM_POWER_S7POWER = 0x80
	// Off
	POWER_RAM_POWER_S7POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S7POWER_On = 0x1
	// Position of S8POWER field.
	POWER_RAM_POWER_S8POWER_Pos = 0x8
	// Bit mask of S8POWER field.
	POWER_RAM_POWER_S8POWER_Msk = 0x100
	// Bit S8POWER.
	POWER_RAM_POWER_S8POWER = 0x100
	// Off
	POWER_RAM_POWER_S8POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S8POWER_On = 0x1
	// Position of S9POWER field.
	POWER_RAM_POWER_S9POWER_Pos = 0x9
	// Bit mask of S9POWER field.
	POWER_RAM_POWER_S9POWER_Msk = 0x200
	// Bit S9POWER.
	POWER_RAM_POWER_S9POWER = 0x200
	// Off
	POWER_RAM_POWER_S9POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S9POWER_On = 0x1
	// Position of S10POWER field.
	POWER_RAM_POWER_S10POWER_Pos = 0xa
	// Bit mask of S10POWER field.
	POWER_RAM_POWER_S10POWER_Msk = 0x400
	// Bit S10POWER.
	POWER_RAM_POWER_S10POWER = 0x400
	// Off
	POWER_RAM_POWER_S10POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S10POWER_On = 0x1
	// Position of S11POWER field.
	POWER_RAM_POWER_S11POWER_Pos = 0xb
	// Bit mask of S11POWER field.
	POWER_RAM_POWER_S11POWER_Msk = 0x800
	// Bit S11POWER.
	POWER_RAM_POWER_S11POWER = 0x800
	// Off
	POWER_RAM_POWER_S11POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S11POWER_On = 0x1
	// Position of S12POWER field.
	POWER_RAM_POWER_S12POWER_Pos = 0xc
	// Bit mask of S12POWER field.
	POWER_RAM_POWER_S12POWER_Msk = 0x1000
	// Bit S12POWER.
	POWER_RAM_POWER_S12POWER = 0x1000
	// Off
	POWER_RAM_POWER_S12POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S12POWER_On = 0x1
	// Position of S13POWER field.
	POWER_RAM_POWER_S13POWER_Pos = 0xd
	// Bit mask of S13POWER field.
	POWER_RAM_POWER_S13POWER_Msk = 0x2000
	// Bit S13POWER.
	POWER_RAM_POWER_S13POWER = 0x2000
	// Off
	POWER_RAM_POWER_S13POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S13POWER_On = 0x1
	// Position of S14POWER field.
	POWER_RAM_POWER_S14POWER_Pos = 0xe
	// Bit mask of S14POWER field.
	POWER_RAM_POWER_S14POWER_Msk = 0x4000
	// Bit S14POWER.
	POWER_RAM_POWER_S14POWER = 0x4000
	// Off
	POWER_RAM_POWER_S14POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S14POWER_On = 0x1
	// Position of S15POWER field.
	POWER_RAM_POWER_S15POWER_Pos = 0xf
	// Bit mask of S15POWER field.
	POWER_RAM_POWER_S15POWER_Msk = 0x8000
	// Bit S15POWER.
	POWER_RAM_POWER_S15POWER = 0x8000
	// Off
	POWER_RAM_POWER_S15POWER_Off = 0x0
	// On
	POWER_RAM_POWER_S15POWER_On = 0x1
	// Position of S0RETENTION field.
	POWER_RAM_POWER_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	POWER_RAM_POWER_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	POWER_RAM_POWER_S0RETENTION = 0x10000
	// Off
	POWER_RAM_POWER_S0RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S0RETENTION_On = 0x1
	// Position of S1RETENTION field.
	POWER_RAM_POWER_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	POWER_RAM_POWER_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	POWER_RAM_POWER_S1RETENTION = 0x20000
	// Off
	POWER_RAM_POWER_S1RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S1RETENTION_On = 0x1
	// Position of S2RETENTION field.
	POWER_RAM_POWER_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	POWER_RAM_POWER_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	POWER_RAM_POWER_S2RETENTION = 0x40000
	// Off
	POWER_RAM_POWER_S2RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S2RETENTION_On = 0x1
	// Position of S3RETENTION field.
	POWER_RAM_POWER_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	POWER_RAM_POWER_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	POWER_RAM_POWER_S3RETENTION = 0x80000
	// Off
	POWER_RAM_POWER_S3RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S3RETENTION_On = 0x1
	// Position of S4RETENTION field.
	POWER_RAM_POWER_S4RETENTION_Pos = 0x14
	// Bit mask of S4RETENTION field.
	POWER_RAM_POWER_S4RETENTION_Msk = 0x100000
	// Bit S4RETENTION.
	POWER_RAM_POWER_S4RETENTION = 0x100000
	// Off
	POWER_RAM_POWER_S4RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S4RETENTION_On = 0x1
	// Position of S5RETENTION field.
	POWER_RAM_POWER_S5RETENTION_Pos = 0x15
	// Bit mask of S5RETENTION field.
	POWER_RAM_POWER_S5RETENTION_Msk = 0x200000
	// Bit S5RETENTION.
	POWER_RAM_POWER_S5RETENTION = 0x200000
	// Off
	POWER_RAM_POWER_S5RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S5RETENTION_On = 0x1
	// Position of S6RETENTION field.
	POWER_RAM_POWER_S6RETENTION_Pos = 0x16
	// Bit mask of S6RETENTION field.
	POWER_RAM_POWER_S6RETENTION_Msk = 0x400000
	// Bit S6RETENTION.
	POWER_RAM_POWER_S6RETENTION = 0x400000
	// Off
	POWER_RAM_POWER_S6RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S6RETENTION_On = 0x1
	// Position of S7RETENTION field.
	POWER_RAM_POWER_S7RETENTION_Pos = 0x17
	// Bit mask of S7RETENTION field.
	POWER_RAM_POWER_S7RETENTION_Msk = 0x800000
	// Bit S7RETENTION.
	POWER_RAM_POWER_S7RETENTION = 0x800000
	// Off
	POWER_RAM_POWER_S7RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S7RETENTION_On = 0x1
	// Position of S8RETENTION field.
	POWER_RAM_POWER_S8RETENTION_Pos = 0x18
	// Bit mask of S8RETENTION field.
	POWER_RAM_POWER_S8RETENTION_Msk = 0x1000000
	// Bit S8RETENTION.
	POWER_RAM_POWER_S8RETENTION = 0x1000000
	// Off
	POWER_RAM_POWER_S8RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S8RETENTION_On = 0x1
	// Position of S9RETENTION field.
	POWER_RAM_POWER_S9RETENTION_Pos = 0x19
	// Bit mask of S9RETENTION field.
	POWER_RAM_POWER_S9RETENTION_Msk = 0x2000000
	// Bit S9RETENTION.
	POWER_RAM_POWER_S9RETENTION = 0x2000000
	// Off
	POWER_RAM_POWER_S9RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S9RETENTION_On = 0x1
	// Position of S10RETENTION field.
	POWER_RAM_POWER_S10RETENTION_Pos = 0x1a
	// Bit mask of S10RETENTION field.
	POWER_RAM_POWER_S10RETENTION_Msk = 0x4000000
	// Bit S10RETENTION.
	POWER_RAM_POWER_S10RETENTION = 0x4000000
	// Off
	POWER_RAM_POWER_S10RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S10RETENTION_On = 0x1
	// Position of S11RETENTION field.
	POWER_RAM_POWER_S11RETENTION_Pos = 0x1b
	// Bit mask of S11RETENTION field.
	POWER_RAM_POWER_S11RETENTION_Msk = 0x8000000
	// Bit S11RETENTION.
	POWER_RAM_POWER_S11RETENTION = 0x8000000
	// Off
	POWER_RAM_POWER_S11RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S11RETENTION_On = 0x1
	// Position of S12RETENTION field.
	POWER_RAM_POWER_S12RETENTION_Pos = 0x1c
	// Bit mask of S12RETENTION field.
	POWER_RAM_POWER_S12RETENTION_Msk = 0x10000000
	// Bit S12RETENTION.
	POWER_RAM_POWER_S12RETENTION = 0x10000000
	// Off
	POWER_RAM_POWER_S12RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S12RETENTION_On = 0x1
	// Position of S13RETENTION field.
	POWER_RAM_POWER_S13RETENTION_Pos = 0x1d
	// Bit mask of S13RETENTION field.
	POWER_RAM_POWER_S13RETENTION_Msk = 0x20000000
	// Bit S13RETENTION.
	POWER_RAM_POWER_S13RETENTION = 0x20000000
	// Off
	POWER_RAM_POWER_S13RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S13RETENTION_On = 0x1
	// Position of S14RETENTION field.
	POWER_RAM_POWER_S14RETENTION_Pos = 0x1e
	// Bit mask of S14RETENTION field.
	POWER_RAM_POWER_S14RETENTION_Msk = 0x40000000
	// Bit S14RETENTION.
	POWER_RAM_POWER_S14RETENTION = 0x40000000
	// Off
	POWER_RAM_POWER_S14RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S14RETENTION_On = 0x1
	// Position of S15RETENTION field.
	POWER_RAM_POWER_S15RETENTION_Pos = 0x1f
	// Bit mask of S15RETENTION field.
	POWER_RAM_POWER_S15RETENTION_Msk = 0x80000000
	// Bit S15RETENTION.
	POWER_RAM_POWER_S15RETENTION = 0x80000000
	// Off
	POWER_RAM_POWER_S15RETENTION_Off = 0x0
	// On
	POWER_RAM_POWER_S15RETENTION_On = 0x1

	// RAM.POWERSET: Description cluster: RAMn power control set register
	// Position of S0POWER field.
	POWER_RAM_POWERSET_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	POWER_RAM_POWERSET_S0POWER_Msk = 0x1
	// Bit S0POWER.
	POWER_RAM_POWERSET_S0POWER = 0x1
	// On
	POWER_RAM_POWERSET_S0POWER_On = 0x1
	// Position of S1POWER field.
	POWER_RAM_POWERSET_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	POWER_RAM_POWERSET_S1POWER_Msk = 0x2
	// Bit S1POWER.
	POWER_RAM_POWERSET_S1POWER = 0x2
	// On
	POWER_RAM_POWERSET_S1POWER_On = 0x1
	// Position of S2POWER field.
	POWER_RAM_POWERSET_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	POWER_RAM_POWERSET_S2POWER_Msk = 0x4
	// Bit S2POWER.
	POWER_RAM_POWERSET_S2POWER = 0x4
	// On
	POWER_RAM_POWERSET_S2POWER_On = 0x1
	// Position of S3POWER field.
	POWER_RAM_POWERSET_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	POWER_RAM_POWERSET_S3POWER_Msk = 0x8
	// Bit S3POWER.
	POWER_RAM_POWERSET_S3POWER = 0x8
	// On
	POWER_RAM_POWERSET_S3POWER_On = 0x1
	// Position of S4POWER field.
	POWER_RAM_POWERSET_S4POWER_Pos = 0x4
	// Bit mask of S4POWER field.
	POWER_RAM_POWERSET_S4POWER_Msk = 0x10
	// Bit S4POWER.
	POWER_RAM_POWERSET_S4POWER = 0x10
	// On
	POWER_RAM_POWERSET_S4POWER_On = 0x1
	// Position of S5POWER field.
	POWER_RAM_POWERSET_S5POWER_Pos = 0x5
	// Bit mask of S5POWER field.
	POWER_RAM_POWERSET_S5POWER_Msk = 0x20
	// Bit S5POWER.
	POWER_RAM_POWERSET_S5POWER = 0x20
	// On
	POWER_RAM_POWERSET_S5POWER_On = 0x1
	// Position of S6POWER field.
	POWER_RAM_POWERSET_S6POWER_Pos = 0x6
	// Bit mask of S6POWER field.
	POWER_RAM_POWERSET_S6POWER_Msk = 0x40
	// Bit S6POWER.
	POWER_RAM_POWERSET_S6POWER = 0x40
	// On
	POWER_RAM_POWERSET_S6POWER_On = 0x1
	// Position of S7POWER field.
	POWER_RAM_POWERSET_S7POWER_Pos = 0x7
	// Bit mask of S7POWER field.
	POWER_RAM_POWERSET_S7POWER_Msk = 0x80
	// Bit S7POWER.
	POWER_RAM_POWERSET_S7POWER = 0x80
	// On
	POWER_RAM_POWERSET_S7POWER_On = 0x1
	// Position of S8POWER field.
	POWER_RAM_POWERSET_S8POWER_Pos = 0x8
	// Bit mask of S8POWER field.
	POWER_RAM_POWERSET_S8POWER_Msk = 0x100
	// Bit S8POWER.
	POWER_RAM_POWERSET_S8POWER = 0x100
	// On
	POWER_RAM_POWERSET_S8POWER_On = 0x1
	// Position of S9POWER field.
	POWER_RAM_POWERSET_S9POWER_Pos = 0x9
	// Bit mask of S9POWER field.
	POWER_RAM_POWERSET_S9POWER_Msk = 0x200
	// Bit S9POWER.
	POWER_RAM_POWERSET_S9POWER = 0x200
	// On
	POWER_RAM_POWERSET_S9POWER_On = 0x1
	// Position of S10POWER field.
	POWER_RAM_POWERSET_S10POWER_Pos = 0xa
	// Bit mask of S10POWER field.
	POWER_RAM_POWERSET_S10POWER_Msk = 0x400
	// Bit S10POWER.
	POWER_RAM_POWERSET_S10POWER = 0x400
	// On
	POWER_RAM_POWERSET_S10POWER_On = 0x1
	// Position of S11POWER field.
	POWER_RAM_POWERSET_S11POWER_Pos = 0xb
	// Bit mask of S11POWER field.
	POWER_RAM_POWERSET_S11POWER_Msk = 0x800
	// Bit S11POWER.
	POWER_RAM_POWERSET_S11POWER = 0x800
	// On
	POWER_RAM_POWERSET_S11POWER_On = 0x1
	// Position of S12POWER field.
	POWER_RAM_POWERSET_S12POWER_Pos = 0xc
	// Bit mask of S12POWER field.
	POWER_RAM_POWERSET_S12POWER_Msk = 0x1000
	// Bit S12POWER.
	POWER_RAM_POWERSET_S12POWER = 0x1000
	// On
	POWER_RAM_POWERSET_S12POWER_On = 0x1
	// Position of S13POWER field.
	POWER_RAM_POWERSET_S13POWER_Pos = 0xd
	// Bit mask of S13POWER field.
	POWER_RAM_POWERSET_S13POWER_Msk = 0x2000
	// Bit S13POWER.
	POWER_RAM_POWERSET_S13POWER = 0x2000
	// On
	POWER_RAM_POWERSET_S13POWER_On = 0x1
	// Position of S14POWER field.
	POWER_RAM_POWERSET_S14POWER_Pos = 0xe
	// Bit mask of S14POWER field.
	POWER_RAM_POWERSET_S14POWER_Msk = 0x4000
	// Bit S14POWER.
	POWER_RAM_POWERSET_S14POWER = 0x4000
	// On
	POWER_RAM_POWERSET_S14POWER_On = 0x1
	// Position of S15POWER field.
	POWER_RAM_POWERSET_S15POWER_Pos = 0xf
	// Bit mask of S15POWER field.
	POWER_RAM_POWERSET_S15POWER_Msk = 0x8000
	// Bit S15POWER.
	POWER_RAM_POWERSET_S15POWER = 0x8000
	// On
	POWER_RAM_POWERSET_S15POWER_On = 0x1
	// Position of S0RETENTION field.
	POWER_RAM_POWERSET_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	POWER_RAM_POWERSET_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	POWER_RAM_POWERSET_S0RETENTION = 0x10000
	// On
	POWER_RAM_POWERSET_S0RETENTION_On = 0x1
	// Position of S1RETENTION field.
	POWER_RAM_POWERSET_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	POWER_RAM_POWERSET_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	POWER_RAM_POWERSET_S1RETENTION = 0x20000
	// On
	POWER_RAM_POWERSET_S1RETENTION_On = 0x1
	// Position of S2RETENTION field.
	POWER_RAM_POWERSET_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	POWER_RAM_POWERSET_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	POWER_RAM_POWERSET_S2RETENTION = 0x40000
	// On
	POWER_RAM_POWERSET_S2RETENTION_On = 0x1
	// Position of S3RETENTION field.
	POWER_RAM_POWERSET_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	POWER_RAM_POWERSET_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	POWER_RAM_POWERSET_S3RETENTION = 0x80000
	// On
	POWER_RAM_POWERSET_S3RETENTION_On = 0x1
	// Position of S4RETENTION field.
	POWER_RAM_POWERSET_S4RETENTION_Pos = 0x14
	// Bit mask of S4RETENTION field.
	POWER_RAM_POWERSET_S4RETENTION_Msk = 0x100000
	// Bit S4RETENTION.
	POWER_RAM_POWERSET_S4RETENTION = 0x100000
	// On
	POWER_RAM_POWERSET_S4RETENTION_On = 0x1
	// Position of S5RETENTION field.
	POWER_RAM_POWERSET_S5RETENTION_Pos = 0x15
	// Bit mask of S5RETENTION field.
	POWER_RAM_POWERSET_S5RETENTION_Msk = 0x200000
	// Bit S5RETENTION.
	POWER_RAM_POWERSET_S5RETENTION = 0x200000
	// On
	POWER_RAM_POWERSET_S5RETENTION_On = 0x1
	// Position of S6RETENTION field.
	POWER_RAM_POWERSET_S6RETENTION_Pos = 0x16
	// Bit mask of S6RETENTION field.
	POWER_RAM_POWERSET_S6RETENTION_Msk = 0x400000
	// Bit S6RETENTION.
	POWER_RAM_POWERSET_S6RETENTION = 0x400000
	// On
	POWER_RAM_POWERSET_S6RETENTION_On = 0x1
	// Position of S7RETENTION field.
	POWER_RAM_POWERSET_S7RETENTION_Pos = 0x17
	// Bit mask of S7RETENTION field.
	POWER_RAM_POWERSET_S7RETENTION_Msk = 0x800000
	// Bit S7RETENTION.
	POWER_RAM_POWERSET_S7RETENTION = 0x800000
	// On
	POWER_RAM_POWERSET_S7RETENTION_On = 0x1
	// Position of S8RETENTION field.
	POWER_RAM_POWERSET_S8RETENTION_Pos = 0x18
	// Bit mask of S8RETENTION field.
	POWER_RAM_POWERSET_S8RETENTION_Msk = 0x1000000
	// Bit S8RETENTION.
	POWER_RAM_POWERSET_S8RETENTION = 0x1000000
	// On
	POWER_RAM_POWERSET_S8RETENTION_On = 0x1
	// Position of S9RETENTION field.
	POWER_RAM_POWERSET_S9RETENTION_Pos = 0x19
	// Bit mask of S9RETENTION field.
	POWER_RAM_POWERSET_S9RETENTION_Msk = 0x2000000
	// Bit S9RETENTION.
	POWER_RAM_POWERSET_S9RETENTION = 0x2000000
	// On
	POWER_RAM_POWERSET_S9RETENTION_On = 0x1
	// Position of S10RETENTION field.
	POWER_RAM_POWERSET_S10RETENTION_Pos = 0x1a
	// Bit mask of S10RETENTION field.
	POWER_RAM_POWERSET_S10RETENTION_Msk = 0x4000000
	// Bit S10RETENTION.
	POWER_RAM_POWERSET_S10RETENTION = 0x4000000
	// On
	POWER_RAM_POWERSET_S10RETENTION_On = 0x1
	// Position of S11RETENTION field.
	POWER_RAM_POWERSET_S11RETENTION_Pos = 0x1b
	// Bit mask of S11RETENTION field.
	POWER_RAM_POWERSET_S11RETENTION_Msk = 0x8000000
	// Bit S11RETENTION.
	POWER_RAM_POWERSET_S11RETENTION = 0x8000000
	// On
	POWER_RAM_POWERSET_S11RETENTION_On = 0x1
	// Position of S12RETENTION field.
	POWER_RAM_POWERSET_S12RETENTION_Pos = 0x1c
	// Bit mask of S12RETENTION field.
	POWER_RAM_POWERSET_S12RETENTION_Msk = 0x10000000
	// Bit S12RETENTION.
	POWER_RAM_POWERSET_S12RETENTION = 0x10000000
	// On
	POWER_RAM_POWERSET_S12RETENTION_On = 0x1
	// Position of S13RETENTION field.
	POWER_RAM_POWERSET_S13RETENTION_Pos = 0x1d
	// Bit mask of S13RETENTION field.
	POWER_RAM_POWERSET_S13RETENTION_Msk = 0x20000000
	// Bit S13RETENTION.
	POWER_RAM_POWERSET_S13RETENTION = 0x20000000
	// On
	POWER_RAM_POWERSET_S13RETENTION_On = 0x1
	// Position of S14RETENTION field.
	POWER_RAM_POWERSET_S14RETENTION_Pos = 0x1e
	// Bit mask of S14RETENTION field.
	POWER_RAM_POWERSET_S14RETENTION_Msk = 0x40000000
	// Bit S14RETENTION.
	POWER_RAM_POWERSET_S14RETENTION = 0x40000000
	// On
	POWER_RAM_POWERSET_S14RETENTION_On = 0x1
	// Position of S15RETENTION field.
	POWER_RAM_POWERSET_S15RETENTION_Pos = 0x1f
	// Bit mask of S15RETENTION field.
	POWER_RAM_POWERSET_S15RETENTION_Msk = 0x80000000
	// Bit S15RETENTION.
	POWER_RAM_POWERSET_S15RETENTION = 0x80000000
	// On
	POWER_RAM_POWERSET_S15RETENTION_On = 0x1

	// RAM.POWERCLR: Description cluster: RAMn power control clear register
	// Position of S0POWER field.
	POWER_RAM_POWERCLR_S0POWER_Pos = 0x0
	// Bit mask of S0POWER field.
	POWER_RAM_POWERCLR_S0POWER_Msk = 0x1
	// Bit S0POWER.
	POWER_RAM_POWERCLR_S0POWER = 0x1
	// Off
	POWER_RAM_POWERCLR_S0POWER_Off = 0x1
	// Position of S1POWER field.
	POWER_RAM_POWERCLR_S1POWER_Pos = 0x1
	// Bit mask of S1POWER field.
	POWER_RAM_POWERCLR_S1POWER_Msk = 0x2
	// Bit S1POWER.
	POWER_RAM_POWERCLR_S1POWER = 0x2
	// Off
	POWER_RAM_POWERCLR_S1POWER_Off = 0x1
	// Position of S2POWER field.
	POWER_RAM_POWERCLR_S2POWER_Pos = 0x2
	// Bit mask of S2POWER field.
	POWER_RAM_POWERCLR_S2POWER_Msk = 0x4
	// Bit S2POWER.
	POWER_RAM_POWERCLR_S2POWER = 0x4
	// Off
	POWER_RAM_POWERCLR_S2POWER_Off = 0x1
	// Position of S3POWER field.
	POWER_RAM_POWERCLR_S3POWER_Pos = 0x3
	// Bit mask of S3POWER field.
	POWER_RAM_POWERCLR_S3POWER_Msk = 0x8
	// Bit S3POWER.
	POWER_RAM_POWERCLR_S3POWER = 0x8
	// Off
	POWER_RAM_POWERCLR_S3POWER_Off = 0x1
	// Position of S4POWER field.
	POWER_RAM_POWERCLR_S4POWER_Pos = 0x4
	// Bit mask of S4POWER field.
	POWER_RAM_POWERCLR_S4POWER_Msk = 0x10
	// Bit S4POWER.
	POWER_RAM_POWERCLR_S4POWER = 0x10
	// Off
	POWER_RAM_POWERCLR_S4POWER_Off = 0x1
	// Position of S5POWER field.
	POWER_RAM_POWERCLR_S5POWER_Pos = 0x5
	// Bit mask of S5POWER field.
	POWER_RAM_POWERCLR_S5POWER_Msk = 0x20
	// Bit S5POWER.
	POWER_RAM_POWERCLR_S5POWER = 0x20
	// Off
	POWER_RAM_POWERCLR_S5POWER_Off = 0x1
	// Position of S6POWER field.
	POWER_RAM_POWERCLR_S6POWER_Pos = 0x6
	// Bit mask of S6POWER field.
	POWER_RAM_POWERCLR_S6POWER_Msk = 0x40
	// Bit S6POWER.
	POWER_RAM_POWERCLR_S6POWER = 0x40
	// Off
	POWER_RAM_POWERCLR_S6POWER_Off = 0x1
	// Position of S7POWER field.
	POWER_RAM_POWERCLR_S7POWER_Pos = 0x7
	// Bit mask of S7POWER field.
	POWER_RAM_POWERCLR_S7POWER_Msk = 0x80
	// Bit S7POWER.
	POWER_RAM_POWERCLR_S7POWER = 0x80
	// Off
	POWER_RAM_POWERCLR_S7POWER_Off = 0x1
	// Position of S8POWER field.
	POWER_RAM_POWERCLR_S8POWER_Pos = 0x8
	// Bit mask of S8POWER field.
	POWER_RAM_POWERCLR_S8POWER_Msk = 0x100
	// Bit S8POWER.
	POWER_RAM_POWERCLR_S8POWER = 0x100
	// Off
	POWER_RAM_POWERCLR_S8POWER_Off = 0x1
	// Position of S9POWER field.
	POWER_RAM_POWERCLR_S9POWER_Pos = 0x9
	// Bit mask of S9POWER field.
	POWER_RAM_POWERCLR_S9POWER_Msk = 0x200
	// Bit S9POWER.
	POWER_RAM_POWERCLR_S9POWER = 0x200
	// Off
	POWER_RAM_POWERCLR_S9POWER_Off = 0x1
	// Position of S10POWER field.
	POWER_RAM_POWERCLR_S10POWER_Pos = 0xa
	// Bit mask of S10POWER field.
	POWER_RAM_POWERCLR_S10POWER_Msk = 0x400
	// Bit S10POWER.
	POWER_RAM_POWERCLR_S10POWER = 0x400
	// Off
	POWER_RAM_POWERCLR_S10POWER_Off = 0x1
	// Position of S11POWER field.
	POWER_RAM_POWERCLR_S11POWER_Pos = 0xb
	// Bit mask of S11POWER field.
	POWER_RAM_POWERCLR_S11POWER_Msk = 0x800
	// Bit S11POWER.
	POWER_RAM_POWERCLR_S11POWER = 0x800
	// Off
	POWER_RAM_POWERCLR_S11POWER_Off = 0x1
	// Position of S12POWER field.
	POWER_RAM_POWERCLR_S12POWER_Pos = 0xc
	// Bit mask of S12POWER field.
	POWER_RAM_POWERCLR_S12POWER_Msk = 0x1000
	// Bit S12POWER.
	POWER_RAM_POWERCLR_S12POWER = 0x1000
	// Off
	POWER_RAM_POWERCLR_S12POWER_Off = 0x1
	// Position of S13POWER field.
	POWER_RAM_POWERCLR_S13POWER_Pos = 0xd
	// Bit mask of S13POWER field.
	POWER_RAM_POWERCLR_S13POWER_Msk = 0x2000
	// Bit S13POWER.
	POWER_RAM_POWERCLR_S13POWER = 0x2000
	// Off
	POWER_RAM_POWERCLR_S13POWER_Off = 0x1
	// Position of S14POWER field.
	POWER_RAM_POWERCLR_S14POWER_Pos = 0xe
	// Bit mask of S14POWER field.
	POWER_RAM_POWERCLR_S14POWER_Msk = 0x4000
	// Bit S14POWER.
	POWER_RAM_POWERCLR_S14POWER = 0x4000
	// Off
	POWER_RAM_POWERCLR_S14POWER_Off = 0x1
	// Position of S15POWER field.
	POWER_RAM_POWERCLR_S15POWER_Pos = 0xf
	// Bit mask of S15POWER field.
	POWER_RAM_POWERCLR_S15POWER_Msk = 0x8000
	// Bit S15POWER.
	POWER_RAM_POWERCLR_S15POWER = 0x8000
	// Off
	POWER_RAM_POWERCLR_S15POWER_Off = 0x1
	// Position of S0RETENTION field.
	POWER_RAM_POWERCLR_S0RETENTION_Pos = 0x10
	// Bit mask of S0RETENTION field.
	POWER_RAM_POWERCLR_S0RETENTION_Msk = 0x10000
	// Bit S0RETENTION.
	POWER_RAM_POWERCLR_S0RETENTION = 0x10000
	// Off
	POWER_RAM_POWERCLR_S0RETENTION_Off = 0x1
	// Position of S1RETENTION field.
	POWER_RAM_POWERCLR_S1RETENTION_Pos = 0x11
	// Bit mask of S1RETENTION field.
	POWER_RAM_POWERCLR_S1RETENTION_Msk = 0x20000
	// Bit S1RETENTION.
	POWER_RAM_POWERCLR_S1RETENTION = 0x20000
	// Off
	POWER_RAM_POWERCLR_S1RETENTION_Off = 0x1
	// Position of S2RETENTION field.
	POWER_RAM_POWERCLR_S2RETENTION_Pos = 0x12
	// Bit mask of S2RETENTION field.
	POWER_RAM_POWERCLR_S2RETENTION_Msk = 0x40000
	// Bit S2RETENTION.
	POWER_RAM_POWERCLR_S2RETENTION = 0x40000
	// Off
	POWER_RAM_POWERCLR_S2RETENTION_Off = 0x1
	// Position of S3RETENTION field.
	POWER_RAM_POWERCLR_S3RETENTION_Pos = 0x13
	// Bit mask of S3RETENTION field.
	POWER_RAM_POWERCLR_S3RETENTION_Msk = 0x80000
	// Bit S3RETENTION.
	POWER_RAM_POWERCLR_S3RETENTION = 0x80000
	// Off
	POWER_RAM_POWERCLR_S3RETENTION_Off = 0x1
	// Position of S4RETENTION field.
	POWER_RAM_POWERCLR_S4RETENTION_Pos = 0x14
	// Bit mask of S4RETENTION field.
	POWER_RAM_POWERCLR_S4RETENTION_Msk = 0x100000
	// Bit S4RETENTION.
	POWER_RAM_POWERCLR_S4RETENTION = 0x100000
	// Off
	POWER_RAM_POWERCLR_S4RETENTION_Off = 0x1
	// Position of S5RETENTION field.
	POWER_RAM_POWERCLR_S5RETENTION_Pos = 0x15
	// Bit mask of S5RETENTION field.
	POWER_RAM_POWERCLR_S5RETENTION_Msk = 0x200000
	// Bit S5RETENTION.
	POWER_RAM_POWERCLR_S5RETENTION = 0x200000
	// Off
	POWER_RAM_POWERCLR_S5RETENTION_Off = 0x1
	// Position of S6RETENTION field.
	POWER_RAM_POWERCLR_S6RETENTION_Pos = 0x16
	// Bit mask of S6RETENTION field.
	POWER_RAM_POWERCLR_S6RETENTION_Msk = 0x400000
	// Bit S6RETENTION.
	POWER_RAM_POWERCLR_S6RETENTION = 0x400000
	// Off
	POWER_RAM_POWERCLR_S6RETENTION_Off = 0x1
	// Position of S7RETENTION field.
	POWER_RAM_POWERCLR_S7RETENTION_Pos = 0x17
	// Bit mask of S7RETENTION field.
	POWER_RAM_POWERCLR_S7RETENTION_Msk = 0x800000
	// Bit S7RETENTION.
	POWER_RAM_POWERCLR_S7RETENTION = 0x800000
	// Off
	POWER_RAM_POWERCLR_S7RETENTION_Off = 0x1
	// Position of S8RETENTION field.
	POWER_RAM_POWERCLR_S8RETENTION_Pos = 0x18
	// Bit mask of S8RETENTION field.
	POWER_RAM_POWERCLR_S8RETENTION_Msk = 0x1000000
	// Bit S8RETENTION.
	POWER_RAM_POWERCLR_S8RETENTION = 0x1000000
	// Off
	POWER_RAM_POWERCLR_S8RETENTION_Off = 0x1
	// Position of S9RETENTION field.
	POWER_RAM_POWERCLR_S9RETENTION_Pos = 0x19
	// Bit mask of S9RETENTION field.
	POWER_RAM_POWERCLR_S9RETENTION_Msk = 0x2000000
	// Bit S9RETENTION.
	POWER_RAM_POWERCLR_S9RETENTION = 0x2000000
	// Off
	POWER_RAM_POWERCLR_S9RETENTION_Off = 0x1
	// Position of S10RETENTION field.
	POWER_RAM_POWERCLR_S10RETENTION_Pos = 0x1a
	// Bit mask of S10RETENTION field.
	POWER_RAM_POWERCLR_S10RETENTION_Msk = 0x4000000
	// Bit S10RETENTION.
	POWER_RAM_POWERCLR_S10RETENTION = 0x4000000
	// Off
	POWER_RAM_POWERCLR_S10RETENTION_Off = 0x1
	// Position of S11RETENTION field.
	POWER_RAM_POWERCLR_S11RETENTION_Pos = 0x1b
	// Bit mask of S11RETENTION field.
	POWER_RAM_POWERCLR_S11RETENTION_Msk = 0x8000000
	// Bit S11RETENTION.
	POWER_RAM_POWERCLR_S11RETENTION = 0x8000000
	// Off
	POWER_RAM_POWERCLR_S11RETENTION_Off = 0x1
	// Position of S12RETENTION field.
	POWER_RAM_POWERCLR_S12RETENTION_Pos = 0x1c
	// Bit mask of S12RETENTION field.
	POWER_RAM_POWERCLR_S12RETENTION_Msk = 0x10000000
	// Bit S12RETENTION.
	POWER_RAM_POWERCLR_S12RETENTION = 0x10000000
	// Off
	POWER_RAM_POWERCLR_S12RETENTION_Off = 0x1
	// Position of S13RETENTION field.
	POWER_RAM_POWERCLR_S13RETENTION_Pos = 0x1d
	// Bit mask of S13RETENTION field.
	POWER_RAM_POWERCLR_S13RETENTION_Msk = 0x20000000
	// Bit S13RETENTION.
	POWER_RAM_POWERCLR_S13RETENTION = 0x20000000
	// Off
	POWER_RAM_POWERCLR_S13RETENTION_Off = 0x1
	// Position of S14RETENTION field.
	POWER_RAM_POWERCLR_S14RETENTION_Pos = 0x1e
	// Bit mask of S14RETENTION field.
	POWER_RAM_POWERCLR_S14RETENTION_Msk = 0x40000000
	// Bit S14RETENTION.
	POWER_RAM_POWERCLR_S14RETENTION = 0x40000000
	// Off
	POWER_RAM_POWERCLR_S14RETENTION_Off = 0x1
	// Position of S15RETENTION field.
	POWER_RAM_POWERCLR_S15RETENTION_Pos = 0x1f
	// Bit mask of S15RETENTION field.
	POWER_RAM_POWERCLR_S15RETENTION_Msk = 0x80000000
	// Bit S15RETENTION.
	POWER_RAM_POWERCLR_S15RETENTION = 0x80000000
	// Off
	POWER_RAM_POWERCLR_S15RETENTION_Off = 0x1
)

// Constants for P0: GPIO Port 1
const (
	// OUT: Write GPIO port
	// Position of PIN0 field.
	GPIO_OUT_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUT_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUT_PIN0 = 0x1
	// Pin driver is low
	GPIO_OUT_PIN0_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN0_High = 0x1
	// Position of PIN1 field.
	GPIO_OUT_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUT_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUT_PIN1 = 0x2
	// Pin driver is low
	GPIO_OUT_PIN1_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN1_High = 0x1
	// Position of PIN2 field.
	GPIO_OUT_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUT_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUT_PIN2 = 0x4
	// Pin driver is low
	GPIO_OUT_PIN2_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN2_High = 0x1
	// Position of PIN3 field.
	GPIO_OUT_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUT_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUT_PIN3 = 0x8
	// Pin driver is low
	GPIO_OUT_PIN3_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN3_High = 0x1
	// Position of PIN4 field.
	GPIO_OUT_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUT_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUT_PIN4 = 0x10
	// Pin driver is low
	GPIO_OUT_PIN4_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN4_High = 0x1
	// Position of PIN5 field.
	GPIO_OUT_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUT_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUT_PIN5 = 0x20
	// Pin driver is low
	GPIO_OUT_PIN5_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN5_High = 0x1
	// Position of PIN6 field.
	GPIO_OUT_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUT_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUT_PIN6 = 0x40
	// Pin driver is low
	GPIO_OUT_PIN6_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN6_High = 0x1
	// Position of PIN7 field.
	GPIO_OUT_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUT_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUT_PIN7 = 0x80
	// Pin driver is low
	GPIO_OUT_PIN7_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN7_High = 0x1
	// Position of PIN8 field.
	GPIO_OUT_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUT_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUT_PIN8 = 0x100
	// Pin driver is low
	GPIO_OUT_PIN8_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN8_High = 0x1
	// Position of PIN9 field.
	GPIO_OUT_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUT_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUT_PIN9 = 0x200
	// Pin driver is low
	GPIO_OUT_PIN9_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN9_High = 0x1
	// Position of PIN10 field.
	GPIO_OUT_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUT_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUT_PIN10 = 0x400
	// Pin driver is low
	GPIO_OUT_PIN10_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN10_High = 0x1
	// Position of PIN11 field.
	GPIO_OUT_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUT_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUT_PIN11 = 0x800
	// Pin driver is low
	GPIO_OUT_PIN11_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN11_High = 0x1
	// Position of PIN12 field.
	GPIO_OUT_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUT_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUT_PIN12 = 0x1000
	// Pin driver is low
	GPIO_OUT_PIN12_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN12_High = 0x1
	// Position of PIN13 field.
	GPIO_OUT_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUT_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUT_PIN13 = 0x2000
	// Pin driver is low
	GPIO_OUT_PIN13_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN13_High = 0x1
	// Position of PIN14 field.
	GPIO_OUT_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUT_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUT_PIN14 = 0x4000
	// Pin driver is low
	GPIO_OUT_PIN14_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN14_High = 0x1
	// Position of PIN15 field.
	GPIO_OUT_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUT_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUT_PIN15 = 0x8000
	// Pin driver is low
	GPIO_OUT_PIN15_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN15_High = 0x1
	// Position of PIN16 field.
	GPIO_OUT_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUT_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUT_PIN16 = 0x10000
	// Pin driver is low
	GPIO_OUT_PIN16_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN16_High = 0x1
	// Position of PIN17 field.
	GPIO_OUT_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUT_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUT_PIN17 = 0x20000
	// Pin driver is low
	GPIO_OUT_PIN17_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN17_High = 0x1
	// Position of PIN18 field.
	GPIO_OUT_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUT_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUT_PIN18 = 0x40000
	// Pin driver is low
	GPIO_OUT_PIN18_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN18_High = 0x1
	// Position of PIN19 field.
	GPIO_OUT_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUT_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUT_PIN19 = 0x80000
	// Pin driver is low
	GPIO_OUT_PIN19_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN19_High = 0x1
	// Position of PIN20 field.
	GPIO_OUT_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUT_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUT_PIN20 = 0x100000
	// Pin driver is low
	GPIO_OUT_PIN20_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN20_High = 0x1
	// Position of PIN21 field.
	GPIO_OUT_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUT_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUT_PIN21 = 0x200000
	// Pin driver is low
	GPIO_OUT_PIN21_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN21_High = 0x1
	// Position of PIN22 field.
	GPIO_OUT_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUT_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUT_PIN22 = 0x400000
	// Pin driver is low
	GPIO_OUT_PIN22_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN22_High = 0x1
	// Position of PIN23 field.
	GPIO_OUT_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUT_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUT_PIN23 = 0x800000
	// Pin driver is low
	GPIO_OUT_PIN23_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN23_High = 0x1
	// Position of PIN24 field.
	GPIO_OUT_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUT_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUT_PIN24 = 0x1000000
	// Pin driver is low
	GPIO_OUT_PIN24_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN24_High = 0x1
	// Position of PIN25 field.
	GPIO_OUT_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUT_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUT_PIN25 = 0x2000000
	// Pin driver is low
	GPIO_OUT_PIN25_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN25_High = 0x1
	// Position of PIN26 field.
	GPIO_OUT_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUT_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUT_PIN26 = 0x4000000
	// Pin driver is low
	GPIO_OUT_PIN26_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN26_High = 0x1
	// Position of PIN27 field.
	GPIO_OUT_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUT_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUT_PIN27 = 0x8000000
	// Pin driver is low
	GPIO_OUT_PIN27_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN27_High = 0x1
	// Position of PIN28 field.
	GPIO_OUT_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUT_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUT_PIN28 = 0x10000000
	// Pin driver is low
	GPIO_OUT_PIN28_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN28_High = 0x1
	// Position of PIN29 field.
	GPIO_OUT_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUT_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUT_PIN29 = 0x20000000
	// Pin driver is low
	GPIO_OUT_PIN29_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN29_High = 0x1
	// Position of PIN30 field.
	GPIO_OUT_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUT_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUT_PIN30 = 0x40000000
	// Pin driver is low
	GPIO_OUT_PIN30_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN30_High = 0x1
	// Position of PIN31 field.
	GPIO_OUT_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUT_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUT_PIN31 = 0x80000000
	// Pin driver is low
	GPIO_OUT_PIN31_Low = 0x0
	// Pin driver is high
	GPIO_OUT_PIN31_High = 0x1

	// OUTSET: Set individual bits in GPIO port
	// Position of PIN0 field.
	GPIO_OUTSET_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUTSET_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUTSET_PIN0 = 0x1
	// Read: pin driver is low
	GPIO_OUTSET_PIN0_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN0_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN0_Set = 0x1
	// Position of PIN1 field.
	GPIO_OUTSET_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUTSET_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUTSET_PIN1 = 0x2
	// Read: pin driver is low
	GPIO_OUTSET_PIN1_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN1_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN1_Set = 0x1
	// Position of PIN2 field.
	GPIO_OUTSET_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUTSET_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUTSET_PIN2 = 0x4
	// Read: pin driver is low
	GPIO_OUTSET_PIN2_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN2_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN2_Set = 0x1
	// Position of PIN3 field.
	GPIO_OUTSET_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUTSET_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUTSET_PIN3 = 0x8
	// Read: pin driver is low
	GPIO_OUTSET_PIN3_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN3_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN3_Set = 0x1
	// Position of PIN4 field.
	GPIO_OUTSET_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUTSET_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUTSET_PIN4 = 0x10
	// Read: pin driver is low
	GPIO_OUTSET_PIN4_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN4_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN4_Set = 0x1
	// Position of PIN5 field.
	GPIO_OUTSET_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUTSET_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUTSET_PIN5 = 0x20
	// Read: pin driver is low
	GPIO_OUTSET_PIN5_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN5_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN5_Set = 0x1
	// Position of PIN6 field.
	GPIO_OUTSET_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUTSET_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUTSET_PIN6 = 0x40
	// Read: pin driver is low
	GPIO_OUTSET_PIN6_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN6_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN6_Set = 0x1
	// Position of PIN7 field.
	GPIO_OUTSET_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUTSET_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUTSET_PIN7 = 0x80
	// Read: pin driver is low
	GPIO_OUTSET_PIN7_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN7_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN7_Set = 0x1
	// Position of PIN8 field.
	GPIO_OUTSET_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUTSET_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUTSET_PIN8 = 0x100
	// Read: pin driver is low
	GPIO_OUTSET_PIN8_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN8_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN8_Set = 0x1
	// Position of PIN9 field.
	GPIO_OUTSET_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUTSET_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUTSET_PIN9 = 0x200
	// Read: pin driver is low
	GPIO_OUTSET_PIN9_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN9_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN9_Set = 0x1
	// Position of PIN10 field.
	GPIO_OUTSET_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUTSET_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUTSET_PIN10 = 0x400
	// Read: pin driver is low
	GPIO_OUTSET_PIN10_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN10_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN10_Set = 0x1
	// Position of PIN11 field.
	GPIO_OUTSET_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUTSET_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUTSET_PIN11 = 0x800
	// Read: pin driver is low
	GPIO_OUTSET_PIN11_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN11_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN11_Set = 0x1
	// Position of PIN12 field.
	GPIO_OUTSET_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUTSET_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUTSET_PIN12 = 0x1000
	// Read: pin driver is low
	GPIO_OUTSET_PIN12_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN12_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN12_Set = 0x1
	// Position of PIN13 field.
	GPIO_OUTSET_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUTSET_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUTSET_PIN13 = 0x2000
	// Read: pin driver is low
	GPIO_OUTSET_PIN13_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN13_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN13_Set = 0x1
	// Position of PIN14 field.
	GPIO_OUTSET_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUTSET_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUTSET_PIN14 = 0x4000
	// Read: pin driver is low
	GPIO_OUTSET_PIN14_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN14_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN14_Set = 0x1
	// Position of PIN15 field.
	GPIO_OUTSET_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUTSET_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUTSET_PIN15 = 0x8000
	// Read: pin driver is low
	GPIO_OUTSET_PIN15_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN15_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN15_Set = 0x1
	// Position of PIN16 field.
	GPIO_OUTSET_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUTSET_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUTSET_PIN16 = 0x10000
	// Read: pin driver is low
	GPIO_OUTSET_PIN16_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN16_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN16_Set = 0x1
	// Position of PIN17 field.
	GPIO_OUTSET_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUTSET_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUTSET_PIN17 = 0x20000
	// Read: pin driver is low
	GPIO_OUTSET_PIN17_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN17_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN17_Set = 0x1
	// Position of PIN18 field.
	GPIO_OUTSET_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUTSET_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUTSET_PIN18 = 0x40000
	// Read: pin driver is low
	GPIO_OUTSET_PIN18_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN18_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN18_Set = 0x1
	// Position of PIN19 field.
	GPIO_OUTSET_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUTSET_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUTSET_PIN19 = 0x80000
	// Read: pin driver is low
	GPIO_OUTSET_PIN19_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN19_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN19_Set = 0x1
	// Position of PIN20 field.
	GPIO_OUTSET_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUTSET_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUTSET_PIN20 = 0x100000
	// Read: pin driver is low
	GPIO_OUTSET_PIN20_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN20_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN20_Set = 0x1
	// Position of PIN21 field.
	GPIO_OUTSET_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUTSET_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUTSET_PIN21 = 0x200000
	// Read: pin driver is low
	GPIO_OUTSET_PIN21_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN21_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN21_Set = 0x1
	// Position of PIN22 field.
	GPIO_OUTSET_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUTSET_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUTSET_PIN22 = 0x400000
	// Read: pin driver is low
	GPIO_OUTSET_PIN22_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN22_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN22_Set = 0x1
	// Position of PIN23 field.
	GPIO_OUTSET_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUTSET_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUTSET_PIN23 = 0x800000
	// Read: pin driver is low
	GPIO_OUTSET_PIN23_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN23_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN23_Set = 0x1
	// Position of PIN24 field.
	GPIO_OUTSET_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUTSET_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUTSET_PIN24 = 0x1000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN24_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN24_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN24_Set = 0x1
	// Position of PIN25 field.
	GPIO_OUTSET_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUTSET_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUTSET_PIN25 = 0x2000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN25_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN25_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN25_Set = 0x1
	// Position of PIN26 field.
	GPIO_OUTSET_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUTSET_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUTSET_PIN26 = 0x4000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN26_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN26_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN26_Set = 0x1
	// Position of PIN27 field.
	GPIO_OUTSET_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUTSET_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUTSET_PIN27 = 0x8000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN27_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN27_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN27_Set = 0x1
	// Position of PIN28 field.
	GPIO_OUTSET_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUTSET_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUTSET_PIN28 = 0x10000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN28_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN28_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN28_Set = 0x1
	// Position of PIN29 field.
	GPIO_OUTSET_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUTSET_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUTSET_PIN29 = 0x20000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN29_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN29_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN29_Set = 0x1
	// Position of PIN30 field.
	GPIO_OUTSET_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUTSET_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUTSET_PIN30 = 0x40000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN30_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN30_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN30_Set = 0x1
	// Position of PIN31 field.
	GPIO_OUTSET_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUTSET_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUTSET_PIN31 = 0x80000000
	// Read: pin driver is low
	GPIO_OUTSET_PIN31_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTSET_PIN31_High = 0x1
	// Write: writing a '1' sets the pin high; writing a '0' has no effect
	GPIO_OUTSET_PIN31_Set = 0x1

	// OUTCLR: Clear individual bits in GPIO port
	// Position of PIN0 field.
	GPIO_OUTCLR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_OUTCLR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_OUTCLR_PIN0 = 0x1
	// Read: pin driver is low
	GPIO_OUTCLR_PIN0_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN0_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN0_Clear = 0x1
	// Position of PIN1 field.
	GPIO_OUTCLR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_OUTCLR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_OUTCLR_PIN1 = 0x2
	// Read: pin driver is low
	GPIO_OUTCLR_PIN1_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN1_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN1_Clear = 0x1
	// Position of PIN2 field.
	GPIO_OUTCLR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_OUTCLR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_OUTCLR_PIN2 = 0x4
	// Read: pin driver is low
	GPIO_OUTCLR_PIN2_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN2_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN2_Clear = 0x1
	// Position of PIN3 field.
	GPIO_OUTCLR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_OUTCLR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_OUTCLR_PIN3 = 0x8
	// Read: pin driver is low
	GPIO_OUTCLR_PIN3_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN3_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN3_Clear = 0x1
	// Position of PIN4 field.
	GPIO_OUTCLR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_OUTCLR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_OUTCLR_PIN4 = 0x10
	// Read: pin driver is low
	GPIO_OUTCLR_PIN4_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN4_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN4_Clear = 0x1
	// Position of PIN5 field.
	GPIO_OUTCLR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_OUTCLR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_OUTCLR_PIN5 = 0x20
	// Read: pin driver is low
	GPIO_OUTCLR_PIN5_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN5_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN5_Clear = 0x1
	// Position of PIN6 field.
	GPIO_OUTCLR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_OUTCLR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_OUTCLR_PIN6 = 0x40
	// Read: pin driver is low
	GPIO_OUTCLR_PIN6_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN6_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN6_Clear = 0x1
	// Position of PIN7 field.
	GPIO_OUTCLR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_OUTCLR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_OUTCLR_PIN7 = 0x80
	// Read: pin driver is low
	GPIO_OUTCLR_PIN7_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN7_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN7_Clear = 0x1
	// Position of PIN8 field.
	GPIO_OUTCLR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_OUTCLR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_OUTCLR_PIN8 = 0x100
	// Read: pin driver is low
	GPIO_OUTCLR_PIN8_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN8_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN8_Clear = 0x1
	// Position of PIN9 field.
	GPIO_OUTCLR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_OUTCLR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_OUTCLR_PIN9 = 0x200
	// Read: pin driver is low
	GPIO_OUTCLR_PIN9_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN9_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN9_Clear = 0x1
	// Position of PIN10 field.
	GPIO_OUTCLR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_OUTCLR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_OUTCLR_PIN10 = 0x400
	// Read: pin driver is low
	GPIO_OUTCLR_PIN10_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN10_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN10_Clear = 0x1
	// Position of PIN11 field.
	GPIO_OUTCLR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_OUTCLR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_OUTCLR_PIN11 = 0x800
	// Read: pin driver is low
	GPIO_OUTCLR_PIN11_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN11_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN11_Clear = 0x1
	// Position of PIN12 field.
	GPIO_OUTCLR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_OUTCLR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_OUTCLR_PIN12 = 0x1000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN12_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN12_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN12_Clear = 0x1
	// Position of PIN13 field.
	GPIO_OUTCLR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_OUTCLR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_OUTCLR_PIN13 = 0x2000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN13_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN13_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN13_Clear = 0x1
	// Position of PIN14 field.
	GPIO_OUTCLR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_OUTCLR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_OUTCLR_PIN14 = 0x4000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN14_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN14_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN14_Clear = 0x1
	// Position of PIN15 field.
	GPIO_OUTCLR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_OUTCLR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_OUTCLR_PIN15 = 0x8000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN15_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN15_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN15_Clear = 0x1
	// Position of PIN16 field.
	GPIO_OUTCLR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_OUTCLR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_OUTCLR_PIN16 = 0x10000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN16_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN16_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN16_Clear = 0x1
	// Position of PIN17 field.
	GPIO_OUTCLR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_OUTCLR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_OUTCLR_PIN17 = 0x20000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN17_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN17_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN17_Clear = 0x1
	// Position of PIN18 field.
	GPIO_OUTCLR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_OUTCLR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_OUTCLR_PIN18 = 0x40000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN18_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN18_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN18_Clear = 0x1
	// Position of PIN19 field.
	GPIO_OUTCLR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_OUTCLR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_OUTCLR_PIN19 = 0x80000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN19_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN19_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN19_Clear = 0x1
	// Position of PIN20 field.
	GPIO_OUTCLR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_OUTCLR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_OUTCLR_PIN20 = 0x100000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN20_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN20_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN20_Clear = 0x1
	// Position of PIN21 field.
	GPIO_OUTCLR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_OUTCLR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_OUTCLR_PIN21 = 0x200000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN21_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN21_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN21_Clear = 0x1
	// Position of PIN22 field.
	GPIO_OUTCLR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_OUTCLR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_OUTCLR_PIN22 = 0x400000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN22_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN22_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN22_Clear = 0x1
	// Position of PIN23 field.
	GPIO_OUTCLR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_OUTCLR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_OUTCLR_PIN23 = 0x800000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN23_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN23_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN23_Clear = 0x1
	// Position of PIN24 field.
	GPIO_OUTCLR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_OUTCLR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_OUTCLR_PIN24 = 0x1000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN24_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN24_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN24_Clear = 0x1
	// Position of PIN25 field.
	GPIO_OUTCLR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_OUTCLR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_OUTCLR_PIN25 = 0x2000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN25_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN25_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN25_Clear = 0x1
	// Position of PIN26 field.
	GPIO_OUTCLR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_OUTCLR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_OUTCLR_PIN26 = 0x4000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN26_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN26_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN26_Clear = 0x1
	// Position of PIN27 field.
	GPIO_OUTCLR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_OUTCLR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_OUTCLR_PIN27 = 0x8000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN27_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN27_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN27_Clear = 0x1
	// Position of PIN28 field.
	GPIO_OUTCLR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_OUTCLR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_OUTCLR_PIN28 = 0x10000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN28_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN28_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN28_Clear = 0x1
	// Position of PIN29 field.
	GPIO_OUTCLR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_OUTCLR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_OUTCLR_PIN29 = 0x20000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN29_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN29_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN29_Clear = 0x1
	// Position of PIN30 field.
	GPIO_OUTCLR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_OUTCLR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_OUTCLR_PIN30 = 0x40000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN30_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN30_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN30_Clear = 0x1
	// Position of PIN31 field.
	GPIO_OUTCLR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_OUTCLR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_OUTCLR_PIN31 = 0x80000000
	// Read: pin driver is low
	GPIO_OUTCLR_PIN31_Low = 0x0
	// Read: pin driver is high
	GPIO_OUTCLR_PIN31_High = 0x1
	// Write: writing a '1' sets the pin low; writing a '0' has no effect
	GPIO_OUTCLR_PIN31_Clear = 0x1

	// IN: Read GPIO port
	// Position of PIN0 field.
	GPIO_IN_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_IN_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_IN_PIN0 = 0x1
	// Pin input is low
	GPIO_IN_PIN0_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN0_High = 0x1
	// Position of PIN1 field.
	GPIO_IN_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_IN_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_IN_PIN1 = 0x2
	// Pin input is low
	GPIO_IN_PIN1_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN1_High = 0x1
	// Position of PIN2 field.
	GPIO_IN_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_IN_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_IN_PIN2 = 0x4
	// Pin input is low
	GPIO_IN_PIN2_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN2_High = 0x1
	// Position of PIN3 field.
	GPIO_IN_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_IN_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_IN_PIN3 = 0x8
	// Pin input is low
	GPIO_IN_PIN3_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN3_High = 0x1
	// Position of PIN4 field.
	GPIO_IN_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_IN_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_IN_PIN4 = 0x10
	// Pin input is low
	GPIO_IN_PIN4_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN4_High = 0x1
	// Position of PIN5 field.
	GPIO_IN_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_IN_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_IN_PIN5 = 0x20
	// Pin input is low
	GPIO_IN_PIN5_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN5_High = 0x1
	// Position of PIN6 field.
	GPIO_IN_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_IN_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_IN_PIN6 = 0x40
	// Pin input is low
	GPIO_IN_PIN6_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN6_High = 0x1
	// Position of PIN7 field.
	GPIO_IN_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_IN_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_IN_PIN7 = 0x80
	// Pin input is low
	GPIO_IN_PIN7_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN7_High = 0x1
	// Position of PIN8 field.
	GPIO_IN_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_IN_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_IN_PIN8 = 0x100
	// Pin input is low
	GPIO_IN_PIN8_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN8_High = 0x1
	// Position of PIN9 field.
	GPIO_IN_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_IN_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_IN_PIN9 = 0x200
	// Pin input is low
	GPIO_IN_PIN9_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN9_High = 0x1
	// Position of PIN10 field.
	GPIO_IN_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_IN_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_IN_PIN10 = 0x400
	// Pin input is low
	GPIO_IN_PIN10_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN10_High = 0x1
	// Position of PIN11 field.
	GPIO_IN_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_IN_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_IN_PIN11 = 0x800
	// Pin input is low
	GPIO_IN_PIN11_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN11_High = 0x1
	// Position of PIN12 field.
	GPIO_IN_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_IN_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_IN_PIN12 = 0x1000
	// Pin input is low
	GPIO_IN_PIN12_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN12_High = 0x1
	// Position of PIN13 field.
	GPIO_IN_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_IN_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_IN_PIN13 = 0x2000
	// Pin input is low
	GPIO_IN_PIN13_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN13_High = 0x1
	// Position of PIN14 field.
	GPIO_IN_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_IN_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_IN_PIN14 = 0x4000
	// Pin input is low
	GPIO_IN_PIN14_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN14_High = 0x1
	// Position of PIN15 field.
	GPIO_IN_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_IN_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_IN_PIN15 = 0x8000
	// Pin input is low
	GPIO_IN_PIN15_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN15_High = 0x1
	// Position of PIN16 field.
	GPIO_IN_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_IN_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_IN_PIN16 = 0x10000
	// Pin input is low
	GPIO_IN_PIN16_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN16_High = 0x1
	// Position of PIN17 field.
	GPIO_IN_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_IN_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_IN_PIN17 = 0x20000
	// Pin input is low
	GPIO_IN_PIN17_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN17_High = 0x1
	// Position of PIN18 field.
	GPIO_IN_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_IN_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_IN_PIN18 = 0x40000
	// Pin input is low
	GPIO_IN_PIN18_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN18_High = 0x1
	// Position of PIN19 field.
	GPIO_IN_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_IN_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_IN_PIN19 = 0x80000
	// Pin input is low
	GPIO_IN_PIN19_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN19_High = 0x1
	// Position of PIN20 field.
	GPIO_IN_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_IN_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_IN_PIN20 = 0x100000
	// Pin input is low
	GPIO_IN_PIN20_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN20_High = 0x1
	// Position of PIN21 field.
	GPIO_IN_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_IN_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_IN_PIN21 = 0x200000
	// Pin input is low
	GPIO_IN_PIN21_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN21_High = 0x1
	// Position of PIN22 field.
	GPIO_IN_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_IN_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_IN_PIN22 = 0x400000
	// Pin input is low
	GPIO_IN_PIN22_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN22_High = 0x1
	// Position of PIN23 field.
	GPIO_IN_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_IN_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_IN_PIN23 = 0x800000
	// Pin input is low
	GPIO_IN_PIN23_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN23_High = 0x1
	// Position of PIN24 field.
	GPIO_IN_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_IN_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_IN_PIN24 = 0x1000000
	// Pin input is low
	GPIO_IN_PIN24_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN24_High = 0x1
	// Position of PIN25 field.
	GPIO_IN_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_IN_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_IN_PIN25 = 0x2000000
	// Pin input is low
	GPIO_IN_PIN25_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN25_High = 0x1
	// Position of PIN26 field.
	GPIO_IN_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_IN_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_IN_PIN26 = 0x4000000
	// Pin input is low
	GPIO_IN_PIN26_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN26_High = 0x1
	// Position of PIN27 field.
	GPIO_IN_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_IN_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_IN_PIN27 = 0x8000000
	// Pin input is low
	GPIO_IN_PIN27_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN27_High = 0x1
	// Position of PIN28 field.
	GPIO_IN_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_IN_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_IN_PIN28 = 0x10000000
	// Pin input is low
	GPIO_IN_PIN28_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN28_High = 0x1
	// Position of PIN29 field.
	GPIO_IN_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_IN_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_IN_PIN29 = 0x20000000
	// Pin input is low
	GPIO_IN_PIN29_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN29_High = 0x1
	// Position of PIN30 field.
	GPIO_IN_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_IN_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_IN_PIN30 = 0x40000000
	// Pin input is low
	GPIO_IN_PIN30_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN30_High = 0x1
	// Position of PIN31 field.
	GPIO_IN_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_IN_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_IN_PIN31 = 0x80000000
	// Pin input is low
	GPIO_IN_PIN31_Low = 0x0
	// Pin input is high
	GPIO_IN_PIN31_High = 0x1

	// DIR: Direction of GPIO pins
	// Position of PIN0 field.
	GPIO_DIR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIR_PIN0 = 0x1
	// Pin set as input
	GPIO_DIR_PIN0_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN0_Output = 0x1
	// Position of PIN1 field.
	GPIO_DIR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIR_PIN1 = 0x2
	// Pin set as input
	GPIO_DIR_PIN1_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN1_Output = 0x1
	// Position of PIN2 field.
	GPIO_DIR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIR_PIN2 = 0x4
	// Pin set as input
	GPIO_DIR_PIN2_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN2_Output = 0x1
	// Position of PIN3 field.
	GPIO_DIR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIR_PIN3 = 0x8
	// Pin set as input
	GPIO_DIR_PIN3_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN3_Output = 0x1
	// Position of PIN4 field.
	GPIO_DIR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIR_PIN4 = 0x10
	// Pin set as input
	GPIO_DIR_PIN4_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN4_Output = 0x1
	// Position of PIN5 field.
	GPIO_DIR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIR_PIN5 = 0x20
	// Pin set as input
	GPIO_DIR_PIN5_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN5_Output = 0x1
	// Position of PIN6 field.
	GPIO_DIR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIR_PIN6 = 0x40
	// Pin set as input
	GPIO_DIR_PIN6_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN6_Output = 0x1
	// Position of PIN7 field.
	GPIO_DIR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIR_PIN7 = 0x80
	// Pin set as input
	GPIO_DIR_PIN7_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN7_Output = 0x1
	// Position of PIN8 field.
	GPIO_DIR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIR_PIN8 = 0x100
	// Pin set as input
	GPIO_DIR_PIN8_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN8_Output = 0x1
	// Position of PIN9 field.
	GPIO_DIR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIR_PIN9 = 0x200
	// Pin set as input
	GPIO_DIR_PIN9_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN9_Output = 0x1
	// Position of PIN10 field.
	GPIO_DIR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIR_PIN10 = 0x400
	// Pin set as input
	GPIO_DIR_PIN10_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN10_Output = 0x1
	// Position of PIN11 field.
	GPIO_DIR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIR_PIN11 = 0x800
	// Pin set as input
	GPIO_DIR_PIN11_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN11_Output = 0x1
	// Position of PIN12 field.
	GPIO_DIR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIR_PIN12 = 0x1000
	// Pin set as input
	GPIO_DIR_PIN12_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN12_Output = 0x1
	// Position of PIN13 field.
	GPIO_DIR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIR_PIN13 = 0x2000
	// Pin set as input
	GPIO_DIR_PIN13_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN13_Output = 0x1
	// Position of PIN14 field.
	GPIO_DIR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIR_PIN14 = 0x4000
	// Pin set as input
	GPIO_DIR_PIN14_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN14_Output = 0x1
	// Position of PIN15 field.
	GPIO_DIR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIR_PIN15 = 0x8000
	// Pin set as input
	GPIO_DIR_PIN15_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN15_Output = 0x1
	// Position of PIN16 field.
	GPIO_DIR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIR_PIN16 = 0x10000
	// Pin set as input
	GPIO_DIR_PIN16_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN16_Output = 0x1
	// Position of PIN17 field.
	GPIO_DIR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIR_PIN17 = 0x20000
	// Pin set as input
	GPIO_DIR_PIN17_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN17_Output = 0x1
	// Position of PIN18 field.
	GPIO_DIR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIR_PIN18 = 0x40000
	// Pin set as input
	GPIO_DIR_PIN18_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN18_Output = 0x1
	// Position of PIN19 field.
	GPIO_DIR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIR_PIN19 = 0x80000
	// Pin set as input
	GPIO_DIR_PIN19_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN19_Output = 0x1
	// Position of PIN20 field.
	GPIO_DIR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIR_PIN20 = 0x100000
	// Pin set as input
	GPIO_DIR_PIN20_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN20_Output = 0x1
	// Position of PIN21 field.
	GPIO_DIR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIR_PIN21 = 0x200000
	// Pin set as input
	GPIO_DIR_PIN21_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN21_Output = 0x1
	// Position of PIN22 field.
	GPIO_DIR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIR_PIN22 = 0x400000
	// Pin set as input
	GPIO_DIR_PIN22_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN22_Output = 0x1
	// Position of PIN23 field.
	GPIO_DIR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIR_PIN23 = 0x800000
	// Pin set as input
	GPIO_DIR_PIN23_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN23_Output = 0x1
	// Position of PIN24 field.
	GPIO_DIR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIR_PIN24 = 0x1000000
	// Pin set as input
	GPIO_DIR_PIN24_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN24_Output = 0x1
	// Position of PIN25 field.
	GPIO_DIR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIR_PIN25 = 0x2000000
	// Pin set as input
	GPIO_DIR_PIN25_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN25_Output = 0x1
	// Position of PIN26 field.
	GPIO_DIR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIR_PIN26 = 0x4000000
	// Pin set as input
	GPIO_DIR_PIN26_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN26_Output = 0x1
	// Position of PIN27 field.
	GPIO_DIR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIR_PIN27 = 0x8000000
	// Pin set as input
	GPIO_DIR_PIN27_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN27_Output = 0x1
	// Position of PIN28 field.
	GPIO_DIR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIR_PIN28 = 0x10000000
	// Pin set as input
	GPIO_DIR_PIN28_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN28_Output = 0x1
	// Position of PIN29 field.
	GPIO_DIR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIR_PIN29 = 0x20000000
	// Pin set as input
	GPIO_DIR_PIN29_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN29_Output = 0x1
	// Position of PIN30 field.
	GPIO_DIR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIR_PIN30 = 0x40000000
	// Pin set as input
	GPIO_DIR_PIN30_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN30_Output = 0x1
	// Position of PIN31 field.
	GPIO_DIR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIR_PIN31 = 0x80000000
	// Pin set as input
	GPIO_DIR_PIN31_Input = 0x0
	// Pin set as output
	GPIO_DIR_PIN31_Output = 0x1

	// DIRSET: DIR set register
	// Position of PIN0 field.
	GPIO_DIRSET_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIRSET_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIRSET_PIN0 = 0x1
	// Read: pin set as input
	GPIO_DIRSET_PIN0_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN0_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN0_Set = 0x1
	// Position of PIN1 field.
	GPIO_DIRSET_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIRSET_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIRSET_PIN1 = 0x2
	// Read: pin set as input
	GPIO_DIRSET_PIN1_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN1_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN1_Set = 0x1
	// Position of PIN2 field.
	GPIO_DIRSET_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIRSET_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIRSET_PIN2 = 0x4
	// Read: pin set as input
	GPIO_DIRSET_PIN2_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN2_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN2_Set = 0x1
	// Position of PIN3 field.
	GPIO_DIRSET_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIRSET_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIRSET_PIN3 = 0x8
	// Read: pin set as input
	GPIO_DIRSET_PIN3_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN3_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN3_Set = 0x1
	// Position of PIN4 field.
	GPIO_DIRSET_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIRSET_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIRSET_PIN4 = 0x10
	// Read: pin set as input
	GPIO_DIRSET_PIN4_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN4_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN4_Set = 0x1
	// Position of PIN5 field.
	GPIO_DIRSET_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIRSET_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIRSET_PIN5 = 0x20
	// Read: pin set as input
	GPIO_DIRSET_PIN5_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN5_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN5_Set = 0x1
	// Position of PIN6 field.
	GPIO_DIRSET_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIRSET_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIRSET_PIN6 = 0x40
	// Read: pin set as input
	GPIO_DIRSET_PIN6_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN6_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN6_Set = 0x1
	// Position of PIN7 field.
	GPIO_DIRSET_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIRSET_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIRSET_PIN7 = 0x80
	// Read: pin set as input
	GPIO_DIRSET_PIN7_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN7_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN7_Set = 0x1
	// Position of PIN8 field.
	GPIO_DIRSET_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIRSET_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIRSET_PIN8 = 0x100
	// Read: pin set as input
	GPIO_DIRSET_PIN8_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN8_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN8_Set = 0x1
	// Position of PIN9 field.
	GPIO_DIRSET_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIRSET_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIRSET_PIN9 = 0x200
	// Read: pin set as input
	GPIO_DIRSET_PIN9_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN9_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN9_Set = 0x1
	// Position of PIN10 field.
	GPIO_DIRSET_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIRSET_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIRSET_PIN10 = 0x400
	// Read: pin set as input
	GPIO_DIRSET_PIN10_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN10_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN10_Set = 0x1
	// Position of PIN11 field.
	GPIO_DIRSET_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIRSET_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIRSET_PIN11 = 0x800
	// Read: pin set as input
	GPIO_DIRSET_PIN11_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN11_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN11_Set = 0x1
	// Position of PIN12 field.
	GPIO_DIRSET_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIRSET_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIRSET_PIN12 = 0x1000
	// Read: pin set as input
	GPIO_DIRSET_PIN12_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN12_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN12_Set = 0x1
	// Position of PIN13 field.
	GPIO_DIRSET_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIRSET_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIRSET_PIN13 = 0x2000
	// Read: pin set as input
	GPIO_DIRSET_PIN13_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN13_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN13_Set = 0x1
	// Position of PIN14 field.
	GPIO_DIRSET_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIRSET_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIRSET_PIN14 = 0x4000
	// Read: pin set as input
	GPIO_DIRSET_PIN14_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN14_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN14_Set = 0x1
	// Position of PIN15 field.
	GPIO_DIRSET_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIRSET_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIRSET_PIN15 = 0x8000
	// Read: pin set as input
	GPIO_DIRSET_PIN15_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN15_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN15_Set = 0x1
	// Position of PIN16 field.
	GPIO_DIRSET_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIRSET_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIRSET_PIN16 = 0x10000
	// Read: pin set as input
	GPIO_DIRSET_PIN16_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN16_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN16_Set = 0x1
	// Position of PIN17 field.
	GPIO_DIRSET_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIRSET_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIRSET_PIN17 = 0x20000
	// Read: pin set as input
	GPIO_DIRSET_PIN17_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN17_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN17_Set = 0x1
	// Position of PIN18 field.
	GPIO_DIRSET_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIRSET_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIRSET_PIN18 = 0x40000
	// Read: pin set as input
	GPIO_DIRSET_PIN18_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN18_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN18_Set = 0x1
	// Position of PIN19 field.
	GPIO_DIRSET_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIRSET_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIRSET_PIN19 = 0x80000
	// Read: pin set as input
	GPIO_DIRSET_PIN19_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN19_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN19_Set = 0x1
	// Position of PIN20 field.
	GPIO_DIRSET_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIRSET_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIRSET_PIN20 = 0x100000
	// Read: pin set as input
	GPIO_DIRSET_PIN20_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN20_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN20_Set = 0x1
	// Position of PIN21 field.
	GPIO_DIRSET_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIRSET_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIRSET_PIN21 = 0x200000
	// Read: pin set as input
	GPIO_DIRSET_PIN21_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN21_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN21_Set = 0x1
	// Position of PIN22 field.
	GPIO_DIRSET_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIRSET_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIRSET_PIN22 = 0x400000
	// Read: pin set as input
	GPIO_DIRSET_PIN22_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN22_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN22_Set = 0x1
	// Position of PIN23 field.
	GPIO_DIRSET_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIRSET_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIRSET_PIN23 = 0x800000
	// Read: pin set as input
	GPIO_DIRSET_PIN23_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN23_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN23_Set = 0x1
	// Position of PIN24 field.
	GPIO_DIRSET_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIRSET_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIRSET_PIN24 = 0x1000000
	// Read: pin set as input
	GPIO_DIRSET_PIN24_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN24_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN24_Set = 0x1
	// Position of PIN25 field.
	GPIO_DIRSET_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIRSET_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIRSET_PIN25 = 0x2000000
	// Read: pin set as input
	GPIO_DIRSET_PIN25_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN25_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN25_Set = 0x1
	// Position of PIN26 field.
	GPIO_DIRSET_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIRSET_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIRSET_PIN26 = 0x4000000
	// Read: pin set as input
	GPIO_DIRSET_PIN26_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN26_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN26_Set = 0x1
	// Position of PIN27 field.
	GPIO_DIRSET_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIRSET_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIRSET_PIN27 = 0x8000000
	// Read: pin set as input
	GPIO_DIRSET_PIN27_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN27_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN27_Set = 0x1
	// Position of PIN28 field.
	GPIO_DIRSET_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIRSET_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIRSET_PIN28 = 0x10000000
	// Read: pin set as input
	GPIO_DIRSET_PIN28_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN28_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN28_Set = 0x1
	// Position of PIN29 field.
	GPIO_DIRSET_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIRSET_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIRSET_PIN29 = 0x20000000
	// Read: pin set as input
	GPIO_DIRSET_PIN29_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN29_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN29_Set = 0x1
	// Position of PIN30 field.
	GPIO_DIRSET_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIRSET_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIRSET_PIN30 = 0x40000000
	// Read: pin set as input
	GPIO_DIRSET_PIN30_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN30_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN30_Set = 0x1
	// Position of PIN31 field.
	GPIO_DIRSET_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIRSET_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIRSET_PIN31 = 0x80000000
	// Read: pin set as input
	GPIO_DIRSET_PIN31_Input = 0x0
	// Read: pin set as output
	GPIO_DIRSET_PIN31_Output = 0x1
	// Write: writing a '1' sets pin to output; writing a '0' has no effect
	GPIO_DIRSET_PIN31_Set = 0x1

	// DIRCLR: DIR clear register
	// Position of PIN0 field.
	GPIO_DIRCLR_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_DIRCLR_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_DIRCLR_PIN0 = 0x1
	// Read: pin set as input
	GPIO_DIRCLR_PIN0_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN0_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN0_Clear = 0x1
	// Position of PIN1 field.
	GPIO_DIRCLR_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_DIRCLR_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_DIRCLR_PIN1 = 0x2
	// Read: pin set as input
	GPIO_DIRCLR_PIN1_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN1_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN1_Clear = 0x1
	// Position of PIN2 field.
	GPIO_DIRCLR_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_DIRCLR_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_DIRCLR_PIN2 = 0x4
	// Read: pin set as input
	GPIO_DIRCLR_PIN2_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN2_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN2_Clear = 0x1
	// Position of PIN3 field.
	GPIO_DIRCLR_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_DIRCLR_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_DIRCLR_PIN3 = 0x8
	// Read: pin set as input
	GPIO_DIRCLR_PIN3_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN3_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN3_Clear = 0x1
	// Position of PIN4 field.
	GPIO_DIRCLR_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_DIRCLR_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_DIRCLR_PIN4 = 0x10
	// Read: pin set as input
	GPIO_DIRCLR_PIN4_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN4_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN4_Clear = 0x1
	// Position of PIN5 field.
	GPIO_DIRCLR_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_DIRCLR_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_DIRCLR_PIN5 = 0x20
	// Read: pin set as input
	GPIO_DIRCLR_PIN5_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN5_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN5_Clear = 0x1
	// Position of PIN6 field.
	GPIO_DIRCLR_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_DIRCLR_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_DIRCLR_PIN6 = 0x40
	// Read: pin set as input
	GPIO_DIRCLR_PIN6_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN6_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN6_Clear = 0x1
	// Position of PIN7 field.
	GPIO_DIRCLR_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_DIRCLR_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_DIRCLR_PIN7 = 0x80
	// Read: pin set as input
	GPIO_DIRCLR_PIN7_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN7_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN7_Clear = 0x1
	// Position of PIN8 field.
	GPIO_DIRCLR_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_DIRCLR_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_DIRCLR_PIN8 = 0x100
	// Read: pin set as input
	GPIO_DIRCLR_PIN8_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN8_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN8_Clear = 0x1
	// Position of PIN9 field.
	GPIO_DIRCLR_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_DIRCLR_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_DIRCLR_PIN9 = 0x200
	// Read: pin set as input
	GPIO_DIRCLR_PIN9_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN9_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN9_Clear = 0x1
	// Position of PIN10 field.
	GPIO_DIRCLR_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_DIRCLR_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_DIRCLR_PIN10 = 0x400
	// Read: pin set as input
	GPIO_DIRCLR_PIN10_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN10_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN10_Clear = 0x1
	// Position of PIN11 field.
	GPIO_DIRCLR_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_DIRCLR_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_DIRCLR_PIN11 = 0x800
	// Read: pin set as input
	GPIO_DIRCLR_PIN11_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN11_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN11_Clear = 0x1
	// Position of PIN12 field.
	GPIO_DIRCLR_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_DIRCLR_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_DIRCLR_PIN12 = 0x1000
	// Read: pin set as input
	GPIO_DIRCLR_PIN12_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN12_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN12_Clear = 0x1
	// Position of PIN13 field.
	GPIO_DIRCLR_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_DIRCLR_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_DIRCLR_PIN13 = 0x2000
	// Read: pin set as input
	GPIO_DIRCLR_PIN13_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN13_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN13_Clear = 0x1
	// Position of PIN14 field.
	GPIO_DIRCLR_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_DIRCLR_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_DIRCLR_PIN14 = 0x4000
	// Read: pin set as input
	GPIO_DIRCLR_PIN14_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN14_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN14_Clear = 0x1
	// Position of PIN15 field.
	GPIO_DIRCLR_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_DIRCLR_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_DIRCLR_PIN15 = 0x8000
	// Read: pin set as input
	GPIO_DIRCLR_PIN15_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN15_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN15_Clear = 0x1
	// Position of PIN16 field.
	GPIO_DIRCLR_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_DIRCLR_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_DIRCLR_PIN16 = 0x10000
	// Read: pin set as input
	GPIO_DIRCLR_PIN16_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN16_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN16_Clear = 0x1
	// Position of PIN17 field.
	GPIO_DIRCLR_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_DIRCLR_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_DIRCLR_PIN17 = 0x20000
	// Read: pin set as input
	GPIO_DIRCLR_PIN17_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN17_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN17_Clear = 0x1
	// Position of PIN18 field.
	GPIO_DIRCLR_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_DIRCLR_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_DIRCLR_PIN18 = 0x40000
	// Read: pin set as input
	GPIO_DIRCLR_PIN18_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN18_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN18_Clear = 0x1
	// Position of PIN19 field.
	GPIO_DIRCLR_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_DIRCLR_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_DIRCLR_PIN19 = 0x80000
	// Read: pin set as input
	GPIO_DIRCLR_PIN19_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN19_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN19_Clear = 0x1
	// Position of PIN20 field.
	GPIO_DIRCLR_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_DIRCLR_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_DIRCLR_PIN20 = 0x100000
	// Read: pin set as input
	GPIO_DIRCLR_PIN20_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN20_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN20_Clear = 0x1
	// Position of PIN21 field.
	GPIO_DIRCLR_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_DIRCLR_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_DIRCLR_PIN21 = 0x200000
	// Read: pin set as input
	GPIO_DIRCLR_PIN21_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN21_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN21_Clear = 0x1
	// Position of PIN22 field.
	GPIO_DIRCLR_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_DIRCLR_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_DIRCLR_PIN22 = 0x400000
	// Read: pin set as input
	GPIO_DIRCLR_PIN22_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN22_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN22_Clear = 0x1
	// Position of PIN23 field.
	GPIO_DIRCLR_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_DIRCLR_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_DIRCLR_PIN23 = 0x800000
	// Read: pin set as input
	GPIO_DIRCLR_PIN23_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN23_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN23_Clear = 0x1
	// Position of PIN24 field.
	GPIO_DIRCLR_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_DIRCLR_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_DIRCLR_PIN24 = 0x1000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN24_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN24_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN24_Clear = 0x1
	// Position of PIN25 field.
	GPIO_DIRCLR_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_DIRCLR_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_DIRCLR_PIN25 = 0x2000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN25_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN25_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN25_Clear = 0x1
	// Position of PIN26 field.
	GPIO_DIRCLR_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_DIRCLR_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_DIRCLR_PIN26 = 0x4000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN26_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN26_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN26_Clear = 0x1
	// Position of PIN27 field.
	GPIO_DIRCLR_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_DIRCLR_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_DIRCLR_PIN27 = 0x8000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN27_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN27_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN27_Clear = 0x1
	// Position of PIN28 field.
	GPIO_DIRCLR_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_DIRCLR_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_DIRCLR_PIN28 = 0x10000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN28_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN28_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN28_Clear = 0x1
	// Position of PIN29 field.
	GPIO_DIRCLR_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_DIRCLR_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_DIRCLR_PIN29 = 0x20000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN29_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN29_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN29_Clear = 0x1
	// Position of PIN30 field.
	GPIO_DIRCLR_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_DIRCLR_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_DIRCLR_PIN30 = 0x40000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN30_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN30_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN30_Clear = 0x1
	// Position of PIN31 field.
	GPIO_DIRCLR_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_DIRCLR_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_DIRCLR_PIN31 = 0x80000000
	// Read: pin set as input
	GPIO_DIRCLR_PIN31_Input = 0x0
	// Read: pin set as output
	GPIO_DIRCLR_PIN31_Output = 0x1
	// Write: writing a '1' sets pin to input; writing a '0' has no effect
	GPIO_DIRCLR_PIN31_Clear = 0x1

	// LATCH: Latch register indicating what GPIO pins that have met the criteria set in the PIN_CNF[n].SENSE registers
	// Position of PIN0 field.
	GPIO_LATCH_PIN0_Pos = 0x0
	// Bit mask of PIN0 field.
	GPIO_LATCH_PIN0_Msk = 0x1
	// Bit PIN0.
	GPIO_LATCH_PIN0 = 0x1
	// Criteria has not been met
	GPIO_LATCH_PIN0_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN0_Latched = 0x1
	// Position of PIN1 field.
	GPIO_LATCH_PIN1_Pos = 0x1
	// Bit mask of PIN1 field.
	GPIO_LATCH_PIN1_Msk = 0x2
	// Bit PIN1.
	GPIO_LATCH_PIN1 = 0x2
	// Criteria has not been met
	GPIO_LATCH_PIN1_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN1_Latched = 0x1
	// Position of PIN2 field.
	GPIO_LATCH_PIN2_Pos = 0x2
	// Bit mask of PIN2 field.
	GPIO_LATCH_PIN2_Msk = 0x4
	// Bit PIN2.
	GPIO_LATCH_PIN2 = 0x4
	// Criteria has not been met
	GPIO_LATCH_PIN2_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN2_Latched = 0x1
	// Position of PIN3 field.
	GPIO_LATCH_PIN3_Pos = 0x3
	// Bit mask of PIN3 field.
	GPIO_LATCH_PIN3_Msk = 0x8
	// Bit PIN3.
	GPIO_LATCH_PIN3 = 0x8
	// Criteria has not been met
	GPIO_LATCH_PIN3_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN3_Latched = 0x1
	// Position of PIN4 field.
	GPIO_LATCH_PIN4_Pos = 0x4
	// Bit mask of PIN4 field.
	GPIO_LATCH_PIN4_Msk = 0x10
	// Bit PIN4.
	GPIO_LATCH_PIN4 = 0x10
	// Criteria has not been met
	GPIO_LATCH_PIN4_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN4_Latched = 0x1
	// Position of PIN5 field.
	GPIO_LATCH_PIN5_Pos = 0x5
	// Bit mask of PIN5 field.
	GPIO_LATCH_PIN5_Msk = 0x20
	// Bit PIN5.
	GPIO_LATCH_PIN5 = 0x20
	// Criteria has not been met
	GPIO_LATCH_PIN5_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN5_Latched = 0x1
	// Position of PIN6 field.
	GPIO_LATCH_PIN6_Pos = 0x6
	// Bit mask of PIN6 field.
	GPIO_LATCH_PIN6_Msk = 0x40
	// Bit PIN6.
	GPIO_LATCH_PIN6 = 0x40
	// Criteria has not been met
	GPIO_LATCH_PIN6_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN6_Latched = 0x1
	// Position of PIN7 field.
	GPIO_LATCH_PIN7_Pos = 0x7
	// Bit mask of PIN7 field.
	GPIO_LATCH_PIN7_Msk = 0x80
	// Bit PIN7.
	GPIO_LATCH_PIN7 = 0x80
	// Criteria has not been met
	GPIO_LATCH_PIN7_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN7_Latched = 0x1
	// Position of PIN8 field.
	GPIO_LATCH_PIN8_Pos = 0x8
	// Bit mask of PIN8 field.
	GPIO_LATCH_PIN8_Msk = 0x100
	// Bit PIN8.
	GPIO_LATCH_PIN8 = 0x100
	// Criteria has not been met
	GPIO_LATCH_PIN8_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN8_Latched = 0x1
	// Position of PIN9 field.
	GPIO_LATCH_PIN9_Pos = 0x9
	// Bit mask of PIN9 field.
	GPIO_LATCH_PIN9_Msk = 0x200
	// Bit PIN9.
	GPIO_LATCH_PIN9 = 0x200
	// Criteria has not been met
	GPIO_LATCH_PIN9_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN9_Latched = 0x1
	// Position of PIN10 field.
	GPIO_LATCH_PIN10_Pos = 0xa
	// Bit mask of PIN10 field.
	GPIO_LATCH_PIN10_Msk = 0x400
	// Bit PIN10.
	GPIO_LATCH_PIN10 = 0x400
	// Criteria has not been met
	GPIO_LATCH_PIN10_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN10_Latched = 0x1
	// Position of PIN11 field.
	GPIO_LATCH_PIN11_Pos = 0xb
	// Bit mask of PIN11 field.
	GPIO_LATCH_PIN11_Msk = 0x800
	// Bit PIN11.
	GPIO_LATCH_PIN11 = 0x800
	// Criteria has not been met
	GPIO_LATCH_PIN11_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN11_Latched = 0x1
	// Position of PIN12 field.
	GPIO_LATCH_PIN12_Pos = 0xc
	// Bit mask of PIN12 field.
	GPIO_LATCH_PIN12_Msk = 0x1000
	// Bit PIN12.
	GPIO_LATCH_PIN12 = 0x1000
	// Criteria has not been met
	GPIO_LATCH_PIN12_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN12_Latched = 0x1
	// Position of PIN13 field.
	GPIO_LATCH_PIN13_Pos = 0xd
	// Bit mask of PIN13 field.
	GPIO_LATCH_PIN13_Msk = 0x2000
	// Bit PIN13.
	GPIO_LATCH_PIN13 = 0x2000
	// Criteria has not been met
	GPIO_LATCH_PIN13_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN13_Latched = 0x1
	// Position of PIN14 field.
	GPIO_LATCH_PIN14_Pos = 0xe
	// Bit mask of PIN14 field.
	GPIO_LATCH_PIN14_Msk = 0x4000
	// Bit PIN14.
	GPIO_LATCH_PIN14 = 0x4000
	// Criteria has not been met
	GPIO_LATCH_PIN14_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN14_Latched = 0x1
	// Position of PIN15 field.
	GPIO_LATCH_PIN15_Pos = 0xf
	// Bit mask of PIN15 field.
	GPIO_LATCH_PIN15_Msk = 0x8000
	// Bit PIN15.
	GPIO_LATCH_PIN15 = 0x8000
	// Criteria has not been met
	GPIO_LATCH_PIN15_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN15_Latched = 0x1
	// Position of PIN16 field.
	GPIO_LATCH_PIN16_Pos = 0x10
	// Bit mask of PIN16 field.
	GPIO_LATCH_PIN16_Msk = 0x10000
	// Bit PIN16.
	GPIO_LATCH_PIN16 = 0x10000
	// Criteria has not been met
	GPIO_LATCH_PIN16_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN16_Latched = 0x1
	// Position of PIN17 field.
	GPIO_LATCH_PIN17_Pos = 0x11
	// Bit mask of PIN17 field.
	GPIO_LATCH_PIN17_Msk = 0x20000
	// Bit PIN17.
	GPIO_LATCH_PIN17 = 0x20000
	// Criteria has not been met
	GPIO_LATCH_PIN17_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN17_Latched = 0x1
	// Position of PIN18 field.
	GPIO_LATCH_PIN18_Pos = 0x12
	// Bit mask of PIN18 field.
	GPIO_LATCH_PIN18_Msk = 0x40000
	// Bit PIN18.
	GPIO_LATCH_PIN18 = 0x40000
	// Criteria has not been met
	GPIO_LATCH_PIN18_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN18_Latched = 0x1
	// Position of PIN19 field.
	GPIO_LATCH_PIN19_Pos = 0x13
	// Bit mask of PIN19 field.
	GPIO_LATCH_PIN19_Msk = 0x80000
	// Bit PIN19.
	GPIO_LATCH_PIN19 = 0x80000
	// Criteria has not been met
	GPIO_LATCH_PIN19_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN19_Latched = 0x1
	// Position of PIN20 field.
	GPIO_LATCH_PIN20_Pos = 0x14
	// Bit mask of PIN20 field.
	GPIO_LATCH_PIN20_Msk = 0x100000
	// Bit PIN20.
	GPIO_LATCH_PIN20 = 0x100000
	// Criteria has not been met
	GPIO_LATCH_PIN20_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN20_Latched = 0x1
	// Position of PIN21 field.
	GPIO_LATCH_PIN21_Pos = 0x15
	// Bit mask of PIN21 field.
	GPIO_LATCH_PIN21_Msk = 0x200000
	// Bit PIN21.
	GPIO_LATCH_PIN21 = 0x200000
	// Criteria has not been met
	GPIO_LATCH_PIN21_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN21_Latched = 0x1
	// Position of PIN22 field.
	GPIO_LATCH_PIN22_Pos = 0x16
	// Bit mask of PIN22 field.
	GPIO_LATCH_PIN22_Msk = 0x400000
	// Bit PIN22.
	GPIO_LATCH_PIN22 = 0x400000
	// Criteria has not been met
	GPIO_LATCH_PIN22_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN22_Latched = 0x1
	// Position of PIN23 field.
	GPIO_LATCH_PIN23_Pos = 0x17
	// Bit mask of PIN23 field.
	GPIO_LATCH_PIN23_Msk = 0x800000
	// Bit PIN23.
	GPIO_LATCH_PIN23 = 0x800000
	// Criteria has not been met
	GPIO_LATCH_PIN23_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN23_Latched = 0x1
	// Position of PIN24 field.
	GPIO_LATCH_PIN24_Pos = 0x18
	// Bit mask of PIN24 field.
	GPIO_LATCH_PIN24_Msk = 0x1000000
	// Bit PIN24.
	GPIO_LATCH_PIN24 = 0x1000000
	// Criteria has not been met
	GPIO_LATCH_PIN24_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN24_Latched = 0x1
	// Position of PIN25 field.
	GPIO_LATCH_PIN25_Pos = 0x19
	// Bit mask of PIN25 field.
	GPIO_LATCH_PIN25_Msk = 0x2000000
	// Bit PIN25.
	GPIO_LATCH_PIN25 = 0x2000000
	// Criteria has not been met
	GPIO_LATCH_PIN25_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN25_Latched = 0x1
	// Position of PIN26 field.
	GPIO_LATCH_PIN26_Pos = 0x1a
	// Bit mask of PIN26 field.
	GPIO_LATCH_PIN26_Msk = 0x4000000
	// Bit PIN26.
	GPIO_LATCH_PIN26 = 0x4000000
	// Criteria has not been met
	GPIO_LATCH_PIN26_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN26_Latched = 0x1
	// Position of PIN27 field.
	GPIO_LATCH_PIN27_Pos = 0x1b
	// Bit mask of PIN27 field.
	GPIO_LATCH_PIN27_Msk = 0x8000000
	// Bit PIN27.
	GPIO_LATCH_PIN27 = 0x8000000
	// Criteria has not been met
	GPIO_LATCH_PIN27_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN27_Latched = 0x1
	// Position of PIN28 field.
	GPIO_LATCH_PIN28_Pos = 0x1c
	// Bit mask of PIN28 field.
	GPIO_LATCH_PIN28_Msk = 0x10000000
	// Bit PIN28.
	GPIO_LATCH_PIN28 = 0x10000000
	// Criteria has not been met
	GPIO_LATCH_PIN28_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN28_Latched = 0x1
	// Position of PIN29 field.
	GPIO_LATCH_PIN29_Pos = 0x1d
	// Bit mask of PIN29 field.
	GPIO_LATCH_PIN29_Msk = 0x20000000
	// Bit PIN29.
	GPIO_LATCH_PIN29 = 0x20000000
	// Criteria has not been met
	GPIO_LATCH_PIN29_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN29_Latched = 0x1
	// Position of PIN30 field.
	GPIO_LATCH_PIN30_Pos = 0x1e
	// Bit mask of PIN30 field.
	GPIO_LATCH_PIN30_Msk = 0x40000000
	// Bit PIN30.
	GPIO_LATCH_PIN30 = 0x40000000
	// Criteria has not been met
	GPIO_LATCH_PIN30_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN30_Latched = 0x1
	// Position of PIN31 field.
	GPIO_LATCH_PIN31_Pos = 0x1f
	// Bit mask of PIN31 field.
	GPIO_LATCH_PIN31_Msk = 0x80000000
	// Bit PIN31.
	GPIO_LATCH_PIN31 = 0x80000000
	// Criteria has not been met
	GPIO_LATCH_PIN31_NotLatched = 0x0
	// Criteria has been met
	GPIO_LATCH_PIN31_Latched = 0x1

	// DETECTMODE: Select between default DETECT signal behaviour and LDETECT mode
	// Position of DETECTMODE field.
	GPIO_DETECTMODE_DETECTMODE_Pos = 0x0
	// Bit mask of DETECTMODE field.
	GPIO_DETECTMODE_DETECTMODE_Msk = 0x1
	// Bit DETECTMODE.
	GPIO_DETECTMODE_DETECTMODE = 0x1
	// DETECT directly connected to PIN DETECT signals
	GPIO_DETECTMODE_DETECTMODE_Default = 0x0
	// Use the latched LDETECT behaviour
	GPIO_DETECTMODE_DETECTMODE_LDETECT = 0x1

	// PIN_CNF: Description collection: Configuration of GPIO pins
	// Position of DIR field.
	GPIO_PIN_CNF_DIR_Pos = 0x0
	// Bit mask of DIR field.
	GPIO_PIN_CNF_DIR_Msk = 0x1
	// Bit DIR.
	GPIO_PIN_CNF_DIR = 0x1
	// Configure pin as an input pin
	GPIO_PIN_CNF_DIR_Input = 0x0
	// Configure pin as an output pin
	GPIO_PIN_CNF_DIR_Output = 0x1
	// Position of INPUT field.
	GPIO_PIN_CNF_INPUT_Pos = 0x1
	// Bit mask of INPUT field.
	GPIO_PIN_CNF_INPUT_Msk = 0x2
	// Bit INPUT.
	GPIO_PIN_CNF_INPUT = 0x2
	// Connect input buffer
	GPIO_PIN_CNF_INPUT_Connect = 0x0
	// Disconnect input buffer
	GPIO_PIN_CNF_INPUT_Disconnect = 0x1
	// Position of PULL field.
	GPIO_PIN_CNF_PULL_Pos = 0x2
	// Bit mask of PULL field.
	GPIO_PIN_CNF_PULL_Msk = 0xc
	// No pull
	GPIO_PIN_CNF_PULL_Disabled = 0x0
	// Pull down on pin
	GPIO_PIN_CNF_PULL_Pulldown = 0x1
	// Pull up on pin
	GPIO_PIN_CNF_PULL_Pullup = 0x3
	// Position of DRIVE field.
	GPIO_PIN_CNF_DRIVE_Pos = 0x8
	// Bit mask of DRIVE field.
	GPIO_PIN_CNF_DRIVE_Msk = 0x700
	// Standard '0', standard '1'
	GPIO_PIN_CNF_DRIVE_S0S1 = 0x0
	// High drive '0', standard '1'
	GPIO_PIN_CNF_DRIVE_H0S1 = 0x1
	// Standard '0', high drive '1'
	GPIO_PIN_CNF_DRIVE_S0H1 = 0x2
	// High drive '0', high 'drive '1''
	GPIO_PIN_CNF_DRIVE_H0H1 = 0x3
	// Disconnect '0' standard '1' (normally used for wired-or connections)
	GPIO_PIN_CNF_DRIVE_D0S1 = 0x4
	// Disconnect '0', high drive '1' (normally used for wired-or connections)
	GPIO_PIN_CNF_DRIVE_D0H1 = 0x5
	// Standard '0'. disconnect '1' (normally used for wired-and connections)
	GPIO_PIN_CNF_DRIVE_S0D1 = 0x6
	// High drive '0', disconnect '1' (normally used for wired-and connections)
	GPIO_PIN_CNF_DRIVE_H0D1 = 0x7
	// Position of SENSE field.
	GPIO_PIN_CNF_SENSE_Pos = 0x10
	// Bit mask of SENSE field.
	GPIO_PIN_CNF_SENSE_Msk = 0x30000
	// Disabled
	GPIO_PIN_CNF_SENSE_Disabled = 0x0
	// Sense for high level
	GPIO_PIN_CNF_SENSE_High = 0x2
	// Sense for low level
	GPIO_PIN_CNF_SENSE_Low = 0x3
)

// Constants for RADIO: 2.4 GHz radio
const (
	// TASKS_TXEN: Enable RADIO in TX mode
	// Position of TASKS_TXEN field.
	RADIO_TASKS_TXEN_TASKS_TXEN_Pos = 0x0
	// Bit mask of TASKS_TXEN field.
	RADIO_TASKS_TXEN_TASKS_TXEN_Msk = 0x1
	// Bit TASKS_TXEN.
	RADIO_TASKS_TXEN_TASKS_TXEN = 0x1
	// Trigger task
	RADIO_TASKS_TXEN_TASKS_TXEN_Trigger = 0x1

	// TASKS_RXEN: Enable RADIO in RX mode
	// Position of TASKS_RXEN field.
	RADIO_TASKS_RXEN_TASKS_RXEN_Pos = 0x0
	// Bit mask of TASKS_RXEN field.
	RADIO_TASKS_RXEN_TASKS_RXEN_Msk = 0x1
	// Bit TASKS_RXEN.
	RADIO_TASKS_RXEN_TASKS_RXEN = 0x1
	// Trigger task
	RADIO_TASKS_RXEN_TASKS_RXEN_Trigger = 0x1

	// TASKS_START: Start RADIO
	// Position of TASKS_START field.
	RADIO_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	RADIO_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	RADIO_TASKS_START_TASKS_START = 0x1
	// Trigger task
	RADIO_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop RADIO
	// Position of TASKS_STOP field.
	RADIO_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	RADIO_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	RADIO_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	RADIO_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_DISABLE: Disable RADIO
	// Position of TASKS_DISABLE field.
	RADIO_TASKS_DISABLE_TASKS_DISABLE_Pos = 0x0
	// Bit mask of TASKS_DISABLE field.
	RADIO_TASKS_DISABLE_TASKS_DISABLE_Msk = 0x1
	// Bit TASKS_DISABLE.
	RADIO_TASKS_DISABLE_TASKS_DISABLE = 0x1
	// Trigger task
	RADIO_TASKS_DISABLE_TASKS_DISABLE_Trigger = 0x1

	// TASKS_RSSISTART: Start the RSSI and take one single sample of the receive signal strength
	// Position of TASKS_RSSISTART field.
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART_Pos = 0x0
	// Bit mask of TASKS_RSSISTART field.
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART_Msk = 0x1
	// Bit TASKS_RSSISTART.
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART = 0x1
	// Trigger task
	RADIO_TASKS_RSSISTART_TASKS_RSSISTART_Trigger = 0x1

	// TASKS_RSSISTOP: Stop the RSSI measurement
	// Position of TASKS_RSSISTOP field.
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP_Pos = 0x0
	// Bit mask of TASKS_RSSISTOP field.
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP_Msk = 0x1
	// Bit TASKS_RSSISTOP.
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP = 0x1
	// Trigger task
	RADIO_TASKS_RSSISTOP_TASKS_RSSISTOP_Trigger = 0x1

	// TASKS_BCSTART: Start the bit counter
	// Position of TASKS_BCSTART field.
	RADIO_TASKS_BCSTART_TASKS_BCSTART_Pos = 0x0
	// Bit mask of TASKS_BCSTART field.
	RADIO_TASKS_BCSTART_TASKS_BCSTART_Msk = 0x1
	// Bit TASKS_BCSTART.
	RADIO_TASKS_BCSTART_TASKS_BCSTART = 0x1
	// Trigger task
	RADIO_TASKS_BCSTART_TASKS_BCSTART_Trigger = 0x1

	// TASKS_BCSTOP: Stop the bit counter
	// Position of TASKS_BCSTOP field.
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP_Pos = 0x0
	// Bit mask of TASKS_BCSTOP field.
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP_Msk = 0x1
	// Bit TASKS_BCSTOP.
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP = 0x1
	// Trigger task
	RADIO_TASKS_BCSTOP_TASKS_BCSTOP_Trigger = 0x1

	// TASKS_EDSTART: Start the energy detect measurement used in IEEE 802.15.4 mode
	// Position of TASKS_EDSTART field.
	RADIO_TASKS_EDSTART_TASKS_EDSTART_Pos = 0x0
	// Bit mask of TASKS_EDSTART field.
	RADIO_TASKS_EDSTART_TASKS_EDSTART_Msk = 0x1
	// Bit TASKS_EDSTART.
	RADIO_TASKS_EDSTART_TASKS_EDSTART = 0x1
	// Trigger task
	RADIO_TASKS_EDSTART_TASKS_EDSTART_Trigger = 0x1

	// TASKS_EDSTOP: Stop the energy detect measurement
	// Position of TASKS_EDSTOP field.
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP_Pos = 0x0
	// Bit mask of TASKS_EDSTOP field.
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP_Msk = 0x1
	// Bit TASKS_EDSTOP.
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP = 0x1
	// Trigger task
	RADIO_TASKS_EDSTOP_TASKS_EDSTOP_Trigger = 0x1

	// TASKS_CCASTART: Start the clear channel assessment used in IEEE 802.15.4 mode
	// Position of TASKS_CCASTART field.
	RADIO_TASKS_CCASTART_TASKS_CCASTART_Pos = 0x0
	// Bit mask of TASKS_CCASTART field.
	RADIO_TASKS_CCASTART_TASKS_CCASTART_Msk = 0x1
	// Bit TASKS_CCASTART.
	RADIO_TASKS_CCASTART_TASKS_CCASTART = 0x1
	// Trigger task
	RADIO_TASKS_CCASTART_TASKS_CCASTART_Trigger = 0x1

	// TASKS_CCASTOP: Stop the clear channel assessment
	// Position of TASKS_CCASTOP field.
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP_Pos = 0x0
	// Bit mask of TASKS_CCASTOP field.
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP_Msk = 0x1
	// Bit TASKS_CCASTOP.
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP = 0x1
	// Trigger task
	RADIO_TASKS_CCASTOP_TASKS_CCASTOP_Trigger = 0x1

	// EVENTS_READY: RADIO has ramped up and is ready to be started
	// Position of EVENTS_READY field.
	RADIO_EVENTS_READY_EVENTS_READY_Pos = 0x0
	// Bit mask of EVENTS_READY field.
	RADIO_EVENTS_READY_EVENTS_READY_Msk = 0x1
	// Bit EVENTS_READY.
	RADIO_EVENTS_READY_EVENTS_READY = 0x1
	// Event not generated
	RADIO_EVENTS_READY_EVENTS_READY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_READY_EVENTS_READY_Generated = 0x1

	// EVENTS_ADDRESS: Address sent or received
	// Position of EVENTS_ADDRESS field.
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_Pos = 0x0
	// Bit mask of EVENTS_ADDRESS field.
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_Msk = 0x1
	// Bit EVENTS_ADDRESS.
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS = 0x1
	// Event not generated
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_ADDRESS_EVENTS_ADDRESS_Generated = 0x1

	// EVENTS_PAYLOAD: Packet payload sent or received
	// Position of EVENTS_PAYLOAD field.
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_Pos = 0x0
	// Bit mask of EVENTS_PAYLOAD field.
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_Msk = 0x1
	// Bit EVENTS_PAYLOAD.
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD = 0x1
	// Event not generated
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_PAYLOAD_EVENTS_PAYLOAD_Generated = 0x1

	// EVENTS_END: Packet sent or received
	// Position of EVENTS_END field.
	RADIO_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	RADIO_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	RADIO_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	RADIO_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_DISABLED: RADIO has been disabled
	// Position of EVENTS_DISABLED field.
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_Pos = 0x0
	// Bit mask of EVENTS_DISABLED field.
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_Msk = 0x1
	// Bit EVENTS_DISABLED.
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED = 0x1
	// Event not generated
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_DISABLED_EVENTS_DISABLED_Generated = 0x1

	// EVENTS_DEVMATCH: A device address match occurred on the last received packet
	// Position of EVENTS_DEVMATCH field.
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_Pos = 0x0
	// Bit mask of EVENTS_DEVMATCH field.
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_Msk = 0x1
	// Bit EVENTS_DEVMATCH.
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH = 0x1
	// Event not generated
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_DEVMATCH_EVENTS_DEVMATCH_Generated = 0x1

	// EVENTS_DEVMISS: No device address match occurred on the last received packet
	// Position of EVENTS_DEVMISS field.
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_Pos = 0x0
	// Bit mask of EVENTS_DEVMISS field.
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_Msk = 0x1
	// Bit EVENTS_DEVMISS.
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS = 0x1
	// Event not generated
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_DEVMISS_EVENTS_DEVMISS_Generated = 0x1

	// EVENTS_RSSIEND: Sampling of receive signal strength complete
	// Position of EVENTS_RSSIEND field.
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_Pos = 0x0
	// Bit mask of EVENTS_RSSIEND field.
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_Msk = 0x1
	// Bit EVENTS_RSSIEND.
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND = 0x1
	// Event not generated
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_RSSIEND_EVENTS_RSSIEND_Generated = 0x1

	// EVENTS_BCMATCH: Bit counter reached bit count value
	// Position of EVENTS_BCMATCH field.
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_Pos = 0x0
	// Bit mask of EVENTS_BCMATCH field.
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_Msk = 0x1
	// Bit EVENTS_BCMATCH.
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH = 0x1
	// Event not generated
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_BCMATCH_EVENTS_BCMATCH_Generated = 0x1

	// EVENTS_CRCOK: Packet received with CRC ok
	// Position of EVENTS_CRCOK field.
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_Pos = 0x0
	// Bit mask of EVENTS_CRCOK field.
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_Msk = 0x1
	// Bit EVENTS_CRCOK.
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK = 0x1
	// Event not generated
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CRCOK_EVENTS_CRCOK_Generated = 0x1

	// EVENTS_CRCERROR: Packet received with CRC error
	// Position of EVENTS_CRCERROR field.
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_Pos = 0x0
	// Bit mask of EVENTS_CRCERROR field.
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_Msk = 0x1
	// Bit EVENTS_CRCERROR.
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR = 0x1
	// Event not generated
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CRCERROR_EVENTS_CRCERROR_Generated = 0x1

	// EVENTS_FRAMESTART: IEEE 802.15.4 length field received
	// Position of EVENTS_FRAMESTART field.
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_Pos = 0x0
	// Bit mask of EVENTS_FRAMESTART field.
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_Msk = 0x1
	// Bit EVENTS_FRAMESTART.
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART = 0x1
	// Event not generated
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_FRAMESTART_EVENTS_FRAMESTART_Generated = 0x1

	// EVENTS_EDEND: Sampling of energy detection complete. A new ED sample is ready for readout from the RADIO.EDSAMPLE register
	// Position of EVENTS_EDEND field.
	RADIO_EVENTS_EDEND_EVENTS_EDEND_Pos = 0x0
	// Bit mask of EVENTS_EDEND field.
	RADIO_EVENTS_EDEND_EVENTS_EDEND_Msk = 0x1
	// Bit EVENTS_EDEND.
	RADIO_EVENTS_EDEND_EVENTS_EDEND = 0x1
	// Event not generated
	RADIO_EVENTS_EDEND_EVENTS_EDEND_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_EDEND_EVENTS_EDEND_Generated = 0x1

	// EVENTS_EDSTOPPED: The sampling of energy detection has stopped
	// Position of EVENTS_EDSTOPPED field.
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_Pos = 0x0
	// Bit mask of EVENTS_EDSTOPPED field.
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_Msk = 0x1
	// Bit EVENTS_EDSTOPPED.
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED = 0x1
	// Event not generated
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_EDSTOPPED_EVENTS_EDSTOPPED_Generated = 0x1

	// EVENTS_CCAIDLE: Wireless medium in idle - clear to send
	// Position of EVENTS_CCAIDLE field.
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_Pos = 0x0
	// Bit mask of EVENTS_CCAIDLE field.
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_Msk = 0x1
	// Bit EVENTS_CCAIDLE.
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE = 0x1
	// Event not generated
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CCAIDLE_EVENTS_CCAIDLE_Generated = 0x1

	// EVENTS_CCABUSY: Wireless medium busy - do not send
	// Position of EVENTS_CCABUSY field.
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_Pos = 0x0
	// Bit mask of EVENTS_CCABUSY field.
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_Msk = 0x1
	// Bit EVENTS_CCABUSY.
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY = 0x1
	// Event not generated
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CCABUSY_EVENTS_CCABUSY_Generated = 0x1

	// EVENTS_CCASTOPPED: The CCA has stopped
	// Position of EVENTS_CCASTOPPED field.
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_Pos = 0x0
	// Bit mask of EVENTS_CCASTOPPED field.
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_Msk = 0x1
	// Bit EVENTS_CCASTOPPED.
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED = 0x1
	// Event not generated
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CCASTOPPED_EVENTS_CCASTOPPED_Generated = 0x1

	// EVENTS_RATEBOOST: Ble_LR CI field received, receive mode is changed from Ble_LR125Kbit to Ble_LR500Kbit.
	// Position of EVENTS_RATEBOOST field.
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_Pos = 0x0
	// Bit mask of EVENTS_RATEBOOST field.
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_Msk = 0x1
	// Bit EVENTS_RATEBOOST.
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST = 0x1
	// Event not generated
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_RATEBOOST_EVENTS_RATEBOOST_Generated = 0x1

	// EVENTS_TXREADY: RADIO has ramped up and is ready to be started TX path
	// Position of EVENTS_TXREADY field.
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_Pos = 0x0
	// Bit mask of EVENTS_TXREADY field.
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_Msk = 0x1
	// Bit EVENTS_TXREADY.
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY = 0x1
	// Event not generated
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_TXREADY_EVENTS_TXREADY_Generated = 0x1

	// EVENTS_RXREADY: RADIO has ramped up and is ready to be started RX path
	// Position of EVENTS_RXREADY field.
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_Pos = 0x0
	// Bit mask of EVENTS_RXREADY field.
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_Msk = 0x1
	// Bit EVENTS_RXREADY.
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY = 0x1
	// Event not generated
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_RXREADY_EVENTS_RXREADY_Generated = 0x1

	// EVENTS_MHRMATCH: MAC header match found
	// Position of EVENTS_MHRMATCH field.
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_Pos = 0x0
	// Bit mask of EVENTS_MHRMATCH field.
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_Msk = 0x1
	// Bit EVENTS_MHRMATCH.
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH = 0x1
	// Event not generated
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_MHRMATCH_EVENTS_MHRMATCH_Generated = 0x1

	// EVENTS_SYNC: Preamble indicator
	// Position of EVENTS_SYNC field.
	RADIO_EVENTS_SYNC_EVENTS_SYNC_Pos = 0x0
	// Bit mask of EVENTS_SYNC field.
	RADIO_EVENTS_SYNC_EVENTS_SYNC_Msk = 0x1
	// Bit EVENTS_SYNC.
	RADIO_EVENTS_SYNC_EVENTS_SYNC = 0x1
	// Event not generated
	RADIO_EVENTS_SYNC_EVENTS_SYNC_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_SYNC_EVENTS_SYNC_Generated = 0x1

	// EVENTS_PHYEND: Generated when last bit is sent on air, or received from air
	// Position of EVENTS_PHYEND field.
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_Pos = 0x0
	// Bit mask of EVENTS_PHYEND field.
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_Msk = 0x1
	// Bit EVENTS_PHYEND.
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND = 0x1
	// Event not generated
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_PHYEND_EVENTS_PHYEND_Generated = 0x1

	// EVENTS_CTEPRESENT: CTE is present (early warning right after receiving CTEInfo byte)
	// Position of EVENTS_CTEPRESENT field.
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT_Pos = 0x0
	// Bit mask of EVENTS_CTEPRESENT field.
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT_Msk = 0x1
	// Bit EVENTS_CTEPRESENT.
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT = 0x1
	// Event not generated
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT_NotGenerated = 0x0
	// Event generated
	RADIO_EVENTS_CTEPRESENT_EVENTS_CTEPRESENT_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of READY_START field.
	RADIO_SHORTS_READY_START_Pos = 0x0
	// Bit mask of READY_START field.
	RADIO_SHORTS_READY_START_Msk = 0x1
	// Bit READY_START.
	RADIO_SHORTS_READY_START = 0x1
	// Disable shortcut
	RADIO_SHORTS_READY_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_READY_START_Enabled = 0x1
	// Position of END_DISABLE field.
	RADIO_SHORTS_END_DISABLE_Pos = 0x1
	// Bit mask of END_DISABLE field.
	RADIO_SHORTS_END_DISABLE_Msk = 0x2
	// Bit END_DISABLE.
	RADIO_SHORTS_END_DISABLE = 0x2
	// Disable shortcut
	RADIO_SHORTS_END_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_END_DISABLE_Enabled = 0x1
	// Position of DISABLED_TXEN field.
	RADIO_SHORTS_DISABLED_TXEN_Pos = 0x2
	// Bit mask of DISABLED_TXEN field.
	RADIO_SHORTS_DISABLED_TXEN_Msk = 0x4
	// Bit DISABLED_TXEN.
	RADIO_SHORTS_DISABLED_TXEN = 0x4
	// Disable shortcut
	RADIO_SHORTS_DISABLED_TXEN_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_DISABLED_TXEN_Enabled = 0x1
	// Position of DISABLED_RXEN field.
	RADIO_SHORTS_DISABLED_RXEN_Pos = 0x3
	// Bit mask of DISABLED_RXEN field.
	RADIO_SHORTS_DISABLED_RXEN_Msk = 0x8
	// Bit DISABLED_RXEN.
	RADIO_SHORTS_DISABLED_RXEN = 0x8
	// Disable shortcut
	RADIO_SHORTS_DISABLED_RXEN_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_DISABLED_RXEN_Enabled = 0x1
	// Position of ADDRESS_RSSISTART field.
	RADIO_SHORTS_ADDRESS_RSSISTART_Pos = 0x4
	// Bit mask of ADDRESS_RSSISTART field.
	RADIO_SHORTS_ADDRESS_RSSISTART_Msk = 0x10
	// Bit ADDRESS_RSSISTART.
	RADIO_SHORTS_ADDRESS_RSSISTART = 0x10
	// Disable shortcut
	RADIO_SHORTS_ADDRESS_RSSISTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_ADDRESS_RSSISTART_Enabled = 0x1
	// Position of END_START field.
	RADIO_SHORTS_END_START_Pos = 0x5
	// Bit mask of END_START field.
	RADIO_SHORTS_END_START_Msk = 0x20
	// Bit END_START.
	RADIO_SHORTS_END_START = 0x20
	// Disable shortcut
	RADIO_SHORTS_END_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_END_START_Enabled = 0x1
	// Position of ADDRESS_BCSTART field.
	RADIO_SHORTS_ADDRESS_BCSTART_Pos = 0x6
	// Bit mask of ADDRESS_BCSTART field.
	RADIO_SHORTS_ADDRESS_BCSTART_Msk = 0x40
	// Bit ADDRESS_BCSTART.
	RADIO_SHORTS_ADDRESS_BCSTART = 0x40
	// Disable shortcut
	RADIO_SHORTS_ADDRESS_BCSTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_ADDRESS_BCSTART_Enabled = 0x1
	// Position of DISABLED_RSSISTOP field.
	RADIO_SHORTS_DISABLED_RSSISTOP_Pos = 0x8
	// Bit mask of DISABLED_RSSISTOP field.
	RADIO_SHORTS_DISABLED_RSSISTOP_Msk = 0x100
	// Bit DISABLED_RSSISTOP.
	RADIO_SHORTS_DISABLED_RSSISTOP = 0x100
	// Disable shortcut
	RADIO_SHORTS_DISABLED_RSSISTOP_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_DISABLED_RSSISTOP_Enabled = 0x1
	// Position of RXREADY_CCASTART field.
	RADIO_SHORTS_RXREADY_CCASTART_Pos = 0xb
	// Bit mask of RXREADY_CCASTART field.
	RADIO_SHORTS_RXREADY_CCASTART_Msk = 0x800
	// Bit RXREADY_CCASTART.
	RADIO_SHORTS_RXREADY_CCASTART = 0x800
	// Disable shortcut
	RADIO_SHORTS_RXREADY_CCASTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_RXREADY_CCASTART_Enabled = 0x1
	// Position of CCAIDLE_TXEN field.
	RADIO_SHORTS_CCAIDLE_TXEN_Pos = 0xc
	// Bit mask of CCAIDLE_TXEN field.
	RADIO_SHORTS_CCAIDLE_TXEN_Msk = 0x1000
	// Bit CCAIDLE_TXEN.
	RADIO_SHORTS_CCAIDLE_TXEN = 0x1000
	// Disable shortcut
	RADIO_SHORTS_CCAIDLE_TXEN_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_CCAIDLE_TXEN_Enabled = 0x1
	// Position of CCABUSY_DISABLE field.
	RADIO_SHORTS_CCABUSY_DISABLE_Pos = 0xd
	// Bit mask of CCABUSY_DISABLE field.
	RADIO_SHORTS_CCABUSY_DISABLE_Msk = 0x2000
	// Bit CCABUSY_DISABLE.
	RADIO_SHORTS_CCABUSY_DISABLE = 0x2000
	// Disable shortcut
	RADIO_SHORTS_CCABUSY_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_CCABUSY_DISABLE_Enabled = 0x1
	// Position of FRAMESTART_BCSTART field.
	RADIO_SHORTS_FRAMESTART_BCSTART_Pos = 0xe
	// Bit mask of FRAMESTART_BCSTART field.
	RADIO_SHORTS_FRAMESTART_BCSTART_Msk = 0x4000
	// Bit FRAMESTART_BCSTART.
	RADIO_SHORTS_FRAMESTART_BCSTART = 0x4000
	// Disable shortcut
	RADIO_SHORTS_FRAMESTART_BCSTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_FRAMESTART_BCSTART_Enabled = 0x1
	// Position of READY_EDSTART field.
	RADIO_SHORTS_READY_EDSTART_Pos = 0xf
	// Bit mask of READY_EDSTART field.
	RADIO_SHORTS_READY_EDSTART_Msk = 0x8000
	// Bit READY_EDSTART.
	RADIO_SHORTS_READY_EDSTART = 0x8000
	// Disable shortcut
	RADIO_SHORTS_READY_EDSTART_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_READY_EDSTART_Enabled = 0x1
	// Position of EDEND_DISABLE field.
	RADIO_SHORTS_EDEND_DISABLE_Pos = 0x10
	// Bit mask of EDEND_DISABLE field.
	RADIO_SHORTS_EDEND_DISABLE_Msk = 0x10000
	// Bit EDEND_DISABLE.
	RADIO_SHORTS_EDEND_DISABLE = 0x10000
	// Disable shortcut
	RADIO_SHORTS_EDEND_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_EDEND_DISABLE_Enabled = 0x1
	// Position of CCAIDLE_STOP field.
	RADIO_SHORTS_CCAIDLE_STOP_Pos = 0x11
	// Bit mask of CCAIDLE_STOP field.
	RADIO_SHORTS_CCAIDLE_STOP_Msk = 0x20000
	// Bit CCAIDLE_STOP.
	RADIO_SHORTS_CCAIDLE_STOP = 0x20000
	// Disable shortcut
	RADIO_SHORTS_CCAIDLE_STOP_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_CCAIDLE_STOP_Enabled = 0x1
	// Position of TXREADY_START field.
	RADIO_SHORTS_TXREADY_START_Pos = 0x12
	// Bit mask of TXREADY_START field.
	RADIO_SHORTS_TXREADY_START_Msk = 0x40000
	// Bit TXREADY_START.
	RADIO_SHORTS_TXREADY_START = 0x40000
	// Disable shortcut
	RADIO_SHORTS_TXREADY_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_TXREADY_START_Enabled = 0x1
	// Position of RXREADY_START field.
	RADIO_SHORTS_RXREADY_START_Pos = 0x13
	// Bit mask of RXREADY_START field.
	RADIO_SHORTS_RXREADY_START_Msk = 0x80000
	// Bit RXREADY_START.
	RADIO_SHORTS_RXREADY_START = 0x80000
	// Disable shortcut
	RADIO_SHORTS_RXREADY_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_RXREADY_START_Enabled = 0x1
	// Position of PHYEND_DISABLE field.
	RADIO_SHORTS_PHYEND_DISABLE_Pos = 0x14
	// Bit mask of PHYEND_DISABLE field.
	RADIO_SHORTS_PHYEND_DISABLE_Msk = 0x100000
	// Bit PHYEND_DISABLE.
	RADIO_SHORTS_PHYEND_DISABLE = 0x100000
	// Disable shortcut
	RADIO_SHORTS_PHYEND_DISABLE_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_PHYEND_DISABLE_Enabled = 0x1
	// Position of PHYEND_START field.
	RADIO_SHORTS_PHYEND_START_Pos = 0x15
	// Bit mask of PHYEND_START field.
	RADIO_SHORTS_PHYEND_START_Msk = 0x200000
	// Bit PHYEND_START.
	RADIO_SHORTS_PHYEND_START = 0x200000
	// Disable shortcut
	RADIO_SHORTS_PHYEND_START_Disabled = 0x0
	// Enable shortcut
	RADIO_SHORTS_PHYEND_START_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of READY field.
	RADIO_INTENSET_READY_Pos = 0x0
	// Bit mask of READY field.
	RADIO_INTENSET_READY_Msk = 0x1
	// Bit READY.
	RADIO_INTENSET_READY = 0x1
	// Read: Disabled
	RADIO_INTENSET_READY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_READY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_READY_Set = 0x1
	// Position of ADDRESS field.
	RADIO_INTENSET_ADDRESS_Pos = 0x1
	// Bit mask of ADDRESS field.
	RADIO_INTENSET_ADDRESS_Msk = 0x2
	// Bit ADDRESS.
	RADIO_INTENSET_ADDRESS = 0x2
	// Read: Disabled
	RADIO_INTENSET_ADDRESS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_ADDRESS_Enabled = 0x1
	// Enable
	RADIO_INTENSET_ADDRESS_Set = 0x1
	// Position of PAYLOAD field.
	RADIO_INTENSET_PAYLOAD_Pos = 0x2
	// Bit mask of PAYLOAD field.
	RADIO_INTENSET_PAYLOAD_Msk = 0x4
	// Bit PAYLOAD.
	RADIO_INTENSET_PAYLOAD = 0x4
	// Read: Disabled
	RADIO_INTENSET_PAYLOAD_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_PAYLOAD_Enabled = 0x1
	// Enable
	RADIO_INTENSET_PAYLOAD_Set = 0x1
	// Position of END field.
	RADIO_INTENSET_END_Pos = 0x3
	// Bit mask of END field.
	RADIO_INTENSET_END_Msk = 0x8
	// Bit END.
	RADIO_INTENSET_END = 0x8
	// Read: Disabled
	RADIO_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_END_Enabled = 0x1
	// Enable
	RADIO_INTENSET_END_Set = 0x1
	// Position of DISABLED field.
	RADIO_INTENSET_DISABLED_Pos = 0x4
	// Bit mask of DISABLED field.
	RADIO_INTENSET_DISABLED_Msk = 0x10
	// Bit DISABLED.
	RADIO_INTENSET_DISABLED = 0x10
	// Read: Disabled
	RADIO_INTENSET_DISABLED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_DISABLED_Enabled = 0x1
	// Enable
	RADIO_INTENSET_DISABLED_Set = 0x1
	// Position of DEVMATCH field.
	RADIO_INTENSET_DEVMATCH_Pos = 0x5
	// Bit mask of DEVMATCH field.
	RADIO_INTENSET_DEVMATCH_Msk = 0x20
	// Bit DEVMATCH.
	RADIO_INTENSET_DEVMATCH = 0x20
	// Read: Disabled
	RADIO_INTENSET_DEVMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_DEVMATCH_Enabled = 0x1
	// Enable
	RADIO_INTENSET_DEVMATCH_Set = 0x1
	// Position of DEVMISS field.
	RADIO_INTENSET_DEVMISS_Pos = 0x6
	// Bit mask of DEVMISS field.
	RADIO_INTENSET_DEVMISS_Msk = 0x40
	// Bit DEVMISS.
	RADIO_INTENSET_DEVMISS = 0x40
	// Read: Disabled
	RADIO_INTENSET_DEVMISS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_DEVMISS_Enabled = 0x1
	// Enable
	RADIO_INTENSET_DEVMISS_Set = 0x1
	// Position of RSSIEND field.
	RADIO_INTENSET_RSSIEND_Pos = 0x7
	// Bit mask of RSSIEND field.
	RADIO_INTENSET_RSSIEND_Msk = 0x80
	// Bit RSSIEND.
	RADIO_INTENSET_RSSIEND = 0x80
	// Read: Disabled
	RADIO_INTENSET_RSSIEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_RSSIEND_Enabled = 0x1
	// Enable
	RADIO_INTENSET_RSSIEND_Set = 0x1
	// Position of BCMATCH field.
	RADIO_INTENSET_BCMATCH_Pos = 0xa
	// Bit mask of BCMATCH field.
	RADIO_INTENSET_BCMATCH_Msk = 0x400
	// Bit BCMATCH.
	RADIO_INTENSET_BCMATCH = 0x400
	// Read: Disabled
	RADIO_INTENSET_BCMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_BCMATCH_Enabled = 0x1
	// Enable
	RADIO_INTENSET_BCMATCH_Set = 0x1
	// Position of CRCOK field.
	RADIO_INTENSET_CRCOK_Pos = 0xc
	// Bit mask of CRCOK field.
	RADIO_INTENSET_CRCOK_Msk = 0x1000
	// Bit CRCOK.
	RADIO_INTENSET_CRCOK = 0x1000
	// Read: Disabled
	RADIO_INTENSET_CRCOK_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CRCOK_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CRCOK_Set = 0x1
	// Position of CRCERROR field.
	RADIO_INTENSET_CRCERROR_Pos = 0xd
	// Bit mask of CRCERROR field.
	RADIO_INTENSET_CRCERROR_Msk = 0x2000
	// Bit CRCERROR.
	RADIO_INTENSET_CRCERROR = 0x2000
	// Read: Disabled
	RADIO_INTENSET_CRCERROR_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CRCERROR_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CRCERROR_Set = 0x1
	// Position of FRAMESTART field.
	RADIO_INTENSET_FRAMESTART_Pos = 0xe
	// Bit mask of FRAMESTART field.
	RADIO_INTENSET_FRAMESTART_Msk = 0x4000
	// Bit FRAMESTART.
	RADIO_INTENSET_FRAMESTART = 0x4000
	// Read: Disabled
	RADIO_INTENSET_FRAMESTART_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_FRAMESTART_Enabled = 0x1
	// Enable
	RADIO_INTENSET_FRAMESTART_Set = 0x1
	// Position of EDEND field.
	RADIO_INTENSET_EDEND_Pos = 0xf
	// Bit mask of EDEND field.
	RADIO_INTENSET_EDEND_Msk = 0x8000
	// Bit EDEND.
	RADIO_INTENSET_EDEND = 0x8000
	// Read: Disabled
	RADIO_INTENSET_EDEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_EDEND_Enabled = 0x1
	// Enable
	RADIO_INTENSET_EDEND_Set = 0x1
	// Position of EDSTOPPED field.
	RADIO_INTENSET_EDSTOPPED_Pos = 0x10
	// Bit mask of EDSTOPPED field.
	RADIO_INTENSET_EDSTOPPED_Msk = 0x10000
	// Bit EDSTOPPED.
	RADIO_INTENSET_EDSTOPPED = 0x10000
	// Read: Disabled
	RADIO_INTENSET_EDSTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_EDSTOPPED_Enabled = 0x1
	// Enable
	RADIO_INTENSET_EDSTOPPED_Set = 0x1
	// Position of CCAIDLE field.
	RADIO_INTENSET_CCAIDLE_Pos = 0x11
	// Bit mask of CCAIDLE field.
	RADIO_INTENSET_CCAIDLE_Msk = 0x20000
	// Bit CCAIDLE.
	RADIO_INTENSET_CCAIDLE = 0x20000
	// Read: Disabled
	RADIO_INTENSET_CCAIDLE_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CCAIDLE_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CCAIDLE_Set = 0x1
	// Position of CCABUSY field.
	RADIO_INTENSET_CCABUSY_Pos = 0x12
	// Bit mask of CCABUSY field.
	RADIO_INTENSET_CCABUSY_Msk = 0x40000
	// Bit CCABUSY.
	RADIO_INTENSET_CCABUSY = 0x40000
	// Read: Disabled
	RADIO_INTENSET_CCABUSY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CCABUSY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CCABUSY_Set = 0x1
	// Position of CCASTOPPED field.
	RADIO_INTENSET_CCASTOPPED_Pos = 0x13
	// Bit mask of CCASTOPPED field.
	RADIO_INTENSET_CCASTOPPED_Msk = 0x80000
	// Bit CCASTOPPED.
	RADIO_INTENSET_CCASTOPPED = 0x80000
	// Read: Disabled
	RADIO_INTENSET_CCASTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CCASTOPPED_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CCASTOPPED_Set = 0x1
	// Position of RATEBOOST field.
	RADIO_INTENSET_RATEBOOST_Pos = 0x14
	// Bit mask of RATEBOOST field.
	RADIO_INTENSET_RATEBOOST_Msk = 0x100000
	// Bit RATEBOOST.
	RADIO_INTENSET_RATEBOOST = 0x100000
	// Read: Disabled
	RADIO_INTENSET_RATEBOOST_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_RATEBOOST_Enabled = 0x1
	// Enable
	RADIO_INTENSET_RATEBOOST_Set = 0x1
	// Position of TXREADY field.
	RADIO_INTENSET_TXREADY_Pos = 0x15
	// Bit mask of TXREADY field.
	RADIO_INTENSET_TXREADY_Msk = 0x200000
	// Bit TXREADY.
	RADIO_INTENSET_TXREADY = 0x200000
	// Read: Disabled
	RADIO_INTENSET_TXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_TXREADY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_TXREADY_Set = 0x1
	// Position of RXREADY field.
	RADIO_INTENSET_RXREADY_Pos = 0x16
	// Bit mask of RXREADY field.
	RADIO_INTENSET_RXREADY_Msk = 0x400000
	// Bit RXREADY.
	RADIO_INTENSET_RXREADY = 0x400000
	// Read: Disabled
	RADIO_INTENSET_RXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_RXREADY_Enabled = 0x1
	// Enable
	RADIO_INTENSET_RXREADY_Set = 0x1
	// Position of MHRMATCH field.
	RADIO_INTENSET_MHRMATCH_Pos = 0x17
	// Bit mask of MHRMATCH field.
	RADIO_INTENSET_MHRMATCH_Msk = 0x800000
	// Bit MHRMATCH.
	RADIO_INTENSET_MHRMATCH = 0x800000
	// Read: Disabled
	RADIO_INTENSET_MHRMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_MHRMATCH_Enabled = 0x1
	// Enable
	RADIO_INTENSET_MHRMATCH_Set = 0x1
	// Position of SYNC field.
	RADIO_INTENSET_SYNC_Pos = 0x1a
	// Bit mask of SYNC field.
	RADIO_INTENSET_SYNC_Msk = 0x4000000
	// Bit SYNC.
	RADIO_INTENSET_SYNC = 0x4000000
	// Read: Disabled
	RADIO_INTENSET_SYNC_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_SYNC_Enabled = 0x1
	// Enable
	RADIO_INTENSET_SYNC_Set = 0x1
	// Position of PHYEND field.
	RADIO_INTENSET_PHYEND_Pos = 0x1b
	// Bit mask of PHYEND field.
	RADIO_INTENSET_PHYEND_Msk = 0x8000000
	// Bit PHYEND.
	RADIO_INTENSET_PHYEND = 0x8000000
	// Read: Disabled
	RADIO_INTENSET_PHYEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_PHYEND_Enabled = 0x1
	// Enable
	RADIO_INTENSET_PHYEND_Set = 0x1
	// Position of CTEPRESENT field.
	RADIO_INTENSET_CTEPRESENT_Pos = 0x1c
	// Bit mask of CTEPRESENT field.
	RADIO_INTENSET_CTEPRESENT_Msk = 0x10000000
	// Bit CTEPRESENT.
	RADIO_INTENSET_CTEPRESENT = 0x10000000
	// Read: Disabled
	RADIO_INTENSET_CTEPRESENT_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENSET_CTEPRESENT_Enabled = 0x1
	// Enable
	RADIO_INTENSET_CTEPRESENT_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of READY field.
	RADIO_INTENCLR_READY_Pos = 0x0
	// Bit mask of READY field.
	RADIO_INTENCLR_READY_Msk = 0x1
	// Bit READY.
	RADIO_INTENCLR_READY = 0x1
	// Read: Disabled
	RADIO_INTENCLR_READY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_READY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_READY_Clear = 0x1
	// Position of ADDRESS field.
	RADIO_INTENCLR_ADDRESS_Pos = 0x1
	// Bit mask of ADDRESS field.
	RADIO_INTENCLR_ADDRESS_Msk = 0x2
	// Bit ADDRESS.
	RADIO_INTENCLR_ADDRESS = 0x2
	// Read: Disabled
	RADIO_INTENCLR_ADDRESS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_ADDRESS_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_ADDRESS_Clear = 0x1
	// Position of PAYLOAD field.
	RADIO_INTENCLR_PAYLOAD_Pos = 0x2
	// Bit mask of PAYLOAD field.
	RADIO_INTENCLR_PAYLOAD_Msk = 0x4
	// Bit PAYLOAD.
	RADIO_INTENCLR_PAYLOAD = 0x4
	// Read: Disabled
	RADIO_INTENCLR_PAYLOAD_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_PAYLOAD_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_PAYLOAD_Clear = 0x1
	// Position of END field.
	RADIO_INTENCLR_END_Pos = 0x3
	// Bit mask of END field.
	RADIO_INTENCLR_END_Msk = 0x8
	// Bit END.
	RADIO_INTENCLR_END = 0x8
	// Read: Disabled
	RADIO_INTENCLR_END_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_END_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_END_Clear = 0x1
	// Position of DISABLED field.
	RADIO_INTENCLR_DISABLED_Pos = 0x4
	// Bit mask of DISABLED field.
	RADIO_INTENCLR_DISABLED_Msk = 0x10
	// Bit DISABLED.
	RADIO_INTENCLR_DISABLED = 0x10
	// Read: Disabled
	RADIO_INTENCLR_DISABLED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_DISABLED_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_DISABLED_Clear = 0x1
	// Position of DEVMATCH field.
	RADIO_INTENCLR_DEVMATCH_Pos = 0x5
	// Bit mask of DEVMATCH field.
	RADIO_INTENCLR_DEVMATCH_Msk = 0x20
	// Bit DEVMATCH.
	RADIO_INTENCLR_DEVMATCH = 0x20
	// Read: Disabled
	RADIO_INTENCLR_DEVMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_DEVMATCH_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_DEVMATCH_Clear = 0x1
	// Position of DEVMISS field.
	RADIO_INTENCLR_DEVMISS_Pos = 0x6
	// Bit mask of DEVMISS field.
	RADIO_INTENCLR_DEVMISS_Msk = 0x40
	// Bit DEVMISS.
	RADIO_INTENCLR_DEVMISS = 0x40
	// Read: Disabled
	RADIO_INTENCLR_DEVMISS_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_DEVMISS_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_DEVMISS_Clear = 0x1
	// Position of RSSIEND field.
	RADIO_INTENCLR_RSSIEND_Pos = 0x7
	// Bit mask of RSSIEND field.
	RADIO_INTENCLR_RSSIEND_Msk = 0x80
	// Bit RSSIEND.
	RADIO_INTENCLR_RSSIEND = 0x80
	// Read: Disabled
	RADIO_INTENCLR_RSSIEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_RSSIEND_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_RSSIEND_Clear = 0x1
	// Position of BCMATCH field.
	RADIO_INTENCLR_BCMATCH_Pos = 0xa
	// Bit mask of BCMATCH field.
	RADIO_INTENCLR_BCMATCH_Msk = 0x400
	// Bit BCMATCH.
	RADIO_INTENCLR_BCMATCH = 0x400
	// Read: Disabled
	RADIO_INTENCLR_BCMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_BCMATCH_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_BCMATCH_Clear = 0x1
	// Position of CRCOK field.
	RADIO_INTENCLR_CRCOK_Pos = 0xc
	// Bit mask of CRCOK field.
	RADIO_INTENCLR_CRCOK_Msk = 0x1000
	// Bit CRCOK.
	RADIO_INTENCLR_CRCOK = 0x1000
	// Read: Disabled
	RADIO_INTENCLR_CRCOK_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CRCOK_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CRCOK_Clear = 0x1
	// Position of CRCERROR field.
	RADIO_INTENCLR_CRCERROR_Pos = 0xd
	// Bit mask of CRCERROR field.
	RADIO_INTENCLR_CRCERROR_Msk = 0x2000
	// Bit CRCERROR.
	RADIO_INTENCLR_CRCERROR = 0x2000
	// Read: Disabled
	RADIO_INTENCLR_CRCERROR_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CRCERROR_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CRCERROR_Clear = 0x1
	// Position of FRAMESTART field.
	RADIO_INTENCLR_FRAMESTART_Pos = 0xe
	// Bit mask of FRAMESTART field.
	RADIO_INTENCLR_FRAMESTART_Msk = 0x4000
	// Bit FRAMESTART.
	RADIO_INTENCLR_FRAMESTART = 0x4000
	// Read: Disabled
	RADIO_INTENCLR_FRAMESTART_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_FRAMESTART_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_FRAMESTART_Clear = 0x1
	// Position of EDEND field.
	RADIO_INTENCLR_EDEND_Pos = 0xf
	// Bit mask of EDEND field.
	RADIO_INTENCLR_EDEND_Msk = 0x8000
	// Bit EDEND.
	RADIO_INTENCLR_EDEND = 0x8000
	// Read: Disabled
	RADIO_INTENCLR_EDEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_EDEND_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_EDEND_Clear = 0x1
	// Position of EDSTOPPED field.
	RADIO_INTENCLR_EDSTOPPED_Pos = 0x10
	// Bit mask of EDSTOPPED field.
	RADIO_INTENCLR_EDSTOPPED_Msk = 0x10000
	// Bit EDSTOPPED.
	RADIO_INTENCLR_EDSTOPPED = 0x10000
	// Read: Disabled
	RADIO_INTENCLR_EDSTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_EDSTOPPED_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_EDSTOPPED_Clear = 0x1
	// Position of CCAIDLE field.
	RADIO_INTENCLR_CCAIDLE_Pos = 0x11
	// Bit mask of CCAIDLE field.
	RADIO_INTENCLR_CCAIDLE_Msk = 0x20000
	// Bit CCAIDLE.
	RADIO_INTENCLR_CCAIDLE = 0x20000
	// Read: Disabled
	RADIO_INTENCLR_CCAIDLE_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CCAIDLE_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CCAIDLE_Clear = 0x1
	// Position of CCABUSY field.
	RADIO_INTENCLR_CCABUSY_Pos = 0x12
	// Bit mask of CCABUSY field.
	RADIO_INTENCLR_CCABUSY_Msk = 0x40000
	// Bit CCABUSY.
	RADIO_INTENCLR_CCABUSY = 0x40000
	// Read: Disabled
	RADIO_INTENCLR_CCABUSY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CCABUSY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CCABUSY_Clear = 0x1
	// Position of CCASTOPPED field.
	RADIO_INTENCLR_CCASTOPPED_Pos = 0x13
	// Bit mask of CCASTOPPED field.
	RADIO_INTENCLR_CCASTOPPED_Msk = 0x80000
	// Bit CCASTOPPED.
	RADIO_INTENCLR_CCASTOPPED = 0x80000
	// Read: Disabled
	RADIO_INTENCLR_CCASTOPPED_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CCASTOPPED_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CCASTOPPED_Clear = 0x1
	// Position of RATEBOOST field.
	RADIO_INTENCLR_RATEBOOST_Pos = 0x14
	// Bit mask of RATEBOOST field.
	RADIO_INTENCLR_RATEBOOST_Msk = 0x100000
	// Bit RATEBOOST.
	RADIO_INTENCLR_RATEBOOST = 0x100000
	// Read: Disabled
	RADIO_INTENCLR_RATEBOOST_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_RATEBOOST_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_RATEBOOST_Clear = 0x1
	// Position of TXREADY field.
	RADIO_INTENCLR_TXREADY_Pos = 0x15
	// Bit mask of TXREADY field.
	RADIO_INTENCLR_TXREADY_Msk = 0x200000
	// Bit TXREADY.
	RADIO_INTENCLR_TXREADY = 0x200000
	// Read: Disabled
	RADIO_INTENCLR_TXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_TXREADY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_TXREADY_Clear = 0x1
	// Position of RXREADY field.
	RADIO_INTENCLR_RXREADY_Pos = 0x16
	// Bit mask of RXREADY field.
	RADIO_INTENCLR_RXREADY_Msk = 0x400000
	// Bit RXREADY.
	RADIO_INTENCLR_RXREADY = 0x400000
	// Read: Disabled
	RADIO_INTENCLR_RXREADY_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_RXREADY_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_RXREADY_Clear = 0x1
	// Position of MHRMATCH field.
	RADIO_INTENCLR_MHRMATCH_Pos = 0x17
	// Bit mask of MHRMATCH field.
	RADIO_INTENCLR_MHRMATCH_Msk = 0x800000
	// Bit MHRMATCH.
	RADIO_INTENCLR_MHRMATCH = 0x800000
	// Read: Disabled
	RADIO_INTENCLR_MHRMATCH_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_MHRMATCH_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_MHRMATCH_Clear = 0x1
	// Position of SYNC field.
	RADIO_INTENCLR_SYNC_Pos = 0x1a
	// Bit mask of SYNC field.
	RADIO_INTENCLR_SYNC_Msk = 0x4000000
	// Bit SYNC.
	RADIO_INTENCLR_SYNC = 0x4000000
	// Read: Disabled
	RADIO_INTENCLR_SYNC_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_SYNC_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_SYNC_Clear = 0x1
	// Position of PHYEND field.
	RADIO_INTENCLR_PHYEND_Pos = 0x1b
	// Bit mask of PHYEND field.
	RADIO_INTENCLR_PHYEND_Msk = 0x8000000
	// Bit PHYEND.
	RADIO_INTENCLR_PHYEND = 0x8000000
	// Read: Disabled
	RADIO_INTENCLR_PHYEND_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_PHYEND_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_PHYEND_Clear = 0x1
	// Position of CTEPRESENT field.
	RADIO_INTENCLR_CTEPRESENT_Pos = 0x1c
	// Bit mask of CTEPRESENT field.
	RADIO_INTENCLR_CTEPRESENT_Msk = 0x10000000
	// Bit CTEPRESENT.
	RADIO_INTENCLR_CTEPRESENT = 0x10000000
	// Read: Disabled
	RADIO_INTENCLR_CTEPRESENT_Disabled = 0x0
	// Read: Enabled
	RADIO_INTENCLR_CTEPRESENT_Enabled = 0x1
	// Disable
	RADIO_INTENCLR_CTEPRESENT_Clear = 0x1

	// CRCSTATUS: CRC status
	// Position of CRCSTATUS field.
	RADIO_CRCSTATUS_CRCSTATUS_Pos = 0x0
	// Bit mask of CRCSTATUS field.
	RADIO_CRCSTATUS_CRCSTATUS_Msk = 0x1
	// Bit CRCSTATUS.
	RADIO_CRCSTATUS_CRCSTATUS = 0x1
	// Packet received with CRC error
	RADIO_CRCSTATUS_CRCSTATUS_CRCError = 0x0
	// Packet received with CRC ok
	RADIO_CRCSTATUS_CRCSTATUS_CRCOk = 0x1

	// RXMATCH: Received address
	// Position of RXMATCH field.
	RADIO_RXMATCH_RXMATCH_Pos = 0x0
	// Bit mask of RXMATCH field.
	RADIO_RXMATCH_RXMATCH_Msk = 0x7

	// RXCRC: CRC field of previously received packet
	// Position of RXCRC field.
	RADIO_RXCRC_RXCRC_Pos = 0x0
	// Bit mask of RXCRC field.
	RADIO_RXCRC_RXCRC_Msk = 0xffffff

	// DAI: Device address match index
	// Position of DAI field.
	RADIO_DAI_DAI_Pos = 0x0
	// Bit mask of DAI field.
	RADIO_DAI_DAI_Msk = 0x7

	// PDUSTAT: Payload status
	// Position of PDUSTAT field.
	RADIO_PDUSTAT_PDUSTAT_Pos = 0x0
	// Bit mask of PDUSTAT field.
	RADIO_PDUSTAT_PDUSTAT_Msk = 0x1
	// Bit PDUSTAT.
	RADIO_PDUSTAT_PDUSTAT = 0x1
	// Payload less than PCNF1.MAXLEN
	RADIO_PDUSTAT_PDUSTAT_LessThan = 0x0
	// Payload greater than PCNF1.MAXLEN
	RADIO_PDUSTAT_PDUSTAT_GreaterThan = 0x1
	// Position of CISTAT field.
	RADIO_PDUSTAT_CISTAT_Pos = 0x1
	// Bit mask of CISTAT field.
	RADIO_PDUSTAT_CISTAT_Msk = 0x6
	// Frame is received at 125 kbps
	RADIO_PDUSTAT_CISTAT_LR125kbit = 0x0
	// Frame is received at 500 kbps
	RADIO_PDUSTAT_CISTAT_LR500kbit = 0x1

	// CTESTATUS: CTEInfo parsed from received packet
	// Position of CTETIME field.
	RADIO_CTESTATUS_CTETIME_Pos = 0x0
	// Bit mask of CTETIME field.
	RADIO_CTESTATUS_CTETIME_Msk = 0x1f
	// Position of RFU field.
	RADIO_CTESTATUS_RFU_Pos = 0x5
	// Bit mask of RFU field.
	RADIO_CTESTATUS_RFU_Msk = 0x20
	// Bit RFU.
	RADIO_CTESTATUS_RFU = 0x20
	// Position of CTETYPE field.
	RADIO_CTESTATUS_CTETYPE_Pos = 0x6
	// Bit mask of CTETYPE field.
	RADIO_CTESTATUS_CTETYPE_Msk = 0xc0

	// DFESTATUS: DFE status information
	// Position of SWITCHINGSTATE field.
	RADIO_DFESTATUS_SWITCHINGSTATE_Pos = 0x0
	// Bit mask of SWITCHINGSTATE field.
	RADIO_DFESTATUS_SWITCHINGSTATE_Msk = 0x7
	// Switching state Idle
	RADIO_DFESTATUS_SWITCHINGSTATE_Idle = 0x0
	// Switching state Offset
	RADIO_DFESTATUS_SWITCHINGSTATE_Offset = 0x1
	// Switching state Guard
	RADIO_DFESTATUS_SWITCHINGSTATE_Guard = 0x2
	// Switching state Ref
	RADIO_DFESTATUS_SWITCHINGSTATE_Ref = 0x3
	// Switching state Switching
	RADIO_DFESTATUS_SWITCHINGSTATE_Switching = 0x4
	// Switching state Ending
	RADIO_DFESTATUS_SWITCHINGSTATE_Ending = 0x5
	// Position of SAMPLINGSTATE field.
	RADIO_DFESTATUS_SAMPLINGSTATE_Pos = 0x4
	// Bit mask of SAMPLINGSTATE field.
	RADIO_DFESTATUS_SAMPLINGSTATE_Msk = 0x10
	// Bit SAMPLINGSTATE.
	RADIO_DFESTATUS_SAMPLINGSTATE = 0x10
	// Sampling state Idle
	RADIO_DFESTATUS_SAMPLINGSTATE_Idle = 0x0
	// Sampling state Sampling
	RADIO_DFESTATUS_SAMPLINGSTATE_Sampling = 0x1

	// PACKETPTR: Packet pointer
	// Position of PACKETPTR field.
	RADIO_PACKETPTR_PACKETPTR_Pos = 0x0
	// Bit mask of PACKETPTR field.
	RADIO_PACKETPTR_PACKETPTR_Msk = 0xffffffff

	// FREQUENCY: Frequency
	// Position of FREQUENCY field.
	RADIO_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	RADIO_FREQUENCY_FREQUENCY_Msk = 0x7f
	// Position of MAP field.
	RADIO_FREQUENCY_MAP_Pos = 0x8
	// Bit mask of MAP field.
	RADIO_FREQUENCY_MAP_Msk = 0x100
	// Bit MAP.
	RADIO_FREQUENCY_MAP = 0x100
	// Channel map between 2400 MHZ .. 2500 MHz
	RADIO_FREQUENCY_MAP_Default = 0x0
	// Channel map between 2360 MHZ .. 2460 MHz
	RADIO_FREQUENCY_MAP_Low = 0x1

	// TXPOWER: Output power
	// Position of TXPOWER field.
	RADIO_TXPOWER_TXPOWER_Pos = 0x0
	// Bit mask of TXPOWER field.
	RADIO_TXPOWER_TXPOWER_Msk = 0xff
	// +8 dBm
	RADIO_TXPOWER_TXPOWER_Pos8dBm = 0x8
	// +7 dBm
	RADIO_TXPOWER_TXPOWER_Pos7dBm = 0x7
	// +6 dBm
	RADIO_TXPOWER_TXPOWER_Pos6dBm = 0x6
	// +5 dBm
	RADIO_TXPOWER_TXPOWER_Pos5dBm = 0x5
	// +4 dBm
	RADIO_TXPOWER_TXPOWER_Pos4dBm = 0x4
	// +3 dBm
	RADIO_TXPOWER_TXPOWER_Pos3dBm = 0x3
	// +2 dBm
	RADIO_TXPOWER_TXPOWER_Pos2dBm = 0x2
	// 0 dBm
	RADIO_TXPOWER_TXPOWER_0dBm = 0x0
	// -4 dBm
	RADIO_TXPOWER_TXPOWER_Neg4dBm = 0xfc
	// -8 dBm
	RADIO_TXPOWER_TXPOWER_Neg8dBm = 0xf8
	// -12 dBm
	RADIO_TXPOWER_TXPOWER_Neg12dBm = 0xf4
	// -16 dBm
	RADIO_TXPOWER_TXPOWER_Neg16dBm = 0xf0
	// -20 dBm
	RADIO_TXPOWER_TXPOWER_Neg20dBm = 0xec
	// Deprecated enumerator - -40 dBm
	RADIO_TXPOWER_TXPOWER_Neg30dBm = 0xe2
	// -40 dBm
	RADIO_TXPOWER_TXPOWER_Neg40dBm = 0xd8

	// MODE: Data rate and modulation
	// Position of MODE field.
	RADIO_MODE_MODE_Pos = 0x0
	// Bit mask of MODE field.
	RADIO_MODE_MODE_Msk = 0xf
	// 1 Mbps Nordic proprietary radio mode
	RADIO_MODE_MODE_Nrf_1Mbit = 0x0
	// 2 Mbps Nordic proprietary radio mode
	RADIO_MODE_MODE_Nrf_2Mbit = 0x1
	// 1 Mbps BLE
	RADIO_MODE_MODE_Ble_1Mbit = 0x3
	// 2 Mbps BLE
	RADIO_MODE_MODE_Ble_2Mbit = 0x4
	// Long range 125 kbps TX, 125 kbps and 500 kbps RX
	RADIO_MODE_MODE_Ble_LR125Kbit = 0x5
	// Long range 500 kbps TX, 125 kbps and 500 kbps RX
	RADIO_MODE_MODE_Ble_LR500Kbit = 0x6
	// IEEE 802.15.4-2006 250 kbps
	RADIO_MODE_MODE_Ieee802154_250Kbit = 0xf

	// PCNF0: Packet configuration register 0
	// Position of LFLEN field.
	RADIO_PCNF0_LFLEN_Pos = 0x0
	// Bit mask of LFLEN field.
	RADIO_PCNF0_LFLEN_Msk = 0xf
	// Position of S0LEN field.
	RADIO_PCNF0_S0LEN_Pos = 0x8
	// Bit mask of S0LEN field.
	RADIO_PCNF0_S0LEN_Msk = 0x100
	// Bit S0LEN.
	RADIO_PCNF0_S0LEN = 0x100
	// Position of S1LEN field.
	RADIO_PCNF0_S1LEN_Pos = 0x10
	// Bit mask of S1LEN field.
	RADIO_PCNF0_S1LEN_Msk = 0xf0000
	// Position of S1INCL field.
	RADIO_PCNF0_S1INCL_Pos = 0x14
	// Bit mask of S1INCL field.
	RADIO_PCNF0_S1INCL_Msk = 0x100000
	// Bit S1INCL.
	RADIO_PCNF0_S1INCL = 0x100000
	// Include S1 field in RAM only if S1LEN &gt; 0
	RADIO_PCNF0_S1INCL_Automatic = 0x0
	// Always include S1 field in RAM independent of S1LEN
	RADIO_PCNF0_S1INCL_Include = 0x1
	// Position of CILEN field.
	RADIO_PCNF0_CILEN_Pos = 0x16
	// Bit mask of CILEN field.
	RADIO_PCNF0_CILEN_Msk = 0xc00000
	// Position of PLEN field.
	RADIO_PCNF0_PLEN_Pos = 0x18
	// Bit mask of PLEN field.
	RADIO_PCNF0_PLEN_Msk = 0x3000000
	// 8-bit preamble
	RADIO_PCNF0_PLEN_8bit = 0x0
	// 16-bit preamble
	RADIO_PCNF0_PLEN_16bit = 0x1
	// 32-bit zero preamble - used for IEEE 802.15.4
	RADIO_PCNF0_PLEN_32bitZero = 0x2
	// Preamble - used for BLE long range
	RADIO_PCNF0_PLEN_LongRange = 0x3
	// Position of CRCINC field.
	RADIO_PCNF0_CRCINC_Pos = 0x1a
	// Bit mask of CRCINC field.
	RADIO_PCNF0_CRCINC_Msk = 0x4000000
	// Bit CRCINC.
	RADIO_PCNF0_CRCINC = 0x4000000
	// LENGTH does not contain CRC
	RADIO_PCNF0_CRCINC_Exclude = 0x0
	// LENGTH includes CRC
	RADIO_PCNF0_CRCINC_Include = 0x1
	// Position of TERMLEN field.
	RADIO_PCNF0_TERMLEN_Pos = 0x1d
	// Bit mask of TERMLEN field.
	RADIO_PCNF0_TERMLEN_Msk = 0x60000000

	// PCNF1: Packet configuration register 1
	// Position of MAXLEN field.
	RADIO_PCNF1_MAXLEN_Pos = 0x0
	// Bit mask of MAXLEN field.
	RADIO_PCNF1_MAXLEN_Msk = 0xff
	// Position of STATLEN field.
	RADIO_PCNF1_STATLEN_Pos = 0x8
	// Bit mask of STATLEN field.
	RADIO_PCNF1_STATLEN_Msk = 0xff00
	// Position of BALEN field.
	RADIO_PCNF1_BALEN_Pos = 0x10
	// Bit mask of BALEN field.
	RADIO_PCNF1_BALEN_Msk = 0x70000
	// Position of ENDIAN field.
	RADIO_PCNF1_ENDIAN_Pos = 0x18
	// Bit mask of ENDIAN field.
	RADIO_PCNF1_ENDIAN_Msk = 0x1000000
	// Bit ENDIAN.
	RADIO_PCNF1_ENDIAN = 0x1000000
	// Least significant bit on air first
	RADIO_PCNF1_ENDIAN_Little = 0x0
	// Most significant bit on air first
	RADIO_PCNF1_ENDIAN_Big = 0x1
	// Position of WHITEEN field.
	RADIO_PCNF1_WHITEEN_Pos = 0x19
	// Bit mask of WHITEEN field.
	RADIO_PCNF1_WHITEEN_Msk = 0x2000000
	// Bit WHITEEN.
	RADIO_PCNF1_WHITEEN = 0x2000000
	// Disable
	RADIO_PCNF1_WHITEEN_Disabled = 0x0
	// Enable
	RADIO_PCNF1_WHITEEN_Enabled = 0x1

	// BASE0: Base address 0
	// Position of BASE0 field.
	RADIO_BASE0_BASE0_Pos = 0x0
	// Bit mask of BASE0 field.
	RADIO_BASE0_BASE0_Msk = 0xffffffff

	// BASE1: Base address 1
	// Position of BASE1 field.
	RADIO_BASE1_BASE1_Pos = 0x0
	// Bit mask of BASE1 field.
	RADIO_BASE1_BASE1_Msk = 0xffffffff

	// PREFIX0: Prefixes bytes for logical addresses 0-3
	// Position of AP0 field.
	RADIO_PREFIX0_AP0_Pos = 0x0
	// Bit mask of AP0 field.
	RADIO_PREFIX0_AP0_Msk = 0xff
	// Position of AP1 field.
	RADIO_PREFIX0_AP1_Pos = 0x8
	// Bit mask of AP1 field.
	RADIO_PREFIX0_AP1_Msk = 0xff00
	// Position of AP2 field.
	RADIO_PREFIX0_AP2_Pos = 0x10
	// Bit mask of AP2 field.
	RADIO_PREFIX0_AP2_Msk = 0xff0000
	// Position of AP3 field.
	RADIO_PREFIX0_AP3_Pos = 0x18
	// Bit mask of AP3 field.
	RADIO_PREFIX0_AP3_Msk = 0xff000000

	// PREFIX1: Prefixes bytes for logical addresses 4-7
	// Position of AP4 field.
	RADIO_PREFIX1_AP4_Pos = 0x0
	// Bit mask of AP4 field.
	RADIO_PREFIX1_AP4_Msk = 0xff
	// Position of AP5 field.
	RADIO_PREFIX1_AP5_Pos = 0x8
	// Bit mask of AP5 field.
	RADIO_PREFIX1_AP5_Msk = 0xff00
	// Position of AP6 field.
	RADIO_PREFIX1_AP6_Pos = 0x10
	// Bit mask of AP6 field.
	RADIO_PREFIX1_AP6_Msk = 0xff0000
	// Position of AP7 field.
	RADIO_PREFIX1_AP7_Pos = 0x18
	// Bit mask of AP7 field.
	RADIO_PREFIX1_AP7_Msk = 0xff000000

	// TXADDRESS: Transmit address select
	// Position of TXADDRESS field.
	RADIO_TXADDRESS_TXADDRESS_Pos = 0x0
	// Bit mask of TXADDRESS field.
	RADIO_TXADDRESS_TXADDRESS_Msk = 0x7

	// RXADDRESSES: Receive address select
	// Position of ADDR0 field.
	RADIO_RXADDRESSES_ADDR0_Pos = 0x0
	// Bit mask of ADDR0 field.
	RADIO_RXADDRESSES_ADDR0_Msk = 0x1
	// Bit ADDR0.
	RADIO_RXADDRESSES_ADDR0 = 0x1
	// Disable
	RADIO_RXADDRESSES_ADDR0_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR0_Enabled = 0x1
	// Position of ADDR1 field.
	RADIO_RXADDRESSES_ADDR1_Pos = 0x1
	// Bit mask of ADDR1 field.
	RADIO_RXADDRESSES_ADDR1_Msk = 0x2
	// Bit ADDR1.
	RADIO_RXADDRESSES_ADDR1 = 0x2
	// Disable
	RADIO_RXADDRESSES_ADDR1_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR1_Enabled = 0x1
	// Position of ADDR2 field.
	RADIO_RXADDRESSES_ADDR2_Pos = 0x2
	// Bit mask of ADDR2 field.
	RADIO_RXADDRESSES_ADDR2_Msk = 0x4
	// Bit ADDR2.
	RADIO_RXADDRESSES_ADDR2 = 0x4
	// Disable
	RADIO_RXADDRESSES_ADDR2_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR2_Enabled = 0x1
	// Position of ADDR3 field.
	RADIO_RXADDRESSES_ADDR3_Pos = 0x3
	// Bit mask of ADDR3 field.
	RADIO_RXADDRESSES_ADDR3_Msk = 0x8
	// Bit ADDR3.
	RADIO_RXADDRESSES_ADDR3 = 0x8
	// Disable
	RADIO_RXADDRESSES_ADDR3_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR3_Enabled = 0x1
	// Position of ADDR4 field.
	RADIO_RXADDRESSES_ADDR4_Pos = 0x4
	// Bit mask of ADDR4 field.
	RADIO_RXADDRESSES_ADDR4_Msk = 0x10
	// Bit ADDR4.
	RADIO_RXADDRESSES_ADDR4 = 0x10
	// Disable
	RADIO_RXADDRESSES_ADDR4_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR4_Enabled = 0x1
	// Position of ADDR5 field.
	RADIO_RXADDRESSES_ADDR5_Pos = 0x5
	// Bit mask of ADDR5 field.
	RADIO_RXADDRESSES_ADDR5_Msk = 0x20
	// Bit ADDR5.
	RADIO_RXADDRESSES_ADDR5 = 0x20
	// Disable
	RADIO_RXADDRESSES_ADDR5_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR5_Enabled = 0x1
	// Position of ADDR6 field.
	RADIO_RXADDRESSES_ADDR6_Pos = 0x6
	// Bit mask of ADDR6 field.
	RADIO_RXADDRESSES_ADDR6_Msk = 0x40
	// Bit ADDR6.
	RADIO_RXADDRESSES_ADDR6 = 0x40
	// Disable
	RADIO_RXADDRESSES_ADDR6_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR6_Enabled = 0x1
	// Position of ADDR7 field.
	RADIO_RXADDRESSES_ADDR7_Pos = 0x7
	// Bit mask of ADDR7 field.
	RADIO_RXADDRESSES_ADDR7_Msk = 0x80
	// Bit ADDR7.
	RADIO_RXADDRESSES_ADDR7 = 0x80
	// Disable
	RADIO_RXADDRESSES_ADDR7_Disabled = 0x0
	// Enable
	RADIO_RXADDRESSES_ADDR7_Enabled = 0x1

	// CRCCNF: CRC configuration
	// Position of LEN field.
	RADIO_CRCCNF_LEN_Pos = 0x0
	// Bit mask of LEN field.
	RADIO_CRCCNF_LEN_Msk = 0x3
	// CRC length is zero and CRC calculation is disabled
	RADIO_CRCCNF_LEN_Disabled = 0x0
	// CRC length is one byte and CRC calculation is enabled
	RADIO_CRCCNF_LEN_One = 0x1
	// CRC length is two bytes and CRC calculation is enabled
	RADIO_CRCCNF_LEN_Two = 0x2
	// CRC length is three bytes and CRC calculation is enabled
	RADIO_CRCCNF_LEN_Three = 0x3
	// Position of SKIPADDR field.
	RADIO_CRCCNF_SKIPADDR_Pos = 0x8
	// Bit mask of SKIPADDR field.
	RADIO_CRCCNF_SKIPADDR_Msk = 0x300
	// CRC calculation includes address field
	RADIO_CRCCNF_SKIPADDR_Include = 0x0
	// CRC calculation does not include address field. The CRC calculation will start at the first byte after the address.
	RADIO_CRCCNF_SKIPADDR_Skip = 0x1
	// CRC calculation as per 802.15.4 standard. Starting at first byte after length field.
	RADIO_CRCCNF_SKIPADDR_Ieee802154 = 0x2

	// CRCPOLY: CRC polynomial
	// Position of CRCPOLY field.
	RADIO_CRCPOLY_CRCPOLY_Pos = 0x0
	// Bit mask of CRCPOLY field.
	RADIO_CRCPOLY_CRCPOLY_Msk = 0xffffff

	// CRCINIT: CRC initial value
	// Position of CRCINIT field.
	RADIO_CRCINIT_CRCINIT_Pos = 0x0
	// Bit mask of CRCINIT field.
	RADIO_CRCINIT_CRCINIT_Msk = 0xffffff

	// TIFS: Interframe spacing in us
	// Position of TIFS field.
	RADIO_TIFS_TIFS_Pos = 0x0
	// Bit mask of TIFS field.
	RADIO_TIFS_TIFS_Msk = 0x3ff

	// RSSISAMPLE: RSSI sample
	// Position of RSSISAMPLE field.
	RADIO_RSSISAMPLE_RSSISAMPLE_Pos = 0x0
	// Bit mask of RSSISAMPLE field.
	RADIO_RSSISAMPLE_RSSISAMPLE_Msk = 0x7f

	// STATE: Current radio state
	// Position of STATE field.
	RADIO_STATE_STATE_Pos = 0x0
	// Bit mask of STATE field.
	RADIO_STATE_STATE_Msk = 0xf
	// RADIO is in the Disabled state
	RADIO_STATE_STATE_Disabled = 0x0
	// RADIO is in the RXRU state
	RADIO_STATE_STATE_RxRu = 0x1
	// RADIO is in the RXIDLE state
	RADIO_STATE_STATE_RxIdle = 0x2
	// RADIO is in the RX state
	RADIO_STATE_STATE_Rx = 0x3
	// RADIO is in the RXDISABLED state
	RADIO_STATE_STATE_RxDisable = 0x4
	// RADIO is in the TXRU state
	RADIO_STATE_STATE_TxRu = 0x9
	// RADIO is in the TXIDLE state
	RADIO_STATE_STATE_TxIdle = 0xa
	// RADIO is in the TX state
	RADIO_STATE_STATE_Tx = 0xb
	// RADIO is in the TXDISABLED state
	RADIO_STATE_STATE_TxDisable = 0xc

	// DATAWHITEIV: Data whitening initial value
	// Position of DATAWHITEIV field.
	RADIO_DATAWHITEIV_DATAWHITEIV_Pos = 0x0
	// Bit mask of DATAWHITEIV field.
	RADIO_DATAWHITEIV_DATAWHITEIV_Msk = 0x7f

	// BCC: Bit counter compare
	// Position of BCC field.
	RADIO_BCC_BCC_Pos = 0x0
	// Bit mask of BCC field.
	RADIO_BCC_BCC_Msk = 0xffffffff

	// DAB: Description collection: Device address base segment n
	// Position of DAB field.
	RADIO_DAB_DAB_Pos = 0x0
	// Bit mask of DAB field.
	RADIO_DAB_DAB_Msk = 0xffffffff

	// DAP: Description collection: Device address prefix n
	// Position of DAP field.
	RADIO_DAP_DAP_Pos = 0x0
	// Bit mask of DAP field.
	RADIO_DAP_DAP_Msk = 0xffff

	// DACNF: Device address match configuration
	// Position of ENA0 field.
	RADIO_DACNF_ENA0_Pos = 0x0
	// Bit mask of ENA0 field.
	RADIO_DACNF_ENA0_Msk = 0x1
	// Bit ENA0.
	RADIO_DACNF_ENA0 = 0x1
	// Disabled
	RADIO_DACNF_ENA0_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA0_Enabled = 0x1
	// Position of ENA1 field.
	RADIO_DACNF_ENA1_Pos = 0x1
	// Bit mask of ENA1 field.
	RADIO_DACNF_ENA1_Msk = 0x2
	// Bit ENA1.
	RADIO_DACNF_ENA1 = 0x2
	// Disabled
	RADIO_DACNF_ENA1_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA1_Enabled = 0x1
	// Position of ENA2 field.
	RADIO_DACNF_ENA2_Pos = 0x2
	// Bit mask of ENA2 field.
	RADIO_DACNF_ENA2_Msk = 0x4
	// Bit ENA2.
	RADIO_DACNF_ENA2 = 0x4
	// Disabled
	RADIO_DACNF_ENA2_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA2_Enabled = 0x1
	// Position of ENA3 field.
	RADIO_DACNF_ENA3_Pos = 0x3
	// Bit mask of ENA3 field.
	RADIO_DACNF_ENA3_Msk = 0x8
	// Bit ENA3.
	RADIO_DACNF_ENA3 = 0x8
	// Disabled
	RADIO_DACNF_ENA3_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA3_Enabled = 0x1
	// Position of ENA4 field.
	RADIO_DACNF_ENA4_Pos = 0x4
	// Bit mask of ENA4 field.
	RADIO_DACNF_ENA4_Msk = 0x10
	// Bit ENA4.
	RADIO_DACNF_ENA4 = 0x10
	// Disabled
	RADIO_DACNF_ENA4_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA4_Enabled = 0x1
	// Position of ENA5 field.
	RADIO_DACNF_ENA5_Pos = 0x5
	// Bit mask of ENA5 field.
	RADIO_DACNF_ENA5_Msk = 0x20
	// Bit ENA5.
	RADIO_DACNF_ENA5 = 0x20
	// Disabled
	RADIO_DACNF_ENA5_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA5_Enabled = 0x1
	// Position of ENA6 field.
	RADIO_DACNF_ENA6_Pos = 0x6
	// Bit mask of ENA6 field.
	RADIO_DACNF_ENA6_Msk = 0x40
	// Bit ENA6.
	RADIO_DACNF_ENA6 = 0x40
	// Disabled
	RADIO_DACNF_ENA6_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA6_Enabled = 0x1
	// Position of ENA7 field.
	RADIO_DACNF_ENA7_Pos = 0x7
	// Bit mask of ENA7 field.
	RADIO_DACNF_ENA7_Msk = 0x80
	// Bit ENA7.
	RADIO_DACNF_ENA7 = 0x80
	// Disabled
	RADIO_DACNF_ENA7_Disabled = 0x0
	// Enabled
	RADIO_DACNF_ENA7_Enabled = 0x1
	// Position of TXADD0 field.
	RADIO_DACNF_TXADD0_Pos = 0x8
	// Bit mask of TXADD0 field.
	RADIO_DACNF_TXADD0_Msk = 0x100
	// Bit TXADD0.
	RADIO_DACNF_TXADD0 = 0x100
	// Position of TXADD1 field.
	RADIO_DACNF_TXADD1_Pos = 0x9
	// Bit mask of TXADD1 field.
	RADIO_DACNF_TXADD1_Msk = 0x200
	// Bit TXADD1.
	RADIO_DACNF_TXADD1 = 0x200
	// Position of TXADD2 field.
	RADIO_DACNF_TXADD2_Pos = 0xa
	// Bit mask of TXADD2 field.
	RADIO_DACNF_TXADD2_Msk = 0x400
	// Bit TXADD2.
	RADIO_DACNF_TXADD2 = 0x400
	// Position of TXADD3 field.
	RADIO_DACNF_TXADD3_Pos = 0xb
	// Bit mask of TXADD3 field.
	RADIO_DACNF_TXADD3_Msk = 0x800
	// Bit TXADD3.
	RADIO_DACNF_TXADD3 = 0x800
	// Position of TXADD4 field.
	RADIO_DACNF_TXADD4_Pos = 0xc
	// Bit mask of TXADD4 field.
	RADIO_DACNF_TXADD4_Msk = 0x1000
	// Bit TXADD4.
	RADIO_DACNF_TXADD4 = 0x1000
	// Position of TXADD5 field.
	RADIO_DACNF_TXADD5_Pos = 0xd
	// Bit mask of TXADD5 field.
	RADIO_DACNF_TXADD5_Msk = 0x2000
	// Bit TXADD5.
	RADIO_DACNF_TXADD5 = 0x2000
	// Position of TXADD6 field.
	RADIO_DACNF_TXADD6_Pos = 0xe
	// Bit mask of TXADD6 field.
	RADIO_DACNF_TXADD6_Msk = 0x4000
	// Bit TXADD6.
	RADIO_DACNF_TXADD6 = 0x4000
	// Position of TXADD7 field.
	RADIO_DACNF_TXADD7_Pos = 0xf
	// Bit mask of TXADD7 field.
	RADIO_DACNF_TXADD7_Msk = 0x8000
	// Bit TXADD7.
	RADIO_DACNF_TXADD7 = 0x8000

	// MHRMATCHCONF: Search pattern configuration
	// Position of MHRMATCHCONF field.
	RADIO_MHRMATCHCONF_MHRMATCHCONF_Pos = 0x0
	// Bit mask of MHRMATCHCONF field.
	RADIO_MHRMATCHCONF_MHRMATCHCONF_Msk = 0xffffffff

	// MHRMATCHMAS: Pattern mask
	// Position of MHRMATCHMAS field.
	RADIO_MHRMATCHMAS_MHRMATCHMAS_Pos = 0x0
	// Bit mask of MHRMATCHMAS field.
	RADIO_MHRMATCHMAS_MHRMATCHMAS_Msk = 0xffffffff

	// MODECNF0: Radio mode configuration register 0
	// Position of RU field.
	RADIO_MODECNF0_RU_Pos = 0x0
	// Bit mask of RU field.
	RADIO_MODECNF0_RU_Msk = 0x1
	// Bit RU.
	RADIO_MODECNF0_RU = 0x1
	// Default ramp-up time (tRXEN and tTXEN), compatible with firmware written for nRF51
	RADIO_MODECNF0_RU_Default = 0x0
	// Fast ramp-up (tRXEN,FAST and tTXEN,FAST), see electrical specification for more information
	RADIO_MODECNF0_RU_Fast = 0x1
	// Position of DTX field.
	RADIO_MODECNF0_DTX_Pos = 0x8
	// Bit mask of DTX field.
	RADIO_MODECNF0_DTX_Msk = 0x300
	// Transmit '1'
	RADIO_MODECNF0_DTX_B1 = 0x0
	// Transmit '0'
	RADIO_MODECNF0_DTX_B0 = 0x1
	// Transmit center frequency
	RADIO_MODECNF0_DTX_Center = 0x2

	// SFD: IEEE 802.15.4 start of frame delimiter
	// Position of SFD field.
	RADIO_SFD_SFD_Pos = 0x0
	// Bit mask of SFD field.
	RADIO_SFD_SFD_Msk = 0xff

	// EDCNT: IEEE 802.15.4 energy detect loop count
	// Position of EDCNT field.
	RADIO_EDCNT_EDCNT_Pos = 0x0
	// Bit mask of EDCNT field.
	RADIO_EDCNT_EDCNT_Msk = 0x1fffff

	// EDSAMPLE: IEEE 802.15.4 energy detect level
	// Position of EDLVL field.
	RADIO_EDSAMPLE_EDLVL_Pos = 0x0
	// Bit mask of EDLVL field.
	RADIO_EDSAMPLE_EDLVL_Msk = 0xff

	// CCACTRL: IEEE 802.15.4 clear channel assessment control
	// Position of CCAMODE field.
	RADIO_CCACTRL_CCAMODE_Pos = 0x0
	// Bit mask of CCAMODE field.
	RADIO_CCACTRL_CCAMODE_Msk = 0x7
	// Energy above threshold
	RADIO_CCACTRL_CCAMODE_EdMode = 0x0
	// Carrier seen
	RADIO_CCACTRL_CCAMODE_CarrierMode = 0x1
	// Energy above threshold AND carrier seen
	RADIO_CCACTRL_CCAMODE_CarrierAndEdMode = 0x2
	// Energy above threshold OR carrier seen
	RADIO_CCACTRL_CCAMODE_CarrierOrEdMode = 0x3
	// Energy above threshold test mode that will abort when first ED measurement over threshold is seen. No averaging.
	RADIO_CCACTRL_CCAMODE_EdModeTest1 = 0x4
	// Position of CCAEDTHRES field.
	RADIO_CCACTRL_CCAEDTHRES_Pos = 0x8
	// Bit mask of CCAEDTHRES field.
	RADIO_CCACTRL_CCAEDTHRES_Msk = 0xff00
	// Position of CCACORRTHRES field.
	RADIO_CCACTRL_CCACORRTHRES_Pos = 0x10
	// Bit mask of CCACORRTHRES field.
	RADIO_CCACTRL_CCACORRTHRES_Msk = 0xff0000
	// Position of CCACORRCNT field.
	RADIO_CCACTRL_CCACORRCNT_Pos = 0x18
	// Bit mask of CCACORRCNT field.
	RADIO_CCACTRL_CCACORRCNT_Msk = 0xff000000

	// DFEMODE: Whether to use Angle-of-Arrival (AOA) or Angle-of-Departure (AOD)
	// Position of DFEOPMODE field.
	RADIO_DFEMODE_DFEOPMODE_Pos = 0x0
	// Bit mask of DFEOPMODE field.
	RADIO_DFEMODE_DFEOPMODE_Msk = 0x3
	// Direction finding mode disabled
	RADIO_DFEMODE_DFEOPMODE_Disabled = 0x0
	// Direction finding mode set to AoD
	RADIO_DFEMODE_DFEOPMODE_AoD = 0x2
	// Direction finding mode set to AoA
	RADIO_DFEMODE_DFEOPMODE_AoA = 0x3

	// CTEINLINECONF: Configuration for CTE inline mode
	// Position of CTEINLINECTRLEN field.
	RADIO_CTEINLINECONF_CTEINLINECTRLEN_Pos = 0x0
	// Bit mask of CTEINLINECTRLEN field.
	RADIO_CTEINLINECONF_CTEINLINECTRLEN_Msk = 0x1
	// Bit CTEINLINECTRLEN.
	RADIO_CTEINLINECONF_CTEINLINECTRLEN = 0x1
	// Parsing of CTEInfo is enabled
	RADIO_CTEINLINECONF_CTEINLINECTRLEN_Enabled = 0x1
	// Parsing of CTEInfo is disabled
	RADIO_CTEINLINECONF_CTEINLINECTRLEN_Disabled = 0x0
	// Position of CTEINFOINS1 field.
	RADIO_CTEINLINECONF_CTEINFOINS1_Pos = 0x3
	// Bit mask of CTEINFOINS1 field.
	RADIO_CTEINLINECONF_CTEINFOINS1_Msk = 0x8
	// Bit CTEINFOINS1.
	RADIO_CTEINLINECONF_CTEINFOINS1 = 0x8
	// CTEInfo is in S1 byte (data PDU)
	RADIO_CTEINLINECONF_CTEINFOINS1_InS1 = 0x1
	// CTEInfo is NOT in S1 byte (advertising PDU)
	RADIO_CTEINLINECONF_CTEINFOINS1_NotInS1 = 0x0
	// Position of CTEERRORHANDLING field.
	RADIO_CTEINLINECONF_CTEERRORHANDLING_Pos = 0x4
	// Bit mask of CTEERRORHANDLING field.
	RADIO_CTEINLINECONF_CTEERRORHANDLING_Msk = 0x10
	// Bit CTEERRORHANDLING.
	RADIO_CTEINLINECONF_CTEERRORHANDLING = 0x10
	// Sampling and antenna switching also when CRC is not OK
	RADIO_CTEINLINECONF_CTEERRORHANDLING_Yes = 0x1
	// No sampling and antenna switching when CRC is not OK
	RADIO_CTEINLINECONF_CTEERRORHANDLING_No = 0x0
	// Position of CTETIMEVALIDRANGE field.
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_Pos = 0x6
	// Bit mask of CTETIMEVALIDRANGE field.
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_Msk = 0xc0
	// 20 in 8us unit (default) Set to 20 if parsed CTETime is larger han 20
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_20 = 0x0
	// 31 in 8us unit
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_31 = 0x1
	// 63 in 8us unit
	RADIO_CTEINLINECONF_CTETIMEVALIDRANGE_63 = 0x2
	// Position of CTEINLINERXMODE1US field.
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_Pos = 0xa
	// Bit mask of CTEINLINERXMODE1US field.
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_Msk = 0x1c00
	// 4us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_4us = 0x1
	// 2us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_2us = 0x2
	// 1us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_1us = 0x3
	// 0.5us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_500ns = 0x4
	// 0.25us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_250ns = 0x5
	// 0.125us
	RADIO_CTEINLINECONF_CTEINLINERXMODE1US_125ns = 0x6
	// Position of CTEINLINERXMODE2US field.
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_Pos = 0xd
	// Bit mask of CTEINLINERXMODE2US field.
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_Msk = 0xe000
	// 4us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_4us = 0x1
	// 2us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_2us = 0x2
	// 1us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_1us = 0x3
	// 0.5us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_500ns = 0x4
	// 0.25us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_250ns = 0x5
	// 0.125us
	RADIO_CTEINLINECONF_CTEINLINERXMODE2US_125ns = 0x6
	// Position of S0CONF field.
	RADIO_CTEINLINECONF_S0CONF_Pos = 0x10
	// Bit mask of S0CONF field.
	RADIO_CTEINLINECONF_S0CONF_Msk = 0xff0000
	// Position of S0MASK field.
	RADIO_CTEINLINECONF_S0MASK_Pos = 0x18
	// Bit mask of S0MASK field.
	RADIO_CTEINLINECONF_S0MASK_Msk = 0xff000000

	// DFECTRL1: Various configuration for Direction finding
	// Position of NUMBEROF8US field.
	RADIO_DFECTRL1_NUMBEROF8US_Pos = 0x0
	// Bit mask of NUMBEROF8US field.
	RADIO_DFECTRL1_NUMBEROF8US_Msk = 0x3f
	// Position of DFEINEXTENSION field.
	RADIO_DFECTRL1_DFEINEXTENSION_Pos = 0x7
	// Bit mask of DFEINEXTENSION field.
	RADIO_DFECTRL1_DFEINEXTENSION_Msk = 0x80
	// Bit DFEINEXTENSION.
	RADIO_DFECTRL1_DFEINEXTENSION = 0x80
	// AoA/AoD procedure triggered at end of CRC
	RADIO_DFECTRL1_DFEINEXTENSION_CRC = 0x1
	// Antenna switching/sampling is done in the packet payload
	RADIO_DFECTRL1_DFEINEXTENSION_Payload = 0x0
	// Position of TSWITCHSPACING field.
	RADIO_DFECTRL1_TSWITCHSPACING_Pos = 0x8
	// Bit mask of TSWITCHSPACING field.
	RADIO_DFECTRL1_TSWITCHSPACING_Msk = 0x700
	// 4us
	RADIO_DFECTRL1_TSWITCHSPACING_4us = 0x1
	// 2us
	RADIO_DFECTRL1_TSWITCHSPACING_2us = 0x2
	// 1us
	RADIO_DFECTRL1_TSWITCHSPACING_1us = 0x3
	// Position of TSAMPLESPACINGREF field.
	RADIO_DFECTRL1_TSAMPLESPACINGREF_Pos = 0xc
	// Bit mask of TSAMPLESPACINGREF field.
	RADIO_DFECTRL1_TSAMPLESPACINGREF_Msk = 0x7000
	// 4us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_4us = 0x1
	// 2us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_2us = 0x2
	// 1us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_1us = 0x3
	// 0.5us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_500ns = 0x4
	// 0.25us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_250ns = 0x5
	// 0.125us
	RADIO_DFECTRL1_TSAMPLESPACINGREF_125ns = 0x6
	// Position of SAMPLETYPE field.
	RADIO_DFECTRL1_SAMPLETYPE_Pos = 0xf
	// Bit mask of SAMPLETYPE field.
	RADIO_DFECTRL1_SAMPLETYPE_Msk = 0x8000
	// Bit SAMPLETYPE.
	RADIO_DFECTRL1_SAMPLETYPE = 0x8000
	// Complex samples in I and Q
	RADIO_DFECTRL1_SAMPLETYPE_IQ = 0x0
	// Complex samples as magnitude and phase
	RADIO_DFECTRL1_SAMPLETYPE_MagPhase = 0x1
	// Position of TSAMPLESPACING field.
	RADIO_DFECTRL1_TSAMPLESPACING_Pos = 0x10
	// Bit mask of TSAMPLESPACING field.
	RADIO_DFECTRL1_TSAMPLESPACING_Msk = 0x70000
	// 4us
	RADIO_DFECTRL1_TSAMPLESPACING_4us = 0x1
	// 2us
	RADIO_DFECTRL1_TSAMPLESPACING_2us = 0x2
	// 1us
	RADIO_DFECTRL1_TSAMPLESPACING_1us = 0x3
	// 0.5us
	RADIO_DFECTRL1_TSAMPLESPACING_500ns = 0x4
	// 0.25us
	RADIO_DFECTRL1_TSAMPLESPACING_250ns = 0x5
	// 0.125us
	RADIO_DFECTRL1_TSAMPLESPACING_125ns = 0x6
	// Position of REPEATPATTERN field.
	RADIO_DFECTRL1_REPEATPATTERN_Pos = 0x14
	// Bit mask of REPEATPATTERN field.
	RADIO_DFECTRL1_REPEATPATTERN_Msk = 0xf00000
	// Do not repeat (1 time in total)
	RADIO_DFECTRL1_REPEATPATTERN_NoRepeat = 0x0
	// Position of AGCBACKOFFGAIN field.
	RADIO_DFECTRL1_AGCBACKOFFGAIN_Pos = 0x18
	// Bit mask of AGCBACKOFFGAIN field.
	RADIO_DFECTRL1_AGCBACKOFFGAIN_Msk = 0xf000000

	// DFECTRL2: Start offset for Direction finding
	// Position of TSWITCHOFFSET field.
	RADIO_DFECTRL2_TSWITCHOFFSET_Pos = 0x0
	// Bit mask of TSWITCHOFFSET field.
	RADIO_DFECTRL2_TSWITCHOFFSET_Msk = 0x1fff
	// Position of TSAMPLEOFFSET field.
	RADIO_DFECTRL2_TSAMPLEOFFSET_Pos = 0x10
	// Bit mask of TSAMPLEOFFSET field.
	RADIO_DFECTRL2_TSAMPLEOFFSET_Msk = 0xfff0000

	// SWITCHPATTERN: GPIO patterns to be used for each antenna
	// Position of SWITCHPATTERN field.
	RADIO_SWITCHPATTERN_SWITCHPATTERN_Pos = 0x0
	// Bit mask of SWITCHPATTERN field.
	RADIO_SWITCHPATTERN_SWITCHPATTERN_Msk = 0xff

	// CLEARPATTERN: Clear the GPIO pattern array for antenna control
	// Position of CLEARPATTERN field.
	RADIO_CLEARPATTERN_CLEARPATTERN_Pos = 0x0
	// Bit mask of CLEARPATTERN field.
	RADIO_CLEARPATTERN_CLEARPATTERN_Msk = 0x1
	// Bit CLEARPATTERN.
	RADIO_CLEARPATTERN_CLEARPATTERN = 0x1
	// Clear the GPIO pattern
	RADIO_CLEARPATTERN_CLEARPATTERN_Clear = 0x1

	// PSEL.DFEGPIO: Description collection: Pin select for DFE pin n
	// Position of PIN field.
	RADIO_PSEL_DFEGPIO_PIN_Pos = 0x0
	// Bit mask of PIN field.
	RADIO_PSEL_DFEGPIO_PIN_Msk = 0x1f
	// Position of PORT field.
	RADIO_PSEL_DFEGPIO_PORT_Pos = 0x5
	// Bit mask of PORT field.
	RADIO_PSEL_DFEGPIO_PORT_Msk = 0x20
	// Bit PORT.
	RADIO_PSEL_DFEGPIO_PORT = 0x20
	// Position of CONNECT field.
	RADIO_PSEL_DFEGPIO_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	RADIO_PSEL_DFEGPIO_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	RADIO_PSEL_DFEGPIO_CONNECT = 0x80000000
	// Disconnect
	RADIO_PSEL_DFEGPIO_CONNECT_Disconnected = 0x1
	// Connect
	RADIO_PSEL_DFEGPIO_CONNECT_Connected = 0x0

	// DFEPACKET.PTR: Data pointer
	// Position of PTR field.
	RADIO_DFEPACKET_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	RADIO_DFEPACKET_PTR_PTR_Msk = 0xffffffff

	// DFEPACKET.MAXCNT: Maximum number of buffer words to transfer
	// Position of MAXCNT field.
	RADIO_DFEPACKET_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	RADIO_DFEPACKET_MAXCNT_MAXCNT_Msk = 0x3fff

	// DFEPACKET.AMOUNT: Number of samples transferred in the last transaction
	// Position of AMOUNT field.
	RADIO_DFEPACKET_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	RADIO_DFEPACKET_AMOUNT_AMOUNT_Msk = 0xffff

	// POWER: Peripheral power control
	// Position of POWER field.
	RADIO_POWER_POWER_Pos = 0x0
	// Bit mask of POWER field.
	RADIO_POWER_POWER_Msk = 0x1
	// Bit POWER.
	RADIO_POWER_POWER = 0x1
	// Peripheral is powered off
	RADIO_POWER_POWER_Disabled = 0x0
	// Peripheral is powered on
	RADIO_POWER_POWER_Enabled = 0x1
)

// Constants for UART0: Universal Asynchronous Receiver/Transmitter
const (
	// TASKS_STARTRX: Start UART receiver
	// Position of TASKS_STARTRX field.
	UART_TASKS_STARTRX_TASKS_STARTRX_Pos = 0x0
	// Bit mask of TASKS_STARTRX field.
	UART_TASKS_STARTRX_TASKS_STARTRX_Msk = 0x1
	// Bit TASKS_STARTRX.
	UART_TASKS_STARTRX_TASKS_STARTRX = 0x1
	// Trigger task
	UART_TASKS_STARTRX_TASKS_STARTRX_Trigger = 0x1

	// TASKS_STOPRX: Stop UART receiver
	// Position of TASKS_STOPRX field.
	UART_TASKS_STOPRX_TASKS_STOPRX_Pos = 0x0
	// Bit mask of TASKS_STOPRX field.
	UART_TASKS_STOPRX_TASKS_STOPRX_Msk = 0x1
	// Bit TASKS_STOPRX.
	UART_TASKS_STOPRX_TASKS_STOPRX = 0x1
	// Trigger task
	UART_TASKS_STOPRX_TASKS_STOPRX_Trigger = 0x1

	// TASKS_STARTTX: Start UART transmitter
	// Position of TASKS_STARTTX field.
	UART_TASKS_STARTTX_TASKS_STARTTX_Pos = 0x0
	// Bit mask of TASKS_STARTTX field.
	UART_TASKS_STARTTX_TASKS_STARTTX_Msk = 0x1
	// Bit TASKS_STARTTX.
	UART_TASKS_STARTTX_TASKS_STARTTX = 0x1
	// Trigger task
	UART_TASKS_STARTTX_TASKS_STARTTX_Trigger = 0x1

	// TASKS_STOPTX: Stop UART transmitter
	// Position of TASKS_STOPTX field.
	UART_TASKS_STOPTX_TASKS_STOPTX_Pos = 0x0
	// Bit mask of TASKS_STOPTX field.
	UART_TASKS_STOPTX_TASKS_STOPTX_Msk = 0x1
	// Bit TASKS_STOPTX.
	UART_TASKS_STOPTX_TASKS_STOPTX = 0x1
	// Trigger task
	UART_TASKS_STOPTX_TASKS_STOPTX_Trigger = 0x1

	// TASKS_SUSPEND: Suspend UART
	// Position of TASKS_SUSPEND field.
	UART_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	UART_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	UART_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	UART_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// EVENTS_CTS: CTS is activated (set low). Clear To Send.
	// Position of EVENTS_CTS field.
	UART_EVENTS_CTS_EVENTS_CTS_Pos = 0x0
	// Bit mask of EVENTS_CTS field.
	UART_EVENTS_CTS_EVENTS_CTS_Msk = 0x1
	// Bit EVENTS_CTS.
	UART_EVENTS_CTS_EVENTS_CTS = 0x1
	// Event not generated
	UART_EVENTS_CTS_EVENTS_CTS_NotGenerated = 0x0
	// Event generated
	UART_EVENTS_CTS_EVENTS_CTS_Generated = 0x1

	// EVENTS_NCTS: CTS is deactivated (set high). Not Clear To Send.
	// Position of EVENTS_NCTS field.
	UART_EVENTS_NCTS_EVENTS_NCTS_Pos = 0x0
	// Bit mask of EVENTS_NCTS field.
	UART_EVENTS_NCTS_EVENTS_NCTS_Msk = 0x1
	// Bit EVENTS_NCTS.
	UART_EVENTS_NCTS_EVENTS_NCTS = 0x1
	// Event not generated
	UART_EVENTS_NCTS_EVENTS_NCTS_NotGenerated = 0x0
	// Event generated
	UART_EVENTS_NCTS_EVENTS_NCTS_Generated = 0x1

	// EVENTS_RXDRDY: Data received in RXD
	// Position of EVENTS_RXDRDY field.
	UART_EVENTS_RXDRDY_EVENTS_RXDRDY_Pos = 0x0
	// Bit mask of EVENTS_RXDRDY field.
	UART_EVENTS_RXDRDY_EVENTS_RXDRDY_Msk = 0x1
	// Bit EVENTS_RXDRDY.
	UART_EVENTS_RXDRDY_EVENTS_RXDRDY = 0x1
	// Event not generated
	UART_EVENTS_RXDRDY_EVENTS_RXDRDY_NotGenerated = 0x0
	// Event generated
	UART_EVENTS_RXDRDY_EVENTS_RXDRDY_Generated = 0x1

	// EVENTS_TXDRDY: Data sent from TXD
	// Position of EVENTS_TXDRDY field.
	UART_EVENTS_TXDRDY_EVENTS_TXDRDY_Pos = 0x0
	// Bit mask of EVENTS_TXDRDY field.
	UART_EVENTS_TXDRDY_EVENTS_TXDRDY_Msk = 0x1
	// Bit EVENTS_TXDRDY.
	UART_EVENTS_TXDRDY_EVENTS_TXDRDY = 0x1
	// Event not generated
	UART_EVENTS_TXDRDY_EVENTS_TXDRDY_NotGenerated = 0x0
	// Event generated
	UART_EVENTS_TXDRDY_EVENTS_TXDRDY_Generated = 0x1

	// EVENTS_ERROR: Error detected
	// Position of EVENTS_ERROR field.
	UART_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	UART_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	UART_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	UART_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	UART_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_RXTO: Receiver timeout
	// Position of EVENTS_RXTO field.
	UART_EVENTS_RXTO_EVENTS_RXTO_Pos = 0x0
	// Bit mask of EVENTS_RXTO field.
	UART_EVENTS_RXTO_EVENTS_RXTO_Msk = 0x1
	// Bit EVENTS_RXTO.
	UART_EVENTS_RXTO_EVENTS_RXTO = 0x1
	// Event not generated
	UART_EVENTS_RXTO_EVENTS_RXTO_NotGenerated = 0x0
	// Event generated
	UART_EVENTS_RXTO_EVENTS_RXTO_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of CTS_STARTRX field.
	UART_SHORTS_CTS_STARTRX_Pos = 0x3
	// Bit mask of CTS_STARTRX field.
	UART_SHORTS_CTS_STARTRX_Msk = 0x8
	// Bit CTS_STARTRX.
	UART_SHORTS_CTS_STARTRX = 0x8
	// Disable shortcut
	UART_SHORTS_CTS_STARTRX_Disabled = 0x0
	// Enable shortcut
	UART_SHORTS_CTS_STARTRX_Enabled = 0x1
	// Position of NCTS_STOPRX field.
	UART_SHORTS_NCTS_STOPRX_Pos = 0x4
	// Bit mask of NCTS_STOPRX field.
	UART_SHORTS_NCTS_STOPRX_Msk = 0x10
	// Bit NCTS_STOPRX.
	UART_SHORTS_NCTS_STOPRX = 0x10
	// Disable shortcut
	UART_SHORTS_NCTS_STOPRX_Disabled = 0x0
	// Enable shortcut
	UART_SHORTS_NCTS_STOPRX_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of CTS field.
	UART_INTENSET_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UART_INTENSET_CTS_Msk = 0x1
	// Bit CTS.
	UART_INTENSET_CTS = 0x1
	// Read: Disabled
	UART_INTENSET_CTS_Disabled = 0x0
	// Read: Enabled
	UART_INTENSET_CTS_Enabled = 0x1
	// Enable
	UART_INTENSET_CTS_Set = 0x1
	// Position of NCTS field.
	UART_INTENSET_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UART_INTENSET_NCTS_Msk = 0x2
	// Bit NCTS.
	UART_INTENSET_NCTS = 0x2
	// Read: Disabled
	UART_INTENSET_NCTS_Disabled = 0x0
	// Read: Enabled
	UART_INTENSET_NCTS_Enabled = 0x1
	// Enable
	UART_INTENSET_NCTS_Set = 0x1
	// Position of RXDRDY field.
	UART_INTENSET_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UART_INTENSET_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UART_INTENSET_RXDRDY = 0x4
	// Read: Disabled
	UART_INTENSET_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UART_INTENSET_RXDRDY_Enabled = 0x1
	// Enable
	UART_INTENSET_RXDRDY_Set = 0x1
	// Position of TXDRDY field.
	UART_INTENSET_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UART_INTENSET_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UART_INTENSET_TXDRDY = 0x80
	// Read: Disabled
	UART_INTENSET_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UART_INTENSET_TXDRDY_Enabled = 0x1
	// Enable
	UART_INTENSET_TXDRDY_Set = 0x1
	// Position of ERROR field.
	UART_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UART_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	UART_INTENSET_ERROR = 0x200
	// Read: Disabled
	UART_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	UART_INTENSET_ERROR_Enabled = 0x1
	// Enable
	UART_INTENSET_ERROR_Set = 0x1
	// Position of RXTO field.
	UART_INTENSET_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UART_INTENSET_RXTO_Msk = 0x20000
	// Bit RXTO.
	UART_INTENSET_RXTO = 0x20000
	// Read: Disabled
	UART_INTENSET_RXTO_Disabled = 0x0
	// Read: Enabled
	UART_INTENSET_RXTO_Enabled = 0x1
	// Enable
	UART_INTENSET_RXTO_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of CTS field.
	UART_INTENCLR_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UART_INTENCLR_CTS_Msk = 0x1
	// Bit CTS.
	UART_INTENCLR_CTS = 0x1
	// Read: Disabled
	UART_INTENCLR_CTS_Disabled = 0x0
	// Read: Enabled
	UART_INTENCLR_CTS_Enabled = 0x1
	// Disable
	UART_INTENCLR_CTS_Clear = 0x1
	// Position of NCTS field.
	UART_INTENCLR_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UART_INTENCLR_NCTS_Msk = 0x2
	// Bit NCTS.
	UART_INTENCLR_NCTS = 0x2
	// Read: Disabled
	UART_INTENCLR_NCTS_Disabled = 0x0
	// Read: Enabled
	UART_INTENCLR_NCTS_Enabled = 0x1
	// Disable
	UART_INTENCLR_NCTS_Clear = 0x1
	// Position of RXDRDY field.
	UART_INTENCLR_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UART_INTENCLR_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UART_INTENCLR_RXDRDY = 0x4
	// Read: Disabled
	UART_INTENCLR_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UART_INTENCLR_RXDRDY_Enabled = 0x1
	// Disable
	UART_INTENCLR_RXDRDY_Clear = 0x1
	// Position of TXDRDY field.
	UART_INTENCLR_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UART_INTENCLR_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UART_INTENCLR_TXDRDY = 0x80
	// Read: Disabled
	UART_INTENCLR_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UART_INTENCLR_TXDRDY_Enabled = 0x1
	// Disable
	UART_INTENCLR_TXDRDY_Clear = 0x1
	// Position of ERROR field.
	UART_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UART_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	UART_INTENCLR_ERROR = 0x200
	// Read: Disabled
	UART_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	UART_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	UART_INTENCLR_ERROR_Clear = 0x1
	// Position of RXTO field.
	UART_INTENCLR_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UART_INTENCLR_RXTO_Msk = 0x20000
	// Bit RXTO.
	UART_INTENCLR_RXTO = 0x20000
	// Read: Disabled
	UART_INTENCLR_RXTO_Disabled = 0x0
	// Read: Enabled
	UART_INTENCLR_RXTO_Enabled = 0x1
	// Disable
	UART_INTENCLR_RXTO_Clear = 0x1

	// ERRORSRC: Error source
	// Position of OVERRUN field.
	UART_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	UART_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	UART_ERRORSRC_OVERRUN = 0x1
	// Read: error not present
	UART_ERRORSRC_OVERRUN_NotPresent = 0x0
	// Read: error present
	UART_ERRORSRC_OVERRUN_Present = 0x1
	// Position of PARITY field.
	UART_ERRORSRC_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UART_ERRORSRC_PARITY_Msk = 0x2
	// Bit PARITY.
	UART_ERRORSRC_PARITY = 0x2
	// Read: error not present
	UART_ERRORSRC_PARITY_NotPresent = 0x0
	// Read: error present
	UART_ERRORSRC_PARITY_Present = 0x1
	// Position of FRAMING field.
	UART_ERRORSRC_FRAMING_Pos = 0x2
	// Bit mask of FRAMING field.
	UART_ERRORSRC_FRAMING_Msk = 0x4
	// Bit FRAMING.
	UART_ERRORSRC_FRAMING = 0x4
	// Read: error not present
	UART_ERRORSRC_FRAMING_NotPresent = 0x0
	// Read: error present
	UART_ERRORSRC_FRAMING_Present = 0x1
	// Position of BREAK field.
	UART_ERRORSRC_BREAK_Pos = 0x3
	// Bit mask of BREAK field.
	UART_ERRORSRC_BREAK_Msk = 0x8
	// Bit BREAK.
	UART_ERRORSRC_BREAK = 0x8
	// Read: error not present
	UART_ERRORSRC_BREAK_NotPresent = 0x0
	// Read: error present
	UART_ERRORSRC_BREAK_Present = 0x1

	// ENABLE: Enable UART
	// Position of ENABLE field.
	UART_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	UART_ENABLE_ENABLE_Msk = 0xf
	// Disable UART
	UART_ENABLE_ENABLE_Disabled = 0x0
	// Enable UART
	UART_ENABLE_ENABLE_Enabled = 0x4

	// PSEL.RTS: Pin select for RTS
	// Position of PIN field.
	UART_PSEL_RTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UART_PSEL_RTS_PIN_Msk = 0x1f
	// Position of PORT field.
	UART_PSEL_RTS_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UART_PSEL_RTS_PORT_Msk = 0x20
	// Bit PORT.
	UART_PSEL_RTS_PORT = 0x20
	// Position of CONNECT field.
	UART_PSEL_RTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UART_PSEL_RTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UART_PSEL_RTS_CONNECT = 0x80000000
	// Disconnect
	UART_PSEL_RTS_CONNECT_Disconnected = 0x1
	// Connect
	UART_PSEL_RTS_CONNECT_Connected = 0x0

	// PSEL.TXD: Pin select for TXD
	// Position of PIN field.
	UART_PSEL_TXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UART_PSEL_TXD_PIN_Msk = 0x1f
	// Position of PORT field.
	UART_PSEL_TXD_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UART_PSEL_TXD_PORT_Msk = 0x20
	// Bit PORT.
	UART_PSEL_TXD_PORT = 0x20
	// Position of CONNECT field.
	UART_PSEL_TXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UART_PSEL_TXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UART_PSEL_TXD_CONNECT = 0x80000000
	// Disconnect
	UART_PSEL_TXD_CONNECT_Disconnected = 0x1
	// Connect
	UART_PSEL_TXD_CONNECT_Connected = 0x0

	// PSEL.CTS: Pin select for CTS
	// Position of PIN field.
	UART_PSEL_CTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UART_PSEL_CTS_PIN_Msk = 0x1f
	// Position of PORT field.
	UART_PSEL_CTS_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UART_PSEL_CTS_PORT_Msk = 0x20
	// Bit PORT.
	UART_PSEL_CTS_PORT = 0x20
	// Position of CONNECT field.
	UART_PSEL_CTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UART_PSEL_CTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UART_PSEL_CTS_CONNECT = 0x80000000
	// Disconnect
	UART_PSEL_CTS_CONNECT_Disconnected = 0x1
	// Connect
	UART_PSEL_CTS_CONNECT_Connected = 0x0

	// PSEL.RXD: Pin select for RXD
	// Position of PIN field.
	UART_PSEL_RXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UART_PSEL_RXD_PIN_Msk = 0x1f
	// Position of PORT field.
	UART_PSEL_RXD_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UART_PSEL_RXD_PORT_Msk = 0x20
	// Bit PORT.
	UART_PSEL_RXD_PORT = 0x20
	// Position of CONNECT field.
	UART_PSEL_RXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UART_PSEL_RXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UART_PSEL_RXD_CONNECT = 0x80000000
	// Disconnect
	UART_PSEL_RXD_CONNECT_Disconnected = 0x1
	// Connect
	UART_PSEL_RXD_CONNECT_Connected = 0x0

	// RXD: RXD register
	// Position of RXD field.
	UART_RXD_RXD_Pos = 0x0
	// Bit mask of RXD field.
	UART_RXD_RXD_Msk = 0xff

	// TXD: TXD register
	// Position of TXD field.
	UART_TXD_TXD_Pos = 0x0
	// Bit mask of TXD field.
	UART_TXD_TXD_Msk = 0xff

	// BAUDRATE: Baud rate. Accuracy depends on the HFCLK source selected.
	// Position of BAUDRATE field.
	UART_BAUDRATE_BAUDRATE_Pos = 0x0
	// Bit mask of BAUDRATE field.
	UART_BAUDRATE_BAUDRATE_Msk = 0xffffffff
	// 1200 baud (actual rate: 1205)
	UART_BAUDRATE_BAUDRATE_Baud1200 = 0x4f000
	// 2400 baud (actual rate: 2396)
	UART_BAUDRATE_BAUDRATE_Baud2400 = 0x9d000
	// 4800 baud (actual rate: 4808)
	UART_BAUDRATE_BAUDRATE_Baud4800 = 0x13b000
	// 9600 baud (actual rate: 9598)
	UART_BAUDRATE_BAUDRATE_Baud9600 = 0x275000
	// 14400 baud (actual rate: 14414)
	UART_BAUDRATE_BAUDRATE_Baud14400 = 0x3b0000
	// 19200 baud (actual rate: 19208)
	UART_BAUDRATE_BAUDRATE_Baud19200 = 0x4ea000
	// 28800 baud (actual rate: 28829)
	UART_BAUDRATE_BAUDRATE_Baud28800 = 0x75f000
	// 31250 baud
	UART_BAUDRATE_BAUDRATE_Baud31250 = 0x800000
	// 38400 baud (actual rate: 38462)
	UART_BAUDRATE_BAUDRATE_Baud38400 = 0x9d5000
	// 56000 baud (actual rate: 55944)
	UART_BAUDRATE_BAUDRATE_Baud56000 = 0xe50000
	// 57600 baud (actual rate: 57762)
	UART_BAUDRATE_BAUDRATE_Baud57600 = 0xebf000
	// 76800 baud (actual rate: 76923)
	UART_BAUDRATE_BAUDRATE_Baud76800 = 0x13a9000
	// 115200 baud (actual rate: 115942)
	UART_BAUDRATE_BAUDRATE_Baud115200 = 0x1d7e000
	// 230400 baud (actual rate: 231884)
	UART_BAUDRATE_BAUDRATE_Baud230400 = 0x3afb000
	// 250000 baud
	UART_BAUDRATE_BAUDRATE_Baud250000 = 0x4000000
	// 460800 baud (actual rate: 470588)
	UART_BAUDRATE_BAUDRATE_Baud460800 = 0x75f7000
	// 921600 baud (actual rate: 941176)
	UART_BAUDRATE_BAUDRATE_Baud921600 = 0xebed000
	// 1Mega baud
	UART_BAUDRATE_BAUDRATE_Baud1M = 0x10000000

	// CONFIG: Configuration of parity and hardware flow control
	// Position of HWFC field.
	UART_CONFIG_HWFC_Pos = 0x0
	// Bit mask of HWFC field.
	UART_CONFIG_HWFC_Msk = 0x1
	// Bit HWFC.
	UART_CONFIG_HWFC = 0x1
	// Disabled
	UART_CONFIG_HWFC_Disabled = 0x0
	// Enabled
	UART_CONFIG_HWFC_Enabled = 0x1
	// Position of PARITY field.
	UART_CONFIG_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UART_CONFIG_PARITY_Msk = 0xe
	// Exclude parity bit
	UART_CONFIG_PARITY_Excluded = 0x0
	// Include parity bit
	UART_CONFIG_PARITY_Included = 0x7
	// Position of STOP field.
	UART_CONFIG_STOP_Pos = 0x4
	// Bit mask of STOP field.
	UART_CONFIG_STOP_Msk = 0x10
	// Bit STOP.
	UART_CONFIG_STOP = 0x10
	// One stop bit
	UART_CONFIG_STOP_One = 0x0
	// Two stop bits
	UART_CONFIG_STOP_Two = 0x1
	// Position of PARITYTYPE field.
	UART_CONFIG_PARITYTYPE_Pos = 0x8
	// Bit mask of PARITYTYPE field.
	UART_CONFIG_PARITYTYPE_Msk = 0x100
	// Bit PARITYTYPE.
	UART_CONFIG_PARITYTYPE = 0x100
	// Even parity
	UART_CONFIG_PARITYTYPE_Even = 0x0
	// Odd parity
	UART_CONFIG_PARITYTYPE_Odd = 0x1
)

// Constants for UARTE0: UART with EasyDMA 0
const (
	// TASKS_STARTRX: Start UART receiver
	// Position of TASKS_STARTRX field.
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Pos = 0x0
	// Bit mask of TASKS_STARTRX field.
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Msk = 0x1
	// Bit TASKS_STARTRX.
	UARTE_TASKS_STARTRX_TASKS_STARTRX = 0x1
	// Trigger task
	UARTE_TASKS_STARTRX_TASKS_STARTRX_Trigger = 0x1

	// TASKS_STOPRX: Stop UART receiver
	// Position of TASKS_STOPRX field.
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Pos = 0x0
	// Bit mask of TASKS_STOPRX field.
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Msk = 0x1
	// Bit TASKS_STOPRX.
	UARTE_TASKS_STOPRX_TASKS_STOPRX = 0x1
	// Trigger task
	UARTE_TASKS_STOPRX_TASKS_STOPRX_Trigger = 0x1

	// TASKS_STARTTX: Start UART transmitter
	// Position of TASKS_STARTTX field.
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Pos = 0x0
	// Bit mask of TASKS_STARTTX field.
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Msk = 0x1
	// Bit TASKS_STARTTX.
	UARTE_TASKS_STARTTX_TASKS_STARTTX = 0x1
	// Trigger task
	UARTE_TASKS_STARTTX_TASKS_STARTTX_Trigger = 0x1

	// TASKS_STOPTX: Stop UART transmitter
	// Position of TASKS_STOPTX field.
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Pos = 0x0
	// Bit mask of TASKS_STOPTX field.
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Msk = 0x1
	// Bit TASKS_STOPTX.
	UARTE_TASKS_STOPTX_TASKS_STOPTX = 0x1
	// Trigger task
	UARTE_TASKS_STOPTX_TASKS_STOPTX_Trigger = 0x1

	// TASKS_FLUSHRX: Flush RX FIFO into RX buffer
	// Position of TASKS_FLUSHRX field.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Pos = 0x0
	// Bit mask of TASKS_FLUSHRX field.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Msk = 0x1
	// Bit TASKS_FLUSHRX.
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX = 0x1
	// Trigger task
	UARTE_TASKS_FLUSHRX_TASKS_FLUSHRX_Trigger = 0x1

	// EVENTS_CTS: CTS is activated (set low). Clear To Send.
	// Position of EVENTS_CTS field.
	UARTE_EVENTS_CTS_EVENTS_CTS_Pos = 0x0
	// Bit mask of EVENTS_CTS field.
	UARTE_EVENTS_CTS_EVENTS_CTS_Msk = 0x1
	// Bit EVENTS_CTS.
	UARTE_EVENTS_CTS_EVENTS_CTS = 0x1
	// Event not generated
	UARTE_EVENTS_CTS_EVENTS_CTS_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_CTS_EVENTS_CTS_Generated = 0x1

	// EVENTS_NCTS: CTS is deactivated (set high). Not Clear To Send.
	// Position of EVENTS_NCTS field.
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Pos = 0x0
	// Bit mask of EVENTS_NCTS field.
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Msk = 0x1
	// Bit EVENTS_NCTS.
	UARTE_EVENTS_NCTS_EVENTS_NCTS = 0x1
	// Event not generated
	UARTE_EVENTS_NCTS_EVENTS_NCTS_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_NCTS_EVENTS_NCTS_Generated = 0x1

	// EVENTS_RXDRDY: Data received in RXD (but potentially not yet transferred to Data RAM)
	// Position of EVENTS_RXDRDY field.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Pos = 0x0
	// Bit mask of EVENTS_RXDRDY field.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Msk = 0x1
	// Bit EVENTS_RXDRDY.
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY = 0x1
	// Event not generated
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXDRDY_EVENTS_RXDRDY_Generated = 0x1

	// EVENTS_ENDRX: Receive buffer is filled up
	// Position of EVENTS_ENDRX field.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_TXDRDY: Data sent from TXD
	// Position of EVENTS_TXDRDY field.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Pos = 0x0
	// Bit mask of EVENTS_TXDRDY field.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Msk = 0x1
	// Bit EVENTS_TXDRDY.
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY = 0x1
	// Event not generated
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXDRDY_EVENTS_TXDRDY_Generated = 0x1

	// EVENTS_ENDTX: Last TX byte transmitted
	// Position of EVENTS_ENDTX field.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Pos = 0x0
	// Bit mask of EVENTS_ENDTX field.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Msk = 0x1
	// Bit EVENTS_ENDTX.
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX = 0x1
	// Event not generated
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ENDTX_EVENTS_ENDTX_Generated = 0x1

	// EVENTS_ERROR: Error detected
	// Position of EVENTS_ERROR field.
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Pos = 0x0
	// Bit mask of EVENTS_ERROR field.
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Msk = 0x1
	// Bit EVENTS_ERROR.
	UARTE_EVENTS_ERROR_EVENTS_ERROR = 0x1
	// Event not generated
	UARTE_EVENTS_ERROR_EVENTS_ERROR_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_ERROR_EVENTS_ERROR_Generated = 0x1

	// EVENTS_RXTO: Receiver timeout
	// Position of EVENTS_RXTO field.
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Pos = 0x0
	// Bit mask of EVENTS_RXTO field.
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Msk = 0x1
	// Bit EVENTS_RXTO.
	UARTE_EVENTS_RXTO_EVENTS_RXTO = 0x1
	// Event not generated
	UARTE_EVENTS_RXTO_EVENTS_RXTO_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXTO_EVENTS_RXTO_Generated = 0x1

	// EVENTS_RXSTARTED: UART receiver has started
	// Position of EVENTS_RXSTARTED field.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_RXSTARTED field.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Msk = 0x1
	// Bit EVENTS_RXSTARTED.
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED = 0x1
	// Event not generated
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_RXSTARTED_EVENTS_RXSTARTED_Generated = 0x1

	// EVENTS_TXSTARTED: UART transmitter has started
	// Position of EVENTS_TXSTARTED field.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Pos = 0x0
	// Bit mask of EVENTS_TXSTARTED field.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Msk = 0x1
	// Bit EVENTS_TXSTARTED.
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED = 0x1
	// Event not generated
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXSTARTED_EVENTS_TXSTARTED_Generated = 0x1

	// EVENTS_TXSTOPPED: Transmitter stopped
	// Position of EVENTS_TXSTOPPED field.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Pos = 0x0
	// Bit mask of EVENTS_TXSTOPPED field.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Msk = 0x1
	// Bit EVENTS_TXSTOPPED.
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED = 0x1
	// Event not generated
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_NotGenerated = 0x0
	// Event generated
	UARTE_EVENTS_TXSTOPPED_EVENTS_TXSTOPPED_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of ENDRX_STARTRX field.
	UARTE_SHORTS_ENDRX_STARTRX_Pos = 0x5
	// Bit mask of ENDRX_STARTRX field.
	UARTE_SHORTS_ENDRX_STARTRX_Msk = 0x20
	// Bit ENDRX_STARTRX.
	UARTE_SHORTS_ENDRX_STARTRX = 0x20
	// Disable shortcut
	UARTE_SHORTS_ENDRX_STARTRX_Disabled = 0x0
	// Enable shortcut
	UARTE_SHORTS_ENDRX_STARTRX_Enabled = 0x1
	// Position of ENDRX_STOPRX field.
	UARTE_SHORTS_ENDRX_STOPRX_Pos = 0x6
	// Bit mask of ENDRX_STOPRX field.
	UARTE_SHORTS_ENDRX_STOPRX_Msk = 0x40
	// Bit ENDRX_STOPRX.
	UARTE_SHORTS_ENDRX_STOPRX = 0x40
	// Disable shortcut
	UARTE_SHORTS_ENDRX_STOPRX_Disabled = 0x0
	// Enable shortcut
	UARTE_SHORTS_ENDRX_STOPRX_Enabled = 0x1

	// INTEN: Enable or disable interrupt
	// Position of CTS field.
	UARTE_INTEN_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTEN_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTEN_CTS = 0x1
	// Disable
	UARTE_INTEN_CTS_Disabled = 0x0
	// Enable
	UARTE_INTEN_CTS_Enabled = 0x1
	// Position of NCTS field.
	UARTE_INTEN_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTEN_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTEN_NCTS = 0x2
	// Disable
	UARTE_INTEN_NCTS_Disabled = 0x0
	// Enable
	UARTE_INTEN_NCTS_Enabled = 0x1
	// Position of RXDRDY field.
	UARTE_INTEN_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTEN_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTEN_RXDRDY = 0x4
	// Disable
	UARTE_INTEN_RXDRDY_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXDRDY_Enabled = 0x1
	// Position of ENDRX field.
	UARTE_INTEN_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTEN_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTEN_ENDRX = 0x10
	// Disable
	UARTE_INTEN_ENDRX_Disabled = 0x0
	// Enable
	UARTE_INTEN_ENDRX_Enabled = 0x1
	// Position of TXDRDY field.
	UARTE_INTEN_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTEN_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTEN_TXDRDY = 0x80
	// Disable
	UARTE_INTEN_TXDRDY_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXDRDY_Enabled = 0x1
	// Position of ENDTX field.
	UARTE_INTEN_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTEN_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTEN_ENDTX = 0x100
	// Disable
	UARTE_INTEN_ENDTX_Disabled = 0x0
	// Enable
	UARTE_INTEN_ENDTX_Enabled = 0x1
	// Position of ERROR field.
	UARTE_INTEN_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTEN_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTEN_ERROR = 0x200
	// Disable
	UARTE_INTEN_ERROR_Disabled = 0x0
	// Enable
	UARTE_INTEN_ERROR_Enabled = 0x1
	// Position of RXTO field.
	UARTE_INTEN_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTEN_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTEN_RXTO = 0x20000
	// Disable
	UARTE_INTEN_RXTO_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXTO_Enabled = 0x1
	// Position of RXSTARTED field.
	UARTE_INTEN_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTEN_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTEN_RXSTARTED = 0x80000
	// Disable
	UARTE_INTEN_RXSTARTED_Disabled = 0x0
	// Enable
	UARTE_INTEN_RXSTARTED_Enabled = 0x1
	// Position of TXSTARTED field.
	UARTE_INTEN_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTEN_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTEN_TXSTARTED = 0x100000
	// Disable
	UARTE_INTEN_TXSTARTED_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXSTARTED_Enabled = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTEN_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTEN_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTEN_TXSTOPPED = 0x400000
	// Disable
	UARTE_INTEN_TXSTOPPED_Disabled = 0x0
	// Enable
	UARTE_INTEN_TXSTOPPED_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of CTS field.
	UARTE_INTENSET_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTENSET_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTENSET_CTS = 0x1
	// Read: Disabled
	UARTE_INTENSET_CTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_CTS_Enabled = 0x1
	// Enable
	UARTE_INTENSET_CTS_Set = 0x1
	// Position of NCTS field.
	UARTE_INTENSET_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTENSET_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTENSET_NCTS = 0x2
	// Read: Disabled
	UARTE_INTENSET_NCTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_NCTS_Enabled = 0x1
	// Enable
	UARTE_INTENSET_NCTS_Set = 0x1
	// Position of RXDRDY field.
	UARTE_INTENSET_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTENSET_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTENSET_RXDRDY = 0x4
	// Read: Disabled
	UARTE_INTENSET_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXDRDY_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXDRDY_Set = 0x1
	// Position of ENDRX field.
	UARTE_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTENSET_ENDRX = 0x10
	// Read: Disabled
	UARTE_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ENDRX_Set = 0x1
	// Position of TXDRDY field.
	UARTE_INTENSET_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTENSET_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTENSET_TXDRDY = 0x80
	// Read: Disabled
	UARTE_INTENSET_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXDRDY_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXDRDY_Set = 0x1
	// Position of ENDTX field.
	UARTE_INTENSET_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTENSET_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTENSET_ENDTX = 0x100
	// Read: Disabled
	UARTE_INTENSET_ENDTX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ENDTX_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ENDTX_Set = 0x1
	// Position of ERROR field.
	UARTE_INTENSET_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTENSET_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTENSET_ERROR = 0x200
	// Read: Disabled
	UARTE_INTENSET_ERROR_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_ERROR_Enabled = 0x1
	// Enable
	UARTE_INTENSET_ERROR_Set = 0x1
	// Position of RXTO field.
	UARTE_INTENSET_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTENSET_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTENSET_RXTO = 0x20000
	// Read: Disabled
	UARTE_INTENSET_RXTO_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXTO_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXTO_Set = 0x1
	// Position of RXSTARTED field.
	UARTE_INTENSET_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTENSET_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTENSET_RXSTARTED = 0x80000
	// Read: Disabled
	UARTE_INTENSET_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_RXSTARTED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_RXSTARTED_Set = 0x1
	// Position of TXSTARTED field.
	UARTE_INTENSET_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTENSET_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTENSET_TXSTARTED = 0x100000
	// Read: Disabled
	UARTE_INTENSET_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXSTARTED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXSTARTED_Set = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTENSET_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTENSET_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTENSET_TXSTOPPED = 0x400000
	// Read: Disabled
	UARTE_INTENSET_TXSTOPPED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENSET_TXSTOPPED_Enabled = 0x1
	// Enable
	UARTE_INTENSET_TXSTOPPED_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of CTS field.
	UARTE_INTENCLR_CTS_Pos = 0x0
	// Bit mask of CTS field.
	UARTE_INTENCLR_CTS_Msk = 0x1
	// Bit CTS.
	UARTE_INTENCLR_CTS = 0x1
	// Read: Disabled
	UARTE_INTENCLR_CTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_CTS_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_CTS_Clear = 0x1
	// Position of NCTS field.
	UARTE_INTENCLR_NCTS_Pos = 0x1
	// Bit mask of NCTS field.
	UARTE_INTENCLR_NCTS_Msk = 0x2
	// Bit NCTS.
	UARTE_INTENCLR_NCTS = 0x2
	// Read: Disabled
	UARTE_INTENCLR_NCTS_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_NCTS_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_NCTS_Clear = 0x1
	// Position of RXDRDY field.
	UARTE_INTENCLR_RXDRDY_Pos = 0x2
	// Bit mask of RXDRDY field.
	UARTE_INTENCLR_RXDRDY_Msk = 0x4
	// Bit RXDRDY.
	UARTE_INTENCLR_RXDRDY = 0x4
	// Read: Disabled
	UARTE_INTENCLR_RXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXDRDY_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXDRDY_Clear = 0x1
	// Position of ENDRX field.
	UARTE_INTENCLR_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	UARTE_INTENCLR_ENDRX_Msk = 0x10
	// Bit ENDRX.
	UARTE_INTENCLR_ENDRX = 0x10
	// Read: Disabled
	UARTE_INTENCLR_ENDRX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ENDRX_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ENDRX_Clear = 0x1
	// Position of TXDRDY field.
	UARTE_INTENCLR_TXDRDY_Pos = 0x7
	// Bit mask of TXDRDY field.
	UARTE_INTENCLR_TXDRDY_Msk = 0x80
	// Bit TXDRDY.
	UARTE_INTENCLR_TXDRDY = 0x80
	// Read: Disabled
	UARTE_INTENCLR_TXDRDY_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXDRDY_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXDRDY_Clear = 0x1
	// Position of ENDTX field.
	UARTE_INTENCLR_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	UARTE_INTENCLR_ENDTX_Msk = 0x100
	// Bit ENDTX.
	UARTE_INTENCLR_ENDTX = 0x100
	// Read: Disabled
	UARTE_INTENCLR_ENDTX_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ENDTX_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ENDTX_Clear = 0x1
	// Position of ERROR field.
	UARTE_INTENCLR_ERROR_Pos = 0x9
	// Bit mask of ERROR field.
	UARTE_INTENCLR_ERROR_Msk = 0x200
	// Bit ERROR.
	UARTE_INTENCLR_ERROR = 0x200
	// Read: Disabled
	UARTE_INTENCLR_ERROR_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_ERROR_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_ERROR_Clear = 0x1
	// Position of RXTO field.
	UARTE_INTENCLR_RXTO_Pos = 0x11
	// Bit mask of RXTO field.
	UARTE_INTENCLR_RXTO_Msk = 0x20000
	// Bit RXTO.
	UARTE_INTENCLR_RXTO = 0x20000
	// Read: Disabled
	UARTE_INTENCLR_RXTO_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXTO_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXTO_Clear = 0x1
	// Position of RXSTARTED field.
	UARTE_INTENCLR_RXSTARTED_Pos = 0x13
	// Bit mask of RXSTARTED field.
	UARTE_INTENCLR_RXSTARTED_Msk = 0x80000
	// Bit RXSTARTED.
	UARTE_INTENCLR_RXSTARTED = 0x80000
	// Read: Disabled
	UARTE_INTENCLR_RXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_RXSTARTED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_RXSTARTED_Clear = 0x1
	// Position of TXSTARTED field.
	UARTE_INTENCLR_TXSTARTED_Pos = 0x14
	// Bit mask of TXSTARTED field.
	UARTE_INTENCLR_TXSTARTED_Msk = 0x100000
	// Bit TXSTARTED.
	UARTE_INTENCLR_TXSTARTED = 0x100000
	// Read: Disabled
	UARTE_INTENCLR_TXSTARTED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXSTARTED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXSTARTED_Clear = 0x1
	// Position of TXSTOPPED field.
	UARTE_INTENCLR_TXSTOPPED_Pos = 0x16
	// Bit mask of TXSTOPPED field.
	UARTE_INTENCLR_TXSTOPPED_Msk = 0x400000
	// Bit TXSTOPPED.
	UARTE_INTENCLR_TXSTOPPED = 0x400000
	// Read: Disabled
	UARTE_INTENCLR_TXSTOPPED_Disabled = 0x0
	// Read: Enabled
	UARTE_INTENCLR_TXSTOPPED_Enabled = 0x1
	// Disable
	UARTE_INTENCLR_TXSTOPPED_Clear = 0x1

	// ERRORSRC: Error source Note : this register is read / write one to clear.
	// Position of OVERRUN field.
	UARTE_ERRORSRC_OVERRUN_Pos = 0x0
	// Bit mask of OVERRUN field.
	UARTE_ERRORSRC_OVERRUN_Msk = 0x1
	// Bit OVERRUN.
	UARTE_ERRORSRC_OVERRUN = 0x1
	// Read: error not present
	UARTE_ERRORSRC_OVERRUN_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_OVERRUN_Present = 0x1
	// Position of PARITY field.
	UARTE_ERRORSRC_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UARTE_ERRORSRC_PARITY_Msk = 0x2
	// Bit PARITY.
	UARTE_ERRORSRC_PARITY = 0x2
	// Read: error not present
	UARTE_ERRORSRC_PARITY_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_PARITY_Present = 0x1
	// Position of FRAMING field.
	UARTE_ERRORSRC_FRAMING_Pos = 0x2
	// Bit mask of FRAMING field.
	UARTE_ERRORSRC_FRAMING_Msk = 0x4
	// Bit FRAMING.
	UARTE_ERRORSRC_FRAMING = 0x4
	// Read: error not present
	UARTE_ERRORSRC_FRAMING_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_FRAMING_Present = 0x1
	// Position of BREAK field.
	UARTE_ERRORSRC_BREAK_Pos = 0x3
	// Bit mask of BREAK field.
	UARTE_ERRORSRC_BREAK_Msk = 0x8
	// Bit BREAK.
	UARTE_ERRORSRC_BREAK = 0x8
	// Read: error not present
	UARTE_ERRORSRC_BREAK_NotPresent = 0x0
	// Read: error present
	UARTE_ERRORSRC_BREAK_Present = 0x1

	// ENABLE: Enable UART
	// Position of ENABLE field.
	UARTE_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	UARTE_ENABLE_ENABLE_Msk = 0xf
	// Disable UARTE
	UARTE_ENABLE_ENABLE_Disabled = 0x0
	// Enable UARTE
	UARTE_ENABLE_ENABLE_Enabled = 0x8

	// PSEL.RTS: Pin select for RTS signal
	// Position of PIN field.
	UARTE_PSEL_RTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_RTS_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_RTS_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_RTS_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_RTS_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_RTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_RTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_RTS_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_RTS_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_RTS_CONNECT_Connected = 0x0

	// PSEL.TXD: Pin select for TXD signal
	// Position of PIN field.
	UARTE_PSEL_TXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_TXD_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_TXD_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_TXD_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_TXD_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_TXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_TXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_TXD_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_TXD_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_TXD_CONNECT_Connected = 0x0

	// PSEL.CTS: Pin select for CTS signal
	// Position of PIN field.
	UARTE_PSEL_CTS_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_CTS_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_CTS_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_CTS_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_CTS_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_CTS_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_CTS_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_CTS_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_CTS_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_CTS_CONNECT_Connected = 0x0

	// PSEL.RXD: Pin select for RXD signal
	// Position of PIN field.
	UARTE_PSEL_RXD_PIN_Pos = 0x0
	// Bit mask of PIN field.
	UARTE_PSEL_RXD_PIN_Msk = 0x1f
	// Position of PORT field.
	UARTE_PSEL_RXD_PORT_Pos = 0x5
	// Bit mask of PORT field.
	UARTE_PSEL_RXD_PORT_Msk = 0x20
	// Bit PORT.
	UARTE_PSEL_RXD_PORT = 0x20
	// Position of CONNECT field.
	UARTE_PSEL_RXD_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	UARTE_PSEL_RXD_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	UARTE_PSEL_RXD_CONNECT = 0x80000000
	// Disconnect
	UARTE_PSEL_RXD_CONNECT_Disconnected = 0x1
	// Connect
	UARTE_PSEL_RXD_CONNECT_Connected = 0x0

	// BAUDRATE: Baud rate. Accuracy depends on the HFCLK source selected.
	// Position of BAUDRATE field.
	UARTE_BAUDRATE_BAUDRATE_Pos = 0x0
	// Bit mask of BAUDRATE field.
	UARTE_BAUDRATE_BAUDRATE_Msk = 0xffffffff
	// 1200 baud (actual rate: 1205)
	UARTE_BAUDRATE_BAUDRATE_Baud1200 = 0x4f000
	// 2400 baud (actual rate: 2396)
	UARTE_BAUDRATE_BAUDRATE_Baud2400 = 0x9d000
	// 4800 baud (actual rate: 4808)
	UARTE_BAUDRATE_BAUDRATE_Baud4800 = 0x13b000
	// 9600 baud (actual rate: 9598)
	UARTE_BAUDRATE_BAUDRATE_Baud9600 = 0x275000
	// 14400 baud (actual rate: 14401)
	UARTE_BAUDRATE_BAUDRATE_Baud14400 = 0x3af000
	// 19200 baud (actual rate: 19208)
	UARTE_BAUDRATE_BAUDRATE_Baud19200 = 0x4ea000
	// 28800 baud (actual rate: 28777)
	UARTE_BAUDRATE_BAUDRATE_Baud28800 = 0x75c000
	// 31250 baud
	UARTE_BAUDRATE_BAUDRATE_Baud31250 = 0x800000
	// 38400 baud (actual rate: 38369)
	UARTE_BAUDRATE_BAUDRATE_Baud38400 = 0x9d0000
	// 56000 baud (actual rate: 55944)
	UARTE_BAUDRATE_BAUDRATE_Baud56000 = 0xe50000
	// 57600 baud (actual rate: 57554)
	UARTE_BAUDRATE_BAUDRATE_Baud57600 = 0xeb0000
	// 76800 baud (actual rate: 76923)
	UARTE_BAUDRATE_BAUDRATE_Baud76800 = 0x13a9000
	// 115200 baud (actual rate: 115108)
	UARTE_BAUDRATE_BAUDRATE_Baud115200 = 0x1d60000
	// 230400 baud (actual rate: 231884)
	UARTE_BAUDRATE_BAUDRATE_Baud230400 = 0x3b00000
	// 250000 baud
	UARTE_BAUDRATE_BAUDRATE_Baud250000 = 0x4000000
	// 460800 baud (actual rate: 457143)
	UARTE_BAUDRATE_BAUDRATE_Baud460800 = 0x7400000
	// 921600 baud (actual rate: 941176)
	UARTE_BAUDRATE_BAUDRATE_Baud921600 = 0xf000000
	// 1Mega baud
	UARTE_BAUDRATE_BAUDRATE_Baud1M = 0x10000000

	// RXD.PTR: Data pointer
	// Position of PTR field.
	UARTE_RXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	UARTE_RXD_PTR_PTR_Msk = 0xffffffff

	// RXD.MAXCNT: Maximum number of bytes in receive buffer
	// Position of MAXCNT field.
	UARTE_RXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	UARTE_RXD_MAXCNT_MAXCNT_Msk = 0xffff

	// RXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	UARTE_RXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	UARTE_RXD_AMOUNT_AMOUNT_Msk = 0xffff

	// TXD.PTR: Data pointer
	// Position of PTR field.
	UARTE_TXD_PTR_PTR_Pos = 0x0
	// Bit mask of PTR field.
	UARTE_TXD_PTR_PTR_Msk = 0xffffffff

	// TXD.MAXCNT: Maximum number of bytes in transmit buffer
	// Position of MAXCNT field.
	UARTE_TXD_MAXCNT_MAXCNT_Pos = 0x0
	// Bit mask of MAXCNT field.
	UARTE_TXD_MAXCNT_MAXCNT_Msk = 0xffff

	// TXD.AMOUNT: Number of bytes transferred in the last transaction
	// Position of AMOUNT field.
	UARTE_TXD_AMOUNT_AMOUNT_Pos = 0x0
	// Bit mask of AMOUNT field.
	UARTE_TXD_AMOUNT_AMOUNT_Msk = 0xffff

	// CONFIG: Configuration of parity and hardware flow control
	// Position of HWFC field.
	UARTE_CONFIG_HWFC_Pos = 0x0
	// Bit mask of HWFC field.
	UARTE_CONFIG_HWFC_Msk = 0x1
	// Bit HWFC.
	UARTE_CONFIG_HWFC = 0x1
	// Disabled
	UARTE_CONFIG_HWFC_Disabled = 0x0
	// Enabled
	UARTE_CONFIG_HWFC_Enabled = 0x1
	// Position of PARITY field.
	UARTE_CONFIG_PARITY_Pos = 0x1
	// Bit mask of PARITY field.
	UARTE_CONFIG_PARITY_Msk = 0xe
	// Exclude parity bit
	UARTE_CONFIG_PARITY_Excluded = 0x0
	// Include even parity bit
	UARTE_CONFIG_PARITY_Included = 0x7
	// Position of STOP field.
	UARTE_CONFIG_STOP_Pos = 0x4
	// Bit mask of STOP field.
	UARTE_CONFIG_STOP_Msk = 0x10
	// Bit STOP.
	UARTE_CONFIG_STOP = 0x10
	// One stop bit
	UARTE_CONFIG_STOP_One = 0x0
	// Two stop bits
	UARTE_CONFIG_STOP_Two = 0x1
	// Position of PARITYTYPE field.
	UARTE_CONFIG_PARITYTYPE_Pos = 0x8
	// Bit mask of PARITYTYPE field.
	UARTE_CONFIG_PARITYTYPE_Msk = 0x100
	// Bit PARITYTYPE.
	UARTE_CONFIG_PARITYTYPE = 0x100
	// Even parity
	UARTE_CONFIG_PARITYTYPE_Even = 0x0
	// Odd parity
	UARTE_CONFIG_PARITYTYPE_Odd = 0x1
)

// Constants for SPI0: Serial Peripheral Interface 0
const (
	// EVENTS_READY: TXD byte sent and RXD byte received
	// Position of EVENTS_READY field.
	SPI_EVENTS_READY_EVENTS_READY_Pos = 0x0
	// Bit mask of EVENTS_READY field.
	SPI_EVENTS_READY_EVENTS_READY_Msk = 0x1
	// Bit EVENTS_READY.
	SPI_EVENTS_READY_EVENTS_READY = 0x1
	// Event not generated
	SPI_EVENTS_READY_EVENTS_READY_NotGenerated = 0x0
	// Event generated
	SPI_EVENTS_READY_EVENTS_READY_Generated = 0x1

	// INTENSET: Enable interrupt
	// Position of READY field.
	SPI_INTENSET_READY_Pos = 0x2
	// Bit mask of READY field.
	SPI_INTENSET_READY_Msk = 0x4
	// Bit READY.
	SPI_INTENSET_READY = 0x4
	// Read: Disabled
	SPI_INTENSET_READY_Disabled = 0x0
	// Read: Enabled
	SPI_INTENSET_READY_Enabled = 0x1
	// Enable
	SPI_INTENSET_READY_Set = 0x1

	// INTENCLR: Disable interrupt
	// Position of READY field.
	SPI_INTENCLR_READY_Pos = 0x2
	// Bit mask of READY field.
	SPI_INTENCLR_READY_Msk = 0x4
	// Bit READY.
	SPI_INTENCLR_READY = 0x4
	// Read: Disabled
	SPI_INTENCLR_READY_Disabled = 0x0
	// Read: Enabled
	SPI_INTENCLR_READY_Enabled = 0x1
	// Disable
	SPI_INTENCLR_READY_Clear = 0x1

	// ENABLE: Enable SPI
	// Position of ENABLE field.
	SPI_ENABLE_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	SPI_ENABLE_ENABLE_Msk = 0xf
	// Disable SPI
	SPI_ENABLE_ENABLE_Disabled = 0x0
	// Enable SPI
	SPI_ENABLE_ENABLE_Enabled = 0x1

	// PSEL.SCK: Pin select for SCK
	// Position of PIN field.
	SPI_PSEL_SCK_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPI_PSEL_SCK_PIN_Msk = 0x1f
	// Position of PORT field.
	SPI_PSEL_SCK_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPI_PSEL_SCK_PORT_Msk = 0x20
	// Bit PORT.
	SPI_PSEL_SCK_PORT = 0x20
	// Position of CONNECT field.
	SPI_PSEL_SCK_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPI_PSEL_SCK_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPI_PSEL_SCK_CONNECT = 0x80000000
	// Disconnect
	SPI_PSEL_SCK_CONNECT_Disconnected = 0x1
	// Connect
	SPI_PSEL_SCK_CONNECT_Connected = 0x0

	// PSEL.MOSI: Pin select for MOSI signal
	// Position of PIN field.
	SPI_PSEL_MOSI_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPI_PSEL_MOSI_PIN_Msk = 0x1f
	// Position of PORT field.
	SPI_PSEL_MOSI_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPI_PSEL_MOSI_PORT_Msk = 0x20
	// Bit PORT.
	SPI_PSEL_MOSI_PORT = 0x20
	// Position of CONNECT field.
	SPI_PSEL_MOSI_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPI_PSEL_MOSI_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPI_PSEL_MOSI_CONNECT = 0x80000000
	// Disconnect
	SPI_PSEL_MOSI_CONNECT_Disconnected = 0x1
	// Connect
	SPI_PSEL_MOSI_CONNECT_Connected = 0x0

	// PSEL.MISO: Pin select for MISO signal
	// Position of PIN field.
	SPI_PSEL_MISO_PIN_Pos = 0x0
	// Bit mask of PIN field.
	SPI_PSEL_MISO_PIN_Msk = 0x1f
	// Position of PORT field.
	SPI_PSEL_MISO_PORT_Pos = 0x5
	// Bit mask of PORT field.
	SPI_PSEL_MISO_PORT_Msk = 0x20
	// Bit PORT.
	SPI_PSEL_MISO_PORT = 0x20
	// Position of CONNECT field.
	SPI_PSEL_MISO_CONNECT_Pos = 0x1f
	// Bit mask of CONNECT field.
	SPI_PSEL_MISO_CONNECT_Msk = 0x80000000
	// Bit CONNECT.
	SPI_PSEL_MISO_CONNECT = 0x80000000
	// Disconnect
	SPI_PSEL_MISO_CONNECT_Disconnected = 0x1
	// Connect
	SPI_PSEL_MISO_CONNECT_Connected = 0x0

	// RXD: RXD register
	// Position of RXD field.
	SPI_RXD_RXD_Pos = 0x0
	// Bit mask of RXD field.
	SPI_RXD_RXD_Msk = 0xff

	// TXD: TXD register
	// Position of TXD field.
	SPI_TXD_TXD_Pos = 0x0
	// Bit mask of TXD field.
	SPI_TXD_TXD_Msk = 0xff

	// FREQUENCY: SPI frequency. Accuracy depends on the HFCLK source selected.
	// Position of FREQUENCY field.
	SPI_FREQUENCY_FREQUENCY_Pos = 0x0
	// Bit mask of FREQUENCY field.
	SPI_FREQUENCY_FREQUENCY_Msk = 0xffffffff
	// 125 kbps
	SPI_FREQUENCY_FREQUENCY_K125 = 0x2000000
	// 250 kbps
	SPI_FREQUENCY_FREQUENCY_K250 = 0x4000000
	// 500 kbps
	SPI_FREQUENCY_FREQUENCY_K500 = 0x8000000
	// 1 Mbps
	SPI_FREQUENCY_FREQUENCY_M1 = 0x10000000
	// 2 Mbps
	SPI_FREQUENCY_FREQUENCY_M2 = 0x20000000
	// 4 Mbps
	SPI_FREQUENCY_FREQUENCY_M4 = 0x40000000
	// 8 Mbps
	SPI_FREQUENCY_FREQUENCY_M8 = 0x80000000

	// CONFIG: Configuration register
	// Position of ORDER field.
	SPI_CONFIG_ORDER_Pos = 0x0
	// Bit mask of ORDER field.
	SPI_CONFIG_ORDER_Msk = 0x1
	// Bit ORDER.
	SPI_CONFIG_ORDER = 0x1
	// Most significant bit shifted out first
	SPI_CONFIG_ORDER_MsbFirst = 0x0
	// Least significant bit shifted out first
	SPI_CONFIG_ORDER_LsbFirst = 0x1
	// Position of CPHA field.
	SPI_CONFIG_CPHA_Pos = 0x1
	// Bit mask of CPHA field.
	SPI_CONFIG_CPHA_Msk = 0x2
	// Bit CPHA.
	SPI_CONFIG_CPHA = 0x2
	// Sample on leading edge of clock, shift serial data on trailing edge
	SPI_CONFIG_CPHA_Leading = 0x0
	// Sample on trailing edge of clock, shift serial data on leading edge
	SPI_CONFIG_CPHA_Trailing = 0x1
	// Position of CPOL field.
	SPI_CONFIG_CPOL_Pos = 0x2
	// Bit mask of CPOL field.
	SPI_CONFIG_CPOL_Msk = 0x4
	// Bit CPOL.
	SPI_CONFIG_CPOL = 0x4
	// Active high
	SPI_CONFIG_CPOL_ActiveHigh = 0x0
	// Active low
	SPI_CONFIG_CPOL_ActiveLow = 0x1
)

// Constants for SPIM0: Serial Peripheral Interface Master with EasyDMA 0
const (
	// TASKS_START: Start SPI transaction
	// Position of TASKS_START field.
	SPIM_TASKS_START_TASKS_START_Pos = 0x0
	// Bit mask of TASKS_START field.
	SPIM_TASKS_START_TASKS_START_Msk = 0x1
	// Bit TASKS_START.
	SPIM_TASKS_START_TASKS_START = 0x1
	// Trigger task
	SPIM_TASKS_START_TASKS_START_Trigger = 0x1

	// TASKS_STOP: Stop SPI transaction
	// Position of TASKS_STOP field.
	SPIM_TASKS_STOP_TASKS_STOP_Pos = 0x0
	// Bit mask of TASKS_STOP field.
	SPIM_TASKS_STOP_TASKS_STOP_Msk = 0x1
	// Bit TASKS_STOP.
	SPIM_TASKS_STOP_TASKS_STOP = 0x1
	// Trigger task
	SPIM_TASKS_STOP_TASKS_STOP_Trigger = 0x1

	// TASKS_SUSPEND: Suspend SPI transaction
	// Position of TASKS_SUSPEND field.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Pos = 0x0
	// Bit mask of TASKS_SUSPEND field.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Msk = 0x1
	// Bit TASKS_SUSPEND.
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND = 0x1
	// Trigger task
	SPIM_TASKS_SUSPEND_TASKS_SUSPEND_Trigger = 0x1

	// TASKS_RESUME: Resume SPI transaction
	// Position of TASKS_RESUME field.
	SPIM_TASKS_RESUME_TASKS_RESUME_Pos = 0x0
	// Bit mask of TASKS_RESUME field.
	SPIM_TASKS_RESUME_TASKS_RESUME_Msk = 0x1
	// Bit TASKS_RESUME.
	SPIM_TASKS_RESUME_TASKS_RESUME = 0x1
	// Trigger task
	SPIM_TASKS_RESUME_TASKS_RESUME_Trigger = 0x1

	// EVENTS_STOPPED: SPI transaction has stopped
	// Position of EVENTS_STOPPED field.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Pos = 0x0
	// Bit mask of EVENTS_STOPPED field.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Msk = 0x1
	// Bit EVENTS_STOPPED.
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED = 0x1
	// Event not generated
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_STOPPED_EVENTS_STOPPED_Generated = 0x1

	// EVENTS_ENDRX: End of RXD buffer reached
	// Position of EVENTS_ENDRX field.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Pos = 0x0
	// Bit mask of EVENTS_ENDRX field.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Msk = 0x1
	// Bit EVENTS_ENDRX.
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX = 0x1
	// Event not generated
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_ENDRX_EVENTS_ENDRX_Generated = 0x1

	// EVENTS_END: End of RXD buffer and TXD buffer reached
	// Position of EVENTS_END field.
	SPIM_EVENTS_END_EVENTS_END_Pos = 0x0
	// Bit mask of EVENTS_END field.
	SPIM_EVENTS_END_EVENTS_END_Msk = 0x1
	// Bit EVENTS_END.
	SPIM_EVENTS_END_EVENTS_END = 0x1
	// Event not generated
	SPIM_EVENTS_END_EVENTS_END_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_END_EVENTS_END_Generated = 0x1

	// EVENTS_ENDTX: End of TXD buffer reached
	// Position of EVENTS_ENDTX field.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Pos = 0x0
	// Bit mask of EVENTS_ENDTX field.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Msk = 0x1
	// Bit EVENTS_ENDTX.
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX = 0x1
	// Event not generated
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_ENDTX_EVENTS_ENDTX_Generated = 0x1

	// EVENTS_STARTED: Transaction started
	// Position of EVENTS_STARTED field.
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Pos = 0x0
	// Bit mask of EVENTS_STARTED field.
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Msk = 0x1
	// Bit EVENTS_STARTED.
	SPIM_EVENTS_STARTED_EVENTS_STARTED = 0x1
	// Event not generated
	SPIM_EVENTS_STARTED_EVENTS_STARTED_NotGenerated = 0x0
	// Event generated
	SPIM_EVENTS_STARTED_EVENTS_STARTED_Generated = 0x1

	// SHORTS: Shortcuts between local events and tasks
	// Position of END_START field.
	SPIM_SHORTS_END_START_Pos = 0x11
	// Bit mask of END_START field.
	SPIM_SHORTS_END_START_Msk = 0x20000
	// Bit END_START.
	SPIM_SHORTS_END_START = 0x20000
	// Disable shortcut
	SPIM_SHORTS_END_START_Disabled = 0x0
	// Enable shortcut
	SPIM_SHORTS_END_START_Enabled = 0x1

	// INTENSET: Enable interrupt
	// Position of STOPPED field.
	SPIM_INTENSET_STOPPED_Pos = 0x1
	// Bit mask of STOPPED field.
	SPIM_INTENSET_STOPPED_Msk = 0x2
	// Bit STOPPED.
	SPIM_INTENSET_STOPPED = 0x2
	// Read: Disabled
	SPIM_INTENSET_STOPPED_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_STOPPED_Enabled = 0x1
	// Enable
	SPIM_INTENSET_STOPPED_Set = 0x1
	// Position of ENDRX field.
	SPIM_INTENSET_ENDRX_Pos = 0x4
	// Bit mask of ENDRX field.
	SPIM_INTENSET_ENDRX_Msk = 0x10
	// Bit ENDRX.
	SPIM_INTENSET_ENDRX = 0x10
	// Read: Disabled
	SPIM_INTENSET_ENDRX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_ENDRX_Enabled = 0x1
	// Enable
	SPIM_INTENSET_ENDRX_Set = 0x1
	// Position of END field.
	SPIM_INTENSET_END_Pos = 0x6
	// Bit mask of END field.
	SPIM_INTENSET_END_Msk = 0x40
	// Bit END.
	SPIM_INTENSET_END = 0x40
	// Read: Disabled
	SPIM_INTENSET_END_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_END_Enabled = 0x1
	// Enable
	SPIM_INTENSET_END_Set = 0x1
	// Position of ENDTX field.
	SPIM_INTENSET_ENDTX_Pos = 0x8
	// Bit mask of ENDTX field.
	SPIM_INTENSET_ENDTX_Msk = 0x100
	// Bit ENDTX.
	SPIM_INTENSET_ENDTX = 0x100
	// Read: Disabled
	SPIM_INTENSET_ENDTX_Disabled = 0x0
	// Read: Enabled
	SPIM_INTENSET_ENDTX_Enabled = 0x1
	// Enable
	SP