// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from R7FA2E2A7.svd, see https://github.com/cmsis-svd/cmsis-svd-data/tree/master/data/Renesas

//go:build renesas && r7fa2e2a7

// Arm Cortex-M23 based Microcontroller RA2E2 device
//
//	This software is supplied by Renesas Electronics Corporation and is only intended for
//	use with Renesas products. No other uses are authorized. This software is owned by
//	Renesas Electronics Corporation and is protected under all applicable laws, including
//	copyright laws.
//
//	THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
//	THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT LIMITED TO
//	WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
//	ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED. TO THE MAXIMUM EXTENT PERMITTED NOT
//	PROHIBITED BY LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED
//	COMPANIES SHALL BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL
//	DAMAGES FOR ANY REASON RELATED TO THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE
//	BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
//
//	Renesas reserves the right, without notice, to make changes to this software and to
//	discontinue the availability of this software. By using this software, you agree to
//	the additional terms and conditions found by accessing the following link:
//	http://www.renesas.com/disclaimer
//	\n
package renesas

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "R7FA2E2A7"
	CPU          = "CM23"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// ICU for CPU
	IRQ_IEL0 = 0

	// ICU for CPU
	IRQ_IEL1 = 1

	// ICU for CPU
	IRQ_IEL2 = 2

	// ICU for CPU
	IRQ_IEL3 = 3

	// ICU for CPU
	IRQ_IEL4 = 4

	// ICU for CPU
	IRQ_IEL5 = 5

	// ICU for CPU
	IRQ_IEL6 = 6

	// ICU for CPU
	IRQ_IEL7 = 7

	// ICU for CPU
	IRQ_IEL8 = 8

	// ICU for CPU
	IRQ_IEL9 = 9

	// ICU for CPU
	IRQ_IEL10 = 10

	// ICU for CPU
	IRQ_IEL11 = 11

	// ICU for CPU
	IRQ_IEL12 = 12

	// ICU for CPU
	IRQ_IEL13 = 13

	// ICU for CPU
	IRQ_IEL14 = 14

	// ICU for CPU
	IRQ_IEL15 = 15

	// ICU for CPU
	IRQ_IEL16 = 16

	// ICU for CPU
	IRQ_IEL17 = 17

	// ICU for CPU
	IRQ_IEL18 = 18

	// ICU for CPU
	IRQ_IEL19 = 19

	// ICU for CPU
	IRQ_IEL20 = 20

	// ICU for CPU
	IRQ_IEL21 = 21

	// ICU for CPU
	IRQ_IEL22 = 22

	// ICU for CPU
	IRQ_IEL23 = 23

	// ICU for CPU
	IRQ_IEL24 = 24

	// ICU for CPU
	IRQ_IEL25 = 25

	// ICU for CPU
	IRQ_IEL26 = 26

	// ICU for CPU
	IRQ_IEL27 = 27

	// ICU for CPU
	IRQ_IEL28 = 28

	// ICU for CPU
	IRQ_IEL29 = 29

	// ICU for CPU
	IRQ_IEL30 = 30

	// ICU for CPU
	IRQ_IEL31 = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export IEL0_IRQHandler
func interruptIEL0() {
	callHandlers(IRQ_IEL0)
}

//export IEL1_IRQHandler
func interruptIEL1() {
	callHandlers(IRQ_IEL1)
}

//export IEL2_IRQHandler
func interruptIEL2() {
	callHandlers(IRQ_IEL2)
}

//export IEL3_IRQHandler
func interruptIEL3() {
	callHandlers(IRQ_IEL3)
}

//export IEL4_IRQHandler
func interruptIEL4() {
	callHandlers(IRQ_IEL4)
}

//export IEL5_IRQHandler
func interruptIEL5() {
	callHandlers(IRQ_IEL5)
}

//export IEL6_IRQHandler
func interruptIEL6() {
	callHandlers(IRQ_IEL6)
}

//export IEL7_IRQHandler
func interruptIEL7() {
	callHandlers(IRQ_IEL7)
}

//export IEL8_IRQHandler
func interruptIEL8() {
	callHandlers(IRQ_IEL8)
}

//export IEL9_IRQHandler
func interruptIEL9() {
	callHandlers(IRQ_IEL9)
}

//export IEL10_IRQHandler
func interruptIEL10() {
	callHandlers(IRQ_IEL10)
}

//export IEL11_IRQHandler
func interruptIEL11() {
	callHandlers(IRQ_IEL11)
}

//export IEL12_IRQHandler
func interruptIEL12() {
	callHandlers(IRQ_IEL12)
}

//export IEL13_IRQHandler
func interruptIEL13() {
	callHandlers(IRQ_IEL13)
}

//export IEL14_IRQHandler
func interruptIEL14() {
	callHandlers(IRQ_IEL14)
}

//export IEL15_IRQHandler
func interruptIEL15() {
	callHandlers(IRQ_IEL15)
}

//export IEL16_IRQHandler
func interruptIEL16() {
	callHandlers(IRQ_IEL16)
}

//export IEL17_IRQHandler
func interruptIEL17() {
	callHandlers(IRQ_IEL17)
}

//export IEL18_IRQHandler
func interruptIEL18() {
	callHandlers(IRQ_IEL18)
}

//export IEL19_IRQHandler
func interruptIEL19() {
	callHandlers(IRQ_IEL19)
}

//export IEL20_IRQHandler
func interruptIEL20() {
	callHandlers(IRQ_IEL20)
}

//export IEL21_IRQHandler
func interruptIEL21() {
	callHandlers(IRQ_IEL21)
}

//export IEL22_IRQHandler
func interruptIEL22() {
	callHandlers(IRQ_IEL22)
}

//export IEL23_IRQHandler
func interruptIEL23() {
	callHandlers(IRQ_IEL23)
}

//export IEL24_IRQHandler
func interruptIEL24() {
	callHandlers(IRQ_IEL24)
}

//export IEL25_IRQHandler
func interruptIEL25() {
	callHandlers(IRQ_IEL25)
}

//export IEL26_IRQHandler
func interruptIEL26() {
	callHandlers(IRQ_IEL26)
}

//export IEL27_IRQHandler
func interruptIEL27() {
	callHandlers(IRQ_IEL27)
}

//export IEL28_IRQHandler
func interruptIEL28() {
	callHandlers(IRQ_IEL28)
}

//export IEL29_IRQHandler
func interruptIEL29() {
	callHandlers(IRQ_IEL29)
}

//export IEL30_IRQHandler
func interruptIEL30() {
	callHandlers(IRQ_IEL30)
}

//export IEL31_IRQHandler
func interruptIEL31() {
	callHandlers(IRQ_IEL31)
}

// Peripherals.
var (
	// Renesas Memory Protection Unit
	RMPU = (*RMPU_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// SRAM Control
	SRAM = (*SRAM_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// BUS Control
	BUS = (*BUS_Type)(unsafe.Pointer(uintptr(0x40003000)))

	// Data Transfer Controller
	DTC = (*DTC_Type)(unsafe.Pointer(uintptr(0x40005400)))

	// ICU for CPU
	ICU = (*ICU_Type)(unsafe.Pointer(uintptr(0x40006000)))

	// Debug Function
	DBG = (*DBG_Type)(unsafe.Pointer(uintptr(0x4001b000)))

	// System Control
	SYSC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x4001e000)))

	// Port 0 Control Registers
	PORT0 = (*PORT0_Type)(unsafe.Pointer(uintptr(0x40040000)))

	// Port 1 Control Registers
	PORT1 = (*PORT1_Type)(unsafe.Pointer(uintptr(0x40040020)))

	// Port 2 Control Registers
	PORT2 = (*PORT1_Type)(unsafe.Pointer(uintptr(0x40040040)))

	// Port 3 Control Registers
	PORT3 = (*PORT0_Type)(unsafe.Pointer(uintptr(0x40040060)))

	// Port 4 Control Registers
	PORT4 = (*PORT0_Type)(unsafe.Pointer(uintptr(0x40040080)))

	// Port 9 Control Registers
	PORT9 = (*PORT0_Type)(unsafe.Pointer(uintptr(0x40040120)))

	// Pmn Pin Function Control Register
	PFS = (*PFS_Type)(unsafe.Pointer(uintptr(0x40040800)))

	// Event Link Controller
	ELC = (*ELC_Type)(unsafe.Pointer(uintptr(0x40041000)))

	// Port Output Enable Module for GPT
	POEG = (*POEG_Type)(unsafe.Pointer(uintptr(0x40042000)))

	// Watchdog Timer
	WDT = (*WDT_Type)(unsafe.Pointer(uintptr(0x40044200)))

	// Independent Watchdog Timer
	IWDT = (*IWDT_Type)(unsafe.Pointer(uintptr(0x40044400)))

	// Clock Frequency Accuracy Measurement Circuit
	CAC = (*CAC_Type)(unsafe.Pointer(uintptr(0x40044600)))

	// Module Stop Control B, C, D
	MSTP = (*MSTP_Type)(unsafe.Pointer(uintptr(0x40047000)))

	// Data Operation Circuit
	DOC = (*DOC_Type)(unsafe.Pointer(uintptr(0x40054100)))

	// 12-bit A/D Converter
	ADC120 = (*ADC120_Type)(unsafe.Pointer(uintptr(0x4005c000)))

	// Serial Communication Interface 0
	SCI9 = (*SCI9_Type)(unsafe.Pointer(uintptr(0x40070120)))

	// Serial Peripheral Interface
	SPI0 = (*SPI0_Type)(unsafe.Pointer(uintptr(0x40072000)))

	// Cyclic Redundancy Check Calculator
	CRC = (*CRC_Type)(unsafe.Pointer(uintptr(0x40074000)))

	// General PWM 16-bit Timer 4
	GPT164 = (*GPT164_Type)(unsafe.Pointer(uintptr(0x40078400)))

	// General PWM 16-bit Timer 5
	GPT165 = (*GPT164_Type)(unsafe.Pointer(uintptr(0x40078500)))

	// General PWM 16-bit Timer 6
	GPT166 = (*GPT164_Type)(unsafe.Pointer(uintptr(0x40078600)))

	// General PWM 16-bit Timer 7
	GPT167 = (*GPT164_Type)(unsafe.Pointer(uintptr(0x40078700)))

	// General PWM 16-bit Timer 8
	GPT168 = (*GPT164_Type)(unsafe.Pointer(uintptr(0x40078800)))

	// General PWM 16-bit Timer 9
	GPT169 = (*GPT164_Type)(unsafe.Pointer(uintptr(0x40078900)))

	// Output Phase Switching Controller
	GPT_OPS = (*GPT_OPS_Type)(unsafe.Pointer(uintptr(0x40078ff0)))

	// Key Interrupt Function
	KINT = (*KINT_Type)(unsafe.Pointer(uintptr(0x40080000)))

	// I3C Bus Interface
	I3C = (*I3C_Type)(unsafe.Pointer(uintptr(0x40083000)))

	// Low Power Asynchronous General Purpose Timer 0
	AGTW0 = (*AGTW0_Type)(unsafe.Pointer(uintptr(0x40084000)))

	// Low Power Asynchronous General Purpose Timer 1
	AGTW1 = (*AGTW0_Type)(unsafe.Pointer(uintptr(0x40084100)))

	// Flash I/O Registers
	FLCN = (*FLCN_Type)(unsafe.Pointer(uintptr(0x407ec000)))
)

// Renesas Memory Protection Unit
type RMPU_Type struct {
	MMPUCTLA  volatile.Register16 // 0x0
	_         [256]byte
	MMPUPTA   volatile.Register16 // 0x102
	_         [252]byte
	MMPUACA0  volatile.Register16 // 0x200
	_         [2]byte
	MMPUSA0   volatile.Register32 // 0x204
	MMPUEA0   volatile.Register32 // 0x208
	_         [4]byte
	MMPUACA1  volatile.Register16 // 0x210
	_         [2]byte
	MMPUSA1   volatile.Register32 // 0x214
	MMPUEA1   volatile.Register32 // 0x218
	_         [4]byte
	MMPUACA2  volatile.Register16 // 0x220
	_         [2]byte
	MMPUSA2   volatile.Register32 // 0x224
	MMPUEA2   volatile.Register32 // 0x228
	_         [4]byte
	MMPUACA3  volatile.Register16 // 0x230
	_         [2]byte
	MMPUSA3   volatile.Register32 // 0x234
	MMPUEA3   volatile.Register32 // 0x238
	_         [2500]byte
	SMPUCTL   volatile.Register16 // 0xC00
	_         [14]byte
	SMPUMBIU  volatile.Register16 // 0xC10
	_         [2]byte
	SMPUFBIU  volatile.Register16 // 0xC14
	_         [2]byte
	SMPUSRAM0 volatile.Register16 // 0xC18
	_         [6]byte
	SMPUP0BIU volatile.Register16 // 0xC20
	_         [2]byte
	SMPUP2BIU volatile.Register16 // 0xC24
	_         [2]byte
	SMPUP6BIU volatile.Register16 // 0xC28
	_         [214]byte
	MSPMPUOAD volatile.Register16 // 0xD00
	_         [2]byte
	MSPMPUCTL volatile.Register16 // 0xD04
	MSPMPUPT  volatile.Register16 // 0xD06
	MSPMPUSA  volatile.Register32 // 0xD08
	MSPMPUEA  volatile.Register32 // 0xD0C
	PSPMPUOAD volatile.Register16 // 0xD10
	_         [2]byte
	PSPMPUCTL volatile.Register16 // 0xD14
	PSPMPUPT  volatile.Register16 // 0xD16
	PSPMPUSA  volatile.Register32 // 0xD18
	PSPMPUEA  volatile.Register32 // 0xD1C
}

// RMPU.MMPUCTLA: Bus Master MPU Control Register
func (o *RMPU_Type) SetMMPUCTLA_ENABLE(value uint16) {
	volatile.StoreUint16(&o.MMPUCTLA.Reg, volatile.LoadUint16(&o.MMPUCTLA.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMMPUCTLA_ENABLE() uint16 {
	return volatile.LoadUint16(&o.MMPUCTLA.Reg) & 0x1
}
func (o *RMPU_Type) SetMMPUCTLA_OAD(value uint16) {
	volatile.StoreUint16(&o.MMPUCTLA.Reg, volatile.LoadUint16(&o.MMPUCTLA.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetMMPUCTLA_OAD() uint16 {
	return (volatile.LoadUint16(&o.MMPUCTLA.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetMMPUCTLA_KEY(value uint16) {
	volatile.StoreUint16(&o.MMPUCTLA.Reg, volatile.LoadUint16(&o.MMPUCTLA.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetMMPUCTLA_KEY() uint16 {
	return (volatile.LoadUint16(&o.MMPUCTLA.Reg) & 0xff00) >> 8
}

// RMPU.MMPUPTA: Group A Protection of Register
func (o *RMPU_Type) SetMMPUPTA_PROTECT(value uint16) {
	volatile.StoreUint16(&o.MMPUPTA.Reg, volatile.LoadUint16(&o.MMPUPTA.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMMPUPTA_PROTECT() uint16 {
	return volatile.LoadUint16(&o.MMPUPTA.Reg) & 0x1
}
func (o *RMPU_Type) SetMMPUPTA_KEY(value uint16) {
	volatile.StoreUint16(&o.MMPUPTA.Reg, volatile.LoadUint16(&o.MMPUPTA.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetMMPUPTA_KEY() uint16 {
	return (volatile.LoadUint16(&o.MMPUPTA.Reg) & 0xff00) >> 8
}

// RMPU.MMPUACA0: Group A Region %s access control register
func (o *RMPU_Type) SetMMPUACA0_ENABLE(value uint16) {
	volatile.StoreUint16(&o.MMPUACA0.Reg, volatile.LoadUint16(&o.MMPUACA0.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMMPUACA0_ENABLE() uint16 {
	return volatile.LoadUint16(&o.MMPUACA0.Reg) & 0x1
}
func (o *RMPU_Type) SetMMPUACA0_RP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA0.Reg, volatile.LoadUint16(&o.MMPUACA0.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetMMPUACA0_RP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA0.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetMMPUACA0_WP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA0.Reg, volatile.LoadUint16(&o.MMPUACA0.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetMMPUACA0_WP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA0.Reg) & 0x4) >> 2
}

// RMPU.MMPUSA0: Group A Region %s Start Address Register
func (o *RMPU_Type) SetMMPUSA0(value uint32) {
	volatile.StoreUint32(&o.MMPUSA0.Reg, value)
}
func (o *RMPU_Type) GetMMPUSA0() uint32 {
	return volatile.LoadUint32(&o.MMPUSA0.Reg)
}

// RMPU.MMPUEA0: Group A Region %s End Address Register
func (o *RMPU_Type) SetMMPUEA0(value uint32) {
	volatile.StoreUint32(&o.MMPUEA0.Reg, value)
}
func (o *RMPU_Type) GetMMPUEA0() uint32 {
	return volatile.LoadUint32(&o.MMPUEA0.Reg)
}

// RMPU.MMPUACA1: Group A Region %s access control register
func (o *RMPU_Type) SetMMPUACA1_ENABLE(value uint16) {
	volatile.StoreUint16(&o.MMPUACA1.Reg, volatile.LoadUint16(&o.MMPUACA1.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMMPUACA1_ENABLE() uint16 {
	return volatile.LoadUint16(&o.MMPUACA1.Reg) & 0x1
}
func (o *RMPU_Type) SetMMPUACA1_RP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA1.Reg, volatile.LoadUint16(&o.MMPUACA1.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetMMPUACA1_RP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA1.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetMMPUACA1_WP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA1.Reg, volatile.LoadUint16(&o.MMPUACA1.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetMMPUACA1_WP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA1.Reg) & 0x4) >> 2
}

// RMPU.MMPUSA1: Group A Region %s Start Address Register
func (o *RMPU_Type) SetMMPUSA1(value uint32) {
	volatile.StoreUint32(&o.MMPUSA1.Reg, value)
}
func (o *RMPU_Type) GetMMPUSA1() uint32 {
	return volatile.LoadUint32(&o.MMPUSA1.Reg)
}

// RMPU.MMPUEA1: Group A Region %s End Address Register
func (o *RMPU_Type) SetMMPUEA1(value uint32) {
	volatile.StoreUint32(&o.MMPUEA1.Reg, value)
}
func (o *RMPU_Type) GetMMPUEA1() uint32 {
	return volatile.LoadUint32(&o.MMPUEA1.Reg)
}

// RMPU.MMPUACA2: Group A Region %s access control register
func (o *RMPU_Type) SetMMPUACA2_ENABLE(value uint16) {
	volatile.StoreUint16(&o.MMPUACA2.Reg, volatile.LoadUint16(&o.MMPUACA2.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMMPUACA2_ENABLE() uint16 {
	return volatile.LoadUint16(&o.MMPUACA2.Reg) & 0x1
}
func (o *RMPU_Type) SetMMPUACA2_RP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA2.Reg, volatile.LoadUint16(&o.MMPUACA2.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetMMPUACA2_RP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA2.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetMMPUACA2_WP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA2.Reg, volatile.LoadUint16(&o.MMPUACA2.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetMMPUACA2_WP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA2.Reg) & 0x4) >> 2
}

// RMPU.MMPUSA2: Group A Region %s Start Address Register
func (o *RMPU_Type) SetMMPUSA2(value uint32) {
	volatile.StoreUint32(&o.MMPUSA2.Reg, value)
}
func (o *RMPU_Type) GetMMPUSA2() uint32 {
	return volatile.LoadUint32(&o.MMPUSA2.Reg)
}

// RMPU.MMPUEA2: Group A Region %s End Address Register
func (o *RMPU_Type) SetMMPUEA2(value uint32) {
	volatile.StoreUint32(&o.MMPUEA2.Reg, value)
}
func (o *RMPU_Type) GetMMPUEA2() uint32 {
	return volatile.LoadUint32(&o.MMPUEA2.Reg)
}

// RMPU.MMPUACA3: Group A Region %s access control register
func (o *RMPU_Type) SetMMPUACA3_ENABLE(value uint16) {
	volatile.StoreUint16(&o.MMPUACA3.Reg, volatile.LoadUint16(&o.MMPUACA3.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMMPUACA3_ENABLE() uint16 {
	return volatile.LoadUint16(&o.MMPUACA3.Reg) & 0x1
}
func (o *RMPU_Type) SetMMPUACA3_RP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA3.Reg, volatile.LoadUint16(&o.MMPUACA3.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetMMPUACA3_RP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA3.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetMMPUACA3_WP(value uint16) {
	volatile.StoreUint16(&o.MMPUACA3.Reg, volatile.LoadUint16(&o.MMPUACA3.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetMMPUACA3_WP() uint16 {
	return (volatile.LoadUint16(&o.MMPUACA3.Reg) & 0x4) >> 2
}

// RMPU.MMPUSA3: Group A Region %s Start Address Register
func (o *RMPU_Type) SetMMPUSA3(value uint32) {
	volatile.StoreUint32(&o.MMPUSA3.Reg, value)
}
func (o *RMPU_Type) GetMMPUSA3() uint32 {
	return volatile.LoadUint32(&o.MMPUSA3.Reg)
}

// RMPU.MMPUEA3: Group A Region %s End Address Register
func (o *RMPU_Type) SetMMPUEA3(value uint32) {
	volatile.StoreUint32(&o.MMPUEA3.Reg, value)
}
func (o *RMPU_Type) GetMMPUEA3() uint32 {
	return volatile.LoadUint32(&o.MMPUEA3.Reg)
}

// RMPU.SMPUCTL: Slave MPU Control Register
func (o *RMPU_Type) SetSMPUCTL_OAD(value uint16) {
	volatile.StoreUint16(&o.SMPUCTL.Reg, volatile.LoadUint16(&o.SMPUCTL.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetSMPUCTL_OAD() uint16 {
	return volatile.LoadUint16(&o.SMPUCTL.Reg) & 0x1
}
func (o *RMPU_Type) SetSMPUCTL_PROTECT(value uint16) {
	volatile.StoreUint16(&o.SMPUCTL.Reg, volatile.LoadUint16(&o.SMPUCTL.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetSMPUCTL_PROTECT() uint16 {
	return (volatile.LoadUint16(&o.SMPUCTL.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetSMPUCTL_KEY(value uint16) {
	volatile.StoreUint16(&o.SMPUCTL.Reg, volatile.LoadUint16(&o.SMPUCTL.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetSMPUCTL_KEY() uint16 {
	return (volatile.LoadUint16(&o.SMPUCTL.Reg) & 0xff00) >> 8
}

// RMPU.SMPUMBIU: Access Control Register for Memory Bus 1
func (o *RMPU_Type) SetSMPUMBIU_RPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUMBIU.Reg, volatile.LoadUint16(&o.SMPUMBIU.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetSMPUMBIU_RPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUMBIU.Reg) & 0x4) >> 2
}
func (o *RMPU_Type) SetSMPUMBIU_WPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUMBIU.Reg, volatile.LoadUint16(&o.SMPUMBIU.Reg)&^(0x8)|value<<3)
}
func (o *RMPU_Type) GetSMPUMBIU_WPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUMBIU.Reg) & 0x8) >> 3
}

// RMPU.SMPUFBIU: Access Control Register for Internal Peripheral Bus 9
func (o *RMPU_Type) SetSMPUFBIU_RPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUFBIU.Reg, volatile.LoadUint16(&o.SMPUFBIU.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetSMPUFBIU_RPCPU() uint16 {
	return volatile.LoadUint16(&o.SMPUFBIU.Reg) & 0x1
}
func (o *RMPU_Type) SetSMPUFBIU_WPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUFBIU.Reg, volatile.LoadUint16(&o.SMPUFBIU.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetSMPUFBIU_WPCPU() uint16 {
	return (volatile.LoadUint16(&o.SMPUFBIU.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetSMPUFBIU_RPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUFBIU.Reg, volatile.LoadUint16(&o.SMPUFBIU.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetSMPUFBIU_RPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUFBIU.Reg) & 0x4) >> 2
}
func (o *RMPU_Type) SetSMPUFBIU_WPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUFBIU.Reg, volatile.LoadUint16(&o.SMPUFBIU.Reg)&^(0x8)|value<<3)
}
func (o *RMPU_Type) GetSMPUFBIU_WPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUFBIU.Reg) & 0x8) >> 3
}

// RMPU.SMPUSRAM0: Access Control Register for Memory Bus 4
func (o *RMPU_Type) SetSMPUSRAM0_RPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUSRAM0.Reg, volatile.LoadUint16(&o.SMPUSRAM0.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetSMPUSRAM0_RPCPU() uint16 {
	return volatile.LoadUint16(&o.SMPUSRAM0.Reg) & 0x1
}
func (o *RMPU_Type) SetSMPUSRAM0_WPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUSRAM0.Reg, volatile.LoadUint16(&o.SMPUSRAM0.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetSMPUSRAM0_WPCPU() uint16 {
	return (volatile.LoadUint16(&o.SMPUSRAM0.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetSMPUSRAM0_RPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUSRAM0.Reg, volatile.LoadUint16(&o.SMPUSRAM0.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetSMPUSRAM0_RPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUSRAM0.Reg) & 0x4) >> 2
}
func (o *RMPU_Type) SetSMPUSRAM0_WPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUSRAM0.Reg, volatile.LoadUint16(&o.SMPUSRAM0.Reg)&^(0x8)|value<<3)
}
func (o *RMPU_Type) GetSMPUSRAM0_WPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUSRAM0.Reg) & 0x8) >> 3
}

// RMPU.SMPUP0BIU: Access Control Register for Internal Peripheral Bus 1
func (o *RMPU_Type) SetSMPUP0BIU_RPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUP0BIU.Reg, volatile.LoadUint16(&o.SMPUP0BIU.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetSMPUP0BIU_RPCPU() uint16 {
	return volatile.LoadUint16(&o.SMPUP0BIU.Reg) & 0x1
}
func (o *RMPU_Type) SetSMPUP0BIU_WPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUP0BIU.Reg, volatile.LoadUint16(&o.SMPUP0BIU.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetSMPUP0BIU_WPCPU() uint16 {
	return (volatile.LoadUint16(&o.SMPUP0BIU.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetSMPUP0BIU_RPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUP0BIU.Reg, volatile.LoadUint16(&o.SMPUP0BIU.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetSMPUP0BIU_RPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUP0BIU.Reg) & 0x4) >> 2
}
func (o *RMPU_Type) SetSMPUP0BIU_WPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUP0BIU.Reg, volatile.LoadUint16(&o.SMPUP0BIU.Reg)&^(0x8)|value<<3)
}
func (o *RMPU_Type) GetSMPUP0BIU_WPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUP0BIU.Reg) & 0x8) >> 3
}

// RMPU.SMPUP2BIU: Access Control Register for Internal Peripheral Bus 3
func (o *RMPU_Type) SetSMPUP2BIU_RPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUP2BIU.Reg, volatile.LoadUint16(&o.SMPUP2BIU.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetSMPUP2BIU_RPCPU() uint16 {
	return volatile.LoadUint16(&o.SMPUP2BIU.Reg) & 0x1
}
func (o *RMPU_Type) SetSMPUP2BIU_WPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUP2BIU.Reg, volatile.LoadUint16(&o.SMPUP2BIU.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetSMPUP2BIU_WPCPU() uint16 {
	return (volatile.LoadUint16(&o.SMPUP2BIU.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetSMPUP2BIU_RPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUP2BIU.Reg, volatile.LoadUint16(&o.SMPUP2BIU.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetSMPUP2BIU_RPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUP2BIU.Reg) & 0x4) >> 2
}
func (o *RMPU_Type) SetSMPUP2BIU_WPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUP2BIU.Reg, volatile.LoadUint16(&o.SMPUP2BIU.Reg)&^(0x8)|value<<3)
}
func (o *RMPU_Type) GetSMPUP2BIU_WPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUP2BIU.Reg) & 0x8) >> 3
}

// RMPU.SMPUP6BIU: Access Control Register for Internal Peripheral Bus 7
func (o *RMPU_Type) SetSMPUP6BIU_RPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUP6BIU.Reg, volatile.LoadUint16(&o.SMPUP6BIU.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetSMPUP6BIU_RPCPU() uint16 {
	return volatile.LoadUint16(&o.SMPUP6BIU.Reg) & 0x1
}
func (o *RMPU_Type) SetSMPUP6BIU_WPCPU(value uint16) {
	volatile.StoreUint16(&o.SMPUP6BIU.Reg, volatile.LoadUint16(&o.SMPUP6BIU.Reg)&^(0x2)|value<<1)
}
func (o *RMPU_Type) GetSMPUP6BIU_WPCPU() uint16 {
	return (volatile.LoadUint16(&o.SMPUP6BIU.Reg) & 0x2) >> 1
}
func (o *RMPU_Type) SetSMPUP6BIU_RPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUP6BIU.Reg, volatile.LoadUint16(&o.SMPUP6BIU.Reg)&^(0x4)|value<<2)
}
func (o *RMPU_Type) GetSMPUP6BIU_RPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUP6BIU.Reg) & 0x4) >> 2
}
func (o *RMPU_Type) SetSMPUP6BIU_WPGRPA(value uint16) {
	volatile.StoreUint16(&o.SMPUP6BIU.Reg, volatile.LoadUint16(&o.SMPUP6BIU.Reg)&^(0x8)|value<<3)
}
func (o *RMPU_Type) GetSMPUP6BIU_WPGRPA() uint16 {
	return (volatile.LoadUint16(&o.SMPUP6BIU.Reg) & 0x8) >> 3
}

// RMPU.MSPMPUOAD: Stack Pointer Monitor Operation After Detection Register
func (o *RMPU_Type) SetMSPMPUOAD_OAD(value uint16) {
	volatile.StoreUint16(&o.MSPMPUOAD.Reg, volatile.LoadUint16(&o.MSPMPUOAD.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMSPMPUOAD_OAD() uint16 {
	return volatile.LoadUint16(&o.MSPMPUOAD.Reg) & 0x1
}
func (o *RMPU_Type) SetMSPMPUOAD_KEY(value uint16) {
	volatile.StoreUint16(&o.MSPMPUOAD.Reg, volatile.LoadUint16(&o.MSPMPUOAD.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetMSPMPUOAD_KEY() uint16 {
	return (volatile.LoadUint16(&o.MSPMPUOAD.Reg) & 0xff00) >> 8
}

// RMPU.MSPMPUCTL: Stack Pointer Monitor Access Control Register
func (o *RMPU_Type) SetMSPMPUCTL_ENABLE(value uint16) {
	volatile.StoreUint16(&o.MSPMPUCTL.Reg, volatile.LoadUint16(&o.MSPMPUCTL.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMSPMPUCTL_ENABLE() uint16 {
	return volatile.LoadUint16(&o.MSPMPUCTL.Reg) & 0x1
}
func (o *RMPU_Type) SetMSPMPUCTL_ERROR(value uint16) {
	volatile.StoreUint16(&o.MSPMPUCTL.Reg, volatile.LoadUint16(&o.MSPMPUCTL.Reg)&^(0x100)|value<<8)
}
func (o *RMPU_Type) GetMSPMPUCTL_ERROR() uint16 {
	return (volatile.LoadUint16(&o.MSPMPUCTL.Reg) & 0x100) >> 8
}

// RMPU.MSPMPUPT: Stack Pointer Monitor Protection Register
func (o *RMPU_Type) SetMSPMPUPT_PROTECT(value uint16) {
	volatile.StoreUint16(&o.MSPMPUPT.Reg, volatile.LoadUint16(&o.MSPMPUPT.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetMSPMPUPT_PROTECT() uint16 {
	return volatile.LoadUint16(&o.MSPMPUPT.Reg) & 0x1
}
func (o *RMPU_Type) SetMSPMPUPT_KEY(value uint16) {
	volatile.StoreUint16(&o.MSPMPUPT.Reg, volatile.LoadUint16(&o.MSPMPUPT.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetMSPMPUPT_KEY() uint16 {
	return (volatile.LoadUint16(&o.MSPMPUPT.Reg) & 0xff00) >> 8
}

// RMPU.MSPMPUSA: Main Stack Pointer (MSP) Monitor Start Address Register
func (o *RMPU_Type) SetMSPMPUSA(value uint32) {
	volatile.StoreUint32(&o.MSPMPUSA.Reg, value)
}
func (o *RMPU_Type) GetMSPMPUSA() uint32 {
	return volatile.LoadUint32(&o.MSPMPUSA.Reg)
}

// RMPU.MSPMPUEA: Main Stack Pointer (MSP) Monitor End Address Register
func (o *RMPU_Type) SetMSPMPUEA(value uint32) {
	volatile.StoreUint32(&o.MSPMPUEA.Reg, value)
}
func (o *RMPU_Type) GetMSPMPUEA() uint32 {
	return volatile.LoadUint32(&o.MSPMPUEA.Reg)
}

// RMPU.PSPMPUOAD: Stack Pointer Monitor Operation After Detection Register
func (o *RMPU_Type) SetPSPMPUOAD_OAD(value uint16) {
	volatile.StoreUint16(&o.PSPMPUOAD.Reg, volatile.LoadUint16(&o.PSPMPUOAD.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetPSPMPUOAD_OAD() uint16 {
	return volatile.LoadUint16(&o.PSPMPUOAD.Reg) & 0x1
}
func (o *RMPU_Type) SetPSPMPUOAD_KEY(value uint16) {
	volatile.StoreUint16(&o.PSPMPUOAD.Reg, volatile.LoadUint16(&o.PSPMPUOAD.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetPSPMPUOAD_KEY() uint16 {
	return (volatile.LoadUint16(&o.PSPMPUOAD.Reg) & 0xff00) >> 8
}

// RMPU.PSPMPUCTL: Stack Pointer Monitor Access Control Register
func (o *RMPU_Type) SetPSPMPUCTL_ENABLE(value uint16) {
	volatile.StoreUint16(&o.PSPMPUCTL.Reg, volatile.LoadUint16(&o.PSPMPUCTL.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetPSPMPUCTL_ENABLE() uint16 {
	return volatile.LoadUint16(&o.PSPMPUCTL.Reg) & 0x1
}
func (o *RMPU_Type) SetPSPMPUCTL_ERROR(value uint16) {
	volatile.StoreUint16(&o.PSPMPUCTL.Reg, volatile.LoadUint16(&o.PSPMPUCTL.Reg)&^(0x100)|value<<8)
}
func (o *RMPU_Type) GetPSPMPUCTL_ERROR() uint16 {
	return (volatile.LoadUint16(&o.PSPMPUCTL.Reg) & 0x100) >> 8
}

// RMPU.PSPMPUPT: Stack Pointer Monitor Protection Register
func (o *RMPU_Type) SetPSPMPUPT_PROTECT(value uint16) {
	volatile.StoreUint16(&o.PSPMPUPT.Reg, volatile.LoadUint16(&o.PSPMPUPT.Reg)&^(0x1)|value)
}
func (o *RMPU_Type) GetPSPMPUPT_PROTECT() uint16 {
	return volatile.LoadUint16(&o.PSPMPUPT.Reg) & 0x1
}
func (o *RMPU_Type) SetPSPMPUPT_KEY(value uint16) {
	volatile.StoreUint16(&o.PSPMPUPT.Reg, volatile.LoadUint16(&o.PSPMPUPT.Reg)&^(0xff00)|value<<8)
}
func (o *RMPU_Type) GetPSPMPUPT_KEY() uint16 {
	return (volatile.LoadUint16(&o.PSPMPUPT.Reg) & 0xff00) >> 8
}

// RMPU.PSPMPUSA: Process Stack Pointer (PSP) Monitor Start Address Register
func (o *RMPU_Type) SetPSPMPUSA(value uint32) {
	volatile.StoreUint32(&o.PSPMPUSA.Reg, value)
}
func (o *RMPU_Type) GetPSPMPUSA() uint32 {
	return volatile.LoadUint32(&o.PSPMPUSA.Reg)
}

// RMPU.PSPMPUEA: Process Stack Pointer (PSP) Monitor End Address Register
func (o *RMPU_Type) SetPSPMPUEA(value uint32) {
	volatile.StoreUint32(&o.PSPMPUEA.Reg, value)
}
func (o *RMPU_Type) GetPSPMPUEA() uint32 {
	return volatile.LoadUint32(&o.PSPMPUEA.Reg)
}

// SRAM Control
type SRAM_Type struct {
	PARIOAD  volatile.Register8 // 0x0
	_        [3]byte
	SRAMPRCR volatile.Register8 // 0x4
}

// SRAM.PARIOAD: SRAM Parity Error Operation After Detection Register
func (o *SRAM_Type) SetPARIOAD_OAD(value uint8) {
	volatile.StoreUint8(&o.PARIOAD.Reg, volatile.LoadUint8(&o.PARIOAD.Reg)&^(0x1)|value)
}
func (o *SRAM_Type) GetPARIOAD_OAD() uint8 {
	return volatile.LoadUint8(&o.PARIOAD.Reg) & 0x1
}

// SRAM.SRAMPRCR: SRAM Protection Register
func (o *SRAM_Type) SetSRAMPRCR(value uint8) {
	volatile.StoreUint8(&o.SRAMPRCR.Reg, volatile.LoadUint8(&o.SRAMPRCR.Reg)&^(0x1)|value)
}
func (o *SRAM_Type) GetSRAMPRCR() uint8 {
	return volatile.LoadUint8(&o.SRAMPRCR.Reg) & 0x1
}
func (o *SRAM_Type) SetSRAMPRCR_KW(value uint8) {
	volatile.StoreUint8(&o.SRAMPRCR.Reg, volatile.LoadUint8(&o.SRAMPRCR.Reg)&^(0xfe)|value<<1)
}
func (o *SRAM_Type) GetSRAMPRCR_KW() uint8 {
	return (volatile.LoadUint8(&o.SRAMPRCR.Reg) & 0xfe) >> 1
}

// BUS Control
type BUS_Type struct {
	_           [4104]byte
	BUSMCNTSYS  volatile.Register16 // 0x1008
	_           [2]byte
	BUSMCNTDMA  volatile.Register16 // 0x100C
	_           [2066]byte
	BUS3ERRADD  volatile.Register32 // 0x1820
	BUS3ERRSTAT volatile.Register8  // 0x1824
	_           [11]byte
	BUS4ERRADD  volatile.Register32 // 0x1830
	BUS4ERRSTAT volatile.Register8  // 0x1834
}

// BUS.BUSMCNTSYS: Master Bus Control Register SYS
func (o *BUS_Type) SetBUSMCNTSYS_IERES(value uint16) {
	volatile.StoreUint16(&o.BUSMCNTSYS.Reg, volatile.LoadUint16(&o.BUSMCNTSYS.Reg)&^(0x8000)|value<<15)
}
func (o *BUS_Type) GetBUSMCNTSYS_IERES() uint16 {
	return (volatile.LoadUint16(&o.BUSMCNTSYS.Reg) & 0x8000) >> 15
}

// BUS.BUSMCNTDMA: Master Bus Control Register DMA
func (o *BUS_Type) SetBUSMCNTDMA_IERES(value uint16) {
	volatile.StoreUint16(&o.BUSMCNTDMA.Reg, volatile.LoadUint16(&o.BUSMCNTDMA.Reg)&^(0x8000)|value<<15)
}
func (o *BUS_Type) GetBUSMCNTDMA_IERES() uint16 {
	return (volatile.LoadUint16(&o.BUSMCNTDMA.Reg) & 0x8000) >> 15
}

// BUS.BUS3ERRADD: Bus Error Address Register 3
func (o *BUS_Type) SetBUS3ERRADD(value uint32) {
	volatile.StoreUint32(&o.BUS3ERRADD.Reg, value)
}
func (o *BUS_Type) GetBUS3ERRADD() uint32 {
	return volatile.LoadUint32(&o.BUS3ERRADD.Reg)
}

// BUS.BUS3ERRSTAT: BUS Error Status Register 3
func (o *BUS_Type) SetBUS3ERRSTAT_ACCSTAT(value uint8) {
	volatile.StoreUint8(&o.BUS3ERRSTAT.Reg, volatile.LoadUint8(&o.BUS3ERRSTAT.Reg)&^(0x1)|value)
}
func (o *BUS_Type) GetBUS3ERRSTAT_ACCSTAT() uint8 {
	return volatile.LoadUint8(&o.BUS3ERRSTAT.Reg) & 0x1
}
func (o *BUS_Type) SetBUS3ERRSTAT_ERRSTAT(value uint8) {
	volatile.StoreUint8(&o.BUS3ERRSTAT.Reg, volatile.LoadUint8(&o.BUS3ERRSTAT.Reg)&^(0x80)|value<<7)
}
func (o *BUS_Type) GetBUS3ERRSTAT_ERRSTAT() uint8 {
	return (volatile.LoadUint8(&o.BUS3ERRSTAT.Reg) & 0x80) >> 7
}

// BUS.BUS4ERRADD: Bus Error Address Register 4
func (o *BUS_Type) SetBUS4ERRADD(value uint32) {
	volatile.StoreUint32(&o.BUS4ERRADD.Reg, value)
}
func (o *BUS_Type) GetBUS4ERRADD() uint32 {
	return volatile.LoadUint32(&o.BUS4ERRADD.Reg)
}

// BUS.BUS4ERRSTAT: BUS Error Status Register 4
func (o *BUS_Type) SetBUS4ERRSTAT_ACCSTAT(value uint8) {
	volatile.StoreUint8(&o.BUS4ERRSTAT.Reg, volatile.LoadUint8(&o.BUS4ERRSTAT.Reg)&^(0x1)|value)
}
func (o *BUS_Type) GetBUS4ERRSTAT_ACCSTAT() uint8 {
	return volatile.LoadUint8(&o.BUS4ERRSTAT.Reg) & 0x1
}
func (o *BUS_Type) SetBUS4ERRSTAT_ERRSTAT(value uint8) {
	volatile.StoreUint8(&o.BUS4ERRSTAT.Reg, volatile.LoadUint8(&o.BUS4ERRSTAT.Reg)&^(0x80)|value<<7)
}
func (o *BUS_Type) GetBUS4ERRSTAT_ERRSTAT() uint8 {
	return (volatile.LoadUint8(&o.BUS4ERRSTAT.Reg) & 0x80) >> 7
}

// Data Transfer Controller
type DTC_Type struct {
	DTCCR  volatile.Register8 // 0x0
	_      [3]byte
	DTCVBR volatile.Register32 // 0x4
	_      [4]byte
	DTCST  volatile.Register8 // 0xC
	_      byte
	DTCSTS volatile.Register16 // 0xE
}

// DTC.DTCCR: DTC Control Register
func (o *DTC_Type) SetDTCCR_RRS(value uint8) {
	volatile.StoreUint8(&o.DTCCR.Reg, volatile.LoadUint8(&o.DTCCR.Reg)&^(0x10)|value<<4)
}
func (o *DTC_Type) GetDTCCR_RRS() uint8 {
	return (volatile.LoadUint8(&o.DTCCR.Reg) & 0x10) >> 4
}

// DTC.DTCST: DTC Module Start Register
func (o *DTC_Type) SetDTCST(value uint8) {
	volatile.StoreUint8(&o.DTCST.Reg, volatile.LoadUint8(&o.DTCST.Reg)&^(0x1)|value)
}
func (o *DTC_Type) GetDTCST() uint8 {
	return volatile.LoadUint8(&o.DTCST.Reg) & 0x1
}

// DTC.DTCSTS: DTC Status Register
func (o *DTC_Type) SetDTCSTS_VECN(value uint16) {
	volatile.StoreUint16(&o.DTCSTS.Reg, volatile.LoadUint16(&o.DTCSTS.Reg)&^(0xff)|value)
}
func (o *DTC_Type) GetDTCSTS_VECN() uint16 {
	return volatile.LoadUint16(&o.DTCSTS.Reg) & 0xff
}
func (o *DTC_Type) SetDTCSTS_ACT(value uint16) {
	volatile.StoreUint16(&o.DTCSTS.Reg, volatile.LoadUint16(&o.DTCSTS.Reg)&^(0x8000)|value<<15)
}
func (o *DTC_Type) GetDTCSTS_ACT() uint16 {
	return (volatile.LoadUint16(&o.DTCSTS.Reg) & 0x8000) >> 15
}

// ICU for CPU
type ICU_Type struct {
	IRQCR0  volatile.Register8 // 0x0
	IRQCR1  volatile.Register8 // 0x1
	IRQCR2  volatile.Register8 // 0x2
	IRQCR3  volatile.Register8 // 0x3
	IRQCR4  volatile.Register8 // 0x4
	IRQCR5  volatile.Register8 // 0x5
	IRQCR6  volatile.Register8 // 0x6
	IRQCR7  volatile.Register8 // 0x7
	_       [248]byte
	NMICR   volatile.Register8 // 0x100
	_       [31]byte
	NMIER   volatile.Register16 // 0x120
	_       [14]byte
	NMICLR  volatile.Register16 // 0x130
	_       [14]byte
	NMISR   volatile.Register16 // 0x140
	_       [94]byte
	WUPEN   volatile.Register32 // 0x1A0
	_       [28]byte
	IELEN   volatile.Register8 // 0x1C0
	_       [63]byte
	SELSR0  volatile.Register16 // 0x200
	_       [254]byte
	IELSR0  volatile.Register32 // 0x300
	IELSR1  volatile.Register32 // 0x304
	IELSR2  volatile.Register32 // 0x308
	IELSR3  volatile.Register32 // 0x30C
	IELSR4  volatile.Register32 // 0x310
	IELSR5  volatile.Register32 // 0x314
	IELSR6  volatile.Register32 // 0x318
	IELSR7  volatile.Register32 // 0x31C
	IELSR8  volatile.Register32 // 0x320
	IELSR9  volatile.Register32 // 0x324
	IELSR10 volatile.Register32 // 0x328
	IELSR11 volatile.Register32 // 0x32C
	IELSR12 volatile.Register32 // 0x330
	IELSR13 volatile.Register32 // 0x334
	IELSR14 volatile.Register32 // 0x338
	IELSR15 volatile.Register32 // 0x33C
	IELSR16 volatile.Register32 // 0x340
	IELSR17 volatile.Register32 // 0x344
	IELSR18 volatile.Register32 // 0x348
	IELSR19 volatile.Register32 // 0x34C
	IELSR20 volatile.Register32 // 0x350
	IELSR21 volatile.Register32 // 0x354
	IELSR22 volatile.Register32 // 0x358
	IELSR23 volatile.Register32 // 0x35C
	IELSR24 volatile.Register32 // 0x360
	IELSR25 volatile.Register32 // 0x364
	IELSR26 volatile.Register32 // 0x368
	IELSR27 volatile.Register32 // 0x36C
	IELSR28 volatile.Register32 // 0x370
	IELSR29 volatile.Register32 // 0x374
	IELSR30 volatile.Register32 // 0x378
	IELSR31 volatile.Register32 // 0x37C
}

// ICU.IRQCR0: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR0_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR0.Reg, volatile.LoadUint8(&o.IRQCR0.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR0_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR0.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR0_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR0.Reg, volatile.LoadUint8(&o.IRQCR0.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR0_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR0.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR0_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR0.Reg, volatile.LoadUint8(&o.IRQCR0.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR0_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR0.Reg) & 0x80) >> 7
}

// ICU.IRQCR1: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR1_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR1.Reg, volatile.LoadUint8(&o.IRQCR1.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR1_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR1.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR1_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR1.Reg, volatile.LoadUint8(&o.IRQCR1.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR1_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR1.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR1_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR1.Reg, volatile.LoadUint8(&o.IRQCR1.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR1_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR1.Reg) & 0x80) >> 7
}

// ICU.IRQCR2: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR2_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR2.Reg, volatile.LoadUint8(&o.IRQCR2.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR2_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR2.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR2_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR2.Reg, volatile.LoadUint8(&o.IRQCR2.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR2_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR2.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR2_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR2.Reg, volatile.LoadUint8(&o.IRQCR2.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR2_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR2.Reg) & 0x80) >> 7
}

// ICU.IRQCR3: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR3_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR3.Reg, volatile.LoadUint8(&o.IRQCR3.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR3_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR3.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR3_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR3.Reg, volatile.LoadUint8(&o.IRQCR3.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR3_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR3.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR3_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR3.Reg, volatile.LoadUint8(&o.IRQCR3.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR3_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR3.Reg) & 0x80) >> 7
}

// ICU.IRQCR4: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR4_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR4.Reg, volatile.LoadUint8(&o.IRQCR4.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR4_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR4.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR4_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR4.Reg, volatile.LoadUint8(&o.IRQCR4.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR4_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR4.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR4_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR4.Reg, volatile.LoadUint8(&o.IRQCR4.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR4_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR4.Reg) & 0x80) >> 7
}

// ICU.IRQCR5: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR5_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR5.Reg, volatile.LoadUint8(&o.IRQCR5.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR5_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR5.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR5_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR5.Reg, volatile.LoadUint8(&o.IRQCR5.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR5_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR5.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR5_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR5.Reg, volatile.LoadUint8(&o.IRQCR5.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR5_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR5.Reg) & 0x80) >> 7
}

// ICU.IRQCR6: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR6_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR6.Reg, volatile.LoadUint8(&o.IRQCR6.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR6_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR6.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR6_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR6.Reg, volatile.LoadUint8(&o.IRQCR6.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR6_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR6.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR6_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR6.Reg, volatile.LoadUint8(&o.IRQCR6.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR6_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR6.Reg) & 0x80) >> 7
}

// ICU.IRQCR7: IRQ Control Register %s
func (o *ICU_Type) SetIRQCR7_IRQMD(value uint8) {
	volatile.StoreUint8(&o.IRQCR7.Reg, volatile.LoadUint8(&o.IRQCR7.Reg)&^(0x3)|value)
}
func (o *ICU_Type) GetIRQCR7_IRQMD() uint8 {
	return volatile.LoadUint8(&o.IRQCR7.Reg) & 0x3
}
func (o *ICU_Type) SetIRQCR7_FCLKSEL(value uint8) {
	volatile.StoreUint8(&o.IRQCR7.Reg, volatile.LoadUint8(&o.IRQCR7.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetIRQCR7_FCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.IRQCR7.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetIRQCR7_FLTEN(value uint8) {
	volatile.StoreUint8(&o.IRQCR7.Reg, volatile.LoadUint8(&o.IRQCR7.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetIRQCR7_FLTEN() uint8 {
	return (volatile.LoadUint8(&o.IRQCR7.Reg) & 0x80) >> 7
}

// ICU.NMICR: NMI Pin Interrupt Control Register
func (o *ICU_Type) SetNMICR_NMIMD(value uint8) {
	volatile.StoreUint8(&o.NMICR.Reg, volatile.LoadUint8(&o.NMICR.Reg)&^(0x1)|value)
}
func (o *ICU_Type) GetNMICR_NMIMD() uint8 {
	return volatile.LoadUint8(&o.NMICR.Reg) & 0x1
}
func (o *ICU_Type) SetNMICR_NFCLKSEL(value uint8) {
	volatile.StoreUint8(&o.NMICR.Reg, volatile.LoadUint8(&o.NMICR.Reg)&^(0x30)|value<<4)
}
func (o *ICU_Type) GetNMICR_NFCLKSEL() uint8 {
	return (volatile.LoadUint8(&o.NMICR.Reg) & 0x30) >> 4
}
func (o *ICU_Type) SetNMICR_NFLTEN(value uint8) {
	volatile.StoreUint8(&o.NMICR.Reg, volatile.LoadUint8(&o.NMICR.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetNMICR_NFLTEN() uint8 {
	return (volatile.LoadUint8(&o.NMICR.Reg) & 0x80) >> 7
}

// ICU.NMIER: Non-Maskable Interrupt Enable Register
func (o *ICU_Type) SetNMIER_IWDTEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x1)|value)
}
func (o *ICU_Type) GetNMIER_IWDTEN() uint16 {
	return volatile.LoadUint16(&o.NMIER.Reg) & 0x1
}
func (o *ICU_Type) SetNMIER_WDTEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x2)|value<<1)
}
func (o *ICU_Type) GetNMIER_WDTEN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x2) >> 1
}
func (o *ICU_Type) SetNMIER_LVD1EN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x4)|value<<2)
}
func (o *ICU_Type) GetNMIER_LVD1EN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x4) >> 2
}
func (o *ICU_Type) SetNMIER_LVD2EN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x8)|value<<3)
}
func (o *ICU_Type) GetNMIER_LVD2EN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x8) >> 3
}
func (o *ICU_Type) SetNMIER_NMIEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetNMIER_NMIEN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x80) >> 7
}
func (o *ICU_Type) SetNMIER_RPEEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x100)|value<<8)
}
func (o *ICU_Type) GetNMIER_RPEEN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x100) >> 8
}
func (o *ICU_Type) SetNMIER_BUSSEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x400)|value<<10)
}
func (o *ICU_Type) GetNMIER_BUSSEN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x400) >> 10
}
func (o *ICU_Type) SetNMIER_BUSMEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x800)|value<<11)
}
func (o *ICU_Type) GetNMIER_BUSMEN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x800) >> 11
}
func (o *ICU_Type) SetNMIER_SPEEN(value uint16) {
	volatile.StoreUint16(&o.NMIER.Reg, volatile.LoadUint16(&o.NMIER.Reg)&^(0x1000)|value<<12)
}
func (o *ICU_Type) GetNMIER_SPEEN() uint16 {
	return (volatile.LoadUint16(&o.NMIER.Reg) & 0x1000) >> 12
}

// ICU.NMICLR: Non-Maskable Interrupt Status Clear Register
func (o *ICU_Type) SetNMICLR_IWDTCLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x1)|value)
}
func (o *ICU_Type) GetNMICLR_IWDTCLR() uint16 {
	return volatile.LoadUint16(&o.NMICLR.Reg) & 0x1
}
func (o *ICU_Type) SetNMICLR_WDTCLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x2)|value<<1)
}
func (o *ICU_Type) GetNMICLR_WDTCLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x2) >> 1
}
func (o *ICU_Type) SetNMICLR_LVD1CLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x4)|value<<2)
}
func (o *ICU_Type) GetNMICLR_LVD1CLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x4) >> 2
}
func (o *ICU_Type) SetNMICLR_LVD2CLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x8)|value<<3)
}
func (o *ICU_Type) GetNMICLR_LVD2CLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x8) >> 3
}
func (o *ICU_Type) SetNMICLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetNMICLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x80) >> 7
}
func (o *ICU_Type) SetNMICLR_RPECLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x100)|value<<8)
}
func (o *ICU_Type) GetNMICLR_RPECLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x100) >> 8
}
func (o *ICU_Type) SetNMICLR_BUSSCLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x400)|value<<10)
}
func (o *ICU_Type) GetNMICLR_BUSSCLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x400) >> 10
}
func (o *ICU_Type) SetNMICLR_BUSMCLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x800)|value<<11)
}
func (o *ICU_Type) GetNMICLR_BUSMCLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x800) >> 11
}
func (o *ICU_Type) SetNMICLR_SPECLR(value uint16) {
	volatile.StoreUint16(&o.NMICLR.Reg, volatile.LoadUint16(&o.NMICLR.Reg)&^(0x1000)|value<<12)
}
func (o *ICU_Type) GetNMICLR_SPECLR() uint16 {
	return (volatile.LoadUint16(&o.NMICLR.Reg) & 0x1000) >> 12
}

// ICU.NMISR: Non-Maskable Interrupt Status Register
func (o *ICU_Type) SetNMISR_IWDTST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x1)|value)
}
func (o *ICU_Type) GetNMISR_IWDTST() uint16 {
	return volatile.LoadUint16(&o.NMISR.Reg) & 0x1
}
func (o *ICU_Type) SetNMISR_WDTST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x2)|value<<1)
}
func (o *ICU_Type) GetNMISR_WDTST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x2) >> 1
}
func (o *ICU_Type) SetNMISR_LVD1ST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x4)|value<<2)
}
func (o *ICU_Type) GetNMISR_LVD1ST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x4) >> 2
}
func (o *ICU_Type) SetNMISR_LVD2ST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x8)|value<<3)
}
func (o *ICU_Type) GetNMISR_LVD2ST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x8) >> 3
}
func (o *ICU_Type) SetNMISR_NMIST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x80)|value<<7)
}
func (o *ICU_Type) GetNMISR_NMIST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x80) >> 7
}
func (o *ICU_Type) SetNMISR_RPEST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x100)|value<<8)
}
func (o *ICU_Type) GetNMISR_RPEST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x100) >> 8
}
func (o *ICU_Type) SetNMISR_BUSSST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x400)|value<<10)
}
func (o *ICU_Type) GetNMISR_BUSSST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x400) >> 10
}
func (o *ICU_Type) SetNMISR_BUSMST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x800)|value<<11)
}
func (o *ICU_Type) GetNMISR_BUSMST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x800) >> 11
}
func (o *ICU_Type) SetNMISR_SPEST(value uint16) {
	volatile.StoreUint16(&o.NMISR.Reg, volatile.LoadUint16(&o.NMISR.Reg)&^(0x1000)|value<<12)
}
func (o *ICU_Type) GetNMISR_SPEST() uint16 {
	return (volatile.LoadUint16(&o.NMISR.Reg) & 0x1000) >> 12
}

// ICU.WUPEN: Wake Up Interrupt Enable Register
func (o *ICU_Type) SetWUPEN_IRQWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0xff)|value)
}
func (o *ICU_Type) GetWUPEN_IRQWUPEN() uint32 {
	return volatile.LoadUint32(&o.WUPEN.Reg) & 0xff
}
func (o *ICU_Type) SetWUPEN_IWDTWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x10000)|value<<16)
}
func (o *ICU_Type) GetWUPEN_IWDTWUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x10000) >> 16
}
func (o *ICU_Type) SetWUPEN_KEYWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x20000)|value<<17)
}
func (o *ICU_Type) GetWUPEN_KEYWUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x20000) >> 17
}
func (o *ICU_Type) SetWUPEN_LVD1WUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x40000)|value<<18)
}
func (o *ICU_Type) GetWUPEN_LVD1WUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x40000) >> 18
}
func (o *ICU_Type) SetWUPEN_LVD2WUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x80000)|value<<19)
}
func (o *ICU_Type) GetWUPEN_LVD2WUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x80000) >> 19
}
func (o *ICU_Type) SetWUPEN_AGT1UDWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x10000000)|value<<28)
}
func (o *ICU_Type) GetWUPEN_AGT1UDWUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x10000000) >> 28
}
func (o *ICU_Type) SetWUPEN_AGT1CAWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x20000000)|value<<29)
}
func (o *ICU_Type) GetWUPEN_AGT1CAWUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x20000000) >> 29
}
func (o *ICU_Type) SetWUPEN_AGT1CBWUPEN(value uint32) {
	volatile.StoreUint32(&o.WUPEN.Reg, volatile.LoadUint32(&o.WUPEN.Reg)&^(0x40000000)|value<<30)
}
func (o *ICU_Type) GetWUPEN_AGT1CBWUPEN() uint32 {
	return (volatile.LoadUint32(&o.WUPEN.Reg) & 0x40000000) >> 30
}

// ICU.IELEN: ICU event Enable Register
func (o *ICU_Type) SetIELEN(value uint8) {
	volatile.StoreUint8(&o.IELEN.Reg, volatile.LoadUint8(&o.IELEN.Reg)&^(0x2)|value<<1)
}
func (o *ICU_Type) GetIELEN() uint8 {
	return (volatile.LoadUint8(&o.IELEN.Reg) & 0x2) >> 1
}

// Debug Function
type DBG_Type struct {
	DBGSTR    volatile.Register32 // 0x0
	_         [12]byte
	DBGSTOPCR volatile.Register32 // 0x10
}

// DBG.DBGSTR: Debug Status Register
func (o *DBG_Type) SetDBGSTR_CDBGPWRUPREQ(value uint32) {
	volatile.StoreUint32(&o.DBGSTR.Reg, volatile.LoadUint32(&o.DBGSTR.Reg)&^(0x10000000)|value<<28)
}
func (o *DBG_Type) GetDBGSTR_CDBGPWRUPREQ() uint32 {
	return (volatile.LoadUint32(&o.DBGSTR.Reg) & 0x10000000) >> 28
}
func (o *DBG_Type) SetDBGSTR_CDBGPWRUPACK(value uint32) {
	volatile.StoreUint32(&o.DBGSTR.Reg, volatile.LoadUint32(&o.DBGSTR.Reg)&^(0x20000000)|value<<29)
}
func (o *DBG_Type) GetDBGSTR_CDBGPWRUPACK() uint32 {
	return (volatile.LoadUint32(&o.DBGSTR.Reg) & 0x20000000) >> 29
}

// DBG.DBGSTOPCR: Debug Stop Control Register
func (o *DBG_Type) SetDBGSTOPCR_DBGSTOP_IWDT(value uint32) {
	volatile.StoreUint32(&o.DBGSTOPCR.Reg, volatile.LoadUint32(&o.DBGSTOPCR.Reg)&^(0x1)|value)
}
func (o *DBG_Type) GetDBGSTOPCR_DBGSTOP_IWDT() uint32 {
	return volatile.LoadUint32(&o.DBGSTOPCR.Reg) & 0x1
}
func (o *DBG_Type) SetDBGSTOPCR_DBGSTOP_WDT(value uint32) {
	volatile.StoreUint32(&o.DBGSTOPCR.Reg, volatile.LoadUint32(&o.DBGSTOPCR.Reg)&^(0x2)|value<<1)
}
func (o *DBG_Type) GetDBGSTOPCR_DBGSTOP_WDT() uint32 {
	return (volatile.LoadUint32(&o.DBGSTOPCR.Reg) & 0x2) >> 1
}
func (o *DBG_Type) SetDBGSTOPCR_DBGSTOP_LVD0(value uint32) {
	volatile.StoreUint32(&o.DBGSTOPCR.Reg, volatile.LoadUint32(&o.DBGSTOPCR.Reg)&^(0x10000)|value<<16)
}
func (o *DBG_Type) GetDBGSTOPCR_DBGSTOP_LVD0() uint32 {
	return (volatile.LoadUint32(&o.DBGSTOPCR.Reg) & 0x10000) >> 16
}
func (o *DBG_Type) SetDBGSTOPCR_DBGSTOP_LVD1(value uint32) {
	volatile.StoreUint32(&o.DBGSTOPCR.Reg, volatile.LoadUint32(&o.DBGSTOPCR.Reg)&^(0x20000)|value<<17)
}
func (o *DBG_Type) GetDBGSTOPCR_DBGSTOP_LVD1() uint32 {
	return (volatile.LoadUint32(&o.DBGSTOPCR.Reg) & 0x20000) >> 17
}
func (o *DBG_Type) SetDBGSTOPCR_DBGSTOP_LVD2(value uint32) {
	volatile.StoreUint32(&o.DBGSTOPCR.Reg, volatile.LoadUint32(&o.DBGSTOPCR.Reg)&^(0x40000)|value<<18)
}
func (o *DBG_Type) GetDBGSTOPCR_DBGSTOP_LVD2() uint32 {
	return (volatile.LoadUint32(&o.DBGSTOPCR.Reg) & 0x40000) >> 18
}
func (o *DBG_Type) SetDBGSTOPCR_DBGSTOP_RPER(value uint32) {
	volatile.StoreUint32(&o.DBGSTOPCR.Reg, volatile.LoadUint32(&o.DBGSTOPCR.Reg)&^(0x1000000)|value<<24)
}
func (o *DBG_Type) GetDBGSTOPCR_DBGSTOP_RPER() uint32 {
	return (volatile.LoadUint32(&o.DBGSTOPCR.Reg) & 0x1000000) >> 24
}

// System Control
type SYSC_Type struct {
	_         [12]byte
	SBYCR     volatile.Register16 // 0xC
	_         [14]byte
	MSTPCRA   volatile.Register32 // 0x1C
	SCKDIVCR  volatile.Register32 // 0x20
	_         [2]byte
	SCKSCR    volatile.Register8 // 0x26
	_         [10]byte
	MEMWAIT   volatile.Register8 // 0x31
	_         [4]byte
	HOCOCR    volatile.Register8 // 0x36
	_         byte
	MOCOCR    volatile.Register8 // 0x38
	_         [3]byte
	OSCSF     volatile.Register8 // 0x3C
	_         byte
	CKOCR     volatile.Register8 // 0x3E
	_         [13]byte
	LPOPT     volatile.Register8 // 0x4C
	_         [20]byte
	MOCOUTCR  volatile.Register8 // 0x61
	HOCOUTCR  volatile.Register8 // 0x62
	_         [47]byte
	SNZCR     volatile.Register8 // 0x92
	_         byte
	SNZEDCR0  volatile.Register8 // 0x94
	_         [3]byte
	SNZREQCR0 volatile.Register32 // 0x98
	_         [3]byte
	PSMCR     volatile.Register8 // 0x9F
	OPCCR     volatile.Register8 // 0xA0
	_         [4]byte
	HOCOWTCR  volatile.Register8 // 0xA5
	_         [4]byte
	SOPCCR    volatile.Register8 // 0xAA
	_         [21]byte
	RSTSR1    volatile.Register16 // 0xC0
	_         [30]byte
	LVD1CR1   volatile.Register8 // 0xE0
	LVD1SR    volatile.Register8 // 0xE1
	LVD2CR1   volatile.Register8 // 0xE2
	LVD2SR    volatile.Register8 // 0xE3
	_         [794]byte
	PRCR      volatile.Register16 // 0x3FE
	_         [14]byte
	SYOCDCR   volatile.Register8 // 0x40E
	_         byte
	RSTSR0    volatile.Register8 // 0x410
	RSTSR2    volatile.Register8 // 0x411
	_         [5]byte
	LVCMPCR   volatile.Register8 // 0x417
	LVDLVLR   volatile.Register8 // 0x418
	_         byte
	LVD1CR0   volatile.Register8 // 0x41A
	LVD2CR0   volatile.Register8 // 0x41B
	_         [116]byte
	LOCOCR    volatile.Register8 // 0x490
	_         byte
	LOCOUTCR  volatile.Register8 // 0x492
}

// SYSC.SBYCR: Standby Control Register
func (o *SYSC_Type) SetSBYCR_SSBY(value uint16) {
	volatile.StoreUint16(&o.SBYCR.Reg, volatile.LoadUint16(&o.SBYCR.Reg)&^(0x8000)|value<<15)
}
func (o *SYSC_Type) GetSBYCR_SSBY() uint16 {
	return (volatile.LoadUint16(&o.SBYCR.Reg) & 0x8000) >> 15
}

// SYSC.MSTPCRA: Module Stop Control Register A
func (o *SYSC_Type) SetMSTPCRA_MSTPA22(value uint32) {
	volatile.StoreUint32(&o.MSTPCRA.Reg, volatile.LoadUint32(&o.MSTPCRA.Reg)&^(0x400000)|value<<22)
}
func (o *SYSC_Type) GetMSTPCRA_MSTPA22() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRA.Reg) & 0x400000) >> 22
}

// SYSC.SCKDIVCR: System Clock Division Control Register
func (o *SYSC_Type) SetSCKDIVCR_PCKD(value uint32) {
	volatile.StoreUint32(&o.SCKDIVCR.Reg, volatile.LoadUint32(&o.SCKDIVCR.Reg)&^(0x7)|value)
}
func (o *SYSC_Type) GetSCKDIVCR_PCKD() uint32 {
	return volatile.LoadUint32(&o.SCKDIVCR.Reg) & 0x7
}
func (o *SYSC_Type) SetSCKDIVCR_PCKB(value uint32) {
	volatile.StoreUint32(&o.SCKDIVCR.Reg, volatile.LoadUint32(&o.SCKDIVCR.Reg)&^(0x700)|value<<8)
}
func (o *SYSC_Type) GetSCKDIVCR_PCKB() uint32 {
	return (volatile.LoadUint32(&o.SCKDIVCR.Reg) & 0x700) >> 8
}
func (o *SYSC_Type) SetSCKDIVCR_ICK(value uint32) {
	volatile.StoreUint32(&o.SCKDIVCR.Reg, volatile.LoadUint32(&o.SCKDIVCR.Reg)&^(0x7000000)|value<<24)
}
func (o *SYSC_Type) GetSCKDIVCR_ICK() uint32 {
	return (volatile.LoadUint32(&o.SCKDIVCR.Reg) & 0x7000000) >> 24
}

// SYSC.SCKSCR: System Clock Source Control Register
func (o *SYSC_Type) SetSCKSCR_CKSEL(value uint8) {
	volatile.StoreUint8(&o.SCKSCR.Reg, volatile.LoadUint8(&o.SCKSCR.Reg)&^(0x7)|value)
}
func (o *SYSC_Type) GetSCKSCR_CKSEL() uint8 {
	return volatile.LoadUint8(&o.SCKSCR.Reg) & 0x7
}

// SYSC.MEMWAIT: Memory Wait Cycle Control Register for Code Flash
func (o *SYSC_Type) SetMEMWAIT(value uint8) {
	volatile.StoreUint8(&o.MEMWAIT.Reg, volatile.LoadUint8(&o.MEMWAIT.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetMEMWAIT() uint8 {
	return volatile.LoadUint8(&o.MEMWAIT.Reg) & 0x1
}

// SYSC.HOCOCR: High-Speed On-Chip Oscillator Control Register
func (o *SYSC_Type) SetHOCOCR_HCSTP(value uint8) {
	volatile.StoreUint8(&o.HOCOCR.Reg, volatile.LoadUint8(&o.HOCOCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetHOCOCR_HCSTP() uint8 {
	return volatile.LoadUint8(&o.HOCOCR.Reg) & 0x1
}

// SYSC.MOCOCR: Middle-Speed On-Chip Oscillator Control Register
func (o *SYSC_Type) SetMOCOCR_MCSTP(value uint8) {
	volatile.StoreUint8(&o.MOCOCR.Reg, volatile.LoadUint8(&o.MOCOCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetMOCOCR_MCSTP() uint8 {
	return volatile.LoadUint8(&o.MOCOCR.Reg) & 0x1
}

// SYSC.OSCSF: Oscillation Stabilization Flag Register
func (o *SYSC_Type) SetOSCSF_HOCOSF(value uint8) {
	volatile.StoreUint8(&o.OSCSF.Reg, volatile.LoadUint8(&o.OSCSF.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetOSCSF_HOCOSF() uint8 {
	return volatile.LoadUint8(&o.OSCSF.Reg) & 0x1
}

// SYSC.CKOCR: Clock Out Control Register
func (o *SYSC_Type) SetCKOCR_CKOSEL(value uint8) {
	volatile.StoreUint8(&o.CKOCR.Reg, volatile.LoadUint8(&o.CKOCR.Reg)&^(0x7)|value)
}
func (o *SYSC_Type) GetCKOCR_CKOSEL() uint8 {
	return volatile.LoadUint8(&o.CKOCR.Reg) & 0x7
}
func (o *SYSC_Type) SetCKOCR_CKODIV(value uint8) {
	volatile.StoreUint8(&o.CKOCR.Reg, volatile.LoadUint8(&o.CKOCR.Reg)&^(0x70)|value<<4)
}
func (o *SYSC_Type) GetCKOCR_CKODIV() uint8 {
	return (volatile.LoadUint8(&o.CKOCR.Reg) & 0x70) >> 4
}
func (o *SYSC_Type) SetCKOCR_CKOEN(value uint8) {
	volatile.StoreUint8(&o.CKOCR.Reg, volatile.LoadUint8(&o.CKOCR.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetCKOCR_CKOEN() uint8 {
	return (volatile.LoadUint8(&o.CKOCR.Reg) & 0x80) >> 7
}

// SYSC.LPOPT: Lower Power Operation Control Register
func (o *SYSC_Type) SetLPOPT_MPUDIS(value uint8) {
	volatile.StoreUint8(&o.LPOPT.Reg, volatile.LoadUint8(&o.LPOPT.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetLPOPT_MPUDIS() uint8 {
	return volatile.LoadUint8(&o.LPOPT.Reg) & 0x1
}
func (o *SYSC_Type) SetLPOPT_DCLKDIS(value uint8) {
	volatile.StoreUint8(&o.LPOPT.Reg, volatile.LoadUint8(&o.LPOPT.Reg)&^(0x6)|value<<1)
}
func (o *SYSC_Type) GetLPOPT_DCLKDIS() uint8 {
	return (volatile.LoadUint8(&o.LPOPT.Reg) & 0x6) >> 1
}
func (o *SYSC_Type) SetLPOPT_BPFCLKDIS(value uint8) {
	volatile.StoreUint8(&o.LPOPT.Reg, volatile.LoadUint8(&o.LPOPT.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetLPOPT_BPFCLKDIS() uint8 {
	return (volatile.LoadUint8(&o.LPOPT.Reg) & 0x8) >> 3
}
func (o *SYSC_Type) SetLPOPT_LPOPTEN(value uint8) {
	volatile.StoreUint8(&o.LPOPT.Reg, volatile.LoadUint8(&o.LPOPT.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetLPOPT_LPOPTEN() uint8 {
	return (volatile.LoadUint8(&o.LPOPT.Reg) & 0x80) >> 7
}

// SYSC.MOCOUTCR: MOCO User Trimming Control Register
func (o *SYSC_Type) SetMOCOUTCR(value uint8) {
	volatile.StoreUint8(&o.MOCOUTCR.Reg, value)
}
func (o *SYSC_Type) GetMOCOUTCR() uint8 {
	return volatile.LoadUint8(&o.MOCOUTCR.Reg)
}

// SYSC.HOCOUTCR: HOCO User Trimming Control Register
func (o *SYSC_Type) SetHOCOUTCR(value uint8) {
	volatile.StoreUint8(&o.HOCOUTCR.Reg, value)
}
func (o *SYSC_Type) GetHOCOUTCR() uint8 {
	return volatile.LoadUint8(&o.HOCOUTCR.Reg)
}

// SYSC.SNZCR: Snooze Control Register
func (o *SYSC_Type) SetSNZCR_SNZDTCEN(value uint8) {
	volatile.StoreUint8(&o.SNZCR.Reg, volatile.LoadUint8(&o.SNZCR.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetSNZCR_SNZDTCEN() uint8 {
	return (volatile.LoadUint8(&o.SNZCR.Reg) & 0x2) >> 1
}
func (o *SYSC_Type) SetSNZCR_SNZE(value uint8) {
	volatile.StoreUint8(&o.SNZCR.Reg, volatile.LoadUint8(&o.SNZCR.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetSNZCR_SNZE() uint8 {
	return (volatile.LoadUint8(&o.SNZCR.Reg) & 0x80) >> 7
}

// SYSC.SNZEDCR0: Snooze End Control Register 0
func (o *SYSC_Type) SetSNZEDCR0_AGTUNFED(value uint8) {
	volatile.StoreUint8(&o.SNZEDCR0.Reg, volatile.LoadUint8(&o.SNZEDCR0.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetSNZEDCR0_AGTUNFED() uint8 {
	return volatile.LoadUint8(&o.SNZEDCR0.Reg) & 0x1
}
func (o *SYSC_Type) SetSNZEDCR0_DTCZRED(value uint8) {
	volatile.StoreUint8(&o.SNZEDCR0.Reg, volatile.LoadUint8(&o.SNZEDCR0.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetSNZEDCR0_DTCZRED() uint8 {
	return (volatile.LoadUint8(&o.SNZEDCR0.Reg) & 0x2) >> 1
}
func (o *SYSC_Type) SetSNZEDCR0_DTCNZRED(value uint8) {
	volatile.StoreUint8(&o.SNZEDCR0.Reg, volatile.LoadUint8(&o.SNZEDCR0.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetSNZEDCR0_DTCNZRED() uint8 {
	return (volatile.LoadUint8(&o.SNZEDCR0.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetSNZEDCR0_AD0MATED(value uint8) {
	volatile.StoreUint8(&o.SNZEDCR0.Reg, volatile.LoadUint8(&o.SNZEDCR0.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetSNZEDCR0_AD0MATED() uint8 {
	return (volatile.LoadUint8(&o.SNZEDCR0.Reg) & 0x8) >> 3
}
func (o *SYSC_Type) SetSNZEDCR0_AD0UMTED(value uint8) {
	volatile.StoreUint8(&o.SNZEDCR0.Reg, volatile.LoadUint8(&o.SNZEDCR0.Reg)&^(0x10)|value<<4)
}
func (o *SYSC_Type) GetSNZEDCR0_AD0UMTED() uint8 {
	return (volatile.LoadUint8(&o.SNZEDCR0.Reg) & 0x10) >> 4
}

// SYSC.SNZREQCR0: Snooze Request Control Register 0
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN0(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN0() uint32 {
	return volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x1
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN1(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN1() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x2) >> 1
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN2(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN2() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN3(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN3() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x8) >> 3
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN4(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x10)|value<<4)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN4() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x10) >> 4
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN5(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x20)|value<<5)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN5() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x20) >> 5
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN6(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x40)|value<<6)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN6() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x40) >> 6
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN7(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN7() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x80) >> 7
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN17(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x20000)|value<<17)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN17() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x20000) >> 17
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN28(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x10000000)|value<<28)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN28() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x10000000) >> 28
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN29(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x20000000)|value<<29)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN29() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x20000000) >> 29
}
func (o *SYSC_Type) SetSNZREQCR0_SNZREQEN30(value uint32) {
	volatile.StoreUint32(&o.SNZREQCR0.Reg, volatile.LoadUint32(&o.SNZREQCR0.Reg)&^(0x40000000)|value<<30)
}
func (o *SYSC_Type) GetSNZREQCR0_SNZREQEN30() uint32 {
	return (volatile.LoadUint32(&o.SNZREQCR0.Reg) & 0x40000000) >> 30
}

// SYSC.PSMCR: Power Save Memory Control Register
func (o *SYSC_Type) SetPSMCR_PSMC(value uint8) {
	volatile.StoreUint8(&o.PSMCR.Reg, volatile.LoadUint8(&o.PSMCR.Reg)&^(0x3)|value)
}
func (o *SYSC_Type) GetPSMCR_PSMC() uint8 {
	return volatile.LoadUint8(&o.PSMCR.Reg) & 0x3
}

// SYSC.OPCCR: Operating Power Control Register
func (o *SYSC_Type) SetOPCCR_OPCM(value uint8) {
	volatile.StoreUint8(&o.OPCCR.Reg, volatile.LoadUint8(&o.OPCCR.Reg)&^(0x3)|value)
}
func (o *SYSC_Type) GetOPCCR_OPCM() uint8 {
	return volatile.LoadUint8(&o.OPCCR.Reg) & 0x3
}
func (o *SYSC_Type) SetOPCCR_OPCMTSF(value uint8) {
	volatile.StoreUint8(&o.OPCCR.Reg, volatile.LoadUint8(&o.OPCCR.Reg)&^(0x10)|value<<4)
}
func (o *SYSC_Type) GetOPCCR_OPCMTSF() uint8 {
	return (volatile.LoadUint8(&o.OPCCR.Reg) & 0x10) >> 4
}

// SYSC.HOCOWTCR: High-Speed On-Chip Oscillator Wait Control Register
func (o *SYSC_Type) SetHOCOWTCR_HSTS(value uint8) {
	volatile.StoreUint8(&o.HOCOWTCR.Reg, volatile.LoadUint8(&o.HOCOWTCR.Reg)&^(0x7)|value)
}
func (o *SYSC_Type) GetHOCOWTCR_HSTS() uint8 {
	return volatile.LoadUint8(&o.HOCOWTCR.Reg) & 0x7
}

// SYSC.SOPCCR: Sub Operating Power Control Register
func (o *SYSC_Type) SetSOPCCR_SOPCM(value uint8) {
	volatile.StoreUint8(&o.SOPCCR.Reg, volatile.LoadUint8(&o.SOPCCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetSOPCCR_SOPCM() uint8 {
	return volatile.LoadUint8(&o.SOPCCR.Reg) & 0x1
}
func (o *SYSC_Type) SetSOPCCR_SOPCMTSF(value uint8) {
	volatile.StoreUint8(&o.SOPCCR.Reg, volatile.LoadUint8(&o.SOPCCR.Reg)&^(0x10)|value<<4)
}
func (o *SYSC_Type) GetSOPCCR_SOPCMTSF() uint8 {
	return (volatile.LoadUint8(&o.SOPCCR.Reg) & 0x10) >> 4
}

// SYSC.RSTSR1: Reset Status Register 1
func (o *SYSC_Type) SetRSTSR1_IWDTRF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetRSTSR1_IWDTRF() uint16 {
	return volatile.LoadUint16(&o.RSTSR1.Reg) & 0x1
}
func (o *SYSC_Type) SetRSTSR1_WDTRF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetRSTSR1_WDTRF() uint16 {
	return (volatile.LoadUint16(&o.RSTSR1.Reg) & 0x2) >> 1
}
func (o *SYSC_Type) SetRSTSR1_SWRF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetRSTSR1_SWRF() uint16 {
	return (volatile.LoadUint16(&o.RSTSR1.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetRSTSR1_RPERF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x100)|value<<8)
}
func (o *SYSC_Type) GetRSTSR1_RPERF() uint16 {
	return (volatile.LoadUint16(&o.RSTSR1.Reg) & 0x100) >> 8
}
func (o *SYSC_Type) SetRSTSR1_BUSSRF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x400)|value<<10)
}
func (o *SYSC_Type) GetRSTSR1_BUSSRF() uint16 {
	return (volatile.LoadUint16(&o.RSTSR1.Reg) & 0x400) >> 10
}
func (o *SYSC_Type) SetRSTSR1_BUSMRF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x800)|value<<11)
}
func (o *SYSC_Type) GetRSTSR1_BUSMRF() uint16 {
	return (volatile.LoadUint16(&o.RSTSR1.Reg) & 0x800) >> 11
}
func (o *SYSC_Type) SetRSTSR1_SPERF(value uint16) {
	volatile.StoreUint16(&o.RSTSR1.Reg, volatile.LoadUint16(&o.RSTSR1.Reg)&^(0x1000)|value<<12)
}
func (o *SYSC_Type) GetRSTSR1_SPERF() uint16 {
	return (volatile.LoadUint16(&o.RSTSR1.Reg) & 0x1000) >> 12
}

// SYSC.LVD1CR1: Voltage Monitor 1 Circuit Control Register
func (o *SYSC_Type) SetLVD1CR1_IDTSEL(value uint8) {
	volatile.StoreUint8(&o.LVD1CR1.Reg, volatile.LoadUint8(&o.LVD1CR1.Reg)&^(0x3)|value)
}
func (o *SYSC_Type) GetLVD1CR1_IDTSEL() uint8 {
	return volatile.LoadUint8(&o.LVD1CR1.Reg) & 0x3
}
func (o *SYSC_Type) SetLVD1CR1_IRQSEL(value uint8) {
	volatile.StoreUint8(&o.LVD1CR1.Reg, volatile.LoadUint8(&o.LVD1CR1.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetLVD1CR1_IRQSEL() uint8 {
	return (volatile.LoadUint8(&o.LVD1CR1.Reg) & 0x4) >> 2
}

// SYSC.LVD1SR: Voltage Monitor 1 Circuit Status Register
func (o *SYSC_Type) SetLVD1SR_DET(value uint8) {
	volatile.StoreUint8(&o.LVD1SR.Reg, volatile.LoadUint8(&o.LVD1SR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetLVD1SR_DET() uint8 {
	return volatile.LoadUint8(&o.LVD1SR.Reg) & 0x1
}
func (o *SYSC_Type) SetLVD1SR_MON(value uint8) {
	volatile.StoreUint8(&o.LVD1SR.Reg, volatile.LoadUint8(&o.LVD1SR.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetLVD1SR_MON() uint8 {
	return (volatile.LoadUint8(&o.LVD1SR.Reg) & 0x2) >> 1
}

// SYSC.LVD2CR1: Voltage Monitor 2 Circuit Control Register 1
func (o *SYSC_Type) SetLVD2CR1_IDTSEL(value uint8) {
	volatile.StoreUint8(&o.LVD2CR1.Reg, volatile.LoadUint8(&o.LVD2CR1.Reg)&^(0x3)|value)
}
func (o *SYSC_Type) GetLVD2CR1_IDTSEL() uint8 {
	return volatile.LoadUint8(&o.LVD2CR1.Reg) & 0x3
}
func (o *SYSC_Type) SetLVD2CR1_IRQSEL(value uint8) {
	volatile.StoreUint8(&o.LVD2CR1.Reg, volatile.LoadUint8(&o.LVD2CR1.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetLVD2CR1_IRQSEL() uint8 {
	return (volatile.LoadUint8(&o.LVD2CR1.Reg) & 0x4) >> 2
}

// SYSC.LVD2SR: Voltage Monitor 2 Circuit Status Register
func (o *SYSC_Type) SetLVD2SR_DET(value uint8) {
	volatile.StoreUint8(&o.LVD2SR.Reg, volatile.LoadUint8(&o.LVD2SR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetLVD2SR_DET() uint8 {
	return volatile.LoadUint8(&o.LVD2SR.Reg) & 0x1
}
func (o *SYSC_Type) SetLVD2SR_MON(value uint8) {
	volatile.StoreUint8(&o.LVD2SR.Reg, volatile.LoadUint8(&o.LVD2SR.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetLVD2SR_MON() uint8 {
	return (volatile.LoadUint8(&o.LVD2SR.Reg) & 0x2) >> 1
}

// SYSC.PRCR: Protect Register
func (o *SYSC_Type) SetPRCR_PRC0(value uint16) {
	volatile.StoreUint16(&o.PRCR.Reg, volatile.LoadUint16(&o.PRCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetPRCR_PRC0() uint16 {
	return volatile.LoadUint16(&o.PRCR.Reg) & 0x1
}
func (o *SYSC_Type) SetPRCR_PRC1(value uint16) {
	volatile.StoreUint16(&o.PRCR.Reg, volatile.LoadUint16(&o.PRCR.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetPRCR_PRC1() uint16 {
	return (volatile.LoadUint16(&o.PRCR.Reg) & 0x2) >> 1
}
func (o *SYSC_Type) SetPRCR_PRC3(value uint16) {
	volatile.StoreUint16(&o.PRCR.Reg, volatile.LoadUint16(&o.PRCR.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetPRCR_PRC3() uint16 {
	return (volatile.LoadUint16(&o.PRCR.Reg) & 0x8) >> 3
}
func (o *SYSC_Type) SetPRCR_PRKEY(value uint16) {
	volatile.StoreUint16(&o.PRCR.Reg, volatile.LoadUint16(&o.PRCR.Reg)&^(0xff00)|value<<8)
}
func (o *SYSC_Type) GetPRCR_PRKEY() uint16 {
	return (volatile.LoadUint16(&o.PRCR.Reg) & 0xff00) >> 8
}

// SYSC.SYOCDCR: System Control OCD Control Register
func (o *SYSC_Type) SetSYOCDCR_DBGEN(value uint8) {
	volatile.StoreUint8(&o.SYOCDCR.Reg, volatile.LoadUint8(&o.SYOCDCR.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetSYOCDCR_DBGEN() uint8 {
	return (volatile.LoadUint8(&o.SYOCDCR.Reg) & 0x80) >> 7
}

// SYSC.RSTSR0: Reset Status Register 0
func (o *SYSC_Type) SetRSTSR0_PORF(value uint8) {
	volatile.StoreUint8(&o.RSTSR0.Reg, volatile.LoadUint8(&o.RSTSR0.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetRSTSR0_PORF() uint8 {
	return volatile.LoadUint8(&o.RSTSR0.Reg) & 0x1
}
func (o *SYSC_Type) SetRSTSR0_LVD0RF(value uint8) {
	volatile.StoreUint8(&o.RSTSR0.Reg, volatile.LoadUint8(&o.RSTSR0.Reg)&^(0x2)|value<<1)
}
func (o *SYSC_Type) GetRSTSR0_LVD0RF() uint8 {
	return (volatile.LoadUint8(&o.RSTSR0.Reg) & 0x2) >> 1
}
func (o *SYSC_Type) SetRSTSR0_LVD1RF(value uint8) {
	volatile.StoreUint8(&o.RSTSR0.Reg, volatile.LoadUint8(&o.RSTSR0.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetRSTSR0_LVD1RF() uint8 {
	return (volatile.LoadUint8(&o.RSTSR0.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetRSTSR0_LVD2RF(value uint8) {
	volatile.StoreUint8(&o.RSTSR0.Reg, volatile.LoadUint8(&o.RSTSR0.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetRSTSR0_LVD2RF() uint8 {
	return (volatile.LoadUint8(&o.RSTSR0.Reg) & 0x8) >> 3
}

// SYSC.RSTSR2: Reset Status Register 2
func (o *SYSC_Type) SetRSTSR2_CWSF(value uint8) {
	volatile.StoreUint8(&o.RSTSR2.Reg, volatile.LoadUint8(&o.RSTSR2.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetRSTSR2_CWSF() uint8 {
	return volatile.LoadUint8(&o.RSTSR2.Reg) & 0x1
}

// SYSC.LVCMPCR: Voltage Monitor Circuit Control Register
func (o *SYSC_Type) SetLVCMPCR_LVD1E(value uint8) {
	volatile.StoreUint8(&o.LVCMPCR.Reg, volatile.LoadUint8(&o.LVCMPCR.Reg)&^(0x20)|value<<5)
}
func (o *SYSC_Type) GetLVCMPCR_LVD1E() uint8 {
	return (volatile.LoadUint8(&o.LVCMPCR.Reg) & 0x20) >> 5
}
func (o *SYSC_Type) SetLVCMPCR_LVD2E(value uint8) {
	volatile.StoreUint8(&o.LVCMPCR.Reg, volatile.LoadUint8(&o.LVCMPCR.Reg)&^(0x40)|value<<6)
}
func (o *SYSC_Type) GetLVCMPCR_LVD2E() uint8 {
	return (volatile.LoadUint8(&o.LVCMPCR.Reg) & 0x40) >> 6
}

// SYSC.LVDLVLR: Voltage Detection Level Select Register
func (o *SYSC_Type) SetLVDLVLR_LVD1LVL(value uint8) {
	volatile.StoreUint8(&o.LVDLVLR.Reg, volatile.LoadUint8(&o.LVDLVLR.Reg)&^(0x1f)|value)
}
func (o *SYSC_Type) GetLVDLVLR_LVD1LVL() uint8 {
	return volatile.LoadUint8(&o.LVDLVLR.Reg) & 0x1f
}
func (o *SYSC_Type) SetLVDLVLR_LVD2LVL(value uint8) {
	volatile.StoreUint8(&o.LVDLVLR.Reg, volatile.LoadUint8(&o.LVDLVLR.Reg)&^(0xe0)|value<<5)
}
func (o *SYSC_Type) GetLVDLVLR_LVD2LVL() uint8 {
	return (volatile.LoadUint8(&o.LVDLVLR.Reg) & 0xe0) >> 5
}

// SYSC.LVD1CR0: Voltage Monitor 1 Circuit Control Register 0
func (o *SYSC_Type) SetLVD1CR0_RIE(value uint8) {
	volatile.StoreUint8(&o.LVD1CR0.Reg, volatile.LoadUint8(&o.LVD1CR0.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetLVD1CR0_RIE() uint8 {
	return volatile.LoadUint8(&o.LVD1CR0.Reg) & 0x1
}
func (o *SYSC_Type) SetLVD1CR0_CMPE(value uint8) {
	volatile.StoreUint8(&o.LVD1CR0.Reg, volatile.LoadUint8(&o.LVD1CR0.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetLVD1CR0_CMPE() uint8 {
	return (volatile.LoadUint8(&o.LVD1CR0.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetLVD1CR0_RI(value uint8) {
	volatile.StoreUint8(&o.LVD1CR0.Reg, volatile.LoadUint8(&o.LVD1CR0.Reg)&^(0x40)|value<<6)
}
func (o *SYSC_Type) GetLVD1CR0_RI() uint8 {
	return (volatile.LoadUint8(&o.LVD1CR0.Reg) & 0x40) >> 6
}
func (o *SYSC_Type) SetLVD1CR0_RN(value uint8) {
	volatile.StoreUint8(&o.LVD1CR0.Reg, volatile.LoadUint8(&o.LVD1CR0.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetLVD1CR0_RN() uint8 {
	return (volatile.LoadUint8(&o.LVD1CR0.Reg) & 0x80) >> 7
}

// SYSC.LVD2CR0: Voltage Monitor 2 Circuit Control Register 0
func (o *SYSC_Type) SetLVD2CR0_RIE(value uint8) {
	volatile.StoreUint8(&o.LVD2CR0.Reg, volatile.LoadUint8(&o.LVD2CR0.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetLVD2CR0_RIE() uint8 {
	return volatile.LoadUint8(&o.LVD2CR0.Reg) & 0x1
}
func (o *SYSC_Type) SetLVD2CR0_CMPE(value uint8) {
	volatile.StoreUint8(&o.LVD2CR0.Reg, volatile.LoadUint8(&o.LVD2CR0.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetLVD2CR0_CMPE() uint8 {
	return (volatile.LoadUint8(&o.LVD2CR0.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetLVD2CR0_RI(value uint8) {
	volatile.StoreUint8(&o.LVD2CR0.Reg, volatile.LoadUint8(&o.LVD2CR0.Reg)&^(0x40)|value<<6)
}
func (o *SYSC_Type) GetLVD2CR0_RI() uint8 {
	return (volatile.LoadUint8(&o.LVD2CR0.Reg) & 0x40) >> 6
}
func (o *SYSC_Type) SetLVD2CR0_RN(value uint8) {
	volatile.StoreUint8(&o.LVD2CR0.Reg, volatile.LoadUint8(&o.LVD2CR0.Reg)&^(0x80)|value<<7)
}
func (o *SYSC_Type) GetLVD2CR0_RN() uint8 {
	return (volatile.LoadUint8(&o.LVD2CR0.Reg) & 0x80) >> 7
}

// SYSC.LOCOCR: Low-Speed On-Chip Oscillator Control Register
func (o *SYSC_Type) SetLOCOCR_LCSTP(value uint8) {
	volatile.StoreUint8(&o.LOCOCR.Reg, volatile.LoadUint8(&o.LOCOCR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetLOCOCR_LCSTP() uint8 {
	return volatile.LoadUint8(&o.LOCOCR.Reg) & 0x1
}

// SYSC.LOCOUTCR: LOCO User Trimming Control Register
func (o *SYSC_Type) SetLOCOUTCR(value uint8) {
	volatile.StoreUint8(&o.LOCOUTCR.Reg, value)
}
func (o *SYSC_Type) GetLOCOUTCR() uint8 {
	return volatile.LoadUint8(&o.LOCOUTCR.Reg)
}

// Port 0 Control Registers
type PORT0_Type struct {
	PCNTR1 volatile.Register32 // 0x0
	PCNTR2 volatile.Register32 // 0x4
	PCNTR3 volatile.Register32 // 0x8
}

// PORT0.PCNTR1: Port Control Register 1
func (o *PORT0_Type) SetPCNTR1_PDR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x1)|value)
}
func (o *PORT0_Type) GetPCNTR1_PDR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR1.Reg) & 0x1
}
func (o *PORT0_Type) SetPCNTR1_PDR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x2)|value<<1)
}
func (o *PORT0_Type) GetPCNTR1_PDR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x2) >> 1
}
func (o *PORT0_Type) SetPCNTR1_PDR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x4)|value<<2)
}
func (o *PORT0_Type) GetPCNTR1_PDR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x4) >> 2
}
func (o *PORT0_Type) SetPCNTR1_PDR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x8)|value<<3)
}
func (o *PORT0_Type) GetPCNTR1_PDR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x8) >> 3
}
func (o *PORT0_Type) SetPCNTR1_PDR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x10)|value<<4)
}
func (o *PORT0_Type) GetPCNTR1_PDR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x10) >> 4
}
func (o *PORT0_Type) SetPCNTR1_PDR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x20)|value<<5)
}
func (o *PORT0_Type) GetPCNTR1_PDR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x20) >> 5
}
func (o *PORT0_Type) SetPCNTR1_PDR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x40)|value<<6)
}
func (o *PORT0_Type) GetPCNTR1_PDR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x40) >> 6
}
func (o *PORT0_Type) SetPCNTR1_PDR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x80)|value<<7)
}
func (o *PORT0_Type) GetPCNTR1_PDR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x80) >> 7
}
func (o *PORT0_Type) SetPCNTR1_PDR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x100)|value<<8)
}
func (o *PORT0_Type) GetPCNTR1_PDR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x100) >> 8
}
func (o *PORT0_Type) SetPCNTR1_PDR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x200)|value<<9)
}
func (o *PORT0_Type) GetPCNTR1_PDR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x200) >> 9
}
func (o *PORT0_Type) SetPCNTR1_PDR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x400)|value<<10)
}
func (o *PORT0_Type) GetPCNTR1_PDR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x400) >> 10
}
func (o *PORT0_Type) SetPCNTR1_PDR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x800)|value<<11)
}
func (o *PORT0_Type) GetPCNTR1_PDR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x800) >> 11
}
func (o *PORT0_Type) SetPCNTR1_PDR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x1000)|value<<12)
}
func (o *PORT0_Type) GetPCNTR1_PDR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x1000) >> 12
}
func (o *PORT0_Type) SetPCNTR1_PDR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x2000)|value<<13)
}
func (o *PORT0_Type) GetPCNTR1_PDR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x2000) >> 13
}
func (o *PORT0_Type) SetPCNTR1_PDR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x4000)|value<<14)
}
func (o *PORT0_Type) GetPCNTR1_PDR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x4000) >> 14
}
func (o *PORT0_Type) SetPCNTR1_PDR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x8000)|value<<15)
}
func (o *PORT0_Type) GetPCNTR1_PDR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x8000) >> 15
}
func (o *PORT0_Type) SetPCNTR1_PODR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x10000)|value<<16)
}
func (o *PORT0_Type) GetPCNTR1_PODR00() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x10000) >> 16
}
func (o *PORT0_Type) SetPCNTR1_PODR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x20000)|value<<17)
}
func (o *PORT0_Type) GetPCNTR1_PODR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x20000) >> 17
}
func (o *PORT0_Type) SetPCNTR1_PODR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x40000)|value<<18)
}
func (o *PORT0_Type) GetPCNTR1_PODR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x40000) >> 18
}
func (o *PORT0_Type) SetPCNTR1_PODR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x80000)|value<<19)
}
func (o *PORT0_Type) GetPCNTR1_PODR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x80000) >> 19
}
func (o *PORT0_Type) SetPCNTR1_PODR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x100000)|value<<20)
}
func (o *PORT0_Type) GetPCNTR1_PODR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x100000) >> 20
}
func (o *PORT0_Type) SetPCNTR1_PODR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x200000)|value<<21)
}
func (o *PORT0_Type) GetPCNTR1_PODR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x200000) >> 21
}
func (o *PORT0_Type) SetPCNTR1_PODR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x400000)|value<<22)
}
func (o *PORT0_Type) GetPCNTR1_PODR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x400000) >> 22
}
func (o *PORT0_Type) SetPCNTR1_PODR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x800000)|value<<23)
}
func (o *PORT0_Type) GetPCNTR1_PODR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x800000) >> 23
}
func (o *PORT0_Type) SetPCNTR1_PODR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT0_Type) GetPCNTR1_PODR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x1000000) >> 24
}
func (o *PORT0_Type) SetPCNTR1_PODR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PORT0_Type) GetPCNTR1_PODR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x2000000) >> 25
}
func (o *PORT0_Type) SetPCNTR1_PODR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PORT0_Type) GetPCNTR1_PODR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x4000000) >> 26
}
func (o *PORT0_Type) SetPCNTR1_PODR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PORT0_Type) GetPCNTR1_PODR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x8000000) >> 27
}
func (o *PORT0_Type) SetPCNTR1_PODR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT0_Type) GetPCNTR1_PODR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x10000000) >> 28
}
func (o *PORT0_Type) SetPCNTR1_PODR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x20000000)|value<<29)
}
func (o *PORT0_Type) GetPCNTR1_PODR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x20000000) >> 29
}
func (o *PORT0_Type) SetPCNTR1_PODR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT0_Type) GetPCNTR1_PODR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x40000000) >> 30
}
func (o *PORT0_Type) SetPCNTR1_PODR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT0_Type) GetPCNTR1_PODR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x80000000) >> 31
}

// PORT0.PCNTR2: Port Control Register 2
func (o *PORT0_Type) SetPCNTR2_PIDR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x1)|value)
}
func (o *PORT0_Type) GetPCNTR2_PIDR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR2.Reg) & 0x1
}
func (o *PORT0_Type) SetPCNTR2_PIDR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x2)|value<<1)
}
func (o *PORT0_Type) GetPCNTR2_PIDR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x2) >> 1
}
func (o *PORT0_Type) SetPCNTR2_PIDR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x4)|value<<2)
}
func (o *PORT0_Type) GetPCNTR2_PIDR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x4) >> 2
}
func (o *PORT0_Type) SetPCNTR2_PIDR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x8)|value<<3)
}
func (o *PORT0_Type) GetPCNTR2_PIDR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x8) >> 3
}
func (o *PORT0_Type) SetPCNTR2_PIDR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x10)|value<<4)
}
func (o *PORT0_Type) GetPCNTR2_PIDR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x10) >> 4
}
func (o *PORT0_Type) SetPCNTR2_PIDR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x20)|value<<5)
}
func (o *PORT0_Type) GetPCNTR2_PIDR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x20) >> 5
}
func (o *PORT0_Type) SetPCNTR2_PIDR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x40)|value<<6)
}
func (o *PORT0_Type) GetPCNTR2_PIDR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x40) >> 6
}
func (o *PORT0_Type) SetPCNTR2_PIDR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x80)|value<<7)
}
func (o *PORT0_Type) GetPCNTR2_PIDR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x80) >> 7
}
func (o *PORT0_Type) SetPCNTR2_PIDR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x100)|value<<8)
}
func (o *PORT0_Type) GetPCNTR2_PIDR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x100) >> 8
}
func (o *PORT0_Type) SetPCNTR2_PIDR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x200)|value<<9)
}
func (o *PORT0_Type) GetPCNTR2_PIDR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x200) >> 9
}
func (o *PORT0_Type) SetPCNTR2_PIDR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x400)|value<<10)
}
func (o *PORT0_Type) GetPCNTR2_PIDR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x400) >> 10
}
func (o *PORT0_Type) SetPCNTR2_PIDR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x800)|value<<11)
}
func (o *PORT0_Type) GetPCNTR2_PIDR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x800) >> 11
}
func (o *PORT0_Type) SetPCNTR2_PIDR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x1000)|value<<12)
}
func (o *PORT0_Type) GetPCNTR2_PIDR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x1000) >> 12
}
func (o *PORT0_Type) SetPCNTR2_PIDR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x2000)|value<<13)
}
func (o *PORT0_Type) GetPCNTR2_PIDR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x2000) >> 13
}
func (o *PORT0_Type) SetPCNTR2_PIDR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x4000)|value<<14)
}
func (o *PORT0_Type) GetPCNTR2_PIDR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x4000) >> 14
}
func (o *PORT0_Type) SetPCNTR2_PIDR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x8000)|value<<15)
}
func (o *PORT0_Type) GetPCNTR2_PIDR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x8000) >> 15
}

// PORT0.PCNTR3: Port Control Register 3
func (o *PORT0_Type) SetPCNTR3_POSR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x1)|value)
}
func (o *PORT0_Type) GetPCNTR3_POSR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR3.Reg) & 0x1
}
func (o *PORT0_Type) SetPCNTR3_POSR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x2)|value<<1)
}
func (o *PORT0_Type) GetPCNTR3_POSR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x2) >> 1
}
func (o *PORT0_Type) SetPCNTR3_POSR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x4)|value<<2)
}
func (o *PORT0_Type) GetPCNTR3_POSR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x4) >> 2
}
func (o *PORT0_Type) SetPCNTR3_POSR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x8)|value<<3)
}
func (o *PORT0_Type) GetPCNTR3_POSR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x8) >> 3
}
func (o *PORT0_Type) SetPCNTR3_POSR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x10)|value<<4)
}
func (o *PORT0_Type) GetPCNTR3_POSR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x10) >> 4
}
func (o *PORT0_Type) SetPCNTR3_POSR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x20)|value<<5)
}
func (o *PORT0_Type) GetPCNTR3_POSR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x20) >> 5
}
func (o *PORT0_Type) SetPCNTR3_POSR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x40)|value<<6)
}
func (o *PORT0_Type) GetPCNTR3_POSR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x40) >> 6
}
func (o *PORT0_Type) SetPCNTR3_POSR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x80)|value<<7)
}
func (o *PORT0_Type) GetPCNTR3_POSR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x80) >> 7
}
func (o *PORT0_Type) SetPCNTR3_POSR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x100)|value<<8)
}
func (o *PORT0_Type) GetPCNTR3_POSR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x100) >> 8
}
func (o *PORT0_Type) SetPCNTR3_POSR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x200)|value<<9)
}
func (o *PORT0_Type) GetPCNTR3_POSR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x200) >> 9
}
func (o *PORT0_Type) SetPCNTR3_POSR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x400)|value<<10)
}
func (o *PORT0_Type) GetPCNTR3_POSR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x400) >> 10
}
func (o *PORT0_Type) SetPCNTR3_POSR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x800)|value<<11)
}
func (o *PORT0_Type) GetPCNTR3_POSR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x800) >> 11
}
func (o *PORT0_Type) SetPCNTR3_POSR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x1000)|value<<12)
}
func (o *PORT0_Type) GetPCNTR3_POSR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x1000) >> 12
}
func (o *PORT0_Type) SetPCNTR3_POSR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x2000)|value<<13)
}
func (o *PORT0_Type) GetPCNTR3_POSR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x2000) >> 13
}
func (o *PORT0_Type) SetPCNTR3_POSR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x4000)|value<<14)
}
func (o *PORT0_Type) GetPCNTR3_POSR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x4000) >> 14
}
func (o *PORT0_Type) SetPCNTR3_POSR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x8000)|value<<15)
}
func (o *PORT0_Type) GetPCNTR3_POSR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x8000) >> 15
}
func (o *PORT0_Type) SetPCNTR3_PORR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x10000)|value<<16)
}
func (o *PORT0_Type) GetPCNTR3_PORR00() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x10000) >> 16
}
func (o *PORT0_Type) SetPCNTR3_PORR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x20000)|value<<17)
}
func (o *PORT0_Type) GetPCNTR3_PORR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x20000) >> 17
}
func (o *PORT0_Type) SetPCNTR3_PORR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x40000)|value<<18)
}
func (o *PORT0_Type) GetPCNTR3_PORR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x40000) >> 18
}
func (o *PORT0_Type) SetPCNTR3_PORR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x80000)|value<<19)
}
func (o *PORT0_Type) GetPCNTR3_PORR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x80000) >> 19
}
func (o *PORT0_Type) SetPCNTR3_PORR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x100000)|value<<20)
}
func (o *PORT0_Type) GetPCNTR3_PORR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x100000) >> 20
}
func (o *PORT0_Type) SetPCNTR3_PORR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x200000)|value<<21)
}
func (o *PORT0_Type) GetPCNTR3_PORR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x200000) >> 21
}
func (o *PORT0_Type) SetPCNTR3_PORR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x400000)|value<<22)
}
func (o *PORT0_Type) GetPCNTR3_PORR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x400000) >> 22
}
func (o *PORT0_Type) SetPCNTR3_PORR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x800000)|value<<23)
}
func (o *PORT0_Type) GetPCNTR3_PORR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x800000) >> 23
}
func (o *PORT0_Type) SetPCNTR3_PORR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT0_Type) GetPCNTR3_PORR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x1000000) >> 24
}
func (o *PORT0_Type) SetPCNTR3_PORR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x2000000)|value<<25)
}
func (o *PORT0_Type) GetPCNTR3_PORR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x2000000) >> 25
}
func (o *PORT0_Type) SetPCNTR3_PORR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x4000000)|value<<26)
}
func (o *PORT0_Type) GetPCNTR3_PORR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x4000000) >> 26
}
func (o *PORT0_Type) SetPCNTR3_PORR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x8000000)|value<<27)
}
func (o *PORT0_Type) GetPCNTR3_PORR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x8000000) >> 27
}
func (o *PORT0_Type) SetPCNTR3_PORR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT0_Type) GetPCNTR3_PORR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x10000000) >> 28
}
func (o *PORT0_Type) SetPCNTR3_PORR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x20000000)|value<<29)
}
func (o *PORT0_Type) GetPCNTR3_PORR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x20000000) >> 29
}
func (o *PORT0_Type) SetPCNTR3_PORR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT0_Type) GetPCNTR3_PORR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x40000000) >> 30
}
func (o *PORT0_Type) SetPCNTR3_PORR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT0_Type) GetPCNTR3_PORR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x80000000) >> 31
}

// Port 1 Control Registers
type PORT1_Type struct {
	PCNTR1 volatile.Register32 // 0x0
	PCNTR2 volatile.Register32 // 0x4
	PCNTR3 volatile.Register32 // 0x8
	PCNTR4 volatile.Register32 // 0xC
}

// PORT1.PCNTR1: Port Control Register 1
func (o *PORT1_Type) SetPCNTR1_PDR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x1)|value)
}
func (o *PORT1_Type) GetPCNTR1_PDR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR1.Reg) & 0x1
}
func (o *PORT1_Type) SetPCNTR1_PDR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x2)|value<<1)
}
func (o *PORT1_Type) GetPCNTR1_PDR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x2) >> 1
}
func (o *PORT1_Type) SetPCNTR1_PDR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x4)|value<<2)
}
func (o *PORT1_Type) GetPCNTR1_PDR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x4) >> 2
}
func (o *PORT1_Type) SetPCNTR1_PDR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x8)|value<<3)
}
func (o *PORT1_Type) GetPCNTR1_PDR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x8) >> 3
}
func (o *PORT1_Type) SetPCNTR1_PDR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x10)|value<<4)
}
func (o *PORT1_Type) GetPCNTR1_PDR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x10) >> 4
}
func (o *PORT1_Type) SetPCNTR1_PDR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x20)|value<<5)
}
func (o *PORT1_Type) GetPCNTR1_PDR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x20) >> 5
}
func (o *PORT1_Type) SetPCNTR1_PDR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x40)|value<<6)
}
func (o *PORT1_Type) GetPCNTR1_PDR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x40) >> 6
}
func (o *PORT1_Type) SetPCNTR1_PDR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x80)|value<<7)
}
func (o *PORT1_Type) GetPCNTR1_PDR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x80) >> 7
}
func (o *PORT1_Type) SetPCNTR1_PDR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x100)|value<<8)
}
func (o *PORT1_Type) GetPCNTR1_PDR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x100) >> 8
}
func (o *PORT1_Type) SetPCNTR1_PDR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x200)|value<<9)
}
func (o *PORT1_Type) GetPCNTR1_PDR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x200) >> 9
}
func (o *PORT1_Type) SetPCNTR1_PDR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x400)|value<<10)
}
func (o *PORT1_Type) GetPCNTR1_PDR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x400) >> 10
}
func (o *PORT1_Type) SetPCNTR1_PDR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x800)|value<<11)
}
func (o *PORT1_Type) GetPCNTR1_PDR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x800) >> 11
}
func (o *PORT1_Type) SetPCNTR1_PDR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x1000)|value<<12)
}
func (o *PORT1_Type) GetPCNTR1_PDR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x1000) >> 12
}
func (o *PORT1_Type) SetPCNTR1_PDR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x2000)|value<<13)
}
func (o *PORT1_Type) GetPCNTR1_PDR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x2000) >> 13
}
func (o *PORT1_Type) SetPCNTR1_PDR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x4000)|value<<14)
}
func (o *PORT1_Type) GetPCNTR1_PDR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x4000) >> 14
}
func (o *PORT1_Type) SetPCNTR1_PDR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x8000)|value<<15)
}
func (o *PORT1_Type) GetPCNTR1_PDR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x8000) >> 15
}
func (o *PORT1_Type) SetPCNTR1_PODR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x10000)|value<<16)
}
func (o *PORT1_Type) GetPCNTR1_PODR00() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x10000) >> 16
}
func (o *PORT1_Type) SetPCNTR1_PODR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x20000)|value<<17)
}
func (o *PORT1_Type) GetPCNTR1_PODR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x20000) >> 17
}
func (o *PORT1_Type) SetPCNTR1_PODR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x40000)|value<<18)
}
func (o *PORT1_Type) GetPCNTR1_PODR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x40000) >> 18
}
func (o *PORT1_Type) SetPCNTR1_PODR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x80000)|value<<19)
}
func (o *PORT1_Type) GetPCNTR1_PODR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x80000) >> 19
}
func (o *PORT1_Type) SetPCNTR1_PODR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x100000)|value<<20)
}
func (o *PORT1_Type) GetPCNTR1_PODR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x100000) >> 20
}
func (o *PORT1_Type) SetPCNTR1_PODR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x200000)|value<<21)
}
func (o *PORT1_Type) GetPCNTR1_PODR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x200000) >> 21
}
func (o *PORT1_Type) SetPCNTR1_PODR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x400000)|value<<22)
}
func (o *PORT1_Type) GetPCNTR1_PODR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x400000) >> 22
}
func (o *PORT1_Type) SetPCNTR1_PODR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x800000)|value<<23)
}
func (o *PORT1_Type) GetPCNTR1_PODR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x800000) >> 23
}
func (o *PORT1_Type) SetPCNTR1_PODR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT1_Type) GetPCNTR1_PODR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x1000000) >> 24
}
func (o *PORT1_Type) SetPCNTR1_PODR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x2000000)|value<<25)
}
func (o *PORT1_Type) GetPCNTR1_PODR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x2000000) >> 25
}
func (o *PORT1_Type) SetPCNTR1_PODR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x4000000)|value<<26)
}
func (o *PORT1_Type) GetPCNTR1_PODR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x4000000) >> 26
}
func (o *PORT1_Type) SetPCNTR1_PODR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x8000000)|value<<27)
}
func (o *PORT1_Type) GetPCNTR1_PODR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x8000000) >> 27
}
func (o *PORT1_Type) SetPCNTR1_PODR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT1_Type) GetPCNTR1_PODR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x10000000) >> 28
}
func (o *PORT1_Type) SetPCNTR1_PODR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x20000000)|value<<29)
}
func (o *PORT1_Type) GetPCNTR1_PODR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x20000000) >> 29
}
func (o *PORT1_Type) SetPCNTR1_PODR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT1_Type) GetPCNTR1_PODR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x40000000) >> 30
}
func (o *PORT1_Type) SetPCNTR1_PODR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR1.Reg, volatile.LoadUint32(&o.PCNTR1.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT1_Type) GetPCNTR1_PODR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR1.Reg) & 0x80000000) >> 31
}

// PORT1.PCNTR2: Port Control Register 2
func (o *PORT1_Type) SetPCNTR2_PIDR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x1)|value)
}
func (o *PORT1_Type) GetPCNTR2_PIDR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR2.Reg) & 0x1
}
func (o *PORT1_Type) SetPCNTR2_PIDR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x2)|value<<1)
}
func (o *PORT1_Type) GetPCNTR2_PIDR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x2) >> 1
}
func (o *PORT1_Type) SetPCNTR2_PIDR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x4)|value<<2)
}
func (o *PORT1_Type) GetPCNTR2_PIDR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x4) >> 2
}
func (o *PORT1_Type) SetPCNTR2_PIDR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x8)|value<<3)
}
func (o *PORT1_Type) GetPCNTR2_PIDR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x8) >> 3
}
func (o *PORT1_Type) SetPCNTR2_PIDR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x10)|value<<4)
}
func (o *PORT1_Type) GetPCNTR2_PIDR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x10) >> 4
}
func (o *PORT1_Type) SetPCNTR2_PIDR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x20)|value<<5)
}
func (o *PORT1_Type) GetPCNTR2_PIDR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x20) >> 5
}
func (o *PORT1_Type) SetPCNTR2_PIDR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x40)|value<<6)
}
func (o *PORT1_Type) GetPCNTR2_PIDR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x40) >> 6
}
func (o *PORT1_Type) SetPCNTR2_PIDR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x80)|value<<7)
}
func (o *PORT1_Type) GetPCNTR2_PIDR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x80) >> 7
}
func (o *PORT1_Type) SetPCNTR2_PIDR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x100)|value<<8)
}
func (o *PORT1_Type) GetPCNTR2_PIDR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x100) >> 8
}
func (o *PORT1_Type) SetPCNTR2_PIDR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x200)|value<<9)
}
func (o *PORT1_Type) GetPCNTR2_PIDR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x200) >> 9
}
func (o *PORT1_Type) SetPCNTR2_PIDR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x400)|value<<10)
}
func (o *PORT1_Type) GetPCNTR2_PIDR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x400) >> 10
}
func (o *PORT1_Type) SetPCNTR2_PIDR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x800)|value<<11)
}
func (o *PORT1_Type) GetPCNTR2_PIDR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x800) >> 11
}
func (o *PORT1_Type) SetPCNTR2_PIDR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x1000)|value<<12)
}
func (o *PORT1_Type) GetPCNTR2_PIDR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x1000) >> 12
}
func (o *PORT1_Type) SetPCNTR2_PIDR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x2000)|value<<13)
}
func (o *PORT1_Type) GetPCNTR2_PIDR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x2000) >> 13
}
func (o *PORT1_Type) SetPCNTR2_PIDR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x4000)|value<<14)
}
func (o *PORT1_Type) GetPCNTR2_PIDR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x4000) >> 14
}
func (o *PORT1_Type) SetPCNTR2_PIDR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x8000)|value<<15)
}
func (o *PORT1_Type) GetPCNTR2_PIDR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x8000) >> 15
}
func (o *PORT1_Type) SetPCNTR2_EIDR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x10000)|value<<16)
}
func (o *PORT1_Type) GetPCNTR2_EIDR00() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x10000) >> 16
}
func (o *PORT1_Type) SetPCNTR2_EIDR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x20000)|value<<17)
}
func (o *PORT1_Type) GetPCNTR2_EIDR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x20000) >> 17
}
func (o *PORT1_Type) SetPCNTR2_EIDR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x40000)|value<<18)
}
func (o *PORT1_Type) GetPCNTR2_EIDR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x40000) >> 18
}
func (o *PORT1_Type) SetPCNTR2_EIDR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x80000)|value<<19)
}
func (o *PORT1_Type) GetPCNTR2_EIDR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x80000) >> 19
}
func (o *PORT1_Type) SetPCNTR2_EIDR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x100000)|value<<20)
}
func (o *PORT1_Type) GetPCNTR2_EIDR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x100000) >> 20
}
func (o *PORT1_Type) SetPCNTR2_EIDR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x200000)|value<<21)
}
func (o *PORT1_Type) GetPCNTR2_EIDR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x200000) >> 21
}
func (o *PORT1_Type) SetPCNTR2_EIDR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x400000)|value<<22)
}
func (o *PORT1_Type) GetPCNTR2_EIDR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x400000) >> 22
}
func (o *PORT1_Type) SetPCNTR2_EIDR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x800000)|value<<23)
}
func (o *PORT1_Type) GetPCNTR2_EIDR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x800000) >> 23
}
func (o *PORT1_Type) SetPCNTR2_EIDR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT1_Type) GetPCNTR2_EIDR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x1000000) >> 24
}
func (o *PORT1_Type) SetPCNTR2_EIDR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x2000000)|value<<25)
}
func (o *PORT1_Type) GetPCNTR2_EIDR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x2000000) >> 25
}
func (o *PORT1_Type) SetPCNTR2_EIDR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x4000000)|value<<26)
}
func (o *PORT1_Type) GetPCNTR2_EIDR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x4000000) >> 26
}
func (o *PORT1_Type) SetPCNTR2_EIDR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x8000000)|value<<27)
}
func (o *PORT1_Type) GetPCNTR2_EIDR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x8000000) >> 27
}
func (o *PORT1_Type) SetPCNTR2_EIDR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT1_Type) GetPCNTR2_EIDR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x10000000) >> 28
}
func (o *PORT1_Type) SetPCNTR2_EIDR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x20000000)|value<<29)
}
func (o *PORT1_Type) GetPCNTR2_EIDR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x20000000) >> 29
}
func (o *PORT1_Type) SetPCNTR2_EIDR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT1_Type) GetPCNTR2_EIDR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x40000000) >> 30
}
func (o *PORT1_Type) SetPCNTR2_EIDR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR2.Reg, volatile.LoadUint32(&o.PCNTR2.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT1_Type) GetPCNTR2_EIDR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR2.Reg) & 0x80000000) >> 31
}

// PORT1.PCNTR3: Port Control Register 3
func (o *PORT1_Type) SetPCNTR3_POSR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x1)|value)
}
func (o *PORT1_Type) GetPCNTR3_POSR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR3.Reg) & 0x1
}
func (o *PORT1_Type) SetPCNTR3_POSR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x2)|value<<1)
}
func (o *PORT1_Type) GetPCNTR3_POSR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x2) >> 1
}
func (o *PORT1_Type) SetPCNTR3_POSR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x4)|value<<2)
}
func (o *PORT1_Type) GetPCNTR3_POSR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x4) >> 2
}
func (o *PORT1_Type) SetPCNTR3_POSR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x8)|value<<3)
}
func (o *PORT1_Type) GetPCNTR3_POSR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x8) >> 3
}
func (o *PORT1_Type) SetPCNTR3_POSR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x10)|value<<4)
}
func (o *PORT1_Type) GetPCNTR3_POSR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x10) >> 4
}
func (o *PORT1_Type) SetPCNTR3_POSR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x20)|value<<5)
}
func (o *PORT1_Type) GetPCNTR3_POSR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x20) >> 5
}
func (o *PORT1_Type) SetPCNTR3_POSR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x40)|value<<6)
}
func (o *PORT1_Type) GetPCNTR3_POSR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x40) >> 6
}
func (o *PORT1_Type) SetPCNTR3_POSR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x80)|value<<7)
}
func (o *PORT1_Type) GetPCNTR3_POSR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x80) >> 7
}
func (o *PORT1_Type) SetPCNTR3_POSR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x100)|value<<8)
}
func (o *PORT1_Type) GetPCNTR3_POSR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x100) >> 8
}
func (o *PORT1_Type) SetPCNTR3_POSR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x200)|value<<9)
}
func (o *PORT1_Type) GetPCNTR3_POSR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x200) >> 9
}
func (o *PORT1_Type) SetPCNTR3_POSR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x400)|value<<10)
}
func (o *PORT1_Type) GetPCNTR3_POSR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x400) >> 10
}
func (o *PORT1_Type) SetPCNTR3_POSR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x800)|value<<11)
}
func (o *PORT1_Type) GetPCNTR3_POSR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x800) >> 11
}
func (o *PORT1_Type) SetPCNTR3_POSR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x1000)|value<<12)
}
func (o *PORT1_Type) GetPCNTR3_POSR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x1000) >> 12
}
func (o *PORT1_Type) SetPCNTR3_POSR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x2000)|value<<13)
}
func (o *PORT1_Type) GetPCNTR3_POSR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x2000) >> 13
}
func (o *PORT1_Type) SetPCNTR3_POSR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x4000)|value<<14)
}
func (o *PORT1_Type) GetPCNTR3_POSR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x4000) >> 14
}
func (o *PORT1_Type) SetPCNTR3_POSR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x8000)|value<<15)
}
func (o *PORT1_Type) GetPCNTR3_POSR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x8000) >> 15
}
func (o *PORT1_Type) SetPCNTR3_PORR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x10000)|value<<16)
}
func (o *PORT1_Type) GetPCNTR3_PORR00() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x10000) >> 16
}
func (o *PORT1_Type) SetPCNTR3_PORR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x20000)|value<<17)
}
func (o *PORT1_Type) GetPCNTR3_PORR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x20000) >> 17
}
func (o *PORT1_Type) SetPCNTR3_PORR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x40000)|value<<18)
}
func (o *PORT1_Type) GetPCNTR3_PORR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x40000) >> 18
}
func (o *PORT1_Type) SetPCNTR3_PORR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x80000)|value<<19)
}
func (o *PORT1_Type) GetPCNTR3_PORR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x80000) >> 19
}
func (o *PORT1_Type) SetPCNTR3_PORR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x100000)|value<<20)
}
func (o *PORT1_Type) GetPCNTR3_PORR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x100000) >> 20
}
func (o *PORT1_Type) SetPCNTR3_PORR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x200000)|value<<21)
}
func (o *PORT1_Type) GetPCNTR3_PORR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x200000) >> 21
}
func (o *PORT1_Type) SetPCNTR3_PORR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x400000)|value<<22)
}
func (o *PORT1_Type) GetPCNTR3_PORR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x400000) >> 22
}
func (o *PORT1_Type) SetPCNTR3_PORR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x800000)|value<<23)
}
func (o *PORT1_Type) GetPCNTR3_PORR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x800000) >> 23
}
func (o *PORT1_Type) SetPCNTR3_PORR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT1_Type) GetPCNTR3_PORR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x1000000) >> 24
}
func (o *PORT1_Type) SetPCNTR3_PORR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x2000000)|value<<25)
}
func (o *PORT1_Type) GetPCNTR3_PORR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x2000000) >> 25
}
func (o *PORT1_Type) SetPCNTR3_PORR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x4000000)|value<<26)
}
func (o *PORT1_Type) GetPCNTR3_PORR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x4000000) >> 26
}
func (o *PORT1_Type) SetPCNTR3_PORR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x8000000)|value<<27)
}
func (o *PORT1_Type) GetPCNTR3_PORR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x8000000) >> 27
}
func (o *PORT1_Type) SetPCNTR3_PORR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT1_Type) GetPCNTR3_PORR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x10000000) >> 28
}
func (o *PORT1_Type) SetPCNTR3_PORR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x20000000)|value<<29)
}
func (o *PORT1_Type) GetPCNTR3_PORR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x20000000) >> 29
}
func (o *PORT1_Type) SetPCNTR3_PORR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT1_Type) GetPCNTR3_PORR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x40000000) >> 30
}
func (o *PORT1_Type) SetPCNTR3_PORR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR3.Reg, volatile.LoadUint32(&o.PCNTR3.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT1_Type) GetPCNTR3_PORR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR3.Reg) & 0x80000000) >> 31
}

// PORT1.PCNTR4: Port Control Register 4
func (o *PORT1_Type) SetPCNTR4_EOSR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x1)|value)
}
func (o *PORT1_Type) GetPCNTR4_EOSR00() uint32 {
	return volatile.LoadUint32(&o.PCNTR4.Reg) & 0x1
}
func (o *PORT1_Type) SetPCNTR4_EOSR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x2)|value<<1)
}
func (o *PORT1_Type) GetPCNTR4_EOSR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x2) >> 1
}
func (o *PORT1_Type) SetPCNTR4_EOSR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x4)|value<<2)
}
func (o *PORT1_Type) GetPCNTR4_EOSR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x4) >> 2
}
func (o *PORT1_Type) SetPCNTR4_EOSR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x8)|value<<3)
}
func (o *PORT1_Type) GetPCNTR4_EOSR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x8) >> 3
}
func (o *PORT1_Type) SetPCNTR4_EOSR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x10)|value<<4)
}
func (o *PORT1_Type) GetPCNTR4_EOSR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x10) >> 4
}
func (o *PORT1_Type) SetPCNTR4_EOSR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x20)|value<<5)
}
func (o *PORT1_Type) GetPCNTR4_EOSR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x20) >> 5
}
func (o *PORT1_Type) SetPCNTR4_EOSR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x40)|value<<6)
}
func (o *PORT1_Type) GetPCNTR4_EOSR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x40) >> 6
}
func (o *PORT1_Type) SetPCNTR4_EOSR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x80)|value<<7)
}
func (o *PORT1_Type) GetPCNTR4_EOSR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x80) >> 7
}
func (o *PORT1_Type) SetPCNTR4_EOSR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x100)|value<<8)
}
func (o *PORT1_Type) GetPCNTR4_EOSR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x100) >> 8
}
func (o *PORT1_Type) SetPCNTR4_EOSR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x200)|value<<9)
}
func (o *PORT1_Type) GetPCNTR4_EOSR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x200) >> 9
}
func (o *PORT1_Type) SetPCNTR4_EOSR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x400)|value<<10)
}
func (o *PORT1_Type) GetPCNTR4_EOSR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x400) >> 10
}
func (o *PORT1_Type) SetPCNTR4_EOSR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x800)|value<<11)
}
func (o *PORT1_Type) GetPCNTR4_EOSR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x800) >> 11
}
func (o *PORT1_Type) SetPCNTR4_EOSR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x1000)|value<<12)
}
func (o *PORT1_Type) GetPCNTR4_EOSR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x1000) >> 12
}
func (o *PORT1_Type) SetPCNTR4_EOSR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x2000)|value<<13)
}
func (o *PORT1_Type) GetPCNTR4_EOSR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x2000) >> 13
}
func (o *PORT1_Type) SetPCNTR4_EOSR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x4000)|value<<14)
}
func (o *PORT1_Type) GetPCNTR4_EOSR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x4000) >> 14
}
func (o *PORT1_Type) SetPCNTR4_EOSR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x8000)|value<<15)
}
func (o *PORT1_Type) GetPCNTR4_EOSR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x8000) >> 15
}
func (o *PORT1_Type) SetPCNTR4_EORR00(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x10000)|value<<16)
}
func (o *PORT1_Type) GetPCNTR4_EORR00() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x10000) >> 16
}
func (o *PORT1_Type) SetPCNTR4_EORR01(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x20000)|value<<17)
}
func (o *PORT1_Type) GetPCNTR4_EORR01() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x20000) >> 17
}
func (o *PORT1_Type) SetPCNTR4_EORR02(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x40000)|value<<18)
}
func (o *PORT1_Type) GetPCNTR4_EORR02() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x40000) >> 18
}
func (o *PORT1_Type) SetPCNTR4_EORR03(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x80000)|value<<19)
}
func (o *PORT1_Type) GetPCNTR4_EORR03() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x80000) >> 19
}
func (o *PORT1_Type) SetPCNTR4_EORR04(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x100000)|value<<20)
}
func (o *PORT1_Type) GetPCNTR4_EORR04() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x100000) >> 20
}
func (o *PORT1_Type) SetPCNTR4_EORR05(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x200000)|value<<21)
}
func (o *PORT1_Type) GetPCNTR4_EORR05() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x200000) >> 21
}
func (o *PORT1_Type) SetPCNTR4_EORR06(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x400000)|value<<22)
}
func (o *PORT1_Type) GetPCNTR4_EORR06() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x400000) >> 22
}
func (o *PORT1_Type) SetPCNTR4_EORR07(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x800000)|value<<23)
}
func (o *PORT1_Type) GetPCNTR4_EORR07() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x800000) >> 23
}
func (o *PORT1_Type) SetPCNTR4_EORR08(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x1000000)|value<<24)
}
func (o *PORT1_Type) GetPCNTR4_EORR08() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x1000000) >> 24
}
func (o *PORT1_Type) SetPCNTR4_EORR09(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x2000000)|value<<25)
}
func (o *PORT1_Type) GetPCNTR4_EORR09() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x2000000) >> 25
}
func (o *PORT1_Type) SetPCNTR4_EORR10(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x4000000)|value<<26)
}
func (o *PORT1_Type) GetPCNTR4_EORR10() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x4000000) >> 26
}
func (o *PORT1_Type) SetPCNTR4_EORR11(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x8000000)|value<<27)
}
func (o *PORT1_Type) GetPCNTR4_EORR11() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x8000000) >> 27
}
func (o *PORT1_Type) SetPCNTR4_EORR12(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT1_Type) GetPCNTR4_EORR12() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x10000000) >> 28
}
func (o *PORT1_Type) SetPCNTR4_EORR13(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x20000000)|value<<29)
}
func (o *PORT1_Type) GetPCNTR4_EORR13() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x20000000) >> 29
}
func (o *PORT1_Type) SetPCNTR4_EORR14(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT1_Type) GetPCNTR4_EORR14() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x40000000) >> 30
}
func (o *PORT1_Type) SetPCNTR4_EORR15(value uint32) {
	volatile.StoreUint32(&o.PCNTR4.Reg, volatile.LoadUint32(&o.PCNTR4.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT1_Type) GetPCNTR4_EORR15() uint32 {
	return (volatile.LoadUint32(&o.PCNTR4.Reg) & 0x80000000) >> 31
}

// Pmn Pin Function Control Register
type PFS_Type struct {
	_       [40]byte
	P010PFS volatile.Register32 // 0x28
	P011PFS volatile.Register32 // 0x2C
	_       [8]byte
	P014PFS volatile.Register32 // 0x38
	P015PFS volatile.Register32 // 0x3C
	P100PFS volatile.Register32 // 0x40
	P101PFS volatile.Register32 // 0x44
	P102PFS volatile.Register32 // 0x48
	P103PFS volatile.Register32 // 0x4C
	_       [16]byte
	P108PFS volatile.Register32 // 0x60
	P109PFS volatile.Register32 // 0x64
	P110PFS volatile.Register32 // 0x68
	P111PFS volatile.Register32 // 0x6C
	P112PFS volatile.Register32 // 0x70
	_       [12]byte
	P200PFS volatile.Register32 // 0x80
	P201PFS volatile.Register32 // 0x84
	_       [12]byte
	P205PFS volatile.Register32 // 0x94
	_       [40]byte
	P300PFS volatile.Register32 // 0xC0
	_       [60]byte
	P400PFS volatile.Register32 // 0x100
	P401PFS volatile.Register32 // 0x104
	_       [368]byte
	P914PFS volatile.Register32 // 0x278
	_       [647]byte
	PWPR    volatile.Register8 // 0x503
	_       [11]byte
	PRWCNTR volatile.Register8 // 0x50F
}

// PFS.P010PFS: Port 0%s Pin Function Select Register
func (o *PFS_Type) SetP010PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP010PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P010PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP010PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP010PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP010PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP010PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP010PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP010PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP010PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP010PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP010PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP010PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP010PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP010PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP010PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP010PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP010PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P010PFS.Reg, volatile.LoadUint32(&o.P010PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP010PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P010PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P011PFS: Port 0%s Pin Function Select Register
func (o *PFS_Type) SetP011PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP011PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P011PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP011PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP011PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP011PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP011PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP011PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP011PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP011PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP011PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP011PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP011PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP011PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP011PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP011PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP011PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP011PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P011PFS.Reg, volatile.LoadUint32(&o.P011PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP011PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P011PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P014PFS: Port 0%s Pin Function Select Register
func (o *PFS_Type) SetP014PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP014PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P014PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP014PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP014PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP014PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP014PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP014PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP014PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP014PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP014PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP014PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP014PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP014PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP014PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP014PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP014PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP014PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P014PFS.Reg, volatile.LoadUint32(&o.P014PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP014PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P014PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P015PFS: Port 0%s Pin Function Select Register
func (o *PFS_Type) SetP015PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP015PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P015PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP015PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP015PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP015PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP015PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP015PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP015PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP015PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP015PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP015PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP015PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP015PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP015PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP015PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP015PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP015PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P015PFS.Reg, volatile.LoadUint32(&o.P015PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP015PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P015PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P100PFS: Port 10%s Pin Function Select Register
func (o *PFS_Type) SetP100PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP100PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P100PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP100PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP100PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP100PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP100PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP100PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP100PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP100PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP100PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP100PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP100PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP100PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP100PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP100PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP100PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP100PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP100PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP100PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P100PFS.Reg, volatile.LoadUint32(&o.P100PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP100PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P100PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P101PFS: Port 10%s Pin Function Select Register
func (o *PFS_Type) SetP101PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP101PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P101PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP101PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP101PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP101PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP101PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP101PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP101PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP101PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP101PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP101PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP101PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP101PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP101PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP101PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP101PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP101PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP101PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP101PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P101PFS.Reg, volatile.LoadUint32(&o.P101PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP101PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P101PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P102PFS: Port 10%s Pin Function Select Register
func (o *PFS_Type) SetP102PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP102PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P102PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP102PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP102PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP102PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP102PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP102PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP102PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP102PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP102PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP102PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP102PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP102PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP102PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP102PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP102PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP102PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP102PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP102PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P102PFS.Reg, volatile.LoadUint32(&o.P102PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP102PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P102PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P103PFS: Port 10%s Pin Function Select Register
func (o *PFS_Type) SetP103PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP103PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P103PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP103PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP103PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP103PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP103PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP103PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP103PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP103PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP103PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP103PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP103PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP103PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP103PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP103PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP103PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP103PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP103PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP103PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P103PFS.Reg, volatile.LoadUint32(&o.P103PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP103PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P103PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P108PFS: Port 108 Pin Function Select Register
func (o *PFS_Type) SetP108PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP108PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P108PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP108PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP108PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP108PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP108PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP108PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP108PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP108PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP108PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP108PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP108PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP108PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP108PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP108PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP108PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP108PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP108PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP108PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P108PFS.Reg, volatile.LoadUint32(&o.P108PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP108PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P108PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P109PFS: Port 109 Pin Function Select Register
func (o *PFS_Type) SetP109PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP109PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P109PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP109PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP109PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP109PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP109PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP109PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP109PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP109PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP109PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP109PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP109PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP109PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP109PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP109PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP109PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP109PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP109PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP109PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P109PFS.Reg, volatile.LoadUint32(&o.P109PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP109PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P109PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P110PFS: Port 1%s Pin Function Select Register
func (o *PFS_Type) SetP110PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP110PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P110PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP110PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP110PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP110PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP110PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP110PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP110PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP110PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP110PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP110PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP110PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP110PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP110PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP110PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP110PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP110PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP110PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP110PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P110PFS.Reg, volatile.LoadUint32(&o.P110PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP110PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P110PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P111PFS: Port 1%s Pin Function Select Register
func (o *PFS_Type) SetP111PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP111PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P111PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP111PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP111PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP111PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP111PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP111PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP111PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP111PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP111PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP111PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP111PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP111PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP111PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP111PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP111PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP111PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP111PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP111PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P111PFS.Reg, volatile.LoadUint32(&o.P111PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP111PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P111PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P112PFS: Port 1%s Pin Function Select Register
func (o *PFS_Type) SetP112PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP112PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P112PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP112PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP112PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP112PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP112PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP112PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP112PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP112PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP112PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP112PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP112PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP112PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP112PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP112PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP112PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP112PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP112PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP112PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P112PFS.Reg, volatile.LoadUint32(&o.P112PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP112PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P112PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P200PFS: Port 200 Pin Function Select Register
func (o *PFS_Type) SetP200PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP200PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P200PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP200PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP200PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP200PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP200PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP200PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP200PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP200PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP200PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP200PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP200PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP200PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP200PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP200PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP200PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP200PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP200PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP200PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P200PFS.Reg, volatile.LoadUint32(&o.P200PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP200PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P200PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P201PFS: Port 201 Pin Function Select Register
func (o *PFS_Type) SetP201PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP201PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P201PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP201PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP201PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP201PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP201PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP201PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP201PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP201PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP201PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP201PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP201PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP201PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP201PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP201PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP201PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP201PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP201PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP201PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P201PFS.Reg, volatile.LoadUint32(&o.P201PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP201PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P201PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P205PFS: Port 205 Pin Function Select Register
func (o *PFS_Type) SetP205PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP205PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P205PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP205PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP205PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP205PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP205PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP205PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP205PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP205PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP205PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP205PFS_EOFR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x3000)|value<<12)
}
func (o *PFS_Type) GetP205PFS_EOFR() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x3000) >> 12
}
func (o *PFS_Type) SetP205PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP205PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP205PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP205PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP205PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP205PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP205PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P205PFS.Reg, volatile.LoadUint32(&o.P205PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP205PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P205PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P300PFS: Port 300 Pin Function Select Register
func (o *PFS_Type) SetP300PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP300PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P300PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP300PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP300PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP300PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP300PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP300PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP300PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP300PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP300PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP300PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP300PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP300PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP300PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP300PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP300PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP300PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P300PFS.Reg, volatile.LoadUint32(&o.P300PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP300PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P300PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P400PFS: Port 40%s Pin Function Select Register
func (o *PFS_Type) SetP400PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP400PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P400PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP400PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP400PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP400PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP400PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP400PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP400PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP400PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP400PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP400PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP400PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP400PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP400PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP400PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP400PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP400PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P400PFS.Reg, volatile.LoadUint32(&o.P400PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP400PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P400PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P401PFS: Port 40%s Pin Function Select Register
func (o *PFS_Type) SetP401PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP401PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P401PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP401PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP401PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP401PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP401PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP401PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP401PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP401PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP401PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP401PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP401PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP401PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP401PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP401PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP401PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP401PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P401PFS.Reg, volatile.LoadUint32(&o.P401PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP401PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P401PFS.Reg) & 0x1f000000) >> 24
}

// PFS.P914PFS: Port 914 Pin Function Select Register
func (o *PFS_Type) SetP914PFS_PODR(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x1)|value)
}
func (o *PFS_Type) GetP914PFS_PODR() uint32 {
	return volatile.LoadUint32(&o.P914PFS.Reg) & 0x1
}
func (o *PFS_Type) SetP914PFS_PIDR(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x2)|value<<1)
}
func (o *PFS_Type) GetP914PFS_PIDR() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x2) >> 1
}
func (o *PFS_Type) SetP914PFS_PDR(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x4)|value<<2)
}
func (o *PFS_Type) GetP914PFS_PDR() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x4) >> 2
}
func (o *PFS_Type) SetP914PFS_PCR(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x10)|value<<4)
}
func (o *PFS_Type) GetP914PFS_PCR() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x10) >> 4
}
func (o *PFS_Type) SetP914PFS_NCODR(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetP914PFS_NCODR() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetP914PFS_ISEL(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x4000)|value<<14)
}
func (o *PFS_Type) GetP914PFS_ISEL() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x4000) >> 14
}
func (o *PFS_Type) SetP914PFS_ASEL(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x8000)|value<<15)
}
func (o *PFS_Type) GetP914PFS_ASEL() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x8000) >> 15
}
func (o *PFS_Type) SetP914PFS_PMR(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x10000)|value<<16)
}
func (o *PFS_Type) GetP914PFS_PMR() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x10000) >> 16
}
func (o *PFS_Type) SetP914PFS_PSEL(value uint32) {
	volatile.StoreUint32(&o.P914PFS.Reg, volatile.LoadUint32(&o.P914PFS.Reg)&^(0x1f000000)|value<<24)
}
func (o *PFS_Type) GetP914PFS_PSEL() uint32 {
	return (volatile.LoadUint32(&o.P914PFS.Reg) & 0x1f000000) >> 24
}

// PFS.PWPR: Write-Protect Register
func (o *PFS_Type) SetPWPR_PFSWE(value uint8) {
	volatile.StoreUint8(&o.PWPR.Reg, volatile.LoadUint8(&o.PWPR.Reg)&^(0x40)|value<<6)
}
func (o *PFS_Type) GetPWPR_PFSWE() uint8 {
	return (volatile.LoadUint8(&o.PWPR.Reg) & 0x40) >> 6
}
func (o *PFS_Type) SetPWPR_B0WI(value uint8) {
	volatile.StoreUint8(&o.PWPR.Reg, volatile.LoadUint8(&o.PWPR.Reg)&^(0x80)|value<<7)
}
func (o *PFS_Type) GetPWPR_B0WI() uint8 {
	return (volatile.LoadUint8(&o.PWPR.Reg) & 0x80) >> 7
}

// PFS.PRWCNTR: Port Read Wait Control Register
func (o *PFS_Type) SetPRWCNTR_WAIT(value uint8) {
	volatile.StoreUint8(&o.PRWCNTR.Reg, volatile.LoadUint8(&o.PRWCNTR.Reg)&^(0x3)|value)
}
func (o *PFS_Type) GetPRWCNTR_WAIT() uint8 {
	return volatile.LoadUint8(&o.PRWCNTR.Reg) & 0x3
}

// Event Link Controller
type ELC_Type struct {
	ELCR    volatile.Register8 // 0x0
	_       byte
	ELSEGR0 volatile.Register8 // 0x2
	_       byte
	ELSEGR1 volatile.Register8 // 0x4
	_       [11]byte
	ELSR0   volatile.Register16 // 0x10
	_       [2]byte
	ELSR1   volatile.Register16 // 0x14
	_       [2]byte
	ELSR2   volatile.Register16 // 0x18
	_       [2]byte
	ELSR3   volatile.Register16 // 0x1C
	_       [18]byte
	ELSR8   volatile.Register16 // 0x30
	_       [2]byte
	ELSR9   volatile.Register16 // 0x34
	_       [18]byte
	ELSR14  volatile.Register16 // 0x48
	_       [2]byte
	ELSR15  volatile.Register16 // 0x4C
}

// ELC.ELCR: Event Link Controller Register
func (o *ELC_Type) SetELCR_ELCON(value uint8) {
	volatile.StoreUint8(&o.ELCR.Reg, volatile.LoadUint8(&o.ELCR.Reg)&^(0x80)|value<<7)
}
func (o *ELC_Type) GetELCR_ELCON() uint8 {
	return (volatile.LoadUint8(&o.ELCR.Reg) & 0x80) >> 7
}

// ELC.ELSEGR0: Event Link Software Event Generation Register %s
func (o *ELC_Type) SetELSEGR0_SEG(value uint8) {
	volatile.StoreUint8(&o.ELSEGR0.Reg, volatile.LoadUint8(&o.ELSEGR0.Reg)&^(0x1)|value)
}
func (o *ELC_Type) GetELSEGR0_SEG() uint8 {
	return volatile.LoadUint8(&o.ELSEGR0.Reg) & 0x1
}
func (o *ELC_Type) SetELSEGR0_WE(value uint8) {
	volatile.StoreUint8(&o.ELSEGR0.Reg, volatile.LoadUint8(&o.ELSEGR0.Reg)&^(0x40)|value<<6)
}
func (o *ELC_Type) GetELSEGR0_WE() uint8 {
	return (volatile.LoadUint8(&o.ELSEGR0.Reg) & 0x40) >> 6
}
func (o *ELC_Type) SetELSEGR0_WI(value uint8) {
	volatile.StoreUint8(&o.ELSEGR0.Reg, volatile.LoadUint8(&o.ELSEGR0.Reg)&^(0x80)|value<<7)
}
func (o *ELC_Type) GetELSEGR0_WI() uint8 {
	return (volatile.LoadUint8(&o.ELSEGR0.Reg) & 0x80) >> 7
}

// ELC.ELSEGR1: Event Link Software Event Generation Register %s
func (o *ELC_Type) SetELSEGR1_SEG(value uint8) {
	volatile.StoreUint8(&o.ELSEGR1.Reg, volatile.LoadUint8(&o.ELSEGR1.Reg)&^(0x1)|value)
}
func (o *ELC_Type) GetELSEGR1_SEG() uint8 {
	return volatile.LoadUint8(&o.ELSEGR1.Reg) & 0x1
}
func (o *ELC_Type) SetELSEGR1_WE(value uint8) {
	volatile.StoreUint8(&o.ELSEGR1.Reg, volatile.LoadUint8(&o.ELSEGR1.Reg)&^(0x40)|value<<6)
}
func (o *ELC_Type) GetELSEGR1_WE() uint8 {
	return (volatile.LoadUint8(&o.ELSEGR1.Reg) & 0x40) >> 6
}
func (o *ELC_Type) SetELSEGR1_WI(value uint8) {
	volatile.StoreUint8(&o.ELSEGR1.Reg, volatile.LoadUint8(&o.ELSEGR1.Reg)&^(0x80)|value<<7)
}
func (o *ELC_Type) GetELSEGR1_WI() uint8 {
	return (volatile.LoadUint8(&o.ELSEGR1.Reg) & 0x80) >> 7
}

// ELC.ELSR0: Event Link Setting Register %s
func (o *ELC_Type) SetELSR0_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR0.Reg, volatile.LoadUint16(&o.ELSR0.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR0_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR0.Reg) & 0xff
}

// ELC.ELSR1: Event Link Setting Register %s
func (o *ELC_Type) SetELSR1_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR1.Reg, volatile.LoadUint16(&o.ELSR1.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR1_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR1.Reg) & 0xff
}

// ELC.ELSR2: Event Link Setting Register %s
func (o *ELC_Type) SetELSR2_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR2.Reg, volatile.LoadUint16(&o.ELSR2.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR2_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR2.Reg) & 0xff
}

// ELC.ELSR3: Event Link Setting Register %s
func (o *ELC_Type) SetELSR3_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR3.Reg, volatile.LoadUint16(&o.ELSR3.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR3_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR3.Reg) & 0xff
}

// ELC.ELSR8: Event Link Setting Register %s
func (o *ELC_Type) SetELSR8_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR8.Reg, volatile.LoadUint16(&o.ELSR8.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR8_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR8.Reg) & 0xff
}

// ELC.ELSR9: Event Link Setting Register %s
func (o *ELC_Type) SetELSR9_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR9.Reg, volatile.LoadUint16(&o.ELSR9.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR9_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR9.Reg) & 0xff
}

// ELC.ELSR14: Event Link Setting Register %s
func (o *ELC_Type) SetELSR14_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR14.Reg, volatile.LoadUint16(&o.ELSR14.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR14_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR14.Reg) & 0xff
}

// ELC.ELSR15: Event Link Setting Register %s
func (o *ELC_Type) SetELSR15_ELS(value uint16) {
	volatile.StoreUint16(&o.ELSR15.Reg, volatile.LoadUint16(&o.ELSR15.Reg)&^(0xff)|value)
}
func (o *ELC_Type) GetELSR15_ELS() uint16 {
	return volatile.LoadUint16(&o.ELSR15.Reg) & 0xff
}

// Port Output Enable Module for GPT
type POEG_Type struct {
	POEGGA volatile.Register32 // 0x0
	_      [252]byte
	POEGGB volatile.Register32 // 0x100
}

// POEG.POEGGA: POEG Group A Setting Register
func (o *POEG_Type) SetPOEGGA_PIDF(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x1)|value)
}
func (o *POEG_Type) GetPOEGGA_PIDF() uint32 {
	return volatile.LoadUint32(&o.POEGGA.Reg) & 0x1
}
func (o *POEG_Type) SetPOEGGA_IOCF(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x2)|value<<1)
}
func (o *POEG_Type) GetPOEGGA_IOCF() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x2) >> 1
}
func (o *POEG_Type) SetPOEGGA_SSF(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x8)|value<<3)
}
func (o *POEG_Type) GetPOEGGA_SSF() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x8) >> 3
}
func (o *POEG_Type) SetPOEGGA_PIDE(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x10)|value<<4)
}
func (o *POEG_Type) GetPOEGGA_PIDE() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x10) >> 4
}
func (o *POEG_Type) SetPOEGGA_IOCE(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x20)|value<<5)
}
func (o *POEG_Type) GetPOEGGA_IOCE() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x20) >> 5
}
func (o *POEG_Type) SetPOEGGA_ST(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x10000)|value<<16)
}
func (o *POEG_Type) GetPOEGGA_ST() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x10000) >> 16
}
func (o *POEG_Type) SetPOEGGA_INV(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x10000000)|value<<28)
}
func (o *POEG_Type) GetPOEGGA_INV() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x10000000) >> 28
}
func (o *POEG_Type) SetPOEGGA_NFEN(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0x20000000)|value<<29)
}
func (o *POEG_Type) GetPOEGGA_NFEN() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0x20000000) >> 29
}
func (o *POEG_Type) SetPOEGGA_NFCS(value uint32) {
	volatile.StoreUint32(&o.POEGGA.Reg, volatile.LoadUint32(&o.POEGGA.Reg)&^(0xc0000000)|value<<30)
}
func (o *POEG_Type) GetPOEGGA_NFCS() uint32 {
	return (volatile.LoadUint32(&o.POEGGA.Reg) & 0xc0000000) >> 30
}

// POEG.POEGGB: POEG Group B Setting Register
func (o *POEG_Type) SetPOEGGB_PIDF(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x1)|value)
}
func (o *POEG_Type) GetPOEGGB_PIDF() uint32 {
	return volatile.LoadUint32(&o.POEGGB.Reg) & 0x1
}
func (o *POEG_Type) SetPOEGGB_IOCF(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x2)|value<<1)
}
func (o *POEG_Type) GetPOEGGB_IOCF() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x2) >> 1
}
func (o *POEG_Type) SetPOEGGB_SSF(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x8)|value<<3)
}
func (o *POEG_Type) GetPOEGGB_SSF() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x8) >> 3
}
func (o *POEG_Type) SetPOEGGB_PIDE(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x10)|value<<4)
}
func (o *POEG_Type) GetPOEGGB_PIDE() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x10) >> 4
}
func (o *POEG_Type) SetPOEGGB_IOCE(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x20)|value<<5)
}
func (o *POEG_Type) GetPOEGGB_IOCE() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x20) >> 5
}
func (o *POEG_Type) SetPOEGGB_ST(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x10000)|value<<16)
}
func (o *POEG_Type) GetPOEGGB_ST() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x10000) >> 16
}
func (o *POEG_Type) SetPOEGGB_INV(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x10000000)|value<<28)
}
func (o *POEG_Type) GetPOEGGB_INV() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x10000000) >> 28
}
func (o *POEG_Type) SetPOEGGB_NFEN(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0x20000000)|value<<29)
}
func (o *POEG_Type) GetPOEGGB_NFEN() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0x20000000) >> 29
}
func (o *POEG_Type) SetPOEGGB_NFCS(value uint32) {
	volatile.StoreUint32(&o.POEGGB.Reg, volatile.LoadUint32(&o.POEGGB.Reg)&^(0xc0000000)|value<<30)
}
func (o *POEG_Type) GetPOEGGB_NFCS() uint32 {
	return (volatile.LoadUint32(&o.POEGGB.Reg) & 0xc0000000) >> 30
}

// Watchdog Timer
type WDT_Type struct {
	WDTRR    volatile.Register8 // 0x0
	_        byte
	WDTCR    volatile.Register16 // 0x2
	WDTSR    volatile.Register16 // 0x4
	WDTRCR   volatile.Register8  // 0x6
	_        byte
	WDTCSTPR volatile.Register8 // 0x8
}

// WDT.WDTCR: WDT Control Register
func (o *WDT_Type) SetWDTCR_TOPS(value uint16) {
	volatile.StoreUint16(&o.WDTCR.Reg, volatile.LoadUint16(&o.WDTCR.Reg)&^(0x3)|value)
}
func (o *WDT_Type) GetWDTCR_TOPS() uint16 {
	return volatile.LoadUint16(&o.WDTCR.Reg) & 0x3
}
func (o *WDT_Type) SetWDTCR_CKS(value uint16) {
	volatile.StoreUint16(&o.WDTCR.Reg, volatile.LoadUint16(&o.WDTCR.Reg)&^(0xf0)|value<<4)
}
func (o *WDT_Type) GetWDTCR_CKS() uint16 {
	return (volatile.LoadUint16(&o.WDTCR.Reg) & 0xf0) >> 4
}
func (o *WDT_Type) SetWDTCR_RPES(value uint16) {
	volatile.StoreUint16(&o.WDTCR.Reg, volatile.LoadUint16(&o.WDTCR.Reg)&^(0x300)|value<<8)
}
func (o *WDT_Type) GetWDTCR_RPES() uint16 {
	return (volatile.LoadUint16(&o.WDTCR.Reg) & 0x300) >> 8
}
func (o *WDT_Type) SetWDTCR_RPSS(value uint16) {
	volatile.StoreUint16(&o.WDTCR.Reg, volatile.LoadUint16(&o.WDTCR.Reg)&^(0x3000)|value<<12)
}
func (o *WDT_Type) GetWDTCR_RPSS() uint16 {
	return (volatile.LoadUint16(&o.WDTCR.Reg) & 0x3000) >> 12
}

// WDT.WDTSR: WDT Status Register
func (o *WDT_Type) SetWDTSR_CNTVAL(value uint16) {
	volatile.StoreUint16(&o.WDTSR.Reg, volatile.LoadUint16(&o.WDTSR.Reg)&^(0x3fff)|value)
}
func (o *WDT_Type) GetWDTSR_CNTVAL() uint16 {
	return volatile.LoadUint16(&o.WDTSR.Reg) & 0x3fff
}
func (o *WDT_Type) SetWDTSR_UNDFF(value uint16) {
	volatile.StoreUint16(&o.WDTSR.Reg, volatile.LoadUint16(&o.WDTSR.Reg)&^(0x4000)|value<<14)
}
func (o *WDT_Type) GetWDTSR_UNDFF() uint16 {
	return (volatile.LoadUint16(&o.WDTSR.Reg) & 0x4000) >> 14
}
func (o *WDT_Type) SetWDTSR_REFEF(value uint16) {
	volatile.StoreUint16(&o.WDTSR.Reg, volatile.LoadUint16(&o.WDTSR.Reg)&^(0x8000)|value<<15)
}
func (o *WDT_Type) GetWDTSR_REFEF() uint16 {
	return (volatile.LoadUint16(&o.WDTSR.Reg) & 0x8000) >> 15
}

// WDT.WDTRCR: WDT Reset Control Register
func (o *WDT_Type) SetWDTRCR_RSTIRQS(value uint8) {
	volatile.StoreUint8(&o.WDTRCR.Reg, volatile.LoadUint8(&o.WDTRCR.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetWDTRCR_RSTIRQS() uint8 {
	return (volatile.LoadUint8(&o.WDTRCR.Reg) & 0x80) >> 7
}

// WDT.WDTCSTPR: WDT Count Stop Control Register
func (o *WDT_Type) SetWDTCSTPR_SLCSTP(value uint8) {
	volatile.StoreUint8(&o.WDTCSTPR.Reg, volatile.LoadUint8(&o.WDTCSTPR.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetWDTCSTPR_SLCSTP() uint8 {
	return (volatile.LoadUint8(&o.WDTCSTPR.Reg) & 0x80) >> 7
}

// Independent Watchdog Timer
type IWDT_Type struct {
	IWDTRR volatile.Register8 // 0x0
	_      [3]byte
	IWDTSR volatile.Register16 // 0x4
}

// IWDT.IWDTSR: IWDT Status Register
func (o *IWDT_Type) SetIWDTSR_CNTVAL(value uint16) {
	volatile.StoreUint16(&o.IWDTSR.Reg, volatile.LoadUint16(&o.IWDTSR.Reg)&^(0x3fff)|value)
}
func (o *IWDT_Type) GetIWDTSR_CNTVAL() uint16 {
	return volatile.LoadUint16(&o.IWDTSR.Reg) & 0x3fff
}
func (o *IWDT_Type) SetIWDTSR_UNDFF(value uint16) {
	volatile.StoreUint16(&o.IWDTSR.Reg, volatile.LoadUint16(&o.IWDTSR.Reg)&^(0x4000)|value<<14)
}
func (o *IWDT_Type) GetIWDTSR_UNDFF() uint16 {
	return (volatile.LoadUint16(&o.IWDTSR.Reg) & 0x4000) >> 14
}
func (o *IWDT_Type) SetIWDTSR_REFEF(value uint16) {
	volatile.StoreUint16(&o.IWDTSR.Reg, volatile.LoadUint16(&o.IWDTSR.Reg)&^(0x8000)|value<<15)
}
func (o *IWDT_Type) GetIWDTSR_REFEF() uint16 {
	return (volatile.LoadUint16(&o.IWDTSR.Reg) & 0x8000) >> 15
}

// Clock Frequency Accuracy Measurement Circuit
type CAC_Type struct {
	CACR0   volatile.Register8 // 0x0
	CACR1   volatile.Register8 // 0x1
	CACR2   volatile.Register8 // 0x2
	CAICR   volatile.Register8 // 0x3
	CASTR   volatile.Register8 // 0x4
	_       byte
	CAULVR  volatile.Register16 // 0x6
	CALLVR  volatile.Register16 // 0x8
	CACNTBR volatile.Register16 // 0xA
}

// CAC.CACR0: CAC Control Register 0
func (o *CAC_Type) SetCACR0_CFME(value uint8) {
	volatile.StoreUint8(&o.CACR0.Reg, volatile.LoadUint8(&o.CACR0.Reg)&^(0x1)|value)
}
func (o *CAC_Type) GetCACR0_CFME() uint8 {
	return volatile.LoadUint8(&o.CACR0.Reg) & 0x1
}

// CAC.CACR1: CAC Control Register 1
func (o *CAC_Type) SetCACR1_CACREFE(value uint8) {
	volatile.StoreUint8(&o.CACR1.Reg, volatile.LoadUint8(&o.CACR1.Reg)&^(0x1)|value)
}
func (o *CAC_Type) GetCACR1_CACREFE() uint8 {
	return volatile.LoadUint8(&o.CACR1.Reg) & 0x1
}
func (o *CAC_Type) SetCACR1_FMCS(value uint8) {
	volatile.StoreUint8(&o.CACR1.Reg, volatile.LoadUint8(&o.CACR1.Reg)&^(0xe)|value<<1)
}
func (o *CAC_Type) GetCACR1_FMCS() uint8 {
	return (volatile.LoadUint8(&o.CACR1.Reg) & 0xe) >> 1
}
func (o *CAC_Type) SetCACR1_TCSS(value uint8) {
	volatile.StoreUint8(&o.CACR1.Reg, volatile.LoadUint8(&o.CACR1.Reg)&^(0x30)|value<<4)
}
func (o *CAC_Type) GetCACR1_TCSS() uint8 {
	return (volatile.LoadUint8(&o.CACR1.Reg) & 0x30) >> 4
}
func (o *CAC_Type) SetCACR1_EDGES(value uint8) {
	volatile.StoreUint8(&o.CACR1.Reg, volatile.LoadUint8(&o.CACR1.Reg)&^(0xc0)|value<<6)
}
func (o *CAC_Type) GetCACR1_EDGES() uint8 {
	return (volatile.LoadUint8(&o.CACR1.Reg) & 0xc0) >> 6
}

// CAC.CACR2: CAC Control Register 2
func (o *CAC_Type) SetCACR2_RPS(value uint8) {
	volatile.StoreUint8(&o.CACR2.Reg, volatile.LoadUint8(&o.CACR2.Reg)&^(0x1)|value)
}
func (o *CAC_Type) GetCACR2_RPS() uint8 {
	return volatile.LoadUint8(&o.CACR2.Reg) & 0x1
}
func (o *CAC_Type) SetCACR2_RSCS(value uint8) {
	volatile.StoreUint8(&o.CACR2.Reg, volatile.LoadUint8(&o.CACR2.Reg)&^(0xe)|value<<1)
}
func (o *CAC_Type) GetCACR2_RSCS() uint8 {
	return (volatile.LoadUint8(&o.CACR2.Reg) & 0xe) >> 1
}
func (o *CAC_Type) SetCACR2_RCDS(value uint8) {
	volatile.StoreUint8(&o.CACR2.Reg, volatile.LoadUint8(&o.CACR2.Reg)&^(0x30)|value<<4)
}
func (o *CAC_Type) GetCACR2_RCDS() uint8 {
	return (volatile.LoadUint8(&o.CACR2.Reg) & 0x30) >> 4
}
func (o *CAC_Type) SetCACR2_DFS(value uint8) {
	volatile.StoreUint8(&o.CACR2.Reg, volatile.LoadUint8(&o.CACR2.Reg)&^(0xc0)|value<<6)
}
func (o *CAC_Type) GetCACR2_DFS() uint8 {
	return (volatile.LoadUint8(&o.CACR2.Reg) & 0xc0) >> 6
}

// CAC.CAICR: CAC Interrupt Control Register
func (o *CAC_Type) SetCAICR_FERRIE(value uint8) {
	volatile.StoreUint8(&o.CAICR.Reg, volatile.LoadUint8(&o.CAICR.Reg)&^(0x1)|value)
}
func (o *CAC_Type) GetCAICR_FERRIE() uint8 {
	return volatile.LoadUint8(&o.CAICR.Reg) & 0x1
}
func (o *CAC_Type) SetCAICR_MENDIE(value uint8) {
	volatile.StoreUint8(&o.CAICR.Reg, volatile.LoadUint8(&o.CAICR.Reg)&^(0x2)|value<<1)
}
func (o *CAC_Type) GetCAICR_MENDIE() uint8 {
	return (volatile.LoadUint8(&o.CAICR.Reg) & 0x2) >> 1
}
func (o *CAC_Type) SetCAICR_OVFIE(value uint8) {
	volatile.StoreUint8(&o.CAICR.Reg, volatile.LoadUint8(&o.CAICR.Reg)&^(0x4)|value<<2)
}
func (o *CAC_Type) GetCAICR_OVFIE() uint8 {
	return (volatile.LoadUint8(&o.CAICR.Reg) & 0x4) >> 2
}
func (o *CAC_Type) SetCAICR_FERRFCL(value uint8) {
	volatile.StoreUint8(&o.CAICR.Reg, volatile.LoadUint8(&o.CAICR.Reg)&^(0x10)|value<<4)
}
func (o *CAC_Type) GetCAICR_FERRFCL() uint8 {
	return (volatile.LoadUint8(&o.CAICR.Reg) & 0x10) >> 4
}
func (o *CAC_Type) SetCAICR_MENDFCL(value uint8) {
	volatile.StoreUint8(&o.CAICR.Reg, volatile.LoadUint8(&o.CAICR.Reg)&^(0x20)|value<<5)
}
func (o *CAC_Type) GetCAICR_MENDFCL() uint8 {
	return (volatile.LoadUint8(&o.CAICR.Reg) & 0x20) >> 5
}
func (o *CAC_Type) SetCAICR_OVFFCL(value uint8) {
	volatile.StoreUint8(&o.CAICR.Reg, volatile.LoadUint8(&o.CAICR.Reg)&^(0x40)|value<<6)
}
func (o *CAC_Type) GetCAICR_OVFFCL() uint8 {
	return (volatile.LoadUint8(&o.CAICR.Reg) & 0x40) >> 6
}

// CAC.CASTR: CAC Status Register
func (o *CAC_Type) SetCASTR_FERRF(value uint8) {
	volatile.StoreUint8(&o.CASTR.Reg, volatile.LoadUint8(&o.CASTR.Reg)&^(0x1)|value)
}
func (o *CAC_Type) GetCASTR_FERRF() uint8 {
	return volatile.LoadUint8(&o.CASTR.Reg) & 0x1
}
func (o *CAC_Type) SetCASTR_MENDF(value uint8) {
	volatile.StoreUint8(&o.CASTR.Reg, volatile.LoadUint8(&o.CASTR.Reg)&^(0x2)|value<<1)
}
func (o *CAC_Type) GetCASTR_MENDF() uint8 {
	return (volatile.LoadUint8(&o.CASTR.Reg) & 0x2) >> 1
}
func (o *CAC_Type) SetCASTR_OVFF(value uint8) {
	volatile.StoreUint8(&o.CASTR.Reg, volatile.LoadUint8(&o.CASTR.Reg)&^(0x4)|value<<2)
}
func (o *CAC_Type) GetCASTR_OVFF() uint8 {
	return (volatile.LoadUint8(&o.CASTR.Reg) & 0x4) >> 2
}

// Module Stop Control B, C, D
type MSTP_Type struct {
	MSTPCRB  volatile.Register32 // 0x0
	MSTPCRC  volatile.Register32 // 0x4
	MSTPCRD  volatile.Register32 // 0x8
	LSMRWDIS volatile.Register16 // 0xC
}

// MSTP.MSTPCRB: Module Stop Control Register B
func (o *MSTP_Type) SetMSTPCRB_MSTPB9(value uint32) {
	volatile.StoreUint32(&o.MSTPCRB.Reg, volatile.LoadUint32(&o.MSTPCRB.Reg)&^(0x200)|value<<9)
}
func (o *MSTP_Type) GetMSTPCRB_MSTPB9() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRB.Reg) & 0x200) >> 9
}
func (o *MSTP_Type) SetMSTPCRB_MSTPB19(value uint32) {
	volatile.StoreUint32(&o.MSTPCRB.Reg, volatile.LoadUint32(&o.MSTPCRB.Reg)&^(0x80000)|value<<19)
}
func (o *MSTP_Type) GetMSTPCRB_MSTPB19() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRB.Reg) & 0x80000) >> 19
}
func (o *MSTP_Type) SetMSTPCRB_MSTPB22(value uint32) {
	volatile.StoreUint32(&o.MSTPCRB.Reg, volatile.LoadUint32(&o.MSTPCRB.Reg)&^(0x400000)|value<<22)
}
func (o *MSTP_Type) GetMSTPCRB_MSTPB22() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRB.Reg) & 0x400000) >> 22
}

// MSTP.MSTPCRC: Module Stop Control Register C
func (o *MSTP_Type) SetMSTPCRC_MSTPC0(value uint32) {
	volatile.StoreUint32(&o.MSTPCRC.Reg, volatile.LoadUint32(&o.MSTPCRC.Reg)&^(0x1)|value)
}
func (o *MSTP_Type) GetMSTPCRC_MSTPC0() uint32 {
	return volatile.LoadUint32(&o.MSTPCRC.Reg) & 0x1
}
func (o *MSTP_Type) SetMSTPCRC_MSTPC1(value uint32) {
	volatile.StoreUint32(&o.MSTPCRC.Reg, volatile.LoadUint32(&o.MSTPCRC.Reg)&^(0x2)|value<<1)
}
func (o *MSTP_Type) GetMSTPCRC_MSTPC1() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRC.Reg) & 0x2) >> 1
}
func (o *MSTP_Type) SetMSTPCRC_MSTPC13(value uint32) {
	volatile.StoreUint32(&o.MSTPCRC.Reg, volatile.LoadUint32(&o.MSTPCRC.Reg)&^(0x2000)|value<<13)
}
func (o *MSTP_Type) GetMSTPCRC_MSTPC13() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRC.Reg) & 0x2000) >> 13
}
func (o *MSTP_Type) SetMSTPCRC_MSTPC14(value uint32) {
	volatile.StoreUint32(&o.MSTPCRC.Reg, volatile.LoadUint32(&o.MSTPCRC.Reg)&^(0x4000)|value<<14)
}
func (o *MSTP_Type) GetMSTPCRC_MSTPC14() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRC.Reg) & 0x4000) >> 14
}
func (o *MSTP_Type) SetMSTPCRC_MSTPC28(value uint32) {
	volatile.StoreUint32(&o.MSTPCRC.Reg, volatile.LoadUint32(&o.MSTPCRC.Reg)&^(0x10000000)|value<<28)
}
func (o *MSTP_Type) GetMSTPCRC_MSTPC28() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRC.Reg) & 0x10000000) >> 28
}
func (o *MSTP_Type) SetMSTPCRC_MSTPC31(value uint32) {
	volatile.StoreUint32(&o.MSTPCRC.Reg, volatile.LoadUint32(&o.MSTPCRC.Reg)&^(0x80000000)|value<<31)
}
func (o *MSTP_Type) GetMSTPCRC_MSTPC31() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRC.Reg) & 0x80000000) >> 31
}

// MSTP.MSTPCRD: Module Stop Control Register D
func (o *MSTP_Type) SetMSTPCRD_MSTPD2(value uint32) {
	volatile.StoreUint32(&o.MSTPCRD.Reg, volatile.LoadUint32(&o.MSTPCRD.Reg)&^(0x4)|value<<2)
}
func (o *MSTP_Type) GetMSTPCRD_MSTPD2() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRD.Reg) & 0x4) >> 2
}
func (o *MSTP_Type) SetMSTPCRD_MSTPD3(value uint32) {
	volatile.StoreUint32(&o.MSTPCRD.Reg, volatile.LoadUint32(&o.MSTPCRD.Reg)&^(0x8)|value<<3)
}
func (o *MSTP_Type) GetMSTPCRD_MSTPD3() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRD.Reg) & 0x8) >> 3
}
func (o *MSTP_Type) SetMSTPCRD_MSTPD6(value uint32) {
	volatile.StoreUint32(&o.MSTPCRD.Reg, volatile.LoadUint32(&o.MSTPCRD.Reg)&^(0x40)|value<<6)
}
func (o *MSTP_Type) GetMSTPCRD_MSTPD6() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRD.Reg) & 0x40) >> 6
}
func (o *MSTP_Type) SetMSTPCRD_MSTPD14(value uint32) {
	volatile.StoreUint32(&o.MSTPCRD.Reg, volatile.LoadUint32(&o.MSTPCRD.Reg)&^(0x4000)|value<<14)
}
func (o *MSTP_Type) GetMSTPCRD_MSTPD14() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRD.Reg) & 0x4000) >> 14
}
func (o *MSTP_Type) SetMSTPCRD_MSTPD16(value uint32) {
	volatile.StoreUint32(&o.MSTPCRD.Reg, volatile.LoadUint32(&o.MSTPCRD.Reg)&^(0x10000)|value<<16)
}
func (o *MSTP_Type) GetMSTPCRD_MSTPD16() uint32 {
	return (volatile.LoadUint32(&o.MSTPCRD.Reg) & 0x10000) >> 16
}

// MSTP.LSMRWDIS: Low Speed Module R/W Disable Control Register
func (o *MSTP_Type) SetLSMRWDIS_WDTDIS(value uint16) {
	volatile.StoreUint16(&o.LSMRWDIS.Reg, volatile.LoadUint16(&o.LSMRWDIS.Reg)&^(0x2)|value<<1)
}
func (o *MSTP_Type) GetLSMRWDIS_WDTDIS() uint16 {
	return (volatile.LoadUint16(&o.LSMRWDIS.Reg) & 0x2) >> 1
}
func (o *MSTP_Type) SetLSMRWDIS_IWDTIDS(value uint16) {
	volatile.StoreUint16(&o.LSMRWDIS.Reg, volatile.LoadUint16(&o.LSMRWDIS.Reg)&^(0x4)|value<<2)
}
func (o *MSTP_Type) GetLSMRWDIS_IWDTIDS() uint16 {
	return (volatile.LoadUint16(&o.LSMRWDIS.Reg) & 0x4) >> 2
}
func (o *MSTP_Type) SetLSMRWDIS_WREN(value uint16) {
	volatile.StoreUint16(&o.LSMRWDIS.Reg, volatile.LoadUint16(&o.LSMRWDIS.Reg)&^(0x80)|value<<7)
}
func (o *MSTP_Type) GetLSMRWDIS_WREN() uint16 {
	return (volatile.LoadUint16(&o.LSMRWDIS.Reg) & 0x80) >> 7
}
func (o *MSTP_Type) SetLSMRWDIS_PRKEY(value uint16) {
	volatile.StoreUint16(&o.LSMRWDIS.Reg, volatile.LoadUint16(&o.LSMRWDIS.Reg)&^(0xff00)|value<<8)
}
func (o *MSTP_Type) GetLSMRWDIS_PRKEY() uint16 {
	return (volatile.LoadUint16(&o.LSMRWDIS.Reg) & 0xff00) >> 8
}

// Data Operation Circuit
type DOC_Type struct {
	DOCR  volatile.Register8 // 0x0
	_     byte
	DODIR volatile.Register16 // 0x2
	DODSR volatile.Register16 // 0x4
}

// DOC.DOCR: DOC Control Register
func (o *DOC_Type) SetDOCR_OMS(value uint8) {
	volatile.StoreUint8(&o.DOCR.Reg, volatile.LoadUint8(&o.DOCR.Reg)&^(0x3)|value)
}
func (o *DOC_Type) GetDOCR_OMS() uint8 {
	return volatile.LoadUint8(&o.DOCR.Reg) & 0x3
}
func (o *DOC_Type) SetDOCR_DCSEL(value uint8) {
	volatile.StoreUint8(&o.DOCR.Reg, volatile.LoadUint8(&o.DOCR.Reg)&^(0x4)|value<<2)
}
func (o *DOC_Type) GetDOCR_DCSEL() uint8 {
	return (volatile.LoadUint8(&o.DOCR.Reg) & 0x4) >> 2
}
func (o *DOC_Type) SetDOCR_DOPCF(value uint8) {
	volatile.StoreUint8(&o.DOCR.Reg, volatile.LoadUint8(&o.DOCR.Reg)&^(0x20)|value<<5)
}
func (o *DOC_Type) GetDOCR_DOPCF() uint8 {
	return (volatile.LoadUint8(&o.DOCR.Reg) & 0x20) >> 5
}
func (o *DOC_Type) SetDOCR_DOPCFCL(value uint8) {
	volatile.StoreUint8(&o.DOCR.Reg, volatile.LoadUint8(&o.DOCR.Reg)&^(0x40)|value<<6)
}
func (o *DOC_Type) GetDOCR_DOPCFCL() uint8 {
	return (volatile.LoadUint8(&o.DOCR.Reg) & 0x40) >> 6
}

// 12-bit A/D Converter
type ADC120_Type struct {
	ADCSR      volatile.Register16 // 0x0
	_          [2]byte
	ADANSA0    volatile.Register16 // 0x4
	ADANSA1    volatile.Register16 // 0x6
	ADADS0     volatile.Register16 // 0x8
	ADADS1     volatile.Register16 // 0xA
	ADADC      volatile.Register8  // 0xC
	_          byte
	ADCER      volatile.Register16 // 0xE
	ADSTRGR    volatile.Register16 // 0x10
	ADEXICR    volatile.Register16 // 0x12
	ADANSB0    volatile.Register16 // 0x14
	ADANSB1    volatile.Register16 // 0x16
	ADDBLDR    volatile.Register16 // 0x18
	ADTSDR     volatile.Register16 // 0x1A
	ADOCDR     volatile.Register16 // 0x1C
	ADRD       volatile.Register16 // 0x1E
	_          [10]byte
	ADDR5      volatile.Register16 // 0x2A
	ADDR6      volatile.Register16 // 0x2C
	_          [4]byte
	ADDR9      volatile.Register16 // 0x32
	ADDR10     volatile.Register16 // 0x34
	_          [16]byte
	ADDR19     volatile.Register16 // 0x46
	ADDR20     volatile.Register16 // 0x48
	ADDR21     volatile.Register16 // 0x4A
	ADDR22     volatile.Register16 // 0x4C
	_          [44]byte
	ADDISCR    volatile.Register8 // 0x7A
	_          [3]byte
	ADACSR     volatile.Register8 // 0x7E
	_          byte
	ADGSPCR    volatile.Register16 // 0x80
	_          [2]byte
	ADDBLDRA   volatile.Register16 // 0x84
	ADDBLDRB   volatile.Register16 // 0x86
	_          [2]byte
	ADHVREFCNT volatile.Register8 // 0x8A
	_          byte
	ADWINMON   volatile.Register8 // 0x8C
	_          [3]byte
	ADCMPCR    volatile.Register16 // 0x90
	ADCMPANSER volatile.Register8  // 0x92
	ADCMPLER   volatile.Register8  // 0x93
	ADCMPANSR0 volatile.Register16 // 0x94
	ADCMPANSR1 volatile.Register16 // 0x96
	ADCMPLR0   volatile.Register16 // 0x98
	ADCMPLR1   volatile.Register16 // 0x9A
	ADCMPDR0   volatile.Register16 // 0x9C
	ADCMPDR1   volatile.Register16 // 0x9E
	ADCMPSR0   volatile.Register16 // 0xA0
	ADCMPSR1   volatile.Register16 // 0xA2
	ADCMPSER   volatile.Register8  // 0xA4
	_          byte
	ADCMPBNSR  volatile.Register8 // 0xA6
	_          byte
	ADWINLLB   volatile.Register16 // 0xA8
	ADWINULB   volatile.Register16 // 0xAA
	ADCMPBSR   volatile.Register8  // 0xAC
	_          [48]byte
	ADSSTRL    volatile.Register8 // 0xDD
	ADSSTRT    volatile.Register8 // 0xDE
	ADSSTRO    volatile.Register8 // 0xDF
	_          [5]byte
	ADSSTR5    volatile.Register8 // 0xE5
	ADSSTR6    volatile.Register8 // 0xE6
	_          [2]byte
	ADSSTR9    volatile.Register8 // 0xE9
	ADSSTR10   volatile.Register8 // 0xEA
}

// ADC120.ADCSR: A/D Control Register
func (o *ADC120_Type) SetADCSR_DBLANS(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x1f)|value)
}
func (o *ADC120_Type) GetADCSR_DBLANS() uint16 {
	return volatile.LoadUint16(&o.ADCSR.Reg) & 0x1f
}
func (o *ADC120_Type) SetADCSR_GBADIE(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCSR_GBADIE() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADCSR_DBLE(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADCSR_DBLE() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADCSR_EXTRG(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADCSR_EXTRG() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADCSR_TRGE(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADCSR_TRGE() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADCSR_ADHSC(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADCSR_ADHSC() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADCSR_ADCS(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x6000)|value<<13)
}
func (o *ADC120_Type) GetADCSR_ADCS() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x6000) >> 13
}
func (o *ADC120_Type) SetADCSR_ADST(value uint16) {
	volatile.StoreUint16(&o.ADCSR.Reg, volatile.LoadUint16(&o.ADCSR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADCSR_ADST() uint16 {
	return (volatile.LoadUint16(&o.ADCSR.Reg) & 0x8000) >> 15
}

// ADC120.ADANSA0: A/D Channel Select Register A0
func (o *ADC120_Type) SetADANSA0_ANSA00(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADANSA0_ANSA00() uint16 {
	return volatile.LoadUint16(&o.ADANSA0.Reg) & 0x1
}
func (o *ADC120_Type) SetADANSA0_ANSA01(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADANSA0_ANSA01() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADANSA0_ANSA02(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADANSA0_ANSA02() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADANSA0_ANSA03(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADANSA0_ANSA03() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADANSA0_ANSA04(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADANSA0_ANSA04() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADANSA0_ANSA05(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADANSA0_ANSA05() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADANSA0_ANSA06(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADANSA0_ANSA06() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADANSA0_ANSA07(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADANSA0_ANSA07() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADANSA0_ANSA08(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADANSA0_ANSA08() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADANSA0_ANSA09(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADANSA0_ANSA09() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADANSA0_ANSA10(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADANSA0_ANSA10() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADANSA0_ANSA11(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADANSA0_ANSA11() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADANSA0_ANSA12(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x1000)|value<<12)
}
func (o *ADC120_Type) GetADANSA0_ANSA12() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x1000) >> 12
}
func (o *ADC120_Type) SetADANSA0_ANSA13(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADANSA0_ANSA13() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADANSA0_ANSA14(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADANSA0_ANSA14() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADANSA0_ANSA15(value uint16) {
	volatile.StoreUint16(&o.ADANSA0.Reg, volatile.LoadUint16(&o.ADANSA0.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADANSA0_ANSA15() uint16 {
	return (volatile.LoadUint16(&o.ADANSA0.Reg) & 0x8000) >> 15
}

// ADC120.ADANSA1: A/D Channel Select Register A1
func (o *ADC120_Type) SetADANSA1_ANSA16(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADANSA1_ANSA16() uint16 {
	return volatile.LoadUint16(&o.ADANSA1.Reg) & 0x1
}
func (o *ADC120_Type) SetADANSA1_ANSA17(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADANSA1_ANSA17() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADANSA1_ANSA18(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADANSA1_ANSA18() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADANSA1_ANSA19(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADANSA1_ANSA19() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADANSA1_ANSA20(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADANSA1_ANSA20() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADANSA1_ANSA21(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADANSA1_ANSA21() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADANSA1_ANSA22(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADANSA1_ANSA22() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADANSA1_ANSA23(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADANSA1_ANSA23() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADANSA1_ANSA24(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADANSA1_ANSA24() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADANSA1_ANSA25(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADANSA1_ANSA25() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADANSA1_ANSA26(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADANSA1_ANSA26() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADANSA1_ANSA27(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADANSA1_ANSA27() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADANSA1_ANSA28(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x1000)|value<<12)
}
func (o *ADC120_Type) GetADANSA1_ANSA28() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x1000) >> 12
}
func (o *ADC120_Type) SetADANSA1_ANSA29(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADANSA1_ANSA29() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADANSA1_ANSA30(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADANSA1_ANSA30() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADANSA1_ANSA31(value uint16) {
	volatile.StoreUint16(&o.ADANSA1.Reg, volatile.LoadUint16(&o.ADANSA1.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADANSA1_ANSA31() uint16 {
	return (volatile.LoadUint16(&o.ADANSA1.Reg) & 0x8000) >> 15
}

// ADC120.ADADS0: A/D-Converted Value Addition/Average Channel Select Register 0
func (o *ADC120_Type) SetADADS0_ADS00(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADADS0_ADS00() uint16 {
	return volatile.LoadUint16(&o.ADADS0.Reg) & 0x1
}
func (o *ADC120_Type) SetADADS0_ADS01(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADADS0_ADS01() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADADS0_ADS02(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADADS0_ADS02() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADADS0_ADS03(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADADS0_ADS03() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADADS0_ADS04(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADADS0_ADS04() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADADS0_ADS05(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADADS0_ADS05() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADADS0_ADS06(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADADS0_ADS06() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADADS0_ADS07(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADADS0_ADS07() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADADS0_ADS08(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADADS0_ADS08() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADADS0_ADS09(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADADS0_ADS09() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADADS0_ADS10(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADADS0_ADS10() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADADS0_ADS11(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADADS0_ADS11() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADADS0_ADS12(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x1000)|value<<12)
}
func (o *ADC120_Type) GetADADS0_ADS12() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x1000) >> 12
}
func (o *ADC120_Type) SetADADS0_ADS13(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADADS0_ADS13() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADADS0_ADS14(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADADS0_ADS14() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADADS0_ADS15(value uint16) {
	volatile.StoreUint16(&o.ADADS0.Reg, volatile.LoadUint16(&o.ADADS0.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADADS0_ADS15() uint16 {
	return (volatile.LoadUint16(&o.ADADS0.Reg) & 0x8000) >> 15
}

// ADC120.ADADS1: A/D-Converted Value Addition/Average Channel Select Register 1
func (o *ADC120_Type) SetADADS1_ADS16(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADADS1_ADS16() uint16 {
	return volatile.LoadUint16(&o.ADADS1.Reg) & 0x1
}
func (o *ADC120_Type) SetADADS1_ADS17(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADADS1_ADS17() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADADS1_ADS18(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADADS1_ADS18() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADADS1_ADS19(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADADS1_ADS19() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADADS1_ADS20(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADADS1_ADS20() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADADS1_ADS21(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADADS1_ADS21() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADADS1_ADS22(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADADS1_ADS22() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADADS1_ADS23(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADADS1_ADS23() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADADS1_ADS24(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADADS1_ADS24() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADADS1_ADS25(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADADS1_ADS25() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADADS1_ADS26(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADADS1_ADS26() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADADS1_ADS27(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADADS1_ADS27() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADADS1_ADS28(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x1000)|value<<12)
}
func (o *ADC120_Type) GetADADS1_ADS28() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x1000) >> 12
}
func (o *ADC120_Type) SetADADS1_ADS29(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADADS1_ADS29() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADADS1_ADS30(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADADS1_ADS30() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADADS1_ADS31(value uint16) {
	volatile.StoreUint16(&o.ADADS1.Reg, volatile.LoadUint16(&o.ADADS1.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADADS1_ADS31() uint16 {
	return (volatile.LoadUint16(&o.ADADS1.Reg) & 0x8000) >> 15
}

// ADC120.ADADC: A/D-Converted Value Addition/Average Count Select Register
func (o *ADC120_Type) SetADADC_ADC(value uint8) {
	volatile.StoreUint8(&o.ADADC.Reg, volatile.LoadUint8(&o.ADADC.Reg)&^(0x7)|value)
}
func (o *ADC120_Type) GetADADC_ADC() uint8 {
	return volatile.LoadUint8(&o.ADADC.Reg) & 0x7
}
func (o *ADC120_Type) SetADADC_AVEE(value uint8) {
	volatile.StoreUint8(&o.ADADC.Reg, volatile.LoadUint8(&o.ADADC.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADADC_AVEE() uint8 {
	return (volatile.LoadUint8(&o.ADADC.Reg) & 0x80) >> 7
}

// ADC120.ADCER: A/D Control Extended Register
func (o *ADC120_Type) SetADCER_ACE(value uint16) {
	volatile.StoreUint16(&o.ADCER.Reg, volatile.LoadUint16(&o.ADCER.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCER_ACE() uint16 {
	return (volatile.LoadUint16(&o.ADCER.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCER_DIAGVAL(value uint16) {
	volatile.StoreUint16(&o.ADCER.Reg, volatile.LoadUint16(&o.ADCER.Reg)&^(0x300)|value<<8)
}
func (o *ADC120_Type) GetADCER_DIAGVAL() uint16 {
	return (volatile.LoadUint16(&o.ADCER.Reg) & 0x300) >> 8
}
func (o *ADC120_Type) SetADCER_DIAGLD(value uint16) {
	volatile.StoreUint16(&o.ADCER.Reg, volatile.LoadUint16(&o.ADCER.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADCER_DIAGLD() uint16 {
	return (volatile.LoadUint16(&o.ADCER.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADCER_DIAGM(value uint16) {
	volatile.StoreUint16(&o.ADCER.Reg, volatile.LoadUint16(&o.ADCER.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADCER_DIAGM() uint16 {
	return (volatile.LoadUint16(&o.ADCER.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADCER_ADRFMT(value uint16) {
	volatile.StoreUint16(&o.ADCER.Reg, volatile.LoadUint16(&o.ADCER.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADCER_ADRFMT() uint16 {
	return (volatile.LoadUint16(&o.ADCER.Reg) & 0x8000) >> 15
}

// ADC120.ADSTRGR: A/D Conversion Start Trigger Select Register
func (o *ADC120_Type) SetADSTRGR_TRSB(value uint16) {
	volatile.StoreUint16(&o.ADSTRGR.Reg, volatile.LoadUint16(&o.ADSTRGR.Reg)&^(0x3f)|value)
}
func (o *ADC120_Type) GetADSTRGR_TRSB() uint16 {
	return volatile.LoadUint16(&o.ADSTRGR.Reg) & 0x3f
}
func (o *ADC120_Type) SetADSTRGR_TRSA(value uint16) {
	volatile.StoreUint16(&o.ADSTRGR.Reg, volatile.LoadUint16(&o.ADSTRGR.Reg)&^(0x3f00)|value<<8)
}
func (o *ADC120_Type) GetADSTRGR_TRSA() uint16 {
	return (volatile.LoadUint16(&o.ADSTRGR.Reg) & 0x3f00) >> 8
}

// ADC120.ADEXICR: A/D Conversion Extended Input Control Registers
func (o *ADC120_Type) SetADEXICR_TSSAD(value uint16) {
	volatile.StoreUint16(&o.ADEXICR.Reg, volatile.LoadUint16(&o.ADEXICR.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADEXICR_TSSAD() uint16 {
	return volatile.LoadUint16(&o.ADEXICR.Reg) & 0x1
}
func (o *ADC120_Type) SetADEXICR_OCSAD(value uint16) {
	volatile.StoreUint16(&o.ADEXICR.Reg, volatile.LoadUint16(&o.ADEXICR.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADEXICR_OCSAD() uint16 {
	return (volatile.LoadUint16(&o.ADEXICR.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADEXICR_TSSA(value uint16) {
	volatile.StoreUint16(&o.ADEXICR.Reg, volatile.LoadUint16(&o.ADEXICR.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADEXICR_TSSA() uint16 {
	return (volatile.LoadUint16(&o.ADEXICR.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADEXICR_OCSA(value uint16) {
	volatile.StoreUint16(&o.ADEXICR.Reg, volatile.LoadUint16(&o.ADEXICR.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADEXICR_OCSA() uint16 {
	return (volatile.LoadUint16(&o.ADEXICR.Reg) & 0x200) >> 9
}

// ADC120.ADANSB0: A/D Channel Select Register B0
func (o *ADC120_Type) SetADANSB0_ANSB00(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADANSB0_ANSB00() uint16 {
	return volatile.LoadUint16(&o.ADANSB0.Reg) & 0x1
}
func (o *ADC120_Type) SetADANSB0_ANSB01(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADANSB0_ANSB01() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADANSB0_ANSB02(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADANSB0_ANSB02() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADANSB0_ANSB03(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADANSB0_ANSB03() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADANSB0_ANSB04(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADANSB0_ANSB04() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADANSB0_ANSB05(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADANSB0_ANSB05() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADANSB0_ANSB06(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADANSB0_ANSB06() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADANSB0_ANSB07(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADANSB0_ANSB07() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADANSB0_ANSB08(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADANSB0_ANSB08() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADANSB0_ANSB09(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADANSB0_ANSB09() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADANSB0_ANSB10(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADANSB0_ANSB10() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADANSB0_ANSB11(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADANSB0_ANSB11() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADANSB0_ANSB12(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x1000)|value<<12)
}
func (o *ADC120_Type) GetADANSB0_ANSB12() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x1000) >> 12
}
func (o *ADC120_Type) SetADANSB0_ANSB13(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADANSB0_ANSB13() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADANSB0_ANSB14(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADANSB0_ANSB14() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADANSB0_ANSB15(value uint16) {
	volatile.StoreUint16(&o.ADANSB0.Reg, volatile.LoadUint16(&o.ADANSB0.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADANSB0_ANSB15() uint16 {
	return (volatile.LoadUint16(&o.ADANSB0.Reg) & 0x8000) >> 15
}

// ADC120.ADANSB1: A/D Channel Select Register B1
func (o *ADC120_Type) SetADANSB1_ANSB16(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADANSB1_ANSB16() uint16 {
	return volatile.LoadUint16(&o.ADANSB1.Reg) & 0x1
}
func (o *ADC120_Type) SetADANSB1_ANSB17(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADANSB1_ANSB17() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADANSB1_ANSB18(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADANSB1_ANSB18() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADANSB1_ANSB19(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADANSB1_ANSB19() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADANSB1_ANSB20(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADANSB1_ANSB20() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADANSB1_ANSB21(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADANSB1_ANSB21() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADANSB1_ANSB22(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADANSB1_ANSB22() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADANSB1_ANSB23(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADANSB1_ANSB23() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADANSB1_ANSB24(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADANSB1_ANSB24() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADANSB1_ANSB25(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADANSB1_ANSB25() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADANSB1_ANSB26(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADANSB1_ANSB26() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADANSB1_ANSB27(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADANSB1_ANSB27() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADANSB1_ANSB28(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x1000)|value<<12)
}
func (o *ADC120_Type) GetADANSB1_ANSB28() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x1000) >> 12
}
func (o *ADC120_Type) SetADANSB1_ANSB29(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADANSB1_ANSB29() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADANSB1_ANSB30(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADANSB1_ANSB30() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADANSB1_ANSB31(value uint16) {
	volatile.StoreUint16(&o.ADANSB1.Reg, volatile.LoadUint16(&o.ADANSB1.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADANSB1_ANSB31() uint16 {
	return (volatile.LoadUint16(&o.ADANSB1.Reg) & 0x8000) >> 15
}

// ADC120.ADDBLDR: A/D Data Duplexing Register
func (o *ADC120_Type) SetADDBLDR(value uint16) {
	volatile.StoreUint16(&o.ADDBLDR.Reg, value)
}
func (o *ADC120_Type) GetADDBLDR() uint16 {
	return volatile.LoadUint16(&o.ADDBLDR.Reg)
}

// ADC120.ADTSDR: A/D Temperature Sensor Data Register
func (o *ADC120_Type) SetADTSDR(value uint16) {
	volatile.StoreUint16(&o.ADTSDR.Reg, value)
}
func (o *ADC120_Type) GetADTSDR() uint16 {
	return volatile.LoadUint16(&o.ADTSDR.Reg)
}

// ADC120.ADOCDR: A/D Internal Reference Voltage Data Register
func (o *ADC120_Type) SetADOCDR(value uint16) {
	volatile.StoreUint16(&o.ADOCDR.Reg, value)
}
func (o *ADC120_Type) GetADOCDR() uint16 {
	return volatile.LoadUint16(&o.ADOCDR.Reg)
}

// ADC120.ADRD: A/D Self-Diagnosis Data Register
func (o *ADC120_Type) SetADRD_AD(value uint16) {
	volatile.StoreUint16(&o.ADRD.Reg, volatile.LoadUint16(&o.ADRD.Reg)&^(0xfff)|value)
}
func (o *ADC120_Type) GetADRD_AD() uint16 {
	return volatile.LoadUint16(&o.ADRD.Reg) & 0xfff
}
func (o *ADC120_Type) SetADRD_DIAGST(value uint16) {
	volatile.StoreUint16(&o.ADRD.Reg, volatile.LoadUint16(&o.ADRD.Reg)&^(0xc000)|value<<14)
}
func (o *ADC120_Type) GetADRD_DIAGST() uint16 {
	return (volatile.LoadUint16(&o.ADRD.Reg) & 0xc000) >> 14
}

// ADC120.ADDR5: A/D Data Registers %s
func (o *ADC120_Type) SetADDR5(value uint16) {
	volatile.StoreUint16(&o.ADDR5.Reg, value)
}
func (o *ADC120_Type) GetADDR5() uint16 {
	return volatile.LoadUint16(&o.ADDR5.Reg)
}

// ADC120.ADDR6: A/D Data Registers %s
func (o *ADC120_Type) SetADDR6(value uint16) {
	volatile.StoreUint16(&o.ADDR6.Reg, value)
}
func (o *ADC120_Type) GetADDR6() uint16 {
	return volatile.LoadUint16(&o.ADDR6.Reg)
}

// ADC120.ADDR9: A/D Data Registers %s
func (o *ADC120_Type) SetADDR9(value uint16) {
	volatile.StoreUint16(&o.ADDR9.Reg, value)
}
func (o *ADC120_Type) GetADDR9() uint16 {
	return volatile.LoadUint16(&o.ADDR9.Reg)
}

// ADC120.ADDR10: A/D Data Registers %s
func (o *ADC120_Type) SetADDR10(value uint16) {
	volatile.StoreUint16(&o.ADDR10.Reg, value)
}
func (o *ADC120_Type) GetADDR10() uint16 {
	return volatile.LoadUint16(&o.ADDR10.Reg)
}

// ADC120.ADDR19: A/D Data Registers %s
func (o *ADC120_Type) SetADDR19(value uint16) {
	volatile.StoreUint16(&o.ADDR19.Reg, value)
}
func (o *ADC120_Type) GetADDR19() uint16 {
	return volatile.LoadUint16(&o.ADDR19.Reg)
}

// ADC120.ADDR20: A/D Data Registers %s
func (o *ADC120_Type) SetADDR20(value uint16) {
	volatile.StoreUint16(&o.ADDR20.Reg, value)
}
func (o *ADC120_Type) GetADDR20() uint16 {
	return volatile.LoadUint16(&o.ADDR20.Reg)
}

// ADC120.ADDR21: A/D Data Registers %s
func (o *ADC120_Type) SetADDR21(value uint16) {
	volatile.StoreUint16(&o.ADDR21.Reg, value)
}
func (o *ADC120_Type) GetADDR21() uint16 {
	return volatile.LoadUint16(&o.ADDR21.Reg)
}

// ADC120.ADDR22: A/D Data Registers %s
func (o *ADC120_Type) SetADDR22(value uint16) {
	volatile.StoreUint16(&o.ADDR22.Reg, value)
}
func (o *ADC120_Type) GetADDR22() uint16 {
	return volatile.LoadUint16(&o.ADDR22.Reg)
}

// ADC120.ADDISCR: A/D Disconnection Detection Control Register
func (o *ADC120_Type) SetADDISCR_ADNDIS(value uint8) {
	volatile.StoreUint8(&o.ADDISCR.Reg, volatile.LoadUint8(&o.ADDISCR.Reg)&^(0xf)|value)
}
func (o *ADC120_Type) GetADDISCR_ADNDIS() uint8 {
	return volatile.LoadUint8(&o.ADDISCR.Reg) & 0xf
}
func (o *ADC120_Type) SetADDISCR_PCHG(value uint8) {
	volatile.StoreUint8(&o.ADDISCR.Reg, volatile.LoadUint8(&o.ADDISCR.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADDISCR_PCHG() uint8 {
	return (volatile.LoadUint8(&o.ADDISCR.Reg) & 0x10) >> 4
}

// ADC120.ADACSR: A/D Conversion Operation Mode Select Register
func (o *ADC120_Type) SetADACSR_ADSAC(value uint8) {
	volatile.StoreUint8(&o.ADACSR.Reg, volatile.LoadUint8(&o.ADACSR.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADACSR_ADSAC() uint8 {
	return (volatile.LoadUint8(&o.ADACSR.Reg) & 0x2) >> 1
}

// ADC120.ADGSPCR: A/D Group Scan Priority Control Register
func (o *ADC120_Type) SetADGSPCR_PGS(value uint16) {
	volatile.StoreUint16(&o.ADGSPCR.Reg, volatile.LoadUint16(&o.ADGSPCR.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADGSPCR_PGS() uint16 {
	return volatile.LoadUint16(&o.ADGSPCR.Reg) & 0x1
}
func (o *ADC120_Type) SetADGSPCR_GBRSCN(value uint16) {
	volatile.StoreUint16(&o.ADGSPCR.Reg, volatile.LoadUint16(&o.ADGSPCR.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADGSPCR_GBRSCN() uint16 {
	return (volatile.LoadUint16(&o.ADGSPCR.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADGSPCR_GBRP(value uint16) {
	volatile.StoreUint16(&o.ADGSPCR.Reg, volatile.LoadUint16(&o.ADGSPCR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADGSPCR_GBRP() uint16 {
	return (volatile.LoadUint16(&o.ADGSPCR.Reg) & 0x8000) >> 15
}

// ADC120.ADDBLDRA: A/D Data Duplexing Register A
func (o *ADC120_Type) SetADDBLDRA(value uint16) {
	volatile.StoreUint16(&o.ADDBLDRA.Reg, value)
}
func (o *ADC120_Type) GetADDBLDRA() uint16 {
	return volatile.LoadUint16(&o.ADDBLDRA.Reg)
}

// ADC120.ADDBLDRB: A/D Data Duplexing Register B
func (o *ADC120_Type) SetADDBLDRB(value uint16) {
	volatile.StoreUint16(&o.ADDBLDRB.Reg, value)
}
func (o *ADC120_Type) GetADDBLDRB() uint16 {
	return volatile.LoadUint16(&o.ADDBLDRB.Reg)
}

// ADC120.ADHVREFCNT: A/D High-Potential/Low-Potential Reference Voltage Control Register
func (o *ADC120_Type) SetADHVREFCNT_HVSEL(value uint8) {
	volatile.StoreUint8(&o.ADHVREFCNT.Reg, volatile.LoadUint8(&o.ADHVREFCNT.Reg)&^(0x3)|value)
}
func (o *ADC120_Type) GetADHVREFCNT_HVSEL() uint8 {
	return volatile.LoadUint8(&o.ADHVREFCNT.Reg) & 0x3
}
func (o *ADC120_Type) SetADHVREFCNT_LVSEL(value uint8) {
	volatile.StoreUint8(&o.ADHVREFCNT.Reg, volatile.LoadUint8(&o.ADHVREFCNT.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADHVREFCNT_LVSEL() uint8 {
	return (volatile.LoadUint8(&o.ADHVREFCNT.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADHVREFCNT_ADSLP(value uint8) {
	volatile.StoreUint8(&o.ADHVREFCNT.Reg, volatile.LoadUint8(&o.ADHVREFCNT.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADHVREFCNT_ADSLP() uint8 {
	return (volatile.LoadUint8(&o.ADHVREFCNT.Reg) & 0x80) >> 7
}

// ADC120.ADWINMON: A/D Compare Function Window A/B Status Monitor Register
func (o *ADC120_Type) SetADWINMON_MONCOMB(value uint8) {
	volatile.StoreUint8(&o.ADWINMON.Reg, volatile.LoadUint8(&o.ADWINMON.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADWINMON_MONCOMB() uint8 {
	return volatile.LoadUint8(&o.ADWINMON.Reg) & 0x1
}
func (o *ADC120_Type) SetADWINMON_MONCMPA(value uint8) {
	volatile.StoreUint8(&o.ADWINMON.Reg, volatile.LoadUint8(&o.ADWINMON.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADWINMON_MONCMPA() uint8 {
	return (volatile.LoadUint8(&o.ADWINMON.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADWINMON_MONCMPB(value uint8) {
	volatile.StoreUint8(&o.ADWINMON.Reg, volatile.LoadUint8(&o.ADWINMON.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADWINMON_MONCMPB() uint8 {
	return (volatile.LoadUint8(&o.ADWINMON.Reg) & 0x20) >> 5
}

// ADC120.ADCMPCR: A/D Compare Function Control Register
func (o *ADC120_Type) SetADCMPCR_CMPAB(value uint16) {
	volatile.StoreUint16(&o.ADCMPCR.Reg, volatile.LoadUint16(&o.ADCMPCR.Reg)&^(0x3)|value)
}
func (o *ADC120_Type) GetADCMPCR_CMPAB() uint16 {
	return volatile.LoadUint16(&o.ADCMPCR.Reg) & 0x3
}
func (o *ADC120_Type) SetADCMPCR_CMPBE(value uint16) {
	volatile.StoreUint16(&o.ADCMPCR.Reg, volatile.LoadUint16(&o.ADCMPCR.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADCMPCR_CMPBE() uint16 {
	return (volatile.LoadUint16(&o.ADCMPCR.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADCMPCR_CMPAE(value uint16) {
	volatile.StoreUint16(&o.ADCMPCR.Reg, volatile.LoadUint16(&o.ADCMPCR.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADCMPCR_CMPAE() uint16 {
	return (volatile.LoadUint16(&o.ADCMPCR.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADCMPCR_CMPBIE(value uint16) {
	volatile.StoreUint16(&o.ADCMPCR.Reg, volatile.LoadUint16(&o.ADCMPCR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADCMPCR_CMPBIE() uint16 {
	return (volatile.LoadUint16(&o.ADCMPCR.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADCMPCR_WCMPE(value uint16) {
	volatile.StoreUint16(&o.ADCMPCR.Reg, volatile.LoadUint16(&o.ADCMPCR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADCMPCR_WCMPE() uint16 {
	return (volatile.LoadUint16(&o.ADCMPCR.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADCMPCR_CMPAIE(value uint16) {
	volatile.StoreUint16(&o.ADCMPCR.Reg, volatile.LoadUint16(&o.ADCMPCR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADCMPCR_CMPAIE() uint16 {
	return (volatile.LoadUint16(&o.ADCMPCR.Reg) & 0x8000) >> 15
}

// ADC120.ADCMPANSER: A/D Compare Function Window A Extended Input Select Register
func (o *ADC120_Type) SetADCMPANSER_CMPTSA(value uint8) {
	volatile.StoreUint8(&o.ADCMPANSER.Reg, volatile.LoadUint8(&o.ADCMPANSER.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPANSER_CMPTSA() uint8 {
	return volatile.LoadUint8(&o.ADCMPANSER.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPANSER_CMPOCA(value uint8) {
	volatile.StoreUint8(&o.ADCMPANSER.Reg, volatile.LoadUint8(&o.ADCMPANSER.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPANSER_CMPOCA() uint8 {
	return (volatile.LoadUint8(&o.ADCMPANSER.Reg) & 0x2) >> 1
}

// ADC120.ADCMPLER: A/D Compare Function Window A Extended Input Comparison Condition Setting Register
func (o *ADC120_Type) SetADCMPLER_CMPLTSA(value uint8) {
	volatile.StoreUint8(&o.ADCMPLER.Reg, volatile.LoadUint8(&o.ADCMPLER.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPLER_CMPLTSA() uint8 {
	return volatile.LoadUint8(&o.ADCMPLER.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPLER_CMPLOCA(value uint8) {
	volatile.StoreUint8(&o.ADCMPLER.Reg, volatile.LoadUint8(&o.ADCMPLER.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPLER_CMPLOCA() uint8 {
	return (volatile.LoadUint8(&o.ADCMPLER.Reg) & 0x2) >> 1
}

// ADC120.ADCMPANSR0: A/D Compare Function Window A Channel Select Register 0
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA00(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA00() uint16 {
	return volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA01(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA01() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA02(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA02() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA03(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA03() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA04(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA04() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA05(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA05() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA06(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA06() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA07(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA07() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA08(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA08() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA09(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA09() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA10(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA10() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA11(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA11() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA12(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x1000)|value<<12)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA12() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x1000) >> 12
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA13(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA13() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA14(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA14() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADCMPANSR0_CMPCHA15(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR0.Reg, volatile.LoadUint16(&o.ADCMPANSR0.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADCMPANSR0_CMPCHA15() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR0.Reg) & 0x8000) >> 15
}

// ADC120.ADCMPANSR1: A/D Compare Function Window A Channel Select Register 1
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA16(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA16() uint16 {
	return volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA17(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA17() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA18(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA18() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA19(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA19() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA20(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA20() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA21(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA21() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA22(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA22() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA23(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA23() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA24(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA24() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA25(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA25() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA26(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA26() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA27(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA27() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA28(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x1000)|value<<12)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA28() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x1000) >> 12
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA29(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA29() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA30(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA30() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADCMPANSR1_CMPCHA31(value uint16) {
	volatile.StoreUint16(&o.ADCMPANSR1.Reg, volatile.LoadUint16(&o.ADCMPANSR1.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADCMPANSR1_CMPCHA31() uint16 {
	return (volatile.LoadUint16(&o.ADCMPANSR1.Reg) & 0x8000) >> 15
}

// ADC120.ADCMPLR0: A/D Compare Function Window A Comparison Condition Setting Register 0
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA00(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA00() uint16 {
	return volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA01(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA01() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA02(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA02() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA03(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA03() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA04(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA04() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA05(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA05() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA06(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA06() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA07(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA07() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA08(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA08() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA09(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA09() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA10(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA10() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA11(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA11() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA12(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x1000)|value<<12)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA12() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x1000) >> 12
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA13(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA13() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA14(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA14() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADCMPLR0_CMPLCHA15(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR0.Reg, volatile.LoadUint16(&o.ADCMPLR0.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADCMPLR0_CMPLCHA15() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR0.Reg) & 0x8000) >> 15
}

// ADC120.ADCMPLR1: A/D Compare Function Window A Comparison Condition Setting Register 1
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA16(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA16() uint16 {
	return volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA17(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA17() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA18(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA18() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA19(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA19() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA20(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA20() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA21(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA21() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA22(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA22() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA23(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA23() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA24(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA24() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA25(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA25() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA26(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA26() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA27(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA27() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA28(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x1000)|value<<12)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA28() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x1000) >> 12
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA29(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA29() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA30(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA30() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADCMPLR1_CMPLCHA31(value uint16) {
	volatile.StoreUint16(&o.ADCMPLR1.Reg, volatile.LoadUint16(&o.ADCMPLR1.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADCMPLR1_CMPLCHA31() uint16 {
	return (volatile.LoadUint16(&o.ADCMPLR1.Reg) & 0x8000) >> 15
}

// ADC120.ADCMPSR0: A/D Compare Function Window A Channel Status Register 0
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA00(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA00() uint16 {
	return volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA01(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA01() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA02(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA02() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA03(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA03() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA04(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA04() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA05(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA05() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA06(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA06() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA07(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA07() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA08(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA08() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA09(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA09() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA10(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA10() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA11(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA11() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA12(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x1000)|value<<12)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA12() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x1000) >> 12
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA13(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA13() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA14(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA14() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADCMPSR0_CMPSTCHA15(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR0.Reg, volatile.LoadUint16(&o.ADCMPSR0.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADCMPSR0_CMPSTCHA15() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR0.Reg) & 0x8000) >> 15
}

// ADC120.ADCMPSR1: A/D Compare Function Window A Channel Status Register1
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA16(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA16() uint16 {
	return volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA17(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA17() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x2) >> 1
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA18(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x4)|value<<2)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA18() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x4) >> 2
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA19(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x8)|value<<3)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA19() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x8) >> 3
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA20(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x10)|value<<4)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA20() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x10) >> 4
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA21(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x20)|value<<5)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA21() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x20) >> 5
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA22(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x40)|value<<6)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA22() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x40) >> 6
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA23(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA23() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x80) >> 7
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA24(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x100)|value<<8)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA24() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x100) >> 8
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA25(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x200)|value<<9)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA25() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x200) >> 9
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA26(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x400)|value<<10)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA26() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x400) >> 10
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA27(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x800)|value<<11)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA27() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x800) >> 11
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA28(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x1000)|value<<12)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA28() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x1000) >> 12
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA29(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x2000)|value<<13)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA29() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x2000) >> 13
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA30(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x4000)|value<<14)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA30() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x4000) >> 14
}
func (o *ADC120_Type) SetADCMPSR1_CMPSTCHA31(value uint16) {
	volatile.StoreUint16(&o.ADCMPSR1.Reg, volatile.LoadUint16(&o.ADCMPSR1.Reg)&^(0x8000)|value<<15)
}
func (o *ADC120_Type) GetADCMPSR1_CMPSTCHA31() uint16 {
	return (volatile.LoadUint16(&o.ADCMPSR1.Reg) & 0x8000) >> 15
}

// ADC120.ADCMPSER: A/D Compare Function Window A Extended Input Channel Status Register
func (o *ADC120_Type) SetADCMPSER_CMPSTTSA(value uint8) {
	volatile.StoreUint8(&o.ADCMPSER.Reg, volatile.LoadUint8(&o.ADCMPSER.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPSER_CMPSTTSA() uint8 {
	return volatile.LoadUint8(&o.ADCMPSER.Reg) & 0x1
}
func (o *ADC120_Type) SetADCMPSER_CMPSTOCA(value uint8) {
	volatile.StoreUint8(&o.ADCMPSER.Reg, volatile.LoadUint8(&o.ADCMPSER.Reg)&^(0x2)|value<<1)
}
func (o *ADC120_Type) GetADCMPSER_CMPSTOCA() uint8 {
	return (volatile.LoadUint8(&o.ADCMPSER.Reg) & 0x2) >> 1
}

// ADC120.ADCMPBNSR: A/D Compare Function Window B Channel Select Register
func (o *ADC120_Type) SetADCMPBNSR_CMPCHB(value uint8) {
	volatile.StoreUint8(&o.ADCMPBNSR.Reg, volatile.LoadUint8(&o.ADCMPBNSR.Reg)&^(0x3f)|value)
}
func (o *ADC120_Type) GetADCMPBNSR_CMPCHB() uint8 {
	return volatile.LoadUint8(&o.ADCMPBNSR.Reg) & 0x3f
}
func (o *ADC120_Type) SetADCMPBNSR_CMPLB(value uint8) {
	volatile.StoreUint8(&o.ADCMPBNSR.Reg, volatile.LoadUint8(&o.ADCMPBNSR.Reg)&^(0x80)|value<<7)
}
func (o *ADC120_Type) GetADCMPBNSR_CMPLB() uint8 {
	return (volatile.LoadUint8(&o.ADCMPBNSR.Reg) & 0x80) >> 7
}

// ADC120.ADCMPBSR: A/D Compare Function Window B Status Register
func (o *ADC120_Type) SetADCMPBSR_CMPSTB(value uint8) {
	volatile.StoreUint8(&o.ADCMPBSR.Reg, volatile.LoadUint8(&o.ADCMPBSR.Reg)&^(0x1)|value)
}
func (o *ADC120_Type) GetADCMPBSR_CMPSTB() uint8 {
	return volatile.LoadUint8(&o.ADCMPBSR.Reg) & 0x1
}

// ADC120.ADSSTRL: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTRL(value uint8) {
	volatile.StoreUint8(&o.ADSSTRL.Reg, value)
}
func (o *ADC120_Type) GetADSSTRL() uint8 {
	return volatile.LoadUint8(&o.ADSSTRL.Reg)
}

// ADC120.ADSSTRT: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTRT(value uint8) {
	volatile.StoreUint8(&o.ADSSTRT.Reg, value)
}
func (o *ADC120_Type) GetADSSTRT() uint8 {
	return volatile.LoadUint8(&o.ADSSTRT.Reg)
}

// ADC120.ADSSTRO: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTRO(value uint8) {
	volatile.StoreUint8(&o.ADSSTRO.Reg, value)
}
func (o *ADC120_Type) GetADSSTRO() uint8 {
	return volatile.LoadUint8(&o.ADSSTRO.Reg)
}

// ADC120.ADSSTR5: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR5(value uint8) {
	volatile.StoreUint8(&o.ADSSTR5.Reg, value)
}
func (o *ADC120_Type) GetADSSTR5() uint8 {
	return volatile.LoadUint8(&o.ADSSTR5.Reg)
}

// ADC120.ADSSTR6: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR6(value uint8) {
	volatile.StoreUint8(&o.ADSSTR6.Reg, value)
}
func (o *ADC120_Type) GetADSSTR6() uint8 {
	return volatile.LoadUint8(&o.ADSSTR6.Reg)
}

// ADC120.ADSSTR9: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR9(value uint8) {
	volatile.StoreUint8(&o.ADSSTR9.Reg, value)
}
func (o *ADC120_Type) GetADSSTR9() uint8 {
	return volatile.LoadUint8(&o.ADSSTR9.Reg)
}

// ADC120.ADSSTR10: A/D Sampling State Register
func (o *ADC120_Type) SetADSSTR10(value uint8) {
	volatile.StoreUint8(&o.ADSSTR10.Reg, value)
}
func (o *ADC120_Type) GetADSSTR10() uint8 {
	return volatile.LoadUint8(&o.ADSSTR10.Reg)
}

// Serial Communication Interface 0
type SCI9_Type struct {
	SMR   volatile.Register8  // 0x0
	BRR   volatile.Register8  // 0x1
	SCR   volatile.Register8  // 0x2
	TDR   volatile.Register8  // 0x3
	SSR   volatile.Register8  // 0x4
	RDR   volatile.Register8  // 0x5
	SCMR  volatile.Register8  // 0x6
	SEMR  volatile.Register8  // 0x7
	SNFR  volatile.Register8  // 0x8
	SIMR1 volatile.Register8  // 0x9
	SIMR2 volatile.Register8  // 0xA
	SIMR3 volatile.Register8  // 0xB
	SISR  volatile.Register8  // 0xC
	SPMR  volatile.Register8  // 0xD
	TDRHL volatile.Register16 // 0xE
	RDRHL volatile.Register16 // 0x10
	MDDR  volatile.Register8  // 0x12
	DCCR  volatile.Register8  // 0x13
	_     [6]byte
	CDR   volatile.Register16 // 0x1A
	SPTR  volatile.Register8  // 0x1C
}

// SCI9.SMR: Serial Mode Register for Non-Smart Card Interface Mode (SCMR.SMIF = 0)
func (o *SCI9_Type) SetSMR_CKS(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x3)|value)
}
func (o *SCI9_Type) GetSMR_CKS() uint8 {
	return volatile.LoadUint8(&o.SMR.Reg) & 0x3
}
func (o *SCI9_Type) SetSMR_MP(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x4)|value<<2)
}
func (o *SCI9_Type) GetSMR_MP() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x4) >> 2
}
func (o *SCI9_Type) SetSMR_STOP(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x8)|value<<3)
}
func (o *SCI9_Type) GetSMR_STOP() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x8) >> 3
}
func (o *SCI9_Type) SetSMR_PM(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x10)|value<<4)
}
func (o *SCI9_Type) GetSMR_PM() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x10) >> 4
}
func (o *SCI9_Type) SetSMR_PE(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x20)|value<<5)
}
func (o *SCI9_Type) GetSMR_PE() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x20) >> 5
}
func (o *SCI9_Type) SetSMR_CHR(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x40)|value<<6)
}
func (o *SCI9_Type) GetSMR_CHR() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x40) >> 6
}
func (o *SCI9_Type) SetSMR_CM(value uint8) {
	volatile.StoreUint8(&o.SMR.Reg, volatile.LoadUint8(&o.SMR.Reg)&^(0x80)|value<<7)
}
func (o *SCI9_Type) GetSMR_CM() uint8 {
	return (volatile.LoadUint8(&o.SMR.Reg) & 0x80) >> 7
}

// SCI9.SCR: Serial Control Register for Non-Smart Card Interface Mode (SCMR.SMIF = 0)
func (o *SCI9_Type) SetSCR_CKE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x3)|value)
}
func (o *SCI9_Type) GetSCR_CKE() uint8 {
	return volatile.LoadUint8(&o.SCR.Reg) & 0x3
}
func (o *SCI9_Type) SetSCR_TEIE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x4)|value<<2)
}
func (o *SCI9_Type) GetSCR_TEIE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x4) >> 2
}
func (o *SCI9_Type) SetSCR_MPIE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x8)|value<<3)
}
func (o *SCI9_Type) GetSCR_MPIE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x8) >> 3
}
func (o *SCI9_Type) SetSCR_RE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x10)|value<<4)
}
func (o *SCI9_Type) GetSCR_RE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x10) >> 4
}
func (o *SCI9_Type) SetSCR_TE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x20)|value<<5)
}
func (o *SCI9_Type) GetSCR_TE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x20) >> 5
}
func (o *SCI9_Type) SetSCR_RIE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x40)|value<<6)
}
func (o *SCI9_Type) GetSCR_RIE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x40) >> 6
}
func (o *SCI9_Type) SetSCR_TIE(value uint8) {
	volatile.StoreUint8(&o.SCR.Reg, volatile.LoadUint8(&o.SCR.Reg)&^(0x80)|value<<7)
}
func (o *SCI9_Type) GetSCR_TIE() uint8 {
	return (volatile.LoadUint8(&o.SCR.Reg) & 0x80) >> 7
}

// SCI9.SSR: Serial Status Register for Non-Smart Card Interface (SCMR.SMIF = 0)
func (o *SCI9_Type) SetSSR_MPBT(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x1)|value)
}
func (o *SCI9_Type) GetSSR_MPBT() uint8 {
	return volatile.LoadUint8(&o.SSR.Reg) & 0x1
}
func (o *SCI9_Type) SetSSR_MPB(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x2)|value<<1)
}
func (o *SCI9_Type) GetSSR_MPB() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x2) >> 1
}
func (o *SCI9_Type) SetSSR_TEND(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x4)|value<<2)
}
func (o *SCI9_Type) GetSSR_TEND() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x4) >> 2
}
func (o *SCI9_Type) SetSSR_PER(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x8)|value<<3)
}
func (o *SCI9_Type) GetSSR_PER() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x8) >> 3
}
func (o *SCI9_Type) SetSSR_FER(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x10)|value<<4)
}
func (o *SCI9_Type) GetSSR_FER() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x10) >> 4
}
func (o *SCI9_Type) SetSSR_ORER(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x20)|value<<5)
}
func (o *SCI9_Type) GetSSR_ORER() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x20) >> 5
}
func (o *SCI9_Type) SetSSR_RDRF(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x40)|value<<6)
}
func (o *SCI9_Type) GetSSR_RDRF() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x40) >> 6
}
func (o *SCI9_Type) SetSSR_TDRE(value uint8) {
	volatile.StoreUint8(&o.SSR.Reg, volatile.LoadUint8(&o.SSR.Reg)&^(0x80)|value<<7)
}
func (o *SCI9_Type) GetSSR_TDRE() uint8 {
	return (volatile.LoadUint8(&o.SSR.Reg) & 0x80) >> 7
}

// SCI9.SCMR: Smart Card Mode Register
func (o *SCI9_Type) SetSCMR_SMIF(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x1)|value)
}
func (o *SCI9_Type) GetSCMR_SMIF() uint8 {
	return volatile.LoadUint8(&o.SCMR.Reg) & 0x1
}
func (o *SCI9_Type) SetSCMR_SINV(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x4)|value<<2)
}
func (o *SCI9_Type) GetSCMR_SINV() uint8 {
	return (volatile.LoadUint8(&o.SCMR.Reg) & 0x4) >> 2
}
func (o *SCI9_Type) SetSCMR_SDIR(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x8)|value<<3)
}
func (o *SCI9_Type) GetSCMR_SDIR() uint8 {
	return (volatile.LoadUint8(&o.SCMR.Reg) & 0x8) >> 3
}
func (o *SCI9_Type) SetSCMR_CHR1(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x10)|value<<4)
}
func (o *SCI9_Type) GetSCMR_CHR1() uint8 {
	return (volatile.LoadUint8(&o.SCMR.Reg) & 0x10) >> 4
}
func (o *SCI9_Type) SetSCMR_BCP2(value uint8) {
	volatile.StoreUint8(&o.SCMR.Reg, volatile.LoadUint8(&o.SCMR.Reg)&^(0x80)|value<<7)
}
func (o *SCI9_Type) GetSCMR_BCP2() uint8 {
	return (volatile.LoadUint8(&o.SCMR.Reg) & 0x80) >> 7
}

// SCI9.SEMR: Serial Extended Mode Register
func (o *SCI9_Type) SetSEMR_BRME(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x4)|value<<2)
}
func (o *SCI9_Type) GetSEMR_BRME() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x4) >> 2
}
func (o *SCI9_Type) SetSEMR_ABCSE(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x8)|value<<3)
}
func (o *SCI9_Type) GetSEMR_ABCSE() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x8) >> 3
}
func (o *SCI9_Type) SetSEMR_ABCS(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x10)|value<<4)
}
func (o *SCI9_Type) GetSEMR_ABCS() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x10) >> 4
}
func (o *SCI9_Type) SetSEMR_NFEN(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x20)|value<<5)
}
func (o *SCI9_Type) GetSEMR_NFEN() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x20) >> 5
}
func (o *SCI9_Type) SetSEMR_BGDM(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x40)|value<<6)
}
func (o *SCI9_Type) GetSEMR_BGDM() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x40) >> 6
}
func (o *SCI9_Type) SetSEMR_RXDESEL(value uint8) {
	volatile.StoreUint8(&o.SEMR.Reg, volatile.LoadUint8(&o.SEMR.Reg)&^(0x80)|value<<7)
}
func (o *SCI9_Type) GetSEMR_RXDESEL() uint8 {
	return (volatile.LoadUint8(&o.SEMR.Reg) & 0x80) >> 7
}

// SCI9.SNFR: Noise Filter Setting Register
func (o *SCI9_Type) SetSNFR_NFCS(value uint8) {
	volatile.StoreUint8(&o.SNFR.Reg, volatile.LoadUint8(&o.SNFR.Reg)&^(0x7)|value)
}
func (o *SCI9_Type) GetSNFR_NFCS() uint8 {
	return volatile.LoadUint8(&o.SNFR.Reg) & 0x7
}

// SCI9.SIMR1: IIC Mode Register 1
func (o *SCI9_Type) SetSIMR1_IICM(value uint8) {
	volatile.StoreUint8(&o.SIMR1.Reg, volatile.LoadUint8(&o.SIMR1.Reg)&^(0x1)|value)
}
func (o *SCI9_Type) GetSIMR1_IICM() uint8 {
	return volatile.LoadUint8(&o.SIMR1.Reg) & 0x1
}
func (o *SCI9_Type) SetSIMR1_IICDL(value uint8) {
	volatile.StoreUint8(&o.SIMR1.Reg, volatile.LoadUint8(&o.SIMR1.Reg)&^(0xf8)|value<<3)
}
func (o *SCI9_Type) GetSIMR1_IICDL() uint8 {
	return (volatile.LoadUint8(&o.SIMR1.Reg) & 0xf8) >> 3
}

// SCI9.SIMR2: IIC Mode Register 2
func (o *SCI9_Type) SetSIMR2_IICINTM(value uint8) {
	volatile.StoreUint8(&o.SIMR2.Reg, volatile.LoadUint8(&o.SIMR2.Reg)&^(0x1)|value)
}
func (o *SCI9_Type) GetSIMR2_IICINTM() uint8 {
	return volatile.LoadUint8(&o.SIMR2.Reg) & 0x1
}
func (o *SCI9_Type) SetSIMR2_IICCSC(value uint8) {
	volatile.StoreUint8(&o.SIMR2.Reg, volatile.LoadUint8(&o.SIMR2.Reg)&^(0x2)|value<<1)
}
func (o *SCI9_Type) GetSIMR2_IICCSC() uint8 {
	return (volatile.LoadUint8(&o.SIMR2.Reg) & 0x2) >> 1
}
func (o *SCI9_Type) SetSIMR2_IICACKT(value uint8) {
	volatile.StoreUint8(&o.SIMR2.Reg, volatile.LoadUint8(&o.SIMR2.Reg)&^(0x20)|value<<5)
}
func (o *SCI9_Type) GetSIMR2_IICACKT() uint8 {
	return (volatile.LoadUint8(&o.SIMR2.Reg) & 0x20) >> 5
}

// SCI9.SIMR3: IIC Mode Register 3
func (o *SCI9_Type) SetSIMR3_IICSTAREQ(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x1)|value)
}
func (o *SCI9_Type) GetSIMR3_IICSTAREQ() uint8 {
	return volatile.LoadUint8(&o.SIMR3.Reg) & 0x1
}
func (o *SCI9_Type) SetSIMR3_IICRSTAREQ(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x2)|value<<1)
}
func (o *SCI9_Type) GetSIMR3_IICRSTAREQ() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0x2) >> 1
}
func (o *SCI9_Type) SetSIMR3_IICSTPREQ(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x4)|value<<2)
}
func (o *SCI9_Type) GetSIMR3_IICSTPREQ() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0x4) >> 2
}
func (o *SCI9_Type) SetSIMR3_IICSTIF(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x8)|value<<3)
}
func (o *SCI9_Type) GetSIMR3_IICSTIF() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0x8) >> 3
}
func (o *SCI9_Type) SetSIMR3_IICSDAS(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0x30)|value<<4)
}
func (o *SCI9_Type) GetSIMR3_IICSDAS() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0x30) >> 4
}
func (o *SCI9_Type) SetSIMR3_IICSCLS(value uint8) {
	volatile.StoreUint8(&o.SIMR3.Reg, volatile.LoadUint8(&o.SIMR3.Reg)&^(0xc0)|value<<6)
}
func (o *SCI9_Type) GetSIMR3_IICSCLS() uint8 {
	return (volatile.LoadUint8(&o.SIMR3.Reg) & 0xc0) >> 6
}

// SCI9.SISR: IIC Status Register
func (o *SCI9_Type) SetSISR_IICACKR(value uint8) {
	volatile.StoreUint8(&o.SISR.Reg, volatile.LoadUint8(&o.SISR.Reg)&^(0x1)|value)
}
func (o *SCI9_Type) GetSISR_IICACKR() uint8 {
	return volatile.LoadUint8(&o.SISR.Reg) & 0x1
}

// SCI9.SPMR: SPI Mode Register
func (o *SCI9_Type) SetSPMR_SSE(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x1)|value)
}
func (o *SCI9_Type) GetSPMR_SSE() uint8 {
	return volatile.LoadUint8(&o.SPMR.Reg) & 0x1
}
func (o *SCI9_Type) SetSPMR_CTSE(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x2)|value<<1)
}
func (o *SCI9_Type) GetSPMR_CTSE() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x2) >> 1
}
func (o *SCI9_Type) SetSPMR_MSS(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x4)|value<<2)
}
func (o *SCI9_Type) GetSPMR_MSS() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x4) >> 2
}
func (o *SCI9_Type) SetSPMR_MFF(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x10)|value<<4)
}
func (o *SCI9_Type) GetSPMR_MFF() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x10) >> 4
}
func (o *SCI9_Type) SetSPMR_CKPOL(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x40)|value<<6)
}
func (o *SCI9_Type) GetSPMR_CKPOL() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x40) >> 6
}
func (o *SCI9_Type) SetSPMR_CKPH(value uint8) {
	volatile.StoreUint8(&o.SPMR.Reg, volatile.LoadUint8(&o.SPMR.Reg)&^(0x80)|value<<7)
}
func (o *SCI9_Type) GetSPMR_CKPH() uint8 {
	return (volatile.LoadUint8(&o.SPMR.Reg) & 0x80) >> 7
}

// SCI9.TDRHL: Transmit Data Register
func (o *SCI9_Type) SetTDRHL_TDAT(value uint16) {
	volatile.StoreUint16(&o.TDRHL.Reg, volatile.LoadUint16(&o.TDRHL.Reg)&^(0x1ff)|value)
}
func (o *SCI9_Type) GetTDRHL_TDAT() uint16 {
	return volatile.LoadUint16(&o.TDRHL.Reg) & 0x1ff
}

// SCI9.RDRHL: Receive Data Register
func (o *SCI9_Type) SetRDRHL_RDAT(value uint16) {
	volatile.StoreUint16(&o.RDRHL.Reg, volatile.LoadUint16(&o.RDRHL.Reg)&^(0x1ff)|value)
}
func (o *SCI9_Type) GetRDRHL_RDAT() uint16 {
	return volatile.LoadUint16(&o.RDRHL.Reg) & 0x1ff
}

// SCI9.DCCR: Data Compare Match Control Register
func (o *SCI9_Type) SetDCCR_DCMF(value uint8) {
	volatile.StoreUint8(&o.DCCR.Reg, volatile.LoadUint8(&o.DCCR.Reg)&^(0x1)|value)
}
func (o *SCI9_Type) GetDCCR_DCMF() uint8 {
	return volatile.LoadUint8(&o.DCCR.Reg) & 0x1
}
func (o *SCI9_Type) SetDCCR_DPER(value uint8) {
	volatile.StoreUint8(&o.DCCR.Reg, volatile.LoadUint8(&o.DCCR.Reg)&^(0x8)|value<<3)
}
func (o *SCI9_Type) GetDCCR_DPER() uint8 {
	return (volatile.LoadUint8(&o.DCCR.Reg) & 0x8) >> 3
}
func (o *SCI9_Type) SetDCCR_DFER(value uint8) {
	volatile.StoreUint8(&o.DCCR.Reg, volatile.LoadUint8(&o.DCCR.Reg)&^(0x10)|value<<4)
}
func (o *SCI9_Type) GetDCCR_DFER() uint8 {
	return (volatile.LoadUint8(&o.DCCR.Reg) & 0x10) >> 4
}
func (o *SCI9_Type) SetDCCR_IDSEL(value uint8) {
	volatile.StoreUint8(&o.DCCR.Reg, volatile.LoadUint8(&o.DCCR.Reg)&^(0x40)|value<<6)
}
func (o *SCI9_Type) GetDCCR_IDSEL() uint8 {
	return (volatile.LoadUint8(&o.DCCR.Reg) & 0x40) >> 6
}
func (o *SCI9_Type) SetDCCR_DCME(value uint8) {
	volatile.StoreUint8(&o.DCCR.Reg, volatile.LoadUint8(&o.DCCR.Reg)&^(0x80)|value<<7)
}
func (o *SCI9_Type) GetDCCR_DCME() uint8 {
	return (volatile.LoadUint8(&o.DCCR.Reg) & 0x80) >> 7
}

// SCI9.CDR: Compare Match Data Register
func (o *SCI9_Type) SetCDR_CMPD(value uint16) {
	volatile.StoreUint16(&o.CDR.Reg, volatile.LoadUint16(&o.CDR.Reg)&^(0x1ff)|value)
}
func (o *SCI9_Type) GetCDR_CMPD() uint16 {
	return volatile.LoadUint16(&o.CDR.Reg) & 0x1ff
}

// SCI9.SPTR: Serial Port Register
func (o *SCI9_Type) SetSPTR_RXDMON(value uint8) {
	volatile.StoreUint8(&o.SPTR.Reg, volatile.LoadUint8(&o.SPTR.Reg)&^(0x1)|value)
}
func (o *SCI9_Type) GetSPTR_RXDMON() uint8 {
	return volatile.LoadUint8(&o.SPTR.Reg) & 0x1
}
func (o *SCI9_Type) SetSPTR_SPB2DT(value uint8) {
	volatile.StoreUint8(&o.SPTR.Reg, volatile.LoadUint8(&o.SPTR.Reg)&^(0x2)|value<<1)
}
func (o *SCI9_Type) GetSPTR_SPB2DT() uint8 {
	return (volatile.LoadUint8(&o.SPTR.Reg) & 0x2) >> 1
}
func (o *SCI9_Type) SetSPTR_SPB2IO(value uint8) {
	volatile.StoreUint8(&o.SPTR.Reg, volatile.LoadUint8(&o.SPTR.Reg)&^(0x4)|value<<2)
}
func (o *SCI9_Type) GetSPTR_SPB2IO() uint8 {
	return (volatile.LoadUint8(&o.SPTR.Reg) & 0x4) >> 2
}

// Serial Peripheral Interface
type SPI0_Type struct {
	SPCR   volatile.Register8  // 0x0
	SSLP   volatile.Register8  // 0x1
	SPPCR  volatile.Register8  // 0x2
	SPSR   volatile.Register8  // 0x3
	SPDR   volatile.Register32 // 0x4
	_      [2]byte
	SPBR   volatile.Register8  // 0xA
	SPDCR  volatile.Register8  // 0xB
	SPCKD  volatile.Register8  // 0xC
	SSLND  volatile.Register8  // 0xD
	SPND   volatile.Register8  // 0xE
	SPCR2  volatile.Register8  // 0xF
	SPCMD0 volatile.Register16 // 0x10
}

// SPI0.SPCR: SPI Control Register
func (o *SPI0_Type) SetSPCR_SPMS(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSPCR_SPMS() uint8 {
	return volatile.LoadUint8(&o.SPCR.Reg) & 0x1
}
func (o *SPI0_Type) SetSPCR_TXMD(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSPCR_TXMD() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSPCR_MODFEN(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetSPCR_MODFEN() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetSPCR_MSTR(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetSPCR_MSTR() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetSPCR_SPEIE(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetSPCR_SPEIE() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetSPCR_SPTIE(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetSPCR_SPTIE() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x20) >> 5
}
func (o *SPI0_Type) SetSPCR_SPE(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x40)|value<<6)
}
func (o *SPI0_Type) GetSPCR_SPE() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x40) >> 6
}
func (o *SPI0_Type) SetSPCR_SPRIE(value uint8) {
	volatile.StoreUint8(&o.SPCR.Reg, volatile.LoadUint8(&o.SPCR.Reg)&^(0x80)|value<<7)
}
func (o *SPI0_Type) GetSPCR_SPRIE() uint8 {
	return (volatile.LoadUint8(&o.SPCR.Reg) & 0x80) >> 7
}

// SPI0.SSLP: SPI Slave Select Polarity Register
func (o *SPI0_Type) SetSSLP_SSL0P(value uint8) {
	volatile.StoreUint8(&o.SSLP.Reg, volatile.LoadUint8(&o.SSLP.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSSLP_SSL0P() uint8 {
	return volatile.LoadUint8(&o.SSLP.Reg) & 0x1
}

// SPI0.SPPCR: SPI Pin Control Register
func (o *SPI0_Type) SetSPPCR_SPLP(value uint8) {
	volatile.StoreUint8(&o.SPPCR.Reg, volatile.LoadUint8(&o.SPPCR.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSPPCR_SPLP() uint8 {
	return volatile.LoadUint8(&o.SPPCR.Reg) & 0x1
}
func (o *SPI0_Type) SetSPPCR_SPLP2(value uint8) {
	volatile.StoreUint8(&o.SPPCR.Reg, volatile.LoadUint8(&o.SPPCR.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSPPCR_SPLP2() uint8 {
	return (volatile.LoadUint8(&o.SPPCR.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSPPCR_MOIFV(value uint8) {
	volatile.StoreUint8(&o.SPPCR.Reg, volatile.LoadUint8(&o.SPPCR.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetSPPCR_MOIFV() uint8 {
	return (volatile.LoadUint8(&o.SPPCR.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetSPPCR_MOIFE(value uint8) {
	volatile.StoreUint8(&o.SPPCR.Reg, volatile.LoadUint8(&o.SPPCR.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetSPPCR_MOIFE() uint8 {
	return (volatile.LoadUint8(&o.SPPCR.Reg) & 0x20) >> 5
}

// SPI0.SPSR: SPI Status Register
func (o *SPI0_Type) SetSPSR_OVRF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSPSR_OVRF() uint8 {
	return volatile.LoadUint8(&o.SPSR.Reg) & 0x1
}
func (o *SPI0_Type) SetSPSR_IDLNF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSPSR_IDLNF() uint8 {
	return (volatile.LoadUint8(&o.SPSR.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSPSR_MODF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetSPSR_MODF() uint8 {
	return (volatile.LoadUint8(&o.SPSR.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetSPSR_PERF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetSPSR_PERF() uint8 {
	return (volatile.LoadUint8(&o.SPSR.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetSPSR_UDRF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetSPSR_UDRF() uint8 {
	return (volatile.LoadUint8(&o.SPSR.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetSPSR_SPTEF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetSPSR_SPTEF() uint8 {
	return (volatile.LoadUint8(&o.SPSR.Reg) & 0x20) >> 5
}
func (o *SPI0_Type) SetSPSR_SPRF(value uint8) {
	volatile.StoreUint8(&o.SPSR.Reg, volatile.LoadUint8(&o.SPSR.Reg)&^(0x80)|value<<7)
}
func (o *SPI0_Type) GetSPSR_SPRF() uint8 {
	return (volatile.LoadUint8(&o.SPSR.Reg) & 0x80) >> 7
}

// SPI0.SPDCR: SPI Data Control Register
func (o *SPI0_Type) SetSPDCR_SPRDTD(value uint8) {
	volatile.StoreUint8(&o.SPDCR.Reg, volatile.LoadUint8(&o.SPDCR.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetSPDCR_SPRDTD() uint8 {
	return (volatile.LoadUint8(&o.SPDCR.Reg) & 0x10) >> 4
}
func (o *SPI0_Type) SetSPDCR_SPLW(value uint8) {
	volatile.StoreUint8(&o.SPDCR.Reg, volatile.LoadUint8(&o.SPDCR.Reg)&^(0x20)|value<<5)
}
func (o *SPI0_Type) GetSPDCR_SPLW() uint8 {
	return (volatile.LoadUint8(&o.SPDCR.Reg) & 0x20) >> 5
}
func (o *SPI0_Type) SetSPDCR_SPBYT(value uint8) {
	volatile.StoreUint8(&o.SPDCR.Reg, volatile.LoadUint8(&o.SPDCR.Reg)&^(0x40)|value<<6)
}
func (o *SPI0_Type) GetSPDCR_SPBYT() uint8 {
	return (volatile.LoadUint8(&o.SPDCR.Reg) & 0x40) >> 6
}

// SPI0.SPCKD: SPI Clock Delay Register
func (o *SPI0_Type) SetSPCKD_SCKDL(value uint8) {
	volatile.StoreUint8(&o.SPCKD.Reg, volatile.LoadUint8(&o.SPCKD.Reg)&^(0x7)|value)
}
func (o *SPI0_Type) GetSPCKD_SCKDL() uint8 {
	return volatile.LoadUint8(&o.SPCKD.Reg) & 0x7
}

// SPI0.SSLND: SPI Slave Select Negation Delay Register
func (o *SPI0_Type) SetSSLND_SLNDL(value uint8) {
	volatile.StoreUint8(&o.SSLND.Reg, volatile.LoadUint8(&o.SSLND.Reg)&^(0x7)|value)
}
func (o *SPI0_Type) GetSSLND_SLNDL() uint8 {
	return volatile.LoadUint8(&o.SSLND.Reg) & 0x7
}

// SPI0.SPND: SPI Next-Access Delay Register
func (o *SPI0_Type) SetSPND_SPNDL(value uint8) {
	volatile.StoreUint8(&o.SPND.Reg, volatile.LoadUint8(&o.SPND.Reg)&^(0x7)|value)
}
func (o *SPI0_Type) GetSPND_SPNDL() uint8 {
	return volatile.LoadUint8(&o.SPND.Reg) & 0x7
}

// SPI0.SPCR2: SPI Control Register 2
func (o *SPI0_Type) SetSPCR2_SPPE(value uint8) {
	volatile.StoreUint8(&o.SPCR2.Reg, volatile.LoadUint8(&o.SPCR2.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSPCR2_SPPE() uint8 {
	return volatile.LoadUint8(&o.SPCR2.Reg) & 0x1
}
func (o *SPI0_Type) SetSPCR2_SPOE(value uint8) {
	volatile.StoreUint8(&o.SPCR2.Reg, volatile.LoadUint8(&o.SPCR2.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSPCR2_SPOE() uint8 {
	return (volatile.LoadUint8(&o.SPCR2.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSPCR2_SPIIE(value uint8) {
	volatile.StoreUint8(&o.SPCR2.Reg, volatile.LoadUint8(&o.SPCR2.Reg)&^(0x4)|value<<2)
}
func (o *SPI0_Type) GetSPCR2_SPIIE() uint8 {
	return (volatile.LoadUint8(&o.SPCR2.Reg) & 0x4) >> 2
}
func (o *SPI0_Type) SetSPCR2_PTE(value uint8) {
	volatile.StoreUint8(&o.SPCR2.Reg, volatile.LoadUint8(&o.SPCR2.Reg)&^(0x8)|value<<3)
}
func (o *SPI0_Type) GetSPCR2_PTE() uint8 {
	return (volatile.LoadUint8(&o.SPCR2.Reg) & 0x8) >> 3
}
func (o *SPI0_Type) SetSPCR2_SCKASE(value uint8) {
	volatile.StoreUint8(&o.SPCR2.Reg, volatile.LoadUint8(&o.SPCR2.Reg)&^(0x10)|value<<4)
}
func (o *SPI0_Type) GetSPCR2_SCKASE() uint8 {
	return (volatile.LoadUint8(&o.SPCR2.Reg) & 0x10) >> 4
}

// SPI0.SPCMD0: SPI Command Register 0
func (o *SPI0_Type) SetSPCMD0_CPHA(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0x1)|value)
}
func (o *SPI0_Type) GetSPCMD0_CPHA() uint16 {
	return volatile.LoadUint16(&o.SPCMD0.Reg) & 0x1
}
func (o *SPI0_Type) SetSPCMD0_CPOL(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0x2)|value<<1)
}
func (o *SPI0_Type) GetSPCMD0_CPOL() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0x2) >> 1
}
func (o *SPI0_Type) SetSPCMD0_BRDV(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0xc)|value<<2)
}
func (o *SPI0_Type) GetSPCMD0_BRDV() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0xc) >> 2
}
func (o *SPI0_Type) SetSPCMD0_SPB(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0xf00)|value<<8)
}
func (o *SPI0_Type) GetSPCMD0_SPB() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0xf00) >> 8
}
func (o *SPI0_Type) SetSPCMD0_LSBF(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0x1000)|value<<12)
}
func (o *SPI0_Type) GetSPCMD0_LSBF() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0x1000) >> 12
}
func (o *SPI0_Type) SetSPCMD0_SPNDEN(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0x2000)|value<<13)
}
func (o *SPI0_Type) GetSPCMD0_SPNDEN() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0x2000) >> 13
}
func (o *SPI0_Type) SetSPCMD0_SLNDEN(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0x4000)|value<<14)
}
func (o *SPI0_Type) GetSPCMD0_SLNDEN() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0x4000) >> 14
}
func (o *SPI0_Type) SetSPCMD0_SCKDEN(value uint16) {
	volatile.StoreUint16(&o.SPCMD0.Reg, volatile.LoadUint16(&o.SPCMD0.Reg)&^(0x8000)|value<<15)
}
func (o *SPI0_Type) GetSPCMD0_SCKDEN() uint16 {
	return (volatile.LoadUint16(&o.SPCMD0.Reg) & 0x8000) >> 15
}

// Cyclic Redundancy Check Calculator
type CRC_Type struct {
	CRCCR0 volatile.Register8 // 0x0
	CRCCR1 volatile.Register8 // 0x1
	_      [2]byte
	CRCDIR volatile.Register32 // 0x4
	CRCDOR volatile.Register32 // 0x8
	CRCSAR volatile.Register16 // 0xC
}

// CRC.CRCCR0: CRC Control Register 0
func (o *CRC_Type) SetCRCCR0_GPS(value uint8) {
	volatile.StoreUint8(&o.CRCCR0.Reg, volatile.LoadUint8(&o.CRCCR0.Reg)&^(0x7)|value)
}
func (o *CRC_Type) GetCRCCR0_GPS() uint8 {
	return volatile.LoadUint8(&o.CRCCR0.Reg) & 0x7
}
func (o *CRC_Type) SetCRCCR0_LMS(value uint8) {
	volatile.StoreUint8(&o.CRCCR0.Reg, volatile.LoadUint8(&o.CRCCR0.Reg)&^(0x40)|value<<6)
}
func (o *CRC_Type) GetCRCCR0_LMS() uint8 {
	return (volatile.LoadUint8(&o.CRCCR0.Reg) & 0x40) >> 6
}
func (o *CRC_Type) SetCRCCR0_DORCLR(value uint8) {
	volatile.StoreUint8(&o.CRCCR0.Reg, volatile.LoadUint8(&o.CRCCR0.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCRCCR0_DORCLR() uint8 {
	return (volatile.LoadUint8(&o.CRCCR0.Reg) & 0x80) >> 7
}

// CRC.CRCCR1: CRC Control Register 1
func (o *CRC_Type) SetCRCCR1_CRCSWR(value uint8) {
	volatile.StoreUint8(&o.CRCCR1.Reg, volatile.LoadUint8(&o.CRCCR1.Reg)&^(0x40)|value<<6)
}
func (o *CRC_Type) GetCRCCR1_CRCSWR() uint8 {
	return (volatile.LoadUint8(&o.CRCCR1.Reg) & 0x40) >> 6
}
func (o *CRC_Type) SetCRCCR1_CRCSEN(value uint8) {
	volatile.StoreUint8(&o.CRCCR1.Reg, volatile.LoadUint8(&o.CRCCR1.Reg)&^(0x80)|value<<7)
}
func (o *CRC_Type) GetCRCCR1_CRCSEN() uint8 {
	return (volatile.LoadUint8(&o.CRCCR1.Reg) & 0x80) >> 7
}

// CRC.CRCSAR: Snoop Address Register
func (o *CRC_Type) SetCRCSAR_CRCSA(value uint16) {
	volatile.StoreUint16(&o.CRCSAR.Reg, volatile.LoadUint16(&o.CRCSAR.Reg)&^(0x3fff)|value)
}
func (o *CRC_Type) GetCRCSAR_CRCSA() uint16 {
	return volatile.LoadUint16(&o.CRCSAR.Reg) & 0x3fff
}

// General PWM 16-bit Timer 4
type GPT164_Type struct {
	GTWP     volatile.Register32 // 0x0
	GTSTR    volatile.Register32 // 0x4
	GTSTP    volatile.Register32 // 0x8
	GTCLR    volatile.Register32 // 0xC
	GTSSR    volatile.Register32 // 0x10
	GTPSR    volatile.Register32 // 0x14
	GTCSR    volatile.Register32 // 0x18
	GTUPSR   volatile.Register32 // 0x1C
	GTDNSR   volatile.Register32 // 0x20
	GTICASR  volatile.Register32 // 0x24
	GTICBSR  volatile.Register32 // 0x28
	GTCR     volatile.Register32 // 0x2C
	GTUDDTYC volatile.Register32 // 0x30
	GTIOR    volatile.Register32 // 0x34
	GTINTAD  volatile.Register32 // 0x38
	GTST     volatile.Register32 // 0x3C
	GTBER    volatile.Register32 // 0x40
	_        [4]byte
	GTCNT    volatile.Register32 // 0x48
	GTCCRA   volatile.Register32 // 0x4C
	GTCCRB   volatile.Register32 // 0x50
	GTCCRC   volatile.Register32 // 0x54
	GTCCRE   volatile.Register32 // 0x58
	GTCCRD   volatile.Register32 // 0x5C
	GTCCRF   volatile.Register32 // 0x60
	GTPR     volatile.Register32 // 0x64
	GTPBR    volatile.Register32 // 0x68
	_        [28]byte
	GTDTCR   volatile.Register32 // 0x88
	GTDVU    volatile.Register32 // 0x8C
}

// GPT164.GTWP: General PWM Timer Write-Protection Register
func (o *GPT164_Type) SetGTWP_WP(value uint32) {
	volatile.StoreUint32(&o.GTWP.Reg, volatile.LoadUint32(&o.GTWP.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTWP_WP() uint32 {
	return volatile.LoadUint32(&o.GTWP.Reg) & 0x1
}
func (o *GPT164_Type) SetGTWP_PRKEY(value uint32) {
	volatile.StoreUint32(&o.GTWP.Reg, volatile.LoadUint32(&o.GTWP.Reg)&^(0xff00)|value<<8)
}
func (o *GPT164_Type) GetGTWP_PRKEY() uint32 {
	return (volatile.LoadUint32(&o.GTWP.Reg) & 0xff00) >> 8
}

// GPT164.GTSTR: General PWM Timer Software Start Register
func (o *GPT164_Type) SetGTSTR_CSTRT0(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTSTR_CSTRT0() uint32 {
	return volatile.LoadUint32(&o.GTSTR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTSTR_CSTRT1(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTSTR_CSTRT1() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTSTR_CSTRT2(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTSTR_CSTRT2() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTSTR_CSTRT3(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTSTR_CSTRT3() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTSTR_CSTRT4(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x10)|value<<4)
}
func (o *GPT164_Type) GetGTSTR_CSTRT4() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x10) >> 4
}
func (o *GPT164_Type) SetGTSTR_CSTRT5(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x20)|value<<5)
}
func (o *GPT164_Type) GetGTSTR_CSTRT5() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x20) >> 5
}
func (o *GPT164_Type) SetGTSTR_CSTRT6(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x40)|value<<6)
}
func (o *GPT164_Type) GetGTSTR_CSTRT6() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x40) >> 6
}
func (o *GPT164_Type) SetGTSTR_CSTRT7(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x80)|value<<7)
}
func (o *GPT164_Type) GetGTSTR_CSTRT7() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x80) >> 7
}
func (o *GPT164_Type) SetGTSTR_CSTRT8(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTSTR_CSTRT8() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTSTR_CSTRT9(value uint32) {
	volatile.StoreUint32(&o.GTSTR.Reg, volatile.LoadUint32(&o.GTSTR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTSTR_CSTRT9() uint32 {
	return (volatile.LoadUint32(&o.GTSTR.Reg) & 0x200) >> 9
}

// GPT164.GTSTP: General PWM Timer Software Stop Register
func (o *GPT164_Type) SetGTSTP_CSTOP0(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTSTP_CSTOP0() uint32 {
	return volatile.LoadUint32(&o.GTSTP.Reg) & 0x1
}
func (o *GPT164_Type) SetGTSTP_CSTOP1(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTSTP_CSTOP1() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTSTP_CSTOP2(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTSTP_CSTOP2() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTSTP_CSTOP3(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTSTP_CSTOP3() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTSTP_CSTOP4(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x10)|value<<4)
}
func (o *GPT164_Type) GetGTSTP_CSTOP4() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x10) >> 4
}
func (o *GPT164_Type) SetGTSTP_CSTOP5(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x20)|value<<5)
}
func (o *GPT164_Type) GetGTSTP_CSTOP5() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x20) >> 5
}
func (o *GPT164_Type) SetGTSTP_CSTOP6(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x40)|value<<6)
}
func (o *GPT164_Type) GetGTSTP_CSTOP6() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x40) >> 6
}
func (o *GPT164_Type) SetGTSTP_CSTOP7(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x80)|value<<7)
}
func (o *GPT164_Type) GetGTSTP_CSTOP7() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x80) >> 7
}
func (o *GPT164_Type) SetGTSTP_CSTOP8(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTSTP_CSTOP8() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTSTP_CSTOP9(value uint32) {
	volatile.StoreUint32(&o.GTSTP.Reg, volatile.LoadUint32(&o.GTSTP.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTSTP_CSTOP9() uint32 {
	return (volatile.LoadUint32(&o.GTSTP.Reg) & 0x200) >> 9
}

// GPT164.GTCLR: General PWM Timer Software Clear Register
func (o *GPT164_Type) SetGTCLR_CCLR0(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTCLR_CCLR0() uint32 {
	return volatile.LoadUint32(&o.GTCLR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTCLR_CCLR1(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTCLR_CCLR1() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTCLR_CCLR2(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTCLR_CCLR2() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTCLR_CCLR3(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTCLR_CCLR3() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTCLR_CCLR4(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x10)|value<<4)
}
func (o *GPT164_Type) GetGTCLR_CCLR4() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x10) >> 4
}
func (o *GPT164_Type) SetGTCLR_CCLR5(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x20)|value<<5)
}
func (o *GPT164_Type) GetGTCLR_CCLR5() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x20) >> 5
}
func (o *GPT164_Type) SetGTCLR_CCLR6(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x40)|value<<6)
}
func (o *GPT164_Type) GetGTCLR_CCLR6() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x40) >> 6
}
func (o *GPT164_Type) SetGTCLR_CCLR7(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x80)|value<<7)
}
func (o *GPT164_Type) GetGTCLR_CCLR7() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x80) >> 7
}
func (o *GPT164_Type) SetGTCLR_CCLR8(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTCLR_CCLR8() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTCLR_CCLR9(value uint32) {
	volatile.StoreUint32(&o.GTCLR.Reg, volatile.LoadUint32(&o.GTCLR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTCLR_CCLR9() uint32 {
	return (volatile.LoadUint32(&o.GTCLR.Reg) & 0x200) >> 9
}

// GPT164.GTSSR: General PWM Timer Start Source Select Register
func (o *GPT164_Type) SetGTSSR_SSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTSSR_SSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTSSR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTSSR_SSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTSSR_SSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTSSR_SSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTSSR_SSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTSSR_SSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTSSR_SSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTSSR_SSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTSSR_SSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTSSR_SSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTSSR_SSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTSSR_SSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTSSR_SSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTSSR_SSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTSSR_SSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTSSR_SSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTSSR_SSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTSSR_SSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTSSR_SSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTSSR_SSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTSSR_SSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTSSR_SSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTSSR_SSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTSSR_SSELCA(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTSSR_SSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTSSR_SSELCB(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTSSR_SSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTSSR_SSELCC(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTSSR_SSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTSSR_SSELCD(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTSSR_SSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x80000) >> 19
}
func (o *GPT164_Type) SetGTSSR_CSTRT(value uint32) {
	volatile.StoreUint32(&o.GTSSR.Reg, volatile.LoadUint32(&o.GTSSR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPT164_Type) GetGTSSR_CSTRT() uint32 {
	return (volatile.LoadUint32(&o.GTSSR.Reg) & 0x80000000) >> 31
}

// GPT164.GTPSR: General PWM Timer Stop Source Select Register
func (o *GPT164_Type) SetGTPSR_PSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTPSR_PSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTPSR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTPSR_PSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTPSR_PSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTPSR_PSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTPSR_PSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTPSR_PSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTPSR_PSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTPSR_PSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTPSR_PSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTPSR_PSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTPSR_PSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTPSR_PSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTPSR_PSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTPSR_PSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTPSR_PSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTPSR_PSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTPSR_PSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTPSR_PSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTPSR_PSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTPSR_PSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTPSR_PSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTPSR_PSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTPSR_PSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTPSR_PSELCA(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTPSR_PSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTPSR_PSELCB(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTPSR_PSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTPSR_PSELCC(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTPSR_PSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTPSR_PSELCD(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTPSR_PSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x80000) >> 19
}
func (o *GPT164_Type) SetGTPSR_CSTOP(value uint32) {
	volatile.StoreUint32(&o.GTPSR.Reg, volatile.LoadUint32(&o.GTPSR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPT164_Type) GetGTPSR_CSTOP() uint32 {
	return (volatile.LoadUint32(&o.GTPSR.Reg) & 0x80000000) >> 31
}

// GPT164.GTCSR: General PWM Timer Clear Source Select Register
func (o *GPT164_Type) SetGTCSR_CSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTCSR_CSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTCSR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTCSR_CSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTCSR_CSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTCSR_CSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTCSR_CSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTCSR_CSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTCSR_CSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTCSR_CSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTCSR_CSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTCSR_CSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTCSR_CSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTCSR_CSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTCSR_CSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTCSR_CSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTCSR_CSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTCSR_CSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTCSR_CSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTCSR_CSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTCSR_CSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTCSR_CSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTCSR_CSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTCSR_CSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTCSR_CSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTCSR_CSELCA(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTCSR_CSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTCSR_CSELCB(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTCSR_CSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTCSR_CSELCC(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTCSR_CSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTCSR_CSELCD(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTCSR_CSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x80000) >> 19
}
func (o *GPT164_Type) SetGTCSR_CCLR(value uint32) {
	volatile.StoreUint32(&o.GTCSR.Reg, volatile.LoadUint32(&o.GTCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *GPT164_Type) GetGTCSR_CCLR() uint32 {
	return (volatile.LoadUint32(&o.GTCSR.Reg) & 0x80000000) >> 31
}

// GPT164.GTUPSR: General PWM Timer Up Count Source Select Register
func (o *GPT164_Type) SetGTUPSR_USGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTUPSR_USGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTUPSR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTUPSR_USGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTUPSR_USGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTUPSR_USGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTUPSR_USGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTUPSR_USGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTUPSR_USGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTUPSR_USCARBL(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTUPSR_USCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTUPSR_USCARBH(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTUPSR_USCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTUPSR_USCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTUPSR_USCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTUPSR_USCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTUPSR_USCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTUPSR_USCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTUPSR_USCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTUPSR_USCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTUPSR_USCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTUPSR_USCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTUPSR_USCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTUPSR_USCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTUPSR_USCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTUPSR_USELCA(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTUPSR_USELCA() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTUPSR_USELCB(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTUPSR_USELCB() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTUPSR_USELCC(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTUPSR_USELCC() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTUPSR_USELCD(value uint32) {
	volatile.StoreUint32(&o.GTUPSR.Reg, volatile.LoadUint32(&o.GTUPSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTUPSR_USELCD() uint32 {
	return (volatile.LoadUint32(&o.GTUPSR.Reg) & 0x80000) >> 19
}

// GPT164.GTDNSR: General PWM Timer Down Count Source Select Register
func (o *GPT164_Type) SetGTDNSR_DSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTDNSR_DSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTDNSR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTDNSR_DSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTDNSR_DSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTDNSR_DSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTDNSR_DSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTDNSR_DSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTDNSR_DSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTDNSR_DSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTDNSR_DSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTDNSR_DSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTDNSR_DSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTDNSR_DSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTDNSR_DSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTDNSR_DSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTDNSR_DSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTDNSR_DSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTDNSR_DSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTDNSR_DSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTDNSR_DSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTDNSR_DSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTDNSR_DSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTDNSR_DSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTDNSR_DSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTDNSR_DSELCA(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTDNSR_DSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTDNSR_DSELCB(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTDNSR_DSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTDNSR_DSELCC(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTDNSR_DSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTDNSR_DSELCD(value uint32) {
	volatile.StoreUint32(&o.GTDNSR.Reg, volatile.LoadUint32(&o.GTDNSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTDNSR_DSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTDNSR.Reg) & 0x80000) >> 19
}

// GPT164.GTICASR: General PWM Timer Input Capture Source Select Register A
func (o *GPT164_Type) SetGTICASR_ASGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTICASR_ASGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTICASR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTICASR_ASGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTICASR_ASGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTICASR_ASGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTICASR_ASGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTICASR_ASGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTICASR_ASGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTICASR_ASCARBL(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTICASR_ASCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTICASR_ASCARBH(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTICASR_ASCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTICASR_ASCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTICASR_ASCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTICASR_ASCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTICASR_ASCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTICASR_ASCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTICASR_ASCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTICASR_ASCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTICASR_ASCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTICASR_ASCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTICASR_ASCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTICASR_ASCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTICASR_ASCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTICASR_ASELCA(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTICASR_ASELCA() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTICASR_ASELCB(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTICASR_ASELCB() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTICASR_ASELCC(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTICASR_ASELCC() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTICASR_ASELCD(value uint32) {
	volatile.StoreUint32(&o.GTICASR.Reg, volatile.LoadUint32(&o.GTICASR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTICASR_ASELCD() uint32 {
	return (volatile.LoadUint32(&o.GTICASR.Reg) & 0x80000) >> 19
}

// GPT164.GTICBSR: General PWM Timer Input Capture Source Select Register B
func (o *GPT164_Type) SetGTICBSR_BSGTRGAR(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTICBSR_BSGTRGAR() uint32 {
	return volatile.LoadUint32(&o.GTICBSR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTICBSR_BSGTRGAF(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTICBSR_BSGTRGAF() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTICBSR_BSGTRGBR(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTICBSR_BSGTRGBR() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTICBSR_BSGTRGBF(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTICBSR_BSGTRGBF() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTICBSR_BSCARBL(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTICBSR_BSCARBL() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTICBSR_BSCARBH(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x200)|value<<9)
}
func (o *GPT164_Type) GetGTICBSR_BSCARBH() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x200) >> 9
}
func (o *GPT164_Type) SetGTICBSR_BSCAFBL(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x400)|value<<10)
}
func (o *GPT164_Type) GetGTICBSR_BSCAFBL() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x400) >> 10
}
func (o *GPT164_Type) SetGTICBSR_BSCAFBH(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x800)|value<<11)
}
func (o *GPT164_Type) GetGTICBSR_BSCAFBH() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x800) >> 11
}
func (o *GPT164_Type) SetGTICBSR_BSCBRAL(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x1000)|value<<12)
}
func (o *GPT164_Type) GetGTICBSR_BSCBRAL() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x1000) >> 12
}
func (o *GPT164_Type) SetGTICBSR_BSCBRAH(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTICBSR_BSCBRAH() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTICBSR_BSCBFAL(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x4000)|value<<14)
}
func (o *GPT164_Type) GetGTICBSR_BSCBFAL() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x4000) >> 14
}
func (o *GPT164_Type) SetGTICBSR_BSCBFAH(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTICBSR_BSCBFAH() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTICBSR_BSELCA(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT164_Type) GetGTICBSR_BSELCA() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x10000) >> 16
}
func (o *GPT164_Type) SetGTICBSR_BSELCB(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT164_Type) GetGTICBSR_BSELCB() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x20000) >> 17
}
func (o *GPT164_Type) SetGTICBSR_BSELCC(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTICBSR_BSELCC() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTICBSR_BSELCD(value uint32) {
	volatile.StoreUint32(&o.GTICBSR.Reg, volatile.LoadUint32(&o.GTICBSR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTICBSR_BSELCD() uint32 {
	return (volatile.LoadUint32(&o.GTICBSR.Reg) & 0x80000) >> 19
}

// GPT164.GTCR: General PWM Timer Control Register
func (o *GPT164_Type) SetGTCR_CST(value uint32) {
	volatile.StoreUint32(&o.GTCR.Reg, volatile.LoadUint32(&o.GTCR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTCR_CST() uint32 {
	return volatile.LoadUint32(&o.GTCR.Reg) & 0x1
}
func (o *GPT164_Type) SetGTCR_MD(value uint32) {
	volatile.StoreUint32(&o.GTCR.Reg, volatile.LoadUint32(&o.GTCR.Reg)&^(0x70000)|value<<16)
}
func (o *GPT164_Type) GetGTCR_MD() uint32 {
	return (volatile.LoadUint32(&o.GTCR.Reg) & 0x70000) >> 16
}
func (o *GPT164_Type) SetGTCR_TPCS(value uint32) {
	volatile.StoreUint32(&o.GTCR.Reg, volatile.LoadUint32(&o.GTCR.Reg)&^(0x7000000)|value<<24)
}
func (o *GPT164_Type) GetGTCR_TPCS() uint32 {
	return (volatile.LoadUint32(&o.GTCR.Reg) & 0x7000000) >> 24
}

// GPT164.GTUDDTYC: General PWM Timer Count Direction and Duty Setting Register
func (o *GPT164_Type) SetGTUDDTYC_UD(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTUDDTYC_UD() uint32 {
	return volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x1
}
func (o *GPT164_Type) SetGTUDDTYC_UDF(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTUDDTYC_UDF() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTUDDTYC_OADTY(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x30000)|value<<16)
}
func (o *GPT164_Type) GetGTUDDTYC_OADTY() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x30000) >> 16
}
func (o *GPT164_Type) SetGTUDDTYC_OADTYF(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x40000)|value<<18)
}
func (o *GPT164_Type) GetGTUDDTYC_OADTYF() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x40000) >> 18
}
func (o *GPT164_Type) SetGTUDDTYC_OADTYR(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x80000)|value<<19)
}
func (o *GPT164_Type) GetGTUDDTYC_OADTYR() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x80000) >> 19
}
func (o *GPT164_Type) SetGTUDDTYC_OBDTY(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x3000000)|value<<24)
}
func (o *GPT164_Type) GetGTUDDTYC_OBDTY() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x3000000) >> 24
}
func (o *GPT164_Type) SetGTUDDTYC_OBDTYF(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x4000000)|value<<26)
}
func (o *GPT164_Type) GetGTUDDTYC_OBDTYF() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x4000000) >> 26
}
func (o *GPT164_Type) SetGTUDDTYC_OBDTYR(value uint32) {
	volatile.StoreUint32(&o.GTUDDTYC.Reg, volatile.LoadUint32(&o.GTUDDTYC.Reg)&^(0x8000000)|value<<27)
}
func (o *GPT164_Type) GetGTUDDTYC_OBDTYR() uint32 {
	return (volatile.LoadUint32(&o.GTUDDTYC.Reg) & 0x8000000) >> 27
}

// GPT164.GTIOR: General PWM Timer I/O Control Register
func (o *GPT164_Type) SetGTIOR_GTIOA(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x1f)|value)
}
func (o *GPT164_Type) GetGTIOR_GTIOA() uint32 {
	return volatile.LoadUint32(&o.GTIOR.Reg) & 0x1f
}
func (o *GPT164_Type) SetGTIOR_OADFLT(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x40)|value<<6)
}
func (o *GPT164_Type) GetGTIOR_OADFLT() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x40) >> 6
}
func (o *GPT164_Type) SetGTIOR_OAHLD(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x80)|value<<7)
}
func (o *GPT164_Type) GetGTIOR_OAHLD() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x80) >> 7
}
func (o *GPT164_Type) SetGTIOR_OAE(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x100)|value<<8)
}
func (o *GPT164_Type) GetGTIOR_OAE() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x100) >> 8
}
func (o *GPT164_Type) SetGTIOR_OADF(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x600)|value<<9)
}
func (o *GPT164_Type) GetGTIOR_OADF() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x600) >> 9
}
func (o *GPT164_Type) SetGTIOR_NFAEN(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x2000)|value<<13)
}
func (o *GPT164_Type) GetGTIOR_NFAEN() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x2000) >> 13
}
func (o *GPT164_Type) SetGTIOR_NFCSA(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0xc000)|value<<14)
}
func (o *GPT164_Type) GetGTIOR_NFCSA() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0xc000) >> 14
}
func (o *GPT164_Type) SetGTIOR_GTIOB(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x1f0000)|value<<16)
}
func (o *GPT164_Type) GetGTIOR_GTIOB() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x1f0000) >> 16
}
func (o *GPT164_Type) SetGTIOR_OBDFLT(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x400000)|value<<22)
}
func (o *GPT164_Type) GetGTIOR_OBDFLT() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x400000) >> 22
}
func (o *GPT164_Type) SetGTIOR_OBHLD(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x800000)|value<<23)
}
func (o *GPT164_Type) GetGTIOR_OBHLD() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x800000) >> 23
}
func (o *GPT164_Type) SetGTIOR_OBE(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x1000000)|value<<24)
}
func (o *GPT164_Type) GetGTIOR_OBE() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x1000000) >> 24
}
func (o *GPT164_Type) SetGTIOR_OBDF(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x6000000)|value<<25)
}
func (o *GPT164_Type) GetGTIOR_OBDF() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x6000000) >> 25
}
func (o *GPT164_Type) SetGTIOR_NFBEN(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPT164_Type) GetGTIOR_NFBEN() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0x20000000) >> 29
}
func (o *GPT164_Type) SetGTIOR_NFCSB(value uint32) {
	volatile.StoreUint32(&o.GTIOR.Reg, volatile.LoadUint32(&o.GTIOR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPT164_Type) GetGTIOR_NFCSB() uint32 {
	return (volatile.LoadUint32(&o.GTIOR.Reg) & 0xc0000000) >> 30
}

// GPT164.GTINTAD: General PWM Timer Interrupt Output Setting Register
func (o *GPT164_Type) SetGTINTAD_GRP(value uint32) {
	volatile.StoreUint32(&o.GTINTAD.Reg, volatile.LoadUint32(&o.GTINTAD.Reg)&^(0x3000000)|value<<24)
}
func (o *GPT164_Type) GetGTINTAD_GRP() uint32 {
	return (volatile.LoadUint32(&o.GTINTAD.Reg) & 0x3000000) >> 24
}
func (o *GPT164_Type) SetGTINTAD_GRPABH(value uint32) {
	volatile.StoreUint32(&o.GTINTAD.Reg, volatile.LoadUint32(&o.GTINTAD.Reg)&^(0x20000000)|value<<29)
}
func (o *GPT164_Type) GetGTINTAD_GRPABH() uint32 {
	return (volatile.LoadUint32(&o.GTINTAD.Reg) & 0x20000000) >> 29
}
func (o *GPT164_Type) SetGTINTAD_GRPABL(value uint32) {
	volatile.StoreUint32(&o.GTINTAD.Reg, volatile.LoadUint32(&o.GTINTAD.Reg)&^(0x40000000)|value<<30)
}
func (o *GPT164_Type) GetGTINTAD_GRPABL() uint32 {
	return (volatile.LoadUint32(&o.GTINTAD.Reg) & 0x40000000) >> 30
}

// GPT164.GTST: General PWM Timer Status Register
func (o *GPT164_Type) SetGTST_TCFA(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTST_TCFA() uint32 {
	return volatile.LoadUint32(&o.GTST.Reg) & 0x1
}
func (o *GPT164_Type) SetGTST_TCFB(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTST_TCFB() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTST_TCFC(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x4)|value<<2)
}
func (o *GPT164_Type) GetGTST_TCFC() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x4) >> 2
}
func (o *GPT164_Type) SetGTST_TCFD(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x8)|value<<3)
}
func (o *GPT164_Type) GetGTST_TCFD() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x8) >> 3
}
func (o *GPT164_Type) SetGTST_TCFE(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x10)|value<<4)
}
func (o *GPT164_Type) GetGTST_TCFE() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x10) >> 4
}
func (o *GPT164_Type) SetGTST_TCFF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x20)|value<<5)
}
func (o *GPT164_Type) GetGTST_TCFF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x20) >> 5
}
func (o *GPT164_Type) SetGTST_TCFPO(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x40)|value<<6)
}
func (o *GPT164_Type) GetGTST_TCFPO() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x40) >> 6
}
func (o *GPT164_Type) SetGTST_TCFPU(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x80)|value<<7)
}
func (o *GPT164_Type) GetGTST_TCFPU() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x80) >> 7
}
func (o *GPT164_Type) SetGTST_TUCF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x8000)|value<<15)
}
func (o *GPT164_Type) GetGTST_TUCF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x8000) >> 15
}
func (o *GPT164_Type) SetGTST_ODF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x1000000)|value<<24)
}
func (o *GPT164_Type) GetGTST_ODF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x1000000) >> 24
}
func (o *GPT164_Type) SetGTST_OABHF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x20000000)|value<<29)
}
func (o *GPT164_Type) GetGTST_OABHF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x20000000) >> 29
}
func (o *GPT164_Type) SetGTST_OABLF(value uint32) {
	volatile.StoreUint32(&o.GTST.Reg, volatile.LoadUint32(&o.GTST.Reg)&^(0x40000000)|value<<30)
}
func (o *GPT164_Type) GetGTST_OABLF() uint32 {
	return (volatile.LoadUint32(&o.GTST.Reg) & 0x40000000) >> 30
}

// GPT164.GTBER: General PWM Timer Buffer Enable Register
func (o *GPT164_Type) SetGTBER_BD0(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTBER_BD0() uint32 {
	return volatile.LoadUint32(&o.GTBER.Reg) & 0x1
}
func (o *GPT164_Type) SetGTBER_BD1(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x2)|value<<1)
}
func (o *GPT164_Type) GetGTBER_BD1() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0x2) >> 1
}
func (o *GPT164_Type) SetGTBER_CCRA(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x30000)|value<<16)
}
func (o *GPT164_Type) GetGTBER_CCRA() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0x30000) >> 16
}
func (o *GPT164_Type) SetGTBER_CCRB(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0xc0000)|value<<18)
}
func (o *GPT164_Type) GetGTBER_CCRB() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0xc0000) >> 18
}
func (o *GPT164_Type) SetGTBER_PR(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x300000)|value<<20)
}
func (o *GPT164_Type) GetGTBER_PR() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0x300000) >> 20
}
func (o *GPT164_Type) SetGTBER_CCRSWT(value uint32) {
	volatile.StoreUint32(&o.GTBER.Reg, volatile.LoadUint32(&o.GTBER.Reg)&^(0x400000)|value<<22)
}
func (o *GPT164_Type) GetGTBER_CCRSWT() uint32 {
	return (volatile.LoadUint32(&o.GTBER.Reg) & 0x400000) >> 22
}

// GPT164.GTDTCR: General PWM Timer Dead Time Control Register
func (o *GPT164_Type) SetGTDTCR_TDE(value uint32) {
	volatile.StoreUint32(&o.GTDTCR.Reg, volatile.LoadUint32(&o.GTDTCR.Reg)&^(0x1)|value)
}
func (o *GPT164_Type) GetGTDTCR_TDE() uint32 {
	return volatile.LoadUint32(&o.GTDTCR.Reg) & 0x1
}

// Output Phase Switching Controller
type GPT_OPS_Type struct {
	OPSCR volatile.Register32 // 0x0
}

// GPT_OPS.OPSCR: Output Phase Switching Control Register
func (o *GPT_OPS_Type) SetOPSCR_UF(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x1)|value)
}
func (o *GPT_OPS_Type) GetOPSCR_UF() uint32 {
	return volatile.LoadUint32(&o.OPSCR.Reg) & 0x1
}
func (o *GPT_OPS_Type) SetOPSCR_VF(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x2)|value<<1)
}
func (o *GPT_OPS_Type) GetOPSCR_VF() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x2) >> 1
}
func (o *GPT_OPS_Type) SetOPSCR_WF(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x4)|value<<2)
}
func (o *GPT_OPS_Type) GetOPSCR_WF() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x4) >> 2
}
func (o *GPT_OPS_Type) SetOPSCR_EN(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x100)|value<<8)
}
func (o *GPT_OPS_Type) GetOPSCR_EN() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x100) >> 8
}
func (o *GPT_OPS_Type) SetOPSCR_FB(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x10000)|value<<16)
}
func (o *GPT_OPS_Type) GetOPSCR_FB() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x10000) >> 16
}
func (o *GPT_OPS_Type) SetOPSCR_P(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x20000)|value<<17)
}
func (o *GPT_OPS_Type) GetOPSCR_P() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x20000) >> 17
}
func (o *GPT_OPS_Type) SetOPSCR_N(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x40000)|value<<18)
}
func (o *GPT_OPS_Type) GetOPSCR_N() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x40000) >> 18
}
func (o *GPT_OPS_Type) SetOPSCR_INV(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x80000)|value<<19)
}
func (o *GPT_OPS_Type) GetOPSCR_INV() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x80000) >> 19
}
func (o *GPT_OPS_Type) SetOPSCR_RV(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x100000)|value<<20)
}
func (o *GPT_OPS_Type) GetOPSCR_RV() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x100000) >> 20
}
func (o *GPT_OPS_Type) SetOPSCR_ALIGN(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x200000)|value<<21)
}
func (o *GPT_OPS_Type) GetOPSCR_ALIGN() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x200000) >> 21
}
func (o *GPT_OPS_Type) SetOPSCR_GRP(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x3000000)|value<<24)
}
func (o *GPT_OPS_Type) GetOPSCR_GRP() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x3000000) >> 24
}
func (o *GPT_OPS_Type) SetOPSCR_GODF(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x4000000)|value<<26)
}
func (o *GPT_OPS_Type) GetOPSCR_GODF() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x4000000) >> 26
}
func (o *GPT_OPS_Type) SetOPSCR_NFEN(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0x20000000)|value<<29)
}
func (o *GPT_OPS_Type) GetOPSCR_NFEN() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0x20000000) >> 29
}
func (o *GPT_OPS_Type) SetOPSCR_NFCS(value uint32) {
	volatile.StoreUint32(&o.OPSCR.Reg, volatile.LoadUint32(&o.OPSCR.Reg)&^(0xc0000000)|value<<30)
}
func (o *GPT_OPS_Type) GetOPSCR_NFCS() uint32 {
	return (volatile.LoadUint32(&o.OPSCR.Reg) & 0xc0000000) >> 30
}

// Key Interrupt Function
type KINT_Type struct {
	KRCTL volatile.Register8 // 0x0
	_     [3]byte
	KRF   volatile.Register8 // 0x4
	_     [3]byte
	KRM   volatile.Register8 // 0x8
}

// KINT.KRCTL: Key Return Control Register
func (o *KINT_Type) SetKRCTL_KREG(value uint8) {
	volatile.StoreUint8(&o.KRCTL.Reg, volatile.LoadUint8(&o.KRCTL.Reg)&^(0x1)|value)
}
func (o *KINT_Type) GetKRCTL_KREG() uint8 {
	return volatile.LoadUint8(&o.KRCTL.Reg) & 0x1
}
func (o *KINT_Type) SetKRCTL_KRMD(value uint8) {
	volatile.StoreUint8(&o.KRCTL.Reg, volatile.LoadUint8(&o.KRCTL.Reg)&^(0x80)|value<<7)
}
func (o *KINT_Type) GetKRCTL_KRMD() uint8 {
	return (volatile.LoadUint8(&o.KRCTL.Reg) & 0x80) >> 7
}

// KINT.KRF: Key Return Flag Register
func (o *KINT_Type) SetKRF_KIF0(value uint8) {
	volatile.StoreUint8(&o.KRF.Reg, volatile.LoadUint8(&o.KRF.Reg)&^(0x1)|value)
}
func (o *KINT_Type) GetKRF_KIF0() uint8 {
	return volatile.LoadUint8(&o.KRF.Reg) & 0x1
}
func (o *KINT_Type) SetKRF_KIF1(value uint8) {
	volatile.StoreUint8(&o.KRF.Reg, volatile.LoadUint8(&o.KRF.Reg)&^(0x2)|value<<1)
}
func (o *KINT_Type) GetKRF_KIF1() uint8 {
	return (volatile.LoadUint8(&o.KRF.Reg) & 0x2) >> 1
}
func (o *KINT_Type) SetKRF_KIF2(value uint8) {
	volatile.StoreUint8(&o.KRF.Reg, volatile.LoadUint8(&o.KRF.Reg)&^(0x4)|value<<2)
}
func (o *KINT_Type) GetKRF_KIF2() uint8 {
	return (volatile.LoadUint8(&o.KRF.Reg) & 0x4) >> 2
}
func (o *KINT_Type) SetKRF_KIF3(value uint8) {
	volatile.StoreUint8(&o.KRF.Reg, volatile.LoadUint8(&o.KRF.Reg)&^(0x8)|value<<3)
}
func (o *KINT_Type) GetKRF_KIF3() uint8 {
	return (volatile.LoadUint8(&o.KRF.Reg) & 0x8) >> 3
}

// KINT.KRM: Key Return Mode Register
func (o *KINT_Type) SetKRM_KIMC0(value uint8) {
	volatile.StoreUint8(&o.KRM.Reg, volatile.LoadUint8(&o.KRM.Reg)&^(0x1)|value)
}
func (o *KINT_Type) GetKRM_KIMC0() uint8 {
	return volatile.LoadUint8(&o.KRM.Reg) & 0x1
}
func (o *KINT_Type) SetKRM_KIMC1(value uint8) {
	volatile.StoreUint8(&o.KRM.Reg, volatile.LoadUint8(&o.KRM.Reg)&^(0x2)|value<<1)
}
func (o *KINT_Type) GetKRM_KIMC1() uint8 {
	return (volatile.LoadUint8(&o.KRM.Reg) & 0x2) >> 1
}
func (o *KINT_Type) SetKRM_KIMC2(value uint8) {
	volatile.StoreUint8(&o.KRM.Reg, volatile.LoadUint8(&o.KRM.Reg)&^(0x4)|value<<2)
}
func (o *KINT_Type) GetKRM_KIMC2() uint8 {
	return (volatile.LoadUint8(&o.KRM.Reg) & 0x4) >> 2
}
func (o *KINT_Type) SetKRM_KIMC3(value uint8) {
	volatile.StoreUint8(&o.KRM.Reg, volatile.LoadUint8(&o.KRM.Reg)&^(0x8)|value<<3)
}
func (o *KINT_Type) GetKRM_KIMC3() uint8 {
	return (volatile.LoadUint8(&o.KRM.Reg) & 0x8) >> 3
}

// I3C Bus Interface
type I3C_Type struct {
	PRTS      volatile.Register32 // 0x0
	_         [16]byte
	BCTL      volatile.Register32 // 0x14
	MSDVAD    volatile.Register32 // 0x18
	_         [4]byte
	RSTCTL    volatile.Register32 // 0x20
	PRSST     volatile.Register32 // 0x24
	_         [8]byte
	INST      volatile.Register32 // 0x30
	INSTE     volatile.Register32 // 0x34
	INIE      volatile.Register32 // 0x38
	INSTFC    volatile.Register32 // 0x3C
	_         [4]byte
	DVCT      volatile.Register32 // 0x44
	_         [16]byte
	IBINCTL   volatile.Register32 // 0x58
	_         [4]byte
	BFCTL     volatile.Register32 // 0x60
	SVCTL     volatile.Register32 // 0x64
	_         [8]byte
	REFCKCTL  volatile.Register32 // 0x70
	STDBR     volatile.Register32 // 0x74
	EXTBR     volatile.Register32 // 0x78
	BFRECDT   volatile.Register32 // 0x7C
	BAVLCDT   volatile.Register32 // 0x80
	BIDLCDT   volatile.Register32 // 0x84
	OUTCTL    volatile.Register32 // 0x88
	INCTL     volatile.Register32 // 0x8C
	TMOCTL    volatile.Register32 // 0x90
	_         [12]byte
	ACKCTL    volatile.Register32 // 0xA0
	SCSTRCTL  volatile.Register32 // 0xA4
	_         [8]byte
	SCSTLCTL  volatile.Register32 // 0xB0
	_         [12]byte
	SVTDLG0   volatile.Register32 // 0xC0
	_         [124]byte
	CNDCTL    volatile.Register32 // 0x140
	_         [12]byte
	NCMDQP    volatile.Register32 // 0x150
	NRSPQP    volatile.Register32 // 0x154
	NTDTBP0   volatile.Register32 // 0x158
	_         [32]byte
	NIBIQP    volatile.Register32 // 0x17C
	NRSQP     volatile.Register32 // 0x180
	_         [12]byte
	NQTHCTL   volatile.Register32 // 0x190
	NTBTHCTL0 volatile.Register32 // 0x194
	_         [40]byte
	NRQTHCTL  volatile.Register32 // 0x1C0
	_         [12]byte
	BST       volatile.Register32 // 0x1D0
	BSTE      volatile.Register32 // 0x1D4
	BIE       volatile.Register32 // 0x1D8
	BSTFC     volatile.Register32 // 0x1DC
	NTST      volatile.Register32 // 0x1E0
	NTSTE     volatile.Register32 // 0x1E4
	NTIE      volatile.Register32 // 0x1E8
	NTSTFC    volatile.Register32 // 0x1EC
	_         [32]byte
	BCST      volatile.Register32 // 0x210
	SVST      volatile.Register32 // 0x214
	_         [12]byte
	DATBAS0   volatile.Register32 // 0x224
	_         [4]byte
	DATBAS1   volatile.Register32 // 0x22C
	_         [4]byte
	DATBAS2   volatile.Register32 // 0x234
	_         [4]byte
	DATBAS3   volatile.Register32 // 0x23C
	_         [96]byte
	EXDATBAS  volatile.Register32 // 0x2A0
	_         [12]byte
	SDATBAS0  volatile.Register32 // 0x2B0
	_         [28]byte
	MSDCT0    volatile.Register32 // 0x2D0
	MSDCT1    volatile.Register32 // 0x2D4
	MSDCT2    volatile.Register32 // 0x2D8
	MSDCT3    volatile.Register32 // 0x2DC
	_         [64]byte
	SVDCT     volatile.Register32 // 0x320
	SDCTPIDL  volatile.Register32 // 0x324
	SDCTPIDH  volatile.Register32 // 0x328
	_         [4]byte
	SVDVAD0   volatile.Register32 // 0x330
	_         [28]byte
	CSECMD    volatile.Register32 // 0x350
	CEACTST   volatile.Register32 // 0x354
	CMWLG     volatile.Register32 // 0x358
	CMRLG     volatile.Register32 // 0x35C
	CETSTMD   volatile.Register32 // 0x360
	CGDVST    volatile.Register32 // 0x364
	CMDSPW    volatile.Register32 // 0x368
	CMDSPR    volatile.Register32 // 0x36C
	CMDSPT    volatile.Register32 // 0x370
	CETSM     volatile.Register32 // 0x374
	_         [8]byte
	BITCNT    volatile.Register32 // 0x380
	_         [16]byte
	NQSTLV    volatile.Register32 // 0x394
	NDBSTLV0  volatile.Register32 // 0x398
	_         [36]byte
	NRSQSTLV  volatile.Register32 // 0x3C0
	_         [8]byte
	PRSTDBG   volatile.Register32 // 0x3CC
	MSERRCNT  volatile.Register32 // 0x3D0
}

// I3C.PRTS: Protocol Selection Register
func (o *I3C_Type) SetPRTS_PRTMD(value uint32) {
	volatile.StoreUint32(&o.PRTS.Reg, volatile.LoadUint32(&o.PRTS.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetPRTS_PRTMD() uint32 {
	return volatile.LoadUint32(&o.PRTS.Reg) & 0x1
}

// I3C.BCTL: Bus Control Register
func (o *I3C_Type) SetBCTL_INCBA(value uint32) {
	volatile.StoreUint32(&o.BCTL.Reg, volatile.LoadUint32(&o.BCTL.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetBCTL_INCBA() uint32 {
	return volatile.LoadUint32(&o.BCTL.Reg) & 0x1
}
func (o *I3C_Type) SetBCTL_HJACKCTL(value uint32) {
	volatile.StoreUint32(&o.BCTL.Reg, volatile.LoadUint32(&o.BCTL.Reg)&^(0x100)|value<<8)
}
func (o *I3C_Type) GetBCTL_HJACKCTL() uint32 {
	return (volatile.LoadUint32(&o.BCTL.Reg) & 0x100) >> 8
}
func (o *I3C_Type) SetBCTL_ABT(value uint32) {
	volatile.StoreUint32(&o.BCTL.Reg, volatile.LoadUint32(&o.BCTL.Reg)&^(0x20000000)|value<<29)
}
func (o *I3C_Type) GetBCTL_ABT() uint32 {
	return (volatile.LoadUint32(&o.BCTL.Reg) & 0x20000000) >> 29
}
func (o *I3C_Type) SetBCTL_RSM(value uint32) {
	volatile.StoreUint32(&o.BCTL.Reg, volatile.LoadUint32(&o.BCTL.Reg)&^(0x40000000)|value<<30)
}
func (o *I3C_Type) GetBCTL_RSM() uint32 {
	return (volatile.LoadUint32(&o.BCTL.Reg) & 0x40000000) >> 30
}
func (o *I3C_Type) SetBCTL_BUSE(value uint32) {
	volatile.StoreUint32(&o.BCTL.Reg, volatile.LoadUint32(&o.BCTL.Reg)&^(0x80000000)|value<<31)
}
func (o *I3C_Type) GetBCTL_BUSE() uint32 {
	return (volatile.LoadUint32(&o.BCTL.Reg) & 0x80000000) >> 31
}

// I3C.MSDVAD: Master Device Address Register
func (o *I3C_Type) SetMSDVAD_MDYAD(value uint32) {
	volatile.StoreUint32(&o.MSDVAD.Reg, volatile.LoadUint32(&o.MSDVAD.Reg)&^(0x7f0000)|value<<16)
}
func (o *I3C_Type) GetMSDVAD_MDYAD() uint32 {
	return (volatile.LoadUint32(&o.MSDVAD.Reg) & 0x7f0000) >> 16
}
func (o *I3C_Type) SetMSDVAD_MDYADV(value uint32) {
	volatile.StoreUint32(&o.MSDVAD.Reg, volatile.LoadUint32(&o.MSDVAD.Reg)&^(0x80000000)|value<<31)
}
func (o *I3C_Type) GetMSDVAD_MDYADV() uint32 {
	return (volatile.LoadUint32(&o.MSDVAD.Reg) & 0x80000000) >> 31
}

// I3C.RSTCTL: Reset Control Register
func (o *I3C_Type) SetRSTCTL_RI3CRST(value uint32) {
	volatile.StoreUint32(&o.RSTCTL.Reg, volatile.LoadUint32(&o.RSTCTL.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetRSTCTL_RI3CRST() uint32 {
	return volatile.LoadUint32(&o.RSTCTL.Reg) & 0x1
}
func (o *I3C_Type) SetRSTCTL_CMDQRST(value uint32) {
	volatile.StoreUint32(&o.RSTCTL.Reg, volatile.LoadUint32(&o.RSTCTL.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetRSTCTL_CMDQRST() uint32 {
	return (volatile.LoadUint32(&o.RSTCTL.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetRSTCTL_RSPQRST(value uint32) {
	volatile.StoreUint32(&o.RSTCTL.Reg, volatile.LoadUint32(&o.RSTCTL.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetRSTCTL_RSPQRST() uint32 {
	return (volatile.LoadUint32(&o.RSTCTL.Reg) & 0x4) >> 2
}
func (o *I3C_Type) SetRSTCTL_TDBRST(value uint32) {
	volatile.StoreUint32(&o.RSTCTL.Reg, volatile.LoadUint32(&o.RSTCTL.Reg)&^(0x8)|value<<3)
}
func (o *I3C_Type) GetRSTCTL_TDBRST() uint32 {
	return (volatile.LoadUint32(&o.RSTCTL.Reg) & 0x8) >> 3
}
func (o *I3C_Type) SetRSTCTL_RDBRST(value uint32) {
	volatile.StoreUint32(&o.RSTCTL.Reg, volatile.LoadUint32(&o.RSTCTL.Reg)&^(0x10)|value<<4)
}
func (o *I3C_Type) GetRSTCTL_RDBRST() uint32 {
	return (volatile.LoadUint32(&o.RSTCTL.Reg) & 0x10) >> 4
}
func (o *I3C_Type) SetRSTCTL_IBIQRST(value uint32) {
	volatile.StoreUint32(&o.RSTCTL.Reg, volatile.LoadUint32(&o.RSTCTL.Reg)&^(0x20)|value<<5)
}
func (o *I3C_Type) GetRSTCTL_IBIQRST() uint32 {
	return (volatile.LoadUint32(&o.RSTCTL.Reg) & 0x20) >> 5
}
func (o *I3C_Type) SetRSTCTL_RSQRST(value uint32) {
	volatile.StoreUint32(&o.RSTCTL.Reg, volatile.LoadUint32(&o.RSTCTL.Reg)&^(0x40)|value<<6)
}
func (o *I3C_Type) GetRSTCTL_RSQRST() uint32 {
	return (volatile.LoadUint32(&o.RSTCTL.Reg) & 0x40) >> 6
}
func (o *I3C_Type) SetRSTCTL_INTLRST(value uint32) {
	volatile.StoreUint32(&o.RSTCTL.Reg, volatile.LoadUint32(&o.RSTCTL.Reg)&^(0x10000)|value<<16)
}
func (o *I3C_Type) GetRSTCTL_INTLRST() uint32 {
	return (volatile.LoadUint32(&o.RSTCTL.Reg) & 0x10000) >> 16
}

// I3C.PRSST: Present State Register
func (o *I3C_Type) SetPRSST_CRMS(value uint32) {
	volatile.StoreUint32(&o.PRSST.Reg, volatile.LoadUint32(&o.PRSST.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetPRSST_CRMS() uint32 {
	return (volatile.LoadUint32(&o.PRSST.Reg) & 0x4) >> 2
}
func (o *I3C_Type) SetPRSST_TRMD(value uint32) {
	volatile.StoreUint32(&o.PRSST.Reg, volatile.LoadUint32(&o.PRSST.Reg)&^(0x10)|value<<4)
}
func (o *I3C_Type) GetPRSST_TRMD() uint32 {
	return (volatile.LoadUint32(&o.PRSST.Reg) & 0x10) >> 4
}
func (o *I3C_Type) SetPRSST_PRSSTWP(value uint32) {
	volatile.StoreUint32(&o.PRSST.Reg, volatile.LoadUint32(&o.PRSST.Reg)&^(0x80)|value<<7)
}
func (o *I3C_Type) GetPRSST_PRSSTWP() uint32 {
	return (volatile.LoadUint32(&o.PRSST.Reg) & 0x80) >> 7
}

// I3C.INST: Internal Status Register
func (o *I3C_Type) SetINST_INEF(value uint32) {
	volatile.StoreUint32(&o.INST.Reg, volatile.LoadUint32(&o.INST.Reg)&^(0x400)|value<<10)
}
func (o *I3C_Type) GetINST_INEF() uint32 {
	return (volatile.LoadUint32(&o.INST.Reg) & 0x400) >> 10
}

// I3C.INSTE: Internal Status Enable Register
func (o *I3C_Type) SetINSTE_INEE(value uint32) {
	volatile.StoreUint32(&o.INSTE.Reg, volatile.LoadUint32(&o.INSTE.Reg)&^(0x400)|value<<10)
}
func (o *I3C_Type) GetINSTE_INEE() uint32 {
	return (volatile.LoadUint32(&o.INSTE.Reg) & 0x400) >> 10
}

// I3C.INIE: Internal Interrupt Enable Register
func (o *I3C_Type) SetINIE_INEIE(value uint32) {
	volatile.StoreUint32(&o.INIE.Reg, volatile.LoadUint32(&o.INIE.Reg)&^(0x400)|value<<10)
}
func (o *I3C_Type) GetINIE_INEIE() uint32 {
	return (volatile.LoadUint32(&o.INIE.Reg) & 0x400) >> 10
}

// I3C.INSTFC: Internal Status Force Register
func (o *I3C_Type) SetINSTFC_INEFC(value uint32) {
	volatile.StoreUint32(&o.INSTFC.Reg, volatile.LoadUint32(&o.INSTFC.Reg)&^(0x400)|value<<10)
}
func (o *I3C_Type) GetINSTFC_INEFC() uint32 {
	return (volatile.LoadUint32(&o.INSTFC.Reg) & 0x400) >> 10
}

// I3C.DVCT: Device Characteristic Table Register
func (o *I3C_Type) SetDVCT_IDX(value uint32) {
	volatile.StoreUint32(&o.DVCT.Reg, volatile.LoadUint32(&o.DVCT.Reg)&^(0xf80000)|value<<19)
}
func (o *I3C_Type) GetDVCT_IDX() uint32 {
	return (volatile.LoadUint32(&o.DVCT.Reg) & 0xf80000) >> 19
}

// I3C.IBINCTL: IBI Notify Control Register
func (o *I3C_Type) SetIBINCTL_NRHJCTL(value uint32) {
	volatile.StoreUint32(&o.IBINCTL.Reg, volatile.LoadUint32(&o.IBINCTL.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetIBINCTL_NRHJCTL() uint32 {
	return volatile.LoadUint32(&o.IBINCTL.Reg) & 0x1
}
func (o *I3C_Type) SetIBINCTL_NRMRCTL(value uint32) {
	volatile.StoreUint32(&o.IBINCTL.Reg, volatile.LoadUint32(&o.IBINCTL.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetIBINCTL_NRMRCTL() uint32 {
	return (volatile.LoadUint32(&o.IBINCTL.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetIBINCTL_NRSIRCTL(value uint32) {
	volatile.StoreUint32(&o.IBINCTL.Reg, volatile.LoadUint32(&o.IBINCTL.Reg)&^(0x8)|value<<3)
}
func (o *I3C_Type) GetIBINCTL_NRSIRCTL() uint32 {
	return (volatile.LoadUint32(&o.IBINCTL.Reg) & 0x8) >> 3
}

// I3C.BFCTL: Bus Function Control Register
func (o *I3C_Type) SetBFCTL_MALE(value uint32) {
	volatile.StoreUint32(&o.BFCTL.Reg, volatile.LoadUint32(&o.BFCTL.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetBFCTL_MALE() uint32 {
	return volatile.LoadUint32(&o.BFCTL.Reg) & 0x1
}
func (o *I3C_Type) SetBFCTL_NALE(value uint32) {
	volatile.StoreUint32(&o.BFCTL.Reg, volatile.LoadUint32(&o.BFCTL.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetBFCTL_NALE() uint32 {
	return (volatile.LoadUint32(&o.BFCTL.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetBFCTL_SALE(value uint32) {
	volatile.StoreUint32(&o.BFCTL.Reg, volatile.LoadUint32(&o.BFCTL.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetBFCTL_SALE() uint32 {
	return (volatile.LoadUint32(&o.BFCTL.Reg) & 0x4) >> 2
}
func (o *I3C_Type) SetBFCTL_SCSYNE(value uint32) {
	volatile.StoreUint32(&o.BFCTL.Reg, volatile.LoadUint32(&o.BFCTL.Reg)&^(0x100)|value<<8)
}
func (o *I3C_Type) GetBFCTL_SCSYNE() uint32 {
	return (volatile.LoadUint32(&o.BFCTL.Reg) & 0x100) >> 8
}
func (o *I3C_Type) SetBFCTL_SMBS(value uint32) {
	volatile.StoreUint32(&o.BFCTL.Reg, volatile.LoadUint32(&o.BFCTL.Reg)&^(0x1000)|value<<12)
}
func (o *I3C_Type) GetBFCTL_SMBS() uint32 {
	return (volatile.LoadUint32(&o.BFCTL.Reg) & 0x1000) >> 12
}
func (o *I3C_Type) SetBFCTL_FMPE(value uint32) {
	volatile.StoreUint32(&o.BFCTL.Reg, volatile.LoadUint32(&o.BFCTL.Reg)&^(0x4000)|value<<14)
}
func (o *I3C_Type) GetBFCTL_FMPE() uint32 {
	return (volatile.LoadUint32(&o.BFCTL.Reg) & 0x4000) >> 14
}
func (o *I3C_Type) SetBFCTL_HSME(value uint32) {
	volatile.StoreUint32(&o.BFCTL.Reg, volatile.LoadUint32(&o.BFCTL.Reg)&^(0x8000)|value<<15)
}
func (o *I3C_Type) GetBFCTL_HSME() uint32 {
	return (volatile.LoadUint32(&o.BFCTL.Reg) & 0x8000) >> 15
}

// I3C.SVCTL: Slave Control Register
func (o *I3C_Type) SetSVCTL_GCAE(value uint32) {
	volatile.StoreUint32(&o.SVCTL.Reg, volatile.LoadUint32(&o.SVCTL.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetSVCTL_GCAE() uint32 {
	return volatile.LoadUint32(&o.SVCTL.Reg) & 0x1
}
func (o *I3C_Type) SetSVCTL_HSMCE(value uint32) {
	volatile.StoreUint32(&o.SVCTL.Reg, volatile.LoadUint32(&o.SVCTL.Reg)&^(0x20)|value<<5)
}
func (o *I3C_Type) GetSVCTL_HSMCE() uint32 {
	return (volatile.LoadUint32(&o.SVCTL.Reg) & 0x20) >> 5
}
func (o *I3C_Type) SetSVCTL_DVIDE(value uint32) {
	volatile.StoreUint32(&o.SVCTL.Reg, volatile.LoadUint32(&o.SVCTL.Reg)&^(0x40)|value<<6)
}
func (o *I3C_Type) GetSVCTL_DVIDE() uint32 {
	return (volatile.LoadUint32(&o.SVCTL.Reg) & 0x40) >> 6
}
func (o *I3C_Type) SetSVCTL_HOAE(value uint32) {
	volatile.StoreUint32(&o.SVCTL.Reg, volatile.LoadUint32(&o.SVCTL.Reg)&^(0x8000)|value<<15)
}
func (o *I3C_Type) GetSVCTL_HOAE() uint32 {
	return (volatile.LoadUint32(&o.SVCTL.Reg) & 0x8000) >> 15
}
func (o *I3C_Type) SetSVCTL_SVAE0(value uint32) {
	volatile.StoreUint32(&o.SVCTL.Reg, volatile.LoadUint32(&o.SVCTL.Reg)&^(0x10000)|value<<16)
}
func (o *I3C_Type) GetSVCTL_SVAE0() uint32 {
	return (volatile.LoadUint32(&o.SVCTL.Reg) & 0x10000) >> 16
}

// I3C.REFCKCTL: Reference Clock Control Register
func (o *I3C_Type) SetREFCKCTL_IREFCKS(value uint32) {
	volatile.StoreUint32(&o.REFCKCTL.Reg, volatile.LoadUint32(&o.REFCKCTL.Reg)&^(0x7)|value)
}
func (o *I3C_Type) GetREFCKCTL_IREFCKS() uint32 {
	return volatile.LoadUint32(&o.REFCKCTL.Reg) & 0x7
}

// I3C.STDBR: Standard Bit Rate Register
func (o *I3C_Type) SetSTDBR_SBRLO(value uint32) {
	volatile.StoreUint32(&o.STDBR.Reg, volatile.LoadUint32(&o.STDBR.Reg)&^(0xff)|value)
}
func (o *I3C_Type) GetSTDBR_SBRLO() uint32 {
	return volatile.LoadUint32(&o.STDBR.Reg) & 0xff
}
func (o *I3C_Type) SetSTDBR_SBRHO(value uint32) {
	volatile.StoreUint32(&o.STDBR.Reg, volatile.LoadUint32(&o.STDBR.Reg)&^(0xff00)|value<<8)
}
func (o *I3C_Type) GetSTDBR_SBRHO() uint32 {
	return (volatile.LoadUint32(&o.STDBR.Reg) & 0xff00) >> 8
}
func (o *I3C_Type) SetSTDBR_SBRLP(value uint32) {
	volatile.StoreUint32(&o.STDBR.Reg, volatile.LoadUint32(&o.STDBR.Reg)&^(0x3f0000)|value<<16)
}
func (o *I3C_Type) GetSTDBR_SBRLP() uint32 {
	return (volatile.LoadUint32(&o.STDBR.Reg) & 0x3f0000) >> 16
}
func (o *I3C_Type) SetSTDBR_SBRHP(value uint32) {
	volatile.StoreUint32(&o.STDBR.Reg, volatile.LoadUint32(&o.STDBR.Reg)&^(0x3f000000)|value<<24)
}
func (o *I3C_Type) GetSTDBR_SBRHP() uint32 {
	return (volatile.LoadUint32(&o.STDBR.Reg) & 0x3f000000) >> 24
}
func (o *I3C_Type) SetSTDBR_DSBRPO(value uint32) {
	volatile.StoreUint32(&o.STDBR.Reg, volatile.LoadUint32(&o.STDBR.Reg)&^(0x80000000)|value<<31)
}
func (o *I3C_Type) GetSTDBR_DSBRPO() uint32 {
	return (volatile.LoadUint32(&o.STDBR.Reg) & 0x80000000) >> 31
}

// I3C.EXTBR: Extended Bit Rate Register
func (o *I3C_Type) SetEXTBR_EBRLO(value uint32) {
	volatile.StoreUint32(&o.EXTBR.Reg, volatile.LoadUint32(&o.EXTBR.Reg)&^(0xff)|value)
}
func (o *I3C_Type) GetEXTBR_EBRLO() uint32 {
	return volatile.LoadUint32(&o.EXTBR.Reg) & 0xff
}
func (o *I3C_Type) SetEXTBR_EBRHO(value uint32) {
	volatile.StoreUint32(&o.EXTBR.Reg, volatile.LoadUint32(&o.EXTBR.Reg)&^(0xff00)|value<<8)
}
func (o *I3C_Type) GetEXTBR_EBRHO() uint32 {
	return (volatile.LoadUint32(&o.EXTBR.Reg) & 0xff00) >> 8
}
func (o *I3C_Type) SetEXTBR_EBRLP(value uint32) {
	volatile.StoreUint32(&o.EXTBR.Reg, volatile.LoadUint32(&o.EXTBR.Reg)&^(0x3f0000)|value<<16)
}
func (o *I3C_Type) GetEXTBR_EBRLP() uint32 {
	return (volatile.LoadUint32(&o.EXTBR.Reg) & 0x3f0000) >> 16
}
func (o *I3C_Type) SetEXTBR_EBRHP(value uint32) {
	volatile.StoreUint32(&o.EXTBR.Reg, volatile.LoadUint32(&o.EXTBR.Reg)&^(0x3f000000)|value<<24)
}
func (o *I3C_Type) GetEXTBR_EBRHP() uint32 {
	return (volatile.LoadUint32(&o.EXTBR.Reg) & 0x3f000000) >> 24
}

// I3C.BFRECDT: Bus Free Condition Detection Time Register
func (o *I3C_Type) SetBFRECDT_FRECYC(value uint32) {
	volatile.StoreUint32(&o.BFRECDT.Reg, volatile.LoadUint32(&o.BFRECDT.Reg)&^(0x1ff)|value)
}
func (o *I3C_Type) GetBFRECDT_FRECYC() uint32 {
	return volatile.LoadUint32(&o.BFRECDT.Reg) & 0x1ff
}

// I3C.BAVLCDT: Bus Available Condition Detection Time Register
func (o *I3C_Type) SetBAVLCDT_AVLCYC(value uint32) {
	volatile.StoreUint32(&o.BAVLCDT.Reg, volatile.LoadUint32(&o.BAVLCDT.Reg)&^(0x1ff)|value)
}
func (o *I3C_Type) GetBAVLCDT_AVLCYC() uint32 {
	return volatile.LoadUint32(&o.BAVLCDT.Reg) & 0x1ff
}

// I3C.BIDLCDT: Bus Idle Condition Detection Time Register
func (o *I3C_Type) SetBIDLCDT_IDLCYC(value uint32) {
	volatile.StoreUint32(&o.BIDLCDT.Reg, volatile.LoadUint32(&o.BIDLCDT.Reg)&^(0x3ffff)|value)
}
func (o *I3C_Type) GetBIDLCDT_IDLCYC() uint32 {
	return volatile.LoadUint32(&o.BIDLCDT.Reg) & 0x3ffff
}

// I3C.OUTCTL: Output Control Register
func (o *I3C_Type) SetOUTCTL_SDOC(value uint32) {
	volatile.StoreUint32(&o.OUTCTL.Reg, volatile.LoadUint32(&o.OUTCTL.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetOUTCTL_SDOC() uint32 {
	return volatile.LoadUint32(&o.OUTCTL.Reg) & 0x1
}
func (o *I3C_Type) SetOUTCTL_SCOC(value uint32) {
	volatile.StoreUint32(&o.OUTCTL.Reg, volatile.LoadUint32(&o.OUTCTL.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetOUTCTL_SCOC() uint32 {
	return (volatile.LoadUint32(&o.OUTCTL.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetOUTCTL_SOCWP(value uint32) {
	volatile.StoreUint32(&o.OUTCTL.Reg, volatile.LoadUint32(&o.OUTCTL.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetOUTCTL_SOCWP() uint32 {
	return (volatile.LoadUint32(&o.OUTCTL.Reg) & 0x4) >> 2
}
func (o *I3C_Type) SetOUTCTL_EXCYC(value uint32) {
	volatile.StoreUint32(&o.OUTCTL.Reg, volatile.LoadUint32(&o.OUTCTL.Reg)&^(0x10)|value<<4)
}
func (o *I3C_Type) GetOUTCTL_EXCYC() uint32 {
	return (volatile.LoadUint32(&o.OUTCTL.Reg) & 0x10) >> 4
}
func (o *I3C_Type) SetOUTCTL_SDOD(value uint32) {
	volatile.StoreUint32(&o.OUTCTL.Reg, volatile.LoadUint32(&o.OUTCTL.Reg)&^(0x700)|value<<8)
}
func (o *I3C_Type) GetOUTCTL_SDOD() uint32 {
	return (volatile.LoadUint32(&o.OUTCTL.Reg) & 0x700) >> 8
}
func (o *I3C_Type) SetOUTCTL_SDODCS(value uint32) {
	volatile.StoreUint32(&o.OUTCTL.Reg, volatile.LoadUint32(&o.OUTCTL.Reg)&^(0x8000)|value<<15)
}
func (o *I3C_Type) GetOUTCTL_SDODCS() uint32 {
	return (volatile.LoadUint32(&o.OUTCTL.Reg) & 0x8000) >> 15
}

// I3C.INCTL: Input Control Register
func (o *I3C_Type) SetINCTL_DNFS(value uint32) {
	volatile.StoreUint32(&o.INCTL.Reg, volatile.LoadUint32(&o.INCTL.Reg)&^(0xf)|value)
}
func (o *I3C_Type) GetINCTL_DNFS() uint32 {
	return volatile.LoadUint32(&o.INCTL.Reg) & 0xf
}
func (o *I3C_Type) SetINCTL_DNFE(value uint32) {
	volatile.StoreUint32(&o.INCTL.Reg, volatile.LoadUint32(&o.INCTL.Reg)&^(0x10)|value<<4)
}
func (o *I3C_Type) GetINCTL_DNFE() uint32 {
	return (volatile.LoadUint32(&o.INCTL.Reg) & 0x10) >> 4
}

// I3C.TMOCTL: Timeout Control Register
func (o *I3C_Type) SetTMOCTL_TODTS(value uint32) {
	volatile.StoreUint32(&o.TMOCTL.Reg, volatile.LoadUint32(&o.TMOCTL.Reg)&^(0x3)|value)
}
func (o *I3C_Type) GetTMOCTL_TODTS() uint32 {
	return volatile.LoadUint32(&o.TMOCTL.Reg) & 0x3
}
func (o *I3C_Type) SetTMOCTL_TOLCTL(value uint32) {
	volatile.StoreUint32(&o.TMOCTL.Reg, volatile.LoadUint32(&o.TMOCTL.Reg)&^(0x10)|value<<4)
}
func (o *I3C_Type) GetTMOCTL_TOLCTL() uint32 {
	return (volatile.LoadUint32(&o.TMOCTL.Reg) & 0x10) >> 4
}
func (o *I3C_Type) SetTMOCTL_TOHCTL(value uint32) {
	volatile.StoreUint32(&o.TMOCTL.Reg, volatile.LoadUint32(&o.TMOCTL.Reg)&^(0x20)|value<<5)
}
func (o *I3C_Type) GetTMOCTL_TOHCTL() uint32 {
	return (volatile.LoadUint32(&o.TMOCTL.Reg) & 0x20) >> 5
}
func (o *I3C_Type) SetTMOCTL_TOMDS(value uint32) {
	volatile.StoreUint32(&o.TMOCTL.Reg, volatile.LoadUint32(&o.TMOCTL.Reg)&^(0xc0)|value<<6)
}
func (o *I3C_Type) GetTMOCTL_TOMDS() uint32 {
	return (volatile.LoadUint32(&o.TMOCTL.Reg) & 0xc0) >> 6
}

// I3C.ACKCTL: Acknowledge Control Register
func (o *I3C_Type) SetACKCTL_ACKR(value uint32) {
	volatile.StoreUint32(&o.ACKCTL.Reg, volatile.LoadUint32(&o.ACKCTL.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetACKCTL_ACKR() uint32 {
	return volatile.LoadUint32(&o.ACKCTL.Reg) & 0x1
}
func (o *I3C_Type) SetACKCTL_ACKT(value uint32) {
	volatile.StoreUint32(&o.ACKCTL.Reg, volatile.LoadUint32(&o.ACKCTL.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetACKCTL_ACKT() uint32 {
	return (volatile.LoadUint32(&o.ACKCTL.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetACKCTL_ACKTWP(value uint32) {
	volatile.StoreUint32(&o.ACKCTL.Reg, volatile.LoadUint32(&o.ACKCTL.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetACKCTL_ACKTWP() uint32 {
	return (volatile.LoadUint32(&o.ACKCTL.Reg) & 0x4) >> 2
}

// I3C.SCSTRCTL: SCL Stretch Control Register
func (o *I3C_Type) SetSCSTRCTL_ACKTWE(value uint32) {
	volatile.StoreUint32(&o.SCSTRCTL.Reg, volatile.LoadUint32(&o.SCSTRCTL.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetSCSTRCTL_ACKTWE() uint32 {
	return volatile.LoadUint32(&o.SCSTRCTL.Reg) & 0x1
}
func (o *I3C_Type) SetSCSTRCTL_RWE(value uint32) {
	volatile.StoreUint32(&o.SCSTRCTL.Reg, volatile.LoadUint32(&o.SCSTRCTL.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetSCSTRCTL_RWE() uint32 {
	return (volatile.LoadUint32(&o.SCSTRCTL.Reg) & 0x2) >> 1
}

// I3C.SCSTLCTL: SCL Stalling Control Register
func (o *I3C_Type) SetSCSTLCTL_STLCYC(value uint32) {
	volatile.StoreUint32(&o.SCSTLCTL.Reg, volatile.LoadUint32(&o.SCSTLCTL.Reg)&^(0xffff)|value)
}
func (o *I3C_Type) GetSCSTLCTL_STLCYC() uint32 {
	return volatile.LoadUint32(&o.SCSTLCTL.Reg) & 0xffff
}
func (o *I3C_Type) SetSCSTLCTL_AAPE(value uint32) {
	volatile.StoreUint32(&o.SCSTLCTL.Reg, volatile.LoadUint32(&o.SCSTLCTL.Reg)&^(0x10000000)|value<<28)
}
func (o *I3C_Type) GetSCSTLCTL_AAPE() uint32 {
	return (volatile.LoadUint32(&o.SCSTLCTL.Reg) & 0x10000000) >> 28
}
func (o *I3C_Type) SetSCSTLCTL_TRAPE(value uint32) {
	volatile.StoreUint32(&o.SCSTLCTL.Reg, volatile.LoadUint32(&o.SCSTLCTL.Reg)&^(0x20000000)|value<<29)
}
func (o *I3C_Type) GetSCSTLCTL_TRAPE() uint32 {
	return (volatile.LoadUint32(&o.SCSTLCTL.Reg) & 0x20000000) >> 29
}
func (o *I3C_Type) SetSCSTLCTL_PARPE(value uint32) {
	volatile.StoreUint32(&o.SCSTLCTL.Reg, volatile.LoadUint32(&o.SCSTLCTL.Reg)&^(0x40000000)|value<<30)
}
func (o *I3C_Type) GetSCSTLCTL_PARPE() uint32 {
	return (volatile.LoadUint32(&o.SCSTLCTL.Reg) & 0x40000000) >> 30
}
func (o *I3C_Type) SetSCSTLCTL_ACKPE(value uint32) {
	volatile.StoreUint32(&o.SCSTLCTL.Reg, volatile.LoadUint32(&o.SCSTLCTL.Reg)&^(0x80000000)|value<<31)
}
func (o *I3C_Type) GetSCSTLCTL_ACKPE() uint32 {
	return (volatile.LoadUint32(&o.SCSTLCTL.Reg) & 0x80000000) >> 31
}

// I3C.SVTDLG0: Slave Transfer Data Length Register 0
func (o *I3C_Type) SetSVTDLG0_STDLG(value uint32) {
	volatile.StoreUint32(&o.SVTDLG0.Reg, volatile.LoadUint32(&o.SVTDLG0.Reg)&^(0xffff0000)|value<<16)
}
func (o *I3C_Type) GetSVTDLG0_STDLG() uint32 {
	return (volatile.LoadUint32(&o.SVTDLG0.Reg) & 0xffff0000) >> 16
}

// I3C.CNDCTL: Condition Control Register
func (o *I3C_Type) SetCNDCTL_STCND(value uint32) {
	volatile.StoreUint32(&o.CNDCTL.Reg, volatile.LoadUint32(&o.CNDCTL.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetCNDCTL_STCND() uint32 {
	return volatile.LoadUint32(&o.CNDCTL.Reg) & 0x1
}
func (o *I3C_Type) SetCNDCTL_SRCND(value uint32) {
	volatile.StoreUint32(&o.CNDCTL.Reg, volatile.LoadUint32(&o.CNDCTL.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetCNDCTL_SRCND() uint32 {
	return (volatile.LoadUint32(&o.CNDCTL.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetCNDCTL_SPCND(value uint32) {
	volatile.StoreUint32(&o.CNDCTL.Reg, volatile.LoadUint32(&o.CNDCTL.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetCNDCTL_SPCND() uint32 {
	return (volatile.LoadUint32(&o.CNDCTL.Reg) & 0x4) >> 2
}

// I3C.NQTHCTL: Normal Queue Threshold Control Register
func (o *I3C_Type) SetNQTHCTL_CMDQTH(value uint32) {
	volatile.StoreUint32(&o.NQTHCTL.Reg, volatile.LoadUint32(&o.NQTHCTL.Reg)&^(0xff)|value)
}
func (o *I3C_Type) GetNQTHCTL_CMDQTH() uint32 {
	return volatile.LoadUint32(&o.NQTHCTL.Reg) & 0xff
}
func (o *I3C_Type) SetNQTHCTL_RSPQTH(value uint32) {
	volatile.StoreUint32(&o.NQTHCTL.Reg, volatile.LoadUint32(&o.NQTHCTL.Reg)&^(0xff00)|value<<8)
}
func (o *I3C_Type) GetNQTHCTL_RSPQTH() uint32 {
	return (volatile.LoadUint32(&o.NQTHCTL.Reg) & 0xff00) >> 8
}
func (o *I3C_Type) SetNQTHCTL_IBIDSSZ(value uint32) {
	volatile.StoreUint32(&o.NQTHCTL.Reg, volatile.LoadUint32(&o.NQTHCTL.Reg)&^(0xff0000)|value<<16)
}
func (o *I3C_Type) GetNQTHCTL_IBIDSSZ() uint32 {
	return (volatile.LoadUint32(&o.NQTHCTL.Reg) & 0xff0000) >> 16
}
func (o *I3C_Type) SetNQTHCTL_IBIQTH(value uint32) {
	volatile.StoreUint32(&o.NQTHCTL.Reg, volatile.LoadUint32(&o.NQTHCTL.Reg)&^(0xff000000)|value<<24)
}
func (o *I3C_Type) GetNQTHCTL_IBIQTH() uint32 {
	return (volatile.LoadUint32(&o.NQTHCTL.Reg) & 0xff000000) >> 24
}

// I3C.NTBTHCTL0: Normal Transfer Data Buffer Threshold Control Register 0
func (o *I3C_Type) SetNTBTHCTL0_TXDBTH(value uint32) {
	volatile.StoreUint32(&o.NTBTHCTL0.Reg, volatile.LoadUint32(&o.NTBTHCTL0.Reg)&^(0x7)|value)
}
func (o *I3C_Type) GetNTBTHCTL0_TXDBTH() uint32 {
	return volatile.LoadUint32(&o.NTBTHCTL0.Reg) & 0x7
}
func (o *I3C_Type) SetNTBTHCTL0_RXDBTH(value uint32) {
	volatile.StoreUint32(&o.NTBTHCTL0.Reg, volatile.LoadUint32(&o.NTBTHCTL0.Reg)&^(0x700)|value<<8)
}
func (o *I3C_Type) GetNTBTHCTL0_RXDBTH() uint32 {
	return (volatile.LoadUint32(&o.NTBTHCTL0.Reg) & 0x700) >> 8
}
func (o *I3C_Type) SetNTBTHCTL0_TXSTTH(value uint32) {
	volatile.StoreUint32(&o.NTBTHCTL0.Reg, volatile.LoadUint32(&o.NTBTHCTL0.Reg)&^(0x70000)|value<<16)
}
func (o *I3C_Type) GetNTBTHCTL0_TXSTTH() uint32 {
	return (volatile.LoadUint32(&o.NTBTHCTL0.Reg) & 0x70000) >> 16
}
func (o *I3C_Type) SetNTBTHCTL0_RXSTTH(value uint32) {
	volatile.StoreUint32(&o.NTBTHCTL0.Reg, volatile.LoadUint32(&o.NTBTHCTL0.Reg)&^(0x7000000)|value<<24)
}
func (o *I3C_Type) GetNTBTHCTL0_RXSTTH() uint32 {
	return (volatile.LoadUint32(&o.NTBTHCTL0.Reg) & 0x7000000) >> 24
}

// I3C.NRQTHCTL: Normal Receive Status Queue Threshold Control Register
func (o *I3C_Type) SetNRQTHCTL_RSQTH(value uint32) {
	volatile.StoreUint32(&o.NRQTHCTL.Reg, volatile.LoadUint32(&o.NRQTHCTL.Reg)&^(0xff)|value)
}
func (o *I3C_Type) GetNRQTHCTL_RSQTH() uint32 {
	return volatile.LoadUint32(&o.NRQTHCTL.Reg) & 0xff
}

// I3C.BST: Bus Status Register
func (o *I3C_Type) SetBST_STCNDDF(value uint32) {
	volatile.StoreUint32(&o.BST.Reg, volatile.LoadUint32(&o.BST.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetBST_STCNDDF() uint32 {
	return volatile.LoadUint32(&o.BST.Reg) & 0x1
}
func (o *I3C_Type) SetBST_SPCNDDF(value uint32) {
	volatile.StoreUint32(&o.BST.Reg, volatile.LoadUint32(&o.BST.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetBST_SPCNDDF() uint32 {
	return (volatile.LoadUint32(&o.BST.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetBST_HDREXDF(value uint32) {
	volatile.StoreUint32(&o.BST.Reg, volatile.LoadUint32(&o.BST.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetBST_HDREXDF() uint32 {
	return (volatile.LoadUint32(&o.BST.Reg) & 0x4) >> 2
}
func (o *I3C_Type) SetBST_NACKDF(value uint32) {
	volatile.StoreUint32(&o.BST.Reg, volatile.LoadUint32(&o.BST.Reg)&^(0x10)|value<<4)
}
func (o *I3C_Type) GetBST_NACKDF() uint32 {
	return (volatile.LoadUint32(&o.BST.Reg) & 0x10) >> 4
}
func (o *I3C_Type) SetBST_TENDF(value uint32) {
	volatile.StoreUint32(&o.BST.Reg, volatile.LoadUint32(&o.BST.Reg)&^(0x100)|value<<8)
}
func (o *I3C_Type) GetBST_TENDF() uint32 {
	return (volatile.LoadUint32(&o.BST.Reg) & 0x100) >> 8
}
func (o *I3C_Type) SetBST_ALF(value uint32) {
	volatile.StoreUint32(&o.BST.Reg, volatile.LoadUint32(&o.BST.Reg)&^(0x10000)|value<<16)
}
func (o *I3C_Type) GetBST_ALF() uint32 {
	return (volatile.LoadUint32(&o.BST.Reg) & 0x10000) >> 16
}
func (o *I3C_Type) SetBST_TODF(value uint32) {
	volatile.StoreUint32(&o.BST.Reg, volatile.LoadUint32(&o.BST.Reg)&^(0x100000)|value<<20)
}
func (o *I3C_Type) GetBST_TODF() uint32 {
	return (volatile.LoadUint32(&o.BST.Reg) & 0x100000) >> 20
}

// I3C.BSTE: Bus Status Enable Register
func (o *I3C_Type) SetBSTE_STCNDDE(value uint32) {
	volatile.StoreUint32(&o.BSTE.Reg, volatile.LoadUint32(&o.BSTE.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetBSTE_STCNDDE() uint32 {
	return volatile.LoadUint32(&o.BSTE.Reg) & 0x1
}
func (o *I3C_Type) SetBSTE_SPCNDDE(value uint32) {
	volatile.StoreUint32(&o.BSTE.Reg, volatile.LoadUint32(&o.BSTE.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetBSTE_SPCNDDE() uint32 {
	return (volatile.LoadUint32(&o.BSTE.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetBSTE_HDREXDE(value uint32) {
	volatile.StoreUint32(&o.BSTE.Reg, volatile.LoadUint32(&o.BSTE.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetBSTE_HDREXDE() uint32 {
	return (volatile.LoadUint32(&o.BSTE.Reg) & 0x4) >> 2
}
func (o *I3C_Type) SetBSTE_NACKDE(value uint32) {
	volatile.StoreUint32(&o.BSTE.Reg, volatile.LoadUint32(&o.BSTE.Reg)&^(0x10)|value<<4)
}
func (o *I3C_Type) GetBSTE_NACKDE() uint32 {
	return (volatile.LoadUint32(&o.BSTE.Reg) & 0x10) >> 4
}
func (o *I3C_Type) SetBSTE_TENDE(value uint32) {
	volatile.StoreUint32(&o.BSTE.Reg, volatile.LoadUint32(&o.BSTE.Reg)&^(0x100)|value<<8)
}
func (o *I3C_Type) GetBSTE_TENDE() uint32 {
	return (volatile.LoadUint32(&o.BSTE.Reg) & 0x100) >> 8
}
func (o *I3C_Type) SetBSTE_ALE(value uint32) {
	volatile.StoreUint32(&o.BSTE.Reg, volatile.LoadUint32(&o.BSTE.Reg)&^(0x10000)|value<<16)
}
func (o *I3C_Type) GetBSTE_ALE() uint32 {
	return (volatile.LoadUint32(&o.BSTE.Reg) & 0x10000) >> 16
}
func (o *I3C_Type) SetBSTE_TODE(value uint32) {
	volatile.StoreUint32(&o.BSTE.Reg, volatile.LoadUint32(&o.BSTE.Reg)&^(0x100000)|value<<20)
}
func (o *I3C_Type) GetBSTE_TODE() uint32 {
	return (volatile.LoadUint32(&o.BSTE.Reg) & 0x100000) >> 20
}

// I3C.BIE: Bus Interrupt Enable Register
func (o *I3C_Type) SetBIE_STCNDDIE(value uint32) {
	volatile.StoreUint32(&o.BIE.Reg, volatile.LoadUint32(&o.BIE.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetBIE_STCNDDIE() uint32 {
	return volatile.LoadUint32(&o.BIE.Reg) & 0x1
}
func (o *I3C_Type) SetBIE_SPCNDDIE(value uint32) {
	volatile.StoreUint32(&o.BIE.Reg, volatile.LoadUint32(&o.BIE.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetBIE_SPCNDDIE() uint32 {
	return (volatile.LoadUint32(&o.BIE.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetBIE_HDREXDIE(value uint32) {
	volatile.StoreUint32(&o.BIE.Reg, volatile.LoadUint32(&o.BIE.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetBIE_HDREXDIE() uint32 {
	return (volatile.LoadUint32(&o.BIE.Reg) & 0x4) >> 2
}
func (o *I3C_Type) SetBIE_NACKDIE(value uint32) {
	volatile.StoreUint32(&o.BIE.Reg, volatile.LoadUint32(&o.BIE.Reg)&^(0x10)|value<<4)
}
func (o *I3C_Type) GetBIE_NACKDIE() uint32 {
	return (volatile.LoadUint32(&o.BIE.Reg) & 0x10) >> 4
}
func (o *I3C_Type) SetBIE_TENDIE(value uint32) {
	volatile.StoreUint32(&o.BIE.Reg, volatile.LoadUint32(&o.BIE.Reg)&^(0x100)|value<<8)
}
func (o *I3C_Type) GetBIE_TENDIE() uint32 {
	return (volatile.LoadUint32(&o.BIE.Reg) & 0x100) >> 8
}
func (o *I3C_Type) SetBIE_ALIE(value uint32) {
	volatile.StoreUint32(&o.BIE.Reg, volatile.LoadUint32(&o.BIE.Reg)&^(0x10000)|value<<16)
}
func (o *I3C_Type) GetBIE_ALIE() uint32 {
	return (volatile.LoadUint32(&o.BIE.Reg) & 0x10000) >> 16
}
func (o *I3C_Type) SetBIE_TODIE(value uint32) {
	volatile.StoreUint32(&o.BIE.Reg, volatile.LoadUint32(&o.BIE.Reg)&^(0x100000)|value<<20)
}
func (o *I3C_Type) GetBIE_TODIE() uint32 {
	return (volatile.LoadUint32(&o.BIE.Reg) & 0x100000) >> 20
}

// I3C.BSTFC: Bus Status Force Register
func (o *I3C_Type) SetBSTFC_STCNDDFC(value uint32) {
	volatile.StoreUint32(&o.BSTFC.Reg, volatile.LoadUint32(&o.BSTFC.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetBSTFC_STCNDDFC() uint32 {
	return volatile.LoadUint32(&o.BSTFC.Reg) & 0x1
}
func (o *I3C_Type) SetBSTFC_SPCNDDFC(value uint32) {
	volatile.StoreUint32(&o.BSTFC.Reg, volatile.LoadUint32(&o.BSTFC.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetBSTFC_SPCNDDFC() uint32 {
	return (volatile.LoadUint32(&o.BSTFC.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetBSTFC_HDREXDFC(value uint32) {
	volatile.StoreUint32(&o.BSTFC.Reg, volatile.LoadUint32(&o.BSTFC.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetBSTFC_HDREXDFC() uint32 {
	return (volatile.LoadUint32(&o.BSTFC.Reg) & 0x4) >> 2
}
func (o *I3C_Type) SetBSTFC_NACKDFC(value uint32) {
	volatile.StoreUint32(&o.BSTFC.Reg, volatile.LoadUint32(&o.BSTFC.Reg)&^(0x10)|value<<4)
}
func (o *I3C_Type) GetBSTFC_NACKDFC() uint32 {
	return (volatile.LoadUint32(&o.BSTFC.Reg) & 0x10) >> 4
}
func (o *I3C_Type) SetBSTFC_TENDFC(value uint32) {
	volatile.StoreUint32(&o.BSTFC.Reg, volatile.LoadUint32(&o.BSTFC.Reg)&^(0x100)|value<<8)
}
func (o *I3C_Type) GetBSTFC_TENDFC() uint32 {
	return (volatile.LoadUint32(&o.BSTFC.Reg) & 0x100) >> 8
}
func (o *I3C_Type) SetBSTFC_ALFC(value uint32) {
	volatile.StoreUint32(&o.BSTFC.Reg, volatile.LoadUint32(&o.BSTFC.Reg)&^(0x10000)|value<<16)
}
func (o *I3C_Type) GetBSTFC_ALFC() uint32 {
	return (volatile.LoadUint32(&o.BSTFC.Reg) & 0x10000) >> 16
}
func (o *I3C_Type) SetBSTFC_TODFC(value uint32) {
	volatile.StoreUint32(&o.BSTFC.Reg, volatile.LoadUint32(&o.BSTFC.Reg)&^(0x100000)|value<<20)
}
func (o *I3C_Type) GetBSTFC_TODFC() uint32 {
	return (volatile.LoadUint32(&o.BSTFC.Reg) & 0x100000) >> 20
}

// I3C.NTST: Normal Transfer Status Register
func (o *I3C_Type) SetNTST_TDBEF0(value uint32) {
	volatile.StoreUint32(&o.NTST.Reg, volatile.LoadUint32(&o.NTST.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetNTST_TDBEF0() uint32 {
	return volatile.LoadUint32(&o.NTST.Reg) & 0x1
}
func (o *I3C_Type) SetNTST_RDBFF0(value uint32) {
	volatile.StoreUint32(&o.NTST.Reg, volatile.LoadUint32(&o.NTST.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetNTST_RDBFF0() uint32 {
	return (volatile.LoadUint32(&o.NTST.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetNTST_IBIQEFF(value uint32) {
	volatile.StoreUint32(&o.NTST.Reg, volatile.LoadUint32(&o.NTST.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetNTST_IBIQEFF() uint32 {
	return (volatile.LoadUint32(&o.NTST.Reg) & 0x4) >> 2
}
func (o *I3C_Type) SetNTST_CMDQEF(value uint32) {
	volatile.StoreUint32(&o.NTST.Reg, volatile.LoadUint32(&o.NTST.Reg)&^(0x8)|value<<3)
}
func (o *I3C_Type) GetNTST_CMDQEF() uint32 {
	return (volatile.LoadUint32(&o.NTST.Reg) & 0x8) >> 3
}
func (o *I3C_Type) SetNTST_RSPQFF(value uint32) {
	volatile.StoreUint32(&o.NTST.Reg, volatile.LoadUint32(&o.NTST.Reg)&^(0x10)|value<<4)
}
func (o *I3C_Type) GetNTST_RSPQFF() uint32 {
	return (volatile.LoadUint32(&o.NTST.Reg) & 0x10) >> 4
}
func (o *I3C_Type) SetNTST_TABTF(value uint32) {
	volatile.StoreUint32(&o.NTST.Reg, volatile.LoadUint32(&o.NTST.Reg)&^(0x20)|value<<5)
}
func (o *I3C_Type) GetNTST_TABTF() uint32 {
	return (volatile.LoadUint32(&o.NTST.Reg) & 0x20) >> 5
}
func (o *I3C_Type) SetNTST_TEF(value uint32) {
	volatile.StoreUint32(&o.NTST.Reg, volatile.LoadUint32(&o.NTST.Reg)&^(0x200)|value<<9)
}
func (o *I3C_Type) GetNTST_TEF() uint32 {
	return (volatile.LoadUint32(&o.NTST.Reg) & 0x200) >> 9
}
func (o *I3C_Type) SetNTST_RSQFF(value uint32) {
	volatile.StoreUint32(&o.NTST.Reg, volatile.LoadUint32(&o.NTST.Reg)&^(0x100000)|value<<20)
}
func (o *I3C_Type) GetNTST_RSQFF() uint32 {
	return (volatile.LoadUint32(&o.NTST.Reg) & 0x100000) >> 20
}

// I3C.NTSTE: Normal Transfer Status Enable Register
func (o *I3C_Type) SetNTSTE_TDBEE0(value uint32) {
	volatile.StoreUint32(&o.NTSTE.Reg, volatile.LoadUint32(&o.NTSTE.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetNTSTE_TDBEE0() uint32 {
	return volatile.LoadUint32(&o.NTSTE.Reg) & 0x1
}
func (o *I3C_Type) SetNTSTE_RDBFE0(value uint32) {
	volatile.StoreUint32(&o.NTSTE.Reg, volatile.LoadUint32(&o.NTSTE.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetNTSTE_RDBFE0() uint32 {
	return (volatile.LoadUint32(&o.NTSTE.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetNTSTE_IBIQEFE(value uint32) {
	volatile.StoreUint32(&o.NTSTE.Reg, volatile.LoadUint32(&o.NTSTE.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetNTSTE_IBIQEFE() uint32 {
	return (volatile.LoadUint32(&o.NTSTE.Reg) & 0x4) >> 2
}
func (o *I3C_Type) SetNTSTE_CMDQEE(value uint32) {
	volatile.StoreUint32(&o.NTSTE.Reg, volatile.LoadUint32(&o.NTSTE.Reg)&^(0x8)|value<<3)
}
func (o *I3C_Type) GetNTSTE_CMDQEE() uint32 {
	return (volatile.LoadUint32(&o.NTSTE.Reg) & 0x8) >> 3
}
func (o *I3C_Type) SetNTSTE_RSPQFE(value uint32) {
	volatile.StoreUint32(&o.NTSTE.Reg, volatile.LoadUint32(&o.NTSTE.Reg)&^(0x10)|value<<4)
}
func (o *I3C_Type) GetNTSTE_RSPQFE() uint32 {
	return (volatile.LoadUint32(&o.NTSTE.Reg) & 0x10) >> 4
}
func (o *I3C_Type) SetNTSTE_TABTE(value uint32) {
	volatile.StoreUint32(&o.NTSTE.Reg, volatile.LoadUint32(&o.NTSTE.Reg)&^(0x20)|value<<5)
}
func (o *I3C_Type) GetNTSTE_TABTE() uint32 {
	return (volatile.LoadUint32(&o.NTSTE.Reg) & 0x20) >> 5
}
func (o *I3C_Type) SetNTSTE_TEE(value uint32) {
	volatile.StoreUint32(&o.NTSTE.Reg, volatile.LoadUint32(&o.NTSTE.Reg)&^(0x200)|value<<9)
}
func (o *I3C_Type) GetNTSTE_TEE() uint32 {
	return (volatile.LoadUint32(&o.NTSTE.Reg) & 0x200) >> 9
}
func (o *I3C_Type) SetNTSTE_RSQFE(value uint32) {
	volatile.StoreUint32(&o.NTSTE.Reg, volatile.LoadUint32(&o.NTSTE.Reg)&^(0x100000)|value<<20)
}
func (o *I3C_Type) GetNTSTE_RSQFE() uint32 {
	return (volatile.LoadUint32(&o.NTSTE.Reg) & 0x100000) >> 20
}

// I3C.NTIE: Normal Transfer Interrupt Enable Register
func (o *I3C_Type) SetNTIE_TDBEIE0(value uint32) {
	volatile.StoreUint32(&o.NTIE.Reg, volatile.LoadUint32(&o.NTIE.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetNTIE_TDBEIE0() uint32 {
	return volatile.LoadUint32(&o.NTIE.Reg) & 0x1
}
func (o *I3C_Type) SetNTIE_RDBFIE0(value uint32) {
	volatile.StoreUint32(&o.NTIE.Reg, volatile.LoadUint32(&o.NTIE.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetNTIE_RDBFIE0() uint32 {
	return (volatile.LoadUint32(&o.NTIE.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetNTIE_IBIQEFIE(value uint32) {
	volatile.StoreUint32(&o.NTIE.Reg, volatile.LoadUint32(&o.NTIE.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetNTIE_IBIQEFIE() uint32 {
	return (volatile.LoadUint32(&o.NTIE.Reg) & 0x4) >> 2
}
func (o *I3C_Type) SetNTIE_CMDQEIE(value uint32) {
	volatile.StoreUint32(&o.NTIE.Reg, volatile.LoadUint32(&o.NTIE.Reg)&^(0x8)|value<<3)
}
func (o *I3C_Type) GetNTIE_CMDQEIE() uint32 {
	return (volatile.LoadUint32(&o.NTIE.Reg) & 0x8) >> 3
}
func (o *I3C_Type) SetNTIE_RSPQFIE(value uint32) {
	volatile.StoreUint32(&o.NTIE.Reg, volatile.LoadUint32(&o.NTIE.Reg)&^(0x10)|value<<4)
}
func (o *I3C_Type) GetNTIE_RSPQFIE() uint32 {
	return (volatile.LoadUint32(&o.NTIE.Reg) & 0x10) >> 4
}
func (o *I3C_Type) SetNTIE_TABTIE(value uint32) {
	volatile.StoreUint32(&o.NTIE.Reg, volatile.LoadUint32(&o.NTIE.Reg)&^(0x20)|value<<5)
}
func (o *I3C_Type) GetNTIE_TABTIE() uint32 {
	return (volatile.LoadUint32(&o.NTIE.Reg) & 0x20) >> 5
}
func (o *I3C_Type) SetNTIE_TEIE(value uint32) {
	volatile.StoreUint32(&o.NTIE.Reg, volatile.LoadUint32(&o.NTIE.Reg)&^(0x200)|value<<9)
}
func (o *I3C_Type) GetNTIE_TEIE() uint32 {
	return (volatile.LoadUint32(&o.NTIE.Reg) & 0x200) >> 9
}
func (o *I3C_Type) SetNTIE_RSQFIE(value uint32) {
	volatile.StoreUint32(&o.NTIE.Reg, volatile.LoadUint32(&o.NTIE.Reg)&^(0x100000)|value<<20)
}
func (o *I3C_Type) GetNTIE_RSQFIE() uint32 {
	return (volatile.LoadUint32(&o.NTIE.Reg) & 0x100000) >> 20
}

// I3C.NTSTFC: Normal Transfer Status Force Register
func (o *I3C_Type) SetNTSTFC_TDBEFC0(value uint32) {
	volatile.StoreUint32(&o.NTSTFC.Reg, volatile.LoadUint32(&o.NTSTFC.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetNTSTFC_TDBEFC0() uint32 {
	return volatile.LoadUint32(&o.NTSTFC.Reg) & 0x1
}
func (o *I3C_Type) SetNTSTFC_RDBFFC0(value uint32) {
	volatile.StoreUint32(&o.NTSTFC.Reg, volatile.LoadUint32(&o.NTSTFC.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetNTSTFC_RDBFFC0() uint32 {
	return (volatile.LoadUint32(&o.NTSTFC.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetNTSTFC_IBIQEFFC(value uint32) {
	volatile.StoreUint32(&o.NTSTFC.Reg, volatile.LoadUint32(&o.NTSTFC.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetNTSTFC_IBIQEFFC() uint32 {
	return (volatile.LoadUint32(&o.NTSTFC.Reg) & 0x4) >> 2
}
func (o *I3C_Type) SetNTSTFC_CMDQEFC(value uint32) {
	volatile.StoreUint32(&o.NTSTFC.Reg, volatile.LoadUint32(&o.NTSTFC.Reg)&^(0x8)|value<<3)
}
func (o *I3C_Type) GetNTSTFC_CMDQEFC() uint32 {
	return (volatile.LoadUint32(&o.NTSTFC.Reg) & 0x8) >> 3
}
func (o *I3C_Type) SetNTSTFC_RSPQFFC(value uint32) {
	volatile.StoreUint32(&o.NTSTFC.Reg, volatile.LoadUint32(&o.NTSTFC.Reg)&^(0x10)|value<<4)
}
func (o *I3C_Type) GetNTSTFC_RSPQFFC() uint32 {
	return (volatile.LoadUint32(&o.NTSTFC.Reg) & 0x10) >> 4
}
func (o *I3C_Type) SetNTSTFC_TABTFC(value uint32) {
	volatile.StoreUint32(&o.NTSTFC.Reg, volatile.LoadUint32(&o.NTSTFC.Reg)&^(0x20)|value<<5)
}
func (o *I3C_Type) GetNTSTFC_TABTFC() uint32 {
	return (volatile.LoadUint32(&o.NTSTFC.Reg) & 0x20) >> 5
}
func (o *I3C_Type) SetNTSTFC_TEFC(value uint32) {
	volatile.StoreUint32(&o.NTSTFC.Reg, volatile.LoadUint32(&o.NTSTFC.Reg)&^(0x200)|value<<9)
}
func (o *I3C_Type) GetNTSTFC_TEFC() uint32 {
	return (volatile.LoadUint32(&o.NTSTFC.Reg) & 0x200) >> 9
}
func (o *I3C_Type) SetNTSTFC_RSQFFC(value uint32) {
	volatile.StoreUint32(&o.NTSTFC.Reg, volatile.LoadUint32(&o.NTSTFC.Reg)&^(0x100000)|value<<20)
}
func (o *I3C_Type) GetNTSTFC_RSQFFC() uint32 {
	return (volatile.LoadUint32(&o.NTSTFC.Reg) & 0x100000) >> 20
}

// I3C.BCST: Bus Condition Status Register
func (o *I3C_Type) SetBCST_BFREF(value uint32) {
	volatile.StoreUint32(&o.BCST.Reg, volatile.LoadUint32(&o.BCST.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetBCST_BFREF() uint32 {
	return volatile.LoadUint32(&o.BCST.Reg) & 0x1
}
func (o *I3C_Type) SetBCST_BAVLF(value uint32) {
	volatile.StoreUint32(&o.BCST.Reg, volatile.LoadUint32(&o.BCST.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetBCST_BAVLF() uint32 {
	return (volatile.LoadUint32(&o.BCST.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetBCST_BIDLF(value uint32) {
	volatile.StoreUint32(&o.BCST.Reg, volatile.LoadUint32(&o.BCST.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetBCST_BIDLF() uint32 {
	return (volatile.LoadUint32(&o.BCST.Reg) & 0x4) >> 2
}

// I3C.SVST: Slave Status Register
func (o *I3C_Type) SetSVST_GCAF(value uint32) {
	volatile.StoreUint32(&o.SVST.Reg, volatile.LoadUint32(&o.SVST.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetSVST_GCAF() uint32 {
	return volatile.LoadUint32(&o.SVST.Reg) & 0x1
}
func (o *I3C_Type) SetSVST_HSMCF(value uint32) {
	volatile.StoreUint32(&o.SVST.Reg, volatile.LoadUint32(&o.SVST.Reg)&^(0x20)|value<<5)
}
func (o *I3C_Type) GetSVST_HSMCF() uint32 {
	return (volatile.LoadUint32(&o.SVST.Reg) & 0x20) >> 5
}
func (o *I3C_Type) SetSVST_DVIDF(value uint32) {
	volatile.StoreUint32(&o.SVST.Reg, volatile.LoadUint32(&o.SVST.Reg)&^(0x40)|value<<6)
}
func (o *I3C_Type) GetSVST_DVIDF() uint32 {
	return (volatile.LoadUint32(&o.SVST.Reg) & 0x40) >> 6
}
func (o *I3C_Type) SetSVST_HOAF(value uint32) {
	volatile.StoreUint32(&o.SVST.Reg, volatile.LoadUint32(&o.SVST.Reg)&^(0x8000)|value<<15)
}
func (o *I3C_Type) GetSVST_HOAF() uint32 {
	return (volatile.LoadUint32(&o.SVST.Reg) & 0x8000) >> 15
}
func (o *I3C_Type) SetSVST_SVAF0(value uint32) {
	volatile.StoreUint32(&o.SVST.Reg, volatile.LoadUint32(&o.SVST.Reg)&^(0x10000)|value<<16)
}
func (o *I3C_Type) GetSVST_SVAF0() uint32 {
	return (volatile.LoadUint32(&o.SVST.Reg) & 0x10000) >> 16
}

// I3C.DATBAS0: Device Address Table Basic Register %s
func (o *I3C_Type) SetDATBAS0_DVSTAD(value uint32) {
	volatile.StoreUint32(&o.DATBAS0.Reg, volatile.LoadUint32(&o.DATBAS0.Reg)&^(0x7f)|value)
}
func (o *I3C_Type) GetDATBAS0_DVSTAD() uint32 {
	return volatile.LoadUint32(&o.DATBAS0.Reg) & 0x7f
}
func (o *I3C_Type) SetDATBAS0_DVIBIPL(value uint32) {
	volatile.StoreUint32(&o.DATBAS0.Reg, volatile.LoadUint32(&o.DATBAS0.Reg)&^(0x1000)|value<<12)
}
func (o *I3C_Type) GetDATBAS0_DVIBIPL() uint32 {
	return (volatile.LoadUint32(&o.DATBAS0.Reg) & 0x1000) >> 12
}
func (o *I3C_Type) SetDATBAS0_DVSIRRJ(value uint32) {
	volatile.StoreUint32(&o.DATBAS0.Reg, volatile.LoadUint32(&o.DATBAS0.Reg)&^(0x2000)|value<<13)
}
func (o *I3C_Type) GetDATBAS0_DVSIRRJ() uint32 {
	return (volatile.LoadUint32(&o.DATBAS0.Reg) & 0x2000) >> 13
}
func (o *I3C_Type) SetDATBAS0_DVMRRJ(value uint32) {
	volatile.StoreUint32(&o.DATBAS0.Reg, volatile.LoadUint32(&o.DATBAS0.Reg)&^(0x4000)|value<<14)
}
func (o *I3C_Type) GetDATBAS0_DVMRRJ() uint32 {
	return (volatile.LoadUint32(&o.DATBAS0.Reg) & 0x4000) >> 14
}
func (o *I3C_Type) SetDATBAS0_DVDYAD(value uint32) {
	volatile.StoreUint32(&o.DATBAS0.Reg, volatile.LoadUint32(&o.DATBAS0.Reg)&^(0xff0000)|value<<16)
}
func (o *I3C_Type) GetDATBAS0_DVDYAD() uint32 {
	return (volatile.LoadUint32(&o.DATBAS0.Reg) & 0xff0000) >> 16
}
func (o *I3C_Type) SetDATBAS0_DVNACK(value uint32) {
	volatile.StoreUint32(&o.DATBAS0.Reg, volatile.LoadUint32(&o.DATBAS0.Reg)&^(0x60000000)|value<<29)
}
func (o *I3C_Type) GetDATBAS0_DVNACK() uint32 {
	return (volatile.LoadUint32(&o.DATBAS0.Reg) & 0x60000000) >> 29
}
func (o *I3C_Type) SetDATBAS0_DVTYP(value uint32) {
	volatile.StoreUint32(&o.DATBAS0.Reg, volatile.LoadUint32(&o.DATBAS0.Reg)&^(0x80000000)|value<<31)
}
func (o *I3C_Type) GetDATBAS0_DVTYP() uint32 {
	return (volatile.LoadUint32(&o.DATBAS0.Reg) & 0x80000000) >> 31
}

// I3C.DATBAS1: Device Address Table Basic Register %s
func (o *I3C_Type) SetDATBAS1_DVSTAD(value uint32) {
	volatile.StoreUint32(&o.DATBAS1.Reg, volatile.LoadUint32(&o.DATBAS1.Reg)&^(0x7f)|value)
}
func (o *I3C_Type) GetDATBAS1_DVSTAD() uint32 {
	return volatile.LoadUint32(&o.DATBAS1.Reg) & 0x7f
}
func (o *I3C_Type) SetDATBAS1_DVIBIPL(value uint32) {
	volatile.StoreUint32(&o.DATBAS1.Reg, volatile.LoadUint32(&o.DATBAS1.Reg)&^(0x1000)|value<<12)
}
func (o *I3C_Type) GetDATBAS1_DVIBIPL() uint32 {
	return (volatile.LoadUint32(&o.DATBAS1.Reg) & 0x1000) >> 12
}
func (o *I3C_Type) SetDATBAS1_DVSIRRJ(value uint32) {
	volatile.StoreUint32(&o.DATBAS1.Reg, volatile.LoadUint32(&o.DATBAS1.Reg)&^(0x2000)|value<<13)
}
func (o *I3C_Type) GetDATBAS1_DVSIRRJ() uint32 {
	return (volatile.LoadUint32(&o.DATBAS1.Reg) & 0x2000) >> 13
}
func (o *I3C_Type) SetDATBAS1_DVMRRJ(value uint32) {
	volatile.StoreUint32(&o.DATBAS1.Reg, volatile.LoadUint32(&o.DATBAS1.Reg)&^(0x4000)|value<<14)
}
func (o *I3C_Type) GetDATBAS1_DVMRRJ() uint32 {
	return (volatile.LoadUint32(&o.DATBAS1.Reg) & 0x4000) >> 14
}
func (o *I3C_Type) SetDATBAS1_DVDYAD(value uint32) {
	volatile.StoreUint32(&o.DATBAS1.Reg, volatile.LoadUint32(&o.DATBAS1.Reg)&^(0xff0000)|value<<16)
}
func (o *I3C_Type) GetDATBAS1_DVDYAD() uint32 {
	return (volatile.LoadUint32(&o.DATBAS1.Reg) & 0xff0000) >> 16
}
func (o *I3C_Type) SetDATBAS1_DVNACK(value uint32) {
	volatile.StoreUint32(&o.DATBAS1.Reg, volatile.LoadUint32(&o.DATBAS1.Reg)&^(0x60000000)|value<<29)
}
func (o *I3C_Type) GetDATBAS1_DVNACK() uint32 {
	return (volatile.LoadUint32(&o.DATBAS1.Reg) & 0x60000000) >> 29
}
func (o *I3C_Type) SetDATBAS1_DVTYP(value uint32) {
	volatile.StoreUint32(&o.DATBAS1.Reg, volatile.LoadUint32(&o.DATBAS1.Reg)&^(0x80000000)|value<<31)
}
func (o *I3C_Type) GetDATBAS1_DVTYP() uint32 {
	return (volatile.LoadUint32(&o.DATBAS1.Reg) & 0x80000000) >> 31
}

// I3C.DATBAS2: Device Address Table Basic Register %s
func (o *I3C_Type) SetDATBAS2_DVSTAD(value uint32) {
	volatile.StoreUint32(&o.DATBAS2.Reg, volatile.LoadUint32(&o.DATBAS2.Reg)&^(0x7f)|value)
}
func (o *I3C_Type) GetDATBAS2_DVSTAD() uint32 {
	return volatile.LoadUint32(&o.DATBAS2.Reg) & 0x7f
}
func (o *I3C_Type) SetDATBAS2_DVIBIPL(value uint32) {
	volatile.StoreUint32(&o.DATBAS2.Reg, volatile.LoadUint32(&o.DATBAS2.Reg)&^(0x1000)|value<<12)
}
func (o *I3C_Type) GetDATBAS2_DVIBIPL() uint32 {
	return (volatile.LoadUint32(&o.DATBAS2.Reg) & 0x1000) >> 12
}
func (o *I3C_Type) SetDATBAS2_DVSIRRJ(value uint32) {
	volatile.StoreUint32(&o.DATBAS2.Reg, volatile.LoadUint32(&o.DATBAS2.Reg)&^(0x2000)|value<<13)
}
func (o *I3C_Type) GetDATBAS2_DVSIRRJ() uint32 {
	return (volatile.LoadUint32(&o.DATBAS2.Reg) & 0x2000) >> 13
}
func (o *I3C_Type) SetDATBAS2_DVMRRJ(value uint32) {
	volatile.StoreUint32(&o.DATBAS2.Reg, volatile.LoadUint32(&o.DATBAS2.Reg)&^(0x4000)|value<<14)
}
func (o *I3C_Type) GetDATBAS2_DVMRRJ() uint32 {
	return (volatile.LoadUint32(&o.DATBAS2.Reg) & 0x4000) >> 14
}
func (o *I3C_Type) SetDATBAS2_DVDYAD(value uint32) {
	volatile.StoreUint32(&o.DATBAS2.Reg, volatile.LoadUint32(&o.DATBAS2.Reg)&^(0xff0000)|value<<16)
}
func (o *I3C_Type) GetDATBAS2_DVDYAD() uint32 {
	return (volatile.LoadUint32(&o.DATBAS2.Reg) & 0xff0000) >> 16
}
func (o *I3C_Type) SetDATBAS2_DVNACK(value uint32) {
	volatile.StoreUint32(&o.DATBAS2.Reg, volatile.LoadUint32(&o.DATBAS2.Reg)&^(0x60000000)|value<<29)
}
func (o *I3C_Type) GetDATBAS2_DVNACK() uint32 {
	return (volatile.LoadUint32(&o.DATBAS2.Reg) & 0x60000000) >> 29
}
func (o *I3C_Type) SetDATBAS2_DVTYP(value uint32) {
	volatile.StoreUint32(&o.DATBAS2.Reg, volatile.LoadUint32(&o.DATBAS2.Reg)&^(0x80000000)|value<<31)
}
func (o *I3C_Type) GetDATBAS2_DVTYP() uint32 {
	return (volatile.LoadUint32(&o.DATBAS2.Reg) & 0x80000000) >> 31
}

// I3C.DATBAS3: Device Address Table Basic Register %s
func (o *I3C_Type) SetDATBAS3_DVSTAD(value uint32) {
	volatile.StoreUint32(&o.DATBAS3.Reg, volatile.LoadUint32(&o.DATBAS3.Reg)&^(0x7f)|value)
}
func (o *I3C_Type) GetDATBAS3_DVSTAD() uint32 {
	return volatile.LoadUint32(&o.DATBAS3.Reg) & 0x7f
}
func (o *I3C_Type) SetDATBAS3_DVIBIPL(value uint32) {
	volatile.StoreUint32(&o.DATBAS3.Reg, volatile.LoadUint32(&o.DATBAS3.Reg)&^(0x1000)|value<<12)
}
func (o *I3C_Type) GetDATBAS3_DVIBIPL() uint32 {
	return (volatile.LoadUint32(&o.DATBAS3.Reg) & 0x1000) >> 12
}
func (o *I3C_Type) SetDATBAS3_DVSIRRJ(value uint32) {
	volatile.StoreUint32(&o.DATBAS3.Reg, volatile.LoadUint32(&o.DATBAS3.Reg)&^(0x2000)|value<<13)
}
func (o *I3C_Type) GetDATBAS3_DVSIRRJ() uint32 {
	return (volatile.LoadUint32(&o.DATBAS3.Reg) & 0x2000) >> 13
}
func (o *I3C_Type) SetDATBAS3_DVMRRJ(value uint32) {
	volatile.StoreUint32(&o.DATBAS3.Reg, volatile.LoadUint32(&o.DATBAS3.Reg)&^(0x4000)|value<<14)
}
func (o *I3C_Type) GetDATBAS3_DVMRRJ() uint32 {
	return (volatile.LoadUint32(&o.DATBAS3.Reg) & 0x4000) >> 14
}
func (o *I3C_Type) SetDATBAS3_DVDYAD(value uint32) {
	volatile.StoreUint32(&o.DATBAS3.Reg, volatile.LoadUint32(&o.DATBAS3.Reg)&^(0xff0000)|value<<16)
}
func (o *I3C_Type) GetDATBAS3_DVDYAD() uint32 {
	return (volatile.LoadUint32(&o.DATBAS3.Reg) & 0xff0000) >> 16
}
func (o *I3C_Type) SetDATBAS3_DVNACK(value uint32) {
	volatile.StoreUint32(&o.DATBAS3.Reg, volatile.LoadUint32(&o.DATBAS3.Reg)&^(0x60000000)|value<<29)
}
func (o *I3C_Type) GetDATBAS3_DVNACK() uint32 {
	return (volatile.LoadUint32(&o.DATBAS3.Reg) & 0x60000000) >> 29
}
func (o *I3C_Type) SetDATBAS3_DVTYP(value uint32) {
	volatile.StoreUint32(&o.DATBAS3.Reg, volatile.LoadUint32(&o.DATBAS3.Reg)&^(0x80000000)|value<<31)
}
func (o *I3C_Type) GetDATBAS3_DVTYP() uint32 {
	return (volatile.LoadUint32(&o.DATBAS3.Reg) & 0x80000000) >> 31
}

// I3C.EXDATBAS: Extended Device Address Table Basic Register
func (o *I3C_Type) SetEXDATBAS_EDSTAD(value uint32) {
	volatile.StoreUint32(&o.EXDATBAS.Reg, volatile.LoadUint32(&o.EXDATBAS.Reg)&^(0x7f)|value)
}
func (o *I3C_Type) GetEXDATBAS_EDSTAD() uint32 {
	return volatile.LoadUint32(&o.EXDATBAS.Reg) & 0x7f
}
func (o *I3C_Type) SetEXDATBAS_EDDYAD(value uint32) {
	volatile.StoreUint32(&o.EXDATBAS.Reg, volatile.LoadUint32(&o.EXDATBAS.Reg)&^(0xff0000)|value<<16)
}
func (o *I3C_Type) GetEXDATBAS_EDDYAD() uint32 {
	return (volatile.LoadUint32(&o.EXDATBAS.Reg) & 0xff0000) >> 16
}
func (o *I3C_Type) SetEXDATBAS_EDNACK(value uint32) {
	volatile.StoreUint32(&o.EXDATBAS.Reg, volatile.LoadUint32(&o.EXDATBAS.Reg)&^(0x60000000)|value<<29)
}
func (o *I3C_Type) GetEXDATBAS_EDNACK() uint32 {
	return (volatile.LoadUint32(&o.EXDATBAS.Reg) & 0x60000000) >> 29
}
func (o *I3C_Type) SetEXDATBAS_EDTYP(value uint32) {
	volatile.StoreUint32(&o.EXDATBAS.Reg, volatile.LoadUint32(&o.EXDATBAS.Reg)&^(0x80000000)|value<<31)
}
func (o *I3C_Type) GetEXDATBAS_EDTYP() uint32 {
	return (volatile.LoadUint32(&o.EXDATBAS.Reg) & 0x80000000) >> 31
}

// I3C.SDATBAS0: Slave Device Address Table Basic Register 0
func (o *I3C_Type) SetSDATBAS0_SDSTAD(value uint32) {
	volatile.StoreUint32(&o.SDATBAS0.Reg, volatile.LoadUint32(&o.SDATBAS0.Reg)&^(0x3ff)|value)
}
func (o *I3C_Type) GetSDATBAS0_SDSTAD() uint32 {
	return volatile.LoadUint32(&o.SDATBAS0.Reg) & 0x3ff
}
func (o *I3C_Type) SetSDATBAS0_SDADLS(value uint32) {
	volatile.StoreUint32(&o.SDATBAS0.Reg, volatile.LoadUint32(&o.SDATBAS0.Reg)&^(0x400)|value<<10)
}
func (o *I3C_Type) GetSDATBAS0_SDADLS() uint32 {
	return (volatile.LoadUint32(&o.SDATBAS0.Reg) & 0x400) >> 10
}
func (o *I3C_Type) SetSDATBAS0_SDIBIPL(value uint32) {
	volatile.StoreUint32(&o.SDATBAS0.Reg, volatile.LoadUint32(&o.SDATBAS0.Reg)&^(0x1000)|value<<12)
}
func (o *I3C_Type) GetSDATBAS0_SDIBIPL() uint32 {
	return (volatile.LoadUint32(&o.SDATBAS0.Reg) & 0x1000) >> 12
}
func (o *I3C_Type) SetSDATBAS0_SDDYAD(value uint32) {
	volatile.StoreUint32(&o.SDATBAS0.Reg, volatile.LoadUint32(&o.SDATBAS0.Reg)&^(0x7f0000)|value<<16)
}
func (o *I3C_Type) GetSDATBAS0_SDDYAD() uint32 {
	return (volatile.LoadUint32(&o.SDATBAS0.Reg) & 0x7f0000) >> 16
}

// I3C.MSDCT0: Master Device Characteristic Table Register %s
func (o *I3C_Type) SetMSDCT0_RBCR0(value uint32) {
	volatile.StoreUint32(&o.MSDCT0.Reg, volatile.LoadUint32(&o.MSDCT0.Reg)&^(0x100)|value<<8)
}
func (o *I3C_Type) GetMSDCT0_RBCR0() uint32 {
	return (volatile.LoadUint32(&o.MSDCT0.Reg) & 0x100) >> 8
}
func (o *I3C_Type) SetMSDCT0_RBCR1(value uint32) {
	volatile.StoreUint32(&o.MSDCT0.Reg, volatile.LoadUint32(&o.MSDCT0.Reg)&^(0x200)|value<<9)
}
func (o *I3C_Type) GetMSDCT0_RBCR1() uint32 {
	return (volatile.LoadUint32(&o.MSDCT0.Reg) & 0x200) >> 9
}
func (o *I3C_Type) SetMSDCT0_RBCR2(value uint32) {
	volatile.StoreUint32(&o.MSDCT0.Reg, volatile.LoadUint32(&o.MSDCT0.Reg)&^(0x400)|value<<10)
}
func (o *I3C_Type) GetMSDCT0_RBCR2() uint32 {
	return (volatile.LoadUint32(&o.MSDCT0.Reg) & 0x400) >> 10
}
func (o *I3C_Type) SetMSDCT0_RBCR3(value uint32) {
	volatile.StoreUint32(&o.MSDCT0.Reg, volatile.LoadUint32(&o.MSDCT0.Reg)&^(0x800)|value<<11)
}
func (o *I3C_Type) GetMSDCT0_RBCR3() uint32 {
	return (volatile.LoadUint32(&o.MSDCT0.Reg) & 0x800) >> 11
}
func (o *I3C_Type) SetMSDCT0_RBCR76(value uint32) {
	volatile.StoreUint32(&o.MSDCT0.Reg, volatile.LoadUint32(&o.MSDCT0.Reg)&^(0xc000)|value<<14)
}
func (o *I3C_Type) GetMSDCT0_RBCR76() uint32 {
	return (volatile.LoadUint32(&o.MSDCT0.Reg) & 0xc000) >> 14
}

// I3C.MSDCT1: Master Device Characteristic Table Register %s
func (o *I3C_Type) SetMSDCT1_RBCR0(value uint32) {
	volatile.StoreUint32(&o.MSDCT1.Reg, volatile.LoadUint32(&o.MSDCT1.Reg)&^(0x100)|value<<8)
}
func (o *I3C_Type) GetMSDCT1_RBCR0() uint32 {
	return (volatile.LoadUint32(&o.MSDCT1.Reg) & 0x100) >> 8
}
func (o *I3C_Type) SetMSDCT1_RBCR1(value uint32) {
	volatile.StoreUint32(&o.MSDCT1.Reg, volatile.LoadUint32(&o.MSDCT1.Reg)&^(0x200)|value<<9)
}
func (o *I3C_Type) GetMSDCT1_RBCR1() uint32 {
	return (volatile.LoadUint32(&o.MSDCT1.Reg) & 0x200) >> 9
}
func (o *I3C_Type) SetMSDCT1_RBCR2(value uint32) {
	volatile.StoreUint32(&o.MSDCT1.Reg, volatile.LoadUint32(&o.MSDCT1.Reg)&^(0x400)|value<<10)
}
func (o *I3C_Type) GetMSDCT1_RBCR2() uint32 {
	return (volatile.LoadUint32(&o.MSDCT1.Reg) & 0x400) >> 10
}
func (o *I3C_Type) SetMSDCT1_RBCR3(value uint32) {
	volatile.StoreUint32(&o.MSDCT1.Reg, volatile.LoadUint32(&o.MSDCT1.Reg)&^(0x800)|value<<11)
}
func (o *I3C_Type) GetMSDCT1_RBCR3() uint32 {
	return (volatile.LoadUint32(&o.MSDCT1.Reg) & 0x800) >> 11
}
func (o *I3C_Type) SetMSDCT1_RBCR76(value uint32) {
	volatile.StoreUint32(&o.MSDCT1.Reg, volatile.LoadUint32(&o.MSDCT1.Reg)&^(0xc000)|value<<14)
}
func (o *I3C_Type) GetMSDCT1_RBCR76() uint32 {
	return (volatile.LoadUint32(&o.MSDCT1.Reg) & 0xc000) >> 14
}

// I3C.MSDCT2: Master Device Characteristic Table Register %s
func (o *I3C_Type) SetMSDCT2_RBCR0(value uint32) {
	volatile.StoreUint32(&o.MSDCT2.Reg, volatile.LoadUint32(&o.MSDCT2.Reg)&^(0x100)|value<<8)
}
func (o *I3C_Type) GetMSDCT2_RBCR0() uint32 {
	return (volatile.LoadUint32(&o.MSDCT2.Reg) & 0x100) >> 8
}
func (o *I3C_Type) SetMSDCT2_RBCR1(value uint32) {
	volatile.StoreUint32(&o.MSDCT2.Reg, volatile.LoadUint32(&o.MSDCT2.Reg)&^(0x200)|value<<9)
}
func (o *I3C_Type) GetMSDCT2_RBCR1() uint32 {
	return (volatile.LoadUint32(&o.MSDCT2.Reg) & 0x200) >> 9
}
func (o *I3C_Type) SetMSDCT2_RBCR2(value uint32) {
	volatile.StoreUint32(&o.MSDCT2.Reg, volatile.LoadUint32(&o.MSDCT2.Reg)&^(0x400)|value<<10)
}
func (o *I3C_Type) GetMSDCT2_RBCR2() uint32 {
	return (volatile.LoadUint32(&o.MSDCT2.Reg) & 0x400) >> 10
}
func (o *I3C_Type) SetMSDCT2_RBCR3(value uint32) {
	volatile.StoreUint32(&o.MSDCT2.Reg, volatile.LoadUint32(&o.MSDCT2.Reg)&^(0x800)|value<<11)
}
func (o *I3C_Type) GetMSDCT2_RBCR3() uint32 {
	return (volatile.LoadUint32(&o.MSDCT2.Reg) & 0x800) >> 11
}
func (o *I3C_Type) SetMSDCT2_RBCR76(value uint32) {
	volatile.StoreUint32(&o.MSDCT2.Reg, volatile.LoadUint32(&o.MSDCT2.Reg)&^(0xc000)|value<<14)
}
func (o *I3C_Type) GetMSDCT2_RBCR76() uint32 {
	return (volatile.LoadUint32(&o.MSDCT2.Reg) & 0xc000) >> 14
}

// I3C.MSDCT3: Master Device Characteristic Table Register %s
func (o *I3C_Type) SetMSDCT3_RBCR0(value uint32) {
	volatile.StoreUint32(&o.MSDCT3.Reg, volatile.LoadUint32(&o.MSDCT3.Reg)&^(0x100)|value<<8)
}
func (o *I3C_Type) GetMSDCT3_RBCR0() uint32 {
	return (volatile.LoadUint32(&o.MSDCT3.Reg) & 0x100) >> 8
}
func (o *I3C_Type) SetMSDCT3_RBCR1(value uint32) {
	volatile.StoreUint32(&o.MSDCT3.Reg, volatile.LoadUint32(&o.MSDCT3.Reg)&^(0x200)|value<<9)
}
func (o *I3C_Type) GetMSDCT3_RBCR1() uint32 {
	return (volatile.LoadUint32(&o.MSDCT3.Reg) & 0x200) >> 9
}
func (o *I3C_Type) SetMSDCT3_RBCR2(value uint32) {
	volatile.StoreUint32(&o.MSDCT3.Reg, volatile.LoadUint32(&o.MSDCT3.Reg)&^(0x400)|value<<10)
}
func (o *I3C_Type) GetMSDCT3_RBCR2() uint32 {
	return (volatile.LoadUint32(&o.MSDCT3.Reg) & 0x400) >> 10
}
func (o *I3C_Type) SetMSDCT3_RBCR3(value uint32) {
	volatile.StoreUint32(&o.MSDCT3.Reg, volatile.LoadUint32(&o.MSDCT3.Reg)&^(0x800)|value<<11)
}
func (o *I3C_Type) GetMSDCT3_RBCR3() uint32 {
	return (volatile.LoadUint32(&o.MSDCT3.Reg) & 0x800) >> 11
}
func (o *I3C_Type) SetMSDCT3_RBCR76(value uint32) {
	volatile.StoreUint32(&o.MSDCT3.Reg, volatile.LoadUint32(&o.MSDCT3.Reg)&^(0xc000)|value<<14)
}
func (o *I3C_Type) GetMSDCT3_RBCR76() uint32 {
	return (volatile.LoadUint32(&o.MSDCT3.Reg) & 0xc000) >> 14
}

// I3C.SVDCT: Slave Device Characteristic Table Register
func (o *I3C_Type) SetSVDCT_TDCR(value uint32) {
	volatile.StoreUint32(&o.SVDCT.Reg, volatile.LoadUint32(&o.SVDCT.Reg)&^(0xff)|value)
}
func (o *I3C_Type) GetSVDCT_TDCR() uint32 {
	return volatile.LoadUint32(&o.SVDCT.Reg) & 0xff
}
func (o *I3C_Type) SetSVDCT_TBCR0(value uint32) {
	volatile.StoreUint32(&o.SVDCT.Reg, volatile.LoadUint32(&o.SVDCT.Reg)&^(0x100)|value<<8)
}
func (o *I3C_Type) GetSVDCT_TBCR0() uint32 {
	return (volatile.LoadUint32(&o.SVDCT.Reg) & 0x100) >> 8
}
func (o *I3C_Type) SetSVDCT_TBCR1(value uint32) {
	volatile.StoreUint32(&o.SVDCT.Reg, volatile.LoadUint32(&o.SVDCT.Reg)&^(0x200)|value<<9)
}
func (o *I3C_Type) GetSVDCT_TBCR1() uint32 {
	return (volatile.LoadUint32(&o.SVDCT.Reg) & 0x200) >> 9
}
func (o *I3C_Type) SetSVDCT_TBCR2(value uint32) {
	volatile.StoreUint32(&o.SVDCT.Reg, volatile.LoadUint32(&o.SVDCT.Reg)&^(0x400)|value<<10)
}
func (o *I3C_Type) GetSVDCT_TBCR2() uint32 {
	return (volatile.LoadUint32(&o.SVDCT.Reg) & 0x400) >> 10
}
func (o *I3C_Type) SetSVDCT_TBCR3(value uint32) {
	volatile.StoreUint32(&o.SVDCT.Reg, volatile.LoadUint32(&o.SVDCT.Reg)&^(0x800)|value<<11)
}
func (o *I3C_Type) GetSVDCT_TBCR3() uint32 {
	return (volatile.LoadUint32(&o.SVDCT.Reg) & 0x800) >> 11
}
func (o *I3C_Type) SetSVDCT_TBCR76(value uint32) {
	volatile.StoreUint32(&o.SVDCT.Reg, volatile.LoadUint32(&o.SVDCT.Reg)&^(0xc000)|value<<14)
}
func (o *I3C_Type) GetSVDCT_TBCR76() uint32 {
	return (volatile.LoadUint32(&o.SVDCT.Reg) & 0xc000) >> 14
}

// I3C.SVDVAD0: Slave Device Address Register 0
func (o *I3C_Type) SetSVDVAD0_SVAD(value uint32) {
	volatile.StoreUint32(&o.SVDVAD0.Reg, volatile.LoadUint32(&o.SVDVAD0.Reg)&^(0x3ff0000)|value<<16)
}
func (o *I3C_Type) GetSVDVAD0_SVAD() uint32 {
	return (volatile.LoadUint32(&o.SVDVAD0.Reg) & 0x3ff0000) >> 16
}
func (o *I3C_Type) SetSVDVAD0_SADLG(value uint32) {
	volatile.StoreUint32(&o.SVDVAD0.Reg, volatile.LoadUint32(&o.SVDVAD0.Reg)&^(0x8000000)|value<<27)
}
func (o *I3C_Type) GetSVDVAD0_SADLG() uint32 {
	return (volatile.LoadUint32(&o.SVDVAD0.Reg) & 0x8000000) >> 27
}
func (o *I3C_Type) SetSVDVAD0_SSTADV(value uint32) {
	volatile.StoreUint32(&o.SVDVAD0.Reg, volatile.LoadUint32(&o.SVDVAD0.Reg)&^(0x40000000)|value<<30)
}
func (o *I3C_Type) GetSVDVAD0_SSTADV() uint32 {
	return (volatile.LoadUint32(&o.SVDVAD0.Reg) & 0x40000000) >> 30
}
func (o *I3C_Type) SetSVDVAD0_SDYADV(value uint32) {
	volatile.StoreUint32(&o.SVDVAD0.Reg, volatile.LoadUint32(&o.SVDVAD0.Reg)&^(0x80000000)|value<<31)
}
func (o *I3C_Type) GetSVDVAD0_SDYADV() uint32 {
	return (volatile.LoadUint32(&o.SVDVAD0.Reg) & 0x80000000) >> 31
}

// I3C.CSECMD: CCC Slave Events Command Register
func (o *I3C_Type) SetCSECMD_SVIRQE(value uint32) {
	volatile.StoreUint32(&o.CSECMD.Reg, volatile.LoadUint32(&o.CSECMD.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetCSECMD_SVIRQE() uint32 {
	return volatile.LoadUint32(&o.CSECMD.Reg) & 0x1
}
func (o *I3C_Type) SetCSECMD_MSRQE(value uint32) {
	volatile.StoreUint32(&o.CSECMD.Reg, volatile.LoadUint32(&o.CSECMD.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetCSECMD_MSRQE() uint32 {
	return (volatile.LoadUint32(&o.CSECMD.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetCSECMD_HJEVE(value uint32) {
	volatile.StoreUint32(&o.CSECMD.Reg, volatile.LoadUint32(&o.CSECMD.Reg)&^(0x8)|value<<3)
}
func (o *I3C_Type) GetCSECMD_HJEVE() uint32 {
	return (volatile.LoadUint32(&o.CSECMD.Reg) & 0x8) >> 3
}

// I3C.CEACTST: CCC Enter Activity State Register
func (o *I3C_Type) SetCEACTST_ACTST(value uint32) {
	volatile.StoreUint32(&o.CEACTST.Reg, volatile.LoadUint32(&o.CEACTST.Reg)&^(0xf)|value)
}
func (o *I3C_Type) GetCEACTST_ACTST() uint32 {
	return volatile.LoadUint32(&o.CEACTST.Reg) & 0xf
}

// I3C.CMWLG: CCC Max Write Length Register
func (o *I3C_Type) SetCMWLG_MWLG(value uint32) {
	volatile.StoreUint32(&o.CMWLG.Reg, volatile.LoadUint32(&o.CMWLG.Reg)&^(0xffff)|value)
}
func (o *I3C_Type) GetCMWLG_MWLG() uint32 {
	return volatile.LoadUint32(&o.CMWLG.Reg) & 0xffff
}

// I3C.CMRLG: CCC Max Read Length Register
func (o *I3C_Type) SetCMRLG_MRLG(value uint32) {
	volatile.StoreUint32(&o.CMRLG.Reg, volatile.LoadUint32(&o.CMRLG.Reg)&^(0xffff)|value)
}
func (o *I3C_Type) GetCMRLG_MRLG() uint32 {
	return volatile.LoadUint32(&o.CMRLG.Reg) & 0xffff
}
func (o *I3C_Type) SetCMRLG_IBIPSZ(value uint32) {
	volatile.StoreUint32(&o.CMRLG.Reg, volatile.LoadUint32(&o.CMRLG.Reg)&^(0xff0000)|value<<16)
}
func (o *I3C_Type) GetCMRLG_IBIPSZ() uint32 {
	return (volatile.LoadUint32(&o.CMRLG.Reg) & 0xff0000) >> 16
}

// I3C.CETSTMD: CCC Enter Test Mode Register
func (o *I3C_Type) SetCETSTMD_TSTMD(value uint32) {
	volatile.StoreUint32(&o.CETSTMD.Reg, volatile.LoadUint32(&o.CETSTMD.Reg)&^(0xff)|value)
}
func (o *I3C_Type) GetCETSTMD_TSTMD() uint32 {
	return volatile.LoadUint32(&o.CETSTMD.Reg) & 0xff
}

// I3C.CGDVST: CCC Get Device Status Register
func (o *I3C_Type) SetCGDVST_PNDINT(value uint32) {
	volatile.StoreUint32(&o.CGDVST.Reg, volatile.LoadUint32(&o.CGDVST.Reg)&^(0xf)|value)
}
func (o *I3C_Type) GetCGDVST_PNDINT() uint32 {
	return volatile.LoadUint32(&o.CGDVST.Reg) & 0xf
}
func (o *I3C_Type) SetCGDVST_PRTE(value uint32) {
	volatile.StoreUint32(&o.CGDVST.Reg, volatile.LoadUint32(&o.CGDVST.Reg)&^(0x20)|value<<5)
}
func (o *I3C_Type) GetCGDVST_PRTE() uint32 {
	return (volatile.LoadUint32(&o.CGDVST.Reg) & 0x20) >> 5
}
func (o *I3C_Type) SetCGDVST_ACTMD(value uint32) {
	volatile.StoreUint32(&o.CGDVST.Reg, volatile.LoadUint32(&o.CGDVST.Reg)&^(0xc0)|value<<6)
}
func (o *I3C_Type) GetCGDVST_ACTMD() uint32 {
	return (volatile.LoadUint32(&o.CGDVST.Reg) & 0xc0) >> 6
}
func (o *I3C_Type) SetCGDVST_VDRSV(value uint32) {
	volatile.StoreUint32(&o.CGDVST.Reg, volatile.LoadUint32(&o.CGDVST.Reg)&^(0xff00)|value<<8)
}
func (o *I3C_Type) GetCGDVST_VDRSV() uint32 {
	return (volatile.LoadUint32(&o.CGDVST.Reg) & 0xff00) >> 8
}

// I3C.CMDSPW: CCC Max Data Speed W (Write) Register
func (o *I3C_Type) SetCMDSPW_MSWDR(value uint32) {
	volatile.StoreUint32(&o.CMDSPW.Reg, volatile.LoadUint32(&o.CMDSPW.Reg)&^(0x7)|value)
}
func (o *I3C_Type) GetCMDSPW_MSWDR() uint32 {
	return volatile.LoadUint32(&o.CMDSPW.Reg) & 0x7
}

// I3C.CMDSPR: CCC Max Data Speed R (Read) Register
func (o *I3C_Type) SetCMDSPR_MSRDR(value uint32) {
	volatile.StoreUint32(&o.CMDSPR.Reg, volatile.LoadUint32(&o.CMDSPR.Reg)&^(0x7)|value)
}
func (o *I3C_Type) GetCMDSPR_MSRDR() uint32 {
	return volatile.LoadUint32(&o.CMDSPR.Reg) & 0x7
}
func (o *I3C_Type) SetCMDSPR_CDTTIM(value uint32) {
	volatile.StoreUint32(&o.CMDSPR.Reg, volatile.LoadUint32(&o.CMDSPR.Reg)&^(0x38)|value<<3)
}
func (o *I3C_Type) GetCMDSPR_CDTTIM() uint32 {
	return (volatile.LoadUint32(&o.CMDSPR.Reg) & 0x38) >> 3
}

// I3C.CMDSPT: CCC Max Data Speed T (Turnaround) Register
func (o *I3C_Type) SetCMDSPT_MRTTIM(value uint32) {
	volatile.StoreUint32(&o.CMDSPT.Reg, volatile.LoadUint32(&o.CMDSPT.Reg)&^(0xffffff)|value)
}
func (o *I3C_Type) GetCMDSPT_MRTTIM() uint32 {
	return volatile.LoadUint32(&o.CMDSPT.Reg) & 0xffffff
}
func (o *I3C_Type) SetCMDSPT_MRTE(value uint32) {
	volatile.StoreUint32(&o.CMDSPT.Reg, volatile.LoadUint32(&o.CMDSPT.Reg)&^(0x80000000)|value<<31)
}
func (o *I3C_Type) GetCMDSPT_MRTE() uint32 {
	return (volatile.LoadUint32(&o.CMDSPT.Reg) & 0x80000000) >> 31
}

// I3C.CETSM: CCC Exchange Timing Support Information M (Mode) Register
func (o *I3C_Type) SetCETSM_FREQ(value uint32) {
	volatile.StoreUint32(&o.CETSM.Reg, volatile.LoadUint32(&o.CETSM.Reg)&^(0xff00)|value<<8)
}
func (o *I3C_Type) GetCETSM_FREQ() uint32 {
	return (volatile.LoadUint32(&o.CETSM.Reg) & 0xff00) >> 8
}
func (o *I3C_Type) SetCETSM_INAC(value uint32) {
	volatile.StoreUint32(&o.CETSM.Reg, volatile.LoadUint32(&o.CETSM.Reg)&^(0xff0000)|value<<16)
}
func (o *I3C_Type) GetCETSM_INAC() uint32 {
	return (volatile.LoadUint32(&o.CETSM.Reg) & 0xff0000) >> 16
}

// I3C.BITCNT: Bit Count Register
func (o *I3C_Type) SetBITCNT_BCNT(value uint32) {
	volatile.StoreUint32(&o.BITCNT.Reg, volatile.LoadUint32(&o.BITCNT.Reg)&^(0x1f)|value)
}
func (o *I3C_Type) GetBITCNT_BCNT() uint32 {
	return volatile.LoadUint32(&o.BITCNT.Reg) & 0x1f
}

// I3C.NQSTLV: Normal Queue Status Level Register
func (o *I3C_Type) SetNQSTLV_CMDQFLV(value uint32) {
	volatile.StoreUint32(&o.NQSTLV.Reg, volatile.LoadUint32(&o.NQSTLV.Reg)&^(0xff)|value)
}
func (o *I3C_Type) GetNQSTLV_CMDQFLV() uint32 {
	return volatile.LoadUint32(&o.NQSTLV.Reg) & 0xff
}
func (o *I3C_Type) SetNQSTLV_RSPQLV(value uint32) {
	volatile.StoreUint32(&o.NQSTLV.Reg, volatile.LoadUint32(&o.NQSTLV.Reg)&^(0xff00)|value<<8)
}
func (o *I3C_Type) GetNQSTLV_RSPQLV() uint32 {
	return (volatile.LoadUint32(&o.NQSTLV.Reg) & 0xff00) >> 8
}
func (o *I3C_Type) SetNQSTLV_IBIQLV(value uint32) {
	volatile.StoreUint32(&o.NQSTLV.Reg, volatile.LoadUint32(&o.NQSTLV.Reg)&^(0xff0000)|value<<16)
}
func (o *I3C_Type) GetNQSTLV_IBIQLV() uint32 {
	return (volatile.LoadUint32(&o.NQSTLV.Reg) & 0xff0000) >> 16
}
func (o *I3C_Type) SetNQSTLV_IBISCNT(value uint32) {
	volatile.StoreUint32(&o.NQSTLV.Reg, volatile.LoadUint32(&o.NQSTLV.Reg)&^(0x1f000000)|value<<24)
}
func (o *I3C_Type) GetNQSTLV_IBISCNT() uint32 {
	return (volatile.LoadUint32(&o.NQSTLV.Reg) & 0x1f000000) >> 24
}

// I3C.NDBSTLV0: Normal Data Buffer Status Level Register 0
func (o *I3C_Type) SetNDBSTLV0_TDBFLV(value uint32) {
	volatile.StoreUint32(&o.NDBSTLV0.Reg, volatile.LoadUint32(&o.NDBSTLV0.Reg)&^(0xff)|value)
}
func (o *I3C_Type) GetNDBSTLV0_TDBFLV() uint32 {
	return volatile.LoadUint32(&o.NDBSTLV0.Reg) & 0xff
}
func (o *I3C_Type) SetNDBSTLV0_RDBLV(value uint32) {
	volatile.StoreUint32(&o.NDBSTLV0.Reg, volatile.LoadUint32(&o.NDBSTLV0.Reg)&^(0xff00)|value<<8)
}
func (o *I3C_Type) GetNDBSTLV0_RDBLV() uint32 {
	return (volatile.LoadUint32(&o.NDBSTLV0.Reg) & 0xff00) >> 8
}

// I3C.NRSQSTLV: Normal Receive Status Queue Status Level Register
func (o *I3C_Type) SetNRSQSTLV_RSQLV(value uint32) {
	volatile.StoreUint32(&o.NRSQSTLV.Reg, volatile.LoadUint32(&o.NRSQSTLV.Reg)&^(0xff)|value)
}
func (o *I3C_Type) GetNRSQSTLV_RSQLV() uint32 {
	return volatile.LoadUint32(&o.NRSQSTLV.Reg) & 0xff
}

// I3C.PRSTDBG: Present State Debug Register
func (o *I3C_Type) SetPRSTDBG_SCILV(value uint32) {
	volatile.StoreUint32(&o.PRSTDBG.Reg, volatile.LoadUint32(&o.PRSTDBG.Reg)&^(0x1)|value)
}
func (o *I3C_Type) GetPRSTDBG_SCILV() uint32 {
	return volatile.LoadUint32(&o.PRSTDBG.Reg) & 0x1
}
func (o *I3C_Type) SetPRSTDBG_SDILV(value uint32) {
	volatile.StoreUint32(&o.PRSTDBG.Reg, volatile.LoadUint32(&o.PRSTDBG.Reg)&^(0x2)|value<<1)
}
func (o *I3C_Type) GetPRSTDBG_SDILV() uint32 {
	return (volatile.LoadUint32(&o.PRSTDBG.Reg) & 0x2) >> 1
}
func (o *I3C_Type) SetPRSTDBG_SCOLV(value uint32) {
	volatile.StoreUint32(&o.PRSTDBG.Reg, volatile.LoadUint32(&o.PRSTDBG.Reg)&^(0x4)|value<<2)
}
func (o *I3C_Type) GetPRSTDBG_SCOLV() uint32 {
	return (volatile.LoadUint32(&o.PRSTDBG.Reg) & 0x4) >> 2
}
func (o *I3C_Type) SetPRSTDBG_SDOLV(value uint32) {
	volatile.StoreUint32(&o.PRSTDBG.Reg, volatile.LoadUint32(&o.PRSTDBG.Reg)&^(0x8)|value<<3)
}
func (o *I3C_Type) GetPRSTDBG_SDOLV() uint32 {
	return (volatile.LoadUint32(&o.PRSTDBG.Reg) & 0x8) >> 3
}

// I3C.MSERRCNT: Master Error Counters Register
func (o *I3C_Type) SetMSERRCNT_M2ECNT(value uint32) {
	volatile.StoreUint32(&o.MSERRCNT.Reg, volatile.LoadUint32(&o.MSERRCNT.Reg)&^(0xff)|value)
}
func (o *I3C_Type) GetMSERRCNT_M2ECNT() uint32 {
	return volatile.LoadUint32(&o.MSERRCNT.Reg) & 0xff
}

// Low Power Asynchronous General Purpose Timer 0
type AGTW0_Type struct {
	AGT      volatile.Register32 // 0x0
	AGTCMA   volatile.Register32 // 0x4
	AGTCMB   volatile.Register32 // 0x8
	AGTCR    volatile.Register8  // 0xC
	AGTMR1   volatile.Register8  // 0xD
	AGTMR2   volatile.Register8  // 0xE
	AGTIOSEL volatile.Register8  // 0xF
	AGTIOC   volatile.Register8  // 0x10
	AGTISR   volatile.Register8  // 0x11
	AGTCMSR  volatile.Register8  // 0x12
}

// AGTW0.AGTCR: AGT Control Register
func (o *AGTW0_Type) SetAGTCR_TSTART(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x1)|value)
}
func (o *AGTW0_Type) GetAGTCR_TSTART() uint8 {
	return volatile.LoadUint8(&o.AGTCR.Reg) & 0x1
}
func (o *AGTW0_Type) SetAGTCR_TCSTF(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x2)|value<<1)
}
func (o *AGTW0_Type) GetAGTCR_TCSTF() uint8 {
	return (volatile.LoadUint8(&o.AGTCR.Reg) & 0x2) >> 1
}
func (o *AGTW0_Type) SetAGTCR_TSTOP(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x4)|value<<2)
}
func (o *AGTW0_Type) GetAGTCR_TSTOP() uint8 {
	return (volatile.LoadUint8(&o.AGTCR.Reg) & 0x4) >> 2
}
func (o *AGTW0_Type) SetAGTCR_TEDGF(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x10)|value<<4)
}
func (o *AGTW0_Type) GetAGTCR_TEDGF() uint8 {
	return (volatile.LoadUint8(&o.AGTCR.Reg) & 0x10) >> 4
}
func (o *AGTW0_Type) SetAGTCR_TUNDF(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x20)|value<<5)
}
func (o *AGTW0_Type) GetAGTCR_TUNDF() uint8 {
	return (volatile.LoadUint8(&o.AGTCR.Reg) & 0x20) >> 5
}
func (o *AGTW0_Type) SetAGTCR_TCMAF(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x40)|value<<6)
}
func (o *AGTW0_Type) GetAGTCR_TCMAF() uint8 {
	return (volatile.LoadUint8(&o.AGTCR.Reg) & 0x40) >> 6
}
func (o *AGTW0_Type) SetAGTCR_TCMBF(value uint8) {
	volatile.StoreUint8(&o.AGTCR.Reg, volatile.LoadUint8(&o.AGTCR.Reg)&^(0x80)|value<<7)
}
func (o *AGTW0_Type) GetAGTCR_TCMBF() uint8 {
	return (volatile.LoadUint8(&o.AGTCR.Reg) & 0x80) >> 7
}

// AGTW0.AGTMR1: AGT Mode Register 1
func (o *AGTW0_Type) SetAGTMR1_TMOD(value uint8) {
	volatile.StoreUint8(&o.AGTMR1.Reg, volatile.LoadUint8(&o.AGTMR1.Reg)&^(0x7)|value)
}
func (o *AGTW0_Type) GetAGTMR1_TMOD() uint8 {
	return volatile.LoadUint8(&o.AGTMR1.Reg) & 0x7
}
func (o *AGTW0_Type) SetAGTMR1_TEDGPL(value uint8) {
	volatile.StoreUint8(&o.AGTMR1.Reg, volatile.LoadUint8(&o.AGTMR1.Reg)&^(0x8)|value<<3)
}
func (o *AGTW0_Type) GetAGTMR1_TEDGPL() uint8 {
	return (volatile.LoadUint8(&o.AGTMR1.Reg) & 0x8) >> 3
}
func (o *AGTW0_Type) SetAGTMR1_TCK(value uint8) {
	volatile.StoreUint8(&o.AGTMR1.Reg, volatile.LoadUint8(&o.AGTMR1.Reg)&^(0x70)|value<<4)
}
func (o *AGTW0_Type) GetAGTMR1_TCK() uint8 {
	return (volatile.LoadUint8(&o.AGTMR1.Reg) & 0x70) >> 4
}

// AGTW0.AGTMR2: AGT Mode Register 2
func (o *AGTW0_Type) SetAGTMR2_CKS(value uint8) {
	volatile.StoreUint8(&o.AGTMR2.Reg, volatile.LoadUint8(&o.AGTMR2.Reg)&^(0x7)|value)
}
func (o *AGTW0_Type) GetAGTMR2_CKS() uint8 {
	return volatile.LoadUint8(&o.AGTMR2.Reg) & 0x7
}
func (o *AGTW0_Type) SetAGTMR2_LPM(value uint8) {
	volatile.StoreUint8(&o.AGTMR2.Reg, volatile.LoadUint8(&o.AGTMR2.Reg)&^(0x80)|value<<7)
}
func (o *AGTW0_Type) GetAGTMR2_LPM() uint8 {
	return (volatile.LoadUint8(&o.AGTMR2.Reg) & 0x80) >> 7
}

// AGTW0.AGTIOSEL: AGT Pin Select Register
func (o *AGTW0_Type) SetAGTIOSEL_TIES(value uint8) {
	volatile.StoreUint8(&o.AGTIOSEL.Reg, volatile.LoadUint8(&o.AGTIOSEL.Reg)&^(0x10)|value<<4)
}
func (o *AGTW0_Type) GetAGTIOSEL_TIES() uint8 {
	return (volatile.LoadUint8(&o.AGTIOSEL.Reg) & 0x10) >> 4
}

// AGTW0.AGTIOC: AGT I/O Control Register
func (o *AGTW0_Type) SetAGTIOC_TEDGSEL(value uint8) {
	volatile.StoreUint8(&o.AGTIOC.Reg, volatile.LoadUint8(&o.AGTIOC.Reg)&^(0x1)|value)
}
func (o *AGTW0_Type) GetAGTIOC_TEDGSEL() uint8 {
	return volatile.LoadUint8(&o.AGTIOC.Reg) & 0x1
}
func (o *AGTW0_Type) SetAGTIOC_TOE(value uint8) {
	volatile.StoreUint8(&o.AGTIOC.Reg, volatile.LoadUint8(&o.AGTIOC.Reg)&^(0x4)|value<<2)
}
func (o *AGTW0_Type) GetAGTIOC_TOE() uint8 {
	return (volatile.LoadUint8(&o.AGTIOC.Reg) & 0x4) >> 2
}
func (o *AGTW0_Type) SetAGTIOC_TIPF(value uint8) {
	volatile.StoreUint8(&o.AGTIOC.Reg, volatile.LoadUint8(&o.AGTIOC.Reg)&^(0x30)|value<<4)
}
func (o *AGTW0_Type) GetAGTIOC_TIPF() uint8 {
	return (volatile.LoadUint8(&o.AGTIOC.Reg) & 0x30) >> 4
}
func (o *AGTW0_Type) SetAGTIOC_TIOGT(value uint8) {
	volatile.StoreUint8(&o.AGTIOC.Reg, volatile.LoadUint8(&o.AGTIOC.Reg)&^(0xc0)|value<<6)
}
func (o *AGTW0_Type) GetAGTIOC_TIOGT() uint8 {
	return (volatile.LoadUint8(&o.AGTIOC.Reg) & 0xc0) >> 6
}

// AGTW0.AGTISR: AGT Event Pin Select Register
func (o *AGTW0_Type) SetAGTISR_EEPS(value uint8) {
	volatile.StoreUint8(&o.AGTISR.Reg, volatile.LoadUint8(&o.AGTISR.Reg)&^(0x4)|value<<2)
}
func (o *AGTW0_Type) GetAGTISR_EEPS() uint8 {
	return (volatile.LoadUint8(&o.AGTISR.Reg) & 0x4) >> 2
}

// AGTW0.AGTCMSR: AGT Compare Match Function Select Register
func (o *AGTW0_Type) SetAGTCMSR_TCMEA(value uint8) {
	volatile.StoreUint8(&o.AGTCMSR.Reg, volatile.LoadUint8(&o.AGTCMSR.Reg)&^(0x1)|value)
}
func (o *AGTW0_Type) GetAGTCMSR_TCMEA() uint8 {
	return volatile.LoadUint8(&o.AGTCMSR.Reg) & 0x1
}
func (o *AGTW0_Type) SetAGTCMSR_TOEA(value uint8) {
	volatile.StoreUint8(&o.AGTCMSR.Reg, volatile.LoadUint8(&o.AGTCMSR.Reg)&^(0x2)|value<<1)
}
func (o *AGTW0_Type) GetAGTCMSR_TOEA() uint8 {
	return (volatile.LoadUint8(&o.AGTCMSR.Reg) & 0x2) >> 1
}
func (o *AGTW0_Type) SetAGTCMSR_TOPOLA(value uint8) {
	volatile.StoreUint8(&o.AGTCMSR.Reg, volatile.LoadUint8(&o.AGTCMSR.Reg)&^(0x4)|value<<2)
}
func (o *AGTW0_Type) GetAGTCMSR_TOPOLA() uint8 {
	return (volatile.LoadUint8(&o.AGTCMSR.Reg) & 0x4) >> 2
}
func (o *AGTW0_Type) SetAGTCMSR_TCMEB(value uint8) {
	volatile.StoreUint8(&o.AGTCMSR.Reg, volatile.LoadUint8(&o.AGTCMSR.Reg)&^(0x10)|value<<4)
}
func (o *AGTW0_Type) GetAGTCMSR_TCMEB() uint8 {
	return (volatile.LoadUint8(&o.AGTCMSR.Reg) & 0x10) >> 4
}
func (o *AGTW0_Type) SetAGTCMSR_TOEB(value uint8) {
	volatile.StoreUint8(&o.AGTCMSR.Reg, volatile.LoadUint8(&o.AGTCMSR.Reg)&^(0x20)|value<<5)
}
func (o *AGTW0_Type) GetAGTCMSR_TOEB() uint8 {
	return (volatile.LoadUint8(&o.AGTCMSR.Reg) & 0x20) >> 5
}
func (o *AGTW0_Type) SetAGTCMSR_TOPOLB(value uint8) {
	volatile.StoreUint8(&o.AGTCMSR.Reg, volatile.LoadUint8(&o.AGTCMSR.Reg)&^(0x40)|value<<6)
}
func (o *AGTW0_Type) GetAGTCMSR_TOPOLB() uint8 {
	return (volatile.LoadUint8(&o.AGTCMSR.Reg) & 0x40) >> 6
}

// Flash I/O Registers
type FLCN_Type struct {
	_        [144]byte
	DFLCTL   volatile.Register8 // 0x90
	_        [111]byte
	FPMCR    volatile.Register8 // 0x100
	_        [3]byte
	FASR     volatile.Register8 // 0x104
	_        [3]byte
	FSARL    volatile.Register16 // 0x108
	_        [6]byte
	FSARH    volatile.Register16 // 0x110
	_        [2]byte
	FCR      volatile.Register8 // 0x114
	_        [3]byte
	FEARL    volatile.Register16 // 0x118
	_        [6]byte
	FEARH    volatile.Register16 // 0x120
	_        [2]byte
	FRESETR  volatile.Register8 // 0x124
	_        [7]byte
	FSTATR1  volatile.Register8 // 0x12C
	_        [3]byte
	FWBL0    volatile.Register16 // 0x130
	_        [6]byte
	FWBH0    volatile.Register16 // 0x138
	_        [70]byte
	FPR      volatile.Register8 // 0x180
	_        [3]byte
	FPSR     volatile.Register8 // 0x184
	_        [3]byte
	FRBL0    volatile.Register16 // 0x188
	_        [6]byte
	FRBH0    volatile.Register16 // 0x190
	_        [46]byte
	FSCMR    volatile.Register16 // 0x1C0
	_        [6]byte
	FAWSMR   volatile.Register16 // 0x1C8
	_        [6]byte
	FAWEMR   volatile.Register16 // 0x1D0
	_        [6]byte
	FISR     volatile.Register8 // 0x1D8
	_        [3]byte
	FEXCR    volatile.Register8 // 0x1DC
	_        [3]byte
	FEAML    volatile.Register16 // 0x1E0
	_        [6]byte
	FEAMH    volatile.Register16 // 0x1E8
	_        [6]byte
	FSTATR2  volatile.Register16 // 0x1F0
	_        [54]byte
	TSCDR    volatile.Register32 // 0x228
	_        [15748]byte
	FENTRYR  volatile.Register16 // 0x3FB0
	_        [18]byte
	FLDWAITR volatile.Register8 // 0x3FC4
	_        [3]byte
	PFBER    volatile.Register8 // 0x3FC8
}

// FLCN.DFLCTL: Data Flash Control Register
func (o *FLCN_Type) SetDFLCTL_DFLEN(value uint8) {
	volatile.StoreUint8(&o.DFLCTL.Reg, volatile.LoadUint8(&o.DFLCTL.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetDFLCTL_DFLEN() uint8 {
	return volatile.LoadUint8(&o.DFLCTL.Reg) & 0x1
}

// FLCN.FPMCR: Flash P/E Mode Control Register
func (o *FLCN_Type) SetFPMCR_FMS0(value uint8) {
	volatile.StoreUint8(&o.FPMCR.Reg, volatile.LoadUint8(&o.FPMCR.Reg)&^(0x2)|value<<1)
}
func (o *FLCN_Type) GetFPMCR_FMS0() uint8 {
	return (volatile.LoadUint8(&o.FPMCR.Reg) & 0x2) >> 1
}
func (o *FLCN_Type) SetFPMCR_RPDIS(value uint8) {
	volatile.StoreUint8(&o.FPMCR.Reg, volatile.LoadUint8(&o.FPMCR.Reg)&^(0x8)|value<<3)
}
func (o *FLCN_Type) GetFPMCR_RPDIS() uint8 {
	return (volatile.LoadUint8(&o.FPMCR.Reg) & 0x8) >> 3
}
func (o *FLCN_Type) SetFPMCR_FMS1(value uint8) {
	volatile.StoreUint8(&o.FPMCR.Reg, volatile.LoadUint8(&o.FPMCR.Reg)&^(0x10)|value<<4)
}
func (o *FLCN_Type) GetFPMCR_FMS1() uint8 {
	return (volatile.LoadUint8(&o.FPMCR.Reg) & 0x10) >> 4
}

// FLCN.FASR: Flash Area Select Register
func (o *FLCN_Type) SetFASR_EXS(value uint8) {
	volatile.StoreUint8(&o.FASR.Reg, volatile.LoadUint8(&o.FASR.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetFASR_EXS() uint8 {
	return volatile.LoadUint8(&o.FASR.Reg) & 0x1
}

// FLCN.FSARL: Flash Processing Start Address Register L
func (o *FLCN_Type) SetFSARL(value uint16) {
	volatile.StoreUint16(&o.FSARL.Reg, value)
}
func (o *FLCN_Type) GetFSARL() uint16 {
	return volatile.LoadUint16(&o.FSARL.Reg)
}

// FLCN.FSARH: Flash Processing Start Address Register H
func (o *FLCN_Type) SetFSARH(value uint16) {
	volatile.StoreUint16(&o.FSARH.Reg, value)
}
func (o *FLCN_Type) GetFSARH() uint16 {
	return volatile.LoadUint16(&o.FSARH.Reg)
}

// FLCN.FCR: Flash Control Register
func (o *FLCN_Type) SetFCR_CMD(value uint8) {
	volatile.StoreUint8(&o.FCR.Reg, volatile.LoadUint8(&o.FCR.Reg)&^(0xf)|value)
}
func (o *FLCN_Type) GetFCR_CMD() uint8 {
	return volatile.LoadUint8(&o.FCR.Reg) & 0xf
}
func (o *FLCN_Type) SetFCR_DRC(value uint8) {
	volatile.StoreUint8(&o.FCR.Reg, volatile.LoadUint8(&o.FCR.Reg)&^(0x10)|value<<4)
}
func (o *FLCN_Type) GetFCR_DRC() uint8 {
	return (volatile.LoadUint8(&o.FCR.Reg) & 0x10) >> 4
}
func (o *FLCN_Type) SetFCR_STOP(value uint8) {
	volatile.StoreUint8(&o.FCR.Reg, volatile.LoadUint8(&o.FCR.Reg)&^(0x40)|value<<6)
}
func (o *FLCN_Type) GetFCR_STOP() uint8 {
	return (volatile.LoadUint8(&o.FCR.Reg) & 0x40) >> 6
}
func (o *FLCN_Type) SetFCR_OPST(value uint8) {
	volatile.StoreUint8(&o.FCR.Reg, volatile.LoadUint8(&o.FCR.Reg)&^(0x80)|value<<7)
}
func (o *FLCN_Type) GetFCR_OPST() uint8 {
	return (volatile.LoadUint8(&o.FCR.Reg) & 0x80) >> 7
}

// FLCN.FEARL: Flash Processing End Address Register L
func (o *FLCN_Type) SetFEARL(value uint16) {
	volatile.StoreUint16(&o.FEARL.Reg, value)
}
func (o *FLCN_Type) GetFEARL() uint16 {
	return volatile.LoadUint16(&o.FEARL.Reg)
}

// FLCN.FEARH: Flash Processing End Address Register H
func (o *FLCN_Type) SetFEARH(value uint16) {
	volatile.StoreUint16(&o.FEARH.Reg, value)
}
func (o *FLCN_Type) GetFEARH() uint16 {
	return volatile.LoadUint16(&o.FEARH.Reg)
}

// FLCN.FRESETR: Flash Reset Register
func (o *FLCN_Type) SetFRESETR_FRESET(value uint8) {
	volatile.StoreUint8(&o.FRESETR.Reg, volatile.LoadUint8(&o.FRESETR.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetFRESETR_FRESET() uint8 {
	return volatile.LoadUint8(&o.FRESETR.Reg) & 0x1
}

// FLCN.FSTATR1: Flash Status Register 1
func (o *FLCN_Type) SetFSTATR1_DRRDY(value uint8) {
	volatile.StoreUint8(&o.FSTATR1.Reg, volatile.LoadUint8(&o.FSTATR1.Reg)&^(0x2)|value<<1)
}
func (o *FLCN_Type) GetFSTATR1_DRRDY() uint8 {
	return (volatile.LoadUint8(&o.FSTATR1.Reg) & 0x2) >> 1
}
func (o *FLCN_Type) SetFSTATR1_FRDY(value uint8) {
	volatile.StoreUint8(&o.FSTATR1.Reg, volatile.LoadUint8(&o.FSTATR1.Reg)&^(0x40)|value<<6)
}
func (o *FLCN_Type) GetFSTATR1_FRDY() uint8 {
	return (volatile.LoadUint8(&o.FSTATR1.Reg) & 0x40) >> 6
}
func (o *FLCN_Type) SetFSTATR1_EXRDY(value uint8) {
	volatile.StoreUint8(&o.FSTATR1.Reg, volatile.LoadUint8(&o.FSTATR1.Reg)&^(0x80)|value<<7)
}
func (o *FLCN_Type) GetFSTATR1_EXRDY() uint8 {
	return (volatile.LoadUint8(&o.FSTATR1.Reg) & 0x80) >> 7
}

// FLCN.FWBL0: Flash Write Buffer Register L0
func (o *FLCN_Type) SetFWBL0(value uint16) {
	volatile.StoreUint16(&o.FWBL0.Reg, value)
}
func (o *FLCN_Type) GetFWBL0() uint16 {
	return volatile.LoadUint16(&o.FWBL0.Reg)
}

// FLCN.FWBH0: Flash Write Buffer Register H0
func (o *FLCN_Type) SetFWBH0(value uint16) {
	volatile.StoreUint16(&o.FWBH0.Reg, value)
}
func (o *FLCN_Type) GetFWBH0() uint16 {
	return volatile.LoadUint16(&o.FWBH0.Reg)
}

// FLCN.FPR: Protection Unlock Register
func (o *FLCN_Type) SetFPR(value uint8) {
	volatile.StoreUint8(&o.FPR.Reg, value)
}
func (o *FLCN_Type) GetFPR() uint8 {
	return volatile.LoadUint8(&o.FPR.Reg)
}

// FLCN.FPSR: Protection Unlock Status Register
func (o *FLCN_Type) SetFPSR_PERR(value uint8) {
	volatile.StoreUint8(&o.FPSR.Reg, volatile.LoadUint8(&o.FPSR.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetFPSR_PERR() uint8 {
	return volatile.LoadUint8(&o.FPSR.Reg) & 0x1
}

// FLCN.FRBL0: Flash Read Buffer Register L0
func (o *FLCN_Type) SetFRBL0(value uint16) {
	volatile.StoreUint16(&o.FRBL0.Reg, value)
}
func (o *FLCN_Type) GetFRBL0() uint16 {
	return volatile.LoadUint16(&o.FRBL0.Reg)
}

// FLCN.FRBH0: Flash Read Buffer Register H0
func (o *FLCN_Type) SetFRBH0(value uint16) {
	volatile.StoreUint16(&o.FRBH0.Reg, value)
}
func (o *FLCN_Type) GetFRBH0() uint16 {
	return volatile.LoadUint16(&o.FRBH0.Reg)
}

// FLCN.FSCMR: Flash Start-Up Setting Monitor Register
func (o *FLCN_Type) SetFSCMR_SASMF(value uint16) {
	volatile.StoreUint16(&o.FSCMR.Reg, volatile.LoadUint16(&o.FSCMR.Reg)&^(0x100)|value<<8)
}
func (o *FLCN_Type) GetFSCMR_SASMF() uint16 {
	return (volatile.LoadUint16(&o.FSCMR.Reg) & 0x100) >> 8
}
func (o *FLCN_Type) SetFSCMR_FSPR(value uint16) {
	volatile.StoreUint16(&o.FSCMR.Reg, volatile.LoadUint16(&o.FSCMR.Reg)&^(0x4000)|value<<14)
}
func (o *FLCN_Type) GetFSCMR_FSPR() uint16 {
	return (volatile.LoadUint16(&o.FSCMR.Reg) & 0x4000) >> 14
}

// FLCN.FAWSMR: Flash Access Window Start Address Monitor Register
func (o *FLCN_Type) SetFAWSMR_FAWS(value uint16) {
	volatile.StoreUint16(&o.FAWSMR.Reg, volatile.LoadUint16(&o.FAWSMR.Reg)&^(0x7ff)|value)
}
func (o *FLCN_Type) GetFAWSMR_FAWS() uint16 {
	return volatile.LoadUint16(&o.FAWSMR.Reg) & 0x7ff
}
func (o *FLCN_Type) SetFAWSMR_FSPR(value uint16) {
	volatile.StoreUint16(&o.FAWSMR.Reg, volatile.LoadUint16(&o.FAWSMR.Reg)&^(0x8000)|value<<15)
}
func (o *FLCN_Type) GetFAWSMR_FSPR() uint16 {
	return (volatile.LoadUint16(&o.FAWSMR.Reg) & 0x8000) >> 15
}

// FLCN.FAWEMR: Flash Access Window End Address Monitor Register
func (o *FLCN_Type) SetFAWEMR_FAWE(value uint16) {
	volatile.StoreUint16(&o.FAWEMR.Reg, volatile.LoadUint16(&o.FAWEMR.Reg)&^(0x7ff)|value)
}
func (o *FLCN_Type) GetFAWEMR_FAWE() uint16 {
	return volatile.LoadUint16(&o.FAWEMR.Reg) & 0x7ff
}
func (o *FLCN_Type) SetFAWEMR_SASMF(value uint16) {
	volatile.StoreUint16(&o.FAWEMR.Reg, volatile.LoadUint16(&o.FAWEMR.Reg)&^(0x8000)|value<<15)
}
func (o *FLCN_Type) GetFAWEMR_SASMF() uint16 {
	return (volatile.LoadUint16(&o.FAWEMR.Reg) & 0x8000) >> 15
}

// FLCN.FISR: Flash Initial Setting Register
func (o *FLCN_Type) SetFISR_PCKA(value uint8) {
	volatile.StoreUint8(&o.FISR.Reg, volatile.LoadUint8(&o.FISR.Reg)&^(0x3f)|value)
}
func (o *FLCN_Type) GetFISR_PCKA() uint8 {
	return volatile.LoadUint8(&o.FISR.Reg) & 0x3f
}
func (o *FLCN_Type) SetFISR_SAS(value uint8) {
	volatile.StoreUint8(&o.FISR.Reg, volatile.LoadUint8(&o.FISR.Reg)&^(0xc0)|value<<6)
}
func (o *FLCN_Type) GetFISR_SAS() uint8 {
	return (volatile.LoadUint8(&o.FISR.Reg) & 0xc0) >> 6
}

// FLCN.FEXCR: Flash Extra Area Control Register
func (o *FLCN_Type) SetFEXCR_CMD(value uint8) {
	volatile.StoreUint8(&o.FEXCR.Reg, volatile.LoadUint8(&o.FEXCR.Reg)&^(0x7)|value)
}
func (o *FLCN_Type) GetFEXCR_CMD() uint8 {
	return volatile.LoadUint8(&o.FEXCR.Reg) & 0x7
}
func (o *FLCN_Type) SetFEXCR_OPST(value uint8) {
	volatile.StoreUint8(&o.FEXCR.Reg, volatile.LoadUint8(&o.FEXCR.Reg)&^(0x80)|value<<7)
}
func (o *FLCN_Type) GetFEXCR_OPST() uint8 {
	return (volatile.LoadUint8(&o.FEXCR.Reg) & 0x80) >> 7
}

// FLCN.FEAML: Flash Error Address Monitor Register L
func (o *FLCN_Type) SetFEAML(value uint16) {
	volatile.StoreUint16(&o.FEAML.Reg, value)
}
func (o *FLCN_Type) GetFEAML() uint16 {
	return volatile.LoadUint16(&o.FEAML.Reg)
}

// FLCN.FEAMH: Flash Error Address Monitor Register H
func (o *FLCN_Type) SetFEAMH(value uint16) {
	volatile.StoreUint16(&o.FEAMH.Reg, value)
}
func (o *FLCN_Type) GetFEAMH() uint16 {
	return volatile.LoadUint16(&o.FEAMH.Reg)
}

// FLCN.FSTATR2: Flash Status Register 2
func (o *FLCN_Type) SetFSTATR2_ERERR(value uint16) {
	volatile.StoreUint16(&o.FSTATR2.Reg, volatile.LoadUint16(&o.FSTATR2.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetFSTATR2_ERERR() uint16 {
	return volatile.LoadUint16(&o.FSTATR2.Reg) & 0x1
}
func (o *FLCN_Type) SetFSTATR2_PRGERR(value uint16) {
	volatile.StoreUint16(&o.FSTATR2.Reg, volatile.LoadUint16(&o.FSTATR2.Reg)&^(0x2)|value<<1)
}
func (o *FLCN_Type) GetFSTATR2_PRGERR() uint16 {
	return (volatile.LoadUint16(&o.FSTATR2.Reg) & 0x2) >> 1
}
func (o *FLCN_Type) SetFSTATR2_PRGERR01(value uint16) {
	volatile.StoreUint16(&o.FSTATR2.Reg, volatile.LoadUint16(&o.FSTATR2.Reg)&^(0x4)|value<<2)
}
func (o *FLCN_Type) GetFSTATR2_PRGERR01() uint16 {
	return (volatile.LoadUint16(&o.FSTATR2.Reg) & 0x4) >> 2
}
func (o *FLCN_Type) SetFSTATR2_BCERR(value uint16) {
	volatile.StoreUint16(&o.FSTATR2.Reg, volatile.LoadUint16(&o.FSTATR2.Reg)&^(0x8)|value<<3)
}
func (o *FLCN_Type) GetFSTATR2_BCERR() uint16 {
	return (volatile.LoadUint16(&o.FSTATR2.Reg) & 0x8) >> 3
}
func (o *FLCN_Type) SetFSTATR2_ILGLERR(value uint16) {
	volatile.StoreUint16(&o.FSTATR2.Reg, volatile.LoadUint16(&o.FSTATR2.Reg)&^(0x10)|value<<4)
}
func (o *FLCN_Type) GetFSTATR2_ILGLERR() uint16 {
	return (volatile.LoadUint16(&o.FSTATR2.Reg) & 0x10) >> 4
}
func (o *FLCN_Type) SetFSTATR2_EILGLERR(value uint16) {
	volatile.StoreUint16(&o.FSTATR2.Reg, volatile.LoadUint16(&o.FSTATR2.Reg)&^(0x20)|value<<5)
}
func (o *FLCN_Type) GetFSTATR2_EILGLERR() uint16 {
	return (volatile.LoadUint16(&o.FSTATR2.Reg) & 0x20) >> 5
}

// FLCN.TSCDR: Temperature Sensor Calibration Data Register
func (o *FLCN_Type) SetTSCDR(value uint32) {
	volatile.StoreUint32(&o.TSCDR.Reg, volatile.LoadUint32(&o.TSCDR.Reg)&^(0xffff)|value)
}
func (o *FLCN_Type) GetTSCDR() uint32 {
	return volatile.LoadUint32(&o.TSCDR.Reg) & 0xffff
}

// FLCN.FENTRYR: Flash P/E Mode Entry Register
func (o *FLCN_Type) SetFENTRYR_FENTRY0(value uint16) {
	volatile.StoreUint16(&o.FENTRYR.Reg, volatile.LoadUint16(&o.FENTRYR.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetFENTRYR_FENTRY0() uint16 {
	return volatile.LoadUint16(&o.FENTRYR.Reg) & 0x1
}
func (o *FLCN_Type) SetFENTRYR_FENTRYD(value uint16) {
	volatile.StoreUint16(&o.FENTRYR.Reg, volatile.LoadUint16(&o.FENTRYR.Reg)&^(0x80)|value<<7)
}
func (o *FLCN_Type) GetFENTRYR_FENTRYD() uint16 {
	return (volatile.LoadUint16(&o.FENTRYR.Reg) & 0x80) >> 7
}
func (o *FLCN_Type) SetFENTRYR_FEKEY(value uint16) {
	volatile.StoreUint16(&o.FENTRYR.Reg, volatile.LoadUint16(&o.FENTRYR.Reg)&^(0xff00)|value<<8)
}
func (o *FLCN_Type) GetFENTRYR_FEKEY() uint16 {
	return (volatile.LoadUint16(&o.FENTRYR.Reg) & 0xff00) >> 8
}

// FLCN.FLDWAITR: Memory Wait Cycle Control Register for Data Flash
func (o *FLCN_Type) SetFLDWAITR_FLDWAIT1(value uint8) {
	volatile.StoreUint8(&o.FLDWAITR.Reg, volatile.LoadUint8(&o.FLDWAITR.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetFLDWAITR_FLDWAIT1() uint8 {
	return volatile.LoadUint8(&o.FLDWAITR.Reg) & 0x1
}

// FLCN.PFBER: Prefetch Buffer Enable Register
func (o *FLCN_Type) SetPFBER_PFBE(value uint8) {
	volatile.StoreUint8(&o.PFBER.Reg, volatile.LoadUint8(&o.PFBER.Reg)&^(0x1)|value)
}
func (o *FLCN_Type) GetPFBER_PFBE() uint8 {
	return volatile.LoadUint8(&o.PFBER.Reg) & 0x1
}

// Constants for RMPU: Renesas Memory Protection Unit
const (
	// MMPUCTLA: Bus Master MPU Control Register
	// Position of ENABLE field.
	RMPU_MMPUCTLA_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	RMPU_MMPUCTLA_ENABLE_Msk = 0x1
	// Bit ENABLE.
	RMPU_MMPUCTLA_ENABLE = 0x1
	// Master group A disabled
	RMPU_MMPUCTLA_ENABLE_0 = 0x0
	// Master group A enabled
	RMPU_MMPUCTLA_ENABLE_1 = 0x1
	// Position of OAD field.
	RMPU_MMPUCTLA_OAD_Pos = 0x1
	// Bit mask of OAD field.
	RMPU_MMPUCTLA_OAD_Msk = 0x2
	// Bit OAD.
	RMPU_MMPUCTLA_OAD = 0x2
	// Non-maskable interrupt
	RMPU_MMPUCTLA_OAD_0 = 0x0
	// Reset
	RMPU_MMPUCTLA_OAD_1 = 0x1
	// Position of KEY field.
	RMPU_MMPUCTLA_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_MMPUCTLA_KEY_Msk = 0xff00

	// MMPUPTA: Group A Protection of Register
	// Position of PROTECT field.
	RMPU_MMPUPTA_PROTECT_Pos = 0x0
	// Bit mask of PROTECT field.
	RMPU_MMPUPTA_PROTECT_Msk = 0x1
	// Bit PROTECT.
	RMPU_MMPUPTA_PROTECT = 0x1
	// All bus master MPU group A register writes are permitted.
	RMPU_MMPUPTA_PROTECT_0 = 0x0
	// All bus master MPU group A register writes are protected. Reads are permitted.
	RMPU_MMPUPTA_PROTECT_1 = 0x1
	// Position of KEY field.
	RMPU_MMPUPTA_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_MMPUPTA_KEY_Msk = 0xff00

	// MMPUACA0: Group A Region %s access control register
	// Position of ENABLE field.
	RMPU_MMPUACA_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	RMPU_MMPUACA_ENABLE_Msk = 0x1
	// Bit ENABLE.
	RMPU_MMPUACA_ENABLE = 0x1
	// Group A region n disabled
	RMPU_MMPUACA_ENABLE_0 = 0x0
	// Group A region n enabled
	RMPU_MMPUACA_ENABLE_1 = 0x1
	// Position of RP field.
	RMPU_MMPUACA_RP_Pos = 0x1
	// Bit mask of RP field.
	RMPU_MMPUACA_RP_Msk = 0x2
	// Bit RP.
	RMPU_MMPUACA_RP = 0x2
	// Read permission
	RMPU_MMPUACA_RP_0 = 0x0
	// Read protection
	RMPU_MMPUACA_RP_1 = 0x1
	// Position of WP field.
	RMPU_MMPUACA_WP_Pos = 0x2
	// Bit mask of WP field.
	RMPU_MMPUACA_WP_Msk = 0x4
	// Bit WP.
	RMPU_MMPUACA_WP = 0x4
	// Write permission
	RMPU_MMPUACA_WP_0 = 0x0
	// Write protection
	RMPU_MMPUACA_WP_1 = 0x1

	// MMPUSA0: Group A Region %s Start Address Register
	// Position of MMPUSA field.
	RMPU_MMPUSA_MMPUSA_Pos = 0x0
	// Bit mask of MMPUSA field.
	RMPU_MMPUSA_MMPUSA_Msk = 0xffffffff

	// MMPUEA0: Group A Region %s End Address Register
	// Position of MMPUEA field.
	RMPU_MMPUEA_MMPUEA_Pos = 0x0
	// Bit mask of MMPUEA field.
	RMPU_MMPUEA_MMPUEA_Msk = 0xffffffff

	// SMPUCTL: Slave MPU Control Register
	// Position of OAD field.
	RMPU_SMPUCTL_OAD_Pos = 0x0
	// Bit mask of OAD field.
	RMPU_SMPUCTL_OAD_Msk = 0x1
	// Bit OAD.
	RMPU_SMPUCTL_OAD = 0x1
	// Non-maskable interrupt
	RMPU_SMPUCTL_OAD_0 = 0x0
	// Reset
	RMPU_SMPUCTL_OAD_1 = 0x1
	// Position of PROTECT field.
	RMPU_SMPUCTL_PROTECT_Pos = 0x1
	// Bit mask of PROTECT field.
	RMPU_SMPUCTL_PROTECT_Msk = 0x2
	// Bit PROTECT.
	RMPU_SMPUCTL_PROTECT = 0x2
	// All bus slave register writes are permitted
	RMPU_SMPUCTL_PROTECT_0 = 0x0
	// All bus slave register writes are protected. Reads are permitted
	RMPU_SMPUCTL_PROTECT_1 = 0x1
	// Position of KEY field.
	RMPU_SMPUCTL_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_SMPUCTL_KEY_Msk = 0xff00

	// SMPUMBIU: Access Control Register for Memory Bus 1
	// Position of RPGRPA field.
	RMPU_SMPUMBIU_RPGRPA_Pos = 0x2
	// Bit mask of RPGRPA field.
	RMPU_SMPUMBIU_RPGRPA_Msk = 0x4
	// Bit RPGRPA.
	RMPU_SMPUMBIU_RPGRPA = 0x4
	// Memory protection read for master MPU group A disabled
	RMPU_SMPUMBIU_RPGRPA_0 = 0x0
	// Memory protection read for master MPU group A enabled
	RMPU_SMPUMBIU_RPGRPA_1 = 0x1
	// Position of WPGRPA field.
	RMPU_SMPUMBIU_WPGRPA_Pos = 0x3
	// Bit mask of WPGRPA field.
	RMPU_SMPUMBIU_WPGRPA_Msk = 0x8
	// Bit WPGRPA.
	RMPU_SMPUMBIU_WPGRPA = 0x8
	// Memory protection write for master MPU group A disabled
	RMPU_SMPUMBIU_WPGRPA_0 = 0x0
	// Memory protection write for master MPU group A enabled
	RMPU_SMPUMBIU_WPGRPA_1 = 0x1

	// SMPUFBIU: Access Control Register for Internal Peripheral Bus 9
	// Position of RPCPU field.
	RMPU_SMPUFBIU_RPCPU_Pos = 0x0
	// Bit mask of RPCPU field.
	RMPU_SMPUFBIU_RPCPU_Msk = 0x1
	// Bit RPCPU.
	RMPU_SMPUFBIU_RPCPU = 0x1
	// Memory protection for CPU read disabled
	RMPU_SMPUFBIU_RPCPU_0 = 0x0
	// Memory protection for CPU read enabled
	RMPU_SMPUFBIU_RPCPU_1 = 0x1
	// Position of WPCPU field.
	RMPU_SMPUFBIU_WPCPU_Pos = 0x1
	// Bit mask of WPCPU field.
	RMPU_SMPUFBIU_WPCPU_Msk = 0x2
	// Bit WPCPU.
	RMPU_SMPUFBIU_WPCPU = 0x2
	// Memory protection for CPU write disabled
	RMPU_SMPUFBIU_WPCPU_0 = 0x0
	// Memory protection for CPU write enabled
	RMPU_SMPUFBIU_WPCPU_1 = 0x1
	// Position of RPGRPA field.
	RMPU_SMPUFBIU_RPGRPA_Pos = 0x2
	// Bit mask of RPGRPA field.
	RMPU_SMPUFBIU_RPGRPA_Msk = 0x4
	// Bit RPGRPA.
	RMPU_SMPUFBIU_RPGRPA = 0x4
	// Memory protection for master MPU group A read disabled
	RMPU_SMPUFBIU_RPGRPA_0 = 0x0
	// Memory protection for master MPU group A read enabled
	RMPU_SMPUFBIU_RPGRPA_1 = 0x1
	// Position of WPGRPA field.
	RMPU_SMPUFBIU_WPGRPA_Pos = 0x3
	// Bit mask of WPGRPA field.
	RMPU_SMPUFBIU_WPGRPA_Msk = 0x8
	// Bit WPGRPA.
	RMPU_SMPUFBIU_WPGRPA = 0x8
	// Memory protection for master MPU group A write disabled
	RMPU_SMPUFBIU_WPGRPA_0 = 0x0
	// Memory protection for master MPU group A write enabled
	RMPU_SMPUFBIU_WPGRPA_1 = 0x1

	// SMPUSRAM0: Access Control Register for Memory Bus 4
	// Position of RPCPU field.
	RMPU_SMPUSRAM0_RPCPU_Pos = 0x0
	// Bit mask of RPCPU field.
	RMPU_SMPUSRAM0_RPCPU_Msk = 0x1
	// Bit RPCPU.
	RMPU_SMPUSRAM0_RPCPU = 0x1
	// Memory protection for CPU read disabled
	RMPU_SMPUSRAM0_RPCPU_0 = 0x0
	// Memory protection for CPU read enabled
	RMPU_SMPUSRAM0_RPCPU_1 = 0x1
	// Position of WPCPU field.
	RMPU_SMPUSRAM0_WPCPU_Pos = 0x1
	// Bit mask of WPCPU field.
	RMPU_SMPUSRAM0_WPCPU_Msk = 0x2
	// Bit WPCPU.
	RMPU_SMPUSRAM0_WPCPU = 0x2
	// Memory protection for CPU write disabled
	RMPU_SMPUSRAM0_WPCPU_0 = 0x0
	// Memory protection for CPU write enabled
	RMPU_SMPUSRAM0_WPCPU_1 = 0x1
	// Position of RPGRPA field.
	RMPU_SMPUSRAM0_RPGRPA_Pos = 0x2
	// Bit mask of RPGRPA field.
	RMPU_SMPUSRAM0_RPGRPA_Msk = 0x4
	// Bit RPGRPA.
	RMPU_SMPUSRAM0_RPGRPA = 0x4
	// Memory protection for master MPU group A read disabled
	RMPU_SMPUSRAM0_RPGRPA_0 = 0x0
	// Memory protection for master MPU group A read enabled
	RMPU_SMPUSRAM0_RPGRPA_1 = 0x1
	// Position of WPGRPA field.
	RMPU_SMPUSRAM0_WPGRPA_Pos = 0x3
	// Bit mask of WPGRPA field.
	RMPU_SMPUSRAM0_WPGRPA_Msk = 0x8
	// Bit WPGRPA.
	RMPU_SMPUSRAM0_WPGRPA = 0x8
	// Memory protection for master MPU group A write disabled
	RMPU_SMPUSRAM0_WPGRPA_0 = 0x0
	// Memory protection for master MPU group A write enabled
	RMPU_SMPUSRAM0_WPGRPA_1 = 0x1

	// SMPUP0BIU: Access Control Register for Internal Peripheral Bus 1
	// Position of RPCPU field.
	RMPU_SMPUP0BIU_RPCPU_Pos = 0x0
	// Bit mask of RPCPU field.
	RMPU_SMPUP0BIU_RPCPU_Msk = 0x1
	// Bit RPCPU.
	RMPU_SMPUP0BIU_RPCPU = 0x1
	// Memory protection for CPU read disabled
	RMPU_SMPUP0BIU_RPCPU_0 = 0x0
	// Memory protection for CPU read enabled
	RMPU_SMPUP0BIU_RPCPU_1 = 0x1
	// Position of WPCPU field.
	RMPU_SMPUP0BIU_WPCPU_Pos = 0x1
	// Bit mask of WPCPU field.
	RMPU_SMPUP0BIU_WPCPU_Msk = 0x2
	// Bit WPCPU.
	RMPU_SMPUP0BIU_WPCPU = 0x2
	// Memory protection for CPU write disabled
	RMPU_SMPUP0BIU_WPCPU_0 = 0x0
	// Memory protection for CPU write enabled
	RMPU_SMPUP0BIU_WPCPU_1 = 0x1
	// Position of RPGRPA field.
	RMPU_SMPUP0BIU_RPGRPA_Pos = 0x2
	// Bit mask of RPGRPA field.
	RMPU_SMPUP0BIU_RPGRPA_Msk = 0x4
	// Bit RPGRPA.
	RMPU_SMPUP0BIU_RPGRPA = 0x4
	// Memory protection for master MPU group A read disabled
	RMPU_SMPUP0BIU_RPGRPA_0 = 0x0
	// Memory protection for master MPU group A read enabled
	RMPU_SMPUP0BIU_RPGRPA_1 = 0x1
	// Position of WPGRPA field.
	RMPU_SMPUP0BIU_WPGRPA_Pos = 0x3
	// Bit mask of WPGRPA field.
	RMPU_SMPUP0BIU_WPGRPA_Msk = 0x8
	// Bit WPGRPA.
	RMPU_SMPUP0BIU_WPGRPA = 0x8
	// Memory protection for master MPU group A write disabled
	RMPU_SMPUP0BIU_WPGRPA_0 = 0x0
	// Memory protection for master MPU group A write enabled
	RMPU_SMPUP0BIU_WPGRPA_1 = 0x1

	// SMPUP2BIU: Access Control Register for Internal Peripheral Bus 3
	// Position of RPCPU field.
	RMPU_SMPUP2BIU_RPCPU_Pos = 0x0
	// Bit mask of RPCPU field.
	RMPU_SMPUP2BIU_RPCPU_Msk = 0x1
	// Bit RPCPU.
	RMPU_SMPUP2BIU_RPCPU = 0x1
	// Memory protection for CPU read disabled
	RMPU_SMPUP2BIU_RPCPU_0 = 0x0
	// Memory protection for CPU read enabled
	RMPU_SMPUP2BIU_RPCPU_1 = 0x1
	// Position of WPCPU field.
	RMPU_SMPUP2BIU_WPCPU_Pos = 0x1
	// Bit mask of WPCPU field.
	RMPU_SMPUP2BIU_WPCPU_Msk = 0x2
	// Bit WPCPU.
	RMPU_SMPUP2BIU_WPCPU = 0x2
	// Memory protection for CPU write disabled
	RMPU_SMPUP2BIU_WPCPU_0 = 0x0
	// Memory protection for CPU write enabled
	RMPU_SMPUP2BIU_WPCPU_1 = 0x1
	// Position of RPGRPA field.
	RMPU_SMPUP2BIU_RPGRPA_Pos = 0x2
	// Bit mask of RPGRPA field.
	RMPU_SMPUP2BIU_RPGRPA_Msk = 0x4
	// Bit RPGRPA.
	RMPU_SMPUP2BIU_RPGRPA = 0x4
	// Memory protection for master MPU group A read disabled
	RMPU_SMPUP2BIU_RPGRPA_0 = 0x0
	// Memory protection for master MPU group A read enabled
	RMPU_SMPUP2BIU_RPGRPA_1 = 0x1
	// Position of WPGRPA field.
	RMPU_SMPUP2BIU_WPGRPA_Pos = 0x3
	// Bit mask of WPGRPA field.
	RMPU_SMPUP2BIU_WPGRPA_Msk = 0x8
	// Bit WPGRPA.
	RMPU_SMPUP2BIU_WPGRPA = 0x8
	// Memory protection for master MPU group A write disabled
	RMPU_SMPUP2BIU_WPGRPA_0 = 0x0
	// Memory protection for master MPU group A write enabled
	RMPU_SMPUP2BIU_WPGRPA_1 = 0x1

	// SMPUP6BIU: Access Control Register for Internal Peripheral Bus 7
	// Position of RPCPU field.
	RMPU_SMPUP6BIU_RPCPU_Pos = 0x0
	// Bit mask of RPCPU field.
	RMPU_SMPUP6BIU_RPCPU_Msk = 0x1
	// Bit RPCPU.
	RMPU_SMPUP6BIU_RPCPU = 0x1
	// CPU read of memory protection disabled
	RMPU_SMPUP6BIU_RPCPU_0 = 0x0
	// CPU read of memory protection enabled
	RMPU_SMPUP6BIU_RPCPU_1 = 0x1
	// Position of WPCPU field.
	RMPU_SMPUP6BIU_WPCPU_Pos = 0x1
	// Bit mask of WPCPU field.
	RMPU_SMPUP6BIU_WPCPU_Msk = 0x2
	// Bit WPCPU.
	RMPU_SMPUP6BIU_WPCPU = 0x2
	// CPU write of memory protection disabled
	RMPU_SMPUP6BIU_WPCPU_0 = 0x0
	// CPU write of memory protection enabled
	RMPU_SMPUP6BIU_WPCPU_1 = 0x1
	// Position of RPGRPA field.
	RMPU_SMPUP6BIU_RPGRPA_Pos = 0x2
	// Bit mask of RPGRPA field.
	RMPU_SMPUP6BIU_RPGRPA_Msk = 0x4
	// Bit RPGRPA.
	RMPU_SMPUP6BIU_RPGRPA = 0x4
	// Master MPU group A read of memory protection disabled
	RMPU_SMPUP6BIU_RPGRPA_0 = 0x0
	// Master MPU group A read of memory protection enabled
	RMPU_SMPUP6BIU_RPGRPA_1 = 0x1
	// Position of WPGRPA field.
	RMPU_SMPUP6BIU_WPGRPA_Pos = 0x3
	// Bit mask of WPGRPA field.
	RMPU_SMPUP6BIU_WPGRPA_Msk = 0x8
	// Bit WPGRPA.
	RMPU_SMPUP6BIU_WPGRPA = 0x8
	// Master MPU group A write of memory protection disabled
	RMPU_SMPUP6BIU_WPGRPA_0 = 0x0
	// Master MPU group A write of memory protection enabled
	RMPU_SMPUP6BIU_WPGRPA_1 = 0x1

	// MSPMPUOAD: Stack Pointer Monitor Operation After Detection Register
	// Position of OAD field.
	RMPU_MSPMPUOAD_OAD_Pos = 0x0
	// Bit mask of OAD field.
	RMPU_MSPMPUOAD_OAD_Msk = 0x1
	// Bit OAD.
	RMPU_MSPMPUOAD_OAD = 0x1
	// Non-maskable interrupt
	RMPU_MSPMPUOAD_OAD_0 = 0x0
	// Reset
	RMPU_MSPMPUOAD_OAD_1 = 0x1
	// Position of KEY field.
	RMPU_MSPMPUOAD_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_MSPMPUOAD_KEY_Msk = 0xff00

	// MSPMPUCTL: Stack Pointer Monitor Access Control Register
	// Position of ENABLE field.
	RMPU_MSPMPUCTL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	RMPU_MSPMPUCTL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	RMPU_MSPMPUCTL_ENABLE = 0x1
	// Stack pointer monitor is disabled
	RMPU_MSPMPUCTL_ENABLE_0 = 0x0
	// Stack pointer monitor is enabled
	RMPU_MSPMPUCTL_ENABLE_1 = 0x1
	// Position of ERROR field.
	RMPU_MSPMPUCTL_ERROR_Pos = 0x8
	// Bit mask of ERROR field.
	RMPU_MSPMPUCTL_ERROR_Msk = 0x100
	// Bit ERROR.
	RMPU_MSPMPUCTL_ERROR = 0x100
	// Stack pointer has not overflowed or underflowed
	RMPU_MSPMPUCTL_ERROR_0 = 0x0
	// Stack pointer has overflowed or underflowed
	RMPU_MSPMPUCTL_ERROR_1 = 0x1

	// MSPMPUPT: Stack Pointer Monitor Protection Register
	// Position of PROTECT field.
	RMPU_MSPMPUPT_PROTECT_Pos = 0x0
	// Bit mask of PROTECT field.
	RMPU_MSPMPUPT_PROTECT_Msk = 0x1
	// Bit PROTECT.
	RMPU_MSPMPUPT_PROTECT = 0x1
	// Stack pointer monitor register writes are permitted.
	RMPU_MSPMPUPT_PROTECT_0 = 0x0
	// Stack pointer monitor register writes are protected. Reads are permitted
	RMPU_MSPMPUPT_PROTECT_1 = 0x1
	// Position of KEY field.
	RMPU_MSPMPUPT_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_MSPMPUPT_KEY_Msk = 0xff00

	// MSPMPUSA: Main Stack Pointer (MSP) Monitor Start Address Register
	// Position of MSPMPUSA field.
	RMPU_MSPMPUSA_MSPMPUSA_Pos = 0x0
	// Bit mask of MSPMPUSA field.
	RMPU_MSPMPUSA_MSPMPUSA_Msk = 0xffffffff

	// MSPMPUEA: Main Stack Pointer (MSP) Monitor End Address Register
	// Position of MSPMPUEA field.
	RMPU_MSPMPUEA_MSPMPUEA_Pos = 0x0
	// Bit mask of MSPMPUEA field.
	RMPU_MSPMPUEA_MSPMPUEA_Msk = 0xffffffff

	// PSPMPUOAD: Stack Pointer Monitor Operation After Detection Register
	// Position of OAD field.
	RMPU_PSPMPUOAD_OAD_Pos = 0x0
	// Bit mask of OAD field.
	RMPU_PSPMPUOAD_OAD_Msk = 0x1
	// Bit OAD.
	RMPU_PSPMPUOAD_OAD = 0x1
	// Non-maskable interrupt
	RMPU_PSPMPUOAD_OAD_0 = 0x0
	// Reset
	RMPU_PSPMPUOAD_OAD_1 = 0x1
	// Position of KEY field.
	RMPU_PSPMPUOAD_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_PSPMPUOAD_KEY_Msk = 0xff00

	// PSPMPUCTL: Stack Pointer Monitor Access Control Register
	// Position of ENABLE field.
	RMPU_PSPMPUCTL_ENABLE_Pos = 0x0
	// Bit mask of ENABLE field.
	RMPU_PSPMPUCTL_ENABLE_Msk = 0x1
	// Bit ENABLE.
	RMPU_PSPMPUCTL_ENABLE = 0x1
	// Stack pointer monitor is disabled
	RMPU_PSPMPUCTL_ENABLE_0 = 0x0
	// Stack pointer monitor is enabled
	RMPU_PSPMPUCTL_ENABLE_1 = 0x1
	// Position of ERROR field.
	RMPU_PSPMPUCTL_ERROR_Pos = 0x8
	// Bit mask of ERROR field.
	RMPU_PSPMPUCTL_ERROR_Msk = 0x100
	// Bit ERROR.
	RMPU_PSPMPUCTL_ERROR = 0x100
	// Stack pointer has not overflowed or underflowed
	RMPU_PSPMPUCTL_ERROR_0 = 0x0
	// Stack pointer has overflowed or underflowed
	RMPU_PSPMPUCTL_ERROR_1 = 0x1

	// PSPMPUPT: Stack Pointer Monitor Protection Register
	// Position of PROTECT field.
	RMPU_PSPMPUPT_PROTECT_Pos = 0x0
	// Bit mask of PROTECT field.
	RMPU_PSPMPUPT_PROTECT_Msk = 0x1
	// Bit PROTECT.
	RMPU_PSPMPUPT_PROTECT = 0x1
	// Stack pointer monitor register writes are permitted.
	RMPU_PSPMPUPT_PROTECT_0 = 0x0
	// Stack pointer monitor register writes are protected. Reads are permitted
	RMPU_PSPMPUPT_PROTECT_1 = 0x1
	// Position of KEY field.
	RMPU_PSPMPUPT_KEY_Pos = 0x8
	// Bit mask of KEY field.
	RMPU_PSPMPUPT_KEY_Msk = 0xff00

	// PSPMPUSA: Process Stack Pointer (PSP) Monitor Start Address Register
	// Position of PSPMPUSA field.
	RMPU_PSPMPUSA_PSPMPUSA_Pos = 0x0
	// Bit mask of PSPMPUSA field.
	RMPU_PSPMPUSA_PSPMPUSA_Msk = 0xffffffff

	// PSPMPUEA: Process Stack Pointer (PSP) Monitor End Address Register
	// Position of PSPMPUEA field.
	RMPU_PSPMPUEA_PSPMPUEA_Pos = 0x0
	// Bit mask of PSPMPUEA field.
	RMPU_PSPMPUEA_PSPMPUEA_Msk = 0xffffffff
)

// Constants for SRAM: SRAM Control
const (
	// PARIOAD: SRAM Parity Error Operation After Detection Register
	// Position of OAD field.
	SRAM_PARIOAD_OAD_Pos = 0x0
	// Bit mask of OAD field.
	SRAM_PARIOAD_OAD_Msk = 0x1
	// Bit OAD.
	SRAM_PARIOAD_OAD = 0x1
	// Non-maskable interrupt
	SRAM_PARIOAD_OAD_0 = 0x0
	// Reset
	SRAM_PARIOAD_OAD_1 = 0x1

	// SRAMPRCR: SRAM Protection Register
	// Position of SRAMPRCR field.
	SRAM_SRAMPRCR_SRAMPRCR_Pos = 0x0
	// Bit mask of SRAMPRCR field.
	SRAM_SRAMPRCR_SRAMPRCR_Msk = 0x1
	// Bit SRAMPRCR.
	SRAM_SRAMPRCR_SRAMPRCR = 0x1
	// Disable writes to protected registers
	SRAM_SRAMPRCR_SRAMPRCR_0 = 0x0
	// Enable writes to protected registers
	SRAM_SRAMPRCR_SRAMPRCR_1 = 0x1
	// Position of KW field.
	SRAM_SRAMPRCR_KW_Pos = 0x1
	// Bit mask of KW field.
	SRAM_SRAMPRCR_KW_Msk = 0xfe
)

// Constants for BUS: BUS Control
const (
	// BUSMCNTSYS: Master Bus Control Register SYS
	// Position of IERES field.
	BUS_BUSMCNTSYS_IERES_Pos = 0xf
	// Bit mask of IERES field.
	BUS_BUSMCNTSYS_IERES_Msk = 0x8000
	// Bit IERES.
	BUS_BUSMCNTSYS_IERES = 0x8000
	// A bus error is reported.
	BUS_BUSMCNTSYS_IERES_0 = 0x0
	// A bus error is not reported.
	BUS_BUSMCNTSYS_IERES_1 = 0x1

	// BUSMCNTDMA: Master Bus Control Register DMA
	// Position of IERES field.
	BUS_BUSMCNTDMA_IERES_Pos = 0xf
	// Bit mask of IERES field.
	BUS_BUSMCNTDMA_IERES_Msk = 0x8000
	// Bit IERES.
	BUS_BUSMCNTDMA_IERES = 0x8000
	// A bus error is reported.
	BUS_BUSMCNTDMA_IERES_0 = 0x0
	// A bus error is not reported.
	BUS_BUSMCNTDMA_IERES_1 = 0x1

	// BUS3ERRADD: Bus Error Address Register 3
	// Position of BERAD field.
	BUS_BUS3ERRADD_BERAD_Pos = 0x0
	// Bit mask of BERAD field.
	BUS_BUS3ERRADD_BERAD_Msk = 0xffffffff

	// BUS3ERRSTAT: BUS Error Status Register 3
	// Position of ACCSTAT field.
	BUS_BUS3ERRSTAT_ACCSTAT_Pos = 0x0
	// Bit mask of ACCSTAT field.
	BUS_BUS3ERRSTAT_ACCSTAT_Msk = 0x1
	// Bit ACCSTAT.
	BUS_BUS3ERRSTAT_ACCSTAT = 0x1
	// Read access
	BUS_BUS3ERRSTAT_ACCSTAT_0 = 0x0
	// Write access
	BUS_BUS3ERRSTAT_ACCSTAT_1 = 0x1
	// Position of ERRSTAT field.
	BUS_BUS3ERRSTAT_ERRSTAT_Pos = 0x7
	// Bit mask of ERRSTAT field.
	BUS_BUS3ERRSTAT_ERRSTAT_Msk = 0x80
	// Bit ERRSTAT.
	BUS_BUS3ERRSTAT_ERRSTAT = 0x80
	// No bus error occurred.
	BUS_BUS3ERRSTAT_ERRSTAT_0 = 0x0
	// Bus error occurred.
	BUS_BUS3ERRSTAT_ERRSTAT_1 = 0x1

	// BUS4ERRADD: Bus Error Address Register 4
	// Position of BERAD field.
	BUS_BUS4ERRADD_BERAD_Pos = 0x0
	// Bit mask of BERAD field.
	BUS_BUS4ERRADD_BERAD_Msk = 0xffffffff

	// BUS4ERRSTAT: BUS Error Status Register 4
	// Position of ACCSTAT field.
	BUS_BUS4ERRSTAT_ACCSTAT_Pos = 0x0
	// Bit mask of ACCSTAT field.
	BUS_BUS4ERRSTAT_ACCSTAT_Msk = 0x1
	// Bit ACCSTAT.
	BUS_BUS4ERRSTAT_ACCSTAT = 0x1
	// Read access
	BUS_BUS4ERRSTAT_ACCSTAT_0 = 0x0
	// Write access
	BUS_BUS4ERRSTAT_ACCSTAT_1 = 0x1
	// Position of ERRSTAT field.
	BUS_BUS4ERRSTAT_ERRSTAT_Pos = 0x7
	// Bit mask of ERRSTAT field.
	BUS_BUS4ERRSTAT_ERRSTAT_Msk = 0x80
	// Bit ERRSTAT.
	BUS_BUS4ERRSTAT_ERRSTAT = 0x80
	// No bus error occurred.
	BUS_BUS4ERRSTAT_ERRSTAT_0 = 0x0
	// Bus error occurred.
	BUS_BUS4ERRSTAT_ERRSTAT_1 = 0x1
)

// Constants for DTC: Data Transfer Controller
const (
	// DTCCR: DTC Control Register
	// Position of RRS field.
	DTC_DTCCR_RRS_Pos = 0x4
	// Bit mask of RRS field.
	DTC_DTCCR_RRS_Msk = 0x10
	// Bit RRS.
	DTC_DTCCR_RRS = 0x10
	// Transfer information read is not skipped
	DTC_DTCCR_RRS_0 = 0x0
	// Transfer information read is skipped when vector numbers match
	DTC_DTCCR_RRS_1 = 0x1

	// DTCST: DTC Module Start Register
	// Position of DTCST field.
	DTC_DTCST_DTCST_Pos = 0x0
	// Bit mask of DTCST field.
	DTC_DTCST_DTCST_Msk = 0x1
	// Bit DTCST.
	DTC_DTCST_DTCST = 0x1
	// DTC module stopped.
	DTC_DTCST_DTCST_0 = 0x0
	// DTC module started.
	DTC_DTCST_DTCST_1 = 0x1

	// DTCSTS: DTC Status Register
	// Position of VECN field.
	DTC_DTCSTS_VECN_Pos = 0x0
	// Bit mask of VECN field.
	DTC_DTCSTS_VECN_Msk = 0xff
	// Position of ACT field.
	DTC_DTCSTS_ACT_Pos = 0xf
	// Bit mask of ACT field.
	DTC_DTCSTS_ACT_Msk = 0x8000
	// Bit ACT.
	DTC_DTCSTS_ACT = 0x8000
	// DTC transfer operation is not in progress.
	DTC_DTCSTS_ACT_0 = 0x0
	// DTC transfer operation is in progress.
	DTC_DTCSTS_ACT_1 = 0x1
)

// Constants for ICU: ICU for CPU
const (
	// IRQCR0: IRQ Control Register %s
	// Position of IRQMD field.
	ICU_IRQCR_IRQMD_Pos = 0x0
	// Bit mask of IRQMD field.
	ICU_IRQCR_IRQMD_Msk = 0x3
	// Falling edge
	ICU_IRQCR_IRQMD_00 = 0x0
	// Rising edge
	ICU_IRQCR_IRQMD_01 = 0x1
	// Rising and falling edges
	ICU_IRQCR_IRQMD_10 = 0x2
	// Low level
	ICU_IRQCR_IRQMD_11 = 0x3
	// Position of FCLKSEL field.
	ICU_IRQCR_FCLKSEL_Pos = 0x4
	// Bit mask of FCLKSEL field.
	ICU_IRQCR_FCLKSEL_Msk = 0x30
	// PCLKB
	ICU_IRQCR_FCLKSEL_00 = 0x0
	// PCLKB/8
	ICU_IRQCR_FCLKSEL_01 = 0x1
	// PCLKB/32
	ICU_IRQCR_FCLKSEL_10 = 0x2
	// PCLKB/64
	ICU_IRQCR_FCLKSEL_11 = 0x3
	// Position of FLTEN field.
	ICU_IRQCR_FLTEN_Pos = 0x7
	// Bit mask of FLTEN field.
	ICU_IRQCR_FLTEN_Msk = 0x80
	// Bit FLTEN.
	ICU_IRQCR_FLTEN = 0x80
	// Digital filter is disabled
	ICU_IRQCR_FLTEN_0 = 0x0
	// Digital filter is enabled.
	ICU_IRQCR_FLTEN_1 = 0x1

	// NMICR: NMI Pin Interrupt Control Register
	// Position of NMIMD field.
	ICU_NMICR_NMIMD_Pos = 0x0
	// Bit mask of NMIMD field.
	ICU_NMICR_NMIMD_Msk = 0x1
	// Bit NMIMD.
	ICU_NMICR_NMIMD = 0x1
	// Falling edge
	ICU_NMICR_NMIMD_0 = 0x0
	// Rising edge
	ICU_NMICR_NMIMD_1 = 0x1
	// Position of NFCLKSEL field.
	ICU_NMICR_NFCLKSEL_Pos = 0x4
	// Bit mask of NFCLKSEL field.
	ICU_NMICR_NFCLKSEL_Msk = 0x30
	// PCLKB
	ICU_NMICR_NFCLKSEL_00 = 0x0
	// PCLKB/8
	ICU_NMICR_NFCLKSEL_01 = 0x1
	// PCLKB/32
	ICU_NMICR_NFCLKSEL_10 = 0x2
	// PCLKB/64
	ICU_NMICR_NFCLKSEL_11 = 0x3
	// Position of NFLTEN field.
	ICU_NMICR_NFLTEN_Pos = 0x7
	// Bit mask of NFLTEN field.
	ICU_NMICR_NFLTEN_Msk = 0x80
	// Bit NFLTEN.
	ICU_NMICR_NFLTEN = 0x80
	// Disabled.
	ICU_NMICR_NFLTEN_0 = 0x0
	// Enabled.
	ICU_NMICR_NFLTEN_1 = 0x1

	// NMIER: Non-Maskable Interrupt Enable Register
	// Position of IWDTEN field.
	ICU_NMIER_IWDTEN_Pos = 0x0
	// Bit mask of IWDTEN field.
	ICU_NMIER_IWDTEN_Msk = 0x1
	// Bit IWDTEN.
	ICU_NMIER_IWDTEN = 0x1
	// Disabled
	ICU_NMIER_IWDTEN_0 = 0x0
	// Enabled.
	ICU_NMIER_IWDTEN_1 = 0x1
	// Position of WDTEN field.
	ICU_NMIER_WDTEN_Pos = 0x1
	// Bit mask of WDTEN field.
	ICU_NMIER_WDTEN_Msk = 0x2
	// Bit WDTEN.
	ICU_NMIER_WDTEN = 0x2
	// Disabled
	ICU_NMIER_WDTEN_0 = 0x0
	// Enabled
	ICU_NMIER_WDTEN_1 = 0x1
	// Position of LVD1EN field.
	ICU_NMIER_LVD1EN_Pos = 0x2
	// Bit mask of LVD1EN field.
	ICU_NMIER_LVD1EN_Msk = 0x4
	// Bit LVD1EN.
	ICU_NMIER_LVD1EN = 0x4
	// Disabled
	ICU_NMIER_LVD1EN_0 = 0x0
	// Enabled
	ICU_NMIER_LVD1EN_1 = 0x1
	// Position of LVD2EN field.
	ICU_NMIER_LVD2EN_Pos = 0x3
	// Bit mask of LVD2EN field.
	ICU_NMIER_LVD2EN_Msk = 0x8
	// Bit LVD2EN.
	ICU_NMIER_LVD2EN = 0x8
	// Disabled
	ICU_NMIER_LVD2EN_0 = 0x0
	// Enabled
	ICU_NMIER_LVD2EN_1 = 0x1
	// Position of NMIEN field.
	ICU_NMIER_NMIEN_Pos = 0x7
	// Bit mask of NMIEN field.
	ICU_NMIER_NMIEN_Msk = 0x80
	// Bit NMIEN.
	ICU_NMIER_NMIEN = 0x80
	// Disabled
	ICU_NMIER_NMIEN_0 = 0x0
	// Enabled
	ICU_NMIER_NMIEN_1 = 0x1
	// Position of RPEEN field.
	ICU_NMIER_RPEEN_Pos = 0x8
	// Bit mask of RPEEN field.
	ICU_NMIER_RPEEN_Msk = 0x100
	// Bit RPEEN.
	ICU_NMIER_RPEEN = 0x100
	// Disabled
	ICU_NMIER_RPEEN_0 = 0x0
	// Enabled
	ICU_NMIER_RPEEN_1 = 0x1
	// Position of BUSSEN field.
	ICU_NMIER_BUSSEN_Pos = 0xa
	// Bit mask of BUSSEN field.
	ICU_NMIER_BUSSEN_Msk = 0x400
	// Bit BUSSEN.
	ICU_NMIER_BUSSEN = 0x400
	// Disabled
	ICU_NMIER_BUSSEN_0 = 0x0
	// Enabled
	ICU_NMIER_BUSSEN_1 = 0x1
	// Position of BUSMEN field.
	ICU_NMIER_BUSMEN_Pos = 0xb
	// Bit mask of BUSMEN field.
	ICU_NMIER_BUSMEN_Msk = 0x800
	// Bit BUSMEN.
	ICU_NMIER_BUSMEN = 0x800
	// Disabled
	ICU_NMIER_BUSMEN_0 = 0x0
	// Enabled
	ICU_NMIER_BUSMEN_1 = 0x1
	// Position of SPEEN field.
	ICU_NMIER_SPEEN_Pos = 0xc
	// Bit mask of SPEEN field.
	ICU_NMIER_SPEEN_Msk = 0x1000
	// Bit SPEEN.
	ICU_NMIER_SPEEN = 0x1000
	// Disabled
	ICU_NMIER_SPEEN_0 = 0x0
	// Enabled
	ICU_NMIER_SPEEN_1 = 0x1

	// NMICLR: Non-Maskable Interrupt Status Clear Register
	// Position of IWDTCLR field.
	ICU_NMICLR_IWDTCLR_Pos = 0x0
	// Bit mask of IWDTCLR field.
	ICU_NMICLR_IWDTCLR_Msk = 0x1
	// Bit IWDTCLR.
	ICU_NMICLR_IWDTCLR = 0x1
	// No effect
	ICU_NMICLR_IWDTCLR_0 = 0x0
	// Clear the NMISR.IWDTST flag
	ICU_NMICLR_IWDTCLR_1 = 0x1
	// Position of WDTCLR field.
	ICU_NMICLR_WDTCLR_Pos = 0x1
	// Bit mask of WDTCLR field.
	ICU_NMICLR_WDTCLR_Msk = 0x2
	// Bit WDTCLR.
	ICU_NMICLR_WDTCLR = 0x2
	// No effect
	ICU_NMICLR_WDTCLR_0 = 0x0
	// Clear the NMISR.WDTST flag
	ICU_NMICLR_WDTCLR_1 = 0x1
	// Position of LVD1CLR field.
	ICU_NMICLR_LVD1CLR_Pos = 0x2
	// Bit mask of LVD1CLR field.
	ICU_NMICLR_LVD1CLR_Msk = 0x4
	// Bit LVD1CLR.
	ICU_NMICLR_LVD1CLR = 0x4
	// No effect
	ICU_NMICLR_LVD1CLR_0 = 0x0
	// Clear the NMISR.LVD1ST flag
	ICU_NMICLR_LVD1CLR_1 = 0x1
	// Position of LVD2CLR field.
	ICU_NMICLR_LVD2CLR_Pos = 0x3
	// Bit mask of LVD2CLR field.
	ICU_NMICLR_LVD2CLR_Msk = 0x8
	// Bit LVD2CLR.
	ICU_NMICLR_LVD2CLR = 0x8
	// No effect
	ICU_NMICLR_LVD2CLR_0 = 0x0
	// Clear the NMISR.LVD2ST flag.
	ICU_NMICLR_LVD2CLR_1 = 0x1
	// Position of NMICLR field.
	ICU_NMICLR_NMICLR_Pos = 0x7
	// Bit mask of NMICLR field.
	ICU_NMICLR_NMICLR_Msk = 0x80
	// Bit NMICLR.
	ICU_NMICLR_NMICLR = 0x80
	// No effect
	ICU_NMICLR_NMICLR_0 = 0x0
	// Clear the NMISR.NMIST flag
	ICU_NMICLR_NMICLR_1 = 0x1
	// Position of RPECLR field.
	ICU_NMICLR_RPECLR_Pos = 0x8
	// Bit mask of RPECLR field.
	ICU_NMICLR_RPECLR_Msk = 0x100
	// Bit RPECLR.
	ICU_NMICLR_RPECLR = 0x100
	// No effect
	ICU_NMICLR_RPECLR_0 = 0x0
	// Clear the NMISR.RPEST flag
	ICU_NMICLR_RPECLR_1 = 0x1
	// Position of BUSSCLR field.
	ICU_NMICLR_BUSSCLR_Pos = 0xa
	// Bit mask of BUSSCLR field.
	ICU_NMICLR_BUSSCLR_Msk = 0x400
	// Bit BUSSCLR.
	ICU_NMICLR_BUSSCLR = 0x400
	// No effect
	ICU_NMICLR_BUSSCLR_0 = 0x0
	// Clear the NMISR.BUSSST flag
	ICU_NMICLR_BUSSCLR_1 = 0x1
	// Position of BUSMCLR field.
	ICU_NMICLR_BUSMCLR_Pos = 0xb
	// Bit mask of BUSMCLR field.
	ICU_NMICLR_BUSMCLR_Msk = 0x800
	// Bit BUSMCLR.
	ICU_NMICLR_BUSMCLR = 0x800
	// No effect
	ICU_NMICLR_BUSMCLR_0 = 0x0
	// Clear the NMISR.BUSMST flag
	ICU_NMICLR_BUSMCLR_1 = 0x1
	// Position of SPECLR field.
	ICU_NMICLR_SPECLR_Pos = 0xc
	// Bit mask of SPECLR field.
	ICU_NMICLR_SPECLR_Msk = 0x1000
	// Bit SPECLR.
	ICU_NMICLR_SPECLR = 0x1000
	// No effect
	ICU_NMICLR_SPECLR_0 = 0x0
	// Clear the NMISR.SPEST flag
	ICU_NMICLR_SPECLR_1 = 0x1

	// NMISR: Non-Maskable Interrupt Status Register
	// Position of IWDTST field.
	ICU_NMISR_IWDTST_Pos = 0x0
	// Bit mask of IWDTST field.
	ICU_NMISR_IWDTST_Msk = 0x1
	// Bit IWDTST.
	ICU_NMISR_IWDTST = 0x1
	// Interrupt not requested
	ICU_NMISR_IWDTST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_IWDTST_1 = 0x1
	// Position of WDTST field.
	ICU_NMISR_WDTST_Pos = 0x1
	// Bit mask of WDTST field.
	ICU_NMISR_WDTST_Msk = 0x2
	// Bit WDTST.
	ICU_NMISR_WDTST = 0x2
	// Interrupt not requested
	ICU_NMISR_WDTST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_WDTST_1 = 0x1
	// Position of LVD1ST field.
	ICU_NMISR_LVD1ST_Pos = 0x2
	// Bit mask of LVD1ST field.
	ICU_NMISR_LVD1ST_Msk = 0x4
	// Bit LVD1ST.
	ICU_NMISR_LVD1ST = 0x4
	// Interrupt not requested
	ICU_NMISR_LVD1ST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_LVD1ST_1 = 0x1
	// Position of LVD2ST field.
	ICU_NMISR_LVD2ST_Pos = 0x3
	// Bit mask of LVD2ST field.
	ICU_NMISR_LVD2ST_Msk = 0x8
	// Bit LVD2ST.
	ICU_NMISR_LVD2ST = 0x8
	// Interrupt not requested
	ICU_NMISR_LVD2ST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_LVD2ST_1 = 0x1
	// Position of NMIST field.
	ICU_NMISR_NMIST_Pos = 0x7
	// Bit mask of NMIST field.
	ICU_NMISR_NMIST_Msk = 0x80
	// Bit NMIST.
	ICU_NMISR_NMIST = 0x80
	// Interrupt not requested
	ICU_NMISR_NMIST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_NMIST_1 = 0x1
	// Position of RPEST field.
	ICU_NMISR_RPEST_Pos = 0x8
	// Bit mask of RPEST field.
	ICU_NMISR_RPEST_Msk = 0x100
	// Bit RPEST.
	ICU_NMISR_RPEST = 0x100
	// Interrupt not requested
	ICU_NMISR_RPEST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_RPEST_1 = 0x1
	// Position of BUSSST field.
	ICU_NMISR_BUSSST_Pos = 0xa
	// Bit mask of BUSSST field.
	ICU_NMISR_BUSSST_Msk = 0x400
	// Bit BUSSST.
	ICU_NMISR_BUSSST = 0x400
	// Interrupt not requested
	ICU_NMISR_BUSSST_0 = 0x0
	// Interrupt requested.
	ICU_NMISR_BUSSST_1 = 0x1
	// Position of BUSMST field.
	ICU_NMISR_BUSMST_Pos = 0xb
	// Bit mask of BUSMST field.
	ICU_NMISR_BUSMST_Msk = 0x800
	// Bit BUSMST.
	ICU_NMISR_BUSMST = 0x800
	// Interrupt not requested
	ICU_NMISR_BUSMST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_BUSMST_1 = 0x1
	// Position of SPEST field.
	ICU_NMISR_SPEST_Pos = 0xc
	// Bit mask of SPEST field.
	ICU_NMISR_SPEST_Msk = 0x1000
	// Bit SPEST.
	ICU_NMISR_SPEST = 0x1000
	// Interrupt not requested
	ICU_NMISR_SPEST_0 = 0x0
	// Interrupt requested
	ICU_NMISR_SPEST_1 = 0x1

	// WUPEN: Wake Up Interrupt Enable Register
	// Position of IRQWUPEN field.
	ICU_WUPEN_IRQWUPEN_Pos = 0x0
	// Bit mask of IRQWUPEN field.
	ICU_WUPEN_IRQWUPEN_Msk = 0xff
	// Software Standby/Snooze Mode returns by IRQn interrupt disabled
	ICU_WUPEN_IRQWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by IRQn interrupt enabled
	ICU_WUPEN_IRQWUPEN_1 = 0x1
	// Position of IWDTWUPEN field.
	ICU_WUPEN_IWDTWUPEN_Pos = 0x10
	// Bit mask of IWDTWUPEN field.
	ICU_WUPEN_IWDTWUPEN_Msk = 0x10000
	// Bit IWDTWUPEN.
	ICU_WUPEN_IWDTWUPEN = 0x10000
	// Software Standby/Snooze Mode returns by IWDT interrupt disabled
	ICU_WUPEN_IWDTWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by IWDT interrupt enabled
	ICU_WUPEN_IWDTWUPEN_1 = 0x1
	// Position of KEYWUPEN field.
	ICU_WUPEN_KEYWUPEN_Pos = 0x11
	// Bit mask of KEYWUPEN field.
	ICU_WUPEN_KEYWUPEN_Msk = 0x20000
	// Bit KEYWUPEN.
	ICU_WUPEN_KEYWUPEN = 0x20000
	// Software Standby/Snooze Mode returns by KEY interrupt disabled
	ICU_WUPEN_KEYWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by KEY interrupt enabled
	ICU_WUPEN_KEYWUPEN_1 = 0x1
	// Position of LVD1WUPEN field.
	ICU_WUPEN_LVD1WUPEN_Pos = 0x12
	// Bit mask of LVD1WUPEN field.
	ICU_WUPEN_LVD1WUPEN_Msk = 0x40000
	// Bit LVD1WUPEN.
	ICU_WUPEN_LVD1WUPEN = 0x40000
	// Software Standby/Snooze Mode returns by LVD1 interrupt disabled
	ICU_WUPEN_LVD1WUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by LVD1 interrupt enabled
	ICU_WUPEN_LVD1WUPEN_1 = 0x1
	// Position of LVD2WUPEN field.
	ICU_WUPEN_LVD2WUPEN_Pos = 0x13
	// Bit mask of LVD2WUPEN field.
	ICU_WUPEN_LVD2WUPEN_Msk = 0x80000
	// Bit LVD2WUPEN.
	ICU_WUPEN_LVD2WUPEN = 0x80000
	// Software Standby/Snooze Mode returns by LVD2 interrupt disabled
	ICU_WUPEN_LVD2WUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by LVD2 interrupt enabled
	ICU_WUPEN_LVD2WUPEN_1 = 0x1
	// Position of AGT1UDWUPEN field.
	ICU_WUPEN_AGT1UDWUPEN_Pos = 0x1c
	// Bit mask of AGT1UDWUPEN field.
	ICU_WUPEN_AGT1UDWUPEN_Msk = 0x10000000
	// Bit AGT1UDWUPEN.
	ICU_WUPEN_AGT1UDWUPEN = 0x10000000
	// Software Standby/Snooze Mode returns by AGT1 underflow interrupt disabled
	ICU_WUPEN_AGT1UDWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by AGT1 underflow
	ICU_WUPEN_AGT1UDWUPEN_1 = 0x1
	// Position of AGT1CAWUPEN field.
	ICU_WUPEN_AGT1CAWUPEN_Pos = 0x1d
	// Bit mask of AGT1CAWUPEN field.
	ICU_WUPEN_AGT1CAWUPEN_Msk = 0x20000000
	// Bit AGT1CAWUPEN.
	ICU_WUPEN_AGT1CAWUPEN = 0x20000000
	// Software Standby/Snooze Mode returns by AGT1 compare match A interrupt disabled.
	ICU_WUPEN_AGT1CAWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by AGT1 compare match A interrupt enabled.
	ICU_WUPEN_AGT1CAWUPEN_1 = 0x1
	// Position of AGT1CBWUPEN field.
	ICU_WUPEN_AGT1CBWUPEN_Pos = 0x1e
	// Bit mask of AGT1CBWUPEN field.
	ICU_WUPEN_AGT1CBWUPEN_Msk = 0x40000000
	// Bit AGT1CBWUPEN.
	ICU_WUPEN_AGT1CBWUPEN = 0x40000000
	// Software Standby/Snooze Mode returns by AGT1 compare match B interrupt disabled.
	ICU_WUPEN_AGT1CBWUPEN_0 = 0x0
	// Software Standby/Snooze Mode returns by AGT1 compare match B interrupt enabled.
	ICU_WUPEN_AGT1CBWUPEN_1 = 0x1

	// IELEN: ICU event Enable Register
	// Position of IELEN field.
	ICU_IELEN_IELEN_Pos = 0x1
	// Bit mask of IELEN field.
	ICU_IELEN_IELEN_Msk = 0x2
	// Bit IELEN.
	ICU_IELEN_IELEN = 0x2
	// Disabled
	ICU_IELEN_IELEN_0 = 0x0
	// Enabled
	ICU_IELEN_IELEN_1 = 0x1
)

// Constants for DBG: Debug Function
const (
	// DBGSTR: Debug Status Register
	// Position of CDBGPWRUPREQ field.
	DBG_DBGSTR_CDBGPWRUPREQ_Pos = 0x1c
	// Bit mask of CDBGPWRUPREQ field.
	DBG_DBGSTR_CDBGPWRUPREQ_Msk = 0x10000000
	// Bit CDBGPWRUPREQ.
	DBG_DBGSTR_CDBGPWRUPREQ = 0x10000000
	// OCD is not requesting debug power up
	DBG_DBGSTR_CDBGPWRUPREQ_0 = 0x0
	// OCD is requesting debug power up
	DBG_DBGSTR_CDBGPWRUPREQ_1 = 0x1
	// Position of CDBGPWRUPACK field.
	DBG_DBGSTR_CDBGPWRUPACK_Pos = 0x1d
	// Bit mask of CDBGPWRUPACK field.
	DBG_DBGSTR_CDBGPWRUPACK_Msk = 0x20000000
	// Bit CDBGPWRUPACK.
	DBG_DBGSTR_CDBGPWRUPACK = 0x20000000
	// Debug power-up request is not acknowledged
	DBG_DBGSTR_CDBGPWRUPACK_0 = 0x0
	// Debug power-up request is acknowledged
	DBG_DBGSTR_CDBGPWRUPACK_1 = 0x1

	// DBGSTOPCR: Debug Stop Control Register
	// Position of DBGSTOP_IWDT field.
	DBG_DBGSTOPCR_DBGSTOP_IWDT_Pos = 0x0
	// Bit mask of DBGSTOP_IWDT field.
	DBG_DBGSTOPCR_DBGSTOP_IWDT_Msk = 0x1
	// Bit DBGSTOP_IWDT.
	DBG_DBGSTOPCR_DBGSTOP_IWDT = 0x1
	// Enable IWDT reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_IWDT_0 = 0x0
	// Mask IWDT reset/interrupt and stop IWDT counter
	DBG_DBGSTOPCR_DBGSTOP_IWDT_1 = 0x1
	// Position of DBGSTOP_WDT field.
	DBG_DBGSTOPCR_DBGSTOP_WDT_Pos = 0x1
	// Bit mask of DBGSTOP_WDT field.
	DBG_DBGSTOPCR_DBGSTOP_WDT_Msk = 0x2
	// Bit DBGSTOP_WDT.
	DBG_DBGSTOPCR_DBGSTOP_WDT = 0x2
	// Enable WDT reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_WDT_0 = 0x0
	// Mask WDT reset/interrupt and stop WDT counter
	DBG_DBGSTOPCR_DBGSTOP_WDT_1 = 0x1
	// Position of DBGSTOP_LVD0 field.
	DBG_DBGSTOPCR_DBGSTOP_LVD0_Pos = 0x10
	// Bit mask of DBGSTOP_LVD0 field.
	DBG_DBGSTOPCR_DBGSTOP_LVD0_Msk = 0x10000
	// Bit DBGSTOP_LVD0.
	DBG_DBGSTOPCR_DBGSTOP_LVD0 = 0x10000
	// Enable LVD0 reset
	DBG_DBGSTOPCR_DBGSTOP_LVD0_0 = 0x0
	// Mask LVD0 reset
	DBG_DBGSTOPCR_DBGSTOP_LVD0_1 = 0x1
	// Position of DBGSTOP_LVD1 field.
	DBG_DBGSTOPCR_DBGSTOP_LVD1_Pos = 0x11
	// Bit mask of DBGSTOP_LVD1 field.
	DBG_DBGSTOPCR_DBGSTOP_LVD1_Msk = 0x20000
	// Bit DBGSTOP_LVD1.
	DBG_DBGSTOPCR_DBGSTOP_LVD1 = 0x20000
	// Enable LVD1 reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_LVD1_0 = 0x0
	// Mask LVD1 reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_LVD1_1 = 0x1
	// Position of DBGSTOP_LVD2 field.
	DBG_DBGSTOPCR_DBGSTOP_LVD2_Pos = 0x12
	// Bit mask of DBGSTOP_LVD2 field.
	DBG_DBGSTOPCR_DBGSTOP_LVD2_Msk = 0x40000
	// Bit DBGSTOP_LVD2.
	DBG_DBGSTOPCR_DBGSTOP_LVD2 = 0x40000
	// Enable LVD2 reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_LVD2_0 = 0x0
	// Mask LVD2 reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_LVD2_1 = 0x1
	// Position of DBGSTOP_RPER field.
	DBG_DBGSTOPCR_DBGSTOP_RPER_Pos = 0x18
	// Bit mask of DBGSTOP_RPER field.
	DBG_DBGSTOPCR_DBGSTOP_RPER_Msk = 0x1000000
	// Bit DBGSTOP_RPER.
	DBG_DBGSTOPCR_DBGSTOP_RPER = 0x1000000
	// Enable SRAM parity error reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_RPER_0 = 0x0
	// Mask SRAM parity error reset/interrupt
	DBG_DBGSTOPCR_DBGSTOP_RPER_1 = 0x1
)

// Constants for SYSC: System Control
const (
	// SBYCR: Standby Control Register
	// Position of SSBY field.
	SYSC_SBYCR_SSBY_Pos = 0xf
	// Bit mask of SSBY field.
	SYSC_SBYCR_SSBY_Msk = 0x8000
	// Bit SSBY.
	SYSC_SBYCR_SSBY = 0x8000
	// Sleep mode
	SYSC_SBYCR_SSBY_0 = 0x0
	// Software Standby mode.
	SYSC_SBYCR_SSBY_1 = 0x1

	// MSTPCRA: Module Stop Control Register A
	// Position of MSTPA22 field.
	SYSC_MSTPCRA_MSTPA22_Pos = 0x16
	// Bit mask of MSTPA22 field.
	SYSC_MSTPCRA_MSTPA22_Msk = 0x400000
	// Bit MSTPA22.
	SYSC_MSTPCRA_MSTPA22 = 0x400000
	// Cancel the module-stop state
	SYSC_MSTPCRA_MSTPA22_0 = 0x0
	// Enter the module-stop state
	SYSC_MSTPCRA_MSTPA22_1 = 0x1

	// SCKDIVCR: System Clock Division Control Register
	// Position of PCKD field.
	SYSC_SCKDIVCR_PCKD_Pos = 0x0
	// Bit mask of PCKD field.
	SYSC_SCKDIVCR_PCKD_Msk = 0x7
	// x 1/1
	SYSC_SCKDIVCR_PCKD_000 = 0x0
	// x 1/2
	SYSC_SCKDIVCR_PCKD_001 = 0x1
	// x 1/4
	SYSC_SCKDIVCR_PCKD_010 = 0x2
	// x 1/8
	SYSC_SCKDIVCR_PCKD_011 = 0x3
	// x 1/16
	SYSC_SCKDIVCR_PCKD_100 = 0x4
	// x 1/32
	SYSC_SCKDIVCR_PCKD_101 = 0x5
	// x 1/64
	SYSC_SCKDIVCR_PCKD_110 = 0x6
	// Position of PCKB field.
	SYSC_SCKDIVCR_PCKB_Pos = 0x8
	// Bit mask of PCKB field.
	SYSC_SCKDIVCR_PCKB_Msk = 0x700
	// x 1/1
	SYSC_SCKDIVCR_PCKB_000 = 0x0
	// x 1/2
	SYSC_SCKDIVCR_PCKB_001 = 0x1
	// x 1/4
	SYSC_SCKDIVCR_PCKB_010 = 0x2
	// x 1/8
	SYSC_SCKDIVCR_PCKB_011 = 0x3
	// x 1/16
	SYSC_SCKDIVCR_PCKB_100 = 0x4
	// x 1/32
	SYSC_SCKDIVCR_PCKB_101 = 0x5
	// x 1/64
	SYSC_SCKDIVCR_PCKB_110 = 0x6
	// Position of ICK field.
	SYSC_SCKDIVCR_ICK_Pos = 0x18
	// Bit mask of ICK field.
	SYSC_SCKDIVCR_ICK_Msk = 0x7000000
	// x 1/1
	SYSC_SCKDIVCR_ICK_000 = 0x0
	// x 1/2
	SYSC_SCKDIVCR_ICK_001 = 0x1
	// x 1/4
	SYSC_SCKDIVCR_ICK_010 = 0x2
	// x 1/8
	SYSC_SCKDIVCR_ICK_011 = 0x3
	// x 1/16
	SYSC_SCKDIVCR_ICK_100 = 0x4
	// x 1/32
	SYSC_SCKDIVCR_ICK_101 = 0x5
	// x 1/64
	SYSC_SCKDIVCR_ICK_110 = 0x6

	// SCKSCR: System Clock Source Control Register
	// Position of CKSEL field.
	SYSC_SCKSCR_CKSEL_Pos = 0x0
	// Bit mask of CKSEL field.
	SYSC_SCKSCR_CKSEL_Msk = 0x7
	// HOCO
	SYSC_SCKSCR_CKSEL_000 = 0x0
	// MOCO
	SYSC_SCKSCR_CKSEL_001 = 0x1
	// LOCO
	SYSC_SCKSCR_CKSEL_010 = 0x2
	// Setting prohibited
	SYSC_SCKSCR_CKSEL_011 = 0x3
	// Setting prohibited
	SYSC_SCKSCR_CKSEL_100 = 0x4
	// Setting prohibited
	SYSC_SCKSCR_CKSEL_101 = 0x5
	// Setting prohibited
	SYSC_SCKSCR_CKSEL_110 = 0x6
	// Setting prohibited
	SYSC_SCKSCR_CKSEL_111 = 0x7

	// MEMWAIT: Memory Wait Cycle Control Register for Code Flash
	// Position of MEMWAIT field.
	SYSC_MEMWAIT_MEMWAIT_Pos = 0x0
	// Bit mask of MEMWAIT field.
	SYSC_MEMWAIT_MEMWAIT_Msk = 0x1
	// Bit MEMWAIT.
	SYSC_MEMWAIT_MEMWAIT = 0x1
	// No wait
	SYSC_MEMWAIT_MEMWAIT_0 = 0x0
	// Wait
	SYSC_MEMWAIT_MEMWAIT_1 = 0x1

	// HOCOCR: High-Speed On-Chip Oscillator Control Register
	// Position of HCSTP field.
	SYSC_HOCOCR_HCSTP_Pos = 0x0
	// Bit mask of HCSTP field.
	SYSC_HOCOCR_HCSTP_Msk = 0x1
	// Bit HCSTP.
	SYSC_HOCOCR_HCSTP = 0x1
	// Operate the HOCO clock
	SYSC_HOCOCR_HCSTP_0 = 0x0
	// Stop the HOCO clock
	SYSC_HOCOCR_HCSTP_1 = 0x1

	// MOCOCR: Middle-Speed On-Chip Oscillator Control Register
	// Position of MCSTP field.
	SYSC_MOCOCR_MCSTP_Pos = 0x0
	// Bit mask of MCSTP field.
	SYSC_MOCOCR_MCSTP_Msk = 0x1
	// Bit MCSTP.
	SYSC_MOCOCR_MCSTP = 0x1
	// MOCO clock is operating
	SYSC_MOCOCR_MCSTP_0 = 0x0
	// MOCO clock is stopped
	SYSC_MOCOCR_MCSTP_1 = 0x1

	// OSCSF: Oscillation Stabilization Flag Register
	// Position of HOCOSF field.
	SYSC_OSCSF_HOCOSF_Pos = 0x0
	// Bit mask of HOCOSF field.
	SYSC_OSCSF_HOCOSF_Msk = 0x1
	// Bit HOCOSF.
	SYSC_OSCSF_HOCOSF = 0x1
	// The HOCO clock is stopped or is not yet stable
	SYSC_OSCSF_HOCOSF_0 = 0x0
	// The HOCO clock is stable, so is available for use as the system clock
	SYSC_OSCSF_HOCOSF_1 = 0x1

	// CKOCR: Clock Out Control Register
	// Position of CKOSEL field.
	SYSC_CKOCR_CKOSEL_Pos = 0x0
	// Bit mask of CKOSEL field.
	SYSC_CKOCR_CKOSEL_Msk = 0x7
	// HOCO (value after reset)
	SYSC_CKOCR_CKOSEL_000 = 0x0
	// MOCO
	SYSC_CKOCR_CKOSEL_001 = 0x1
	// LOCO
	SYSC_CKOCR_CKOSEL_010 = 0x2
	// Setting prohibited
	SYSC_CKOCR_CKOSEL_011 = 0x3
	// Setting prohibited
	SYSC_CKOCR_CKOSEL_100 = 0x4
	// Setting prohibited
	SYSC_CKOCR_CKOSEL_101 = 0x5
	// Position of CKODIV field.
	SYSC_CKOCR_CKODIV_Pos = 0x4
	// Bit mask of CKODIV field.
	SYSC_CKOCR_CKODIV_Msk = 0x70
	// x 1/1
	SYSC_CKOCR_CKODIV_000 = 0x0
	// x 1/2
	SYSC_CKOCR_CKODIV_001 = 0x1
	// x 1/4
	SYSC_CKOCR_CKODIV_010 = 0x2
	// x 1/8
	SYSC_CKOCR_CKODIV_011 = 0x3
	// x 1/16
	SYSC_CKOCR_CKODIV_100 = 0x4
	// x 1/32
	SYSC_CKOCR_CKODIV_101 = 0x5
	// x 1/64
	SYSC_CKOCR_CKODIV_110 = 0x6
	// x 1/128
	SYSC_CKOCR_CKODIV_111 = 0x7
	// Position of CKOEN field.
	SYSC_CKOCR_CKOEN_Pos = 0x7
	// Bit mask of CKOEN field.
	SYSC_CKOCR_CKOEN_Msk = 0x80
	// Bit CKOEN.
	SYSC_CKOCR_CKOEN = 0x80
	// Disable clock out
	SYSC_CKOCR_CKOEN_0 = 0x0
	// Enable clock out
	SYSC_CKOCR_CKOEN_1 = 0x1

	// LPOPT: Lower Power Operation Control Register
	// Position of MPUDIS field.
	SYSC_LPOPT_MPUDIS_Pos = 0x0
	// Bit mask of MPUDIS field.
	SYSC_LPOPT_MPUDIS_Msk = 0x1
	// Bit MPUDIS.
	SYSC_LPOPT_MPUDIS = 0x1
	// MPU operates as normal
	SYSC_LPOPT_MPUDIS_0 = 0x0
	// MPU operate clock stops (MPU function disable).
	SYSC_LPOPT_MPUDIS_1 = 0x1
	// Position of DCLKDIS field.
	SYSC_LPOPT_DCLKDIS_Pos = 0x1
	// Bit mask of DCLKDIS field.
	SYSC_LPOPT_DCLKDIS_Msk = 0x6
	// Debug clock does not stop
	SYSC_LPOPT_DCLKDIS_00 = 0x0
	// Position of BPFCLKDIS field.
	SYSC_LPOPT_BPFCLKDIS_Pos = 0x3
	// Bit mask of BPFCLKDIS field.
	SYSC_LPOPT_BPFCLKDIS_Msk = 0x8
	// Bit BPFCLKDIS.
	SYSC_LPOPT_BPFCLKDIS = 0x8
	// Flash register R/W clock operates as normal
	SYSC_LPOPT_BPFCLKDIS_0 = 0x0
	// Flash register R/W clock stops.
	SYSC_LPOPT_BPFCLKDIS_1 = 0x1
	// Position of LPOPTEN field.
	SYSC_LPOPT_LPOPTEN_Pos = 0x7
	// Bit mask of LPOPTEN field.
	SYSC_LPOPT_LPOPTEN_Msk = 0x80
	// Bit LPOPTEN.
	SYSC_LPOPT_LPOPTEN = 0x80
	// All lower power counter measure disable
	SYSC_LPOPT_LPOPTEN_0 = 0x0
	// All lower power counter measure enable
	SYSC_LPOPT_LPOPTEN_1 = 0x1

	// MOCOUTCR: MOCO User Trimming Control Register
	// Position of MOCOUTRM field.
	SYSC_MOCOUTCR_MOCOUTRM_Pos = 0x0
	// Bit mask of MOCOUTRM field.
	SYSC_MOCOUTCR_MOCOUTRM_Msk = 0xff

	// HOCOUTCR: HOCO User Trimming Control Register
	// Position of HOCOUTRM field.
	SYSC_HOCOUTCR_HOCOUTRM_Pos = 0x0
	// Bit mask of HOCOUTRM field.
	SYSC_HOCOUTCR_HOCOUTRM_Msk = 0xff

	// SNZCR: Snooze Control Register
	// Position of SNZDTCEN field.
	SYSC_SNZCR_SNZDTCEN_Pos = 0x1
	// Bit mask of SNZDTCEN field.
	SYSC_SNZCR_SNZDTCEN_Msk = 0x2
	// Bit SNZDTCEN.
	SYSC_SNZCR_SNZDTCEN = 0x2
	// Disable DTC operation
	SYSC_SNZCR_SNZDTCEN_0 = 0x0
	// Enable DTC operation
	SYSC_SNZCR_SNZDTCEN_1 = 0x1
	// Position of SNZE field.
	SYSC_SNZCR_SNZE_Pos = 0x7
	// Bit mask of SNZE field.
	SYSC_SNZCR_SNZE_Msk = 0x80
	// Bit SNZE.
	SYSC_SNZCR_SNZE = 0x80
	// Disable Snooze mode
	SYSC_SNZCR_SNZE_0 = 0x0
	// Enable Snooze mode
	SYSC_SNZCR_SNZE_1 = 0x1

	// SNZEDCR0: Snooze End Control Register 0
	// Position of AGTUNFED field.
	SYSC_SNZEDCR0_AGTUNFED_Pos = 0x0
	// Bit mask of AGTUNFED field.
	SYSC_SNZEDCR0_AGTUNFED_Msk = 0x1
	// Bit AGTUNFED.
	SYSC_SNZEDCR0_AGTUNFED = 0x1
	// Disable the snooze end request
	SYSC_SNZEDCR0_AGTUNFED_0 = 0x0
	// Enable the snooze end request
	SYSC_SNZEDCR0_AGTUNFED_1 = 0x1
	// Position of DTCZRED field.
	SYSC_SNZEDCR0_DTCZRED_Pos = 0x1
	// Bit mask of DTCZRED field.
	SYSC_SNZEDCR0_DTCZRED_Msk = 0x2
	// Bit DTCZRED.
	SYSC_SNZEDCR0_DTCZRED = 0x2
	// Disable the snooze end request
	SYSC_SNZEDCR0_DTCZRED_0 = 0x0
	// Enable the snooze end request
	SYSC_SNZEDCR0_DTCZRED_1 = 0x1
	// Position of DTCNZRED field.
	SYSC_SNZEDCR0_DTCNZRED_Pos = 0x2
	// Bit mask of DTCNZRED field.
	SYSC_SNZEDCR0_DTCNZRED_Msk = 0x4
	// Bit DTCNZRED.
	SYSC_SNZEDCR0_DTCNZRED = 0x4
	// Disable the snooze end request
	SYSC_SNZEDCR0_DTCNZRED_0 = 0x0
	// Enable the snooze end request
	SYSC_SNZEDCR0_DTCNZRED_1 = 0x1
	// Position of AD0MATED field.
	SYSC_SNZEDCR0_AD0MATED_Pos = 0x3
	// Bit mask of AD0MATED field.
	SYSC_SNZEDCR0_AD0MATED_Msk = 0x8
	// Bit AD0MATED.
	SYSC_SNZEDCR0_AD0MATED = 0x8
	// Disable the snooze end request
	SYSC_SNZEDCR0_AD0MATED_0 = 0x0
	// Enable the snooze end request
	SYSC_SNZEDCR0_AD0MATED_1 = 0x1
	// Position of AD0UMTED field.
	SYSC_SNZEDCR0_AD0UMTED_Pos = 0x4
	// Bit mask of AD0UMTED field.
	SYSC_SNZEDCR0_AD0UMTED_Msk = 0x10
	// Bit AD0UMTED.
	SYSC_SNZEDCR0_AD0UMTED = 0x10
	// Disable the snooze end request
	SYSC_SNZEDCR0_AD0UMTED_0 = 0x0
	// Enable the snooze end request
	SYSC_SNZEDCR0_AD0UMTED_1 = 0x1

	// SNZREQCR0: Snooze Request Control Register 0
	// Position of SNZREQEN0 field.
	SYSC_SNZREQCR0_SNZREQEN0_Pos = 0x0
	// Bit mask of SNZREQEN0 field.
	SYSC_SNZREQCR0_SNZREQEN0_Msk = 0x1
	// Bit SNZREQEN0.
	SYSC_SNZREQCR0_SNZREQEN0 = 0x1
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN0_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN0_1 = 0x1
	// Position of SNZREQEN1 field.
	SYSC_SNZREQCR0_SNZREQEN1_Pos = 0x1
	// Bit mask of SNZREQEN1 field.
	SYSC_SNZREQCR0_SNZREQEN1_Msk = 0x2
	// Bit SNZREQEN1.
	SYSC_SNZREQCR0_SNZREQEN1 = 0x2
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN1_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN1_1 = 0x1
	// Position of SNZREQEN2 field.
	SYSC_SNZREQCR0_SNZREQEN2_Pos = 0x2
	// Bit mask of SNZREQEN2 field.
	SYSC_SNZREQCR0_SNZREQEN2_Msk = 0x4
	// Bit SNZREQEN2.
	SYSC_SNZREQCR0_SNZREQEN2 = 0x4
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN2_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN2_1 = 0x1
	// Position of SNZREQEN3 field.
	SYSC_SNZREQCR0_SNZREQEN3_Pos = 0x3
	// Bit mask of SNZREQEN3 field.
	SYSC_SNZREQCR0_SNZREQEN3_Msk = 0x8
	// Bit SNZREQEN3.
	SYSC_SNZREQCR0_SNZREQEN3 = 0x8
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN3_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN3_1 = 0x1
	// Position of SNZREQEN4 field.
	SYSC_SNZREQCR0_SNZREQEN4_Pos = 0x4
	// Bit mask of SNZREQEN4 field.
	SYSC_SNZREQCR0_SNZREQEN4_Msk = 0x10
	// Bit SNZREQEN4.
	SYSC_SNZREQCR0_SNZREQEN4 = 0x10
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN4_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN4_1 = 0x1
	// Position of SNZREQEN5 field.
	SYSC_SNZREQCR0_SNZREQEN5_Pos = 0x5
	// Bit mask of SNZREQEN5 field.
	SYSC_SNZREQCR0_SNZREQEN5_Msk = 0x20
	// Bit SNZREQEN5.
	SYSC_SNZREQCR0_SNZREQEN5 = 0x20
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN5_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN5_1 = 0x1
	// Position of SNZREQEN6 field.
	SYSC_SNZREQCR0_SNZREQEN6_Pos = 0x6
	// Bit mask of SNZREQEN6 field.
	SYSC_SNZREQCR0_SNZREQEN6_Msk = 0x40
	// Bit SNZREQEN6.
	SYSC_SNZREQCR0_SNZREQEN6 = 0x40
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN6_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN6_1 = 0x1
	// Position of SNZREQEN7 field.
	SYSC_SNZREQCR0_SNZREQEN7_Pos = 0x7
	// Bit mask of SNZREQEN7 field.
	SYSC_SNZREQCR0_SNZREQEN7_Msk = 0x80
	// Bit SNZREQEN7.
	SYSC_SNZREQCR0_SNZREQEN7 = 0x80
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN7_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN7_1 = 0x1
	// Position of SNZREQEN17 field.
	SYSC_SNZREQCR0_SNZREQEN17_Pos = 0x11
	// Bit mask of SNZREQEN17 field.
	SYSC_SNZREQCR0_SNZREQEN17_Msk = 0x20000
	// Bit SNZREQEN17.
	SYSC_SNZREQCR0_SNZREQEN17 = 0x20000
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN17_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN17_1 = 0x1
	// Position of SNZREQEN28 field.
	SYSC_SNZREQCR0_SNZREQEN28_Pos = 0x1c
	// Bit mask of SNZREQEN28 field.
	SYSC_SNZREQCR0_SNZREQEN28_Msk = 0x10000000
	// Bit SNZREQEN28.
	SYSC_SNZREQCR0_SNZREQEN28 = 0x10000000
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN28_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN28_1 = 0x1
	// Position of SNZREQEN29 field.
	SYSC_SNZREQCR0_SNZREQEN29_Pos = 0x1d
	// Bit mask of SNZREQEN29 field.
	SYSC_SNZREQCR0_SNZREQEN29_Msk = 0x20000000
	// Bit SNZREQEN29.
	SYSC_SNZREQCR0_SNZREQEN29 = 0x20000000
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN29_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN29_1 = 0x1
	// Position of SNZREQEN30 field.
	SYSC_SNZREQCR0_SNZREQEN30_Pos = 0x1e
	// Bit mask of SNZREQEN30 field.
	SYSC_SNZREQCR0_SNZREQEN30_Msk = 0x40000000
	// Bit SNZREQEN30.
	SYSC_SNZREQCR0_SNZREQEN30 = 0x40000000
	// Disable the snooze request
	SYSC_SNZREQCR0_SNZREQEN30_0 = 0x0
	// Enable the snooze request
	SYSC_SNZREQCR0_SNZREQEN30_1 = 0x1

	// PSMCR: Power Save Memory Control Register
	// Position of PSMC field.
	SYSC_PSMCR_PSMC_Pos = 0x0
	// Bit mask of PSMC field.
	SYSC_PSMCR_PSMC_Msk = 0x3
	// All SRAMs are on in Software Standby mode
	SYSC_PSMCR_PSMC_00 = 0x0
	// 4 KB SRAM (0x2000_4000 to 0x2000_4FFF) is on in Software Standby mode
	SYSC_PSMCR_PSMC_01 = 0x1
	// Setting prohibited
	SYSC_PSMCR_PSMC_10 = 0x2
	// Setting prohibited
	SYSC_PSMCR_PSMC_11 = 0x3

	// OPCCR: Operating Power Control Register
	// Position of OPCM field.
	SYSC_OPCCR_OPCM_Pos = 0x0
	// Bit mask of OPCM field.
	SYSC_OPCCR_OPCM_Msk = 0x3
	// High-speed mode
	SYSC_OPCCR_OPCM_00 = 0x0
	// Middle-speed mode
	SYSC_OPCCR_OPCM_01 = 0x1
	// Setting prohibited
	SYSC_OPCCR_OPCM_10 = 0x2
	// Low-speed mode
	SYSC_OPCCR_OPCM_11 = 0x3
	// Position of OPCMTSF field.
	SYSC_OPCCR_OPCMTSF_Pos = 0x4
	// Bit mask of OPCMTSF field.
	SYSC_OPCCR_OPCMTSF_Msk = 0x10
	// Bit OPCMTSF.
	SYSC_OPCCR_OPCMTSF = 0x10
	// Transition completed
	SYSC_OPCCR_OPCMTSF_0 = 0x0
	// During transition
	SYSC_OPCCR_OPCMTSF_1 = 0x1

	// HOCOWTCR: High-Speed On-Chip Oscillator Wait Control Register
	// Position of HSTS field.
	SYSC_HOCOWTCR_HSTS_Pos = 0x0
	// Bit mask of HSTS field.
	SYSC_HOCOWTCR_HSTS_Msk = 0x7
	// Value after reset.
	SYSC_HOCOWTCR_HSTS_101 = 0x5
	// Before starting high-speed on-chip oscillator by setting HOCOCR.HCSTP bit, the HSTS[2:0] bits must be set to 011b beforehand. Wait time = 46 cycles (5.75 µs) Wait time is calculated at MOCO = 8 MHz (typically 0.125 µs).
	SYSC_HOCOWTCR_HSTS_011 = 0x3

	// SOPCCR: Sub Operating Power Control Register
	// Position of SOPCM field.
	SYSC_SOPCCR_SOPCM_Pos = 0x0
	// Bit mask of SOPCM field.
	SYSC_SOPCCR_SOPCM_Msk = 0x1
	// Bit SOPCM.
	SYSC_SOPCCR_SOPCM = 0x1
	// Other than Subosc-speed mode
	SYSC_SOPCCR_SOPCM_0 = 0x0
	// Subosc-speed mode
	SYSC_SOPCCR_SOPCM_1 = 0x1
	// Position of SOPCMTSF field.
	SYSC_SOPCCR_SOPCMTSF_Pos = 0x4
	// Bit mask of SOPCMTSF field.
	SYSC_SOPCCR_SOPCMTSF_Msk = 0x10
	// Bit SOPCMTSF.
	SYSC_SOPCCR_SOPCMTSF = 0x10
	// Transition completed
	SYSC_SOPCCR_SOPCMTSF_0 = 0x0
	// During transition
	SYSC_SOPCCR_SOPCMTSF_1 = 0x1

	// RSTSR1: Reset Status Register 1
	// Position of IWDTRF field.
	SYSC_RSTSR1_IWDTRF_Pos = 0x0
	// Bit mask of IWDTRF field.
	SYSC_RSTSR1_IWDTRF_Msk = 0x1
	// Bit IWDTRF.
	SYSC_RSTSR1_IWDTRF = 0x1
	// Independent watchdog timer reset not detected
	SYSC_RSTSR1_IWDTRF_0 = 0x0
	// Independent watchdog timer reset detected
	SYSC_RSTSR1_IWDTRF_1 = 0x1
	// Position of WDTRF field.
	SYSC_RSTSR1_WDTRF_Pos = 0x1
	// Bit mask of WDTRF field.
	SYSC_RSTSR1_WDTRF_Msk = 0x2
	// Bit WDTRF.
	SYSC_RSTSR1_WDTRF = 0x2
	// Watchdog timer reset not detected
	SYSC_RSTSR1_WDTRF_0 = 0x0
	// Watchdog timer reset detected
	SYSC_RSTSR1_WDTRF_1 = 0x1
	// Position of SWRF field.
	SYSC_RSTSR1_SWRF_Pos = 0x2
	// Bit mask of SWRF field.
	SYSC_RSTSR1_SWRF_Msk = 0x4
	// Bit SWRF.
	SYSC_RSTSR1_SWRF = 0x4
	// Software reset not detected
	SYSC_RSTSR1_SWRF_0 = 0x0
	// Software reset detected
	SYSC_RSTSR1_SWRF_1 = 0x1
	// Position of RPERF field.
	SYSC_RSTSR1_RPERF_Pos = 0x8
	// Bit mask of RPERF field.
	SYSC_RSTSR1_RPERF_Msk = 0x100
	// Bit RPERF.
	SYSC_RSTSR1_RPERF = 0x100
	// SRAM parity error reset not detected
	SYSC_RSTSR1_RPERF_0 = 0x0
	// SRAM parity error reset detected
	SYSC_RSTSR1_RPERF_1 = 0x1
	// Position of BUSSRF field.
	SYSC_RSTSR1_BUSSRF_Pos = 0xa
	// Bit mask of BUSSRF field.
	SYSC_RSTSR1_BUSSRF_Msk = 0x400
	// Bit BUSSRF.
	SYSC_RSTSR1_BUSSRF = 0x400
	// Bus slave MPU error reset not detected
	SYSC_RSTSR1_BUSSRF_0 = 0x0
	// Bus slave MPU error reset detected
	SYSC_RSTSR1_BUSSRF_1 = 0x1
	// Position of BUSMRF field.
	SYSC_RSTSR1_BUSMRF_Pos = 0xb
	// Bit mask of BUSMRF field.
	SYSC_RSTSR1_BUSMRF_Msk = 0x800
	// Bit BUSMRF.
	SYSC_RSTSR1_BUSMRF = 0x800
	// Bus master MPU error reset not detected
	SYSC_RSTSR1_BUSMRF_0 = 0x0
	// Bus master MPU error reset detected
	SYSC_RSTSR1_BUSMRF_1 = 0x1
	// Position of SPERF field.
	SYSC_RSTSR1_SPERF_Pos = 0xc
	// Bit mask of SPERF field.
	SYSC_RSTSR1_SPERF_Msk = 0x1000
	// Bit SPERF.
	SYSC_RSTSR1_SPERF = 0x1000
	// CPU stack pointer error reset not detected
	SYSC_RSTSR1_SPERF_0 = 0x0
	// CPU stack pointer error reset detected
	SYSC_RSTSR1_SPERF_1 = 0x1

	// LVD1CR1: Voltage Monitor 1 Circuit Control Register
	// Position of IDTSEL field.
	SYSC_LVD1CR1_IDTSEL_Pos = 0x0
	// Bit mask of IDTSEL field.
	SYSC_LVD1CR1_IDTSEL_Msk = 0x3
	// When VCC >= Vdet1 (rise) is detected
	SYSC_LVD1CR1_IDTSEL_00 = 0x0
	// When VCC < Vdet1 (fall) is detected
	SYSC_LVD1CR1_IDTSEL_01 = 0x1
	// When fall and rise are detected
	SYSC_LVD1CR1_IDTSEL_10 = 0x2
	// Settings prohibited
	SYSC_LVD1CR1_IDTSEL_11 = 0x3
	// Position of IRQSEL field.
	SYSC_LVD1CR1_IRQSEL_Pos = 0x2
	// Bit mask of IRQSEL field.
	SYSC_LVD1CR1_IRQSEL_Msk = 0x4
	// Bit IRQSEL.
	SYSC_LVD1CR1_IRQSEL = 0x4
	// Non-maskable interrupt
	SYSC_LVD1CR1_IRQSEL_0 = 0x0
	// Maskable interrupt
	SYSC_LVD1CR1_IRQSEL_1 = 0x1

	// LVD1SR: Voltage Monitor 1 Circuit Status Register
	// Position of DET field.
	SYSC_LVD1SR_DET_Pos = 0x0
	// Bit mask of DET field.
	SYSC_LVD1SR_DET_Msk = 0x1
	// Bit DET.
	SYSC_LVD1SR_DET = 0x1
	// Not detected
	SYSC_LVD1SR_DET_0 = 0x0
	// Vdet1 crossing is detected
	SYSC_LVD1SR_DET_1 = 0x1
	// Position of MON field.
	SYSC_LVD1SR_MON_Pos = 0x1
	// Bit mask of MON field.
	SYSC_LVD1SR_MON_Msk = 0x2
	// Bit MON.
	SYSC_LVD1SR_MON = 0x2
	// VCC < Vdet1
	SYSC_LVD1SR_MON_0 = 0x0
	// VCC >= Vdet1 or MON is disabled
	SYSC_LVD1SR_MON_1 = 0x1

	// LVD2CR1: Voltage Monitor 2 Circuit Control Register 1
	// Position of IDTSEL field.
	SYSC_LVD2CR1_IDTSEL_Pos = 0x0
	// Bit mask of IDTSEL field.
	SYSC_LVD2CR1_IDTSEL_Msk = 0x3
	// When VCC>= Vdet2 (rise) is detected
	SYSC_LVD2CR1_IDTSEL_00 = 0x0
	// When VCC < Vdet2 (fall) is detected
	SYSC_LVD2CR1_IDTSEL_01 = 0x1
	// When fall and rise are detected
	SYSC_LVD2CR1_IDTSEL_10 = 0x2
	// Settings prohibited
	SYSC_LVD2CR1_IDTSEL_11 = 0x3
	// Position of IRQSEL field.
	SYSC_LVD2CR1_IRQSEL_Pos = 0x2
	// Bit mask of IRQSEL field.
	SYSC_LVD2CR1_IRQSEL_Msk = 0x4
	// Bit IRQSEL.
	SYSC_LVD2CR1_IRQSEL = 0x4
	// Non-maskable interrupt
	SYSC_LVD2CR1_IRQSEL_0 = 0x0
	// Maskable interrupt
	SYSC_LVD2CR1_IRQSEL_1 = 0x1

	// LVD2SR: Voltage Monitor 2 Circuit Status Register
	// Position of DET field.
	SYSC_LVD2SR_DET_Pos = 0x0
	// Bit mask of DET field.
	SYSC_LVD2SR_DET_Msk = 0x1
	// Bit DET.
	SYSC_LVD2SR_DET = 0x1
	// Not detected
	SYSC_LVD2SR_DET_0 = 0x0
	// Vdet2 crossing is detected
	SYSC_LVD2SR_DET_1 = 0x1
	// Position of MON field.
	SYSC_LVD2SR_MON_Pos = 0x1
	// Bit mask of MON field.
	SYSC_LVD2SR_MON_Msk = 0x2
	// Bit MON.
	SYSC_LVD2SR_MON = 0x2
	// VCC < Vdet2
	SYSC_LVD2SR_MON_0 = 0x0
	// VCC>= Vdet2 or MON is disabled
	SYSC_LVD2SR_MON_1 = 0x1

	// PRCR: Protect Register
	// Position of PRC0 field.
	SYSC_PRCR_PRC0_Pos = 0x0
	// Bit mask of PRC0 field.
	SYSC_PRCR_PRC0_Msk = 0x1
	// Bit PRC0.
	SYSC_PRCR_PRC0 = 0x1
	// Disable writes
	SYSC_PRCR_PRC0_0 = 0x0
	// Enable writes
	SYSC_PRCR_PRC0_1 = 0x1
	// Position of PRC1 field.
	SYSC_PRCR_PRC1_Pos = 0x1
	// Bit mask of PRC1 field.
	SYSC_PRCR_PRC1_Msk = 0x2
	// Bit PRC1.
	SYSC_PRCR_PRC1 = 0x2
	// Disable writes
	SYSC_PRCR_PRC1_0 = 0x0
	// Enable writes
	SYSC_PRCR_PRC1_1 = 0x1
	// Position of PRC3 field.
	SYSC_PRCR_PRC3_Pos = 0x3
	// Bit mask of PRC3 field.
	SYSC_PRCR_PRC3_Msk = 0x8
	// Bit PRC3.
	SYSC_PRCR_PRC3 = 0x8
	// Disable writes
	SYSC_PRCR_PRC3_0 = 0x0
	// Enable writes
	SYSC_PRCR_PRC3_1 = 0x1
	// Position of PRKEY field.
	SYSC_PRCR_PRKEY_Pos = 0x8
	// Bit mask of PRKEY field.
	SYSC_PRCR_PRKEY_Msk = 0xff00

	// SYOCDCR: System Control OCD Control Register
	// Position of DBGEN field.
	SYSC_SYOCDCR_DBGEN_Pos = 0x7
	// Bit mask of DBGEN field.
	SYSC_SYOCDCR_DBGEN_Msk = 0x80
	// Bit DBGEN.
	SYSC_SYOCDCR_DBGEN = 0x80
	// On-chip debugger is disabled
	SYSC_SYOCDCR_DBGEN_0 = 0x0
	// On-chip debugger is enabled
	SYSC_SYOCDCR_DBGEN_1 = 0x1

	// RSTSR0: Reset Status Register 0
	// Position of PORF field.
	SYSC_RSTSR0_PORF_Pos = 0x0
	// Bit mask of PORF field.
	SYSC_RSTSR0_PORF_Msk = 0x1
	// Bit PORF.
	SYSC_RSTSR0_PORF = 0x1
	// Power-on reset not detected
	SYSC_RSTSR0_PORF_0 = 0x0
	// Power-on reset detected
	SYSC_RSTSR0_PORF_1 = 0x1
	// Position of LVD0RF field.
	SYSC_RSTSR0_LVD0RF_Pos = 0x1
	// Bit mask of LVD0RF field.
	SYSC_RSTSR0_LVD0RF_Msk = 0x2
	// Bit LVD0RF.
	SYSC_RSTSR0_LVD0RF = 0x2
	// Voltage monitor 0 reset not detected
	SYSC_RSTSR0_LVD0RF_0 = 0x0
	// Voltage monitor 0 reset detected
	SYSC_RSTSR0_LVD0RF_1 = 0x1
	// Position of LVD1RF field.
	SYSC_RSTSR0_LVD1RF_Pos = 0x2
	// Bit mask of LVD1RF field.
	SYSC_RSTSR0_LVD1RF_Msk = 0x4
	// Bit LVD1RF.
	SYSC_RSTSR0_LVD1RF = 0x4
	// Voltage monitor 1 reset not detected
	SYSC_RSTSR0_LVD1RF_0 = 0x0
	// Voltage monitor 1 reset detected
	SYSC_RSTSR0_LVD1RF_1 = 0x1
	// Position of LVD2RF field.
	SYSC_RSTSR0_LVD2RF_Pos = 0x3
	// Bit mask of LVD2RF field.
	SYSC_RSTSR0_LVD2RF_Msk = 0x8
	// Bit LVD2RF.
	SYSC_RSTSR0_LVD2RF = 0x8
	// Voltage monitor 2 reset not detected
	SYSC_RSTSR0_LVD2RF_0 = 0x0
	// Voltage monitor 2 reset detected
	SYSC_RSTSR0_LVD2RF_1 = 0x1

	// RSTSR2: Reset Status Register 2
	// Position of CWSF field.
	SYSC_RSTSR2_CWSF_Pos = 0x0
	// Bit mask of CWSF field.
	SYSC_RSTSR2_CWSF_Msk = 0x1
	// Bit CWSF.
	SYSC_RSTSR2_CWSF = 0x1
	// Cold start
	SYSC_RSTSR2_CWSF_0 = 0x0
	// Warm start
	SYSC_RSTSR2_CWSF_1 = 0x1

	// LVCMPCR: Voltage Monitor Circuit Control Register
	// Position of LVD1E field.
	SYSC_LVCMPCR_LVD1E_Pos = 0x5
	// Bit mask of LVD1E field.
	SYSC_LVCMPCR_LVD1E_Msk = 0x20
	// Bit LVD1E.
	SYSC_LVCMPCR_LVD1E = 0x20
	// Voltage detection 1 circuit disabled
	SYSC_LVCMPCR_LVD1E_0 = 0x0
	// Voltage detection 1 circuit enabled
	SYSC_LVCMPCR_LVD1E_1 = 0x1
	// Position of LVD2E field.
	SYSC_LVCMPCR_LVD2E_Pos = 0x6
	// Bit mask of LVD2E field.
	SYSC_LVCMPCR_LVD2E_Msk = 0x40
	// Bit LVD2E.
	SYSC_LVCMPCR_LVD2E = 0x40
	// Voltage detection 2 circuit disabled
	SYSC_LVCMPCR_LVD2E_0 = 0x0
	// Voltage detection 2 circuit enabled
	SYSC_LVCMPCR_LVD2E_1 = 0x1

	// LVDLVLR: Voltage Detection Level Select Register
	// Position of LVD1LVL field.
	SYSC_LVDLVLR_LVD1LVL_Pos = 0x0
	// Bit mask of LVD1LVL field.
	SYSC_LVDLVLR_LVD1LVL_Msk = 0x1f
	// Vdet1_0
	SYSC_LVDLVLR_LVD1LVL_0x00 = 0x0
	// Vdet1_1
	SYSC_LVDLVLR_LVD1LVL_0x01 = 0x1
	// Vdet1_2
	SYSC_LVDLVLR_LVD1LVL_0x02 = 0x2
	// Vdet1_3
	SYSC_LVDLVLR_LVD1LVL_0x03 = 0x3
	// Vdet1_4
	SYSC_LVDLVLR_LVD1LVL_0x04 = 0x4
	// Vdet1_5
	SYSC_LVDLVLR_LVD1LVL_0x05 = 0x5
	// Vdet1_6
	SYSC_LVDLVLR_LVD1LVL_0x06 = 0x6
	// Vdet1_7
	SYSC_LVDLVLR_LVD1LVL_0x07 = 0x7
	// Vdet1_8
	SYSC_LVDLVLR_LVD1LVL_0x08 = 0x8
	// Vdet1_9
	SYSC_LVDLVLR_LVD1LVL_0x09 = 0x9
	// Vdet1_A
	SYSC_LVDLVLR_LVD1LVL_0x0A = 0xa
	// Vdet1_B
	SYSC_LVDLVLR_LVD1LVL_0x0B = 0xb
	// Vdet1_C
	SYSC_LVDLVLR_LVD1LVL_0x0C = 0xc
	// Vdet1_D
	SYSC_LVDLVLR_LVD1LVL_0x0D = 0xd
	// Vdet1_E
	SYSC_LVDLVLR_LVD1LVL_0x0E = 0xe
	// Vdet1_F
	SYSC_LVDLVLR_LVD1LVL_0x0F = 0xf
	// Position of LVD2LVL field.
	SYSC_LVDLVLR_LVD2LVL_Pos = 0x5
	// Bit mask of LVD2LVL field.
	SYSC_LVDLVLR_LVD2LVL_Msk = 0xe0
	// Vdet2_0
	SYSC_LVDLVLR_LVD2LVL_000 = 0x0
	// Vdet2_1
	SYSC_LVDLVLR_LVD2LVL_001 = 0x1
	// Vdet2_2
	SYSC_LVDLVLR_LVD2LVL_010 = 0x2
	// Vdet2_3
	SYSC_LVDLVLR_LVD2LVL_011 = 0x3

	// LVD1CR0: Voltage Monitor 1 Circuit Control Register 0
	// Position of RIE field.
	SYSC_LVD1CR0_RIE_Pos = 0x0
	// Bit mask of RIE field.
	SYSC_LVD1CR0_RIE_Msk = 0x1
	// Bit RIE.
	SYSC_LVD1CR0_RIE = 0x1
	// Disable
	SYSC_LVD1CR0_RIE_0 = 0x0
	// Enable
	SYSC_LVD1CR0_RIE_1 = 0x1
	// Position of CMPE field.
	SYSC_LVD1CR0_CMPE_Pos = 0x2
	// Bit mask of CMPE field.
	SYSC_LVD1CR0_CMPE_Msk = 0x4
	// Bit CMPE.
	SYSC_LVD1CR0_CMPE = 0x4
	// Disable voltage monitor 1 circuit comparison result output
	SYSC_LVD1CR0_CMPE_0 = 0x0
	// Enable voltage monitor 1 circuit comparison result output
	SYSC_LVD1CR0_CMPE_1 = 0x1
	// Position of RI field.
	SYSC_LVD1CR0_RI_Pos = 0x6
	// Bit mask of RI field.
	SYSC_LVD1CR0_RI_Msk = 0x40
	// Bit RI.
	SYSC_LVD1CR0_RI = 0x40
	// Generate voltage monitor 1 interrupt on Vdet1 crossing
	SYSC_LVD1CR0_RI_0 = 0x0
	// Enable voltage monitor 1 reset when the voltage falls to and below Vdet1
	SYSC_LVD1CR0_RI_1 = 0x1
	// Position of RN field.
	SYSC_LVD1CR0_RN_Pos = 0x7
	// Bit mask of RN field.
	SYSC_LVD1CR0_RN_Msk = 0x80
	// Bit RN.
	SYSC_LVD1CR0_RN = 0x80
	// Negate after a stabilization time (tLVD1) when VCC > Vdet1 is detected
	SYSC_LVD1CR0_RN_0 = 0x0
	// Negate after a stabilization time (tLVD1) on assertion of the LVD1 reset
	SYSC_LVD1CR0_RN_1 = 0x1

	// LVD2CR0: Voltage Monitor 2 Circuit Control Register 0
	// Position of RIE field.
	SYSC_LVD2CR0_RIE_Pos = 0x0
	// Bit mask of RIE field.
	SYSC_LVD2CR0_RIE_Msk = 0x1
	// Bit RIE.
	SYSC_LVD2CR0_RIE = 0x1
	// Disable
	SYSC_LVD2CR0_RIE_0 = 0x0
	// Enable
	SYSC_LVD2CR0_RIE_1 = 0x1
	// Position of CMPE field.
	SYSC_LVD2CR0_CMPE_Pos = 0x2
	// Bit mask of CMPE field.
	SYSC_LVD2CR0_CMPE_Msk = 0x4
	// Bit CMPE.
	SYSC_LVD2CR0_CMPE = 0x4
	// Disable voltage monitor 2 circuit comparison result output
	SYSC_LVD2CR0_CMPE_0 = 0x0
	// Enable voltage monitor 2 circuit comparison result output
	SYSC_LVD2CR0_CMPE_1 = 0x1
	// Position of RI field.
	SYSC_LVD2CR0_RI_Pos = 0x6
	// Bit mask of RI field.
	SYSC_LVD2CR0_RI_Msk = 0x40
	// Bit RI.
	SYSC_LVD2CR0_RI = 0x40
	// Generate voltage monitor 2 interrupt on Vdet2 crossing
	SYSC_LVD2CR0_RI_0 = 0x0
	// Enable voltage monitor 2 reset when the voltage falls to and below Vdet2
	SYSC_LVD2CR0_RI_1 = 0x1
	// Position of RN field.
	SYSC_LVD2CR0_RN_Pos = 0x7
	// Bit mask of RN field.
	SYSC_LVD2CR0_RN_Msk = 0x80
	// Bit RN.
	SYSC_LVD2CR0_RN = 0x80
	// Negate after a stabilization time (tLVD2) when VCC > Vdet2 is detected
	SYSC_LVD2CR0_RN_0 = 0x0
	// Negate after a stabilization time (tLVD2) on assertion of the LVD2 reset
	SYSC_LVD2CR0_RN_1 = 0x1

	// LOCOCR: Low-Speed On-Chip Oscillator Control Register
	// Position of LCSTP field.
	SYSC_LOCOCR_LCSTP_Pos = 0x0
	// Bit mask of LCSTP field.
	SYSC_LOCOCR_LCSTP_Msk = 0x1
	// Bit LCSTP.
	SYSC_LOCOCR_LCSTP = 0x1
	// Operate the LOCO clock
	SYSC_LOCOCR_LCSTP_0 = 0x0
	// Stop the LOCO clock
	SYSC_LOCOCR_LCSTP_1 = 0x1

	// LOCOUTCR: LOCO User Trimming Control Register
	// Position of LOCOUTRM field.
	SYSC_LOCOUTCR_LOCOUTRM_Pos = 0x0
	// Bit mask of LOCOUTRM field.
	SYSC_LOCOUTCR_LOCOUTRM_Msk = 0xff
)

// Constants for PORT0: Port 0 Control Registers
const (
	// PCNTR1: Port Control Register 1
	// Position of PDR00 field.
	PORT0_PCNTR1_PDR00_Pos = 0x0
	// Bit mask of PDR00 field.
	PORT0_PCNTR1_PDR00_Msk = 0x1
	// Bit PDR00.
	PORT0_PCNTR1_PDR00 = 0x1
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR00_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR00_1 = 0x1
	// Position of PDR01 field.
	PORT0_PCNTR1_PDR01_Pos = 0x1
	// Bit mask of PDR01 field.
	PORT0_PCNTR1_PDR01_Msk = 0x2
	// Bit PDR01.
	PORT0_PCNTR1_PDR01 = 0x2
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR01_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR01_1 = 0x1
	// Position of PDR02 field.
	PORT0_PCNTR1_PDR02_Pos = 0x2
	// Bit mask of PDR02 field.
	PORT0_PCNTR1_PDR02_Msk = 0x4
	// Bit PDR02.
	PORT0_PCNTR1_PDR02 = 0x4
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR02_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR02_1 = 0x1
	// Position of PDR03 field.
	PORT0_PCNTR1_PDR03_Pos = 0x3
	// Bit mask of PDR03 field.
	PORT0_PCNTR1_PDR03_Msk = 0x8
	// Bit PDR03.
	PORT0_PCNTR1_PDR03 = 0x8
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR03_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR03_1 = 0x1
	// Position of PDR04 field.
	PORT0_PCNTR1_PDR04_Pos = 0x4
	// Bit mask of PDR04 field.
	PORT0_PCNTR1_PDR04_Msk = 0x10
	// Bit PDR04.
	PORT0_PCNTR1_PDR04 = 0x10
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR04_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR04_1 = 0x1
	// Position of PDR05 field.
	PORT0_PCNTR1_PDR05_Pos = 0x5
	// Bit mask of PDR05 field.
	PORT0_PCNTR1_PDR05_Msk = 0x20
	// Bit PDR05.
	PORT0_PCNTR1_PDR05 = 0x20
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR05_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR05_1 = 0x1
	// Position of PDR06 field.
	PORT0_PCNTR1_PDR06_Pos = 0x6
	// Bit mask of PDR06 field.
	PORT0_PCNTR1_PDR06_Msk = 0x40
	// Bit PDR06.
	PORT0_PCNTR1_PDR06 = 0x40
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR06_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR06_1 = 0x1
	// Position of PDR07 field.
	PORT0_PCNTR1_PDR07_Pos = 0x7
	// Bit mask of PDR07 field.
	PORT0_PCNTR1_PDR07_Msk = 0x80
	// Bit PDR07.
	PORT0_PCNTR1_PDR07 = 0x80
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR07_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR07_1 = 0x1
	// Position of PDR08 field.
	PORT0_PCNTR1_PDR08_Pos = 0x8
	// Bit mask of PDR08 field.
	PORT0_PCNTR1_PDR08_Msk = 0x100
	// Bit PDR08.
	PORT0_PCNTR1_PDR08 = 0x100
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR08_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR08_1 = 0x1
	// Position of PDR09 field.
	PORT0_PCNTR1_PDR09_Pos = 0x9
	// Bit mask of PDR09 field.
	PORT0_PCNTR1_PDR09_Msk = 0x200
	// Bit PDR09.
	PORT0_PCNTR1_PDR09 = 0x200
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR09_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR09_1 = 0x1
	// Position of PDR10 field.
	PORT0_PCNTR1_PDR10_Pos = 0xa
	// Bit mask of PDR10 field.
	PORT0_PCNTR1_PDR10_Msk = 0x400
	// Bit PDR10.
	PORT0_PCNTR1_PDR10 = 0x400
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR10_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR10_1 = 0x1
	// Position of PDR11 field.
	PORT0_PCNTR1_PDR11_Pos = 0xb
	// Bit mask of PDR11 field.
	PORT0_PCNTR1_PDR11_Msk = 0x800
	// Bit PDR11.
	PORT0_PCNTR1_PDR11 = 0x800
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR11_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR11_1 = 0x1
	// Position of PDR12 field.
	PORT0_PCNTR1_PDR12_Pos = 0xc
	// Bit mask of PDR12 field.
	PORT0_PCNTR1_PDR12_Msk = 0x1000
	// Bit PDR12.
	PORT0_PCNTR1_PDR12 = 0x1000
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR12_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR12_1 = 0x1
	// Position of PDR13 field.
	PORT0_PCNTR1_PDR13_Pos = 0xd
	// Bit mask of PDR13 field.
	PORT0_PCNTR1_PDR13_Msk = 0x2000
	// Bit PDR13.
	PORT0_PCNTR1_PDR13 = 0x2000
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR13_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR13_1 = 0x1
	// Position of PDR14 field.
	PORT0_PCNTR1_PDR14_Pos = 0xe
	// Bit mask of PDR14 field.
	PORT0_PCNTR1_PDR14_Msk = 0x4000
	// Bit PDR14.
	PORT0_PCNTR1_PDR14 = 0x4000
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR14_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR14_1 = 0x1
	// Position of PDR15 field.
	PORT0_PCNTR1_PDR15_Pos = 0xf
	// Bit mask of PDR15 field.
	PORT0_PCNTR1_PDR15_Msk = 0x8000
	// Bit PDR15.
	PORT0_PCNTR1_PDR15 = 0x8000
	// Input (functions as an input pin)
	PORT0_PCNTR1_PDR15_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PCNTR1_PDR15_1 = 0x1
	// Position of PODR00 field.
	PORT0_PCNTR1_PODR00_Pos = 0x10
	// Bit mask of PODR00 field.
	PORT0_PCNTR1_PODR00_Msk = 0x10000
	// Bit PODR00.
	PORT0_PCNTR1_PODR00 = 0x10000
	// Low output
	PORT0_PCNTR1_PODR00_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR00_1 = 0x1
	// Position of PODR01 field.
	PORT0_PCNTR1_PODR01_Pos = 0x11
	// Bit mask of PODR01 field.
	PORT0_PCNTR1_PODR01_Msk = 0x20000
	// Bit PODR01.
	PORT0_PCNTR1_PODR01 = 0x20000
	// Low output
	PORT0_PCNTR1_PODR01_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR01_1 = 0x1
	// Position of PODR02 field.
	PORT0_PCNTR1_PODR02_Pos = 0x12
	// Bit mask of PODR02 field.
	PORT0_PCNTR1_PODR02_Msk = 0x40000
	// Bit PODR02.
	PORT0_PCNTR1_PODR02 = 0x40000
	// Low output
	PORT0_PCNTR1_PODR02_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR02_1 = 0x1
	// Position of PODR03 field.
	PORT0_PCNTR1_PODR03_Pos = 0x13
	// Bit mask of PODR03 field.
	PORT0_PCNTR1_PODR03_Msk = 0x80000
	// Bit PODR03.
	PORT0_PCNTR1_PODR03 = 0x80000
	// Low output
	PORT0_PCNTR1_PODR03_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR03_1 = 0x1
	// Position of PODR04 field.
	PORT0_PCNTR1_PODR04_Pos = 0x14
	// Bit mask of PODR04 field.
	PORT0_PCNTR1_PODR04_Msk = 0x100000
	// Bit PODR04.
	PORT0_PCNTR1_PODR04 = 0x100000
	// Low output
	PORT0_PCNTR1_PODR04_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR04_1 = 0x1
	// Position of PODR05 field.
	PORT0_PCNTR1_PODR05_Pos = 0x15
	// Bit mask of PODR05 field.
	PORT0_PCNTR1_PODR05_Msk = 0x200000
	// Bit PODR05.
	PORT0_PCNTR1_PODR05 = 0x200000
	// Low output
	PORT0_PCNTR1_PODR05_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR05_1 = 0x1
	// Position of PODR06 field.
	PORT0_PCNTR1_PODR06_Pos = 0x16
	// Bit mask of PODR06 field.
	PORT0_PCNTR1_PODR06_Msk = 0x400000
	// Bit PODR06.
	PORT0_PCNTR1_PODR06 = 0x400000
	// Low output
	PORT0_PCNTR1_PODR06_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR06_1 = 0x1
	// Position of PODR07 field.
	PORT0_PCNTR1_PODR07_Pos = 0x17
	// Bit mask of PODR07 field.
	PORT0_PCNTR1_PODR07_Msk = 0x800000
	// Bit PODR07.
	PORT0_PCNTR1_PODR07 = 0x800000
	// Low output
	PORT0_PCNTR1_PODR07_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR07_1 = 0x1
	// Position of PODR08 field.
	PORT0_PCNTR1_PODR08_Pos = 0x18
	// Bit mask of PODR08 field.
	PORT0_PCNTR1_PODR08_Msk = 0x1000000
	// Bit PODR08.
	PORT0_PCNTR1_PODR08 = 0x1000000
	// Low output
	PORT0_PCNTR1_PODR08_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR08_1 = 0x1
	// Position of PODR09 field.
	PORT0_PCNTR1_PODR09_Pos = 0x19
	// Bit mask of PODR09 field.
	PORT0_PCNTR1_PODR09_Msk = 0x2000000
	// Bit PODR09.
	PORT0_PCNTR1_PODR09 = 0x2000000
	// Low output
	PORT0_PCNTR1_PODR09_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR09_1 = 0x1
	// Position of PODR10 field.
	PORT0_PCNTR1_PODR10_Pos = 0x1a
	// Bit mask of PODR10 field.
	PORT0_PCNTR1_PODR10_Msk = 0x4000000
	// Bit PODR10.
	PORT0_PCNTR1_PODR10 = 0x4000000
	// Low output
	PORT0_PCNTR1_PODR10_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR10_1 = 0x1
	// Position of PODR11 field.
	PORT0_PCNTR1_PODR11_Pos = 0x1b
	// Bit mask of PODR11 field.
	PORT0_PCNTR1_PODR11_Msk = 0x8000000
	// Bit PODR11.
	PORT0_PCNTR1_PODR11 = 0x8000000
	// Low output
	PORT0_PCNTR1_PODR11_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR11_1 = 0x1
	// Position of PODR12 field.
	PORT0_PCNTR1_PODR12_Pos = 0x1c
	// Bit mask of PODR12 field.
	PORT0_PCNTR1_PODR12_Msk = 0x10000000
	// Bit PODR12.
	PORT0_PCNTR1_PODR12 = 0x10000000
	// Low output
	PORT0_PCNTR1_PODR12_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR12_1 = 0x1
	// Position of PODR13 field.
	PORT0_PCNTR1_PODR13_Pos = 0x1d
	// Bit mask of PODR13 field.
	PORT0_PCNTR1_PODR13_Msk = 0x20000000
	// Bit PODR13.
	PORT0_PCNTR1_PODR13 = 0x20000000
	// Low output
	PORT0_PCNTR1_PODR13_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR13_1 = 0x1
	// Position of PODR14 field.
	PORT0_PCNTR1_PODR14_Pos = 0x1e
	// Bit mask of PODR14 field.
	PORT0_PCNTR1_PODR14_Msk = 0x40000000
	// Bit PODR14.
	PORT0_PCNTR1_PODR14 = 0x40000000
	// Low output
	PORT0_PCNTR1_PODR14_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR14_1 = 0x1
	// Position of PODR15 field.
	PORT0_PCNTR1_PODR15_Pos = 0x1f
	// Bit mask of PODR15 field.
	PORT0_PCNTR1_PODR15_Msk = 0x80000000
	// Bit PODR15.
	PORT0_PCNTR1_PODR15 = 0x80000000
	// Low output
	PORT0_PCNTR1_PODR15_0 = 0x0
	// High output
	PORT0_PCNTR1_PODR15_1 = 0x1

	// PODR: Port Control Register 1
	// Position of PODR00 field.
	PORT0_PODR_PODR00_Pos = 0x0
	// Bit mask of PODR00 field.
	PORT0_PODR_PODR00_Msk = 0x1
	// Bit PODR00.
	PORT0_PODR_PODR00 = 0x1
	// Low output
	PORT0_PODR_PODR00_0 = 0x0
	// High output
	PORT0_PODR_PODR00_1 = 0x1
	// Position of PODR01 field.
	PORT0_PODR_PODR01_Pos = 0x1
	// Bit mask of PODR01 field.
	PORT0_PODR_PODR01_Msk = 0x2
	// Bit PODR01.
	PORT0_PODR_PODR01 = 0x2
	// Low output
	PORT0_PODR_PODR01_0 = 0x0
	// High output
	PORT0_PODR_PODR01_1 = 0x1
	// Position of PODR02 field.
	PORT0_PODR_PODR02_Pos = 0x2
	// Bit mask of PODR02 field.
	PORT0_PODR_PODR02_Msk = 0x4
	// Bit PODR02.
	PORT0_PODR_PODR02 = 0x4
	// Low output
	PORT0_PODR_PODR02_0 = 0x0
	// High output
	PORT0_PODR_PODR02_1 = 0x1
	// Position of PODR03 field.
	PORT0_PODR_PODR03_Pos = 0x3
	// Bit mask of PODR03 field.
	PORT0_PODR_PODR03_Msk = 0x8
	// Bit PODR03.
	PORT0_PODR_PODR03 = 0x8
	// Low output
	PORT0_PODR_PODR03_0 = 0x0
	// High output
	PORT0_PODR_PODR03_1 = 0x1
	// Position of PODR04 field.
	PORT0_PODR_PODR04_Pos = 0x4
	// Bit mask of PODR04 field.
	PORT0_PODR_PODR04_Msk = 0x10
	// Bit PODR04.
	PORT0_PODR_PODR04 = 0x10
	// Low output
	PORT0_PODR_PODR04_0 = 0x0
	// High output
	PORT0_PODR_PODR04_1 = 0x1
	// Position of PODR05 field.
	PORT0_PODR_PODR05_Pos = 0x5
	// Bit mask of PODR05 field.
	PORT0_PODR_PODR05_Msk = 0x20
	// Bit PODR05.
	PORT0_PODR_PODR05 = 0x20
	// Low output
	PORT0_PODR_PODR05_0 = 0x0
	// High output
	PORT0_PODR_PODR05_1 = 0x1
	// Position of PODR06 field.
	PORT0_PODR_PODR06_Pos = 0x6
	// Bit mask of PODR06 field.
	PORT0_PODR_PODR06_Msk = 0x40
	// Bit PODR06.
	PORT0_PODR_PODR06 = 0x40
	// Low output
	PORT0_PODR_PODR06_0 = 0x0
	// High output
	PORT0_PODR_PODR06_1 = 0x1
	// Position of PODR07 field.
	PORT0_PODR_PODR07_Pos = 0x7
	// Bit mask of PODR07 field.
	PORT0_PODR_PODR07_Msk = 0x80
	// Bit PODR07.
	PORT0_PODR_PODR07 = 0x80
	// Low output
	PORT0_PODR_PODR07_0 = 0x0
	// High output
	PORT0_PODR_PODR07_1 = 0x1
	// Position of PODR08 field.
	PORT0_PODR_PODR08_Pos = 0x8
	// Bit mask of PODR08 field.
	PORT0_PODR_PODR08_Msk = 0x100
	// Bit PODR08.
	PORT0_PODR_PODR08 = 0x100
	// Low output
	PORT0_PODR_PODR08_0 = 0x0
	// High output
	PORT0_PODR_PODR08_1 = 0x1
	// Position of PODR09 field.
	PORT0_PODR_PODR09_Pos = 0x9
	// Bit mask of PODR09 field.
	PORT0_PODR_PODR09_Msk = 0x200
	// Bit PODR09.
	PORT0_PODR_PODR09 = 0x200
	// Low output
	PORT0_PODR_PODR09_0 = 0x0
	// High output
	PORT0_PODR_PODR09_1 = 0x1
	// Position of PODR10 field.
	PORT0_PODR_PODR10_Pos = 0xa
	// Bit mask of PODR10 field.
	PORT0_PODR_PODR10_Msk = 0x400
	// Bit PODR10.
	PORT0_PODR_PODR10 = 0x400
	// Low output
	PORT0_PODR_PODR10_0 = 0x0
	// High output
	PORT0_PODR_PODR10_1 = 0x1
	// Position of PODR11 field.
	PORT0_PODR_PODR11_Pos = 0xb
	// Bit mask of PODR11 field.
	PORT0_PODR_PODR11_Msk = 0x800
	// Bit PODR11.
	PORT0_PODR_PODR11 = 0x800
	// Low output
	PORT0_PODR_PODR11_0 = 0x0
	// High output
	PORT0_PODR_PODR11_1 = 0x1
	// Position of PODR12 field.
	PORT0_PODR_PODR12_Pos = 0xc
	// Bit mask of PODR12 field.
	PORT0_PODR_PODR12_Msk = 0x1000
	// Bit PODR12.
	PORT0_PODR_PODR12 = 0x1000
	// Low output
	PORT0_PODR_PODR12_0 = 0x0
	// High output
	PORT0_PODR_PODR12_1 = 0x1
	// Position of PODR13 field.
	PORT0_PODR_PODR13_Pos = 0xd
	// Bit mask of PODR13 field.
	PORT0_PODR_PODR13_Msk = 0x2000
	// Bit PODR13.
	PORT0_PODR_PODR13 = 0x2000
	// Low output
	PORT0_PODR_PODR13_0 = 0x0
	// High output
	PORT0_PODR_PODR13_1 = 0x1
	// Position of PODR14 field.
	PORT0_PODR_PODR14_Pos = 0xe
	// Bit mask of PODR14 field.
	PORT0_PODR_PODR14_Msk = 0x4000
	// Bit PODR14.
	PORT0_PODR_PODR14 = 0x4000
	// Low output
	PORT0_PODR_PODR14_0 = 0x0
	// High output
	PORT0_PODR_PODR14_1 = 0x1
	// Position of PODR15 field.
	PORT0_PODR_PODR15_Pos = 0xf
	// Bit mask of PODR15 field.
	PORT0_PODR_PODR15_Msk = 0x8000
	// Bit PODR15.
	PORT0_PODR_PODR15 = 0x8000
	// Low output
	PORT0_PODR_PODR15_0 = 0x0
	// High output
	PORT0_PODR_PODR15_1 = 0x1

	// PDR: Port Control Register 1
	// Position of PDR00 field.
	PORT0_PDR_PDR00_Pos = 0x0
	// Bit mask of PDR00 field.
	PORT0_PDR_PDR00_Msk = 0x1
	// Bit PDR00.
	PORT0_PDR_PDR00 = 0x1
	// Input (functions as an input pin)
	PORT0_PDR_PDR00_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR00_1 = 0x1
	// Position of PDR01 field.
	PORT0_PDR_PDR01_Pos = 0x1
	// Bit mask of PDR01 field.
	PORT0_PDR_PDR01_Msk = 0x2
	// Bit PDR01.
	PORT0_PDR_PDR01 = 0x2
	// Input (functions as an input pin)
	PORT0_PDR_PDR01_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR01_1 = 0x1
	// Position of PDR02 field.
	PORT0_PDR_PDR02_Pos = 0x2
	// Bit mask of PDR02 field.
	PORT0_PDR_PDR02_Msk = 0x4
	// Bit PDR02.
	PORT0_PDR_PDR02 = 0x4
	// Input (functions as an input pin)
	PORT0_PDR_PDR02_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR02_1 = 0x1
	// Position of PDR03 field.
	PORT0_PDR_PDR03_Pos = 0x3
	// Bit mask of PDR03 field.
	PORT0_PDR_PDR03_Msk = 0x8
	// Bit PDR03.
	PORT0_PDR_PDR03 = 0x8
	// Input (functions as an input pin)
	PORT0_PDR_PDR03_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR03_1 = 0x1
	// Position of PDR04 field.
	PORT0_PDR_PDR04_Pos = 0x4
	// Bit mask of PDR04 field.
	PORT0_PDR_PDR04_Msk = 0x10
	// Bit PDR04.
	PORT0_PDR_PDR04 = 0x10
	// Input (functions as an input pin)
	PORT0_PDR_PDR04_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR04_1 = 0x1
	// Position of PDR05 field.
	PORT0_PDR_PDR05_Pos = 0x5
	// Bit mask of PDR05 field.
	PORT0_PDR_PDR05_Msk = 0x20
	// Bit PDR05.
	PORT0_PDR_PDR05 = 0x20
	// Input (functions as an input pin)
	PORT0_PDR_PDR05_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR05_1 = 0x1
	// Position of PDR06 field.
	PORT0_PDR_PDR06_Pos = 0x6
	// Bit mask of PDR06 field.
	PORT0_PDR_PDR06_Msk = 0x40
	// Bit PDR06.
	PORT0_PDR_PDR06 = 0x40
	// Input (functions as an input pin)
	PORT0_PDR_PDR06_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR06_1 = 0x1
	// Position of PDR07 field.
	PORT0_PDR_PDR07_Pos = 0x7
	// Bit mask of PDR07 field.
	PORT0_PDR_PDR07_Msk = 0x80
	// Bit PDR07.
	PORT0_PDR_PDR07 = 0x80
	// Input (functions as an input pin)
	PORT0_PDR_PDR07_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR07_1 = 0x1
	// Position of PDR08 field.
	PORT0_PDR_PDR08_Pos = 0x8
	// Bit mask of PDR08 field.
	PORT0_PDR_PDR08_Msk = 0x100
	// Bit PDR08.
	PORT0_PDR_PDR08 = 0x100
	// Input (functions as an input pin)
	PORT0_PDR_PDR08_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR08_1 = 0x1
	// Position of PDR09 field.
	PORT0_PDR_PDR09_Pos = 0x9
	// Bit mask of PDR09 field.
	PORT0_PDR_PDR09_Msk = 0x200
	// Bit PDR09.
	PORT0_PDR_PDR09 = 0x200
	// Input (functions as an input pin)
	PORT0_PDR_PDR09_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR09_1 = 0x1
	// Position of PDR10 field.
	PORT0_PDR_PDR10_Pos = 0xa
	// Bit mask of PDR10 field.
	PORT0_PDR_PDR10_Msk = 0x400
	// Bit PDR10.
	PORT0_PDR_PDR10 = 0x400
	// Input (functions as an input pin)
	PORT0_PDR_PDR10_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR10_1 = 0x1
	// Position of PDR11 field.
	PORT0_PDR_PDR11_Pos = 0xb
	// Bit mask of PDR11 field.
	PORT0_PDR_PDR11_Msk = 0x800
	// Bit PDR11.
	PORT0_PDR_PDR11 = 0x800
	// Input (functions as an input pin)
	PORT0_PDR_PDR11_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR11_1 = 0x1
	// Position of PDR12 field.
	PORT0_PDR_PDR12_Pos = 0xc
	// Bit mask of PDR12 field.
	PORT0_PDR_PDR12_Msk = 0x1000
	// Bit PDR12.
	PORT0_PDR_PDR12 = 0x1000
	// Input (functions as an input pin)
	PORT0_PDR_PDR12_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR12_1 = 0x1
	// Position of PDR13 field.
	PORT0_PDR_PDR13_Pos = 0xd
	// Bit mask of PDR13 field.
	PORT0_PDR_PDR13_Msk = 0x2000
	// Bit PDR13.
	PORT0_PDR_PDR13 = 0x2000
	// Input (functions as an input pin)
	PORT0_PDR_PDR13_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR13_1 = 0x1
	// Position of PDR14 field.
	PORT0_PDR_PDR14_Pos = 0xe
	// Bit mask of PDR14 field.
	PORT0_PDR_PDR14_Msk = 0x4000
	// Bit PDR14.
	PORT0_PDR_PDR14 = 0x4000
	// Input (functions as an input pin)
	PORT0_PDR_PDR14_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR14_1 = 0x1
	// Position of PDR15 field.
	PORT0_PDR_PDR15_Pos = 0xf
	// Bit mask of PDR15 field.
	PORT0_PDR_PDR15_Msk = 0x8000
	// Bit PDR15.
	PORT0_PDR_PDR15 = 0x8000
	// Input (functions as an input pin)
	PORT0_PDR_PDR15_0 = 0x0
	// Output (functions as an output pin)
	PORT0_PDR_PDR15_1 = 0x1

	// PCNTR2: Port Control Register 2
	// Position of PIDR00 field.
	PORT0_PCNTR2_PIDR00_Pos = 0x0
	// Bit mask of PIDR00 field.
	PORT0_PCNTR2_PIDR00_Msk = 0x1
	// Bit PIDR00.
	PORT0_PCNTR2_PIDR00 = 0x1
	// Low level
	PORT0_PCNTR2_PIDR00_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR00_1 = 0x1
	// Position of PIDR01 field.
	PORT0_PCNTR2_PIDR01_Pos = 0x1
	// Bit mask of PIDR01 field.
	PORT0_PCNTR2_PIDR01_Msk = 0x2
	// Bit PIDR01.
	PORT0_PCNTR2_PIDR01 = 0x2
	// Low level
	PORT0_PCNTR2_PIDR01_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR01_1 = 0x1
	// Position of PIDR02 field.
	PORT0_PCNTR2_PIDR02_Pos = 0x2
	// Bit mask of PIDR02 field.
	PORT0_PCNTR2_PIDR02_Msk = 0x4
	// Bit PIDR02.
	PORT0_PCNTR2_PIDR02 = 0x4
	// Low level
	PORT0_PCNTR2_PIDR02_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR02_1 = 0x1
	// Position of PIDR03 field.
	PORT0_PCNTR2_PIDR03_Pos = 0x3
	// Bit mask of PIDR03 field.
	PORT0_PCNTR2_PIDR03_Msk = 0x8
	// Bit PIDR03.
	PORT0_PCNTR2_PIDR03 = 0x8
	// Low level
	PORT0_PCNTR2_PIDR03_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR03_1 = 0x1
	// Position of PIDR04 field.
	PORT0_PCNTR2_PIDR04_Pos = 0x4
	// Bit mask of PIDR04 field.
	PORT0_PCNTR2_PIDR04_Msk = 0x10
	// Bit PIDR04.
	PORT0_PCNTR2_PIDR04 = 0x10
	// Low level
	PORT0_PCNTR2_PIDR04_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR04_1 = 0x1
	// Position of PIDR05 field.
	PORT0_PCNTR2_PIDR05_Pos = 0x5
	// Bit mask of PIDR05 field.
	PORT0_PCNTR2_PIDR05_Msk = 0x20
	// Bit PIDR05.
	PORT0_PCNTR2_PIDR05 = 0x20
	// Low level
	PORT0_PCNTR2_PIDR05_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR05_1 = 0x1
	// Position of PIDR06 field.
	PORT0_PCNTR2_PIDR06_Pos = 0x6
	// Bit mask of PIDR06 field.
	PORT0_PCNTR2_PIDR06_Msk = 0x40
	// Bit PIDR06.
	PORT0_PCNTR2_PIDR06 = 0x40
	// Low level
	PORT0_PCNTR2_PIDR06_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR06_1 = 0x1
	// Position of PIDR07 field.
	PORT0_PCNTR2_PIDR07_Pos = 0x7
	// Bit mask of PIDR07 field.
	PORT0_PCNTR2_PIDR07_Msk = 0x80
	// Bit PIDR07.
	PORT0_PCNTR2_PIDR07 = 0x80
	// Low level
	PORT0_PCNTR2_PIDR07_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR07_1 = 0x1
	// Position of PIDR08 field.
	PORT0_PCNTR2_PIDR08_Pos = 0x8
	// Bit mask of PIDR08 field.
	PORT0_PCNTR2_PIDR08_Msk = 0x100
	// Bit PIDR08.
	PORT0_PCNTR2_PIDR08 = 0x100
	// Low level
	PORT0_PCNTR2_PIDR08_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR08_1 = 0x1
	// Position of PIDR09 field.
	PORT0_PCNTR2_PIDR09_Pos = 0x9
	// Bit mask of PIDR09 field.
	PORT0_PCNTR2_PIDR09_Msk = 0x200
	// Bit PIDR09.
	PORT0_PCNTR2_PIDR09 = 0x200
	// Low level
	PORT0_PCNTR2_PIDR09_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR09_1 = 0x1
	// Position of PIDR10 field.
	PORT0_PCNTR2_PIDR10_Pos = 0xa
	// Bit mask of PIDR10 field.
	PORT0_PCNTR2_PIDR10_Msk = 0x400
	// Bit PIDR10.
	PORT0_PCNTR2_PIDR10 = 0x400
	// Low level
	PORT0_PCNTR2_PIDR10_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR10_1 = 0x1
	// Position of PIDR11 field.
	PORT0_PCNTR2_PIDR11_Pos = 0xb
	// Bit mask of PIDR11 field.
	PORT0_PCNTR2_PIDR11_Msk = 0x800
	// Bit PIDR11.
	PORT0_PCNTR2_PIDR11 = 0x800
	// Low level
	PORT0_PCNTR2_PIDR11_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR11_1 = 0x1
	// Position of PIDR12 field.
	PORT0_PCNTR2_PIDR12_Pos = 0xc
	// Bit mask of PIDR12 field.
	PORT0_PCNTR2_PIDR12_Msk = 0x1000
	// Bit PIDR12.
	PORT0_PCNTR2_PIDR12 = 0x1000
	// Low level
	PORT0_PCNTR2_PIDR12_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR12_1 = 0x1
	// Position of PIDR13 field.
	PORT0_PCNTR2_PIDR13_Pos = 0xd
	// Bit mask of PIDR13 field.
	PORT0_PCNTR2_PIDR13_Msk = 0x2000
	// Bit PIDR13.
	PORT0_PCNTR2_PIDR13 = 0x2000
	// Low level
	PORT0_PCNTR2_PIDR13_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR13_1 = 0x1
	// Position of PIDR14 field.
	PORT0_PCNTR2_PIDR14_Pos = 0xe
	// Bit mask of PIDR14 field.
	PORT0_PCNTR2_PIDR14_Msk = 0x4000
	// Bit PIDR14.
	PORT0_PCNTR2_PIDR14 = 0x4000
	// Low level
	PORT0_PCNTR2_PIDR14_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR14_1 = 0x1
	// Position of PIDR15 field.
	PORT0_PCNTR2_PIDR15_Pos = 0xf
	// Bit mask of PIDR15 field.
	PORT0_PCNTR2_PIDR15_Msk = 0x8000
	// Bit PIDR15.
	PORT0_PCNTR2_PIDR15 = 0x8000
	// Low level
	PORT0_PCNTR2_PIDR15_0 = 0x0
	// High level
	PORT0_PCNTR2_PIDR15_1 = 0x1

	// PIDR: Port Control Register 2
	// Position of PIDR00 field.
	PORT0_PIDR_PIDR00_Pos = 0x0
	// Bit mask of PIDR00 field.
	PORT0_PIDR_PIDR00_Msk = 0x1
	// Bit PIDR00.
	PORT0_PIDR_PIDR00 = 0x1
	// Low level
	PORT0_PIDR_PIDR00_0 = 0x0
	// High level
	PORT0_PIDR_PIDR00_1 = 0x1
	// Position of PIDR01 field.
	PORT0_PIDR_PIDR01_Pos = 0x1
	// Bit mask of PIDR01 field.
	PORT0_PIDR_PIDR01_Msk = 0x2
	// Bit PIDR01.
	PORT0_PIDR_PIDR01 = 0x2
	// Low level
	PORT0_PIDR_PIDR01_0 = 0x0
	// High level
	PORT0_PIDR_PIDR01_1 = 0x1
	// Position of PIDR02 field.
	PORT0_PIDR_PIDR02_Pos = 0x2
	// Bit mask of PIDR02 field.
	PORT0_PIDR_PIDR02_Msk = 0x4
	// Bit PIDR02.
	PORT0_PIDR_PIDR02 = 0x4
	// Low level
	PORT0_PIDR_PIDR02_0 = 0x0
	// High level
	PORT0_PIDR_PIDR02_1 = 0x1
	// Position of PIDR03 field.
	PORT0_PIDR_PIDR03_Pos = 0x3
	// Bit mask of PIDR03 field.
	PORT0_PIDR_PIDR03_Msk = 0x8
	// Bit PIDR03.
	PORT0_PIDR_PIDR03 = 0x8
	// Low level
	PORT0_PIDR_PIDR03_0 = 0x0
	// High level
	PORT0_PIDR_PIDR03_1 = 0x1
	// Position of PIDR04 field.
	PORT0_PIDR_PIDR04_Pos = 0x4
	// Bit mask of PIDR04 field.
	PORT0_PIDR_PIDR04_Msk = 0x10
	// Bit PIDR04.
	PORT0_PIDR_PIDR04 = 0x10
	// Low level
	PORT0_PIDR_PIDR04_0 = 0x0
	// High level
	PORT0_PIDR_PIDR04_1 = 0x1
	// Position of PIDR05 field.
	PORT0_PIDR_PIDR05_Pos = 0x5
	// Bit mask of PIDR05 field.
	PORT0_PIDR_PIDR05_Msk = 0x20
	// Bit PIDR05.
	PORT0_PIDR_PIDR05 = 0x20
	// Low level
	PORT0_PIDR_PIDR05_0 = 0x0
	// High level
	PORT0_PIDR_PIDR05_1 = 0x1
	// Position of PIDR06 field.
	PORT0_PIDR_PIDR06_Pos = 0x6
	// Bit mask of PIDR06 field.
	PORT0_PIDR_PIDR06_Msk = 0x40
	// Bit PIDR06.
	PORT0_PIDR_PIDR06 = 0x40
	// Low level
	PORT0_PIDR_PIDR06_0 = 0x0
	// High level
	PORT0_PIDR_PIDR06_1 = 0x1
	// Position of PIDR07 field.
	PORT0_PIDR_PIDR07_Pos = 0x7
	// Bit mask of PIDR07 field.
	PORT0_PIDR_PIDR07_Msk = 0x80
	// Bit PIDR07.
	PORT0_PIDR_PIDR07 = 0x80
	// Low level
	PORT0_PIDR_PIDR07_0 = 0x0
	// High level
	PORT0_PIDR_PIDR07_1 = 0x1
	// Position of PIDR08 field.
	PORT0_PIDR_PIDR08_Pos = 0x8
	// Bit mask of PIDR08 field.
	PORT0_PIDR_PIDR08_Msk = 0x100
	// Bit PIDR08.
	PORT0_PIDR_PIDR08 = 0x100
	// Low level
	PORT0_PIDR_PIDR08_0 = 0x0
	// High level
	PORT0_PIDR_PIDR08_1 = 0x1
	// Position of PIDR09 field.
	PORT0_PIDR_PIDR09_Pos = 0x9
	// Bit mask of PIDR09 field.
	PORT0_PIDR_PIDR09_Msk = 0x200
	// Bit PIDR09.
	PORT0_PIDR_PIDR09 = 0x200
	// Low level
	PORT0_PIDR_PIDR09_0 = 0x0
	// High level
	PORT0_PIDR_PIDR09_1 = 0x1
	// Position of PIDR10 field.
	PORT0_PIDR_PIDR10_Pos = 0xa
	// Bit mask of PIDR10 field.
	PORT0_PIDR_PIDR10_Msk = 0x400
	// Bit PIDR10.
	PORT0_PIDR_PIDR10 = 0x400
	// Low level
	PORT0_PIDR_PIDR10_0 = 0x0
	// High level
	PORT0_PIDR_PIDR10_1 = 0x1
	// Position of PIDR11 field.
	PORT0_PIDR_PIDR11_Pos = 0xb
	// Bit mask of PIDR11 field.
	PORT0_PIDR_PIDR11_Msk = 0x800
	// Bit PIDR11.
	PORT0_PIDR_PIDR11 = 0x800
	// Low level
	PORT0_PIDR_PIDR11_0 = 0x0
	// High level
	PORT0_PIDR_PIDR11_1 = 0x1
	// Position of PIDR12 field.
	PORT0_PIDR_PIDR12_Pos = 0xc
	// Bit mask of PIDR12 field.
	PORT0_PIDR_PIDR12_Msk = 0x1000
	// Bit PIDR12.
	PORT0_PIDR_PIDR12 = 0x1000
	// Low level
	PORT0_PIDR_PIDR12_0 = 0x0
	// High level
	PORT0_PIDR_PIDR12_1 = 0x1
	// Position of PIDR13 field.
	PORT0_PIDR_PIDR13_Pos = 0xd
	// Bit mask of PIDR13 field.
	PORT0_PIDR_PIDR13_Msk = 0x2000
	// Bit PIDR13.
	PORT0_PIDR_PIDR13 = 0x2000
	// Low level
	PORT0_PIDR_PIDR13_0 = 0x0
	// High level
	PORT0_PIDR_PIDR13_1 = 0x1
	// Position of PIDR14 field.
	PORT0_PIDR_PIDR14_Pos = 0xe
	// Bit mask of PIDR14 field.
	PORT0_PIDR_PIDR14_Msk = 0x4000
	// Bit PIDR14.
	PORT0_PIDR_PIDR14 = 0x4000
	// Low level
	PORT0_PIDR_PIDR14_0 = 0x0
	// High level
	PORT0_PIDR_PIDR14_1 = 0x1
	// Position of PIDR15 field.
	PORT0_PIDR_PIDR15_Pos = 0xf
	// Bit mask of PIDR15 field.
	PORT0_PIDR_PIDR15_Msk = 0x8000
	// Bit PIDR15.
	PORT0_PIDR_PIDR15 = 0x8000
	// Low level
	PORT0_PIDR_PIDR15_0 = 0x0
	// High level
	PORT0_PIDR_PIDR15_1 = 0x1

	// PCNTR3: Port Control Register 3
	// Position of POSR00 field.
	PORT0_PCNTR3_POSR00_Pos = 0x0
	// Bit mask of POSR00 field.
	PORT0_PCNTR3_POSR00_Msk = 0x1
	// Bit POSR00.
	PORT0_PCNTR3_POSR00 = 0x1
	// No effect on output
	PORT0_PCNTR3_POSR00_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR00_1 = 0x1
	// Position of POSR01 field.
	PORT0_PCNTR3_POSR01_Pos = 0x1
	// Bit mask of POSR01 field.
	PORT0_PCNTR3_POSR01_Msk = 0x2
	// Bit POSR01.
	PORT0_PCNTR3_POSR01 = 0x2
	// No effect on output
	PORT0_PCNTR3_POSR01_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR01_1 = 0x1
	// Position of POSR02 field.
	PORT0_PCNTR3_POSR02_Pos = 0x2
	// Bit mask of POSR02 field.
	PORT0_PCNTR3_POSR02_Msk = 0x4
	// Bit POSR02.
	PORT0_PCNTR3_POSR02 = 0x4
	// No effect on output
	PORT0_PCNTR3_POSR02_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR02_1 = 0x1
	// Position of POSR03 field.
	PORT0_PCNTR3_POSR03_Pos = 0x3
	// Bit mask of POSR03 field.
	PORT0_PCNTR3_POSR03_Msk = 0x8
	// Bit POSR03.
	PORT0_PCNTR3_POSR03 = 0x8
	// No effect on output
	PORT0_PCNTR3_POSR03_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR03_1 = 0x1
	// Position of POSR04 field.
	PORT0_PCNTR3_POSR04_Pos = 0x4
	// Bit mask of POSR04 field.
	PORT0_PCNTR3_POSR04_Msk = 0x10
	// Bit POSR04.
	PORT0_PCNTR3_POSR04 = 0x10
	// No effect on output
	PORT0_PCNTR3_POSR04_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR04_1 = 0x1
	// Position of POSR05 field.
	PORT0_PCNTR3_POSR05_Pos = 0x5
	// Bit mask of POSR05 field.
	PORT0_PCNTR3_POSR05_Msk = 0x20
	// Bit POSR05.
	PORT0_PCNTR3_POSR05 = 0x20
	// No effect on output
	PORT0_PCNTR3_POSR05_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR05_1 = 0x1
	// Position of POSR06 field.
	PORT0_PCNTR3_POSR06_Pos = 0x6
	// Bit mask of POSR06 field.
	PORT0_PCNTR3_POSR06_Msk = 0x40
	// Bit POSR06.
	PORT0_PCNTR3_POSR06 = 0x40
	// No effect on output
	PORT0_PCNTR3_POSR06_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR06_1 = 0x1
	// Position of POSR07 field.
	PORT0_PCNTR3_POSR07_Pos = 0x7
	// Bit mask of POSR07 field.
	PORT0_PCNTR3_POSR07_Msk = 0x80
	// Bit POSR07.
	PORT0_PCNTR3_POSR07 = 0x80
	// No effect on output
	PORT0_PCNTR3_POSR07_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR07_1 = 0x1
	// Position of POSR08 field.
	PORT0_PCNTR3_POSR08_Pos = 0x8
	// Bit mask of POSR08 field.
	PORT0_PCNTR3_POSR08_Msk = 0x100
	// Bit POSR08.
	PORT0_PCNTR3_POSR08 = 0x100
	// No effect on output
	PORT0_PCNTR3_POSR08_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR08_1 = 0x1
	// Position of POSR09 field.
	PORT0_PCNTR3_POSR09_Pos = 0x9
	// Bit mask of POSR09 field.
	PORT0_PCNTR3_POSR09_Msk = 0x200
	// Bit POSR09.
	PORT0_PCNTR3_POSR09 = 0x200
	// No effect on output
	PORT0_PCNTR3_POSR09_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR09_1 = 0x1
	// Position of POSR10 field.
	PORT0_PCNTR3_POSR10_Pos = 0xa
	// Bit mask of POSR10 field.
	PORT0_PCNTR3_POSR10_Msk = 0x400
	// Bit POSR10.
	PORT0_PCNTR3_POSR10 = 0x400
	// No effect on output
	PORT0_PCNTR3_POSR10_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR10_1 = 0x1
	// Position of POSR11 field.
	PORT0_PCNTR3_POSR11_Pos = 0xb
	// Bit mask of POSR11 field.
	PORT0_PCNTR3_POSR11_Msk = 0x800
	// Bit POSR11.
	PORT0_PCNTR3_POSR11 = 0x800
	// No effect on output
	PORT0_PCNTR3_POSR11_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR11_1 = 0x1
	// Position of POSR12 field.
	PORT0_PCNTR3_POSR12_Pos = 0xc
	// Bit mask of POSR12 field.
	PORT0_PCNTR3_POSR12_Msk = 0x1000
	// Bit POSR12.
	PORT0_PCNTR3_POSR12 = 0x1000
	// No effect on output
	PORT0_PCNTR3_POSR12_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR12_1 = 0x1
	// Position of POSR13 field.
	PORT0_PCNTR3_POSR13_Pos = 0xd
	// Bit mask of POSR13 field.
	PORT0_PCNTR3_POSR13_Msk = 0x2000
	// Bit POSR13.
	PORT0_PCNTR3_POSR13 = 0x2000
	// No effect on output
	PORT0_PCNTR3_POSR13_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR13_1 = 0x1
	// Position of POSR14 field.
	PORT0_PCNTR3_POSR14_Pos = 0xe
	// Bit mask of POSR14 field.
	PORT0_PCNTR3_POSR14_Msk = 0x4000
	// Bit POSR14.
	PORT0_PCNTR3_POSR14 = 0x4000
	// No effect on output
	PORT0_PCNTR3_POSR14_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR14_1 = 0x1
	// Position of POSR15 field.
	PORT0_PCNTR3_POSR15_Pos = 0xf
	// Bit mask of POSR15 field.
	PORT0_PCNTR3_POSR15_Msk = 0x8000
	// Bit POSR15.
	PORT0_PCNTR3_POSR15 = 0x8000
	// No effect on output
	PORT0_PCNTR3_POSR15_0 = 0x0
	// High output
	PORT0_PCNTR3_POSR15_1 = 0x1
	// Position of PORR00 field.
	PORT0_PCNTR3_PORR00_Pos = 0x10
	// Bit mask of PORR00 field.
	PORT0_PCNTR3_PORR00_Msk = 0x10000
	// Bit PORR00.
	PORT0_PCNTR3_PORR00 = 0x10000
	// No effect on output
	PORT0_PCNTR3_PORR00_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR00_1 = 0x1
	// Position of PORR01 field.
	PORT0_PCNTR3_PORR01_Pos = 0x11
	// Bit mask of PORR01 field.
	PORT0_PCNTR3_PORR01_Msk = 0x20000
	// Bit PORR01.
	PORT0_PCNTR3_PORR01 = 0x20000
	// No effect on output
	PORT0_PCNTR3_PORR01_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR01_1 = 0x1
	// Position of PORR02 field.
	PORT0_PCNTR3_PORR02_Pos = 0x12
	// Bit mask of PORR02 field.
	PORT0_PCNTR3_PORR02_Msk = 0x40000
	// Bit PORR02.
	PORT0_PCNTR3_PORR02 = 0x40000
	// No effect on output
	PORT0_PCNTR3_PORR02_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR02_1 = 0x1
	// Position of PORR03 field.
	PORT0_PCNTR3_PORR03_Pos = 0x13
	// Bit mask of PORR03 field.
	PORT0_PCNTR3_PORR03_Msk = 0x80000
	// Bit PORR03.
	PORT0_PCNTR3_PORR03 = 0x80000
	// No effect on output
	PORT0_PCNTR3_PORR03_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR03_1 = 0x1
	// Position of PORR04 field.
	PORT0_PCNTR3_PORR04_Pos = 0x14
	// Bit mask of PORR04 field.
	PORT0_PCNTR3_PORR04_Msk = 0x100000
	// Bit PORR04.
	PORT0_PCNTR3_PORR04 = 0x100000
	// No effect on output
	PORT0_PCNTR3_PORR04_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR04_1 = 0x1
	// Position of PORR05 field.
	PORT0_PCNTR3_PORR05_Pos = 0x15
	// Bit mask of PORR05 field.
	PORT0_PCNTR3_PORR05_Msk = 0x200000
	// Bit PORR05.
	PORT0_PCNTR3_PORR05 = 0x200000
	// No effect on output
	PORT0_PCNTR3_PORR05_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR05_1 = 0x1
	// Position of PORR06 field.
	PORT0_PCNTR3_PORR06_Pos = 0x16
	// Bit mask of PORR06 field.
	PORT0_PCNTR3_PORR06_Msk = 0x400000
	// Bit PORR06.
	PORT0_PCNTR3_PORR06 = 0x400000
	// No effect on output
	PORT0_PCNTR3_PORR06_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR06_1 = 0x1
	// Position of PORR07 field.
	PORT0_PCNTR3_PORR07_Pos = 0x17
	// Bit mask of PORR07 field.
	PORT0_PCNTR3_PORR07_Msk = 0x800000
	// Bit PORR07.
	PORT0_PCNTR3_PORR07 = 0x800000
	// No effect on output
	PORT0_PCNTR3_PORR07_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR07_1 = 0x1
	// Position of PORR08 field.
	PORT0_PCNTR3_PORR08_Pos = 0x18
	// Bit mask of PORR08 field.
	PORT0_PCNTR3_PORR08_Msk = 0x1000000
	// Bit PORR08.
	PORT0_PCNTR3_PORR08 = 0x1000000
	// No effect on output
	PORT0_PCNTR3_PORR08_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR08_1 = 0x1
	// Position of PORR09 field.
	PORT0_PCNTR3_PORR09_Pos = 0x19
	// Bit mask of PORR09 field.
	PORT0_PCNTR3_PORR09_Msk = 0x2000000
	// Bit PORR09.
	PORT0_PCNTR3_PORR09 = 0x2000000
	// No effect on output
	PORT0_PCNTR3_PORR09_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR09_1 = 0x1
	// Position of PORR10 field.
	PORT0_PCNTR3_PORR10_Pos = 0x1a
	// Bit mask of PORR10 field.
	PORT0_PCNTR3_PORR10_Msk = 0x4000000
	// Bit PORR10.
	PORT0_PCNTR3_PORR10 = 0x4000000
	// No effect on output
	PORT0_PCNTR3_PORR10_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR10_1 = 0x1
	// Position of PORR11 field.
	PORT0_PCNTR3_PORR11_Pos = 0x1b
	// Bit mask of PORR11 field.
	PORT0_PCNTR3_PORR11_Msk = 0x8000000
	// Bit PORR11.
	PORT0_PCNTR3_PORR11 = 0x8000000
	// No effect on output
	PORT0_PCNTR3_PORR11_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR11_1 = 0x1
	// Position of PORR12 field.
	PORT0_PCNTR3_PORR12_Pos = 0x1c
	// Bit mask of PORR12 field.
	PORT0_PCNTR3_PORR12_Msk = 0x10000000
	// Bit PORR12.
	PORT0_PCNTR3_PORR12 = 0x10000000
	// No effect on output
	PORT0_PCNTR3_PORR12_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR12_1 = 0x1
	// Position of PORR13 field.
	PORT0_PCNTR3_PORR13_Pos = 0x1d
	// Bit mask of PORR13 field.
	PORT0_PCNTR3_PORR13_Msk = 0x20000000
	// Bit PORR13.
	PORT0_PCNTR3_PORR13 = 0x20000000
	// No effect on output
	PORT0_PCNTR3_PORR13_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR13_1 = 0x1
	// Position of PORR14 field.
	PORT0_PCNTR3_PORR14_Pos = 0x1e
	// Bit mask of PORR14 field.
	PORT0_PCNTR3_PORR14_Msk = 0x40000000
	// Bit PORR14.
	PORT0_PCNTR3_PORR14 = 0x40000000
	// No effect on output
	PORT0_PCNTR3_PORR14_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR14_1 = 0x1
	// Position of PORR15 field.
	PORT0_PCNTR3_PORR15_Pos = 0x1f
	// Bit mask of PORR15 field.
	PORT0_PCNTR3_PORR15_Msk = 0x80000000
	// Bit PORR15.
	PORT0_PCNTR3_PORR15 = 0x80000000
	// No effect on output
	PORT0_PCNTR3_PORR15_0 = 0x0
	// Low output
	PORT0_PCNTR3_PORR15_1 = 0x1

	// PORR: Port Control Register 3
	// Position of PORR00 field.
	PORT0_PORR_PORR00_Pos = 0x0
	// Bit mask of PORR00 field.
	PORT0_PORR_PORR00_Msk = 0x1
	// Bit PORR00.
	PORT0_PORR_PORR00 = 0x1
	// No effect on output
	PORT0_PORR_PORR00_0 = 0x0
	// Low output
	PORT0_PORR_PORR00_1 = 0x1
	// Position of PORR01 field.
	PORT0_PORR_PORR01_Pos = 0x1
	// Bit mask of PORR01 field.
	PORT0_PORR_PORR01_Msk = 0x2
	// Bit PORR01.
	PORT0_PORR_PORR01 = 0x2
	// No effect on output
	PORT0_PORR_PORR01_0 = 0x0
	// Low output
	PORT0_PORR_PORR01_1 = 0x1
	// Position of PORR02 field.
	PORT0_PORR_PORR02_Pos = 0x2
	// Bit mask of PORR02 field.
	PORT0_PORR_PORR02_Msk = 0x4
	// Bit PORR02.
	PORT0_PORR_PORR02 = 0x4
	// No effect on output
	PORT0_PORR_PORR02_0 = 0x0
	// Low output
	PORT0_PORR_PORR02_1 = 0x1
	// Position of PORR03 field.
	PORT0_PORR_PORR03_Pos = 0x3
	// Bit mask of PORR03 field.
	PORT0_PORR_PORR03_Msk = 0x8
	// Bit PORR03.
	PORT0_PORR_PORR03 = 0x8
	// No effect on output
	PORT0_PORR_PORR03_0 = 0x0
	// Low output
	PORT0_PORR_PORR03_1 = 0x1
	// Position of PORR04 field.
	PORT0_PORR_PORR04_Pos = 0x4
	// Bit mask of PORR04 field.
	PORT0_PORR_PORR04_Msk = 0x10
	// Bit PORR04.
	PORT0_PORR_PORR04 = 0x10
	// No effect on output
	PORT0_PORR_PORR04_0 = 0x0
	// Low output
	PORT0_PORR_PORR04_1 = 0x1
	// Position of PORR05 field.
	PORT0_PORR_PORR05_Pos = 0x5
	// Bit mask of PORR05 field.
	PORT0_PORR_PORR05_Msk = 0x20
	// Bit PORR05.
	PORT0_PORR_PORR05 = 0x20
	// No effect on output
	PORT0_PORR_PORR05_0 = 0x0
	// Low output
	PORT0_PORR_PORR05_1 = 0x1
	// Position of PORR06 field.
	PORT0_PORR_PORR06_Pos = 0x6
	// Bit mask of PORR06 field.
	PORT0_PORR_PORR06_Msk = 0x40
	// Bit PORR06.
	PORT0_PORR_PORR06 = 0x40
	// No effect on output
	PORT0_PORR_PORR06_0 = 0x0
	// Low output
	PORT0_PORR_PORR06_1 = 0x1
	// Position of PORR07 field.
	PORT0_PORR_PORR07_Pos = 0x7
	// Bit mask of PORR07 field.
	PORT0_PORR_PORR07_Msk = 0x80
	// Bit PORR07.
	PORT0_PORR_PORR07 = 0x80
	// No effect on output
	PORT0_PORR_PORR07_0 = 0x0
	// Low output
	PORT0_PORR_PORR07_1 = 0x1
	// Position of PORR08 field.
	PORT0_PORR_PORR08_Pos = 0x8
	// Bit mask of PORR08 field.
	PORT0_PORR_PORR08_Msk = 0x100
	// Bit PORR08.
	PORT0_PORR_PORR08 = 0x100
	// No effect on output
	PORT0_PORR_PORR08_0 = 0x0
	// Low output
	PORT0_PORR_PORR08_1 = 0x1
	// Position of PORR09 field.
	PORT0_PORR_PORR09_Pos = 0x9
	// Bit mask of PORR09 field.
	PORT0_PORR_PORR09_Msk = 0x200
	// Bit PORR09.
	PORT0_PORR_PORR09 = 0x200
	// No effect on output
	PORT0_PORR_PORR09_0 = 0x0
	// Low output
	PORT0_PORR_PORR09_1 = 0x1
	// Position of PORR10 field.
	PORT0_PORR_PORR10_Pos = 0xa
	// Bit mask of PORR10 field.
	PORT0_PORR_PORR10_Msk = 0x400
	// Bit PORR10.
	PORT0_PORR_PORR10 = 0x400
	// No effect on output
	PORT0_PORR_PORR10_0 = 0x0
	// Low output
	PORT0_PORR_PORR10_1 = 0x1
	// Position of PORR11 field.
	PORT0_PORR_PORR11_Pos = 0xb
	// Bit mask of PORR11 field.
	PORT0_PORR_PORR11_Msk = 0x800
	// Bit PORR11.
	PORT0_PORR_PORR11 = 0x800
	// No effect on output
	PORT0_PORR_PORR11_0 = 0x0
	// Low output
	PORT0_PORR_PORR11_1 = 0x1
	// Position of PORR12 field.
	PORT0_PORR_PORR12_Pos = 0xc
	// Bit mask of PORR12 field.
	PORT0_PORR_PORR12_Msk = 0x1000
	// Bit PORR12.
	PORT0_PORR_PORR12 = 0x1000
	// No effect on output
	PORT0_PORR_PORR12_0 = 0x0
	// Low output
	PORT0_PORR_PORR12_1 = 0x1
	// Position of PORR13 field.
	PORT0_PORR_PORR13_Pos = 0xd
	// Bit mask of PORR13 field.
	PORT0_PORR_PORR13_Msk = 0x2000
	// Bit PORR13.
	PORT0_PORR_PORR13 = 0x2000
	// No effect on output
	PORT0_PORR_PORR13_0 = 0x0
	// Low output
	PORT0_PORR_PORR13_1 = 0x1
	// Position of PORR14 field.
	PORT0_PORR_PORR14_Pos = 0xe
	// Bit mask of PORR14 field.
	PORT0_PORR_PORR14_Msk = 0x4000
	// Bit PORR14.
	PORT0_PORR_PORR14 = 0x4000
	// No effect on output
	PORT0_PORR_PORR14_0 = 0x0
	// Low output
	PORT0_PORR_PORR14_1 = 0x1
	// Position of PORR15 field.
	PORT0_PORR_PORR15_Pos = 0xf
	// Bit mask of PORR15 field.
	PORT0_PORR_PORR15_Msk = 0x8000
	// Bit PORR15.
	PORT0_PORR_PORR15 = 0x8000
	// No effect on output
	PORT0_PORR_PORR15_0 = 0x0
	// Low output
	PORT0_PORR_PORR15_1 = 0x1

	// POSR: Port Control Register 3
	// Position of POSR00 field.
	PORT0_POSR_POSR00_Pos = 0x0
	// Bit mask of POSR00 field.
	PORT0_POSR_POSR00_Msk = 0x1
	// Bit POSR00.
	PORT0_POSR_POSR00 = 0x1
	// No effect on output
	PORT0_POSR_POSR00_0 = 0x0
	// High output
	PORT0_POSR_POSR00_1 = 0x1
	// Position of POSR01 field.
	PORT0_POSR_POSR01_Pos = 0x1
	// Bit mask of POSR01 field.
	PORT0_POSR_POSR01_Msk = 0x2
	// Bit POSR01.
	PORT0_POSR_POSR01 = 0x2
	// No effect on output
	PORT0_POSR_POSR01_0 = 0x0
	// High output
	PORT0_POSR_POSR01_1 = 0x1
	// Position of POSR02 field.
	PORT0_POSR_POSR02_Pos = 0x2
	// Bit mask of POSR02 field.
	PORT0_POSR_POSR02_Msk = 0x4
	// Bit POSR02.
	PORT0_POSR_POSR02 = 0x4
	// No effect on output
	PORT0_POSR_POSR02_0 = 0x0
	// High output
	PORT0_POSR_POSR02_1 = 0x1
	// Position of POSR03 field.
	PORT0_POSR_POSR03_Pos = 0x3
	// Bit mask of POSR03 field.
	PORT0_POSR_POSR03_Msk = 0x8
	// Bit POSR03.
	PORT0_POSR_POSR03 = 0x8
	// No effect on output
	PORT0_POSR_POSR03_0 = 0x0
	// High output
	PORT0_POSR_POSR03_1 = 0x1
	// Position of POSR04 field.
	PORT0_POSR_POSR04_Pos = 0x4
	// Bit mask of POSR04 field.
	PORT0_POSR_POSR04_Msk = 0x10
	// Bit POSR04.
	PORT0_POSR_POSR04 = 0x10
	// No effect on output
	PORT0_POSR_POSR04_0 = 0x0
	// High output
	PORT0_POSR_POSR04_1 = 0x1
	// Position of POSR05 field.
	PORT0_POSR_POSR05_Pos = 0x5
	// Bit mask of POSR05 field.
	PORT0_POSR_POSR05_Msk = 0x20
	// Bit POSR05.
	PORT0_POSR_POSR05 = 0x20
	// No effect on output
	PORT0_POSR_POSR05_0 = 0x0
	// High output
	PORT0_POSR_POSR05_1 = 0x1
	// Position of POSR06 field.
	PORT0_POSR_POSR06_Pos = 0x6
	// Bit mask of POSR06 field.
	PORT0_POSR_POSR06_Msk = 0x40
	// Bit POSR06.
	PORT0_POSR_POSR06 = 0x40
	// No effect on output
	PORT0_POSR_POSR06_0 = 0x0
	// High output
	PORT0_POSR_POSR06_1 = 0x1
	// Position of POSR07 field.
	PORT0_POSR_POSR07_Pos = 0x7
	// Bit mask of POSR07 field.
	PORT0_POSR_POSR07_Msk = 0x80
	// Bit POSR07.
	PORT0_POSR_POSR07 = 0x80
	// No effect on output
	PORT0_POSR_POSR07_0 = 0x0
	// High output
	PORT0_POSR_POSR07_1 = 0x1
	// Position of POSR08 field.
	PORT0_POSR_POSR08_Pos = 0x8
	// Bit mask of POSR08 field.
	PORT0_POSR_POSR08_Msk = 0x100
	// Bit POSR08.
	PORT0_POSR_POSR08 = 0x100
	// No effect on output
	PORT0_POSR_POSR08_0 = 0x0
	// High output
	PORT0_POSR_POSR08_1 = 0x1
	// Position of POSR09 field.
	PORT0_POSR_POSR09_Pos = 0x9
	// Bit mask of POSR09 field.
	PORT0_POSR_POSR09_Msk = 0x200
	// Bit POSR09.
	PORT0_POSR_POSR09 = 0x200
	// No effect on output
	PORT0_POSR_POSR09_0 = 0x0
	// High output
	PORT0_POSR_POSR09_1 = 0x1
	// Position of POSR10 field.
	PORT0_POSR_POSR10_Pos = 0xa
	// Bit mask of POSR10 field.
	PORT0_POSR_POSR10_Msk = 0x400
	// Bit POSR10.
	PORT0_POSR_POSR10 = 0x400
	// No effect on output
	PORT0_POSR_POSR10_0 = 0x0
	// High output
	PORT0_POSR_POSR10_1 = 0x1
	// Position of POSR11 field.
	PORT0_POSR_POSR11_Pos = 0xb
	// Bit mask of POSR11 field.
	PORT0_POSR_POSR11_Msk = 0x800
	// Bit POSR11.
	PORT0_POSR_POSR11 = 0x800
	// No effect on output
	PORT0_POSR_POSR11_0 = 0x0
	// High output
	PORT0_POSR_POSR11_1 = 0x1
	// Position of POSR12 field.
	PORT0_POSR_POSR12_Pos = 0xc
	// Bit mask of POSR12 field.
	PORT0_POSR_POSR12_Msk = 0x1000
	// Bit POSR12.
	PORT0_POSR_POSR12 = 0x1000
	// No effect on output
	PORT0_POSR_POSR12_0 = 0x0
	// High output
	PORT0_POSR_POSR12_1 = 0x1
	// Position of POSR13 field.
	PORT0_POSR_POSR13_Pos = 0xd
	// Bit mask of POSR13 field.
	PORT0_POSR_POSR13_Msk = 0x2000
	// Bit POSR13.
	PORT0_POSR_POSR13 = 0x2000
	// No effect on output
	PORT0_POSR_POSR13_0 = 0x0
	// High output
	PORT0_POSR_POSR13_1 = 0x1
	// Position of POSR14 field.
	PORT0_POSR_POSR14_Pos = 0xe
	// Bit mask of POSR14 field.
	PORT0_POSR_POSR14_Msk = 0x4000
	// Bit POSR14.
	PORT0_POSR_POSR14 = 0x4000
	// No effect on output
	PORT0_POSR_POSR14_0 = 0x0
	// High output
	PORT0_POSR_POSR14_1 = 0x1
	// Position of POSR15 field.
	PORT0_POSR_POSR15_Pos = 0xf
	// Bit mask of POSR15 field.
	PORT0_POSR_POSR15_Msk = 0x8000
	// Bit POSR15.
	PORT0_POSR_POSR15 = 0x8000
	// No effect on output
	PORT0_POSR_POSR15_0 = 0x0
	// High output
	PORT0_POSR_POSR15_1 = 0x1
)

// Constants for PORT1: Port 1 Control Registers
const (
	// PCNTR1: Port Control Register 1
	// Position of PDR00 field.
	PORT1_PCNTR1_PDR00_Pos = 0x0
	// Bit mask of PDR00 field.
	PORT1_PCNTR1_PDR00_Msk = 0x1
	// Bit PDR00.
	PORT1_PCNTR1_PDR00 = 0x1
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR00_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR00_1 = 0x1
	// Position of PDR01 field.
	PORT1_PCNTR1_PDR01_Pos = 0x1
	// Bit mask of PDR01 field.
	PORT1_PCNTR1_PDR01_Msk = 0x2
	// Bit PDR01.
	PORT1_PCNTR1_PDR01 = 0x2
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR01_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR01_1 = 0x1
	// Position of PDR02 field.
	PORT1_PCNTR1_PDR02_Pos = 0x2
	// Bit mask of PDR02 field.
	PORT1_PCNTR1_PDR02_Msk = 0x4
	// Bit PDR02.
	PORT1_PCNTR1_PDR02 = 0x4
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR02_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR02_1 = 0x1
	// Position of PDR03 field.
	PORT1_PCNTR1_PDR03_Pos = 0x3
	// Bit mask of PDR03 field.
	PORT1_PCNTR1_PDR03_Msk = 0x8
	// Bit PDR03.
	PORT1_PCNTR1_PDR03 = 0x8
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR03_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR03_1 = 0x1
	// Position of PDR04 field.
	PORT1_PCNTR1_PDR04_Pos = 0x4
	// Bit mask of PDR04 field.
	PORT1_PCNTR1_PDR04_Msk = 0x10
	// Bit PDR04.
	PORT1_PCNTR1_PDR04 = 0x10
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR04_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR04_1 = 0x1
	// Position of PDR05 field.
	PORT1_PCNTR1_PDR05_Pos = 0x5
	// Bit mask of PDR05 field.
	PORT1_PCNTR1_PDR05_Msk = 0x20
	// Bit PDR05.
	PORT1_PCNTR1_PDR05 = 0x20
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR05_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR05_1 = 0x1
	// Position of PDR06 field.
	PORT1_PCNTR1_PDR06_Pos = 0x6
	// Bit mask of PDR06 field.
	PORT1_PCNTR1_PDR06_Msk = 0x40
	// Bit PDR06.
	PORT1_PCNTR1_PDR06 = 0x40
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR06_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR06_1 = 0x1
	// Position of PDR07 field.
	PORT1_PCNTR1_PDR07_Pos = 0x7
	// Bit mask of PDR07 field.
	PORT1_PCNTR1_PDR07_Msk = 0x80
	// Bit PDR07.
	PORT1_PCNTR1_PDR07 = 0x80
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR07_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR07_1 = 0x1
	// Position of PDR08 field.
	PORT1_PCNTR1_PDR08_Pos = 0x8
	// Bit mask of PDR08 field.
	PORT1_PCNTR1_PDR08_Msk = 0x100
	// Bit PDR08.
	PORT1_PCNTR1_PDR08 = 0x100
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR08_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR08_1 = 0x1
	// Position of PDR09 field.
	PORT1_PCNTR1_PDR09_Pos = 0x9
	// Bit mask of PDR09 field.
	PORT1_PCNTR1_PDR09_Msk = 0x200
	// Bit PDR09.
	PORT1_PCNTR1_PDR09 = 0x200
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR09_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR09_1 = 0x1
	// Position of PDR10 field.
	PORT1_PCNTR1_PDR10_Pos = 0xa
	// Bit mask of PDR10 field.
	PORT1_PCNTR1_PDR10_Msk = 0x400
	// Bit PDR10.
	PORT1_PCNTR1_PDR10 = 0x400
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR10_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR10_1 = 0x1
	// Position of PDR11 field.
	PORT1_PCNTR1_PDR11_Pos = 0xb
	// Bit mask of PDR11 field.
	PORT1_PCNTR1_PDR11_Msk = 0x800
	// Bit PDR11.
	PORT1_PCNTR1_PDR11 = 0x800
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR11_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR11_1 = 0x1
	// Position of PDR12 field.
	PORT1_PCNTR1_PDR12_Pos = 0xc
	// Bit mask of PDR12 field.
	PORT1_PCNTR1_PDR12_Msk = 0x1000
	// Bit PDR12.
	PORT1_PCNTR1_PDR12 = 0x1000
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR12_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR12_1 = 0x1
	// Position of PDR13 field.
	PORT1_PCNTR1_PDR13_Pos = 0xd
	// Bit mask of PDR13 field.
	PORT1_PCNTR1_PDR13_Msk = 0x2000
	// Bit PDR13.
	PORT1_PCNTR1_PDR13 = 0x2000
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR13_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR13_1 = 0x1
	// Position of PDR14 field.
	PORT1_PCNTR1_PDR14_Pos = 0xe
	// Bit mask of PDR14 field.
	PORT1_PCNTR1_PDR14_Msk = 0x4000
	// Bit PDR14.
	PORT1_PCNTR1_PDR14 = 0x4000
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR14_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR14_1 = 0x1
	// Position of PDR15 field.
	PORT1_PCNTR1_PDR15_Pos = 0xf
	// Bit mask of PDR15 field.
	PORT1_PCNTR1_PDR15_Msk = 0x8000
	// Bit PDR15.
	PORT1_PCNTR1_PDR15 = 0x8000
	// Input (functions as an input pin)
	PORT1_PCNTR1_PDR15_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PCNTR1_PDR15_1 = 0x1
	// Position of PODR00 field.
	PORT1_PCNTR1_PODR00_Pos = 0x10
	// Bit mask of PODR00 field.
	PORT1_PCNTR1_PODR00_Msk = 0x10000
	// Bit PODR00.
	PORT1_PCNTR1_PODR00 = 0x10000
	// Low output
	PORT1_PCNTR1_PODR00_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR00_1 = 0x1
	// Position of PODR01 field.
	PORT1_PCNTR1_PODR01_Pos = 0x11
	// Bit mask of PODR01 field.
	PORT1_PCNTR1_PODR01_Msk = 0x20000
	// Bit PODR01.
	PORT1_PCNTR1_PODR01 = 0x20000
	// Low output
	PORT1_PCNTR1_PODR01_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR01_1 = 0x1
	// Position of PODR02 field.
	PORT1_PCNTR1_PODR02_Pos = 0x12
	// Bit mask of PODR02 field.
	PORT1_PCNTR1_PODR02_Msk = 0x40000
	// Bit PODR02.
	PORT1_PCNTR1_PODR02 = 0x40000
	// Low output
	PORT1_PCNTR1_PODR02_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR02_1 = 0x1
	// Position of PODR03 field.
	PORT1_PCNTR1_PODR03_Pos = 0x13
	// Bit mask of PODR03 field.
	PORT1_PCNTR1_PODR03_Msk = 0x80000
	// Bit PODR03.
	PORT1_PCNTR1_PODR03 = 0x80000
	// Low output
	PORT1_PCNTR1_PODR03_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR03_1 = 0x1
	// Position of PODR04 field.
	PORT1_PCNTR1_PODR04_Pos = 0x14
	// Bit mask of PODR04 field.
	PORT1_PCNTR1_PODR04_Msk = 0x100000
	// Bit PODR04.
	PORT1_PCNTR1_PODR04 = 0x100000
	// Low output
	PORT1_PCNTR1_PODR04_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR04_1 = 0x1
	// Position of PODR05 field.
	PORT1_PCNTR1_PODR05_Pos = 0x15
	// Bit mask of PODR05 field.
	PORT1_PCNTR1_PODR05_Msk = 0x200000
	// Bit PODR05.
	PORT1_PCNTR1_PODR05 = 0x200000
	// Low output
	PORT1_PCNTR1_PODR05_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR05_1 = 0x1
	// Position of PODR06 field.
	PORT1_PCNTR1_PODR06_Pos = 0x16
	// Bit mask of PODR06 field.
	PORT1_PCNTR1_PODR06_Msk = 0x400000
	// Bit PODR06.
	PORT1_PCNTR1_PODR06 = 0x400000
	// Low output
	PORT1_PCNTR1_PODR06_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR06_1 = 0x1
	// Position of PODR07 field.
	PORT1_PCNTR1_PODR07_Pos = 0x17
	// Bit mask of PODR07 field.
	PORT1_PCNTR1_PODR07_Msk = 0x800000
	// Bit PODR07.
	PORT1_PCNTR1_PODR07 = 0x800000
	// Low output
	PORT1_PCNTR1_PODR07_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR07_1 = 0x1
	// Position of PODR08 field.
	PORT1_PCNTR1_PODR08_Pos = 0x18
	// Bit mask of PODR08 field.
	PORT1_PCNTR1_PODR08_Msk = 0x1000000
	// Bit PODR08.
	PORT1_PCNTR1_PODR08 = 0x1000000
	// Low output
	PORT1_PCNTR1_PODR08_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR08_1 = 0x1
	// Position of PODR09 field.
	PORT1_PCNTR1_PODR09_Pos = 0x19
	// Bit mask of PODR09 field.
	PORT1_PCNTR1_PODR09_Msk = 0x2000000
	// Bit PODR09.
	PORT1_PCNTR1_PODR09 = 0x2000000
	// Low output
	PORT1_PCNTR1_PODR09_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR09_1 = 0x1
	// Position of PODR10 field.
	PORT1_PCNTR1_PODR10_Pos = 0x1a
	// Bit mask of PODR10 field.
	PORT1_PCNTR1_PODR10_Msk = 0x4000000
	// Bit PODR10.
	PORT1_PCNTR1_PODR10 = 0x4000000
	// Low output
	PORT1_PCNTR1_PODR10_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR10_1 = 0x1
	// Position of PODR11 field.
	PORT1_PCNTR1_PODR11_Pos = 0x1b
	// Bit mask of PODR11 field.
	PORT1_PCNTR1_PODR11_Msk = 0x8000000
	// Bit PODR11.
	PORT1_PCNTR1_PODR11 = 0x8000000
	// Low output
	PORT1_PCNTR1_PODR11_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR11_1 = 0x1
	// Position of PODR12 field.
	PORT1_PCNTR1_PODR12_Pos = 0x1c
	// Bit mask of PODR12 field.
	PORT1_PCNTR1_PODR12_Msk = 0x10000000
	// Bit PODR12.
	PORT1_PCNTR1_PODR12 = 0x10000000
	// Low output
	PORT1_PCNTR1_PODR12_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR12_1 = 0x1
	// Position of PODR13 field.
	PORT1_PCNTR1_PODR13_Pos = 0x1d
	// Bit mask of PODR13 field.
	PORT1_PCNTR1_PODR13_Msk = 0x20000000
	// Bit PODR13.
	PORT1_PCNTR1_PODR13 = 0x20000000
	// Low output
	PORT1_PCNTR1_PODR13_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR13_1 = 0x1
	// Position of PODR14 field.
	PORT1_PCNTR1_PODR14_Pos = 0x1e
	// Bit mask of PODR14 field.
	PORT1_PCNTR1_PODR14_Msk = 0x40000000
	// Bit PODR14.
	PORT1_PCNTR1_PODR14 = 0x40000000
	// Low output
	PORT1_PCNTR1_PODR14_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR14_1 = 0x1
	// Position of PODR15 field.
	PORT1_PCNTR1_PODR15_Pos = 0x1f
	// Bit mask of PODR15 field.
	PORT1_PCNTR1_PODR15_Msk = 0x80000000
	// Bit PODR15.
	PORT1_PCNTR1_PODR15 = 0x80000000
	// Low output
	PORT1_PCNTR1_PODR15_0 = 0x0
	// High output
	PORT1_PCNTR1_PODR15_1 = 0x1

	// PODR: Port Control Register 1
	// Position of PODR00 field.
	PORT1_PODR_PODR00_Pos = 0x0
	// Bit mask of PODR00 field.
	PORT1_PODR_PODR00_Msk = 0x1
	// Bit PODR00.
	PORT1_PODR_PODR00 = 0x1
	// Low output
	PORT1_PODR_PODR00_0 = 0x0
	// High output
	PORT1_PODR_PODR00_1 = 0x1
	// Position of PODR01 field.
	PORT1_PODR_PODR01_Pos = 0x1
	// Bit mask of PODR01 field.
	PORT1_PODR_PODR01_Msk = 0x2
	// Bit PODR01.
	PORT1_PODR_PODR01 = 0x2
	// Low output
	PORT1_PODR_PODR01_0 = 0x0
	// High output
	PORT1_PODR_PODR01_1 = 0x1
	// Position of PODR02 field.
	PORT1_PODR_PODR02_Pos = 0x2
	// Bit mask of PODR02 field.
	PORT1_PODR_PODR02_Msk = 0x4
	// Bit PODR02.
	PORT1_PODR_PODR02 = 0x4
	// Low output
	PORT1_PODR_PODR02_0 = 0x0
	// High output
	PORT1_PODR_PODR02_1 = 0x1
	// Position of PODR03 field.
	PORT1_PODR_PODR03_Pos = 0x3
	// Bit mask of PODR03 field.
	PORT1_PODR_PODR03_Msk = 0x8
	// Bit PODR03.
	PORT1_PODR_PODR03 = 0x8
	// Low output
	PORT1_PODR_PODR03_0 = 0x0
	// High output
	PORT1_PODR_PODR03_1 = 0x1
	// Position of PODR04 field.
	PORT1_PODR_PODR04_Pos = 0x4
	// Bit mask of PODR04 field.
	PORT1_PODR_PODR04_Msk = 0x10
	// Bit PODR04.
	PORT1_PODR_PODR04 = 0x10
	// Low output
	PORT1_PODR_PODR04_0 = 0x0
	// High output
	PORT1_PODR_PODR04_1 = 0x1
	// Position of PODR05 field.
	PORT1_PODR_PODR05_Pos = 0x5
	// Bit mask of PODR05 field.
	PORT1_PODR_PODR05_Msk = 0x20
	// Bit PODR05.
	PORT1_PODR_PODR05 = 0x20
	// Low output
	PORT1_PODR_PODR05_0 = 0x0
	// High output
	PORT1_PODR_PODR05_1 = 0x1
	// Position of PODR06 field.
	PORT1_PODR_PODR06_Pos = 0x6
	// Bit mask of PODR06 field.
	PORT1_PODR_PODR06_Msk = 0x40
	// Bit PODR06.
	PORT1_PODR_PODR06 = 0x40
	// Low output
	PORT1_PODR_PODR06_0 = 0x0
	// High output
	PORT1_PODR_PODR06_1 = 0x1
	// Position of PODR07 field.
	PORT1_PODR_PODR07_Pos = 0x7
	// Bit mask of PODR07 field.
	PORT1_PODR_PODR07_Msk = 0x80
	// Bit PODR07.
	PORT1_PODR_PODR07 = 0x80
	// Low output
	PORT1_PODR_PODR07_0 = 0x0
	// High output
	PORT1_PODR_PODR07_1 = 0x1
	// Position of PODR08 field.
	PORT1_PODR_PODR08_Pos = 0x8
	// Bit mask of PODR08 field.
	PORT1_PODR_PODR08_Msk = 0x100
	// Bit PODR08.
	PORT1_PODR_PODR08 = 0x100
	// Low output
	PORT1_PODR_PODR08_0 = 0x0
	// High output
	PORT1_PODR_PODR08_1 = 0x1
	// Position of PODR09 field.
	PORT1_PODR_PODR09_Pos = 0x9
	// Bit mask of PODR09 field.
	PORT1_PODR_PODR09_Msk = 0x200
	// Bit PODR09.
	PORT1_PODR_PODR09 = 0x200
	// Low output
	PORT1_PODR_PODR09_0 = 0x0
	// High output
	PORT1_PODR_PODR09_1 = 0x1
	// Position of PODR10 field.
	PORT1_PODR_PODR10_Pos = 0xa
	// Bit mask of PODR10 field.
	PORT1_PODR_PODR10_Msk = 0x400
	// Bit PODR10.
	PORT1_PODR_PODR10 = 0x400
	// Low output
	PORT1_PODR_PODR10_0 = 0x0
	// High output
	PORT1_PODR_PODR10_1 = 0x1
	// Position of PODR11 field.
	PORT1_PODR_PODR11_Pos = 0xb
	// Bit mask of PODR11 field.
	PORT1_PODR_PODR11_Msk = 0x800
	// Bit PODR11.
	PORT1_PODR_PODR11 = 0x800
	// Low output
	PORT1_PODR_PODR11_0 = 0x0
	// High output
	PORT1_PODR_PODR11_1 = 0x1
	// Position of PODR12 field.
	PORT1_PODR_PODR12_Pos = 0xc
	// Bit mask of PODR12 field.
	PORT1_PODR_PODR12_Msk = 0x1000
	// Bit PODR12.
	PORT1_PODR_PODR12 = 0x1000
	// Low output
	PORT1_PODR_PODR12_0 = 0x0
	// High output
	PORT1_PODR_PODR12_1 = 0x1
	// Position of PODR13 field.
	PORT1_PODR_PODR13_Pos = 0xd
	// Bit mask of PODR13 field.
	PORT1_PODR_PODR13_Msk = 0x2000
	// Bit PODR13.
	PORT1_PODR_PODR13 = 0x2000
	// Low output
	PORT1_PODR_PODR13_0 = 0x0
	// High output
	PORT1_PODR_PODR13_1 = 0x1
	// Position of PODR14 field.
	PORT1_PODR_PODR14_Pos = 0xe
	// Bit mask of PODR14 field.
	PORT1_PODR_PODR14_Msk = 0x4000
	// Bit PODR14.
	PORT1_PODR_PODR14 = 0x4000
	// Low output
	PORT1_PODR_PODR14_0 = 0x0
	// High output
	PORT1_PODR_PODR14_1 = 0x1
	// Position of PODR15 field.
	PORT1_PODR_PODR15_Pos = 0xf
	// Bit mask of PODR15 field.
	PORT1_PODR_PODR15_Msk = 0x8000
	// Bit PODR15.
	PORT1_PODR_PODR15 = 0x8000
	// Low output
	PORT1_PODR_PODR15_0 = 0x0
	// High output
	PORT1_PODR_PODR15_1 = 0x1

	// PDR: Port Control Register 1
	// Position of PDR00 field.
	PORT1_PDR_PDR00_Pos = 0x0
	// Bit mask of PDR00 field.
	PORT1_PDR_PDR00_Msk = 0x1
	// Bit PDR00.
	PORT1_PDR_PDR00 = 0x1
	// Input (functions as an input pin)
	PORT1_PDR_PDR00_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR00_1 = 0x1
	// Position of PDR01 field.
	PORT1_PDR_PDR01_Pos = 0x1
	// Bit mask of PDR01 field.
	PORT1_PDR_PDR01_Msk = 0x2
	// Bit PDR01.
	PORT1_PDR_PDR01 = 0x2
	// Input (functions as an input pin)
	PORT1_PDR_PDR01_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR01_1 = 0x1
	// Position of PDR02 field.
	PORT1_PDR_PDR02_Pos = 0x2
	// Bit mask of PDR02 field.
	PORT1_PDR_PDR02_Msk = 0x4
	// Bit PDR02.
	PORT1_PDR_PDR02 = 0x4
	// Input (functions as an input pin)
	PORT1_PDR_PDR02_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR02_1 = 0x1
	// Position of PDR03 field.
	PORT1_PDR_PDR03_Pos = 0x3
	// Bit mask of PDR03 field.
	PORT1_PDR_PDR03_Msk = 0x8
	// Bit PDR03.
	PORT1_PDR_PDR03 = 0x8
	// Input (functions as an input pin)
	PORT1_PDR_PDR03_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR03_1 = 0x1
	// Position of PDR04 field.
	PORT1_PDR_PDR04_Pos = 0x4
	// Bit mask of PDR04 field.
	PORT1_PDR_PDR04_Msk = 0x10
	// Bit PDR04.
	PORT1_PDR_PDR04 = 0x10
	// Input (functions as an input pin)
	PORT1_PDR_PDR04_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR04_1 = 0x1
	// Position of PDR05 field.
	PORT1_PDR_PDR05_Pos = 0x5
	// Bit mask of PDR05 field.
	PORT1_PDR_PDR05_Msk = 0x20
	// Bit PDR05.
	PORT1_PDR_PDR05 = 0x20
	// Input (functions as an input pin)
	PORT1_PDR_PDR05_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR05_1 = 0x1
	// Position of PDR06 field.
	PORT1_PDR_PDR06_Pos = 0x6
	// Bit mask of PDR06 field.
	PORT1_PDR_PDR06_Msk = 0x40
	// Bit PDR06.
	PORT1_PDR_PDR06 = 0x40
	// Input (functions as an input pin)
	PORT1_PDR_PDR06_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR06_1 = 0x1
	// Position of PDR07 field.
	PORT1_PDR_PDR07_Pos = 0x7
	// Bit mask of PDR07 field.
	PORT1_PDR_PDR07_Msk = 0x80
	// Bit PDR07.
	PORT1_PDR_PDR07 = 0x80
	// Input (functions as an input pin)
	PORT1_PDR_PDR07_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR07_1 = 0x1
	// Position of PDR08 field.
	PORT1_PDR_PDR08_Pos = 0x8
	// Bit mask of PDR08 field.
	PORT1_PDR_PDR08_Msk = 0x100
	// Bit PDR08.
	PORT1_PDR_PDR08 = 0x100
	// Input (functions as an input pin)
	PORT1_PDR_PDR08_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR08_1 = 0x1
	// Position of PDR09 field.
	PORT1_PDR_PDR09_Pos = 0x9
	// Bit mask of PDR09 field.
	PORT1_PDR_PDR09_Msk = 0x200
	// Bit PDR09.
	PORT1_PDR_PDR09 = 0x200
	// Input (functions as an input pin)
	PORT1_PDR_PDR09_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR09_1 = 0x1
	// Position of PDR10 field.
	PORT1_PDR_PDR10_Pos = 0xa
	// Bit mask of PDR10 field.
	PORT1_PDR_PDR10_Msk = 0x400
	// Bit PDR10.
	PORT1_PDR_PDR10 = 0x400
	// Input (functions as an input pin)
	PORT1_PDR_PDR10_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR10_1 = 0x1
	// Position of PDR11 field.
	PORT1_PDR_PDR11_Pos = 0xb
	// Bit mask of PDR11 field.
	PORT1_PDR_PDR11_Msk = 0x800
	// Bit PDR11.
	PORT1_PDR_PDR11 = 0x800
	// Input (functions as an input pin)
	PORT1_PDR_PDR11_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR11_1 = 0x1
	// Position of PDR12 field.
	PORT1_PDR_PDR12_Pos = 0xc
	// Bit mask of PDR12 field.
	PORT1_PDR_PDR12_Msk = 0x1000
	// Bit PDR12.
	PORT1_PDR_PDR12 = 0x1000
	// Input (functions as an input pin)
	PORT1_PDR_PDR12_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR12_1 = 0x1
	// Position of PDR13 field.
	PORT1_PDR_PDR13_Pos = 0xd
	// Bit mask of PDR13 field.
	PORT1_PDR_PDR13_Msk = 0x2000
	// Bit PDR13.
	PORT1_PDR_PDR13 = 0x2000
	// Input (functions as an input pin)
	PORT1_PDR_PDR13_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR13_1 = 0x1
	// Position of PDR14 field.
	PORT1_PDR_PDR14_Pos = 0xe
	// Bit mask of PDR14 field.
	PORT1_PDR_PDR14_Msk = 0x4000
	// Bit PDR14.
	PORT1_PDR_PDR14 = 0x4000
	// Input (functions as an input pin)
	PORT1_PDR_PDR14_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR14_1 = 0x1
	// Position of PDR15 field.
	PORT1_PDR_PDR15_Pos = 0xf
	// Bit mask of PDR15 field.
	PORT1_PDR_PDR15_Msk = 0x8000
	// Bit PDR15.
	PORT1_PDR_PDR15 = 0x8000
	// Input (functions as an input pin)
	PORT1_PDR_PDR15_0 = 0x0
	// Output (functions as an output pin)
	PORT1_PDR_PDR15_1 = 0x1

	// PCNTR2: Port Control Register 2
	// Position of PIDR00 field.
	PORT1_PCNTR2_PIDR00_Pos = 0x0
	// Bit mask of PIDR00 field.
	PORT1_PCNTR2_PIDR00_Msk = 0x1
	// Bit PIDR00.
	PORT1_PCNTR2_PIDR00 = 0x1
	// Low level
	PORT1_PCNTR2_PIDR00_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR00_1 = 0x1
	// Position of PIDR01 field.
	PORT1_PCNTR2_PIDR01_Pos = 0x1
	// Bit mask of PIDR01 field.
	PORT1_PCNTR2_PIDR01_Msk = 0x2
	// Bit PIDR01.
	PORT1_PCNTR2_PIDR01 = 0x2
	// Low level
	PORT1_PCNTR2_PIDR01_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR01_1 = 0x1
	// Position of PIDR02 field.
	PORT1_PCNTR2_PIDR02_Pos = 0x2
	// Bit mask of PIDR02 field.
	PORT1_PCNTR2_PIDR02_Msk = 0x4
	// Bit PIDR02.
	PORT1_PCNTR2_PIDR02 = 0x4
	// Low level
	PORT1_PCNTR2_PIDR02_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR02_1 = 0x1
	// Position of PIDR03 field.
	PORT1_PCNTR2_PIDR03_Pos = 0x3
	// Bit mask of PIDR03 field.
	PORT1_PCNTR2_PIDR03_Msk = 0x8
	// Bit PIDR03.
	PORT1_PCNTR2_PIDR03 = 0x8
	// Low level
	PORT1_PCNTR2_PIDR03_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR03_1 = 0x1
	// Position of PIDR04 field.
	PORT1_PCNTR2_PIDR04_Pos = 0x4
	// Bit mask of PIDR04 field.
	PORT1_PCNTR2_PIDR04_Msk = 0x10
	// Bit PIDR04.
	PORT1_PCNTR2_PIDR04 = 0x10
	// Low level
	PORT1_PCNTR2_PIDR04_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR04_1 = 0x1
	// Position of PIDR05 field.
	PORT1_PCNTR2_PIDR05_Pos = 0x5
	// Bit mask of PIDR05 field.
	PORT1_PCNTR2_PIDR05_Msk = 0x20
	// Bit PIDR05.
	PORT1_PCNTR2_PIDR05 = 0x20
	// Low level
	PORT1_PCNTR2_PIDR05_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR05_1 = 0x1
	// Position of PIDR06 field.
	PORT1_PCNTR2_PIDR06_Pos = 0x6
	// Bit mask of PIDR06 field.
	PORT1_PCNTR2_PIDR06_Msk = 0x40
	// Bit PIDR06.
	PORT1_PCNTR2_PIDR06 = 0x40
	// Low level
	PORT1_PCNTR2_PIDR06_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR06_1 = 0x1
	// Position of PIDR07 field.
	PORT1_PCNTR2_PIDR07_Pos = 0x7
	// Bit mask of PIDR07 field.
	PORT1_PCNTR2_PIDR07_Msk = 0x80
	// Bit PIDR07.
	PORT1_PCNTR2_PIDR07 = 0x80
	// Low level
	PORT1_PCNTR2_PIDR07_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR07_1 = 0x1
	// Position of PIDR08 field.
	PORT1_PCNTR2_PIDR08_Pos = 0x8
	// Bit mask of PIDR08 field.
	PORT1_PCNTR2_PIDR08_Msk = 0x100
	// Bit PIDR08.
	PORT1_PCNTR2_PIDR08 = 0x100
	// Low level
	PORT1_PCNTR2_PIDR08_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR08_1 = 0x1
	// Position of PIDR09 field.
	PORT1_PCNTR2_PIDR09_Pos = 0x9
	// Bit mask of PIDR09 field.
	PORT1_PCNTR2_PIDR09_Msk = 0x200
	// Bit PIDR09.
	PORT1_PCNTR2_PIDR09 = 0x200
	// Low level
	PORT1_PCNTR2_PIDR09_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR09_1 = 0x1
	// Position of PIDR10 field.
	PORT1_PCNTR2_PIDR10_Pos = 0xa
	// Bit mask of PIDR10 field.
	PORT1_PCNTR2_PIDR10_Msk = 0x400
	// Bit PIDR10.
	PORT1_PCNTR2_PIDR10 = 0x400
	// Low level
	PORT1_PCNTR2_PIDR10_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR10_1 = 0x1
	// Position of PIDR11 field.
	PORT1_PCNTR2_PIDR11_Pos = 0xb
	// Bit mask of PIDR11 field.
	PORT1_PCNTR2_PIDR11_Msk = 0x800
	// Bit PIDR11.
	PORT1_PCNTR2_PIDR11 = 0x800
	// Low level
	PORT1_PCNTR2_PIDR11_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR11_1 = 0x1
	// Position of PIDR12 field.
	PORT1_PCNTR2_PIDR12_Pos = 0xc
	// Bit mask of PIDR12 field.
	PORT1_PCNTR2_PIDR12_Msk = 0x1000
	// Bit PIDR12.
	PORT1_PCNTR2_PIDR12 = 0x1000
	// Low level
	PORT1_PCNTR2_PIDR12_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR12_1 = 0x1
	// Position of PIDR13 field.
	PORT1_PCNTR2_PIDR13_Pos = 0xd
	// Bit mask of PIDR13 field.
	PORT1_PCNTR2_PIDR13_Msk = 0x2000
	// Bit PIDR13.
	PORT1_PCNTR2_PIDR13 = 0x2000
	// Low level
	PORT1_PCNTR2_PIDR13_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR13_1 = 0x1
	// Position of PIDR14 field.
	PORT1_PCNTR2_PIDR14_Pos = 0xe
	// Bit mask of PIDR14 field.
	PORT1_PCNTR2_PIDR14_Msk = 0x4000
	// Bit PIDR14.
	PORT1_PCNTR2_PIDR14 = 0x4000
	// Low level
	PORT1_PCNTR2_PIDR14_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR14_1 = 0x1
	// Position of PIDR15 field.
	PORT1_PCNTR2_PIDR15_Pos = 0xf
	// Bit mask of PIDR15 field.
	PORT1_PCNTR2_PIDR15_Msk = 0x8000
	// Bit PIDR15.
	PORT1_PCNTR2_PIDR15 = 0x8000
	// Low level
	PORT1_PCNTR2_PIDR15_0 = 0x0
	// High level
	PORT1_PCNTR2_PIDR15_1 = 0x1
	// Position of EIDR00 field.
	PORT1_PCNTR2_EIDR00_Pos = 0x10
	// Bit mask of EIDR00 field.
	PORT1_PCNTR2_EIDR00_Msk = 0x10000
	// Bit EIDR00.
	PORT1_PCNTR2_EIDR00 = 0x10000
	// Low input
	PORT1_PCNTR2_EIDR00_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR00_1 = 0x1
	// Position of EIDR01 field.
	PORT1_PCNTR2_EIDR01_Pos = 0x11
	// Bit mask of EIDR01 field.
	PORT1_PCNTR2_EIDR01_Msk = 0x20000
	// Bit EIDR01.
	PORT1_PCNTR2_EIDR01 = 0x20000
	// Low input
	PORT1_PCNTR2_EIDR01_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR01_1 = 0x1
	// Position of EIDR02 field.
	PORT1_PCNTR2_EIDR02_Pos = 0x12
	// Bit mask of EIDR02 field.
	PORT1_PCNTR2_EIDR02_Msk = 0x40000
	// Bit EIDR02.
	PORT1_PCNTR2_EIDR02 = 0x40000
	// Low input
	PORT1_PCNTR2_EIDR02_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR02_1 = 0x1
	// Position of EIDR03 field.
	PORT1_PCNTR2_EIDR03_Pos = 0x13
	// Bit mask of EIDR03 field.
	PORT1_PCNTR2_EIDR03_Msk = 0x80000
	// Bit EIDR03.
	PORT1_PCNTR2_EIDR03 = 0x80000
	// Low input
	PORT1_PCNTR2_EIDR03_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR03_1 = 0x1
	// Position of EIDR04 field.
	PORT1_PCNTR2_EIDR04_Pos = 0x14
	// Bit mask of EIDR04 field.
	PORT1_PCNTR2_EIDR04_Msk = 0x100000
	// Bit EIDR04.
	PORT1_PCNTR2_EIDR04 = 0x100000
	// Low input
	PORT1_PCNTR2_EIDR04_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR04_1 = 0x1
	// Position of EIDR05 field.
	PORT1_PCNTR2_EIDR05_Pos = 0x15
	// Bit mask of EIDR05 field.
	PORT1_PCNTR2_EIDR05_Msk = 0x200000
	// Bit EIDR05.
	PORT1_PCNTR2_EIDR05 = 0x200000
	// Low input
	PORT1_PCNTR2_EIDR05_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR05_1 = 0x1
	// Position of EIDR06 field.
	PORT1_PCNTR2_EIDR06_Pos = 0x16
	// Bit mask of EIDR06 field.
	PORT1_PCNTR2_EIDR06_Msk = 0x400000
	// Bit EIDR06.
	PORT1_PCNTR2_EIDR06 = 0x400000
	// Low input
	PORT1_PCNTR2_EIDR06_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR06_1 = 0x1
	// Position of EIDR07 field.
	PORT1_PCNTR2_EIDR07_Pos = 0x17
	// Bit mask of EIDR07 field.
	PORT1_PCNTR2_EIDR07_Msk = 0x800000
	// Bit EIDR07.
	PORT1_PCNTR2_EIDR07 = 0x800000
	// Low input
	PORT1_PCNTR2_EIDR07_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR07_1 = 0x1
	// Position of EIDR08 field.
	PORT1_PCNTR2_EIDR08_Pos = 0x18
	// Bit mask of EIDR08 field.
	PORT1_PCNTR2_EIDR08_Msk = 0x1000000
	// Bit EIDR08.
	PORT1_PCNTR2_EIDR08 = 0x1000000
	// Low input
	PORT1_PCNTR2_EIDR08_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR08_1 = 0x1
	// Position of EIDR09 field.
	PORT1_PCNTR2_EIDR09_Pos = 0x19
	// Bit mask of EIDR09 field.
	PORT1_PCNTR2_EIDR09_Msk = 0x2000000
	// Bit EIDR09.
	PORT1_PCNTR2_EIDR09 = 0x2000000
	// Low input
	PORT1_PCNTR2_EIDR09_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR09_1 = 0x1
	// Position of EIDR10 field.
	PORT1_PCNTR2_EIDR10_Pos = 0x1a
	// Bit mask of EIDR10 field.
	PORT1_PCNTR2_EIDR10_Msk = 0x4000000
	// Bit EIDR10.
	PORT1_PCNTR2_EIDR10 = 0x4000000
	// Low input
	PORT1_PCNTR2_EIDR10_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR10_1 = 0x1
	// Position of EIDR11 field.
	PORT1_PCNTR2_EIDR11_Pos = 0x1b
	// Bit mask of EIDR11 field.
	PORT1_PCNTR2_EIDR11_Msk = 0x8000000
	// Bit EIDR11.
	PORT1_PCNTR2_EIDR11 = 0x8000000
	// Low input
	PORT1_PCNTR2_EIDR11_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR11_1 = 0x1
	// Position of EIDR12 field.
	PORT1_PCNTR2_EIDR12_Pos = 0x1c
	// Bit mask of EIDR12 field.
	PORT1_PCNTR2_EIDR12_Msk = 0x10000000
	// Bit EIDR12.
	PORT1_PCNTR2_EIDR12 = 0x10000000
	// Low input
	PORT1_PCNTR2_EIDR12_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR12_1 = 0x1
	// Position of EIDR13 field.
	PORT1_PCNTR2_EIDR13_Pos = 0x1d
	// Bit mask of EIDR13 field.
	PORT1_PCNTR2_EIDR13_Msk = 0x20000000
	// Bit EIDR13.
	PORT1_PCNTR2_EIDR13 = 0x20000000
	// Low input
	PORT1_PCNTR2_EIDR13_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR13_1 = 0x1
	// Position of EIDR14 field.
	PORT1_PCNTR2_EIDR14_Pos = 0x1e
	// Bit mask of EIDR14 field.
	PORT1_PCNTR2_EIDR14_Msk = 0x40000000
	// Bit EIDR14.
	PORT1_PCNTR2_EIDR14 = 0x40000000
	// Low input
	PORT1_PCNTR2_EIDR14_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR14_1 = 0x1
	// Position of EIDR15 field.
	PORT1_PCNTR2_EIDR15_Pos = 0x1f
	// Bit mask of EIDR15 field.
	PORT1_PCNTR2_EIDR15_Msk = 0x80000000
	// Bit EIDR15.
	PORT1_PCNTR2_EIDR15 = 0x80000000
	// Low input
	PORT1_PCNTR2_EIDR15_0 = 0x0
	// High input
	PORT1_PCNTR2_EIDR15_1 = 0x1

	// EIDR: Port Control Register 2
	// Position of EIDR00 field.
	PORT1_EIDR_EIDR00_Pos = 0x0
	// Bit mask of EIDR00 field.
	PORT1_EIDR_EIDR00_Msk = 0x1
	// Bit EIDR00.
	PORT1_EIDR_EIDR00 = 0x1
	// Low input
	PORT1_EIDR_EIDR00_0 = 0x0
	// High input
	PORT1_EIDR_EIDR00_1 = 0x1
	// Position of EIDR01 field.
	PORT1_EIDR_EIDR01_Pos = 0x1
	// Bit mask of EIDR01 field.
	PORT1_EIDR_EIDR01_Msk = 0x2
	// Bit EIDR01.
	PORT1_EIDR_EIDR01 = 0x2
	// Low input
	PORT1_EIDR_EIDR01_0 = 0x0
	// High input
	PORT1_EIDR_EIDR01_1 = 0x1
	// Position of EIDR02 field.
	PORT1_EIDR_EIDR02_Pos = 0x2
	// Bit mask of EIDR02 field.
	PORT1_EIDR_EIDR02_Msk = 0x4
	// Bit EIDR02.
	PORT1_EIDR_EIDR02 = 0x4
	// Low input
	PORT1_EIDR_EIDR02_0 = 0x0
	// High input
	PORT1_EIDR_EIDR02_1 = 0x1
	// Position of EIDR03 field.
	PORT1_EIDR_EIDR03_Pos = 0x3
	// Bit mask of EIDR03 field.
	PORT1_EIDR_EIDR03_Msk = 0x8
	// Bit EIDR03.
	PORT1_EIDR_EIDR03 = 0x8
	// Low input
	PORT1_EIDR_EIDR03_0 = 0x0
	// High input
	PORT1_EIDR_EIDR03_1 = 0x1
	// Position of EIDR04 field.
	PORT1_EIDR_EIDR04_Pos = 0x4
	// Bit mask of EIDR04 field.
	PORT1_EIDR_EIDR04_Msk = 0x10
	// Bit EIDR04.
	PORT1_EIDR_EIDR04 = 0x10
	// Low input
	PORT1_EIDR_EIDR04_0 = 0x0
	// High input
	PORT1_EIDR_EIDR04_1 = 0x1
	// Position of EIDR05 field.
	PORT1_EIDR_EIDR05_Pos = 0x5
	// Bit mask of EIDR05 field.
	PORT1_EIDR_EIDR05_Msk = 0x20
	// Bit EIDR05.
	PORT1_EIDR_EIDR05 = 0x20
	// Low input
	PORT1_EIDR_EIDR05_0 = 0x0
	// High input
	PORT1_EIDR_EIDR05_1 = 0x1
	// Position of EIDR06 field.
	PORT1_EIDR_EIDR06_Pos = 0x6
	// Bit mask of EIDR06 field.
	PORT1_EIDR_EIDR06_Msk = 0x40
	// Bit EIDR06.
	PORT1_EIDR_EIDR06 = 0x40
	// Low input
	PORT1_EIDR_EIDR06_0 = 0x0
	// High input
	PORT1_EIDR_EIDR06_1 = 0x1
	// Position of EIDR07 field.
	PORT1_EIDR_EIDR07_Pos = 0x7
	// Bit mask of EIDR07 field.
	PORT1_EIDR_EIDR07_Msk = 0x80
	// Bit EIDR07.
	PORT1_EIDR_EIDR07 = 0x80
	// Low input
	PORT1_EIDR_EIDR07_0 = 0x0
	// High input
	PORT1_EIDR_EIDR07_1 = 0x1
	// Position of EIDR08 field.
	PORT1_EIDR_EIDR08_Pos = 0x8
	// Bit mask of EIDR08 field.
	PORT1_EIDR_EIDR08_Msk = 0x100
	// Bit EIDR08.
	PORT1_EIDR_EIDR08 = 0x100
	// Low input
	PORT1_EIDR_EIDR08_0 = 0x0
	// High input
	PORT1_EIDR_EIDR08_1 = 0x1
	// Position of EIDR09 field.
	PORT1_EIDR_EIDR09_Pos = 0x9
	// Bit mask of EIDR09 field.
	PORT1_EIDR_EIDR09_Msk = 0x200
	// Bit EIDR09.
	PORT1_EIDR_EIDR09 = 0x200
	// Low input
	PORT1_EIDR_EIDR09_0 = 0x0
	// High input
	PORT1_EIDR_EIDR09_1 = 0x1
	// Position of EIDR10 field.
	PORT1_EIDR_EIDR10_Pos = 0xa
	// Bit mask of EIDR10 field.
	PORT1_EIDR_EIDR10_Msk = 0x400
	// Bit EIDR10.
	PORT1_EIDR_EIDR10 = 0x400
	// Low input
	PORT1_EIDR_EIDR10_0 = 0x0
	// High input
	PORT1_EIDR_EIDR10_1 = 0x1
	// Position of EIDR11 field.
	PORT1_EIDR_EIDR11_Pos = 0xb
	// Bit mask of EIDR11 field.
	PORT1_EIDR_EIDR11_Msk = 0x800
	// Bit EIDR11.
	PORT1_EIDR_EIDR11 = 0x800
	// Low input
	PORT1_EIDR_EIDR11_0 = 0x0
	// High input
	PORT1_EIDR_EIDR11_1 = 0x1
	// Position of EIDR12 field.
	PORT1_EIDR_EIDR12_Pos = 0xc
	// Bit mask of EIDR12 field.
	PORT1_EIDR_EIDR12_Msk = 0x1000
	// Bit EIDR12.
	PORT1_EIDR_EIDR12 = 0x1000
	// Low input
	PORT1_EIDR_EIDR12_0 = 0x0
	// High input
	PORT1_EIDR_EIDR12_1 = 0x1
	// Position of EIDR13 field.
	PORT1_EIDR_EIDR13_Pos = 0xd
	// Bit mask of EIDR13 field.
	PORT1_EIDR_EIDR13_Msk = 0x2000
	// Bit EIDR13.
	PORT1_EIDR_EIDR13 = 0x2000
	// Low input
	PORT1_EIDR_EIDR13_0 = 0x0
	// High input
	PORT1_EIDR_EIDR13_1 = 0x1
	// Position of EIDR14 field.
	PORT1_EIDR_EIDR14_Pos = 0xe
	// Bit mask of EIDR14 field.
	PORT1_EIDR_EIDR14_Msk = 0x4000
	// Bit EIDR14.
	PORT1_EIDR_EIDR14 = 0x4000
	// Low input
	PORT1_EIDR_EIDR14_0 = 0x0
	// High input
	PORT1_EIDR_EIDR14_1 = 0x1
	// Position of EIDR15 field.
	PORT1_EIDR_EIDR15_Pos = 0xf
	// Bit mask of EIDR15 field.
	PORT1_EIDR_EIDR15_Msk = 0x8000
	// Bit EIDR15.
	PORT1_EIDR_EIDR15 = 0x8000
	// Low input
	PORT1_EIDR_EIDR15_0 = 0x0
	// High input
	PORT1_EIDR_EIDR15_1 = 0x1

	// PIDR: Port Control Register 2
	// Position of PIDR00 field.
	PORT1_PIDR_PIDR00_Pos = 0x0
	// Bit mask of PIDR00 field.
	PORT1_PIDR_PIDR00_Msk = 0x1
	// Bit PIDR00.
	PORT1_PIDR_PIDR00 = 0x1
	// Low level
	PORT1_PIDR_PIDR00_0 = 0x0
	// High level
	PORT1_PIDR_PIDR00_1 = 0x1
	// Position of PIDR01 field.
	PORT1_PIDR_PIDR01_Pos = 0x1
	// Bit mask of PIDR01 field.
	PORT1_PIDR_PIDR01_Msk = 0x2
	// Bit PIDR01.
	PORT1_PIDR_PIDR01 = 0x2
	// Low level
	PORT1_PIDR_PIDR01_0 = 0x0
	// High level
	PORT1_PIDR_PIDR01_1 = 0x1
	// Position of PIDR02 field.
	PORT1_PIDR_PIDR02_Pos = 0x2
	// Bit mask of PIDR02 field.
	PORT1_PIDR_PIDR02_Msk = 0x4
	// Bit PIDR02.
	PORT1_PIDR_PIDR02 = 0x4
	// Low level
	PORT1_PIDR_PIDR02_0 = 0x0
	// High level
	PORT1_PIDR_PIDR02_1 = 0x1
	// Position of PIDR03 field.
	PORT1_PIDR_PIDR03_Pos = 0x3
	// Bit mask of PIDR03 field.
	PORT1_PIDR_PIDR03_Msk = 0x8
	// Bit PIDR03.
	PORT1_PIDR_PIDR03 = 0x8
	// Low level
	PORT1_PIDR_PIDR03_0 = 0x0
	// High level
	PORT1_PIDR_PIDR03_1 = 0x1
	// Position of PIDR04 field.
	PORT1_PIDR_PIDR04_Pos = 0x4
	// Bit mask of PIDR04 field.
	PORT1_PIDR_PIDR04_Msk = 0x10
	// Bit PIDR04.
	PORT1_PIDR_PIDR04 = 0x10
	// Low level
	PORT1_PIDR_PIDR04_0 = 0x0
	// High level
	PORT1_PIDR_PIDR04_1 = 0x1
	// Position of PIDR05 field.
	PORT1_PIDR_PIDR05_Pos = 0x5
	// Bit mask of PIDR05 field.
	PORT1_PIDR_PIDR05_Msk = 0x20
	// Bit PIDR05.
	PORT1_PIDR_PIDR05 = 0x20
	// Low level
	PORT1_PIDR_PIDR05_0 = 0x0
	// High level
	PORT1_PIDR_PIDR05_1 = 0x1
	// Position of PIDR06 field.
	PORT1_PIDR_PIDR06_Pos = 0x6
	// Bit mask of PIDR06 field.
	PORT1_PIDR_PIDR06_Msk = 0x40
	// Bit PIDR06.
	PORT1_PIDR_PIDR06 = 0x40
	// Low level
	PORT1_PIDR_PIDR06_0 = 0x0
	// High level
	PORT1_PIDR_PIDR06_1 = 0x1
	// Position of PIDR07 field.
	PORT1_PIDR_PIDR07_Pos = 0x7
	// Bit mask of PIDR07 field.
	PORT1_PIDR_PIDR07_Msk = 0x80
	// Bit PIDR07.
	PORT1_PIDR_PIDR07 = 0x80
	// Low level
	PORT1_PIDR_PIDR07_0 = 0x0
	// High level
	PORT1_PIDR_PIDR07_1 = 0x1
	// Position of PIDR08 field.
	PORT1_PIDR_PIDR08_Pos = 0x8
	// Bit mask of PIDR08 field.
	PORT1_PIDR_PIDR08_Msk = 0x100
	// Bit PIDR08.
	PORT1_PIDR_PIDR08 = 0x100
	// Low level
	PORT1_PIDR_PIDR08_0 = 0x0
	// High level
	PORT1_PIDR_PIDR08_1 = 0x1
	// Position of PIDR09 field.
	PORT1_PIDR_PIDR09_Pos = 0x9
	// Bit mask of PIDR09 field.
	PORT1_PIDR_PIDR09_Msk = 0x200
	// Bit PIDR09.
	PORT1_PIDR_PIDR09 = 0x200
	// Low level
	PORT1_PIDR_PIDR09_0 = 0x0
	// High level
	PORT1_PIDR_PIDR09_1 = 0x1
	// Position of PIDR10 field.
	PORT1_PIDR_PIDR10_Pos = 0xa
	// Bit mask of PIDR10 field.
	PORT1_PIDR_PIDR10_Msk = 0x400
	// Bit PIDR10.
	PORT1_PIDR_PIDR10 = 0x400
	// Low level
	PORT1_PIDR_PIDR10_0 = 0x0
	// High level
	PORT1_PIDR_PIDR10_1 = 0x1
	// Position of PIDR11 field.
	PORT1_PIDR_PIDR11_Pos = 0xb
	// Bit mask of PIDR11 field.
	PORT1_PIDR_PIDR11_Msk = 0x800
	// Bit PIDR11.
	PORT1_PIDR_PIDR11 = 0x800
	// Low level
	PORT1_PIDR_PIDR11_0 = 0x0
	// High level
	PORT1_PIDR_PIDR11_1 = 0x1
	// Position of PIDR12 field.
	PORT1_PIDR_PIDR12_Pos = 0xc
	// Bit mask of PIDR12 field.
	PORT1_PIDR_PIDR12_Msk = 0x1000
	// Bit PIDR12.
	PORT1_PIDR_PIDR12 = 0x1000
	// Low level
	PORT1_PIDR_PIDR12_0 = 0x0
	// High level
	PORT1_PIDR_PIDR12_1 = 0x1
	// Position of PIDR13 field.
	PORT1_PIDR_PIDR13_Pos = 0xd
	// Bit mask of PIDR13 field.
	PORT1_PIDR_PIDR13_Msk = 0x2000
	// Bit PIDR13.
	PORT1_PIDR_PIDR13 = 0x2000
	// Low level
	PORT1_PIDR_PIDR13_0 = 0x0
	// High level
	PORT1_PIDR_PIDR13_1 = 0x1
	// Position of PIDR14 field.
	PORT1_PIDR_PIDR14_Pos = 0xe
	// Bit mask of PIDR14 field.
	PORT1_PIDR_PIDR14_Msk = 0x4000
	// Bit PIDR14.
	PORT1_PIDR_PIDR14 = 0x4000
	// Low level
	PORT1_PIDR_PIDR14_0 = 0x0
	// High level
	PORT1_PIDR_PIDR14_1 = 0x1
	// Position of PIDR15 field.
	PORT1_PIDR_PIDR15_Pos = 0xf
	// Bit mask of PIDR15 field.
	PORT1_PIDR_PIDR15_Msk = 0x8000
	// Bit PIDR15.
	PORT1_PIDR_PIDR15 = 0x8000
	// Low level
	PORT1_PIDR_PIDR15_0 = 0x0
	// High level
	PORT1_PIDR_PIDR15_1 = 0x1

	// PCNTR3: Port Control Register 3
	// Position of POSR00 field.
	PORT1_PCNTR3_POSR00_Pos = 0x0
	// Bit mask of POSR00 field.
	PORT1_PCNTR3_POSR00_Msk = 0x1
	// Bit POSR00.
	PORT1_PCNTR3_POSR00 = 0x1
	// No effect on output
	PORT1_PCNTR3_POSR00_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR00_1 = 0x1
	// Position of POSR01 field.
	PORT1_PCNTR3_POSR01_Pos = 0x1
	// Bit mask of POSR01 field.
	PORT1_PCNTR3_POSR01_Msk = 0x2
	// Bit POSR01.
	PORT1_PCNTR3_POSR01 = 0x2
	// No effect on output
	PORT1_PCNTR3_POSR01_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR01_1 = 0x1
	// Position of POSR02 field.
	PORT1_PCNTR3_POSR02_Pos = 0x2
	// Bit mask of POSR02 field.
	PORT1_PCNTR3_POSR02_Msk = 0x4
	// Bit POSR02.
	PORT1_PCNTR3_POSR02 = 0x4
	// No effect on output
	PORT1_PCNTR3_POSR02_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR02_1 = 0x1
	// Position of POSR03 field.
	PORT1_PCNTR3_POSR03_Pos = 0x3
	// Bit mask of POSR03 field.
	PORT1_PCNTR3_POSR03_Msk = 0x8
	// Bit POSR03.
	PORT1_PCNTR3_POSR03 = 0x8
	// No effect on output
	PORT1_PCNTR3_POSR03_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR03_1 = 0x1
	// Position of POSR04 field.
	PORT1_PCNTR3_POSR04_Pos = 0x4
	// Bit mask of POSR04 field.
	PORT1_PCNTR3_POSR04_Msk = 0x10
	// Bit POSR04.
	PORT1_PCNTR3_POSR04 = 0x10
	// No effect on output
	PORT1_PCNTR3_POSR04_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR04_1 = 0x1
	// Position of POSR05 field.
	PORT1_PCNTR3_POSR05_Pos = 0x5
	// Bit mask of POSR05 field.
	PORT1_PCNTR3_POSR05_Msk = 0x20
	// Bit POSR05.
	PORT1_PCNTR3_POSR05 = 0x20
	// No effect on output
	PORT1_PCNTR3_POSR05_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR05_1 = 0x1
	// Position of POSR06 field.
	PORT1_PCNTR3_POSR06_Pos = 0x6
	// Bit mask of POSR06 field.
	PORT1_PCNTR3_POSR06_Msk = 0x40
	// Bit POSR06.
	PORT1_PCNTR3_POSR06 = 0x40
	// No effect on output
	PORT1_PCNTR3_POSR06_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR06_1 = 0x1
	// Position of POSR07 field.
	PORT1_PCNTR3_POSR07_Pos = 0x7
	// Bit mask of POSR07 field.
	PORT1_PCNTR3_POSR07_Msk = 0x80
	// Bit POSR07.
	PORT1_PCNTR3_POSR07 = 0x80
	// No effect on output
	PORT1_PCNTR3_POSR07_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR07_1 = 0x1
	// Position of POSR08 field.
	PORT1_PCNTR3_POSR08_Pos = 0x8
	// Bit mask of POSR08 field.
	PORT1_PCNTR3_POSR08_Msk = 0x100
	// Bit POSR08.
	PORT1_PCNTR3_POSR08 = 0x100
	// No effect on output
	PORT1_PCNTR3_POSR08_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR08_1 = 0x1
	// Position of POSR09 field.
	PORT1_PCNTR3_POSR09_Pos = 0x9
	// Bit mask of POSR09 field.
	PORT1_PCNTR3_POSR09_Msk = 0x200
	// Bit POSR09.
	PORT1_PCNTR3_POSR09 = 0x200
	// No effect on output
	PORT1_PCNTR3_POSR09_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR09_1 = 0x1
	// Position of POSR10 field.
	PORT1_PCNTR3_POSR10_Pos = 0xa
	// Bit mask of POSR10 field.
	PORT1_PCNTR3_POSR10_Msk = 0x400
	// Bit POSR10.
	PORT1_PCNTR3_POSR10 = 0x400
	// No effect on output
	PORT1_PCNTR3_POSR10_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR10_1 = 0x1
	// Position of POSR11 field.
	PORT1_PCNTR3_POSR11_Pos = 0xb
	// Bit mask of POSR11 field.
	PORT1_PCNTR3_POSR11_Msk = 0x800
	// Bit POSR11.
	PORT1_PCNTR3_POSR11 = 0x800
	// No effect on output
	PORT1_PCNTR3_POSR11_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR11_1 = 0x1
	// Position of POSR12 field.
	PORT1_PCNTR3_POSR12_Pos = 0xc
	// Bit mask of POSR12 field.
	PORT1_PCNTR3_POSR12_Msk = 0x1000
	// Bit POSR12.
	PORT1_PCNTR3_POSR12 = 0x1000
	// No effect on output
	PORT1_PCNTR3_POSR12_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR12_1 = 0x1
	// Position of POSR13 field.
	PORT1_PCNTR3_POSR13_Pos = 0xd
	// Bit mask of POSR13 field.
	PORT1_PCNTR3_POSR13_Msk = 0x2000
	// Bit POSR13.
	PORT1_PCNTR3_POSR13 = 0x2000
	// No effect on output
	PORT1_PCNTR3_POSR13_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR13_1 = 0x1
	// Position of POSR14 field.
	PORT1_PCNTR3_POSR14_Pos = 0xe
	// Bit mask of POSR14 field.
	PORT1_PCNTR3_POSR14_Msk = 0x4000
	// Bit POSR14.
	PORT1_PCNTR3_POSR14 = 0x4000
	// No effect on output
	PORT1_PCNTR3_POSR14_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR14_1 = 0x1
	// Position of POSR15 field.
	PORT1_PCNTR3_POSR15_Pos = 0xf
	// Bit mask of POSR15 field.
	PORT1_PCNTR3_POSR15_Msk = 0x8000
	// Bit POSR15.
	PORT1_PCNTR3_POSR15 = 0x8000
	// No effect on output
	PORT1_PCNTR3_POSR15_0 = 0x0
	// High output
	PORT1_PCNTR3_POSR15_1 = 0x1
	// Position of PORR00 field.
	PORT1_PCNTR3_PORR00_Pos = 0x10
	// Bit mask of PORR00 field.
	PORT1_PCNTR3_PORR00_Msk = 0x10000
	// Bit PORR00.
	PORT1_PCNTR3_PORR00 = 0x10000
	// No effect on output
	PORT1_PCNTR3_PORR00_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR00_1 = 0x1
	// Position of PORR01 field.
	PORT1_PCNTR3_PORR01_Pos = 0x11
	// Bit mask of PORR01 field.
	PORT1_PCNTR3_PORR01_Msk = 0x20000
	// Bit PORR01.
	PORT1_PCNTR3_PORR01 = 0x20000
	// No effect on output
	PORT1_PCNTR3_PORR01_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR01_1 = 0x1
	// Position of PORR02 field.
	PORT1_PCNTR3_PORR02_Pos = 0x12
	// Bit mask of PORR02 field.
	PORT1_PCNTR3_PORR02_Msk = 0x40000
	// Bit PORR02.
	PORT1_PCNTR3_PORR02 = 0x40000
	// No effect on output
	PORT1_PCNTR3_PORR02_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR02_1 = 0x1
	// Position of PORR03 field.
	PORT1_PCNTR3_PORR03_Pos = 0x13
	// Bit mask of PORR03 field.
	PORT1_PCNTR3_PORR03_Msk = 0x80000
	// Bit PORR03.
	PORT1_PCNTR3_PORR03 = 0x80000
	// No effect on output
	PORT1_PCNTR3_PORR03_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR03_1 = 0x1
	// Position of PORR04 field.
	PORT1_PCNTR3_PORR04_Pos = 0x14
	// Bit mask of PORR04 field.
	PORT1_PCNTR3_PORR04_Msk = 0x100000
	// Bit PORR04.
	PORT1_PCNTR3_PORR04 = 0x100000
	// No effect on output
	PORT1_PCNTR3_PORR04_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR04_1 = 0x1
	// Position of PORR05 field.
	PORT1_PCNTR3_PORR05_Pos = 0x15
	// Bit mask of PORR05 field.
	PORT1_PCNTR3_PORR05_Msk = 0x200000
	// Bit PORR05.
	PORT1_PCNTR3_PORR05 = 0x200000
	// No effect on output
	PORT1_PCNTR3_PORR05_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR05_1 = 0x1
	// Position of PORR06 field.
	PORT1_PCNTR3_PORR06_Pos = 0x16
	// Bit mask of PORR06 field.
	PORT1_PCNTR3_PORR06_Msk = 0x400000
	// Bit PORR06.
	PORT1_PCNTR3_PORR06 = 0x400000
	// No effect on output
	PORT1_PCNTR3_PORR06_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR06_1 = 0x1
	// Position of PORR07 field.
	PORT1_PCNTR3_PORR07_Pos = 0x17
	// Bit mask of PORR07 field.
	PORT1_PCNTR3_PORR07_Msk = 0x800000
	// Bit PORR07.
	PORT1_PCNTR3_PORR07 = 0x800000
	// No effect on output
	PORT1_PCNTR3_PORR07_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR07_1 = 0x1
	// Position of PORR08 field.
	PORT1_PCNTR3_PORR08_Pos = 0x18
	// Bit mask of PORR08 field.
	PORT1_PCNTR3_PORR08_Msk = 0x1000000
	// Bit PORR08.
	PORT1_PCNTR3_PORR08 = 0x1000000
	// No effect on output
	PORT1_PCNTR3_PORR08_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR08_1 = 0x1
	// Position of PORR09 field.
	PORT1_PCNTR3_PORR09_Pos = 0x19
	// Bit mask of PORR09 field.
	PORT1_PCNTR3_PORR09_Msk = 0x2000000
	// Bit PORR09.
	PORT1_PCNTR3_PORR09 = 0x2000000
	// No effect on output
	PORT1_PCNTR3_PORR09_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR09_1 = 0x1
	// Position of PORR10 field.
	PORT1_PCNTR3_PORR10_Pos = 0x1a
	// Bit mask of PORR10 field.
	PORT1_PCNTR3_PORR10_Msk = 0x4000000
	// Bit PORR10.
	PORT1_PCNTR3_PORR10 = 0x4000000
	// No effect on output
	PORT1_PCNTR3_PORR10_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR10_1 = 0x1
	// Position of PORR11 field.
	PORT1_PCNTR3_PORR11_Pos = 0x1b
	// Bit mask of PORR11 field.
	PORT1_PCNTR3_PORR11_Msk = 0x8000000
	// Bit PORR11.
	PORT1_PCNTR3_PORR11 = 0x8000000
	// No effect on output
	PORT1_PCNTR3_PORR11_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR11_1 = 0x1
	// Position of PORR12 field.
	PORT1_PCNTR3_PORR12_Pos = 0x1c
	// Bit mask of PORR12 field.
	PORT1_PCNTR3_PORR12_Msk = 0x10000000
	// Bit PORR12.
	PORT1_PCNTR3_PORR12 = 0x10000000
	// No effect on output
	PORT1_PCNTR3_PORR12_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR12_1 = 0x1
	// Position of PORR13 field.
	PORT1_PCNTR3_PORR13_Pos = 0x1d
	// Bit mask of PORR13 field.
	PORT1_PCNTR3_PORR13_Msk = 0x20000000
	// Bit PORR13.
	PORT1_PCNTR3_PORR13 = 0x20000000
	// No effect on output
	PORT1_PCNTR3_PORR13_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR13_1 = 0x1
	// Position of PORR14 field.
	PORT1_PCNTR3_PORR14_Pos = 0x1e
	// Bit mask of PORR14 field.
	PORT1_PCNTR3_PORR14_Msk = 0x40000000
	// Bit PORR14.
	PORT1_PCNTR3_PORR14 = 0x40000000
	// No effect on output
	PORT1_PCNTR3_PORR14_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR14_1 = 0x1
	// Position of PORR15 field.
	PORT1_PCNTR3_PORR15_Pos = 0x1f
	// Bit mask of PORR15 field.
	PORT1_PCNTR3_PORR15_Msk = 0x80000000
	// Bit PORR15.
	PORT1_PCNTR3_PORR15 = 0x80000000
	// No effect on output
	PORT1_PCNTR3_PORR15_0 = 0x0
	// Low output
	PORT1_PCNTR3_PORR15_1 = 0x1

	// PORR: Port Control Register 3
	// Position of PORR00 field.
	PORT1_PORR_PORR00_Pos = 0x0
	// Bit mask of PORR00 field.
	PORT1_PORR_PORR00_Msk = 0x1
	// Bit PORR00.
	PORT1_PORR_PORR00 = 0x1
	// No effect on output
	PORT1_PORR_PORR00_0 = 0x0
	// Low output
	PORT1_PORR_PORR00_1 = 0x1
	// Position of PORR01 field.
	PORT1_PORR_PORR01_Pos = 0x1
	// Bit mask of PORR01 field.
	PORT1_PORR_PORR01_Msk = 0x2
	// Bit PORR01.
	PORT1_PORR_PORR01 = 0x2
	// No effect on output
	PORT1_PORR_PORR01_0 = 0x0
	// Low output
	PORT1_PORR_PORR01_1 = 0x1
	// Position of PORR02 field.
	PORT1_PORR_PORR02_Pos = 0x2
	// Bit mask of PORR02 field.
	PORT1_PORR_PORR02_Msk = 0x4
	// Bit PORR02.
	PORT1_PORR_PORR02 = 0x4
	// No effect on output
	PORT1_PORR_PORR02_0 = 0x0
	// Low output
	PORT1_PORR_PORR02_1 = 0x1
	// Position of PORR03 field.
	PORT1_PORR_PORR03_Pos = 0x3
	// Bit mask of PORR03 field.
	PORT1_PORR_PORR03_Msk = 0x8
	// Bit PORR03.
	PORT1_PORR_PORR03 = 0x8
	// No effect on output
	PORT1_PORR_PORR03_0 = 0x0
	// Low output
	PORT1_PORR_PORR03_1 = 0x1
	// Position of PORR04 field.
	PORT1_PORR_PORR04_Pos = 0x4
	// Bit mask of PORR04 field.
	PORT1_PORR_PORR04_Msk = 0x10
	// Bit PORR04.
	PORT1_PORR_PORR04 = 0x10
	// No effect on output
	PORT1_PORR_PORR04_0 = 0x0
	// Low output
	PORT1_PORR_PORR04_1 = 0x1
	// Position of PORR05 field.
	PORT1_PORR_PORR05_Pos = 0x5
	// Bit mask of PORR05 field.
	PORT1_PORR_PORR05_Msk = 0x20
	// Bit PORR05.
	PORT1_PORR_PORR05 = 0x20
	// No effect on output
	PORT1_PORR_PORR05_0 = 0x0
	// Low output
	PORT1_PORR_PORR05_1 = 0x1
	// Position of PORR06 field.
	PORT1_PORR_PORR06_Pos = 0x6
	// Bit mask of PORR06 field.
	PORT1_PORR_PORR06_Msk = 0x40
	// Bit PORR06.
	PORT1_PORR_PORR06 = 0x40
	// No effect on output
	PORT1_PORR_PORR06_0 = 0x0
	// Low output
	PORT1_PORR_PORR06_1 = 0x1
	// Position of PORR07 field.
	PORT1_PORR_PORR07_Pos = 0x7
	// Bit mask of PORR07 field.
	PORT1_PORR_PORR07_Msk = 0x80
	// Bit PORR07.
	PORT1_PORR_PORR07 = 0x80
	// No effect on output
	PORT1_PORR_PORR07_0 = 0x0
	// Low output
	PORT1_PORR_PORR07_1 = 0x1
	// Position of PORR08 field.
	PORT1_PORR_PORR08_Pos = 0x8
	// Bit mask of PORR08 field.
	PORT1_PORR_PORR08_Msk = 0x100
	// Bit PORR08.
	PORT1_PORR_PORR08 = 0x100
	// No effect on output
	PORT1_PORR_PORR08_0 = 0x0
	// Low output
	PORT1_PORR_PORR08_1 = 0x1
	// Position of PORR09 field.
	PORT1_PORR_PORR09_Pos = 0x9
	// Bit mask of PORR09 field.
	PORT1_PORR_PORR09_Msk = 0x200
	// Bit PORR09.
	PORT1_PORR_PORR09 = 0x200
	// No effect on output
	PORT1_PORR_PORR09_0 = 0x0
	// Low output
	PORT1_PORR_PORR09_1 = 0x1
	// Position of PORR10 field.
	PORT1_PORR_PORR10_Pos = 0xa
	// Bit mask of PORR10 field.
	PORT1_PORR_PORR10_Msk = 0x400
	// Bit PORR10.
	PORT1_PORR_PORR10 = 0x400
	// No effect on output
	PORT1_PORR_PORR10_0 = 0x0
	// Low output
	PORT1_PORR_PORR10_1 = 0x1
	// Position of PORR11 field.
	PORT1_PORR_PORR11_Pos = 0xb
	// Bit mask of PORR11 field.
	PORT1_PORR_PORR11_Msk = 0x800
	// Bit PORR11.
	PORT1_PORR_PORR11 = 0x800
	// No effect on output
	PORT1_PORR_PORR11_0 = 0x0
	// Low output
	PORT1_PORR_PORR11_1 = 0x1
	// Position of PORR12 field.
	PORT1_PORR_PORR12_Pos = 0xc
	// Bit mask of PORR12 field.
	PORT1_PORR_PORR12_Msk = 0x1000
	// Bit PORR12.
	PORT1_PORR_PORR12 = 0x1000
	// No effect on output
	PORT1_PORR_PORR12_0 = 0x0
	// Low output
	PORT1_PORR_PORR12_1 = 0x1
	// Position of PORR13 field.
	PORT1_PORR_PORR13_Pos = 0xd
	// Bit mask of PORR13 field.
	PORT1_PORR_PORR13_Msk = 0x2000
	// Bit PORR13.
	PORT1_PORR_PORR13 = 0x2000
	// No effect on output
	PORT1_PORR_PORR13_0 = 0x0
	// Low output
	PORT1_PORR_PORR13_1 = 0x1
	// Position of PORR14 field.
	PORT1_PORR_PORR14_Pos = 0xe
	// Bit mask of PORR14 field.
	PORT1_PORR_PORR14_Msk = 0x4000
	// Bit PORR14.
	PORT1_PORR_PORR14 = 0x4000
	// No effect on output
	PORT1_PORR_PORR14_0 = 0x0
	// Low output
	PORT1_PORR_PORR14_1 = 0x1
	// Position of PORR15 field.
	PORT1_PORR_PORR15_Pos = 0xf
	// Bit mask of PORR15 field.
	PORT1_PORR_PORR15_Msk = 0x8000
	// Bit PORR15.
	PORT1_PORR_PORR15 = 0x8000
	// No effect on output
	PORT1_PORR_PORR15_0 = 0x0
	// Low output
	PORT1_PORR_PORR15_1 = 0x1

	// POSR: Port Control Register 3
	// Position of POSR00 field.
	PORT1_POSR_POSR00_Pos = 0x0
	// Bit mask of POSR00 field.
	PORT1_POSR_POSR00_Msk = 0x1
	// Bit POSR00.
	PORT1_POSR_POSR00 = 0x1
	// No effect on output
	PORT1_POSR_POSR00_0 = 0x0
	// High output
	PORT1_POSR_POSR00_1 = 0x1
	// Position of POSR01 field.
	PORT1_POSR_POSR01_Pos = 0x1
	// Bit mask of POSR01 field.
	PORT1_POSR_POSR01_Msk = 0x2
	// Bit POSR01.
	PORT1_POSR_POSR01 = 0x2
	// No effect on output
	PORT1_POSR_POSR01_0 = 0x0
	// High output
	PORT1_POSR_POSR01_1 = 0x1
	// Position of POSR02 field.
	PORT1_POSR_POSR02_Pos = 0x2
	// Bit mask of POSR02 field.
	PORT1_POSR_POSR02_Msk = 0x4
	// Bit POSR02.
	PORT1_POSR_POSR02 = 0x4
	// No effect on output
	PORT1_POSR_POSR02_0 = 0x0
	// High output
	PORT1_POSR_POSR02_1 = 0x1
	// Position of POSR03 field.
	PORT1_POSR_POSR03_Pos = 0x3
	// Bit mask of POSR03 field.
	PORT1_POSR_POSR03_Msk = 0x8
	// Bit POSR03.
	PORT1_POSR_POSR03 = 0x8
	// No effect on output
	PORT1_POSR_POSR03_0 = 0x0
	// High output
	PORT1_POSR_POSR03_1 = 0x1
	// Position of POSR04 field.
	PORT1_POSR_POSR04_Pos = 0x4
	// Bit mask of POSR04 field.
	PORT1_POSR_POSR04_Msk = 0x10
	// Bit POSR04.
	PORT1_POSR_POSR04 = 0x10
	// No effect on output
	PORT1_POSR_POSR04_0 = 0x0
	// High output
	PORT1_POSR_POSR04_1 = 0x1
	// Position of POSR05 field.
	PORT1_POSR_POSR05_Pos = 0x5
	// Bit mask of POSR05 field.
	PORT1_POSR_POSR05_Msk = 0x20
	// Bit POSR05.
	PORT1_POSR_POSR05 = 0x20
	// No effect on output
	PORT1_POSR_POSR05_0 = 0x0
	// High output
	PORT1_POSR_POSR05_1 = 0x1
	// Position of POSR06 field.
	PORT1_POSR_POSR06_Pos = 0x6
	// Bit mask of POSR06 field.
	PORT1_POSR_POSR06_Msk = 0x40
	// Bit POSR06.
	PORT1_POSR_POSR06 = 0x40
	// No effect on output
	PORT1_POSR_POSR06_0 = 0x0
	// High output
	PORT1_POSR_POSR06_1 = 0x1
	// Position of POSR07 field.
	PORT1_POSR_POSR07_Pos = 0x7
	// Bit mask of POSR07 field.
	PORT1_POSR_POSR07_Msk = 0x80
	// Bit POSR07.
	PORT1_POSR_POSR07 = 0x80
	// No effect on output
	PORT1_POSR_POSR07_0 = 0x0
	// High output
	PORT1_POSR_POSR07_1 = 0x1
	// Position of POSR08 field.
	PORT1_POSR_POSR08_Pos = 0x8
	// Bit mask of POSR08 field.
	PORT1_POSR_POSR08_Msk = 0x100
	// Bit POSR08.
	PORT1_POSR_POSR08 = 0x100
	// No effect on output
	PORT1_POSR_POSR08_0 = 0x0
	// High output
	PORT1_POSR_POSR08_1 = 0x1
	// Position of POSR09 field.
	PORT1_POSR_POSR09_Pos = 0x9
	// Bit mask of POSR09 field.
	PORT1_POSR_POSR09_Msk = 0x200
	// Bit POSR09.
	PORT1_POSR_POSR09 = 0x200
	// No effect on output
	PORT1_POSR_POSR09_0 = 0x0
	// High output
	PORT1_POSR_POSR09_1 = 0x1
	// Position of POSR10 field.
	PORT1_POSR_POSR10_Pos = 0xa
	// Bit mask of POSR10 field.
	PORT1_POSR_POSR10_Msk = 0x400
	// Bit POSR10.
	PORT1_POSR_POSR10 = 0x400
	// No effect on output
	PORT1_POSR_POSR10_0 = 0x0
	// High output
	PORT1_POSR_POSR10_1 = 0x1
	// Position of POSR11 field.
	PORT1_POSR_POSR11_Pos = 0xb
	// Bit mask of POSR11 field.
	PORT1_POSR_POSR11_Msk = 0x800
	// Bit POSR11.
	PORT1_POSR_POSR11 = 0x800
	// No effect on output
	PORT1_POSR_POSR11_0 = 0x0
	// High output
	PORT1_POSR_POSR11_1 = 0x1
	// Position of POSR12 field.
	PORT1_POSR_POSR12_Pos = 0xc
	// Bit mask of POSR12 field.
	PORT1_POSR_POSR12_Msk = 0x1000
	// Bit POSR12.
	PORT1_POSR_POSR12 = 0x1000
	// No effect on output
	PORT1_POSR_POSR12_0 = 0x0
	// High output
	PORT1_POSR_POSR12_1 = 0x1
	// Position of POSR13 field.
	PORT1_POSR_POSR13_Pos = 0xd
	// Bit mask of POSR13 field.
	PORT1_POSR_POSR13_Msk = 0x2000
	// Bit POSR13.
	PORT1_POSR_POSR13 = 0x2000
	// No effect on output
	PORT1_POSR_POSR13_0 = 0x0
	// High output
	PORT1_POSR_POSR13_1 = 0x1
	// Position of POSR14 field.
	PORT1_POSR_POSR14_Pos = 0xe
	// Bit mask of POSR14 field.
	PORT1_POSR_POSR14_Msk = 0x4000
	// Bit POSR14.
	PORT1_POSR_POSR14 = 0x4000
	// No effect on output
	PORT1_POSR_POSR14_0 = 0x0
	// High output
	PORT1_POSR_POSR14_1 = 0x1
	// Position of POSR15 field.
	PORT1_POSR_POSR15_Pos = 0xf
	// Bit mask of POSR15 field.
	PORT1_POSR_POSR15_Msk = 0x8000
	// Bit POSR15.
	PORT1_POSR_POSR15 = 0x8000
	// No effect on output
	PORT1_POSR_POSR15_0 = 0x0
	// High output
	PORT1_POSR_POSR15_1 = 0x1

	// PCNTR4: Port Control Register 4
	// Position of EOSR00 field.
	PORT1_PCNTR4_EOSR00_Pos = 0x0
	// Bit mask of EOSR00 field.
	PORT1_PCNTR4_EOSR00_Msk = 0x1
	// Bit EOSR00.
	PORT1_PCNTR4_EOSR00 = 0x1
	// No effect on output
	PORT1_PCNTR4_EOSR00_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR00_1 = 0x1
	// Position of EOSR01 field.
	PORT1_PCNTR4_EOSR01_Pos = 0x1
	// Bit mask of EOSR01 field.
	PORT1_PCNTR4_EOSR01_Msk = 0x2
	// Bit EOSR01.
	PORT1_PCNTR4_EOSR01 = 0x2
	// No effect on output
	PORT1_PCNTR4_EOSR01_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR01_1 = 0x1
	// Position of EOSR02 field.
	PORT1_PCNTR4_EOSR02_Pos = 0x2
	// Bit mask of EOSR02 field.
	PORT1_PCNTR4_EOSR02_Msk = 0x4
	// Bit EOSR02.
	PORT1_PCNTR4_EOSR02 = 0x4
	// No effect on output
	PORT1_PCNTR4_EOSR02_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR02_1 = 0x1
	// Position of EOSR03 field.
	PORT1_PCNTR4_EOSR03_Pos = 0x3
	// Bit mask of EOSR03 field.
	PORT1_PCNTR4_EOSR03_Msk = 0x8
	// Bit EOSR03.
	PORT1_PCNTR4_EOSR03 = 0x8
	// No effect on output
	PORT1_PCNTR4_EOSR03_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR03_1 = 0x1
	// Position of EOSR04 field.
	PORT1_PCNTR4_EOSR04_Pos = 0x4
	// Bit mask of EOSR04 field.
	PORT1_PCNTR4_EOSR04_Msk = 0x10
	// Bit EOSR04.
	PORT1_PCNTR4_EOSR04 = 0x10
	// No effect on output
	PORT1_PCNTR4_EOSR04_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR04_1 = 0x1
	// Position of EOSR05 field.
	PORT1_PCNTR4_EOSR05_Pos = 0x5
	// Bit mask of EOSR05 field.
	PORT1_PCNTR4_EOSR05_Msk = 0x20
	// Bit EOSR05.
	PORT1_PCNTR4_EOSR05 = 0x20
	// No effect on output
	PORT1_PCNTR4_EOSR05_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR05_1 = 0x1
	// Position of EOSR06 field.
	PORT1_PCNTR4_EOSR06_Pos = 0x6
	// Bit mask of EOSR06 field.
	PORT1_PCNTR4_EOSR06_Msk = 0x40
	// Bit EOSR06.
	PORT1_PCNTR4_EOSR06 = 0x40
	// No effect on output
	PORT1_PCNTR4_EOSR06_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR06_1 = 0x1
	// Position of EOSR07 field.
	PORT1_PCNTR4_EOSR07_Pos = 0x7
	// Bit mask of EOSR07 field.
	PORT1_PCNTR4_EOSR07_Msk = 0x80
	// Bit EOSR07.
	PORT1_PCNTR4_EOSR07 = 0x80
	// No effect on output
	PORT1_PCNTR4_EOSR07_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR07_1 = 0x1
	// Position of EOSR08 field.
	PORT1_PCNTR4_EOSR08_Pos = 0x8
	// Bit mask of EOSR08 field.
	PORT1_PCNTR4_EOSR08_Msk = 0x100
	// Bit EOSR08.
	PORT1_PCNTR4_EOSR08 = 0x100
	// No effect on output
	PORT1_PCNTR4_EOSR08_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR08_1 = 0x1
	// Position of EOSR09 field.
	PORT1_PCNTR4_EOSR09_Pos = 0x9
	// Bit mask of EOSR09 field.
	PORT1_PCNTR4_EOSR09_Msk = 0x200
	// Bit EOSR09.
	PORT1_PCNTR4_EOSR09 = 0x200
	// No effect on output
	PORT1_PCNTR4_EOSR09_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR09_1 = 0x1
	// Position of EOSR10 field.
	PORT1_PCNTR4_EOSR10_Pos = 0xa
	// Bit mask of EOSR10 field.
	PORT1_PCNTR4_EOSR10_Msk = 0x400
	// Bit EOSR10.
	PORT1_PCNTR4_EOSR10 = 0x400
	// No effect on output
	PORT1_PCNTR4_EOSR10_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR10_1 = 0x1
	// Position of EOSR11 field.
	PORT1_PCNTR4_EOSR11_Pos = 0xb
	// Bit mask of EOSR11 field.
	PORT1_PCNTR4_EOSR11_Msk = 0x800
	// Bit EOSR11.
	PORT1_PCNTR4_EOSR11 = 0x800
	// No effect on output
	PORT1_PCNTR4_EOSR11_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR11_1 = 0x1
	// Position of EOSR12 field.
	PORT1_PCNTR4_EOSR12_Pos = 0xc
	// Bit mask of EOSR12 field.
	PORT1_PCNTR4_EOSR12_Msk = 0x1000
	// Bit EOSR12.
	PORT1_PCNTR4_EOSR12 = 0x1000
	// No effect on output
	PORT1_PCNTR4_EOSR12_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR12_1 = 0x1
	// Position of EOSR13 field.
	PORT1_PCNTR4_EOSR13_Pos = 0xd
	// Bit mask of EOSR13 field.
	PORT1_PCNTR4_EOSR13_Msk = 0x2000
	// Bit EOSR13.
	PORT1_PCNTR4_EOSR13 = 0x2000
	// No effect on output
	PORT1_PCNTR4_EOSR13_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR13_1 = 0x1
	// Position of EOSR14 field.
	PORT1_PCNTR4_EOSR14_Pos = 0xe
	// Bit mask of EOSR14 field.
	PORT1_PCNTR4_EOSR14_Msk = 0x4000
	// Bit EOSR14.
	PORT1_PCNTR4_EOSR14 = 0x4000
	// No effect on output
	PORT1_PCNTR4_EOSR14_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR14_1 = 0x1
	// Position of EOSR15 field.
	PORT1_PCNTR4_EOSR15_Pos = 0xf
	// Bit mask of EOSR15 field.
	PORT1_PCNTR4_EOSR15_Msk = 0x8000
	// Bit EOSR15.
	PORT1_PCNTR4_EOSR15 = 0x8000
	// No effect on output
	PORT1_PCNTR4_EOSR15_0 = 0x0
	// High output
	PORT1_PCNTR4_EOSR15_1 = 0x1
	// Position of EORR00 field.
	PORT1_PCNTR4_EORR00_Pos = 0x10
	// Bit mask of EORR00 field.
	PORT1_PCNTR4_EORR00_Msk = 0x10000
	// Bit EORR00.
	PORT1_PCNTR4_EORR00 = 0x10000
	// No effect on output
	PORT1_PCNTR4_EORR00_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR00_1 = 0x1
	// Position of EORR01 field.
	PORT1_PCNTR4_EORR01_Pos = 0x11
	// Bit mask of EORR01 field.
	PORT1_PCNTR4_EORR01_Msk = 0x20000
	// Bit EORR01.
	PORT1_PCNTR4_EORR01 = 0x20000
	// No effect on output
	PORT1_PCNTR4_EORR01_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR01_1 = 0x1
	// Position of EORR02 field.
	PORT1_PCNTR4_EORR02_Pos = 0x12
	// Bit mask of EORR02 field.
	PORT1_PCNTR4_EORR02_Msk = 0x40000
	// Bit EORR02.
	PORT1_PCNTR4_EORR02 = 0x40000
	// No effect on output
	PORT1_PCNTR4_EORR02_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR02_1 = 0x1
	// Position of EORR03 field.
	PORT1_PCNTR4_EORR03_Pos = 0x13
	// Bit mask of EORR03 field.
	PORT1_PCNTR4_EORR03_Msk = 0x80000
	// Bit EORR03.
	PORT1_PCNTR4_EORR03 = 0x80000
	// No effect on output
	PORT1_PCNTR4_EORR03_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR03_1 = 0x1
	// Position of EORR04 field.
	PORT1_PCNTR4_EORR04_Pos = 0x14
	// Bit mask of EORR04 field.
	PORT1_PCNTR4_EORR04_Msk = 0x100000
	// Bit EORR04.
	PORT1_PCNTR4_EORR04 = 0x100000
	// No effect on output
	PORT1_PCNTR4_EORR04_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR04_1 = 0x1
	// Position of EORR05 field.
	PORT1_PCNTR4_EORR05_Pos = 0x15
	// Bit mask of EORR05 field.
	PORT1_PCNTR4_EORR05_Msk = 0x200000
	// Bit EORR05.
	PORT1_PCNTR4_EORR05 = 0x200000
	// No effect on output
	PORT1_PCNTR4_EORR05_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR05_1 = 0x1
	// Position of EORR06 field.
	PORT1_PCNTR4_EORR06_Pos = 0x16
	// Bit mask of EORR06 field.
	PORT1_PCNTR4_EORR06_Msk = 0x400000
	// Bit EORR06.
	PORT1_PCNTR4_EORR06 = 0x400000
	// No effect on output
	PORT1_PCNTR4_EORR06_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR06_1 = 0x1
	// Position of EORR07 field.
	PORT1_PCNTR4_EORR07_Pos = 0x17
	// Bit mask of EORR07 field.
	PORT1_PCNTR4_EORR07_Msk = 0x800000
	// Bit EORR07.
	PORT1_PCNTR4_EORR07 = 0x800000
	// No effect on output
	PORT1_PCNTR4_EORR07_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR07_1 = 0x1
	// Position of EORR08 field.
	PORT1_PCNTR4_EORR08_Pos = 0x18
	// Bit mask of EORR08 field.
	PORT1_PCNTR4_EORR08_Msk = 0x1000000
	// Bit EORR08.
	PORT1_PCNTR4_EORR08 = 0x1000000
	// No effect on output
	PORT1_PCNTR4_EORR08_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR08_1 = 0x1
	// Position of EORR09 field.
	PORT1_PCNTR4_EORR09_Pos = 0x19
	// Bit mask of EORR09 field.
	PORT1_PCNTR4_EORR09_Msk = 0x2000000
	// Bit EORR09.
	PORT1_PCNTR4_EORR09 = 0x2000000
	// No effect on output
	PORT1_PCNTR4_EORR09_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR09_1 = 0x1
	// Position of EORR10 field.
	PORT1_PCNTR4_EORR10_Pos = 0x1a
	// Bit mask of EORR10 field.
	PORT1_PCNTR4_EORR10_Msk = 0x4000000
	// Bit EORR10.
	PORT1_PCNTR4_EORR10 = 0x4000000
	// No effect on output
	PORT1_PCNTR4_EORR10_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR10_1 = 0x1
	// Position of EORR11 field.
	PORT1_PCNTR4_EORR11_Pos = 0x1b
	// Bit mask of EORR11 field.
	PORT1_PCNTR4_EORR11_Msk = 0x8000000
	// Bit EORR11.
	PORT1_PCNTR4_EORR11 = 0x8000000
	// No effect on output
	PORT1_PCNTR4_EORR11_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR11_1 = 0x1
	// Position of EORR12 field.
	PORT1_PCNTR4_EORR12_Pos = 0x1c
	// Bit mask of EORR12 field.
	PORT1_PCNTR4_EORR12_Msk = 0x10000000
	// Bit EORR12.
	PORT1_PCNTR4_EORR12 = 0x10000000
	// No effect on output
	PORT1_PCNTR4_EORR12_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR12_1 = 0x1
	// Position of EORR13 field.
	PORT1_PCNTR4_EORR13_Pos = 0x1d
	// Bit mask of EORR13 field.
	PORT1_PCNTR4_EORR13_Msk = 0x20000000
	// Bit EORR13.
	PORT1_PCNTR4_EORR13 = 0x20000000
	// No effect on output
	PORT1_PCNTR4_EORR13_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR13_1 = 0x1
	// Position of EORR14 field.
	PORT1_PCNTR4_EORR14_Pos = 0x1e
	// Bit mask of EORR14 field.
	PORT1_PCNTR4_EORR14_Msk = 0x40000000
	// Bit EORR14.
	PORT1_PCNTR4_EORR14 = 0x40000000
	// No effect on output
	PORT1_PCNTR4_EORR14_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR14_1 = 0x1
	// Position of EORR15 field.
	PORT1_PCNTR4_EORR15_Pos = 0x1f
	// Bit mask of EORR15 field.
	PORT1_PCNTR4_EORR15_Msk = 0x80000000
	// Bit EORR15.
	PORT1_PCNTR4_EORR15 = 0x80000000
	// No effect on output
	PORT1_PCNTR4_EORR15_0 = 0x0
	// Low output
	PORT1_PCNTR4_EORR15_1 = 0x1

	// EORR: Port Control Register 4
	// Position of EORR00 field.
	PORT1_EORR_EORR00_Pos = 0x0
	// Bit mask of EORR00 field.
	PORT1_EORR_EORR00_Msk = 0x1
	// Bit EORR00.
	PORT1_EORR_EORR00 = 0x1
	// No effect on output
	PORT1_EORR_EORR00_0 = 0x0
	// Low output
	PORT1_EORR_EORR00_1 = 0x1
	// Position of EORR01 field.
	PORT1_EORR_EORR01_Pos = 0x1
	// Bit mask of EORR01 field.
	PORT1_EORR_EORR01_Msk = 0x2
	// Bit EORR01.
	PORT1_EORR_EORR01 = 0x2
	// No effect on output
	PORT1_EORR_EORR01_0 = 0x0
	// Low output
	PORT1_EORR_EORR01_1 = 0x1
	// Position of EORR02 field.
	PORT1_EORR_EORR02_Pos = 0x2
	// Bit mask of EORR02 field.
	PORT1_EORR_EORR02_Msk = 0x4
	// Bit EORR02.
	PORT1_EORR_EORR02 = 0x4
	// No effect on output
	PORT1_EORR_EORR02_0 = 0x0
	// Low output
	PORT1_EORR_EORR02_1 = 0x1
	// Position of EORR03 field.
	PORT1_EORR_EORR03_Pos = 0x3
	// Bit mask of EORR03 field.
	PORT1_EORR_EORR03_Msk = 0x8
	// Bit EORR03.
	PORT1_EORR_EORR03 = 0x8
	// No effect on output
	PORT1_EORR_EORR03_0 = 0x0
	// Low output
	PORT1_EORR_EORR03_1 = 0x1
	// Position of EORR04 field.
	PORT1_EORR_EORR04_Pos = 0x4
	// Bit mask of EORR04 field.
	PORT1_EORR_EORR04_Msk = 0x10
	// Bit EORR04.
	PORT1_EORR_EORR04 = 0x10
	// No effect on output
	PORT1_EORR_EORR04_0 = 0x0
	// Low output
	PORT1_EORR_EORR04_1 = 0x1
	// Position of EORR05 field.
	PORT1_EORR_EORR05_Pos = 0x5
	// Bit mask of EORR05 field.
	PORT1_EORR_EORR05_Msk = 0x20
	// Bit EORR05.
	PORT1_EORR_EORR05 = 0x20
	// No effect on output
	PORT1_EORR_EORR05_0 = 0x0
	// Low output
	PORT1_EORR_EORR05_1 = 0x1
	// Position of EORR06 field.
	PORT1_EORR_EORR06_Pos = 0x6
	// Bit mask of EORR06 field.
	PORT1_EORR_EORR06_Msk = 0x40
	// Bit EORR06.
	PORT1_EORR_EORR06 = 0x40
	// No effect on output
	PORT1_EORR_EORR06_0 = 0x0
	// Low output
	PORT1_EORR_EORR06_1 = 0x1
	// Position of EORR07 field.
	PORT1_EORR_EORR07_Pos = 0x7
	// Bit mask of EORR07 field.
	PORT1_EORR_EORR07_Msk = 0x80
	// Bit EORR07.
	PORT1_EORR_EORR07 = 0x80
	// No effect on output
	PORT1_EORR_EORR07_0 = 0x0
	// Low output
	PORT1_EORR_EORR07_1 = 0x1
	// Position of EORR08 field.
	PORT1_EORR_EORR08_Pos = 0x8
	// Bit mask of EORR08 field.
	PORT1_EORR_EORR08_Msk = 0x100
	// Bit EORR08.
	PORT1_EORR_EORR08 = 0x100
	// No effect on output
	PORT1_EORR_EORR08_0 = 0x0
	// Low output
	PORT1_EORR_EORR08_1 = 0x1
	// Position of EORR09 field.
	PORT1_EORR_EORR09_Pos = 0x9
	// Bit mask of EORR09 field.
	PORT1_EORR_EORR09_Msk = 0x200
	// Bit EORR09.
	PORT1_EORR_EORR09 = 0x200
	// No effect on output
	PORT1_EORR_EORR09_0 = 0x0
	// Low output
	PORT1_EORR_EORR09_1 = 0x1
	// Position of EORR10 field.
	PORT1_EORR_EORR10_Pos = 0xa
	// Bit mask of EORR10 field.
	PORT1_EORR_EORR10_Msk = 0x400
	// Bit EORR10.
	PORT1_EORR_EORR10 = 0x400
	// No effect on output
	PORT1_EORR_EORR10_0 = 0x0
	// Low output
	PORT1_EORR_EORR10_1 = 0x1
	// Position of EORR11 field.
	PORT1_EORR_EORR11_Pos = 0xb
	// Bit mask of EORR11 field.
	PORT1_EORR_EORR11_Msk = 0x800
	// Bit EORR11.
	PORT1_EORR_EORR11 = 0x800
	// No effect on output
	PORT1_EORR_EORR11_0 = 0x0
	// Low output
	PORT1_EORR_EORR11_1 = 0x1
	// Position of EORR12 field.
	PORT1_EORR_EORR12_Pos = 0xc
	// Bit mask of EORR12 field.
	PORT1_EORR_EORR12_Msk = 0x1000
	// Bit EORR12.
	PORT1_EORR_EORR12 = 0x1000
	// No effect on output
	PORT1_EORR_EORR12_0 = 0x0
	// Low output
	PORT1_EORR_EORR12_1 = 0x1
	// Position of EORR13 field.
	PORT1_EORR_EORR13_Pos = 0xd
	// Bit mask of EORR13 field.
	PORT1_EORR_EORR13_Msk = 0x2000
	// Bit EORR13.
	PORT1_EORR_EORR13 = 0x2000
	// No effect on output
	PORT1_EORR_EORR13_0 = 0x0
	// Low output
	PORT1_EORR_EORR13_1 = 0x1
	// Position of EORR14 field.
	PORT1_EORR_EORR14_Pos = 0xe
	// Bit mask of EORR14 field.
	PORT1_EORR_EORR14_Msk = 0x4000
	// Bit EORR14.
	PORT1_EORR_EORR14 = 0x4000
	// No effect on output
	PORT1_EORR_EORR14_0 = 0x0
	// Low output
	PORT1_EORR_EORR14_1 = 0x1
	// Position of EORR15 field.
	PORT1_EORR_EORR15_Pos = 0xf
	// Bit mask of EORR15 field.
	PORT1_EORR_EORR15_Msk = 0x8000
	// Bit EORR15.
	PORT1_EORR_EORR15 = 0x8000
	// No effect on output
	PORT1_EORR_EORR15_0 = 0x0
	// Low output
	PORT1_EORR_EORR15_1 = 0x1

	// EOSR: Port Control Register 4
	// Position of EOSR00 field.
	PORT1_EOSR_EOSR00_Pos = 0x0
	// Bit mask of EOSR00 field.
	PORT1_EOSR_EOSR00_Msk = 0x1
	// Bit EOSR00.
	PORT1_EOSR_EOSR00 = 0x1
	// No effect on output
	PORT1_EOSR_EOSR00_0 = 0x0
	// High output
	PORT1_EOSR_EOSR00_1 = 0x1
	// Position of EOSR01 field.
	PORT1_EOSR_EOSR01_Pos = 0x1
	// Bit mask of EOSR01 field.
	PORT1_EOSR_EOSR01_Msk = 0x2
	// Bit EOSR01.
	PORT1_EOSR_EOSR01 = 0x2
	// No effect on output
	PORT1_EOSR_EOSR01_0 = 0x0
	// High output
	PORT1_EOSR_EOSR01_1 = 0x1
	// Position of EOSR02 field.
	PORT1_EOSR_EOSR02_Pos = 0x2
	// Bit mask of EOSR02 field.
	PORT1_EOSR_EOSR02_Msk = 0x4
	// Bit EOSR02.
	PORT1_EOSR_EOSR02 = 0x4
	// No effect on output
	PORT1_EOSR_EOSR02_0 = 0x0
	// High output
	PORT1_EOSR_EOSR02_1 = 0x1
	// Position of EOSR03 field.
	PORT1_EOSR_EOSR03_Pos = 0x3
	// Bit mask of EOSR03 field.
	PORT1_EOSR_EOSR03_Msk = 0x8
	// Bit EOSR03.
	PORT1_EOSR_EOSR03 = 0x8
	// No effect on output
	PORT1_EOSR_EOSR03_0 = 0x0
	// High output
	PORT1_EOSR_EOSR03_1 = 0x1
	// Position of EOSR04 field.
	PORT1_EOSR_EOSR04_Pos = 0x4
	// Bit mask of EOSR04 field.
	PORT1_EOSR_EOSR04_Msk = 0x10
	// Bit EOSR04.
	PORT1_EOSR_EOSR04 = 0x10
	// No effect on output
	PORT1_EOSR_EOSR04_0 = 0x0
	// High output
	PORT1_EOSR_EOSR04_1 = 0x1
	// Position of EOSR05 field.
	PORT1_EOSR_EOSR05_Pos = 0x5
	// Bit mask of EOSR05 field.
	PORT1_EOSR_EOSR05_Msk = 0x20
	// Bit EOSR05.
	PORT1_EOSR_EOSR05 = 0x20
	// No effect on output
	PORT1_EOSR_EOSR05_0 = 0x0
	// High output
	PORT1_EOSR_EOSR05_1 = 0x1
	// Position of EOSR06 field.
	PORT1_EOSR_EOSR06_Pos = 0x6
	// Bit mask of EOSR06 field.
	PORT1_EOSR_EOSR06_Msk = 0x40
	// Bit EOSR06.
	PORT1_EOSR_EOSR06 = 0x40
	// No effect on output
	PORT1_EOSR_EOSR06_0 = 0x0
	// High output
	PORT1_EOSR_EOSR06_1 = 0x1
	// Position of EOSR07 field.
	PORT1_EOSR_EOSR07_Pos = 0x7
	// Bit mask of EOSR07 field.
	PORT1_EOSR_EOSR07_Msk = 0x80
	// Bit EOSR07.
	PORT1_EOSR_EOSR07 = 0x80
	// No effect on output
	PORT1_EOSR_EOSR07_0 = 0x0
	// High output
	PORT1_EOSR_EOSR07_1 = 0x1
	// Position of EOSR08 field.
	PORT1_EOSR_EOSR08_Pos = 0x8
	// Bit mask of EOSR08 field.
	PORT1_EOSR_EOSR08_Msk = 0x100
	// Bit EOSR08.
	PORT1_EOSR_EOSR08 = 0x100
	// No effect on output
	PORT1_EOSR_EOSR08_0 = 0x0
	// High output
	PORT1_EOSR_EOSR08_1 = 0x1
	// Position of EOSR09 field.
	PORT1_EOSR_EOSR09_Pos = 0x9
	// Bit mask of EOSR09 field.
	PORT1_EOSR_EOSR09_Msk = 0x200
	// Bit EOSR09.
	PORT1_EOSR_EOSR09 = 0x200
	// No effect on output
	PORT1_EOSR_EOSR09_0 = 0x0
	// High output
	PORT1_EOSR_EOSR09_1 = 0x1
	// Position of EOSR10 field.
	PORT1_EOSR_EOSR10_Pos = 0xa
	// Bit mask of EOSR10 field.
	PORT1_EOSR_EOSR10_Msk = 0x400
	// Bit EOSR10.
	PORT1_EOSR_EOSR10 = 0x400
	// No effect on output
	PORT1_EOSR_EOSR10_0 = 0x0
	// High output
	PORT1_EOSR_EOSR10_1 = 0x1
	// Position of EOSR11 field.
	PORT1_EOSR_EOSR11_Pos = 0xb
	// Bit mask of EOSR11 field.
	PORT1_EOSR_EOSR11_Msk = 0x800
	// Bit EOSR11.
	PORT1_EOSR_EOSR11 = 0x800
	// No effect on output
	PORT1_EOSR_EOSR11_0 = 0x0
	// High output
	PORT1_EOSR_EOSR11_1 = 0x1
	// Position of EOSR12 field.
	PORT1_EOSR_EOSR12_Pos = 0xc
	// Bit mask of EOSR12 field.
	PORT1_EOSR_EOSR12_Msk = 0x1000
	// Bit EOSR12.
	PORT1_EOSR_EOSR12 = 0x1000
	// No effect on output
	PORT1_EOSR_EOSR12_0 = 0x0
	// High output
	PORT1_EOSR_EOSR12_1 = 0x1
	// Position of EOSR13 field.
	PORT1_EOSR_EOSR13_Pos = 0xd
	// Bit mask of EOSR13 field.
	PORT1_EOSR_EOSR13_Msk = 0x2000
	// Bit EOSR13.
	PORT1_EOSR_EOSR13 = 0x2000
	// No effect on output
	PORT1_EOSR_EOSR13_0 = 0x0
	// High output
	PORT1_EOSR_EOSR13_1 = 0x1
	// Position of EOSR14 field.
	PORT1_EOSR_EOSR14_Pos = 0xe
	// Bit mask of EOSR14 field.
	PORT1_EOSR_EOSR14_Msk = 0x4000
	// Bit EOSR14.
	PORT1_EOSR_EOSR14 = 0x4000
	// No effect on output
	PORT1_EOSR_EOSR14_0 = 0x0
	// High output
	PORT1_EOSR_EOSR14_1 = 0x1
	// Position of EOSR15 field.
	PORT1_EOSR_EOSR15_Pos = 0xf
	// Bit mask of EOSR15 field.
	PORT1_EOSR_EOSR15_Msk = 0x8000
	// Bit EOSR15.
	PORT1_EOSR_EOSR15 = 0x8000
	// No effect on output
	PORT1_EOSR_EOSR15_0 = 0x0
	// High output
	PORT1_EOSR_EOSR15_1 = 0x1
)

// Constants for PFS: Pmn Pin Function Control Register
const (
	// P010PFS: Port 0%s Pin Function Select Register
	// Position of PODR field.
	PFS_P0PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P0PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P0PFS_PODR = 0x1
	// Output low
	PFS_P0PFS_PODR_0 = 0x0
	// Output high
	PFS_P0PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P0PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P0PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P0PFS_PIDR = 0x2
	// Low level
	PFS_P0PFS_PIDR_0 = 0x0
	// High level
	PFS_P0PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P0PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P0PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P0PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P0PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P0PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P0PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P0PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P0PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P0PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P0PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P0PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P0PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P0PFS_NCODR = 0x40
	// Output CMOS
	PFS_P0PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P0PFS_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P0PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P0PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P0PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P0PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P0PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P0PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P0PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P0PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P0PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P0PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P0PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P0PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P0PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P0PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P0PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P0PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P0PFS_PSEL_Msk = 0x1f000000

	// P010PFS_HA: Port 0%s Pin Function Select Register
	// Position of PODR field.
	PFS_P0PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P0PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P0PFS_HA_PODR = 0x1
	// Output low
	PFS_P0PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P0PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P0PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P0PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P0PFS_HA_PIDR = 0x2
	// Low level
	PFS_P0PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P0PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P0PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P0PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P0PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P0PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P0PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P0PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P0PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P0PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P0PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P0PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P0PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P0PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P0PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P0PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P0PFS_HA_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P0PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P0PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P0PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P0PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P0PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P0PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P0PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P0PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P0PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P0PFS_HA_ASEL_1 = 0x1

	// P010PFS_BY: Port 0%s Pin Function Select Register
	// Position of PODR field.
	PFS_P0PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P0PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P0PFS_BY_PODR = 0x1
	// Output low
	PFS_P0PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P0PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P0PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P0PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P0PFS_BY_PIDR = 0x2
	// Low level
	PFS_P0PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P0PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P0PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P0PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P0PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P0PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P0PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P0PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P0PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P0PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P0PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P0PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P0PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P0PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P0PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P0PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P0PFS_BY_NCODR_1 = 0x1

	// P014PFS: Port 0%s Pin Function Select Register
	// Position of PODR field.
	PFS_P0PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P0PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P0PFS_PODR = 0x1
	// Output low
	PFS_P0PFS_PODR_0 = 0x0
	// Output high
	PFS_P0PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P0PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P0PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P0PFS_PIDR = 0x2
	// Low level
	PFS_P0PFS_PIDR_0 = 0x0
	// High level
	PFS_P0PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P0PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P0PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P0PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P0PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P0PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P0PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P0PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P0PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P0PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P0PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P0PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P0PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P0PFS_NCODR = 0x40
	// Output CMOS
	PFS_P0PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P0PFS_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P0PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P0PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P0PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P0PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P0PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P0PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P0PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P0PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P0PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P0PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P0PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P0PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P0PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P0PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P0PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P0PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P0PFS_PSEL_Msk = 0x1f000000

	// P014PFS_HA: Port 0%s Pin Function Select Register
	// Position of PODR field.
	PFS_P0PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P0PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P0PFS_HA_PODR = 0x1
	// Output low
	PFS_P0PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P0PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P0PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P0PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P0PFS_HA_PIDR = 0x2
	// Low level
	PFS_P0PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P0PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P0PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P0PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P0PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P0PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P0PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P0PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P0PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P0PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P0PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P0PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P0PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P0PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P0PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P0PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P0PFS_HA_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P0PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P0PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P0PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P0PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P0PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P0PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P0PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P0PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P0PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P0PFS_HA_ASEL_1 = 0x1

	// P014PFS_BY: Port 0%s Pin Function Select Register
	// Position of PODR field.
	PFS_P0PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P0PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P0PFS_BY_PODR = 0x1
	// Output low
	PFS_P0PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P0PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P0PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P0PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P0PFS_BY_PIDR = 0x2
	// Low level
	PFS_P0PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P0PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P0PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P0PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P0PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P0PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P0PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P0PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P0PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P0PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P0PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P0PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P0PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P0PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P0PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P0PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P0PFS_BY_NCODR_1 = 0x1

	// P100PFS: Port 10%s Pin Function Select Register
	// Position of PODR field.
	PFS_P10PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P10PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P10PFS_PODR = 0x1
	// Output low
	PFS_P10PFS_PODR_0 = 0x0
	// Output high
	PFS_P10PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P10PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P10PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P10PFS_PIDR = 0x2
	// Low level
	PFS_P10PFS_PIDR_0 = 0x0
	// High level
	PFS_P10PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P10PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P10PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P10PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P10PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P10PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P10PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P10PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P10PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P10PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P10PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P10PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P10PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P10PFS_NCODR = 0x40
	// Output CMOS
	PFS_P10PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P10PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P10PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P10PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P10PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P10PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P10PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P10PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P10PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P10PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P10PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P10PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P10PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P10PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P10PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P10PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P10PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P10PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P10PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P10PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P10PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P10PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P10PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P10PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P10PFS_PSEL_Msk = 0x1f000000

	// P100PFS_HA: Port 10%s Pin Function Select Register
	// Position of PODR field.
	PFS_P10PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P10PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P10PFS_HA_PODR = 0x1
	// Output low
	PFS_P10PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P10PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P10PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P10PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P10PFS_HA_PIDR = 0x2
	// Low level
	PFS_P10PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P10PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P10PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P10PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P10PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P10PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P10PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P10PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P10PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P10PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P10PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P10PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P10PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P10PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P10PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P10PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P10PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P10PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P10PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P10PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P10PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P10PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P10PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P10PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P10PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P10PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P10PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P10PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P10PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P10PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P10PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P10PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P10PFS_HA_ASEL_1 = 0x1

	// P100PFS_BY: Port 10%s Pin Function Select Register
	// Position of PODR field.
	PFS_P10PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P10PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P10PFS_BY_PODR = 0x1
	// Output low
	PFS_P10PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P10PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P10PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P10PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P10PFS_BY_PIDR = 0x2
	// Low level
	PFS_P10PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P10PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P10PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P10PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P10PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P10PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P10PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P10PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P10PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P10PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P10PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P10PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P10PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P10PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P10PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P10PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P10PFS_BY_NCODR_1 = 0x1

	// P108PFS: Port 108 Pin Function Select Register
	// Position of PODR field.
	PFS_P108PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P108PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P108PFS_PODR = 0x1
	// Output low
	PFS_P108PFS_PODR_0 = 0x0
	// Output high
	PFS_P108PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P108PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P108PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P108PFS_PIDR = 0x2
	// Low level
	PFS_P108PFS_PIDR_0 = 0x0
	// High level
	PFS_P108PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P108PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P108PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P108PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P108PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P108PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P108PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P108PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P108PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P108PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P108PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P108PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P108PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P108PFS_NCODR = 0x40
	// Output CMOS
	PFS_P108PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P108PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P108PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P108PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P108PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P108PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P108PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P108PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P108PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P108PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P108PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P108PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P108PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P108PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P108PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P108PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P108PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P108PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P108PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P108PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P108PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P108PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P108PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P108PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P108PFS_PSEL_Msk = 0x1f000000

	// P108PFS_HA: Port 108 Pin Function Select Register
	// Position of PODR field.
	PFS_P108PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P108PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P108PFS_HA_PODR = 0x1
	// Output low
	PFS_P108PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P108PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P108PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P108PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P108PFS_HA_PIDR = 0x2
	// Low level
	PFS_P108PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P108PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P108PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P108PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P108PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P108PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P108PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P108PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P108PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P108PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P108PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P108PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P108PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P108PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P108PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P108PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P108PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P108PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P108PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P108PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P108PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P108PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P108PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P108PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P108PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P108PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P108PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P108PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P108PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P108PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P108PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P108PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P108PFS_HA_ASEL_1 = 0x1

	// P108PFS_BY: Port 108 Pin Function Select Register
	// Position of PODR field.
	PFS_P108PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P108PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P108PFS_BY_PODR = 0x1
	// Output low
	PFS_P108PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P108PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P108PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P108PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P108PFS_BY_PIDR = 0x2
	// Low level
	PFS_P108PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P108PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P108PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P108PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P108PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P108PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P108PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P108PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P108PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P108PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P108PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P108PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P108PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P108PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P108PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P108PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P108PFS_BY_NCODR_1 = 0x1

	// P109PFS: Port 109 Pin Function Select Register
	// Position of PODR field.
	PFS_P109PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P109PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P109PFS_PODR = 0x1
	// Output low
	PFS_P109PFS_PODR_0 = 0x0
	// Output high
	PFS_P109PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P109PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P109PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P109PFS_PIDR = 0x2
	// Low level
	PFS_P109PFS_PIDR_0 = 0x0
	// High level
	PFS_P109PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P109PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P109PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P109PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P109PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P109PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P109PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P109PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P109PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P109PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P109PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P109PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P109PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P109PFS_NCODR = 0x40
	// Output CMOS
	PFS_P109PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P109PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P109PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P109PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P109PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P109PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P109PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P109PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P109PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P109PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P109PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P109PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P109PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P109PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P109PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P109PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P109PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P109PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P109PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P109PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P109PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P109PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P109PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P109PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P109PFS_PSEL_Msk = 0x1f000000

	// P109PFS_HA: Port 109 Pin Function Select Register
	// Position of PODR field.
	PFS_P109PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P109PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P109PFS_HA_PODR = 0x1
	// Output low
	PFS_P109PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P109PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P109PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P109PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P109PFS_HA_PIDR = 0x2
	// Low level
	PFS_P109PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P109PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P109PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P109PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P109PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P109PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P109PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P109PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P109PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P109PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P109PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P109PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P109PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P109PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P109PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P109PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P109PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P109PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P109PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P109PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P109PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P109PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P109PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P109PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P109PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P109PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P109PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P109PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P109PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P109PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P109PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P109PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P109PFS_HA_ASEL_1 = 0x1

	// P109PFS_BY: Port 109 Pin Function Select Register
	// Position of PODR field.
	PFS_P109PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P109PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P109PFS_BY_PODR = 0x1
	// Output low
	PFS_P109PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P109PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P109PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P109PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P109PFS_BY_PIDR = 0x2
	// Low level
	PFS_P109PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P109PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P109PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P109PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P109PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P109PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P109PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P109PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P109PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P109PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P109PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P109PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P109PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P109PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P109PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P109PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P109PFS_BY_NCODR_1 = 0x1

	// P110PFS: Port 1%s Pin Function Select Register
	// Position of PODR field.
	PFS_P1PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P1PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P1PFS_PODR = 0x1
	// Output low
	PFS_P1PFS_PODR_0 = 0x0
	// Output high
	PFS_P1PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P1PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P1PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P1PFS_PIDR = 0x2
	// Low level
	PFS_P1PFS_PIDR_0 = 0x0
	// High level
	PFS_P1PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P1PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P1PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P1PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P1PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P1PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P1PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P1PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P1PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P1PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P1PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P1PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P1PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P1PFS_NCODR = 0x40
	// Output CMOS
	PFS_P1PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P1PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P1PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P1PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P1PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P1PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P1PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P1PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P1PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P1PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P1PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P1PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P1PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P1PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P1PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P1PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P1PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P1PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P1PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P1PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P1PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P1PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P1PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P1PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P1PFS_PSEL_Msk = 0x1f000000

	// P110PFS_HA: Port 1%s Pin Function Select Register
	// Position of PODR field.
	PFS_P1PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P1PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P1PFS_HA_PODR = 0x1
	// Output low
	PFS_P1PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P1PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P1PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P1PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P1PFS_HA_PIDR = 0x2
	// Low level
	PFS_P1PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P1PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P1PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P1PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P1PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P1PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P1PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P1PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P1PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P1PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P1PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P1PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P1PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P1PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P1PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P1PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P1PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P1PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P1PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P1PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P1PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P1PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P1PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P1PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P1PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P1PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P1PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P1PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P1PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P1PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P1PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P1PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P1PFS_HA_ASEL_1 = 0x1

	// P110PFS_BY: Port 1%s Pin Function Select Register
	// Position of PODR field.
	PFS_P1PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P1PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P1PFS_BY_PODR = 0x1
	// Output low
	PFS_P1PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P1PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P1PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P1PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P1PFS_BY_PIDR = 0x2
	// Low level
	PFS_P1PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P1PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P1PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P1PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P1PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P1PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P1PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P1PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P1PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P1PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P1PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P1PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P1PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P1PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P1PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P1PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P1PFS_BY_NCODR_1 = 0x1

	// P200PFS: Port 200 Pin Function Select Register
	// Position of PODR field.
	PFS_P200PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P200PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P200PFS_PODR = 0x1
	// Output low
	PFS_P200PFS_PODR_0 = 0x0
	// Output high
	PFS_P200PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P200PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P200PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P200PFS_PIDR = 0x2
	// Low level
	PFS_P200PFS_PIDR_0 = 0x0
	// High level
	PFS_P200PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P200PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P200PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P200PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P200PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P200PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P200PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P200PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P200PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P200PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P200PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P200PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P200PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P200PFS_NCODR = 0x40
	// Output CMOS
	PFS_P200PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P200PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P200PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P200PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P200PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P200PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P200PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P200PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P200PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P200PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P200PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P200PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P200PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P200PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P200PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P200PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P200PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P200PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P200PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P200PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P200PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P200PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P200PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P200PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P200PFS_PSEL_Msk = 0x1f000000

	// P200PFS_HA: Port 200 Pin Function Select Register
	// Position of PODR field.
	PFS_P200PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P200PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P200PFS_HA_PODR = 0x1
	// Output low
	PFS_P200PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P200PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P200PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P200PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P200PFS_HA_PIDR = 0x2
	// Low level
	PFS_P200PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P200PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P200PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P200PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P200PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P200PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P200PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P200PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P200PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P200PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P200PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P200PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P200PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P200PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P200PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P200PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P200PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P200PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P200PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P200PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P200PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P200PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P200PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P200PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P200PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P200PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P200PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P200PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P200PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P200PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P200PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P200PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P200PFS_HA_ASEL_1 = 0x1

	// P200PFS_BY: Port 200 Pin Function Select Register
	// Position of PODR field.
	PFS_P200PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P200PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P200PFS_BY_PODR = 0x1
	// Output low
	PFS_P200PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P200PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P200PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P200PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P200PFS_BY_PIDR = 0x2
	// Low level
	PFS_P200PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P200PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P200PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P200PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P200PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P200PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P200PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P200PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P200PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P200PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P200PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P200PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P200PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P200PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P200PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P200PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P200PFS_BY_NCODR_1 = 0x1

	// P201PFS: Port 201 Pin Function Select Register
	// Position of PODR field.
	PFS_P201PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P201PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P201PFS_PODR = 0x1
	// Output low
	PFS_P201PFS_PODR_0 = 0x0
	// Output high
	PFS_P201PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P201PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P201PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P201PFS_PIDR = 0x2
	// Low level
	PFS_P201PFS_PIDR_0 = 0x0
	// High level
	PFS_P201PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P201PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P201PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P201PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P201PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P201PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P201PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P201PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P201PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P201PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P201PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P201PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P201PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P201PFS_NCODR = 0x40
	// Output CMOS
	PFS_P201PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P201PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P201PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P201PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P201PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P201PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P201PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P201PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P201PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P201PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P201PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P201PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P201PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P201PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P201PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P201PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P201PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P201PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P201PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P201PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P201PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P201PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P201PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P201PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P201PFS_PSEL_Msk = 0x1f000000

	// P201PFS_HA: Port 201 Pin Function Select Register
	// Position of PODR field.
	PFS_P201PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P201PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P201PFS_HA_PODR = 0x1
	// Output low
	PFS_P201PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P201PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P201PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P201PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P201PFS_HA_PIDR = 0x2
	// Low level
	PFS_P201PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P201PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P201PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P201PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P201PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P201PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P201PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P201PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P201PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P201PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P201PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P201PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P201PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P201PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P201PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P201PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P201PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P201PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P201PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P201PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P201PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P201PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P201PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P201PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P201PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P201PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P201PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P201PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P201PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P201PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P201PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P201PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P201PFS_HA_ASEL_1 = 0x1

	// P201PFS_BY: Port 201 Pin Function Select Register
	// Position of PODR field.
	PFS_P201PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P201PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P201PFS_BY_PODR = 0x1
	// Output low
	PFS_P201PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P201PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P201PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P201PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P201PFS_BY_PIDR = 0x2
	// Low level
	PFS_P201PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P201PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P201PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P201PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P201PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P201PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P201PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P201PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P201PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P201PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P201PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P201PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P201PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P201PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P201PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P201PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P201PFS_BY_NCODR_1 = 0x1

	// P205PFS: Port 205 Pin Function Select Register
	// Position of PODR field.
	PFS_P205PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P205PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P205PFS_PODR = 0x1
	// Output low
	PFS_P205PFS_PODR_0 = 0x0
	// Output high
	PFS_P205PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P205PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P205PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P205PFS_PIDR = 0x2
	// Low level
	PFS_P205PFS_PIDR_0 = 0x0
	// High level
	PFS_P205PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P205PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P205PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P205PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P205PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P205PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P205PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P205PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P205PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P205PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P205PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P205PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P205PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P205PFS_NCODR = 0x40
	// Output CMOS
	PFS_P205PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P205PFS_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P205PFS_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P205PFS_EOFR_Msk = 0x3000
	// Don't care
	PFS_P205PFS_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P205PFS_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P205PFS_EOFR_10 = 0x2
	// Detect both edges
	PFS_P205PFS_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P205PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P205PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P205PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P205PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P205PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P205PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P205PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P205PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P205PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P205PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P205PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P205PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P205PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P205PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P205PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P205PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P205PFS_PSEL_Msk = 0x1f000000

	// P205PFS_HA: Port 205 Pin Function Select Register
	// Position of PODR field.
	PFS_P205PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P205PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P205PFS_HA_PODR = 0x1
	// Output low
	PFS_P205PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P205PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P205PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P205PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P205PFS_HA_PIDR = 0x2
	// Low level
	PFS_P205PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P205PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P205PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P205PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P205PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P205PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P205PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P205PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P205PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P205PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P205PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P205PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P205PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P205PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P205PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P205PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P205PFS_HA_NCODR_1 = 0x1
	// Position of EOFR field.
	PFS_P205PFS_HA_EOFR_Pos = 0xc
	// Bit mask of EOFR field.
	PFS_P205PFS_HA_EOFR_Msk = 0x3000
	// Don't care
	PFS_P205PFS_HA_EOFR_00 = 0x0
	// Detect rising edge
	PFS_P205PFS_HA_EOFR_01 = 0x1
	// Detect falling edge
	PFS_P205PFS_HA_EOFR_10 = 0x2
	// Detect both edges
	PFS_P205PFS_HA_EOFR_11 = 0x3
	// Position of ISEL field.
	PFS_P205PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P205PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P205PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P205PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P205PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P205PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P205PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P205PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P205PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P205PFS_HA_ASEL_1 = 0x1

	// P205PFS_BY: Port 205 Pin Function Select Register
	// Position of PODR field.
	PFS_P205PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P205PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P205PFS_BY_PODR = 0x1
	// Output low
	PFS_P205PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P205PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P205PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P205PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P205PFS_BY_PIDR = 0x2
	// Low level
	PFS_P205PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P205PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P205PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P205PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P205PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P205PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P205PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P205PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P205PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P205PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P205PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P205PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P205PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P205PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P205PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P205PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P205PFS_BY_NCODR_1 = 0x1

	// P300PFS: Port 300 Pin Function Select Register
	// Position of PODR field.
	PFS_P300PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P300PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P300PFS_PODR = 0x1
	// Output low
	PFS_P300PFS_PODR_0 = 0x0
	// Output high
	PFS_P300PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P300PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P300PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P300PFS_PIDR = 0x2
	// Low level
	PFS_P300PFS_PIDR_0 = 0x0
	// High level
	PFS_P300PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P300PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P300PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P300PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P300PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P300PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P300PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P300PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P300PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P300PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P300PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P300PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P300PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P300PFS_NCODR = 0x40
	// Output CMOS
	PFS_P300PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P300PFS_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P300PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P300PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P300PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P300PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P300PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P300PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P300PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P300PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P300PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P300PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P300PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P300PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P300PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P300PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P300PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P300PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P300PFS_PSEL_Msk = 0x1f000000

	// P300PFS_HA: Port 300 Pin Function Select Register
	// Position of PODR field.
	PFS_P300PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P300PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P300PFS_HA_PODR = 0x1
	// Output low
	PFS_P300PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P300PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P300PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P300PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P300PFS_HA_PIDR = 0x2
	// Low level
	PFS_P300PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P300PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P300PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P300PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P300PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P300PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P300PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P300PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P300PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P300PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P300PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P300PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P300PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P300PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P300PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P300PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P300PFS_HA_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P300PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P300PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P300PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P300PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P300PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P300PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P300PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P300PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P300PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P300PFS_HA_ASEL_1 = 0x1

	// P300PFS_BY: Port 300 Pin Function Select Register
	// Position of PODR field.
	PFS_P300PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P300PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P300PFS_BY_PODR = 0x1
	// Output low
	PFS_P300PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P300PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P300PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P300PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P300PFS_BY_PIDR = 0x2
	// Low level
	PFS_P300PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P300PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P300PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P300PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P300PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P300PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P300PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P300PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P300PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P300PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P300PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P300PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P300PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P300PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P300PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P300PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P300PFS_BY_NCODR_1 = 0x1

	// P400PFS: Port 40%s Pin Function Select Register
	// Position of PODR field.
	PFS_P40PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P40PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P40PFS_PODR = 0x1
	// Output low
	PFS_P40PFS_PODR_0 = 0x0
	// Output high
	PFS_P40PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P40PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P40PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P40PFS_PIDR = 0x2
	// Low level
	PFS_P40PFS_PIDR_0 = 0x0
	// High level
	PFS_P40PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P40PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P40PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P40PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P40PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P40PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P40PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P40PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P40PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P40PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P40PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P40PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P40PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P40PFS_NCODR = 0x40
	// Output CMOS
	PFS_P40PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P40PFS_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P40PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P40PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P40PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P40PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P40PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P40PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P40PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P40PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P40PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P40PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P40PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P40PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P40PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P40PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P40PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P40PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P40PFS_PSEL_Msk = 0x1f000000

	// P400PFS_HA: Port 40%s Pin Function Select Register
	// Position of PODR field.
	PFS_P40PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P40PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P40PFS_HA_PODR = 0x1
	// Output low
	PFS_P40PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P40PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P40PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P40PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P40PFS_HA_PIDR = 0x2
	// Low level
	PFS_P40PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P40PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P40PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P40PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P40PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P40PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P40PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P40PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P40PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P40PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P40PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P40PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P40PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P40PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P40PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P40PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P40PFS_HA_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P40PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P40PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P40PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P40PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P40PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P40PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P40PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P40PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P40PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P40PFS_HA_ASEL_1 = 0x1

	// P400PFS_BY: Port 40%s Pin Function Select Register
	// Position of PODR field.
	PFS_P40PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P40PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P40PFS_BY_PODR = 0x1
	// Output low
	PFS_P40PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P40PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P40PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P40PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P40PFS_BY_PIDR = 0x2
	// Low level
	PFS_P40PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P40PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P40PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P40PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P40PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P40PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P40PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P40PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P40PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P40PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P40PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P40PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P40PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P40PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P40PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P40PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P40PFS_BY_NCODR_1 = 0x1

	// P914PFS: Port 914 Pin Function Select Register
	// Position of PODR field.
	PFS_P914PFS_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P914PFS_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P914PFS_PODR = 0x1
	// Output low
	PFS_P914PFS_PODR_0 = 0x0
	// Output high
	PFS_P914PFS_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P914PFS_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P914PFS_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P914PFS_PIDR = 0x2
	// Low level
	PFS_P914PFS_PIDR_0 = 0x0
	// High level
	PFS_P914PFS_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P914PFS_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P914PFS_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P914PFS_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P914PFS_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P914PFS_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P914PFS_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P914PFS_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P914PFS_PCR = 0x10
	// Disable input pull-up
	PFS_P914PFS_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P914PFS_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P914PFS_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P914PFS_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P914PFS_NCODR = 0x40
	// Output CMOS
	PFS_P914PFS_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P914PFS_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P914PFS_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P914PFS_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P914PFS_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P914PFS_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P914PFS_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P914PFS_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P914PFS_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P914PFS_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P914PFS_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P914PFS_ASEL_1 = 0x1
	// Position of PMR field.
	PFS_P914PFS_PMR_Pos = 0x10
	// Bit mask of PMR field.
	PFS_P914PFS_PMR_Msk = 0x10000
	// Bit PMR.
	PFS_P914PFS_PMR = 0x10000
	// Use as general I/O pin
	PFS_P914PFS_PMR_0 = 0x0
	// Use as I/O port for peripheral functions
	PFS_P914PFS_PMR_1 = 0x1
	// Position of PSEL field.
	PFS_P914PFS_PSEL_Pos = 0x18
	// Bit mask of PSEL field.
	PFS_P914PFS_PSEL_Msk = 0x1f000000

	// P914PFS_HA: Port 914 Pin Function Select Register
	// Position of PODR field.
	PFS_P914PFS_HA_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P914PFS_HA_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P914PFS_HA_PODR = 0x1
	// Output low
	PFS_P914PFS_HA_PODR_0 = 0x0
	// Output high
	PFS_P914PFS_HA_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P914PFS_HA_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P914PFS_HA_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P914PFS_HA_PIDR = 0x2
	// Low level
	PFS_P914PFS_HA_PIDR_0 = 0x0
	// High level
	PFS_P914PFS_HA_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P914PFS_HA_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P914PFS_HA_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P914PFS_HA_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P914PFS_HA_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P914PFS_HA_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P914PFS_HA_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P914PFS_HA_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P914PFS_HA_PCR = 0x10
	// Disable input pull-up
	PFS_P914PFS_HA_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P914PFS_HA_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P914PFS_HA_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P914PFS_HA_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P914PFS_HA_NCODR = 0x40
	// Output CMOS
	PFS_P914PFS_HA_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P914PFS_HA_NCODR_1 = 0x1
	// Position of ISEL field.
	PFS_P914PFS_HA_ISEL_Pos = 0xe
	// Bit mask of ISEL field.
	PFS_P914PFS_HA_ISEL_Msk = 0x4000
	// Bit ISEL.
	PFS_P914PFS_HA_ISEL = 0x4000
	// Do not use as IRQn input pin
	PFS_P914PFS_HA_ISEL_0 = 0x0
	// Use as IRQn input pin
	PFS_P914PFS_HA_ISEL_1 = 0x1
	// Position of ASEL field.
	PFS_P914PFS_HA_ASEL_Pos = 0xf
	// Bit mask of ASEL field.
	PFS_P914PFS_HA_ASEL_Msk = 0x8000
	// Bit ASEL.
	PFS_P914PFS_HA_ASEL = 0x8000
	// Do not use as analog pin
	PFS_P914PFS_HA_ASEL_0 = 0x0
	// Use as analog pin
	PFS_P914PFS_HA_ASEL_1 = 0x1

	// P914PFS_BY: Port 914 Pin Function Select Register
	// Position of PODR field.
	PFS_P914PFS_BY_PODR_Pos = 0x0
	// Bit mask of PODR field.
	PFS_P914PFS_BY_PODR_Msk = 0x1
	// Bit PODR.
	PFS_P914PFS_BY_PODR = 0x1
	// Output low
	PFS_P914PFS_BY_PODR_0 = 0x0
	// Output high
	PFS_P914PFS_BY_PODR_1 = 0x1
	// Position of PIDR field.
	PFS_P914PFS_BY_PIDR_Pos = 0x1
	// Bit mask of PIDR field.
	PFS_P914PFS_BY_PIDR_Msk = 0x2
	// Bit PIDR.
	PFS_P914PFS_BY_PIDR = 0x2
	// Low level
	PFS_P914PFS_BY_PIDR_0 = 0x0
	// High level
	PFS_P914PFS_BY_PIDR_1 = 0x1
	// Position of PDR field.
	PFS_P914PFS_BY_PDR_Pos = 0x2
	// Bit mask of PDR field.
	PFS_P914PFS_BY_PDR_Msk = 0x4
	// Bit PDR.
	PFS_P914PFS_BY_PDR = 0x4
	// Input (functions as an input pin)
	PFS_P914PFS_BY_PDR_0 = 0x0
	// Output (functions as an output pin)
	PFS_P914PFS_BY_PDR_1 = 0x1
	// Position of PCR field.
	PFS_P914PFS_BY_PCR_Pos = 0x4
	// Bit mask of PCR field.
	PFS_P914PFS_BY_PCR_Msk = 0x10
	// Bit PCR.
	PFS_P914PFS_BY_PCR = 0x10
	// Disable input pull-up
	PFS_P914PFS_BY_PCR_0 = 0x0
	// Enable input pull-up
	PFS_P914PFS_BY_PCR_1 = 0x1
	// Position of NCODR field.
	PFS_P914PFS_BY_NCODR_Pos = 0x6
	// Bit mask of NCODR field.
	PFS_P914PFS_BY_NCODR_Msk = 0x40
	// Bit NCODR.
	PFS_P914PFS_BY_NCODR = 0x40
	// Output CMOS
	PFS_P914PFS_BY_NCODR_0 = 0x0
	// Output NMOS open-drain
	PFS_P914PFS_BY_NCODR_1 = 0x1

	// PWPR: Write-Protect Register
	// Position of PFSWE field.
	PFS_PWPR_PFSWE_Pos = 0x6
	// Bit mask of PFSWE field.
	PFS_PWPR_PFSWE_Msk = 0x40
	// Bit PFSWE.
	PFS_PWPR_PFSWE = 0x40
	// Writing to the PmnPFS register is disabled
	PFS_PWPR_PFSWE_0 = 0x0
	// Writing to the PmnPFS register is enabled
	PFS_PWPR_PFSWE_1 = 0x1
	// Position of B0WI field.
	PFS_PWPR_B0WI_Pos = 0x7
	// Bit mask of B0WI field.
	PFS_PWPR_B0WI_Msk = 0x80
	// Bit B0WI.
	PFS_PWPR_B0WI = 0x80
	// Writing to the PFSWE bit is enabled
	PFS_PWPR_B0WI_0 = 0x0
	// Writing to the PFSWE bit is disabled
	PFS_PWPR_B0WI_1 = 0x1

	// PRWCNTR: Port Read Wait Control Register
	// Position of WAIT field.
	PFS_PRWCNTR_WAIT_Pos = 0x0
	// Bit mask of WAIT field.
	PFS_PRWCNTR_WAIT_Msk = 0x3
	// Setting prohibited
	PFS_PRWCNTR_WAIT_00 = 0x0
	// Insert a 1-cycle wait
	PFS_PRWCNTR_WAIT_01 = 0x1
	// Insert a 2-cycle wait
	PFS_PRWCNTR_WAIT_10 = 0x2
	// Insert a 3-cycle wait
	PFS_PRWCNTR_WAIT_11 = 0x3
)

// Constants for ELC: Event Link Controller
const (
	// ELCR: Event Link Controller Register
	// Position of ELCON field.
	ELC_ELCR_ELCON_Pos = 0x7
	// Bit mask of ELCON field.
	ELC_ELCR_ELCON_Msk = 0x80
	// Bit ELCON.
	ELC_ELCR_ELCON = 0x80
	// ELC function is disabled.
	ELC_ELCR_ELCON_0 = 0x0
	// ELC function is enabled.
	ELC_ELCR_ELCON_1 = 0x1

	// ELSEGR0: Event Link Software Event Generation Register %s
	// Position of SEG field.
	ELC_ELSEGR_SEG_Pos = 0x0
	// Bit mask of SEG field.
	ELC_ELSEGR_SEG_Msk = 0x1
	// Bit SEG.
	ELC_ELSEGR_SEG = 0x1
	// Normal operation
	ELC_ELSEGR_SEG_0 = 0x0
	// Software event is generated.
	ELC_ELSEGR_SEG_1 = 0x1
	// Position of WE field.
	ELC_ELSEGR_WE_Pos = 0x6
	// Bit mask of WE field.
	ELC_ELSEGR_WE_Msk = 0x40
	// Bit WE.
	ELC_ELSEGR_WE = 0x40
	// Write to SEG bit disabled.
	ELC_ELSEGR_WE_0 = 0x0
	// Write to SEG bit enabled.
	ELC_ELSEGR_WE_1 = 0x1
	// Position of WI field.
	ELC_ELSEGR_WI_Pos = 0x7
	// Bit mask of WI field.
	ELC_ELSEGR_WI_Msk = 0x80
	// Bit WI.
	ELC_ELSEGR_WI = 0x80
	// Write to ELSEGR register enabled.
	ELC_ELSEGR_WI_0 = 0x0
	// Write to ELSEGR register disabled.
	ELC_ELSEGR_WI_1 = 0x1

	// ELSR0: Event Link Setting Register %s
	// Position of ELS field.
	ELC_ELSR_ELS_Pos = 0x0
	// Bit mask of ELS field.
	ELC_ELSR_ELS_Msk = 0xff

	// ELSR8: Event Link Setting Register %s
	// Position of ELS field.
	ELC_ELSR_ELS_Pos = 0x0
	// Bit mask of ELS field.
	ELC_ELSR_ELS_Msk = 0xff

	// ELSR14: Event Link Setting Register %s
	// Position of ELS field.
	ELC_ELSR_ELS_Pos = 0x0
	// Bit mask of ELS field.
	ELC_ELSR_ELS_Msk = 0xff
)

// Constants for POEG: Port Output Enable Module for GPT
const (
	// POEGGA: POEG Group A Setting Register
	// Position of PIDF field.
	POEG_POEGGA_PIDF_Pos = 0x0
	// Bit mask of PIDF field.
	POEG_POEGGA_PIDF_Msk = 0x1
	// Bit PIDF.
	POEG_POEGGA_PIDF = 0x1
	// No output-disable request from the GTETRGn pin occurred
	POEG_POEGGA_PIDF_0 = 0x0
	// Output-disable request from the GTETRGn pin occurred.
	POEG_POEGGA_PIDF_1 = 0x1
	// Position of IOCF field.
	POEG_POEGGA_IOCF_Pos = 0x1
	// Bit mask of IOCF field.
	POEG_POEGGA_IOCF_Msk = 0x2
	// Bit IOCF.
	POEG_POEGGA_IOCF = 0x2
	// No output-disable request from GPT occurred.
	POEG_POEGGA_IOCF_0 = 0x0
	// Output-disable request from GPT occurred.
	POEG_POEGGA_IOCF_1 = 0x1
	// Position of SSF field.
	POEG_POEGGA_SSF_Pos = 0x3
	// Bit mask of SSF field.
	POEG_POEGGA_SSF_Msk = 0x8
	// Bit SSF.
	POEG_POEGGA_SSF = 0x8
	// No output-disable request from software occurred
	POEG_POEGGA_SSF_0 = 0x0
	// Output-disable request from software occurred
	POEG_POEGGA_SSF_1 = 0x1
	// Position of PIDE field.
	POEG_POEGGA_PIDE_Pos = 0x4
	// Bit mask of PIDE field.
	POEG_POEGGA_PIDE_Msk = 0x10
	// Bit PIDE.
	POEG_POEGGA_PIDE = 0x10
	// Disable output-disable requests from the GTETRGn pins
	POEG_POEGGA_PIDE_0 = 0x0
	// Enable output-disable requests from the GTETRGn pins
	POEG_POEGGA_PIDE_1 = 0x1
	// Position of IOCE field.
	POEG_POEGGA_IOCE_Pos = 0x5
	// Bit mask of IOCE field.
	POEG_POEGGA_IOCE_Msk = 0x20
	// Bit IOCE.
	POEG_POEGGA_IOCE = 0x20
	// Disable output-disable requests from GPT
	POEG_POEGGA_IOCE_0 = 0x0
	// Enable output-disable requests from GPT
	POEG_POEGGA_IOCE_1 = 0x1
	// Position of ST field.
	POEG_POEGGA_ST_Pos = 0x10
	// Bit mask of ST field.
	POEG_POEGGA_ST_Msk = 0x10000
	// Bit ST.
	POEG_POEGGA_ST = 0x10000
	// GTETRGn input after filtering was 0
	POEG_POEGGA_ST_0 = 0x0
	// GTETRGn input after filtering was 1
	POEG_POEGGA_ST_1 = 0x1
	// Position of INV field.
	POEG_POEGGA_INV_Pos = 0x1c
	// Bit mask of INV field.
	POEG_POEGGA_INV_Msk = 0x10000000
	// Bit INV.
	POEG_POEGGA_INV = 0x10000000
	// Input GTETRGn as-is
	POEG_POEGGA_INV_0 = 0x0
	// Input GTETRGn in reverse
	POEG_POEGGA_INV_1 = 0x1
	// Position of NFEN field.
	POEG_POEGGA_NFEN_Pos = 0x1d
	// Bit mask of NFEN field.
	POEG_POEGGA_NFEN_Msk = 0x20000000
	// Bit NFEN.
	POEG_POEGGA_NFEN = 0x20000000
	// Disable noise filtering
	POEG_POEGGA_NFEN_0 = 0x0
	// Enable noise filtering
	POEG_POEGGA_NFEN_1 = 0x1
	// Position of NFCS field.
	POEG_POEGGA_NFCS_Pos = 0x1e
	// Bit mask of NFCS field.
	POEG_POEGGA_NFCS_Msk = 0xc0000000
	// Sample GTETRGn pin input level three times every PCLKB
	POEG_POEGGA_NFCS_00 = 0x0
	// Sample GTETRGn pin input level three times every PCLKB/8
	POEG_POEGGA_NFCS_01 = 0x1
	// Sample GTETRGn pin input level three times every PCLKB/32
	POEG_POEGGA_NFCS_10 = 0x2
	// Sample GTETRGn pin input level three times every PCLKB/128
	POEG_POEGGA_NFCS_11 = 0x3

	// POEGGB: POEG Group B Setting Register
	// Position of PIDF field.
	POEG_POEGGB_PIDF_Pos = 0x0
	// Bit mask of PIDF field.
	POEG_POEGGB_PIDF_Msk = 0x1
	// Bit PIDF.
	POEG_POEGGB_PIDF = 0x1
	// No output-disable request from the GTETRGn pin occurred
	POEG_POEGGB_PIDF_0 = 0x0
	// Output-disable request from the GTETRGn pin occurred.
	POEG_POEGGB_PIDF_1 = 0x1
	// Position of IOCF field.
	POEG_POEGGB_IOCF_Pos = 0x1
	// Bit mask of IOCF field.
	POEG_POEGGB_IOCF_Msk = 0x2
	// Bit IOCF.
	POEG_POEGGB_IOCF = 0x2
	// No output-disable request from GPT occurred.
	POEG_POEGGB_IOCF_0 = 0x0
	// Output-disable request from GPT occurred.
	POEG_POEGGB_IOCF_1 = 0x1
	// Position of SSF field.
	POEG_POEGGB_SSF_Pos = 0x3
	// Bit mask of SSF field.
	POEG_POEGGB_SSF_Msk = 0x8
	// Bit SSF.
	POEG_POEGGB_SSF = 0x8
	// No output-disable request from software occurred
	POEG_POEGGB_SSF_0 = 0x0
	// Output-disable request from software occurred
	POEG_POEGGB_SSF_1 = 0x1
	// Position of PIDE field.
	POEG_POEGGB_PIDE_Pos = 0x4
	// Bit mask of PIDE field.
	POEG_POEGGB_PIDE_Msk = 0x10
	// Bit PIDE.
	POEG_POEGGB_PIDE = 0x10
	// Disable output-disable requests from the GTETRGn pins
	POEG_POEGGB_PIDE_0 = 0x0
	// Enable output-disable requests from the GTETRGn pins
	POEG_POEGGB_PIDE_1 = 0x1
	// Position of IOCE field.
	POEG_POEGGB_IOCE_Pos = 0x5
	// Bit mask of IOCE field.
	POEG_POEGGB_IOCE_Msk = 0x20
	// Bit IOCE.
	POEG_POEGGB_IOCE = 0x20
	// Disable output-disable requests from GPT
	POEG_POEGGB_IOCE_0 = 0x0
	// Enable output-disable requests from GPT
	POEG_POEGGB_IOCE_1 = 0x1
	// Position of ST field.
	POEG_POEGGB_ST_Pos = 0x10
	// Bit mask of ST field.
	POEG_POEGGB_ST_Msk = 0x10000
	// Bit ST.
	POEG_POEGGB_ST = 0x10000
	// GTETRGn input after filtering was 0
	POEG_POEGGB_ST_0 = 0x0
	// GTETRGn input after filtering was 1
	POEG_POEGGB_ST_1 = 0x1
	// Position of INV field.
	POEG_POEGGB_INV_Pos = 0x1c
	// Bit mask of INV field.
	POEG_POEGGB_INV_Msk = 0x10000000
	// Bit INV.
	POEG_POEGGB_INV = 0x10000000
	// Input GTETRGn as-is
	POEG_POEGGB_INV_0 = 0x0
	// Input GTETRGn in reverse
	POEG_POEGGB_INV_1 = 0x1
	// Position of NFEN field.
	POEG_POEGGB_NFEN_Pos = 0x1d
	// Bit mask of NFEN field.
	POEG_POEGGB_NFEN_Msk = 0x20000000
	// Bit NFEN.
	POEG_POEGGB_NFEN = 0x20000000
	// Disable noise filtering
	POEG_POEGGB_NFEN_0 = 0x0
	// Enable noise filtering
	POEG_POEGGB_NFEN_1 = 0x1
	// Position of NFCS field.
	POEG_POEGGB_NFCS_Pos = 0x1e
	// Bit mask of NFCS field.
	POEG_POEGGB_NFCS_Msk = 0xc0000000
	// Sample GTETRGn pin input level three times every PCLKB
	POEG_POEGGB_NFCS_00 = 0x0
	// Sample GTETRGn pin input level three times every PCLKB/8
	POEG_POEGGB_NFCS_01 = 0x1
	// Sample GTETRGn pin input level three times every PCLKB/32
	POEG_POEGGB_NFCS_10 = 0x2
	// Sample GTETRGn pin input level three times every PCLKB/128
	POEG_POEGGB_NFCS_11 = 0x3
)

// Constants for WDT: Watchdog Timer
const (
	// WDTCR: WDT Control Register
	// Position of TOPS field.
	WDT_WDTCR_TOPS_Pos = 0x0
	// Bit mask of TOPS field.
	WDT_WDTCR_TOPS_Msk = 0x3
	// 1024 cycles (0x03FF)
	WDT_WDTCR_TOPS_00 = 0x0
	// 4096 cycles (0x0FFF)
	WDT_WDTCR_TOPS_01 = 0x1
	// 8192 cycles (0x1FFF)
	WDT_WDTCR_TOPS_10 = 0x2
	// 16384 cycles (0x3FFF)
	WDT_WDTCR_TOPS_11 = 0x3
	// Position of CKS field.
	WDT_WDTCR_CKS_Pos = 0x4
	// Bit mask of CKS field.
	WDT_WDTCR_CKS_Msk = 0xf0
	// PCLKB/4
	WDT_WDTCR_CKS_0x1 = 0x1
	// PCLKB/64
	WDT_WDTCR_CKS_0x4 = 0x4
	// PCLKB/128
	WDT_WDTCR_CKS_0xF = 0xf
	// PCLKB/512
	WDT_WDTCR_CKS_0x6 = 0x6
	// PCLKB/2048
	WDT_WDTCR_CKS_0x7 = 0x7
	// PCLKB/8192
	WDT_WDTCR_CKS_0x8 = 0x8
	// Position of RPES field.
	WDT_WDTCR_RPES_Pos = 0x8
	// Bit mask of RPES field.
	WDT_WDTCR_RPES_Msk = 0x300
	// 75%
	WDT_WDTCR_RPES_00 = 0x0
	// 50%
	WDT_WDTCR_RPES_01 = 0x1
	// 25%
	WDT_WDTCR_RPES_10 = 0x2
	// 0% (do not specify window end position).
	WDT_WDTCR_RPES_11 = 0x3
	// Position of RPSS field.
	WDT_WDTCR_RPSS_Pos = 0xc
	// Bit mask of RPSS field.
	WDT_WDTCR_RPSS_Msk = 0x3000
	// 25%
	WDT_WDTCR_RPSS_00 = 0x0
	// 50%
	WDT_WDTCR_RPSS_01 = 0x1
	// 75%
	WDT_WDTCR_RPSS_10 = 0x2
	// 100% (do not specify window start position).
	WDT_WDTCR_RPSS_11 = 0x3

	// WDTSR: WDT Status Register
	// Position of CNTVAL field.
	WDT_WDTSR_CNTVAL_Pos = 0x0
	// Bit mask of CNTVAL field.
	WDT_WDTSR_CNTVAL_Msk = 0x3fff
	// Position of UNDFF field.
	WDT_WDTSR_UNDFF_Pos = 0xe
	// Bit mask of UNDFF field.
	WDT_WDTSR_UNDFF_Msk = 0x4000
	// Bit UNDFF.
	WDT_WDTSR_UNDFF = 0x4000
	// No underflow occurred
	WDT_WDTSR_UNDFF_0 = 0x0
	// Underflow occurred
	WDT_WDTSR_UNDFF_1 = 0x1
	// Position of REFEF field.
	WDT_WDTSR_REFEF_Pos = 0xf
	// Bit mask of REFEF field.
	WDT_WDTSR_REFEF_Msk = 0x8000
	// Bit REFEF.
	WDT_WDTSR_REFEF = 0x8000
	// No refresh error occurred
	WDT_WDTSR_REFEF_0 = 0x0
	// Refresh error occurred
	WDT_WDTSR_REFEF_1 = 0x1

	// WDTRCR: WDT Reset Control Register
	// Position of RSTIRQS field.
	WDT_WDTRCR_RSTIRQS_Pos = 0x7
	// Bit mask of RSTIRQS field.
	WDT_WDTRCR_RSTIRQS_Msk = 0x80
	// Bit RSTIRQS.
	WDT_WDTRCR_RSTIRQS = 0x80
	// Interrupt
	WDT_WDTRCR_RSTIRQS_0 = 0x0
	// Reset
	WDT_WDTRCR_RSTIRQS_1 = 0x1

	// WDTCSTPR: WDT Count Stop Control Register
	// Position of SLCSTP field.
	WDT_WDTCSTPR_SLCSTP_Pos = 0x7
	// Bit mask of SLCSTP field.
	WDT_WDTCSTPR_SLCSTP_Msk = 0x80
	// Bit SLCSTP.
	WDT_WDTCSTPR_SLCSTP = 0x80
	// Disable count stop
	WDT_WDTCSTPR_SLCSTP_0 = 0x0
	// Stop count on transition to Sleep mode
	WDT_WDTCSTPR_SLCSTP_1 = 0x1
)

// Constants for IWDT: Independent Watchdog Timer
const (
	// IWDTSR: IWDT Status Register
	// Position of CNTVAL field.
	IWDT_IWDTSR_CNTVAL_Pos = 0x0
	// Bit mask of CNTVAL field.
	IWDT_IWDTSR_CNTVAL_Msk = 0x3fff
	// Position of UNDFF field.
	IWDT_IWDTSR_UNDFF_Pos = 0xe
	// Bit mask of UNDFF field.
	IWDT_IWDTSR_UNDFF_Msk = 0x4000
	// Bit UNDFF.
	IWDT_IWDTSR_UNDFF = 0x4000
	// No underflow occurred
	IWDT_IWDTSR_UNDFF_0 = 0x0
	// Underflow occurred
	IWDT_IWDTSR_UNDFF_1 = 0x1
	// Position of REFEF field.
	IWDT_IWDTSR_REFEF_Pos = 0xf
	// Bit mask of REFEF field.
	IWDT_IWDTSR_REFEF_Msk = 0x8000
	// Bit REFEF.
	IWDT_IWDTSR_REFEF = 0x8000
	// No refresh error occurred
	IWDT_IWDTSR_REFEF_0 = 0x0
	// Refresh error occurred
	IWDT_IWDTSR_REFEF_1 = 0x1
)

// Constants for CAC: Clock Frequency Accuracy Measurement Circuit
const (
	// CACR0: CAC Control Register 0
	// Position of CFME field.
	CAC_CACR0_CFME_Pos = 0x0
	// Bit mask of CFME field.
	CAC_CACR0_CFME_Msk = 0x1
	// Bit CFME.
	CAC_CACR0_CFME = 0x1
	// Disable
	CAC_CACR0_CFME_0 = 0x0
	// Enable
	CAC_CACR0_CFME_1 = 0x1

	// CACR1: CAC Control Register 1
	// Position of CACREFE field.
	CAC_CACR1_CACREFE_Pos = 0x0
	// Bit mask of CACREFE field.
	CAC_CACR1_CACREFE_Msk = 0x1
	// Bit CACREFE.
	CAC_CACR1_CACREFE = 0x1
	// Disable
	CAC_CACR1_CACREFE_0 = 0x0
	// Enable
	CAC_CACR1_CACREFE_1 = 0x1
	// Position of FMCS field.
	CAC_CACR1_FMCS_Pos = 0x1
	// Bit mask of FMCS field.
	CAC_CACR1_FMCS_Msk = 0xe
	// Setting prohibited
	CAC_CACR1_FMCS_000 = 0x0
	// Setting prohibited
	CAC_CACR1_FMCS_001 = 0x1
	// HOCO clock
	CAC_CACR1_FMCS_010 = 0x2
	// MOCO
	CAC_CACR1_FMCS_011 = 0x3
	// LOCO clock
	CAC_CACR1_FMCS_100 = 0x4
	// Peripheral module clock B (PCLKB)
	CAC_CACR1_FMCS_101 = 0x5
	// IWDT-dedicated clock
	CAC_CACR1_FMCS_110 = 0x6
	// Setting prohibited
	CAC_CACR1_FMCS_111 = 0x7
	// Position of TCSS field.
	CAC_CACR1_TCSS_Pos = 0x4
	// Bit mask of TCSS field.
	CAC_CACR1_TCSS_Msk = 0x30
	// No division
	CAC_CACR1_TCSS_00 = 0x0
	// x 1/4 clock
	CAC_CACR1_TCSS_01 = 0x1
	// x 1/8 clock
	CAC_CACR1_TCSS_10 = 0x2
	// x 1/32 clock
	CAC_CACR1_TCSS_11 = 0x3
	// Position of EDGES field.
	CAC_CACR1_EDGES_Pos = 0x6
	// Bit mask of EDGES field.
	CAC_CACR1_EDGES_Msk = 0xc0
	// Rising edge
	CAC_CACR1_EDGES_00 = 0x0
	// Falling edge
	CAC_CACR1_EDGES_01 = 0x1
	// Both rising and falling edges
	CAC_CACR1_EDGES_10 = 0x2
	// Setting prohibited
	CAC_CACR1_EDGES_11 = 0x3

	// CACR2: CAC Control Register 2
	// Position of RPS field.
	CAC_CACR2_RPS_Pos = 0x0
	// Bit mask of RPS field.
	CAC_CACR2_RPS_Msk = 0x1
	// Bit RPS.
	CAC_CACR2_RPS = 0x1
	// CACREF pin input
	CAC_CACR2_RPS_0 = 0x0
	// Internal clock (internally generated signal)
	CAC_CACR2_RPS_1 = 0x1
	// Position of RSCS field.
	CAC_CACR2_RSCS_Pos = 0x1
	// Bit mask of RSCS field.
	CAC_CACR2_RSCS_Msk = 0xe
	// Setting prohibited
	CAC_CACR2_RSCS_000 = 0x0
	// Setting prohibited
	CAC_CACR2_RSCS_001 = 0x1
	// HOCO clock
	CAC_CACR2_RSCS_010 = 0x2
	// MOCO
	CAC_CACR2_RSCS_011 = 0x3
	// LOCO clock
	CAC_CACR2_RSCS_100 = 0x4
	// Peripheral module clock B (PCLKB)
	CAC_CACR2_RSCS_101 = 0x5
	// IWDT-dedicated clock
	CAC_CACR2_RSCS_110 = 0x6
	// Setting prohibited
	CAC_CACR2_RSCS_111 = 0x7
	// Position of RCDS field.
	CAC_CACR2_RCDS_Pos = 0x4
	// Bit mask of RCDS field.
	CAC_CACR2_RCDS_Msk = 0x30
	// x 1/32 clock
	CAC_CACR2_RCDS_00 = 0x0
	// x 1/128 clock
	CAC_CACR2_RCDS_01 = 0x1
	// x 1/1024 clock
	CAC_CACR2_RCDS_10 = 0x2
	// x 1/8192 clock
	CAC_CACR2_RCDS_11 = 0x3
	// Position of DFS field.
	CAC_CACR2_DFS_Pos = 0x6
	// Bit mask of DFS field.
	CAC_CACR2_DFS_Msk = 0xc0
	// Disable digital filtering
	CAC_CACR2_DFS_00 = 0x0
	// Use sampling clock for the digital filter as the frequency measuring clock
	CAC_CACR2_DFS_01 = 0x1
	// Use sampling clock for the digital filter as the frequency measuring clock divided by 4
	CAC_CACR2_DFS_10 = 0x2
	// Use sampling clock for the digital filter as the frequency measuring clock divided by 16.
	CAC_CACR2_DFS_11 = 0x3

	// CAICR: CAC Interrupt Control Register
	// Position of FERRIE field.
	CAC_CAICR_FERRIE_Pos = 0x0
	// Bit mask of FERRIE field.
	CAC_CAICR_FERRIE_Msk = 0x1
	// Bit FERRIE.
	CAC_CAICR_FERRIE = 0x1
	// Disable
	CAC_CAICR_FERRIE_0 = 0x0
	// Enable
	CAC_CAICR_FERRIE_1 = 0x1
	// Position of MENDIE field.
	CAC_CAICR_MENDIE_Pos = 0x1
	// Bit mask of MENDIE field.
	CAC_CAICR_MENDIE_Msk = 0x2
	// Bit MENDIE.
	CAC_CAICR_MENDIE = 0x2
	// Disable
	CAC_CAICR_MENDIE_0 = 0x0
	// Enable
	CAC_CAICR_MENDIE_1 = 0x1
	// Position of OVFIE field.
	CAC_CAICR_OVFIE_Pos = 0x2
	// Bit mask of OVFIE field.
	CAC_CAICR_OVFIE_Msk = 0x4
	// Bit OVFIE.
	CAC_CAICR_OVFIE = 0x4
	// Disable
	CAC_CAICR_OVFIE_0 = 0x0
	// Enable
	CAC_CAICR_OVFIE_1 = 0x1
	// Position of FERRFCL field.
	CAC_CAICR_FERRFCL_Pos = 0x4
	// Bit mask of FERRFCL field.
	CAC_CAICR_FERRFCL_Msk = 0x10
	// Bit FERRFCL.
	CAC_CAICR_FERRFCL = 0x10
	// No effect
	CAC_CAICR_FERRFCL_0 = 0x0
	// The CASTR.FERRF flag is cleared
	CAC_CAICR_FERRFCL_1 = 0x1
	// Position of MENDFCL field.
	CAC_CAICR_MENDFCL_Pos = 0x5
	// Bit mask of MENDFCL field.
	CAC_CAICR_MENDFCL_Msk = 0x20
	// Bit MENDFCL.
	CAC_CAICR_MENDFCL = 0x20
	// No effect
	CAC_CAICR_MENDFCL_0 = 0x0
	// The CASTR.MENDF flag is cleared
	CAC_CAICR_MENDFCL_1 = 0x1
	// Position of OVFFCL field.
	CAC_CAICR_OVFFCL_Pos = 0x6
	// Bit mask of OVFFCL field.
	CAC_CAICR_OVFFCL_Msk = 0x40
	// Bit OVFFCL.
	CAC_CAICR_OVFFCL = 0x40
	// No effect
	CAC_CAICR_OVFFCL_0 = 0x0
	// The CASTR.OVFF flag is cleared.
	CAC_CAICR_OVFFCL_1 = 0x1

	// CASTR: CAC Status Register
	// Position of FERRF field.
	CAC_CASTR_FERRF_Pos = 0x0
	// Bit mask of FERRF field.
	CAC_CASTR_FERRF_Msk = 0x1
	// Bit FERRF.
	CAC_CASTR_FERRF = 0x1
	// Clock frequency is within the allowable range
	CAC_CASTR_FERRF_0 = 0x0
	// Clock frequency has deviated beyond the allowable range (frequency error).
	CAC_CASTR_FERRF_1 = 0x1
	// Position of MENDF field.
	CAC_CASTR_MENDF_Pos = 0x1
	// Bit mask of MENDF field.
	CAC_CASTR_MENDF_Msk = 0x2
	// Bit MENDF.
	CAC_CASTR_MENDF = 0x2
	// Measurement is in progress
	CAC_CASTR_MENDF_0 = 0x0
	// Measurement ended
	CAC_CASTR_MENDF_1 = 0x1
	// Position of OVFF field.
	CAC_CASTR_OVFF_Pos = 0x2
	// Bit mask of OVFF field.
	CAC_CASTR_OVFF_Msk = 0x4
	// Bit OVFF.
	CAC_CASTR_OVFF = 0x4
	// Counter has not overflowed
	CAC_CASTR_OVFF_0 = 0x0
	// Counter overflowed
	CAC_CASTR_OVFF_1 = 0x1
)

// Constants for MSTP: Module Stop Control B, C, D
const (
	// MSTPCRB: Module Stop Control Register B
	// Position of MSTPB9 field.
	MSTP_MSTPCRB_MSTPB9_Pos = 0x9
	// Bit mask of MSTPB9 field.
	MSTP_MSTPCRB_MSTPB9_Msk = 0x200
	// Bit MSTPB9.
	MSTP_MSTPCRB_MSTPB9 = 0x200
	// Cancel the module-stop state
	MSTP_MSTPCRB_MSTPB9_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRB_MSTPB9_1 = 0x1
	// Position of MSTPB19 field.
	MSTP_MSTPCRB_MSTPB19_Pos = 0x13
	// Bit mask of MSTPB19 field.
	MSTP_MSTPCRB_MSTPB19_Msk = 0x80000
	// Bit MSTPB19.
	MSTP_MSTPCRB_MSTPB19 = 0x80000
	// Cancel the module-stop state
	MSTP_MSTPCRB_MSTPB19_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRB_MSTPB19_1 = 0x1
	// Position of MSTPB22 field.
	MSTP_MSTPCRB_MSTPB22_Pos = 0x16
	// Bit mask of MSTPB22 field.
	MSTP_MSTPCRB_MSTPB22_Msk = 0x400000
	// Bit MSTPB22.
	MSTP_MSTPCRB_MSTPB22 = 0x400000
	// Cancel the module-stop state
	MSTP_MSTPCRB_MSTPB22_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRB_MSTPB22_1 = 0x1

	// MSTPCRC: Module Stop Control Register C
	// Position of MSTPC0 field.
	MSTP_MSTPCRC_MSTPC0_Pos = 0x0
	// Bit mask of MSTPC0 field.
	MSTP_MSTPCRC_MSTPC0_Msk = 0x1
	// Bit MSTPC0.
	MSTP_MSTPCRC_MSTPC0 = 0x1
	// Cancel the module-stop state
	MSTP_MSTPCRC_MSTPC0_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRC_MSTPC0_1 = 0x1
	// Position of MSTPC1 field.
	MSTP_MSTPCRC_MSTPC1_Pos = 0x1
	// Bit mask of MSTPC1 field.
	MSTP_MSTPCRC_MSTPC1_Msk = 0x2
	// Bit MSTPC1.
	MSTP_MSTPCRC_MSTPC1 = 0x2
	// Cancel the module-stop state
	MSTP_MSTPCRC_MSTPC1_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRC_MSTPC1_1 = 0x1
	// Position of MSTPC13 field.
	MSTP_MSTPCRC_MSTPC13_Pos = 0xd
	// Bit mask of MSTPC13 field.
	MSTP_MSTPCRC_MSTPC13_Msk = 0x2000
	// Bit MSTPC13.
	MSTP_MSTPCRC_MSTPC13 = 0x2000
	// Cancel the module-stop state
	MSTP_MSTPCRC_MSTPC13_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRC_MSTPC13_1 = 0x1
	// Position of MSTPC14 field.
	MSTP_MSTPCRC_MSTPC14_Pos = 0xe
	// Bit mask of MSTPC14 field.
	MSTP_MSTPCRC_MSTPC14_Msk = 0x4000
	// Bit MSTPC14.
	MSTP_MSTPCRC_MSTPC14 = 0x4000
	// Cancel the module-stop state
	MSTP_MSTPCRC_MSTPC14_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRC_MSTPC14_1 = 0x1
	// Position of MSTPC28 field.
	MSTP_MSTPCRC_MSTPC28_Pos = 0x1c
	// Bit mask of MSTPC28 field.
	MSTP_MSTPCRC_MSTPC28_Msk = 0x10000000
	// Bit MSTPC28.
	MSTP_MSTPCRC_MSTPC28 = 0x10000000
	// Cancel the module-stop state
	MSTP_MSTPCRC_MSTPC28_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRC_MSTPC28_1 = 0x1
	// Position of MSTPC31 field.
	MSTP_MSTPCRC_MSTPC31_Pos = 0x1f
	// Bit mask of MSTPC31 field.
	MSTP_MSTPCRC_MSTPC31_Msk = 0x80000000
	// Bit MSTPC31.
	MSTP_MSTPCRC_MSTPC31 = 0x80000000
	// Cancel the module-stop state
	MSTP_MSTPCRC_MSTPC31_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRC_MSTPC31_1 = 0x1

	// MSTPCRD: Module Stop Control Register D
	// Position of MSTPD2 field.
	MSTP_MSTPCRD_MSTPD2_Pos = 0x2
	// Bit mask of MSTPD2 field.
	MSTP_MSTPCRD_MSTPD2_Msk = 0x4
	// Bit MSTPD2.
	MSTP_MSTPCRD_MSTPD2 = 0x4
	// Cancel the module-stop state
	MSTP_MSTPCRD_MSTPD2_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRD_MSTPD2_1 = 0x1
	// Position of MSTPD3 field.
	MSTP_MSTPCRD_MSTPD3_Pos = 0x3
	// Bit mask of MSTPD3 field.
	MSTP_MSTPCRD_MSTPD3_Msk = 0x8
	// Bit MSTPD3.
	MSTP_MSTPCRD_MSTPD3 = 0x8
	// Cancel the module-stop state
	MSTP_MSTPCRD_MSTPD3_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRD_MSTPD3_1 = 0x1
	// Position of MSTPD6 field.
	MSTP_MSTPCRD_MSTPD6_Pos = 0x6
	// Bit mask of MSTPD6 field.
	MSTP_MSTPCRD_MSTPD6_Msk = 0x40
	// Bit MSTPD6.
	MSTP_MSTPCRD_MSTPD6 = 0x40
	// Cancel the module-stop state
	MSTP_MSTPCRD_MSTPD6_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRD_MSTPD6_1 = 0x1
	// Position of MSTPD14 field.
	MSTP_MSTPCRD_MSTPD14_Pos = 0xe
	// Bit mask of MSTPD14 field.
	MSTP_MSTPCRD_MSTPD14_Msk = 0x4000
	// Bit MSTPD14.
	MSTP_MSTPCRD_MSTPD14 = 0x4000
	// Cancel the module-stop state
	MSTP_MSTPCRD_MSTPD14_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRD_MSTPD14_1 = 0x1
	// Position of MSTPD16 field.
	MSTP_MSTPCRD_MSTPD16_Pos = 0x10
	// Bit mask of MSTPD16 field.
	MSTP_MSTPCRD_MSTPD16_Msk = 0x10000
	// Bit MSTPD16.
	MSTP_MSTPCRD_MSTPD16 = 0x10000
	// Cancel the module-stop state
	MSTP_MSTPCRD_MSTPD16_0 = 0x0
	// Enter the module-stop state
	MSTP_MSTPCRD_MSTPD16_1 = 0x1

	// LSMRWDIS: Low Speed Module R/W Disable Control Register
	// Position of WDTDIS field.
	MSTP_LSMRWDIS_WDTDIS_Pos = 0x1
	// Bit mask of WDTDIS field.
	MSTP_LSMRWDIS_WDTDIS_Msk = 0x2
	// Bit WDTDIS.
	MSTP_LSMRWDIS_WDTDIS = 0x2
	// WDT operates as normal
	MSTP_LSMRWDIS_WDTDIS_0 = 0x0
	// Stop the WDT clock and register R/W clock
	MSTP_LSMRWDIS_WDTDIS_1 = 0x1
	// Position of IWDTIDS field.
	MSTP_LSMRWDIS_IWDTIDS_Pos = 0x2
	// Bit mask of IWDTIDS field.
	MSTP_LSMRWDIS_IWDTIDS_Msk = 0x4
	// Bit IWDTIDS.
	MSTP_LSMRWDIS_IWDTIDS = 0x4
	// IWDT operates as normal
	MSTP_LSMRWDIS_IWDTIDS_0 = 0x0
	// Stop the IWDT register R/W clock
	MSTP_LSMRWDIS_IWDTIDS_1 = 0x1
	// Position of WREN field.
	MSTP_LSMRWDIS_WREN_Pos = 0x7
	// Bit mask of WREN field.
	MSTP_LSMRWDIS_WREN_Msk = 0x80
	// Bit WREN.
	MSTP_LSMRWDIS_WREN = 0x80
	// Write protect for bits [2:0]
	MSTP_LSMRWDIS_WREN_0 = 0x0
	// Write enable for bits [2:0]
	MSTP_LSMRWDIS_WREN_1 = 0x1
	// Position of PRKEY field.
	MSTP_LSMRWDIS_PRKEY_Pos = 0x8
	// Bit mask of PRKEY field.
	MSTP_LSMRWDIS_PRKEY_Msk = 0xff00
)

// Constants for DOC: Data Operation Circuit
const (
	// DOCR: DOC Control Register
	// Position of OMS field.
	DOC_DOCR_OMS_Pos = 0x0
	// Bit mask of OMS field.
	DOC_DOCR_OMS_Msk = 0x3
	// Data comparison mode
	DOC_DOCR_OMS_00 = 0x0
	// Data addition mode
	DOC_DOCR_OMS_01 = 0x1
	// Data subtraction mode
	DOC_DOCR_OMS_10 = 0x2
	// Setting prohibited
	DOC_DOCR_OMS_11 = 0x3
	// Position of DCSEL field.
	DOC_DOCR_DCSEL_Pos = 0x2
	// Bit mask of DCSEL field.
	DOC_DOCR_DCSEL_Msk = 0x4
	// Bit DCSEL.
	DOC_DOCR_DCSEL = 0x4
	// Set DOPCF flag when data mismatch is detected
	DOC_DOCR_DCSEL_0 = 0x0
	// Set DOPCF flag when data match is detected
	DOC_DOCR_DCSEL_1 = 0x1
	// Position of DOPCF field.
	DOC_DOCR_DOPCF_Pos = 0x5
	// Bit mask of DOPCF field.
	DOC_DOCR_DOPCF_Msk = 0x20
	// Bit DOPCF.
	DOC_DOCR_DOPCF = 0x20
	// Position of DOPCFCL field.
	DOC_DOCR_DOPCFCL_Pos = 0x6
	// Bit mask of DOPCFCL field.
	DOC_DOCR_DOPCFCL_Msk = 0x40
	// Bit DOPCFCL.
	DOC_DOCR_DOPCFCL = 0x40
	// Retain DOPCF flag state
	DOC_DOCR_DOPCFCL_0 = 0x0
	// Clear DOPCF flag
	DOC_DOCR_DOPCFCL_1 = 0x1
)

// Constants for ADC120: 12-bit A/D Converter
const (
	// ADCSR: A/D Control Register
	// Position of DBLANS field.
	ADC120_ADCSR_DBLANS_Pos = 0x0
	// Bit mask of DBLANS field.
	ADC120_ADCSR_DBLANS_Msk = 0x1f
	// Position of GBADIE field.
	ADC120_ADCSR_GBADIE_Pos = 0x6
	// Bit mask of GBADIE field.
	ADC120_ADCSR_GBADIE_Msk = 0x40
	// Bit GBADIE.
	ADC120_ADCSR_GBADIE = 0x40
	// Disable ADC120_GBADI interrupt generation on group B scan completion.
	ADC120_ADCSR_GBADIE_0 = 0x0
	// Enable ADC120_GBADI interrupt generation on group B scan completion.
	ADC120_ADCSR_GBADIE_1 = 0x1
	// Position of DBLE field.
	ADC120_ADCSR_DBLE_Pos = 0x7
	// Bit mask of DBLE field.
	ADC120_ADCSR_DBLE_Msk = 0x80
	// Bit DBLE.
	ADC120_ADCSR_DBLE = 0x80
	// Deselect double-trigger mode.
	ADC120_ADCSR_DBLE_0 = 0x0
	// Select double-trigger mode.
	ADC120_ADCSR_DBLE_1 = 0x1
	// Position of EXTRG field.
	ADC120_ADCSR_EXTRG_Pos = 0x8
	// Bit mask of EXTRG field.
	ADC120_ADCSR_EXTRG_Msk = 0x100
	// Bit EXTRG.
	ADC120_ADCSR_EXTRG = 0x100
	// Start A/D conversion by the synchronous trigger (ELC).
	ADC120_ADCSR_EXTRG_0 = 0x0
	// Start A/D conversion by the asynchronous trigger (ADTRG0).
	ADC120_ADCSR_EXTRG_1 = 0x1
	// Position of TRGE field.
	ADC120_ADCSR_TRGE_Pos = 0x9
	// Bit mask of TRGE field.
	ADC120_ADCSR_TRGE_Msk = 0x200
	// Bit TRGE.
	ADC120_ADCSR_TRGE = 0x200
	// Disable A/D conversion to be started by the synchronous or asynchronous trigger
	ADC120_ADCSR_TRGE_0 = 0x0
	// Enable A/D conversion to be started by the synchronous or asynchronous trigger
	ADC120_ADCSR_TRGE_1 = 0x1
	// Position of ADHSC field.
	ADC120_ADCSR_ADHSC_Pos = 0xa
	// Bit mask of ADHSC field.
	ADC120_ADCSR_ADHSC_Msk = 0x400
	// Bit ADHSC.
	ADC120_ADCSR_ADHSC = 0x400
	// High-speed A/D conversion mode
	ADC120_ADCSR_ADHSC_0 = 0x0
	// Low-power A/D conversion mode
	ADC120_ADCSR_ADHSC_1 = 0x1
	// Position of ADCS field.
	ADC120_ADCSR_ADCS_Pos = 0xd
	// Bit mask of ADCS field.
	ADC120_ADCSR_ADCS_Msk = 0x6000
	// Single scan mode
	ADC120_ADCSR_ADCS_00 = 0x0
	// Group scan mode
	ADC120_ADCSR_ADCS_01 = 0x1
	// Continuous scan mode
	ADC120_ADCSR_ADCS_10 = 0x2
	// Setting prohibited
	ADC120_ADCSR_ADCS_11 = 0x3
	// Position of ADST field.
	ADC120_ADCSR_ADST_Pos = 0xf
	// Bit mask of ADST field.
	ADC120_ADCSR_ADST_Msk = 0x8000
	// Bit ADST.
	ADC120_ADCSR_ADST = 0x8000
	// Stop A/D conversion process.
	ADC120_ADCSR_ADST_0 = 0x0
	// Start A/D conversion process.
	ADC120_ADCSR_ADST_1 = 0x1

	// ADANSA0: A/D Channel Select Register A0
	// Position of ANSA00 field.
	ADC120_ADANSA0_ANSA00_Pos = 0x0
	// Bit mask of ANSA00 field.
	ADC120_ADANSA0_ANSA00_Msk = 0x1
	// Bit ANSA00.
	ADC120_ADANSA0_ANSA00 = 0x1
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA00_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA00_1 = 0x1
	// Position of ANSA01 field.
	ADC120_ADANSA0_ANSA01_Pos = 0x1
	// Bit mask of ANSA01 field.
	ADC120_ADANSA0_ANSA01_Msk = 0x2
	// Bit ANSA01.
	ADC120_ADANSA0_ANSA01 = 0x2
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA01_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA01_1 = 0x1
	// Position of ANSA02 field.
	ADC120_ADANSA0_ANSA02_Pos = 0x2
	// Bit mask of ANSA02 field.
	ADC120_ADANSA0_ANSA02_Msk = 0x4
	// Bit ANSA02.
	ADC120_ADANSA0_ANSA02 = 0x4
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA02_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA02_1 = 0x1
	// Position of ANSA03 field.
	ADC120_ADANSA0_ANSA03_Pos = 0x3
	// Bit mask of ANSA03 field.
	ADC120_ADANSA0_ANSA03_Msk = 0x8
	// Bit ANSA03.
	ADC120_ADANSA0_ANSA03 = 0x8
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA03_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA03_1 = 0x1
	// Position of ANSA04 field.
	ADC120_ADANSA0_ANSA04_Pos = 0x4
	// Bit mask of ANSA04 field.
	ADC120_ADANSA0_ANSA04_Msk = 0x10
	// Bit ANSA04.
	ADC120_ADANSA0_ANSA04 = 0x10
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA04_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA04_1 = 0x1
	// Position of ANSA05 field.
	ADC120_ADANSA0_ANSA05_Pos = 0x5
	// Bit mask of ANSA05 field.
	ADC120_ADANSA0_ANSA05_Msk = 0x20
	// Bit ANSA05.
	ADC120_ADANSA0_ANSA05 = 0x20
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA05_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA05_1 = 0x1
	// Position of ANSA06 field.
	ADC120_ADANSA0_ANSA06_Pos = 0x6
	// Bit mask of ANSA06 field.
	ADC120_ADANSA0_ANSA06_Msk = 0x40
	// Bit ANSA06.
	ADC120_ADANSA0_ANSA06 = 0x40
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA06_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA06_1 = 0x1
	// Position of ANSA07 field.
	ADC120_ADANSA0_ANSA07_Pos = 0x7
	// Bit mask of ANSA07 field.
	ADC120_ADANSA0_ANSA07_Msk = 0x80
	// Bit ANSA07.
	ADC120_ADANSA0_ANSA07 = 0x80
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA07_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA07_1 = 0x1
	// Position of ANSA08 field.
	ADC120_ADANSA0_ANSA08_Pos = 0x8
	// Bit mask of ANSA08 field.
	ADC120_ADANSA0_ANSA08_Msk = 0x100
	// Bit ANSA08.
	ADC120_ADANSA0_ANSA08 = 0x100
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA08_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA08_1 = 0x1
	// Position of ANSA09 field.
	ADC120_ADANSA0_ANSA09_Pos = 0x9
	// Bit mask of ANSA09 field.
	ADC120_ADANSA0_ANSA09_Msk = 0x200
	// Bit ANSA09.
	ADC120_ADANSA0_ANSA09 = 0x200
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA09_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA09_1 = 0x1
	// Position of ANSA10 field.
	ADC120_ADANSA0_ANSA10_Pos = 0xa
	// Bit mask of ANSA10 field.
	ADC120_ADANSA0_ANSA10_Msk = 0x400
	// Bit ANSA10.
	ADC120_ADANSA0_ANSA10 = 0x400
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA10_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA10_1 = 0x1
	// Position of ANSA11 field.
	ADC120_ADANSA0_ANSA11_Pos = 0xb
	// Bit mask of ANSA11 field.
	ADC120_ADANSA0_ANSA11_Msk = 0x800
	// Bit ANSA11.
	ADC120_ADANSA0_ANSA11 = 0x800
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA11_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA11_1 = 0x1
	// Position of ANSA12 field.
	ADC120_ADANSA0_ANSA12_Pos = 0xc
	// Bit mask of ANSA12 field.
	ADC120_ADANSA0_ANSA12_Msk = 0x1000
	// Bit ANSA12.
	ADC120_ADANSA0_ANSA12 = 0x1000
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA12_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA12_1 = 0x1
	// Position of ANSA13 field.
	ADC120_ADANSA0_ANSA13_Pos = 0xd
	// Bit mask of ANSA13 field.
	ADC120_ADANSA0_ANSA13_Msk = 0x2000
	// Bit ANSA13.
	ADC120_ADANSA0_ANSA13 = 0x2000
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA13_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA13_1 = 0x1
	// Position of ANSA14 field.
	ADC120_ADANSA0_ANSA14_Pos = 0xe
	// Bit mask of ANSA14 field.
	ADC120_ADANSA0_ANSA14_Msk = 0x4000
	// Bit ANSA14.
	ADC120_ADANSA0_ANSA14 = 0x4000
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA14_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA14_1 = 0x1
	// Position of ANSA15 field.
	ADC120_ADANSA0_ANSA15_Pos = 0xf
	// Bit mask of ANSA15 field.
	ADC120_ADANSA0_ANSA15_Msk = 0x8000
	// Bit ANSA15.
	ADC120_ADANSA0_ANSA15 = 0x8000
	// Do not select associated input channel.
	ADC120_ADANSA0_ANSA15_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA0_ANSA15_1 = 0x1

	// ADANSA1: A/D Channel Select Register A1
	// Position of ANSA16 field.
	ADC120_ADANSA1_ANSA16_Pos = 0x0
	// Bit mask of ANSA16 field.
	ADC120_ADANSA1_ANSA16_Msk = 0x1
	// Bit ANSA16.
	ADC120_ADANSA1_ANSA16 = 0x1
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA16_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA16_1 = 0x1
	// Position of ANSA17 field.
	ADC120_ADANSA1_ANSA17_Pos = 0x1
	// Bit mask of ANSA17 field.
	ADC120_ADANSA1_ANSA17_Msk = 0x2
	// Bit ANSA17.
	ADC120_ADANSA1_ANSA17 = 0x2
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA17_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA17_1 = 0x1
	// Position of ANSA18 field.
	ADC120_ADANSA1_ANSA18_Pos = 0x2
	// Bit mask of ANSA18 field.
	ADC120_ADANSA1_ANSA18_Msk = 0x4
	// Bit ANSA18.
	ADC120_ADANSA1_ANSA18 = 0x4
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA18_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA18_1 = 0x1
	// Position of ANSA19 field.
	ADC120_ADANSA1_ANSA19_Pos = 0x3
	// Bit mask of ANSA19 field.
	ADC120_ADANSA1_ANSA19_Msk = 0x8
	// Bit ANSA19.
	ADC120_ADANSA1_ANSA19 = 0x8
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA19_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA19_1 = 0x1
	// Position of ANSA20 field.
	ADC120_ADANSA1_ANSA20_Pos = 0x4
	// Bit mask of ANSA20 field.
	ADC120_ADANSA1_ANSA20_Msk = 0x10
	// Bit ANSA20.
	ADC120_ADANSA1_ANSA20 = 0x10
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA20_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA20_1 = 0x1
	// Position of ANSA21 field.
	ADC120_ADANSA1_ANSA21_Pos = 0x5
	// Bit mask of ANSA21 field.
	ADC120_ADANSA1_ANSA21_Msk = 0x20
	// Bit ANSA21.
	ADC120_ADANSA1_ANSA21 = 0x20
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA21_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA21_1 = 0x1
	// Position of ANSA22 field.
	ADC120_ADANSA1_ANSA22_Pos = 0x6
	// Bit mask of ANSA22 field.
	ADC120_ADANSA1_ANSA22_Msk = 0x40
	// Bit ANSA22.
	ADC120_ADANSA1_ANSA22 = 0x40
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA22_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA22_1 = 0x1
	// Position of ANSA23 field.
	ADC120_ADANSA1_ANSA23_Pos = 0x7
	// Bit mask of ANSA23 field.
	ADC120_ADANSA1_ANSA23_Msk = 0x80
	// Bit ANSA23.
	ADC120_ADANSA1_ANSA23 = 0x80
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA23_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA23_1 = 0x1
	// Position of ANSA24 field.
	ADC120_ADANSA1_ANSA24_Pos = 0x8
	// Bit mask of ANSA24 field.
	ADC120_ADANSA1_ANSA24_Msk = 0x100
	// Bit ANSA24.
	ADC120_ADANSA1_ANSA24 = 0x100
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA24_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA24_1 = 0x1
	// Position of ANSA25 field.
	ADC120_ADANSA1_ANSA25_Pos = 0x9
	// Bit mask of ANSA25 field.
	ADC120_ADANSA1_ANSA25_Msk = 0x200
	// Bit ANSA25.
	ADC120_ADANSA1_ANSA25 = 0x200
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA25_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA25_1 = 0x1
	// Position of ANSA26 field.
	ADC120_ADANSA1_ANSA26_Pos = 0xa
	// Bit mask of ANSA26 field.
	ADC120_ADANSA1_ANSA26_Msk = 0x400
	// Bit ANSA26.
	ADC120_ADANSA1_ANSA26 = 0x400
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA26_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA26_1 = 0x1
	// Position of ANSA27 field.
	ADC120_ADANSA1_ANSA27_Pos = 0xb
	// Bit mask of ANSA27 field.
	ADC120_ADANSA1_ANSA27_Msk = 0x800
	// Bit ANSA27.
	ADC120_ADANSA1_ANSA27 = 0x800
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA27_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA27_1 = 0x1
	// Position of ANSA28 field.
	ADC120_ADANSA1_ANSA28_Pos = 0xc
	// Bit mask of ANSA28 field.
	ADC120_ADANSA1_ANSA28_Msk = 0x1000
	// Bit ANSA28.
	ADC120_ADANSA1_ANSA28 = 0x1000
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA28_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA28_1 = 0x1
	// Position of ANSA29 field.
	ADC120_ADANSA1_ANSA29_Pos = 0xd
	// Bit mask of ANSA29 field.
	ADC120_ADANSA1_ANSA29_Msk = 0x2000
	// Bit ANSA29.
	ADC120_ADANSA1_ANSA29 = 0x2000
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA29_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA29_1 = 0x1
	// Position of ANSA30 field.
	ADC120_ADANSA1_ANSA30_Pos = 0xe
	// Bit mask of ANSA30 field.
	ADC120_ADANSA1_ANSA30_Msk = 0x4000
	// Bit ANSA30.
	ADC120_ADANSA1_ANSA30 = 0x4000
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA30_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA30_1 = 0x1
	// Position of ANSA31 field.
	ADC120_ADANSA1_ANSA31_Pos = 0xf
	// Bit mask of ANSA31 field.
	ADC120_ADANSA1_ANSA31_Msk = 0x8000
	// Bit ANSA31.
	ADC120_ADANSA1_ANSA31 = 0x8000
	// Do not select associated input channel.
	ADC120_ADANSA1_ANSA31_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSA1_ANSA31_1 = 0x1

	// ADADS0: A/D-Converted Value Addition/Average Channel Select Register 0
	// Position of ADS00 field.
	ADC120_ADADS0_ADS00_Pos = 0x0
	// Bit mask of ADS00 field.
	ADC120_ADADS0_ADS00_Msk = 0x1
	// Bit ADS00.
	ADC120_ADADS0_ADS00 = 0x1
	// Do not select associated input channel.
	ADC120_ADADS0_ADS00_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS00_1 = 0x1
	// Position of ADS01 field.
	ADC120_ADADS0_ADS01_Pos = 0x1
	// Bit mask of ADS01 field.
	ADC120_ADADS0_ADS01_Msk = 0x2
	// Bit ADS01.
	ADC120_ADADS0_ADS01 = 0x2
	// Do not select associated input channel.
	ADC120_ADADS0_ADS01_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS01_1 = 0x1
	// Position of ADS02 field.
	ADC120_ADADS0_ADS02_Pos = 0x2
	// Bit mask of ADS02 field.
	ADC120_ADADS0_ADS02_Msk = 0x4
	// Bit ADS02.
	ADC120_ADADS0_ADS02 = 0x4
	// Do not select associated input channel.
	ADC120_ADADS0_ADS02_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS02_1 = 0x1
	// Position of ADS03 field.
	ADC120_ADADS0_ADS03_Pos = 0x3
	// Bit mask of ADS03 field.
	ADC120_ADADS0_ADS03_Msk = 0x8
	// Bit ADS03.
	ADC120_ADADS0_ADS03 = 0x8
	// Do not select associated input channel.
	ADC120_ADADS0_ADS03_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS03_1 = 0x1
	// Position of ADS04 field.
	ADC120_ADADS0_ADS04_Pos = 0x4
	// Bit mask of ADS04 field.
	ADC120_ADADS0_ADS04_Msk = 0x10
	// Bit ADS04.
	ADC120_ADADS0_ADS04 = 0x10
	// Do not select associated input channel.
	ADC120_ADADS0_ADS04_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS04_1 = 0x1
	// Position of ADS05 field.
	ADC120_ADADS0_ADS05_Pos = 0x5
	// Bit mask of ADS05 field.
	ADC120_ADADS0_ADS05_Msk = 0x20
	// Bit ADS05.
	ADC120_ADADS0_ADS05 = 0x20
	// Do not select associated input channel.
	ADC120_ADADS0_ADS05_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS05_1 = 0x1
	// Position of ADS06 field.
	ADC120_ADADS0_ADS06_Pos = 0x6
	// Bit mask of ADS06 field.
	ADC120_ADADS0_ADS06_Msk = 0x40
	// Bit ADS06.
	ADC120_ADADS0_ADS06 = 0x40
	// Do not select associated input channel.
	ADC120_ADADS0_ADS06_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS06_1 = 0x1
	// Position of ADS07 field.
	ADC120_ADADS0_ADS07_Pos = 0x7
	// Bit mask of ADS07 field.
	ADC120_ADADS0_ADS07_Msk = 0x80
	// Bit ADS07.
	ADC120_ADADS0_ADS07 = 0x80
	// Do not select associated input channel.
	ADC120_ADADS0_ADS07_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS07_1 = 0x1
	// Position of ADS08 field.
	ADC120_ADADS0_ADS08_Pos = 0x8
	// Bit mask of ADS08 field.
	ADC120_ADADS0_ADS08_Msk = 0x100
	// Bit ADS08.
	ADC120_ADADS0_ADS08 = 0x100
	// Do not select associated input channel.
	ADC120_ADADS0_ADS08_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS08_1 = 0x1
	// Position of ADS09 field.
	ADC120_ADADS0_ADS09_Pos = 0x9
	// Bit mask of ADS09 field.
	ADC120_ADADS0_ADS09_Msk = 0x200
	// Bit ADS09.
	ADC120_ADADS0_ADS09 = 0x200
	// Do not select associated input channel.
	ADC120_ADADS0_ADS09_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS09_1 = 0x1
	// Position of ADS10 field.
	ADC120_ADADS0_ADS10_Pos = 0xa
	// Bit mask of ADS10 field.
	ADC120_ADADS0_ADS10_Msk = 0x400
	// Bit ADS10.
	ADC120_ADADS0_ADS10 = 0x400
	// Do not select associated input channel.
	ADC120_ADADS0_ADS10_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS10_1 = 0x1
	// Position of ADS11 field.
	ADC120_ADADS0_ADS11_Pos = 0xb
	// Bit mask of ADS11 field.
	ADC120_ADADS0_ADS11_Msk = 0x800
	// Bit ADS11.
	ADC120_ADADS0_ADS11 = 0x800
	// Do not select associated input channel.
	ADC120_ADADS0_ADS11_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS11_1 = 0x1
	// Position of ADS12 field.
	ADC120_ADADS0_ADS12_Pos = 0xc
	// Bit mask of ADS12 field.
	ADC120_ADADS0_ADS12_Msk = 0x1000
	// Bit ADS12.
	ADC120_ADADS0_ADS12 = 0x1000
	// Do not select associated input channel.
	ADC120_ADADS0_ADS12_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS12_1 = 0x1
	// Position of ADS13 field.
	ADC120_ADADS0_ADS13_Pos = 0xd
	// Bit mask of ADS13 field.
	ADC120_ADADS0_ADS13_Msk = 0x2000
	// Bit ADS13.
	ADC120_ADADS0_ADS13 = 0x2000
	// Do not select associated input channel.
	ADC120_ADADS0_ADS13_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS13_1 = 0x1
	// Position of ADS14 field.
	ADC120_ADADS0_ADS14_Pos = 0xe
	// Bit mask of ADS14 field.
	ADC120_ADADS0_ADS14_Msk = 0x4000
	// Bit ADS14.
	ADC120_ADADS0_ADS14 = 0x4000
	// Do not select associated input channel.
	ADC120_ADADS0_ADS14_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS14_1 = 0x1
	// Position of ADS15 field.
	ADC120_ADADS0_ADS15_Pos = 0xf
	// Bit mask of ADS15 field.
	ADC120_ADADS0_ADS15_Msk = 0x8000
	// Bit ADS15.
	ADC120_ADADS0_ADS15 = 0x8000
	// Do not select associated input channel.
	ADC120_ADADS0_ADS15_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS0_ADS15_1 = 0x1

	// ADADS1: A/D-Converted Value Addition/Average Channel Select Register 1
	// Position of ADS16 field.
	ADC120_ADADS1_ADS16_Pos = 0x0
	// Bit mask of ADS16 field.
	ADC120_ADADS1_ADS16_Msk = 0x1
	// Bit ADS16.
	ADC120_ADADS1_ADS16 = 0x1
	// Do not select associated input channel.
	ADC120_ADADS1_ADS16_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS16_1 = 0x1
	// Position of ADS17 field.
	ADC120_ADADS1_ADS17_Pos = 0x1
	// Bit mask of ADS17 field.
	ADC120_ADADS1_ADS17_Msk = 0x2
	// Bit ADS17.
	ADC120_ADADS1_ADS17 = 0x2
	// Do not select associated input channel.
	ADC120_ADADS1_ADS17_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS17_1 = 0x1
	// Position of ADS18 field.
	ADC120_ADADS1_ADS18_Pos = 0x2
	// Bit mask of ADS18 field.
	ADC120_ADADS1_ADS18_Msk = 0x4
	// Bit ADS18.
	ADC120_ADADS1_ADS18 = 0x4
	// Do not select associated input channel.
	ADC120_ADADS1_ADS18_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS18_1 = 0x1
	// Position of ADS19 field.
	ADC120_ADADS1_ADS19_Pos = 0x3
	// Bit mask of ADS19 field.
	ADC120_ADADS1_ADS19_Msk = 0x8
	// Bit ADS19.
	ADC120_ADADS1_ADS19 = 0x8
	// Do not select associated input channel.
	ADC120_ADADS1_ADS19_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS19_1 = 0x1
	// Position of ADS20 field.
	ADC120_ADADS1_ADS20_Pos = 0x4
	// Bit mask of ADS20 field.
	ADC120_ADADS1_ADS20_Msk = 0x10
	// Bit ADS20.
	ADC120_ADADS1_ADS20 = 0x10
	// Do not select associated input channel.
	ADC120_ADADS1_ADS20_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS20_1 = 0x1
	// Position of ADS21 field.
	ADC120_ADADS1_ADS21_Pos = 0x5
	// Bit mask of ADS21 field.
	ADC120_ADADS1_ADS21_Msk = 0x20
	// Bit ADS21.
	ADC120_ADADS1_ADS21 = 0x20
	// Do not select associated input channel.
	ADC120_ADADS1_ADS21_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS21_1 = 0x1
	// Position of ADS22 field.
	ADC120_ADADS1_ADS22_Pos = 0x6
	// Bit mask of ADS22 field.
	ADC120_ADADS1_ADS22_Msk = 0x40
	// Bit ADS22.
	ADC120_ADADS1_ADS22 = 0x40
	// Do not select associated input channel.
	ADC120_ADADS1_ADS22_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS22_1 = 0x1
	// Position of ADS23 field.
	ADC120_ADADS1_ADS23_Pos = 0x7
	// Bit mask of ADS23 field.
	ADC120_ADADS1_ADS23_Msk = 0x80
	// Bit ADS23.
	ADC120_ADADS1_ADS23 = 0x80
	// Do not select associated input channel.
	ADC120_ADADS1_ADS23_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS23_1 = 0x1
	// Position of ADS24 field.
	ADC120_ADADS1_ADS24_Pos = 0x8
	// Bit mask of ADS24 field.
	ADC120_ADADS1_ADS24_Msk = 0x100
	// Bit ADS24.
	ADC120_ADADS1_ADS24 = 0x100
	// Do not select associated input channel.
	ADC120_ADADS1_ADS24_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS24_1 = 0x1
	// Position of ADS25 field.
	ADC120_ADADS1_ADS25_Pos = 0x9
	// Bit mask of ADS25 field.
	ADC120_ADADS1_ADS25_Msk = 0x200
	// Bit ADS25.
	ADC120_ADADS1_ADS25 = 0x200
	// Do not select associated input channel.
	ADC120_ADADS1_ADS25_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS25_1 = 0x1
	// Position of ADS26 field.
	ADC120_ADADS1_ADS26_Pos = 0xa
	// Bit mask of ADS26 field.
	ADC120_ADADS1_ADS26_Msk = 0x400
	// Bit ADS26.
	ADC120_ADADS1_ADS26 = 0x400
	// Do not select associated input channel.
	ADC120_ADADS1_ADS26_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS26_1 = 0x1
	// Position of ADS27 field.
	ADC120_ADADS1_ADS27_Pos = 0xb
	// Bit mask of ADS27 field.
	ADC120_ADADS1_ADS27_Msk = 0x800
	// Bit ADS27.
	ADC120_ADADS1_ADS27 = 0x800
	// Do not select associated input channel.
	ADC120_ADADS1_ADS27_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS27_1 = 0x1
	// Position of ADS28 field.
	ADC120_ADADS1_ADS28_Pos = 0xc
	// Bit mask of ADS28 field.
	ADC120_ADADS1_ADS28_Msk = 0x1000
	// Bit ADS28.
	ADC120_ADADS1_ADS28 = 0x1000
	// Do not select associated input channel.
	ADC120_ADADS1_ADS28_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS28_1 = 0x1
	// Position of ADS29 field.
	ADC120_ADADS1_ADS29_Pos = 0xd
	// Bit mask of ADS29 field.
	ADC120_ADADS1_ADS29_Msk = 0x2000
	// Bit ADS29.
	ADC120_ADADS1_ADS29 = 0x2000
	// Do not select associated input channel.
	ADC120_ADADS1_ADS29_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS29_1 = 0x1
	// Position of ADS30 field.
	ADC120_ADADS1_ADS30_Pos = 0xe
	// Bit mask of ADS30 field.
	ADC120_ADADS1_ADS30_Msk = 0x4000
	// Bit ADS30.
	ADC120_ADADS1_ADS30 = 0x4000
	// Do not select associated input channel.
	ADC120_ADADS1_ADS30_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS30_1 = 0x1
	// Position of ADS31 field.
	ADC120_ADADS1_ADS31_Pos = 0xf
	// Bit mask of ADS31 field.
	ADC120_ADADS1_ADS31_Msk = 0x8000
	// Bit ADS31.
	ADC120_ADADS1_ADS31 = 0x8000
	// Do not select associated input channel.
	ADC120_ADADS1_ADS31_0 = 0x0
	// Select associated input channel.
	ADC120_ADADS1_ADS31_1 = 0x1

	// ADADC: A/D-Converted Value Addition/Average Count Select Register
	// Position of ADC field.
	ADC120_ADADC_ADC_Pos = 0x0
	// Bit mask of ADC field.
	ADC120_ADADC_ADC_Msk = 0x7
	// 1-time conversion (no addition, same as normal conversion)
	ADC120_ADADC_ADC_000 = 0x0
	// 2-time conversion (1 addition)
	ADC120_ADADC_ADC_001 = 0x1
	// 3-time conversion (2 additions)
	ADC120_ADADC_ADC_010 = 0x2
	// 4-time conversion (3 additions)
	ADC120_ADADC_ADC_011 = 0x3
	// 16-time conversion (15 additions)
	ADC120_ADADC_ADC_101 = 0x5
	// Position of AVEE field.
	ADC120_ADADC_AVEE_Pos = 0x7
	// Bit mask of AVEE field.
	ADC120_ADADC_AVEE_Msk = 0x80
	// Bit AVEE.
	ADC120_ADADC_AVEE = 0x80
	// Enable addition mode
	ADC120_ADADC_AVEE_0 = 0x0
	// Enable average mode
	ADC120_ADADC_AVEE_1 = 0x1

	// ADCER: A/D Control Extended Register
	// Position of ACE field.
	ADC120_ADCER_ACE_Pos = 0x5
	// Bit mask of ACE field.
	ADC120_ADCER_ACE_Msk = 0x20
	// Bit ACE.
	ADC120_ADCER_ACE = 0x20
	// Disable automatic clearing
	ADC120_ADCER_ACE_0 = 0x0
	// Enable automatic clearing
	ADC120_ADCER_ACE_1 = 0x1
	// Position of DIAGVAL field.
	ADC120_ADCER_DIAGVAL_Pos = 0x8
	// Bit mask of DIAGVAL field.
	ADC120_ADCER_DIAGVAL_Msk = 0x300
	// Setting prohibited when self-diagnosis is enabled
	ADC120_ADCER_DIAGVAL_00 = 0x0
	// 0 volts
	ADC120_ADCER_DIAGVAL_01 = 0x1
	// Reference voltage × 1/2
	ADC120_ADCER_DIAGVAL_10 = 0x2
	// Reference voltage
	ADC120_ADCER_DIAGVAL_11 = 0x3
	// Position of DIAGLD field.
	ADC120_ADCER_DIAGLD_Pos = 0xa
	// Bit mask of DIAGLD field.
	ADC120_ADCER_DIAGLD_Msk = 0x400
	// Bit DIAGLD.
	ADC120_ADCER_DIAGLD = 0x400
	// Select rotation mode for self-diagnosis voltage
	ADC120_ADCER_DIAGLD_0 = 0x0
	// Select mixed mode for self-diagnosis voltage
	ADC120_ADCER_DIAGLD_1 = 0x1
	// Position of DIAGM field.
	ADC120_ADCER_DIAGM_Pos = 0xb
	// Bit mask of DIAGM field.
	ADC120_ADCER_DIAGM_Msk = 0x800
	// Bit DIAGM.
	ADC120_ADCER_DIAGM = 0x800
	// Disable ADC12 self-diagnosis
	ADC120_ADCER_DIAGM_0 = 0x0
	// Enable ADC12 self-diagnosis
	ADC120_ADCER_DIAGM_1 = 0x1
	// Position of ADRFMT field.
	ADC120_ADCER_ADRFMT_Pos = 0xf
	// Bit mask of ADRFMT field.
	ADC120_ADCER_ADRFMT_Msk = 0x8000
	// Bit ADRFMT.
	ADC120_ADCER_ADRFMT = 0x8000
	// Select right-justified for the A/D data register format
	ADC120_ADCER_ADRFMT_0 = 0x0
	// Select left-justified for the A/D data register format
	ADC120_ADCER_ADRFMT_1 = 0x1

	// ADSTRGR: A/D Conversion Start Trigger Select Register
	// Position of TRSB field.
	ADC120_ADSTRGR_TRSB_Pos = 0x0
	// Bit mask of TRSB field.
	ADC120_ADSTRGR_TRSB_Msk = 0x3f
	// Position of TRSA field.
	ADC120_ADSTRGR_TRSA_Pos = 0x8
	// Bit mask of TRSA field.
	ADC120_ADSTRGR_TRSA_Msk = 0x3f00

	// ADEXICR: A/D Conversion Extended Input Control Registers
	// Position of TSSAD field.
	ADC120_ADEXICR_TSSAD_Pos = 0x0
	// Bit mask of TSSAD field.
	ADC120_ADEXICR_TSSAD_Msk = 0x1
	// Bit TSSAD.
	ADC120_ADEXICR_TSSAD = 0x1
	// Do not select addition/average mode for temperature sensor output.
	ADC120_ADEXICR_TSSAD_0 = 0x0
	// Select addition/average mode for temperature sensor output.
	ADC120_ADEXICR_TSSAD_1 = 0x1
	// Position of OCSAD field.
	ADC120_ADEXICR_OCSAD_Pos = 0x1
	// Bit mask of OCSAD field.
	ADC120_ADEXICR_OCSAD_Msk = 0x2
	// Bit OCSAD.
	ADC120_ADEXICR_OCSAD = 0x2
	// Do not select addition/average mode for internal reference voltage.
	ADC120_ADEXICR_OCSAD_0 = 0x0
	// Select addition/average mode for internal reference voltage.
	ADC120_ADEXICR_OCSAD_1 = 0x1
	// Position of TSSA field.
	ADC120_ADEXICR_TSSA_Pos = 0x8
	// Bit mask of TSSA field.
	ADC120_ADEXICR_TSSA_Msk = 0x100
	// Bit TSSA.
	ADC120_ADEXICR_TSSA = 0x100
	// Disable A/D conversion of temperature sensor output
	ADC120_ADEXICR_TSSA_0 = 0x0
	// Enable A/D conversion of temperature sensor output
	ADC120_ADEXICR_TSSA_1 = 0x1
	// Position of OCSA field.
	ADC120_ADEXICR_OCSA_Pos = 0x9
	// Bit mask of OCSA field.
	ADC120_ADEXICR_OCSA_Msk = 0x200
	// Bit OCSA.
	ADC120_ADEXICR_OCSA = 0x200
	// Disable A/D conversion of internal reference voltage
	ADC120_ADEXICR_OCSA_0 = 0x0
	// Enable A/D conversion of internal reference voltage
	ADC120_ADEXICR_OCSA_1 = 0x1

	// ADANSB0: A/D Channel Select Register B0
	// Position of ANSB00 field.
	ADC120_ADANSB0_ANSB00_Pos = 0x0
	// Bit mask of ANSB00 field.
	ADC120_ADANSB0_ANSB00_Msk = 0x1
	// Bit ANSB00.
	ADC120_ADANSB0_ANSB00 = 0x1
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB00_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB00_1 = 0x1
	// Position of ANSB01 field.
	ADC120_ADANSB0_ANSB01_Pos = 0x1
	// Bit mask of ANSB01 field.
	ADC120_ADANSB0_ANSB01_Msk = 0x2
	// Bit ANSB01.
	ADC120_ADANSB0_ANSB01 = 0x2
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB01_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB01_1 = 0x1
	// Position of ANSB02 field.
	ADC120_ADANSB0_ANSB02_Pos = 0x2
	// Bit mask of ANSB02 field.
	ADC120_ADANSB0_ANSB02_Msk = 0x4
	// Bit ANSB02.
	ADC120_ADANSB0_ANSB02 = 0x4
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB02_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB02_1 = 0x1
	// Position of ANSB03 field.
	ADC120_ADANSB0_ANSB03_Pos = 0x3
	// Bit mask of ANSB03 field.
	ADC120_ADANSB0_ANSB03_Msk = 0x8
	// Bit ANSB03.
	ADC120_ADANSB0_ANSB03 = 0x8
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB03_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB03_1 = 0x1
	// Position of ANSB04 field.
	ADC120_ADANSB0_ANSB04_Pos = 0x4
	// Bit mask of ANSB04 field.
	ADC120_ADANSB0_ANSB04_Msk = 0x10
	// Bit ANSB04.
	ADC120_ADANSB0_ANSB04 = 0x10
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB04_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB04_1 = 0x1
	// Position of ANSB05 field.
	ADC120_ADANSB0_ANSB05_Pos = 0x5
	// Bit mask of ANSB05 field.
	ADC120_ADANSB0_ANSB05_Msk = 0x20
	// Bit ANSB05.
	ADC120_ADANSB0_ANSB05 = 0x20
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB05_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB05_1 = 0x1
	// Position of ANSB06 field.
	ADC120_ADANSB0_ANSB06_Pos = 0x6
	// Bit mask of ANSB06 field.
	ADC120_ADANSB0_ANSB06_Msk = 0x40
	// Bit ANSB06.
	ADC120_ADANSB0_ANSB06 = 0x40
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB06_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB06_1 = 0x1
	// Position of ANSB07 field.
	ADC120_ADANSB0_ANSB07_Pos = 0x7
	// Bit mask of ANSB07 field.
	ADC120_ADANSB0_ANSB07_Msk = 0x80
	// Bit ANSB07.
	ADC120_ADANSB0_ANSB07 = 0x80
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB07_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB07_1 = 0x1
	// Position of ANSB08 field.
	ADC120_ADANSB0_ANSB08_Pos = 0x8
	// Bit mask of ANSB08 field.
	ADC120_ADANSB0_ANSB08_Msk = 0x100
	// Bit ANSB08.
	ADC120_ADANSB0_ANSB08 = 0x100
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB08_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB08_1 = 0x1
	// Position of ANSB09 field.
	ADC120_ADANSB0_ANSB09_Pos = 0x9
	// Bit mask of ANSB09 field.
	ADC120_ADANSB0_ANSB09_Msk = 0x200
	// Bit ANSB09.
	ADC120_ADANSB0_ANSB09 = 0x200
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB09_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB09_1 = 0x1
	// Position of ANSB10 field.
	ADC120_ADANSB0_ANSB10_Pos = 0xa
	// Bit mask of ANSB10 field.
	ADC120_ADANSB0_ANSB10_Msk = 0x400
	// Bit ANSB10.
	ADC120_ADANSB0_ANSB10 = 0x400
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB10_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB10_1 = 0x1
	// Position of ANSB11 field.
	ADC120_ADANSB0_ANSB11_Pos = 0xb
	// Bit mask of ANSB11 field.
	ADC120_ADANSB0_ANSB11_Msk = 0x800
	// Bit ANSB11.
	ADC120_ADANSB0_ANSB11 = 0x800
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB11_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB11_1 = 0x1
	// Position of ANSB12 field.
	ADC120_ADANSB0_ANSB12_Pos = 0xc
	// Bit mask of ANSB12 field.
	ADC120_ADANSB0_ANSB12_Msk = 0x1000
	// Bit ANSB12.
	ADC120_ADANSB0_ANSB12 = 0x1000
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB12_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB12_1 = 0x1
	// Position of ANSB13 field.
	ADC120_ADANSB0_ANSB13_Pos = 0xd
	// Bit mask of ANSB13 field.
	ADC120_ADANSB0_ANSB13_Msk = 0x2000
	// Bit ANSB13.
	ADC120_ADANSB0_ANSB13 = 0x2000
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB13_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB13_1 = 0x1
	// Position of ANSB14 field.
	ADC120_ADANSB0_ANSB14_Pos = 0xe
	// Bit mask of ANSB14 field.
	ADC120_ADANSB0_ANSB14_Msk = 0x4000
	// Bit ANSB14.
	ADC120_ADANSB0_ANSB14 = 0x4000
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB14_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB14_1 = 0x1
	// Position of ANSB15 field.
	ADC120_ADANSB0_ANSB15_Pos = 0xf
	// Bit mask of ANSB15 field.
	ADC120_ADANSB0_ANSB15_Msk = 0x8000
	// Bit ANSB15.
	ADC120_ADANSB0_ANSB15 = 0x8000
	// Do not select associated input channel.
	ADC120_ADANSB0_ANSB15_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB0_ANSB15_1 = 0x1

	// ADANSB1: A/D Channel Select Register B1
	// Position of ANSB16 field.
	ADC120_ADANSB1_ANSB16_Pos = 0x0
	// Bit mask of ANSB16 field.
	ADC120_ADANSB1_ANSB16_Msk = 0x1
	// Bit ANSB16.
	ADC120_ADANSB1_ANSB16 = 0x1
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB16_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB16_1 = 0x1
	// Position of ANSB17 field.
	ADC120_ADANSB1_ANSB17_Pos = 0x1
	// Bit mask of ANSB17 field.
	ADC120_ADANSB1_ANSB17_Msk = 0x2
	// Bit ANSB17.
	ADC120_ADANSB1_ANSB17 = 0x2
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB17_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB17_1 = 0x1
	// Position of ANSB18 field.
	ADC120_ADANSB1_ANSB18_Pos = 0x2
	// Bit mask of ANSB18 field.
	ADC120_ADANSB1_ANSB18_Msk = 0x4
	// Bit ANSB18.
	ADC120_ADANSB1_ANSB18 = 0x4
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB18_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB18_1 = 0x1
	// Position of ANSB19 field.
	ADC120_ADANSB1_ANSB19_Pos = 0x3
	// Bit mask of ANSB19 field.
	ADC120_ADANSB1_ANSB19_Msk = 0x8
	// Bit ANSB19.
	ADC120_ADANSB1_ANSB19 = 0x8
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB19_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB19_1 = 0x1
	// Position of ANSB20 field.
	ADC120_ADANSB1_ANSB20_Pos = 0x4
	// Bit mask of ANSB20 field.
	ADC120_ADANSB1_ANSB20_Msk = 0x10
	// Bit ANSB20.
	ADC120_ADANSB1_ANSB20 = 0x10
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB20_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB20_1 = 0x1
	// Position of ANSB21 field.
	ADC120_ADANSB1_ANSB21_Pos = 0x5
	// Bit mask of ANSB21 field.
	ADC120_ADANSB1_ANSB21_Msk = 0x20
	// Bit ANSB21.
	ADC120_ADANSB1_ANSB21 = 0x20
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB21_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB21_1 = 0x1
	// Position of ANSB22 field.
	ADC120_ADANSB1_ANSB22_Pos = 0x6
	// Bit mask of ANSB22 field.
	ADC120_ADANSB1_ANSB22_Msk = 0x40
	// Bit ANSB22.
	ADC120_ADANSB1_ANSB22 = 0x40
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB22_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB22_1 = 0x1
	// Position of ANSB23 field.
	ADC120_ADANSB1_ANSB23_Pos = 0x7
	// Bit mask of ANSB23 field.
	ADC120_ADANSB1_ANSB23_Msk = 0x80
	// Bit ANSB23.
	ADC120_ADANSB1_ANSB23 = 0x80
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB23_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB23_1 = 0x1
	// Position of ANSB24 field.
	ADC120_ADANSB1_ANSB24_Pos = 0x8
	// Bit mask of ANSB24 field.
	ADC120_ADANSB1_ANSB24_Msk = 0x100
	// Bit ANSB24.
	ADC120_ADANSB1_ANSB24 = 0x100
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB24_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB24_1 = 0x1
	// Position of ANSB25 field.
	ADC120_ADANSB1_ANSB25_Pos = 0x9
	// Bit mask of ANSB25 field.
	ADC120_ADANSB1_ANSB25_Msk = 0x200
	// Bit ANSB25.
	ADC120_ADANSB1_ANSB25 = 0x200
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB25_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB25_1 = 0x1
	// Position of ANSB26 field.
	ADC120_ADANSB1_ANSB26_Pos = 0xa
	// Bit mask of ANSB26 field.
	ADC120_ADANSB1_ANSB26_Msk = 0x400
	// Bit ANSB26.
	ADC120_ADANSB1_ANSB26 = 0x400
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB26_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB26_1 = 0x1
	// Position of ANSB27 field.
	ADC120_ADANSB1_ANSB27_Pos = 0xb
	// Bit mask of ANSB27 field.
	ADC120_ADANSB1_ANSB27_Msk = 0x800
	// Bit ANSB27.
	ADC120_ADANSB1_ANSB27 = 0x800
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB27_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB27_1 = 0x1
	// Position of ANSB28 field.
	ADC120_ADANSB1_ANSB28_Pos = 0xc
	// Bit mask of ANSB28 field.
	ADC120_ADANSB1_ANSB28_Msk = 0x1000
	// Bit ANSB28.
	ADC120_ADANSB1_ANSB28 = 0x1000
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB28_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB28_1 = 0x1
	// Position of ANSB29 field.
	ADC120_ADANSB1_ANSB29_Pos = 0xd
	// Bit mask of ANSB29 field.
	ADC120_ADANSB1_ANSB29_Msk = 0x2000
	// Bit ANSB29.
	ADC120_ADANSB1_ANSB29 = 0x2000
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB29_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB29_1 = 0x1
	// Position of ANSB30 field.
	ADC120_ADANSB1_ANSB30_Pos = 0xe
	// Bit mask of ANSB30 field.
	ADC120_ADANSB1_ANSB30_Msk = 0x4000
	// Bit ANSB30.
	ADC120_ADANSB1_ANSB30 = 0x4000
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB30_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB30_1 = 0x1
	// Position of ANSB31 field.
	ADC120_ADANSB1_ANSB31_Pos = 0xf
	// Bit mask of ANSB31 field.
	ADC120_ADANSB1_ANSB31_Msk = 0x8000
	// Bit ANSB31.
	ADC120_ADANSB1_ANSB31 = 0x8000
	// Do not select associated input channel.
	ADC120_ADANSB1_ANSB31_0 = 0x0
	// Select associated input channel.
	ADC120_ADANSB1_ANSB31_1 = 0x1

	// ADDBLDR: A/D Data Duplexing Register
	// Position of ADDBLDR field.
	ADC120_ADDBLDR_ADDBLDR_Pos = 0x0
	// Bit mask of ADDBLDR field.
	ADC120_ADDBLDR_ADDBLDR_Msk = 0xffff

	// ADTSDR: A/D Temperature Sensor Data Register
	// Position of ADTSDR field.
	ADC120_ADTSDR_ADTSDR_Pos = 0x0
	// Bit mask of ADTSDR field.
	ADC120_ADTSDR_ADTSDR_Msk = 0xffff

	// ADOCDR: A/D Internal Reference Voltage Data Register
	// Position of ADOCDR field.
	ADC120_ADOCDR_ADOCDR_Pos = 0x0
	// Bit mask of ADOCDR field.
	ADC120_ADOCDR_ADOCDR_Msk = 0xffff

	// ADRD: A/D Self-Diagnosis Data Register
	// Position of AD field.
	ADC120_ADRD_AD_Pos = 0x0
	// Bit mask of AD field.
	ADC120_ADRD_AD_Msk = 0xfff
	// Position of DIAGST field.
	ADC120_ADRD_DIAGST_Pos = 0xe
	// Bit mask of DIAGST field.
	ADC120_ADRD_DIAGST_Msk = 0xc000
	// Self-diagnosis not executed after power-on.
	ADC120_ADRD_DIAGST_00 = 0x0
	// Self-diagnosis was executed using the 0 V voltage.
	ADC120_ADRD_DIAGST_01 = 0x1
	// Self-diagnosis was executed using the reference voltage × 1/2.
	ADC120_ADRD_DIAGST_10 = 0x2
	// Self-diagnosis was executed using the reference voltage .
	ADC120_ADRD_DIAGST_11 = 0x3

	// ADDR5: A/D Data Registers %s
	// Position of ADDR field.
	ADC120_ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	ADC120_ADDR_ADDR_Msk = 0xffff

	// ADDR9: A/D Data Registers %s
	// Position of ADDR field.
	ADC120_ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	ADC120_ADDR_ADDR_Msk = 0xffff

	// ADDR19: A/D Data Registers %s
	// Position of ADDR field.
	ADC120_ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	ADC120_ADDR_ADDR_Msk = 0xffff

	// ADDISCR: A/D Disconnection Detection Control Register
	// Position of ADNDIS field.
	ADC120_ADDISCR_ADNDIS_Pos = 0x0
	// Bit mask of ADNDIS field.
	ADC120_ADDISCR_ADNDIS_Msk = 0xf
	// The disconnection detection assist function is disabled
	ADC120_ADDISCR_ADNDIS_0x0 = 0x0
	// Setting prohibited
	ADC120_ADDISCR_ADNDIS_0x1 = 0x1
	// Position of PCHG field.
	ADC120_ADDISCR_PCHG_Pos = 0x4
	// Bit mask of PCHG field.
	ADC120_ADDISCR_PCHG_Msk = 0x10
	// Bit PCHG.
	ADC120_ADDISCR_PCHG = 0x10
	// Discharge
	ADC120_ADDISCR_PCHG_0 = 0x0
	// Precharge
	ADC120_ADDISCR_PCHG_1 = 0x1

	// ADACSR: A/D Conversion Operation Mode Select Register
	// Position of ADSAC field.
	ADC120_ADACSR_ADSAC_Pos = 0x1
	// Bit mask of ADSAC field.
	ADC120_ADACSR_ADSAC_Msk = 0x2
	// Bit ADSAC.
	ADC120_ADACSR_ADSAC = 0x2
	// Normal conversion mode (default)
	ADC120_ADACSR_ADSAC_0 = 0x0
	// Fast conversion mode
	ADC120_ADACSR_ADSAC_1 = 0x1

	// ADGSPCR: A/D Group Scan Priority Control Register
	// Position of PGS field.
	ADC120_ADGSPCR_PGS_Pos = 0x0
	// Bit mask of PGS field.
	ADC120_ADGSPCR_PGS_Msk = 0x1
	// Bit PGS.
	ADC120_ADGSPCR_PGS = 0x1
	// Operate without group priority control.
	ADC120_ADGSPCR_PGS_0 = 0x0
	// Operate with group priority control.
	ADC120_ADGSPCR_PGS_1 = 0x1
	// Position of GBRSCN field.
	ADC120_ADGSPCR_GBRSCN_Pos = 0x1
	// Bit mask of GBRSCN field.
	ADC120_ADGSPCR_GBRSCN_Msk = 0x2
	// Bit GBRSCN.
	ADC120_ADGSPCR_GBRSCN = 0x2
	// Disable rescanning of the group that was stopped in group priority operation
	ADC120_ADGSPCR_GBRSCN_0 = 0x0
	// Enable rescanning of the group that was stopped in group priority operation.
	ADC120_ADGSPCR_GBRSCN_1 = 0x1
	// Position of GBRP field.
	ADC120_ADGSPCR_GBRP_Pos = 0xf
	// Bit mask of GBRP field.
	ADC120_ADGSPCR_GBRP_Msk = 0x8000
	// Bit GBRP.
	ADC120_ADGSPCR_GBRP = 0x8000
	// Single scan is not continuously activated.
	ADC120_ADGSPCR_GBRP_0 = 0x0
	// Single scan for the group with the lower-priority is continuously activated.
	ADC120_ADGSPCR_GBRP_1 = 0x1

	// ADDBLDRA: A/D Data Duplexing Register A
	// Position of ADDBLDR field.
	ADC120_ADDBLDRA_ADDBLDR_Pos = 0x0
	// Bit mask of ADDBLDR field.
	ADC120_ADDBLDRA_ADDBLDR_Msk = 0xffff

	// ADDBLDRB: A/D Data Duplexing Register B
	// Position of ADDBLDR field.
	ADC120_ADDBLDRB_ADDBLDR_Pos = 0x0
	// Bit mask of ADDBLDR field.
	ADC120_ADDBLDRB_ADDBLDR_Msk = 0xffff

	// ADHVREFCNT: A/D High-Potential/Low-Potential Reference Voltage Control Register
	// Position of HVSEL field.
	ADC120_ADHVREFCNT_HVSEL_Pos = 0x0
	// Bit mask of HVSEL field.
	ADC120_ADHVREFCNT_HVSEL_Msk = 0x3
	// AVCC0 is selected as the high-potential reference voltage
	ADC120_ADHVREFCNT_HVSEL_00 = 0x0
	// VREFH0 is selected as the high-potential reference voltage
	ADC120_ADHVREFCNT_HVSEL_01 = 0x1
	// Internal reference voltage is selected as the high-potential reference voltage
	ADC120_ADHVREFCNT_HVSEL_10 = 0x2
	// No reference voltage pin is selected (internal node discharge)
	ADC120_ADHVREFCNT_HVSEL_11 = 0x3
	// Position of LVSEL field.
	ADC120_ADHVREFCNT_LVSEL_Pos = 0x4
	// Bit mask of LVSEL field.
	ADC120_ADHVREFCNT_LVSEL_Msk = 0x10
	// Bit LVSEL.
	ADC120_ADHVREFCNT_LVSEL = 0x10
	// AVSS0 is selected as the low-potential reference voltage.
	ADC120_ADHVREFCNT_LVSEL_0 = 0x0
	// VREFL0 is selected as the low-potential reference voltage.
	ADC120_ADHVREFCNT_LVSEL_1 = 0x1
	// Position of ADSLP field.
	ADC120_ADHVREFCNT_ADSLP_Pos = 0x7
	// Bit mask of ADSLP field.
	ADC120_ADHVREFCNT_ADSLP_Msk = 0x80
	// Bit ADSLP.
	ADC120_ADHVREFCNT_ADSLP = 0x80
	// Normal operation
	ADC120_ADHVREFCNT_ADSLP_0 = 0x0
	// Standby state
	ADC120_ADHVREFCNT_ADSLP_1 = 0x1

	// ADWINMON: A/D Compare Function Window A/B Status Monitor Register
	// Position of MONCOMB field.
	ADC120_ADWINMON_MONCOMB_Pos = 0x0
	// Bit mask of MONCOMB field.
	ADC120_ADWINMON_MONCOMB_Msk = 0x1
	// Bit MONCOMB.
	ADC120_ADWINMON_MONCOMB = 0x1
	// Window A/B composite conditions are not met.
	ADC120_ADWINMON_MONCOMB_0 = 0x0
	// Window A/B composite conditions are met.
	ADC120_ADWINMON_MONCOMB_1 = 0x1
	// Position of MONCMPA field.
	ADC120_ADWINMON_MONCMPA_Pos = 0x4
	// Bit mask of MONCMPA field.
	ADC120_ADWINMON_MONCMPA_Msk = 0x10
	// Bit MONCMPA.
	ADC120_ADWINMON_MONCMPA = 0x10
	// Window A comparison conditions are not met.
	ADC120_ADWINMON_MONCMPA_0 = 0x0
	// Window A comparison conditions are met.
	ADC120_ADWINMON_MONCMPA_1 = 0x1
	// Position of MONCMPB field.
	ADC120_ADWINMON_MONCMPB_Pos = 0x5
	// Bit mask of MONCMPB field.
	ADC120_ADWINMON_MONCMPB_Msk = 0x20
	// Bit MONCMPB.
	ADC120_ADWINMON_MONCMPB = 0x20
	// Window B comparison conditions are not met.
	ADC120_ADWINMON_MONCMPB_0 = 0x0
	// Window B comparison conditions are met.
	ADC120_ADWINMON_MONCMPB_1 = 0x1

	// ADCMPCR: A/D Compare Function Control Register
	// Position of CMPAB field.
	ADC120_ADCMPCR_CMPAB_Pos = 0x0
	// Bit mask of CMPAB field.
	ADC120_ADCMPCR_CMPAB_Msk = 0x3
	// Output ADC120_WCMPM when window A OR window B comparison conditions are met. Otherwise, output ADC120_WCMPUM.
	ADC120_ADCMPCR_CMPAB_00 = 0x0
	// Output ADC120_WCMPM when window A EXOR window B comparison conditions are met. Otherwise, output ADC120_WCMPUM.
	ADC120_ADCMPCR_CMPAB_01 = 0x1
	// Output ADC120_WCMPM when window A AND window B comparison conditions are met. Otherwise, output ADC120_WCMPUM.
	ADC120_ADCMPCR_CMPAB_10 = 0x2
	// Setting prohibited.
	ADC120_ADCMPCR_CMPAB_11 = 0x3
	// Position of CMPBE field.
	ADC120_ADCMPCR_CMPBE_Pos = 0x9
	// Bit mask of CMPBE field.
	ADC120_ADCMPCR_CMPBE_Msk = 0x200
	// Bit CMPBE.
	ADC120_ADCMPCR_CMPBE = 0x200
	// Disable compare window B operation. Disable ADC120_WCMPM and ADC120_WCMPUM outputs.
	ADC120_ADCMPCR_CMPBE_0 = 0x0
	// Enable compare window B operation.
	ADC120_ADCMPCR_CMPBE_1 = 0x1
	// Position of CMPAE field.
	ADC120_ADCMPCR_CMPAE_Pos = 0xb
	// Bit mask of CMPAE field.
	ADC120_ADCMPCR_CMPAE_Msk = 0x800
	// Bit CMPAE.
	ADC120_ADCMPCR_CMPAE = 0x800
	// Disable compare window A operation. Disable ADC120_WCMPM and ADC120_WCMPUM outputs.
	ADC120_ADCMPCR_CMPAE_0 = 0x0
	// Enable compare window A operation.
	ADC120_ADCMPCR_CMPAE_1 = 0x1
	// Position of CMPBIE field.
	ADC120_ADCMPCR_CMPBIE_Pos = 0xd
	// Bit mask of CMPBIE field.
	ADC120_ADCMPCR_CMPBIE_Msk = 0x2000
	// Bit CMPBIE.
	ADC120_ADCMPCR_CMPBIE = 0x2000
	// Disable ADC120_CMPBI interrupt when comparison conditions (window B) are met.
	ADC120_ADCMPCR_CMPBIE_0 = 0x0
	// Enable ADC120_CMPBI interrupt when comparison conditions (window B) are met.
	ADC120_ADCMPCR_CMPBIE_1 = 0x1
	// Position of WCMPE field.
	ADC120_ADCMPCR_WCMPE_Pos = 0xe
	// Bit mask of WCMPE field.
	ADC120_ADCMPCR_WCMPE_Msk = 0x4000
	// Bit WCMPE.
	ADC120_ADCMPCR_WCMPE = 0x4000
	// Disable window function Window A and window B operate as a comparator to compare the single value on the lower side with the A/D conversion result.
	ADC120_ADCMPCR_WCMPE_0 = 0x0
	// Enable window function Window A and window B operate as a comparator to compare the two values on the upper and lower sides with the A/D conversion result.
	ADC120_ADCMPCR_WCMPE_1 = 0x1
	// Position of CMPAIE field.
	ADC120_ADCMPCR_CMPAIE_Pos = 0xf
	// Bit mask of CMPAIE field.
	ADC120_ADCMPCR_CMPAIE_Msk = 0x8000
	// Bit CMPAIE.
	ADC120_ADCMPCR_CMPAIE = 0x8000
	// Disable ADC120_CMPAI interrupt when comparison conditions (window A) are met.
	ADC120_ADCMPCR_CMPAIE_0 = 0x0
	// Enable ADC120_CMPAI interrupt when comparison conditions (window A) are met.
	ADC120_ADCMPCR_CMPAIE_1 = 0x1

	// ADCMPANSER: A/D Compare Function Window A Extended Input Select Register
	// Position of CMPTSA field.
	ADC120_ADCMPANSER_CMPTSA_Pos = 0x0
	// Bit mask of CMPTSA field.
	ADC120_ADCMPANSER_CMPTSA_Msk = 0x1
	// Bit CMPTSA.
	ADC120_ADCMPANSER_CMPTSA = 0x1
	// Exclude the temperature sensor output from the compare Window A target range.
	ADC120_ADCMPANSER_CMPTSA_0 = 0x0
	// Include the temperature sensor output in the compare Window A target range.
	ADC120_ADCMPANSER_CMPTSA_1 = 0x1
	// Position of CMPOCA field.
	ADC120_ADCMPANSER_CMPOCA_Pos = 0x1
	// Bit mask of CMPOCA field.
	ADC120_ADCMPANSER_CMPOCA_Msk = 0x2
	// Bit CMPOCA.
	ADC120_ADCMPANSER_CMPOCA = 0x2
	// Exclude the internal reference voltage from the compare Window A target range.
	ADC120_ADCMPANSER_CMPOCA_0 = 0x0
	// Include the internal reference voltage in the compare Window A target range.
	ADC120_ADCMPANSER_CMPOCA_1 = 0x1

	// ADCMPLER: A/D Compare Function Window A Extended Input Comparison Condition Setting Register
	// Position of CMPLTSA field.
	ADC120_ADCMPLER_CMPLTSA_Pos = 0x0
	// Bit mask of CMPLTSA field.
	ADC120_ADCMPLER_CMPLTSA_Msk = 0x1
	// Bit CMPLTSA.
	ADC120_ADCMPLER_CMPLTSA = 0x1
	// When window function is disabled (ADCMPCR.WCMPE = 0) : ADCMPDR0 value > A/D-converted valueCompare Window A Temperature Sensor Output Comparison Condition Select When window function is enabled (ADCMPCR.WCMPE = 1) : Compare Window A Temperature Sensor Output Comparison ConditionA/D-converted value < ADCMPDR0 value, or A/D-converted value > ADCMPDR1 value
	ADC120_ADCMPLER_CMPLTSA_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0) : ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1) : ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLER_CMPLTSA_1 = 0x1
	// Position of CMPLOCA field.
	ADC120_ADCMPLER_CMPLOCA_Pos = 0x1
	// Bit mask of CMPLOCA field.
	ADC120_ADCMPLER_CMPLOCA_Msk = 0x2
	// Bit CMPLOCA.
	ADC120_ADCMPLER_CMPLOCA = 0x2
	// When window function is disabled (ADCMPCR.WCMPE = 0) : ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or A/D-converted value > ADCMPDR1 value
	ADC120_ADCMPLER_CMPLOCA_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLER_CMPLOCA_1 = 0x1

	// ADCMPANSR0: A/D Compare Function Window A Channel Select Register 0
	// Position of CMPCHA00 field.
	ADC120_ADCMPANSR0_CMPCHA00_Pos = 0x0
	// Bit mask of CMPCHA00 field.
	ADC120_ADCMPANSR0_CMPCHA00_Msk = 0x1
	// Bit CMPCHA00.
	ADC120_ADCMPANSR0_CMPCHA00 = 0x1
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA00_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA00_1 = 0x1
	// Position of CMPCHA01 field.
	ADC120_ADCMPANSR0_CMPCHA01_Pos = 0x1
	// Bit mask of CMPCHA01 field.
	ADC120_ADCMPANSR0_CMPCHA01_Msk = 0x2
	// Bit CMPCHA01.
	ADC120_ADCMPANSR0_CMPCHA01 = 0x2
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA01_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA01_1 = 0x1
	// Position of CMPCHA02 field.
	ADC120_ADCMPANSR0_CMPCHA02_Pos = 0x2
	// Bit mask of CMPCHA02 field.
	ADC120_ADCMPANSR0_CMPCHA02_Msk = 0x4
	// Bit CMPCHA02.
	ADC120_ADCMPANSR0_CMPCHA02 = 0x4
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA02_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA02_1 = 0x1
	// Position of CMPCHA03 field.
	ADC120_ADCMPANSR0_CMPCHA03_Pos = 0x3
	// Bit mask of CMPCHA03 field.
	ADC120_ADCMPANSR0_CMPCHA03_Msk = 0x8
	// Bit CMPCHA03.
	ADC120_ADCMPANSR0_CMPCHA03 = 0x8
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA03_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA03_1 = 0x1
	// Position of CMPCHA04 field.
	ADC120_ADCMPANSR0_CMPCHA04_Pos = 0x4
	// Bit mask of CMPCHA04 field.
	ADC120_ADCMPANSR0_CMPCHA04_Msk = 0x10
	// Bit CMPCHA04.
	ADC120_ADCMPANSR0_CMPCHA04 = 0x10
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA04_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA04_1 = 0x1
	// Position of CMPCHA05 field.
	ADC120_ADCMPANSR0_CMPCHA05_Pos = 0x5
	// Bit mask of CMPCHA05 field.
	ADC120_ADCMPANSR0_CMPCHA05_Msk = 0x20
	// Bit CMPCHA05.
	ADC120_ADCMPANSR0_CMPCHA05 = 0x20
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA05_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA05_1 = 0x1
	// Position of CMPCHA06 field.
	ADC120_ADCMPANSR0_CMPCHA06_Pos = 0x6
	// Bit mask of CMPCHA06 field.
	ADC120_ADCMPANSR0_CMPCHA06_Msk = 0x40
	// Bit CMPCHA06.
	ADC120_ADCMPANSR0_CMPCHA06 = 0x40
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA06_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA06_1 = 0x1
	// Position of CMPCHA07 field.
	ADC120_ADCMPANSR0_CMPCHA07_Pos = 0x7
	// Bit mask of CMPCHA07 field.
	ADC120_ADCMPANSR0_CMPCHA07_Msk = 0x80
	// Bit CMPCHA07.
	ADC120_ADCMPANSR0_CMPCHA07 = 0x80
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA07_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA07_1 = 0x1
	// Position of CMPCHA08 field.
	ADC120_ADCMPANSR0_CMPCHA08_Pos = 0x8
	// Bit mask of CMPCHA08 field.
	ADC120_ADCMPANSR0_CMPCHA08_Msk = 0x100
	// Bit CMPCHA08.
	ADC120_ADCMPANSR0_CMPCHA08 = 0x100
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA08_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA08_1 = 0x1
	// Position of CMPCHA09 field.
	ADC120_ADCMPANSR0_CMPCHA09_Pos = 0x9
	// Bit mask of CMPCHA09 field.
	ADC120_ADCMPANSR0_CMPCHA09_Msk = 0x200
	// Bit CMPCHA09.
	ADC120_ADCMPANSR0_CMPCHA09 = 0x200
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA09_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA09_1 = 0x1
	// Position of CMPCHA10 field.
	ADC120_ADCMPANSR0_CMPCHA10_Pos = 0xa
	// Bit mask of CMPCHA10 field.
	ADC120_ADCMPANSR0_CMPCHA10_Msk = 0x400
	// Bit CMPCHA10.
	ADC120_ADCMPANSR0_CMPCHA10 = 0x400
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA10_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA10_1 = 0x1
	// Position of CMPCHA11 field.
	ADC120_ADCMPANSR0_CMPCHA11_Pos = 0xb
	// Bit mask of CMPCHA11 field.
	ADC120_ADCMPANSR0_CMPCHA11_Msk = 0x800
	// Bit CMPCHA11.
	ADC120_ADCMPANSR0_CMPCHA11 = 0x800
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA11_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA11_1 = 0x1
	// Position of CMPCHA12 field.
	ADC120_ADCMPANSR0_CMPCHA12_Pos = 0xc
	// Bit mask of CMPCHA12 field.
	ADC120_ADCMPANSR0_CMPCHA12_Msk = 0x1000
	// Bit CMPCHA12.
	ADC120_ADCMPANSR0_CMPCHA12 = 0x1000
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA12_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA12_1 = 0x1
	// Position of CMPCHA13 field.
	ADC120_ADCMPANSR0_CMPCHA13_Pos = 0xd
	// Bit mask of CMPCHA13 field.
	ADC120_ADCMPANSR0_CMPCHA13_Msk = 0x2000
	// Bit CMPCHA13.
	ADC120_ADCMPANSR0_CMPCHA13 = 0x2000
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA13_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA13_1 = 0x1
	// Position of CMPCHA14 field.
	ADC120_ADCMPANSR0_CMPCHA14_Pos = 0xe
	// Bit mask of CMPCHA14 field.
	ADC120_ADCMPANSR0_CMPCHA14_Msk = 0x4000
	// Bit CMPCHA14.
	ADC120_ADCMPANSR0_CMPCHA14 = 0x4000
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA14_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA14_1 = 0x1
	// Position of CMPCHA15 field.
	ADC120_ADCMPANSR0_CMPCHA15_Pos = 0xf
	// Bit mask of CMPCHA15 field.
	ADC120_ADCMPANSR0_CMPCHA15_Msk = 0x8000
	// Bit CMPCHA15.
	ADC120_ADCMPANSR0_CMPCHA15 = 0x8000
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA15_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR0_CMPCHA15_1 = 0x1

	// ADCMPANSR1: A/D Compare Function Window A Channel Select Register 1
	// Position of CMPCHA16 field.
	ADC120_ADCMPANSR1_CMPCHA16_Pos = 0x0
	// Bit mask of CMPCHA16 field.
	ADC120_ADCMPANSR1_CMPCHA16_Msk = 0x1
	// Bit CMPCHA16.
	ADC120_ADCMPANSR1_CMPCHA16 = 0x1
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA16_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA16_1 = 0x1
	// Position of CMPCHA17 field.
	ADC120_ADCMPANSR1_CMPCHA17_Pos = 0x1
	// Bit mask of CMPCHA17 field.
	ADC120_ADCMPANSR1_CMPCHA17_Msk = 0x2
	// Bit CMPCHA17.
	ADC120_ADCMPANSR1_CMPCHA17 = 0x2
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA17_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA17_1 = 0x1
	// Position of CMPCHA18 field.
	ADC120_ADCMPANSR1_CMPCHA18_Pos = 0x2
	// Bit mask of CMPCHA18 field.
	ADC120_ADCMPANSR1_CMPCHA18_Msk = 0x4
	// Bit CMPCHA18.
	ADC120_ADCMPANSR1_CMPCHA18 = 0x4
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA18_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA18_1 = 0x1
	// Position of CMPCHA19 field.
	ADC120_ADCMPANSR1_CMPCHA19_Pos = 0x3
	// Bit mask of CMPCHA19 field.
	ADC120_ADCMPANSR1_CMPCHA19_Msk = 0x8
	// Bit CMPCHA19.
	ADC120_ADCMPANSR1_CMPCHA19 = 0x8
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA19_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA19_1 = 0x1
	// Position of CMPCHA20 field.
	ADC120_ADCMPANSR1_CMPCHA20_Pos = 0x4
	// Bit mask of CMPCHA20 field.
	ADC120_ADCMPANSR1_CMPCHA20_Msk = 0x10
	// Bit CMPCHA20.
	ADC120_ADCMPANSR1_CMPCHA20 = 0x10
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA20_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA20_1 = 0x1
	// Position of CMPCHA21 field.
	ADC120_ADCMPANSR1_CMPCHA21_Pos = 0x5
	// Bit mask of CMPCHA21 field.
	ADC120_ADCMPANSR1_CMPCHA21_Msk = 0x20
	// Bit CMPCHA21.
	ADC120_ADCMPANSR1_CMPCHA21 = 0x20
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA21_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA21_1 = 0x1
	// Position of CMPCHA22 field.
	ADC120_ADCMPANSR1_CMPCHA22_Pos = 0x6
	// Bit mask of CMPCHA22 field.
	ADC120_ADCMPANSR1_CMPCHA22_Msk = 0x40
	// Bit CMPCHA22.
	ADC120_ADCMPANSR1_CMPCHA22 = 0x40
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA22_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA22_1 = 0x1
	// Position of CMPCHA23 field.
	ADC120_ADCMPANSR1_CMPCHA23_Pos = 0x7
	// Bit mask of CMPCHA23 field.
	ADC120_ADCMPANSR1_CMPCHA23_Msk = 0x80
	// Bit CMPCHA23.
	ADC120_ADCMPANSR1_CMPCHA23 = 0x80
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA23_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA23_1 = 0x1
	// Position of CMPCHA24 field.
	ADC120_ADCMPANSR1_CMPCHA24_Pos = 0x8
	// Bit mask of CMPCHA24 field.
	ADC120_ADCMPANSR1_CMPCHA24_Msk = 0x100
	// Bit CMPCHA24.
	ADC120_ADCMPANSR1_CMPCHA24 = 0x100
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA24_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA24_1 = 0x1
	// Position of CMPCHA25 field.
	ADC120_ADCMPANSR1_CMPCHA25_Pos = 0x9
	// Bit mask of CMPCHA25 field.
	ADC120_ADCMPANSR1_CMPCHA25_Msk = 0x200
	// Bit CMPCHA25.
	ADC120_ADCMPANSR1_CMPCHA25 = 0x200
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA25_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA25_1 = 0x1
	// Position of CMPCHA26 field.
	ADC120_ADCMPANSR1_CMPCHA26_Pos = 0xa
	// Bit mask of CMPCHA26 field.
	ADC120_ADCMPANSR1_CMPCHA26_Msk = 0x400
	// Bit CMPCHA26.
	ADC120_ADCMPANSR1_CMPCHA26 = 0x400
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA26_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA26_1 = 0x1
	// Position of CMPCHA27 field.
	ADC120_ADCMPANSR1_CMPCHA27_Pos = 0xb
	// Bit mask of CMPCHA27 field.
	ADC120_ADCMPANSR1_CMPCHA27_Msk = 0x800
	// Bit CMPCHA27.
	ADC120_ADCMPANSR1_CMPCHA27 = 0x800
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA27_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA27_1 = 0x1
	// Position of CMPCHA28 field.
	ADC120_ADCMPANSR1_CMPCHA28_Pos = 0xc
	// Bit mask of CMPCHA28 field.
	ADC120_ADCMPANSR1_CMPCHA28_Msk = 0x1000
	// Bit CMPCHA28.
	ADC120_ADCMPANSR1_CMPCHA28 = 0x1000
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA28_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA28_1 = 0x1
	// Position of CMPCHA29 field.
	ADC120_ADCMPANSR1_CMPCHA29_Pos = 0xd
	// Bit mask of CMPCHA29 field.
	ADC120_ADCMPANSR1_CMPCHA29_Msk = 0x2000
	// Bit CMPCHA29.
	ADC120_ADCMPANSR1_CMPCHA29 = 0x2000
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA29_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA29_1 = 0x1
	// Position of CMPCHA30 field.
	ADC120_ADCMPANSR1_CMPCHA30_Pos = 0xe
	// Bit mask of CMPCHA30 field.
	ADC120_ADCMPANSR1_CMPCHA30_Msk = 0x4000
	// Bit CMPCHA30.
	ADC120_ADCMPANSR1_CMPCHA30 = 0x4000
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA30_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA30_1 = 0x1
	// Position of CMPCHA31 field.
	ADC120_ADCMPANSR1_CMPCHA31_Pos = 0xf
	// Bit mask of CMPCHA31 field.
	ADC120_ADCMPANSR1_CMPCHA31_Msk = 0x8000
	// Bit CMPCHA31.
	ADC120_ADCMPANSR1_CMPCHA31 = 0x8000
	// Disable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA31_0 = 0x0
	// Enable compare function for associated input channel
	ADC120_ADCMPANSR1_CMPCHA31_1 = 0x1

	// ADCMPLR0: A/D Compare Function Window A Comparison Condition Setting Register 0
	// Position of CMPLCHA00 field.
	ADC120_ADCMPLR0_CMPLCHA00_Pos = 0x0
	// Bit mask of CMPLCHA00 field.
	ADC120_ADCMPLR0_CMPLCHA00_Msk = 0x1
	// Bit CMPLCHA00.
	ADC120_ADCMPLR0_CMPLCHA00 = 0x1
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA00_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA00_1 = 0x1
	// Position of CMPLCHA01 field.
	ADC120_ADCMPLR0_CMPLCHA01_Pos = 0x1
	// Bit mask of CMPLCHA01 field.
	ADC120_ADCMPLR0_CMPLCHA01_Msk = 0x2
	// Bit CMPLCHA01.
	ADC120_ADCMPLR0_CMPLCHA01 = 0x2
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA01_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA01_1 = 0x1
	// Position of CMPLCHA02 field.
	ADC120_ADCMPLR0_CMPLCHA02_Pos = 0x2
	// Bit mask of CMPLCHA02 field.
	ADC120_ADCMPLR0_CMPLCHA02_Msk = 0x4
	// Bit CMPLCHA02.
	ADC120_ADCMPLR0_CMPLCHA02 = 0x4
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA02_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA02_1 = 0x1
	// Position of CMPLCHA03 field.
	ADC120_ADCMPLR0_CMPLCHA03_Pos = 0x3
	// Bit mask of CMPLCHA03 field.
	ADC120_ADCMPLR0_CMPLCHA03_Msk = 0x8
	// Bit CMPLCHA03.
	ADC120_ADCMPLR0_CMPLCHA03 = 0x8
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA03_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA03_1 = 0x1
	// Position of CMPLCHA04 field.
	ADC120_ADCMPLR0_CMPLCHA04_Pos = 0x4
	// Bit mask of CMPLCHA04 field.
	ADC120_ADCMPLR0_CMPLCHA04_Msk = 0x10
	// Bit CMPLCHA04.
	ADC120_ADCMPLR0_CMPLCHA04 = 0x10
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA04_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA04_1 = 0x1
	// Position of CMPLCHA05 field.
	ADC120_ADCMPLR0_CMPLCHA05_Pos = 0x5
	// Bit mask of CMPLCHA05 field.
	ADC120_ADCMPLR0_CMPLCHA05_Msk = 0x20
	// Bit CMPLCHA05.
	ADC120_ADCMPLR0_CMPLCHA05 = 0x20
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA05_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA05_1 = 0x1
	// Position of CMPLCHA06 field.
	ADC120_ADCMPLR0_CMPLCHA06_Pos = 0x6
	// Bit mask of CMPLCHA06 field.
	ADC120_ADCMPLR0_CMPLCHA06_Msk = 0x40
	// Bit CMPLCHA06.
	ADC120_ADCMPLR0_CMPLCHA06 = 0x40
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA06_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA06_1 = 0x1
	// Position of CMPLCHA07 field.
	ADC120_ADCMPLR0_CMPLCHA07_Pos = 0x7
	// Bit mask of CMPLCHA07 field.
	ADC120_ADCMPLR0_CMPLCHA07_Msk = 0x80
	// Bit CMPLCHA07.
	ADC120_ADCMPLR0_CMPLCHA07 = 0x80
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA07_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA07_1 = 0x1
	// Position of CMPLCHA08 field.
	ADC120_ADCMPLR0_CMPLCHA08_Pos = 0x8
	// Bit mask of CMPLCHA08 field.
	ADC120_ADCMPLR0_CMPLCHA08_Msk = 0x100
	// Bit CMPLCHA08.
	ADC120_ADCMPLR0_CMPLCHA08 = 0x100
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA08_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA08_1 = 0x1
	// Position of CMPLCHA09 field.
	ADC120_ADCMPLR0_CMPLCHA09_Pos = 0x9
	// Bit mask of CMPLCHA09 field.
	ADC120_ADCMPLR0_CMPLCHA09_Msk = 0x200
	// Bit CMPLCHA09.
	ADC120_ADCMPLR0_CMPLCHA09 = 0x200
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA09_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA09_1 = 0x1
	// Position of CMPLCHA10 field.
	ADC120_ADCMPLR0_CMPLCHA10_Pos = 0xa
	// Bit mask of CMPLCHA10 field.
	ADC120_ADCMPLR0_CMPLCHA10_Msk = 0x400
	// Bit CMPLCHA10.
	ADC120_ADCMPLR0_CMPLCHA10 = 0x400
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA10_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA10_1 = 0x1
	// Position of CMPLCHA11 field.
	ADC120_ADCMPLR0_CMPLCHA11_Pos = 0xb
	// Bit mask of CMPLCHA11 field.
	ADC120_ADCMPLR0_CMPLCHA11_Msk = 0x800
	// Bit CMPLCHA11.
	ADC120_ADCMPLR0_CMPLCHA11 = 0x800
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA11_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA11_1 = 0x1
	// Position of CMPLCHA12 field.
	ADC120_ADCMPLR0_CMPLCHA12_Pos = 0xc
	// Bit mask of CMPLCHA12 field.
	ADC120_ADCMPLR0_CMPLCHA12_Msk = 0x1000
	// Bit CMPLCHA12.
	ADC120_ADCMPLR0_CMPLCHA12 = 0x1000
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA12_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA12_1 = 0x1
	// Position of CMPLCHA13 field.
	ADC120_ADCMPLR0_CMPLCHA13_Pos = 0xd
	// Bit mask of CMPLCHA13 field.
	ADC120_ADCMPLR0_CMPLCHA13_Msk = 0x2000
	// Bit CMPLCHA13.
	ADC120_ADCMPLR0_CMPLCHA13 = 0x2000
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA13_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA13_1 = 0x1
	// Position of CMPLCHA14 field.
	ADC120_ADCMPLR0_CMPLCHA14_Pos = 0xe
	// Bit mask of CMPLCHA14 field.
	ADC120_ADCMPLR0_CMPLCHA14_Msk = 0x4000
	// Bit CMPLCHA14.
	ADC120_ADCMPLR0_CMPLCHA14 = 0x4000
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA14_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA14_1 = 0x1
	// Position of CMPLCHA15 field.
	ADC120_ADCMPLR0_CMPLCHA15_Pos = 0xf
	// Bit mask of CMPLCHA15 field.
	ADC120_ADCMPLR0_CMPLCHA15_Msk = 0x8000
	// Bit CMPLCHA15.
	ADC120_ADCMPLR0_CMPLCHA15 = 0x8000
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR0_CMPLCHA15_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR0_CMPLCHA15_1 = 0x1

	// ADCMPLR1: A/D Compare Function Window A Comparison Condition Setting Register 1
	// Position of CMPLCHA16 field.
	ADC120_ADCMPLR1_CMPLCHA16_Pos = 0x0
	// Bit mask of CMPLCHA16 field.
	ADC120_ADCMPLR1_CMPLCHA16_Msk = 0x1
	// Bit CMPLCHA16.
	ADC120_ADCMPLR1_CMPLCHA16 = 0x1
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA16_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA16_1 = 0x1
	// Position of CMPLCHA17 field.
	ADC120_ADCMPLR1_CMPLCHA17_Pos = 0x1
	// Bit mask of CMPLCHA17 field.
	ADC120_ADCMPLR1_CMPLCHA17_Msk = 0x2
	// Bit CMPLCHA17.
	ADC120_ADCMPLR1_CMPLCHA17 = 0x2
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA17_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA17_1 = 0x1
	// Position of CMPLCHA18 field.
	ADC120_ADCMPLR1_CMPLCHA18_Pos = 0x2
	// Bit mask of CMPLCHA18 field.
	ADC120_ADCMPLR1_CMPLCHA18_Msk = 0x4
	// Bit CMPLCHA18.
	ADC120_ADCMPLR1_CMPLCHA18 = 0x4
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA18_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA18_1 = 0x1
	// Position of CMPLCHA19 field.
	ADC120_ADCMPLR1_CMPLCHA19_Pos = 0x3
	// Bit mask of CMPLCHA19 field.
	ADC120_ADCMPLR1_CMPLCHA19_Msk = 0x8
	// Bit CMPLCHA19.
	ADC120_ADCMPLR1_CMPLCHA19 = 0x8
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA19_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA19_1 = 0x1
	// Position of CMPLCHA20 field.
	ADC120_ADCMPLR1_CMPLCHA20_Pos = 0x4
	// Bit mask of CMPLCHA20 field.
	ADC120_ADCMPLR1_CMPLCHA20_Msk = 0x10
	// Bit CMPLCHA20.
	ADC120_ADCMPLR1_CMPLCHA20 = 0x10
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA20_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA20_1 = 0x1
	// Position of CMPLCHA21 field.
	ADC120_ADCMPLR1_CMPLCHA21_Pos = 0x5
	// Bit mask of CMPLCHA21 field.
	ADC120_ADCMPLR1_CMPLCHA21_Msk = 0x20
	// Bit CMPLCHA21.
	ADC120_ADCMPLR1_CMPLCHA21 = 0x20
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA21_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA21_1 = 0x1
	// Position of CMPLCHA22 field.
	ADC120_ADCMPLR1_CMPLCHA22_Pos = 0x6
	// Bit mask of CMPLCHA22 field.
	ADC120_ADCMPLR1_CMPLCHA22_Msk = 0x40
	// Bit CMPLCHA22.
	ADC120_ADCMPLR1_CMPLCHA22 = 0x40
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA22_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA22_1 = 0x1
	// Position of CMPLCHA23 field.
	ADC120_ADCMPLR1_CMPLCHA23_Pos = 0x7
	// Bit mask of CMPLCHA23 field.
	ADC120_ADCMPLR1_CMPLCHA23_Msk = 0x80
	// Bit CMPLCHA23.
	ADC120_ADCMPLR1_CMPLCHA23 = 0x80
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA23_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA23_1 = 0x1
	// Position of CMPLCHA24 field.
	ADC120_ADCMPLR1_CMPLCHA24_Pos = 0x8
	// Bit mask of CMPLCHA24 field.
	ADC120_ADCMPLR1_CMPLCHA24_Msk = 0x100
	// Bit CMPLCHA24.
	ADC120_ADCMPLR1_CMPLCHA24 = 0x100
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA24_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA24_1 = 0x1
	// Position of CMPLCHA25 field.
	ADC120_ADCMPLR1_CMPLCHA25_Pos = 0x9
	// Bit mask of CMPLCHA25 field.
	ADC120_ADCMPLR1_CMPLCHA25_Msk = 0x200
	// Bit CMPLCHA25.
	ADC120_ADCMPLR1_CMPLCHA25 = 0x200
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA25_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA25_1 = 0x1
	// Position of CMPLCHA26 field.
	ADC120_ADCMPLR1_CMPLCHA26_Pos = 0xa
	// Bit mask of CMPLCHA26 field.
	ADC120_ADCMPLR1_CMPLCHA26_Msk = 0x400
	// Bit CMPLCHA26.
	ADC120_ADCMPLR1_CMPLCHA26 = 0x400
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA26_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA26_1 = 0x1
	// Position of CMPLCHA27 field.
	ADC120_ADCMPLR1_CMPLCHA27_Pos = 0xb
	// Bit mask of CMPLCHA27 field.
	ADC120_ADCMPLR1_CMPLCHA27_Msk = 0x800
	// Bit CMPLCHA27.
	ADC120_ADCMPLR1_CMPLCHA27 = 0x800
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA27_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA27_1 = 0x1
	// Position of CMPLCHA28 field.
	ADC120_ADCMPLR1_CMPLCHA28_Pos = 0xc
	// Bit mask of CMPLCHA28 field.
	ADC120_ADCMPLR1_CMPLCHA28_Msk = 0x1000
	// Bit CMPLCHA28.
	ADC120_ADCMPLR1_CMPLCHA28 = 0x1000
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA28_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA28_1 = 0x1
	// Position of CMPLCHA29 field.
	ADC120_ADCMPLR1_CMPLCHA29_Pos = 0xd
	// Bit mask of CMPLCHA29 field.
	ADC120_ADCMPLR1_CMPLCHA29_Msk = 0x2000
	// Bit CMPLCHA29.
	ADC120_ADCMPLR1_CMPLCHA29 = 0x2000
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA29_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA29_1 = 0x1
	// Position of CMPLCHA30 field.
	ADC120_ADCMPLR1_CMPLCHA30_Pos = 0xe
	// Bit mask of CMPLCHA30 field.
	ADC120_ADCMPLR1_CMPLCHA30_Msk = 0x4000
	// Bit CMPLCHA30.
	ADC120_ADCMPLR1_CMPLCHA30 = 0x4000
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA30_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA30_1 = 0x1
	// Position of CMPLCHA31 field.
	ADC120_ADCMPLR1_CMPLCHA31_Pos = 0xf
	// Bit mask of CMPLCHA31 field.
	ADC120_ADCMPLR1_CMPLCHA31_Msk = 0x8000
	// Bit CMPLCHA31.
	ADC120_ADCMPLR1_CMPLCHA31 = 0x8000
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADCMPDR0 value, or ADCMPDR1 value < A/D-converted value
	ADC120_ADCMPLR1_CMPLCHA31_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADCMPDR0 value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADCMPDR0 value < A/D-converted value < ADCMPDR1 value
	ADC120_ADCMPLR1_CMPLCHA31_1 = 0x1

	// ADCMPSR0: A/D Compare Function Window A Channel Status Register 0
	// Position of CMPSTCHA00 field.
	ADC120_ADCMPSR0_CMPSTCHA00_Pos = 0x0
	// Bit mask of CMPSTCHA00 field.
	ADC120_ADCMPSR0_CMPSTCHA00_Msk = 0x1
	// Bit CMPSTCHA00.
	ADC120_ADCMPSR0_CMPSTCHA00 = 0x1
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA00_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA00_1 = 0x1
	// Position of CMPSTCHA01 field.
	ADC120_ADCMPSR0_CMPSTCHA01_Pos = 0x1
	// Bit mask of CMPSTCHA01 field.
	ADC120_ADCMPSR0_CMPSTCHA01_Msk = 0x2
	// Bit CMPSTCHA01.
	ADC120_ADCMPSR0_CMPSTCHA01 = 0x2
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA01_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA01_1 = 0x1
	// Position of CMPSTCHA02 field.
	ADC120_ADCMPSR0_CMPSTCHA02_Pos = 0x2
	// Bit mask of CMPSTCHA02 field.
	ADC120_ADCMPSR0_CMPSTCHA02_Msk = 0x4
	// Bit CMPSTCHA02.
	ADC120_ADCMPSR0_CMPSTCHA02 = 0x4
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA02_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA02_1 = 0x1
	// Position of CMPSTCHA03 field.
	ADC120_ADCMPSR0_CMPSTCHA03_Pos = 0x3
	// Bit mask of CMPSTCHA03 field.
	ADC120_ADCMPSR0_CMPSTCHA03_Msk = 0x8
	// Bit CMPSTCHA03.
	ADC120_ADCMPSR0_CMPSTCHA03 = 0x8
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA03_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA03_1 = 0x1
	// Position of CMPSTCHA04 field.
	ADC120_ADCMPSR0_CMPSTCHA04_Pos = 0x4
	// Bit mask of CMPSTCHA04 field.
	ADC120_ADCMPSR0_CMPSTCHA04_Msk = 0x10
	// Bit CMPSTCHA04.
	ADC120_ADCMPSR0_CMPSTCHA04 = 0x10
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA04_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA04_1 = 0x1
	// Position of CMPSTCHA05 field.
	ADC120_ADCMPSR0_CMPSTCHA05_Pos = 0x5
	// Bit mask of CMPSTCHA05 field.
	ADC120_ADCMPSR0_CMPSTCHA05_Msk = 0x20
	// Bit CMPSTCHA05.
	ADC120_ADCMPSR0_CMPSTCHA05 = 0x20
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA05_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA05_1 = 0x1
	// Position of CMPSTCHA06 field.
	ADC120_ADCMPSR0_CMPSTCHA06_Pos = 0x6
	// Bit mask of CMPSTCHA06 field.
	ADC120_ADCMPSR0_CMPSTCHA06_Msk = 0x40
	// Bit CMPSTCHA06.
	ADC120_ADCMPSR0_CMPSTCHA06 = 0x40
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA06_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA06_1 = 0x1
	// Position of CMPSTCHA07 field.
	ADC120_ADCMPSR0_CMPSTCHA07_Pos = 0x7
	// Bit mask of CMPSTCHA07 field.
	ADC120_ADCMPSR0_CMPSTCHA07_Msk = 0x80
	// Bit CMPSTCHA07.
	ADC120_ADCMPSR0_CMPSTCHA07 = 0x80
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA07_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA07_1 = 0x1
	// Position of CMPSTCHA08 field.
	ADC120_ADCMPSR0_CMPSTCHA08_Pos = 0x8
	// Bit mask of CMPSTCHA08 field.
	ADC120_ADCMPSR0_CMPSTCHA08_Msk = 0x100
	// Bit CMPSTCHA08.
	ADC120_ADCMPSR0_CMPSTCHA08 = 0x100
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA08_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA08_1 = 0x1
	// Position of CMPSTCHA09 field.
	ADC120_ADCMPSR0_CMPSTCHA09_Pos = 0x9
	// Bit mask of CMPSTCHA09 field.
	ADC120_ADCMPSR0_CMPSTCHA09_Msk = 0x200
	// Bit CMPSTCHA09.
	ADC120_ADCMPSR0_CMPSTCHA09 = 0x200
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA09_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA09_1 = 0x1
	// Position of CMPSTCHA10 field.
	ADC120_ADCMPSR0_CMPSTCHA10_Pos = 0xa
	// Bit mask of CMPSTCHA10 field.
	ADC120_ADCMPSR0_CMPSTCHA10_Msk = 0x400
	// Bit CMPSTCHA10.
	ADC120_ADCMPSR0_CMPSTCHA10 = 0x400
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA10_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA10_1 = 0x1
	// Position of CMPSTCHA11 field.
	ADC120_ADCMPSR0_CMPSTCHA11_Pos = 0xb
	// Bit mask of CMPSTCHA11 field.
	ADC120_ADCMPSR0_CMPSTCHA11_Msk = 0x800
	// Bit CMPSTCHA11.
	ADC120_ADCMPSR0_CMPSTCHA11 = 0x800
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA11_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA11_1 = 0x1
	// Position of CMPSTCHA12 field.
	ADC120_ADCMPSR0_CMPSTCHA12_Pos = 0xc
	// Bit mask of CMPSTCHA12 field.
	ADC120_ADCMPSR0_CMPSTCHA12_Msk = 0x1000
	// Bit CMPSTCHA12.
	ADC120_ADCMPSR0_CMPSTCHA12 = 0x1000
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA12_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA12_1 = 0x1
	// Position of CMPSTCHA13 field.
	ADC120_ADCMPSR0_CMPSTCHA13_Pos = 0xd
	// Bit mask of CMPSTCHA13 field.
	ADC120_ADCMPSR0_CMPSTCHA13_Msk = 0x2000
	// Bit CMPSTCHA13.
	ADC120_ADCMPSR0_CMPSTCHA13 = 0x2000
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA13_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA13_1 = 0x1
	// Position of CMPSTCHA14 field.
	ADC120_ADCMPSR0_CMPSTCHA14_Pos = 0xe
	// Bit mask of CMPSTCHA14 field.
	ADC120_ADCMPSR0_CMPSTCHA14_Msk = 0x4000
	// Bit CMPSTCHA14.
	ADC120_ADCMPSR0_CMPSTCHA14 = 0x4000
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA14_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA14_1 = 0x1
	// Position of CMPSTCHA15 field.
	ADC120_ADCMPSR0_CMPSTCHA15_Pos = 0xf
	// Bit mask of CMPSTCHA15 field.
	ADC120_ADCMPSR0_CMPSTCHA15_Msk = 0x8000
	// Bit CMPSTCHA15.
	ADC120_ADCMPSR0_CMPSTCHA15 = 0x8000
	// Comparison conditions are not met.
	ADC120_ADCMPSR0_CMPSTCHA15_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR0_CMPSTCHA15_1 = 0x1

	// ADCMPSR1: A/D Compare Function Window A Channel Status Register1
	// Position of CMPSTCHA16 field.
	ADC120_ADCMPSR1_CMPSTCHA16_Pos = 0x0
	// Bit mask of CMPSTCHA16 field.
	ADC120_ADCMPSR1_CMPSTCHA16_Msk = 0x1
	// Bit CMPSTCHA16.
	ADC120_ADCMPSR1_CMPSTCHA16 = 0x1
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA16_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA16_1 = 0x1
	// Position of CMPSTCHA17 field.
	ADC120_ADCMPSR1_CMPSTCHA17_Pos = 0x1
	// Bit mask of CMPSTCHA17 field.
	ADC120_ADCMPSR1_CMPSTCHA17_Msk = 0x2
	// Bit CMPSTCHA17.
	ADC120_ADCMPSR1_CMPSTCHA17 = 0x2
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA17_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA17_1 = 0x1
	// Position of CMPSTCHA18 field.
	ADC120_ADCMPSR1_CMPSTCHA18_Pos = 0x2
	// Bit mask of CMPSTCHA18 field.
	ADC120_ADCMPSR1_CMPSTCHA18_Msk = 0x4
	// Bit CMPSTCHA18.
	ADC120_ADCMPSR1_CMPSTCHA18 = 0x4
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA18_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA18_1 = 0x1
	// Position of CMPSTCHA19 field.
	ADC120_ADCMPSR1_CMPSTCHA19_Pos = 0x3
	// Bit mask of CMPSTCHA19 field.
	ADC120_ADCMPSR1_CMPSTCHA19_Msk = 0x8
	// Bit CMPSTCHA19.
	ADC120_ADCMPSR1_CMPSTCHA19 = 0x8
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA19_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA19_1 = 0x1
	// Position of CMPSTCHA20 field.
	ADC120_ADCMPSR1_CMPSTCHA20_Pos = 0x4
	// Bit mask of CMPSTCHA20 field.
	ADC120_ADCMPSR1_CMPSTCHA20_Msk = 0x10
	// Bit CMPSTCHA20.
	ADC120_ADCMPSR1_CMPSTCHA20 = 0x10
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA20_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA20_1 = 0x1
	// Position of CMPSTCHA21 field.
	ADC120_ADCMPSR1_CMPSTCHA21_Pos = 0x5
	// Bit mask of CMPSTCHA21 field.
	ADC120_ADCMPSR1_CMPSTCHA21_Msk = 0x20
	// Bit CMPSTCHA21.
	ADC120_ADCMPSR1_CMPSTCHA21 = 0x20
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA21_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA21_1 = 0x1
	// Position of CMPSTCHA22 field.
	ADC120_ADCMPSR1_CMPSTCHA22_Pos = 0x6
	// Bit mask of CMPSTCHA22 field.
	ADC120_ADCMPSR1_CMPSTCHA22_Msk = 0x40
	// Bit CMPSTCHA22.
	ADC120_ADCMPSR1_CMPSTCHA22 = 0x40
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA22_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA22_1 = 0x1
	// Position of CMPSTCHA23 field.
	ADC120_ADCMPSR1_CMPSTCHA23_Pos = 0x7
	// Bit mask of CMPSTCHA23 field.
	ADC120_ADCMPSR1_CMPSTCHA23_Msk = 0x80
	// Bit CMPSTCHA23.
	ADC120_ADCMPSR1_CMPSTCHA23 = 0x80
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA23_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA23_1 = 0x1
	// Position of CMPSTCHA24 field.
	ADC120_ADCMPSR1_CMPSTCHA24_Pos = 0x8
	// Bit mask of CMPSTCHA24 field.
	ADC120_ADCMPSR1_CMPSTCHA24_Msk = 0x100
	// Bit CMPSTCHA24.
	ADC120_ADCMPSR1_CMPSTCHA24 = 0x100
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA24_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA24_1 = 0x1
	// Position of CMPSTCHA25 field.
	ADC120_ADCMPSR1_CMPSTCHA25_Pos = 0x9
	// Bit mask of CMPSTCHA25 field.
	ADC120_ADCMPSR1_CMPSTCHA25_Msk = 0x200
	// Bit CMPSTCHA25.
	ADC120_ADCMPSR1_CMPSTCHA25 = 0x200
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA25_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA25_1 = 0x1
	// Position of CMPSTCHA26 field.
	ADC120_ADCMPSR1_CMPSTCHA26_Pos = 0xa
	// Bit mask of CMPSTCHA26 field.
	ADC120_ADCMPSR1_CMPSTCHA26_Msk = 0x400
	// Bit CMPSTCHA26.
	ADC120_ADCMPSR1_CMPSTCHA26 = 0x400
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA26_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA26_1 = 0x1
	// Position of CMPSTCHA27 field.
	ADC120_ADCMPSR1_CMPSTCHA27_Pos = 0xb
	// Bit mask of CMPSTCHA27 field.
	ADC120_ADCMPSR1_CMPSTCHA27_Msk = 0x800
	// Bit CMPSTCHA27.
	ADC120_ADCMPSR1_CMPSTCHA27 = 0x800
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA27_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA27_1 = 0x1
	// Position of CMPSTCHA28 field.
	ADC120_ADCMPSR1_CMPSTCHA28_Pos = 0xc
	// Bit mask of CMPSTCHA28 field.
	ADC120_ADCMPSR1_CMPSTCHA28_Msk = 0x1000
	// Bit CMPSTCHA28.
	ADC120_ADCMPSR1_CMPSTCHA28 = 0x1000
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA28_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA28_1 = 0x1
	// Position of CMPSTCHA29 field.
	ADC120_ADCMPSR1_CMPSTCHA29_Pos = 0xd
	// Bit mask of CMPSTCHA29 field.
	ADC120_ADCMPSR1_CMPSTCHA29_Msk = 0x2000
	// Bit CMPSTCHA29.
	ADC120_ADCMPSR1_CMPSTCHA29 = 0x2000
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA29_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA29_1 = 0x1
	// Position of CMPSTCHA30 field.
	ADC120_ADCMPSR1_CMPSTCHA30_Pos = 0xe
	// Bit mask of CMPSTCHA30 field.
	ADC120_ADCMPSR1_CMPSTCHA30_Msk = 0x4000
	// Bit CMPSTCHA30.
	ADC120_ADCMPSR1_CMPSTCHA30 = 0x4000
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA30_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA30_1 = 0x1
	// Position of CMPSTCHA31 field.
	ADC120_ADCMPSR1_CMPSTCHA31_Pos = 0xf
	// Bit mask of CMPSTCHA31 field.
	ADC120_ADCMPSR1_CMPSTCHA31_Msk = 0x8000
	// Bit CMPSTCHA31.
	ADC120_ADCMPSR1_CMPSTCHA31 = 0x8000
	// Comparison conditions are not met.
	ADC120_ADCMPSR1_CMPSTCHA31_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSR1_CMPSTCHA31_1 = 0x1

	// ADCMPSER: A/D Compare Function Window A Extended Input Channel Status Register
	// Position of CMPSTTSA field.
	ADC120_ADCMPSER_CMPSTTSA_Pos = 0x0
	// Bit mask of CMPSTTSA field.
	ADC120_ADCMPSER_CMPSTTSA_Msk = 0x1
	// Bit CMPSTTSA.
	ADC120_ADCMPSER_CMPSTTSA = 0x1
	// Comparison conditions are not met.
	ADC120_ADCMPSER_CMPSTTSA_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSER_CMPSTTSA_1 = 0x1
	// Position of CMPSTOCA field.
	ADC120_ADCMPSER_CMPSTOCA_Pos = 0x1
	// Bit mask of CMPSTOCA field.
	ADC120_ADCMPSER_CMPSTOCA_Msk = 0x2
	// Bit CMPSTOCA.
	ADC120_ADCMPSER_CMPSTOCA = 0x2
	// Comparison conditions are not met.
	ADC120_ADCMPSER_CMPSTOCA_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPSER_CMPSTOCA_1 = 0x1

	// ADCMPBNSR: A/D Compare Function Window B Channel Select Register
	// Position of CMPCHB field.
	ADC120_ADCMPBNSR_CMPCHB_Pos = 0x0
	// Bit mask of CMPCHB field.
	ADC120_ADCMPBNSR_CMPCHB_Msk = 0x3f
	// Position of CMPLB field.
	ADC120_ADCMPBNSR_CMPLB_Pos = 0x7
	// Bit mask of CMPLB field.
	ADC120_ADCMPBNSR_CMPLB_Msk = 0x80
	// Bit CMPLB.
	ADC120_ADCMPBNSR_CMPLB = 0x80
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADWINLLB value > A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): A/D-converted value < ADWINLLB value, or ADWINULB value < A/D-converted value
	ADC120_ADCMPBNSR_CMPLB_0 = 0x0
	// When window function is disabled (ADCMPCR.WCMPE = 0): ADWINLLB value < A/D-converted value When window function is enabled (ADCMPCR.WCMPE = 1): ADWINLLB value < A/D-converted value < ADWINULB value
	ADC120_ADCMPBNSR_CMPLB_1 = 0x1

	// ADCMPBSR: A/D Compare Function Window B Status Register
	// Position of CMPSTB field.
	ADC120_ADCMPBSR_CMPSTB_Pos = 0x0
	// Bit mask of CMPSTB field.
	ADC120_ADCMPBSR_CMPSTB_Msk = 0x1
	// Bit CMPSTB.
	ADC120_ADCMPBSR_CMPSTB = 0x1
	// Comparison conditions are not met.
	ADC120_ADCMPBSR_CMPSTB_0 = 0x0
	// Comparison conditions are met.
	ADC120_ADCMPBSR_CMPSTB_1 = 0x1

	// ADSSTRL: A/D Sampling State Register
	// Position of SST field.
	ADC120_ADSSTRL_SST_Pos = 0x0
	// Bit mask of SST field.
	ADC120_ADSSTRL_SST_Msk = 0xff

	// ADSSTRT: A/D Sampling State Register
	// Position of SST field.
	ADC120_ADSSTRT_SST_Pos = 0x0
	// Bit mask of SST field.
	ADC120_ADSSTRT_SST_Msk = 0xff

	// ADSSTRO: A/D Sampling State Register
	// Position of SST field.
	ADC120_ADSSTRO_SST_Pos = 0x0
	// Bit mask of SST field.
	ADC120_ADSSTRO_SST_Msk = 0xff

	// ADSSTR5: A/D Sampling State Register
	// Position of SST field.
	ADC120_ADSSTR_SST_Pos = 0x0
	// Bit mask of SST field.
	ADC120_ADSSTR_SST_Msk = 0xff

	// ADSSTR9: A/D Sampling State Register
	// Position of SST field.
	ADC120_ADSSTR_SST_Pos = 0x0
	// Bit mask of SST field.
	ADC120_ADSSTR_SST_Msk = 0xff
)

// Constants for SCI9: Serial Communication Interface 0
const (
	// SMR: Serial Mode Register for Non-Smart Card Interface Mode (SCMR.SMIF = 0)
	// Position of CKS field.
	SCI9_SMR_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SCI9_SMR_CKS_Msk = 0x3
	// PCLK clock (n = 0)
	SCI9_SMR_CKS_00 = 0x0
	// PCLK/4 clock (n = 1)
	SCI9_SMR_CKS_01 = 0x1
	// PCLK/16 clock (n = 2)
	SCI9_SMR_CKS_10 = 0x2
	// PCLK/64 clock (n = 3)
	SCI9_SMR_CKS_11 = 0x3
	// Position of MP field.
	SCI9_SMR_MP_Pos = 0x2
	// Bit mask of MP field.
	SCI9_SMR_MP_Msk = 0x4
	// Bit MP.
	SCI9_SMR_MP = 0x4
	// Disable multi-processor communications function
	SCI9_SMR_MP_0 = 0x0
	// Enable multi-processor communications function
	SCI9_SMR_MP_1 = 0x1
	// Position of STOP field.
	SCI9_SMR_STOP_Pos = 0x3
	// Bit mask of STOP field.
	SCI9_SMR_STOP_Msk = 0x8
	// Bit STOP.
	SCI9_SMR_STOP = 0x8
	// 1 stop bit
	SCI9_SMR_STOP_0 = 0x0
	// 2 stop bits
	SCI9_SMR_STOP_1 = 0x1
	// Position of PM field.
	SCI9_SMR_PM_Pos = 0x4
	// Bit mask of PM field.
	SCI9_SMR_PM_Msk = 0x10
	// Bit PM.
	SCI9_SMR_PM = 0x10
	// Even parity
	SCI9_SMR_PM_0 = 0x0
	// Odd parity
	SCI9_SMR_PM_1 = 0x1
	// Position of PE field.
	SCI9_SMR_PE_Pos = 0x5
	// Bit mask of PE field.
	SCI9_SMR_PE_Msk = 0x20
	// Bit PE.
	SCI9_SMR_PE = 0x20
	// When transmitting: Do not add parity bit When receiving: Do not check parity bit
	SCI9_SMR_PE_0 = 0x0
	// When transmitting: Add parity bit When receiving: Check parity bit
	SCI9_SMR_PE_1 = 0x1
	// Position of CHR field.
	SCI9_SMR_CHR_Pos = 0x6
	// Bit mask of CHR field.
	SCI9_SMR_CHR_Msk = 0x40
	// Bit CHR.
	SCI9_SMR_CHR = 0x40
	// SCMR.CHR1 = 0: Transmit/receive in 9-bit data length SCMR.CHR1 = 1: Transmit/receive in 8-bit data length (initial value)
	SCI9_SMR_CHR_0 = 0x0
	// SCMR.CHR1 = 0: Transmit/receive in 9-bit data length SCMR.CHR1 = 1: Transmit/receive in 7-bit data length
	SCI9_SMR_CHR_1 = 0x1
	// Position of CM field.
	SCI9_SMR_CM_Pos = 0x7
	// Bit mask of CM field.
	SCI9_SMR_CM_Msk = 0x80
	// Bit CM.
	SCI9_SMR_CM = 0x80
	// Asynchronous mode or simple IIC mode
	SCI9_SMR_CM_0 = 0x0
	// Clock synchronous mode or simple SPI mode
	SCI9_SMR_CM_1 = 0x1

	// SMR_SMCI: Serial Mode Register for Smart Card Interface Mode (SCMR.SMIF = 1)
	// Position of CKS field.
	SCI9_SMR_SMCI_CKS_Pos = 0x0
	// Bit mask of CKS field.
	SCI9_SMR_SMCI_CKS_Msk = 0x3
	// PCLK clock (n = 0)
	SCI9_SMR_SMCI_CKS_00 = 0x0
	// PCLK/4 clock (n = 1)
	SCI9_SMR_SMCI_CKS_01 = 0x1
	// PCLK/16 clock (n = 2)
	SCI9_SMR_SMCI_CKS_10 = 0x2
	// PCLK/64 clock (n = 3)
	SCI9_SMR_SMCI_CKS_11 = 0x3
	// Position of BCP field.
	SCI9_SMR_SMCI_BCP_Pos = 0x2
	// Bit mask of BCP field.
	SCI9_SMR_SMCI_BCP_Msk = 0xc
	// Position of PM field.
	SCI9_SMR_SMCI_PM_Pos = 0x4
	// Bit mask of PM field.
	SCI9_SMR_SMCI_PM_Msk = 0x10
	// Bit PM.
	SCI9_SMR_SMCI_PM = 0x10
	// Even parity
	SCI9_SMR_SMCI_PM_0 = 0x0
	// Odd parity
	SCI9_SMR_SMCI_PM_1 = 0x1
	// Position of PE field.
	SCI9_SMR_SMCI_PE_Pos = 0x5
	// Bit mask of PE field.
	SCI9_SMR_SMCI_PE_Msk = 0x20
	// Bit PE.
	SCI9_SMR_SMCI_PE = 0x20
	// Position of BLK field.
	SCI9_SMR_SMCI_BLK_Pos = 0x6
	// Bit mask of BLK field.
	SCI9_SMR_SMCI_BLK_Msk = 0x40
	// Bit BLK.
	SCI9_SMR_SMCI_BLK = 0x40
	// Normal mode operation
	SCI9_SMR_SMCI_BLK_0 = 0x0
	// Block transfer mode operation
	SCI9_SMR_SMCI_BLK_1 = 0x1
	// Position of GM field.
	SCI9_SMR_SMCI_GM_Pos = 0x7
	// Bit mask of GM field.
	SCI9_SMR_SMCI_GM_Msk = 0x80
	// Bit GM.
	SCI9_SMR_SMCI_GM = 0x80
	// Normal mode operation
	SCI9_SMR_SMCI_GM_0 = 0x0
	// GSM mode operation
	SCI9_SMR_SMCI_GM_1 = 0x1

	// SCR: Serial Control Register for Non-Smart Card Interface Mode (SCMR.SMIF = 0)
	// Position of CKE field.
	SCI9_SCR_CKE_Pos = 0x0
	// Bit mask of CKE field.
	SCI9_SCR_CKE_Msk = 0x3
	// In asynchronous mode, the SCKn pin is available for use as an I/O port based on the I/O port settings. In clock synchronous mode, the SCKn pin functions as the clock output pin.
	SCI9_SCR_CKE_00 = 0x0
	// In asynchronous mode, a clock with the same frequency as the bit rate is output from the SCKn pin. In clock synchronous mode, the SCKn pin functions as the clock output pin.
	SCI9_SCR_CKE_01 = 0x1
	// Position of TEIE field.
	SCI9_SCR_TEIE_Pos = 0x2
	// Bit mask of TEIE field.
	SCI9_SCR_TEIE_Msk = 0x4
	// Bit TEIE.
	SCI9_SCR_TEIE = 0x4
	// Disable SCIn_TEI interrupt requests
	SCI9_SCR_TEIE_0 = 0x0
	// Enable SCIn_TEI interrupt requests
	SCI9_SCR_TEIE_1 = 0x1
	// Position of MPIE field.
	SCI9_SCR_MPIE_Pos = 0x3
	// Bit mask of MPIE field.
	SCI9_SCR_MPIE_Msk = 0x8
	// Bit MPIE.
	SCI9_SCR_MPIE = 0x8
	// Normal reception
	SCI9_SCR_MPIE_0 = 0x0
	// When data with the multi-processor bit set to 0 is received, the data is not read, and setting the status flags RDRF, ORER, and FER in SSR to 1. When data with the multi-processor bit set to 1 is received, the MPIE bit is automatically set to 0, and normal reception is resumed.
	SCI9_SCR_MPIE_1 = 0x1
	// Position of RE field.
	SCI9_SCR_RE_Pos = 0x4
	// Bit mask of RE field.
	SCI9_SCR_RE_Msk = 0x10
	// Bit RE.
	SCI9_SCR_RE = 0x10
	// Disable serial reception
	SCI9_SCR_RE_0 = 0x0
	// Enable serial reception
	SCI9_SCR_RE_1 = 0x1
	// Position of TE field.
	SCI9_SCR_TE_Pos = 0x5
	// Bit mask of TE field.
	SCI9_SCR_TE_Msk = 0x20
	// Bit TE.
	SCI9_SCR_TE = 0x20
	// Disable serial transmission
	SCI9_SCR_TE_0 = 0x0
	// Enable serial transmission
	SCI9_SCR_TE_1 = 0x1
	// Position of RIE field.
	SCI9_SCR_RIE_Pos = 0x6
	// Bit mask of RIE field.
	SCI9_SCR_RIE_Msk = 0x40
	// Bit RIE.
	SCI9_SCR_RIE = 0x40
	// Disable SCIn_RXI and SCIn_ERI interrupt requests
	SCI9_SCR_RIE_0 = 0x0
	// Enable SCIn_RXI and SCIn_ERI interrupt requests
	SCI9_SCR_RIE_1 = 0x1
	// Position of TIE field.
	SCI9_SCR_TIE_Pos = 0x7
	// Bit mask of TIE field.
	SCI9_SCR_TIE_Msk = 0x80
	// Bit TIE.
	SCI9_SCR_TIE = 0x80
	// Disable SCIn_TXI interrupt requests
	SCI9_SCR_TIE_0 = 0x0
	// Enable SCIn_TXI interrupt requests
	SCI9_SCR_TIE_1 = 0x1

	// SCR_SMCI: Serial Control Register for Smart Card Interface Mode (SCMR.SMIF = 1)
	// Position of CKE field.
	SCI9_SCR_SMCI_CKE_Pos = 0x0
	// Bit mask of CKE field.
	SCI9_SCR_SMCI_CKE_Msk = 0x3
	// When SMR_SMCI.GM = 0: Disable output The SCKn pin is available for use as an I/O port if set up in the I/O port settings When SMR_SMCI.GM = 1: Fix output low
	SCI9_SCR_SMCI_CKE_00 = 0x0
	// When SMR_SMCI.GM = 0: Output clock When SMR_SMCI.GM = 1: Output clock
	SCI9_SCR_SMCI_CKE_01 = 0x1
	// When SMR_SMCI.GM = 0: Setting prohibited When SMR_SMCI.GM = 1: Fix output high
	SCI9_SCR_SMCI_CKE_10 = 0x2
	// When SMR_SMCI.GM = 0: Setting prohibited When SMR_SMCI.GM = 1: Output clock
	SCI9_SCR_SMCI_CKE_11 = 0x3
	// Position of TEIE field.
	SCI9_SCR_SMCI_TEIE_Pos = 0x2
	// Bit mask of TEIE field.
	SCI9_SCR_SMCI_TEIE_Msk = 0x4
	// Bit TEIE.
	SCI9_SCR_SMCI_TEIE = 0x4
	// Position of MPIE field.
	SCI9_SCR_SMCI_MPIE_Pos = 0x3
	// Bit mask of MPIE field.
	SCI9_SCR_SMCI_MPIE_Msk = 0x8
	// Bit MPIE.
	SCI9_SCR_SMCI_MPIE = 0x8
	// Position of RE field.
	SCI9_SCR_SMCI_RE_Pos = 0x4
	// Bit mask of RE field.
	SCI9_SCR_SMCI_RE_Msk = 0x10
	// Bit RE.
	SCI9_SCR_SMCI_RE = 0x10
	// Disable serial reception
	SCI9_SCR_SMCI_RE_0 = 0x0
	// Enable serial reception
	SCI9_SCR_SMCI_RE_1 = 0x1
	// Position of TE field.
	SCI9_SCR_SMCI_TE_Pos = 0x5
	// Bit mask of TE field.
	SCI9_SCR_SMCI_TE_Msk = 0x20
	// Bit TE.
	SCI9_SCR_SMCI_TE = 0x20
	// Disable serial transmission
	SCI9_SCR_SMCI_TE_0 = 0x0
	// Enable serial transmission
	SCI9_SCR_SMCI_TE_1 = 0x1
	// Position of RIE field.
	SCI9_SCR_SMCI_RIE_Pos = 0x6
	// Bit mask of RIE field.
	SCI9_SCR_SMCI_RIE_Msk = 0x40
	// Bit RIE.
	SCI9_SCR_SMCI_RIE = 0x40
	// Disable SCIn_RXI and SCIn_ERI interrupt requests
	SCI9_SCR_SMCI_RIE_0 = 0x0
	// Enable SCIn_RXI and SCIn_ERI interrupt requests
	SCI9_SCR_SMCI_RIE_1 = 0x1
	// Position of TIE field.
	SCI9_SCR_SMCI_TIE_Pos = 0x7
	// Bit mask of TIE field.
	SCI9_SCR_SMCI_TIE_Msk = 0x80
	// Bit TIE.
	SCI9_SCR_SMCI_TIE = 0x80
	// Disable SCIn_TXI interrupt requests
	SCI9_SCR_SMCI_TIE_0 = 0x0
	// Enable SCIn_TXI interrupt requests
	SCI9_SCR_SMCI_TIE_1 = 0x1

	// SSR: Serial Status Register for Non-Smart Card Interface (SCMR.SMIF = 0)
	// Position of MPBT field.
	SCI9_SSR_MPBT_Pos = 0x0
	// Bit mask of MPBT field.
	SCI9_SSR_MPBT_Msk = 0x1
	// Bit MPBT.
	SCI9_SSR_MPBT = 0x1
	// Data transmission cycle
	SCI9_SSR_MPBT_0 = 0x0
	// ID transmission cycle
	SCI9_SSR_MPBT_1 = 0x1
	// Position of MPB field.
	SCI9_SSR_MPB_Pos = 0x1
	// Bit mask of MPB field.
	SCI9_SSR_MPB_Msk = 0x2
	// Bit MPB.
	SCI9_SSR_MPB = 0x2
	// Data transmission cycle
	SCI9_SSR_MPB_0 = 0x0
	// ID transmission cycle
	SCI9_SSR_MPB_1 = 0x1
	// Position of TEND field.
	SCI9_SSR_TEND_Pos = 0x2
	// Bit mask of TEND field.
	SCI9_SSR_TEND_Msk = 0x4
	// Bit TEND.
	SCI9_SSR_TEND = 0x4
	// A character is being transmitted
	SCI9_SSR_TEND_0 = 0x0
	// Character transfer is complete
	SCI9_SSR_TEND_1 = 0x1
	// Position of PER field.
	SCI9_SSR_PER_Pos = 0x3
	// Bit mask of PER field.
	SCI9_SSR_PER_Msk = 0x8
	// Bit PER.
	SCI9_SSR_PER = 0x8
	// No parity error occurred
	SCI9_SSR_PER_0 = 0x0
	// Parity error occurred
	SCI9_SSR_PER_1 = 0x1
	// Position of FER field.
	SCI9_SSR_FER_Pos = 0x4
	// Bit mask of FER field.
	SCI9_SSR_FER_Msk = 0x10
	// Bit FER.
	SCI9_SSR_FER = 0x10
	// No framing error occurred
	SCI9_SSR_FER_0 = 0x0
	// Framing error occurred
	SCI9_SSR_FER_1 = 0x1
	// Position of ORER field.
	SCI9_SSR_ORER_Pos = 0x5
	// Bit mask of ORER field.
	SCI9_SSR_ORER_Msk = 0x20
	// Bit ORER.
	SCI9_SSR_ORER = 0x20
	// No overrun error occurred
	SCI9_SSR_ORER_0 = 0x0
	// Overrun error occurred
	SCI9_SSR_ORER_1 = 0x1
	// Position of RDRF field.
	SCI9_SSR_RDRF_Pos = 0x6
	// Bit mask of RDRF field.
	SCI9_SSR_RDRF_Msk = 0x40
	// Bit RDRF.
	SCI9_SSR_RDRF = 0x40
	// No received data in RDR register
	SCI9_SSR_RDRF_0 = 0x0
	// Received data in RDR register
	SCI9_SSR_RDRF_1 = 0x1
	// Position of TDRE field.
	SCI9_SSR_TDRE_Pos = 0x7
	// Bit mask of TDRE field.
	SCI9_SSR_TDRE_Msk = 0x80
	// Bit TDRE.
	SCI9_SSR_TDRE = 0x80
	// Transmit data in TDR register
	SCI9_SSR_TDRE_0 = 0x0
	// No transmit data in TDR register
	SCI9_SSR_TDRE_1 = 0x1

	// SSR_SMCI: Serial Status Register for Smart Card Interface Mode (SCMR.SMIF = 1)
	// Position of MPBT field.
	SCI9_SSR_SMCI_MPBT_Pos = 0x0
	// Bit mask of MPBT field.
	SCI9_SSR_SMCI_MPBT_Msk = 0x1
	// Bit MPBT.
	SCI9_SSR_SMCI_MPBT = 0x1
	// Position of MPB field.
	SCI9_SSR_SMCI_MPB_Pos = 0x1
	// Bit mask of MPB field.
	SCI9_SSR_SMCI_MPB_Msk = 0x2
	// Bit MPB.
	SCI9_SSR_SMCI_MPB = 0x2
	// Position of TEND field.
	SCI9_SSR_SMCI_TEND_Pos = 0x2
	// Bit mask of TEND field.
	SCI9_SSR_SMCI_TEND_Msk = 0x4
	// Bit TEND.
	SCI9_SSR_SMCI_TEND = 0x4
	// A character is being transmitted
	SCI9_SSR_SMCI_TEND_0 = 0x0
	// Character transfer is complete
	SCI9_SSR_SMCI_TEND_1 = 0x1
	// Position of PER field.
	SCI9_SSR_SMCI_PER_Pos = 0x3
	// Bit mask of PER field.
	SCI9_SSR_SMCI_PER_Msk = 0x8
	// Bit PER.
	SCI9_SSR_SMCI_PER = 0x8
	// No parity error occurred
	SCI9_SSR_SMCI_PER_0 = 0x0
	// Parity error occurred
	SCI9_SSR_SMCI_PER_1 = 0x1
	// Position of ERS field.
	SCI9_SSR_SMCI_ERS_Pos = 0x4
	// Bit mask of ERS field.
	SCI9_SSR_SMCI_ERS_Msk = 0x10
	// Bit ERS.
	SCI9_SSR_SMCI_ERS = 0x10
	// No low error signal response
	SCI9_SSR_SMCI_ERS_0 = 0x0
	// Low error signal response occurred
	SCI9_SSR_SMCI_ERS_1 = 0x1
	// Position of ORER field.
	SCI9_SSR_SMCI_ORER_Pos = 0x5
	// Bit mask of ORER field.
	SCI9_SSR_SMCI_ORER_Msk = 0x20
	// Bit ORER.
	SCI9_SSR_SMCI_ORER = 0x20
	// No overrun error occurred
	SCI9_SSR_SMCI_ORER_0 = 0x0
	// Overrun error occurred
	SCI9_SSR_SMCI_ORER_1 = 0x1
	// Position of RDRF field.
	SCI9_SSR_SMCI_RDRF_Pos = 0x6
	// Bit mask of RDRF field.
	SCI9_SSR_SMCI_RDRF_Msk = 0x40
	// Bit RDRF.
	SCI9_SSR_SMCI_RDRF = 0x40
	// No received data in RDR register
	SCI9_SSR_SMCI_RDRF_0 = 0x0
	// Received data in RDR register
	SCI9_SSR_SMCI_RDRF_1 = 0x1
	// Position of TDRE field.
	SCI9_SSR_SMCI_TDRE_Pos = 0x7
	// Bit mask of TDRE field.
	SCI9_SSR_SMCI_TDRE_Msk = 0x80
	// Bit TDRE.
	SCI9_SSR_SMCI_TDRE = 0x80
	// Transmit data in TDR register
	SCI9_SSR_SMCI_TDRE_0 = 0x0
	// No transmit data in TDR register
	SCI9_SSR_SMCI_TDRE_1 = 0x1

	// SCMR: Smart Card Mode Register
	// Position of SMIF field.
	SCI9_SCMR_SMIF_Pos = 0x0
	// Bit mask of SMIF field.
	SCI9_SCMR_SMIF_Msk = 0x1
	// Bit SMIF.
	SCI9_SCMR_SMIF = 0x1
	// Non-smart card interface mode (asynchronous mode, clock synchronous mode, simple SPI mode, or simple IIC mode)
	SCI9_SCMR_SMIF_0 = 0x0
	// Smart card interface mode
	SCI9_SCMR_SMIF_1 = 0x1
	// Position of SINV field.
	SCI9_SCMR_SINV_Pos = 0x2
	// Bit mask of SINV field.
	SCI9_SCMR_SINV_Msk = 0x4
	// Bit SINV.
	SCI9_SCMR_SINV = 0x4
	// TDR contents are transmitted as they are. Received data is stored as received in the RDR register.
	SCI9_SCMR_SINV_0 = 0x0
	// TDR register contents are inverted before transmission. Receive data is stored in inverted form in the RDR register.
	SCI9_SCMR_SINV_1 = 0x1
	// Position of SDIR field.
	SCI9_SCMR_SDIR_Pos = 0x3
	// Bit mask of SDIR field.
	SCI9_SCMR_SDIR_Msk = 0x8
	// Bit SDIR.
	SCI9_SCMR_SDIR = 0x8
	// Transfer LSB-first
	SCI9_SCMR_SDIR_0 = 0x0
	// Transfer MSB-first
	SCI9_SCMR_SDIR_1 = 0x1
	// Position of CHR1 field.
	SCI9_SCMR_CHR1_Pos = 0x4
	// Bit mask of CHR1 field.
	SCI9_SCMR_CHR1_Msk = 0x10
	// Bit CHR1.
	SCI9_SCMR_CHR1 = 0x10
	// SMR.CHR = 0: Transmit/receive in 9-bit data length SMR.CHR = 1: Transmit/receive in 9-bit data length
	SCI9_SCMR_CHR1_0 = 0x0
	// SMR.CHR = 0: Transmit/receive in 8-bit data length (initial value) SMR.CHR = 1: Transmit/receive in 7-bit data length
	SCI9_SCMR_CHR1_1 = 0x1
	// Position of BCP2 field.
	SCI9_SCMR_BCP2_Pos = 0x7
	// Bit mask of BCP2 field.
	SCI9_SCMR_BCP2_Msk = 0x80
	// Bit BCP2.
	SCI9_SCMR_BCP2 = 0x80

	// SEMR: Serial Extended Mode Register
	// Position of BRME field.
	SCI9_SEMR_BRME_Pos = 0x2
	// Bit mask of BRME field.
	SCI9_SEMR_BRME_Msk = 0x4
	// Bit BRME.
	SCI9_SEMR_BRME = 0x4
	// Disable bit rate modulation function
	SCI9_SEMR_BRME_0 = 0x0
	// Enable bit rate modulation function
	SCI9_SEMR_BRME_1 = 0x1
	// Position of ABCSE field.
	SCI9_SEMR_ABCSE_Pos = 0x3
	// Bit mask of ABCSE field.
	SCI9_SEMR_ABCSE_Msk = 0x8
	// Bit ABCSE.
	SCI9_SEMR_ABCSE = 0x8
	// Clock cycles for 1-bit period determined by combination of the BGDM and ABCS bits in the SEMR register
	SCI9_SEMR_ABCSE_0 = 0x0
	// Baud rate is 6 base clock cycles for 1-bit period
	SCI9_SEMR_ABCSE_1 = 0x1
	// Position of ABCS field.
	SCI9_SEMR_ABCS_Pos = 0x4
	// Bit mask of ABCS field.
	SCI9_SEMR_ABCS_Msk = 0x10
	// Bit ABCS.
	SCI9_SEMR_ABCS = 0x10
	// Select 16 base clock cycles for 1-bit period
	SCI9_SEMR_ABCS_0 = 0x0
	// Select 8 base clock cycles for 1-bit period
	SCI9_SEMR_ABCS_1 = 0x1
	// Position of NFEN field.
	SCI9_SEMR_NFEN_Pos = 0x5
	// Bit mask of NFEN field.
	SCI9_SEMR_NFEN_Msk = 0x20
	// Bit NFEN.
	SCI9_SEMR_NFEN = 0x20
	// In asynchronous mode: Disable noise cancellation function for RXDn input signal In simple I2C mode: Disable noise cancellation function for SCLn and SDAn input signals
	SCI9_SEMR_NFEN_0 = 0x0
	// In asynchronous mode: Enable noise cancellation function for RXDn input signal In simple I2C mode: Enable noise cancellation function for SCLn and SDAn input signals
	SCI9_SEMR_NFEN_1 = 0x1
	// Position of BGDM field.
	SCI9_SEMR_BGDM_Pos = 0x6
	// Bit mask of BGDM field.
	SCI9_SEMR_BGDM_Msk = 0x40
	// Bit BGDM.
	SCI9_SEMR_BGDM = 0x40
	// Output clock from baud rate generator with normal frequency
	SCI9_SEMR_BGDM_0 = 0x0
	// Output clock from baud rate generator with doubled frequency
	SCI9_SEMR_BGDM_1 = 0x1
	// Position of RXDESEL field.
	SCI9_SEMR_RXDESEL_Pos = 0x7
	// Bit mask of RXDESEL field.
	SCI9_SEMR_RXDESEL_Msk = 0x80
	// Bit RXDESEL.
	SCI9_SEMR_RXDESEL = 0x80
	// Detect low level on RXDn pin as start bit
	SCI9_SEMR_RXDESEL_0 = 0x0
	// Detect falling edge of RXDn pin as start bit
	SCI9_SEMR_RXDESEL_1 = 0x1

	// SNFR: Noise Filter Setting Register
	// Position of NFCS field.
	SCI9_SNFR_NFCS_Pos = 0x0
	// Bit mask of NFCS field.
	SCI9_SNFR_NFCS_Msk = 0x7
	// In asynchronous mode: Use clock signal divided by 1 with noise filter In simple I2C mode: Setting prohibited
	SCI9_SNFR_NFCS_000 = 0x0
	// In asynchronous mode: Setting prohibited In simple I2C mode: Use clock signal divided by 1 with noise filter
	SCI9_SNFR_NFCS_001 = 0x1
	// In asynchronous mode: Setting prohibited In simple I2C mode: Use clock signal divided by 2 with noise filter
	SCI9_SNFR_NFCS_010 = 0x2
	// In asynchronous mode: Setting prohibited In simple I2C mode: Use clock signal divided by 4 with noise filter
	SCI9_SNFR_NFCS_011 = 0x3
	// In asynchronous mode: Setting prohibited In simple I2C mode: Use clock signal divided by 8 with noise filter
	SCI9_SNFR_NFCS_100 = 0x4

	// SIMR1: IIC Mode Register 1
	// Position of IICM field.
	SCI9_SIMR1_IICM_Pos = 0x0
	// Bit mask of IICM field.
	SCI9_SIMR1_IICM_Msk = 0x1
	// Bit IICM.
	SCI9_SIMR1_IICM = 0x1
	// SCMR.SMIF = 0: Asynchronous mode (including multi-processor mode), clock synchronous mode, or simple SPI mode SCMR.SMIF = 1: Smart card interface mode
	SCI9_SIMR1_IICM_0 = 0x0
	// SCMR.SMIF = 0: Simple IIC mode SCMR.SMIF = 1: Setting prohibited
	SCI9_SIMR1_IICM_1 = 0x1
	// Position of IICDL field.
	SCI9_SIMR1_IICDL_Pos = 0x3
	// Bit mask of IICDL field.
	SCI9_SIMR1_IICDL_Msk = 0xf8
	// No output delay
	SCI9_SIMR1_IICDL_0x00 = 0x0

	// SIMR2: IIC Mode Register 2
	// Position of IICINTM field.
	SCI9_SIMR2_IICINTM_Pos = 0x0
	// Bit mask of IICINTM field.
	SCI9_SIMR2_IICINTM_Msk = 0x1
	// Bit IICINTM.
	SCI9_SIMR2_IICINTM = 0x1
	// Use ACK/NACK interrupts
	SCI9_SIMR2_IICINTM_0 = 0x0
	// Use reception and transmission interrupts
	SCI9_SIMR2_IICINTM_1 = 0x1
	// Position of IICCSC field.
	SCI9_SIMR2_IICCSC_Pos = 0x1
	// Bit mask of IICCSC field.
	SCI9_SIMR2_IICCSC_Msk = 0x2
	// Bit IICCSC.
	SCI9_SIMR2_IICCSC = 0x2
	// Do not synchronize with clock signal
	SCI9_SIMR2_IICCSC_0 = 0x0
	// Synchronize with clock signal
	SCI9_SIMR2_IICCSC_1 = 0x1
	// Position of IICACKT field.
	SCI9_SIMR2_IICACKT_Pos = 0x5
	// Bit mask of IICACKT field.
	SCI9_SIMR2_IICACKT_Msk = 0x20
	// Bit IICACKT.
	SCI9_SIMR2_IICACKT = 0x20
	// ACK transmission
	SCI9_SIMR2_IICACKT_0 = 0x0
	// NACK transmission and ACK/NACK reception
	SCI9_SIMR2_IICACKT_1 = 0x1

	// SIMR3: IIC Mode Register 3
	// Position of IICSTAREQ field.
	SCI9_SIMR3_IICSTAREQ_Pos = 0x0
	// Bit mask of IICSTAREQ field.
	SCI9_SIMR3_IICSTAREQ_Msk = 0x1
	// Bit IICSTAREQ.
	SCI9_SIMR3_IICSTAREQ = 0x1
	// Do not generate start condition
	SCI9_SIMR3_IICSTAREQ_0 = 0x0
	// Generate start condition
	SCI9_SIMR3_IICSTAREQ_1 = 0x1
	// Position of IICRSTAREQ field.
	SCI9_SIMR3_IICRSTAREQ_Pos = 0x1
	// Bit mask of IICRSTAREQ field.
	SCI9_SIMR3_IICRSTAREQ_Msk = 0x2
	// Bit IICRSTAREQ.
	SCI9_SIMR3_IICRSTAREQ = 0x2
	// Do not generate restart condition
	SCI9_SIMR3_IICRSTAREQ_0 = 0x0
	// Generate restart condition
	SCI9_SIMR3_IICRSTAREQ_1 = 0x1
	// Position of IICSTPREQ field.
	SCI9_SIMR3_IICSTPREQ_Pos = 0x2
	// Bit mask of IICSTPREQ field.
	SCI9_SIMR3_IICSTPREQ_Msk = 0x4
	// Bit IICSTPREQ.
	SCI9_SIMR3_IICSTPREQ = 0x4
	// Do not generate stop condition
	SCI9_SIMR3_IICSTPREQ_0 = 0x0
	// Generate stop condition
	SCI9_SIMR3_IICSTPREQ_1 = 0x1
	// Position of IICSTIF field.
	SCI9_SIMR3_IICSTIF_Pos = 0x3
	// Bit mask of IICSTIF field.
	SCI9_SIMR3_IICSTIF_Msk = 0x8
	// Bit IICSTIF.
	SCI9_SIMR3_IICSTIF = 0x8
	// No requests are being made for generating conditions, or a condition is being generated
	SCI9_SIMR3_IICSTIF_0 = 0x0
	// Generation of start, restart, or stop condition is complete. When 0 is written to IICSTIF, it is set to 0
	SCI9_SIMR3_IICSTIF_1 = 0x1
	// Position of IICSDAS field.
	SCI9_SIMR3_IICSDAS_Pos = 0x4
	// Bit mask of IICSDAS field.
	SCI9_SIMR3_IICSDAS_Msk = 0x30
	// Output serial data
	SCI9_SIMR3_IICSDAS_00 = 0x0
	// Generate start, restart, or stop condition
	SCI9_SIMR3_IICSDAS_01 = 0x1
	// Output low on SDAn pin
	SCI9_SIMR3_IICSDAS_10 = 0x2
	// Drive SDAn pin to high-impedance state
	SCI9_SIMR3_IICSDAS_11 = 0x3
	// Position of IICSCLS field.
	SCI9_SIMR3_IICSCLS_Pos = 0x6
	// Bit mask of IICSCLS field.
	SCI9_SIMR3_IICSCLS_Msk = 0xc0
	// Output serial clock
	SCI9_SIMR3_IICSCLS_00 = 0x0
	// Generate start, restart, or stop condition
	SCI9_SIMR3_IICSCLS_01 = 0x1
	// Output low on SCLn pin
	SCI9_SIMR3_IICSCLS_10 = 0x2
	// Drive SCLn pin to high-impedance state
	SCI9_SIMR3_IICSCLS_11 = 0x3

	// SISR: IIC Status Register
	// Position of IICACKR field.
	SCI9_SISR_IICACKR_Pos = 0x0
	// Bit mask of IICACKR field.
	SCI9_SISR_IICACKR_Msk = 0x1
	// Bit IICACKR.
	SCI9_SISR_IICACKR = 0x1
	// ACK received
	SCI9_SISR_IICACKR_0 = 0x0
	// NACK received
	SCI9_SISR_IICACKR_1 = 0x1

	// SPMR: SPI Mode Register
	// Position of SSE field.
	SCI9_SPMR_SSE_Pos = 0x0
	// Bit mask of SSE field.
	SCI9_SPMR_SSE_Msk = 0x1
	// Bit SSE.
	SCI9_SPMR_SSE = 0x1
	// Disable SSn pin function
	SCI9_SPMR_SSE_0 = 0x0
	// Enable SSn pin function
	SCI9_SPMR_SSE_1 = 0x1
	// Position of CTSE field.
	SCI9_SPMR_CTSE_Pos = 0x1
	// Bit mask of CTSE field.
	SCI9_SPMR_CTSE_Msk = 0x2
	// Bit CTSE.
	SCI9_SPMR_CTSE = 0x2
	// Disable CTS function (enable RTS output function)
	SCI9_SPMR_CTSE_0 = 0x0
	// Enable CTS function
	SCI9_SPMR_CTSE_1 = 0x1
	// Position of MSS field.
	SCI9_SPMR_MSS_Pos = 0x2
	// Bit mask of MSS field.
	SCI9_SPMR_MSS_Msk = 0x4
	// Bit MSS.
	SCI9_SPMR_MSS = 0x4
	// Transmit through TXDn pin and receive through RXDn pin (master mode)
	SCI9_SPMR_MSS_0 = 0x0
	// Receive through TXDn pin and transmit through RXDn pin (slave mode)
	SCI9_SPMR_MSS_1 = 0x1
	// Position of MFF field.
	SCI9_SPMR_MFF_Pos = 0x4
	// Bit mask of MFF field.
	SCI9_SPMR_MFF_Msk = 0x10
	// Bit MFF.
	SCI9_SPMR_MFF = 0x10
	// No mode fault error
	SCI9_SPMR_MFF_0 = 0x0
	// Mode fault error
	SCI9_SPMR_MFF_1 = 0x1
	// Position of CKPOL field.
	SCI9_SPMR_CKPOL_Pos = 0x6
	// Bit mask of CKPOL field.
	SCI9_SPMR_CKPOL_Msk = 0x40
	// Bit CKPOL.
	SCI9_SPMR_CKPOL = 0x40
	// Do not invert clock polarity
	SCI9_SPMR_CKPOL_0 = 0x0
	// Invert clock polarity
	SCI9_SPMR_CKPOL_1 = 0x1
	// Position of CKPH field.
	SCI9_SPMR_CKPH_Pos = 0x7
	// Bit mask of CKPH field.
	SCI9_SPMR_CKPH_Msk = 0x80
	// Bit CKPH.
	SCI9_SPMR_CKPH = 0x80
	// Do not delay clock
	SCI9_SPMR_CKPH_0 = 0x0
	// Delay clock
	SCI9_SPMR_CKPH_1 = 0x1

	// TDRHL: Transmit Data Register
	// Position of TDAT field.
	SCI9_TDRHL_TDAT_Pos = 0x0
	// Bit mask of TDAT field.
	SCI9_TDRHL_TDAT_Msk = 0x1ff

	// RDRHL: Receive Data Register
	// Position of RDAT field.
	SCI9_RDRHL_RDAT_Pos = 0x0
	// Bit mask of RDAT field.
	SCI9_RDRHL_RDAT_Msk = 0x1ff

	// DCCR: Data Compare Match Control Register
	// Position of DCMF field.
	SCI9_DCCR_DCMF_Pos = 0x0
	// Bit mask of DCMF field.
	SCI9_DCCR_DCMF_Msk = 0x1
	// Bit DCMF.
	SCI9_DCCR_DCMF = 0x1
	// Not matched
	SCI9_DCCR_DCMF_0 = 0x0
	// Matched
	SCI9_DCCR_DCMF_1 = 0x1
	// Position of DPER field.
	SCI9_DCCR_DPER_Pos = 0x3
	// Bit mask of DPER field.
	SCI9_DCCR_DPER_Msk = 0x8
	// Bit DPER.
	SCI9_DCCR_DPER = 0x8
	// No parity error occurred
	SCI9_DCCR_DPER_0 = 0x0
	// Parity error occurred
	SCI9_DCCR_DPER_1 = 0x1
	// Position of DFER field.
	SCI9_DCCR_DFER_Pos = 0x4
	// Bit mask of DFER field.
	SCI9_DCCR_DFER_Msk = 0x10
	// Bit DFER.
	SCI9_DCCR_DFER = 0x10
	// No framing error occurred
	SCI9_DCCR_DFER_0 = 0x0
	// Framing error occurred
	SCI9_DCCR_DFER_1 = 0x1
	// Position of IDSEL field.
	SCI9_DCCR_IDSEL_Pos = 0x6
	// Bit mask of IDSEL field.
	SCI9_DCCR_IDSEL_Msk = 0x40
	// Bit IDSEL.
	SCI9_DCCR_IDSEL = 0x40
	// Always compare data regardless of the MPB bit value
	SCI9_DCCR_IDSEL_0 = 0x0
	// Only compare data when MPB bit = 1 (ID frame)
	SCI9_DCCR_IDSEL_1 = 0x1
	// Position of DCME field.
	SCI9_DCCR_DCME_Pos = 0x7
	// Bit mask of DCME field.
	SCI9_DCCR_DCME_Msk = 0x80
	// Bit DCME.
	SCI9_DCCR_DCME = 0x80
	// Disable address match function
	SCI9_DCCR_DCME_0 = 0x0
	// Enable address match function
	SCI9_DCCR_DCME_1 = 0x1

	// CDR: Compare Match Data Register
	// Position of CMPD field.
	SCI9_CDR_CMPD_Pos = 0x0
	// Bit mask of CMPD field.
	SCI9_CDR_CMPD_Msk = 0x1ff

	// SPTR: Serial Port Register
	// Position of RXDMON field.
	SCI9_SPTR_RXDMON_Pos = 0x0
	// Bit mask of RXDMON field.
	SCI9_SPTR_RXDMON_Msk = 0x1
	// Bit RXDMON.
	SCI9_SPTR_RXDMON = 0x1
	// Position of SPB2DT field.
	SCI9_SPTR_SPB2DT_Pos = 0x1
	// Bit mask of SPB2DT field.
	SCI9_SPTR_SPB2DT_Msk = 0x2
	// Bit SPB2DT.
	SCI9_SPTR_SPB2DT = 0x2
	// Position of SPB2IO field.
	SCI9_SPTR_SPB2IO_Pos = 0x2
	// Bit mask of SPB2IO field.
	SCI9_SPTR_SPB2IO_Msk = 0x4
	// Bit SPB2IO.
	SCI9_SPTR_SPB2IO = 0x4
	// Do not output value of SPB2DT bit on TXDn pin
	SCI9_SPTR_SPB2IO_0 = 0x0
	// Output value of SPB2DT bit on TXDn pin
	SCI9_SPTR_SPB2IO_1 = 0x1
)

// Constants for SPI0: Serial Peripheral Interface
const (
	// SPCR: SPI Control Register
	// Position of SPMS field.
	SPI0_SPCR_SPMS_Pos = 0x0
	// Bit mask of SPMS field.
	SPI0_SPCR_SPMS_Msk = 0x1
	// Bit SPMS.
	SPI0_SPCR_SPMS = 0x1
	// Select SPI operation (4-wire method)
	SPI0_SPCR_SPMS_0 = 0x0
	// Select clock synchronous operation (3-wire method)
	SPI0_SPCR_SPMS_1 = 0x1
	// Position of TXMD field.
	SPI0_SPCR_TXMD_Pos = 0x1
	// Bit mask of TXMD field.
	SPI0_SPCR_TXMD_Msk = 0x2
	// Bit TXMD.
	SPI0_SPCR_TXMD = 0x2
	// Select full-duplex synchronous serial communications
	SPI0_SPCR_TXMD_0 = 0x0
	// Select serial communications with transmit-only
	SPI0_SPCR_TXMD_1 = 0x1
	// Position of MODFEN field.
	SPI0_SPCR_MODFEN_Pos = 0x2
	// Bit mask of MODFEN field.
	SPI0_SPCR_MODFEN_Msk = 0x4
	// Bit MODFEN.
	SPI0_SPCR_MODFEN = 0x4
	// Disable detection of mode fault errors
	SPI0_SPCR_MODFEN_0 = 0x0
	// Enable detection of mode fault errors
	SPI0_SPCR_MODFEN_1 = 0x1
	// Position of MSTR field.
	SPI0_SPCR_MSTR_Pos = 0x3
	// Bit mask of MSTR field.
	SPI0_SPCR_MSTR_Msk = 0x8
	// Bit MSTR.
	SPI0_SPCR_MSTR = 0x8
	// Select slave mode
	SPI0_SPCR_MSTR_0 = 0x0
	// Select master mode
	SPI0_SPCR_MSTR_1 = 0x1
	// Position of SPEIE field.
	SPI0_SPCR_SPEIE_Pos = 0x4
	// Bit mask of SPEIE field.
	SPI0_SPCR_SPEIE_Msk = 0x10
	// Bit SPEIE.
	SPI0_SPCR_SPEIE = 0x10
	// Disable SPI error interrupt requests
	SPI0_SPCR_SPEIE_0 = 0x0
	// Enable SPI error interrupt requests
	SPI0_SPCR_SPEIE_1 = 0x1
	// Position of SPTIE field.
	SPI0_SPCR_SPTIE_Pos = 0x5
	// Bit mask of SPTIE field.
	SPI0_SPCR_SPTIE_Msk = 0x20
	// Bit SPTIE.
	SPI0_SPCR_SPTIE = 0x20
	// Disable transmit buffer empty interrupt requests
	SPI0_SPCR_SPTIE_0 = 0x0
	// Enable transmit buffer empty interrupt requests
	SPI0_SPCR_SPTIE_1 = 0x1
	// Position of SPE field.
	SPI0_SPCR_SPE_Pos = 0x6
	// Bit mask of SPE field.
	SPI0_SPCR_SPE_Msk = 0x40
	// Bit SPE.
	SPI0_SPCR_SPE = 0x40
	// Disable SPI function
	SPI0_SPCR_SPE_0 = 0x0
	// Enable SPI function
	SPI0_SPCR_SPE_1 = 0x1
	// Position of SPRIE field.
	SPI0_SPCR_SPRIE_Pos = 0x7
	// Bit mask of SPRIE field.
	SPI0_SPCR_SPRIE_Msk = 0x80
	// Bit SPRIE.
	SPI0_SPCR_SPRIE = 0x80
	// Disable SPI receive buffer full interrupt requests
	SPI0_SPCR_SPRIE_0 = 0x0
	// Enable SPI receive buffer full interrupt requests
	SPI0_SPCR_SPRIE_1 = 0x1

	// SSLP: SPI Slave Select Polarity Register
	// Position of SSL0P field.
	SPI0_SSLP_SSL0P_Pos = 0x0
	// Bit mask of SSL0P field.
	SPI0_SSLP_SSL0P_Msk = 0x1
	// Bit SSL0P.
	SPI0_SSLP_SSL0P = 0x1
	// Set SSLn0 signal to active-low
	SPI0_SSLP_SSL0P_0 = 0x0
	// Set SSLn0 signal to active-high
	SPI0_SSLP_SSL0P_1 = 0x1

	// SPPCR: SPI Pin Control Register
	// Position of SPLP field.
	SPI0_SPPCR_SPLP_Pos = 0x0
	// Bit mask of SPLP field.
	SPI0_SPPCR_SPLP_Msk = 0x1
	// Bit SPLP.
	SPI0_SPPCR_SPLP = 0x1
	// Normal mode
	SPI0_SPPCR_SPLP_0 = 0x0
	// Loopback mode (receive data = inverted transmit data)
	SPI0_SPPCR_SPLP_1 = 0x1
	// Position of SPLP2 field.
	SPI0_SPPCR_SPLP2_Pos = 0x1
	// Bit mask of SPLP2 field.
	SPI0_SPPCR_SPLP2_Msk = 0x2
	// Bit SPLP2.
	SPI0_SPPCR_SPLP2 = 0x2
	// Normal mode
	SPI0_SPPCR_SPLP2_0 = 0x0
	// Loopback mode (receive data = transmit data)
	SPI0_SPPCR_SPLP2_1 = 0x1
	// Position of MOIFV field.
	SPI0_SPPCR_MOIFV_Pos = 0x4
	// Bit mask of MOIFV field.
	SPI0_SPPCR_MOIFV_Msk = 0x10
	// Bit MOIFV.
	SPI0_SPPCR_MOIFV = 0x10
	// Set level output on MOSIn pin during MOSI idling to low
	SPI0_SPPCR_MOIFV_0 = 0x0
	// Set level output on MOSIn pin during MOSI idling to high
	SPI0_SPPCR_MOIFV_1 = 0x1
	// Position of MOIFE field.
	SPI0_SPPCR_MOIFE_Pos = 0x5
	// Bit mask of MOIFE field.
	SPI0_SPPCR_MOIFE_Msk = 0x20
	// Bit MOIFE.
	SPI0_SPPCR_MOIFE = 0x20
	// Set MOSI output value to equal final data from previous transfer
	SPI0_SPPCR_MOIFE_0 = 0x0
	// Set MOSI output value to equal value set in the MOIFV bit
	SPI0_SPPCR_MOIFE_1 = 0x1

	// SPSR: SPI Status Register
	// Position of OVRF field.
	SPI0_SPSR_OVRF_Pos = 0x0
	// Bit mask of OVRF field.
	SPI0_SPSR_OVRF_Msk = 0x1
	// Bit OVRF.
	SPI0_SPSR_OVRF = 0x1
	// No overrun error occurred
	SPI0_SPSR_OVRF_0 = 0x0
	// Overrun error occurred
	SPI0_SPSR_OVRF_1 = 0x1
	// Position of IDLNF field.
	SPI0_SPSR_IDLNF_Pos = 0x1
	// Bit mask of IDLNF field.
	SPI0_SPSR_IDLNF_Msk = 0x2
	// Bit IDLNF.
	SPI0_SPSR_IDLNF = 0x2
	// SPI is in the idle state
	SPI0_SPSR_IDLNF_0 = 0x0
	// SPI is in the transfer state
	SPI0_SPSR_IDLNF_1 = 0x1
	// Position of MODF field.
	SPI0_SPSR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI0_SPSR_MODF_Msk = 0x4
	// Bit MODF.
	SPI0_SPSR_MODF = 0x4
	// No mode fault or underrun error occurred
	SPI0_SPSR_MODF_0 = 0x0
	// Mode fault error or underrun error occurred
	SPI0_SPSR_MODF_1 = 0x1
	// Position of PERF field.
	SPI0_SPSR_PERF_Pos = 0x3
	// Bit mask of PERF field.
	SPI0_SPSR_PERF_Msk = 0x8
	// Bit PERF.
	SPI0_SPSR_PERF = 0x8
	// No parity error occurred
	SPI0_SPSR_PERF_0 = 0x0
	// Parity error occurred
	SPI0_SPSR_PERF_1 = 0x1
	// Position of UDRF field.
	SPI0_SPSR_UDRF_Pos = 0x4
	// Bit mask of UDRF field.
	SPI0_SPSR_UDRF_Msk = 0x10
	// Bit UDRF.
	SPI0_SPSR_UDRF = 0x10
	// Mode fault error occurred (MODF = 1)
	SPI0_SPSR_UDRF_0 = 0x0
	// Underrun error occurred (MODF = 1)
	SPI0_SPSR_UDRF_1 = 0x1
	// Position of SPTEF field.
	SPI0_SPSR_SPTEF_Pos = 0x5
	// Bit mask of SPTEF field.
	SPI0_SPSR_SPTEF_Msk = 0x20
	// Bit SPTEF.
	SPI0_SPSR_SPTEF = 0x20
	// Data is in the transmit buffer
	SPI0_SPSR_SPTEF_0 = 0x0
	// No data is in the transmit buffer
	SPI0_SPSR_SPTEF_1 = 0x1
	// Position of SPRF field.
	SPI0_SPSR_SPRF_Pos = 0x7
	// Bit mask of SPRF field.
	SPI0_SPSR_SPRF_Msk = 0x80
	// Bit SPRF.
	SPI0_SPSR_SPRF = 0x80
	// No valid data is in SPDR/SPDR_HA
	SPI0_SPSR_SPRF_0 = 0x0
	// Valid data is in SPDR/SPDR_HA
	SPI0_SPSR_SPRF_1 = 0x1

	// SPDCR: SPI Data Control Register
	// Position of SPRDTD field.
	SPI0_SPDCR_SPRDTD_Pos = 0x4
	// Bit mask of SPRDTD field.
	SPI0_SPDCR_SPRDTD_Msk = 0x10
	// Bit SPRDTD.
	SPI0_SPDCR_SPRDTD = 0x10
	// Read SPDR/SPDR_HA values from receive buffer
	SPI0_SPDCR_SPRDTD_0 = 0x0
	// Read SPDR/SPDR_HA values from transmit buffer, but only if the transmit buffer is empty
	SPI0_SPDCR_SPRDTD_1 = 0x1
	// Position of SPLW field.
	SPI0_SPDCR_SPLW_Pos = 0x5
	// Bit mask of SPLW field.
	SPI0_SPDCR_SPLW_Msk = 0x20
	// Bit SPLW.
	SPI0_SPDCR_SPLW = 0x20
	// Set SPDR_HA to valid for halfword access
	SPI0_SPDCR_SPLW_0 = 0x0
	// Set SPDR to valid for word access
	SPI0_SPDCR_SPLW_1 = 0x1
	// Position of SPBYT field.
	SPI0_SPDCR_SPBYT_Pos = 0x6
	// Bit mask of SPBYT field.
	SPI0_SPDCR_SPBYT_Msk = 0x40
	// Bit SPBYT.
	SPI0_SPDCR_SPBYT = 0x40
	// SPDR/SPDR_HA is accessed in halfword or word (SPLW is valid)
	SPI0_SPDCR_SPBYT_0 = 0x0
	// SPDR_BY is accessed in byte (SPLW is invalid)
	SPI0_SPDCR_SPBYT_1 = 0x1

	// SPCKD: SPI Clock Delay Register
	// Position of SCKDL field.
	SPI0_SPCKD_SCKDL_Pos = 0x0
	// Bit mask of SCKDL field.
	SPI0_SPCKD_SCKDL_Msk = 0x7
	// 1 RSPCK
	SPI0_SPCKD_SCKDL_000 = 0x0
	// 2 RSPCK
	SPI0_SPCKD_SCKDL_001 = 0x1
	// 3 RSPCK
	SPI0_SPCKD_SCKDL_010 = 0x2
	// 4 RSPCK
	SPI0_SPCKD_SCKDL_011 = 0x3
	// 5 RSPCK
	SPI0_SPCKD_SCKDL_100 = 0x4
	// 6 RSPCK
	SPI0_SPCKD_SCKDL_101 = 0x5
	// 7 RSPCK
	SPI0_SPCKD_SCKDL_110 = 0x6
	// 8 RSPCK
	SPI0_SPCKD_SCKDL_111 = 0x7

	// SSLND: SPI Slave Select Negation Delay Register
	// Position of SLNDL field.
	SPI0_SSLND_SLNDL_Pos = 0x0
	// Bit mask of SLNDL field.
	SPI0_SSLND_SLNDL_Msk = 0x7
	// 1 RSPCK
	SPI0_SSLND_SLNDL_000 = 0x0
	// 2 RSPCK
	SPI0_SSLND_SLNDL_001 = 0x1
	// 3 RSPCK
	SPI0_SSLND_SLNDL_010 = 0x2
	// 4 RSPCK
	SPI0_SSLND_SLNDL_011 = 0x3
	// 5 RSPCK
	SPI0_SSLND_SLNDL_100 = 0x4
	// 6 RSPCK
	SPI0_SSLND_SLNDL_101 = 0x5
	// 7 RSPCK
	SPI0_SSLND_SLNDL_110 = 0x6
	// 8 RSPCK
	SPI0_SSLND_SLNDL_111 = 0x7

	// SPND: SPI Next-Access Delay Register
	// Position of SPNDL field.
	SPI0_SPND_SPNDL_Pos = 0x0
	// Bit mask of SPNDL field.
	SPI0_SPND_SPNDL_Msk = 0x7
	// 1 RSPCK + 2 PCLKB
	SPI0_SPND_SPNDL_000 = 0x0
	// 2 RSPCK + 2 PCLKB
	SPI0_SPND_SPNDL_001 = 0x1
	// 3 RSPCK + 2 PCLKB
	SPI0_SPND_SPNDL_010 = 0x2
	// 4 RSPCK + 2 PCLKB
	SPI0_SPND_SPNDL_011 = 0x3
	// 5 RSPCK + 2 PCLKB
	SPI0_SPND_SPNDL_100 = 0x4
	// 6 RSPCK + 2 PCLKB
	SPI0_SPND_SPNDL_101 = 0x5
	// 7 RSPCK + 2 PCLKB
	SPI0_SPND_SPNDL_110 = 0x6
	// 8 RSPCK + 2 PCLKB
	SPI0_SPND_SPNDL_111 = 0x7

	// SPCR2: SPI Control Register 2
	// Position of SPPE field.
	SPI0_SPCR2_SPPE_Pos = 0x0
	// Bit mask of SPPE field.
	SPI0_SPCR2_SPPE_Msk = 0x1
	// Bit SPPE.
	SPI0_SPCR2_SPPE = 0x1
	// Do not add parity bit to transmit data and do not check parity bit of receive data
	SPI0_SPCR2_SPPE_0 = 0x0
	// When SPCR.TXMD = 0: Add parity bit to transmit data and check parity bit of receive data When SPCR.TXMD = 1: Add parity bit to transmit data but do not check parity bit of receive data
	SPI0_SPCR2_SPPE_1 = 0x1
	// Position of SPOE field.
	SPI0_SPCR2_SPOE_Pos = 0x1
	// Bit mask of SPOE field.
	SPI0_SPCR2_SPOE_Msk = 0x2
	// Bit SPOE.
	SPI0_SPCR2_SPOE = 0x2
	// Select even parity for transmission and reception
	SPI0_SPCR2_SPOE_0 = 0x0
	// Select odd parity for transmission and reception
	SPI0_SPCR2_SPOE_1 = 0x1
	// Position of SPIIE field.
	SPI0_SPCR2_SPIIE_Pos = 0x2
	// Bit mask of SPIIE field.
	SPI0_SPCR2_SPIIE_Msk = 0x4
	// Bit SPIIE.
	SPI0_SPCR2_SPIIE = 0x4
	// Disable idle interrupt requests
	SPI0_SPCR2_SPIIE_0 = 0x0
	// Enable idle interrupt requests
	SPI0_SPCR2_SPIIE_1 = 0x1
	// Position of PTE field.
	SPI0_SPCR2_PTE_Pos = 0x3
	// Bit mask of PTE field.
	SPI0_SPCR2_PTE_Msk = 0x8
	// Bit PTE.
	SPI0_SPCR2_PTE = 0x8
	// Disable self-diagnosis function of the parity circuit
	SPI0_SPCR2_PTE_0 = 0x0
	// Enable self-diagnosis function of the parity circuit
	SPI0_SPCR2_PTE_1 = 0x1
	// Position of SCKASE field.
	SPI0_SPCR2_SCKASE_Pos = 0x4
	// Bit mask of SCKASE field.
	SPI0_SPCR2_SCKASE_Msk = 0x10
	// Bit SCKASE.
	SPI0_SPCR2_SCKASE = 0x10
	// Disable RSPCK auto-stop function
	SPI0_SPCR2_SCKASE_0 = 0x0
	// Enable RSPCK auto-stop function
	SPI0_SPCR2_SCKASE_1 = 0x1

	// SPCMD0: SPI Command Register 0
	// Position of CPHA field.
	SPI0_SPCMD0_CPHA_Pos = 0x0
	// Bit mask of CPHA field.
	SPI0_SPCMD0_CPHA_Msk = 0x1
	// Bit CPHA.
	SPI0_SPCMD0_CPHA = 0x1
	// Select data sampling on leading edge, data change on trailing edge
	SPI0_SPCMD0_CPHA_0 = 0x0
	// Select data change on leading edge, data sampling on trailing edge
	SPI0_SPCMD0_CPHA_1 = 0x1
	// Position of CPOL field.
	SPI0_SPCMD0_CPOL_Pos = 0x1
	// Bit mask of CPOL field.
	SPI0_SPCMD0_CPOL_Msk = 0x2
	// Bit CPOL.
	SPI0_SPCMD0_CPOL = 0x2
	// Set RSPCK low during idle
	SPI0_SPCMD0_CPOL_0 = 0x0
	// Set RSPCK high during idle
	SPI0_SPCMD0_CPOL_1 = 0x1
	// Position of BRDV field.
	SPI0_SPCMD0_BRDV_Pos = 0x2
	// Bit mask of BRDV field.
	SPI0_SPCMD0_BRDV_Msk = 0xc
	// Base bit rate
	SPI0_SPCMD0_BRDV_00 = 0x0
	// Base bit rate divided by 2
	SPI0_SPCMD0_BRDV_01 = 0x1
	// Base bit rate divided by 4
	SPI0_SPCMD0_BRDV_10 = 0x2
	// Base bit rate divided by 8
	SPI0_SPCMD0_BRDV_11 = 0x3
	// Position of SPB field.
	SPI0_SPCMD0_SPB_Pos = 0x8
	// Bit mask of SPB field.
	SPI0_SPCMD0_SPB_Msk = 0xf00
	// 20 bits
	SPI0_SPCMD0_SPB_0x0 = 0x0
	// 24 bits
	SPI0_SPCMD0_SPB_0x1 = 0x1
	// 32 bits
	SPI0_SPCMD0_SPB_0x2 = 0x2
	// 32 bits
	SPI0_SPCMD0_SPB_0x3 = 0x3
	// 9 bits
	SPI0_SPCMD0_SPB_0x8 = 0x8
	// 10 bits
	SPI0_SPCMD0_SPB_0x9 = 0x9
	// 11 bits
	SPI0_SPCMD0_SPB_0xA = 0xa
	// 12 bits
	SPI0_SPCMD0_SPB_0xB = 0xb
	// 13 bits
	SPI0_SPCMD0_SPB_0xC = 0xc
	// 14 bits
	SPI0_SPCMD0_SPB_0xD = 0xd
	// 15 bits
	SPI0_SPCMD0_SPB_0xE = 0xe
	// 16 bits
	SPI0_SPCMD0_SPB_0xF = 0xf
	// Position of LSBF field.
	SPI0_SPCMD0_LSBF_Pos = 0xc
	// Bit mask of LSBF field.
	SPI0_SPCMD0_LSBF_Msk = 0x1000
	// Bit LSBF.
	SPI0_SPCMD0_LSBF = 0x1000
	// MSB-first
	SPI0_SPCMD0_LSBF_0 = 0x0
	// LSB-first
	SPI0_SPCMD0_LSBF_1 = 0x1
	// Position of SPNDEN field.
	SPI0_SPCMD0_SPNDEN_Pos = 0xd
	// Bit mask of SPNDEN field.
	SPI0_SPCMD0_SPNDEN_Msk = 0x2000
	// Bit SPNDEN.
	SPI0_SPCMD0_SPNDEN = 0x2000
	// Select next-access delay of 1 RSPCK + 2 PCLKB
	SPI0_SPCMD0_SPNDEN_0 = 0x0
	// Select next-access delay equal to the setting in the SPI Next-Access Delay Register (SPND)
	SPI0_SPCMD0_SPNDEN_1 = 0x1
	// Position of SLNDEN field.
	SPI0_SPCMD0_SLNDEN_Pos = 0xe
	// Bit mask of SLNDEN field.
	SPI0_SPCMD0_SLNDEN_Msk = 0x4000
	// Bit SLNDEN.
	SPI0_SPCMD0_SLNDEN = 0x4000
	// Select SSL negation delay of 1 RSPCK
	SPI0_SPCMD0_SLNDEN_0 = 0x0
	// Select SSL negation delay equal to the setting in the SPI Slave Select Negation Delay Register (SSLND)
	SPI0_SPCMD0_SLNDEN_1 = 0x1
	// Position of SCKDEN field.
	SPI0_SPCMD0_SCKDEN_Pos = 0xf
	// Bit mask of SCKDEN field.
	SPI0_SPCMD0_SCKDEN_Msk = 0x8000
	// Bit SCKDEN.
	SPI0_SPCMD0_SCKDEN = 0x8000
	// Select RSPCK delay of 1 RSPCK
	SPI0_SPCMD0_SCKDEN_0 = 0x0
	// Select RSPCK delay equal to the setting in the SPI Clock Delay Register (SPCKD)
	SPI0_SPCMD0_SCKDEN_1 = 0x1
)

// Constants for CRC: Cyclic Redundancy Check Calculator
const (
	// CRCCR0: CRC Control Register 0
	// Position of GPS field.
	CRC_CRCCR0_GPS_Pos = 0x0
	// Bit mask of GPS field.
	CRC_CRCCR0_GPS_Msk = 0x7
	// 8-bit CRC-8 (X8 + X2 + X + 1)
	CRC_CRCCR0_GPS_001 = 0x1
	// 16-bit CRC-16 (X16 + X15 + X2 + 1)
	CRC_CRCCR0_GPS_010 = 0x2
	// 16-bit CRC-CCITT (X16 + X12 + X5 + 1)
	CRC_CRCCR0_GPS_011 = 0x3
	// 32-bit CRC-32 (X32 + X26 + X23 + X22 + X16 + X12 + X11 +X10 + X8 + X7 + X5 + X4 + X2 + X + 1)
	CRC_CRCCR0_GPS_100 = 0x4
	// 32-bit CRC-32C (X32 + X28 + X27 + X26 + X25 + X23 + X22 + X20 + X19 + X18 + X14 + X13 + X11 + X10 + X9 + X8 + X6 + 1)
	CRC_CRCCR0_GPS_101 = 0x5
	// Position of LMS field.
	CRC_CRCCR0_LMS_Pos = 0x6
	// Bit mask of LMS field.
	CRC_CRCCR0_LMS_Msk = 0x40
	// Bit LMS.
	CRC_CRCCR0_LMS = 0x40
	// Generate CRC code for LSB-first communication
	CRC_CRCCR0_LMS_0 = 0x0
	// Generate CRC code for MSB-first communication
	CRC_CRCCR0_LMS_1 = 0x1
	// Position of DORCLR field.
	CRC_CRCCR0_DORCLR_Pos = 0x7
	// Bit mask of DORCLR field.
	CRC_CRCCR0_DORCLR_Msk = 0x80
	// Bit DORCLR.
	CRC_CRCCR0_DORCLR = 0x80
	// No effect
	CRC_CRCCR0_DORCLR_0 = 0x0
	// Clear the CRCDOR/CRCDOR_HA/CRCDOR_BY register
	CRC_CRCCR0_DORCLR_1 = 0x1

	// CRCCR1: CRC Control Register 1
	// Position of CRCSWR field.
	CRC_CRCCR1_CRCSWR_Pos = 0x6
	// Bit mask of CRCSWR field.
	CRC_CRCCR1_CRCSWR_Msk = 0x40
	// Bit CRCSWR.
	CRC_CRCCR1_CRCSWR = 0x40
	// Snoop-on-read
	CRC_CRCCR1_CRCSWR_0 = 0x0
	// Snoop-on-write
	CRC_CRCCR1_CRCSWR_1 = 0x1
	// Position of CRCSEN field.
	CRC_CRCCR1_CRCSEN_Pos = 0x7
	// Bit mask of CRCSEN field.
	CRC_CRCCR1_CRCSEN_Msk = 0x80
	// Bit CRCSEN.
	CRC_CRCCR1_CRCSEN = 0x80
	// Disabled
	CRC_CRCCR1_CRCSEN_0 = 0x0
	// Enabled
	CRC_CRCCR1_CRCSEN_1 = 0x1

	// CRCSAR: Snoop Address Register
	// Position of CRCSA field.
	CRC_CRCSAR_CRCSA_Pos = 0x0
	// Bit mask of CRCSA field.
	CRC_CRCSAR_CRCSA_Msk = 0x3fff
)

// Constants for GPT164: General PWM 16-bit Timer 4
const (
	// GTWP: General PWM Timer Write-Protection Register
	// Position of WP field.
	GPT164_GTWP_WP_Pos = 0x0
	// Bit mask of WP field.
	GPT164_GTWP_WP_Msk = 0x1
	// Bit WP.
	GPT164_GTWP_WP = 0x1
	// Write to the register enabled
	GPT164_GTWP_WP_0 = 0x0
	// Write to the register disabled
	GPT164_GTWP_WP_1 = 0x1
	// Position of PRKEY field.
	GPT164_GTWP_PRKEY_Pos = 0x8
	// Bit mask of PRKEY field.
	GPT164_GTWP_PRKEY_Msk = 0xff00

	// GTSTR: General PWM Timer Software Start Register
	// Position of CSTRT0 field.
	GPT164_GTSTR_CSTRT0_Pos = 0x0
	// Bit mask of CSTRT0 field.
	GPT164_GTSTR_CSTRT0_Msk = 0x1
	// Bit CSTRT0.
	GPT164_GTSTR_CSTRT0 = 0x1
	// GTCNT counter not start
	GPT164_GTSTR_CSTRT0_0 = 0x0
	// GTCNT counter start
	GPT164_GTSTR_CSTRT0_1 = 0x1
	// Position of CSTRT1 field.
	GPT164_GTSTR_CSTRT1_Pos = 0x1
	// Bit mask of CSTRT1 field.
	GPT164_GTSTR_CSTRT1_Msk = 0x2
	// Bit CSTRT1.
	GPT164_GTSTR_CSTRT1 = 0x2
	// GTCNT counter not start
	GPT164_GTSTR_CSTRT1_0 = 0x0
	// GTCNT counter start
	GPT164_GTSTR_CSTRT1_1 = 0x1
	// Position of CSTRT2 field.
	GPT164_GTSTR_CSTRT2_Pos = 0x2
	// Bit mask of CSTRT2 field.
	GPT164_GTSTR_CSTRT2_Msk = 0x4
	// Bit CSTRT2.
	GPT164_GTSTR_CSTRT2 = 0x4
	// GTCNT counter not start
	GPT164_GTSTR_CSTRT2_0 = 0x0
	// GTCNT counter start
	GPT164_GTSTR_CSTRT2_1 = 0x1
	// Position of CSTRT3 field.
	GPT164_GTSTR_CSTRT3_Pos = 0x3
	// Bit mask of CSTRT3 field.
	GPT164_GTSTR_CSTRT3_Msk = 0x8
	// Bit CSTRT3.
	GPT164_GTSTR_CSTRT3 = 0x8
	// GTCNT counter not start
	GPT164_GTSTR_CSTRT3_0 = 0x0
	// GTCNT counter start
	GPT164_GTSTR_CSTRT3_1 = 0x1
	// Position of CSTRT4 field.
	GPT164_GTSTR_CSTRT4_Pos = 0x4
	// Bit mask of CSTRT4 field.
	GPT164_GTSTR_CSTRT4_Msk = 0x10
	// Bit CSTRT4.
	GPT164_GTSTR_CSTRT4 = 0x10
	// GTCNT counter not start
	GPT164_GTSTR_CSTRT4_0 = 0x0
	// GTCNT counter start
	GPT164_GTSTR_CSTRT4_1 = 0x1
	// Position of CSTRT5 field.
	GPT164_GTSTR_CSTRT5_Pos = 0x5
	// Bit mask of CSTRT5 field.
	GPT164_GTSTR_CSTRT5_Msk = 0x20
	// Bit CSTRT5.
	GPT164_GTSTR_CSTRT5 = 0x20
	// GTCNT counter not start
	GPT164_GTSTR_CSTRT5_0 = 0x0
	// GTCNT counter start
	GPT164_GTSTR_CSTRT5_1 = 0x1
	// Position of CSTRT6 field.
	GPT164_GTSTR_CSTRT6_Pos = 0x6
	// Bit mask of CSTRT6 field.
	GPT164_GTSTR_CSTRT6_Msk = 0x40
	// Bit CSTRT6.
	GPT164_GTSTR_CSTRT6 = 0x40
	// GTCNT counter not start
	GPT164_GTSTR_CSTRT6_0 = 0x0
	// GTCNT counter start
	GPT164_GTSTR_CSTRT6_1 = 0x1
	// Position of CSTRT7 field.
	GPT164_GTSTR_CSTRT7_Pos = 0x7
	// Bit mask of CSTRT7 field.
	GPT164_GTSTR_CSTRT7_Msk = 0x80
	// Bit CSTRT7.
	GPT164_GTSTR_CSTRT7 = 0x80
	// GTCNT counter not start
	GPT164_GTSTR_CSTRT7_0 = 0x0
	// GTCNT counter start
	GPT164_GTSTR_CSTRT7_1 = 0x1
	// Position of CSTRT8 field.
	GPT164_GTSTR_CSTRT8_Pos = 0x8
	// Bit mask of CSTRT8 field.
	GPT164_GTSTR_CSTRT8_Msk = 0x100
	// Bit CSTRT8.
	GPT164_GTSTR_CSTRT8 = 0x100
	// GTCNT counter not start
	GPT164_GTSTR_CSTRT8_0 = 0x0
	// GTCNT counter start
	GPT164_GTSTR_CSTRT8_1 = 0x1
	// Position of CSTRT9 field.
	GPT164_GTSTR_CSTRT9_Pos = 0x9
	// Bit mask of CSTRT9 field.
	GPT164_GTSTR_CSTRT9_Msk = 0x200
	// Bit CSTRT9.
	GPT164_GTSTR_CSTRT9 = 0x200
	// GTCNT counter not start
	GPT164_GTSTR_CSTRT9_0 = 0x0
	// GTCNT counter start
	GPT164_GTSTR_CSTRT9_1 = 0x1

	// GTSTP: General PWM Timer Software Stop Register
	// Position of CSTOP0 field.
	GPT164_GTSTP_CSTOP0_Pos = 0x0
	// Bit mask of CSTOP0 field.
	GPT164_GTSTP_CSTOP0_Msk = 0x1
	// Bit CSTOP0.
	GPT164_GTSTP_CSTOP0 = 0x1
	// GTCNT counter not stop
	GPT164_GTSTP_CSTOP0_0 = 0x0
	// GTCNT counter stop
	GPT164_GTSTP_CSTOP0_1 = 0x1
	// Position of CSTOP1 field.
	GPT164_GTSTP_CSTOP1_Pos = 0x1
	// Bit mask of CSTOP1 field.
	GPT164_GTSTP_CSTOP1_Msk = 0x2
	// Bit CSTOP1.
	GPT164_GTSTP_CSTOP1 = 0x2
	// GTCNT counter not stop
	GPT164_GTSTP_CSTOP1_0 = 0x0
	// GTCNT counter stop
	GPT164_GTSTP_CSTOP1_1 = 0x1
	// Position of CSTOP2 field.
	GPT164_GTSTP_CSTOP2_Pos = 0x2
	// Bit mask of CSTOP2 field.
	GPT164_GTSTP_CSTOP2_Msk = 0x4
	// Bit CSTOP2.
	GPT164_GTSTP_CSTOP2 = 0x4
	// GTCNT counter not stop
	GPT164_GTSTP_CSTOP2_0 = 0x0
	// GTCNT counter stop
	GPT164_GTSTP_CSTOP2_1 = 0x1
	// Position of CSTOP3 field.
	GPT164_GTSTP_CSTOP3_Pos = 0x3
	// Bit mask of CSTOP3 field.
	GPT164_GTSTP_CSTOP3_Msk = 0x8
	// Bit CSTOP3.
	GPT164_GTSTP_CSTOP3 = 0x8
	// GTCNT counter not stop
	GPT164_GTSTP_CSTOP3_0 = 0x0
	// GTCNT counter stop
	GPT164_GTSTP_CSTOP3_1 = 0x1
	// Position of CSTOP4 field.
	GPT164_GTSTP_CSTOP4_Pos = 0x4
	// Bit mask of CSTOP4 field.
	GPT164_GTSTP_CSTOP4_Msk = 0x10
	// Bit CSTOP4.
	GPT164_GTSTP_CSTOP4 = 0x10
	// GTCNT counter not stop
	GPT164_GTSTP_CSTOP4_0 = 0x0
	// GTCNT counter stop
	GPT164_GTSTP_CSTOP4_1 = 0x1
	// Position of CSTOP5 field.
	GPT164_GTSTP_CSTOP5_Pos = 0x5
	// Bit mask of CSTOP5 field.
	GPT164_GTSTP_CSTOP5_Msk = 0x20
	// Bit CSTOP5.
	GPT164_GTSTP_CSTOP5 = 0x20
	// GTCNT counter not stop
	GPT164_GTSTP_CSTOP5_0 = 0x0
	// GTCNT counter stop
	GPT164_GTSTP_CSTOP5_1 = 0x1
	// Position of CSTOP6 field.
	GPT164_GTSTP_CSTOP6_Pos = 0x6
	// Bit mask of CSTOP6 field.
	GPT164_GTSTP_CSTOP6_Msk = 0x40
	// Bit CSTOP6.
	GPT164_GTSTP_CSTOP6 = 0x40
	// GTCNT counter not stop
	GPT164_GTSTP_CSTOP6_0 = 0x0
	// GTCNT counter stop
	GPT164_GTSTP_CSTOP6_1 = 0x1
	// Position of CSTOP7 field.
	GPT164_GTSTP_CSTOP7_Pos = 0x7
	// Bit mask of CSTOP7 field.
	GPT164_GTSTP_CSTOP7_Msk = 0x80
	// Bit CSTOP7.
	GPT164_GTSTP_CSTOP7 = 0x80
	// GTCNT counter not stop
	GPT164_GTSTP_CSTOP7_0 = 0x0
	// GTCNT counter stop
	GPT164_GTSTP_CSTOP7_1 = 0x1
	// Position of CSTOP8 field.
	GPT164_GTSTP_CSTOP8_Pos = 0x8
	// Bit mask of CSTOP8 field.
	GPT164_GTSTP_CSTOP8_Msk = 0x100
	// Bit CSTOP8.
	GPT164_GTSTP_CSTOP8 = 0x100
	// GTCNT counter not stop
	GPT164_GTSTP_CSTOP8_0 = 0x0
	// GTCNT counter stop
	GPT164_GTSTP_CSTOP8_1 = 0x1
	// Position of CSTOP9 field.
	GPT164_GTSTP_CSTOP9_Pos = 0x9
	// Bit mask of CSTOP9 field.
	GPT164_GTSTP_CSTOP9_Msk = 0x200
	// Bit CSTOP9.
	GPT164_GTSTP_CSTOP9 = 0x200
	// GTCNT counter not stop
	GPT164_GTSTP_CSTOP9_0 = 0x0
	// GTCNT counter stop
	GPT164_GTSTP_CSTOP9_1 = 0x1

	// GTCLR: General PWM Timer Software Clear Register
	// Position of CCLR0 field.
	GPT164_GTCLR_CCLR0_Pos = 0x0
	// Bit mask of CCLR0 field.
	GPT164_GTCLR_CCLR0_Msk = 0x1
	// Bit CCLR0.
	GPT164_GTCLR_CCLR0 = 0x1
	// GTCNT counter is not cleared
	GPT164_GTCLR_CCLR0_0 = 0x0
	// GTCNT counter is cleared
	GPT164_GTCLR_CCLR0_1 = 0x1
	// Position of CCLR1 field.
	GPT164_GTCLR_CCLR1_Pos = 0x1
	// Bit mask of CCLR1 field.
	GPT164_GTCLR_CCLR1_Msk = 0x2
	// Bit CCLR1.
	GPT164_GTCLR_CCLR1 = 0x2
	// GTCNT counter is not cleared
	GPT164_GTCLR_CCLR1_0 = 0x0
	// GTCNT counter is cleared
	GPT164_GTCLR_CCLR1_1 = 0x1
	// Position of CCLR2 field.
	GPT164_GTCLR_CCLR2_Pos = 0x2
	// Bit mask of CCLR2 field.
	GPT164_GTCLR_CCLR2_Msk = 0x4
	// Bit CCLR2.
	GPT164_GTCLR_CCLR2 = 0x4
	// GTCNT counter is not cleared
	GPT164_GTCLR_CCLR2_0 = 0x0
	// GTCNT counter is cleared
	GPT164_GTCLR_CCLR2_1 = 0x1
	// Position of CCLR3 field.
	GPT164_GTCLR_CCLR3_Pos = 0x3
	// Bit mask of CCLR3 field.
	GPT164_GTCLR_CCLR3_Msk = 0x8
	// Bit CCLR3.
	GPT164_GTCLR_CCLR3 = 0x8
	// GTCNT counter is not cleared
	GPT164_GTCLR_CCLR3_0 = 0x0
	// GTCNT counter is cleared
	GPT164_GTCLR_CCLR3_1 = 0x1
	// Position of CCLR4 field.
	GPT164_GTCLR_CCLR4_Pos = 0x4
	// Bit mask of CCLR4 field.
	GPT164_GTCLR_CCLR4_Msk = 0x10
	// Bit CCLR4.
	GPT164_GTCLR_CCLR4 = 0x10
	// GTCNT counter is not cleared
	GPT164_GTCLR_CCLR4_0 = 0x0
	// GTCNT counter is cleared
	GPT164_GTCLR_CCLR4_1 = 0x1
	// Position of CCLR5 field.
	GPT164_GTCLR_CCLR5_Pos = 0x5
	// Bit mask of CCLR5 field.
	GPT164_GTCLR_CCLR5_Msk = 0x20
	// Bit CCLR5.
	GPT164_GTCLR_CCLR5 = 0x20
	// GTCNT counter is not cleared
	GPT164_GTCLR_CCLR5_0 = 0x0
	// GTCNT counter is cleared
	GPT164_GTCLR_CCLR5_1 = 0x1
	// Position of CCLR6 field.
	GPT164_GTCLR_CCLR6_Pos = 0x6
	// Bit mask of CCLR6 field.
	GPT164_GTCLR_CCLR6_Msk = 0x40
	// Bit CCLR6.
	GPT164_GTCLR_CCLR6 = 0x40
	// GTCNT counter is not cleared
	GPT164_GTCLR_CCLR6_0 = 0x0
	// GTCNT counter is cleared
	GPT164_GTCLR_CCLR6_1 = 0x1
	// Position of CCLR7 field.
	GPT164_GTCLR_CCLR7_Pos = 0x7
	// Bit mask of CCLR7 field.
	GPT164_GTCLR_CCLR7_Msk = 0x80
	// Bit CCLR7.
	GPT164_GTCLR_CCLR7 = 0x80
	// GTCNT counter is not cleared
	GPT164_GTCLR_CCLR7_0 = 0x0
	// GTCNT counter is cleared
	GPT164_GTCLR_CCLR7_1 = 0x1
	// Position of CCLR8 field.
	GPT164_GTCLR_CCLR8_Pos = 0x8
	// Bit mask of CCLR8 field.
	GPT164_GTCLR_CCLR8_Msk = 0x100
	// Bit CCLR8.
	GPT164_GTCLR_CCLR8 = 0x100
	// GTCNT counter is not cleared
	GPT164_GTCLR_CCLR8_0 = 0x0
	// GTCNT counter is cleared
	GPT164_GTCLR_CCLR8_1 = 0x1
	// Position of CCLR9 field.
	GPT164_GTCLR_CCLR9_Pos = 0x9
	// Bit mask of CCLR9 field.
	GPT164_GTCLR_CCLR9_Msk = 0x200
	// Bit CCLR9.
	GPT164_GTCLR_CCLR9 = 0x200
	// GTCNT counter is not cleared
	GPT164_GTCLR_CCLR9_0 = 0x0
	// GTCNT counter is cleared
	GPT164_GTCLR_CCLR9_1 = 0x1

	// GTSSR: General PWM Timer Start Source Select Register
	// Position of SSGTRGAR field.
	GPT164_GTSSR_SSGTRGAR_Pos = 0x0
	// Bit mask of SSGTRGAR field.
	GPT164_GTSSR_SSGTRGAR_Msk = 0x1
	// Bit SSGTRGAR.
	GPT164_GTSSR_SSGTRGAR = 0x1
	// Counter start disabled on the rising edge of GTETRGA input
	GPT164_GTSSR_SSGTRGAR_0 = 0x0
	// Counter start enabled on the rising edge of GTETRGA input
	GPT164_GTSSR_SSGTRGAR_1 = 0x1
	// Position of SSGTRGAF field.
	GPT164_GTSSR_SSGTRGAF_Pos = 0x1
	// Bit mask of SSGTRGAF field.
	GPT164_GTSSR_SSGTRGAF_Msk = 0x2
	// Bit SSGTRGAF.
	GPT164_GTSSR_SSGTRGAF = 0x2
	// Counter start disabled on the falling edge of GTETRGA input
	GPT164_GTSSR_SSGTRGAF_0 = 0x0
	// Counter start enabled on the falling edge of GTETRGA input
	GPT164_GTSSR_SSGTRGAF_1 = 0x1
	// Position of SSGTRGBR field.
	GPT164_GTSSR_SSGTRGBR_Pos = 0x2
	// Bit mask of SSGTRGBR field.
	GPT164_GTSSR_SSGTRGBR_Msk = 0x4
	// Bit SSGTRGBR.
	GPT164_GTSSR_SSGTRGBR = 0x4
	// Counter start disabled on the rising edge of GTETRGB input
	GPT164_GTSSR_SSGTRGBR_0 = 0x0
	// Counter start enabled on the rising edge of GTETRGB input
	GPT164_GTSSR_SSGTRGBR_1 = 0x1
	// Position of SSGTRGBF field.
	GPT164_GTSSR_SSGTRGBF_Pos = 0x3
	// Bit mask of SSGTRGBF field.
	GPT164_GTSSR_SSGTRGBF_Msk = 0x8
	// Bit SSGTRGBF.
	GPT164_GTSSR_SSGTRGBF = 0x8
	// Counter start disabled on the falling edge of GTETRGB input
	GPT164_GTSSR_SSGTRGBF_0 = 0x0
	// Counter start enabled on the falling edge of GTETRGB input
	GPT164_GTSSR_SSGTRGBF_1 = 0x1
	// Position of SSCARBL field.
	GPT164_GTSSR_SSCARBL_Pos = 0x8
	// Bit mask of SSCARBL field.
	GPT164_GTSSR_SSCARBL_Msk = 0x100
	// Bit SSCARBL.
	GPT164_GTSSR_SSCARBL = 0x100
	// Counter start disabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTSSR_SSCARBL_0 = 0x0
	// Counter start enabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTSSR_SSCARBL_1 = 0x1
	// Position of SSCARBH field.
	GPT164_GTSSR_SSCARBH_Pos = 0x9
	// Bit mask of SSCARBH field.
	GPT164_GTSSR_SSCARBH_Msk = 0x200
	// Bit SSCARBH.
	GPT164_GTSSR_SSCARBH = 0x200
	// Counter start disabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTSSR_SSCARBH_0 = 0x0
	// Counter start enabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTSSR_SSCARBH_1 = 0x1
	// Position of SSCAFBL field.
	GPT164_GTSSR_SSCAFBL_Pos = 0xa
	// Bit mask of SSCAFBL field.
	GPT164_GTSSR_SSCAFBL_Msk = 0x400
	// Bit SSCAFBL.
	GPT164_GTSSR_SSCAFBL = 0x400
	// Counter start disabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTSSR_SSCAFBL_0 = 0x0
	// Counter start enabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTSSR_SSCAFBL_1 = 0x1
	// Position of SSCAFBH field.
	GPT164_GTSSR_SSCAFBH_Pos = 0xb
	// Bit mask of SSCAFBH field.
	GPT164_GTSSR_SSCAFBH_Msk = 0x800
	// Bit SSCAFBH.
	GPT164_GTSSR_SSCAFBH = 0x800
	// Counter start disabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTSSR_SSCAFBH_0 = 0x0
	// Counter start enabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTSSR_SSCAFBH_1 = 0x1
	// Position of SSCBRAL field.
	GPT164_GTSSR_SSCBRAL_Pos = 0xc
	// Bit mask of SSCBRAL field.
	GPT164_GTSSR_SSCBRAL_Msk = 0x1000
	// Bit SSCBRAL.
	GPT164_GTSSR_SSCBRAL = 0x1000
	// Counter start disabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTSSR_SSCBRAL_0 = 0x0
	// Counter start enabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTSSR_SSCBRAL_1 = 0x1
	// Position of SSCBRAH field.
	GPT164_GTSSR_SSCBRAH_Pos = 0xd
	// Bit mask of SSCBRAH field.
	GPT164_GTSSR_SSCBRAH_Msk = 0x2000
	// Bit SSCBRAH.
	GPT164_GTSSR_SSCBRAH = 0x2000
	// Counter start disabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTSSR_SSCBRAH_0 = 0x0
	// Counter start enabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTSSR_SSCBRAH_1 = 0x1
	// Position of SSCBFAL field.
	GPT164_GTSSR_SSCBFAL_Pos = 0xe
	// Bit mask of SSCBFAL field.
	GPT164_GTSSR_SSCBFAL_Msk = 0x4000
	// Bit SSCBFAL.
	GPT164_GTSSR_SSCBFAL = 0x4000
	// Counter start disabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTSSR_SSCBFAL_0 = 0x0
	// Counter start enabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTSSR_SSCBFAL_1 = 0x1
	// Position of SSCBFAH field.
	GPT164_GTSSR_SSCBFAH_Pos = 0xf
	// Bit mask of SSCBFAH field.
	GPT164_GTSSR_SSCBFAH_Msk = 0x8000
	// Bit SSCBFAH.
	GPT164_GTSSR_SSCBFAH = 0x8000
	// Counter start disabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTSSR_SSCBFAH_0 = 0x0
	// Counter start enabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTSSR_SSCBFAH_1 = 0x1
	// Position of SSELCA field.
	GPT164_GTSSR_SSELCA_Pos = 0x10
	// Bit mask of SSELCA field.
	GPT164_GTSSR_SSELCA_Msk = 0x10000
	// Bit SSELCA.
	GPT164_GTSSR_SSELCA = 0x10000
	// Counter start disabled at the ELC_GPTA input
	GPT164_GTSSR_SSELCA_0 = 0x0
	// Counter start enabled at the ELC_GPTA input
	GPT164_GTSSR_SSELCA_1 = 0x1
	// Position of SSELCB field.
	GPT164_GTSSR_SSELCB_Pos = 0x11
	// Bit mask of SSELCB field.
	GPT164_GTSSR_SSELCB_Msk = 0x20000
	// Bit SSELCB.
	GPT164_GTSSR_SSELCB = 0x20000
	// Counter start disabled at the ELC_GPTB input
	GPT164_GTSSR_SSELCB_0 = 0x0
	// Counter start enabled at the ELC_GPTB input
	GPT164_GTSSR_SSELCB_1 = 0x1
	// Position of SSELCC field.
	GPT164_GTSSR_SSELCC_Pos = 0x12
	// Bit mask of SSELCC field.
	GPT164_GTSSR_SSELCC_Msk = 0x40000
	// Bit SSELCC.
	GPT164_GTSSR_SSELCC = 0x40000
	// Counter start disabled at the ELC_GPTC input
	GPT164_GTSSR_SSELCC_0 = 0x0
	// Counter start enabled at the ELC_GPTC input
	GPT164_GTSSR_SSELCC_1 = 0x1
	// Position of SSELCD field.
	GPT164_GTSSR_SSELCD_Pos = 0x13
	// Bit mask of SSELCD field.
	GPT164_GTSSR_SSELCD_Msk = 0x80000
	// Bit SSELCD.
	GPT164_GTSSR_SSELCD = 0x80000
	// Counter start disabled at the ELC_GPTD input
	GPT164_GTSSR_SSELCD_0 = 0x0
	// Counter start enabled at the ELC_GPTD input
	GPT164_GTSSR_SSELCD_1 = 0x1
	// Position of CSTRT field.
	GPT164_GTSSR_CSTRT_Pos = 0x1f
	// Bit mask of CSTRT field.
	GPT164_GTSSR_CSTRT_Msk = 0x80000000
	// Bit CSTRT.
	GPT164_GTSSR_CSTRT = 0x80000000
	// Counter start disabled by the GTSTR register
	GPT164_GTSSR_CSTRT_0 = 0x0
	// Counter start enabled by the GTSTR register
	GPT164_GTSSR_CSTRT_1 = 0x1

	// GTPSR: General PWM Timer Stop Source Select Register
	// Position of PSGTRGAR field.
	GPT164_GTPSR_PSGTRGAR_Pos = 0x0
	// Bit mask of PSGTRGAR field.
	GPT164_GTPSR_PSGTRGAR_Msk = 0x1
	// Bit PSGTRGAR.
	GPT164_GTPSR_PSGTRGAR = 0x1
	// Counter stop disabled on the rising edge of GTETRGA input
	GPT164_GTPSR_PSGTRGAR_0 = 0x0
	// Counter stop enabled on the rising edge of GTETRGA input
	GPT164_GTPSR_PSGTRGAR_1 = 0x1
	// Position of PSGTRGAF field.
	GPT164_GTPSR_PSGTRGAF_Pos = 0x1
	// Bit mask of PSGTRGAF field.
	GPT164_GTPSR_PSGTRGAF_Msk = 0x2
	// Bit PSGTRGAF.
	GPT164_GTPSR_PSGTRGAF = 0x2
	// Counter stop disabled on the falling edge of GTETRGA input
	GPT164_GTPSR_PSGTRGAF_0 = 0x0
	// Counter stop enabled on the falling edge of GTETRGA input
	GPT164_GTPSR_PSGTRGAF_1 = 0x1
	// Position of PSGTRGBR field.
	GPT164_GTPSR_PSGTRGBR_Pos = 0x2
	// Bit mask of PSGTRGBR field.
	GPT164_GTPSR_PSGTRGBR_Msk = 0x4
	// Bit PSGTRGBR.
	GPT164_GTPSR_PSGTRGBR = 0x4
	// Counter stop disabled on the rising edge of GTETRGB input
	GPT164_GTPSR_PSGTRGBR_0 = 0x0
	// Counter stop enabled on the rising edge of GTETRGB input
	GPT164_GTPSR_PSGTRGBR_1 = 0x1
	// Position of PSGTRGBF field.
	GPT164_GTPSR_PSGTRGBF_Pos = 0x3
	// Bit mask of PSGTRGBF field.
	GPT164_GTPSR_PSGTRGBF_Msk = 0x8
	// Bit PSGTRGBF.
	GPT164_GTPSR_PSGTRGBF = 0x8
	// Counter stop disabled on the falling edge of GTETRGB input
	GPT164_GTPSR_PSGTRGBF_0 = 0x0
	// Counter stop enabled on the falling edge of GTETRGB input
	GPT164_GTPSR_PSGTRGBF_1 = 0x1
	// Position of PSCARBL field.
	GPT164_GTPSR_PSCARBL_Pos = 0x8
	// Bit mask of PSCARBL field.
	GPT164_GTPSR_PSCARBL_Msk = 0x100
	// Bit PSCARBL.
	GPT164_GTPSR_PSCARBL = 0x100
	// Counter stop disabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTPSR_PSCARBL_0 = 0x0
	// Counter stop enabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTPSR_PSCARBL_1 = 0x1
	// Position of PSCARBH field.
	GPT164_GTPSR_PSCARBH_Pos = 0x9
	// Bit mask of PSCARBH field.
	GPT164_GTPSR_PSCARBH_Msk = 0x200
	// Bit PSCARBH.
	GPT164_GTPSR_PSCARBH = 0x200
	// Counter stop disabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTPSR_PSCARBH_0 = 0x0
	// Counter stop enabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTPSR_PSCARBH_1 = 0x1
	// Position of PSCAFBL field.
	GPT164_GTPSR_PSCAFBL_Pos = 0xa
	// Bit mask of PSCAFBL field.
	GPT164_GTPSR_PSCAFBL_Msk = 0x400
	// Bit PSCAFBL.
	GPT164_GTPSR_PSCAFBL = 0x400
	// Counter stop disabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTPSR_PSCAFBL_0 = 0x0
	// Counter stop enabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTPSR_PSCAFBL_1 = 0x1
	// Position of PSCAFBH field.
	GPT164_GTPSR_PSCAFBH_Pos = 0xb
	// Bit mask of PSCAFBH field.
	GPT164_GTPSR_PSCAFBH_Msk = 0x800
	// Bit PSCAFBH.
	GPT164_GTPSR_PSCAFBH = 0x800
	// Counter stop disabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTPSR_PSCAFBH_0 = 0x0
	// Counter stop enabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTPSR_PSCAFBH_1 = 0x1
	// Position of PSCBRAL field.
	GPT164_GTPSR_PSCBRAL_Pos = 0xc
	// Bit mask of PSCBRAL field.
	GPT164_GTPSR_PSCBRAL_Msk = 0x1000
	// Bit PSCBRAL.
	GPT164_GTPSR_PSCBRAL = 0x1000
	// Counter stop disabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTPSR_PSCBRAL_0 = 0x0
	// Counter stop enabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTPSR_PSCBRAL_1 = 0x1
	// Position of PSCBRAH field.
	GPT164_GTPSR_PSCBRAH_Pos = 0xd
	// Bit mask of PSCBRAH field.
	GPT164_GTPSR_PSCBRAH_Msk = 0x2000
	// Bit PSCBRAH.
	GPT164_GTPSR_PSCBRAH = 0x2000
	// Counter stop disabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTPSR_PSCBRAH_0 = 0x0
	// Counter stop enabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTPSR_PSCBRAH_1 = 0x1
	// Position of PSCBFAL field.
	GPT164_GTPSR_PSCBFAL_Pos = 0xe
	// Bit mask of PSCBFAL field.
	GPT164_GTPSR_PSCBFAL_Msk = 0x4000
	// Bit PSCBFAL.
	GPT164_GTPSR_PSCBFAL = 0x4000
	// Counter stop disabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTPSR_PSCBFAL_0 = 0x0
	// Counter stop enabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTPSR_PSCBFAL_1 = 0x1
	// Position of PSCBFAH field.
	GPT164_GTPSR_PSCBFAH_Pos = 0xf
	// Bit mask of PSCBFAH field.
	GPT164_GTPSR_PSCBFAH_Msk = 0x8000
	// Bit PSCBFAH.
	GPT164_GTPSR_PSCBFAH = 0x8000
	// Counter stop disabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTPSR_PSCBFAH_0 = 0x0
	// Counter stop enabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTPSR_PSCBFAH_1 = 0x1
	// Position of PSELCA field.
	GPT164_GTPSR_PSELCA_Pos = 0x10
	// Bit mask of PSELCA field.
	GPT164_GTPSR_PSELCA_Msk = 0x10000
	// Bit PSELCA.
	GPT164_GTPSR_PSELCA = 0x10000
	// Counter stop disabled at the ELC_GPTA input
	GPT164_GTPSR_PSELCA_0 = 0x0
	// Counter stop enabled at the ELC_GPTA input
	GPT164_GTPSR_PSELCA_1 = 0x1
	// Position of PSELCB field.
	GPT164_GTPSR_PSELCB_Pos = 0x11
	// Bit mask of PSELCB field.
	GPT164_GTPSR_PSELCB_Msk = 0x20000
	// Bit PSELCB.
	GPT164_GTPSR_PSELCB = 0x20000
	// Counter stop disabled at the ELC_GPTB input
	GPT164_GTPSR_PSELCB_0 = 0x0
	// Counter stop enabled at the ELC_GPTB input
	GPT164_GTPSR_PSELCB_1 = 0x1
	// Position of PSELCC field.
	GPT164_GTPSR_PSELCC_Pos = 0x12
	// Bit mask of PSELCC field.
	GPT164_GTPSR_PSELCC_Msk = 0x40000
	// Bit PSELCC.
	GPT164_GTPSR_PSELCC = 0x40000
	// Counter stop disabled at the ELC_GPTC input
	GPT164_GTPSR_PSELCC_0 = 0x0
	// Counter stop enabled at the ELC_GPTC input
	GPT164_GTPSR_PSELCC_1 = 0x1
	// Position of PSELCD field.
	GPT164_GTPSR_PSELCD_Pos = 0x13
	// Bit mask of PSELCD field.
	GPT164_GTPSR_PSELCD_Msk = 0x80000
	// Bit PSELCD.
	GPT164_GTPSR_PSELCD = 0x80000
	// Counter stop disabled at the ELC_GPTD input
	GPT164_GTPSR_PSELCD_0 = 0x0
	// Counter stop enabled at the ELC_GPTD input
	GPT164_GTPSR_PSELCD_1 = 0x1
	// Position of CSTOP field.
	GPT164_GTPSR_CSTOP_Pos = 0x1f
	// Bit mask of CSTOP field.
	GPT164_GTPSR_CSTOP_Msk = 0x80000000
	// Bit CSTOP.
	GPT164_GTPSR_CSTOP = 0x80000000
	// Counter stop disabled by the GTSTP register
	GPT164_GTPSR_CSTOP_0 = 0x0
	// Counter stop enabled by the GTSTP register
	GPT164_GTPSR_CSTOP_1 = 0x1

	// GTCSR: General PWM Timer Clear Source Select Register
	// Position of CSGTRGAR field.
	GPT164_GTCSR_CSGTRGAR_Pos = 0x0
	// Bit mask of CSGTRGAR field.
	GPT164_GTCSR_CSGTRGAR_Msk = 0x1
	// Bit CSGTRGAR.
	GPT164_GTCSR_CSGTRGAR = 0x1
	// Counter clear disabled on the rising edge of GTETRGA input
	GPT164_GTCSR_CSGTRGAR_0 = 0x0
	// Counter clear enabled on the rising edge of GTETRGA input
	GPT164_GTCSR_CSGTRGAR_1 = 0x1
	// Position of CSGTRGAF field.
	GPT164_GTCSR_CSGTRGAF_Pos = 0x1
	// Bit mask of CSGTRGAF field.
	GPT164_GTCSR_CSGTRGAF_Msk = 0x2
	// Bit CSGTRGAF.
	GPT164_GTCSR_CSGTRGAF = 0x2
	// Counter clear disabled on the falling edge of GTETRGA input
	GPT164_GTCSR_CSGTRGAF_0 = 0x0
	// Counter clear enabled on the falling edge of GTETRGA input
	GPT164_GTCSR_CSGTRGAF_1 = 0x1
	// Position of CSGTRGBR field.
	GPT164_GTCSR_CSGTRGBR_Pos = 0x2
	// Bit mask of CSGTRGBR field.
	GPT164_GTCSR_CSGTRGBR_Msk = 0x4
	// Bit CSGTRGBR.
	GPT164_GTCSR_CSGTRGBR = 0x4
	// Disable counter clear on the rising edge of GTETRGB input
	GPT164_GTCSR_CSGTRGBR_0 = 0x0
	// Enable counter clear on the rising edge of GTETRGB input
	GPT164_GTCSR_CSGTRGBR_1 = 0x1
	// Position of CSGTRGBF field.
	GPT164_GTCSR_CSGTRGBF_Pos = 0x3
	// Bit mask of CSGTRGBF field.
	GPT164_GTCSR_CSGTRGBF_Msk = 0x8
	// Bit CSGTRGBF.
	GPT164_GTCSR_CSGTRGBF = 0x8
	// Counter clear disabled on the falling edge of GTETRGB input
	GPT164_GTCSR_CSGTRGBF_0 = 0x0
	// Counter clear enabled on the falling edge of GTETRGB input
	GPT164_GTCSR_CSGTRGBF_1 = 0x1
	// Position of CSCARBL field.
	GPT164_GTCSR_CSCARBL_Pos = 0x8
	// Bit mask of CSCARBL field.
	GPT164_GTCSR_CSCARBL_Msk = 0x100
	// Bit CSCARBL.
	GPT164_GTCSR_CSCARBL = 0x100
	// Counter clear disabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTCSR_CSCARBL_0 = 0x0
	// Counter clear enabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTCSR_CSCARBL_1 = 0x1
	// Position of CSCARBH field.
	GPT164_GTCSR_CSCARBH_Pos = 0x9
	// Bit mask of CSCARBH field.
	GPT164_GTCSR_CSCARBH_Msk = 0x200
	// Bit CSCARBH.
	GPT164_GTCSR_CSCARBH = 0x200
	// Counter clear disabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTCSR_CSCARBH_0 = 0x0
	// Counter clear enabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTCSR_CSCARBH_1 = 0x1
	// Position of CSCAFBL field.
	GPT164_GTCSR_CSCAFBL_Pos = 0xa
	// Bit mask of CSCAFBL field.
	GPT164_GTCSR_CSCAFBL_Msk = 0x400
	// Bit CSCAFBL.
	GPT164_GTCSR_CSCAFBL = 0x400
	// Counter clear disabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTCSR_CSCAFBL_0 = 0x0
	// Counter clear enabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTCSR_CSCAFBL_1 = 0x1
	// Position of CSCAFBH field.
	GPT164_GTCSR_CSCAFBH_Pos = 0xb
	// Bit mask of CSCAFBH field.
	GPT164_GTCSR_CSCAFBH_Msk = 0x800
	// Bit CSCAFBH.
	GPT164_GTCSR_CSCAFBH = 0x800
	// Counter clear disabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTCSR_CSCAFBH_0 = 0x0
	// Counter clear enabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTCSR_CSCAFBH_1 = 0x1
	// Position of CSCBRAL field.
	GPT164_GTCSR_CSCBRAL_Pos = 0xc
	// Bit mask of CSCBRAL field.
	GPT164_GTCSR_CSCBRAL_Msk = 0x1000
	// Bit CSCBRAL.
	GPT164_GTCSR_CSCBRAL = 0x1000
	// Counter clear disabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTCSR_CSCBRAL_0 = 0x0
	// Counter clear enabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTCSR_CSCBRAL_1 = 0x1
	// Position of CSCBRAH field.
	GPT164_GTCSR_CSCBRAH_Pos = 0xd
	// Bit mask of CSCBRAH field.
	GPT164_GTCSR_CSCBRAH_Msk = 0x2000
	// Bit CSCBRAH.
	GPT164_GTCSR_CSCBRAH = 0x2000
	// Counter clear disabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTCSR_CSCBRAH_0 = 0x0
	// Counter clear enabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTCSR_CSCBRAH_1 = 0x1
	// Position of CSCBFAL field.
	GPT164_GTCSR_CSCBFAL_Pos = 0xe
	// Bit mask of CSCBFAL field.
	GPT164_GTCSR_CSCBFAL_Msk = 0x4000
	// Bit CSCBFAL.
	GPT164_GTCSR_CSCBFAL = 0x4000
	// Counter clear disabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTCSR_CSCBFAL_0 = 0x0
	// Counter clear enabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTCSR_CSCBFAL_1 = 0x1
	// Position of CSCBFAH field.
	GPT164_GTCSR_CSCBFAH_Pos = 0xf
	// Bit mask of CSCBFAH field.
	GPT164_GTCSR_CSCBFAH_Msk = 0x8000
	// Bit CSCBFAH.
	GPT164_GTCSR_CSCBFAH = 0x8000
	// Counter clear disabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTCSR_CSCBFAH_0 = 0x0
	// Counter clear enabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTCSR_CSCBFAH_1 = 0x1
	// Position of CSELCA field.
	GPT164_GTCSR_CSELCA_Pos = 0x10
	// Bit mask of CSELCA field.
	GPT164_GTCSR_CSELCA_Msk = 0x10000
	// Bit CSELCA.
	GPT164_GTCSR_CSELCA = 0x10000
	// Counter clear disabled at the ELC_GPTA input
	GPT164_GTCSR_CSELCA_0 = 0x0
	// Counter clear enabled at the ELC_GPTA input
	GPT164_GTCSR_CSELCA_1 = 0x1
	// Position of CSELCB field.
	GPT164_GTCSR_CSELCB_Pos = 0x11
	// Bit mask of CSELCB field.
	GPT164_GTCSR_CSELCB_Msk = 0x20000
	// Bit CSELCB.
	GPT164_GTCSR_CSELCB = 0x20000
	// Counter clear disabled at the ELC_GPTB input
	GPT164_GTCSR_CSELCB_0 = 0x0
	// Counter clear enabled at the ELC_GPTB input
	GPT164_GTCSR_CSELCB_1 = 0x1
	// Position of CSELCC field.
	GPT164_GTCSR_CSELCC_Pos = 0x12
	// Bit mask of CSELCC field.
	GPT164_GTCSR_CSELCC_Msk = 0x40000
	// Bit CSELCC.
	GPT164_GTCSR_CSELCC = 0x40000
	// Counter clear disabled at the ELC_GPTC input
	GPT164_GTCSR_CSELCC_0 = 0x0
	// Counter clear enabled at the ELC_GPTC input
	GPT164_GTCSR_CSELCC_1 = 0x1
	// Position of CSELCD field.
	GPT164_GTCSR_CSELCD_Pos = 0x13
	// Bit mask of CSELCD field.
	GPT164_GTCSR_CSELCD_Msk = 0x80000
	// Bit CSELCD.
	GPT164_GTCSR_CSELCD = 0x80000
	// Counter clear disabled at the ELC_GPTD input
	GPT164_GTCSR_CSELCD_0 = 0x0
	// Counter clear enabled at the ELC_GPTD input
	GPT164_GTCSR_CSELCD_1 = 0x1
	// Position of CCLR field.
	GPT164_GTCSR_CCLR_Pos = 0x1f
	// Bit mask of CCLR field.
	GPT164_GTCSR_CCLR_Msk = 0x80000000
	// Bit CCLR.
	GPT164_GTCSR_CCLR = 0x80000000
	// Counter clear disabled by the GTCLR register
	GPT164_GTCSR_CCLR_0 = 0x0
	// Counter clear enabled by the GTCLR register
	GPT164_GTCSR_CCLR_1 = 0x1

	// GTUPSR: General PWM Timer Up Count Source Select Register
	// Position of USGTRGAR field.
	GPT164_GTUPSR_USGTRGAR_Pos = 0x0
	// Bit mask of USGTRGAR field.
	GPT164_GTUPSR_USGTRGAR_Msk = 0x1
	// Bit USGTRGAR.
	GPT164_GTUPSR_USGTRGAR = 0x1
	// Counter count up disabled on the rising edge of GTETRGA input
	GPT164_GTUPSR_USGTRGAR_0 = 0x0
	// Counter count up enabled on the rising edge of GTETRGA input
	GPT164_GTUPSR_USGTRGAR_1 = 0x1
	// Position of USGTRGAF field.
	GPT164_GTUPSR_USGTRGAF_Pos = 0x1
	// Bit mask of USGTRGAF field.
	GPT164_GTUPSR_USGTRGAF_Msk = 0x2
	// Bit USGTRGAF.
	GPT164_GTUPSR_USGTRGAF = 0x2
	// Counter count up disabled on the falling edge of GTETRGA input
	GPT164_GTUPSR_USGTRGAF_0 = 0x0
	// Counter count up enabled on the falling edge of GTETRGA input
	GPT164_GTUPSR_USGTRGAF_1 = 0x1
	// Position of USGTRGBR field.
	GPT164_GTUPSR_USGTRGBR_Pos = 0x2
	// Bit mask of USGTRGBR field.
	GPT164_GTUPSR_USGTRGBR_Msk = 0x4
	// Bit USGTRGBR.
	GPT164_GTUPSR_USGTRGBR = 0x4
	// Counter count up disabled on the rising edge of GTETRGB input
	GPT164_GTUPSR_USGTRGBR_0 = 0x0
	// Counter count up enabled on the rising edge of GTETRGB input
	GPT164_GTUPSR_USGTRGBR_1 = 0x1
	// Position of USGTRGBF field.
	GPT164_GTUPSR_USGTRGBF_Pos = 0x3
	// Bit mask of USGTRGBF field.
	GPT164_GTUPSR_USGTRGBF_Msk = 0x8
	// Bit USGTRGBF.
	GPT164_GTUPSR_USGTRGBF = 0x8
	// Counter count up disabled on the falling edge of GTETRGB input
	GPT164_GTUPSR_USGTRGBF_0 = 0x0
	// Counter count up enabled on the falling edge of GTETRGB input
	GPT164_GTUPSR_USGTRGBF_1 = 0x1
	// Position of USCARBL field.
	GPT164_GTUPSR_USCARBL_Pos = 0x8
	// Bit mask of USCARBL field.
	GPT164_GTUPSR_USCARBL_Msk = 0x100
	// Bit USCARBL.
	GPT164_GTUPSR_USCARBL = 0x100
	// Counter count up disabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTUPSR_USCARBL_0 = 0x0
	// Counter count up enabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTUPSR_USCARBL_1 = 0x1
	// Position of USCARBH field.
	GPT164_GTUPSR_USCARBH_Pos = 0x9
	// Bit mask of USCARBH field.
	GPT164_GTUPSR_USCARBH_Msk = 0x200
	// Bit USCARBH.
	GPT164_GTUPSR_USCARBH = 0x200
	// Counter count up disabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTUPSR_USCARBH_0 = 0x0
	// Counter count up enabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTUPSR_USCARBH_1 = 0x1
	// Position of USCAFBL field.
	GPT164_GTUPSR_USCAFBL_Pos = 0xa
	// Bit mask of USCAFBL field.
	GPT164_GTUPSR_USCAFBL_Msk = 0x400
	// Bit USCAFBL.
	GPT164_GTUPSR_USCAFBL = 0x400
	// Counter count up disabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTUPSR_USCAFBL_0 = 0x0
	// Counter count up enabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTUPSR_USCAFBL_1 = 0x1
	// Position of USCAFBH field.
	GPT164_GTUPSR_USCAFBH_Pos = 0xb
	// Bit mask of USCAFBH field.
	GPT164_GTUPSR_USCAFBH_Msk = 0x800
	// Bit USCAFBH.
	GPT164_GTUPSR_USCAFBH = 0x800
	// Counter count up disabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTUPSR_USCAFBH_0 = 0x0
	// Counter count up enabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTUPSR_USCAFBH_1 = 0x1
	// Position of USCBRAL field.
	GPT164_GTUPSR_USCBRAL_Pos = 0xc
	// Bit mask of USCBRAL field.
	GPT164_GTUPSR_USCBRAL_Msk = 0x1000
	// Bit USCBRAL.
	GPT164_GTUPSR_USCBRAL = 0x1000
	// Counter count up disabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTUPSR_USCBRAL_0 = 0x0
	// Counter count up enabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTUPSR_USCBRAL_1 = 0x1
	// Position of USCBRAH field.
	GPT164_GTUPSR_USCBRAH_Pos = 0xd
	// Bit mask of USCBRAH field.
	GPT164_GTUPSR_USCBRAH_Msk = 0x2000
	// Bit USCBRAH.
	GPT164_GTUPSR_USCBRAH = 0x2000
	// Counter count up disabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTUPSR_USCBRAH_0 = 0x0
	// Counter count up enabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTUPSR_USCBRAH_1 = 0x1
	// Position of USCBFAL field.
	GPT164_GTUPSR_USCBFAL_Pos = 0xe
	// Bit mask of USCBFAL field.
	GPT164_GTUPSR_USCBFAL_Msk = 0x4000
	// Bit USCBFAL.
	GPT164_GTUPSR_USCBFAL = 0x4000
	// Counter count up disabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTUPSR_USCBFAL_0 = 0x0
	// Counter count up enabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTUPSR_USCBFAL_1 = 0x1
	// Position of USCBFAH field.
	GPT164_GTUPSR_USCBFAH_Pos = 0xf
	// Bit mask of USCBFAH field.
	GPT164_GTUPSR_USCBFAH_Msk = 0x8000
	// Bit USCBFAH.
	GPT164_GTUPSR_USCBFAH = 0x8000
	// Counter count up disabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTUPSR_USCBFAH_0 = 0x0
	// Counter count up enabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTUPSR_USCBFAH_1 = 0x1
	// Position of USELCA field.
	GPT164_GTUPSR_USELCA_Pos = 0x10
	// Bit mask of USELCA field.
	GPT164_GTUPSR_USELCA_Msk = 0x10000
	// Bit USELCA.
	GPT164_GTUPSR_USELCA = 0x10000
	// Counter count up disabled at the ELC_GPTA input
	GPT164_GTUPSR_USELCA_0 = 0x0
	// Counter count up enabled at the ELC_GPTA input
	GPT164_GTUPSR_USELCA_1 = 0x1
	// Position of USELCB field.
	GPT164_GTUPSR_USELCB_Pos = 0x11
	// Bit mask of USELCB field.
	GPT164_GTUPSR_USELCB_Msk = 0x20000
	// Bit USELCB.
	GPT164_GTUPSR_USELCB = 0x20000
	// Counter count up disabled at the ELC_GPTB input
	GPT164_GTUPSR_USELCB_0 = 0x0
	// Counter count up enabled at the ELC_GPTB input
	GPT164_GTUPSR_USELCB_1 = 0x1
	// Position of USELCC field.
	GPT164_GTUPSR_USELCC_Pos = 0x12
	// Bit mask of USELCC field.
	GPT164_GTUPSR_USELCC_Msk = 0x40000
	// Bit USELCC.
	GPT164_GTUPSR_USELCC = 0x40000
	// Counter count up disabled at the ELC_GPTC input
	GPT164_GTUPSR_USELCC_0 = 0x0
	// Counter count up enabled at the ELC_GPTC input
	GPT164_GTUPSR_USELCC_1 = 0x1
	// Position of USELCD field.
	GPT164_GTUPSR_USELCD_Pos = 0x13
	// Bit mask of USELCD field.
	GPT164_GTUPSR_USELCD_Msk = 0x80000
	// Bit USELCD.
	GPT164_GTUPSR_USELCD = 0x80000
	// Counter count up disabled at the ELC_GPTD input
	GPT164_GTUPSR_USELCD_0 = 0x0
	// Counter count up enabled at the ELC_GPTD input
	GPT164_GTUPSR_USELCD_1 = 0x1

	// GTDNSR: General PWM Timer Down Count Source Select Register
	// Position of DSGTRGAR field.
	GPT164_GTDNSR_DSGTRGAR_Pos = 0x0
	// Bit mask of DSGTRGAR field.
	GPT164_GTDNSR_DSGTRGAR_Msk = 0x1
	// Bit DSGTRGAR.
	GPT164_GTDNSR_DSGTRGAR = 0x1
	// Counter count down disabled on the rising edge of GTETRGA input
	GPT164_GTDNSR_DSGTRGAR_0 = 0x0
	// Counter count down enabled on the rising edge of GTETRGA input
	GPT164_GTDNSR_DSGTRGAR_1 = 0x1
	// Position of DSGTRGAF field.
	GPT164_GTDNSR_DSGTRGAF_Pos = 0x1
	// Bit mask of DSGTRGAF field.
	GPT164_GTDNSR_DSGTRGAF_Msk = 0x2
	// Bit DSGTRGAF.
	GPT164_GTDNSR_DSGTRGAF = 0x2
	// Counter count down disabled on the falling edge of GTETRGA input
	GPT164_GTDNSR_DSGTRGAF_0 = 0x0
	// Counter count down enabled on the falling edge of GTETRGA input
	GPT164_GTDNSR_DSGTRGAF_1 = 0x1
	// Position of DSGTRGBR field.
	GPT164_GTDNSR_DSGTRGBR_Pos = 0x2
	// Bit mask of DSGTRGBR field.
	GPT164_GTDNSR_DSGTRGBR_Msk = 0x4
	// Bit DSGTRGBR.
	GPT164_GTDNSR_DSGTRGBR = 0x4
	// Counter count down disabled on the rising edge of GTETRGB input
	GPT164_GTDNSR_DSGTRGBR_0 = 0x0
	// Counter count down enabled on the rising edge of GTETRGB input
	GPT164_GTDNSR_DSGTRGBR_1 = 0x1
	// Position of DSGTRGBF field.
	GPT164_GTDNSR_DSGTRGBF_Pos = 0x3
	// Bit mask of DSGTRGBF field.
	GPT164_GTDNSR_DSGTRGBF_Msk = 0x8
	// Bit DSGTRGBF.
	GPT164_GTDNSR_DSGTRGBF = 0x8
	// Counter count down disabled on the falling edge of GTETRGB input
	GPT164_GTDNSR_DSGTRGBF_0 = 0x0
	// Counter count down enabled on the falling edge of GTETRGB input
	GPT164_GTDNSR_DSGTRGBF_1 = 0x1
	// Position of DSCARBL field.
	GPT164_GTDNSR_DSCARBL_Pos = 0x8
	// Bit mask of DSCARBL field.
	GPT164_GTDNSR_DSCARBL_Msk = 0x100
	// Bit DSCARBL.
	GPT164_GTDNSR_DSCARBL = 0x100
	// Counter count down disabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTDNSR_DSCARBL_0 = 0x0
	// Counter count down enabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTDNSR_DSCARBL_1 = 0x1
	// Position of DSCARBH field.
	GPT164_GTDNSR_DSCARBH_Pos = 0x9
	// Bit mask of DSCARBH field.
	GPT164_GTDNSR_DSCARBH_Msk = 0x200
	// Bit DSCARBH.
	GPT164_GTDNSR_DSCARBH = 0x200
	// Counter count down disabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTDNSR_DSCARBH_0 = 0x0
	// Counter count down enabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTDNSR_DSCARBH_1 = 0x1
	// Position of DSCAFBL field.
	GPT164_GTDNSR_DSCAFBL_Pos = 0xa
	// Bit mask of DSCAFBL field.
	GPT164_GTDNSR_DSCAFBL_Msk = 0x400
	// Bit DSCAFBL.
	GPT164_GTDNSR_DSCAFBL = 0x400
	// Counter count down disabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTDNSR_DSCAFBL_0 = 0x0
	// Counter count down enabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTDNSR_DSCAFBL_1 = 0x1
	// Position of DSCAFBH field.
	GPT164_GTDNSR_DSCAFBH_Pos = 0xb
	// Bit mask of DSCAFBH field.
	GPT164_GTDNSR_DSCAFBH_Msk = 0x800
	// Bit DSCAFBH.
	GPT164_GTDNSR_DSCAFBH = 0x800
	// Counter count down disabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTDNSR_DSCAFBH_0 = 0x0
	// Counter count down enabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTDNSR_DSCAFBH_1 = 0x1
	// Position of DSCBRAL field.
	GPT164_GTDNSR_DSCBRAL_Pos = 0xc
	// Bit mask of DSCBRAL field.
	GPT164_GTDNSR_DSCBRAL_Msk = 0x1000
	// Bit DSCBRAL.
	GPT164_GTDNSR_DSCBRAL = 0x1000
	// Counter count down disabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTDNSR_DSCBRAL_0 = 0x0
	// Counter count down enabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTDNSR_DSCBRAL_1 = 0x1
	// Position of DSCBRAH field.
	GPT164_GTDNSR_DSCBRAH_Pos = 0xd
	// Bit mask of DSCBRAH field.
	GPT164_GTDNSR_DSCBRAH_Msk = 0x2000
	// Bit DSCBRAH.
	GPT164_GTDNSR_DSCBRAH = 0x2000
	// Counter count down disabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTDNSR_DSCBRAH_0 = 0x0
	// Counter count down enabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTDNSR_DSCBRAH_1 = 0x1
	// Position of DSCBFAL field.
	GPT164_GTDNSR_DSCBFAL_Pos = 0xe
	// Bit mask of DSCBFAL field.
	GPT164_GTDNSR_DSCBFAL_Msk = 0x4000
	// Bit DSCBFAL.
	GPT164_GTDNSR_DSCBFAL = 0x4000
	// Counter count down disabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTDNSR_DSCBFAL_0 = 0x0
	// Counter count down enabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTDNSR_DSCBFAL_1 = 0x1
	// Position of DSCBFAH field.
	GPT164_GTDNSR_DSCBFAH_Pos = 0xf
	// Bit mask of DSCBFAH field.
	GPT164_GTDNSR_DSCBFAH_Msk = 0x8000
	// Bit DSCBFAH.
	GPT164_GTDNSR_DSCBFAH = 0x8000
	// Counter count down disabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTDNSR_DSCBFAH_0 = 0x0
	// Counter count down enabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTDNSR_DSCBFAH_1 = 0x1
	// Position of DSELCA field.
	GPT164_GTDNSR_DSELCA_Pos = 0x10
	// Bit mask of DSELCA field.
	GPT164_GTDNSR_DSELCA_Msk = 0x10000
	// Bit DSELCA.
	GPT164_GTDNSR_DSELCA = 0x10000
	// Counter count down disabled at the ELC_GPTA input
	GPT164_GTDNSR_DSELCA_0 = 0x0
	// Counter count down enabled at the ELC_GPTA input
	GPT164_GTDNSR_DSELCA_1 = 0x1
	// Position of DSELCB field.
	GPT164_GTDNSR_DSELCB_Pos = 0x11
	// Bit mask of DSELCB field.
	GPT164_GTDNSR_DSELCB_Msk = 0x20000
	// Bit DSELCB.
	GPT164_GTDNSR_DSELCB = 0x20000
	// Counter count down disabled at the ELC_GPTB input
	GPT164_GTDNSR_DSELCB_0 = 0x0
	// Counter count down enabled at the ELC_GPTB input
	GPT164_GTDNSR_DSELCB_1 = 0x1
	// Position of DSELCC field.
	GPT164_GTDNSR_DSELCC_Pos = 0x12
	// Bit mask of DSELCC field.
	GPT164_GTDNSR_DSELCC_Msk = 0x40000
	// Bit DSELCC.
	GPT164_GTDNSR_DSELCC = 0x40000
	// Counter count down disabled at the ELC_GPTC input
	GPT164_GTDNSR_DSELCC_0 = 0x0
	// Counter count down enabled at the ELC_GPTC input
	GPT164_GTDNSR_DSELCC_1 = 0x1
	// Position of DSELCD field.
	GPT164_GTDNSR_DSELCD_Pos = 0x13
	// Bit mask of DSELCD field.
	GPT164_GTDNSR_DSELCD_Msk = 0x80000
	// Bit DSELCD.
	GPT164_GTDNSR_DSELCD = 0x80000
	// Counter count down disabled at the ELC_GPTD input
	GPT164_GTDNSR_DSELCD_0 = 0x0
	// Counter count down enabled at the ELC_GPTD input
	GPT164_GTDNSR_DSELCD_1 = 0x1

	// GTICASR: General PWM Timer Input Capture Source Select Register A
	// Position of ASGTRGAR field.
	GPT164_GTICASR_ASGTRGAR_Pos = 0x0
	// Bit mask of ASGTRGAR field.
	GPT164_GTICASR_ASGTRGAR_Msk = 0x1
	// Bit ASGTRGAR.
	GPT164_GTICASR_ASGTRGAR = 0x1
	// GTCCRA input capture disabled on the rising edge of GTETRGA input
	GPT164_GTICASR_ASGTRGAR_0 = 0x0
	// GTCCRA input capture enabled on the rising edge of GTETRGA input
	GPT164_GTICASR_ASGTRGAR_1 = 0x1
	// Position of ASGTRGAF field.
	GPT164_GTICASR_ASGTRGAF_Pos = 0x1
	// Bit mask of ASGTRGAF field.
	GPT164_GTICASR_ASGTRGAF_Msk = 0x2
	// Bit ASGTRGAF.
	GPT164_GTICASR_ASGTRGAF = 0x2
	// GTCCRA input capture disabled on the falling edge of GTETRGA input
	GPT164_GTICASR_ASGTRGAF_0 = 0x0
	// GTCCRA input capture enabled on the falling edge of GTETRGA input
	GPT164_GTICASR_ASGTRGAF_1 = 0x1
	// Position of ASGTRGBR field.
	GPT164_GTICASR_ASGTRGBR_Pos = 0x2
	// Bit mask of ASGTRGBR field.
	GPT164_GTICASR_ASGTRGBR_Msk = 0x4
	// Bit ASGTRGBR.
	GPT164_GTICASR_ASGTRGBR = 0x4
	// GTCCRA input capture disabled on the rising edge of GTETRGB input
	GPT164_GTICASR_ASGTRGBR_0 = 0x0
	// GTCCRA input capture enabled on the rising edge of GTETRGB input
	GPT164_GTICASR_ASGTRGBR_1 = 0x1
	// Position of ASGTRGBF field.
	GPT164_GTICASR_ASGTRGBF_Pos = 0x3
	// Bit mask of ASGTRGBF field.
	GPT164_GTICASR_ASGTRGBF_Msk = 0x8
	// Bit ASGTRGBF.
	GPT164_GTICASR_ASGTRGBF = 0x8
	// GTCCRA input capture disabled on the falling edge of GTETRGB input
	GPT164_GTICASR_ASGTRGBF_0 = 0x0
	// GTCCRA input capture enabled on the falling edge of GTETRGB input
	GPT164_GTICASR_ASGTRGBF_1 = 0x1
	// Position of ASCARBL field.
	GPT164_GTICASR_ASCARBL_Pos = 0x8
	// Bit mask of ASCARBL field.
	GPT164_GTICASR_ASCARBL_Msk = 0x100
	// Bit ASCARBL.
	GPT164_GTICASR_ASCARBL = 0x100
	// GTCCRA input capture disabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTICASR_ASCARBL_0 = 0x0
	// GTCCRA input capture enabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTICASR_ASCARBL_1 = 0x1
	// Position of ASCARBH field.
	GPT164_GTICASR_ASCARBH_Pos = 0x9
	// Bit mask of ASCARBH field.
	GPT164_GTICASR_ASCARBH_Msk = 0x200
	// Bit ASCARBH.
	GPT164_GTICASR_ASCARBH = 0x200
	// GTCCRA input capture disabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTICASR_ASCARBH_0 = 0x0
	// GTCCRA input capture enabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTICASR_ASCARBH_1 = 0x1
	// Position of ASCAFBL field.
	GPT164_GTICASR_ASCAFBL_Pos = 0xa
	// Bit mask of ASCAFBL field.
	GPT164_GTICASR_ASCAFBL_Msk = 0x400
	// Bit ASCAFBL.
	GPT164_GTICASR_ASCAFBL = 0x400
	// GTCCRA input capture disabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTICASR_ASCAFBL_0 = 0x0
	// GTCCRA input capture enabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTICASR_ASCAFBL_1 = 0x1
	// Position of ASCAFBH field.
	GPT164_GTICASR_ASCAFBH_Pos = 0xb
	// Bit mask of ASCAFBH field.
	GPT164_GTICASR_ASCAFBH_Msk = 0x800
	// Bit ASCAFBH.
	GPT164_GTICASR_ASCAFBH = 0x800
	// GTCCRA input capture disabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTICASR_ASCAFBH_0 = 0x0
	// GTCCRA input capture enabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTICASR_ASCAFBH_1 = 0x1
	// Position of ASCBRAL field.
	GPT164_GTICASR_ASCBRAL_Pos = 0xc
	// Bit mask of ASCBRAL field.
	GPT164_GTICASR_ASCBRAL_Msk = 0x1000
	// Bit ASCBRAL.
	GPT164_GTICASR_ASCBRAL = 0x1000
	// GTCCRA input capture disabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTICASR_ASCBRAL_0 = 0x0
	// GTCCRA input capture enabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTICASR_ASCBRAL_1 = 0x1
	// Position of ASCBRAH field.
	GPT164_GTICASR_ASCBRAH_Pos = 0xd
	// Bit mask of ASCBRAH field.
	GPT164_GTICASR_ASCBRAH_Msk = 0x2000
	// Bit ASCBRAH.
	GPT164_GTICASR_ASCBRAH = 0x2000
	// GTCCRA input capture disabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTICASR_ASCBRAH_0 = 0x0
	// GTCCRA input capture enabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTICASR_ASCBRAH_1 = 0x1
	// Position of ASCBFAL field.
	GPT164_GTICASR_ASCBFAL_Pos = 0xe
	// Bit mask of ASCBFAL field.
	GPT164_GTICASR_ASCBFAL_Msk = 0x4000
	// Bit ASCBFAL.
	GPT164_GTICASR_ASCBFAL = 0x4000
	// GTCCRA input capture disabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTICASR_ASCBFAL_0 = 0x0
	// GTCCRA input capture enabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTICASR_ASCBFAL_1 = 0x1
	// Position of ASCBFAH field.
	GPT164_GTICASR_ASCBFAH_Pos = 0xf
	// Bit mask of ASCBFAH field.
	GPT164_GTICASR_ASCBFAH_Msk = 0x8000
	// Bit ASCBFAH.
	GPT164_GTICASR_ASCBFAH = 0x8000
	// GTCCRA input capture disabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTICASR_ASCBFAH_0 = 0x0
	// GTCCRA input capture enabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTICASR_ASCBFAH_1 = 0x1
	// Position of ASELCA field.
	GPT164_GTICASR_ASELCA_Pos = 0x10
	// Bit mask of ASELCA field.
	GPT164_GTICASR_ASELCA_Msk = 0x10000
	// Bit ASELCA.
	GPT164_GTICASR_ASELCA = 0x10000
	// GTCCRA input capture disabled at the ELC_GPTA input
	GPT164_GTICASR_ASELCA_0 = 0x0
	// GTCCRA input capture enabled at the ELC_GPTA input
	GPT164_GTICASR_ASELCA_1 = 0x1
	// Position of ASELCB field.
	GPT164_GTICASR_ASELCB_Pos = 0x11
	// Bit mask of ASELCB field.
	GPT164_GTICASR_ASELCB_Msk = 0x20000
	// Bit ASELCB.
	GPT164_GTICASR_ASELCB = 0x20000
	// GTCCRA input capture disabled at the ELC_GPTB input
	GPT164_GTICASR_ASELCB_0 = 0x0
	// GTCCRA input capture enabled at the ELC_GPTB input
	GPT164_GTICASR_ASELCB_1 = 0x1
	// Position of ASELCC field.
	GPT164_GTICASR_ASELCC_Pos = 0x12
	// Bit mask of ASELCC field.
	GPT164_GTICASR_ASELCC_Msk = 0x40000
	// Bit ASELCC.
	GPT164_GTICASR_ASELCC = 0x40000
	// GTCCRA input capture disabled at the ELC_GPTC input
	GPT164_GTICASR_ASELCC_0 = 0x0
	// GTCCRA input capture enabled at the ELC_GPTC input
	GPT164_GTICASR_ASELCC_1 = 0x1
	// Position of ASELCD field.
	GPT164_GTICASR_ASELCD_Pos = 0x13
	// Bit mask of ASELCD field.
	GPT164_GTICASR_ASELCD_Msk = 0x80000
	// Bit ASELCD.
	GPT164_GTICASR_ASELCD = 0x80000
	// GTCCRA input capture disabled at the ELC_GPTD input
	GPT164_GTICASR_ASELCD_0 = 0x0
	// GTCCRA input capture enabled at the ELC_GPTD input
	GPT164_GTICASR_ASELCD_1 = 0x1

	// GTICBSR: General PWM Timer Input Capture Source Select Register B
	// Position of BSGTRGAR field.
	GPT164_GTICBSR_BSGTRGAR_Pos = 0x0
	// Bit mask of BSGTRGAR field.
	GPT164_GTICBSR_BSGTRGAR_Msk = 0x1
	// Bit BSGTRGAR.
	GPT164_GTICBSR_BSGTRGAR = 0x1
	// GTCCRB input capture disabled on the rising edge of GTETRGA input
	GPT164_GTICBSR_BSGTRGAR_0 = 0x0
	// GTCCRB input capture enabled on the rising edge of GTETRGA input
	GPT164_GTICBSR_BSGTRGAR_1 = 0x1
	// Position of BSGTRGAF field.
	GPT164_GTICBSR_BSGTRGAF_Pos = 0x1
	// Bit mask of BSGTRGAF field.
	GPT164_GTICBSR_BSGTRGAF_Msk = 0x2
	// Bit BSGTRGAF.
	GPT164_GTICBSR_BSGTRGAF = 0x2
	// GTCCRB input capture disabled on the falling edge of GTETRGA input
	GPT164_GTICBSR_BSGTRGAF_0 = 0x0
	// GTCCRB input capture enabled on the falling edge of GTETRGA input
	GPT164_GTICBSR_BSGTRGAF_1 = 0x1
	// Position of BSGTRGBR field.
	GPT164_GTICBSR_BSGTRGBR_Pos = 0x2
	// Bit mask of BSGTRGBR field.
	GPT164_GTICBSR_BSGTRGBR_Msk = 0x4
	// Bit BSGTRGBR.
	GPT164_GTICBSR_BSGTRGBR = 0x4
	// GTCCRB input capture disabled on the rising edge of GTETRGB input
	GPT164_GTICBSR_BSGTRGBR_0 = 0x0
	// GTCCRB input capture enabled on the rising edge of GTETRGB input
	GPT164_GTICBSR_BSGTRGBR_1 = 0x1
	// Position of BSGTRGBF field.
	GPT164_GTICBSR_BSGTRGBF_Pos = 0x3
	// Bit mask of BSGTRGBF field.
	GPT164_GTICBSR_BSGTRGBF_Msk = 0x8
	// Bit BSGTRGBF.
	GPT164_GTICBSR_BSGTRGBF = 0x8
	// GTCCRB input capture disabled on the falling edge of GTETRGB input
	GPT164_GTICBSR_BSGTRGBF_0 = 0x0
	// GTCCRB input capture enabled on the falling edge of GTETRGB input
	GPT164_GTICBSR_BSGTRGBF_1 = 0x1
	// Position of BSCARBL field.
	GPT164_GTICBSR_BSCARBL_Pos = 0x8
	// Bit mask of BSCARBL field.
	GPT164_GTICBSR_BSCARBL_Msk = 0x100
	// Bit BSCARBL.
	GPT164_GTICBSR_BSCARBL = 0x100
	// GTCCRB input capture disabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTICBSR_BSCARBL_0 = 0x0
	// GTCCRB input capture enabled on the rising edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTICBSR_BSCARBL_1 = 0x1
	// Position of BSCARBH field.
	GPT164_GTICBSR_BSCARBH_Pos = 0x9
	// Bit mask of BSCARBH field.
	GPT164_GTICBSR_BSCARBH_Msk = 0x200
	// Bit BSCARBH.
	GPT164_GTICBSR_BSCARBH = 0x200
	// GTCCRB input capture disabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTICBSR_BSCARBH_0 = 0x0
	// GTCCRB input capture enabled on the rising edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTICBSR_BSCARBH_1 = 0x1
	// Position of BSCAFBL field.
	GPT164_GTICBSR_BSCAFBL_Pos = 0xa
	// Bit mask of BSCAFBL field.
	GPT164_GTICBSR_BSCAFBL_Msk = 0x400
	// Bit BSCAFBL.
	GPT164_GTICBSR_BSCAFBL = 0x400
	// GTCCRB input capture disabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTICBSR_BSCAFBL_0 = 0x0
	// GTCCRB input capture enabled on the falling edge of GTIOCnA input when GTIOCnB input is 0
	GPT164_GTICBSR_BSCAFBL_1 = 0x1
	// Position of BSCAFBH field.
	GPT164_GTICBSR_BSCAFBH_Pos = 0xb
	// Bit mask of BSCAFBH field.
	GPT164_GTICBSR_BSCAFBH_Msk = 0x800
	// Bit BSCAFBH.
	GPT164_GTICBSR_BSCAFBH = 0x800
	// GTCCRB input capture disabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTICBSR_BSCAFBH_0 = 0x0
	// GTCCRB input capture enabled on the falling edge of GTIOCnA input when GTIOCnB input is 1
	GPT164_GTICBSR_BSCAFBH_1 = 0x1
	// Position of BSCBRAL field.
	GPT164_GTICBSR_BSCBRAL_Pos = 0xc
	// Bit mask of BSCBRAL field.
	GPT164_GTICBSR_BSCBRAL_Msk = 0x1000
	// Bit BSCBRAL.
	GPT164_GTICBSR_BSCBRAL = 0x1000
	// GTCCRB input capture disabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTICBSR_BSCBRAL_0 = 0x0
	// GTCCRB input capture enabled on the rising edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTICBSR_BSCBRAL_1 = 0x1
	// Position of BSCBRAH field.
	GPT164_GTICBSR_BSCBRAH_Pos = 0xd
	// Bit mask of BSCBRAH field.
	GPT164_GTICBSR_BSCBRAH_Msk = 0x2000
	// Bit BSCBRAH.
	GPT164_GTICBSR_BSCBRAH = 0x2000
	// GTCCRB input capture disabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTICBSR_BSCBRAH_0 = 0x0
	// GTCCRB input capture enabled on the rising edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTICBSR_BSCBRAH_1 = 0x1
	// Position of BSCBFAL field.
	GPT164_GTICBSR_BSCBFAL_Pos = 0xe
	// Bit mask of BSCBFAL field.
	GPT164_GTICBSR_BSCBFAL_Msk = 0x4000
	// Bit BSCBFAL.
	GPT164_GTICBSR_BSCBFAL = 0x4000
	// GTCCRB input capture disabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTICBSR_BSCBFAL_0 = 0x0
	// GTCCRB input capture enabled on the falling edge of GTIOCnB input when GTIOCnA input is 0
	GPT164_GTICBSR_BSCBFAL_1 = 0x1
	// Position of BSCBFAH field.
	GPT164_GTICBSR_BSCBFAH_Pos = 0xf
	// Bit mask of BSCBFAH field.
	GPT164_GTICBSR_BSCBFAH_Msk = 0x8000
	// Bit BSCBFAH.
	GPT164_GTICBSR_BSCBFAH = 0x8000
	// GTCCRB input capture disabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTICBSR_BSCBFAH_0 = 0x0
	// GTCCRB input capture enabled on the falling edge of GTIOCnB input when GTIOCnA input is 1
	GPT164_GTICBSR_BSCBFAH_1 = 0x1
	// Position of BSELCA field.
	GPT164_GTICBSR_BSELCA_Pos = 0x10
	// Bit mask of BSELCA field.
	GPT164_GTICBSR_BSELCA_Msk = 0x10000
	// Bit BSELCA.
	GPT164_GTICBSR_BSELCA = 0x10000
	// GTCCRB input capture disabled at the ELC_GPTA input
	GPT164_GTICBSR_BSELCA_0 = 0x0
	// GTCCRB input capture enabled at the ELC_GPTA input
	GPT164_GTICBSR_BSELCA_1 = 0x1
	// Position of BSELCB field.
	GPT164_GTICBSR_BSELCB_Pos = 0x11
	// Bit mask of BSELCB field.
	GPT164_GTICBSR_BSELCB_Msk = 0x20000
	// Bit BSELCB.
	GPT164_GTICBSR_BSELCB = 0x20000
	// GTCCRB input capture disabled at the ELC_GPTB input
	GPT164_GTICBSR_BSELCB_0 = 0x0
	// GTCCRB input capture enabled at the ELC_GPTB input
	GPT164_GTICBSR_BSELCB_1 = 0x1
	// Position of BSELCC field.
	GPT164_GTICBSR_BSELCC_Pos = 0x12
	// Bit mask of BSELCC field.
	GPT164_GTICBSR_BSELCC_Msk = 0x40000
	// Bit BSELCC.
	GPT164_GTICBSR_BSELCC = 0x40000
	// GTCCRB input capture disabled at the ELC_GPTC input
	GPT164_GTICBSR_BSELCC_0 = 0x0
	// GTCCRB input capture enabled at the ELC_GPTC input
	GPT164_GTICBSR_BSELCC_1 = 0x1
	// Position of BSELCD field.
	GPT164_GTICBSR_BSELCD_Pos = 0x13
	// Bit mask of BSELCD field.
	GPT164_GTICBSR_BSELCD_Msk = 0x80000
	// Bit BSELCD.
	GPT164_GTICBSR_BSELCD = 0x80000
	// GTCCRB input capture disabled at the ELC_GPTD input
	GPT164_GTICBSR_BSELCD_0 = 0x0
	// GTCCRB input capture enabled at the ELC_GPTD input
	GPT164_GTICBSR_BSELCD_1 = 0x1

	// GTCR: General PWM Timer Control Register
	// Position of CST field.
	GPT164_GTCR_CST_Pos = 0x0
	// Bit mask of CST field.
	GPT164_GTCR_CST_Msk = 0x1
	// Bit CST.
	GPT164_GTCR_CST = 0x1
	// Count operation is stopped
	GPT164_GTCR_CST_0 = 0x0
	// Count operation is performed
	GPT164_GTCR_CST_1 = 0x1
	// Position of MD field.
	GPT164_GTCR_MD_Pos = 0x10
	// Bit mask of MD field.
	GPT164_GTCR_MD_Msk = 0x70000
	// Saw-wave PWM mode (single buffer or double buffer possible)
	GPT164_GTCR_MD_000 = 0x0
	// Saw-wave one-shot pulse mode (fixed buffer operation)
	GPT164_GTCR_MD_001 = 0x1
	// Setting prohibited
	GPT164_GTCR_MD_010 = 0x2
	// Setting prohibited
	GPT164_GTCR_MD_011 = 0x3
	// Triangle-wave PWM mode 1 (32-bit transfer at trough) (single buffer or double buffer is possible)
	GPT164_GTCR_MD_100 = 0x4
	// Triangle-wave PWM mode 2 (32-bit transfer at crest and trough) (single buffer or double buffer is possible)
	GPT164_GTCR_MD_101 = 0x5
	// Triangle-wave PWM mode 3 (64-bit transfer at trough) (fixed buffer operation)
	GPT164_GTCR_MD_110 = 0x6
	// Setting prohibited
	GPT164_GTCR_MD_111 = 0x7
	// Position of TPCS field.
	GPT164_GTCR_TPCS_Pos = 0x18
	// Bit mask of TPCS field.
	GPT164_GTCR_TPCS_Msk = 0x7000000
	// PCLKD/1
	GPT164_GTCR_TPCS_000 = 0x0
	// PCLKD/4
	GPT164_GTCR_TPCS_001 = 0x1
	// PCLKD/16
	GPT164_GTCR_TPCS_010 = 0x2
	// PCLKD/64
	GPT164_GTCR_TPCS_011 = 0x3
	// PCLKD/256
	GPT164_GTCR_TPCS_100 = 0x4
	// PCLKD/1024
	GPT164_GTCR_TPCS_101 = 0x5

	// GTUDDTYC: General PWM Timer Count Direction and Duty Setting Register
	// Position of UD field.
	GPT164_GTUDDTYC_UD_Pos = 0x0
	// Bit mask of UD field.
	GPT164_GTUDDTYC_UD_Msk = 0x1
	// Bit UD.
	GPT164_GTUDDTYC_UD = 0x1
	// GTCNT counts down
	GPT164_GTUDDTYC_UD_0 = 0x0
	// GTCNT counts up
	GPT164_GTUDDTYC_UD_1 = 0x1
	// Position of UDF field.
	GPT164_GTUDDTYC_UDF_Pos = 0x1
	// Bit mask of UDF field.
	GPT164_GTUDDTYC_UDF_Msk = 0x2
	// Bit UDF.
	GPT164_GTUDDTYC_UDF = 0x2
	// Not forcibly set
	GPT164_GTUDDTYC_UDF_0 = 0x0
	// Forcibly set
	GPT164_GTUDDTYC_UDF_1 = 0x1
	// Position of OADTY field.
	GPT164_GTUDDTYC_OADTY_Pos = 0x10
	// Bit mask of OADTY field.
	GPT164_GTUDDTYC_OADTY_Msk = 0x30000
	// GTIOCnA pin duty depends on the compare match
	GPT164_GTUDDTYC_OADTY_00 = 0x0
	// GTIOCnA pin duty depends on the compare match
	GPT164_GTUDDTYC_OADTY_01 = 0x1
	// GTIOCnA pin duty 0%
	GPT164_GTUDDTYC_OADTY_10 = 0x2
	// GTIOCnA pin duty 100%
	GPT164_GTUDDTYC_OADTY_11 = 0x3
	// Position of OADTYF field.
	GPT164_GTUDDTYC_OADTYF_Pos = 0x12
	// Bit mask of OADTYF field.
	GPT164_GTUDDTYC_OADTYF_Msk = 0x40000
	// Bit OADTYF.
	GPT164_GTUDDTYC_OADTYF = 0x40000
	// Not forcibly set
	GPT164_GTUDDTYC_OADTYF_0 = 0x0
	// Forcibly set
	GPT164_GTUDDTYC_OADTYF_1 = 0x1
	// Position of OADTYR field.
	GPT164_GTUDDTYC_OADTYR_Pos = 0x13
	// Bit mask of OADTYR field.
	GPT164_GTUDDTYC_OADTYR_Msk = 0x80000
	// Bit OADTYR.
	GPT164_GTUDDTYC_OADTYR = 0x80000
	// The function selected by the GTIOA[3:2] bits is applied to the output value when the duty cycle is set after release from the 0 or 100% duty-cycle setting.
	GPT164_GTUDDTYC_OADTYR_0 = 0x0
	// The function selected by the GTIOA[3:2] bits is applied to the compare match output value which is masked after release from the 0 or 100% duty-cycle setting.
	GPT164_GTUDDTYC_OADTYR_1 = 0x1
	// Position of OBDTY field.
	GPT164_GTUDDTYC_OBDTY_Pos = 0x18
	// Bit mask of OBDTY field.
	GPT164_GTUDDTYC_OBDTY_Msk = 0x3000000
	// GTIOCnB pin duty depends on the compare match
	GPT164_GTUDDTYC_OBDTY_00 = 0x0
	// GTIOCnB pin duty depends on the compare match
	GPT164_GTUDDTYC_OBDTY_01 = 0x1
	// GTIOCnB pin duty 0%
	GPT164_GTUDDTYC_OBDTY_10 = 0x2
	// GTIOCnB pin duty 100%
	GPT164_GTUDDTYC_OBDTY_11 = 0x3
	// Position of OBDTYF field.
	GPT164_GTUDDTYC_OBDTYF_Pos = 0x1a
	// Bit mask of OBDTYF field.
	GPT164_GTUDDTYC_OBDTYF_Msk = 0x4000000
	// Bit OBDTYF.
	GPT164_GTUDDTYC_OBDTYF = 0x4000000
	// Not forcibly set
	GPT164_GTUDDTYC_OBDTYF_0 = 0x0
	// Forcibly set
	GPT164_GTUDDTYC_OBDTYF_1 = 0x1
	// Position of OBDTYR field.
	GPT164_GTUDDTYC_OBDTYR_Pos = 0x1b
	// Bit mask of OBDTYR field.
	GPT164_GTUDDTYC_OBDTYR_Msk = 0x8000000
	// Bit OBDTYR.
	GPT164_GTUDDTYC_OBDTYR = 0x8000000
	// The function selected by the GTIOB[3:2] bits is applied to the output value when the duty cycle is set after release from the 0 or 100% duty-cycle setting.
	GPT164_GTUDDTYC_OBDTYR_0 = 0x0
	// The function selected by the GTIOB[3:2] bits is applied to the compare match output value which is masked after release from the 0 or 100% duty-cycle setting.
	GPT164_GTUDDTYC_OBDTYR_1 = 0x1

	// GTIOR: General PWM Timer I/O Control Register
	// Position of GTIOA field.
	GPT164_GTIOR_GTIOA_Pos = 0x0
	// Bit mask of GTIOA field.
	GPT164_GTIOR_GTIOA_Msk = 0x1f
	// Position of OADFLT field.
	GPT164_GTIOR_OADFLT_Pos = 0x6
	// Bit mask of OADFLT field.
	GPT164_GTIOR_OADFLT_Msk = 0x40
	// Bit OADFLT.
	GPT164_GTIOR_OADFLT = 0x40
	// The GTIOCnA pin outputs low when counting stops
	GPT164_GTIOR_OADFLT_0 = 0x0
	// The GTIOCnA pin outputs high when counting stops
	GPT164_GTIOR_OADFLT_1 = 0x1
	// Position of OAHLD field.
	GPT164_GTIOR_OAHLD_Pos = 0x7
	// Bit mask of OAHLD field.
	GPT164_GTIOR_OAHLD_Msk = 0x80
	// Bit OAHLD.
	GPT164_GTIOR_OAHLD = 0x80
	// The GTIOCnA pin output level at the start or stop of counting depends on the register setting
	GPT164_GTIOR_OAHLD_0 = 0x0
	// The GTIOCnA pin output level is retained at the start or stop of counting
	GPT164_GTIOR_OAHLD_1 = 0x1
	// Position of OAE field.
	GPT164_GTIOR_OAE_Pos = 0x8
	// Bit mask of OAE field.
	GPT164_GTIOR_OAE_Msk = 0x100
	// Bit OAE.
	GPT164_GTIOR_OAE = 0x100
	// Output is disabled
	GPT164_GTIOR_OAE_0 = 0x0
	// Output is enabled
	GPT164_GTIOR_OAE_1 = 0x1
	// Position of OADF field.
	GPT164_GTIOR_OADF_Pos = 0x9
	// Bit mask of OADF field.
	GPT164_GTIOR_OADF_Msk = 0x600
	// None of the below options are specified
	GPT164_GTIOR_OADF_00 = 0x0
	// GTIOCnA pin is set to Hi-Z in response to controlling the output negation
	GPT164_GTIOR_OADF_01 = 0x1
	// GTIOCnA pin is set to 0 in response to controlling the output negation
	GPT164_GTIOR_OADF_10 = 0x2
	// GTIOCnA pin is set to 1 in response to controlling the output negation
	GPT164_GTIOR_OADF_11 = 0x3
	// Position of NFAEN field.
	GPT164_GTIOR_NFAEN_Pos = 0xd
	// Bit mask of NFAEN field.
	GPT164_GTIOR_NFAEN_Msk = 0x2000
	// Bit NFAEN.
	GPT164_GTIOR_NFAEN = 0x2000
	// The noise filter for the GTIOCnA pin is disabled
	GPT164_GTIOR_NFAEN_0 = 0x0
	// The noise filter for the GTIOCnA pin is enabled
	GPT164_GTIOR_NFAEN_1 = 0x1
	// Position of NFCSA field.
	GPT164_GTIOR_NFCSA_Pos = 0xe
	// Bit mask of NFCSA field.
	GPT164_GTIOR_NFCSA_Msk = 0xc000
	// PCLKD/1
	GPT164_GTIOR_NFCSA_00 = 0x0
	// PCLKD/4
	GPT164_GTIOR_NFCSA_01 = 0x1
	// PCLKD/16
	GPT164_GTIOR_NFCSA_10 = 0x2
	// PCLKD/64
	GPT164_GTIOR_NFCSA_11 = 0x3
	// Position of GTIOB field.
	GPT164_GTIOR_GTIOB_Pos = 0x10
	// Bit mask of GTIOB field.
	GPT164_GTIOR_GTIOB_Msk = 0x1f0000
	// Position of OBDFLT field.
	GPT164_GTIOR_OBDFLT_Pos = 0x16
	// Bit mask of OBDFLT field.
	GPT164_GTIOR_OBDFLT_Msk = 0x400000
	// Bit OBDFLT.
	GPT164_GTIOR_OBDFLT = 0x400000
	// The GTIOCnB pin outputs low when counting stops
	GPT164_GTIOR_OBDFLT_0 = 0x0
	// The GTIOCnB pin outputs high when counting stops
	GPT164_GTIOR_OBDFLT_1 = 0x1
	// Position of OBHLD field.
	GPT164_GTIOR_OBHLD_Pos = 0x17
	// Bit mask of OBHLD field.
	GPT164_GTIOR_OBHLD_Msk = 0x800000
	// Bit OBHLD.
	GPT164_GTIOR_OBHLD = 0x800000
	// The GTIOCnB pin output level at the start/stop of counting depends on the register setting
	GPT164_GTIOR_OBHLD_0 = 0x0
	// The GTIOCnB pin output level is retained at the start/stop of counting
	GPT164_GTIOR_OBHLD_1 = 0x1
	// Position of OBE field.
	GPT164_GTIOR_OBE_Pos = 0x18
	// Bit mask of OBE field.
	GPT164_GTIOR_OBE_Msk = 0x1000000
	// Bit OBE.
	GPT164_GTIOR_OBE = 0x1000000
	// Output is disabled
	GPT164_GTIOR_OBE_0 = 0x0
	// Output is enabled
	GPT164_GTIOR_OBE_1 = 0x1
	// Position of OBDF field.
	GPT164_GTIOR_OBDF_Pos = 0x19
	// Bit mask of OBDF field.
	GPT164_GTIOR_OBDF_Msk = 0x6000000
	// None of the below options are specified
	GPT164_GTIOR_OBDF_00 = 0x0
	// GTIOCnB pin is set to Hi-Z in response to controlling the output negation
	GPT164_GTIOR_OBDF_01 = 0x1
	// GTIOCnB pin is set to 0 in response to controlling the output negation
	GPT164_GTIOR_OBDF_10 = 0x2
	// GTIOCnB pin is set to 1 in response to controlling the output negation
	GPT164_GTIOR_OBDF_11 = 0x3
	// Position of NFBEN field.
	GPT164_GTIOR_NFBEN_Pos = 0x1d
	// Bit mask of NFBEN field.
	GPT164_GTIOR_NFBEN_Msk = 0x20000000
	// Bit NFBEN.
	GPT164_GTIOR_NFBEN = 0x20000000
	// The noise filter for the GTIOCnB pin is disabled
	GPT164_GTIOR_NFBEN_0 = 0x0
	// The noise filter for the GTIOCnB pin is enabled
	GPT164_GTIOR_NFBEN_1 = 0x1
	// Position of NFCSB field.
	GPT164_GTIOR_NFCSB_Pos = 0x1e
	// Bit mask of NFCSB field.
	GPT164_GTIOR_NFCSB_Msk = 0xc0000000
	// PCLKD/1
	GPT164_GTIOR_NFCSB_00 = 0x0
	// PCLKD/4
	GPT164_GTIOR_NFCSB_01 = 0x1
	// PCLKD/16
	GPT164_GTIOR_NFCSB_10 = 0x2
	// PCLKD/64
	GPT164_GTIOR_NFCSB_11 = 0x3

	// GTINTAD: General PWM Timer Interrupt Output Setting Register
	// Position of GRP field.
	GPT164_GTINTAD_GRP_Pos = 0x18
	// Bit mask of GRP field.
	GPT164_GTINTAD_GRP_Msk = 0x3000000
	// Group A output disable request is selected
	GPT164_GTINTAD_GRP_00 = 0x0
	// Group B output disable request is selected
	GPT164_GTINTAD_GRP_01 = 0x1
	// Position of GRPABH field.
	GPT164_GTINTAD_GRPABH_Pos = 0x1d
	// Bit mask of GRPABH field.
	GPT164_GTINTAD_GRPABH_Msk = 0x20000000
	// Bit GRPABH.
	GPT164_GTINTAD_GRPABH = 0x20000000
	// Same time output level high disable request disabled
	GPT164_GTINTAD_GRPABH_0 = 0x0
	// Same time output level high disable request enabled
	GPT164_GTINTAD_GRPABH_1 = 0x1
	// Position of GRPABL field.
	GPT164_GTINTAD_GRPABL_Pos = 0x1e
	// Bit mask of GRPABL field.
	GPT164_GTINTAD_GRPABL_Msk = 0x40000000
	// Bit GRPABL.
	GPT164_GTINTAD_GRPABL = 0x40000000
	// Same time output level low disable request disabled
	GPT164_GTINTAD_GRPABL_0 = 0x0
	// Same time output level low disable request enabled
	GPT164_GTINTAD_GRPABL_1 = 0x1

	// GTST: General PWM Timer Status Register
	// Position of TCFA field.
	GPT164_GTST_TCFA_Pos = 0x0
	// Bit mask of TCFA field.
	GPT164_GTST_TCFA_Msk = 0x1
	// Bit TCFA.
	GPT164_GTST_TCFA = 0x1
	// No input capture/compare match of GTCCRA is generated
	GPT164_GTST_TCFA_0 = 0x0
	// An input capture/compare match of GTCCRA is generated
	GPT164_GTST_TCFA_1 = 0x1
	// Position of TCFB field.
	GPT164_GTST_TCFB_Pos = 0x1
	// Bit mask of TCFB field.
	GPT164_GTST_TCFB_Msk = 0x2
	// Bit TCFB.
	GPT164_GTST_TCFB = 0x2
	// No input capture/compare match of GTCCRB is generated
	GPT164_GTST_TCFB_0 = 0x0
	// An input capture/compare match of GTCCRB is generated
	GPT164_GTST_TCFB_1 = 0x1
	// Position of TCFC field.
	GPT164_GTST_TCFC_Pos = 0x2
	// Bit mask of TCFC field.
	GPT164_GTST_TCFC_Msk = 0x4
	// Bit TCFC.
	GPT164_GTST_TCFC = 0x4
	// No compare match of GTCCRC is generated
	GPT164_GTST_TCFC_0 = 0x0
	// A compare match of GTCCRC is generated
	GPT164_GTST_TCFC_1 = 0x1
	// Position of TCFD field.
	GPT164_GTST_TCFD_Pos = 0x3
	// Bit mask of TCFD field.
	GPT164_GTST_TCFD_Msk = 0x8
	// Bit TCFD.
	GPT164_GTST_TCFD = 0x8
	// No compare match of GTCCRD is generated
	GPT164_GTST_TCFD_0 = 0x0
	// A compare match of GTCCRD is generated
	GPT164_GTST_TCFD_1 = 0x1
	// Position of TCFE field.
	GPT164_GTST_TCFE_Pos = 0x4
	// Bit mask of TCFE field.
	GPT164_GTST_TCFE_Msk = 0x10
	// Bit TCFE.
	GPT164_GTST_TCFE = 0x10
	// No compare match of GTCCRE is generated
	GPT164_GTST_TCFE_0 = 0x0
	// A compare match of GTCCRE is generated
	GPT164_GTST_TCFE_1 = 0x1
	// Position of TCFF field.
	GPT164_GTST_TCFF_Pos = 0x5
	// Bit mask of TCFF field.
	GPT164_GTST_TCFF_Msk = 0x20
	// Bit TCFF.
	GPT164_GTST_TCFF = 0x20
	// No compare match of GTCCRF is generated
	GPT164_GTST_TCFF_0 = 0x0
	// A compare match of GTCCRF is generated
	GPT164_GTST_TCFF_1 = 0x1
	// Position of TCFPO field.
	GPT164_GTST_TCFPO_Pos = 0x6
	// Bit mask of TCFPO field.
	GPT164_GTST_TCFPO_Msk = 0x40
	// Bit TCFPO.
	GPT164_GTST_TCFPO = 0x40
	// No overflow (crest) occurred
	GPT164_GTST_TCFPO_0 = 0x0
	// An overflow (crest) occurred
	GPT164_GTST_TCFPO_1 = 0x1
	// Position of TCFPU field.
	GPT164_GTST_TCFPU_Pos = 0x7
	// Bit mask of TCFPU field.
	GPT164_GTST_TCFPU_Msk = 0x80
	// Bit TCFPU.
	GPT164_GTST_TCFPU = 0x80
	// No underflow (trough) occurred
	GPT164_GTST_TCFPU_0 = 0x0
	// An underflow (trough) occurred
	GPT164_GTST_TCFPU_1 = 0x1
	// Position of TUCF field.
	GPT164_GTST_TUCF_Pos = 0xf
	// Bit mask of TUCF field.
	GPT164_GTST_TUCF_Msk = 0x8000
	// Bit TUCF.
	GPT164_GTST_TUCF = 0x8000
	// GTCNT counter counts downward
	GPT164_GTST_TUCF_0 = 0x0
	// GTCNT counter counts upward
	GPT164_GTST_TUCF_1 = 0x1
	// Position of ODF field.
	GPT164_GTST_ODF_Pos = 0x18
	// Bit mask of ODF field.
	GPT164_GTST_ODF_Msk = 0x1000000
	// Bit ODF.
	GPT164_GTST_ODF = 0x1000000
	// No output disable request is generated
	GPT164_GTST_ODF_0 = 0x0
	// An output disable request is generated
	GPT164_GTST_ODF_1 = 0x1
	// Position of OABHF field.
	GPT164_GTST_OABHF_Pos = 0x1d
	// Bit mask of OABHF field.
	GPT164_GTST_OABHF_Msk = 0x20000000
	// Bit OABHF.
	GPT164_GTST_OABHF = 0x20000000
	// No simultaneous generation of 1 both for the GTIOCA and GTIOCB pins has occurred.
	GPT164_GTST_OABHF_0 = 0x0
	// A simultaneous generation of 1 both for the GTIOCA and GTIOCB pins has occurred.
	GPT164_GTST_OABHF_1 = 0x1
	// Position of OABLF field.
	GPT164_GTST_OABLF_Pos = 0x1e
	// Bit mask of OABLF field.
	GPT164_GTST_OABLF_Msk = 0x40000000
	// Bit OABLF.
	GPT164_GTST_OABLF = 0x40000000
	// No simultaneous generation of 0 both for the GTIOCA and GTIOCB pins has occurred.
	GPT164_GTST_OABLF_0 = 0x0
	// A simultaneous generation of 0 both for the GTIOCA and GTIOCB pins has occurred.
	GPT164_GTST_OABLF_1 = 0x1

	// GTBER: General PWM Timer Buffer Enable Register
	// Position of BD0 field.
	GPT164_GTBER_BD0_Pos = 0x0
	// Bit mask of BD0 field.
	GPT164_GTBER_BD0_Msk = 0x1
	// Bit BD0.
	GPT164_GTBER_BD0 = 0x1
	// Buffer operation is enabled
	GPT164_GTBER_BD0_0 = 0x0
	// Buffer operation is disabled
	GPT164_GTBER_BD0_1 = 0x1
	// Position of BD1 field.
	GPT164_GTBER_BD1_Pos = 0x1
	// Bit mask of BD1 field.
	GPT164_GTBER_BD1_Msk = 0x2
	// Bit BD1.
	GPT164_GTBER_BD1 = 0x2
	// Buffer operation is enabled
	GPT164_GTBER_BD1_0 = 0x0
	// Buffer operation is disabled
	GPT164_GTBER_BD1_1 = 0x1
	// Position of CCRA field.
	GPT164_GTBER_CCRA_Pos = 0x10
	// Bit mask of CCRA field.
	GPT164_GTBER_CCRA_Msk = 0x30000
	// No buffer operation
	GPT164_GTBER_CCRA_00 = 0x0
	// Single buffer operation (GTCCRA <---->GTCCRC)
	GPT164_GTBER_CCRA_01 = 0x1
	// Position of CCRB field.
	GPT164_GTBER_CCRB_Pos = 0x12
	// Bit mask of CCRB field.
	GPT164_GTBER_CCRB_Msk = 0xc0000
	// No buffer operation
	GPT164_GTBER_CCRB_00 = 0x0
	// Single buffer operation (GTCCRB <----> GTCCRE)
	GPT164_GTBER_CCRB_01 = 0x1
	// Position of PR field.
	GPT164_GTBER_PR_Pos = 0x14
	// Bit mask of PR field.
	GPT164_GTBER_PR_Msk = 0x300000
	// No buffer operation
	GPT164_GTBER_PR_00 = 0x0
	// Single buffer operation (GTPBR --> GTPR)
	GPT164_GTBER_PR_01 = 0x1
	// Position of CCRSWT field.
	GPT164_GTBER_CCRSWT_Pos = 0x16
	// Bit mask of CCRSWT field.
	GPT164_GTBER_CCRSWT_Msk = 0x400000
	// Bit CCRSWT.
	GPT164_GTBER_CCRSWT = 0x400000

	// GTDTCR: General PWM Timer Dead Time Control Register
	// Position of TDE field.
	GPT164_GTDTCR_TDE_Pos = 0x0
	// Bit mask of TDE field.
	GPT164_GTDTCR_TDE_Msk = 0x1
	// Bit TDE.
	GPT164_GTDTCR_TDE = 0x1
	// GTCCRB is set without using GTDVU
	GPT164_GTDTCR_TDE_0 = 0x0
	// GTDVU is used to set the compare match value for negative-phase waveform with dead time automatically in GTCCRB
	GPT164_GTDTCR_TDE_1 = 0x1
)

// Constants for GPT_OPS: Output Phase Switching Controller
const (
	// OPSCR: Output Phase Switching Control Register
	// Position of UF field.
	GPT_OPS_OPSCR_UF_Pos = 0x0
	// Bit mask of UF field.
	GPT_OPS_OPSCR_UF_Msk = 0x1
	// Bit UF.
	GPT_OPS_OPSCR_UF = 0x1
	// Position of VF field.
	GPT_OPS_OPSCR_VF_Pos = 0x1
	// Bit mask of VF field.
	GPT_OPS_OPSCR_VF_Msk = 0x2
	// Bit VF.
	GPT_OPS_OPSCR_VF = 0x2
	// Position of WF field.
	GPT_OPS_OPSCR_WF_Pos = 0x2
	// Bit mask of WF field.
	GPT_OPS_OPSCR_WF_Msk = 0x4
	// Bit WF.
	GPT_OPS_OPSCR_WF = 0x4
	// Position of EN field.
	GPT_OPS_OPSCR_EN_Pos = 0x8
	// Bit mask of EN field.
	GPT_OPS_OPSCR_EN_Msk = 0x100
	// Bit EN.
	GPT_OPS_OPSCR_EN = 0x100
	// Do not output (Hi-Z external pin)
	GPT_OPS_OPSCR_EN_0 = 0x0
	// Output
	GPT_OPS_OPSCR_EN_1 = 0x1
	// Position of FB field.
	GPT_OPS_OPSCR_FB_Pos = 0x10
	// Bit mask of FB field.
	GPT_OPS_OPSCR_FB_Msk = 0x10000
	// Bit FB.
	GPT_OPS_OPSCR_FB = 0x10000
	// Do not use
	GPT_OPS_OPSCR_FB_0 = 0x0
	// Select the soft setting (OPSCR.UF, VF, WF)
	GPT_OPS_OPSCR_FB_1 = 0x1
	// Position of P field.
	GPT_OPS_OPSCR_P_Pos = 0x11
	// Bit mask of P field.
	GPT_OPS_OPSCR_P_Msk = 0x20000
	// Bit P.
	GPT_OPS_OPSCR_P = 0x20000
	// Level signal output
	GPT_OPS_OPSCR_P_0 = 0x0
	// PWM signal output
	GPT_OPS_OPSCR_P_1 = 0x1
	// Position of N field.
	GPT_OPS_OPSCR_N_Pos = 0x12
	// Bit mask of N field.
	GPT_OPS_OPSCR_N_Msk = 0x40000
	// Bit N.
	GPT_OPS_OPSCR_N = 0x40000
	// Level signal output
	GPT_OPS_OPSCR_N_0 = 0x0
	// PWM signal output
	GPT_OPS_OPSCR_N_1 = 0x1
	// Position of INV field.
	GPT_OPS_OPSCR_INV_Pos = 0x13
	// Bit mask of INV field.
	GPT_OPS_OPSCR_INV_Msk = 0x80000
	// Bit INV.
	GPT_OPS_OPSCR_INV = 0x80000
	// Positive logic (active-high) output
	GPT_OPS_OPSCR_INV_0 = 0x0
	// Negative logic (active-low) output
	GPT_OPS_OPSCR_INV_1 = 0x1
	// Position of RV field.
	GPT_OPS_OPSCR_RV_Pos = 0x14
	// Bit mask of RV field.
	GPT_OPS_OPSCR_RV_Msk = 0x100000
	// Bit RV.
	GPT_OPS_OPSCR_RV = 0x100000
	// Positive rotation
	GPT_OPS_OPSCR_RV_0 = 0x0
	// Reverse rotation
	GPT_OPS_OPSCR_RV_1 = 0x1
	// Position of ALIGN field.
	GPT_OPS_OPSCR_ALIGN_Pos = 0x15
	// Bit mask of ALIGN field.
	GPT_OPS_OPSCR_ALIGN_Msk = 0x200000
	// Bit ALIGN.
	GPT_OPS_OPSCR_ALIGN = 0x200000
	// Input phase aligned to PCLKD
	GPT_OPS_OPSCR_ALIGN_0 = 0x0
	// Input phase aligned to the falling edge of PWM
	GPT_OPS_OPSCR_ALIGN_1 = 0x1
	// Position of GRP field.
	GPT_OPS_OPSCR_GRP_Pos = 0x18
	// Bit mask of GRP field.
	GPT_OPS_OPSCR_GRP_Msk = 0x3000000
	// Position of GODF field.
	GPT_OPS_OPSCR_GODF_Pos = 0x1a
	// Bit mask of GODF field.
	GPT_OPS_OPSCR_GODF_Msk = 0x4000000
	// Bit GODF.
	GPT_OPS_OPSCR_GODF = 0x4000000
	// This bit function is ignored
	GPT_OPS_OPSCR_GODF_0 = 0x0
	// Group disable clears the OPSCR.EN bit
	GPT_OPS_OPSCR_GODF_1 = 0x1
	// Position of NFEN field.
	GPT_OPS_OPSCR_NFEN_Pos = 0x1d
	// Bit mask of NFEN field.
	GPT_OPS_OPSCR_NFEN_Msk = 0x20000000
	// Bit NFEN.
	GPT_OPS_OPSCR_NFEN = 0x20000000
	// Do not use a noise filter on the external input
	GPT_OPS_OPSCR_NFEN_0 = 0x0
	// Use a noise filter on the external input
	GPT_OPS_OPSCR_NFEN_1 = 0x1
	// Position of NFCS field.
	GPT_OPS_OPSCR_NFCS_Pos = 0x1e
	// Bit mask of NFCS field.
	GPT_OPS_OPSCR_NFCS_Msk = 0xc0000000
	// PCLKD/1
	GPT_OPS_OPSCR_NFCS_00 = 0x0
	// PCLKD/4
	GPT_OPS_OPSCR_NFCS_01 = 0x1
	// PCLKD/16
	GPT_OPS_OPSCR_NFCS_10 = 0x2
	// PCLKD/64
	GPT_OPS_OPSCR_NFCS_11 = 0x3
)

// Constants for KINT: Key Interrupt Function
const (
	// KRCTL: Key Return Control Register
	// Position of KREG field.
	KINT_KRCTL_KREG_Pos = 0x0
	// Bit mask of KREG field.
	KINT_KRCTL_KREG_Msk = 0x1
	// Bit KREG.
	KINT_KRCTL_KREG = 0x1
	// Falling edge
	KINT_KRCTL_KREG_0 = 0x0
	// Rising edge
	KINT_KRCTL_KREG_1 = 0x1
	// Position of KRMD field.
	KINT_KRCTL_KRMD_Pos = 0x7
	// Bit mask of KRMD field.
	KINT_KRCTL_KRMD_Msk = 0x80
	// Bit KRMD.
	KINT_KRCTL_KRMD = 0x80
	// Do not use key interrupt flags
	KINT_KRCTL_KRMD_0 = 0x0
	// Use key interrupt flags
	KINT_KRCTL_KRMD_1 = 0x1

	// KRF: Key Return Flag Register
	// Position of KIF0 field.
	KINT_KRF_KIF0_Pos = 0x0
	// Bit mask of KIF0 field.
	KINT_KRF_KIF0_Msk = 0x1
	// Bit KIF0.
	KINT_KRF_KIF0 = 0x1
	// No interrupt detected
	KINT_KRF_KIF0_0 = 0x0
	// Interrupt detected
	KINT_KRF_KIF0_1 = 0x1
	// Position of KIF1 field.
	KINT_KRF_KIF1_Pos = 0x1
	// Bit mask of KIF1 field.
	KINT_KRF_KIF1_Msk = 0x2
	// Bit KIF1.
	KINT_KRF_KIF1 = 0x2
	// No interrupt detected
	KINT_KRF_KIF1_0 = 0x0
	// Interrupt detected
	KINT_KRF_KIF1_1 = 0x1
	// Position of KIF2 field.
	KINT_KRF_KIF2_Pos = 0x2
	// Bit mask of KIF2 field.
	KINT_KRF_KIF2_Msk = 0x4
	// Bit KIF2.
	KINT_KRF_KIF2 = 0x4
	// No interrupt detected
	KINT_KRF_KIF2_0 = 0x0
	// Interrupt detected
	KINT_KRF_KIF2_1 = 0x1
	// Position of KIF3 field.
	KINT_KRF_KIF3_Pos = 0x3
	// Bit mask of KIF3 field.
	KINT_KRF_KIF3_Msk = 0x8
	// Bit KIF3.
	KINT_KRF_KIF3 = 0x8
	// No interrupt detected
	KINT_KRF_KIF3_0 = 0x0
	// Interrupt detected
	KINT_KRF_KIF3_1 = 0x1

	// KRM: Key Return Mode Register
	// Position of KIMC0 field.
	KINT_KRM_KIMC0_Pos = 0x0
	// Bit mask of KIMC0 field.
	KINT_KRM_KIMC0_Msk = 0x1
	// Bit KIMC0.
	KINT_KRM_KIMC0 = 0x1
	// Do not detect key interrupt signals
	KINT_KRM_KIMC0_0 = 0x0
	// Detect key interrupt signals
	KINT_KRM_KIMC0_1 = 0x1
	// Position of KIMC1 field.
	KINT_KRM_KIMC1_Pos = 0x1
	// Bit mask of KIMC1 field.
	KINT_KRM_KIMC1_Msk = 0x2
	// Bit KIMC1.
	KINT_KRM_KIMC1 = 0x2
	// Do not detect key interrupt signals
	KINT_KRM_KIMC1_0 = 0x0
	// Detect key interrupt signals
	KINT_KRM_KIMC1_1 = 0x1
	// Position of KIMC2 field.
	KINT_KRM_KIMC2_Pos = 0x2
	// Bit mask of KIMC2 field.
	KINT_KRM_KIMC2_Msk = 0x4
	// Bit KIMC2.
	KINT_KRM_KIMC2 = 0x4
	// Do not detect key interrupt signals
	KINT_KRM_KIMC2_0 = 0x0
	// Detect key interrupt signals
	KINT_KRM_KIMC2_1 = 0x1
	// Position of KIMC3 field.
	KINT_KRM_KIMC3_Pos = 0x3
	// Bit mask of KIMC3 field.
	KINT_KRM_KIMC3_Msk = 0x8
	// Bit KIMC3.
	KINT_KRM_KIMC3 = 0x8
	// Do not detect key interrupt signals
	KINT_KRM_KIMC3_0 = 0x0
	// Detect key interrupt signals
	KINT_KRM_KIMC3_1 = 0x1
)

// Constants for I3C: I3C Bus Interface
const (
	// PRTS: Protocol Selection Register
	// Position of PRTMD field.
	I3C_PRTS_PRTMD_Pos = 0x0
	// Bit mask of PRTMD field.
	I3C_PRTS_PRTMD_Msk = 0x1
	// Bit PRTMD.
	I3C_PRTS_PRTMD = 0x1
	// I3C protocol mode
	I3C_PRTS_PRTMD_0 = 0x0
	// I2C protocol mode
	I3C_PRTS_PRTMD_1 = 0x1

	// BCTL: Bus Control Register
	// Position of INCBA field.
	I3C_BCTL_INCBA_Pos = 0x0
	// Bit mask of INCBA field.
	I3C_BCTL_INCBA_Msk = 0x1
	// Bit INCBA.
	I3C_BCTL_INCBA = 0x1
	// Do not include I3C broadcast address for private transfers
	I3C_BCTL_INCBA_0 = 0x0
	// Include I3C broadcast address for private transfers
	I3C_BCTL_INCBA_1 = 0x1
	// Position of HJACKCTL field.
	I3C_BCTL_HJACKCTL_Pos = 0x8
	// Bit mask of HJACKCTL field.
	I3C_BCTL_HJACKCTL_Msk = 0x100
	// Bit HJACKCTL.
	I3C_BCTL_HJACKCTL = 0x100
	// ACK the Hot-Join request
	I3C_BCTL_HJACKCTL_0 = 0x0
	// NACK and send broadcast CCC to disable Hot-Join
	I3C_BCTL_HJACKCTL_1 = 0x1
	// Position of ABT field.
	I3C_BCTL_ABT_Pos = 0x1d
	// Bit mask of ABT field.
	I3C_BCTL_ABT_Msk = 0x20000000
	// Bit ABT.
	I3C_BCTL_ABT = 0x20000000
	// I3C is running.
	I3C_BCTL_ABT_0 = 0x0
	// I3C has aborted a transfer.
	I3C_BCTL_ABT_1 = 0x1
	// Position of RSM field.
	I3C_BCTL_RSM_Pos = 0x1e
	// Bit mask of RSM field.
	I3C_BCTL_RSM_Msk = 0x40000000
	// Bit RSM.
	I3C_BCTL_RSM = 0x40000000
	// I3C is running.
	I3C_BCTL_RSM_0 = 0x0
	// I3C is suspended (RW1C).
	I3C_BCTL_RSM_1 = 0x1
	// Position of BUSE field.
	I3C_BCTL_BUSE_Pos = 0x1f
	// Bit mask of BUSE field.
	I3C_BCTL_BUSE_Msk = 0x80000000
	// Bit BUSE.
	I3C_BCTL_BUSE = 0x80000000
	// I3C bus operation is disabled.
	I3C_BCTL_BUSE_0 = 0x0
	// I3C bus operation is enabled.
	I3C_BCTL_BUSE_1 = 0x1

	// MSDVAD: Master Device Address Register
	// Position of MDYAD field.
	I3C_MSDVAD_MDYAD_Pos = 0x10
	// Bit mask of MDYAD field.
	I3C_MSDVAD_MDYAD_Msk = 0x7f0000
	// Position of MDYADV field.
	I3C_MSDVAD_MDYADV_Pos = 0x1f
	// Bit mask of MDYADV field.
	I3C_MSDVAD_MDYADV_Msk = 0x80000000
	// Bit MDYADV.
	I3C_MSDVAD_MDYADV = 0x80000000
	// The master dynamic address field is not valid.
	I3C_MSDVAD_MDYADV_0 = 0x0
	// The master dynamic address field is valid.
	I3C_MSDVAD_MDYADV_1 = 0x1

	// RSTCTL: Reset Control Register
	// Position of RI3CRST field.
	I3C_RSTCTL_RI3CRST_Pos = 0x0
	// Bit mask of RI3CRST field.
	I3C_RSTCTL_RI3CRST_Msk = 0x1
	// Bit RI3CRST.
	I3C_RSTCTL_RI3CRST = 0x1
	// Release I3C reset.
	I3C_RSTCTL_RI3CRST_0 = 0x0
	// Initiate I3C reset.
	I3C_RSTCTL_RI3CRST_1 = 0x1
	// Position of CMDQRST field.
	I3C_RSTCTL_CMDQRST_Pos = 0x1
	// Bit mask of CMDQRST field.
	I3C_RSTCTL_CMDQRST_Msk = 0x2
	// Bit CMDQRST.
	I3C_RSTCTL_CMDQRST = 0x2
	// The Command Queues in I3C is not flushed.
	I3C_RSTCTL_CMDQRST_0 = 0x0
	// The Command Queues in I3C is flushed.
	I3C_RSTCTL_CMDQRST_1 = 0x1
	// Position of RSPQRST field.
	I3C_RSTCTL_RSPQRST_Pos = 0x2
	// Bit mask of RSPQRST field.
	I3C_RSTCTL_RSPQRST_Msk = 0x4
	// Bit RSPQRST.
	I3C_RSTCTL_RSPQRST = 0x4
	// The Response Queues in I3C is not flushed.
	I3C_RSTCTL_RSPQRST_0 = 0x0
	// The Response Queues in I3C is flushed.
	I3C_RSTCTL_RSPQRST_1 = 0x1
	// Position of TDBRST field.
	I3C_RSTCTL_TDBRST_Pos = 0x3
	// Bit mask of TDBRST field.
	I3C_RSTCTL_TDBRST_Msk = 0x8
	// Bit TDBRST.
	I3C_RSTCTL_TDBRST = 0x8
	// The Transmit Queues in I3C is not flushed.
	I3C_RSTCTL_TDBRST_0 = 0x0
	// The Transmit Queues in I3C is flushed.
	I3C_RSTCTL_TDBRST_1 = 0x1
	// Position of RDBRST field.
	I3C_RSTCTL_RDBRST_Pos = 0x4
	// Bit mask of RDBRST field.
	I3C_RSTCTL_RDBRST_Msk = 0x10
	// Bit RDBRST.
	I3C_RSTCTL_RDBRST = 0x10
	// The Receive Queues in I3C is not flushed.
	I3C_RSTCTL_RDBRST_0 = 0x0
	// The Receive Queues in I3C is flushed.
	I3C_RSTCTL_RDBRST_1 = 0x1
	// Position of IBIQRST field.
	I3C_RSTCTL_IBIQRST_Pos = 0x5
	// Bit mask of IBIQRST field.
	I3C_RSTCTL_IBIQRST_Msk = 0x20
	// Bit IBIQRST.
	I3C_RSTCTL_IBIQRST = 0x20
	// The IBI Queues in I3C is not flushed.
	I3C_RSTCTL_IBIQRST_0 = 0x0
	// The IBI Queues in I3C is flushed.
	I3C_RSTCTL_IBIQRST_1 = 0x1
	// Position of RSQRST field.
	I3C_RSTCTL_RSQRST_Pos = 0x6
	// Bit mask of RSQRST field.
	I3C_RSTCTL_RSQRST_Msk = 0x40
	// Bit RSQRST.
	I3C_RSTCTL_RSQRST = 0x40
	// The Receive Status Queue in I3C is not flushed.
	I3C_RSTCTL_RSQRST_0 = 0x0
	// The Receive Status Queue in I3C is flushed.
	I3C_RSTCTL_RSQRST_1 = 0x1
	// Position of INTLRST field.
	I3C_RSTCTL_INTLRST_Pos = 0x10
	// Bit mask of INTLRST field.
	I3C_RSTCTL_INTLRST_Msk = 0x10000
	// Bit INTLRST.
	I3C_RSTCTL_INTLRST = 0x10000
	// Releases of some registers and internal state.
	I3C_RSTCTL_INTLRST_0 = 0x0
	// Resets of some registers and internal state.
	I3C_RSTCTL_INTLRST_1 = 0x1

	// PRSST: Present State Register
	// Position of CRMS field.
	I3C_PRSST_CRMS_Pos = 0x2
	// Bit mask of CRMS field.
	I3C_PRSST_CRMS_Msk = 0x4
	// Bit CRMS.
	I3C_PRSST_CRMS = 0x4
	// The Master is not the Current Master, and must request and acquire bus ownership before initiating any transfer.
	I3C_PRSST_CRMS_0 = 0x0
	// The Master is the Current Master, and as a result can initiate transfers.
	I3C_PRSST_CRMS_1 = 0x1
	// Position of TRMD field.
	I3C_PRSST_TRMD_Pos = 0x4
	// Bit mask of TRMD field.
	I3C_PRSST_TRMD_Msk = 0x10
	// Bit TRMD.
	I3C_PRSST_TRMD = 0x10
	// Receive mode
	I3C_PRSST_TRMD_0 = 0x0
	// Transmit mode
	I3C_PRSST_TRMD_1 = 0x1
	// Position of PRSSTWP field.
	I3C_PRSST_PRSSTWP_Pos = 0x7
	// Bit mask of PRSSTWP field.
	I3C_PRSST_PRSSTWP_Msk = 0x80
	// Bit PRSSTWP.
	I3C_PRSST_PRSSTWP = 0x80
	// CRMS bit is protected.
	I3C_PRSST_PRSSTWP_0 = 0x0
	// CRMS bit can be written when writing simultaneously with the value of the target bit.
	I3C_PRSST_PRSSTWP_1 = 0x1

	// INST: Internal Status Register
	// Position of INEF field.
	I3C_INST_INEF_Pos = 0xa
	// Bit mask of INEF field.
	I3C_INST_INEF_Msk = 0x400
	// Bit INEF.
	I3C_INST_INEF = 0x400
	// I3C Internal Error has not detected.
	I3C_INST_INEF_0 = 0x0
	// I3C Internal Error has detected.
	I3C_INST_INEF_1 = 0x1

	// INSTE: Internal Status Enable Register
	// Position of INEE field.
	I3C_INSTE_INEE_Pos = 0xa
	// Bit mask of INEE field.
	I3C_INSTE_INEE_Msk = 0x400
	// Bit INEE.
	I3C_INSTE_INEE = 0x400
	// Disable INST.INEF
	I3C_INSTE_INEE_0 = 0x0
	// Enable INST.INEF
	I3C_INSTE_INEE_1 = 0x1

	// INIE: Internal Interrupt Enable Register
	// Position of INEIE field.
	I3C_INIE_INEIE_Pos = 0xa
	// Bit mask of INEIE field.
	I3C_INIE_INEIE_Msk = 0x400
	// Bit INEIE.
	I3C_INIE_INEIE = 0x400
	// Disables Non-recoverable Internal Error Interrupt Signal.
	I3C_INIE_INEIE_0 = 0x0
	// Enables Non-recoverable Internal Error Interrupt Signal.
	I3C_INIE_INEIE_1 = 0x1

	// INSTFC: Internal Status Force Register
	// Position of INEFC field.
	I3C_INSTFC_INEFC_Pos = 0xa
	// Bit mask of INEFC field.
	I3C_INSTFC_INEFC_Msk = 0x400
	// Bit INEFC.
	I3C_INSTFC_INEFC = 0x400
	// Not force a specific interrupt
	I3C_INSTFC_INEFC_0 = 0x0
	// Force a specific interrupt
	I3C_INSTFC_INEFC_1 = 0x1

	// DVCT: Device Characteristic Table Register
	// Position of IDX field.
	I3C_DVCT_IDX_Pos = 0x13
	// Bit mask of IDX field.
	I3C_DVCT_IDX_Msk = 0xf80000

	// IBINCTL: IBI Notify Control Register
	// Position of NRHJCTL field.
	I3C_IBINCTL_NRHJCTL_Pos = 0x0
	// Bit mask of NRHJCTL field.
	I3C_IBINCTL_NRHJCTL_Msk = 0x1
	// Bit NRHJCTL.
	I3C_IBINCTL_NRHJCTL = 0x1
	// Do not pass rejected IBI Status to IBI Queue, if the incoming HotJoin request is NACKed and is autodisabled based on field HJACKCTL of BCTL.
	I3C_IBINCTL_NRHJCTL_0 = 0x0
	// Pass rejected IBI Status to the IBI Queue, if the incoming Hot Join request is NACKed and is autodisabled based on field HJACKCTL of BCTL.
	I3C_IBINCTL_NRHJCTL_1 = 0x1
	// Position of NRMRCTL field.
	I3C_IBINCTL_NRMRCTL_Pos = 0x1
	// Bit mask of NRMRCTL field.
	I3C_IBINCTL_NRMRCTL_Msk = 0x2
	// Bit NRMRCTL.
	I3C_IBINCTL_NRMRCTL = 0x2
	// Do not pass rejected IBI Status to IBI Queue/Ring, if the incoming Master Request is NACKed and is auto-disabled based on DVMRRJ field in relevant DAT entry.
	I3C_IBINCTL_NRMRCTL_0 = 0x0
	// Pass rejected IBI Status to the IBI Queue, if the incoming Master Request is NACKed and is autodisabled based on DVMRRJ field in relevant DAT entry.
	I3C_IBINCTL_NRMRCTL_1 = 0x1
	// Position of NRSIRCTL field.
	I3C_IBINCTL_NRSIRCTL_Pos = 0x3
	// Bit mask of NRSIRCTL field.
	I3C_IBINCTL_NRSIRCTL_Msk = 0x8
	// Bit NRSIRCTL.
	I3C_IBINCTL_NRSIRCTL = 0x8
	// Do not pass rejected IBI Status to the IBI Queue/Rings, if the incoming SIR is NACKed and is auto-disabled based on DVSIRRJ field in relevant DAT entry.
	I3C_IBINCTL_NRSIRCTL_0 = 0x0
	// Pass rejected IBI Status to the IBI Queue/Rings, if the incoming SIR is NACKed and is auto-disabled based on DVSIRRJ field in relevant DAT entry.
	I3C_IBINCTL_NRSIRCTL_1 = 0x1

	// BFCTL: Bus Function Control Register
	// Position of MALE field.
	I3C_BFCTL_MALE_Pos = 0x0
	// Bit mask of MALE field.
	I3C_BFCTL_MALE_Msk = 0x1
	// Bit MALE.
	I3C_BFCTL_MALE = 0x1
	// Master arbitration-lost detection disables. Disables the arbitration-lost detection function and does not clear the CRMS and TRMD bits in PRSST automatically when arbitration is lost.
	I3C_BFCTL_MALE_0 = 0x0
	// Master arbitration-lost detection enables. Enables the arbitration-lost detection function and clears the CRMS and TRMD bits in PRSST automatically when arbitration is lost.
	I3C_BFCTL_MALE_1 = 0x1
	// Position of NALE field.
	I3C_BFCTL_NALE_Pos = 0x1
	// Bit mask of NALE field.
	I3C_BFCTL_NALE_Msk = 0x2
	// Bit NALE.
	I3C_BFCTL_NALE = 0x2
	// NACK transmission arbitration-lost detection disables.
	I3C_BFCTL_NALE_0 = 0x0
	// NACK transmission arbitration-lost detection enables.
	I3C_BFCTL_NALE_1 = 0x1
	// Position of SALE field.
	I3C_BFCTL_SALE_Pos = 0x2
	// Bit mask of SALE field.
	I3C_BFCTL_SALE_Msk = 0x4
	// Bit SALE.
	I3C_BFCTL_SALE = 0x4
	// Slave arbitration-lost detection disables.
	I3C_BFCTL_SALE_0 = 0x0
	// Slave arbitration-lost detection enables.
	I3C_BFCTL_SALE_1 = 0x1
	// Position of SCSYNE field.
	I3C_BFCTL_SCSYNE_Pos = 0x8
	// Bit mask of SCSYNE field.
	I3C_BFCTL_SCSYNE_Msk = 0x100
	// Bit SCSYNE.
	I3C_BFCTL_SCSYNE = 0x100
	// No SCL synchronous circuit uses.
	I3C_BFCTL_SCSYNE_0 = 0x0
	// An SCL synchronous circuit uses.
	I3C_BFCTL_SCSYNE_1 = 0x1
	// Position of SMBS field.
	I3C_BFCTL_SMBS_Pos = 0xc
	// Bit mask of SMBS field.
	I3C_BFCTL_SMBS_Msk = 0x1000
	// Bit SMBS.
	I3C_BFCTL_SMBS = 0x1000
	// The I2C bus select.
	I3C_BFCTL_SMBS_0 = 0x0
	// The SMBus select.
	I3C_BFCTL_SMBS_1 = 0x1
	// Position of FMPE field.
	I3C_BFCTL_FMPE_Pos = 0xe
	// Bit mask of FMPE field.
	I3C_BFCTL_FMPE_Msk = 0x4000
	// Bit FMPE.
	I3C_BFCTL_FMPE = 0x4000
	// No Fm+ slope control circuit uses for the SCLn pin and SDAn pin. (n = 0)
	I3C_BFCTL_FMPE_0 = 0x0
	// An Fm+ slope control circuit uses for the SCLn pin and SDAn pin. (n = 0)
	I3C_BFCTL_FMPE_1 = 0x1
	// Position of HSME field.
	I3C_BFCTL_HSME_Pos = 0xf
	// Bit mask of HSME field.
	I3C_BFCTL_HSME_Msk = 0x8000
	// Bit HSME.
	I3C_BFCTL_HSME = 0x8000
	// Disable High Speed Mode.
	I3C_BFCTL_HSME_0 = 0x0
	// Enable High Speed Mode.
	I3C_BFCTL_HSME_1 = 0x1

	// SVCTL: Slave Control Register
	// Position of GCAE field.
	I3C_SVCTL_GCAE_Pos = 0x0
	// Bit mask of GCAE field.
	I3C_SVCTL_GCAE_Msk = 0x1
	// Bit GCAE.
	I3C_SVCTL_GCAE = 0x1
	// General call address detection disables.
	I3C_SVCTL_GCAE_0 = 0x0
	// General call address detection enables.
	I3C_SVCTL_GCAE_1 = 0x1
	// Position of HSMCE field.
	I3C_SVCTL_HSMCE_Pos = 0x5
	// Bit mask of HSMCE field.
	I3C_SVCTL_HSMCE_Msk = 0x20
	// Bit HSMCE.
	I3C_SVCTL_HSMCE = 0x20
	// Hs-mode Master Code Detection disables.
	I3C_SVCTL_HSMCE_0 = 0x0
	// Hs-mode Master Code Detection enables.
	I3C_SVCTL_HSMCE_1 = 0x1
	// Position of DVIDE field.
	I3C_SVCTL_DVIDE_Pos = 0x6
	// Bit mask of DVIDE field.
	I3C_SVCTL_DVIDE_Msk = 0x40
	// Bit DVIDE.
	I3C_SVCTL_DVIDE = 0x40
	// Device-ID address detection disables.
	I3C_SVCTL_DVIDE_0 = 0x0
	// Device-ID address detection enables.
	I3C_SVCTL_DVIDE_1 = 0x1
	// Position of HOAE field.
	I3C_SVCTL_HOAE_Pos = 0xf
	// Bit mask of HOAE field.
	I3C_SVCTL_HOAE_Msk = 0x8000
	// Bit HOAE.
	I3C_SVCTL_HOAE = 0x8000
	// Host address detection disables.
	I3C_SVCTL_HOAE_0 = 0x0
	// Host address detection enables.
	I3C_SVCTL_HOAE_1 = 0x1
	// Position of SVAE0 field.
	I3C_SVCTL_SVAE0_Pos = 0x10
	// Bit mask of SVAE0 field.
	I3C_SVCTL_SVAE0_Msk = 0x10000
	// Bit SVAE0.
	I3C_SVCTL_SVAE0 = 0x10000
	// Slave 0 disables
	I3C_SVCTL_SVAE0_0 = 0x0
	// Slave 0 enables
	I3C_SVCTL_SVAE0_1 = 0x1

	// REFCKCTL: Reference Clock Control Register
	// Position of IREFCKS field.
	I3C_REFCKCTL_IREFCKS_Pos = 0x0
	// Bit mask of IREFCKS field.
	I3C_REFCKCTL_IREFCKS_Msk = 0x7
	// PCLKD/1 clock
	I3C_REFCKCTL_IREFCKS_000 = 0x0
	// PCLKD/2 clock
	I3C_REFCKCTL_IREFCKS_001 = 0x1
	// PCLKD/4 clock
	I3C_REFCKCTL_IREFCKS_010 = 0x2
	// PCLKD/8 clock
	I3C_REFCKCTL_IREFCKS_011 = 0x3
	// PCLKD/16 clock
	I3C_REFCKCTL_IREFCKS_100 = 0x4
	// PCLKD/32 clock
	I3C_REFCKCTL_IREFCKS_101 = 0x5
	// PCLKD/64 clock
	I3C_REFCKCTL_IREFCKS_110 = 0x6
	// PCLKD/128 clock
	I3C_REFCKCTL_IREFCKS_111 = 0x7

	// STDBR: Standard Bit Rate Register
	// Position of SBRLO field.
	I3C_STDBR_SBRLO_Pos = 0x0
	// Bit mask of SBRLO field.
	I3C_STDBR_SBRLO_Msk = 0xff
	// Position of SBRHO field.
	I3C_STDBR_SBRHO_Pos = 0x8
	// Bit mask of SBRHO field.
	I3C_STDBR_SBRHO_Msk = 0xff00
	// Position of SBRLP field.
	I3C_STDBR_SBRLP_Pos = 0x10
	// Bit mask of SBRLP field.
	I3C_STDBR_SBRLP_Msk = 0x3f0000
	// Position of SBRHP field.
	I3C_STDBR_SBRHP_Pos = 0x18
	// Bit mask of SBRHP field.
	I3C_STDBR_SBRHP_Msk = 0x3f000000
	// Position of DSBRPO field.
	I3C_STDBR_DSBRPO_Pos = 0x1f
	// Bit mask of DSBRPO field.
	I3C_STDBR_DSBRPO_Msk = 0x80000000
	// Bit DSBRPO.
	I3C_STDBR_DSBRPO = 0x80000000
	// The time period set for SBRHO[7:0] and SBRLO[7:0] is not doubled.
	I3C_STDBR_DSBRPO_0 = 0x0
	// The time period set for SBRHO[7:0] and SBRLO[7:0] is doubled.
	I3C_STDBR_DSBRPO_1 = 0x1

	// EXTBR: Extended Bit Rate Register
	// Position of EBRLO field.
	I3C_EXTBR_EBRLO_Pos = 0x0
	// Bit mask of EBRLO field.
	I3C_EXTBR_EBRLO_Msk = 0xff
	// Position of EBRHO field.
	I3C_EXTBR_EBRHO_Pos = 0x8
	// Bit mask of EBRHO field.
	I3C_EXTBR_EBRHO_Msk = 0xff00
	// Position of EBRLP field.
	I3C_EXTBR_EBRLP_Pos = 0x10
	// Bit mask of EBRLP field.
	I3C_EXTBR_EBRLP_Msk = 0x3f0000
	// Position of EBRHP field.
	I3C_EXTBR_EBRHP_Pos = 0x18
	// Bit mask of EBRHP field.
	I3C_EXTBR_EBRHP_Msk = 0x3f000000

	// BFRECDT: Bus Free Condition Detection Time Register
	// Position of FRECYC field.
	I3C_BFRECDT_FRECYC_Pos = 0x0
	// Bit mask of FRECYC field.
	I3C_BFRECDT_FRECYC_Msk = 0x1ff

	// BAVLCDT: Bus Available Condition Detection Time Register
	// Position of AVLCYC field.
	I3C_BAVLCDT_AVLCYC_Pos = 0x0
	// Bit mask of AVLCYC field.
	I3C_BAVLCDT_AVLCYC_Msk = 0x1ff

	// BIDLCDT: Bus Idle Condition Detection Time Register
	// Position of IDLCYC field.
	I3C_BIDLCDT_IDLCYC_Pos = 0x0
	// Bit mask of IDLCYC field.
	I3C_BIDLCDT_IDLCYC_Msk = 0x3ffff

	// OUTCTL: Output Control Register
	// Position of SDOC field.
	I3C_OUTCTL_SDOC_Pos = 0x0
	// Bit mask of SDOC field.
	I3C_OUTCTL_SDOC_Msk = 0x1
	// Bit SDOC.
	I3C_OUTCTL_SDOC = 0x1
	// I3C drives the SDAn pin low.
	I3C_OUTCTL_SDOC_0 = 0x0
	// I3C releases the SDAn pin.
	I3C_OUTCTL_SDOC_1 = 0x1
	// Position of SCOC field.
	I3C_OUTCTL_SCOC_Pos = 0x1
	// Bit mask of SCOC field.
	I3C_OUTCTL_SCOC_Msk = 0x2
	// Bit SCOC.
	I3C_OUTCTL_SCOC = 0x2
	// I3C drives the SCLn pin low.
	I3C_OUTCTL_SCOC_0 = 0x0
	// I3C releases the SCLn pin.
	I3C_OUTCTL_SCOC_1 = 0x1
	// Position of SOCWP field.
	I3C_OUTCTL_SOCWP_Pos = 0x2
	// Bit mask of SOCWP field.
	I3C_OUTCTL_SOCWP_Msk = 0x4
	// Bit SOCWP.
	I3C_OUTCTL_SOCWP = 0x4
	// Bits SCOC and SDOC are protected.
	I3C_OUTCTL_SOCWP_0 = 0x0
	// Bits SCOC and SDOC can be written (When writing simultaneously with the value of the target bit). This bit is read as 0.
	I3C_OUTCTL_SOCWP_1 = 0x1
	// Position of EXCYC field.
	I3C_OUTCTL_EXCYC_Pos = 0x4
	// Bit mask of EXCYC field.
	I3C_OUTCTL_EXCYC_Msk = 0x10
	// Bit EXCYC.
	I3C_OUTCTL_EXCYC = 0x10
	// Does not output an extra SCL clock cycle (default).
	I3C_OUTCTL_EXCYC_0 = 0x0
	// Outputs an extra SCL clock cycle.
	I3C_OUTCTL_EXCYC_1 = 0x1
	// Position of SDOD field.
	I3C_OUTCTL_SDOD_Pos = 0x8
	// Bit mask of SDOD field.
	I3C_OUTCTL_SDOD_Msk = 0x700
	// No output delay
	I3C_OUTCTL_SDOD_000 = 0x0
	// 1 I3Cφ cycle (When OUTCTL.SDODCS = 0 (I3Cφ)) 1 or 2 I3Cφ cycles (When OUTCTL.SDODCS = 1 (I3Cφ/2))
	I3C_OUTCTL_SDOD_001 = 0x1
	// 2 I3Cφ cycles (When OUTCTL.SDODCS = 0 (I3Cφ)) 3 or 4 I3Cφ cycles (When OUTCTL.SDODCS = 1 (I3Cφ/2))
	I3C_OUTCTL_SDOD_010 = 0x2
	// 3 I3Cφ cycles (When OUTCTL.SDODCS = 0 (I3Cφ)) 5 or 6 I3Cφ cycles (When OUTCTL.SDODCS = 1 (I3Cφ/2))
	I3C_OUTCTL_SDOD_011 = 0x3
	// 4 I3Cφ cycles (When OUTCTL.SDODCS = 0 (I3Cφ)) 7 or 8 I3Cφ cycles (When OUTCTL.SDODCS = 1 (I3Cφ/2))
	I3C_OUTCTL_SDOD_100 = 0x4
	// 5 I3Cφ cycles (When OUTCTL.SDODCS = 0 (I3Cφ)) 9 or 10 I3Cφ cycles (When OUTCTL.SDODCS = 1 (I3Cφ/2))
	I3C_OUTCTL_SDOD_101 = 0x5
	// 6 I3Cφ cycles (When OUTCTL.SDODCS = 0 (I3Cφ)) 11 or 12 I3Cφ cycles (When OUTCTL.SDODCS = 1 (I3Cφ/2))
	I3C_OUTCTL_SDOD_110 = 0x6
	// 7 I3Cφ cycles (When OUTCTL.SDODCS = 0 (I3Cφ)) 13 or 14 I3Cφ cycles (When OUTCTL.SDODCS = 1 (I3Cφ/2))
	I3C_OUTCTL_SDOD_111 = 0x7
	// Position of SDODCS field.
	I3C_OUTCTL_SDODCS_Pos = 0xf
	// Bit mask of SDODCS field.
	I3C_OUTCTL_SDODCS_Msk = 0x8000
	// Bit SDODCS.
	I3C_OUTCTL_SDODCS = 0x8000
	// The internal reference clock (I3Cφ) is selected as the clock source of the SDA output delay counter.
	I3C_OUTCTL_SDODCS_0 = 0x0
	// The internal reference clock divided by 2 (I3Cφ/2) is selected as the clock source of the SDA output delay counter.
	I3C_OUTCTL_SDODCS_1 = 0x1

	// INCTL: Input Control Register
	// Position of DNFS field.
	I3C_INCTL_DNFS_Pos = 0x0
	// Bit mask of DNFS field.
	I3C_INCTL_DNFS_Msk = 0xf
	// Position of DNFE field.
	I3C_INCTL_DNFE_Pos = 0x4
	// Bit mask of DNFE field.
	I3C_INCTL_DNFE_Msk = 0x10
	// Bit DNFE.
	I3C_INCTL_DNFE = 0x10
	// No digital noise filter circuit is used.
	I3C_INCTL_DNFE_0 = 0x0
	// A digital noise filter circuit is used.
	I3C_INCTL_DNFE_1 = 0x1

	// TMOCTL: Timeout Control Register
	// Position of TODTS field.
	I3C_TMOCTL_TODTS_Pos = 0x0
	// Bit mask of TODTS field.
	I3C_TMOCTL_TODTS_Msk = 0x3
	// 16bit-timeout
	I3C_TMOCTL_TODTS_00 = 0x0
	// 14bit-timeout
	I3C_TMOCTL_TODTS_01 = 0x1
	// 8bit-timeout
	I3C_TMOCTL_TODTS_10 = 0x2
	// 6bit-timeout
	I3C_TMOCTL_TODTS_11 = 0x3
	// Position of TOLCTL field.
	I3C_TMOCTL_TOLCTL_Pos = 0x4
	// Bit mask of TOLCTL field.
	I3C_TMOCTL_TOLCTL_Msk = 0x10
	// Bit TOLCTL.
	I3C_TMOCTL_TOLCTL = 0x10
	// Count is disabled while the SCLn line is at a low level.
	I3C_TMOCTL_TOLCTL_0 = 0x0
	// Count is enabled while the SCLn line is at a low level.
	I3C_TMOCTL_TOLCTL_1 = 0x1
	// Position of TOHCTL field.
	I3C_TMOCTL_TOHCTL_Pos = 0x5
	// Bit mask of TOHCTL field.
	I3C_TMOCTL_TOHCTL_Msk = 0x20
	// Bit TOHCTL.
	I3C_TMOCTL_TOHCTL = 0x20
	// Count is disabled while the SCLn line is at a high level.
	I3C_TMOCTL_TOHCTL_0 = 0x0
	// Count is enabled while the SCLn line is at a high level.
	I3C_TMOCTL_TOHCTL_1 = 0x1
	// Position of TOMDS field.
	I3C_TMOCTL_TOMDS_Pos = 0x6
	// Bit mask of TOMDS field.
	I3C_TMOCTL_TOMDS_Msk = 0xc0
	// Timeout is detected during the following conditions: The bus is busy (BCST.BFREF = 0) in master mode.I3C’s own slave address is detected and the bus is busy in slave mode.The bus is free (BCST.BFREF = 1) while generation of a START condition is requested (CNDCTL.STCND = 1).
	I3C_TMOCTL_TOMDS_00 = 0x0
	// Timeout is detected while the bus is busy.
	I3C_TMOCTL_TOMDS_01 = 0x1
	// Timeout is detected while the bus is free.
	I3C_TMOCTL_TOMDS_10 = 0x2
	// Setting prohibited
	I3C_TMOCTL_TOMDS_11 = 0x3

	// ACKCTL: Acknowledge Control Register
	// Position of ACKR field.
	I3C_ACKCTL_ACKR_Pos = 0x0
	// Bit mask of ACKR field.
	I3C_ACKCTL_ACKR_Msk = 0x1
	// Bit ACKR.
	I3C_ACKCTL_ACKR = 0x1
	// A 0 is received as the acknowledge bit (ACK reception).
	I3C_ACKCTL_ACKR_0 = 0x0
	// A 1 is received as the acknowledge bit (NACK reception).
	I3C_ACKCTL_ACKR_1 = 0x1
	// Position of ACKT field.
	I3C_ACKCTL_ACKT_Pos = 0x1
	// Bit mask of ACKT field.
	I3C_ACKCTL_ACKT_Msk = 0x2
	// Bit ACKT.
	I3C_ACKCTL_ACKT = 0x2
	// A 0 is sent as the acknowledge bit (ACK transmission).
	I3C_ACKCTL_ACKT_0 = 0x0
	// A 1 is sent as the acknowledge bit (NACK transmission).
	I3C_ACKCTL_ACKT_1 = 0x1
	// Position of ACKTWP field.
	I3C_ACKCTL_ACKTWP_Pos = 0x2
	// Bit mask of ACKTWP field.
	I3C_ACKCTL_ACKTWP_Msk = 0x4
	// Bit ACKTWP.
	I3C_ACKCTL_ACKTWP = 0x4
	// The ACKT bit are protected.
	I3C_ACKCTL_ACKTWP_0 = 0x0
	// The ACKT bit can be written (when writing simultaneously with the value of the target bit). This bit is read as 0.
	I3C_ACKCTL_ACKTWP_1 = 0x1

	// SCSTRCTL: SCL Stretch Control Register
	// Position of ACKTWE field.
	I3C_SCSTRCTL_ACKTWE_Pos = 0x0
	// Bit mask of ACKTWE field.
	I3C_SCSTRCTL_ACKTWE_Msk = 0x1
	// Bit ACKTWE.
	I3C_SCSTRCTL_ACKTWE = 0x1
	// NTST.RDBFF0 is set at the rising edge of the ninth SCL clock cycle. (The SCLn line is not held low at the falling edge of the eighth clock cycle.)
	I3C_SCSTRCTL_ACKTWE_0 = 0x0
	// NTST.RDBFF0 is set at the rising edge of the eighth SCL clock cycle. (The SCLn line is held low at the falling edge of the eighth clock cycle.) Low-hold is released by writing a value to the ACKCTL.ACKT bit.
	I3C_SCSTRCTL_ACKTWE_1 = 0x1
	// Position of RWE field.
	I3C_SCSTRCTL_RWE_Pos = 0x1
	// Bit mask of RWE field.
	I3C_SCSTRCTL_RWE_Msk = 0x2
	// Bit RWE.
	I3C_SCSTRCTL_RWE = 0x2
	// No WAIT (The period between ninth clock cycle and first clock cycle is not held low.)
	I3C_SCSTRCTL_RWE_0 = 0x0
	// WAIT (The period between ninth clock cycle and first clock cycle is held low.) Low-hold is released by reading NTDTBP0.
	I3C_SCSTRCTL_RWE_1 = 0x1

	// SCSTLCTL: SCL Stalling Control Register
	// Position of STLCYC field.
	I3C_SCSTLCTL_STLCYC_Pos = 0x0
	// Bit mask of STLCYC field.
	I3C_SCSTLCTL_STLCYC_Msk = 0xffff
	// Position of AAPE field.
	I3C_SCSTLCTL_AAPE_Pos = 0x1c
	// Bit mask of AAPE field.
	I3C_SCSTLCTL_AAPE_Msk = 0x10000000
	// Bit AAPE.
	I3C_SCSTLCTL_AAPE = 0x10000000
	// Does not stall the SCL clock during the address assignment phase.
	I3C_SCSTLCTL_AAPE_0 = 0x0
	// Stall the SCL clock during address assignment phase.
	I3C_SCSTLCTL_AAPE_1 = 0x1
	// Position of TRAPE field.
	I3C_SCSTLCTL_TRAPE_Pos = 0x1d
	// Bit mask of TRAPE field.
	I3C_SCSTLCTL_TRAPE_Msk = 0x20000000
	// Bit TRAPE.
	I3C_SCSTLCTL_TRAPE = 0x20000000
	// Does not stall the SCL clock during the transition bit in read transfer.
	I3C_SCSTLCTL_TRAPE_0 = 0x0
	// Stall the SCL clock during the transition bit in read transfer.
	I3C_SCSTLCTL_TRAPE_1 = 0x1
	// Position of PARPE field.
	I3C_SCSTLCTL_PARPE_Pos = 0x1e
	// Bit mask of PARPE field.
	I3C_SCSTLCTL_PARPE_Msk = 0x40000000
	// Bit PARPE.
	I3C_SCSTLCTL_PARPE = 0x40000000
	// Does not stall the SCL clock during the parity bit period.
	I3C_SCSTLCTL_PARPE_0 = 0x0
	// Stall the SCL clock during the parity bit period.
	I3C_SCSTLCTL_PARPE_1 = 0x1
	// Position of ACKPE field.
	I3C_SCSTLCTL_ACKPE_Pos = 0x1f
	// Bit mask of ACKPE field.
	I3C_SCSTLCTL_ACKPE_Msk = 0x80000000
	// Bit ACKPE.
	I3C_SCSTLCTL_ACKPE = 0x80000000
	// Does not stall the SCL clock during the ACK/NACK phase.
	I3C_SCSTLCTL_ACKPE_0 = 0x0
	// Stall the SCL clock during the ACK/NACK phase.
	I3C_SCSTLCTL_ACKPE_1 = 0x1

	// SVTDLG0: Slave Transfer Data Length Register 0
	// Position of STDLG field.
	I3C_SVTDLG0_STDLG_Pos = 0x10
	// Bit mask of STDLG field.
	I3C_SVTDLG0_STDLG_Msk = 0xffff0000

	// CNDCTL: Condition Control Register
	// Position of STCND field.
	I3C_CNDCTL_STCND_Pos = 0x0
	// Bit mask of STCND field.
	I3C_CNDCTL_STCND_Msk = 0x1
	// Bit STCND.
	I3C_CNDCTL_STCND = 0x1
	// Does not request to issue a START condition.
	I3C_CNDCTL_STCND_0 = 0x0
	// Requests to issue a START condition.
	I3C_CNDCTL_STCND_1 = 0x1
	// Position of SRCND field.
	I3C_CNDCTL_SRCND_Pos = 0x1
	// Bit mask of SRCND field.
	I3C_CNDCTL_SRCND_Msk = 0x2
	// Bit SRCND.
	I3C_CNDCTL_SRCND = 0x2
	// Does not request to issue a Repeated START condition.
	I3C_CNDCTL_SRCND_0 = 0x0
	// Requests to issue a Repeated START condition.
	I3C_CNDCTL_SRCND_1 = 0x1
	// Position of SPCND field.
	I3C_CNDCTL_SPCND_Pos = 0x2
	// Bit mask of SPCND field.
	I3C_CNDCTL_SPCND_Msk = 0x4
	// Bit SPCND.
	I3C_CNDCTL_SPCND = 0x4
	// Does not request to issue a STOP condition.
	I3C_CNDCTL_SPCND_0 = 0x0
	// Requests to issue a STOP condition.
	I3C_CNDCTL_SPCND_1 = 0x1

	// NQTHCTL: Normal Queue Threshold Control Register
	// Position of CMDQTH field.
	I3C_NQTHCTL_CMDQTH_Pos = 0x0
	// Bit mask of CMDQTH field.
	I3C_NQTHCTL_CMDQTH_Msk = 0xff
	// Interrupt is issued when Command Queue is completely empty.
	I3C_NQTHCTL_CMDQTH_0x00 = 0x0
	// Position of RSPQTH field.
	I3C_NQTHCTL_RSPQTH_Pos = 0x8
	// Bit mask of RSPQTH field.
	I3C_NQTHCTL_RSPQTH_Msk = 0xff00
	// Interrupt is issued when Response Queue contains 1 entry (DWORD).
	I3C_NQTHCTL_RSPQTH_0x00 = 0x0
	// Position of IBIDSSZ field.
	I3C_NQTHCTL_IBIDSSZ_Pos = 0x10
	// Bit mask of IBIDSSZ field.
	I3C_NQTHCTL_IBIDSSZ_Msk = 0xff0000
	// Position of IBIQTH field.
	I3C_NQTHCTL_IBIQTH_Pos = 0x18
	// Bit mask of IBIQTH field.
	I3C_NQTHCTL_IBIQTH_Msk = 0xff000000
	// I3C Protocol mode (Master): Interrupt is generated when the Outstanding IBI Status count is 1 or more. I3C Protocol mode (Slave): Interrupt is issued when IBI Data Buffer is completely empty.
	I3C_NQTHCTL_IBIQTH_0x00 = 0x0

	// NTBTHCTL0: Normal Transfer Data Buffer Threshold Control Register 0
	// Position of TXDBTH field.
	I3C_NTBTHCTL0_TXDBTH_Pos = 0x0
	// Bit mask of TXDBTH field.
	I3C_NTBTHCTL0_TXDBTH_Msk = 0x7
	// Interrupt triggers at 2 Tx Buffer empties, DWORDs
	I3C_NTBTHCTL0_TXDBTH_000 = 0x0
	// Reserved
	I3C_NTBTHCTL0_TXDBTH_001 = 0x1
	// Position of RXDBTH field.
	I3C_NTBTHCTL0_RXDBTH_Pos = 0x8
	// Bit mask of RXDBTH field.
	I3C_NTBTHCTL0_RXDBTH_Msk = 0x700
	// Interrupt triggers at 2 Rx Buffer entries, DWORDs
	I3C_NTBTHCTL0_RXDBTH_000 = 0x0
	// Reserved
	I3C_NTBTHCTL0_RXDBTH_001 = 0x1
	// Position of TXSTTH field.
	I3C_NTBTHCTL0_TXSTTH_Pos = 0x10
	// Bit mask of TXSTTH field.
	I3C_NTBTHCTL0_TXSTTH_Msk = 0x70000
	// Wait for 2 DWORDs
	I3C_NTBTHCTL0_TXSTTH_000 = 0x0
	// Reserved
	I3C_NTBTHCTL0_TXSTTH_001 = 0x1
	// Position of RXSTTH field.
	I3C_NTBTHCTL0_RXSTTH_Pos = 0x18
	// Bit mask of RXSTTH field.
	I3C_NTBTHCTL0_RXSTTH_Msk = 0x7000000
	// Wait for 2 empty DWORDs
	I3C_NTBTHCTL0_RXSTTH_000 = 0x0
	// Reserved
	I3C_NTBTHCTL0_RXSTTH_001 = 0x1

	// NRQTHCTL: Normal Receive Status Queue Threshold Control Register
	// Position of RSQTH field.
	I3C_NRQTHCTL_RSQTH_Pos = 0x0
	// Bit mask of RSQTH field.
	I3C_NRQTHCTL_RSQTH_Msk = 0xff
	// Interrupt is issued when Receive Status Queue contains 1 entry (DWORD).
	I3C_NRQTHCTL_RSQTH_0x00 = 0x0

	// BST: Bus Status Register
	// Position of STCNDDF field.
	I3C_BST_STCNDDF_Pos = 0x0
	// Bit mask of STCNDDF field.
	I3C_BST_STCNDDF_Msk = 0x1
	// Bit STCNDDF.
	I3C_BST_STCNDDF = 0x1
	// START condition is not detected.
	I3C_BST_STCNDDF_0 = 0x0
	// START condition is detected.
	I3C_BST_STCNDDF_1 = 0x1
	// Position of SPCNDDF field.
	I3C_BST_SPCNDDF_Pos = 0x1
	// Bit mask of SPCNDDF field.
	I3C_BST_SPCNDDF_Msk = 0x2
	// Bit SPCNDDF.
	I3C_BST_SPCNDDF = 0x2
	// STOP condition is not detected.
	I3C_BST_SPCNDDF_0 = 0x0
	// STOP condition is detected.
	I3C_BST_SPCNDDF_1 = 0x1
	// Position of HDREXDF field.
	I3C_BST_HDREXDF_Pos = 0x2
	// Bit mask of HDREXDF field.
	I3C_BST_HDREXDF_Msk = 0x4
	// Bit HDREXDF.
	I3C_BST_HDREXDF = 0x4
	// HDR Exit Pattern Detection Interrupt does not occur.
	I3C_BST_HDREXDF_0 = 0x0
	// HDR Exit Pattern Detection Interrupt occurs.
	I3C_BST_HDREXDF_1 = 0x1
	// Position of NACKDF field.
	I3C_BST_NACKDF_Pos = 0x4
	// Bit mask of NACKDF field.
	I3C_BST_NACKDF_Msk = 0x10
	// Bit NACKDF.
	I3C_BST_NACKDF = 0x10
	// NACK is not detected.
	I3C_BST_NACKDF_0 = 0x0
	// NACK is detected.
	I3C_BST_NACKDF_1 = 0x1
	// Position of TENDF field.
	I3C_BST_TENDF_Pos = 0x8
	// Bit mask of TENDF field.
	I3C_BST_TENDF_Msk = 0x100
	// Bit TENDF.
	I3C_BST_TENDF = 0x100
	// Data is being transmitted.
	I3C_BST_TENDF_0 = 0x0
	// Data has been transmitted.
	I3C_BST_TENDF_1 = 0x1
	// Position of ALF field.
	I3C_BST_ALF_Pos = 0x10
	// Bit mask of ALF field.
	I3C_BST_ALF_Msk = 0x10000
	// Bit ALF.
	I3C_BST_ALF = 0x10000
	// Arbitration is not lost
	I3C_BST_ALF_0 = 0x0
	// Arbitration is lost.
	I3C_BST_ALF_1 = 0x1
	// Position of TODF field.
	I3C_BST_TODF_Pos = 0x14
	// Bit mask of TODF field.
	I3C_BST_TODF_Msk = 0x100000
	// Bit TODF.
	I3C_BST_TODF = 0x100000
	// Timeout is not detected.
	I3C_BST_TODF_0 = 0x0
	// Timeout is detected.
	I3C_BST_TODF_1 = 0x1

	// BSTE: Bus Status Enable Register
	// Position of STCNDDE field.
	I3C_BSTE_STCNDDE_Pos = 0x0
	// Bit mask of STCNDDE field.
	I3C_BSTE_STCNDDE_Msk = 0x1
	// Bit STCNDDE.
	I3C_BSTE_STCNDDE = 0x1
	// Disables START condition Detection Interrupt Status logging.
	I3C_BSTE_STCNDDE_0 = 0x0
	// Enables START condition Detection Interrupt Status logging.
	I3C_BSTE_STCNDDE_1 = 0x1
	// Position of SPCNDDE field.
	I3C_BSTE_SPCNDDE_Pos = 0x1
	// Bit mask of SPCNDDE field.
	I3C_BSTE_SPCNDDE_Msk = 0x2
	// Bit SPCNDDE.
	I3C_BSTE_SPCNDDE = 0x2
	// Disables STOP condition Detection Interrupt Status logging.
	I3C_BSTE_SPCNDDE_0 = 0x0
	// Enables STOP condition Detection Interrupt Status logging.
	I3C_BSTE_SPCNDDE_1 = 0x1
	// Position of HDREXDE field.
	I3C_BSTE_HDREXDE_Pos = 0x2
	// Bit mask of HDREXDE field.
	I3C_BSTE_HDREXDE_Msk = 0x4
	// Bit HDREXDE.
	I3C_BSTE_HDREXDE = 0x4
	// Disables HDR Exit Pattern Detection Interrupt Status logging.
	I3C_BSTE_HDREXDE_0 = 0x0
	// Enables HDR Exit Pattern Detection Interrupt Status logging.
	I3C_BSTE_HDREXDE_1 = 0x1
	// Position of NACKDE field.
	I3C_BSTE_NACKDE_Pos = 0x4
	// Bit mask of NACKDE field.
	I3C_BSTE_NACKDE_Msk = 0x10
	// Bit NACKDE.
	I3C_BSTE_NACKDE = 0x10
	// Disables NACK Detection Interrupt Status logging.
	I3C_BSTE_NACKDE_0 = 0x0
	// Enables NACK Detection Interrupt Status logging.
	I3C_BSTE_NACKDE_1 = 0x1
	// Position of TENDE field.
	I3C_BSTE_TENDE_Pos = 0x8
	// Bit mask of TENDE field.
	I3C_BSTE_TENDE_Msk = 0x100
	// Bit TENDE.
	I3C_BSTE_TENDE = 0x100
	// Disables Transmit End Interrupt Status logging.
	I3C_BSTE_TENDE_0 = 0x0
	// Enables Transmit End Interrupt Status logging.
	I3C_BSTE_TENDE_1 = 0x1
	// Position of ALE field.
	I3C_BSTE_ALE_Pos = 0x10
	// Bit mask of ALE field.
	I3C_BSTE_ALE_Msk = 0x10000
	// Bit ALE.
	I3C_BSTE_ALE = 0x10000
	// Disables Arbitration Lost Interrupt Status logging.
	I3C_BSTE_ALE_0 = 0x0
	// Enables Arbitration Lost Interrupt Status logging.
	I3C_BSTE_ALE_1 = 0x1
	// Position of TODE field.
	I3C_BSTE_TODE_Pos = 0x14
	// Bit mask of TODE field.
	I3C_BSTE_TODE_Msk = 0x100000
	// Bit TODE.
	I3C_BSTE_TODE = 0x100000
	// Disables Timeout Detection Interrupt Status logging.
	I3C_BSTE_TODE_0 = 0x0
	// Enables Timeout Detection Interrupt Status logging.
	I3C_BSTE_TODE_1 = 0x1

	// BIE: Bus Interrupt Enable Register
	// Position of STCNDDIE field.
	I3C_BIE_STCNDDIE_Pos = 0x0
	// Bit mask of STCNDDIE field.
	I3C_BIE_STCNDDIE_Msk = 0x1
	// Bit STCNDDIE.
	I3C_BIE_STCNDDIE = 0x1
	// Disables START condition Detection Interrupt Signal.
	I3C_BIE_STCNDDIE_0 = 0x0
	// Enables START condition Detection Interrupt Signal.
	I3C_BIE_STCNDDIE_1 = 0x1
	// Position of SPCNDDIE field.
	I3C_BIE_SPCNDDIE_Pos = 0x1
	// Bit mask of SPCNDDIE field.
	I3C_BIE_SPCNDDIE_Msk = 0x2
	// Bit SPCNDDIE.
	I3C_BIE_SPCNDDIE = 0x2
	// Disables STOP condition Detection Interrupt Signal.
	I3C_BIE_SPCNDDIE_0 = 0x0
	// Enables STOP condition Detection Interrupt Signal.
	I3C_BIE_SPCNDDIE_1 = 0x1
	// Position of HDREXDIE field.
	I3C_BIE_HDREXDIE_Pos = 0x2
	// Bit mask of HDREXDIE field.
	I3C_BIE_HDREXDIE_Msk = 0x4
	// Bit HDREXDIE.
	I3C_BIE_HDREXDIE = 0x4
	// Disables HDR Exit Pattern Detection Interrupt Signal.
	I3C_BIE_HDREXDIE_0 = 0x0
	// Enables HDR Exit Pattern Detection Interrupt Signal.
	I3C_BIE_HDREXDIE_1 = 0x1
	// Position of NACKDIE field.
	I3C_BIE_NACKDIE_Pos = 0x4
	// Bit mask of NACKDIE field.
	I3C_BIE_NACKDIE_Msk = 0x10
	// Bit NACKDIE.
	I3C_BIE_NACKDIE = 0x10
	// Disables NACK Detection Interrupt Signal.
	I3C_BIE_NACKDIE_0 = 0x0
	// Enables NACK Detection Interrupt Signal.
	I3C_BIE_NACKDIE_1 = 0x1
	// Position of TENDIE field.
	I3C_BIE_TENDIE_Pos = 0x8
	// Bit mask of TENDIE field.
	I3C_BIE_TENDIE_Msk = 0x100
	// Bit TENDIE.
	I3C_BIE_TENDIE = 0x100
	// Disables Transmit End Interrupt Signal.
	I3C_BIE_TENDIE_0 = 0x0
	// Enables Transmit End Interrupt Signal.
	I3C_BIE_TENDIE_1 = 0x1
	// Position of ALIE field.
	I3C_BIE_ALIE_Pos = 0x10
	// Bit mask of ALIE field.
	I3C_BIE_ALIE_Msk = 0x10000
	// Bit ALIE.
	I3C_BIE_ALIE = 0x10000
	// Disables Arbitration Lost Interrupt Signal.
	I3C_BIE_ALIE_0 = 0x0
	// Enables Arbitration Lost Interrupt Signal.
	I3C_BIE_ALIE_1 = 0x1
	// Position of TODIE field.
	I3C_BIE_TODIE_Pos = 0x14
	// Bit mask of TODIE field.
	I3C_BIE_TODIE_Msk = 0x100000
	// Bit TODIE.
	I3C_BIE_TODIE = 0x100000
	// Disables Timeout Detection Interrupt Signal.
	I3C_BIE_TODIE_0 = 0x0
	// Enables Timeout Detection Interrupt Signal.
	I3C_BIE_TODIE_1 = 0x1

	// BSTFC: Bus Status Force Register
	// Position of STCNDDFC field.
	I3C_BSTFC_STCNDDFC_Pos = 0x0
	// Bit mask of STCNDDFC field.
	I3C_BSTFC_STCNDDFC_Msk = 0x1
	// Bit STCNDDFC.
	I3C_BSTFC_STCNDDFC = 0x1
	// Not Force START condition Detection Interrupt for software testing.
	I3C_BSTFC_STCNDDFC_0 = 0x0
	// Force START condition Detection Interrupt for software testing.
	I3C_BSTFC_STCNDDFC_1 = 0x1
	// Position of SPCNDDFC field.
	I3C_BSTFC_SPCNDDFC_Pos = 0x1
	// Bit mask of SPCNDDFC field.
	I3C_BSTFC_SPCNDDFC_Msk = 0x2
	// Bit SPCNDDFC.
	I3C_BSTFC_SPCNDDFC = 0x2
	// Not Force STOP condition Detection Interrupt for software testing.
	I3C_BSTFC_SPCNDDFC_0 = 0x0
	// Force STOP condition Detection Interrupt for software testing.
	I3C_BSTFC_SPCNDDFC_1 = 0x1
	// Position of HDREXDFC field.
	I3C_BSTFC_HDREXDFC_Pos = 0x2
	// Bit mask of HDREXDFC field.
	I3C_BSTFC_HDREXDFC_Msk = 0x4
	// Bit HDREXDFC.
	I3C_BSTFC_HDREXDFC = 0x4
	// Not Force HDR Exit Pattern Detection Interrupt for software testing.
	I3C_BSTFC_HDREXDFC_0 = 0x0
	// Force HDR Exit Pattern Detection Interrupt for software testing.
	I3C_BSTFC_HDREXDFC_1 = 0x1
	// Position of NACKDFC field.
	I3C_BSTFC_NACKDFC_Pos = 0x4
	// Bit mask of NACKDFC field.
	I3C_BSTFC_NACKDFC_Msk = 0x10
	// Bit NACKDFC.
	I3C_BSTFC_NACKDFC = 0x10
	// Not Force NACK Detection Interrupt for software testing.
	I3C_BSTFC_NACKDFC_0 = 0x0
	// Force NACK Detection Interrupt for software testing.
	I3C_BSTFC_NACKDFC_1 = 0x1
	// Position of TENDFC field.
	I3C_BSTFC_TENDFC_Pos = 0x8
	// Bit mask of TENDFC field.
	I3C_BSTFC_TENDFC_Msk = 0x100
	// Bit TENDFC.
	I3C_BSTFC_TENDFC = 0x100
	// Not Force Transmit End Interrupt for software testing.
	I3C_BSTFC_TENDFC_0 = 0x0
	// Force Transmit End Interrupt for software testing.
	I3C_BSTFC_TENDFC_1 = 0x1
	// Position of ALFC field.
	I3C_BSTFC_ALFC_Pos = 0x10
	// Bit mask of ALFC field.
	I3C_BSTFC_ALFC_Msk = 0x10000
	// Bit ALFC.
	I3C_BSTFC_ALFC = 0x10000
	// Not Force Arbitration Lost Interrupt for software testing.
	I3C_BSTFC_ALFC_0 = 0x0
	// Force Arbitration Lost Interrupt for software testing.
	I3C_BSTFC_ALFC_1 = 0x1
	// Position of TODFC field.
	I3C_BSTFC_TODFC_Pos = 0x14
	// Bit mask of TODFC field.
	I3C_BSTFC_TODFC_Msk = 0x100000
	// Bit TODFC.
	I3C_BSTFC_TODFC = 0x100000
	// Not Force Timeout Detection Interrupt for software testing.
	I3C_BSTFC_TODFC_0 = 0x0
	// Force Timeout Detection Interrupt for software testing.
	I3C_BSTFC_TODFC_1 = 0x1

	// NTST: Normal Transfer Status Register
	// Position of TDBEF0 field.
	I3C_NTST_TDBEF0_Pos = 0x0
	// Bit mask of TDBEF0 field.
	I3C_NTST_TDBEF0_Msk = 0x1
	// Bit TDBEF0.
	I3C_NTST_TDBEF0 = 0x1
	// For I2C protocol mode: PRTS.PRTMD bit = 1. Normal Transmit Data Buffer 0 contains transmit data. For I3C protocol mode: PRTS.PRTMD bit = 0. The number of empties in the Normal Transmit Data Buffer 0 is less than the NTBTHCTL0.TXDBTH[2:0] threshold.
	I3C_NTST_TDBEF0_0 = 0x0
	// For I2C protocol mode: PRTS.PRTMD bit = 1. Normal Transmit Data Buffer 0 contains no transmit data. For I3C protocol mode: PRTS.PRTMD bit = 0. The number of empties in the Normal Transmit Data Buffer 0 is the NTBTHCTL0.TXDBTH[2:0] threshold or more.
	I3C_NTST_TDBEF0_1 = 0x1
	// Position of RDBFF0 field.
	I3C_NTST_RDBFF0_Pos = 0x1
	// Bit mask of RDBFF0 field.
	I3C_NTST_RDBFF0_Msk = 0x2
	// Bit RDBFF0.
	I3C_NTST_RDBFF0 = 0x2
	// For I2C protocol mode: PRTS.PRTMD bit = 1. Normal Receive Data Buffer0 contains no receive data. For I3C Protocol mode: PRTS.PRTMD bit = 0. The number of entries in the Normal Receive Data Buffer 0 is less than the NTBTHCTL0.RXDBTH[2:0] threshold.
	I3C_NTST_RDBFF0_0 = 0x0
	// For I2C protocol mode: PRTS.PRTMD bit = 1. Normal Receive Data Buffer0 contains receive data. For I3C Protocol mode: PRTS.PRTMD bit = 0. The number of entries in the Normal Receive Data Buffer 0 is the NTBTHCTL0.RXDBTH[2:0] threshold or more.
	I3C_NTST_RDBFF0_1 = 0x1
	// Position of IBIQEFF field.
	I3C_NTST_IBIQEFF_Pos = 0x2
	// Bit mask of IBIQEFF field.
	I3C_NTST_IBIQEFF_Msk = 0x4
	// Bit IBIQEFF.
	I3C_NTST_IBIQEFF = 0x4
	// For I3C protocol mode (Master): PRTS.PRTMD bit = 0, PRSST.CRMS bit = 1. The number of IBI Status Queue entries is the NQTHCTL.IBIQTH threshold or less. For I3C protocol mode (Slave) : PRTS.PRTMD bit = 0, PRSST.CRMS bit = 0. If the NQTHCTL.IBIQTH = 0: The number of IBI Data Buffer empties is less than the IBI Data Buffer size. If the NQTHCTL.IBIQTH is other than 0: The number of IBI Data Buffer empties is less than the NQTHCTL.IBIQTH threshold.
	I3C_NTST_IBIQEFF_0 = 0x0
	// For I3C protocol mode (Master): PRTS.PRTMD bit = 0, PRSST.CRMS bit = 1. The number of IBI Status Queue entries is more than the NQTHCTL.IBIQTH threshold. For I3C protocol mode (Slave) : PRTS.PRTMD bit = 0, PRSST.CRMS bit = 0. If the NQTHCTL.IBIQTH = 0: The number of IBI Data Buffer empties is the IBI Data Buffer size. If the NQTHCTL.IBIQTH is other than 0: The number of IBI Data Buffer empties is the NQTHCTL.IBIQTH threshold or more.
	I3C_NTST_IBIQEFF_1 = 0x1
	// Position of CMDQEF field.
	I3C_NTST_CMDQEF_Pos = 0x3
	// Bit mask of CMDQEF field.
	I3C_NTST_CMDQEF_Msk = 0x8
	// Bit CMDQEF.
	I3C_NTST_CMDQEF = 0x8
	// If the NQTHCTL.CMDQTH = 0: The number of Command Queue empties is less than the Command Queue size. If the NQTHCTL.CMDQTH is other than 0: The number of Command Queue empties is less than the NQTHCTL.CMDQTH threshold.
	I3C_NTST_CMDQEF_0 = 0x0
	// If the NQTHCTL.CMDQTH = 0: The number of Command Queue empties is the Command Queue size. If the NQTHCTL.CMDQTH is other than 0: 1: The number of Command Queue empties is the NQTHCTL.CMDQTH threshold or more.
	I3C_NTST_CMDQEF_1 = 0x1
	// Position of RSPQFF field.
	I3C_NTST_RSPQFF_Pos = 0x4
	// Bit mask of RSPQFF field.
	I3C_NTST_RSPQFF_Msk = 0x10
	// Bit RSPQFF.
	I3C_NTST_RSPQFF = 0x10
	// The number of Response Queue entries is the NQTHCTL.RSPQTH threshold or less.
	I3C_NTST_RSPQFF_0 = 0x0
	// The number of Response Queue entries is more than the NQTHCTL.RSPQTH threshold.
	I3C_NTST_RSPQFF_1 = 0x1
	// Position of TABTF field.
	I3C_NTST_TABTF_Pos = 0x5
	// Bit mask of TABTF field.
	I3C_NTST_TABTF_Msk = 0x20
	// Bit TABTF.
	I3C_NTST_TABTF = 0x20
	// Transfer Abort does not occur.
	I3C_NTST_TABTF_0 = 0x0
	// Transfer Abort occur. To clear, write 0 to this bit after 1 state is read.
	I3C_NTST_TABTF_1 = 0x1
	// Position of TEF field.
	I3C_NTST_TEF_Pos = 0x9
	// Bit mask of TEF field.
	I3C_NTST_TEF_Msk = 0x200
	// Bit TEF.
	I3C_NTST_TEF = 0x200
	// Transfer Error does not occur.
	I3C_NTST_TEF_0 = 0x0
	// Transfer Error occurs. To clear, write 0 to this bit after 1 state is read.
	I3C_NTST_TEF_1 = 0x1
	// Position of RSQFF field.
	I3C_NTST_RSQFF_Pos = 0x14
	// Bit mask of RSQFF field.
	I3C_NTST_RSQFF_Msk = 0x100000
	// Bit RSQFF.
	I3C_NTST_RSQFF = 0x100000
	// The number of Receive Status Queue entries is the NRQTHCTL.RSQTH threshold or less.
	I3C_NTST_RSQFF_0 = 0x0
	// The number of Receive Status Queue entries is more than the NRQTHCTL.RSQTH threshold.
	I3C_NTST_RSQFF_1 = 0x1

	// NTSTE: Normal Transfer Status Enable Register
	// Position of TDBEE0 field.
	I3C_NTSTE_TDBEE0_Pos = 0x0
	// Bit mask of TDBEE0 field.
	I3C_NTSTE_TDBEE0_Msk = 0x1
	// Bit TDBEE0.
	I3C_NTSTE_TDBEE0 = 0x1
	// Disables Tx0 Data Buffer Empty Interrupt Status logging.
	I3C_NTSTE_TDBEE0_0 = 0x0
	// Enables Tx0 Data Buffer Empty Interrupt Status logging.
	I3C_NTSTE_TDBEE0_1 = 0x1
	// Position of RDBFE0 field.
	I3C_NTSTE_RDBFE0_Pos = 0x1
	// Bit mask of RDBFE0 field.
	I3C_NTSTE_RDBFE0_Msk = 0x2
	// Bit RDBFE0.
	I3C_NTSTE_RDBFE0 = 0x2
	// Disables Rx0 Data Buffer Full Interrupt Status logging.
	I3C_NTSTE_RDBFE0_0 = 0x0
	// Enables Rx0 Data Buffer Full Interrupt Status logging.
	I3C_NTSTE_RDBFE0_1 = 0x1
	// Position of IBIQEFE field.
	I3C_NTSTE_IBIQEFE_Pos = 0x2
	// Bit mask of IBIQEFE field.
	I3C_NTSTE_IBIQEFE_Msk = 0x4
	// Bit IBIQEFE.
	I3C_NTSTE_IBIQEFE = 0x4
	// Disables IBI Status Buffer Empty/Full Interrupt Status logging.
	I3C_NTSTE_IBIQEFE_0 = 0x0
	// Enables IBI Status Buffer Empty/Full Interrupt Status logging.
	I3C_NTSTE_IBIQEFE_1 = 0x1
	// Position of CMDQEE field.
	I3C_NTSTE_CMDQEE_Pos = 0x3
	// Bit mask of CMDQEE field.
	I3C_NTSTE_CMDQEE_Msk = 0x8
	// Bit CMDQEE.
	I3C_NTSTE_CMDQEE = 0x8
	// Disables Command Buffer Empty Interrupt Status logging.
	I3C_NTSTE_CMDQEE_0 = 0x0
	// Enables Command Buffer Empty Interrupt Status logging.
	I3C_NTSTE_CMDQEE_1 = 0x1
	// Position of RSPQFE field.
	I3C_NTSTE_RSPQFE_Pos = 0x4
	// Bit mask of RSPQFE field.
	I3C_NTSTE_RSPQFE_Msk = 0x10
	// Bit RSPQFE.
	I3C_NTSTE_RSPQFE = 0x10
	// Disables Response Buffer Full Interrupt Status logging.
	I3C_NTSTE_RSPQFE_0 = 0x0
	// Enables Response Buffer Full Interrupt Status logging.
	I3C_NTSTE_RSPQFE_1 = 0x1
	// Position of TABTE field.
	I3C_NTSTE_TABTE_Pos = 0x5
	// Bit mask of TABTE field.
	I3C_NTSTE_TABTE_Msk = 0x20
	// Bit TABTE.
	I3C_NTSTE_TABTE = 0x20
	// Disables Transfer Abort Interrupt Status logging.
	I3C_NTSTE_TABTE_0 = 0x0
	// Enables Transfer Abort Interrupt Status logging.
	I3C_NTSTE_TABTE_1 = 0x1
	// Position of TEE field.
	I3C_NTSTE_TEE_Pos = 0x9
	// Bit mask of TEE field.
	I3C_NTSTE_TEE_Msk = 0x200
	// Bit TEE.
	I3C_NTSTE_TEE = 0x200
	// Disables Transfer Error Interrupt Status logging.
	I3C_NTSTE_TEE_0 = 0x0
	// Enables Transfer Error Interrupt Status logging.
	I3C_NTSTE_TEE_1 = 0x1
	// Position of RSQFE field.
	I3C_NTSTE_RSQFE_Pos = 0x14
	// Bit mask of RSQFE field.
	I3C_NTSTE_RSQFE_Msk = 0x100000
	// Bit RSQFE.
	I3C_NTSTE_RSQFE = 0x100000
	// Disables Receive Status Buffer Full Interrupt Status logging.
	I3C_NTSTE_RSQFE_0 = 0x0
	// Enables Receive Status Buffer Full Interrupt Status logging.
	I3C_NTSTE_RSQFE_1 = 0x1

	// NTIE: Normal Transfer Interrupt Enable Register
	// Position of TDBEIE0 field.
	I3C_NTIE_TDBEIE0_Pos = 0x0
	// Bit mask of TDBEIE0 field.
	I3C_NTIE_TDBEIE0_Msk = 0x1
	// Bit TDBEIE0.
	I3C_NTIE_TDBEIE0 = 0x1
	// Disables Tx0 Data Buffer Empty Interrupt Signal.
	I3C_NTIE_TDBEIE0_0 = 0x0
	// Enables Tx0 Data Buffer Empty Interrupt Signal.
	I3C_NTIE_TDBEIE0_1 = 0x1
	// Position of RDBFIE0 field.
	I3C_NTIE_RDBFIE0_Pos = 0x1
	// Bit mask of RDBFIE0 field.
	I3C_NTIE_RDBFIE0_Msk = 0x2
	// Bit RDBFIE0.
	I3C_NTIE_RDBFIE0 = 0x2
	// Disables Rx0 Data Buffer Full Interrupt Signal.
	I3C_NTIE_RDBFIE0_0 = 0x0
	// Enables Rx0 Data Buffer Full Interrupt Signal.
	I3C_NTIE_RDBFIE0_1 = 0x1
	// Position of IBIQEFIE field.
	I3C_NTIE_IBIQEFIE_Pos = 0x2
	// Bit mask of IBIQEFIE field.
	I3C_NTIE_IBIQEFIE_Msk = 0x4
	// Bit IBIQEFIE.
	I3C_NTIE_IBIQEFIE = 0x4
	// Disables IBI Status Buffer Empty/Full Interrupt Signal.
	I3C_NTIE_IBIQEFIE_0 = 0x0
	// Enables IBI Status Buffer Empty/Full Interrupt Signal.
	I3C_NTIE_IBIQEFIE_1 = 0x1
	// Position of CMDQEIE field.
	I3C_NTIE_CMDQEIE_Pos = 0x3
	// Bit mask of CMDQEIE field.
	I3C_NTIE_CMDQEIE_Msk = 0x8
	// Bit CMDQEIE.
	I3C_NTIE_CMDQEIE = 0x8
	// Disables Command Buffer Empty Interrupt Signal.
	I3C_NTIE_CMDQEIE_0 = 0x0
	// Enables Command Buffer Empty Interrupt Signal.
	I3C_NTIE_CMDQEIE_1 = 0x1
	// Position of RSPQFIE field.
	I3C_NTIE_RSPQFIE_Pos = 0x4
	// Bit mask of RSPQFIE field.
	I3C_NTIE_RSPQFIE_Msk = 0x10
	// Bit RSPQFIE.
	I3C_NTIE_RSPQFIE = 0x10
	// Disables Response Buffer Full Interrupt Signal.
	I3C_NTIE_RSPQFIE_0 = 0x0
	// Enables Response Buffer Full Interrupt Signal.
	I3C_NTIE_RSPQFIE_1 = 0x1
	// Position of TABTIE field.
	I3C_NTIE_TABTIE_Pos = 0x5
	// Bit mask of TABTIE field.
	I3C_NTIE_TABTIE_Msk = 0x20
	// Bit TABTIE.
	I3C_NTIE_TABTIE = 0x20
	// Disables Transfer Abort Interrupt Signal.
	I3C_NTIE_TABTIE_0 = 0x0
	// Enables Transfer Abort Interrupt Signal.
	I3C_NTIE_TABTIE_1 = 0x1
	// Position of TEIE field.
	I3C_NTIE_TEIE_Pos = 0x9
	// Bit mask of TEIE field.
	I3C_NTIE_TEIE_Msk = 0x200
	// Bit TEIE.
	I3C_NTIE_TEIE = 0x200
	// Disables Transfer Error Interrupt Signal.
	I3C_NTIE_TEIE_0 = 0x0
	// Enables Transfer Error Interrupt Signal.
	I3C_NTIE_TEIE_1 = 0x1
	// Position of RSQFIE field.
	I3C_NTIE_RSQFIE_Pos = 0x14
	// Bit mask of RSQFIE field.
	I3C_NTIE_RSQFIE_Msk = 0x100000
	// Bit RSQFIE.
	I3C_NTIE_RSQFIE = 0x100000
	// Disables Receive Status Buffer Full Interrupt Signal.
	I3C_NTIE_RSQFIE_0 = 0x0
	// Enables Receive Status Buffer Full Interrupt Signal.
	I3C_NTIE_RSQFIE_1 = 0x1

	// NTSTFC: Normal Transfer Status Force Register
	// Position of TDBEFC0 field.
	I3C_NTSTFC_TDBEFC0_Pos = 0x0
	// Bit mask of TDBEFC0 field.
	I3C_NTSTFC_TDBEFC0_Msk = 0x1
	// Bit TDBEFC0.
	I3C_NTSTFC_TDBEFC0 = 0x1
	// Not Force Tx0 Data Buffer Empty Interrupt for software testing.
	I3C_NTSTFC_TDBEFC0_0 = 0x0
	// Force Tx0 Data Buffer Empty Interrupt for software testing.
	I3C_NTSTFC_TDBEFC0_1 = 0x1
	// Position of RDBFFC0 field.
	I3C_NTSTFC_RDBFFC0_Pos = 0x1
	// Bit mask of RDBFFC0 field.
	I3C_NTSTFC_RDBFFC0_Msk = 0x2
	// Bit RDBFFC0.
	I3C_NTSTFC_RDBFFC0 = 0x2
	// Not Force Rx0 Data Buffer Full Interrupt for software testing.
	I3C_NTSTFC_RDBFFC0_0 = 0x0
	// Force Rx0 Data Buffer Full Interrupt for software testing.
	I3C_NTSTFC_RDBFFC0_1 = 0x1
	// Position of IBIQEFFC field.
	I3C_NTSTFC_IBIQEFFC_Pos = 0x2
	// Bit mask of IBIQEFFC field.
	I3C_NTSTFC_IBIQEFFC_Msk = 0x4
	// Bit IBIQEFFC.
	I3C_NTSTFC_IBIQEFFC = 0x4
	// Not Force IBI Status Buffer Full Interrupt for software testing.
	I3C_NTSTFC_IBIQEFFC_0 = 0x0
	// Force IBI Status Buffer Full Interrupt for software testing.
	I3C_NTSTFC_IBIQEFFC_1 = 0x1
	// Position of CMDQEFC field.
	I3C_NTSTFC_CMDQEFC_Pos = 0x3
	// Bit mask of CMDQEFC field.
	I3C_NTSTFC_CMDQEFC_Msk = 0x8
	// Bit CMDQEFC.
	I3C_NTSTFC_CMDQEFC = 0x8
	// Not Force Command Buffer Empty Interrupt for software testing.
	I3C_NTSTFC_CMDQEFC_0 = 0x0
	// Force Command Buffer Empty Interrupt for software testing.
	I3C_NTSTFC_CMDQEFC_1 = 0x1
	// Position of RSPQFFC field.
	I3C_NTSTFC_RSPQFFC_Pos = 0x4
	// Bit mask of RSPQFFC field.
	I3C_NTSTFC_RSPQFFC_Msk = 0x10
	// Bit RSPQFFC.
	I3C_NTSTFC_RSPQFFC = 0x10
	// Not Force Response Buffer Full Interrupt for software testing.
	I3C_NTSTFC_RSPQFFC_0 = 0x0
	// Force Response Buffer Full Interrupt for software testing.
	I3C_NTSTFC_RSPQFFC_1 = 0x1
	// Position of TABTFC field.
	I3C_NTSTFC_TABTFC_Pos = 0x5
	// Bit mask of TABTFC field.
	I3C_NTSTFC_TABTFC_Msk = 0x20
	// Bit TABTFC.
	I3C_NTSTFC_TABTFC = 0x20
	// Not Force Transfer Abort Interrupt for software testing.
	I3C_NTSTFC_TABTFC_0 = 0x0
	// Force Transfer Abort Interrupt for software testing.
	I3C_NTSTFC_TABTFC_1 = 0x1
	// Position of TEFC field.
	I3C_NTSTFC_TEFC_Pos = 0x9
	// Bit mask of TEFC field.
	I3C_NTSTFC_TEFC_Msk = 0x200
	// Bit TEFC.
	I3C_NTSTFC_TEFC = 0x200
	// Not Force Transfer Error Interrupt for software testing.
	I3C_NTSTFC_TEFC_0 = 0x0
	// Force Transfer Error Interrupt for software testing.
	I3C_NTSTFC_TEFC_1 = 0x1
	// Position of RSQFFC field.
	I3C_NTSTFC_RSQFFC_Pos = 0x14
	// Bit mask of RSQFFC field.
	I3C_NTSTFC_RSQFFC_Msk = 0x100000
	// Bit RSQFFC.
	I3C_NTSTFC_RSQFFC = 0x100000
	// Not Force Receive Status Buffer Full Interrupt for software testing.
	I3C_NTSTFC_RSQFFC_0 = 0x0
	// Force Receive Status Buffer Full Interrupt for software testing.
	I3C_NTSTFC_RSQFFC_1 = 0x1

	// BCST: Bus Condition Status Register
	// Position of BFREF field.
	I3C_BCST_BFREF_Pos = 0x0
	// Bit mask of BFREF field.
	I3C_BCST_BFREF_Msk = 0x1
	// Bit BFREF.
	I3C_BCST_BFREF = 0x1
	// Have not Detected Bus Free
	I3C_BCST_BFREF_0 = 0x0
	// Have Detected Bus Free
	I3C_BCST_BFREF_1 = 0x1
	// Position of BAVLF field.
	I3C_BCST_BAVLF_Pos = 0x1
	// Bit mask of BAVLF field.
	I3C_BCST_BAVLF_Msk = 0x2
	// Bit BAVLF.
	I3C_BCST_BAVLF = 0x2
	// Have not Detected Bus Available
	I3C_BCST_BAVLF_0 = 0x0
	// Have Detected Bus Available
	I3C_BCST_BAVLF_1 = 0x1
	// Position of BIDLF field.
	I3C_BCST_BIDLF_Pos = 0x2
	// Bit mask of BIDLF field.
	I3C_BCST_BIDLF_Msk = 0x4
	// Bit BIDLF.
	I3C_BCST_BIDLF = 0x4
	// Have not Detected Bus Idle
	I3C_BCST_BIDLF_0 = 0x0
	// Have Detected Bus Idle
	I3C_BCST_BIDLF_1 = 0x1

	// SVST: Slave Status Register
	// Position of GCAF field.
	I3C_SVST_GCAF_Pos = 0x0
	// Bit mask of GCAF field.
	I3C_SVST_GCAF_Msk = 0x1
	// Bit GCAF.
	I3C_SVST_GCAF = 0x1
	// General call address does not detect.
	I3C_SVST_GCAF_0 = 0x0
	// General call address detects.
	I3C_SVST_GCAF_1 = 0x1
	// Position of HSMCF field.
	I3C_SVST_HSMCF_Pos = 0x5
	// Bit mask of HSMCF field.
	I3C_SVST_HSMCF_Msk = 0x20
	// Bit HSMCF.
	I3C_SVST_HSMCF = 0x20
	// Hs-mode Master Code does not detect.
	I3C_SVST_HSMCF_0 = 0x0
	// Hs-mode Master Code detects.
	I3C_SVST_HSMCF_1 = 0x1
	// Position of DVIDF field.
	I3C_SVST_DVIDF_Pos = 0x6
	// Bit mask of DVIDF field.
	I3C_SVST_DVIDF_Msk = 0x40
	// Bit DVIDF.
	I3C_SVST_DVIDF = 0x40
	// Device-ID command does not detect.
	I3C_SVST_DVIDF_0 = 0x0
	// Device-ID command detects. This bit set to 1 when the first frame received immediately after a START condition is detected matches a value of (device ID (1111 100) + 0[W]).
	I3C_SVST_DVIDF_1 = 0x1
	// Position of HOAF field.
	I3C_SVST_HOAF_Pos = 0xf
	// Bit mask of HOAF field.
	I3C_SVST_HOAF_Msk = 0x8000
	// Bit HOAF.
	I3C_SVST_HOAF = 0x8000
	// Host address does not detect.
	I3C_SVST_HOAF_0 = 0x0
	// Host address detects. This bit set to 1 when the received slave address matches the host address (0001 000).
	I3C_SVST_HOAF_1 = 0x1
	// Position of SVAF0 field.
	I3C_SVST_SVAF0_Pos = 0x10
	// Bit mask of SVAF0 field.
	I3C_SVST_SVAF0_Msk = 0x10000
	// Bit SVAF0.
	I3C_SVST_SVAF0 = 0x10000
	// Slave 0 does not detect
	I3C_SVST_SVAF0_0 = 0x0
	// Slave 0 detect
	I3C_SVST_SVAF0_1 = 0x1

	// DATBAS0: Device Address Table Basic Register %s
	// Position of DVSTAD field.
	I3C_DATBAS_DVSTAD_Pos = 0x0
	// Bit mask of DVSTAD field.
	I3C_DATBAS_DVSTAD_Msk = 0x7f
	// Position of DVIBIPL field.
	I3C_DATBAS_DVIBIPL_Pos = 0xc
	// Bit mask of DVIBIPL field.
	I3C_DATBAS_DVIBIPL_Msk = 0x1000
	// Bit DVIBIPL.
	I3C_DATBAS_DVIBIPL = 0x1000
	// IBIs from this Device do not carry a Data Payload.
	I3C_DATBAS_DVIBIPL_0 = 0x0
	// IBIs from this Device do carry a Data Payload.
	I3C_DATBAS_DVIBIPL_1 = 0x1
	// Position of DVSIRRJ field.
	I3C_DATBAS_DVSIRRJ_Pos = 0xd
	// Bit mask of DVSIRRJ field.
	I3C_DATBAS_DVSIRRJ_Msk = 0x2000
	// Bit DVSIRRJ.
	I3C_DATBAS_DVSIRRJ = 0x2000
	// This Device shall ACK the SIR.
	I3C_DATBAS_DVSIRRJ_0 = 0x0
	// This Device shall NACK the SIR and send the auto-disable CCC.
	I3C_DATBAS_DVSIRRJ_1 = 0x1
	// Position of DVMRRJ field.
	I3C_DATBAS_DVMRRJ_Pos = 0xe
	// Bit mask of DVMRRJ field.
	I3C_DATBAS_DVMRRJ_Msk = 0x4000
	// Bit DVMRRJ.
	I3C_DATBAS_DVMRRJ = 0x4000
	// This Device shall ACK Master Requests.
	I3C_DATBAS_DVMRRJ_0 = 0x0
	// This Device shall NACK Master Requests and send the auto-disable command.
	I3C_DATBAS_DVMRRJ_1 = 0x1
	// Position of DVDYAD field.
	I3C_DATBAS_DVDYAD_Pos = 0x10
	// Bit mask of DVDYAD field.
	I3C_DATBAS_DVDYAD_Msk = 0xff0000
	// Position of DVNACK field.
	I3C_DATBAS_DVNACK_Pos = 0x1d
	// Bit mask of DVNACK field.
	I3C_DATBAS_DVNACK_Msk = 0x60000000
	// Position of DVTYP field.
	I3C_DATBAS_DVTYP_Pos = 0x1f
	// Bit mask of DVTYP field.
	I3C_DATBAS_DVTYP_Msk = 0x80000000
	// Bit DVTYP.
	I3C_DATBAS_DVTYP = 0x80000000
	// I3C Device
	I3C_DATBAS_DVTYP_0 = 0x0
	// I2C Device
	I3C_DATBAS_DVTYP_1 = 0x1

	// EXDATBAS: Extended Device Address Table Basic Register
	// Position of EDSTAD field.
	I3C_EXDATBAS_EDSTAD_Pos = 0x0
	// Bit mask of EDSTAD field.
	I3C_EXDATBAS_EDSTAD_Msk = 0x7f
	// Position of EDDYAD field.
	I3C_EXDATBAS_EDDYAD_Pos = 0x10
	// Bit mask of EDDYAD field.
	I3C_EXDATBAS_EDDYAD_Msk = 0xff0000
	// Position of EDNACK field.
	I3C_EXDATBAS_EDNACK_Pos = 0x1d
	// Bit mask of EDNACK field.
	I3C_EXDATBAS_EDNACK_Msk = 0x60000000
	// Position of EDTYP field.
	I3C_EXDATBAS_EDTYP_Pos = 0x1f
	// Bit mask of EDTYP field.
	I3C_EXDATBAS_EDTYP_Msk = 0x80000000
	// Bit EDTYP.
	I3C_EXDATBAS_EDTYP = 0x80000000
	// I3C Device
	I3C_EXDATBAS_EDTYP_0 = 0x0
	// I2C Device
	I3C_EXDATBAS_EDTYP_1 = 0x1

	// SDATBAS0: Slave Device Address Table Basic Register 0
	// Position of SDSTAD field.
	I3C_SDATBAS0_SDSTAD_Pos = 0x0
	// Bit mask of SDSTAD field.
	I3C_SDATBAS0_SDSTAD_Msk = 0x3ff
	// Position of SDADLS field.
	I3C_SDATBAS0_SDADLS_Pos = 0xa
	// Bit mask of SDADLS field.
	I3C_SDATBAS0_SDADLS_Msk = 0x400
	// Bit SDADLS.
	I3C_SDATBAS0_SDADLS = 0x400
	// Slave device address length 7 bits selected.
	I3C_SDATBAS0_SDADLS_0 = 0x0
	// Slave device address length 10 bits selected. (I2C device only)
	I3C_SDATBAS0_SDADLS_1 = 0x1
	// Position of SDIBIPL field.
	I3C_SDATBAS0_SDIBIPL_Pos = 0xc
	// Bit mask of SDIBIPL field.
	I3C_SDATBAS0_SDIBIPL_Msk = 0x1000
	// Bit SDIBIPL.
	I3C_SDATBAS0_SDIBIPL = 0x1000
	// IBIs from this device do not carry a data payload.
	I3C_SDATBAS0_SDIBIPL_0 = 0x0
	// IBIs from this device carry a data payload.
	I3C_SDATBAS0_SDIBIPL_1 = 0x1
	// Position of SDDYAD field.
	I3C_SDATBAS0_SDDYAD_Pos = 0x10
	// Bit mask of SDDYAD field.
	I3C_SDATBAS0_SDDYAD_Msk = 0x7f0000

	// MSDCT0: Master Device Characteristic Table Register %s
	// Position of RBCR0 field.
	I3C_MSDCT_RBCR0_Pos = 0x8
	// Bit mask of RBCR0 field.
	I3C_MSDCT_RBCR0_Msk = 0x100
	// Bit RBCR0.
	I3C_MSDCT_RBCR0 = 0x100
	// No Limitation
	I3C_MSDCT_RBCR0_0 = 0x0
	// Limitation
	I3C_MSDCT_RBCR0_1 = 0x1
	// Position of RBCR1 field.
	I3C_MSDCT_RBCR1_Pos = 0x9
	// Bit mask of RBCR1 field.
	I3C_MSDCT_RBCR1_Msk = 0x200
	// Bit RBCR1.
	I3C_MSDCT_RBCR1 = 0x200
	// Not Capable
	I3C_MSDCT_RBCR1_0 = 0x0
	// Capable
	I3C_MSDCT_RBCR1_1 = 0x1
	// Position of RBCR2 field.
	I3C_MSDCT_RBCR2_Pos = 0xa
	// Bit mask of RBCR2 field.
	I3C_MSDCT_RBCR2_Msk = 0x400
	// Bit RBCR2.
	I3C_MSDCT_RBCR2 = 0x400
	// No data byte follows the accepted IBI.
	I3C_MSDCT_RBCR2_0 = 0x0
	// Mandatory one or more data bytes follow the accepted IBI. Data byte continuation is indicated by T-Bit.
	I3C_MSDCT_RBCR2_1 = 0x1
	// Position of RBCR3 field.
	I3C_MSDCT_RBCR3_Pos = 0xb
	// Bit mask of RBCR3 field.
	I3C_MSDCT_RBCR3_Msk = 0x800
	// Bit RBCR3.
	I3C_MSDCT_RBCR3 = 0x800
	// Device will always respond to I3C bus commands.
	I3C_MSDCT_RBCR3_0 = 0x0
	// Device will not always respond to I3C bus commands.
	I3C_MSDCT_RBCR3_1 = 0x1
	// Position of RBCR76 field.
	I3C_MSDCT_RBCR76_Pos = 0xe
	// Bit mask of RBCR76 field.
	I3C_MSDCT_RBCR76_Msk = 0xc000
	// I3C Slave
	I3C_MSDCT_RBCR76_00 = 0x0
	// I3C Master
	I3C_MSDCT_RBCR76_01 = 0x1

	// SVDCT: Slave Device Characteristic Table Register
	// Position of TDCR field.
	I3C_SVDCT_TDCR_Pos = 0x0
	// Bit mask of TDCR field.
	I3C_SVDCT_TDCR_Msk = 0xff
	// Position of TBCR0 field.
	I3C_SVDCT_TBCR0_Pos = 0x8
	// Bit mask of TBCR0 field.
	I3C_SVDCT_TBCR0_Msk = 0x100
	// Bit TBCR0.
	I3C_SVDCT_TBCR0 = 0x100
	// No Limitation
	I3C_SVDCT_TBCR0_0 = 0x0
	// Limitation
	I3C_SVDCT_TBCR0_1 = 0x1
	// Position of TBCR1 field.
	I3C_SVDCT_TBCR1_Pos = 0x9
	// Bit mask of TBCR1 field.
	I3C_SVDCT_TBCR1_Msk = 0x200
	// Bit TBCR1.
	I3C_SVDCT_TBCR1 = 0x200
	// Not Capable
	I3C_SVDCT_TBCR1_0 = 0x0
	// Capable
	I3C_SVDCT_TBCR1_1 = 0x1
	// Position of TBCR2 field.
	I3C_SVDCT_TBCR2_Pos = 0xa
	// Bit mask of TBCR2 field.
	I3C_SVDCT_TBCR2_Msk = 0x400
	// Bit TBCR2.
	I3C_SVDCT_TBCR2 = 0x400
	// No data byte follows the accepted IBI.
	I3C_SVDCT_TBCR2_0 = 0x0
	// Mandatory one or more data bytes follow the accepted IBI. Data byte continuation is indicated by T-Bit.
	I3C_SVDCT_TBCR2_1 = 0x1
	// Position of TBCR3 field.
	I3C_SVDCT_TBCR3_Pos = 0xb
	// Bit mask of TBCR3 field.
	I3C_SVDCT_TBCR3_Msk = 0x800
	// Bit TBCR3.
	I3C_SVDCT_TBCR3 = 0x800
	// Device will always respond to I3C bus commands.
	I3C_SVDCT_TBCR3_0 = 0x0
	// Device will not always respond to I3C bus commands.
	I3C_SVDCT_TBCR3_1 = 0x1
	// Position of TBCR76 field.
	I3C_SVDCT_TBCR76_Pos = 0xe
	// Bit mask of TBCR76 field.
	I3C_SVDCT_TBCR76_Msk = 0xc000
	// I3C Slave
	I3C_SVDCT_TBCR76_00 = 0x0
	// I3C Master
	I3C_SVDCT_TBCR76_01 = 0x1
	// Reserved for future definition by MIPI Sensor WG
	I3C_SVDCT_TBCR76_10 = 0x2
	// Reserved for future definition by MIPI Sensor WG
	I3C_SVDCT_TBCR76_11 = 0x3

	// SVDVAD0: Slave Device Address Register 0
	// Position of SVAD field.
	I3C_SVDVAD0_SVAD_Pos = 0x10
	// Bit mask of SVAD field.
	I3C_SVDVAD0_SVAD_Msk = 0x3ff0000
	// Position of SADLG field.
	I3C_SVDVAD0_SADLG_Pos = 0x1b
	// Bit mask of SADLG field.
	I3C_SVDVAD0_SADLG_Msk = 0x8000000
	// Bit SADLG.
	I3C_SVDVAD0_SADLG = 0x8000000
	// The 7-bit address format is selected.
	I3C_SVDVAD0_SADLG_0 = 0x0
	// The 10-bit address format is selected.
	I3C_SVDVAD0_SADLG_1 = 0x1
	// Position of SSTADV field.
	I3C_SVDVAD0_SSTADV_Pos = 0x1e
	// Bit mask of SSTADV field.
	I3C_SVDVAD0_SSTADV_Msk = 0x40000000
	// Bit SSTADV.
	I3C_SVDVAD0_SSTADV = 0x40000000
	// Slave address is disabled.
	I3C_SVDVAD0_SSTADV_0 = 0x0
	// Slave address is enabled.
	I3C_SVDVAD0_SSTADV_1 = 0x1
	// Position of SDYADV field.
	I3C_SVDVAD0_SDYADV_Pos = 0x1f
	// Bit mask of SDYADV field.
	I3C_SVDVAD0_SDYADV_Msk = 0x80000000
	// Bit SDYADV.
	I3C_SVDVAD0_SDYADV = 0x80000000
	// Dynamic Address is disabled.
	I3C_SVDVAD0_SDYADV_0 = 0x0
	// Dynamic Address is enabled.
	I3C_SVDVAD0_SDYADV_1 = 0x1

	// CSECMD: CCC Slave Events Command Register
	// Position of SVIRQE field.
	I3C_CSECMD_SVIRQE_Pos = 0x0
	// Bit mask of SVIRQE field.
	I3C_CSECMD_SVIRQE_Msk = 0x1
	// Bit SVIRQE.
	I3C_CSECMD_SVIRQE = 0x1
	// DISABLED: Slave-initiated Interrupts is Disabled by the Master to control.
	I3C_CSECMD_SVIRQE_0 = 0x0
	// ENABLED: Slave-initiated Interrupts is Enabled by the Master to control.
	I3C_CSECMD_SVIRQE_1 = 0x1
	// Position of MSRQE field.
	I3C_CSECMD_MSRQE_Pos = 0x1
	// Bit mask of MSRQE field.
	I3C_CSECMD_MSRQE_Msk = 0x2
	// Bit MSRQE.
	I3C_CSECMD_MSRQE = 0x2
	// DISABLED: Mastership requests from Secondary Masters is Disabled by the Current Master to control.
	I3C_CSECMD_MSRQE_0 = 0x0
	// ENABLED: Mastership requests from Secondary Masters is Enabled by the Current Master to control.
	I3C_CSECMD_MSRQE_1 = 0x1
	// Position of HJEVE field.
	I3C_CSECMD_HJEVE_Pos = 0x3
	// Bit mask of HJEVE field.
	I3C_CSECMD_HJEVE_Msk = 0x8
	// Bit HJEVE.
	I3C_CSECMD_HJEVE = 0x8
	// DISABLED: Slave-initiated Hot-Join is Disabled by the Master to control.
	I3C_CSECMD_HJEVE_0 = 0x0
	// ENABLED: Slave-initiated Hot-Join is Enabled by the Master to control.
	I3C_CSECMD_HJEVE_1 = 0x1

	// CEACTST: CCC Enter Activity State Register
	// Position of ACTST field.
	I3C_CEACTST_ACTST_Pos = 0x0
	// Bit mask of ACTST field.
	I3C_CEACTST_ACTST_Msk = 0xf
	// ENTAS0 (1µs: Latency-free operation)
	I3C_CEACTST_ACTST_0x1 = 0x1
	// ENTAS1 (100 µs)
	I3C_CEACTST_ACTST_0x2 = 0x2
	// ENTAS2 (2 ms)
	I3C_CEACTST_ACTST_0x4 = 0x4
	// ENTAS3 (50 ms: Lowest-activity operation)
	I3C_CEACTST_ACTST_0x8 = 0x8

	// CMWLG: CCC Max Write Length Register
	// Position of MWLG field.
	I3C_CMWLG_MWLG_Pos = 0x0
	// Bit mask of MWLG field.
	I3C_CMWLG_MWLG_Msk = 0xffff

	// CMRLG: CCC Max Read Length Register
	// Position of MRLG field.
	I3C_CMRLG_MRLG_Pos = 0x0
	// Bit mask of MRLG field.
	I3C_CMRLG_MRLG_Msk = 0xffff
	// Position of IBIPSZ field.
	I3C_CMRLG_IBIPSZ_Pos = 0x10
	// Bit mask of IBIPSZ field.
	I3C_CMRLG_IBIPSZ_Msk = 0xff0000

	// CETSTMD: CCC Enter Test Mode Register
	// Position of TSTMD field.
	I3C_CETSTMD_TSTMD_Pos = 0x0
	// Bit mask of TSTMD field.
	I3C_CETSTMD_TSTMD_Msk = 0xff
	// Exit Test Mode This value removes all I3C devices from Test Mode.
	I3C_CETSTMD_TSTMD_0x00 = 0x0
	// Vendor Test Mode This value indicates that I3C devices shall return a random 32bit value in the provisional ID during the Dynamic Address Assignment procedure.
	I3C_CETSTMD_TSTMD_0x01 = 0x1

	// CGDVST: CCC Get Device Status Register
	// Position of PNDINT field.
	I3C_CGDVST_PNDINT_Pos = 0x0
	// Bit mask of PNDINT field.
	I3C_CGDVST_PNDINT_Msk = 0xf
	// Position of PRTE field.
	I3C_CGDVST_PRTE_Pos = 0x5
	// Bit mask of PRTE field.
	I3C_CGDVST_PRTE_Msk = 0x20
	// Bit PRTE.
	I3C_CGDVST_PRTE = 0x20
	// The Slave has not detected a protocol error since the last Status read.
	I3C_CGDVST_PRTE_0 = 0x0
	// The Slave has detected a protocol error since the last Status read.
	I3C_CGDVST_PRTE_1 = 0x1
	// Position of ACTMD field.
	I3C_CGDVST_ACTMD_Pos = 0x6
	// Bit mask of ACTMD field.
	I3C_CGDVST_ACTMD_Msk = 0xc0
	// Activity Mode 0
	I3C_CGDVST_ACTMD_00 = 0x0
	// Activity Mode 1
	I3C_CGDVST_ACTMD_01 = 0x1
	// Activity Mode 2
	I3C_CGDVST_ACTMD_10 = 0x2
	// Activity Mode 3
	I3C_CGDVST_ACTMD_11 = 0x3
	// Position of VDRSV field.
	I3C_CGDVST_VDRSV_Pos = 0x8
	// Bit mask of VDRSV field.
	I3C_CGDVST_VDRSV_Msk = 0xff00

	// CMDSPW: CCC Max Data Speed W (Write) Register
	// Position of MSWDR field.
	I3C_CMDSPW_MSWDR_Pos = 0x0
	// Bit mask of MSWDR field.
	I3C_CMDSPW_MSWDR_Msk = 0x7
	// fscl Max (default value)
	I3C_CMDSPW_MSWDR_000 = 0x0
	// 8 MHz
	I3C_CMDSPW_MSWDR_001 = 0x1
	// 6 MHz
	I3C_CMDSPW_MSWDR_010 = 0x2
	// 4 MHz
	I3C_CMDSPW_MSWDR_011 = 0x3
	// 2 MHz
	I3C_CMDSPW_MSWDR_100 = 0x4

	// CMDSPR: CCC Max Data Speed R (Read) Register
	// Position of MSRDR field.
	I3C_CMDSPR_MSRDR_Pos = 0x0
	// Bit mask of MSRDR field.
	I3C_CMDSPR_MSRDR_Msk = 0x7
	// fscl Max (default value)
	I3C_CMDSPR_MSRDR_000 = 0x0
	// 8 MHz
	I3C_CMDSPR_MSRDR_001 = 0x1
	// 6 MHz
	I3C_CMDSPR_MSRDR_010 = 0x2
	// 4 MHz
	I3C_CMDSPR_MSRDR_011 = 0x3
	// 2 MHz
	I3C_CMDSPR_MSRDR_100 = 0x4
	// Position of CDTTIM field.
	I3C_CMDSPR_CDTTIM_Pos = 0x3
	// Bit mask of CDTTIM field.
	I3C_CMDSPR_CDTTIM_Msk = 0x38
	// 8 ns or less (default value)
	I3C_CMDSPR_CDTTIM_000 = 0x0
	// 9 ns or less
	I3C_CMDSPR_CDTTIM_001 = 0x1
	// 10 ns or less
	I3C_CMDSPR_CDTTIM_010 = 0x2
	// 11 ns or less
	I3C_CMDSPR_CDTTIM_011 = 0x3
	// 12 ns or less
	I3C_CMDSPR_CDTTIM_100 = 0x4
	// TSCO is more than 12 ns, and is reported by private agreement.
	I3C_CMDSPR_CDTTIM_111 = 0x7

	// CMDSPT: CCC Max Data Speed T (Turnaround) Register
	// Position of MRTTIM field.
	I3C_CMDSPT_MRTTIM_Pos = 0x0
	// Bit mask of MRTTIM field.
	I3C_CMDSPT_MRTTIM_Msk = 0xffffff
	// Position of MRTE field.
	I3C_CMDSPT_MRTE_Pos = 0x1f
	// Bit mask of MRTE field.
	I3C_CMDSPT_MRTE_Msk = 0x80000000
	// Bit MRTE.
	I3C_CMDSPT_MRTE = 0x80000000
	// Disables transmission of the Maximum Read Turnaround Time. (GETMXDS Format 1: Without Turnaround)
	I3C_CMDSPT_MRTE_0 = 0x0
	// Enables transmission of the Maximum Read Turnaround Time. (GETMXDS Format 2: With Turnaround)
	I3C_CMDSPT_MRTE_1 = 0x1

	// CETSM: CCC Exchange Timing Support Information M (Mode) Register
	// Position of FREQ field.
	I3C_CETSM_FREQ_Pos = 0x8
	// Bit mask of FREQ field.
	I3C_CETSM_FREQ_Msk = 0xff00
	// 32.0 KHz
	I3C_CETSM_FREQ_0x00 = 0x0
	// 7.5 MHz
	I3C_CETSM_FREQ_0x0F = 0xf
	// 15.5 MHz
	I3C_CETSM_FREQ_0x1F = 0x1f
	// 23.5 MHz
	I3C_CETSM_FREQ_0x2F = 0x2f
	// 31.5 MHz
	I3C_CETSM_FREQ_0x3F = 0x3f
	// 39.5 MHz
	I3C_CETSM_FREQ_0x4F = 0x4f
	// 47.5 MHz
	I3C_CETSM_FREQ_0x5F = 0x5f
	// 55.5 MHz
	I3C_CETSM_FREQ_0x6F = 0x6f
	// 63.5 MHz
	I3C_CETSM_FREQ_0x7F = 0x7f
	// Position of INAC field.
	I3C_CETSM_INAC_Pos = 0x10
	// Bit mask of INAC field.
	I3C_CETSM_INAC_Msk = 0xff0000
	// 0.0%
	I3C_CETSM_INAC_0x00 = 0x0
	// 1.5%
	I3C_CETSM_INAC_0x0F = 0xf
	// 3.1%
	I3C_CETSM_INAC_0x1F = 0x1f
	// 4.7%
	I3C_CETSM_INAC_0x2F = 0x2f
	// 6.3%
	I3C_CETSM_INAC_0x3F = 0x3f
	// 7.9%
	I3C_CETSM_INAC_0x4F = 0x4f
	// 9.5%
	I3C_CETSM_INAC_0x5F = 0x5f
	// 11.1%
	I3