// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAM3N0C.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && atsam3n0c

// Atmel ATSAM3N0C Microcontroller
//

package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ATSAM3N0C"
	CPU          = "CM3"
	FPUPresent   = false
	NVICPrioBits = 4
)

// Interrupt numbers.
const (
	// Power Management Controller
	IRQ_PMC = 5

	// Embedded Flash Controller
	IRQ_EFC = 6

	// Universal Asynchronous Receiver Transmitter 0
	IRQ_UART0 = 8

	// Universal Asynchronous Receiver Transmitter 1
	IRQ_UART1 = 9

	// Parallel Input/Output Controller A
	IRQ_PIOA = 11

	// Parallel Input/Output Controller B
	IRQ_PIOB = 12

	// Parallel Input/Output Controller C
	IRQ_PIOC = 13

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	IRQ_USART0 = 14

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	IRQ_USART1 = 15

	// Two-wire Interface 0
	IRQ_TWI0 = 19

	// Two-wire Interface 1
	IRQ_TWI1 = 20

	// Serial Peripheral Interface
	IRQ_SPI = 21

	// Timer Counter 0
	IRQ_TC0 = 23

	// Timer Counter 0
	IRQ_TC1 = 24

	// Timer Counter 0
	IRQ_TC2 = 25

	// Timer Counter 1
	IRQ_TC3 = 26

	// Timer Counter 1
	IRQ_TC4 = 27

	// Timer Counter 1
	IRQ_TC5 = 28

	// Analog-to-Digital Converter
	IRQ_ADC = 29

	// Digital-to-Analog Converter Controller
	IRQ_DACC = 30

	// Pulse Width Modulation Controller
	IRQ_PWM = 31

	// Highest interrupt number on this device.
	IRQ_max = 31
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export PMC_IRQHandler
func interruptPMC() {
	callHandlers(IRQ_PMC)
}

//export EFC_IRQHandler
func interruptEFC() {
	callHandlers(IRQ_EFC)
}

//export UART0_IRQHandler
func interruptUART0() {
	callHandlers(IRQ_UART0)
}

//export UART1_IRQHandler
func interruptUART1() {
	callHandlers(IRQ_UART1)
}

//export PIOA_IRQHandler
func interruptPIOA() {
	callHandlers(IRQ_PIOA)
}

//export PIOB_IRQHandler
func interruptPIOB() {
	callHandlers(IRQ_PIOB)
}

//export PIOC_IRQHandler
func interruptPIOC() {
	callHandlers(IRQ_PIOC)
}

//export USART0_IRQHandler
func interruptUSART0() {
	callHandlers(IRQ_USART0)
}

//export USART1_IRQHandler
func interruptUSART1() {
	callHandlers(IRQ_USART1)
}

//export TWI0_IRQHandler
func interruptTWI0() {
	callHandlers(IRQ_TWI0)
}

//export TWI1_IRQHandler
func interruptTWI1() {
	callHandlers(IRQ_TWI1)
}

//export SPI_IRQHandler
func interruptSPI() {
	callHandlers(IRQ_SPI)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export TC1_IRQHandler
func interruptTC1() {
	callHandlers(IRQ_TC1)
}

//export TC2_IRQHandler
func interruptTC2() {
	callHandlers(IRQ_TC2)
}

//export TC3_IRQHandler
func interruptTC3() {
	callHandlers(IRQ_TC3)
}

//export TC4_IRQHandler
func interruptTC4() {
	callHandlers(IRQ_TC4)
}

//export TC5_IRQHandler
func interruptTC5() {
	callHandlers(IRQ_TC5)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export DACC_IRQHandler
func interruptDACC() {
	callHandlers(IRQ_DACC)
}

//export PWM_IRQHandler
func interruptPWM() {
	callHandlers(IRQ_PWM)
}

// Peripherals.
var (
	// Serial Peripheral Interface
	SPI = (*SPI_Type)(unsafe.Pointer(uintptr(0x40008000)))

	// Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0x40010000)))

	// Timer Counter 1
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0x40014000)))

	// Two-wire Interface 0
	TWI0 = (*TWI_Type)(unsafe.Pointer(uintptr(0x40018000)))

	// Two-wire Interface 1
	TWI1 = (*TWI_Type)(unsafe.Pointer(uintptr(0x4001c000)))

	// Pulse Width Modulation Controller
	PWM = (*PWM_Type)(unsafe.Pointer(uintptr(0x40020000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 0
	USART0 = (*USART_Type)(unsafe.Pointer(uintptr(0x40024000)))

	// Universal Synchronous Asynchronous Receiver Transmitter 1
	USART1 = (*USART_Type)(unsafe.Pointer(uintptr(0x40028000)))

	// Analog-to-Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x40038000)))

	// Digital-to-Analog Converter Controller
	DACC = (*DACC_Type)(unsafe.Pointer(uintptr(0x4003c000)))

	// AHB Bus Matrix
	MATRIX = (*MATRIX_Type)(unsafe.Pointer(uintptr(0x400e0200)))

	// Power Management Controller
	PMC = (*PMC_Type)(unsafe.Pointer(uintptr(0x400e0400)))

	// Universal Asynchronous Receiver Transmitter 0
	UART0 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0600)))

	// Chip Identifier
	CHIPID = (*CHIPID_Type)(unsafe.Pointer(uintptr(0x400e0740)))

	// Universal Asynchronous Receiver Transmitter 1
	UART1 = (*UART_Type)(unsafe.Pointer(uintptr(0x400e0800)))

	// Embedded Flash Controller
	EFC = (*EFC_Type)(unsafe.Pointer(uintptr(0x400e0a00)))

	// Parallel Input/Output Controller A
	PIOA = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e0e00)))

	// Parallel Input/Output Controller B
	PIOB = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1000)))

	// Parallel Input/Output Controller C
	PIOC = (*PIO_Type)(unsafe.Pointer(uintptr(0x400e1200)))

	// Reset Controller
	RSTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1400)))

	// Supply Controller
	SUPC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1410)))

	// Real-time Timer
	RTT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1430)))

	// Watchdog Timer
	WDT = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1450)))

	// Real-time Clock
	RTC = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1460)))

	// General Purpose Backup Registers
	GPBR = (*SYSC_Type)(unsafe.Pointer(uintptr(0x400e1490)))
)

// Serial Peripheral Interface
type SPI_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	RDR  volatile.Register32 // 0x8
	TDR  volatile.Register32 // 0xC
	SR   volatile.Register32 // 0x10
	IER  volatile.Register32 // 0x14
	IDR  volatile.Register32 // 0x18
	IMR  volatile.Register32 // 0x1C
	_    [16]byte
	CSR  [4]volatile.Register32 // 0x30
	_    [164]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// SPI.CR: Control Register
func (o *SPI_Type) SetCR_SPIEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCR_SPIEN() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SPI_Type) SetCR_SPIDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCR_SPIDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetCR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetCR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000000) >> 24
}

// SPI.MR: Mode Register
func (o *SPI_Type) SetMR_MSTR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetMR_MSTR() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *SPI_Type) SetMR_PS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetMR_PS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetMR_PCSDEC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetMR_PCSDEC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetMR_MODFDIS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *SPI_Type) GetMR_MODFDIS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *SPI_Type) SetMR_WDRBT(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *SPI_Type) GetMR_WDRBT() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *SPI_Type) SetMR_LLB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *SPI_Type) GetMR_LLB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *SPI_Type) SetMR_PCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetMR_PCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetMR_DLYBCS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetMR_DLYBCS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// SPI.RDR: Receive Data Register
func (o *SPI_Type) SetRDR_RD(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRDR_RD() uint32 {
	return volatile.LoadUint32(&o.RDR.Reg) & 0xffff
}
func (o *SPI_Type) SetRDR_PCS(value uint32) {
	volatile.StoreUint32(&o.RDR.Reg, volatile.LoadUint32(&o.RDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetRDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.RDR.Reg) & 0xf0000) >> 16
}

// SPI.TDR: Transmit Data Register
func (o *SPI_Type) SetTDR_TD(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTDR_TD() uint32 {
	return volatile.LoadUint32(&o.TDR.Reg) & 0xffff
}
func (o *SPI_Type) SetTDR_PCS(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0xf0000)|value<<16)
}
func (o *SPI_Type) GetTDR_PCS() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0xf0000) >> 16
}
func (o *SPI_Type) SetTDR_LASTXFER(value uint32) {
	volatile.StoreUint32(&o.TDR.Reg, volatile.LoadUint32(&o.TDR.Reg)&^(0x1000000)|value<<24)
}
func (o *SPI_Type) GetTDR_LASTXFER() uint32 {
	return (volatile.LoadUint32(&o.TDR.Reg) & 0x1000000) >> 24
}

// SPI.SR: Status Register
func (o *SPI_Type) SetSR_RDRF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetSR_RDRF() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SPI_Type) SetSR_TDRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetSR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetSR_MODF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetSR_MODF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetSR_OVRES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetSR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetSR_NSSR(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetSR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetSR_UNDES(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetSR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *SPI_Type) SetSR_SPIENS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SPI_Type) GetSR_SPIENS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}

// SPI.IER: Interrupt Enable Register
func (o *SPI_Type) SetIER_RDRF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIER_RDRF() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *SPI_Type) SetIER_TDRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIER_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIER_MODF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIER_MODF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIER_OVRES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIER_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIER_NSSR(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIER_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIER_UNDES(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIER_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}

// SPI.IDR: Interrupt Disable Register
func (o *SPI_Type) SetIDR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIDR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *SPI_Type) SetIDR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIDR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIDR_MODF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIDR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIDR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIDR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIDR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIDR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIDR_UNDES(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIDR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}

// SPI.IMR: Interrupt Mask Register
func (o *SPI_Type) SetIMR_RDRF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetIMR_RDRF() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *SPI_Type) SetIMR_TDRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetIMR_TDRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetIMR_MODF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetIMR_MODF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetIMR_OVRES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetIMR_OVRES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetIMR_NSSR(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetIMR_NSSR() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *SPI_Type) SetIMR_UNDES(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *SPI_Type) GetIMR_UNDES() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}

// SPI.CSR: Chip Select Register
func (o *SPI_Type) SetCSR_CPOL(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetCSR_CPOL(idx int) uint32 {
	return volatile.LoadUint32(&o.CSR[idx].Reg) & 0x1
}
func (o *SPI_Type) SetCSR_NCPHA(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetCSR_NCPHA(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetCSR_CSNAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *SPI_Type) GetCSR_CSNAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x4) >> 2
}
func (o *SPI_Type) SetCSR_CSAAT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *SPI_Type) GetCSR_CSAAT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0x8) >> 3
}
func (o *SPI_Type) SetCSR_BITS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xf0)|value<<4)
}
func (o *SPI_Type) GetCSR_BITS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xf0) >> 4
}
func (o *SPI_Type) SetCSR_SCBR(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetCSR_SCBR(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff00) >> 8
}
func (o *SPI_Type) SetCSR_DLYBS(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff0000)|value<<16)
}
func (o *SPI_Type) GetCSR_DLYBS(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff0000) >> 16
}
func (o *SPI_Type) SetCSR_DLYBCT(idx int, value uint32) {
	volatile.StoreUint32(&o.CSR[idx].Reg, volatile.LoadUint32(&o.CSR[idx].Reg)&^(0xff000000)|value<<24)
}
func (o *SPI_Type) GetCSR_DLYBCT(idx int) uint32 {
	return (volatile.LoadUint32(&o.CSR[idx].Reg) & 0xff000000) >> 24
}

// SPI.WPMR: Write Protection Control Register
func (o *SPI_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *SPI_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *SPI_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// SPI.WPSR: Write Protection Status Register
func (o *SPI_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *SPI_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *SPI_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// SPI.RPR: Receive Pointer Register
func (o *SPI_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *SPI_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// SPI.RCR: Receive Counter Register
func (o *SPI_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// SPI.TPR: Transmit Pointer Register
func (o *SPI_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *SPI_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// SPI.TCR: Transmit Counter Register
func (o *SPI_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// SPI.RNPR: Receive Next Pointer Register
func (o *SPI_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *SPI_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// SPI.RNCR: Receive Next Counter Register
func (o *SPI_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// SPI.TNPR: Transmit Next Pointer Register
func (o *SPI_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *SPI_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// SPI.TNCR: Transmit Next Counter Register
func (o *SPI_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *SPI_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// SPI.PTCR: Transfer Control Register
func (o *SPI_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *SPI_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *SPI_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *SPI_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *SPI_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *SPI_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// SPI.PTSR: Transfer Status Register
func (o *SPI_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *SPI_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *SPI_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *SPI_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Timer Counter 0
type TC_Type struct {
	CCR0  volatile.Register32 // 0x0
	CMR0  volatile.Register32 // 0x4
	SMMR0 volatile.Register32 // 0x8
	_     [4]byte
	CV0   volatile.Register32 // 0x10
	RA0   volatile.Register32 // 0x14
	RB0   volatile.Register32 // 0x18
	RC0   volatile.Register32 // 0x1C
	SR0   volatile.Register32 // 0x20
	IER0  volatile.Register32 // 0x24
	IDR0  volatile.Register32 // 0x28
	IMR0  volatile.Register32 // 0x2C
	_     [16]byte
	CCR1  volatile.Register32 // 0x40
	CMR1  volatile.Register32 // 0x44
	SMMR1 volatile.Register32 // 0x48
	_     [4]byte
	CV1   volatile.Register32 // 0x50
	RA1   volatile.Register32 // 0x54
	RB1   volatile.Register32 // 0x58
	RC1   volatile.Register32 // 0x5C
	SR1   volatile.Register32 // 0x60
	IER1  volatile.Register32 // 0x64
	IDR1  volatile.Register32 // 0x68
	IMR1  volatile.Register32 // 0x6C
	_     [16]byte
	CCR2  volatile.Register32 // 0x80
	CMR2  volatile.Register32 // 0x84
	SMMR2 volatile.Register32 // 0x88
	_     [4]byte
	CV2   volatile.Register32 // 0x90
	RA2   volatile.Register32 // 0x94
	RB2   volatile.Register32 // 0x98
	RC2   volatile.Register32 // 0x9C
	SR2   volatile.Register32 // 0xA0
	IER2  volatile.Register32 // 0xA4
	IDR2  volatile.Register32 // 0xA8
	IMR2  volatile.Register32 // 0xAC
	_     [16]byte
	BCR   volatile.Register32 // 0xC0
	BMR   volatile.Register32 // 0xC4
	QIER  volatile.Register32 // 0xC8
	QIDR  volatile.Register32 // 0xCC
	QIMR  volatile.Register32 // 0xD0
	QISR  volatile.Register32 // 0xD4
	_     [12]byte
	WPMR  volatile.Register32 // 0xE4
}

// TC.CCR0: Channel Control Register (channel = 0)
func (o *TC_Type) SetCCR0_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR0_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR0.Reg) & 0x1
}
func (o *TC_Type) SetCCR0_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR0_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR0_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR0.Reg, volatile.LoadUint32(&o.CCR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR0_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR0.Reg) & 0x4) >> 2
}

// TC.CMR0: Channel Mode Register (channel = 0)
func (o *TC_Type) SetCMR0_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR0_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0x7
}
func (o *TC_Type) SetCMR0_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR0_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR0_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR0_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR0_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR0_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR0_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR0_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR0_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR0_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR0_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR0_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR0_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR0_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR0_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR0_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR0_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR0_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR0_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR0_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0xc0000) >> 18
}

// TC.SMMR0: Stepper Motor Mode Register (channel = 0)
func (o *TC_Type) SetSMMR0_GCEN(value uint32) {
	volatile.StoreUint32(&o.SMMR0.Reg, volatile.LoadUint32(&o.SMMR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSMMR0_GCEN() uint32 {
	return volatile.LoadUint32(&o.SMMR0.Reg) & 0x1
}
func (o *TC_Type) SetSMMR0_DOWN(value uint32) {
	volatile.StoreUint32(&o.SMMR0.Reg, volatile.LoadUint32(&o.SMMR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSMMR0_DOWN() uint32 {
	return (volatile.LoadUint32(&o.SMMR0.Reg) & 0x2) >> 1
}

// TC.CV0: Counter Value (channel = 0)
func (o *TC_Type) SetCV0(value uint32) {
	volatile.StoreUint32(&o.CV0.Reg, value)
}
func (o *TC_Type) GetCV0() uint32 {
	return volatile.LoadUint32(&o.CV0.Reg)
}

// TC.RA0: Register A (channel = 0)
func (o *TC_Type) SetRA0(value uint32) {
	volatile.StoreUint32(&o.RA0.Reg, value)
}
func (o *TC_Type) GetRA0() uint32 {
	return volatile.LoadUint32(&o.RA0.Reg)
}

// TC.RB0: Register B (channel = 0)
func (o *TC_Type) SetRB0(value uint32) {
	volatile.StoreUint32(&o.RB0.Reg, value)
}
func (o *TC_Type) GetRB0() uint32 {
	return volatile.LoadUint32(&o.RB0.Reg)
}

// TC.RC0: Register C (channel = 0)
func (o *TC_Type) SetRC0(value uint32) {
	volatile.StoreUint32(&o.RC0.Reg, value)
}
func (o *TC_Type) GetRC0() uint32 {
	return volatile.LoadUint32(&o.RC0.Reg)
}

// TC.SR0: Status Register (channel = 0)
func (o *TC_Type) SetSR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR0.Reg) & 0x1
}
func (o *TC_Type) SetSR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR0_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR0_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR0_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR0_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR0_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR0.Reg, volatile.LoadUint32(&o.SR0.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR0_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR0.Reg) & 0x40000) >> 18
}

// TC.IER0: Interrupt Enable Register (channel = 0)
func (o *TC_Type) SetIER0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER0.Reg) & 0x1
}
func (o *TC_Type) SetIER0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER0.Reg, volatile.LoadUint32(&o.IER0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER0.Reg) & 0x80) >> 7
}

// TC.IDR0: Interrupt Disable Register (channel = 0)
func (o *TC_Type) SetIDR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR0.Reg) & 0x1
}
func (o *TC_Type) SetIDR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR0.Reg, volatile.LoadUint32(&o.IDR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR0.Reg) & 0x80) >> 7
}

// TC.IMR0: Interrupt Mask Register (channel = 0)
func (o *TC_Type) SetIMR0_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR0_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR0.Reg) & 0x1
}
func (o *TC_Type) SetIMR0_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR0_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR0_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR0_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR0_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR0_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR0_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR0_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR0_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR0_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR0_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR0_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR0_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR0.Reg, volatile.LoadUint32(&o.IMR0.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR0_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR0.Reg) & 0x80) >> 7
}

// TC.CCR1: Channel Control Register (channel = 1)
func (o *TC_Type) SetCCR1_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR1_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR1.Reg) & 0x1
}
func (o *TC_Type) SetCCR1_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR1_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR1_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR1.Reg, volatile.LoadUint32(&o.CCR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR1_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR1.Reg) & 0x4) >> 2
}

// TC.CMR1: Channel Mode Register (channel = 1)
func (o *TC_Type) SetCMR1_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR1_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0x7
}
func (o *TC_Type) SetCMR1_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR1_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR1_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR1_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR1_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR1_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR1_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR1_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR1_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR1_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR1_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR1_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR1_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR1_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR1_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR1_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR1_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR1_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR1_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR1_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0xc0000) >> 18
}

// TC.SMMR1: Stepper Motor Mode Register (channel = 1)
func (o *TC_Type) SetSMMR1_GCEN(value uint32) {
	volatile.StoreUint32(&o.SMMR1.Reg, volatile.LoadUint32(&o.SMMR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSMMR1_GCEN() uint32 {
	return volatile.LoadUint32(&o.SMMR1.Reg) & 0x1
}
func (o *TC_Type) SetSMMR1_DOWN(value uint32) {
	volatile.StoreUint32(&o.SMMR1.Reg, volatile.LoadUint32(&o.SMMR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSMMR1_DOWN() uint32 {
	return (volatile.LoadUint32(&o.SMMR1.Reg) & 0x2) >> 1
}

// TC.CV1: Counter Value (channel = 1)
func (o *TC_Type) SetCV1(value uint32) {
	volatile.StoreUint32(&o.CV1.Reg, value)
}
func (o *TC_Type) GetCV1() uint32 {
	return volatile.LoadUint32(&o.CV1.Reg)
}

// TC.RA1: Register A (channel = 1)
func (o *TC_Type) SetRA1(value uint32) {
	volatile.StoreUint32(&o.RA1.Reg, value)
}
func (o *TC_Type) GetRA1() uint32 {
	return volatile.LoadUint32(&o.RA1.Reg)
}

// TC.RB1: Register B (channel = 1)
func (o *TC_Type) SetRB1(value uint32) {
	volatile.StoreUint32(&o.RB1.Reg, value)
}
func (o *TC_Type) GetRB1() uint32 {
	return volatile.LoadUint32(&o.RB1.Reg)
}

// TC.RC1: Register C (channel = 1)
func (o *TC_Type) SetRC1(value uint32) {
	volatile.StoreUint32(&o.RC1.Reg, value)
}
func (o *TC_Type) GetRC1() uint32 {
	return volatile.LoadUint32(&o.RC1.Reg)
}

// TC.SR1: Status Register (channel = 1)
func (o *TC_Type) SetSR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR1.Reg) & 0x1
}
func (o *TC_Type) SetSR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR1_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR1_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR1_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR1_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR1_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR1.Reg, volatile.LoadUint32(&o.SR1.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR1_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR1.Reg) & 0x40000) >> 18
}

// TC.IER1: Interrupt Enable Register (channel = 1)
func (o *TC_Type) SetIER1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER1.Reg) & 0x1
}
func (o *TC_Type) SetIER1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER1.Reg, volatile.LoadUint32(&o.IER1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER1.Reg) & 0x80) >> 7
}

// TC.IDR1: Interrupt Disable Register (channel = 1)
func (o *TC_Type) SetIDR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR1.Reg) & 0x1
}
func (o *TC_Type) SetIDR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR1.Reg, volatile.LoadUint32(&o.IDR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR1.Reg) & 0x80) >> 7
}

// TC.IMR1: Interrupt Mask Register (channel = 1)
func (o *TC_Type) SetIMR1_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR1_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR1.Reg) & 0x1
}
func (o *TC_Type) SetIMR1_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR1_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR1_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR1_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR1_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR1_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR1_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR1_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR1_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR1_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR1_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR1_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR1_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR1.Reg, volatile.LoadUint32(&o.IMR1.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR1_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR1.Reg) & 0x80) >> 7
}

// TC.CCR2: Channel Control Register (channel = 2)
func (o *TC_Type) SetCCR2_CLKEN(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetCCR2_CLKEN() uint32 {
	return volatile.LoadUint32(&o.CCR2.Reg) & 0x1
}
func (o *TC_Type) SetCCR2_CLKDIS(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetCCR2_CLKDIS() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetCCR2_SWTRG(value uint32) {
	volatile.StoreUint32(&o.CCR2.Reg, volatile.LoadUint32(&o.CCR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetCCR2_SWTRG() uint32 {
	return (volatile.LoadUint32(&o.CCR2.Reg) & 0x4) >> 2
}

// TC.CMR2: Channel Mode Register (channel = 2)
func (o *TC_Type) SetCMR2_TCCLKS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x7)|value)
}
func (o *TC_Type) GetCMR2_TCCLKS() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0x7
}
func (o *TC_Type) SetCMR2_CLKI(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetCMR2_CLKI() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetCMR2_BURST(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetCMR2_BURST() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetCMR2_LDBSTOP(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetCMR2_LDBSTOP() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetCMR2_LDBDIS(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetCMR2_LDBDIS() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetCMR2_ETRGEDG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x300)|value<<8)
}
func (o *TC_Type) GetCMR2_ETRGEDG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x300) >> 8
}
func (o *TC_Type) SetCMR2_ABETRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetCMR2_ABETRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetCMR2_CPCTRG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetCMR2_CPCTRG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetCMR2_WAVE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetCMR2_WAVE() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetCMR2_LDRA(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x30000)|value<<16)
}
func (o *TC_Type) GetCMR2_LDRA() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x30000) >> 16
}
func (o *TC_Type) SetCMR2_LDRB(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xc0000)|value<<18)
}
func (o *TC_Type) GetCMR2_LDRB() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0xc0000) >> 18
}

// TC.SMMR2: Stepper Motor Mode Register (channel = 2)
func (o *TC_Type) SetSMMR2_GCEN(value uint32) {
	volatile.StoreUint32(&o.SMMR2.Reg, volatile.LoadUint32(&o.SMMR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSMMR2_GCEN() uint32 {
	return volatile.LoadUint32(&o.SMMR2.Reg) & 0x1
}
func (o *TC_Type) SetSMMR2_DOWN(value uint32) {
	volatile.StoreUint32(&o.SMMR2.Reg, volatile.LoadUint32(&o.SMMR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSMMR2_DOWN() uint32 {
	return (volatile.LoadUint32(&o.SMMR2.Reg) & 0x2) >> 1
}

// TC.CV2: Counter Value (channel = 2)
func (o *TC_Type) SetCV2(value uint32) {
	volatile.StoreUint32(&o.CV2.Reg, value)
}
func (o *TC_Type) GetCV2() uint32 {
	return volatile.LoadUint32(&o.CV2.Reg)
}

// TC.RA2: Register A (channel = 2)
func (o *TC_Type) SetRA2(value uint32) {
	volatile.StoreUint32(&o.RA2.Reg, value)
}
func (o *TC_Type) GetRA2() uint32 {
	return volatile.LoadUint32(&o.RA2.Reg)
}

// TC.RB2: Register B (channel = 2)
func (o *TC_Type) SetRB2(value uint32) {
	volatile.StoreUint32(&o.RB2.Reg, value)
}
func (o *TC_Type) GetRB2() uint32 {
	return volatile.LoadUint32(&o.RB2.Reg)
}

// TC.RC2: Register C (channel = 2)
func (o *TC_Type) SetRC2(value uint32) {
	volatile.StoreUint32(&o.RC2.Reg, value)
}
func (o *TC_Type) GetRC2() uint32 {
	return volatile.LoadUint32(&o.RC2.Reg)
}

// TC.SR2: Status Register (channel = 2)
func (o *TC_Type) SetSR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetSR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.SR2.Reg) & 0x1
}
func (o *TC_Type) SetSR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetSR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetSR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetSR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetSR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetSR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetSR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetSR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetSR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetSR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetSR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetSR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetSR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetSR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x80) >> 7
}
func (o *TC_Type) SetSR2_CLKSTA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetSR2_CLKSTA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetSR2_MTIOA(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetSR2_MTIOA() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetSR2_MTIOB(value uint32) {
	volatile.StoreUint32(&o.SR2.Reg, volatile.LoadUint32(&o.SR2.Reg)&^(0x40000)|value<<18)
}
func (o *TC_Type) GetSR2_MTIOB() uint32 {
	return (volatile.LoadUint32(&o.SR2.Reg) & 0x40000) >> 18
}

// TC.IER2: Interrupt Enable Register (channel = 2)
func (o *TC_Type) SetIER2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIER2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IER2.Reg) & 0x1
}
func (o *TC_Type) SetIER2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIER2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIER2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIER2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIER2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIER2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIER2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIER2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIER2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIER2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIER2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIER2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIER2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IER2.Reg, volatile.LoadUint32(&o.IER2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIER2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IER2.Reg) & 0x80) >> 7
}

// TC.IDR2: Interrupt Disable Register (channel = 2)
func (o *TC_Type) SetIDR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIDR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IDR2.Reg) & 0x1
}
func (o *TC_Type) SetIDR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIDR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIDR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIDR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIDR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIDR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIDR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIDR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIDR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIDR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIDR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIDR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIDR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IDR2.Reg, volatile.LoadUint32(&o.IDR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIDR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IDR2.Reg) & 0x80) >> 7
}

// TC.IMR2: Interrupt Mask Register (channel = 2)
func (o *TC_Type) SetIMR2_COVFS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetIMR2_COVFS() uint32 {
	return volatile.LoadUint32(&o.IMR2.Reg) & 0x1
}
func (o *TC_Type) SetIMR2_LOVRS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetIMR2_LOVRS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetIMR2_CPAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetIMR2_CPAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetIMR2_CPBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x8)|value<<3)
}
func (o *TC_Type) GetIMR2_CPBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x8) >> 3
}
func (o *TC_Type) SetIMR2_CPCS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x10)|value<<4)
}
func (o *TC_Type) GetIMR2_CPCS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x10) >> 4
}
func (o *TC_Type) SetIMR2_LDRAS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x20)|value<<5)
}
func (o *TC_Type) GetIMR2_LDRAS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x20) >> 5
}
func (o *TC_Type) SetIMR2_LDRBS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x40)|value<<6)
}
func (o *TC_Type) GetIMR2_LDRBS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x40) >> 6
}
func (o *TC_Type) SetIMR2_ETRGS(value uint32) {
	volatile.StoreUint32(&o.IMR2.Reg, volatile.LoadUint32(&o.IMR2.Reg)&^(0x80)|value<<7)
}
func (o *TC_Type) GetIMR2_ETRGS() uint32 {
	return (volatile.LoadUint32(&o.IMR2.Reg) & 0x80) >> 7
}

// TC.BCR: Block Control Register
func (o *TC_Type) SetBCR_SYNC(value uint32) {
	volatile.StoreUint32(&o.BCR.Reg, volatile.LoadUint32(&o.BCR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetBCR_SYNC() uint32 {
	return volatile.LoadUint32(&o.BCR.Reg) & 0x1
}

// TC.BMR: Block Mode Register
func (o *TC_Type) SetBMR_TC0XC0S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3)|value)
}
func (o *TC_Type) GetBMR_TC0XC0S() uint32 {
	return volatile.LoadUint32(&o.BMR.Reg) & 0x3
}
func (o *TC_Type) SetBMR_TC1XC1S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0xc)|value<<2)
}
func (o *TC_Type) GetBMR_TC1XC1S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0xc) >> 2
}
func (o *TC_Type) SetBMR_TC2XC2S(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x30)|value<<4)
}
func (o *TC_Type) GetBMR_TC2XC2S() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x30) >> 4
}
func (o *TC_Type) SetBMR_QDEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x100)|value<<8)
}
func (o *TC_Type) GetBMR_QDEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x100) >> 8
}
func (o *TC_Type) SetBMR_POSEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x200)|value<<9)
}
func (o *TC_Type) GetBMR_POSEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x200) >> 9
}
func (o *TC_Type) SetBMR_SPEEDEN(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x400)|value<<10)
}
func (o *TC_Type) GetBMR_SPEEDEN() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x400) >> 10
}
func (o *TC_Type) SetBMR_QDTRANS(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x800)|value<<11)
}
func (o *TC_Type) GetBMR_QDTRANS() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x800) >> 11
}
func (o *TC_Type) SetBMR_EDGPHA(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x1000)|value<<12)
}
func (o *TC_Type) GetBMR_EDGPHA() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x1000) >> 12
}
func (o *TC_Type) SetBMR_INVA(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x2000)|value<<13)
}
func (o *TC_Type) GetBMR_INVA() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x2000) >> 13
}
func (o *TC_Type) SetBMR_INVB(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x4000)|value<<14)
}
func (o *TC_Type) GetBMR_INVB() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x4000) >> 14
}
func (o *TC_Type) SetBMR_INVIDX(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x8000)|value<<15)
}
func (o *TC_Type) GetBMR_INVIDX() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x8000) >> 15
}
func (o *TC_Type) SetBMR_SWAP(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x10000)|value<<16)
}
func (o *TC_Type) GetBMR_SWAP() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x10000) >> 16
}
func (o *TC_Type) SetBMR_IDXPHB(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x20000)|value<<17)
}
func (o *TC_Type) GetBMR_IDXPHB() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x20000) >> 17
}
func (o *TC_Type) SetBMR_MAXFILT(value uint32) {
	volatile.StoreUint32(&o.BMR.Reg, volatile.LoadUint32(&o.BMR.Reg)&^(0x3f00000)|value<<20)
}
func (o *TC_Type) GetBMR_MAXFILT() uint32 {
	return (volatile.LoadUint32(&o.BMR.Reg) & 0x3f00000) >> 20
}

// TC.QIER: QDEC Interrupt Enable Register
func (o *TC_Type) SetQIER_IDX(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIER_IDX() uint32 {
	return volatile.LoadUint32(&o.QIER.Reg) & 0x1
}
func (o *TC_Type) SetQIER_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIER_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIER.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIER_QERR(value uint32) {
	volatile.StoreUint32(&o.QIER.Reg, volatile.LoadUint32(&o.QIER.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIER_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIER.Reg) & 0x4) >> 2
}

// TC.QIDR: QDEC Interrupt Disable Register
func (o *TC_Type) SetQIDR_IDX(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIDR_IDX() uint32 {
	return volatile.LoadUint32(&o.QIDR.Reg) & 0x1
}
func (o *TC_Type) SetQIDR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIDR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIDR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIDR_QERR(value uint32) {
	volatile.StoreUint32(&o.QIDR.Reg, volatile.LoadUint32(&o.QIDR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIDR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIDR.Reg) & 0x4) >> 2
}

// TC.QIMR: QDEC Interrupt Mask Register
func (o *TC_Type) SetQIMR_IDX(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQIMR_IDX() uint32 {
	return volatile.LoadUint32(&o.QIMR.Reg) & 0x1
}
func (o *TC_Type) SetQIMR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQIMR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QIMR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQIMR_QERR(value uint32) {
	volatile.StoreUint32(&o.QIMR.Reg, volatile.LoadUint32(&o.QIMR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQIMR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QIMR.Reg) & 0x4) >> 2
}

// TC.QISR: QDEC Interrupt Status Register
func (o *TC_Type) SetQISR_IDX(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetQISR_IDX() uint32 {
	return volatile.LoadUint32(&o.QISR.Reg) & 0x1
}
func (o *TC_Type) SetQISR_DIRCHG(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x2)|value<<1)
}
func (o *TC_Type) GetQISR_DIRCHG() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x2) >> 1
}
func (o *TC_Type) SetQISR_QERR(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x4)|value<<2)
}
func (o *TC_Type) GetQISR_QERR() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x4) >> 2
}
func (o *TC_Type) SetQISR_DIR(value uint32) {
	volatile.StoreUint32(&o.QISR.Reg, volatile.LoadUint32(&o.QISR.Reg)&^(0x100)|value<<8)
}
func (o *TC_Type) GetQISR_DIR() uint32 {
	return (volatile.LoadUint32(&o.QISR.Reg) & 0x100) >> 8
}

// TC.WPMR: Write Protection Mode Register
func (o *TC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *TC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *TC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *TC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// Two-wire Interface 0
type TWI_Type struct {
	CR   volatile.Register32 // 0x0
	MMR  volatile.Register32 // 0x4
	SMR  volatile.Register32 // 0x8
	IADR volatile.Register32 // 0xC
	CWGR volatile.Register32 // 0x10
	_    [12]byte
	SR   volatile.Register32 // 0x20
	IER  volatile.Register32 // 0x24
	IDR  volatile.Register32 // 0x28
	IMR  volatile.Register32 // 0x2C
	RHR  volatile.Register32 // 0x30
	THR  volatile.Register32 // 0x34
	_    [200]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// TWI.CR: Control Register
func (o *TWI_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetCR_START() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *TWI_Type) SetCR_STOP(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetCR_STOP() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetCR_MSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetCR_MSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetCR_MSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetCR_MSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetCR_SVEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetCR_SVEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetCR_SVDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetCR_SVDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetCR_QUICK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetCR_QUICK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *TWI_Type) GetCR_SWRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}

// TWI.MMR: Master Mode Register
func (o *TWI_Type) SetMMR_IADRSZ(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x300)|value<<8)
}
func (o *TWI_Type) GetMMR_IADRSZ() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x300) >> 8
}
func (o *TWI_Type) SetMMR_MREAD(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetMMR_MREAD() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetMMR_DADR(value uint32) {
	volatile.StoreUint32(&o.MMR.Reg, volatile.LoadUint32(&o.MMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetMMR_DADR() uint32 {
	return (volatile.LoadUint32(&o.MMR.Reg) & 0x7f0000) >> 16
}

// TWI.SMR: Slave Mode Register
func (o *TWI_Type) SetSMR_SADR(value uint32) {
	volatile.StoreUint32(&o.SMR.Reg, volatile.LoadUint32(&o.SMR.Reg)&^(0x7f0000)|value<<16)
}
func (o *TWI_Type) GetSMR_SADR() uint32 {
	return (volatile.LoadUint32(&o.SMR.Reg) & 0x7f0000) >> 16
}

// TWI.IADR: Internal Address Register
func (o *TWI_Type) SetIADR(value uint32) {
	volatile.StoreUint32(&o.IADR.Reg, volatile.LoadUint32(&o.IADR.Reg)&^(0xffffff)|value)
}
func (o *TWI_Type) GetIADR() uint32 {
	return volatile.LoadUint32(&o.IADR.Reg) & 0xffffff
}

// TWI.CWGR: Clock Waveform Generator Register
func (o *TWI_Type) SetCWGR_CLDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetCWGR_CLDIV() uint32 {
	return volatile.LoadUint32(&o.CWGR.Reg) & 0xff
}
func (o *TWI_Type) SetCWGR_CHDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0xff00)|value<<8)
}
func (o *TWI_Type) GetCWGR_CHDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0xff00) >> 8
}
func (o *TWI_Type) SetCWGR_CKDIV(value uint32) {
	volatile.StoreUint32(&o.CWGR.Reg, volatile.LoadUint32(&o.CWGR.Reg)&^(0x70000)|value<<16)
}
func (o *TWI_Type) GetCWGR_CKDIV() uint32 {
	return (volatile.LoadUint32(&o.CWGR.Reg) & 0x70000) >> 16
}

// TWI.SR: Status Register
func (o *TWI_Type) SetSR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetSR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *TWI_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetSR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetSR_SVREAD(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *TWI_Type) GetSR_SVREAD() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *TWI_Type) SetSR_SVACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetSR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetSR_GACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetSR_GACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetSR_NACK(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetSR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetSR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetSR_SCLWS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetSR_SCLWS() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetSR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetSR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8000) >> 15
}

// TWI.IER: Interrupt Enable Register
func (o *TWI_Type) SetIER_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIER_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *TWI_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIER_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIER_SVACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIER_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIER_GACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIER_GACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIER_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIER_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIER_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIER_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIER_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIER_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}

// TWI.IDR: Interrupt Disable Register
func (o *TWI_Type) SetIDR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIDR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *TWI_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIDR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIDR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIDR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIDR_GACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIDR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIDR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIDR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIDR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIDR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIDR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIDR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}

// TWI.IMR: Interrupt Mask Register
func (o *TWI_Type) SetIMR_TXCOMP(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetIMR_TXCOMP() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *TWI_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetIMR_RXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *TWI_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *TWI_Type) SetIMR_SVACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *TWI_Type) GetIMR_SVACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *TWI_Type) SetIMR_GACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *TWI_Type) GetIMR_GACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *TWI_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *TWI_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *TWI_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetIMR_ARBLST(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetIMR_ARBLST() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *TWI_Type) SetIMR_SCL_WS(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *TWI_Type) GetIMR_SCL_WS() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *TWI_Type) SetIMR_EOSACC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *TWI_Type) GetIMR_EOSACC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *TWI_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *TWI_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *TWI_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *TWI_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *TWI_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *TWI_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *TWI_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *TWI_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}

// TWI.RHR: Receive Holding Register
func (o *TWI_Type) SetRHR_RXDATA(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetRHR_RXDATA() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// TWI.THR: Transmit Holding Register
func (o *TWI_Type) SetTHR_TXDATA(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *TWI_Type) GetTHR_TXDATA() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// TWI.RPR: Receive Pointer Register
func (o *TWI_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *TWI_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// TWI.RCR: Receive Counter Register
func (o *TWI_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// TWI.TPR: Transmit Pointer Register
func (o *TWI_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *TWI_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// TWI.TCR: Transmit Counter Register
func (o *TWI_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// TWI.RNPR: Receive Next Pointer Register
func (o *TWI_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *TWI_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// TWI.RNCR: Receive Next Counter Register
func (o *TWI_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// TWI.TNPR: Transmit Next Pointer Register
func (o *TWI_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *TWI_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// TWI.TNCR: Transmit Next Counter Register
func (o *TWI_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *TWI_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// TWI.PTCR: Transfer Control Register
func (o *TWI_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *TWI_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *TWI_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *TWI_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *TWI_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *TWI_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// TWI.PTSR: Transfer Status Register
func (o *TWI_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *TWI_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *TWI_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *TWI_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Pulse Width Modulation Controller
type PWM_Type struct {
	MR    volatile.Register32 // 0x0
	ENA   volatile.Register32 // 0x4
	DIS   volatile.Register32 // 0x8
	SR    volatile.Register32 // 0xC
	IER   volatile.Register32 // 0x10
	IDR   volatile.Register32 // 0x14
	IMR   volatile.Register32 // 0x18
	ISR   volatile.Register32 // 0x1C
	_     [480]byte
	CMR0  volatile.Register32 // 0x200
	CDTY0 volatile.Register32 // 0x204
	CPRD0 volatile.Register32 // 0x208
	CCNT0 volatile.Register32 // 0x20C
	CUPD0 volatile.Register32 // 0x210
	_     [12]byte
	CMR1  volatile.Register32 // 0x220
	CDTY1 volatile.Register32 // 0x224
	CPRD1 volatile.Register32 // 0x228
	CCNT1 volatile.Register32 // 0x22C
	CUPD1 volatile.Register32 // 0x230
	_     [12]byte
	CMR2  volatile.Register32 // 0x240
	CDTY2 volatile.Register32 // 0x244
	CPRD2 volatile.Register32 // 0x248
	CCNT2 volatile.Register32 // 0x24C
	CUPD2 volatile.Register32 // 0x250
	_     [12]byte
	CMR3  volatile.Register32 // 0x260
	CDTY3 volatile.Register32 // 0x264
	CPRD3 volatile.Register32 // 0x268
	CCNT3 volatile.Register32 // 0x26C
	CUPD3 volatile.Register32 // 0x270
}

// PWM.MR: PWM Mode Register
func (o *PWM_Type) SetMR_DIVA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff)|value)
}
func (o *PWM_Type) GetMR_DIVA() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xff
}
func (o *PWM_Type) SetMR_PREA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00)|value<<8)
}
func (o *PWM_Type) GetMR_PREA() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00) >> 8
}
func (o *PWM_Type) SetMR_DIVB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff0000)|value<<16)
}
func (o *PWM_Type) GetMR_DIVB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff0000) >> 16
}
func (o *PWM_Type) SetMR_PREB(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *PWM_Type) GetMR_PREB() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}

// PWM.ENA: PWM Enable Register
func (o *PWM_Type) SetENA_CHID0(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetENA_CHID0() uint32 {
	return volatile.LoadUint32(&o.ENA.Reg) & 0x1
}
func (o *PWM_Type) SetENA_CHID1(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetENA_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetENA_CHID2(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetENA_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetENA_CHID3(value uint32) {
	volatile.StoreUint32(&o.ENA.Reg, volatile.LoadUint32(&o.ENA.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetENA_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ENA.Reg) & 0x8) >> 3
}

// PWM.DIS: PWM Disable Register
func (o *PWM_Type) SetDIS_CHID0(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetDIS_CHID0() uint32 {
	return volatile.LoadUint32(&o.DIS.Reg) & 0x1
}
func (o *PWM_Type) SetDIS_CHID1(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetDIS_CHID1() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetDIS_CHID2(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetDIS_CHID2() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetDIS_CHID3(value uint32) {
	volatile.StoreUint32(&o.DIS.Reg, volatile.LoadUint32(&o.DIS.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetDIS_CHID3() uint32 {
	return (volatile.LoadUint32(&o.DIS.Reg) & 0x8) >> 3
}

// PWM.SR: PWM Status Register
func (o *PWM_Type) SetSR_CHID0(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetSR_CHID0() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *PWM_Type) SetSR_CHID1(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetSR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetSR_CHID2(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetSR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetSR_CHID3(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetSR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}

// PWM.IER: PWM Interrupt Enable Register
func (o *PWM_Type) SetIER_CHID0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIER_CHID0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PWM_Type) SetIER_CHID1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIER_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIER_CHID2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIER_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIER_CHID3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIER_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}

// PWM.IDR: PWM Interrupt Disable Register
func (o *PWM_Type) SetIDR_CHID0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIDR_CHID0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PWM_Type) SetIDR_CHID1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIDR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIDR_CHID2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIDR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIDR_CHID3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIDR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}

// PWM.IMR: PWM Interrupt Mask Register
func (o *PWM_Type) SetIMR_CHID0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetIMR_CHID0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PWM_Type) SetIMR_CHID1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetIMR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetIMR_CHID2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetIMR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetIMR_CHID3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetIMR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}

// PWM.ISR: PWM Interrupt Status Register
func (o *PWM_Type) SetISR_CHID0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *PWM_Type) GetISR_CHID0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *PWM_Type) SetISR_CHID1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *PWM_Type) GetISR_CHID1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *PWM_Type) SetISR_CHID2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *PWM_Type) GetISR_CHID2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *PWM_Type) SetISR_CHID3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *PWM_Type) GetISR_CHID3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}

// PWM.CMR0: PWM Channel Mode Register (ch_num = 0)
func (o *PWM_Type) SetCMR0_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR0_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR0.Reg) & 0xf
}
func (o *PWM_Type) SetCMR0_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR0_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR0_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR0_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR0_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR0.Reg, volatile.LoadUint32(&o.CMR0.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR0_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR0.Reg) & 0x400) >> 10
}

// PWM.CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
func (o *PWM_Type) SetCDTY0(value uint32) {
	volatile.StoreUint32(&o.CDTY0.Reg, value)
}
func (o *PWM_Type) GetCDTY0() uint32 {
	return volatile.LoadUint32(&o.CDTY0.Reg)
}

// PWM.CPRD0: PWM Channel Period Register (ch_num = 0)
func (o *PWM_Type) SetCPRD0(value uint32) {
	volatile.StoreUint32(&o.CPRD0.Reg, value)
}
func (o *PWM_Type) GetCPRD0() uint32 {
	return volatile.LoadUint32(&o.CPRD0.Reg)
}

// PWM.CCNT0: PWM Channel Counter Register (ch_num = 0)
func (o *PWM_Type) SetCCNT0(value uint32) {
	volatile.StoreUint32(&o.CCNT0.Reg, value)
}
func (o *PWM_Type) GetCCNT0() uint32 {
	return volatile.LoadUint32(&o.CCNT0.Reg)
}

// PWM.CUPD0: PWM Channel Update Register (ch_num = 0)
func (o *PWM_Type) SetCUPD0(value uint32) {
	volatile.StoreUint32(&o.CUPD0.Reg, value)
}
func (o *PWM_Type) GetCUPD0() uint32 {
	return volatile.LoadUint32(&o.CUPD0.Reg)
}

// PWM.CMR1: PWM Channel Mode Register (ch_num = 1)
func (o *PWM_Type) SetCMR1_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR1_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR1.Reg) & 0xf
}
func (o *PWM_Type) SetCMR1_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR1_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR1_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR1_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR1_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR1.Reg, volatile.LoadUint32(&o.CMR1.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR1_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR1.Reg) & 0x400) >> 10
}

// PWM.CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
func (o *PWM_Type) SetCDTY1(value uint32) {
	volatile.StoreUint32(&o.CDTY1.Reg, value)
}
func (o *PWM_Type) GetCDTY1() uint32 {
	return volatile.LoadUint32(&o.CDTY1.Reg)
}

// PWM.CPRD1: PWM Channel Period Register (ch_num = 1)
func (o *PWM_Type) SetCPRD1(value uint32) {
	volatile.StoreUint32(&o.CPRD1.Reg, value)
}
func (o *PWM_Type) GetCPRD1() uint32 {
	return volatile.LoadUint32(&o.CPRD1.Reg)
}

// PWM.CCNT1: PWM Channel Counter Register (ch_num = 1)
func (o *PWM_Type) SetCCNT1(value uint32) {
	volatile.StoreUint32(&o.CCNT1.Reg, value)
}
func (o *PWM_Type) GetCCNT1() uint32 {
	return volatile.LoadUint32(&o.CCNT1.Reg)
}

// PWM.CUPD1: PWM Channel Update Register (ch_num = 1)
func (o *PWM_Type) SetCUPD1(value uint32) {
	volatile.StoreUint32(&o.CUPD1.Reg, value)
}
func (o *PWM_Type) GetCUPD1() uint32 {
	return volatile.LoadUint32(&o.CUPD1.Reg)
}

// PWM.CMR2: PWM Channel Mode Register (ch_num = 2)
func (o *PWM_Type) SetCMR2_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR2_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR2.Reg) & 0xf
}
func (o *PWM_Type) SetCMR2_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR2_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR2_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR2_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR2_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR2.Reg, volatile.LoadUint32(&o.CMR2.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR2_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR2.Reg) & 0x400) >> 10
}

// PWM.CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
func (o *PWM_Type) SetCDTY2(value uint32) {
	volatile.StoreUint32(&o.CDTY2.Reg, value)
}
func (o *PWM_Type) GetCDTY2() uint32 {
	return volatile.LoadUint32(&o.CDTY2.Reg)
}

// PWM.CPRD2: PWM Channel Period Register (ch_num = 2)
func (o *PWM_Type) SetCPRD2(value uint32) {
	volatile.StoreUint32(&o.CPRD2.Reg, value)
}
func (o *PWM_Type) GetCPRD2() uint32 {
	return volatile.LoadUint32(&o.CPRD2.Reg)
}

// PWM.CCNT2: PWM Channel Counter Register (ch_num = 2)
func (o *PWM_Type) SetCCNT2(value uint32) {
	volatile.StoreUint32(&o.CCNT2.Reg, value)
}
func (o *PWM_Type) GetCCNT2() uint32 {
	return volatile.LoadUint32(&o.CCNT2.Reg)
}

// PWM.CUPD2: PWM Channel Update Register (ch_num = 2)
func (o *PWM_Type) SetCUPD2(value uint32) {
	volatile.StoreUint32(&o.CUPD2.Reg, value)
}
func (o *PWM_Type) GetCUPD2() uint32 {
	return volatile.LoadUint32(&o.CUPD2.Reg)
}

// PWM.CMR3: PWM Channel Mode Register (ch_num = 3)
func (o *PWM_Type) SetCMR3_CPRE(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0xf)|value)
}
func (o *PWM_Type) GetCMR3_CPRE() uint32 {
	return volatile.LoadUint32(&o.CMR3.Reg) & 0xf
}
func (o *PWM_Type) SetCMR3_CALG(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x100)|value<<8)
}
func (o *PWM_Type) GetCMR3_CALG() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x100) >> 8
}
func (o *PWM_Type) SetCMR3_CPOL(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x200)|value<<9)
}
func (o *PWM_Type) GetCMR3_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x200) >> 9
}
func (o *PWM_Type) SetCMR3_CPD(value uint32) {
	volatile.StoreUint32(&o.CMR3.Reg, volatile.LoadUint32(&o.CMR3.Reg)&^(0x400)|value<<10)
}
func (o *PWM_Type) GetCMR3_CPD() uint32 {
	return (volatile.LoadUint32(&o.CMR3.Reg) & 0x400) >> 10
}

// PWM.CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
func (o *PWM_Type) SetCDTY3(value uint32) {
	volatile.StoreUint32(&o.CDTY3.Reg, value)
}
func (o *PWM_Type) GetCDTY3() uint32 {
	return volatile.LoadUint32(&o.CDTY3.Reg)
}

// PWM.CPRD3: PWM Channel Period Register (ch_num = 3)
func (o *PWM_Type) SetCPRD3(value uint32) {
	volatile.StoreUint32(&o.CPRD3.Reg, value)
}
func (o *PWM_Type) GetCPRD3() uint32 {
	return volatile.LoadUint32(&o.CPRD3.Reg)
}

// PWM.CCNT3: PWM Channel Counter Register (ch_num = 3)
func (o *PWM_Type) SetCCNT3(value uint32) {
	volatile.StoreUint32(&o.CCNT3.Reg, value)
}
func (o *PWM_Type) GetCCNT3() uint32 {
	return volatile.LoadUint32(&o.CCNT3.Reg)
}

// PWM.CUPD3: PWM Channel Update Register (ch_num = 3)
func (o *PWM_Type) SetCUPD3(value uint32) {
	volatile.StoreUint32(&o.CUPD3.Reg, value)
}
func (o *PWM_Type) GetCUPD3() uint32 {
	return volatile.LoadUint32(&o.CUPD3.Reg)
}

// Universal Synchronous Asynchronous Receiver Transmitter 0
type USART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	CSR  volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	RTOR volatile.Register32 // 0x24
	TTGR volatile.Register32 // 0x28
	_    [20]byte
	FIDI volatile.Register32 // 0x40
	NER  volatile.Register32 // 0x44
	_    [4]byte
	IF   volatile.Register32 // 0x4C
	_    [148]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [20]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// USART.CR: Control Register
func (o *USART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCR_STTBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCR_STTBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCR_STPBRK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCR_STPBRK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCR_STTTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCR_STTTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCR_SENDA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCR_SENDA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCR_RSTIT(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCR_RSTIT() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCR_RSTNACK(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4000)|value<<14)
}
func (o *USART_Type) GetCR_RSTNACK() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4000) >> 14
}
func (o *USART_Type) SetCR_RETTO(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetCR_RETTO() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8000) >> 15
}
func (o *USART_Type) SetCR_RTSEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetCR_RTSEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetCR_RTSDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCR_RTSDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80000) >> 19
}

// USART.MR: Mode Register
func (o *USART_Type) SetMR_USART_MODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf)|value)
}
func (o *USART_Type) GetMR_USART_MODE() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0xf
}
func (o *USART_Type) SetMR_USCLKS(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x30)|value<<4)
}
func (o *USART_Type) GetMR_USCLKS() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x30) >> 4
}
func (o *USART_Type) SetMR_CHRL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc0)|value<<6)
}
func (o *USART_Type) GetMR_CHRL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc0) >> 6
}
func (o *USART_Type) SetMR_SYNC(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetMR_SYNC() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *USART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *USART_Type) SetMR_NBSTOP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x3000)|value<<12)
}
func (o *USART_Type) GetMR_NBSTOP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x3000) >> 12
}
func (o *USART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *USART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}
func (o *USART_Type) SetMR_MSBF(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000)|value<<16)
}
func (o *USART_Type) GetMR_MSBF() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000) >> 16
}
func (o *USART_Type) SetMR_MODE9(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20000)|value<<17)
}
func (o *USART_Type) GetMR_MODE9() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20000) >> 17
}
func (o *USART_Type) SetMR_CLKO(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40000)|value<<18)
}
func (o *USART_Type) GetMR_CLKO() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40000) >> 18
}
func (o *USART_Type) SetMR_OVER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetMR_OVER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetMR_INACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x100000)|value<<20)
}
func (o *USART_Type) GetMR_INACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x100000) >> 20
}
func (o *USART_Type) SetMR_DSNACK(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x200000)|value<<21)
}
func (o *USART_Type) GetMR_DSNACK() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x200000) >> 21
}
func (o *USART_Type) SetMR_INVDATA(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetMR_INVDATA() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x800000) >> 23
}
func (o *USART_Type) SetMR_MAX_ITERATION(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x7000000)|value<<24)
}
func (o *USART_Type) GetMR_MAX_ITERATION() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x7000000) >> 24
}
func (o *USART_Type) SetMR_FILTER(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10000000)|value<<28)
}
func (o *USART_Type) GetMR_FILTER() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10000000) >> 28
}

// USART.IER: Interrupt Enable Register
func (o *USART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *USART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIER_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIER_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIER_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIER_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIER_ITER(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIER_ITER() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIER_NACK(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIER_NACK() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIER_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIER_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}

// USART.IDR: Interrupt Disable Register
func (o *USART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *USART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIDR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIDR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIDR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIDR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIDR_ITER(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIDR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIDR_NACK(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIDR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIDR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIDR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}

// USART.IMR: Interrupt Mask Register
func (o *USART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *USART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetIMR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetIMR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetIMR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetIMR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetIMR_ITER(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetIMR_ITER() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetIMR_NACK(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetIMR_NACK() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetIMR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetIMR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}

// USART.CSR: Channel Status Register
func (o *USART_Type) SetCSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetCSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.CSR.Reg) & 0x1
}
func (o *USART_Type) SetCSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetCSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetCSR_RXBRK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x4)|value<<2)
}
func (o *USART_Type) GetCSR_RXBRK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x4) >> 2
}
func (o *USART_Type) SetCSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x8)|value<<3)
}
func (o *USART_Type) GetCSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x8) >> 3
}
func (o *USART_Type) SetCSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x10)|value<<4)
}
func (o *USART_Type) GetCSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x10) >> 4
}
func (o *USART_Type) SetCSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x20)|value<<5)
}
func (o *USART_Type) GetCSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x20) >> 5
}
func (o *USART_Type) SetCSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x40)|value<<6)
}
func (o *USART_Type) GetCSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x40) >> 6
}
func (o *USART_Type) SetCSR_PARE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80)|value<<7)
}
func (o *USART_Type) GetCSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80) >> 7
}
func (o *USART_Type) SetCSR_TIMEOUT(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetCSR_TIMEOUT() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetCSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetCSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x200) >> 9
}
func (o *USART_Type) SetCSR_ITER(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x400)|value<<10)
}
func (o *USART_Type) GetCSR_ITER() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x400) >> 10
}
func (o *USART_Type) SetCSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800)|value<<11)
}
func (o *USART_Type) GetCSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800) >> 11
}
func (o *USART_Type) SetCSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x1000)|value<<12)
}
func (o *USART_Type) GetCSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x1000) >> 12
}
func (o *USART_Type) SetCSR_NACK(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x2000)|value<<13)
}
func (o *USART_Type) GetCSR_NACK() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x2000) >> 13
}
func (o *USART_Type) SetCSR_CTSIC(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x80000)|value<<19)
}
func (o *USART_Type) GetCSR_CTSIC() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x80000) >> 19
}
func (o *USART_Type) SetCSR_CTS(value uint32) {
	volatile.StoreUint32(&o.CSR.Reg, volatile.LoadUint32(&o.CSR.Reg)&^(0x800000)|value<<23)
}
func (o *USART_Type) GetCSR_CTS() uint32 {
	return (volatile.LoadUint32(&o.CSR.Reg) & 0x800000) >> 23
}

// USART.RHR: Receiver Holding Register
func (o *USART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0x1ff
}
func (o *USART_Type) SetRHR_RXSYNH(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetRHR_RXSYNH() uint32 {
	return (volatile.LoadUint32(&o.RHR.Reg) & 0x8000) >> 15
}

// USART.THR: Transmitter Holding Register
func (o *USART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x1ff)|value)
}
func (o *USART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0x1ff
}
func (o *USART_Type) SetTHR_TXSYNH(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0x8000)|value<<15)
}
func (o *USART_Type) GetTHR_TXSYNH() uint32 {
	return (volatile.LoadUint32(&o.THR.Reg) & 0x8000) >> 15
}

// USART.BRGR: Baud Rate Generator Register
func (o *USART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}
func (o *USART_Type) SetBRGR_FP(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0x70000)|value<<16)
}
func (o *USART_Type) GetBRGR_FP() uint32 {
	return (volatile.LoadUint32(&o.BRGR.Reg) & 0x70000) >> 16
}

// USART.RTOR: Receiver Time-out Register
func (o *USART_Type) SetRTOR_TO(value uint32) {
	volatile.StoreUint32(&o.RTOR.Reg, volatile.LoadUint32(&o.RTOR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRTOR_TO() uint32 {
	return volatile.LoadUint32(&o.RTOR.Reg) & 0xffff
}

// USART.TTGR: Transmitter Timeguard Register
func (o *USART_Type) SetTTGR_TG(value uint32) {
	volatile.StoreUint32(&o.TTGR.Reg, volatile.LoadUint32(&o.TTGR.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetTTGR_TG() uint32 {
	return volatile.LoadUint32(&o.TTGR.Reg) & 0xff
}

// USART.FIDI: FI DI Ratio Register
func (o *USART_Type) SetFIDI_FI_DI_RATIO(value uint32) {
	volatile.StoreUint32(&o.FIDI.Reg, volatile.LoadUint32(&o.FIDI.Reg)&^(0x7ff)|value)
}
func (o *USART_Type) GetFIDI_FI_DI_RATIO() uint32 {
	return volatile.LoadUint32(&o.FIDI.Reg) & 0x7ff
}

// USART.NER: Number of Errors Register
func (o *USART_Type) SetNER_NB_ERRORS(value uint32) {
	volatile.StoreUint32(&o.NER.Reg, volatile.LoadUint32(&o.NER.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetNER_NB_ERRORS() uint32 {
	return volatile.LoadUint32(&o.NER.Reg) & 0xff
}

// USART.IF: IrDA Filter Register
func (o *USART_Type) SetIF_IRDA_FILTER(value uint32) {
	volatile.StoreUint32(&o.IF.Reg, volatile.LoadUint32(&o.IF.Reg)&^(0xff)|value)
}
func (o *USART_Type) GetIF_IRDA_FILTER() uint32 {
	return volatile.LoadUint32(&o.IF.Reg) & 0xff
}

// USART.WPMR: Write Protect Mode Register
func (o *USART_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *USART_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *USART_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// USART.WPSR: Write Protect Status Register
func (o *USART_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *USART_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *USART_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// USART.RPR: Receive Pointer Register
func (o *USART_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *USART_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// USART.RCR: Receive Counter Register
func (o *USART_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// USART.TPR: Transmit Pointer Register
func (o *USART_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *USART_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// USART.TCR: Transmit Counter Register
func (o *USART_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// USART.RNPR: Receive Next Pointer Register
func (o *USART_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *USART_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// USART.RNCR: Receive Next Counter Register
func (o *USART_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// USART.TNPR: Transmit Next Pointer Register
func (o *USART_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *USART_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// USART.TNCR: Transmit Next Counter Register
func (o *USART_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *USART_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// USART.PTCR: Transfer Control Register
func (o *USART_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *USART_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *USART_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *USART_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *USART_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *USART_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// USART.PTSR: Transfer Status Register
func (o *USART_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *USART_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *USART_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *USART_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Analog-to-Digital Converter
type ADC_Type struct {
	CR    volatile.Register32 // 0x0
	MR    volatile.Register32 // 0x4
	SEQR1 volatile.Register32 // 0x8
	SEQR2 volatile.Register32 // 0xC
	CHER  volatile.Register32 // 0x10
	CHDR  volatile.Register32 // 0x14
	CHSR  volatile.Register32 // 0x18
	_     [4]byte
	LCDR  volatile.Register32 // 0x20
	IER   volatile.Register32 // 0x24
	IDR   volatile.Register32 // 0x28
	IMR   volatile.Register32 // 0x2C
	ISR   volatile.Register32 // 0x30
	_     [8]byte
	OVER  volatile.Register32 // 0x3C
	EMR   volatile.Register32 // 0x40
	CWR   volatile.Register32 // 0x44
	_     [8]byte
	CDR   [16]volatile.Register32 // 0x50
	_     [84]byte
	WPMR  volatile.Register32 // 0xE4
	WPSR  volatile.Register32 // 0xE8
	_     [20]byte
	RPR   volatile.Register32 // 0x100
	RCR   volatile.Register32 // 0x104
	_     [8]byte
	RNPR  volatile.Register32 // 0x110
	RNCR  volatile.Register32 // 0x114
	_     [8]byte
	PTCR  volatile.Register32 // 0x120
	PTSR  volatile.Register32 // 0x124
}

// ADC.CR: Control Register
func (o *ADC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *ADC_Type) SetCR_START(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCR_START() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x2) >> 1
}

// ADC.MR: Mode Register
func (o *ADC_Type) SetMR_TRGEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetMR_TRGEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *ADC_Type) SetMR_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe)|value<<1)
}
func (o *ADC_Type) GetMR_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe) >> 1
}
func (o *ADC_Type) SetMR_LOWRES(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetMR_LOWRES() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetMR_SLEEP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetMR_SLEEP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetMR_FWUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetMR_FWUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetMR_FREERUN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetMR_FREERUN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetMR_PRESCAL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff00)|value<<8)
}
func (o *ADC_Type) GetMR_PRESCAL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff00) >> 8
}
func (o *ADC_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetMR_TRACKTIM(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetMR_TRACKTIM() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetMR_USEQ(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x80000000)|value<<31)
}
func (o *ADC_Type) GetMR_USEQ() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x80000000) >> 31
}

// ADC.SEQR1: Channel Sequence Register 1
func (o *ADC_Type) SetSEQR1_USCH1(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQR1_USCH1() uint32 {
	return volatile.LoadUint32(&o.SEQR1.Reg) & 0xf
}
func (o *ADC_Type) SetSEQR1_USCH2(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetSEQR1_USCH2() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetSEQR1_USCH3(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetSEQR1_USCH3() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetSEQR1_USCH4(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetSEQR1_USCH4() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf000) >> 12
}
func (o *ADC_Type) SetSEQR1_USCH5(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetSEQR1_USCH5() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetSEQR1_USCH6(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSEQR1_USCH6() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSEQR1_USCH7(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetSEQR1_USCH7() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetSEQR1_USCH8(value uint32) {
	volatile.StoreUint32(&o.SEQR1.Reg, volatile.LoadUint32(&o.SEQR1.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetSEQR1_USCH8() uint32 {
	return (volatile.LoadUint32(&o.SEQR1.Reg) & 0xf0000000) >> 28
}

// ADC.SEQR2: Channel Sequence Register 2
func (o *ADC_Type) SetSEQR2_USCH9(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetSEQR2_USCH9() uint32 {
	return volatile.LoadUint32(&o.SEQR2.Reg) & 0xf
}
func (o *ADC_Type) SetSEQR2_USCH10(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetSEQR2_USCH10() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetSEQR2_USCH11(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf00)|value<<8)
}
func (o *ADC_Type) GetSEQR2_USCH11() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf00) >> 8
}
func (o *ADC_Type) SetSEQR2_USCH12(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetSEQR2_USCH12() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf000) >> 12
}
func (o *ADC_Type) SetSEQR2_USCH13(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0000)|value<<16)
}
func (o *ADC_Type) GetSEQR2_USCH13() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0000) >> 16
}
func (o *ADC_Type) SetSEQR2_USCH14(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf00000)|value<<20)
}
func (o *ADC_Type) GetSEQR2_USCH14() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf00000) >> 20
}
func (o *ADC_Type) SetSEQR2_USCH15(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf000000)|value<<24)
}
func (o *ADC_Type) GetSEQR2_USCH15() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf000000) >> 24
}
func (o *ADC_Type) SetSEQR2_USCH16(value uint32) {
	volatile.StoreUint32(&o.SEQR2.Reg, volatile.LoadUint32(&o.SEQR2.Reg)&^(0xf0000000)|value<<28)
}
func (o *ADC_Type) GetSEQR2_USCH16() uint32 {
	return (volatile.LoadUint32(&o.SEQR2.Reg) & 0xf0000000) >> 28
}

// ADC.CHER: Channel Enable Register
func (o *ADC_Type) SetCHER_CH0(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHER_CH0() uint32 {
	return volatile.LoadUint32(&o.CHER.Reg) & 0x1
}
func (o *ADC_Type) SetCHER_CH1(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHER_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHER_CH2(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHER_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHER_CH3(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHER_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHER_CH4(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHER_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHER_CH5(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHER_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHER_CH6(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHER_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHER_CH7(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHER_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHER_CH8(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHER_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHER_CH9(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHER_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHER_CH10(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHER_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHER_CH11(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHER_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCHER_CH12(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCHER_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCHER_CH13(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCHER_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCHER_CH14(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCHER_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCHER_CH15(value uint32) {
	volatile.StoreUint32(&o.CHER.Reg, volatile.LoadUint32(&o.CHER.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCHER_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHER.Reg) & 0x8000) >> 15
}

// ADC.CHDR: Channel Disable Register
func (o *ADC_Type) SetCHDR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHDR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHDR.Reg) & 0x1
}
func (o *ADC_Type) SetCHDR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHDR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHDR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHDR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHDR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHDR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHDR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHDR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHDR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHDR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHDR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHDR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHDR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHDR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHDR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHDR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHDR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHDR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHDR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHDR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHDR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHDR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCHDR_CH12(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCHDR_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCHDR_CH13(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCHDR_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCHDR_CH14(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCHDR_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCHDR_CH15(value uint32) {
	volatile.StoreUint32(&o.CHDR.Reg, volatile.LoadUint32(&o.CHDR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCHDR_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHDR.Reg) & 0x8000) >> 15
}

// ADC.CHSR: Channel Status Register
func (o *ADC_Type) SetCHSR_CH0(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCHSR_CH0() uint32 {
	return volatile.LoadUint32(&o.CHSR.Reg) & 0x1
}
func (o *ADC_Type) SetCHSR_CH1(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCHSR_CH1() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCHSR_CH2(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCHSR_CH2() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCHSR_CH3(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCHSR_CH3() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCHSR_CH4(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetCHSR_CH4() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetCHSR_CH5(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetCHSR_CH5() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetCHSR_CH6(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCHSR_CH6() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCHSR_CH7(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCHSR_CH7() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCHSR_CH8(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetCHSR_CH8() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetCHSR_CH9(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetCHSR_CH9() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetCHSR_CH10(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetCHSR_CH10() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetCHSR_CH11(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetCHSR_CH11() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetCHSR_CH12(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetCHSR_CH12() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetCHSR_CH13(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetCHSR_CH13() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetCHSR_CH14(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetCHSR_CH14() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetCHSR_CH15(value uint32) {
	volatile.StoreUint32(&o.CHSR.Reg, volatile.LoadUint32(&o.CHSR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetCHSR_CH15() uint32 {
	return (volatile.LoadUint32(&o.CHSR.Reg) & 0x8000) >> 15
}

// ADC.LCDR: Last Converted Data Register
func (o *ADC_Type) SetLCDR_LDATA(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetLCDR_LDATA() uint32 {
	return volatile.LoadUint32(&o.LCDR.Reg) & 0xfff
}
func (o *ADC_Type) SetLCDR_CHNB(value uint32) {
	volatile.StoreUint32(&o.LCDR.Reg, volatile.LoadUint32(&o.LCDR.Reg)&^(0xf000)|value<<12)
}
func (o *ADC_Type) GetLCDR_CHNB() uint32 {
	return (volatile.LoadUint32(&o.LCDR.Reg) & 0xf000) >> 12
}

// ADC.IER: Interrupt Enable Register
func (o *ADC_Type) SetIER_EOC0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIER_EOC0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *ADC_Type) SetIER_EOC1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIER_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIER_EOC2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIER_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIER_EOC3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIER_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIER_EOC4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIER_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIER_EOC5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIER_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIER_EOC6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIER_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIER_EOC7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIER_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIER_EOC8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIER_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIER_EOC9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIER_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIER_EOC10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIER_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIER_EOC11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIER_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIER_EOC12(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetIER_EOC12() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetIER_EOC13(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIER_EOC13() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetIER_EOC14(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetIER_EOC14() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetIER_EOC15(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetIER_EOC15() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetIER_DRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIER_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIER_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIER_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIER_COMPE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIER_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}

// ADC.IDR: Interrupt Disable Register
func (o *ADC_Type) SetIDR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIDR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *ADC_Type) SetIDR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIDR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIDR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIDR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIDR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIDR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIDR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIDR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIDR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIDR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIDR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIDR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIDR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIDR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIDR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIDR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIDR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIDR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIDR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIDR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIDR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIDR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIDR_EOC12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetIDR_EOC12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetIDR_EOC13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIDR_EOC13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetIDR_EOC14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetIDR_EOC14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetIDR_EOC15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetIDR_EOC15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetIDR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIDR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIDR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIDR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIDR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIDR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}

// ADC.IMR: Interrupt Mask Register
func (o *ADC_Type) SetIMR_EOC0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetIMR_EOC0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *ADC_Type) SetIMR_EOC1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetIMR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetIMR_EOC2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetIMR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetIMR_EOC3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetIMR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetIMR_EOC4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetIMR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetIMR_EOC5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetIMR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetIMR_EOC6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetIMR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetIMR_EOC7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetIMR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetIMR_EOC8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetIMR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetIMR_EOC9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetIMR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetIMR_EOC10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetIMR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetIMR_EOC11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetIMR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetIMR_EOC12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetIMR_EOC12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetIMR_EOC13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetIMR_EOC13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetIMR_EOC14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetIMR_EOC14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetIMR_EOC15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetIMR_EOC15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetIMR_DRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetIMR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetIMR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetIMR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetIMR_COMPE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetIMR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}

// ADC.ISR: Interrupt Status Register
func (o *ADC_Type) SetISR_EOC0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetISR_EOC0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *ADC_Type) SetISR_EOC1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetISR_EOC1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetISR_EOC2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetISR_EOC2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetISR_EOC3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetISR_EOC3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetISR_EOC4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetISR_EOC4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetISR_EOC5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetISR_EOC5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetISR_EOC6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetISR_EOC6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetISR_EOC7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetISR_EOC7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetISR_EOC8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetISR_EOC8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetISR_EOC9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetISR_EOC9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetISR_EOC10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetISR_EOC10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetISR_EOC11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetISR_EOC11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetISR_EOC12(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetISR_EOC12() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetISR_EOC13(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetISR_EOC13() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetISR_EOC14(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetISR_EOC14() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetISR_EOC15(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetISR_EOC15() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *ADC_Type) SetISR_DRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetISR_DRDY() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *ADC_Type) SetISR_GOVRE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *ADC_Type) GetISR_GOVRE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *ADC_Type) SetISR_COMPE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *ADC_Type) GetISR_COMPE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *ADC_Type) SetISR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *ADC_Type) GetISR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *ADC_Type) SetISR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *ADC_Type) GetISR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}

// ADC.OVER: Overrun Status Register
func (o *ADC_Type) SetOVER_OVRE0(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetOVER_OVRE0() uint32 {
	return volatile.LoadUint32(&o.OVER.Reg) & 0x1
}
func (o *ADC_Type) SetOVER_OVRE1(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetOVER_OVRE1() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetOVER_OVRE2(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetOVER_OVRE2() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetOVER_OVRE3(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetOVER_OVRE3() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetOVER_OVRE4(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetOVER_OVRE4() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetOVER_OVRE5(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetOVER_OVRE5() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetOVER_OVRE6(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetOVER_OVRE6() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetOVER_OVRE7(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetOVER_OVRE7() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetOVER_OVRE8(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetOVER_OVRE8() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetOVER_OVRE9(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetOVER_OVRE9() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetOVER_OVRE10(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetOVER_OVRE10() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x400) >> 10
}
func (o *ADC_Type) SetOVER_OVRE11(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x800)|value<<11)
}
func (o *ADC_Type) GetOVER_OVRE11() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x800) >> 11
}
func (o *ADC_Type) SetOVER_OVRE12(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x1000)|value<<12)
}
func (o *ADC_Type) GetOVER_OVRE12() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x1000) >> 12
}
func (o *ADC_Type) SetOVER_OVRE13(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x2000)|value<<13)
}
func (o *ADC_Type) GetOVER_OVRE13() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x2000) >> 13
}
func (o *ADC_Type) SetOVER_OVRE14(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x4000)|value<<14)
}
func (o *ADC_Type) GetOVER_OVRE14() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x4000) >> 14
}
func (o *ADC_Type) SetOVER_OVRE15(value uint32) {
	volatile.StoreUint32(&o.OVER.Reg, volatile.LoadUint32(&o.OVER.Reg)&^(0x8000)|value<<15)
}
func (o *ADC_Type) GetOVER_OVRE15() uint32 {
	return (volatile.LoadUint32(&o.OVER.Reg) & 0x8000) >> 15
}

// ADC.EMR: Extended Mode Register
func (o *ADC_Type) SetEMR_CMPMODE(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x3)|value)
}
func (o *ADC_Type) GetEMR_CMPMODE() uint32 {
	return volatile.LoadUint32(&o.EMR.Reg) & 0x3
}
func (o *ADC_Type) SetEMR_CMPSEL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0xf0)|value<<4)
}
func (o *ADC_Type) GetEMR_CMPSEL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0xf0) >> 4
}
func (o *ADC_Type) SetEMR_CMPALL(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetEMR_CMPALL() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetEMR_TAG(value uint32) {
	volatile.StoreUint32(&o.EMR.Reg, volatile.LoadUint32(&o.EMR.Reg)&^(0x1000000)|value<<24)
}
func (o *ADC_Type) GetEMR_TAG() uint32 {
	return (volatile.LoadUint32(&o.EMR.Reg) & 0x1000000) >> 24
}

// ADC.CWR: Compare Window Register
func (o *ADC_Type) SetCWR_LOWTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetCWR_LOWTHRES() uint32 {
	return volatile.LoadUint32(&o.CWR.Reg) & 0xfff
}
func (o *ADC_Type) SetCWR_HIGHTHRES(value uint32) {
	volatile.StoreUint32(&o.CWR.Reg, volatile.LoadUint32(&o.CWR.Reg)&^(0xfff0000)|value<<16)
}
func (o *ADC_Type) GetCWR_HIGHTHRES() uint32 {
	return (volatile.LoadUint32(&o.CWR.Reg) & 0xfff0000) >> 16
}

// ADC.CDR: Channel Data Register
func (o *ADC_Type) SetCDR_DATA(idx int, value uint32) {
	volatile.StoreUint32(&o.CDR[idx].Reg, volatile.LoadUint32(&o.CDR[idx].Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetCDR_DATA(idx int) uint32 {
	return volatile.LoadUint32(&o.CDR[idx].Reg) & 0xfff
}

// ADC.WPMR: Write Protect Mode Register
func (o *ADC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *ADC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *ADC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// ADC.WPSR: Write Protect Status Register
func (o *ADC_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *ADC_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *ADC_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// ADC.RPR: Receive Pointer Register
func (o *ADC_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *ADC_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// ADC.RCR: Receive Counter Register
func (o *ADC_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// ADC.RNPR: Receive Next Pointer Register
func (o *ADC_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *ADC_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// ADC.RNCR: Receive Next Counter Register
func (o *ADC_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *ADC_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// ADC.PTCR: Transfer Control Register
func (o *ADC_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *ADC_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// ADC.PTSR: Transfer Status Register
func (o *ADC_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *ADC_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Digital-to-Analog Converter Controller
type DACC_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	CDR  volatile.Register32 // 0x8
	IER  volatile.Register32 // 0xC
	IDR  volatile.Register32 // 0x10
	IMR  volatile.Register32 // 0x14
	ISR  volatile.Register32 // 0x18
	_    [200]byte
	WPMR volatile.Register32 // 0xE4
	WPSR volatile.Register32 // 0xE8
	_    [28]byte
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	_    [8]byte
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// DACC.CR: Control Register
func (o *DACC_Type) SetCR_SWRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetCR_SWRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}

// DACC.MR: Mode Register
func (o *DACC_Type) SetMR_TRGEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetMR_TRGEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *DACC_Type) SetMR_TRGSEL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe)|value<<1)
}
func (o *DACC_Type) GetMR_TRGSEL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe) >> 1
}
func (o *DACC_Type) SetMR_DACEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *DACC_Type) GetMR_DACEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *DACC_Type) SetMR_WORD(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x20)|value<<5)
}
func (o *DACC_Type) GetMR_WORD() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x20) >> 5
}
func (o *DACC_Type) SetMR_STARTUP(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff00)|value<<8)
}
func (o *DACC_Type) GetMR_STARTUP() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff00) >> 8
}
func (o *DACC_Type) SetMR_CLKDIV(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xffff0000)|value<<16)
}
func (o *DACC_Type) GetMR_CLKDIV() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xffff0000) >> 16
}

// DACC.CDR: Conversion Data Register
func (o *DACC_Type) SetCDR(value uint32) {
	volatile.StoreUint32(&o.CDR.Reg, value)
}
func (o *DACC_Type) GetCDR() uint32 {
	return volatile.LoadUint32(&o.CDR.Reg)
}

// DACC.IER: Interrupt Enable Register
func (o *DACC_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIER_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *DACC_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *DACC_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}

// DACC.IDR: Interrupt Disable Register
func (o *DACC_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIDR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *DACC_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *DACC_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}

// DACC.IMR: Interrupt Mask Register
func (o *DACC_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetIMR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *DACC_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *DACC_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}

// DACC.ISR: Interrupt Status Register
func (o *DACC_Type) SetISR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetISR_TXRDY() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *DACC_Type) SetISR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetISR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetISR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *DACC_Type) GetISR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}

// DACC.WPMR: Write Protect Mode Register
func (o *DACC_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *DACC_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *DACC_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// DACC.WPSR: Write Protect Status Register
func (o *DACC_Type) SetWPSR_WPROTERR(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetWPSR_WPROTERR() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *DACC_Type) SetWPSR_WPROTADDR(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xff00)|value<<8)
}
func (o *DACC_Type) GetWPSR_WPROTADDR() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xff00) >> 8
}

// DACC.TPR: Transmit Pointer Register
func (o *DACC_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *DACC_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// DACC.TCR: Transmit Counter Register
func (o *DACC_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *DACC_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// DACC.TNPR: Transmit Next Pointer Register
func (o *DACC_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *DACC_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// DACC.TNCR: Transmit Next Counter Register
func (o *DACC_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *DACC_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// DACC.PTCR: Transfer Control Register
func (o *DACC_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *DACC_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *DACC_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *DACC_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *DACC_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *DACC_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *DACC_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// DACC.PTSR: Transfer Status Register
func (o *DACC_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *DACC_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *DACC_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *DACC_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// AHB Bus Matrix
type MATRIX_Type struct {
	MATRIX_MCFG  [3]volatile.Register32 // 0x0
	_            [52]byte
	MATRIX_SCFG  [4]volatile.Register32 // 0x40
	_            [48]byte
	MATRIX_PRAS0 volatile.Register32 // 0x80
	_            [4]byte
	MATRIX_PRAS1 volatile.Register32 // 0x88
	_            [4]byte
	MATRIX_PRAS2 volatile.Register32 // 0x90
	_            [4]byte
	MATRIX_PRAS3 volatile.Register32 // 0x98
	_            [120]byte
	CCFG_SYSIO   volatile.Register32 // 0x114
	_            [204]byte
	MATRIX_WPMR  volatile.Register32 // 0x1E4
	MATRIX_WPSR  volatile.Register32 // 0x1E8
}

// MATRIX.MATRIX_MCFG: Master Configuration Register
func (o *MATRIX_Type) SetMATRIX_MCFG_ULBT(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_MCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_MCFG[idx].Reg)&^(0x7)|value)
}
func (o *MATRIX_Type) GetMATRIX_MCFG_ULBT(idx int) uint32 {
	return volatile.LoadUint32(&o.MATRIX_MCFG[idx].Reg) & 0x7
}

// MATRIX.MATRIX_SCFG: Slave Configuration Register
func (o *MATRIX_Type) SetMATRIX_SCFG_SLOT_CYCLE(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0xff)|value)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_SLOT_CYCLE(idx int) uint32 {
	return volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0xff
}
func (o *MATRIX_Type) SetMATRIX_SCFG_DEFMSTR_TYPE(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x30000)|value<<16)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_DEFMSTR_TYPE(idx int) uint32 {
	return (volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x30000) >> 16
}
func (o *MATRIX_Type) SetMATRIX_SCFG_FIXED_DEFMSTR(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x1c0000)|value<<18)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_FIXED_DEFMSTR(idx int) uint32 {
	return (volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x1c0000) >> 18
}
func (o *MATRIX_Type) SetMATRIX_SCFG_ARBT(idx int, value uint32) {
	volatile.StoreUint32(&o.MATRIX_SCFG[idx].Reg, volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg)&^(0x3000000)|value<<24)
}
func (o *MATRIX_Type) GetMATRIX_SCFG_ARBT(idx int) uint32 {
	return (volatile.LoadUint32(&o.MATRIX_SCFG[idx].Reg) & 0x3000000) >> 24
}

// MATRIX.MATRIX_PRAS0: Priority Register A for Slave 0
func (o *MATRIX_Type) SetMATRIX_PRAS0_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS0_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS0_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS0_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS0.Reg, volatile.LoadUint32(&o.MATRIX_PRAS0.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS0_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS0.Reg) & 0x3000) >> 12
}

// MATRIX.MATRIX_PRAS1: Priority Register A for Slave 1
func (o *MATRIX_Type) SetMATRIX_PRAS1_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS1_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS1_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS1_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS1.Reg, volatile.LoadUint32(&o.MATRIX_PRAS1.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS1_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS1.Reg) & 0x3000) >> 12
}

// MATRIX.MATRIX_PRAS2: Priority Register A for Slave 2
func (o *MATRIX_Type) SetMATRIX_PRAS2_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS2_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS2_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS2_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS2.Reg, volatile.LoadUint32(&o.MATRIX_PRAS2.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS2_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS2.Reg) & 0x3000) >> 12
}

// MATRIX.MATRIX_PRAS3: Priority Register A for Slave 3
func (o *MATRIX_Type) SetMATRIX_PRAS3_M0PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x3)|value)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M0PR() uint32 {
	return volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x3
}
func (o *MATRIX_Type) SetMATRIX_PRAS3_M1PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x30)|value<<4)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M1PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x30) >> 4
}
func (o *MATRIX_Type) SetMATRIX_PRAS3_M2PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x300)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M2PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x300) >> 8
}
func (o *MATRIX_Type) SetMATRIX_PRAS3_M3PR(value uint32) {
	volatile.StoreUint32(&o.MATRIX_PRAS3.Reg, volatile.LoadUint32(&o.MATRIX_PRAS3.Reg)&^(0x3000)|value<<12)
}
func (o *MATRIX_Type) GetMATRIX_PRAS3_M3PR() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_PRAS3.Reg) & 0x3000) >> 12
}

// MATRIX.CCFG_SYSIO: System I/O Configuration register
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO4(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x10)|value<<4)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO4() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x10) >> 4
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO5(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x20)|value<<5)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO5() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x20) >> 5
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO6(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x40)|value<<6)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO6() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x40) >> 6
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO7(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x80)|value<<7)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO7() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x80) >> 7
}
func (o *MATRIX_Type) SetCCFG_SYSIO_SYSIO12(value uint32) {
	volatile.StoreUint32(&o.CCFG_SYSIO.Reg, volatile.LoadUint32(&o.CCFG_SYSIO.Reg)&^(0x1000)|value<<12)
}
func (o *MATRIX_Type) GetCCFG_SYSIO_SYSIO12() uint32 {
	return (volatile.LoadUint32(&o.CCFG_SYSIO.Reg) & 0x1000) >> 12
}

// MATRIX.MATRIX_WPMR: Write Protect Mode Register
func (o *MATRIX_Type) SetMATRIX_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPMR.Reg, volatile.LoadUint32(&o.MATRIX_WPMR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMATRIX_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.MATRIX_WPMR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMATRIX_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPMR.Reg, volatile.LoadUint32(&o.MATRIX_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_WPMR.Reg) & 0xffffff00) >> 8
}

// MATRIX.MATRIX_WPSR: Write Protect Status Register
func (o *MATRIX_Type) SetMATRIX_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPSR.Reg, volatile.LoadUint32(&o.MATRIX_WPSR.Reg)&^(0x1)|value)
}
func (o *MATRIX_Type) GetMATRIX_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.MATRIX_WPSR.Reg) & 0x1
}
func (o *MATRIX_Type) SetMATRIX_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.MATRIX_WPSR.Reg, volatile.LoadUint32(&o.MATRIX_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *MATRIX_Type) GetMATRIX_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.MATRIX_WPSR.Reg) & 0xffff00) >> 8
}

// Power Management Controller
type PMC_Type struct {
	PMC_SCER   volatile.Register32 // 0x0
	PMC_SCDR   volatile.Register32 // 0x4
	PMC_SCSR   volatile.Register32 // 0x8
	_          [4]byte
	PMC_PCER0  volatile.Register32 // 0x10
	PMC_PCDR0  volatile.Register32 // 0x14
	PMC_PCSR0  volatile.Register32 // 0x18
	_          [4]byte
	CKGR_MOR   volatile.Register32 // 0x20
	CKGR_MCFR  volatile.Register32 // 0x24
	CKGR_PLLAR volatile.Register32 // 0x28
	_          [4]byte
	PMC_MCKR   volatile.Register32 // 0x30
	_          [12]byte
	PMC_PCK    [3]volatile.Register32 // 0x40
	_          [20]byte
	PMC_IER    volatile.Register32 // 0x60
	PMC_IDR    volatile.Register32 // 0x64
	PMC_SR     volatile.Register32 // 0x68
	PMC_IMR    volatile.Register32 // 0x6C
	PMC_FSMR   volatile.Register32 // 0x70
	PMC_FSPR   volatile.Register32 // 0x74
	PMC_FOCR   volatile.Register32 // 0x78
	_          [104]byte
	PMC_WPMR   volatile.Register32 // 0xE4
	PMC_WPSR   volatile.Register32 // 0xE8
}

// PMC.PMC_SCER: System Clock Enable Register
func (o *PMC_Type) SetPMC_SCER_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCER_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCER_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCER_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCER_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCER.Reg, volatile.LoadUint32(&o.PMC_SCER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCER_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCER.Reg) & 0x400) >> 10
}

// PMC.PMC_SCDR: System Clock Disable Register
func (o *PMC_Type) SetPMC_SCDR_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCDR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCDR_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCDR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCDR_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCDR.Reg, volatile.LoadUint32(&o.PMC_SCDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCDR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCDR.Reg) & 0x400) >> 10
}

// PMC.PMC_SCSR: System Clock Status Register
func (o *PMC_Type) SetPMC_SCSR_PCK0(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SCSR_PCK0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SCSR_PCK1(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SCSR_PCK1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SCSR_PCK2(value uint32) {
	volatile.StoreUint32(&o.PMC_SCSR.Reg, volatile.LoadUint32(&o.PMC_SCSR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SCSR_PCK2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SCSR.Reg) & 0x400) >> 10
}

// PMC.PMC_PCER0: Peripheral Clock Enable Register 0
func (o *PMC_Type) SetPMC_PCER0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCER0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCER0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCER0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCER0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCER0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCER0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCER0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCER0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCER0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCER0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCER0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCER0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCER0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCER0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCER0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCER0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCER0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCER0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCER0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCER0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCER0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCER0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCER0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCER0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCER0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCER0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCER0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCER0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCER0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCER0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCER0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCER0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCER0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCER0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCER0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCER0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCER0.Reg, volatile.LoadUint32(&o.PMC_PCER0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCER0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCER0.Reg) & 0x80000000) >> 31
}

// PMC.PMC_PCDR0: Peripheral Clock Disable Register 0
func (o *PMC_Type) SetPMC_PCDR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCDR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCDR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCDR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCDR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCDR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCDR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCDR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCDR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCDR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCDR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCDR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCDR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCDR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCDR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCDR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCDR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCDR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCDR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCDR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCDR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCDR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCDR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCDR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCDR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCDR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCDR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCDR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCDR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCDR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCDR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCDR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCDR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCDR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCDR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCDR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCDR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCDR0.Reg, volatile.LoadUint32(&o.PMC_PCDR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCDR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCDR0.Reg) & 0x80000000) >> 31
}

// PMC.PMC_PCSR0: Peripheral Clock Status Register 0
func (o *PMC_Type) SetPMC_PCSR0_PID9(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_PCSR0_PID9() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_PCSR0_PID10(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_PCSR0_PID10() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_PCSR0_PID11(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_PCSR0_PID11() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_PCSR0_PID12(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_PCSR0_PID12() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_PCSR0_PID13(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_PCSR0_PID13() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_PCSR0_PID14(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_PCSR0_PID14() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_PCSR0_PID15(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_PCSR0_PID15() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_PCSR0_PID19(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_PCSR0_PID19() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_PCSR0_PID20(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_PCSR0_PID20() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x100000) >> 20
}
func (o *PMC_Type) SetPMC_PCSR0_PID21(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x200000)|value<<21)
}
func (o *PMC_Type) GetPMC_PCSR0_PID21() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x200000) >> 21
}
func (o *PMC_Type) SetPMC_PCSR0_PID23(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x800000)|value<<23)
}
func (o *PMC_Type) GetPMC_PCSR0_PID23() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x800000) >> 23
}
func (o *PMC_Type) SetPMC_PCSR0_PID24(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetPMC_PCSR0_PID24() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetPMC_PCSR0_PID25(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetPMC_PCSR0_PID25() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x2000000) >> 25
}
func (o *PMC_Type) SetPMC_PCSR0_PID26(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x4000000)|value<<26)
}
func (o *PMC_Type) GetPMC_PCSR0_PID26() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x4000000) >> 26
}
func (o *PMC_Type) SetPMC_PCSR0_PID27(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x8000000)|value<<27)
}
func (o *PMC_Type) GetPMC_PCSR0_PID27() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x8000000) >> 27
}
func (o *PMC_Type) SetPMC_PCSR0_PID28(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x10000000)|value<<28)
}
func (o *PMC_Type) GetPMC_PCSR0_PID28() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x10000000) >> 28
}
func (o *PMC_Type) SetPMC_PCSR0_PID29(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetPMC_PCSR0_PID29() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x20000000) >> 29
}
func (o *PMC_Type) SetPMC_PCSR0_PID30(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x40000000)|value<<30)
}
func (o *PMC_Type) GetPMC_PCSR0_PID30() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x40000000) >> 30
}
func (o *PMC_Type) SetPMC_PCSR0_PID31(value uint32) {
	volatile.StoreUint32(&o.PMC_PCSR0.Reg, volatile.LoadUint32(&o.PMC_PCSR0.Reg)&^(0x80000000)|value<<31)
}
func (o *PMC_Type) GetPMC_PCSR0_PID31() uint32 {
	return (volatile.LoadUint32(&o.PMC_PCSR0.Reg) & 0x80000000) >> 31
}

// PMC.CKGR_MOR: Main Oscillator Register
func (o *PMC_Type) SetCKGR_MOR_MOSCXTEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTEN() uint32 {
	return volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTBY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTBY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetCKGR_MOR_MOSCRCF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCRCF() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetCKGR_MOR_MOSCXTST(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff00)|value<<8)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCXTST() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff00) >> 8
}
func (o *PMC_Type) SetCKGR_MOR_KEY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0xff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MOR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0xff0000) >> 16
}
func (o *PMC_Type) SetCKGR_MOR_MOSCSEL(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x1000000)|value<<24)
}
func (o *PMC_Type) GetCKGR_MOR_MOSCSEL() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x1000000) >> 24
}
func (o *PMC_Type) SetCKGR_MOR_CFDEN(value uint32) {
	volatile.StoreUint32(&o.CKGR_MOR.Reg, volatile.LoadUint32(&o.CKGR_MOR.Reg)&^(0x2000000)|value<<25)
}
func (o *PMC_Type) GetCKGR_MOR_CFDEN() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MOR.Reg) & 0x2000000) >> 25
}

// PMC.CKGR_MCFR: Main Clock Frequency Register
func (o *PMC_Type) SetCKGR_MCFR_MAINF(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0xffff)|value)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINF() uint32 {
	return volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0xffff
}
func (o *PMC_Type) SetCKGR_MCFR_MAINFRDY(value uint32) {
	volatile.StoreUint32(&o.CKGR_MCFR.Reg, volatile.LoadUint32(&o.CKGR_MCFR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetCKGR_MCFR_MAINFRDY() uint32 {
	return (volatile.LoadUint32(&o.CKGR_MCFR.Reg) & 0x10000) >> 16
}

// PMC.CKGR_PLLAR: PLLA Register
func (o *PMC_Type) SetCKGR_PLLAR_DIVA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0xff)|value)
}
func (o *PMC_Type) GetCKGR_PLLAR_DIVA() uint32 {
	return volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0xff
}
func (o *PMC_Type) SetCKGR_PLLAR_PLLACOUNT(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x3f00)|value<<8)
}
func (o *PMC_Type) GetCKGR_PLLAR_PLLACOUNT() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x3f00) >> 8
}
func (o *PMC_Type) SetCKGR_PLLAR_MULA(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x7ff0000)|value<<16)
}
func (o *PMC_Type) GetCKGR_PLLAR_MULA() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x7ff0000) >> 16
}
func (o *PMC_Type) SetCKGR_PLLAR_ONE(value uint32) {
	volatile.StoreUint32(&o.CKGR_PLLAR.Reg, volatile.LoadUint32(&o.CKGR_PLLAR.Reg)&^(0x20000000)|value<<29)
}
func (o *PMC_Type) GetCKGR_PLLAR_ONE() uint32 {
	return (volatile.LoadUint32(&o.CKGR_PLLAR.Reg) & 0x20000000) >> 29
}

// PMC.PMC_MCKR: Master Clock Register
func (o *PMC_Type) SetPMC_MCKR_CSS(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x3)|value)
}
func (o *PMC_Type) GetPMC_MCKR_CSS() uint32 {
	return volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x3
}
func (o *PMC_Type) SetPMC_MCKR_PRES(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetPMC_MCKR_PRES() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x70) >> 4
}
func (o *PMC_Type) SetPMC_MCKR_PLLADIV2(value uint32) {
	volatile.StoreUint32(&o.PMC_MCKR.Reg, volatile.LoadUint32(&o.PMC_MCKR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_MCKR_PLLADIV2() uint32 {
	return (volatile.LoadUint32(&o.PMC_MCKR.Reg) & 0x1000) >> 12
}

// PMC.PMC_PCK: Programmable Clock 0 Register
func (o *PMC_Type) SetPMC_PCK_CSS(idx int, value uint32) {
	volatile.StoreUint32(&o.PMC_PCK[idx].Reg, volatile.LoadUint32(&o.PMC_PCK[idx].Reg)&^(0x7)|value)
}
func (o *PMC_Type) GetPMC_PCK_CSS(idx int) uint32 {
	return volatile.LoadUint32(&o.PMC_PCK[idx].Reg) & 0x7
}
func (o *PMC_Type) SetPMC_PCK_PRES(idx int, value uint32) {
	volatile.StoreUint32(&o.PMC_PCK[idx].Reg, volatile.LoadUint32(&o.PMC_PCK[idx].Reg)&^(0x70)|value<<4)
}
func (o *PMC_Type) GetPMC_PCK_PRES(idx int) uint32 {
	return (volatile.LoadUint32(&o.PMC_PCK[idx].Reg) & 0x70) >> 4
}

// PMC.PMC_IER: Interrupt Enable Register
func (o *PMC_Type) SetPMC_IER_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IER_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IER.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IER_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IER_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IER_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IER_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IER_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IER_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IER_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IER_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IER_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IER_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IER_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IER_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IER_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IER.Reg, volatile.LoadUint32(&o.PMC_IER.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IER_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IER.Reg) & 0x40000) >> 18
}

// PMC.PMC_IDR: Interrupt Disable Register
func (o *PMC_Type) SetPMC_IDR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IDR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IDR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IDR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IDR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IDR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IDR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IDR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IDR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IDR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IDR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IDR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IDR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IDR.Reg, volatile.LoadUint32(&o.PMC_IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IDR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IDR.Reg) & 0x40000) >> 18
}

// PMC.PMC_SR: Status Register
func (o *PMC_Type) SetPMC_SR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_SR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_SR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_SR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_SR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_SR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_SR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_SR_OSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_SR_OSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_SR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_SR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_SR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_SR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_SR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_SR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_SR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_SR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_SR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_SR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x40000) >> 18
}
func (o *PMC_Type) SetPMC_SR_CFDS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x80000)|value<<19)
}
func (o *PMC_Type) GetPMC_SR_CFDS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x80000) >> 19
}
func (o *PMC_Type) SetPMC_SR_FOS(value uint32) {
	volatile.StoreUint32(&o.PMC_SR.Reg, volatile.LoadUint32(&o.PMC_SR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_SR_FOS() uint32 {
	return (volatile.LoadUint32(&o.PMC_SR.Reg) & 0x100000) >> 20
}

// PMC.PMC_IMR: Interrupt Mask Register
func (o *PMC_Type) SetPMC_IMR_MOSCXTS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_IMR_MOSCXTS() uint32 {
	return volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_IMR_LOCKA(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_IMR_LOCKA() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_IMR_MCKRDY(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_IMR_MCKRDY() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY0(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY0() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY1(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY1() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_IMR_PCKRDY2(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_IMR_PCKRDY2() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_IMR_MOSCSELS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_IMR_MOSCSELS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_IMR_MOSCRCS(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_IMR_MOSCRCS() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_IMR_CFDEV(value uint32) {
	volatile.StoreUint32(&o.PMC_IMR.Reg, volatile.LoadUint32(&o.PMC_IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PMC_Type) GetPMC_IMR_CFDEV() uint32 {
	return (volatile.LoadUint32(&o.PMC_IMR.Reg) & 0x40000) >> 18
}

// PMC.PMC_FSMR: Fast Start-up Mode Register
func (o *PMC_Type) SetPMC_FSMR_FSTT0(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT0() uint32 {
	return volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_FSMR_FSTT1(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT1() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_FSMR_FSTT2(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT2() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_FSMR_FSTT3(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT3() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_FSMR_FSTT4(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT4() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_FSMR_FSTT5(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT5() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_FSMR_FSTT6(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT6() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_FSMR_FSTT7(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT7() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_FSMR_FSTT8(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT8() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_FSMR_FSTT9(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT9() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_FSMR_FSTT10(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT10() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_FSMR_FSTT11(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT11() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_FSMR_FSTT12(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT12() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_FSMR_FSTT13(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT13() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_FSMR_FSTT14(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT14() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_FSMR_FSTT15(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_FSMR_FSTT15() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x8000) >> 15
}
func (o *PMC_Type) SetPMC_FSMR_RTTAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x10000)|value<<16)
}
func (o *PMC_Type) GetPMC_FSMR_RTTAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x10000) >> 16
}
func (o *PMC_Type) SetPMC_FSMR_RTCAL(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x20000)|value<<17)
}
func (o *PMC_Type) GetPMC_FSMR_RTCAL() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x20000) >> 17
}
func (o *PMC_Type) SetPMC_FSMR_LPM(value uint32) {
	volatile.StoreUint32(&o.PMC_FSMR.Reg, volatile.LoadUint32(&o.PMC_FSMR.Reg)&^(0x100000)|value<<20)
}
func (o *PMC_Type) GetPMC_FSMR_LPM() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSMR.Reg) & 0x100000) >> 20
}

// PMC.PMC_FSPR: Fast Start-up Polarity Register
func (o *PMC_Type) SetPMC_FSPR_FSTP0(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP0() uint32 {
	return volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_FSPR_FSTP1(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x2)|value<<1)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP1() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x2) >> 1
}
func (o *PMC_Type) SetPMC_FSPR_FSTP2(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x4)|value<<2)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP2() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x4) >> 2
}
func (o *PMC_Type) SetPMC_FSPR_FSTP3(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x8)|value<<3)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP3() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x8) >> 3
}
func (o *PMC_Type) SetPMC_FSPR_FSTP4(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x10)|value<<4)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP4() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x10) >> 4
}
func (o *PMC_Type) SetPMC_FSPR_FSTP5(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x20)|value<<5)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP5() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x20) >> 5
}
func (o *PMC_Type) SetPMC_FSPR_FSTP6(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x40)|value<<6)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP6() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x40) >> 6
}
func (o *PMC_Type) SetPMC_FSPR_FSTP7(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x80)|value<<7)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP7() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x80) >> 7
}
func (o *PMC_Type) SetPMC_FSPR_FSTP8(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x100)|value<<8)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP8() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x100) >> 8
}
func (o *PMC_Type) SetPMC_FSPR_FSTP9(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x200)|value<<9)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP9() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x200) >> 9
}
func (o *PMC_Type) SetPMC_FSPR_FSTP10(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x400)|value<<10)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP10() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x400) >> 10
}
func (o *PMC_Type) SetPMC_FSPR_FSTP11(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x800)|value<<11)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP11() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x800) >> 11
}
func (o *PMC_Type) SetPMC_FSPR_FSTP12(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x1000)|value<<12)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP12() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x1000) >> 12
}
func (o *PMC_Type) SetPMC_FSPR_FSTP13(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x2000)|value<<13)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP13() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x2000) >> 13
}
func (o *PMC_Type) SetPMC_FSPR_FSTP14(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x4000)|value<<14)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP14() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x4000) >> 14
}
func (o *PMC_Type) SetPMC_FSPR_FSTP15(value uint32) {
	volatile.StoreUint32(&o.PMC_FSPR.Reg, volatile.LoadUint32(&o.PMC_FSPR.Reg)&^(0x8000)|value<<15)
}
func (o *PMC_Type) GetPMC_FSPR_FSTP15() uint32 {
	return (volatile.LoadUint32(&o.PMC_FSPR.Reg) & 0x8000) >> 15
}

// PMC.PMC_FOCR: Fault Output Clear Register
func (o *PMC_Type) SetPMC_FOCR_FOCLR(value uint32) {
	volatile.StoreUint32(&o.PMC_FOCR.Reg, volatile.LoadUint32(&o.PMC_FOCR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_FOCR_FOCLR() uint32 {
	return volatile.LoadUint32(&o.PMC_FOCR.Reg) & 0x1
}

// PMC.PMC_WPMR: Write Protect Mode Register
func (o *PMC_Type) SetPMC_WPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.PMC_WPMR.Reg, volatile.LoadUint32(&o.PMC_WPMR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_WPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.PMC_WPMR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_WPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.PMC_WPMR.Reg, volatile.LoadUint32(&o.PMC_WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PMC_Type) GetPMC_WPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.PMC_WPMR.Reg) & 0xffffff00) >> 8
}

// PMC.PMC_WPSR: Write Protect Status Register
func (o *PMC_Type) SetPMC_WPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.PMC_WPSR.Reg, volatile.LoadUint32(&o.PMC_WPSR.Reg)&^(0x1)|value)
}
func (o *PMC_Type) GetPMC_WPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.PMC_WPSR.Reg) & 0x1
}
func (o *PMC_Type) SetPMC_WPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.PMC_WPSR.Reg, volatile.LoadUint32(&o.PMC_WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *PMC_Type) GetPMC_WPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.PMC_WPSR.Reg) & 0xffff00) >> 8
}

// Universal Asynchronous Receiver Transmitter 0
type UART_Type struct {
	CR   volatile.Register32 // 0x0
	MR   volatile.Register32 // 0x4
	IER  volatile.Register32 // 0x8
	IDR  volatile.Register32 // 0xC
	IMR  volatile.Register32 // 0x10
	SR   volatile.Register32 // 0x14
	RHR  volatile.Register32 // 0x18
	THR  volatile.Register32 // 0x1C
	BRGR volatile.Register32 // 0x20
	_    [220]byte
	RPR  volatile.Register32 // 0x100
	RCR  volatile.Register32 // 0x104
	TPR  volatile.Register32 // 0x108
	TCR  volatile.Register32 // 0x10C
	RNPR volatile.Register32 // 0x110
	RNCR volatile.Register32 // 0x114
	TNPR volatile.Register32 // 0x118
	TNCR volatile.Register32 // 0x11C
	PTCR volatile.Register32 // 0x120
	PTSR volatile.Register32 // 0x124
}

// UART.CR: Control Register
func (o *UART_Type) SetCR_RSTRX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *UART_Type) GetCR_RSTRX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *UART_Type) SetCR_RSTTX(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetCR_RSTTX() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetCR_RXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetCR_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetCR_RXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetCR_RXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetCR_TXEN(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetCR_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetCR_TXDIS(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetCR_TXDIS() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetCR_RSTSTA(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetCR_RSTSTA() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x100) >> 8
}

// UART.MR: Mode Register
func (o *UART_Type) SetMR_PAR(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xe00)|value<<9)
}
func (o *UART_Type) GetMR_PAR() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xe00) >> 9
}
func (o *UART_Type) SetMR_CHMODE(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xc000)|value<<14)
}
func (o *UART_Type) GetMR_CHMODE() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xc000) >> 14
}

// UART.IER: Interrupt Enable Register
func (o *UART_Type) SetIER_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIER_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *UART_Type) SetIER_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIER_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIER_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIER_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIER_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIER_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIER_OVRE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIER_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIER_FRAME(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIER_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIER_PARE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIER_PARE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIER_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIER_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIER_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetIER_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetIER_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetIER_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}

// UART.IDR: Interrupt Disable Register
func (o *UART_Type) SetIDR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIDR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *UART_Type) SetIDR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIDR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIDR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIDR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIDR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIDR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIDR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIDR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIDR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIDR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIDR_PARE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIDR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIDR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIDR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIDR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetIDR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetIDR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetIDR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}

// UART.IMR: Interrupt Mask Register
func (o *UART_Type) SetIMR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetIMR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *UART_Type) SetIMR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetIMR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetIMR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetIMR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetIMR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetIMR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetIMR_OVRE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetIMR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetIMR_FRAME(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetIMR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetIMR_PARE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetIMR_PARE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetIMR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetIMR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetIMR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetIMR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetIMR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetIMR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}

// UART.SR: Status Register
func (o *UART_Type) SetSR_RXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetSR_RXRDY() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *UART_Type) SetSR_TXRDY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetSR_TXRDY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetSR_ENDRX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x8)|value<<3)
}
func (o *UART_Type) GetSR_ENDRX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x8) >> 3
}
func (o *UART_Type) SetSR_ENDTX(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10)|value<<4)
}
func (o *UART_Type) GetSR_ENDTX() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10) >> 4
}
func (o *UART_Type) SetSR_OVRE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20)|value<<5)
}
func (o *UART_Type) GetSR_OVRE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20) >> 5
}
func (o *UART_Type) SetSR_FRAME(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x40)|value<<6)
}
func (o *UART_Type) GetSR_FRAME() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x40) >> 6
}
func (o *UART_Type) SetSR_PARE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x80)|value<<7)
}
func (o *UART_Type) GetSR_PARE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x80) >> 7
}
func (o *UART_Type) SetSR_TXEMPTY(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetSR_TXEMPTY() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x200) >> 9
}
func (o *UART_Type) SetSR_TXBUFE(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x800)|value<<11)
}
func (o *UART_Type) GetSR_TXBUFE() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x800) >> 11
}
func (o *UART_Type) SetSR_RXBUFF(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1000)|value<<12)
}
func (o *UART_Type) GetSR_RXBUFF() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x1000) >> 12
}

// UART.RHR: Receive Holding Register
func (o *UART_Type) SetRHR_RXCHR(value uint32) {
	volatile.StoreUint32(&o.RHR.Reg, volatile.LoadUint32(&o.RHR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetRHR_RXCHR() uint32 {
	return volatile.LoadUint32(&o.RHR.Reg) & 0xff
}

// UART.THR: Transmit Holding Register
func (o *UART_Type) SetTHR_TXCHR(value uint32) {
	volatile.StoreUint32(&o.THR.Reg, volatile.LoadUint32(&o.THR.Reg)&^(0xff)|value)
}
func (o *UART_Type) GetTHR_TXCHR() uint32 {
	return volatile.LoadUint32(&o.THR.Reg) & 0xff
}

// UART.BRGR: Baud Rate Generator Register
func (o *UART_Type) SetBRGR_CD(value uint32) {
	volatile.StoreUint32(&o.BRGR.Reg, volatile.LoadUint32(&o.BRGR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetBRGR_CD() uint32 {
	return volatile.LoadUint32(&o.BRGR.Reg) & 0xffff
}

// UART.RPR: Receive Pointer Register
func (o *UART_Type) SetRPR(value uint32) {
	volatile.StoreUint32(&o.RPR.Reg, value)
}
func (o *UART_Type) GetRPR() uint32 {
	return volatile.LoadUint32(&o.RPR.Reg)
}

// UART.RCR: Receive Counter Register
func (o *UART_Type) SetRCR_RXCTR(value uint32) {
	volatile.StoreUint32(&o.RCR.Reg, volatile.LoadUint32(&o.RCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetRCR_RXCTR() uint32 {
	return volatile.LoadUint32(&o.RCR.Reg) & 0xffff
}

// UART.TPR: Transmit Pointer Register
func (o *UART_Type) SetTPR(value uint32) {
	volatile.StoreUint32(&o.TPR.Reg, value)
}
func (o *UART_Type) GetTPR() uint32 {
	return volatile.LoadUint32(&o.TPR.Reg)
}

// UART.TCR: Transmit Counter Register
func (o *UART_Type) SetTCR_TXCTR(value uint32) {
	volatile.StoreUint32(&o.TCR.Reg, volatile.LoadUint32(&o.TCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetTCR_TXCTR() uint32 {
	return volatile.LoadUint32(&o.TCR.Reg) & 0xffff
}

// UART.RNPR: Receive Next Pointer Register
func (o *UART_Type) SetRNPR(value uint32) {
	volatile.StoreUint32(&o.RNPR.Reg, value)
}
func (o *UART_Type) GetRNPR() uint32 {
	return volatile.LoadUint32(&o.RNPR.Reg)
}

// UART.RNCR: Receive Next Counter Register
func (o *UART_Type) SetRNCR_RXNCTR(value uint32) {
	volatile.StoreUint32(&o.RNCR.Reg, volatile.LoadUint32(&o.RNCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetRNCR_RXNCTR() uint32 {
	return volatile.LoadUint32(&o.RNCR.Reg) & 0xffff
}

// UART.TNPR: Transmit Next Pointer Register
func (o *UART_Type) SetTNPR(value uint32) {
	volatile.StoreUint32(&o.TNPR.Reg, value)
}
func (o *UART_Type) GetTNPR() uint32 {
	return volatile.LoadUint32(&o.TNPR.Reg)
}

// UART.TNCR: Transmit Next Counter Register
func (o *UART_Type) SetTNCR_TXNCTR(value uint32) {
	volatile.StoreUint32(&o.TNCR.Reg, volatile.LoadUint32(&o.TNCR.Reg)&^(0xffff)|value)
}
func (o *UART_Type) GetTNCR_TXNCTR() uint32 {
	return volatile.LoadUint32(&o.TNCR.Reg) & 0xffff
}

// UART.PTCR: Transfer Control Register
func (o *UART_Type) SetPTCR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetPTCR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTCR.Reg) & 0x1
}
func (o *UART_Type) SetPTCR_RXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x2)|value<<1)
}
func (o *UART_Type) GetPTCR_RXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x2) >> 1
}
func (o *UART_Type) SetPTCR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetPTCR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x100) >> 8
}
func (o *UART_Type) SetPTCR_TXTDIS(value uint32) {
	volatile.StoreUint32(&o.PTCR.Reg, volatile.LoadUint32(&o.PTCR.Reg)&^(0x200)|value<<9)
}
func (o *UART_Type) GetPTCR_TXTDIS() uint32 {
	return (volatile.LoadUint32(&o.PTCR.Reg) & 0x200) >> 9
}

// UART.PTSR: Transfer Status Register
func (o *UART_Type) SetPTSR_RXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x1)|value)
}
func (o *UART_Type) GetPTSR_RXTEN() uint32 {
	return volatile.LoadUint32(&o.PTSR.Reg) & 0x1
}
func (o *UART_Type) SetPTSR_TXTEN(value uint32) {
	volatile.StoreUint32(&o.PTSR.Reg, volatile.LoadUint32(&o.PTSR.Reg)&^(0x100)|value<<8)
}
func (o *UART_Type) GetPTSR_TXTEN() uint32 {
	return (volatile.LoadUint32(&o.PTSR.Reg) & 0x100) >> 8
}

// Chip Identifier
type CHIPID_Type struct {
	CIDR volatile.Register32 // 0x0
	EXID volatile.Register32 // 0x4
}

// CHIPID.CIDR: Chip ID Register
func (o *CHIPID_Type) SetCIDR_VERSION(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x1f)|value)
}
func (o *CHIPID_Type) GetCIDR_VERSION() uint32 {
	return volatile.LoadUint32(&o.CIDR.Reg) & 0x1f
}
func (o *CHIPID_Type) SetCIDR_EPROC(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xe0)|value<<5)
}
func (o *CHIPID_Type) GetCIDR_EPROC() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xe0) >> 5
}
func (o *CHIPID_Type) SetCIDR_NVPSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf00)|value<<8)
}
func (o *CHIPID_Type) GetCIDR_NVPSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf00) >> 8
}
func (o *CHIPID_Type) SetCIDR_NVPSIZ2(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf000)|value<<12)
}
func (o *CHIPID_Type) GetCIDR_NVPSIZ2() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf000) >> 12
}
func (o *CHIPID_Type) SetCIDR_SRAMSIZ(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xf0000)|value<<16)
}
func (o *CHIPID_Type) GetCIDR_SRAMSIZ() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xf0000) >> 16
}
func (o *CHIPID_Type) SetCIDR_ARCH(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0xff00000)|value<<20)
}
func (o *CHIPID_Type) GetCIDR_ARCH() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0xff00000) >> 20
}
func (o *CHIPID_Type) SetCIDR_NVPTYP(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x70000000)|value<<28)
}
func (o *CHIPID_Type) GetCIDR_NVPTYP() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x70000000) >> 28
}
func (o *CHIPID_Type) SetCIDR_EXT(value uint32) {
	volatile.StoreUint32(&o.CIDR.Reg, volatile.LoadUint32(&o.CIDR.Reg)&^(0x80000000)|value<<31)
}
func (o *CHIPID_Type) GetCIDR_EXT() uint32 {
	return (volatile.LoadUint32(&o.CIDR.Reg) & 0x80000000) >> 31
}

// CHIPID.EXID: Chip ID Extension Register
func (o *CHIPID_Type) SetEXID(value uint32) {
	volatile.StoreUint32(&o.EXID.Reg, value)
}
func (o *CHIPID_Type) GetEXID() uint32 {
	return volatile.LoadUint32(&o.EXID.Reg)
}

// Embedded Flash Controller
type EFC_Type struct {
	FMR volatile.Register32 // 0x0
	FCR volatile.Register32 // 0x4
	FSR volatile.Register32 // 0x8
	FRR volatile.Register32 // 0xC
}

// EFC.FMR: EEFC Flash Mode Register
func (o *EFC_Type) SetFMR_FRDY(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetFMR_FRDY() uint32 {
	return volatile.LoadUint32(&o.FMR.Reg) & 0x1
}
func (o *EFC_Type) SetFMR_FWS(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0xf00)|value<<8)
}
func (o *EFC_Type) GetFMR_FWS() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0xf00) >> 8
}
func (o *EFC_Type) SetFMR_SCOD(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x10000)|value<<16)
}
func (o *EFC_Type) GetFMR_SCOD() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x10000) >> 16
}
func (o *EFC_Type) SetFMR_FAM(value uint32) {
	volatile.StoreUint32(&o.FMR.Reg, volatile.LoadUint32(&o.FMR.Reg)&^(0x1000000)|value<<24)
}
func (o *EFC_Type) GetFMR_FAM() uint32 {
	return (volatile.LoadUint32(&o.FMR.Reg) & 0x1000000) >> 24
}

// EFC.FCR: EEFC Flash Command Register
func (o *EFC_Type) SetFCR_FCMD(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff)|value)
}
func (o *EFC_Type) GetFCR_FCMD() uint32 {
	return volatile.LoadUint32(&o.FCR.Reg) & 0xff
}
func (o *EFC_Type) SetFCR_FARG(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xffff00)|value<<8)
}
func (o *EFC_Type) GetFCR_FARG() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xffff00) >> 8
}
func (o *EFC_Type) SetFCR_FKEY(value uint32) {
	volatile.StoreUint32(&o.FCR.Reg, volatile.LoadUint32(&o.FCR.Reg)&^(0xff000000)|value<<24)
}
func (o *EFC_Type) GetFCR_FKEY() uint32 {
	return (volatile.LoadUint32(&o.FCR.Reg) & 0xff000000) >> 24
}

// EFC.FSR: EEFC Flash Status Register
func (o *EFC_Type) SetFSR_FRDY(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0x1)|value)
}
func (o *EFC_Type) GetFSR_FRDY() uint32 {
	return volatile.LoadUint32(&o.FSR.Reg) & 0x1
}
func (o *EFC_Type) SetFSR_FCMDE(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0x2)|value<<1)
}
func (o *EFC_Type) GetFSR_FCMDE() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0x2) >> 1
}
func (o *EFC_Type) SetFSR_FLOCKE(value uint32) {
	volatile.StoreUint32(&o.FSR.Reg, volatile.LoadUint32(&o.FSR.Reg)&^(0x4)|value<<2)
}
func (o *EFC_Type) GetFSR_FLOCKE() uint32 {
	return (volatile.LoadUint32(&o.FSR.Reg) & 0x4) >> 2
}

// EFC.FRR: EEFC Flash Result Register
func (o *EFC_Type) SetFRR(value uint32) {
	volatile.StoreUint32(&o.FRR.Reg, value)
}
func (o *EFC_Type) GetFRR() uint32 {
	return volatile.LoadUint32(&o.FRR.Reg)
}

// Parallel Input/Output Controller A
type PIO_Type struct {
	PER     volatile.Register32 // 0x0
	PDR     volatile.Register32 // 0x4
	PSR     volatile.Register32 // 0x8
	_       [4]byte
	OER     volatile.Register32 // 0x10
	ODR     volatile.Register32 // 0x14
	OSR     volatile.Register32 // 0x18
	_       [4]byte
	IFER    volatile.Register32 // 0x20
	IFDR    volatile.Register32 // 0x24
	IFSR    volatile.Register32 // 0x28
	_       [4]byte
	SODR    volatile.Register32 // 0x30
	CODR    volatile.Register32 // 0x34
	ODSR    volatile.Register32 // 0x38
	PDSR    volatile.Register32 // 0x3C
	IER     volatile.Register32 // 0x40
	IDR     volatile.Register32 // 0x44
	IMR     volatile.Register32 // 0x48
	ISR     volatile.Register32 // 0x4C
	MDER    volatile.Register32 // 0x50
	MDDR    volatile.Register32 // 0x54
	MDSR    volatile.Register32 // 0x58
	_       [4]byte
	PUDR    volatile.Register32 // 0x60
	PUER    volatile.Register32 // 0x64
	PUSR    volatile.Register32 // 0x68
	_       [4]byte
	ABCDSR  [2]volatile.Register32 // 0x70
	_       [8]byte
	IFSCDR  volatile.Register32 // 0x80
	IFSCER  volatile.Register32 // 0x84
	IFSCSR  volatile.Register32 // 0x88
	SCDR    volatile.Register32 // 0x8C
	PPDDR   volatile.Register32 // 0x90
	PPDER   volatile.Register32 // 0x94
	PPDSR   volatile.Register32 // 0x98
	_       [4]byte
	OWER    volatile.Register32 // 0xA0
	OWDR    volatile.Register32 // 0xA4
	OWSR    volatile.Register32 // 0xA8
	_       [4]byte
	AIMER   volatile.Register32 // 0xB0
	AIMDR   volatile.Register32 // 0xB4
	AIMMR   volatile.Register32 // 0xB8
	_       [4]byte
	ESR     volatile.Register32 // 0xC0
	LSR     volatile.Register32 // 0xC4
	ELSR    volatile.Register32 // 0xC8
	_       [4]byte
	FELLSR  volatile.Register32 // 0xD0
	REHLSR  volatile.Register32 // 0xD4
	FRLHSR  volatile.Register32 // 0xD8
	_       [4]byte
	LOCKSR  volatile.Register32 // 0xE0
	WPMR    volatile.Register32 // 0xE4
	WPSR    volatile.Register32 // 0xE8
	_       [20]byte
	SCHMITT volatile.Register32 // 0x100
}

// PIO.PER: PIO Enable Register
func (o *PIO_Type) SetPER_P0(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPER_P0() uint32 {
	return volatile.LoadUint32(&o.PER.Reg) & 0x1
}
func (o *PIO_Type) SetPER_P1(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPER_P1() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPER_P2(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPER_P2() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPER_P3(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPER_P3() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPER_P4(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPER_P4() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPER_P5(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPER_P5() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPER_P6(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPER_P6() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPER_P7(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPER_P7() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPER_P8(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPER_P8() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPER_P9(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPER_P9() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPER_P10(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPER_P10() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPER_P11(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPER_P11() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPER_P12(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPER_P12() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPER_P13(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPER_P13() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPER_P14(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPER_P14() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPER_P15(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPER_P15() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPER_P16(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPER_P16() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPER_P17(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPER_P17() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPER_P18(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPER_P18() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPER_P19(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPER_P19() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPER_P20(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPER_P20() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPER_P21(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPER_P21() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPER_P22(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPER_P22() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPER_P23(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPER_P23() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPER_P24(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPER_P24() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPER_P25(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPER_P25() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPER_P26(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPER_P26() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPER_P27(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPER_P27() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPER_P28(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPER_P28() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPER_P29(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPER_P29() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPER_P30(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPER_P30() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPER_P31(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPER_P31() uint32 {
	return (volatile.LoadUint32(&o.PER.Reg) & 0x80000000) >> 31
}

// PIO.PDR: PIO Disable Register
func (o *PIO_Type) SetPDR_P0(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDR_P0() uint32 {
	return volatile.LoadUint32(&o.PDR.Reg) & 0x1
}
func (o *PIO_Type) SetPDR_P1(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDR_P2(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDR_P3(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDR_P4(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDR_P5(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDR_P6(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDR_P7(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDR_P8(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDR_P9(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDR_P10(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDR_P11(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDR_P12(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDR_P13(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDR_P14(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDR_P15(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDR_P16(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDR_P17(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDR_P18(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDR_P19(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDR_P20(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDR_P21(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDR_P22(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDR_P23(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDR_P24(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDR_P25(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDR_P26(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDR_P27(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDR_P28(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDR_P29(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDR_P30(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDR_P31(value uint32) {
	volatile.StoreUint32(&o.PDR.Reg, volatile.LoadUint32(&o.PDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDR.Reg) & 0x80000000) >> 31
}

// PIO.PSR: PIO Status Register
func (o *PIO_Type) SetPSR_P0(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPSR_P0() uint32 {
	return volatile.LoadUint32(&o.PSR.Reg) & 0x1
}
func (o *PIO_Type) SetPSR_P1(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPSR_P2(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPSR_P3(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPSR_P4(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPSR_P5(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPSR_P6(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPSR_P7(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPSR_P8(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPSR_P9(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPSR_P10(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPSR_P11(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPSR_P12(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPSR_P13(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPSR_P14(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPSR_P15(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPSR_P16(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPSR_P17(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPSR_P18(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPSR_P19(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPSR_P20(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPSR_P21(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPSR_P22(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPSR_P23(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPSR_P24(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPSR_P25(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPSR_P26(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPSR_P27(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPSR_P28(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPSR_P29(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPSR_P30(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPSR_P31(value uint32) {
	volatile.StoreUint32(&o.PSR.Reg, volatile.LoadUint32(&o.PSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PSR.Reg) & 0x80000000) >> 31
}

// PIO.OER: Output Enable Register
func (o *PIO_Type) SetOER_P0(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOER_P0() uint32 {
	return volatile.LoadUint32(&o.OER.Reg) & 0x1
}
func (o *PIO_Type) SetOER_P1(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOER_P1() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOER_P2(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOER_P2() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOER_P3(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOER_P3() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOER_P4(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOER_P4() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOER_P5(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOER_P5() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOER_P6(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOER_P6() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOER_P7(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOER_P7() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOER_P8(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOER_P8() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOER_P9(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOER_P9() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOER_P10(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOER_P10() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOER_P11(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOER_P11() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOER_P12(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOER_P12() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOER_P13(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOER_P13() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOER_P14(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOER_P14() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOER_P15(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOER_P15() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOER_P16(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOER_P16() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOER_P17(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOER_P17() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOER_P18(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOER_P18() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOER_P19(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOER_P19() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOER_P20(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOER_P20() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOER_P21(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOER_P21() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOER_P22(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOER_P22() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOER_P23(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOER_P23() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOER_P24(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOER_P24() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOER_P25(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOER_P25() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOER_P26(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOER_P26() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOER_P27(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOER_P27() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOER_P28(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOER_P28() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOER_P29(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOER_P29() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOER_P30(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOER_P30() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOER_P31(value uint32) {
	volatile.StoreUint32(&o.OER.Reg, volatile.LoadUint32(&o.OER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOER_P31() uint32 {
	return (volatile.LoadUint32(&o.OER.Reg) & 0x80000000) >> 31
}

// PIO.ODR: Output Disable Register
func (o *PIO_Type) SetODR_P0(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODR_P0() uint32 {
	return volatile.LoadUint32(&o.ODR.Reg) & 0x1
}
func (o *PIO_Type) SetODR_P1(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODR_P2(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODR_P3(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODR_P4(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODR_P5(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODR_P6(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODR_P7(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODR_P8(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODR_P9(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODR_P10(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODR_P11(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODR_P12(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODR_P13(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODR_P14(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODR_P15(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODR_P16(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODR_P17(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODR_P18(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODR_P19(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODR_P20(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODR_P21(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODR_P22(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODR_P23(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODR_P24(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODR_P25(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODR_P26(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODR_P27(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODR_P28(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODR_P29(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODR_P30(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODR_P31(value uint32) {
	volatile.StoreUint32(&o.ODR.Reg, volatile.LoadUint32(&o.ODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODR.Reg) & 0x80000000) >> 31
}

// PIO.OSR: Output Status Register
func (o *PIO_Type) SetOSR_P0(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOSR_P0() uint32 {
	return volatile.LoadUint32(&o.OSR.Reg) & 0x1
}
func (o *PIO_Type) SetOSR_P1(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOSR_P2(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOSR_P3(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOSR_P4(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOSR_P5(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOSR_P6(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOSR_P7(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOSR_P8(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOSR_P9(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOSR_P10(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOSR_P11(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOSR_P12(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOSR_P13(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOSR_P14(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOSR_P15(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOSR_P16(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOSR_P17(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOSR_P18(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOSR_P19(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOSR_P20(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOSR_P21(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOSR_P22(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOSR_P23(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOSR_P24(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOSR_P25(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOSR_P26(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOSR_P27(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOSR_P28(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOSR_P29(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOSR_P30(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOSR_P31(value uint32) {
	volatile.StoreUint32(&o.OSR.Reg, volatile.LoadUint32(&o.OSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OSR.Reg) & 0x80000000) >> 31
}

// PIO.IFER: Glitch Input Filter Enable Register
func (o *PIO_Type) SetIFER_P0(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFER_P0() uint32 {
	return volatile.LoadUint32(&o.IFER.Reg) & 0x1
}
func (o *PIO_Type) SetIFER_P1(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFER_P2(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFER_P3(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFER_P4(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFER_P5(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFER_P6(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFER_P7(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFER_P8(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFER_P9(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFER_P10(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFER_P11(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFER_P12(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFER_P13(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFER_P14(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFER_P15(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFER_P16(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFER_P17(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFER_P18(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFER_P19(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFER_P20(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFER_P21(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFER_P22(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFER_P23(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFER_P24(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFER_P25(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFER_P26(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFER_P27(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFER_P28(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFER_P29(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFER_P30(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFER_P31(value uint32) {
	volatile.StoreUint32(&o.IFER.Reg, volatile.LoadUint32(&o.IFER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFER.Reg) & 0x80000000) >> 31
}

// PIO.IFDR: Glitch Input Filter Disable Register
func (o *PIO_Type) SetIFDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFDR.Reg, volatile.LoadUint32(&o.IFDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSR: Glitch Input Filter Status Register
func (o *PIO_Type) SetIFSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSR.Reg, volatile.LoadUint32(&o.IFSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSR.Reg) & 0x80000000) >> 31
}

// PIO.SODR: Set Output Data Register
func (o *PIO_Type) SetSODR_P0(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSODR_P0() uint32 {
	return volatile.LoadUint32(&o.SODR.Reg) & 0x1
}
func (o *PIO_Type) SetSODR_P1(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSODR_P1() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSODR_P2(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSODR_P2() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSODR_P3(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSODR_P3() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSODR_P4(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSODR_P4() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSODR_P5(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSODR_P5() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSODR_P6(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSODR_P6() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSODR_P7(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSODR_P7() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSODR_P8(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSODR_P8() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSODR_P9(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSODR_P9() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSODR_P10(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSODR_P10() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSODR_P11(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSODR_P11() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSODR_P12(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSODR_P12() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSODR_P13(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSODR_P13() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSODR_P14(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSODR_P14() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSODR_P15(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSODR_P15() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSODR_P16(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSODR_P16() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSODR_P17(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSODR_P17() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSODR_P18(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSODR_P18() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSODR_P19(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSODR_P19() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSODR_P20(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSODR_P20() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSODR_P21(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSODR_P21() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSODR_P22(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSODR_P22() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSODR_P23(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSODR_P23() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSODR_P24(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSODR_P24() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSODR_P25(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSODR_P25() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSODR_P26(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSODR_P26() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSODR_P27(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSODR_P27() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSODR_P28(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSODR_P28() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSODR_P29(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSODR_P29() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSODR_P30(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSODR_P30() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSODR_P31(value uint32) {
	volatile.StoreUint32(&o.SODR.Reg, volatile.LoadUint32(&o.SODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSODR_P31() uint32 {
	return (volatile.LoadUint32(&o.SODR.Reg) & 0x80000000) >> 31
}

// PIO.CODR: Clear Output Data Register
func (o *PIO_Type) SetCODR_P0(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetCODR_P0() uint32 {
	return volatile.LoadUint32(&o.CODR.Reg) & 0x1
}
func (o *PIO_Type) SetCODR_P1(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetCODR_P1() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetCODR_P2(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetCODR_P2() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetCODR_P3(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetCODR_P3() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetCODR_P4(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetCODR_P4() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetCODR_P5(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetCODR_P5() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetCODR_P6(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetCODR_P6() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetCODR_P7(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetCODR_P7() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetCODR_P8(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetCODR_P8() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetCODR_P9(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetCODR_P9() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetCODR_P10(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetCODR_P10() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetCODR_P11(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetCODR_P11() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetCODR_P12(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetCODR_P12() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetCODR_P13(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetCODR_P13() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetCODR_P14(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetCODR_P14() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetCODR_P15(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetCODR_P15() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetCODR_P16(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetCODR_P16() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetCODR_P17(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetCODR_P17() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetCODR_P18(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetCODR_P18() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetCODR_P19(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetCODR_P19() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetCODR_P20(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetCODR_P20() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetCODR_P21(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetCODR_P21() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetCODR_P22(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetCODR_P22() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetCODR_P23(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetCODR_P23() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetCODR_P24(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetCODR_P24() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetCODR_P25(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetCODR_P25() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetCODR_P26(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetCODR_P26() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetCODR_P27(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetCODR_P27() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetCODR_P28(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetCODR_P28() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetCODR_P29(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetCODR_P29() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetCODR_P30(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetCODR_P30() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetCODR_P31(value uint32) {
	volatile.StoreUint32(&o.CODR.Reg, volatile.LoadUint32(&o.CODR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetCODR_P31() uint32 {
	return (volatile.LoadUint32(&o.CODR.Reg) & 0x80000000) >> 31
}

// PIO.ODSR: Output Data Status Register
func (o *PIO_Type) SetODSR_P0(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetODSR_P0() uint32 {
	return volatile.LoadUint32(&o.ODSR.Reg) & 0x1
}
func (o *PIO_Type) SetODSR_P1(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetODSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetODSR_P2(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetODSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetODSR_P3(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetODSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetODSR_P4(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetODSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetODSR_P5(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetODSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetODSR_P6(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetODSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetODSR_P7(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetODSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetODSR_P8(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetODSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetODSR_P9(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetODSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetODSR_P10(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetODSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetODSR_P11(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetODSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetODSR_P12(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetODSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetODSR_P13(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetODSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetODSR_P14(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetODSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetODSR_P15(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetODSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetODSR_P16(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetODSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetODSR_P17(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetODSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetODSR_P18(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetODSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetODSR_P19(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetODSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetODSR_P20(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetODSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetODSR_P21(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetODSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetODSR_P22(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetODSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetODSR_P23(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetODSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetODSR_P24(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetODSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetODSR_P25(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetODSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetODSR_P26(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetODSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetODSR_P27(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetODSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetODSR_P28(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetODSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetODSR_P29(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetODSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetODSR_P30(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetODSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetODSR_P31(value uint32) {
	volatile.StoreUint32(&o.ODSR.Reg, volatile.LoadUint32(&o.ODSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetODSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ODSR.Reg) & 0x80000000) >> 31
}

// PIO.PDSR: Pin Data Status Register
func (o *PIO_Type) SetPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PDSR.Reg, volatile.LoadUint32(&o.PDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PDSR.Reg) & 0x80000000) >> 31
}

// PIO.IER: Interrupt Enable Register
func (o *PIO_Type) SetIER_P0(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIER_P0() uint32 {
	return volatile.LoadUint32(&o.IER.Reg) & 0x1
}
func (o *PIO_Type) SetIER_P1(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIER_P1() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIER_P2(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIER_P2() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIER_P3(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIER_P3() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIER_P4(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIER_P4() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIER_P5(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIER_P5() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIER_P6(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIER_P6() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIER_P7(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIER_P7() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIER_P8(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIER_P8() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIER_P9(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIER_P9() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIER_P10(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIER_P10() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIER_P11(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIER_P11() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIER_P12(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIER_P12() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIER_P13(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIER_P13() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIER_P14(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIER_P14() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIER_P15(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIER_P15() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIER_P16(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIER_P16() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIER_P17(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIER_P17() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIER_P18(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIER_P18() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIER_P19(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIER_P19() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIER_P20(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIER_P20() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIER_P21(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIER_P21() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIER_P22(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIER_P22() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIER_P23(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIER_P23() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIER_P24(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIER_P24() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIER_P25(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIER_P25() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIER_P26(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIER_P26() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIER_P27(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIER_P27() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIER_P28(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIER_P28() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIER_P29(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIER_P29() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIER_P30(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIER_P30() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIER_P31(value uint32) {
	volatile.StoreUint32(&o.IER.Reg, volatile.LoadUint32(&o.IER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIER_P31() uint32 {
	return (volatile.LoadUint32(&o.IER.Reg) & 0x80000000) >> 31
}

// PIO.IDR: Interrupt Disable Register
func (o *PIO_Type) SetIDR_P0(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIDR_P0() uint32 {
	return volatile.LoadUint32(&o.IDR.Reg) & 0x1
}
func (o *PIO_Type) SetIDR_P1(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIDR_P2(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIDR_P3(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIDR_P4(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIDR_P5(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIDR_P6(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIDR_P7(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIDR_P8(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIDR_P9(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIDR_P10(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIDR_P11(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIDR_P12(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIDR_P13(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIDR_P14(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIDR_P15(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIDR_P16(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIDR_P17(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIDR_P18(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIDR_P19(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIDR_P20(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIDR_P21(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIDR_P22(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIDR_P23(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIDR_P24(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIDR_P25(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIDR_P26(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIDR_P27(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIDR_P28(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIDR_P29(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIDR_P30(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIDR_P31(value uint32) {
	volatile.StoreUint32(&o.IDR.Reg, volatile.LoadUint32(&o.IDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IDR.Reg) & 0x80000000) >> 31
}

// PIO.IMR: Interrupt Mask Register
func (o *PIO_Type) SetIMR_P0(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIMR_P0() uint32 {
	return volatile.LoadUint32(&o.IMR.Reg) & 0x1
}
func (o *PIO_Type) SetIMR_P1(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIMR_P1() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIMR_P2(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIMR_P2() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIMR_P3(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIMR_P3() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIMR_P4(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIMR_P4() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIMR_P5(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIMR_P5() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIMR_P6(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIMR_P6() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIMR_P7(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIMR_P7() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIMR_P8(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIMR_P8() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIMR_P9(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIMR_P9() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIMR_P10(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIMR_P10() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIMR_P11(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIMR_P11() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIMR_P12(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIMR_P12() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIMR_P13(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIMR_P13() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIMR_P14(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIMR_P14() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIMR_P15(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIMR_P15() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIMR_P16(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIMR_P16() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIMR_P17(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIMR_P17() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIMR_P18(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIMR_P18() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIMR_P19(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIMR_P19() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIMR_P20(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIMR_P20() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIMR_P21(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIMR_P21() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIMR_P22(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIMR_P22() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIMR_P23(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIMR_P23() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIMR_P24(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIMR_P24() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIMR_P25(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIMR_P25() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIMR_P26(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIMR_P26() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIMR_P27(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIMR_P27() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIMR_P28(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIMR_P28() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIMR_P29(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIMR_P29() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIMR_P30(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIMR_P30() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIMR_P31(value uint32) {
	volatile.StoreUint32(&o.IMR.Reg, volatile.LoadUint32(&o.IMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIMR_P31() uint32 {
	return (volatile.LoadUint32(&o.IMR.Reg) & 0x80000000) >> 31
}

// PIO.ISR: Interrupt Status Register
func (o *PIO_Type) SetISR_P0(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetISR_P0() uint32 {
	return volatile.LoadUint32(&o.ISR.Reg) & 0x1
}
func (o *PIO_Type) SetISR_P1(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetISR_P1() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetISR_P2(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetISR_P2() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetISR_P3(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetISR_P3() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetISR_P4(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetISR_P4() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetISR_P5(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetISR_P5() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetISR_P6(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetISR_P6() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetISR_P7(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetISR_P7() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetISR_P8(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetISR_P8() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetISR_P9(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetISR_P9() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetISR_P10(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetISR_P10() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetISR_P11(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetISR_P11() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetISR_P12(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetISR_P12() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetISR_P13(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetISR_P13() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetISR_P14(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetISR_P14() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetISR_P15(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetISR_P15() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetISR_P16(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetISR_P16() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetISR_P17(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetISR_P17() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetISR_P18(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetISR_P18() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetISR_P19(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetISR_P19() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetISR_P20(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetISR_P20() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetISR_P21(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetISR_P21() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetISR_P22(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetISR_P22() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetISR_P23(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetISR_P23() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetISR_P24(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetISR_P24() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetISR_P25(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetISR_P25() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetISR_P26(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetISR_P26() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetISR_P27(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetISR_P27() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetISR_P28(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetISR_P28() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetISR_P29(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetISR_P29() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetISR_P30(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetISR_P30() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetISR_P31(value uint32) {
	volatile.StoreUint32(&o.ISR.Reg, volatile.LoadUint32(&o.ISR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetISR_P31() uint32 {
	return (volatile.LoadUint32(&o.ISR.Reg) & 0x80000000) >> 31
}

// PIO.MDER: Multi-driver Enable Register
func (o *PIO_Type) SetMDER_P0(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDER_P0() uint32 {
	return volatile.LoadUint32(&o.MDER.Reg) & 0x1
}
func (o *PIO_Type) SetMDER_P1(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDER_P1() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDER_P2(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDER_P2() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDER_P3(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDER_P3() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDER_P4(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDER_P4() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDER_P5(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDER_P5() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDER_P6(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDER_P6() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDER_P7(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDER_P7() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDER_P8(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDER_P8() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDER_P9(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDER_P9() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDER_P10(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDER_P10() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDER_P11(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDER_P11() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDER_P12(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDER_P12() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDER_P13(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDER_P13() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDER_P14(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDER_P14() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDER_P15(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDER_P15() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDER_P16(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDER_P16() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDER_P17(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDER_P17() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDER_P18(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDER_P18() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDER_P19(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDER_P19() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDER_P20(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDER_P20() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDER_P21(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDER_P21() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDER_P22(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDER_P22() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDER_P23(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDER_P23() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDER_P24(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDER_P24() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDER_P25(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDER_P25() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDER_P26(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDER_P26() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDER_P27(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDER_P27() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDER_P28(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDER_P28() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDER_P29(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDER_P29() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDER_P30(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDER_P30() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDER_P31(value uint32) {
	volatile.StoreUint32(&o.MDER.Reg, volatile.LoadUint32(&o.MDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDER_P31() uint32 {
	return (volatile.LoadUint32(&o.MDER.Reg) & 0x80000000) >> 31
}

// PIO.MDDR: Multi-driver Disable Register
func (o *PIO_Type) SetMDDR_P0(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDDR_P0() uint32 {
	return volatile.LoadUint32(&o.MDDR.Reg) & 0x1
}
func (o *PIO_Type) SetMDDR_P1(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDDR_P2(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDDR_P3(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDDR_P4(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDDR_P5(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDDR_P6(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDDR_P7(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDDR_P8(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDDR_P9(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDDR_P10(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDDR_P11(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDDR_P12(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDDR_P13(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDDR_P14(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDDR_P15(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDDR_P16(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDDR_P17(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDDR_P18(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDDR_P19(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDDR_P20(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDDR_P21(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDDR_P22(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDDR_P23(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDDR_P24(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDDR_P25(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDDR_P26(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDDR_P27(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDDR_P28(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDDR_P29(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDDR_P30(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDDR_P31(value uint32) {
	volatile.StoreUint32(&o.MDDR.Reg, volatile.LoadUint32(&o.MDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDDR.Reg) & 0x80000000) >> 31
}

// PIO.MDSR: Multi-driver Status Register
func (o *PIO_Type) SetMDSR_P0(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetMDSR_P0() uint32 {
	return volatile.LoadUint32(&o.MDSR.Reg) & 0x1
}
func (o *PIO_Type) SetMDSR_P1(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetMDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetMDSR_P2(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetMDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetMDSR_P3(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetMDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetMDSR_P4(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetMDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetMDSR_P5(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetMDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetMDSR_P6(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetMDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetMDSR_P7(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetMDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetMDSR_P8(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetMDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetMDSR_P9(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetMDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetMDSR_P10(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetMDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetMDSR_P11(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetMDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetMDSR_P12(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetMDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetMDSR_P13(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetMDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetMDSR_P14(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetMDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetMDSR_P15(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetMDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetMDSR_P16(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetMDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetMDSR_P17(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetMDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetMDSR_P18(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetMDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetMDSR_P19(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetMDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetMDSR_P20(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetMDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetMDSR_P21(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetMDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetMDSR_P22(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetMDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetMDSR_P23(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetMDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetMDSR_P24(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetMDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetMDSR_P25(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetMDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetMDSR_P26(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetMDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetMDSR_P27(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetMDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetMDSR_P28(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetMDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetMDSR_P29(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetMDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetMDSR_P30(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetMDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetMDSR_P31(value uint32) {
	volatile.StoreUint32(&o.MDSR.Reg, volatile.LoadUint32(&o.MDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetMDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.MDSR.Reg) & 0x80000000) >> 31
}

// PIO.PUDR: Pull-up Disable Register
func (o *PIO_Type) SetPUDR_P0(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUDR_P0() uint32 {
	return volatile.LoadUint32(&o.PUDR.Reg) & 0x1
}
func (o *PIO_Type) SetPUDR_P1(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUDR_P2(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUDR_P3(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUDR_P4(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUDR_P5(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUDR_P6(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUDR_P7(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUDR_P8(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUDR_P9(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUDR_P10(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUDR_P11(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUDR_P12(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUDR_P13(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUDR_P14(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUDR_P15(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUDR_P16(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUDR_P17(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUDR_P18(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUDR_P19(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUDR_P20(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUDR_P21(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUDR_P22(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUDR_P23(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUDR_P24(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUDR_P25(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUDR_P26(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUDR_P27(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUDR_P28(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUDR_P29(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUDR_P30(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUDR_P31(value uint32) {
	volatile.StoreUint32(&o.PUDR.Reg, volatile.LoadUint32(&o.PUDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUDR.Reg) & 0x80000000) >> 31
}

// PIO.PUER: Pull-up Enable Register
func (o *PIO_Type) SetPUER_P0(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUER_P0() uint32 {
	return volatile.LoadUint32(&o.PUER.Reg) & 0x1
}
func (o *PIO_Type) SetPUER_P1(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUER_P1() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUER_P2(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUER_P2() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUER_P3(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUER_P3() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUER_P4(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUER_P4() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUER_P5(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUER_P5() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUER_P6(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUER_P6() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUER_P7(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUER_P7() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUER_P8(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUER_P8() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUER_P9(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUER_P9() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUER_P10(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUER_P10() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUER_P11(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUER_P11() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUER_P12(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUER_P12() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUER_P13(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUER_P13() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUER_P14(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUER_P14() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUER_P15(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUER_P15() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUER_P16(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUER_P16() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUER_P17(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUER_P17() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUER_P18(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUER_P18() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUER_P19(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUER_P19() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUER_P20(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUER_P20() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUER_P21(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUER_P21() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUER_P22(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUER_P22() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUER_P23(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUER_P23() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUER_P24(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUER_P24() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUER_P25(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUER_P25() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUER_P26(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUER_P26() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUER_P27(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUER_P27() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUER_P28(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUER_P28() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUER_P29(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUER_P29() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUER_P30(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUER_P30() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUER_P31(value uint32) {
	volatile.StoreUint32(&o.PUER.Reg, volatile.LoadUint32(&o.PUER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUER_P31() uint32 {
	return (volatile.LoadUint32(&o.PUER.Reg) & 0x80000000) >> 31
}

// PIO.PUSR: Pad Pull-up Status Register
func (o *PIO_Type) SetPUSR_P0(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPUSR_P0() uint32 {
	return volatile.LoadUint32(&o.PUSR.Reg) & 0x1
}
func (o *PIO_Type) SetPUSR_P1(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPUSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPUSR_P2(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPUSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPUSR_P3(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPUSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPUSR_P4(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPUSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPUSR_P5(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPUSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPUSR_P6(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPUSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPUSR_P7(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPUSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPUSR_P8(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPUSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPUSR_P9(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPUSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPUSR_P10(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPUSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPUSR_P11(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPUSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPUSR_P12(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPUSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPUSR_P13(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPUSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPUSR_P14(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPUSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPUSR_P15(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPUSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPUSR_P16(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPUSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPUSR_P17(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPUSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPUSR_P18(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPUSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPUSR_P19(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPUSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPUSR_P20(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPUSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPUSR_P21(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPUSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPUSR_P22(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPUSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPUSR_P23(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPUSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPUSR_P24(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPUSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPUSR_P25(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPUSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPUSR_P26(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPUSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPUSR_P27(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPUSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPUSR_P28(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPUSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPUSR_P29(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPUSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPUSR_P30(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPUSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPUSR_P31(value uint32) {
	volatile.StoreUint32(&o.PUSR.Reg, volatile.LoadUint32(&o.PUSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPUSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PUSR.Reg) & 0x80000000) >> 31
}

// PIO.ABCDSR: Peripheral Select Register
func (o *PIO_Type) SetABCDSR_P0(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetABCDSR_P0(idx int) uint32 {
	return volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1
}
func (o *PIO_Type) SetABCDSR_P1(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetABCDSR_P1(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetABCDSR_P2(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetABCDSR_P2(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetABCDSR_P3(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetABCDSR_P3(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetABCDSR_P4(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetABCDSR_P4(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetABCDSR_P5(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetABCDSR_P5(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetABCDSR_P6(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetABCDSR_P6(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetABCDSR_P7(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetABCDSR_P7(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetABCDSR_P8(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetABCDSR_P8(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetABCDSR_P9(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetABCDSR_P9(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetABCDSR_P10(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetABCDSR_P10(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetABCDSR_P11(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetABCDSR_P11(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetABCDSR_P12(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetABCDSR_P12(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetABCDSR_P13(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetABCDSR_P13(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetABCDSR_P14(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetABCDSR_P14(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetABCDSR_P15(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetABCDSR_P15(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetABCDSR_P16(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetABCDSR_P16(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetABCDSR_P17(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetABCDSR_P17(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetABCDSR_P18(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetABCDSR_P18(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetABCDSR_P19(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetABCDSR_P19(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetABCDSR_P20(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetABCDSR_P20(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetABCDSR_P21(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetABCDSR_P21(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetABCDSR_P22(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetABCDSR_P22(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetABCDSR_P23(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetABCDSR_P23(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetABCDSR_P24(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetABCDSR_P24(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetABCDSR_P25(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetABCDSR_P25(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetABCDSR_P26(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetABCDSR_P26(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetABCDSR_P27(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetABCDSR_P27(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetABCDSR_P28(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetABCDSR_P28(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetABCDSR_P29(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetABCDSR_P29(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetABCDSR_P30(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetABCDSR_P30(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetABCDSR_P31(idx int, value uint32) {
	volatile.StoreUint32(&o.ABCDSR[idx].Reg, volatile.LoadUint32(&o.ABCDSR[idx].Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetABCDSR_P31(idx int) uint32 {
	return (volatile.LoadUint32(&o.ABCDSR[idx].Reg) & 0x80000000) >> 31
}

// PIO.IFSCDR: Input Filter Slow Clock Disable Register
func (o *PIO_Type) SetIFSCDR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCDR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCDR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCDR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCDR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCDR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCDR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCDR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCDR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCDR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCDR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCDR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCDR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCDR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCDR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCDR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCDR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCDR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCDR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCDR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCDR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCDR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCDR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCDR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCDR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCDR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCDR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCDR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCDR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCDR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCDR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCDR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCDR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCDR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCDR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCDR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCDR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCDR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCDR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCDR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCDR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCDR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCDR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCDR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCDR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCDR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCDR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCDR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCDR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCDR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCDR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCDR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCDR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCDR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCDR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCDR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCDR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCDR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCDR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCDR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCDR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCDR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCDR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCDR.Reg, volatile.LoadUint32(&o.IFSCDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCDR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCDR.Reg) & 0x80000000) >> 31
}

// PIO.IFSCER: Input Filter Slow Clock Enable Register
func (o *PIO_Type) SetIFSCER_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCER_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCER.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCER_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCER_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCER_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCER_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCER_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCER_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCER_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCER_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCER_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCER_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCER_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCER_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCER_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCER_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCER_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCER_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCER_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCER_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCER_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCER_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCER_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCER_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCER_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCER_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCER_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCER_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCER_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCER_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCER_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCER_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCER_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCER_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCER_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCER_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCER_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCER_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCER_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCER_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCER_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCER_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCER_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCER_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCER_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCER_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCER_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCER_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCER_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCER_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCER_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCER_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCER_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCER_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCER_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCER_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCER_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCER_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCER_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCER_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCER_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCER_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCER_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCER.Reg, volatile.LoadUint32(&o.IFSCER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCER_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCER.Reg) & 0x80000000) >> 31
}

// PIO.IFSCSR: Input Filter Slow Clock Status Register
func (o *PIO_Type) SetIFSCSR_P0(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetIFSCSR_P0() uint32 {
	return volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1
}
func (o *PIO_Type) SetIFSCSR_P1(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetIFSCSR_P1() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetIFSCSR_P2(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetIFSCSR_P2() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetIFSCSR_P3(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetIFSCSR_P3() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetIFSCSR_P4(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetIFSCSR_P4() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetIFSCSR_P5(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetIFSCSR_P5() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetIFSCSR_P6(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetIFSCSR_P6() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetIFSCSR_P7(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetIFSCSR_P7() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetIFSCSR_P8(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetIFSCSR_P8() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetIFSCSR_P9(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetIFSCSR_P9() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetIFSCSR_P10(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetIFSCSR_P10() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetIFSCSR_P11(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetIFSCSR_P11() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetIFSCSR_P12(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetIFSCSR_P12() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetIFSCSR_P13(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetIFSCSR_P13() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetIFSCSR_P14(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetIFSCSR_P14() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetIFSCSR_P15(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetIFSCSR_P15() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetIFSCSR_P16(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetIFSCSR_P16() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetIFSCSR_P17(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetIFSCSR_P17() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetIFSCSR_P18(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetIFSCSR_P18() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetIFSCSR_P19(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetIFSCSR_P19() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetIFSCSR_P20(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetIFSCSR_P20() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetIFSCSR_P21(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetIFSCSR_P21() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetIFSCSR_P22(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetIFSCSR_P22() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetIFSCSR_P23(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetIFSCSR_P23() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetIFSCSR_P24(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetIFSCSR_P24() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetIFSCSR_P25(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetIFSCSR_P25() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetIFSCSR_P26(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetIFSCSR_P26() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetIFSCSR_P27(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetIFSCSR_P27() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetIFSCSR_P28(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetIFSCSR_P28() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetIFSCSR_P29(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetIFSCSR_P29() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetIFSCSR_P30(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetIFSCSR_P30() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetIFSCSR_P31(value uint32) {
	volatile.StoreUint32(&o.IFSCSR.Reg, volatile.LoadUint32(&o.IFSCSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetIFSCSR_P31() uint32 {
	return (volatile.LoadUint32(&o.IFSCSR.Reg) & 0x80000000) >> 31
}

// PIO.SCDR: Slow Clock Divider Debouncing Register
func (o *PIO_Type) SetSCDR_DIV(value uint32) {
	volatile.StoreUint32(&o.SCDR.Reg, volatile.LoadUint32(&o.SCDR.Reg)&^(0x3fff)|value)
}
func (o *PIO_Type) GetSCDR_DIV() uint32 {
	return volatile.LoadUint32(&o.SCDR.Reg) & 0x3fff
}

// PIO.PPDDR: Pad Pull-down Disable Register
func (o *PIO_Type) SetPPDDR_P0(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDDR_P0() uint32 {
	return volatile.LoadUint32(&o.PPDDR.Reg) & 0x1
}
func (o *PIO_Type) SetPPDDR_P1(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDDR_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDDR_P2(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDDR_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDDR_P3(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDDR_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDDR_P4(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDDR_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDDR_P5(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDDR_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDDR_P6(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDDR_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDDR_P7(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDDR_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDDR_P8(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDDR_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDDR_P9(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDDR_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDDR_P10(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDDR_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDDR_P11(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDDR_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDDR_P12(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDDR_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDDR_P13(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDDR_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDDR_P14(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDDR_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDDR_P15(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDDR_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDDR_P16(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDDR_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDDR_P17(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDDR_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDDR_P18(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDDR_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDDR_P19(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDDR_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDDR_P20(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDDR_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDDR_P21(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDDR_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDDR_P22(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDDR_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDDR_P23(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDDR_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDDR_P24(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDDR_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDDR_P25(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDDR_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDDR_P26(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDDR_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDDR_P27(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDDR_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDDR_P28(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDDR_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDDR_P29(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDDR_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDDR_P30(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDDR_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDDR_P31(value uint32) {
	volatile.StoreUint32(&o.PPDDR.Reg, volatile.LoadUint32(&o.PPDDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDDR_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDDR.Reg) & 0x80000000) >> 31
}

// PIO.PPDER: Pad Pull-down Enable Register
func (o *PIO_Type) SetPPDER_P0(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDER_P0() uint32 {
	return volatile.LoadUint32(&o.PPDER.Reg) & 0x1
}
func (o *PIO_Type) SetPPDER_P1(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDER_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDER_P2(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDER_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDER_P3(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDER_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDER_P4(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDER_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDER_P5(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDER_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDER_P6(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDER_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDER_P7(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDER_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDER_P8(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDER_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDER_P9(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDER_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDER_P10(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDER_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDER_P11(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDER_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDER_P12(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDER_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDER_P13(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDER_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDER_P14(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDER_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDER_P15(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDER_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDER_P16(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDER_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDER_P17(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDER_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDER_P18(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDER_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDER_P19(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDER_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDER_P20(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDER_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDER_P21(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDER_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDER_P22(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDER_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDER_P23(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDER_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDER_P24(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDER_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDER_P25(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDER_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDER_P26(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDER_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDER_P27(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDER_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDER_P28(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDER_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDER_P29(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDER_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDER_P30(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDER_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDER_P31(value uint32) {
	volatile.StoreUint32(&o.PPDER.Reg, volatile.LoadUint32(&o.PPDER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDER_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDER.Reg) & 0x80000000) >> 31
}

// PIO.PPDSR: Pad Pull-down Status Register
func (o *PIO_Type) SetPPDSR_P0(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetPPDSR_P0() uint32 {
	return volatile.LoadUint32(&o.PPDSR.Reg) & 0x1
}
func (o *PIO_Type) SetPPDSR_P1(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetPPDSR_P1() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetPPDSR_P2(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetPPDSR_P2() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetPPDSR_P3(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetPPDSR_P3() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetPPDSR_P4(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetPPDSR_P4() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetPPDSR_P5(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetPPDSR_P5() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetPPDSR_P6(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetPPDSR_P6() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetPPDSR_P7(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetPPDSR_P7() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetPPDSR_P8(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetPPDSR_P8() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetPPDSR_P9(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetPPDSR_P9() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetPPDSR_P10(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetPPDSR_P10() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetPPDSR_P11(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetPPDSR_P11() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetPPDSR_P12(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetPPDSR_P12() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetPPDSR_P13(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetPPDSR_P13() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetPPDSR_P14(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetPPDSR_P14() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetPPDSR_P15(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetPPDSR_P15() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetPPDSR_P16(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetPPDSR_P16() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetPPDSR_P17(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetPPDSR_P17() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetPPDSR_P18(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetPPDSR_P18() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetPPDSR_P19(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetPPDSR_P19() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetPPDSR_P20(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetPPDSR_P20() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetPPDSR_P21(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetPPDSR_P21() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetPPDSR_P22(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetPPDSR_P22() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetPPDSR_P23(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetPPDSR_P23() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetPPDSR_P24(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetPPDSR_P24() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetPPDSR_P25(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetPPDSR_P25() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetPPDSR_P26(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetPPDSR_P26() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetPPDSR_P27(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetPPDSR_P27() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetPPDSR_P28(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetPPDSR_P28() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetPPDSR_P29(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetPPDSR_P29() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetPPDSR_P30(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetPPDSR_P30() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetPPDSR_P31(value uint32) {
	volatile.StoreUint32(&o.PPDSR.Reg, volatile.LoadUint32(&o.PPDSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetPPDSR_P31() uint32 {
	return (volatile.LoadUint32(&o.PPDSR.Reg) & 0x80000000) >> 31
}

// PIO.OWER: Output Write Enable
func (o *PIO_Type) SetOWER_P0(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWER_P0() uint32 {
	return volatile.LoadUint32(&o.OWER.Reg) & 0x1
}
func (o *PIO_Type) SetOWER_P1(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWER_P1() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWER_P2(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWER_P2() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWER_P3(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWER_P3() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWER_P4(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWER_P4() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWER_P5(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWER_P5() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWER_P6(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWER_P6() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWER_P7(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWER_P7() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWER_P8(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWER_P8() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWER_P9(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWER_P9() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWER_P10(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWER_P10() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWER_P11(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWER_P11() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWER_P12(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWER_P12() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWER_P13(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWER_P13() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWER_P14(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWER_P14() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWER_P15(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWER_P15() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWER_P16(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWER_P16() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWER_P17(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWER_P17() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWER_P18(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWER_P18() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWER_P19(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWER_P19() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWER_P20(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWER_P20() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWER_P21(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWER_P21() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWER_P22(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWER_P22() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWER_P23(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWER_P23() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWER_P24(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWER_P24() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWER_P25(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWER_P25() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWER_P26(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWER_P26() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWER_P27(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWER_P27() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWER_P28(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWER_P28() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWER_P29(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWER_P29() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWER_P30(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWER_P30() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWER_P31(value uint32) {
	volatile.StoreUint32(&o.OWER.Reg, volatile.LoadUint32(&o.OWER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWER_P31() uint32 {
	return (volatile.LoadUint32(&o.OWER.Reg) & 0x80000000) >> 31
}

// PIO.OWDR: Output Write Disable
func (o *PIO_Type) SetOWDR_P0(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWDR_P0() uint32 {
	return volatile.LoadUint32(&o.OWDR.Reg) & 0x1
}
func (o *PIO_Type) SetOWDR_P1(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWDR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWDR_P2(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWDR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWDR_P3(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWDR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWDR_P4(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWDR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWDR_P5(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWDR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWDR_P6(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWDR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWDR_P7(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWDR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWDR_P8(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWDR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWDR_P9(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWDR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWDR_P10(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWDR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWDR_P11(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWDR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWDR_P12(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWDR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWDR_P13(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWDR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWDR_P14(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWDR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWDR_P15(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWDR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWDR_P16(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWDR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWDR_P17(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWDR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWDR_P18(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWDR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWDR_P19(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWDR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWDR_P20(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWDR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWDR_P21(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWDR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWDR_P22(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWDR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWDR_P23(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWDR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWDR_P24(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWDR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWDR_P25(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWDR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWDR_P26(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWDR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWDR_P27(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWDR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWDR_P28(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWDR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWDR_P29(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWDR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWDR_P30(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWDR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWDR_P31(value uint32) {
	volatile.StoreUint32(&o.OWDR.Reg, volatile.LoadUint32(&o.OWDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWDR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWDR.Reg) & 0x80000000) >> 31
}

// PIO.OWSR: Output Write Status Register
func (o *PIO_Type) SetOWSR_P0(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetOWSR_P0() uint32 {
	return volatile.LoadUint32(&o.OWSR.Reg) & 0x1
}
func (o *PIO_Type) SetOWSR_P1(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetOWSR_P1() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetOWSR_P2(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetOWSR_P2() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetOWSR_P3(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetOWSR_P3() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetOWSR_P4(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetOWSR_P4() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetOWSR_P5(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetOWSR_P5() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetOWSR_P6(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetOWSR_P6() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetOWSR_P7(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetOWSR_P7() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetOWSR_P8(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetOWSR_P8() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetOWSR_P9(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetOWSR_P9() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetOWSR_P10(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetOWSR_P10() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetOWSR_P11(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetOWSR_P11() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetOWSR_P12(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetOWSR_P12() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetOWSR_P13(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetOWSR_P13() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetOWSR_P14(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetOWSR_P14() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetOWSR_P15(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetOWSR_P15() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetOWSR_P16(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetOWSR_P16() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetOWSR_P17(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetOWSR_P17() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetOWSR_P18(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetOWSR_P18() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetOWSR_P19(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetOWSR_P19() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetOWSR_P20(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetOWSR_P20() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetOWSR_P21(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetOWSR_P21() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetOWSR_P22(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetOWSR_P22() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetOWSR_P23(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetOWSR_P23() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetOWSR_P24(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetOWSR_P24() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetOWSR_P25(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetOWSR_P25() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetOWSR_P26(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetOWSR_P26() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetOWSR_P27(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetOWSR_P27() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetOWSR_P28(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetOWSR_P28() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetOWSR_P29(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetOWSR_P29() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetOWSR_P30(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetOWSR_P30() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetOWSR_P31(value uint32) {
	volatile.StoreUint32(&o.OWSR.Reg, volatile.LoadUint32(&o.OWSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetOWSR_P31() uint32 {
	return (volatile.LoadUint32(&o.OWSR.Reg) & 0x80000000) >> 31
}

// PIO.AIMER: Additional Interrupt Modes Enable Register
func (o *PIO_Type) SetAIMER_P0(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMER_P0() uint32 {
	return volatile.LoadUint32(&o.AIMER.Reg) & 0x1
}
func (o *PIO_Type) SetAIMER_P1(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMER_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMER_P2(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMER_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMER_P3(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMER_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMER_P4(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMER_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMER_P5(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMER_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMER_P6(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMER_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMER_P7(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMER_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMER_P8(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMER_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMER_P9(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMER_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMER_P10(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMER_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMER_P11(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMER_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMER_P12(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMER_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMER_P13(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMER_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMER_P14(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMER_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMER_P15(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMER_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMER_P16(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMER_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMER_P17(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMER_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMER_P18(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMER_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMER_P19(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMER_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMER_P20(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMER_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMER_P21(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMER_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMER_P22(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMER_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMER_P23(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMER_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMER_P24(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMER_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMER_P25(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMER_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMER_P26(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMER_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMER_P27(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMER_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMER_P28(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMER_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMER_P29(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMER_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMER_P30(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMER_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMER_P31(value uint32) {
	volatile.StoreUint32(&o.AIMER.Reg, volatile.LoadUint32(&o.AIMER.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMER_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMER.Reg) & 0x80000000) >> 31
}

// PIO.AIMDR: Additional Interrupt Modes Disables Register
func (o *PIO_Type) SetAIMDR_P0(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMDR_P0() uint32 {
	return volatile.LoadUint32(&o.AIMDR.Reg) & 0x1
}
func (o *PIO_Type) SetAIMDR_P1(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMDR_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMDR_P2(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMDR_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMDR_P3(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMDR_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMDR_P4(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMDR_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMDR_P5(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMDR_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMDR_P6(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMDR_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMDR_P7(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMDR_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMDR_P8(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMDR_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMDR_P9(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMDR_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMDR_P10(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMDR_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMDR_P11(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMDR_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMDR_P12(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMDR_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMDR_P13(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMDR_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMDR_P14(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMDR_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMDR_P15(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMDR_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMDR_P16(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMDR_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMDR_P17(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMDR_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMDR_P18(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMDR_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMDR_P19(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMDR_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMDR_P20(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMDR_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMDR_P21(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMDR_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMDR_P22(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMDR_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMDR_P23(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMDR_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMDR_P24(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMDR_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMDR_P25(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMDR_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMDR_P26(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMDR_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMDR_P27(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMDR_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMDR_P28(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMDR_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMDR_P29(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMDR_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMDR_P30(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMDR_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMDR_P31(value uint32) {
	volatile.StoreUint32(&o.AIMDR.Reg, volatile.LoadUint32(&o.AIMDR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMDR_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMDR.Reg) & 0x80000000) >> 31
}

// PIO.AIMMR: Additional Interrupt Modes Mask Register
func (o *PIO_Type) SetAIMMR_P0(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetAIMMR_P0() uint32 {
	return volatile.LoadUint32(&o.AIMMR.Reg) & 0x1
}
func (o *PIO_Type) SetAIMMR_P1(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetAIMMR_P1() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetAIMMR_P2(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetAIMMR_P2() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetAIMMR_P3(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetAIMMR_P3() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetAIMMR_P4(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetAIMMR_P4() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetAIMMR_P5(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetAIMMR_P5() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetAIMMR_P6(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetAIMMR_P6() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetAIMMR_P7(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetAIMMR_P7() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetAIMMR_P8(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetAIMMR_P8() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetAIMMR_P9(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetAIMMR_P9() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetAIMMR_P10(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetAIMMR_P10() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetAIMMR_P11(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetAIMMR_P11() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetAIMMR_P12(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetAIMMR_P12() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetAIMMR_P13(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetAIMMR_P13() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetAIMMR_P14(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetAIMMR_P14() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetAIMMR_P15(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetAIMMR_P15() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetAIMMR_P16(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetAIMMR_P16() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetAIMMR_P17(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetAIMMR_P17() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetAIMMR_P18(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetAIMMR_P18() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetAIMMR_P19(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetAIMMR_P19() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetAIMMR_P20(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetAIMMR_P20() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetAIMMR_P21(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetAIMMR_P21() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetAIMMR_P22(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetAIMMR_P22() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetAIMMR_P23(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetAIMMR_P23() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetAIMMR_P24(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetAIMMR_P24() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetAIMMR_P25(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetAIMMR_P25() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetAIMMR_P26(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetAIMMR_P26() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetAIMMR_P27(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetAIMMR_P27() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetAIMMR_P28(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetAIMMR_P28() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetAIMMR_P29(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetAIMMR_P29() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetAIMMR_P30(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetAIMMR_P30() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetAIMMR_P31(value uint32) {
	volatile.StoreUint32(&o.AIMMR.Reg, volatile.LoadUint32(&o.AIMMR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetAIMMR_P31() uint32 {
	return (volatile.LoadUint32(&o.AIMMR.Reg) & 0x80000000) >> 31
}

// PIO.ESR: Edge Select Register
func (o *PIO_Type) SetESR_P0(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetESR_P0() uint32 {
	return volatile.LoadUint32(&o.ESR.Reg) & 0x1
}
func (o *PIO_Type) SetESR_P1(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetESR_P1() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetESR_P2(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetESR_P2() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetESR_P3(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetESR_P3() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetESR_P4(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetESR_P4() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetESR_P5(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetESR_P5() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetESR_P6(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetESR_P6() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetESR_P7(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetESR_P7() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetESR_P8(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetESR_P8() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetESR_P9(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetESR_P9() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetESR_P10(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetESR_P10() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetESR_P11(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetESR_P11() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetESR_P12(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetESR_P12() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetESR_P13(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetESR_P13() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetESR_P14(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetESR_P14() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetESR_P15(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetESR_P15() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetESR_P16(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetESR_P16() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetESR_P17(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetESR_P17() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetESR_P18(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetESR_P18() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetESR_P19(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetESR_P19() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetESR_P20(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetESR_P20() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetESR_P21(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetESR_P21() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetESR_P22(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetESR_P22() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetESR_P23(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetESR_P23() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetESR_P24(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetESR_P24() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetESR_P25(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetESR_P25() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetESR_P26(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetESR_P26() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetESR_P27(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetESR_P27() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetESR_P28(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetESR_P28() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetESR_P29(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetESR_P29() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetESR_P30(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetESR_P30() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetESR_P31(value uint32) {
	volatile.StoreUint32(&o.ESR.Reg, volatile.LoadUint32(&o.ESR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetESR_P31() uint32 {
	return (volatile.LoadUint32(&o.ESR.Reg) & 0x80000000) >> 31
}

// PIO.LSR: Level Select Register
func (o *PIO_Type) SetLSR_P0(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetLSR_P0() uint32 {
	return volatile.LoadUint32(&o.LSR.Reg) & 0x1
}
func (o *PIO_Type) SetLSR_P1(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetLSR_P2(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetLSR_P3(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetLSR_P4(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetLSR_P5(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetLSR_P6(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetLSR_P7(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetLSR_P8(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetLSR_P9(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetLSR_P10(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetLSR_P11(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetLSR_P12(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetLSR_P13(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetLSR_P14(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetLSR_P15(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetLSR_P16(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetLSR_P17(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetLSR_P18(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetLSR_P19(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetLSR_P20(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetLSR_P21(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetLSR_P22(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetLSR_P23(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetLSR_P24(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetLSR_P25(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetLSR_P26(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetLSR_P27(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetLSR_P28(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetLSR_P29(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetLSR_P30(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetLSR_P31(value uint32) {
	volatile.StoreUint32(&o.LSR.Reg, volatile.LoadUint32(&o.LSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.LSR.Reg) & 0x80000000) >> 31
}

// PIO.ELSR: Edge/Level Status Register
func (o *PIO_Type) SetELSR_P0(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetELSR_P0() uint32 {
	return volatile.LoadUint32(&o.ELSR.Reg) & 0x1
}
func (o *PIO_Type) SetELSR_P1(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetELSR_P1() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetELSR_P2(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetELSR_P2() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetELSR_P3(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetELSR_P3() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetELSR_P4(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetELSR_P4() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetELSR_P5(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetELSR_P5() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetELSR_P6(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetELSR_P6() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetELSR_P7(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetELSR_P7() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetELSR_P8(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetELSR_P8() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetELSR_P9(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetELSR_P9() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetELSR_P10(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetELSR_P10() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetELSR_P11(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetELSR_P11() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetELSR_P12(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetELSR_P12() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetELSR_P13(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetELSR_P13() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetELSR_P14(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetELSR_P14() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetELSR_P15(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetELSR_P15() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetELSR_P16(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetELSR_P16() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetELSR_P17(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetELSR_P17() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetELSR_P18(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetELSR_P18() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetELSR_P19(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetELSR_P19() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetELSR_P20(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetELSR_P20() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetELSR_P21(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetELSR_P21() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetELSR_P22(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetELSR_P22() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetELSR_P23(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetELSR_P23() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetELSR_P24(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetELSR_P24() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetELSR_P25(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetELSR_P25() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetELSR_P26(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetELSR_P26() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetELSR_P27(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetELSR_P27() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetELSR_P28(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetELSR_P28() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetELSR_P29(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetELSR_P29() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetELSR_P30(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetELSR_P30() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetELSR_P31(value uint32) {
	volatile.StoreUint32(&o.ELSR.Reg, volatile.LoadUint32(&o.ELSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetELSR_P31() uint32 {
	return (volatile.LoadUint32(&o.ELSR.Reg) & 0x80000000) >> 31
}

// PIO.FELLSR: Falling Edge/Low Level Select Register
func (o *PIO_Type) SetFELLSR_P0(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetFELLSR_P0() uint32 {
	return volatile.LoadUint32(&o.FELLSR.Reg) & 0x1
}
func (o *PIO_Type) SetFELLSR_P1(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetFELLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetFELLSR_P2(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetFELLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetFELLSR_P3(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetFELLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetFELLSR_P4(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetFELLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetFELLSR_P5(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetFELLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetFELLSR_P6(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetFELLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetFELLSR_P7(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetFELLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetFELLSR_P8(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetFELLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetFELLSR_P9(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetFELLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetFELLSR_P10(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetFELLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetFELLSR_P11(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetFELLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetFELLSR_P12(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetFELLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetFELLSR_P13(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetFELLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetFELLSR_P14(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetFELLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetFELLSR_P15(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetFELLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetFELLSR_P16(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetFELLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetFELLSR_P17(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetFELLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetFELLSR_P18(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetFELLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetFELLSR_P19(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetFELLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetFELLSR_P20(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetFELLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetFELLSR_P21(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetFELLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetFELLSR_P22(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetFELLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetFELLSR_P23(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetFELLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetFELLSR_P24(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetFELLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetFELLSR_P25(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetFELLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetFELLSR_P26(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetFELLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetFELLSR_P27(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetFELLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetFELLSR_P28(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetFELLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetFELLSR_P29(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetFELLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetFELLSR_P30(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetFELLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetFELLSR_P31(value uint32) {
	volatile.StoreUint32(&o.FELLSR.Reg, volatile.LoadUint32(&o.FELLSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetFELLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.FELLSR.Reg) & 0x80000000) >> 31
}

// PIO.REHLSR: Rising Edge/ High Level Select Register
func (o *PIO_Type) SetREHLSR_P0(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetREHLSR_P0() uint32 {
	return volatile.LoadUint32(&o.REHLSR.Reg) & 0x1
}
func (o *PIO_Type) SetREHLSR_P1(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetREHLSR_P1() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetREHLSR_P2(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetREHLSR_P2() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetREHLSR_P3(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetREHLSR_P3() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetREHLSR_P4(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetREHLSR_P4() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetREHLSR_P5(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetREHLSR_P5() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetREHLSR_P6(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetREHLSR_P6() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetREHLSR_P7(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetREHLSR_P7() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetREHLSR_P8(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetREHLSR_P8() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetREHLSR_P9(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetREHLSR_P9() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetREHLSR_P10(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetREHLSR_P10() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetREHLSR_P11(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetREHLSR_P11() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetREHLSR_P12(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetREHLSR_P12() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetREHLSR_P13(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetREHLSR_P13() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetREHLSR_P14(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetREHLSR_P14() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetREHLSR_P15(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetREHLSR_P15() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetREHLSR_P16(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetREHLSR_P16() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetREHLSR_P17(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetREHLSR_P17() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetREHLSR_P18(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetREHLSR_P18() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetREHLSR_P19(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetREHLSR_P19() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetREHLSR_P20(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetREHLSR_P20() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetREHLSR_P21(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetREHLSR_P21() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetREHLSR_P22(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetREHLSR_P22() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetREHLSR_P23(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetREHLSR_P23() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetREHLSR_P24(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetREHLSR_P24() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetREHLSR_P25(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetREHLSR_P25() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetREHLSR_P26(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetREHLSR_P26() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetREHLSR_P27(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetREHLSR_P27() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetREHLSR_P28(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetREHLSR_P28() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetREHLSR_P29(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetREHLSR_P29() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetREHLSR_P30(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetREHLSR_P30() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetREHLSR_P31(value uint32) {
	volatile.StoreUint32(&o.REHLSR.Reg, volatile.LoadUint32(&o.REHLSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetREHLSR_P31() uint32 {
	return (volatile.LoadUint32(&o.REHLSR.Reg) & 0x80000000) >> 31
}

// PIO.FRLHSR: Fall/Rise - Low/High Status Register
func (o *PIO_Type) SetFRLHSR_P0(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetFRLHSR_P0() uint32 {
	return volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1
}
func (o *PIO_Type) SetFRLHSR_P1(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetFRLHSR_P1() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetFRLHSR_P2(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetFRLHSR_P2() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetFRLHSR_P3(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetFRLHSR_P3() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetFRLHSR_P4(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetFRLHSR_P4() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetFRLHSR_P5(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetFRLHSR_P5() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetFRLHSR_P6(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetFRLHSR_P6() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetFRLHSR_P7(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetFRLHSR_P7() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetFRLHSR_P8(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetFRLHSR_P8() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetFRLHSR_P9(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetFRLHSR_P9() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetFRLHSR_P10(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetFRLHSR_P10() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetFRLHSR_P11(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetFRLHSR_P11() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetFRLHSR_P12(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetFRLHSR_P12() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetFRLHSR_P13(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetFRLHSR_P13() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetFRLHSR_P14(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetFRLHSR_P14() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetFRLHSR_P15(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetFRLHSR_P15() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetFRLHSR_P16(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetFRLHSR_P16() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetFRLHSR_P17(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetFRLHSR_P17() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetFRLHSR_P18(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetFRLHSR_P18() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetFRLHSR_P19(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetFRLHSR_P19() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetFRLHSR_P20(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetFRLHSR_P20() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetFRLHSR_P21(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetFRLHSR_P21() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetFRLHSR_P22(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetFRLHSR_P22() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetFRLHSR_P23(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetFRLHSR_P23() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetFRLHSR_P24(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetFRLHSR_P24() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetFRLHSR_P25(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetFRLHSR_P25() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetFRLHSR_P26(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetFRLHSR_P26() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetFRLHSR_P27(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetFRLHSR_P27() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetFRLHSR_P28(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetFRLHSR_P28() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetFRLHSR_P29(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetFRLHSR_P29() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetFRLHSR_P30(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetFRLHSR_P30() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetFRLHSR_P31(value uint32) {
	volatile.StoreUint32(&o.FRLHSR.Reg, volatile.LoadUint32(&o.FRLHSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetFRLHSR_P31() uint32 {
	return (volatile.LoadUint32(&o.FRLHSR.Reg) & 0x80000000) >> 31
}

// PIO.LOCKSR: Lock Status
func (o *PIO_Type) SetLOCKSR_P0(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetLOCKSR_P0() uint32 {
	return volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1
}
func (o *PIO_Type) SetLOCKSR_P1(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetLOCKSR_P1() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetLOCKSR_P2(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetLOCKSR_P2() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetLOCKSR_P3(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetLOCKSR_P3() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetLOCKSR_P4(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetLOCKSR_P4() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetLOCKSR_P5(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetLOCKSR_P5() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetLOCKSR_P6(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetLOCKSR_P6() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetLOCKSR_P7(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetLOCKSR_P7() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetLOCKSR_P8(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetLOCKSR_P8() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetLOCKSR_P9(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetLOCKSR_P9() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetLOCKSR_P10(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetLOCKSR_P10() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetLOCKSR_P11(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetLOCKSR_P11() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetLOCKSR_P12(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetLOCKSR_P12() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetLOCKSR_P13(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetLOCKSR_P13() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetLOCKSR_P14(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetLOCKSR_P14() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetLOCKSR_P15(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetLOCKSR_P15() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetLOCKSR_P16(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetLOCKSR_P16() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetLOCKSR_P17(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetLOCKSR_P17() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetLOCKSR_P18(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetLOCKSR_P18() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetLOCKSR_P19(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetLOCKSR_P19() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetLOCKSR_P20(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetLOCKSR_P20() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetLOCKSR_P21(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetLOCKSR_P21() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetLOCKSR_P22(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetLOCKSR_P22() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetLOCKSR_P23(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetLOCKSR_P23() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetLOCKSR_P24(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetLOCKSR_P24() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetLOCKSR_P25(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetLOCKSR_P25() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetLOCKSR_P26(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetLOCKSR_P26() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetLOCKSR_P27(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetLOCKSR_P27() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetLOCKSR_P28(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetLOCKSR_P28() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetLOCKSR_P29(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetLOCKSR_P29() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetLOCKSR_P30(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetLOCKSR_P30() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetLOCKSR_P31(value uint32) {
	volatile.StoreUint32(&o.LOCKSR.Reg, volatile.LoadUint32(&o.LOCKSR.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetLOCKSR_P31() uint32 {
	return (volatile.LoadUint32(&o.LOCKSR.Reg) & 0x80000000) >> 31
}

// PIO.WPMR: Write Protect Mode Register
func (o *PIO_Type) SetWPMR_WPEN(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetWPMR_WPEN() uint32 {
	return volatile.LoadUint32(&o.WPMR.Reg) & 0x1
}
func (o *PIO_Type) SetWPMR_WPKEY(value uint32) {
	volatile.StoreUint32(&o.WPMR.Reg, volatile.LoadUint32(&o.WPMR.Reg)&^(0xffffff00)|value<<8)
}
func (o *PIO_Type) GetWPMR_WPKEY() uint32 {
	return (volatile.LoadUint32(&o.WPMR.Reg) & 0xffffff00) >> 8
}

// PIO.WPSR: Write Protect Status Register
func (o *PIO_Type) SetWPSR_WPVS(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetWPSR_WPVS() uint32 {
	return volatile.LoadUint32(&o.WPSR.Reg) & 0x1
}
func (o *PIO_Type) SetWPSR_WPVSRC(value uint32) {
	volatile.StoreUint32(&o.WPSR.Reg, volatile.LoadUint32(&o.WPSR.Reg)&^(0xffff00)|value<<8)
}
func (o *PIO_Type) GetWPSR_WPVSRC() uint32 {
	return (volatile.LoadUint32(&o.WPSR.Reg) & 0xffff00) >> 8
}

// PIO.SCHMITT: Schmitt Trigger Register
func (o *PIO_Type) SetSCHMITT_SCHMITT0(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1)|value)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT0() uint32 {
	return volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1
}
func (o *PIO_Type) SetSCHMITT_SCHMITT1(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2)|value<<1)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT1() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2) >> 1
}
func (o *PIO_Type) SetSCHMITT_SCHMITT2(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4)|value<<2)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT2() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4) >> 2
}
func (o *PIO_Type) SetSCHMITT_SCHMITT3(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8)|value<<3)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT3() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8) >> 3
}
func (o *PIO_Type) SetSCHMITT_SCHMITT4(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10)|value<<4)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT4() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10) >> 4
}
func (o *PIO_Type) SetSCHMITT_SCHMITT5(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20)|value<<5)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT5() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20) >> 5
}
func (o *PIO_Type) SetSCHMITT_SCHMITT6(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40)|value<<6)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT6() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40) >> 6
}
func (o *PIO_Type) SetSCHMITT_SCHMITT7(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80)|value<<7)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT7() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80) >> 7
}
func (o *PIO_Type) SetSCHMITT_SCHMITT8(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x100)|value<<8)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT8() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x100) >> 8
}
func (o *PIO_Type) SetSCHMITT_SCHMITT9(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x200)|value<<9)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT9() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x200) >> 9
}
func (o *PIO_Type) SetSCHMITT_SCHMITT10(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x400)|value<<10)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT10() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x400) >> 10
}
func (o *PIO_Type) SetSCHMITT_SCHMITT11(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x800)|value<<11)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT11() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x800) >> 11
}
func (o *PIO_Type) SetSCHMITT_SCHMITT12(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1000)|value<<12)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT12() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1000) >> 12
}
func (o *PIO_Type) SetSCHMITT_SCHMITT13(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2000)|value<<13)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT13() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2000) >> 13
}
func (o *PIO_Type) SetSCHMITT_SCHMITT14(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4000)|value<<14)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT14() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4000) >> 14
}
func (o *PIO_Type) SetSCHMITT_SCHMITT15(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8000)|value<<15)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT15() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8000) >> 15
}
func (o *PIO_Type) SetSCHMITT_SCHMITT16(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10000)|value<<16)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT16() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10000) >> 16
}
func (o *PIO_Type) SetSCHMITT_SCHMITT17(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20000)|value<<17)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT17() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20000) >> 17
}
func (o *PIO_Type) SetSCHMITT_SCHMITT18(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40000)|value<<18)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT18() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40000) >> 18
}
func (o *PIO_Type) SetSCHMITT_SCHMITT19(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80000)|value<<19)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT19() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80000) >> 19
}
func (o *PIO_Type) SetSCHMITT_SCHMITT20(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x100000)|value<<20)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT20() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x100000) >> 20
}
func (o *PIO_Type) SetSCHMITT_SCHMITT21(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x200000)|value<<21)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT21() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x200000) >> 21
}
func (o *PIO_Type) SetSCHMITT_SCHMITT22(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x400000)|value<<22)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT22() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x400000) >> 22
}
func (o *PIO_Type) SetSCHMITT_SCHMITT23(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x800000)|value<<23)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT23() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x800000) >> 23
}
func (o *PIO_Type) SetSCHMITT_SCHMITT24(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x1000000)|value<<24)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT24() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x1000000) >> 24
}
func (o *PIO_Type) SetSCHMITT_SCHMITT25(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x2000000)|value<<25)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT25() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x2000000) >> 25
}
func (o *PIO_Type) SetSCHMITT_SCHMITT26(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x4000000)|value<<26)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT26() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x4000000) >> 26
}
func (o *PIO_Type) SetSCHMITT_SCHMITT27(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x8000000)|value<<27)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT27() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x8000000) >> 27
}
func (o *PIO_Type) SetSCHMITT_SCHMITT28(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x10000000)|value<<28)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT28() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x10000000) >> 28
}
func (o *PIO_Type) SetSCHMITT_SCHMITT29(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x20000000)|value<<29)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT29() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x20000000) >> 29
}
func (o *PIO_Type) SetSCHMITT_SCHMITT30(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x40000000)|value<<30)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT30() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x40000000) >> 30
}
func (o *PIO_Type) SetSCHMITT_SCHMITT31(value uint32) {
	volatile.StoreUint32(&o.SCHMITT.Reg, volatile.LoadUint32(&o.SCHMITT.Reg)&^(0x80000000)|value<<31)
}
func (o *PIO_Type) GetSCHMITT_SCHMITT31() uint32 {
	return (volatile.LoadUint32(&o.SCHMITT.Reg) & 0x80000000) >> 31
}

// Reset Controller
type SYSC_Type struct {
	CR volatile.Register32 // 0x0
	SR volatile.Register32 // 0x4
	MR volatile.Register32 // 0x8
}

// SYSC.CR: Control Register
func (o *SYSC_Type) SetCR_PROCRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetCR_PROCRST() uint32 {
	return volatile.LoadUint32(&o.CR.Reg) & 0x1
}
func (o *SYSC_Type) SetCR_PERRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x4)|value<<2)
}
func (o *SYSC_Type) GetCR_PERRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x4) >> 2
}
func (o *SYSC_Type) SetCR_EXTRST(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0x8)|value<<3)
}
func (o *SYSC_Type) GetCR_EXTRST() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0x8) >> 3
}
func (o *SYSC_Type) SetCR_KEY(value uint32) {
	volatile.StoreUint32(&o.CR.Reg, volatile.LoadUint32(&o.CR.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSC_Type) GetCR_KEY() uint32 {
	return (volatile.LoadUint32(&o.CR.Reg) & 0xff000000) >> 24
}

// SYSC.SR: Status Register
func (o *SYSC_Type) SetSR_URSTS(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetSR_URSTS() uint32 {
	return volatile.LoadUint32(&o.SR.Reg) & 0x1
}
func (o *SYSC_Type) SetSR_RSTTYP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x700)|value<<8)
}
func (o *SYSC_Type) GetSR_RSTTYP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x700) >> 8
}
func (o *SYSC_Type) SetSR_NRSTL(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x10000)|value<<16)
}
func (o *SYSC_Type) GetSR_NRSTL() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x10000) >> 16
}
func (o *SYSC_Type) SetSR_SRCMP(value uint32) {
	volatile.StoreUint32(&o.SR.Reg, volatile.LoadUint32(&o.SR.Reg)&^(0x20000)|value<<17)
}
func (o *SYSC_Type) GetSR_SRCMP() uint32 {
	return (volatile.LoadUint32(&o.SR.Reg) & 0x20000) >> 17
}

// SYSC.MR: Mode Register
func (o *SYSC_Type) SetMR_URSTEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x1)|value)
}
func (o *SYSC_Type) GetMR_URSTEN() uint32 {
	return volatile.LoadUint32(&o.MR.Reg) & 0x1
}
func (o *SYSC_Type) SetMR_URSTIEN(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0x10)|value<<4)
}
func (o *SYSC_Type) GetMR_URSTIEN() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0x10) >> 4
}
func (o *SYSC_Type) SetMR_ERSTL(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xf00)|value<<8)
}
func (o *SYSC_Type) GetMR_ERSTL() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xf00) >> 8
}
func (o *SYSC_Type) SetMR_KEY(value uint32) {
	volatile.StoreUint32(&o.MR.Reg, volatile.LoadUint32(&o.MR.Reg)&^(0xff000000)|value<<24)
}
func (o *SYSC_Type) GetMR_KEY() uint32 {
	return (volatile.LoadUint32(&o.MR.Reg) & 0xff000000) >> 24
}

// Constants for SPI: Serial Peripheral Interface
const (
	// CR: Control Register
	// Position of SPIEN field.
	SPI_CR_SPIEN_Pos = 0x0
	// Bit mask of SPIEN field.
	SPI_CR_SPIEN_Msk = 0x1
	// Bit SPIEN.
	SPI_CR_SPIEN = 0x1
	// Position of SPIDIS field.
	SPI_CR_SPIDIS_Pos = 0x1
	// Bit mask of SPIDIS field.
	SPI_CR_SPIDIS_Msk = 0x2
	// Bit SPIDIS.
	SPI_CR_SPIDIS = 0x2
	// Position of SWRST field.
	SPI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	SPI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	SPI_CR_SWRST = 0x80
	// Position of LASTXFER field.
	SPI_CR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_CR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_CR_LASTXFER = 0x1000000

	// MR: Mode Register
	// Position of MSTR field.
	SPI_MR_MSTR_Pos = 0x0
	// Bit mask of MSTR field.
	SPI_MR_MSTR_Msk = 0x1
	// Bit MSTR.
	SPI_MR_MSTR = 0x1
	// Position of PS field.
	SPI_MR_PS_Pos = 0x1
	// Bit mask of PS field.
	SPI_MR_PS_Msk = 0x2
	// Bit PS.
	SPI_MR_PS = 0x2
	// Position of PCSDEC field.
	SPI_MR_PCSDEC_Pos = 0x2
	// Bit mask of PCSDEC field.
	SPI_MR_PCSDEC_Msk = 0x4
	// Bit PCSDEC.
	SPI_MR_PCSDEC = 0x4
	// Position of MODFDIS field.
	SPI_MR_MODFDIS_Pos = 0x4
	// Bit mask of MODFDIS field.
	SPI_MR_MODFDIS_Msk = 0x10
	// Bit MODFDIS.
	SPI_MR_MODFDIS = 0x10
	// Position of WDRBT field.
	SPI_MR_WDRBT_Pos = 0x5
	// Bit mask of WDRBT field.
	SPI_MR_WDRBT_Msk = 0x20
	// Bit WDRBT.
	SPI_MR_WDRBT = 0x20
	// Position of LLB field.
	SPI_MR_LLB_Pos = 0x7
	// Bit mask of LLB field.
	SPI_MR_LLB_Msk = 0x80
	// Bit LLB.
	SPI_MR_LLB = 0x80
	// Position of PCS field.
	SPI_MR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_MR_PCS_Msk = 0xf0000
	// Position of DLYBCS field.
	SPI_MR_DLYBCS_Pos = 0x18
	// Bit mask of DLYBCS field.
	SPI_MR_DLYBCS_Msk = 0xff000000

	// RDR: Receive Data Register
	// Position of RD field.
	SPI_RDR_RD_Pos = 0x0
	// Bit mask of RD field.
	SPI_RDR_RD_Msk = 0xffff
	// Position of PCS field.
	SPI_RDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_RDR_PCS_Msk = 0xf0000

	// TDR: Transmit Data Register
	// Position of TD field.
	SPI_TDR_TD_Pos = 0x0
	// Bit mask of TD field.
	SPI_TDR_TD_Msk = 0xffff
	// Position of PCS field.
	SPI_TDR_PCS_Pos = 0x10
	// Bit mask of PCS field.
	SPI_TDR_PCS_Msk = 0xf0000
	// Position of LASTXFER field.
	SPI_TDR_LASTXFER_Pos = 0x18
	// Bit mask of LASTXFER field.
	SPI_TDR_LASTXFER_Msk = 0x1000000
	// Bit LASTXFER.
	SPI_TDR_LASTXFER = 0x1000000

	// SR: Status Register
	// Position of RDRF field.
	SPI_SR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_SR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_SR_RDRF = 0x1
	// Position of TDRE field.
	SPI_SR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_SR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_SR_TDRE = 0x2
	// Position of MODF field.
	SPI_SR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_SR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_SR_MODF = 0x4
	// Position of OVRES field.
	SPI_SR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_SR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_SR_OVRES = 0x8
	// Position of NSSR field.
	SPI_SR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_SR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_SR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_SR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_SR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_SR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_SR_UNDES = 0x400
	// Position of SPIENS field.
	SPI_SR_SPIENS_Pos = 0x10
	// Bit mask of SPIENS field.
	SPI_SR_SPIENS_Msk = 0x10000
	// Bit SPIENS.
	SPI_SR_SPIENS = 0x10000

	// IER: Interrupt Enable Register
	// Position of RDRF field.
	SPI_IER_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IER_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IER_RDRF = 0x1
	// Position of TDRE field.
	SPI_IER_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IER_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IER_TDRE = 0x2
	// Position of MODF field.
	SPI_IER_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IER_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IER_MODF = 0x4
	// Position of OVRES field.
	SPI_IER_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IER_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IER_OVRES = 0x8
	// Position of NSSR field.
	SPI_IER_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IER_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IER_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IER_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IER_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IER_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IER_UNDES = 0x400

	// IDR: Interrupt Disable Register
	// Position of RDRF field.
	SPI_IDR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IDR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IDR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IDR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IDR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IDR_TDRE = 0x2
	// Position of MODF field.
	SPI_IDR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IDR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IDR_MODF = 0x4
	// Position of OVRES field.
	SPI_IDR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IDR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IDR_OVRES = 0x8
	// Position of NSSR field.
	SPI_IDR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IDR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IDR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IDR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IDR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IDR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IDR_UNDES = 0x400

	// IMR: Interrupt Mask Register
	// Position of RDRF field.
	SPI_IMR_RDRF_Pos = 0x0
	// Bit mask of RDRF field.
	SPI_IMR_RDRF_Msk = 0x1
	// Bit RDRF.
	SPI_IMR_RDRF = 0x1
	// Position of TDRE field.
	SPI_IMR_TDRE_Pos = 0x1
	// Bit mask of TDRE field.
	SPI_IMR_TDRE_Msk = 0x2
	// Bit TDRE.
	SPI_IMR_TDRE = 0x2
	// Position of MODF field.
	SPI_IMR_MODF_Pos = 0x2
	// Bit mask of MODF field.
	SPI_IMR_MODF_Msk = 0x4
	// Bit MODF.
	SPI_IMR_MODF = 0x4
	// Position of OVRES field.
	SPI_IMR_OVRES_Pos = 0x3
	// Bit mask of OVRES field.
	SPI_IMR_OVRES_Msk = 0x8
	// Bit OVRES.
	SPI_IMR_OVRES = 0x8
	// Position of NSSR field.
	SPI_IMR_NSSR_Pos = 0x8
	// Bit mask of NSSR field.
	SPI_IMR_NSSR_Msk = 0x100
	// Bit NSSR.
	SPI_IMR_NSSR = 0x100
	// Position of TXEMPTY field.
	SPI_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	SPI_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	SPI_IMR_TXEMPTY = 0x200
	// Position of UNDES field.
	SPI_IMR_UNDES_Pos = 0xa
	// Bit mask of UNDES field.
	SPI_IMR_UNDES_Msk = 0x400
	// Bit UNDES.
	SPI_IMR_UNDES = 0x400

	// CSR: Chip Select Register
	// Position of CPOL field.
	SPI_CSR_CPOL_Pos = 0x0
	// Bit mask of CPOL field.
	SPI_CSR_CPOL_Msk = 0x1
	// Bit CPOL.
	SPI_CSR_CPOL = 0x1
	// Position of NCPHA field.
	SPI_CSR_NCPHA_Pos = 0x1
	// Bit mask of NCPHA field.
	SPI_CSR_NCPHA_Msk = 0x2
	// Bit NCPHA.
	SPI_CSR_NCPHA = 0x2
	// Position of CSNAAT field.
	SPI_CSR_CSNAAT_Pos = 0x2
	// Bit mask of CSNAAT field.
	SPI_CSR_CSNAAT_Msk = 0x4
	// Bit CSNAAT.
	SPI_CSR_CSNAAT = 0x4
	// Position of CSAAT field.
	SPI_CSR_CSAAT_Pos = 0x3
	// Bit mask of CSAAT field.
	SPI_CSR_CSAAT_Msk = 0x8
	// Bit CSAAT.
	SPI_CSR_CSAAT = 0x8
	// Position of BITS field.
	SPI_CSR_BITS_Pos = 0x4
	// Bit mask of BITS field.
	SPI_CSR_BITS_Msk = 0xf0
	// 8 bits for transfer
	SPI_CSR_BITS_8_BIT = 0x0
	// 9 bits for transfer
	SPI_CSR_BITS_9_BIT = 0x1
	// 10 bits for transfer
	SPI_CSR_BITS_10_BIT = 0x2
	// 11 bits for transfer
	SPI_CSR_BITS_11_BIT = 0x3
	// 12 bits for transfer
	SPI_CSR_BITS_12_BIT = 0x4
	// 13 bits for transfer
	SPI_CSR_BITS_13_BIT = 0x5
	// 14 bits for transfer
	SPI_CSR_BITS_14_BIT = 0x6
	// 15 bits for transfer
	SPI_CSR_BITS_15_BIT = 0x7
	// 16 bits for transfer
	SPI_CSR_BITS_16_BIT = 0x8
	// Position of SCBR field.
	SPI_CSR_SCBR_Pos = 0x8
	// Bit mask of SCBR field.
	SPI_CSR_SCBR_Msk = 0xff00
	// Position of DLYBS field.
	SPI_CSR_DLYBS_Pos = 0x10
	// Bit mask of DLYBS field.
	SPI_CSR_DLYBS_Msk = 0xff0000
	// Position of DLYBCT field.
	SPI_CSR_DLYBCT_Pos = 0x18
	// Bit mask of DLYBCT field.
	SPI_CSR_DLYBCT_Msk = 0xff000000

	// WPMR: Write Protection Control Register
	// Position of WPEN field.
	SPI_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	SPI_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	SPI_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	SPI_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	SPI_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protection Status Register
	// Position of WPVS field.
	SPI_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	SPI_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	SPI_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	SPI_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	SPI_WPSR_WPVSRC_Msk = 0xff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	SPI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	SPI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	SPI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	SPI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	SPI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	SPI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	SPI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	SPI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	SPI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	SPI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	SPI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	SPI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	SPI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	SPI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	SPI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	SPI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	SPI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SPI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SPI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	SPI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	SPI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	SPI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	SPI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SPI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SPI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	SPI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	SPI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	SPI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	SPI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	SPI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	SPI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	SPI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	SPI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	SPI_PTSR_TXTEN = 0x100
)

// Constants for TC0: Timer Counter 0
const (
	// CCR0: Channel Control Register (channel = 0)
	// Position of CLKEN field.
	TC_CCR0_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR0_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR0_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR0_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR0_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR0_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR0_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR0_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR0_SWTRG = 0x4

	// CMR0: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR0_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR0_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR0_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR0_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR0_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR0_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR0_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR0_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR0_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR0_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR0_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR0_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR0_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR0_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR0_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR0_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR0_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR0_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR0_LDRA_Msk = 0x30000
	// None
	TC_CMR0_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR0_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR0_LDRB_Msk = 0xc0000
	// None
	TC_CMR0_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR0_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR0_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR0_LDRB_EDGE = 0x3

	// CMR0_WAVEFORM_MODE: Channel Mode Register (channel = 0)
	// Position of TCCLKS field.
	TC_CMR0_WAVEFORM_MODE_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR0_WAVEFORM_MODE_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR0_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR0_WAVEFORM_MODE_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR0_WAVEFORM_MODE_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR0_WAVEFORM_MODE_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR0_WAVEFORM_MODE_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR0_WAVEFORM_MODE_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR0_WAVEFORM_MODE_CLKI = 0x8
	// Position of BURST field.
	TC_CMR0_WAVEFORM_MODE_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR0_WAVEFORM_MODE_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR0_WAVEFORM_MODE_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR0_WAVEFORM_MODE_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR0_WAVEFORM_MODE_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR0_WAVEFORM_MODE_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR0_WAVEFORM_MODE_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR0_WAVEFORM_MODE_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR0_WAVEFORM_MODE_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR0_WAVEFORM_MODE_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR0_WAVEFORM_MODE_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR0_WAVEFORM_MODE_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_Msk = 0x300
	// None
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR0_WAVEFORM_MODE_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR0_WAVEFORM_MODE_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR0_WAVEFORM_MODE_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR0_WAVEFORM_MODE_EEVT_TIOB = 0x0
	// XC0
	TC_CMR0_WAVEFORM_MODE_EEVT_XC0 = 0x1
	// XC1
	TC_CMR0_WAVEFORM_MODE_EEVT_XC1 = 0x2
	// XC2
	TC_CMR0_WAVEFORM_MODE_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR0_WAVEFORM_MODE_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR0_WAVEFORM_MODE_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR0_WAVEFORM_MODE_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR0_WAVEFORM_MODE_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR0_WAVEFORM_MODE_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR0_WAVEFORM_MODE_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR0_WAVEFORM_MODE_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR0_WAVEFORM_MODE_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR0_WAVEFORM_MODE_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR0_WAVEFORM_MODE_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR0_WAVEFORM_MODE_ACPA_Msk = 0x30000
	// None
	TC_CMR0_WAVEFORM_MODE_ACPA_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_ACPA_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR0_WAVEFORM_MODE_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR0_WAVEFORM_MODE_ACPC_Msk = 0xc0000
	// None
	TC_CMR0_WAVEFORM_MODE_ACPC_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_ACPC_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR0_WAVEFORM_MODE_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR0_WAVEFORM_MODE_AEEVT_Msk = 0x300000
	// None
	TC_CMR0_WAVEFORM_MODE_AEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_AEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR0_WAVEFORM_MODE_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR0_WAVEFORM_MODE_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR0_WAVEFORM_MODE_ASWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_ASWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR0_WAVEFORM_MODE_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR0_WAVEFORM_MODE_BCPB_Msk = 0x3000000
	// None
	TC_CMR0_WAVEFORM_MODE_BCPB_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_BCPB_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR0_WAVEFORM_MODE_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR0_WAVEFORM_MODE_BCPC_Msk = 0xc000000
	// None
	TC_CMR0_WAVEFORM_MODE_BCPC_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_BCPC_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR0_WAVEFORM_MODE_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR0_WAVEFORM_MODE_BEEVT_Msk = 0x30000000
	// None
	TC_CMR0_WAVEFORM_MODE_BEEVT_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_BEEVT_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR0_WAVEFORM_MODE_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR0_WAVEFORM_MODE_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR0_WAVEFORM_MODE_BSWTRG_NONE = 0x0
	// Set
	TC_CMR0_WAVEFORM_MODE_BSWTRG_SET = 0x1
	// Clear
	TC_CMR0_WAVEFORM_MODE_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR0_WAVEFORM_MODE_BSWTRG_TOGGLE = 0x3

	// SMMR0: Stepper Motor Mode Register (channel = 0)
	// Position of GCEN field.
	TC_SMMR0_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR0_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR0_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR0_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR0_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR0_DOWN = 0x2

	// CV0: Counter Value (channel = 0)
	// Position of CV field.
	TC_CV0_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV0_CV_Msk = 0xffffffff

	// RA0: Register A (channel = 0)
	// Position of RA field.
	TC_RA0_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA0_RA_Msk = 0xffffffff

	// RB0: Register B (channel = 0)
	// Position of RB field.
	TC_RB0_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB0_RB_Msk = 0xffffffff

	// RC0: Register C (channel = 0)
	// Position of RC field.
	TC_RC0_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC0_RC_Msk = 0xffffffff

	// SR0: Status Register (channel = 0)
	// Position of COVFS field.
	TC_SR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR0_CPAS = 0x4
	// Position of CPBS field.
	TC_SR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR0_CPBS = 0x8
	// Position of CPCS field.
	TC_SR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR0_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR0_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR0_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR0_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR0_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR0_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR0_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR0_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR0_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR0_MTIOB = 0x40000

	// IER0: Interrupt Enable Register (channel = 0)
	// Position of COVFS field.
	TC_IER0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER0_CPAS = 0x4
	// Position of CPBS field.
	TC_IER0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER0_CPBS = 0x8
	// Position of CPCS field.
	TC_IER0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER0_ETRGS = 0x80

	// IDR0: Interrupt Disable Register (channel = 0)
	// Position of COVFS field.
	TC_IDR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR0_ETRGS = 0x80

	// IMR0: Interrupt Mask Register (channel = 0)
	// Position of COVFS field.
	TC_IMR0_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR0_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR0_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR0_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR0_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR0_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR0_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR0_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR0_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR0_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR0_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR0_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR0_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR0_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR0_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR0_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR0_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR0_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR0_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR0_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR0_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR0_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR0_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR0_ETRGS = 0x80

	// CCR1: Channel Control Register (channel = 1)
	// Position of CLKEN field.
	TC_CCR1_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR1_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR1_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR1_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR1_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR1_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR1_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR1_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR1_SWTRG = 0x4

	// CMR1: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR1_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR1_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR1_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR1_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR1_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR1_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR1_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR1_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR1_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR1_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR1_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR1_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR1_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR1_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR1_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR1_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR1_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR1_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR1_LDRA_Msk = 0x30000
	// None
	TC_CMR1_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR1_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR1_LDRB_Msk = 0xc0000
	// None
	TC_CMR1_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR1_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR1_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR1_LDRB_EDGE = 0x3

	// CMR1_WAVEFORM_MODE: Channel Mode Register (channel = 1)
	// Position of TCCLKS field.
	TC_CMR1_WAVEFORM_MODE_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR1_WAVEFORM_MODE_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR1_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR1_WAVEFORM_MODE_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR1_WAVEFORM_MODE_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR1_WAVEFORM_MODE_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR1_WAVEFORM_MODE_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR1_WAVEFORM_MODE_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR1_WAVEFORM_MODE_CLKI = 0x8
	// Position of BURST field.
	TC_CMR1_WAVEFORM_MODE_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR1_WAVEFORM_MODE_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR1_WAVEFORM_MODE_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR1_WAVEFORM_MODE_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR1_WAVEFORM_MODE_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR1_WAVEFORM_MODE_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR1_WAVEFORM_MODE_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR1_WAVEFORM_MODE_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR1_WAVEFORM_MODE_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR1_WAVEFORM_MODE_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR1_WAVEFORM_MODE_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR1_WAVEFORM_MODE_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_Msk = 0x300
	// None
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR1_WAVEFORM_MODE_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR1_WAVEFORM_MODE_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR1_WAVEFORM_MODE_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR1_WAVEFORM_MODE_EEVT_TIOB = 0x0
	// XC0
	TC_CMR1_WAVEFORM_MODE_EEVT_XC0 = 0x1
	// XC1
	TC_CMR1_WAVEFORM_MODE_EEVT_XC1 = 0x2
	// XC2
	TC_CMR1_WAVEFORM_MODE_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR1_WAVEFORM_MODE_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR1_WAVEFORM_MODE_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR1_WAVEFORM_MODE_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR1_WAVEFORM_MODE_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR1_WAVEFORM_MODE_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR1_WAVEFORM_MODE_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR1_WAVEFORM_MODE_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR1_WAVEFORM_MODE_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR1_WAVEFORM_MODE_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR1_WAVEFORM_MODE_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR1_WAVEFORM_MODE_ACPA_Msk = 0x30000
	// None
	TC_CMR1_WAVEFORM_MODE_ACPA_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_ACPA_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR1_WAVEFORM_MODE_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR1_WAVEFORM_MODE_ACPC_Msk = 0xc0000
	// None
	TC_CMR1_WAVEFORM_MODE_ACPC_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_ACPC_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR1_WAVEFORM_MODE_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR1_WAVEFORM_MODE_AEEVT_Msk = 0x300000
	// None
	TC_CMR1_WAVEFORM_MODE_AEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_AEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR1_WAVEFORM_MODE_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR1_WAVEFORM_MODE_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR1_WAVEFORM_MODE_ASWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_ASWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR1_WAVEFORM_MODE_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR1_WAVEFORM_MODE_BCPB_Msk = 0x3000000
	// None
	TC_CMR1_WAVEFORM_MODE_BCPB_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_BCPB_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR1_WAVEFORM_MODE_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR1_WAVEFORM_MODE_BCPC_Msk = 0xc000000
	// None
	TC_CMR1_WAVEFORM_MODE_BCPC_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_BCPC_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR1_WAVEFORM_MODE_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR1_WAVEFORM_MODE_BEEVT_Msk = 0x30000000
	// None
	TC_CMR1_WAVEFORM_MODE_BEEVT_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_BEEVT_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR1_WAVEFORM_MODE_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR1_WAVEFORM_MODE_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR1_WAVEFORM_MODE_BSWTRG_NONE = 0x0
	// Set
	TC_CMR1_WAVEFORM_MODE_BSWTRG_SET = 0x1
	// Clear
	TC_CMR1_WAVEFORM_MODE_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR1_WAVEFORM_MODE_BSWTRG_TOGGLE = 0x3

	// SMMR1: Stepper Motor Mode Register (channel = 1)
	// Position of GCEN field.
	TC_SMMR1_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR1_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR1_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR1_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR1_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR1_DOWN = 0x2

	// CV1: Counter Value (channel = 1)
	// Position of CV field.
	TC_CV1_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV1_CV_Msk = 0xffffffff

	// RA1: Register A (channel = 1)
	// Position of RA field.
	TC_RA1_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA1_RA_Msk = 0xffffffff

	// RB1: Register B (channel = 1)
	// Position of RB field.
	TC_RB1_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB1_RB_Msk = 0xffffffff

	// RC1: Register C (channel = 1)
	// Position of RC field.
	TC_RC1_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC1_RC_Msk = 0xffffffff

	// SR1: Status Register (channel = 1)
	// Position of COVFS field.
	TC_SR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR1_CPAS = 0x4
	// Position of CPBS field.
	TC_SR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR1_CPBS = 0x8
	// Position of CPCS field.
	TC_SR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR1_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR1_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR1_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR1_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR1_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR1_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR1_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR1_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR1_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR1_MTIOB = 0x40000

	// IER1: Interrupt Enable Register (channel = 1)
	// Position of COVFS field.
	TC_IER1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER1_CPAS = 0x4
	// Position of CPBS field.
	TC_IER1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER1_CPBS = 0x8
	// Position of CPCS field.
	TC_IER1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER1_ETRGS = 0x80

	// IDR1: Interrupt Disable Register (channel = 1)
	// Position of COVFS field.
	TC_IDR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR1_ETRGS = 0x80

	// IMR1: Interrupt Mask Register (channel = 1)
	// Position of COVFS field.
	TC_IMR1_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR1_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR1_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR1_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR1_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR1_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR1_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR1_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR1_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR1_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR1_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR1_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR1_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR1_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR1_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR1_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR1_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR1_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR1_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR1_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR1_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR1_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR1_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR1_ETRGS = 0x80

	// CCR2: Channel Control Register (channel = 2)
	// Position of CLKEN field.
	TC_CCR2_CLKEN_Pos = 0x0
	// Bit mask of CLKEN field.
	TC_CCR2_CLKEN_Msk = 0x1
	// Bit CLKEN.
	TC_CCR2_CLKEN = 0x1
	// Position of CLKDIS field.
	TC_CCR2_CLKDIS_Pos = 0x1
	// Bit mask of CLKDIS field.
	TC_CCR2_CLKDIS_Msk = 0x2
	// Bit CLKDIS.
	TC_CCR2_CLKDIS = 0x2
	// Position of SWTRG field.
	TC_CCR2_SWTRG_Pos = 0x2
	// Bit mask of SWTRG field.
	TC_CCR2_SWTRG_Msk = 0x4
	// Bit SWTRG.
	TC_CCR2_SWTRG = 0x4

	// CMR2: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR2_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_BURST_XC2 = 0x3
	// Position of LDBSTOP field.
	TC_CMR2_LDBSTOP_Pos = 0x6
	// Bit mask of LDBSTOP field.
	TC_CMR2_LDBSTOP_Msk = 0x40
	// Bit LDBSTOP.
	TC_CMR2_LDBSTOP = 0x40
	// Position of LDBDIS field.
	TC_CMR2_LDBDIS_Pos = 0x7
	// Bit mask of LDBDIS field.
	TC_CMR2_LDBDIS_Msk = 0x80
	// Bit LDBDIS.
	TC_CMR2_LDBDIS = 0x80
	// Position of ETRGEDG field.
	TC_CMR2_ETRGEDG_Pos = 0x8
	// Bit mask of ETRGEDG field.
	TC_CMR2_ETRGEDG_Msk = 0x300
	// The clock is not gated by an external signal.
	TC_CMR2_ETRGEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_ETRGEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_ETRGEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_ETRGEDG_EDGE = 0x3
	// Position of ABETRG field.
	TC_CMR2_ABETRG_Pos = 0xa
	// Bit mask of ABETRG field.
	TC_CMR2_ABETRG_Msk = 0x400
	// Bit ABETRG.
	TC_CMR2_ABETRG = 0x400
	// Position of CPCTRG field.
	TC_CMR2_CPCTRG_Pos = 0xe
	// Bit mask of CPCTRG field.
	TC_CMR2_CPCTRG_Msk = 0x4000
	// Bit CPCTRG.
	TC_CMR2_CPCTRG = 0x4000
	// Position of WAVE field.
	TC_CMR2_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVE = 0x8000
	// Position of LDRA field.
	TC_CMR2_LDRA_Pos = 0x10
	// Bit mask of LDRA field.
	TC_CMR2_LDRA_Msk = 0x30000
	// None
	TC_CMR2_LDRA_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRA_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRA_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRA_EDGE = 0x3
	// Position of LDRB field.
	TC_CMR2_LDRB_Pos = 0x12
	// Bit mask of LDRB field.
	TC_CMR2_LDRB_Msk = 0xc0000
	// None
	TC_CMR2_LDRB_NONE = 0x0
	// Rising edge of TIOA
	TC_CMR2_LDRB_RISING = 0x1
	// Falling edge of TIOA
	TC_CMR2_LDRB_FALLING = 0x2
	// Each edge of TIOA
	TC_CMR2_LDRB_EDGE = 0x3

	// CMR2_WAVEFORM_MODE: Channel Mode Register (channel = 2)
	// Position of TCCLKS field.
	TC_CMR2_WAVEFORM_MODE_TCCLKS_Pos = 0x0
	// Bit mask of TCCLKS field.
	TC_CMR2_WAVEFORM_MODE_TCCLKS_Msk = 0x7
	// Clock selected: internal MCK/2 clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK1 = 0x0
	// Clock selected: internal MCK/8 clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK2 = 0x1
	// Clock selected: internal MCK/32 clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK3 = 0x2
	// Clock selected: internal MCK/128 clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK4 = 0x3
	// Clock selected: internal SLCK clock signal (from PMC)
	TC_CMR2_WAVEFORM_MODE_TCCLKS_TIMER_CLOCK5 = 0x4
	// Clock selected: XC0
	TC_CMR2_WAVEFORM_MODE_TCCLKS_XC0 = 0x5
	// Clock selected: XC1
	TC_CMR2_WAVEFORM_MODE_TCCLKS_XC1 = 0x6
	// Clock selected: XC2
	TC_CMR2_WAVEFORM_MODE_TCCLKS_XC2 = 0x7
	// Position of CLKI field.
	TC_CMR2_WAVEFORM_MODE_CLKI_Pos = 0x3
	// Bit mask of CLKI field.
	TC_CMR2_WAVEFORM_MODE_CLKI_Msk = 0x8
	// Bit CLKI.
	TC_CMR2_WAVEFORM_MODE_CLKI = 0x8
	// Position of BURST field.
	TC_CMR2_WAVEFORM_MODE_BURST_Pos = 0x4
	// Bit mask of BURST field.
	TC_CMR2_WAVEFORM_MODE_BURST_Msk = 0x30
	// The clock is not gated by an external signal.
	TC_CMR2_WAVEFORM_MODE_BURST_NONE = 0x0
	// XC0 is ANDed with the selected clock.
	TC_CMR2_WAVEFORM_MODE_BURST_XC0 = 0x1
	// XC1 is ANDed with the selected clock.
	TC_CMR2_WAVEFORM_MODE_BURST_XC1 = 0x2
	// XC2 is ANDed with the selected clock.
	TC_CMR2_WAVEFORM_MODE_BURST_XC2 = 0x3
	// Position of CPCSTOP field.
	TC_CMR2_WAVEFORM_MODE_CPCSTOP_Pos = 0x6
	// Bit mask of CPCSTOP field.
	TC_CMR2_WAVEFORM_MODE_CPCSTOP_Msk = 0x40
	// Bit CPCSTOP.
	TC_CMR2_WAVEFORM_MODE_CPCSTOP = 0x40
	// Position of CPCDIS field.
	TC_CMR2_WAVEFORM_MODE_CPCDIS_Pos = 0x7
	// Bit mask of CPCDIS field.
	TC_CMR2_WAVEFORM_MODE_CPCDIS_Msk = 0x80
	// Bit CPCDIS.
	TC_CMR2_WAVEFORM_MODE_CPCDIS = 0x80
	// Position of EEVTEDG field.
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_Pos = 0x8
	// Bit mask of EEVTEDG field.
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_Msk = 0x300
	// None
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_NONE = 0x0
	// Rising edge
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_RISING = 0x1
	// Falling edge
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_FALLING = 0x2
	// Each edge
	TC_CMR2_WAVEFORM_MODE_EEVTEDG_EDGE = 0x3
	// Position of EEVT field.
	TC_CMR2_WAVEFORM_MODE_EEVT_Pos = 0xa
	// Bit mask of EEVT field.
	TC_CMR2_WAVEFORM_MODE_EEVT_Msk = 0xc00
	// TIOB
	TC_CMR2_WAVEFORM_MODE_EEVT_TIOB = 0x0
	// XC0
	TC_CMR2_WAVEFORM_MODE_EEVT_XC0 = 0x1
	// XC1
	TC_CMR2_WAVEFORM_MODE_EEVT_XC1 = 0x2
	// XC2
	TC_CMR2_WAVEFORM_MODE_EEVT_XC2 = 0x3
	// Position of ENETRG field.
	TC_CMR2_WAVEFORM_MODE_ENETRG_Pos = 0xc
	// Bit mask of ENETRG field.
	TC_CMR2_WAVEFORM_MODE_ENETRG_Msk = 0x1000
	// Bit ENETRG.
	TC_CMR2_WAVEFORM_MODE_ENETRG = 0x1000
	// Position of WAVSEL field.
	TC_CMR2_WAVEFORM_MODE_WAVSEL_Pos = 0xd
	// Bit mask of WAVSEL field.
	TC_CMR2_WAVEFORM_MODE_WAVSEL_Msk = 0x6000
	// UP mode without automatic trigger on RC Compare
	TC_CMR2_WAVEFORM_MODE_WAVSEL_UP = 0x0
	// UPDOWN mode without automatic trigger on RC Compare
	TC_CMR2_WAVEFORM_MODE_WAVSEL_UPDOWN = 0x1
	// UP mode with automatic trigger on RC Compare
	TC_CMR2_WAVEFORM_MODE_WAVSEL_UP_RC = 0x2
	// UPDOWN mode with automatic trigger on RC Compare
	TC_CMR2_WAVEFORM_MODE_WAVSEL_UPDOWN_RC = 0x3
	// Position of WAVE field.
	TC_CMR2_WAVEFORM_MODE_WAVE_Pos = 0xf
	// Bit mask of WAVE field.
	TC_CMR2_WAVEFORM_MODE_WAVE_Msk = 0x8000
	// Bit WAVE.
	TC_CMR2_WAVEFORM_MODE_WAVE = 0x8000
	// Position of ACPA field.
	TC_CMR2_WAVEFORM_MODE_ACPA_Pos = 0x10
	// Bit mask of ACPA field.
	TC_CMR2_WAVEFORM_MODE_ACPA_Msk = 0x30000
	// None
	TC_CMR2_WAVEFORM_MODE_ACPA_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_ACPA_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_ACPA_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_ACPA_TOGGLE = 0x3
	// Position of ACPC field.
	TC_CMR2_WAVEFORM_MODE_ACPC_Pos = 0x12
	// Bit mask of ACPC field.
	TC_CMR2_WAVEFORM_MODE_ACPC_Msk = 0xc0000
	// None
	TC_CMR2_WAVEFORM_MODE_ACPC_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_ACPC_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_ACPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_ACPC_TOGGLE = 0x3
	// Position of AEEVT field.
	TC_CMR2_WAVEFORM_MODE_AEEVT_Pos = 0x14
	// Bit mask of AEEVT field.
	TC_CMR2_WAVEFORM_MODE_AEEVT_Msk = 0x300000
	// None
	TC_CMR2_WAVEFORM_MODE_AEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_AEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_AEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_AEEVT_TOGGLE = 0x3
	// Position of ASWTRG field.
	TC_CMR2_WAVEFORM_MODE_ASWTRG_Pos = 0x16
	// Bit mask of ASWTRG field.
	TC_CMR2_WAVEFORM_MODE_ASWTRG_Msk = 0xc00000
	// None
	TC_CMR2_WAVEFORM_MODE_ASWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_ASWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_ASWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_ASWTRG_TOGGLE = 0x3
	// Position of BCPB field.
	TC_CMR2_WAVEFORM_MODE_BCPB_Pos = 0x18
	// Bit mask of BCPB field.
	TC_CMR2_WAVEFORM_MODE_BCPB_Msk = 0x3000000
	// None
	TC_CMR2_WAVEFORM_MODE_BCPB_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_BCPB_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_BCPB_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_BCPB_TOGGLE = 0x3
	// Position of BCPC field.
	TC_CMR2_WAVEFORM_MODE_BCPC_Pos = 0x1a
	// Bit mask of BCPC field.
	TC_CMR2_WAVEFORM_MODE_BCPC_Msk = 0xc000000
	// None
	TC_CMR2_WAVEFORM_MODE_BCPC_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_BCPC_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_BCPC_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_BCPC_TOGGLE = 0x3
	// Position of BEEVT field.
	TC_CMR2_WAVEFORM_MODE_BEEVT_Pos = 0x1c
	// Bit mask of BEEVT field.
	TC_CMR2_WAVEFORM_MODE_BEEVT_Msk = 0x30000000
	// None
	TC_CMR2_WAVEFORM_MODE_BEEVT_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_BEEVT_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_BEEVT_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_BEEVT_TOGGLE = 0x3
	// Position of BSWTRG field.
	TC_CMR2_WAVEFORM_MODE_BSWTRG_Pos = 0x1e
	// Bit mask of BSWTRG field.
	TC_CMR2_WAVEFORM_MODE_BSWTRG_Msk = 0xc0000000
	// None
	TC_CMR2_WAVEFORM_MODE_BSWTRG_NONE = 0x0
	// Set
	TC_CMR2_WAVEFORM_MODE_BSWTRG_SET = 0x1
	// Clear
	TC_CMR2_WAVEFORM_MODE_BSWTRG_CLEAR = 0x2
	// Toggle
	TC_CMR2_WAVEFORM_MODE_BSWTRG_TOGGLE = 0x3

	// SMMR2: Stepper Motor Mode Register (channel = 2)
	// Position of GCEN field.
	TC_SMMR2_GCEN_Pos = 0x0
	// Bit mask of GCEN field.
	TC_SMMR2_GCEN_Msk = 0x1
	// Bit GCEN.
	TC_SMMR2_GCEN = 0x1
	// Position of DOWN field.
	TC_SMMR2_DOWN_Pos = 0x1
	// Bit mask of DOWN field.
	TC_SMMR2_DOWN_Msk = 0x2
	// Bit DOWN.
	TC_SMMR2_DOWN = 0x2

	// CV2: Counter Value (channel = 2)
	// Position of CV field.
	TC_CV2_CV_Pos = 0x0
	// Bit mask of CV field.
	TC_CV2_CV_Msk = 0xffffffff

	// RA2: Register A (channel = 2)
	// Position of RA field.
	TC_RA2_RA_Pos = 0x0
	// Bit mask of RA field.
	TC_RA2_RA_Msk = 0xffffffff

	// RB2: Register B (channel = 2)
	// Position of RB field.
	TC_RB2_RB_Pos = 0x0
	// Bit mask of RB field.
	TC_RB2_RB_Msk = 0xffffffff

	// RC2: Register C (channel = 2)
	// Position of RC field.
	TC_RC2_RC_Pos = 0x0
	// Bit mask of RC field.
	TC_RC2_RC_Msk = 0xffffffff

	// SR2: Status Register (channel = 2)
	// Position of COVFS field.
	TC_SR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_SR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_SR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_SR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_SR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_SR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_SR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_SR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_SR2_CPAS = 0x4
	// Position of CPBS field.
	TC_SR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_SR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_SR2_CPBS = 0x8
	// Position of CPCS field.
	TC_SR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_SR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_SR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_SR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_SR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_SR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_SR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_SR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_SR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_SR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_SR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_SR2_ETRGS = 0x80
	// Position of CLKSTA field.
	TC_SR2_CLKSTA_Pos = 0x10
	// Bit mask of CLKSTA field.
	TC_SR2_CLKSTA_Msk = 0x10000
	// Bit CLKSTA.
	TC_SR2_CLKSTA = 0x10000
	// Position of MTIOA field.
	TC_SR2_MTIOA_Pos = 0x11
	// Bit mask of MTIOA field.
	TC_SR2_MTIOA_Msk = 0x20000
	// Bit MTIOA.
	TC_SR2_MTIOA = 0x20000
	// Position of MTIOB field.
	TC_SR2_MTIOB_Pos = 0x12
	// Bit mask of MTIOB field.
	TC_SR2_MTIOB_Msk = 0x40000
	// Bit MTIOB.
	TC_SR2_MTIOB = 0x40000

	// IER2: Interrupt Enable Register (channel = 2)
	// Position of COVFS field.
	TC_IER2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IER2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IER2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IER2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IER2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IER2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IER2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IER2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IER2_CPAS = 0x4
	// Position of CPBS field.
	TC_IER2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IER2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IER2_CPBS = 0x8
	// Position of CPCS field.
	TC_IER2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IER2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IER2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IER2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IER2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IER2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IER2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IER2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IER2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IER2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IER2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IER2_ETRGS = 0x80

	// IDR2: Interrupt Disable Register (channel = 2)
	// Position of COVFS field.
	TC_IDR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IDR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IDR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IDR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IDR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IDR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IDR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IDR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IDR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IDR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IDR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IDR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IDR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IDR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IDR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IDR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IDR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IDR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IDR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IDR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IDR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IDR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IDR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IDR2_ETRGS = 0x80

	// IMR2: Interrupt Mask Register (channel = 2)
	// Position of COVFS field.
	TC_IMR2_COVFS_Pos = 0x0
	// Bit mask of COVFS field.
	TC_IMR2_COVFS_Msk = 0x1
	// Bit COVFS.
	TC_IMR2_COVFS = 0x1
	// Position of LOVRS field.
	TC_IMR2_LOVRS_Pos = 0x1
	// Bit mask of LOVRS field.
	TC_IMR2_LOVRS_Msk = 0x2
	// Bit LOVRS.
	TC_IMR2_LOVRS = 0x2
	// Position of CPAS field.
	TC_IMR2_CPAS_Pos = 0x2
	// Bit mask of CPAS field.
	TC_IMR2_CPAS_Msk = 0x4
	// Bit CPAS.
	TC_IMR2_CPAS = 0x4
	// Position of CPBS field.
	TC_IMR2_CPBS_Pos = 0x3
	// Bit mask of CPBS field.
	TC_IMR2_CPBS_Msk = 0x8
	// Bit CPBS.
	TC_IMR2_CPBS = 0x8
	// Position of CPCS field.
	TC_IMR2_CPCS_Pos = 0x4
	// Bit mask of CPCS field.
	TC_IMR2_CPCS_Msk = 0x10
	// Bit CPCS.
	TC_IMR2_CPCS = 0x10
	// Position of LDRAS field.
	TC_IMR2_LDRAS_Pos = 0x5
	// Bit mask of LDRAS field.
	TC_IMR2_LDRAS_Msk = 0x20
	// Bit LDRAS.
	TC_IMR2_LDRAS = 0x20
	// Position of LDRBS field.
	TC_IMR2_LDRBS_Pos = 0x6
	// Bit mask of LDRBS field.
	TC_IMR2_LDRBS_Msk = 0x40
	// Bit LDRBS.
	TC_IMR2_LDRBS = 0x40
	// Position of ETRGS field.
	TC_IMR2_ETRGS_Pos = 0x7
	// Bit mask of ETRGS field.
	TC_IMR2_ETRGS_Msk = 0x80
	// Bit ETRGS.
	TC_IMR2_ETRGS = 0x80

	// BCR: Block Control Register
	// Position of SYNC field.
	TC_BCR_SYNC_Pos = 0x0
	// Bit mask of SYNC field.
	TC_BCR_SYNC_Msk = 0x1
	// Bit SYNC.
	TC_BCR_SYNC = 0x1

	// BMR: Block Mode Register
	// Position of TC0XC0S field.
	TC_BMR_TC0XC0S_Pos = 0x0
	// Bit mask of TC0XC0S field.
	TC_BMR_TC0XC0S_Msk = 0x3
	// Signal connected to XC0: TCLK0
	TC_BMR_TC0XC0S_TCLK0 = 0x0
	// Signal connected to XC0: TIOA1
	TC_BMR_TC0XC0S_TIOA1 = 0x2
	// Signal connected to XC0: TIOA2
	TC_BMR_TC0XC0S_TIOA2 = 0x3
	// Position of TC1XC1S field.
	TC_BMR_TC1XC1S_Pos = 0x2
	// Bit mask of TC1XC1S field.
	TC_BMR_TC1XC1S_Msk = 0xc
	// Signal connected to XC1: TCLK1
	TC_BMR_TC1XC1S_TCLK1 = 0x0
	// Signal connected to XC1: TIOA0
	TC_BMR_TC1XC1S_TIOA0 = 0x2
	// Signal connected to XC1: TIOA2
	TC_BMR_TC1XC1S_TIOA2 = 0x3
	// Position of TC2XC2S field.
	TC_BMR_TC2XC2S_Pos = 0x4
	// Bit mask of TC2XC2S field.
	TC_BMR_TC2XC2S_Msk = 0x30
	// Signal connected to XC2: TCLK2
	TC_BMR_TC2XC2S_TCLK2 = 0x0
	// Signal connected to XC2: TIOA0
	TC_BMR_TC2XC2S_TIOA0 = 0x2
	// Signal connected to XC2: TIOA1
	TC_BMR_TC2XC2S_TIOA1 = 0x3
	// Position of QDEN field.
	TC_BMR_QDEN_Pos = 0x8
	// Bit mask of QDEN field.
	TC_BMR_QDEN_Msk = 0x100
	// Bit QDEN.
	TC_BMR_QDEN = 0x100
	// Position of POSEN field.
	TC_BMR_POSEN_Pos = 0x9
	// Bit mask of POSEN field.
	TC_BMR_POSEN_Msk = 0x200
	// Bit POSEN.
	TC_BMR_POSEN = 0x200
	// Position of SPEEDEN field.
	TC_BMR_SPEEDEN_Pos = 0xa
	// Bit mask of SPEEDEN field.
	TC_BMR_SPEEDEN_Msk = 0x400
	// Bit SPEEDEN.
	TC_BMR_SPEEDEN = 0x400
	// Position of QDTRANS field.
	TC_BMR_QDTRANS_Pos = 0xb
	// Bit mask of QDTRANS field.
	TC_BMR_QDTRANS_Msk = 0x800
	// Bit QDTRANS.
	TC_BMR_QDTRANS = 0x800
	// Position of EDGPHA field.
	TC_BMR_EDGPHA_Pos = 0xc
	// Bit mask of EDGPHA field.
	TC_BMR_EDGPHA_Msk = 0x1000
	// Bit EDGPHA.
	TC_BMR_EDGPHA = 0x1000
	// Position of INVA field.
	TC_BMR_INVA_Pos = 0xd
	// Bit mask of INVA field.
	TC_BMR_INVA_Msk = 0x2000
	// Bit INVA.
	TC_BMR_INVA = 0x2000
	// Position of INVB field.
	TC_BMR_INVB_Pos = 0xe
	// Bit mask of INVB field.
	TC_BMR_INVB_Msk = 0x4000
	// Bit INVB.
	TC_BMR_INVB = 0x4000
	// Position of INVIDX field.
	TC_BMR_INVIDX_Pos = 0xf
	// Bit mask of INVIDX field.
	TC_BMR_INVIDX_Msk = 0x8000
	// Bit INVIDX.
	TC_BMR_INVIDX = 0x8000
	// Position of SWAP field.
	TC_BMR_SWAP_Pos = 0x10
	// Bit mask of SWAP field.
	TC_BMR_SWAP_Msk = 0x10000
	// Bit SWAP.
	TC_BMR_SWAP = 0x10000
	// Position of IDXPHB field.
	TC_BMR_IDXPHB_Pos = 0x11
	// Bit mask of IDXPHB field.
	TC_BMR_IDXPHB_Msk = 0x20000
	// Bit IDXPHB.
	TC_BMR_IDXPHB = 0x20000
	// Position of MAXFILT field.
	TC_BMR_MAXFILT_Pos = 0x14
	// Bit mask of MAXFILT field.
	TC_BMR_MAXFILT_Msk = 0x3f00000

	// QIER: QDEC Interrupt Enable Register
	// Position of IDX field.
	TC_QIER_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIER_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIER_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIER_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIER_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIER_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIER_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIER_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIER_QERR = 0x4

	// QIDR: QDEC Interrupt Disable Register
	// Position of IDX field.
	TC_QIDR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIDR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIDR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIDR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIDR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIDR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIDR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIDR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIDR_QERR = 0x4

	// QIMR: QDEC Interrupt Mask Register
	// Position of IDX field.
	TC_QIMR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QIMR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QIMR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QIMR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QIMR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QIMR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QIMR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QIMR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QIMR_QERR = 0x4

	// QISR: QDEC Interrupt Status Register
	// Position of IDX field.
	TC_QISR_IDX_Pos = 0x0
	// Bit mask of IDX field.
	TC_QISR_IDX_Msk = 0x1
	// Bit IDX.
	TC_QISR_IDX = 0x1
	// Position of DIRCHG field.
	TC_QISR_DIRCHG_Pos = 0x1
	// Bit mask of DIRCHG field.
	TC_QISR_DIRCHG_Msk = 0x2
	// Bit DIRCHG.
	TC_QISR_DIRCHG = 0x2
	// Position of QERR field.
	TC_QISR_QERR_Pos = 0x2
	// Bit mask of QERR field.
	TC_QISR_QERR_Msk = 0x4
	// Bit QERR.
	TC_QISR_QERR = 0x4
	// Position of DIR field.
	TC_QISR_DIR_Pos = 0x8
	// Bit mask of DIR field.
	TC_QISR_DIR_Msk = 0x100
	// Bit DIR.
	TC_QISR_DIR = 0x100

	// WPMR: Write Protection Mode Register
	// Position of WPEN field.
	TC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	TC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	TC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	TC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	TC_WPMR_WPKEY_Msk = 0xffffff00
	// Writing any other value in this field aborts the write operation of the WPEN bit.Always reads as 0.
	TC_WPMR_WPKEY_PASSWD = 0x54494d
)

// Constants for TWI0: Two-wire Interface 0
const (
	// CR: Control Register
	// Position of START field.
	TWI_CR_START_Pos = 0x0
	// Bit mask of START field.
	TWI_CR_START_Msk = 0x1
	// Bit START.
	TWI_CR_START = 0x1
	// Position of STOP field.
	TWI_CR_STOP_Pos = 0x1
	// Bit mask of STOP field.
	TWI_CR_STOP_Msk = 0x2
	// Bit STOP.
	TWI_CR_STOP = 0x2
	// Position of MSEN field.
	TWI_CR_MSEN_Pos = 0x2
	// Bit mask of MSEN field.
	TWI_CR_MSEN_Msk = 0x4
	// Bit MSEN.
	TWI_CR_MSEN = 0x4
	// Position of MSDIS field.
	TWI_CR_MSDIS_Pos = 0x3
	// Bit mask of MSDIS field.
	TWI_CR_MSDIS_Msk = 0x8
	// Bit MSDIS.
	TWI_CR_MSDIS = 0x8
	// Position of SVEN field.
	TWI_CR_SVEN_Pos = 0x4
	// Bit mask of SVEN field.
	TWI_CR_SVEN_Msk = 0x10
	// Bit SVEN.
	TWI_CR_SVEN = 0x10
	// Position of SVDIS field.
	TWI_CR_SVDIS_Pos = 0x5
	// Bit mask of SVDIS field.
	TWI_CR_SVDIS_Msk = 0x20
	// Bit SVDIS.
	TWI_CR_SVDIS = 0x20
	// Position of QUICK field.
	TWI_CR_QUICK_Pos = 0x6
	// Bit mask of QUICK field.
	TWI_CR_QUICK_Msk = 0x40
	// Bit QUICK.
	TWI_CR_QUICK = 0x40
	// Position of SWRST field.
	TWI_CR_SWRST_Pos = 0x7
	// Bit mask of SWRST field.
	TWI_CR_SWRST_Msk = 0x80
	// Bit SWRST.
	TWI_CR_SWRST = 0x80

	// MMR: Master Mode Register
	// Position of IADRSZ field.
	TWI_MMR_IADRSZ_Pos = 0x8
	// Bit mask of IADRSZ field.
	TWI_MMR_IADRSZ_Msk = 0x300
	// No internal device address
	TWI_MMR_IADRSZ_NONE = 0x0
	// One-byte internal device address
	TWI_MMR_IADRSZ_1_BYTE = 0x1
	// Two-byte internal device address
	TWI_MMR_IADRSZ_2_BYTE = 0x2
	// Three-byte internal device address
	TWI_MMR_IADRSZ_3_BYTE = 0x3
	// Position of MREAD field.
	TWI_MMR_MREAD_Pos = 0xc
	// Bit mask of MREAD field.
	TWI_MMR_MREAD_Msk = 0x1000
	// Bit MREAD.
	TWI_MMR_MREAD = 0x1000
	// Position of DADR field.
	TWI_MMR_DADR_Pos = 0x10
	// Bit mask of DADR field.
	TWI_MMR_DADR_Msk = 0x7f0000

	// SMR: Slave Mode Register
	// Position of SADR field.
	TWI_SMR_SADR_Pos = 0x10
	// Bit mask of SADR field.
	TWI_SMR_SADR_Msk = 0x7f0000

	// IADR: Internal Address Register
	// Position of IADR field.
	TWI_IADR_IADR_Pos = 0x0
	// Bit mask of IADR field.
	TWI_IADR_IADR_Msk = 0xffffff

	// CWGR: Clock Waveform Generator Register
	// Position of CLDIV field.
	TWI_CWGR_CLDIV_Pos = 0x0
	// Bit mask of CLDIV field.
	TWI_CWGR_CLDIV_Msk = 0xff
	// Position of CHDIV field.
	TWI_CWGR_CHDIV_Pos = 0x8
	// Bit mask of CHDIV field.
	TWI_CWGR_CHDIV_Msk = 0xff00
	// Position of CKDIV field.
	TWI_CWGR_CKDIV_Pos = 0x10
	// Bit mask of CKDIV field.
	TWI_CWGR_CKDIV_Msk = 0x70000

	// SR: Status Register
	// Position of TXCOMP field.
	TWI_SR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_SR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_SR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_SR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_SR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_SR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_SR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_SR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_SR_TXRDY = 0x4
	// Position of SVREAD field.
	TWI_SR_SVREAD_Pos = 0x3
	// Bit mask of SVREAD field.
	TWI_SR_SVREAD_Msk = 0x8
	// Bit SVREAD.
	TWI_SR_SVREAD = 0x8
	// Position of SVACC field.
	TWI_SR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_SR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_SR_SVACC = 0x10
	// Position of GACC field.
	TWI_SR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_SR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_SR_GACC = 0x20
	// Position of OVRE field.
	TWI_SR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_SR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_SR_OVRE = 0x40
	// Position of NACK field.
	TWI_SR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_SR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_SR_NACK = 0x100
	// Position of ARBLST field.
	TWI_SR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_SR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_SR_ARBLST = 0x200
	// Position of SCLWS field.
	TWI_SR_SCLWS_Pos = 0xa
	// Bit mask of SCLWS field.
	TWI_SR_SCLWS_Msk = 0x400
	// Bit SCLWS.
	TWI_SR_SCLWS = 0x400
	// Position of EOSACC field.
	TWI_SR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_SR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_SR_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_SR_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_SR_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_SR_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_SR_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_SR_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_SR_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_SR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_SR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_SR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_SR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_SR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_SR_TXBUFE = 0x8000

	// IER: Interrupt Enable Register
	// Position of TXCOMP field.
	TWI_IER_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IER_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IER_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IER_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IER_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IER_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IER_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IER_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IER_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IER_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IER_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IER_SVACC = 0x10
	// Position of GACC field.
	TWI_IER_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IER_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IER_GACC = 0x20
	// Position of OVRE field.
	TWI_IER_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IER_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IER_OVRE = 0x40
	// Position of NACK field.
	TWI_IER_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IER_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IER_NACK = 0x100
	// Position of ARBLST field.
	TWI_IER_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IER_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IER_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IER_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IER_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IER_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IER_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IER_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IER_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_IER_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_IER_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_IER_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_IER_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_IER_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_IER_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_IER_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_IER_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_IER_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_IER_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_IER_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_IER_TXBUFE = 0x8000

	// IDR: Interrupt Disable Register
	// Position of TXCOMP field.
	TWI_IDR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IDR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IDR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IDR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IDR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IDR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IDR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IDR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IDR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IDR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IDR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IDR_SVACC = 0x10
	// Position of GACC field.
	TWI_IDR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IDR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IDR_GACC = 0x20
	// Position of OVRE field.
	TWI_IDR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IDR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IDR_OVRE = 0x40
	// Position of NACK field.
	TWI_IDR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IDR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IDR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IDR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IDR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IDR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IDR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IDR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IDR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IDR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IDR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IDR_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_IDR_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_IDR_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_IDR_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_IDR_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_IDR_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_IDR_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_IDR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_IDR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_IDR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_IDR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_IDR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_IDR_TXBUFE = 0x8000

	// IMR: Interrupt Mask Register
	// Position of TXCOMP field.
	TWI_IMR_TXCOMP_Pos = 0x0
	// Bit mask of TXCOMP field.
	TWI_IMR_TXCOMP_Msk = 0x1
	// Bit TXCOMP.
	TWI_IMR_TXCOMP = 0x1
	// Position of RXRDY field.
	TWI_IMR_RXRDY_Pos = 0x1
	// Bit mask of RXRDY field.
	TWI_IMR_RXRDY_Msk = 0x2
	// Bit RXRDY.
	TWI_IMR_RXRDY = 0x2
	// Position of TXRDY field.
	TWI_IMR_TXRDY_Pos = 0x2
	// Bit mask of TXRDY field.
	TWI_IMR_TXRDY_Msk = 0x4
	// Bit TXRDY.
	TWI_IMR_TXRDY = 0x4
	// Position of SVACC field.
	TWI_IMR_SVACC_Pos = 0x4
	// Bit mask of SVACC field.
	TWI_IMR_SVACC_Msk = 0x10
	// Bit SVACC.
	TWI_IMR_SVACC = 0x10
	// Position of GACC field.
	TWI_IMR_GACC_Pos = 0x5
	// Bit mask of GACC field.
	TWI_IMR_GACC_Msk = 0x20
	// Bit GACC.
	TWI_IMR_GACC = 0x20
	// Position of OVRE field.
	TWI_IMR_OVRE_Pos = 0x6
	// Bit mask of OVRE field.
	TWI_IMR_OVRE_Msk = 0x40
	// Bit OVRE.
	TWI_IMR_OVRE = 0x40
	// Position of NACK field.
	TWI_IMR_NACK_Pos = 0x8
	// Bit mask of NACK field.
	TWI_IMR_NACK_Msk = 0x100
	// Bit NACK.
	TWI_IMR_NACK = 0x100
	// Position of ARBLST field.
	TWI_IMR_ARBLST_Pos = 0x9
	// Bit mask of ARBLST field.
	TWI_IMR_ARBLST_Msk = 0x200
	// Bit ARBLST.
	TWI_IMR_ARBLST = 0x200
	// Position of SCL_WS field.
	TWI_IMR_SCL_WS_Pos = 0xa
	// Bit mask of SCL_WS field.
	TWI_IMR_SCL_WS_Msk = 0x400
	// Bit SCL_WS.
	TWI_IMR_SCL_WS = 0x400
	// Position of EOSACC field.
	TWI_IMR_EOSACC_Pos = 0xb
	// Bit mask of EOSACC field.
	TWI_IMR_EOSACC_Msk = 0x800
	// Bit EOSACC.
	TWI_IMR_EOSACC = 0x800
	// Position of ENDRX field.
	TWI_IMR_ENDRX_Pos = 0xc
	// Bit mask of ENDRX field.
	TWI_IMR_ENDRX_Msk = 0x1000
	// Bit ENDRX.
	TWI_IMR_ENDRX = 0x1000
	// Position of ENDTX field.
	TWI_IMR_ENDTX_Pos = 0xd
	// Bit mask of ENDTX field.
	TWI_IMR_ENDTX_Msk = 0x2000
	// Bit ENDTX.
	TWI_IMR_ENDTX = 0x2000
	// Position of RXBUFF field.
	TWI_IMR_RXBUFF_Pos = 0xe
	// Bit mask of RXBUFF field.
	TWI_IMR_RXBUFF_Msk = 0x4000
	// Bit RXBUFF.
	TWI_IMR_RXBUFF = 0x4000
	// Position of TXBUFE field.
	TWI_IMR_TXBUFE_Pos = 0xf
	// Bit mask of TXBUFE field.
	TWI_IMR_TXBUFE_Msk = 0x8000
	// Bit TXBUFE.
	TWI_IMR_TXBUFE = 0x8000

	// RHR: Receive Holding Register
	// Position of RXDATA field.
	TWI_RHR_RXDATA_Pos = 0x0
	// Bit mask of RXDATA field.
	TWI_RHR_RXDATA_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXDATA field.
	TWI_THR_TXDATA_Pos = 0x0
	// Bit mask of TXDATA field.
	TWI_THR_TXDATA_Msk = 0xff

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	TWI_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	TWI_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	TWI_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	TWI_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	TWI_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	TWI_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	TWI_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	TWI_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	TWI_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	TWI_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	TWI_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	TWI_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	TWI_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	TWI_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	TWI_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	TWI_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	TWI_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	TWI_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	TWI_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	TWI_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	TWI_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	TWI_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	TWI_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	TWI_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	TWI_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	TWI_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	TWI_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	TWI_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	TWI_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	TWI_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	TWI_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	TWI_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	TWI_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	TWI_PTSR_TXTEN = 0x100
)

// Constants for PWM: Pulse Width Modulation Controller
const (
	// MR: PWM Mode Register
	// Position of DIVA field.
	PWM_MR_DIVA_Pos = 0x0
	// Bit mask of DIVA field.
	PWM_MR_DIVA_Msk = 0xff
	// CLKA, CLKB clock is turned off
	PWM_MR_DIVA_CLK_OFF = 0x0
	// CLKA, CLKB clock is clock selected by PREA, PREB
	PWM_MR_DIVA_CLK_DIV1 = 0x1
	// Position of PREA field.
	PWM_MR_PREA_Pos = 0x8
	// Bit mask of PREA field.
	PWM_MR_PREA_Msk = 0xf00
	// Master Clock
	PWM_MR_PREA_MCK = 0x0
	// Master Clock divided by 2
	PWM_MR_PREA_MCKDIV2 = 0x1
	// Master Clock divided by 4
	PWM_MR_PREA_MCKDIV4 = 0x2
	// Master Clock divided by 8
	PWM_MR_PREA_MCKDIV8 = 0x3
	// Master Clock divided by 16
	PWM_MR_PREA_MCKDIV16 = 0x4
	// Master Clock divided by 32
	PWM_MR_PREA_MCKDIV32 = 0x5
	// Master Clock divided by 64
	PWM_MR_PREA_MCKDIV64 = 0x6
	// Master Clock divided by 128
	PWM_MR_PREA_MCKDIV128 = 0x7
	// Master Clock divided by 256
	PWM_MR_PREA_MCKDIV256 = 0x8
	// Master Clock divided by 512
	PWM_MR_PREA_MCKDIV512 = 0x9
	// Master Clock divided by 1024
	PWM_MR_PREA_MCKDIV1024 = 0xa
	// Position of DIVB field.
	PWM_MR_DIVB_Pos = 0x10
	// Bit mask of DIVB field.
	PWM_MR_DIVB_Msk = 0xff0000
	// CLKA, CLKB clock is turned off
	PWM_MR_DIVB_CLK_OFF = 0x0
	// CLKA, CLKB clock is clock selected by PREA, PREB
	PWM_MR_DIVB_CLK_DIV1 = 0x1
	// Position of PREB field.
	PWM_MR_PREB_Pos = 0x18
	// Bit mask of PREB field.
	PWM_MR_PREB_Msk = 0xf000000
	// Master Clock
	PWM_MR_PREB_MCK = 0x0
	// Master Clock divided by 2
	PWM_MR_PREB_MCKDIV2 = 0x1
	// Master Clock divided by 4
	PWM_MR_PREB_MCKDIV4 = 0x2
	// Master Clock divided by 8
	PWM_MR_PREB_MCKDIV8 = 0x3
	// Master Clock divided by 16
	PWM_MR_PREB_MCKDIV16 = 0x4
	// Master Clock divided by 32
	PWM_MR_PREB_MCKDIV32 = 0x5
	// Master Clock divided by 64
	PWM_MR_PREB_MCKDIV64 = 0x6
	// Master Clock divided by 128
	PWM_MR_PREB_MCKDIV128 = 0x7
	// Master Clock divided by 256
	PWM_MR_PREB_MCKDIV256 = 0x8
	// Master Clock divided by 512
	PWM_MR_PREB_MCKDIV512 = 0x9
	// Master Clock divided by 1024
	PWM_MR_PREB_MCKDIV1024 = 0xa

	// ENA: PWM Enable Register
	// Position of CHID0 field.
	PWM_ENA_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_ENA_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_ENA_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_ENA_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_ENA_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_ENA_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_ENA_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_ENA_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_ENA_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_ENA_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_ENA_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_ENA_CHID3 = 0x8

	// DIS: PWM Disable Register
	// Position of CHID0 field.
	PWM_DIS_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_DIS_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_DIS_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_DIS_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_DIS_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_DIS_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_DIS_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_DIS_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_DIS_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_DIS_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_DIS_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_DIS_CHID3 = 0x8

	// SR: PWM Status Register
	// Position of CHID0 field.
	PWM_SR_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_SR_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_SR_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_SR_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_SR_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_SR_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_SR_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_SR_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_SR_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_SR_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_SR_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_SR_CHID3 = 0x8

	// IER: PWM Interrupt Enable Register
	// Position of CHID0 field.
	PWM_IER_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IER_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IER_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IER_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IER_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IER_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IER_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IER_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IER_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IER_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IER_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IER_CHID3 = 0x8

	// IDR: PWM Interrupt Disable Register
	// Position of CHID0 field.
	PWM_IDR_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IDR_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IDR_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IDR_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IDR_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IDR_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IDR_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IDR_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IDR_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IDR_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IDR_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IDR_CHID3 = 0x8

	// IMR: PWM Interrupt Mask Register
	// Position of CHID0 field.
	PWM_IMR_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_IMR_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_IMR_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_IMR_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_IMR_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_IMR_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_IMR_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_IMR_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_IMR_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_IMR_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_IMR_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_IMR_CHID3 = 0x8

	// ISR: PWM Interrupt Status Register
	// Position of CHID0 field.
	PWM_ISR_CHID0_Pos = 0x0
	// Bit mask of CHID0 field.
	PWM_ISR_CHID0_Msk = 0x1
	// Bit CHID0.
	PWM_ISR_CHID0 = 0x1
	// Position of CHID1 field.
	PWM_ISR_CHID1_Pos = 0x1
	// Bit mask of CHID1 field.
	PWM_ISR_CHID1_Msk = 0x2
	// Bit CHID1.
	PWM_ISR_CHID1 = 0x2
	// Position of CHID2 field.
	PWM_ISR_CHID2_Pos = 0x2
	// Bit mask of CHID2 field.
	PWM_ISR_CHID2_Msk = 0x4
	// Bit CHID2.
	PWM_ISR_CHID2 = 0x4
	// Position of CHID3 field.
	PWM_ISR_CHID3_Pos = 0x3
	// Bit mask of CHID3 field.
	PWM_ISR_CHID3_Msk = 0x8
	// Bit CHID3.
	PWM_ISR_CHID3 = 0x8

	// CMR0: PWM Channel Mode Register (ch_num = 0)
	// Position of CPRE field.
	PWM_CMR0_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR0_CPRE_Msk = 0xf
	// Master Clock
	PWM_CMR0_CPRE_MCK = 0x0
	// Master Clock divided by 2
	PWM_CMR0_CPRE_MCKDIV2 = 0x1
	// Master Clock divided by 4
	PWM_CMR0_CPRE_MCKDIV4 = 0x2
	// Master Clock divided by 8
	PWM_CMR0_CPRE_MCKDIV8 = 0x3
	// Master Clock divided by 16
	PWM_CMR0_CPRE_MCKDIV16 = 0x4
	// Master Clock divided by 32
	PWM_CMR0_CPRE_MCKDIV32 = 0x5
	// Master Clock divided by 64
	PWM_CMR0_CPRE_MCKDIV64 = 0x6
	// Master Clock divided by 128
	PWM_CMR0_CPRE_MCKDIV128 = 0x7
	// Master Clock divided by 256
	PWM_CMR0_CPRE_MCKDIV256 = 0x8
	// Master Clock divided by 512
	PWM_CMR0_CPRE_MCKDIV512 = 0x9
	// Master Clock divided by 1024
	PWM_CMR0_CPRE_MCKDIV1024 = 0xa
	// Clock A
	PWM_CMR0_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR0_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR0_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR0_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR0_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR0_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR0_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR0_CPOL = 0x200
	// Position of CPD field.
	PWM_CMR0_CPD_Pos = 0xa
	// Bit mask of CPD field.
	PWM_CMR0_CPD_Msk = 0x400
	// Bit CPD.
	PWM_CMR0_CPD = 0x400

	// CDTY0: PWM Channel Duty Cycle Register (ch_num = 0)
	// Position of CDTY field.
	PWM_CDTY0_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY0_CDTY_Msk = 0xffffffff

	// CPRD0: PWM Channel Period Register (ch_num = 0)
	// Position of CPRD field.
	PWM_CPRD0_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD0_CPRD_Msk = 0xffffffff

	// CCNT0: PWM Channel Counter Register (ch_num = 0)
	// Position of CNT field.
	PWM_CCNT0_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT0_CNT_Msk = 0xffffffff

	// CUPD0: PWM Channel Update Register (ch_num = 0)
	// Position of CUPD field.
	PWM_CUPD0_CUPD_Pos = 0x0
	// Bit mask of CUPD field.
	PWM_CUPD0_CUPD_Msk = 0xffffffff

	// CMR1: PWM Channel Mode Register (ch_num = 1)
	// Position of CPRE field.
	PWM_CMR1_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR1_CPRE_Msk = 0xf
	// Master Clock
	PWM_CMR1_CPRE_MCK = 0x0
	// Master Clock divided by 2
	PWM_CMR1_CPRE_MCKDIV2 = 0x1
	// Master Clock divided by 4
	PWM_CMR1_CPRE_MCKDIV4 = 0x2
	// Master Clock divided by 8
	PWM_CMR1_CPRE_MCKDIV8 = 0x3
	// Master Clock divided by 16
	PWM_CMR1_CPRE_MCKDIV16 = 0x4
	// Master Clock divided by 32
	PWM_CMR1_CPRE_MCKDIV32 = 0x5
	// Master Clock divided by 64
	PWM_CMR1_CPRE_MCKDIV64 = 0x6
	// Master Clock divided by 128
	PWM_CMR1_CPRE_MCKDIV128 = 0x7
	// Master Clock divided by 256
	PWM_CMR1_CPRE_MCKDIV256 = 0x8
	// Master Clock divided by 512
	PWM_CMR1_CPRE_MCKDIV512 = 0x9
	// Master Clock divided by 1024
	PWM_CMR1_CPRE_MCKDIV1024 = 0xa
	// Clock A
	PWM_CMR1_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR1_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR1_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR1_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR1_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR1_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR1_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR1_CPOL = 0x200
	// Position of CPD field.
	PWM_CMR1_CPD_Pos = 0xa
	// Bit mask of CPD field.
	PWM_CMR1_CPD_Msk = 0x400
	// Bit CPD.
	PWM_CMR1_CPD = 0x400

	// CDTY1: PWM Channel Duty Cycle Register (ch_num = 1)
	// Position of CDTY field.
	PWM_CDTY1_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY1_CDTY_Msk = 0xffffffff

	// CPRD1: PWM Channel Period Register (ch_num = 1)
	// Position of CPRD field.
	PWM_CPRD1_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD1_CPRD_Msk = 0xffffffff

	// CCNT1: PWM Channel Counter Register (ch_num = 1)
	// Position of CNT field.
	PWM_CCNT1_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT1_CNT_Msk = 0xffffffff

	// CUPD1: PWM Channel Update Register (ch_num = 1)
	// Position of CUPD field.
	PWM_CUPD1_CUPD_Pos = 0x0
	// Bit mask of CUPD field.
	PWM_CUPD1_CUPD_Msk = 0xffffffff

	// CMR2: PWM Channel Mode Register (ch_num = 2)
	// Position of CPRE field.
	PWM_CMR2_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR2_CPRE_Msk = 0xf
	// Master Clock
	PWM_CMR2_CPRE_MCK = 0x0
	// Master Clock divided by 2
	PWM_CMR2_CPRE_MCKDIV2 = 0x1
	// Master Clock divided by 4
	PWM_CMR2_CPRE_MCKDIV4 = 0x2
	// Master Clock divided by 8
	PWM_CMR2_CPRE_MCKDIV8 = 0x3
	// Master Clock divided by 16
	PWM_CMR2_CPRE_MCKDIV16 = 0x4
	// Master Clock divided by 32
	PWM_CMR2_CPRE_MCKDIV32 = 0x5
	// Master Clock divided by 64
	PWM_CMR2_CPRE_MCKDIV64 = 0x6
	// Master Clock divided by 128
	PWM_CMR2_CPRE_MCKDIV128 = 0x7
	// Master Clock divided by 256
	PWM_CMR2_CPRE_MCKDIV256 = 0x8
	// Master Clock divided by 512
	PWM_CMR2_CPRE_MCKDIV512 = 0x9
	// Master Clock divided by 1024
	PWM_CMR2_CPRE_MCKDIV1024 = 0xa
	// Clock A
	PWM_CMR2_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR2_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR2_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR2_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR2_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR2_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR2_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR2_CPOL = 0x200
	// Position of CPD field.
	PWM_CMR2_CPD_Pos = 0xa
	// Bit mask of CPD field.
	PWM_CMR2_CPD_Msk = 0x400
	// Bit CPD.
	PWM_CMR2_CPD = 0x400

	// CDTY2: PWM Channel Duty Cycle Register (ch_num = 2)
	// Position of CDTY field.
	PWM_CDTY2_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY2_CDTY_Msk = 0xffffffff

	// CPRD2: PWM Channel Period Register (ch_num = 2)
	// Position of CPRD field.
	PWM_CPRD2_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD2_CPRD_Msk = 0xffffffff

	// CCNT2: PWM Channel Counter Register (ch_num = 2)
	// Position of CNT field.
	PWM_CCNT2_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT2_CNT_Msk = 0xffffffff

	// CUPD2: PWM Channel Update Register (ch_num = 2)
	// Position of CUPD field.
	PWM_CUPD2_CUPD_Pos = 0x0
	// Bit mask of CUPD field.
	PWM_CUPD2_CUPD_Msk = 0xffffffff

	// CMR3: PWM Channel Mode Register (ch_num = 3)
	// Position of CPRE field.
	PWM_CMR3_CPRE_Pos = 0x0
	// Bit mask of CPRE field.
	PWM_CMR3_CPRE_Msk = 0xf
	// Master Clock
	PWM_CMR3_CPRE_MCK = 0x0
	// Master Clock divided by 2
	PWM_CMR3_CPRE_MCKDIV2 = 0x1
	// Master Clock divided by 4
	PWM_CMR3_CPRE_MCKDIV4 = 0x2
	// Master Clock divided by 8
	PWM_CMR3_CPRE_MCKDIV8 = 0x3
	// Master Clock divided by 16
	PWM_CMR3_CPRE_MCKDIV16 = 0x4
	// Master Clock divided by 32
	PWM_CMR3_CPRE_MCKDIV32 = 0x5
	// Master Clock divided by 64
	PWM_CMR3_CPRE_MCKDIV64 = 0x6
	// Master Clock divided by 128
	PWM_CMR3_CPRE_MCKDIV128 = 0x7
	// Master Clock divided by 256
	PWM_CMR3_CPRE_MCKDIV256 = 0x8
	// Master Clock divided by 512
	PWM_CMR3_CPRE_MCKDIV512 = 0x9
	// Master Clock divided by 1024
	PWM_CMR3_CPRE_MCKDIV1024 = 0xa
	// Clock A
	PWM_CMR3_CPRE_CLKA = 0xb
	// Clock B
	PWM_CMR3_CPRE_CLKB = 0xc
	// Position of CALG field.
	PWM_CMR3_CALG_Pos = 0x8
	// Bit mask of CALG field.
	PWM_CMR3_CALG_Msk = 0x100
	// Bit CALG.
	PWM_CMR3_CALG = 0x100
	// Position of CPOL field.
	PWM_CMR3_CPOL_Pos = 0x9
	// Bit mask of CPOL field.
	PWM_CMR3_CPOL_Msk = 0x200
	// Bit CPOL.
	PWM_CMR3_CPOL = 0x200
	// Position of CPD field.
	PWM_CMR3_CPD_Pos = 0xa
	// Bit mask of CPD field.
	PWM_CMR3_CPD_Msk = 0x400
	// Bit CPD.
	PWM_CMR3_CPD = 0x400

	// CDTY3: PWM Channel Duty Cycle Register (ch_num = 3)
	// Position of CDTY field.
	PWM_CDTY3_CDTY_Pos = 0x0
	// Bit mask of CDTY field.
	PWM_CDTY3_CDTY_Msk = 0xffffffff

	// CPRD3: PWM Channel Period Register (ch_num = 3)
	// Position of CPRD field.
	PWM_CPRD3_CPRD_Pos = 0x0
	// Bit mask of CPRD field.
	PWM_CPRD3_CPRD_Msk = 0xffffffff

	// CCNT3: PWM Channel Counter Register (ch_num = 3)
	// Position of CNT field.
	PWM_CCNT3_CNT_Pos = 0x0
	// Bit mask of CNT field.
	PWM_CCNT3_CNT_Msk = 0xffffffff

	// CUPD3: PWM Channel Update Register (ch_num = 3)
	// Position of CUPD field.
	PWM_CUPD3_CUPD_Pos = 0x0
	// Bit mask of CUPD field.
	PWM_CUPD3_CUPD_Msk = 0xffffffff
)

// Constants for USART0: Universal Synchronous Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	// Position of RSTRX field.
	USART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_RSTSTA = 0x100
	// Position of STTBRK field.
	USART_CR_STTBRK_Pos = 0x9
	// Bit mask of STTBRK field.
	USART_CR_STTBRK_Msk = 0x200
	// Bit STTBRK.
	USART_CR_STTBRK = 0x200
	// Position of STPBRK field.
	USART_CR_STPBRK_Pos = 0xa
	// Bit mask of STPBRK field.
	USART_CR_STPBRK_Msk = 0x400
	// Bit STPBRK.
	USART_CR_STPBRK = 0x400
	// Position of STTTO field.
	USART_CR_STTTO_Pos = 0xb
	// Bit mask of STTTO field.
	USART_CR_STTTO_Msk = 0x800
	// Bit STTTO.
	USART_CR_STTTO = 0x800
	// Position of SENDA field.
	USART_CR_SENDA_Pos = 0xc
	// Bit mask of SENDA field.
	USART_CR_SENDA_Msk = 0x1000
	// Bit SENDA.
	USART_CR_SENDA = 0x1000
	// Position of RSTIT field.
	USART_CR_RSTIT_Pos = 0xd
	// Bit mask of RSTIT field.
	USART_CR_RSTIT_Msk = 0x2000
	// Bit RSTIT.
	USART_CR_RSTIT = 0x2000
	// Position of RSTNACK field.
	USART_CR_RSTNACK_Pos = 0xe
	// Bit mask of RSTNACK field.
	USART_CR_RSTNACK_Msk = 0x4000
	// Bit RSTNACK.
	USART_CR_RSTNACK = 0x4000
	// Position of RETTO field.
	USART_CR_RETTO_Pos = 0xf
	// Bit mask of RETTO field.
	USART_CR_RETTO_Msk = 0x8000
	// Bit RETTO.
	USART_CR_RETTO = 0x8000
	// Position of RTSEN field.
	USART_CR_RTSEN_Pos = 0x12
	// Bit mask of RTSEN field.
	USART_CR_RTSEN_Msk = 0x40000
	// Bit RTSEN.
	USART_CR_RTSEN = 0x40000
	// Position of RTSDIS field.
	USART_CR_RTSDIS_Pos = 0x13
	// Bit mask of RTSDIS field.
	USART_CR_RTSDIS_Msk = 0x80000
	// Bit RTSDIS.
	USART_CR_RTSDIS = 0x80000

	// CR_SPI_MODE: Control Register
	// Position of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	USART_CR_SPI_MODE_RSTRX_Msk = 0x4
	// Bit RSTRX.
	USART_CR_SPI_MODE_RSTRX = 0x4
	// Position of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	USART_CR_SPI_MODE_RSTTX_Msk = 0x8
	// Bit RSTTX.
	USART_CR_SPI_MODE_RSTTX = 0x8
	// Position of RXEN field.
	USART_CR_SPI_MODE_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	USART_CR_SPI_MODE_RXEN_Msk = 0x10
	// Bit RXEN.
	USART_CR_SPI_MODE_RXEN = 0x10
	// Position of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	USART_CR_SPI_MODE_RXDIS_Msk = 0x20
	// Bit RXDIS.
	USART_CR_SPI_MODE_RXDIS = 0x20
	// Position of TXEN field.
	USART_CR_SPI_MODE_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	USART_CR_SPI_MODE_TXEN_Msk = 0x40
	// Bit TXEN.
	USART_CR_SPI_MODE_TXEN = 0x40
	// Position of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	USART_CR_SPI_MODE_TXDIS_Msk = 0x80
	// Bit TXDIS.
	USART_CR_SPI_MODE_TXDIS = 0x80
	// Position of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	USART_CR_SPI_MODE_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	USART_CR_SPI_MODE_RSTSTA = 0x100
	// Position of FCS field.
	USART_CR_SPI_MODE_FCS_Pos = 0x12
	// Bit mask of FCS field.
	USART_CR_SPI_MODE_FCS_Msk = 0x40000
	// Bit FCS.
	USART_CR_SPI_MODE_FCS = 0x40000
	// Position of RCS field.
	USART_CR_SPI_MODE_RCS_Pos = 0x13
	// Bit mask of RCS field.
	USART_CR_SPI_MODE_RCS_Msk = 0x80000
	// Bit RCS.
	USART_CR_SPI_MODE_RCS = 0x80000

	// MR: Mode Register
	// Position of USART_MODE field.
	USART_MR_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_USART_MODE_Msk = 0xf
	// Normal mode
	USART_MR_USART_MODE_NORMAL = 0x0
	// RS485
	USART_MR_USART_MODE_RS485 = 0x1
	// Hardware Handshaking
	USART_MR_USART_MODE_HW_HANDSHAKING = 0x2
	// IS07816 Protocol: T = 0
	USART_MR_USART_MODE_IS07816_T_0 = 0x4
	// IS07816 Protocol: T = 1
	USART_MR_USART_MODE_IS07816_T_1 = 0x6
	// IrDA
	USART_MR_USART_MODE_IRDA = 0x8
	// SPI Master
	USART_MR_USART_MODE_SPI_MASTER = 0xe
	// SPI Slave
	USART_MR_USART_MODE_SPI_SLAVE = 0xf
	// Position of USCLKS field.
	USART_MR_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_USCLKS_Msk = 0x30
	// Master Clock MCK is selected
	USART_MR_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_CHRL_Msk = 0xc0
	// Character length is 5 bits
	USART_MR_CHRL_5_BIT = 0x0
	// Character length is 6 bits
	USART_MR_CHRL_6_BIT = 0x1
	// Character length is 7 bits
	USART_MR_CHRL_7_BIT = 0x2
	// Character length is 8 bits
	USART_MR_CHRL_8_BIT = 0x3
	// Position of SYNC field.
	USART_MR_SYNC_Pos = 0x8
	// Bit mask of SYNC field.
	USART_MR_SYNC_Msk = 0x100
	// Bit SYNC.
	USART_MR_SYNC = 0x100
	// Position of PAR field.
	USART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	USART_MR_PAR_Msk = 0xe00
	// Even parity
	USART_MR_PAR_EVEN = 0x0
	// Odd parity
	USART_MR_PAR_ODD = 0x1
	// Parity forced to 0 (Space)
	USART_MR_PAR_SPACE = 0x2
	// Parity forced to 1 (Mark)
	USART_MR_PAR_MARK = 0x3
	// No parity
	USART_MR_PAR_NO = 0x4
	// Multidrop mode
	USART_MR_PAR_MULTIDROP = 0x6
	// Position of NBSTOP field.
	USART_MR_NBSTOP_Pos = 0xc
	// Bit mask of NBSTOP field.
	USART_MR_NBSTOP_Msk = 0x3000
	// 1 stop bit
	USART_MR_NBSTOP_1_BIT = 0x0
	// 1.5 stop bit (SYNC = 0) or reserved (SYNC = 1)
	USART_MR_NBSTOP_1_5_BIT = 0x1
	// 2 stop bits
	USART_MR_NBSTOP_2_BIT = 0x2
	// Position of CHMODE field.
	USART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	USART_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	USART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo. Receiver input is connected to the TXD pin.
	USART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback. Transmitter output is connected to the Receiver Input.
	USART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback. RXD pin is internally connected to the TXD pin.
	USART_MR_CHMODE_REMOTE_LOOPBACK = 0x3
	// Position of MSBF field.
	USART_MR_MSBF_Pos = 0x10
	// Bit mask of MSBF field.
	USART_MR_MSBF_Msk = 0x10000
	// Bit MSBF.
	USART_MR_MSBF = 0x10000
	// Position of MODE9 field.
	USART_MR_MODE9_Pos = 0x11
	// Bit mask of MODE9 field.
	USART_MR_MODE9_Msk = 0x20000
	// Bit MODE9.
	USART_MR_MODE9 = 0x20000
	// Position of CLKO field.
	USART_MR_CLKO_Pos = 0x12
	// Bit mask of CLKO field.
	USART_MR_CLKO_Msk = 0x40000
	// Bit CLKO.
	USART_MR_CLKO = 0x40000
	// Position of OVER field.
	USART_MR_OVER_Pos = 0x13
	// Bit mask of OVER field.
	USART_MR_OVER_Msk = 0x80000
	// Bit OVER.
	USART_MR_OVER = 0x80000
	// Position of INACK field.
	USART_MR_INACK_Pos = 0x14
	// Bit mask of INACK field.
	USART_MR_INACK_Msk = 0x100000
	// Bit INACK.
	USART_MR_INACK = 0x100000
	// Position of DSNACK field.
	USART_MR_DSNACK_Pos = 0x15
	// Bit mask of DSNACK field.
	USART_MR_DSNACK_Msk = 0x200000
	// Bit DSNACK.
	USART_MR_DSNACK = 0x200000
	// Position of INVDATA field.
	USART_MR_INVDATA_Pos = 0x17
	// Bit mask of INVDATA field.
	USART_MR_INVDATA_Msk = 0x800000
	// Bit INVDATA.
	USART_MR_INVDATA = 0x800000
	// Position of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Pos = 0x18
	// Bit mask of MAX_ITERATION field.
	USART_MR_MAX_ITERATION_Msk = 0x7000000
	// Position of FILTER field.
	USART_MR_FILTER_Pos = 0x1c
	// Bit mask of FILTER field.
	USART_MR_FILTER_Msk = 0x10000000
	// Bit FILTER.
	USART_MR_FILTER = 0x10000000

	// MR_SPI_MODE: Mode Register
	// Position of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Pos = 0x0
	// Bit mask of USART_MODE field.
	USART_MR_SPI_MODE_USART_MODE_Msk = 0xf
	// SPI Master
	USART_MR_SPI_MODE_USART_MODE_SPI_MASTER = 0xe
	// SPI Slave
	USART_MR_SPI_MODE_USART_MODE_SPI_SLAVE = 0xf
	// Position of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Pos = 0x4
	// Bit mask of USCLKS field.
	USART_MR_SPI_MODE_USCLKS_Msk = 0x30
	// Master Clock MCK is selected
	USART_MR_SPI_MODE_USCLKS_MCK = 0x0
	// Internal Clock Divided MCK/DIV (DIV=8) is selected
	USART_MR_SPI_MODE_USCLKS_DIV = 0x1
	// Serial Clock SLK is selected
	USART_MR_SPI_MODE_USCLKS_SCK = 0x3
	// Position of CHRL field.
	USART_MR_SPI_MODE_CHRL_Pos = 0x6
	// Bit mask of CHRL field.
	USART_MR_SPI_MODE_CHRL_Msk = 0xc0
	// Character length is 8 bits
	USART_MR_SPI_MODE_CHRL_8_BIT = 0x3
	// Position of CPHA field.
	USART_MR_SPI_MODE_CPHA_Pos = 0x8
	// Bit mask of CPHA field.
	USART_MR_SPI_MODE_CPHA_Msk = 0x100
	// Bit CPHA.
	USART_MR_SPI_MODE_CPHA = 0x100
	// Position of CPOL field.
	USART_MR_SPI_MODE_CPOL_Pos = 0x10
	// Bit mask of CPOL field.
	USART_MR_SPI_MODE_CPOL_Msk = 0x10000
	// Bit CPOL.
	USART_MR_SPI_MODE_CPOL = 0x10000
	// Position of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Pos = 0x14
	// Bit mask of WRDBT field.
	USART_MR_SPI_MODE_WRDBT_Msk = 0x100000
	// Bit WRDBT.
	USART_MR_SPI_MODE_WRDBT = 0x100000

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IER_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IER_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IER_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IER_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IER_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IER_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IER_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IER_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IER_ENDTX = 0x10
	// Position of OVRE field.
	USART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_OVRE = 0x20
	// Position of FRAME field.
	USART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IER_FRAME = 0x40
	// Position of PARE field.
	USART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IER_PARE_Msk = 0x80
	// Bit PARE.
	USART_IER_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IER_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IER_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IER_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IER_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IER_ITER_Msk = 0x400
	// Bit ITER.
	USART_IER_ITER = 0x400
	// Position of TXBUFE field.
	USART_IER_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IER_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IER_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IER_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IER_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IER_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IER_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IER_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IER_NACK = 0x2000
	// Position of CTSIC field.
	USART_IER_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IER_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IER_CTSIC = 0x80000

	// IER_SPI_MODE: Interrupt Enable Register
	// Position of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IER_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IER_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IER_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IER_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IER_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IER_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IER_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IER_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IER_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IER_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IER_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IER_SPI_MODE_UNRE = 0x400

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IDR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IDR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IDR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IDR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IDR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IDR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IDR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IDR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IDR_ENDTX = 0x10
	// Position of OVRE field.
	USART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_OVRE = 0x20
	// Position of FRAME field.
	USART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IDR_FRAME = 0x40
	// Position of PARE field.
	USART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IDR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IDR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IDR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IDR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IDR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IDR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IDR_ITER = 0x400
	// Position of TXBUFE field.
	USART_IDR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IDR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IDR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IDR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IDR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IDR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IDR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IDR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IDR_NACK = 0x2000
	// Position of CTSIC field.
	USART_IDR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IDR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IDR_CTSIC = 0x80000

	// IDR_SPI_MODE: Interrupt Disable Register
	// Position of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IDR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IDR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IDR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IDR_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IDR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IDR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IDR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IDR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IDR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IDR_SPI_MODE_UNRE = 0x400

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_IMR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_IMR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_IMR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_IMR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_IMR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_IMR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_IMR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_IMR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_IMR_ENDTX = 0x10
	// Position of OVRE field.
	USART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_OVRE = 0x20
	// Position of FRAME field.
	USART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_IMR_FRAME = 0x40
	// Position of PARE field.
	USART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	USART_IMR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_IMR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_IMR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_IMR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_IMR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_IMR_ITER_Msk = 0x400
	// Bit ITER.
	USART_IMR_ITER = 0x400
	// Position of TXBUFE field.
	USART_IMR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_IMR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_IMR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_IMR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_IMR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_IMR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_IMR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_IMR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_IMR_NACK = 0x2000
	// Position of CTSIC field.
	USART_IMR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_IMR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_IMR_CTSIC = 0x80000

	// IMR_SPI_MODE: Interrupt Mask Register
	// Position of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_IMR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_IMR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_IMR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_IMR_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_IMR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_IMR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_IMR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_IMR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_IMR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_IMR_SPI_MODE_UNRE = 0x400

	// CSR: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_TXRDY = 0x2
	// Position of RXBRK field.
	USART_CSR_RXBRK_Pos = 0x2
	// Bit mask of RXBRK field.
	USART_CSR_RXBRK_Msk = 0x4
	// Bit RXBRK.
	USART_CSR_RXBRK = 0x4
	// Position of ENDRX field.
	USART_CSR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	USART_CSR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	USART_CSR_ENDRX = 0x8
	// Position of ENDTX field.
	USART_CSR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	USART_CSR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	USART_CSR_ENDTX = 0x10
	// Position of OVRE field.
	USART_CSR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_OVRE = 0x20
	// Position of FRAME field.
	USART_CSR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	USART_CSR_FRAME_Msk = 0x40
	// Bit FRAME.
	USART_CSR_FRAME = 0x40
	// Position of PARE field.
	USART_CSR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	USART_CSR_PARE_Msk = 0x80
	// Bit PARE.
	USART_CSR_PARE = 0x80
	// Position of TIMEOUT field.
	USART_CSR_TIMEOUT_Pos = 0x8
	// Bit mask of TIMEOUT field.
	USART_CSR_TIMEOUT_Msk = 0x100
	// Bit TIMEOUT.
	USART_CSR_TIMEOUT = 0x100
	// Position of TXEMPTY field.
	USART_CSR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_TXEMPTY = 0x200
	// Position of ITER field.
	USART_CSR_ITER_Pos = 0xa
	// Bit mask of ITER field.
	USART_CSR_ITER_Msk = 0x400
	// Bit ITER.
	USART_CSR_ITER = 0x400
	// Position of TXBUFE field.
	USART_CSR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	USART_CSR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	USART_CSR_TXBUFE = 0x800
	// Position of RXBUFF field.
	USART_CSR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	USART_CSR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	USART_CSR_RXBUFF = 0x1000
	// Position of NACK field.
	USART_CSR_NACK_Pos = 0xd
	// Bit mask of NACK field.
	USART_CSR_NACK_Msk = 0x2000
	// Bit NACK.
	USART_CSR_NACK = 0x2000
	// Position of CTSIC field.
	USART_CSR_CTSIC_Pos = 0x13
	// Bit mask of CTSIC field.
	USART_CSR_CTSIC_Msk = 0x80000
	// Bit CTSIC.
	USART_CSR_CTSIC = 0x80000
	// Position of CTS field.
	USART_CSR_CTS_Pos = 0x17
	// Bit mask of CTS field.
	USART_CSR_CTS_Msk = 0x800000
	// Bit CTS.
	USART_CSR_CTS = 0x800000

	// CSR_SPI_MODE: Channel Status Register
	// Position of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	USART_CSR_SPI_MODE_RXRDY_Msk = 0x1
	// Bit RXRDY.
	USART_CSR_SPI_MODE_RXRDY = 0x1
	// Position of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	USART_CSR_SPI_MODE_TXRDY_Msk = 0x2
	// Bit TXRDY.
	USART_CSR_SPI_MODE_TXRDY = 0x2
	// Position of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	USART_CSR_SPI_MODE_OVRE_Msk = 0x20
	// Bit OVRE.
	USART_CSR_SPI_MODE_OVRE = 0x20
	// Position of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	USART_CSR_SPI_MODE_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	USART_CSR_SPI_MODE_TXEMPTY = 0x200
	// Position of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Pos = 0xa
	// Bit mask of UNRE field.
	USART_CSR_SPI_MODE_UNRE_Msk = 0x400
	// Bit UNRE.
	USART_CSR_SPI_MODE_UNRE = 0x400

	// RHR: Receiver Holding Register
	// Position of RXCHR field.
	USART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	USART_RHR_RXCHR_Msk = 0x1ff
	// Position of RXSYNH field.
	USART_RHR_RXSYNH_Pos = 0xf
	// Bit mask of RXSYNH field.
	USART_RHR_RXSYNH_Msk = 0x8000
	// Bit RXSYNH.
	USART_RHR_RXSYNH = 0x8000

	// THR: Transmitter Holding Register
	// Position of TXCHR field.
	USART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	USART_THR_TXCHR_Msk = 0x1ff
	// Position of TXSYNH field.
	USART_THR_TXSYNH_Pos = 0xf
	// Bit mask of TXSYNH field.
	USART_THR_TXSYNH_Msk = 0x8000
	// Bit TXSYNH.
	USART_THR_TXSYNH = 0x8000

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	USART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	USART_BRGR_CD_Msk = 0xffff
	// Position of FP field.
	USART_BRGR_FP_Pos = 0x10
	// Bit mask of FP field.
	USART_BRGR_FP_Msk = 0x70000

	// RTOR: Receiver Time-out Register
	// Position of TO field.
	USART_RTOR_TO_Pos = 0x0
	// Bit mask of TO field.
	USART_RTOR_TO_Msk = 0xffff

	// TTGR: Transmitter Timeguard Register
	// Position of TG field.
	USART_TTGR_TG_Pos = 0x0
	// Bit mask of TG field.
	USART_TTGR_TG_Msk = 0xff

	// FIDI: FI DI Ratio Register
	// Position of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Pos = 0x0
	// Bit mask of FI_DI_RATIO field.
	USART_FIDI_FI_DI_RATIO_Msk = 0x7ff

	// NER: Number of Errors Register
	// Position of NB_ERRORS field.
	USART_NER_NB_ERRORS_Pos = 0x0
	// Bit mask of NB_ERRORS field.
	USART_NER_NB_ERRORS_Msk = 0xff

	// IF: IrDA Filter Register
	// Position of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Pos = 0x0
	// Bit mask of IRDA_FILTER field.
	USART_IF_IRDA_FILTER_Msk = 0xff

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	USART_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	USART_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	USART_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	USART_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	USART_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	USART_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	USART_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	USART_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	USART_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	USART_WPSR_WPVSRC_Msk = 0xffff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	USART_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	USART_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	USART_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	USART_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	USART_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	USART_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	USART_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	USART_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	USART_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	USART_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	USART_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	USART_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	USART_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	USART_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	USART_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	USART_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	USART_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	USART_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	USART_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	USART_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	USART_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	USART_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	USART_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	USART_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	USART_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	USART_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	USART_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	USART_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	USART_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	USART_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	USART_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	USART_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	USART_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	USART_PTSR_TXTEN = 0x100
)

// Constants for ADC: Analog-to-Digital Converter
const (
	// CR: Control Register
	// Position of SWRST field.
	ADC_CR_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ADC_CR_SWRST_Msk = 0x1
	// Bit SWRST.
	ADC_CR_SWRST = 0x1
	// Position of START field.
	ADC_CR_START_Pos = 0x1
	// Bit mask of START field.
	ADC_CR_START_Msk = 0x2
	// Bit START.
	ADC_CR_START = 0x2

	// MR: Mode Register
	// Position of TRGEN field.
	ADC_MR_TRGEN_Pos = 0x0
	// Bit mask of TRGEN field.
	ADC_MR_TRGEN_Msk = 0x1
	// Bit TRGEN.
	ADC_MR_TRGEN = 0x1
	// Hardware triggers are disabled. Starting a conversion is only possible by software.
	ADC_MR_TRGEN_DIS = 0x0
	// Hardware trigger selected by TRGSEL field is enabled.
	ADC_MR_TRGEN_EN = 0x1
	// Position of TRGSEL field.
	ADC_MR_TRGSEL_Pos = 0x1
	// Bit mask of TRGSEL field.
	ADC_MR_TRGSEL_Msk = 0xe
	// External trigger
	ADC_MR_TRGSEL_ADC_TRIG0 = 0x0
	// TIO Output of the Timer Counter Channel 0
	ADC_MR_TRGSEL_ADC_TRIG1 = 0x1
	// TIO Output of the Timer Counter Channel 1
	ADC_MR_TRGSEL_ADC_TRIG2 = 0x2
	// TIO Output of the Timer Counter Channel 2
	ADC_MR_TRGSEL_ADC_TRIG3 = 0x3
	// Position of LOWRES field.
	ADC_MR_LOWRES_Pos = 0x4
	// Bit mask of LOWRES field.
	ADC_MR_LOWRES_Msk = 0x10
	// Bit LOWRES.
	ADC_MR_LOWRES = 0x10
	// 10-bit resolution
	ADC_MR_LOWRES_BITS_10 = 0x0
	// 8-bit resolution
	ADC_MR_LOWRES_BITS_8 = 0x1
	// Position of SLEEP field.
	ADC_MR_SLEEP_Pos = 0x5
	// Bit mask of SLEEP field.
	ADC_MR_SLEEP_Msk = 0x20
	// Bit SLEEP.
	ADC_MR_SLEEP = 0x20
	// Normal Mode: The ADC Core and reference voltage circuitry are kept ON between conversions
	ADC_MR_SLEEP_NORMAL = 0x0
	// Sleep Mode: The ADC Core and reference voltage circuitry are OFF between conversions
	ADC_MR_SLEEP_SLEEP = 0x1
	// Position of FWUP field.
	ADC_MR_FWUP_Pos = 0x6
	// Bit mask of FWUP field.
	ADC_MR_FWUP_Msk = 0x40
	// Bit FWUP.
	ADC_MR_FWUP = 0x40
	// Normal Sleep Mode: The sleep mode is defined by the SLEEP bit
	ADC_MR_FWUP_OFF = 0x0
	// Fast Wake Up Sleep Mode: The Voltage reference is ON between conversions and ADC Core is OFF
	ADC_MR_FWUP_ON = 0x1
	// Position of FREERUN field.
	ADC_MR_FREERUN_Pos = 0x7
	// Bit mask of FREERUN field.
	ADC_MR_FREERUN_Msk = 0x80
	// Bit FREERUN.
	ADC_MR_FREERUN = 0x80
	// Normal Mode
	ADC_MR_FREERUN_OFF = 0x0
	// Free Run Mode: Never wait for any trigger.
	ADC_MR_FREERUN_ON = 0x1
	// Position of PRESCAL field.
	ADC_MR_PRESCAL_Pos = 0x8
	// Bit mask of PRESCAL field.
	ADC_MR_PRESCAL_Msk = 0xff00
	// Position of STARTUP field.
	ADC_MR_STARTUP_Pos = 0x10
	// Bit mask of STARTUP field.
	ADC_MR_STARTUP_Msk = 0xf0000
	// 0 periods of ADCClock
	ADC_MR_STARTUP_SUT0 = 0x0
	// 8 periods of ADCClock
	ADC_MR_STARTUP_SUT8 = 0x1
	// 16 periods of ADCClock
	ADC_MR_STARTUP_SUT16 = 0x2
	// 24 periods of ADCClock
	ADC_MR_STARTUP_SUT24 = 0x3
	// 64 periods of ADCClock
	ADC_MR_STARTUP_SUT64 = 0x4
	// 80 periods of ADCClock
	ADC_MR_STARTUP_SUT80 = 0x5
	// 96 periods of ADCClock
	ADC_MR_STARTUP_SUT96 = 0x6
	// 112 periods of ADCClock
	ADC_MR_STARTUP_SUT112 = 0x7
	// 512 periods of ADCClock
	ADC_MR_STARTUP_SUT512 = 0x8
	// 576 periods of ADCClock
	ADC_MR_STARTUP_SUT576 = 0x9
	// 640 periods of ADCClock
	ADC_MR_STARTUP_SUT640 = 0xa
	// 704 periods of ADCClock
	ADC_MR_STARTUP_SUT704 = 0xb
	// 768 periods of ADCClock
	ADC_MR_STARTUP_SUT768 = 0xc
	// 832 periods of ADCClock
	ADC_MR_STARTUP_SUT832 = 0xd
	// 896 periods of ADCClock
	ADC_MR_STARTUP_SUT896 = 0xe
	// 960 periods of ADCClock
	ADC_MR_STARTUP_SUT960 = 0xf
	// Position of TRACKTIM field.
	ADC_MR_TRACKTIM_Pos = 0x18
	// Bit mask of TRACKTIM field.
	ADC_MR_TRACKTIM_Msk = 0xf000000
	// Position of USEQ field.
	ADC_MR_USEQ_Pos = 0x1f
	// Bit mask of USEQ field.
	ADC_MR_USEQ_Msk = 0x80000000
	// Bit USEQ.
	ADC_MR_USEQ = 0x80000000
	// Normal Mode: The controller converts channels in a simple numeric order.
	ADC_MR_USEQ_NUM_ORDER = 0x0
	// User Sequence Mode: The sequence respects what is defined in ADC_SEQR1 and ADC_SEQR2 registers.
	ADC_MR_USEQ_REG_ORDER = 0x1

	// SEQR1: Channel Sequence Register 1
	// Position of USCH1 field.
	ADC_SEQR1_USCH1_Pos = 0x0
	// Bit mask of USCH1 field.
	ADC_SEQR1_USCH1_Msk = 0xf
	// Position of USCH2 field.
	ADC_SEQR1_USCH2_Pos = 0x4
	// Bit mask of USCH2 field.
	ADC_SEQR1_USCH2_Msk = 0xf0
	// Position of USCH3 field.
	ADC_SEQR1_USCH3_Pos = 0x8
	// Bit mask of USCH3 field.
	ADC_SEQR1_USCH3_Msk = 0xf00
	// Position of USCH4 field.
	ADC_SEQR1_USCH4_Pos = 0xc
	// Bit mask of USCH4 field.
	ADC_SEQR1_USCH4_Msk = 0xf000
	// Position of USCH5 field.
	ADC_SEQR1_USCH5_Pos = 0x10
	// Bit mask of USCH5 field.
	ADC_SEQR1_USCH5_Msk = 0xf0000
	// Position of USCH6 field.
	ADC_SEQR1_USCH6_Pos = 0x14
	// Bit mask of USCH6 field.
	ADC_SEQR1_USCH6_Msk = 0xf00000
	// Position of USCH7 field.
	ADC_SEQR1_USCH7_Pos = 0x18
	// Bit mask of USCH7 field.
	ADC_SEQR1_USCH7_Msk = 0xf000000
	// Position of USCH8 field.
	ADC_SEQR1_USCH8_Pos = 0x1c
	// Bit mask of USCH8 field.
	ADC_SEQR1_USCH8_Msk = 0xf0000000

	// SEQR2: Channel Sequence Register 2
	// Position of USCH9 field.
	ADC_SEQR2_USCH9_Pos = 0x0
	// Bit mask of USCH9 field.
	ADC_SEQR2_USCH9_Msk = 0xf
	// Position of USCH10 field.
	ADC_SEQR2_USCH10_Pos = 0x4
	// Bit mask of USCH10 field.
	ADC_SEQR2_USCH10_Msk = 0xf0
	// Position of USCH11 field.
	ADC_SEQR2_USCH11_Pos = 0x8
	// Bit mask of USCH11 field.
	ADC_SEQR2_USCH11_Msk = 0xf00
	// Position of USCH12 field.
	ADC_SEQR2_USCH12_Pos = 0xc
	// Bit mask of USCH12 field.
	ADC_SEQR2_USCH12_Msk = 0xf000
	// Position of USCH13 field.
	ADC_SEQR2_USCH13_Pos = 0x10
	// Bit mask of USCH13 field.
	ADC_SEQR2_USCH13_Msk = 0xf0000
	// Position of USCH14 field.
	ADC_SEQR2_USCH14_Pos = 0x14
	// Bit mask of USCH14 field.
	ADC_SEQR2_USCH14_Msk = 0xf00000
	// Position of USCH15 field.
	ADC_SEQR2_USCH15_Pos = 0x18
	// Bit mask of USCH15 field.
	ADC_SEQR2_USCH15_Msk = 0xf000000
	// Position of USCH16 field.
	ADC_SEQR2_USCH16_Pos = 0x1c
	// Bit mask of USCH16 field.
	ADC_SEQR2_USCH16_Msk = 0xf0000000

	// CHER: Channel Enable Register
	// Position of CH0 field.
	ADC_CHER_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHER_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHER_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHER_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHER_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHER_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHER_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHER_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHER_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHER_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHER_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHER_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHER_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHER_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHER_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHER_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHER_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHER_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHER_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHER_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHER_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHER_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHER_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHER_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHER_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHER_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHER_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHER_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHER_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHER_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHER_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHER_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHER_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHER_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHER_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHER_CH11 = 0x800
	// Position of CH12 field.
	ADC_CHER_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	ADC_CHER_CH12_Msk = 0x1000
	// Bit CH12.
	ADC_CHER_CH12 = 0x1000
	// Position of CH13 field.
	ADC_CHER_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	ADC_CHER_CH13_Msk = 0x2000
	// Bit CH13.
	ADC_CHER_CH13 = 0x2000
	// Position of CH14 field.
	ADC_CHER_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	ADC_CHER_CH14_Msk = 0x4000
	// Bit CH14.
	ADC_CHER_CH14 = 0x4000
	// Position of CH15 field.
	ADC_CHER_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	ADC_CHER_CH15_Msk = 0x8000
	// Bit CH15.
	ADC_CHER_CH15 = 0x8000

	// CHDR: Channel Disable Register
	// Position of CH0 field.
	ADC_CHDR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHDR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHDR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHDR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHDR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHDR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHDR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHDR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHDR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHDR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHDR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHDR_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHDR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHDR_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHDR_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHDR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHDR_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHDR_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHDR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHDR_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHDR_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHDR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHDR_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHDR_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHDR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHDR_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHDR_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHDR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHDR_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHDR_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHDR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHDR_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHDR_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHDR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHDR_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHDR_CH11 = 0x800
	// Position of CH12 field.
	ADC_CHDR_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	ADC_CHDR_CH12_Msk = 0x1000
	// Bit CH12.
	ADC_CHDR_CH12 = 0x1000
	// Position of CH13 field.
	ADC_CHDR_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	ADC_CHDR_CH13_Msk = 0x2000
	// Bit CH13.
	ADC_CHDR_CH13 = 0x2000
	// Position of CH14 field.
	ADC_CHDR_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	ADC_CHDR_CH14_Msk = 0x4000
	// Bit CH14.
	ADC_CHDR_CH14 = 0x4000
	// Position of CH15 field.
	ADC_CHDR_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	ADC_CHDR_CH15_Msk = 0x8000
	// Bit CH15.
	ADC_CHDR_CH15 = 0x8000

	// CHSR: Channel Status Register
	// Position of CH0 field.
	ADC_CHSR_CH0_Pos = 0x0
	// Bit mask of CH0 field.
	ADC_CHSR_CH0_Msk = 0x1
	// Bit CH0.
	ADC_CHSR_CH0 = 0x1
	// Position of CH1 field.
	ADC_CHSR_CH1_Pos = 0x1
	// Bit mask of CH1 field.
	ADC_CHSR_CH1_Msk = 0x2
	// Bit CH1.
	ADC_CHSR_CH1 = 0x2
	// Position of CH2 field.
	ADC_CHSR_CH2_Pos = 0x2
	// Bit mask of CH2 field.
	ADC_CHSR_CH2_Msk = 0x4
	// Bit CH2.
	ADC_CHSR_CH2 = 0x4
	// Position of CH3 field.
	ADC_CHSR_CH3_Pos = 0x3
	// Bit mask of CH3 field.
	ADC_CHSR_CH3_Msk = 0x8
	// Bit CH3.
	ADC_CHSR_CH3 = 0x8
	// Position of CH4 field.
	ADC_CHSR_CH4_Pos = 0x4
	// Bit mask of CH4 field.
	ADC_CHSR_CH4_Msk = 0x10
	// Bit CH4.
	ADC_CHSR_CH4 = 0x10
	// Position of CH5 field.
	ADC_CHSR_CH5_Pos = 0x5
	// Bit mask of CH5 field.
	ADC_CHSR_CH5_Msk = 0x20
	// Bit CH5.
	ADC_CHSR_CH5 = 0x20
	// Position of CH6 field.
	ADC_CHSR_CH6_Pos = 0x6
	// Bit mask of CH6 field.
	ADC_CHSR_CH6_Msk = 0x40
	// Bit CH6.
	ADC_CHSR_CH6 = 0x40
	// Position of CH7 field.
	ADC_CHSR_CH7_Pos = 0x7
	// Bit mask of CH7 field.
	ADC_CHSR_CH7_Msk = 0x80
	// Bit CH7.
	ADC_CHSR_CH7 = 0x80
	// Position of CH8 field.
	ADC_CHSR_CH8_Pos = 0x8
	// Bit mask of CH8 field.
	ADC_CHSR_CH8_Msk = 0x100
	// Bit CH8.
	ADC_CHSR_CH8 = 0x100
	// Position of CH9 field.
	ADC_CHSR_CH9_Pos = 0x9
	// Bit mask of CH9 field.
	ADC_CHSR_CH9_Msk = 0x200
	// Bit CH9.
	ADC_CHSR_CH9 = 0x200
	// Position of CH10 field.
	ADC_CHSR_CH10_Pos = 0xa
	// Bit mask of CH10 field.
	ADC_CHSR_CH10_Msk = 0x400
	// Bit CH10.
	ADC_CHSR_CH10 = 0x400
	// Position of CH11 field.
	ADC_CHSR_CH11_Pos = 0xb
	// Bit mask of CH11 field.
	ADC_CHSR_CH11_Msk = 0x800
	// Bit CH11.
	ADC_CHSR_CH11 = 0x800
	// Position of CH12 field.
	ADC_CHSR_CH12_Pos = 0xc
	// Bit mask of CH12 field.
	ADC_CHSR_CH12_Msk = 0x1000
	// Bit CH12.
	ADC_CHSR_CH12 = 0x1000
	// Position of CH13 field.
	ADC_CHSR_CH13_Pos = 0xd
	// Bit mask of CH13 field.
	ADC_CHSR_CH13_Msk = 0x2000
	// Bit CH13.
	ADC_CHSR_CH13 = 0x2000
	// Position of CH14 field.
	ADC_CHSR_CH14_Pos = 0xe
	// Bit mask of CH14 field.
	ADC_CHSR_CH14_Msk = 0x4000
	// Bit CH14.
	ADC_CHSR_CH14 = 0x4000
	// Position of CH15 field.
	ADC_CHSR_CH15_Pos = 0xf
	// Bit mask of CH15 field.
	ADC_CHSR_CH15_Msk = 0x8000
	// Bit CH15.
	ADC_CHSR_CH15 = 0x8000

	// LCDR: Last Converted Data Register
	// Position of LDATA field.
	ADC_LCDR_LDATA_Pos = 0x0
	// Bit mask of LDATA field.
	ADC_LCDR_LDATA_Msk = 0xfff
	// Position of CHNB field.
	ADC_LCDR_CHNB_Pos = 0xc
	// Bit mask of CHNB field.
	ADC_LCDR_CHNB_Msk = 0xf000

	// IER: Interrupt Enable Register
	// Position of EOC0 field.
	ADC_IER_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IER_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IER_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IER_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IER_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IER_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IER_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IER_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IER_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IER_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IER_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IER_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IER_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IER_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IER_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IER_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IER_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IER_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IER_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IER_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IER_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IER_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IER_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IER_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IER_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IER_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IER_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IER_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IER_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IER_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IER_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IER_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IER_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IER_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IER_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IER_EOC11 = 0x800
	// Position of EOC12 field.
	ADC_IER_EOC12_Pos = 0xc
	// Bit mask of EOC12 field.
	ADC_IER_EOC12_Msk = 0x1000
	// Bit EOC12.
	ADC_IER_EOC12 = 0x1000
	// Position of EOC13 field.
	ADC_IER_EOC13_Pos = 0xd
	// Bit mask of EOC13 field.
	ADC_IER_EOC13_Msk = 0x2000
	// Bit EOC13.
	ADC_IER_EOC13 = 0x2000
	// Position of EOC14 field.
	ADC_IER_EOC14_Pos = 0xe
	// Bit mask of EOC14 field.
	ADC_IER_EOC14_Msk = 0x4000
	// Bit EOC14.
	ADC_IER_EOC14 = 0x4000
	// Position of EOC15 field.
	ADC_IER_EOC15_Pos = 0xf
	// Bit mask of EOC15 field.
	ADC_IER_EOC15_Msk = 0x8000
	// Bit EOC15.
	ADC_IER_EOC15 = 0x8000
	// Position of DRDY field.
	ADC_IER_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IER_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IER_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IER_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IER_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IER_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IER_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IER_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IER_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_IER_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_IER_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_IER_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_IER_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_IER_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_IER_RXBUFF = 0x10000000

	// IDR: Interrupt Disable Register
	// Position of EOC0 field.
	ADC_IDR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IDR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IDR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IDR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IDR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IDR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IDR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IDR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IDR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IDR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IDR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IDR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IDR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IDR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IDR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IDR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IDR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IDR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IDR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IDR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IDR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IDR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IDR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IDR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IDR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IDR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IDR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IDR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IDR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IDR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IDR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IDR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IDR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IDR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IDR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IDR_EOC11 = 0x800
	// Position of EOC12 field.
	ADC_IDR_EOC12_Pos = 0xc
	// Bit mask of EOC12 field.
	ADC_IDR_EOC12_Msk = 0x1000
	// Bit EOC12.
	ADC_IDR_EOC12 = 0x1000
	// Position of EOC13 field.
	ADC_IDR_EOC13_Pos = 0xd
	// Bit mask of EOC13 field.
	ADC_IDR_EOC13_Msk = 0x2000
	// Bit EOC13.
	ADC_IDR_EOC13 = 0x2000
	// Position of EOC14 field.
	ADC_IDR_EOC14_Pos = 0xe
	// Bit mask of EOC14 field.
	ADC_IDR_EOC14_Msk = 0x4000
	// Bit EOC14.
	ADC_IDR_EOC14 = 0x4000
	// Position of EOC15 field.
	ADC_IDR_EOC15_Pos = 0xf
	// Bit mask of EOC15 field.
	ADC_IDR_EOC15_Msk = 0x8000
	// Bit EOC15.
	ADC_IDR_EOC15 = 0x8000
	// Position of DRDY field.
	ADC_IDR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IDR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IDR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IDR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IDR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IDR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IDR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IDR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IDR_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_IDR_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_IDR_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_IDR_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_IDR_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_IDR_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_IDR_RXBUFF = 0x10000000

	// IMR: Interrupt Mask Register
	// Position of EOC0 field.
	ADC_IMR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_IMR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_IMR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_IMR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_IMR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_IMR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_IMR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_IMR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_IMR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_IMR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_IMR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_IMR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_IMR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_IMR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_IMR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_IMR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_IMR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_IMR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_IMR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_IMR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_IMR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_IMR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_IMR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_IMR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_IMR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_IMR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_IMR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_IMR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_IMR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_IMR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_IMR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_IMR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_IMR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_IMR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_IMR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_IMR_EOC11 = 0x800
	// Position of EOC12 field.
	ADC_IMR_EOC12_Pos = 0xc
	// Bit mask of EOC12 field.
	ADC_IMR_EOC12_Msk = 0x1000
	// Bit EOC12.
	ADC_IMR_EOC12 = 0x1000
	// Position of EOC13 field.
	ADC_IMR_EOC13_Pos = 0xd
	// Bit mask of EOC13 field.
	ADC_IMR_EOC13_Msk = 0x2000
	// Bit EOC13.
	ADC_IMR_EOC13 = 0x2000
	// Position of EOC14 field.
	ADC_IMR_EOC14_Pos = 0xe
	// Bit mask of EOC14 field.
	ADC_IMR_EOC14_Msk = 0x4000
	// Bit EOC14.
	ADC_IMR_EOC14 = 0x4000
	// Position of EOC15 field.
	ADC_IMR_EOC15_Pos = 0xf
	// Bit mask of EOC15 field.
	ADC_IMR_EOC15_Msk = 0x8000
	// Bit EOC15.
	ADC_IMR_EOC15 = 0x8000
	// Position of DRDY field.
	ADC_IMR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_IMR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_IMR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_IMR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_IMR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_IMR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_IMR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_IMR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_IMR_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_IMR_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_IMR_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_IMR_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_IMR_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_IMR_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_IMR_RXBUFF = 0x10000000

	// ISR: Interrupt Status Register
	// Position of EOC0 field.
	ADC_ISR_EOC0_Pos = 0x0
	// Bit mask of EOC0 field.
	ADC_ISR_EOC0_Msk = 0x1
	// Bit EOC0.
	ADC_ISR_EOC0 = 0x1
	// Position of EOC1 field.
	ADC_ISR_EOC1_Pos = 0x1
	// Bit mask of EOC1 field.
	ADC_ISR_EOC1_Msk = 0x2
	// Bit EOC1.
	ADC_ISR_EOC1 = 0x2
	// Position of EOC2 field.
	ADC_ISR_EOC2_Pos = 0x2
	// Bit mask of EOC2 field.
	ADC_ISR_EOC2_Msk = 0x4
	// Bit EOC2.
	ADC_ISR_EOC2 = 0x4
	// Position of EOC3 field.
	ADC_ISR_EOC3_Pos = 0x3
	// Bit mask of EOC3 field.
	ADC_ISR_EOC3_Msk = 0x8
	// Bit EOC3.
	ADC_ISR_EOC3 = 0x8
	// Position of EOC4 field.
	ADC_ISR_EOC4_Pos = 0x4
	// Bit mask of EOC4 field.
	ADC_ISR_EOC4_Msk = 0x10
	// Bit EOC4.
	ADC_ISR_EOC4 = 0x10
	// Position of EOC5 field.
	ADC_ISR_EOC5_Pos = 0x5
	// Bit mask of EOC5 field.
	ADC_ISR_EOC5_Msk = 0x20
	// Bit EOC5.
	ADC_ISR_EOC5 = 0x20
	// Position of EOC6 field.
	ADC_ISR_EOC6_Pos = 0x6
	// Bit mask of EOC6 field.
	ADC_ISR_EOC6_Msk = 0x40
	// Bit EOC6.
	ADC_ISR_EOC6 = 0x40
	// Position of EOC7 field.
	ADC_ISR_EOC7_Pos = 0x7
	// Bit mask of EOC7 field.
	ADC_ISR_EOC7_Msk = 0x80
	// Bit EOC7.
	ADC_ISR_EOC7 = 0x80
	// Position of EOC8 field.
	ADC_ISR_EOC8_Pos = 0x8
	// Bit mask of EOC8 field.
	ADC_ISR_EOC8_Msk = 0x100
	// Bit EOC8.
	ADC_ISR_EOC8 = 0x100
	// Position of EOC9 field.
	ADC_ISR_EOC9_Pos = 0x9
	// Bit mask of EOC9 field.
	ADC_ISR_EOC9_Msk = 0x200
	// Bit EOC9.
	ADC_ISR_EOC9 = 0x200
	// Position of EOC10 field.
	ADC_ISR_EOC10_Pos = 0xa
	// Bit mask of EOC10 field.
	ADC_ISR_EOC10_Msk = 0x400
	// Bit EOC10.
	ADC_ISR_EOC10 = 0x400
	// Position of EOC11 field.
	ADC_ISR_EOC11_Pos = 0xb
	// Bit mask of EOC11 field.
	ADC_ISR_EOC11_Msk = 0x800
	// Bit EOC11.
	ADC_ISR_EOC11 = 0x800
	// Position of EOC12 field.
	ADC_ISR_EOC12_Pos = 0xc
	// Bit mask of EOC12 field.
	ADC_ISR_EOC12_Msk = 0x1000
	// Bit EOC12.
	ADC_ISR_EOC12 = 0x1000
	// Position of EOC13 field.
	ADC_ISR_EOC13_Pos = 0xd
	// Bit mask of EOC13 field.
	ADC_ISR_EOC13_Msk = 0x2000
	// Bit EOC13.
	ADC_ISR_EOC13 = 0x2000
	// Position of EOC14 field.
	ADC_ISR_EOC14_Pos = 0xe
	// Bit mask of EOC14 field.
	ADC_ISR_EOC14_Msk = 0x4000
	// Bit EOC14.
	ADC_ISR_EOC14 = 0x4000
	// Position of EOC15 field.
	ADC_ISR_EOC15_Pos = 0xf
	// Bit mask of EOC15 field.
	ADC_ISR_EOC15_Msk = 0x8000
	// Bit EOC15.
	ADC_ISR_EOC15 = 0x8000
	// Position of DRDY field.
	ADC_ISR_DRDY_Pos = 0x18
	// Bit mask of DRDY field.
	ADC_ISR_DRDY_Msk = 0x1000000
	// Bit DRDY.
	ADC_ISR_DRDY = 0x1000000
	// Position of GOVRE field.
	ADC_ISR_GOVRE_Pos = 0x19
	// Bit mask of GOVRE field.
	ADC_ISR_GOVRE_Msk = 0x2000000
	// Bit GOVRE.
	ADC_ISR_GOVRE = 0x2000000
	// Position of COMPE field.
	ADC_ISR_COMPE_Pos = 0x1a
	// Bit mask of COMPE field.
	ADC_ISR_COMPE_Msk = 0x4000000
	// Bit COMPE.
	ADC_ISR_COMPE = 0x4000000
	// Position of ENDRX field.
	ADC_ISR_ENDRX_Pos = 0x1b
	// Bit mask of ENDRX field.
	ADC_ISR_ENDRX_Msk = 0x8000000
	// Bit ENDRX.
	ADC_ISR_ENDRX = 0x8000000
	// Position of RXBUFF field.
	ADC_ISR_RXBUFF_Pos = 0x1c
	// Bit mask of RXBUFF field.
	ADC_ISR_RXBUFF_Msk = 0x10000000
	// Bit RXBUFF.
	ADC_ISR_RXBUFF = 0x10000000

	// OVER: Overrun Status Register
	// Position of OVRE0 field.
	ADC_OVER_OVRE0_Pos = 0x0
	// Bit mask of OVRE0 field.
	ADC_OVER_OVRE0_Msk = 0x1
	// Bit OVRE0.
	ADC_OVER_OVRE0 = 0x1
	// Position of OVRE1 field.
	ADC_OVER_OVRE1_Pos = 0x1
	// Bit mask of OVRE1 field.
	ADC_OVER_OVRE1_Msk = 0x2
	// Bit OVRE1.
	ADC_OVER_OVRE1 = 0x2
	// Position of OVRE2 field.
	ADC_OVER_OVRE2_Pos = 0x2
	// Bit mask of OVRE2 field.
	ADC_OVER_OVRE2_Msk = 0x4
	// Bit OVRE2.
	ADC_OVER_OVRE2 = 0x4
	// Position of OVRE3 field.
	ADC_OVER_OVRE3_Pos = 0x3
	// Bit mask of OVRE3 field.
	ADC_OVER_OVRE3_Msk = 0x8
	// Bit OVRE3.
	ADC_OVER_OVRE3 = 0x8
	// Position of OVRE4 field.
	ADC_OVER_OVRE4_Pos = 0x4
	// Bit mask of OVRE4 field.
	ADC_OVER_OVRE4_Msk = 0x10
	// Bit OVRE4.
	ADC_OVER_OVRE4 = 0x10
	// Position of OVRE5 field.
	ADC_OVER_OVRE5_Pos = 0x5
	// Bit mask of OVRE5 field.
	ADC_OVER_OVRE5_Msk = 0x20
	// Bit OVRE5.
	ADC_OVER_OVRE5 = 0x20
	// Position of OVRE6 field.
	ADC_OVER_OVRE6_Pos = 0x6
	// Bit mask of OVRE6 field.
	ADC_OVER_OVRE6_Msk = 0x40
	// Bit OVRE6.
	ADC_OVER_OVRE6 = 0x40
	// Position of OVRE7 field.
	ADC_OVER_OVRE7_Pos = 0x7
	// Bit mask of OVRE7 field.
	ADC_OVER_OVRE7_Msk = 0x80
	// Bit OVRE7.
	ADC_OVER_OVRE7 = 0x80
	// Position of OVRE8 field.
	ADC_OVER_OVRE8_Pos = 0x8
	// Bit mask of OVRE8 field.
	ADC_OVER_OVRE8_Msk = 0x100
	// Bit OVRE8.
	ADC_OVER_OVRE8 = 0x100
	// Position of OVRE9 field.
	ADC_OVER_OVRE9_Pos = 0x9
	// Bit mask of OVRE9 field.
	ADC_OVER_OVRE9_Msk = 0x200
	// Bit OVRE9.
	ADC_OVER_OVRE9 = 0x200
	// Position of OVRE10 field.
	ADC_OVER_OVRE10_Pos = 0xa
	// Bit mask of OVRE10 field.
	ADC_OVER_OVRE10_Msk = 0x400
	// Bit OVRE10.
	ADC_OVER_OVRE10 = 0x400
	// Position of OVRE11 field.
	ADC_OVER_OVRE11_Pos = 0xb
	// Bit mask of OVRE11 field.
	ADC_OVER_OVRE11_Msk = 0x800
	// Bit OVRE11.
	ADC_OVER_OVRE11 = 0x800
	// Position of OVRE12 field.
	ADC_OVER_OVRE12_Pos = 0xc
	// Bit mask of OVRE12 field.
	ADC_OVER_OVRE12_Msk = 0x1000
	// Bit OVRE12.
	ADC_OVER_OVRE12 = 0x1000
	// Position of OVRE13 field.
	ADC_OVER_OVRE13_Pos = 0xd
	// Bit mask of OVRE13 field.
	ADC_OVER_OVRE13_Msk = 0x2000
	// Bit OVRE13.
	ADC_OVER_OVRE13 = 0x2000
	// Position of OVRE14 field.
	ADC_OVER_OVRE14_Pos = 0xe
	// Bit mask of OVRE14 field.
	ADC_OVER_OVRE14_Msk = 0x4000
	// Bit OVRE14.
	ADC_OVER_OVRE14 = 0x4000
	// Position of OVRE15 field.
	ADC_OVER_OVRE15_Pos = 0xf
	// Bit mask of OVRE15 field.
	ADC_OVER_OVRE15_Msk = 0x8000
	// Bit OVRE15.
	ADC_OVER_OVRE15 = 0x8000

	// EMR: Extended Mode Register
	// Position of CMPMODE field.
	ADC_EMR_CMPMODE_Pos = 0x0
	// Bit mask of CMPMODE field.
	ADC_EMR_CMPMODE_Msk = 0x3
	// Generates an event when the converted data is lower than the low threshold of the window.
	ADC_EMR_CMPMODE_LOW = 0x0
	// Generates an event when the converted data is higher than the high threshold of the window.
	ADC_EMR_CMPMODE_HIGH = 0x1
	// Generates an event when the converted data is in the comparison window.
	ADC_EMR_CMPMODE_IN = 0x2
	// Generates an event when the converted data is out of the comparison window.
	ADC_EMR_CMPMODE_OUT = 0x3
	// Position of CMPSEL field.
	ADC_EMR_CMPSEL_Pos = 0x4
	// Bit mask of CMPSEL field.
	ADC_EMR_CMPSEL_Msk = 0xf0
	// Position of CMPALL field.
	ADC_EMR_CMPALL_Pos = 0x9
	// Bit mask of CMPALL field.
	ADC_EMR_CMPALL_Msk = 0x200
	// Bit CMPALL.
	ADC_EMR_CMPALL = 0x200
	// Position of TAG field.
	ADC_EMR_TAG_Pos = 0x18
	// Bit mask of TAG field.
	ADC_EMR_TAG_Msk = 0x1000000
	// Bit TAG.
	ADC_EMR_TAG = 0x1000000

	// CWR: Compare Window Register
	// Position of LOWTHRES field.
	ADC_CWR_LOWTHRES_Pos = 0x0
	// Bit mask of LOWTHRES field.
	ADC_CWR_LOWTHRES_Msk = 0xfff
	// Position of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Pos = 0x10
	// Bit mask of HIGHTHRES field.
	ADC_CWR_HIGHTHRES_Msk = 0xfff0000

	// CDR: Channel Data Register
	// Position of DATA field.
	ADC_CDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	ADC_CDR_DATA_Msk = 0xfff

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	ADC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	ADC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	ADC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	ADC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	ADC_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPVS field.
	ADC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	ADC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	ADC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	ADC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	ADC_WPSR_WPVSRC_Msk = 0xffff00

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	ADC_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	ADC_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	ADC_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	ADC_RCR_RXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	ADC_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	ADC_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	ADC_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	ADC_RNCR_RXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	ADC_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	ADC_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	ADC_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	ADC_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	ADC_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	ADC_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	ADC_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	ADC_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	ADC_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	ADC_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	ADC_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	ADC_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	ADC_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	ADC_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	ADC_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	ADC_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	ADC_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	ADC_PTSR_TXTEN = 0x100
)

// Constants for DACC: Digital-to-Analog Converter Controller
const (
	// CR: Control Register
	// Position of SWRST field.
	DACC_CR_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DACC_CR_SWRST_Msk = 0x1
	// Bit SWRST.
	DACC_CR_SWRST = 0x1

	// MR: Mode Register
	// Position of TRGEN field.
	DACC_MR_TRGEN_Pos = 0x0
	// Bit mask of TRGEN field.
	DACC_MR_TRGEN_Msk = 0x1
	// Bit TRGEN.
	DACC_MR_TRGEN = 0x1
	// Position of TRGSEL field.
	DACC_MR_TRGSEL_Pos = 0x1
	// Bit mask of TRGSEL field.
	DACC_MR_TRGSEL_Msk = 0xe
	// External trigger
	DACC_MR_TRGSEL_TRGSEL0 = 0x0
	// TIO Output of the Timer Counter Channel 0
	DACC_MR_TRGSEL_TRGSEL1 = 0x1
	// TIO Output of the Timer Counter Channel 1
	DACC_MR_TRGSEL_TRGSEL2 = 0x2
	// TIO Output of the Timer Counter Channel 2
	DACC_MR_TRGSEL_TRGSEL3 = 0x3
	// Position of DACEN field.
	DACC_MR_DACEN_Pos = 0x4
	// Bit mask of DACEN field.
	DACC_MR_DACEN_Msk = 0x10
	// Bit DACEN.
	DACC_MR_DACEN = 0x10
	// Position of WORD field.
	DACC_MR_WORD_Pos = 0x5
	// Bit mask of WORD field.
	DACC_MR_WORD_Msk = 0x20
	// Bit WORD.
	DACC_MR_WORD = 0x20
	// Position of STARTUP field.
	DACC_MR_STARTUP_Pos = 0x8
	// Bit mask of STARTUP field.
	DACC_MR_STARTUP_Msk = 0xff00
	// Position of CLKDIV field.
	DACC_MR_CLKDIV_Pos = 0x10
	// Bit mask of CLKDIV field.
	DACC_MR_CLKDIV_Msk = 0xffff0000

	// CDR: Conversion Data Register
	// Position of DATA field.
	DACC_CDR_DATA_Pos = 0x0
	// Bit mask of DATA field.
	DACC_CDR_DATA_Msk = 0xffffffff

	// IER: Interrupt Enable Register
	// Position of TXRDY field.
	DACC_IER_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	DACC_IER_TXRDY_Msk = 0x1
	// Bit TXRDY.
	DACC_IER_TXRDY = 0x1
	// Position of ENDTX field.
	DACC_IER_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	DACC_IER_ENDTX_Msk = 0x2
	// Bit ENDTX.
	DACC_IER_ENDTX = 0x2
	// Position of TXBUFE field.
	DACC_IER_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	DACC_IER_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	DACC_IER_TXBUFE = 0x4

	// IDR: Interrupt Disable Register
	// Position of TXRDY field.
	DACC_IDR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	DACC_IDR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	DACC_IDR_TXRDY = 0x1
	// Position of ENDTX field.
	DACC_IDR_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	DACC_IDR_ENDTX_Msk = 0x2
	// Bit ENDTX.
	DACC_IDR_ENDTX = 0x2
	// Position of TXBUFE field.
	DACC_IDR_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	DACC_IDR_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	DACC_IDR_TXBUFE = 0x4

	// IMR: Interrupt Mask Register
	// Position of TXRDY field.
	DACC_IMR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	DACC_IMR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	DACC_IMR_TXRDY = 0x1
	// Position of ENDTX field.
	DACC_IMR_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	DACC_IMR_ENDTX_Msk = 0x2
	// Bit ENDTX.
	DACC_IMR_ENDTX = 0x2
	// Position of TXBUFE field.
	DACC_IMR_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	DACC_IMR_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	DACC_IMR_TXBUFE = 0x4

	// ISR: Interrupt Status Register
	// Position of TXRDY field.
	DACC_ISR_TXRDY_Pos = 0x0
	// Bit mask of TXRDY field.
	DACC_ISR_TXRDY_Msk = 0x1
	// Bit TXRDY.
	DACC_ISR_TXRDY = 0x1
	// Position of ENDTX field.
	DACC_ISR_ENDTX_Pos = 0x1
	// Bit mask of ENDTX field.
	DACC_ISR_ENDTX_Msk = 0x2
	// Bit ENDTX.
	DACC_ISR_ENDTX = 0x2
	// Position of TXBUFE field.
	DACC_ISR_TXBUFE_Pos = 0x2
	// Bit mask of TXBUFE field.
	DACC_ISR_TXBUFE_Msk = 0x4
	// Bit TXBUFE.
	DACC_ISR_TXBUFE = 0x4

	// WPMR: Write Protect Mode Register
	// Position of WPEN field.
	DACC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	DACC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	DACC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	DACC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	DACC_WPMR_WPKEY_Msk = 0xffffff00

	// WPSR: Write Protect Status Register
	// Position of WPROTERR field.
	DACC_WPSR_WPROTERR_Pos = 0x0
	// Bit mask of WPROTERR field.
	DACC_WPSR_WPROTERR_Msk = 0x1
	// Bit WPROTERR.
	DACC_WPSR_WPROTERR = 0x1
	// Position of WPROTADDR field.
	DACC_WPSR_WPROTADDR_Pos = 0x8
	// Bit mask of WPROTADDR field.
	DACC_WPSR_WPROTADDR_Msk = 0xff00

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	DACC_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	DACC_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	DACC_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	DACC_TCR_TXCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	DACC_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	DACC_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	DACC_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	DACC_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	DACC_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	DACC_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	DACC_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	DACC_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	DACC_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	DACC_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	DACC_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	DACC_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	DACC_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	DACC_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	DACC_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	DACC_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	DACC_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	DACC_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	DACC_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	DACC_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	DACC_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	DACC_PTSR_TXTEN = 0x100
)

// Constants for MATRIX: AHB Bus Matrix
const (
	// MATRIX_MCFG: Master Configuration Register
	// Position of ULBT field.
	MATRIX_MATRIX_MCFG_ULBT_Pos = 0x0
	// Bit mask of ULBT field.
	MATRIX_MATRIX_MCFG_ULBT_Msk = 0x7

	// MATRIX_SCFG: Slave Configuration Register
	// Position of SLOT_CYCLE field.
	MATRIX_MATRIX_SCFG_SLOT_CYCLE_Pos = 0x0
	// Bit mask of SLOT_CYCLE field.
	MATRIX_MATRIX_SCFG_SLOT_CYCLE_Msk = 0xff
	// Position of DEFMSTR_TYPE field.
	MATRIX_MATRIX_SCFG_DEFMSTR_TYPE_Pos = 0x10
	// Bit mask of DEFMSTR_TYPE field.
	MATRIX_MATRIX_SCFG_DEFMSTR_TYPE_Msk = 0x30000
	// Position of FIXED_DEFMSTR field.
	MATRIX_MATRIX_SCFG_FIXED_DEFMSTR_Pos = 0x12
	// Bit mask of FIXED_DEFMSTR field.
	MATRIX_MATRIX_SCFG_FIXED_DEFMSTR_Msk = 0x1c0000
	// Position of ARBT field.
	MATRIX_MATRIX_SCFG_ARBT_Pos = 0x18
	// Bit mask of ARBT field.
	MATRIX_MATRIX_SCFG_ARBT_Msk = 0x3000000

	// MATRIX_PRAS0: Priority Register A for Slave 0
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS0_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS0_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS0_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS0_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS0_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS0_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS0_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS0_M3PR_Msk = 0x3000

	// MATRIX_PRAS1: Priority Register A for Slave 1
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS1_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS1_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS1_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS1_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS1_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS1_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS1_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS1_M3PR_Msk = 0x3000

	// MATRIX_PRAS2: Priority Register A for Slave 2
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS2_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS2_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS2_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS2_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS2_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS2_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS2_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS2_M3PR_Msk = 0x3000

	// MATRIX_PRAS3: Priority Register A for Slave 3
	// Position of M0PR field.
	MATRIX_MATRIX_PRAS3_M0PR_Pos = 0x0
	// Bit mask of M0PR field.
	MATRIX_MATRIX_PRAS3_M0PR_Msk = 0x3
	// Position of M1PR field.
	MATRIX_MATRIX_PRAS3_M1PR_Pos = 0x4
	// Bit mask of M1PR field.
	MATRIX_MATRIX_PRAS3_M1PR_Msk = 0x30
	// Position of M2PR field.
	MATRIX_MATRIX_PRAS3_M2PR_Pos = 0x8
	// Bit mask of M2PR field.
	MATRIX_MATRIX_PRAS3_M2PR_Msk = 0x300
	// Position of M3PR field.
	MATRIX_MATRIX_PRAS3_M3PR_Pos = 0xc
	// Bit mask of M3PR field.
	MATRIX_MATRIX_PRAS3_M3PR_Msk = 0x3000

	// CCFG_SYSIO: System I/O Configuration register
	// Position of SYSIO4 field.
	MATRIX_CCFG_SYSIO_SYSIO4_Pos = 0x4
	// Bit mask of SYSIO4 field.
	MATRIX_CCFG_SYSIO_SYSIO4_Msk = 0x10
	// Bit SYSIO4.
	MATRIX_CCFG_SYSIO_SYSIO4 = 0x10
	// Position of SYSIO5 field.
	MATRIX_CCFG_SYSIO_SYSIO5_Pos = 0x5
	// Bit mask of SYSIO5 field.
	MATRIX_CCFG_SYSIO_SYSIO5_Msk = 0x20
	// Bit SYSIO5.
	MATRIX_CCFG_SYSIO_SYSIO5 = 0x20
	// Position of SYSIO6 field.
	MATRIX_CCFG_SYSIO_SYSIO6_Pos = 0x6
	// Bit mask of SYSIO6 field.
	MATRIX_CCFG_SYSIO_SYSIO6_Msk = 0x40
	// Bit SYSIO6.
	MATRIX_CCFG_SYSIO_SYSIO6 = 0x40
	// Position of SYSIO7 field.
	MATRIX_CCFG_SYSIO_SYSIO7_Pos = 0x7
	// Bit mask of SYSIO7 field.
	MATRIX_CCFG_SYSIO_SYSIO7_Msk = 0x80
	// Bit SYSIO7.
	MATRIX_CCFG_SYSIO_SYSIO7 = 0x80
	// Position of SYSIO12 field.
	MATRIX_CCFG_SYSIO_SYSIO12_Pos = 0xc
	// Bit mask of SYSIO12 field.
	MATRIX_CCFG_SYSIO_SYSIO12_Msk = 0x1000
	// Bit SYSIO12.
	MATRIX_CCFG_SYSIO_SYSIO12 = 0x1000

	// MATRIX_WPMR: Write Protect Mode Register
	// Position of WPEN field.
	MATRIX_MATRIX_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	MATRIX_MATRIX_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	MATRIX_MATRIX_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	MATRIX_MATRIX_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	MATRIX_MATRIX_WPMR_WPKEY_Msk = 0xffffff00

	// MATRIX_WPSR: Write Protect Status Register
	// Position of WPVS field.
	MATRIX_MATRIX_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	MATRIX_MATRIX_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	MATRIX_MATRIX_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	MATRIX_MATRIX_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	MATRIX_MATRIX_WPSR_WPVSRC_Msk = 0xffff00
)

// Constants for PMC: Power Management Controller
const (
	// PMC_SCER: System Clock Enable Register
	// Position of PCK0 field.
	PMC_PMC_SCER_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCER_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCER_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCER_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCER_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCER_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCER_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCER_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCER_PCK2 = 0x400

	// PMC_SCDR: System Clock Disable Register
	// Position of PCK0 field.
	PMC_PMC_SCDR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCDR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCDR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCDR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCDR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCDR_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCDR_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCDR_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCDR_PCK2 = 0x400

	// PMC_SCSR: System Clock Status Register
	// Position of PCK0 field.
	PMC_PMC_SCSR_PCK0_Pos = 0x8
	// Bit mask of PCK0 field.
	PMC_PMC_SCSR_PCK0_Msk = 0x100
	// Bit PCK0.
	PMC_PMC_SCSR_PCK0 = 0x100
	// Position of PCK1 field.
	PMC_PMC_SCSR_PCK1_Pos = 0x9
	// Bit mask of PCK1 field.
	PMC_PMC_SCSR_PCK1_Msk = 0x200
	// Bit PCK1.
	PMC_PMC_SCSR_PCK1 = 0x200
	// Position of PCK2 field.
	PMC_PMC_SCSR_PCK2_Pos = 0xa
	// Bit mask of PCK2 field.
	PMC_PMC_SCSR_PCK2_Msk = 0x400
	// Bit PCK2.
	PMC_PMC_SCSR_PCK2 = 0x400

	// PMC_PCER0: Peripheral Clock Enable Register 0
	// Position of PID9 field.
	PMC_PMC_PCER0_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCER0_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCER0_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCER0_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCER0_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCER0_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCER0_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCER0_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCER0_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCER0_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCER0_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCER0_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCER0_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCER0_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCER0_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCER0_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCER0_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCER0_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCER0_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCER0_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCER0_PID15 = 0x8000
	// Position of PID19 field.
	PMC_PMC_PCER0_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCER0_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCER0_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCER0_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCER0_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCER0_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCER0_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCER0_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCER0_PID21 = 0x200000
	// Position of PID23 field.
	PMC_PMC_PCER0_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCER0_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCER0_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCER0_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCER0_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCER0_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCER0_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCER0_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCER0_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCER0_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCER0_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCER0_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCER0_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCER0_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCER0_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCER0_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCER0_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCER0_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCER0_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCER0_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCER0_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCER0_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCER0_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCER0_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCER0_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCER0_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCER0_PID31 = 0x80000000

	// PMC_PCDR0: Peripheral Clock Disable Register 0
	// Position of PID9 field.
	PMC_PMC_PCDR0_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCDR0_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCDR0_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCDR0_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCDR0_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCDR0_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCDR0_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCDR0_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCDR0_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCDR0_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCDR0_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCDR0_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCDR0_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCDR0_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCDR0_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCDR0_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCDR0_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCDR0_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCDR0_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCDR0_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCDR0_PID15 = 0x8000
	// Position of PID19 field.
	PMC_PMC_PCDR0_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCDR0_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCDR0_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCDR0_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCDR0_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCDR0_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCDR0_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCDR0_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCDR0_PID21 = 0x200000
	// Position of PID23 field.
	PMC_PMC_PCDR0_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCDR0_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCDR0_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCDR0_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCDR0_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCDR0_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCDR0_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCDR0_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCDR0_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCDR0_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCDR0_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCDR0_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCDR0_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCDR0_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCDR0_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCDR0_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCDR0_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCDR0_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCDR0_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCDR0_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCDR0_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCDR0_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCDR0_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCDR0_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCDR0_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCDR0_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCDR0_PID31 = 0x80000000

	// PMC_PCSR0: Peripheral Clock Status Register 0
	// Position of PID9 field.
	PMC_PMC_PCSR0_PID9_Pos = 0x9
	// Bit mask of PID9 field.
	PMC_PMC_PCSR0_PID9_Msk = 0x200
	// Bit PID9.
	PMC_PMC_PCSR0_PID9 = 0x200
	// Position of PID10 field.
	PMC_PMC_PCSR0_PID10_Pos = 0xa
	// Bit mask of PID10 field.
	PMC_PMC_PCSR0_PID10_Msk = 0x400
	// Bit PID10.
	PMC_PMC_PCSR0_PID10 = 0x400
	// Position of PID11 field.
	PMC_PMC_PCSR0_PID11_Pos = 0xb
	// Bit mask of PID11 field.
	PMC_PMC_PCSR0_PID11_Msk = 0x800
	// Bit PID11.
	PMC_PMC_PCSR0_PID11 = 0x800
	// Position of PID12 field.
	PMC_PMC_PCSR0_PID12_Pos = 0xc
	// Bit mask of PID12 field.
	PMC_PMC_PCSR0_PID12_Msk = 0x1000
	// Bit PID12.
	PMC_PMC_PCSR0_PID12 = 0x1000
	// Position of PID13 field.
	PMC_PMC_PCSR0_PID13_Pos = 0xd
	// Bit mask of PID13 field.
	PMC_PMC_PCSR0_PID13_Msk = 0x2000
	// Bit PID13.
	PMC_PMC_PCSR0_PID13 = 0x2000
	// Position of PID14 field.
	PMC_PMC_PCSR0_PID14_Pos = 0xe
	// Bit mask of PID14 field.
	PMC_PMC_PCSR0_PID14_Msk = 0x4000
	// Bit PID14.
	PMC_PMC_PCSR0_PID14 = 0x4000
	// Position of PID15 field.
	PMC_PMC_PCSR0_PID15_Pos = 0xf
	// Bit mask of PID15 field.
	PMC_PMC_PCSR0_PID15_Msk = 0x8000
	// Bit PID15.
	PMC_PMC_PCSR0_PID15 = 0x8000
	// Position of PID19 field.
	PMC_PMC_PCSR0_PID19_Pos = 0x13
	// Bit mask of PID19 field.
	PMC_PMC_PCSR0_PID19_Msk = 0x80000
	// Bit PID19.
	PMC_PMC_PCSR0_PID19 = 0x80000
	// Position of PID20 field.
	PMC_PMC_PCSR0_PID20_Pos = 0x14
	// Bit mask of PID20 field.
	PMC_PMC_PCSR0_PID20_Msk = 0x100000
	// Bit PID20.
	PMC_PMC_PCSR0_PID20 = 0x100000
	// Position of PID21 field.
	PMC_PMC_PCSR0_PID21_Pos = 0x15
	// Bit mask of PID21 field.
	PMC_PMC_PCSR0_PID21_Msk = 0x200000
	// Bit PID21.
	PMC_PMC_PCSR0_PID21 = 0x200000
	// Position of PID23 field.
	PMC_PMC_PCSR0_PID23_Pos = 0x17
	// Bit mask of PID23 field.
	PMC_PMC_PCSR0_PID23_Msk = 0x800000
	// Bit PID23.
	PMC_PMC_PCSR0_PID23 = 0x800000
	// Position of PID24 field.
	PMC_PMC_PCSR0_PID24_Pos = 0x18
	// Bit mask of PID24 field.
	PMC_PMC_PCSR0_PID24_Msk = 0x1000000
	// Bit PID24.
	PMC_PMC_PCSR0_PID24 = 0x1000000
	// Position of PID25 field.
	PMC_PMC_PCSR0_PID25_Pos = 0x19
	// Bit mask of PID25 field.
	PMC_PMC_PCSR0_PID25_Msk = 0x2000000
	// Bit PID25.
	PMC_PMC_PCSR0_PID25 = 0x2000000
	// Position of PID26 field.
	PMC_PMC_PCSR0_PID26_Pos = 0x1a
	// Bit mask of PID26 field.
	PMC_PMC_PCSR0_PID26_Msk = 0x4000000
	// Bit PID26.
	PMC_PMC_PCSR0_PID26 = 0x4000000
	// Position of PID27 field.
	PMC_PMC_PCSR0_PID27_Pos = 0x1b
	// Bit mask of PID27 field.
	PMC_PMC_PCSR0_PID27_Msk = 0x8000000
	// Bit PID27.
	PMC_PMC_PCSR0_PID27 = 0x8000000
	// Position of PID28 field.
	PMC_PMC_PCSR0_PID28_Pos = 0x1c
	// Bit mask of PID28 field.
	PMC_PMC_PCSR0_PID28_Msk = 0x10000000
	// Bit PID28.
	PMC_PMC_PCSR0_PID28 = 0x10000000
	// Position of PID29 field.
	PMC_PMC_PCSR0_PID29_Pos = 0x1d
	// Bit mask of PID29 field.
	PMC_PMC_PCSR0_PID29_Msk = 0x20000000
	// Bit PID29.
	PMC_PMC_PCSR0_PID29 = 0x20000000
	// Position of PID30 field.
	PMC_PMC_PCSR0_PID30_Pos = 0x1e
	// Bit mask of PID30 field.
	PMC_PMC_PCSR0_PID30_Msk = 0x40000000
	// Bit PID30.
	PMC_PMC_PCSR0_PID30 = 0x40000000
	// Position of PID31 field.
	PMC_PMC_PCSR0_PID31_Pos = 0x1f
	// Bit mask of PID31 field.
	PMC_PMC_PCSR0_PID31_Msk = 0x80000000
	// Bit PID31.
	PMC_PMC_PCSR0_PID31 = 0x80000000

	// CKGR_MOR: Main Oscillator Register
	// Position of MOSCXTEN field.
	PMC_CKGR_MOR_MOSCXTEN_Pos = 0x0
	// Bit mask of MOSCXTEN field.
	PMC_CKGR_MOR_MOSCXTEN_Msk = 0x1
	// Bit MOSCXTEN.
	PMC_CKGR_MOR_MOSCXTEN = 0x1
	// Position of MOSCXTBY field.
	PMC_CKGR_MOR_MOSCXTBY_Pos = 0x1
	// Bit mask of MOSCXTBY field.
	PMC_CKGR_MOR_MOSCXTBY_Msk = 0x2
	// Bit MOSCXTBY.
	PMC_CKGR_MOR_MOSCXTBY = 0x2
	// Position of MOSCRCEN field.
	PMC_CKGR_MOR_MOSCRCEN_Pos = 0x3
	// Bit mask of MOSCRCEN field.
	PMC_CKGR_MOR_MOSCRCEN_Msk = 0x8
	// Bit MOSCRCEN.
	PMC_CKGR_MOR_MOSCRCEN = 0x8
	// Position of MOSCRCF field.
	PMC_CKGR_MOR_MOSCRCF_Pos = 0x4
	// Bit mask of MOSCRCF field.
	PMC_CKGR_MOR_MOSCRCF_Msk = 0x70
	// The Fast RC Oscillator Frequency is at 4 MHz (default)
	PMC_CKGR_MOR_MOSCRCF_4_MHz = 0x0
	// The Fast RC Oscillator Frequency is at 8 MHz
	PMC_CKGR_MOR_MOSCRCF_8_MHz = 0x1
	// The Fast RC Oscillator Frequency is at 12 MHz
	PMC_CKGR_MOR_MOSCRCF_12_MHz = 0x2
	// Position of MOSCXTST field.
	PMC_CKGR_MOR_MOSCXTST_Pos = 0x8
	// Bit mask of MOSCXTST field.
	PMC_CKGR_MOR_MOSCXTST_Msk = 0xff00
	// Position of KEY field.
	PMC_CKGR_MOR_KEY_Pos = 0x10
	// Bit mask of KEY field.
	PMC_CKGR_MOR_KEY_Msk = 0xff0000
	// Position of MOSCSEL field.
	PMC_CKGR_MOR_MOSCSEL_Pos = 0x18
	// Bit mask of MOSCSEL field.
	PMC_CKGR_MOR_MOSCSEL_Msk = 0x1000000
	// Bit MOSCSEL.
	PMC_CKGR_MOR_MOSCSEL = 0x1000000
	// Position of CFDEN field.
	PMC_CKGR_MOR_CFDEN_Pos = 0x19
	// Bit mask of CFDEN field.
	PMC_CKGR_MOR_CFDEN_Msk = 0x2000000
	// Bit CFDEN.
	PMC_CKGR_MOR_CFDEN = 0x2000000

	// CKGR_MCFR: Main Clock Frequency Register
	// Position of MAINF field.
	PMC_CKGR_MCFR_MAINF_Pos = 0x0
	// Bit mask of MAINF field.
	PMC_CKGR_MCFR_MAINF_Msk = 0xffff
	// Position of MAINFRDY field.
	PMC_CKGR_MCFR_MAINFRDY_Pos = 0x10
	// Bit mask of MAINFRDY field.
	PMC_CKGR_MCFR_MAINFRDY_Msk = 0x10000
	// Bit MAINFRDY.
	PMC_CKGR_MCFR_MAINFRDY = 0x10000

	// CKGR_PLLAR: PLLA Register
	// Position of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Pos = 0x0
	// Bit mask of DIVA field.
	PMC_CKGR_PLLAR_DIVA_Msk = 0xff
	// Position of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Pos = 0x8
	// Bit mask of PLLACOUNT field.
	PMC_CKGR_PLLAR_PLLACOUNT_Msk = 0x3f00
	// Position of MULA field.
	PMC_CKGR_PLLAR_MULA_Pos = 0x10
	// Bit mask of MULA field.
	PMC_CKGR_PLLAR_MULA_Msk = 0x7ff0000
	// Position of ONE field.
	PMC_CKGR_PLLAR_ONE_Pos = 0x1d
	// Bit mask of ONE field.
	PMC_CKGR_PLLAR_ONE_Msk = 0x20000000
	// Bit ONE.
	PMC_CKGR_PLLAR_ONE = 0x20000000

	// PMC_MCKR: Master Clock Register
	// Position of CSS field.
	PMC_PMC_MCKR_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_MCKR_CSS_Msk = 0x3
	// Slow Clock is selected
	PMC_PMC_MCKR_CSS_SLOW_CLK = 0x0
	// Main Clock is selected
	PMC_PMC_MCKR_CSS_MAIN_CLK = 0x1
	// PLLA Clock is selected
	PMC_PMC_MCKR_CSS_PLLA_CLK = 0x2
	// Position of PRES field.
	PMC_PMC_MCKR_PRES_Pos = 0x4
	// Bit mask of PRES field.
	PMC_PMC_MCKR_PRES_Msk = 0x70
	// Selected clock
	PMC_PMC_MCKR_PRES_CLK_1 = 0x0
	// Selected clock divided by 2
	PMC_PMC_MCKR_PRES_CLK_2 = 0x1
	// Selected clock divided by 4
	PMC_PMC_MCKR_PRES_CLK_4 = 0x2
	// Selected clock divided by 8
	PMC_PMC_MCKR_PRES_CLK_8 = 0x3
	// Selected clock divided by 16
	PMC_PMC_MCKR_PRES_CLK_16 = 0x4
	// Selected clock divided by 32
	PMC_PMC_MCKR_PRES_CLK_32 = 0x5
	// Selected clock divided by 64
	PMC_PMC_MCKR_PRES_CLK_64 = 0x6
	// Selected clock divided by 3
	PMC_PMC_MCKR_PRES_CLK_3 = 0x7
	// Position of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2_Pos = 0xc
	// Bit mask of PLLADIV2 field.
	PMC_PMC_MCKR_PLLADIV2_Msk = 0x1000
	// Bit PLLADIV2.
	PMC_PMC_MCKR_PLLADIV2 = 0x1000

	// PMC_PCK: Programmable Clock 0 Register
	// Position of CSS field.
	PMC_PMC_PCK_CSS_Pos = 0x0
	// Bit mask of CSS field.
	PMC_PMC_PCK_CSS_Msk = 0x7
	// Slow Clock is selected
	PMC_PMC_PCK_CSS_SLOW_CLK = 0x0
	// Main Clock is selected
	PMC_PMC_PCK_CSS_MAIN_CLK = 0x1
	// PLLA Clock is selected
	PMC_PMC_PCK_CSS_PLLA_CLK = 0x2
	// Master Clock is selected
	PMC_PMC_PCK_CSS_MCK = 0x4
	// Position of PRES field.
	PMC_PMC_PCK_PRES_Pos = 0x4
	// Bit mask of PRES field.
	PMC_PMC_PCK_PRES_Msk = 0x70
	// Selected clock
	PMC_PMC_PCK_PRES_CLK_1 = 0x0
	// Selected clock divided by 2
	PMC_PMC_PCK_PRES_CLK_2 = 0x1
	// Selected clock divided by 4
	PMC_PMC_PCK_PRES_CLK_4 = 0x2
	// Selected clock divided by 8
	PMC_PMC_PCK_PRES_CLK_8 = 0x3
	// Selected clock divided by 16
	PMC_PMC_PCK_PRES_CLK_16 = 0x4
	// Selected clock divided by 32
	PMC_PMC_PCK_PRES_CLK_32 = 0x5
	// Selected clock divided by 64
	PMC_PMC_PCK_PRES_CLK_64 = 0x6

	// PMC_IER: Interrupt Enable Register
	// Position of MOSCXTS field.
	PMC_PMC_IER_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IER_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IER_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IER_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IER_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IER_LOCKA = 0x2
	// Position of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IER_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IER_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IER_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IER_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IER_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IER_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IER_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IER_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IER_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_IER_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IER_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IER_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IER_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IER_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IER_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IER_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IER_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IER_CFDEV = 0x40000

	// PMC_IDR: Interrupt Disable Register
	// Position of MOSCXTS field.
	PMC_PMC_IDR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IDR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IDR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IDR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IDR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IDR_LOCKA = 0x2
	// Position of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IDR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IDR_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IDR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IDR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IDR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IDR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IDR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IDR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IDR_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_IDR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IDR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IDR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IDR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IDR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IDR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IDR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IDR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IDR_CFDEV = 0x40000

	// PMC_SR: Status Register
	// Position of MOSCXTS field.
	PMC_PMC_SR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_SR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_SR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_SR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_SR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_SR_LOCKA = 0x2
	// Position of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_SR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_SR_MCKRDY = 0x8
	// Position of OSCSELS field.
	PMC_PMC_SR_OSCSELS_Pos = 0x7
	// Bit mask of OSCSELS field.
	PMC_PMC_SR_OSCSELS_Msk = 0x80
	// Bit OSCSELS.
	PMC_PMC_SR_OSCSELS = 0x80
	// Position of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_SR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_SR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_SR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_SR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_SR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_SR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_SR_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_SR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_SR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_SR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_SR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_SR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_SR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_SR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_SR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_SR_CFDEV = 0x40000
	// Position of CFDS field.
	PMC_PMC_SR_CFDS_Pos = 0x13
	// Bit mask of CFDS field.
	PMC_PMC_SR_CFDS_Msk = 0x80000
	// Bit CFDS.
	PMC_PMC_SR_CFDS = 0x80000
	// Position of FOS field.
	PMC_PMC_SR_FOS_Pos = 0x14
	// Bit mask of FOS field.
	PMC_PMC_SR_FOS_Msk = 0x100000
	// Bit FOS.
	PMC_PMC_SR_FOS = 0x100000

	// PMC_IMR: Interrupt Mask Register
	// Position of MOSCXTS field.
	PMC_PMC_IMR_MOSCXTS_Pos = 0x0
	// Bit mask of MOSCXTS field.
	PMC_PMC_IMR_MOSCXTS_Msk = 0x1
	// Bit MOSCXTS.
	PMC_PMC_IMR_MOSCXTS = 0x1
	// Position of LOCKA field.
	PMC_PMC_IMR_LOCKA_Pos = 0x1
	// Bit mask of LOCKA field.
	PMC_PMC_IMR_LOCKA_Msk = 0x2
	// Bit LOCKA.
	PMC_PMC_IMR_LOCKA = 0x2
	// Position of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Pos = 0x3
	// Bit mask of MCKRDY field.
	PMC_PMC_IMR_MCKRDY_Msk = 0x8
	// Bit MCKRDY.
	PMC_PMC_IMR_MCKRDY = 0x8
	// Position of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Pos = 0x8
	// Bit mask of PCKRDY0 field.
	PMC_PMC_IMR_PCKRDY0_Msk = 0x100
	// Bit PCKRDY0.
	PMC_PMC_IMR_PCKRDY0 = 0x100
	// Position of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Pos = 0x9
	// Bit mask of PCKRDY1 field.
	PMC_PMC_IMR_PCKRDY1_Msk = 0x200
	// Bit PCKRDY1.
	PMC_PMC_IMR_PCKRDY1 = 0x200
	// Position of PCKRDY2 field.
	PMC_PMC_IMR_PCKRDY2_Pos = 0xa
	// Bit mask of PCKRDY2 field.
	PMC_PMC_IMR_PCKRDY2_Msk = 0x400
	// Bit PCKRDY2.
	PMC_PMC_IMR_PCKRDY2 = 0x400
	// Position of MOSCSELS field.
	PMC_PMC_IMR_MOSCSELS_Pos = 0x10
	// Bit mask of MOSCSELS field.
	PMC_PMC_IMR_MOSCSELS_Msk = 0x10000
	// Bit MOSCSELS.
	PMC_PMC_IMR_MOSCSELS = 0x10000
	// Position of MOSCRCS field.
	PMC_PMC_IMR_MOSCRCS_Pos = 0x11
	// Bit mask of MOSCRCS field.
	PMC_PMC_IMR_MOSCRCS_Msk = 0x20000
	// Bit MOSCRCS.
	PMC_PMC_IMR_MOSCRCS = 0x20000
	// Position of CFDEV field.
	PMC_PMC_IMR_CFDEV_Pos = 0x12
	// Bit mask of CFDEV field.
	PMC_PMC_IMR_CFDEV_Msk = 0x40000
	// Bit CFDEV.
	PMC_PMC_IMR_CFDEV = 0x40000

	// PMC_FSMR: Fast Start-up Mode Register
	// Position of FSTT0 field.
	PMC_PMC_FSMR_FSTT0_Pos = 0x0
	// Bit mask of FSTT0 field.
	PMC_PMC_FSMR_FSTT0_Msk = 0x1
	// Bit FSTT0.
	PMC_PMC_FSMR_FSTT0 = 0x1
	// Position of FSTT1 field.
	PMC_PMC_FSMR_FSTT1_Pos = 0x1
	// Bit mask of FSTT1 field.
	PMC_PMC_FSMR_FSTT1_Msk = 0x2
	// Bit FSTT1.
	PMC_PMC_FSMR_FSTT1 = 0x2
	// Position of FSTT2 field.
	PMC_PMC_FSMR_FSTT2_Pos = 0x2
	// Bit mask of FSTT2 field.
	PMC_PMC_FSMR_FSTT2_Msk = 0x4
	// Bit FSTT2.
	PMC_PMC_FSMR_FSTT2 = 0x4
	// Position of FSTT3 field.
	PMC_PMC_FSMR_FSTT3_Pos = 0x3
	// Bit mask of FSTT3 field.
	PMC_PMC_FSMR_FSTT3_Msk = 0x8
	// Bit FSTT3.
	PMC_PMC_FSMR_FSTT3 = 0x8
	// Position of FSTT4 field.
	PMC_PMC_FSMR_FSTT4_Pos = 0x4
	// Bit mask of FSTT4 field.
	PMC_PMC_FSMR_FSTT4_Msk = 0x10
	// Bit FSTT4.
	PMC_PMC_FSMR_FSTT4 = 0x10
	// Position of FSTT5 field.
	PMC_PMC_FSMR_FSTT5_Pos = 0x5
	// Bit mask of FSTT5 field.
	PMC_PMC_FSMR_FSTT5_Msk = 0x20
	// Bit FSTT5.
	PMC_PMC_FSMR_FSTT5 = 0x20
	// Position of FSTT6 field.
	PMC_PMC_FSMR_FSTT6_Pos = 0x6
	// Bit mask of FSTT6 field.
	PMC_PMC_FSMR_FSTT6_Msk = 0x40
	// Bit FSTT6.
	PMC_PMC_FSMR_FSTT6 = 0x40
	// Position of FSTT7 field.
	PMC_PMC_FSMR_FSTT7_Pos = 0x7
	// Bit mask of FSTT7 field.
	PMC_PMC_FSMR_FSTT7_Msk = 0x80
	// Bit FSTT7.
	PMC_PMC_FSMR_FSTT7 = 0x80
	// Position of FSTT8 field.
	PMC_PMC_FSMR_FSTT8_Pos = 0x8
	// Bit mask of FSTT8 field.
	PMC_PMC_FSMR_FSTT8_Msk = 0x100
	// Bit FSTT8.
	PMC_PMC_FSMR_FSTT8 = 0x100
	// Position of FSTT9 field.
	PMC_PMC_FSMR_FSTT9_Pos = 0x9
	// Bit mask of FSTT9 field.
	PMC_PMC_FSMR_FSTT9_Msk = 0x200
	// Bit FSTT9.
	PMC_PMC_FSMR_FSTT9 = 0x200
	// Position of FSTT10 field.
	PMC_PMC_FSMR_FSTT10_Pos = 0xa
	// Bit mask of FSTT10 field.
	PMC_PMC_FSMR_FSTT10_Msk = 0x400
	// Bit FSTT10.
	PMC_PMC_FSMR_FSTT10 = 0x400
	// Position of FSTT11 field.
	PMC_PMC_FSMR_FSTT11_Pos = 0xb
	// Bit mask of FSTT11 field.
	PMC_PMC_FSMR_FSTT11_Msk = 0x800
	// Bit FSTT11.
	PMC_PMC_FSMR_FSTT11 = 0x800
	// Position of FSTT12 field.
	PMC_PMC_FSMR_FSTT12_Pos = 0xc
	// Bit mask of FSTT12 field.
	PMC_PMC_FSMR_FSTT12_Msk = 0x1000
	// Bit FSTT12.
	PMC_PMC_FSMR_FSTT12 = 0x1000
	// Position of FSTT13 field.
	PMC_PMC_FSMR_FSTT13_Pos = 0xd
	// Bit mask of FSTT13 field.
	PMC_PMC_FSMR_FSTT13_Msk = 0x2000
	// Bit FSTT13.
	PMC_PMC_FSMR_FSTT13 = 0x2000
	// Position of FSTT14 field.
	PMC_PMC_FSMR_FSTT14_Pos = 0xe
	// Bit mask of FSTT14 field.
	PMC_PMC_FSMR_FSTT14_Msk = 0x4000
	// Bit FSTT14.
	PMC_PMC_FSMR_FSTT14 = 0x4000
	// Position of FSTT15 field.
	PMC_PMC_FSMR_FSTT15_Pos = 0xf
	// Bit mask of FSTT15 field.
	PMC_PMC_FSMR_FSTT15_Msk = 0x8000
	// Bit FSTT15.
	PMC_PMC_FSMR_FSTT15 = 0x8000
	// Position of RTTAL field.
	PMC_PMC_FSMR_RTTAL_Pos = 0x10
	// Bit mask of RTTAL field.
	PMC_PMC_FSMR_RTTAL_Msk = 0x10000
	// Bit RTTAL.
	PMC_PMC_FSMR_RTTAL = 0x10000
	// Position of RTCAL field.
	PMC_PMC_FSMR_RTCAL_Pos = 0x11
	// Bit mask of RTCAL field.
	PMC_PMC_FSMR_RTCAL_Msk = 0x20000
	// Bit RTCAL.
	PMC_PMC_FSMR_RTCAL = 0x20000
	// Position of LPM field.
	PMC_PMC_FSMR_LPM_Pos = 0x14
	// Bit mask of LPM field.
	PMC_PMC_FSMR_LPM_Msk = 0x100000
	// Bit LPM.
	PMC_PMC_FSMR_LPM = 0x100000

	// PMC_FSPR: Fast Start-up Polarity Register
	// Position of FSTP0 field.
	PMC_PMC_FSPR_FSTP0_Pos = 0x0
	// Bit mask of FSTP0 field.
	PMC_PMC_FSPR_FSTP0_Msk = 0x1
	// Bit FSTP0.
	PMC_PMC_FSPR_FSTP0 = 0x1
	// Position of FSTP1 field.
	PMC_PMC_FSPR_FSTP1_Pos = 0x1
	// Bit mask of FSTP1 field.
	PMC_PMC_FSPR_FSTP1_Msk = 0x2
	// Bit FSTP1.
	PMC_PMC_FSPR_FSTP1 = 0x2
	// Position of FSTP2 field.
	PMC_PMC_FSPR_FSTP2_Pos = 0x2
	// Bit mask of FSTP2 field.
	PMC_PMC_FSPR_FSTP2_Msk = 0x4
	// Bit FSTP2.
	PMC_PMC_FSPR_FSTP2 = 0x4
	// Position of FSTP3 field.
	PMC_PMC_FSPR_FSTP3_Pos = 0x3
	// Bit mask of FSTP3 field.
	PMC_PMC_FSPR_FSTP3_Msk = 0x8
	// Bit FSTP3.
	PMC_PMC_FSPR_FSTP3 = 0x8
	// Position of FSTP4 field.
	PMC_PMC_FSPR_FSTP4_Pos = 0x4
	// Bit mask of FSTP4 field.
	PMC_PMC_FSPR_FSTP4_Msk = 0x10
	// Bit FSTP4.
	PMC_PMC_FSPR_FSTP4 = 0x10
	// Position of FSTP5 field.
	PMC_PMC_FSPR_FSTP5_Pos = 0x5
	// Bit mask of FSTP5 field.
	PMC_PMC_FSPR_FSTP5_Msk = 0x20
	// Bit FSTP5.
	PMC_PMC_FSPR_FSTP5 = 0x20
	// Position of FSTP6 field.
	PMC_PMC_FSPR_FSTP6_Pos = 0x6
	// Bit mask of FSTP6 field.
	PMC_PMC_FSPR_FSTP6_Msk = 0x40
	// Bit FSTP6.
	PMC_PMC_FSPR_FSTP6 = 0x40
	// Position of FSTP7 field.
	PMC_PMC_FSPR_FSTP7_Pos = 0x7
	// Bit mask of FSTP7 field.
	PMC_PMC_FSPR_FSTP7_Msk = 0x80
	// Bit FSTP7.
	PMC_PMC_FSPR_FSTP7 = 0x80
	// Position of FSTP8 field.
	PMC_PMC_FSPR_FSTP8_Pos = 0x8
	// Bit mask of FSTP8 field.
	PMC_PMC_FSPR_FSTP8_Msk = 0x100
	// Bit FSTP8.
	PMC_PMC_FSPR_FSTP8 = 0x100
	// Position of FSTP9 field.
	PMC_PMC_FSPR_FSTP9_Pos = 0x9
	// Bit mask of FSTP9 field.
	PMC_PMC_FSPR_FSTP9_Msk = 0x200
	// Bit FSTP9.
	PMC_PMC_FSPR_FSTP9 = 0x200
	// Position of FSTP10 field.
	PMC_PMC_FSPR_FSTP10_Pos = 0xa
	// Bit mask of FSTP10 field.
	PMC_PMC_FSPR_FSTP10_Msk = 0x400
	// Bit FSTP10.
	PMC_PMC_FSPR_FSTP10 = 0x400
	// Position of FSTP11 field.
	PMC_PMC_FSPR_FSTP11_Pos = 0xb
	// Bit mask of FSTP11 field.
	PMC_PMC_FSPR_FSTP11_Msk = 0x800
	// Bit FSTP11.
	PMC_PMC_FSPR_FSTP11 = 0x800
	// Position of FSTP12 field.
	PMC_PMC_FSPR_FSTP12_Pos = 0xc
	// Bit mask of FSTP12 field.
	PMC_PMC_FSPR_FSTP12_Msk = 0x1000
	// Bit FSTP12.
	PMC_PMC_FSPR_FSTP12 = 0x1000
	// Position of FSTP13 field.
	PMC_PMC_FSPR_FSTP13_Pos = 0xd
	// Bit mask of FSTP13 field.
	PMC_PMC_FSPR_FSTP13_Msk = 0x2000
	// Bit FSTP13.
	PMC_PMC_FSPR_FSTP13 = 0x2000
	// Position of FSTP14 field.
	PMC_PMC_FSPR_FSTP14_Pos = 0xe
	// Bit mask of FSTP14 field.
	PMC_PMC_FSPR_FSTP14_Msk = 0x4000
	// Bit FSTP14.
	PMC_PMC_FSPR_FSTP14 = 0x4000
	// Position of FSTP15 field.
	PMC_PMC_FSPR_FSTP15_Pos = 0xf
	// Bit mask of FSTP15 field.
	PMC_PMC_FSPR_FSTP15_Msk = 0x8000
	// Bit FSTP15.
	PMC_PMC_FSPR_FSTP15 = 0x8000

	// PMC_FOCR: Fault Output Clear Register
	// Position of FOCLR field.
	PMC_PMC_FOCR_FOCLR_Pos = 0x0
	// Bit mask of FOCLR field.
	PMC_PMC_FOCR_FOCLR_Msk = 0x1
	// Bit FOCLR.
	PMC_PMC_FOCR_FOCLR = 0x1

	// PMC_WPMR: Write Protect Mode Register
	// Position of WPEN field.
	PMC_PMC_WPMR_WPEN_Pos = 0x0
	// Bit mask of WPEN field.
	PMC_PMC_WPMR_WPEN_Msk = 0x1
	// Bit WPEN.
	PMC_PMC_WPMR_WPEN = 0x1
	// Position of WPKEY field.
	PMC_PMC_WPMR_WPKEY_Pos = 0x8
	// Bit mask of WPKEY field.
	PMC_PMC_WPMR_WPKEY_Msk = 0xffffff00

	// PMC_WPSR: Write Protect Status Register
	// Position of WPVS field.
	PMC_PMC_WPSR_WPVS_Pos = 0x0
	// Bit mask of WPVS field.
	PMC_PMC_WPSR_WPVS_Msk = 0x1
	// Bit WPVS.
	PMC_PMC_WPSR_WPVS = 0x1
	// Position of WPVSRC field.
	PMC_PMC_WPSR_WPVSRC_Pos = 0x8
	// Bit mask of WPVSRC field.
	PMC_PMC_WPSR_WPVSRC_Msk = 0xffff00
)

// Constants for UART0: Universal Asynchronous Receiver Transmitter 0
const (
	// CR: Control Register
	// Position of RSTRX field.
	UART_CR_RSTRX_Pos = 0x2
	// Bit mask of RSTRX field.
	UART_CR_RSTRX_Msk = 0x4
	// Bit RSTRX.
	UART_CR_RSTRX = 0x4
	// Position of RSTTX field.
	UART_CR_RSTTX_Pos = 0x3
	// Bit mask of RSTTX field.
	UART_CR_RSTTX_Msk = 0x8
	// Bit RSTTX.
	UART_CR_RSTTX = 0x8
	// Position of RXEN field.
	UART_CR_RXEN_Pos = 0x4
	// Bit mask of RXEN field.
	UART_CR_RXEN_Msk = 0x10
	// Bit RXEN.
	UART_CR_RXEN = 0x10
	// Position of RXDIS field.
	UART_CR_RXDIS_Pos = 0x5
	// Bit mask of RXDIS field.
	UART_CR_RXDIS_Msk = 0x20
	// Bit RXDIS.
	UART_CR_RXDIS = 0x20
	// Position of TXEN field.
	UART_CR_TXEN_Pos = 0x6
	// Bit mask of TXEN field.
	UART_CR_TXEN_Msk = 0x40
	// Bit TXEN.
	UART_CR_TXEN = 0x40
	// Position of TXDIS field.
	UART_CR_TXDIS_Pos = 0x7
	// Bit mask of TXDIS field.
	UART_CR_TXDIS_Msk = 0x80
	// Bit TXDIS.
	UART_CR_TXDIS = 0x80
	// Position of RSTSTA field.
	UART_CR_RSTSTA_Pos = 0x8
	// Bit mask of RSTSTA field.
	UART_CR_RSTSTA_Msk = 0x100
	// Bit RSTSTA.
	UART_CR_RSTSTA = 0x100

	// MR: Mode Register
	// Position of PAR field.
	UART_MR_PAR_Pos = 0x9
	// Bit mask of PAR field.
	UART_MR_PAR_Msk = 0xe00
	// Even parity
	UART_MR_PAR_EVEN = 0x0
	// Odd parity
	UART_MR_PAR_ODD = 0x1
	// Space: parity forced to 0
	UART_MR_PAR_SPACE = 0x2
	// Mark: parity forced to 1
	UART_MR_PAR_MARK = 0x3
	// No parity
	UART_MR_PAR_NO = 0x4
	// Position of CHMODE field.
	UART_MR_CHMODE_Pos = 0xe
	// Bit mask of CHMODE field.
	UART_MR_CHMODE_Msk = 0xc000
	// Normal Mode
	UART_MR_CHMODE_NORMAL = 0x0
	// Automatic Echo
	UART_MR_CHMODE_AUTOMATIC = 0x1
	// Local Loopback
	UART_MR_CHMODE_LOCAL_LOOPBACK = 0x2
	// Remote Loopback
	UART_MR_CHMODE_REMOTE_LOOPBACK = 0x3

	// IER: Interrupt Enable Register
	// Position of RXRDY field.
	UART_IER_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IER_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IER_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IER_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IER_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IER_TXRDY = 0x2
	// Position of ENDRX field.
	UART_IER_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_IER_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_IER_ENDRX = 0x8
	// Position of ENDTX field.
	UART_IER_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_IER_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_IER_ENDTX = 0x10
	// Position of OVRE field.
	UART_IER_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IER_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IER_OVRE = 0x20
	// Position of FRAME field.
	UART_IER_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IER_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IER_FRAME = 0x40
	// Position of PARE field.
	UART_IER_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IER_PARE_Msk = 0x80
	// Bit PARE.
	UART_IER_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IER_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IER_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IER_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_IER_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_IER_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_IER_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_IER_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_IER_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_IER_RXBUFF = 0x1000

	// IDR: Interrupt Disable Register
	// Position of RXRDY field.
	UART_IDR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IDR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IDR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IDR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IDR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IDR_TXRDY = 0x2
	// Position of ENDRX field.
	UART_IDR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_IDR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_IDR_ENDRX = 0x8
	// Position of ENDTX field.
	UART_IDR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_IDR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_IDR_ENDTX = 0x10
	// Position of OVRE field.
	UART_IDR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IDR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IDR_OVRE = 0x20
	// Position of FRAME field.
	UART_IDR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IDR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IDR_FRAME = 0x40
	// Position of PARE field.
	UART_IDR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IDR_PARE_Msk = 0x80
	// Bit PARE.
	UART_IDR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IDR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IDR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IDR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_IDR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_IDR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_IDR_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_IDR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_IDR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_IDR_RXBUFF = 0x1000

	// IMR: Interrupt Mask Register
	// Position of RXRDY field.
	UART_IMR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_IMR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_IMR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_IMR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_IMR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_IMR_TXRDY = 0x2
	// Position of ENDRX field.
	UART_IMR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_IMR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_IMR_ENDRX = 0x8
	// Position of ENDTX field.
	UART_IMR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_IMR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_IMR_ENDTX = 0x10
	// Position of OVRE field.
	UART_IMR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_IMR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_IMR_OVRE = 0x20
	// Position of FRAME field.
	UART_IMR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_IMR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_IMR_FRAME = 0x40
	// Position of PARE field.
	UART_IMR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_IMR_PARE_Msk = 0x80
	// Bit PARE.
	UART_IMR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_IMR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_IMR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_IMR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_IMR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_IMR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_IMR_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_IMR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_IMR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_IMR_RXBUFF = 0x1000

	// SR: Status Register
	// Position of RXRDY field.
	UART_SR_RXRDY_Pos = 0x0
	// Bit mask of RXRDY field.
	UART_SR_RXRDY_Msk = 0x1
	// Bit RXRDY.
	UART_SR_RXRDY = 0x1
	// Position of TXRDY field.
	UART_SR_TXRDY_Pos = 0x1
	// Bit mask of TXRDY field.
	UART_SR_TXRDY_Msk = 0x2
	// Bit TXRDY.
	UART_SR_TXRDY = 0x2
	// Position of ENDRX field.
	UART_SR_ENDRX_Pos = 0x3
	// Bit mask of ENDRX field.
	UART_SR_ENDRX_Msk = 0x8
	// Bit ENDRX.
	UART_SR_ENDRX = 0x8
	// Position of ENDTX field.
	UART_SR_ENDTX_Pos = 0x4
	// Bit mask of ENDTX field.
	UART_SR_ENDTX_Msk = 0x10
	// Bit ENDTX.
	UART_SR_ENDTX = 0x10
	// Position of OVRE field.
	UART_SR_OVRE_Pos = 0x5
	// Bit mask of OVRE field.
	UART_SR_OVRE_Msk = 0x20
	// Bit OVRE.
	UART_SR_OVRE = 0x20
	// Position of FRAME field.
	UART_SR_FRAME_Pos = 0x6
	// Bit mask of FRAME field.
	UART_SR_FRAME_Msk = 0x40
	// Bit FRAME.
	UART_SR_FRAME = 0x40
	// Position of PARE field.
	UART_SR_PARE_Pos = 0x7
	// Bit mask of PARE field.
	UART_SR_PARE_Msk = 0x80
	// Bit PARE.
	UART_SR_PARE = 0x80
	// Position of TXEMPTY field.
	UART_SR_TXEMPTY_Pos = 0x9
	// Bit mask of TXEMPTY field.
	UART_SR_TXEMPTY_Msk = 0x200
	// Bit TXEMPTY.
	UART_SR_TXEMPTY = 0x200
	// Position of TXBUFE field.
	UART_SR_TXBUFE_Pos = 0xb
	// Bit mask of TXBUFE field.
	UART_SR_TXBUFE_Msk = 0x800
	// Bit TXBUFE.
	UART_SR_TXBUFE = 0x800
	// Position of RXBUFF field.
	UART_SR_RXBUFF_Pos = 0xc
	// Bit mask of RXBUFF field.
	UART_SR_RXBUFF_Msk = 0x1000
	// Bit RXBUFF.
	UART_SR_RXBUFF = 0x1000

	// RHR: Receive Holding Register
	// Position of RXCHR field.
	UART_RHR_RXCHR_Pos = 0x0
	// Bit mask of RXCHR field.
	UART_RHR_RXCHR_Msk = 0xff

	// THR: Transmit Holding Register
	// Position of TXCHR field.
	UART_THR_TXCHR_Pos = 0x0
	// Bit mask of TXCHR field.
	UART_THR_TXCHR_Msk = 0xff

	// BRGR: Baud Rate Generator Register
	// Position of CD field.
	UART_BRGR_CD_Pos = 0x0
	// Bit mask of CD field.
	UART_BRGR_CD_Msk = 0xffff

	// RPR: Receive Pointer Register
	// Position of RXPTR field.
	UART_RPR_RXPTR_Pos = 0x0
	// Bit mask of RXPTR field.
	UART_RPR_RXPTR_Msk = 0xffffffff

	// RCR: Receive Counter Register
	// Position of RXCTR field.
	UART_RCR_RXCTR_Pos = 0x0
	// Bit mask of RXCTR field.
	UART_RCR_RXCTR_Msk = 0xffff

	// TPR: Transmit Pointer Register
	// Position of TXPTR field.
	UART_TPR_TXPTR_Pos = 0x0
	// Bit mask of TXPTR field.
	UART_TPR_TXPTR_Msk = 0xffffffff

	// TCR: Transmit Counter Register
	// Position of TXCTR field.
	UART_TCR_TXCTR_Pos = 0x0
	// Bit mask of TXCTR field.
	UART_TCR_TXCTR_Msk = 0xffff

	// RNPR: Receive Next Pointer Register
	// Position of RXNPTR field.
	UART_RNPR_RXNPTR_Pos = 0x0
	// Bit mask of RXNPTR field.
	UART_RNPR_RXNPTR_Msk = 0xffffffff

	// RNCR: Receive Next Counter Register
	// Position of RXNCTR field.
	UART_RNCR_RXNCTR_Pos = 0x0
	// Bit mask of RXNCTR field.
	UART_RNCR_RXNCTR_Msk = 0xffff

	// TNPR: Transmit Next Pointer Register
	// Position of TXNPTR field.
	UART_TNPR_TXNPTR_Pos = 0x0
	// Bit mask of TXNPTR field.
	UART_TNPR_TXNPTR_Msk = 0xffffffff

	// TNCR: Transmit Next Counter Register
	// Position of TXNCTR field.
	UART_TNCR_TXNCTR_Pos = 0x0
	// Bit mask of TXNCTR field.
	UART_TNCR_TXNCTR_Msk = 0xffff

	// PTCR: Transfer Control Register
	// Position of RXTEN field.
	UART_PTCR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	UART_PTCR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	UART_PTCR_RXTEN = 0x1
	// Position of RXTDIS field.
	UART_PTCR_RXTDIS_Pos = 0x1
	// Bit mask of RXTDIS field.
	UART_PTCR_RXTDIS_Msk = 0x2
	// Bit RXTDIS.
	UART_PTCR_RXTDIS = 0x2
	// Position of TXTEN field.
	UART_PTCR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	UART_PTCR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	UART_PTCR_TXTEN = 0x100
	// Position of TXTDIS field.
	UART_PTCR_TXTDIS_Pos = 0x9
	// Bit mask of TXTDIS field.
	UART_PTCR_TXTDIS_Msk = 0x200
	// Bit TXTDIS.
	UART_PTCR_TXTDIS = 0x200

	// PTSR: Transfer Status Register
	// Position of RXTEN field.
	UART_PTSR_RXTEN_Pos = 0x0
	// Bit mask of RXTEN field.
	UART_PTSR_RXTEN_Msk = 0x1
	// Bit RXTEN.
	UART_PTSR_RXTEN = 0x1
	// Position of TXTEN field.
	UART_PTSR_TXTEN_Pos = 0x8
	// Bit mask of TXTEN field.
	UART_PTSR_TXTEN_Msk = 0x100
	// Bit TXTEN.
	UART_PTSR_TXTEN = 0x100
)

// Constants for CHIPID: Chip Identifier
const (
	// CIDR: Chip ID Register
	// Position of VERSION field.
	CHIPID_CIDR_VERSION_Pos = 0x0
	// Bit mask of VERSION field.
	CHIPID_CIDR_VERSION_Msk = 0x1f
	// Position of EPROC field.
	CHIPID_CIDR_EPROC_Pos = 0x5
	// Bit mask of EPROC field.
	CHIPID_CIDR_EPROC_Msk = 0xe0
	// ARM946ES
	CHIPID_CIDR_EPROC_ARM946ES = 0x1
	// ARM7TDMI
	CHIPID_CIDR_EPROC_ARM7TDMI = 0x2
	// Cortex-M3
	CHIPID_CIDR_EPROC_CM3 = 0x3
	// ARM920T
	CHIPID_CIDR_EPROC_ARM920T = 0x4
	// ARM926EJS
	CHIPID_CIDR_EPROC_ARM926EJS = 0x5
	// Cortex-A5
	CHIPID_CIDR_EPROC_CA5 = 0x6
	// Cortex-M4
	CHIPID_CIDR_EPROC_CM4 = 0x7
	// Position of NVPSIZ field.
	CHIPID_CIDR_NVPSIZ_Pos = 0x8
	// Bit mask of NVPSIZ field.
	CHIPID_CIDR_NVPSIZ_Msk = 0xf00
	// None
	CHIPID_CIDR_NVPSIZ_NONE = 0x0
	// 8K bytes
	CHIPID_CIDR_NVPSIZ_8K = 0x1
	// 16K bytes
	CHIPID_CIDR_NVPSIZ_16K = 0x2
	// 32K bytes
	CHIPID_CIDR_NVPSIZ_32K = 0x3
	// 64K bytes
	CHIPID_CIDR_NVPSIZ_64K = 0x5
	// 128K bytes
	CHIPID_CIDR_NVPSIZ_128K = 0x7
	// 256K bytes
	CHIPID_CIDR_NVPSIZ_256K = 0x9
	// 512K bytes
	CHIPID_CIDR_NVPSIZ_512K = 0xa
	// 1024K bytes
	CHIPID_CIDR_NVPSIZ_1024K = 0xc
	// 2048K bytes
	CHIPID_CIDR_NVPSIZ_2048K = 0xe
	// Position of NVPSIZ2 field.
	CHIPID_CIDR_NVPSIZ2_Pos = 0xc
	// Bit mask of NVPSIZ2 field.
	CHIPID_CIDR_NVPSIZ2_Msk = 0xf000
	// None
	CHIPID_CIDR_NVPSIZ2_NONE = 0x0
	// 8K bytes
	CHIPID_CIDR_NVPSIZ2_8K = 0x1
	// 16K bytes
	CHIPID_CIDR_NVPSIZ2_16K = 0x2
	// 32K bytes
	CHIPID_CIDR_NVPSIZ2_32K = 0x3
	// 64K bytes
	CHIPID_CIDR_NVPSIZ2_64K = 0x5
	// 128K bytes
	CHIPID_CIDR_NVPSIZ2_128K = 0x7
	// 256K bytes
	CHIPID_CIDR_NVPSIZ2_256K = 0x9
	// 512K bytes
	CHIPID_CIDR_NVPSIZ2_512K = 0xa
	// 1024K bytes
	CHIPID_CIDR_NVPSIZ2_1024K = 0xc
	// 2048K bytes
	CHIPID_CIDR_NVPSIZ2_2048K = 0xe
	// Position of SRAMSIZ field.
	CHIPID_CIDR_SRAMSIZ_Pos = 0x10
	// Bit mask of SRAMSIZ field.
	CHIPID_CIDR_SRAMSIZ_Msk = 0xf0000
	// 48K bytes
	CHIPID_CIDR_SRAMSIZ_48K = 0x0
	// 1K bytes
	CHIPID_CIDR_SRAMSIZ_1K = 0x1
	// 2K bytes
	CHIPID_CIDR_SRAMSIZ_2K = 0x2
	// 6K bytes
	CHIPID_CIDR_SRAMSIZ_6K = 0x3
	// 24K bytes
	CHIPID_CIDR_SRAMSIZ_24K = 0x4
	// 4K bytes
	CHIPID_CIDR_SRAMSIZ_4K = 0x5
	// 80K bytes
	CHIPID_CIDR_SRAMSIZ_80K = 0x6
	// 160K bytes
	CHIPID_CIDR_SRAMSIZ_160K = 0x7
	// 8K bytes
	CHIPID_CIDR_SRAMSIZ_8K = 0x8
	// 16K bytes
	CHIPID_CIDR_SRAMSIZ_16K = 0x9
	// 32K bytes
	CHIPID_CIDR_SRAMSIZ_32K = 0xa
	// 64K bytes
	CHIPID_CIDR_SRAMSIZ_64K = 0xb
	// 128K bytes
	CHIPID_CIDR_SRAMSIZ_128K = 0xc
	// 256K bytes
	CHIPID_CIDR_SRAMSIZ_256K = 0xd
	// 96K bytes
	CHIPID_CIDR_SRAMSIZ_96K = 0xe
	// 512K bytes
	CHIPID_CIDR_SRAMSIZ_512K = 0xf
	// Position of ARCH field.
	CHIPID_CIDR_ARCH_Pos = 0x14
	// Bit mask of ARCH field.
	CHIPID_CIDR_ARCH_Msk = 0xff00000
	// AT91SAM9xx Series
	CHIPID_CIDR_ARCH_AT91SAM9xx = 0x19
	// AT91SAM9XExx Series
	CHIPID_CIDR_ARCH_AT91SAM9XExx = 0x29
	// AT91x34 Series
	CHIPID_CIDR_ARCH_AT91x34 = 0x34
	// CAP7 Series
	CHIPID_CIDR_ARCH_CAP7 = 0x37
	// CAP9 Series
	CHIPID_CIDR_ARCH_CAP9 = 0x39
	// CAP11 Series
	CHIPID_CIDR_ARCH_CAP11 = 0x3b
	// AT91x40 Series
	CHIPID_CIDR_ARCH_AT91x40 = 0x40
	// AT91x42 Series
	CHIPID_CIDR_ARCH_AT91x42 = 0x42
	// AT91x55 Series
	CHIPID_CIDR_ARCH_AT91x55 = 0x55
	// AT91SAM7Axx Series
	CHIPID_CIDR_ARCH_AT91SAM7Axx = 0x60
	// AT91SAM7AQxx Series
	CHIPID_CIDR_ARCH_AT91SAM7AQxx = 0x61
	// AT91x63 Series
	CHIPID_CIDR_ARCH_AT91x63 = 0x63
	// AT91SAM7Sxx Series
	CHIPID_CIDR_ARCH_AT91SAM7Sxx = 0x70
	// AT91SAM7XCxx Series
	CHIPID_CIDR_ARCH_AT91SAM7XCxx = 0x71
	// AT91SAM7SExx Series
	CHIPID_CIDR_ARCH_AT91SAM7SExx = 0x72
	// AT91SAM7Lxx Series
	CHIPID_CIDR_ARCH_AT91SAM7Lxx = 0x73
	// AT91SAM7Xxx Series
	CHIPID_CIDR_ARCH_AT91SAM7Xxx = 0x75
	// AT91SAM7SLxx Series
	CHIPID_CIDR_ARCH_AT91SAM7SLxx = 0x76
	// SAM3UxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3UxC = 0x80
	// SAM3UxE Series (144-pin version)
	CHIPID_CIDR_ARCH_SAM3UxE = 0x81
	// SAM3AxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3AxC = 0x83
	// SAM4AxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM4AxC = 0x83
	// SAM3XxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3XxC = 0x84
	// SAM4XxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM4XxC = 0x84
	// SAM3XxE Series (144-pin version)
	CHIPID_CIDR_ARCH_SAM3XxE = 0x85
	// SAM4XxE Series (144-pin version)
	CHIPID_CIDR_ARCH_SAM4XxE = 0x85
	// SAM3XxG Series (208/217-pin version)
	CHIPID_CIDR_ARCH_SAM3XxG = 0x86
	// SAM4XxG Series (208/217-pin version)
	CHIPID_CIDR_ARCH_SAM4XxG = 0x86
	// SAM3SxASeries (48-pin version)
	CHIPID_CIDR_ARCH_SAM3SxA = 0x88
	// SAM4SxA Series (48-pin version)
	CHIPID_CIDR_ARCH_SAM4SxA = 0x88
	// SAM3SxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM3SxB = 0x89
	// SAM4SxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM4SxB = 0x89
	// SAM3SxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3SxC = 0x8a
	// SAM4SxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM4SxC = 0x8a
	// AT91x92 Series
	CHIPID_CIDR_ARCH_AT91x92 = 0x92
	// SAM3NxA Series (48-pin version)
	CHIPID_CIDR_ARCH_SAM3NxA = 0x93
	// SAM3NxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM3NxB = 0x94
	// SAM3NxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3NxC = 0x95
	// SAM3SDxB Series (64-pin version)
	CHIPID_CIDR_ARCH_SAM3SDxB = 0x99
	// SAM3SDxC Series (100-pin version)
	CHIPID_CIDR_ARCH_SAM3SDxC = 0x9a
	// SAM5A
	CHIPID_CIDR_ARCH_SAM5A = 0xa5
	// AT75Cxx Series
	CHIPID_CIDR_ARCH_AT75Cxx = 0xf0
	// Position of NVPTYP field.
	CHIPID_CIDR_NVPTYP_Pos = 0x1c
	// Bit mask of NVPTYP field.
	CHIPID_CIDR_NVPTYP_Msk = 0x70000000
	// ROM
	CHIPID_CIDR_NVPTYP_ROM = 0x0
	// ROMless or on-chip Flash
	CHIPID_CIDR_NVPTYP_ROMLESS = 0x1
	// Embedded Flash Memory
	CHIPID_CIDR_NVPTYP_FLASH = 0x2
	// ROM and Embedded Flash MemoryNVPSIZ is ROM size NVPSIZ2 is Flash size
	CHIPID_CIDR_NVPTYP_ROM_FLASH = 0x3
	// SRAM emulating ROM
	CHIPID_CIDR_NVPTYP_SRAM = 0x4
	// Position of EXT field.
	CHIPID_CIDR_EXT_Pos = 0x1f
	// Bit mask of EXT field.
	CHIPID_CIDR_EXT_Msk = 0x80000000
	// Bit EXT.
	CHIPID_CIDR_EXT = 0x80000000

	// EXID: Chip ID Extension Register
	// Position of EXID field.
	CHIPID_EXID_EXID_Pos = 0x0
	// Bit mask of EXID field.
	CHIPID_EXID_EXID_Msk = 0xffffffff
)

// Constants for EFC: Embedded Flash Controller
const (
	// FMR: EEFC Flash Mode Register
	// Position of FRDY field.
	EFC_FMR_FRDY_Pos = 0x0
	// Bit mask of FRDY field.
	EFC_FMR_FRDY_Msk = 0x1
	// Bit FRDY.
	EFC_FMR_FRDY = 0x1
	// Position of FWS field.
	EFC_FMR_FWS_Pos = 0x8
	// Bit mask of FWS field.
	EFC_FMR_FWS_Msk = 0xf00
	// Position of SCOD field.
	EFC_FMR_SCOD_Pos = 0x10
	// Bit mask of SCOD field.
	EFC_FMR_SCOD_Msk = 0x10000
	// Bit SCOD.
	EFC_FMR_SCOD = 0x10000
	// Position of FAM field.
	EFC_FMR_FAM_Pos = 0x18
	// Bit mask of FAM field.
	EFC_FMR_FAM_Msk = 0x1000000
	// Bit FAM.
	EFC_FMR_FAM = 0x1000000

	// FCR: EEFC Flash Command Register
	// Position of FCMD field.
	EFC_FCR_FCMD_Pos = 0x0
	// Bit mask of FCMD field.
	EFC_FCR_FCMD_Msk = 0xff
	// Get Flash Descriptor
	EFC_FCR_FCMD_GETD = 0x0
	// Write page
	EFC_FCR_FCMD_WP = 0x1
	// Write page and lock
	EFC_FCR_FCMD_WPL = 0x2
	// Erase page and write page
	EFC_FCR_FCMD_EWP = 0x3
	// Erase page and write page then lock
	EFC_FCR_FCMD_EWPL = 0x4
	// Erase all
	EFC_FCR_FCMD_EA = 0x5
	// Set Lock Bit
	EFC_FCR_FCMD_SLB = 0x8
	// Clear Lock Bit
	EFC_FCR_FCMD_CLB = 0x9
	// Get Lock Bit
	EFC_FCR_FCMD_GLB = 0xa
	// Set GPNVM Bit
	EFC_FCR_FCMD_SGPB = 0xb
	// Clear GPNVM Bit
	EFC_FCR_FCMD_CGPB = 0xc
	// Get GPNVM Bit
	EFC_FCR_FCMD_GGPB = 0xd
	// Start Read Unique Identifier
	EFC_FCR_FCMD_STUI = 0xe
	// Stop Read Unique Identifier
	EFC_FCR_FCMD_SPUI = 0xf
	// Get CALIB Bit
	EFC_FCR_FCMD_GCALB = 0x10
	// Position of FARG field.
	EFC_FCR_FARG_Pos = 0x8
	// Bit mask of FARG field.
	EFC_FCR_FARG_Msk = 0xffff00
	// Position of FKEY field.
	EFC_FCR_FKEY_Pos = 0x18
	// Bit mask of FKEY field.
	EFC_FCR_FKEY_Msk = 0xff000000
	// The 0x5A value enables the command defined by the bits of the register. If the field is written with a different value, the write is not performed and no action is started.
	EFC_FCR_FKEY_PASSWD = 0x5a

	// FSR: EEFC Flash Status Register
	// Position of FRDY field.
	EFC_FSR_FRDY_Pos = 0x0
	// Bit mask of FRDY field.
	EFC_FSR_FRDY_Msk = 0x1
	// Bit FRDY.
	EFC_FSR_FRDY = 0x1
	// Position of FCMDE field.
	EFC_FSR_FCMDE_Pos = 0x1
	// Bit mask of FCMDE field.
	EFC_FSR_FCMDE_Msk = 0x2
	// Bit FCMDE.
	EFC_FSR_FCMDE = 0x2
	// Position of FLOCKE field.
	EFC_FSR_FLOCKE_Pos = 0x2
	// Bit mask of FLOCKE field.
	EFC_FSR_FLOCKE_Msk = 0x4
	// Bit FLOCKE.
	EFC_FSR_FLOCKE = 0x4

	// FRR: EEFC Flash Result Register
	// Position of FVALUE field.
	EFC_FRR_FVALUE_Pos = 0x0
	// Bit mask of FVALUE field.
	EFC_FRR_FVALUE_Msk = 0xffffffff
)

// Constants for PIOA: Parallel Input/Output Controller A
const (
	// PER: PIO Enable Register
	// Position of P0 field.
	PIO_PER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PER_P0_Msk = 0x1
	// Bit P0.
	PIO_PER_P0 = 0x1
	// Position of P1 field.
	PIO_PER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PER_P1_Msk = 0x2
	// Bit P1.
	PIO_PER_P1 = 0x2
	// Position of P2 field.
	PIO_PER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PER_P2_Msk = 0x4
	// Bit P2.
	PIO_PER_P2 = 0x4
	// Position of P3 field.
	PIO_PER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PER_P3_Msk = 0x8
	// Bit P3.
	PIO_PER_P3 = 0x8
	// Position of P4 field.
	PIO_PER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PER_P4_Msk = 0x10
	// Bit P4.
	PIO_PER_P4 = 0x10
	// Position of P5 field.
	PIO_PER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PER_P5_Msk = 0x20
	// Bit P5.
	PIO_PER_P5 = 0x20
	// Position of P6 field.
	PIO_PER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PER_P6_Msk = 0x40
	// Bit P6.
	PIO_PER_P6 = 0x40
	// Position of P7 field.
	PIO_PER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PER_P7_Msk = 0x80
	// Bit P7.
	PIO_PER_P7 = 0x80
	// Position of P8 field.
	PIO_PER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PER_P8_Msk = 0x100
	// Bit P8.
	PIO_PER_P8 = 0x100
	// Position of P9 field.
	PIO_PER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PER_P9_Msk = 0x200
	// Bit P9.
	PIO_PER_P9 = 0x200
	// Position of P10 field.
	PIO_PER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PER_P10_Msk = 0x400
	// Bit P10.
	PIO_PER_P10 = 0x400
	// Position of P11 field.
	PIO_PER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PER_P11_Msk = 0x800
	// Bit P11.
	PIO_PER_P11 = 0x800
	// Position of P12 field.
	PIO_PER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PER_P12 = 0x1000
	// Position of P13 field.
	PIO_PER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PER_P13 = 0x2000
	// Position of P14 field.
	PIO_PER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PER_P14 = 0x4000
	// Position of P15 field.
	PIO_PER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PER_P15 = 0x8000
	// Position of P16 field.
	PIO_PER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PER_P16 = 0x10000
	// Position of P17 field.
	PIO_PER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PER_P17 = 0x20000
	// Position of P18 field.
	PIO_PER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PER_P18 = 0x40000
	// Position of P19 field.
	PIO_PER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PER_P19 = 0x80000
	// Position of P20 field.
	PIO_PER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PER_P20 = 0x100000
	// Position of P21 field.
	PIO_PER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PER_P21 = 0x200000
	// Position of P22 field.
	PIO_PER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PER_P22 = 0x400000
	// Position of P23 field.
	PIO_PER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PER_P23 = 0x800000
	// Position of P24 field.
	PIO_PER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PER_P31 = 0x80000000

	// PDR: PIO Disable Register
	// Position of P0 field.
	PIO_PDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDR_P0 = 0x1
	// Position of P1 field.
	PIO_PDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDR_P1 = 0x2
	// Position of P2 field.
	PIO_PDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDR_P2 = 0x4
	// Position of P3 field.
	PIO_PDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDR_P3 = 0x8
	// Position of P4 field.
	PIO_PDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDR_P4 = 0x10
	// Position of P5 field.
	PIO_PDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDR_P5 = 0x20
	// Position of P6 field.
	PIO_PDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDR_P6 = 0x40
	// Position of P7 field.
	PIO_PDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDR_P7 = 0x80
	// Position of P8 field.
	PIO_PDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDR_P8 = 0x100
	// Position of P9 field.
	PIO_PDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDR_P9 = 0x200
	// Position of P10 field.
	PIO_PDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDR_P10 = 0x400
	// Position of P11 field.
	PIO_PDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDR_P11 = 0x800
	// Position of P12 field.
	PIO_PDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDR_P31 = 0x80000000

	// PSR: PIO Status Register
	// Position of P0 field.
	PIO_PSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PSR_P0 = 0x1
	// Position of P1 field.
	PIO_PSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PSR_P1 = 0x2
	// Position of P2 field.
	PIO_PSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PSR_P2 = 0x4
	// Position of P3 field.
	PIO_PSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PSR_P3 = 0x8
	// Position of P4 field.
	PIO_PSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PSR_P4 = 0x10
	// Position of P5 field.
	PIO_PSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PSR_P5 = 0x20
	// Position of P6 field.
	PIO_PSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PSR_P6 = 0x40
	// Position of P7 field.
	PIO_PSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PSR_P7 = 0x80
	// Position of P8 field.
	PIO_PSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PSR_P8 = 0x100
	// Position of P9 field.
	PIO_PSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PSR_P9 = 0x200
	// Position of P10 field.
	PIO_PSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PSR_P10 = 0x400
	// Position of P11 field.
	PIO_PSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PSR_P11 = 0x800
	// Position of P12 field.
	PIO_PSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PSR_P31 = 0x80000000

	// OER: Output Enable Register
	// Position of P0 field.
	PIO_OER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OER_P0_Msk = 0x1
	// Bit P0.
	PIO_OER_P0 = 0x1
	// Position of P1 field.
	PIO_OER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OER_P1_Msk = 0x2
	// Bit P1.
	PIO_OER_P1 = 0x2
	// Position of P2 field.
	PIO_OER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OER_P2_Msk = 0x4
	// Bit P2.
	PIO_OER_P2 = 0x4
	// Position of P3 field.
	PIO_OER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OER_P3_Msk = 0x8
	// Bit P3.
	PIO_OER_P3 = 0x8
	// Position of P4 field.
	PIO_OER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OER_P4_Msk = 0x10
	// Bit P4.
	PIO_OER_P4 = 0x10
	// Position of P5 field.
	PIO_OER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OER_P5_Msk = 0x20
	// Bit P5.
	PIO_OER_P5 = 0x20
	// Position of P6 field.
	PIO_OER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OER_P6_Msk = 0x40
	// Bit P6.
	PIO_OER_P6 = 0x40
	// Position of P7 field.
	PIO_OER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OER_P7_Msk = 0x80
	// Bit P7.
	PIO_OER_P7 = 0x80
	// Position of P8 field.
	PIO_OER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OER_P8_Msk = 0x100
	// Bit P8.
	PIO_OER_P8 = 0x100
	// Position of P9 field.
	PIO_OER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OER_P9_Msk = 0x200
	// Bit P9.
	PIO_OER_P9 = 0x200
	// Position of P10 field.
	PIO_OER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OER_P10_Msk = 0x400
	// Bit P10.
	PIO_OER_P10 = 0x400
	// Position of P11 field.
	PIO_OER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OER_P11_Msk = 0x800
	// Bit P11.
	PIO_OER_P11 = 0x800
	// Position of P12 field.
	PIO_OER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OER_P12 = 0x1000
	// Position of P13 field.
	PIO_OER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OER_P13 = 0x2000
	// Position of P14 field.
	PIO_OER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OER_P14 = 0x4000
	// Position of P15 field.
	PIO_OER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OER_P15 = 0x8000
	// Position of P16 field.
	PIO_OER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OER_P16 = 0x10000
	// Position of P17 field.
	PIO_OER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OER_P17 = 0x20000
	// Position of P18 field.
	PIO_OER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OER_P18 = 0x40000
	// Position of P19 field.
	PIO_OER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OER_P19 = 0x80000
	// Position of P20 field.
	PIO_OER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OER_P20 = 0x100000
	// Position of P21 field.
	PIO_OER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OER_P21 = 0x200000
	// Position of P22 field.
	PIO_OER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OER_P22 = 0x400000
	// Position of P23 field.
	PIO_OER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OER_P23 = 0x800000
	// Position of P24 field.
	PIO_OER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OER_P31 = 0x80000000

	// ODR: Output Disable Register
	// Position of P0 field.
	PIO_ODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODR_P0 = 0x1
	// Position of P1 field.
	PIO_ODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODR_P1 = 0x2
	// Position of P2 field.
	PIO_ODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODR_P2 = 0x4
	// Position of P3 field.
	PIO_ODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODR_P3 = 0x8
	// Position of P4 field.
	PIO_ODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODR_P4 = 0x10
	// Position of P5 field.
	PIO_ODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODR_P5 = 0x20
	// Position of P6 field.
	PIO_ODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODR_P6 = 0x40
	// Position of P7 field.
	PIO_ODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODR_P7 = 0x80
	// Position of P8 field.
	PIO_ODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODR_P8 = 0x100
	// Position of P9 field.
	PIO_ODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODR_P9 = 0x200
	// Position of P10 field.
	PIO_ODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODR_P10 = 0x400
	// Position of P11 field.
	PIO_ODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODR_P11 = 0x800
	// Position of P12 field.
	PIO_ODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODR_P31 = 0x80000000

	// OSR: Output Status Register
	// Position of P0 field.
	PIO_OSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OSR_P0 = 0x1
	// Position of P1 field.
	PIO_OSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OSR_P1 = 0x2
	// Position of P2 field.
	PIO_OSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OSR_P2 = 0x4
	// Position of P3 field.
	PIO_OSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OSR_P3 = 0x8
	// Position of P4 field.
	PIO_OSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OSR_P4 = 0x10
	// Position of P5 field.
	PIO_OSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OSR_P5 = 0x20
	// Position of P6 field.
	PIO_OSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OSR_P6 = 0x40
	// Position of P7 field.
	PIO_OSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OSR_P7 = 0x80
	// Position of P8 field.
	PIO_OSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OSR_P8 = 0x100
	// Position of P9 field.
	PIO_OSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OSR_P9 = 0x200
	// Position of P10 field.
	PIO_OSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OSR_P10 = 0x400
	// Position of P11 field.
	PIO_OSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OSR_P11 = 0x800
	// Position of P12 field.
	PIO_OSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OSR_P31 = 0x80000000

	// IFER: Glitch Input Filter Enable Register
	// Position of P0 field.
	PIO_IFER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFER_P0_Msk = 0x1
	// Bit P0.
	PIO_IFER_P0 = 0x1
	// Position of P1 field.
	PIO_IFER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFER_P1_Msk = 0x2
	// Bit P1.
	PIO_IFER_P1 = 0x2
	// Position of P2 field.
	PIO_IFER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFER_P2_Msk = 0x4
	// Bit P2.
	PIO_IFER_P2 = 0x4
	// Position of P3 field.
	PIO_IFER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFER_P3_Msk = 0x8
	// Bit P3.
	PIO_IFER_P3 = 0x8
	// Position of P4 field.
	PIO_IFER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFER_P4_Msk = 0x10
	// Bit P4.
	PIO_IFER_P4 = 0x10
	// Position of P5 field.
	PIO_IFER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFER_P5_Msk = 0x20
	// Bit P5.
	PIO_IFER_P5 = 0x20
	// Position of P6 field.
	PIO_IFER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFER_P6_Msk = 0x40
	// Bit P6.
	PIO_IFER_P6 = 0x40
	// Position of P7 field.
	PIO_IFER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFER_P7_Msk = 0x80
	// Bit P7.
	PIO_IFER_P7 = 0x80
	// Position of P8 field.
	PIO_IFER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFER_P8_Msk = 0x100
	// Bit P8.
	PIO_IFER_P8 = 0x100
	// Position of P9 field.
	PIO_IFER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFER_P9_Msk = 0x200
	// Bit P9.
	PIO_IFER_P9 = 0x200
	// Position of P10 field.
	PIO_IFER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFER_P10_Msk = 0x400
	// Bit P10.
	PIO_IFER_P10 = 0x400
	// Position of P11 field.
	PIO_IFER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFER_P11_Msk = 0x800
	// Bit P11.
	PIO_IFER_P11 = 0x800
	// Position of P12 field.
	PIO_IFER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFER_P12 = 0x1000
	// Position of P13 field.
	PIO_IFER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFER_P13 = 0x2000
	// Position of P14 field.
	PIO_IFER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFER_P14 = 0x4000
	// Position of P15 field.
	PIO_IFER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFER_P15 = 0x8000
	// Position of P16 field.
	PIO_IFER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFER_P16 = 0x10000
	// Position of P17 field.
	PIO_IFER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFER_P17 = 0x20000
	// Position of P18 field.
	PIO_IFER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFER_P18 = 0x40000
	// Position of P19 field.
	PIO_IFER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFER_P19 = 0x80000
	// Position of P20 field.
	PIO_IFER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFER_P20 = 0x100000
	// Position of P21 field.
	PIO_IFER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFER_P21 = 0x200000
	// Position of P22 field.
	PIO_IFER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFER_P22 = 0x400000
	// Position of P23 field.
	PIO_IFER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFER_P23 = 0x800000
	// Position of P24 field.
	PIO_IFER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFER_P31 = 0x80000000

	// IFDR: Glitch Input Filter Disable Register
	// Position of P0 field.
	PIO_IFDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFDR_P0 = 0x1
	// Position of P1 field.
	PIO_IFDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFDR_P1 = 0x2
	// Position of P2 field.
	PIO_IFDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFDR_P2 = 0x4
	// Position of P3 field.
	PIO_IFDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFDR_P3 = 0x8
	// Position of P4 field.
	PIO_IFDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFDR_P4 = 0x10
	// Position of P5 field.
	PIO_IFDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFDR_P5 = 0x20
	// Position of P6 field.
	PIO_IFDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFDR_P6 = 0x40
	// Position of P7 field.
	PIO_IFDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFDR_P7 = 0x80
	// Position of P8 field.
	PIO_IFDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFDR_P8 = 0x100
	// Position of P9 field.
	PIO_IFDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFDR_P9 = 0x200
	// Position of P10 field.
	PIO_IFDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFDR_P10 = 0x400
	// Position of P11 field.
	PIO_IFDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFDR_P11 = 0x800
	// Position of P12 field.
	PIO_IFDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFDR_P31 = 0x80000000

	// IFSR: Glitch Input Filter Status Register
	// Position of P0 field.
	PIO_IFSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSR_P0 = 0x1
	// Position of P1 field.
	PIO_IFSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSR_P1 = 0x2
	// Position of P2 field.
	PIO_IFSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSR_P2 = 0x4
	// Position of P3 field.
	PIO_IFSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSR_P3 = 0x8
	// Position of P4 field.
	PIO_IFSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSR_P4 = 0x10
	// Position of P5 field.
	PIO_IFSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSR_P5 = 0x20
	// Position of P6 field.
	PIO_IFSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSR_P6 = 0x40
	// Position of P7 field.
	PIO_IFSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSR_P7 = 0x80
	// Position of P8 field.
	PIO_IFSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSR_P8 = 0x100
	// Position of P9 field.
	PIO_IFSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSR_P9 = 0x200
	// Position of P10 field.
	PIO_IFSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSR_P10 = 0x400
	// Position of P11 field.
	PIO_IFSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSR_P11 = 0x800
	// Position of P12 field.
	PIO_IFSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSR_P31 = 0x80000000

	// SODR: Set Output Data Register
	// Position of P0 field.
	PIO_SODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_SODR_P0_Msk = 0x1
	// Bit P0.
	PIO_SODR_P0 = 0x1
	// Position of P1 field.
	PIO_SODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_SODR_P1_Msk = 0x2
	// Bit P1.
	PIO_SODR_P1 = 0x2
	// Position of P2 field.
	PIO_SODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_SODR_P2_Msk = 0x4
	// Bit P2.
	PIO_SODR_P2 = 0x4
	// Position of P3 field.
	PIO_SODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_SODR_P3_Msk = 0x8
	// Bit P3.
	PIO_SODR_P3 = 0x8
	// Position of P4 field.
	PIO_SODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_SODR_P4_Msk = 0x10
	// Bit P4.
	PIO_SODR_P4 = 0x10
	// Position of P5 field.
	PIO_SODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_SODR_P5_Msk = 0x20
	// Bit P5.
	PIO_SODR_P5 = 0x20
	// Position of P6 field.
	PIO_SODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_SODR_P6_Msk = 0x40
	// Bit P6.
	PIO_SODR_P6 = 0x40
	// Position of P7 field.
	PIO_SODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_SODR_P7_Msk = 0x80
	// Bit P7.
	PIO_SODR_P7 = 0x80
	// Position of P8 field.
	PIO_SODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_SODR_P8_Msk = 0x100
	// Bit P8.
	PIO_SODR_P8 = 0x100
	// Position of P9 field.
	PIO_SODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_SODR_P9_Msk = 0x200
	// Bit P9.
	PIO_SODR_P9 = 0x200
	// Position of P10 field.
	PIO_SODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_SODR_P10_Msk = 0x400
	// Bit P10.
	PIO_SODR_P10 = 0x400
	// Position of P11 field.
	PIO_SODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_SODR_P11_Msk = 0x800
	// Bit P11.
	PIO_SODR_P11 = 0x800
	// Position of P12 field.
	PIO_SODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_SODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_SODR_P12 = 0x1000
	// Position of P13 field.
	PIO_SODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_SODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_SODR_P13 = 0x2000
	// Position of P14 field.
	PIO_SODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_SODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_SODR_P14 = 0x4000
	// Position of P15 field.
	PIO_SODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_SODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_SODR_P15 = 0x8000
	// Position of P16 field.
	PIO_SODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_SODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_SODR_P16 = 0x10000
	// Position of P17 field.
	PIO_SODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_SODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_SODR_P17 = 0x20000
	// Position of P18 field.
	PIO_SODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_SODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_SODR_P18 = 0x40000
	// Position of P19 field.
	PIO_SODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_SODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_SODR_P19 = 0x80000
	// Position of P20 field.
	PIO_SODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_SODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_SODR_P20 = 0x100000
	// Position of P21 field.
	PIO_SODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_SODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_SODR_P21 = 0x200000
	// Position of P22 field.
	PIO_SODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_SODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_SODR_P22 = 0x400000
	// Position of P23 field.
	PIO_SODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_SODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_SODR_P23 = 0x800000
	// Position of P24 field.
	PIO_SODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_SODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_SODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_SODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_SODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_SODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_SODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_SODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_SODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_SODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_SODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_SODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_SODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_SODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_SODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_SODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_SODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_SODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_SODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_SODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_SODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_SODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_SODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_SODR_P31 = 0x80000000

	// CODR: Clear Output Data Register
	// Position of P0 field.
	PIO_CODR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_CODR_P0_Msk = 0x1
	// Bit P0.
	PIO_CODR_P0 = 0x1
	// Position of P1 field.
	PIO_CODR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_CODR_P1_Msk = 0x2
	// Bit P1.
	PIO_CODR_P1 = 0x2
	// Position of P2 field.
	PIO_CODR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_CODR_P2_Msk = 0x4
	// Bit P2.
	PIO_CODR_P2 = 0x4
	// Position of P3 field.
	PIO_CODR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_CODR_P3_Msk = 0x8
	// Bit P3.
	PIO_CODR_P3 = 0x8
	// Position of P4 field.
	PIO_CODR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_CODR_P4_Msk = 0x10
	// Bit P4.
	PIO_CODR_P4 = 0x10
	// Position of P5 field.
	PIO_CODR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_CODR_P5_Msk = 0x20
	// Bit P5.
	PIO_CODR_P5 = 0x20
	// Position of P6 field.
	PIO_CODR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_CODR_P6_Msk = 0x40
	// Bit P6.
	PIO_CODR_P6 = 0x40
	// Position of P7 field.
	PIO_CODR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_CODR_P7_Msk = 0x80
	// Bit P7.
	PIO_CODR_P7 = 0x80
	// Position of P8 field.
	PIO_CODR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_CODR_P8_Msk = 0x100
	// Bit P8.
	PIO_CODR_P8 = 0x100
	// Position of P9 field.
	PIO_CODR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_CODR_P9_Msk = 0x200
	// Bit P9.
	PIO_CODR_P9 = 0x200
	// Position of P10 field.
	PIO_CODR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_CODR_P10_Msk = 0x400
	// Bit P10.
	PIO_CODR_P10 = 0x400
	// Position of P11 field.
	PIO_CODR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_CODR_P11_Msk = 0x800
	// Bit P11.
	PIO_CODR_P11 = 0x800
	// Position of P12 field.
	PIO_CODR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_CODR_P12_Msk = 0x1000
	// Bit P12.
	PIO_CODR_P12 = 0x1000
	// Position of P13 field.
	PIO_CODR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_CODR_P13_Msk = 0x2000
	// Bit P13.
	PIO_CODR_P13 = 0x2000
	// Position of P14 field.
	PIO_CODR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_CODR_P14_Msk = 0x4000
	// Bit P14.
	PIO_CODR_P14 = 0x4000
	// Position of P15 field.
	PIO_CODR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_CODR_P15_Msk = 0x8000
	// Bit P15.
	PIO_CODR_P15 = 0x8000
	// Position of P16 field.
	PIO_CODR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_CODR_P16_Msk = 0x10000
	// Bit P16.
	PIO_CODR_P16 = 0x10000
	// Position of P17 field.
	PIO_CODR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_CODR_P17_Msk = 0x20000
	// Bit P17.
	PIO_CODR_P17 = 0x20000
	// Position of P18 field.
	PIO_CODR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_CODR_P18_Msk = 0x40000
	// Bit P18.
	PIO_CODR_P18 = 0x40000
	// Position of P19 field.
	PIO_CODR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_CODR_P19_Msk = 0x80000
	// Bit P19.
	PIO_CODR_P19 = 0x80000
	// Position of P20 field.
	PIO_CODR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_CODR_P20_Msk = 0x100000
	// Bit P20.
	PIO_CODR_P20 = 0x100000
	// Position of P21 field.
	PIO_CODR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_CODR_P21_Msk = 0x200000
	// Bit P21.
	PIO_CODR_P21 = 0x200000
	// Position of P22 field.
	PIO_CODR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_CODR_P22_Msk = 0x400000
	// Bit P22.
	PIO_CODR_P22 = 0x400000
	// Position of P23 field.
	PIO_CODR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_CODR_P23_Msk = 0x800000
	// Bit P23.
	PIO_CODR_P23 = 0x800000
	// Position of P24 field.
	PIO_CODR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_CODR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_CODR_P24 = 0x1000000
	// Position of P25 field.
	PIO_CODR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_CODR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_CODR_P25 = 0x2000000
	// Position of P26 field.
	PIO_CODR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_CODR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_CODR_P26 = 0x4000000
	// Position of P27 field.
	PIO_CODR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_CODR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_CODR_P27 = 0x8000000
	// Position of P28 field.
	PIO_CODR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_CODR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_CODR_P28 = 0x10000000
	// Position of P29 field.
	PIO_CODR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_CODR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_CODR_P29 = 0x20000000
	// Position of P30 field.
	PIO_CODR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_CODR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_CODR_P30 = 0x40000000
	// Position of P31 field.
	PIO_CODR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_CODR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_CODR_P31 = 0x80000000

	// ODSR: Output Data Status Register
	// Position of P0 field.
	PIO_ODSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ODSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ODSR_P0 = 0x1
	// Position of P1 field.
	PIO_ODSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ODSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ODSR_P1 = 0x2
	// Position of P2 field.
	PIO_ODSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ODSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ODSR_P2 = 0x4
	// Position of P3 field.
	PIO_ODSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ODSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ODSR_P3 = 0x8
	// Position of P4 field.
	PIO_ODSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ODSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ODSR_P4 = 0x10
	// Position of P5 field.
	PIO_ODSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ODSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ODSR_P5 = 0x20
	// Position of P6 field.
	PIO_ODSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ODSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ODSR_P6 = 0x40
	// Position of P7 field.
	PIO_ODSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ODSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ODSR_P7 = 0x80
	// Position of P8 field.
	PIO_ODSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ODSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ODSR_P8 = 0x100
	// Position of P9 field.
	PIO_ODSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ODSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ODSR_P9 = 0x200
	// Position of P10 field.
	PIO_ODSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ODSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ODSR_P10 = 0x400
	// Position of P11 field.
	PIO_ODSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ODSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ODSR_P11 = 0x800
	// Position of P12 field.
	PIO_ODSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ODSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ODSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ODSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ODSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ODSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ODSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ODSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ODSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ODSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ODSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ODSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ODSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ODSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ODSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ODSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ODSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ODSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ODSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ODSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ODSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ODSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ODSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ODSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ODSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ODSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ODSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ODSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ODSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ODSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ODSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ODSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ODSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ODSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ODSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ODSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ODSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ODSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ODSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ODSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ODSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ODSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ODSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ODSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ODSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ODSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ODSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ODSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ODSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ODSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ODSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ODSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ODSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ODSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ODSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ODSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ODSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ODSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ODSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ODSR_P31 = 0x80000000

	// PDSR: Pin Data Status Register
	// Position of P0 field.
	PIO_PDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PDSR_P0 = 0x1
	// Position of P1 field.
	PIO_PDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PDSR_P1 = 0x2
	// Position of P2 field.
	PIO_PDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PDSR_P2 = 0x4
	// Position of P3 field.
	PIO_PDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PDSR_P3 = 0x8
	// Position of P4 field.
	PIO_PDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PDSR_P4 = 0x10
	// Position of P5 field.
	PIO_PDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PDSR_P5 = 0x20
	// Position of P6 field.
	PIO_PDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PDSR_P6 = 0x40
	// Position of P7 field.
	PIO_PDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PDSR_P7 = 0x80
	// Position of P8 field.
	PIO_PDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PDSR_P8 = 0x100
	// Position of P9 field.
	PIO_PDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PDSR_P9 = 0x200
	// Position of P10 field.
	PIO_PDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PDSR_P10 = 0x400
	// Position of P11 field.
	PIO_PDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PDSR_P11 = 0x800
	// Position of P12 field.
	PIO_PDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PDSR_P31 = 0x80000000

	// IER: Interrupt Enable Register
	// Position of P0 field.
	PIO_IER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IER_P0_Msk = 0x1
	// Bit P0.
	PIO_IER_P0 = 0x1
	// Position of P1 field.
	PIO_IER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IER_P1_Msk = 0x2
	// Bit P1.
	PIO_IER_P1 = 0x2
	// Position of P2 field.
	PIO_IER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IER_P2_Msk = 0x4
	// Bit P2.
	PIO_IER_P2 = 0x4
	// Position of P3 field.
	PIO_IER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IER_P3_Msk = 0x8
	// Bit P3.
	PIO_IER_P3 = 0x8
	// Position of P4 field.
	PIO_IER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IER_P4_Msk = 0x10
	// Bit P4.
	PIO_IER_P4 = 0x10
	// Position of P5 field.
	PIO_IER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IER_P5_Msk = 0x20
	// Bit P5.
	PIO_IER_P5 = 0x20
	// Position of P6 field.
	PIO_IER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IER_P6_Msk = 0x40
	// Bit P6.
	PIO_IER_P6 = 0x40
	// Position of P7 field.
	PIO_IER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IER_P7_Msk = 0x80
	// Bit P7.
	PIO_IER_P7 = 0x80
	// Position of P8 field.
	PIO_IER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IER_P8_Msk = 0x100
	// Bit P8.
	PIO_IER_P8 = 0x100
	// Position of P9 field.
	PIO_IER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IER_P9_Msk = 0x200
	// Bit P9.
	PIO_IER_P9 = 0x200
	// Position of P10 field.
	PIO_IER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IER_P10_Msk = 0x400
	// Bit P10.
	PIO_IER_P10 = 0x400
	// Position of P11 field.
	PIO_IER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IER_P11_Msk = 0x800
	// Bit P11.
	PIO_IER_P11 = 0x800
	// Position of P12 field.
	PIO_IER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IER_P12 = 0x1000
	// Position of P13 field.
	PIO_IER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IER_P13 = 0x2000
	// Position of P14 field.
	PIO_IER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IER_P14 = 0x4000
	// Position of P15 field.
	PIO_IER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IER_P15 = 0x8000
	// Position of P16 field.
	PIO_IER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IER_P16 = 0x10000
	// Position of P17 field.
	PIO_IER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IER_P17 = 0x20000
	// Position of P18 field.
	PIO_IER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IER_P18 = 0x40000
	// Position of P19 field.
	PIO_IER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IER_P19 = 0x80000
	// Position of P20 field.
	PIO_IER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IER_P20 = 0x100000
	// Position of P21 field.
	PIO_IER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IER_P21 = 0x200000
	// Position of P22 field.
	PIO_IER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IER_P22 = 0x400000
	// Position of P23 field.
	PIO_IER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IER_P23 = 0x800000
	// Position of P24 field.
	PIO_IER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IER_P31 = 0x80000000

	// IDR: Interrupt Disable Register
	// Position of P0 field.
	PIO_IDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IDR_P0 = 0x1
	// Position of P1 field.
	PIO_IDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IDR_P1 = 0x2
	// Position of P2 field.
	PIO_IDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IDR_P2 = 0x4
	// Position of P3 field.
	PIO_IDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IDR_P3 = 0x8
	// Position of P4 field.
	PIO_IDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IDR_P4 = 0x10
	// Position of P5 field.
	PIO_IDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IDR_P5 = 0x20
	// Position of P6 field.
	PIO_IDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IDR_P6 = 0x40
	// Position of P7 field.
	PIO_IDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IDR_P7 = 0x80
	// Position of P8 field.
	PIO_IDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IDR_P8 = 0x100
	// Position of P9 field.
	PIO_IDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IDR_P9 = 0x200
	// Position of P10 field.
	PIO_IDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IDR_P10 = 0x400
	// Position of P11 field.
	PIO_IDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IDR_P11 = 0x800
	// Position of P12 field.
	PIO_IDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IDR_P31 = 0x80000000

	// IMR: Interrupt Mask Register
	// Position of P0 field.
	PIO_IMR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IMR_P0_Msk = 0x1
	// Bit P0.
	PIO_IMR_P0 = 0x1
	// Position of P1 field.
	PIO_IMR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IMR_P1_Msk = 0x2
	// Bit P1.
	PIO_IMR_P1 = 0x2
	// Position of P2 field.
	PIO_IMR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IMR_P2_Msk = 0x4
	// Bit P2.
	PIO_IMR_P2 = 0x4
	// Position of P3 field.
	PIO_IMR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IMR_P3_Msk = 0x8
	// Bit P3.
	PIO_IMR_P3 = 0x8
	// Position of P4 field.
	PIO_IMR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IMR_P4_Msk = 0x10
	// Bit P4.
	PIO_IMR_P4 = 0x10
	// Position of P5 field.
	PIO_IMR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IMR_P5_Msk = 0x20
	// Bit P5.
	PIO_IMR_P5 = 0x20
	// Position of P6 field.
	PIO_IMR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IMR_P6_Msk = 0x40
	// Bit P6.
	PIO_IMR_P6 = 0x40
	// Position of P7 field.
	PIO_IMR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IMR_P7_Msk = 0x80
	// Bit P7.
	PIO_IMR_P7 = 0x80
	// Position of P8 field.
	PIO_IMR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IMR_P8_Msk = 0x100
	// Bit P8.
	PIO_IMR_P8 = 0x100
	// Position of P9 field.
	PIO_IMR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IMR_P9_Msk = 0x200
	// Bit P9.
	PIO_IMR_P9 = 0x200
	// Position of P10 field.
	PIO_IMR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IMR_P10_Msk = 0x400
	// Bit P10.
	PIO_IMR_P10 = 0x400
	// Position of P11 field.
	PIO_IMR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IMR_P11_Msk = 0x800
	// Bit P11.
	PIO_IMR_P11 = 0x800
	// Position of P12 field.
	PIO_IMR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IMR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IMR_P12 = 0x1000
	// Position of P13 field.
	PIO_IMR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IMR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IMR_P13 = 0x2000
	// Position of P14 field.
	PIO_IMR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IMR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IMR_P14 = 0x4000
	// Position of P15 field.
	PIO_IMR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IMR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IMR_P15 = 0x8000
	// Position of P16 field.
	PIO_IMR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IMR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IMR_P16 = 0x10000
	// Position of P17 field.
	PIO_IMR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IMR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IMR_P17 = 0x20000
	// Position of P18 field.
	PIO_IMR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IMR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IMR_P18 = 0x40000
	// Position of P19 field.
	PIO_IMR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IMR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IMR_P19 = 0x80000
	// Position of P20 field.
	PIO_IMR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IMR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IMR_P20 = 0x100000
	// Position of P21 field.
	PIO_IMR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IMR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IMR_P21 = 0x200000
	// Position of P22 field.
	PIO_IMR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IMR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IMR_P22 = 0x400000
	// Position of P23 field.
	PIO_IMR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IMR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IMR_P23 = 0x800000
	// Position of P24 field.
	PIO_IMR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IMR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IMR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IMR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IMR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IMR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IMR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IMR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IMR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IMR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IMR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IMR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IMR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IMR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IMR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IMR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IMR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IMR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IMR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IMR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IMR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IMR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IMR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IMR_P31 = 0x80000000

	// ISR: Interrupt Status Register
	// Position of P0 field.
	PIO_ISR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ISR_P0_Msk = 0x1
	// Bit P0.
	PIO_ISR_P0 = 0x1
	// Position of P1 field.
	PIO_ISR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ISR_P1_Msk = 0x2
	// Bit P1.
	PIO_ISR_P1 = 0x2
	// Position of P2 field.
	PIO_ISR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ISR_P2_Msk = 0x4
	// Bit P2.
	PIO_ISR_P2 = 0x4
	// Position of P3 field.
	PIO_ISR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ISR_P3_Msk = 0x8
	// Bit P3.
	PIO_ISR_P3 = 0x8
	// Position of P4 field.
	PIO_ISR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ISR_P4_Msk = 0x10
	// Bit P4.
	PIO_ISR_P4 = 0x10
	// Position of P5 field.
	PIO_ISR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ISR_P5_Msk = 0x20
	// Bit P5.
	PIO_ISR_P5 = 0x20
	// Position of P6 field.
	PIO_ISR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ISR_P6_Msk = 0x40
	// Bit P6.
	PIO_ISR_P6 = 0x40
	// Position of P7 field.
	PIO_ISR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ISR_P7_Msk = 0x80
	// Bit P7.
	PIO_ISR_P7 = 0x80
	// Position of P8 field.
	PIO_ISR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ISR_P8_Msk = 0x100
	// Bit P8.
	PIO_ISR_P8 = 0x100
	// Position of P9 field.
	PIO_ISR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ISR_P9_Msk = 0x200
	// Bit P9.
	PIO_ISR_P9 = 0x200
	// Position of P10 field.
	PIO_ISR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ISR_P10_Msk = 0x400
	// Bit P10.
	PIO_ISR_P10 = 0x400
	// Position of P11 field.
	PIO_ISR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ISR_P11_Msk = 0x800
	// Bit P11.
	PIO_ISR_P11 = 0x800
	// Position of P12 field.
	PIO_ISR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ISR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ISR_P12 = 0x1000
	// Position of P13 field.
	PIO_ISR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ISR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ISR_P13 = 0x2000
	// Position of P14 field.
	PIO_ISR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ISR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ISR_P14 = 0x4000
	// Position of P15 field.
	PIO_ISR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ISR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ISR_P15 = 0x8000
	// Position of P16 field.
	PIO_ISR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ISR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ISR_P16 = 0x10000
	// Position of P17 field.
	PIO_ISR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ISR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ISR_P17 = 0x20000
	// Position of P18 field.
	PIO_ISR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ISR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ISR_P18 = 0x40000
	// Position of P19 field.
	PIO_ISR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ISR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ISR_P19 = 0x80000
	// Position of P20 field.
	PIO_ISR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ISR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ISR_P20 = 0x100000
	// Position of P21 field.
	PIO_ISR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ISR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ISR_P21 = 0x200000
	// Position of P22 field.
	PIO_ISR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ISR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ISR_P22 = 0x400000
	// Position of P23 field.
	PIO_ISR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ISR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ISR_P23 = 0x800000
	// Position of P24 field.
	PIO_ISR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ISR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ISR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ISR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ISR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ISR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ISR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ISR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ISR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ISR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ISR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ISR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ISR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ISR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ISR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ISR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ISR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ISR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ISR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ISR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ISR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ISR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ISR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ISR_P31 = 0x80000000

	// MDER: Multi-driver Enable Register
	// Position of P0 field.
	PIO_MDER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDER_P0_Msk = 0x1
	// Bit P0.
	PIO_MDER_P0 = 0x1
	// Position of P1 field.
	PIO_MDER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDER_P1_Msk = 0x2
	// Bit P1.
	PIO_MDER_P1 = 0x2
	// Position of P2 field.
	PIO_MDER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDER_P2_Msk = 0x4
	// Bit P2.
	PIO_MDER_P2 = 0x4
	// Position of P3 field.
	PIO_MDER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDER_P3_Msk = 0x8
	// Bit P3.
	PIO_MDER_P3 = 0x8
	// Position of P4 field.
	PIO_MDER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDER_P4_Msk = 0x10
	// Bit P4.
	PIO_MDER_P4 = 0x10
	// Position of P5 field.
	PIO_MDER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDER_P5_Msk = 0x20
	// Bit P5.
	PIO_MDER_P5 = 0x20
	// Position of P6 field.
	PIO_MDER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDER_P6_Msk = 0x40
	// Bit P6.
	PIO_MDER_P6 = 0x40
	// Position of P7 field.
	PIO_MDER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDER_P7_Msk = 0x80
	// Bit P7.
	PIO_MDER_P7 = 0x80
	// Position of P8 field.
	PIO_MDER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDER_P8_Msk = 0x100
	// Bit P8.
	PIO_MDER_P8 = 0x100
	// Position of P9 field.
	PIO_MDER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDER_P9_Msk = 0x200
	// Bit P9.
	PIO_MDER_P9 = 0x200
	// Position of P10 field.
	PIO_MDER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDER_P10_Msk = 0x400
	// Bit P10.
	PIO_MDER_P10 = 0x400
	// Position of P11 field.
	PIO_MDER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDER_P11_Msk = 0x800
	// Bit P11.
	PIO_MDER_P11 = 0x800
	// Position of P12 field.
	PIO_MDER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDER_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDER_P12 = 0x1000
	// Position of P13 field.
	PIO_MDER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDER_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDER_P13 = 0x2000
	// Position of P14 field.
	PIO_MDER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDER_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDER_P14 = 0x4000
	// Position of P15 field.
	PIO_MDER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDER_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDER_P15 = 0x8000
	// Position of P16 field.
	PIO_MDER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDER_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDER_P16 = 0x10000
	// Position of P17 field.
	PIO_MDER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDER_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDER_P17 = 0x20000
	// Position of P18 field.
	PIO_MDER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDER_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDER_P18 = 0x40000
	// Position of P19 field.
	PIO_MDER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDER_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDER_P19 = 0x80000
	// Position of P20 field.
	PIO_MDER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDER_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDER_P20 = 0x100000
	// Position of P21 field.
	PIO_MDER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDER_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDER_P21 = 0x200000
	// Position of P22 field.
	PIO_MDER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDER_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDER_P22 = 0x400000
	// Position of P23 field.
	PIO_MDER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDER_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDER_P23 = 0x800000
	// Position of P24 field.
	PIO_MDER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDER_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDER_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDER_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDER_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDER_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDER_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDER_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDER_P31 = 0x80000000

	// MDDR: Multi-driver Disable Register
	// Position of P0 field.
	PIO_MDDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDDR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDDR_P0 = 0x1
	// Position of P1 field.
	PIO_MDDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDDR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDDR_P1 = 0x2
	// Position of P2 field.
	PIO_MDDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDDR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDDR_P2 = 0x4
	// Position of P3 field.
	PIO_MDDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDDR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDDR_P3 = 0x8
	// Position of P4 field.
	PIO_MDDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDDR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDDR_P4 = 0x10
	// Position of P5 field.
	PIO_MDDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDDR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDDR_P5 = 0x20
	// Position of P6 field.
	PIO_MDDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDDR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDDR_P6 = 0x40
	// Position of P7 field.
	PIO_MDDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDDR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDDR_P7 = 0x80
	// Position of P8 field.
	PIO_MDDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDDR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDDR_P8 = 0x100
	// Position of P9 field.
	PIO_MDDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDDR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDDR_P9 = 0x200
	// Position of P10 field.
	PIO_MDDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDDR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDDR_P10 = 0x400
	// Position of P11 field.
	PIO_MDDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDDR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDDR_P11 = 0x800
	// Position of P12 field.
	PIO_MDDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDDR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDDR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDDR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDDR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDDR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDDR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDDR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDDR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDDR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDDR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDDR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDDR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDDR_P31 = 0x80000000

	// MDSR: Multi-driver Status Register
	// Position of P0 field.
	PIO_MDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_MDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_MDSR_P0 = 0x1
	// Position of P1 field.
	PIO_MDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_MDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_MDSR_P1 = 0x2
	// Position of P2 field.
	PIO_MDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_MDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_MDSR_P2 = 0x4
	// Position of P3 field.
	PIO_MDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_MDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_MDSR_P3 = 0x8
	// Position of P4 field.
	PIO_MDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_MDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_MDSR_P4 = 0x10
	// Position of P5 field.
	PIO_MDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_MDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_MDSR_P5 = 0x20
	// Position of P6 field.
	PIO_MDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_MDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_MDSR_P6 = 0x40
	// Position of P7 field.
	PIO_MDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_MDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_MDSR_P7 = 0x80
	// Position of P8 field.
	PIO_MDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_MDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_MDSR_P8 = 0x100
	// Position of P9 field.
	PIO_MDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_MDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_MDSR_P9 = 0x200
	// Position of P10 field.
	PIO_MDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_MDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_MDSR_P10 = 0x400
	// Position of P11 field.
	PIO_MDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_MDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_MDSR_P11 = 0x800
	// Position of P12 field.
	PIO_MDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_MDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_MDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_MDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_MDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_MDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_MDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_MDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_MDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_MDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_MDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_MDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_MDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_MDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_MDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_MDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_MDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_MDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_MDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_MDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_MDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_MDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_MDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_MDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_MDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_MDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_MDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_MDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_MDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_MDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_MDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_MDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_MDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_MDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_MDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_MDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_MDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_MDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_MDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_MDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_MDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_MDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_MDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_MDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_MDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_MDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_MDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_MDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_MDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_MDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_MDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_MDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_MDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_MDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_MDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_MDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_MDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_MDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_MDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_MDSR_P31 = 0x80000000

	// PUDR: Pull-up Disable Register
	// Position of P0 field.
	PIO_PUDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUDR_P0 = 0x1
	// Position of P1 field.
	PIO_PUDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUDR_P1 = 0x2
	// Position of P2 field.
	PIO_PUDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUDR_P2 = 0x4
	// Position of P3 field.
	PIO_PUDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUDR_P3 = 0x8
	// Position of P4 field.
	PIO_PUDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUDR_P4 = 0x10
	// Position of P5 field.
	PIO_PUDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUDR_P5 = 0x20
	// Position of P6 field.
	PIO_PUDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUDR_P6 = 0x40
	// Position of P7 field.
	PIO_PUDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUDR_P7 = 0x80
	// Position of P8 field.
	PIO_PUDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUDR_P8 = 0x100
	// Position of P9 field.
	PIO_PUDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUDR_P9 = 0x200
	// Position of P10 field.
	PIO_PUDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUDR_P10 = 0x400
	// Position of P11 field.
	PIO_PUDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUDR_P11 = 0x800
	// Position of P12 field.
	PIO_PUDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUDR_P31 = 0x80000000

	// PUER: Pull-up Enable Register
	// Position of P0 field.
	PIO_PUER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUER_P0_Msk = 0x1
	// Bit P0.
	PIO_PUER_P0 = 0x1
	// Position of P1 field.
	PIO_PUER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUER_P1_Msk = 0x2
	// Bit P1.
	PIO_PUER_P1 = 0x2
	// Position of P2 field.
	PIO_PUER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUER_P2_Msk = 0x4
	// Bit P2.
	PIO_PUER_P2 = 0x4
	// Position of P3 field.
	PIO_PUER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUER_P3_Msk = 0x8
	// Bit P3.
	PIO_PUER_P3 = 0x8
	// Position of P4 field.
	PIO_PUER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUER_P4_Msk = 0x10
	// Bit P4.
	PIO_PUER_P4 = 0x10
	// Position of P5 field.
	PIO_PUER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUER_P5_Msk = 0x20
	// Bit P5.
	PIO_PUER_P5 = 0x20
	// Position of P6 field.
	PIO_PUER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUER_P6_Msk = 0x40
	// Bit P6.
	PIO_PUER_P6 = 0x40
	// Position of P7 field.
	PIO_PUER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUER_P7_Msk = 0x80
	// Bit P7.
	PIO_PUER_P7 = 0x80
	// Position of P8 field.
	PIO_PUER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUER_P8_Msk = 0x100
	// Bit P8.
	PIO_PUER_P8 = 0x100
	// Position of P9 field.
	PIO_PUER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUER_P9_Msk = 0x200
	// Bit P9.
	PIO_PUER_P9 = 0x200
	// Position of P10 field.
	PIO_PUER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUER_P10_Msk = 0x400
	// Bit P10.
	PIO_PUER_P10 = 0x400
	// Position of P11 field.
	PIO_PUER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUER_P11_Msk = 0x800
	// Bit P11.
	PIO_PUER_P11 = 0x800
	// Position of P12 field.
	PIO_PUER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUER_P12 = 0x1000
	// Position of P13 field.
	PIO_PUER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUER_P13 = 0x2000
	// Position of P14 field.
	PIO_PUER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUER_P14 = 0x4000
	// Position of P15 field.
	PIO_PUER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUER_P15 = 0x8000
	// Position of P16 field.
	PIO_PUER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUER_P16 = 0x10000
	// Position of P17 field.
	PIO_PUER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUER_P17 = 0x20000
	// Position of P18 field.
	PIO_PUER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUER_P18 = 0x40000
	// Position of P19 field.
	PIO_PUER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUER_P19 = 0x80000
	// Position of P20 field.
	PIO_PUER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUER_P20 = 0x100000
	// Position of P21 field.
	PIO_PUER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUER_P21 = 0x200000
	// Position of P22 field.
	PIO_PUER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUER_P22 = 0x400000
	// Position of P23 field.
	PIO_PUER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUER_P23 = 0x800000
	// Position of P24 field.
	PIO_PUER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUER_P31 = 0x80000000

	// PUSR: Pad Pull-up Status Register
	// Position of P0 field.
	PIO_PUSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PUSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PUSR_P0 = 0x1
	// Position of P1 field.
	PIO_PUSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PUSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PUSR_P1 = 0x2
	// Position of P2 field.
	PIO_PUSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PUSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PUSR_P2 = 0x4
	// Position of P3 field.
	PIO_PUSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PUSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PUSR_P3 = 0x8
	// Position of P4 field.
	PIO_PUSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PUSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PUSR_P4 = 0x10
	// Position of P5 field.
	PIO_PUSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PUSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PUSR_P5 = 0x20
	// Position of P6 field.
	PIO_PUSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PUSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PUSR_P6 = 0x40
	// Position of P7 field.
	PIO_PUSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PUSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PUSR_P7 = 0x80
	// Position of P8 field.
	PIO_PUSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PUSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PUSR_P8 = 0x100
	// Position of P9 field.
	PIO_PUSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PUSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PUSR_P9 = 0x200
	// Position of P10 field.
	PIO_PUSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PUSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PUSR_P10 = 0x400
	// Position of P11 field.
	PIO_PUSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PUSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PUSR_P11 = 0x800
	// Position of P12 field.
	PIO_PUSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PUSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PUSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PUSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PUSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PUSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PUSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PUSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PUSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PUSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PUSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PUSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PUSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PUSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PUSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PUSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PUSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PUSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PUSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PUSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PUSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PUSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PUSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PUSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PUSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PUSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PUSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PUSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PUSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PUSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PUSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PUSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PUSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PUSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PUSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PUSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PUSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PUSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PUSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PUSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PUSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PUSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PUSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PUSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PUSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PUSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PUSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PUSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PUSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PUSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PUSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PUSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PUSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PUSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PUSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PUSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PUSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PUSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PUSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PUSR_P31 = 0x80000000

	// ABCDSR: Peripheral Select Register
	// Position of P0 field.
	PIO_ABCDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ABCDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_ABCDSR_P0 = 0x1
	// Position of P1 field.
	PIO_ABCDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ABCDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_ABCDSR_P1 = 0x2
	// Position of P2 field.
	PIO_ABCDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ABCDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_ABCDSR_P2 = 0x4
	// Position of P3 field.
	PIO_ABCDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ABCDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_ABCDSR_P3 = 0x8
	// Position of P4 field.
	PIO_ABCDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ABCDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_ABCDSR_P4 = 0x10
	// Position of P5 field.
	PIO_ABCDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ABCDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_ABCDSR_P5 = 0x20
	// Position of P6 field.
	PIO_ABCDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ABCDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_ABCDSR_P6 = 0x40
	// Position of P7 field.
	PIO_ABCDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ABCDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_ABCDSR_P7 = 0x80
	// Position of P8 field.
	PIO_ABCDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ABCDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_ABCDSR_P8 = 0x100
	// Position of P9 field.
	PIO_ABCDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ABCDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_ABCDSR_P9 = 0x200
	// Position of P10 field.
	PIO_ABCDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_ABCDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_ABCDSR_P10 = 0x400
	// Position of P11 field.
	PIO_ABCDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_ABCDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_ABCDSR_P11 = 0x800
	// Position of P12 field.
	PIO_ABCDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_ABCDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_ABCDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_ABCDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_ABCDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_ABCDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_ABCDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_ABCDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_ABCDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_ABCDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_ABCDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_ABCDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_ABCDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_ABCDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_ABCDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_ABCDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_ABCDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_ABCDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_ABCDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_ABCDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_ABCDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_ABCDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_ABCDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_ABCDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_ABCDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_ABCDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_ABCDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_ABCDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_ABCDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_ABCDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_ABCDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_ABCDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_ABCDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_ABCDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_ABCDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_ABCDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_ABCDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_ABCDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_ABCDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_ABCDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_ABCDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_ABCDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_ABCDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_ABCDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_ABCDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_ABCDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_ABCDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_ABCDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_ABCDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_ABCDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_ABCDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_ABCDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_ABCDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_ABCDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_ABCDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_ABCDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_ABCDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_ABCDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_ABCDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_ABCDSR_P31 = 0x80000000

	// IFSCDR: Input Filter Slow Clock Disable Register
	// Position of P0 field.
	PIO_IFSCDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSCDR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSCDR_P0 = 0x1
	// Position of P1 field.
	PIO_IFSCDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSCDR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSCDR_P1 = 0x2
	// Position of P2 field.
	PIO_IFSCDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSCDR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSCDR_P2 = 0x4
	// Position of P3 field.
	PIO_IFSCDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSCDR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSCDR_P3 = 0x8
	// Position of P4 field.
	PIO_IFSCDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSCDR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSCDR_P4 = 0x10
	// Position of P5 field.
	PIO_IFSCDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSCDR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSCDR_P5 = 0x20
	// Position of P6 field.
	PIO_IFSCDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSCDR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSCDR_P6 = 0x40
	// Position of P7 field.
	PIO_IFSCDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSCDR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSCDR_P7 = 0x80
	// Position of P8 field.
	PIO_IFSCDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSCDR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSCDR_P8 = 0x100
	// Position of P9 field.
	PIO_IFSCDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSCDR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSCDR_P9 = 0x200
	// Position of P10 field.
	PIO_IFSCDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSCDR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSCDR_P10 = 0x400
	// Position of P11 field.
	PIO_IFSCDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSCDR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSCDR_P11 = 0x800
	// Position of P12 field.
	PIO_IFSCDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSCDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSCDR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSCDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSCDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSCDR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSCDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSCDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSCDR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSCDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSCDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSCDR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSCDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSCDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSCDR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSCDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSCDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSCDR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSCDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSCDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSCDR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSCDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSCDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSCDR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSCDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSCDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSCDR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSCDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSCDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSCDR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSCDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSCDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSCDR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSCDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSCDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSCDR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSCDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSCDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSCDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSCDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSCDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSCDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSCDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSCDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSCDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSCDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSCDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSCDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSCDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSCDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSCDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSCDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSCDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSCDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSCDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSCDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSCDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSCDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSCDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSCDR_P31 = 0x80000000

	// IFSCER: Input Filter Slow Clock Enable Register
	// Position of P0 field.
	PIO_IFSCER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSCER_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSCER_P0 = 0x1
	// Position of P1 field.
	PIO_IFSCER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSCER_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSCER_P1 = 0x2
	// Position of P2 field.
	PIO_IFSCER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSCER_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSCER_P2 = 0x4
	// Position of P3 field.
	PIO_IFSCER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSCER_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSCER_P3 = 0x8
	// Position of P4 field.
	PIO_IFSCER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSCER_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSCER_P4 = 0x10
	// Position of P5 field.
	PIO_IFSCER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSCER_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSCER_P5 = 0x20
	// Position of P6 field.
	PIO_IFSCER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSCER_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSCER_P6 = 0x40
	// Position of P7 field.
	PIO_IFSCER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSCER_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSCER_P7 = 0x80
	// Position of P8 field.
	PIO_IFSCER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSCER_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSCER_P8 = 0x100
	// Position of P9 field.
	PIO_IFSCER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSCER_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSCER_P9 = 0x200
	// Position of P10 field.
	PIO_IFSCER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSCER_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSCER_P10 = 0x400
	// Position of P11 field.
	PIO_IFSCER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSCER_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSCER_P11 = 0x800
	// Position of P12 field.
	PIO_IFSCER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSCER_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSCER_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSCER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSCER_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSCER_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSCER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSCER_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSCER_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSCER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSCER_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSCER_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSCER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSCER_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSCER_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSCER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSCER_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSCER_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSCER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSCER_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSCER_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSCER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSCER_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSCER_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSCER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSCER_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSCER_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSCER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSCER_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSCER_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSCER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSCER_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSCER_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSCER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSCER_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSCER_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSCER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSCER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSCER_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSCER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSCER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSCER_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSCER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSCER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSCER_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSCER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSCER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSCER_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSCER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSCER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSCER_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSCER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSCER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSCER_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSCER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSCER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSCER_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSCER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSCER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSCER_P31 = 0x80000000

	// IFSCSR: Input Filter Slow Clock Status Register
	// Position of P0 field.
	PIO_IFSCSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_IFSCSR_P0_Msk = 0x1
	// Bit P0.
	PIO_IFSCSR_P0 = 0x1
	// Position of P1 field.
	PIO_IFSCSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_IFSCSR_P1_Msk = 0x2
	// Bit P1.
	PIO_IFSCSR_P1 = 0x2
	// Position of P2 field.
	PIO_IFSCSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_IFSCSR_P2_Msk = 0x4
	// Bit P2.
	PIO_IFSCSR_P2 = 0x4
	// Position of P3 field.
	PIO_IFSCSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_IFSCSR_P3_Msk = 0x8
	// Bit P3.
	PIO_IFSCSR_P3 = 0x8
	// Position of P4 field.
	PIO_IFSCSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_IFSCSR_P4_Msk = 0x10
	// Bit P4.
	PIO_IFSCSR_P4 = 0x10
	// Position of P5 field.
	PIO_IFSCSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_IFSCSR_P5_Msk = 0x20
	// Bit P5.
	PIO_IFSCSR_P5 = 0x20
	// Position of P6 field.
	PIO_IFSCSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_IFSCSR_P6_Msk = 0x40
	// Bit P6.
	PIO_IFSCSR_P6 = 0x40
	// Position of P7 field.
	PIO_IFSCSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_IFSCSR_P7_Msk = 0x80
	// Bit P7.
	PIO_IFSCSR_P7 = 0x80
	// Position of P8 field.
	PIO_IFSCSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_IFSCSR_P8_Msk = 0x100
	// Bit P8.
	PIO_IFSCSR_P8 = 0x100
	// Position of P9 field.
	PIO_IFSCSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_IFSCSR_P9_Msk = 0x200
	// Bit P9.
	PIO_IFSCSR_P9 = 0x200
	// Position of P10 field.
	PIO_IFSCSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_IFSCSR_P10_Msk = 0x400
	// Bit P10.
	PIO_IFSCSR_P10 = 0x400
	// Position of P11 field.
	PIO_IFSCSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_IFSCSR_P11_Msk = 0x800
	// Bit P11.
	PIO_IFSCSR_P11 = 0x800
	// Position of P12 field.
	PIO_IFSCSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_IFSCSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_IFSCSR_P12 = 0x1000
	// Position of P13 field.
	PIO_IFSCSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_IFSCSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_IFSCSR_P13 = 0x2000
	// Position of P14 field.
	PIO_IFSCSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_IFSCSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_IFSCSR_P14 = 0x4000
	// Position of P15 field.
	PIO_IFSCSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_IFSCSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_IFSCSR_P15 = 0x8000
	// Position of P16 field.
	PIO_IFSCSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_IFSCSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_IFSCSR_P16 = 0x10000
	// Position of P17 field.
	PIO_IFSCSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_IFSCSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_IFSCSR_P17 = 0x20000
	// Position of P18 field.
	PIO_IFSCSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_IFSCSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_IFSCSR_P18 = 0x40000
	// Position of P19 field.
	PIO_IFSCSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_IFSCSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_IFSCSR_P19 = 0x80000
	// Position of P20 field.
	PIO_IFSCSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_IFSCSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_IFSCSR_P20 = 0x100000
	// Position of P21 field.
	PIO_IFSCSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_IFSCSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_IFSCSR_P21 = 0x200000
	// Position of P22 field.
	PIO_IFSCSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_IFSCSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_IFSCSR_P22 = 0x400000
	// Position of P23 field.
	PIO_IFSCSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_IFSCSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_IFSCSR_P23 = 0x800000
	// Position of P24 field.
	PIO_IFSCSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_IFSCSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_IFSCSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_IFSCSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_IFSCSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_IFSCSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_IFSCSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_IFSCSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_IFSCSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_IFSCSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_IFSCSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_IFSCSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_IFSCSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_IFSCSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_IFSCSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_IFSCSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_IFSCSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_IFSCSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_IFSCSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_IFSCSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_IFSCSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_IFSCSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_IFSCSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_IFSCSR_P31 = 0x80000000

	// SCDR: Slow Clock Divider Debouncing Register
	// Position of DIV field.
	PIO_SCDR_DIV_Pos = 0x0
	// Bit mask of DIV field.
	PIO_SCDR_DIV_Msk = 0x3fff

	// PPDDR: Pad Pull-down Disable Register
	// Position of P0 field.
	PIO_PPDDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PPDDR_P0_Msk = 0x1
	// Bit P0.
	PIO_PPDDR_P0 = 0x1
	// Position of P1 field.
	PIO_PPDDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PPDDR_P1_Msk = 0x2
	// Bit P1.
	PIO_PPDDR_P1 = 0x2
	// Position of P2 field.
	PIO_PPDDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PPDDR_P2_Msk = 0x4
	// Bit P2.
	PIO_PPDDR_P2 = 0x4
	// Position of P3 field.
	PIO_PPDDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PPDDR_P3_Msk = 0x8
	// Bit P3.
	PIO_PPDDR_P3 = 0x8
	// Position of P4 field.
	PIO_PPDDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PPDDR_P4_Msk = 0x10
	// Bit P4.
	PIO_PPDDR_P4 = 0x10
	// Position of P5 field.
	PIO_PPDDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PPDDR_P5_Msk = 0x20
	// Bit P5.
	PIO_PPDDR_P5 = 0x20
	// Position of P6 field.
	PIO_PPDDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PPDDR_P6_Msk = 0x40
	// Bit P6.
	PIO_PPDDR_P6 = 0x40
	// Position of P7 field.
	PIO_PPDDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PPDDR_P7_Msk = 0x80
	// Bit P7.
	PIO_PPDDR_P7 = 0x80
	// Position of P8 field.
	PIO_PPDDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PPDDR_P8_Msk = 0x100
	// Bit P8.
	PIO_PPDDR_P8 = 0x100
	// Position of P9 field.
	PIO_PPDDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PPDDR_P9_Msk = 0x200
	// Bit P9.
	PIO_PPDDR_P9 = 0x200
	// Position of P10 field.
	PIO_PPDDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PPDDR_P10_Msk = 0x400
	// Bit P10.
	PIO_PPDDR_P10 = 0x400
	// Position of P11 field.
	PIO_PPDDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PPDDR_P11_Msk = 0x800
	// Bit P11.
	PIO_PPDDR_P11 = 0x800
	// Position of P12 field.
	PIO_PPDDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PPDDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PPDDR_P12 = 0x1000
	// Position of P13 field.
	PIO_PPDDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PPDDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PPDDR_P13 = 0x2000
	// Position of P14 field.
	PIO_PPDDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PPDDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PPDDR_P14 = 0x4000
	// Position of P15 field.
	PIO_PPDDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PPDDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PPDDR_P15 = 0x8000
	// Position of P16 field.
	PIO_PPDDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PPDDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PPDDR_P16 = 0x10000
	// Position of P17 field.
	PIO_PPDDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PPDDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PPDDR_P17 = 0x20000
	// Position of P18 field.
	PIO_PPDDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PPDDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PPDDR_P18 = 0x40000
	// Position of P19 field.
	PIO_PPDDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PPDDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PPDDR_P19 = 0x80000
	// Position of P20 field.
	PIO_PPDDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PPDDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PPDDR_P20 = 0x100000
	// Position of P21 field.
	PIO_PPDDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PPDDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PPDDR_P21 = 0x200000
	// Position of P22 field.
	PIO_PPDDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PPDDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PPDDR_P22 = 0x400000
	// Position of P23 field.
	PIO_PPDDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PPDDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PPDDR_P23 = 0x800000
	// Position of P24 field.
	PIO_PPDDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PPDDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PPDDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PPDDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PPDDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PPDDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PPDDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PPDDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PPDDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PPDDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PPDDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PPDDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PPDDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PPDDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PPDDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PPDDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PPDDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PPDDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PPDDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PPDDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PPDDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PPDDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PPDDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PPDDR_P31 = 0x80000000

	// PPDER: Pad Pull-down Enable Register
	// Position of P0 field.
	PIO_PPDER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PPDER_P0_Msk = 0x1
	// Bit P0.
	PIO_PPDER_P0 = 0x1
	// Position of P1 field.
	PIO_PPDER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PPDER_P1_Msk = 0x2
	// Bit P1.
	PIO_PPDER_P1 = 0x2
	// Position of P2 field.
	PIO_PPDER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PPDER_P2_Msk = 0x4
	// Bit P2.
	PIO_PPDER_P2 = 0x4
	// Position of P3 field.
	PIO_PPDER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PPDER_P3_Msk = 0x8
	// Bit P3.
	PIO_PPDER_P3 = 0x8
	// Position of P4 field.
	PIO_PPDER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PPDER_P4_Msk = 0x10
	// Bit P4.
	PIO_PPDER_P4 = 0x10
	// Position of P5 field.
	PIO_PPDER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PPDER_P5_Msk = 0x20
	// Bit P5.
	PIO_PPDER_P5 = 0x20
	// Position of P6 field.
	PIO_PPDER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PPDER_P6_Msk = 0x40
	// Bit P6.
	PIO_PPDER_P6 = 0x40
	// Position of P7 field.
	PIO_PPDER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PPDER_P7_Msk = 0x80
	// Bit P7.
	PIO_PPDER_P7 = 0x80
	// Position of P8 field.
	PIO_PPDER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PPDER_P8_Msk = 0x100
	// Bit P8.
	PIO_PPDER_P8 = 0x100
	// Position of P9 field.
	PIO_PPDER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PPDER_P9_Msk = 0x200
	// Bit P9.
	PIO_PPDER_P9 = 0x200
	// Position of P10 field.
	PIO_PPDER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PPDER_P10_Msk = 0x400
	// Bit P10.
	PIO_PPDER_P10 = 0x400
	// Position of P11 field.
	PIO_PPDER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PPDER_P11_Msk = 0x800
	// Bit P11.
	PIO_PPDER_P11 = 0x800
	// Position of P12 field.
	PIO_PPDER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PPDER_P12_Msk = 0x1000
	// Bit P12.
	PIO_PPDER_P12 = 0x1000
	// Position of P13 field.
	PIO_PPDER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PPDER_P13_Msk = 0x2000
	// Bit P13.
	PIO_PPDER_P13 = 0x2000
	// Position of P14 field.
	PIO_PPDER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PPDER_P14_Msk = 0x4000
	// Bit P14.
	PIO_PPDER_P14 = 0x4000
	// Position of P15 field.
	PIO_PPDER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PPDER_P15_Msk = 0x8000
	// Bit P15.
	PIO_PPDER_P15 = 0x8000
	// Position of P16 field.
	PIO_PPDER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PPDER_P16_Msk = 0x10000
	// Bit P16.
	PIO_PPDER_P16 = 0x10000
	// Position of P17 field.
	PIO_PPDER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PPDER_P17_Msk = 0x20000
	// Bit P17.
	PIO_PPDER_P17 = 0x20000
	// Position of P18 field.
	PIO_PPDER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PPDER_P18_Msk = 0x40000
	// Bit P18.
	PIO_PPDER_P18 = 0x40000
	// Position of P19 field.
	PIO_PPDER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PPDER_P19_Msk = 0x80000
	// Bit P19.
	PIO_PPDER_P19 = 0x80000
	// Position of P20 field.
	PIO_PPDER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PPDER_P20_Msk = 0x100000
	// Bit P20.
	PIO_PPDER_P20 = 0x100000
	// Position of P21 field.
	PIO_PPDER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PPDER_P21_Msk = 0x200000
	// Bit P21.
	PIO_PPDER_P21 = 0x200000
	// Position of P22 field.
	PIO_PPDER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PPDER_P22_Msk = 0x400000
	// Bit P22.
	PIO_PPDER_P22 = 0x400000
	// Position of P23 field.
	PIO_PPDER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PPDER_P23_Msk = 0x800000
	// Bit P23.
	PIO_PPDER_P23 = 0x800000
	// Position of P24 field.
	PIO_PPDER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PPDER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PPDER_P24 = 0x1000000
	// Position of P25 field.
	PIO_PPDER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PPDER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PPDER_P25 = 0x2000000
	// Position of P26 field.
	PIO_PPDER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PPDER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PPDER_P26 = 0x4000000
	// Position of P27 field.
	PIO_PPDER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PPDER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PPDER_P27 = 0x8000000
	// Position of P28 field.
	PIO_PPDER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PPDER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PPDER_P28 = 0x10000000
	// Position of P29 field.
	PIO_PPDER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PPDER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PPDER_P29 = 0x20000000
	// Position of P30 field.
	PIO_PPDER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PPDER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PPDER_P30 = 0x40000000
	// Position of P31 field.
	PIO_PPDER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PPDER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PPDER_P31 = 0x80000000

	// PPDSR: Pad Pull-down Status Register
	// Position of P0 field.
	PIO_PPDSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_PPDSR_P0_Msk = 0x1
	// Bit P0.
	PIO_PPDSR_P0 = 0x1
	// Position of P1 field.
	PIO_PPDSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_PPDSR_P1_Msk = 0x2
	// Bit P1.
	PIO_PPDSR_P1 = 0x2
	// Position of P2 field.
	PIO_PPDSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_PPDSR_P2_Msk = 0x4
	// Bit P2.
	PIO_PPDSR_P2 = 0x4
	// Position of P3 field.
	PIO_PPDSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_PPDSR_P3_Msk = 0x8
	// Bit P3.
	PIO_PPDSR_P3 = 0x8
	// Position of P4 field.
	PIO_PPDSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_PPDSR_P4_Msk = 0x10
	// Bit P4.
	PIO_PPDSR_P4 = 0x10
	// Position of P5 field.
	PIO_PPDSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_PPDSR_P5_Msk = 0x20
	// Bit P5.
	PIO_PPDSR_P5 = 0x20
	// Position of P6 field.
	PIO_PPDSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_PPDSR_P6_Msk = 0x40
	// Bit P6.
	PIO_PPDSR_P6 = 0x40
	// Position of P7 field.
	PIO_PPDSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_PPDSR_P7_Msk = 0x80
	// Bit P7.
	PIO_PPDSR_P7 = 0x80
	// Position of P8 field.
	PIO_PPDSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_PPDSR_P8_Msk = 0x100
	// Bit P8.
	PIO_PPDSR_P8 = 0x100
	// Position of P9 field.
	PIO_PPDSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_PPDSR_P9_Msk = 0x200
	// Bit P9.
	PIO_PPDSR_P9 = 0x200
	// Position of P10 field.
	PIO_PPDSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_PPDSR_P10_Msk = 0x400
	// Bit P10.
	PIO_PPDSR_P10 = 0x400
	// Position of P11 field.
	PIO_PPDSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_PPDSR_P11_Msk = 0x800
	// Bit P11.
	PIO_PPDSR_P11 = 0x800
	// Position of P12 field.
	PIO_PPDSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_PPDSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_PPDSR_P12 = 0x1000
	// Position of P13 field.
	PIO_PPDSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_PPDSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_PPDSR_P13 = 0x2000
	// Position of P14 field.
	PIO_PPDSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_PPDSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_PPDSR_P14 = 0x4000
	// Position of P15 field.
	PIO_PPDSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_PPDSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_PPDSR_P15 = 0x8000
	// Position of P16 field.
	PIO_PPDSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_PPDSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_PPDSR_P16 = 0x10000
	// Position of P17 field.
	PIO_PPDSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_PPDSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_PPDSR_P17 = 0x20000
	// Position of P18 field.
	PIO_PPDSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_PPDSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_PPDSR_P18 = 0x40000
	// Position of P19 field.
	PIO_PPDSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_PPDSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_PPDSR_P19 = 0x80000
	// Position of P20 field.
	PIO_PPDSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_PPDSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_PPDSR_P20 = 0x100000
	// Position of P21 field.
	PIO_PPDSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_PPDSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_PPDSR_P21 = 0x200000
	// Position of P22 field.
	PIO_PPDSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_PPDSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_PPDSR_P22 = 0x400000
	// Position of P23 field.
	PIO_PPDSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_PPDSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_PPDSR_P23 = 0x800000
	// Position of P24 field.
	PIO_PPDSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_PPDSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_PPDSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_PPDSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_PPDSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_PPDSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_PPDSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_PPDSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_PPDSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_PPDSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_PPDSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_PPDSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_PPDSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_PPDSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_PPDSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_PPDSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_PPDSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_PPDSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_PPDSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_PPDSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_PPDSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_PPDSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_PPDSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_PPDSR_P31 = 0x80000000

	// OWER: Output Write Enable
	// Position of P0 field.
	PIO_OWER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWER_P0_Msk = 0x1
	// Bit P0.
	PIO_OWER_P0 = 0x1
	// Position of P1 field.
	PIO_OWER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWER_P1_Msk = 0x2
	// Bit P1.
	PIO_OWER_P1 = 0x2
	// Position of P2 field.
	PIO_OWER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWER_P2_Msk = 0x4
	// Bit P2.
	PIO_OWER_P2 = 0x4
	// Position of P3 field.
	PIO_OWER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWER_P3_Msk = 0x8
	// Bit P3.
	PIO_OWER_P3 = 0x8
	// Position of P4 field.
	PIO_OWER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWER_P4_Msk = 0x10
	// Bit P4.
	PIO_OWER_P4 = 0x10
	// Position of P5 field.
	PIO_OWER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWER_P5_Msk = 0x20
	// Bit P5.
	PIO_OWER_P5 = 0x20
	// Position of P6 field.
	PIO_OWER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWER_P6_Msk = 0x40
	// Bit P6.
	PIO_OWER_P6 = 0x40
	// Position of P7 field.
	PIO_OWER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWER_P7_Msk = 0x80
	// Bit P7.
	PIO_OWER_P7 = 0x80
	// Position of P8 field.
	PIO_OWER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWER_P8_Msk = 0x100
	// Bit P8.
	PIO_OWER_P8 = 0x100
	// Position of P9 field.
	PIO_OWER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWER_P9_Msk = 0x200
	// Bit P9.
	PIO_OWER_P9 = 0x200
	// Position of P10 field.
	PIO_OWER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWER_P10_Msk = 0x400
	// Bit P10.
	PIO_OWER_P10 = 0x400
	// Position of P11 field.
	PIO_OWER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWER_P11_Msk = 0x800
	// Bit P11.
	PIO_OWER_P11 = 0x800
	// Position of P12 field.
	PIO_OWER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWER_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWER_P12 = 0x1000
	// Position of P13 field.
	PIO_OWER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWER_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWER_P13 = 0x2000
	// Position of P14 field.
	PIO_OWER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWER_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWER_P14 = 0x4000
	// Position of P15 field.
	PIO_OWER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWER_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWER_P15 = 0x8000
	// Position of P16 field.
	PIO_OWER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWER_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWER_P16 = 0x10000
	// Position of P17 field.
	PIO_OWER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWER_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWER_P17 = 0x20000
	// Position of P18 field.
	PIO_OWER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWER_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWER_P18 = 0x40000
	// Position of P19 field.
	PIO_OWER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWER_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWER_P19 = 0x80000
	// Position of P20 field.
	PIO_OWER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWER_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWER_P20 = 0x100000
	// Position of P21 field.
	PIO_OWER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWER_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWER_P21 = 0x200000
	// Position of P22 field.
	PIO_OWER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWER_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWER_P22 = 0x400000
	// Position of P23 field.
	PIO_OWER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWER_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWER_P23 = 0x800000
	// Position of P24 field.
	PIO_OWER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWER_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWER_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWER_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWER_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWER_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWER_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWER_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWER_P31 = 0x80000000

	// OWDR: Output Write Disable
	// Position of P0 field.
	PIO_OWDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWDR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWDR_P0 = 0x1
	// Position of P1 field.
	PIO_OWDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWDR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWDR_P1 = 0x2
	// Position of P2 field.
	PIO_OWDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWDR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWDR_P2 = 0x4
	// Position of P3 field.
	PIO_OWDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWDR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWDR_P3 = 0x8
	// Position of P4 field.
	PIO_OWDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWDR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWDR_P4 = 0x10
	// Position of P5 field.
	PIO_OWDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWDR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWDR_P5 = 0x20
	// Position of P6 field.
	PIO_OWDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWDR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWDR_P6 = 0x40
	// Position of P7 field.
	PIO_OWDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWDR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWDR_P7 = 0x80
	// Position of P8 field.
	PIO_OWDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWDR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWDR_P8 = 0x100
	// Position of P9 field.
	PIO_OWDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWDR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWDR_P9 = 0x200
	// Position of P10 field.
	PIO_OWDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWDR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWDR_P10 = 0x400
	// Position of P11 field.
	PIO_OWDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWDR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWDR_P11 = 0x800
	// Position of P12 field.
	PIO_OWDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWDR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWDR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWDR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWDR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWDR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWDR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWDR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWDR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWDR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWDR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWDR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWDR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWDR_P31 = 0x80000000

	// OWSR: Output Write Status Register
	// Position of P0 field.
	PIO_OWSR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_OWSR_P0_Msk = 0x1
	// Bit P0.
	PIO_OWSR_P0 = 0x1
	// Position of P1 field.
	PIO_OWSR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_OWSR_P1_Msk = 0x2
	// Bit P1.
	PIO_OWSR_P1 = 0x2
	// Position of P2 field.
	PIO_OWSR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_OWSR_P2_Msk = 0x4
	// Bit P2.
	PIO_OWSR_P2 = 0x4
	// Position of P3 field.
	PIO_OWSR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_OWSR_P3_Msk = 0x8
	// Bit P3.
	PIO_OWSR_P3 = 0x8
	// Position of P4 field.
	PIO_OWSR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_OWSR_P4_Msk = 0x10
	// Bit P4.
	PIO_OWSR_P4 = 0x10
	// Position of P5 field.
	PIO_OWSR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_OWSR_P5_Msk = 0x20
	// Bit P5.
	PIO_OWSR_P5 = 0x20
	// Position of P6 field.
	PIO_OWSR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_OWSR_P6_Msk = 0x40
	// Bit P6.
	PIO_OWSR_P6 = 0x40
	// Position of P7 field.
	PIO_OWSR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_OWSR_P7_Msk = 0x80
	// Bit P7.
	PIO_OWSR_P7 = 0x80
	// Position of P8 field.
	PIO_OWSR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_OWSR_P8_Msk = 0x100
	// Bit P8.
	PIO_OWSR_P8 = 0x100
	// Position of P9 field.
	PIO_OWSR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_OWSR_P9_Msk = 0x200
	// Bit P9.
	PIO_OWSR_P9 = 0x200
	// Position of P10 field.
	PIO_OWSR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_OWSR_P10_Msk = 0x400
	// Bit P10.
	PIO_OWSR_P10 = 0x400
	// Position of P11 field.
	PIO_OWSR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_OWSR_P11_Msk = 0x800
	// Bit P11.
	PIO_OWSR_P11 = 0x800
	// Position of P12 field.
	PIO_OWSR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_OWSR_P12_Msk = 0x1000
	// Bit P12.
	PIO_OWSR_P12 = 0x1000
	// Position of P13 field.
	PIO_OWSR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_OWSR_P13_Msk = 0x2000
	// Bit P13.
	PIO_OWSR_P13 = 0x2000
	// Position of P14 field.
	PIO_OWSR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_OWSR_P14_Msk = 0x4000
	// Bit P14.
	PIO_OWSR_P14 = 0x4000
	// Position of P15 field.
	PIO_OWSR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_OWSR_P15_Msk = 0x8000
	// Bit P15.
	PIO_OWSR_P15 = 0x8000
	// Position of P16 field.
	PIO_OWSR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_OWSR_P16_Msk = 0x10000
	// Bit P16.
	PIO_OWSR_P16 = 0x10000
	// Position of P17 field.
	PIO_OWSR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_OWSR_P17_Msk = 0x20000
	// Bit P17.
	PIO_OWSR_P17 = 0x20000
	// Position of P18 field.
	PIO_OWSR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_OWSR_P18_Msk = 0x40000
	// Bit P18.
	PIO_OWSR_P18 = 0x40000
	// Position of P19 field.
	PIO_OWSR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_OWSR_P19_Msk = 0x80000
	// Bit P19.
	PIO_OWSR_P19 = 0x80000
	// Position of P20 field.
	PIO_OWSR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_OWSR_P20_Msk = 0x100000
	// Bit P20.
	PIO_OWSR_P20 = 0x100000
	// Position of P21 field.
	PIO_OWSR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_OWSR_P21_Msk = 0x200000
	// Bit P21.
	PIO_OWSR_P21 = 0x200000
	// Position of P22 field.
	PIO_OWSR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_OWSR_P22_Msk = 0x400000
	// Bit P22.
	PIO_OWSR_P22 = 0x400000
	// Position of P23 field.
	PIO_OWSR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_OWSR_P23_Msk = 0x800000
	// Bit P23.
	PIO_OWSR_P23 = 0x800000
	// Position of P24 field.
	PIO_OWSR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_OWSR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_OWSR_P24 = 0x1000000
	// Position of P25 field.
	PIO_OWSR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_OWSR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_OWSR_P25 = 0x2000000
	// Position of P26 field.
	PIO_OWSR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_OWSR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_OWSR_P26 = 0x4000000
	// Position of P27 field.
	PIO_OWSR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_OWSR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_OWSR_P27 = 0x8000000
	// Position of P28 field.
	PIO_OWSR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_OWSR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_OWSR_P28 = 0x10000000
	// Position of P29 field.
	PIO_OWSR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_OWSR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_OWSR_P29 = 0x20000000
	// Position of P30 field.
	PIO_OWSR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_OWSR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_OWSR_P30 = 0x40000000
	// Position of P31 field.
	PIO_OWSR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_OWSR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_OWSR_P31 = 0x80000000

	// AIMER: Additional Interrupt Modes Enable Register
	// Position of P0 field.
	PIO_AIMER_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMER_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMER_P0 = 0x1
	// Position of P1 field.
	PIO_AIMER_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMER_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMER_P1 = 0x2
	// Position of P2 field.
	PIO_AIMER_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMER_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMER_P2 = 0x4
	// Position of P3 field.
	PIO_AIMER_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMER_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMER_P3 = 0x8
	// Position of P4 field.
	PIO_AIMER_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMER_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMER_P4 = 0x10
	// Position of P5 field.
	PIO_AIMER_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMER_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMER_P5 = 0x20
	// Position of P6 field.
	PIO_AIMER_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMER_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMER_P6 = 0x40
	// Position of P7 field.
	PIO_AIMER_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMER_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMER_P7 = 0x80
	// Position of P8 field.
	PIO_AIMER_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMER_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMER_P8 = 0x100
	// Position of P9 field.
	PIO_AIMER_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMER_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMER_P9 = 0x200
	// Position of P10 field.
	PIO_AIMER_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMER_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMER_P10 = 0x400
	// Position of P11 field.
	PIO_AIMER_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMER_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMER_P11 = 0x800
	// Position of P12 field.
	PIO_AIMER_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMER_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMER_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMER_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMER_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMER_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMER_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMER_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMER_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMER_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMER_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMER_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMER_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMER_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMER_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMER_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMER_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMER_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMER_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMER_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMER_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMER_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMER_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMER_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMER_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMER_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMER_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMER_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMER_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMER_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMER_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMER_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMER_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMER_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMER_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMER_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMER_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMER_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMER_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMER_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMER_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMER_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMER_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMER_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMER_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMER_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMER_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMER_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMER_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMER_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMER_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMER_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMER_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMER_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMER_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMER_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMER_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMER_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMER_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMER_P31 = 0x80000000

	// AIMDR: Additional Interrupt Modes Disables Register
	// Position of P0 field.
	PIO_AIMDR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMDR_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMDR_P0 = 0x1
	// Position of P1 field.
	PIO_AIMDR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMDR_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMDR_P1 = 0x2
	// Position of P2 field.
	PIO_AIMDR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMDR_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMDR_P2 = 0x4
	// Position of P3 field.
	PIO_AIMDR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMDR_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMDR_P3 = 0x8
	// Position of P4 field.
	PIO_AIMDR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMDR_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMDR_P4 = 0x10
	// Position of P5 field.
	PIO_AIMDR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMDR_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMDR_P5 = 0x20
	// Position of P6 field.
	PIO_AIMDR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMDR_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMDR_P6 = 0x40
	// Position of P7 field.
	PIO_AIMDR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMDR_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMDR_P7 = 0x80
	// Position of P8 field.
	PIO_AIMDR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMDR_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMDR_P8 = 0x100
	// Position of P9 field.
	PIO_AIMDR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMDR_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMDR_P9 = 0x200
	// Position of P10 field.
	PIO_AIMDR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMDR_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMDR_P10 = 0x400
	// Position of P11 field.
	PIO_AIMDR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMDR_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMDR_P11 = 0x800
	// Position of P12 field.
	PIO_AIMDR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMDR_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMDR_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMDR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMDR_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMDR_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMDR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMDR_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMDR_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMDR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMDR_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMDR_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMDR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMDR_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMDR_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMDR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMDR_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMDR_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMDR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMDR_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMDR_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMDR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMDR_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMDR_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMDR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMDR_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMDR_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMDR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMDR_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMDR_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMDR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMDR_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMDR_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMDR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMDR_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMDR_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMDR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMDR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMDR_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMDR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMDR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMDR_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMDR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMDR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMDR_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMDR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMDR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMDR_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMDR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMDR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMDR_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMDR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMDR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMDR_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMDR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMDR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMDR_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMDR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMDR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMDR_P31 = 0x80000000

	// AIMMR: Additional Interrupt Modes Mask Register
	// Position of P0 field.
	PIO_AIMMR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_AIMMR_P0_Msk = 0x1
	// Bit P0.
	PIO_AIMMR_P0 = 0x1
	// Position of P1 field.
	PIO_AIMMR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_AIMMR_P1_Msk = 0x2
	// Bit P1.
	PIO_AIMMR_P1 = 0x2
	// Position of P2 field.
	PIO_AIMMR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_AIMMR_P2_Msk = 0x4
	// Bit P2.
	PIO_AIMMR_P2 = 0x4
	// Position of P3 field.
	PIO_AIMMR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_AIMMR_P3_Msk = 0x8
	// Bit P3.
	PIO_AIMMR_P3 = 0x8
	// Position of P4 field.
	PIO_AIMMR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_AIMMR_P4_Msk = 0x10
	// Bit P4.
	PIO_AIMMR_P4 = 0x10
	// Position of P5 field.
	PIO_AIMMR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_AIMMR_P5_Msk = 0x20
	// Bit P5.
	PIO_AIMMR_P5 = 0x20
	// Position of P6 field.
	PIO_AIMMR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_AIMMR_P6_Msk = 0x40
	// Bit P6.
	PIO_AIMMR_P6 = 0x40
	// Position of P7 field.
	PIO_AIMMR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_AIMMR_P7_Msk = 0x80
	// Bit P7.
	PIO_AIMMR_P7 = 0x80
	// Position of P8 field.
	PIO_AIMMR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_AIMMR_P8_Msk = 0x100
	// Bit P8.
	PIO_AIMMR_P8 = 0x100
	// Position of P9 field.
	PIO_AIMMR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_AIMMR_P9_Msk = 0x200
	// Bit P9.
	PIO_AIMMR_P9 = 0x200
	// Position of P10 field.
	PIO_AIMMR_P10_Pos = 0xa
	// Bit mask of P10 field.
	PIO_AIMMR_P10_Msk = 0x400
	// Bit P10.
	PIO_AIMMR_P10 = 0x400
	// Position of P11 field.
	PIO_AIMMR_P11_Pos = 0xb
	// Bit mask of P11 field.
	PIO_AIMMR_P11_Msk = 0x800
	// Bit P11.
	PIO_AIMMR_P11 = 0x800
	// Position of P12 field.
	PIO_AIMMR_P12_Pos = 0xc
	// Bit mask of P12 field.
	PIO_AIMMR_P12_Msk = 0x1000
	// Bit P12.
	PIO_AIMMR_P12 = 0x1000
	// Position of P13 field.
	PIO_AIMMR_P13_Pos = 0xd
	// Bit mask of P13 field.
	PIO_AIMMR_P13_Msk = 0x2000
	// Bit P13.
	PIO_AIMMR_P13 = 0x2000
	// Position of P14 field.
	PIO_AIMMR_P14_Pos = 0xe
	// Bit mask of P14 field.
	PIO_AIMMR_P14_Msk = 0x4000
	// Bit P14.
	PIO_AIMMR_P14 = 0x4000
	// Position of P15 field.
	PIO_AIMMR_P15_Pos = 0xf
	// Bit mask of P15 field.
	PIO_AIMMR_P15_Msk = 0x8000
	// Bit P15.
	PIO_AIMMR_P15 = 0x8000
	// Position of P16 field.
	PIO_AIMMR_P16_Pos = 0x10
	// Bit mask of P16 field.
	PIO_AIMMR_P16_Msk = 0x10000
	// Bit P16.
	PIO_AIMMR_P16 = 0x10000
	// Position of P17 field.
	PIO_AIMMR_P17_Pos = 0x11
	// Bit mask of P17 field.
	PIO_AIMMR_P17_Msk = 0x20000
	// Bit P17.
	PIO_AIMMR_P17 = 0x20000
	// Position of P18 field.
	PIO_AIMMR_P18_Pos = 0x12
	// Bit mask of P18 field.
	PIO_AIMMR_P18_Msk = 0x40000
	// Bit P18.
	PIO_AIMMR_P18 = 0x40000
	// Position of P19 field.
	PIO_AIMMR_P19_Pos = 0x13
	// Bit mask of P19 field.
	PIO_AIMMR_P19_Msk = 0x80000
	// Bit P19.
	PIO_AIMMR_P19 = 0x80000
	// Position of P20 field.
	PIO_AIMMR_P20_Pos = 0x14
	// Bit mask of P20 field.
	PIO_AIMMR_P20_Msk = 0x100000
	// Bit P20.
	PIO_AIMMR_P20 = 0x100000
	// Position of P21 field.
	PIO_AIMMR_P21_Pos = 0x15
	// Bit mask of P21 field.
	PIO_AIMMR_P21_Msk = 0x200000
	// Bit P21.
	PIO_AIMMR_P21 = 0x200000
	// Position of P22 field.
	PIO_AIMMR_P22_Pos = 0x16
	// Bit mask of P22 field.
	PIO_AIMMR_P22_Msk = 0x400000
	// Bit P22.
	PIO_AIMMR_P22 = 0x400000
	// Position of P23 field.
	PIO_AIMMR_P23_Pos = 0x17
	// Bit mask of P23 field.
	PIO_AIMMR_P23_Msk = 0x800000
	// Bit P23.
	PIO_AIMMR_P23 = 0x800000
	// Position of P24 field.
	PIO_AIMMR_P24_Pos = 0x18
	// Bit mask of P24 field.
	PIO_AIMMR_P24_Msk = 0x1000000
	// Bit P24.
	PIO_AIMMR_P24 = 0x1000000
	// Position of P25 field.
	PIO_AIMMR_P25_Pos = 0x19
	// Bit mask of P25 field.
	PIO_AIMMR_P25_Msk = 0x2000000
	// Bit P25.
	PIO_AIMMR_P25 = 0x2000000
	// Position of P26 field.
	PIO_AIMMR_P26_Pos = 0x1a
	// Bit mask of P26 field.
	PIO_AIMMR_P26_Msk = 0x4000000
	// Bit P26.
	PIO_AIMMR_P26 = 0x4000000
	// Position of P27 field.
	PIO_AIMMR_P27_Pos = 0x1b
	// Bit mask of P27 field.
	PIO_AIMMR_P27_Msk = 0x8000000
	// Bit P27.
	PIO_AIMMR_P27 = 0x8000000
	// Position of P28 field.
	PIO_AIMMR_P28_Pos = 0x1c
	// Bit mask of P28 field.
	PIO_AIMMR_P28_Msk = 0x10000000
	// Bit P28.
	PIO_AIMMR_P28 = 0x10000000
	// Position of P29 field.
	PIO_AIMMR_P29_Pos = 0x1d
	// Bit mask of P29 field.
	PIO_AIMMR_P29_Msk = 0x20000000
	// Bit P29.
	PIO_AIMMR_P29 = 0x20000000
	// Position of P30 field.
	PIO_AIMMR_P30_Pos = 0x1e
	// Bit mask of P30 field.
	PIO_AIMMR_P30_Msk = 0x40000000
	// Bit P30.
	PIO_AIMMR_P30 = 0x40000000
	// Position of P31 field.
	PIO_AIMMR_P31_Pos = 0x1f
	// Bit mask of P31 field.
	PIO_AIMMR_P31_Msk = 0x80000000
	// Bit P31.
	PIO_AIMMR_P31 = 0x80000000

	// ESR: Edge Select Register
	// Position of P0 field.
	PIO_ESR_P0_Pos = 0x0
	// Bit mask of P0 field.
	PIO_ESR_P0_Msk = 0x1
	// Bit P0.
	PIO_ESR_P0 = 0x1
	// Position of P1 field.
	PIO_ESR_P1_Pos = 0x1
	// Bit mask of P1 field.
	PIO_ESR_P1_Msk = 0x2
	// Bit P1.
	PIO_ESR_P1 = 0x2
	// Position of P2 field.
	PIO_ESR_P2_Pos = 0x2
	// Bit mask of P2 field.
	PIO_ESR_P2_Msk = 0x4
	// Bit P2.
	PIO_ESR_P2 = 0x4
	// Position of P3 field.
	PIO_ESR_P3_Pos = 0x3
	// Bit mask of P3 field.
	PIO_ESR_P3_Msk = 0x8
	// Bit P3.
	PIO_ESR_P3 = 0x8
	// Position of P4 field.
	PIO_ESR_P4_Pos = 0x4
	// Bit mask of P4 field.
	PIO_ESR_P4_Msk = 0x10
	// Bit P4.
	PIO_ESR_P4 = 0x10
	// Position of P5 field.
	PIO_ESR_P5_Pos = 0x5
	// Bit mask of P5 field.
	PIO_ESR_P5_Msk = 0x20
	// Bit P5.
	PIO_ESR_P5 = 0x20
	// Position of P6 field.
	PIO_ESR_P6_Pos = 0x6
	// Bit mask of P6 field.
	PIO_ESR_P6_Msk = 0x40
	// Bit P6.
	PIO_ESR_P6 = 0x40
	// Position of P7 field.
	PIO_ESR_P7_Pos = 0x7
	// Bit mask of P7 field.
	PIO_ESR_P7_Msk = 0x80
	// Bit P7.
	PIO_ESR_P7 = 0x80
	// Position of P8 field.
	PIO_ESR_P8_Pos = 0x8
	// Bit mask of P8 field.
	PIO_ESR_P8_Msk = 0x100
	// Bit P8.
	PIO_ESR_P8 = 0x100
	// Position of P9 field.
	PIO_ESR_P9_Pos = 0x9
	// Bit mask of P9 field.
	PIO_ESR_P9_Msk = 0x200
	// Bit P9.
	PIO_ESR_P9 = 0x200
	// Position of P10 field.
	PIO_ESR_P10_Pos = 0xa
	// Bit mas