/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ProtocolFamily;
import java.net.SocketAddress;
import java.net.StandardProtocolFamily;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;

class Jre16Compat
extends JreCompat {
    private static final Log log = LogFactory.getLog(Jre16Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre16Compat.class);
    private static final Class<?> unixDomainSocketAddressClazz;
    private static final Method openServerSocketChannelFamilyMethod;
    private static final Method unixDomainSocketAddressOfMethod;
    private static final Method openSocketChannelFamilyMethod;

    Jre16Compat() {
    }

    static boolean isSupported() {
        return unixDomainSocketAddressClazz != null;
    }

    @Override
    public SocketAddress getUnixDomainSocketAddress(String string) {
        try {
            return (SocketAddress)unixDomainSocketAddressOfMethod.invoke(null, string);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new UnsupportedOperationException(exception);
        }
    }

    @Override
    public ServerSocketChannel openUnixDomainServerSocketChannel() {
        try {
            return (ServerSocketChannel)openServerSocketChannelFamilyMethod.invoke(null, StandardProtocolFamily.valueOf("UNIX"));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new UnsupportedOperationException(exception);
        }
    }

    @Override
    public SocketChannel openUnixDomainSocketChannel() {
        try {
            return (SocketChannel)openSocketChannelFamilyMethod.invoke(null, StandardProtocolFamily.valueOf("UNIX"));
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new UnsupportedOperationException(exception);
        }
    }

    static {
        Class<?> clazz = null;
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        try {
            clazz = Class.forName("java.net.UnixDomainSocketAddress");
            method = ServerSocketChannel.class.getMethod("open", ProtocolFamily.class);
            method2 = clazz.getMethod("of", String.class);
            method3 = SocketChannel.class.getMethod("open", ProtocolFamily.class);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.debug((Object)sm.getString("jre16Compat.javaPre16"), (Throwable)classNotFoundException);
        }
        catch (IllegalArgumentException | ReflectiveOperationException exception) {
            log.error((Object)sm.getString("jre16Compat.unexpected"), (Throwable)exception);
        }
        unixDomainSocketAddressClazz = clazz;
        openServerSocketChannelFamilyMethod = method;
        unixDomainSocketAddressOfMethod = method2;
        openSocketChannelFamilyMethod = method3;
    }
}

