/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.lms;

import java.io.IOException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.lms.LMS;
import org.bouncycastle.pqc.crypto.lms.LMSPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSPublicKeyParameters;
import org.bouncycastle.pqc.crypto.lms.LMSSignature;

public class LMSSigner
implements MessageSigner {
    private LMSPrivateKeyParameters privKey;
    private LMSPublicKeyParameters pubKey;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            this.privKey = (LMSPrivateKeyParameters)param;
        } else {
            this.pubKey = (LMSPublicKeyParameters)param;
        }
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        try {
            return LMS.generateSign(this.privKey, message).getEncoded();
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to encode signature: " + e.getMessage());
        }
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        try {
            return LMS.verifySignature(this.pubKey, LMSSignature.getInstance(signature), message);
        }
        catch (IOException e) {
            throw new IllegalStateException("unable to decode signature: " + e.getMessage());
        }
    }
}

