/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.export.MeshData;
import org.jmol.export.__CartesianExporter;
import org.jmol.modelset.Atom;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.Viewer;

public class _ObjExporter
extends __CartesianExporter {
    private static final boolean debug = false;
    private boolean surfacesOnly = false;
    private boolean normalizeUV = true;
    private OC mtlout;
    String objFileRootName;
    private int nMtlBytes;
    Set<Short> textures = new HashSet<Short>();
    Lst<String> textureFiles;
    private int sphereNum = 1;
    private int cylinderNum = 1;
    private int ellipseNum = 1;
    private int circleNum = 1;
    private int ellipsoidNum = 1;
    private int coneNum = 1;
    private int triangleNum = 1;
    private int surfaceNum = 1;
    private int currentVertexOrigin = 1;
    private int currentNormalOrigin = 1;
    private int currentTextureOrigin = 1;
    private final P3 ptTemp = new P3();

    public _ObjExporter() {
        this.debugPrint("_WavefrontObjExporter CTOR");
        this.commentChar = "# ";
    }

    protected void debugPrint(String string) {
    }

    @Override
    protected void outputFace(int[] face, int[] map, int faceVertexMax) {
    }

    @Override
    protected void outputCircle(P3 pt1, P3 pt2, float radius, short colix, boolean doFill) {
        this.debugPrint("outputCircle");
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        if (doFill) {
            this.outputCircle1(pt1, pt2, colix, radius);
        }
    }

    @Override
    protected void outputCone(P3 ptBase, P3 ptTip, float radius, short colix) {
        this.debugPrint("outputCone");
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        this.outputCone1(ptBase, ptTip, radius, colix);
    }

    @Override
    protected boolean outputCylinder(P3 ptCenter, P3 pt1, P3 pt2, short colix, byte endcaps, float radius, P3 ptX, P3 ptY, boolean checkRadius) {
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return true;
        }
        if (ptX != null) {
            if (endcaps == 2) {
                this.outputEllipse1(ptCenter, pt1, ptX, ptY, colix);
                this.tempP3.add2(ptCenter, ptCenter);
                this.tempP3.sub(ptX);
                this.outputEllipse1(ptCenter, pt2, this.tempP3, ptY, colix);
            }
        } else if (endcaps == 3) {
            this.outputSphere(pt1, radius * 1.01f, colix, true);
            this.outputSphere(pt2, radius * 1.01f, colix, true);
        } else if (endcaps == 2) {
            this.outputCircle1(pt1, pt2, colix, radius);
            this.outputCircle1(pt2, pt1, colix, radius);
        }
        this.outputCylinder1(ptCenter, pt1, pt2, colix, endcaps, radius, ptX, ptY);
        return true;
    }

    @Override
    protected void outputEllipsoid(P3 center, P3[] points, short colix) {
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        A4 a = Quat.getQuaternionFrame(center, points[1], points[3]).toAxisAngle4f();
        float sx = points[1].distance(center);
        float sy = points[3].distance(center);
        float sz = points[5].distance(center);
        this.outputEllipsoid1(center, sx, sy, sz, a, colix);
    }

    @Override
    protected void outputSphere(P3 center, float radius, short colix, boolean checkRadius) {
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        this.outputEllipsoid1(center, radius, radius, radius, null, colix);
    }

    @Override
    protected void outputTextPixel(P3 pt, int argb) {
    }

    @Override
    protected void outputTriangle(T3 pt1, T3 pt2, T3 pt3, short colix) {
        if (this.surfacesOnly) {
            return;
        }
        this.outputTriangle1(pt1, pt2, pt3, colix);
    }

    @Override
    protected void outputHeader() {
        this.debugPrint("outputHeader");
        this.output("#obj Created by Jmol " + Viewer.getJmolVersion() + "\n");
    }

    @Override
    protected void output(T3 pt) {
        this.debugPrint("output");
    }

    @Override
    protected void drawSurface(MeshSurface meshSurface, short colix) {
        int i0;
        if (Logger.debugging) {
            this.debugPrint("outputSurface");
            this.debugPrint("  nVertices=" + meshSurface.vc);
            if (meshSurface.normals == null) {
                this.debugPrint("  no vertex normals");
            } else {
                this.debugPrint("  nNormals=" + meshSurface.vc);
            }
            if (meshSurface.vcs == null) {
                this.debugPrint("  no vertex colors");
            } else {
                this.debugPrint("  nColixes=" + meshSurface.vc);
            }
            this.debugPrint("  number of triangles or quads=" + meshSurface.pc);
            if (meshSurface.pcs == null) {
                this.debugPrint("  no face colors");
            } else {
                this.debugPrint("  nPolygonColixes=" + meshSurface.pc);
            }
            if (meshSurface.bsPolygons == null) {
                this.debugPrint("  all polygons used");
            } else {
                this.debugPrint("  number of polygons used=" + meshSurface.bsPolygons.cardinality());
            }
            this.debugPrint("  solid color=" + this.gdata.getColorArgbOrGray(colix));
        }
        BS bsPolygons = meshSurface.bsPolygons;
        int nPolygons = meshSurface.pc;
        if (meshSurface.normals != null) {
            meshSurface.normalCount = meshSurface.vc;
        }
        boolean isAll = bsPolygons == null;
        int[][] faces = AU.newInt2(isAll ? nPolygons : bsPolygons.cardinality());
        int i = i0 = isAll ? nPolygons - 1 : bsPolygons.nextSetBit(0);
        int ipt = 0;
        while (i >= 0) {
            int[] nArray;
            int[] polygon = meshSurface.pis[i];
            int n = ipt++;
            if (meshSurface.haveQuads) {
                nArray = polygon;
            } else {
                int[] nArray2 = new int[3];
                nArray2[0] = polygon[0];
                nArray2[1] = polygon[1];
                nArray = nArray2;
                nArray2[2] = polygon[2];
            }
            faces[n] = nArray;
            i = isAll ? i - 1 : bsPolygons.nextSetBit(i + 1);
        }
        MeshSurface data = MeshSurface.newMesh(false, meshSurface.vs, meshSurface.vc, faces, meshSurface.normals, 0);
        data.vcs = meshSurface.vcs;
        String name = "Surface" + this.surfaceNum++;
        boolean isSolidColor = colix != 0;
        this.addTexture(colix, isSolidColor ? null : name);
        int[] dim = null;
        if (isSolidColor) {
            this.debugPrint("outputSurface: coloring solid");
            this.debugPrint("  Omitting texture map");
        } else {
            int nFaces = faces.length;
            int width = (int)Math.ceil(Math.sqrt(nFaces));
            int height = nFaces / width;
            if (nFaces % width != 0) {
                // empty if block
            }
            dim = new int[]{width, ++height};
            this.debugPrint("  width=" + width + " height=" + height + " size = " + width * height);
            OC file = this.createTextureFile(name, data, dim);
            if (file == null || file.getByteCount() == 0) {
                System.out.println("Error creating texture file: " + name);
                this.textureFiles.addLast("Error creating texture file: " + name);
                return;
            }
            this.textureFiles.addLast(file.getByteCount() + " (" + width + "x" + height + ") " + name);
            String shortName = file.getName();
            this.outputMtl(" map_Kd " + shortName + "\n");
            this.outputMtl(" map_Ka " + shortName + "\n");
        }
        M4 matrix = M4.newM4(null);
        matrix.setTranslation(V3.newV(meshSurface.offset));
        BS bsValid = new BS();
        this.addMesh(name, data, matrix, null, colix, dim, bsValid);
    }

    @Override
    boolean initializeOutput(Viewer vwr, double privateKey, GData gdata, Map<String, Object> params) {
        this.debugPrint("initializeOutput: + output");
        boolean retVal = this.initOutput(vwr, privateKey, gdata, params);
        if (!retVal) {
            this.debugPrint("End initializeOutput (error in super):");
            return false;
        }
        if (this.fileName == null) {
            throw new NullPointerException("Cannot output two files (OBJ and MTL) to string");
        }
        int dot = this.fileName.lastIndexOf(".");
        if (dot < 0) {
            this.debugPrint("End initializeOutput (Error creating .mtl file):");
            return false;
        }
        this.objFileRootName = this.fileName.substring(0, dot);
        try {
            String mtlFileName = this.objFileRootName + ".mtl";
            this.mtlout = vwr.openExportChannel(privateKey, mtlFileName, true);
        }
        catch (Exception ex) {
            this.debugPrint("End initializeOutput (" + ex.getMessage() + "):");
            return false;
        }
        this.outputMtl("# Created by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("\nmtllib " + this.mtlout.getName() + "\n");
        this.textureFiles = new Lst();
        this.debugPrint("End initializeOutput:");
        return true;
    }

    @Override
    protected String finalizeOutput() {
        this.debugPrint("finalizeOutput");
        String retVal = this.finalizeOutput2();
        String ret = this.mtlout.closeChannel();
        if (ret != null) {
            Logger.info(ret);
            ret = "ERROR EXPORTING MTL FILE: " + ret;
            if (retVal.startsWith("OK")) {
                return ret;
            }
            return retVal + " and " + ret;
        }
        retVal = retVal + ", " + this.nMtlBytes + " " + this.mtlout.getFileName();
        for (String string : this.textureFiles) {
            retVal = retVal + ", " + string;
        }
        this.debugPrint(retVal);
        this.debugPrint("End finalizeOutput:");
        return retVal;
    }

    private void outputMtl(String data) {
        this.nMtlBytes += data.length();
        this.mtlout.append(data);
    }

    private String getTextureName(short colix) {
        return "k" + Escape.getHexColorFromRGB(this.gdata.getColorArgbOrGray(colix));
    }

    private void outputCircle1(P3 ptCenter, P3 ptPerp, short colix, float radius) {
        MeshSurface data = MeshData.getCircleData();
        M4 matrix = new M4();
        this.addTexture(colix, null);
        String name = "Circle" + this.circleNum++;
        matrix.setToM3(this.getRotationMatrix(ptCenter, ptPerp, radius));
        matrix.m03 = ptCenter.x;
        matrix.m13 = ptCenter.y;
        matrix.m23 = ptCenter.z;
        matrix.m33 = 1.0f;
        this.addMesh(name, data, matrix, matrix, colix, null, null);
    }

    private void outputCone1(P3 ptBase, P3 ptTip, float radius, short colix) {
        MeshSurface data = MeshData.getConeData();
        M4 matrix = new M4();
        this.addTexture(colix, null);
        String name = "Cone" + this.coneNum++;
        matrix.setToM3(this.getRotationMatrix(ptBase, ptTip, radius));
        matrix.m03 = ptBase.x;
        matrix.m13 = ptBase.y;
        matrix.m23 = ptBase.z;
        matrix.m33 = 1.0f;
        this.addMesh(name, data, matrix, matrix, colix, null, null);
    }

    private boolean outputEllipse1(P3 ptCenter, P3 ptZ, P3 ptX, P3 ptY, short colix) {
        MeshSurface data = MeshData.getCircleData();
        M4 matrix = new M4();
        this.addTexture(colix, null);
        String name = "Ellipse" + this.ellipseNum++;
        matrix.setToM3(this.getRotationMatrix(ptCenter, ptZ, 1.0f, ptX, ptY));
        matrix.m03 = ptZ.x;
        matrix.m13 = ptZ.y;
        matrix.m23 = ptZ.z;
        matrix.m33 = 1.0f;
        this.addMesh(name, data, matrix, matrix, colix, null, null);
        return true;
    }

    private void outputEllipsoid1(T3 center, float rx, float ry, float rz, A4 a, short colix) {
        String name;
        MeshSurface data = MeshSurface.getSphereData(3);
        this.addTexture(colix, null);
        if (center instanceof Atom) {
            Atom atom = (Atom)center;
            name = PT.replaceAllCharacters(atom.getAtomName(), " \t", "") + "_Atom";
        } else {
            name = rx == ry && rx == rz ? "Sphere" + this.sphereNum++ : "Ellipsoid" + this.ellipsoidNum++;
        }
        this.setSphereMatrix(center, rx, ry, rz, a, this.sphereMatrix);
        this.addMesh(name, data, this.sphereMatrix, this.sphereMatrix, colix, null, null);
    }

    private void outputCylinder1(P3 ptCenter, P3 pt1, P3 pt2, short colix, byte endcaps, float radius, P3 ptX, P3 ptY) {
        MeshSurface data = MeshData.getCylinderData(false);
        M4 matrix = new M4();
        this.addTexture(colix, null);
        String name = "Cylinder" + this.cylinderNum++;
        int n = ptX != null && endcaps == 0 ? 2 : 1;
        for (int i = 0; i < n; ++i) {
            if (ptX == null) {
                matrix.setToM3(this.getRotationMatrix(pt1, pt2, radius));
            } else {
                matrix.setToM3(this.getRotationMatrix(ptCenter, pt2, radius, ptX, ptY));
            }
            matrix.m03 = pt1.x;
            matrix.m13 = pt1.y;
            matrix.m23 = pt1.z;
            matrix.m33 = 1.0f;
        }
        this.addMesh(name, data, matrix, matrix, colix, null, null);
    }

    private void outputTriangle1(T3 pt1, T3 pt2, T3 pt3, short colix) {
        MeshSurface data = MeshData.getTriangleData(pt1, pt2, pt3);
        this.addTexture(colix, null);
        String name = "Triangle" + this.triangleNum++;
        M4 matrix = M4.newM4(null);
        this.addMesh(name, data, matrix, matrix, colix, null, null);
    }

    private void addTexture(short colix, String name) {
        Short scolix = colix;
        if (name == null && this.textures.contains(scolix)) {
            return;
        }
        this.textures.add(scolix);
        SB sb = new SB();
        sb.append("\nnewmtl " + (name == null ? this.getTextureName(colix) : name) + "\n");
        sb.append(" Ns 163\n");
        sb.append(" Tr " + _ObjExporter.opacityFractionalFromColix(colix) + "\n");
        sb.append(" Ni 0.001\n");
        sb.append(" illum 2\n");
        sb.append(" Ka 0.20 0.20 0.20\n");
        sb.append(" Kd " + this.rgbFractionalFromColix(colix) + "\n");
        sb.append(" Ks 0.25 0.25 0.25\n");
        this.outputMtl(sb.toString());
    }

    private void addMesh(String name, MeshSurface data, M4 matrix, M4 matrix1, short colix, int[] dim, BS bsValid) {
        int i;
        if (this.surfacesOnly && (name == null || !name.startsWith("Surface"))) {
            return;
        }
        this.output("\ng " + name + "\n");
        this.output("usemtl " + (dim == null ? this.getTextureName(colix) : name) + "\n");
        int[][] faces = data.getFaces();
        int nFaces = faces.length;
        if (bsValid != null) {
            int[][] nArray = faces;
            int n = nArray.length;
            for (int j = 0; j < n; ++j) {
                int[] face;
                for (int i2 : face = nArray[j]) {
                    bsValid.set(i2);
                }
            }
        }
        T3[] vertices = data.getVertices();
        int nVertices = data.vc;
        int[] map = new int[nVertices];
        int nCoord = this.getCoordinateMap(vertices, map, bsValid);
        this.output("# Number of vertices: " + nCoord + "\n");
        this.outputList(vertices, nVertices, matrix, "v ", bsValid);
        nVertices = nCoord;
        T3[] normals = data.normals;
        int nNormals = data.normalCount;
        int[] map2 = null;
        Lst<String> vNormals = null;
        if (normals != null) {
            vNormals = new Lst<String>();
            map2 = this.getNormalMap(normals, nNormals, bsValid, vNormals);
            nNormals = vNormals.size();
            this.output("# Number of normals: " + nNormals + "\n");
            for (i = 0; i < nNormals; ++i) {
                this.output("vn " + (String)vNormals.get(i));
            }
        }
        if (dim != null) {
            this.output("# Number of texture coordinates: " + nFaces + "\n");
            int width = dim[0];
            int height = dim[1];
            int iFace = 0;
            block3: for (int row = 0; row < height; ++row) {
                float v = (float)row + 0.5f;
                if (this.normalizeUV) {
                    v /= (float)height;
                }
                for (int col = 0; col < width; ++col) {
                    float u = (float)col + 0.5f;
                    if (this.normalizeUV) {
                        u /= (float)width;
                    }
                    this.output("vt " + u + " " + v + "\n");
                    if (++iFace == nFaces) continue block3;
                }
            }
            if (!this.normalizeUV) {
                this.output("vt 0.0 0.0\n");
                this.output("vt " + (float)width + " " + (float)height + "\n");
            }
        }
        this.output("# Number of faces: " + nFaces + "\n");
        for (i = 0; i < nFaces; ++i) {
            if (dim != null) {
                this.outputFace2(faces[i], i, map, map2);
                continue;
            }
            this.outputFace1(faces[i], map, map2);
        }
        if (dim != null) {
            this.currentTextureOrigin += nFaces;
        }
        this.currentVertexOrigin += nVertices;
        this.currentNormalOrigin += nNormals;
    }

    private void outputList(T3[] pts, int nPts, M4 m, String prefix, BS bsValid) {
        for (int i = 0; i < nPts; ++i) {
            if (bsValid != null && !bsValid.get(i)) continue;
            this.ptTemp.setT(pts[i]);
            if (m != null) {
                m.rotTrans(this.ptTemp);
            }
            this.output(prefix + this.ptTemp.x + " " + this.ptTemp.y + " " + this.ptTemp.z + "\n");
        }
    }

    private void outputFace1(int[] face, int[] map, int[] map2) {
        this.output("f");
        for (int i : face) {
            this.output(" " + ((map == null ? i : map[i]) + this.currentVertexOrigin) + "//" + ((map2 == null ? i : map2[i]) + this.currentNormalOrigin));
        }
        this.output("\n");
    }

    private void outputFace2(int[] face, int vt, int[] map, int[] map2) {
        this.output("f");
        for (int i : face) {
            this.output(" " + ((map == null ? i : map[i]) + this.currentVertexOrigin) + "/" + (this.currentTextureOrigin + vt) + "/" + ((map2 == null ? i : map2[i]) + this.currentNormalOrigin));
        }
        this.output("\n");
    }

    private OC createTextureFile(String name, MeshSurface data, int[] dim) {
        short[] colixes;
        this.debugPrint("createTextureFile: " + name);
        short[] sArray = colixes = data.pcs == null ? data.vcs : data.pcs;
        if (colixes == null || colixes.length == 0) {
            this.debugPrint("createTextureFile: Array problem");
            this.debugPrint("  colixes=" + colixes + " data=" + data);
            if (colixes != null) {
                this.debugPrint("  colixes.length=" + colixes.length);
            }
            return null;
        }
        int nUsed = data.pis.length;
        if (nUsed <= 0) {
            this.debugPrint("createTextureFile: nFaces = 0");
            return null;
        }
        int width = dim[0];
        int height = dim[1];
        String textureType = "png";
        int row = height - 1;
        int col = 0;
        P3 sum = new P3();
        int w = width * 3;
        int h = height * 3;
        byte[][] bytes = textureType.equals("tga") ? new byte[h][w * 3] : (byte[][])null;
        int[] rgbbuf = bytes == null ? new int[h * w] : null;
        P3 ptTemp = new P3();
        for (int i = 0; i < data.pis.length; ++i) {
            int rgb;
            if (data.pcs == null) {
                int[] face = data.pis[i];
                sum.set(0.0f, 0.0f, 0.0f);
                for (int iVertex : face) {
                    sum.add(CU.colorPtFromInt(this.gdata.getColorArgbOrGray(colixes[iVertex]), ptTemp));
                }
                sum.scale(1.0f / (float)face.length);
                rgb = CU.colorPtToFFRGB(sum);
            } else {
                rgb = this.gdata.getColorArgbOrGray(colixes[i]);
            }
            if (bytes == null) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        rgbbuf[(row * 3 + k) * w + col * 3 + j] = rgb;
                    }
                }
            }
            if ((col = (col + 1) % width) != 0) continue;
            --row;
        }
        try {
            Hashtable<String, Object> params = new Hashtable<String, Object>();
            String fname = this.fileName;
            if (rgbbuf != null) {
                params.put("rgbbuf", rgbbuf);
                params.put("fileName", this.objFileRootName + "_" + name + "." + textureType);
                params.put("type", textureType);
                params.put("width", w);
                params.put("height", h);
                fname = this.fileName = this.vwr.outputToFile(params);
            }
            this.debugPrint("End createTextureFile: " + fname);
            return (OC)params.get("outputChannel");
        }
        catch (Exception ex) {
            this.debugPrint("End createTextureFile (" + ex.getMessage() + "):");
            return null;
        }
    }
}

