/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.caches.CollectionStubComputer;
import org.jetbrains.kotlin.backend.jvm.caches.StubsForCollectionClass;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.CollectionStubMethodLoweringKt;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeCheckerStateKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextWithAdditionalAxioms;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.TypeCheckerState;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@PhaseDescription(name="CollectionStubMethod", description="Generate Collection stub methods")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001:\u0002IJB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J \u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u001a*\u00020\fH\u0002J,\u0010\u001b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00160\u001eH\u0002J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\f2\u0006\u0010$\u001a\u00020\fH\u0002J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\fH\u0002J \u0010)\u001a\u00020\"2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010*\u001a\u00020&H\u0002J \u0010+\u001a\u00020\"2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010*\u001a\u00020&H\u0002J%\u0010,\u001a\u00020\"2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\f2\u0006\u0010*\u001a\u00020&H\u0000\u00a2\u0006\u0002\b-J(\u0010.\u001a\u00020/*\u00020/2\u0006\u00100\u001a\u00020\f2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00160\u001eH\u0002J(\u00101\u001a\u00020/*\u00020/2\u0006\u00100\u001a\u00020\f2\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001603H\u0002J,\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u00160\u001e2\u0006\u00105\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u00122\u0006\u00107\u001a\u00020\u0012H\u0002J\u0016\u00108\u001a\b\u0012\u0004\u0012\u00020\f092\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010:\u001a\b\u0012\u0004\u0012\u00020\f09*\u00020;2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010<\u001a\b\u0012\u0004\u0012\u00020;092\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020;092\u0006\u0010>\u001a\u00020\u0012H\u0002J\u001a\u0010?\u001a\u00020\u0016*\b\u0012\u0004\u0012\u00020\u00160@2\u0006\u0010A\u001a\u00020BH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010>\u001a\u0004\u0018\u00010\u0012*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bC\u0010DR\u001e\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00120F*\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010H\u00a8\u0006K"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/CollectionStubMethodLowering;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "collectionStubComputer", "Lorg/jetbrains/kotlin/backend/jvm/caches/CollectionStubComputer;", "nameAndArity", "Lorg/jetbrains/kotlin/backend/jvm/lower/CollectionStubMethodLowering$NameAndArity;", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getNameAndArity", "(Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;)Lorg/jetbrains/kotlin/backend/jvm/lower/CollectionStubMethodLowering$NameAndArity;", "lower", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "createRemoveAtStub", "removeAtStub", "stubReturnType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "stubOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "toJvmSignature", "", "createStubMethod", "function", "substitutionMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "liftStubMethodReturnType", "isEffectivelyOverriddenBy", "", "superFun", "overridingFun", "createTypeCheckerState", "Lorg/jetbrains/kotlin/types/TypeCheckerState;", "overrideFun", "parentFun", "areTypeParametersEquivalent", "typeChecker", "areValueParametersEquivalent", "isReturnTypeOverrideCompliant", "isReturnTypeOverrideCompliant$backend_jvm_lower", "copyWithSubstitution", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "target", "copyWithCustomTypeSubstitution", "substituteType", "Lkotlin/Function1;", "computeSubstitutionMap", "readOnlyClass", "mutableClass", "targetClass", "generateRelevantStubMethods", "", "createStubFuns", "Lorg/jetbrains/kotlin/backend/jvm/caches/StubsForCollectionClass;", "computeStubsForSuperClasses", "computeStubsForSuperClass", "superClass", "findMostSpecificTypeForClass", "", "classifier", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getSuperClass", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "superClassChain", "Lkotlin/sequences/Sequence;", "getSuperClassChain", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)Lkotlin/sequences/Sequence;", "NameAndArity", "FilteredStubsForCollectionClass", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nCollectionStubMethodLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionStubMethodLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/CollectionStubMethodLowering\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,390:1\n2707#2,10:391\n992#2:514\n1021#2,3:515\n1024#2,3:525\n1485#3:401\n1510#3,3:402\n1513#3,3:412\n1485#3:415\n1510#3,3:416\n1513#3,3:426\n774#3:429\n865#3,2:430\n1863#3,2:432\n774#3:434\n865#3,2:435\n1557#3:437\n1628#3,3:438\n1557#3:441\n1628#3,3:442\n1557#3:449\n1628#3,3:450\n1557#3:457\n1628#3,3:458\n1734#3,2:461\n1734#3,3:463\n1736#3:466\n1734#3,3:467\n1611#3,9:475\n1863#3:484\n1864#3:486\n1620#3:487\n1557#3:488\n1628#3,3:489\n1368#3:492\n1454#3,5:493\n1368#3:498\n1454#3,5:499\n1628#3,3:504\n774#3:507\n865#3,2:508\n1557#3:510\n1628#3,3:511\n1557#3:528\n1628#3,2:529\n774#3:531\n865#3:532\n2632#3,3:533\n866#3:536\n1630#3:537\n774#3:538\n865#3,2:539\n230#3:541\n1734#3,3:542\n231#3:545\n1611#3,9:546\n1863#3:555\n1864#3:557\n1620#3:558\n669#3,11:559\n381#4,7:405\n381#4,7:419\n381#4,7:518\n237#5,4:445\n237#5,4:453\n343#5,2:470\n345#5,2:473\n1#6:472\n1#6:485\n1#6:556\n*S KotlinDebug\n*F\n+ 1 CollectionStubMethodLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/CollectionStubMethodLowering\n*L\n60#1:391,10\n344#1:514\n344#1:515,3\n344#1:525,3\n61#1:401\n61#1:402,3\n61#1:412,3\n62#1:415\n62#1:416,3\n62#1:426,3\n67#1:429\n67#1:430,2\n70#1:432,2\n86#1:434\n86#1:435,2\n87#1:437\n87#1:438,3\n103#1:441\n103#1:442,3\n148#1:449\n148#1:450,3\n176#1:457\n176#1:458,3\n234#1:461,2\n236#1:463,3\n234#1:466\n247#1:467,3\n288#1:475,9\n288#1:484\n288#1:486\n288#1:487\n297#1:488\n297#1:489,3\n303#1:492\n303#1:493,5\n307#1:498\n307#1:499,5\n308#1:504,3\n310#1:507\n310#1:508,2\n315#1:510\n315#1:511,3\n348#1:528\n348#1:529,2\n353#1:531\n353#1:532\n356#1:533,3\n353#1:536\n348#1:537\n365#1:538\n365#1:539,2\n369#1:541\n370#1:542,3\n369#1:545\n375#1:546,9\n375#1:555\n375#1:557\n375#1:558\n375#1:559,11\n61#1:405,7\n62#1:419,7\n344#1:518,7\n137#1:445,4\n163#1:453,4\n270#1:470,2\n270#1:473,2\n288#1:485\n375#1:556\n*E\n"})
public final class CollectionStubMethodLowering
implements ClassLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final CollectionStubComputer collectionStubComputer;

    public CollectionStubMethodLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter(context, "context");
        this.context = context;
        this.collectionStubComputer = this.context.getCollectionStubComputer();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    private final NameAndArity getNameAndArity(IrSimpleFunction $this$nameAndArity) {
        return new NameAndArity($this$nameAndArity.getName(), $this$nameAndArity.getTypeParameters().size(), $this$nameAndArity.getValueParameters().size());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter(irClass, "irClass");
        if (IrUtilsKt.isInterface(irClass)) {
            return;
        }
        methodStubsToGenerate = this.generateRelevantStubMethods(irClass);
        if (methodStubsToGenerate.isEmpty()) {
            return;
        }
        $this$partition$iv = IrUtilsKt.getFunctions(irClass);
        $i$f$partition = false;
        first$iv = new ArrayList<IrSimpleFunction>();
        second$iv = new ArrayList<IrSimpleFunction>();
        var8_8 = $this$partition$iv.iterator();
        while (var8_8.hasNext()) {
            element$iv = var8_8.next();
            it = element$iv;
            $i$a$-partition-CollectionStubMethodLowering$lower$1 = false;
            v0 = (it.getModality() == Modality.ABSTRACT && it.isFakeOverride() != false) != false ? first$iv.add((IrSimpleFunction)element$iv) : second$iv.add((IrSimpleFunction)element$iv);
        }
        var3_17 = new Pair<ArrayList<E>, ArrayList<E>>(first$iv, second$iv);
        abstractMethods = var3_17.component1();
        nonAbstractMethods = var3_17.component2();
        $this$groupBy$iv = nonAbstractMethods;
        $i$f$groupBy = false;
        element$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            it = (IrSimpleFunction)element$iv$iv;
            $i$a$-groupBy-CollectionStubMethodLowering$lower$nonAbstractMethodsByNameAndArity$1 = false;
            key$iv$iv = this.getNameAndArity(it);
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                v1 /* !! */  = answer$iv$iv$iv;
            } else {
                v1 /* !! */  = value$iv$iv$iv;
            }
            list$iv$iv = (List)v1 /* !! */ ;
            list$iv$iv.add(element$iv$iv);
        }
        nonAbstractMethodsByNameAndArity = destination$iv$iv;
        $this$groupBy$iv = abstractMethods;
        $i$f$groupBy = false;
        destination$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap<K, V>();
        $i$f$groupByTo = false;
        for (E element$iv$iv : $this$groupByTo$iv$iv) {
            it = (IrSimpleFunction)element$iv$iv;
            $i$a$-groupBy-CollectionStubMethodLowering$lower$abstractMethodsByNameAndArity$1 = false;
            key$iv$iv = this.getNameAndArity(it);
            $this$getOrPut$iv$iv$iv = destination$iv$iv;
            $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                $i$a$-getOrPut-CollectionsKt___CollectionsKt$groupByTo$list$1$iv$iv = false;
                answer$iv$iv$iv = new ArrayList<E>();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                v2 /* !! */  = answer$iv$iv$iv;
            } else {
                v2 /* !! */  = value$iv$iv$iv;
            }
            list$iv$iv = (List)v2 /* !! */ ;
            list$iv$iv.add(element$iv$iv);
        }
        abstractMethodsByNameAndArity = destination$iv$iv;
        block7: for (IrSimpleFunction stub : methodStubsToGenerate) {
            stubNameAndArity = this.getNameAndArity(stub);
            v3 = (List<T>)nonAbstractMethodsByNameAndArity.get(stubNameAndArity);
            if (v3 == null) {
                v3 = CollectionsKt.emptyList();
            }
            relevantMembers = v3;
            $this$filter$iv = relevantMembers;
            $i$f$filter = false;
            it = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            $this$getOrPut$iv$iv$iv = $this$filterTo$iv$iv.iterator();
            while ($this$getOrPut$iv$iv$iv.hasNext()) {
                element$iv$iv = $this$getOrPut$iv$iv$iv.next();
                it = (IrSimpleFunction)element$iv$iv;
                $i$a$-filter-CollectionStubMethodLowering$lower$existingOverrides$1 = false;
                if (!this.isEffectivelyOverriddenBy(stub, it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            existingOverrides = (List)destination$iv$iv;
            if (((Collection)existingOverrides).isEmpty() == false) {
                $this$forEach$iv = existingOverrides;
                $i$f$forEach = false;
                $this$filterTo$iv$iv = $this$forEach$iv.iterator();
                while ($this$filterTo$iv$iv.hasNext()) {
                    element$iv = $this$filterTo$iv$iv.next();
                    it = (IrSimpleFunction)element$iv;
                    $i$a$-forEach-CollectionStubMethodLowering$lower$2 = false;
                    JvmIrAttributesKt.setOverridesWithoutStubs(it, CollectionsKt.toList((Iterable)it.getOverriddenSymbols()));
                    it.setOverriddenSymbols((List<? extends IrSimpleFunctionSymbol>)CollectionsKt.plus((Collection)it.getOverriddenSymbols(), (Iterable)stub.getOverriddenSymbols()));
                }
                continue;
            }
            v4 = (List<T>)abstractMethodsByNameAndArity.get(stubNameAndArity);
            if (v4 == null) {
                v4 = CollectionsKt.emptyList();
            }
            $i$f$forEach = v4;
            $i$f$filter = false;
            element$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (IrSimpleFunction)element$iv$iv;
                $i$a$-filter-CollectionStubMethodLowering$lower$overriddenAbstractMethods$1 = false;
                if (!this.isEffectivelyOverriddenBy(it, stub)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            overriddenAbstractMethods = (List)destination$iv$iv;
            $this$filter$iv = overriddenAbstractMethods;
            var30_71 = stub.getOverriddenSymbols();
            var29_70 = stub;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            var19_47 = $this$mapTo$iv$iv.iterator();
            while (var19_47.hasNext()) {
                item$iv$iv = var19_47.next();
                it = (IrSimpleFunction)item$iv$iv;
                var31_72 = destination$iv$iv;
                $i$a$-map-CollectionStubMethodLowering$lower$3 = false;
                var31_72.add(it.getSymbol());
            }
            var31_72 = (List)destination$iv$iv;
            var29_70.setOverriddenSymbols((List<? extends IrSimpleFunctionSymbol>)CollectionsKt.plus(var30_71, (Iterable)var31_72));
            var14_24 = stub.getName().asString();
            switch (var14_24.hashCode()) {
                case -512823337: {
                    if (var14_24.equals("removeAt")) break;
                    ** break;
                }
                case -934610812: {
                    if (!var14_24.equals("remove")) ** break;
                    $this$mapTo$iv$iv = $i$f$map = stub;
                    var29_70 = irClass.getDeclarations();
                    $i$a$-apply-CollectionStubMethodLowering$lower$4 = false;
                    $i$f$mapTo = $this$lower_u24lambda_u249.getValueParameters();
                    var19_47 = $this$lower_u24lambda_u249;
                    $i$f$map = false;
                    it = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var26_67 = (IrValueParameter)item$iv$iv;
                        var27_68 = destination$iv$iv;
                        $i$a$-map-CollectionStubMethodLowering$lower$4$1 = false;
                        var27_68.add(this.copyWithCustomTypeSubstitution((IrValueParameter)it, (IrSimpleFunction)$this$lower_u24lambda_u249, (Function1<IrType, IrType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lower$lambda$9$lambda$8$lambda$7(org.jetbrains.kotlin.backend.jvm.lower.CollectionStubMethodLowering org.jetbrains.kotlin.ir.types.IrType ), (Lorg/jetbrains/kotlin/ir/types/IrType;)Lorg/jetbrains/kotlin/ir/types/IrType;)((CollectionStubMethodLowering)this)));
                    }
                    var19_47.setValueParameters((List)destination$iv$iv);
                    var29_70.add($i$f$map);
                    continue block7;
                }
            }
            removeIntFun = this.createRemoveAtStub(stub, stub.getReturnType(), IrDeclarationOrigin.Companion.getIR_BUILTINS_STUB());
            irClass.getDeclarations().add(removeIntFun);
            removeIntBridgeFun = this.createRemoveAtStub(stub, this.context.getIrBuiltIns().getAnyNType(), IrDeclarationOrigin.Companion.getBRIDGE());
            if (Intrinsics.areEqual(this.toJvmSignature(removeIntBridgeFun), this.toJvmSignature(removeIntFun))) continue;
            irClass.getDeclarations().add(removeIntBridgeFun);
            continue;
lbl179:
            // 3 sources

            irClass.getDeclarations().add(stub);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createRemoveAtStub(IrSimpleFunction removeAtStub, IrType stubReturnType, IrDeclarationOrigin stubOrigin) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrSimpleFunction irSimpleFunction;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
        boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
        IrFunctionBuilder $this$createRemoveAtStub_u24lambda_u2410 = $this$buildFun_u24lambda_u2420$iv;
        boolean bl = false;
        $this$createRemoveAtStub_u24lambda_u2410.setName(Name.identifier("remove"));
        $this$createRemoveAtStub_u24lambda_u2410.setReturnType(stubReturnType);
        $this$createRemoveAtStub_u24lambda_u2410.setVisibility(removeAtStub.getVisibility());
        $this$createRemoveAtStub_u24lambda_u2410.setOrigin(stubOrigin);
        $this$createRemoveAtStub_u24lambda_u2410.setModality(Modality.OPEN);
        IrSimpleFunction $this$createRemoveAtStub_u24lambda_u2414 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
        boolean bl2 = false;
        $this$createRemoveAtStub_u24lambda_u2414.setParent(removeAtStub.getParent());
        IrValueParameter irValueParameter = removeAtStub.getDispatchReceiverParameter();
        $this$createRemoveAtStub_u24lambda_u2414.setDispatchReceiverParameter(irValueParameter != null ? this.copyWithCustomTypeSubstitution(irValueParameter, $this$createRemoveAtStub_u24lambda_u2414, CollectionStubMethodLowering::createRemoveAtStub$lambda$14$lambda$11) : null);
        $this$createRemoveAtStub_u24lambda_u2414.setExtensionReceiverParameter(null);
        Iterable $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = removeAtStub.getValueParameters();
        IrSimpleFunction irSimpleFunction2 = $this$createRemoveAtStub_u24lambda_u2414;
        boolean $i$f$map = false;
        void var10_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void stubParameter;
            IrValueParameter irValueParameter2 = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(this.copyWithCustomTypeSubstitution((IrValueParameter)stubParameter, $this$createRemoveAtStub_u24lambda_u2414, CollectionStubMethodLowering::createRemoveAtStub$lambda$14$lambda$13$lambda$12));
        }
        irSimpleFunction2.setValueParameters((List)destination$iv$iv);
        $this$createRemoveAtStub_u24lambda_u2414.setBody(CollectionStubMethodLoweringKt.createThrowingStubBody(this.context, $this$createRemoveAtStub_u24lambda_u2414));
        return irSimpleFunction;
    }

    private final String toJvmSignature(IrSimpleFunction $this$toJvmSignature) {
        String string2 = this.context.getDefaultMethodSignatureMapper().mapAsmMethod($this$toJvmSignature).toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createStubMethod(IrSimpleFunction function2, IrClass irClass, Map<IrTypeParameterSymbol, ? extends IrType> substitutionMap) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrSimpleFunction irSimpleFunction;
        IrFactory $this$buildFun$iv = this.context.getIrFactory();
        boolean $i$f$buildFun = false;
        IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
        boolean $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = false;
        IrFunctionBuilder $this$createStubMethod_u24lambda_u2415 = $this$buildFun_u24lambda_u2420$iv;
        boolean bl = false;
        $this$createStubMethod_u24lambda_u2415.setName(function2.getName());
        $this$createStubMethod_u24lambda_u2415.setReturnType(org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.substitute(this.liftStubMethodReturnType(function2), substitutionMap));
        $this$createStubMethod_u24lambda_u2415.setVisibility(function2.getVisibility());
        $this$createStubMethod_u24lambda_u2415.setOrigin(IrDeclarationOrigin.Companion.getIR_BUILTINS_STUB());
        $this$createStubMethod_u24lambda_u2415.setModality(Modality.OPEN);
        IrSimpleFunction $this$createStubMethod_u24lambda_u2417 = irSimpleFunction = DeclarationBuildersKt.buildFunction($this$buildFun$iv, $this$buildFun_u24lambda_u2420$iv);
        boolean bl2 = false;
        $this$createStubMethod_u24lambda_u2417.setOverriddenSymbols((List<? extends IrSimpleFunctionSymbol>)CollectionsKt.listOf(function2.getSymbol()));
        $this$createStubMethod_u24lambda_u2417.setParent(irClass);
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        $this$createStubMethod_u24lambda_u2417.setDispatchReceiverParameter(irValueParameter != null ? this.copyWithSubstitution(irValueParameter, $this$createStubMethod_u24lambda_u2417, substitutionMap) : null);
        IrValueParameter irValueParameter2 = function2.getExtensionReceiverParameter();
        $this$createStubMethod_u24lambda_u2417.setExtensionReceiverParameter(irValueParameter2 != null ? this.copyWithSubstitution(irValueParameter2, $this$createStubMethod_u24lambda_u2417, substitutionMap) : null);
        Iterable $i$a$-run-DeclarationBuildersKt$buildFun$1$iv22 = function2.getValueParameters();
        IrSimpleFunction irSimpleFunction2 = $this$createStubMethod_u24lambda_u2417;
        boolean $i$f$map = false;
        void var10_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter3 = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(this.copyWithSubstitution((IrValueParameter)it, $this$createStubMethod_u24lambda_u2417, substitutionMap));
        }
        irSimpleFunction2.setValueParameters((List)destination$iv$iv);
        $this$createStubMethod_u24lambda_u2417.setBody(CollectionStubMethodLoweringKt.createThrowingStubBody(this.context, $this$createStubMethod_u24lambda_u2417));
        return irSimpleFunction;
    }

    private final IrType liftStubMethodReturnType(IrSimpleFunction function2) {
        IrClassSymbol irClassSymbol;
        switch (function2.getName().asString()) {
            case "iterator": {
                irClassSymbol = this.context.getIr().getSymbols().getIterator();
                break;
            }
            case "listIterator": {
                irClassSymbol = this.context.getIr().getSymbols().getListIterator();
                break;
            }
            case "subList": {
                irClassSymbol = this.context.getIr().getSymbols().getList();
                break;
            }
            default: {
                return function2.getReturnType();
            }
        }
        IrClassSymbol klass = irClassSymbol;
        IrClassifierSymbol irClassifierSymbol = klass;
        IrType irType = function2.getReturnType();
        Intrinsics.checkNotNull(irType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        return IrTypesKt.typeWithArguments(irClassifierSymbol, ((IrSimpleType)irType).getArguments());
    }

    private final boolean isEffectivelyOverriddenBy(IrSimpleFunction superFun, IrSimpleFunction overridingFun) {
        if (!Intrinsics.areEqual(superFun.getName(), overridingFun.getName())) {
            return false;
        }
        if (superFun.getTypeParameters().size() != overridingFun.getTypeParameters().size()) {
            return false;
        }
        if (superFun.getValueParameters().size() != overridingFun.getValueParameters().size()) {
            return false;
        }
        if (!superFun.isSuspend() && overridingFun.isSuspend()) {
            return false;
        }
        TypeCheckerState typeChecker = this.createTypeCheckerState(superFun, overridingFun);
        if (!this.areTypeParametersEquivalent(overridingFun, superFun, typeChecker)) {
            return false;
        }
        if (!this.areValueParametersEquivalent(overridingFun, superFun, typeChecker)) {
            return false;
        }
        return this.isReturnTypeOverrideCompliant$backend_jvm_lower(overridingFun, superFun, typeChecker);
    }

    private final TypeCheckerState createTypeCheckerState(IrSimpleFunction overrideFun, IrSimpleFunction parentFun) {
        return IrTypeCheckerStateKt.createIrTypeCheckerState(new IrTypeSystemContextWithAdditionalAxioms(this.context.getTypeSystem(), overrideFun.getTypeParameters(), parentFun.getTypeParameters()));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areTypeParametersEquivalent(IrSimpleFunction overrideFun, IrSimpleFunction parentFun, TypeCheckerState typeChecker) {
        boolean bl;
        block7: {
            void $this$all$iv;
            Iterable iterable = CollectionsKt.zip((Iterable)overrideFun.getTypeParameters(), (Iterable)parentFun.getTypeParameters());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    boolean bl2;
                    block6: {
                        void $this$all$iv2;
                        Pair pair = (Pair)element$iv;
                        boolean bl3 = false;
                        IrTypeParameter typeParameter1 = (IrTypeParameter)pair.component1();
                        IrTypeParameter typeParameter2 = (IrTypeParameter)pair.component2();
                        Iterable iterable2 = CollectionsKt.zip((Iterable)typeParameter1.getSuperTypes(), (Iterable)typeParameter2.getSuperTypes());
                        boolean $i$f$all2 = false;
                        if ($this$all$iv2 instanceof Collection && ((Collection)$this$all$iv2).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv2 : $this$all$iv2) {
                                IrType supertype2;
                                Pair pair2 = (Pair)element$iv2;
                                boolean bl4 = false;
                                IrType supertype1 = (IrType)pair2.component1();
                                if (AbstractTypeChecker.INSTANCE.equalTypes(typeChecker, supertype1, supertype2 = (IrType)pair2.component2())) continue;
                                bl2 = false;
                                break block6;
                            }
                            bl2 = true;
                        }
                    }
                    if (bl2) continue;
                    bl = false;
                    break block7;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean areValueParametersEquivalent(IrSimpleFunction overrideFun, IrSimpleFunction parentFun, TypeCheckerState typeChecker) {
        boolean bl;
        block3: {
            void $this$all$iv;
            Iterable iterable = CollectionsKt.zip((Iterable)overrideFun.getValueParameters(), (Iterable)parentFun.getValueParameters());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl2 = false;
                    IrValueParameter valueParameter1 = (IrValueParameter)pair.component1();
                    IrValueParameter valueParameter2 = (IrValueParameter)pair.component2();
                    if (AbstractTypeChecker.INSTANCE.equalTypes(typeChecker, valueParameter1.getType(), valueParameter2.getType())) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public final boolean isReturnTypeOverrideCompliant$backend_jvm_lower(@NotNull IrSimpleFunction overrideFun, @NotNull IrSimpleFunction parentFun, @NotNull TypeCheckerState typeChecker) {
        Intrinsics.checkNotNullParameter(overrideFun, "overrideFun");
        Intrinsics.checkNotNullParameter(parentFun, "parentFun");
        Intrinsics.checkNotNullParameter(typeChecker, "typeChecker");
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeChecker, (KotlinTypeMarker)overrideFun.getReturnType(), (KotlinTypeMarker)parentFun.getReturnType(), false, 8, null);
    }

    private final IrValueParameter copyWithSubstitution(IrValueParameter $this$copyWithSubstitution, IrSimpleFunction target, Map<IrTypeParameterSymbol, ? extends IrType> substitutionMap) {
        return this.copyWithCustomTypeSubstitution($this$copyWithSubstitution, target, arg_0 -> CollectionStubMethodLowering.copyWithSubstitution$lambda$21(substitutionMap, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final IrValueParameter copyWithCustomTypeSubstitution(IrValueParameter $this$copyWithCustomTypeSubstitution, IrSimpleFunction target, Function1<? super IrType, ? extends IrType> substituteType) {
        IrType irType;
        IrValueParameter parameter = $this$copyWithCustomTypeSubstitution;
        boolean $i$f$buildValueParameter = false;
        IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
        boolean bl = false;
        IrValueParameterBuilder $this$copyWithCustomTypeSubstitution_u24lambda_u2423 = $this$buildValueParameter_u24lambda_u2430$iv;
        boolean bl2 = false;
        $this$copyWithCustomTypeSubstitution_u24lambda_u2423.setOrigin(IrDeclarationOrigin.Companion.getIR_BUILTINS_STUB());
        $this$copyWithCustomTypeSubstitution_u24lambda_u2423.setName(parameter.getName());
        $this$copyWithCustomTypeSubstitution_u24lambda_u2423.setType(substituteType.invoke(parameter.getType()));
        IrValueParameterBuilder irValueParameterBuilder = $this$copyWithCustomTypeSubstitution_u24lambda_u2423;
        IrType irType2 = parameter.getVarargElementType();
        if (irType2 != null) {
            void it;
            IrType irType3 = irType2;
            IrValueParameterBuilder irValueParameterBuilder2 = irValueParameterBuilder;
            boolean bl3 = false;
            irType = substituteType.invoke((IrType)it);
            irValueParameterBuilder = irValueParameterBuilder2;
        } else {
            irType = null;
        }
        irValueParameterBuilder.setVarargElementType(irType);
        $this$copyWithCustomTypeSubstitution_u24lambda_u2423.setCrossInline(parameter.isCrossinline());
        $this$copyWithCustomTypeSubstitution_u24lambda_u2423.setNoinline(parameter.isNoinline());
        return DeclarationBuildersKt.buildValueParameter(((IrDeclaration)target).getFactory(), $this$buildValueParameter_u24lambda_u2430$iv, (IrDeclarationParent)((Object)((IrDeclaration)target)));
    }

    /*
     * WARNING - void declaration
     */
    private final Map<IrTypeParameterSymbol, IrType> computeSubstitutionMap(IrClass readOnlyClass, IrClass mutableClass, IrClass targetClass) {
        void $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        IrType readOnlyClassType = this.findMostSpecificTypeForClass((Collection<? extends IrType>)org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.getAllSubstitutedSupertypes(targetClass), readOnlyClass.getSymbol());
        Intrinsics.checkNotNull(readOnlyClassType, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        Iterable $this$mapNotNull$iv = ((IrSimpleType)readOnlyClassType).getArguments();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            IrType it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            IrTypeArgument it = (IrTypeArgument)element$iv$iv;
            boolean bl2 = false;
            IrTypeProjection irTypeProjection = it instanceof IrTypeProjection ? (IrTypeProjection)it : null;
            if ((irTypeProjection != null ? irTypeProjection.getType() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List readOnlyClassTypeArguments = (List)destination$iv$iv;
        if (readOnlyClassTypeArguments.isEmpty() || readOnlyClassTypeArguments.size() != mutableClass.getTypeParameters().size()) {
            throw new IllegalStateException("Type argument mismatch between immutable class " + IrUtilsKt.getFqNameWhenAvailable(readOnlyClass) + " and mutable class " + IrUtilsKt.getFqNameWhenAvailable(mutableClass) + ", when processingclass " + IrUtilsKt.getFqNameWhenAvailable(targetClass));
        }
        Iterable $this$map$iv = mutableClass.getTypeParameters();
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (IrTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return MapsKt.toMap(CollectionsKt.zip((Iterable)((List)destination$iv$iv), readOnlyClassTypeArguments));
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrSimpleFunction> generateRelevantStubMethods(IrClass irClass) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        void $this$flatMapTo$iv$iv2;
        Iterable $this$flatMap$iv2 = this.collectionStubComputer.stubsForCollectionClasses(irClass);
        boolean $i$f$flatMap22 = false;
        Iterable iterable = $this$flatMap$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            StubsForCollectionClass it = (StubsForCollectionClass)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.createStubFuns(it, irClass);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List classStubFuns = (List)destination$iv$iv;
        if (classStubFuns.isEmpty()) {
            return classStubFuns;
        }
        Iterable $i$f$flatMap22 = this.computeStubsForSuperClasses(irClass);
        boolean $i$f$flatMap = false;
        destination$iv$iv = $this$flatMap$iv;
        Object destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            StubsForCollectionClass it = (StubsForCollectionClass)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.createStubFuns(it, irClass);
            CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv2;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo22 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Object element$iv$iv;
            element$iv$iv = (IrSimpleFunction)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            collection.add(this.toJvmSignature((IrSimpleFunction)it));
        }
        HashSet alreadyPresent = (HashSet)destination$iv;
        Iterable $this$filter$iv = classStubFuns;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv$iv;
            boolean bl = false;
            if (!alreadyPresent.add(this.toJvmSignature(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrSimpleFunction> createStubFuns(StubsForCollectionClass $this$createStubFuns, IrClass irClass) {
        void $this$mapTo$iv$iv;
        Map<IrTypeParameterSymbol, IrType> substitutionMap = this.computeSubstitutionMap((IrClass)$this$createStubFuns.getReadOnlyClass().getOwner(), (IrClass)$this$createStubFuns.getMutableClass().getOwner(), irClass);
        Iterable $this$map$iv = $this$createStubFuns.getCandidatesForStubs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void function2;
            IrSimpleFunction irSimpleFunction = (IrSimpleFunction)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createStubMethod((IrSimpleFunction)function2, irClass, substitutionMap));
        }
        return (List)destination$iv$iv;
    }

    private final List<StubsForCollectionClass> computeStubsForSuperClasses(IrClass irClass) {
        IrClass irClass2 = this.getSuperClass(irClass);
        if (irClass2 == null) {
            return CollectionsKt.emptyList();
        }
        IrClass immediateSuperClass = irClass2;
        return SequencesKt.toList(SequencesKt.flatMapIterable(this.getSuperClassChain(immediateSuperClass), arg_0 -> CollectionStubMethodLowering.computeStubsForSuperClasses$lambda$31(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final List<StubsForCollectionClass> computeStubsForSuperClass(IrClass superClass) {
        void $this$mapTo$iv$iv;
        Object value$iv$iv$iv;
        Object it;
        Iterable $this$groupByTo$iv$iv;
        void $this$groupBy$iv;
        List<StubsForCollectionClass> superClassStubs = this.collectionStubComputer.stubsForCollectionClasses(superClass);
        if (superClassStubs.isEmpty() || superClass.getModality() != Modality.ABSTRACT) {
            return superClassStubs;
        }
        Sequence<IrSimpleFunction> sequence2 = SequencesKt.filter(IrUtilsKt.getFunctions(superClass), CollectionStubMethodLowering::computeStubsForSuperClass$lambda$32);
        boolean $i$f$groupBy = false;
        void var6_5 = $this$groupBy$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (IrSimpleFunction)element$iv$iv;
            boolean bl = false;
            NameAndArity key$iv$iv = this.getNameAndArity((IrSimpleFunction)it);
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object abstractFunsByNameAndArity = destination$iv$iv;
        if (abstractFunsByNameAndArity.isEmpty()) {
            return superClassStubs;
        }
        Iterable $this$map$iv = superClassStubs;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            it = (StubsForCollectionClass)item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            Map<IrTypeParameterSymbol, IrType> substitutionMap = this.computeSubstitutionMap((IrClass)it.getReadOnlyClass().getOwner(), (IrClass)it.getMutableClass().getOwner(), superClass);
            Iterable $this$filter$iv = it.getCandidatesForStubs();
            boolean $i$f$filter = false;
            value$iv$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl3;
                block11: {
                    void $this$none$iv;
                    IrSimpleFunction candidateFun = (IrSimpleFunction)element$iv$iv;
                    boolean bl4 = false;
                    IrSimpleFunction stubMethod = this.createStubMethod(candidateFun, superClass, substitutionMap);
                    NameAndArity stubNameAndArity = this.getNameAndArity(stubMethod);
                    List list = (List)abstractFunsByNameAndArity.get(stubNameAndArity);
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    Iterable iterable = list;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl3 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            IrSimpleFunction abstractFun = (IrSimpleFunction)element$iv;
                            boolean bl5 = false;
                            if (!this.isEffectivelyOverriddenBy(stubMethod, abstractFun)) continue;
                            bl3 = false;
                            break block11;
                        }
                        bl3 = true;
                    }
                }
                if (!bl3) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List filteredCandidates = (List)destination$iv$iv2;
            object.add(new FilteredStubsForCollectionClass(it.getReadOnlyClass(), it.getMutableClass(), filteredCandidates));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final IrType findMostSpecificTypeForClass(Collection<? extends IrType> $this$findMostSpecificTypeForClass, IrClassSymbol classifier) {
        Object element$iv2;
        block8: {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this$findMostSpecificTypeForClass;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                IrType it = (IrType)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(IrTypesKt.getClassifierOrNull(it), classifier)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List types2 = (List)destination$iv$iv;
            if (types2.isEmpty()) {
                throw new IllegalStateException(("No supertype of " + classifier + " in " + $this$findMostSpecificTypeForClass).toString());
            }
            if (types2.size() == 1) {
                return (IrType)CollectionsKt.first(types2);
            }
            Iterable $this$first$iv = types2;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                boolean bl;
                block7: {
                    IrType type2 = (IrType)element$iv2;
                    boolean bl2 = false;
                    Iterable $this$all$iv = types2;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv3 : $this$all$iv) {
                            IrType other = (IrType)element$iv3;
                            boolean bl3 = false;
                            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(other);
                            Intrinsics.checkNotNull(irClassSymbol);
                            if (IrTypeUtilsKt.isSubtypeOfClass(type2, irClassSymbol)) continue;
                            bl = false;
                            break block7;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                break block8;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (IrType)element$iv2;
    }

    /*
     * WARNING - void declaration
     */
    private final IrClass getSuperClass(IrClass $this$superClass) {
        Object v0;
        block3: {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = $this$superClass.getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrClass it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                IrType it = (IrType)element$iv$iv;
                boolean bl2 = false;
                if (IrTypesKt.getClass(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrClass it = (IrClass)element$iv;
                boolean bl = false;
                if (!(!JvmIrUtilsKt.isJvmInterface(it))) continue;
                if (found$iv) {
                    v0 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        return v0;
    }

    private final Sequence<IrClass> getSuperClassChain(IrClass $this$superClassChain) {
        return SequencesKt.generateSequence($this$superClassChain, arg_0 -> CollectionStubMethodLowering._get_superClassChain_$lambda$42(this, arg_0));
    }

    private static final IrType lower$lambda$9$lambda$8$lambda$7(CollectionStubMethodLowering this$0, IrType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.context.getIrBuiltIns().getAnyNType();
    }

    private static final IrType createRemoveAtStub$lambda$14$lambda$11(IrType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it;
    }

    private static final IrType createRemoveAtStub$lambda$14$lambda$13$lambda$12(IrType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it;
    }

    private static final IrType copyWithSubstitution$lambda$21(Map $substitutionMap, IrType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.substitute(it, $substitutionMap);
    }

    private static final Iterable computeStubsForSuperClasses$lambda$31(CollectionStubMethodLowering this$0, IrClass superClass) {
        Intrinsics.checkNotNullParameter(superClass, "superClass");
        return this$0.computeStubsForSuperClass(superClass);
    }

    private static final boolean computeStubsForSuperClass$lambda$32(IrSimpleFunction it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !it.isFakeOverride() && it.getModality() == Modality.ABSTRACT;
    }

    private static final IrClass _get_superClassChain_$lambda$42(CollectionStubMethodLowering this$0, IrClass it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.getSuperClass(it);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/CollectionStubMethodLowering$FilteredStubsForCollectionClass;", "Lorg/jetbrains/kotlin/backend/jvm/caches/StubsForCollectionClass;", "readOnlyClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "mutableClass", "candidatesForStubs", "", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "<init>", "(Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Ljava/util/Collection;)V", "getReadOnlyClass", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getMutableClass", "getCandidatesForStubs", "()Ljava/util/Collection;", "backend.jvm.lower"})
    private static final class FilteredStubsForCollectionClass
    implements StubsForCollectionClass {
        @NotNull
        private final IrClassSymbol readOnlyClass;
        @NotNull
        private final IrClassSymbol mutableClass;
        @NotNull
        private final Collection<IrSimpleFunction> candidatesForStubs;

        public FilteredStubsForCollectionClass(@NotNull IrClassSymbol readOnlyClass, @NotNull IrClassSymbol mutableClass, @NotNull Collection<? extends IrSimpleFunction> candidatesForStubs) {
            Intrinsics.checkNotNullParameter(readOnlyClass, "readOnlyClass");
            Intrinsics.checkNotNullParameter(mutableClass, "mutableClass");
            Intrinsics.checkNotNullParameter(candidatesForStubs, "candidatesForStubs");
            this.readOnlyClass = readOnlyClass;
            this.mutableClass = mutableClass;
            this.candidatesForStubs = candidatesForStubs;
        }

        @Override
        @NotNull
        public IrClassSymbol getReadOnlyClass() {
            return this.readOnlyClass;
        }

        @Override
        @NotNull
        public IrClassSymbol getMutableClass() {
            return this.mutableClass;
        }

        @Override
        @NotNull
        public Collection<IrSimpleFunction> getCandidatesForStubs() {
            return this.candidatesForStubs;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/CollectionStubMethodLowering$NameAndArity;", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "typeParametersCount", "", "valueParametersCount", "<init>", "(Lorg/jetbrains/kotlin/name/Name;II)V", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "getTypeParametersCount", "()I", "getValueParametersCount", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "backend.jvm.lower"})
    private static final class NameAndArity {
        @NotNull
        private final Name name;
        private final int typeParametersCount;
        private final int valueParametersCount;

        public NameAndArity(@NotNull Name name2, int typeParametersCount2, int valueParametersCount) {
            Intrinsics.checkNotNullParameter(name2, "name");
            this.name = name2;
            this.typeParametersCount = typeParametersCount2;
            this.valueParametersCount = valueParametersCount;
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        public final int getTypeParametersCount() {
            return this.typeParametersCount;
        }

        public final int getValueParametersCount() {
            return this.valueParametersCount;
        }

        @NotNull
        public final Name component1() {
            return this.name;
        }

        public final int component2() {
            return this.typeParametersCount;
        }

        public final int component3() {
            return this.valueParametersCount;
        }

        @NotNull
        public final NameAndArity copy(@NotNull Name name2, int typeParametersCount2, int valueParametersCount) {
            Intrinsics.checkNotNullParameter(name2, "name");
            return new NameAndArity(name2, typeParametersCount2, valueParametersCount);
        }

        public static /* synthetic */ NameAndArity copy$default(NameAndArity nameAndArity, Name name2, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                name2 = nameAndArity.name;
            }
            if ((n3 & 2) != 0) {
                n = nameAndArity.typeParametersCount;
            }
            if ((n3 & 4) != 0) {
                n2 = nameAndArity.valueParametersCount;
            }
            return nameAndArity.copy(name2, n, n2);
        }

        @NotNull
        public String toString() {
            return "NameAndArity(name=" + this.name + ", typeParametersCount=" + this.typeParametersCount + ", valueParametersCount=" + this.valueParametersCount + ')';
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.typeParametersCount);
            result2 = result2 * 31 + Integer.hashCode(this.valueParametersCount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof NameAndArity)) {
                return false;
            }
            NameAndArity nameAndArity = (NameAndArity)other;
            if (!Intrinsics.areEqual(this.name, nameAndArity.name)) {
                return false;
            }
            if (this.typeParametersCount != nameAndArity.typeParametersCount) {
                return false;
            }
            return this.valueParametersCount == nameAndArity.valueParametersCount;
        }
    }
}

