# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_oct_global_optspecs
	string join \n output-format= output-version= h/help V/version
end

function __fish_oct_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_oct_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_oct_using_subcommand
	set -l cmd (__fish_oct_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c oct -n "__fish_oct_needs_command" -l output-format -d 'Produce output in the chosen format' -r -f -a "{json\t'',text\t'',yaml\t''}"
complete -c oct -n "__fish_oct_needs_command" -l output-version -d 'Pick output version to use, for non-textual formats' -r
complete -c oct -n "__fish_oct_needs_command" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_needs_command" -s V -l version -d 'Print version'
complete -c oct -n "__fish_oct_needs_command" -f -a "list" -d 'Enumerate available OpenPGP cards'
complete -c oct -n "__fish_oct_needs_command" -f -a "status" -d 'Show information about the data on a card'
complete -c oct -n "__fish_oct_needs_command" -f -a "info" -d 'Show technical details about a card'
complete -c oct -n "__fish_oct_needs_command" -f -a "ssh" -d 'Show a card\'s authentication key as an SSH public key'
complete -c oct -n "__fish_oct_needs_command" -f -a "pubkey" -d 'Export the key data on a card as an OpenPGP public key'
complete -c oct -n "__fish_oct_needs_command" -f -a "admin" -d 'Administer data on a card (including keys and metadata)'
complete -c oct -n "__fish_oct_needs_command" -f -a "pin" -d 'PIN management (change PINs, reset blocked PINs)'
complete -c oct -n "__fish_oct_needs_command" -f -a "decrypt" -d 'Decrypt data using a card'
complete -c oct -n "__fish_oct_needs_command" -f -a "sign" -d 'Sign data using a card'
complete -c oct -n "__fish_oct_needs_command" -f -a "attestation" -d 'Attestation management (Yubico only)'
complete -c oct -n "__fish_oct_needs_command" -f -a "system" -d 'Initialization and similar functionality'
complete -c oct -n "__fish_oct_needs_command" -f -a "output-versions" -d 'Show supported output format versions'
complete -c oct -n "__fish_oct_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_oct_using_subcommand list" -s i -l idents-only -d 'Only show card idents'
complete -c oct -n "__fish_oct_using_subcommand list" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand status" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_oct_using_subcommand status" -s v -l verbose -d 'Use verbose output'
complete -c oct -n "__fish_oct_using_subcommand status" -s K -l public-key-material -d 'Print public key material for each key slot'
complete -c oct -n "__fish_oct_using_subcommand status" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand info" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_oct_using_subcommand info" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand ssh" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_oct_using_subcommand ssh" -l key-only -d 'Only print the ssh public key'
complete -c oct -n "__fish_oct_using_subcommand ssh" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand pubkey" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_oct_using_subcommand pubkey" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand pubkey" -s u -l userid -d 'User ID to add to the exported certificate representation' -r
complete -c oct -n "__fish_oct_using_subcommand pubkey" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_oct_using_subcommand admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -s P -l admin-pin -d 'Optionally, get Admin PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "name" -d 'Set cardholder name'
complete -c oct -n "__fish_oct_using_subcommand admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "url" -d 'Set certificate URL'
complete -c oct -n "__fish_oct_using_subcommand admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "signing-pin-validity" -d 'Configure if user PIN presentation is valid for just one signing operation, or for unlimited signing operations'
complete -c oct -n "__fish_oct_using_subcommand admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "import" -d 'Import a Key onto the card'
complete -c oct -n "__fish_oct_using_subcommand admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "generate" -d 'Generate a Key on the card'
complete -c oct -n "__fish_oct_using_subcommand admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "touch" -d 'Set the card\'s touch policy (if supported)'
complete -c oct -n "__fish_oct_using_subcommand admin; and not __fish_seen_subcommand_from name url signing-pin-validity import generate touch help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from name" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from url" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from signing-pin-validity" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from import" -s s -l sig-fp -d 'Optionally, select the subkey to import in the SIG slot' -r
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from import" -s d -l dec-fp -d 'Optionally, select the subkey to import in the DEC slot' -r
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from import" -s a -l aut-fp -d 'Optionally, select the subkey to import in the AUT slot' -r
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from import" -l key-passphrase -d 'Optionally, provide a passphrase for encrypted secret key material in a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from import" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from generate" -s o -l output -d 'Output file' -r -F
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from generate" -s u -l userid -d 'User ID to add to the exported certificate representation' -r
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from generate" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from generate" -l no-dec -d 'Do not create a key in the DEC slot'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from generate" -l no-aut -d 'Do not create a key in the AUT slot'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from touch" -s k -l key -d 'Key slot to set the touch policy for' -r -f -a "{SIG\t'',DEC\t'',AUT\t'',ATT\t''}"
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from touch" -s p -l policy -d 'Touch policy to set on this key slot' -r -f -a "{Off\t'',On\t'',Fixed\t'',Cached\t'',Cached-Fixed\t''}"
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from touch" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from help" -f -a "name" -d 'Set cardholder name'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from help" -f -a "url" -d 'Set certificate URL'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from help" -f -a "signing-pin-validity" -d 'Configure if user PIN presentation is valid for just one signing operation, or for unlimited signing operations'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from help" -f -a "import" -d 'Import a Key onto the card'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate a Key on the card'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from help" -f -a "touch" -d 'Set the card\'s touch policy (if supported)'
complete -c oct -n "__fish_oct_using_subcommand admin; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_oct_using_subcommand pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_oct_using_subcommand pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "set-user" -d 'Set User PIN'
complete -c oct -n "__fish_oct_using_subcommand pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "set-admin" -d 'Set Admin PIN'
complete -c oct -n "__fish_oct_using_subcommand pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "reset-user" -d 'Reset User PIN with Admin PIN'
complete -c oct -n "__fish_oct_using_subcommand pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "reset-user-rc" -d 'Reset User PIN with Resetting Code'
complete -c oct -n "__fish_oct_using_subcommand pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "set-reset" -d 'Set Resetting Code'
complete -c oct -n "__fish_oct_using_subcommand pin; and not __fish_seen_subcommand_from set-user set-admin reset-user reset-user-rc set-reset help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from set-user" -s p -l user-pin-old -d 'Optionally, get old User PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from set-user" -s q -l user-pin-new -d 'Optionally, get new User PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from set-user" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from set-admin" -s P -l admin-pin-old -d 'Optionally, get old Admin PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from set-admin" -s Q -l admin-pin-new -d 'Optionally, get new Admin PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from set-admin" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from reset-user" -s P -l admin-pin -d 'Optionally, get Admin PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from reset-user" -s p -l user-pin-new -d 'Optionally, get new User PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from reset-user" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from reset-user-rc" -s r -l reset-code -d 'Optionally, get the Resetting Code from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from reset-user-rc" -s p -l user-pin-new -d 'Optionally, get new User PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from reset-user-rc" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from set-reset" -s P -l admin-pin -d 'Optionally, get Admin PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from set-reset" -s r -l reset-code -d 'Optionally, get the Resetting Code from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from set-reset" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from help" -f -a "set-user" -d 'Set User PIN'
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from help" -f -a "set-admin" -d 'Set Admin PIN'
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from help" -f -a "reset-user" -d 'Reset User PIN with Admin PIN'
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from help" -f -a "reset-user-rc" -d 'Reset User PIN with Resetting Code'
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from help" -f -a "set-reset" -d 'Set Resetting Code'
complete -c oct -n "__fish_oct_using_subcommand pin; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_oct_using_subcommand decrypt" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_oct_using_subcommand decrypt" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand decrypt" -s o -l output -d 'Output file (stdout if unset)' -r -F
complete -c oct -n "__fish_oct_using_subcommand decrypt" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand sign; and not __fish_seen_subcommand_from detached cleartext inline help" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_oct_using_subcommand sign; and not __fish_seen_subcommand_from detached cleartext inline help" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand sign; and not __fish_seen_subcommand_from detached cleartext inline help" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand sign; and not __fish_seen_subcommand_from detached cleartext inline help" -f -a "detached" -d 'Create a detached signature'
complete -c oct -n "__fish_oct_using_subcommand sign; and not __fish_seen_subcommand_from detached cleartext inline help" -f -a "cleartext" -d 'Create a cleartext signature'
complete -c oct -n "__fish_oct_using_subcommand sign; and not __fish_seen_subcommand_from detached cleartext inline help" -f -a "inline" -d 'Create an inline signature'
complete -c oct -n "__fish_oct_using_subcommand sign; and not __fish_seen_subcommand_from detached cleartext inline help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_oct_using_subcommand sign; and __fish_seen_subcommand_from detached" -s o -l output -d 'Output file (stdout if unset)' -r -F
complete -c oct -n "__fish_oct_using_subcommand sign; and __fish_seen_subcommand_from detached" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand sign; and __fish_seen_subcommand_from cleartext" -s o -l output -d 'Output file (stdout if unset)' -r -F
complete -c oct -n "__fish_oct_using_subcommand sign; and __fish_seen_subcommand_from cleartext" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand sign; and __fish_seen_subcommand_from inline" -s o -l output -d 'Output file (stdout if unset)' -r -F
complete -c oct -n "__fish_oct_using_subcommand sign; and __fish_seen_subcommand_from inline" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand sign; and __fish_seen_subcommand_from help" -f -a "detached" -d 'Create a detached signature'
complete -c oct -n "__fish_oct_using_subcommand sign; and __fish_seen_subcommand_from help" -f -a "cleartext" -d 'Create a cleartext signature'
complete -c oct -n "__fish_oct_using_subcommand sign; and __fish_seen_subcommand_from help" -f -a "inline" -d 'Create an inline signature'
complete -c oct -n "__fish_oct_using_subcommand sign; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_oct_using_subcommand attestation; and not __fish_seen_subcommand_from cert generate statement help" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand attestation; and not __fish_seen_subcommand_from cert generate statement help" -f -a "cert" -d 'Print the card\'s attestation certificate'
complete -c oct -n "__fish_oct_using_subcommand attestation; and not __fish_seen_subcommand_from cert generate statement help" -f -a "generate" -d 'Generate attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_oct_using_subcommand attestation; and not __fish_seen_subcommand_from cert generate statement help" -f -a "statement" -d 'Print the attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_oct_using_subcommand attestation; and not __fish_seen_subcommand_from cert generate statement help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_oct_using_subcommand attestation; and __fish_seen_subcommand_from cert" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_oct_using_subcommand attestation; and __fish_seen_subcommand_from cert" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand attestation; and __fish_seen_subcommand_from generate" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_oct_using_subcommand attestation; and __fish_seen_subcommand_from generate" -s k -l key -d 'Key slot to use' -r -f -a "{SIG\t'',DEC\t'',AUT\t''}"
complete -c oct -n "__fish_oct_using_subcommand attestation; and __fish_seen_subcommand_from generate" -s p -l user-pin -d 'Optionally, get User PIN from a file' -r -F
complete -c oct -n "__fish_oct_using_subcommand attestation; and __fish_seen_subcommand_from generate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand attestation; and __fish_seen_subcommand_from statement" -s c -l card -d 'Identifier of the card to reset' -r
complete -c oct -n "__fish_oct_using_subcommand attestation; and __fish_seen_subcommand_from statement" -s k -l key -d 'Key slot to use' -r -f -a "{SIG\t'',DEC\t'',AUT\t''}"
complete -c oct -n "__fish_oct_using_subcommand attestation; and __fish_seen_subcommand_from statement" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand attestation; and __fish_seen_subcommand_from help" -f -a "cert" -d 'Print the card\'s attestation certificate'
complete -c oct -n "__fish_oct_using_subcommand attestation; and __fish_seen_subcommand_from help" -f -a "generate" -d 'Generate attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_oct_using_subcommand attestation; and __fish_seen_subcommand_from help" -f -a "statement" -d 'Print the attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_oct_using_subcommand attestation; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_oct_using_subcommand system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "factory-reset" -d 'Completely reset a card (deletes all data including keys!)'
complete -c oct -n "__fish_oct_using_subcommand system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "kdf-setup" -d 'Set up KDF mode'
complete -c oct -n "__fish_oct_using_subcommand system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "set-identity" -d 'Change identity (Nitrokey Start only)'
complete -c oct -n "__fish_oct_using_subcommand system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "activate-file" -d 'Activate File (recover from "card terminated" state)'
complete -c oct -n "__fish_oct_using_subcommand system; and not __fish_seen_subcommand_from factory-reset kdf-setup set-identity activate-file help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_oct_using_subcommand system; and __fish_seen_subcommand_from factory-reset" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_oct_using_subcommand system; and __fish_seen_subcommand_from factory-reset" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand system; and __fish_seen_subcommand_from kdf-setup" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_oct_using_subcommand system; and __fish_seen_subcommand_from kdf-setup" -s h -l help -d 'Print help'
complete -c oct -n "__fish_oct_using_subcommand system; and __fish_seen_subcommand_from set-identity" -s c -l card -d 'Identifier of the card to use' -r
complete -c oct -n "__fish_oct_using_subcommand system; and __fish_seen_subcommand_from set-identity" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand system; and __fish_seen_subcommand_from activate-file" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "factory-reset" -d 'Completely reset a card (deletes all data including keys!)'
complete -c oct -n "__fish_oct_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "kdf-setup" -d 'Set up KDF mode'
complete -c oct -n "__fish_oct_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "set-identity" -d 'Change identity (Nitrokey Start only)'
complete -c oct -n "__fish_oct_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "activate-file" -d 'Activate File (recover from "card terminated" state)'
complete -c oct -n "__fish_oct_using_subcommand system; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_oct_using_subcommand output-versions" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c oct -n "__fish_oct_using_subcommand help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "list" -d 'Enumerate available OpenPGP cards'
complete -c oct -n "__fish_oct_using_subcommand help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "status" -d 'Show information about the data on a card'
complete -c oct -n "__fish_oct_using_subcommand help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "info" -d 'Show technical details about a card'
complete -c oct -n "__fish_oct_using_subcommand help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "ssh" -d 'Show a card\'s authentication key as an SSH public key'
complete -c oct -n "__fish_oct_using_subcommand help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "pubkey" -d 'Export the key data on a card as an OpenPGP public key'
complete -c oct -n "__fish_oct_using_subcommand help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "admin" -d 'Administer data on a card (including keys and metadata)'
complete -c oct -n "__fish_oct_using_subcommand help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "pin" -d 'PIN management (change PINs, reset blocked PINs)'
complete -c oct -n "__fish_oct_using_subcommand help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "decrypt" -d 'Decrypt data using a card'
complete -c oct -n "__fish_oct_using_subcommand help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "sign" -d 'Sign data using a card'
complete -c oct -n "__fish_oct_using_subcommand help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "attestation" -d 'Attestation management (Yubico only)'
complete -c oct -n "__fish_oct_using_subcommand help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "system" -d 'Initialization and similar functionality'
complete -c oct -n "__fish_oct_using_subcommand help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "output-versions" -d 'Show supported output format versions'
complete -c oct -n "__fish_oct_using_subcommand help; and not __fish_seen_subcommand_from list status info ssh pubkey admin pin decrypt sign attestation system output-versions help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from admin" -f -a "name" -d 'Set cardholder name'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from admin" -f -a "url" -d 'Set certificate URL'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from admin" -f -a "signing-pin-validity" -d 'Configure if user PIN presentation is valid for just one signing operation, or for unlimited signing operations'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from admin" -f -a "import" -d 'Import a Key onto the card'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from admin" -f -a "generate" -d 'Generate a Key on the card'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from admin" -f -a "touch" -d 'Set the card\'s touch policy (if supported)'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from pin" -f -a "set-user" -d 'Set User PIN'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from pin" -f -a "set-admin" -d 'Set Admin PIN'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from pin" -f -a "reset-user" -d 'Reset User PIN with Admin PIN'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from pin" -f -a "reset-user-rc" -d 'Reset User PIN with Resetting Code'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from pin" -f -a "set-reset" -d 'Set Resetting Code'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from sign" -f -a "detached" -d 'Create a detached signature'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from sign" -f -a "cleartext" -d 'Create a cleartext signature'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from sign" -f -a "inline" -d 'Create an inline signature'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from attestation" -f -a "cert" -d 'Print the card\'s attestation certificate'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from attestation" -f -a "generate" -d 'Generate attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from attestation" -f -a "statement" -d 'Print the attestation statement for one of the key slots on the card'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "factory-reset" -d 'Completely reset a card (deletes all data including keys!)'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "kdf-setup" -d 'Set up KDF mode'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "set-identity" -d 'Change identity (Nitrokey Start only)'
complete -c oct -n "__fish_oct_using_subcommand help; and __fish_seen_subcommand_from system" -f -a "activate-file" -d 'Activate File (recover from "card terminated" state)'
