/*
 * Copyright (C) 2014 Google, Inc.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _PANEL_JDI_LPM102A188A_H_
#define _PANEL_JDI_LPM102A188A_H_

#define MIPI_DCS_RSP_WRITE_DISPLAY_BRIGHTNESS		0x51
#define RSP_WRITE_DISPLAY_BRIGHTNESS(x)			((x) & 0xFF)

#define MIPI_DCS_RSP_WRITE_CONTROL_DISPLAY		0x53
#define RSP_WRITE_CONTROL_DISPLAY_BL_ON			(1 << 2)
#define RSP_WRITE_CONTROL_DISPLAY_DD_ON			(1 << 3)
#define RSP_WRITE_CONTROL_DISPLAY_BCTRL_LEDPWM		(1 << 5)

#define MIPI_DCS_RSP_WRITE_ADAPTIVE_BRIGHTNESS_CONTROL	0x55
#define RSP_WRITE_ADAPTIVE_BRIGHTNESS_CONTROL_C_OFF	(0 << 0)
#define RSP_WRITE_ADAPTIVE_BRIGHTNESS_CONTROL_C_UI	(1 << 0)
#define RSP_WRITE_ADAPTIVE_BRIGHTNESS_CONTROL_C_STILL	(2 << 0)
#define RSP_WRITE_ADAPTIVE_BRIGHTNESS_CONTROL_C_VIDEO	(3 << 0)
#define RSP_WRITE_ADAPTIVE_BRIGHTNESS_CONTROL_SRE_USER	(0 << 4)
#define RSP_WRITE_ADAPTIVE_BRIGHTNESS_CONTROL_SRE_WEAK	(1 << 4)
#define RSP_WRITE_ADAPTIVE_BRIGHTNESS_CONTROL_SRE_MID	(2 << 4)
#define RSP_WRITE_ADAPTIVE_BRIGHTNESS_CONTROL_SRE_HIGH	(3 << 4)
#define RSP_WRITE_ADAPTIVE_BRIGHTNESS_CONTROL_SRE_ON	(1 << 6)

#define MIPI_DCS_RSP_MFG_COMMAND_ACCESS_PROTECT		0xB0
#define RSP_MFG_COMMAND_ACCESS_PROTECT_OFF		(0 << 0)

#define MIPI_DSI_RSP_MFG_POWER_CONTROL_FUNCTION		0xD0
#define RSP_MFG_POWER_CONTROL_PARAM1_DEFAULT		(2 << 0)
#define RSP_MFG_POWER_CONTROL_PARAM1_VGH_210_DIV	(1 << 4)
#define RSP_MFG_POWER_CONTROL_PARAM1_VGH_240_DIV	(2 << 4)
#define RSP_MFG_POWER_CONTROL_PARAM1_VGH_280_DIV	(3 << 4)
#define RSP_MFG_POWER_CONTROL_PARAM1_VGH_330_DIV	(4 << 4)
#define RSP_MFG_POWER_CONTROL_PARAM1_VGH_410_DIV	(5 << 4)
#define RSP_MFG_POWER_CONTROL_PARAM2_VGL_210_DIV	(1 << 0)
#define RSP_MFG_POWER_CONTROL_PARAM2_VGL_240_DIV	(2 << 0)
#define RSP_MFG_POWER_CONTROL_PARAM2_VGL_280_DIV	(3 << 0)
#define RSP_MFG_POWER_CONTROL_PARAM2_VGL_330_DIV	(4 << 0)
#define RSP_MFG_POWER_CONTROL_PARAM2_VGL_410_DIV	(5 << 0)
#define RSP_MFG_POWER_CONTROL_PARAM2_DEFAULT		(9 << 4)

#define I2C_LP8557_COMMAND				0x00
#define I2C_LP8557_BRIGHTNESS_CTRL			0x04
#define I2C_LP8557_CONFIG				0x10
#define LP8557_CONFIG_BRTMODE_PWM			(0x00 << 0)
#define LP8557_CONFIG_AUTO_LEDEN			(0x00 << 2)
#define I2C_LP8557_CURRENT				0x11
#define LP8557_CURRENT_MAXCUR_18MA			(0x04 << 0)
#define I2C_LP8557_PGEN					0x12
#define LP8557_PGEN_PFREQ_9_8KHZ			(0x01 << 0)
#define LP8557_PGEN_THRESHOLD_FULL			(0x07 << 3)
#define I2C_LP8557_BOOST				0x13
#define LP8557_BOOST_FREQ_1MHZ				(0x01 << 0)
#define LP8557_BOOST_BCOMP_OPTION_1			(0x01 << 1)
#define I2C_LP8557_LEDEN				0x14
#define LP8557_LEDEN_6_CURRENT_SINKS			(0x3F << 0)
#define LP8557_LEDEN_4V_0V				(0x02 << 6)
#define I2C_LP8557_SMOOTHING_STEP			0x15
#define LP8557_SMOOTHING_HEAVY				(0x03 << 6)
#define LP8557_SMOOTHING_STEP_200MS			(0x03 << 0)
#endif
