
use builtin;
use str;

set edit:completion:arg-completer[zellij] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'zellij'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'zellij'= {
            cand --max-panes 'Maximum panes on screen, caution: opening more panes will close old ones'
            cand --data-dir 'Change where zellij looks for plugins'
            cand --server 'Run server listening at the specified socket path'
            cand -s 'Specify name of a new session'
            cand --session 'Specify name of a new session'
            cand -l 'Name of a predefined layout inside the layout directory or the path to a layout file if inside a session (or using the --session flag) will be added to the session as a new tab or tabs, otherwise will start a new session'
            cand --layout 'Name of a predefined layout inside the layout directory or the path to a layout file if inside a session (or using the --session flag) will be added to the session as a new tab or tabs, otherwise will start a new session'
            cand -n 'Name of a predefined layout inside the layout directory or the path to a layout file Will always start a new session, even if inside an existing session'
            cand --new-session-with-layout 'Name of a predefined layout inside the layout directory or the path to a layout file Will always start a new session, even if inside an existing session'
            cand -c 'Change where zellij looks for the configuration file'
            cand --config 'Change where zellij looks for the configuration file'
            cand --config-dir 'Change where zellij looks for the configuration directory'
            cand -h 'Print help information'
            cand --help 'Print help information'
            cand -V 'Print version information'
            cand --version 'Print version information'
            cand -d 'Specify emitting additional debug information'
            cand --debug 'Specify emitting additional debug information'
            cand options 'Change the behaviour of zellij'
            cand setup 'Setup zellij and check its configuration'
            cand list-sessions 'List active sessions'
            cand list-aliases 'List existing plugin aliases'
            cand attach 'Attach to a session'
            cand kill-session 'Kill a specific session'
            cand delete-session 'Delete a specific session'
            cand kill-all-sessions 'Kill all sessions'
            cand delete-all-sessions 'Delete all sessions'
            cand action 'Send actions to a specific session'
            cand run 'Run a command in a new pane'
            cand plugin 'Load a plugin'
            cand edit 'Edit file with default $EDITOR / $VISUAL'
            cand convert-config 'convert-config'
            cand convert-layout 'convert-layout'
            cand convert-theme 'convert-theme'
            cand pipe 'Send data to one or more plugins, launch them if they are not running'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'zellij;options'= {
            cand --simplified-ui 'Allow plugins to use a more simplified layout that is compatible with more fonts (true or false)'
            cand --theme 'Set the default theme'
            cand --default-mode 'Set the default mode'
            cand --default-shell 'Set the default shell'
            cand --default-cwd 'Set the default cwd'
            cand --default-layout 'Set the default layout'
            cand --layout-dir 'Set the layout_dir, defaults to subdirectory of config dir'
            cand --theme-dir 'Set the theme_dir, defaults to subdirectory of config dir'
            cand --mouse-mode 'Set the handling of mouse events (true or false) Can be temporarily bypassed by the [SHIFT] key'
            cand --pane-frames 'Set display of the pane frames (true or false)'
            cand --mirror-session 'Mirror session when multiple users are connected (true or false)'
            cand --on-force-close 'Set behaviour on force close (quit or detach)'
            cand --scroll-buffer-size 'scroll-buffer-size'
            cand --copy-command 'Switch to using a user supplied command for clipboard instead of OSC52'
            cand --copy-clipboard 'OSC52 destination clipboard'
            cand --copy-on-select 'Automatically copy when selecting text (true or false)'
            cand --scrollback-editor 'Explicit full path to open the scrollback editor (default is $EDITOR or $VISUAL)'
            cand --session-name 'The name of the session to create when starting Zellij'
            cand --attach-to-session 'Whether to attach to a session specified in "session-name" if it exists'
            cand --auto-layout 'Whether to lay out panes in a predefined set of layouts whenever possible'
            cand --session-serialization 'Whether sessions should be serialized to the HD so that they can be later resurrected, default is true'
            cand --serialize-pane-viewport 'Whether pane viewports are serialized along with the session, default is false'
            cand --scrollback-lines-to-serialize 'Scrollback lines to serialize along with the pane viewport when serializing sessions, 0 defaults to the scrollback size. If this number is higher than the scrollback size, it will also default to the scrollback size'
            cand --styled-underlines 'Whether to use ANSI styled underlines'
            cand --serialization-interval 'The interval at which to serialize sessions for resurrection (in seconds)'
            cand --disable-session-metadata 'If true, will disable writing session metadata to disk'
            cand --support-kitty-keyboard-protocol 'Whether to enable support for the Kitty keyboard protocol (must also be supported by the host terminal), defaults to true if the terminal supports it'
            cand --disable-mouse-mode 'Disable handling of mouse events'
            cand --no-pane-frames 'Disable display of pane frames'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;setup'= {
            cand --dump-layout 'Dump specified layout to stdout'
            cand --dump-swap-layout 'Dump the specified swap layout file to stdout'
            cand --dump-plugins 'Dump the builtin plugins to DIR or "DATA DIR" if unspecified'
            cand --generate-completion 'Generates completion for the specified shell'
            cand --generate-auto-start 'Generates auto-start script for the specified shell'
            cand --dump-config 'Dump the default configuration file to stdout'
            cand --clean 'Disables loading of configuration file at default location, loads the defaults that zellij ships with'
            cand --check 'Checks the configuration of zellij and displays currently used directories'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;list-sessions'= {
            cand -n 'Do not add colors and formatting to the list (useful for parsing)'
            cand --no-formatting 'Do not add colors and formatting to the list (useful for parsing)'
            cand -s 'Print just the session name'
            cand --short 'Print just the session name'
            cand -r 'List the sessions in reverse order (default is ascending order)'
            cand --reverse 'List the sessions in reverse order (default is ascending order)'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;list-aliases'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;attach'= {
            cand --index 'Number of the session index in the active sessions ordered creation date'
            cand -c 'Create a session if one does not exist'
            cand --create 'Create a session if one does not exist'
            cand -b 'Create a detached session in the background if one does not exist'
            cand --create-background 'Create a detached session in the background if one does not exist'
            cand -f 'If resurrecting a dead session, immediately run all its commands on startup'
            cand --force-run-commands 'If resurrecting a dead session, immediately run all its commands on startup'
            cand -h 'Print help information'
            cand --help 'Print help information'
            cand options 'Change the behaviour of zellij'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'zellij;attach;options'= {
            cand --simplified-ui 'Allow plugins to use a more simplified layout that is compatible with more fonts (true or false)'
            cand --theme 'Set the default theme'
            cand --default-mode 'Set the default mode'
            cand --default-shell 'Set the default shell'
            cand --default-cwd 'Set the default cwd'
            cand --default-layout 'Set the default layout'
            cand --layout-dir 'Set the layout_dir, defaults to subdirectory of config dir'
            cand --theme-dir 'Set the theme_dir, defaults to subdirectory of config dir'
            cand --mouse-mode 'Set the handling of mouse events (true or false) Can be temporarily bypassed by the [SHIFT] key'
            cand --pane-frames 'Set display of the pane frames (true or false)'
            cand --mirror-session 'Mirror session when multiple users are connected (true or false)'
            cand --on-force-close 'Set behaviour on force close (quit or detach)'
            cand --scroll-buffer-size 'scroll-buffer-size'
            cand --copy-command 'Switch to using a user supplied command for clipboard instead of OSC52'
            cand --copy-clipboard 'OSC52 destination clipboard'
            cand --copy-on-select 'Automatically copy when selecting text (true or false)'
            cand --scrollback-editor 'Explicit full path to open the scrollback editor (default is $EDITOR or $VISUAL)'
            cand --session-name 'The name of the session to create when starting Zellij'
            cand --attach-to-session 'Whether to attach to a session specified in "session-name" if it exists'
            cand --auto-layout 'Whether to lay out panes in a predefined set of layouts whenever possible'
            cand --session-serialization 'Whether sessions should be serialized to the HD so that they can be later resurrected, default is true'
            cand --serialize-pane-viewport 'Whether pane viewports are serialized along with the session, default is false'
            cand --scrollback-lines-to-serialize 'Scrollback lines to serialize along with the pane viewport when serializing sessions, 0 defaults to the scrollback size. If this number is higher than the scrollback size, it will also default to the scrollback size'
            cand --styled-underlines 'Whether to use ANSI styled underlines'
            cand --serialization-interval 'The interval at which to serialize sessions for resurrection (in seconds)'
            cand --disable-session-metadata 'If true, will disable writing session metadata to disk'
            cand --support-kitty-keyboard-protocol 'Whether to enable support for the Kitty keyboard protocol (must also be supported by the host terminal), defaults to true if the terminal supports it'
            cand --disable-mouse-mode 'Disable handling of mouse events'
            cand --no-pane-frames 'Disable display of pane frames'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;attach;help'= {
        }
        &'zellij;kill-session'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;delete-session'= {
            cand -f 'Kill the session if it''s running before deleting it'
            cand --force 'Kill the session if it''s running before deleting it'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;kill-all-sessions'= {
            cand -y 'Automatic yes to prompts'
            cand --yes 'Automatic yes to prompts'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;delete-all-sessions'= {
            cand -y 'Automatic yes to prompts'
            cand --yes 'Automatic yes to prompts'
            cand -f 'Kill the sessions if they''re running before deleting them'
            cand --force 'Kill the sessions if they''re running before deleting them'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
            cand write 'Write bytes to the terminal'
            cand write-chars 'Write characters to the terminal'
            cand resize '[increase|decrease] the focused panes area at the [left|down|up|right] border'
            cand focus-next-pane 'Change focus to the next pane'
            cand focus-previous-pane 'Change focus to the previous pane'
            cand move-focus 'Move the focused pane in the specified direction. [right|left|up|down]'
            cand move-focus-or-tab 'Move focus to the pane or tab (if on screen edge) in the specified direction [right|left|up|down]'
            cand move-pane 'Change the location of the focused pane in the specified direction or rotate forwrads [right|left|up|down]'
            cand move-pane-backwards 'Rotate the location of the previous pane backwards'
            cand clear 'Clear all buffers for a focused pane'
            cand dump-screen 'Dump the focused pane to a file'
            cand dump-layout 'Dump current layout to stdout'
            cand edit-scrollback 'Open the pane scrollback in your default editor'
            cand scroll-up 'Scroll up in the focused pane'
            cand scroll-down 'Scroll down in focus pane'
            cand scroll-to-bottom 'Scroll down to bottom in focus pane'
            cand scroll-to-top 'Scroll up to top in focus pane'
            cand page-scroll-up 'Scroll up one page in focus pane'
            cand page-scroll-down 'Scroll down one page in focus pane'
            cand half-page-scroll-up 'Scroll up half page in focus pane'
            cand half-page-scroll-down 'Scroll down half page in focus pane'
            cand toggle-fullscreen 'Toggle between fullscreen focus pane and normal layout'
            cand toggle-pane-frames 'Toggle frames around panes in the UI'
            cand toggle-active-sync-tab 'Toggle between sending text commands to all panes on the current tab and normal mode'
            cand new-pane 'Open a new pane in the specified direction [right|down] If no direction is specified, will try to use the biggest available space'
            cand edit 'Open the specified file in a new zellij pane with your default EDITOR'
            cand switch-mode 'Switch input mode of all connected clients [locked|pane|tab|resize|move|search|session]'
            cand toggle-pane-embed-or-floating 'Embed focused pane if floating or float focused pane if embedded'
            cand toggle-floating-panes 'Toggle the visibility of all floating panes in the current Tab, open one if none exist'
            cand close-pane 'Close the focused pane'
            cand rename-pane 'Renames the focused pane'
            cand undo-rename-pane 'Remove a previously set pane name'
            cand go-to-next-tab 'Go to the next tab'
            cand go-to-previous-tab 'Go to the previous tab'
            cand close-tab 'Close the current tab'
            cand go-to-tab 'Go to tab with index [index]'
            cand go-to-tab-name 'Go to tab with name [name]'
            cand rename-tab 'Renames the focused pane'
            cand undo-rename-tab 'Remove a previously set tab name'
            cand new-tab 'Create a new tab, optionally with a specified tab layout and name'
            cand move-tab 'Move the focused tab in the specified direction. [right|left]'
            cand previous-swap-layout 'previous-swap-layout'
            cand next-swap-layout 'next-swap-layout'
            cand query-tab-names 'Query all tab names'
            cand start-or-reload-plugin 'start-or-reload-plugin'
            cand launch-or-focus-plugin 'launch-or-focus-plugin'
            cand launch-plugin 'launch-plugin'
            cand rename-session 'rename-session'
            cand pipe 'Send data to one or more plugins, launch them if they are not running'
            cand list-clients 'list-clients'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'zellij;action;write'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;write-chars'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;resize'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;focus-next-pane'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;focus-previous-pane'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;move-focus'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;move-focus-or-tab'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;move-pane'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;move-pane-backwards'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;clear'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;dump-screen'= {
            cand -f 'Dump the pane with full scrollback'
            cand --full 'Dump the pane with full scrollback'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;dump-layout'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;edit-scrollback'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;scroll-up'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;scroll-down'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;scroll-to-bottom'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;scroll-to-top'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;page-scroll-up'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;page-scroll-down'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;half-page-scroll-up'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;half-page-scroll-down'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;toggle-fullscreen'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;toggle-pane-frames'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;toggle-active-sync-tab'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;new-pane'= {
            cand -d 'Direction to open the new pane in'
            cand --direction 'Direction to open the new pane in'
            cand -p 'p'
            cand --plugin 'plugin'
            cand --cwd 'Change the working directory of the new pane'
            cand -n 'Name of the new pane'
            cand --name 'Name of the new pane'
            cand --configuration 'configuration'
            cand -x 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --x 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand -y 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --y 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --width 'The width if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --height 'The height if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand -f 'Open the new pane in floating mode'
            cand --floating 'Open the new pane in floating mode'
            cand -i 'Open the new pane in place of the current pane, temporarily suspending it'
            cand --in-place 'Open the new pane in place of the current pane, temporarily suspending it'
            cand -c 'Close the pane immediately when its command exits'
            cand --close-on-exit 'Close the pane immediately when its command exits'
            cand -s 'Start the command suspended, only running it after the you first press ENTER'
            cand --start-suspended 'Start the command suspended, only running it after the you first press ENTER'
            cand --skip-plugin-cache 'skip-plugin-cache'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;edit'= {
            cand -d 'Direction to open the new pane in'
            cand --direction 'Direction to open the new pane in'
            cand -l 'Open the file in the specified line number'
            cand --line-number 'Open the file in the specified line number'
            cand --cwd 'Change the working directory of the editor'
            cand -x 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --x 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand -y 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --y 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --width 'The width if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --height 'The height if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand -f 'Open the new pane in floating mode'
            cand --floating 'Open the new pane in floating mode'
            cand -i 'Open the new pane in place of the current pane, temporarily suspending it'
            cand --in-place 'Open the new pane in place of the current pane, temporarily suspending it'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;switch-mode'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;toggle-pane-embed-or-floating'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;toggle-floating-panes'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;close-pane'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;rename-pane'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;undo-rename-pane'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;go-to-next-tab'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;go-to-previous-tab'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;close-tab'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;go-to-tab'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;go-to-tab-name'= {
            cand -c 'Create a tab if one does not exist'
            cand --create 'Create a tab if one does not exist'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;rename-tab'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;undo-rename-tab'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;new-tab'= {
            cand -l 'Layout to use for the new tab'
            cand --layout 'Layout to use for the new tab'
            cand --layout-dir 'Default folder to look for layouts'
            cand -n 'Name of the new tab'
            cand --name 'Name of the new tab'
            cand -c 'Change the working directory of the new tab'
            cand --cwd 'Change the working directory of the new tab'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;move-tab'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;previous-swap-layout'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;next-swap-layout'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;query-tab-names'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;start-or-reload-plugin'= {
            cand -c 'c'
            cand --configuration 'configuration'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;launch-or-focus-plugin'= {
            cand -c 'c'
            cand --configuration 'configuration'
            cand -f 'f'
            cand --floating 'floating'
            cand -i 'i'
            cand --in-place 'in-place'
            cand -m 'm'
            cand --move-to-focused-tab 'move-to-focused-tab'
            cand -s 's'
            cand --skip-plugin-cache 'skip-plugin-cache'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;launch-plugin'= {
            cand -c 'c'
            cand --configuration 'configuration'
            cand -f 'f'
            cand --floating 'floating'
            cand -i 'i'
            cand --in-place 'in-place'
            cand -s 's'
            cand --skip-plugin-cache 'skip-plugin-cache'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;rename-session'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;pipe'= {
            cand -n 'The name of the pipe'
            cand --name 'The name of the pipe'
            cand -a 'The args of the pipe'
            cand --args 'The args of the pipe'
            cand -p 'The plugin url (eg. file:/tmp/my-plugin.wasm) to direct this pipe to, if not specified, will be sent to all plugins, if specified and is not running, the plugin will be launched'
            cand --plugin 'The plugin url (eg. file:/tmp/my-plugin.wasm) to direct this pipe to, if not specified, will be sent to all plugins, if specified and is not running, the plugin will be launched'
            cand -c 'The plugin configuration (note: the same plugin with different configuration is considered a different plugin for the purposes of determining the pipe destination)'
            cand --plugin-configuration 'The plugin configuration (note: the same plugin with different configuration is considered a different plugin for the purposes of determining the pipe destination)'
            cand -f 'If launching a plugin, should it be floating or not, defaults to floating'
            cand --floating-plugin 'If launching a plugin, should it be floating or not, defaults to floating'
            cand -i 'If launching a plugin, launch it in-place (on top of the current pane)'
            cand --in-place-plugin 'If launching a plugin, launch it in-place (on top of the current pane)'
            cand -w 'If launching a plugin, specify its working directory'
            cand --plugin-cwd 'If launching a plugin, specify its working directory'
            cand -t 'If launching a plugin, specify its pane title'
            cand --plugin-title 'If launching a plugin, specify its pane title'
            cand -l 'Launch a new plugin even if one is already running'
            cand --force-launch-plugin 'Launch a new plugin even if one is already running'
            cand -s 'If launching a new plugin, skip cache and force-compile the plugin'
            cand --skip-plugin-cache 'If launching a new plugin, skip cache and force-compile the plugin'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;list-clients'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;action;help'= {
        }
        &'zellij;run'= {
            cand -d 'Direction to open the new pane in'
            cand --direction 'Direction to open the new pane in'
            cand --cwd 'Change the working directory of the new pane'
            cand -n 'Name of the new pane'
            cand --name 'Name of the new pane'
            cand -x 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --x 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand -y 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --y 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --width 'The width if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --height 'The height if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand -f 'Open the new pane in floating mode'
            cand --floating 'Open the new pane in floating mode'
            cand -i 'Open the new pane in place of the current pane, temporarily suspending it'
            cand --in-place 'Open the new pane in place of the current pane, temporarily suspending it'
            cand -c 'Close the pane immediately when its command exits'
            cand --close-on-exit 'Close the pane immediately when its command exits'
            cand -s 'Start the command suspended, only running after you first presses ENTER'
            cand --start-suspended 'Start the command suspended, only running after you first presses ENTER'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;plugin'= {
            cand -c 'Plugin configuration'
            cand --configuration 'Plugin configuration'
            cand -x 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --x 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand -y 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --y 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --width 'The width if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --height 'The height if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand -f 'Open the new pane in floating mode'
            cand --floating 'Open the new pane in floating mode'
            cand -i 'Open the new pane in place of the current pane, temporarily suspending it'
            cand --in-place 'Open the new pane in place of the current pane, temporarily suspending it'
            cand -s 'Skip the memory and HD cache and force recompile of the plugin (good for development)'
            cand --skip-plugin-cache 'Skip the memory and HD cache and force recompile of the plugin (good for development)'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;edit'= {
            cand -l 'Open the file in the specified line number'
            cand --line-number 'Open the file in the specified line number'
            cand -d 'Direction to open the new pane in'
            cand --direction 'Direction to open the new pane in'
            cand --cwd 'Change the working directory of the editor'
            cand -x 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --x 'The x coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand -y 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --y 'The y coordinates if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --width 'The width if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand --height 'The height if the pane is floating as a bare integer (eg. 1) or percent (eg. 10%)'
            cand -i 'Open the new pane in place of the current pane, temporarily suspending it'
            cand --in-place 'Open the new pane in place of the current pane, temporarily suspending it'
            cand -f 'Open the new pane in floating mode'
            cand --floating 'Open the new pane in floating mode'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;convert-config'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;convert-layout'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;convert-theme'= {
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;pipe'= {
            cand -n 'The name of the pipe'
            cand --name 'The name of the pipe'
            cand -a 'The args of the pipe'
            cand --args 'The args of the pipe'
            cand -p 'The plugin url (eg. file:/tmp/my-plugin.wasm) to direct this pipe to, if not specified, will be sent to all plugins, if specified and is not running, the plugin will be launched'
            cand --plugin 'The plugin url (eg. file:/tmp/my-plugin.wasm) to direct this pipe to, if not specified, will be sent to all plugins, if specified and is not running, the plugin will be launched'
            cand -c 'The plugin configuration (note: the same plugin with different configuration is considered a different plugin for the purposes of determining the pipe destination)'
            cand --plugin-configuration 'The plugin configuration (note: the same plugin with different configuration is considered a different plugin for the purposes of determining the pipe destination)'
            cand -h 'Print help information'
            cand --help 'Print help information'
        }
        &'zellij;help'= {
        }
    ]
    $completions[$command]
}
