/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.archunit;

import com.tngtech.archunit.core.domain.Dependency;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.domain.Source;
import com.tngtech.archunit.core.importer.ClassFileImporter;
import com.tngtech.archunit.core.importer.Location;
import com.tngtech.archunit.freeplane.extension.ArchitectureViolations;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.freeplane.core.util.LogUtils;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyVerdict;
import org.freeplane.plugin.codeexplorer.map.CodeNode;
import org.freeplane.plugin.codeexplorer.task.AnnotationMatcher;
import org.freeplane.plugin.codeexplorer.task.CodeExplorerConfiguration;
import org.freeplane.plugin.codeexplorer.task.DependencyJudge;
import org.freeplane.plugin.codeexplorer.task.GroupIdentifier;
import org.freeplane.plugin.codeexplorer.task.GroupMatcher;

public class ArchitectureViolationsConfiguration
implements CodeExplorerConfiguration {
    private final ArchitectureViolations architectureViolations;
    private final Set<String> violationDependencyDescriptions;
    private final Set<String> cyclicDependencyDescriptions;
    private JavaClasses importedClasses;
    private Map<String, Dependency> violations;

    public ArchitectureViolationsConfiguration(ArchitectureViolations architectureViolations) {
        this.architectureViolations = architectureViolations;
        List violationDescriptions = architectureViolations.getViolationDescriptions();
        this.violationDependencyDescriptions = violationDescriptions.stream().flatMap(x -> x.getViolationDependencyDescriptions().stream()).collect(Collectors.toSet());
        this.cyclicDependencyDescriptions = violationDescriptions.stream().flatMap(x -> x.getCyclicDependencyDescriptions().stream()).collect(Collectors.toSet());
    }

    @Override
    public int countLocations() {
        return this.architectureViolations.getViolatingClassLocations().size();
    }

    @Override
    public JavaClasses importClasses() {
        if (this.importedClasses == null) {
            List classLocations = this.architectureViolations.getViolatingClassLocations().values().stream().flatMap(Collection::stream).map(x -> {
                try {
                    return new URI((String)x);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }).map(Location::of).collect(Collectors.toList());
            LogUtils.info((String)("Starting import of " + this.countLocations() + " classes"));
            this.importedClasses = new ClassFileImporter().importLocations(classLocations);
            LogUtils.info((String)"Import done");
        }
        return this.importedClasses;
    }

    public Map<String, Dependency> violationsByDescription() {
        if (this.violations == null) {
            this.importClasses();
            this.violations = ((Stream)this.importedClasses.stream().flatMap(javaClass -> Stream.concat(javaClass.getDirectDependenciesFromSelf().stream(), javaClass.getDirectDependenciesToSelf().stream())).parallel()).filter(dependency -> this.violationDependencyDescriptions.contains(dependency.getDescription()) || this.cyclicDependencyDescriptions.contains(dependency.getDescription())).collect(Collectors.toMap(Dependency::getDescription, x -> x, this::throwExceptionOnDifferentValues, HashMap::new));
        }
        return this.violations;
    }

    public Dependency throwExceptionOnDifferentValues(Dependency x, Dependency y) {
        if (x.equals((Object)y)) {
            return x;
        }
        throw new IllegalArgumentException("Different dependencies with the same description " + x + " and " + y);
    }

    @Override
    public String getProjectName() {
        return this.architectureViolations.getViolatedRuleDescription();
    }

    @Override
    public GroupMatcher createGroupMatcher() {
        return this::location;
    }

    private Optional<GroupIdentifier> location(JavaClass javaClass) {
        return javaClass.getSource().map(Source::getUri).map(URI::toString).flatMap(uri -> this.architectureViolations.getViolatingClassLocations().entrySet().stream().filter(e -> ((Set)e.getValue()).contains(uri)).findAny()).map(Map.Entry::getKey).flatMap(s -> s.isEmpty() ? CodeNode.classSourceLocationOf(javaClass) : Optional.of(s)).map(name -> new GroupIdentifier((String)name, (String)name));
    }

    @Override
    public DependencyJudge getDependencyJudge() {
        return (dependency, goesUp) -> this.violationDependencyDescriptions.contains(dependency.getDescription()) ? DependencyVerdict.FORBIDDEN : (this.cyclicDependencyDescriptions.contains(dependency.getDescription()) ? (goesUp ? DependencyVerdict.FORBIDDEN : DependencyVerdict.ALLOWED) : DependencyVerdict.IGNORED);
    }

    @Override
    public AnnotationMatcher getAnnotationMatcher() {
        return AnnotationMatcher.IGNORING_ALL;
    }

    @Override
    public boolean canBeSaved() {
        return false;
    }
}

