/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.View;

class FocusManager {
    private static final FocusManager INSTANCE = new FocusManager();
    private int ignoreFocusChanges;
    private Timer focusTimer = new Timer(20, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FocusManager.this.updateFocus();
            FocusManager.this.focusUpdateTriggered = false;
        }
    });
    private boolean focusUpdateTriggered;
    private ArrayList lastFocusedWindows = new ArrayList();
    private Component focusedComponent;
    private PropertyChangeListener focusListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (FocusManager.this.ignoreFocusChanges > 0) {
                return;
            }
            FocusManager focusManager = FocusManager.this;
            focusManager.ignoreFocusChanges = focusManager.ignoreFocusChanges + 1;
            try {
                this.triggerFocusUpdate();
            }
            finally {
                FocusManager focusManager2 = FocusManager.this;
                focusManager2.ignoreFocusChanges = focusManager2.ignoreFocusChanges - 1;
            }
        }

        private void triggerFocusUpdate() {
            if (FocusManager.this.focusUpdateTriggered) {
                return;
            }
            FocusManager.this.focusUpdateTriggered = true;
            FocusManager.this.focusTimer.setRepeats(false);
            FocusManager.this.focusTimer.start();
        }
    };

    private FocusManager() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("focusOwner", this.focusListener);
        this.updateFocus();
    }

    static FocusManager getInstance() {
        return INSTANCE;
    }

    private void updateFocus() {
        this.focusedComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        ArrayList oldFocusedWindows = this.lastFocusedWindows;
        this.lastFocusedWindows = new ArrayList();
        this.updateWindows(this.focusedComponent, this.focusedComponent, oldFocusedWindows);
        int i = 0;
        while (i < oldFocusedWindows.size()) {
            RootWindow w = (RootWindow)((Reference)oldFocusedWindows.get(i)).get();
            if (w != null) {
                w.setFocusedView(null);
            }
            ++i;
        }
    }

    void pinFocus(Runnable runnable) {
        ++this.ignoreFocusChanges;
        Component c = this.focusedComponent;
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            if (--this.ignoreFocusChanges == 0 && c != null) {
                c.requestFocusInWindow();
                SwingUtilities.invokeLater(new Runnable(c){
                    private final /* synthetic */ Component val$c;
                    {
                        this.val$c = component;
                    }

                    @Override
                    public void run() {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                val$c.requestFocusInWindow();
                            }
                        });
                    }
                });
            }
            throw throwable;
        }
        if (--this.ignoreFocusChanges == 0 && c != null) {
            c.requestFocusInWindow();
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }
    }

    void startIgnoreFocusChanges() {
        ++this.ignoreFocusChanges;
    }

    void stopIgnoreFocusChanges() {
        if (--this.ignoreFocusChanges == 0) {
            this.updateFocus();
        }
    }

    static void focusWindow(final DockingWindow window) {
        if (window == null) {
            return;
        }
        window.restoreFocus();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        window.restoreFocus();
                    }
                });
            }
        });
    }

    private static View getViewContaining(Component component) {
        return component == null ? null : (component instanceof View ? (View)component : FocusManager.getViewContaining(component.getParent()));
    }

    private void updateWindows(Component focusedComponent, Component component, ArrayList oldFocusedWindows) {
        View view;
        while ((view = FocusManager.getViewContaining(component)) != null) {
            view.setLastFocusedComponent(focusedComponent);
            RootWindow rw = view.getRootWindow();
            if (rw == null) break;
            rw.setFocusedView(view);
            this.lastFocusedWindows.add(new WeakReference<RootWindow>(rw));
            component = rw;
            int i = 0;
            while (i < oldFocusedWindows.size()) {
                if (((Reference)oldFocusedWindows.get(i)).get() == component) {
                    oldFocusedWindows.remove(i);
                }
                ++i;
            }
        }
    }
}

