/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.util.Collection;
import java.util.HashSet;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleRevisionImpl;
import org.knopflerfish.framework.FrameworkContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;

public class FrameworkWiringImpl
implements FrameworkWiring {
    private final FrameworkContext fwCtx;
    static final String SPEC_VERSION = "1.0";

    FrameworkWiringImpl(FrameworkContext fwCtx) {
        this.fwCtx = fwCtx;
    }

    @Override
    public Bundle getBundle() {
        return this.fwCtx.systemBundle;
    }

    @Override
    public void refreshBundles(Collection<Bundle> bundles, FrameworkListener ... listeners) {
        Bundle[] bs = bundles != null ? bundles.toArray(new Bundle[bundles.size()]) : null;
        this.fwCtx.packageAdmin.refreshPackages(bs, listeners);
    }

    @Override
    public boolean resolveBundles(Collection<Bundle> bundles) {
        Bundle[] bs = bundles != null ? bundles.toArray(new Bundle[bundles.size()]) : null;
        return this.fwCtx.packageAdmin.resolveBundles(bs);
    }

    @Override
    public Collection<Bundle> getRemovalPendingBundles() {
        HashSet<Bundle> res = new HashSet<Bundle>();
        this.fwCtx.bundles.getRemovalPendingBundles(res);
        return res;
    }

    @Override
    public Collection<Bundle> getDependencyClosure(Collection<Bundle> bundles) {
        HashSet<Bundle> res = new HashSet<Bundle>();
        for (Bundle b : bundles) {
            this.fwCtx.checkOurBundle(b);
            res.add(b);
        }
        this.fwCtx.resolver.closure(res);
        return res;
    }

    @Override
    public Collection<BundleCapability> findProviders(Requirement requirement) {
        Filter filter;
        String namespace = requirement.getNamespace();
        String filterStr = requirement.getDirectives().get("filter");
        if (filterStr != null) {
            try {
                filter = FrameworkUtil.createFilter(filterStr);
            }
            catch (InvalidSyntaxException ise) {
                String msg = "Invalid filter directive '" + filterStr + "': " + ise;
                throw new IllegalArgumentException(msg, ise);
            }
        } else {
            filter = null;
        }
        HashSet<BundleCapability> res = new HashSet<BundleCapability>();
        for (BundleGeneration bg : this.fwCtx.bundles.getBundleGenerations(null)) {
            BundleRevisionImpl bri = bg.bundleRevision;
            if (bri == null) continue;
            for (BundleCapability bc : bri.getDeclaredCapabilities(namespace)) {
                if (null != filter && !filter.matches(bc.getAttributes())) continue;
                res.add(bc);
            }
        }
        return res;
    }
}

