/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map.mindmapmode.clipboard;

import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.dpolivaev.mnemonicsetter.MnemonicSetter;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.map.mindmapmode.clipboard.MMapClipboardController;
import org.freeplane.features.mode.Controller;

class SelectedPasteAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private MMapClipboardController.IDataFlavorHandler selectedHandler;

    public SelectedPasteAction() {
        super("SelectedPasteAction");
    }

    public void actionPerformed(ActionEvent e) {
        MMapClipboardController clipboardController = (MMapClipboardController)MapClipboardController.getController();
        Collection<MMapClipboardController.IDataFlavorHandler> flavorHandlers = clipboardController.getFlavorHandlers();
        if (flavorHandlers.isEmpty()) {
            return;
        }
        JPanel options = this.createPane(flavorHandlers);
        MnemonicSetter.INSTANCE.setComponentMnemonics(new Container[]{options});
        if (2 == JOptionPane.showConfirmDialog((Component)e.getSource(), options, (String)this.getValue("Name"), 2)) {
            return;
        }
        NodeModel parent = Controller.getCurrentController().getSelection().getSelected();
        Transferable clipboardContents = clipboardController.getClipboardContents();
        clipboardController.paste(clipboardContents, this.selectedHandler, parent, MapController.suggestNewChildSide((NodeModel)parent, (NodeModel.Side)NodeModel.Side.DEFAULT));
        this.selectedHandler = null;
    }

    private JPanel createPane(Collection<MMapClipboardController.IDataFlavorHandler> flavorHandlers) {
        ButtonGroup group = new ButtonGroup();
        JRadioButton[] buttons = new JRadioButton[flavorHandlers.size()];
        int i = 0;
        this.selectedHandler = null;
        for (final MMapClipboardController.IDataFlavorHandler handler : flavorHandlers) {
            JRadioButton radioButton = new JRadioButton(TextUtils.getText((String)handler.getClass().getSimpleName()));
            group.add(radioButton);
            if (this.selectedHandler == null) {
                this.selectedHandler = handler;
                radioButton.setSelected(true);
            }
            radioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectedPasteAction.this.selectedHandler = handler;
                }
            });
            buttons[i++] = radioButton;
        }
        return this.createPane(buttons);
    }

    private JPanel createPane(JRadioButton[] radioButtons) {
        int numChoices = radioButtons.length;
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 3));
        for (int i = 0; i < numChoices; ++i) {
            box.add(radioButtons[i]);
        }
        return box;
    }
}

