/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.core.resources.components.QuantityProperty;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.nodestyle.NodeSizeModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

class MinNodeWidthControlGroup
implements ControlGroup {
    private static final String MIN_NODE_WIDTH = "min_node_width";
    private static final String REVERT = "revert-min_node_width";
    private RevertingProperty mSetMinNodeWidth;
    private QuantityProperty<LengthUnit> mMinNodeWidth;
    private MinNodeWidthChangeListener propertyChangeListener;

    MinNodeWidthControlGroup() {
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.mSetMinNodeWidth = new RevertingProperty(REVERT);
        this.mMinNodeWidth = new QuantityProperty(MIN_NODE_WIDTH, 0.0, 100000.0, 0.1, (Enum)LengthUnit.px);
        this.propertyChangeListener = new MinNodeWidthChangeListener(this.mSetMinNodeWidth, new IPropertyControl[]{this.mMinNodeWidth});
        this.mSetMinNodeWidth.addPropertyChangeListener(this.propertyChangeListener);
        this.mMinNodeWidth.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.mMinNodeWidth.appendToForm(formBuilder);
        this.mSetMinNodeWidth.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.propertyChangeListener.setStyle(node);
    }

    private class MinNodeWidthChangeListener
    extends ControlGroupChangeListener {
        public MinNodeWidthChangeListener(RevertingProperty mSet, IPropertyControl ... mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            styleController.setMinNodeWidth(node, enabled ? MinNodeWidthControlGroup.this.mMinNodeWidth.getQuantifiedValue() : null);
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            NodeSizeModel nodeSizeModel = NodeSizeModel.getModel((NodeModel)node);
            NodeStyleController styleController = NodeStyleController.getController();
            Quantity width = nodeSizeModel != null ? nodeSizeModel.getMinNodeWidth() : null;
            Quantity viewWidth = styleController.getMinWidth(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            MinNodeWidthControlGroup.this.mSetMinNodeWidth.setValue(width != null);
            MinNodeWidthControlGroup.this.mMinNodeWidth.setQuantifiedValue(viewWidth);
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, MinNodeWidthControlGroup.this.mSetMinNodeWidth);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)MinNodeWidthControlGroup.this.mMinNodeWidth);
        }
    }
}

