/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import javajs.J2SIgnoreImport;
import javajs.api.JSONEncodable;
import javajs.util.AU;
import javajs.util.DF;
import javajs.util.Lst;
import javajs.util.M34;
import javajs.util.M4;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.T4;

@J2SIgnoreImport(value={Array.class})
public class PT {
    public static final float[] tensScale = new float[]{10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f};
    public static final float[] decimalScale = new float[]{0.1f, 0.01f, 0.001f, 1.0E-4f, 1.0E-5f, 1.0E-6f, 1.0E-7f, 1.0E-8f, 1.0E-9f, 1.0E-10f, 1.0E-11f, 1.0E-12f, 1.0E-13f, 1.0E-14f, 1.0E-15f};
    private static final String escapable = "\\\\\tt\rr\nn\"\"";
    public static final float FRACTIONAL_PRECISION = 100000.0f;
    public static final float CARTESIAN_PRECISION = 10000.0f;

    public static int parseInt(String str) {
        return PT.parseIntNext(str, new int[]{0});
    }

    public static int parseIntNext(String str, int[] next) {
        int cch = str.length();
        if (next[0] < 0 || next[0] >= cch) {
            return Integer.MIN_VALUE;
        }
        return PT.parseIntChecked(str, cch, next);
    }

    public static int parseIntChecked(String str, int ichMax, int[] next) {
        char ch;
        boolean digitSeen = false;
        int value = 0;
        int ich = next[0];
        if (ich < 0) {
            return Integer.MIN_VALUE;
        }
        while (ich < ichMax && PT.isWhiteSpace(str, ich)) {
            ++ich;
        }
        boolean negative = false;
        if (ich < ichMax && str.charAt(ich) == '-') {
            negative = true;
            ++ich;
        }
        while (ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
            value = value * 10 + (ch - 48);
            digitSeen = true;
            ++ich;
        }
        if (!digitSeen) {
            value = Integer.MIN_VALUE;
        } else if (negative) {
            value = -value;
        }
        next[0] = ich;
        return value;
    }

    public static boolean isWhiteSpace(String str, int ich) {
        char ch;
        return ich >= 0 && ((ch = str.charAt(ich)) == ' ' || ch == '\t' || ch == '\n');
    }

    public static float parseFloatChecked(String str, int ichMax, int[] next, boolean isStrict) {
        float value;
        int nzero;
        int ich;
        boolean digitSeen = false;
        if (isStrict && str.indexOf(10) != str.lastIndexOf(10)) {
            return Float.NaN;
        }
        for (ich = next[0]; ich < ichMax && PT.isWhiteSpace(str, ich); ++ich) {
        }
        boolean negative = false;
        if (ich < ichMax && str.charAt(ich) == '-') {
            ++ich;
            negative = true;
        }
        char ch = '\u0000';
        float ival = 0.0f;
        float ival2 = 0.0f;
        while (ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
            ival = ival * 10.0f + (float)(ch - 48) * 1.0f;
            ++ich;
            digitSeen = true;
        }
        boolean isDecimal = false;
        int iscale = 0;
        int n = nzero = ival == 0.0f ? -1 : 0;
        if (ch == '.') {
            isDecimal = true;
            while (++ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
                digitSeen = true;
                if (nzero < 0) {
                    if (ch == '0') {
                        --nzero;
                        continue;
                    }
                    nzero = -nzero;
                }
                if (iscale >= decimalScale.length) continue;
                ival2 = ival2 * 10.0f + (float)(ch - 48) * 1.0f;
                ++iscale;
            }
        }
        if (!digitSeen) {
            value = Float.NaN;
        } else if (ival2 > 0.0f) {
            value = ival2 * decimalScale[iscale - 1];
            value = nzero > 1 ? (nzero - 2 < decimalScale.length ? (value *= decimalScale[nzero - 2]) : (float)((double)value * Math.pow(10.0, 1 - nzero))) : (value += ival);
        } else {
            value = ival;
        }
        boolean isExponent = false;
        if (ich < ichMax && (ch == 'E' || ch == 'e' || ch == 'D')) {
            isExponent = true;
            if (++ich >= ichMax) {
                return Float.NaN;
            }
            ch = str.charAt(ich);
            if (ch == '+' && ++ich >= ichMax) {
                return Float.NaN;
            }
            next[0] = ich;
            int exponent = PT.parseIntChecked(str, ichMax, next);
            if (exponent == Integer.MIN_VALUE) {
                return Float.NaN;
            }
            if (exponent > 0 && exponent <= tensScale.length) {
                value *= tensScale[exponent - 1];
            } else if (exponent < 0 && -exponent <= decimalScale.length) {
                value *= decimalScale[-exponent - 1];
            } else if (exponent != 0) {
                value = (float)((double)value * Math.pow(10.0, exponent));
            }
        } else {
            next[0] = ich;
        }
        if (negative) {
            value = -value;
        }
        if (value == Float.POSITIVE_INFINITY) {
            value = Float.MAX_VALUE;
        }
        return !isStrict || (!isExponent || isDecimal) && PT.checkTrailingText(str, next[0], ichMax) ? value : Float.NaN;
    }

    public static boolean checkTrailingText(String str, int ich, int ichMax) {
        char ch;
        while (ich < ichMax && (PT.isWhitespace(ch = str.charAt(ich)) || ch == ';')) {
            ++ich;
        }
        return ich == ichMax;
    }

    public static float[] parseFloatArray(String str) {
        return PT.parseFloatArrayNext(str, new int[1], null, null, null);
    }

    public static int parseFloatArrayInfested(String[] tokens, float[] data) {
        int len = data.length;
        int nTokens = tokens.length;
        int n = 0;
        int max = 0;
        for (int i = 0; i >= 0 && i < len && n < nTokens; ++i) {
            float f;
            while (Float.isNaN(f = PT.parseFloat(tokens[n++])) && n < nTokens) {
            }
            if (!Float.isNaN(f)) {
                max = i;
                data[max] = f;
            }
            if (n == nTokens) break;
        }
        return max + 1;
    }

    public static float[] parseFloatArrayNext(String str, int[] next, float[] f, String strStart, String strEnd) {
        int n = 0;
        int pt = next[0];
        if (pt >= 0) {
            int p;
            if (strStart != null && (p = str.indexOf(strStart, pt)) >= 0) {
                next[0] = p + strStart.length();
            }
            str = str.substring(next[0]);
            int n2 = pt = strEnd == null ? -1 : str.indexOf(strEnd);
            if (pt < 0) {
                pt = str.length();
            } else {
                str = str.substring(0, pt);
            }
            next[0] = next[0] + (pt + 1);
            String[] tokens = PT.getTokens(str);
            if (f == null) {
                f = new float[tokens.length];
            }
            n = PT.parseFloatArrayInfested(tokens, f);
        }
        if (f == null) {
            return new float[0];
        }
        for (int i = n; i < f.length; ++i) {
            f[i] = Float.NaN;
        }
        return f;
    }

    public static float parseFloatRange(String str, int ichMax, int[] next) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (next[0] < 0 || next[0] >= ichMax) {
            return Float.NaN;
        }
        return PT.parseFloatChecked(str, ichMax, next, false);
    }

    public static float parseFloatNext(String str, int[] next) {
        int cch = str == null ? -1 : str.length();
        return next[0] < 0 || next[0] >= cch ? Float.NaN : PT.parseFloatChecked(str, cch, next, false);
    }

    public static float parseFloatStrict(String str) {
        int cch = str.length();
        if (cch == 0) {
            return Float.NaN;
        }
        return PT.parseFloatChecked(str, cch, new int[]{0}, true);
    }

    public static float parseFloat(String str) {
        return PT.parseFloatNext(str, new int[]{0});
    }

    public static int parseIntRadix(String s, int i) throws NumberFormatException {
        return Integer.parseInt(s, i);
    }

    public static String[] getTokens(String line) {
        return PT.getTokensAt(line, 0);
    }

    public static String parseToken(String str) {
        return PT.parseTokenNext(str, new int[]{0});
    }

    public static String parseTrimmed(String str) {
        return PT.parseTrimmedRange(str, 0, str.length());
    }

    public static String parseTrimmedAt(String str, int ichStart) {
        return PT.parseTrimmedRange(str, ichStart, str.length());
    }

    public static String parseTrimmedRange(String str, int ichStart, int ichMax) {
        int cch = str.length();
        if (ichMax < cch) {
            cch = ichMax;
        }
        if (cch < ichStart) {
            return "";
        }
        return PT.parseTrimmedChecked(str, ichStart, cch);
    }

    public static String[] getTokensAt(String line, int ich) {
        if (line == null) {
            return null;
        }
        int cchLine = line.length();
        if (ich < 0 || ich > cchLine) {
            return null;
        }
        int tokenCount = PT.countTokens(line, ich);
        String[] tokens = new String[tokenCount];
        int[] next = new int[]{ich};
        for (int i = 0; i < tokenCount; ++i) {
            tokens[i] = PT.parseTokenChecked(line, cchLine, next);
        }
        return tokens;
    }

    public static int countChar(String line, char c) {
        int n = 0;
        int i = line.lastIndexOf(c) + 1;
        while (--i >= 0) {
            if (line.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static int countTokens(String line, int ich) {
        int tokenCount = 0;
        if (line != null) {
            int ichMax = line.length();
            while (true) {
                if (ich < ichMax && PT.isWhiteSpace(line, ich)) {
                    ++ich;
                    continue;
                }
                if (ich == ichMax) break;
                ++tokenCount;
                while (++ich < ichMax && !PT.isWhiteSpace(line, ich)) {
                }
            }
        }
        return tokenCount;
    }

    public static String parseTokenNext(String str, int[] next) {
        int cch = str.length();
        return next[0] < 0 || next[0] >= cch ? null : PT.parseTokenChecked(str, cch, next);
    }

    public static String parseTokenRange(String str, int ichMax, int[] next) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        return next[0] < 0 || next[0] >= ichMax ? null : PT.parseTokenChecked(str, ichMax, next);
    }

    public static String parseTokenChecked(String str, int ichMax, int[] next) {
        int ich;
        for (ich = next[0]; ich < ichMax && PT.isWhiteSpace(str, ich); ++ich) {
        }
        int ichNonWhite = ich;
        while (ich < ichMax && !PT.isWhiteSpace(str, ich)) {
            ++ich;
        }
        next[0] = ich;
        return ichNonWhite == ich ? null : str.substring(ichNonWhite, ich);
    }

    public static String parseTrimmedChecked(String str, int ich, int ichMax) {
        int ichLast;
        while (ich < ichMax && PT.isWhiteSpace(str, ich)) {
            ++ich;
        }
        for (ichLast = ichMax - 1; ichLast >= ich && PT.isWhiteSpace(str, ichLast); --ichLast) {
        }
        return ichLast < ich ? "" : str.substring(ich, ichLast + 1);
    }

    public static double dVal(String s) throws NumberFormatException {
        return Double.valueOf(s);
    }

    public static float fVal(String s) throws NumberFormatException {
        return Float.parseFloat(s);
    }

    public static int parseIntRange(String str, int ichMax, int[] next) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        return next[0] < 0 || next[0] >= ichMax ? Integer.MIN_VALUE : PT.parseIntChecked(str, ichMax, next);
    }

    public static void parseFloatArrayData(String[] tokens, float[] data) {
        PT.parseFloatArrayDataN(tokens, data, data.length);
    }

    public static void parseFloatArrayDataN(String[] tokens, float[] data, int nData) {
        int i = nData;
        while (--i >= 0) {
            data[i] = i >= tokens.length ? Float.NaN : PT.parseFloat(tokens[i]);
        }
    }

    public static String[] split(String text, String run) {
        if (text.length() == 0) {
            return new String[0];
        }
        int n = 1;
        int i = text.indexOf(run);
        int runLen = run.length();
        if (i < 0 || runLen == 0) {
            String[] lines = new String[]{text};
            return lines;
        }
        int len = text.length() - runLen;
        while (i >= 0 && i < len) {
            i = text.indexOf(run, i + runLen);
            ++n;
        }
        String[] lines = new String[n];
        i = 0;
        int ipt = 0;
        int pt = 0;
        while ((ipt = text.indexOf(run, i)) >= 0 && pt + 1 < n) {
            lines[pt++] = text.substring(i, ipt);
            i = ipt + runLen;
        }
        if (text.indexOf(run, len) != len) {
            len += runLen;
        }
        lines[pt] = text.substring(i, len);
        return lines;
    }

    public static String getQuotedStringAt(String line, int ipt0) {
        int[] next = new int[]{ipt0};
        return PT.getQuotedStringNext(line, next);
    }

    public static String getQuotedStringNext(String line, int[] next) {
        int i = next[0];
        if (i < 0 || (i = line.indexOf("\"", i)) < 0) {
            return "";
        }
        int pt = i + 1;
        int len = line.length();
        while (++i < len && line.charAt(i) != '\"') {
            if (line.charAt(i) != '\\') continue;
            ++i;
        }
        next[0] = i + 1;
        return line.substring(pt, i);
    }

    public static String getQuotedOrUnquotedAttribute(String line, String key) {
        if (line == null || key == null) {
            return null;
        }
        int pt = line.toLowerCase().indexOf(key.toLowerCase() + "=");
        if (pt < 0 || (pt = pt + key.length() + 1) >= line.length()) {
            return "";
        }
        int c = line.charAt(pt);
        switch (c) {
            case 34: 
            case 39: {
                ++pt;
                break;
            }
            default: {
                c = 32;
                line = line + " ";
            }
        }
        int pt1 = line.indexOf(c, pt);
        return pt1 < 0 ? null : line.substring(pt, pt1);
    }

    public static String getCSVString(String line, int[] next) {
        int i = next[1];
        if (i < 0 || (i = line.indexOf("\"", i)) < 0) {
            return null;
        }
        int pt = next[0] = i;
        int len = line.length();
        boolean escaped = false;
        boolean haveEscape = false;
        while (++i < len && (line.charAt(i) != '\"' || (escaped = i + 1 < len && line.charAt(i + 1) == '\"'))) {
            if (!escaped) continue;
            escaped = false;
            haveEscape = true;
            ++i;
        }
        if (i >= len) {
            next[1] = -1;
            return null;
        }
        next[1] = i + 1;
        String s = line.substring(pt + 1, i);
        return haveEscape ? PT.rep(PT.rep(s, "\"\"", "\u0000"), "\u0000", "\"") : s;
    }

    public static boolean isOneOf(String key, String semiList) {
        if (semiList.length() == 0 || key.indexOf(";") >= 0) {
            return false;
        }
        if (semiList.charAt(0) != ';') {
            semiList = ";" + semiList + ";";
        }
        return semiList.indexOf(';' + key + ';') >= 0;
    }

    public static String getQuotedAttribute(String info, String name) {
        int i = info.indexOf(name + "=");
        return i < 0 ? null : PT.getQuotedStringAt(info, i);
    }

    public static float approx(float f, float n) {
        return (float)Math.round(f * n) / n;
    }

    public static String rep(String str, String strFrom, String strTo) {
        if (str == null || strFrom.length() == 0 || str.indexOf(strFrom) < 0) {
            return str;
        }
        boolean isOnce = strTo.indexOf(strFrom) >= 0;
        do {
            str = str.replace(strFrom, strTo);
        } while (!isOnce && str.indexOf(strFrom) >= 0);
        return str;
    }

    public static String formatF(float value, int width, int precision, boolean alignLeft, boolean zeroPad) {
        return PT.formatS(DF.formatDecimal(value, precision), width, 0, alignLeft, zeroPad);
    }

    public static String formatD(double value, int width, int precision, boolean alignLeft, boolean zeroPad) {
        return PT.formatS(DF.formatDecimal((float)value, -1 - precision), width, 0, alignLeft, zeroPad);
    }

    public static String formatS(String value, int width, int precision, boolean alignLeft, boolean zeroPad) {
        if (value == null) {
            return "";
        }
        int len = value.length();
        if (precision != Integer.MAX_VALUE && precision > 0 && precision < len) {
            value = value.substring(0, precision);
        } else if (precision < 0 && len + precision >= 0) {
            value = value.substring(len + precision + 1);
        }
        int padLength = width - value.length();
        if (padLength <= 0) {
            return value;
        }
        boolean isNeg = zeroPad && !alignLeft && value.charAt(0) == '-';
        char padChar = zeroPad ? (char)'0' : ' ';
        char padChar0 = isNeg ? (char)'-' : padChar;
        SB sb = new SB();
        if (alignLeft) {
            sb.append(value);
        }
        sb.appendC(padChar0);
        int i = padLength;
        while (--i > 0) {
            sb.appendC(padChar);
        }
        if (!alignLeft) {
            sb.append(isNeg ? padChar + value.substring(1) : value);
        }
        return sb.toString();
    }

    public static String replaceWithCharacter(String str, String strFrom, char chTo) {
        if (str == null) {
            return null;
        }
        int i = strFrom.length();
        while (--i >= 0) {
            str = str.replace(strFrom.charAt(i), chTo);
        }
        return str;
    }

    public static String replaceAllCharacters(String str, String strFrom, String strTo) {
        int i = strFrom.length();
        while (--i >= 0) {
            String chFrom = strFrom.substring(i, i + 1);
            str = PT.rep(str, chFrom, strTo);
        }
        return str;
    }

    public static String trim(String str, String chars) {
        int m;
        int k;
        if (str == null || str.length() == 0) {
            return str;
        }
        if (chars.length() == 0) {
            return str.trim();
        }
        int len = str.length();
        for (k = 0; k < len && chars.indexOf(str.charAt(k)) >= 0; ++k) {
        }
        for (m = str.length() - 1; m > k && chars.indexOf(str.charAt(m)) >= 0; --m) {
        }
        return str.substring(k, m + 1);
    }

    public static String trimQuotes(String value) {
        return value != null && value.length() > 1 && value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
    }

    public static boolean isNonStringPrimitive(Object info) {
        return info instanceof Number || info instanceof Boolean;
    }

    public static String toJSON(String infoType, Object info) {
        if (info == null) {
            return PT.packageJSON(infoType, null);
        }
        if (PT.isNonStringPrimitive(info)) {
            return PT.packageJSON(infoType, info.toString());
        }
        String s = null;
        SB sb = null;
        while (true) {
            if (info instanceof String) {
                s = (String)info;
                if (s.indexOf("{\"") == 0) break;
                s = PT.esc(s);
                break;
            }
            if (info instanceof JSONEncodable) {
                s = ((JSONEncodable)info).toJSON();
                if (s != null) break;
                s = "null";
                break;
            }
            sb = new SB();
            if (info instanceof Map) {
                sb.append("{ ");
                String sep = "";
                Set keys = ((Map)info).keySet();
                Object[] skeys = keys.toArray(new String[keys.size()]);
                Arrays.sort(skeys);
                for (Object key : skeys) {
                    if (key == null) {
                        key = "null";
                    }
                    sb.append(sep).append(PT.packageJSON((String)key, PT.toJSON(null, ((Map)info).get(key))));
                    sep = ",";
                }
                sb.append(" }");
                break;
            }
            if (info instanceof Lst) {
                sb.append("[ ");
                int n = ((Lst)info).size();
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        sb.appendC(',');
                    }
                    sb.append(PT.toJSON(null, ((Lst)info).get(i)));
                }
                sb.append(" ]");
                break;
            }
            if (info instanceof M34) {
                int len = info instanceof M4 ? 4 : 3;
                float[] x = new float[len];
                M34 m = (M34)info;
                sb.appendC('[');
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        sb.appendC(',');
                    }
                    m.getRow(i, x);
                    sb.append(PT.toJSON(null, x));
                }
                sb.appendC(']');
                break;
            }
            s = PT.nonArrayString(info);
            if (s == null) {
                sb.append("[");
                int n = AU.getLength(info);
                Object o = null;
                if (o != null) {
                    sb.appendO(info);
                } else {
                    for (int i = 0; i < n; ++i) {
                        if (i > 0) {
                            sb.appendC(',');
                        }
                        sb.append(PT.toJSON(null, PT.arrayGet(info, i)));
                    }
                }
                sb.append("]");
                break;
            }
            info = info.toString();
        }
        return PT.packageJSON(infoType, s == null ? sb.toString() : s);
    }

    private static Object arrayGet(Object info, int i) {
        return Array.get(info, i);
    }

    public static String nonArrayString(Object x) {
        try {
            Array.getLength(x);
            return null;
        }
        catch (Exception e) {
            return x.toString();
        }
    }

    public static String byteArrayToJSON(byte[] data) {
        SB sb = new SB();
        sb.append("[");
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sb.appendC(',');
            }
            sb.appendI(data[i] & 0xFF);
        }
        sb.append("]");
        return sb.toString();
    }

    public static String packageJSON(String infoType, String info) {
        return infoType == null ? info : "\"" + infoType + "\": " + info;
    }

    public static String escapeUrl(String url) {
        url = PT.rep(url, "\n", "");
        url = PT.rep(url, "%", "%25");
        url = PT.rep(url, "#", "%23");
        url = PT.rep(url, "[", "%5B");
        url = PT.rep(url, "\\", "%5C");
        url = PT.rep(url, "]", "%5D");
        url = PT.rep(url, " ", "%20");
        return url;
    }

    public static String esc(String str) {
        int i;
        if (str == null || str.length() == 0) {
            return "\"\"";
        }
        boolean haveEscape = false;
        for (i = 0; i < escapable.length(); i += 2) {
            if (str.indexOf(escapable.charAt(i)) < 0) continue;
            haveEscape = true;
            break;
        }
        if (haveEscape) {
            while (i < escapable.length()) {
                int pt = -1;
                char ch = escapable.charAt(i++);
                char ch2 = escapable.charAt(i++);
                SB sb = new SB();
                int pt0 = 0;
                while ((pt = str.indexOf(ch, pt + 1)) >= 0) {
                    sb.append(str.substring(pt0, pt)).appendC('\\').appendC(ch2);
                    pt0 = pt + 1;
                }
                sb.append(str.substring(pt0, str.length()));
                str = sb.toString();
            }
        }
        return "\"" + PT.escUnicode(str) + "\"";
    }

    public static String escUnicode(String str) {
        int i = str.length();
        while (--i >= 0) {
            if (str.charAt(i) <= '\u007f') continue;
            String s = "0000" + Integer.toHexString(str.charAt(i));
            str = str.substring(0, i) + "\\u" + s.substring(s.length() - 4) + str.substring(i + 1);
        }
        return str;
    }

    public static String escF(float f) {
        String sf = "" + f;
        return sf;
    }

    public static String join(String[] s, char c, int i0) {
        if (s.length < i0) {
            return null;
        }
        SB sb = new SB();
        sb.append(s[i0++]);
        for (int i = i0; i < s.length; ++i) {
            sb.appendC(c).append(s[i]);
        }
        return sb.toString();
    }

    public static boolean isLike(String a, String b) {
        boolean areEqual = a.equals(b);
        if (areEqual) {
            return true;
        }
        boolean isStart = b.startsWith("*");
        boolean isEnd = b.endsWith("*");
        return !isStart && !isEnd ? areEqual : (isStart && isEnd ? b.length() == 1 || a.contains(b.substring(1, b.length() - 1)) : (isStart ? a.endsWith(b.substring(1)) : a.startsWith(b.substring(0, b.length() - 1))));
    }

    public static Object getMapValueNoCase(Map<String, ?> h, String key) {
        if ("this".equals(key)) {
            return h;
        }
        Object val = h.get(key);
        if (val == null) {
            for (Map.Entry<String, ?> e : h.entrySet()) {
                if (!e.getKey().equalsIgnoreCase(key)) continue;
                return e.getValue();
            }
        }
        return val;
    }

    public static String clean(String s) {
        return PT.rep(PT.replaceAllCharacters(s, " \t\n\r", " "), "  ", " ").trim();
    }

    public static String fdup(String f, int pt, int n) {
        int count = 0;
        int i = pt;
        block4: while (--i >= 1) {
            char ch = f.charAt(i);
            if (PT.isDigit(ch)) continue;
            switch (ch) {
                case '.': {
                    if (count++ == 0) continue block4;
                    return f;
                }
                case '-': {
                    if (i == 1 || f.charAt(i - 1) == '.') continue block4;
                    return f;
                }
            }
            return f;
        }
        String s = f.substring(0, pt + 1);
        SB sb = new SB();
        for (int i2 = 0; i2 < n; ++i2) {
            sb.append(s);
        }
        sb.append(f.substring(pt + 1));
        return sb.toString();
    }

    private static String formatString(String strFormat, String key, String strT, float floatT, double doubleT, boolean doOne) {
        int ichKey;
        int ichPercent;
        if (strFormat == null) {
            return null;
        }
        if ("".equals(strFormat)) {
            return "";
        }
        int len = key.length();
        if (strFormat.indexOf("%") < 0 || len == 0 || strFormat.indexOf(key) < 0) {
            return strFormat;
        }
        String strLabel = "";
        int ich = 0;
        while ((ichPercent = strFormat.indexOf(37, ich)) >= 0 && (ichKey = strFormat.indexOf(key, ichPercent + 1)) >= 0) {
            if (ich != ichPercent) {
                strLabel = strLabel + strFormat.substring(ich, ichPercent);
            }
            ich = ichPercent + 1;
            if (ichKey > ichPercent + 6) {
                strLabel = strLabel + '%';
                continue;
            }
            try {
                String st;
                char ch;
                boolean alignLeft = false;
                if (strFormat.charAt(ich) == '-') {
                    alignLeft = true;
                    ++ich;
                }
                boolean zeroPad = false;
                if (strFormat.charAt(ich) == '0') {
                    zeroPad = true;
                    ++ich;
                }
                int width = 0;
                while ((ch = strFormat.charAt(ich)) >= '0' && ch <= '9') {
                    width = 10 * width + (ch - 48);
                    ++ich;
                }
                int precision = Integer.MAX_VALUE;
                boolean isExponential = false;
                if (strFormat.charAt(ich) == '.') {
                    if ((ch = strFormat.charAt(++ich)) == '-') {
                        isExponential = true;
                        ++ich;
                    }
                    if ((ch = strFormat.charAt(ich)) >= '0' && ch <= '9') {
                        precision = ch - 48;
                        if ((ch = strFormat.charAt(++ich)) >= '0' && ch <= '9') {
                            precision = 10 * precision + (ch - 48);
                            ++ich;
                        }
                    }
                    if (isExponential) {
                        precision = -precision;
                    }
                }
                if (!(st = strFormat.substring(ich, ich + len)).equals(key)) {
                    ich = ichPercent + 1;
                    strLabel = strLabel + '%';
                    continue;
                }
                ich += len;
                if (!Float.isNaN(floatT)) {
                    strLabel = strLabel + PT.formatF(floatT, width, precision, alignLeft, zeroPad);
                } else if (strT != null) {
                    strLabel = strLabel + PT.formatS(strT, width, precision < 0 ? precision - 1 : precision, alignLeft, zeroPad);
                } else if (!Double.isNaN(doubleT)) {
                    strLabel = strLabel + PT.formatD(doubleT, width, precision - 1, alignLeft, zeroPad);
                }
                if (!doOne) continue;
                break;
            }
            catch (IndexOutOfBoundsException ioobe) {
                ich = ichPercent;
                break;
            }
        }
        strLabel = strLabel + strFormat.substring(ich);
        return strLabel;
    }

    public static String formatStringS(String strFormat, String key, String strT) {
        return PT.formatString(strFormat, key, strT, Float.NaN, Double.NaN, false);
    }

    public static String formatStringF(String strFormat, String key, float floatT) {
        return PT.formatString(strFormat, key, null, floatT, Double.NaN, false);
    }

    public static String formatStringI(String strFormat, String key, int intT) {
        return PT.formatString(strFormat, key, "" + intT, Float.NaN, Double.NaN, false);
    }

    public static String sprintf(String strFormat, String list, Object[] values) {
        if (values == null) {
            return strFormat;
        }
        int n = list.length();
        if (n == values.length) {
            try {
                block14: for (int o = 0; o < n; ++o) {
                    if (values[o] == null) continue;
                    switch (list.charAt(o)) {
                        case 's': {
                            strFormat = PT.formatString(strFormat, "s", (String)values[o], Float.NaN, Double.NaN, true);
                            continue block14;
                        }
                        case 'f': {
                            strFormat = PT.formatString(strFormat, "f", null, ((Number)values[o]).floatValue(), Double.NaN, true);
                            continue block14;
                        }
                        case 'i': {
                            strFormat = PT.formatString(strFormat, "d", "" + values[o], Float.NaN, Double.NaN, true);
                            strFormat = PT.formatString(strFormat, "i", "" + values[o], Float.NaN, Double.NaN, true);
                            continue block14;
                        }
                        case 'd': {
                            strFormat = PT.formatString(strFormat, "e", null, Float.NaN, ((Number)values[o]).doubleValue(), true);
                            continue block14;
                        }
                        case 'p': {
                            T3 pVal = (T3)values[o];
                            strFormat = PT.formatString(strFormat, "p", null, pVal.x, Double.NaN, true);
                            strFormat = PT.formatString(strFormat, "p", null, pVal.y, Double.NaN, true);
                            strFormat = PT.formatString(strFormat, "p", null, pVal.z, Double.NaN, true);
                            continue block14;
                        }
                        case 'q': {
                            T4 qVal = (T4)values[o];
                            strFormat = PT.formatString(strFormat, "q", null, qVal.x, Double.NaN, true);
                            strFormat = PT.formatString(strFormat, "q", null, qVal.y, Double.NaN, true);
                            strFormat = PT.formatString(strFormat, "q", null, qVal.z, Double.NaN, true);
                            strFormat = PT.formatString(strFormat, "q", null, qVal.w, Double.NaN, true);
                            continue block14;
                        }
                        case 'S': {
                            String[] sVal = (String[])values[o];
                            for (int i = 0; i < sVal.length; ++i) {
                                strFormat = PT.formatString(strFormat, "s", sVal[i], Float.NaN, Double.NaN, true);
                            }
                            continue block14;
                        }
                        case 'F': {
                            float[] fVal = (float[])values[o];
                            for (int i = 0; i < fVal.length; ++i) {
                                strFormat = PT.formatString(strFormat, "f", null, fVal[i], Double.NaN, true);
                            }
                            continue block14;
                        }
                        case 'I': {
                            int i;
                            int[] iVal = (int[])values[o];
                            for (i = 0; i < iVal.length; ++i) {
                                strFormat = PT.formatString(strFormat, "d", "" + iVal[i], Float.NaN, Double.NaN, true);
                            }
                            for (i = 0; i < iVal.length; ++i) {
                                strFormat = PT.formatString(strFormat, "i", "" + iVal[i], Float.NaN, Double.NaN, true);
                            }
                            continue block14;
                        }
                        case 'D': {
                            double[] dVal = (double[])values[o];
                            for (int i = 0; i < dVal.length; ++i) {
                                strFormat = PT.formatString(strFormat, "e", null, Float.NaN, dVal[i], true);
                            }
                            continue block14;
                        }
                    }
                }
                return PT.rep(strFormat, "%%", "%");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.out.println("TextFormat.sprintf error " + list + " " + strFormat);
        return PT.rep(strFormat, "%", "?");
    }

    public static String formatCheck(String strFormat) {
        if (strFormat == null || strFormat.indexOf(112) < 0 && strFormat.indexOf(113) < 0) {
            return strFormat;
        }
        strFormat = PT.rep(strFormat, "%%", "\u0001");
        strFormat = PT.rep(strFormat, "%p", "%6.2p");
        strFormat = PT.rep(strFormat, "%q", "%6.2q");
        String[] format = PT.split(strFormat, "%");
        SB sb = new SB();
        sb.append(format[0]);
        for (int i = 1; i < format.length; ++i) {
            String f = "%" + format[i];
            if (f.length() >= 3) {
                int pt = f.indexOf(112);
                if (pt >= 0) {
                    f = PT.fdup(f, pt, 3);
                }
                if ((pt = f.indexOf(113)) >= 0) {
                    f = PT.fdup(f, pt, 4);
                }
            }
            sb.append(f);
        }
        return sb.toString().replace('\u0001', '%');
    }

    public static void leftJustify(SB s, String s1, String s2) {
        s.append(s2);
        int n = s1.length() - s2.length();
        if (n > 0) {
            s.append(s1.substring(0, n));
        }
    }

    public static void rightJustify(SB s, String s1, String s2) {
        int n = s1.length() - s2.length();
        if (n > 0) {
            s.append(s1.substring(0, n));
        }
        s.append(s2);
    }

    public static String safeTruncate(float f, int n) {
        if ((double)f > -0.001 && (double)f < 0.001) {
            f = 0.0f;
        }
        return (f + "         ").substring(0, n);
    }

    public static boolean isWild(String s) {
        return s != null && (s.indexOf("*") >= 0 || s.indexOf("?") >= 0);
    }

    public static boolean isMatch(String search, String match, boolean checkStar, boolean allowInitialStar) {
        int nq;
        boolean haveQ;
        boolean isStar0;
        if (search.equals(match)) {
            return true;
        }
        int mLen = match.length();
        if (mLen == 0) {
            return false;
        }
        boolean bl = checkStar && allowInitialStar ? match.charAt(0) == '*' : (isStar0 = false);
        if (mLen == 1 && isStar0) {
            return true;
        }
        boolean isStar1 = checkStar && match.endsWith("*");
        boolean bl2 = haveQ = match.indexOf(63) >= 0;
        if (!haveQ) {
            if (isStar0) {
                return isStar1 ? mLen < 3 || search.indexOf(match.substring(1, mLen - 1)) >= 0 : search.endsWith(match.substring(1));
            }
            if (isStar1) {
                return search.startsWith(match.substring(0, mLen - 1));
            }
        }
        int sLen = search.length();
        String qqqq = "????";
        for (nq = 4; nq < sLen; nq *= 2) {
            qqqq = qqqq + qqqq;
        }
        if (checkStar) {
            if (isStar0) {
                match = qqqq + match.substring(1);
                mLen += nq - 1;
            }
            if (isStar1) {
                match = match.substring(0, mLen - 1) + qqqq;
                mLen += nq - 1;
            }
        }
        if (mLen < sLen) {
            return false;
        }
        int ich = 0;
        while (mLen > sLen) {
            if (allowInitialStar && match.charAt(ich) == '?') {
                ++ich;
            } else if (match.charAt(ich + mLen - 1) != '?') {
                return false;
            }
            --mLen;
        }
        int i = sLen;
        while (--i >= 0) {
            char chs;
            char chm = match.charAt(ich + i);
            if (chm == '?' || chm == (chs = search.charAt(i)) || chm == '\u0001' && chs == '?') continue;
            return false;
        }
        return true;
    }

    public static String replaceQuotedStrings(String s, Lst<String> list, Lst<String> newList) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String name = (String)list.get(i);
            String newName = (String)newList.get(i);
            if (newName.equals(name)) continue;
            s = PT.rep(s, "\"" + name + "\"", "\"" + newName + "\"");
        }
        return s;
    }

    public static String replaceStrings(String s, Lst<String> list, Lst<String> newList) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String name = (String)list.get(i);
            String newName = (String)newList.get(i);
            if (newName.equals(name)) continue;
            s = PT.rep(s, name, newName);
        }
        return s;
    }

    public static boolean isDigit(char ch) {
        char c = ch;
        return '0' <= c && c <= '9';
    }

    public static boolean isUpperCase(char ch) {
        char c = ch;
        return 'A' <= c && c <= 'Z';
    }

    public static boolean isLowerCase(char ch) {
        char c = ch;
        return 'a' <= c && c <= 'z';
    }

    public static boolean isLetter(char ch) {
        char c = ch;
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z';
    }

    public static boolean isLetterOrDigit(char ch) {
        char c = ch;
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9';
    }

    public static boolean isWhitespace(char ch) {
        char c = ch;
        return c >= '\u001c' && c <= ' ' || c >= '\t' && c <= '\r';
    }

    public static void fixPtFloats(T3 pt, float f) {
        pt.x = (float)Math.round(pt.x * f) / f;
        pt.y = (float)Math.round(pt.y * f) / f;
        pt.z = (float)Math.round(pt.z * f) / f;
    }

    public static float fixFloat(float d, double f) {
        return (float)((double)Math.round((double)d * f) / f);
    }

    public static double fixDouble(double d, double f) {
        return (double)Math.round(d * f) / f;
    }

    public static float parseFloatFraction(String s) {
        int pt = s.indexOf("/");
        return pt < 0 ? PT.parseFloat(s) : PT.parseFloat(s.substring(0, pt)) / PT.parseFloat(s.substring(pt + 1));
    }
}

