/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.inchi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import net.sf.jniinchi.INCHI_BOND_STEREO;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.INCHI_PARITY;
import net.sf.jniinchi.INCHI_STEREOTYPE;
import net.sf.jniinchi.JniInchiAtom;
import net.sf.jniinchi.JniInchiBond;
import net.sf.jniinchi.JniInchiInput;
import net.sf.jniinchi.JniInchiInputInchi;
import net.sf.jniinchi.JniInchiOutput;
import net.sf.jniinchi.JniInchiOutputStructure;
import net.sf.jniinchi.JniInchiStereo0D;
import net.sf.jniinchi.JniInchiStructure;
import net.sf.jniinchi.JniInchiWrapper;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterBondIterator;
import org.jmol.api.JmolInChI;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.Node;
import org.jmol.util.SimpleNode;
import org.jmol.viewer.Viewer;

public class InChIJNI
implements JmolInChI {
    private Map<BS, int[]> mapTet;
    private Map<Integer, Boolean> mapPlanar;

    @Override
    public String getInchi(Viewer vwr, BS atoms, Object molData, String options) {
        try {
            boolean inputInChI;
            String smilesOptions;
            if (atoms == null ? molData == null : atoms.isEmpty()) {
                return "";
            }
            if (options == null) {
                options = "";
            }
            String inchi = null;
            String lc = options.toLowerCase();
            boolean getSmiles = lc.indexOf("smiles") == 0;
            boolean getStructure = lc.indexOf("structure") >= 0;
            boolean getKey = lc.indexOf("key") >= 0;
            String string = smilesOptions = getSmiles ? options : null;
            if (lc.startsWith("structure/")) {
                inchi = options.substring(10);
                lc = "";
                options = "";
            }
            boolean bl = inputInChI = molData instanceof String && ((String)molData).startsWith("InChI=");
            if (inputInChI) {
                inchi = (String)molData;
                if (getSmiles) {
                    options = lc.replace("structure", "");
                }
            } else {
                options = lc;
                if (getKey) {
                    options = options.replace("inchikey", "");
                    options = options.replace("key", "");
                }
                if (options.indexOf("fixedh?") >= 0) {
                    String fxd = this.getInchi(vwr, atoms, molData, options.replace('?', ' '));
                    options = PT.rep(options, "fixedh?", "");
                    String std = this.getInchi(vwr, atoms, molData, options);
                    inchi = fxd != null && fxd.length() <= std.length() ? std : fxd;
                } else {
                    JniInchiStructure struc;
                    JniInchiInput in = new JniInchiInput(getSmiles ? "fixedh" : options);
                    if (atoms == null) {
                        struc = InChIJNI.newJniInchiStructure(vwr, molData);
                        in.setStructure(struc);
                    } else {
                        struc = InChIJNI.newJniInchiStructureBS(vwr, atoms);
                        in.setStructure(struc);
                    }
                    if (getStructure) {
                        return InChIJNI.toJSON(struc);
                    }
                    JniInchiOutput out = JniInchiWrapper.getInchi(in);
                    String msg = out.getMessage();
                    if (msg != null) {
                        System.err.println(msg);
                    }
                    inchi = out.getInchi();
                }
            }
            if (getSmiles || getStructure) {
                JniInchiOutputStructure struc = JniInchiWrapper.getStructureFromInchi(new JniInchiInputInchi(inchi));
                return getSmiles ? this.getSmiles(vwr, struc, smilesOptions) : InChIJNI.toJSON(struc);
            }
            return getKey ? JniInchiWrapper.getInchiKey(inchi).getKey() : inchi;
        }
        catch (Throwable e) {
            System.out.println(e);
            if (e.getMessage().indexOf("ption") >= 0) {
                System.out.println(e.getMessage() + ": " + options.toLowerCase() + "\n See https://www.inchi-trust.org/download/104/inchi-faq.pdf for valid options");
            } else {
                e.printStackTrace();
            }
            return "";
        }
    }

    private static JniInchiStructure newJniInchiStructureBS(Viewer vwr, BS bsAtoms) {
        JniInchiStructure mol = new JniInchiStructure();
        JniInchiAtom[] atoms = new JniInchiAtom[bsAtoms.cardinality()];
        int[] map = new int[bsAtoms.length()];
        BS bsBonds = vwr.ms.getBondsForSelectedAtoms(bsAtoms, false);
        int pt = 0;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            Atom a = vwr.ms.at[i];
            String sym = a.getElementSymbolIso(false);
            int iso = a.getIsotopeNumber();
            if (a.getElementNumber() == 1) {
                sym = "H";
            }
            atoms[pt] = new JniInchiAtom(a.x, a.y, a.z, sym);
            mol.addAtom(atoms[pt]);
            atoms[pt].setCharge(a.getFormalCharge());
            if (iso > 0) {
                atoms[pt].setIsotopicMass(iso);
            }
            map[i] = pt++;
            i = bsAtoms.nextSetBit(i + 1);
        }
        Bond[] bonds = vwr.ms.bo;
        i = bsBonds.nextSetBit(0);
        while (i >= 0) {
            INCHI_BOND_TYPE order;
            Bond bond = bonds[i];
            if (bond != null && (order = InChIJNI.getOrder(Math.max(bond.isPartial() ? 1 : 0, bond.getCovalentOrder()))) != null) {
                mol.addBond(new JniInchiBond(atoms[map[bond.getAtomIndex1()]], atoms[map[bond.getAtomIndex2()]], order, InChIJNI.getStereo(bond.getBondType())));
            }
            i = bsBonds.nextSetBit(i + 1);
        }
        return mol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JniInchiStructure newJniInchiStructure(Viewer vwr, Object molData) {
        JniInchiStructure mol = new JniInchiStructure();
        Object r = null;
        try {
            if (molData instanceof String) {
                r = new BufferedReader(new StringReader((String)molData));
            } else if (molData instanceof InputStream) {
                r = molData;
            }
            Hashtable<String, Object> htParams = new Hashtable<String, Object>();
            JmolAdapter adapter = vwr.getModelAdapter();
            Object atomSetReader = adapter.getAtomSetCollectionReader("String", null, r, htParams);
            if (atomSetReader instanceof String) {
                System.err.println("InChIJNI could not read molData");
                JniInchiStructure jniInchiStructure = null;
                return jniInchiStructure;
            }
            AtomSetCollection asc = (AtomSetCollection)adapter.getAtomSetCollection(atomSetReader);
            JmolAdapterAtomIterator ai = adapter.getAtomIterator(asc);
            JmolAdapterBondIterator bi = adapter.getBondIterator(asc);
            JniInchiAtom[] atoms = new JniInchiAtom[asc.getAtomSetAtomCount(0)];
            int n = 0;
            Hashtable<Object, Integer> atomMap = new Hashtable<Object, Integer>();
            while (ai.hasNext() && n < atoms.length) {
                P3 p = ai.getXYZ();
                int atno = ai.getElementNumber();
                if (atno <= 0) {
                    System.err.println("InChIJNI atom " + p + " index " + ai.getUniqueID() + " is not a valid element");
                    JniInchiStructure jniInchiStructure = null;
                    return jniInchiStructure;
                }
                String sym = Elements.elementSymbolFromNumber(atno);
                JniInchiAtom a = new JniInchiAtom(p.x, p.y, p.z, sym);
                a.setCharge(ai.getFormalCharge());
                mol.addAtom(a);
                atomMap.put(ai.getUniqueID(), n);
                atoms[n++] = a;
            }
            int nb = 0;
            while (bi.hasNext()) {
                int jmolOrder = bi.getEncodedOrder();
                INCHI_BOND_TYPE order = InChIJNI.getOrder(jmolOrder);
                if (order == null) continue;
                Integer id1 = (Integer)atomMap.get(bi.getAtomUniqueID1());
                Integer id2 = (Integer)atomMap.get(bi.getAtomUniqueID2());
                if (id1 == null || id2 == null) {
                    System.err.println("InChIJNI bond " + nb + "has null atom " + (id1 == null ? bi.getAtomUniqueID1() : "") + " " + (id2 == null ? bi.getAtomUniqueID2() : ""));
                    JniInchiStructure jniInchiStructure = null;
                    return jniInchiStructure;
                }
                JniInchiAtom a = atoms[id1];
                JniInchiAtom b = atoms[id2];
                if (a == null || b == null) {
                    System.err.println("InChIJNI bond " + nb + "has null atom: " + a + "/" + b + " for ids " + id1 + " " + id2 + " and " + n + " atoms");
                    JniInchiStructure jniInchiStructure = null;
                    return jniInchiStructure;
                }
                mol.addBond(new JniInchiBond(a, b, order, InChIJNI.getStereo(jmolOrder)));
                ++nb;
            }
            return mol;
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.err.println(t.toString());
            return mol;
        }
        finally {
            try {
                if (r instanceof BufferedReader) {
                    ((BufferedReader)r).close();
                } else {
                    ((InputStream)r).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static INCHI_BOND_STEREO getStereo(int jmolOrder) {
        switch (jmolOrder) {
            case 1041: {
                return INCHI_BOND_STEREO.SINGLE_1DOWN;
            }
            case 1025: {
                return INCHI_BOND_STEREO.SINGLE_1UP;
            }
            case 1057: {
                return INCHI_BOND_STEREO.SINGLE_1EITHER;
            }
        }
        return INCHI_BOND_STEREO.NONE;
    }

    private static INCHI_BOND_TYPE getOrder(int jmolOrder) {
        switch (jmolOrder) {
            case 1: 
            case 1025: 
            case 1041: 
            case 1057: {
                return INCHI_BOND_TYPE.SINGLE;
            }
            case 2: {
                return INCHI_BOND_TYPE.DOUBLE;
            }
            case 3: {
                return INCHI_BOND_TYPE.TRIPLE;
            }
        }
        return null;
    }

    private static String toJSON(JniInchiStructure mol) {
        int i;
        int na = mol.getNumAtoms();
        int nb = mol.getNumBonds();
        int ns = mol.getNumStereo0D();
        HashMap<JniInchiAtom, Integer> mapAtoms = new HashMap<JniInchiAtom, Integer>();
        String s = "{\"atoms\":[\n";
        for (i = 0; i < na; ++i) {
            JniInchiAtom a = mol.getAtom(i);
            mapAtoms.put(a, i);
            if (i > 0) {
                s = s + ",\n";
            }
            s = s + "{\n";
            s = s + InChIJNI.toJSON("index", i, ",");
            s = s + InChIJNI.toJSON("elementType", a.getElementType(), ",");
            s = s + InChIJNI.toJSON("charge", a.getCharge(), ",");
            s = s + InChIJNI.toJSON("isotopeMass", a.getIsotopicMass(), ",");
            s = s + InChIJNI.toJSON("implicitH", a.getImplicitH(), ",");
            s = s + InChIJNI.toJSON("radical", (Object)a.getRadical(), ",");
            s = s + InChIJNI.toJSON("x", a.getX(), ",");
            s = s + InChIJNI.toJSON("y", a.getY(), ",");
            s = s + InChIJNI.toJSON("z", a.getZ(), ",");
            s = s + InChIJNI.toJSON("implicitDeuterium", a.getImplicitDeuterium(), ",");
            s = s + InChIJNI.toJSON("implicitProtium", a.getImplicitProtium(), ",");
            s = s + InChIJNI.toJSON("implicitTritium", a.getImplicitTritium(), "");
            s = s + "}";
        }
        s = s + "\n],\n\"bonds\":[\n";
        for (i = 0; i < nb; ++i) {
            if (i > 0) {
                s = s + ",\n";
            }
            s = s + "{\n";
            JniInchiBond b = mol.getBond(i);
            s = s + InChIJNI.toJSON("originAtom", mapAtoms.get(b.getOriginAtom()), ",");
            s = s + InChIJNI.toJSON("targetAtom", mapAtoms.get(b.getTargetAtom()), ",");
            s = s + InChIJNI.toJSON("bondType", (Object)b.getBondType(), ",");
            s = s + InChIJNI.toJSON("bondStereo", (Object)b.getBondStereo(), "");
            s = s + "}";
        }
        s = s + "\n],\n\"stereo\":[\n";
        for (i = 0; i < ns; ++i) {
            if (i > 0) {
                s = s + ",\n";
            }
            s = s + "{\n";
            JniInchiStereo0D d = mol.getStereo0D(i);
            s = s + InChIJNI.toJSON("centralAtomID", mapAtoms.get(d.getCentralAtom()), ",");
            s = s + InChIJNI.toJSON("debugString", d.getDebugString(), ",");
            s = s + InChIJNI.toJSON("disconnectedParity", (Object)d.getDisconnectedParity(), ",");
            s = s + InChIJNI.toJSON("parity", (Object)d.getParity(), ",");
            s = s + InChIJNI.toJSON("stereoType", (Object)d.getStereoType(), ",");
            JniInchiAtom[] an = d.getNeighbors();
            int[] nbs = new int[an.length];
            for (int j = 0; j < an.length; ++j) {
                nbs[j] = (Integer)mapAtoms.get(d.getNeighbor(j));
            }
            s = s + InChIJNI.toJSON("neighbors", nbs, "");
            s = s + "}";
        }
        s = s + "\n]}\n";
        return s;
    }

    private static String toJSON(String key, Object val, String term) {
        return PT.toJSON(key, val) + term + "\n";
    }

    private String getSmiles(Viewer vwr, JniInchiOutputStructure struc, String smilesOptions) {
        int i;
        boolean hackImine = smilesOptions.indexOf("imine") >= 0;
        int nAtoms = struc.getNumAtoms();
        int nBonds = struc.getNumBonds();
        int nh = 0;
        for (int i2 = 0; i2 < nAtoms; ++i2) {
            JniInchiAtom a = struc.getAtom(i2);
            nh += a.getImplicitH();
        }
        Lst<SmilesAtom> atoms = new Lst<SmilesAtom>();
        Hashtable<JniInchiAtom, 1> map = new Hashtable<JniInchiAtom, 1>();
        this.mapTet = new Hashtable<BS, int[]>();
        this.mapPlanar = new Hashtable<Integer, Boolean>();
        int nb = 0;
        int na = 0;
        for (i = 0; i < nAtoms; ++i) {
            JniInchiAtom a = struc.getAtom(i);
            SmilesAtom n = new SmilesAtom(){

                @Override
                public boolean definesStereo() {
                    return true;
                }

                @Override
                public String getStereoAtAt(SimpleNode[] nodes) {
                    return InChIJNI.this.decodeInchiStereo(nodes);
                }

                @Override
                public Boolean isStereoOpposite(int i2, int iA, int iB) {
                    return InChIJNI.this.isInchiOpposite(this.getIndex(), i2, iA, iB);
                }
            };
            atoms.addLast(n);
            n.set((float)a.getX(), (float)a.getY(), (float)a.getZ());
            n.setIndex(na++);
            n.setCharge(a.getCharge());
            n.setSymbol(a.getElementType());
            nh = a.getImplicitH();
            for (int j = 0; j < nh; ++j) {
                this.addH(atoms, n, nb++);
                ++na;
            }
            map.put(a, n);
        }
        for (i = 0; i < nBonds; ++i) {
            JniInchiBond b = struc.getBond(i);
            JniInchiAtom a1 = b.getOriginAtom();
            JniInchiAtom a2 = b.getTargetAtom();
            int bt = InChIJNI.getJmolBondType(b);
            SmilesAtom sa1 = (SmilesAtom)map.get(a1);
            SmilesAtom sa2 = (SmilesAtom)map.get(a2);
            SmilesBond sb = new SmilesBond(sa1, sa2, bt, false);
            sb.index = nb++;
        }
        nb = this.checkFormalCharges(atoms, nb, hackImine);
        na = atoms.size();
        Node[] aatoms = new SmilesAtom[na];
        atoms.toArray(aatoms);
        for (int i3 = 0; i3 < na; ++i3) {
            aatoms[i3].setBondArray();
        }
        int iA = -1;
        int iB = -1;
        int i4 = struc.getNumStereo0D();
        block11: while (--i4 >= 0) {
            JniInchiStereo0D sd = struc.getStereo0D(i4);
            JniInchiAtom[] an = sd.getNeighbors();
            if (an.length != 4) continue;
            JniInchiAtom ca = sd.getCentralAtom();
            int i0 = ((SmilesAtom)map.get(an[0])).getIndex();
            int i1 = ((SmilesAtom)map.get(an[1])).getIndex();
            int i2 = ((SmilesAtom)map.get(an[2])).getIndex();
            int i3 = ((SmilesAtom)map.get(an[3])).getIndex();
            boolean isEven = sd.getParity() == INCHI_PARITY.EVEN;
            INCHI_STEREOTYPE type = sd.getStereoType();
            switch (type) {
                case ALLENE: 
                case DOUBLEBOND: {
                    iA = i1;
                    iB = i2;
                    i1 = InChIJNI.getOtherEneAtom((SmilesAtom[])aatoms, i1, i0);
                    i2 = InChIJNI.getOtherEneAtom((SmilesAtom[])aatoms, i2, i3);
                    break;
                }
                case NONE: {
                    continue block11;
                }
            }
            if (ca == null) {
                this.setPlanarKey(i0, i3, iA, iB, isEven);
                this.setPlanarKey(i0, i2, iA, iB, !isEven);
                this.setPlanarKey(i1, i2, iA, iB, isEven);
                this.setPlanarKey(i1, i3, iA, iB, !isEven);
                this.setPlanarKey(i0, i1, iA, iB, Boolean.TRUE);
                this.setPlanarKey(i2, i3, iA, iB, Boolean.TRUE);
                continue;
            }
            int[] list = new int[]{isEven ? i0 : i1, isEven ? i1 : i0, i2, i3};
            this.mapTet.put(InChIJNI.orderList(list), list);
        }
        try {
            SmilesMatcherInterface m = vwr.getSmilesMatcher();
            return m.getSmiles(aatoms, na, BSUtil.newBitSet2(0, na), smilesOptions, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private void setPlanarKey(int i0, int i3, int iA, int iB, Boolean v) {
        this.mapPlanar.put(InChIJNI.getIntKey(i0, iA, i3), v);
        this.mapPlanar.put(InChIJNI.getIntKey(i0, iB, i3), v);
    }

    private SmilesAtom addH(Lst<SmilesAtom> atoms, SmilesAtom n, int nb) {
        SmilesAtom h = new SmilesAtom();
        h.setIndex(atoms.size());
        h.setSymbol("H");
        atoms.addLast(h);
        SmilesBond sb = new SmilesBond(n, h, 1, false);
        sb.index = nb;
        return h;
    }

    private int checkFormalCharges(Lst<SmilesAtom> atoms, int nb, boolean hackImine) {
        int i = atoms.size();
        while (--i >= 0) {
            SmilesAtom a = (SmilesAtom)atoms.get(i);
            int val = a.getValence();
            int nbonds = a.getCovalentBondCount();
            int nbtot = a.getBondCount();
            int ano = a.getElementNumber();
            int formalCharge = a.getCharge();
            SmilesBond b1 = null;
            SmilesBond b2 = null;
            block0 : switch (val * 10 + nbonds) {
                case 32: {
                    if (ano != 7 || !hackImine) break;
                    a.setSymbol("C");
                    a.setAtomicMass(17);
                    SmilesAtom h = this.addH(atoms, a, nb++);
                    h.setAtomicMass(5);
                    break;
                }
                case 53: {
                    if (ano != 7 || formalCharge != 0) break;
                    for (int j = 0; j < nbtot; ++j) {
                        SmilesBond b = a.getBond(j);
                        if (b.getCovalentOrder() != 2) continue;
                        if (b1 == null) {
                            b1 = b;
                            continue;
                        }
                        b2 = b;
                        break block0;
                    }
                    break;
                }
            }
            if (b2 == null) continue;
            SmilesAtom a2 = b2.getOtherAtom(a);
            a2.setCharge(-1);
            a.setCharge(1);
            b2.set2(1, false);
        }
        return nb;
    }

    protected Boolean isInchiOpposite(int i1, int i2, int iA, int iB) {
        Boolean b = this.mapPlanar.get(InChIJNI.getIntKey(i1, Math.max(iA, iB), i2));
        return b;
    }

    protected String decodeInchiStereo(SimpleNode[] nodes) {
        int[] list = new int[]{InChIJNI.getNodeIndex(nodes[0]), InChIJNI.getNodeIndex(nodes[1]), InChIJNI.getNodeIndex(nodes[2]), InChIJNI.getNodeIndex(nodes[3])};
        int[] list2 = this.mapTet.get(InChIJNI.orderList(list));
        return list2 == null ? null : (InChIJNI.isPermutation(list, list2) ? "@@" : "@");
    }

    private static int getNodeIndex(SimpleNode node) {
        return node == null ? -1 : node.getIndex();
    }

    private static Integer getIntKey(int i, int iA, int j) {
        Integer v = (Math.min(i, j) << 24) + (iA << 12) + Math.max(i, j);
        return v;
    }

    private static BS orderList(int[] list) {
        BS bs = new BS();
        for (int i = 0; i < list.length; ++i) {
            bs.set(list[i]);
        }
        return bs;
    }

    private static boolean isPermutation(int[] list, int[] list2) {
        boolean ok = true;
        for (int i = 0; i < 3; ++i) {
            int l1 = list[i];
            for (int j = i + 1; j < 4; ++j) {
                int l2 = list2[j];
                if (l2 != l1 || j == i) continue;
                list2[j] = list2[i];
                list2[i] = l2;
                ok = !ok;
            }
        }
        return ok;
    }

    private static int getOtherEneAtom(SmilesAtom[] atoms, int i0, int i1) {
        SmilesAtom a = atoms[i0];
        int i = a.getBondCount();
        while (--i >= 0) {
            int i2;
            if (a.getBond(i).getBondType() != 1 || (i2 = a.getBondedAtomIndex(i)) == i1) continue;
            return i2;
        }
        return -1;
    }

    private static int getJmolBondType(JniInchiBond b) {
        INCHI_BOND_TYPE type = b.getBondType();
        switch (type) {
            case NONE: {
                return 0;
            }
            case ALTERN: {
                return 515;
            }
            case DOUBLE: {
                return 2;
            }
            case TRIPLE: {
                return 3;
            }
        }
        return 1;
    }
}

