/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery.vectortile.mapbox.style;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.IntFunction;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.InvalidMapboxVectorTileException;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.style.Scheme;
import org.openstreetmap.josm.data.imagery.vectortile.mapbox.style.SourceType;

public class Source {
    private static final String WMS_BBOX = "bbox-epsg-3857";
    private static final String[] NO_URLS = new String[0];
    private static final IntFunction<Integer> ZOOM_BOUND_FUNCTION = new ZoomBoundFunction(0, 30);
    private final String name;
    private final SourceType sourceType;
    private final int minZoom;
    private final int maxZoom;
    private final String[] tileUrls;
    private final String attribution;
    private final Bounds bounds;
    private final String promoteId;
    private final Scheme scheme;
    private final boolean volatileCache;
    private final int tileSize;

    public Source(String name, JsonObject data) {
        Objects.requireNonNull(name, "Name cannot be null");
        Objects.requireNonNull(data, "Data cannot be null");
        this.name = name;
        String type = data.getString("type");
        this.sourceType = SourceType.valueOf(type.replace("-", "_").toUpperCase(Locale.ROOT));
        if (SourceType.VECTOR == this.sourceType || SourceType.RASTER == this.sourceType) {
            if (data.containsKey("url")) {
                throw new InvalidMapboxVectorTileException("TileJson not yet supported");
            }
            this.minZoom = ZOOM_BOUND_FUNCTION.apply(data.getInt("minzoom", 0));
            this.maxZoom = ZOOM_BOUND_FUNCTION.apply(data.getInt("maxzoom", 22));
            this.attribution = data.getString("attribution", null);
            if (data.containsKey("bounds") && ((JsonValue)data.get("bounds")).getValueType() == JsonValue.ValueType.ARRAY) {
                JsonArray bJsonArray = data.getJsonArray("bounds");
                if (bJsonArray.size() != 4) {
                    throw new IllegalArgumentException(MessageFormat.format("bounds must have four values, but has {0}", bJsonArray.size()));
                }
                double[] bArray = new double[bJsonArray.size()];
                for (int i = 0; i < bJsonArray.size(); ++i) {
                    bArray[i] = bJsonArray.getJsonNumber(i).doubleValue();
                }
                this.bounds = new Bounds(bArray[1], bArray[0], bArray[3], bArray[2]);
            } else {
                this.bounds = new Bounds(-85.051129, -180.0, 85.051129, 180.0);
            }
            this.promoteId = data.getString("promoteId", null);
            this.scheme = Scheme.valueOf(data.getString("scheme", "xyz").toUpperCase(Locale.ROOT));
            this.tileUrls = data.containsKey("tiles") && ((JsonValue)data.get("tiles")).getValueType() == JsonValue.ValueType.ARRAY ? (String[])data.getJsonArray("tiles").stream().filter(JsonString.class::isInstance).map(JsonString.class::cast).map(JsonString::getString).map(url -> url.replace(WMS_BBOX, "bbox")).toArray(String[]::new) : NO_URLS;
        } else {
            throw new UnsupportedOperationException();
        }
        this.volatileCache = data.getBoolean("volatile", false);
        this.tileSize = data.getInt("tileSize", 512);
    }

    public Bounds getBounds() {
        return this.bounds;
    }

    public String getName() {
        return this.name;
    }

    public List<String> getUrls() {
        return Collections.unmodifiableList(Arrays.asList(this.tileUrls));
    }

    public int getMinZoom() {
        return this.minZoom;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    public String getAttributionText() {
        return this.attribution;
    }

    public String toString() {
        ArrayList<String> parts = new ArrayList<String>(1 + this.getUrls().size());
        parts.add(this.getName());
        parts.addAll(this.getUrls());
        return String.join((CharSequence)" ", parts);
    }

    public boolean equals(Object other) {
        if (other != null && this.getClass() == other.getClass()) {
            Source o = (Source)other;
            return Objects.equals(this.name, o.name) && this.sourceType == o.sourceType && this.minZoom == o.minZoom && this.maxZoom == o.maxZoom && Objects.equals(this.attribution, o.attribution) && Objects.equals(this.promoteId, o.promoteId) && this.scheme == o.scheme && this.volatileCache == o.volatileCache && this.tileSize == o.tileSize && Objects.equals(this.bounds, o.bounds) && Objects.deepEquals(this.tileUrls, o.tileUrls);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.sourceType, this.minZoom, this.maxZoom, this.attribution, this.promoteId, this.scheme, this.volatileCache, this.tileSize, this.bounds, Arrays.hashCode(this.tileUrls)});
    }

    private static class ZoomBoundFunction
    implements IntFunction<Integer> {
        private final int min;
        private final int max;

        ZoomBoundFunction(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public Integer apply(int value) {
            return Math.max(this.min, Math.min(value, this.max));
        }
    }
}

