/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.oauth;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonReader;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.openstreetmap.josm.data.oauth.IOAuthParameters;
import org.openstreetmap.josm.data.oauth.OAuthVersion;
import org.openstreetmap.josm.spi.preferences.Config;

public final class OAuth20Parameters
implements IOAuthParameters {
    private static final String REDIRECT_URI = "redirect_uri";
    private static final String CLIENT_ID = "client_id";
    private static final String CLIENT_SECRET = "client_secret";
    private static final String TOKEN_URL = "token_url";
    private static final String AUTHORIZE_URL = "authorize_url";
    private static final String API_URL = "api_url";
    private final String redirectUri;
    private final String clientSecret;
    private final String clientId;
    private final String tokenUrl;
    private final String authorizeUrl;
    private final String apiUrl;

    public OAuth20Parameters(String jsonString) {
        try (ByteArrayInputStream bais = new ByteArrayInputStream(jsonString.getBytes(StandardCharsets.UTF_8));
             JsonReader reader = Json.createReader(bais);){
            JsonStructure structure = reader.read();
            if (structure.getValueType() != JsonValue.ValueType.OBJECT) {
                throw new IllegalArgumentException("Invalid JSON object: " + jsonString);
            }
            JsonObject jsonObject = structure.asJsonObject();
            this.redirectUri = jsonObject.getString(REDIRECT_URI);
            this.clientId = jsonObject.getString(CLIENT_ID);
            this.clientSecret = jsonObject.getString(CLIENT_SECRET, null);
            this.tokenUrl = jsonObject.getString(TOKEN_URL);
            this.authorizeUrl = jsonObject.getString(AUTHORIZE_URL);
            this.apiUrl = jsonObject.getString(API_URL);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public OAuth20Parameters(String clientId, String clientSecret, String baseUrl, String apiUrl, String redirectUri) {
        this(clientId, clientSecret, baseUrl + "/token", baseUrl + "/authorize", apiUrl, redirectUri);
    }

    public OAuth20Parameters(String clientId, String clientSecret, String tokenUrl, String authorizeUrl, String apiUrl, String redirectUri) {
        Objects.requireNonNull(authorizeUrl, "authorizeUrl");
        Objects.requireNonNull(clientId, "clientId");
        Objects.requireNonNull(redirectUri, "redirectUri");
        Objects.requireNonNull(tokenUrl, "tokenUrl");
        Objects.requireNonNull(apiUrl, "apiUrl");
        this.redirectUri = redirectUri;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.tokenUrl = tokenUrl;
        this.authorizeUrl = authorizeUrl;
        this.apiUrl = apiUrl;
    }

    @Override
    public String getAccessTokenUrl() {
        return this.tokenUrl;
    }

    @Override
    public String getAuthorizationUrl() {
        return this.authorizeUrl;
    }

    @Override
    public OAuthVersion getOAuthVersion() {
        return OAuthVersion.OAuth20;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Override
    public String getApiUrl() {
        return this.apiUrl;
    }

    @Override
    public void rememberPreferences() {
        Config.getPref().put("oauth.access-token.parameters." + OAuthVersion.OAuth20 + "." + this.apiUrl, this.toPreferencesString());
    }

    @Override
    public String toPreferencesString() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add(CLIENT_ID, this.clientId);
        builder.add(REDIRECT_URI, this.redirectUri);
        if (this.apiUrl != null) {
            builder.add(API_URL, this.apiUrl);
        }
        if (this.authorizeUrl != null) {
            builder.add(AUTHORIZE_URL, this.authorizeUrl);
        }
        if (this.clientSecret != null) {
            builder.add(CLIENT_SECRET, this.clientSecret);
        }
        if (this.tokenUrl != null) {
            builder.add(TOKEN_URL, this.tokenUrl);
        }
        return builder.build().toString();
    }

    public int hashCode() {
        return Objects.hash(this.apiUrl, this.authorizeUrl, this.tokenUrl, this.clientId, this.clientSecret, this.redirectUri);
    }

    public boolean equals(Object obj) {
        if (obj != null && this.getClass() == obj.getClass()) {
            OAuth20Parameters other = (OAuth20Parameters)obj;
            return Objects.equals(this.clientSecret, other.clientSecret) && Objects.equals(this.clientId, other.clientId) && Objects.equals(this.redirectUri, other.redirectUri) && Objects.equals(this.tokenUrl, other.tokenUrl) && Objects.equals(this.authorizeUrl, other.authorizeUrl) && Objects.equals(this.apiUrl, other.apiUrl);
        }
        return false;
    }
}

