/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.URL;
import java.util.stream.Collectors;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.LanguageInfo;

public class WikiReader {
    private final String baseurl;

    public WikiReader(String baseurl) {
        this.baseurl = baseurl;
    }

    public WikiReader() {
        this(Config.getPref().get("help.baseurl", Config.getUrls().getJOSMWebsite()));
    }

    public final String getBaseUrlWiki() {
        return this.baseurl + "/wiki/";
    }

    public String read(String url) throws IOException {
        URL u = new URL(url);
        try (BufferedReader in = HttpClient.create(u).connect().getContentReader();){
            boolean txt = url.endsWith("?format=txt");
            if (url.startsWith(this.getBaseUrlWiki()) && !txt) {
                String string = this.readFromTrac(in, u);
                return string;
            }
            String string = WikiReader.readNormal(in, !txt);
            return string;
        }
    }

    public String readLang(String text) throws IOException {
        String res = "";
        String languageCode = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.DEFAULTNOTENGLISH);
        if (languageCode != null) {
            res = this.readLang(new URL(this.getBaseUrlWiki() + languageCode + text));
        }
        if (res.isEmpty() && (languageCode = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.BASELANGUAGE)) != null) {
            res = this.readLang(new URL(this.getBaseUrlWiki() + languageCode + text));
        }
        if (res.isEmpty() && (languageCode = LanguageInfo.getWikiLanguagePrefix(LanguageInfo.LocaleType.ENGLISH)) != null) {
            res = this.readLang(new URL(this.getBaseUrlWiki() + languageCode + text));
        }
        if (res.isEmpty()) {
            throw new IOException(text + " does not exist");
        }
        return res;
    }

    private String readLang(URL url) throws IOException {
        try (BufferedReader in = HttpClient.create(url).connect().getContentReader();){
            String string = this.readFromTrac(in, url);
            return string;
        }
    }

    private static String readNormal(BufferedReader in, boolean html) {
        String string = in.lines().filter(line -> !line.contains("[[TranslatedPages]]")).map(line -> line.replace(" />", ">") + "\n").collect(Collectors.joining());
        return html ? "<html>" + string + "</html>" : string;
    }

    protected String readFromTrac(BufferedReader in, URL url) throws IOException {
        boolean inside = false;
        boolean transl = false;
        boolean skip = false;
        StringBuilder b = new StringBuilder();
        StringBuilder full = new StringBuilder();
        String line = in.readLine();
        while (line != null) {
            full.append(line);
            if (line.contains("<div id=\"searchable\">")) {
                inside = true;
            } else if (line.contains("<div class=\"wiki-toc trac-nav\"")) {
                transl = true;
            } else if (line.contains("<div class=\"wikipage searchable\">")) {
                inside = true;
            } else if (line.contains("<div class=\"buttons\">")) {
                inside = false;
            } else if (line.contains("<h3>Attachments</h3>")) {
                inside = false;
            } else if (line.contains("<div id=\"attachments\">")) {
                inside = false;
            } else if (line.contains("<div class=\"trac-modifiedby\">")) {
                skip = true;
            }
            if (inside && !transl && !skip) {
                b.append(line.replace("<img ", "<img border=\"0\" ").replaceAll("width=\"(\\d+)\"", "").replaceAll("<span class=\"icon\">.</span>", "").replace("href=\"/", "href=\"" + this.baseurl + "/").replace(" />", ">")).append('\n');
            } else if (transl && line.contains("</div>")) {
                transl = false;
            }
            if (line.contains("</div>")) {
                skip = false;
            }
            line = in.readLine();
        }
        if (b.indexOf("      Describe ") >= 0 || b.indexOf(" does not exist. You can create it here.") >= 0) {
            return "";
        }
        if (b.length() == 0) {
            b = full;
        }
        return "<html><base href=\"" + url.toExternalForm() + "\"> " + b + "</html>";
    }
}

