/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kea extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bn = "bengali";
        final String metaValue_bo = "tibetanu";
        final String metaValue_el = "gregu";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebraiku";
        final String metaValue_hy = "arm\u00e9niu";
        final String metaValue_ja = "japones";
        final String metaValue_ka = "jorjianu";
        final String metaValue_km = "kmer";
        final String metaValue_kn = "kanares";
        final String metaValue_ko = "korianu";
        final String metaValue_lo = "lausianu";
        final String metaValue_ml = "malaialam";
        final String metaValue_my = "birmanes";
        final String metaValue_si = "singales";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailandes";
        final Object[][] data = new Object[][] {
            { "Zsym", "s\u00edmbulus" },
            { "fil", "filipinu" },
            { "es_ES", "spanhol europeu" },
            { "ab", "abk\u00e1ziu" },
            { "AC", "Ilha di Asens\u00e3u" },
            { "AD", "Andora" },
            { "AE", "Emiradus \u00c1rabi Unidu" },
            { "nl_BE", "flamengu" },
            { "AF", "Afeganist\u00e3u" },
            { "af", "afrikaner" },
            { "AG", "Antigua i Barbuda" },
            { "AI", "Angila" },
            { "ak", "akan" },
            { "AL", "Alb\u00e1nia" },
            { "AM", "Arm\u00e9nia" },
            { "am", "am\u00e1riku" },
            { "Arab", "ar\u00e1biku" },
            { "AO", "Angola" },
            { "Jpan", metaValue_ja },
            { "AQ", "Ant\u00e1rtika" },
            { "AR", "Arjentina" },
            { "ar", "\u00e1rabi" },
            { "AS", "Samoa Merkanu" },
            { "as", "asames" },
            { "AT", "\u00c1ustria" },
            { "AU", "Austr\u00e1lia" },
            { "AW", "Aruba" },
            { "en_US", "ingles merkanu" },
            { "AX", "Ilhas \u00c5land" },
            { "ay", "aimara" },
            { "AZ", "Azerbaij\u00e3u" },
            { "az", "azerbaijanu" },
            { "BA", "B\u00f3snia i Erzegovina" },
            { "ba", "baxkir" },
            { "BB", "Barbadus" },
            { "BD", "Bangladexi" },
            { "BE", "B\u00e9ljika" },
            { "be", "bielorusu" },
            { "BF", "Burkina Fasu" },
            { "BG", "Bulg\u00e1ria" },
            { "bg", "b\u00falgaru" },
            { "BH", "Barain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "S\u00e3u Bartolomeu" },
            { "BM", "Bermudas" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "BN", "Brunei" },
            { "bo", metaValue_bo },
            { "BO", "Bol\u00edvia" },
            { "BQ", "Karaibas Olandezas" },
            { "BR", "Brazil" },
            { "br", "bret\u00e3u" },
            { "BS", "Baamas" },
            { "bs", "bosniu" },
            { "BT", "But\u00e3u" },
            { "BV", "Ilha Buve" },
            { "Mymr", metaValue_my },
            { "BW", "Botsuana" },
            { "BY", "Belarus" },
            { "BZ", "Belizi" },
            { "CA", "Kanad\u00e1" },
            { "ca", "katal\u00e3u" },
            { "CC", "Ilhas Kokus (Keeling)" },
            { "ses", "koiraboro seni" },
            { "CD", "Kongu - Kinxasa" },
            { "ce", "txetxenu" },
            { "CF", "Republika Sentru-Afrikanu" },
            { "CG", "Kongu - Brazavili" },
            { "CH", "Suisa" },
            { "CI", "Kosta di Marfin" },
            { "CK", "Ilhas Kuk" },
            { "CL", "Xili" },
            { "CM", "Kamar\u00f5is" },
            { "CN", "Xina" },
            { "CO", "Kol\u00f4mbia" },
            { "co", "k\u00f3rsiku" },
            { "CP", "Ilha Kliperton" },
            { "Orya", "oriya" },
            { "CR", "Kosta Rika" },
            { "cs", "txeku" },
            { "CU", "Kuba" },
            { "CV", "Kabu Verdi" },
            { "cv", "txuvaxi" },
            { "CW", "Kurasau" },
            { "CX", "Ilha di Natal" },
            { "CY", "Xipri" },
            { "cy", "gales" },
            { "CZ", "Tx\u00e9kia" },
            { "da", "dinamarkes" },
            { "pt_PT", "purtuges europeu" },
            { "DE", "Alimanha" },
            { "de", "alim\u00e3u" },
            { "cgg", "xiga" },
            { "DG", "Diegu Garsia" },
            { "DJ", "Djibuti" },
            { "DK", "Dinamarka" },
            { "Brai", "braille" },
            { "DM", "Dominika" },
            { "DO", "Rep\u00fablika Dominikana" },
            { "bem", "bemba" },
            { "es_419", "spanhol latinu-merkanu" },
            { "DZ", "Arj\u00e9lia" },
            { "dz", "dzonka" },
            { "bez", "bena" },
            { "EA", "Seuta i Melilha" },
            { "EC", "Ekuador" },
            { "dje", "zarma" },
            { "EE", "St\u00f3nia" },
            { "ee", "eve" },
            { "EG", "Ejitu" },
            { "EH", "Sara Osidental" },
            { "ro_MD", "rumenu mold\u00e1viku" },
            { "el", metaValue_el },
            { "en", "ingles" },
            { "eo", "sperantu" },
            { "chr", "xeroki" },
            { "ER", "Iritreia" },
            { "ES", "Spanha" },
            { "es", "spanhol" },
            { "ET", "Eti\u00f3pia" },
            { "et", "stonianu" },
            { "EU", "Uni\u00e3u Europeia" },
            { "eu", "basku" },
            { "Hang", "hangul" },
            { "type.ca.gregorian", "Kalend\u00e1riu Gregorianu" },
            { "hsb", "s\u00f3rbiu altu" },
            { "Hani", "han" },
            { "fa", "persa" },
            { "Hans", "simplifikadu" },
            { "type.nu.latn", "N\u00famerus Ar\u00e1bikus" },
            { "Hant", "tradisional" },
            { "FI", "Finl\u00e1ndia" },
            { "fi", "finlandes" },
            { "FJ", "Fidji" },
            { "fj", "fijianu" },
            { "FK", "Ilhas Malvinas" },
            { "FM", "Mikron\u00e9zia" },
            { "FO", "Ilhas Faroe" },
            { "fo", "faroes" },
            { "Taml", metaValue_ta },
            { "FR", "Fransa" },
            { "fr", "franses" },
            { "fy", "fr\u00edziu osidental" },
            { "GA", "Gab\u00e3u" },
            { "ga", "irlandes" },
            { "GB", "Reinu Unidu" },
            { "GD", "Granada" },
            { "GE", "Ji\u00f3rjia" },
            { "GF", "Giana Franseza" },
            { "GG", "Gernzi" },
            { "GH", "Gana" },
            { "GI", "Jibraltar" },
            { "GL", "Gronel\u00e1ndia" },
            { "gl", "galegu" },
            { "GM", "G\u00e1mbia" },
            { "GN", "Gine" },
            { "gn", "guarani" },
            { "GP", "Guadalupi" },
            { "GQ", "Gine Ekuatorial" },
            { "und", "l\u00edngua diskonxedu" },
            { "GR", "Gr\u00e9sia" },
            { "GS", "Ilhas Je\u00f3rjia di Sul i Sanduixi di Sul" },
            { "GT", "Guatimala" },
            { "gu", metaValue_gu },
            { "GU", "Guam" },
            { "gv", "manks" },
            { "GW", "Gine-Bisau" },
            { "GY", "Giana" },
            { "ha", "auza" },
            { "ckb", "kurdu sentral" },
            { "zxx", "sen kontiudu lingu\u00edstiku" },
            { "he", metaValue_he },
            { "hi", "indi" },
            { "de_AT", "alim\u00e3u austriaku" },
            { "HK", "Reji\u00e3u Administrativu Spesial di Hong Kong" },
            { "HM", "Ilhas Heard i McDonald" },
            { "HN", "Onduras" },
            { "HR", "Kro\u00e1sia" },
            { "hr", "kroata" },
            { "agq", "aghem" },
            { "gsw", "alim\u00e3u su\u00edsu" },
            { "HT", "Ait\u00ed" },
            { "ht", "aitianu" },
            { "HU", "Ungria" },
            { "hu", "\u00fangaru" },
            { "hy", metaValue_hy },
            { "IC", "Kan\u00e1rias" },
            { "ID", "Indon\u00e9zia" },
            { "id", "indon\u00e9ziu" },
            { "IE", "Irlanda" },
            { "ig", "ibo" },
            { "ii", "nuosu" },
            { "IL", "Israel" },
            { "IM", "Ilha di Man" },
            { "IN", "\u00cdndia" },
            { "IO", "Ilhas Brit\u00e1nikas di \u00cdndiku" },
            { "IQ", "Iraki" },
            { "IR", "Ir\u00e3u" },
            { "IS", "Isl\u00e1ndia" },
            { "is", "islandes" },
            { "IT", "It\u00e1lia" },
            { "it", "italianu" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "JE", "Jersi" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "JO", "Jord\u00e1nia" },
            { "JP", "Jap\u00e3u" },
            { "jv", "javanes" },
            { "guz", "gusii" },
            { "de_CH", "altu alim\u00e3u suisu" },
            { "smn", "inari sami" },
            { "ka", metaValue_ka },
            { "KE", "K\u00e9nia" },
            { "419", "Merka Latinu" },
            { "KG", "Kirgist\u00e3u" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "ki", "kikuiu" },
            { "kk", "kazak" },
            { "kl", "groenlandes" },
            { "km", metaValue_km },
            { "KM", "Kamoris" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "S\u00e3u Kristov\u00e3u i Nevis" },
            { "fr_CA", "franses kanadianu" },
            { "ko", metaValue_ko },
            { "KP", "Koreia di Norti" },
            { "KR", "Koreia di Sul" },
            { "ks", "kaxmira" },
            { "ku", "kurdu" },
            { "fr_CH", "franses suisu" },
            { "KW", "Kueiti" },
            { "kw", "k\u00f3rniku" },
            { "KY", "Ilhas Kaim\u00e3u" },
            { "ky", "kirgiz" },
            { "KZ", "Kazakist\u00e3u" },
            { "Cyrl", "sir\u00edliku" },
            { "LA", "Laus" },
            { "la", "latin" },
            { "LB", "L\u00edbanu" },
            { "lb", "luxemburges" },
            { "LC", "Santa L\u00fasia" },
            { "lg", "luganda" },
            { "LI", "Lixenstain" },
            { "LK", "Sri Lanka" },
            { "Tibt", metaValue_bo },
            { "lo", metaValue_lo },
            { "LR", "Lib\u00e9ria" },
            { "LS", "Lezotu" },
            { "LT", "Litu\u00e1nia" },
            { "lt", "lituanes" },
            { "LU", "Luxemburgu" },
            { "LV", "Let\u00f3nia" },
            { "lv", "let\u00e3u" },
            { "Kana", "katakana" },
            { "LY", "L\u00edbia" },
            { "Thaa", "taana" },
            { "MA", "Marokus" },
            { "MC", "M\u00f3naku" },
            { "MD", "Mold\u00e1via" },
            { "ME", "Montenegru" },
            { "MF", "S\u00e3u Martinhu di Fransa" },
            { "MG", "Madagaskar" },
            { "mg", "malgaxi" },
            { "Thai", metaValue_th },
            { "MH", "Ilhas Marxal" },
            { "mi", "maori" },
            { "MK", "Masid\u00f3nia" },
            { "mk", "mased\u00f3niu" },
            { "ml", metaValue_ml },
            { "ML", "Mali" },
            { "MM", "Mianmar (Birm\u00e1nia)" },
            { "MN", "Mong\u00f3lia" },
            { "MO", "Reji\u00e3u Administrativu Spesial di Makau" },
            { "MP", "Ilhas Marianas di Norti" },
            { "MQ", "Martinika" },
            { "MR", "Maurit\u00e1nia" },
            { "mr", "marati" },
            { "MS", "Monserat" },
            { "ms", "mal\u00e1iu" },
            { "MT", "Malta" },
            { "mt", "maltes" },
            { "MU", "Maur\u00edsia" },
            { "MV", "Maldivas" },
            { "MW", "Malaui" },
            { "MX", "M\u00e9xiku" },
            { "my", metaValue_my },
            { "MY", "Mal\u00e1zia" },
            { "Armn", metaValue_hy },
            { "MZ", "Musambiki" },
            { "dsb", "s\u00f3rbiu baxu" },
            { "NA", "Nam\u00edbia" },
            { "nb", "norueges bokm\u00e5l" },
            { "NC", "Nova Kalid\u00f3nia" },
            { "NE", "Nijer" },
            { "ne", "nepales" },
            { "NF", "Ilhas Norfolk" },
            { "NG", "Nij\u00e9ria" },
            { "NI", "Nikar\u00e1gua" },
            { "NL", "Olanda" },
            { "nl", "olandes" },
            { "nn", "norueges nynorsk" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zil\u00e1ndia" },
            { "kab", "kabila" },
            { "kam", "kamba" },
            { "OM", "Oman" },
            { "om", "oromo" },
            { "or", "od\u00eda" },
            { "PA", "Panam\u00e1" },
            { "pa", "pandjabi" },
            { "dua", "duala" },
            { "en_GB", "ingles britaniku" },
            { "PE", "Peru" },
            { "PF", "Polin\u00e9zia Franseza" },
            { "PG", "Papua-Nova Gine" },
            { "PH", "Filipinas" },
            { "PK", "Pakist\u00e3u" },
            { "PL", "Pul\u00f3nia" },
            { "pl", "pulaku" },
            { "PM", "San Piere i Mikelon" },
            { "PN", "Pirkairn" },
            { "PR", "Portu Riku" },
            { "PS", "Palistina" },
            { "ps", "paxto" },
            { "PT", "Purtugal" },
            { "pt", "purtuges" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "pt_BR", "purtuges brazileru" },
            { "Hebr", metaValue_he },
            { "QA", "Katar" },
            { "key.ca", "Kalend\u00e1riu" },
            { "Laoo", metaValue_lo },
            { "QO", "Ilhas di Oseania" },
            { "qu", "kexua" },
            { "brx", "bodo" },
            { "001", "Mundu" },
            { "Ethi", "eti\u00f3piku" },
            { "002", "\u00c1frika" },
            { "003", "Merka di Norti" },
            { "RE", "Runi\u00e3u" },
            { "005", "Merka di Sul" },
            { "009", "Oseania" },
            { "rm", "romanxi" },
            { "RO", "Rum\u00e9nia" },
            { "ro", "rumenu" },
            { "RS", "S\u00e9rvia" },
            { "RU", "R\u00fasia" },
            { "ru", "rusu" },
            { "RW", "Ruanda" },
            { "rw", "kiniaruanda" },
            { "kea", "kabuverdianu" },
            { "en_AU", "ingles australianu" },
            { "SA", "Ar\u00e1bia Saudita" },
            { "sa", "s\u00e1nskritu" },
            { "SB", "Ilhas Salum\u00e3u" },
            { "011", "\u00c1frika Osidental" },
            { "SC", "Seixelis" },
            { "SD", "Sud\u00e3u" },
            { "sd", "sindi" },
            { "013", "Merka Sentral" },
            { "SE", "Su\u00e9sia" },
            { "014", "\u00c1frika Oriental" },
            { "015", "Norti di \u00c1frika" },
            { "SG", "Singapura" },
            { "SH", "Santa Ilena" },
            { "si", metaValue_si },
            { "017", "\u00c1frika Sentral" },
            { "SI", "Slov\u00e9nia" },
            { "018", "Sul di \u00c1frika" },
            { "SJ", "Svalbard i Jan Maien" },
            { "019", "Merkas" },
            { "SK", "Slov\u00e1kia" },
            { "sk", "slovaku" },
            { "SL", "Sera Lioa" },
            { "sl", "slov\u00e9niu" },
            { "SM", "San Marinu" },
            { "SN", "Senegal" },
            { "SO", "Sum\u00e1lia" },
            { "so", "somali" },
            { "arn", "araukanu" },
            { "sq", "albanes" },
            { "SR", "Surinami" },
            { "sr", "s\u00e9rviu" },
            { "SS", "Sud\u00e3u di Sul" },
            { "ST", "S\u00e3u Tume i Pr\u00ednsipi" },
            { "su", "sundanes" },
            { "SV", "El Salvador" },
            { "sv", "sueku" },
            { "sw", "sua\u00edli" },
            { "SX", "S\u00e3u Martinhu di Olanda" },
            { "SY", "S\u00edria" },
            { "SZ", "Suazil\u00e1ndia" },
            { "ta", metaValue_ta },
            { "TA", "Tristan da Kunha" },
            { "asa", "asu" },
            { "021", "Norti di Merka" },
            { "142", "\u00c1zia" },
            { "TC", "Ilhas Turkas i Kaikus" },
            { "143", "\u00c1zia Sentral" },
            { "TD", "Txadi" },
            { "te", metaValue_te },
            { "145", "\u00c1zia Osidental" },
            { "TF", "Terras Franses di Sul" },
            { "TG", "Togu" },
            { "tg", "tadjiki" },
            { "th", metaValue_th },
            { "TH", "Tail\u00e1ndia" },
            { "ti", "tigrinia" },
            { "TJ", "Tadjikist\u00e3u" },
            { "en_CA", "ingles kanadianu" },
            { "029", "Karaibas" },
            { "TK", "Tokelau" },
            { "tk", "turkmenu" },
            { "TL", "Timor Lesti" },
            { "TM", "Turkumenist\u00e3u" },
            { "TN", "Tun\u00edzia" },
            { "TO", "Tonga" },
            { "to", "tonganes" },
            { "dyo", "jola-fonyi" },
            { "TR", "Turkia" },
            { "tr", "turku" },
            { "TT", "Trinidad i Tobagu" },
            { "tt", "tatar" },
            { "TV", "Tuvalu" },
            { "TW", "Taiuan" },
            { "TZ", "Tanz\u00e1nia" },
            { "nmg", "kuazio" },
            { "Zzzz", "skrita diskonxedu" },
            { "150", "Europa" },
            { "UA", "Ukr\u00e1nia" },
            { "030", "\u00c1zia Oriental" },
            { "151", "Europa Oriental" },
            { "154", "Europa di Norti" },
            { "sw_CD", "sua\u00edli kongoles" },
            { "034", "Sul di \u00c1zia" },
            { "155", "Europa Osidental" },
            { "035", "Sudesti Azi\u00e1tiku" },
            { "UG", "Uganda" },
            { "ug", "uigur" },
            { "Kore", metaValue_ko },
            { "Zyyy", "komun" },
            { "039", "Europa di Sul" },
            { "uk", "ukranianu" },
            { "Sinh", metaValue_si },
            { "UM", "Ilhas Minoris Distantis de Stadus Unidus" },
            { "ur", "urdu" },
            { "US", "Stadus Unidos di Merka" },
            { "haw", "avaianu" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbekist\u00e3u" },
            { "uz", "uzbeki" },
            { "tzm", "tamazait di Atlas Sentral" },
            { "VA", "Vatikanu" },
            { "VC", "S\u00e3u Bisenti i Granadinas" },
            { "VE", "Vinizuela" },
            { "VG", "Ilhas Virjens Brit\u00e1nikas" },
            { "VI", "Ilhas Virjens Merkanas" },
            { "vi", "vietnamita" },
            { "khq", "koira txiini" },
            { "VN", "Vietnam" },
            { "quc", "kitxe" },
            { "VU", "Vanuatu" },
            { "gag", "gagauz" },
            { "053", "Austral\u00e1zia" },
            { "054", "Melan\u00e9zia" },
            { "WF", "Ualis i Futuna" },
            { "Grek", metaValue_el },
            { "057", "Reji\u00e3u di Mikron\u00e9zia" },
            { "jgo", "\u00f1omba" },
            { "wo", "uolof" },
            { "ar_001", "\u00e1rabi mudernu" },
            { "WS", "Samoa" },
            { "Mong", "mongol" },
            { "061", "Polin\u00e9zia" },
            { "Latn", "latinu" },
            { "xh", "koza" },
            { "XK", "Kozovu" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "n\u00e3u skritu" },
            { "YE", "I\u00e9men" },
            { "yo", "ioruba" },
            { "es_MX", "spanhol mexikanu" },
            { "YT", "Maiote" },
            { "ZA", "\u00c1frika di Sul" },
            { "kln", "kalenjin" },
            { "Deva", "devanagari" },
            { "zh", "xines" },
            { "Hira", "iragana" },
            { "ZM", "Z\u00e1mbia" },
            { "Bopo", "bopomofo" },
            { "zu", "zulu" },
            { "ZW", "Zimb\u00e1bui" },
            { "Geor", metaValue_ka },
            { "ZZ", "Reji\u00e3u Diskonxedu" },
            { "ebu", "embu" },
            { "jmc", "matxame" },
            { "zh_Hans", "xines simplifikadu" },
            { "koi", "komi-permiak" },
            { "kok", "konkani" },
            { "dav", "taita" },
            { "zh_Hant", "xines tradisional" },
            { "Khmr", metaValue_km },
            { "Guru", "gurmuki" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
