/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.HitQueue;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.util.BitSet;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.knn.common.FieldInfoExtractor;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.query.KNNQuery;
import org.opensearch.knn.index.query.SegmentLevelQuantizationInfo;
import org.opensearch.knn.index.query.SegmentLevelQuantizationUtil;
import org.opensearch.knn.index.query.filtered.FilteredIdsKNNByteIterator;
import org.opensearch.knn.index.query.filtered.FilteredIdsKNNIterator;
import org.opensearch.knn.index.query.filtered.KNNIterator;
import org.opensearch.knn.index.query.filtered.NestedFilteredIdsKNNByteIterator;
import org.opensearch.knn.index.query.filtered.NestedFilteredIdsKNNIterator;
import org.opensearch.knn.index.vectorvalues.KNNBinaryVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNFloatVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.index.vectorvalues.KNNVectorValuesFactory;
import org.opensearch.knn.indices.ModelDao;

public class ExactSearcher {
    @Generated
    private static final Logger log = LogManager.getLogger(ExactSearcher.class);
    private final ModelDao modelDao;

    public Map<Integer, Float> searchLeaf(LeafReaderContext leafReaderContext, ExactSearcherContext exactSearcherContext) throws IOException {
        KNNIterator iterator = this.getMatchedKNNIterator(leafReaderContext, exactSearcherContext);
        if (exactSearcherContext.getMatchedDocs().cardinality() <= exactSearcherContext.getK()) {
            return this.scoreAllDocs(iterator);
        }
        return this.searchTopK(iterator, exactSearcherContext.getK());
    }

    private Map<Integer, Float> scoreAllDocs(KNNIterator iterator) throws IOException {
        int docId;
        HashMap<Integer, Float> docToScore = new HashMap<Integer, Float>();
        while ((docId = iterator.nextDoc()) != Integer.MAX_VALUE) {
            docToScore.put(docId, Float.valueOf(iterator.score()));
        }
        return docToScore;
    }

    private Map<Integer, Float> searchTopK(KNNIterator iterator, int k) throws IOException {
        int docId;
        HitQueue queue = new HitQueue(k, true);
        ScoreDoc topDoc = (ScoreDoc)queue.top();
        HashMap<Integer, Float> docToScore = new HashMap<Integer, Float>();
        while ((docId = iterator.nextDoc()) != Integer.MAX_VALUE) {
            if (!(iterator.score() > topDoc.score)) continue;
            topDoc.score = iterator.score();
            topDoc.doc = docId;
            topDoc = (ScoreDoc)queue.updateTop();
        }
        while (queue.size() > 0 && ((ScoreDoc)queue.top()).score < 0.0f) {
            queue.pop();
        }
        while (queue.size() > 0) {
            ScoreDoc doc = (ScoreDoc)queue.pop();
            docToScore.put(doc.doc, Float.valueOf(doc.score));
        }
        return docToScore;
    }

    private KNNIterator getMatchedKNNIterator(LeafReaderContext leafReaderContext, ExactSearcherContext exactSearcherContext) throws IOException {
        byte[] quantizedQueryVector;
        SegmentLevelQuantizationInfo segmentLevelQuantizationInfo;
        boolean isNestedRequired;
        KNNQuery knnQuery = exactSearcherContext.getKnnQuery();
        BitSet matchedDocs = exactSearcherContext.getMatchedDocs();
        SegmentReader reader = Lucene.segmentReader((LeafReader)leafReaderContext.reader());
        FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(knnQuery.getField());
        SpaceType spaceType = FieldInfoExtractor.getSpaceType(this.modelDao, fieldInfo);
        boolean bl = isNestedRequired = exactSearcherContext.isParentHits() && knnQuery.getParentsFilter() != null;
        if (VectorDataType.BINARY == knnQuery.getVectorDataType() && isNestedRequired) {
            KNNVectorValues vectorValues = KNNVectorValuesFactory.getVectorValues(fieldInfo, (LeafReader)reader);
            return new NestedFilteredIdsKNNByteIterator(matchedDocs, knnQuery.getByteQueryVector(), (KNNBinaryVectorValues)vectorValues, spaceType, knnQuery.getParentsFilter().getBitSet(leafReaderContext));
        }
        if (VectorDataType.BINARY == knnQuery.getVectorDataType()) {
            KNNVectorValues vectorValues = KNNVectorValuesFactory.getVectorValues(fieldInfo, (LeafReader)reader);
            return new FilteredIdsKNNByteIterator(matchedDocs, knnQuery.getByteQueryVector(), (KNNBinaryVectorValues)vectorValues, spaceType);
        }
        if (exactSearcherContext.isUseQuantizedVectorsForSearch()) {
            segmentLevelQuantizationInfo = SegmentLevelQuantizationInfo.build((LeafReader)reader, fieldInfo, knnQuery.getField());
            quantizedQueryVector = SegmentLevelQuantizationUtil.quantizeVector(knnQuery.getQueryVector(), segmentLevelQuantizationInfo);
        } else {
            segmentLevelQuantizationInfo = null;
            quantizedQueryVector = null;
        }
        KNNVectorValues vectorValues = KNNVectorValuesFactory.getVectorValues(fieldInfo, (LeafReader)reader);
        if (isNestedRequired) {
            return new NestedFilteredIdsKNNIterator(matchedDocs, knnQuery.getQueryVector(), (KNNFloatVectorValues)vectorValues, spaceType, knnQuery.getParentsFilter().getBitSet(leafReaderContext), quantizedQueryVector, segmentLevelQuantizationInfo);
        }
        return new FilteredIdsKNNIterator(matchedDocs, knnQuery.getQueryVector(), (KNNFloatVectorValues)vectorValues, spaceType, quantizedQueryVector, segmentLevelQuantizationInfo);
    }

    @Generated
    public ExactSearcher(ModelDao modelDao) {
        this.modelDao = modelDao;
    }

    public static final class ExactSearcherContext {
        private final boolean useQuantizedVectorsForSearch;
        private final int k;
        private final BitSet matchedDocs;
        private final KNNQuery knnQuery;
        private final boolean isParentHits;

        @Generated
        ExactSearcherContext(boolean useQuantizedVectorsForSearch, int k, BitSet matchedDocs, KNNQuery knnQuery, boolean isParentHits) {
            this.useQuantizedVectorsForSearch = useQuantizedVectorsForSearch;
            this.k = k;
            this.matchedDocs = matchedDocs;
            this.knnQuery = knnQuery;
            this.isParentHits = isParentHits;
        }

        @Generated
        public static ExactSearcherContextBuilder builder() {
            return new ExactSearcherContextBuilder();
        }

        @Generated
        public boolean isUseQuantizedVectorsForSearch() {
            return this.useQuantizedVectorsForSearch;
        }

        @Generated
        public int getK() {
            return this.k;
        }

        @Generated
        public BitSet getMatchedDocs() {
            return this.matchedDocs;
        }

        @Generated
        public KNNQuery getKnnQuery() {
            return this.knnQuery;
        }

        @Generated
        public boolean isParentHits() {
            return this.isParentHits;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExactSearcherContext)) {
                return false;
            }
            ExactSearcherContext other = (ExactSearcherContext)o;
            if (this.isUseQuantizedVectorsForSearch() != other.isUseQuantizedVectorsForSearch()) {
                return false;
            }
            if (this.getK() != other.getK()) {
                return false;
            }
            if (this.isParentHits() != other.isParentHits()) {
                return false;
            }
            BitSet this$matchedDocs = this.getMatchedDocs();
            BitSet other$matchedDocs = other.getMatchedDocs();
            if (this$matchedDocs == null ? other$matchedDocs != null : !this$matchedDocs.equals(other$matchedDocs)) {
                return false;
            }
            KNNQuery this$knnQuery = this.getKnnQuery();
            KNNQuery other$knnQuery = other.getKnnQuery();
            return !(this$knnQuery == null ? other$knnQuery != null : !((Object)((Object)this$knnQuery)).equals((Object)other$knnQuery));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUseQuantizedVectorsForSearch() ? 79 : 97);
            result = result * 59 + this.getK();
            result = result * 59 + (this.isParentHits() ? 79 : 97);
            BitSet $matchedDocs = this.getMatchedDocs();
            result = result * 59 + ($matchedDocs == null ? 43 : $matchedDocs.hashCode());
            KNNQuery $knnQuery = this.getKnnQuery();
            result = result * 59 + ($knnQuery == null ? 43 : ((Object)((Object)$knnQuery)).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ExactSearcher.ExactSearcherContext(useQuantizedVectorsForSearch=" + this.isUseQuantizedVectorsForSearch() + ", k=" + this.getK() + ", matchedDocs=" + this.getMatchedDocs() + ", knnQuery=" + this.getKnnQuery() + ", isParentHits=" + this.isParentHits() + ")";
        }

        @Generated
        public static class ExactSearcherContextBuilder {
            @Generated
            private boolean useQuantizedVectorsForSearch;
            @Generated
            private int k;
            @Generated
            private BitSet matchedDocs;
            @Generated
            private KNNQuery knnQuery;
            @Generated
            private boolean isParentHits;

            @Generated
            ExactSearcherContextBuilder() {
            }

            @Generated
            public ExactSearcherContextBuilder useQuantizedVectorsForSearch(boolean useQuantizedVectorsForSearch) {
                this.useQuantizedVectorsForSearch = useQuantizedVectorsForSearch;
                return this;
            }

            @Generated
            public ExactSearcherContextBuilder k(int k) {
                this.k = k;
                return this;
            }

            @Generated
            public ExactSearcherContextBuilder matchedDocs(BitSet matchedDocs) {
                this.matchedDocs = matchedDocs;
                return this;
            }

            @Generated
            public ExactSearcherContextBuilder knnQuery(KNNQuery knnQuery) {
                this.knnQuery = knnQuery;
                return this;
            }

            @Generated
            public ExactSearcherContextBuilder isParentHits(boolean isParentHits) {
                this.isParentHits = isParentHits;
                return this;
            }

            @Generated
            public ExactSearcherContext build() {
                return new ExactSearcherContext(this.useQuantizedVectorsForSearch, this.k, this.matchedDocs, this.knnQuery, this.isParentHits);
            }

            @Generated
            public String toString() {
                return "ExactSearcher.ExactSearcherContext.ExactSearcherContextBuilder(useQuantizedVectorsForSearch=" + this.useQuantizedVectorsForSearch + ", k=" + this.k + ", matchedDocs=" + this.matchedDocs + ", knnQuery=" + this.knnQuery + ", isParentHits=" + this.isParentHits + ")";
            }
        }
    }
}

