/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.opensearch.knn.index.query.KNNWeight;

public class KNNScorer
extends Scorer {
    private final DocIdSetIterator docIdsIter;
    private final Map<Integer, Float> scores;
    private final float boost;

    public KNNScorer(Weight weight, DocIdSetIterator docIdsIter, Map<Integer, Float> scores, float boost) {
        super(weight);
        this.docIdsIter = docIdsIter;
        this.scores = scores;
        this.boost = boost;
    }

    public DocIdSetIterator iterator() {
        return this.docIdsIter;
    }

    public float getMaxScore(int upTo) throws IOException {
        return Float.MAX_VALUE;
    }

    public float score() {
        assert (this.docID() != Integer.MAX_VALUE);
        Float score = this.scores.get(this.docID());
        if (score == null) {
            throw new RuntimeException("Null score for the docID: " + this.docID());
        }
        return score.floatValue() * this.boost;
    }

    public int docID() {
        return this.docIdsIter.docID();
    }

    public static Scorer emptyScorer(KNNWeight knnWeight) {
        return new Scorer(knnWeight){
            private final DocIdSetIterator docIdsIter = DocIdSetIterator.empty();

            public DocIdSetIterator iterator() {
                return this.docIdsIter;
            }

            public float getMaxScore(int upTo) throws IOException {
                return 0.0f;
            }

            public float score() throws IOException {
                assert (this.docID() != Integer.MAX_VALUE);
                return 0.0f;
            }

            public int docID() {
                return this.docIdsIter.docID();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof Scorer)) {
                    return false;
                }
                return this.getWeight().equals(((Scorer)obj).getWeight());
            }
        };
    }
}

