/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.autoplay;

import tim.prune.data.DataPoint;
import tim.prune.data.Timestamp;

public class PointInfo
implements Comparable<PointInfo> {
    private final Timestamp _timestamp;
    private final int _pointIndex;
    private final boolean _segmentFlag;

    public PointInfo(DataPoint dataPoint, int n) {
        this._timestamp = dataPoint.hasTimestamp() ? dataPoint.getTimestamp() : (dataPoint.getPhoto() != null && dataPoint.getPhoto().hasTimestamp() ? dataPoint.getPhoto().getTimestamp() : null);
        this._pointIndex = n;
        this._segmentFlag = dataPoint.getSegmentStart();
    }

    public Timestamp getTimestamp() {
        return this._timestamp;
    }

    public int getIndex() {
        return this._pointIndex;
    }

    public boolean getSegmentFlag() {
        return this._segmentFlag;
    }

    @Override
    public int compareTo(PointInfo pointInfo) {
        boolean bl;
        long l = 0L;
        boolean bl2 = this._timestamp != null;
        boolean bl3 = bl = pointInfo._timestamp != null;
        if (bl2 && bl) {
            l = this._timestamp.getMillisecondsSince(pointInfo._timestamp);
        } else if (bl2) {
            l = -1L;
        } else if (bl) {
            l = 1L;
        }
        if (l == 0L) {
            return this._pointIndex - pointInfo._pointIndex;
        }
        return l < 0L ? -1 : 1;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (object == null || !(object instanceof PointInfo)) {
            return false;
        }
        PointInfo pointInfo = (PointInfo)object;
        if (this._pointIndex != pointInfo._pointIndex) {
            return false;
        }
        boolean bl2 = this._timestamp != null;
        boolean bl3 = bl = pointInfo._timestamp != null;
        if (bl2 != bl) {
            return false;
        }
        if (!bl2 && !bl) {
            return true;
        }
        return this._timestamp.isEqual(pointInfo._timestamp);
    }
}

