/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.agent;

import java.io.IOException;
import java.util.Map;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.utils.StringUtils;

public class MLToolSpec
implements ToXContentObject {
    public static final String TOOL_TYPE_FIELD = "type";
    public static final String TOOL_NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String PARAMETERS_FIELD = "parameters";
    public static final String INCLUDE_OUTPUT_IN_AGENT_RESPONSE = "include_output_in_agent_response";
    private String type;
    private String name;
    private String description;
    private Map<String, String> parameters;
    private boolean includeOutputInAgentResponse;

    public MLToolSpec(String type, String name, String description, Map<String, String> parameters, boolean includeOutputInAgentResponse) {
        if (type == null) {
            throw new IllegalArgumentException("tool type is null");
        }
        this.type = type;
        this.name = name;
        this.description = description;
        this.parameters = parameters;
        this.includeOutputInAgentResponse = includeOutputInAgentResponse;
    }

    public MLToolSpec(StreamInput input) throws IOException {
        this.type = input.readString();
        this.name = input.readOptionalString();
        this.description = input.readOptionalString();
        if (input.readBoolean()) {
            this.parameters = input.readMap(StreamInput::readString, StreamInput::readOptionalString);
        }
        this.includeOutputInAgentResponse = input.readBoolean();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeOptionalString(this.name);
        out.writeOptionalString(this.description);
        if (this.parameters != null && this.parameters.size() > 0) {
            out.writeBoolean(true);
            out.writeMap(this.parameters, StreamOutput::writeString, StreamOutput::writeOptionalString);
        } else {
            out.writeBoolean(false);
        }
        out.writeBoolean(this.includeOutputInAgentResponse);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.type != null) {
            builder.field(TOOL_TYPE_FIELD, this.type);
        }
        if (this.name != null) {
            builder.field(TOOL_NAME_FIELD, this.name);
        }
        if (this.description != null) {
            builder.field(DESCRIPTION_FIELD, this.description);
        }
        if (this.parameters != null && this.parameters.size() > 0) {
            builder.field(PARAMETERS_FIELD, this.parameters);
        }
        builder.field(INCLUDE_OUTPUT_IN_AGENT_RESPONSE, this.includeOutputInAgentResponse);
        builder.endObject();
        return builder;
    }

    public static MLToolSpec parse(XContentParser parser) throws IOException {
        String type = null;
        String name = null;
        String description = null;
        Map<String, String> parameters = null;
        boolean includeOutputInAgentResponse = false;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block14: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "type": {
                    type = parser.text();
                    continue block14;
                }
                case "name": {
                    name = parser.text();
                    continue block14;
                }
                case "description": {
                    description = parser.text();
                    continue block14;
                }
                case "parameters": {
                    parameters = StringUtils.getParameterMap(parser.map());
                    continue block14;
                }
                case "include_output_in_agent_response": {
                    includeOutputInAgentResponse = parser.booleanValue();
                    continue block14;
                }
            }
            parser.skipChildren();
        }
        return MLToolSpec.builder().type(type).name(name).description(description).parameters(parameters).includeOutputInAgentResponse(includeOutputInAgentResponse).build();
    }

    public static MLToolSpec fromStream(StreamInput in) throws IOException {
        MLToolSpec toolSpec = new MLToolSpec(in);
        return toolSpec;
    }

    @Generated
    public static MLToolSpecBuilder builder() {
        return new MLToolSpecBuilder();
    }

    @Generated
    public MLToolSpecBuilder toBuilder() {
        return new MLToolSpecBuilder().type(this.type).name(this.name).description(this.description).parameters(this.parameters).includeOutputInAgentResponse(this.includeOutputInAgentResponse);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MLToolSpec)) {
            return false;
        }
        MLToolSpec other = (MLToolSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isIncludeOutputInAgentResponse() != other.isIncludeOutputInAgentResponse()) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        Map<String, String> this$parameters = this.getParameters();
        Map<String, String> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MLToolSpec;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeOutputInAgentResponse() ? 79 : 97);
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        Map<String, String> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Generated
    public boolean isIncludeOutputInAgentResponse() {
        return this.includeOutputInAgentResponse;
    }

    @Generated
    public static class MLToolSpecBuilder {
        @Generated
        private String type;
        @Generated
        private String name;
        @Generated
        private String description;
        @Generated
        private Map<String, String> parameters;
        @Generated
        private boolean includeOutputInAgentResponse;

        @Generated
        MLToolSpecBuilder() {
        }

        @Generated
        public MLToolSpecBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public MLToolSpecBuilder name(String name) {
            this.name = name;
            return this;
        }

        @Generated
        public MLToolSpecBuilder description(String description) {
            this.description = description;
            return this;
        }

        @Generated
        public MLToolSpecBuilder parameters(Map<String, String> parameters) {
            this.parameters = parameters;
            return this;
        }

        @Generated
        public MLToolSpecBuilder includeOutputInAgentResponse(boolean includeOutputInAgentResponse) {
            this.includeOutputInAgentResponse = includeOutputInAgentResponse;
            return this;
        }

        @Generated
        public MLToolSpec build() {
            return new MLToolSpec(this.type, this.name, this.description, this.parameters, this.includeOutputInAgentResponse);
        }

        @Generated
        public String toString() {
            return "MLToolSpec.MLToolSpecBuilder(type=" + this.type + ", name=" + this.name + ", description=" + this.description + ", parameters=" + this.parameters + ", includeOutputInAgentResponse=" + this.includeOutputInAgentResponse + ")";
        }
    }
}

