/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.PT;
import javax.imageio.ImageIO;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jme.JME;
import jme.JMEmol;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.writers.CDXMLWriter;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterAtomIterator;
import org.jmol.api.JmolAdapterBondIterator;
import org.jmol.api.JmolDropEditor;
import org.jmol.api.JmolViewer;
import org.jmol.awt.FileDropper;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class JmolJME
extends JME
implements WindowListener,
JmolDropEditor {
    Viewer vwr;
    private Container parentWindow;
    private String fileName;
    private boolean headless = true;
    private boolean allowClean = true;
    private boolean cleaning = false;

    public JmolJME() {
        super((JFrame)null, true);
        this.keepHydrogens = false;
    }

    public void setViewer(JFrame frame, Viewer vwr, Container parent) {
        this.parentWindow = parent;
        this.vwr = vwr;
        this.headless = vwr.headless;
        this.setDropTarget(new DropTarget(this, new FileDropper(null, null, this)));
        if (frame == null) {
            frame = new JFrame(this.getTitle());
            frame.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    JmolJME.this.mol.center();
                }
            });
            JPanel pp = new JPanel();
            JPanel p = new JPanel();
            pp.add("Center", p);
            p.setLayout(new BoxLayout(p, 0));
            JButton b = new JButton("clean");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JmolJME.this.doClean();
                }
            });
            b = new JButton("from 3D");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JmolJME.this.from3D();
                }
            });
            p.add(Box.createHorizontalStrut(5));
            b = new JButton("replace 3D");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JmolJME.this.to3D(false);
                }
            });
            b = new JButton("add 3D");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JmolJME.this.to3D(true);
                }
            });
            p.add(Box.createHorizontalStrut(5));
            b = new JButton("to MOL");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JmolJME.this.toMOL();
                }
            });
            b = new JButton("to CDXML");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JmolJME.this.toCDXML();
                }
            });
            b = new JButton("to PNG");
            p.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JmolJME.this.toPNG(null);
                }
            });
            frame.add("South", pp);
            frame.setBounds(300, 300, 600, 400);
            frame.addWindowListener(this);
            this.setFrame(frame);
        }
        frame.setResizable(true);
        frame.setVisible(true);
    }

    public void toPNG(String filename) {
        try {
            BufferedImage img = this.getImage(30, 10);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "PNG", bos);
            this.toFile(filename == null ? "?jmol.png" : filename, bos.toByteArray(), "png");
        }
        catch (IOException e1) {
            this.sorry("Something went wrong: " + e1);
        }
    }

    public BufferedImage getImage(int marginX, int marginY) {
        double[][] xy = this.mol.saveXY();
        Dimension d = this.mol.shiftToXY(marginX, marginY);
        BufferedImage img = new BufferedImage(d.width, d.height, 2);
        boolean needRecenter = this.mol.needRecentering;
        this.mol.needRecentering = false;
        this.paintMolecularArea(img);
        this.mol.needRecentering = needRecenter;
        this.mol.restoreXY(xy);
        return img;
    }

    private String getTitle() {
        return "Jmol/JME 2D Molecular Editor" + (this.fileName == null ? "" : " " + this.fileName);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        if (this.myFrame != null) {
            this.myFrame.setVisible(false);
        }
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    public void dispose() {
        this.vwr = null;
        if (this.myFrame != null) {
            this.myFrame.dispose();
        }
        this.myFrame = null;
        this.parentWindow = null;
    }

    public void from3D() {
        if (this.vwr.getFrameAtoms().isEmpty()) {
            return;
        }
        Map<String, Object> info = this.vwr.getCurrentModelAuxInfo();
        if (info == null) {
            this.sorry("More than one model is visible in Jmol.");
            return;
        }
        boolean is2D = "2D".equals(info.get("dimension"));
        String mol = null;
        try {
            if (is2D) {
                mol = this.vwr.getModelExtract("thisModel", false, false, "MOL");
            } else {
                String smiles = this.vwr.getSmiles(this.vwr.getFrameAtoms());
                mol = this.getMolFromSmiles(smiles, false);
            }
            if (mol == null) {
                this.sorry("Something went wrong.");
            }
            this.clear();
            this.readMolFile(mol);
        }
        catch (Exception e) {
            this.sorry(e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public String smiles() {
        if (this.mol.natoms == 0) {
            return "";
        }
        String mol = this.molFile();
        if (mol.length() == 0) {
            return "";
        }
        String smiles = this.vwr.getInchi(null, mol, "smiles");
        this.repaint();
        return smiles;
    }

    public String inchi() {
        return this.vwr.getInchi(null, this.molFile(), "standard");
    }

    private String getMolFromSmiles(String smiles, boolean is3D) {
        System.out.println("JmolJME using SMILES " + smiles);
        String url = JC.resolveDataBase("smiles" + (is3D ? "3D" : "2D"), PT.escapeUrl(smiles), null);
        return this.vwr.getFileAsString(url);
    }

    void sorry(String msg) {
        System.err.println(msg);
        if (!this.headless) {
            JOptionPane.showMessageDialog(this, msg, "Sorry, can't do that.", 1);
        }
    }

    void say(String msg) {
        System.out.println(msg);
        this.infoText = msg;
    }

    public void to3D(boolean isAppend) {
        String smiles = this.smiles();
        if (smiles == null || smiles.length() == 0) {
            this.sorry("There was a problem generating the SMILES from the InChI");
            return;
        }
        System.out.println("using smiles from InChI: " + smiles);
        String mol = this.getMolFromSmiles(smiles, true);
        Hashtable<String, Object> htParams = new Hashtable<String, Object>();
        this.vwr.openStringInlineParamsAppend(mol, htParams, isAppend);
        if (!this.headless) {
            this.parentWindow.requestFocus();
            this.vwr.refresh(1, "JmolJME");
        }
    }

    public void setFrameVisible(boolean b) {
        if (this.myFrame != null) {
            this.myFrame.setVisible(b);
        }
    }

    protected void toMOL() {
        String mol = this.molFile();
        this.toFile("?jmol.mol", mol, "txt");
    }

    protected void toCDXML() {
        String mol = this.molFile();
        String xml = CDXMLWriter.fromString(this.vwr, "Mol", mol);
        this.toFile("?jmol.cdxml", xml, "txt");
    }

    @Override
    public void loadFile(String fname) {
        this.read2Dor3DFile(fname);
    }

    private void read2Dor3DFile(String fname) {
        try {
            this.setFileName(fname);
            File f = new File(fname);
            System.out.println("JmolJME reading file " + f.getAbsolutePath());
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            boolean isBinary = Resolver.getBinaryType(bis) != null;
            String type = this.vwr.getModelAdapter().getFileTypeName(bis);
            bis.close();
            if ("Jme".equals(type)) {
                this.clear();
                this.readMolecule(this.vwr.getFileAsString(fname));
                this.mol.center();
                return;
            }
            Hashtable<String, Object> htParams = new Hashtable<String, Object>();
            htParams.put("filter", "NOH;NO3D;fileType=" + type);
            htParams.put("binary", isBinary);
            this.vwr.setLoadParameters(htParams, false);
            bis = new BufferedInputStream(new FileInputStream(f));
            Object ret = this.vwr.getModelAdapter().getAtomSetCollectionFromReader(fname, bis, htParams);
            if (ret instanceof AtomSetCollection) {
                AtomSetCollection asc = (AtomSetCollection)ret;
                Map<String, Object> info = asc.getAtomSetAuxiliaryInfo(0);
                boolean is2D = "2D".equals(info.get("dimension"));
                this.clear();
                if (is2D) {
                    this.read2D(fname, asc);
                } else {
                    this.read3D(fname);
                }
                this.mol.center();
            } else {
                this.sorry(ret.toString());
            }
        }
        catch (Exception e) {
            this.sorry(e.toString());
            e.printStackTrace();
        }
        this.repaint();
        System.out.println("JJME " + fname);
    }

    private void setFileName(String fname) {
        this.fileName = fname;
    }

    private void read2D(String fname, AtomSetCollection asc) {
        this.fileName = fname;
        this.reaction = false;
        JmolAdapter a = this.vwr.getModelAdapter();
        this.readAtomSet(a.getAtomIterator(asc), this.vwr.getModelAdapter().getBondIterator(asc));
    }

    private void readAtomSet(JmolAdapterAtomIterator atomIterator, JmolAdapterBondIterator bondIterator) {
        this.reset();
        JMEmol jMEmol = new JMEmol((JME)this, atomIterator, bondIterator);
        this.mols[++this.nmols] = jMEmol;
        this.mol = jMEmol;
        if (!this.setMol(true)) {
            this.say("Close atoms found; cleaning");
            this.doClean();
            this.repaint();
        }
    }

    @Override
    protected boolean setMol(boolean checkMultipart) {
        super.setMol(checkMultipart);
        int i = this.mol.natoms + 1;
        while (--i >= 1) {
            double x = this.mol.getX(i);
            double y = this.mol.getY(i);
            int j = i;
            while (--j >= 1) {
                double x2 = this.mol.getX(j);
                double y2 = this.mol.getY(j);
                if (!(Math.abs(x - x2) + Math.abs(y - y2) < 0.1)) continue;
                System.out.println(i + " " + j + " " + x + " " + y + " " + x2 + " " + y2);
                return false;
            }
        }
        return true;
    }

    private void read3D(String fname) {
        String mol = this.vwr.getFileAsString(fname);
        this.loadSmilesCleanly(this.getSmiles(mol));
    }

    private String getSmiles(String mol) {
        return this.vwr.getInchi(null, mol, "smiles");
    }

    @Override
    public void loadContent(String script) {
    }

    void doClean() {
        if (!this.allowClean) {
            return;
        }
        String smiles = this.vwr.getInchi(null, this.molFile(), "smiles");
        this.loadSmilesCleanly(smiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSmilesCleanly(String smiles) {
        if (smiles == null || smiles.length() == 0 || this.cleaning) {
            return;
        }
        System.out.println("using smiles from InChI: " + smiles);
        String mol = null;
        try {
            this.cleaning = true;
            mol = this.getMolFromSmiles(smiles, false);
            if (mol == null) {
                this.sorry("Something went wrong.");
            } else {
                this.readMolFile(mol);
            }
        }
        catch (Exception e) {
            this.sorry(e.toString());
            e.printStackTrace();
        }
        finally {
            this.cleaning = false;
        }
    }

    private void toFile(String name, final Object bytesOrString, final String type) {
        boolean useThread;
        boolean bl = useThread = name.indexOf("?") >= 0;
        if (useThread && this.headless) {
            this.sorry("Filenames must not contain '?' in headless mode - '?' replaced with '_'");
            name = name.replace('?', '_');
            useThread = false;
        }
        final String finalName = name;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                System.out.println("JmolJME writing file " + finalName);
                JmolJME.this.vwr.writeFile(finalName, bytesOrString, type);
            }
        };
        if (useThread) {
            new Thread(r).start();
        } else {
            r.run();
        }
    }

    public static void main(String[] args) {
        Viewer vwr = (Viewer)JmolViewer.allocateViewer(null, new SmarterJmolAdapter());
        JmolJME jjme = new JmolJME();
        jjme.vwr = vwr;
        jjme.headless = true;
        String mol = vwr.getFileAsString("c:/temp/jmetest.mol");
        jjme.readMolFile(mol);
        jjme.toPNG("c:/temp/test.png");
    }
}

