// NOTICE: This file is generated by Rollup. To modify it,
// please instead edit the ESM counterpart and rebuild with Rollup (npm run build).
'use strict';

const createMapWithSet = require('../../utils/createMapWithSet.cjs');
const isStandardSyntaxAtRule = require('../../utils/isStandardSyntaxAtRule.cjs');
const validateTypes = require('../../utils/validateTypes.cjs');
const report = require('../../utils/report.cjs');
const ruleMessages = require('../../utils/ruleMessages.cjs');
const validateObjectWithArrayProps = require('../../utils/validateObjectWithArrayProps.cjs');
const validateOptions = require('../../utils/validateOptions.cjs');

// NOTE: We should have named this rule as `at-rule-descriptor-required-list` instead.
// See https://github.com/stylelint/stylelint/pull/8185
const ruleName = 'at-rule-property-required-list';

const messages = ruleMessages(ruleName, {
	expected: (atRule, descriptor) => `Expected descriptor "${descriptor}" for at-rule "${atRule}"`,
});

const meta = {
	url: 'https://stylelint.io/user-guide/rules/at-rule-property-required-list',
};

/** @type {import('stylelint').CoreRules[ruleName]} */
const rule = (primary) => {
	return (root, result) => {
		const validOptions = validateOptions(result, ruleName, {
			actual: primary,
			possible: [validateObjectWithArrayProps(validateTypes.isString)],
		});

		if (!validOptions) {
			return;
		}

		const propLists = createMapWithSet(primary);

		/** @type {Set<string>} */
		const currentPropList = new Set();

		root.walkAtRules((atRule) => {
			if (!isStandardSyntaxAtRule(atRule)) {
				return;
			}

			const { name, nodes } = atRule;

			if (!nodes) return;

			const atRuleName = name.toLowerCase();
			const propList = propLists.get(atRuleName);

			if (!propList) {
				return;
			}

			currentPropList.clear();

			for (const node of nodes) {
				if (!node || node.type !== 'decl') continue;

				const propName = node.prop.toLowerCase();

				if (!propList.has(propName)) continue;

				currentPropList.add(propName);
			}

			if (currentPropList.size === propList.size) {
				return;
			}

			for (const requiredProp of propList) {
				if (currentPropList.has(requiredProp)) continue;

				report({
					message: messages.expected,
					messageArgs: [atRuleName, requiredProp],
					node: atRule,
					word: `@${atRule.name}`,
					result,
					ruleName,
				});
			}
		});
	};
};

rule.ruleName = ruleName;
rule.messages = messages;
rule.meta = meta;

module.exports = rule;
