/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow;

import java.io.File;
import java.util.Locale;
import org.sunflow.PluginRegistry;
import org.sunflow.RenderObjectMap;
import org.sunflow.SunflowAPIInterface;
import org.sunflow.core.Camera;
import org.sunflow.core.CameraLens;
import org.sunflow.core.Display;
import org.sunflow.core.Geometry;
import org.sunflow.core.ImageSampler;
import org.sunflow.core.Instance;
import org.sunflow.core.LightSource;
import org.sunflow.core.Modifier;
import org.sunflow.core.Options;
import org.sunflow.core.ParameterList;
import org.sunflow.core.PrimitiveList;
import org.sunflow.core.Scene;
import org.sunflow.core.SceneParser;
import org.sunflow.core.Shader;
import org.sunflow.core.Tesselatable;
import org.sunflow.core.TextureCache;
import org.sunflow.image.ColorFactory;
import org.sunflow.math.BoundingBox;
import org.sunflow.math.Matrix4;
import org.sunflow.math.Point2;
import org.sunflow.math.Point3;
import org.sunflow.math.Vector3;
import org.sunflow.system.FileUtils;
import org.sunflow.system.SearchPath;
import org.sunflow.system.UI;

public class SunflowAPI
implements SunflowAPIInterface {
    public static final String VERSION = "0.07.3";
    public static final String DEFAULT_OPTIONS = "::options";
    private Scene scene;
    private SearchPath includeSearchPath;
    private SearchPath textureSearchPath;
    private ParameterList parameterList;
    private RenderObjectMap renderObjects;
    private int currentFrame;
    private TextureCache textureCache = new TextureCache();

    public static void runSystemCheck() {
        String string;
        long l = Runtime.getRuntime().maxMemory() / 0x100000L;
        if (l < 800L) {
            UI.printError(UI.Module.API, "JVM available memory is below %d MB (found %d MB only).\nPlease make sure you launched the program with the -Xmx command line options.", 800L, l);
        }
        if ((string = System.getProperty("java.vm.name")) == null || !string.contains("HotSpot") || !string.contains("Server")) {
            UI.printError(UI.Module.API, "You do not appear to be running Sun's server JVM\nPerformance may suffer", new Object[0]);
        }
        UI.printDetailed(UI.Module.API, "Java environment settings:", new Object[0]);
        UI.printDetailed(UI.Module.API, "  * Max memory available : %d MB", l);
        UI.printDetailed(UI.Module.API, "  * Virtual machine name : %s", string == null ? "<unknown" : string);
        UI.printDetailed(UI.Module.API, "  * Operating system     : %s", System.getProperty("os.name"));
        UI.printDetailed(UI.Module.API, "  * CPU architecture     : %s", System.getProperty("os.arch"));
    }

    public SunflowAPI() {
        this.reset();
    }

    public final void reset() {
        this.scene = new Scene();
        this.includeSearchPath = new SearchPath("include");
        this.textureSearchPath = new SearchPath("texture");
        this.parameterList = new ParameterList();
        this.renderObjects = new RenderObjectMap();
        this.currentFrame = 1;
    }

    public final void plugin(String string, String string2, String string3) {
        if (string.equals("primitive")) {
            PluginRegistry.primitivePlugins.registerPlugin(string2, string3);
        } else if (string.equals("tesselatable")) {
            PluginRegistry.tesselatablePlugins.registerPlugin(string2, string3);
        } else if (string.equals("shader")) {
            PluginRegistry.shaderPlugins.registerPlugin(string2, string3);
        } else if (string.equals("modifier")) {
            PluginRegistry.modifierPlugins.registerPlugin(string2, string3);
        } else if (string.equals("camera_lens")) {
            PluginRegistry.cameraLensPlugins.registerPlugin(string2, string3);
        } else if (string.equals("light")) {
            PluginRegistry.lightSourcePlugins.registerPlugin(string2, string3);
        } else if (string.equals("accel")) {
            PluginRegistry.accelPlugins.registerPlugin(string2, string3);
        } else if (string.equals("bucket_order")) {
            PluginRegistry.bucketOrderPlugins.registerPlugin(string2, string3);
        } else if (string.equals("filter")) {
            PluginRegistry.filterPlugins.registerPlugin(string2, string3);
        } else if (string.equals("gi_engine")) {
            PluginRegistry.giEnginePlugins.registerPlugin(string2, string3);
        } else if (string.equals("caustic_photon_map")) {
            PluginRegistry.causticPhotonMapPlugins.registerPlugin(string2, string3);
        } else if (string.equals("global_photon_map")) {
            PluginRegistry.globalPhotonMapPlugins.registerPlugin(string2, string3);
        } else if (string.equals("image_sampler")) {
            PluginRegistry.imageSamplerPlugins.registerPlugin(string2, string3);
        } else if (string.equals("parser")) {
            PluginRegistry.parserPlugins.registerPlugin(string2, string3);
        } else if (string.equals("bitmap_reader")) {
            PluginRegistry.bitmapReaderPlugins.registerPlugin(string2, string3);
        } else if (string.equals("bitmap_writer")) {
            PluginRegistry.bitmapWriterPlugins.registerPlugin(string2, string3);
        } else {
            UI.printWarning(UI.Module.API, "Unrecognized plugin type: \"%s\" - ignoring declaration of \"%s\"", string, string2);
        }
    }

    public final void parameter(String string, String string2) {
        this.parameterList.addString(string, string2);
    }

    public final void parameter(String string, boolean bl) {
        this.parameterList.addBoolean(string, bl);
    }

    public final void parameter(String string, int n) {
        this.parameterList.addInteger(string, n);
    }

    public final void parameter(String string, float f) {
        this.parameterList.addFloat(string, f);
    }

    public final void parameter(String string, String string2, float ... fArray) {
        try {
            this.parameterList.addColor(string, ColorFactory.createColor(string2, fArray));
        }
        catch (ColorFactory.ColorSpecificationException colorSpecificationException) {
            UI.printError(UI.Module.API, "Unable to specify color: %s - ignoring parameter \"%s\"", colorSpecificationException.getMessage(), string);
        }
    }

    public final void parameter(String string, Point3 point3) {
        this.parameterList.addPoints(string, ParameterList.InterpolationType.NONE, new float[]{point3.x, point3.y, point3.z});
    }

    public final void parameter(String string, Vector3 vector3) {
        this.parameterList.addVectors(string, ParameterList.InterpolationType.NONE, new float[]{vector3.x, vector3.y, vector3.z});
    }

    public final void parameter(String string, Point2 point2) {
        this.parameterList.addTexCoords(string, ParameterList.InterpolationType.NONE, new float[]{point2.x, point2.y});
    }

    public final void parameter(String string, Matrix4 matrix4) {
        this.parameterList.addMatrices(string, ParameterList.InterpolationType.NONE, matrix4.asRowMajor());
    }

    public final void parameter(String string, int[] nArray) {
        this.parameterList.addIntegerArray(string, nArray);
    }

    public final void parameter(String string, String[] stringArray) {
        this.parameterList.addStringArray(string, stringArray);
    }

    public final void parameter(String string, String string2, String string3, float[] fArray) {
        ParameterList.InterpolationType interpolationType;
        try {
            interpolationType = ParameterList.InterpolationType.valueOf(string3.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            UI.printError(UI.Module.API, "Unknown interpolation type: %s -- ignoring parameter \"%s\"", string3, string);
            return;
        }
        if (string2.equals("float")) {
            this.parameterList.addFloats(string, interpolationType, fArray);
        } else if (string2.equals("point")) {
            this.parameterList.addPoints(string, interpolationType, fArray);
        } else if (string2.equals("vector")) {
            this.parameterList.addVectors(string, interpolationType, fArray);
        } else if (string2.equals("texcoord")) {
            this.parameterList.addTexCoords(string, interpolationType, fArray);
        } else if (string2.equals("matrix")) {
            this.parameterList.addMatrices(string, interpolationType, fArray);
        } else {
            UI.printError(UI.Module.API, "Unknown parameter type: %s -- ignoring parameter \"%s\"", string2, string);
        }
    }

    public void remove(String string) {
        this.renderObjects.remove(string);
    }

    private boolean update(String string) {
        boolean bl = this.renderObjects.update(string, this.parameterList, this);
        this.parameterList.clear(bl);
        return bl;
    }

    public final void searchpath(String string, String string2) {
        if (string.equals("include")) {
            this.includeSearchPath.addSearchPath(string2);
        } else if (string.equals("texture")) {
            this.textureSearchPath.addSearchPath(string2);
        } else {
            UI.printWarning(UI.Module.API, "Invalid searchpath type: \"%s\"", string);
        }
    }

    public final String resolveTextureFilename(String string) {
        return this.textureSearchPath.resolvePath(string);
    }

    public final String resolveIncludeFilename(String string) {
        return this.includeSearchPath.resolvePath(string);
    }

    public final void shader(String string, String string2) {
        if (!this.isIncremental(string2)) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare shader \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            Shader shader = PluginRegistry.shaderPlugins.createObject(string2);
            if (shader == null) {
                UI.printError(UI.Module.API, "Unable to create shader of type \"%s\"", string2);
                return;
            }
            this.renderObjects.put(string, shader);
        }
        if (this.lookupShader(string) != null) {
            this.update(string);
        } else {
            UI.printError(UI.Module.API, "Unable to update shader \"%s\" - shader object was not found", string);
            this.parameterList.clear(true);
        }
    }

    public final void modifier(String string, String string2) {
        if (!this.isIncremental(string2)) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare modifier \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            Modifier modifier = PluginRegistry.modifierPlugins.createObject(string2);
            if (modifier == null) {
                UI.printError(UI.Module.API, "Unable to create modifier of type \"%s\"", string2);
                return;
            }
            this.renderObjects.put(string, modifier);
        }
        if (this.lookupModifier(string) != null) {
            this.update(string);
        } else {
            UI.printError(UI.Module.API, "Unable to update modifier \"%s\" - modifier object was not found", string);
            this.parameterList.clear(true);
        }
    }

    public final void geometry(String string, String string2) {
        if (!this.isIncremental(string2)) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare geometry \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            if (PluginRegistry.tesselatablePlugins.hasType(string2)) {
                Tesselatable tesselatable = PluginRegistry.tesselatablePlugins.createObject(string2);
                if (tesselatable == null) {
                    UI.printError(UI.Module.API, "Unable to create tesselatable object of type \"%s\"", string2);
                    return;
                }
                this.renderObjects.put(string, tesselatable);
            } else {
                PrimitiveList primitiveList = PluginRegistry.primitivePlugins.createObject(string2);
                if (primitiveList == null) {
                    UI.printError(UI.Module.API, "Unable to create primitive of type \"%s\"", string2);
                    return;
                }
                this.renderObjects.put(string, primitiveList);
            }
        }
        if (this.lookupGeometry(string) != null) {
            this.update(string);
        } else {
            UI.printError(UI.Module.API, "Unable to update geometry \"%s\" - geometry object was not found", string);
            this.parameterList.clear(true);
        }
    }

    public final void instance(String string, String string2) {
        if (!this.isIncremental(string2)) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare instance \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            this.parameter("geometry", string2);
            this.renderObjects.put(string, new Instance());
        }
        if (this.lookupInstance(string) != null) {
            this.update(string);
        } else {
            UI.printError(UI.Module.API, "Unable to update instance \"%s\" - instance object was not found", string);
            this.parameterList.clear(true);
        }
    }

    public final void light(String string, String string2) {
        if (!this.isIncremental(string2)) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare light \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            LightSource lightSource = PluginRegistry.lightSourcePlugins.createObject(string2);
            if (lightSource == null) {
                UI.printError(UI.Module.API, "Unable to create light source of type \"%s\"", string2);
                return;
            }
            this.renderObjects.put(string, lightSource);
        }
        if (this.lookupLight(string) != null) {
            this.update(string);
        } else {
            UI.printError(UI.Module.API, "Unable to update instance \"%s\" - instance object was not found", string);
            this.parameterList.clear(true);
        }
    }

    public final void camera(String string, String string2) {
        if (!this.isIncremental(string2)) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare camera \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            CameraLens cameraLens = PluginRegistry.cameraLensPlugins.createObject(string2);
            if (cameraLens == null) {
                UI.printError(UI.Module.API, "Unable to create a camera lens of type \"%s\"", string2);
                return;
            }
            this.renderObjects.put(string, new Camera(cameraLens));
        }
        if (this.lookupCamera(string) != null) {
            this.update(string);
        } else {
            UI.printError(UI.Module.API, "Unable to update camera \"%s\" - camera object was not found", string);
            this.parameterList.clear(true);
        }
    }

    public final void options(String string) {
        if (this.lookupOptions(string) == null) {
            if (this.renderObjects.has(string)) {
                UI.printError(UI.Module.API, "Unable to declare options \"%s\", name is already in use", string);
                this.parameterList.clear(true);
                return;
            }
            this.renderObjects.put(string, new Options());
        }
        assert (this.lookupOptions(string) != null);
        this.update(string);
    }

    private final boolean isIncremental(String string) {
        return string == null || string.equals("incremental");
    }

    public final Geometry lookupGeometry(String string) {
        return this.renderObjects.lookupGeometry(string);
    }

    private final Instance lookupInstance(String string) {
        return this.renderObjects.lookupInstance(string);
    }

    private final Camera lookupCamera(String string) {
        return this.renderObjects.lookupCamera(string);
    }

    private final Options lookupOptions(String string) {
        return this.renderObjects.lookupOptions(string);
    }

    public final Shader lookupShader(String string) {
        return this.renderObjects.lookupShader(string);
    }

    public final Modifier lookupModifier(String string) {
        return this.renderObjects.lookupModifier(string);
    }

    private final LightSource lookupLight(String string) {
        return this.renderObjects.lookupLight(string);
    }

    public final void render(String string, Display display) {
        Object object;
        Object object2;
        this.renderObjects.updateScene(this.scene);
        Options options = this.lookupOptions(string);
        if (options == null) {
            options = new Options();
        }
        this.scene.setCamera(this.lookupCamera(options.getString("camera", null)));
        String string2 = options.getString("override.shader", "none");
        boolean bl = options.getBoolean("override.photons", false);
        if (string2.equals("none")) {
            this.scene.setShaderOverride(null, false);
        } else {
            object2 = this.lookupShader(string2);
            if (object2 == null) {
                UI.printWarning(UI.Module.API, "Unable to find shader \"%s\" for override, disabling", string2);
            }
            this.scene.setShaderOverride((Shader)object2, bl);
        }
        object2 = options.getString("baking.instance", null);
        if (object2 != null) {
            object = this.lookupInstance((String)object2);
            if (object == null) {
                UI.printError(UI.Module.API, "Unable to bake instance \"%s\" - not found", object2);
                return;
            }
            this.scene.setBakingInstance((Instance)object);
        } else {
            this.scene.setBakingInstance(null);
        }
        object = PluginRegistry.imageSamplerPlugins.createObject(options.getString("sampler", "bucket"));
        this.scene.render(options, (ImageSampler)object, display);
    }

    public final boolean include(String string) {
        if (string == null) {
            return false;
        }
        String string2 = FileUtils.getExtension(string = this.includeSearchPath.resolvePath(string));
        SceneParser sceneParser = PluginRegistry.parserPlugins.createObject(string2);
        if (sceneParser == null) {
            UI.printError(UI.Module.API, "Unable to find a suitable parser for: \"%s\" (extension: %s)", string, string2);
            return false;
        }
        String string3 = new File(string).getAbsoluteFile().getParentFile().getAbsolutePath();
        this.includeSearchPath.addSearchPath(string3);
        this.textureSearchPath.addSearchPath(string3);
        return sceneParser.parse(string, this);
    }

    public final BoundingBox getBounds() {
        return this.scene.getBounds();
    }

    public void build() {
    }

    public static SunflowAPI create(String string, int n) {
        throw new UnsupportedOperationException("Removed parser support  from SunFlow");
    }

    public static boolean translate(String string, String string2) {
        throw new UnsupportedOperationException("Removed parser support from SunFlow");
    }

    public static SunflowAPI compile(String string) {
        throw new UnsupportedOperationException("Removed parser support from SunFlow");
    }

    public int currentFrame() {
        return this.currentFrame;
    }

    public void currentFrame(int n) {
        this.currentFrame = n;
    }

    public TextureCache getTextureCache() {
        return this.textureCache;
    }
}

