/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.behaviors.vp.ViewPlatformBehavior;
import com.sun.j3d.utils.universe.MultiTransformGroup;
import com.sun.j3d.utils.universe.PlatformGeometry;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewerAvatar;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.vecmath.Vector3d;

public class ViewingPlatform
extends BranchGroup {
    protected ViewPlatform viewPlatform;
    protected MultiTransformGroup mtg;
    protected BranchGroup platformGeometryRoot;
    protected BranchGroup avatarRoot;
    protected PlatformGeometry platformGeometry = null;
    protected Hashtable viewerList = new Hashtable();
    protected BranchGroup behaviors;
    protected SimpleUniverse universe;

    public ViewingPlatform() {
        this(1);
    }

    public ViewingPlatform(int n) {
        this.setCapability(13);
        this.setCapability(14);
        this.setCapability(17);
        if (n < 1) {
            n = 1;
        }
        this.mtg = new MultiTransformGroup(n);
        TransformGroup transformGroup = this.mtg.getTransformGroup(0);
        this.addChild((Node)transformGroup);
        transformGroup = this.mtg.getTransformGroup(n - 1);
        this.viewPlatform = new ViewPlatform();
        this.viewPlatform.setCapability(12);
        this.viewPlatform.setCapability(13);
        transformGroup.addChild((Node)this.viewPlatform);
        transformGroup.setCapability(17);
        transformGroup.setCapability(18);
        this.avatarRoot = new BranchGroup();
        this.avatarRoot.setCapability(12);
        this.avatarRoot.setCapability(13);
        this.avatarRoot.setCapability(14);
        transformGroup.addChild((Node)this.avatarRoot);
        this.platformGeometryRoot = new BranchGroup();
        this.platformGeometryRoot.setCapability(12);
        this.platformGeometryRoot.setCapability(13);
        this.platformGeometryRoot.setCapability(14);
        transformGroup.addChild((Node)this.platformGeometryRoot);
    }

    public void setViewPlatform(ViewPlatform viewPlatform) {
        TransformGroup transformGroup = this.getViewPlatformTransform();
        transformGroup.removeChild((Node)this.viewPlatform);
        transformGroup.addChild((Node)viewPlatform);
        this.viewPlatform = viewPlatform;
        Enumeration enumeration = this.viewerList.keys();
        while (enumeration.hasMoreElements()) {
            ((Viewer)enumeration.nextElement()).setViewingPlatform(this);
        }
    }

    public ViewPlatform getViewPlatform() {
        return this.viewPlatform;
    }

    public void setPlatformGeometry(PlatformGeometry platformGeometry) {
        if (this.platformGeometry == platformGeometry) {
            return;
        }
        if (platformGeometry == null) {
            if (this.platformGeometryRoot.numChildren() != 0) {
                this.platformGeometryRoot.removeChild(0);
            }
        } else if (this.platformGeometryRoot.numChildren() != 0) {
            this.platformGeometryRoot.setChild((Node)platformGeometry, 0);
        } else {
            this.platformGeometryRoot.addChild((Node)platformGeometry);
        }
        this.platformGeometry = platformGeometry;
    }

    public PlatformGeometry getPlatformGeometry() {
        return this.platformGeometry;
    }

    public MultiTransformGroup getMultiTransformGroup() {
        return this.mtg;
    }

    public TransformGroup getViewPlatformTransform() {
        return this.mtg.getTransformGroup(this.mtg.getNumTransforms() - 1);
    }

    public void setNominalViewingTransform() {
        if (this.viewPlatform.getViewAttachPolicy() == 0) {
            Object object;
            double d;
            if (this.viewerList.size() == 0) {
                d = 0.7853981633974483;
            } else {
                if (this.viewerList.size() > 1) {
                    throw new RuntimeException(J3dUtilsI18N.getString("ViewingPlatform0"));
                }
                object = (Viewer)this.viewerList.keys().nextElement();
                View view = ((Viewer)object).getView();
                d = view.getFieldOfView();
            }
            object = new Transform3D();
            double d2 = 1.0 / Math.tan(d / 2.0);
            object.set(new Vector3d(0.0, 0.0, d2));
            this.getViewPlatformTransform().setTransform((Transform3D)object);
        }
    }

    private int findAvatarChild(ViewerAvatar viewerAvatar) {
        for (int i = 0; i < this.avatarRoot.numChildren(); ++i) {
            if ((ViewerAvatar)this.avatarRoot.getChild(i) != viewerAvatar) continue;
            return i;
        }
        System.err.println("ViewingPlatform.findAvatarChild:Child not found.");
        return -1;
    }

    void setAvatar(Viewer viewer, ViewerAvatar viewerAvatar) {
        Object v = this.viewerList.get(viewer);
        int n = -1;
        if (v != this.avatarRoot) {
            n = this.findAvatarChild((ViewerAvatar)((Object)v));
        }
        if (viewerAvatar == null) {
            if (n != -1) {
                this.avatarRoot.removeChild(n);
                this.viewerList.put(viewer, this.avatarRoot);
            }
        } else {
            if (n != -1) {
                this.avatarRoot.setChild((Node)viewerAvatar, n);
            } else {
                this.avatarRoot.addChild((Node)viewerAvatar);
            }
            this.viewerList.put(viewer, viewerAvatar);
        }
    }

    void addViewer(Viewer viewer) {
        this.viewerList.put(viewer, this.avatarRoot);
    }

    void removeViewer(Viewer viewer) {
        this.viewerList.remove(viewer);
    }

    void addViewPlatformBehavior(ViewPlatformBehavior viewPlatformBehavior) {
        viewPlatformBehavior.setViewingPlatform(this);
        if (this.behaviors == null) {
            this.behaviors = new BranchGroup();
            this.behaviors.setCapability(17);
            this.behaviors.setCapability(12);
        } else {
            this.behaviors.detach();
        }
        this.behaviors.addChild((Node)viewPlatformBehavior);
        this.addChild((Node)this.behaviors);
    }

    public void setViewPlatformBehavior(ViewPlatformBehavior viewPlatformBehavior) {
        if (this.behaviors != null) {
            this.removeViewPlatformBehavior((ViewPlatformBehavior)this.behaviors.getChild(0));
        }
        if (viewPlatformBehavior != null) {
            this.addViewPlatformBehavior(viewPlatformBehavior);
        }
    }

    void removeViewPlatformBehavior(ViewPlatformBehavior viewPlatformBehavior) {
        if (this.behaviors != null) {
            this.behaviors.detach();
            for (int i = 0; i < this.behaviors.numChildren(); ++i) {
                if (this.behaviors.getChild(i) != viewPlatformBehavior) continue;
                viewPlatformBehavior.setViewingPlatform(null);
                this.behaviors.removeChild(i);
                break;
            }
            if (this.behaviors.numChildren() == 0) {
                this.behaviors = null;
            } else {
                this.addChild((Node)this.behaviors);
            }
        }
    }

    int getViewPlatformBehaviorCount() {
        return this.behaviors.numChildren();
    }

    ViewPlatformBehavior getViewPlatformBehavior(int n) {
        return (ViewPlatformBehavior)this.behaviors.getChild(n);
    }

    public ViewPlatformBehavior getViewPlatformBehavior() {
        if (this.behaviors == null) {
            return null;
        }
        return this.getViewPlatformBehavior(0);
    }

    public Viewer[] getViewers() {
        if (this.viewerList.size() == 0) {
            return null;
        }
        return this.viewerList.keySet().toArray(new Viewer[0]);
    }

    public SimpleUniverse getUniverse() {
        return this.universe;
    }

    public void setUniverse(SimpleUniverse simpleUniverse) {
        this.universe = simpleUniverse;
    }
}

