/**
 * SECTION:location-details
 * @short_description: A location. Typically latitude and longitude will be based on WGS84. However, folks often has no way of verifying that and just has to assume it&apos;s true.
 * @latitude: The latitude.
 * @longitude: The longitude.
 *
 * Since: 0.9.2
 */
/**
 * FOLKS_TYPE_LOCATION:
 * 
 * The type for <link linkend="FolksLocation"><type>FolksLocation</type></link>.
 */
/**
 * folks_location_equal:
 * @self: the <link linkend="FolksLocation"><type>FolksLocation</type></link> instance
 * @other: (in): &nbsp;.  <para>the instance to compare against </para>
 * 
 * Compare this location to another by geographical position.
 * 
 * Returns: <para>true iff the coordinates are exactly the same </para>
 *
 * Since: 0.9.2
 */
/**
 * folks_location_equal_coordinates:
 * @self: the <link linkend="FolksLocation"><type>FolksLocation</type></link> instance
 * @latitude: (in): &nbsp;.  <para>latitude of the other position </para>
 * @longitude: (in): &nbsp;.  <para>longitude of the other position </para>
 * 
 * Compare the geographical position of this location against another position.
 * 
 * Returns: <para>true iff the coordinates are exactly the same </para>
 *
 * Since: 0.9.2
 */
/**
 * folks_location_new:
 * @latitude: (in): &nbsp;.  <para>latitude of the new instance </para>
 * @longitude: (in): &nbsp;.  <para>longitude of the new instance </para>
 * 
 * Constructs a new instance with the given coordinates.
 *
 * Since: 0.9.2
 */
/**
 * FolksLocation:
 * @latitude: The latitude.
 * @longitude: The longitude.
 * 
 * A location. Typically latitude and longitude will be based on WGS84. However, folks often has no way of verifying that and just has to assume it&apos;s true.
 *
 * Since: 0.9.2
 */
/**
 * FolksLocationClass:
 * @parent_class: the parent class structure
 * 
 * The class structure for <link linkend="FOLKS-TYPE-LOCATION:CAPS"><literal>FOLKS_TYPE_LOCATION</literal></link>. All the fields in this structure are private and should never be accessed directly.
 */
/**
 * folks_location_details_change_location:
 * @self: the <link linkend="FolksLocationDetails"><type>FolksLocationDetails</type></link> instance
 * @location: (in) (allow-none): &nbsp;.  <para>the contact&apos;s location, null to remove the information </para>
 * @_callback_: (scope async): callback to call when the request is satisfied
 * @_user_data_: (closure): the data to pass to @_callback_ function
 * 
 * Set or remove the contact&apos;s currently advertised location.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksLocationDetails--location"><type>"location"</type></link> directly, as this method gives error notification and will only return once the location has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the location failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-location-details-change-location-finish"><function>folks_location_details_change_location_finish()</function></link>
 *
 * Since: 0.9.2
 */
/**
 * folks_location_details_change_location_finish:
 * @self: the <link linkend="FolksLocationDetails"><type>FolksLocationDetails</type></link> instance
 * @_res_: a <link linkend="GAsyncResult"><type>GAsyncResult</type></link>
 * @error: (error-domains FolksPropertyError): location to store the error occurring, or %NULL to ignore
 * 
 * Set or remove the contact&apos;s currently advertised location.
 * 
 * <para>It&apos;s preferred to call this rather than setting <link linkend="FolksLocationDetails--location"><type>"location"</type></link> directly, as this method gives error notification and will only return once the location has been written to the relevant backing store (or the operation&apos;s failed).</para>
 * <para><link linkend="FolksPropertyError"><type>FolksPropertyError</type></link> will be returned in @error <para>if setting the location failed </para></para>
 * 
 * <emphasis>See also</emphasis>: <link linkend="folks-location-details-change-location"><function>folks_location_details_change_location()</function></link>
 *
 * Since: 0.9.2
 */
/**
 * FolksLocationDetails:location:
 * 
 * The current location of the contact. Null if the contact’s current location isn’t known, or they’re keeping it private.
 *
 * Since: 0.9.2
 */
/**
 * folks_location_details_get_location:
 * @self: the <link linkend="FolksLocationDetails"><type>FolksLocationDetails</type></link> instance to query
 * 
 * Get and return the current value of the <link linkend="FolksLocationDetails--location"><type>"location"</type></link> property.
 * 
 * The current location of the contact. Null if the contact’s current location isn’t known, or they’re keeping it private.
 * 
 * Returns: the value of the <link linkend="FolksLocationDetails--location"><type>"location"</type></link> property
 *
 * Since: 0.9.2
 */
/**
 * folks_location_details_set_location:
 * @self: the <link linkend="FolksLocationDetails"><type>FolksLocationDetails</type></link> instance to modify
 * @value: the new value of the <link linkend="FolksLocationDetails--location"><type>"location"</type></link> property
 * 
 * Set the value of the <link linkend="FolksLocationDetails--location"><type>"location"</type></link> property to @value.
 * 
 * The current location of the contact. Null if the contact’s current location isn’t known, or they’re keeping it private.
 *
 * Since: 0.9.2
 */
/**
 * FolksLocationDetails:
 * 
 * Location of a contact. folks tries to keep track of the current location and thus favors live data (say, as advertised by a chat service) over static data (from an address book). Static addresses, such as a contact&apos;s home or work address, should be presented using the <link linkend="FolksPostalAddressDetails"><type>FolksPostalAddressDetails</type></link> interface. <link linkend="FolksLocationDetails"><type>FolksLocationDetails</type></link> is purely for exposing the contact&apos;s current or recent location.
 * 
 * <para>Backends are expected to report only relevant changes in a persona&apos;s location. For storage backends like EDS, all changes must have been triggered by a person (e.g. editing the contact) and thus all are relevant.</para><para>A backend pulling in live data, for example from a GPS, is expected to filter the data to minimize noise.</para><para>folks itself will then apply all changes coming from backends without further filtering.</para>
 *
 * Since: 0.9.2
 */
/**
 * FolksLocationDetailsIface:
 * @change_location: virtual method called by <link linkend="folks-location-details-change-location"><function>folks_location_details_change_location()</function></link>
 * @change_location_finish: asynchronous finish function for <structfield>change_location</structfield>, called by <link linkend="folks-location-details-change-location"><function>folks_location_details_change_location()</function></link>
 * @get_location: getter method for the abstract property <link linkend="FolksLocationDetails--location"><type>"location"</type></link>
 * @set_location: setter method for the abstract property <link linkend="FolksLocationDetails--location"><type>"location"</type></link>
 * @parent_iface: the parent interface structure
 * 
 * Interface for creating <link linkend="FolksLocationDetails"><type>FolksLocationDetails</type></link> implementations.
 */
